package com.testing;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;

import javax.annotation.PostConstruct;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.ejb.Remove;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.xml.XMLConstants;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;

import org.jboss.ejb3.annotation.SerializedConcurrentAccess;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import bsh.Interpreter;
import bsh.InterpreterError;
//imports from core Java API
//Changed by Swapnil Shirke on 18-Aug-2010 [ SY90SUN004 ] To support multiple database connection through single JBoss.
//imports from XML Parsers and Transformers
//imports required for calling web service
//Changed by Monif on 6/27/2008 [To remove OraclePreparedStatement ].
//import oracle.jdbc.driver.OraclePreparedStatement;
//imports from within the Application
import ibase.bean.EventLogInfoBean;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.RAHandler;
import ibase.utility.RAHandlerTO;
import ibase.utility.UserInfoBean;
import ibase.webitm.servlet.E12InvokeWorkflowServlet;
import ibase.webitm.utility.DWFactory;
import ibase.webitm.utility.DWObject;
import ibase.webitm.utility.I18NLabel;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.JMSSender;
import ibase.webitm.utility.ReCalculateTax;
import ibase.webitm.utility.TaxCalculation;
import ibase.wrkflw.WorkflowProcessInstanceMonitorEJB;

//Changed by Prasad on 10/12/18 [for wildfly clustering, as getting not serialise while deploying in clustering]
//Added by Pankaj T on 12-10-17 [Added parameter passivationCapable=false As per KB Sir for infnispan issue]
@javax.ejb.Stateful(passivationCapable=true)
@SerializedConcurrentAccess
public class MasterStatefulEJB implements MasterStatefulRemote, MasterStatefulLocal //implements SessionBean 
{
	protected transient InitialContext initialContext = null;
	//Aggregated poperties
	/*private MasterDataStateful masterDataStateful = null;
	private EventManager eventManager = null;
	private DBAccessRemote dbAccess = null;*/
	private MasterDataStatefulEJB masterDataStateful = null;
	private EventManagerEJB eventManager = null;
	// Added by Raju K on 02-05-14 for Event log and Transaction lock as per danish sir START--
	//Added By Mahesh Patidar on 01/AUG/13[WI3DSUN001|to log the user event activity log]
	private ibase.ejb.UserEventLogEJB userEventLogEJB = null;
	private DBAccessEJB dbAccess = null;
	
	private String user_lang = "en"; //$NON-NLS-1$
	private String user_country = "US"; //$NON-NLS-1$
	
	protected ibase.utility.UserInfoBean userInfo = null;//Encapsulates information pertaining to the logged in user.

	//Attributes pertaining to the current transaction.
	protected String objName;//Name of the transaction.
		
	//Static att. of the current transaction as read from the DB.
	protected String msgNo=null;//Added by Shrutika on 23-02-17	
	protected String msgString=null;//Added by Shrutika on 23-02-17
	protected String refSer = null;//Ref series corr. to the transaction type.
	protected String tranType = "S";//Transaction type(S :System defined/U :user defined). //$NON-NLS-1$
	protected String systemDefObjName = null;//For user defined objects the corr. system defined transaction type.
	protected String keyFlag = "M";//Transaction key generation status(A :Automatic generation/M :Manual generation). //$NON-NLS-1$
	protected String confirmCol = null;//
	protected String confirmVal = null;//
	//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - start
	protected String cancelCol = null;
	protected String cancelVal = null;
	protected String closeCol = null;
	protected String closeVal = null;
	protected boolean isClose = false;
	protected boolean isCancel = false;
	protected boolean isConfirm = false;
	protected boolean isNonEditable = false;
	//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - end
	protected String tranDateCol = null;//
	protected boolean isAutoConfirm = false;//
	protected boolean isHeaderRepeat = false;//
	
//	Changed by Dhruv on 06/11/2007 to support add detail repeat flag.
	protected boolean isDetailRepeat = false;
	protected String mainTableName = null;//
	protected String signStatus = null;//Sign object evaluation stage(D :Evaluation on draft saving(Save to draft event)/Evaluation on transaction saving(Save event)).
	protected ArrayList taxList = null;//List of context/forms number on which tax calculations to be done
	
	//protected String rateCol = "rate__stduom";
	//protected String qtyCol = "quantity__stduom";
	protected String rateCol = null;
	protected String qtyCol = null;
	//Added By Pankaj T. on 23-11-18 for if no change in form then avoid detail form validation when click on Finish from feed view - start
	private String isFormChange = "true";

	public String getIsFormChange() {
		return isFormChange;
	}

	public void setIsFormChange(String isFormChange) {
		this.isFormChange = isFormChange;
	}
	//Added By Pankaj T. on 23-11-18 for if no change in form then avoid detail form validation when click on Finish from feed view - end

	protected int editTemplate = 0;//Edit Template(0 : default behaviour of displaying the header as well as detail, 1: Brow window is editable for obj context 2 onwards).
	
	//Changed by Danish on 11/01/2007
	protected boolean isWrkflwInitiated = false;
	protected boolean isWrkflwToBeInitiated = false;
	protected String wrkflwInit = null;
	protected String wrkflwProcInstId = null;//to Store process Instance Id

	//Danish Thursday, May 04, 2006 
	//0- no workflow, 1- old signing module, 2- workflow with saving in ITM, 3- workflow without saving
	protected String wrkflwOpt = "0"; //$NON-NLS-1$
	//Changed by Danish on 13/07/2006 to incorporate editability of transaction based on editopt and audit trail 
	//Editable Options
	//0- always editable, 1- never editable, 2- editable only if not in workflow and not confirmed, 3- editable only if not confirmed.
	protected String editOpt = "0"; //$NON-NLS-1$
	//Changed by Manish to add new criteria for editing, i.e; in addition to being not confirmed, only if condn. is satisfied shall the transaction be editable.Start
	protected String editExpr = null;
	//Changed by Manish to add new criteria for editing, i.e; in addition to being not confirmed, only if condn. is satisfied shall the transaction be editable.End
	//Audit Trail Options.
	//0- no audit trail, 1- only for unconfirmed transactions, 2- always audit trail.
	protected String auditTrailOpt = "1"; //$NON-NLS-1$
	protected boolean isAuditTrailOn = true;//Made it by default ON

	protected ArrayList contextTitlesList = null;//List of context/form names.
	protected int noOfForms = -1;//No. of forms in the current transaction.
	protected ArrayList crossUpdateExprList = null;//List of expressions for cross form updations(for each form).
	protected ArrayList exprVarInfoList = null;//List of variable information pertaining to each expression for each context/form.
	protected ArrayList targetVarInfoList = null;//List of variable information pertaining to each target field(to which the evaluated value is to be applied) for each context/form.

	//Changed by Taru on 1/11/2008 [ to get scan related info ] start
	protected ArrayList scanFlagList = null;
	protected ArrayList scanMetadataList = null;
	protected ArrayList autoAcceptScanList = null;
	//Changed by Taru on 1/11/2008 [ to get scan related info ] End
	
	//Changed By Pragyan 19/08/08 . [To get the Property Info column value] [SY89BAS005]
	protected ArrayList calPropertyInfoList = null;

	//Changed by Monif on 12/3/2008. [Weighing functionality] [WI89BAS012].
	protected ArrayList weighAfterSaveList = null;
	protected ArrayList weighColumnOnSaveList = null;
	protected ArrayList scanDelimiterList = null;
	//Changed by Monif on 12/3/2008. [Weighing functionality] [WI89BAS012].

	//Static att. of the current transaction as read from the MetaData file(xml file stored in Jboss2.4.2\bin\metadata\).
	protected String argFieldNames = null;//Name of the argument fields.
	protected String argFieldTypes = null;//Data type of the argument fields.
	protected String accFilterQuery = null;//
	protected String headerPKFieldNames = null;//Name of the primary keys of the transaction(only header form).
	//Added By Pankaj T. on 17-12-18 [ for avoiding override default pkField value in copy transaction ]
	private ArrayList<String> primaryKeyList = new ArrayList<>();
	//Attributes holding the state of the transaction as created by the end user(These should synchronize exactly with the client side status).
	protected String objContext = "1";//Current context/form in focus on the client side(1/2/3/4/... :Sequential number as many as the no. of forms belonging to thetrans.). //$NON-NLS-1$
	protected String pageContext;//Current format mode of the current form of the transaction(1 :brow mode(generally for vieing only)/2 :detail mode).
	protected String editFlag;//Current edit mode in which the transaction exists(A :add mode/V :view mode/E :edit mode/D :delete mode).
	protected String localEditFlag;//Current edit mode in which the transaction exists(A :add mode/V :view mode/E :edit mode/D :delete mode).
	
	//Added By Suraj for infinispan implementation
	/*InfinispanLocal infinispanLocalObj = null;
	Hashtable jndiProperties = null;
	InitialContext ctxInfi = null;*/
	
	//Added By Pankaj T on 12/09/17 for creating infinispan object on class level - Start
	static InfinispanLocal infinispanLocalObj = null;
	static Hashtable jndiProperties = null;
	static InitialContext ctx = null;
	
	static
	{
		try 
		{
			//Added Pankaj T on 18-10-17 [To use infinispan cache depends on CACHE_OPT define in ibase.xml 0 = NO Cache, 1 = Internal Cache, 2 = External Cache]
			if( CommonConstants.CACHE_OPT != 0 )
			{
				jndiProperties = new Hashtable();
				jndiProperties.put(Context.URL_PKG_PREFIXES,"org.jboss.ejb.client.naming");	   
				ctx=new InitialContext(jndiProperties);
				infinispanLocalObj = ((InfinispanLocal)ctx.lookup("ibase/InfinispanEJB/local"));
				BaseLogger.log("1", null,null,"MasterStatefulEJB infinispanLocalObj created.....");
			}
		}
		catch (Exception e) 
		{
			BaseLogger.log("0", null,null,"Exception in MasterStatefulEJB static block:["+e.getMessage()+"]");
			e.printStackTrace();
		}
	}
	//Added By Pankaj T on 12/09/17 for creating infinispan object on class level - End
	
	//Added by Shrutika on 23-02-17
	public String getMsgNo() {
		return msgNo;
	}

	public void setMsgNo(String msgNo) {
		this.msgNo = msgNo;
	}	

	public String getMsgString() {
		return msgString;
	}

	public void setMsgString(String msgString) {
		this.msgString = msgString;
	}
	//Added by Shrutika on 23-02-17
	
	//Added by Pankaj on 01-03-17[for upload utility set run mode] - Start
	private String runMode = "I";

	public String getRunMode() {
		return runMode;
	}

	public void setRunMode(String runMode) {
		this.runMode = runMode;
	}
	//Added by Pankaj on 01-03-17[for upload utility set run mode] - End
	
	//Added by Sandeep S. on 2-11-16 [[S16EBAS019]To implement multiple layouts in Editor]Start
	/**
	 * @return the editFlag
	 */
	public String getEditFlag() {
		return editFlag;
	}

	/**
	 * @param editFlag the editFlag to set
	 */
	public void setEditFlag(String editFlag) {
		this.editFlag = editFlag;
	}

	/**
	 * @return the localEditFlag
	 */
	public String getLocalEditFlag() {
		return localEditFlag;
	}

	/**
	 * @param localEditFlag the localEditFlag to set
	 */
	public void setLocalEditFlag(String localEditFlag) {
		this.localEditFlag = localEditFlag;
	}
	//Added by Sandeep S. on 2-11-16 [[S16EBAS019]To implement multiple layouts in Editor] End
	protected String viewDomId = "-1"; //$NON-NLS-1$
	protected String headerDomId = "1"; //$NON-NLS-1$
	protected String detailDomId = "-1"; //$NON-NLS-1$
	protected String taxDomId = "-1"; //$NON-NLS-1$

	protected String saveLevel = "";//Level of saving(0 :Temporary saving only in the memory in the dom/1 :Persistent saving in the DB). //$NON-NLS-1$

	protected String focussedColumn = "";//Current element in the current form in focus. //$NON-NLS-1$
	protected String currentEventContext = "";// //$NON-NLS-1$
	protected String overWriteDefault = "";// //$NON-NLS-1$
	transient HashMap headerInfoMap;//Satus of the transaction as on the client side.
	protected String recordID = "";//Current focussed record no.(count as per the sequence of selected records from the DB and then the sequence of addition by the client). //$NON-NLS-1$
	
	protected ArrayList blankDomList = null;//Identical empty doms saved for additional records added to specific forms(XML Strings representing the data structure of thecurrent form,stored one each for each form, created only if requested atleast once).
	protected ArrayList maxDomIDList = null;//Record count(only visible records as seen by client) for each form.
	protected ArrayList maxLineNoList = null;//Maximum Line no.(if applicable) for each form.
	
	protected String argFieldValues;//Values of the formal arguments(in case of multiple values separated by "~").
	protected String advQuery;//Where clause as per user selection of formal arguments and added advanced filter
	protected String headerPKFieldValues = null;//Values of the primary keys of the transaction(only header form, in case of multiple values separated by "~").
	public String getHeaderPKFieldValues() {
		return headerPKFieldValues;
	}

	public void setHeaderPKFieldValues(String headerPKFieldValues) {
		this.headerPKFieldValues = headerPKFieldValues;
	}

	protected String headerPKFieldDataTypes = null;
	protected String filterString = ""; //$NON-NLS-1$
	
	//protected transient Document viewDom = null;//XML Document representation of the same as above.
	//protected String viewDomString = null;//XML string representation of the data structure of the entire transactions(in view mode) selected on client request.
	
	protected transient Document headerListDom = null;//XML Document representation of the same as above.
	protected String headerListXMLStr = null;//XML Document representation of the same as above.

	protected String actionXmlStr = null;//To store actions.
	
	protected String detailDomString = null;//XML string representation of the data structure of the currently selected record(in detail mode).
	//Changed by Danish on 13/07/2006 to incorporate audit trail
	protected String auditDataXmlBefore = null;

	protected transient Document detailDom = null;//XML Document representation of the same as above.
	private transient Node currRecordNode = null;//Reference of the node representing the selected record of the current transaction.
	
	boolean isRecordValidated = true;
	boolean isCurrentDetailValidated = true;
	transient Node currTaxNode = null;

	final String COLUMN_SEPARATOR = ":"; //$NON-NLS-1$
	final String XTRA_PARAMS_SEPARATOR = "~~"; //$NON-NLS-1$
	
	private int printSeq = 0;

	protected TreeMap changedDataMap = null;

	//Changed by Danish on 13/07/2006 to incorporate audit trail
	protected HashMap auditDataMap = null;

	protected boolean isTaxChanged = false;
		
	//Changed by Shravan on 01/11/2006 added a temp variable to handle itemchange from external requests to store the current record index.
	protected int recCtr = -1;

	//Changed by Danish on 03/01/2007 to encorporate itemChange on requestedFields
	protected String requestParamStr = null;
	
	//Changed by Danish on 06/03/2007 added to support validation logic whle copying entire transactions.
	protected boolean isCopyingRec = false;
	
	//Added By Pankaj T. on 16-06-22 to validate & calculate tax of all form records on saving if not validated 
	protected boolean validateAllFormData = false;

	//Changed by Prasad on 10/12/18 [for wildfly clustering]
	//Changed by Dhruv on 13/07/07.
	protected transient Connection dbSaveConn_doNotUse = null;
	protected boolean isPartOfExtTrans = false;

	//Changed by Danish on 04/09/2008 [ to include exception with Data in Case of itm_default ]
	String exceptnMsg = null;
	
	//Changed by Monif on 18/03/09.
	private boolean transactionPropertySet = false;
 	private HashMap defaultXmlDomForDetail = null;

	//Changed by Danish on 3/23/2009 [ created Map to store as per objName_formNo ]
	private HashMap maxDomIdMap = null;
	//Added by shrutika on 26-09-18 [Start] for issue occur when add detail and copy paste detail and again add detail then last copy data open not blank dom open.
	public HashMap getMaxDomIdMap() {
		return maxDomIdMap;
	}
	public void setMaxDomIdMap(HashMap maxDomIdMap) {
		this.maxDomIdMap = maxDomIdMap;
	}
	//Added by shrutika on 26-09-18 [End] for issue occur when add detail and copy paste detail and again add detail then last copy data open not blank dom open.
	//Changed by Monif on 22/04/09. [Weighing functionality] [WI89BAS012].
	protected ArrayList extMetadataList = null;
	protected ArrayList autoAcceptWeighdataList = null;

	//Changed by Monif on 02/07/09[To Save data on Add action if SaveFlag in Transetup is A].
	protected String saveFlag = null;
	//Changed by Dayanand on 25/08/09[ WI89BAS029 || set coreModelId  ]
	protected int coreModelId = -1;
	// Added by Amit D on 19 Dec 13.
	protected boolean isTransactionEditfromWF = false;
	
	//Added by Prasad on 02/11/16 [to search node from dbId]
	protected String currDbID = "";
	
	// Added By Arvind on 03-MAR-2014
	public boolean isDataUpload = false;
	
	private HashMap<String, String> objFormInfoMap = null;
	//Added by Prasad on 17/03/18 [formName implementation in transaction editor]
	private ArrayList objFormsDetailList = null;
	private String OBJ_INFO_SEPARATOR = ";";
	
	public boolean isDataUpload() {
		return isDataUpload;
	}

	public void setDataUpload(boolean isDataUpload) {
		this.isDataUpload = isDataUpload;
	}
	
	//Added by Prasad on 05/05/16 [Editor option added for Property Editor] START
	private String editor = "";
	
	/**
	 * @return the editor
	 */
	public String getEditor() 
	{
		return editor;
	}
	/**
	 * @param editor the editor to set
	 */
	public void setEditor(String editor) 
	{
		this.editor = editor;
	}
	//Added by Prasad on 05/05/16 [Editor option added for Property Editor] END
	//Added BY Suraj on 18-11-2016 [To set plan date for GWT Editor in Calendar]Start
	private String plan_Date = "";
	private String Cal_Comp = "";
	/**
	 * @return the cal_Comp
	 */
	public String getCalComp() 
	{
		return Cal_Comp;
	}
	/**
	 * @param cal_Comp the cal_Comp to set
	 */
	public void setCalComp(String cal_Comp) 
	{
		Cal_Comp = cal_Comp;
	}
	public String getPlanDate() 
	{
		return plan_Date;
	}
	/**
	 * @param editor the editor to set
	 */
	public void setPlanDate(String plan_Date) 
	{
		this.plan_Date = plan_Date;
	}
	//Added BY Suraj on 18-11-2016 [To set plan date for GWT Editor in Calendar]End
	//Added by Prasad on 02/06/16 [get form wise primary fields] START
	private HashMap<String, String> formWisePkFldNameMap = new HashMap<String, String>();
	/**
	 * @return the formWisePkFldNameMap
	 */
	public HashMap<String, String> getFormWisePkFldNameMap() 
	{
		return formWisePkFldNameMap;
	}
	/**
	 * @param formWisePkFldNameMap the formWisePkFldNameMap to set
	 */
	public void setFormWisePkFldNameMap(HashMap<String, String> formWisePkFldNameMap) 
	{
		this.formWisePkFldNameMap = formWisePkFldNameMap;
	}
	//Added by Prasad on 02/06/16 [get form wise primary fields] END
	//Added by Prasad on 26/12/16 [to set fileUpload flag] START
	public boolean isFileUpload = false;
	
	public boolean isFileUpload() 
	{
		return isFileUpload;
	}

	public void setFileUpload(boolean isDataUpload) 
	{
		this.isFileUpload = isDataUpload;
	}
	//Added by Prasad on 26/12/16 [to set fileUpload flag] END

	//Added by Pankaj T on 16/03/17 [to set transCopy flag] Start
	public boolean isTransCopy = false;
	
	public boolean isTransCopy()
	{
		return isTransCopy;
	}
	
	public void setTransCopy(boolean transCopy)
	{
		this.isTransCopy = transCopy;
	}
	//Added by Pankaj T on 16/03/17 [to set transCopy flag] End
	
	//Added By Pankaj t on 16-06-17 [F16KSUN001][to set retainPkValue flag true for primary key value is set from uploaded xml when key flag "A"] - Start
	private boolean isRetainPkValue = false;
	
	public boolean isRetainPkValue() {
		return isRetainPkValue;
	}

	public void setRetainPkValue(boolean isRetainPkValue) {
		this.isRetainPkValue = isRetainPkValue;
	}
	//Added By Pankaj t on 16-06-17 [F16KSUN001][to set retainPkValue flag true for primary key value is set from uploaded xml when key flag "A"] - End
	
	//Added By Ravindra C on 22-01-2021 [for auto confirm transaction from upload] Start
	private boolean isDataUploadAutoConfirm = false;
	public boolean isDataUploadAutoConfirm()
	{
		return this.isDataUploadAutoConfirm;
	}

	public void setDataUploadAutoConfirm( boolean isDataUploadAutoConfirm )
	{
		this.isDataUploadAutoConfirm = isDataUploadAutoConfirm;
	}
	//Added By Ravindra C on 22-01-2021 [for auto confirm transaction from upload] End

	//Added by shrutika on 18-06-19 [Start] for perform tax calculation after copy paste records in detail.
	public String getObjContext() {
		return objContext;
	}
	public void setObjContext(String objContext) {
		this.objContext = objContext;
	}
	public String getDetailDomId() {
		return detailDomId;
	}
	public void setDetailDomId(String detailDomId) {
		this.detailDomId = detailDomId;
	}
	//Added by shrutika on 18-06-19 [End] for perform tax calculation after copy paste records in detail.
	
	//Added by Pankaj P on 25/05/2021 [set batchid details] START
	private String uploadBatchId = "";
	public String getUploadBatchId()
	{
		return this.uploadBatchId;
	}
	
	public void setUploadBatchId( String batchId )
	{
		this.uploadBatchId = batchId;
	}
	//Added by Pankaj P on 25/05/2021 [set batchid details] END

	@PostConstruct
	public void ejbCreate()
	{
		try
		{
			setInitialContext();//Changed by MOnif on 26/03/09[].
			/*MasterDataStatefulHome masterDataStatefulHome = (MasterDataStatefulHome)this.initialContext.lookup("MasterDataStateful");
			this.masterDataStateful = masterDataStatefulHome.create();
			EventManagerHome eventManagerHome = (EventManagerHome)this.initialContext.lookup("EventManager");
			this.eventManager = eventManagerHome.create();
			DBAccessHome dbAccessHome = (DBAccessHome)this.initialContext.lookup("DBAccess");
			this.dbAccess = dbAccessHome.create();*/
			//this.masterDataStateful = (MasterDataStatefulLocal)this.initialContext.lookup("ibase/MasterDataStatefulEJB/local"); //$NON-NLS-1$
			this.masterDataStateful = new MasterDataStatefulEJB();
			//this.eventManager = (EventManagerLocal)this.initialContext.lookup("ibase/EventManagerEJB/local"); //$NON-NLS-1$
			this.eventManager = new EventManagerEJB();
			// Added by Raju K on 02-05-14 for Event log and Transaction lock as per danish sir START--
//			Added By Mahesh Patidar on 01/AUG/13[WI3DSUN001|initialized userEventLogEJB variable value]
			// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [START]
			//userEventLogEJB = (UserEventLogEJBLocal) this.initialContext.lookup("ibase/UserEventLogEJB/local");
			userEventLogEJB = new ibase.ejb.UserEventLogEJB();
			// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [END]
			//this.dbAccess = (DBAccessLocal)this.initialContext.lookup("ibase/DBAccessEJB/local"); //$NON-NLS-1$
			this.dbAccess = new DBAccessEJB();
			//Changes done by Gaurav Singh on 13-JUL-2016 [ setIBASEHOME only when TOMCAT_HOME is null | Start ]
			//CommonConstants.setIBASEHOME();
			if(CommonConstants.TOMCAT_HOME == null || CommonConstants.TOMCAT_HOME.trim().length() == 0)
			{
				CommonConstants.setIBASEHOME();
			}
			//Changes done by Gaurav Singh on 13-JUL-2016 [ setIBASEHOME only when TOMCAT_HOME is null | End ]
			
			this.objFormInfoMap = null;
			
			//Changed by Dayanand on 25/08/09[ WI89BAS029 || Update instanceActivityLog ]
			instanceInterceptorLog( "ejbCreate" ); //$NON-NLS-1$
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :ejbCreate"); //$NON-NLS-1$
			e.printStackTrace();
		}
	}

	@Remove
	public void remove()
	{
		//Changed by Dayanand on 25/08/09[ WI89BAS029 || Update instanceActivityLog ]
		instanceInterceptorLog( "remove" ); //$NON-NLS-1$
		//Changed by Dayanand on 05/08/09[Removing Column Object while removing instance].Start
		/*
		this.masterDataStateful.remove();
		this.eventManager.remove();
		this.dbAccess.remove();
		File applnLog = new File(".." + File.separator + "applnlog");// + File.separator + "MasterStatefulStatusLog.log"
		if(applnLog.exists())
		{
			applnLog = new File(applnLog, "MasterStatefulStatusLog.log");
			if(applnLog.exists())
			{
				applnLog.delete();
			}
		}
		*/
		try
		{
			this.masterDataStateful.remove();
			this.eventManager.remove();
			this.dbAccess.remove();
			this.masterDataStateful = null;
			this.eventManager = null;
			this.userEventLogEJB = null;
			this.dbAccess = null;
			//Added By Mahesh Patidar on 10-SEP-13 [to clear this.maxDomIdMap map when remove the masterstateful Components]
			if(maxDomIdMap != null) // Added by AMit D on 4th Dec to avoid null pointer Exception.
			{
				this.maxDomIdMap.clear();
				this.maxDomIdMap = null;
			}
			//Ended By Mahesh Patidar on 10-SEP-13 [to clear this.maxDomIdMap map when remove the masterstateful Components]
			File applnLog = new File(".." + File.separator + "applnlog");// + File.separator + "MasterStatefulStatusLog.log" //$NON-NLS-1$ //$NON-NLS-2$
			if(applnLog.exists())
			{
				applnLog = new File(applnLog, "MasterStatefulStatusLog.log"); //$NON-NLS-1$
				if(applnLog.exists())
				{
					applnLog.delete();
				}
			}

			DWObject dwObj = null;
			if ( this.objName != null && this.objName.trim().length() > 0 )
			{
				dwObj = getDWObject(this.objName, 1);
			}
			//Added by Prasad on 09/04/18 [to check dwObj object is null or not] START
			if ( dwObj != null )
			{
				dwObj.remove();
			}
			//Added by Prasad on 09/04/18 [to check dwObj object is null or not] END
		}
		catch(Exception e)
		{
			e.printStackTrace();
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :remove :==>\n"+e); //$NON-NLS-1$
		}	
		//Changed by Dayanand on 05/08/09[Removing Column Object while removing instance].End
	}

	@PostActivate
	public void ejbActivate()
	{
		try
		{
			//Changed by Dayanand on 25/08/09[ WI89BAS029 || Update instanceActivityLog ]
			instanceInterceptorLog( "ejbActivate" ); //$NON-NLS-1$
			if(this.initialContext == null)
			{
				setInitialContext();
			}
			/*if(this.masterDataStateful == null)
			{
				//MasterDataStatefulHome masterDataStatefulHome = (MasterDataStatefulHome)this.initialContext.lookup("MasterDataStateful");
				//this.masterDataStateful = masterDataStatefulHome.create();
				this.masterDataStateful = (MasterDataStatefulLocal)this.initialContext.lookup("ibase/MasterDataStatefulEJB/local"); //$NON-NLS-1$
			}*/
			this.masterDataStateful = new MasterDataStatefulEJB();
			if(this.eventManager == null)
			{
				/*EventManagerHome eventManagerHome = (EventManagerHome)this.initialContext.lookup("EventManager");
				this.eventManager = eventManagerHome.create();*/
				//this.eventManager = (EventManagerLocal)this.initialContext.lookup("ibase/EventManagerEJB/local");				 //$NON-NLS-1$
				this.eventManager = new EventManagerEJB();
			}
			// Added by Raju K on 02-05-14 for Event log and Transaction lock as per danish sir START--
			//Added By Mahesh Patidar on 01/AUG/13[WI3DSUN001|to log the user event activity log]
			if(this.userEventLogEJB == null)
			{
				// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [START]
				//userEventLogEJB = (UserEventLogEJBLocal) this.initialContext.lookup("ibase/UserEventLogEJB/local");
				userEventLogEJB = new ibase.ejb.UserEventLogEJB();
				// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [END]
			}
			//Ended By Mahesh Patidar on 01/AUG/13[WI3DSUN001|to log the user event activity log]
			// Ended by Raju K on 02-05-14 for Event log and Transaction lock as per danish sir END--
			/*if(this.dbAccess == null)
			{
				DBAccessHome dbAccessHome = (DBAccessHome)this.initialContext.lookup("DBAccess");
				this.dbAccess = dbAccessHome.create();
				this.dbAccess = (DBAccessLocal)this.initialContext.lookup("ibase/DBAccessEJB/local");			 //$NON-NLS-1$
			}*/
			this.dbAccess = new DBAccessEJB();
			if(this.headerListXMLStr != null)
			{
				this.headerListDom = parseString(this.headerListXMLStr);
				this.headerListXMLStr = null;
			}
			if(this.detailDomString != null)
			{
				this.detailDom = parseString(this.detailDomString);
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :ejbActivate :==>\n"+e); //$NON-NLS-1$
		}
	}

	@PrePassivate
	public void ejbPassivate()
	{
		try
		{
			//Changed by Dayanand on 25/08/09[ WI89BAS029 || Update instanceActivityLog and remove masterDataStateful ,eventManager and dbAccess instances ]Start
			instanceInterceptorLog( "ejbPassivate" ); //$NON-NLS-1$
			this.masterDataStateful.remove();
			this.eventManager.remove();
			this.dbAccess.remove();
			this.masterDataStateful = null;
			this.eventManager = null;
			userEventLogEJB = null;
			this.dbAccess = null;
			//Changed by Dayanand on 25/08/09[ WI89BAS029 || Update instanceActivityLog and remove masterDataStateful ,eventManager and dbAccess instances ]End

			if(this.headerListDom != null)
			{
				this.headerListXMLStr = serializeDom(this.headerListDom);
				this.headerListDom = null;
			}
			if(this.detailDom != null)
			{
				this.detailDomString = serializeDom(this.detailDom);
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :ejbPassivate :==>\n"+e); //$NON-NLS-1$
		}
	}
	
	public void setSessionContext(SessionContext sessionContext)
	{

	}

	private void setInitialContext()throws ITMException
	{
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			this.initialContext = new InitialContext(appConnect.getProperty());
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulBean :setInitialContext :"); //$NON-NLS-1$
			throw new ITMException(e);
		}
	}
	// Added by Amit D on 19 Dec start
	public void setTransactionEditforWF( boolean isTransactionEditFromWF )throws RemoteException
	{
		this.isTransactionEditfromWF = isTransactionEditFromWF;
	}
	// Added by Amit D on 19 Dec END	
	
	
	public void setUserInfo( ibase.utility.UserInfoBean userInfo )throws RemoteException
	{
		this.userInfo = userInfo;
		//changed by Gulzar on 24/05/16 : START
		//this changes is made to pass the userInfo value to ValidatorEJB, ActionHandlerEJB, ProcessEJB through eventManger.
		//Changes is made related to multidb connection.
		if(this.eventManager != null)
		{
			this.eventManager.setUserInfo(userInfo);
		}
		//changed by Gulzar on 24/05/16 : END
	}
	//Changed by Dayanand on 25/08/09[ WI89BAS029 || Add method instanceInterceptorLog  ]
	public void setCoreModelId ( int transactionCoreModelId )
	{
		this.coreModelId = transactionCoreModelId ;
	}

	//Changed By Monif on 6/25/2008 [Setting UserInfo and detailDom through Xform]Start
	public void setUserInfo( String userInfoStr, String tempDetailXMLStr )throws RemoteException
	{		
		try
		{
			this.userInfo = new ibase.utility.UserInfoBean( userInfoStr );
			if ( tempDetailXMLStr != null && tempDetailXMLStr.length() > 0 )
			{
				this.detailDom = parseString( tempDetailXMLStr );
			}
			//changed by Gulzar on 24/05/16 : START
			//this changes is made to pass the userInfo value to ValidatorEJB, ActionHandlerEJB, ProcessEJB through eventManger.
			//Changes is made related to multidb connection.
			if(this.eventManager != null)
			{
				this.eventManager.setUserInfo(this.userInfo);
			}
			//changed by Gulzar on 24/05/16 : END
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :setUserInfo :==>"+e); //$NON-NLS-1$
			e.printStackTrace();
		}
	}
	//Changed By Monif on 6/25/2008 [Setting UserInfo and detailDom through Xform]End

	private void setObjDetails(String objName)throws ITMException
	{
		try
		{
			//Changed by Dayanand on 25/08/09[ WI89BAS029 || Update instanceActivityLog ]
			instanceInterceptorLog( "setObjDetails" ); //$NON-NLS-1$
			BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB]Object name set..............."); //$NON-NLS-1$
			this.objName = objName;
			HashMap objDetailMap = this.dbAccess.getObjDetailMap(objName, userInfo);
			if (objDetailMap != null)
			{
				this.msgNo = (objDetailMap.get("MSG_NO") != null)?(String)objDetailMap.get("MSG_NO"):null;//Added by shrutika on 23-02-17				
				this.msgString = (objDetailMap.get("MSG_STR") != null)?(String)objDetailMap.get("MSG_STR"):null;//Added by shrutika on 23-02-17
				this.refSer = (objDetailMap.get("REF_SER") != null)?(String)objDetailMap.get("REF_SER"):null; //$NON-NLS-1$ //$NON-NLS-2$
				this.systemDefObjName = (objDetailMap.get("USER_TRAN_WINDOW") != null)?((String)objDetailMap.get("USER_TRAN_WINDOW")).trim():"w_"+objName; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				if( ! systemDefObjName.equalsIgnoreCase(((String)objDetailMap.get("TRAN_WINDOW")).trim())) //$NON-NLS-1$
				{
					this.tranType = "U"; //$NON-NLS-1$
				}
				this.keyFlag = (objDetailMap.get("KEY_FLAG") != null)?(String)objDetailMap.get("KEY_FLAG") : "M"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				this.confirmCol = (objDetailMap.get("CONFIRM_COL") != null)?(String)objDetailMap.get("CONFIRM_COL") : ""; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				this.confirmVal = (objDetailMap.get("CONFIRM_VAL") != null)?(String)objDetailMap.get("CONFIRM_VAL") : ""; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - start
				this.cancelCol = (objDetailMap.get("CANCEL_COL") != null)?(String)objDetailMap.get("CANCEL_COL") : "";
				this.cancelVal = (objDetailMap.get("CANCEL_VAL") != null)?(String)objDetailMap.get("CANCEL_VAL") : "";
				this.closeCol = (objDetailMap.get("CLOSE_COL") != null)?(String)objDetailMap.get("CLOSE_COL") : "";
				this.closeVal = (objDetailMap.get("CLOSE_VAL") != null)?(String)objDetailMap.get("CLOSE_VAL") : "";
				//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - end
				this.tranDateCol = (objDetailMap.get("TRAN_DATE_COL") != null)?(String)objDetailMap.get("TRAN_DATE_COL") : ""; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				this.isAutoConfirm = (objDetailMap.get("AUTO_CONFIRM") != null && "Y".equalsIgnoreCase((String)objDetailMap.get("AUTO_CONFIRM")))?true : false; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				this.isHeaderRepeat = (objDetailMap.get("REPEATE_ADD") != null && "Y".equalsIgnoreCase((String)objDetailMap.get("REPEATE_ADD")))?true : false; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				
//				Changed by Dhruv on 06/11/2007 to support add detail repeat flag.
				this.isDetailRepeat = ( objDetailMap.get( "REPEAT_ADD_DET" ) != null && "Y".equalsIgnoreCase( ( String )objDetailMap.get( "REPEAT_ADD_DET" ) ) ) ? true : false; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$

				this.mainTableName = (objDetailMap.get("TABLE_NAME") != null)?(String)objDetailMap.get("TABLE_NAME"):""; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$

				this.signStatus = (objDetailMap.get("SIGN_STATUS") != null)?(String)objDetailMap.get("SIGN_STATUS") : null; //$NON-NLS-1$ //$NON-NLS-2$
				this.taxList = getTokenList((String)objDetailMap.get( "TAX_FORMS" ), "," ); //$NON-NLS-1$ //$NON-NLS-2$
				this.rateCol = ( objDetailMap.get( "RATE_COL" ) != null) ? (String)objDetailMap.get( "RATE_COL" ) : null; //$NON-NLS-1$ //$NON-NLS-2$
				this.qtyCol = ( objDetailMap.get( "QTY_COL" ) != null) ? (String)objDetailMap.get( "QTY_COL" ) : null; //$NON-NLS-1$ //$NON-NLS-2$
				this.editTemplate = (objDetailMap.get("EDIT_TMPLT") != null)?Integer.parseInt((String)objDetailMap.get("EDIT_TMPLT")) : 0; //$NON-NLS-1$ //$NON-NLS-2$
				this.wrkflwInit = (String)objDetailMap.get("WRKFLW_INIT"); //$NON-NLS-1$

				//Danish Thursday, May 04, 2006
				this.wrkflwOpt = ( objDetailMap.get( "WORKFLOW_OPT" ) != null ) ? ( String ) objDetailMap.get( "WORKFLOW_OPT" ) : this.wrkflwOpt; //$NON-NLS-1$ //$NON-NLS-2$
				if( Integer.parseInt(this.wrkflwOpt) > 1 )
				{
					this.isWrkflwToBeInitiated = true;
				}
				//Changed by Danish on 13/07/2006 for audit trail and editability flag
				this.editOpt = ( objDetailMap.get( "EDIT_OPT" ) != null ) ? ( String ) objDetailMap.get( "EDIT_OPT" ) : this.editOpt; //$NON-NLS-1$ //$NON-NLS-2$
				//Changed by Manish to add new criteria for editing, i.e; in addition to being not confirmed, only if condn. is satisfied shall the transaction be editable.
				this.editExpr = (objDetailMap.get("EDIT_EXPR") != null)?(String)objDetailMap.get("EDIT_EXPR") : null; //$NON-NLS-1$ //$NON-NLS-2$
				
				//Commented by Gulzar on 12/02/16 : Audit Trail should always on : START
				//this.auditTrailOpt = ( objDetailMap.get( "AUDIT_TRAIL_OPT" ) != null ) ? ( String ) objDetailMap.get( "AUDIT_TRAIL_OPT" ) : "1"; //$NON-NLS-1$ //$NON-NLS-2$
				//Commented by Gulzar on 12/02/16 : Audit Trail should always on : END
				
				//Changed by Monif on 02/07/09[To Save data on Add action if SaveFlag in Transetup is A].
				this.saveFlag = (objDetailMap.get("SAVE_FLAG") != null)?(String)objDetailMap.get("SAVE_FLAG") : null; //$NON-NLS-1$ //$NON-NLS-2$
			//	BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB][Object Name=" + this.objName + "][Ref Ser=" + this.refSer + "][Tran type=" + this.tranType +"][System def obj name=" + this.systemDefObjName + "][Key Flag=" + this.keyFlag + "] [Confirm Col="+this.confirmCol+"] [Confirm Val="+this.confirmVal+"] [Tran Date Col ="+this.tranDateCol+"] [Auto Confirm Flag="+this.isAutoConfirm+"] [Header Repeat Flag="+this.isHeaderRepeat+"][Detail Repeat Flag="+this.isDetailRepeat+"][Main Table Name="+this.mainTableName+"] [Sign status =" + this.signStatus + "] [Tax List=" + this.taxList + "] [editTemplate="+ this.editTemplate +"] [Is Wrkflw Init="+ this.wrkflwInit +"] [Edit Opt="+this.editOpt+"] [Audit Trail Opt="+this.auditTrailOpt+"]");
				//Added by Prasad on 17/03/18 [formName implementation in transaction editor]
				this.objFormInfoMap = new HashMap<String, String>();
			}
			else
			{
				//DDDDDDDDDD
				//if possible send the user an info saying that the invalid object name.
			}
			//Changed by Shrvan on 29/11/2006 as signing module is now based on wrkflwopt and sign list not reqd.Start
			/* 
			if(this.refSer != null && this.dbAccess.isSignDefined(this.refSer))
			{			
				BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB]Checking probable sign objects whether defined or not");
				//SignManagerHome signManagerHome =(SignManagerHome)this.initialContext.lookup("SignManager");
				//SignManager signManager = signManagerHome.create();	
				//this.signList = signManager.getSignObjList(this.objName);
				this.isAutoConfirm = false;
			}
			*/
			//Changed by Shrvan on 29/11/2006 as signing module is now based on wrkflwopt and sign list not reqd.End
			//if(this.signList != null)
			//{
			//	this.isAutoConfirm = false;
			//}
			setContextDetails(userInfo);
			this.actionXmlStr = getActionString(objName);
			if( this.headerPKFieldNames == null )
			{
				setHeaderPKFieldNames();
				setArgFieldProperties();
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :setObjDetails :==>"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]Obj name and other initializations done !!!!!!!!!!!!!"); //$NON-NLS-1$
	}

	/*private void setContextDetails()throws java.rmi.RemoteException, ITMException
	{
		BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB]In setContextDetails. . . . . . "); //$NON-NLS-1$
		try
		{
			String objName = this.objName;
			this.contextTitlesList = new ArrayList();
			 //Changed by Taru on 1/12/2008 [ to get scan related info ] start
			this.scanFlagList = new ArrayList();
			this.scanMetadataList = new ArrayList();
			this.autoAcceptScanList = new ArrayList();
            //Changed by Taru on 1/12/2008 [ to get scan related info ] END
			
			//Changed By Pragyan 19/08/08 . [For Property Calculation Show] [SY89BAS005]
			this.calPropertyInfoList = new  ArrayList();
			
			//Changed by Monif on 12/3/2008. [Weighing functionality] [WI89BAS012].Start
			this.weighAfterSaveList = new  ArrayList();
			this.weighColumnOnSaveList = new  ArrayList();
			this.scanDelimiterList = new  ArrayList();
			//Changed by Monif on 12/3/2008. [Weighing functionality] [WI89BAS012].End
			//Changed by Monif on 22/04/09. [Weighing functionality] [WI89BAS012].
			this.extMetadataList = new  ArrayList();
			this.autoAcceptWeighdataList = new  ArrayList();

			ArrayList objFormsDetailList = this.dbAccess.getObjFormsDetailList(objName);
			this.noOfForms = objFormsDetailList.size();
			this.crossUpdateExprList = new ArrayList();
			this.exprVarInfoList = new ArrayList();
			this.targetVarInfoList = new ArrayList();
			for(int i = 0; i < this.noOfForms; i++)
			{
				ArrayList currFormDetailList = (ArrayList)objFormsDetailList.get(i);
				this.contextTitlesList.add(currFormDetailList.get(0));
				this.crossUpdateExprList.add(currFormDetailList.get(1));
				this.exprVarInfoList.add(currFormDetailList.get(2));
				this.targetVarInfoList.add(currFormDetailList.get(3));
				
//				Changed by Taru on 1/11/2008 [ to get scan related info ] start
				this.scanFlagList.add(currFormDetailList.get(5));
				this.scanMetadataList.add(currFormDetailList.get(6));
				this.autoAcceptScanList.add(currFormDetailList.get(7));
				//Changed by Taru on 1/11/2008 [ to get scan related info ] End
				
				//Changed By Pragyan 19/08/08 . [set Propert Info] [SY89BAS005]
				this.calPropertyInfoList.add(currFormDetailList.get(8));

				//Changed by Monif on 12/3/2008. [Weighing functionality] [WI89BAS012].Start
				this.weighAfterSaveList.add(currFormDetailList.get(9));
				this.weighColumnOnSaveList.add(currFormDetailList.get(10));
				this.scanDelimiterList.add(currFormDetailList.get(11));
				//Changed by Monif on 12/3/2008. [Weighing functionality] [WI89BAS012].End
				//Changed by Monif on 22/04/09. [Weighing functionality] [WI89BAS012].
				this.extMetadataList.add(currFormDetailList.get(12));	
				this.autoAcceptWeighdataList.add(currFormDetailList.get(13));
				//Added by Prasad on 02/06/16 [get tran_id_col for all forms]
				if ( currFormDetailList.size() > 27 )
				{
					this.getFormWisePkFldNameMap().put(""+(i+1), ""+currFormDetailList.get(27));
				}
			}
			//Added by Prasad on 02/06/16 [get tran_id_col for all forms] START
			if ( this.masterDataStateful != null )
			{
				this.masterDataStateful.setFormWisePkFldNameMap( this.getFormWisePkFldNameMap() );
			}
			//Added by Prasad on 02/06/16 [get tran_id_col for all forms] END
		}
		catch(Exception e)
		{
			BaseLogger.log("3", userInfo,editorId,"Exception :MasterStatefulEJB :setContextDetails :==>"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
	}*/
	
//	Changed by Taru on 1/11/2008 [ to get scan related info ] start
	public ArrayList getScanFlagList(String objName)throws java.rmi.RemoteException, ITMException
	{
		 return this.scanFlagList;
	}

	public ArrayList getScanMetadataList(String objName)throws java.rmi.RemoteException,ITMException
	{
		return this.scanMetadataList;
	}
	public ArrayList getAutoAcceptScanList(String objName)throws java.rmi.RemoteException,ITMException
	{
		return this.autoAcceptScanList;
	}
	//Changed by Taru on 1/11/2008 [ to get scan related info ] End
	
	public ArrayList getContextTitlesList(String objName)throws java.rmi.RemoteException,ITMException
	{
		ArrayList contextTitlesList = null;
		try
		{
			setObjDetails(objName);
			contextTitlesList = new ArrayList(this.contextTitlesList);
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :getContextTitlesList :==>"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return contextTitlesList;
	}

	public void setArgFieldNames(String argFieldNames)throws RemoteException, ITMException
	{
		try
		{
			this.argFieldNames = argFieldNames;
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :setArgFieldNames :==>"); //$NON-NLS-1$
			e.printStackTrace();
			throw new ITMException (e);
		}
	}

	//Changed by Monif on 11/11/09[To get isDetailRepeat value].Start
	public boolean getIsDetailRepeat(String objName)throws java.rmi.RemoteException,ITMException
	{
		return this.isDetailRepeat;
	}//Changed by Monif on 11/11/09[To get isDetailRepeat value].End
	
	private void setArgFieldProperties()throws ITMException
	{
		try
		{
			BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB]Setting header argument field properties .........."); //$NON-NLS-1$
			//Changes By Ajinkya Gopalkar on 4-Apr-17
//			DWObject dw = DWFactory.getDWFactory().getDataWindow(this.objName +"11"); //$NON-NLS-1$
			//Changed by Prasad on 17/03/18 [formName implementation in transaction editor]
			//DWObject dw = new DWFactory().getDataWindow(this.objName +"11");
			DWObject dw = new DWFactory(userInfo).getDataWindow(this.objName +"1"+ getFormName( "1" ));
			ArrayList argNamesList = dw.getArgNamesList();
			String argMetaDataString = null;
			StringTokenizer argTokens = null;
			StringBuffer argFieldNamesBuff = new StringBuffer();
			StringBuffer argFieldDataTypesBuff = new StringBuffer();
			for(int i = 0; i < argNamesList.size(); i++)
			{
				argMetaDataString = (String)argNamesList.get(i);
				argTokens = new StringTokenizer(argMetaDataString, "~"); //$NON-NLS-1$
				argFieldNamesBuff.append(argTokens.nextToken()).append(":"); //$NON-NLS-1$
				argTokens.nextToken();
				argFieldDataTypesBuff.append(argTokens.nextToken()).append(":"); //$NON-NLS-1$
			}
			if (argFieldNamesBuff.length() > 0)
			{
				argFieldNamesBuff.deleteCharAt((argFieldNamesBuff.length() - 1));
				argFieldDataTypesBuff.deleteCharAt((argFieldDataTypesBuff.length() - 1));
			}
			this.argFieldNames = argFieldNamesBuff.toString();
			this.argFieldTypes = argFieldDataTypesBuff.toString();
			//BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB]Argument field names :["+this.argFieldNames+"] field types :["+this.argFieldTypes+"]");
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :setArgFieldProperties :==>"); //$NON-NLS-1$
			e.printStackTrace();
			throw new ITMException (e);
		}
	}

	public void setArgFieldTypes(String argFieldTypes)throws RemoteException, ITMException
	{
		try
		{
			this.argFieldTypes = argFieldTypes;
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :setArgFieldTypes :==>"); //$NON-NLS-1$
			e.printStackTrace();
			throw new ITMException (e);
		}
	}

	public void setArgFieldValues(String argFieldValues)throws RemoteException, ITMException
	{
		try
		{
			//Changed by Dhruv on 13/07/2006 : to avoid append "null"
			String argFieldValuesNew = ""; //$NON-NLS-1$
			//Changed by Dhruv on 22/06/2006 to check for Argument Values != null for direct access of Add from web.
			if( argFieldValues != null && argFieldValues.length() > 0 )
			{
				//BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB]this.argFieldTypes :"+this.argFieldTypes);
				StringTokenizer argValueTokens = new StringTokenizer(argFieldValues, ":"); //$NON-NLS-1$
				StringTokenizer argTypeTokens = new StringTokenizer(this.argFieldTypes, ":"); //$NON-NLS-1$
				while(argTypeTokens.hasMoreTokens() && argValueTokens.hasMoreTokens())
				{
					String currArgType = argTypeTokens.nextToken();
					String currArgValue = argValueTokens.nextToken();
					if (currArgType.equalsIgnoreCase("DATETIME") || currArgType.equalsIgnoreCase("DATE")) //$NON-NLS-1$ //$NON-NLS-2$
					{
						//Changed By Danish on 05/09/2006 reason [dont parse if value is null or blank]
						//argFieldValuesNew += getValidDateString(currArgValue, getDispDateFormat(), getApplDateFormat());
						argFieldValuesNew += ( currArgValue != null && currArgValue.length() > 0 ) ? getValidDateString( currArgValue, getDispDateFormat(), getApplDateFormat() ) : currArgValue ;
					}
					else
					{
						argFieldValuesNew += currArgValue;
					}
					argFieldValuesNew += ":"; //$NON-NLS-1$
				}
				//BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB]argFieldValuesNew :"+argFieldValuesNew);
				this.argFieldValues = argFieldValuesNew;
			}//if( argFieldValues != null && argFieldValues.length() > 0 )
			//DDD 
			//this.detailDom = null;
			//this.headerListDom = null;
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :argFieldValues :==>"); //$NON-NLS-1$
			e.printStackTrace();
			throw new ITMException ( e );
		}
	}

	public void setAccFilterQuery( String accFilterQuery )throws RemoteException, ITMException
	{
		try
		{
			BaseLogger.log("3", userInfo,editorId, "[MasterStatefulEJB]Setting Acc filter Query :[" + accFilterQuery + "]" ); //$NON-NLS-1$ //$NON-NLS-2$
			this.accFilterQuery = accFilterQuery;
			//DD 
			this.detailDom = null;
			this.headerListDom = null;
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :setAccFilterQuery :==>"); //$NON-NLS-1$
			e.printStackTrace();
			throw new ITMException (e);
		}
	}

	public void setAdvQuery( String advQuery )throws RemoteException, ITMException
	{
		try
		{
			//this.advQuery = advQuery;
			updateFilter( advQuery );
			//DDD
			this.detailDom = null;
			this.headerListDom = null;
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :setAdvQuery :==>"); //$NON-NLS-1$
			e.printStackTrace();
			throw new ITMException (e);
		}
	}

	private void setHeaderPKFieldNames()throws Exception
	{
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]Setting header primary key field names .........."); //$NON-NLS-1$
		DWObject dwObj = getDWObject(objName, 1);
		ArrayList primaryKeyLogNameList = dwObj.getPrimaryKeyLogNameList();
		ArrayList primaryKeyDataTypeList = dwObj.getPrimaryKeyDataTypeList();
		StringBuffer headerPKFieldNamesBuff = new StringBuffer();
		StringBuffer headerPKFieldDataTypesBuff = new StringBuffer();
		for(int i = 0; i < primaryKeyLogNameList.size(); i++)
		{
			headerPKFieldNamesBuff.append((String)primaryKeyLogNameList.get(i)).append(":"); //$NON-NLS-1$
			headerPKFieldDataTypesBuff.append((String)primaryKeyDataTypeList.get(i)).append(":"); //$NON-NLS-1$
		}
		if (headerPKFieldNamesBuff.length() > 0)
		{
			headerPKFieldNamesBuff.deleteCharAt((headerPKFieldNamesBuff.length() - 1));
		}
		this.headerPKFieldNames = headerPKFieldNamesBuff.toString();
		this.headerPKFieldDataTypes = headerPKFieldDataTypesBuff.toString();
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]Header primary key field names :"+this.headerPKFieldNames+": !!!!!!"); //$NON-NLS-1$ //$NON-NLS-2$
	}

	//objContext == 1
	//edit
	//add
	private void setHeaderPKFieldValues()throws  ITMException
	{
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]Setting header primary key field values..........."); //$NON-NLS-1$
		try
		{
			//BaseLogger.log("3", userInfo,editorId,"Amit..headerListDom[" +GenericUtility.getInstance().serializeDom(this.headerListDom)+"]");
			//BaseLogger.log("3", userInfo,editorId,"Amit..this.editFlag[" +this.editFlag+"]this.keyFlag["+this.keyFlag+"]this.headerPKFieldValues["+this.headerPKFieldValues+"]");
			String workflowRefID = this.headerPKFieldValues ; // Added by Amit D on 30 Dec 13.
			if(Integer.parseInt(this.objContext.trim()) == 1)
			{
				String headerPKFieldValues = ""; //$NON-NLS-1$
				Node detailNode = null;
				if( this.headerListDom != null && ! this.editFlag.equalsIgnoreCase( "A" ) ) //$NON-NLS-1$
				{
					//Changed by Prasad on 02/11/16 [to search node from dbId]
					//detailNode = searchNode(this.headerListDom, "1", this.viewDomId); //$NON-NLS-1$
					detailNode = searchNode(this.headerListDom, "1", this.viewDomId, ""); //$NON-NLS-1$
					headerPKFieldValues = detailNode.getAttributes().getNamedItem("dbID").getNodeValue(); //$NON-NLS-1$
				}
				else if( this.keyFlag.equalsIgnoreCase( "M" ) ) //$NON-NLS-1$
				{
					//For header, domId is always "1"
					//Changed by Prasad on 02/11/16 [to search node from dbId]
					//detailNode = searchNode(this.detailDom, "1", "1"); //$NON-NLS-1$ //$NON-NLS-2$
					detailNode = searchNode(this.detailDom, "1", "1", ""); //$NON-NLS-1$ //$NON-NLS-2$
					StringTokenizer pkNameTokens = new StringTokenizer(this.headerPKFieldNames, ":"); //$NON-NLS-1$
					while(pkNameTokens.hasMoreTokens())
					{
						String currPKName = pkNameTokens.nextToken();
						NodeList childNodes = detailNode.getChildNodes();
						int noOfChilds = childNodes.getLength();
						for(int ctr = 0; ctr < noOfChilds; ctr++)
						{
							Node currChild = childNodes.item(ctr);
							//Changed by Nazia on 06/09/2007 [ currChild.getFirstChild() != null condition added to avoid null pointer exception]
							if( currChild.getNodeName().equalsIgnoreCase(currPKName) && currChild.getFirstChild() != null)
							{
								headerPKFieldValues += currChild.getFirstChild().getNodeValue() + ":"; //$NON-NLS-1$
							}
						}
						/* Changed by Danish on 07-01-08 [Commented and taken outside] start
						if( headerPKFieldValues.endsWith( ":" ) )
						{
							headerPKFieldValues = headerPKFieldValues.substring( 0, headerPKFieldValues.lastIndexOf( ":" ) );
							BaseLogger.log("3", userInfo,editorId," headerPKFieldValues  :"+ headerPKFieldValues);
						}
						Changed by Danish on 07-01-08 [Commented and taken outside] End
						*/
					}
					//Changed by Danish on 07-01-08 [taken outside] Start
					if( headerPKFieldValues.endsWith( ":" ) ) //$NON-NLS-1$
					{
						headerPKFieldValues = headerPKFieldValues.substring( 0, headerPKFieldValues.lastIndexOf( ":" ) ); //$NON-NLS-1$
						BaseLogger.log("3", userInfo,editorId," headerPKFieldValues  :"+ headerPKFieldValues); //$NON-NLS-1$
					}
					//Changed by Danish on 07-01-08 [taken outside] End
					
					
				}
				this.headerPKFieldValues = headerPKFieldValues;
				if(isTransactionEditfromWF && workflowRefID!=null)
				{
					BaseLogger.log("3", userInfo,editorId,"Transaction Edited From Workflow so setting work flow ref id  as primary key");
					this.headerPKFieldValues  = workflowRefID ;
				}
				/*
					BaseLogger.log("3", userInfo,editorId,"isTransactionEditfromWF--"+isTransactionEditfromWF);
					if(!isTransactionEditfromWF && this.headerPKFieldValues !=null )
					{
						this.headerPKFieldValues = headerPKFieldValues;
					}
					else
					{
						BaseLogger.log("3", userInfo,editorId,"As Transaction is Edited From Work Flow so we ignoring to set Primary key second time ");
					}*/
				
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :setHeaderPKFieldValues :==>"); //$NON-NLS-1$
			//e.printStackTrace();
			throw new ITMException(e);
		}
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]Header primary key field values :"+this.headerPKFieldValues+": !!!!!!!!"); //$NON-NLS-1$ //$NON-NLS-2$
	}

	//Changed by Danish on 03/01/2007
	public void setRequestParamStr(String requestParamStr)throws RemoteException, ITMException
	{
		try
		{
			this.requestParamStr = requestParamStr;
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception : MasterStatefulEJB : setRequestParamStr :==>"); //$NON-NLS-1$
			e.printStackTrace();
			throw new ITMException (e);
		}
	}

	private HashMap getRowSecurityInfoMap() throws Exception
	{
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]In getRowSecurityInfoMap  . . . . . . "); //$NON-NLS-1$
		//StringBuffer rowSecurityStrBuff = new StringBuffer();
		HashMap rowSecurityInfo = null;
		Connection con = null;
		Statement stmt = null;
		//Added by Shahu Mali on 09-10-13.[]
        String transDB = null;
		try
		{
			ConnDriver conDriver = new ConnDriver();
			//Commented and Below changes done by shahu Mali on 09-10-13 to support multiDB connection : START
			
			//if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
			{
			  con = conDriver.getConnectDB(transDB);
			}
			//Commented and Below changes done by shahu Mali on 09-10-13 to support multiDB connection : END
			
			//SITE_ACC_COL,ITEM_SER_ACC_COL these values not to be set from here
			String sql = "SELECT SITE_ACC_COL,SALES_PERS_ACC_COL,CUST_ACC_COL,SUPP_ACC_COL,ITEM_SER_ACC_COL,EMP_ACC_COL FROM TRANSETUP WHERE TRAN_WINDOW='w_" + this.objName+"'"; //$NON-NLS-1$ //$NON-NLS-2$
			stmt = con.createStatement();
			ResultSet rs = stmt.executeQuery(sql);		
			String site_acc_col = null;
			String sales_pers_acc_col = null;
			String cust_acc_col = null;
			String supp_acc_col = null;
			String item_ser_acc_col = null;
			String emp_acc_col = null;

			if(rs.next())
			{
				site_acc_col = rs.getString("SITE_ACC_COL"); //$NON-NLS-1$
				
				sales_pers_acc_col = rs.getString("SALES_PERS_ACC_COL"); //$NON-NLS-1$
				
				cust_acc_col = rs.getString("CUST_ACC_COL"); //$NON-NLS-1$
				
				supp_acc_col = rs.getString("SUPP_ACC_COL"); //$NON-NLS-1$
				
				item_ser_acc_col = rs.getString("ITEM_SER_ACC_COL"); //$NON-NLS-1$
				
				emp_acc_col = rs.getString("EMP_ACC_COL"); //$NON-NLS-1$
				
				String focussedColumn = ""; //$NON-NLS-1$
				String itemSer = ""; //$NON-NLS-1$
				String condn = ""; //$NON-NLS-1$
				rowSecurityInfo = new HashMap();
				//BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB]User Type :"+this.userInfo.getUserType());
				if (this.userInfo.getUserType() != null)
				{
					//if site has value then append AND SITE_CODE TO YOUR ROW SECURITY
					if((this.userInfo.getUserType().trim().equalsIgnoreCase("P")) && (sales_pers_acc_col != null && sales_pers_acc_col.length() >0)) //$NON-NLS-1$
					{
						focussedColumn = sales_pers_acc_col.trim();
						if((item_ser_acc_col != null && item_ser_acc_col.length() >0))
						{
							itemSer = item_ser_acc_col.trim();
							condn = " SALES_PERS."+itemSer+"=CUST_STOCK.ITEM_SER AND SALES_PERS.SALES_PERS='" + this.userInfo.getEntityCode() +"'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
							rowSecurityInfo.put("SALES_PERS", condn); //$NON-NLS-1$
						}
					}
					else if((this.userInfo.getUserType().trim().equalsIgnoreCase("C")) && (cust_acc_col != null && cust_acc_col.length() >0)) //$NON-NLS-1$
					{
						focussedColumn = cust_acc_col.trim();
					}
					else if((this.userInfo.getUserType().trim().equalsIgnoreCase("S")) && (supp_acc_col != null && supp_acc_col.length() >0)) //$NON-NLS-1$
					{
						focussedColumn = supp_acc_col.trim();
					}
					else if((this.userInfo.getUserType().trim().equalsIgnoreCase("E")) && (emp_acc_col != null && emp_acc_col.length() >0)) //$NON-NLS-1$
					{
						focussedColumn = emp_acc_col.trim();
						if((item_ser_acc_col != null && item_ser_acc_col.length() >0))
						{
							itemSer = item_ser_acc_col.trim();
						}
						//rowSecurityStrBuff.append(" AND ."+itemSer+" = CUST_STOCK.ITEM_SER");
					}
				}
			}
			rs.close();
			rs = null;
			stmt.close();
			stmt = null;
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :getRowSecurityInfoMap :==>"); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(con != null)
				{					
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					con.close();
					con = null;
				}
			}
			catch (Exception e)
			{
				BaseLogger.log("0", userInfo,editorId, "Exception :MasterStatefulEJB :getRowSecurityInfoMap :finally==>" ); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2", userInfo,editorId, "[MasterStatefulEJB]rowSecurityInfo :\n"+rowSecurityInfo ); //$NON-NLS-1$
		return rowSecurityInfo;
	}

	//Changed by deepak on 16-oct-08  to Change in no. of arguments in toXSL request id WI89BAS013 
	//public String toXSL(String objName, String pContext, String objContext, String editFlag, String appContext) throws RemoteException,ITMException
	public String toXSL(String objName, String pContext, String objContext, String editFlag, String appContext,String profileIdRes, String transDB) throws RemoteException,ITMException
	{
		//BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB]Building XSL for foll params.........:\nobjName :" + objName + ":\npageContext :" + pContext+":\nobjContext :" + objContext + ":\neditFlag :" + editFlag+":\nappContext :"+appContext+":");
		String retString = null;
		try
		{
			if (editFlag != null && editFlag.length() > 0)
			{
				this.editFlag = editFlag;
				this.localEditFlag = editFlag;
			}
			if(this.tranType.equalsIgnoreCase("U")) //$NON-NLS-1$
			{
			//Added by Pankaj T on 19-12-17 [changes for multitenancy]
				retString = this.dbAccess.getDraftXSLFName(this.userInfo.getLoginCode(), this.objName, -1, pContext, this.userInfo.toString());
			}
			if(this.tranType.equalsIgnoreCase("S") || retString == null || retString.length() == 0) //$NON-NLS-1$
			{
				I18NLabel localizer  = new I18NLabel();
				// Changed by deepak on 16-oct-08  to Change no. of arguments in setLocaleLabels request id WI89BAS013 
				//Document metaDataDoc = localizer.setLocaleLabels(objName, objContext, this.user_lang, this.user_country, pContext, editFlag);
				//Changed by Prasad on 05/05/16 [Editor option added for Property Editor] START
				//Document metaDataDoc = localizer.setLocaleLabels(objName, objContext, this.user_lang, this.user_country, pContext, editFlag, profileIdRes);
				
				//Changed by samadhan on 01/11/2017 for getting metadata from E12GenericUtility to apply enterprise propery editor start
				//String propertyEditorDtl = profileIdRes+"~~SEP~~"+getEditor();
				//Document metaDataDoc = localizer.setLocaleLabels(objName, objContext, this.user_lang, this.user_country, pContext, editFlag, propertyEditorDtl);
				
				HashMap<String, String> propEditorInfoMap = new HashMap<String,String>();
				propEditorInfoMap.put("PROFILE_ID_RES", profileIdRes);
				propEditorInfoMap.put("ENTERPRISE_ID_RES", this.userInfo.getEnterprise());
				propEditorInfoMap.put("EDITOR", getEditor());
				//Added by Sadique on 15/03/2021 [pass userid to apply table properties]
				propEditorInfoMap.put("USER_ID", this.userInfo.getLoginCode());
				//Added by Prasad on 17/03/18 [formName implementation in transaction editor]
				//Document metaDataDoc = localizer.setLocaleLabels(objName, objContext, this.user_lang, this.user_country, pContext, editFlag, propEditorInfoMap, userInfo.getTransDB());
				Document metaDataDoc = localizer.setLocaleLabels(objName, objContext, this.user_lang, this.user_country, pContext, editFlag, propEditorInfoMap, this.userInfo);
				//Changed by samadhan on 01/11/2017 for getting metadata from E12GenericUtility to apply enterprise propery editor end
								
				//Changed by Prasad on 05/05/16 [Editor option added for Property Editor] END

				HashMap paramMap = new HashMap();
				//paramMap.put("NO_OF_FORMS", new Integer(this.noOfForms));
				paramMap.put("KEY_FLAG", this.keyFlag); //$NON-NLS-1$
				paramMap.put("EDIT_TMPLT", new Integer(this.editTemplate)); //$NON-NLS-1$
				paramMap.put("CONFIRM_COL", this.confirmCol); //$NON-NLS-1$
				paramMap.put("CONFIRM_VAL", this.confirmVal); //$NON-NLS-1$
				Boolean isTaxApplicable = new Boolean(false);
				if(this.taxList != null && this.taxList.contains(objContext))
				{
					isTaxApplicable = new Boolean(true);
				}
				paramMap.put("IS_TAX_APPL", isTaxApplicable); //$NON-NLS-1$
				//Changed by Pankaj on 21/12/17 added userInfo parameter for multidb connection 
				retString = localizer.getXSL(this.editFlag, appContext, paramMap, this.userInfo);
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :toXSL==>\n"+e); //$NON-NLS-1$
			e.printStackTrace();
			throw new ITMException(e);
		}
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]\t\t***************  XSL building ends  ****************"); //$NON-NLS-1$
		return retString;
	}
	
	private void updateFilter(String filterStr)
	{
		this.filterString = filterStr;
		//Other updations(ROW security, Accessibility Filter) of the filter to be done here
	}

	private void createHeaderListDom()throws Exception
	{
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]In createHeaderListDom   . . . . . . "); //$NON-NLS-1$
		String tempHeaderXMLStr = null;
		/*MasterDataHome mDataHome = (ibase.webitm.ejb.MasterDataHome)this.initialContext.lookup("MasterData");
		MasterData mDataRem = mDataHome.create();*/
		//MasterDataLocal mDataRem = (ibase.webitm.ejb.MasterDataLocal)this.initialContext.lookup("ibase/MasterDataEJB/local"); //$NON-NLS-1$
		MasterDataEJB masterDataEJB = new MasterDataEJB();
		if(this.tranType.equalsIgnoreCase("S")) //$NON-NLS-1$
		{
			tempHeaderXMLStr = masterDataEJB.getXMLFromDBForBrow(this.objName, "1", "1", this.argFieldValues, this.argFieldTypes, this.filterString, this.userInfo); //$NON-NLS-1$ //$NON-NLS-2$
		}
		else if(this.tranType.equalsIgnoreCase("U")) //$NON-NLS-1$
		{
		//Changed by Pankaj T on 04-01-18 [changes for multitenancy]
			tempHeaderXMLStr = masterDataEJB.getDraftBrowXml(this.objName, this.userInfo.getLoginCode(), -1, this.userInfo);
		}
		//brow xml string should not be null or empty string, even in case of no records found it should return a well-formed xml without the <Detail> tags. 
		this.headerListDom = parseString(tempHeaderXMLStr);
		masterDataEJB = null;
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]createHeaderListDom  completed . . . . . . "); //$NON-NLS-1$
	}

	//This will execute only for the header
	private void createDetailDom()throws Exception
	{
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]In createDetailDom  . . . . . .this.headerPKFieldValues["+this.headerPKFieldValues+"]headerPKFieldDataTypes["+this.headerPKFieldDataTypes+"]"); //$NON-NLS-1$
		Date startTime = new Date();
		//Added by shrutika on 03-12-18 [Start] for updateEventLog.
		String actionMode = "VIEW";
		if(this.editFlag.equals("A"))
		{
			actionMode = "ADD";
		}
		else if(this.editFlag.equals("E"))
		{
			actionMode = "EDIT";
		}
		if("".equals(this.getEditorId()))
		{
			this.editorId = "" +new Date().getTime();
		}
        //Change by shrutika on 05-01-19 for add exception.
        //Added if condition by shrutika on 16-05-2020 for nullPointer Exception occur issue repoted by piyush sir(Case not given only give Exception file)
        if( userEventLogEJB != null && userInfo != null )
        {
            userEventLogEJB.setEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(), this.getEditorId(), actionMode , "get_data" , startTime, null ,"objContext:[" + this.objContext + "] pageContext:["+this.pageContext+"]", this.headerPKFieldValues,"Pending","SA","");
        }
		//Added by shrutika on 03-12-18 [End] for updateEventLog.
		setAuditTrailOpt();
		String tempDetailXMLStr = null;
		if( ! this.editFlag.equalsIgnoreCase("A")) //$NON-NLS-1$
		{
			if(this.tranType.equalsIgnoreCase("S")) //$NON-NLS-1$
			{
				//tempDetailXMLStr = this.masterDataStateful.getXMLFromDBForEdit(this.objName, this.pageContext, this.noOfForms, this.headerPKFieldValues, this.headerPKFieldDataTypes, null, this.taxList, this.refSer);
				
				if(isTransactionEditfromWF)
				{
					tempDetailXMLStr = this.masterDataStateful.getTransactionXMLForEditFromWFDB(this.objName, this.pageContext, this.noOfForms, this.headerPKFieldValues, this.headerPKFieldDataTypes, null, this.taxList, this.refSer, this.userInfo.toString() );
				}
				else
				{
					tempDetailXMLStr = this.masterDataStateful.getTransactionXMLForEdit(this.objName, this.pageContext, this.noOfForms, this.headerPKFieldValues, this.headerPKFieldDataTypes, null, this.taxList, this.refSer, this.userInfo.toString(), this.objFormsDetailList );
				}
				//Changed by Dhruv on 18/07/2006 to retain old dom for audit trail.
				if( this.isAuditTrailOn )
				{
					this.auditDataXmlBefore = tempDetailXMLStr;
				}
			}
			else if(this.tranType.equalsIgnoreCase("U")) //$NON-NLS-1$
			{
				//Changed by Pankaj T on 04-01-18 [changes for multitenancy]
				tempDetailXMLStr = this.masterDataStateful.getDraftEditXml(this.objName, this.userInfo.getLoginCode(), this.headerPKFieldValues, this.userInfo.toString() );
			}
		}
		else if(this.editFlag.equalsIgnoreCase("A")) //$NON-NLS-1$
		{
			//Changed by Pragyan 24/01/08 For passing User Info String to the method.
			//tempDetailXMLStr = this.masterDataStateful.getBlankDomForAdd(this.objName, "1", this.pageContext, this.taxList);
			//Changed by Prasad on 05/05/16 [Editor option added for Property Editor] START
			//tempDetailXMLStr = this.masterDataStateful.getBlankDomForAdd(this.objName, "1", this.pageContext, this.taxList,this.userInfo.toString() ); //$NON-NLS-1$
			//Changed by Prasad on 17/03/18 [formName implementation in transaction editor]
			String formName = getObjPropValue( "1", "FORM_NAME" );
			tempDetailXMLStr = this.masterDataStateful.getBlankDomForAdd(this.objName, "1", this.pageContext, this.taxList,this.userInfo.toString(), this.getEditor(), formName ); //$NON-NLS-1$
			//Changed by Prasad on 05/05/16 [Editor option added for Property Editor] END
		}
		//Added BY Suraj on 18-11-2016 [To set plan date for GWT Editor in Calendar]Start
		if ( this.editFlag.equalsIgnoreCase("A") && "Yes".equalsIgnoreCase(getCalComp()) )
		{
			tempDetailXMLStr = addDateToDOM( tempDetailXMLStr );
		}
		//Added BY Suraj on 18-11-2016 [To set plan date for GWT Editor in Calendar]End
		this.detailDom = null;
		this.currRecordNode = null;
		this.currTaxNode = null;
		this.detailDom = parseString( tempDetailXMLStr );
		String transDB = this.userInfo.getTransDB(); //Shahu on 10/12/14

		if( ! this.editFlag.equalsIgnoreCase("V") ) //$NON-NLS-1$
		{
			updateNewDom(null);
		}
		// Added by Raju K on 02-05-14 for Event log and Transaction lock as per danish sir START--
		//changed By Mahesh Patidar on 01/AUG/13[WI3DSUN001|to log the user event activity log]
		if( userInfo != null )
		{
			//Change by shrutika on 03-12-18 for updateEventLog.
			//userEventLogEJB.setEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(), this.getEditorId(), actionMode , "get_data" , startTime, new Date(),"objContext:[" + this.objContext + "] pageContext:["+this.pageContext+"]", this.headerPKFieldValues);
			//Change by shrutika on 05-01-19 for add exception.
			userEventLogEJB.updateEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(), this.getEditorId(), actionMode , "get_data" , startTime, new Date(),"objContext:[" + this.objContext + "] pageContext:["+this.pageContext+"]", this.headerPKFieldValues,"Success","SA","");
		}
		else
		{
			BaseLogger.log("3", userInfo,editorId," ============ User info is null then never create event log in MasterStatefulEJB.java file");
		}
		//Ended By Mahesh Patidar on 01/AUG/13[WI3DSUN001|to log the user event activity log]
		// Ended by Raju K on 02-05-14 for Event log and Transaction lock as per danish sir END--
//		BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB]createDetailDom  completed : detailDom :"+this.detailDom);
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]createDetailDom  completed. . . . . . . . . "); //$NON-NLS-1$
	}
	//Added BY Suraj on 18-11-2016 [To set plan date for GWT Editor in Calendar]Start
	
	private String addDateToDOM( String xmlStr )
	{
		try 
		{
			String params = getPlanDate();
			BaseLogger.log("3", userInfo,editorId,"Sura222 params ["+params+"]");
			//Sura222 params [27-Oct-2017~start_date]
			String  [] paramsArr = params.split( "~" );
			HashMap<String, String> argMap = new HashMap<String, String>();
			if( paramsArr != null && paramsArr.length > 0 )
			{
				for( String param : paramsArr )
				{
					BaseLogger.log("3", userInfo,editorId,"142000000 - param ["+param+"]");
					String  [] fieldArr = param.split( "=" );
					String fieldName = fieldArr[1];
					String fieldValue = fieldArr[0];
					argMap.put(fieldName, fieldValue);
				}
			}
			//String fieldName = paramsArr[1];
			//String fieldValue = paramsArr[0];
			//BaseLogger.log("3", userInfo,editorId,"fieldName- ["+fieldName+"] fieldValue ["+fieldValue+"] params ["+params+"]");
			Document document = new E12GenericUtility().parseString( xmlStr );
			NodeList detailNodeList = document.getElementsByTagName("Detail1");
			Node detailNode = detailNodeList.item(0);
			NodeList detailChildList = detailNode.getChildNodes(); //to get childs of detail
		
			for (int i = 0; i <detailChildList.getLength(); i++)
			{
				Node childNoe = detailChildList.item(i);//selects items one by one
				if(childNoe.getNodeType() == Node.ELEMENT_NODE && !"attribute".equalsIgnoreCase(childNoe.getNodeName()))
				{
					BaseLogger.log("3", userInfo,editorId,"NodeName-"+childNoe.getNodeName());
					/*if( childNoe.getNodeName().equalsIgnoreCase( fieldName.trim() ))
					{
					BaseLogger.log("3", userInfo,editorId,"$$ planDate ["+getPlanDate()+"]--["+this.getPlanDate()+"] Cal_Comp ["+getCalComp()+"] fieldValue ["+fieldValue+"]");
					childNoe.setTextContent(fieldValue.trim());
					}*/
				
					if( argMap.containsKey( childNoe.getNodeName().trim() ) )
					{
						BaseLogger.log("3", userInfo,editorId,"$$ planDate ["+getPlanDate()+"]--["+this.getPlanDate()+"] Cal_Comp ["+getCalComp()+"]");
						childNoe.setTextContent( argMap.get( childNoe.getNodeName().trim() ));
					}
				}
			}
			xmlStr = serializeDom(document);
			BaseLogger.log("9", userInfo,editorId,"$$$--changed xml String ["+xmlStr+"]");
		} 
		catch (ITMException e) 
		{
		BaseLogger.log("0", userInfo,editorId,"Exception on add date : "+e);
		}
		return xmlStr;
	}
	
	/*private String addDateToDOM( String xmlStr )
	{
		try 
		{
			Document document = new E12GenericUtility().parseString( xmlStr );
			NodeList detailNodeList = document.getElementsByTagName("Detail1");
			Node detailNode = detailNodeList.item(0);
			NodeList detailChildList = detailNode.getChildNodes(); //to get childs of detail

			for (int i = 0; i <detailChildList.getLength(); i++)
			{
				Node childNoe = detailChildList.item(i);//selects items one by one
				if(childNoe.getNodeType() == Node.ELEMENT_NODE && !"attribute".equalsIgnoreCase(childNoe.getNodeName()))
				{
					BaseLogger.log("3", userInfo,editorId,"NodeName-"+childNoe.getNodeName());
					//BaseLogger.log("3", userInfo,editorId,"1348---$$$$$$$$$$$$$ planDate ["+getPlanDate()+"]--["+this.getPlanDate()+"]");	
					if( childNoe.getNodeName().equalsIgnoreCase("plan_date"))
					{
						BaseLogger.log("3", userInfo,editorId,"$$ planDate ["+getPlanDate()+"]--["+this.getPlanDate()+"] Cal_Comp ["+getCalComp()+"]");
						childNoe.setTextContent(getPlanDate());
					}
				}
			}
			xmlStr = serializeDom(document);
			BaseLogger.log("3", userInfo,editorId,"$$$--changed xml String ["+xmlStr+"]");
		} 
		catch (ITMException e) 
		{
			BaseLogger.log("3", userInfo,editorId,"Exception on add date : "+e);
		}
		return xmlStr;
	}*/
	//Added BY Suraj on 18-11-2016 [To set plan date for GWT Editor in Calendar]End
	//This will execute only for the child
	private void addChildAddDom()throws Exception
	{
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]In addChildAddDom  . . . . . . "); //$NON-NLS-1$
		Document childAddDom = null;
		//Changed by Pragyan 24/01/08 [passing User Info to implement resource modifier ].
		//String childDomStr = this.masterDataStateful.getBlankDomForAdd(this.objName, this.objContext, this.pageContext, this.taxList);
		
		//Changed by MOnif on 18/03/09[To Add Details from Instance if present in Hashmap].Start
		//String childDomStr = this.masterDataStateful.getBlankDomForAdd(this.objName, this.objContext, this.pageContext, this.taxList,this.userInfo.toString());
		String childDomStr = null;
		if ( this.defaultXmlDomForDetail == null )
		{
			this.defaultXmlDomForDetail = new HashMap();
		}		
		String detailKeyForXmlDom = this.objName +"_"+ Integer.toString( Integer.parseInt( this.objContext ) - 2 ); //$NON-NLS-1$
		if ( ! this.defaultXmlDomForDetail.containsKey( detailKeyForXmlDom ) )
		{
			//Changed by Prasad on 05/05/16 [Editor option added for Property Editor] START
			//childDomStr = this.masterDataStateful.getBlankDomForAdd(this.objName, this.objContext, this.pageContext, this.taxList,this.userInfo.toString());
			//Changed by Sandeep S. on 23/05/16 [To set any default data when adding new detail] Start
			//Changed by Prasad on 17/03/18 [formName implementation in transaction editor] START
			String formName = getObjPropValue( this.objContext, "FORM_NAME" );
			if( this.localEditFlag.equalsIgnoreCase("A"))
			{
				childDomStr = this.masterDataStateful.getBlankDomForAdd(this.objName, this.objContext, "2", this.taxList,this.userInfo.toString(), this.getEditor(), formName );
			}
			else
			{
				childDomStr = this.masterDataStateful.getBlankDomForAdd(this.objName, this.objContext, this.pageContext, this.taxList,this.userInfo.toString(), this.getEditor(), formName );
			}
			//Changed by Prasad on 17/03/18 [formName implementation in transaction editor] END
			//childDomStr = this.masterDataStateful.getBlankDomForAdd(this.objName, this.objContext, this.pageContext, this.taxList,this.userInfo.toString(), this.getEditor());
			//Changed by Sandeep S. on 23/05/16 [To set any default data when adding new detail] End
			//Changed by Prasad on 05/05/16 [Editor option added for Property Editor] END
			this.defaultXmlDomForDetail.put( detailKeyForXmlDom, childDomStr );
		}
		childDomStr = (String)this.defaultXmlDomForDetail.get( detailKeyForXmlDom );
		//Changed by MOnif on 18/03/09[To Add Details from Instance if present in Hashmap].End

		this.currRecordNode = null;
		this.currTaxNode = null;
		appendToDom(this.detailDom, parseString(childDomStr), this.objContext);
		updateNewDom("A"); //$NON-NLS-1$
		this.isCurrentDetailValidated = false;
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]addChildAddDom  completed . . . . . . "); //$NON-NLS-1$
	}

	public String getXMLDataForBrow(String objContext, boolean refreshMode, String colName, String order, String dataType)throws RemoteException, ITMException
	{
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]Brow dom for objContext :"+objContext+": refreshMode :"+refreshMode+":"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		String browXMLStr = null;
		Date startTime = new Date();
		try
		{
			//Added by shrutika on 03-12-18 [Start] for updateEventLog.
			if("".equals(this.getEditorId()))
			{
				this.editorId = "" + new Date().getTime();
			}
			if( userInfo != null )
			{
				//Change by shrutika on 05-01-19 for add exception.
				userEventLogEJB.setEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(), this.getEditorId(), ( String )this.headerInfoMap.get( "action" ) , "load_form_"+this.objContext, startTime, null ,"EventContext:[" + currentEventContext + "]" , this.headerPKFieldValues,"Pending","SA","");
			}
			//Added by shrutika on 03-12-18 [End] for updateEventLog.
			this.pageContext = "1"; //$NON-NLS-1$
			this.objContext = objContext;
			this.eventManager.setUserInfo(this.userInfo);//Added by vinayak on 17-Jun-2016 to set userInfo
			if(Integer.parseInt(this.objContext) == 1)
			{
				if(this.headerListDom == null || refreshMode)
				{
					createHeaderListDom();
				}
				browXMLStr = serializeDom(this.headerListDom);
			}
			else if(Integer.parseInt(this.objContext) > 1)
			{
				//DDD
				/*
				if(this.detailDom == null)
				{
					//BaseLogger.log("3", userInfo,editorId,"5555555 Calling creation of  D E T A I L  D O M 55555555");
					//createDetailDom();
				}
				*/
				if(this.detailDom !=null)
				{
					NodeList detailList = searchNodes(this.detailDom, this.objContext);
					int detailListLength = detailList.getLength();
					if(detailListLength == 0)
					{
						//This exclusive case is for Auto-Stock i.e; if brow itself is editable and 
						//Changed by Monif on 11/17/2008 [To make eventManager object as Local [As per KB.]
						//String detailXMLStr = this.eventManager.executeSystemEvent(this.objName, "load_form_" + this.objContext, currentEventContext, null, this.detailDom, getXtraParams(), this.detailDomId );
						//Changed by Monif on 6/2/2009 [Reverting Back [As per KB.]
						//String detailXMLStr = getEventManager().executeSystemEvent(this.objName, "load_form_" + this.objContext, currentEventContext, null, this.detailDom, getXtraParams(), this.detailDomId );
						//changes done By Shahu Mali on  09-10-13.[WS3GBAS001] for multiDB connection : START
						String transDB = this.userInfo.getTransDB();
						String detailXMLStr = "";
						//Changed by Prasad on 17/03/18 [formName implementation in transaction editor] START
						String formName = getObjPropValue( this.objContext, "FORM_NAME" );
						if(transDB != null && !"null".equalsIgnoreCase(transDB) && transDB.trim().length() > 0)
						{
							detailXMLStr = this.eventManager.executeSystemEvent(this.objName, "load_form_" + this.objContext, currentEventContext, null, this.detailDom, getXtraParams(), this.detailDomId, formName, this.userInfo ); //$NON-NLS-1$
						}
						else
						{
							detailXMLStr = this.eventManager.executeSystemEvent(this.objName, "load_form_" + this.objContext, currentEventContext, null, this.detailDom, getXtraParams(), this.detailDomId, formName ); //$NON-NLS-1$
						}
						//Changed by Prasad on 17/03/18 [formName implementation in transaction editor] END
						//changes done By Shahu Mali on  09-10-13.[WS3GBAS001] for multiDB connection : END
						if(detailXMLStr != null && detailXMLStr.trim().length() > 0)
						{
							appendToDom(this.detailDom, parseString(detailXMLStr), this.objContext);
							detailList = searchNodes(this.detailDom, objContext); 
							detailListLength = detailList.getLength();
						}
					}
					StringBuffer tempStringBuff = new StringBuffer();
					for(int ctr = 0; ctr < detailListLength; ctr++)
					{
						tempStringBuff.append(serializeDom(detailList.item(ctr)));
					}
					browXMLStr = getNormalizedString(tempStringBuff.toString());
				}
			}
			browXMLStr = addSortTags(browXMLStr, colName, order, dataType);
			// Added by Raju K on 02-05-14 for Event log and Transaction lock as per danish sir START--
			//Added By Mahesh Patidar on 01/AUG/13[WI3DSUN001|to log the user event activity log]
			if( userInfo != null )
			{
				//Change by shrutika on 03-12-18 for updateEventLog.
				//userEventLogEJB.setEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(), this.getEditorId(), ( String )this.headerInfoMap.get( "action" ) , "load_form_"+this.objContext, startTime, new Date(),"EventContext:[" + currentEventContext + "]" , this.headerPKFieldValues);
				//Change by shrutika on 05-01-19 for add exception.
				userEventLogEJB.updateEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(), this.getEditorId(), ( String )this.headerInfoMap.get( "action" ) , "load_form_"+this.objContext, startTime, new Date(),"EventContext:[" + currentEventContext + "]" , this.headerPKFieldValues,"Success","SA","");
			}
			else
			{
				BaseLogger.log("3", userInfo,editorId," ============ User info is null then never create event log in getXMLDataForBrow() method and MasterStatefulEJB.java file ");
			}
			//Added By Mahesh Patidar on 01/AUG/13[WI3DSUN001|to log the user event activity log]
			// Ended by Raju K on 02-05-14 for Event log and Transaction lock as per danish sir END--
		}
		catch(Exception e)
		{
			//Added by shrutika on 25-12-18 [Start] for update status as Exception.
			if( userInfo != null )
			{
				//change by shrutika on 22-01-19 for parsing issue for writePrintStacktrace in updateEventLog.
				ITMException ie = new ITMException(e);
				userEventLogEJB.updateEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(), this.getEditorId(), ( String )this.headerInfoMap.get( "action" ) , "load_form_"+this.objContext, startTime, new Date(),"EventContext:[" + currentEventContext + "]" , this.headerPKFieldValues,"Exception","SA",ie.getMessage());
			}
			//Added by shrutika on 25-12-18 [End] for update status as Exception.
			BaseLogger.log("0", userInfo,editorId,"Exception: MasterStatefulEJB: getXMLDataForBrow:==>\n"+e); //$NON-NLS-1$
			e.printStackTrace();
			throw new ITMException(e);
		}
		BaseLogger.log("2", userInfo,editorId,"\t\tXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"); //$NON-NLS-1$
//		BaseLogger.log("3", userInfo,editorId,"Brow Xml String :\n"+browXMLStr);
//		BaseLogger.log("3", userInfo,editorId,"\t\tXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
		return browXMLStr;
	}

	public String getXMLDataForDetail(String objContext, String editFlag, String domId)throws RemoteException,ITMException
	{
		//BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB]Detail dom for objContext :"+objContext+": editFlag :"+editFlag+": domId :"+domId+": ");
		String detailXMLStr = null;
		boolean isHeaderFocusChanged = false;
		try
		{
			setAuditTrailOpt();
			BaseLogger.log("3", userInfo,editorId,"AUDIT ["+this.auditTrailOpt+"]");
			//Setting the pageContext as 2 forcibly.
			this.pageContext = "2"; //$NON-NLS-1$

			//Setting the objContext based on the request.
			this.objContext = objContext;
			
			//Setting the globalEditFlag and localEditFlag based on the request and current objContext 
			if(Integer.parseInt(this.objContext.trim()) == 1)
			{
				if (editFlag != null && editFlag.length() > 0)
				{
					this.editFlag = editFlag;
					this.localEditFlag = editFlag;
				}
			}
			else
			{
				if (editFlag != null && editFlag.length() > 0)
				{
					this.localEditFlag = editFlag;
				}
			}

			//Setting the domId based on the request and current objContext
			if( Integer.parseInt( this.objContext.trim() ) == 1)
			{
				if( ! this.editFlag.equalsIgnoreCase( "A" ) ) //$NON-NLS-1$
				{
					if( ! this.viewDomId.equalsIgnoreCase(domId))
					{
						isHeaderFocusChanged = true;
					}
					this.viewDomId = domId;
				}
				else
				{
					if(! this.viewDomId.equalsIgnoreCase("-1")) //$NON-NLS-1$
					{
						isHeaderFocusChanged = true;
					}
					this.viewDomId = "-1"; //$NON-NLS-1$
				}
				this.headerDomId = "1"; //$NON-NLS-1$
				this.detailDomId = "-1"; //$NON-NLS-1$
			}
			else
			{
				if( this.localEditFlag.equalsIgnoreCase( "A" ) )  //$NON-NLS-1$
				{
					//In this condition, this.detailDomId 
					//has been set at the time of creation of the new child dom to avoid calculation of number of existing records.
				}
				else
				{
					this.detailDomId = domId;
				}
			}

			//Creation of detail dom
			if( Integer.parseInt( this.objContext.trim() ) == 1 )
			{
				if( this.detailDom == null || isHeaderFocusChanged )
				{
					if ( ! this.editFlag.equalsIgnoreCase( "A" ) ) //$NON-NLS-1$
					{
						//DDDD Check in case of this.keyFlag == M, this.headerPKFieldValues need to be assigned at the time of validation of the first form(this.objContext == 1)
						setHeaderPKFieldValues();
					}
					else if ( this.editFlag.equalsIgnoreCase( "A" ) ) //$NON-NLS-1$
					{
						this.headerPKFieldValues = null;
					}
					
					//Changed by Dhruv on 18/07/2006 to set Audit Trail option.
					/*if ( this.editFlag.equalsIgnoreCase( "E" ) ) //$NON-NLS-1$
					{
						setAuditTrailOpt();
					}*/
					//Changed by Dhruv on 18/07/2006 to check ediatbility based on TRANSETUP.EDIT_OPT
					//Changed by Sandeep on 14-APR-16 [[S15LSUN004] New interface for Wizard and Editor] Start
					// added by mahesh saggam on 9-DEC-19 [In case confirmed, cancelled or edit expression failed, separate message to be given to the user] Start
					//if ( ( ( ! this.editFlag.equalsIgnoreCase("V") ) &&  (! this.editFlag.equalsIgnoreCase("A") ) ) && ! isEditable() && this.editExpr != null) //$NON-NLS-1$
					if ( ( ( ! this.editFlag.equalsIgnoreCase("V") ) &&  (! this.editFlag.equalsIgnoreCase("A") ) ) && ! isEditable() ) //$NON-NLS-1$
					{
						//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - start
						if( isClose )
						{
							int count = Integer.parseInt(dbAccess.getDBColumnValue("MESSAGES", "COUNT(0)", "MSG_NO = 'NOEDITL'"));
							if( count > 0 )
							{
								String message  = dbAccess.getDBColumnValue("MESSAGES", "MSG_STR", "MSG_NO = 'NOEDITL'");
								String messageDescr  = dbAccess.getDBColumnValue("MESSAGES", "MSG_DESCR", "MSG_NO = 'NOEDITL'");
							    return "<DocumentRoot><Message>"+message+"<br>"+messageDescr+"</Message></DocumentRoot>";
							}
							else
							{
								return "<DocumentRoot><Message>"+Messages.getString("MasterStatefulEJB_selectedTransaction") + this.headerPKFieldValues + Messages.getString("MasterStatefulEJB_modifyTransaction")+"</Message></DocumentRoot>"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
							}
						}
						else if( isCancel )
						{
							int count = Integer.parseInt(dbAccess.getDBColumnValue("MESSAGES", "COUNT(0)", "MSG_NO = 'NOEDITX'"));
							if( count > 0 )
							{
								String message  = dbAccess.getDBColumnValue("MESSAGES", "MSG_STR", "MSG_NO = 'NOEDITX'");
								String messageDescr  = dbAccess.getDBColumnValue("MESSAGES", "MSG_DESCR", "MSG_NO = 'NOEDITX'");
							    return "<DocumentRoot><Message>"+message+"<br>"+messageDescr+"</Message></DocumentRoot>";
							}
							else
							{
								return "<DocumentRoot><Message>"+Messages.getString("MasterStatefulEJB_selectedTransaction") + this.headerPKFieldValues + Messages.getString("MasterStatefulEJB_modifyTransaction")+"</Message></DocumentRoot>"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
							}
						}
						else if( isConfirm )
						{
							int count = Integer.parseInt(dbAccess.getDBColumnValue("MESSAGES", "COUNT(0)", "MSG_NO = 'NOEDITC'"));
							if( count > 0 )
							{
								String message  = dbAccess.getDBColumnValue("MESSAGES", "MSG_STR", "MSG_NO = 'NOEDITC'");
								String messageDescr  = dbAccess.getDBColumnValue("MESSAGES", "MSG_DESCR", "MSG_NO = 'NOEDITC'");
							    return "<DocumentRoot><Message>"+message+"<br>"+messageDescr+"</Message></DocumentRoot>";
							}
							else
							{
								return "<DocumentRoot><Message>"+Messages.getString("MasterStatefulEJB_selectedTransaction") + this.headerPKFieldValues + Messages.getString("MasterStatefulEJB_modifyTransaction")+"</Message></DocumentRoot>"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
							}
						}
						else if( isNonEditable )
						{
							int count = Integer.parseInt(dbAccess.getDBColumnValue("MESSAGES", "COUNT(0)", "MSG_NO = 'NOEDITO'"));
							if( count > 0 )
							{
								String message  = dbAccess.getDBColumnValue("MESSAGES", "MSG_STR", "MSG_NO = 'NOEDITO'");
								String messageDescr  = dbAccess.getDBColumnValue("MESSAGES", "MSG_DESCR", "MSG_NO = 'NOEDITO'");
							    return "<DocumentRoot><Message>"+message+"<br>"+messageDescr+"</Message></DocumentRoot>";
							}
							else
							{
								return "<DocumentRoot><Message>"+Messages.getString("MasterStatefulEJB_selectedTransaction") + this.headerPKFieldValues + Messages.getString("MasterStatefulEJB_modifyTransaction")+"</Message></DocumentRoot>"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
							}
						}
						//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - end
					}
					// added by mahesh saggam on 9-DEC-19 [In case confirmed, cancelled or edit expression failed, separate message to be given to the user] End
					//Commented By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - start
					/*else if ( ( ( ! this.editFlag.equalsIgnoreCase("V") ) &&  (! this.editFlag.equalsIgnoreCase("A") ) ) && ! isEditable() ) //$NON-NLS-1$
					{
						return "<DocumentRoot><Message>"+Messages.getString("MasterStatefulEJB_selectedTransaction") + this.headerPKFieldValues + Messages.getString("MasterStatefulEJB_notEditable")+"</Message></DocumentRoot>"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
					}*/
					//Commented By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - end
					//Changed by Sandeep on 14-APR-16 [[S15LSUN004] New interface for Wizard and Editor] End
					/*
					if ( ( ! this.editFlag.equalsIgnoreCase("V")) && isConfirmed() )
					{
						return "<DocumentRoot><Message>The selected transaction " + this.headerPKFieldValues + " has already been confirmed.<br/>So, cannot be edited</Message></DocumentRoot>";
					}
					else if ( ( ! this.editFlag.equalsIgnoreCase("V")) && isWorkflowPending() )
					{
						return "<DocumentRoot><Message>The selected transaction " + this.headerPKFieldValues + " has already been initiated for WorkFlow.<br/>So, cannot be edited</Message></DocumentRoot>";
					}
					*/
					else
					{
						createDetailDom();
					}
				}
			}
			else
			{
				if( this.localEditFlag.equalsIgnoreCase("A"))  //$NON-NLS-1$
				{
					addChildAddDom();
				}
			}
			//Creation of currRecordNode
			//Changed by Prasad on 02/11/16 [to search node from dbId]
			//this.currRecordNode = searchNode( this.detailDom, this.objContext, ( ( Integer.parseInt( this.objContext.trim() ) == 1 ) ? this.headerDomId : this.detailDomId ) );
			this.currRecordNode = searchNode( this.detailDom, this.objContext, ( ( Integer.parseInt( this.objContext.trim() ) == 1 ) ? this.headerDomId : this.detailDomId ), "" );
			//Creation of currTaxNode
			if (isTaxApplicable())
			{
				this.currTaxNode = getCurrTaxNode();
			}
			setFocus();
			detailXMLStr = getNormalizedString( serializeDom( this.currRecordNode ) );
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :getXMLDataForDetail :==>\n"+e); //$NON-NLS-1$
			e.printStackTrace();
			throw new ITMException(e);
		}
		BaseLogger.log("2", userInfo,editorId,"\t\tXXXXXXXEdit XML StartXXXXXXXXX"); //$NON-NLS-1$
		//BaseLogger.log("3", userInfo,editorId,"Edit XML String :\n"+detailXMLStr);
		BaseLogger.log("2", userInfo,editorId,"\t\tXXXXXXXEdit XML EndXXXXXXXXX"); //$NON-NLS-1$
		return detailXMLStr;
	}
	
	//This is for ItemChange
	public String applyItemChange( String xmlStr ) throws RemoteException, ITMException
	{
		Date startTime = new Date();
		//BaseLogger.log("3", userInfo,editorId, "[MasterStatefulEJB]In applyItemChange. . . . . . . with xmlStr :[" + xmlStr + "]" );
		String returnValue = ""; //$NON-NLS-1$
		try
	    {
			String[] inputArr = { "INPUT_STR", xmlStr }; //$NON-NLS-1$
			debug( "ItemChange", inputArr, "1" ); //$NON-NLS-1$ //$NON-NLS-2$
			updateHeaderInfoMap( xmlStr );
			this.eventManager.setUserInfo(this.userInfo);//Added by vinayak on 17-Jun-2016 to set userInfo

			if( this.currRecordNode == null )
			{
				//Changed by Prasad on 02/11/16 [to search node from dbId]
				//this.currRecordNode = searchNode( this.detailDom, this.objContext, ( ( Integer.parseInt( this.objContext.trim() ) == 1 ) ? this.headerDomId : this.detailDomId ) );
				this.currRecordNode = searchNode( this.detailDom, this.objContext, ( ( Integer.parseInt( this.objContext.trim() ) == 1 ) ? this.headerDomId : this.detailDomId ), this.currDbID );
			}
			
			//Changed by Dhruv on 04/04/2007 to stop itemchange invocation if the record on whicvh item change is to be performed doesn't exist in the current dom.Start
			//if( this.currRecordNode == null )
			//{
			//	throw new Exception( "Invalid item change context for focussed column :["+(String)this.headerInfoMap.get("focusedColumn")+"]" );
			//}
			//Changed by Dhruv on 04/04/2007 to stop itemchange invocation if the record on whicvh item change is to be performed doesn't exist in the current dom.End

			this.changedDataMap = new TreeMap();
			Document changedStrDom = parseString(xmlStr);
			if( ( ( Boolean )this.headerInfoMap.get( "taxInFocus" ) ).booleanValue() ) //$NON-NLS-1$
			{
				//D Check if there is a call for itemChange while tax isin focus how does the screen get refreshed or atleast the updated data is sent back to client
				handleItemChange( xmlStr );
				this.changedDataMap.clear();//Rajesh 19-10-2005
				BaseLogger.log("3", userInfo,editorId, "[MasterStatefulEJB] reCalculating tax  ..........." + this.detailDomId ); //$NON-NLS-1$
				//returnValue = recalculateTax();
				BaseLogger.log("3", userInfo,editorId,"xmlStr ["+xmlStr+"] this.detailDomId ["+this.detailDomId+"]");
				if( ( "1".equalsIgnoreCase( this.detailDomId ) && xmlStr.indexOf( "<tax_perc>" ) != -1 || xmlStr.indexOf( "<TAX_PERC>" ) != -1 )
						&& xmlStr.indexOf( "TAX_ON_ALL_DETAILS" ) != -1)
				{	
					returnValue = applyTaxPercToAllDetail( xmlStr );
				}
				returnValue = recalculateTax();
			}
			else
			{
				handleItemChange( xmlStr );
				this.changedDataMap.clear();
				overWriteDefault = "0"; //$NON-NLS-1$
				//Only to retain the data as recieved from client side not using it
				this.focussedColumn = (String)this.headerInfoMap.get("focusedColumn"); //$NON-NLS-1$
				this.currentEventContext = this.objContext + COLUMN_SEPARATOR + this.focussedColumn;
				
				//D This part of the code is not in use as there is no 'pre_item_change' in the system currently, when used has to be ensured to be done in the same way as 'post_item_change'
				//this.eventManager.executeSystemEvent(this.objName, "pre_item_change", currentEventContext, parseString(xmlStr), this.detailDom, getXtraParams(), this.domId);
				
				if( this.focussedColumn != null && this.focussedColumn.length() > 0 )
				{
					//Changed by Monif on 11/17/2008 [To make eventManager object as Local [As per KB.]
					//returnValue = this.eventManager.executeSystemEvent( this.objName, "post_item_change", currentEventContext, parseString( xmlStr ), this.detailDom, getXtraParams(), ( Integer.parseInt( this.objContext.trim() ) == 1 ) ? this.headerDomId : this.detailDomId );
					//Changed by Monif on 6/2/2009 [Reverting Back and writing Log[As per KB.]Start
					//returnValue =  getEventManager().executeSystemEvent( this.objName, "post_item_change", currentEventContext, parseString( xmlStr ), this.detailDom, getXtraParams(), ( Integer.parseInt( this.objContext.trim() ) == 1 ) ? this.headerDomId : this.detailDomId );
					//changes done By Shahu Mali on  09-10-13.[WS3GBAS001] for multiDB connection : START
					String transDB = this.userInfo.getTransDB();
					//Changed by Prasad on 17/03/18 [formName implementation in transaction editor] START
					String formName = getObjPropValue( this.objContext, "FORM_NAME" );
					//Changed By Pankaj T. on 22-03-19 for if connection is pass from processRequset then pass same connection to validation & itemChmage - start
					if( this.dbSaveConn_doNotUse != null )
					{
						if(transDB != null && !"null".equalsIgnoreCase(transDB) && transDB.trim().length() > 0)
						{
							returnValue = this.eventManager.executeSystemEvent( this.objName, "post_item_change", currentEventContext, parseString( xmlStr ), this.detailDom, getXtraParams(), ( Integer.parseInt( this.objContext.trim() ) == 1 ) ? this.headerDomId : this.detailDomId, this.dbSaveConn_doNotUse, formName, this.userInfo ); //$NON-NLS-1$
						}
						else
						{
							returnValue = this.eventManager.executeSystemEvent( this.objName, "post_item_change", currentEventContext, parseString( xmlStr ), this.detailDom, getXtraParams(), ( Integer.parseInt( this.objContext.trim() ) == 1 ) ? this.headerDomId : this.detailDomId, this.dbSaveConn_doNotUse, formName ); //$NON-NLS-1$
						}
					}
					else
					{
						if(transDB != null && !"null".equalsIgnoreCase(transDB) && transDB.trim().length() > 0)
						{
							returnValue = this.eventManager.executeSystemEvent( this.objName, "post_item_change", currentEventContext, parseString( xmlStr ), this.detailDom, getXtraParams(), ( Integer.parseInt( this.objContext.trim() ) == 1 ) ? this.headerDomId : this.detailDomId, formName, this.userInfo ); //$NON-NLS-1$
						}
						else
						{
							returnValue = this.eventManager.executeSystemEvent( this.objName, "post_item_change", currentEventContext, parseString( xmlStr ), this.detailDom, getXtraParams(), ( Integer.parseInt( this.objContext.trim() ) == 1 ) ? this.headerDomId : this.detailDomId, formName ); //$NON-NLS-1$
						}
					}
					//Changed By Pankaj T. on 22-03-19 for if connection is pass from processRequset then pass same connection to validation & itemChmage - end
					//Changed by Prasad on 17/03/18 [formName implementation in transaction editor] END
					//changes done By Shahu Mali on  09-10-13.[WS3GBAS001] for multiDB connection : END
					//Changed by Nilesh Soor on 25/07/2014 [As per Kandarp Sir : It is not required now as its done to identify issue of "One user data is getting shared to another user"]
					/*if( "2".equals( CommonConstants.USER_LOG ) ) //$NON-NLS-1$
					{
						BaseLogger.log("3", userInfo,editorId,"Writing Log File before Calling ItemChange"); //$NON-NLS-1$
						new ibase.webitm.utility.GenericUtility().getInstance().writeLoggerFile( this.userInfo.getLoginCode(), this.userInfo.getSiteCode(), "post_item_change", this.focussedColumn, serializeDom( this.detailDom ),xmlStr , returnValue ); //$NON-NLS-1$
					}*/
					//Changed by Monif on 6/2/2009 [Reverting Back and writing Log[As per KB.]End
				}
	
				if( returnValue != null && returnValue.length() > 0 )
				{
					if ( returnValue.indexOf( "<Errors>" ) == -1 ) //$NON-NLS-1$
					{
						handleItemChange(returnValue);
						returnValue = getChangedXMLString();
					}
					returnValue = (returnValue != null && returnValue.length() > 0)?returnValue:xmlStr;	
					Document returnDom = parseString(returnValue);
					
					NodeList wsReturnHeaderList = (returnDom.getElementsByTagName("header").item(0) ==	null)?returnDom.getElementsByTagName("Header"):returnDom.getElementsByTagName("header"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
					int wsReturnHeaderListLen = wsReturnHeaderList.getLength();
					if( wsReturnHeaderListLen > 0)
					{
						for (int ctr = 0; ctr < wsReturnHeaderListLen; ctr++)
						{
							NodeList headerNodeList = changedStrDom.getElementsByTagName("header"); //$NON-NLS-1$
							int headerNodeListLen = headerNodeList.getLength();
							for (int i = 0; i < headerNodeListLen; i++)
							{
								Node currHeader = headerNodeList.item(i);
								Node updatedNode = returnDom.importNode(currHeader, true);
								(returnDom.getDocumentElement()).replaceChild(updatedNode, wsReturnHeaderList.item(ctr));
							}
						}
					}
					else
					{
						NodeList headerNodeList = changedStrDom.getElementsByTagName("header"); //$NON-NLS-1$
						int headerNodeListLen = headerNodeList.getLength();

						for (int j = 0; j < headerNodeListLen; j++)
						{
							Node currHeader = headerNodeList.item(j);
							Node importedNode = returnDom.importNode(currHeader, true);
							(returnDom.getDocumentElement()).appendChild(importedNode);
						}
					}
					returnValue = serializeDom( returnDom );
				}
				else
				{
					//D check what needs to be assigned to returnValue if event manager returns null or empty string
				}
				if(!(((Boolean)this.headerInfoMap.get("taxInFocus")).booleanValue())) //$NON-NLS-1$
				{
					isRecordValidated = false;
				}
			}
			this.changedDataMap.clear();
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulException :applyItemChange :==>\n"+e.getMessage()); //$NON-NLS-1$
			e.printStackTrace();
			debug( "ItemChange :Exception", null, e.getMessage() ); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			debug( "ItemChange", null, returnValue ); //$NON-NLS-1$
		}
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]applyItemChange  completed . . . . . . "); //$NON-NLS-1$
		return returnValue;
	}

	private String itemChanged(String xmlStr)
	{
		return ""; //$NON-NLS-1$
	}

	public String updateDetailDom( String xmlStr ) throws RemoteException, ITMException
	{
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]In updateDetailDom . . . . . . "); //$NON-NLS-1$
		String wsReturnValue = ""; //$NON-NLS-1$
		String valDataReturnVal = ""; //$NON-NLS-1$
		String retString = ""; //$NON-NLS-1$
		String forcedSaveFlag = "false"; //$NON-NLS-1$
		String xmlStrEditFlag = null;
		String xmlStrKeyValue = null;
		String tempObjName = null;	
		boolean isDataError = false;
		//Changed by gayatri on 07-04-2011 [SY89SUN079][To add save and continue button in detail page]
		String isSaveNContinue = "false"; //$NON-NLS-1$

		//This variable is used to track a situation when itm_defaultedit for detail is to be performed. foll. are the cases
		//case 1 :if it is not db saving
		//case 2 :if validation of header form is done without any error/warning
		//case 3 :if validation of header form is done with only warning.
		//Changed by Dhruv on 20/07/07 to support itm_defaultedit in case of warnings.
		boolean isPermissible = true;
		try
		{
			String[] inputArr = { "INPUT_STR", xmlStr }; //$NON-NLS-1$
			debug( "ValData", inputArr, "1" ); //$NON-NLS-1$ //$NON-NLS-2$
			this.changedDataMap = new TreeMap();

			updateHeaderInfoMap( xmlStr );
			//Changed by gayatri on 07-04-2011 [SY89SUN079][To add save and continue button in detail page]
			isSaveNContinue = (String)this.headerInfoMap.get( "isSaveNConitinue" ); //$NON-NLS-1$

			String clientObjContext = ( String )this.headerInfoMap.get( "objContext" ); //$NON-NLS-1$
			forcedSaveFlag = (String)this.headerInfoMap.get( "forcedSave" ); //$NON-NLS-1$
			this.focussedColumn = (String)this.headerInfoMap.get( "focusedColumn" ); //$NON-NLS-1$
			xmlStrEditFlag = this.localEditFlag;
			this.currentEventContext = this.objContext + COLUMN_SEPARATOR + this.focussedColumn;
			if( xmlStrEditFlag != null && xmlStrEditFlag.equalsIgnoreCase( "ABORT" ) ) //$NON-NLS-1$
			{
				BaseLogger.log("3", userInfo,editorId, "[MasterStatefulEJB]Aborting current transaction......" ); //$NON-NLS-1$
				this.detailDom = null;
				this.currRecordNode = null;
				this.currTaxNode = null;
				retString = "<Root><Detail>Success</Detail></Root>"; //$NON-NLS-1$
			}
			else if( xmlStrEditFlag != null && ! xmlStrEditFlag.equalsIgnoreCase( "ABORT" ) ) //$NON-NLS-1$
			{
				//changed by Monif on 1/15/2009.[SY89DIS013].Start
				// added by mahesh saggam on 9-DEC-19 [In case confirmed, cancelled or edit expression failed, separate message to be given to the user] Start
				//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression.
				//if ( this.editFlag.equalsIgnoreCase("E") && isConfirmed() && this.editExpr != null)
				if ( this.editFlag.equalsIgnoreCase("E") && ( isClosed() || isCanceled() || isConfirmed() || isNonEditable() ) )
				{
					//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - start
					if( isClose )
					{
						int count = Integer.parseInt(dbAccess.getDBColumnValue("MESSAGES", "COUNT(0)", "MSG_NO = 'NOEDITL'"));
						if( count > 0 )
						{
							String message  = dbAccess.getDBColumnValue("MESSAGES", "MSG_STR", "MSG_NO = 'NOEDITL'");
							String messageDescr  = dbAccess.getDBColumnValue("MESSAGES", "MSG_DESCR", "MSG_NO = 'NOEDITL'");
							StringBuffer retStrBuff = new StringBuffer("<?xml version='1.0' encoding='"+this.userInfo.getCharEnc()+"'?><Errors>");
							retStrBuff.append("<error id='NOEDITL' type='E' column_name=''>");
							retStrBuff.append("<message><![CDATA["+message+"]]></message>");
							retStrBuff.append("<description><![CDATA["+messageDescr+"]]></description>");
							retStrBuff.append("<trace><![CDATA[]]></trace>");
							retStrBuff.append("<redirect>1</redirect></error></Errors>");
						    retString = retStrBuff.toString();
						}
						else
						{
							StringBuffer retStrBuff = new StringBuffer("<?xml version='1.0' encoding='"+this.userInfo.getCharEnc()+"'?><Errors>"); //$NON-NLS-1$ //$NON-NLS-2$
							retStrBuff.append("<error id='' type='E' column_name=''>"); //$NON-NLS-1$
							retStrBuff.append("<message><![CDATA["+Messages.getString("MasterStatefulEJB_transaction") + this.headerPKFieldValues + Messages.getString("MasterStatefulEJB_modifyTransaction")+"]]></message>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
							retStrBuff.append("<trace><![CDATA[]]></trace>"); //$NON-NLS-1$
							retStrBuff.append("<redirect>1</redirect></error></Errors>"); //$NON-NLS-1$
							retString = retStrBuff.toString();
						}
					}
					else if( isCancel )
					{
						int count = Integer.parseInt(dbAccess.getDBColumnValue("MESSAGES", "COUNT(0)", "MSG_NO = 'NOEDITX'"));
						if( count > 0 )
						{
							String message  = dbAccess.getDBColumnValue("MESSAGES", "MSG_STR", "MSG_NO = 'NOEDITX'");
							String messageDescr  = dbAccess.getDBColumnValue("MESSAGES", "MSG_DESCR", "MSG_NO = 'NOEDITX'");
							StringBuffer retStrBuff = new StringBuffer("<?xml version='1.0' encoding='"+this.userInfo.getCharEnc()+"'?><Errors>");
							retStrBuff.append("<error id='NOEDITX' type='E' column_name=''>");
							retStrBuff.append("<message><![CDATA["+message+"]]></message>");
							retStrBuff.append("<description><![CDATA["+messageDescr+"]]></description>");
							retStrBuff.append("<trace><![CDATA[]]></trace>");
							retStrBuff.append("<redirect>1</redirect></error></Errors>");
						    retString = retStrBuff.toString();
						}
						else
						{
							StringBuffer retStrBuff = new StringBuffer("<?xml version='1.0' encoding='"+this.userInfo.getCharEnc()+"'?><Errors>"); //$NON-NLS-1$ //$NON-NLS-2$
							retStrBuff.append("<error id='' type='E' column_name=''>"); //$NON-NLS-1$
							retStrBuff.append("<message><![CDATA["+Messages.getString("MasterStatefulEJB_transaction") + this.headerPKFieldValues + Messages.getString("MasterStatefulEJB_modifyTransaction")+"]]></message>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
							retStrBuff.append("<trace><![CDATA[]]></trace>"); //$NON-NLS-1$
							retStrBuff.append("<redirect>1</redirect></error></Errors>"); //$NON-NLS-1$
							retString = retStrBuff.toString();
						}
					}
					else if( isConfirm )
					{
						int count = Integer.parseInt(dbAccess.getDBColumnValue("MESSAGES", "COUNT(0)", "MSG_NO = 'NOEDITC'"));
						if( count > 0 )
						{
							String message  = dbAccess.getDBColumnValue("MESSAGES", "MSG_STR", "MSG_NO = 'NOEDITC'");
							String messageDescr  = dbAccess.getDBColumnValue("MESSAGES", "MSG_DESCR", "MSG_NO = 'NOEDITC'");
							StringBuffer retStrBuff = new StringBuffer("<?xml version='1.0' encoding='"+this.userInfo.getCharEnc()+"'?><Errors>");
							retStrBuff.append("<error id='NOEDITC' type='E' column_name=''>");
							retStrBuff.append("<message><![CDATA["+message+"]]></message>");
							retStrBuff.append("<description><![CDATA["+messageDescr+"]]></description>");
							retStrBuff.append("<trace><![CDATA[]]></trace>");
							retStrBuff.append("<redirect>1</redirect></error></Errors>");
						    retString = retStrBuff.toString();
						}
						else
						{
							StringBuffer retStrBuff = new StringBuffer("<?xml version='1.0' encoding='"+this.userInfo.getCharEnc()+"'?><Errors>"); //$NON-NLS-1$ //$NON-NLS-2$
							retStrBuff.append("<error id='' type='E' column_name=''>"); //$NON-NLS-1$
							retStrBuff.append("<message><![CDATA["+Messages.getString("MasterStatefulEJB_transaction") + this.headerPKFieldValues + Messages.getString("MasterStatefulEJB_modifyTransaction")+"]]></message>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
							retStrBuff.append("<trace><![CDATA[]]></trace>"); //$NON-NLS-1$
							retStrBuff.append("<redirect>1</redirect></error></Errors>"); //$NON-NLS-1$
							retString = retStrBuff.toString();
						}
					}
					else if( isNonEditable )
					{
						int count = Integer.parseInt(dbAccess.getDBColumnValue("MESSAGES", "COUNT(0)", "MSG_NO = 'NOEDITO'"));
						if( count > 0 )
						{
							String message  = dbAccess.getDBColumnValue("MESSAGES", "MSG_STR", "MSG_NO = 'NOEDITO'");
							String messageDescr  = dbAccess.getDBColumnValue("MESSAGES", "MSG_DESCR", "MSG_NO = 'NOEDITO'");
							StringBuffer retStrBuff = new StringBuffer("<?xml version='1.0' encoding='"+this.userInfo.getCharEnc()+"'?><Errors>");
							retStrBuff.append("<error id='NOEDITO' type='E' column_name=''>");
							retStrBuff.append("<message><![CDATA["+message+"]]></message>");
							retStrBuff.append("<description><![CDATA["+messageDescr+"]]></description>");
							retStrBuff.append("<trace><![CDATA[]]></trace>");
							retStrBuff.append("<redirect>1</redirect></error></Errors>");
						    retString = retStrBuff.toString();
						}
						else
						{
							StringBuffer retStrBuff = new StringBuffer("<?xml version='1.0' encoding='"+this.userInfo.getCharEnc()+"'?><Errors>"); //$NON-NLS-1$ //$NON-NLS-2$
							retStrBuff.append("<error id='' type='E' column_name=''>"); //$NON-NLS-1$
							retStrBuff.append("<message><![CDATA["+Messages.getString("MasterStatefulEJB_transaction") + this.headerPKFieldValues + Messages.getString("MasterStatefulEJB_modifyTransaction")+"]]></message>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
							retStrBuff.append("<trace><![CDATA[]]></trace>"); //$NON-NLS-1$
							retStrBuff.append("<redirect>1</redirect></error></Errors>"); //$NON-NLS-1$
							retString = retStrBuff.toString();
						}
					}
					//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - end
				}
				// added by mahesh saggam on 9-DEC-19 [In case confirmed, cancelled or edit expression failed, separate message to be given to the user] End
				//Commented By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - start
				/*else if ( isConfirmed() )
				{	
					//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - start
					int count = Integer.parseInt(dbAccess.getDBColumnValue("MESSAGES", "COUNT(0)", "MSG_NO = 'NOEDITC'"));
					if( count > 0 )
					{
						String message  = dbAccess.getDBColumnValue("MESSAGES", "MSG_STR", "MSG_NO = 'NOEDITC'");
						String messageDescr  = dbAccess.getDBColumnValue("MESSAGES", "MSG_DESCR", "MSG_NO = 'NOEDITC'");
						StringBuffer retStrBuff = new StringBuffer("<?xml version='1.0' encoding='"+this.userInfo.getCharEnc()+"'?><Errors>");
						retStrBuff.append("<error id='NOEDITC' type='E' column_name=''>");
						retStrBuff.append("<message><![CDATA["+message+"]]></message>");
						retStrBuff.append("<description><![CDATA["+messageDescr+"]]></description>");
						retStrBuff.append("<trace><![CDATA[]]></trace>");
						retStrBuff.append("<redirect>1</redirect></error></Errors>");
					    retString = retStrBuff.toString();
					}
					else
					{
						StringBuffer retStrBuff = new StringBuffer("<?xml version='1.0' encoding='"+this.userInfo.getCharEnc()+"'?><Errors>"); //$NON-NLS-1$ //$NON-NLS-2$
						retStrBuff.append("<error id='' type='E' column_name=''>"); //$NON-NLS-1$
						retStrBuff.append("<message><![CDATA["+Messages.getString("MasterStatefulEJB_transaction") + this.headerPKFieldValues + Messages.getString("MasterStatefulEJB_hasAlreadyBeenConfirmed")+"]]></message>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
						retStrBuff.append("<description><![CDATA[ "+Messages.getString("MasterStatefulEJB_transactionCannotBeEdited")+"]]></description>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						retStrBuff.append("<trace><![CDATA[]]></trace>"); //$NON-NLS-1$
						retStrBuff.append("<redirect>1</redirect></error></Errors>"); //$NON-NLS-1$
						retString = retStrBuff.toString();
					}
					//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - end
				}*///changed by Monif on 1/15/2009.[SY89DIS013].End
				//Commented By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - end
				else
				{
					if( this.currRecordNode == null )
					{
						//Changed by Prasad on 02/11/16 [to search node from dbId]
						//this.currRecordNode = searchNode( this.detailDom, this.objContext, ( ( Integer.parseInt(this.objContext.trim() ) == 1 ) ? this.headerDomId : this.detailDomId ) );
						this.currRecordNode = searchNode( this.detailDom, this.objContext, ( ( Integer.parseInt(this.objContext.trim() ) == 1 ) ? this.headerDomId : this.detailDomId ), "" );
					}
					handleItemChange( xmlStr );
				
					//Validation reqd. only if Tax is not in focus, this might not hold true if there exists any validation based on context+tax collectively.
					if ( ! ( ( Boolean )this.headerInfoMap.get( "taxInFocus" ) ).booleanValue() ) //$NON-NLS-1$
					{
						//Changed By Manish on 27/03/07 to set HaederPkValues invariablly whether errors or warnings have come or not.Start
						if( Integer.parseInt( this.objContext.trim() ) == 1 && this.keyFlag.equalsIgnoreCase( "M" ) ) //$NON-NLS-1$
						{
							setHeaderPKFieldValues();
						}
						//Changed By Manish on 27/03/07 to set HaederPkValues invariablly whether errors or warnings have come or not.End
						
						boolean isErrorNodeFound = false ;//Gulzar on 03/01/14 to get the error type from error string
						//Changed By Pankaj T. on 23-11-18 for if no change in form then avoid detail form validation when click on Finish from feed view - start
						BaseLogger.log("3",userInfo,editorId,"MasterStatefulEJB.updateDetailDom() isFormChange:["+getIsFormChange()+"]");
						//if( ! forcedSaveFlag.equalsIgnoreCase( "true" ) && ! xmlStrEditFlag.equalsIgnoreCase( "D" ) ) //$NON-NLS-1$ //$NON-NLS-2$
						if( ! forcedSaveFlag.equalsIgnoreCase( "true" ) && ! xmlStrEditFlag.equalsIgnoreCase( "D" ) && !("false".equalsIgnoreCase(getIsFormChange())) )
						{
							valDataReturnVal = validateData(xmlStr);
							
							//Changed by Gulzar on 03/01/14 to to check the error type if error exist : START 
							isErrorNodeFound = new E12GenericUtility().isErrorNodeFound( valDataReturnVal );
							//Changed by Gulzar on 03/01/14 to to check the error type if error exist : END
						}
						else if( forcedSaveFlag.equalsIgnoreCase( "true" ) && ! xmlStrEditFlag.equalsIgnoreCase( "D" ) )
						{
							//Added By Pankaj T. on 17-02-2021 - added new attributes in detail tag valdatastat, taxcalcstat & id for  checking current record is valid or not at the time of adding new detail - start
							if( this.detailDom != null )
							{
								Node detailNode = searchNode(this.detailDom, this.objContext, this.detailDomId, this.currDbID);
								if( detailNode != null )
								{
									((Element) detailNode).setAttribute("valdatastat", "3");
			                    }
							}
							//Added By Pankaj T. on 17-02-2021 - added new attributes in detail tag valdatastat, taxcalcstat & id for  checking current record is valid or not at the time of adding new detail - end
						}
						
						BaseLogger.log("3", userInfo,editorId,"isErrorNodeFound =["+isErrorNodeFound+"]");
						
						//Commented and changed by Gulzar on 03/01/14 to calculate the tax other than error type ='E'
						//if( valDataReturnVal.indexOf( "<Errors>" ) != -1 ) //$NON-NLS-1$
						if( valDataReturnVal.indexOf( "<Errors>" ) != -1 && isErrorNodeFound ) //$NON-NLS-1$
						{
							Document returnDom = parseString( valDataReturnVal );
							//Node returnNode = returnDom.getElementsByTagName("Root").item(0);

							//Changed by Dhruv on 20/07/07 to support itm_defaultedit in case of warnings.Start
							if( returnDom != null )
							{
								NodeList errorNodeItemChgList = returnDom.getElementsByTagName( "error" ); //$NON-NLS-1$
							
								int errorNodeItemChgListLen = errorNodeItemChgList.getLength();
								for (int i=0; i < errorNodeItemChgListLen; i++)
								{
									Node errorNode = errorNodeItemChgList.item(i);									
									String itemChgErrorType = errorNode.getAttributes().getNamedItem("type").getNodeValue(); //$NON-NLS-1$
									if( ( "E" ).equals( itemChgErrorType ) ) //$NON-NLS-1$
									{
										String detailDomInfo = "<detailDomId><![CDATA[ "+this.detailDomId+" ]]></detailDomId>"; //$NON-NLS-1$ //$NON-NLS-2$
										errorNode.appendChild( errorNode.getOwnerDocument().importNode( parseString(detailDomInfo).getFirstChild(), true ) );
										//Added by Ravindra C on 08-02-19 to write Matrix And Normal Excel Errpor Information - Start
										detailDomInfo = "<objContext><![CDATA[ "+this.objContext+" ]]></objContext>";
										errorNode.appendChild( errorNode.getOwnerDocument().importNode( parseString(detailDomInfo).getFirstChild(), true ) );
										//Added by Ravindra C on 08-02-19 to write Matrix And Normal Excel Errpor Information - End
										isPermissible = false;
										break;
									}
								}
							}
							//Changed by Dhruv on 20/07/07 to support itm_defaultedit in case of warnings.End

							BaseLogger.log("3", userInfo,editorId,"valDataReturnVal ["+valDataReturnVal+"]"); //$NON-NLS-1$ //$NON-NLS-2$
							//Changed By Danish on 19/09/2006 reason [to avoid null point issue b'coz of '\n' ]

							Node returnNode = returnDom.getFirstChild();

							if ( returnNode != null )
							{
								BaseLogger.log("3", userInfo,editorId, "Getting Changes XML String for validation......." ); //$NON-NLS-1$
								String changedStr = getChangedXMLString();
								if( changedStr != null && changedStr.length() > 0 )
								{
									Document chgDoc = parseString(changedStr);
									Node chgNode = chgDoc.getElementsByTagName("Root").item(0); //$NON-NLS-1$
									if (chgNode != null )
									{
										NodeList childNodeList = chgNode.getChildNodes();
										int nodeListLength = childNodeList.getLength();
										for(int cCnt=0; cCnt < nodeListLength; cCnt++)
										{
											Node detailNode = childNodeList.item(cCnt);
											if(detailNode.getNodeType() == Node.ELEMENT_NODE)
											{
												returnNode.appendChild(returnNode.getOwnerDocument().importNode(detailNode,true));
											}
										}
									}
									else
									{
										BaseLogger.log("3", userInfo,editorId,"No Change Data Found"); //$NON-NLS-1$
									}
								}
							}
							else
							{
								BaseLogger.log("3", userInfo,editorId,"No Root Node Found"); //$NON-NLS-1$
							}//Changed By Danish on 19/09/2006
							
							retString = serializeDom( returnDom );
							isDataError = true;
						}//if( valDataReturnVal.indexOf( "<Errors>" ) != -1 )
						else
						{
							//Added by Shrutika on 09-03-18 [Start] for display prompt and warning message.
							//Commenetd by Pratheek on 22-03-18[to call the calculateTax() if propmpt appears]-Start
							//Uncomment By Pankaj T. on 17-06-2020 in case of prompt & warning return error string instead of calculateTax - start
							String isPrompt =  new E12GenericUtility().isPromptOrWarningMsg( valDataReturnVal );
							BaseLogger.log("3", userInfo,editorId,"In MasterStatefulEJB updateDetailDom isPrompt ["+isPrompt+"]");
							if("P".equalsIgnoreCase(isPrompt) || "W".equalsIgnoreCase(isPrompt))
							{
								retString = valDataReturnVal;
								isPermissible = false;
								isDataError = true;
								BaseLogger.log("3", userInfo,editorId,"valDataReturnVal retString 2218!!!!{"+valDataReturnVal+"}");
							}
							//Uncomment By Pankaj T. on 17-06-2020 in case of prompt & warning return error string instead of calculateTax - end
							//Commenetd by Pratheek on 22-03-18[to call the calculateTax() if propmpt appears]-End
							//Added by Shrutika on 09-03-18 [End] for display prompt and warning message.
							//Commenetd by Pratheek on 22-03-18[to call the calculateTax() if propmpt appears]-Start
							//Uncomment By Pankaj T. on 17-06-2020 in case of prompt & warning return error string instead of calculateTax - start
							else
							{
							//Uncomment By Pankaj T. on 17-06-2020 in case of prompt & warning return error string instead of calculateTax - end	
							//Commenetd by Pratheek on 22-03-18[to call the calculateTax() if propmpt appears]-End
								//BaseLogger.log("3", userInfo,editorId,"before calculating tax : this.editFlag : 2222!!!["+this.editFlag+"] this.localEditFlag ["+this.localEditFlag+"] xmlStrEditFlag ["+xmlStrEditFlag+"]");
								//Changed By Danish on 19/08/2006 reason [ don't calculateTax inCase of deleting too ]
								//Changed by Dhruv on 20/12/2006 stop only recalculating don't stop crossupdation.
								//if( ! this.localEditFlag.equalsIgnoreCase("V") && ! xmlStrEditFlag.equalsIgnoreCase("D") )
								if( ! this.localEditFlag.equalsIgnoreCase( "V" ) ) //$NON-NLS-1$
								{
									//	BaseLogger.log("3", userInfo,editorId, "before calculating tax : this.editFlag :["+this.editFlag+"]" );
									//Changed By Pankaj T. on 13-12-19 for When finish transaction from feed view and there in no change in form then should not go for tax calculation.
									//if( ! xmlStrEditFlag.equalsIgnoreCase( "D" ) ) //$NON-NLS-1$
									if( ! xmlStrEditFlag.equalsIgnoreCase( "D" ) && !("false".equalsIgnoreCase(getIsFormChange())) ) //$NON-NLS-1$
									{
										//Changed By Pankaj T. on 19-08-19 As per suggested by KB sir if each_rate not define in daily_exch_rate master then throw error - start
										String taxChgString = calculateTax();
										if( taxChgString != null && taxChgString.length() > 0 && taxChgString.indexOf("<Errors>") != -1)
										{
											return taxChgString;
										}
										//Changed By Pankaj T. on 19-08-19 As per suggested by KB sir if each_rate not define in daily_exch_rate master then throw error - end
										//Changed by Prasad on 02/11/16 [to search node from dbId]
										//this.currTaxNode = getCurrTaxNode( this.objContext, this.detailDomId );
										this.currTaxNode = getCurrTaxNode( this.objContext, this.detailDomId, "" );
									}
									// Added by Raju K on 23-Sep-14 for Event logger as per dnyaneshwar start--
									if( xmlStrEditFlag.equalsIgnoreCase( "D" ) )
									{
										String actionMode = "VIEW";
										//Added By Samadhan for Handling null pointer exception while simple Transation editor start
										if(editFlag != null)
										{
											//Added By Samadhan on 25/04/2016[S15LBAS001] for Handling null pointer exception while simple Transation editor end
											if( editFlag.equals("A") )
											{
												actionMode = "ADD";
											}
											else if( editFlag.equals("E") )
											{
												actionMode = "EDIT";			
											}
										}
										String pagectx = "pageContext:["+this.pageContext+"] objContext:["+this.objContext+"]";
										//userEventLogEJB.setEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), this.editorId, actionMode, "Delete", new Date(), new Date(), pagectx, this.headerPKFieldValues);
										//Change by shrutika on 03-12-18 [End] for updateEventLog.
										//Change by shrutika on 05-01-19 for add exception.
										userEventLogEJB.setEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), this.editorId, actionMode, "Delete", new Date(), new Date(), pagectx, this.headerPKFieldValues, "Success","SA","");
									}
//								Added by Raju K on 23-Sep-14 for Event logger as per dnyaneshwar end--
									crossUpdate( this.objContext, this.detailDom );
									//Changed by Dhruv on 25/07/07 to return chg string if clientObjContext != 1
									retString = getChangedXMLString();
								}
								//Commenetd by Pratheek on 22-03-18[to call the calculateTax() if propmpt appears]-Start
							//Uncomment By Pankaj T. on 17-06-2020 in case of prompt & warning return error string instead of calculateTax - start	
							}
							//Uncomment By Pankaj T. on 17-06-2020 in case of prompt & warning return error string instead of calculateTax - end
								//Commenetd by Pratheek on 22-03-18[to call the calculateTax() if propmpt appears]-End
							//Changed by Gulzar on 03/01/14 to append the error node if error exist : START 
							
							//BaseLogger.log("3", userInfo,editorId,"retString ::"+retString);
							//Added by Pratheek on 22-03-18[created new method to import node into another node]-Start
							//Commented By Pankaj T. on 17-06-2020 in case of prompt & warning return error string instead of calculateTax - start
							/*String isPrompt =  new E12GenericUtility().isPromptOrWarningMsg( valDataReturnVal );
							BaseLogger.log("3", userInfo,editorId," retString 2262!!!!{"+retString+"} isPrompt ["+isPrompt+"]");
							if ( "P".equalsIgnoreCase(isPrompt) || "W".equalsIgnoreCase(isPrompt) )
							{
								retString = new E12GenericUtility().appendErrorXMLString( valDataReturnVal, retString);
								isDataError = true;
								BaseLogger.log("3", userInfo,editorId,"inside if cond retString 2266!!!!{"+retString+"} " );
							}*/
							//Commented By Pankaj T. on 17-06-2020 in case of prompt & warning return error string instead of calculateTax - end
							//Added by Pratheek on 22-03-18[created new method to import node into another node]-End
								
							if (valDataReturnVal.indexOf( "<Errors>" ) != -1 && isErrorNodeFound)
							{
								Document returnDom = parseString( valDataReturnVal );
								
								Node returnNode = returnDom.getFirstChild();

								if ( returnNode != null )
								{
									if( retString != null && retString.length() > 0 )
									{
										Document chgDoc = parseString(retString);
										Node chgNode = chgDoc.getElementsByTagName("Root").item(0); //$NON-NLS-1$
										if (chgNode != null )
										{
											NodeList childNodeList = chgNode.getChildNodes();
											int nodeListLength = childNodeList.getLength();
											for(int cCnt=0; cCnt < nodeListLength; cCnt++)
											{
												Node detailNode = childNodeList.item(cCnt);
												if(detailNode.getNodeType() == Node.ELEMENT_NODE)
												{
													returnNode.appendChild(returnNode.getOwnerDocument().importNode(detailNode,true));
												}
											}
										}
										else
										{
											BaseLogger.log("3", userInfo,editorId,"No Change Data Found"); //$NON-NLS-1$
										}
									}//if( retString != null && retString.length() > 0 )
								}//if ( returnNode != null )
								
								retString = serializeDom( returnDom );
								isDataError = true;
								
								BaseLogger.log("3", userInfo,editorId,"retString123 :::"+retString);
								
							}//if (valDataReturnVal.indexOf( "<Errors>" ) 
							//Changed by Gulzar on 03/01/14 to append the error node if error exist : END 
						}
					}

					//Changed by Dhruv on 20/07/07 to support itm_defaultedit in case of warnings.
					//if ( ! isDataError )
					if ( ! isDataError || isPermissible )
					{
						//Changed by Pankaj on 13-Oct-16 for getting Detail1 data from DOM [Start]
//						NodeList detailList = searchNodes( this.detailDom, "1" );
//						int detailListLength = detailList.getLength();
						StringBuffer tempStringBuff = new StringBuffer();
//						for(int ctr = 0; ctr < detailListLength; ctr++)
//						{
//							tempStringBuff.append(serializeDom(detailList.item(ctr)));
//						}
						//Changes done by Suraj B on 6-June-17 for passing allform along websocket notification Start
						tempStringBuff.append(serializeDom( this.detailDom ));
						//Changes done by Suraj B on 6-June-17 for passing allform along websocket notification End
						String dataXML = E12GenericUtility.checkNull(getNormalizedString(tempStringBuff.toString()));		
						BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB] Detail1 XML : Recent Activity::[ "+dataXML+" ]");	
						//Changed by Pankaj on 13-Oct-16 for getting Detail1 data from DOM [End]
						if( this.saveLevel.equalsIgnoreCase( "1" ) && ! isDataError ) //$NON-NLS-1$
						{
							//Added By Pankaj T. on 16-06-22 to validate & calculate tax of all form records on saving if not validated - start
							retString = validateAllFormData(xmlStrEditFlag);
							BaseLogger.log("3", userInfo,editorId,"MasterStatefulEJB.updateDetailDom() validateAllFormData retString : ["+retString+"]");
							//Added By Pankaj T. on 16-06-22 to validate & calculate tax of all form records on saving if not validated - end
							if( retString.indexOf( "Errors" ) == -1 )
							{
								BaseLogger.log("3", userInfo,editorId,"2179 this.saveLevel ["+this.saveLevel+"] isDataError ["+isDataError+"]");
								this.saveLevel = "0"; //$NON-NLS-1$
								retString = save( xmlStr );
								dataXML = E12GenericUtility.checkNull(getNormalizedString(serializeDom( this.detailDom )));		
								BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB] Detail1 XML : Recent Activity after save::[ "+dataXML+" ]");
								//Changed by Dhruv to ensure that var clearing is done only if saving is successful.
								if( retString.indexOf( "Errors" ) == -1 ) //$NON-NLS-1$
								{
									this.detailDom = null;
									this.currRecordNode = null;
									this.currTaxNode = null;
									
									//Added By Suraj for infinispan implementation
									//Changed by Pankaj on 13-Oct-16 for Auto Refresh Table/Feed Data After Save [Start]
									
									//Added by Pankaj T on 03-08-17 [To use infinispan cache depends on ibase.xml configuration] Start
									//Added Pankaj T on 18-10-17 [To use infinispan cache depends on CACHE_OPT define in ibase.xml 0 = NO Cache, 1 = Internal Cache, 2 = External Cache]
									if( CommonConstants.CACHE_OPT != 0 )
									{
										try 
										{
											/*if(this.infinispanLocalObj == null)
										{
											BaseLogger.log("3", userInfo,editorId,"MasterStateFulEJB infinispanLocalObj is null.....");
											jndiProperties = new Hashtable();
											jndiProperties.put(Context.URL_PKG_PREFIXES,"org.jboss.ejb.client.naming");	   
											ctxInfi=new InitialContext(jndiProperties);
											this.infinispanLocalObj = ((InfinispanLocal)ctxInfi.lookup("ibase/InfinispanEJB/local"));
											BaseLogger.log("3", userInfo,editorId,"MasterStateFulEJB infinispanLocalObj created.....");
										}*/
											
											if( this.infinispanLocalObj != null )
											{
												BaseLogger.log("3", userInfo,editorId,"MasterStateFulEJB : Putting values inside infinispan object key ["+objName+"_"+this.headerPKFieldValues+"]");
												//this.infinispanLocalObj.putFormData( objName+"_"+this.headerPKFieldValues, dataXML );
												this.infinispanLocalObj.putFormData( objName+"_"+this.headerPKFieldValues, this.headerPKFieldNames+"~"+this.headerPKFieldValues+"~"+dataXML );//Changes by ashutosh on 3-May-2017 [to put pkname pkvalue pkname and objname]
												this.infinispanLocalObj.setUsers( E12GenericUtility.checkNull( userInfo.getLoginCode() ) );
											}
										}
										catch (Exception e) 
										{
											e.printStackTrace();
										}
									}
									else
									{
										RAHandlerTO raHandlerTO = new RAHandlerTO(this.headerPKFieldNames+"~"+this.headerPKFieldValues, userInfo.getLoginCode(), editFlag, objName, this.headerPKFieldNames+"~"+this.headerPKFieldValues+"~"+dataXML);																
										RAHandler.updateRA(E12GenericUtility.checkNull(userInfo.getLoginCode()), raHandlerTO);
									}
									//Added by Pankaj T on 03-08-17 [To use infinispan cache depends on ibase.xml configuration] End
									//Changed by Pankaj on 13-Oct-16 for Auto Refresh Table/Feed Data After Save [End]
									//Added By Suraj for infinispan implementation
								}
							}
						}
						//Changed by Dhruv on 20/07/07 to support itm_defaultedit in case of warnings.
						//else
						else if( ! this.saveLevel.equalsIgnoreCase( "1" ) && isPermissible ) //$NON-NLS-1$
						{
							//Changed by Monif on 02/07/09[To Save data on Add action if SaveFlag in Transetup is A].Start
							//Changed by gayatri on 07-04-2011 [SY89SUN079][To add save and continue button in detail page]
							//if ( this.saveFlag != null &&  "A".equalsIgnoreCase( this.saveFlag.trim() ) )
							//if ( this.saveFlag != null &&  "A".equalsIgnoreCase( this.saveFlag.trim() )|| isSaveNContinue.equalsIgnoreCase("true") )
							//changed by gayatri on 25-04-2011 [To solve null pointer exception]
							//if ( this.saveFlag != null &&  "A".equalsIgnoreCase( this.saveFlag.trim() )|| isSaveNContinue.equalsIgnoreCase("true") )
							if ( this.saveFlag != null &&  "A".equalsIgnoreCase( this.saveFlag.trim() )|| "true".equalsIgnoreCase(isSaveNContinue)  ) //$NON-NLS-1$ //$NON-NLS-2$
							{
								String retSaveDetailStr = saveDetailOnAdd( xmlStr );
								if( retSaveDetailStr.indexOf( "Errors" ) != -1 ) //$NON-NLS-1$
								{
									//Changed by Pankaj on 13-Oct-16 for Auto Refresh Table/Feed Data After Save [Start]
									RAHandlerTO raHandlerTO = new RAHandlerTO(this.headerPKFieldNames+"~"+this.headerPKFieldValues, userInfo.getLoginCode(), editFlag, objName, dataXML);																	
									RAHandler.updateRA(E12GenericUtility.checkNull(userInfo.getLoginCode()), raHandlerTO);
									//Changed by Pankaj on 13-Oct-16 for Auto Refresh Table/Feed Data After Save [End]
									return retSaveDetailStr;
								}
							}//Changed by Monif on 02/07/09[To Save data on Add action if SaveFlag in Transetup is A].End
							
							if( ! ( ( Boolean )this.headerInfoMap.get( "taxInFocus" ) ).booleanValue() ) //$NON-NLS-1$
							{
								this.isRecordValidated = true;
							}
							//Changed by Dhruv on 24/07/07 commented as the chg string is already updated in case of warnings.
							//retString = getChangedXMLString();
							//DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD

							BaseLogger.log("3", userInfo,editorId, "validation if save level != 1 value of clientObjContext :["+clientObjContext +"] xmlStrEditFlag :["+xmlStrEditFlag+"]" ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
							if( "1".equals( clientObjContext ) && "E".equalsIgnoreCase( xmlStrEditFlag ) ) //$NON-NLS-1$ //$NON-NLS-2$
							{
								ArrayList itmDefaultEditFormNoList = this.dbAccess.getITMDefaultEditFormNoList( this.objName, this.userInfo );
								BaseLogger.log("3", userInfo,editorId, "itmDefaultEditFormNoList :" + itmDefaultEditFormNoList ); //$NON-NLS-1$
								if( itmDefaultEditFormNoList != null )
								{
									//Changed by Dhruv on 25/07/07 to avoid returnDom being assigned null if detail doesn't exist and even valdata/crossupdate doesn't have a result value.
									retString = ( retString != null && retString.length() > 0 ) ? retString : "<?xml version='1.0' encoding='"+this.userInfo.getCharEnc()+"'?><Root></Root>"; //$NON-NLS-1$ //$NON-NLS-2$
									//Document returnDom = ( retString != null && retString.length() > 0 ) ? parseString( retString ) : null;
									Document returnDom = parseString( retString );

									for( int noOfForms = 0; noOfForms < itmDefaultEditFormNoList.size(); noOfForms++ )
									{
										String formNo = ( String )itmDefaultEditFormNoList.get( noOfForms );
										//Changed by Dhruv on 04/04/2007 added with if condn. to check if detail exists before invoking itm_defaultedit on a transaction.
										//Changed by Prasad on 02/11/16 [to search node from dbId]
										//this.currRecordNode = searchNode( this.detailDom, formNo, "1" ); //$NON-NLS-1$
										this.currRecordNode = searchNode( this.detailDom, formNo, "1", "" ); //$NON-NLS-1$
										if( this.currRecordNode != null )
										{
											String tempString = "<?xml version='1.0' encoding='"+this.userInfo.getCharEnc()+"'?>" //$NON-NLS-1$ //$NON-NLS-2$
														+ "<Root>" //$NON-NLS-1$
														+ "<header>" //$NON-NLS-1$
														+ "<objName><![CDATA[" + this.objName + "]]></objName>" //$NON-NLS-1$ //$NON-NLS-2$
														+ "<pageContext><![CDATA[" + this.pageContext + "]]></pageContext>" //$NON-NLS-1$ //$NON-NLS-2$
														+ "<objContext><![CDATA[" + formNo + "]]></objContext>" //$NON-NLS-1$ //$NON-NLS-2$
														+ "<editFlag><![CDATA[E]]></editFlag>" //$NON-NLS-1$
														+ "<focusedColumn><![CDATA[itm_defaultedit]]></focusedColumn>" //$NON-NLS-1$
														+ "<keyValue><![CDATA[1]]></keyValue>" //$NON-NLS-1$
														+ "<saveLevel><![CDATA[0]]></saveLevel>" //$NON-NLS-1$
														+ "<forcedSave><![CDATA[false]]></forcedSave>" //$NON-NLS-1$
														+ "</header>" //$NON-NLS-1$
														+ "</Root>"; //$NON-NLS-1$
											String defItemChangeRetValue = applyItemChange( tempString );
											//BaseLogger.log("3", userInfo,editorId, "ItmDefaultEdit defItemChangeRetValue :[" + defItemChangeRetValue + "]" );
											if( defItemChangeRetValue.indexOf( "Errors" ) == -1 ) //$NON-NLS-1$
											{
												Document defItemChangeRetDom = ( defItemChangeRetValue != null && defItemChangeRetValue.length() > 0 ) ? parseString( defItemChangeRetValue ) : null;	
												if( returnDom != null && defItemChangeRetDom != null )
												{
													//Node retDomRootNode = returnDom.getElementsByTagName( "Root" ).item( 0 );
													Node retDomRootNode = returnDom.getFirstChild();
													Node defItemChangeRootNode = defItemChangeRetDom.getElementsByTagName( "Root" ).item( 0 ); //$NON-NLS-1$
													int ctr = 0;
													Node currChgDetailNode = null;
													while( ( currChgDetailNode = ( defItemChangeRootNode.getChildNodes() ).item( ctr ) ) != null )
													{
														if( currChgDetailNode.getNodeType() == Node.ELEMENT_NODE && currChgDetailNode.getNodeName().startsWith( "Detail" ) ) //$NON-NLS-1$
														{
															retDomRootNode.appendChild( retDomRootNode.getOwnerDocument().importNode( currChgDetailNode, true ) );
														}
														ctr++;
													}//while( ( currChgDetailNode = ( defItemChangeRootNode.getChildNodes() ).item( ctr ) ) != null )
												}//if( returnDom != null && defItemChangeRetDom != null )
											}//if( defItemChangeRetValue.indexOf( "Errors" ) == -1 )
										}//if( this.currRecordNode != null )
									}//for( int noOfForms = 0; noOfForms < itmDefaultEditFormNoList.size(); noOfForms++ )
									retString = serializeDom( returnDom );
								}//if( itmDefaultEditFormNoList != null )
							}//if( "1".equals( clientObjContext ) && "E".equalsIgnoreCase( xmlStrEditFlag ) )
							this.isCurrentDetailValidated = true;
						}//else of if( this.saveLevel.equalsIgnoreCase( "1" ) )
					}//if ( ! isDataError )
				}//if isConfirmed
			}//else if( xmlStrEditFlag != null && ! xmlStrEditFlag.equalsIgnoreCase( "ABORT" ) )
			//BaseLogger.log("3", userInfo,editorId,"retString :\n"+retString);
			this.changedDataMap.clear();
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB : updateDetailDom :==>Exception"); //$NON-NLS-1$
			e.printStackTrace();
			debug( "ValData :Exception", null, retString ); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			debug( "ValData", null, retString ); //$NON-NLS-1$
		}
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]updateDetailDom  completed return string :["+retString.length()+"]"); //$NON-NLS-1$ //$NON-NLS-2$
		return retString;
	}
	
	public String abort()throws RemoteException, Exception
	{
		//DDD   Also remove focus selection from Header brow Dom
		this.detailDom = null;
		this.currRecordNode = null;
		this.currTaxNode = null;
		return "<Root><Detail>Success</Detail></Root>"; //$NON-NLS-1$
	}

	private String validateData(String xmlStr)throws ITMException
	{
		Date startTime = new Date();
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]In validateData ......"); //$NON-NLS-1$
		String wsReturnValue = ""; //$NON-NLS-1$
		String valDataReturnVal = ""; //$NON-NLS-1$
		String retString = ""; //$NON-NLS-1$
		// Added by Dnyaneshwar Chavan 20-Aug-15 [ PRIMARY_KEY tag value should not be null as per Danish Sir ] Start
		String eventResult = "Success";
		String eventType = "";
		// Added by Dnyaneshwar Chavan 20-Aug-15 [ PRIMARY_KEY tag value should not be null as per Danish Sir ] End
		StringBuffer currentRowSampleData = new StringBuffer();
		//Change by shrutika on 17-01-19 [Start] for write Exception in user activity log.
		String logAction = "";
		E12GenericUtility e12GenericUtility = new E12GenericUtility();
		try
		{
			//Changes made by Shahu on 10/10/13 [WS3GBAS001] to support multiDB connection : START
			String transDB = this.userInfo.getTransDB();
			this.eventManager.setUserInfo(this.userInfo);//Gaurav Singh on 16-MAY-16
			
			if(this.currRecordNode != null)
			{
				//Added By Pankaj T. on 17-02-2021 - added new attributes in detail tag valdatastat, taxcalcstat & id for  checking current record is valid or not at the time of adding new detail - start
				if( this.detailDom != null )
				{
					Node detailNode = searchNode(this.detailDom, this.objContext, this.detailDomId, this.currDbID);
					if( detailNode != null )
					{
						((Element) detailNode).setAttribute("valdatastat", "1");
                    }
                    addFormNameToDOM(); //Changes by Jatin M for implementation of formName attribute in DOMString for pre-save action
				}
				//Added By Pankaj T. on 17-02-2021 - added new attributes in detail tag valdatastat, taxcalcstat & id for  checking current record is valid or not at the time of adding new detail - end
				String updateFlag = ""; //$NON-NLS-1$
				NodeList colNodeList = this.currRecordNode.getChildNodes();
				//Changed By Mahesh Patidar on 20-MAY-13 [WI3BSUN001 | to get the current dom column value for error string trace]
				int sampleMaxdata = 0 ;
				for (int colCtr=0; colCtr<colNodeList.getLength(); colCtr++)
				{
					Node colNode = colNodeList.item(colCtr);
					String colName = colNode.getNodeName(); 
					if (colName.equalsIgnoreCase("attribute")) //$NON-NLS-1$
					{
						updateFlag = ((colNode.getAttributes()).getNamedItem("updateFlag")).getNodeValue(); //$NON-NLS-1$
						//break;
					}
					else
					{
						if( colNode.getFirstChild() != null && sampleMaxdata < 5 )
						{
							colName = getCapitalizedString(colName);
							currentRowSampleData.append( colName + " : " + colNode.getFirstChild().getNodeValue() + ", " );
							sampleMaxdata = sampleMaxdata + 1;
						}
					}
					
					if( sampleMaxdata >= 5 && updateFlag.length() > 0  )
					{
						break;
					}
				}
				int pos = currentRowSampleData.lastIndexOf(", ");
				if(pos != -1 && pos == (currentRowSampleData.length() - 2))
				{
					currentRowSampleData = currentRowSampleData.replace(pos, pos+2, "");
				}
				BaseLogger.log("3", userInfo,editorId,"currentRowSampleData[" + currentRowSampleData.toString() + "]");
				//Ended By Mahesh Patidar
				// Added by Raju K on 02-05-14 for Event log and Transaction lock as per danish sir START--
				//Added By Mahesh Patidar on 01/AUG/13[WI3DSUN001|to log the user event activity log]
				logAction = "EDIT";
				if( "A".equalsIgnoreCase(this.editFlag) )
				{
					logAction = "ADD";
				}
				//Ended By Mahesh Patidar on 01/AUG/13[WI3DSUN001|to log the user event activity log]
				// Ended by Raju K on 02-05-14 for Event log and Transaction lock as per danish sir END--
				if( ! updateFlag.equalsIgnoreCase( "D" ) ) //$NON-NLS-1$
				{
					//Changed by Dhruv on 06/03/2007 to validate each record forcibly in case of copied records added if/else.
					//Added By Pankaj T. on 16-06-22 to validate & calculate tax of all form records on saving if not validated
					if ( this.isCopyingRec && this.saveLevel.equalsIgnoreCase( "1" ) && !this.validateAllFormData ) //$NON-NLS-1$
					{
						//Added by shrutika on 03-12-18 [Start] for updateEventLog.
						if("".equals(this.getEditorId()))
						{
							this.editorId = ""+new Date().getTime();
						}
						//Change by shrutika on 05-01-19 for add exception.
						userEventLogEJB.setEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(), this.getEditorId(), logAction, "post_validate", startTime, null,"EventContext:[" + currentEventContext + "], currDomID:[" + ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId) + "]", ( String )this.headerPKFieldValues,"Pending","SA","");
						//Added by shrutika on 03-12-18 [End] for updateEventLog.
						Node detailNode = this.detailDom.getElementsByTagName( "Detail1" ).item( 0 ); //$NON-NLS-1$
						do
						{
							if( detailNode.getNodeType() == Node.ELEMENT_NODE &&  detailNode.getNodeName().startsWith( "Detail" ) ) //$NON-NLS-1$
							{
								String currDomID = detailNode.getAttributes().getNamedItem("domID").getNodeValue(); //$NON-NLS-1$
								String currObjCtx = detailNode.getAttributes().getNamedItem("objContext").getNodeValue(); //$NON-NLS-1$
								//Added By Pankaj T. on 24-01-19 for Prevent to change value of transetup column confirm_col,site_acc_col,emp_acc_col,cust_acc_col,supp_acc_col and sales_pers_acc_col if defined and match entity type - start
								String chkConsistencyResStr = e12GenericUtility.checkConsistency(e12GenericUtility.serializeDom(detailNode), this.userInfo, this.editorId, this.objName, currObjCtx, "T", null);
								BaseLogger.log("3", userInfo, editorId,"MasterStatefulEJB.validatedata() chkConsistencyResStr::["+chkConsistencyResStr+"]");
								if( chkConsistencyResStr != null )
								{
									boolean isErrorNodeExist = new E12GenericUtility().isErrorNodeFound( chkConsistencyResStr );
									BaseLogger.log("3", userInfo,editorId,"isErrorNodeExist in chkConsistencyResStr ["+isErrorNodeExist+"]");
									if( isErrorNodeExist )
									{
										return chkConsistencyResStr;
									}
								}
								//Added By Pankaj T. on 24-01-19 for Prevent to change value of transetup column confirm_col,site_acc_col,emp_acc_col,cust_acc_col,supp_acc_col and sales_pers_acc_col if defined and match entity type - end
								BaseLogger.log("3", userInfo,editorId,"currDomID ["+currDomID+"] currObjCtx ["+currObjCtx+"]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$

								StringBuffer hdrStrBuff = new StringBuffer();
								hdrStrBuff.append( "<Root>" ); //$NON-NLS-1$
								hdrStrBuff.append( "<header>" ); //$NON-NLS-1$
								hdrStrBuff.append( "<objName><![CDATA[" + this.objName + "]]></objName>" ); //$NON-NLS-1$ //$NON-NLS-2$
								hdrStrBuff.append( "<pageContext><![CDATA[2]]></pageContext>" ); //$NON-NLS-1$
								hdrStrBuff.append( "<editFlag><![CDATA[" + this.editFlag + "]]></editFlag>" ); //$NON-NLS-1$ //$NON-NLS-2$
								hdrStrBuff.append( "<action><![CDATA[SAVE]]></action>" ); //$NON-NLS-1$
								hdrStrBuff.append( "<elementName><![CDATA[]]></elementName>" ); //$NON-NLS-1$
								hdrStrBuff.append( "<taxKeyValue><![CDATA[]]></taxKeyValue>" ); //$NON-NLS-1$
								hdrStrBuff.append( "<taxInFocus><![CDATA[false]]></taxInFocus>" ); //$NON-NLS-1$
								hdrStrBuff.append("<objContext><![CDATA[" + currObjCtx + "]]></objContext>");												 //$NON-NLS-1$ //$NON-NLS-2$
								hdrStrBuff.append("<focusedColumn><![CDATA[]]></focusedColumn>"); //$NON-NLS-1$
								hdrStrBuff.append("<forcedSave><![CDATA[true]]></forcedSave>"); //$NON-NLS-1$
								hdrStrBuff.append("<keyValue><![CDATA["+ currDomID +"]]></keyValue>"); //$NON-NLS-1$ //$NON-NLS-2$
								if (this.wrkflwProcInstId != null && this.wrkflwProcInstId.length() > 0)
								{
									hdrStrBuff.append("<wrkflwProcInstId><![CDATA["+ this.wrkflwProcInstId+"]]></wrkflwProcInstId>"); //$NON-NLS-1$ //$NON-NLS-2$
								}
								
								hdrStrBuff.append("<saveLevel><![CDATA[1]]></saveLevel>"); //$NON-NLS-1$
								hdrStrBuff.append( "</header>" ); //$NON-NLS-1$
								hdrStrBuff.append( "</Root>" ); //$NON-NLS-1$

								//Changed by Monif on 11/17/2008 [To make eventManager object as Local [As per KB.]
								//wsReturnValue = this.eventManager.executeSystemEvent( this.objName, "pre_validate", currObjCtx + ":", parseString( hdrStrBuff.toString() ), this.detailDom, getXtraParams(), currDomID );
								//Changed by Monif on 6/2/2009 [Reverting Back [As per KB.]
								//wsReturnValue =  getEventManager().executeSystemEvent( this.objName, "pre_validate", currObjCtx + ":", parseString( hdrStrBuff.toString() ), this.detailDom, getXtraParams(), currDomID );
								//Changes made by Shahu on 10/10/13 [WS3GBAS001] to support multiDB connection : START
								//Changed by Prasad on 17/03/18 [formName implementation in transaction editor] START
								String formName = getObjPropValue( currObjCtx, "FORM_NAME" );
								//Changed By Pankaj T. on 22-03-19 for if connection is pass from processRequset then pass same connection to validation & itemChmage - start
								if( this.dbSaveConn_doNotUse != null )
								{
									if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
									{
										//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
										this.eventManager.setAction("edit");
										wsReturnValue = this.eventManager.executeSystemEvent( this.objName, "pre_validate", currObjCtx + ":", parseString( hdrStrBuff.toString() ), this.detailDom, getXtraParams(), currDomID, this.dbSaveConn_doNotUse, formName, this.userInfo ); //$NON-NLS-1$ //$NON-NLS-2$
										//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
										this.eventManager.setAction("");
									}
									else
									{
										//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
										this.eventManager.setAction("edit");
										wsReturnValue = this.eventManager.executeSystemEvent( this.objName, "pre_validate", currObjCtx + ":", parseString( hdrStrBuff.toString() ), this.detailDom, getXtraParams(), currDomID, this.dbSaveConn_doNotUse, formName ); //$NON-NLS-1$ //$NON-NLS-2$
										//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
										this.eventManager.setAction("");
									}
								}
								else
								{
									if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
									{
										//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
										this.eventManager.setAction("edit");
										wsReturnValue = this.eventManager.executeSystemEvent( this.objName, "pre_validate", currObjCtx + ":", parseString( hdrStrBuff.toString() ), this.detailDom, getXtraParams(), currDomID, formName, this.userInfo ); //$NON-NLS-1$ //$NON-NLS-2$
										//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
										this.eventManager.setAction("");
									}
									else
									{
										//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
										this.eventManager.setAction("edit");
										wsReturnValue = this.eventManager.executeSystemEvent( this.objName, "pre_validate", currObjCtx + ":", parseString( hdrStrBuff.toString() ), this.detailDom, getXtraParams(), currDomID, formName ); //$NON-NLS-1$ //$NON-NLS-2$
										//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
										this.eventManager.setAction("");
									}
								}
								//Changed By Pankaj T. on 22-03-19 for if connection is pass from processRequset then pass same connection to validation & itemChmage - end 
								//Changed by Prasad on 17/03/18 [formName implementation in transaction editor] END
								//Changes made by Shahu on 10/10/13 [WS3GBAS001] to support multiDB connection : END
								
								//Changed by Danish on 14/01/2008 [ CALLING POST_VALIDATE IF ALL ERRORS ARE WARNING IN PRE-VALIDATE ] start
								/*if( wsReturnValue != null && wsReturnValue.indexOf( "<Errors>" ) != -1 )
								{
									retString = wsReturnValue;
								}
								else
								{
									valDataReturnVal = validate();
									if( valDataReturnVal.indexOf( "<Errors>" ) != -1 )
									{
										retString = valDataReturnVal;
									}
									
									wsReturnValue = this.eventManager.executeSystemEvent( this.objName, "post_validate", currObjCtx+":", parseString( hdrStrBuff.toString() ), this.detailDom, getXtraParams(), currDomID );
									
									if( wsReturnValue != null && wsReturnValue.indexOf( "<Errors>" ) != -1 )
									{
										retString = wsReturnValue;
									}
									else
									{
										retString = "";
									}
								}*/
								/*boolean isErrorNodeFound = new ibase.webitm.utility.GenericUtility().isErrorNodeFound( wsReturnValue );
								BaseLogger.log("3", userInfo,editorId," isErrorNodeFound in save level 1 ["+ isErrorNodeFound +"]");				
								if( isErrorNodeFound  )
								{
									retString = wsReturnValue;
								}
								else
								{
									//Changed by Monif on 11/17/2008 [To make eventManager object as Local [As per KB.]
									//wsReturnValue = this.eventManager.executeSystemEvent( this.objName, "post_validate", currObjCtx+":", parseString( hdrStrBuff.toString() ), this.detailDom, getXtraParams(), currDomID );
									//Changed by Monif on 6/2/2009 [Reverting Back [As per KB.]
									//wsReturnValue =  getEventManager().executeSystemEvent( this.objName, "post_validate", currObjCtx+":", parseString( hdrStrBuff.toString() ), this.detailDom, getXtraParams(), currDomID );
									wsReturnValue = this.eventManager.executeSystemEvent( this.objName, "post_validate", currObjCtx+":", parseString( hdrStrBuff.toString() ), this.detailDom, getXtraParams(), currDomID );
									if( wsReturnValue != null && wsReturnValue.indexOf( "<Errors>" ) != -1 )
									{
										retString = wsReturnValue;
									}
									else
									{
										retString = "";
									}
								}*///Changed by Monif on 11/06/09[Reverted Back to Show warning and prompt also.]Start
								//Changed by Rupali Hande [to get both system warning -prompt- and generalized validation ].Start
								/*
								if( wsReturnValue != null && wsReturnValue.indexOf( "<Errors>" ) != -1 )
								{
									retString = wsReturnValue;
								}
								else
								{
									valDataReturnVal = validate();
									if( valDataReturnVal.indexOf( "<Errors>" ) != -1 )
									{
										retString = valDataReturnVal;
									}
									
									wsReturnValue = this.eventManager.executeSystemEvent( this.objName, "post_validate", currObjCtx+":", parseString( hdrStrBuff.toString() ), this.detailDom, getXtraParams(), currDomID );
									
									if( wsReturnValue != null && wsReturnValue.indexOf( "<Errors>" ) != -1 )
									{
										retString = wsReturnValue;
									}
									else
									{
										retString = "";
									}
								}
								*///Changed by Monif on 11/06/09[Reverted Back to Show warning and prompt also.]End
								boolean isErrorNodeExist = new E12GenericUtility().isErrorNodeFound( wsReturnValue );
								BaseLogger.log("3", userInfo,editorId,"isErrorNodeExist  1922  ["+isErrorNodeExist+"]"); //$NON-NLS-1$ //$NON-NLS-2$
								if (isErrorNodeExist)
								{
									eventResult = "Failure";// Added by Dnyaneshwar Chavan 20-Aug-15 [ PRIMARY_KEY tag value should not be null as per Danish Sir ] Start
									retString = wsReturnValue;
									//Changed By Mahesh Patidar on 20-MAY-13 [WI3BSUN001 | to append the current dom column value in error string trace]
									if( retString.indexOf( "<trace><![CDATA[]]></trace>" ) != -1 )
									{
										retString = retString.replace( "<trace><![CDATA[]]></trace>", "<trace><![CDATA["+currentRowSampleData.toString()+"]]></trace>");
									}
									
									if (  retString.indexOf( "<trace></trace>") != -1 )
									{
										retString = retString.replace( "<trace></trace>", "<trace><![CDATA["+currentRowSampleData.toString()+"]]></trace>");
									}

									if(  retString.indexOf( "<trace>") == -1 )
									{
										//retString = retString.replace( "</message>", "</message><trace><![CDATA["+currentRowSampleData.toString()+"]]></trace>");
										//Added by shrutika on 26-06-18 [start] for display trace after the description.
										if (  retString.indexOf( "<description>") != -1 )
										{
											retString = retString.replace( "</description>", "</description><trace><![CDATA["+currentRowSampleData.toString()+"]]></trace>");
										}
										else
										{
											retString = retString.replace( "</message>", "</message><trace><![CDATA["+currentRowSampleData.toString()+"]]></trace>");
										}
										//Added by shrutika on 26-06-18 [End] for display trace after the description.
									}
									//Ended By Mahesh Patidar
									//Added by gayatri on 30-09-2013 [WI3FSUN003][To break loop if error type is "E" for current node in copy transaction]
									break;
								}
								else
								{
									// Added by Raju K on 02-05-14 for Event log and Transaction lock as per danish sir START--
									//changed By Mahesh Patidar on 01/AUG/13[WI3DSUN001|to log the user event activity log]
									//startTime = new Date(); //commented by shrutika for issue in update eventlog.
									//changes done by Shahu Mali on 10-10-13 [WS3GBAS001] 
									String genValueError = "";
									//Changed by Prasad on 17/03/18 [formName implementation in transaction editor] START
									formName = getObjPropValue( this.objContext, "FORM_NAME" );
									//Changed By Pankaj T. on 22-03-19 for if connection is pass from processRequset then pass same connection to validation & itemChmage - start
									if( this.dbSaveConn_doNotUse != null )
									{
										if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
										{
											//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
											this.eventManager.setAction("edit");
											genValueError = this.eventManager.executeSystemEvent(this.objName, "post_validate", currentEventContext, parseString(xmlStr), this.detailDom, getXtraParams(), ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId), this.dbSaveConn_doNotUse, formName, this.userInfo); //$NON-NLS-1$
											//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
											this.eventManager.setAction("edit");
										}
										else
										{
											//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
											this.eventManager.setAction("edit");
											genValueError = this.eventManager.executeSystemEvent(this.objName, "post_validate", currentEventContext, parseString(xmlStr), this.detailDom, getXtraParams(), ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId), this.dbSaveConn_doNotUse, formName); //$NON-NLS-1$
											//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
											this.eventManager.setAction("");
										}
									}
									else
									{
										if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
										{
											//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
											this.eventManager.setAction("edit");
											genValueError = this.eventManager.executeSystemEvent(this.objName, "post_validate", currentEventContext, parseString(xmlStr), this.detailDom, getXtraParams(), ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId), formName, this.userInfo); //$NON-NLS-1$
											//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
											this.eventManager.setAction("edit");
										}
										else
										{
											//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
											this.eventManager.setAction("edit");
											genValueError = this.eventManager.executeSystemEvent(this.objName, "post_validate", currentEventContext, parseString(xmlStr), this.detailDom, getXtraParams(), ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId), formName); //$NON-NLS-1$
											//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
											this.eventManager.setAction("");
										}
									}
									//Changed By Pankaj T. on 22-03-19 for if connection is pass from processRequset then pass same connection to validation & itemChmage - end
									//Changed by Prasad on 17/03/18 [formName implementation in transaction editor] END
									//changes done by Shahu Mali on 10-10-13 [WS3GBAS001] : END
									retString = getErrorNodes(wsReturnValue,genValueError );
									eventResult = (new E12GenericUtility().isErrorNodeFound( retString ) ) ? "Failure" : eventResult; //Added by Dnyaneshwar Chavan on 23-Sep-15 [Store the validation information in event result tag ] 
								}
								//Changed by Rupali Hande [to get both system warning -prompt- and generalized validation ].End
								//Changed by Danish on 14/01/2008 [ CALLING POST_VALIDATE IF ALL ERRORS ARE WARNING IN PRE-VALIDATE  ] start
							}
						}
						while ( ( detailNode = detailNode.getNextSibling() ) != null );
						// Added by Raju K on 01-07-14 for Bug Fixing of start time end time[WI3DSUN001] in Event log and Transaction lock as per danish sir START--
						if( userInfo != null )
						{
							//userEventLogEJB.setEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(), this.getEditorId(), logAction, "post_validate", startTime, new Date(),"EventContext:[" + currentEventContext + "], currDomID:[" + ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId) + "]", ( String )this.headerPKFieldValues);
							//change by shrutika on 03-12-18 for updateEventLog.
							//userEventLogEJB.setEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(), this.getEditorId(), logAction, "post_validate", startTime, new Date(),"EventContext:[" + currentEventContext + "], currDomID:[" + ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId) + "]", ( String )this.headerPKFieldValues,eventResult);
							//Change by shrutika on 17-01-19 [Start] for write Exception in user activity log.
							userEventLogEJB.updateEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(), this.getEditorId(), logAction, "post_validate", startTime, new Date(),"EventContext:[" + currentEventContext + "], currDomID:[" + ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId) + "]", ( String )this.headerPKFieldValues,eventResult,"SA","");
						}
						else
						{
							BaseLogger.log("3", userInfo,editorId," ============ User info is null then never create event log in validateData() method and MasterStatefulEJB.java file ");
						}
						// Added by Raju K on 01-07-14 for Bug Fixing of start time end time[WI3DSUN001] in Event log and Transaction lock as per danish sir End--
					}
					else
					{
						//Changed by Monif on 11/17/2008 [To make eventManager object as Local [As per KB.]
						//wsReturnValue = this.eventManager.executeSystemEvent( this.objName, "pre_validate", currentEventContext, parseString(xmlStr), this.detailDom, getXtraParams(), ( ( Integer.parseInt( this.objContext.trim() ) == 1 ) ? this.headerDomId : this.detailDomId ) );
						//Changed by Monif on 6/2/2009 [Reverting Back [As per KB.]
						//wsReturnValue =  getEventManager().executeSystemEvent( this.objName, "pre_validate", currentEventContext, parseString(xmlStr), this.detailDom, getXtraParams(), ( ( Integer.parseInt( this.objContext.trim() ) == 1 ) ? this.headerDomId : this.detailDomId ) );
						// Added by Raju K on 02-05-14 for Event log and Transaction lock as per danish sir START--
						//changed By Mahesh Patidar on 01/AUG/13[WI3DSUN001|to log the user event activity log]
						//startTime = new Date(); //commented by shrutika for issue in update eventlog.

						//Added by shrutika on 03-12-18 [Start] for updateEventLog.
						if("".equals(this.getEditorId()))
						{
							this.editorId = ""+ new Date().getTime();
						}
						//Change by shrutika on 05-01-19 for add exception.
						userEventLogEJB.setEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(), this.getEditorId(), logAction, eventType, startTime, null,"EventContext:[" + currentEventContext + "], currDomId:[" + ( ( Integer.parseInt( this.objContext.trim() ) == 1 ) ? this.headerDomId : this.detailDomId ) + "]", ( String )this.headerPKFieldValues,"Pending","SA","");
						//Added by shrutika on 03-12-18 [End] for updateEventLog.
						//changes done by Shahu Mali on 10-10-13 [WS3GBAS001]
						//Changed by Prasad on 17/03/18 [formName implementation in transaction editor]
						String formName = getObjPropValue( this.objContext, "FORM_NAME" );
						//Added By Pankaj T. on 24-01-19 for Prevent to change value of transetup column confirm_col,site_acc_col,emp_acc_col,cust_acc_col,supp_acc_col and sales_pers_acc_col if defined and match entity type - start
						String chkConsistencyResStr = e12GenericUtility.checkConsistency(xmlStr, this.userInfo, this.editorId, this.objName, this.objContext, "T", null);
						BaseLogger.log("3", userInfo, editorId,"MasterStatefulEJB.validatedata() chkConsistencyResStr@@["+chkConsistencyResStr+"]");
						if( chkConsistencyResStr != null )
						{
							boolean isErrorNodeExist = new E12GenericUtility().isErrorNodeFound( chkConsistencyResStr );
							BaseLogger.log("3", userInfo,editorId,"isErrorNodeExist in chkConsistencyResStr @@["+isErrorNodeExist+"]");
							if( isErrorNodeExist )
							{
								return chkConsistencyResStr;
							}
						}
						//Added By Pankaj T. on 24-01-19 for Prevent to change value of transetup column confirm_col,site_acc_col,emp_acc_col,cust_acc_col,supp_acc_col and sales_pers_acc_col if defined and match entity type - end
						//Changed By Pankaj T. on 22-03-19 for if connection is pass from processRequset then pass same connection to validation & itemChmage - start
						if( this.dbSaveConn_doNotUse != null )
						{
							if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
							{
								//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
								this.eventManager.setAction("edit");
								wsReturnValue = this.eventManager.executeSystemEvent( this.objName, "pre_validate", currentEventContext, parseString(xmlStr), this.detailDom, getXtraParams(), ( ( Integer.parseInt( this.objContext.trim() ) == 1 ) ? this.headerDomId : this.detailDomId ), this.dbSaveConn_doNotUse, formName, this.userInfo ); //$NON-NLS-1$
								//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
								this.eventManager.setAction("");
							}
							else
							{
								//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
								this.eventManager.setAction("edit");
								wsReturnValue = this.eventManager.executeSystemEvent( this.objName, "pre_validate", currentEventContext, parseString(xmlStr), this.detailDom, getXtraParams(), ( ( Integer.parseInt( this.objContext.trim() ) == 1 ) ? this.headerDomId : this.detailDomId ), this.dbSaveConn_doNotUse, formName ); //$NON-NLS-1$
								//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
								this.eventManager.setAction("");
							}
						}
						else
						{
							if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
							{
								//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
								this.eventManager.setAction("edit");
								wsReturnValue = this.eventManager.executeSystemEvent( this.objName, "pre_validate", currentEventContext, parseString(xmlStr), this.detailDom, getXtraParams(), ( ( Integer.parseInt( this.objContext.trim() ) == 1 ) ? this.headerDomId : this.detailDomId ), formName, this.userInfo ); //$NON-NLS-1$
								//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
								this.eventManager.setAction("");
							}
							else
							{
								//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
								this.eventManager.setAction("edit");
								wsReturnValue = this.eventManager.executeSystemEvent( this.objName, "pre_validate", currentEventContext, parseString(xmlStr), this.detailDom, getXtraParams(), ( ( Integer.parseInt( this.objContext.trim() ) == 1 ) ? this.headerDomId : this.detailDomId ), formName ); //$NON-NLS-1$
								//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
								this.eventManager.setAction("");
							}
						}
						//Changed By Pankaj T. on 22-03-19 for if connection is pass from processRequset then pass same connection to validation & itemChmage - end
						//changes done by Shahu Mali on 10-10-13 [WS3GBAS001] : END
						eventType = "pre_validate";
						
						/* //Changed by Danish on 14/01/2008 [ CALLING POST_VALIDATE IF ALL ERRORS ARE WARNING IN PRE-VALIDATE  ] start
						if(wsReturnValue != null && wsReturnValue.indexOf("<Errors>") != -1)
						{
							retString = wsReturnValue;
						}
						else
						{
							valDataReturnVal = validate();
							if(valDataReturnVal.indexOf("<Errors>") != -1)
							{
								retString = valDataReturnVal;
							}
							wsReturnValue = this.eventManager.executeSystemEvent(this.objName, "post_validate", currentEventContext, parseString(xmlStr), this.detailDom, getXtraParams(), ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId));
							if(wsReturnValue != null && wsReturnValue.indexOf("<Errors>") != -1)
							{
								retString = wsReturnValue;
							}
							else
							{
								retString = "";
							}
						}*/
						/*boolean isErrorNodeFound = new ibase.webitm.utility.GenericUtility().isErrorNodeFound( wsReturnValue );
						BaseLogger.log("3", userInfo,editorId," isErrorNodeFound in save level is not 1 ["+ isErrorNodeFound +"]");
						if( isErrorNodeFound )
						{
							retString = wsReturnValue;
						}
						else
						{
							//Changed by Monif on 11/17/2008 [To make eventManager object as Local [As per KB.]
							//wsReturnValue = this.eventManager.executeSystemEvent(this.objName, "post_validate", currentEventContext, parseString(xmlStr), this.detailDom, getXtraParams(), ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId));
							//Changed by Monif on 6/2/2009 [Reverting Back [As per KB.]
							//wsReturnValue = getEventManager().executeSystemEvent(this.objName, "post_validate", currentEventContext, parseString(xmlStr), this.detailDom, getXtraParams(), ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId));
							wsReturnValue = this.eventManager.executeSystemEvent(this.objName, "post_validate", currentEventContext, parseString(xmlStr), this.detailDom, getXtraParams(), ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId));
							if(wsReturnValue != null && wsReturnValue.indexOf("<Errors>") != -1)
							{
								retString = wsReturnValue;
							}
							else
							{
								retString = "";
							}
						}*///Changed by Monif on 11/06/09[Reverted Back to Show warning and prompt also.]Start
						//Changed by Rupali Hande [to get both system warning -prompt- and generalized validation ].Start
						/*
						if(wsReturnValue != null && wsReturnValue.indexOf("<Errors>") != -1)
						{
							retString = wsReturnValue;
						}
						else
						{
							valDataReturnVal = validate();
							if(valDataReturnVal.indexOf("<Errors>") != -1)
							{
								retString = valDataReturnVal;
							}
							wsReturnValue = this.eventManager.executeSystemEvent(this.objName, "post_validate", currentEventContext, parseString(xmlStr), this.detailDom, getXtraParams(), ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId));
							if(wsReturnValue != null && wsReturnValue.indexOf("<Errors>") != -1)
							{
								retString = wsReturnValue;
							}
							else
							{
								retString = "";
							}
						}
						*///Changed by Monif on 11/06/09[Reverted Back to Show warning and prompt also.]End
						boolean isErrorNodeExist = new E12GenericUtility().isErrorNodeFound( wsReturnValue );
						BaseLogger.log("3", userInfo,editorId,"isErrorNodeExist 2024   ["+isErrorNodeExist+"]"); //$NON-NLS-1$ //$NON-NLS-2$
						if (isErrorNodeExist)
						{
							eventResult = "Failure"; // Added by Dnyaneshwar Chavan 20-Aug-15 [ PRIMARY_KEY tag value should not be null as per Danish Sir ]
							retString = wsReturnValue;
							//Changed By Mahesh Patidar on 20-MAY-13 [WI3BSUN001 | to append the current dom column value in error string trace]
							if( retString.indexOf( "<trace><![CDATA[]]></trace>" ) != -1 )
							{
								retString = retString.replace( "<trace><![CDATA[]]></trace>", "<trace><![CDATA["+currentRowSampleData.toString()+"]]></trace>");
							}

							if (  retString.indexOf( "<trace></trace>") != -1 )
							{
								retString = retString.replace( "<trace></trace>", "<trace><![CDATA["+currentRowSampleData.toString()+"]]></trace>");
							}
							
							if(  retString.indexOf( "<trace>") == -1 )
							{
								//retString = retString.replace( "</message>", "</message><trace><![CDATA["+currentRowSampleData.toString()+"]]></trace>");
								//Added by shrutika on 26-06-18 [start] for display trace after the description.
								if (  retString.indexOf( "<description>") != -1 )
								{
									retString = retString.replace( "</description>", "</description><trace><![CDATA["+currentRowSampleData.toString()+"]]></trace>");
								}
								else
								{
									retString = retString.replace( "</message>", "</message><trace><![CDATA["+currentRowSampleData.toString()+"]]></trace>");
								}
								//Added by shrutika on 26-06-18 [End] for display trace after the description.
							}
							//Ended By Mahesh Patidar
						}
						else
						{
							//changed By Mahesh Patidar on 01/AUG/13[WI3DSUN001|to log the user event activity log]
							//startTime = new Date(); //commented by shrutika for issue in update eventlog.
							//Changes done by Shahu Mali on 10-10-13 for multiDB connection: START
							String genValueError = "";
							//Changed by Prasad on 17/03/18 [formName implementation in transaction editor]
							formName = getObjPropValue( this.objContext, "FORM_NAME" );
							//Changed By Pankaj T. on 22-03-19 for if connection is pass from processRequset then pass same connection to validation & itemChmage - start
							if( this.dbSaveConn_doNotUse != null )
							{
								if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
								{
									//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
									this.eventManager.setAction("edit");
									genValueError = this.eventManager.executeSystemEvent(this.objName, "post_validate", currentEventContext, parseString(xmlStr), this.detailDom, getXtraParams(), ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId), this.dbSaveConn_doNotUse, formName, this.userInfo); //$NON-NLS-1$
									//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
									this.eventManager.setAction("");
								}
								else
								{
									//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
									this.eventManager.setAction("edit");
									genValueError = this.eventManager.executeSystemEvent(this.objName, "post_validate", currentEventContext, parseString(xmlStr), this.detailDom, getXtraParams(), ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId), this.dbSaveConn_doNotUse, formName); //$NON-NLS-1$
									//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
									this.eventManager.setAction("");
								}
							}
							else
							{
								if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
								{
									//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
									this.eventManager.setAction("edit");
									genValueError = this.eventManager.executeSystemEvent(this.objName, "post_validate", currentEventContext, parseString(xmlStr), this.detailDom, getXtraParams(), ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId), formName, this.userInfo); //$NON-NLS-1$
									//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
									this.eventManager.setAction("");
								}
								else
								{
									//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
									this.eventManager.setAction("edit");
									genValueError = this.eventManager.executeSystemEvent(this.objName, "post_validate", currentEventContext, parseString(xmlStr), this.detailDom, getXtraParams(), ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId), formName); //$NON-NLS-1$
									//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
									this.eventManager.setAction("");
								}
							}
							//Changed By Pankaj T. on 22-03-19 for if connection is pass from processRequset then pass same connection to validation & itemChmage - end
							//Changes done by Shahu Mali on 10-10-13 : END
							eventType = "post_validate"; // Added by Dnyaneshwar Chavan 20-Aug-15 [ PRIMARY_KEY tag value should not be null as per Danish Sir ] Start
							retString = getErrorNodes(wsReturnValue,genValueError );
						}
						//Changed by Rupali Hande [to get both system warning -prompt- and generalized validation ].End
						//Changed by Danish on 14/01/2008 [ CALLING POST_VALIDATE IF ALL ERRORS ARE WARNING IN PRE-VALIDATE  ] end 
						// Added by Dnyaneshwar Chavan 20-Aug-15 [ PRIMARY_KEY tag value should not be null as per Danish Sir ] Start
						eventResult = (new E12GenericUtility().isErrorNodeFound( retString ) ) ? "Failure" : eventResult;
						if( userInfo != null )
						{
							//Change by shrutika on 03-12-18 for updateEventLog.
							//userEventLogEJB.setEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(), this.getEditorId(), logAction, eventType, startTime, new Date(),"EventContext:[" + currentEventContext + "], currDomId:[" + ( ( Integer.parseInt( this.objContext.trim() ) == 1 ) ? this.headerDomId : this.detailDomId ) + "]", ( String )this.headerPKFieldValues,eventResult);
							//Change by shrutika on 05-01-19 for add exception.
							userEventLogEJB.updateEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(), this.getEditorId(), logAction, eventType, startTime, new Date(),"EventContext:[" + currentEventContext + "], currDomId:[" + ( ( Integer.parseInt( this.objContext.trim() ) == 1 ) ? this.headerDomId : this.detailDomId ) + "]", ( String )this.headerPKFieldValues,eventResult,"SA","");
						}
						else
						{
							BaseLogger.log("3", userInfo,editorId," ============ User info is null then never create event log in validateData() method and MasterStatefulEJB.java file ");
						}
						// Added by Dnyaneshwar Chavan 20-Aug-15 [ PRIMARY_KEY tag value should not be null as per Danish Sir ] End
						//Ended By Mahesh Patidar on 01/AUG/13[WI3DSUN001|to log the user event activity log]
						// Ended by Raju K on 02-05-14 for Event log and Transaction lock as per danish sir END--
					}
				}
			}
			//Added By Pankaj T. on 17-02-2021 - added new attributes in detail tag valdatastat, taxcalcstat & id for  checking current record is valid or not at the time of adding new detail - start
			BaseLogger.log("3", userInfo,editorId,"In validateAndPerformAction retString["+retString+"]");
			Node detailNode = null;
			if( this.detailDom != null )
			{
				detailNode = searchNode(this.detailDom, this.objContext, this.detailDomId, this.currDbID);
			}
			//boolean isValid = (retString != null && retString.indexOf("<Errors>") != -1)?false:true;
			boolean isErrorNodeFound = new E12GenericUtility().isErrorNodeFound( E12GenericUtility.checkNull( (retString) ) );
			BaseLogger.log("3", userInfo,editorId,"In validateAndPerformAction isErrorNodeFound before update valdatastat : [" + isErrorNodeFound +"]");
			if(!isErrorNodeFound)
			{
				if( detailNode != null )
				{
					((Element) detailNode).setAttribute("valdatastat", "3");
				}
			}
			else
			{
				if( detailNode != null )
				{
					((Element) detailNode).setAttribute("valdatastat", "2");
				}
			}
			//Added By Pankaj T. on 17-02-2021 - added new attributes in detail tag valdatastat, taxcalcstat & id for  checking current record is valid or not at the time of adding new detail - end
			BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB]validateData completed ......"); //$NON-NLS-1$
		}
		catch(Exception e)
		{
			//Added by shrutika on 25-12-18 [Start] for update status as Exception.
			if( userInfo != null )
			{
				//change by shrutika on 22-01-19 for parsing issue for writePrintStacktrace in updateEventLog.
				ITMException ie = new ITMException(e);
				userEventLogEJB.updateEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(), this.getEditorId(), logAction, "post_validate", startTime, new Date(),"EventContext:[" + currentEventContext + "], currDomID:[" + ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId) + "]", ( String )this.headerPKFieldValues,eventResult,"SA",ie.getMessage());
			}
			//Added by shrutika on 25-12-18 [End] for update status as Exception.
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :validateData :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return retString;
	}

	public String validate()
	{
		return ""; //$NON-NLS-1$
	}

	public String handleAction(String eventCode, String serviceHandler, String xmlStr) throws RemoteException, ITMException
	{
		Date startTime = new Date();
		//BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB.handleAction()] Handle Action called for eventCode :["+eventCode+"] serviceHandler :["+serviceHandler+"]\nxmlStr :["+xmlStr+"]");
		String returnValue = "";		 //$NON-NLS-1$
		try
		{
			//Change by shrutika on 08-02-19 for issue user activities are not update in case of ServiceHandler3 and ServiceHandler4.(change sequence of seteventlog and updateHeaderInfoMap)
			this.eventManager.setUserInfo(this.userInfo);//Added by vinayak on 17-Jun-2016 to set userInfo
			updateHeaderInfoMap(xmlStr);
			//Added by shrutika on 03-12-18 [Start] for updateEventLog.
			if( userInfo != null )
			{
				//Change by shrutika on 05-01-19 for add exception.
				userEventLogEJB.setEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(),this.getEditorId() , ( String )this.headerInfoMap.get( "action" )  , eventCode, startTime, null,"currDomId:[" +( (Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId) + "]", this.headerPKFieldValues,"Pending","SA","");
			}
			//Added by shrutika on 03-12-18 [End] for updateEventLog.
			//Changed by Monif on 11/17/2008 [To make eventManager object as Local [As per KB.]
			//String evtRetStr = this.eventManager.executeSystemEvent(this.objName, eventCode, null, parseString(xmlStr), this.detailDom, getXtraParams(), (Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId);
			//Changed by Monif on 6/2/2009 [Reverting Back [As per KB.]
			//String evtRetStr = getEventManager().executeSystemEvent(this.objName, eventCode, null, parseString(xmlStr), this.detailDom, getXtraParams(), (Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId);
			//Changed by Dayanand on 19/01/2011[ FI90SUN010 || Read Default data from file if is detail repeate "x" in transetup table ]start
			//Changes Done By Shahu Mali on 10-10-13.[WS3GBAS001] for multiDB connection : START
			String transDB = this.userInfo.getTransDB();
			String evtRetStr = "";
			//Changed By Pankaj T. on 22-03-19 for if connection is pass from processRequset then pass same connection to validation & itemChmage - start
			if( this.dbSaveConn_doNotUse != null )
			{
				if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
				{
					evtRetStr = this.eventManager.executeSystemEvent(this.objName, eventCode, null, parseString(xmlStr), this.detailDom, getXtraParams(), (Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId, this.dbSaveConn_doNotUse, this.userInfo);
				}
				else
				{
					evtRetStr = this.eventManager.executeSystemEvent(this.objName, eventCode, null, parseString(xmlStr), this.detailDom, getXtraParams(), (Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId, this.dbSaveConn_doNotUse);
				}
			}
			else
			{
				if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
				{
					evtRetStr = this.eventManager.executeSystemEvent(this.objName, eventCode, null, parseString(xmlStr), this.detailDom, getXtraParams(), (Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId, this.userInfo);
				}
				else
				{
					evtRetStr = this.eventManager.executeSystemEvent(this.objName, eventCode, null, parseString(xmlStr), this.detailDom, getXtraParams(), (Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId);
				}
			}
			//Changed By Pankaj T. on 22-03-19 for if connection is pass from processRequset then pass same connection to validation & itemChmage - end
			//Changes Done By Shahu Mali on 10-10-13.[WS3GBAS001] for multiDB connection : END
			// Added by Raju K on 02-05-14 for Event log and Transaction lock as per danish sir START--
			//Added By Mahesh Patidar on 01/AUG/13[WI3DSUN001|to log the user event activity log]
			if( userInfo != null )
			{
				//Change by shrutika on 03-12-18 for updateEventLog.
				//userEventLogEJB.setEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(),this.getEditorId() , ( String )this.headerInfoMap.get( "action" )  , eventCode, startTime, new Date(),"currDomId:[" +( (Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId) + "]", this.headerPKFieldValues);
				//Change by shrutika on 05-01-19 for add exception.
				userEventLogEJB.updateEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(),this.getEditorId() , ( String )this.headerInfoMap.get( "action" )  , eventCode, startTime, new Date(),"currDomId:[" +( (Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId) + "]", this.headerPKFieldValues,"Success","SA","");
			}
			else
			{
				BaseLogger.log("3", userInfo,editorId," ============ User info is null then never create event log in handleAction() method and MasterStatefulEJB.java file ");
			}
			if( ( "DEFAULT_DATA".equals(eventCode) ) && ( evtRetStr == null || evtRetStr.length() <= 0 ) ) //$NON-NLS-1$
			{
				evtRetStr = getDefaultDataFromFile( this.objName, this.objContext.trim());				
				if( evtRetStr == null || evtRetStr.length() <= 0 )
				{
					evtRetStr = "<Root><Errors><error><message>"+Messages.getString("MasterStatefulEJB_errorWhileLoadingDefaultFromData")+"</message></error></Errors></Root>"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				}
			}
			//Changed by Dayanand on 19/01/2011[ Read Default data from file if is detail repeate "x" in transetup table ]end
			if (evtRetStr.indexOf("<Errors>") == -1) //$NON-NLS-1$
			{
				if(serviceHandler.equals("3")) //$NON-NLS-1$
				{
					returnValue = setActionData(eventCode, evtRetStr);
				}
				else if(serviceHandler.equals("4")) //$NON-NLS-1$
				{
					returnValue = evtRetStr;
				}
			}
			else
			{
				returnValue = evtRetStr;
			}
		}
		catch(Exception e)
		{
			//Added by shrutika on 25-12-18 [Start] for update status as Exception.
			if( userInfo != null )
			{
				//change by shrutika on 22-01-19 for parsing issue for writePrintStacktrace in updateEventLog.
				ITMException ie = new ITMException(e);
				userEventLogEJB.updateEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(),this.getEditorId() , ( String )this.headerInfoMap.get( "action" )  , eventCode, startTime, new Date(),"currDomId:[" +( (Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId) + "]", this.headerPKFieldValues,"Exception","SA",ie.getMessage());
			}
			//Added by shrutika on 25-12-18 [End] for update status as Exception.
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :handleAction()==>"); //$NON-NLS-1$
			e.printStackTrace();
			throw new ITMException(e);
		}
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB.handleAction()] Return String :\n["+returnValue.length()+"]"); //$NON-NLS-1$ //$NON-NLS-2$
		return returnValue;
	}

	public String setActionData(String eventCode, String evtRetStr) throws RemoteException, ITMException
	{
		Date startTime = new Date();
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB.setActionData()] Set Action Data called for eventCode :["+eventCode+"]"); //$NON-NLS-1$ //$NON-NLS-2$
		String returnValue = ""; //$NON-NLS-1$
		try
		{
			//updateHeaderInfoMap(evtRetStr);
			//String transformStr = this.eventManager.executeSystemEvent(this.objName, eventCode+"_transform", null, parseString(evtRetStr), this.detailDom, getXtraParams(), (Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId);
			
			//Changed By prerna on 24/07/2006 Start-- []
			Document eventRetDom = parseString(evtRetStr);
			NodeList eventRetList = eventRetDom.getElementsByTagName("Detail"); //$NON-NLS-1$
			this.eventManager.setUserInfo(this.userInfo);//Added by vinayak on 17-Jun-2016 to set the userinfo 
			int detailPresent = eventRetList.getLength();

			//Added by shrutika on 03-12-18 [start] for updateEventLog.
			if( userInfo != null )
			{
				if("".equals(this.getEditorId()))
				{
					this.editorId = "" + new Date().getTime();
				}
				//Change by shrutika on 05-01-19 for add exception.
				userEventLogEJB.setEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(),this.getEditorId() , ( String )this.headerInfoMap.get( "action" )  , eventCode, startTime, null ,"currDomId:[" +( (Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId) + "]", this.headerPKFieldValues,"Pending","SA","");
			}
			//Added by shrutika on 03-12-18 [End] for updateEventLog.
			if(detailPresent == 0)
			{
				return "<Errors><error id = \"xxxx\" type=\"E\"><message>"+Messages.getString("MasterStatefulEJB_noRecordsFound")+"</message></error></Errors>"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}	
			//Changed by Monif on 11/17/2008 [To make eventManager object as Local [As per KB.]
			//String transformStr = this.eventManager.executeSystemEvent(this.objName, eventCode+"_transform", null, eventRetDom, this.detailDom, getXtraParams(), (Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId);
			//Changed by Monif on 6/2/2009 [Reverting Back [As per KB.]
			//String transformStr = getEventManager().executeSystemEvent(this.objName, eventCode+"_transform", null, eventRetDom, this.detailDom, getXtraParams(), (Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId);
			//Changes done By Shahu Mali on  10-10-13.[WS3GBAS001] for multiDB connection : START
			String transDB = this.userInfo.getTransDB();
			String transformStr = "";
			if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
			{
				transformStr = this.eventManager.executeSystemEvent(this.objName, eventCode+"_transform", null, eventRetDom, this.detailDom, getXtraParams(), (Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId,this.userInfo); //$NON-NLS-1$
			}
			else
			{
				transformStr = this.eventManager.executeSystemEvent(this.objName, eventCode+"_transform", null, eventRetDom, this.detailDom, getXtraParams(), (Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId); //$NON-NLS-1$
			}
			//Changes done By Shahu Mali on  10-10-13.[WS3GBAS001] for multiDB connection : END
			//Changed By prerna on 24/07/2006 End-- []

			if (transformStr != null && transformStr.indexOf("<Errors>") == -1) //$NON-NLS-1$
			{
				if(transformStr.length() == 0)
				{
					transformStr = evtRetStr;
				}
				Document returnDom = parseString(transformStr);
				NodeList detailList = returnDom.getElementsByTagName("Detail"); //$NON-NLS-1$
				int noOfDetails = detailList.getLength();
				StringBuffer returnStrBuff = new StringBuffer();
				String itemChgString = "<?xml version='1.0' encoding='"+this.userInfo.getCharEnc()+"'?>" //$NON-NLS-1$ //$NON-NLS-2$
							+ "<Root>" //$NON-NLS-1$
							+ "<header>" //$NON-NLS-1$
							+ "<objName><![CDATA[" + this.objName +"]]></objName>" //$NON-NLS-1$ //$NON-NLS-2$
							+ "<pageContext><![CDATA[" + this.pageContext +"]]></pageContext>" //$NON-NLS-1$ //$NON-NLS-2$
							+ "<objContext><![CDATA[" + this.objContext +"]]></objContext>" //$NON-NLS-1$ //$NON-NLS-2$
							+ "<editFlag><![CDATA[" + this.localEditFlag +"]]></editFlag>" //$NON-NLS-1$ //$NON-NLS-2$
							+ "<saveLevel><![CDATA[0]]></saveLevel>" //$NON-NLS-1$
							+ "<forcedSave><![CDATA[false]]></forcedSave>"; //$NON-NLS-1$
				
//				Changed by Dhruv on 02/08/2007 to support mandatory flag default value differnet in case of all_rec fn.
				//ArrayList itemChangeList = this.dbAccess.getItemChangeElementList( this.objName, this.objContext );
				
				//Changes done By Shahu Mali on  10-10-13.[WS3GBAS001] for multiDB connection : START
				ArrayList itemChangeList = null;
				if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
				{
					itemChangeList = this.dbAccess.getManadatoryItemChangeElementList( this.objName, this.objContext, "Y", this.userInfo ); //$NON-NLS-1$
				}
				//Changes done By Shahu Mali on  10-10-13.[WS3GBAS001] for multiDB connection : END
				
				//DD if(this.detailDom) has the free dom, delete it
				BaseLogger.log("3", userInfo,editorId,"noOfDetails:["+noOfDetails+"]");
				BaseLogger.log("3", userInfo,editorId,"this.isCurrentDetailValidated:["+this.isCurrentDetailValidated+"]");
				for (int j = 0; j < noOfDetails; j++)
				{   
//					Changed by Dhruv on 06/11/2007 to overwrite/add based on domId attribute in the returned Detail node.
					Node currDetailNode = detailList.item(j);
					if( (j > 0) || (j == 0 && this.isCurrentDetailValidated ))
					{
						//Changed by Dhruv on 06/11/2007 to overwrite/add based on domId attribute in the returned Detail node.Start
						Node domIDAttrNode = currDetailNode.getAttributes().getNamedItem( "domID" ); //$NON-NLS-1$
						String newDomIdVal = null; 
						if( domIDAttrNode != null )
						{
							newDomIdVal = domIDAttrNode.getNodeValue();
							newDomIdVal = ( newDomIdVal != null && newDomIdVal.length() > 0 ) ? newDomIdVal : null;
						}
						//Added by Prasad on 02/11/16 [to search node from dbId] START
						Node dbIDAttrNode = currDetailNode.getAttributes().getNamedItem( "dbID" ); //$NON-NLS-1$
						String dbIdVal = null; 
						if( domIDAttrNode != null )
						{
							dbIdVal = dbIDAttrNode.getNodeValue();
							dbIdVal = ( dbIdVal != null && dbIdVal.length() > 0 ) ? dbIdVal : null;
						}
						//Added by Prasad on 02/11/16 [to search node from dbId] END
						if( newDomIdVal != null )
						{
							//Changed by Prasad on 02/11/16 [to search node from dbId]
							//if( searchNode( this.detailDom, this.objContext, newDomIdVal ) != null )
							if( searchNode( this.detailDom, this.objContext, newDomIdVal, dbIdVal ) != null )
							{
								this.detailDomId = newDomIdVal;
							}
							else
							{
								addChildAddDom();
							}
						}
						//Changed by Dhruv on 06/11/2007 to overwrite/add based on domId attribute in the returned Detail node.End
						else
						{
							addChildAddDom();
						}
					}
					//Changed by Prasad on 02/11/16 [to search node from dbId]
					//this.currRecordNode = searchNode(this.detailDom, this.objContext, (Integer.parseInt(this.objContext.trim()) == 1) ? this.headerDomId : this.detailDomId);
					this.currRecordNode = searchNode(this.detailDom, this.objContext, (Integer.parseInt(this.objContext.trim()) == 1) ? this.headerDomId : this.detailDomId, "");
					//Added By Pankaj T. on 10-03-2021 to set valdatastat = 3 and consider details record added through servicehandler 3/4 are validated - start
					if( this.currRecordNode != null )
					{
						((Element) this.currRecordNode).setAttribute("valdatastat", "3");
					}
					//Added By Pankaj T. on 10-03-2021 to set valdatastat = 3 and consider details record added through servicehandler 3/4 are validated - end
					//Changed by Dhruv on 06/11/2007 commented and added above if block to overwrite/add based on domId attribute in the returned Detail node.
					//Node currDetailNode = detailList.item(j);
					NodeList childList = currDetailNode.getChildNodes();
					int noOfChilds = childList.getLength();
					String focusedColumn = ""; //$NON-NLS-1$
					StringBuffer chgDetailStrBuff = new StringBuffer();
					
					for(int k = 0; k < noOfChilds; k++)
					{
						Node colNode = childList.item(k);
						if(colNode != null && colNode.getNodeType() == Node.ELEMENT_NODE)
						{
							focusedColumn = colNode.getNodeName().toLowerCase();
							String colStr = serializeDom(colNode);
							Node attrNode = colNode.getAttributes().getNamedItem("isSrvCallOnChg"); //$NON-NLS-1$
							String attrVal = null;
							if(attrNode != null)
							{
								attrVal = attrNode.getNodeValue();
							}
							boolean isSrvCallOnChg = (attrVal == null || (attrVal != null && attrVal.trim().length() > 0 && attrVal.trim().equals("1")))?true:false; //$NON-NLS-1$
							BaseLogger.log("3", userInfo,editorId,"Column Name :["+focusedColumn+"] isSrvCallOnChg :["+isSrvCallOnChg+"]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
							if(isSrvCallOnChg && itemChangeList.contains(focusedColumn))
							{
								String newString = itemChgString + "<focusedColumn><![CDATA[" + focusedColumn +"]]></focusedColumn>" //$NON-NLS-1$ //$NON-NLS-2$
												 + "<keyValue><![CDATA[" + ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId) + "]]></keyValue>" //$NON-NLS-1$ //$NON-NLS-2$
												 + "</header><Detail>" + colStr + "</Detail></Root>"; //$NON-NLS-1$ //$NON-NLS-2$
								applyItemChange(newString);
							}
							else
							{
								chgDetailStrBuff.append(colStr);
							}
						}//if(colNode != null && colNode.getNodeType() == Node.ELEMENT_NODE)
					}
					//BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB.setActionData()] Non Item Change Cols :["+chgDetailStrBuff.toString()+"]");
					if(chgDetailStrBuff.length() > 0)
					{
						String newString = itemChgString 
										 + "<keyValue><![CDATA[" + ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId) + "]]></keyValue>" //$NON-NLS-1$ //$NON-NLS-2$
										 + "</header><Detail>" + chgDetailStrBuff.toString() + "</Detail></Root>"; //$NON-NLS-1$ //$NON-NLS-2$
						//BaseLogger.log("3", userInfo,editorId,"Calling to apply Data To XML through handleItemChange with Change String:["+newString+"]");
						updateHeaderInfoMap(newString);
						handleItemChange( newString );
					}
					//Changed By Pankaj T. on 19-08-19 As per suggested by KB sir if each_rate not define in daily_exch_rate master then throw error - start
					String taxChgString = calculateTax();
					if( taxChgString != null && taxChgString.length() > 0 && taxChgString.indexOf("<Errors>") != -1)
					{
						return taxChgString;
					}
					//Changed By Pankaj T. on 19-08-19 As per suggested by KB sir if each_rate not define in daily_exch_rate master then throw error - end
					//Changed by Prasad on 02/11/16 [to search node from dbId]
					//this.currTaxNode = getCurrTaxNode(this.objContext, this.detailDomId);
					this.currTaxNode = getCurrTaxNode(this.objContext, this.detailDomId, "");
					crossUpdate(this.objContext, this.detailDom);
					returnStrBuff.append(serializeDom(this.currRecordNode));
				}//for (int j = 0; j < noOfDetails; j++)
				returnValue = getNormalizedString(returnStrBuff.toString());
			}//if (transformStr != null && transformStr.indexOf("<Errors>") == -1)
			else
			{
				returnValue = transformStr;
			}
			// Added by Raju K on 02-05-14 for Event log and Transaction lock as per danish sir START--
			//Added By Mahesh Patidar on 01/AUG/13[WI3DSUN001|to log the user event activity log]
			if( userInfo != null )
			{
				//Added by shrutika on 03-12-18 for updateEventLog.
				//userEventLogEJB.setEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(),this.getEditorId() , ( String )this.headerInfoMap.get( "action" )  , eventCode, startTime, new Date(),"currDomId:[" +( (Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId) + "]", this.headerPKFieldValues);
				//Change by shrutika on 05-01-19 for add exception.
				userEventLogEJB.updateEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(),this.getEditorId() , ( String )this.headerInfoMap.get( "action" )  , eventCode, startTime, new Date(),"currDomId:[" +( (Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId) + "]", this.headerPKFieldValues,"Success","SA","");
			}
			else
			{
				BaseLogger.log("3", userInfo,editorId," ============ User info is null then never create event log in setActionData() method and MasterStatefulEJB.java file ");
			}
		}
		catch(Exception e)
		{
			//Added by shrutika on 25-12-18 [Start] for update status as Exception.
			if( userInfo != null )
			{
				//change by shrutika on 22-01-19 for parsing issue for writePrintStacktrace in updateEventLog.
				ITMException ie = new ITMException(e);
				userEventLogEJB.updateEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(),this.getEditorId() , ( String )this.headerInfoMap.get( "action" )  , eventCode, startTime, new Date(),"currDomId:[" +( (Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId) + "]", this.headerPKFieldValues,"Exception","SA",ie.getMessage());
			}
			//Added by shrutika on 25-12-18 [End] for update status as Exception.
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :setActionData()==>"); //$NON-NLS-1$
			throw new ITMException(e);
		}
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB.setActionData()] Return String :\n["+returnValue.length()+"]"); //$NON-NLS-1$ //$NON-NLS-2$
		return returnValue;
	}

//-------------------------------------------------------------------------------------------------------------//	
	//Changed by Dhruv on 24/07/07 commented and replaced by below methods for supporting explicit/implicit tranasctional saving to ITM.Start
	
	/*
	private String save(String xmlStr)throws ITMException
	{
		BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB]saving ......");
		String retString = "";
		String wsReturnValue = "";
		String tempObjName = null;
		try
		{
			if(this.tranType.equalsIgnoreCase("U"))
			{
				tempObjName = this.objName;
				Document newDetailDom = transformDom(this.detailDom, tempObjName);
				String newObjName = null;
				if(this.systemDefObjName.startsWith("[") || this.systemDefObjName.startsWith("<"))
				{
					newObjName = getSystemDefObjName(this.systemDefObjName, newDetailDom);
					this.systemDefObjName = null;
				}
				setObjDetails(newObjName);
				this.detailDom = newDetailDom;
				setHeaderPKFieldNames();
			}
			//wsReturnValue = this.eventManager.executeSystemEvent(this.objName, "pre_save", currentEventContext, parseString(xmlStr), this.detailDom, getXtraParams(), ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId));

			if(wsReturnValue != null && wsReturnValue.indexOf("<Errors>") != -1)
			{
				retString = wsReturnValue;
			}
			else
			{
				XML2DBHome xml2DBHome = (XML2DBHome)this.initialContext.lookup("XML2DB");
				XML2DB xml2DBRem = xml2DBHome.create();
				
				BaseLogger.log("3", userInfo,editorId,"this.editFlag ["+this.editFlag+"] this.keyFlag ["+this.keyFlag+"]");
				//Changed by Danish on 11/01/2007
				//retString = xml2DBRem.saveXML2DB( this.refSer, new ibase.webitm.utility.GenericUtility().getInstance().serializeDom( this.detailDom ), this.objName, this.editFlag, this.noOfForms, ( this.editFlag.equalsIgnoreCase( "E" )? false : ( ( this.editFlag.equalsIgnoreCase( "A" ) && this.keyFlag.equalsIgnoreCase( "A" ) ) ) ? true : false ), this.userInfo.getLoginCode(), this.headerPKFieldNames, this.isAutoConfirm, getXtraParams(), this.taxList, this.wrkflwInit, this.isWrkflwToBeInitiated, this.wrkflwOpt, this.auditDataXmlBefore, getAuditXMLString(), this.headerPKFieldValues );
				//BaseLogger.log("3", userInfo,editorId,"**************this.detailDom Before saveXML2DB***********"+ serializeDom( this.detailDom ) );
				retString = xml2DBRem.saveXML2DB( this.refSer, new ibase.webitm.utility.GenericUtility().getInstance().serializeDom( this.detailDom ), this.objName, this.editFlag, this.noOfForms, ( this.editFlag.equalsIgnoreCase( "E" )? false : ( ( this.editFlag.equalsIgnoreCase( "A" ) && this.keyFlag.equalsIgnoreCase( "A" ) ) ) ? true : false ), this.userInfo.getLoginCode(), this.headerPKFieldNames, this.isAutoConfirm, getXtraParams(), this.taxList, this.wrkflwInit, this.isWrkflwToBeInitiated, this.wrkflwOpt, this.auditDataXmlBefore, getAuditXMLString(), this.headerPKFieldValues, this.isWrkflwInitiated  );
				
				if(retString.indexOf( "<Errors>" ) == -1 )
				{
					if(this.tranType.equalsIgnoreCase( "U" ) && getDelFlagForDraft( tempObjName ).equalsIgnoreCase( "Y" ) )
					{
						deleteDraftObject();
					}
					if( this.tranType.equalsIgnoreCase( "U" ) )
					{
						this.systemDefObjName = null;
						setObjDetails( tempObjName );
						setHeaderPKFieldNames();
					}
					retString = "<Root><Detail>Success</Detail><TranID>"+retString+"</TranID></Root>";
				}//if(retString.indexOf("<Errors>") == -1)
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("3", userInfo,editorId,"Exception :MasterStatefulEJB : save :"+e);
			throw new ITMException(e);
		}
		BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB]save completed ......");
		return retString;
	}
	*/

	private String save( String xmlStr )throws ITMException
	{
		Date startTime = new Date();
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]saving ......"); //$NON-NLS-1$
		String retString = ""; //$NON-NLS-1$
		String wsReturnValue = ""; //$NON-NLS-1$
		String tempObjName = null;
		//Added by shrutika on 25-12-18 [Start] for update status as Exception.
		String actionMode = "";
		String tempEditorId = "";
		//Added by shrutika on 25-12-18 [End] for update status as Exception.
		try
		{
			//Added by shrutika on 03-12-18 [Start] for updateEventLog.
			actionMode = "VIEW";
			if( editFlag.equals("A") )
			{
				actionMode = "ADD";
			}
			else if( editFlag.equals("E") )
			{
				actionMode = "EDIT";
			}
			tempEditorId = this.getEditorId();
			if( userInfo != null )
			{
				if("".equals(this.getEditorId()))
				{
					this.editorId = ""+ new Date().getTime();
				}
				//userEventLogEJB.setEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorId, actionMode , "Save", new Date(), null ,"" , this.headerPKFieldValues);  // pageContext:[" + this.pageContext + "], objContext:[" + this.objContext + "]
				//Change by shrutika on 05-01-19 for add exception.
				userEventLogEJB.setEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorId, actionMode , "Save", startTime, null ,"" , this.headerPKFieldValues, "Pending","SA","");  // pageContext:[" + this.pageContext + "], objContext:[" + this.objContext + "]
			}
			//Added by shrutika on 03-12-18 [End] for updateEventLog.

			//Changes made by Gulzar to validate the Save XML against XSD on 28/05/14 : START
			String saveXMLStr = serializeDom( this.detailDom );
			//BaseLogger.log("3", userInfo,editorId,"Save XML Str :::"+saveXMLStr);
			this.eventManager.setUserInfo(this.userInfo);//Added by vinayak on 17-Jun-2016 to set userInfo
			boolean isValidated = validateXMLAgainstXSD(saveXMLStr);
			BaseLogger.log("3", userInfo,editorId,"isValidated =["+isValidated+"]");
			if(!isValidated)
			{
				//Return ErrorString
				ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
				retString = itmDBAccessEJB.getErrorString("", "INVALIDXSD", "", this.userInfo);
			}
			
			//BaseLogger.log("3", userInfo,editorId,"retString ::"+retString);
			
			if(retString == null || retString.trim().length() == 0)
			{
			//Changes made by Gulzar to validate the Save XML against XSD on 28/05/14 : END
				
				String transDB = this.userInfo.getTransDB();//Shahu for multiDB connection
	
				if( this.tranType.equalsIgnoreCase( "U" ) ) //$NON-NLS-1$
				{
					tempObjName = this.objName;
					Document newDetailDom = transformDom( this.detailDom, tempObjName );
					String newObjName = null;
					if( this.systemDefObjName.startsWith( "[" ) || this.systemDefObjName.startsWith( "<" ) ) //$NON-NLS-1$ //$NON-NLS-2$
					{
						newObjName = getSystemDefObjName( this.systemDefObjName, newDetailDom );
						this.systemDefObjName = null;
					}
					setObjDetails(newObjName);
					this.detailDom = newDetailDom;
					setHeaderPKFieldNames();
				}
				if( wsReturnValue != null && wsReturnValue.indexOf( "<Errors>" ) != -1 ) //$NON-NLS-1$
				{
					retString = wsReturnValue;
				}
				else
				{
					
						
					/*XML2DBHome xml2DBHome = (XML2DBHome)this.initialContext.lookup("XML2DB");
					XML2DB xml2DBRem = xml2DBHome.create();*/
					
					// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [START]
					//XML2DBLocal xml2dbejb = (XML2DBLocal)this.initialContext.lookup("ibase/XML2DBEJB/local"); //$NON-NLS-1$
					XML2DBEJB xml2dbejb = new XML2DBEJB();
					// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [START]
					
					//Added By Pankaj t on 16-06-17 [F16KSUN001][to set retainPkValue flag true for primary key value is set from uploaded xml when key flag "A"]
					xml2dbejb.setRetainPkValue(isRetainPkValue);
					//Commented by Gulzar on 25-May-17
					//xml2DBRem.setObjFormInfoMap(objFormInfoMap);//Gulzar on 09/02/17
					BaseLogger.log("3", userInfo,editorId,"this.editFlag ["+this.editFlag+"] this.keyFlag ["+this.keyFlag+"]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
					
					if(isTransactionEditfromWF)
					{
						BaseLogger.log("3", userInfo,editorId,"Transaction Edited from Work Flow So save data in Workflow Database");
						//Changed by Prasad on 17/03/18 [formName implementation in transaction editor]
						//retString = xml2DBRem.saveXML2WFDB( this.refSer, serializeDom( this.detailDom ), this.objName, this.editFlag, this.noOfForms, ( this.editFlag.equalsIgnoreCase( "E" )? false : ( ( this.editFlag.equalsIgnoreCase( "A" ) && this.keyFlag.equalsIgnoreCase( "A" ) ) ) ? true : false ), this.userInfo.getLoginCode(), this.headerPKFieldNames, this.isAutoConfirm, getXtraParams(), this.taxList, this.wrkflwInit, this.isWrkflwToBeInitiated, this.wrkflwOpt, this.auditDataXmlBefore, getAuditXMLString(), this.headerPKFieldValues, this.isWrkflwInitiated, this.isAuditTrailOn, this.userInfo ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						retString = xml2dbejb.saveXML2WFDB( this.refSer, serializeDom( this.detailDom ), this.objName, this.editFlag, this.noOfForms, ( this.editFlag.equalsIgnoreCase( "E" )? false : ( ( this.editFlag.equalsIgnoreCase( "A" ) && this.keyFlag.equalsIgnoreCase( "A" ) ) ) ? true : false ), this.userInfo.getLoginCode(), this.headerPKFieldNames, this.isAutoConfirm, getXtraParams(), this.taxList, this.wrkflwInit, this.isWrkflwToBeInitiated, this.wrkflwOpt, this.auditDataXmlBefore, getAuditXMLString(), this.headerPKFieldValues, this.isWrkflwInitiated, this.isAuditTrailOn, this.userInfo, this.objFormInfoMap ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
					}
					else
					{
						//Changed by Dhruv on 24/07/07 commented and replaced by below methods for supporting explicit/implicit tranasctional saving to ITM.Start
	
						//retString = xml2DBRem.saveXML2DB( this.refSer, new ibase.webitm.utility.GenericUtility()/*.getInstance()*/.serializeDom( this.detailDom ), this.objName, this.editFlag, this.noOfForms, ( this.editFlag.equalsIgnoreCase( "E" )? false : ( ( this.editFlag.equalsIgnoreCase( "A" ) && this.keyFlag.equalsIgnoreCase( "A" ) ) ) ? true : false ), this.userInfo.getLoginCode(), this.headerPKFieldNames, this.isAutoConfirm, getXtraParams(), this.taxList, this.wrkflwInit, this.isWrkflwToBeInitiated, this.wrkflwOpt, this.auditDataXmlBefore, getAuditXMLString(), this.headerPKFieldValues, this.isWrkflwInitiated  );
						//this.dbSaveConn_doNotUse = con;
						//this.isPartOfExtTrans = isPartOfExtTrans;
						if( this.isPartOfExtTrans )
						{
							//Commented and changed by Gulzar on 30/03/16. Removed the checking of  J2EE_VERSION : START
							//if( "1".equals( CommonConstants.J2EE_VERSION ) ) //$NON-NLS-1$
							{
								//Changed by Monif on 11/14/2008 [For special char parsing issue].
								//retString = xml2DBRem.saveXML2DB( this.refSer, new ibase.webitm.utility.GenericUtility()/*.getInstance()*/.serializeDom( this.detailDom ), this.objName, this.editFlag, this.noOfForms, ( this.editFlag.equalsIgnoreCase( "E" )? false : ( ( this.editFlag.equalsIgnoreCase( "A" ) && this.keyFlag.equalsIgnoreCase( "A" ) ) ) ? true : false ), this.userInfo.getLoginCode(), this.headerPKFieldNames, this.isAutoConfirm, getXtraParams(), this.taxList, this.wrkflwInit, this.isWrkflwToBeInitiated, this.wrkflwOpt, this.auditDataXmlBefore, getAuditXMLString(), this.headerPKFieldValues, this.isWrkflwInitiated,  this.dbSaveConn_doNotUse  );
								//Changes Done By Shahu Mali on 10-10-13 .[WS3GBAS001] for multiDB connedction : START
								if(transDB != null && !"null".equalsIgnoreCase(transDB) && transDB.trim().length() > 0)
								{
									if (isDataUpload)
									{
										//Changed by Prasad on 17/03/18 [formName implementation in transaction editor]
										retString = xml2dbejb.saveXML2DB( this.refSer, serializeDom( this.detailDom ), this.objName, this.editFlag, this.noOfForms, ( this.editFlag.equalsIgnoreCase( "E" )? false : ( ( this.editFlag.equalsIgnoreCase( "A" ) && this.keyFlag.equalsIgnoreCase( "A" ) ) ) ? true : false ), this.userInfo.getLoginCode(), this.headerPKFieldNames, this.isAutoConfirm, getXtraParams(), this.taxList, this.wrkflwInit, this.isWrkflwToBeInitiated, this.wrkflwOpt, this.auditDataXmlBefore, getAuditXMLString(), this.headerPKFieldValues, this.isWrkflwInitiated,  this.dbSaveConn_doNotUse, this.isAuditTrailOn,this.userInfo,isDataUpload, this.objFormInfoMap); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
									}
									else
									{
										//Changed by Prasad on 17/03/18 [formName implementation in transaction editor]
										//Added By Pankaj T. on 15-10-18 for copy transaction add entry in audit_trail - start
										xml2dbejb.setCopyingRec(this.isCopyingRec);
										//Added By Pankaj T. on 03-12-19 for update attachment refId on finish against editorId in add mode
										xml2dbejb.setEditorId(this.editorId);
										retString = xml2dbejb.saveXML2DB( this.refSer, serializeDom( this.detailDom ), this.objName, this.editFlag, this.noOfForms, ( this.editFlag.equalsIgnoreCase( "E" )? false : ( ( this.editFlag.equalsIgnoreCase( "A" ) && this.keyFlag.equalsIgnoreCase( "A" ) ) ) ? true : false ), this.userInfo.getLoginCode(), this.headerPKFieldNames, this.isAutoConfirm, getXtraParams(), this.taxList, this.wrkflwInit, this.isWrkflwToBeInitiated, this.wrkflwOpt, this.auditDataXmlBefore, getAuditXMLString(), this.headerPKFieldValues, this.isWrkflwInitiated,  this.dbSaveConn_doNotUse, this.isAuditTrailOn, this.userInfo, this.objFormInfoMap ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
										xml2dbejb.setCopyingRec(false);
										//Added By Pankaj T. on 15-10-18 for copy transaction add entry in audit_trail - end
									}
								}
								//Changes Done By Shahu Mali on 10-10-13 .[WS3GBAS001] for multiDB connedction : END
							}
							//Commented and changed by Gulzar on 30/03/16. Removed the checking of  J2EE_VERSION : START
							/*
							else if( "2".equals( CommonConstants.J2EE_VERSION ) ) //$NON-NLS-1$
							{
								//Changed by Monif on 11/14/2008 [For special char parsing issue].
								//retString = xml2DBRem.saveXML2DB( this.refSer, new ibase.webitm.utility.GenericUtility().getInstance().serializeDom( this.detailDom ), this.objName, this.editFlag, this.noOfForms, ( this.editFlag.equalsIgnoreCase( "E" )? false : ( ( this.editFlag.equalsIgnoreCase( "A" ) && this.keyFlag.equalsIgnoreCase( "A" ) ) ) ? true : false ), this.userInfo.getLoginCode(), this.headerPKFieldNames, this.isAutoConfirm, getXtraParams(), this.taxList, this.wrkflwInit, this.isWrkflwToBeInitiated, this.wrkflwOpt, this.auditDataXmlBefore, getAuditXMLString(), this.headerPKFieldValues, this.isWrkflwInitiated, null  );
								//Changes Done By Shahu Mali on 10-10-13 .[WS3GBAS001] for multiDB connedction : START
								if(transDB != null && !"null".equalsIgnoreCase(transDB) && transDB.trim().length() > 0)
								{
									if (isDataUpload)
									{
										retString = xml2DBRem.saveXML2DB( this.refSer, serializeDom( this.detailDom ), this.objName, this.editFlag, this.noOfForms, ( this.editFlag.equalsIgnoreCase( "E" )? false : ( ( this.editFlag.equalsIgnoreCase( "A" ) && this.keyFlag.equalsIgnoreCase( "A" ) ) ) ? true : false ), this.userInfo.getLoginCode(), this.headerPKFieldNames, this.isAutoConfirm, getXtraParams(), this.taxList, this.wrkflwInit, this.isWrkflwToBeInitiated, this.wrkflwOpt, this.auditDataXmlBefore, getAuditXMLString(), this.headerPKFieldValues, this.isWrkflwInitiated, null, this.isAuditTrailOn,this.userInfo, isDataUpload  ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
									}
									else
									{
										retString = xml2DBRem.saveXML2DB( this.refSer, serializeDom( this.detailDom ), this.objName, this.editFlag, this.noOfForms, ( this.editFlag.equalsIgnoreCase( "E" )? false : ( ( this.editFlag.equalsIgnoreCase( "A" ) && this.keyFlag.equalsIgnoreCase( "A" ) ) ) ? true : false ), this.userInfo.getLoginCode(), this.headerPKFieldNames, this.isAutoConfirm, getXtraParams(), this.taxList, this.wrkflwInit, this.isWrkflwToBeInitiated, this.wrkflwOpt, this.auditDataXmlBefore, getAuditXMLString(), this.headerPKFieldValues, this.isWrkflwInitiated, null, this.isAuditTrailOn,this.userInfo  ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
									}
								}
								else
								{
									if (isDataUpload)
									{
										retString = xml2DBRem.saveXML2DB( this.refSer, serializeDom( this.detailDom ), this.objName, this.editFlag, this.noOfForms, ( this.editFlag.equalsIgnoreCase( "E" )? false : ( ( this.editFlag.equalsIgnoreCase( "A" ) && this.keyFlag.equalsIgnoreCase( "A" ) ) ) ? true : false ), this.userInfo.getLoginCode(), this.headerPKFieldNames, this.isAutoConfirm, getXtraParams(), this.taxList, this.wrkflwInit, this.isWrkflwToBeInitiated, this.wrkflwOpt, this.auditDataXmlBefore, getAuditXMLString(), this.headerPKFieldValues, this.isWrkflwInitiated, null, this.isAuditTrailOn,isDataUpload  ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
									}
									else
									{
										retString = xml2DBRem.saveXML2DB( this.refSer, serializeDom( this.detailDom ), this.objName, this.editFlag, this.noOfForms, ( this.editFlag.equalsIgnoreCase( "E" )? false : ( ( this.editFlag.equalsIgnoreCase( "A" ) && this.keyFlag.equalsIgnoreCase( "A" ) ) ) ? true : false ), this.userInfo.getLoginCode(), this.headerPKFieldNames, this.isAutoConfirm, getXtraParams(), this.taxList, this.wrkflwInit, this.isWrkflwToBeInitiated, this.wrkflwOpt, this.auditDataXmlBefore, getAuditXMLString(), this.headerPKFieldValues, this.isWrkflwInitiated, null, this.isAuditTrailOn  ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
									}
								}
								//Changes Done By Shahu Mali on 10-10-13 .[WS3GBAS001] for multiDB connedction : END
							}
							*/
							//Commented and changed by Gulzar on 30/03/16. Removed the checking of  J2EE_VERSION : END
						}
						else
						{
							//Changed by Monif on 11/14/2008 [For special char parsing issue].
							//retString = xml2DBRem.saveXML2DB( this.refSer, new ibase.webitm.utility.GenericUtility()/*.getInstance()*/.serializeDom( this.detailDom ), this.objName, this.editFlag, this.noOfForms, ( this.editFlag.equalsIgnoreCase( "E" )? false : ( ( this.editFlag.equalsIgnoreCase( "A" ) && this.keyFlag.equalsIgnoreCase( "A" ) ) ) ? true : false ), this.userInfo.getLoginCode(), this.headerPKFieldNames, this.isAutoConfirm, getXtraParams(), this.taxList, this.wrkflwInit, this.isWrkflwToBeInitiated, this.wrkflwOpt, this.auditDataXmlBefore, getAuditXMLString(), this.headerPKFieldValues, this.isWrkflwInitiated  );
							//Changes Done By Shahu Mali on 10-10-13 .[WS3GBAS001] for multiDB connection : START
							if(transDB != null && !"null".equalsIgnoreCase(transDB) && transDB.trim().length() > 0)
							{
								if (isDataUpload)
								{
									//Changed by Prasad on 17/03/18 [formName implementation in transaction editor]
									retString = xml2dbejb.saveXML2DB( this.refSer, serializeDom( this.detailDom ), this.objName, this.editFlag, this.noOfForms, ( this.editFlag.equalsIgnoreCase( "E" )? false : ( ( this.editFlag.equalsIgnoreCase( "A" ) && this.keyFlag.equalsIgnoreCase( "A" ) ) ) ? true : false ), this.userInfo.getLoginCode(), this.headerPKFieldNames, this.isAutoConfirm, getXtraParams(), this.taxList, this.wrkflwInit, this.isWrkflwToBeInitiated, this.wrkflwOpt, this.auditDataXmlBefore, getAuditXMLString(), this.headerPKFieldValues, this.isWrkflwInitiated, this.isAuditTrailOn,this.userInfo, isDataUpload, this.objFormInfoMap ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
								}
								else
								{
									//Changed by Prasad on 17/03/18 [formName implementation in transaction editor]
									//Added By Pankaj T. on 15-10-18 for copy transaction add entry in audit_trail - start
									xml2dbejb.setCopyingRec(this.isCopyingRec);
									//Added By Pankaj T. on 03-12-19 for update attachment refId on finish against editorId in add mode
									xml2dbejb.setEditorId(this.editorId);
									retString = xml2dbejb.saveXML2DB( this.refSer, serializeDom( this.detailDom ), this.objName, this.editFlag, this.noOfForms, ( this.editFlag.equalsIgnoreCase( "E" )? false : ( ( this.editFlag.equalsIgnoreCase( "A" ) && this.keyFlag.equalsIgnoreCase( "A" ) ) ) ? true : false ), this.userInfo.getLoginCode(), this.headerPKFieldNames, this.isAutoConfirm, getXtraParams(), this.taxList, this.wrkflwInit, this.isWrkflwToBeInitiated, this.wrkflwOpt, this.auditDataXmlBefore, getAuditXMLString(), this.headerPKFieldValues, this.isWrkflwInitiated, this.isAuditTrailOn, this.userInfo, this.objFormInfoMap ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
									xml2dbejb.setCopyingRec(false);
									//Added By Pankaj T. on 15-10-18 for copy transaction add entry in audit_trail - end
								}
							}
							//Changes Done By Shahu Mali on 10-10-13 .[WS3GBAS001] for multiDB connection : END
						}
					}
					BaseLogger.log("3", userInfo,editorId, " ====1111======= Dnyaneshwar After saved the record retString["+retString+"]" );
					//Changed by Dhruv on 24/07/07 commented and replaced by below methods for supporting explicit/implicit tranasctional saving to ITM.End
					if(retString.indexOf( "<Errors>" ) == -1 ) //$NON-NLS-1$
					{
						//Added By Pankaj T. on 19-04-22 for apply presavedata on detailDom - start
						String preSaveData = xml2dbejb.getPreSaveResponse();
						this.detailDom = new E12GenericUtility().applyPostSaveDataOnDetail(preSaveData, this.detailDom, this.noOfForms);
						//Added By Pankaj T. on 19-04-22 for apply presavedata on detailDom - end
						
						//Added By Pankaj T. on 27-07-18 for apply postsavedata on detailDom - start
						String postSaveData = xml2dbejb.getPostSaveResponse();
						this.detailDom = new E12GenericUtility().applyPostSaveDataOnDetail(postSaveData, this.detailDom, this.noOfForms);
						//Added By Pankaj T. on 27-07-18 for apply postsavedata on detailDom - end
						if(this.tranType.equalsIgnoreCase( "U" ) && getDelFlagForDraft( tempObjName ).equalsIgnoreCase( "Y" ) ) //$NON-NLS-1$ //$NON-NLS-2$
						{
							deleteDraftObject();
						}
						if( this.tranType.equalsIgnoreCase( "U" ) ) //$NON-NLS-1$
						{
							this.systemDefObjName = null;
							setObjDetails( tempObjName );
							setHeaderPKFieldNames();
						}
						
						//Changed by Dnyaneshwar on 19/11/12 [ WS2GSUN002 ] Start
						String msgString = "";
						//Changes made by Gulzar on 12/02/14 [WS3GBAS001] to support multiDB connection : START
						if(transDB != null && !"null".equalsIgnoreCase(transDB) && transDB.trim().length() > 0)
						{
							msgString = getMessageOnSave( retString, userInfo );
						}
						else
						{
							msgString = getMessageOnSave( retString );						
						}
						//Changes made by Gulzar on 12/02/14 [WS3GBAS001] to support multiDB connection : END
						
						//Changed by Gulzar on 12/11/14
						String currPkVal = retString;
						this.headerPKFieldValues = currPkVal; // Added by Dnyaneshwar Chavan 20-Aug-15 [ PRIMARY_KEY tag value should not be null as per Danish Sir ] Start
						//retString = "<Root><Detail>Success</Detail><TranID>"+retString+"</TranID></Root>"; //$NON-NLS-1$ //$NON-NLS-2$
						retString = "<Root><Detail>Success</Detail><TranID>"+retString+"</TranID><MsgOnSave>"+msgString+"</MsgOnSave></Root>"; //$NON-NLS-1$ //$NON-NLS-2$
						//Changed by Dnyaneshwar on 19/11/12 [ WS2GSUN002 ] End
						
						//Changed by Gulzar on 06/11/14 : START
						//Implement new event 'call_report_save' which is get called after saving of transaction to send the report as mail attachment.
						try
						{
							String responseStr = "";
							boolean isEventFound = false;
							
							isEventFound = this.eventManager.isEventExist(objName, "call_report_save", this.userInfo);
							BaseLogger.log("3", userInfo,editorId,"isEventFound[call_report_save] =["+isEventFound+"]");
							
							if(isEventFound)
							{
								//Changes made by Gulzar on 10/06/15 to include the <editFlag> tag : START
								//which will be used while sending report, mail or sms 
								String editFlagStr = "<editFlag><![CDATA["+this.editFlag+"]]></editFlag>\n";
								//Changed by Prasad on 17/03/18 [formName implementation in transaction editor]
								String transXMLStr = this.masterDataStateful.getTransactionXMLForEdit(this.objName, this.pageContext, this.noOfForms, currPkVal, this.headerPKFieldDataTypes, null, this.taxList, this.refSer, this.userInfo.toString(), this.objFormsDetailList );
								StringBuffer transXmlBuf = new StringBuffer(transXMLStr);
								transXmlBuf.insert(transXMLStr.indexOf("<Detail1"), editFlagStr);
								
								//Changes made by Gulzar on 10/06/15 to include the <editFlag> tag : END
								
								transXMLStr = transXmlBuf.toString();
								
								BaseLogger.log("3", userInfo,editorId,"transXMLStr ::"+transXMLStr);
								
								//Changed by Gulzar on 30/06/15 [for checking transDb is null]
								//if(this.userInfo != null)
								if(transDB != null && !"null".equalsIgnoreCase(transDB) && transDB.trim().length() > 0)
								{
									responseStr = this.eventManager.executeSystemEvent(this.objName, "call_report_save", null, transXMLStr,  transXMLStr, getXtraParams(), "1", this.userInfo);
								}
								else
								{
									responseStr = this.eventManager.executeSystemEvent(this.objName, "call_report_save", null, transXMLStr,  transXMLStr, getXtraParams(), "1");
								}
								
								BaseLogger.log("3", userInfo,editorId,"responseStr ::"+responseStr);
							}
						}
						catch(Exception re)
						{
							re.printStackTrace();
							BaseLogger.log("0",userInfo,null,"MasterStatefulEJB.save() call_report_save Exception :["+E12GenericUtility.getStackTrace(re)+"]");
						}
						//Changed by Gulzar on 06/11/14 : END
						//Added By Pankaj T. on 18-04-19 for execute follow up actions like Email, SMS, Notification, Workflow, Update dirty datamodels, EDI etc. using JMS Queue - start
						try 
						{
							//Changed By Pankaj T. on 09-5-19 to pass pkNames for "EMAIL" action and send mail using Email template
							BaseLogger.log("3",userInfo,editorId,"MasterStatefulEJB.save() headerPKFieldNames:["+this.headerPKFieldNames+"]");
							String jmsData = new E12GenericUtility().serializeDom(detailDom)+"!~~!"+objName+"!~~!"+objContext+"!~~!"+this.headerPKFieldNames+"!~~!"+this.headerPKFieldValues+"!~~!"+"save"+"!~~!"+getXtraParams()+"!~~!"+userInfo.toString()+"!~~!"+this.coreModelId;
							JMSSender jmsSender = new JMSSender(userInfo);
							jmsSender.getMessage().setJMSType("FOLLOWUP_ACTIONS");
							jmsSender.send(jmsData);
						}
						catch (ITMException itme)
						{
							BaseLogger.log("0",userInfo,editorId,"MasterStatefulEJB.save() JMS ITMException :["+itme.getMessage()+"]");
						}
						catch (Exception e) 
						{
							BaseLogger.log("0",userInfo,editorId,"MasterStatefulEJB.save() JMS Exception :["+E12GenericUtility.getStackTrace(e)+"]");
						}
						//Added By Pankaj T. on 18-04-19 for execute follow up actions like Email, SMS, Notification, Workflow, Update dirty datamodels, EDI etc. using JMS Queue - end
						
					}//if(retString.indexOf("<Errors>") == -1)
					xml2dbejb = null;
				}
			}
			// Added method by Raju K on 23-Sep-14 for Event Log as Dnyaneshwar start--
			actionMode = "VIEW";
			if( editFlag.equals("A") )
			{
				actionMode = "ADD";
			}
			else if( editFlag.equals("E") )
			{
				actionMode = "EDIT";			
			}
			tempEditorId = this.getEditorId();
			//Commented and changed by Gulzar on 17/10/14
			//if ( this.getEditorId() != null && this.getEditorId().indexOf( userInfo.getLoginCode() ) != -1 )
			if ( tempEditorId != null && tempEditorId.trim().length() > 0 && tempEditorId.indexOf( userInfo.getLoginCode() ) != -1 )
			{
				//tempEditorId = this.getEditorId().substring( 0,this.getEditorId().indexOf( userInfo.getLoginCode() ) );
				tempEditorId = tempEditorId.substring( 0, tempEditorId.indexOf( userInfo.getLoginCode() ) );
			}
			if( userInfo != null )
			{
				//Added by shrutika on 03-12-18 for updateEventLog.
				//userEventLogEJB.setEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorId, actionMode , "Save", new Date(), new Date(),"" , this.headerPKFieldValues);  // pageContext:[" + this.pageContext + "], objContext:[" + this.objContext + "]
				//Change by shrutika on 05-01-19 for add exception.
				userEventLogEJB.updateEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorId, actionMode , "Save", startTime, new Date(),"" , this.headerPKFieldValues,"Success","SA","");  // pageContext:[" + this.pageContext + "], objContext:[" + this.objContext + "]
			}
			else
			{
				BaseLogger.log("3", userInfo,editorId," ============ User info is null then never create event log in save() method and MasterStatefulEJB.java file ");
			}
			// Added method by Raju K on 23-Sep-14 for Event Log as Dnyaneshwar end--
		}
		catch(Exception e)
		{
			//Added by shrutika on 25-12-18 [Start] for update status as Exception.
			if( userInfo != null )
			{
				//change by shrutika on 22-01-19 for parsing issue for writePrintStacktrace in updateEventLog.
				ITMException ie = new ITMException(e);
				userEventLogEJB.updateEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorId, actionMode , "Save", startTime, new Date(),"" , this.headerPKFieldValues,"Exception","SA",ie.getMessage());
			}
			//Added by shrutika on 25-12-18 [End] for update status as Exception.
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB : save :"+e); //$NON-NLS-1$
			e.printStackTrace();
			throw new ITMException(e);
		}
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]save completed ......"); //$NON-NLS-1$
		return retString;
	}
	//Changed by Dhruv on 24/07/07 commented and replaced by below methods for supporting explicit/implicit tranasctional saving to ITM.End
//-------------------------------------------------------------------------------------------------------------//	

	//Changed by Prasad on 02/11/16 [to search node from dbId]
	//private void crossUpdateDeailNode(String objContext, String domID, Document dom)throws ITMException
	private void crossUpdateDeailNode(String objContext, String domID, Document dom, String dbId)throws ITMException
	{
		BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB]In crossUpdateDeailNode ......"); //$NON-NLS-1$
		/*
		For Cross updation, the expression syntax for column name CROSS_UPDATE_EXPR in OBJ_FORMS table 
		
		CROSS_UPDATE_EXPR	----> [exp1][exp1]...
		where 
		[exp1]				----> ANY VALID MATHEMATICAL EXP

		EXPR_VAR_INFO		----> [Details of variables appearing in exp1][Details of variables appearing in exp2]...
		where 
		[Details of variables appearing in exp1]
							----> [ObjContext.RecordNo.DataType.VarName,ObjContext.RecordNo.DataType.VarName,...]

		TARGET_VAR_INFO		----> [Details of target field list for exp1][Details of target field list for exp1]...
		where 
		[Details of target field list for exp1]
							----> [ObjContext.RecordNo.DataType.VarName,ObjContext.RecordNo.DataType.VarName,...]

		eg. 
		For Sales Order window the entries for Form No 2 ie for 'Sorddet' form :
		CROSS_UPDATE_EXPR	----> [(quantity*rate)+tax_amt][abs(tax_amt)+50]
		EXPR_VAR_INFO		----> [2.1.I.quantity,2.1.D.rate,2.1.D.tax_amt][2..D.tax_amt]
		TARGET_VAR_INFO		----> [2.1.D.net_amt,1..D.tot_amt][1.1.S.remarks3]
		*/	
		try
		{
			if ( this.crossUpdateExprList.get( Integer.parseInt( objContext ) - 1 ) != null )
			{
				ArrayList exprList = getTokenList( ( String )this.crossUpdateExprList.get( Integer.parseInt( objContext ) - 1 ), "[]" ); //$NON-NLS-1$
				ArrayList varInfoList = getTokenList( ( String )this.exprVarInfoList.get( Integer.parseInt( objContext ) - 1 ), "[]" ); //$NON-NLS-1$
				ArrayList targetInfoList = getTokenList( ( String )this.targetVarInfoList.get( Integer.parseInt( objContext ) - 1 ), "[]" ); //$NON-NLS-1$
				BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB]Expression List for the current objContext :"+exprList+":"); //$NON-NLS-1$ //$NON-NLS-2$

				boolean evalFlag = true;
				String expVal = null;
				for (int ctr = 0; ctr < exprList.size(); ctr++)
				{
					String currExpr = (String)exprList.get(ctr);
					ArrayList currVarInfoList = getTokenList((String)varInfoList.get(ctr), ","); //$NON-NLS-1$
					expVal = evaluateExpression(currExpr, currVarInfoList);

					if(expVal != null)
					{
						ArrayList currTargetInfoList = getTokenList((String)targetInfoList.get(ctr), ","); //$NON-NLS-1$
						for (int targetCtr = 0; targetCtr < currTargetInfoList.size(); targetCtr++)
						{
							String currTargetInfo = (String)currTargetInfoList.get(targetCtr);
							String targetObjContext = currTargetInfo.substring(0, currTargetInfo.indexOf(".")); //$NON-NLS-1$
							currTargetInfo = currTargetInfo.substring(currTargetInfo.indexOf(".")+1); //$NON-NLS-1$

							String targetVarInfo = currTargetInfo.substring(currTargetInfo.indexOf(".")+1); //$NON-NLS-1$
							String colName = targetVarInfo.substring(targetVarInfo.indexOf(".")+1); //$NON-NLS-1$
							StringBuffer xmlDetailStrBuff = new StringBuffer();
							xmlDetailStrBuff.append("<Detail"+targetObjContext+" domID='"+domID+"'>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
							xmlDetailStrBuff.append("<"+colName+"><![CDATA["+expVal+"]]></"+colName+">"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
							xmlDetailStrBuff.append("</Detail"+targetObjContext+">"); //$NON-NLS-1$ //$NON-NLS-2$
							Document newDom = parseString(xmlDetailStrBuff.toString());
							DWObject dwObject = getDWObject(this.objName, Integer.parseInt(targetObjContext.trim()));
							Hashtable dbTypes = dwObject.getUpdateableLogNameColType();
							
							BaseLogger.log("3", userInfo,editorId,"Setting crossUpdate on node.. targetObjContext ["+targetObjContext+"] domID ["+domID+"]");
							
							//Changed by Prasad on 02/11/16 [to search node from dbId]
							//Node currDetailNode = searchNode(dom, targetObjContext, domID);
							Node currDetailNode = searchNode(dom, targetObjContext, domID, dbId);
							if(currDetailNode != null)
							{
								applyDataToXML( newDom.getDocumentElement(), currDetailNode, dbTypes );
							}
						}
					}
				}//for (int ctr = 0; ctr < exprList.size(); ctr++)									
			}//if (this.crossUpdateExprList.size() > 0)
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :crossUpdate :==>"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]crossUpdate completed ......"); //$NON-NLS-1$
	}	

	private void crossUpdate(String objContext, Document dom)throws ITMException
	{
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]In crossUpdate ......"); //$NON-NLS-1$
		/*
		For Cross updation, the expression syntax for column name CROSS_UPDATE_EXPR in OBJ_FORMS table 
		
		CROSS_UPDATE_EXPR	----> [exp1][exp1]...
		where 
		[exp1]				----> ANY VALID MATHEMATICAL EXP

		EXPR_VAR_INFO		----> [Details of variables appearing in exp1][Details of variables appearing in exp2]...
		where 
		[Details of variables appearing in exp1]
							----> [ObjContext.RecordNo.DataType.VarName,ObjContext.RecordNo.DataType.VarName,...]

		TARGET_VAR_INFO		----> [Details of target field list for exp1][Details of target field list for exp1]...
		where 
		[Details of target field list for exp1]
							----> [ObjContext.RecordNo.DataType.VarName,ObjContext.RecordNo.DataType.VarName,...]

		eg. 
		For Sales Order window the entries for Form No 2 ie for 'Sorddet' form :
		CROSS_UPDATE_EXPR	----> [(quantity*rate)+tax_amt][abs(tax_amt)+50]
		EXPR_VAR_INFO		----> [2.1.I.quantity,2.1.D.rate,2.1.D.tax_amt][2..D.tax_amt]
		TARGET_VAR_INFO		----> [2.1.D.net_amt,1..D.tot_amt][1.1.S.remarks3]
		*/	
		try
		{
			//Changed by MOnif on 18/03/09[To initialize exprJEP once Only].
			//org.nfunk.jep.JEP exprJEP = null;
			//Interpreter interpreter;
			if ( this.crossUpdateExprList.get( Integer.parseInt( objContext ) - 1 ) != null )
			{
				ArrayList exprList = getTokenList( ( String )this.crossUpdateExprList.get( Integer.parseInt( objContext ) - 1 ), "[]" ); //$NON-NLS-1$
				ArrayList varInfoList = getTokenList( ( String )this.exprVarInfoList.get( Integer.parseInt( objContext ) - 1 ), "[]" ); //$NON-NLS-1$
				ArrayList targetInfoList = getTokenList( ( String )this.targetVarInfoList.get( Integer.parseInt( objContext ) - 1 ), "[]" ); //$NON-NLS-1$
				BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB]Expression List for the current objContext :"+exprList+":"); //$NON-NLS-1$ //$NON-NLS-2$

				boolean evalFlag = true;
				String expVal = null;
				//Changed by MOnif on 18/03/09[To initialize exprJEP once Only].Start
				//exprJEP = new org.nfunk.jep.JEP();
				//exprJEP.addStandardFunctions();
				//exprJEP.addStandardConstants();
				//interpreter =new Interpreter();
				//Changed by MOnif on 18/03/09[To initialize exprJEP once Only].End
				for (int ctr = 0; ctr < exprList.size(); ctr++)
				{
					String currExpr = (String)exprList.get(ctr);
					ArrayList currVarInfoList = getTokenList((String)varInfoList.get(ctr), ","); //$NON-NLS-1$
					//BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB]Current Expression :"+currExpr+": and corr. var Info List :"+currVarInfoList+":");				
					//Changed by MOnif on 18/03/09[Overloaded evaluateExpression to Pass object of exprJEP]
					expVal = evaluateExpression(currExpr, currVarInfoList);
					//expVal = evaluateExpression(currExpr, currVarInfoList, exprJEP);
					
					//Try sending it to the corresponding apply method
					//Applying the expression value to the target field columns as mentioned in targetInfoList	
					if(expVal != null)
					{
						ArrayList currTargetInfoList = getTokenList((String)targetInfoList.get(ctr), ","); //$NON-NLS-1$
						for (int targetCtr = 0; targetCtr < currTargetInfoList.size(); targetCtr++)
						{
							String currTargetInfo = (String)currTargetInfoList.get(targetCtr);
							String targetObjContext = currTargetInfo.substring(0, currTargetInfo.indexOf(".")); //$NON-NLS-1$
							currTargetInfo = currTargetInfo.substring(currTargetInfo.indexOf(".")+1); //$NON-NLS-1$
							String targetDomId = currTargetInfo.substring(0, currTargetInfo.indexOf(".")); //$NON-NLS-1$
							if (targetDomId.length() == 0)
							{
								targetDomId = this.detailDomId;
							}
							String targetVarInfo = currTargetInfo.substring(currTargetInfo.indexOf(".")+1); //$NON-NLS-1$
							//applyResultToDom(dom, targetObjContext, targetDomId, targetVarInfo.substring(targetVarInfo.indexOf(".")+1), expVal);
							String colName = targetVarInfo.substring(targetVarInfo.indexOf(".")+1); //$NON-NLS-1$
							StringBuffer xmlDetailStrBuff = new StringBuffer();
							xmlDetailStrBuff.append("<Detail"+targetObjContext+" domID='"+targetDomId+"'>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
							xmlDetailStrBuff.append("<"+colName+"><![CDATA["+expVal+"]]></"+colName+">"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
							xmlDetailStrBuff.append("</Detail"+targetObjContext+">"); //$NON-NLS-1$ //$NON-NLS-2$
							Document newDom = parseString(xmlDetailStrBuff.toString());
							DWObject dwObject = getDWObject(this.objName, Integer.parseInt(targetObjContext.trim()));
							Hashtable dbTypes = dwObject.getUpdateableLogNameColType();
							//Changed by Prasad on 02/11/16 [to search node from dbId]
							//Node currDetailNode = searchNode(dom, targetObjContext, targetDomId);
							Node currDetailNode = searchNode(dom, targetObjContext, targetDomId, "");
							if(currDetailNode != null)
							{
								applyDataToXML( newDom.getDocumentElement(), currDetailNode, dbTypes );
							}
						}
					}
				}//for (int ctr = 0; ctr < exprList.size(); ctr++)									
			}//if (this.crossUpdateExprList.size() > 0)
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :crossUpdate :==>"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]crossUpdate completed ......"); //$NON-NLS-1$
	}	

	
	
	//Changed by MOnif on 18/03/09[OverLoaded Method to Pass object of exprJEP].
	//private String evaluateExpression( String expStr, ArrayList varInfoList , org.nfunk.jep.JEP exprJEP)throws ITMException
	private String evaluateExpression( String expStr, ArrayList varInfoList )throws ITMException
	{
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]In evaluateExpression ......"); //$NON-NLS-1$
		String expValue = null;
		Interpreter interpreter;
		//org.nfunk.jep.JEP exprJEP = null;
		
		try
		{
			//Changed by MOnif on 18/03/09.
			/*exprJEP = new org.nfunk.jep.JEP();
			exprJEP.addStandardFunctions();
			exprJEP.addStandardConstants();*/
			interpreter =new Interpreter();
			String firstVarInfo = (String)varInfoList.get(0);
			
			String firstVarObjCtx = firstVarInfo.substring(0, firstVarInfo.indexOf(".")); //$NON-NLS-1$
			firstVarInfo = firstVarInfo.substring(firstVarInfo.indexOf(".")+1); //$NON-NLS-1$
			
			String firstVarDomID = firstVarInfo.substring(0, firstVarInfo.indexOf(".")); //$NON-NLS-1$
			double expSumVal = 0d;

			NodeList detailList = null;
			int noOfRecords = 1;
			if(firstVarDomID.length() == 0)
			{
				detailList = searchNodes(this.detailDom, firstVarObjCtx);
				noOfRecords = detailList.getLength();
			}
			boolean flag = true;
			for(int i = 0; i < noOfRecords; i++)
			{
				Node curDetail = null;
				if(firstVarDomID.length() > 0)
				{
					firstVarDomID = (firstVarDomID.equalsIgnoreCase("X"))?this.detailDomId:firstVarDomID; //$NON-NLS-1$
					BaseLogger.log("3", userInfo,editorId,"domId replacing 'X' by :["+firstVarDomID+"]"); //$NON-NLS-1$ //$NON-NLS-2$
					//Changed by Prasad on 02/11/16 [to search node from dbId]
					//curDetail = searchNode(this.detailDom, firstVarObjCtx, firstVarDomID);
					curDetail = searchNode(this.detailDom, firstVarObjCtx, firstVarDomID, "");
				}
				else
				{
					curDetail = detailList.item(i);
				}
				if(curDetail == null)
				{
					continue;
				}
				String domID = curDetail.getAttributes().getNamedItem("domID").getNodeValue(); //$NON-NLS-1$
				//Check if current detail is temp. deleted i.e; marked as "D" in the dom, thiese values should not be considered				
				String updateFlag = null;
				NodeList colNodeList = curDetail.getChildNodes();
				for (int colCtr=0; colCtr<colNodeList.getLength(); colCtr++)
                {
					Node colNode = colNodeList.item(colCtr);
					if (colNode.getNodeName().equalsIgnoreCase("attribute")) //$NON-NLS-1$
					{
						updateFlag = ((colNode.getAttributes()).getNamedItem("updateFlag")).getNodeValue(); //$NON-NLS-1$
						break;
					}
				}
				if(updateFlag.equalsIgnoreCase("D")) //$NON-NLS-1$
				{
					continue;
				}
				for (int varCtr = 0; varCtr < varInfoList.size(); varCtr++)
				{
					String currVarInfo = (String)varInfoList.get(varCtr);
					String objContext = currVarInfo.substring(0, currVarInfo.indexOf(".")); //$NON-NLS-1$
					currVarInfo = currVarInfo.substring(currVarInfo.indexOf(".")+1); //$NON-NLS-1$
					String recordID = currVarInfo.substring(0, currVarInfo.indexOf(".")); //$NON-NLS-1$
					String varInfo = currVarInfo.substring(currVarInfo.indexOf(".")+1); //$NON-NLS-1$
					//Changed by Prasad on 02/11/16 [to search node from dbId]
					//Node detailNode = searchNode(this.detailDom, objContext, (recordID.length()== 0 || recordID.equalsIgnoreCase("X"))?domID:recordID); //$NON-NLS-1$
					Node detailNode = searchNode(this.detailDom, objContext, (recordID.length()== 0 || recordID.equalsIgnoreCase("X"))?domID:recordID, ""); //$NON-NLS-1$
					String varType = varInfo.substring(0, varInfo.indexOf(".")); //$NON-NLS-1$
					String varName = varInfo.substring(varInfo.indexOf(".")+1); //$NON-NLS-1$
					String currVarValue = getValueOfField(detailNode, varName);
					Object varValue = null;
					if (varType.equalsIgnoreCase("I")) //$NON-NLS-1$
					{
						varValue = Integer.valueOf((currVarValue == null || currVarValue.length() == 0?"0":currVarValue)); //$NON-NLS-1$
					}
					else if (varType.equalsIgnoreCase("N") || varType.equalsIgnoreCase("D")) //$NON-NLS-1$ //$NON-NLS-2$
					{
						varValue = Double.valueOf((currVarValue == null || currVarValue.length() == 0?"0":currVarValue)); //$NON-NLS-1$
					}
					else
					{
						varValue = ((currVarValue == null)?"":currVarValue); //$NON-NLS-1$
					}
					//Changed by MOnif on 18/03/09.
					//exprJEP.addVariableAsObject(varName, varValue);
					interpreter.set(varName,varValue);
				}
				//Changed by MOnif on 18/03/09.Start
				//Checking for errors after parsing the erpression and if no errors then evaluate the same
				/*String errorString = exprJEP.getErrorInfo();
				String expVal = "";
				if (errorString != null)
				{
					BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB] : Error while parsing expression : "+errorString);
					expVal = errorString;
					flag = false;
				}
				else
				{
					expVal = exprJEP.getValueAsObject().toString();
					BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB]Result of expression :"+expVal+":");
					flag = true;
				}*/
				String expVal = ""; //$NON-NLS-1$
				try
				{
					expVal=interpreter.eval( expStr ).toString();
					flag = true;
				}
				catch(InterpreterError inte)
				{
					BaseLogger.log("0", userInfo,editorId,"MasterStatefulEJB--Interpreter Exception: ==>\n"+ inte); //$NON-NLS-1$
					expVal=inte.getMessage();
					flag = false;
				}
				//Changed by MOnif on 18/03/09.End
				expSumVal += Double.parseDouble((expVal == null || expVal.length() == 0)?"0.0":expVal); //$NON-NLS-1$
			}//for(int i = 0; i < detailList.getLength(); i++)
			if (flag)
			{
				expValue = new E12GenericUtility().formatDouble(expSumVal, 3);
				//expValue = String.valueOf(expSumVal);
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB : evaluateExpression "+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]evaluateExpression completed ......"); //$NON-NLS-1$
		return expValue;
	}
	
	private String getChangedXMLString() throws ITMException
	{
		BaseLogger.log("2", userInfo,editorId,"Building Changed XML String for ChaNge Data Map size :["+this.changedDataMap.size()+"]"); //$NON-NLS-1$ //$NON-NLS-2$
		String retString = ""; //$NON-NLS-1$
		try
		{
			StringBuffer changedXMLStrBuff = new StringBuffer("<?xml version='1.0' encoding='"+this.userInfo.getCharEnc()+"'?><Root>\n"); //$NON-NLS-1$ //$NON-NLS-2$
			if (this.changedDataMap.size() > 0)
			{
				Set keySet = this.changedDataMap.keySet();
				Iterator iterator = keySet.iterator();
				String objContext = null;
				String domID = null;
				int i = 1;
				//BaseLogger.log("3", userInfo,editorId,"this.changedDataMapYUTUTUYT :"+this.changedDataMap);
				ArrayList allList = new ArrayList(this.noOfForms);
				for(int ctr = 0; ctr < this.noOfForms; ctr++)
				{
					allList.add(null);
				}
				//BaseLogger.log("3", userInfo,editorId,"allList :"+allList);
				while (iterator.hasNext())
				{
					String id = (String)iterator.next();
					
					//Changed by Roshan on 10/04/2007 to support more tan one digit obj context and dom ids.Start
					//String currDomID = id.substring( ( id.indexOf( "_" ) + 1 ), id.indexOf( "_",  ( id.indexOf( "_" ) + 1 ) ) );
					//String tagName = id.substring( id.indexOf( "_", 3 ) + 1 );
					String currObjContext = id.substring(0, id.indexOf( "_" ) ); //$NON-NLS-1$
					int domIdLen = id.indexOf( "_", ( id.indexOf( "_" ) + 1 ) ); //$NON-NLS-1$ //$NON-NLS-2$
					String currDomID =id.substring( ( id.indexOf( "_" ) + 1 ), domIdLen ); //$NON-NLS-1$
					String tagName = id.substring( domIdLen + 1 );
					//Changed by Roshan on 10/04/2007 to support more tan one digit obj context and dom ids.End
					
					Node curDetChild = (Node)this.changedDataMap.get(id);
					ArrayList currFormList = (ArrayList)allList.get(Integer.parseInt(currObjContext) - 1);
					if(currFormList == null)
					{
						currFormList = new ArrayList();
						allList.set(Integer.parseInt(currObjContext) - 1, currFormList);
					}
					int currFormListSize = currFormList.size();
					if(Integer.parseInt(currDomID) > currFormListSize)
					{
						for(; currFormListSize < Integer.parseInt(currDomID); currFormListSize++)
						{
							currFormList.add(null);
						}
					}
					StringBuffer currRecordColBuffer = (StringBuffer)currFormList.get(Integer.parseInt(currDomID) - 1);
					if(currRecordColBuffer == null)
					{
						currRecordColBuffer = new StringBuffer();
					}
					currFormList.set(Integer.parseInt(currDomID) - 1, currRecordColBuffer.append(serializeDom(curDetChild)));
				}//while (iterator.hasNext())
				//BaseLogger.log("3", userInfo,editorId,"allList :"+allList);
				for(int formCtr = 0; formCtr < this.noOfForms; formCtr++)
				{
					ArrayList currFormList = ( ArrayList )allList.get( formCtr );
					if(currFormList != null )
					{
						int noOfRecs = currFormList.size();
						for(int recCtr = 0; recCtr < noOfRecs; recCtr++)
						{
							if(currFormList.get(recCtr) != null)
							{
								changedXMLStrBuff.append("<Detail" + (formCtr+1)+"  domID='"+(recCtr+1)+"'>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
								changedXMLStrBuff.append(currFormList.get(recCtr).toString());
								if(this.isTaxChanged && ((formCtr + 1) == Integer.parseInt(this.objContext) && (recCtr + 1) == Integer.parseInt(this.detailDomId)))
								{
									changedXMLStrBuff.append(getAllTaxesXMLString(this.objContext, this.detailDomId));
									this.isTaxChanged = false;
								}
								changedXMLStrBuff.append("</Detail" + (formCtr+1) +">"); //$NON-NLS-1$ //$NON-NLS-2$
							}
						}
					}//if(currFormList != null)
				}//for(int formCtr = 0; formCtr < this.noOfForms; formCtr++)
			}
			if( this.isTaxChanged )
			{
				changedXMLStrBuff.append( "<Detail" + this.objContext +"  domID='"+this.detailDomId+"'>" ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				changedXMLStrBuff.append(getAllTaxesXMLString(this.objContext, this.detailDomId));
				changedXMLStrBuff.append( "</Detail" + this.objContext +">" ); //$NON-NLS-1$ //$NON-NLS-2$
			}
			//changedXMLStrBuff.append("<Detai2><item_code protect='1'><item_ser protect='1'></Detail2>");
			changedXMLStrBuff.append("</Root>\n"); //$NON-NLS-1$
			retString = changedXMLStrBuff.toString();
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB : getChangedXMLString :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return retString;
	}

	//Changed by Danish on 13/07/2006 to accomodate audit trail feature
	private String getAuditXMLString() throws ITMException
	{
		String retString = ""; //$NON-NLS-1$
		try
		{
			BaseLogger.log("3", userInfo,editorId,"this.editFlag ["+this.editFlag+"]");
			if( "A".equalsIgnoreCase(this.editFlag ) )
			{
				BaseLogger.log("3", userInfo,editorId,"returning blank in case of header add");
				return retString;
			}
			BaseLogger.log("3", userInfo,editorId,"this.isAuditTrailOn ["+this.isAuditTrailOn+"]");
			StringBuffer changedXMLStrBuff = new StringBuffer("<Root>\n"); //$NON-NLS-1$
			if ( this.isAuditTrailOn  && this.auditDataMap != null && this.auditDataMap.size() > 0)
			{
				BaseLogger.log("3", userInfo,editorId,"Building Changed XML String for Audit Data Map size :["+this.auditDataMap.size()+"]"); //$NON-NLS-1$ //$NON-NLS-2$
				Set keySet = this.auditDataMap.keySet();
				Iterator iterator = keySet.iterator();
				
				while (iterator.hasNext())
				{
					String currObjContext = (String)iterator.next();
					TreeMap tempHashMap = (TreeMap)this.auditDataMap.get(currObjContext);
					Set keySetInner = tempHashMap.keySet();
					Iterator iteratorInner = keySetInner.iterator();
					
					DWObject dwObject = getDWObject(this.objName, Integer.parseInt(currObjContext) );
					
					HashMap phyDispNameMap = dwObject.getPhysicalNameDisplayNameMap();
					Hashtable phyUpdDispNameMap = dwObject.getUpdateableLogPhyColNames();
					
					//Changed by Gulzar on 24/07/13 to get the dolumn data type 
					HashMap colDataTypeMap = dwObject.getColDataTypeMap();

					//BaseLogger.log("3", userInfo,editorId,"phyDispNameMap ["+phyDispNameMap+"]");
					//BaseLogger.log("3", userInfo,editorId,"phyUpdDispNameMap ["+phyUpdDispNameMap+"]");
					//BaseLogger.log("3", userInfo,editorId,"this.contextTitlesList ["+this.contextTitlesList+"]");
					String title = (String)this.contextTitlesList.get(Integer.parseInt(currObjContext) -1 );
					//BaseLogger.log("3", userInfo,editorId,"Title ["+title+"]");

					String preDomId = ""; //$NON-NLS-1$
					Node currNode = null;
					
					while (iteratorInner.hasNext())
					{
						String oldVal = ""; //$NON-NLS-1$
						String id = (String)iteratorInner.next();
						String currDomID = id.substring(0, id.indexOf("_"));//1_prod_form //$NON-NLS-1$
						String tagName = id.substring(id.indexOf("_") + 1); //$NON-NLS-1$
					 	String tagValue = (String)tempHashMap.get(id);

						//BaseLogger.log("3", userInfo,editorId,"id ["+id+"]");
						BaseLogger.log("3", userInfo,editorId," ( ! "+preDomId+".equals("+currDomID+"))  ["+( ! preDomId.equals(currDomID)) +"]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
						
						if ( ! preDomId.equals(currDomID) )
						{
							//Changed by Prasad on 02/11/16 [to search node from dbId]
							//currNode = searchNode(parseString(this.auditDataXmlBefore), currObjContext, currDomID);
							currNode = searchNode(parseString(this.auditDataXmlBefore), currObjContext, currDomID, "");
						}

						if (currNode != null )
						{
							oldVal = getValueOfField(currNode, tagName);
						}
						
						String newValue = (tagValue == null || "null".equals(tagValue)) ? "" : tagValue;
						String oldValue = (oldVal == null || "null".equals(oldVal)) ? "" : oldVal;
						
						BaseLogger.log("3", userInfo,editorId,"newValue ["+newValue+"] oldVal ["+oldValue+"] newValue.equals(oldVal) ["+newValue.equalsIgnoreCase(oldValue)+"]");
						
						//Changed by gulzar on 24/07/13 - instead of string comparison if column data type is decimal or number 
						//then newValue and oldvalue should compare after parsing : START
						boolean applyChange = false;
						String currColDataType = "";
						if(colDataTypeMap.containsKey(tagName))
						{
							currColDataType = (String)colDataTypeMap.get(tagName);
						}
						BaseLogger.log("3", userInfo,editorId,"tagName =["+tagName+"], currColDataType =["+currColDataType+"]");
						if( currColDataType != null && ("decimal".equalsIgnoreCase(currColDataType) || "number".equalsIgnoreCase(currColDataType)) )
						{
							newValue = (newValue.trim().length() == 0) ? "0" : newValue;
							oldValue = (oldValue.trim().length() == 0) ? "0" : oldValue;
							if((Double.parseDouble(newValue) != Double.parseDouble(oldValue)) )
							{
								applyChange = true;
							}
						}
						else if( ! newValue.trim().equalsIgnoreCase(oldValue.trim()) )
						{
							applyChange = true;
						}
						BaseLogger.log("3", userInfo,editorId,"applyChange =["+applyChange+"]");
						//Changes made by Pratheek on 02-08-19[ to check the mode if user has edited ,added or deleted ]-Start
						String action = getChgMode(searchNode(this.detailDom, currObjContext, currDomID, ""));
						BaseLogger.log("3", userInfo,editorId,"action 4543!!!! ["+action+"]");
						//Changes made by Pratheek on 02-08-19[ to check the mode if user has edited ,added or deleted ]-End
						//if( ! newValue.equalsIgnoreCase(oldValue) )
						if( applyChange && !"Deleted".equalsIgnoreCase(action) && !"".equalsIgnoreCase(action))
						//Changed by Gulzar on 27/07/13 : END
						{
							//Changed by Prasad on 02/11/16 [to search node from dbId]
							//String chgMode = getChgMode(searchNode(this.detailDom, currObjContext, currDomID));
							String chgMode = getChgMode(searchNode(this.detailDom, currObjContext, currDomID, ""));
	
							//Changed By by Swapnil Ph on 16-mar-12 [   ] Start 
							//String updDispName = (String)phyUpdDispNameMap.get(tagName);
							//String dispName = (String)phyDispNameMap.get(updDispName);
							String dispName = (String)phyDispNameMap.get( tagName );
							
							//Changed By by Swapnil Ph on 16-mar-12 end 
							
							if (dispName != null && dispName.length() > 0)
							{
								if(dispName.indexOf("_") != -1)  //Minal 17/11/06 Start //$NON-NLS-1$
								{
									dispName = new E12GenericUtility().initCap(dispName.replace('_',' ')," ");  //$NON-NLS-1$
								}
								//Minal 17/11/06 End
								changedXMLStrBuff.append("<Detail" + currObjContext+"  domID='"+currDomID+"' title='"+title+"'>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
								changedXMLStrBuff.append("<field_name><![CDATA["+tagName+"]]></field_name>"); //$NON-NLS-1$ //$NON-NLS-2$
								changedXMLStrBuff.append("<field_disp_name><![CDATA["+dispName+"]]></field_disp_name>"); //$NON-NLS-1$ //$NON-NLS-2$
								changedXMLStrBuff.append("<new_value><![CDATA["+newValue+"]]></new_value>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
								changedXMLStrBuff.append("<old_value><![CDATA["+oldValue+"]]></old_value>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
								changedXMLStrBuff.append("<chg_mode><![CDATA["+chgMode+"]]></chg_mode>"); //$NON-NLS-1$ //$NON-NLS-2$
								changedXMLStrBuff.append("</Detail" + currObjContext +">"); //$NON-NLS-1$ //$NON-NLS-2$
							}
						}
						else if( "Deleted".equalsIgnoreCase(action) )
						{
							//Changes made by Pratheek on 02-08-19[ to show the deleted transcation data in audit trail]-Start
							String dispName = (String)phyDispNameMap.get( tagName );
							if (dispName != null && dispName.length() > 0)
							{
								if(dispName.indexOf("_") != -1)  
								{
									dispName = new E12GenericUtility().initCap(dispName.replace('_',' ')," ");  //$NON-NLS-1$
								}
								changedXMLStrBuff.append("<Detail" + currObjContext+"  domID='"+currDomID+"' title='"+title+"'>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
								changedXMLStrBuff.append("<field_name><![CDATA["+tagName+"]]></field_name>"); //$NON-NLS-1$ //$NON-NLS-2$
								changedXMLStrBuff.append("<field_disp_name><![CDATA["+dispName+"]]></field_disp_name>"); //$NON-NLS-1$ //$NON-NLS-2$
								changedXMLStrBuff.append("<new_value><![CDATA["+newValue+"]]></new_value>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
								changedXMLStrBuff.append("<old_value><![CDATA["+oldValue+"]]></old_value>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
								changedXMLStrBuff.append("<chg_mode><![CDATA["+action+"]]></chg_mode>"); //$NON-NLS-1$ //$NON-NLS-2$
								changedXMLStrBuff.append("</Detail" + currObjContext +">"); //$NON-NLS-1$ //$NON-NLS-2$
							}
							//Changes made by Pratheek on 02-08-19[ to show the deleted transcation data in audit trail]-End
						}
						preDomId = currDomID;
					}
				}//while (iterator.hasNext())
			}
			changedXMLStrBuff.append("</Root>\n"); //$NON-NLS-1$
			retString = changedXMLStrBuff.toString();
			
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB : getChangedXMLString :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		BaseLogger.log("2", userInfo,editorId,"Audit retString ["+retString.length()+"]retString"+retString); //$NON-NLS-1$ //$NON-NLS-2$
		return retString;
	}

	private boolean deleteDraftObject()throws ITMException
	{
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]Deleting the draft object...........");		 //$NON-NLS-1$
		boolean deleteDraft = false;
		try
		{
			deleteDraft = this.dbAccess.deleteDraftObject(((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId), this.userInfo.toString());
		}
		catch(Exception e)
		{	
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :deleteDraftObject :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]Draft delete status :"+deleteDraft+":"); //$NON-NLS-1$ //$NON-NLS-2$
		return deleteDraft;
	}

//-------------------------------------------------------------------------------------------------------------//	
	//Changed by Dhruv on 24/07/07 commented and replaced by below methods for overloading processRequest to accept db conn.Start
	/*
	public String processRequest( String[] user, String siteCode, boolean isAuthentic, String xmlString )throws RemoteException, ITMException
	{
		String retString = null;
		BaseLogger.log("3", userInfo,editorId, "siteCode :[" + siteCode + "] isAuthentic :[" + isAuthentic + "]" );
		BaseLogger.log("3", userInfo,editorId,"xmlString :["+xmlString+"]");
		try
		{
			if (this.userInfo == null)
			{
				this.userInfo = new ibase.utility.UserInfoBean( user, siteCode, isAuthentic );
				BaseLogger.log("3", userInfo,editorId,"User Info Created for non stateful request : [" + this.userInfo + "]");
			}
			retString = processRequest( this.userInfo, xmlString );
		}
		catch (Exception e)
		{
			BaseLogger.log("3", userInfo,editorId,"Exception :MasterStatefulEJB : processRequest :==>Exception");
			e.printStackTrace();
			throw new ITMException(e);
		}
		BaseLogger.log("3", userInfo,editorId,"Control Returning back to ITMService with String :"+retString+":");
		return retString;
	}
	*/

	/**
	 * 
	 * @param user - o position value is userId.
	 * @param siteCode
	 * @param isAuthentic
	 * @param xmlString
	 * @param isPartOfExtTrans
	 * @param con
	 * @return
	 * @throws RemoteException
	 * @throws ITMException
	 */
	public String processRequest( String[] user, String siteCode, boolean isAuthentic, String xmlString, boolean isPartOfExtTrans, Connection con )throws RemoteException, ITMException
	{
		String retString = null;
		BaseLogger.log("2", userInfo,editorId, "user array:[ "+user+" ]\n siteCode :[" + siteCode + "]\n isAuthentic :[" + isAuthentic + "]" ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		try
		{
			if (this.userInfo == null)
			{
				//this.userInfo = new ibase.utility.UserInfoBean( user, siteCode, isAuthentic );
				/*DBAccessLocal dbAccess = null;
				dbAccess = (DBAccessLocal)this.initialContext.lookup("ibase/DBAccessEJB/local");*/
				DBAccessEJB dbAccess = new DBAccessEJB();
				//Added by Pratheek on 14/09/19 [to pass the updated site_cdoe if present when creating new userInfo] START
				//this.userInfo = dbAccess.createUserInfo(user[0]);
				this.userInfo = dbAccess.createUserInfo(user[0],siteCode); 
				//Added by Pratheek on 14/09/19 [to pass the updated site_cdoe if present when creating new userInfo] End
				BaseLogger.log("3", userInfo,editorId,"User Info Created for non stateful request : [" + this.userInfo + "]");
				dbAccess = null;
			}
			retString = processRequest( this.userInfo, xmlString, isPartOfExtTrans, con );
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB : processRequest :==>Exception"); //$NON-NLS-1$
			e.printStackTrace();
			throw new ITMException(e);
		}
		BaseLogger.log("2", userInfo,editorId,"Control Returning back to ITMService with String :"+retString.length()+":"); //$NON-NLS-1$ //$NON-NLS-2$
		return retString;
	}
	
	/*
	public String processRequest( String userInfoStr, String xmlString )throws RemoteException, ITMException
	{
		String retString = null;
		try
		{
			if ( this.userInfo == null )
			{
				this.userInfo = new ibase.utility.UserInfoBean( userInfoStr );
				BaseLogger.log("3", userInfo,editorId, "User Info Created for non stateful request : [" + this.userInfo + "]" );
			}
			retString = processRequest( this.userInfo, xmlString );
		}
		catch ( ITMException itme )
		{
			throw itme;
		}
		catch ( Exception e )
		{
			throw new ITMException( e );
		}
		BaseLogger.log("3", userInfo,editorId,"Control Returning back to ITMService with String :"+retString+":");
		return retString;
	}
	*/
	
	/**
	 * 
	 * @param userInfoStr
	 * @param xmlString
	 * @param isPartOfExtTrans
	 * @param con
	 * @return
	 * @throws RemoteException
	 * @throws ITMException
	 */
	public String processRequest( String userInfoStr, String xmlString, boolean isPartOfExtTrans, Connection con )throws RemoteException, ITMException
	{
		String retString = null;
		try
		{
			if ( this.userInfo == null )
			{
				this.userInfo = new ibase.utility.UserInfoBean( userInfoStr );
				BaseLogger.log("3", userInfo,editorId, "User Info Created for non stateful request : [" + this.userInfo + "]" );
			}
			retString = processRequest( this.userInfo, xmlString, isPartOfExtTrans, con );
		}
		catch ( ITMException itme )
		{
			throw itme;
		}
		catch ( Exception e )
		{
			throw new ITMException( e );
		}
		BaseLogger.log("2", userInfo,editorId,"Control Returning back to ITMService with String :"+retString.length()+":"); //$NON-NLS-1$ //$NON-NLS-2$
		return retString;
	}

	/*
	//Changed by Kunjal on 24/02/2007 to reimplement processrequest through copy transaction.
	public String processRequest( ibase.utility.UserInfoBean userInfo, String xmlString )throws RemoteException, ITMException
	{
		BaseLogger.log("3", userInfo,editorId,"------------- [MasterStatefulEJB]calling processRequest ...");
		String retString = null;
		String childString = null;
		Document chgDom = null;
		try
		{
			if (this.userInfo == null)
			{
				this.userInfo = userInfo;
			}

			updateHeaderInfoMap(xmlString);
			setObjDetails(objName);
			setContextDetails();
			
			//Changed by Dhruv to handle validation 01/07/2006
			String reqForcedFlag = ( String )this.headerInfoMap.get( "forcedSave" );
			boolean isModeInteractive = false;
			if( this.headerInfoMap.get( "isModeInteractive" ) != null )
			{
				isModeInteractive = ( ( Boolean )this.headerInfoMap.get( "isModeInteractive" ) ).booleanValue();
			}
			 
			if ( this.wrkflwProcInstId != null && this.wrkflwProcInstId.length() > 0 )
			{
				this.isWrkflwToBeInitiated = false;
				this.isWrkflwInitiated = true;
			}
			Document xmlStrDoc = null;
			if( ( ( String )this.headerInfoMap.get( "action" ) ).equalsIgnoreCase( "SAVE" ) )
			{
				BaseLogger.log("3", userInfo,editorId, "-------1------- Calling getTransCopyXMLString for data string" );// [" + xmlString + "]" );
				String xmlStr = getTransCopyXMLString(objName, objContext, null, xmlString );
				getXtraParams();
				if( xmlStr.indexOf("<Errors>") != -1 )
				{
					return xmlStr;
				}
			}
			else if( ( ( String )this.headerInfoMap.get( "action" ) ).equalsIgnoreCase( "EDIT" ) && ( String )this.headerInfoMap.get( "pkValues" ) != null )
			{
				getDetailXMLDomString( objName, this.objContext, "E", ( String )this.headerInfoMap.get( "pkValues" ), "" );

				BaseLogger.log("3", userInfo,editorId,"xmlString ["+xmlString+"]");
				
				NodeList childNodeList = parseString( xmlString ).getChildNodes().item(0).getChildNodes();
				int childNodeListLength = childNodeList.getLength();
				for ( int i = 0; i < childNodeListLength; i++ )
				{
					Node childNode = childNodeList.item( i );

					if (  childNode.getNodeName().indexOf("Detail") != -1 )
					{
						String currDomID = childNode.getAttributes().getNamedItem("domID").getNodeValue();
						String currObjCtx = childNode.getAttributes().getNamedItem("objContext").getNodeValue();

						//The foll. logic fails if on editing a detail record is added to the existing transaction.
						Node copyToNode = searchNode( this.detailDom, currObjCtx, currDomID );

						copyRecord( childNode, copyToNode, null, null, null, currObjCtx );	
						
						NodeList copyToNodeList = copyToNode.getChildNodes();
						int copyToNodeListLen = copyToNodeList.getLength();
						for (int ctr = 0; ctr < copyToNodeListLen; ctr++)
						{
							if ( ("attribute").equals( copyToNodeList.item( ctr ).getNodeName() ) )
							{
								copyToNodeList.item(ctr).getAttributes().getNamedItem("updateFlag").setNodeValue("E");
								break;
							}
						}
					}
				}
				//Changed by Danish on 05/03/2007 -- [Saving data in case of Edited from outside].End
			}
			if( ! isModeInteractive )
			{
				StringBuffer hdrStrBuff = new StringBuffer();
				hdrStrBuff.append( "<Root>" );
				hdrStrBuff.append( "<header>" );
				hdrStrBuff.append( "<objName><![CDATA["+this.objName+"]]></objName>" );
				hdrStrBuff.append( "<pageContext><![CDATA[2]]></pageContext>" );
				hdrStrBuff.append( "<editFlag><![CDATA[" + this.editFlag + "]]></editFlag>" );
				hdrStrBuff.append( "<action><![CDATA[SAVE]]></action>" );
				hdrStrBuff.append( "<elementName><![CDATA[]]></elementName>" );
				hdrStrBuff.append( "<taxKeyValue><![CDATA[]]></taxKeyValue>" );
				hdrStrBuff.append( "<taxInFocus><![CDATA[false]]></taxInFocus>" );
				hdrStrBuff.append( "<objContext><![CDATA["+this.objContext+"]]></objContext>" );												
				hdrStrBuff.append( "<focusedColumn><![CDATA[]]></focusedColumn>" );
				hdrStrBuff.append( "<forcedSave><![CDATA[true]]></forcedSave>" );
				hdrStrBuff.append( "<keyValue><![CDATA["+ this.detailDomId+"]]></keyValue>" );
				//Changed by Danish on 06/03/2007 to send process instance id.
				if ( this.wrkflwProcInstId != null && this.wrkflwProcInstId.length() > 0 )
				{
					hdrStrBuff.append( "<wrkflwProcInstId><![CDATA[" + this.wrkflwProcInstId + "]]></wrkflwProcInstId>" );
				}
				hdrStrBuff.append( "<saveLevel><![CDATA[1]]></saveLevel>" );
				hdrStrBuff.append( "</header>" );
				hdrStrBuff.append( "</Root>" );
				//BaseLogger.log("3", userInfo,editorId,"----------- 777  --------- this.detailDom :"+serializeDom( this.detailDom ) );
				retString = updateDetailDom( hdrStrBuff.toString() );
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("3", userInfo,editorId,"Exception :MasterStatefulEJB : processRequest :==>Exception");
			e.printStackTrace();
			retString = new ibase.webitm.utility.GenericUtility().createErrorString(e);
		}
		BaseLogger.log("3", userInfo,editorId,"Control Returning back to ITMService .....");
		return retString;
	}
	*/

	//Changed by Kunjal on 24/02/2007 to reimplement processrequest through copy transaction.
	/**
	 * 
	 * @param userInfo
	 * @param xmlString
	 * @param isPartOfExtTrans
	 * @param con
	 * @return
	 * @throws RemoteException
	 * @throws ITMException
	 */
	public String processRequest( ibase.utility.UserInfoBean userInfo, String xmlString, boolean isPartOfExtTrans, Connection con )throws RemoteException, ITMException
	{
		BaseLogger.log("2", userInfo,editorId,"------------- [MasterStatefulEJB]calling processRequest ..."); //$NON-NLS-1$
		String retString = null;
		String childString = null;
		Document chgDom = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		try
		{
			//Changed by Dhruv on 13/07/07
			this.dbSaveConn_doNotUse = con;
			this.isPartOfExtTrans = isPartOfExtTrans;

			if (this.userInfo == null)
			{
				this.userInfo = userInfo;
			}

			updateHeaderInfoMap(xmlString);
			//Changes made by Shahu on 10/10/13 [WS3GBAS001] to support multiDB connection : START
			String transDB = this.userInfo.getTransDB();
			//if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
			{
				setObjDetails(objName, userInfo);
				setContextDetails(userInfo);
			}
			//Changes made by Shahu on 10/10/13 [WS3GBAS001] to support multiDB connection : END
			
			//Changed by Dhruv to handle validation 01/07/2006
			String reqForcedFlag = ( String )this.headerInfoMap.get( "forcedSave" ); //$NON-NLS-1$
			boolean isModeInteractive = false;
			if( this.headerInfoMap.get( "isModeInteractive" ) != null ) //$NON-NLS-1$
			{
				isModeInteractive = ( ( Boolean )this.headerInfoMap.get( "isModeInteractive" ) ).booleanValue(); //$NON-NLS-1$
			}
			
			if ( this.wrkflwProcInstId != null && this.wrkflwProcInstId.length() > 0 )
			{
				this.isWrkflwToBeInitiated = false;
				this.isWrkflwInitiated = true;
			}
			Document xmlStrDoc = null;
			if( ( ( String )this.headerInfoMap.get( "action" ) ).equalsIgnoreCase( "SAVE" ) ) //$NON-NLS-1$ //$NON-NLS-2$
			{
				BaseLogger.log("3", userInfo,editorId, "-------1------- Calling getTransCopyXMLString for data string" );// [" + xmlString + "]" ); //$NON-NLS-1$
				String xmlStr = getTransCopyXMLString(objName, objContext, null, xmlString );
				getXtraParams();
				if( xmlStr.indexOf("<Errors>") != -1 ) //$NON-NLS-1$
				{
					return xmlStr;
				}
			}
			else if( ( ( String )this.headerInfoMap.get( "action" ) ).equalsIgnoreCase( "EDIT" ) && ( String )this.headerInfoMap.get( "pkValues" ) != null ) //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			{
				//Changed By Pankaj T on 14-06-17 [handle response if error] - Start
				//getDetailXMLDomString( objName, this.objContext, "E", ( String )this.headerInfoMap.get( "pkValues" ), "" ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				String xmlStr = getDetailXMLDomString( objName, this.objContext, "E", ( String )this.headerInfoMap.get( "pkValues" ), "" ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				BaseLogger.log("9", userInfo,editorId,"Response from getDetailXMLDomString::["+xmlStr+"]");
				if( xmlStr.indexOf("<Errors>") != -1 ) //$NON-NLS-1$
				{
					BaseLogger.log("3", userInfo,editorId,"In if");
					return xmlStr;
				}
				//Changed By Pankaj T on 14-06-17 [handle response if error] - End
				//Changed by Monif on 7/3/2008 [ Appending New Details from processRequest xmlString ]
				appendNewDetailsInDom( xmlString );
				
				//BaseLogger.log("3", userInfo,editorId,"Amittt In Edit Mode xmlString ["+xmlString+"]");
				
				NodeList childNodeList = parseString( xmlString ).getChildNodes().item(0).getChildNodes();
				//BaseLogger.log("3", userInfo,editorId,"Amitt -- childNodeList Length Before  ["+childNodeList.getLength()+"]");
				//childNodeList = parseString( xmlString ).getElementsByTagName("group0").item(0).getChildNodes(); // Amit D on 04  Dec 13
				int childNodeListLength = childNodeList.getLength();
				for ( int i = 0; i < childNodeListLength; i++ )
				{
					Node childNode = childNodeList.item( i );

					if (  childNode.getNodeName().indexOf("Detail") != -1 ) //$NON-NLS-1$
					{
						//Added by samadhan on 28/07/2016[S15LBAS001] for get dom id using currObjCtx and currDbId
						//Changed by Danish on 10/09/2007 for getting curDbID instead of domID
						//String currDomID = childNode.getAttributes().getNamedItem("domID").getNodeValue();
						String currDomID = childNode.getAttributes().getNamedItem("domID").getNodeValue();
						String currDbID = childNode.getAttributes().getNamedItem("dbID").getNodeValue(); //$NON-NLS-1$
						//Changed by Prasad on 02/11/16 [to search node from dbId]
						this.currDbID = currDbID;

						String currObjCtx = childNode.getAttributes().getNamedItem("objContext").getNodeValue(); //$NON-NLS-1$

						//Changed by samadhan on 28/07/2016[S15LBAS001] for get dom id using currObjCtx and currDbId
						//The foll. logic fails if on editing a detail record is added to the existing transaction.
						//Changed by Danish on 10/09/2007 for getting Node of curDbID
						//Node copyToNode = searchNode( this.detailDom, currObjCtx, currDomID );
						//Node copyToNode = searchNode( this.detailDom, currObjCtx, getDomId( currDbID ) );
						//Changed by Prasad on 02/11/16 [to search node from dbId]
						//Node copyToNode = searchNode( this.detailDom, currObjCtx, getDomId( currDbID , currObjCtx ) );
						//Added by Prasad on 15/06/17 [to resolve detailDomId related issue in edit mode from processRequest] START
						this.detailDomId = getDomId( currDbID , currObjCtx );
						if ( this.detailDomId == null || this.detailDomId.trim().length() == 0 )
						{
							this.detailDomId = currDomID;
						}
						//Added by Prasad on 15/06/17 [to resolve detailDomId related issue in edit mode from processRequest] END
						Node copyToNode = searchNode( this.detailDom, currObjCtx, this.detailDomId, currDbID );
						//Changed by Monif on 16/04/09. Validation in Xform only if it is ERROR in Edit Case][WS89NOV542].Start
						//copyRecord( childNode, copyToNode, null, null, null, currObjCtx );
						//Changes made by Gulzar on 12/02/14 [WS3GBAS001] to support multiDB connection : START
						ArrayList itemChangeList = null;
						//Changed by Prasad on 28/12/16 [do item change only if updateFlag E and fileUpload] START
						/*if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
						{
							itemChangeList = this.dbAccess.getManadatoryItemChangeElementList( this.objName,currObjCtx, "Y", this.userInfo ); // Added by AMit D on 01 Jan 14.
						}
						else
						{
							itemChangeList = this.dbAccess.getManadatoryItemChangeElementList( this.objName,currObjCtx, "Y" ); // Added by AMit D on 01 Jan 14.
						}*/
						if( isFileUpload() )
						{
							NodeList childToNodeList = childNode.getChildNodes();
							int childToNodeListLen = childToNodeList.getLength();
							for (int ctr = 0; ctr < childToNodeListLen; ctr++)
							{
								if ( ("attribute").equals( childToNodeList.item( ctr ).getNodeName() ) ) //$NON-NLS-1$
								{
									String updateFlag = ((childToNodeList.item(ctr).getAttributes()).getNamedItem("updateFlag")).getNodeValue();
									if( ! "N".equalsIgnoreCase( updateFlag ) )
									{
										if ( transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0 )
										{
											itemChangeList = this.dbAccess.getManadatoryItemChangeElementList( this.objName,currObjCtx, "Y", this.userInfo ); // Added by AMit D on 01 Jan 14.
										}
									}
									break;
								}
							}
						}
						else
						{
							if ( transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0 )
							{
								itemChangeList = this.dbAccess.getManadatoryItemChangeElementList( this.objName,currObjCtx, "Y", this.userInfo ); // Added by AMit D on 01 Jan 14.
							}
						}
						//Changed by Prasad on 28/12/16 [do item change only if updateFlag E and fileUpload] END
						//Changes made by Gulzar on 12/02/14 [WS3GBAS001] to support multiDB connection : END
						
						//Changed by samadhan on 09/09/2016[S15LBAS001] for force tax calculation
						//String copyStatusStr = copyRecord( childNode, copyToNode, null, null, itemChangeList, currObjCtx ); // Send Item Change Arraylist as an input Added by MAIt D on 13 Jan 14.
						//Added By Pankaj T. on 03-11-2020 - return a error string if passed xml string node not matched with existing record node - start
						if( copyToNode == null )
						{
							E12GenericUtility e12GenericUtility = new E12GenericUtility();
							String message = "Unable to find the node in the existing record against Form No:"+currObjCtx+",DomId:"+this.detailDomId+" & DbID"+currDbID;
							retString = e12GenericUtility.getErrorString("", "E", "", message, "", "");
							BaseLogger.log("3", userInfo,editorId,"retString if copyToNode is null::["+retString+"]");
							return retString;
						}
						//Added By Pankaj T. on 03-11-2020 - return a error string if passed xml string node not matched with existing record node - end
						String copyStatusStr = copyRecord( childNode, copyToNode, null, null, itemChangeList, currObjCtx, false);
						BaseLogger.log("3", userInfo,editorId,"copyStatusStr::["+copyStatusStr+"]");
						if( copyStatusStr.indexOf("<Errors>") != -1 ) //$NON-NLS-1$
						{
							NodeList errorNodeList = new E12GenericUtility().parseString(copyStatusStr).getElementsByTagName("error"); //$NON-NLS-1$
							boolean isErrorNodeFound = false;
							int errorNodeListLen = errorNodeList.getLength();
							for (int errCtr = 0; errCtr < errorNodeListLen; errCtr++)
							{
								Node errorNode = errorNodeList.item( errCtr );
								String errorType = errorNode.getAttributes().getNamedItem( "type" ).getNodeValue(); //$NON-NLS-1$
								if( ( ("E").equals( errorType ) ) ) //$NON-NLS-1$
								{
									return copyStatusStr;
								}
							}
						}
						//Changed by Monif on 16/04/09. Validation in Xform only if it is ERROR in Edit Case][WS89NOV542] .End
						
						NodeList copyToNodeList = copyToNode.getChildNodes();
						int copyToNodeListLen = copyToNodeList.getLength();
						for (int ctr = 0; ctr < copyToNodeListLen; ctr++)
						{
							if ( ("attribute").equals( copyToNodeList.item( ctr ).getNodeName() ) ) //$NON-NLS-1$
							{
								//Changed by Samadhan on 28/07/2016[S15LBAS001] for updateFlag "D" can't set "E" start
								//copyToNodeList.item(ctr).getAttributes().getNamedItem("updateFlag").setNodeValue("E"); //$NON-NLS-1$ //$NON-NLS-2$
								String updateFlag = ((copyToNodeList.item(ctr).getAttributes()).getNamedItem("updateFlag")).getNodeValue();
								//Changed by Prasad on 28/12/16 [set updateFlag E if data not from fileUpload] START
								//if( ! updateFlag.equalsIgnoreCase( "D" ) )
								if( ! updateFlag.equalsIgnoreCase( "D" ) && ! isFileUpload() )
								{
									copyToNodeList.item(ctr).getAttributes().getNamedItem("updateFlag").setNodeValue("E");
								}
								//Changed by Samadhan on 28/07/2016 for updateFlag "D" can't set "E" end
								//break;
							}
						}
					}
				}
				//Changed by Danish on 05/03/2007 -- [Saving data in case of Edited from outside].End
				//Changed by Monif on 7/3/2008 [ Appending New Details from processRequest xmlString ]
				//Changed by Danish on 20/12/2007 [ Appending New Details from processRequest xmlString ]
				//appendNewDetailsInDom( xmlString );
			}
			if( ! isModeInteractive )
			{
				StringBuffer hdrStrBuff = new StringBuffer();
				hdrStrBuff.append( "<Root>" ); //$NON-NLS-1$
				hdrStrBuff.append( "<header>" ); //$NON-NLS-1$
				hdrStrBuff.append( "<objName><![CDATA["+this.objName+"]]></objName>" ); //$NON-NLS-1$ //$NON-NLS-2$
				hdrStrBuff.append( "<pageContext><![CDATA[2]]></pageContext>" ); //$NON-NLS-1$
				hdrStrBuff.append( "<editFlag><![CDATA[" + this.editFlag + "]]></editFlag>" ); //$NON-NLS-1$ //$NON-NLS-2$
				hdrStrBuff.append( "<action><![CDATA[SAVE]]></action>" ); //$NON-NLS-1$
				hdrStrBuff.append( "<elementName><![CDATA[]]></elementName>" ); //$NON-NLS-1$
				hdrStrBuff.append( "<taxKeyValue><![CDATA[]]></taxKeyValue>" ); //$NON-NLS-1$
				hdrStrBuff.append( "<taxInFocus><![CDATA[false]]></taxInFocus>" ); //$NON-NLS-1$
				hdrStrBuff.append( "<objContext><![CDATA["+this.objContext+"]]></objContext>" );												 //$NON-NLS-1$ //$NON-NLS-2$
				hdrStrBuff.append( "<focusedColumn><![CDATA[]]></focusedColumn>" ); //$NON-NLS-1$
				hdrStrBuff.append( "<forcedSave><![CDATA[true]]></forcedSave>" ); //$NON-NLS-1$
				hdrStrBuff.append( "<keyValue><![CDATA["+ this.detailDomId+"]]></keyValue>" ); //$NON-NLS-1$ //$NON-NLS-2$
				//Changed by Danish on 06/03/2007 to send process instance id.
				if ( this.wrkflwProcInstId != null && this.wrkflwProcInstId.length() > 0 )
				{
					hdrStrBuff.append( "<wrkflwProcInstId><![CDATA[" + this.wrkflwProcInstId + "]]></wrkflwProcInstId>" ); //$NON-NLS-1$ //$NON-NLS-2$
				}
				hdrStrBuff.append( "<saveLevel><![CDATA[1]]></saveLevel>" ); //$NON-NLS-1$
				hdrStrBuff.append( "</header>" ); //$NON-NLS-1$
				hdrStrBuff.append( "</Root>" ); //$NON-NLS-1$
				//BaseLogger.log("3", userInfo,editorId,"----------- 777  --------- this.detailDom :"+serializeDom( this.detailDom ) );
				//Added by Pankaj T on 02-03-2017 [For upload utility to execute pre_confirm event if confirmCol value is match with data]-Start
				if( this.confirmCol != "" && isDataUpload )
				{
					Document uploadDom = parseString(xmlString);
					NodeList detailList = searchNodes( uploadDom, "1" );					
					//BaseLogger.log("3", userInfo,editorId,"detailList.getLength()::["+detailList.getLength()+"]");
					String confirmColVal = "";
					for (int i = 0; i < detailList.getLength(); i++)			
					{
						Node parentNode = detailList.item(i);
						confirmColVal = genericUtility.getColumnValueFromNode(this.confirmCol.toLowerCase(), parentNode);
						BaseLogger.log("3", userInfo,editorId,"confirmColVal in processRequest::["+confirmColVal+"]");
					}
					//Added By Ravindra C on 22-01-2021 [for auto confirm transaction from upload]
					BaseLogger.log( "3", userInfo, editorId, "isDataUploadAutoConfirm : ["+ isDataUploadAutoConfirm() +"]");
					if( this.confirmVal.equalsIgnoreCase(confirmColVal) || isDataUploadAutoConfirm() )
					{
						this.runMode = "B";
					}
				}
				//Added by Pankaj T on 02-03-2017 [For upload utility to execute pre_confirm event if confirmCol value is match with data]-End
				retString = updateDetailDom( hdrStrBuff.toString() );
				this.runMode = "I";
				
				//changed By Pankaj T on 15-06-17 [F16KSUN001|to remove editor activity from activity log map] - Start
				if(userInfo != null  )
				{
					EventLogInfoBean eventLogInfoBean = new EventLogInfoBean(userInfo.getLoginCode());
					eventLogInfoBean.removeEditorActivity(objName, userInfo.getSesstionId(), this.editorId, this.userInfo.getTransDB());
				}
				else
				{
					BaseLogger.log("3", userInfo,editorId," ============ User info is null then never created event log in MasterStatefulEJB.java file");
				}
				//changed By Pankaj T on 15-06-17 [F16KSUN001|to remove editor activity from activity log map] - End
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB : processRequest :==>Exception"); //$NON-NLS-1$
			e.printStackTrace();
			retString = new E12GenericUtility().createErrorString(e);
		}
		BaseLogger.log("2", userInfo,editorId,"Control Returning back to ITMService ....."); //$NON-NLS-1$
		return retString;
	}
	//Changed by Dhruv on 24/07/07 commented and replaced by below methods for overloading processRequest to accept db conn.End
//-------------------------------------------------------------------------------------------------------------//

	private String saveChangesInDb()throws RemoteException, Exception
	{
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]Invoking saving process to database"); //$NON-NLS-1$
		String retString = null;
		try
		{
			
		}
		catch(Exception e)
		{
			retString = null;
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :saveChangesInDb :"+e); //$NON-NLS-1$
			throw e;
		}
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]Succesfully saved transaction with header primary key values :"+retString +": !!!!"); //$NON-NLS-1$ //$NON-NLS-2$
		return retString;
	}

	public String saveDraftObject(String xmlStringFromClient) throws RemoteException,ITMException
	{
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]Saving to draft called...........");		 //$NON-NLS-1$
		String retStatus = ""; //$NON-NLS-1$
		try
		{
			retStatus = updateDetailDom(xmlStringFromClient);
			if(retStatus.indexOf("<Errors>") == -1) //$NON-NLS-1$
			{
				/*XML2DBHome xml2DBHome = (XML2DBHome)this.initialContext.lookup("XML2DB");
				XML2DB xml2DB = xml2DBHome.create();*/
				// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [START]
				//XML2DBLocal xml2dbejb = (XML2DBLocal)this.initialContext.lookup("ibase/XML2DBEJB/local"); //$NON-NLS-1$
				XML2DBEJB xml2dbejb = new XML2DBEJB();
				// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [END]
				//Commented by Gulzar on 25-May-17
				//xml2DB.setObjFormInfoMap(objFormInfoMap);//Gulzar on 09/02/17
				retStatus = xml2dbejb.saveDraftObject(this.detailDom, this.objName, this.editFlag, this.keyFlag, this.userInfo.getLoginCode(), this.headerPKFieldNames, this.signStatus);
				xml2dbejb = null;
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :saveToDraft"); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return retStatus;
	}

	private String getDelFlagForDraft(String objName) throws ITMException
	{
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]Getting delete flag for the draft objects from FINPARM table for objName :"+objName); //$NON-NLS-1$
		ConnDriver connDriver = null;
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		String delFlag = "Y"; //$NON-NLS-1$
		//Added By Shahu Mali on 09-10-13
		String transDB=null;
		try
		{
			connDriver = new ConnDriver();
			//Changes made by Shahu on 10/10/13 [WS3GBAS001] to support multiDB connection : START
			transDB = this.userInfo.getTransDB();
			if(transDB != null && !"null".equalsIgnoreCase(transDB) && transDB.trim().length() > 0)
			{
				conn = connDriver.getConnectDB(transDB);
			}
			//Changes made by Shahu on 10/10/13 [WS3GBAS001] to support multiDB connection : END
			
			stmt = conn.createStatement();
			String query  = "SELECT VAR_VALUE FROM FINPARM WHERE PRD_CODE = '999999' AND VAR_NAME = 'DEL_"+objName.toUpperCase()+"'"; //$NON-NLS-1$ //$NON-NLS-2$
			rs = stmt.executeQuery(query);
			while(rs.next())
			{
				delFlag = rs.getString(1);				
			}
			rs.close();
			rs = null;
			stmt.close();
			stmt = null;
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :getDelFlagForDraft :==>\n"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if (stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :getDelFlagForDraft :==>finally\n"+e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]Returing delete flag :"+delFlag); //$NON-NLS-1$
		return delFlag;
	}

	private String handleItemChange( String xmlStr )throws ITMException
	{
		//BaseLogger.log("3", userInfo,editorId,"handleItemChange called for xmlStr :\n :"+xmlStr);
		try
		{
			Document xmlStrDoc = null;
			if( xmlStr != null && ! xmlStr.equals( "-1" ) ) //$NON-NLS-1$
			{
				//Changed by Monif on 2/23/2009 [For special char parsing issue].Start
				E12GenericUtility genericUtility = new E12GenericUtility();
				xmlStr = genericUtility.setXmlDec( xmlStr );			
				//Changed by Monif on 2/23/2009 [For special char parsing issue].End
				xmlStrDoc = parseString( xmlStr );
				this.focussedColumn = ( String )this.headerInfoMap.get( "focusedColumn" ); //$NON-NLS-1$
				this.saveLevel = ( String )this.headerInfoMap.get( "saveLevel" ); //$NON-NLS-1$
				String xmlStrObjContext = ( String )this.headerInfoMap.get( "objContext" ); //$NON-NLS-1$
				DWObject dwObject = getDWObject( this.objName, Integer.parseInt( xmlStrObjContext.trim() ) );
				Hashtable dbTypes = dwObject.getUpdateableLogNameColType();
				
				Node domDetailNode = null;
				BaseLogger.log("3", userInfo,editorId, "Creating domDetailDom for objContext :[" + this.objContext + "] this.headerDomId :[" + this.headerDomId + "] this.detailDomId :[" + this.detailDomId + "]" ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				//Changed by Prasad on 02/05/17 [to handle itemchange from Compact view]
				//if( xmlStrDoc.getElementsByTagName( "Root" ).item( 0 ) != null ) //$NON-NLS-1$
				if( xmlStrDoc.getElementsByTagName( "Root" ).item( 0 ) != null || xmlStrDoc.getElementsByTagName( "DocumentRoot" ).item( 0 ) != null ) //$NON-NLS-1$
				{
					Node rootNode = xmlStrDoc.getElementsByTagName( "Root" ).item( 0 ); //$NON-NLS-1$
					//Changed by Prasad on 02/05/17 [to handle itemchange from Compact view] START
					if ( rootNode == null )
					{
						rootNode = xmlStrDoc.getElementsByTagName( "DocumentRoot" ).item( 0 );
					}
					//Changed by Prasad on 02/05/17 [to handle itemchange from Compact view] END
					NodeList xmlStrDetailList = rootNode.getChildNodes(); //data tags with Detail/Detail1
					int xmlStrDetailListLength = xmlStrDetailList.getLength();
					for ( int i = 0; i < xmlStrDetailListLength; i++ )
					{
						Node currXMLStrDetail = xmlStrDetailList.item(i);
						String tagName = currXMLStrDetail.getNodeName();
						String formNo = null;
						String domIdStr = null;
						//Added by Prasad on 02/11/16 [to search node from dbId]
						String dbIdStr = null;
						BaseLogger.log("3", userInfo,editorId, "tagName [" + tagName + "]" ); //$NON-NLS-1$ //$NON-NLS-2$
						if ( tagName.startsWith( "Detail" ) ) //$NON-NLS-1$
						{
							formNo = ( tagName.length() > "Detail".length() ) ? ( tagName.substring( "Detail".length() ) ) : this.objContext; //$NON-NLS-1$ //$NON-NLS-2$
							
							//Changed by Dhruv on 10/10/2007 to chnage dbtypes based on form no. as read from detail Node.Start
							if( ! xmlStrObjContext.trim().equals( formNo ) )
							{
								dwObject = getDWObject( this.objName, Integer.parseInt( formNo ) );
								dbTypes = dwObject.getUpdateableLogNameColType();
							}
							//Changed by Dhruv on 10/10/2007 to chnage dbtypes based on form no. as read from detail Node.End
							
							//Changed by Dhruv 6/19/2006 for applying multiple item changes.
							domIdStr = ( formNo != null && formNo.equalsIgnoreCase( "1" ) ) ? "1" : null; //$NON-NLS-1$ //$NON-NLS-2$
							if( ( ( Node ) ( ( NamedNodeMap )currXMLStrDetail.getAttributes() ).getNamedItem( "domID" ) ) != null ) //$NON-NLS-1$
							{
								domIdStr = ( ( Node ) ( ( NamedNodeMap )currXMLStrDetail.getAttributes() ).getNamedItem( "domID" ) ).getNodeValue(); //$NON-NLS-1$
							}
							//Added by Prasad on 02/11/16 [to search node from dbId]
							if( ( ( Node ) ( ( NamedNodeMap )currXMLStrDetail.getAttributes() ).getNamedItem( "dbID" ) ) != null ) //$NON-NLS-1$
							{
								dbIdStr = ( ( Node ) ( ( NamedNodeMap )currXMLStrDetail.getAttributes() ).getNamedItem( "dbID" ) ).getNodeValue(); //$NON-NLS-1$
							}
							BaseLogger.log("3", userInfo,editorId, "Searching corresponding data to which changes to be appied domIdStr :["+domIdStr+"], dbIdStr :["+ dbIdStr +"]"); //$NON-NLS-1$ //$NON-NLS-2$
							BaseLogger.log("3", userInfo,editorId, "is tax in focus :["+( (Boolean) this.headerInfoMap.get("taxInFocus") ).booleanValue()+"]" ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
							if( ( (Boolean) this.headerInfoMap.get("taxInFocus") ).booleanValue() ) //$NON-NLS-1$
							{
								domIdStr = (domIdStr != null && domIdStr.length() > 0)?domIdStr : (String)this.headerInfoMap.get("taxKeyValue"); //$NON-NLS-1$
								if(this.currTaxNode == null)
								{
									this.currTaxNode = getCurrTaxNode();
								}
								NodeList taxNodeList = this.currTaxNode.getChildNodes();
								int taxDomIdCtr = 0;
								for(int j = 0; j < taxNodeList.getLength(); j++)
								{
									//Changed by Manish on 09/02/2007 to chnage logic to find curr tax node based on dom id value and not sequence.Start
									/*
									if( domIdStr.equalsIgnoreCase( "" + ( j + 1 ) ) )
									{
										domDetailNode = taxNodeList.item(j);
										break;
									}
									*/
									Node currTaxNode = taxNodeList.item( j );
									if( currTaxNode.getNodeType() == Node.ELEMENT_NODE )
									{
										//if( currTaxNode.getAttributes().getNamedItem("domID").getNodeValue().equalsIgnoreCase( domIdStr ))
										if( domIdStr.equalsIgnoreCase( "" + ( ++taxDomIdCtr ) ) ) //$NON-NLS-1$
										{
											domDetailNode = currTaxNode;
											break;
										}
									}
									//Changed by Manish on 09/02/2007 to chnage logic to find curr tax node based on dom id value and not sequence.End
								}
							}
							else
							{
								domIdStr = (domIdStr != null && domIdStr.length() > 0) ? domIdStr : (String)this.headerInfoMap.get( "keyValue" ); //$NON-NLS-1$
								//Added by Prasad on 14/11/16 [to search node using dbId] START
								dbIdStr = (dbIdStr != null && dbIdStr.length() > 0) ? dbIdStr : this.currDbID; //$NON-NLS-1$
								BaseLogger.log("3", userInfo,editorId, "In else ------------- domIdStr :["+domIdStr+"], dbIdStr :["+ dbIdStr +"]");
								//Added by Prasad on 14/11/16 [to search node using dbId] END
								//Changed by Prasad on 02/11/16 [to search node from dbId]
								//domDetailNode = searchNode( this.detailDom, formNo, domIdStr );
								domDetailNode = searchNode( this.detailDom, formNo, domIdStr, dbIdStr );
							}
							//BaseLogger.log("3", userInfo,editorId,"Searched node on which changes to be applied :["+domDetailNode+"]");
							//Changed by Nilesh Soor on 25/07/2014 [As per Kandarp Sir : It is not required now as its done to identify issue of "One user data is getting shared to another user"]
							//Changed by Monif on 6/2/2009 [writing Log[As per KB.]Start
							/*if( "2".equals( CommonConstants.USER_LOG ) ) //$NON-NLS-1$
							{
								new ibase.webitm.utility.GenericUtility().getInstance().writeLoggerFile( "", "", "Before applyDataToXML", "", "[domDetailNode is]", serializeDom( domDetailNode ) ,"[currXMLStrDetail is]::"+ serializeDom( currXMLStrDetail ) ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
							}*/
							//Changed by Monif on 6/2/2009 [writing Log[As per KB.]End
							//Gulzar on 16/10/15 - Checked for null to avoid NullPointerException
							if(domDetailNode != null)
							{
								applyDataToXML( currXMLStrDetail, domDetailNode, dbTypes );
							}
							//BaseLogger.log("3", userInfo,editorId,"Changed Dom after applyDataToXML :["+domDetailNode+"]");
						}//if (tagName.startsWith("Detail"))
					}//for (int i = 0; i < xmlStrDetailLength; i++)
					if( this.localEditFlag.equalsIgnoreCase( "D" ) ) //$NON-NLS-1$
					{
						//Changed by Prasad on 02/11/16 [to search node from dbId]
						//domDetailNode = searchNode( this.detailDom, this.objContext, ( String ) this.headerInfoMap.get( "keyValue" ) ); //$NON-NLS-1$
						domDetailNode = searchNode( this.detailDom, this.objContext, ( String ) this.headerInfoMap.get( "keyValue" ), "" ); //$NON-NLS-1$
						applyDataToXML( xmlStrDoc, domDetailNode, dbTypes );
					}
				}//if(xmlStrDoc.getElementsByTagName("Root").item(0) != null)
			}//if(xmlStr != null && !xmlStr.equalsIgnoreCase("-1"))
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception : MasterStatefulEJB : handleItemChange :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return xmlStr;
	}

	private String applyDataToXML( Node clientDetailNode, Node domDetailNode, Hashtable dbTypes ) throws ITMException
	{
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]Applying Data To Xml ..........."); //$NON-NLS-1$
		String retXMLString = ""; //$NON-NLS-1$
		try
		{
			//Changes made by Pratheek on 27-02-2020-[to show space as a value in CDATA in reponse]-Start
			//Changes made by Pratheek on 16-03-2020[ commenting the changes since the issue of cctr_code is solved in sun by making changes in metadata(i.e removing the initial tag with spaces as a value)]-Start
			//E12GenericUtility e12GenericUtility1 = new E12GenericUtility();
			//e12GenericUtility1.removeWhitespaces(domDetailNode);
			//Changes made by Pratheek on 16-03-2020[ commenting the changes since the issue of cctr_code is solved in sun by making changes in metadata(i.e removing the initial tag with spaces as a value)]-End
			//Changes made by Pratheek on 27-02-2020-[to show space as a value in CDATA in reponse]-End
			//Reading the status of the current node as in the dom
			//editFlag
			String xmlStrEditFlag = this.localEditFlag;
			boolean isExists = false;
			NodeList domDetailChildList = domDetailNode.getChildNodes();
			int domDetailChildListLength = domDetailChildList.getLength();
			String currDomIDStr = ( ( (Boolean)this.headerInfoMap.get("taxInFocus") ).booleanValue() ) ? this.detailDomId : domDetailNode.getAttributes().getNamedItem("domID").getNodeValue(); //$NON-NLS-1$ //$NON-NLS-2$
			String currObjCtxStr = ( ( (Boolean)this.headerInfoMap.get("taxInFocus") ).booleanValue() ) ? this.objContext : domDetailNode.getAttributes().getNamedItem("objContext").getNodeValue(); //$NON-NLS-1$ //$NON-NLS-2$
			NodeList clientDetailChildList = clientDetailNode.getChildNodes();
			int clientDetailChildListLength = clientDetailChildList.getLength();
			BaseLogger.log("3", userInfo,editorId,"Inside MasterStatefulEJB applyDataToXML currDomIDStr["+currDomIDStr+"] currObjCtxStr["+currObjCtxStr+"] and ["+this.headerInfoMap.get("keyValue")+"]");
			for(int iCtr = 0; iCtr < clientDetailChildListLength; iCtr++)
			{
				if(clientDetailChildList.item(iCtr).getNodeType() == Node.ELEMENT_NODE)
				{
					String clientDetailUnitTagName = clientDetailChildList.item(iCtr).getNodeName();
					String clientDetailUnitTagValue = ""; //$NON-NLS-1$
					Node newNode = clientDetailChildList.item(iCtr).getFirstChild();
					//Changed by Monif on 5/16/2008[Checking DataType is null ]Start.
					String dataType = (String)dbTypes.get( clientDetailUnitTagName );
					if(newNode != null)
					{
						//Changed by Monif on 18/03/2008 [Applying Change on  XMLTYPE data]Start.
						//clientDetailUnitTagValue = newNode.getNodeValue();
						if ( dataType != null && dataType.length() > 0)
						{
							if ( dataType.toUpperCase().indexOf("XMLTYPE") != -1 ) //$NON-NLS-1$
							{
								//clientDetailUnitTagValue = serializeDom( newNode );
								clientDetailUnitTagValue = serializeDom( clientDetailChildList.item(iCtr) ); //Added by Lokesh on 21/06/2016[M15ESUN001]
							}
							else
							{
								clientDetailUnitTagValue = newNode.getNodeValue();
							}
						}
						else
						{
							clientDetailUnitTagValue = newNode.getNodeValue();
						}
						//Changed by Monif on 18/03/2008 [Applying Change on  XMLTYPE data]End.
					}
					NamedNodeMap attributeMap = clientDetailChildList.item(iCtr).getAttributes();
					for(int oCtr = 0; oCtr < domDetailChildListLength; oCtr++)
					{
						Node curDomDetChild = domDetailChildList.item(oCtr);
						NamedNodeMap currDomAttrMap = curDomDetChild.getAttributes();
						String domUnitTagName = curDomDetChild.getNodeName();
						if(clientDetailUnitTagName.equals(domUnitTagName))
						{
							CDATASection cDataSection = null;
							//String dataType = (String)dbTypes.get(domUnitTagName);
							if ( dataType != null )
							{
								//Changed by Madhup on 27/06/2007 accomodating DateTime Format.Start
								/*if ( ( dataType.toUpperCase().indexOf("DATETIME") != -1 ) || ( dataType.toUpperCase().indexOf("TIMESTAMP") != -1 ) || ( dataType.toUpperCase().indexOf("DATE") != -1 ) )
								{
									String displayDateVal = clientDetailUnitTagValue;
									
									String displayDataFormat = getDispDateFormat();
									if (displayDateVal.length() > displayDataFormat.length())
									{
										displayDateVal = displayDateVal.substring(0 , displayDataFormat.length());
									}
									//Changed By Danish on 05/09/2006 reason [dont parse if value is null or blank]
									//String validApplDateVal = getValidDateString(displayDateVal, displayDataFormat, getApplDateFormat());
									String validApplDateVal = (displayDateVal != null && displayDateVal.length() > 0) ? getValidDateString(displayDateVal, displayDataFormat, getApplDateFormat()) : displayDateVal ;
									cDataSection = this.detailDom.createCDATASection(validApplDateVal);
								}*/
								E12GenericUtility e12GenericUtility = new E12GenericUtility();
								String displayDateVal = null;
								String displayDataFormat = null;
								String validApplDateVal = null;
								if ( ( dataType.toUpperCase().indexOf("DATETIME") != -1 ) || ( dataType.toUpperCase().indexOf("TIMESTAMP") != -1 ) ) //$NON-NLS-1$ //$NON-NLS-2$
								{									
									displayDateVal = clientDetailUnitTagValue;
									//Added by Shrutika on 29-01-18 [start] for avoid append "00:00:00" if already time is present in displayDateVal.
									int countColon = 0;
									for(int i=0; i<displayDateVal.length(); i++)
									{
										if(displayDateVal.charAt(i) == ':')
										{
											countColon++;
										}
									}
									//Added by Shrutika on 29-01-18 [End] for avoid append "00:00:00" if already time is present in displayDateVal.
									//Change done by Sandeep on 10-May-16 [[S15LSUN004] For DateBox issue in TransactionEditor ] start 
									BaseLogger.log("3", userInfo,editorId,"Inside MasterStateFulEJB before appending time displayDateVal["+displayDateVal+"]");
									if( displayDateVal.indexOf(":") != -1 && countColon == 1 )//Added and condition by Shrutika on 29-01-18 for avoid append "00:00:00" if already time is present in displayDateVal.
									{
										displayDateVal = displayDateVal + " 00:00:00";
									}
									//Added BY Suraj on 18-11-2016 [To set plan date for GWT Editor in Calendar]Start
									//Changes By Ajinkya Gopalkar on 11-May-17[For issue of time not appending on date]
									if( !"".equals(displayDateVal) && displayDateVal.indexOf(":") == -1 /*&& "Yes".equalsIgnoreCase(getCalComp())*/ )
									{
										BaseLogger.log("3", userInfo,editorId,"222");
										displayDateVal = displayDateVal + " 00:00:00";
									}
									//Added BY Suraj on 18-11-2016 [To set plan date for GWT Editor in Calendar]End
									BaseLogger.log("3", userInfo,editorId,"Inside MasterStateFulEJB after appending time displayDateVal["+displayDateVal+"]");
									//Change done by Sandeep on 10-May-16 [[S15LSUN004] For DateBox issue in TransactionEditor ] End 
									displayDataFormat = getDispDateFormat();
									String displayDataTimeFormat = e12GenericUtility.getDispDateTimeFormat();
									
									//Changed by Dhruv on 12/07/07 to create CDATASection with empty string incase date filed value is null.
									//validApplDateVal = (displayDateVal != null && displayDateVal.length() > 0) ? (new ibase.webitm.utility.GenericUtility()).getValidDateTimeString(displayDateVal,  (new GenericUtility()).getApplDateTimeFormat()) : null ;
									validApplDateVal = (displayDateVal != null && displayDateVal.length() > 0) ? e12GenericUtility.getValidDateTimeString( displayDateVal,  e12GenericUtility.getApplDateTimeFormat() ) : "" ; //$NON-NLS-1$
									
									cDataSection = this.detailDom.createCDATASection(validApplDateVal);
								}
								else if( dataType.toUpperCase().indexOf("DATE") != -1 ) //$NON-NLS-1$
								{
									displayDateVal = clientDetailUnitTagValue;
									displayDataFormat = getDispDateFormat();
									
									//Changed by Dhruv on 12/07/07 to create CDATASection with empty string incase date filed value is null.
									//validApplDateVal = (displayDateVal != null && displayDateVal.length() > 0) ? (new ibase.webitm.utility.GenericUtility()).getValidDateString( displayDateVal,(new GenericUtility()).getApplDateFormat()) : null ;
									validApplDateVal = (displayDateVal != null && displayDateVal.length() > 0) ? e12GenericUtility.getValidDateString( displayDateVal,e12GenericUtility.getApplDateFormat()) : "" ; //$NON-NLS-1$

									cDataSection = this.detailDom.createCDATASection(validApplDateVal);
								}
								//Changed by Madhup on 27/06/2007 accomodating DateTime Format.End
								// Changed By Roshan 08/10/07 to Set Time Format.Start
								else if ( dataType.toUpperCase().indexOf("TIME") != -1 ) //$NON-NLS-1$
								{
									displayDateVal = clientDetailUnitTagValue;
									displayDataFormat = e12GenericUtility.getDisplayTimeFormat();
									validApplDateVal = (displayDateVal != null && displayDateVal.length() > 0) ? e12GenericUtility.getValidDateString( displayDateVal,displayDataFormat,"hh:mm:ss") : "" ; //$NON-NLS-1$ //$NON-NLS-2$
									cDataSection = this.detailDom.createCDATASection(validApplDateVal);
								}
								// Changed By Roshan 08/10/07 to Set Time Format.End
								//Changed by Monif on 18/03/2008 [Applying Change on  XMLTYPE data]Start.
								else if ( dataType.toUpperCase().indexOf("XMLTYPE") != -1 ) //$NON-NLS-1$
								{									
									//BaseLogger.log("3", userInfo,editorId, "XMLTYPE:[this.detailDom]" + serializeDom( this.detailDom ) );								
								}//Changed by Monif on 18/03/2008 [Applying Change on  XMLTYPE data]End.
								else
								{
									cDataSection = this.detailDom.createCDATASection(clientDetailUnitTagValue);
								}
							}
							else
							{
								cDataSection = this.detailDom.createCDATASection(clientDetailUnitTagValue);
							}

							//sourceElement.appendChild(cDataSection);
							int currDomAttrMapLength = currDomAttrMap.getLength();
							for(int attrCnt=0;attrCnt<attributeMap.getLength();attrCnt++)
							{
								Node eachAttribute = attributeMap.item(attrCnt);
								String attributeName = eachAttribute.getNodeName().trim();
								String attributeValue = eachAttribute.getNodeValue().trim();
								boolean isAttrFound = false;
								for(int currAttrCnt=0; currAttrCnt<currDomAttrMapLength; currAttrCnt++)
								{
									Node currDetAttr = currDomAttrMap.item(currAttrCnt);
									String currAttrName = currDetAttr.getNodeName().trim();
									if( attributeName.equals( currAttrName ) )
									{
										isAttrFound = true;
										currDetAttr.setNodeValue(attributeValue);
									}
								}
								if( ! isAttrFound)
								{
									( ( Element )curDomDetChild ).setAttribute( attributeName, attributeValue );
								}
							}//for(int attrCnt=0;attrCnt<attributeMap.getLength();attrCnt++)
							/*if( domDetailChildList.item( oCtr ).getFirstChild() != null )
							{
								//Changed by Monif on 18/03/2008 [Applying Change on  XMLTYPE data]Start.
								//BaseLogger.log("3", userInfo,editorId, "Values \t:" + domDetailChildList.item( oCtr ).getFirstChild().getNodeValue() + ": BY :" + clientDetailUnitTagValue );
								if ( domDetailChildList.item( oCtr ).getFirstChild().getNodeValue() != null )
								{
									BaseLogger.log("3", userInfo,editorId, "Values \t:" + domDetailChildList.item( oCtr ).getFirstChild().getNodeValue() + ": BY :" + clientDetailUnitTagValue );
								}								
								else 
								{
									BaseLogger.log("3", userInfo,editorId, "Values \t:" + serializeDom( domDetailChildList.item( oCtr ).getFirstChild() ) + ": BY :" + clientDetailUnitTagValue );
								}
								//Changed by Monif on 18/03/2008 [Applying Change on  XMLTYPE data]End.
							}
							else
							{
								BaseLogger.log("3", userInfo,editorId, "Values \t:: BY :" + clientDetailUnitTagValue );//deepali 22-02-2006
							}*/
							//domDetailNode.replaceChild(domDetailNode.getOwnerDocument().importNode(sourceElement, true), domDetailChildList.item(oCtr));

							Node colValueNode = curDomDetChild.getFirstChild();
							//Changed by Monif on 18/03/2008 [Applying Change on XMLTYPE data]End.
							//if( colValueNode != null && colValueNode.getNodeValue() != null )
							if( colValueNode != null )
							{
								if ( colValueNode.getNodeValue() != null  )
								{
									colValueNode.setNodeValue( clientDetailUnitTagValue );
								}
								else if ( dataType !=null && dataType.length() > 0 )
								{
									if ( dataType.toUpperCase().indexOf("XMLTYPE") != -1 ) //$NON-NLS-1$
									{
										curDomDetChild.replaceChild(curDomDetChild.getOwnerDocument().importNode(newNode, true), curDomDetChild.getFirstChild());										
									}
								}//Changed by Monif on 18/03/2008 [Applying Change on XMLTYPE data]End.
							}
							else
							{
								curDomDetChild.appendChild(cDataSection);
							}
							//clientDetailNode.replaceChild(clientDetailNode.getOwnerDocument().importNode(sourceElement, true), clientDetailChildList.item(iCtr));
							//BaseLogger.log("3", userInfo,editorId,"REPLACED.........");
							String key = currObjCtxStr + "_" + currDomIDStr + "_" + clientDetailUnitTagName; //$NON-NLS-1$ //$NON-NLS-2$
							
							if ( ! this.changedDataMap.containsKey( key ) )
							{
								//BaseLogger.log("3", userInfo,editorId,"key :"+key);
								//this.changedDataMap.put(key, sourceElement);
								this.changedDataMap.put( key, curDomDetChild );
							}
							//Changed by Danish on 13/07/2006 to incorporate Audit Trail feature
							if( this.isAuditTrailOn )
							{
								if( this.auditDataMap == null )
								{
									this.auditDataMap = new HashMap();
									
								}
								TreeMap currFormMap = ( this.auditDataMap.get( currObjCtxStr ) != null ) ? ( TreeMap )this.auditDataMap.get( currObjCtxStr ) : new TreeMap();
								
								String tempKey = currDomIDStr + "_" + clientDetailUnitTagName; //$NON-NLS-1$
								currFormMap.put( tempKey, clientDetailUnitTagValue );
								this.auditDataMap.put( currObjCtxStr, currFormMap );
								
								//BaseLogger.log("3", userInfo,editorId,"auditDataMap ["+this.auditDataMap+"]");
							}
							break;
						}//if(clientDetailUnitTagName.equalsIgnoreCase(domUnitTagName))
					}//for(int oCtr = 0; oCtr < domDetailChildListLength; oCtr++)
				}//if(clientDetailChildList.item(iCtr).getFirstChild() != null)
			}//for(int iCtr = 0; iCtr < clientDetailChildListLength; iCtr++)

			for(int oCtr = 0; oCtr < domDetailChildListLength; oCtr++)
			{
				Node curDomDetChild = domDetailChildList.item(oCtr);
				String domUnitTagName = curDomDetChild.getNodeName();
				
				String statusInDom = null;
				if( domUnitTagName.equalsIgnoreCase( "attribute" ) ) //$NON-NLS-1$
				{
					if(curDomDetChild.getAttributes().getNamedItem( "status" ) != null) //$NON-NLS-1$
					{
						statusInDom = curDomDetChild.getAttributes().getNamedItem( "status" ).getNodeValue(); //$NON-NLS-1$
						if(statusInDom.equalsIgnoreCase( "O" ) ) //$NON-NLS-1$
						{
							isExists = true;
						}
					}
					if( curDomDetChild.getAttributes().getNamedItem( "updateFlag" ) != null && ( ! curDomDetChild.getAttributes().getNamedItem( "updateFlag" ).getNodeValue().equals( "D" ) ) ) //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
					{
						if(isExists)
						{
							if( xmlStrEditFlag.equalsIgnoreCase( "D" ) ) //$NON-NLS-1$
							{
								if(this.objContext.equals(currObjCtxStr) && this.headerInfoMap.get("keyValue").equals(currDomIDStr)) //$NON-NLS-1$
								{
									curDomDetChild.getAttributes().getNamedItem("updateFlag").setNodeValue(xmlStrEditFlag); //$NON-NLS-1$
									//Changed by Danish on 13/07/2006 to incorporate Audit Trail feature
									if( this.isAuditTrailOn )
									{
										updateAuditDataMap(currObjCtxStr, currDomIDStr, domDetailNode);
									}
								}
								else
								{
									curDomDetChild.getAttributes().getNamedItem("updateFlag").setNodeValue("E"); //$NON-NLS-1$ //$NON-NLS-2$
								}
							}
							else
							{
								curDomDetChild.getAttributes().getNamedItem("updateFlag").setNodeValue("E"); //$NON-NLS-1$ //$NON-NLS-2$
							}
						}
						else if(xmlStrEditFlag.equalsIgnoreCase("D")) //$NON-NLS-1$
						{
							if(this.objContext.equals(currObjCtxStr) && this.headerInfoMap.get("keyValue").equals(currDomIDStr)) //$NON-NLS-1$
							{
								BaseLogger.log("3", userInfo,editorId,"Deleting newly added record from DOM........"); //$NON-NLS-1$
								this.detailDom.getElementsByTagName("Header0").item(0).removeChild(domDetailNode); //$NON-NLS-1$
								//this.detailDom.removeChild(domDetailNode);
							}
						}
					}
					break;
				}//if(domUnitTagName.equalsIgnoreCase("attribute"))
			}//for(int oCtr = 0; oCtr < domDetailChildListLength; oCtr++)

			BaseLogger.log("3", userInfo,editorId,"Is Tax in Focus :[" + ( (Boolean)this.headerInfoMap.get("taxInFocus") ).booleanValue() + "]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			BaseLogger.log("3", userInfo,editorId,"[currentRecordId==focussedRowId][" + currDomIDStr +"==" + this.headerInfoMap.get("keyValue") + "]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			if( ( (Boolean)this.headerInfoMap.get("taxInFocus") ).booleanValue() ) //$NON-NLS-1$
			{
				for(int oCtr = 0; oCtr < domDetailChildListLength; oCtr++)
				{
					if( this.objContext.equals(currObjCtxStr) && this.headerInfoMap.get("keyValue").equals(currDomIDStr) ) //$NON-NLS-1$
					{
						Node curDomDetChild = domDetailChildList.item(oCtr);
						String domUnitTagName = curDomDetChild.getNodeName();
						if(domUnitTagName.equalsIgnoreCase("chg_stat")) //$NON-NLS-1$
						{
							BaseLogger.log("3", userInfo,editorId,"Updating chg_stat as FROZEN for the edited Tax Record...."); //$NON-NLS-1$
							if( curDomDetChild.getFirstChild() != null )
							{
								curDomDetChild.getFirstChild().setNodeValue("F"); //$NON-NLS-1$
							}
							else
							{
								CDATASection cDataSection = this.detailDom.createCDATASection("F"); //$NON-NLS-1$
								curDomDetChild.appendChild(cDataSection);
							}
							BaseLogger.log("3", userInfo,editorId,"Updated chg_stat as FROZEN...."); //$NON-NLS-1$
							break;
						}
						//BaseLogger.log("3", userInfo,editorId,"Updated chg_stat as FROZEN for the edited Tax Record....");
					}
				}
			}//if( ( (Boolean)this.headerInfoMap.get("taxInFocus") ).booleanValue() )
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception : MasterStatefulEJB : applyDataToXML :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		//BaseLogger.log("3", userInfo,editorId,"Returning changed xml string :\n"+retXMLString);
		return retXMLString;
	}

	private void updateHeaderInfoMap(String xmlStr)throws Exception
	{
		//BaseLogger.log("3", userInfo,editorId,"updateHeaderInfoMap : xmlStr :"+xmlStr);
		HashMap lHeaderInfoMap = null;
		Document xmlStrDoc = null;

		String saveLevel = ""; //$NON-NLS-1$
		String focussedColumn = ""; //$NON-NLS-1$
		String objName = ""; //$NON-NLS-1$
		String editFlag = ""; //$NON-NLS-1$
		String objContext = ""; //$NON-NLS-1$
		String keyValue = ""; //$NON-NLS-1$
		String pkValues = ""; //$NON-NLS-1$
		String action = ""; //$NON-NLS-1$
		String forcedSave = ""; //$NON-NLS-1$
		String clientSideElemName = ""; //$NON-NLS-1$
		String taxInFocus = "false"; //$NON-NLS-1$
		lHeaderInfoMap = new HashMap();
		if(xmlStr != null && !xmlStr.equalsIgnoreCase("-1")) //$NON-NLS-1$
		{
			xmlStrDoc = parseString(xmlStr);
			if(xmlStrDoc.getElementsByTagName("saveLevel").item(0) != null) //$NON-NLS-1$
			{
				if(xmlStrDoc.getElementsByTagName("saveLevel").item(0).getFirstChild() != null) //$NON-NLS-1$
				{
					this.saveLevel = ((String)xmlStrDoc.getElementsByTagName("saveLevel").item(0).getFirstChild().getNodeValue()).trim(); //$NON-NLS-1$
					lHeaderInfoMap.put("saveLevel",this.saveLevel); //$NON-NLS-1$
				}
			}
			if(xmlStrDoc.getElementsByTagName("forcedSave").item(0) != null) //$NON-NLS-1$
			{
				if(xmlStrDoc.getElementsByTagName("forcedSave").item(0).getFirstChild() != null) //$NON-NLS-1$
				{
					forcedSave = ((String)xmlStrDoc.getElementsByTagName("forcedSave").item(0).getFirstChild().getNodeValue()).trim(); //$NON-NLS-1$
					lHeaderInfoMap.put("forcedSave",forcedSave ); //$NON-NLS-1$
				}
			}
			if(xmlStrDoc.getElementsByTagName("focusedColumn").item(0) != null) //$NON-NLS-1$
			{
				if(xmlStrDoc.getElementsByTagName("focusedColumn").item(0).getFirstChild() != null) //$NON-NLS-1$
				{
					focussedColumn = ((String)xmlStrDoc.getElementsByTagName("focusedColumn").item(0).getFirstChild().getNodeValue()).trim(); //$NON-NLS-1$
					lHeaderInfoMap.put("focusedColumn", focussedColumn ); //$NON-NLS-1$
				}
			}
			if(xmlStrDoc.getElementsByTagName("objName").item(0) != null) //$NON-NLS-1$
			{
				if(xmlStrDoc.getElementsByTagName("objName").item(0).getFirstChild() != null) //$NON-NLS-1$
				{
					objName = ((String)xmlStrDoc.getElementsByTagName("objName").item(0).getFirstChild().getNodeValue()).trim(); //$NON-NLS-1$
					lHeaderInfoMap.put("objName",objName ); //$NON-NLS-1$
					if(this.objName == null)
					{
						this.objName = objName;
					}
				}
			}
			if(xmlStrDoc.getElementsByTagName("editFlag").item(0) != null) //$NON-NLS-1$
			{
				if(xmlStrDoc.getElementsByTagName("editFlag").item(0).getFirstChild() != null) //$NON-NLS-1$
				{
					editFlag = ((String)xmlStrDoc.getElementsByTagName("editFlag").item(0).getFirstChild().getNodeValue()).trim(); //$NON-NLS-1$
					lHeaderInfoMap.put("editFlag",editFlag ); //$NON-NLS-1$
					this.localEditFlag = editFlag;
				}
			}
			if(xmlStrDoc.getElementsByTagName("objContext").item(0) != null) //$NON-NLS-1$
			{
				if(xmlStrDoc.getElementsByTagName("objContext").item(0).getFirstChild() != null) //$NON-NLS-1$
				{
					objContext = ((String)xmlStrDoc.getElementsByTagName("objContext").item(0).getFirstChild().getNodeValue()).trim(); //$NON-NLS-1$
					lHeaderInfoMap.put( "objContext",objContext ); //$NON-NLS-1$
				}
			}
			if(xmlStrDoc.getElementsByTagName("keyValue").item(0) != null) //$NON-NLS-1$
			{
				if(xmlStrDoc.getElementsByTagName("keyValue").item(0).getFirstChild() != null) //$NON-NLS-1$
				{
					keyValue = ((String)xmlStrDoc.getElementsByTagName("keyValue").item(0).getFirstChild().getNodeValue()).trim(); //$NON-NLS-1$
					lHeaderInfoMap.put("keyValue", ((Integer.parseInt(objContext.trim()) == 1)?this.headerDomId : keyValue)); //$NON-NLS-1$
				}
			}
			if(xmlStrDoc.getElementsByTagName("pkValues").item(0) != null) //$NON-NLS-1$
			{
				if(xmlStrDoc.getElementsByTagName("pkValues").item(0).getFirstChild() != null) //$NON-NLS-1$
				{
					pkValues = ((String)xmlStrDoc.getElementsByTagName("pkValues").item(0).getFirstChild().getNodeValue()).trim(); //$NON-NLS-1$
					lHeaderInfoMap.put("pkValues", pkValues); //$NON-NLS-1$
				}
			}
			if(xmlStrDoc.getElementsByTagName("action").item(0) != null) //$NON-NLS-1$
			{
				if(xmlStrDoc.getElementsByTagName("action").item(0).getFirstChild() != null) //$NON-NLS-1$
				{
					action = ((String)xmlStrDoc.getElementsByTagName("action").item(0).getFirstChild().getNodeValue()).trim(); //$NON-NLS-1$
					lHeaderInfoMap.put("action",action ); //$NON-NLS-1$
				}
			}
			if(xmlStrDoc.getElementsByTagName("elementName").item(0) != null) //$NON-NLS-1$
			{
				if(xmlStrDoc.getElementsByTagName("elementName").item(0).getFirstChild() != null) //$NON-NLS-1$
				{
					clientSideElemName = ((String)xmlStrDoc.getElementsByTagName("elementName").item(0).getFirstChild().getNodeValue()).trim(); //$NON-NLS-1$
					lHeaderInfoMap.put("elementName", clientSideElemName ); //$NON-NLS-1$
				}
			}
			else
			{
				lHeaderInfoMap.put("elementName", clientSideElemName ); //$NON-NLS-1$
			}
			if(xmlStrDoc.getElementsByTagName("taxInFocus").item(0) != null) //$NON-NLS-1$
			{
				if(xmlStrDoc.getElementsByTagName("taxInFocus").item(0).getFirstChild() != null) //$NON-NLS-1$
				{
					taxInFocus = ((String)xmlStrDoc.getElementsByTagName("taxInFocus").item(0).getFirstChild().getNodeValue()).trim(); //$NON-NLS-1$
					lHeaderInfoMap.put("taxInFocus", Boolean.valueOf(taxInFocus)); //$NON-NLS-1$
				}
			}
			else
			{
				lHeaderInfoMap.put("taxInFocus", Boolean.valueOf(taxInFocus)); //$NON-NLS-1$
			}
			if(xmlStrDoc.getElementsByTagName("taxKeyValue").item(0) != null) //$NON-NLS-1$
			{
				if(xmlStrDoc.getElementsByTagName("taxKeyValue").item(0).getFirstChild() != null) //$NON-NLS-1$
				{
					this.taxDomId = ((String)xmlStrDoc.getElementsByTagName("taxKeyValue").item(0).getFirstChild().getNodeValue()).trim(); //$NON-NLS-1$
					lHeaderInfoMap.put("taxKeyValue", this.taxDomId); //$NON-NLS-1$
				}
			}
			if( xmlStrDoc.getElementsByTagName("transKeyValue").item(0) != null ) //$NON-NLS-1$
			{
				if(xmlStrDoc.getElementsByTagName("transKeyValue").item(0).getFirstChild() != null) //$NON-NLS-1$
				{
					this.headerPKFieldValues = ((String)xmlStrDoc.getElementsByTagName("transKeyValue").item(0).getFirstChild().getNodeValue()).trim(); //$NON-NLS-1$
				}
			}
			if( xmlStrDoc.getElementsByTagName("wrkflwProcInstId").item(0) != null ) //$NON-NLS-1$
			{
				if(xmlStrDoc.getElementsByTagName("wrkflwProcInstId").item(0).getFirstChild() != null) //$NON-NLS-1$
				{
					this.wrkflwProcInstId = ((String)xmlStrDoc.getElementsByTagName("wrkflwProcInstId").item(0).getFirstChild().getNodeValue()).trim(); //$NON-NLS-1$
					BaseLogger.log("3", userInfo,editorId,"this.wrkflwProcInstId ["+this.wrkflwProcInstId+"]"); //$NON-NLS-1$ //$NON-NLS-2$
				}
			}
			if( xmlStrDoc.getElementsByTagName( "isModeInteractive" ).item(0) != null ) //$NON-NLS-1$
			{
				if( xmlStrDoc.getElementsByTagName("isModeInteractive").item(0).getFirstChild() != null ) //$NON-NLS-1$
				{
					String isModeInteractive = ( ( String )xmlStrDoc.getElementsByTagName( "isModeInteractive" ).item(0).getFirstChild().getNodeValue() ).trim(); //$NON-NLS-1$
					lHeaderInfoMap.put( "isModeInteractive", Boolean.valueOf( isModeInteractive )); //$NON-NLS-1$
				}
			}
			//Added by Gayatri Yadav on 07-04-2011 [SY89SUN079][To add save and continue button in detail page in RCP]start
			if( xmlStrDoc.getElementsByTagName( "isSaveNConitinue" ).item(0) != null ) //$NON-NLS-1$
			{
				if( xmlStrDoc.getElementsByTagName("isSaveNConitinue").item(0).getFirstChild() != null ) //$NON-NLS-1$
				{
					String isSaveNContinue = ( ( String )xmlStrDoc.getElementsByTagName( "isSaveNConitinue" ).item(0).getFirstChild().getNodeValue() ).trim(); //$NON-NLS-1$
					lHeaderInfoMap.put( "isSaveNConitinue", isSaveNContinue ); //$NON-NLS-1$
				}
			}
			//Added by Gayatri Yadav on 07-04-2011 [SY89SUN079][To add save and continue button in detail page in RCP]end
		}
		if(Integer.parseInt(objContext.trim()) == 1)
		{
			this.editFlag = this.localEditFlag;
		}
		if(!(this.detailDomId.equals(keyValue) && this.objContext.equals(objContext)))
		{
			this.currRecordNode = null;
			this.currTaxNode = null;
		}
		this.detailDomId = keyValue;
		this.objContext = objContext;
		this.headerInfoMap = lHeaderInfoMap;
	}

	private void updateNewDom(String editFlag)throws Exception
	{
		//Changed by Danish on 04/09/2008 try and catch added [ to include exception with Data in Case of itm_default ]
		try
		{
			String transDB = this.userInfo.getTransDB(); //Shahu on 10/12/14
			
			//Changed by Danish on 04/09/2008 setting null
			this.exceptnMsg = null;
			
			editFlag = (editFlag == null)?this.localEditFlag:editFlag;
			NodeList detailList = null;
			int detailListLength = -1;
			//Changes made by Gulzar on 27/03/14
			ArrayList itemChangeList = null;
			//if(transDB != null && transDB.trim().length() > 0 && !"null".equalsIgnoreCase(transDB.trim()))
			{
				itemChangeList = this.dbAccess.getItemChangeElementList( this.objName, this.objContext, this.userInfo );
			}
			/*else
			{
				itemChangeList = this.dbAccess.getItemChangeElementList( this.objName, this.objContext );
			}*/
			if( editFlag.equalsIgnoreCase( "A" ) ) //$NON-NLS-1$
			{
				detailList = searchNodes(this.detailDom, this.objContext);
				detailListLength = detailList.getLength();
				Node lastDetailNode = detailList.item(detailListLength - 1);
				BaseLogger.log("3", userInfo,editorId,"detailListLength :"+detailListLength); //$NON-NLS-1$
				assignNewDomID(detailList, lastDetailNode, detailListLength);

				//Changed by Dhruv on 18/08/2006 to change sequence of setting in a ne dom. Start
				if( Integer.parseInt(this.objContext) > 1 )
				{
					//assignDefaultValues( this.userInfo.getUserType(), this.userInfo.getEntityCode(), itemChangeList );
					assignPKFieldValues(lastDetailNode);
				}
				/*
				else
				{
					assignPKFieldValues(lastDetailNode);
				}
				*/
				assignArgValues(lastDetailNode, itemChangeList);
				assignNewLineNo(detailList, detailListLength);
			}
			/*
			if( editFlag.equalsIgnoreCase( "A" ) )
			{
				assignNewLineNo(detailList, detailListLength);
			}
			*/
			assignITMDefaultValues( editFlag, itemChangeList );
			if( Integer.parseInt( this.objContext ) == 1 && editFlag.equalsIgnoreCase( "A" ) ) //$NON-NLS-1$
			{
				assignDefaultValues( this.userInfo.getUserType(), this.userInfo.getEntityCode(), itemChangeList );
			}
			//Changed by Dhruv on 18/08/2006 to change sequence of setting in a ne dom. End
			
		}
		catch ( Exception e)
		{
			e.printStackTrace();
			this.exceptnMsg = e.getMessage();
		}
	}

	private void assignNewDomID(NodeList detailList, Node detailNode, int detailListLength)throws Exception
	{
		//Changed by Monif on 18/03/09[Make as Instance Var].
		int maxDomID = 0;
		int currDomID = -1;
		Node currDetailNode = null;
		NodeList currDetailChildNodeList = null;
		//Changed by MOnif on 18/03/09[Changed for assigning DomID by iterating only if maxDomID is 0. To retain value in insatnce so we don't need to iterate].
		if( this.maxDomIdMap == null )
		{
			this.maxDomIdMap = new HashMap();
		}

		if ( this.maxDomIdMap.get( this.objName+"_"+this.objContext ) == null ) //$NON-NLS-1$
		{
			for(int detailCtr = 0; detailCtr < detailListLength; detailCtr++)
			{
				currDetailNode = detailList.item(detailCtr);
				String currDomIDStr = currDetailNode.getAttributes().getNamedItem("domID").getNodeValue(); //$NON-NLS-1$
				//BaseLogger.log("3", userInfo,editorId,"currDomIDStr :"+currDomIDStr);
				if(currDomIDStr != null && !currDomIDStr.equals("")) //$NON-NLS-1$
				{
					currDomID = Integer.parseInt(currDomIDStr.trim());
				}
				if(currDomID > maxDomID)
				{
					maxDomID = currDomID;
				}
			}
			BaseLogger.log("3", userInfo,editorId,"Setting Value if not found for ["+ this.objName+"_"+this.objContext +"] to ["+ ( maxDomID + 1 ) +" ] "); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			maxDomID = maxDomID + 1;
			this.maxDomIdMap.put( this.objName+"_"+this.objContext , new Integer( maxDomID ) ); //$NON-NLS-1$
		}
		else
		{
			maxDomID = ( ( Integer ) this.maxDomIdMap.get( this.objName+"_"+this.objContext ) ).intValue(); //$NON-NLS-1$
			maxDomID = maxDomID + 1;
			BaseLogger.log("3", userInfo,editorId,"Setting Value if found for ["+ this.objName+"_"+this.objContext +"] to ["+ ( maxDomID ) +" ] "); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			this.maxDomIdMap.put( this.objName+"_"+this.objContext , new Integer ( maxDomID )   ); //$NON-NLS-1$
		}
		//Changed by MOnif on 18/03/09[Changed for assigning DomID by iterating only if maxDomID is 0. To retain value in insatnce so we don't need to iterate].
		//this.maxDomID = this.maxDomID + 1;
		if(Integer.parseInt(this.objContext) > 1)
		{
			//this.detailDomId = String.valueOf(maxDomID+1);
			this.detailDomId = String.valueOf( maxDomID );
		}
		//detailNode.getAttributes().getNamedItem("domID").setNodeValue(String.valueOf(maxDomID+1));
		detailNode.getAttributes().getNamedItem("domID").setNodeValue(String.valueOf(maxDomID)); //$NON-NLS-1$
		BaseLogger.log("2", userInfo,editorId,"Assigned new Dom id :[" + maxDomID +"]"); //$NON-NLS-1$ //$NON-NLS-2$
		//Added By Pankaj T. on 17-02-2021 - added new attributes in detail tag valdatastat, taxcalcstat & id for  checking current record is valid or not at the time of adding new detail - start
		String id = "";
		String headerPKValues = "";
		if( this.headerPKFieldValues != null && (this.headerPKFieldValues.lastIndexOf(":") == this.headerPKFieldValues.length() - 1) )
		{
			headerPKValues = this.headerPKFieldValues.substring(0, this.headerPKFieldValues.lastIndexOf(":"));
		}
		if( this.objContext != null & this.objContext.equals("1") )
		{
			id = this.objContext + ":" + this.objContext + ":" + headerPKValues;
		}
		else
		{
			id = this.objContext + ":" + this.detailDomId + ":" + headerPKValues;
		}
		BaseLogger.log("2", userInfo,editorId,"detailNode id :[" + id +"]");
		detailNode.getAttributes().getNamedItem("id").setNodeValue(id);
		//Added By Pankaj T. on 17-02-2021 - added new attributes in detail tag valdatastat, taxcalcstat & id for  checking current record is valid or not at the time of adding new detail - end
	}

	private void assignNewLineNo( NodeList detailList, int detailListLength )throws Exception
	{
		String lineNoStr = ""; //$NON-NLS-1$
		int maxLineNo = 0;
		int currLineNo = -1;
		Node currDetailNode = null;
		NodeList currDetailChildNodeList = null;
		for(int detailCtr = 0; detailCtr < (detailListLength - 1); detailCtr++)
		{
			currDetailNode = detailList.item(detailCtr);
			currDetailChildNodeList = currDetailNode.getChildNodes();
			int noOfDetailChildren = currDetailChildNodeList.getLength();
			for(int detailChildCtr = 0; detailChildCtr < noOfDetailChildren; detailChildCtr++)
			{
				Node detailChildNode = currDetailChildNodeList.item(detailChildCtr);
				if(detailChildNode.getNodeName().equalsIgnoreCase( "LINE_NO" ) && detailChildNode.getFirstChild() != null) //$NON-NLS-1$
				{
					String currLineNoStr = detailChildNode.getFirstChild().getNodeValue();
					if( currLineNoStr != null )
					{
						currLineNo = Integer.parseInt( currLineNoStr.trim() );
					}
					if(currLineNo > maxLineNo)
					{
						maxLineNo = currLineNo;
						break;
					}
				}
			}
		}
		currDetailNode = detailList.item(detailListLength - 1);
		currDetailChildNodeList = currDetailNode.getChildNodes();
		int noOfDetailChildren = currDetailChildNodeList.getLength();
		for(int detailChildCtr = 0; detailChildCtr < noOfDetailChildren; detailChildCtr++)
		{
			Node detailChildNode = currDetailChildNodeList.item(detailChildCtr);
			if(detailChildNode.getNodeName().equalsIgnoreCase("LINE_NO")) //$NON-NLS-1$
			{
				lineNoStr = String.valueOf(maxLineNo + 1);
				DWObject dwObj = getDWObject(this.objName, Integer.parseInt(this.objContext));
				HashMap colLogNameTypeMap = dwObj.getColLogNameTypeMap();
				HashMap colLogNameSizeMap = dwObj.getColLogNameSizeMap();
				if(((String)colLogNameTypeMap.get("line_no")).equalsIgnoreCase("char")) //$NON-NLS-1$ //$NON-NLS-2$
				{
					int size = ((Integer)colLogNameSizeMap.get("line_no")).intValue(); //$NON-NLS-1$
					while(lineNoStr.length() != size)
					{
						lineNoStr = " " + lineNoStr; //$NON-NLS-1$
					}
				}
				CDATASection cDataSection = currDetailNode.getOwnerDocument().createCDATASection(lineNoStr);
				if(detailChildNode.getFirstChild() != null)
				{
					detailChildNode.replaceChild(cDataSection, detailChildNode.getFirstChild());
				}
				else
				{
					detailChildNode.appendChild(cDataSection);
				}
				break;
			}
		}
		BaseLogger.log("2", userInfo,editorId,"Assigned new line no :["+lineNoStr+"]"); //$NON-NLS-1$ //$NON-NLS-2$
	}

	private void assignPKFieldValues(Node detailNode)throws Exception
	{
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]this.headerPKFieldValues :"+this.headerPKFieldValues); //$NON-NLS-1$
		if(this.headerPKFieldValues != null && this.headerPKFieldValues.length() > 0)
		{
			NodeList currDetailChildNodeList = detailNode.getChildNodes();
			int noOfDetailChildren = currDetailChildNodeList.getLength();
			StringTokenizer pkNameTokens = new StringTokenizer(this.headerPKFieldNames, ":"); //$NON-NLS-1$
			StringTokenizer pkValueTokens = new StringTokenizer(this.headerPKFieldValues, ":"); //$NON-NLS-1$
			while(pkNameTokens.hasMoreTokens())
			{
				String currPKName = pkNameTokens.nextToken();
				String currPKValue = pkValueTokens.nextToken();
								
				for(int detailChildCtr = 0; detailChildCtr < noOfDetailChildren; detailChildCtr++)
				{
					Node detailChildNode = currDetailChildNodeList.item(detailChildCtr);
					if(detailChildNode.getNodeName().equalsIgnoreCase(currPKName))
					{
						//detailChildNode.appendChild(this.detailDom.createTextNode(currPKValue));
						CDATASection cDataSection = detailChildNode.getOwnerDocument().createCDATASection(currPKValue);
						if(detailChildNode.getFirstChild() != null)
						{
							detailChildNode.replaceChild(cDataSection, detailChildNode.getFirstChild());
						}
						else
						{
							detailChildNode.appendChild(cDataSection);
						}
						break;
					}
				}
			}//while(pkNameTokens.hasMoreTokens())
		}
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]Assigned header pk field values...."); //$NON-NLS-1$
	}

	private void assignArgValues(Node detailNode, ArrayList itemChangeList)throws Exception
	{
		if(this.argFieldValues != null && this.argFieldValues.length() > 0)
		{
			NodeList currDetailChildNodeList = detailNode.getChildNodes();
			int noOfDetailChildren = currDetailChildNodeList.getLength();
			
			StringTokenizer argNameTokens = new StringTokenizer(this.argFieldNames, ":"); //$NON-NLS-1$
			StringTokenizer argValueTokens = new StringTokenizer(this.argFieldValues, ":"); //$NON-NLS-1$
			StringTokenizer argTypeTokens = new StringTokenizer(this.argFieldTypes, ":"); //$NON-NLS-1$
			Date startTime = new Date();
			while(argNameTokens.hasMoreTokens())
			{
				String currArgName = argNameTokens.nextToken();
				//Change by shrutika on 03-09-19 [Start] for itmDefault value not set in create receipt link.
				//String currArgValue = argValueTokens.nextToken();
				String currArgValue = "";
				if( argValueTokens.hasMoreTokens() )
				{
					currArgValue = argValueTokens.nextToken();
				}
				else
				{
					ArgumentEJB argument = new ArgumentEJB();
					HashMap defValMap = argument.createDefValueMap(this.objName, userInfo);
					if( defValMap != null && defValMap.containsKey(currArgName) )
					{
						currArgValue = ( String ) defValMap.get( currArgName );
					}
				}
				//Change by shrutika on 03-09-19 [End] for itmDefault value not set in create receipt link.
				String currArgType = argTypeTokens.nextToken();
				if (currArgName != null && currArgName.length() > 0)
				{
					for(int detailChildCtr = 0; detailChildCtr < noOfDetailChildren; detailChildCtr++)
					{
						Node detailChildNode = currDetailChildNodeList.item(detailChildCtr);
						if(detailChildNode.getNodeName().equalsIgnoreCase(currArgName))
						{							
							//detailChildNode.appendChild(this.detailDom.createTextNode(currArgValue));
							CDATASection cDataSection = detailChildNode.getOwnerDocument().createCDATASection(currArgValue);
							if(detailChildNode.getFirstChild() != null)
							{
								detailChildNode.replaceChild(cDataSection, detailChildNode.getFirstChild());
							}
							else
							{
								detailChildNode.appendChild(cDataSection);
							}
							if( itemChangeList.contains( currArgName ) )
							{
								String tempString = ""; //$NON-NLS-1$
								//Changed by Pramod on 06-01-11[ WI01SUN021 || Set encoding from CommonConstants]
											//"<?xml version='1.0' encoding='utf-8'?>"
								tempString = "<?xml version='1.0' encoding='"+CommonConstants.ENCODING+"'?>" //$NON-NLS-1$ //$NON-NLS-2$
										+ "<Root>" //$NON-NLS-1$
										+ "<header>" //$NON-NLS-1$
										+ "<objName><![CDATA["+ this.objName +"]]></objName>" //$NON-NLS-1$ //$NON-NLS-2$
										+ "<pageContext><![CDATA["+ this.pageContext +"]]></pageContext>" //$NON-NLS-1$ //$NON-NLS-2$
										+ "<objContext><![CDATA["+ this.objContext +"]]></objContext>" //$NON-NLS-1$ //$NON-NLS-2$
										+ "<editFlag><![CDATA["+ this.localEditFlag +"]]></editFlag>" //$NON-NLS-1$ //$NON-NLS-2$
										+ "<focusedColumn><![CDATA["+ currArgName +"]]></focusedColumn>" //$NON-NLS-1$ //$NON-NLS-2$
										+ "<keyValue><![CDATA[" + ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId) + "]]></keyValue>" //$NON-NLS-1$ //$NON-NLS-2$
										+ "<saveLevel><![CDATA[0]]></saveLevel>" //$NON-NLS-1$
										+ "<forcedSave><![CDATA[false]]></forcedSave>" //$NON-NLS-1$
										+ "</header>" //$NON-NLS-1$
										+ "<Detail>" //$NON-NLS-1$
										+ "<"+currArgName+">"+ currArgValue +"</"+currArgName+">" //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
										+ "</Detail>" //$NON-NLS-1$
										+ "</Root>"; //$NON-NLS-1$
								currentEventContext = this.objContext + COLUMN_SEPARATOR + currArgName;
								applyItemChange(tempString);
							}
							break;
						}
					}
				}//if (currArgName != null && currArgName.length() > 0)
			}//while
			// Added by Raju K on 01-07-14 for Bug Fixing of start time end time[WI3DSUN001] in Event log and Transaction lock as per danish sir 
			userSetEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(), this.getEditorId(), "EDIT", "post_item_change", startTime, new Date(),"EventContext:[" + currentEventContext + "], focused column:[" + this.focussedColumn + "]", this.headerPKFieldValues);
		}//if(this.argFieldValues != null && this.argFieldValues.length() > 0)
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]Assigned arg field values...."); //$NON-NLS-1$
	}

	private void assignDefaultValues(String userType, String entityCode, ArrayList itemChangeList)throws Exception		
	{
		Connection con = null;
		Statement stmt = null;
		//Added By Shahu Mali on 09-10-13
		String transDB = null;
		try
		{
			ConnDriver conDriver = null;
			conDriver = new ConnDriver();
			//Commented and Below changes done By Shahu Mali on 09-10-13 for multiDB connection : START
			transDB = this.userInfo.getTransDB();
			if(transDB != null && !"null".equalsIgnoreCase(transDB) && transDB.trim().length() > 0)
			{
				con = conDriver.getConnectDB(transDB);
			}
			//Commented and Below changes done By Shahu Mali on 09-10-13 for multiDB connection : END
			//SITE_ACC_COL,ITEM_SER_ACC_COL these values not to be set from here
			String sql = "SELECT SITE_ACC_COL,SALES_PERS_ACC_COL,CUST_ACC_COL,SUPP_ACC_COL,ITEM_SER_ACC_COL,EMP_ACC_COL FROM TRANSETUP WHERE TRAN_WINDOW='w_" + this.objName+"'"; //$NON-NLS-1$ //$NON-NLS-2$
			stmt = con.createStatement();
			ResultSet rs = stmt.executeQuery(sql);		
			String site_acc_col = null;
			String sales_pers_acc_col = null;
			String cust_acc_col = null;
			String supp_acc_col = null;
			String item_ser_acc_col = null;
			String emp_acc_col = null;

			if(rs.next())
			{
				site_acc_col = rs.getString("SITE_ACC_COL"); //$NON-NLS-1$
				
				sales_pers_acc_col = rs.getString("SALES_PERS_ACC_COL"); //$NON-NLS-1$
				
				cust_acc_col = rs.getString("CUST_ACC_COL"); //$NON-NLS-1$
				
				supp_acc_col = rs.getString("SUPP_ACC_COL"); //$NON-NLS-1$
				
				item_ser_acc_col = rs.getString("ITEM_SER_ACC_COL"); //$NON-NLS-1$
				
				emp_acc_col = rs.getString("EMP_ACC_COL"); //$NON-NLS-1$
				
			}//if(rs.next())
			rs.close();
			stmt.close();
			stmt = null;
			boolean isColAssigned = false;
			if(this.userInfo.getUserLevel() != null && Integer.parseInt(this.userInfo.getUserLevel()) > 1)
			{
				isColAssigned = true;
			}
			String tempString = "<?xml version='1.0' encoding='"+this.userInfo.getCharEnc()+"'?>" //$NON-NLS-1$ //$NON-NLS-2$
						+ "<Root>" //$NON-NLS-1$
						+ "<header>" //$NON-NLS-1$
						+ "<objName><![CDATA[" + this.objName +"]]></objName>" //$NON-NLS-1$ //$NON-NLS-2$
						+ "<pageContext><![CDATA[" + this.pageContext +"]]></pageContext>" //$NON-NLS-1$ //$NON-NLS-2$
						+ "<objContext><![CDATA[" + this.objContext +"]]></objContext>" //$NON-NLS-1$ //$NON-NLS-2$
						+ "<editFlag><![CDATA[" + this.localEditFlag +"]]></editFlag>"		 //$NON-NLS-1$ //$NON-NLS-2$
						+ "<keyValue><![CDATA[" + ((Integer.parseInt(this.objContext.trim()) == 1) ? this.headerDomId : this.detailDomId) + "]]></keyValue>" //$NON-NLS-1$ //$NON-NLS-2$
						+ "<saveLevel><![CDATA[0]]></saveLevel>" //$NON-NLS-1$
						+ "<forcedSave><![CDATA[false]]></forcedSave>"; //$NON-NLS-1$
			
			String applString = ""; //$NON-NLS-1$
			Date startTime = new Date();
			if(site_acc_col != null && site_acc_col.length() > 0)
			{
				applString = tempString 
								+ "<focusedColumn><![CDATA[" + site_acc_col.toLowerCase() +"]]></focusedColumn>" //$NON-NLS-1$ //$NON-NLS-2$
								+ "</header>" //$NON-NLS-1$
								+ "<Detail>"								 //$NON-NLS-1$
								+ "<"+site_acc_col.toLowerCase() + ((isColAssigned) ? " protect='1'>" : ">")  //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
								+ this.userInfo.getSiteCode() +"</"+site_acc_col.toLowerCase()+">" //$NON-NLS-1$ //$NON-NLS-2$
								+ "</Detail>" //$NON-NLS-1$
								+ "</Root>"; //$NON-NLS-1$
				currentEventContext = this.objContext + COLUMN_SEPARATOR + site_acc_col.toLowerCase();
				applyItemChange(applString);
			}

			if (this.userInfo.getUserType() != null)
			{
				if((this.userInfo.getUserType().trim().equalsIgnoreCase("P")) && (sales_pers_acc_col != null && sales_pers_acc_col.length() >0)) //$NON-NLS-1$
				{
					applString = tempString 
								+ "<focusedColumn><![CDATA[" + sales_pers_acc_col.toLowerCase() +"]]></focusedColumn>" //$NON-NLS-1$ //$NON-NLS-2$
								+ "</header>" //$NON-NLS-1$
								+ "<Detail>"								 //$NON-NLS-1$
								+ "<"+sales_pers_acc_col.toLowerCase() + ((isColAssigned) ? " protect='1'>" : ">")  //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
								+ this.userInfo.getEntityCode()
								+ "</"+sales_pers_acc_col.toLowerCase()+">" //$NON-NLS-1$ //$NON-NLS-2$
								+ "</Detail>" //$NON-NLS-1$
								+ "</Root>"; //$NON-NLS-1$
					currentEventContext = this.objContext + COLUMN_SEPARATOR + sales_pers_acc_col.toLowerCase();
					applyItemChange(applString);
				}
				else if((this.userInfo.getUserType().trim().equalsIgnoreCase("C")) && (cust_acc_col != null && cust_acc_col.length() >0)) //$NON-NLS-1$
				{
					applString = tempString 
								+ "<focusedColumn><![CDATA[" + cust_acc_col.toLowerCase() +"]]></focusedColumn>" //$NON-NLS-1$ //$NON-NLS-2$
								+ "</header>" //$NON-NLS-1$
								+ "<Detail>"								 //$NON-NLS-1$
								+ "<"+cust_acc_col.toLowerCase() + ((isColAssigned) ? " protect='1'>" : ">")  //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
								+ this.userInfo.getEntityCode()
								+ "</"+cust_acc_col.toLowerCase()+">" //$NON-NLS-1$ //$NON-NLS-2$
								+ "</Detail>" //$NON-NLS-1$
								+ "</Root>"; //$NON-NLS-1$
					currentEventContext = this.objContext + COLUMN_SEPARATOR + cust_acc_col.toLowerCase();
					applyItemChange(applString);
				}
				else if((this.userInfo.getUserType().trim().equalsIgnoreCase("S")) && (supp_acc_col != null && supp_acc_col.length() >0)) //$NON-NLS-1$
				{
					applString = tempString 
								+ "<focusedColumn><![CDATA[" + supp_acc_col.toLowerCase() +"]]></focusedColumn>" //$NON-NLS-1$ //$NON-NLS-2$
								+ "</header>" //$NON-NLS-1$
								+ "<Detail>"								 //$NON-NLS-1$
								+ "<"+supp_acc_col.toLowerCase() + ((isColAssigned) ? " protect='1'>" : ">")  //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
								+ this.userInfo.getEntityCode()
								+ "</"+supp_acc_col.toLowerCase()+">" //$NON-NLS-1$ //$NON-NLS-2$
								+ "</Detail>" //$NON-NLS-1$
								+ "</Root>"; //$NON-NLS-1$
					currentEventContext = this.objContext + COLUMN_SEPARATOR + supp_acc_col.toLowerCase();
					applyItemChange(applString);
				}
				else if((this.userInfo.getUserType().trim().equalsIgnoreCase("E")) && (emp_acc_col != null && emp_acc_col.length() >0)) //$NON-NLS-1$
				{
					applString = tempString 
								+ "<focusedColumn><![CDATA[" + emp_acc_col.toLowerCase() +"]]></focusedColumn>" //$NON-NLS-1$ //$NON-NLS-2$
								+ "</header>" //$NON-NLS-1$
								+ "<Detail>"								 //$NON-NLS-1$
								+ "<"+emp_acc_col.toLowerCase() + ((isColAssigned) ? " protect='1'>" : ">")  //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
								+ this.userInfo.getEntityCode()
								+ "</"+emp_acc_col.toLowerCase()+">" //$NON-NLS-1$ //$NON-NLS-2$
								+ "</Detail>" //$NON-NLS-1$
								+ "</Root>"; //$NON-NLS-1$
					currentEventContext = this.objContext + COLUMN_SEPARATOR + emp_acc_col.toLowerCase();
					applyItemChange(applString);
				}
				else if (item_ser_acc_col != null && item_ser_acc_col.length() > 0)
				{
					applString = tempString 
								+ "<focusedColumn><![CDATA[" + item_ser_acc_col.toLowerCase() +"]]></focusedColumn>" //$NON-NLS-1$ //$NON-NLS-2$
								+ "</header>" //$NON-NLS-1$
								+ "<Detail>"								 //$NON-NLS-1$
								+ "<"+item_ser_acc_col.toLowerCase() + ((isColAssigned) ? " protect='1'>" : ">")  //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
								+ this.userInfo.getItemSer()
								+ "</"+item_ser_acc_col.toLowerCase()+">" //$NON-NLS-1$ //$NON-NLS-2$
								+ "</Detail>" //$NON-NLS-1$
								+ "</Root>"; //$NON-NLS-1$
					currentEventContext = this.objContext + COLUMN_SEPARATOR + item_ser_acc_col.toLowerCase();
					applyItemChange(applString);
				}
			}//if (this.userInfo.getUserType() != null)
			BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB]Assigned default values...."); //$NON-NLS-1$
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw e;
		}
		finally
		{
			try
			{
				if(con != null)
				{					
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					con.close();
					con = null;
				}				
			}
			catch(Exception e)
			{
				System.err.println("Exception: MasterStatefulEJB: assignDefaultValues :finally" + e); //$NON-NLS-1$
				throw e;
			}
		}
	}
	
	private void assignITMDefaultValues(String editFlag, ArrayList itemChangeList)throws Exception		
	{
		try
		{
			Date startTime = new Date();
			//Changed by Danish on 03/01/2007 Calling itemChange if requestParamStr found
			if ( this.requestParamStr != null )
			{
				StringTokenizer requestParamST = null;
				String elementName = ""; //$NON-NLS-1$
				String elementValue = ""; //$NON-NLS-1$
				if( ! this.requestParamStr.equals( "" ) ) //$NON-NLS-1$
				{
					requestParamST =new StringTokenizer( this.requestParamStr, "~" ); //$NON-NLS-1$
					while(requestParamST.hasMoreTokens()) 
					{
						String currentPair = requestParamST.nextToken();
						elementName = currentPair.substring(0, currentPair.indexOf("=")); //$NON-NLS-1$
						elementName = elementName.toLowerCase();
						elementValue = currentPair.substring(currentPair.indexOf("=") + 1); //$NON-NLS-1$
						
						setValueOnDom(this.objContext, elementName, elementValue);
						
						String tempString = ""; //$NON-NLS-1$
						tempString = "<?xml version='1.0' encoding='"+this.userInfo.getCharEnc()+"'?>" //$NON-NLS-1$ //$NON-NLS-2$
									+ "<Root>" //$NON-NLS-1$
									+ "<header>" //$NON-NLS-1$
									+ "<objName><![CDATA["+ this.objName +"]]></objName>" //$NON-NLS-1$ //$NON-NLS-2$
									+ "<pageContext><![CDATA["+ this.pageContext +"]]></pageContext>" //$NON-NLS-1$ //$NON-NLS-2$
									+ "<objContext><![CDATA["+ this.objContext +"]]></objContext>" //$NON-NLS-1$ //$NON-NLS-2$
									+ "<editFlag><![CDATA["+ this.localEditFlag +"]]></editFlag>" //$NON-NLS-1$ //$NON-NLS-2$
									+ "<focusedColumn><![CDATA["+elementName+"]]></focusedColumn>" //$NON-NLS-1$ //$NON-NLS-2$
									+ "<keyValue><![CDATA[" + ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId) + "]]></keyValue>" //$NON-NLS-1$ //$NON-NLS-2$
									+ "<saveLevel><![CDATA[0]]></saveLevel>" //$NON-NLS-1$
									+ "<forcedSave><![CDATA[false]]></forcedSave>" //$NON-NLS-1$
									+ "</header>" //$NON-NLS-1$
									+ "</Root>"; //$NON-NLS-1$
						currentEventContext = this.objContext + COLUMN_SEPARATOR + elementName;
						startTime = new Date();
						applyItemChange(tempString);
					}//while(requestParamST.hasMoreTokens()) 
				}
			}//if ( this.requestParamStr != null)

			String fieldName = ""; //$NON-NLS-1$
			if (editFlag.equalsIgnoreCase("A")) //$NON-NLS-1$
			{
				fieldName = "itm_default"; //$NON-NLS-1$
			}
			else if (editFlag.equalsIgnoreCase("E")) //$NON-NLS-1$
			{
				fieldName = "itm_defaultedit"; //$NON-NLS-1$
			}
			if( itemChangeList.contains( fieldName ) )
			{
				String tempString = ""; //$NON-NLS-1$
				tempString = "<?xml version='1.0' encoding='"+this.userInfo.getCharEnc()+"'?>" //$NON-NLS-1$ //$NON-NLS-2$
							+ "<Root>" //$NON-NLS-1$
							+ "<header>" //$NON-NLS-1$
							+ "<objName><![CDATA["+ this.objName +"]]></objName>" //$NON-NLS-1$ //$NON-NLS-2$
							+ "<pageContext><![CDATA["+ this.pageContext +"]]></pageContext>" //$NON-NLS-1$ //$NON-NLS-2$
							+ "<objContext><![CDATA["+ this.objContext +"]]></objContext>" //$NON-NLS-1$ //$NON-NLS-2$
							+ "<editFlag><![CDATA["+ this.localEditFlag +"]]></editFlag>" //$NON-NLS-1$ //$NON-NLS-2$
							+ "<focusedColumn><![CDATA["+fieldName+"]]></focusedColumn>" //$NON-NLS-1$ //$NON-NLS-2$
							+ "<keyValue><![CDATA[" + ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId) + "]]></keyValue>" //$NON-NLS-1$ //$NON-NLS-2$
							+ "<saveLevel><![CDATA[0]]></saveLevel>" //$NON-NLS-1$
							+ "<forcedSave><![CDATA[false]]></forcedSave>" //$NON-NLS-1$
							+ "</header>" //$NON-NLS-1$
							+ "</Root>"; //$NON-NLS-1$
				currentEventContext = this.objContext + COLUMN_SEPARATOR + fieldName;
				startTime = new Date();
				applyItemChange(tempString);
			}
			BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB]Assigned itm default values...."); //$NON-NLS-1$
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw e;
		}
	}

	private Document transformDom(Document dom, String xslFileName)throws Exception
	{
		Document trasformedDom = null;
		String retString = null;
		String xslFilePath = ".." + File.separator + "xsl" + File.separator + xslFileName + "_trfrm.xsl"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		System.setProperty("javax.xml.transformer.TransformerFactory","org.apache.xalan.processor.TransformerFactoryImpl"); //$NON-NLS-1$ //$NON-NLS-2$
		TransformerFactory tFactory = TransformerFactory.newInstance();
		Transformer transformer = tFactory.newTransformer(new StreamSource(xslFilePath));
		ByteArrayOutputStream bos = new ByteArrayOutputStream();
		transformer.transform(new DOMSource(dom), new StreamResult(bos));
		retString = bos.toString( CommonConstants.ENCODING );
		trasformedDom = parseString(retString);
		return trasformedDom;
	}

	private String getSystemDefObjName(String systemDefObjInfo, Document sysDefObjDom) throws Exception
	{
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]Getting system def obj name for systemDefObjInfo :"+systemDefObjInfo+":"); //$NON-NLS-1$ //$NON-NLS-2$
		String sysObjName = null;
		if(((systemDefObjInfo.indexOf("<") == 0) && (systemDefObjInfo.indexOf(">") == systemDefObjInfo.length() - 1))) //$NON-NLS-1$ //$NON-NLS-2$
		{
			String tagName = systemDefObjInfo.substring(1, systemDefObjInfo.indexOf(">")); //$NON-NLS-1$
			if(tagName.indexOf("@") > 0) //$NON-NLS-1$
			{
				NodeList detailNodeList = sysDefObjDom.getElementsByTagName(tagName.substring(0, tagName.indexOf("@"))); //$NON-NLS-1$
				if(detailNodeList.getLength() > 0)
				{
					sysObjName = detailNodeList.item(0).getAttributes().getNamedItem(tagName.substring(tagName.indexOf("@")+1, tagName.length())).getNodeValue(); //$NON-NLS-1$
				}
			}
			else
			{
				NodeList tagNodeList = sysDefObjDom.getElementsByTagName(tagName);
				if (tagNodeList.getLength() > 0)
				{
					if (tagNodeList.item(0).getFirstChild() != null)
					{
						sysObjName = tagNodeList.item(0).getFirstChild().getNodeValue();
					}
				}
			}
		}
		return sysObjName;
	}

	private void setFocus()throws Exception
	{
		Document dom = null;
		String localDomId = "1"; //$NON-NLS-1$
		if(this.objContext.equalsIgnoreCase("1")) //$NON-NLS-1$
		{
			dom = this.headerListDom;
			localDomId = this.viewDomId;
		}
		else
		{
			dom = this.detailDom;
			localDomId = this.detailDomId;
		}
		//Search nodes used to make sure that remaining details are retrieved and there selected attribute is set to 'N'
		NodeList detailList = searchNodes(dom, this.objContext);
		int detListLength = detailList.getLength();
		for(int oCtr = 0; oCtr < detListLength; oCtr++)
		{
			Node curDetail = detailList.item(oCtr);
			if(curDetail.getAttributes().getNamedItem("domID").getNodeValue().equalsIgnoreCase(localDomId)) //$NON-NLS-1$
			{				
				NodeList detailChildList = curDetail.getChildNodes();
				int detChildListLength =  detailChildList.getLength();
				for(int iCtr = 0; iCtr < detChildListLength ; iCtr++)
				{
					Node curChild = detailChildList.item(iCtr);
					if(curChild.getNodeName().equalsIgnoreCase("attribute") && curChild.getAttributes().getNamedItem("selected") != null) //$NON-NLS-1$ //$NON-NLS-2$
					{
						curChild.getAttributes().getNamedItem("selected").setNodeValue("Y"); //$NON-NLS-1$ //$NON-NLS-2$
						break;
					}
				}
			}
			else
			{
				NodeList detailChildList = curDetail.getChildNodes();
				int detChildListLength = detailChildList.getLength();
				for(int iCtr = 0; iCtr < detChildListLength; iCtr++)
				{
					Node curChild = detailChildList.item(iCtr);
					if(curChild.getNodeName().equalsIgnoreCase("attribute") && curChild.getAttributes().getNamedItem("selected") != null) //$NON-NLS-1$ //$NON-NLS-2$
					{
						curChild.getAttributes().getNamedItem("selected").setNodeValue("N"); //$NON-NLS-1$ //$NON-NLS-2$
						break;
					}
				}
			}
		}
	}
	//changed by vishal pathare for using clipBoardData(Excel data) onpaste event add feeds in detail page for browser].
	public String getXtraParams() throws ITMException
	{
		StringBuffer xtraParamsBuff = new StringBuffer();
		xtraParamsBuff.append("loginCode=" + this.userInfo.getLoginCode()); //$NON-NLS-1$
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("loginEmpCode=" + this.userInfo.getEmpCode()); //$NON-NLS-1$
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("loginSiteCode=" + this.userInfo.getSiteCode()); //$NON-NLS-1$
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("entityCode=" + this.userInfo.getEntityCode()); //$NON-NLS-1$
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("profileId=" + this.userInfo.getProfileId()); //$NON-NLS-1$
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("userType=" + this.userInfo.getUserType()); //$NON-NLS-1$
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("runMode="+this.runMode); //$NON-NLS-1$
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("user_lang=" + this.user_lang); //$NON-NLS-1$
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("user_country=" + this.user_country); //$NON-NLS-1$
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("charEnc=" + this.userInfo.getCharEnc()); //$NON-NLS-1$
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("objName=" + this.objName); //$NON-NLS-1$
		//Added by Dnyaneshwar Chavan on 4-Apr-14 [Add timeZone Data member in user info been as per Danish sir  ] Start
		String timeZone = getUserTimeZone();
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("timeZone=" + timeZone ); //$NON-NLS-1$
		//Added by Dnyaneshwar Chavan on 4-Apr-14 [Add timeZone Data member in user info been as per Danish sir  ] End
		
		//Changed by Dhruv on 10/08/2006 as siteCode should have the value from Formal Args and loginSiteCode sotred in as loginSiteCode.
		//xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("site_code=" + this.userInfo.getSiteCode());
		//Changed by Manish on 04/06/2007 to poulate termId based on user info remote host.
		//xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("termId=SYSTEM");
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("termId="+this.userInfo.getRemoteHost()); //$NON-NLS-1$

		// changes by madhup 10/02/07
		//Change by Nilesh on 21-Mar-2011 [MF01SUN037][set machine name into chgterm]Start
		String chgTerm = this.userInfo.getRemoteHostName();
		if( chgTerm != null && chgTerm.length() > 15 )
		{
			chgTerm = chgTerm.substring(0, 15);
		}
		else if( chgTerm == null || chgTerm.length() == 0 )
		{
			chgTerm = this.userInfo.getRemoteHost();
		}
		//xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("chgTerm=" + this.userInfo.getRemoteHost());
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("chgTerm=" + chgTerm ); //$NON-NLS-1$
		//Change by Nilesh on 21-Mar-2011 [MF01SUN037][set machine name into chgterm]End
		
		NodeList detailList = searchNodes(this.detailDom, this.objContext);
		int detailListLength = (detailList != null)?detailList.getLength():0;
		String currDomId = (this.objContext.equals("1"))?this.headerDomId:this.detailDomId; //$NON-NLS-1$
		int focussedRow = -1;
		int detailCnt = 0;
		for(int i = 0; i < detailListLength; i++)
		{
			Node detailNode = detailList.item(i);
			String updateFlag = ""; //$NON-NLS-1$
			NodeList colNodeList = detailNode.getChildNodes();
			int colCnt = colNodeList.getLength();
			for (int colCtr=0; colCtr<colCnt; colCtr++)
			{
				Node colNode = colNodeList.item(colCtr);
				if (colNode.getNodeName().equalsIgnoreCase("attribute")) //$NON-NLS-1$
				{
					updateFlag = ((colNode.getAttributes()).getNamedItem("updateFlag")).getNodeValue(); //$NON-NLS-1$
					break;
				}
			}
			if(! updateFlag.equalsIgnoreCase("D")) //$NON-NLS-1$
			{
				detailCnt++;
				String domId = detailNode.getAttributes().getNamedItem("domID").getNodeValue(); //$NON-NLS-1$
				if(domId.equals(currDomId))
				{
					focussedRow = detailCnt;
					//break;
				}
			}
		}
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("detCnt=" + detailCnt); //$NON-NLS-1$
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("focusRow=" + focussedRow); //$NON-NLS-1$

		if(this.argFieldValues != null && this.argFieldValues.length() > 0)
		{
			StringTokenizer argNameTokens  = new StringTokenizer(this.argFieldNames, ":"); //$NON-NLS-1$
			StringTokenizer argValueTokens = new StringTokenizer(this.argFieldValues, ":"); //$NON-NLS-1$
			
			while(argNameTokens.hasMoreTokens())
			{
				String currArgName = argNameTokens.nextToken();
				//Change by shrutika on 19-08-19 [Start] for In purchase order menu NoSuchElementException occur while open link create receipt.
				//String currArgValue = argValueTokens.nextToken();
				String currArgValue = "";
				if( argValueTokens.hasMoreTokens() )
				{
					currArgValue = argValueTokens.nextToken();
				}
				else
				{
					ArgumentEJB argument = new ArgumentEJB();
					HashMap defValMap = argument.createDefValueMap(this.objName, userInfo);
					if( defValMap != null && defValMap.containsKey(currArgName) )
					{
						currArgValue = ( String ) defValMap.get( currArgName );
					}
				}
				//Change by shrutika on 19-08-19 [End] for In purchase order menu NoSuchElementException occur while open link create receipt.
				//Changed by Dhruv on Thursday, July 13, 2006 : to avoid repetation of parameters with same name.
				if( xtraParamsBuff.toString().indexOf( XTRA_PARAMS_SEPARATOR + currArgName + "=" ) == -1 ) //$NON-NLS-1$
				{
					xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append(currArgName + "=" + currArgValue); //$NON-NLS-1$
				}
			}
        }
		//Changed by Shravan on 01/11/2006 added a temp variable to handle itemchange from external requests to store the current record index.
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("REC_CTR=" + this.recCtr); //$NON-NLS-1$
		//Changed by Danish on 02/12/2006
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("saveLevel=" + this.saveLevel); //$NON-NLS-1$
		//BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB]XTRA_PARAMS :" + xtraParamsBuff.toString());
		
    	//Added By Prajyot - To append currentGeoPos in XTRA_PARAMS
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("currentGeoPos=" + this.userInfo.getCurrentGeoPOS() ); //$NON-NLS-1$
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]XTRA_PARAMS currentGeoPos :" + this.userInfo.getCurrentGeoPOS() );
		
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("currentGeoPosName=" + this.userInfo.getCurrentGeoPOSName() );		//Added By Sagar B. - To append currentGeoPosName in XTRA_PARAMS[10-Apr-18]
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("geoPosAccuracy=" + this.userInfo.getGeoPosAccuracy() );		//Added by Sagar B. to store accuracy of geo position[23-Jul-18]
        //Added if condition by shrutika on 16-02-21 [Start] for issue in preview action of incentive defination in case of view mode
        if( headerInfoMap != null )
        {
            xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("forcedSave=" + headerInfoMap.get("forcedSave")  );//AMOL S on 18-7-19
        }
        //Added if condition by shrutika on 16-02-21 [End] for issue in preview action of incentive defination in case of view mode.
      //Added by Pankaj P on 25/05/2021 [set batchid details] START
        if( this.uploadBatchId != null && this.uploadBatchId.length() > 0 )
        {
            xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("batch_id=" + this.uploadBatchId );
        }
      //Added by Pankaj P on 25/05/2021 [set batchid details] END
		return xtraParamsBuff.toString();
	}

	private String getValueOfField(Node node, String currFieldName)throws Exception
	{
		String currFieldValue = null;
		NodeList childNodeList = node.getChildNodes();
		int noOfChilds = childNodeList.getLength();
		for(int ctr = 0; ctr < noOfChilds; ctr++)
		{
			Node currChild = childNodeList.item(ctr);
			if(currChild.getNodeName().equalsIgnoreCase(currFieldName) && currChild.getFirstChild() != null)
			{
				currFieldValue = currChild.getFirstChild().getNodeValue();
				break;
			}
		}
		return currFieldValue;
	}

	private String getValueOfField(Document dom, String currFieldName)throws Exception
	{
		String currFieldValue = null;
		NodeList currFieldList = dom.getElementsByTagName(currFieldName);
		int currFieldListLen = currFieldList.getLength();
		if (currFieldListLen > 0)
		{
			if (currFieldList.item(0).getFirstChild() != null)
			{
				currFieldValue = currFieldList.item(0).getFirstChild().getNodeValue();
			}
			else
			{
				currFieldValue = null;
			}				
		}
		return currFieldValue;
	}
	
	private ArrayList getTokenList(String tokenString, String delimiter) throws Exception
	{
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]Getting arraylist from the string :"+tokenString+": delimiter :"+delimiter+":"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		ArrayList returnList = null;
		if (tokenString != null && tokenString.length() > 0 && tokenString !="") //$NON-NLS-1$
		{
			returnList = new ArrayList();
			if (delimiter.length() == 1)
			{
				while (tokenString.indexOf(delimiter) != -1)
				{
					int endIndex = tokenString.indexOf(delimiter);
					returnList.add(tokenString.substring(0, endIndex));
					tokenString = tokenString.substring(endIndex + 1, tokenString.length());
				}
				returnList.add(tokenString.substring(0, tokenString.length()));
			}
			else if ((delimiter.length() == 2) && (delimiter.equals("[]") || delimiter.equals("{}") || delimiter.equals("()"))) //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			{
				while (tokenString.indexOf(delimiter.substring(0, 1)) != -1)
				{
					int endIndex = tokenString.indexOf(delimiter.substring(1));
					returnList.add(tokenString.substring(1, endIndex));
					tokenString = tokenString.substring(endIndex + 1, tokenString.length());
				}
			}
		}
		return returnList;
	}
	
//creates currentTaxNode from current node
	private Node getCurrTaxNode() throws Exception
	{
		//Added by shrutika on 18-06-19 [Start] for perform tax calculation after copy paste records in detail.
		this.currRecordNode = searchNode( this.detailDom, this.objContext, ( ( Integer.parseInt( this.objContext.trim() ) == 1 ) ? this.headerDomId : this.detailDomId ), this.currDbID );
		Node taxNode = null;
		try
		{
			NodeList currRecordChildList = this.currRecordNode.getChildNodes();
			int childListLength = currRecordChildList.getLength();
			for (int i = 0; i < childListLength; i++)
			{
				if (currRecordChildList.item(i).getNodeName().equalsIgnoreCase("Taxes")) //$NON-NLS-1$
				{
					taxNode = currRecordChildList.item(i);
				}
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception:MasterStatefulEJB: getCurrTaxNode:"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return taxNode;
	}

	//Changed by Prasad on 02/11/16 [to search node from dbId]
	//private Node getCurrTaxNode(String objContext, String domID) throws Exception
	private Node getCurrTaxNode(String objContext, String domID, String dbId) throws Exception
	{
		Node taxNode = null;
		try
		{
			BaseLogger.log("3", userInfo,editorId,"MasterStatefulEJB : getCurrTaxNode : objContext :"+objContext+": domID :"+domID+":"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			//Changed by Prasad on 02/11/16 [to search node from dbId]
			//Node currNode	 = searchNode(this.detailDom, objContext, domID);
			Node currNode	 = searchNode(this.detailDom, objContext, domID, dbId);
			if(currNode != null)
			{
				NodeList currRecordChildList = currNode.getChildNodes();
				int childListLength = currRecordChildList.getLength();
				for (int i = 0; i < childListLength; i++)
				{
					if (currRecordChildList.item(i).getNodeName().equalsIgnoreCase("Taxes")) //$NON-NLS-1$
					{
						taxNode = currRecordChildList.item(i);
					}
				}
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception:MasterStatefulEJB: getCurrTaxNode(String objContext, String domID):"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return taxNode;
	}
	
	//SHWETA 27-06-2005
	private String getAllTaxesXMLString(String objContext, String domID)throws ITMException
	{
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]Getting all taxes string for objContext :"+objContext+":"); //$NON-NLS-1$ //$NON-NLS-2$
		StringBuffer taxXmlBuff = new StringBuffer();
		String taxesXmlString = ""; //$NON-NLS-1$
		try
		{
			//Building tax string
			NodeList detailList = this.detailDom.getElementsByTagName("Detail"+objContext); //$NON-NLS-1$
			for (int i = 0; i < detailList.getLength(); i++)
			{
				Node currDetail = detailList.item(i);
				if ((currDetail.getAttributes().getNamedItem("domID").getNodeValue()).equalsIgnoreCase(domID)) //$NON-NLS-1$
				{
					NodeList currDetailList = currDetail.getChildNodes();
					for (int j = 0; j < currDetailList.getLength(); j++)
					{
						Node currChild = currDetailList.item(j);
						if (currChild.getNodeName().equalsIgnoreCase("Taxes")) //$NON-NLS-1$
						{
							taxXmlBuff.append(serializeDom(currChild)).append("\n"); //$NON-NLS-1$
						}
					}
				}
			}
			taxesXmlString = taxXmlBuff.toString();
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :getAllTaxesString :==>"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		BaseLogger.log("2", userInfo,editorId, "changed all taxesXmlString.length() :[" + taxesXmlString.length() +"]"); //$NON-NLS-1$ //$NON-NLS-2$
		return taxesXmlString;
	}

	public String getTaxXMLString(String objContext, String domID)throws RemoteException,ITMException
	{
		StringBuffer taxXmlBuff = new StringBuffer();
		String taxXmlString = null;
		try
		{
			if ((!(this.objContext.equalsIgnoreCase(objContext) && this.detailDomId.equalsIgnoreCase(domID))) || (this.currTaxNode == null))
			{
				//Changed by Prasad on 02/11/16 [to search node from dbId]
				//this.currTaxNode = getCurrTaxNode(objContext, domID);
				this.currTaxNode = getCurrTaxNode(objContext, domID, "");
			}
			//Building tax string
			if (this.currTaxNode != null)
			{
				NodeList taxList = this.currTaxNode.getChildNodes();
				int taxListLength = taxList.getLength();
				for (int i = 0; i < taxListLength; i++)
				{
					taxXmlBuff.append(serializeDom(taxList.item(i)));
				}
			}
			taxXmlString = getNormalizedString(taxXmlBuff.toString());
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception:MasterStatefulEJB: getTaxXmlString :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return taxXmlString;
	}
	
	private void appendOrReplaceTaxesNode()throws ITMException
	{
		boolean found = false;
		try
		{
			String blankTaxString = this.masterDataStateful.getBlankTaxDomForAdd( this.objContext );
			if (this.currRecordNode == null)
			{
				//Changed by Prasad on 02/11/16 [to search node from dbId]
				//this.currRecordNode = searchNode(this.detailDom,this.objContext,this.detailDomId);
				this.currRecordNode = searchNode(this.detailDom,this.objContext,this.detailDomId, "");
			}
			NodeList dataNodeChildList = this.currRecordNode.getChildNodes();
			int dataNodeChildListLen = dataNodeChildList.getLength();
			for (int i=0; i < dataNodeChildListLen; i++)
			{
				if (dataNodeChildList.item(i) != null)
				{
					if (dataNodeChildList.item(i).getNodeName().equalsIgnoreCase("Taxes") ) //$NON-NLS-1$
					{
						this.currRecordNode.replaceChild( this.currRecordNode.getOwnerDocument().importNode( parseString(blankTaxString ).getFirstChild(), true ), dataNodeChildList.item( i ) );
						found = true;
						break;
					}
				}
			}
			if (!found)
			{
				this.currRecordNode.appendChild(this.currRecordNode.getOwnerDocument().importNode(parseString(blankTaxString).getFirstChild(), true));
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :TaxCalculation: removeTaxNodeInDetail :==>\n"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
	}

	//change by shrutika on 18-06-19 for perform tax calculation after copy paste records in detail.
	//private void calculateTax()throws ITMException
	//Changed By Pankaj T. on 19-08-19 As per suggested by KB sir if each_rate not define in daily_exch_rate master then throw error
	public String calculateTax()throws ITMException
	{
		String actionMode = "";
		try
		{
			BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB]CALCULATING TAX.................. "); //$NON-NLS-1$
			if(isTaxApplicable())
			{
				//Added By Pankaj T. on 17-02-2021 - added new attributes in detail tag valdatastat, taxcalcstat & id for  checking current record is valid or not at the time of adding new detail - start
				if( this.detailDom != null )
				{
					Node detailNode = searchNode(this.detailDom, this.objContext, this.detailDomId, this.currDbID);
					if( detailNode != null )
					{
						((Element) detailNode).setAttribute("taxcalcstat", "1");
					}
				}
				//Added By Pankaj T. on 17-02-2021 - added new attributes in detail tag valdatastat, taxcalcstat & id for  checking current record is valid or not at the time of adding new detail - end
				//Changed by Gulzar on 19/04/16 :Overloaded constructor created to pass connection.:START
				//TaxCalculation taxCal = new TaxCalculation( this.objName );
				TaxCalculation taxCal = new TaxCalculation( this.objName, this.dbSaveConn_doNotUse, this.userInfo );
				//Changed by Gulzar on 19/04/16 :Overloaded constructor created to pass connection.:END
				taxCal.setUpdatedTaxDom(getCurrTaxNode());

				appendOrReplaceTaxesNode();
			
				//printState("currRecordNode :\n",serializeDom(this.currRecordNode));
				this.currTaxNode = getCurrTaxNode();
				//printState("currTaxNode :\n",serializeDom(this.currTaxNode));
				
				taxCal.setTaxDom(this.currTaxNode);
				//Changed by Dhruv on 22/06/2006 to pass this.objContext, this.detailDomId to taxCal.setDataNode
				taxCal.setDataNode(this.currRecordNode, this.objContext, this.detailDomId );

				//Changed by Prasad on 02/11/16 [to search node from dbId]
				//Node currNode = searchNode(this.detailDom, "1", "1"); //$NON-NLS-1$ //$NON-NLS-2$
				Node currNode = searchNode(this.detailDom, "1", "1", ""); //$NON-NLS-1$ //$NON-NLS-2$
				//Commented By Pankaj T. on 29-07-19 as per MANOHARN Sir pass TRAN_DATE_COL column value from header as tax_date for tax calculation - start
				/*String taxDate = getValueOfField(currNode, "tax_date"); //$NON-NLS-1$
				if(taxDate == null || (taxDate != null && taxDate.length() == 0))
				{
					taxDate = getValueOfField(currNode, this.tranDateCol);
				}*/
				//Commented By Pankaj T. on 29-07-19 as per MANOHARN Sir pass TRAN_DATE_COL column value from header as tax_date for tax calculation - end
				String taxDate = getValueOfField(currNode, this.tranDateCol);
				BaseLogger.log("3", userInfo,editorId,"taxDate :["+taxDate+"]"); //$NON-NLS-1$ //$NON-NLS-2$
				
				//Changed by Manish on 09/02/2007 received string value to collect changes in deatilDam as a result of tax calculation.Start
				//Changed by Prasad on 02/11/16 [to search node from dbId]
				//String taxChgStr = taxCal.taxCalc( this.refSer, this.headerPKFieldValues, taxDate, "rate__stduom","quantity__stduom", this.rateCol, this.qtyCol, getValueOfField(searchNode( this.detailDom, "1", "1" ), "curr_code" ), this.userInfo.getSiteCode(), this.objContext ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
				//Changed by Pankaj T. on 26-04-19 add parameter editorid & action mode for write tax base calculation details in user activity - start
				actionMode = "VIEW";
				if( editFlag.equals("A") )
				{
					actionMode = "ADD";
				}
				else if( editFlag.equals("E") )
				{
					actionMode = "EDIT";
				}
				//Added By Pankaj T. on 17-02-2021 - added new attributes in detail tag valdatastat, taxcalcstat & id for  checking current record is valid or not at the time of adding new detail - start
				if( this.detailDom != null )
				{
					Node detailNode = searchNode(this.detailDom, this.objContext, this.detailDomId, this.currDbID);
					if( detailNode != null )
					{
						((Element) detailNode).setAttribute("taxcalcstat", "2");
					}
				}
				//Added By Pankaj T. on 17-02-2021 - added new attributes in detail tag valdatastat, taxcalcstat & id for  checking current record is valid or not at the time of adding new detail - end
				//Changed by Pankaj T. on 29-07-19 passed header exch_rate for tax calculation
				String taxChgStr = taxCal.taxCalc( this.refSer, this.headerPKFieldValues, taxDate, "rate__stduom","quantity__stduom", this.rateCol, this.qtyCol, getValueOfField(searchNode( this.detailDom, "1", "1", "" ), "curr_code" ), this.userInfo.getSiteCode(), this.objContext, this.userInfo.getTransDB(), this.getEditorId(), actionMode, getValueOfField( currNode, "exch_rate" ) ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
				//Changed by Pankaj T. on 26-04-19 add parameter editorid & action mode for write tax base calculation details in user activity - end
				//Changed By Pankaj T. on 19-08-19 As per suggested by KB sir if each_rate not define in daily_exch_rate master then throw error - start
				if( taxChgStr != null && taxChgStr.length() > 0  && taxChgStr.indexOf("<Errors>") != -1 )
				{
					//Added By Pankaj T. on 17-02-2021 - added new attributes in detail tag valdatastat, taxcalcstat & id for  checking current record is valid or not at the time of adding new detail - start
					if( this.detailDom != null )
					{
						Node detailNode = searchNode(this.detailDom, this.objContext, this.detailDomId, this.currDbID);
						if( detailNode != null )
						{
							((Element) detailNode).setAttribute("taxcalcstat", "3");
						}
					}
					//Added By Pankaj T. on 17-02-2021 - added new attributes in detail tag valdatastat, taxcalcstat & id for  checking current record is valid or not at the time of adding new detail - end
					return taxChgStr;
				}
				//Changed By Pankaj T. on 19-08-19 As per suggested by KB sir if each_rate not define in daily_exch_rate master then throw error - end
				else if( taxChgStr != null && taxChgStr.length() > 0  && taxChgStr.indexOf("<Errors>") == -1 )
				{
					Document chgDataDom = parseString( taxChgStr );
					if( chgDataDom.getElementsByTagName( "Root" ).item( 0 ) != null ) //$NON-NLS-1$
					{
						Node rootNode = chgDataDom.getElementsByTagName( "Root" ).item( 0 ); //$NON-NLS-1$
						NodeList chgDataNodeList = rootNode.getChildNodes();
						int noOfChgDataNodes = chgDataNodeList.getLength();
						for ( int i = 0; i < noOfChgDataNodes; i++ )
						{
							Node chgDataDetailNode = chgDataNodeList.item(i);
							String tagName = chgDataDetailNode.getNodeName();
							String formNo = null;
							String domIdStr = null;
							BaseLogger.log("3", userInfo,editorId,"tagName ["+tagName+"]"); //$NON-NLS-1$ //$NON-NLS-2$
							if ( tagName.startsWith( "Detail" ) ) //$NON-NLS-1$
							{
								formNo = ( tagName.length() > "Detail".length()) ? ( tagName.substring( "Detail".length() ) ) : "1"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
								if( ( ( NamedNodeMap )chgDataDetailNode.getAttributes() ).getNamedItem( "domID" ) != null ) //$NON-NLS-1$
								{
									domIdStr = ( ( Node )( ( NamedNodeMap )chgDataDetailNode.getAttributes() ).getNamedItem( "domID" ) ).getNodeValue(); //$NON-NLS-1$
								}
								NodeList chgColNodeList = chgDataDetailNode.getChildNodes();
								int noOfChgColNodes = chgColNodeList.getLength();
								for ( int j = 0; j < noOfChgColNodes; j++ )
								{
									Node chgColNode = chgColNodeList.item(j);
									if( chgColNode != null && chgColNode.getNodeType() == Node.ELEMENT_NODE )
									{
										this.changedDataMap.put( formNo + "_" + domIdStr + "_" + chgColNode.getNodeName() , chgColNode ); //$NON-NLS-1$ //$NON-NLS-2$
									}
								}
							}
						}
						//Added By Pankaj T. on 17-02-2021 - added new attributes in detail tag valdatastat, taxcalcstat & id for  checking current record is valid or not at the time of adding new detail - start
						if( this.detailDom != null )
						{
							Node detailNode = searchNode(this.detailDom, this.objContext, this.detailDomId, this.currDbID);
							if( detailNode != null )
							{
								((Element) detailNode).setAttribute("taxcalcstat", "4");
							}
						}
						//Added By Pankaj T. on 17-02-2021 - added new attributes in detail tag valdatastat, taxcalcstat & id for  checking current record is valid or not at the time of adding new detail - end
					}
				}
				//Changed by Manish on 09/02/2007 received string value to collect changes in deatilDam as a result of tax calculation.End
				
				this.currTaxNode = getCurrTaxNode();
				//BaseLogger.log("3", userInfo,editorId,"After calculating tax  Curr Tax Node:\n\n"+serializeDom(this.currTaxNode));
				BaseLogger.log("3", userInfo,editorId,"\n\n\n\n\n\n\n"); //$NON-NLS-1$
				
				//printState("Final : currTaxNode :\n",serializeDom(this.currTaxNode));
				//printState("Final : currRecordNode :\n",serializeDom(this.currRecordNode));
				this.isTaxChanged = true;
			}

		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception : MAsterStatefulEJB : calculateTax :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return "";
	}
	
	private String applyTaxPercToAllDetail(String changeTaxXmlString) throws ITMException
	{
		String taxChangeStr = "";
		try
		{
			BaseLogger.log("3", userInfo,editorId,"this.detailDomId ["+this.detailDomId+"]");
			if( "1".equalsIgnoreCase(this.detailDomId ))
			{
				NodeList detailNodeList = this.detailDom.getElementsByTagName("Detail"+this.objContext);
				int detailNodeListLen = detailNodeList.getLength();
				BaseLogger.log("3", userInfo,editorId,"applyToAllTaxPerc detailNodeListLen ["+detailNodeListLen+"]");
				HashMap taxCodeNPercMap = new HashMap();
				for( int detCtr = 0; detCtr < detailNodeListLen; detCtr++ )
				{
					String nextDomID = detailNodeList.item( detCtr ).getAttributes().getNamedItem( "domID" ).getNodeValue();
					//Added by Prasad on 02/11/16 [to search node from dbId]
					String dbID = detailNodeList.item( detCtr ).getAttributes().getNamedItem( "dbID" ).getNodeValue();
					BaseLogger.log("3", userInfo,editorId,"nextDomID ["+nextDomID+"]");
					if( nextDomID != null && ( ! "1".equalsIgnoreCase( nextDomID.trim() ) ) )
					{
						//Changed by Prasad on 02/11/16 [to search node from dbId]
						//Node taxNode = getCurrTaxNode( this.objContext, nextDomID  );
						Node taxNode = getCurrTaxNode( this.objContext, nextDomID, dbID  );
						if( taxNode != null )
						{
							BaseLogger.log("3", userInfo,editorId,"taxCodeNPercMap ["+taxCodeNPercMap+"]");
							boolean isTaxPercChange = applyTaxPercInTaxNode( taxCodeNPercMap, taxNode);
							if( isTaxPercChange )
							{
								//Changed by Prasad on 02/11/16 [to search node from dbId]
								//Node recordNode = searchNode( this.detailDom, this.objContext, nextDomID );
								Node recordNode = searchNode( this.detailDom, this.objContext, nextDomID, dbID );
								ReCalculateTax reCalTax1 = new ReCalculateTax();
								setRateNQtyCol();
								reCalTax1.setTaxTranDom( recordNode, taxNode, this.objContext, nextDomID);
								//Changed by Pankaj T on 04-01-18 [changes for multitenancy]
								//Changed By Pankaj T. on 09-06-19 for passed curr_code to tax calculation from transaction header
								//Changed By Pankaj T. on 17-09-19 for on recalculate get exchange rate from master instead of current dom - start
								Node currNode = searchNode(this.detailDom, "1", "1", "");
								String taxDate = getValueOfField(currNode, this.tranDateCol);
								taxChangeStr = reCalTax1.reCalculate( this.rateCol, this.qtyCol, this.userInfo,getValueOfField(searchNode( this.detailDom, "1", "1", "" ), "curr_code" ), this.refSer, taxDate );
								//Changed By Pankaj T. on 17-09-19 for on recalculate get exchange rate from master instead of current dom - end
								NodeList nodeList = recordNode.getChildNodes();
								int detailNodesLen = nodeList.getLength();
								for (int i = 0; i < detailNodesLen; i++ )
								{
									Node colNode = nodeList.item(i);
									String nodeName = colNode.getNodeName();
									BaseLogger.log("3", userInfo,editorId,"nodeName ["+nodeName+"]"); //$NON-NLS-1$ //$NON-NLS-2$
									if ( "attribute".equals( nodeName ) ) //Changed by Danish on 12/02/2007 End //$NON-NLS-1$
									{
										String updFlag = ((colNode.getAttributes()).getNamedItem("updateFlag")).getNodeValue(); //$NON-NLS-1$
										((colNode.getAttributes()).getNamedItem("updateFlag")).setNodeValue("E");
										break;
									}
								}
								reCalTax1 = null;
								
								//Changed by Danish 
								BaseLogger.log("3", userInfo,editorId,"Called for record Node...");
								//Changed by Prasad on 02/11/16 [to search node from dbId]
								//crossUpdateDeailNode( this.objContext, nextDomID, this.detailDom );
								crossUpdateDeailNode( this.objContext, nextDomID, this.detailDom, dbID );
							}
						}
					}
					else
					{
						taxCodeNPercMap = createTaxCodeNPercMap( changeTaxXmlString );
					}
				}
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception : MasterStatefulEJB : recalculateTax :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return taxChangeStr;
	}
	
	private HashMap createTaxCodeNPercMap( String changeTaxXmlString )
	{
		HashMap taxCodeNPercMap = new HashMap();
		try
		{
			BaseLogger.log("3", userInfo,editorId,"changeTaxXmlString ["+changeTaxXmlString+"]");
			Document chgTaxDom = parseString( changeTaxXmlString );
			NodeList chgTaxDomeNodeList = chgTaxDom.getElementsByTagName("Detail"+this.objContext );
			int chgTaxDomeNodeListLength = chgTaxDomeNodeList.getLength();
			BaseLogger.log("3", userInfo,editorId," createTaxCodeNPercMap : tempTaxNodeLen ["+chgTaxDomeNodeListLength+"]");
			for( int taxNodeCtr = 0; taxNodeCtr < chgTaxDomeNodeListLength; taxNodeCtr++ )
			{
				Node currentTaxNode = chgTaxDomeNodeList.item( taxNodeCtr );
				BaseLogger.log("3", userInfo,editorId,"currentTaxNode.getNodeName() ["+currentTaxNode.getNodeName()+"]");
				
				NodeList currentNodeList = currentTaxNode.getChildNodes();
				int currNodeLen =  currentNodeList.getLength();
				BaseLogger.log("3", userInfo,editorId, "createTaxCodeNPercMap : currNodeLen ["+currNodeLen+"]" );
				String taxRecTaxCode = "";
				String taxCode = "";
				String taxPerc = "";
				int bothFound = 0;
				for( int currentNodeCtr = 0; currentNodeCtr < currNodeLen; currentNodeCtr++ )
				{
					Node currentNode = currentNodeList.item( currentNodeCtr );
					if( "tax_code".equalsIgnoreCase( currentNode.getNodeName() ) )
					{
						if( currentNode.getFirstChild() != null )
						{
							taxCode = currentNode.getFirstChild().getNodeValue();
						}
						else
						{
							taxCode = currentNode.getNodeValue();
						}
						bothFound++;
						BaseLogger.log("3", userInfo,editorId, " taxCode ["+taxCode+"] bothFound ["+bothFound+"]" );
					}
					if( "tax_perc".equalsIgnoreCase( currentNode.getNodeName() ) )
					{
						if( currentNode.getFirstChild() != null )
						{
							taxPerc = currentNode.getFirstChild().getNodeValue();
						}
						else
						{
							taxPerc = currentNode.getNodeValue();
						}
						bothFound++;
						BaseLogger.log("3", userInfo,editorId, " taxPerc ["+taxPerc+"] bothFound ["+bothFound+"]" );
					}
					if( bothFound == 2 )
					{
						taxCodeNPercMap.put(taxCode.trim(), taxPerc.trim());
						break;
					}
				}
			}
		}
		catch (Exception e) 
		{
			e.printStackTrace();
		}
		return taxCodeNPercMap;
	}
	
	private boolean applyTaxPercInTaxNode( HashMap taxCodeNPercMap, Node currentDomTaxNode) throws ITMException
	{
		boolean isTaxPercChange = false;
		try
		{
			NodeList currentTaxNodeList = currentDomTaxNode.getChildNodes();
			int currentTaxNodeLength = currentTaxNodeList.getLength();
			BaseLogger.log("3", userInfo,editorId," tempTaxNodeLen ["+currentTaxNodeLength+"]");
			for( int taxNodeCtr = 0; taxNodeCtr < currentTaxNodeLength; taxNodeCtr++ )
			{
				Node currentTaxNode = currentTaxNodeList.item( taxNodeCtr );
				if( "Tax".equalsIgnoreCase( currentTaxNode.getNodeName() ))
				{
					NodeList currentNodeList = currentTaxNode.getChildNodes();
					int currNodeLen =  currentNodeList.getLength();
					BaseLogger.log("3", userInfo,editorId, "currNodeLen ["+currNodeLen+"]" );
					String taxRecTaxCode = ""; 
					for( int currentNodeCtr = 0; currentNodeCtr < currNodeLen; currentNodeCtr++ )
					{
						if( "tax_code".equalsIgnoreCase( currentNodeList.item( currentNodeCtr ).getNodeName() ) )
						{
							if( currentNodeList.item( currentNodeCtr ).getFirstChild() != null )
							{
								taxRecTaxCode = currentNodeList.item( currentNodeCtr ).getFirstChild().getNodeValue();
							}
							else
							{
								taxRecTaxCode = currentNodeList.item( currentNodeCtr ).getNodeValue();
							}
							break;
						}
					}
					for( int currentNodeCtr = 0; currentNodeCtr < currNodeLen; currentNodeCtr++ )
					{
						if( "tax_perc".equalsIgnoreCase( currentNodeList.item( currentNodeCtr ).getNodeName() ) )
						{
							String changedTaxPerc = ( String ) taxCodeNPercMap.get( taxRecTaxCode.trim() );
							if( changedTaxPerc != null && changedTaxPerc.trim().length() > 0 )
							{
								if( currentNodeList.item( currentNodeCtr ).getFirstChild() != null )
								{
									BaseLogger.log("3", userInfo,editorId,"setting  YES FIRST CHILD tax_perc ["+changedTaxPerc+"] ");
									currentNodeList.item( currentNodeCtr ).getFirstChild().setNodeValue( changedTaxPerc );
								}
								else
								{
									BaseLogger.log("3", userInfo,editorId,"setting  NO  tax_perc ["+changedTaxPerc+"] ");
									currentNodeList.item( currentNodeCtr ).setNodeValue( changedTaxPerc );
									if( currentNodeList.item( currentNodeCtr ).getNodeValue() == null  )
									{
										BaseLogger.log("3", userInfo,editorId,"setting  With CDATA ");
										CDATASection cDataSection = this.detailDom.createCDATASection( changedTaxPerc );
										currentNodeList.item( currentNodeCtr ).appendChild( cDataSection );
									}
								}
								isTaxPercChange = true;
								break;
							}
						}
					}//for( int currentNodeCtr = 0; currentNodeCtr < currNodeLen; currentNodeCtr++ )
				}//if( "Tax".equalsIgnoreCase( currentTaxNode.getNodeName() ))
			}//for( int taxNodeCtr = 0; taxNodeCtr < currentTaxNodeLength; taxNodeCtr++ )
		}
		catch( Exception e )
		{
			throw new ITMException( e);
		}
		return isTaxPercChange;
	}
	
	private String recalculateTax()throws ITMException
	{
		
		String taxChangeStr = "" ; //$NON-NLS-1$
		try
		{
			setRateNQtyCol();
			ReCalculateTax reCalTax = new ReCalculateTax();
			if ( this.currTaxNode == null )
			{
				//Changed by Prasad on 02/11/16 [to search node from dbId]
				//this.currTaxNode = getCurrTaxNode( this.objContext, this.detailDomId );
				this.currTaxNode = getCurrTaxNode( this.objContext, this.detailDomId, "" );
			}
			//Changed by Dhruv on 22/06/2006 to pass this.objContext, this.detailDomId to reCalTax.setTaxTranDom
			reCalTax.setTaxTranDom( this.currRecordNode, this.currTaxNode, this.objContext, this.detailDomId );
			
			//Changed by Dhruv on 209/04/2007 to pass this.rateCol, this.qtyCol as the dynamic values instead of the previous hardcoded values.
			//Changed by Pankaj T on 04-01-18 [changes for multitenancy]
			//Changed By Pankaj T. on 09-06-19 for passed curr_code to tax calculation from transaction header
			//Changed By Pankaj T. on 17-09-19 for on recalculate get exchange rate from master instead of current dom - start
			Node currNode = searchNode(this.detailDom, "1", "1", "");
			String taxDate = getValueOfField(currNode, this.tranDateCol);
			taxChangeStr = reCalTax.reCalculate( this.rateCol, this.qtyCol, this.userInfo, getValueOfField(searchNode( this.detailDom, "1", "1", "" ), "curr_code" ), this.refSer, taxDate );
			//Changed By Pankaj T. on 17-09-19 for on recalculate get exchange rate from master instead of current dom - end
			this.isTaxChanged = true;
			/*
			BaseLogger.log("3", userInfo,editorId, "taxChangeStr :["+taxChangeStr+"]" );
			crossUpdate( this.objContext, this.detailDom );
			Document taxChangeDom = ( taxChangeStr != null && taxChangeStr.length() > 0 ) ? parseString( taxChangeStr ) : null;	
			String crossUpdateChangeRetValue = getChangedXMLString();
			BaseLogger.log("3", userInfo,editorId, "crossUpdateChangeRetValue :[" + crossUpdateChangeRetValue + "]" );
			if( crossUpdateChangeRetValue.indexOf( "Errors" ) == -1 )
			{
				Document crossUpdateChangeRetDom = ( crossUpdateChangeRetValue != null && crossUpdateChangeRetValue.length() > 0 ) ? parseString( crossUpdateChangeRetValue ) : null;	
				if( taxChangeDom != null && crossUpdateChangeRetDom != null )
				{
					Node taxChangeDomRootNode = taxChangeDom.getElementsByTagName( "Root" ).item( 0 );
					Node crossUpdateChangeRootNode = crossUpdateChangeRetDom.getElementsByTagName( "Root" ).item( 0 );
					int ctr = 0;
					Node currChgDetailNode = null;
					while( ( currChgDetailNode = ( crossUpdateChangeRootNode.getChildNodes() ).item( ctr ) ) != null )
					{
						if( currChgDetailNode.getNodeType() == Node.ELEMENT_NODE && currChgDetailNode.getNodeName().startsWith( "Detail" ) )
						{
							taxChangeDomRootNode.appendChild( taxChangeDomRootNode.getOwnerDocument().importNode( currChgDetailNode, true ) );
						}
						ctr++;
					}//while( ( currChgDetailNode = ( crossUpdateChangeRootNode.getChildNodes() ).item( ctr ) ) != null )
				}//if( taxChangeDom != null && crossUpdateChangeRetDom != null )
			}//if( crossUpdateChangeRetValue.indexOf( "Errors" ) == -1 )
			*/
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception : MasterStatefulEJB : recalculateTax :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return taxChangeStr;
	}
	
	private boolean isTaxApplicable()throws Exception
	{
		Node taxEditNode = null;
		boolean isApplicable = false;
		String taxEnvStr = null;
		if(this.taxList != null && !this.taxList.contains("N") && this.taxList.contains(this.objContext)) //$NON-NLS-1$
		{
			//Changed By Danish on 19/08/2006 reason [to get the exact node]
			//taxEditNode = this.detailDom.getElementsByTagName("Detail" +objContext).item(0);
			//Changed by Prasad on 02/11/16 [to search node from dbId]
			//taxEditNode = searchNode( this.detailDom, this.objContext, ( ( Integer.parseInt(this.objContext.trim()) == 1) ? this.headerDomId : this.detailDomId ) );
			taxEditNode = searchNode( this.detailDom, this.objContext, ( ( Integer.parseInt(this.objContext.trim()) == 1) ? this.headerDomId : this.detailDomId ), "" );
			if (taxEditNode != null)
			{
				NodeList currTaxList = taxEditNode.getChildNodes();
				int len = currTaxList.getLength();
				for(int ctr = 0 ;ctr<len; ctr++)
				{
					Node taxNode = currTaxList.item(ctr);
					if(taxNode.getNodeName().equalsIgnoreCase("tax_env"))  //$NON-NLS-1$
					{
						isApplicable = true;
					}
				}
			}
		}
		return isApplicable;
	}

	private ArrayList getXMLStrKeyFlagList(String xmlStrKeyVal, String delimiter) throws ITMException
	{
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]Getting keyVal arraylist from the string :"+xmlStrKeyVal+": delimiter :"+delimiter+":"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		ArrayList returnList = new ArrayList();
		try
		{
			if (xmlStrKeyVal != null && xmlStrKeyVal.length() > 0 && xmlStrKeyVal !="") //$NON-NLS-1$
			{
				while (xmlStrKeyVal.indexOf(delimiter) != -1)
				{
					int endIndex = xmlStrKeyVal.indexOf(delimiter);
					returnList.add(xmlStrKeyVal.substring(0, endIndex));
					xmlStrKeyVal = xmlStrKeyVal.substring(endIndex + 1, xmlStrKeyVal.length());
				}
				returnList.add(xmlStrKeyVal.substring(0, xmlStrKeyVal.length()));
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception : MasterStatefulEJB : getXMLStrKeyFlagList :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		//BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB]Returning from getXMLStrKeyFlagList : returnList :"+returnList);
		return returnList;
	}

	private void appendToDom(Document tempParentDom, Document tempChildDom, String childObjContext)throws ITMException
    {
		try
		{
			NodeList oriHeaderList  = tempParentDom.getElementsByTagName("Header0"); //$NON-NLS-1$
			Node node = oriHeaderList.item(0);

			NodeList newDetailList = tempChildDom.getElementsByTagName("Detail"+childObjContext); //$NON-NLS-1$
			int len = newDetailList.getLength();
			for (int j = 0; j < len; j++)
			{
				Node nDetail = newDetailList.item(j);
				Node importedNode = tempParentDom.importNode(nDetail, true);
				oriHeaderList.item(0).appendChild(importedNode);
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception : MasterStatefulEJB : appendToDom :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		} 
	}

	//Changed by Prasad on 02/11/16 [to search node from dbId]
	//private Node searchNode( Document dom, String objContext, String nodeID )throws ITMException
	//Change by shrutika on 20-12-18 for perform itemchange one by one field in copy paste functionality.
	//private Node searchNode( Document dom, String objContext, String nodeID, String dbId )throws ITMException
	public Node searchNode( Document dom, String objContext, String nodeID, String dbId )throws ITMException
	{
		BaseLogger.log("2", userInfo,editorId,"searchNode : objContext :["+objContext+"], nodeID :["+nodeID+"], dbId :["+ dbId +"]");
		Node detailNode = null;
		try
		{
			objContext = ( objContext == null || objContext.length() == 0 ) ? "1" : objContext; //$NON-NLS-1$
			nodeID = ( nodeID == null || nodeID.length() == 0 ) ? "1" : nodeID; //$NON-NLS-1$
			//Added by Prasad on 02/11/16 [to search node from dbId]
			dbId = ( dbId == null || dbId.length() == 0 ) ? "" : dbId;
			BaseLogger.log("3", userInfo,editorId,"searchNode : objContext :["+objContext+"], nodeID :["+nodeID+"], dbId :["+ dbId +"], dom :["+dom+"]");
		   //change by shrutika on 19-12-2020 for Exception in application start
			NodeList detailList = null;
			int detListLength = 0;
			if( dom != null )
			{
				detailList = dom.getElementsByTagName("Detail" + objContext); //$NON-NLS-1$
				detListLength = detailList.getLength();
			}
			//change by shrutika on 19-12-2020 for Exception in application end
			//Added By Pankaj T. on 17-02-2021 - added new attributes in detail tag valdatastat, taxcalcstat & id for  checking current record is valid or not at the time of adding new detail - start
			if( dom != null )
			{
				try
				{
					String headerPKValues = "";
					if( this.headerPKFieldValues != null && (this.headerPKFieldValues.lastIndexOf(":") == this.headerPKFieldValues.length() - 1) )
					{
						headerPKValues = this.headerPKFieldValues.substring(0, this.headerPKFieldValues.lastIndexOf(":"));
					}
					String id = objContext + ":" + nodeID + ":" + headerPKValues;
					BaseLogger.log("3", userInfo,editorId,"Inside MasterStatefulEJB.searchNode()  detailNode id : [" + id +"]");
					XPathFactory xpf = XPathFactory.newInstance();
					XPath xpath = xpf.newXPath();
					XPathExpression expression = xpath.compile( "//Detail"+objContext+"[@id='"+id+"']" );
					detailNode = (Node) expression.evaluate( dom, XPathConstants.NODE );
				}
				catch (Exception e) 
				{
					BaseLogger.log("3", userInfo,editorId,"Inside MasterStatefulEJB.searchNode() Exception in xpath : ["+E12GenericUtility.getStackTrace(e)+"]");
				}
			}
			//Added By Pankaj T. on 17-02-2021 - added new attributes in detail tag valdatastat, taxcalcstat & id for  checking current record is valid or not at the time of adding new detail - end
			//Changed by Prasad on 02/11/16 [to search node from dbId]
	        if( detailNode == null && dbId.length() > 0 && ! this.editFlag.equalsIgnoreCase( "A" ) )
			{
				for(int ctr = 0; ctr < detListLength; ctr++)
				{
					Node curDetail = detailList.item(ctr);
					//Added by Prasad on 11/04/17 [remove empty space of dbId to compare] START
					String nodeDbId = curDetail.getAttributes().getNamedItem("dbID").getNodeValue();
					nodeDbId = nodeDbId.replaceAll( "\\s", "" );
					dbId = dbId.replaceAll( "\\s", "" );
					BaseLogger.log("3", userInfo,editorId, "nodeDbId - ["+ nodeDbId +"], dbId - ["+ dbId +"]" );
					//if ( curDetail.getAttributes().getNamedItem("dbID").getNodeValue().equalsIgnoreCase( dbId ) )
					if ( nodeDbId.equals( dbId ) )
					//Added by Prasad on 11/04/17 [remove empty space of dbId to compare] END
					{
						detailNode = curDetail;
						break;
					}
					else
					{
						continue;
					}
				}
			}
			else
			{
				for(int ctr = 0; ctr < detListLength; ctr++)
				{
					Node curDetail = detailList.item(ctr);
					if( curDetail.getAttributes().getNamedItem("domID").getNodeValue().equalsIgnoreCase( nodeID ) ) //$NON-NLS-1$
					{
						detailNode = curDetail;
						break;
					}
					else
					{
						continue;
					}
				}
			}
			//Changed by Prasad on 02/11/16 [to search node from dbId] END
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception : MasterStatefulEJB : searchNode :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return detailNode;
	}

	private NodeList searchNodes(Document dom, String objContext) throws ITMException
	{
		NodeList detailList = null;
		try
		{
			objContext = (objContext == null)?"1" : objContext; //$NON-NLS-1$
			detailList = dom.getElementsByTagName("Detail" + objContext);	 //$NON-NLS-1$
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception : MasterStatefulEJB : searchNodes :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return detailList;
	}

	private Document parseString(String xmlString)throws ITMException
	{
		Document dom = null;
		try
		{
			//Changed by Monif on 2/23/2009 [For special char parsing issue].Start
			E12GenericUtility genericUtility = new E12GenericUtility();
			xmlString = genericUtility.setXmlDec( xmlString );			
			//Changed by Monif on 2/23/2009 [For special char parsing issue].End	
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			dbf.setNamespaceAware(true);
			dbf.setIgnoringComments(true);
			DocumentBuilder db = dbf.newDocumentBuilder();
			//Changed by Dayanand 28/01/2011[SY01SUN026 - Special character "�" is not get save in Remarks field]
			//OutputStreamWriter errorWriter =   new OutputStreamWriter(System.err, this.userInfo.getCharEnc() );
			OutputStreamWriter errorWriter =   new OutputStreamWriter(System.err, CommonConstants.ENCODING );
			//Changed by Monif on 24/04/08 [TO support Character encoding while uploading].start
			//ByteArrayInputStream baos = new ByteArrayInputStream(xmlString.getBytes());
			//Changed by Dayanand 28/01/2011[SY01SUN026 - Special character "�" is not get save in Remarks field]
			//ByteArrayInputStream baos = new ByteArrayInputStream(xmlString.getBytes( this.userInfo.getCharEnc() ));
			ByteArrayInputStream baos = new ByteArrayInputStream(xmlString.getBytes(CommonConstants.ENCODING));
			//Changed by Monif on 24/04/08 [TO support Character encoding while uploading].End
			dom = db.parse(baos);
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception : MasterStatefulEJB : parseString :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return dom;
	}

	private String serializeDom(Node dom)throws ITMException
	{
		String retString = null;
		try
		{
			ByteArrayOutputStream out = new ByteArrayOutputStream();
			Transformer serializer = TransformerFactory.newInstance().newTransformer();

			//Changed by Manish on 23/01/2007 to omit xml version tag if serailized dom is an element node and not a document.
			if( dom.getNodeType() == Node.ELEMENT_NODE )
			{
				serializer.setOutputProperty( OutputKeys.OMIT_XML_DECLARATION, "yes" ); //$NON-NLS-1$
			}
			//Changed by Dayanand 28/01/2011[SY01SUN026 - Special character "�" is not get save in Remarks field]
			//serializer.setOutputProperty(OutputKeys.ENCODING, this.userInfo.getCharEnc() );
			serializer.setOutputProperty(OutputKeys.ENCODING, CommonConstants.ENCODING );
			serializer.transform(new DOMSource(dom), new javax.xml.transform.stream.StreamResult(out));
			retString = out.toString(CommonConstants.ENCODING);
			out.flush();
			out.close();
			out = null;
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception : MasterStatefulEJB : serializeDom :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return retString;
	}

	private String getNormalizedString(String nodeString)throws ITMException
	{
		StringBuffer tempStringBuff = new StringBuffer();
		try
		{
			//Changed by Manish on 09/02/2007 as the evrsion tag is getting added twice.
			//tempStringBuff.append("<?xml version='1.0' encoding='"+this.userInfo.getCharEnc()+"' ?>");//Manish
			//Added for issue while getting data header tag already exist
			if( nodeString != null && nodeString.indexOf("<DocumentRoot>") == -1)
			{
				tempStringBuff.append("<DocumentRoot>"); //$NON-NLS-1$
				tempStringBuff.append("<description>Datawindow Root</description>"); //$NON-NLS-1$
				tempStringBuff.append("<group0>"); //$NON-NLS-1$
				tempStringBuff.append("<description>Group0 description</description>"); //$NON-NLS-1$
				tempStringBuff.append("<Header0>"); //$NON-NLS-1$
				tempStringBuff.append("<description>Header0 members</description>"); //$NON-NLS-1$
	
				tempStringBuff.append(nodeString);
	
				tempStringBuff.append("</Header0>"); //$NON-NLS-1$
				tempStringBuff.append("</group0>"); //$NON-NLS-1$
				tempStringBuff.append("</DocumentRoot>"); //$NON-NLS-1$
			}
			else
			{
				tempStringBuff.append(nodeString);
			}
			
		}
		catch (Exception e)
 		{
 			throw new ITMException(e);
 		}
		return tempStringBuff.toString();
	}

	private String getDeNormalizedString(String nodeString)throws ITMException
	{
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]Denormalizing XML string......................."); //$NON-NLS-1$
		StringBuffer deNormalizedStringBuff = null;
		try
		{
			Document tempDom = parseString(nodeString);
			Node headerNode = tempDom.getElementsByTagName("Header0").item(0); //$NON-NLS-1$
			NodeList headerChildList = headerNode.getChildNodes();

			int noOfDetails = headerChildList.getLength();
			if(noOfDetails > 0)
			{
				deNormalizedStringBuff = new StringBuffer();
			}
			Node currDetailNode = null;
			for(int ctr = 1; ctr < noOfDetails; ctr++)
			{
				currDetailNode = headerChildList.item(ctr);
				deNormalizedStringBuff.append(serializeDom(currDetailNode));
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception : MasterStatefulEJB : getDeNormalizedString :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return deNormalizedStringBuff.toString();
	}

	private String addSortTags(String browXMLString, String colName, String order, String dataType)
	{
		try
		{
			if(browXMLString != null && browXMLString.length() > 0)
			{
				colName = (colName != null && !colName.equalsIgnoreCase("null") && colName.length() > 0)?colName:""; //$NON-NLS-1$ //$NON-NLS-2$
				order = ((order != null && !order.equalsIgnoreCase("null") && order.length() > 0) && order.equalsIgnoreCase("ascending"))?"descending":"ascending"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				dataType = (dataType != null && !dataType.equalsIgnoreCase("null") && dataType.length() > 0)?dataType:"text"; //$NON-NLS-1$ //$NON-NLS-2$
				BaseLogger.log("3", userInfo,editorId,"Adding Sort Tags colName :["+ colName + "]order :[" + order + "]dataType :[" + dataType + "]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				Document tempBrowDom = parseString(browXMLString);
				Element n1 = tempBrowDom.createElement("col_name"); //$NON-NLS-1$
				Element n2 = tempBrowDom.createElement("order"); //$NON-NLS-1$
				Element n3 = tempBrowDom.createElement("datatype"); //$NON-NLS-1$
				
				n1.appendChild(tempBrowDom.createTextNode(colName));
				n2.appendChild(tempBrowDom.createTextNode(order));
				n3.appendChild(tempBrowDom.createTextNode(dataType));
				(tempBrowDom.getFirstChild()).insertBefore(n3,(tempBrowDom.getFirstChild()).getFirstChild());
				(tempBrowDom.getFirstChild()).insertBefore(n2,(tempBrowDom.getFirstChild()).getFirstChild());
				(tempBrowDom.getFirstChild()).insertBefore(n1,(tempBrowDom.getFirstChild()).getFirstChild());
				browXMLString = serializeDom(tempBrowDom);
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception : MasterStatefulEJB : addSortTags :"+e); //$NON-NLS-1$
		}
		return browXMLString;
	}

	private String genericTransform(String xsl, String xml)throws ITMException
	{
		ByteArrayOutputStream bos = new ByteArrayOutputStream();
		try
		{
			TransformerFactory tFactory = TransformerFactory.newInstance();
			Transformer transformer = tFactory.newTransformer(new StreamSource(new ByteArrayInputStream(xsl.getBytes())));
			transformer.transform(new StreamSource(new ByteArrayInputStream(xml.getBytes( CommonConstants.ENCODING ))), new StreamResult(bos));
			return bos.toString(CommonConstants.ENCODING);
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception : MasterStatefulEJB : genericTransform :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		
	}
	
	private DWObject getDWObject(String objName, int formNo) throws ITMException
	{
		DWObject dwObject = null;
		try
		{
			//Added by Prasad on 09/04/18 [to resolve null objName related issue] START
			if ( objName == null || objName.trim().length() == 0 )
			{
				throw new ITMException( new Exception( "objName is null" ) );
			}
			//Added by Prasad on 09/04/18 [to resolve null objName related issue] END
			//Added by Prasad on 17/03/18 [formName implementation in transaction editor]
			String formName = getFormName( ""+ formNo );
			String metaDataFileName = objName + "2" + formName; //$NON-NLS-1$
			//Changes By Ajinkya Gopalkar on 4-Apr-17
//			DWFactory dws = DWFactory.getDWFactory();
			DWFactory dws = new DWFactory(userInfo);
			dwObject = (DWObject)dws.getDataWindow(metaDataFileName);	
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception : MasterStatefulEJB : getDWObject :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return dwObject;
	}

	private String getValidDateString(String dateStr, String sourceDateFormat, String targetDateFormat) throws ITMException
	{
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]Converting dateStr :["+dateStr+"] From format :["+sourceDateFormat +"] To Format :["+targetDateFormat+"]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
		Object date = null;
		String retDateStr = ""; //$NON-NLS-1$
		try
		{
			if (!(sourceDateFormat.equalsIgnoreCase(targetDateFormat)))
			{
				if (sourceDateFormat.indexOf("/") != -1) //$NON-NLS-1$
				{
					dateStr.replace('/', '-');
				}
				else if (sourceDateFormat.indexOf(".") != -1) //$NON-NLS-1$
				{
					dateStr.replace('.', '-');
				}

				date = new SimpleDateFormat(sourceDateFormat).parse(dateStr);
				SimpleDateFormat sdfOutput = new SimpleDateFormat(targetDateFormat);
				retDateStr = sdfOutput.format(date);
			}
			else
			{
				retDateStr = dateStr;
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :getValidDateString :==>"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]Converted Datestr :["+retDateStr+"]"); //$NON-NLS-1$ //$NON-NLS-2$
		return retDateStr;
	}

	private String getDispDateFormat()throws ITMException,Exception
	{
		String dateFormatStr = null;
		try
		{
			//Commented and changed by Nilesh on 18-07-2017 : START
			//Instead of using local method GenericUtility method is used to resolve too many file open issue reported @franco
			/*
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			DocumentBuilder db = dbf.newDocumentBuilder();
			
			//Changed by Swapnil Shirke on 18-Aug-2010 [ SY90SUN004 ] To support multiple database connection through single JBoss.
			//Document doc = db.parse(".." + File.separator + "setting" + File.separator + "DateFormat.xml");
			Document doc = db.parse(CommonConstants.APPLICATION_CONTEXT + File.separator + "setting" + File.separator + "DateFormat.xml"); //$NON-NLS-1$ //$NON-NLS-2$
			NodeList nlDateFormat = doc.getElementsByTagName("DISP_DATE_FORMAT"); //$NON-NLS-1$
			Node ndDateFormat = nlDateFormat.item(0);
			dateFormatStr = ndDateFormat.getFirstChild().getNodeValue();
			*/
			E12GenericUtility genericUtility = new E12GenericUtility();
			dateFormatStr = genericUtility.getDispDateFormat();
			//Commented and changed by Nilesh on 18-07-2017 : END
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :getDispDateFormat :==>\n"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return dateFormatStr;
	}
	
	private String getApplDateFormat()throws ITMException,Exception
	{
		String dateFormatStr = null;
		try
		{
			//Commented and changed by Nilesh on 18-07-2017 : START
			//Instead of using local method GenericUtility method is used to resolve too many file open issue reported @franco
			/*
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			DocumentBuilder db = dbf.newDocumentBuilder();
			
			//Changed by Swapnil Shirke on 18-Aug-2010 [ SY90SUN004 ] To support multiple database connection through single JBoss.
			//Document doc = db.parse(".." + File.separator + "setting" + File.separator + "DateFormat.xml");
			Document doc = db.parse(CommonConstants.APPLICATION_CONTEXT + File.separator + "setting" + File.separator + "DateFormat.xml"); //$NON-NLS-1$ //$NON-NLS-2$
			NodeList nlDateFormat = doc.getElementsByTagName("APPL_DATE_FORMAT"); //$NON-NLS-1$
			Node ndDateFormat = nlDateFormat.item(0);
			dateFormatStr = ndDateFormat.getFirstChild().getNodeValue();
			*/
			E12GenericUtility genericUtility = new E12GenericUtility();
			dateFormatStr = genericUtility.getApplDateFormat();
			//Commented and changed by Nilesh on 18-07-2017 : END
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :DB2XMLGenerator :getApplDateFormat :==>\n"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return dateFormatStr;
	}

	private String getDBDateFormat()throws ITMException,Exception
	{
		String dateFormatStr = null;
		try
		{
			//Commented and changed by Nilesh on 18-07-2017 : START
			//Instead of using local method GenericUtility method is used to resolve too many file open issue reported @franco
			/*
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			DocumentBuilder db = dbf.newDocumentBuilder();
			
			//Changed by Swapnil Shirke on 18-Aug-2010 [ SY90SUN004 ] To support multiple database connection through single JBoss.
			//Document doc = db.parse(".." + File.separator + "setting" + File.separator + "DateFormat.xml");
			Document doc = db.parse(CommonConstants.APPLICATION_CONTEXT + File.separator + "setting" + File.separator + "DateFormat.xml"); //$NON-NLS-1$ //$NON-NLS-2$
			NodeList nlDateFormat = doc.getElementsByTagName("DB_DATE_FORMAT"); //$NON-NLS-1$
			Node ndDateFormat = nlDateFormat.item(0);
			dateFormatStr = ndDateFormat.getFirstChild().getNodeValue();
			*/
			E12GenericUtility genericUtility = new E12GenericUtility();
			dateFormatStr = genericUtility.getDBDateFormat();
			//Commented and changed by Nilesh on 18-07-2017 : END
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :DB2XMLGenerator :getDBDateFormat :==>\n"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return dateFormatStr;
	}

	public String executeConfirm(String xmlStr) throws RemoteException,ITMException
	{
		Date startTime = new Date();
		String wsReturnValue=""; //$NON-NLS-1$
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]Calling Confirmation Event with  :\n"+xmlStr); //$NON-NLS-1$
		try
	    {
			BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB]Invoking Confirmation event..........."); //$NON-NLS-1$
			this.eventManager.setUserInfo(this.userInfo);//Added by vinayak on 17-Jun-2016 to set the userInfo
			//Changed by Monif on 11/17/2008 [To make eventManager object as Local [As per KB.]
			//wsReturnValue = this.eventManager.executeSystemEvent(this.objName, "pre_confirm", currentEventContext, parseString(xmlStr), this.detailDom, getXtraParams(), ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId));
			//Changed by Monif on 6/2/2009 [Reverting Back [As per KB.]
			//wsReturnValue = getEventManager().executeSystemEvent(this.objName, "pre_confirm", currentEventContext, parseString(xmlStr), this.detailDom, getXtraParams(), ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId));
			//Changed by Shahu mali on 10-10-13.[WS3GBAS001] for multiDB connection ; START
			String transDB = this.userInfo.getTransDB();
			//Added by shrutika on 03-12-18 [Start] for updateEventLog.
			if("".equals(this.getEditorId()))
			{
				this.editorId = ""+ new Date().getTime();
			}
			//Change by shrutika on 05-01-19 for add exception.
			userEventLogEJB.setEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(), this.getEditorId(), ( String )this.headerInfoMap.get( "action" ) , "pre_confirm", startTime, null ,"currDomId:[" + ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId) + "]", this.headerPKFieldValues,"Pending","SA","");
			//Added by shrutika on 03-12-18 [End] for updateEventLog.
			//Changed by Prasad on 17/03/18 [formName implementation in transaction editor]
			String formName = getObjPropValue( this.objContext, "FORM_NAME" );
			if(transDB != null && !"null".equalsIgnoreCase(transDB) && transDB.trim().length() > 0)
			{
				//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
				this.eventManager.setAction("confirm");
				wsReturnValue = this.eventManager.executeSystemEvent(this.objName, "pre_confirm", currentEventContext, parseString(xmlStr), this.detailDom, getXtraParams(), ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId), formName, this.userInfo); //$NON-NLS-1$
				//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
				this.eventManager.setAction("");
			}
			else
			{
				//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
				this.eventManager.setAction("confirm");
				wsReturnValue = this.eventManager.executeSystemEvent(this.objName, "pre_confirm", currentEventContext, parseString(xmlStr), this.detailDom, getXtraParams(), ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId), formName); //$NON-NLS-1$
				//Added by shrutika on 24-12-18 for execute gen validation only defined action and form_no specific validation.
				this.eventManager.setAction("");
			}
			//Changed by Shahu mali on 10-10-13.[WS3GBAS001] for multiDB connection ; END

			BaseLogger.log("3", userInfo,editorId,"wsReturnValue from Confirmation: "+ wsReturnValue); //$NON-NLS-1$
			// Added by Raju K on 02-05-14 for Event log and Transaction lock as per danish sir START--
			//Added By Mahesh Patidar on 01/AUG/13[WI3DSUN001|to log the user event activity log]
			if( userInfo != null )
			{
				//Added by shrutika on 03-12-18 for updateEventLog.
				//userEventLogEJB.setEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(), this.getEditorId(), ( String )this.headerInfoMap.get( "action" ) , "pre_confirm", startTime, new Date(),"currDomId:[" + ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId) + "]", this.headerPKFieldValues);
				//Change by shrutika on 05-01-19 for add exception.
				userEventLogEJB.updateEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(), this.getEditorId(), ( String )this.headerInfoMap.get( "action" ) , "pre_confirm", startTime, new Date(),"currDomId:[" + ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId) + "]", this.headerPKFieldValues,"Success","SA","");
			}
			else
			{
				BaseLogger.log("3", userInfo,editorId," ============ User info is null then never create event log in executeConfirm() method and MasterStatefulEJB.java file ");
			}
		}
		catch(Exception e)
		{
			//Added by shrutika on 25-12-18 [Start] for update status as Exception.
			if( userInfo != null )
			{
				//change by shrutika on 22-01-19 for parsing issue for writePrintStacktrace in updateEventLog.
				ITMException ie = new ITMException(e);
				userEventLogEJB.updateEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(), this.getEditorId(), ( String )this.headerInfoMap.get( "action" ) , "pre_confirm", startTime, new Date(),"currDomId:[" + ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId) + "]", this.headerPKFieldValues,"Exception","SA",ie.getMessage());
			}
			//Added by shrutika on 25-12-18 [End] for update status as Exception.
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulException :executeConfirmation :==>\n"+e.getMessage()); //$NON-NLS-1$
			e.printStackTrace();
			throw new ITMException(e);
		}
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]Returning string after executeing Confirmation :\n"+wsReturnValue+": !!!!!"); //$NON-NLS-1$ //$NON-NLS-2$
		return wsReturnValue;
	}
	
	//Changed by Danish on 04/09/2008 [ to include exception with Data in Case of itm_default ] Start
	public String getDetailXMLDomString(String objName, String objContext, String editFlag, String pkValues, String argFieldValues, boolean withExceptnMsg)throws RemoteException,ITMException
	{
		String detailXMLStr = null;
		try
		{
			BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB] getDetailXMLDomString  objName:: "+objName);
			detailXMLStr = getDetailXMLDomString(objName, objContext, editFlag, pkValues, argFieldValues);
			if ( withExceptnMsg && ( this.exceptnMsg != null ))
			{
				detailXMLStr = detailXMLStr + "<EXCEPTN_MSG>"+exceptnMsg+"</EXCEPTN_MSG>"; //$NON-NLS-1$ //$NON-NLS-2$
				BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB] getDetailXMLDomString  EXCEPTN_MSG added with Data "); //$NON-NLS-1$
			}	
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return detailXMLStr;
	}
	//Changed by Danish on 04/09/2008 [ to include exception with Data in Case of itm_default ] End

	public String getDetailXMLDomString(String objName, String objContext, String editFlag, String pkValues, String argFieldValues)throws RemoteException,ITMException
	{
		//Start maintaining MasterStateful state from this state.
		//Case 1 :Identify request for entire existing transaction (header + all details) call createDetailDom(String pkValues)
		//Case 2 :Identify request for add dom for a given context
		
		//BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB]Detail dom for objContext :["+objContext+"] editFlag :["+editFlag+"] pkValues :["+pkValues+"] argFieldValues :["+argFieldValues+"]");
		String detailXMLStr = null;
		boolean isHeaderFocusChanged = true;
		try
		{
			BaseLogger.log("3", userInfo,editorId,"Inside MasterStatefulEjb line 6587 editFlag ["+editFlag+"]");
			BaseLogger.log("3", userInfo,editorId,"Inside MasterStatefulEjb line 6587 objName ["+objName+"]");
			//Changed by Dayanand on 25/08/09[ WI89BAS029 || Update instanceActivityLog ]
			instanceInterceptorLog( "getXMLDataForDetail" ); //$NON-NLS-1$
			//To set the object details
			//Changed by MOnif on 18/03/09[Call getContextTitlesList only once for objName].
			//ArrayList contextTitlesList = getContextTitlesList(objName);
			if ( ! this.transactionPropertySet || ! objName.equalsIgnoreCase(this.objName) )
			{
				this.transactionPropertySet = true;
				ArrayList contextTitlesList= null;
				//Added by Sneha on 18-1-14 to pass userInfo
				String transDB=this.userInfo.getTransDB();
				BaseLogger.log("3", userInfo,editorId,"getDetailXMLDomString...transDB.."+transDB);
				if(transDB != null && transDB.trim().length() >0)
				{
					BaseLogger.log("3", userInfo,editorId,"Inside MasterStatefulEjb line 8432 objName ["+objName+"]");
					contextTitlesList = getContextTitlesList(objName, this.userInfo);
				}
				else
				{
					contextTitlesList = getContextTitlesList(objName);
				}
			}
	
			//Setting the pageContext as 2 forcibly.
			this.pageContext = "2"; //$NON-NLS-1$

			//Setting the objContext based on the request.
			if (editFlag.equalsIgnoreCase("A")) //$NON-NLS-1$
			{
				this.objContext = objContext;
			}
			else
			{
				this.objContext = "1"; //$NON-NLS-1$
			}
			
			//dddSetting the globalEditFlag and localEditFlag based on the request and current objContext 
			if(Integer.parseInt(this.objContext.trim()) == 1)
			{
				if (editFlag != null && editFlag.length() > 0)
				{
					this.editFlag = editFlag;
					this.localEditFlag = editFlag;
				}
			}
			else
			{
				if (editFlag != null && editFlag.length() > 0)
				{
					this.localEditFlag = editFlag;
				}
			}

			//Creation of detail dom
			if(Integer.parseInt(this.objContext.trim()) == 1)//BaseLogger.log("3", userInfo,editorId, "fromDommmmmm" +  serializeDom( fromDom ) );
			{
				if (!this.editFlag.equalsIgnoreCase("A")) //$NON-NLS-1$
				{
					this.headerPKFieldValues = pkValues;
				}
				else if (this.editFlag.equalsIgnoreCase("A")) //$NON-NLS-1$
				{
					setArgFieldValues(argFieldValues);
					this.headerPKFieldValues = null;
				}
		
				//Changed by Dhruv on 18/07/2006 to set Audit Trail option.
				if ( this.editFlag.equalsIgnoreCase( "E" ) ) //$NON-NLS-1$
				{
					setAuditTrailOpt();
				}
				//Changed by Dhruv on 18/07/2006 to check ediatbility based on TRANSETUP.EDIT_OPT
				//Changed by Sandeep on 14-APR-16 [[S15LSUN004] New interface for Wizard and Editor] Start
				// added by mahesh saggam on 9-DEC-19 [In case confirmed, cancelled or edit expression failed, separate message to be given to the user] Start
				//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression.
				//if (  ( (! this.editFlag.equalsIgnoreCase("V") ) && (! this.editFlag.equalsIgnoreCase("A") ) )&& ! isEditable() && ! isEditable() && this.editExpr != null)//prerna 15/07/2006 //$NON-NLS-1$
				if ( ( (! this.editFlag.equalsIgnoreCase("V")) && (! this.editFlag.equalsIgnoreCase("A") ) ) && !isEditable() )
				{
					//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - start
					BaseLogger.log("3", userInfo,editorId,"MasterStatefulEJB.getDetailXMLDomString() isClose:["+isClose+"]");
					BaseLogger.log("3", userInfo,editorId,"MasterStatefulEJB.getDetailXMLDomString() isCancel:["+isCancel+"]");
					BaseLogger.log("3", userInfo,editorId,"MasterStatefulEJB.getDetailXMLDomString() isConfirm:["+isConfirm+"]");
					BaseLogger.log("3", userInfo,editorId,"MasterStatefulEJB.getDetailXMLDomString() isNonEditable:["+isNonEditable+"]");
					if( isClose )
					{
						int count = Integer.parseInt(dbAccess.getDBColumnValue("MESSAGES", "COUNT(0)", "MSG_NO = 'NOEDITL'"));
						if( count > 0 )
						{
							String message  = dbAccess.getDBColumnValue("MESSAGES", "MSG_STR", "MSG_NO = 'NOEDITL'");
							String messageDescr  = dbAccess.getDBColumnValue("MESSAGES", "MSG_DESCR", "MSG_NO = 'NOEDITL'");
							StringBuffer retStrBuff = new StringBuffer("<?xml version='1.0' encoding='"+this.userInfo.getCharEnc()+"'?><Errors>");
							retStrBuff.append("<error id='NOEDITL' type='E' column_name=''>");
							retStrBuff.append("<message><![CDATA["+message+"]]></message>");
							retStrBuff.append("<description><![CDATA["+messageDescr+"]]></description>");
							retStrBuff.append("<trace><![CDATA[]]></trace>");
							retStrBuff.append("<redirect>1</redirect></error></Errors>");
						    return retStrBuff.toString();
						}
						else
						{
							StringBuffer retStrBuff = new StringBuffer("<?xml version='1.0' encoding='"+this.userInfo.getCharEnc()+"'?><Errors>");
							retStrBuff.append("<error id='' type='E' column_name=''>");
							retStrBuff.append("<message><![CDATA["+ Messages.getString("MasterStatefulEJB_transaction") + this.headerPKFieldValues + Messages.getString("MasterStatefulEJB_modifyTransaction") +"]]></message>");
							retStrBuff.append("<trace><![CDATA[]]></trace>");
							retStrBuff.append("<redirect>1</redirect></error></Errors>");
							return retStrBuff.toString();
						}
					}
					else if( isCancel )
					{
						int count = Integer.parseInt(dbAccess.getDBColumnValue("MESSAGES", "COUNT(0)", "MSG_NO = 'NOEDITX'"));
						if( count > 0 )
						{
							String message  = dbAccess.getDBColumnValue("MESSAGES", "MSG_STR", "MSG_NO = 'NOEDITX'");
							String messageDescr  = dbAccess.getDBColumnValue("MESSAGES", "MSG_DESCR", "MSG_NO = 'NOEDITX'");
							StringBuffer retStrBuff = new StringBuffer("<?xml version='1.0' encoding='"+this.userInfo.getCharEnc()+"'?><Errors>");
							retStrBuff.append("<error id='NOEDITX' type='E' column_name=''>");
							retStrBuff.append("<message><![CDATA["+message+"]]></message>");
							retStrBuff.append("<description><![CDATA["+messageDescr+"]]></description>");
							retStrBuff.append("<trace><![CDATA[]]></trace>");
							retStrBuff.append("<redirect>1</redirect></error></Errors>");
						    return retStrBuff.toString();
						}
						else
						{
							StringBuffer retStrBuff = new StringBuffer("<?xml version='1.0' encoding='"+this.userInfo.getCharEnc()+"'?><Errors>");
							retStrBuff.append("<error id='' type='E' column_name=''>");
							retStrBuff.append("<message><![CDATA["+ Messages.getString("MasterStatefulEJB_transaction") + this.headerPKFieldValues + Messages.getString("MasterStatefulEJB_modifyTransaction") +"]]></message>");
							retStrBuff.append("<trace><![CDATA[]]></trace>");
							retStrBuff.append("<redirect>1</redirect></error></Errors>");
							return retStrBuff.toString();
						}
					}
					else if( isConfirm )
					{
						int count = Integer.parseInt(dbAccess.getDBColumnValue("MESSAGES", "COUNT(0)", "MSG_NO = 'NOEDITC'"));
						if( count > 0 )
						{
							String message  = dbAccess.getDBColumnValue("MESSAGES", "MSG_STR", "MSG_NO = 'NOEDITC'");
							String messageDescr  = dbAccess.getDBColumnValue("MESSAGES", "MSG_DESCR", "MSG_NO = 'NOEDITC'");
							StringBuffer retStrBuff = new StringBuffer("<?xml version='1.0' encoding='"+this.userInfo.getCharEnc()+"'?><Errors>");
							retStrBuff.append("<error id='NOEDITC' type='E' column_name=''>");
							retStrBuff.append("<message><![CDATA["+message+"]]></message>");
							retStrBuff.append("<description><![CDATA["+messageDescr+"]]></description>");
							retStrBuff.append("<trace><![CDATA[]]></trace>");
							retStrBuff.append("<redirect>1</redirect></error></Errors>");
						    return retStrBuff.toString();
						}
						else
						{
							StringBuffer retStrBuff = new StringBuffer("<?xml version='1.0' encoding='"+this.userInfo.getCharEnc()+"'?><Errors>");
							retStrBuff.append("<error id='' type='E' column_name=''>");
							retStrBuff.append("<message><![CDATA["+ Messages.getString("MasterStatefulEJB_transaction") + this.headerPKFieldValues + Messages.getString("MasterStatefulEJB_modifyTransaction") +"]]></message>");
							retStrBuff.append("<trace><![CDATA[]]></trace>");
							retStrBuff.append("<redirect>1</redirect></error></Errors>");
							return retStrBuff.toString();
						}
					}
					else if( isNonEditable )
					{
						int count = Integer.parseInt(dbAccess.getDBColumnValue("MESSAGES", "COUNT(0)", "MSG_NO = 'NOEDITO'"));
						if( count > 0 )
						{
							String message  = dbAccess.getDBColumnValue("MESSAGES", "MSG_STR", "MSG_NO = 'NOEDITO'");
							String messageDescr  = dbAccess.getDBColumnValue("MESSAGES", "MSG_DESCR", "MSG_NO = 'NOEDITO'");
							StringBuffer retStrBuff = new StringBuffer("<?xml version='1.0' encoding='"+this.userInfo.getCharEnc()+"'?><Errors>");
							retStrBuff.append("<error id='NOEDITO' type='E' column_name=''>");
							retStrBuff.append("<message><![CDATA["+message+"]]></message>");
							retStrBuff.append("<description><![CDATA["+messageDescr+"]]></description>");
							retStrBuff.append("<trace><![CDATA[]]></trace>");
							retStrBuff.append("<redirect>1</redirect></error></Errors>");
						    return retStrBuff.toString();
						}
						else
						{
							StringBuffer retStrBuff = new StringBuffer("<?xml version='1.0' encoding='"+this.userInfo.getCharEnc()+"'?><Errors>");
							retStrBuff.append("<error id='' type='E' column_name=''>");
							retStrBuff.append("<message><![CDATA["+ Messages.getString("MasterStatefulEJB_transaction") + this.headerPKFieldValues + Messages.getString("MasterStatefulEJB_modifyTransaction") +"]]></message>");
							retStrBuff.append("<trace><![CDATA[]]></trace>");
							retStrBuff.append("<redirect>1</redirect></error></Errors>");
							return retStrBuff.toString();
						}
					}//Added by Prasad on 29/08/2020 [ to display alert message on if transaction in workflow ] START
					else if( this.isWrkflwToBeInitiated && isWorkflowPending() )
					{
						BaseLogger.log( "3", userInfo, editorId, "MasterStatefulEJB.getDetailXMLDomString() isWorkflowPending : [true]" );
						
						StringBuffer retStrBuff = new StringBuffer("<?xml version='1.0' encoding='"+this.userInfo.getCharEnc()+"'?><Errors>");
						retStrBuff.append("<error id='' type='E' column_name=''>");
						retStrBuff.append("<message><![CDATA["+ Messages.getString("MasterStatefulEJB_transaction") + this.headerPKFieldValues + Messages.getString("MasterStatefulEJB_hasAlreadyConfirmed") +"]]></message>");
						retStrBuff.append("<trace><![CDATA[]]></trace>");
						retStrBuff.append("<redirect>1</redirect></error></Errors>");
						return retStrBuff.toString();
					}
					//Added by Prasad on 29/08/2020 [ to display alert message on if transaction in workflow ] END
					//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - end
				}
				// added by mahesh saggam on 9-DEC-19 [In case confirmed, cancelled or edit expression failed, separate message to be given to the user] End
				//Commented By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - start
				/*else if (  ( (! this.editFlag.equalsIgnoreCase("V") ) && (! this.editFlag.equalsIgnoreCase("A") ) )&& ! isEditable() )//prerna 15/07/2006 //$NON-NLS-1$
				{
					//Changed By Pankaj T on 14-06-17 [chanage response of confirm transaction] - Start 
					//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - start
					int count = Integer.parseInt(dbAccess.getDBColumnValue("MESSAGES", "COUNT(0)", "MSG_NO = 'NOEDITO'"));
					if( count > 0 )
					{
						String message  = dbAccess.getDBColumnValue("MESSAGES", "MSG_STR", "MSG_NO = 'NOEDITO'");
						String messageDescr  = dbAccess.getDBColumnValue("MESSAGES", "MSG_DESCR", "MSG_NO = 'NOEDITO'");
						StringBuffer retStrBuff = new StringBuffer("<?xml version='1.0' encoding='"+this.userInfo.getCharEnc()+"'?><Errors>");
						retStrBuff.append("<error id='NOEDITO' type='E' column_name=''>");
						retStrBuff.append("<message><![CDATA["+message+"]]></message>");
						retStrBuff.append("<description><![CDATA["+messageDescr+"]]></description>");
						retStrBuff.append("<trace><![CDATA[]]></trace>");
						retStrBuff.append("<redirect>1</redirect></error></Errors>");
					    return retStrBuff.toString();
					}
					else
					{
						StringBuffer retStrBuff = new StringBuffer("<?xml version='1.0' encoding='"+this.userInfo.getCharEnc()+"'?><Errors>");
						retStrBuff.append("<error id='' type='E' column_name=''>");
						retStrBuff.append("<message><![CDATA["+Messages.getString("MasterStatefulEJB_transaction") + this.headerPKFieldValues + Messages.getString("MasterStatefulEJB_hasAlreadyBeenConfirmed")+"]]></message>");
						retStrBuff.append("<description><![CDATA[ "+Messages.getString("MasterStatefulEJB_transactionCannotBeEdited")+"]]></description>");
						retStrBuff.append("<trace><![CDATA[]]></trace>");
						retStrBuff.append("<redirect>1</redirect></error></Errors>");
						return retStrBuff.toString();
					}
					//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - end
					//return "<DocumentRoot><Message>"+Messages.getString("MasterStatefulEJB_selectedTransaction") + this.headerPKFieldValues + " is not editable</Message></DocumentRoot>"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				    //Changed By Pankaj T on 14-06-17 [chanage response of confirm transaction] - End
				}*/
				//Commented By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - end
				//Changed by Sandeep on 14-APR-16 [[S15LSUN004] New interface for Wizard and Editor] End
				/*if ( ( ! this.editFlag.equalsIgnoreCase("V")) && isConfirmed() )
				{
					return "<DocumentRoot><Message>The selected transaction " + this.headerPKFieldValues + " has already been confirmed.<br/>So, cannot be edited</Message></DocumentRoot>";
				}*/
				//Uncommented by Prasad on 29/08/2020 [ to display alert message on if transaction in workflow ] START
				else if ( ( ! this.editFlag.equalsIgnoreCase("V") ) && this.isWrkflwToBeInitiated && isWorkflowPending() )//Danish Thursday, May 11, 2006
				{
					//return "<DocumentRoot><Message>The selected transaction " + this.headerPKFieldValues + " has already been initiated for WorkFlow.<br/>So, cannot be edited</Message></DocumentRoot>";
					return "<DocumentRoot><Message>"+Messages.getString("MasterStatefulEJB_selectedTransaction") + this.headerPKFieldValues + Messages.getString("MasterStatefulEJB_hasAlreadyConfirmed")+"<br/>"+Messages.getString("MasterStatefulEJB_cannotBeEdited")+"</Message></DocumentRoot>";
				}//Uncommented by Prasad on 29/08/2020 [ to display alert message on if transaction in workflow ] END
				else
				{
					createDetailDom();
				}
				detailXMLStr = serializeDom(this.detailDom);
			}
			else
			{
				if( this.localEditFlag.equalsIgnoreCase("A"))  //$NON-NLS-1$
				{
					addChildAddDom();
					//vikrant 6/2/2005
					//Creation of currRecordNode
					//this.currRecordNode = searchNode(this.detailDom,this.objContext,this.detailDomId);
					//detailXMLStr = getNormalizedString(serializeDom(this.currRecordNode));
				}
				//vikrant 6/3/2005
				//Changed by Prasad on 02/11/16 [to search node from dbId]
				//this.currRecordNode = searchNode(this.detailDom,this.objContext,this.detailDomId);
				this.currRecordNode = searchNode(this.detailDom,this.objContext,this.detailDomId, "");
				detailXMLStr = getNormalizedString(serializeDom(this.currRecordNode));

			}
			//vikrant 6/2/2005
			//detailXMLStr =serializeDom(this.detailDom);
					
						
			// = searchNode(this.detailDom, this.objContext, ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId) );
			//Creation of currTaxNode
			//this.currTaxNode = getCurrTaxNode();

		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :getXMLDataForDetail :==>\n"+e); //$NON-NLS-1$
			e.printStackTrace();
			throw new ITMException(e);
		}
		BaseLogger.log("2", userInfo,editorId,"\t\tXXXXXXXEdit XML StartXXXXXXXXX"); //$NON-NLS-1$
//		BaseLogger.log("3", userInfo,editorId,"Edit XML String :\n"+detailXMLStr);
		BaseLogger.log("2", userInfo,editorId,"\t\tXXXXXXXEdit XML EndXXXXXXXXX"); //$NON-NLS-1$
		return detailXMLStr;
	}
	
	public String getDataXML( String objContext, String domId, String editFlag, String pgContext )throws RemoteException,ITMException
	{
		//BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB]getDataXML Obj Context :["+objContext+"] Dom Id :["+domId+"] Edit Flag :["+editFlag+"] Page Context :["+pgContext+"]");
		//Added by shrutika on 25-12-18 [Start] for update status as Exception.
		String actionMode = "";
		Date startTime = null;
		//Added by shrutika on 25-12-18 [End] for update status as Exception.
		String dataXML = null;
		try
		{
			//Changed by Dayanand on 25/08/09[ WI89BAS029 || Update instanceActivityLog ]
			instanceInterceptorLog( "getDataXML" ); //$NON-NLS-1$
			//Setting the objContext
			this.objContext = objContext;
			
			//Setting the detailDomId
			if( E12GenericUtility.checkNull(domId).length() > 0 )
			{
				this.detailDomId = domId;
			}

			//Setting the pageContext
			this.pageContext = pgContext;

			//Setting the globalEditFlag and localEditFlag based on the request and current objContext
			if (editFlag != null && editFlag.length() > 0)
			{
				if( Integer.parseInt( this.objContext.trim() ) == 1)
				{
					this.editFlag = editFlag;
					this.localEditFlag = editFlag;
				}
				else
				{
					this.localEditFlag = editFlag;
				}
			}
			
			//Creating DataDom for current Form
			if( Integer.parseInt( this.objContext.trim() ) == 1 )
			{
				if( this.detailDom == null )
				{
					// added by mahesh saggam on 9-DEC-19 [In case confirmed, cancelled or edit expression failed, separate message to be given to the user] Start
					//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression.
					//if ( this.editFlag.equalsIgnoreCase("E") && isConfirmed() && this.editExpr != null)
					if ( this.editFlag.equalsIgnoreCase("E") && ( isClosed() || isCanceled() || isConfirmed() || isNonEditable() ) )
					{
						//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - start
						if( isClose )
						{
							int count = Integer.parseInt(dbAccess.getDBColumnValue("MESSAGES", "COUNT(0)", "MSG_NO = 'NOEDITL'"));
							if( count > 0 )
							{
								String message  = dbAccess.getDBColumnValue("MESSAGES", "MSG_STR", "MSG_NO = 'NOEDITL'");
								String messageDescr  = dbAccess.getDBColumnValue("MESSAGES", "MSG_DESCR", "MSG_NO = 'NOEDITL'");
							    return "<DocumentRoot><Message>"+message+"<br>"+messageDescr+"</Message></DocumentRoot>";
							}
							else
							{
								return "<DocumentRoot><Message>"+Messages.getString("MasterStatefulEJB_selectedTransaction") + this.headerPKFieldValues + Messages.getString("MasterStatefulEJB_modifyTransaction")+"</Message></DocumentRoot>"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
							}
						}
						else if( isCancel )
						{
							int count = Integer.parseInt(dbAccess.getDBColumnValue("MESSAGES", "COUNT(0)", "MSG_NO = 'NOEDITX'"));
							if( count > 0 )
							{
								String message  = dbAccess.getDBColumnValue("MESSAGES", "MSG_STR", "MSG_NO = 'NOEDITX'");
								String messageDescr  = dbAccess.getDBColumnValue("MESSAGES", "MSG_DESCR", "MSG_NO = 'NOEDITX'");
							    return "<DocumentRoot><Message>"+message+"<br>"+messageDescr+"</Message></DocumentRoot>";
							}
							else
							{
								return "<DocumentRoot><Message>"+Messages.getString("MasterStatefulEJB_selectedTransaction") + this.headerPKFieldValues + Messages.getString("MasterStatefulEJB_modifyTransaction")+"</Message></DocumentRoot>"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
							}
						}
						else if( isConfirm )
						{
							int count = Integer.parseInt(dbAccess.getDBColumnValue("MESSAGES", "COUNT(0)", "MSG_NO = 'NOEDITC'"));
							if( count > 0 )
							{
								String message  = dbAccess.getDBColumnValue("MESSAGES", "MSG_STR", "MSG_NO = 'NOEDITC'");
								String messageDescr  = dbAccess.getDBColumnValue("MESSAGES", "MSG_DESCR", "MSG_NO = 'NOEDITC'");
							    return "<DocumentRoot><Message>"+message+"<br>"+messageDescr+"</Message></DocumentRoot>";
							}
							else
							{
								return "<DocumentRoot><Message>"+Messages.getString("MasterStatefulEJB_selectedTransaction") + this.headerPKFieldValues + Messages.getString("MasterStatefulEJB_modifyTransaction")+"</Message></DocumentRoot>"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
							}
						}
						else if( isNonEditable )
						{
							int count = Integer.parseInt(dbAccess.getDBColumnValue("MESSAGES", "COUNT(0)", "MSG_NO = 'NOEDITO'"));
							if( count > 0 )
							{
								String message  = dbAccess.getDBColumnValue("MESSAGES", "MSG_STR", "MSG_NO = 'NOEDITO'");
								String messageDescr  = dbAccess.getDBColumnValue("MESSAGES", "MSG_DESCR", "MSG_NO = 'NOEDITO'");
							    return "<DocumentRoot><Message>"+message+"<br>"+messageDescr+"</Message></DocumentRoot>";
							}
							else
							{
								return "<DocumentRoot><Message>"+Messages.getString("MasterStatefulEJB_selectedTransaction") + this.headerPKFieldValues + Messages.getString("MasterStatefulEJB_modifyTransaction")+"</Message></DocumentRoot>"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
							}
						}
						//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - end
					}
					// added by mahesh saggam on 9-DEC-19 [In case confirmed, cancelled or edit expression failed, separate message to be given to the user] End
					//Commented By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - start
					/*else if ( this.editFlag.equalsIgnoreCase("E") && isConfirmed() ) //$NON-NLS-1$
					{
						//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - start
						int count = Integer.parseInt(dbAccess.getDBColumnValue("MESSAGES", "COUNT(0)", "MSG_NO = 'NOEDITC'"));
						if( count > 0 )
						{
							String message  = dbAccess.getDBColumnValue("MESSAGES", "MSG_STR", "MSG_NO = 'NOEDITC'");
							String messageDescr  = dbAccess.getDBColumnValue("MESSAGES", "MSG_DESCR", "MSG_NO = 'NOEDITC'");
						    return "<DocumentRoot><Message>"+message+"<br>"+messageDescr+"</Message></DocumentRoot>";
						}
						else
						{
							return "<DocumentRoot><Message>"+Messages.getString("MasterStatefulEJB_selectedTransaction") + this.headerPKFieldValues + Messages.getString("MasterStatefulEJB_hasAlreadyBeenConfirmed")+"<br/>"+"So, cannot be edited"+"</Message></DocumentRoot>"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
						}
						//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - end
					}*/
					//Commented By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - end
					else if ( this.editFlag.equalsIgnoreCase("E") && this.isWrkflwToBeInitiated && isWorkflowPending()  ) //$NON-NLS-1$
					{
						return "<DocumentRoot><Message>"+Messages.getString("MasterStatefulEJB_selectedTransaction") + this.headerPKFieldValues + Messages.getString("MasterStatefulEJB_hasAlreadyConfirmed")+"<br/>"+Messages.getString("MasterStatefulEJB_cannotBeEdited")+"</Message></DocumentRoot>"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
					}
					else
					{
						createDetailDom();
					}
				}
			}//if(Integer.parseInt(this.objContext.trim()) == 1)
			else
			{
				if( this.localEditFlag.equalsIgnoreCase("A") ) //$NON-NLS-1$
				{
					//Added by shrutika on 03-12-18 [Start] for updateEventLog.
					startTime = new Date();
					actionMode = "VIEW";
					if(this.editFlag.equals("A"))
					{
						actionMode = "ADD";
					}
					else if(this.editFlag.equals("E"))
					{
						actionMode = "EDIT";			
					}
					if( userInfo != null )
					{
						//Change by shrutika on 05-01-19 for add exception.
						userEventLogEJB.setEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(), this.getEditorId(), actionMode , "ADD" , startTime, null ,"objContext:[" + this.objContext + "] pageContext:["+this.pageContext+"]", this.headerPKFieldValues,"Pending","SA","");
					}
					//Added by shrutika on 03-12-18 [End] for updateEventLog.
					addChildAddDom();
					// Added method by Raju K on 23-Sep-14 for Event Log as Dnyaneshwar start--
					if( userInfo != null )
					{
						//Added by shrutika on 03-12-18 for updateEventLog.
						//userEventLogEJB.setEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(), this.getEditorId(), actionMode , "ADD" , startTime, new Date(),"objContext:[" + this.objContext + "] pageContext:["+this.pageContext+"]", this.headerPKFieldValues);
						//Change by shrutika on 05-01-19 for add exception.
						userEventLogEJB.updateEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(), this.getEditorId(), actionMode , "ADD" , startTime, new Date(),"objContext:[" + this.objContext + "] pageContext:["+this.pageContext+"]", this.headerPKFieldValues,"Success","SA","");
					}
					else
					{
						BaseLogger.log("3", userInfo,editorId," ============ User info is null then never create event log in MasterStatefulEJB.java file");
					}
					// Added method by Raju K on 23-Sep-14 for Event Log as Dnyaneshwar end--
				}
			}//else of if(Integer.parseInt(this.objContext.trim()) == 1)

			//Filtering Data for current Form
			if( this.detailDom != null )
			{
				//BaseLogger.log("3", userInfo,editorId,"this.detailDom :["+serializeDom( this.detailDom )+"]");
				if( Integer.parseInt( this.pageContext.trim() ) == 1 )
				{
					NodeList detailList = searchNodes( this.detailDom, this.objContext );
					int detailListLength = detailList.getLength();
					StringBuffer tempStringBuff = new StringBuffer();
					for(int ctr = 0; ctr < detailListLength; ctr++)
					{
						tempStringBuff.append(serializeDom(detailList.item(ctr)));
					}
					//Added By Ajinkya Gopalkar on 29-May-17[Issue while saving blank detail from Standard editor]
					this.currRecordNode = searchNode( this.detailDom, this.objContext, this.detailDomId, "" );
					dataXML = getNormalizedString(tempStringBuff.toString());
				}
				else
				{
					if ( this.detailDomId.equals( "-1" ) ) //$NON-NLS-1$
					{
						this.detailDomId = "1"; //$NON-NLS-1$
					}
					//Changed by Prasad on 02/11/16 [to search node from dbId]
					//this.currRecordNode = searchNode( this.detailDom, this.objContext, this.detailDomId );
					this.currRecordNode = searchNode( this.detailDom, this.objContext, this.detailDomId, "" );
					if( this.currRecordNode != null )
					{
						dataXML = getNormalizedString( serializeDom( this.currRecordNode ) );
					}
				}
			}
		}
		/*
		catch( ITMException itme )
		{
			throw itme;
		}
		*/
		catch(Exception e)
		{
			//Added by shrutika on 25-12-18 [Start] for update status as Exception.
			if( userInfo != null )
			{
				//change by shrutika on 22-01-19 for parsing issue for writePrintStacktrace in updateEventLog.
				ITMException ie = new ITMException(e);
				userEventLogEJB.updateEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(), this.getEditorId(), actionMode , "ADD" , startTime, new Date(),"objContext:[" + this.objContext + "] pageContext:["+this.pageContext+"]", this.headerPKFieldValues,"Exception","SA",ie.getMessage());
			}
			//Added by shrutika on 25-12-18 [End] for update status as Exception.
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :getDataXML :==>\n"+e); //$NON-NLS-1$
			e.printStackTrace();
			throw new ITMException(e);
		}
		BaseLogger.log("2", userInfo,editorId,"\t\t11111111111Edit XML Start7777777777objContext :["+objContext+"] editFlag :["+editFlag+"]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		BaseLogger.log("2", userInfo,editorId,dataXML);
		BaseLogger.log("2", userInfo,editorId,"\t\t77777777Edit XML End111111111111111"); //$NON-NLS-1$
		return dataXML;
	}

	//Changed by Dilip on 06/11/2007 to accomodate getting data functionality used by Mobile ext. of RequestHandlerServlet.
	public String getDataXML( String objContext, String domId, String editFlag, String pgContext ,String pkValues)throws RemoteException,ITMException
	{
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]getDataXML Obj Context :["+objContext+"] Dom Id :["+domId+"] Edit Flag :["+editFlag+"] Page Context :["+pgContext+"]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
		String dataXML = null;
		try
		{
			if( "1".equals( objContext ) && pkValues != null ) //$NON-NLS-1$
			{
				this.headerPKFieldValues = pkValues;
			}
			else
			{
				if ( pkValues !=null )
				{
					domId = pkValues;
				}				
			}
			dataXML = getDataXML( objContext, domId, editFlag, pgContext );
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :getDataXML :==>\n"+e); //$NON-NLS-1$
			e.printStackTrace();
			throw new ITMException(e);
		}
		return dataXML;
	}

	public void setTransInfo( String pkValues, String argFieldValues )throws RemoteException,ITMException
	{
		try
		{
			this.headerPKFieldValues = pkValues;
			setArgFieldValues( argFieldValues );	
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :setTransInfo :==>\n"+e); //$NON-NLS-1$
			e.printStackTrace();
			throw new ITMException(e);
		}
	}

	private String getActionString(String objName)throws ITMException
	{
		String actionStr = ""; //$NON-NLS-1$
		try
		{
			/*DBAccessHome home = null;
			DBAccessRemote ejbObj = null;*/
			DBAccessEJB ejbObj = null;
			BaseLogger.log("3", userInfo,editorId,"this.userInfo :"+this.userInfo); //$NON-NLS-1$
			//home = (DBAccessHome)this.initialContext.lookup("DBAccess");
			//ejbObj = (DBAccessLocal)this.initialContext.lookup("ibase/DBAccessEJB/local"); //$NON-NLS-1$
			ejbObj = new DBAccessEJB();
			//ejbObj = home.create();
			BaseLogger.log("3", userInfo,editorId,"ejbObj :"+ejbObj); //$NON-NLS-1$
			//Added By Ajinkya Gopalkar on 21-SEP-17[For code optimization and reduce server call] Start
			String cacheActionStr = objName + "~~"+ this.userInfo.getProfileId() + "~~" + this.userInfo.getUserLevel();
			//Added Pankaj T on 18-10-17 [To use infinispan cache depends on CACHE_OPT define in ibase.xml 0 = NO Cache, 1 = Internal Cache, 2 = External Cache]
			//Changed by Prasad on 23/11/2020 [check infinispanLocalObj not null]
			if( CommonConstants.CACHE_OPT != 0 && infinispanLocalObj != null )
			{
				if( infinispanLocalObj.contains(cacheActionStr))
				{
					actionStr = infinispanLocalObj.getFormData(cacheActionStr);
				}
				else
				{
					actionStr = this.dbAccess.getAllActionsString(objName, this.userInfo.getProfileId(), this.userInfo.getUserLevel(), this.userInfo.getTransDB());
					infinispanLocalObj.putFormData(cacheActionStr, actionStr);
				}
			}
			else
			{	
				actionStr = ejbObj.getAllActionsString(objName, this.userInfo.getProfileId(), this.userInfo.getUserLevel(), this.userInfo.getTransDB());
			}
			//Added By Ajinkya Gopalkar on 21-SEP-17[For code optimization and reduce server call] End
			ejbObj = null;
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :getActionString :==>"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return actionStr;
	}

	public String getFilteredActions(String editFlag, String objContext) throws  RemoteException, ITMException
	{
		//BaseLogger.log("3", userInfo,editorId,"Applying filteredAction with editFlag :["+editFlag+"] objContext :["+objContext+"]");
		//BaseLogger.log("3", userInfo,editorId,"and this.editFlag :"+this.editFlag+": this.objContext :"+this.objContext+": ");
		/*
		<action id='A' enabled='-1' title ='Add' interactive='Y' image='a' action_type='S' obj_context='1' service_handler='0' placement='0'>
				<service_code>NA</service_code>
		</action>
		*/
		String retString = ""; //$NON-NLS-1$
		Document document = null;
		Document instDocument = null;
		Document childDocument = null;
		StringBuffer tempStrBuff = new StringBuffer("<ACTIONS>"); //$NON-NLS-1$
		try
		{
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			DocumentBuilder db = dbf.newDocumentBuilder();
			//BaseLogger.log("3", userInfo,editorId,"this.actionXmlStr :"+this.actionXmlStr+":");
			document = db.parse(new ByteArrayInputStream(this.actionXmlStr.getBytes()));
			BaseLogger.log("3", userInfo,editorId,"\n\n\n@@@@ this.actionXmlStr @@@@ "+document); //$NON-NLS-1$
			instDocument = db.parse(new ByteArrayInputStream(this.actionXmlStr.getBytes( CommonConstants.ENCODING )));
			if (Integer.parseInt(objContext) != 0)
			{
				if (Integer.parseInt(objContext) == 1)
				{
					BaseLogger.log("3", userInfo,editorId,"Adding Refresh editFlag :"+editFlag); //$NON-NLS-1$
					if ("V".equalsIgnoreCase(editFlag)) //$NON-NLS-1$
					{
						tempStrBuff.append("<action id='R' enabled='0' title ='Refresh' interactive='Y' image='menu.bmp' action_type='S' obj_context='1' service_handler='0' placement='0'>"); //$NON-NLS-1$
					}
					else
					{
						tempStrBuff.append("<action id='R' enabled='1' title ='Refresh' interactive='Y' image='menu.bmp' action_type='S' obj_context='1' service_handler='0' placement='0'>"); //$NON-NLS-1$
					}
					tempStrBuff.append("<service_code>NA</service_code>"); //$NON-NLS-1$
					tempStrBuff.append("</action>"); //$NON-NLS-1$
				}
				Node actnNode = document.getElementsByTagName(document.getDocumentElement().getTagName()).item(0);
				Node instNode = instDocument.getElementsByTagName(instDocument.getDocumentElement().getTagName()).item(0);

				NodeList actnNodeChildList = document.getElementsByTagName("action"); //$NON-NLS-1$
				NodeList instNodeChildList = instDocument.getElementsByTagName("action"); //$NON-NLS-1$
				
				// Add, Edit, Delete, Save, Next, Previous, Refresh
				int contextTitlesListLen = this.contextTitlesList.size();	
				int actnNodeChildSize = actnNodeChildList.getLength();
				BaseLogger.log("3", userInfo,editorId,"actnNodeChildSize :"+actnNodeChildSize+":"); //$NON-NLS-1$ //$NON-NLS-2$

				for (int i = 0; i < actnNodeChildSize; i++)
				{
					Node currNode =	actnNodeChildList.item(i);
					Node currInsNode = instNodeChildList.item(i);
					BaseLogger.log("3", userInfo,editorId,"ID :"+currNode.getAttributes().getNamedItem("id").getNodeValue()+":"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
					String currNodeId = currNode.getAttributes().getNamedItem("id").getNodeValue(); //$NON-NLS-1$
					String currNodeStatus = currNode.getAttributes().getNamedItem("enabled").getNodeValue(); //$NON-NLS-1$
					String actionType = currNode.getAttributes().getNamedItem("action_type").getNodeValue(); //$NON-NLS-1$
					BaseLogger.log("3", userInfo,editorId,"getFilteredActions :["+i+"] currNodeId :"+currNodeId+":"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
					
					if (Integer.parseInt(objContext) == 1 && actionType.equalsIgnoreCase("S")) //$NON-NLS-1$
					{
						if (((currNodeStatus.equals("-1") || editFlag.equalsIgnoreCase("")) && ! currNodeId.equalsIgnoreCase("S") ) || ( ! editFlag.equalsIgnoreCase("V") && this.pageContext.equals("2") && (currNodeId.equalsIgnoreCase("S") || currNodeId.equalsIgnoreCase("D"))) ) //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$
						{
							currNode.getAttributes().getNamedItem("enabled").setNodeValue("1"); //$NON-NLS-1$ //$NON-NLS-2$
							currInsNode.getAttributes().getNamedItem("enabled").setNodeValue("0"); //$NON-NLS-1$ //$NON-NLS-2$
							BaseLogger.log("3", userInfo,editorId,"currNodeId :"+currNodeId+": editFlag :"+editFlag+": enabled :"+currNode.getAttributes().getNamedItem("enabled").getNodeValue()); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
							tempStrBuff.append(serializeDom(currNode));
						}
						else
						{
							currNode.getAttributes().getNamedItem("enabled").setNodeValue("0"); //$NON-NLS-1$ //$NON-NLS-2$
							currInsNode.getAttributes().getNamedItem("enabled").setNodeValue("0"); //$NON-NLS-1$ //$NON-NLS-2$
							tempStrBuff.append(serializeDom(currNode));
						}
					}
					else
					{	
						if ( ! currNodeId.equalsIgnoreCase("E") && actionType.equalsIgnoreCase("S")) //$NON-NLS-1$ //$NON-NLS-2$
						{
							if (this.editTemplate == 0 && ! this.editFlag.equalsIgnoreCase("V") && (currNodeId.equalsIgnoreCase("A") || currNodeId.equalsIgnoreCase("S") || currNodeId.equalsIgnoreCase("D"))) //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
							{
								currNode.getAttributes().getNamedItem("enabled").setNodeValue("1"); //$NON-NLS-1$ //$NON-NLS-2$
								currInsNode.getAttributes().getNamedItem("enabled").setNodeValue("0"); //$NON-NLS-1$ //$NON-NLS-2$
								tempStrBuff.append(serializeDom(currNode));
							}
						}
						else if ( ! actionType.equalsIgnoreCase("S")) //$NON-NLS-1$
						{
							String nodeObjContext = currNode.getAttributes().getNamedItem("obj_context").getNodeValue(); //$NON-NLS-1$
							if (nodeObjContext.equalsIgnoreCase(objContext))
							{
								tempStrBuff.append(serializeDom(currNode));
							}
						}
					}
				}//for (int i=0; i<actnNodeChildSize; i++)
				BaseLogger.log("3", userInfo,editorId," Adding Abort "); //$NON-NLS-1$
				if ((Integer.parseInt(this.pageContext) == 2) || Integer.parseInt(this.objContext) > 1 || ! editFlag.equals("") )//Disabled By Calling of Save //$NON-NLS-1$
				{
					tempStrBuff.append("<action id='X' enabled='1' title ='Abort' interactive='Y' image='menu.bmp' action_type='S' obj_context='1' service_handler='0' placement='0'>"); //$NON-NLS-1$
				}
				else
				{
					tempStrBuff.append("<action id='X' enabled='0' title ='Abort' interactive='Y' image='menu.bmp' action_type='S' obj_context='1' service_handler='0' placement='0'>"); //$NON-NLS-1$
				}
				tempStrBuff.append("	<service_code>NA</service_code>"); //$NON-NLS-1$
				tempStrBuff.append("</action>"); //$NON-NLS-1$
				if((Integer.parseInt(objContext) < contextTitlesListLen))
				{
					if ((Integer.parseInt(objContext) > 1) || (Integer.parseInt(objContext) == 1 && Integer.parseInt(this.pageContext) == 2))
					{
						BaseLogger.log("3", userInfo,editorId," Adding Next "); //$NON-NLS-1$
						tempStrBuff.append("<action id='N' enabled='1' title ='Next' interactive='Y' image='menu.bmp' action_type='S' obj_context='1' service_handler='0' placement='0'>"); //$NON-NLS-1$
						tempStrBuff.append("<service_code>NA</service_code>"); //$NON-NLS-1$
						tempStrBuff.append("</action>"); //$NON-NLS-1$
					}
				}
				if (Integer.parseInt(objContext) > 1)
				{
					BaseLogger.log("3", userInfo,editorId," Adding Previous "); //$NON-NLS-1$
					tempStrBuff.append("<action id='P' enabled='1' title ='Previous' interactive='Y' image='menu.bmp' action_type='S' obj_context='1' service_handler='0' placement='0'>"); //$NON-NLS-1$
					tempStrBuff.append("<service_code>NA</service_code>"); //$NON-NLS-1$
					tempStrBuff.append("</action>"); //$NON-NLS-1$
				}
				BaseLogger.log("3", userInfo,editorId," Adding Close"); //$NON-NLS-1$
				tempStrBuff.append("<action id='C' enabled='1' title ='Close' interactive='Y' image='menu.bmp' action_type='S' obj_context='1' service_handler='0' placement='0'>"); //$NON-NLS-1$
				tempStrBuff.append("<service_code>NA</service_code>"); //$NON-NLS-1$
				tempStrBuff.append("</action>"); //$NON-NLS-1$

				tempStrBuff.append("</ACTIONS>"); //$NON-NLS-1$
				this.actionXmlStr = serializeDom(instDocument);
				retString = tempStrBuff.toString();
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return retString;
	}
	
	/*
	//Changed By Dhruv on 27/12/2006 logic changed.
	public String getTransCopyXMLString( String objName, String objContext, String pkValues )throws RemoteException,ITMException
	{
		BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB]Detail dom for objName ["+objName+"] objContext :["+objContext+"] editFlag :["+editFlag+"] pkValues :["+pkValues+"] argFieldValues :["+argFieldValues+"]");
		String detailXMLStr = null;
		
		boolean isHeaderFocusChanged = true;
		try
		{
			//This step shall create a View Dom of the transaction to be copied from.
			getDetailXMLDomString( objName, objContext, "V", pkValues, null );
			Document tempDom = this.detailDom;

			for( int formCtr = 1; formCtr <= this.noOfForms; formCtr++ )
			{
				HashMap copyColInfoMap = this.dbAccess.getCopyColInfoMap( objName , ""+formCtr );
				HashMap exclFieldNameDefValueMap = ( HashMap )copyColInfoMap.get( "N" );
				exclFieldNameDefValueMap.put( "attribute", "" );
				
				StringTokenizer pkNameTokens = new StringTokenizer( this.headerPKFieldNames, ":" );
				while( pkNameTokens.hasMoreTokens() )
				{
					exclFieldNameDefValueMap.put( pkNameTokens.nextToken(), "" );
				}//while( pkNameTokens.hasMoreTokens() )
				exclFieldNameDefValueMap.put( this.confirmCol, "" );
				
				HashMap inclFieldNameDefValueMap = ( HashMap )copyColInfoMap.get( "Y" );

				NodeList tempDomDetailNodeList = tempDom.getElementsByTagName( "Detail" + formCtr );
				int noOfRecs = tempDomDetailNodeList.getLength();

				for( int recCtr = 0; recCtr < noOfRecs; recCtr++ )
				{
					if( formCtr == 1 )
					{
						getDetailXMLDomString( objName, "" + formCtr, "A", pkValues, null );
					}
					else if( formCtr > 1 && ! exclFieldNameDefValueMap.containsKey( "*" ) )
					{
						getDetailXMLDomString( objName, "" + formCtr, "A", pkValues, null );
					}
					
					if( ! exclFieldNameDefValueMap.containsKey( "*" ) )
					{
						Node tempDomDetailNode = tempDomDetailNodeList.item( recCtr );
						if( tempDomDetailNode != null )
						{
							Node newDomDetailNode = searchNode( this.detailDom, ""+formCtr, ( ( formCtr == 1 ) ? "1" : this.detailDomId ) );
							BaseLogger.log("3", userInfo,editorId, "tempDomDetailNode :["+serializeDom( tempDomDetailNode )+"]" );
							BaseLogger.log("3", userInfo,editorId, "newDomDetailNode :["+serializeDom( newDomDetailNode )+"]" );
							copyNode( tempDomDetailNode, newDomDetailNode, exclFieldNameDefValueMap, inclFieldNameDefValueMap );
						}
					}
				}
			}
			detailXMLStr = serializeDom( this.detailDom );
			BaseLogger.log("3", userInfo,editorId, "................Copying Transaction" );
		}
		catch(Throwable e)
		{
			BaseLogger.log("3", userInfo,editorId,"Exception :MasterStatefulEJB :getTransCopyXMLString :==>\n"+e);
			e.printStackTrace();
		}
		return detailXMLStr;
	}
	*/
	
	//Added by samadhan on 28/09/2016[CO3ASUN001] for forcefully tax calculation.
	public String getTransCopyXMLString( String objName, String objContext, String pkValues, String processReqStr)throws RemoteException,ITMException, Exception
	{
		String returnCopyXml = "";	
		try
		{
			returnCopyXml = getTransCopyXMLString(objName, objContext, pkValues, processReqStr, false);
		}catch ( ITMException itme )
		{
			throw itme;
		}
		catch ( Exception e )
		{
			throw new ITMException( e );
		}
		return returnCopyXml;
	}
	//Added by samadhan on 28/09/2016[CO3ASUN001] for forcefully tax calculation.
	
	//Changed by samadhan on 28/09/2016[CO3ASUN001] for forcefully tax calculation.
	//Changed by Kunjal on 24/02/2007 to handle processrequest through copy transaction.
	//public String getTransCopyXMLString( String objName, String objContext, String pkValues, String processReqStr )throws RemoteException,ITMException, Exception
	public String getTransCopyXMLString( String objName, String objContext, String pkValues, String processReqStr, Boolean forceCalculateTax )throws RemoteException,ITMException, Exception
	{
		BaseLogger.log("2", userInfo,editorId, "Request for Transaction copy( getTransCopyXMLString ) Obj Name ["+objName+"] objContext :["+objContext+"] pkValues :["+pkValues+"] argFieldValues :["+argFieldValues+"]" ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
		String detailXMLStr = null;
		String transDB = null;
		
		boolean isHeaderFocusChanged = true;
		try
		{
			Document fromDom = null;
			if( processReqStr != null)
			{
				BaseLogger.log("3", userInfo,editorId, "Creating new copy dom setting from dom=external dom...." ); //$NON-NLS-1$
				fromDom = parseString( processReqStr );
			}
			else
			{
				BaseLogger.log("3", userInfo,editorId, "Creating new copy dom setting from dom=transactionto be copied from...." ); //$NON-NLS-1$
				getDetailXMLDomString( objName, objContext, "V", pkValues, null ); //$NON-NLS-1$
				fromDom = this.detailDom;
				//Changed by Dhruv on 06/03/2007 to set status as copying.
				this.isCopyingRec = true;
			}
			for( int formCtr = 1; formCtr <= this.noOfForms; formCtr++ )
			{
				
				HashMap copyColInfoMap=null;
				//Changes made By Sneha on 17-1-14 Pass userInfo to support multiDB connection : START
				transDB = this.userInfo.getTransDB();
				//if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
				{
					  copyColInfoMap = this.dbAccess.getCopyColInfoMap( objName , ""+formCtr, this.userInfo);
				}
				//Changes made By Sneha on 17-1-14 Pass userInfo to support multiDB connection : END

				//$NON-NLS-1$
				HashMap exclFieldNameDefValueMap = ( HashMap )copyColInfoMap.get( "N" ); //$NON-NLS-1$
				exclFieldNameDefValueMap.put( "attribute", "" ); //$NON-NLS-1$ //$NON-NLS-2$
				if( this.isCopyingRec )
				{
					StringTokenizer pkNameTokens = new StringTokenizer( this.headerPKFieldNames, ":" ); //$NON-NLS-1$
					primaryKeyList = new ArrayList<>();
					while( pkNameTokens.hasMoreTokens() )
					{
						//exclFieldNameDefValueMap.put( pkNameTokens.nextToken(), "" ); //$NON-NLS-1$
						//Added By Pankaj T. on 17-12-18 [ for avoiding override default pkField value in copy transaction ]
						primaryKeyList.add( pkNameTokens.nextToken() );
					}//while( pkNameTokens.hasMoreTokens() )
					//exclFieldNameDefValueMap.put( this.confirmCol, "" ); //$NON-NLS-1$
					//Added By Pankaj T. on 17-12-18 [ for avoiding override default pkField value in copy transaction ]
					primaryKeyList.add( this.confirmCol );
					BaseLogger.log( "3", userInfo, editorId, "primaryKeyLists in copy transaction: ["+ primaryKeyList +"]");
				}
				HashMap inclFieldNameDefValueMap = ( HashMap )copyColInfoMap.get( "Y" ); //$NON-NLS-1$

				NodeList fromDomDetailNodeList = fromDom.getElementsByTagName( "Detail" + formCtr ); //$NON-NLS-1$
				int noOfRecs = fromDomDetailNodeList.getLength();
				
//				Changed by Dhruv on 02/08/2007 to support mandatory flag default value differnet in case of all_rec fn.
				ArrayList itemChangeList =null;
				//Changes made By Sneha on 17-1-14 Pass userInfo to support multiDB connection : START
				transDB =this.userInfo.getTransDB();
				BaseLogger.log("3", userInfo,editorId,"getTransCopyXMLString.2.transDB...."+transDB);
				if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
				{
					itemChangeList = this.dbAccess.getManadatoryItemChangeElementList( this.objName, "" + formCtr, "N" ,this.userInfo); //$NON-NLS-1$ //$NON-NLS-2$
				}
				//Changes made By Sneha on 17-1-14 Pass userInfo to support multiDB connection : END
				
				for( int recCtr = 0; recCtr < noOfRecs; recCtr++ )
				{
					boolean toCopyRecord = false;
					if( formCtr == 1 )
					{
						BaseLogger.log("3", userInfo,editorId, "Creating header record....." ); //$NON-NLS-1$
						getDetailXMLDomString( objName, "" + formCtr, "A", pkValues, null ); //$NON-NLS-1$ //$NON-NLS-2$
						toCopyRecord = true;
					}
					else if( formCtr > 1 && ( ( ! this.isCopyingRec ) || ( this.isCopyingRec && ! exclFieldNameDefValueMap.containsKey( "*" ) ) ) ) //$NON-NLS-1$
					{
						BaseLogger.log("3", userInfo,editorId, "Creating detail record for form no :["+formCtr+"] record no. :[" + recCtr + "]" ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						getDetailXMLDomString( objName, "" + formCtr, "A", pkValues, null ); //$NON-NLS-1$ //$NON-NLS-2$
						toCopyRecord = true;
					}
					if( toCopyRecord )
					{
						Node fromDomDetailNode = fromDomDetailNodeList.item( recCtr );
						if( fromDomDetailNode != null )
						{
							//Changed by Prasad on 02/11/16 [to search node from dbId]
							//Node newDomDetailNode = searchNode( this.detailDom, ""+formCtr, ( ( formCtr == 1 ) ? "1" : this.detailDomId ) ); //$NON-NLS-1$ //$NON-NLS-2$
							Node newDomDetailNode = searchNode( this.detailDom, ""+formCtr, ( ( formCtr == 1 ) ? "1" : this.detailDomId ), "" ); //$NON-NLS-1$ //$NON-NLS-2$
							
							String fromDomId = fromDomDetailNode.getAttributes().getNamedItem( "domID" ).getNodeValue();
							BaseLogger.log("3", userInfo,editorId, "fromDomId - ["+ fromDomId +"], recCtr - ["+ recCtr	+"]" );
							
							//Changed by samadhan on 28/09/2016[CO3ASUN001] for forcefully tax calculation.
							//Changed by samadhan on 09/09/2016[S15LBAS001] for force tax calculation
							//String copyStatusStr = copyRecord( fromDomDetailNode, newDomDetailNode, exclFieldNameDefValueMap, inclFieldNameDefValueMap, itemChangeList, "" + formCtr ); //$NON-NLS-1$
							//String copyStatusStr = copyRecord( fromDomDetailNode, newDomDetailNode, exclFieldNameDefValueMap, inclFieldNameDefValueMap, itemChangeList, "" + formCtr,false );
							String copyStatusStr = copyRecord( fromDomDetailNode, newDomDetailNode, exclFieldNameDefValueMap, inclFieldNameDefValueMap, itemChangeList, "" + formCtr, forceCalculateTax );
							if( copyStatusStr.indexOf("<Errors>") != -1 ) //$NON-NLS-1$
							{
								return copyStatusStr;
							}
						}
					}
				}
				//Added By Pankaj T. on 17-12-18 [ for avoiding override default pkField value in copy transaction ]
				primaryKeyList.clear();
			}
			detailXMLStr = serializeDom( this.detailDom );
			BaseLogger.log("3", userInfo,editorId, "-------------- Copying Transaction Complete ---------------- " ); //$NON-NLS-1$
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :getTransCopyXMLString :==>\n"+e); //$NON-NLS-1$
			e.printStackTrace();
			throw e;
		}
		return detailXMLStr;
	}

	//Changed By Dhruv on 27/12/2006 logic changed.
	public String getDetailCopyXMLString( String domId, String objContext ) throws  RemoteException, ITMException
	{
		BaseLogger.log("2", userInfo,editorId, "Request for Detail copy(getDetailCopyXMLString) Line no/domId ["+domId+"] objContext :["+objContext+"]" ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		String copyXMLStr = ""; //$NON-NLS-1$
		try
		{
			BaseLogger.log("3", userInfo,editorId,"Inside MasterStatefulEjb getDetailCopyXMLString line 9387 this.objName ["+this.objName+"]");
			getDetailXMLDomString( this.objName, objContext, "A", null, null ); //$NON-NLS-1$
			//BaseLogger.log("3", userInfo,editorId, "Current detail dom after appended balnk dom for detail :[" + serializeDom( this.detailDom ) + "]" );
			//Changed by Pankaj T on 04-01-18 [changes for multitenancy]
			HashMap copyColInfoMap = this.dbAccess.getCopyColInfoMap( objName , objContext, this.userInfo );
			HashMap exclFieldNameDefValueMap = ( HashMap )copyColInfoMap.get( "N" ); //$NON-NLS-1$
			exclFieldNameDefValueMap.put( "attribute", "" ); //$NON-NLS-1$ //$NON-NLS-2$
			exclFieldNameDefValueMap.put( "line_no", "" ); //$NON-NLS-1$ //$NON-NLS-2$
			HashMap inclFieldNameDefValueMap = ( HashMap )copyColInfoMap.get( "Y" ); //$NON-NLS-1$
			//Changed by Prasad on 02/11/16 [to search node from dbId]
			//Node newDomDetailNode = searchNode( this.detailDom, objContext, this.detailDomId );
			Node newDomDetailNode = searchNode( this.detailDom, objContext, this.detailDomId, "" );
			if( ! exclFieldNameDefValueMap.containsKey( "*" ) ) //$NON-NLS-1$
			{
				//Changed by Prasad on 02/11/16 [to search node from dbId]
				//Node fromDomDetailNode = searchNode( this.detailDom, this.objContext, domId );
				Node fromDomDetailNode = searchNode( this.detailDom, this.objContext, domId, "" );
				//Changed by Kunjal on 21-02-07. [Change in method signature.]
				//copyNode( fromDomDetailNode, newDomDetailNode, exclFieldNameDefValueMap, inclFieldNameDefValueMap );
				//Changed by samadhan on 09/09/2016[S15LBAS001] for force tax calculation
				//String copyStatusStr = copyRecord( fromDomDetailNode, newDomDetailNode, exclFieldNameDefValueMap, inclFieldNameDefValueMap, null, objContext );
				String copyStatusStr = copyRecord( fromDomDetailNode, newDomDetailNode, exclFieldNameDefValueMap, inclFieldNameDefValueMap, null, objContext,false );
				//BaseLogger.log("3", userInfo,editorId, "Current detail dom after copying data to blank dom for detail :[" + serializeDom( this.detailDom ) + "]" );
				if( copyStatusStr.indexOf("<Errors>") != -1 ) //$NON-NLS-1$
				{
					return copyStatusStr;
				}
			}
			copyXMLStr = getNormalizedString( serializeDom( newDomDetailNode ) );
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		BaseLogger.log("2", userInfo,editorId, "-------------- Copying Detail Complete ---------------- " ); //$NON-NLS-1$
		return copyXMLStr;
	}

	/*
	private boolean copyNode( Node fromNode, Node toNode, HashMap exclusionMap, HashMap inclusionMap )throws ITMException
	{
		try
		{
			BaseLogger.log("3", userInfo,editorId, "before copying toNode :["+serializeDom(toNode)+"]" );
			NodeList fromColNodeList = fromNode.getChildNodes();
			int fromColNodeLength = fromColNodeList.getLength();
			NodeList toColNodeList = toNode.getChildNodes();
			int toColNodeLength = toColNodeList.getLength();
			for( int fromColNodeCtr = 0; fromColNodeCtr < fromColNodeLength; fromColNodeCtr++ )
			{
				//Assuming the sequence of columns in dom careted in View mode and Add mode is exactly the same.
				//if this assumption is wrong then iterate through the toNode's child nodes to find the node with the same name as that of the from node name.
				Node currFromColNode = fromColNodeList.item( fromColNodeCtr );
				String currFromColNodeName = null;
				if( currFromColNode.getNodeType() == Node.ELEMENT_NODE  )
				{
					currFromColNodeName = currFromColNode.getNodeName();
					for( int toColNodeCtr = 0; toColNodeCtr < toColNodeLength; toColNodeCtr++)
					{
						Node currToColNode = toColNodeList.item( toColNodeCtr );
						String currToColNodeName = null;
						if( currToColNode.getNodeType() == Node.ELEMENT_NODE  )
						{
							currToColNodeName = currToColNode.getNodeName();
							if( currFromColNodeName.equals( currToColNodeName ) )
							{
								BaseLogger.log("3", userInfo,editorId, "currFromColNodeName :["+currFromColNodeName+"] currToColNodeName :["+currToColNodeName+"]" );
								if( exclusionMap.containsKey( currFromColNodeName ) )
								{
									if( exclusionMap.get( currFromColNodeName ) != null )
									{
										currToColNode.setNodeValue( (String)exclusionMap.get( currFromColNodeName ) );
									}
								}
								else
								{
									String nodeValue = "";
									if( currFromColNode.getFirstChild() != null )
									{
										BaseLogger.log("3", userInfo,editorId, "currFromColNode.getNodeValue()  :["+ currFromColNode.getFirstChild().getNodeValue() +"]" );
										nodeValue = currFromColNode.getFirstChild().getNodeValue();
									}
									Node currToColValueNode = currToColNode.getFirstChild();
									if( currToColValueNode != null && currToColValueNode.getNodeValue() != null)
									{
										currToColValueNode.setNodeValue( nodeValue );
									}
									else
									{
										CDATASection cDataSection = this.detailDom.createCDATASection( nodeValue );
										currToColNode.appendChild( cDataSection );
									}
								}
								break;
							}
						}
					}
				}
			}
			BaseLogger.log("3", userInfo,editorId, "after copying toNode :["+serializeDom(toNode)+"]" );
			
		}
		catch ( Exception e )
		{
			throw new ITMException( e );
		}
		return false;
	}
	*/
	
	//Changed by samadhan on 09/09/2016[S15LBAS001] for force tax calculation
	//Changed by Kunjal on 24/02/2007 to handle processrequest through copy transaction.
	//private String copyRecord( Node fromNode, Node toNode, HashMap exclusionMap, HashMap inclusionMap, ArrayList currItemChangeList, String currFormNo )throws ITMException
	private String copyRecord( Node fromNode, Node toNode, HashMap exclusionMap, HashMap inclusionMap, ArrayList currItemChangeList, String currFormNo,boolean forceCalculateTax )throws ITMException
	{
		String retString = ""; //$NON-NLS-1$
		BaseLogger.log("2", userInfo,editorId, "Copying Invoked for currFormNo :["+currFormNo+"] current headerDomId :["+this.headerDomId+"] current detailDomId :["+this.detailDomId+"]" ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
		try
		{
			String allItemChgFieldNames = ""; //$NON-NLS-1$
			String formNo = null;
			String domIdStr = null;
			StringBuffer dtlStrBuff =new StringBuffer();
			String childString = null;
			
			NodeList fromColNodeList = fromNode.getChildNodes();
			int fromColNodeLength = fromColNodeList.getLength();
			NodeList toColNodeList = toNode.getChildNodes();
			int toColNodeLength = toColNodeList.getLength();
			formNo = currFormNo;
			Date startTime = new Date();
			
			//DANISH 0n 02JUL15
			String updateFlag = "";
			//Added By Samadhan on 09/09/2016[S15LBAS001] for tax Calculation start.
			Node fromTaxesNode = null;
			NodeList fromTaxesNodeList = null;
			Element fromElemntNode = null;
			Node toTaxesNode = null;
			NodeList toTaxesNodeList = null;
			Element toElemntNode = null;
			//Added By Samadhan on 09/09/2016[S15LBAS001] for tax Calculation end.
			//Added By Pankaj T on 02-11-17 [To resolved issue of creating dwObject multiple times] - Start 
			DWObject dwObject = getDWObject( this.objName, Integer.parseInt( formNo.trim() ) );
			Hashtable dbTypes = dwObject.getUpdateableLogNameColType();
			//Added By Pankaj T on 02-11-17 [To resolved issue of creating dwObject multiple times] - End
			
			//Added By Ravindra C on 22-12-18 [to restrict the itemChange if currentvalue and previous value is same]
			E12GenericUtility genericUtility = new E12GenericUtility();
			
			String domId = "";
			for( int fromColNodeCtr = 0; fromColNodeCtr < fromColNodeLength; fromColNodeCtr++ )
			{
				Node currFromColNode = fromColNodeList.item( fromColNodeCtr );
				//BaseLogger.log("3", userInfo,editorId, "currFromColNode :["+serializeDom( currFromColNode )+"]" );
				String currFromColNodeName = null;
				if( currFromColNode.getNodeType() == Node.ELEMENT_NODE  )
				{
					currFromColNodeName = currFromColNode.getNodeName();
					
					//Added By Ravindra C on 22-12-18 [to restrict the itemChange if currentvalue and previous value is same] START
					NamedNodeMap currNodeAttrMap = currFromColNode.getAttributes();
					String isDataUpload = "false";
					if ( currNodeAttrMap.getNamedItem( "isDataUpload" ) != null )
					{
						isDataUpload = currNodeAttrMap.getNamedItem( "isDataUpload" ).getNodeValue();
					}
					BaseLogger.log( "3", userInfo, editorId, "isDataUpload - ["+ isDataUpload +"]" );
					//Added By Ravindra C on 22-12-18 [to restrict the itemChange if currentvalue and previous value is same] END
					//DANISH 0n 02JUL15 set the updateFlag : START
					if( "attribute".equalsIgnoreCase( currFromColNodeName ) )
					{
						updateFlag = ((currFromColNode.getAttributes()).getNamedItem("updateFlag")).getNodeValue();
						//Changed by Prasad on 02/11/16 [to search node from dbId]
						//Node nodeToSetFlag = searchNode(this.detailDom, currFormNo , fromNode.getAttributes().getNamedItem("domID").getNodeValue() );
						String dbId = fromNode.getAttributes().getNamedItem("dbID").getNodeValue();
						//Added by Prasad on 16/11/18 [audit trail implementation for non-itemchange field related changes]
						domId = fromNode.getAttributes().getNamedItem("domID").getNodeValue();
						Node nodeToSetFlag = searchNode(this.detailDom, currFormNo, domId, dbId );
						//Gulzar on 02/10/15 - Check for null to avoid NullPointerException
						if( nodeToSetFlag != null )
						{
							NodeList nodeToSetFlagList = nodeToSetFlag.getChildNodes();
							int nodeToSetFlagListLen = nodeToSetFlagList.getLength();
							for ( int i=0; i < nodeToSetFlagListLen; i++  )
							{
								String currNodeName = nodeToSetFlagList.item(i).getNodeName();
								if( "attribute".equalsIgnoreCase( currNodeName ) )
								{
									BaseLogger.log("3", userInfo, editorId, "setting ["+updateFlag+"] to detailDom for formNo ["+ currFormNo +"] domId ["+ domId +"]" );
									(nodeToSetFlagList.item(i)).getAttributes().getNamedItem("updateFlag").setNodeValue( updateFlag );
									break;
								}
							}
						}
					}
					//DANISH 0n 02JUL15 set the updateFlag : END
					//Added by Prasad on 11/04/17 [to set fromnode from updated detail dom] START
					else if( isFileUpload() )
					{
						//Added by Prasad on 27/07/17 [to set fromnode from updated detail dom only in case add mode] START
						/*NamedNodeMap currNodeAttrMap = currFromColNode.getAttributes();
						String isDataUpload = "false";
						if ( currNodeAttrMap.getNamedItem( "isDataUpload" ) != null )
						{
							isDataUpload = currNodeAttrMap.getNamedItem( "isDataUpload" ).getNodeValue();
						}
						BaseLogger.log("3", userInfo,editorId, "isDataUpload - ["+ isDataUpload +"]" );*/
						//Changed by Prasad on 19/0/2020 [to reolve upload issue in add mode if isDataUpload attribute is missing]
						//if ( ! "true".equalsIgnoreCase( isDataUpload ) )
						//Changed by Prasad on 13/01/2021 [to resolve the blank line_no related issue while saving]
						if ( ! "true".equalsIgnoreCase( isDataUpload ) && ( "line_no".equalsIgnoreCase( currFromColNodeName ) || ! this.editFlag.equals( "A" ) ) )
						{
							//Added by Prasad on 27/07/17 [to set fromnode from updated detail dom only in case add mode] END
							String dbId = fromNode.getAttributes().getNamedItem("dbID").getNodeValue();
							Node nodeToSetFlag = searchNode(this.detailDom, currFormNo , fromNode.getAttributes().getNamedItem("domID").getNodeValue(), dbId );
							//BaseLogger.log("3", userInfo,editorId, "fromColNodeCtr - ["+ fromColNodeCtr +"], 7778" );
							if(nodeToSetFlag != null)
							{
								//BaseLogger.log("3", userInfo,editorId, "fromColNodeCtr - ["+ fromColNodeCtr +"], nodeToSetFlag :["+serializeDom( nodeToSetFlag )+"], 7781" );
								NodeList tempNodeList = nodeToSetFlag.getChildNodes();
								int tempNodeLen = tempNodeList.getLength();
								for( int i = 0; i < tempNodeLen; i++ )
								{
									Node tempNode = tempNodeList.item( i );
									if( tempNode.getNodeType() == Node.ELEMENT_NODE  )
									{
										String tempNodeName = tempNode.getNodeName();
										//BaseLogger.log("3", userInfo,editorId, "i - ["+ i +"], tempNodeName :["+ tempNodeName +"], 7751" );
										if ( tempNodeName.equals( currFromColNodeName ) )
										{
											//BaseLogger.log("3", userInfo,editorId, "i - ["+ i +"], tempNode :["+serializeDom( tempNode )+"], 7758" );
											currFromColNode = tempNode;
											break;
										}
									}
								}
							}
						}
					}
					//Added by Prasad on 11/04/17 [to set fromnode from updated detail dom] END
					if( currItemChangeList != null && currItemChangeList.contains( currFromColNodeName ) )
					{
						BaseLogger.log( "3", userInfo, editorId, "currFromColNodeName : ["+currFromColNodeName+"]" );
						if( isDataUpload() )
						{
							//added by Ravindra c on 21-01-19 to restrict itmChange for protrected field.
							//String isProtected = checkIsProtected( fromNode, currFromColNodeName, currFormNo );
							//BaseLogger.log( "3", userInfo, editorId, "isProtected : ["+isProtected+"]" );
							
							//Added By Ravindra C on 22-12-18 [to restrict the itemChange if currentvalue and previous value is same] - Start
							String fromNodeValue = genericUtility.getColumnValueFromNode( currFromColNodeName, fromNode );
							String toNodeValue = genericUtility.getColumnValueFromNode( currFromColNodeName, toNode );
							BaseLogger.log("3", userInfo, editorId, "fromNodeValue : ["+ fromNodeValue + "] toNodeValue ["+ toNodeValue +"]");
							BaseLogger.log("3", userInfo, editorId, "updateFlag : ["+ updateFlag +"], editFlag : ["+ this.editFlag +"], localEditFlag : ["+ this.localEditFlag + "]");
							//if ( fromNodeValue != null && fromNodeValue.equalsIgnoreCase( toNodeValue ) && ! updateFlag.equals( "A" ) && !isProtected.trim().equals("1") )
							//Changed by Prasad on 19/0/2020 [to reolve upload issue in add mode using old upload utility, updateFlag 'N' condition added]
							//if ( fromNodeValue != null && fromNodeValue.equalsIgnoreCase( toNodeValue ) && ! updateFlag.equals( "A" ) )
							if ( fromNodeValue != null && fromNodeValue.equalsIgnoreCase( toNodeValue ) && ! "A".equalsIgnoreCase( updateFlag ) && ! "N".equalsIgnoreCase( updateFlag ) )
							{
								BaseLogger.log( "3", userInfo, editorId, "item change not performed for :["+currFromColNodeName+"], as current and previous value is same" );
								continue;
							}
							//Added By Ravindra C on 22-12-18 [to restrict the itemChange if currentvalue and previous value is same] - End
							//Added By Ravindra C on 15-07-18 [to restrict the itemChange if editflag is E and item_change  filed is Primary fileld] - Start
							//Changed by Prasad on 19/0/2020 [to reolve upload issue in add mode using old upload utility, updateFlag 'N' condition added]
							//if( headerPKFieldNames != null && headerPKFieldNames.contains( currFromColNodeName ) && ! updateFlag.equals( "A" ) )
							if( headerPKFieldNames != null && headerPKFieldNames.contains( currFromColNodeName ) && ! "A".equalsIgnoreCase( updateFlag ) && ! "N".equalsIgnoreCase( updateFlag ) )
							{
								BaseLogger.log( "3", userInfo, editorId, "item change not performed for :["+ currFromColNodeName +"], as a primary key field" );
								continue;
							}
							//Added By Ravindra C on 15-07-18 [to restrict the itemChange if editflag is E and item_change  filed is Primary fileld] - End
							
							//Added By Ravindra C on 22-12-18 [to restrict the itemChange if currentvalue and previous value is same]
							//Added by Pankaj T on 08/06/17 [to perform itemchanged only for uploaded xml field when isDataUpload flag true] START
							//if((currFromColNode.getAttributes().getNamedItem("isDataUpload") != null && "true".equalsIgnoreCase(currFromColNode.getAttributes().getNamedItem("isDataUpload").getNodeValue())) || (this.editFlag.equals("A")))
							if( "true".equalsIgnoreCase( isDataUpload ) || this.editFlag.equals("A") )
							{
								BaseLogger.log("3", userInfo,editorId, "item change performed for :["+currFromColNodeName+"]" );
								StringBuffer hdrStrBuff = new StringBuffer();
								hdrStrBuff.append( "<header>" ); //$NON-NLS-1$
								hdrStrBuff.append( "<objName><![CDATA[" + this.objName + "]]></objName>" ); //$NON-NLS-1$ //$NON-NLS-2$
								hdrStrBuff.append( "<pageContext><![CDATA[2]]></pageContext>" ); //$NON-NLS-1$
								hdrStrBuff.append( "<editFlag><![CDATA[" + this.editFlag + "]]></editFlag>" ); //$NON-NLS-1$ //$NON-NLS-2$
								hdrStrBuff.append( "<action><![CDATA[SAVE]]></action>" ); //$NON-NLS-1$
								hdrStrBuff.append( "<elementName><![CDATA[]]></elementName>" ); //$NON-NLS-1$
								hdrStrBuff.append( "<taxKeyValue><![CDATA[]]></taxKeyValue>" ); //$NON-NLS-1$
								hdrStrBuff.append( "<taxInFocus><![CDATA[false]]></taxInFocus>" ); //$NON-NLS-1$

								hdrStrBuff.append("<objContext><![CDATA["+formNo+"]]></objContext>"); //$NON-NLS-1$ //$NON-NLS-2$

								allItemChgFieldNames = ""; //$NON-NLS-1$

								hdrStrBuff.append("<focusedColumn><![CDATA["+currFromColNodeName+"]]></focusedColumn>"); //$NON-NLS-1$ //$NON-NLS-2$
								hdrStrBuff.append("<forcedSave><![CDATA[false]]></forcedSave>"); //$NON-NLS-1$

								//Danish on 02JUL15
								//Changed by Prasad on 15/06/17 [changes reverted getting issue in taxCalculation as per Danish Sir]
								hdrStrBuff.append("<keyValue><![CDATA[" + ( ( formNo.equals( "1" ) ) ? "1" : this.detailDomId ) + "]]></keyValue>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
								//hdrStrBuff.append("<keyValue><![CDATA[" + ( ( formNo.equals( "1" ) ) ? "1" : fromNode.getAttributes().getNamedItem("domID").getNodeValue() ) + "]]></keyValue>");

								hdrStrBuff.append("<saveLevel><![CDATA[0]]></saveLevel>"); //$NON-NLS-1$

								StringBuffer chgStringBuff = new StringBuffer();
								if( currFromColNode != null )
								{
									chgStringBuff.append( "<Detail>" ); //$NON-NLS-1$
									chgStringBuff.append( serializeDom( currFromColNode ) );
									chgStringBuff.append( "</Detail>" ); //$NON-NLS-1$
								}

								childString ="<Root>" + hdrStrBuff.toString() + "</header>" + chgStringBuff.toString() + "</Root>"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
								BaseLogger.log("3", userInfo,editorId, "copyRecord - childString - ["+ childString +"]" );
								startTime = new Date();
								//Changed by Samadhan on 28/07/2016[S15LBAS001] for Stop itemChanged for updateFlag="D" start
								//retString = applyItemChange( childString );
								if(!updateFlag.equalsIgnoreCase("D"))
								{
									retString = applyItemChange( childString );
								}
								else
								{
									retString = "";
								}
								//Changed by Samadhan on 28/07/2016[S15LBAS001] for Stop itemChanged for updateFlag="D" End
								if( retString.indexOf("<Errors>") != -1) //$NON-NLS-1$
								{
									NodeList errorNodeItemChgList = new E12GenericUtility().parseString( retString ).getElementsByTagName( "error" ); //$NON-NLS-1$
									boolean isErrorNodeFound = false;
									String reqForcedFlag = "true"; //$NON-NLS-1$
									int errorNodeItemChgListLen = errorNodeItemChgList.getLength();
									for (int i=0; i < errorNodeItemChgListLen; i++)
									{
										Node errorNode = errorNodeItemChgList.item(i);
										String itemChgErrorType = errorNode.getAttributes().getNamedItem("type").getNodeValue(); //$NON-NLS-1$
										if( ( "E" ).equals( itemChgErrorType ) ) //$NON-NLS-1$
										{
											BaseLogger.log("3", userInfo,editorId,"--------------- EEE RRR RRR OOO RRR (itemChange)----------  isErrorNodeFound ["+isErrorNodeFound+"]"); //$NON-NLS-1$ //$NON-NLS-2$
											//throw new Exception( errorNode.getChildNodes().item( 0 ).getFirstChild().getNodeValue() );
											return retString;
										}

									}
								}
							}
							else
							{
								BaseLogger.log("3", userInfo,editorId, "item change not performed for :["+currFromColNodeName+"]" );
							}
							//Added by Pankaj T on 08/06/17 [to perform itemchanged only for uploaded xml field when isDataUpload flag true] END
						}
						else
						{
							StringBuffer hdrStrBuff = new StringBuffer();
							hdrStrBuff.append( "<header>" ); //$NON-NLS-1$
							hdrStrBuff.append( "<objName><![CDATA[" + this.objName + "]]></objName>" ); //$NON-NLS-1$ //$NON-NLS-2$
							hdrStrBuff.append( "<pageContext><![CDATA[2]]></pageContext>" ); //$NON-NLS-1$
							hdrStrBuff.append( "<editFlag><![CDATA[" + this.editFlag + "]]></editFlag>" ); //$NON-NLS-1$ //$NON-NLS-2$
							hdrStrBuff.append( "<action><![CDATA[SAVE]]></action>" ); //$NON-NLS-1$
							hdrStrBuff.append( "<elementName><![CDATA[]]></elementName>" ); //$NON-NLS-1$
							hdrStrBuff.append( "<taxKeyValue><![CDATA[]]></taxKeyValue>" ); //$NON-NLS-1$
							hdrStrBuff.append( "<taxInFocus><![CDATA[false]]></taxInFocus>" ); //$NON-NLS-1$

							hdrStrBuff.append("<objContext><![CDATA["+formNo+"]]></objContext>"); //$NON-NLS-1$ //$NON-NLS-2$

							allItemChgFieldNames = ""; //$NON-NLS-1$

							hdrStrBuff.append("<focusedColumn><![CDATA["+currFromColNodeName+"]]></focusedColumn>"); //$NON-NLS-1$ //$NON-NLS-2$
							hdrStrBuff.append("<forcedSave><![CDATA[false]]></forcedSave>"); //$NON-NLS-1$

							//Danish on 02JUL15
							//Changed by Prasad on 15/06/17 [changes reverted getting issue in taxCalculation as per Danish Sir]
							hdrStrBuff.append("<keyValue><![CDATA[" + ( ( formNo.equals( "1" ) ) ? "1" : this.detailDomId ) + "]]></keyValue>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
							//hdrStrBuff.append("<keyValue><![CDATA[" + ( ( formNo.equals( "1" ) ) ? "1" : fromNode.getAttributes().getNamedItem("domID").getNodeValue() ) + "]]></keyValue>");

							hdrStrBuff.append("<saveLevel><![CDATA[0]]></saveLevel>"); //$NON-NLS-1$

							StringBuffer chgStringBuff = new StringBuffer();
							if( currFromColNode != null )
							{
								chgStringBuff.append( "<Detail>" ); //$NON-NLS-1$
								chgStringBuff.append( serializeDom( currFromColNode ) );
								chgStringBuff.append( "</Detail>" ); //$NON-NLS-1$
							}

							childString ="<Root>" + hdrStrBuff.toString() + "</header>" + chgStringBuff.toString() + "</Root>"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
							BaseLogger.log("3", userInfo,editorId, "copyRecord - childString - ["+ childString +"]" );
							startTime = new Date();
							//Changed by Samadhan on 28/07/2016[S15LBAS001] for Stop itemChanged for updateFlag="D" start
							//retString = applyItemChange( childString );
							if(!updateFlag.equalsIgnoreCase("D"))
							{
								retString = applyItemChange( childString );
							}
							else
							{
								retString = "";
							}
							//Changed by Samadhan on 28/07/2016[S15LBAS001] for Stop itemChanged for updateFlag="D" End
							if( retString.indexOf("<Errors>") != -1) //$NON-NLS-1$
							{
								NodeList errorNodeItemChgList = new E12GenericUtility().parseString( retString ).getElementsByTagName( "error" ); //$NON-NLS-1$
								boolean isErrorNodeFound = false;
								String reqForcedFlag = "true"; //$NON-NLS-1$
								int errorNodeItemChgListLen = errorNodeItemChgList.getLength();
								for (int i=0; i < errorNodeItemChgListLen; i++)
								{
									Node errorNode = errorNodeItemChgList.item(i);
									String itemChgErrorType = errorNode.getAttributes().getNamedItem("type").getNodeValue(); //$NON-NLS-1$
									if( ( "E" ).equals( itemChgErrorType ) ) //$NON-NLS-1$
									{
										BaseLogger.log("3", userInfo,editorId,"--------------- EEE RRR RRR OOO RRR (itemChange)----------  isErrorNodeFound ["+isErrorNodeFound+"]"); //$NON-NLS-1$ //$NON-NLS-2$
										//throw new Exception( errorNode.getChildNodes().item( 0 ).getFirstChild().getNodeValue() );
										return retString;
									}
								}
							}
						}
						BaseLogger.log("3", userInfo,editorId, "--------- 14 --------- item change performed for :["+currFromColNodeName+"]" ); //$NON-NLS-1$ //$NON-NLS-2$
					}
					else
					{
						BaseLogger.log("3", userInfo,editorId, "item change not defined for column :["+currFromColNodeName+"]" ); //$NON-NLS-1$ //$NON-NLS-2$
						for( int toColNodeCtr = 0; toColNodeCtr < toColNodeLength; toColNodeCtr++ )
						{
							Node currToColNode = toColNodeList.item( toColNodeCtr );
							String currToColNodeName = null;
							if( currToColNode.getNodeType() == Node.ELEMENT_NODE  )
							{
								currToColNodeName = currToColNode.getNodeName();
								if( currFromColNodeName.equals( currToColNodeName ) )
								{
									//Danish on 02JUL15 : START
									if( "attribute".equalsIgnoreCase( currFromColNodeName ) )
									{
										BaseLogger.log("3", userInfo,editorId,"setting "+updateFlag+" to detailDom for formNo [" + currFormNo + "] node ["+fromNode.getAttributes().getNamedItem("domID").getNodeValue()+"]" );
										currToColNode.getAttributes().getNamedItem("updateFlag").setNodeValue( updateFlag );
										
										BaseLogger.log("3", userInfo,editorId,"After Setting...node ["+currToColNode.getAttributes().getNamedItem("updateFlag").getNodeValue()+"]" );
									}
									//BaseLogger.log("3", userInfo,editorId,"Is DetailDomUpdated ["+serializeDom( this.detailDom )+"]");
									//Danish on 02JUL15 : END
									
									BaseLogger.log("3", userInfo,editorId,"isTransCopy flag:["+this.isTransCopy+"]");
									BaseLogger.log("3", userInfo,editorId,"isDataUpload flag:["+this.isDataUpload+"]");
									//Changed By Pankaj T on 16-03-17 [ Check transCopy flag for Copy Transaction ]
									//if( exclusionMap != null && exclusionMap.containsKey( currFromColNodeName ) )
									//Changed By Pankaj T on 31-07-18 [ Checked transCopy flag for Copy Transaction & dataUpload]
									String nodeValue = "";
									
									//Changed By Ravindra C on 12-07-19 to remove TRANS_COPY_SETUP related logic while uploading.
									//if( exclusionMap != null && exclusionMap.containsKey( currFromColNodeName ) && ( this.isTransCopy == true || this.isDataUpload ) )
									if( exclusionMap != null && exclusionMap.containsKey( currFromColNodeName ) && ( this.isTransCopy == true ) ) //RAVINDRA CHANGES : 
									{
										if( exclusionMap.get( currFromColNodeName ) != null )
										{
											nodeValue = (String)exclusionMap.get( currFromColNodeName );
											//Changed By Pankaj T. on 06-04-18 resolving issue of firstChild nodeValue is null then value is not set to Node - Start 
											if( currToColNode != null )
											{
												if(currToColNode.getFirstChild() != null && currToColNode.getFirstChild().getNodeValue() != null)
												{
													currToColNode.getFirstChild().setNodeValue( nodeValue );
												}
												else
												{
													currToColNode.setTextContent( nodeValue );
												}
											}
											//Changed By Pankaj T. on 06-04-18 resolving issue of firstChild nodeValue is null then value is not set to Node - End
										}
									}
									else
									{
										//String nodeValue = ""; //$NON-NLS-1$
										if( currFromColNode.getFirstChild() != null )
										{
											nodeValue = currFromColNode.getFirstChild().getNodeValue();
										}
										Node currToColValueNode = currToColNode.getFirstChild();
										//Changed by Monif on 08/02/2008 [Start if portion. Applying Change on XMLTYPE data]Start
										/*if( currToColValueNode != null && currToColValueNode.getNodeValue() != null)
										{
											currToColValueNode.setNodeValue( nodeValue );
											
										}*/
										//Changed by Monif on 8/28/2008 [Applying Changeon XMLTYPE data if Edit Flag ="A"]Start.
										//Commented By Pankaj T on 02-11-17 [for resolving issue of creating dwObject multiple times] - Start
										/*DWObject dwObject = getDWObject( this.objName, Integer.parseInt( formNo.trim() ) );
										Hashtable dbTypes = dwObject.getUpdateableLogNameColType();*/
										//Commented By Pankaj T on 02-11-17 [for resolving issue of creating dwObject multiple times] - End
										String dataType = (String)dbTypes.get(currFromColNodeName);
										//Changed by Monif on 8/28/2008 [Applying Changeon XMLTYPE data if Edit Flag ="A"]End.
										if( currToColValueNode != null )
										{
											if ( currToColValueNode.getNodeValue() != null )
											{
												//Added By Pankaj T. on 17-12-18 [ for avoiding override default pkField value in copy transaction ] - start
												if( this.isCopyingRec )
												{
													if( primaryKeyList != null && !(primaryKeyList.contains( currFromColNodeName )) )
													{
														currToColValueNode.setNodeValue( nodeValue );
													}
												}
												else
												{
													currToColValueNode.setNodeValue( nodeValue );
												}
												//Added By Pankaj T. on 17-12-18 [ for avoiding override default pkField value in copy transaction ] - end
											}
											else
											{
												//Changed by Monif on 8/28/2008 [Applying Changeon XMLTYPE data if Edit Flag ="A" Commented].
												/*DWObject dwObject = getDWObject( this.objName, Integer.parseInt( formNo.trim() ) );
												Hashtable dbTypes = dwObject.getUpdateableLogNameColType();
												String dataType = (String)dbTypes.get(currFromColNodeName);*/

												if ( dataType !=null && dataType.length() > 0 )
												{
													if ( dataType.toUpperCase().indexOf("XMLTYPE") != -1 ) //$NON-NLS-1$
													{
														currToColValueNode.setNodeValue( serializeDom( currFromColNode ) );
														if ( !(serializeDom( currFromColNode ) ).equalsIgnoreCase( serializeDom( currToColNode ) ) )
														{
															StringBuffer hdrStrBuff = new StringBuffer();
															hdrStrBuff.append( "<header>" ); //$NON-NLS-1$
															hdrStrBuff.append( "<objName><![CDATA[" + this.objName + "]]></objName>" ); //$NON-NLS-1$ //$NON-NLS-2$
															hdrStrBuff.append( "<pageContext><![CDATA[2]]></pageContext>" ); //$NON-NLS-1$
															hdrStrBuff.append( "<editFlag><![CDATA[" + this.editFlag + "]]></editFlag>" ); //$NON-NLS-1$ //$NON-NLS-2$
															hdrStrBuff.append( "<action><![CDATA[SAVE]]></action>" ); //$NON-NLS-1$
															hdrStrBuff.append( "<elementName><![CDATA[]]></elementName>" ); //$NON-NLS-1$
															hdrStrBuff.append( "<taxKeyValue><![CDATA[]]></taxKeyValue>" ); //$NON-NLS-1$
															hdrStrBuff.append( "<taxInFocus><![CDATA[false]]></taxInFocus>" ); //$NON-NLS-1$
															hdrStrBuff.append("<objContext><![CDATA["+formNo+"]]></objContext>"); //$NON-NLS-1$ //$NON-NLS-2$
															allItemChgFieldNames = "";	hdrStrBuff.append("<focusedColumn><![CDATA["+currFromColNodeName+"]]></focusedColumn>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
															hdrStrBuff.append("<forcedSave><![CDATA[false]]></forcedSave>"); //$NON-NLS-1$
															hdrStrBuff.append("<keyValue><![CDATA[" + ( ( formNo.equals( "1" ) ) ? "1" : fromNode.getAttributes().getNamedItem("domID").getNodeValue() ) + "]]></keyValue>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
															hdrStrBuff.append("<saveLevel><![CDATA[0]]></saveLevel>");			 //$NON-NLS-1$
															StringBuffer chgStringBuff = new StringBuffer();
															if( currFromColNode != null )
															{
																chgStringBuff.append( "<Detail>" ); //$NON-NLS-1$
																chgStringBuff.append( serializeDom( currFromColNode ) );
																chgStringBuff.append( "</Detail>" ); //$NON-NLS-1$
															}						
															childString ="<Root>" + hdrStrBuff.toString() + "</header>" + chgStringBuff.toString() + "</Root>";	 //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
															BaseLogger.log("3", userInfo,editorId, "childString - ["+ childString +"]" );
															startTime = new Date();
															//Changed by Samadhan on 28/07/2016[S15LBAS001] for Stop itemChanged for updateFlag="D" start
															//retString = applyItemChange( childString );
															if(!updateFlag.equalsIgnoreCase("D"))
															{
																retString = applyItemChange( childString );
															}
															else
															{
																retString = "";
															}
															//Changed by Samadhan on 28/07/2016[S15LBAS001] for Stop itemChanged for updateFlag="D" End
														}						
													}
												}
											}											
										}//Changed by Monif on 08/02/2008 [End of changed if portion Applying Changeon XMLTYPE data ]End.		
										else
										{	
											//Changed by Monif on 8/28/2008 [Applying Changeon XMLTYPE data if Edit Flag ="A"]Start.
											if ( dataType !=null && dataType.length() > 0 )
											{
												if ( dataType.toUpperCase().indexOf("XMLTYPE") != -1 ) //$NON-NLS-1$
												{
													Node importedNode = this.detailDom.importNode(currFromColNode.getFirstChild(),true);
													currToColNode.appendChild( importedNode );
												}
												else
												{
													//Added By Pankaj T. on 17-12-18 [ for avoiding override default pkField value in copy transaction ] - start
													if( this.isCopyingRec )
													{
														if( primaryKeyList != null && !(primaryKeyList.contains( currFromColNodeName )) )
														{
															CDATASection cDataSection = this.detailDom.createCDATASection( nodeValue );
															currToColNode.appendChild( cDataSection );
														}
													}
													else
													{
														CDATASection cDataSection = this.detailDom.createCDATASection( nodeValue );
														currToColNode.appendChild( cDataSection );
													}
													//Added By Pankaj T. on 17-12-18 [ for avoiding override default pkField value in copy transaction ] - end
												}
											}//Changed by Monif on 8/28/2008 [Applying Changeon XMLTYPE data if Edit Flag ="A"]End.
											else
											{
												//Added By Pankaj T. on 17-12-18 [ for avoiding override default pkField value in copy transaction ] - start
												if( this.isCopyingRec )
												{
													if( primaryKeyList != null && !(primaryKeyList.contains( currFromColNodeName )) )
													{
														CDATASection cDataSection = this.detailDom.createCDATASection( nodeValue );
														currToColNode.appendChild( cDataSection );
													}
												}
												else
												{
													CDATASection cDataSection = this.detailDom.createCDATASection( nodeValue );
													currToColNode.appendChild( cDataSection );
												}
												//Added By Pankaj T. on 17-12-18 [ for avoiding override default pkField value in copy transaction ] - end
											}
										}
									}
									//Added by Prasad on 16/11/18 [audit trail implementation for non-itemchange field] START
									if( this.isAuditTrailOn && isDataUpload() )
									{
										if( this.auditDataMap == null )
										{
											this.auditDataMap = new HashMap();
										}
										TreeMap currFormMap = ( this.auditDataMap.get( formNo ) != null ) ? ( TreeMap )this.auditDataMap.get( formNo ) : new TreeMap();
										
										String tempKey = domId + "_" + currFromColNodeName; //$NON-NLS-1$
										currFormMap.put( tempKey, nodeValue );
										this.auditDataMap.put( formNo, currFormMap );
										BaseLogger.log( "3", userInfo, editorId, "auditDataMap -------["+ currFromColNodeName +"]---- ["+this.auditDataMap+"]" );
									}
									//Added by Prasad on 16/11/18 [audit trail implementation for non-itemchange field] END
									break;
								}
							}
						}//for( int toColNodeCtr = 0; toColNodeCtr < toColNodeLength; toColNodeCtr++)
					}
				}
			}
			
			//Added by Samadhan on 09/09/2016[S15LBAS001] for tax calulation and copy tax node start.
			if(fromNode.getNodeType() == Node.ELEMENT_NODE)
			{
				fromElemntNode = (Element)fromNode;
				fromTaxesNodeList = fromElemntNode.getElementsByTagName("Taxes");
				if(fromTaxesNodeList != null)
				{
					fromTaxesNode = fromTaxesNodeList.item(0);
					if(fromTaxesNode != null && this.taxList != null && this.taxList.contains(formNo) && this.editFlag.equals("E"))
					{	
						BaseLogger.log("3", userInfo,editorId,"Inside copy taxes node edit...........");
						if(toNode.getNodeType() == Node.ELEMENT_NODE)
						{
							toElemntNode = (Element)toNode;
							toTaxesNodeList = toElemntNode.getElementsByTagName("Taxes");
							if(toTaxesNodeList != null)
							{
								toTaxesNode = toTaxesNodeList.item(0);
								toNode.replaceChild( toNode.getOwnerDocument().importNode( fromTaxesNode, true ), toTaxesNode );
							}
						}
					}
					if(fromTaxesNode != null && this.taxList != null && this.taxList.contains(formNo) && this.editFlag.equals("A"))
					{
						BaseLogger.log("3", userInfo,editorId,"Inside copy taxes node Add...........");
						Node importedNode = this.detailDom.importNode(fromTaxesNode,true);
						toNode.appendChild( importedNode );
					}
				}
			}
			if(forceCalculateTax)
			{
				//Changed By Pankaj T. on 19-08-19 As per suggested by KB sir if each_rate not define in daily_exch_rate master then throw error - start
				String taxChgString = calculateTax();
				if( taxChgString != null && taxChgString.length() > 0 && taxChgString.indexOf("<Errors>") != -1)
				{
					return taxChgString;
				}
				//Changed By Pankaj T. on 19-08-19 As per suggested by KB sir if each_rate not define in daily_exch_rate master then throw error - end
			}
			//Added by Samadhan on 09/09/2016[S15LBAS001] for tax calulation and copy tax node end
			
			// Added by Raju K on 01-07-14 for Bug Fixing of start time end time[WI3DSUN001] in Event log and Transaction lock as per danish sir 
			userSetEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(), this.getEditorId(), "EDIT", "post_item_change", startTime, new Date(),"EventContext:[" + currentEventContext + "], focused column:[" + this.focussedColumn + "]", this.headerPKFieldValues);
			//Chnged by Danish on 06/03/2007 to skip validation while copying record.
			if ( ! this.isCopyingRec )
			{
				StringBuffer hdrStrBuff = new StringBuffer();
				hdrStrBuff.append( "<Root>" ); //$NON-NLS-1$
				hdrStrBuff.append( "<header>" ); //$NON-NLS-1$
				hdrStrBuff.append( "<objName><![CDATA["+this.objName+"]]></objName>" ); //$NON-NLS-1$ //$NON-NLS-2$
				hdrStrBuff.append( "<pageContext><![CDATA[2]]></pageContext>" ); //$NON-NLS-1$
				hdrStrBuff.append( "<editFlag><![CDATA[" + this.editFlag + "]]></editFlag>" ); //$NON-NLS-1$ //$NON-NLS-2$
				hdrStrBuff.append( "<action><![CDATA[SAVE]]></action>" ); //$NON-NLS-1$
				hdrStrBuff.append( "<elementName><![CDATA[]]></elementName>" ); //$NON-NLS-1$
				hdrStrBuff.append( "<taxKeyValue><![CDATA[]]></taxKeyValue>" ); //$NON-NLS-1$
				hdrStrBuff.append( "<taxInFocus><![CDATA[false]]></taxInFocus>" ); //$NON-NLS-1$
				hdrStrBuff.append("<objContext><![CDATA["+formNo+"]]></objContext>");												 //$NON-NLS-1$ //$NON-NLS-2$
				hdrStrBuff.append("<focusedColumn><![CDATA[]]></focusedColumn>"); //$NON-NLS-1$
				hdrStrBuff.append("<forcedSave><![CDATA[false]]></forcedSave>"); //$NON-NLS-1$
				
				//DANISH 02JUL15
				//Changed by Prasad on 15/06/17 [changes reverted getting issue in taxCalculation as per Danish Sir]
				hdrStrBuff.append("<keyValue><![CDATA[" + ( ( formNo.equals( "1" ) ) ? "1" : this.detailDomId ) + "]]></keyValue>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				//hdrStrBuff.append("<keyValue><![CDATA[" + ( ( formNo.equals( "1" ) ) ? "1" : fromNode.getAttributes().getNamedItem("domID").getNodeValue() ) + "]]></keyValue>");
				
				hdrStrBuff.append("<saveLevel><![CDATA[0]]></saveLevel>"); //$NON-NLS-1$
				hdrStrBuff.append( "</header>" ); //$NON-NLS-1$
				hdrStrBuff.append( "</Root>" ); //$NON-NLS-1$
				//BaseLogger.log("3", userInfo,editorId," If in Copying Record " + serializeDom( this.detailDom ) );
				retString = updateDetailDom( hdrStrBuff.toString() );

				if( retString.indexOf( "<Errors>" ) != -1 ) //$NON-NLS-1$
				{
					NodeList errorNodeList = new E12GenericUtility().parseString(retString).getElementsByTagName("error"); //$NON-NLS-1$
					boolean isErrorNodeFound = false;
					String reqForcedFlag = "true"; //$NON-NLS-1$
					int errorNodeListLen = errorNodeList.getLength();
					for (int i=0; i < errorNodeListLen; i++)
					{
						Node errorNode = errorNodeList.item(i);
						String errorType = errorNode.getAttributes().getNamedItem( "type" ).getNodeValue(); //$NON-NLS-1$
						BaseLogger.log("3", userInfo,editorId, "errorType :["+errorType+"]" ); //$NON-NLS-1$ //$NON-NLS-2$
						BaseLogger.log("3", userInfo,editorId, "reqForcedFlag :["+reqForcedFlag+"]" ); //$NON-NLS-1$ //$NON-NLS-2$
						if( ( ("E").equals( errorType ) ) 	|| ( ! reqForcedFlag.equalsIgnoreCase("true") && ( ("W").equals( errorType ) || 	("P").equals( errorType )	) )  || 	("").equals( errorType ) ) //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
						{
							BaseLogger.log("3", userInfo,editorId,"--------------- EEE RRR RRR OOO RRR (valData)----------  isErrorNodeFound ["+isErrorNodeFound+"]"); //$NON-NLS-1$ //$NON-NLS-2$
							isErrorNodeFound = true;
							//throw new Exception( errorNode.getChildNodes().item( 0 ).getFirstChild().getNodeValue() );
							return retString;
						}
					}
					StringBuffer tempStrBuff = new StringBuffer();
					tempStrBuff.append( "<Root>" ); //$NON-NLS-1$
					tempStrBuff.append( "<header>" ); //$NON-NLS-1$
					tempStrBuff.append( "<objName><![CDATA["+this.objName+"]]></objName>" ); //$NON-NLS-1$ //$NON-NLS-2$
					tempStrBuff.append( "<pageContext><![CDATA[2]]></pageContext>" ); //$NON-NLS-1$
					tempStrBuff.append( "<editFlag><![CDATA[" + this.editFlag + "]]></editFlag>" ); //$NON-NLS-1$ //$NON-NLS-2$
					tempStrBuff.append( "<action><![CDATA[SAVE]]></action>" ); //$NON-NLS-1$
					tempStrBuff.append( "<elementName><![CDATA[]]></elementName>" ); //$NON-NLS-1$
					tempStrBuff.append( "<taxKeyValue><![CDATA[]]></taxKeyValue>" ); //$NON-NLS-1$
					tempStrBuff.append( "<taxInFocus><![CDATA[false]]></taxInFocus>" ); //$NON-NLS-1$
					tempStrBuff.append("<objContext><![CDATA[" + formNo + "]]></objContext>");												 //$NON-NLS-1$ //$NON-NLS-2$
					tempStrBuff.append("<focusedColumn><![CDATA[]]></focusedColumn>"); //$NON-NLS-1$
					tempStrBuff.append("<forcedSave><![CDATA[true]]></forcedSave>"); //$NON-NLS-1$
					
					//DANISH 02JUL15
					//Changed by Prasad on 15/06/17 [changes reverted getting issue in taxCalculation as per Danish Sir]
					tempStrBuff.append("<keyValue><![CDATA[" + ( ( formNo.equals( "1" ) ) ? "1" : this.detailDomId ) + "]]></keyValue>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
					//tempStrBuff.append("<keyValue><![CDATA[" + ( ( formNo.equals( "1" ) ) ? "1" : fromNode.getAttributes().getNamedItem("domID").getNodeValue() ) + "]]></keyValue>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
					
					tempStrBuff.append("<saveLevel><![CDATA[0]]></saveLevel>"); //$NON-NLS-1$
					tempStrBuff.append( "</header>" ); //$NON-NLS-1$
					tempStrBuff.append( "</Root>" ); //$NON-NLS-1$
					retString = updateDetailDom( tempStrBuff.toString() );
				}
			}
		}
		catch ( Exception e )
		{
			throw new ITMException( e );
		}
		return retString;
	}
	
	private void appendToActionsDom(Document parentDom, Document childDom)throws Exception
    {
		try
		{
			if(parentDom != null)
			{
				NodeList parentNodeList  = parentDom.getElementsByTagName("sys_actions"); //$NON-NLS-1$
				Node node = parentNodeList.item(parentNodeList.getLength());
	
				NodeList newChildList = childDom.getElementsByTagName("action"); //$NON-NLS-1$
				int len = newChildList.getLength();
				if (len > 0)
				{
					for (int j=0;j<len;j++)
					{
						Node nDetail = newChildList.item(j);
						Node importedNode = parentDom.importNode(nDetail,true);
						parentNodeList.item(0).appendChild(importedNode);
					}
				}
			}
	   }
	   catch(Exception e)
	   {
		   BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :appendToActionsDom :\n"+e.getMessage()); //$NON-NLS-1$
			throw e;
	   }
	}
	
	//Changed by Manish on 05/06/2007 to support datetime datatypes in pk for checking confirmation status and changed queries to use PreparedStatement.Start
	/*
	private boolean isConfirmed() throws ITMException
	{
		Connection con = null;
		Statement stmt = null;
		boolean isConf = false;
		try
		{
			StringBuffer confirmQryBuffer = new StringBuffer();
			if ( ( ! "null".equalsIgnoreCase( this.confirmCol ) ) && this.confirmCol.length() > 0 && ( ! "null".equalsIgnoreCase( this.confirmVal ) ) && this.confirmVal.length() > 0 && this.mainTableName != null && this.headerPKFieldValues != null )
			{
				confirmQryBuffer.append( "SELECT COUNT(1) FROM " + this.mainTableName + " WHERE " );
				StringTokenizer pkNameTokens = new StringTokenizer( this.headerPKFieldNames, ":" );
				StringTokenizer pkDataTypeTokens = new StringTokenizer( this.headerPKFieldDataTypes, ":" );
				StringTokenizer pkValueTokens = new StringTokenizer( this.headerPKFieldValues, ":" );
				while( pkNameTokens.hasMoreTokens() )
				{
					String currPKName = pkNameTokens.nextToken();
					String currPKDataType = pkDataTypeTokens.nextToken();
					String currPKValue = pkValueTokens.nextToken();

					if ( currPKDataType.equalsIgnoreCase( "CHAR" ) || currPKDataType.equalsIgnoreCase( "VARCHAR" ) || currPKDataType.equalsIgnoreCase( "VARCHAR2" ) || currPKDataType.equalsIgnoreCase( "DATE" ) || currPKDataType.equalsIgnoreCase( "DATETIME" ) ||  currPKDataType.equalsIgnoreCase( "TIMESTAMP" ) )
					{
						confirmQryBuffer.append( currPKName ).append( " = '" ).append(currPKValue).append( "' AND " );
					}
					else
					{
						confirmQryBuffer.append(currPKName).append( " = " ).append( currPKValue ).append( " AND " );
					}
				}

				confirmQryBuffer.append( "(" + this.confirmCol+"='"+this.confirmVal+"' " );

				if( this.editExpr != null )
				{
					confirmQryBuffer.append( " " + this.editExpr  );
				}
				confirmQryBuffer.append( ")" );
				if( confirmQryBuffer.length() > 0 )
				{
					ConnDriver conDriver = new ConnDriver();
					con = conDriver.getConnectDB( "Driver" );
					stmt = con.createStatement();
					BaseLogger.log("3", userInfo,editorId, "Query to check confirm status :[" + confirmQryBuffer.toString() + "]" );
					ResultSet rs = stmt.executeQuery( confirmQryBuffer.toString()  );
					while(rs.next())
					{
						int count = rs.getInt(1);
						if (count > 0)
						{
							isConf = true;
						}
					}
					stmt.close();
					stmt = null;
				}
			}
			return isConf; 
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(con != null)
				{					
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					con.close();
					con = null;
				}
			}
			catch (Exception e)
			{
				BaseLogger.log("3", userInfo,editorId,"Exception :MasterStatefulEJB :isConfirmed :finally==>");
				throw new ITMException(e);
			}
		}
	}
	*/
	private boolean isConfirmed() throws ITMException
	{
		BaseLogger.log("3", userInfo, editorId, "In isConfirmed");
		Connection con = null;
		PreparedStatement pStmt = null;
		//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression.
		//boolean isConf = false;
		ResultSet rs = null ;
		//Added By Shahu Mali on  09-10-13.[WS3GBAS001]
		String transDB = null;
		
		try
		{
			//Added By Mahesh Patidar on 20-FEB-13
			if ((this.editFlag !=null && this.editFlag.equalsIgnoreCase( "A" )) || this.headerPKFieldValues == null || this.headerPKFieldValues.trim().length() == 0 ) 
			{
				//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - start
				//return isConf;
				isConfirm = false;
				return isConfirm;
				//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - end
			}
			//Ended By Mahesh Patidar
			// Added by Amit D on  31 Dec 13 to return isConfirmed false if editing from workflow.START
			if(isTransactionEditfromWF)
			{
				//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - start
				//return isConf;
				isConfirm = false;
				return isConfirm;
				//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - end
			}
			// Added by Amit D on 31 Dec 13 to return isConfirmed false if editing from workflow.END
			StringBuffer confirmQryBuffer = new StringBuffer();
			//changed by Monif on 1/15/2009.[SY89DIS013].
			//if ( ( ! "null".equalsIgnoreCase( this.confirmCol ) ) && this.confirmCol.length() > 0 && ( ! "null".equalsIgnoreCase( this.confirmVal ) ) && this.confirmVal.length() > 0 && this.mainTableName != null && this.headerPKFieldValues != null )
			if ( ( ! "null".equalsIgnoreCase( this.confirmCol ) ) && this.confirmCol.length() > 0 && ( ! "null".equalsIgnoreCase( this.confirmVal ) ) && this.confirmVal.length() > 0 && ( this.mainTableName != null &&  this.mainTableName.length() > 0 ) && ( ! "null".equalsIgnoreCase( this.mainTableName ) ) ) //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			{
				confirmQryBuffer.append( "SELECT COUNT(1) FROM " + this.mainTableName + " WHERE " ); //$NON-NLS-1$ //$NON-NLS-2$
				StringTokenizer pkNameTokens = new StringTokenizer( this.headerPKFieldNames, ":" ); //$NON-NLS-1$
				while( pkNameTokens.hasMoreTokens() )
				{
					String currPKName = pkNameTokens.nextToken();
					confirmQryBuffer.append( currPKName ).append( " = " ).append("?").append( " AND " ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				}

				confirmQryBuffer.append( "(" + this.confirmCol+"='"+this.confirmVal+"' " ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$

				//Commented By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - start
				/*if( this.editExpr != null )
				{
					confirmQryBuffer.append( " " + this.editExpr  ); //$NON-NLS-1$
				}*/
				//Commented By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - end
				confirmQryBuffer.append( ")" ); //$NON-NLS-1$
				if( confirmQryBuffer.length() > 0 )
				{
					E12GenericUtility genericUtility = new E12GenericUtility();
					ConnDriver conDriver = new ConnDriver();
					//Commented and Below changes done By Shahu Mali on  09-10-13.[WS3GBAS001] for multiDB connection : START
					transDB = this.userInfo.getTransDB();
					if(transDB != null && !"null".equalsIgnoreCase(transDB) && transDB.trim().length() > 0)
					{
						con = conDriver.getConnectDB(transDB);
					}
					//Commented and Below changes done By Shahu Mali on  09-10-13.[WS3GBAS001] for multiDB connection : END
					BaseLogger.log("3", userInfo,editorId, "Query to check confirm status :[" + confirmQryBuffer.toString() + "]" ); //$NON-NLS-1$ //$NON-NLS-2$
					pStmt = con.prepareStatement( confirmQryBuffer.toString() );
					if( this.headerPKFieldValues != null && confirmQryBuffer.indexOf( "?" ) != -1 ) //$NON-NLS-1$
					{
						String pkColumnsDataType = this.headerPKFieldDataTypes;
						StringTokenizer qryParamTokens = new StringTokenizer( this.headerPKFieldValues  );
						int pCount=1;
						while(qryParamTokens.hasMoreTokens())
						{
							
							String testParam = qryParamTokens.nextToken( COLUMN_SEPARATOR );
							if ( pkColumnsDataType != null )
							{
								String testParamType = pkColumnsDataType.substring( 0, pkColumnsDataType.indexOf( COLUMN_SEPARATOR ) );
								BaseLogger.log("3", userInfo,editorId, "Setting Param value :["+testParam+"] Type :["+testParamType+"] position :["+pCount+"]" ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
								if ( testParamType.equalsIgnoreCase( "DATETIME" ) ) //$NON-NLS-1$
								{
									testParam = genericUtility.getValidDateTimeString(testParam, genericUtility.getDispDateFormat(), genericUtility.getDBDateFormat());
									pStmt.setTimestamp(pCount, java.sql.Timestamp.valueOf(testParam));
									
								}
								else if (testParamType.equalsIgnoreCase("DATE")) //$NON-NLS-1$
								{
									testParam = getValidDateString( testParam, genericUtility.getDispDateFormat(), genericUtility.getDBDateFormat() );
									pStmt.setDate( pCount, java.sql.Date.valueOf( testParam ) );
								}
								else if ( testParamType.equalsIgnoreCase( "DECIMAL" ) ) //$NON-NLS-1$
								{
									pStmt.setDouble(pCount, Double.parseDouble(testParam));
								}
								else
								{
									DWObject dwObj = getDWObject( this.objName, 1 );
									//Changed by Monif on 6/27/2008 [To remove OraclePreparedStatement ]Start.
									//Changed by Danish on 10/12/2007 [Setting database as DB_NAME  of CommonConstants]	
									//if ( dwObj.getDatabase().toUpperCase().startsWith("ORACLE") && ( testParamType.equalsIgnoreCase( "STRING" ) || testParamType.equalsIgnoreCase( "CHAR" ) ) ) 
									/*if ( ( ( CommonConstants.DB_NAME ).toUpperCase().startsWith("ORACLE") )&& ( testParamType.equalsIgnoreCase( "STRING" ) || testParamType.equalsIgnoreCase( "CHAR" ) ) ) 
									{
										( ( OraclePreparedStatement )pStmt ).setFixedCHAR( pCount, testParam );
									}
									else
									{
										pStmt.setString( pCount, testParam );
									}*/
									pStmt.setString( pCount, testParam );
									//Changed by Monif on 6/27/2008 [To remove OraclePreparedStatement ]End.
								}
								pkColumnsDataType = pkColumnsDataType.substring( pkColumnsDataType.indexOf( COLUMN_SEPARATOR ) + 1 );
							}
							else
							{
								pStmt.setString( pCount, testParam );
							}
							pCount = pCount + 1;
						}
					}
					rs = pStmt.executeQuery();
					while(rs.next())
					{
						int count = rs.getInt(1);
						if (count > 0)
						{
							//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - start
							//isConf = true;
							isConfirm = true;
							//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - end
						}
					}
					rs.close();
					rs = null;
				}
			}
			//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - start
			//return isConf;
			return isConfirm;
			//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - end
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(con != null)
				{					
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
					con.close();
					con = null;
				}
			}
			catch (Exception e)
			{
				BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :isConfirmed :finally==>"); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
	}

	//Changed by Dhruv on 18/07/2006 to check ediatbility based on TRANSETUP.EDIT_OPT
	private boolean isEditable()throws ITMException
	{
		boolean isEditable = false;		
		try
		{
			/*Added by Ashish Sonawane on 27-Dec-12 for preventing transaction to be editable in case of wrkflwOpt=4 and workflow is already instantiated [START] */
			if("4".equalsIgnoreCase(this.wrkflwOpt))
			{
				//Changes done by Ashish Sonawane on 07-Dec-12
				//if( this.wrkflwProcInstId != null || isConfirmed() )
				//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression.
				//if( isConfirmed() )
				if( isClosed() || isCanceled() || isConfirmed() || isNonEditable() )
				{
					isEditable = false;
				}
				else
				{	
					//cross checking the workflow initiated or not in case of this.wrkflwProcInstId is null
					//Changed by Guzar on 02/07/14 add if(this.wrkflwProcInstId == null) condition to allow the external transaction. START
					//which was missed earlier by Ashish.
					isEditable = true;
					if(this.wrkflwProcInstId == null)
					{
						E12InvokeWorkflowServlet invWrkflw= new E12InvokeWorkflowServlet();
						boolean isWorflowExist = invWrkflw.isWorkflowInitiated(this.refSer, this.objName, this.headerPKFieldValues, this.wrkflwInit, this.userInfo);
						if(isWorflowExist)
						{
							isEditable = false;
						}
						else
						{
							isEditable = true;
						}
					}
					//Changed by Guzar on 02/07/14 add if(this.wrkflwProcInstId == null) condition to allow the external transaction. END
				}	
			}
			/*Added by Ashish Sonawane on 27-Dec-12 for preventing transaction to be editable in case of wrkflwOpt=4 and workflow is already instantiated [END] */
			else if( "0".equals( this.editOpt ) )//Always Editable  //$NON-NLS-1$
			{
				isEditable = true;
			}
			else if( "1".equals( this.editOpt ) )//Never Editable //$NON-NLS-1$
			{
				isEditable = false;
			}
			//Changed by Danish on 9/3/2007 [ Editable true if accessed via workflow transSave and editOpt = 2 ]
			//else if( "2".equals( this.editOpt ) && this.isWrkflwToBeInitiated && ! isWorkflowPending() && ! isConfirmed() )//Editable if not in workflow
			//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression.
			//else if( ( "2".equals( this.editOpt ) && this.isWrkflwToBeInitiated && ! isWorkflowPending() && ! isConfirmed() ) || ( this.wrkflwProcInstId != null ) )//Editable if not in workflow //$NON-NLS-1$
			else if( ( "2".equals( this.editOpt ) && this.isWrkflwToBeInitiated && ! isWorkflowPending() && ! isClosed() && ! isCanceled() &&  ! isConfirmed() && ! isNonEditable() ) || ( this.wrkflwProcInstId != null ) )//Editable if not in workflow //$NON-NLS-1$
			{
				isEditable = true;
			}
			//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression.
			//else if( "3".equals( this.editOpt ) && ! isConfirmed() ) //$NON-NLS-1$
			else if( "3".equals( this.editOpt ) && ! isClosed() && ! isCanceled() &&  ! isConfirmed() && ! isNonEditable() ) //$NON-NLS-1$
			{
				isEditable = true;
				//Changed by Manish to add new criteria for editing, i.e; in addition to being not confirmed, only if condn. is satisfied shall the transaction be editable.
				/*
				if( this.editExpr != null && this.editExpr.length() > 0)
				{
					isEditable = evaluateEditExpr( this.editExpr , this.editExprInp); 
				}
				*/
			}
			BaseLogger.log("2", userInfo,editorId, "isEditable["+isEditable+"]" ); //$NON-NLS-1$ //$NON-NLS-2$
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception : MasterStatefulEJB : isEditable :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return isEditable;
	}
	
	//Changed by Manish to add new criteria for editing, i.e; in addition to being not confirmed, only if condn. is satisfied shall the transaction be editable.
	/*private boolean evaluateEditExpr( String exprStr, String exprStrInput )throws ITMException 
	{
		BaseLogger.log("3", userInfo,editorId,"exprStr ["+exprStr+"] exprStrInput ["+exprStrInput+"]");
		boolean expVal = false;
		org.nfunk.jep.JEP taxJEP = new org.nfunk.jep.JEP();
		try
		{
			taxJEP.addStandardFunctions();
			taxJEP.addStandardConstants();
			if (exprStrInput != null && exprStrInput.length() > 0)
			{
				ArrayList exprStrInputList = getTokenList( exprStrInput, "," );
				BaseLogger.log("3", userInfo,editorId,"ExprStrInputList :"+ exprStrInputList);
				String firstToken = null;
				for (int ctr = 0; ctr < exprStrInputList.size(); ctr++)
				{
					String currVarName = null;
					String currVarValue = null;
					String varType = null;

					String tempExprInpStr = (String)exprStrInputList.get( ctr );
					BaseLogger.log("3", userInfo,editorId,"Current Expr Input :["+tempExprInpStr+"]");

					ArrayList varDescTokenList = getTokenList(tempExprInpStr, ".");
					if( varDescTokenList != null && varDescTokenList.size() > 0)
					{
						currVarName = (String) varDescTokenList.get( varDescTokenList.size() - 1 );
						firstToken = ( String ) varDescTokenList.get( 0 );
						firstToken = ( ( firstToken.length() == 0 ) ? this.objContext : firstToken );
						String detailDomId = ( String ) varDescTokenList.get( 1 );
						detailDomId = ( ( detailDomId.length() == 0 ) ? "1" : detailDomId );
						
						BaseLogger.log("3", userInfo,editorId,"Form No. :["+firstToken+"] Dom Id :["+detailDomId+"]");
						if( this.detailDom != null )
						{
							Node curDetail = searchNode( this.detailDom, firstToken, detailDomId );
							currVarValue = getElementValueFromNode( currVarName, curDetail );
						}
						varType = ( String ) varDescTokenList.get( 2 );
						
						BaseLogger.log("3", userInfo,editorId,"Var Name :["+currVarName+"] Var Type :["+varType+"] Var Value :["+currVarValue+"]");
						Object varValue = null;
						if ( varType.equalsIgnoreCase( "I" ) )
						{
							varValue = Integer.valueOf((currVarValue == null || currVarValue.length() == 0 ? "0" : currVarValue));
						}
						else if ( varType.equalsIgnoreCase( "N" ) || varType.equalsIgnoreCase( "D" ) )
						{
							varValue = Double.valueOf((currVarValue == null || currVarValue.length() == 0 ? "0" : currVarValue));
						}
						else
						{
							varValue = ( ( currVarValue == null ) ? "" : currVarValue);
						}

						if ( varValue != null )
						{
							BaseLogger.log("3", userInfo,editorId,"********* Adding currVar ["+currVarName+"] with currVarValue ["+varValue.toString()+"] into taxJEP ");
							taxJEP.addVariableAsObject( currVarName, varValue );
						}
					}
				}
			}
			
			taxJEP.parseExpression( exprStr );

			String errStr = taxJEP.getErrorInfo();
			
			if ( errStr != null )
			{
				String expErrStr = errStr;
				BaseLogger.log("3", userInfo,editorId,"********* Error occured during Evaluation");
			}
			else
			{
				if ( taxJEP.getValueAsObject() != null )
				{
					String expObjString = ( String )taxJEP.getValueAsObject().toString();
					BaseLogger.log("3", userInfo,editorId," expObjString :"+ expObjString );
					expVal = ( ( expObjString != null && expObjString.length() > 0 ) && expObjString.equalsIgnoreCase("1") )  ? true : false ;
				}
				else
				{
					expVal = false;
					BaseLogger.log("3", userInfo,editorId,"taxJEP.getValueAsObject() is null ");
				}
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("3", userInfo,editorId,"Exception : MasterStatesfulEJB : evaluateEditExpr() \n");
			throw new ITMException(e);
		}
		return true;
	}*/
	private String getElementValueFromNode( String elementName, Node curNode)throws ITMException
	{
		BaseLogger.log("2", userInfo,editorId,"********* getElementValueFromNode elementName ["+elementName+"]"); //$NON-NLS-1$ //$NON-NLS-2$
		String elementVal = ""; //$NON-NLS-1$
		try
		{
			NodeList curNodeList = curNode.getChildNodes();

			int curNodeListLength =  curNodeList.getLength();

			for(int ctr = 0; ctr < curNodeListLength; ctr++)
			{
				Node curChildNode = curNodeList.item(ctr);
				if(curChildNode.getNodeName().equalsIgnoreCase(elementName) && (curChildNode.getFirstChild() != null))
				{
					elementVal =  curChildNode.getFirstChild().getNodeValue();
					BaseLogger.log("3", userInfo,editorId,"********* getElementValueFromNode elementVal ["+elementVal+"]"); //$NON-NLS-1$ //$NON-NLS-2$
					break;
				}
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception : TaxCalculation : getElementValueFromNode :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return elementVal;
	}
	
	//Changed by Dhruv on 18/07/2006 to set Audit Trail option.
	private void setAuditTrailOpt()throws ITMException
	{
		try
		{
			if("0".equalsIgnoreCase(this.auditTrailOpt))//No audit Trail //$NON-NLS-1$
			{
				this.isAuditTrailOn = false;
			}
			else
			{
				this.auditDataMap = new HashMap();
			}
			/* Commented as it made by default on, negation will be set by above.
			 else if("1".equals(this.auditTrailOpt) && !isConfirmed())//audit trail for unconfirmed transaction //$NON-NLS-1$
			{
				this.isAuditTrailOn = true;
				this.auditDataMap = new HashMap();
			}
			else if("2".equals(this.auditTrailOpt))//Audit trail for all transaction //$NON-NLS-1$
			{
				this.isAuditTrailOn = true;
				this.auditDataMap = new HashMap();
			}*/
			BaseLogger.log("3", userInfo,editorId,"isAuditTrailOn ["+this.isAuditTrailOn+"]"); //$NON-NLS-1$ //$NON-NLS-2$
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception : MasterStatefulEJB : setAuditTrailOpt :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}		
	}

	private boolean isWorkflowPending() throws ITMException
	{
		boolean isExists = false;
		try
		{
			if( this.isWrkflwToBeInitiated )
			{
				Class[] paramSpec = new Class[ 4 ];
				String[] params = new String[ 4 ];
				paramSpec[ 0 ] = Class.forName( "java.lang.String" ); //$NON-NLS-1$
				paramSpec[ 1 ] = Class.forName( "java.lang.String" ); //$NON-NLS-1$
				paramSpec[ 2 ] = Class.forName( "java.lang.String" ); //$NON-NLS-1$
				paramSpec[ 3 ] = Class.forName( "java.lang.String" ); //$NON-NLS-1$
				params[ 0 ] = this.wrkflwInit;
				params[ 1 ] = this.objName;
				params[ 2 ] = this.refSer;
				params[ 3 ] = this.headerPKFieldValues;

				AppConnectParm appConnect = new AppConnectParm();
				java.util.Properties p = appConnect.getProperty();
				InitialContext ctx = new InitialContext( p );

                //Object comp = null;
                WorkflowProcessInstanceMonitorEJB comp = null;
				//Changed by Monif on 06/04/09.[EJB3.0 Implementation].Start
				/*Object ejbRemoteObj = getObj( "WorkflowProcessInstanceMonitor" );
				Method m = ejbRemoteObj.getClass().getDeclaredMethod( "getProcessStatus", paramSpec );
				m.setAccessible( true );
				String returnValue = (String)m.invoke ( ejbRemoteObj, ( Object[] )params );*/
				// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [START]
				//comp = (WorkflowProcessInstanceMonitorLocal)ctx.lookup("ibase/WorkflowProcessInstanceMonitorEJB/local"); //$NON-NLS-1$
                comp = new WorkflowProcessInstanceMonitorEJB();
                comp.setUserInfo( this.userInfo );
				// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [END]
				Class classObj = Class.forName( comp.getClass().getName() );
				Method metObj = classObj.getMethod("getProcessStatus", paramSpec); //$NON-NLS-1$
				metObj.setAccessible(true);
				String returnValue = (String)metObj.invoke(comp, ( Object[] )params);
				//Changed by Monif on 06/04/09.[EJB3.0 Implementation].End
				if( "P".equalsIgnoreCase( returnValue ) ) //$NON-NLS-1$
				{
					isExists = true;
				}
			}
			/*
			ConnDriver conDriver = new ConnDriver();
			con = conDriver.getConnectDB("Driver");
			stmt = con.createStatement();
			//If wrkflw invoked i.e; 0,(1 - for first activity) for current ref_id should display wrkflw initiated
			String prcStatusSelQry = "SELECT PROCESS_STATUS FROM WF_PRC_STATUS WHERE PROCESS_ID='"+this.wrkflwInit+"' AND ACTIVITY_ID='"+this.wrkflwInit+"' AND REF_SER='"+this.refSer+"' AND REF_ID='"+this.headerPKFieldValues+"' AND OBJ_NAME='"+this.objName+"'";
			BaseLogger.log("3", userInfo,editorId,"Checking if workflow process already instantiated :["+prcStatusSelQry+"]");
			ResultSet rs = stmt.executeQuery(prcStatusSelQry);
			if(rs.next())
			{
				int prcStatus = rs.getInt(1);
				if(prcStatus > 1)
				{
					isExists = true;
				}
			}
			stmt.close();
			stmt = null;
			*/
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		BaseLogger.log( "2", userInfo, editorId, "Returning Process Exists Status :["+ isExists +"]" ); //$NON-NLS-1$ //$NON-NLS-2$
		return isExists;
	}
	
	private void updateAuditDataMap(String currObjCtxStr,String currDomIDStr, Node domDetailNode) 
	{
		try
		{
			NodeList domDetailNodeList = domDetailNode.getChildNodes();
			int detailNodesLen = domDetailNodeList.getLength();
			for (int i = 0; i < detailNodesLen; i++ )
			{
				Node currNode = domDetailNodeList.item(i);
				String nodeName = currNode.getNodeName();
				String nodeValue = currNode.getNodeValue();
				if ( ! "attribute".equals(nodeName)) //$NON-NLS-1$
				{
					String tempKey = currDomIDStr + "_" + nodeName;	 //$NON-NLS-1$
					
					if (this.auditDataMap.get(currObjCtxStr) != null)
					{
						BaseLogger.log("3", userInfo,editorId,"auditDataMap old objContext ["+currObjCtxStr+"] for key ["+tempKey+"] Value ["+nodeValue+"]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
						( (TreeMap)this.auditDataMap.get(currObjCtxStr) ).put(tempKey, nodeValue);
					}
					else
					{
						BaseLogger.log("3", userInfo,editorId,"auditDataMap new objContext ["+currObjCtxStr+"] for key ["+tempKey+"] Value ["+nodeValue+"]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
						TreeMap tempMap = new TreeMap();
						tempMap.put( tempKey, nodeValue );
						this.auditDataMap.put(currObjCtxStr, tempMap);
					}
				}
			}
			BaseLogger.log("3", userInfo,editorId,"After updateAuditDataMap auditDataMap ["+this.auditDataMap+"]"); //$NON-NLS-1$ //$NON-NLS-2$
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}

	//Changed By Dhruv on 23/02/2007 Change the method 
	private String getChgMode(Node currNode)throws ITMException
	{
		String chgMode = ""; //$NON-NLS-1$
		try
		{
			//Changed by Danish on 12/02/2007
			if (currNode != null)
			{
				//Changed by Danish on 12/02/2007 start
				//BaseLogger.log("3", userInfo,editorId,"getChgMode currNode ["+serializeDom(currNode)+"]");
				//Node colNode = currNode.getChildNodes().item(0);
				
				//if (colNode.getNodeName().equalsIgnoreCase("attribute"))
				//{
				NodeList nodeList = currNode.getChildNodes();
				int detailNodesLen = nodeList.getLength();
				for (int i = 0; i < detailNodesLen; i++ )
				{
					Node colNode = nodeList.item(i);
					String nodeName = colNode.getNodeName();
					BaseLogger.log("3", userInfo,editorId,"nodeName ["+nodeName+"]"); //$NON-NLS-1$ //$NON-NLS-2$
					if ( "attribute".equals( nodeName ) ) //Changed by Danish on 12/02/2007 End //$NON-NLS-1$
					{
						String updFlag = ((colNode.getAttributes()).getNamedItem("updateFlag")).getNodeValue(); //$NON-NLS-1$
						BaseLogger.log("3", userInfo,editorId,"Update Flag ["+updFlag+"]" ) ; //$NON-NLS-1$ //$NON-NLS-2$

						if ("D".equals(updFlag) ) //$NON-NLS-1$
						{
							chgMode = "Deleted"; //$NON-NLS-1$
						}
						else if ("E".equals(updFlag) ) //$NON-NLS-1$
						{
							chgMode = "Edited"; //$NON-NLS-1$
						}
						else if ("A".equals(updFlag) ) //$NON-NLS-1$
						{
							chgMode = "Added"; //$NON-NLS-1$
						}
						//Changed by Danish on 12/02/2007
						break;
					}
				}
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception : MasterStatefulEJB : searchNode :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return chgMode;
	}

	//Changed by Samadhan on 28/07/2016[S15LBAS001] for getting domId using dbId and objContext 
	//private String getDomId(String dbID)
	private String getDomId(String dbID,String objContext)
	{
		String domID = ""; //$NON-NLS-1$
		NodeList headerNodeList = this.detailDom.getElementsByTagName("Header0"); //$NON-NLS-1$
		Node headerNode = headerNodeList.item(0);
		if( headerNode != null )
		{
			NodeList headerChlidList = headerNode.getChildNodes();
			int noOfHeaderChlid = headerChlidList.getLength();
			for (int recCtr = 0; recCtr < noOfHeaderChlid; recCtr++)
			{
				Node headerChlidNode = headerChlidList.item(recCtr);
				String headerChlidName = headerChlidNode.getNodeName();
				BaseLogger.log("3", userInfo,editorId,"headerChlidName ("+headerChlidName+"]"); //$NON-NLS-1$ //$NON-NLS-2$
				//Changed by Samadhan on 28/07/2016[S15LBAS001] for getting domId using dbId and objContext 
				//if( headerChlidName.startsWith("Detail") ) //$NON-NLS-1$
				if( headerChlidName.equalsIgnoreCase("Detail"+objContext) )
				{
					if (headerChlidNode.getAttributes().getNamedItem("dbID").getNodeValue().trim().equalsIgnoreCase(dbID.trim())) //$NON-NLS-1$
					{
						domID = headerChlidNode.getAttributes().getNamedItem("domID").getNodeValue(); //$NON-NLS-1$
					}
				}
			}
		}
		BaseLogger.log("2", userInfo,editorId,"Returning domID ["+domID+"] for dbID ["+dbID+"]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		return domID;
	}
	
	/*private Object getObj ( String lookupName ) throws Exception
    {
        try
        {
            EJBHome obHome = getHome( lookupName );
            Method m = obHome.getClass().getDeclaredMethod( "create", new Class[0] );
            Object obj = m.invoke ( obHome, new Object[0] );
            return obj;
        }
		catch (Exception e)
        {
            throw e;
        }
    }

	private EJBHome getHome( String lookupName ) throws Exception
    {
        try
        {
            AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);

            Object home = ctx.lookup( lookupName );
            EJBHome obHome = (EJBHome)PortableRemoteObject.narrow (home, EJBHome.class);
            return obHome;
        }
       catch (Exception e)
        {
            throw e;
        }
    }*/

	private void printState(String message, String varValue)
	{
		try
		{
			File applnLog = new File(".." + File.separator + "applnlog");// + File.separator + "MasterStatefulStatusLog.log" //$NON-NLS-1$ //$NON-NLS-2$
			if(applnLog.exists())
			{
				applnLog = new File(applnLog, "MasterStatefulStatusLog.log"); //$NON-NLS-1$
				BufferedWriter buffWriter = new BufferedWriter(new FileWriter(".." + File.separator + "applnlog" + File.separator + "MasterStatefulStatusLog.log", true)); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				buffWriter.write("\n\n\n***P R I N T  S E Q U E N C E [" + (++this.printSeq) + "] ***"); //$NON-NLS-1$ //$NON-NLS-2$
				if (varValue == null)
				{
					buffWriter.write("\nPrint State					     :"+message); //$NON-NLS-1$
					buffWriter.write("\nInitialContext				 :[" + this.initialContext + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nMasterDataStateful		 :[" + this.masterDataStateful + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nEventManager				 :[" + this.eventManager + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nDBAccessRemote			 :[" + this.dbAccess + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nUserInfoBean				 :[" + this.userInfo + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nObject Name					 :[" + this.objName + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nReference Series			 :[" + this.refSer + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nTransaction type			 :[" + this.tranType + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nSystem Obj Name			 :[" + this.systemDefObjName + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nKey Flag						 :[" + this.keyFlag + "]"); //$NON-NLS-1$ //$NON-NLS-2$
//					buffWriter.write("\nSign List						 :[" + this.signList + "]");
					buffWriter.write("\nSign status					 :[" + this.signStatus + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nTaxList							 :[" + this.taxList + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					
					buffWriter.write("\nContext Titles List			 :[" + this.contextTitlesList + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nNo of Forms					 :[" + this.noOfForms + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nCross Update Expr List	 :[" + this.crossUpdateExprList + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nExpr Var Info List			 :[" + this.exprVarInfoList + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nTarget Var Info List		 :[" + this.targetVarInfoList + "]"); //$NON-NLS-1$ //$NON-NLS-2$

					buffWriter.write("\nArg filed Names				 :[" + this.argFieldNames + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nArg Filed Types				 :[" + this.argFieldTypes + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nAcc Filter Query				 :[" + this.accFilterQuery + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nHeader PK Field Names  :[" + this.headerPKFieldNames + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nObject Context				 :[" + this.objContext + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nPage Context				 :[" + this.pageContext + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nEdit Flag						 :[" + this.editFlag + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nLocal Edit Flag				 :[" + this.localEditFlag + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nView Dom ID					 :[" + this.viewDomId + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nHeader Dom ID				 :[" + this.headerDomId + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nDetail DOm ID				 :[" + this.detailDomId + "]"); //$NON-NLS-1$ //$NON-NLS-2$

					buffWriter.write("\nSave Level						 :[" + this.saveLevel + "]"); //$NON-NLS-1$ //$NON-NLS-2$

					buffWriter.write("\nFocussed Column			 :[" + this.focussedColumn + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nCurrent Event Context   :[" + this.currentEventContext + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nOver Write Default		 :[" + this.overWriteDefault + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nHeader Info Map			 :[" + this.headerInfoMap + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nRecord ID						 :[" + this.recordID + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					
					buffWriter.write("\nBlank DOm ID List			 :[" + this.blankDomList + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nMax Dom ID List			 :[" + this.maxDomIDList + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nMax Line NO List			 :[" + this.maxLineNoList + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					
					buffWriter.write("\nArg Field Values				 :[" + this.argFieldValues + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nAdv Query						 :[" + this.advQuery + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nHeader PK Field Values  :[" + this.headerPKFieldValues + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nFilter String					 :[" + this.filterString + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					
					buffWriter.write("\nHeader List Dom			 :[" + this.headerListDom + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nHeader List XML String	 :[" + this.headerListXMLStr + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					
					buffWriter.write("\nDetail Dom String			 :[" + this.detailDomString + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nDetail Dom						 :[" + this.detailDom + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nCurr Record Node			 :[" + this.currRecordNode + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					
					buffWriter.write("\nIs Record Validated		 :[" + this.isRecordValidated + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nCurrent Tax Node			 :[" + this.currTaxNode + "]"); //$NON-NLS-1$ //$NON-NLS-2$

					buffWriter.write("\nColumn Separator			 :[" + this.COLUMN_SEPARATOR + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					buffWriter.write("\nXTRA Params Separator :[" + this.XTRA_PARAMS_SEPARATOR + "]"); //$NON-NLS-1$ //$NON-NLS-2$
				}
				else
				{
					buffWriter.write("\n"+message+" :[" + varValue + "]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				}
				buffWriter.close();
				buffWriter = null;
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"This error will only stop logging the state can proceed ahead inspite of this............."); //$NON-NLS-1$
			e.printStackTrace();
		}
	}

	private void debug( String action, String[] inputStrArr, String responseStr )
	{
		BufferedWriter logFileWriter = null;
		try
		{
			//Commented by Nilesh Soor on 19-Aug-14 [ As per Danish Sir's Instruction ] Start
			/*if( "0".equals( CommonConstants.USER_LOG ) )
			{
				return;
			}*/
			//Commented by Nilesh Soor on 19-Aug-14 [ As per Danish Sir's Instruction ] End
			
			
			//Added by Nilesh Soor on 19-Aug-14 [ As per Danish Sir's Instruction ] Start
			if( !"9".equals( CommonConstants.USER_LOG ) )
			{
				return;
			}
			//Added by Nilesh Soor on 19-Aug-14 [ As per Danish Sir's Instruction ] End
			String logFileName = CommonConstants.JBOSSHOME + File.separator + "log" + File.separator + this.userInfo.getLoginCode(); //$NON-NLS-1$
			logFileWriter = new BufferedWriter( new FileWriter( logFileName, true ) );
			if( "1".equals( responseStr ) ) //$NON-NLS-1$
			{
				logFileWriter.newLine();
				logFileWriter.write( "===================[Start--"+action+"---Start]===================" ); //$NON-NLS-1$ //$NON-NLS-2$
				logFileWriter.newLine();
				if( this.detailDom != null )
				{
					logFileWriter.write( "["+new java.util.Date()+"]Detail dom before action :\n[\n" + serializeDom( this.detailDom ) + "\n]\n" ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				}
				logFileWriter.newLine();
				for( int argCtr = 0; argCtr < inputStrArr.length; argCtr+=2 )
				{
					logFileWriter.write( "["+new java.util.Date()+"]"+action + "[arg name] :[arg value] :[" + inputStrArr[ argCtr ] + "] :[" + inputStrArr[ ( argCtr + 1 ) ] + "]" ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
					logFileWriter.newLine();
				}
			}
			else
			{
				logFileWriter.write( "["+new java.util.Date()+"]Response to action :[" + action + "] :[" + responseStr + "]" ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				logFileWriter.newLine();
				if( this.detailDom != null )
				{
					logFileWriter.write( "["+new java.util.Date()+"]Detail dom after action :\n[\n" + serializeDom( this.detailDom ) + "\n]\n" ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				}
				logFileWriter.newLine();
				logFileWriter.write( "===================[End--"+action+"--End]===================" ); //$NON-NLS-1$ //$NON-NLS-2$
				logFileWriter.newLine();
			}
		}
		catch ( Exception e )
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( logFileWriter != null )
				{
					logFileWriter.flush();
					logFileWriter.close();
					logFileWriter = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
				logFileWriter = null;
			}
		}
	}



	//Changed by Danish on 03/01/2007 
	private void setValueOnDom(String objContext, String elementName, String elementValue)throws ITMException
	{
		try
		{
			//BaseLogger.log("3", userInfo,editorId,"Setting value for obj context :["+objContext+"] element name :["+elementName+"] value :["+elementValue+"]");
			if(objContext == null || (objContext != null && objContext.length() > 0))
			{
				objContext = "1"; //$NON-NLS-1$
			}
			NodeList detailList = this.detailDom.getElementsByTagName("Detail"+objContext); //$NON-NLS-1$
			int noOfDetails = detailList.getLength();
			for(int detCtr = 0; detCtr < noOfDetails; detCtr++)
			{
				Node detailNode = detailList.item(detCtr);
				NodeList detailChildList = detailNode.getChildNodes();
				int noOfDetailChild = detailChildList.getLength();
				for (int detChildCtr = 0; detChildCtr < noOfDetailChild; detChildCtr++)
				{
					Node colNameNode = detailChildList.item(detChildCtr);
					String nodeName = colNameNode.getNodeName();
					if(colNameNode.getNodeType() == Node.ELEMENT_NODE && nodeName != null && nodeName.equals(elementName))
					{
						Node colValueNode = colNameNode.getFirstChild();
						if(colValueNode != null && colValueNode.getNodeValue() != null)
						{
							colValueNode.setNodeValue(elementValue);
						}
						else
						{
							CDATASection cDataSection = this.detailDom.createCDATASection(elementValue);
							colNameNode.appendChild(cDataSection);
						}
					}
				}//for (int detChildCtr = 0; detChildCtr < noOfDetailChild; detChildCtr)
			}//for(int detCtr = 0; detCtr < noOfDetails; detCtr++)
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
	}

	//Changed by Danish on 20/12/2007 [ Appending New Details from processRequest xmlString ]
	public void appendNewDetailsInDom( String xmlString ) throws ITMException
	 {		
		try
		{
			BaseLogger.log("3", userInfo,editorId,"appendNewDetailsInDom called "); //$NON-NLS-1$
			Document document = parseString( xmlString );
			if (document != null )
			{
				//Changed by Monif on 7/3/2008 [ Appending New Details from processRequest xmlString ].Start
				//Changed by monif on 07/01/2009.Start
				Node detNode = null;
				Node hdrNode = this.detailDom.getElementsByTagName( "Header0" ).item( 0 ); //$NON-NLS-1$
				do
				{	
					if( hdrNode.getNodeType() == Node.ELEMENT_NODE && hdrNode.getNodeName().startsWith("Header0")) //$NON-NLS-1$
					{
						NodeList detailDomList = hdrNode.getChildNodes();
						int noOfChilds = detailDomList.getLength();
						for(int detCtr = 0; detCtr < noOfChilds; detCtr++)
						{
							detNode = detailDomList.item( detCtr );
						
							if(detNode != null && detNode.getNodeType() == Node.ELEMENT_NODE  )
							{	
								if( detNode.getNodeName().equals("<Detail1>") ) //$NON-NLS-1$
								{
									break;
								}
							}
						}
					}
				}while ( ( hdrNode = hdrNode.getNextSibling() ) != null );
				//Changed by monif on 07/01/2009.End
				Node node = document.getElementsByTagName( "Detail1" ).item( 0 ); //$NON-NLS-1$
				do
				{					
					if( node.getNodeType() == Node.ELEMENT_NODE && node.getNodeName().startsWith("Detail")) //$NON-NLS-1$
					{
						String domID = node.getAttributes().getNamedItem("domID").getNodeValue(); //$NON-NLS-1$
						String objCtx = node.getAttributes().getNamedItem("objContext").getNodeValue(); //$NON-NLS-1$
						//Added by Prasad on 02/11/16 [to search node from dbId]
						String dbID = node.getAttributes().getNamedItem("dbID").getNodeValue(); //$NON-NLS-1$
						if( Integer.parseInt( objCtx ) > 1 )
						{
							//Changed by Prasad on 02/11/16 [to search node from dbId]
							//Node childNode = searchNode( document, objCtx, domID );
							Node childNode = searchNode( document, objCtx, domID, dbID );
							NodeList childNodeList = childNode.getChildNodes();
							int childNodeListLen = childNodeList.getLength();
							for(int l = 0; l < childNodeListLen; l++)
							{
								if( ! "attribute".equals(	childNodeList.item( l ).getNodeName() ) ) //$NON-NLS-1$
									continue;
								String status = childNodeList.item( l ).getAttributes().getNamedItem("status").getNodeValue(); //$NON-NLS-1$
								String updateFlag = childNodeList.item( l ).getAttributes().getNamedItem("updateFlag").getNodeValue(); //$NON-NLS-1$
								BaseLogger.log("3", userInfo,editorId,"status [" + status + "]"); //$NON-NLS-1$ //$NON-NLS-2$
								BaseLogger.log("3", userInfo,editorId,"updateFlag= [" + updateFlag + "]"); //$NON-NLS-1$ //$NON-NLS-2$
								if( ! "N".equalsIgnoreCase( status ) ) //$NON-NLS-1$
								{
									if ( "D".equalsIgnoreCase( updateFlag ) ) //$NON-NLS-1$
									{
										//Danish 02JUL15 -- commented why to add if D : START
										Node newNode = this.detailDom.importNode(childNode, true);
										//Danish 02JUL15 -- commented why to add if D : END
										
										//Changed by monif on 07/01/2009.Start
										//this.detailDom.getDocumentElement().appendChild( newNode );
										
										//Danish 02JUL15 -- commented why to add if D
										detNode.getParentNode().appendChild( newNode );
										//Danish 02JUL15 -- commented why to add if D : END
									}
									break;
								}
								else
								{
									Node newNode = this.detailDom.importNode(childNode, true);
									//Changed by monif on 07/01/2009.Start
									//this.detailDom.getDocumentElement().appendChild( newNode );
									detNode.getParentNode().appendChild( newNode );									
									break;								
								}							
							}
						}
					}
				}while ( ( node = node.getNextSibling() ) != null );
				//Changed by Monif on 7/3/2008 [ Appending New Details from processRequest xmlString ].End
				/*if (document.getElementsByTagName("Header0") != null && document.getElementsByTagName("Header0").item(0) != null )
				{
					NodeList nodelist = document.getElementsByTagName("Header0").item(0).getChildNodes();
					int nodeListLen = nodelist.getLength();
					for(int ctr = 0; ctr < nodeListLen; ctr++)
					{
						Node node = nodelist.item( ctr );
						if( node.getNodeName().indexOf("Detail") != -1)
						{
							BaseLogger.log("3", userInfo,editorId,"Detail found [" + node.getNodeName() + "]");
							String domID = node.getAttributes().getNamedItem("domID").getNodeValue();
							String objCtx = node.getAttributes().getNamedItem("objContext").getNodeValue();
							BaseLogger.log("3", userInfo,editorId,"currObjCtx [" + objCtx + "]");
							if( Integer.parseInt( objCtx ) > 1 )
							{
								Node childNode = searchNode( document, objCtx, domID );
								NodeList childNodeList = childNode.getChildNodes();
								int childNodeListLen = childNodeList.getLength();
								BaseLogger.log("3", userInfo,editorId,"copyToNodeListLen [" + childNodeListLen + "]");
								for(int l = 0; l < childNodeListLen; l++)
								{
									if( ! "attribute".equals(	childNodeList.item( l ).getNodeName() ) )
										continue;
									String status = childNodeList.item( l ).getAttributes().getNamedItem("status").getNodeValue();
									BaseLogger.log("3", userInfo,editorId,"status [" + status + "]");
									if( ! "N".equalsIgnoreCase( status ) )
									{
										continue;
									}
									Node newNode = this.detailDom.importNode(childNode, true);
									this.detailDom.getDocumentElement().appendChild( newNode );
									break;
								}
							}
						}
					}
				}*///if (document.getElementsByTagName("Header0") != null && document.getElementsByTagName("Header0").item(0) != null )
			}//if (document != null )
		}
		catch(Exception exception)
		{
			throw new ITMException(exception);
		}
	}

	//Changed by Nazia on 7/4/2008[Added new methode to get values for POPSqlInput parameters from this.detailDom WI89BAS005]start
	public String getParameterValue(String parameterName)throws java.rmi.RemoteException,ITMException
	{
		//BaseLogger.log("3", userInfo,editorId,"MasterStateFulEJB: getParameterValue() parameterName ["+parameterName+"] ");
		String formNo = ""; //$NON-NLS-1$
		String rowNo = ""; //$NON-NLS-1$
		String  actualValue = ""; //$NON-NLS-1$
		if( ( parameterName != null ) && ( parameterName.indexOf( "." ) != -1 ) ) //$NON-NLS-1$
		{
			formNo = parameterName.substring(0,parameterName.indexOf(".")); //$NON-NLS-1$
			if (parameterName.indexOf(".")<parameterName.lastIndexOf(".")) //$NON-NLS-1$ //$NON-NLS-2$
			{
				rowNo = parameterName.substring(parameterName.indexOf(".")+1,parameterName.lastIndexOf(".")); //$NON-NLS-1$ //$NON-NLS-2$
			}			
			parameterName = parameterName.substring(parameterName.lastIndexOf(".")+1,parameterName.length());			 //$NON-NLS-1$
			BaseLogger.log("3", userInfo,editorId,"MasterStateFulEJB:getParameterValue formNo["+formNo+"], rowNo["+rowNo+"]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			
			actualValue = new E12GenericUtility().getColumnValue(parameterName,this.detailDom,formNo,rowNo);
		}		
		BaseLogger.log("2", userInfo,editorId,"MasterStateFulEJB: getParameterValue() actualValue ["+actualValue+"] "); //$NON-NLS-1$ //$NON-NLS-2$
		return actualValue;
	}
	//Changed by Nazia on 7/4/2008[Added new methode to get values for POPSqlInput parameters from this.detailDom WI89BAS005]End
	
	//Changed by Monif on 11/12/2008 [].start
	//private EventManager getEventManager()throws ITMException
	private EventManagerLocal getEventManager()throws ITMException
	{
		//EventManager eventManager = null;
		EventManagerLocal eventManager = null;
		try
		{
			/*EventManagerHome eventManagerHome = (EventManagerHome)this.initialContext.lookup("EventManager");
			eventManager = eventManagerHome.create();*/
			eventManager = (EventManagerLocal)this.initialContext.lookup("ibase/EventManagerEJB/local");			 //$NON-NLS-1$
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :ITMXformEditSignServlet :getDBAccessRemote :==>\n"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return eventManager;
	}
	//Changed by Monif on 11/12/2008 [].End

	//Changed by Monif on 02/07/09[To Save data on Add action if SaveFlag in Transetup is A].Start
	private String saveDetailOnAdd( String xmlStr )throws ITMException
	{
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]saving Each Detail......"); //$NON-NLS-1$
		String retString = ""; //$NON-NLS-1$
		String wsReturnValue = ""; //$NON-NLS-1$
		String tempObjName = null;
		try
		{
			//Changes made by Gulzar to validate the Save XML against XSD on 28/05/14 : START
			String saveXMLStr = serializeDom( this.detailDom );
			//BaseLogger.log("3", userInfo,editorId,"Save XML Str :::"+saveXMLStr);
			
			boolean isValidated = validateXMLAgainstXSD(saveXMLStr);
			BaseLogger.log("3", userInfo,editorId,"isValidated =["+isValidated+"]");
			if(!isValidated)
			{
				//Return ErrorString
				ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
				retString = itmDBAccessEJB.getErrorString("", "INVALIDXSD", "", this.userInfo);
			}
			
			//BaseLogger.log("3", userInfo,editorId,"retString ::"+retString);
			
			if(retString == null || retString.trim().length() == 0)
			{
			//Changes made by Gulzar to validate the Save XML against XSD on 28/05/14 : END 
				
				if( "U".equalsIgnoreCase( this.tranType ) ) //$NON-NLS-1$
				{
					tempObjName = this.objName;
					Document newDetailDom = transformDom( this.detailDom, tempObjName );
					String newObjName = null;
					if( this.systemDefObjName.startsWith( "[" ) || this.systemDefObjName.startsWith( "<" ) ) //$NON-NLS-1$ //$NON-NLS-2$
					{
						newObjName = getSystemDefObjName( this.systemDefObjName, newDetailDom );
						this.systemDefObjName = null;
					}
					setObjDetails(newObjName);
					this.detailDom = newDetailDom;
					setHeaderPKFieldNames();
				}
				if( wsReturnValue != null && wsReturnValue.indexOf( "<Errors>" ) != -1 ) //$NON-NLS-1$
				{
					retString = wsReturnValue;
				}
				else
				{
					// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [START]
					//XML2DBLocal xml2dbejb = (XML2DBLocal)this.initialContext.lookup("ibase/XML2DBEJB/local"); //$NON-NLS-1$
					XML2DBEJB xml2dbejb = new XML2DBEJB();
					// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [END]
					
					//Commented by Gulzar on 25-May-17
					//xml2DBRem.setObjFormInfoMap(objFormInfoMap);//Gulzar on 09/02/17
					
					BaseLogger.log("3", userInfo,editorId,"this.editFlag ["+this.editFlag+"] this.keyFlag ["+this.keyFlag+"]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
					BaseLogger.log("3", userInfo,editorId,"Amit Sending Fiel For Save " +serializeDom( this.detailDom ));
					if( this.isPartOfExtTrans )
					{
						//Commented and changed by Gulzar on 30/03/16. Removed the checking of J2EE_VERSION : START
						/*
						if( "1".equals( CommonConstants.J2EE_VERSION ) ) //$NON-NLS-1$
						{
							retString = xml2DBRem.saveXML2DB( this.refSer, serializeDom( this.detailDom ), this.objName, this.editFlag, this.noOfForms, ( this.editFlag.equalsIgnoreCase( "E" )? false : ( ( this.editFlag.equalsIgnoreCase( "A" ) && this.keyFlag.equalsIgnoreCase( "A" ) ) ) ? true : false ), this.userInfo.getLoginCode(), this.headerPKFieldNames, this.isAutoConfirm, getXtraParams(), this.taxList, this.wrkflwInit, this.isWrkflwToBeInitiated, this.wrkflwOpt, this.auditDataXmlBefore, getAuditXMLString(), this.headerPKFieldValues, this.isWrkflwInitiated,  this.dbSaveConn_doNotUse, this.isAuditTrailOn  ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						}
						else if( "2".equals( CommonConstants.J2EE_VERSION ) ) //$NON-NLS-1$
						{
							retString = xml2DBRem.saveXML2DB( this.refSer, serializeDom( this.detailDom ), this.objName, this.editFlag, this.noOfForms, ( this.editFlag.equalsIgnoreCase( "E" )? false : ( ( this.editFlag.equalsIgnoreCase( "A" ) && this.keyFlag.equalsIgnoreCase( "A" ) ) ) ? true : false ), this.userInfo.getLoginCode(), this.headerPKFieldNames, this.isAutoConfirm, getXtraParams(), this.taxList, this.wrkflwInit, this.isWrkflwToBeInitiated, this.wrkflwOpt, this.auditDataXmlBefore, getAuditXMLString(), this.headerPKFieldValues, this.isWrkflwInitiated, null, this.isAuditTrailOn  ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						}
						*/
						//Changed by Prasad on 17/03/18 [formName implementation in transaction editor]
						retString = xml2dbejb.saveXML2DB( this.refSer, serializeDom( this.detailDom ), this.objName, this.editFlag, this.noOfForms, ( this.editFlag.equalsIgnoreCase( "E" )? false : ( ( this.editFlag.equalsIgnoreCase( "A" ) && this.keyFlag.equalsIgnoreCase( "A" ) ) ) ? true : false ), this.userInfo.getLoginCode(), this.headerPKFieldNames, this.isAutoConfirm, getXtraParams(), this.taxList, this.wrkflwInit, this.isWrkflwToBeInitiated, this.wrkflwOpt, this.auditDataXmlBefore, getAuditXMLString(), this.headerPKFieldValues, this.isWrkflwInitiated,  this.dbSaveConn_doNotUse, this.isAuditTrailOn, this.userInfo, this.objFormInfoMap ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						//Commented and changed by Gulzar on 30/03/16. Removed the checking of J2EE_VERSION : END
					}
					else
					{
						//Changed by Prasad on 17/03/18 [formName implementation in transaction editor]
						retString = xml2dbejb.saveXML2DB( this.refSer, serializeDom( this.detailDom ), this.objName, this.editFlag, this.noOfForms, ( this.editFlag.equalsIgnoreCase( "E" )? false : ( ( this.editFlag.equalsIgnoreCase( "A" ) && this.keyFlag.equalsIgnoreCase( "A" ) ) ) ? true : false ), this.userInfo.getLoginCode(), this.headerPKFieldNames, this.isAutoConfirm, getXtraParams(), this.taxList, this.wrkflwInit, this.isWrkflwToBeInitiated, this.wrkflwOpt, this.auditDataXmlBefore, getAuditXMLString(), this.headerPKFieldValues, this.isWrkflwInitiated, this.isAuditTrailOn, this.userInfo, this.objFormInfoMap ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
					}
					if(retString.indexOf( "<Errors>" ) == -1 ) //$NON-NLS-1$
					{
						if(this.tranType.equalsIgnoreCase( "U" ) && getDelFlagForDraft( tempObjName ).equalsIgnoreCase( "Y" ) ) //$NON-NLS-1$ //$NON-NLS-2$
						{
							deleteDraftObject();
						}
						if( this.tranType.equalsIgnoreCase( "U" ) ) //$NON-NLS-1$
						{
							this.systemDefObjName = null;
							setObjDetails( tempObjName );
							setHeaderPKFieldNames();
						}
						changeDetailDomAttribute( retString );
						retString = "<Root><Detail>Success</Detail><TranID>"+retString+"</TranID></Root>"; //$NON-NLS-1$ //$NON-NLS-2$
					}//if(retString.indexOf("<Errors>") == -1)
					xml2dbejb = null;
				}
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB : saveDetailOnAdd :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]saveDetailOnAdd completed ......"); //$NON-NLS-1$
		return retString;
	}
	//Changed by Rupali Hande [to get both system warning -prompt- and generalized validation ].Start
	//added by vishal pathare for using clipBoardData(Excel data) onpaste event add feeds in detail page for browser].
	public String getErrorNodes(String wsReturnValue, String genValueError) {

		String retString = ""; //$NON-NLS-1$
		E12GenericUtility genericUtility =  new E12GenericUtility();
		try{
			if(wsReturnValue != null && wsReturnValue.indexOf("Errors") != -1){ //$NON-NLS-1$
				retString = wsReturnValue;
				if(genValueError !=null && genValueError.indexOf("Errors") != -1){ //$NON-NLS-1$
					Document sysDom = genericUtility.parseString(wsReturnValue);
					Document genDom = genericUtility.parseString(genValueError);					
					NodeList genNodeList = genDom.getElementsByTagName("error");					 //$NON-NLS-1$
					
					for ( int i = 0; i< genNodeList.getLength(); i++ )
					{
						Node genNode = genNodeList.item(i);
						Node importedNode = sysDom.importNode(genNode,true);
						sysDom.getElementsByTagName( "Errors" ).item( 0 ).appendChild( importedNode ); //$NON-NLS-1$
						retString = genericUtility.serializeDom(sysDom);					
					}
					retString = genericUtility.serializeDom(sysDom);					
				}
			}
			else{
				if(genValueError !=null && genValueError.indexOf("Errors") != -1){ //$NON-NLS-1$
					retString = genValueError;
				}
			}
		}
		catch(Exception e){
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :getErrorNodes :"+e);	 //$NON-NLS-1$
			e.printStackTrace();
		}
		BaseLogger.log("2", userInfo,editorId," getErrorNodes return String ["+retString+"]"); //$NON-NLS-1$ //$NON-NLS-2$
		return retString;
	}
	//Changed by Rupali Hande [to get both system warning -prompt- and generalized validation ].End
	private void changeDetailDomAttribute(String pkFieldValue)throws ITMException
	{
		try
		{
			Node detailNode = this.detailDom.getElementsByTagName( "Detail1" ).item( 0 ); //$NON-NLS-1$
			do
			{					
				if( detailNode.getNodeType() == Node.ELEMENT_NODE && detailNode.getNodeName().startsWith("Detail")) //$NON-NLS-1$
				{				
					NodeList detailChildList = detailNode.getChildNodes();
					for(int dCtr = 0; dCtr < detailChildList.getLength(); dCtr++)
					{
						Node currChild = detailChildList.item(dCtr);
						if ( detailNode.getNodeName().equalsIgnoreCase("Detail1") ) //$NON-NLS-1$
						{
							if ( headerPKFieldNames != null && headerPKFieldNames.indexOf(":") == -1 && currChild.getNodeName().equalsIgnoreCase( headerPKFieldNames.trim() ) ) //$NON-NLS-1$
							{
								if ( currChild != null && currChild.getNodeValue() == null )
								{
									CDATASection cDataSection = null;
									cDataSection = this.detailDom.createCDATASection( pkFieldValue );
									currChild.appendChild(cDataSection);
								}
							}
						}
						if ( currChild.getNodeName().equalsIgnoreCase("attribute") ) //$NON-NLS-1$
						{
							String status = currChild.getAttributes().getNamedItem("status").getNodeValue(); //$NON-NLS-1$
							String updateFlag = currChild.getAttributes().getNamedItem("updateFlag").getNodeValue(); //$NON-NLS-1$
							if ( ( status != null && status.length() > 0 ) && ( updateFlag != null && updateFlag.length() > 0 ))
							{
								if ( status.trim().equalsIgnoreCase( "N" ) && updateFlag.trim().equalsIgnoreCase( "A" )) //$NON-NLS-1$ //$NON-NLS-2$
								{
									( ( Element )currChild ).setAttribute( "status", "O" ); //$NON-NLS-1$ //$NON-NLS-2$
									( ( Element )currChild ).setAttribute( "updateFlag", "N" ); //$NON-NLS-1$ //$NON-NLS-2$
								}
							}
						}						
					}
				}
			}while ( ( detailNode = detailNode.getNextSibling() ) != null );
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB : changeDetailDomAttribute :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]changeDetailDomAttribute completed ......"); //$NON-NLS-1$
	}//Changed by Monif on 02/07/09[To Save data on Add action if SaveFlag in Transetup is A].End
	//Changed by Dayanand on 25/08/09[ WI89BAS029 || Add method instanceInterceptorLog  ]Start
	private void instanceInterceptorLog( String event )
	{
		BufferedWriter logFileWriter = null;
		try
		{
			java.sql.Timestamp currTime =new java.sql.Timestamp(System.currentTimeMillis());				
			String logString = "";			 //$NON-NLS-1$
			if ( this.userInfo != null && this.userInfo.getLoggerType() != null && (this.userInfo.getLoggerType()).length() >= 0 )
			{
				BaseLogger.log("3", userInfo,editorId,"this.userInfo.getLoggerType()["+this.userInfo.getLoggerType()+"]"); //$NON-NLS-1$ //$NON-NLS-2$
				if ( ( this.userInfo.getLoggerType().trim() ).equals("1") || (this.userInfo.getLoggerType().trim()).equals("2") ) //$NON-NLS-1$ //$NON-NLS-2$
				{
					logString = this.coreModelId + "," + this.userInfo.getLoginCode() + "," + currTime + "," + event + "," + this.objName;			 //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
					if(!( new File ( CommonConstants.JBOSSHOME  + File.separator + "log" + File.separator + "instanceActivityLog.log" ) ).exists() ) //$NON-NLS-1$ //$NON-NLS-2$
					{
						( new File( CommonConstants.JBOSSHOME  + File.separator + "log" + File.separator + "instanceActivityLog.log" ) ).createNewFile(); //$NON-NLS-1$ //$NON-NLS-2$
					}
					String logFileName = CommonConstants.JBOSSHOME + File.separator + "log" + File.separator + "instanceActivityLog.log"; //$NON-NLS-1$ //$NON-NLS-2$
					logFileWriter = new BufferedWriter( new FileWriter( logFileName, true ) );
					logFileWriter.newLine();
					logFileWriter.write( logString );
				}
			}
		}
		catch ( Exception e )
		{
			e.printStackTrace();			
		}
		finally
		{
			try
			{
				if( logFileWriter != null )
				{
					logFileWriter.flush();
					logFileWriter.close();
					logFileWriter = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
				logFileWriter = null;
			}
		}
	}
	//Changed by Dayanand on 25/08/09[ WI89BAS029 || Add method instanceInterceptorLog  ]End
	//Changed by Dayanand on 19/01/2011[ Read Default data from file if is detail repeate "x" in transetup table ]start
	private String getDefaultDataFromFile( String objName, String objContext)throws ITMException
	{
		String defaultDataFromFile=null;
		String fileName = null;
		try 
		{			
			fileName = CommonConstants.JBOSSHOME  + File.separator + "resource" + File.separator + objName+"_"+objContext+"_DEFAULT_DATA.xml"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			E12GenericUtility genericUtility =  new E12GenericUtility();	
			defaultDataFromFile = genericUtility.readFile( fileName );
		}
		catch( FileNotFoundException ex )
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB : getDefaultDataFromFile :"+ex); //$NON-NLS-1$
			BaseLogger.log("0", userInfo,editorId,"Exception :getDefaultDataFromFile : File " + fileName + " Not Found"); //$NON-NLS-1$ //$NON-NLS-2$
			throw new ITMException(ex);
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB : getDefaultDataFromFile :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return defaultDataFromFile;
	}
	//Changed by Dayanand on 19/01/2011[ Read Default data from file if is detail repeate "x" in transetup table ]end
	//Change by Nilesh on 02-Mar-2011 [DI01SUN004][To get TranID depending on EditorID]Start
	@Lock(LockType.READ)
	public String getTranId() throws RemoteException, ITMException
	{
		return this.headerPKFieldValues;
	}
	//Change by Nilesh on 02-Mar-2011 [DI01SUN004][To get TranID depending on EditorID]End
	
	//Changed by Dnyaneshwar on 19/11/12 [ WS2GSUN002 ] Start
	/**
	 * This method is get the message from ObjDetailMap again objName. <br>
	 * If check message is null. Then set standard message 
	 * 
	 * @param tranId
	 * @return String 
	 * **/
	private String getMessageOnSave(String tranID) throws RemoteException, ITMException 
	{
		//Changed by Pankaj on 21/12/17 added userInfo parameter for multidb connection 
		HashMap objDetailMap = this.dbAccess.getObjDetailMap(objName, this.userInfo);
		
		String msgOnSave = "" ;
		if (objDetailMap != null) 
		{
			msgOnSave = (objDetailMap.get("MSG_ONSAVE") != null) ? ( (String) objDetailMap.get("MSG_ONSAVE") ) : ( " Transaction is saved. " );
			msgOnSave = msgOnSave.replace("<TRAN_ID>", tranID);	
		}
		
		return msgOnSave;
	}
	//Changed by Dnyaneshwar on 19/11/12 [ WS2GSUN002 ] End
	//Changed By Mahesh Patidar on 23-MAY-13 [WI3BSUN001 | to get capitalized string]
	private String getCapitalizedString(String name)
	{
		name = name.replace("_", " ");
		String[] tokens = name.split("\\s");
		name = "";
		for(int i = 0; i < tokens.length; i++)
		{
			String currToken = tokens[i];
			if(currToken != null && currToken.length() > 0)
			{
			    char capLetter = Character.toUpperCase(currToken.charAt(0));
			    name +=  " " + capLetter + currToken.substring(1, currToken.length());
			}
		}
		return name;
	}
	
	//Overloaded methods Added By Arvind on 16-12-13 to support MultiDB connection : START
	
	private void setObjDetails(String objName, UserInfoBean userInfo)throws ITMException
	{
		try
		{
			//Changed by Dayanand on 25/08/09[ WI89BAS029 || Update instanceActivityLog ]
			instanceInterceptorLog( "setObjDetails" ); //$NON-NLS-1$
			BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB]Object name set..............."); //$NON-NLS-1$
			this.objName = objName;
			BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB]Object name set...............objName"+objName);
			HashMap objDetailMap = this.dbAccess.getObjDetailMap(objName, userInfo);
			if (objDetailMap != null)
			{
				this.msgNo = (objDetailMap.get("MSG_NO") != null)?(String)objDetailMap.get("MSG_NO"):null; //Added by shrutika on 23-02-17
				this.msgString = (objDetailMap.get("MSG_STR") != null)?(String)objDetailMap.get("MSG_STR"):null;//Added by shrutika on 23-02-17
				this.refSer = (objDetailMap.get("REF_SER") != null)?(String)objDetailMap.get("REF_SER"):null; //$NON-NLS-1$ //$NON-NLS-2$
				this.systemDefObjName = (objDetailMap.get("USER_TRAN_WINDOW") != null)?((String)objDetailMap.get("USER_TRAN_WINDOW")).trim():"w_"+objName; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				if( ! systemDefObjName.equalsIgnoreCase(((String)objDetailMap.get("TRAN_WINDOW")).trim())) //$NON-NLS-1$
				{
					this.tranType = "U"; //$NON-NLS-1$
				}
				this.keyFlag = (objDetailMap.get("KEY_FLAG") != null)?(String)objDetailMap.get("KEY_FLAG") : "M"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				this.confirmCol = (objDetailMap.get("CONFIRM_COL") != null)?(String)objDetailMap.get("CONFIRM_COL") : ""; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				this.confirmVal = (objDetailMap.get("CONFIRM_VAL") != null)?(String)objDetailMap.get("CONFIRM_VAL") : ""; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - start
				this.cancelCol = (objDetailMap.get("CANCEL_COL") != null)?(String)objDetailMap.get("CANCEL_COL") : "";
				this.cancelVal = (objDetailMap.get("CANCEL_VAL") != null)?(String)objDetailMap.get("CANCEL_VAL") : "";
				this.closeCol = (objDetailMap.get("CLOSE_COL") != null)?(String)objDetailMap.get("CLOSE_COL") : "";
				this.closeVal = (objDetailMap.get("CLOSE_VAL") != null)?(String)objDetailMap.get("CLOSE_VAL") : "";
				//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - end
				this.tranDateCol = (objDetailMap.get("TRAN_DATE_COL") != null)?(String)objDetailMap.get("TRAN_DATE_COL") : ""; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				this.isAutoConfirm = (objDetailMap.get("AUTO_CONFIRM") != null && "Y".equalsIgnoreCase((String)objDetailMap.get("AUTO_CONFIRM")))?true : false; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				this.isHeaderRepeat = (objDetailMap.get("REPEATE_ADD") != null && "Y".equalsIgnoreCase((String)objDetailMap.get("REPEATE_ADD")))?true : false; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				
//				Changed by Dhruv on 06/11/2007 to support add detail repeat flag.
				this.isDetailRepeat = ( objDetailMap.get( "REPEAT_ADD_DET" ) != null && "Y".equalsIgnoreCase( ( String )objDetailMap.get( "REPEAT_ADD_DET" ) ) ) ? true : false; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$

				this.mainTableName = (objDetailMap.get("TABLE_NAME") != null)?(String)objDetailMap.get("TABLE_NAME"):""; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$

				this.signStatus = (objDetailMap.get("SIGN_STATUS") != null)?(String)objDetailMap.get("SIGN_STATUS") : null; //$NON-NLS-1$ //$NON-NLS-2$
				this.taxList = getTokenList((String)objDetailMap.get( "TAX_FORMS" ), "," ); //$NON-NLS-1$ //$NON-NLS-2$
				this.rateCol = ( objDetailMap.get( "RATE_COL" ) != null) ? (String)objDetailMap.get( "RATE_COL" ) : null; //$NON-NLS-1$ //$NON-NLS-2$
				this.qtyCol = ( objDetailMap.get( "QTY_COL" ) != null) ? (String)objDetailMap.get( "QTY_COL" ) : null; //$NON-NLS-1$ //$NON-NLS-2$
				this.editTemplate = (objDetailMap.get("EDIT_TMPLT") != null)?Integer.parseInt((String)objDetailMap.get("EDIT_TMPLT")) : 0; //$NON-NLS-1$ //$NON-NLS-2$
				this.wrkflwInit = (String)objDetailMap.get("WRKFLW_INIT"); //$NON-NLS-1$

				//Danish Thursday, May 04, 2006
				this.wrkflwOpt = ( objDetailMap.get( "WORKFLOW_OPT" ) != null ) ? ( String ) objDetailMap.get( "WORKFLOW_OPT" ) : this.wrkflwOpt; //$NON-NLS-1$ //$NON-NLS-2$
				if( Integer.parseInt(this.wrkflwOpt) > 1 )
				{
					this.isWrkflwToBeInitiated = true;
				}
				//Changed by Danish on 13/07/2006 for audit trail and editability flag
				this.editOpt = ( objDetailMap.get( "EDIT_OPT" ) != null ) ? ( String ) objDetailMap.get( "EDIT_OPT" ) : this.editOpt; //$NON-NLS-1$ //$NON-NLS-2$
				//Changed by Manish to add new criteria for editing, i.e; in addition to being not confirmed, only if condn. is satisfied shall the transaction be editable.
				this.editExpr = (objDetailMap.get("EDIT_EXPR") != null)?(String)objDetailMap.get("EDIT_EXPR") : null; //$NON-NLS-1$ //$NON-NLS-2$
				
				//Commented by Gulzar on 12/02/16 : Audit Trail should always on : START
				//this.auditTrailOpt = ( objDetailMap.get( "AUDIT_TRAIL_OPT" ) != null ) ? ( String ) objDetailMap.get( "AUDIT_TRAIL_OPT" ) : "1"; //$NON-NLS-1$ //$NON-NLS-2$
				//Commented by Gulzar on 12/02/16 : Audit Trail should always on : END
				
				//Changed by Monif on 02/07/09[To Save data on Add action if SaveFlag in Transetup is A].
				this.saveFlag = (objDetailMap.get("SAVE_FLAG") != null)?(String)objDetailMap.get("SAVE_FLAG") : null; //$NON-NLS-1$ //$NON-NLS-2$
			//	BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB][Object Name=" + this.objName + "][Ref Ser=" + this.refSer + "][Tran type=" + this.tranType +"][System def obj name=" + this.systemDefObjName + "][Key Flag=" + this.keyFlag + "] [Confirm Col="+this.confirmCol+"] [Confirm Val="+this.confirmVal+"] [Tran Date Col ="+this.tranDateCol+"] [Auto Confirm Flag="+this.isAutoConfirm+"] [Header Repeat Flag="+this.isHeaderRepeat+"][Detail Repeat Flag="+this.isDetailRepeat+"][Main Table Name="+this.mainTableName+"] [Sign status =" + this.signStatus + "] [Tax List=" + this.taxList + "] [editTemplate="+ this.editTemplate +"] [Is Wrkflw Init="+ this.wrkflwInit +"] [Edit Opt="+this.editOpt+"] [Audit Trail Opt="+this.auditTrailOpt+"]");
				//Changed by Prasad on 17/03/18 [formName implementation in transaction editor]
				this.objFormInfoMap = new HashMap<String, String>();
			}
			else
			{
				//DDDDDDDDDD
				//if possible send the user an info saying that the invalid object name.
			}
			//Changed by Shrvan on 29/11/2006 as signing module is now based on wrkflwopt and sign list not reqd.Start
			/* 
			if(this.refSer != null && this.dbAccess.isSignDefined(this.refSer))
			{			
				BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB]Checking probable sign objects whether defined or not");
				//SignManagerHome signManagerHome =(SignManagerHome)this.initialContext.lookup("SignManager");
				//SignManager signManager = signManagerHome.create();	
				//this.signList = signManager.getSignObjList(this.objName);
				this.isAutoConfirm = false;
			}
			*/
			//Changed by Shrvan on 29/11/2006 as signing module is now based on wrkflwopt and sign list not reqd.End
			//if(this.signList != null)
			//{
			//	this.isAutoConfirm = false;
			//}
			setContextDetails(userInfo);
			this.actionXmlStr = getActionString(objName, userInfo);
			if( this.headerPKFieldNames == null )
			{
				setHeaderPKFieldNames();
				setArgFieldProperties();
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :setObjDetails :==>"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]Obj name and other initializations done !!!!!!!!!!!!!"); //$NON-NLS-1$
	}

	// Added By Arvind on 17-12-13

	private void setContextDetails(UserInfoBean userInfo) throws java.rmi.RemoteException, ITMException
	{
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]In setContextDetails. . . . . . "); //$NON-NLS-1$
		try
		{
			BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]In setContextDetails. . .before . . . objName ::"+objName);
			String objName = this.objName;
			BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB]In setContextDetails. . .after . . . objName ::"+objName);
			this.contextTitlesList = new ArrayList();
			 //Changed by Taru on 1/12/2008 [ to get scan related info ] start
			this.scanFlagList = new ArrayList();
			this.scanMetadataList = new ArrayList();
			this.autoAcceptScanList = new ArrayList();
            //Changed by Taru on 1/12/2008 [ to get scan related info ] END
			
			//Changed By Pragyan 19/08/08 . [For Property Calculation Show] [SY89BAS005]
			this.calPropertyInfoList = new  ArrayList();
			
			//Changed by Monif on 12/3/2008. [Weighing functionality] [WI89BAS012].Start
			this.weighAfterSaveList = new  ArrayList();
			this.weighColumnOnSaveList = new  ArrayList();
			this.scanDelimiterList = new  ArrayList();
			//Changed by Monif on 12/3/2008. [Weighing functionality] [WI89BAS012].End
			//Changed by Monif on 22/04/09. [Weighing functionality] [WI89BAS012].
			this.extMetadataList = new  ArrayList();
			this.autoAcceptWeighdataList = new  ArrayList();

			//Changed by Prasad on 17/03/18 [formName implementation in transaction editor]
			objFormsDetailList = this.dbAccess.getObjFormsDetailList(objName, userInfo);
			setObjFormInfoMap( objFormsDetailList );
			this.noOfForms = objFormsDetailList.size();
			this.crossUpdateExprList = new ArrayList();
			this.exprVarInfoList = new ArrayList();
			this.targetVarInfoList = new ArrayList();
			for(int i = 0; i < this.noOfForms; i++)
			{
				ArrayList currFormDetailList = (ArrayList)objFormsDetailList.get(i);
				this.contextTitlesList.add(currFormDetailList.get(0));
				this.crossUpdateExprList.add(currFormDetailList.get(1));
				this.exprVarInfoList.add(currFormDetailList.get(2));
				this.targetVarInfoList.add(currFormDetailList.get(3));
				
//				Changed by Taru on 1/11/2008 [ to get scan related info ] start
				this.scanFlagList.add(currFormDetailList.get(5));
				this.scanMetadataList.add(currFormDetailList.get(6));
				this.autoAcceptScanList.add(currFormDetailList.get(7));
				//Changed by Taru on 1/11/2008 [ to get scan related info ] End
				
				//Changed By Pragyan 19/08/08 . [set Propert Info] [SY89BAS005]
				this.calPropertyInfoList.add(currFormDetailList.get(8));

				//Changed by Monif on 12/3/2008. [Weighing functionality] [WI89BAS012].Start
				this.weighAfterSaveList.add(currFormDetailList.get(9));
				this.weighColumnOnSaveList.add(currFormDetailList.get(10));
				this.scanDelimiterList.add(currFormDetailList.get(11));
				//Changed by Monif on 12/3/2008. [Weighing functionality] [WI89BAS012].End
				//Changed by Monif on 22/04/09. [Weighing functionality] [WI89BAS012].
				this.extMetadataList.add(currFormDetailList.get(12));	
				this.autoAcceptWeighdataList.add(currFormDetailList.get(13));
				//Added by Prasad on 02/06/16 [get tran_id_col for all forms]
				if ( currFormDetailList.size() > 27 )
				{
					this.getFormWisePkFldNameMap().put(""+(i+1), ""+currFormDetailList.get(27));
				}
			}
			//Added by Prasad on 02/06/16 [get tran_id_col for all forms] START
			if ( this.masterDataStateful != null )
			{
				this.masterDataStateful.setFormWisePkFldNameMap( this.getFormWisePkFldNameMap() );
			}
			//Added by Prasad on 02/06/16 [get tran_id_col for all forms] END
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :setContextDetails :==>"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
	}
	public ArrayList getContextTitlesList(String objName, UserInfoBean userInfo) throws java.rmi.RemoteException,ITMException
	{
		ArrayList contextTitlesList = null;
		try
		{
			BaseLogger.log("0", userInfo,editorId," :MasterStatefulEJB :objName :==>"+objName);
			//setObjDetails(objName, userInfo);
			if( this.contextTitlesList == null )
			{
				setObjDetails(objName, userInfo);
			}
			contextTitlesList = new ArrayList(this.contextTitlesList);
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :getContextTitlesList :==>"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return contextTitlesList;
	}
	// Added By Arvind on 17-12-13
	private void updateNewDom(String editFlag, UserInfoBean userInfo)throws Exception
	{
		//Changed by Danish on 04/09/2008 try and catch added [ to include exception with Data in Case of itm_default ]
		try
		{
			//Changed by Danish on 04/09/2008 setting null
			this.exceptnMsg = null;
			
			editFlag = (editFlag == null)?this.localEditFlag:editFlag;
			NodeList detailList = null;
			int detailListLength = -1;
			ArrayList itemChangeList = this.dbAccess.getItemChangeElementList( this.objName, this.objContext, userInfo );
			if( editFlag.equalsIgnoreCase( "A" ) ) //$NON-NLS-1$
			{
				detailList = searchNodes(this.detailDom, this.objContext);
				detailListLength = detailList.getLength();
				Node lastDetailNode = detailList.item(detailListLength - 1);
				BaseLogger.log("3", userInfo,editorId,"detailListLength :"+detailListLength); //$NON-NLS-1$
				assignNewDomID(detailList, lastDetailNode, detailListLength);

				//Changed by Dhruv on 18/08/2006 to change sequence of setting in a ne dom. Start
				if( Integer.parseInt(this.objContext) > 1 )
				{
					//assignDefaultValues( this.userInfo.getUserType(), this.userInfo.getEntityCode(), itemChangeList );
					assignPKFieldValues(lastDetailNode);
				}
				/*
				else
				{
					assignPKFieldValues(lastDetailNode);
				}
				*/
				assignArgValues(lastDetailNode, itemChangeList);
				assignNewLineNo(detailList, detailListLength);
			}
			/*
			if( editFlag.equalsIgnoreCase( "A" ) )
			{
				assignNewLineNo(detailList, detailListLength);
			}
			*/
			assignITMDefaultValues( editFlag, itemChangeList );
			if( Integer.parseInt( this.objContext ) == 1 && editFlag.equalsIgnoreCase( "A" ) ) //$NON-NLS-1$
			{
				assignDefaultValues( this.userInfo.getUserType(), this.userInfo.getEntityCode(), itemChangeList );
			}
			//Changed by Dhruv on 18/08/2006 to change sequence of setting in a ne dom. End
			
		}
		catch ( Exception e)
		{
			e.printStackTrace();
			this.exceptnMsg = e.getMessage();
		}
	}

	private String getActionString(String objName, UserInfoBean userInfo)throws ITMException
	{
		String actionStr = ""; //$NON-NLS-1$
		try
		{
			/*DBAccessHome home = null;
			DBAccessRemote ejbObj = null;*/
			DBAccessEJB ejbObj = null;
			BaseLogger.log("3", userInfo,editorId,"this.userInfo :"+this.userInfo); //$NON-NLS-1$
			//home = (DBAccessHome)this.initialContext.lookup("DBAccess");
			//ejbObj = (DBAccessLocal)this.initialContext.lookup("ibase/DBAccessEJB/local"); //$NON-NLS-1$
			ejbObj = new DBAccessEJB();
			//ejbObj = home.create();
			BaseLogger.log("3", userInfo,editorId,"ejbObj :"+ejbObj); //$NON-NLS-1$
			//Added By Ajinkya Gopalkar on 21-SEP-17[For code optimization and reduce server call] Start
			String cacheActionStr = objName + "~~"+ this.userInfo.getProfileId() + "~~" + this.userInfo.getUserLevel();
			//Added Pankaj T on 18-10-17 [To use infinispan cache depends on CACHE_OPT define in ibase.xml 0 = NO Cache, 1 = Internal Cache, 2 = External Cache]
			//Changed by Prasad on 23/11/2020 [check infinispanLocalObj not null]
			if( CommonConstants.CACHE_OPT != 0 && infinispanLocalObj != null )
			{
				if( infinispanLocalObj.contains(cacheActionStr))
				{
					actionStr = infinispanLocalObj.getFormData(cacheActionStr);
				}
				else
				{
					actionStr = ejbObj.getAllActionsString(objName, this.userInfo.getProfileId(), this.userInfo.getUserLevel(), userInfo);
					infinispanLocalObj.putFormData(cacheActionStr, actionStr);
				}
			}
			else
			{
				actionStr = ejbObj.getAllActionsString(objName, this.userInfo.getProfileId(), this.userInfo.getUserLevel(), userInfo);
			}
			//Added By Ajinkya Gopalkar on 21-SEP-17[For code optimization and reduce server call] End
			ejbObj = null;
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :getActionString :==>"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return actionStr;
	}
	private String getMessageOnSave(String tranID, UserInfoBean userInfo) throws RemoteException, ITMException 
	{
		HashMap objDetailMap = this.dbAccess.getObjDetailMap(objName, userInfo);
		
		String msgOnSave = "" ;
		if (objDetailMap != null) 
		{
			msgOnSave = (objDetailMap.get("MSG_ONSAVE") != null) ? ( (String) objDetailMap.get("MSG_ONSAVE") ) : ( " Transaction is saved. " );
			msgOnSave = msgOnSave.replace("<TRAN_ID>", tranID);	
		}
		
		return msgOnSave;
	}
	
	//Added by Dnyaneshwar Chavan on 4-Apr-14 [Add timeZone Data member in user info been as per Danish sir ] Start
	/***
	 * 
	 * If current user time zone is not blank then return the time zone from user Info been
	 * otherwise create a blank time zone  
	 * 
	 * @return the string  
	 */
	private String getUserTimeZone()
	{
		String timeZone = "";
		try
		{
			timeZone = this.userInfo.getTimeZone();
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,editorId, "New time zone set for user" );
			BaseLogger.log("0", userInfo,editorId, "Common version '6-3-0-2' should be match " );
		}
		return timeZone;
	}
	//Added by Dnyaneshwar Chavan on 4-Apr-14 [Add timeZone Data member in user info been as per Danish sir  ] Start

//Overloaded methods Added By Arvind on 16-12-13 to support MultiDB connection : END

	// Added by Raju K on 02-05-14 for Event log and Transaction lock as per danish sir START--
	//Added By Mahesh Patidar on 01/AUG/13[WI3DSUN001|to set and get Editor Id]
	String editorId = "";
	@Lock(LockType.WRITE)
	public void setEditorId(String editorId)
	{
		this.editorId = editorId;
	}
	
	@Lock(LockType.READ)
	public String getEditorId()
	{
		return this.editorId;
	}
	//Ended By Mahesh Patidar
	// Ended by Raju K on 02-05-14 for Event log and Transaction lock as per danish sir END--

	//Changes made by Gulzar to validate the Save XML against XSD on 28/05/14 : START
	private boolean validateXMLAgainstXSD(String saveXMLStr) throws Exception
	{
		String retString = "";
		
		try
		{
			saveXMLStr = "<Root>"+saveXMLStr.substring(saveXMLStr.indexOf("<Detail1"), saveXMLStr.indexOf("</Header0>"))+"</Root>";
			
			String xsdFile = CommonConstants.JBOSSHOME + File.separator + "bin" + File.separator + "XSD" + File.separator + this.objName +".xsd";
			BaseLogger.log("3", userInfo,editorId,"XSD FILE PATH........::"+xsdFile);
			File file = new File(xsdFile);
			BaseLogger.log("3", userInfo,editorId,"xsdFile exist =["+file.exists()+"]");
			if( file.exists() )
			{
				 SchemaFactory factory = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
				 Schema schema = factory.newSchema(new File(xsdFile));
		         
		         InputStream xmlIS = new ByteArrayInputStream(saveXMLStr.getBytes());

		         Validator validator = schema.newValidator();
		         validator.validate(new StreamSource(xmlIS));
		         
		         xmlIS.close();
			}
			else
			{
				BaseLogger.log("3", userInfo,editorId,"Alert : No XSD found against "+ this.objName);
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			return false;
		}
		
		return true;
	}
	//Changes made by Gulzar to validate the Save XML against XSD on 28/05/14 : END
	
	// Added method by Raju K on 01-07-14 for Bug Fixing of start time end time[WI3DSUN001] in Event log and Transaction lock as per danish sir START--
		
	/**
	 * Set the user logger information
	 * @param userCode for user login code
	 * @param objName object name
	 * @param sessionId user current session id
	 * @param editorId editor Id
	 * @param action action name
	 * @param event event name
	 * @param startTime access time start
	 * @param endTime access time end
	 * @param argsParam argumnent params
	 * @param tranId primary key or tran id
	 */
	private void userSetEventLog(String userCode, String objName, String sessionId,String editorId, String action, String event, Date startTime , Date endTime, String argsParam, String tranId)
	{
			String actionMode = "EDIT";
			if("A".equalsIgnoreCase(this.editFlag))
			{
				actionMode = "ADD";
			}
			if ( userInfo != null )
			{
				//Change by shrutika on 03-12-18 for updateEventLog.
				//userEventLogEJB.setEventLog(userCode, objName, sessionId, editorId, action, event, startTime , endTime, argsParam, tranId);
				//Change by shrutika on 05-01-19 for add exception.
				userEventLogEJB.setEventLog(userCode, objName, sessionId, editorId, action, event, startTime , endTime, argsParam, tranId, "Success","SA","");
			}
			else
			{
				BaseLogger.log("3", userInfo,editorId," ============ User info is null then never create event log in MasterStatefulEJB.java file");
			}
	}
	// Added by Raju K on 01-07-14 for Bug Fixing of start time end time[WI3DSUN001] in Event log and Transaction lock as per danish sir END--

	private void setRateNQtyCol() throws Exception
	{
		Statement stmtLocal = null;
		ResultSet rsLocal = null;
		Connection conn = null;
		try
		{
			ConnDriver conDriver = new ConnDriver();
			conn = conDriver.getConnectDB(this.userInfo.getTransDB());
			
			String varRateColName = "";
			String varQtyColName = "";
			String qryStr = "SELECT RATE_COL, QTY_COL FROM OBJ_FORMS WHERE WIN_NAME='w_"+this.objName +"' AND FORM_NO ='"+this.objContext+"' ";
			stmtLocal = conn.createStatement();
			BaseLogger.log("3", userInfo,editorId,"MasterStatefulEJB : setRateNQtyCol : qryStr ["+qryStr+"]");
			rsLocal = stmtLocal.executeQuery( qryStr );
			while( rsLocal.next() )
			{
				varRateColName = rsLocal.getString( "RATE_COL" );
				varQtyColName = rsLocal.getString( "QTY_COL" );
				
				if( varRateColName != null && varRateColName.trim().length() > 0 )
				{
					this.rateCol = varRateColName;
				}
				if( varQtyColName != null && varQtyColName.trim().length() > 0 )
				{
					this.qtyCol = varQtyColName;
				}
				BaseLogger.log("3", userInfo,editorId,"Setting RATE_COL QTY_COL FROM OBJ_FORMS for "+this.objName);
			}
			rsLocal.close();
			rsLocal = null;
			stmtLocal.close();
			stmtLocal = null;
		}
		catch ( Exception e )
		{
			BaseLogger.log("0", userInfo,editorId,"MasterStatefulEJB : setRateNQtyCol : taxCalc :==>\n"+e);
			throw e;
		}//Changed by Danish on 11/14/2008 [To make Local Connection and statement].Start
		finally
		{
			try
			{
				if ( stmtLocal != null )
				{
					stmtLocal.close();
					stmtLocal = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch ( Exception e )
			{
				throw new ITMException(e);
			}			
		}
	}
	//Added by Prajyot on 17JUL15[To get taxes data from Transaction editor] Starts
	public String calculateTax(String objContext, String domID)throws RemoteException,ITMException
	{
		String taxXmlString = null;
		try
		{
			this.changedDataMap = new TreeMap();
			//Changed By Pankaj T. on 19-08-19 As per suggested by KB sir if each_rate not define in daily_exch_rate master then throw error - start
			String taxChgString = calculateTax();
			if( taxChgString != null && taxChgString.length() > 0 && taxChgString.indexOf("<Errors>") != -1)
			{
				return taxChgString;
			}
			//Changed By Pankaj T. on 19-08-19 As per suggested by KB sir if each_rate not define in daily_exch_rate master then throw error - end
			taxXmlString = getAllTaxesXMLString(this.objContext, this.detailDomId);
			StringBuffer tempStringBuff = new StringBuffer();
			tempStringBuff.append("<DocumentRoot>"); 
			tempStringBuff.append("<description>Datawindow Root</description>"); 
			tempStringBuff.append("<group0>"); 
			tempStringBuff.append("<description>Group0 description</description>"); 
			tempStringBuff.append("<Header0>"); 
			tempStringBuff.append("<description>Header0 members</description>"); 
			tempStringBuff.append(taxXmlString);
			tempStringBuff.append("</Header0>"); 
			tempStringBuff.append("</group0>"); 
			tempStringBuff.append("</DocumentRoot>"); 
			
			taxXmlString = tempStringBuff.toString();
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception:MasterStatefulEJB: getTaxXmlString :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return taxXmlString;
	}
	//Added by Prajyot on 17JUL15[To get taxes data from Transaction editor] Ends

	//Added by Sandeep S. on 1-09-16 [[S16EBAS019] To Implement multiple layout support for Editors] Start
	public void setData(String detaillXML) throws ITMException
	{
		String xml = "";
		if(detaillXML != null && detaillXML.length() > 0 )
		{
			xml = detaillXML;
			this.detailDom = parseString(xml);
//			BaseLogger.log("3", userInfo,editorId,"updated detail dom ===>["+serializeDom(this.detailDom)+"]");
			
		}
	}
	//Added by Sandeep S. on 1-09-16 [[S16EBAS019] To Implement multiple layout support for Editors] End
	//Added by samadhan on 21/04/2016 [[S15LBAS001]for Append new dom to Detail] Start 
	public String getAppendXML( String objContext, String domId, String editFlag, String pgContext )throws RemoteException,ITMException
	{
		String dataXML = null;
		try
		{
			instanceInterceptorLog( "getAppendXML" ); 

			this.objContext = objContext;
			this.detailDomId = domId;
			this.pageContext = pgContext;

			if (editFlag != null && editFlag.length() > 0)
			{
				if( Integer.parseInt( this.objContext.trim() ) == 1)
				{
					this.editFlag = editFlag;
					this.localEditFlag = editFlag;
				}
				else
				{
					this.localEditFlag = editFlag;
				}
			}

			if( Integer.parseInt( this.objContext.trim() ) == 1 )
			{
				if( this.detailDom == null )
				{
					// added by mahesh saggam on 9-DEC-19 [In case confirmed, cancelled or edit expression failed, separate message to be given to the user] Start
					//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression.
					//if ( this.editFlag.equalsIgnoreCase("E") && isConfirmed() && this.editExpr != null) 
					if ( this.editFlag.equalsIgnoreCase("E") && ( isClosed() || isCanceled() || isConfirmed() || isNonEditable() ) )
					{
						//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - start
						if( isClose )
						{
							int count = Integer.parseInt(dbAccess.getDBColumnValue("MESSAGES", "COUNT(0)", "MSG_NO = 'NOEDITL'"));
							if( count > 0 )
							{
								String message  = dbAccess.getDBColumnValue("MESSAGES", "MSG_STR", "MSG_NO = 'NOEDITL'");
								String messageDescr  = dbAccess.getDBColumnValue("MESSAGES", "MSG_DESCR", "MSG_NO = 'NOEDITL'");
							    return "<DocumentRoot><Message>"+message+"<br>"+messageDescr+"</Message></DocumentRoot>";
							}
							else
							{
								return "<DocumentRoot><Message>"+Messages.getString("MasterStatefulEJB_selectedTransaction") + this.headerPKFieldValues + Messages.getString("MasterStatefulEJB_modifyTransaction")+"</Message></DocumentRoot>"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
							}
						}
						else if( isCancel )
						{
							int count = Integer.parseInt(dbAccess.getDBColumnValue("MESSAGES", "COUNT(0)", "MSG_NO = 'NOEDITX'"));
							if( count > 0 )
							{
								String message  = dbAccess.getDBColumnValue("MESSAGES", "MSG_STR", "MSG_NO = 'NOEDITX'");
								String messageDescr  = dbAccess.getDBColumnValue("MESSAGES", "MSG_DESCR", "MSG_NO = 'NOEDITOX");
							    return "<DocumentRoot><Message>"+message+"<br>"+messageDescr+"</Message></DocumentRoot>";
							}
							else
							{
								return "<DocumentRoot><Message>"+Messages.getString("MasterStatefulEJB_selectedTransaction") + this.headerPKFieldValues + Messages.getString("MasterStatefulEJB_modifyTransaction")+"</Message></DocumentRoot>"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
							}
						}
						else if( isConfirm )
						{
							int count = Integer.parseInt(dbAccess.getDBColumnValue("MESSAGES", "COUNT(0)", "MSG_NO = 'NOEDITC'"));
							if( count > 0 )
							{
								String message  = dbAccess.getDBColumnValue("MESSAGES", "MSG_STR", "MSG_NO = 'NOEDITC'");
								String messageDescr  = dbAccess.getDBColumnValue("MESSAGES", "MSG_DESCR", "MSG_NO = 'NOEDITC");
							    return "<DocumentRoot><Message>"+message+"<br>"+messageDescr+"</Message></DocumentRoot>";
							}
							else
							{
								return "<DocumentRoot><Message>"+Messages.getString("MasterStatefulEJB_selectedTransaction") + this.headerPKFieldValues + Messages.getString("MasterStatefulEJB_modifyTransaction")+"</Message></DocumentRoot>"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
							}
						}
						else if( isNonEditable )
						{
							int count = Integer.parseInt(dbAccess.getDBColumnValue("MESSAGES", "COUNT(0)", "MSG_NO = 'NOEDITO'"));
							if( count > 0 )
							{
								String message  = dbAccess.getDBColumnValue("MESSAGES", "MSG_STR", "MSG_NO = 'NOEDITO'");
								String messageDescr  = dbAccess.getDBColumnValue("MESSAGES", "MSG_DESCR", "MSG_NO = 'NOEDITO'");
							    return "<DocumentRoot><Message>"+message+"<br>"+messageDescr+"</Message></DocumentRoot>";
							}
							else
							{
								return "<DocumentRoot><Message>"+Messages.getString("MasterStatefulEJB_selectedTransaction") + this.headerPKFieldValues + Messages.getString("MasterStatefulEJB_modifyTransaction")+"</Message></DocumentRoot>"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
							}
						}
						//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - end
					}
					// added by mahesh saggam on 9-DEC-19 [In case confirmed, cancelled or edit expression failed, separate message to be given to the user] End
					//Commented By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - start
					/*else if ( this.editFlag.equalsIgnoreCase("E") && isConfirmed() ) 
					{
						//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - start
						int count = Integer.parseInt(dbAccess.getDBColumnValue("MESSAGES", "COUNT(0)", "MSG_NO = 'NOEDITC'"));
						if( count > 0 )
						{
							String message  = dbAccess.getDBColumnValue("MESSAGES", "MSG_STR", "MSG_NO = 'NOEDITC'");
							String messageDescr  = dbAccess.getDBColumnValue("MESSAGES", "MSG_DESCR", "MSG_NO = 'NOEDITC'");
						    return "<DocumentRoot><Message>"+message+"<br>"+messageDescr+"</Message></DocumentRoot>";
						}
						else
						{
							return "<DocumentRoot><Message>"+Messages.getString("MasterStatefulEJB_selectedTransaction") + this.headerPKFieldValues + Messages.getString("MasterStatefulEJB_hasAlreadyBeenConfirmed")+"<br/>"+"So, cannot be edited"+"</Message></DocumentRoot>"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
						}
						//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - end
					}*/
					//Commented By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - end
					else if ( this.editFlag.equalsIgnoreCase("E") && this.isWrkflwToBeInitiated && isWorkflowPending()  ) //$NON-NLS-1$
					{
						return "<DocumentRoot><Message>"+Messages.getString("MasterStatefulEJB_selectedTransaction") + this.headerPKFieldValues + Messages.getString("MasterStatefulEJB_hasAlreadyConfirmed")+"<br/>"+Messages.getString("MasterStatefulEJB_cannotBeEdited")+"</Message></DocumentRoot>"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
					}
					else
					{
						createDetailDom();
					}
				}
			}
			else
			{
				addChildAddDom();	
			}
			if( this.detailDom != null )
			{
				NodeList detailList = searchNodes( this.detailDom, this.objContext );
				int detailListLength = detailList.getLength();
				StringBuffer tempStringBuff = new StringBuffer();
				for(int ctr = 0; ctr < detailListLength; ctr++)
				{
					tempStringBuff.append(serializeDom(detailList.item(ctr)));
				}
				dataXML = getNormalizedString(tempStringBuff.toString());
			}
		}

		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :getAppendXML :==>\n"+e); 
			e.printStackTrace();
			throw new ITMException(e);
		}
		BaseLogger.log("2", userInfo,editorId,"MasterStatefulEJB :getAppendXML:XML Data:"+dataXML);
		return dataXML;
	}
	//Added by samadhan on 21/04/2016 [[S15LBAS001]for Append new dom to Detail] End
	//Added by Samadhan on 240515[[S15LBAS001]To get taxes data for Simple Transaction editor] Starts
	public String getCalculateTax(String xmlString,String objContext, String domID)throws RemoteException,ITMException
	{
		String taxXmlString = null;
		try
		{
			updateHeaderInfoMap(xmlString);
			this.changedDataMap = new TreeMap();
			//Changed by Prasad on 02/11/16 [to search node from dbId]
			//this.currRecordNode = searchNode( this.detailDom, this.objContext, ( ( Integer.parseInt(this.objContext.trim() ) == 1 ) ? this.headerDomId : this.detailDomId ) );
			this.currRecordNode = searchNode( this.detailDom, this.objContext, ( ( Integer.parseInt(this.objContext.trim() ) == 1 ) ? this.headerDomId : this.detailDomId ), "" );
			//Changed By Pankaj T. on 19-08-19 As per suggested by KB sir if each_rate not define in daily_exch_rate master then throw error - start
			String taxChgString = calculateTax();
			if( taxChgString != null && taxChgString.length() > 0 && taxChgString.indexOf("<Errors>") != -1)
			{
				return taxChgString;
			}
			//Changed By Pankaj T. on 19-08-19 As per suggested by KB sir if each_rate not define in daily_exch_rate master then throw error - end
			taxXmlString = getAllTaxesXMLString(this.objContext, this.detailDomId);
			StringBuffer tempStringBuff = new StringBuffer();
			tempStringBuff.append("<DocumentRoot>"); 
			tempStringBuff.append("<description>Datawindow Root</description>"); 
			tempStringBuff.append("<group0>"); 
			tempStringBuff.append("<description>Group0 description</description>"); 
			tempStringBuff.append("<Header0>"); 
			tempStringBuff.append("<description>Header0 members</description>"); 
			tempStringBuff.append(taxXmlString);
			tempStringBuff.append("</Header0>"); 
			tempStringBuff.append("</group0>"); 
			tempStringBuff.append("</DocumentRoot>"); 

			taxXmlString = tempStringBuff.toString();
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception:MasterStatefulEJB: getCalculateTax :"+e); 
			throw new ITMException(e);
		}
		return taxXmlString;
	}
	//Added by Samadhan on 240515[[S15LBAS001]To get taxes data for Simple Transaction editor] Ends

	//Added by Samadhan[S16GBAS001] on 12/10/2016 To get Replace tax Dom]
	public String getReplaceTaxDom(String xmlString,String objContext, String domID,String taxXmlStr)throws RemoteException,ITMException
	{
		String taxXmlString = null;
		Node currTaxNode = null;
		Node NewTaxNode = null;
		Node currentRecordNode = null;
		try
		{
			updateHeaderInfoMap(xmlString);
			this.changedDataMap = new TreeMap();
			//Changed by Prasad on 02/11/16 [to search node from dbId]
			//currentRecordNode = searchNode( this.detailDom, this.objContext, ( ( Integer.parseInt(this.objContext.trim() ) == 1 ) ? this.headerDomId : this.detailDomId ) );
			currentRecordNode = searchNode( this.detailDom, this.objContext, ( ( Integer.parseInt(this.objContext.trim() ) == 1 ) ? this.headerDomId : this.detailDomId ), "" );
			currTaxNode = getCurrTaxNode();
			NewTaxNode = parseString(taxXmlStr);
			if(currTaxNode != null && currentRecordNode != null)
			{
				currentRecordNode.replaceChild(currentRecordNode.getOwnerDocument().importNode( NewTaxNode.getFirstChild(), true ), currTaxNode);	
			}		
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,editorId,"Exception:MasterStatefulEJB: getCalculateTax :"+e); 
			throw new ITMException(e);
		}
		return taxXmlString;
	}

	//Added By sanket J on 26/04/17 [for pophelp related changes]- [START]
	@Override
	@Lock(LockType.READ)
	public String getDetailDomData() 
	{
		String dataXML = null;
		try 
		{
			if( this.detailDom != null )
			{
				dataXML = getNormalizedString( serializeDom( this.detailDom ) );
			}
		}
		catch (ITMException e) 
		{
			dataXML = null;
			e.printStackTrace();
		}
		return dataXML;
	}
	//Added By sanket J on 26/04/17 [for pophelp related changes]- [END]

	//Added by Prasad on 13/10/17 [to resolve issue of calling service handler from header form] START
	/**
	 * @return the isCurrentDetailValidated
	 */
	public boolean isCurrentDetailValidated() 
	{
		return isCurrentDetailValidated;
	}

	/**
	 * @param isCurrentDetailValidated the isCurrentDetailValidated to set
	 */
	public void setCurrentDetailValidated(boolean isCurrentDetailValidated) 
	{
		this.isCurrentDetailValidated = isCurrentDetailValidated;
	}
	//Added by Prasad on 13/10/17 [to resolve issue of calling service handler from header form] END

	//Added by Prasad on 17/03/18 [formName implementation in transaction editor]
	private void setObjFormInfoMap(ArrayList dbValues)
	{
		try
		{
			for(int i = 0 ; i < dbValues.size() ; i++)
			{
				ArrayList currForm = (ArrayList) dbValues.get(i);
				String title = (String)currForm.get(0);
				String objContext = (String) currForm.get(14);
				String scrType = (String) ( ( currForm.get(15) == null ) ? "" : currForm.get(15) );
				String dbFormType = (String) ( ( currForm.get(16) == null ) ? "" : currForm.get(16) );
				String formName = (String) ( ( currForm.get(32) == null ) ? "" : currForm.get(32) );
				String parentKeyCol = (String) ( ( currForm.get(18) == null ) ? "" : currForm.get(18) );
				BaseLogger.log("3", userInfo,editorId,"objContext =["+objContext+"], formName =["+formName+"]");
				this.objFormInfoMap.put(objContext, dbFormType + OBJ_INFO_SEPARATOR + parentKeyCol + OBJ_INFO_SEPARATOR + scrType + OBJ_INFO_SEPARATOR + formName);
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}

		BaseLogger.log("2", userInfo,editorId,"MasterStateful >> setObjFormInfoMap >> this.objFromInfoMap ::"+this.objFormInfoMap);
	}


	//change by shrutika on 16-06-18 for used in itemchange of paste functionality.
	public String getObjPropValue( String formNo, String objPropName )
	{
		String value = "";
		try
		{
			if( this.objFormInfoMap == null )
			{
				BaseLogger.log("3", userInfo,editorId, objPropName + "= []");
				return "";
			}
			String objFromInfo = this.objFormInfoMap.get( formNo );
			if(objFromInfo != null)
			{
				String[] strArr = objFromInfo.split( OBJ_INFO_SEPARATOR );
				if( "FORM_TYPE".equalsIgnoreCase(objPropName) )
				{
					value = ( strArr != null && strArr.length > 0 ) ? strArr[0] : "" ; //e.g 3:MP:6 or SP or ""
				}
				else if( "PARENT_KEY_COL".equalsIgnoreCase(objPropName) )
				{
					value = ( strArr != null && strArr.length > 1 ) ? strArr[1] : "" ;//e.g sc_code
				}
				else if( "SCR_FLAG".equalsIgnoreCase(objPropName) )
				{
					value = ( strArr != null && strArr.length > 2 ) ? strArr[2] : "" ;//e.g F or T
				}
				else if( "FORM_NAME".equalsIgnoreCase(objPropName) )
				{
					value = ( strArr != null && strArr.length > 3 ) ? strArr[3] : "" ;//e.g F or T
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		BaseLogger.log("2", userInfo,editorId, objPropName + "= [" + value + "]");
		return value;	
	}

	private String getFormName( String formNo )
	{
		String formName = getObjPropValue( formNo, "FORM_NAME" );
		if ( formName == null || formName.trim().length() == 0 )
		{
			formName = formNo;
		}
		return formName;
	}
	//Added by Prasad on 17/03/18 [formName implementation in transaction editor] END
	//Added by Shrutika on 27-04-18 [Start] for getting current form data.
	public String getCurrentFormDetail( String objContext )throws RemoteException,ITMException
	{
		E12GenericUtility genericUtility = new E12GenericUtility();
		Document detilDom = this.detailDom;
		NodeList currentformData = searchNodes(detilDom, objContext);
		//NodeList detailList = searchNodes( this.detailDom, this.objContext );
		int detailListLength = currentformData.getLength();
		StringBuffer tempStringBuff = new StringBuffer();
		for(int ctr = 0; ctr < detailListLength; ctr++)
		{
			tempStringBuff.append(serializeDom(currentformData.item(ctr)));
		}
		String currentFormXML = getNormalizedString(tempStringBuff.toString());
		return currentFormXML;
	}
	//Added by Shrutika on 27-04-18 [End] for getting current form data.

	//Changed by Prasad on 31/01/19 [to validate client and server side data and perform respected action] START
	/**
	 * Validate client side and server side data and perform respected action
	 * 
	 * @param xmlStr
	 * @param action
	 * @return
	 * @throws RemoteException
	 * @throws ITMException
	 */
	@Override
	public String validateAndPerformAction(String xmlStr, String action) throws RemoteException, ITMException 
	{
		BaseLogger.log( "2", userInfo, editorId, "In validateAndPerformAction :: action : ["+ action + "]");
		
		String retString = "";
		try
		{
			boolean isErrorNodeFound = false;
			updateHeaderInfoMap( xmlStr );
			//Changes made by Pratheek on 30-04-19[ item change not woriking in tax screen because currRecordNode was coming null ]-Start
			if( this.currRecordNode == null )
			{
				this.currRecordNode = searchNode( this.detailDom, this.objContext, ( ( Integer.parseInt( this.objContext.trim() ) == 1 ) ? this.headerDomId : this.detailDomId ), this.currDbID );
			}
			//Changes made by Pratheek on 30-04-19[ item change not woriking in tax screen because currRecordNode was coming null ]-End
			Document xmlStrDoc = null;
			if( xmlStr != null && ! xmlStr.equals( "-1" ) ) 
			{
				BaseLogger.log( "3", userInfo, editorId, "editFlag : ["+ this.editFlag +"], localEditFlag : ["+ this.localEditFlag +"], keyFlag : ["+ keyFlag +"]" );
				
				E12GenericUtility genericUtility = new E12GenericUtility();
				xmlStr = genericUtility.setXmlDec( xmlStr );			
				xmlStrDoc = parseString( xmlStr );
				
				this.focussedColumn = ( String )this.headerInfoMap.get( "focusedColumn" ); 
				this.saveLevel = ( String )this.headerInfoMap.get( "saveLevel" );
				boolean isTaxInFocus = ( (Boolean) this.headerInfoMap.get("taxInFocus") ).booleanValue();
				
				String xmlStrObjContext = ( String )this.headerInfoMap.get( "objContext" ); 
				
				DWObject dwObject = getDWObject( this.objName, Integer.parseInt( xmlStrObjContext.trim() ) );
				Hashtable dbTypes = dwObject.getUpdateableLogNameColType();
				HashMap<String, String> nonEditableLogPhyColMap = dwObject.getNonEditableLogPhyColMap();
				//Added By Pankaj T. on 24-11-2021 [Added validation of length, if column value exceeds DB SIZE then it will throw an error.]
				HashMap<String, Integer> colLogNameSizeMap = dwObject.getColLogNameSizeMap();
				ArrayList primaryKeyLogNameList = dwObject.getPrimaryKeyLogNameList();
				
				Node domDetailNode = null;
				BaseLogger.log( "3", userInfo, editorId, "Creating domDetailDom for objContext :[" + this.objContext + "] this.headerDomId :[" + this.headerDomId + "] this.detailDomId :[" + this.detailDomId + "]" );
				if( xmlStrDoc.getElementsByTagName( "Root" ).item( 0 ) != null || xmlStrDoc.getElementsByTagName( "DocumentRoot" ).item( 0 ) != null ) 
				{
					Node rootNode = xmlStrDoc.getElementsByTagName( "Root" ).item( 0 ); 
					if ( rootNode == null )
					{
						rootNode = xmlStrDoc.getElementsByTagName( "DocumentRoot" ).item( 0 );
					}
					NodeList xmlStrDetailList = rootNode.getChildNodes(); //data tags with Detail/Detail1
					int xmlStrDetailListLength = xmlStrDetailList.getLength();
					for ( int i = 0; i < xmlStrDetailListLength; i++ )
					{
						Node currXMLStrDetail = xmlStrDetailList.item(i);
						String tagName = currXMLStrDetail.getNodeName();
						String formNo = null;
						String domIdStr = null;
						String dbIdStr = null;
						BaseLogger.log( "3", userInfo, editorId, "tagName [" + tagName + "]" );  //$NON-NLS-2$
						if ( tagName.startsWith( "Detail" ) ) 
						{
							formNo = ( tagName.length() > "Detail".length() ) ? ( tagName.substring( "Detail".length() ) ) : this.objContext;  //$NON-NLS-2$
							
							if( ! xmlStrObjContext.trim().equals( formNo ) )
							{
								dwObject = getDWObject( this.objName, Integer.parseInt( formNo ) );
								dbTypes = dwObject.getUpdateableLogNameColType();
								nonEditableLogPhyColMap = dwObject.getNonEditableLogPhyColMap();
							}
							domIdStr = ( formNo != null && formNo.equalsIgnoreCase( "1" ) ) ? "1" : null;  //$NON-NLS-2$
							if( ( ( Node ) ( ( NamedNodeMap )currXMLStrDetail.getAttributes() ).getNamedItem( "domID" ) ) != null ) 
							{
								domIdStr = ( ( Node ) ( ( NamedNodeMap )currXMLStrDetail.getAttributes() ).getNamedItem( "domID" ) ).getNodeValue(); 
							}
							if( ( ( Node ) ( ( NamedNodeMap )currXMLStrDetail.getAttributes() ).getNamedItem( "dbID" ) ) != null )
							{
								dbIdStr = ( ( Node ) ( ( NamedNodeMap )currXMLStrDetail.getAttributes() ).getNamedItem( "dbID" ) ).getNodeValue();
							}
							BaseLogger.log("3", userInfo,editorId, "Searching corresponding data to which changes to be appied domIdStr :["+domIdStr+"], dbIdStr :["+ dbIdStr +"]");
							BaseLogger.log("3", userInfo,editorId, "is tax in focus :["+ isTaxInFocus +"]" );
							
							if( isTaxInFocus )
							{
								domIdStr = (domIdStr != null && domIdStr.length() > 0)?domIdStr : (String)this.headerInfoMap.get("taxKeyValue");
								if(this.currTaxNode == null)
								{
									this.currTaxNode = getCurrTaxNode();
								}
								NodeList taxNodeList = this.currTaxNode.getChildNodes();
								int taxDomIdCtr = 0;
								for(int j = 0; j < taxNodeList.getLength(); j++)
								{
									Node currTaxNode = taxNodeList.item( j );
									if( currTaxNode.getNodeType() == Node.ELEMENT_NODE )
									{
										if( domIdStr.equalsIgnoreCase( "" + ( ++taxDomIdCtr ) ) )
										{
											domDetailNode = currTaxNode;
											break;
										}
									}
								}
							}
							else
							{
								domIdStr = (domIdStr != null && domIdStr.length() > 0) ? domIdStr : (String)this.headerInfoMap.get( "keyValue" ); //$NON-NLS-1$
								dbIdStr = (dbIdStr != null && dbIdStr.length() > 0) ? dbIdStr : this.currDbID; //$NON-NLS-1$
								BaseLogger.log("3", userInfo,editorId, "In else ------------- domIdStr :["+domIdStr+"], dbIdStr :["+ dbIdStr +"]");
								domDetailNode = searchNode( this.detailDom, formNo, domIdStr, dbIdStr );
							}
							
							if( domDetailNode != null )
							{
								//Added By Pankaj T. on 24-11-2021 [Added validation of length, if column value exceeds DB SIZE then it will throw an error.]
								retString = validateDetail( currXMLStrDetail, domDetailNode, dbTypes, nonEditableLogPhyColMap, primaryKeyLogNameList, formNo, colLogNameSizeMap );
								BaseLogger.log( "3", userInfo, editorId, "retString :["+ retString +"]" );
								if ( retString.indexOf( "<Errors>" ) != -1 )
								{
									isErrorNodeFound = true;
									break;
								}
							}
						}
					}
				}
				BaseLogger.log( "3", userInfo, editorId, "isErrorNodeFound : ["+ isErrorNodeFound +"], action : ["+ action +"]" );
				if ( ! isErrorNodeFound )
				{
					if ( "ITEM_CHANGE".equals( action ) )
					{
						retString = applyItemChange( xmlStr );
					}
					else if ( "VAL_DATA".equals( action ) )
					{
						retString = updateDetailDom( xmlStr );
						//Added By Pankaj T. on 17-02-2021 - added new attributes in detail tag valdatastat, taxcalcstat & id for  checking current record is valid or not at the time of adding new detail - start
						BaseLogger.log("3", userInfo,editorId,"In validateAndPerformAction retString["+retString+"]");
						Node detailNode = null;
						E12GenericUtility e12GenericUtility = new E12GenericUtility();
						if( this.detailDom != null )
						{
							detailNode = searchNode(this.detailDom, this.objContext, this.detailDomId, this.currDbID);
						}
						//boolean isValid = (retString.indexOf("<Errors>") != -1)?false:true;
						isErrorNodeFound = new E12GenericUtility().isErrorNodeFound( E12GenericUtility.checkNull( (retString) ) );
						BaseLogger.log("3", userInfo,editorId,"In validateAndPerformAction isErrorNodeFound before update valdatastat : [" + isErrorNodeFound +"]");
						if(!isErrorNodeFound)
						{
							if( detailNode != null )
							{
								((Element) detailNode).setAttribute("valdatastat", "3");
							}
						}
						else
						{
							if( detailNode != null )
							{
								((Element) detailNode).setAttribute("valdatastat", "2");
							}
						}
						//Added By Pankaj T. on 17-02-2021 - added new attributes in detail tag valdatastat, taxcalcstat & id for  checking current record is valid or not at the time of adding new detail - end
					}
				}
			}
		}
		catch( Exception e )
		{
			BaseLogger.log( "0", userInfo, editorId, "Exception in validateAndPerformAction : ["+ e.getMessage() + "]");
			throw new ITMException( e );
		}
		BaseLogger.log( "2", userInfo, editorId, "In validateAndPerformAction :: retString : ["+ retString + "]");
		return retString;
	}
	
	/**
	 * 
	 * @param clientDetailNode
	 * @param domDetailNode
	 * @param dbTypes
	 * @param nonEditableLogPhyColMap
	 * @param primaryKeyLogNameList
	 * @return
	 * @throws RemoteException
	 * @throws ITMException
	 */
	private String validateDetail( Node clientDetailNode, Node domDetailNode, Hashtable dbTypes, HashMap<String, String> nonEditableLogPhyColMap, ArrayList primaryKeyLogNameList, String formNo, HashMap<String, Integer> colLogNameSizeMap ) throws RemoteException, ITMException
	{
		BaseLogger.log( "2", userInfo, editorId, "In validateDetail :: formNo : ["+formNo+"]");
		BaseLogger.log( "2", userInfo, editorId, "In validateDetail :: nonEditableLogPhyColMap : ["+ nonEditableLogPhyColMap +"], primaryKeyLogNameList : ["+ primaryKeyLogNameList +"]" );
		String retString = "";
		try
		{
			E12GenericUtility genericUtility = new E12GenericUtility();
			
			//String xmlStrEditFlag = this.localEditFlag;
			boolean isExists = false;
			boolean isTaxInFocus = ( (Boolean) this.headerInfoMap.get("taxInFocus") ).booleanValue();
			
			NodeList domDetailChildList = domDetailNode.getChildNodes();
			int domDetailChildListLength = domDetailChildList.getLength();
			
			String currDomIDStr = ( isTaxInFocus ) ? this.detailDomId : domDetailNode.getAttributes().getNamedItem("domID").getNodeValue(); //$NON-NLS-1$ //$NON-NLS-2$
			String currObjCtxStr = ( isTaxInFocus ) ? this.objContext : domDetailNode.getAttributes().getNamedItem("objContext").getNodeValue(); //$NON-NLS-1$ //$NON-NLS-2$
			
			NodeList clientDetailChildList = clientDetailNode.getChildNodes();
			int clientDetailChildListLength = clientDetailChildList.getLength();
			
			BaseLogger.log("3", userInfo, editorId, "Inside validateXML :: currDomIDStr["+currDomIDStr+"] currObjCtxStr["+currObjCtxStr+"] and ["+this.headerInfoMap.get("keyValue")+"]");
			String updateFlag = "";
			BaseLogger.log( "3", userInfo, editorId, "colLogNameSizeMap : ["+ colLogNameSizeMap.toString() +"]");
			for( int iCtr = 0; iCtr < clientDetailChildListLength; iCtr++ )
			{
				if( clientDetailChildList.item(iCtr).getNodeType() == Node.ELEMENT_NODE )
				{
					if ( "D".equals( updateFlag ) )
					{
						break;
					}
					String clientDetailColName = clientDetailChildList.item(iCtr).getNodeName();
					BaseLogger.log( "3", userInfo, editorId, "clientDetailColName ["+ clientDetailColName +"]" );
					//Changed by Pankaj T. on 30-04-19 As per KB Sir added condition temporary for skip tax_amt validation in detail form, need to update detail form feeddata & redraw detail feed - start
					if( !"tax_amt".equals(clientDetailColName) )
					{
						String dataType = (String)dbTypes.get( clientDetailColName );
						
						String clientDetailColValue = "";
						String domDetailColValue = "";
						
						Node detailNode = clientDetailChildList.item(iCtr).getFirstChild();
						if( detailNode != null )
						{
							if ( dataType != null && dataType.length() > 0 )
							{
								if ( dataType.toUpperCase().indexOf("XMLTYPE") != -1 )
								{
									clientDetailColValue = serializeDom( clientDetailChildList.item(iCtr) );
								}
								else
								{
									clientDetailColValue = detailNode.getNodeValue();
								}
							}
							else
							{
								clientDetailColValue = detailNode.getNodeValue();
							}
						}
						clientDetailColValue = E12GenericUtility.checkNull( clientDetailColValue );
						BaseLogger.log( "3", userInfo, editorId, "clientDetailColValue ["+ clientDetailColValue +"]" );
						for( int oCtr = 0; oCtr < domDetailChildListLength; oCtr++ )
						{
							if( domDetailChildList.item(oCtr).getNodeType() == Node.ELEMENT_NODE )
							{
								Node curDomDetChild = domDetailChildList.item(oCtr);
								String domDetColName = curDomDetChild.getNodeName();
								if( "attribute".equals( clientDetailColName ) && curDomDetChild.hasAttributes() && curDomDetChild.getAttributes().getNamedItem( "updateFlag" ) != null )
								{
									updateFlag = curDomDetChild.getAttributes().getNamedItem( "updateFlag" ).getNodeValue();
									BaseLogger.log( "3", userInfo, editorId, "updateFlag : ["+ updateFlag +"]" );
									if ( "D".equals( updateFlag ) )
									{
										break;
									}
									continue;
								}
								
								String protectValue = "";
								if( clientDetailColName.equals( domDetColName ) )
								{
									if( curDomDetChild.hasAttributes() && curDomDetChild.getAttributes().getNamedItem( "protect" ) != null )
									{
										protectValue = curDomDetChild.getAttributes().getNamedItem( "protect" ).getNodeValue();
									}
									BaseLogger.log( "3", userInfo, editorId, "domDetColName : ["+ domDetColName +"], protectValue : ["+ protectValue +"]" );
									
									detailNode = domDetailChildList.item(oCtr).getFirstChild();
									if( detailNode != null )
									{
										if ( dataType != null && dataType.length() > 0 )
										{
											if ( dataType.toUpperCase().indexOf("XMLTYPE") != -1 )
											{
												domDetailColValue = serializeDom( curDomDetChild );
											}
											else
											{
												domDetailColValue = detailNode.getNodeValue();
											}
										}
										else
										{
											domDetailColValue = detailNode.getNodeValue();
										}
									}
									domDetailColValue = E12GenericUtility.checkNull( domDetailColValue );
									BaseLogger.log( "3", userInfo, editorId, "domDetailColValue ["+ domDetailColValue +"]" );
									//Changed By Pankaj T. on 03-10-19 [for field datatype is numeric then value convert into specific datatype from string and check its equals or not] - start
									BaseLogger.log( "3", userInfo, editorId, "dataType of field ["+ dataType +"]" );
									boolean dataMatch = false;
									if( "int".equals(dataType) || "float".equals(dataType) || "double".equals(dataType) || "long".equals(dataType) || "decimal".equals(dataType) )
									{
										if( "int".equals(dataType) )
										{
											int domVal = 0;
											int clientVal = 0;
											if( !"".equals(clientDetailColValue) )
											{
												clientVal = Integer.parseInt(clientDetailColValue);
											}
											if( !"".equals(domDetailColValue) )
											{
												domVal = Integer.parseInt(domDetailColValue);
											}
											if( clientVal == domVal )
											{
												dataMatch = true;
											}
										}
										if( "float".equals(dataType) )
										{
											float domVal = 0;
											float clientVal = 0;
											if( !"".equals(clientDetailColValue) )
											{
												clientVal = Float.parseFloat(clientDetailColValue);
											}
											if( !"".equals(domDetailColValue) )
											{
												domVal = Float.parseFloat(domDetailColValue);
											}
											if( clientVal == domVal )
											{
												dataMatch = true;
											}
										}
										if( "long".equals(dataType) )
										{
											long domVal = 0;
											long clientVal = 0;
											if( !"".equals(clientDetailColValue) )
											{
												clientVal = Long.parseLong(clientDetailColValue);
											}
											if( !"".equals(domDetailColValue) )
											{
												domVal = Long.parseLong(domDetailColValue);
											}
											if( clientVal == domVal )
											{
												dataMatch = true;
											}
										}
										if( "double".equals(dataType) )
										{
											double domVal = 0;
											double clientVal = 0;
											if( !"".equals(clientDetailColValue) )
											{
												clientVal = Double.parseDouble(clientDetailColValue);
											}
											if( !"".equals(domDetailColValue) )
											{
												domVal = Double.parseDouble(domDetailColValue);
											}
											if( clientVal == domVal )
											{
												dataMatch = true;
											}
										}
										if( "decimal".equals(dataType) )
										{
											double domVal = 0;
											double clientVal = 0;
											if( !"".equals(clientDetailColValue) )
											{
												clientVal = Double.parseDouble(clientDetailColValue);
											}
											if( !"".equals(domDetailColValue) )
											{
												domVal = Double.parseDouble(domDetailColValue);
											}
											if( clientVal == domVal )
											{
												dataMatch = true;
											}
										}
									}
									else
									{
										dataMatch = clientDetailColValue.equals(domDetailColValue);
									}
									//Changed By Pankaj T. on 03-10-19 [for field datatype is numeric then value convert into specific datatype from string and check its equals or not] - end
									boolean isNonEditable = nonEditableLogPhyColMap.containsKey( domDetColName );
									boolean isProtected = "1".equals( protectValue );
									boolean isPkField = primaryKeyLogNameList.contains( domDetColName );
									boolean isAddNew = ( "A".equals( this.editFlag ) || ( "E".equals( this.editFlag ) && "A".equals( updateFlag ) ) );
									BaseLogger.log( "3", userInfo, editorId, "isNonEditable : ["+ isNonEditable +"], isProtected : ["+ isProtected +"], isPkField : ["+ isPkField +"], isAddNew : ["+ isAddNew +"], dataMatch : ["+ dataMatch+"]" );
									StringTokenizer pkNameTokens = new StringTokenizer( this.headerPKFieldNames, ":" );
									ArrayList<String> headerPrimaryKeyList = new ArrayList<>();
									while( pkNameTokens.hasMoreTokens() )
									{
										headerPrimaryKeyList.add( pkNameTokens.nextToken() );
									}
									if( !"1".equals(formNo) )
									{
										headerPrimaryKeyList.add("line_no");
									}
									BaseLogger.log( "3", userInfo, editorId, "headerPrimaryKeyList : ["+ headerPrimaryKeyList +"]");
									if ( ( ( isNonEditable || isProtected || isPkField ) )
											&& ( !(isAddNew) || (isAddNew && headerPrimaryKeyList.contains(domDetColName) && ("A".equals(keyFlag) || ("M".equals(keyFlag) && !("1".equals(formNo) ) ) ) ) )
											&& ( ! dataMatch )) 
									{
                                        retString = genericUtility.getErrorString( clientDetailColName, "VTINVTDATA", userInfo.getLoginCode() );
                                        //Added by Pankaj T. on 11-09-2020 written log for system inconsitency detected details in file Firewall_breach_attempts.log in ExceptionLog folder
                                        genericUtility.writeSystemInconsistencyLogInFile( userInfo, "ProtectedDataAltered", this.objName, "", domDetColName, clientDetailColValue, domDetailColValue, "" );
										return retString = genericUtility.updateXMLString("trace", "Non editable column ( "+ domDetColName +" ) value is mismatch", retString, userInfo);
									}
									//Added By Pankaj T. on 24-11-2021 [Added validation of length, if column value exceeds DB SIZE then it will throw an error.] - start
									//Commented on 19-01-2022 [as per suggested by SM Sir commeted temporary because lot of changes required in metadata & it's required more time.]
									/*if( colLogNameSizeMap.containsKey(domDetColName))
									{
										int colDBLen = colLogNameSizeMap.get( domDetColName );
										int colValLen = clientDetailColValue.length();
										BaseLogger.log( "3", userInfo, editorId, "column DB SIZE : ["+ colDBLen +"]");
										BaseLogger.log( "3", userInfo, editorId, "column Value Length : ["+ colValLen +"]");
										if (  colDBLen > 0 && colValLen > colDBLen ) 
										{
											retString = genericUtility.getErrorString( clientDetailColName, "VTINVTDATA", userInfo.getLoginCode() );
											//Added by Pankaj T. on 11-09-2020 written log for system inconsitency detected details in file Firewall_breach_attempts.log in ExceptionLog folder
											genericUtility.writeSystemInconsistencyLogInFile( userInfo, "ProtectedDataAltered", this.objName, "", domDetColName, clientDetailColValue, domDetailColValue, "" );
											return retString = genericUtility.updateXMLString("trace", "Value of the ( "+ domDetColName +" ) column exceeds the DB SIZE.", retString, userInfo);
										}
									}*/
									//Added By Pankaj T. on 24-11-2021 [Added validation of length, if column value exceeds DB SIZE then it will throw an error.] - end
									break;
								}
							}
						}
					}
					//Changed by Pankaj T. on 30-04-19 As per KB Sir added condition temporary for skip tax_amt validation in detail form, need to update detail form feeddata & redraw detail feed - end
				}
			}
		}
		catch( Exception e )
		{
			BaseLogger.log( "0", userInfo, editorId, "Exception in validateXML : ["+ e.getMessage() + "]");
			throw new ITMException( e );
		}
		BaseLogger.log( "2", userInfo, editorId, "In validateDetail :: retString : ["+ retString + "]");
		return retString;
	}
	
	private String getPKFieldNames( int formNo ) throws ITMException
	{
		DWObject dwObj = getDWObject( this.objName, formNo );
		ArrayList primaryKeyLogNameList = dwObj.getPrimaryKeyLogNameList();
		StringBuffer headerPKFieldNamesBuff = new StringBuffer();
		for(int i = 0; i < primaryKeyLogNameList.size(); i++)
		{
			headerPKFieldNamesBuff.append((String)primaryKeyLogNameList.get(i)).append(":"); //$NON-NLS-1$
		}
		if (headerPKFieldNamesBuff.length() > 0)
		{
			headerPKFieldNamesBuff.deleteCharAt((headerPKFieldNamesBuff.length() - 1));
		}
		return headerPKFieldNamesBuff.toString();
	}
	//Changed by Prasad on 31/01/19 [to validate client and server side data and perform respected action] END
	
	//added By Ravindra c on 21-01-19 to restrict itmchange for protected field. - Start 
	private String checkIsProtected( Node fromNode, String currFromColNodeName, String currFormNo ) throws ITMException
	{
		String xmlStr ="";
		E12GenericUtility genericUtility = new E12GenericUtility();
		String dbId = fromNode.getAttributes().getNamedItem("dbID").getNodeValue();
		Node nodeToSetFlag = searchNode(this.detailDom, currFormNo , fromNode.getAttributes().getNamedItem("domID").getNodeValue(), dbId );
		if(nodeToSetFlag != null)
		{
			NodeList tempNodeList = nodeToSetFlag.getChildNodes();
			int tempNodeLen = tempNodeList.getLength();
			for( int i = 0; i < tempNodeLen; i++ )
			{
				Node tempNode = tempNodeList.item( i );
				if( tempNode.getNodeType() == Node.ELEMENT_NODE  )
				{
					String tempNodeName = tempNode.getNodeName();
					if ( tempNodeName.equals( currFromColNodeName ) && tempNode.hasAttributes() )
					{
						xmlStr = tempNode.getAttributes().getNamedItem("protect").getNodeValue();
						break;
					}
				}
			}
		}
		BaseLogger.log("3", userInfo, editorId, "xmlStr :: ["+ xmlStr +"]");
		return xmlStr;
	}
	//added By Ravindra c on 21-01-19 to restrict itmchange for protected field. - End
	
	//Added By Pankaj T. on 08-03-19 for on cancel set old data in detailDom if isFormDirty - start
	public String updateDetailDomOnCancel( String xmlStr ) throws RemoteException, ITMException
	{
		String responseStr = null;
		E12GenericUtility e12GenericUtility = new E12GenericUtility();
		try 
		{
			updateHeaderInfoMap(xmlStr);
			Document xmlStrDoc = null;
			if( xmlStr != null && ! xmlStr.equals( "-1" ) )
			{
				E12GenericUtility genericUtility = new E12GenericUtility();
				xmlStr = genericUtility.setXmlDec( xmlStr );			
				xmlStrDoc = parseString( xmlStr );
				this.focussedColumn = ( String )this.headerInfoMap.get( "focusedColumn" );
				this.saveLevel = ( String )this.headerInfoMap.get( "saveLevel" );
				String xmlStrObjContext = ( String )this.headerInfoMap.get( "objContext" );
				DWObject dwObject = getDWObject( this.objName, Integer.parseInt( xmlStrObjContext.trim() ) );
				Hashtable dbTypes = dwObject.getUpdateableLogNameColType();
				
				Node domDetailNode = null;
				BaseLogger.log("3", userInfo,editorId, "Creating domDetailDom for objContext :[" + this.objContext + "] this.headerDomId :[" + this.headerDomId + "] this.detailDomId :[" + this.detailDomId + "]" );
				if( xmlStrDoc.getElementsByTagName( "Root" ).item( 0 ) != null || xmlStrDoc.getElementsByTagName( "DocumentRoot" ).item( 0 ) != null )
				{
					Node rootNode = xmlStrDoc.getElementsByTagName( "Root" ).item( 0 );
					if ( rootNode == null )
					{
						rootNode = xmlStrDoc.getElementsByTagName( "DocumentRoot" ).item( 0 );
					}
					NodeList xmlStrDetailList = rootNode.getChildNodes(); //data tags with Detail/Detail1
					int xmlStrDetailListLength = xmlStrDetailList.getLength();
					for ( int i = 0; i < xmlStrDetailListLength; i++ )
					{
						Node currXMLStrDetail = xmlStrDetailList.item(i);
						String tagName = currXMLStrDetail.getNodeName();
						String formNo = null;
						String domIdStr = null;
						String dbIdStr = null;
						BaseLogger.log("3", userInfo,editorId, "tagName [" + tagName + "]" );
						if ( tagName.startsWith( "Detail" ) )
						{
							formNo = ( tagName.length() > "Detail".length() ) ? ( tagName.substring( "Detail".length() ) ) : this.objContext; //$NON-NLS-2$
							
							if( ! xmlStrObjContext.trim().equals( formNo ) )
							{
								dwObject = getDWObject( this.objName, Integer.parseInt( formNo ) );
								dbTypes = dwObject.getUpdateableLogNameColType();
							}
							
							domIdStr = ( formNo != null && formNo.equalsIgnoreCase( "1" ) ) ? "1" : null; //$NON-NLS-2$
							if( ( ( Node ) ( ( NamedNodeMap )currXMLStrDetail.getAttributes() ).getNamedItem( "domID" ) ) != null )
							{
								domIdStr = ( ( Node ) ( ( NamedNodeMap )currXMLStrDetail.getAttributes() ).getNamedItem( "domID" ) ).getNodeValue();
							}
							if( ( ( Node ) ( ( NamedNodeMap )currXMLStrDetail.getAttributes() ).getNamedItem( "dbID" ) ) != null )
							{
								dbIdStr = ( ( Node ) ( ( NamedNodeMap )currXMLStrDetail.getAttributes() ).getNamedItem( "dbID" ) ).getNodeValue();
							}
							BaseLogger.log("3", userInfo,editorId, "Searching corresponding data to which changes to be appied domIdStr :["+domIdStr+"], dbIdStr :["+ dbIdStr +"]");
							BaseLogger.log("3", userInfo,editorId, "is tax in focus :["+( (Boolean) this.headerInfoMap.get("taxInFocus") ).booleanValue()+"]" );
							if( ( (Boolean) this.headerInfoMap.get("taxInFocus") ).booleanValue() )
							{
								domIdStr = (domIdStr != null && domIdStr.length() > 0)?domIdStr : (String)this.headerInfoMap.get("taxKeyValue");
								if(this.currTaxNode == null)
								{
									this.currTaxNode = getCurrTaxNode();
								}
								NodeList taxNodeList = this.currTaxNode.getChildNodes();
								int taxDomIdCtr = 0;
								for(int j = 0; j < taxNodeList.getLength(); j++)
								{
									Node currTaxNode = taxNodeList.item( j );
									if( currTaxNode.getNodeType() == Node.ELEMENT_NODE )
									{
										if( domIdStr.equalsIgnoreCase( "" + ( ++taxDomIdCtr ) ) )
										{
											domDetailNode = currTaxNode;
											break;
										}
									}
								}
							}
							else
							{
								domIdStr = (domIdStr != null && domIdStr.length() > 0) ? domIdStr : (String)this.headerInfoMap.get( "keyValue" );
								dbIdStr = (dbIdStr != null && dbIdStr.length() > 0) ? dbIdStr : this.currDbID;
								BaseLogger.log("3", userInfo,editorId, "In else ------------- domIdStr :["+domIdStr+"], dbIdStr :["+ dbIdStr +"]");
								domDetailNode = searchNode( this.detailDom, formNo, domIdStr, dbIdStr );
							}
							if(domDetailNode != null)
							{
								applyDataToXML( currXMLStrDetail, domDetailNode, dbTypes );
							}
						}//if (tagName.startsWith("Detail"))
					}//for (int i = 0; i < xmlStrDetailLength; i++)
				}//if(xmlStrDoc.getElementsByTagName("Root").item(0) != null)
			}//if(xmlStr != null && !xmlStr.equalsIgnoreCase("-1"))
		}
		catch (ITMException itmexp) 
		{
			BaseLogger.log("0", userInfo, editorId, "In updateDetailDomOnCancel ITMException :["+itmexp+"]");
			itmexp.printStackTrace();
		}
		catch (Exception e) 
		{
			BaseLogger.log("0", userInfo, editorId, "In updateDetailDomOnCancel Exception :["+e+"]");
			e.printStackTrace();
		}
		return responseStr;
	}
	//Added By Pankaj T. on 08-03-19 for on cancel set old data in detailDom if isFormDirty - end

	//Added by Prasad on 09/08/19 [to get pkFieldName] START
	@Override
	public String getPKFieldName() 
	{
		return this.headerPKFieldNames;
	}
	//Added by Prasad on 09/08/19 [to get pkFieldName] END
	
	//Added by Pratheek on 05-03-2020[ to add the detail feed in second form when scaaning the product from 1st form]-Start
	public String populateAttachmentData( String evtRetStr, String editFlag ) throws RemoteException, ITMException
	{
		//BaseLogger.log("3", userInfo,editorId,"Inside MasterStateFullEJB 12342!!!! ["+evtRetStr+"]");
		Date startTime = new Date();
		String returnValue = "";
		try
		{
			this.pageContext = "2";

			this.objContext = "2";
			
			if (editFlag != null && editFlag.length() > 0)
			{
				this.localEditFlag = editFlag;
			}
			
			Document eventRetDom = parseString(evtRetStr);
			NodeList eventRetList = eventRetDom.getElementsByTagName("Detail2"); 
			this.eventManager.setUserInfo(this.userInfo); 
			int detailPresent = eventRetList.getLength();
			//BaseLogger.log("3", userInfo,editorId,"Inside MasterStateFullEJB detailPresent 12362!!!! ["+detailPresent+"]");
			if( userInfo != null )
			{
				if("".equals(this.getEditorId()))
				{
					this.editorId = "" + new Date().getTime();
				}
				userEventLogEJB.setEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(),this.getEditorId() , ( String )this.headerInfoMap.get( "action" )  , "" , startTime, null ,"currDomId:[" +( (Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId) + "]", this.headerPKFieldValues,"Pending","SA","");
			}
			if(detailPresent == 0)
			{
				return "<Errors><error id = \"xxxx\" type=\"E\"><message>"+Messages.getString("MasterStatefulEJB_noRecordsFound")+"</message></error></Errors>"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}	
			
			String transDB = this.userInfo.getTransDB();
			String transformStr = "";
			if(transformStr.length() == 0)
			{
				transformStr = evtRetStr;
				Document returnDom = parseString(transformStr);
				NodeList detailList = returnDom.getElementsByTagName("Detail2"); 
				int noOfDetails = detailList.getLength();
				StringBuffer returnStrBuff = new StringBuffer();
				
				BaseLogger.log("3", userInfo,editorId,"pageContext 12401!!!! ["+this.pageContext+"] objContext ["+this.objContext+"] editFlag ["+this.localEditFlag+"]");
				
				String itemChgString = "<?xml version='1.0' encoding='"+this.userInfo.getCharEnc()+"'?>" 
							+ "<Root>" 
							+ "<header>" 
							+ "<objName><![CDATA[" + this.objName +"]]></objName>" 
							+ "<pageContext><![CDATA[" + this.pageContext +"]]></pageContext>" 
							+ "<objContext><![CDATA[" + this.objContext +"]]></objContext>" 
							+ "<editFlag><![CDATA[" + this.localEditFlag +"]]></editFlag>" 
							+ "<saveLevel><![CDATA[0]]></saveLevel>" 
							+ "<forcedSave><![CDATA[false]]></forcedSave>"; 
				
				ArrayList itemChangeList = null;
				if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
				{
					itemChangeList = this.dbAccess.getManadatoryItemChangeElementList( this.objName, this.objContext, "Y", this.userInfo ); //$NON-NLS-1$
				}
				
				BaseLogger.log("3", userInfo,editorId,"Inside MasterStateFulEJB itemChangeList 3487!!!! ["+itemChangeList+"]");
				BaseLogger.log("3", userInfo,editorId,"noOfDetails:["+noOfDetails+"]");
				BaseLogger.log("3", userInfo,editorId,"this.isCurrentDetailValidated:["+this.isCurrentDetailValidated+"]");
				for (int j = 0; j < noOfDetails; j++)
				{   
					Node currDetailNode = detailList.item(j);
					if( (j > 0) || (j == 0 && this.isCurrentDetailValidated ))
					{
						Node domIDAttrNode = currDetailNode.getAttributes().getNamedItem( "domID" ); //$NON-NLS-1$
						String newDomIdVal = null; 
						if( domIDAttrNode != null )
						{
							newDomIdVal = domIDAttrNode.getNodeValue();
							newDomIdVal = ( newDomIdVal != null && newDomIdVal.length() > 0 ) ? newDomIdVal : null;
						}
						Node dbIDAttrNode = currDetailNode.getAttributes().getNamedItem( "dbID" ); //$NON-NLS-1$
						String dbIdVal = null; 
						if( domIDAttrNode != null )
						{
							dbIdVal = dbIDAttrNode.getNodeValue();
							dbIdVal = ( dbIdVal != null && dbIdVal.length() > 0 ) ? dbIdVal : null;
						}
						BaseLogger.log("3", userInfo,editorId,"newDomIdVal 3514!!!! ["+newDomIdVal+"] objContext ["+this.objContext+"]");
						addChildAddDom();
					}
					//BaseLogger.log("3", userInfo,editorId,"Detail DOm 3538!!!!! ["+serializeDom(this.detailDom)+"]");
					this.currRecordNode = searchNode(this.detailDom, this.objContext, (Integer.parseInt(this.objContext.trim()) == 1) ? this.headerDomId : this.detailDomId, "");
					//BaseLogger.log("3", userInfo,editorId,"Inside MasterSateFullEJB currentNode value 3544!!! ["+serializeDom(this.currRecordNode)+"]");
					NodeList childList = currDetailNode.getChildNodes();
					int noOfChilds = childList.getLength();
					String focusedColumn = ""; 
					StringBuffer chgDetailStrBuff = new StringBuffer();
					//BaseLogger.log("3", userInfo,editorId,"noOfChilds 3550!!!! ["+noOfChilds+"]");
					for(int k = 0; k < noOfChilds; k++)
					{
						Node colNode = childList.item(k);
						if(colNode != null && colNode.getNodeType() == Node.ELEMENT_NODE)
						{
							focusedColumn = colNode.getNodeName().toLowerCase();
							String colStr = serializeDom(colNode);
							Node attrNode = colNode.getAttributes().getNamedItem("isSrvCallOnChg"); //$NON-NLS-1$
							String attrVal = null;
							if(attrNode != null)
							{
								attrVal = attrNode.getNodeValue();
							}
							boolean isSrvCallOnChg = (attrVal == null || (attrVal != null && attrVal.trim().length() > 0 && attrVal.trim().equals("1")))?true:false; //$NON-NLS-1$
							BaseLogger.log("3", userInfo,editorId,"Column Name :["+focusedColumn+"] isSrvCallOnChg :["+isSrvCallOnChg+"] ItemChange contains ["+itemChangeList.contains(focusedColumn)+"]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
							if(isSrvCallOnChg && itemChangeList.contains(focusedColumn))
							{
								String newString = itemChgString + "<focusedColumn><![CDATA[" + focusedColumn +"]]></focusedColumn>" //$NON-NLS-1$ //$NON-NLS-2$
												 + "<keyValue><![CDATA[" + ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId) + "]]></keyValue>" //$NON-NLS-1$ //$NON-NLS-2$
												 + "</header><Detail>" + colStr + "</Detail></Root>"; //$NON-NLS-1$ //$NON-NLS-2$
								applyItemChange(newString);
							}
							else
							{
								chgDetailStrBuff.append(colStr);
							}
						}
					}
					BaseLogger.log("3", userInfo,editorId,"[MasterStatefulEJB.setActionData()] Non Item Change Cols :["+chgDetailStrBuff.toString()+"]");
					if(chgDetailStrBuff.length() > 0)
					{
						String newString = itemChgString 
										 + "<keyValue><![CDATA[" + ((Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId) + "]]></keyValue>" //$NON-NLS-1$ //$NON-NLS-2$
										 + "</header><Detail>" + chgDetailStrBuff.toString() + "</Detail></Root>"; //$NON-NLS-1$ //$NON-NLS-2$
						updateHeaderInfoMap(newString);
						handleItemChange( newString );
					}
					String taxChgString = calculateTax();
					if( taxChgString != null && taxChgString.length() > 0 && taxChgString.indexOf("<Errors>") != -1)
					{
						return taxChgString;
					}
					//BaseLogger.log("3", userInfo,editorId,"Detail DOm 3591!!!!! ["+serializeDom(this.detailDom)+"]");
					this.currTaxNode = getCurrTaxNode(this.objContext, this.detailDomId, "");
					crossUpdate(this.objContext, this.detailDom);
					//BaseLogger.log("3", userInfo,editorId,"Detail DOm 3597!!!!! ["+serializeDom(this.detailDom)+"]");
					returnStrBuff.append(serializeDom(this.currRecordNode));
				}
				returnValue = getNormalizedString(returnStrBuff.toString());
			}
			else
			{
				returnValue = transformStr;
			}
			if( userInfo != null )
			{
				userEventLogEJB.updateEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(),this.getEditorId() , ( String )this.headerInfoMap.get( "action" )  , "", startTime, new Date(),"currDomId:[" +( (Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId) + "]", this.headerPKFieldValues,"Success","SA","");
			}
			else
			{
				BaseLogger.log("3", userInfo,editorId," ============ User info is null then never create event log in setActionData() method and MasterStatefulEJB.java file ");
			}
		}
		catch(Exception e)
		{
			if( userInfo != null )
			{
				ITMException ie = new ITMException(e);
				userEventLogEJB.updateEventLog(userInfo.getLoginCode(), this.objName, userInfo.getSesstionId(),this.getEditorId() , ( String )this.headerInfoMap.get( "action" )  , "", startTime, new Date(),"currDomId:[" +( (Integer.parseInt(this.objContext.trim()) == 1)?this.headerDomId : this.detailDomId) + "]", this.headerPKFieldValues,"Exception","SA",ie.getMessage());
			}
			BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :setActionData()==>"); //$NON-NLS-1$
			throw new ITMException(e);
		}
		BaseLogger.log("2", userInfo,editorId,"[MasterStatefulEJB.setActionData()] Return String : ["+returnValue+"]"); //$NON-NLS-1$ //$NON-NLS-2$
		return returnValue;
	}
	//Added by Pratheek on 05-03-2020[ to add the detail feed in second form when scaaning the product from 1st form]-End
	
	//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - start
	private boolean isClosed() throws ITMException
	{
		BaseLogger.log("3", userInfo, editorId, "In isClosed");
		Connection con = null;
		PreparedStatement pStmt = null;
		ResultSet rs = null ;
		String transDB = null;
		
		try
		{
			if ((this.editFlag !=null && this.editFlag.equalsIgnoreCase( "A" )) || this.headerPKFieldValues == null || this.headerPKFieldValues.trim().length() == 0 ) 
			{
				isClose = false;
				return isClose;
			}
			if(isTransactionEditfromWF)
			{
				isClose = false;
				return isClose; 
			}
			StringBuffer queryBuffer = new StringBuffer();
			if ( ( ! "null".equalsIgnoreCase( this.closeCol ) ) && this.closeCol.length() > 0 && ( ! "null".equalsIgnoreCase( this.closeVal ) ) && this.closeVal.length() > 0 && ( this.mainTableName != null &&  this.mainTableName.length() > 0 ) && ( ! "null".equalsIgnoreCase( this.mainTableName ) ) )
			{
				queryBuffer.append( "SELECT COUNT(1) FROM " + this.mainTableName + " WHERE " );
				StringTokenizer pkNameTokens = new StringTokenizer( this.headerPKFieldNames, ":" );
				while( pkNameTokens.hasMoreTokens() )
				{
					String currPKName = pkNameTokens.nextToken();
					queryBuffer.append( currPKName ).append( " = " ).append("?").append( " AND " );
				}

				queryBuffer.append( "(" + this.closeCol+"='"+this.closeVal+"' " );
				queryBuffer.append( ")" );
				if( queryBuffer.length() > 0 )
				{
					E12GenericUtility genericUtility = new E12GenericUtility();
					ConnDriver conDriver = new ConnDriver();
					transDB = this.userInfo.getTransDB();
					if(transDB != null && !"null".equalsIgnoreCase(transDB) && transDB.trim().length() > 0)
					{
						con = conDriver.getConnectDB(transDB);
					}
					BaseLogger.log("3", userInfo,editorId, "Query to check close status :[" + queryBuffer.toString() + "]" );
					pStmt = con.prepareStatement( queryBuffer.toString() );
					if( this.headerPKFieldValues != null && queryBuffer.indexOf( "?" ) != -1 )
					{
						String pkColumnsDataType = this.headerPKFieldDataTypes;
						StringTokenizer qryParamTokens = new StringTokenizer( this.headerPKFieldValues  );
						int pCount=1;
						while(qryParamTokens.hasMoreTokens())
						{
							String testParam = qryParamTokens.nextToken( COLUMN_SEPARATOR );
							if ( pkColumnsDataType != null )
							{
								String testParamType = pkColumnsDataType.substring( 0, pkColumnsDataType.indexOf( COLUMN_SEPARATOR ) );
								BaseLogger.log("3", userInfo,editorId, "Setting Param value :["+testParam+"] Type :["+testParamType+"] position :["+pCount+"]" ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
								if ( testParamType.equalsIgnoreCase( "DATETIME" ) )
								{
									testParam = genericUtility.getValidDateTimeString(testParam, genericUtility.getDispDateFormat(), genericUtility.getDBDateFormat());
									pStmt.setTimestamp(pCount, java.sql.Timestamp.valueOf(testParam));
								}
								else if (testParamType.equalsIgnoreCase("DATE"))
								{
									testParam = getValidDateString( testParam, genericUtility.getDispDateFormat(), genericUtility.getDBDateFormat() );
									pStmt.setDate( pCount, java.sql.Date.valueOf( testParam ) );
								}
								else if ( testParamType.equalsIgnoreCase( "DECIMAL" ) )
								{
									pStmt.setDouble(pCount, Double.parseDouble(testParam));
								}
								else
								{
									DWObject dwObj = getDWObject( this.objName, 1 );
									pStmt.setString( pCount, testParam );
								}
								pkColumnsDataType = pkColumnsDataType.substring( pkColumnsDataType.indexOf( COLUMN_SEPARATOR ) + 1 );
							}
							else
							{
								pStmt.setString( pCount, testParam );
							}
							pCount = pCount + 1;
						}
					}
					rs = pStmt.executeQuery();
					while(rs.next())
					{
						int count = rs.getInt(1);
						if (count > 0)
						{
							isClose = true;
						}
					}
					rs.close();
					rs = null;
				}
			}
			return isClose;
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(con != null)
				{					
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
					con.close();
					con = null;
				}
			}
			catch (Exception e)
			{
				BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :isClosed :finally==>"); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
	}
	
	private boolean isCanceled() throws ITMException
	{
		BaseLogger.log("3", userInfo, editorId, "In isCanceled");
		Connection con = null;
		PreparedStatement pStmt = null;
		ResultSet rs = null ;
		String transDB = null;
		
		try
		{
			if ((this.editFlag !=null && this.editFlag.equalsIgnoreCase( "A" )) || this.headerPKFieldValues == null || this.headerPKFieldValues.trim().length() == 0 ) 
			{
				isCancel = false;
				return isCancel;
			}
			if(isTransactionEditfromWF)
			{
				isCancel = false;
				return isCancel; 
			}
			StringBuffer queryBuffer = new StringBuffer();
			if ( ( ! "null".equalsIgnoreCase( this.cancelCol ) ) && this.cancelCol.length() > 0 && ( ! "null".equalsIgnoreCase( this.cancelVal ) ) && this.cancelVal.length() > 0 && ( this.mainTableName != null &&  this.mainTableName.length() > 0 ) && ( ! "null".equalsIgnoreCase( this.mainTableName ) ) )
			{
				queryBuffer.append( "SELECT COUNT(1) FROM " + this.mainTableName + " WHERE " );
				StringTokenizer pkNameTokens = new StringTokenizer( this.headerPKFieldNames, ":" );
				while( pkNameTokens.hasMoreTokens() )
				{
					String currPKName = pkNameTokens.nextToken();
					queryBuffer.append( currPKName ).append( " = " ).append("?").append( " AND " );
				}

				queryBuffer.append( "(" + this.cancelCol+"='"+this.cancelVal+"' " );
				queryBuffer.append( ")" );
				if( queryBuffer.length() > 0 )
				{
					E12GenericUtility genericUtility = new E12GenericUtility();
					ConnDriver conDriver = new ConnDriver();
					transDB = this.userInfo.getTransDB();
					if(transDB != null && !"null".equalsIgnoreCase(transDB) && transDB.trim().length() > 0)
					{
						con = conDriver.getConnectDB(transDB);
					}
					BaseLogger.log("3", userInfo,editorId, "Query to check cancel status :[" + queryBuffer.toString() + "]" );
					pStmt = con.prepareStatement( queryBuffer.toString() );
					if( this.headerPKFieldValues != null && queryBuffer.indexOf( "?" ) != -1 )
					{
						String pkColumnsDataType = this.headerPKFieldDataTypes;
						StringTokenizer qryParamTokens = new StringTokenizer( this.headerPKFieldValues  );
						int pCount=1;
						while(qryParamTokens.hasMoreTokens())
						{
							String testParam = qryParamTokens.nextToken( COLUMN_SEPARATOR );
							if ( pkColumnsDataType != null )
							{
								String testParamType = pkColumnsDataType.substring( 0, pkColumnsDataType.indexOf( COLUMN_SEPARATOR ) );
								BaseLogger.log("3", userInfo,editorId, "Setting Param value :["+testParam+"] Type :["+testParamType+"] position :["+pCount+"]" ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
								if ( testParamType.equalsIgnoreCase( "DATETIME" ) )
								{
									testParam = genericUtility.getValidDateTimeString(testParam, genericUtility.getDispDateFormat(), genericUtility.getDBDateFormat());
									pStmt.setTimestamp(pCount, java.sql.Timestamp.valueOf(testParam));
								}
								else if (testParamType.equalsIgnoreCase("DATE"))
								{
									testParam = getValidDateString( testParam, genericUtility.getDispDateFormat(), genericUtility.getDBDateFormat() );
									pStmt.setDate( pCount, java.sql.Date.valueOf( testParam ) );
								}
								else if ( testParamType.equalsIgnoreCase( "DECIMAL" ) )
								{
									pStmt.setDouble(pCount, Double.parseDouble(testParam));
								}
								else
								{
									DWObject dwObj = getDWObject( this.objName, 1 );
									pStmt.setString( pCount, testParam );
								}
								pkColumnsDataType = pkColumnsDataType.substring( pkColumnsDataType.indexOf( COLUMN_SEPARATOR ) + 1 );
							}
							else
							{
								pStmt.setString( pCount, testParam );
							}
							pCount = pCount + 1;
						}
					}
					rs = pStmt.executeQuery();
					while(rs.next())
					{
						int count = rs.getInt(1);
						if (count > 0)
						{
							isCancel = true;
						}
					}
					rs.close();
					rs = null;
				}
			}
			return isCancel;
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(con != null)
				{					
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
					con.close();
					con = null;
				}
			}
			catch (Exception e)
			{
				BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :isCanceled :finally==>"); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
	}
	
	private boolean isNonEditable() throws ITMException
	{
		BaseLogger.log("3", userInfo, editorId, "In isNonEditabled");
		Connection con = null;
		PreparedStatement pStmt = null;
		ResultSet rs = null ;
		String transDB = null;
		
		try
		{
			if ((this.editFlag !=null && this.editFlag.equalsIgnoreCase( "A" )) || this.headerPKFieldValues == null || this.headerPKFieldValues.trim().length() == 0 ) 
			{
				isNonEditable = false;
				return isNonEditable;
			}
			if(isTransactionEditfromWF)
			{
				isNonEditable = false;
				return isNonEditable; 
			}
			StringBuffer queryBuffer = new StringBuffer();
			if ( this.editExpr != null )
			{
				queryBuffer.append( "SELECT COUNT(1) FROM " + this.mainTableName + " WHERE " );
				StringTokenizer pkNameTokens = new StringTokenizer( this.headerPKFieldNames, ":" );
				while( pkNameTokens.hasMoreTokens() )
				{
					String currPKName = pkNameTokens.nextToken();
					queryBuffer.append( currPKName ).append( " = " ).append("?").append( " AND " );
				}

				queryBuffer.append( "(" );
				BaseLogger.log("3", userInfo,editorId, "edit expression before :[" + this.editExpr + "]" );
				String editExprn = this.editExpr;
				editExprn = editExprn.trim();
				if( editExprn.startsWith("or ") || editExprn.startsWith("OR ") )
				{
					editExprn = editExprn.substring(3);
				}
				else if( editExprn.startsWith("and ") || editExprn.startsWith("AND ") )
				{
					editExprn = editExprn.substring(4);
				}
				queryBuffer.append( editExprn );
				BaseLogger.log("3", userInfo,editorId, "edit expression after :[" + editExprn + "]" );
				queryBuffer.append( ")" );
				
				if( queryBuffer.length() > 0 )
				{
					E12GenericUtility genericUtility = new E12GenericUtility();
					ConnDriver conDriver = new ConnDriver();
					transDB = this.userInfo.getTransDB();
					if(transDB != null && !"null".equalsIgnoreCase(transDB) && transDB.trim().length() > 0)
					{
						con = conDriver.getConnectDB(transDB);
					}
					BaseLogger.log("3", userInfo,editorId, "Query to check edit expression status :[" + queryBuffer.toString() + "]" );
					pStmt = con.prepareStatement( queryBuffer.toString() );
					if( this.headerPKFieldValues != null && queryBuffer.indexOf( "?" ) != -1 )
					{
						String pkColumnsDataType = this.headerPKFieldDataTypes;
						StringTokenizer qryParamTokens = new StringTokenizer( this.headerPKFieldValues  );
						int pCount=1;
						while(qryParamTokens.hasMoreTokens())
						{
							String testParam = qryParamTokens.nextToken( COLUMN_SEPARATOR );
							if ( pkColumnsDataType != null )
							{
								String testParamType = pkColumnsDataType.substring( 0, pkColumnsDataType.indexOf( COLUMN_SEPARATOR ) );
								BaseLogger.log("3", userInfo,editorId, "Setting Param value :["+testParam+"] Type :["+testParamType+"] position :["+pCount+"]" ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
								if ( testParamType.equalsIgnoreCase( "DATETIME" ) )
								{
									testParam = genericUtility.getValidDateTimeString(testParam, genericUtility.getDispDateFormat(), genericUtility.getDBDateFormat());
									pStmt.setTimestamp(pCount, java.sql.Timestamp.valueOf(testParam));
								}
								else if (testParamType.equalsIgnoreCase("DATE"))
								{
									testParam = getValidDateString( testParam, genericUtility.getDispDateFormat(), genericUtility.getDBDateFormat() );
									pStmt.setDate( pCount, java.sql.Date.valueOf( testParam ) );
								}
								else if ( testParamType.equalsIgnoreCase( "DECIMAL" ) )
								{
									pStmt.setDouble(pCount, Double.parseDouble(testParam));
								}
								else
								{
									DWObject dwObj = getDWObject( this.objName, 1 );
									pStmt.setString( pCount, testParam );
								}
								pkColumnsDataType = pkColumnsDataType.substring( pkColumnsDataType.indexOf( COLUMN_SEPARATOR ) + 1 );
							}
							else
							{
								pStmt.setString( pCount, testParam );
							}
							pCount = pCount + 1;
						}
					}
					rs = pStmt.executeQuery();
					while(rs.next())
					{
						int count = rs.getInt(1);
						if (count > 0)
						{
							isNonEditable = true;
						}
					}
					rs.close();
					rs = null;
				}
			}
			return isNonEditable;
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(con != null)
				{					
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
					con.close();
					con = null;
				}
			}
			catch (Exception e)
			{
				BaseLogger.log("0", userInfo,editorId,"Exception :MasterStatefulEJB :isEditabled :finally==>"); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
	}
	//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. -end

	//Added by Ravindra on 06/09/2021 [restore transaction related point] START
	@Override
	public void addDetailDataInCache()
	{
		if ( infinispanLocalObj != null )
		{
			try
			{
				BaseLogger.log( "2", userInfo, editorId, "In the masterStateful addTransactionData :: objName : ["+ objName +"]" );
				String objData = getDetailDomData();
				if( objData.indexOf( "?>" ) != -1 )
				{
					objData = objData.substring( objData.indexOf("?>") + 2 );
					BaseLogger.log( "2", userInfo, editorId, "In the masterStateful addTransactionData :: objData : ["+ objData +"]" );
				}
				String winName = "w_"+objName;
				DBAccessEJB accessEJB = new DBAccessEJB();
				String objType =  accessEJB.getDBColumnValue( "ITM2MENU", "OBJ_TYPE", "WIN_NAME ='"+ winName +"'", userInfo.getTransDB() );
				BaseLogger.log("3", userInfo,editorId,"objType : ["+ objType +"]");

				JSONArray objTransactionJsonArr = new JSONArray();
				if ( infinispanLocalObj.containsStatefulDataCache( userInfo.getLoginCode() ) )
				{
					objTransactionJsonArr = infinispanLocalObj.getStatefulDataCache( userInfo.getLoginCode() );
				}
				if ( objTransactionJsonArr == null )
				{
					objTransactionJsonArr = new JSONArray();
				}

				JSONObject objTransactionJson = new JSONObject();
				objTransactionJson.put( objName +"_SEP_"+ getEditorId(), objData );
				objTransactionJson.put( "EDITOR_ID", getEditorId() );
				objTransactionJson.put( "PK_VALUES", getHeaderPKFieldValues() );
				objTransactionJson.put( "OBJ_TYPE", objType );
				objTransactionJson.put( "CURRENT_FORM", getObjContext() );
				objTransactionJson.put( "EDIT_FLAG", getEditFlag() );
				BaseLogger.log( "2", userInfo, editorId, "In the masterStateful remove :: objTransactionJson : ["+ objTransactionJson +"]" );

				infinispanLocalObj.setStatefulDataCache( userInfo.getLoginCode(), (objTransactionJsonArr.put( objTransactionJson )) );
			}
			catch(Exception e)
			{
				BaseLogger.log("3", userInfo,editorId,"in the addTransactionData Exception : ["+ e.getMessage() +"]");
				e.printStackTrace();
			}
		}
	}
    //Added by Ravindra on 06/09/2021 [restore transaction related point] END
    //Changes by Jatin M for implementation of formName attribute in DOMString for pre-save action - START
    public void addFormNameToDOM()
    {
        try
		{
            Node prNode = this.detailDom.getElementsByTagName("Header0").item(0);
            NodeList chldNodeList = prNode.getChildNodes();
            int prNodeListLen = chldNodeList.getLength();
            BaseLogger.log("3", userInfo,editorId,"validateData prNodeListLen ["+prNodeListLen+"]");
            for(int prLen = 0; prLen < prNodeListLen; prLen++)
            {
                Node childNode = chldNodeList.item( prLen );
                if (  childNode.getNodeName().indexOf("Detail") != -1 )
                {
                    String currObjContext = childNode.getAttributes().getNamedItem("objContext").getNodeValue();
                    String currformName = getObjPropValue( currObjContext, "FORM_NAME" );
                    String currDomID = childNode.getAttributes().getNamedItem("domID").getNodeValue();
                    String currDbID = childNode.getAttributes().getNamedItem("dbID").getNodeValue();
                    BaseLogger.log("3", userInfo,editorId,"validateData currformName ["+currformName+"] prLen ["+prLen+"] currDomID ["+currDomID+"] currDbID ["+currDbID+"] currObjContext ["+currObjContext+"]");
                    
                    Node detailNode = searchNode(this.detailDom, currObjContext, currDomID, currDbID);
                    if( detailNode != null )
                    {
                        ((Element) detailNode).setAttribute("formName", currformName);
                    }
                }
            }
        }
        catch(Exception e)
        {
            BaseLogger.log("3", userInfo,editorId,"addFormNameToDOM Exception : ["+ e.getMessage() +"]");
        }
    }
    //Changes by Jatin M for implementation of formName attribute in DOMString for pre-save action - END
    
    //Added By Pankaj T. on 16-06-22 to validate & calculate tax of all form records on saving if not validated - start
    private String validateAllFormData( String xmlStrEditFlag ) throws ITMException
    {
    	BaseLogger.log("3", userInfo,editorId,"MasterStatefulEJB.validateAllFormData()");
    	String retString = "";
    	try
    	{
    		String orignalobjContext = this.objContext;
    		String orignaldetailDomId = this.detailDomId;
    		BaseLogger.log("3", userInfo,editorId,"MasterStatefulEJB.validateAllFormData() before validation this.objContext : ["+this.objContext+"]");
			BaseLogger.log("3", userInfo,editorId,"MasterStatefulEJB.validateAllFormData() before validation this.detailDomId : ["+this.detailDomId+"]");
			if( this.detailDom != null && this.noOfForms > 0 )
			{
				this.validateAllFormData = true;
				for( int i = 1; i <= noOfForms; i++ )
				{
					BaseLogger.log("3", userInfo,editorId,"MasterStatefulEJB.validateAllFormData() formNo : ["+i+"]");
					NodeList detailNodeList = this.detailDom.getElementsByTagName("Detail"+i);
					if( detailNodeList != null && detailNodeList.getLength() > 0 )
					{
						for( int j = 0; j < detailNodeList.getLength(); j++ )
						{
							Node detNode = detailNodeList.item(j);
							if( detNode != null )
							{
								String currDomID = detNode.getAttributes().getNamedItem("domID").getNodeValue();
								BaseLogger.log("3", userInfo,editorId,"MasterStatefulEJB.validateAllFormData() domId : ["+currDomID+"]");
								retString = "";
								String valDataReturnVal = "";
								boolean isDataError = false;
								boolean isPermissible = true;
								boolean isErrorNodeFound = false ;
								
								String valdatastat = ((Element) detNode).getAttribute("valdatastat");
								String taxcalcstat = ((Element) detNode).getAttribute("taxcalcstat");
								BaseLogger.log("3", userInfo,editorId,"MasterStatefulEJB.validateAllFormData() valdatastat : ["+valdatastat+"]");
								BaseLogger.log("3", userInfo,editorId,"MasterStatefulEJB.validateAllFormData() taxcalcstat : ["+taxcalcstat+"]");
								
								if( !"".equals(E12GenericUtility.checkNull(valdatastat)) && "0".equals(valdatastat) || "1".equals(valdatastat) || "2".equals(valdatastat) )
								{
									this.objContext = ""+i;
									this.detailDomId = currDomID;
									this.currentEventContext = this.objContext + COLUMN_SEPARATOR + this.focussedColumn;
									valDataReturnVal = validateData(serializeDom(detNode));
									BaseLogger.log("3", userInfo,editorId,"MasterStatefulEJB.validateAllFormData() valDataReturnVal : ["+valDataReturnVal+"]");
									isErrorNodeFound = new E12GenericUtility().isErrorNodeFound( valDataReturnVal );
									if( valDataReturnVal.indexOf( "<Errors>" ) != -1 && isErrorNodeFound )
									{
										Document returnDom = parseString( valDataReturnVal );
										if( returnDom != null )
										{
											NodeList errorNodeItemChgList = returnDom.getElementsByTagName( "error" );
											int errorNodeItemChgListLen = errorNodeItemChgList.getLength();
											for(int k = 0; k < errorNodeItemChgListLen; k++)
											{
												Node errorNode = errorNodeItemChgList.item(k);									
												String itemChgErrorType = errorNode.getAttributes().getNamedItem("type").getNodeValue();
												if( ( "E" ).equals( itemChgErrorType ) )
												{
													String detailDomInfo = "<detailDomId><![CDATA[ "+this.detailDomId+" ]]></detailDomId>";
													errorNode.appendChild( errorNode.getOwnerDocument().importNode( parseString(detailDomInfo).getFirstChild(), true ) );
													detailDomInfo = "<objContext><![CDATA[ "+this.objContext+" ]]></objContext>";
													errorNode.appendChild( errorNode.getOwnerDocument().importNode( parseString(detailDomInfo).getFirstChild(), true ) );
													isPermissible = false;
													break;
												}
											}
										}
										Node returnNode = returnDom.getFirstChild();

										if ( returnNode != null )
										{
											String changedStr = getChangedXMLString();
											if( changedStr != null && changedStr.length() > 0 )
											{
												Document chgDoc = parseString(changedStr);
												Node chgNode = chgDoc.getElementsByTagName("Root").item(0);
												if (chgNode != null )
												{
													NodeList childNodeList = chgNode.getChildNodes();
													int nodeListLength = childNodeList.getLength();
													for(int cCnt=0; cCnt < nodeListLength; cCnt++)
													{
														Node detailNode = childNodeList.item(cCnt);
														if(detailNode.getNodeType() == Node.ELEMENT_NODE)
														{
															returnNode.appendChild(returnNode.getOwnerDocument().importNode(detailNode,true));
														}
													}
												}
												else
												{
													BaseLogger.log("3", userInfo,editorId,"MasterStatefulEJB.validateAllFormData() No Change Data Found");
												}
											}
										}
										else
										{
											BaseLogger.log("3", userInfo,editorId,"MasterStatefulEJB.validateAllFormData() No Root Node Found");
										}
										
										retString = serializeDom( returnDom );
										isDataError = true;
									}
									else
									{
										String isPrompt =  new E12GenericUtility().isPromptOrWarningMsg( valDataReturnVal );
										if("P".equalsIgnoreCase(isPrompt) || "W".equalsIgnoreCase(isPrompt))
										{
											retString = valDataReturnVal;
											isPermissible = false;
											isDataError = true;
											break;
										}
										else
										{
											if( ! this.localEditFlag.equalsIgnoreCase( "V" ) )
											{
												if( ! xmlStrEditFlag.equalsIgnoreCase( "D" ) )
												{
													String taxChgString = calculateTax();
													BaseLogger.log("3", userInfo,editorId,"MasterStatefulEJB.validateAllFormData() taxChgString : ["+taxChgString+"]");
													if( taxChgString != null && taxChgString.length() > 0 && taxChgString.indexOf("<Errors>") != -1)
													{
														return taxChgString;
													}
													this.currTaxNode = getCurrTaxNode( this.objContext, this.detailDomId, "" );
												}
												crossUpdate( this.objContext, this.detailDom );
												retString = getChangedXMLString();
											}
										}
										if (valDataReturnVal.indexOf( "<Errors>" ) != -1 && isErrorNodeFound)
										{
											Document returnDom = parseString( valDataReturnVal );
											
											Node returnNode = returnDom.getFirstChild();

											if ( returnNode != null )
											{
												if( retString != null && retString.length() > 0 )
												{
													Document chgDoc = parseString(retString);
													Node chgNode = chgDoc.getElementsByTagName("Root").item(0);
													if (chgNode != null )
													{
														NodeList childNodeList = chgNode.getChildNodes();
														int nodeListLength = childNodeList.getLength();
														for(int cCnt=0; cCnt < nodeListLength; cCnt++)
														{
															Node detailNode = childNodeList.item(cCnt);
															if(detailNode.getNodeType() == Node.ELEMENT_NODE)
															{
																returnNode.appendChild(returnNode.getOwnerDocument().importNode(detailNode,true));
															}
														}
													}
													else
													{
														BaseLogger.log("3", userInfo,editorId,"MasterStatefulEJB.validateAllFormData() No Change Data Found");
													}
												}
											}
											retString = serializeDom( returnDom );
											isDataError = true;
											BaseLogger.log("3", userInfo,editorId,"MasterStatefulEJB.validateAllFormData() retString123 :::"+retString);
										} 
									}
								}
							}
						}
					}
				}
				this.validateAllFormData = false;
			}
			this.objContext = orignalobjContext;
			this.detailDomId = orignaldetailDomId;
			BaseLogger.log("3", userInfo,editorId,"MasterStatefulEJB.validateAllFormData() after validation this.objContext : ["+this.objContext+"]");
			BaseLogger.log("3", userInfo,editorId,"MasterStatefulEJB.validateAllFormData() after validation this.detailDomId : ["+this.detailDomId+"]");
		}
    	catch (Exception e)
    	{
    		this.validateAllFormData = false;
    		BaseLogger.log("3", userInfo,editorId,"MasterStatefulEJB.validateAllFormData() Exception : ["+E12GenericUtility.getStackTrace(e)+"]");
    		throw new ITMException(e);
		}
    	return retString;
    }
    //Added By Pankaj T. on 16-06-22 to validate & calculate tax of all form records on saving if not validated - end
}

//D Check whether updateHeaderInfoMap is reqd. or not.
//D Tax nodes if existing is referred by this.currTaxNode as and when this.currRecordNode is assigned.
//D If transaction(any context) undergoes any change in data this.isTaxUpdated is set to false.
//D If Tax String requested for
//		(A).Tax not in focus.
//			i).   tax does not exits needs to be calculated.
//			ii).  tax exists but if this.isTaxUpdated is false needs to recalculate
//			iii). tax
//		(B).Tax in focus.
//			i).
//D If Tax

//Getting brow should be handled privately based on pagecontext, only one public data access method to exist