/*
 * Decompiled with CFR 0.152.
 */
package ibase.servlet;

import ibase.ejb.CommonDBAccessEJB;
import ibase.servlet.AuthenticateServlet;
import ibase.system.config.AppConnectParm;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.InternalLogger;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SessionTimeoutFilter
extends AuthenticateServlet
implements Filter {
    private static final long serialVersionUID = 1L;
    ServletContext servletContext = null;
    private String[] excludeUrlsPatterns;

    public void destroy() {
        InternalLogger.log("0", null, null, "SessionTimeoutFilter destroyed.");
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain filterChain) throws IOException, ServletException {
        ArrayList<String> encApplyServletList;
        String queryString;
        String host;
        String requestURL;
        String requestUri;
        String servletPathStr;
        String sessionTimeoutIP;
        String authenticatedIP;
        String errorCode;
        UserInfoBean userInfo;
        HttpServletResponse response;
        HttpServletRequest request;
        boolean isSessionExpired;
        block51: {
            HttpSession sessionObj;
            block50: {
                isSessionExpired = false;
                request = (HttpServletRequest)req;
                response = (HttpServletResponse)resp;
                userInfo = null;
                sessionObj = request.getSession(false);
                String userId = "";
                Enumeration allParams = request.getParameterNames();
                BaseLogger.log("3", null, null, "SessionTimeoutFilter allParams::" + allParams);
                StringBuffer atttsNameAndValue = new StringBuffer();
                while (allParams.hasMoreElements()) {
                    String paramName = (String)allParams.nextElement();
                    String paramValue = request.getParameter(paramName);
                    if ("USER".equals(paramName)) {
                        userId = paramValue;
                    }
                    atttsNameAndValue.append(paramName).append("=").append(paramValue).append("&");
                    if (userInfo == null) continue;
                    userId = userInfo.getLoginCode();
                    BaseLogger.log("3", null, null, "SessionTimeoutFilter userId::" + userId);
                    if (userId.equalsIgnoreCase("SHILPAM")) {
                        BaseLogger.log("3", null, null, "SessionTimeoutFilter request.getRemoteHost::" + request.getRemoteHost());
                        BaseLogger.log("3", null, null, "SessionTimeoutFilter request.getRemotePort::" + request.getRemotePort());
                        BaseLogger.log("3", null, null, "SessionTimeoutFilter request.getHeaderNames::" + request.getHeaderNames());
                        BaseLogger.log("3", null, null, "SessionTimeoutFilter request.getPathInfo::" + request.getPathInfo());
                        BaseLogger.log("3", null, null, "SessionTimeoutFilter request.getRemoteAddr::" + request.getRemoteAddr());
                    }
                    new E12GenericUtility().writeFile("FilterComp", " \n SessionTimeoutFilter : In doFiler() method  userId[," + userId + ",] sessionId[," + request.getSession().getId() + ",] Time[," + new Date() + ",] hostName[," + userInfo.getHostName() + ",] hostIP[," + userInfo.getHostIP() + ",] Attributes[," + atttsNameAndValue.toString() + ",]");
                }
                errorCode = "SESSIONEXP";
                authenticatedIP = "";
                sessionTimeoutIP = "";
                try {
                    Cookie[] cookie;
                    if (sessionObj != null) {
                        BaseLogger.log("3", null, null, "SessionTimeoutFilter session getting not null");
                        userInfo = (UserInfoBean)sessionObj.getAttribute("USER_INFO");
                        String storeSessTime = request.getParameter("STORE_SESS_TIME");
                        BaseLogger.log("3", null, null, "SessionTimeoutFilter storeSessTime: [" + storeSessTime + "]");
                        if (!"false".equalsIgnoreCase(storeSessTime)) {
                            long lastAccessedTimeInmMilliSeconds = sessionObj.getLastAccessedTime();
                            sessionObj.setAttribute("LAST_SRV_CALL", (Object)lastAccessedTimeInmMilliSeconds);
                            BaseLogger.log("3", null, null, "SessionTimeoutFilter LAST_SRV_CALL after: [" + sessionObj.getAttribute("LAST_SRV_CALL") + "]");
                        }
                        if (userInfo == null) {
                            BaseLogger.log("3", null, null, "SessionTimeoutFilter session userInfo is null");
                            errorCode = "SESSIONKIL";
                        }
                        break block50;
                    }
                    BaseLogger.log("3", null, null, "SessionTimeoutFilter session getting null");
                    String hostName = "";
                    try {
                        InetAddress inetAddress = InetAddress.getLocalHost();
                        hostName = inetAddress.getHostName();
                        sessionTimeoutIP = inetAddress.getHostAddress();
                        BaseLogger.log("3", null, null, "SessionTimeoutFilter hostName : [" + hostName + "]");
                        BaseLogger.log("3", null, null, "SessionTimeoutFilter sessionTimeoutIP : [" + sessionTimeoutIP + "]");
                        if (sessionTimeoutIP != null && sessionTimeoutIP.indexOf(".") != -1) {
                            sessionTimeoutIP = sessionTimeoutIP.substring(sessionTimeoutIP.lastIndexOf(".") + 1);
                        }
                    }
                    catch (UnknownHostException e) {
                        BaseLogger.log("0", null, null, "Exception while getting inetAddress : [" + E12GenericUtility.getStackTrace(e) + "]");
                    }
                    if ((cookie = request.getCookies()) != null) {
                        int i = 0;
                        while (i < cookie.length) {
                            String cookieName = cookie[i].getName();
                            String cookieValue = cookie[i].getValue();
                            BaseLogger.log("3", null, null, "SessionTimeoutFilter cookieName : [" + cookieName + "]");
                            BaseLogger.log("3", null, null, "SessionTimeoutFilter cookieValue : [" + cookieValue + "]");
                            if (cookieName.equalsIgnoreCase("authenticatedIP")) {
                                authenticatedIP = cookieValue;
                                BaseLogger.log("3", null, null, "SessionTimeoutFilter cookie authenticatedIP: [" + authenticatedIP + "]");
                                break;
                            }
                            ++i;
                        }
                    }
                    errorCode = E12GenericUtility.checkNull(sessionTimeoutIP).length() > 0 && E12GenericUtility.checkNull(authenticatedIP).length() > 0 && !sessionTimeoutIP.equals(authenticatedIP) ? "SESSIONCHG" : "SESSIONOUT";
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "SessionTimeoutFilter Exception in session getting invalid :[" + E12GenericUtility.getStackTrace(e) + "]");
                }
            }
            servletPathStr = (servletPathStr = request.getServletPath()) == null ? "" : servletPathStr;
            requestUri = request.getRequestURI();
            requestURL = request.getRequestURL().toString();
            host = request.getHeader("host");
            BaseLogger.log("3", null, null, "SessionTimeoutFilter servletPathStr:[" + servletPathStr + "]");
            BaseLogger.log("3", null, null, "SessionTimeoutFilter requestUri:[" + requestUri + "]");
            BaseLogger.log("3", null, null, "SessionTimeoutFilter requestURL:[" + requestURL + "]");
            BaseLogger.log("3", null, null, "SessionTimeoutFilter host:[" + host + "]");
            String isRcpRequestStr = "";
            if (sessionObj != null) {
                isRcpRequestStr = (String)sessionObj.getAttribute("IS_RCP_REQUEST");
            }
            if (this.excludeFromFilter(servletPathStr, requestUri) || "true".equalsIgnoreCase(isRcpRequestStr)) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            String reqHeader = request.getHeader("User-Agent");
            boolean isMobileDevice = false;
            if (reqHeader.indexOf("iPhone") != -1) {
                isMobileDevice = true;
            } else if (reqHeader.indexOf("iPad") != -1) {
                isMobileDevice = false;
            } else if (reqHeader.indexOf("Android") != -1) {
                isMobileDevice = reqHeader.indexOf("Mobile") != -1;
            }
            InternalLogger.log("0", null, null, "@@@@SessionTimeoutFilter Called...  User Agent:[" + reqHeader + "]" + "isMobileDevice:[" + isMobileDevice + "]" + "isIE8[" + (reqHeader.indexOf("MSIE 8.0;") != -1) + "]");
            queryString = request.getQueryString();
            if (E12GenericUtility.checkNull(queryString).length() > 0) {
                queryString = URLDecoder.decode(queryString, CommonConstants.ENCODING);
            }
            if (CommonConstants.APPLICATION_CONTEXT == null) {
                try {
                    InternalLogger.log("0", null, null, "Setting  IBASE_HOME .............in SessionTimeoutFilter[" + this.servletContext.getRealPath("/") + "]");
                    CommonConstants.setAPPLICATION_CONTEXT(this.servletContext.getRealPath("/"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ArrayList<String> authServletPathList = CommonConstants.getAuthServletPathList();
            encApplyServletList = new ArrayList<String>();
            encApplyServletList.add("/AuthenticateServlet");
            encApplyServletList.add("/RIAWizardHandlerServlet");
            encApplyServletList.add("/WelcomeMsgServlet");
            encApplyServletList.add("/ME12FavouriteServlet");
            encApplyServletList.add("/WebITMAuthenticateServlet");
            encApplyServletList.add("/StaticDashboardServlet");
            encApplyServletList.add("/ProfileServiceServlet");
            encApplyServletList.add("/WebITMSignAjaxDataServlet");
            if (userInfo == null) {
                isSessionExpired = !authServletPathList.contains(servletPathStr) && (queryString == null || !queryString.contains("ACTION=LOGIN"));
                try {
                    InternalLogger.log("0", null, null, "isSessionExpired : [" + isSessionExpired + "]");
                    if (!isSessionExpired) break block51;
                    String user = E12GenericUtility.checkNull(request.getParameter("USER"));
                    String password = E12GenericUtility.checkNull(request.getParameter("PASSWORD"));
                    InternalLogger.log("0", null, null, "USER : [" + user + "], PASSWORD : [" + password + "]");
                    if (user.length() > 0 && password.length() > 0) {
                        boolean isValidateUser = Boolean.valueOf(this.authenticate(request));
                        InternalLogger.log("0", null, null, "isValidateUser : [" + isValidateUser + "]");
                        if (isValidateUser) {
                            isSessionExpired = false;
                        }
                    }
                }
                catch (BaseException e) {
                    InternalLogger.log("0", null, null, "SessionTimeoutFilter :: BaseException : [" + e.getMessage() + "]");
                    e.printStackTrace();
                }
            } else {
                isSessionExpired = false;
                if (!"0".equalsIgnoreCase(userInfo.getGeoPosOption())) {
                    String currentGeoPos = E12GenericUtility.checkNull(request.getParameter("CURRENT_GEO_POS"));
                    String dataMode = E12GenericUtility.checkNull(request.getParameter("DATA_MODE"));
                    String currentGeoPosName = E12GenericUtility.checkNull(request.getParameter("CURRENT_GEO_POS_NAME"));
                    String geoPosAccuracy = E12GenericUtility.checkNull(request.getParameter("GEOPOS_ACCURACY"));
                    InternalLogger.log("0", null, null, "@SESSION FILTER CURRENT_GEO_POS [" + currentGeoPos + "] CURRENT_GEO_POS_NAME[" + currentGeoPosName + "] GEOPOS_ACCURACY[" + geoPosAccuracy + "]");
                    if (currentGeoPos.length() > 0 && !currentGeoPos.equalsIgnoreCase(userInfo.getCurrentGeoPOS())) {
                        userInfo.setCurrentGeoPOS(currentGeoPos);
                        userInfo.setDataMode(dataMode);
                        userInfo.setCurrentGeoPOSName(currentGeoPosName);
                        userInfo.setGeoPosAccuracy(geoPosAccuracy);
                        if (sessionObj != null) {
                            sessionObj.setAttribute("USER_INFO", (Object)userInfo);
                        }
                        String deviceUuId = E12GenericUtility.checkNull(request.getParameter("DEVICEUUID"));
                        this.insertGeoPosition(deviceUuId, userInfo);
                    }
                }
            }
        }
        InternalLogger.log("0", null, null, "@@@isSessionExpired [" + isSessionExpired + "]");
        if (isSessionExpired) {
            String formData = "";
            try {
                response.setHeader("Cache-Control", "no-cache");
                response.setHeader("SessionExpire", "true");
                BaseLogger.log("3", null, null, "SessionTimeoutFilter session errorCode:[" + errorCode + "]");
                ITMDBAccessEJB itmDbAccess = new ITMDBAccessEJB();
                formData = itmDbAccess.getErrorString("", errorCode, " ", userInfo);
                BaseLogger.log("3", null, null, "SessionTimeoutFilter session timeout message:[" + formData + "]");
                if ("SESSIONCHG".equals(errorCode) && formData != null && formData.indexOf("<Errors>") != -1) {
                    E12GenericUtility e12GenericUtility = new E12GenericUtility();
                    Document errorDoc = e12GenericUtility.parseString(formData);
                    Node errorsNode = errorDoc.getElementsByTagName("error").item(0);
                    String msgDescription = e12GenericUtility.getColumnValueFromNode("description", errorsNode);
                    InternalLogger.log("0", null, null, "SessionTimeoutFilter : Session Timeout msgDescription:[" + msgDescription + "]");
                    LocalDate currentdate = LocalDate.now();
                    int day = currentdate.getDayOfMonth();
                    int month = currentdate.getMonthValue();
                    int hours = LocalDateTime.now().getHour();
                    int minutes = LocalDateTime.now().getMinute();
                    if (msgDescription != null && msgDescription.indexOf("id:") != -1) {
                        msgDescription = msgDescription.substring(0, msgDescription.indexOf("id:") + 4);
                        msgDescription = String.valueOf(msgDescription) + day + "-" + month + " " + hours + ":" + minutes + ", " + authenticatedIP + ":" + sessionTimeoutIP;
                        InternalLogger.log("0", null, null, "SessionTimeoutFilter : Session Timeout msgDescription after update:[" + msgDescription + "]");
                        formData = e12GenericUtility.updateXMLString("description", msgDescription, formData, userInfo);
                        InternalLogger.log("0", null, null, "SessionTimeoutFilter : Session timeout message after update:[" + formData + "]");
                    }
                }
                response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
                response.getWriter().write(formData);
            }
            catch (ITMException item) {
                String itmExpMsg = item.getMessage();
                InternalLogger.log("0", null, null, "SessionTimeoutFilter : ITMException Msg[" + itmExpMsg + "]");
                response.setHeader("Cache-Control", "no-cache");
                response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
                response.getWriter().write(itmExpMsg);
            }
            catch (Exception e) {
                InternalLogger.log("0", null, null, "SessionTimeoutFilter : Exception in Session Timeout... [" + E12GenericUtility.getStackTrace(e) + "]");
                response.getWriter().write(e.toString());
            }
            InternalLogger.log("0", null, null, "SessionTimeoutFilter : Session Timeout... ");
        } else {
            if (encApplyServletList.contains(servletPathStr)) {
                request.setCharacterEncoding(CommonConstants.ENCODING);
                response.setContentType("text/xml; charset=" + CommonConstants.ENCODING);
                InternalLogger.log("0", null, null, "SessionTimeoutFilter request.getCharacterEncoding() [" + request.getCharacterEncoding() + "]");
                InternalLogger.log("0", null, null, "SessionTimeoutFilter response.getCharacterEncoding() [" + response.getCharacterEncoding() + "]");
            }
            try {
                E12GenericUtility e12GenericUtility = new E12GenericUtility();
                String result = e12GenericUtility.checkVulnerability(queryString, servletPathStr, userInfo, requestUri, requestURL, host);
                if (!"".equals(E12GenericUtility.checkNull(result))) {
                    throw new ITMException(new Exception(result));
                }
            }
            catch (ITMException itmExp) {
                InternalLogger.log("0", null, null, "SessionTimeoutFilter.doFilter() ITMException :[" + itmExp.getMessage() + "]");
                try {
                    String itmExpMsg = itmExp.getMessage();
                    response.setHeader("Cache-Control", "no-cache");
                    response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
                    response.getWriter().write(itmExpMsg);
                    response.getWriter().flush();
                    response.getWriter().close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (Exception e) {
                InternalLogger.log("0", null, null, "SessionTimeoutFilter.doFilter() Exception :[" + E12GenericUtility.getStackTrace(e) + "]");
                try {
                    ITMException itmExp = new ITMException(e);
                    String itmExpMsg = itmExp.getMessage();
                    response.setHeader("Cache-Control", "no-cache");
                    response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
                    response.getWriter().write(itmExpMsg);
                    response.getWriter().flush();
                    response.getWriter().close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        InternalLogger.log("0", null, null, "SessionTimeoutFilter Ends ");
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.servletContext = filterConfig.getServletContext();
        String exUrlPattExt = filterConfig.getInitParameter("excludeUrlsPatterns");
        InternalLogger.log("0", null, null, "excludeUrlsPatterns[" + exUrlPattExt + "]");
        if (exUrlPattExt == null) {
            exUrlPattExt = "css,html,js,png,jpg";
        }
        this.excludeUrlsPatterns = exUrlPattExt.split(",");
    }

    public String getErrorString(String msgNo, boolean isXML, UserInfoBean userInfo) throws RemoteException, ITMException {
        String errStringXml = "";
        try {
            AppConnectParm appConnect = new AppConnectParm();
            InitialContext ctx = new InitialContext(appConnect.getProperty());
            ITMDBAccessEJB itmDbAccess = new ITMDBAccessEJB();
            errStringXml = itmDbAccess.getErrorString("", msgNo, " ", userInfo);
            if (errStringXml != null) {
                if (isXML) {
                    errStringXml = errStringXml.replace("<trace", "<trace type =\"SESSION_EXPIRED\"");
                } else {
                    E12GenericUtility e12GenUtil = new E12GenericUtility();
                    Document errorDoc = e12GenUtil.parseString(errStringXml);
                    Node errorsNode = errorDoc.getElementsByTagName("Errors").item(0);
                    String msgString = e12GenUtil.getColumnValueFromNode("message", errorsNode);
                    String msgDescription = e12GenUtil.getColumnValueFromNode("description", errorsNode);
                    errStringXml = String.valueOf(msgString) + "~SEP~" + msgDescription;
                }
            }
            itmDbAccess = null;
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return errStringXml;
    }

    private boolean excludeFromFilter(String url, String pathUri) {
        int len = this.excludeUrlsPatterns.length;
        int i = 0;
        while (i < len) {
            String suffix = this.excludeUrlsPatterns[i];
            if (url.endsWith(suffix)) {
                return true;
            }
            if (pathUri.contains("/ibase/sessionpushnotification/")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getHTMLData(String messageStr) {
        String hostName = "";
        String hostIP = "";
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            hostName = inetAddress.getHostName();
            hostIP = inetAddress.getHostAddress();
        }
        catch (UnknownHostException e) {
            BaseLogger.log("2", null, null, "Exception while getting  inetAddress **[" + e.getMessage() + "]**");
            e.printStackTrace();
        }
        String assignLink = "if( window.opener != undefined || window.opener != null ){window.opener.location.assign(\"/ibase/jsp/login.html\" );window.close();}else{window.parent.location.assign(\"/ibase/jsp/login.html\" );}";
        String[] msgArr = messageStr.split("~SEP~");
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("<html>");
        strBuffer.append("<body>");
        strBuffer.append("<h1>Session timeout.</h1>");
        if (hostIP != null && hostIP.trim().length() > 0) {
            strBuffer.append("<h2>Server IP: " + hostIP + "</h2>");
        }
        strBuffer.append("Message : " + msgArr[0]);
        strBuffer.append("<br/>");
        strBuffer.append("Description : " + msgArr[1]);
        strBuffer.append("<br/>");
        strBuffer.append("<button onclick='" + assignLink + "'>Click here to Login</button>");
        strBuffer.append("</body>");
        strBuffer.append("</html>");
        return strBuffer.toString();
    }

    private void insertGeoPosition(String deviceUuId, UserInfoBean userInfo) {
        try {
            deviceUuId = deviceUuId.length() > 0 ? deviceUuId : userInfo.getRemoteHost();
            AppConnectParm appConnect = new AppConnectParm();
            InitialContext ctx = new InitialContext(appConnect.getProperty());
            CommonDBAccessEJB commonDbAccess = new CommonDBAccessEJB();
            commonDbAccess.insertGeoPosition(userInfo.getLoginCode(), deviceUuId, "", userInfo.getCurrentGeoPOS(), "2", userInfo.getDataMode(), userInfo.getCurrentGeoPOSName(), userInfo.getGeoPosAccuracy());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

