/*
 * Decompiled with CFR 0.152.
 */
package ibase.bi.common.system.config;

import ibase.bi.utility.BIException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import java.io.File;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class DBInfo {
    public static String UNION;
    public static String INTERSECTION;
    public static String UNION_ALL;
    public static String MINUS;
    public static String OUTER_JOIN;
    public static DBInfo dbInfo;
    private static Document document;
    private static HashMap functionExpressionMap;

    private DBInfo(String dbName) throws Exception {
        String minusSupported;
        NodeList minusList;
        String unionAllSupported;
        NodeList unionAllList;
        String outJoinSupported;
        NodeList joinList;
        String intsnSupported;
        NodeList intsnList;
        String unionSupported;
        functionExpressionMap = new HashMap();
        UNION = null;
        INTERSECTION = null;
        UNION_ALL = null;
        MINUS = null;
        OUTER_JOIN = null;
        String path = String.valueOf(CommonConstants.BI_RESOURCE_PATH) + File.separator + "common" + File.separator + "xml" + File.separator + dbName + ".xml";
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        document = db.parse(path);
        NodeList unionList = document.getElementsByTagName("UNION");
        if (unionList != null && unionList.getLength() == 1 && (unionSupported = unionList.item(0).getAttributes().getNamedItem("SUPPORTED").getNodeValue()).equalsIgnoreCase("YES")) {
            UNION = unionList.item(0).getFirstChild().getNodeValue();
        }
        if ((intsnList = document.getElementsByTagName("INTERSECTION")) != null && intsnList.getLength() == 1 && (intsnSupported = intsnList.item(0).getAttributes().getNamedItem("SUPPORTED").getNodeValue()).equalsIgnoreCase("YES")) {
            INTERSECTION = intsnList.item(0).getFirstChild().getNodeValue();
        }
        if ((joinList = document.getElementsByTagName("JOIN_PROPERTIES")) != null && joinList.getLength() == 1 && (outJoinSupported = joinList.item(0).getAttributes().getNamedItem("SUPPORTED").getNodeValue()).equalsIgnoreCase("YES")) {
            OUTER_JOIN = joinList.item(0).getChildNodes().item(0).getFirstChild().getNodeValue();
        }
        if ((unionAllList = document.getElementsByTagName("UNION ALL")) != null && unionAllList.getLength() == 1 && (unionAllSupported = unionAllList.item(0).getAttributes().getNamedItem("SUPPORTED").getNodeValue()).equalsIgnoreCase("YES")) {
            UNION_ALL = unionAllList.item(0).getFirstChild().getNodeValue();
        }
        if ((minusList = document.getElementsByTagName("MINUS")) != null && minusList.getLength() == 1 && (minusSupported = minusList.item(0).getAttributes().getNamedItem("SUPPORTED").getNodeValue()).equalsIgnoreCase("YES")) {
            MINUS = minusList.item(0).getFirstChild().getNodeValue();
        }
        this.populateFunctionExpressionMap();
    }

    public static DBInfo newInstance(String dbName) throws Exception {
        try {
            if (dbInfo == null) {
                dbInfo = new DBInfo(dbName);
            }
            return dbInfo;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private void populateFunctionExpressionMap() throws Exception {
        NodeList dbList = document.getElementsByTagName("FUNCTION");
        int i = 0;
        while (i < dbList.getLength()) {
            String name = dbList.item(i).getAttributes().getNamedItem("NAME").getNodeValue();
            String physicalName = dbList.item(i).getAttributes().getNamedItem("PHYSICALNAME").getNodeValue();
            String type = dbList.item(i).getAttributes().getNamedItem("EXPRESSIONTYPE").getNodeValue();
            String isWinFunc = dbList.item(i).getAttributes().getNamedItem("ISWINFUNC").getNodeValue();
            functionExpressionMap.put(name, String.valueOf(isWinFunc) + "." + type + "." + physicalName);
            ++i;
        }
    }

    public static String getFunctionType(String funName) throws Exception {
        String retvalue = null;
        try {
            BaseLogger.log("3", null, null, "funName :" + funName);
            BaseLogger.log("3", null, null, "functionExpressionMap :" + functionExpressionMap);
            if (functionExpressionMap.get(funName) != null) {
                retvalue = ((String)functionExpressionMap.get(funName)).trim();
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
        return retvalue;
    }

    public static String getDataProfileName(String xmlFile) {
        String driverFileName = "Driver";
        if (!driverFileName.equals(xmlFile)) {
            File driverFile = new File(String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "setting" + File.separator + xmlFile + ".xml");
            if (driverFile.exists()) {
                driverFileName = xmlFile;
            } else if (!"DriverBI".equals(xmlFile)) {
                driverFileName = DBInfo.getDataProfileName("DriverBI");
            }
        }
        return driverFileName;
    }
}

