package com.testing;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.oreilly.servlet.multipart.FilePart;
import com.oreilly.servlet.multipart.MultipartParser;
import com.oreilly.servlet.multipart.ParamPart;
import com.oreilly.servlet.multipart.Part;

import ibase.bean.EventLogInfoBean;
import ibase.ejb.CommonDBAccessEJB;
import ibase.ejb.CommonDBAccessRemote;
import ibase.system.config.AppConnectParm;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.CommonConstants.WebSocketMessageType;
import ibase.utility.E12GenericUtility;
import ibase.utility.RAHandler;
import ibase.utility.RAHandlerTO;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.E12TransEditorCoreModel;
import ibase.webitm.bean.ITMTransactionCoreModel;
import ibase.webitm.bean.ITMTransactionHeaderModel;
import ibase.webitm.bean.wiz.RIAWizardBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.InfinispanLocal;
import ibase.webitm.ejb.LocalizationEJB;
import ibase.webitm.ejb.MasterApplyEJB;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.MasterStatefulRemote;
import ibase.webitm.ejb.PopUpEJB;
import ibase.webitm.notification.ejb.PublishPushNotificationEJB;
import ibase.webitm.notification.ejb.PublishPushNotificationRemote;
import ibase.webitm.utility.DWFactory;
import ibase.webitm.utility.DWObject;
import ibase.webitm.utility.ITMException;
import ibase.wrkflw.E12FollowUpActionEJB;

/**
 * @author base71
 *
 */
//Create new servlet by Sandeep on 12-APR-16 [[S15LSUN004] for new Interface of wizard and transaction editor] Start

public class E12EditorHandlerServlet extends HttpServlet 
{
	//[For File Attachment on Finish]
	private static String dirName = null;				//DIRECTORY NAME where file to be upload temporary
	//[Download large content file size] Start
	private static int MAX_UPLOAD_SIZE = 700*1024*1024;	//Maximum of 200MB allowed for upload
	//[Download large content file size] End
	// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [START]
	//private UserEventLogEJBLocal userEventLogEJB = null;
	private ibase.ejb.UserEventLogEJB userEventLogEJB = null;
	// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [END]
	protected InitialContext ctx = null;
	//Added by Suraj on 18-11-2016 [To set plan date for Editor in GWT Calendat]Start
	String plan_Date = "";
	String Cal_Comp = "";
	//Added by Suraj on 18-11-2016 [To set plan date for Editor in GWT Calendat]End
	//change by shrutika on 28-01-19 for multiple activities are not update due to global userinfo.
	//private UserInfoBean userInfo = null;
	//Changed by Gulzar on 29/12/16 : START
	ServletContext servletContext = null;
	ServletConfig servletConfig = null;

	//Added By Pankaj T on 12/09/17 for creating infinispan object on class level - Start
	static InfinispanLocal infinispanLocalObj = null;
	static Hashtable jndiProperties = null;
	static InitialContext infiCtx = null;
	
	static
	{
		try 
		{
			//Added Pankaj T on 18-10-17 [To use infinispan cache depends on CACHE_OPT define in ibase.xml 0 = NO Cache, 1 = Internal Cache, 2 = External Cache]
			if( CommonConstants.CACHE_OPT != 0 )
			{
				jndiProperties = new Hashtable();
				jndiProperties.put(Context.URL_PKG_PREFIXES,"org.jboss.ejb.client.naming");	   
				infiCtx=new InitialContext(jndiProperties);
				infinispanLocalObj = ((InfinispanLocal)infiCtx.lookup("ibase/InfinispanEJB/local"));
				BaseLogger.log("1", null,null,"E12EditorHandlerServlet infinispanLocalObj created.....");
			}
		}
		catch (Exception e) 
		{
			BaseLogger.log("0", null,null,"Exception in E12EditorHandlerServlet static block:["+e.getMessage()+"]");
			e.printStackTrace();
		}
	}
	//Added By Pankaj T on 12/09/17 for creating infinispan object on class level - End
		
	public void init(ServletConfig servletConfig) throws ServletException
	{   
		this.servletConfig = servletConfig;
		this.servletContext = servletConfig.getServletContext();
	}
	//Changed by Gulzar on 29/12/16 : END 
	
	protected void doGet(HttpServletRequest request, HttpServletResponse response)throws IOException, ServletException
    {
		doPost( request, response );
    }

	public void doPost(HttpServletRequest request, HttpServletResponse response)throws IOException, ServletException
	{

		//Added by shrutika on 25-12-18 [Start] for update status as Exception.
		Date tempstartTime = null;
		String tempObjName = "",tempactionMode = "",temppkValues = "",tempformNo = "",tempfieldName = "", tempevent = "",tempargFieldValues = "", temppageContext = "", editorID = "", action ="";
		String focusColumn = "";
		//Added by shrutika on 25-12-18 [End] for update status as Exception.
		//change by shrutika on 28-01-19 for multiple activities are not update due to global userinfo.
		UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
		//Added by Jay.K to get Enterprise of User[Start]
		String enterprise = userInfo.getEnterprise();
		//Added by Jay.K to get Enterprise of User[End]

		try
		{
			HttpSession sess = null;
			sess = request.getSession();
			BaseLogger.log("3", userInfo,null,"XXXXXXXXE12EditorHandlerServletXXXXXXXXXXXXXX");
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
			// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [START]
			//userEventLogEJB = (UserEventLogEJBLocal) this.ctx.lookup("ibase/UserEventLogEJB/local");
			userEventLogEJB = new ibase.ejb.UserEventLogEJB();
			// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [END]
			boolean isAddnlAct = false;
			String formData = "";

			action = request.getParameter("ACTION");
			editorID = request.getParameter("EDITOR_ID");

			BaseLogger.log("3", userInfo,null,"ACTION["+action+"] EDITOR_ID["+editorID+"]");
			if( "ABORT".equalsIgnoreCase( action ) )
			{
				//change by shrutika on 28-01-19 for multiple activities are not update due to global userinfo.
				//abortServeComp( request );
				abortServeComp( request, userInfo );
				return;
			}

			//change by shrutika on 28-01-19 for multiple activities are not update due to global userinfo.
			//userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
			//Added by sanket J on 30/05/17 [for checking Session expired or err msg ]-start 
			if(userInfo != null)
			{
				String transDB = userInfo.getTransDB();

				String objName = request.getParameter("OBJ_NAME");
				String formNo = request.getParameter("FORM_NO");
				String formType = request.getParameter("FORM_TYPE");//Type of form to implement MultipleForms
				String forceSave = request.getParameter("FORCESAVE");//To override Warnings from Business Components
				String fieldName = request.getParameter("FIELD_NAME");

				BaseLogger.log("3", userInfo,null,"OBJ_NAME["+objName+"] FORM_NO["+formNo+"] FORMTYPE["+formType+"] FORCESAVE["+forceSave+"] FIELDNAME["+fieldName+"]");

				//To Retrieve OBJ_ITEMCHANGE Info
				if( "OBJ_ITEMCHANGE_DET".equalsIgnoreCase( action ) )
				{
					StringBuilder objItemChangeBuff = new StringBuilder("<ITEMCHANGE_FIELDS>") ;
					//DBAccessRemote dbAccess = ( DBAccessRemote )ctx.lookup( "ibase/DBAccessEJB/remote" );
					DBAccessEJB dbAccess = new DBAccessEJB();
					ArrayList dbValues = null;
					//if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
					{
						dbValues = dbAccess.getObjFormsDetailList(objName, userInfo);
						for(int i = 0 ; i < dbValues.size() ; i++)
						{
							ArrayList currForm = (ArrayList) dbValues.get(i);
							String objContext = (String) currForm.get(14);
							ArrayList objICElmList = dbAccess.getItemChangeElementList( objName, objContext, userInfo );
							//change by shrutika on 28-01-19 for multiple activities are not update due to global userinfo.
							//objItemChangeBuff.append("<ITEMCHANGE_FIELD objContext = '" + objContext + "' >").append("<![CDATA[" + getCommaSeperatedValue( objICElmList ) + "]]>").append("</ITEMCHANGE_FIELD>");
							objItemChangeBuff.append("<ITEMCHANGE_FIELD objContext = '" + objContext + "' >").append("<![CDATA[" + getCommaSeperatedValue( objICElmList, userInfo ) + "]]>").append("</ITEMCHANGE_FIELD>");
						}
					}
					/*else
					{
						dbValues = dbAccess.getObjFormsDetailList(objName);
						for(int i = 0 ; i < dbValues.size() ; i++)
						{
							ArrayList currForm = (ArrayList) dbValues.get(i);
							String objContext = (String) currForm.get(14);
							ArrayList objICElmList = dbAccess.getItemChangeElementList( objName, objContext, userInfo );
							objItemChangeBuff.append("<ITEMCHANGE_FIELD objContext = '" + objContext + "' >").append("<![CDATA[" + getCommaSeperatedValue( objICElmList ) + "]]>").append("</ITEMCHANGE_FIELD>");
						}

					}*/

					objItemChangeBuff.append("</ITEMCHANGE_FIELDS>");
					BaseLogger.log("3", userInfo,null,"ITEMCHANGE_FIELDS[" + objItemChangeBuff.toString() + "]");
					response.setContentType( "text/xml; charset="+CommonConstants.ENCODING );
					response.setHeader("Cache-Control", "no-cache");
					response.getWriter().write(objItemChangeBuff.toString());
					isAddnlAct = true;
					dbAccess = null;
				}
				else if( "OBJ_FORMS_DET".equalsIgnoreCase( action ) )
				{
					StringBuilder objnTitle = new StringBuilder() ;
					//DBAccessRemote dbAccess = ( DBAccessRemote )ctx.lookup( "ibase/DBAccessEJB/remote" );
					DBAccessEJB dbAccess = new DBAccessEJB();
					ArrayList dbValues = null;
					//if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
					{
						dbValues = dbAccess.getObjFormsDetailList(objName, userInfo);
					}
					/*else
					{
						dbValues = dbAccess.getObjFormsDetailList(objName);
					}*/

					for(int i = 0 ; i < dbValues.size() ; i++)
					{
						ArrayList currForm = (ArrayList) dbValues.get(i);
						String title = (String)currForm.get(0);
						String objContext = (String) currForm.get(14);
						String scrFlag = (String) currForm.get(15);
						String dbFormType = (String) ( ( currForm.get(16) == null ) ? "" : currForm.get(16) );
						String dispMetaData = (String) ( ( currForm.get(17) == null ) ? "" : currForm.get(17) );
						String parentKeyCol = (String) ( ( currForm.get(18) == null ) ? "" : currForm.get(18) );

						BaseLogger.log("3", userInfo,null,"title [" + title + "] objContext14 [" + objContext + "] ");
						BaseLogger.log("3", userInfo,null,"scrFlag [" + scrFlag + "] dbFormType [" + dbFormType + "] ");
						BaseLogger.log("3", userInfo,null,"dispMetaData[" + dispMetaData + "] parentKeyCol[" + parentKeyCol + "] ");
                        //Changed By Ravindra C on 06-2-18 for [separator chnaged from '#' to '#SEP#']
						objnTitle.append( title + "#SEP#" + scrFlag + "#SEP#" + dbFormType+ "#SEP#" + dispMetaData + "#SEP#" + parentKeyCol + "~" );
					}
					String isAttachment = "";
					if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
					{
						isAttachment = dbAccess.getIsAttachment(objName, userInfo);
					}
					
					isAttachment = ( "".equalsIgnoreCase(isAttachment) ) ? "N" : isAttachment;
					objnTitle.append( isAttachment + "~" );
					BaseLogger.log("3", userInfo,null,"objnTitle[" + objnTitle.toString() + "]");
					response.setContentType( "text/xml; charset="+CommonConstants.ENCODING );
					response.setHeader("Cache-Control", "no-cache");
					response.getWriter().write(objnTitle.toString());
					isAddnlAct = true;
					dbAccess = null;
				}
				else if ("OBJ_FORMS_DET_N_BUTTON_INFO".equalsIgnoreCase(action))
				{
					StringBuilder objnTitle = new StringBuilder();
					//DBAccessRemote dbAccess = ( DBAccessRemote )ctx.lookup( "ibase/DBAccessEJB/remote" );
					DBAccessEJB dbAccess = new DBAccessEJB();
					ArrayList dbValues= null;
					//if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
					{
						dbValues = dbAccess.getObjFormsDetailList(objName,userInfo);
					}
					/*else
					{
						dbValues = dbAccess.getObjFormsDetailList(objName);
					}*/

					for(int i = 0 ; i < dbValues.size() ; i++)
					{
						ArrayList currForm = (ArrayList)dbValues.get(i);
						String title = (String)currForm.get(0);
						String scanMetaData = (String) currForm.get(6);
						String objContext = (String) currForm.get(14);
						String scrFlag = (String) currForm.get(15);
						String dbFormType = (String) ( ( currForm.get(16) == null ) ? "" : currForm.get(16) );
						String dispMetaData = (String) ( ( currForm.get(17) == null ) ? "" : currForm.get(17) );
						String parentKeyCol = (String) ( ( currForm.get(18) == null ) ? "" : currForm.get(18) );

						String assistedMode = (String) ( ( currForm.get(19) == null ) ? "" : currForm.get(19) );
						String storageKeyMetadata = ( String ) currForm.get( 20 );
						String selectionMode = ( String ) currForm.get( 21 );
						String defaultView = ( String ) currForm.get( 22 );
						String freezeColNum = ( String ) currForm.get( 24 );
						String defRowCnt = ( String ) currForm.get( 25 );
						String isMandatory = ( String ) currForm.get( 26 );
						BaseLogger.log("3", userInfo,null,"title["+title+"] \nobjContext["+objContext+"] \nscrFlag["+scrFlag+"] \ndbFormType["+dbFormType+"] " + "\ndispMetaData[" + dispMetaData + "]\nparentKeyCol[" + parentKeyCol + "]\nscanMetaData[" + scanMetaData + "]\nassistedMode[" + assistedMode + "]\nStorageKeyMetadata[" + storageKeyMetadata + "]\nselectionMode[" + selectionMode + "]\ndefaultView[" + defaultView + "]\nfreezColNum[" + freezeColNum + "]\ndefRowCnt[ "+defRowCnt+"]\nisMandatory["+isMandatory+"]" );
						//Changed By Ravindra C on 06-2-18 for [separator chnaged from '#' to '#SEP#']
						objnTitle.append( title + "#SEP#" + scrFlag + "#SEP#" + dbFormType+ "#SEP#" + dispMetaData + "#SEP#" + parentKeyCol + "#SEP#" + scanMetaData + "#SEP#" + assistedMode + "#SEP#" + storageKeyMetadata + "#SEP#" + selectionMode + "#SEP#" + defaultView + "#SEP#" + freezeColNum + "#SEP#" + defRowCnt + "#SEP#" + isMandatory + "~" );
						//[to reset the dump file name]
						if(request.getSession().getAttribute("DUMP_FILE_PATH") != null)
						{
							request.getSession().setAttribute("DUMP_FILE_PATH", null) ;
						}
					}
					BaseLogger.log("3", userInfo,null, "\n ACTION = ["+ action + "]" );

					String actionsStr= "";
					//if( userInfo != null )
					//	{
					transDB =userInfo.getTransDB();
					if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
					{
						//Added By Ajinkya Gopalkar on 21-SEP-17 [for code optimization and reduce server call] Start
						String cacheActionStr = objName + "~~"+ userInfo.getProfileId() + "~~" + userInfo.getUserLevel();
						//Added Pankaj T on 18-10-17 [To use infinispan cache depends on CACHE_OPT define in ibase.xml 0 = NO Cache, 1 = Internal Cache, 2 = External Cache]
						//Changed by Prasad on 23/11/2020 [check infinispanLocalObj not null]
						if( CommonConstants.CACHE_OPT != 0 && infinispanLocalObj != null )
						{
							if( infinispanLocalObj.contains(cacheActionStr))
							{
								actionsStr = infinispanLocalObj.getFormData(cacheActionStr);
							}
							else
							{
								actionsStr = dbAccess.getAllActionsString(objName, userInfo.getProfileId(), "0", userInfo);
								infinispanLocalObj.putFormData(cacheActionStr, actionsStr);
							}
						}
						else
						{
							actionsStr = dbAccess.getAllActionsString(objName, userInfo.getProfileId(), userInfo.getUserLevel(),userInfo);
						}
					}
					else
					{
						String cacheActionStr = objName + "~~"+ userInfo.getProfileId() + "~~" + userInfo.getUserLevel();
						//Added Pankaj T on 18-10-17 [To use infinispan cache depends on CACHE_OPT define in ibase.xml 0 = NO Cache, 1 = Internal Cache, 2 = External Cache]
						//Changed by Prasad on 23/11/2020 [check infinispanLocalObj not null]
						if( CommonConstants.CACHE_OPT != 0 && infinispanLocalObj != null )
						{
							if( infinispanLocalObj.contains(cacheActionStr))
							{
								actionsStr = infinispanLocalObj.getFormData(cacheActionStr);
							}
							else
							{
								actionsStr = dbAccess.getAllActionsString(objName, userInfo.getProfileId(), userInfo.getUserLevel(), userInfo.getTransDB());
								infinispanLocalObj.putFormData(cacheActionStr, actionsStr);
							}
						}
						else
						{
							actionsStr = dbAccess.getAllActionsString(objName, userInfo.getProfileId(), userInfo.getUserLevel(), userInfo.getTransDB());
						}
						//Added By Ajinkya Gopalkar on 21-SEP-17 [for code optimization and reduce server call] End
					}
					//End
					//	}
					/*else
					{
						actionsStr = "ERR_MSG :You have not logged on or your session has expired. \nPlease Re-connect to work on E12";
					}*/

					String isAttachment = null,startForm=null,repeateAdd=null,saveFlag=null, msgOnSave="";
					transDB =userInfo.getTransDB();
					if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
					{
						isAttachment = dbAccess.getIsAttachment(objName,userInfo);
						startForm    = dbAccess.getStartForm(objName,userInfo);
						repeateAdd   = getValueFromDBAccess(objName, "REPEATE_ADD",userInfo);
						saveFlag     = getValueFromDBAccess(objName, "SAVE_FLAG",userInfo);
						msgOnSave 	 = getValueFromDBAccess(objName, "MSG_ONSAVE",userInfo);
					}

					//[For Restart Transaction from specified Form] Start
					String columnName = "RESTART_FORM";
					String tableName = "TRANSETUP";
					String condition = " WHERE TRAN_WINDOW ='w_" + objName.trim() + "' ";
					//change by shrutika on 28-01-19 for multiple activities are not update due to global userinfo.
					//String reStartForm = getCommonDBAccess().getDBColumnValue( tableName, columnName, condition, userInfo.getTransDB() );
					String reStartForm = getCommonDBAccess(userInfo).getDBColumnValue( tableName, columnName, condition, userInfo.getTransDB() );
					//for configuring max transaction date in offline mode - Start
					columnName = "NO_OFFLINE_ALLWD";
					tableName = "USER_RIGHTS";
					//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
					//condition = " WHERE OBJ_NAME = '" + objName.trim() + "' AND PROFILE_ID = '"+userInfo.getProfileId()+"'";
					condition = " WHERE OBJ_NAME = '" + objName.trim() + "' AND PROFILE_ID IN "+ E12GenericUtility.getFormattedProfileId( userInfo.getProfileId() );
					String noOfflineAllowd;
					if("0".equalsIgnoreCase(userInfo.getUserLevel()))
					{
						noOfflineAllowd = "0";             //For User Level = 0 no offline transaction allowed.
					}
					else
					{
						//change by shrutika on 28-01-19 for multiple activities are not update due to global userinfo.
						//noOfflineAllowd = checkNull(getCommonDBAccess().getDBColumnValue( tableName, columnName, condition, userInfo.getTransDB() )); //No. of offline transaction allowed
						noOfflineAllowd = checkNull(getCommonDBAccess( userInfo ).getDBColumnValue( tableName, columnName, condition, userInfo.getTransDB() )); //No. of offline transaction allowed
					}
					//In case of null noOfflineAllowd is set to -1
					if(	"".equalsIgnoreCase( noOfflineAllowd ) )
					{
						noOfflineAllowd = "-1";
					}
					//for configuring max transaction date in offline mode - End
					String responseStr = "<Root><ACTIONS_DATA>"+actionsStr+"</ACTIONS_DATA>" +
							"<FORMS_DET><![CDATA["+objnTitle.toString()+"]]></FORMS_DET>" +
							"<ISATTACHMENT><![CDATA["+isAttachment+"]]></ISATTACHMENT>"+
							"<START_FORM><![CDATA["+startForm+"]]></START_FORM>"+
							"<REPEATE_ADD><![CDATA["+repeateAdd+"]]></REPEATE_ADD>" +
							"<SAVE_FLAG><![CDATA["+saveFlag+"]]></SAVE_FLAG>"+
							"<RESTART_FORM><![CDATA["+ checkNull( reStartForm ) +"]]></RESTART_FORM>" +
							"<NO_OFFLINE_ALLWD><![CDATA["+ noOfflineAllowd +"]]></NO_OFFLINE_ALLWD>" +
							"<MSG_ONSAVE><![CDATA["+ checkNull( msgOnSave ) +"]]></MSG_ONSAVE></Root>";
					//[For Restart Transaction from specified Form] End

					BaseLogger.log("3", userInfo,null, "\n\nE12EditorHandlerServlet : OBJ_FORMS_DET_N_BUTTON_INFO : ResponseStr : -------- \n\n" + responseStr + "\n\n------------------ END ----------" );
					response.setContentType( "text/xml; charset="+CommonConstants.ENCODING );
					response.setHeader("Cache-Control", "no-cache");
					response.getWriter().write( responseStr );
					isAddnlAct = true;
					dbAccess = null;
				}
				else if("OBJ_METADATA".equalsIgnoreCase(action))
				{
					String profileId = request.getParameter("PROFILEID");
					String tabType = request.getParameter("TAB_TYPE");
					//Changed by Prasad on 05/05/16 [As per Danish Sir, Editor option added for Property Editor] STRAT
					//String xmlString = getXmlDataString(objName, action, formNo, fieldName, profileId, tabType, userInfo);
					String editor = checkNull(request.getParameter("EDITOR"));
					String xmlString = getXmlDataString(objName, action, formNo, fieldName, profileId, tabType, userInfo, editor);
					//Changed by Prasad on 05/05/16 [As per Danish Sir, Editor option added for Property Editor] END

					// Do it on CommonConstants'flag basis 
					String targetDir = CommonConstants.APPLICATION_CONTEXT + File.separator + "temp";
					//change by shrutika on 28-01-19 for multiple activities are not update due to global userinfo.
					//xmlString = ( new E12GenericUtility() ).transformToString( getXSLFileName("ME12XML2TEXT.xsl"), xmlString, targetDir, "Output", ".html" );
					xmlString = ( new E12GenericUtility() ).transformToString( getXSLFileName("ME12XML2TEXT.xsl", userInfo), xmlString, targetDir, "Output", ".html" );

					if(xmlString.startsWith("<?xml version="))
					{
						xmlString = xmlString.substring( xmlString.indexOf("?>") + 2 );
					}
					response.setContentType( "text/xml; charset="+CommonConstants.ENCODING );
					response.setHeader("Cache-Control", "no-cache");
					response.getWriter().write(xmlString);
					isAddnlAct = true;
				}
				else if("OBJ_POPHELP".equalsIgnoreCase(action))
				{
					String paramXmlStr = request.getParameter("PARAMXML");
					BaseLogger.log("3", userInfo,null,"OBJ_POPHELP [" + paramXmlStr + "]");
					//Changed By Ajinkya Darvesh on 11/07/2017 [To get header data into detail for popup column] [START]
					//String sqlXmlStr = getpopUpKeyStr(objName, fieldName, paramXmlStr,userInfo);
					StringBuffer params = new StringBuffer();
					String editorId = request.getParameter("EDITOR_ID");
					formNo = request.getParameter("FORM_NO");
					//Added by shrutika for 12-03-18 [Start] for add pophelp event in event activity log.
					String pkValues = request.getParameter("PKVLAUE");
					String editflag = request.getParameter("EDIT_FLAG");
					//Added by shrutika for 12-03-18 [end] for add pophelp event in event activity log.
					//change by shrutika on 28-01-19 for multiple activities are not update due to global userinfo.
					//String allDetailXmlData = getDetailDomData(request, editorId, userInfo.getLoginCode());
					String allDetailXmlData = getDetailDomData(request, editorId, userInfo.getLoginCode(), userInfo);
					Enumeration enum1 = request.getParameterNames();
					while( enum1.hasMoreElements() )
					{
						String paramName = ( String ) enum1.nextElement();
						String paramValue = request.getParameter( paramName );
						params.append(paramName).append("=").append(paramValue).append("~SEP~");
					}
					//Added by shrutika for 12-03-18 [Start] for add pophelp event in event activity log.
					ibase.ejb.UserEventLogEJB userEventLogEJB = new ibase.ejb.UserEventLogEJB();

					if( "".equalsIgnoreCase(editorID))
					{
						 editorID = "" + new Date().getTime();
					}
					Date startTime = new Date();
					String actionMode = "VIEW";
					if(editflag != null)
					{
						//Added By Samadhan on 25/04/2016[S15LBAS001] for Handling null pointer exception while simple Transation editor end
						if( editflag.equals("A") )
						{
							actionMode = "ADD";
						}
						else if( editflag.equals("E") )
						{
							actionMode = "EDIT";
						}
					}
					//Added by shrutika on 25-12-18 [Start] for update status as Exception.
					tempstartTime = startTime;
					tempObjName = objName;
					tempevent = "pophelp";
					temppkValues = pkValues;
					tempformNo = formNo;
					tempfieldName = fieldName;
					tempactionMode = actionMode;
					editorID = editorID;
					//Added by shrutika on 25-12-18 [End] for update status as Exception.

					//Change by shrutika on 05-01-19 for add exception.
					userEventLogEJB.setEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(),editorID , actionMode , "pophelp", startTime, null,"pkValues:[" + pkValues + "], objContext:[" + formNo + "], filedName:["+fieldName+"]", pkValues, "Pending","SA","");
					//Added by shrutika for 12-03-18 [end] for add pophelp event in event activity log.
					String sqlXmlStr = getpopUpKeyStr(objName, fieldName, paramXmlStr, userInfo, allDetailXmlData, formNo, params.toString());
					//Added by shrutika for 12-03-18 for add pophelp event in event activity log.
					//Change by shrutika on 05-01-19 for add exception.
					userEventLogEJB.updateEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(),editorID , actionMode , "pophelp", startTime, new Date(),"pkValues:[" + pkValues + "], objContext:[" + formNo + "], filedName:["+fieldName+"]", pkValues, "Success","SA","");
					//Changed By Ajinkya Darvesh on 11/07/2017 [To get header data into detail for popup column] [END]
					response.setContentType( "text/xml; charset="+CommonConstants.ENCODING );
					response.setHeader("Cache-Control", "no-cache");
					response.getWriter().write(sqlXmlStr);
					isAddnlAct = true;
				}
				else if("AUTO_SEARCH_POPHELP".equalsIgnoreCase(action))
				{
					BaseLogger.log("3", userInfo,null,"In side AUTO_SEARCH_POPHELP ");
					String pophelpData = getAutoSearchPophelp(request, userInfo);
					response.setContentType( "text/xml; charset="+CommonConstants.ENCODING );
					response.setHeader("Cache-Control", "no-cache");
					response.getWriter().write(pophelpData);
					isAddnlAct = true;
				}
				else if("OBJ_POPHELPINFO_ALL".equalsIgnoreCase(action))
				{
					String objType = request.getParameter("OBJ_TYPE");
					//added by shrutika on 10-12-18 [start] for add pophelp data in event log.
					String pkValues = request.getParameter("PKVLAUE");
					String editflag = request.getParameter("EDIT_FLAG");
					ibase.ejb.UserEventLogEJB userEventLogEJB = new ibase.ejb.UserEventLogEJB();
					String editorId = "" + new Date().getTime();
					Date startTime = new Date();
					String actionMode = "VIEW";
					if(editflag != null)
					{
						if( editflag.equals("A") )
						{
							actionMode = "ADD";
						}
						else if( editflag.equals("E") )
						{
							actionMode = "EDIT";
						}
					}
					//Change by shrutika on 05-01-19 for add exception.
					userEventLogEJB.setEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(),editorId , actionMode , "OBJ_POPHELPINFO_ALL", startTime, null,"pkValues:[" + pkValues + "], objContext:[" + formNo + "]", pkValues, "Pending","SA","");
					//Added by shrutika for 10-12-18 [end] for add pophelp event in event activity log.
					ArrayList<String> popHelpLst = null;

					//if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
					{
						popHelpLst = getPopHelpInfo(objName, objType, userInfo);
					}
					/*else
					{
						popHelpLst = getPopHelpInfo(objName, objType);					
					}*/

					//Added by shrutika on 25-12-18 [Start] for update status as Exception.
					tempstartTime = startTime;
					tempObjName = objName;
					tempactionMode = actionMode;
					temppkValues = pkValues;
					tempformNo = formNo;
					tempfieldName = fieldName;
					tempevent = "OBJ_POPHELPINFO_ALL";
					editorID = editorId;
					//Added by shrutika on 25-12-18 [End] for update status as Exception.
					StringBuffer popHelpLstStr = new StringBuffer();
					for (String popHelpName : popHelpLst) 
					{
						popHelpLstStr.append(popHelpName).append(",");
					}
					//Added by shrutika for 10-12-18 for add pophelp event in event activity log.
					//Change by shrutika on 05-01-19 for add exception.
					userEventLogEJB.updateEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(),editorId , actionMode , "OBJ_POPHELPINFO_ALL", startTime, new Date(),"pkValues:[" + pkValues + "], objContext:[" + formNo + "]", pkValues, "Success","SA","");
					response.setContentType( "text/xml; charset="+CommonConstants.ENCODING );
					response.setHeader("Cache-Control", "no-cache");
					response.getWriter().write(popHelpLstStr.toString());
					isAddnlAct = true;
				}
				else if( "BUTTON_INFO".equalsIgnoreCase( action ))
				{
					String responseStr= "";
					String pageContext = request.getParameter( "PAGE_CTX" );
					String metaDataFileName = request.getParameter( "LINK_FORM" );
					BaseLogger.log("3", userInfo,null, "OBJ_DETAILS : Request Parameters : --------\n\nOBJ_NAME : [" + objName + "]\nPAGE_CTX : [" + pageContext + "]\nLINK_FORM : [" + metaDataFileName + "]\n\n----------------- END ----------" );

					//	if( userInfo != null )
					//	{
					//DBAccessRemote dbAccess = ( DBAccessRemote )ctx.lookup( "ibase/DBAccessEJB/remote" );
					DBAccessEJB dbAccess = new DBAccessEJB();
					transDB=userInfo.getTransDB();
					if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
					{
						responseStr = dbAccess.getAllActionsString(objName, userInfo.getProfileId(), userInfo.getUserLevel(),userInfo);
					}
					else
					{
						responseStr = dbAccess.getAllActionsString(objName, userInfo.getProfileId(), userInfo.getUserLevel(), userInfo.getTransDB());
					}
					//	}
					/*else
					{
					responseStr = "ERR_MSG :You have not logged on or your session has expired. \nPlease Re-connect to work on E12";
					}*/
					BaseLogger.log("3", userInfo,null, "\n\nE12EditorHandlerServlet : OBJ_DETAILS : ResponseStr : -------- \n\n" + responseStr + "\n\n------------------ END ----------" );
					response.setContentType( "text/xml; charset="+CommonConstants.ENCODING );
					response.setHeader("Cache-Control", "no-cache");
					response.getWriter().write( responseStr );
					isAddnlAct = true;
					dbAccess = null;
				}
				/*else if( "BLANK_DOM_FOR_ADD".equalsIgnoreCase( action ) )
				{
					String lastDomID = request.getParameter("LAST_DOM_ID") ;
					lastDomID = ( lastDomID == null || "".equalsIgnoreCase(lastDomID) ) ? "1" : lastDomID;
					int lastDomId = Integer.parseInt(  lastDomID );
					BaseLogger.log("3", userInfo,editorId," LAST_DOM_ID ["+lastDomId+"]");
					ArrayList<String> dataArrayList = ( ArrayList<String> ) createDataArrayList( request, formNo,  objName);
					BaseLogger.log("3", userInfo,editorId, " 123 dataArrayList ::: " + dataArrayList );
					formData = riaWizardBean.callEventManager("blank_dom_for_add", formNo, ""+( lastDomId ), dataArrayList, action, formType, forceSave );
					BaseLogger.log("3", userInfo,editorId,"BLANK_DOM_FOR_ADD ::: formData["+formData+"]");
			        response.setContentType( "text/xml; charset="+CommonConstants.ENCODING );
					response.setHeader("Cache-Control", "no-cache");
					BaseLogger.log("3", userInfo,editorId,"formData["+formData+"]");
					response.getWriter().write(formData);
					isAddnlAct = true;
				}*/
				else if("GET_WEIGH_METADATA".equalsIgnoreCase(action))
				{
					String machineCode= request.getParameter("mc_code"); //TODO based on machine names connect & read the return values
					BaseLogger.log("3", userInfo,null,"Reading WEIGH_METADATA for " + machineCode + "...." );
					String weighingXmlPath =  //CommonConstants.APPLICATION_CONTEXT + "BMRFiles"+ File.separator + "XML" + File.separator;
							CommonConstants.RIALITE_PROFILE_PATH + File.separator + CommonConstants.PROFILE_MENU + File.separator + "WeighMetadata" + File.separator;

					weighingXmlPath = weighingXmlPath + "weigh_" + machineCode + ".xml";
					BaseLogger.log("3", userInfo,null,"Reading WEIGH_METADATA XML from : " + weighingXmlPath);

					StringBuilder readings = new StringBuilder();
					try 
					{
						BufferedReader reader = new BufferedReader(new FileReader(weighingXmlPath));
						String line;
						while((line = reader.readLine())!= null)
						{
							readings.append(line+"\n");
						}
						BaseLogger.log("3", userInfo,null,readings.toString());					
						response.getWriter().write(readings.toString());
					} 
					catch (Exception e)
					{
						BaseLogger.log("0", userInfo,null,"Exception in parsing file: "+e.getMessage());
						e.printStackTrace();
						//ITMDBAccessRemote itmDbAccess = (ITMDBAccessRemote)ctx.lookup("/ibase/ITMDBAccessEJB/remote");
						ITMDBAccessEJB itmDbAccess = new ITMDBAccessEJB();
						String errorStr = itmDbAccess.getErrorString("","INVWGMDATA", userInfo.getLoginCode(), userInfo );// INVALID_WEIGH_METADATA - Weigh Metadata not found
						itmDbAccess = null;
						response.getWriter().write(errorStr);
					}
				}
				else if(action.equals("XML_DATA_DETAIL")) //$NON-NLS-1$
				{
					String responseStr = "";
					Date startTime = new Date();
					String objContext = ( request.getParameter("OBJ_CTX")); //$NON-NLS-1$
					String editFlag = ( request.getParameter("EDIT_FLAG")); //$NON-NLS-1$
					String pkValues =  ( request.getParameter("PK_VALUES")); //$NON-NLS-1$
					String editorId =  ( request.getParameter("EDITOR_ID")); //$NON-NLS-1$
					//Changed by Prasad on 18/05/16 [As per Danish Sir, Editor option added for Property Editor] STRAT
					String editor = checkNull( request.getParameter("EDITOR") );
					if ( editor.length() == 0 )
					{
						editor = "MobEditor";
					}
					BaseLogger.log("3", userInfo,editorId,"EDITOR - ["+ editor +"]");
					//Changed by Prasad on 18/05/16 [As per Danish Sir, Editor option added for Property Editor] END
					String userId = userInfo.getLoginCode();
					editorId = editorId + userId; 
					//String terminal = request.getRemoteAddr();
					//Changed By Pankaj T. on 21-05-2021 for getting actual client ip in case of load balancer - start
					String chgIP = request.getHeader("X-Forwarded-For");
					if(chgIP == null)
					{  
						chgIP = request.getRemoteAddr();
					}
					//Changed By Pankaj T. on 21-05-2021 for getting actual client ip in case of load balancer - end
					String action1 = action;
					if("A".equalsIgnoreCase(editFlag))
					{
						action1 = "ADD";
					}
					else if("V".equalsIgnoreCase(editFlag))
					{
						action1 = "VIEW";
					}
					else
					{
						action1 = "EDIT";
					}
					if("EDIT".equalsIgnoreCase(action1) && (pkValues == null || pkValues.trim().length() == 0))
					{
						action1  = "ADD";
					}
					if( "E".equals( editFlag ) )  //$NON-NLS-1$
					{
						/*String tempEditorID = editorId;
					if( editorId != null &&  editorId.indexOf(userId) != -1)
					{
						tempEditorID = editorId.substring(0,editorId.indexOf(userId));
					}
					startTime = new Date();*/
					}
					/*String tempEditorID = editorId;
				if( editorId != null &&  editorId.indexOf(userId) != -1)
				{
					tempEditorID = editorId.substring(0,editorId.indexOf(userId));
				}*/
					String tempEditorID = getStatefulEditorId( editorId, userId );
					if( pkValues != null && pkValues.trim().length() > 0 && ( ! pkValues.equalsIgnoreCase("null") ) && ( "A".equalsIgnoreCase( editFlag ) )  && ( Integer.parseInt( objContext ) == 1 ) ) //$NON-NLS-1$ //$NON-NLS-2$
					{
						startTime = new Date();
						//Changed by Prasad on 18/05/16 [As per Danish Sir, Editor option added for Property Editor] START
						//responseStr = setActionForDuplicateTransaction(objName, objContext, pkValues , sess , editorId, userId);
						responseStr = setActionForDuplicateTransaction(objName, objContext, pkValues , sess , editorId, userId, editor);
					}
					else
					{
						startTime = new Date();
						String chgStr = request.getParameter("CHG_STR"); //$NON-NLS-1$
						String argFieldValues = request.getParameter("ARG_VALUES"); //$NON-NLS-1$
						String reqParamStr = request.getParameter("REQ_PARAM_STR"); //$NON-NLS-1$
						//Added by Suraj on 18-11-2016 [To set plan date for Editor in GWT Calendat]Start
						plan_Date =	( request.getParameter( "PLAN_DATE"  )!= null )?request.getParameter( "PLAN_DATE"  ):"";
						Cal_Comp =	( request.getParameter( "CALENDAR_COMP"  )!= null )?request.getParameter( "CALENDAR_COMP"  ):"";
						//Added by Suraj on 18-11-2016 [To set plan date for Editor in GWT Calendat]End
						//Changed by Prasad on 18/05/16 [As per Danish Sir, Editor option added for Property Editor] START
						//responseStr = getXMLDataForDetail( objName, objContext, editFlag, pkValues, chgStr, argFieldValues, sess, editorId, reqParamStr, userId );
						BaseLogger.log("3", userInfo,editorId,"** plan_Date ["+plan_Date+"] Cal_Comp ["+Cal_Comp+"]");
						responseStr = getXMLDataForDetail( objName, objContext, editFlag, pkValues, chgStr, argFieldValues, sess, editorId, reqParamStr, userId, editor );
						//Changed by Prasad on 18/05/16 [As per Danish Sir, Editor option added for Property Editor] END
						//					BaseLogger.log("3", userInfo,editorId,"response from getXMLDataForDetail responseStr["+responseStr+"]");
					}
					String event = "get_detail_data";
					if ( objContext != null && !"null".equalsIgnoreCase( objContext )  )
					{
						if ( pkValues !=null && !"null".equalsIgnoreCase( pkValues ) && pkValues.trim().length() > 0 && !"1".equals( objContext ) )
						{
							if ( "A".equalsIgnoreCase( editFlag ) )
							{
								event = "ADD";
							}
							action1 = "EDIT";
						}
						else if ( !"1".equals( objContext ) ) 
						{
							if("A".equalsIgnoreCase(editFlag))
							{
								event = "ADD";
							}
							action1 = "ADD";
						}
					}
					if( userEventLogEJB != null && userInfo != null )
					{
						//userEventLogEJB.setEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorID, action1 , event, new Date(), new Date(),"pkValues:[" + pkValues + "], objContext:[" + objContext + "], ", pkValues);
						//Change by shrutika on 05-01-19 for add exception.
						userEventLogEJB.updateEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorID, action1 , event, new Date(), new Date(),"pkValues:[" + pkValues + "], objContext:[" + objContext + "], ", pkValues,"Success","SA","");

					}
					else
					{
						BaseLogger.log("3", userInfo,editorId," ============ User info is null then never create event log in doPost() method of RequestHandlerServlet.java file, action is 'XML_DATA_DETAIL' ");
					}
					//Added By Pankaj T. on 17-02-2021 - added new attributes in detail tag valdatastat, taxcalcstat & id for  checking current record is valid or not at the time of adding new detail - start
					org.w3c.dom.Document currentDetailNode = null;
					if( responseStr != null && !(responseStr.startsWith("Invalid row found")) && !(responseStr.startsWith("Tax not calculated")) )
					{
						currentDetailNode = new E12GenericUtility().parseString(responseStr);
					}
					//Added By Pankaj T. on 17-02-2021 - added new attributes in detail tag valdatastat, taxcalcstat & id for  checking current record is valid or not at the time of adding new detail - end
					//Changed by Sandeep on 28-JUN-16 [[S15LSUN004] New interface for Wizard and Editor] Start
					/*if( currentDetailNode.getElementsByTagName("Detail1").item(0) != null )
				{
					responseStr = new E12GenericUtility().serializeDom( (Node) currentDetailNode.getElementsByTagName("Detail1").item(0) );
				}*/
					//Changed by Sandeep on 14-APR-16 [[S15LSUN004] New interface for Wizard and Editor] End
					//responseStr = "<?xml version='1.0'?><Root><Header><editFlag>null</editFlag></Header><Errors></Errors>" + responseStr + "</Root>";
					//Changed by Amey W. [ Implement copy transaction action in E12mobile ] on 23-03-2020 START
					
					//Change by shrutika on 19-05-2020 for extract template option.
					String returnType =  E12GenericUtility.checkNull( request.getParameter("RTEURN_TYPE"));
					//if( responseStr.indexOf("<?xml version") == -1 )
					//Added By Pankaj T. on 17-02-2021 - added new attributes in detail tag valdatastat, taxcalcstat & id for  checking current record is valid or not at the time of adding new detail
					if( responseStr.indexOf("<?xml version") == -1 && !"json".equalsIgnoreCase(returnType) && !(responseStr.startsWith("Invalid row found")) && !(responseStr.startsWith("Tax not calculated")) )
					{
						responseStr = "<?xml version='1.0'?><Root><Header><editFlag>null</editFlag></Header><Errors></Errors>" + responseStr + "</Root>";
					}
					if( "json".equalsIgnoreCase(returnType) && currentDetailNode != null && currentDetailNode.getElementsByTagName("Errors").item(0) == null )
					//if( "json".equalsIgnoreCase(returnType) )
					{
			            JSONObject jsonObject  = XML.toJSONObject(responseStr);
			            responseStr = jsonObject.toString();
					}
					//Change by shrutika on 19-05-2020 [End] for extract template option.
					BaseLogger.log("3", userInfo,editorId,"r111 responseStr ["+responseStr+"]");
					response.setContentType( "text/plain; charset="+CommonConstants.ENCODING );
					response.setHeader("Cache-Control", "no-cache");
					response.getWriter().write( responseStr );
					isAddnlAct = true;
				}
				else if( action.equals("BLANK_DOM_FOR_ADD") )
				{
					String responseStr = "";
					Date startTime = new Date();
					String objContext = ( request.getParameter("OBJ_CTX")); //$NON-NLS-1$
					String editFlag = ( request.getParameter("EDIT_FLAG")); //$NON-NLS-1$
					String pkValues =  ( request.getParameter("PK_VALUES")); //$NON-NLS-1$
					String editorId =  ( request.getParameter("EDITOR_ID")); //$NON-NLS-1$
					//Changed by Prasad on 18/05/16 [As per Danish Sir, Editor option added for Property Editor] STRAT
					String editor = checkNull( request.getParameter("EDITOR") );
					String domId = checkNull( request.getParameter("DOM_ID") );
					if ( editor.length() == 0 )
					{
						editor = "MobEditor";
					}
					BaseLogger.log("3", userInfo,editorId,"EDITOR - ["+ editor +"]");
					//Changed by Prasad on 18/05/16 [As per Danish Sir, Editor option added for Property Editor] END
					String userId = userInfo.getLoginCode();
					editorId = editorId + userId; 
					//String terminal = request.getRemoteAddr();
					//Changed By Pankaj T. on 21-05-2021 for getting actual client ip in case of load balancer - start
					String chgIP = request.getHeader("X-Forwarded-For");
					if(chgIP == null)
					{  
						chgIP = request.getRemoteAddr();
					}
					//Changed By Pankaj T. on 21-05-2021 for getting actual client ip in case of load balancer - end
					String action1 = action;
					if("A".equalsIgnoreCase(editFlag))
					{
						action1 = "ADD";
					}
					else if("V".equalsIgnoreCase(editFlag))
					{
						action1 = "VIEW";
					}
					else
					{
						action1 = "EDIT";
					}
					if("EDIT".equalsIgnoreCase(action1) && (pkValues == null || pkValues.trim().length() == 0))
					{
						action1  = "ADD";
					}
					if( "E".equals( editFlag ) )  //$NON-NLS-1$
					{
						/*String tempEditorID = editorId;
					if( editorId != null &&  editorId.indexOf(userId) != -1)
					{
						tempEditorID = editorId.substring(0,editorId.indexOf(userId));
					}
					startTime = new Date();*/
					}
					/*String tempEditorID = editorId;
				if( editorId != null &&  editorId.indexOf(userId) != -1)
				{
					tempEditorID = editorId.substring(0,editorId.indexOf(userId));
				}*/
					String tempEditorID = getStatefulEditorId( editorId, userId );
					//Change by shrutika on 03-12-18 [Start] for updateEventLog.
					String event = "get_detail_data";

					//Added by shrutika on 25-12-18 [Start] for update status as Exception.
					tempstartTime = startTime;
					tempObjName = objName;
					tempevent = event;
					temppkValues = pkValues;
					tempformNo = objContext;
					tempfieldName = fieldName;
					tempactionMode = action1;
					editorID = tempEditorID;
					//Added by shrutika on 25-12-18 [End] for update status as Exception.
					if( userEventLogEJB != null && userInfo != null )
					{
						//Change by shrutika on 05-01-19 for add exception.
						userEventLogEJB.setEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorID, action1 , event,  startTime, null ,"pkValues:[" + pkValues + "], objContext:[" + objContext + "], ", pkValues,"Pending","SA","");
					}
					//Change by shrutika on 03-12-18 [End] for updateEventLog.
					if( pkValues != null && pkValues.trim().length() > 0 && ( ! pkValues.equalsIgnoreCase("null") ) && ( "A".equalsIgnoreCase( editFlag ) )  && ( Integer.parseInt( objContext ) == 1 ) ) //$NON-NLS-1$ //$NON-NLS-2$
					{
						startTime = new Date();
						//Changed by Prasad on 18/05/16 [As per Danish Sir, Editor option added for Property Editor] START
						//responseStr = setActionForDuplicateTransaction(objName, objContext, pkValues , sess , editorId, userId);
						responseStr = setActionForDuplicateTransaction(objName, objContext, pkValues , sess , editorId, userId, editor);
					}
					else
					{
						startTime = new Date();
						String chgStr = request.getParameter("CHG_STR"); //$NON-NLS-1$
						String argFieldValues = request.getParameter("ARG_VALUES"); //$NON-NLS-1$
						String reqParamStr = request.getParameter("REQ_PARAM_STR"); //$NON-NLS-1$
						//Changed by Prasad on 18/05/16 [As per Danish Sir, Editor option added for Property Editor] START
						//responseStr = getXMLDataForDetail( objName, objContext, editFlag, pkValues, chgStr, argFieldValues, sess, editorId, reqParamStr, userId, editor);
						responseStr = getXMLDataOnDelete( objName, objContext, editFlag, pkValues, chgStr, argFieldValues, sess, editorId, reqParamStr, userId, action, domId);
						//Changed by Prasad on 18/05/16 [As per Danish Sir, Editor option added for Property Editor] END
						//					BaseLogger.log("3", userInfo,editorId,"response from getXMLDataForDetail responseStr["+responseStr+"]");
					}
					//String event = "get_detail_data";
					if ( objContext != null && !"null".equalsIgnoreCase( objContext )  )
					{
						if ( pkValues !=null && !"null".equalsIgnoreCase( pkValues ) && pkValues.trim().length() > 0 && !"1".equals( objContext ) )
						{
							if ( "A".equalsIgnoreCase( editFlag ) )
							{
								event = "ADD";
							}
							action1 = "EDIT";
						}
						else if ( !"1".equals( objContext ) ) 
						{
							if("A".equalsIgnoreCase(editFlag))
							{
								event = "ADD";
							}
							action1 = "ADD";
						}
					}
					if( userEventLogEJB != null && userInfo != null )
					{
						//Change by shrutika on 03-12-18 for updateEventLog.
						//userEventLogEJB.setEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorID, action1 , event, new Date(), new Date(),"pkValues:[" + pkValues + "], objContext:[" + objContext + "], ", pkValues);
						//Change by shrutika on 05-01-19 for add exception.
						userEventLogEJB.updateEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorID, action1 , event, startTime, new Date(),"pkValues:[" + pkValues + "], objContext:[" + objContext + "], ", pkValues,"Success","SA","");
					}
					else
					{
						BaseLogger.log("3", userInfo,editorId," ============ User info is null then never create event log in doPost() method of RequestHandlerServlet.java file, action is 'XML_DATA_DETAIL' ");
					}

					org.w3c.dom.Document currentDetailNode = new E12GenericUtility().parseString(responseStr);
					//Changed by Sandeep on 14-APR-16 [[S15LSUN004] New interface for Wizard and Editor] Start
					if( currentDetailNode.getElementsByTagName("Detail1").item(0) != null )
					{
						responseStr = new E12GenericUtility().serializeDom( (Node) currentDetailNode.getElementsByTagName("Detail1").item(0) );
					}
					//Changed by Sandeep on 14-APR-16 [[S15LSUN004] New interface for Wizard and Editor] End
					responseStr = "<?xml version='1.0'?><Root><Header><editFlag>null</editFlag></Header><Errors></Errors>" + responseStr + "</Root>";
					BaseLogger.log("3", userInfo,editorId,"responseStr ["+responseStr+"]");

					response.setContentType( "text/plain; charset="+CommonConstants.ENCODING );
					response.setHeader("Cache-Control", "no-cache");
					response.getWriter().write( responseStr );
					isAddnlAct = true;
				}
				//Added by Sandeep on 10-May-16 [[S15LSUN004] for next action in Transaction Editor ] start
				else if(action.equals("NEXT"))
				{
					String responseStr = "";
					Date startTime = new Date();
					String objContext = ( request.getParameter("OBJ_CTX")); //$NON-NLS-1$
					String editFlag = ( request.getParameter("EDIT_FLAG")); //$NON-NLS-1$
					String pkValues =  ( request.getParameter("PK_VALUES")); //$NON-NLS-1$
					String editorId =  ( request.getParameter("EDITOR_ID")); //$NON-NLS-1$
					String FORM_NO = ( request.getParameter("FORM_NO")); 
					//Added by Prasad on 18/05/16 [As per Danish Sir, Editor option added for Property Editor] START
					String editor = checkNull( request.getParameter("EDITOR") );
					String domId = checkNull( request.getParameter("DOM_ID") );
					if ( editor.length() == 0 )
					{
						editor = "MobEditor";
					}
					BaseLogger.log("3", userInfo,editorId,"EDITOR - ["+ editor +"]");
					//Added by Prasad on 18/05/16 [As per Danish Sir, Editor option added for Property Editor] END
					String userId = userInfo.getLoginCode();
					editorId = editorId + userId; 
					//String terminal = request.getRemoteAddr();
					//Changed By Pankaj T. on 21-05-2021 for getting actual client ip in case of load balancer - start
					String chgIP = request.getHeader("X-Forwarded-For");
					if(chgIP == null)
					{  
						chgIP = request.getRemoteAddr();
					}
					//Changed By Pankaj T. on 21-05-2021 for getting actual client ip in case of load balancer - end
					String action1 = action;
					BaseLogger.log("3", userInfo,editorId,"Inside E12EditorHandlerServlet FORM_NO["+FORM_NO+"] objContext["+objContext+"] editFlag["+editFlag+"]");
					if("A".equalsIgnoreCase(editFlag))
					{
						action1 = "ADD";
					}
					else if("V".equalsIgnoreCase(editFlag))
					{
						action1 = "VIEW";
					}
					else
					{
						action1 = "EDIT";
					}
					if("EDIT".equalsIgnoreCase(action1) && (pkValues == null || pkValues.trim().length() == 0))
					{
						action1  = "ADD";
					}
					if( "E".equals( editFlag ) )  //$NON-NLS-1$
					{
						/*String tempEditorID = editorId;
					if( editorId != null &&  editorId.indexOf(userId) != -1)
					{
						tempEditorID = editorId.substring(0,editorId.indexOf(userId));
					}
					startTime = new Date();*/
					}
					/*String tempEditorID = editorId;
				if( editorId != null &&  editorId.indexOf(userId) != -1)
				{
					tempEditorID = editorId.substring(0,editorId.indexOf(userId));
				}*/
					String tempEditorID = getStatefulEditorId( editorId, userId );
					//Added by shrutika on 03-12-18 [Start] for updateEventLog.
					String event = "get_detail_data";
					//Added by shrutika on 13-12-18 [Start] for activity is not close when click on next in transaction
					if ( objContext != null && !"null".equalsIgnoreCase( objContext )  )
					{
						if ( pkValues !=null && !"null".equalsIgnoreCase( pkValues ) && pkValues.trim().length() > 0 && !"1".equals( objContext ) )
						{
							if ( "A".equalsIgnoreCase( editFlag ) )
							{
								event = "ADD";
							}
							action1 = "EDIT";
						}
						else if ( !"1".equals( objContext ) )
						{
							if("A".equalsIgnoreCase(editFlag))
							{
								event = "ADD";
							}
							action1 = "ADD";
						}
					}
					//Added by shrutika on 13-12-18 [En] for activity is not close when click on next in transaction
					if( userEventLogEJB != null && userInfo != null )
					{
						//Change by shrutika on 05-01-19 for add exception.
						userEventLogEJB.setEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorID, action1 , event, startTime, null ,"pkValues:[" + pkValues + "], objContext:[" + objContext + "], ", pkValues,"Pending","SA","");
					}

					//Added by shrutika on 25-12-18 [Start] for update status as Exception.
					tempstartTime = startTime;
					tempObjName = objName;
					tempevent = event;
					temppkValues = pkValues;
					tempformNo = objContext;
					tempfieldName = fieldName;
					tempactionMode = action1;
					editorID = tempEditorID;
					//Added by shrutika on 25-12-18 [End] for update status as Exception.
					//Added by shrutika on 03-12-18 [End] for updateEventLog.
					if( pkValues != null && pkValues.trim().length() > 0 && ( ! pkValues.equalsIgnoreCase("null") ) && ( "A".equalsIgnoreCase( editFlag ) )  && ( Integer.parseInt( objContext ) == 1 ) ) //$NON-NLS-1$ //$NON-NLS-2$
					{
						//startTime = new Date();
						//Changed by Prasad on 18/05/16 [As per Danish Sir, Editor option added for Property Editor] START
						//responseStr = setActionForDuplicateTransaction(objName, objContext, pkValues , sess , editorId, userId);
						responseStr = setActionForDuplicateTransaction(objName, objContext, pkValues , sess , editorId, userId, editor);
						//Changed by Prasad on 18/05/16 [As per Danish Sir, Editor option added for Property Editor] END
					}
					else
					{
						//startTime = new Date();
						String chgStr = request.getParameter("CHG_STR"); //$NON-NLS-1$
						//Added by shrutika on 26-04-18 [Start] for update forcedSave flag in change xml string.
						E12GenericUtility genericutility = new E12GenericUtility();
						if(forceSave != null && forceSave.equalsIgnoreCase("true"))
						{
							chgStr = genericutility.updateDataHeader(chgStr, forceSave, "forcedSave");
						}
						//Added by shrutika on 26-04-18 [End] for update forcedSave flag in change xml string.
						String argFieldValues = request.getParameter("ARG_VALUES"); //$NON-NLS-1$
						String reqParamStr = request.getParameter("REQ_PARAM_STR"); //$NON-NLS-1$
						//Changed by Prasad on 18/05/16 [As per Danish Sir, Editor option added for Property Editor] START
						//responseStr = getXMLDataForDetail( objName, objContext, editFlag, pkValues, chgStr, argFieldValues, sess, editorId, reqParamStr, userId );
						//responseStr = getXMLDataForDetail( objName, objContext, editFlag, pkValues, chgStr, argFieldValues, sess, editorId, reqParamStr, userId, editor);
						responseStr = getXMLDataOnDelete( objName, objContext, editFlag, pkValues, chgStr, argFieldValues, sess, editorId, reqParamStr, userId, action, domId);
						//Changed by Prasad on 18/05/16 [As per Danish Sir, Editor option added for Property Editor] END
						//					BaseLogger.log("3", userInfo,editorId,"response from getXMLDataForDetail responseStr["+responseStr+"]");
					}
					//String event = "get_detail_data";
					if ( objContext != null && !"null".equalsIgnoreCase( objContext )  )
					{
						if ( pkValues !=null && !"null".equalsIgnoreCase( pkValues ) && pkValues.trim().length() > 0 && !"1".equals( objContext ) )
						{
							if ( "A".equalsIgnoreCase( editFlag ) )
							{
								event = "ADD";
							}
							action1 = "EDIT";
						}
						else if ( !"1".equals( objContext ) ) 
						{
							if("A".equalsIgnoreCase(editFlag))
							{
								event = "ADD";
							}
							action1 = "ADD";
						}
					}
					if( userEventLogEJB != null && userInfo != null )
					{
						//Added by shrutika on 03-12-18 for updateEventLog.
						//userEventLogEJB.setEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorID, action1 , event, new Date(), new Date(),"pkValues:[" + pkValues + "], objContext:[" + objContext + "], ", pkValues);
						//Change by shrutika on 05-01-19 for add exception.
						userEventLogEJB.updateEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorID, action1 , event, startTime, new Date(),"pkValues:[" + pkValues + "], objContext:[" + objContext + "], ", pkValues,"Success","SA","");
					}
					else
					{
						BaseLogger.log("3", userInfo,editorId," ============ User info is null then never create event log in doPost() method of RequestHandlerServlet.java file, action is 'XML_DATA_DETAIL' ");
					}

					org.w3c.dom.Document currentDetailNode = new E12GenericUtility().parseString(responseStr);
					int totalDetailNodes = currentDetailNode.getElementsByTagName("Detail" + FORM_NO).getLength();
					E12GenericUtility genericutility = new E12GenericUtility();
					BaseLogger.log("3", userInfo,editorId,"Inside E12EditorHandlerServlet Action [NEXT] totalDetailNodes["+totalDetailNodes+"]");
					String finalRespStr = "";
					//Changed by Sandeep on 14-APR-16 [[S15LSUN004] New interface for Wizard and Editor] Start
					if( totalDetailNodes > 0)
					{	
						for( int i = 0 ; i < totalDetailNodes ; i++ )
						{	
							if( currentDetailNode.getElementsByTagName("Detail" + FORM_NO).item(i) != null )
							{
								responseStr = new E12GenericUtility().serializeDom( (Node) currentDetailNode.getElementsByTagName("Detail" + FORM_NO).item(i) );
								finalRespStr = finalRespStr + responseStr;
							}
						}
					}
					else if( currentDetailNode.getElementsByTagName("Errors").item(0) != null )
					{
						//finalRespStr = new E12GenericUtility().serializeDom( (Node) currentDetailNode.getElementsByTagName( "Errors" ).item(0) );
						//Added by Shrutika on 20-01-18 for getting error list.
						NodeList errorNodeList = null;
						int errorNodeListLen = 0;
						if( responseStr.indexOf( "<Errors>" ) != -1 )
						{
							if (responseStr != null && responseStr.length() > 0)
							{
								errorNodeList = genericutility.parseString( responseStr ).getElementsByTagName("error");
							}
							if(errorNodeList != null)
							{
								errorNodeListLen = errorNodeList.getLength();
							}
							//Added for loop by Shrutika on 20-01-18 [Start] for display multiple message with different type if present.
							for ( int i = 0; i < errorNodeListLen; i++)
							{
								Node errorNode = currentDetailNode.getElementsByTagName("error").item(i);
								Node typeNode = errorNode.getAttributes().getNamedItem("type");
								
								String typeNodeValue = typeNode.getNodeValue();
								BaseLogger.log("3", userInfo,editorId,"inside E12EditorHandler Servlet...934 typeNodeValue["+typeNodeValue+"]");
								//Added by Shrutika on 19-09-18 for pass column name to set focus in case of custom warning.
								Node columnNode  = errorNode.getAttributes().getNamedItem("column_name");
								String columnVlaue ="";
								if( columnNode != null)
								{
									columnVlaue = columnNode.getNodeValue();
								}
								BaseLogger.log("3", userInfo,editorId,"InE12EditorHandlerServlet columnVlaue["+columnVlaue+"]");
								//Commented By Pankaj T. on 16-03-20 for If the 1st error code is warning and 2nd error code is error, then system does not show warning and shows only error message - start
								//if( !"P".equalsIgnoreCase(typeNodeValue) && !"W".equalsIgnoreCase(typeNodeValue) )
								{
									finalRespStr = finalRespStr + "<Errors>" + new E12GenericUtility().serializeDom( (Node) currentDetailNode.getElementsByTagName( "error" ).item(i) ) + "</Errors>";
								}
								/*else
								{
									//finalRespStr = new E12GenericUtility().serializeDom( (Node) currentDetailNode.getElementsByTagName( "message" ).item(0) );
									//finalRespStr = "<Message type=\""+typeNodeValue+ "\">";
									//Change by Shrutika on 19-09-18 for pass column name to set focus in case of custom warning.
									//finalRespStr = finalRespStr +  "<Message type=\""+typeNodeValue+ "\">";
									finalRespStr = finalRespStr +  "<Message type=\""+typeNodeValue+ "\" column_name=\""+columnVlaue+"\">";
									finalRespStr = finalRespStr + new E12GenericUtility().serializeDom( (Node) currentDetailNode.getElementsByTagName( "message" ).item(i) );
									if( currentDetailNode.getElementsByTagName( "description" ).item(0) != null )
									{
										finalRespStr = finalRespStr + new E12GenericUtility().serializeDom( (Node) currentDetailNode.getElementsByTagName( "description" ).item(i) );
									}
									finalRespStr = finalRespStr + "</Message>";
								}*/
								//Commented By Pankaj T. on 16-03-20 for If the 1st error code is warning and 2nd error code is error, then system does not show warning and shows only error message - end
							
							}
							//Added for loop by Shrutika on 20-01-18 [End] for display multiple message with different type if present.
						}
						
						responseStr = finalRespStr;
					}
					//Changed by Sandeep on 14-APR-16 [[S15LSUN004] New interface for Wizard and Editor] End
					responseStr = "<?xml version='1.0'?><Root><Header><editFlag>null</editFlag></Header><Errors></Errors>" + finalRespStr + "</Root>";
					BaseLogger.log("3", userInfo,editorId,"responseStr ["+responseStr+"]");

					response.setContentType( "text/plain; charset="+CommonConstants.ENCODING );
					response.setHeader("Cache-Control", "no-cache");
					response.getWriter().write( responseStr );
					isAddnlAct = true;
				}
				//Added by Sandeep on 10-May-16 [[S15LSUN004] for next action in Transaction Editor ] end
				//Added by Sandeep on 10-May-16 [[S15LSUN004] for delete action in Transaction Editor ] start
				else if(action.equals("DESELECT"))
				{
					String responseStr = "";
					Date startTime = new Date();
					String objContext = ( request.getParameter("OBJ_CTX")); //$NON-NLS-1$
					String editFlag = ( request.getParameter("EDIT_FLAG")); //$NON-NLS-1$
					String pkValues =  ( request.getParameter("PK_VALUES")); //$NON-NLS-1$
					String editorId =  ( request.getParameter("EDITOR_ID")); //$NON-NLS-1$
					String FORM_NO = ( request.getParameter("FORM_NO")); 
					//Added by Prasad on 18/05/16 [As per Danish Sir, Editor option added for Property Editor] START
					String editor = checkNull( request.getParameter("EDITOR") );
					String domId = checkNull( request.getParameter("DOM_ID") );
					if ( editor.length() == 0 )
					{
						editor = "MobEditor";
					}
					BaseLogger.log("3", userInfo,editorId,"EDITOR - ["+ editor +"]");
					//Added by Prasad on 18/05/16 [As per Danish Sir, Editor option added for Property Editor] END
					String userId = userInfo.getLoginCode();
					editorId = editorId + userId; 
					//String terminal = request.getRemoteAddr();
					//Changed By Pankaj T. on 21-05-2021 for getting actual client ip in case of load balancer - start
					String chgIP = request.getHeader("X-Forwarded-For");
					if(chgIP == null)
					{  
						chgIP = request.getRemoteAddr();
					}
					//Changed By Pankaj T. on 21-05-2021 for getting actual client ip in case of load balancer - end
					String action1 = action;
					BaseLogger.log("3", userInfo,editorId,"Inside E12EditorHandlerServlet FORM_NO["+FORM_NO+"] objContext["+objContext+"] editFlag["+editFlag+"]");
					if("A".equalsIgnoreCase(editFlag))
					{
						action1 = "ADD";
					}
					else if("V".equalsIgnoreCase(editFlag))
					{
						action1 = "VIEW";
					}
					else
					{
						action1 = "EDIT";
					}
					if("EDIT".equalsIgnoreCase(action1) && (pkValues == null || pkValues.trim().length() == 0))
					{
						action1  = "ADD";
					}
					if( "E".equals( editFlag ) )  //$NON-NLS-1$
					{
						/*String tempEditorID = editorId;
					if( editorId != null &&  editorId.indexOf(userId) != -1)
					{
						tempEditorID = editorId.substring(0,editorId.indexOf(userId));
					}
					startTime = new Date();*/
					}
					/*String tempEditorID = editorId;
				if( editorId != null &&  editorId.indexOf(userId) != -1)
				{
					tempEditorID = editorId.substring(0,editorId.indexOf(userId));
				}*/

					if( pkValues != null && pkValues.trim().length() > 0 && ( ! pkValues.equalsIgnoreCase("null") ) && ( "A".equalsIgnoreCase( editFlag ) )  && ( Integer.parseInt( objContext ) == 1 ) ) //$NON-NLS-1$ //$NON-NLS-2$
					{
						startTime = new Date();
						//Changed by Prasad on 18/05/16 [As per Danish Sir, Editor option added for Property Editor] START
						//responseStr = setActionForDuplicateTransaction(objName, objContext, pkValues , sess , editorId, userId);
						responseStr = setActionForDuplicateTransaction(objName, objContext, pkValues , sess , editorId, userId, editor);
						//Changed by Prasad on 18/05/16 [As per Danish Sir, Editor option added for Property Editor] END
					}
					else
					{
						startTime = new Date();
						String chgStr = request.getParameter("CHG_STR"); //$NON-NLS-1$
						String argFieldValues = request.getParameter("ARG_VALUES"); //$NON-NLS-1$
						String reqParamStr = request.getParameter("REQ_PARAM_STR"); //$NON-NLS-1$
						//responseStr = getXMLDataForDetail( objName, objContext, editFlag, pkValues, chgStr, argFieldValues, sess, editorId, reqParamStr, userId );
						responseStr = getXMLDataOnDelete( objName, objContext, editFlag, pkValues, chgStr, argFieldValues, sess, editorId, reqParamStr, userId, action, domId);
						//					BaseLogger.log("3", userInfo,editorId,"response from getXMLDataForDetail responseStr["+responseStr+"]");
					}
					String event = "get_detail_data";
					if ( objContext != null && !"null".equalsIgnoreCase( objContext )  )
					{
						if ( pkValues !=null && !"null".equalsIgnoreCase( pkValues ) && pkValues.trim().length() > 0 && !"1".equals( objContext ) )
						{
							if ( "A".equalsIgnoreCase( editFlag ) )
							{
								event = "ADD";
							}
							action1 = "EDIT";
						}
						else if ( !"1".equals( objContext ) ) 
						{
							if("A".equalsIgnoreCase(editFlag))
							{
								event = "ADD";
							}
							action1 = "ADD";
						}
					}
					/*if( userEventLogEJB != null && userInfo != null )
				{
					userEventLogEJB.setEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorID, action1 , event, new Date(), new Date(),"pkValues:[" + pkValues + "], objContext:[" + objContext + "], ", pkValues);
				}
				else
				{
					BaseLogger.log("3", userInfo,editorId," ============ User info is null then never create event log in doPost() method of RequestHandlerServlet.java file, action is 'XML_DATA_DETAIL' ");
				}*/

					org.w3c.dom.Document currentDetailNode = new E12GenericUtility().parseString(responseStr);
					int totalDetailNodes = currentDetailNode.getElementsByTagName("Detail" + FORM_NO).getLength();
					BaseLogger.log("3", userInfo,editorId,"Inside E12EditorHandlerServlet Action [NEXT] totalDetailNodes["+totalDetailNodes+"]");
					String finalRespStr = "";
					//Changed by Sandeep on 14-APR-16 [[S15LSUN004] New interface for Wizard and Editor] Start
					if( totalDetailNodes > 0)
					{	
						for( int i = 0 ; i < totalDetailNodes ; i++ )
						{	
							if( currentDetailNode.getElementsByTagName("Detail" + FORM_NO).item(i) != null )
							{
								responseStr = new E12GenericUtility().serializeDom( (Node) currentDetailNode.getElementsByTagName("Detail" + FORM_NO).item(i) );
								finalRespStr = finalRespStr + responseStr;
							}
						}
					}
					else if( currentDetailNode.getElementsByTagName("Errors").item(0) != null )
					{
						finalRespStr = new E12GenericUtility().serializeDom( (Node) currentDetailNode.getElementsByTagName( "Errors" ).item(0) );
					}
					//Changed by Sandeep on 14-APR-16 [[S15LSUN004] New interface for Wizard and Editor] End
					//Added by Mahesh Saggam on 22-May-2020 [to return jsonData on delete for extract template] Start
					String returnType =  E12GenericUtility.checkNull( request.getParameter("RTEURN_TYPE"));
					if(!"json".equalsIgnoreCase(returnType))
					{
						responseStr = "<?xml version='1.0'?><Root><Header><editFlag>null</editFlag></Header><Errors></Errors>" + finalRespStr + "</Root>";
					}
					if( "json".equalsIgnoreCase(returnType) && currentDetailNode != null && currentDetailNode.getElementsByTagName("Errors").item(0) == null )
					{
			            JSONObject jsonObject  = XML.toJSONObject(finalRespStr);
			            responseStr = jsonObject.toString();
					}
					//Added by Mahesh Saggam on 22-May-2020 [to return jsonData on delete for extract template] End
					BaseLogger.log("3", userInfo,editorId,"responseStr ["+responseStr+"]");
					response.setContentType( "text/plain; charset="+CommonConstants.ENCODING );
					response.setHeader("Cache-Control", "no-cache");
					response.getWriter().write( responseStr );
					isAddnlAct = true;
				}
				//Added by Sandeep on 10-May-16 [[S15LSUN004] for delete action in Transaction Editor ] end
				else if(action.equals("ITEM_CHANGE")) //$NON-NLS-1$
				{
					Date startTime = new Date();

					String chgStr = request.getParameter("CHG_STR");
					//Added By Pankaj T. on 16-03-20 for If the 1st error code is warning and 2nd error code is error, then system does not show warning and shows only error message - start
					E12GenericUtility genericutility = new E12GenericUtility();
					if(forceSave != null && forceSave.equalsIgnoreCase("true"))
					{
						chgStr = genericutility.updateDataHeader(chgStr, forceSave, "forcedSave");
					}
					//Added By Pankaj T. on 16-03-20 for If the 1st error code is warning and 2nd error code is error, then system does not show warning and shows only error message - end
					String editorId = request.getParameter("EDITOR_ID");
					String userId = userInfo.getLoginCode();
					editorId = editorId + userId;
					objName =  request.getParameter("OBJ_NAME"); //$NON-NLS-1$
					String objContext =  request.getParameter("OBJ_CTX"); //$NON-NLS-1$
					String pkValues =  request.getParameter("PK_VALUES"); //$NON-NLS-1$
					String argFieldValues = request.getParameter("ARG_VALUES"); //$NON-NLS-1$
					String pageContext = request.getParameter("PAGE_CTX"); //$NON-NLS-1$

					//Added by shrutika on 17-01-18 for add focuscolumn in arg param.
					focusColumn = request.getParameter("FIELD_NAME");

					//Added by shrutika on 03-12-18 [Start] for updateEventLog.
					String editFlag = "";
					String tempEditorID = getStatefulEditorId( editorId, userId );
					BaseLogger.log("3", userInfo,editorId,"Dnyaneshwar ::  ITEM_CHANGE chgStr["+chgStr+"] \n editFlag["+editFlag+"] objName["+objName+"]");
					String action1 = "EDIT";
					if("A".equalsIgnoreCase(editFlag))
					{
						action1 = "ADD";
					}
					else if("V".equalsIgnoreCase(editFlag))
					{
						action1 = "VIEW";
					}
					else
					{
						action1 = "EDIT";
					}
					if( userEventLogEJB != null && userInfo != null )
					{
						//Change by shrutika on 05-01-19 for add exception.
						userEventLogEJB.setEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorID, action1 , "item change", startTime, null ,"pkValues:[" + pkValues + "], pageContext:[" + pageContext + "], objContext:[" + objContext + "], argFieldValues:[" + argFieldValues + "] focusColumn["+focusColumn+"]", pkValues,"Pending","SA","");
					}

					//Added by shrutika on 25-12-18 [Start] for update status as Exception.
					tempargFieldValues = argFieldValues;
					tempstartTime = startTime;
					tempObjName = objName;
					tempevent = "item change";
					temppkValues = pkValues;
					tempformNo = objContext;
					tempfieldName = fieldName;
					tempactionMode = action1;
					editorID = tempEditorID;
					temppageContext = pageContext;
					//Added by shrutika on 25-12-18 [End] for update status as Exception.
					//Added by shrutika on 03-12-18 [End] for updateEventLog.
					String responseStr = getChangedData(chgStr, sess, request, editorId, userId);
					if( chgStr != null && !"null".equalsIgnoreCase( chgStr ) )
					{
						E12GenericUtility e12GenericUtility = new E12GenericUtility();
						Document dom = e12GenericUtility.parseString(chgStr);
						if( objName == null || "null".equalsIgnoreCase(objName)  )
						{
							objName = e12GenericUtility.getColumnValue( "objName", dom );
						}
						editFlag = e12GenericUtility.getColumnValue( "editFlag", dom );
						if( pkValues==null || "null".equalsIgnoreCase(pkValues) )
						{
							pkValues = "NA";
						}
						if( objContext == null || "null".equalsIgnoreCase(objContext) )
						{
							objContext = e12GenericUtility.getColumnValue( "objContext", dom );
						}
						if( pageContext == null || "null".equalsIgnoreCase(pageContext) )
						{
							pageContext = e12GenericUtility.getColumnValue( "pageContext", dom );
						}
					}
					/*String tempEditorID = editorId;
				if( editorId != null &&  editorId.indexOf( userInfo.getLoginCode() ) != -1)
				{
					tempEditorID = editorId.substring(0,editorId.indexOf( userInfo.getLoginCode() ));
				}*/
					tempEditorID = getStatefulEditorId( editorId, userId );
					BaseLogger.log("3", userInfo,editorId,"Dnyaneshwar ::  ITEM_CHANGE chgStr["+chgStr+"] \n editFlag["+editFlag+"] objName["+objName+"]");
					action1 = "EDIT";
					if("A".equalsIgnoreCase(editFlag))
					{
						action1 = "ADD";
					}
					else if("V".equalsIgnoreCase(editFlag))
					{
						action1 = "VIEW";
					}
					else
					{
						action1 = "EDIT";
					}
					if( userEventLogEJB != null && userInfo != null )
					{
						//Added by shrutika on 03-12-18  for updateEventLog.
						//userEventLogEJB.setEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorID, action1 , "item change", startTime, new Date(),"pkValues:[" + pkValues + "], pageContext:[" + pageContext + "], objContext:[" + objContext + "], argFieldValues:[" + argFieldValues + "]", pkValues);
						//Change by shrutika on 05-01-19 for add exception.
						userEventLogEJB.updateEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorID, action1 , "item change", startTime, new Date(),"pkValues:[" + pkValues + "], pageContext:[" + pageContext + "], objContext:[" + objContext + "], argFieldValues:[" + argFieldValues + "]  focusColumn["+focusColumn+"]", pkValues,"Success","SA","");
					}
					else
					{
						BaseLogger.log("3", userInfo,editorId," ============ User info is null then never create event log in doPost() method of RequestHandlerServlet.java file, action is 'XML_DATA_DETAIL' ");
					}

					org.w3c.dom.Document currentDetailNode = new E12GenericUtility().parseString(responseStr);
					String finalRespStr = "";
					//Added by Pankaj T on 23-03-18[to check if currentDetailNode is blank or not ]-Start
//					if( currentDetailNode.getElementsByTagName("Errors").item(0) != null )
					if( currentDetailNode != null && currentDetailNode.getElementsByTagName("Errors").item(0) != null )
					{
						Node errorNode = currentDetailNode.getElementsByTagName("error").item(0);
						Node typeNode = errorNode.getAttributes().getNamedItem("type");
						String typeNodeValue = typeNode.getNodeValue();
						BaseLogger.log("3", userInfo,editorId,"InE12EditorHandlerServlet typeNodeValue["+typeNodeValue+"]");
						//Commented By Pankaj T. on 16-03-20 for If the 1st error code is warning and 2nd error code is error, then system does not show warning and shows only error message - start
						//if( !"P".equalsIgnoreCase(typeNodeValue) && !"W".equalsIgnoreCase(typeNodeValue) )
						{
							finalRespStr = new E12GenericUtility().serializeDom( (Node) currentDetailNode.getElementsByTagName( "Errors" ).item(0) );
						}
						/*else
						{
							//finalRespStr = new E12GenericUtility().serializeDom( (Node) currentDetailNode.getElementsByTagName( "message" ).item(0) );
							finalRespStr = "<Message type=\""+typeNodeValue+ "\">";
							finalRespStr = finalRespStr + new E12GenericUtility().serializeDom( (Node) currentDetailNode.getElementsByTagName( "message" ).item(0) );
							if( currentDetailNode.getElementsByTagName( "description" ).item(0) != null )
							{
								finalRespStr = finalRespStr + new E12GenericUtility().serializeDom( (Node) currentDetailNode.getElementsByTagName( "description" ).item(0) );
							}
							finalRespStr = finalRespStr + "</Message>";
						}*/
						//Commented By Pankaj T. on 16-03-20 for If the 1st error code is warning and 2nd error code is error, then system does not show warning and shows only error message - end
						responseStr = finalRespStr;
					}
					
					
					//Added by shrutika on 19-05-2020 [Start] for extract template option.
					String returnType =  E12GenericUtility.checkNull( request.getParameter("RTEURN_TYPE"));
					if( "json".equalsIgnoreCase(returnType) && currentDetailNode != null && currentDetailNode.getElementsByTagName("Errors").item(0) == null )
					//if( "json".equalsIgnoreCase(returnType) )
					{
			            JSONObject jsonObject  = XML.toJSONObject(responseStr);
			            responseStr = jsonObject.toString();
					}
					//Added by shrutika on 19-05-2020 [End] for extract template option.

					request.getInputStream();
					response.setContentType( "text/plain; charset="+CommonConstants.ENCODING );
					response.setHeader("Cache-Control", "no-cache");
					response.getWriter().write( responseStr );
				}
				else if(action.equals("VAL_DATA")) //$NON-NLS-1$
				{
					String chgStr = request.getParameter("CHG_STR");
					//Added By Pankaj T. on 16-03-20 for If the 1st error code is warning and 2nd error code is error, then system does not show warning and shows only error message - start
					E12GenericUtility genericutility = new E12GenericUtility();
					
					//Added by shrutika on 26-10-2020 [Start] for finish functionality in extract template.
					String isExtractTemplate = checkNull( request.getParameter("IsExtractTemplate") );
					String objContext = checkNull( request.getParameter("FORM_NO") );
					String editFlag =  request.getParameter("EDIT_FLAG");	 //$NON-NLS-1$
					String domId =  request.getParameter("DOM_ID");
					if( "true".equalsIgnoreCase(isExtractTemplate) )
					{
						chgStr = currentDomIdDataforFinsih(chgStr, objContext, domId, objName, editFlag);
					}
					//Added by shrutika on 26-10-2020 [End] for finish functionality in extract template.
					if(forceSave != null && forceSave.equalsIgnoreCase("true"))
					{
						chgStr = genericutility.updateDataHeader(chgStr, forceSave, "forcedSave");
					}
					//Added By Pankaj T. on 16-03-20 for If the 1st error code is warning and 2nd error code is error, then system does not show warning and shows only error message - end
					String editorId = request.getParameter( "EDITOR_ID" ); //$NON-NLS-1$
					String userId = userInfo.getLoginCode();
					editorId = editorId + userId;
					String refSer = request.getParameter( "REF_SER" ); //$NON-NLS-1$
					String saveLvl =  request.getParameter( "SAVE_LVL" ); //$NON-NLS-1$
					String saveDocument =  request.getParameter( "SAVE_DOCUMENT" ); //$NON-NLS-1$
					//String editFlag =  request.getParameter("EDIT_FLAG");	 //$NON-NLS-1$
					//Added By Pankaj T. on 23-11-18 for if no change in form then avoid detail form validation when click on Finish from feed view - start
					String isFormChange = request.getParameter("IS_FORM_CHANGE");
					BaseLogger.log("3",userInfo,editorId,"E12EditorHandlerServlet.doPost() isFormChange:["+isFormChange+"]");
					//Added By Pankaj T. on 23-11-18 for if no change in form then avoid detail form validation when click on Finish from feed view - end
					//Added by Prasad on 18/05/16 [As per Danish Sir, Editor option added for Property Editor] START
					String editor = checkNull( request.getParameter("EDITOR") );
					if ( editor.length() == 0 )
					{
						editor = "MobEditor";
					}
					BaseLogger.log("3", userInfo,editorId,"EDITOR ===> ["+editor+"]");
					//Added by Prasad on 18/05/16 [As per Danish Sir, Editor option added for Property Editor] END
					BaseLogger.log("3", userInfo,editorId,"CHG_STR ===> ["+chgStr+"]");
					BaseLogger.log("3", userInfo,editorId,"SAVE_LVL ===> ["+saveLvl+"]");
					BaseLogger.log("3", userInfo,editorId,"SAVE_DOCUMENT ===> ["+saveDocument+"]");
					//Added by Bhupendra M on 5-June-17 for Client Side Summary Xsl Transformation Starts
					String callerInterface = request.getParameter("CALLER_INTERFACE");
					
					//Added by Jay.K to draw summary from enterprise folder[Start]
					String currentSummaryXsl = new E12GenericUtility().getSummaryXSL( objName, callerInterface,enterprise );
					//Added by Jay.K to draw summary from enterprise folder[End]

					//Added by Bhupendra M on 5-June-17 for Client Side Summary Xsl Transformation End
					//Changed by Prasad on 04/05/17 [Create E12TransEditorCoreModel and keep in session instead of MasterStateful]
					//MasterStatefulRemote masterStatefulEJB = ( MasterStatefulRemote )sess.getAttribute( editorId );
					E12TransEditorCoreModel transEditorCoreModel = (E12TransEditorCoreModel) sess.getAttribute( editorId );
					/*String tempEditorID = editorId;
				if( editorId != null &&  editorId.indexOf(userInfo.getLoginCode()) != -1)
				{
					tempEditorID = editorId.substring( 0, editorId.indexOf( userInfo.getLoginCode() ) );
				}*/
					try 
					{
						if ( transEditorCoreModel != null )
						{
							MasterStatefulRemote masterStatefulEJB = transEditorCoreModel.getMasterStateful();
							if( masterStatefulEJB != null && masterStatefulEJB.getEditorId() != null )
							{
								//Added By Pankaj T. on 23-11-18 for if no change in form then avoid detail form validation when click on Finish from feed view - start
								masterStatefulEJB.setIsFormChange(isFormChange);
								//Added By Pankaj T. on 23-11-18 for if no change in form then avoid detail form validation when click on Finish from feed view - end
								String tempEditorID = getStatefulEditorId( editorId, userId );
								masterStatefulEJB.setEditorId(tempEditorID);
								//Added by Prasad on 18/05/16 [As per Danish Sir, Editor option added for Property Editor]
								masterStatefulEJB.setEditor(editor);
								String tranID = ""; //$NON-NLS-1$
								if( masterStatefulEJB.getTranId() != null )
								{
									tranID = masterStatefulEJB.getTranId().trim();
								}
								//String objName = ""; //$NON-NLS-1$
								if( ! ("V".equals( editFlag ) ) )  //$NON-NLS-1$
								{
									AppConnectParm appConn = new AppConnectParm();
									InitialContext ctx = new InitialContext(appConn.getProperty());
									Calendar cal = Calendar.getInstance();
									SimpleDateFormat formatter = new SimpleDateFormat(CommonConstants.DISP_DATETIME_FORMAT);
									String currentDateTime = formatter.format( cal.getTime() ); 
									Document chgString = new E12GenericUtility().parseString( chgStr );
									if( chgString != null )
									{
										NodeList chgStringchildNode = chgString.getFirstChild().getChildNodes();
										objName = chgStringchildNode.item(0).getChildNodes().item(0).getFirstChild().getNodeValue();
									}
									masterStatefulEJB.setEditorId(tempEditorID);
									EventLogInfoBean eventInfoBean = null;
									if( userInfo != null )
									{
										eventInfoBean = new EventLogInfoBean(userInfo.getLoginCode());
									}
									else
									{
										BaseLogger.log("3", userInfo,editorId," ============ User info is null then never created event log in E12EditorHandlerServlet.java file");
									}
								}
								String responseStr = validateData( chgStr, sess, editorId, editFlag, saveLvl, objName, tranID, masterStatefulEJB );

								BaseLogger.log("3", userInfo,editorId,"responseStr =["+responseStr+"]");

								//Added by Prasad on 29/07/16 [for adding follow up actions] START
								String tranIDRet = "";
								try
								{
									Node tranIdNode = new E12GenericUtility().parseString( responseStr ).getElementsByTagName("TranID").item(0);
									if ( tranIdNode != null && tranIdNode.getFirstChild() != null)
									{
										tranIDRet = tranIdNode.getFirstChild().getNodeValue();
									}
									BaseLogger.log("3", userInfo,editorId,"tranIDRet - ["+ tranIDRet +"]");
									//userId = userInfo.getLoginCode();
									String coreModelID = request.getParameter("CORE_MDL_ID");
									if(tranIDRet != null && tranIDRet.trim().length() > 0)
									{
										//Changed by Pankaj T on 04-01-18 [changes for multitenancy]
										addFollowUpAction( userId, coreModelID, tranIDRet, objName, userInfo );
									}
								}
								catch(Exception ex)
								{
									ex.printStackTrace();
								}
								//Added by Prasad on 29/07/16 [for adding follow up actions] END

								// Changed by Abhishek T on 08-Feb-17 [For sending notification if error not present] Start
								//Added By Suraj on 19-01-2017 [Auto refresh data for wizard]End
								final String finalKey = objName+"_"+tranIDRet;
								final String tranIDWS = tranIDRet;
								final String userIdWS = userId;
								final String objNameEd = objName;
								BaseLogger.log("3", userInfo,editorId,"1019------refIdNew ["+tranIDWS+"] finalKey ["+finalKey+"]");
								
								// Added by Abhishek T on 07-Nov-2019
								final String summaryXMLString = getSummaryXMLString(finalKey, objNameEd, userInfo);
								
								// Changed by Abhishek T on 08-Feb-17 [For sending notification if error not present] START
								//Added By Suraj on 19-01-2017 [Auto refresh data for wizard]Start
								new Thread()					
								{
									@Override
									public void run() 
									{
										try 
										{
											//Added by Pankaj T on 03-08-17 [To use infinispan cache depends on ibase.xml configuration] Start
											ArrayList<String> userIdList = new ArrayList<String>();
											String xmlData = "";
											String webSocketXMLData = "";
											//Added Pankaj T on 18-10-17 [To use infinispan cache depends on CACHE_OPT define in ibase.xml 0 = NO Cache, 1 = Internal Cache, 2 = External Cache]
											if( CommonConstants.CACHE_OPT != 0 )
											{
												/*InfinispanLocal infinispanLocalObj = null;
												Hashtable jndiProperties = null;
												InitialContext ctx = null;*/
												//String infiStr = "";
//												ArrayList<String> userIdList = null;
												BaseLogger.log("3", userInfo,null,"959 ----!!*** Recent Activity: In run method");

												/*if(infinispanLocalObj == null)
												{
													BaseLogger.log("3", userInfo,editorId,"SummaryInfiniSpan infinispanLocalObj is null.....");
													jndiProperties = new Hashtable();
													jndiProperties.put(Context.URL_PKG_PREFIXES,"org.jboss.ejb.client.naming");	   
													ctx=new InitialContext(jndiProperties);
													infinispanLocalObj = ((InfinispanLocal)ctx.lookup("ibase/InfinispanEJB/local"));
													BaseLogger.log("3", userInfo,editorId,"SummaryInfiniSpan infinispanLocalObj created.....");
												}*/

												if( infinispanLocalObj != null )
												{
													BaseLogger.log("3", userInfo,null,"Getting values inside infinispan object ["+finalKey+"]" );
													//infinispanLocalObj.put(  );
													xmlData = summaryXMLString;
													userIdList = infinispanLocalObj.getUsers();
													//Added by Bhupendra M on 15-05-17 for Tran Id is not display on summery page after saving any transaction in compact layout Starts
													//Commented by Saiprasad G. for the auto refresh the field for browser[START]
													// webSocketXMLData = new E12GenericUtility().editWebSocketXml( xmlData );
													//Commented by Saiprasad G. for the auto refresh the field for browser [END]
													//infiStr = tranIDWS+"~"+objNameEd+"~"+E12GenericUtility.checkNull(infiStr);
													//infiStr = objNameEd+"~"+E12GenericUtility.checkNull(infiStr);
													//Commented by Saiprasad G. for the auto refresh the field for browser[START]
													//xmlData = objNameEd+"~"+E12GenericUtility.checkNull(webSocketXMLData);
													//Commented by Saiprasad G. for the auto refresh the field for browser[END]
													xmlData = E12GenericUtility.checkNull(xmlData);
													//Added by Bhupendra M on 15-05-17 for Tran Id is not display on summery page after saving any transaction in compact layout Ends
												}
											}
											else
											{
												// RAHandler raHandler = new RAHandler();
												if(RAHandler.getUserRATO().containsKey(userIdWS))
												{
													ArrayList<RAHandlerTO> raHandlerTOs = RAHandler.getUserRATO().get(userIdWS);
													if(raHandlerTOs != null && !raHandlerTOs.isEmpty())
													{
														//Commented by Saiprasad G. for the auto refresh the field for browser[START]
														// RAHandlerTO raHandlerTO = new RAHandlerTO();
														// raHandlerTO = raHandlerTOs.get(raHandlerTOs.size()-1);
														//Commented by Saiprasad G. for the auto refresh the field for browser[END]
														// String tranId = E12GenericUtility.checkNull(raHandlerTO.getTranId());
														//Commented by Saiprasad G. for the auto refresh the field for browser[START]
														// String object = E12GenericUtility.checkNull(raHandlerTO.getObject());
														// webSocketXMLData = new E12GenericUtility().editWebSocketXml( E12GenericUtility.checkNull(raHandlerTO.getData()) );
														//xmlData = object+"~"+E12GenericUtility.checkNull(webSocketXMLData);
														//Commented by Saiprasad G. for the auto refresh the field for browser[END]
														xmlData = summaryXMLString;
														xmlData = E12GenericUtility.checkNull(xmlData);
														//xmlData = tranId+"~"+object+"~"+E12GenericUtility.checkNull(raHandlerTO.getData());
														userIdList.add(userIdWS);
														//String message = "New Notification";
														//														PublishPushNotificationRemote notificationRemote = (PublishPushNotificationRemote) getInitialContext().lookup("ibase/PublishPushNotificationEJB/remote");
														//														notificationRemote.invockPushNotification(message, userId, PublishPushNotificationRemote.OPEN_TARGET_TRANSACTION, tranId, userIdList , xmlData, "", "", userId, 0, "C");
													}
												}
											}
											//Added by Pankaj T on 03-08-17 [To use infinispan cache depends on ibase.xml configuration] End
											if( userIdList != null )
											{
												if( userIdList.contains( userIdWS ))
												{
													BaseLogger.log("3", userInfo,null,"********** User exists ----- userId ["+userIdWS+"]");
													String message = "New Notification";
													ArrayList<String> currentUserList = new ArrayList<String>();
													currentUserList.add( userIdWS.trim() );

													//PublishPushNotificationRemote notificationRemote = (PublishPushNotificationRemote) getInitialContext().lookup("ibase/PublishPushNotificationEJB/remote");
													PublishPushNotificationEJB notificationRemote = new PublishPushNotificationEJB();
													// Changed by Pankaj R on 26-Feb-18 added userInfo parameter
													//Commented and Added by Pankaj R on 05-Nov-18 to identify the web socket message type [START]
													//notificationRemote.invockPushNotification(message, userIdWS, PublishPushNotificationRemote.OPEN_TARGET_TRANSACTION, tranIDWS, currentUserList , xmlData, "", "", userIdWS, 0, "C", "1", userInfo);
													notificationRemote.invockPushNotification(message, userIdWS, PublishPushNotificationRemote.OPEN_TARGET_TRANSACTION, tranIDWS, currentUserList , xmlData, "", "", userIdWS, 0, "C", userInfo, "1", WebSocketMessageType.SUMMARY);
													//Added by Pankaj R on 05-Nov-18 to identify the web socket message type [END]
												}
											}
										}
										catch (Exception e) 
										{
											BaseLogger.log("0", userInfo,null,"Exception in new thread::"+e.getMessage());
										}						
									}					
								}.start();
								// Changed by Abhishek T on 08-Feb-17 [For sending notification if error not present] END
								//Added By Suraj on 19-01-2017 [Auto refresh data for wizard]End

								if( Boolean.valueOf( saveDocument ).booleanValue() && ( responseStr == null  || responseStr.indexOf("<Errors>") == -1 || responseStr.indexOf( "ERR_MSG" ) == -1 ) ) //$NON-NLS-1$ //$NON-NLS-2$
								{
									//change by shrutika on 28-01-19 for multiple activities are not update due to global userinfo.
								//	String refId = getSavedTransId(responseStr);
									String refId = getSavedTransId(responseStr, userInfo);
									String password = request.getParameter("PASSWORD"); //$NON-NLS-1$
									String siteCode = request.getParameter("SITE_CODE"); //$NON-NLS-1$
									String param = "?ACTION=SAVE_UNSAVED_ATTACHMENT&USER="+userInfo.getLoginCode()+"&PASSWORD="+password+"&SITE_CODE="+siteCode+"&EDITOR_ID="+editorId +"&REF_ID="+refId+"&REF_SER="+refSer+"&RES_STR="+responseStr; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$
									response.sendRedirect( "/ibase/WebITMDocumentHandlerServlet" + param ); //$NON-NLS-1$
								}

								//Change done by Sandeep S. on 26/09/16 [To display promt or warning alert mesage] Start
								org.w3c.dom.Document currentDetailNode = new E12GenericUtility().parseString(responseStr);
								String finalRespStr = "";
								NodeList errorNodeList = null;
								int errorNodeListLen = 0;
								//Commented By Pankaj T. on 16-03-20 for If the 1st error code is warning and 2nd error code is error, then system does not show warning and shows only error message
								//E12GenericUtility genericutility = new E12GenericUtility();
								if (responseStr != null && responseStr.length() > 0)
								{
									errorNodeList = genericutility.parseString( responseStr ).getElementsByTagName("error");
								}
								if(errorNodeList != null)
								{
									errorNodeListLen = errorNodeList.getLength();
								}
								//Added for loop by Shrutika on 20-01-18 [Start] for display multiple message with different type if present.
								for ( int i = 0; i < errorNodeListLen; i++)
								{
									if(currentDetailNode.getElementsByTagName("error").item(i) != null)
									{
										Node errorNode = currentDetailNode.getElementsByTagName("error").item(i);
										Node typeNode = errorNode.getAttributes().getNamedItem("type");
										String typeNodeValue = typeNode.getNodeValue();
										BaseLogger.log("3", userInfo,editorId,"InE12EditorHandlerServlet typeNodeValue..1471["+typeNodeValue+"]");
										//Added by Shrutika on 19-09-18 for pass column name to set focus in case of custom warning.
										Node columnNode  = errorNode.getAttributes().getNamedItem("column_name");
										String columnVlaue ="";
										if( columnNode != null)
										{
											columnVlaue = columnNode.getNodeValue();
										}
										BaseLogger.log("3", userInfo,editorId,"InE12EditorHandlerServlet on finsih columnVlaue["+columnVlaue+"]");
										//Commented By Pankaj T. on 16-03-20 for If the 1st error code is warning and 2nd error code is error, then system does not show warning and shows only error message - start
										//if( !"P".equalsIgnoreCase(typeNodeValue) && !"W".equalsIgnoreCase(typeNodeValue) )
										{
											finalRespStr = finalRespStr + "<Errors>" + new E12GenericUtility().serializeDom( (Node) currentDetailNode.getElementsByTagName( "error" ).item(i) ) + "</Errors>";
										}
										/*else
										{
											//Change by Shrutika on 19-09-18 for pass column name to set focus in case of custom warning.
											//finalRespStr = finalRespStr +"<Message type=\""+typeNodeValue+ "\">";
											finalRespStr = finalRespStr +  "<Message type=\""+typeNodeValue+ "\" column_name=\""+columnVlaue+"\">";
											finalRespStr = finalRespStr + new E12GenericUtility().serializeDom( (Node) currentDetailNode.getElementsByTagName( "message" ).item(i) );
											if( currentDetailNode.getElementsByTagName( "description" ).item(i) != null )
											{
												finalRespStr = finalRespStr + new E12GenericUtility().serializeDom( (Node) currentDetailNode.getElementsByTagName( "description" ).item(i) );
											}
											finalRespStr = finalRespStr + "</Message>";
										}*/
										//Commented By Pankaj T. on 16-03-20 for If the 1st error code is warning and 2nd error code is error, then system does not show warning and shows only error message - end
										
										responseStr = finalRespStr;
									}
								}
								//Added for loop by Shrutika on 20-01-18 [End] for display multiple message with different type if present.
								//change by shrutika on 26-10-2020 [Start] for finish functionality in extract template.
								if( !"true".equalsIgnoreCase(isExtractTemplate)  )
								{
									responseStr = "<?xml version='1.0'?><Root><Header><editFlag>null</editFlag></Header><Errors></Errors>" + responseStr + "</Root>";
								}
								//change by shrutika on 26-10-2020 [End] for finish functionality in extract template.
								BaseLogger.log("3", userInfo,editorId,"responseStr ["+responseStr+"]");
								//Added by Bhupendra M on 5-June-17 for Client Side Summary Xsl Transformation Starts
								
								// Added by Abhishek T on 30-Oct-2019 START
								responseStr = responseStr + "~#~" + currentSummaryXsl + "~#~" + summaryXMLString;
								// Added by Abhishek T on 30-Oct-2019 END
								
								//Added by Bhupendra M on 5-June-17 for Client Side Summary Xsl Transformation End
								response.setContentType( "text/xml; charset="+CommonConstants.ENCODING );
								response.setHeader("Cache-Control", "no-cache");
								response.getWriter().write( responseStr );
							}
						}
					}
					catch ( javax.ejb.NoSuchEJBException e ) 
					{
						BaseLogger.log("0", userInfo,editorId, " RequestHandlerServlet :: IN CATCH BLOCK " );
					}
				}
				//Added By Pankaj T. on 08-03-19 for on cancel set old data in detailDom if isFormDirty - start
				else if(action.equals("CANCEL"))
				{
					String chgStr = request.getParameter("CHG_STR");
					//Added By Pankaj T. on 16-03-20 for If the 1st error code is warning and 2nd error code is error, then system does not show warning and shows only error message - start
					E12GenericUtility genericutility = new E12GenericUtility();
					if(forceSave != null && forceSave.equalsIgnoreCase("true"))
					{
						chgStr = genericutility.updateDataHeader(chgStr, forceSave, "forcedSave");
					}
					//Added By Pankaj T. on 16-03-20 for If the 1st error code is warning and 2nd error code is error, then system does not show warning and shows only error message - end
					String editorId = request.getParameter( "EDITOR_ID" );
					String userId = userInfo.getLoginCode();
					editorId = editorId + userId;
					String refSer = request.getParameter( "REF_SER" );
					String saveLvl =  request.getParameter( "SAVE_LVL" );
					String saveDocument =  request.getParameter( "SAVE_DOCUMENT" );
					String editFlag =  request.getParameter("EDIT_FLAG");	
					//Added By Pankaj T. on 23-11-18 for if no change in form then avoid detail form validation when click on Finish from feed view - start
					String isFormChange = request.getParameter("IS_FORM_CHANGE");
					BaseLogger.log("3",userInfo,editorId,"E12EditorHandlerServlet.doPost() isFormChange:["+isFormChange+"]");
					//Added By Pankaj T. on 23-11-18 for if no change in form then avoid detail form validation when click on Finish from feed view - end
					String editor = checkNull( request.getParameter("EDITOR") );
					if ( editor.length() == 0 )
					{
						editor = "MobEditor";
					}
					BaseLogger.log("3", userInfo,editorId,"EDITOR ===> ["+editor+"]");
					BaseLogger.log("3", userInfo,editorId,"CHG_STR ===> ["+chgStr+"]");
					BaseLogger.log("3", userInfo,editorId,"SAVE_LVL ===> ["+saveLvl+"]");
					BaseLogger.log("3", userInfo,editorId,"SAVE_DOCUMENT ===> ["+saveDocument+"]");
					E12TransEditorCoreModel transEditorCoreModel = (E12TransEditorCoreModel) sess.getAttribute( editorId );
					try 
					{
						if ( transEditorCoreModel != null )
						{
							MasterStatefulRemote masterStatefulEJB = transEditorCoreModel.getMasterStateful();
							if( masterStatefulEJB != null && masterStatefulEJB.getEditorId() != null )
							{
								//Added By Pankaj T. on 23-11-18 for if no change in form then avoid detail form validation when click on Finish from feed view - start
								masterStatefulEJB.setIsFormChange(isFormChange);
								//Added By Pankaj T. on 23-11-18 for if no change in form then avoid detail form validation when click on Finish from feed view - end
								String tempEditorID = getStatefulEditorId( editorId, userId );
								masterStatefulEJB.setEditorId(tempEditorID);
								masterStatefulEJB.setEditor(editor);
								String responseStr = masterStatefulEJB.updateDetailDomOnCancel( chgStr );
								BaseLogger.log("3", userInfo,editorId,"responseStr =["+responseStr+"]");
								org.w3c.dom.Document currentDetailNode = new E12GenericUtility().parseString(responseStr);
								String finalRespStr = "";
								NodeList errorNodeList = null;
								int errorNodeListLen = 0;
								//Commented By Pankaj T. on 16-03-20 for If the 1st error code is warning and 2nd error code is error, then system does not show warning and shows only error message
								//E12GenericUtility genericutility = new E12GenericUtility();
								if (responseStr != null && responseStr.length() > 0)
								{
									errorNodeList = genericutility.parseString( responseStr ).getElementsByTagName("error");
								}
								if(errorNodeList != null)
								{
									errorNodeListLen = errorNodeList.getLength();
								}
								//Added for loop by Shrutika on 20-01-18 [Start] for display multiple message with different type if present.
								for ( int i = 0; i < errorNodeListLen; i++)
								{
									if(currentDetailNode.getElementsByTagName("error").item(i) != null)
									{
										Node errorNode = currentDetailNode.getElementsByTagName("error").item(i);
										Node typeNode = errorNode.getAttributes().getNamedItem("type");
										String typeNodeValue = typeNode.getNodeValue();
										BaseLogger.log("3", userInfo,editorId,"InE12EditorHandlerServlet typeNodeValue..1471["+typeNodeValue+"]");
										//Added by Shrutika on 19-09-18 for pass column name to set focus in case of custom warning.
										Node columnNode  = errorNode.getAttributes().getNamedItem("column_name");
										String columnVlaue ="";
										if( columnNode != null)
										{
											columnVlaue = columnNode.getNodeValue();
										}
										BaseLogger.log("3", userInfo,editorId,"InE12EditorHandlerServlet on finsih columnVlaue["+columnVlaue+"]");
										//Commented By Pankaj T. on 16-03-20 for If the 1st error code is warning and 2nd error code is error, then system does not show warning and shows only error message - start
										//if( !"P".equalsIgnoreCase(typeNodeValue) && !"W".equalsIgnoreCase(typeNodeValue) )
										{
											finalRespStr = finalRespStr + "<Errors>" + new E12GenericUtility().serializeDom( (Node) currentDetailNode.getElementsByTagName( "error" ).item(i) ) + "</Errors>";
										}
										/*else
										{
											//Change by Shrutika on 19-09-18 for pass column name to set focus in case of custom warning.
											//finalRespStr = finalRespStr +"<Message type=\""+typeNodeValue+ "\">";
											finalRespStr = finalRespStr +  "<Message type=\""+typeNodeValue+ "\" column_name=\""+columnVlaue+"\">";
											finalRespStr = finalRespStr + new E12GenericUtility().serializeDom( (Node) currentDetailNode.getElementsByTagName( "message" ).item(i) );
											if( currentDetailNode.getElementsByTagName( "description" ).item(i) != null )
											{
												finalRespStr = finalRespStr + new E12GenericUtility().serializeDom( (Node) currentDetailNode.getElementsByTagName( "description" ).item(i) );
											}
											finalRespStr = finalRespStr + "</Message>";
										}*/
										//Commented By Pankaj T. on 16-03-20 for If the 1st error code is warning and 2nd error code is error, then system does not show warning and shows only error message - end
										
										responseStr = finalRespStr;
									}
								}
								//Added for loop by Shrutika on 20-01-18 [End] for display multiple message with different type if present.
								responseStr = "<?xml version='1.0'?><Root><Header><editFlag>null</editFlag></Header><Errors></Errors>" + responseStr + "</Root>";
								BaseLogger.log("3", userInfo,editorId,"responseStr ["+responseStr+"]");
								response.setContentType( "text/xml; charset="+CommonConstants.ENCODING );
								response.setHeader("Cache-Control", "no-cache");
								response.getWriter().write( responseStr );
							}
						}
					}
					catch ( Exception e ) 
					{
						BaseLogger.log("0", userInfo,editorId, " RequestHandlerServlet on CANCEL:: IN CATCH BLOCK " );
					}
				}
				//Added By Pankaj T. on 08-03-19 for on cancel set old data in detailDom if isFormDirty - end
				else if(action.equals("ADD_DETAIL_DOM"))
				{
					String responseStr = "";
					Date startTime = new Date();
					String objContext = ( request.getParameter("OBJ_CTX")); //$NON-NLS-1$
					String editFlag = ( request.getParameter("EDIT_FLAG")); //$NON-NLS-1$
					String pkValues =  ( request.getParameter("PK_VALUES")); //$NON-NLS-1$
					String editorId =  ( request.getParameter("EDITOR_ID")); //$NON-NLS-1$
					String FORM_NO = ( request.getParameter("FORM_NO")); 
					String userId = userInfo.getLoginCode();
					String editor = checkNull( request.getParameter("EDITOR") );
					String domId = checkNull( request.getParameter("DOM_ID") );
					editorId = editorId + userId; 
					//String terminal = request.getRemoteAddr();
					//Changed By Pankaj T. on 21-05-2021 for getting actual client ip in case of load balancer - start
					String chgIP = request.getHeader("X-Forwarded-For");
					if(chgIP == null)
					{  
						chgIP = request.getRemoteAddr();
					}
					//Changed By Pankaj T. on 21-05-2021 for getting actual client ip in case of load balancer - end
					String action1 = action;
					String chgStr = request.getParameter("CHG_STR"); //$NON-NLS-1$
					
					//Added by shrutika on 05-06-2020 [Start] for validation in case of extract template.
					String returnType = checkNull( request.getParameter("RTEURN_TYPE") );
					
					if( "json".equalsIgnoreCase(returnType) )
					{
						chgStr = currentDomIdData(chgStr, objContext, domId, objName, editFlag);
					}
					//Added by shrutika on 05-06-2020 [Start] for validation in case of extract template.
					//Added By Pankaj T. on 16-03-20 for If the 1st error code is warning and 2nd error code is error, then system does not show warning and shows only error message - start
					E12GenericUtility genericutility = new E12GenericUtility();
					if(forceSave != null && forceSave.equalsIgnoreCase("true"))
					{
						chgStr = genericutility.updateDataHeader(chgStr, forceSave, "forcedSave");
					}
					//Added By Pankaj T. on 16-03-20 for If the 1st error code is warning and 2nd error code is error, then system does not show warning and shows only error message - end
					String argFieldValues = request.getParameter("ARG_VALUES"); //$NON-NLS-1$
					String reqParamStr = request.getParameter("REQ_PARAM_STR"); //$NON-NLS-1$
					BaseLogger.log("3", userInfo,editorId,"Inside E12EditorHandlerServlet FORM_NO["+FORM_NO+"] objContext["+objContext+"] editFlag["+editFlag+"]");
					BaseLogger.log("3", userInfo,editorId,"Inside E12EditorHandlerServlet CHG_STR["+( request.getParameter("CHG_STR"))+"]");
					
					if("A".equalsIgnoreCase(editFlag))
					{
						action1 = "ADD";
					}
					else if("V".equalsIgnoreCase(editFlag))
					{
						action1 = "VIEW";
					}
					else
					{
						action1 = "EDIT";
					}
					if("EDIT".equalsIgnoreCase(action1) && (pkValues == null || pkValues.trim().length() == 0))
					{
						action1  = "ADD";
					}
					if( "E".equals( editFlag ) )  //$NON-NLS-1$
					{
						/*String tempEditorID = editorId;
					if( editorId != null &&  editorId.indexOf(userId) != -1)
					{
						tempEditorID = editorId.substring(0,editorId.indexOf(userId));
					}
					startTime = new Date();*/
					}
					/*String tempEditorID = editorId;
				if( editorId != null &&  editorId.indexOf(userId) != -1)
				{
					tempEditorID = editorId.substring(0,editorId.indexOf(userId));
				}*/

					if( pkValues != null && pkValues.trim().length() > 0 && ( ! pkValues.equalsIgnoreCase("null") ) && ( "A".equalsIgnoreCase( editFlag ) )  && ( Integer.parseInt( objContext ) == 1 ) ) //$NON-NLS-1$ //$NON-NLS-2$
					{
						startTime = new Date();
						responseStr = setActionForDuplicateTransaction(objName, objContext, pkValues , sess , editorId, userId ,editor);
					}
					else
					{
						startTime = new Date();
						//responseStr = getXMLDataForDetail( objName, objContext, editFlag, pkValues, chgStr, argFieldValues, sess, editorId, reqParamStr, userId, action);
						responseStr = getXMLDataOnDelete( objName, objContext, editFlag, pkValues, chgStr, argFieldValues, sess, editorId, reqParamStr, userId, action, domId);
						//					BaseLogger.log("3", userInfo,editorId,"response from getXMLDataForDetail responseStr["+responseStr+"]");
					}
					String event = "get_detail_data";
					if ( objContext != null && !"null".equalsIgnoreCase( objContext )  )
					{
						if ( pkValues !=null && !"null".equalsIgnoreCase( pkValues ) && pkValues.trim().length() > 0 && !"1".equals( objContext ) )
						{
							if ( "A".equalsIgnoreCase( editFlag ) )
							{
								event = "ADD";
							}
							action1 = "EDIT";
						}
						else if ( !"1".equals( objContext ) ) 
						{
							if("A".equalsIgnoreCase(editFlag))
							{
								event = "ADD";
							}
							action1 = "ADD";
						}
					}
					/*if( userEventLogEJB != null && userInfo != null )
				{
					userEventLogEJB.setEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorID, action1 , event, new Date(), new Date(),"pkValues:[" + pkValues + "], objContext:[" + objContext + "], ", pkValues);
				}
				else
				{
					BaseLogger.log("3", userInfo,editorId," ============ User info is null then never create event log in doPost() method of RequestHandlerServlet.java file, action is 'XML_DATA_DETAIL' ");
				}*/

					org.w3c.dom.Document currentDetailNode = new E12GenericUtility().parseString(responseStr);
					int totalDetailNodes = currentDetailNode.getElementsByTagName("Detail" + FORM_NO).getLength();
					BaseLogger.log("3", userInfo,editorId,"Inside E12EditorHandlerServlet Action [ADD_DETAIL_DOM] totalDetailNodes["+totalDetailNodes+"]");
					//Added by Shrutika on 26-01-18 [Start] for display multiple message with different type if present on done click.
					NodeList errorNodeList = null;
					int errorNodeListLen = 0;
					//Commented By Pankaj T. on 16-03-20 for If the 1st error code is warning and 2nd error code is error, then system does not show warning and shows only error message
					//E12GenericUtility genericutility = new E12GenericUtility();
					if (responseStr != null && responseStr.length() > 0)
					{
						errorNodeList = genericutility.parseString( responseStr ).getElementsByTagName("error");
					}
					if(errorNodeList != null)
					{
						errorNodeListLen = errorNodeList.getLength();
					}
					//Added by Shrutika on 26-01-18 [End] for display multiple message with different type if present on done click.
					String finalRespStr = "";
					//Changed by Sandeep on 14-APR-16 [[S15LSUN004] New interface for Wizard and Editor] Start
					if( totalDetailNodes > 0)
					{	
						for( int i = 0 ; i < totalDetailNodes ; i++ )
						{	
							if( currentDetailNode.getElementsByTagName("Detail" + FORM_NO).item(i) != null )
							{
								responseStr = new E12GenericUtility().serializeDom( (Node) currentDetailNode.getElementsByTagName("Detail" + FORM_NO).item(i) );
								//change by shrutika on 17-05-18 for detail screen related issue.
								BaseLogger.log("3", userInfo,editorId,"errorNodeListLen...1610["+errorNodeListLen+"]");
								if( errorNodeListLen == 0)
								{
									finalRespStr = finalRespStr + responseStr;
								}
							}
						}
					}
					//Added for loop by Shrutika on 26-01-18 [Start] for display multiple message with different type if present on Done Click.
					String detailXmlString ="";
					boolean isError = true;
					for ( int j = 0; j < errorNodeListLen; j++)
					{
						if( currentDetailNode.getElementsByTagName("error").item(j) != null )
						{
							Node errorNode = currentDetailNode.getElementsByTagName("error").item(j);
							Node typeNode = errorNode.getAttributes().getNamedItem("type");
							String typeNodeValue = typeNode.getNodeValue();
							//Added by Shrutika on 19-09-18 for pass column name to set focus in case of custom warning.
							Node columnNode  = errorNode.getAttributes().getNamedItem("column_name");
							String columnVlaue ="";
							if( columnNode != null)
							{
								columnVlaue = columnNode.getNodeValue();
							}
							BaseLogger.log("3", userInfo,editorId,"InE12EditorHandlerServlet typeNodeValue..1595["+typeNodeValue+"] columnVlaue["+columnVlaue+"]");
							//Commented By Pankaj T. on 16-03-20 for If the 1st error code is warning and 2nd error code is error, then system does not show warning and shows only error message - start
							//if( !"P".equalsIgnoreCase(typeNodeValue) && !"W".equalsIgnoreCase(typeNodeValue) )
							{
								finalRespStr =  finalRespStr+ "<Errors>" +new E12GenericUtility().serializeDom( (Node) currentDetailNode.getElementsByTagName( "error" ).item(j) ) +"</Errors>";
								isError =true;
							}
							/*else
							{
								isError = false;
								//change by shrutika on 17-05-18 for display all messages on Done click.
								//finalRespStr = finalRespStr + "<Message type=\""+typeNodeValue+ "\">";
								//Change by Shrutika on 19-09-18 for pass column name to set focus in case of custom warning.
								finalRespStr = finalRespStr + "<Message type=\""+typeNodeValue+ "\" column_name=\""+columnVlaue+"\">";
								finalRespStr = finalRespStr + new E12GenericUtility().serializeDom( (Node) currentDetailNode.getElementsByTagName( "message" ).item(j) );
								//Added by Pratheek on 29-08-18[to show description in prompt ]-Start
								if( currentDetailNode.getElementsByTagName( "description" ).item(j) != null )
								{
									finalRespStr = finalRespStr + new E12GenericUtility().serializeDom( (Node) currentDetailNode.getElementsByTagName( "description" ).item(j) );
								}
								//Added by Pratheek on 29-08-18[to show description in prompt ]-End
								finalRespStr = finalRespStr + "</Message>";
							}*/
							//Commented By Pankaj T. on 16-03-20 for If the 1st error code is warning and 2nd error code is error, then system does not show warning and shows only error message - end
							//finalRespStr = new E12GenericUtility().serializeDom( (Node) currentDetailNode.getElementsByTagName( "Errors" ).item(0) );
						}
					}
					//change by shrutika on 17-05-18 [start] for detail screen related issue.
					if( !isError )
					{
						detailXmlString = getDetailData(objName, objContext, editFlag, pkValues, chgStr, argFieldValues, sess, editorId, reqParamStr, userId, action, domId);
						org.w3c.dom.Document allDetailNode = new E12GenericUtility().parseString(detailXmlString);
						detailXmlString = "";
						int detailNodes = allDetailNode.getElementsByTagName("Detail" + FORM_NO).getLength();
						if( detailNodes > 0)
						{	
							for( int i = 0 ; i < detailNodes ; i++ )
							{	
								if( allDetailNode.getElementsByTagName("Detail" + FORM_NO).item(i) != null )
								{
									//singleDetailString = new E12GenericUtility().serializeDom( (Node) allDetailNode.getElementsByTagName("Detail" + FORM_NO).item(i) );
									//Change by Shrutika on 07-03-18 [Start] for add all detail feed and display all detail feed on freeform.
									String singleDetailString = "";
									singleDetailString = new E12GenericUtility().serializeDom( (Node) allDetailNode.getElementsByTagName("Detail" + FORM_NO).item(i) );
									detailXmlString = detailXmlString + singleDetailString;
									//Change by Shrutika on 07-03-18 [End] for add all detail feed and display all detail feed on freeform.
								}
							}
						}
					}
					//change by shrutika on 17-05-18 [End] for detail screen related issue.
					//Added for loop by Shrutika on 26-01-18 [End] for display multiple message with different type if present on Done click
					//detailXmlString = detailXmlString + singleDetailString;
					finalRespStr = finalRespStr + detailXmlString;
					//Change by shrutika on 05-06-2020 [Start] for validation in case of extract template.
					//responseStr = "<?xml version='1.0'?><Root><Header><editFlag>null</editFlag></Header><Errors></Errors>" + finalRespStr + "</Root>";
					if( "json".equalsIgnoreCase(returnType) )
					{
						responseStr = finalRespStr ;
					}
					else
					{
						responseStr = "<?xml version='1.0'?><Root><Header><editFlag>null</editFlag></Header><Errors></Errors>" + finalRespStr + "</Root>";
					}
					BaseLogger.log("3", userInfo,editorId,"responseStr........2183["+responseStr+"]");
					if( "json".equalsIgnoreCase(returnType) && currentDetailNode != null && currentDetailNode.getElementsByTagName("Errors").item(0) == null )
					{
						if ( responseStr == null || ( responseStr != null && responseStr.startsWith( "<?xml" ) ) )
						{
							responseStr = "<Root>" + responseStr + "</Root>";
						}
			            JSONObject jsonObject  = XML.toJSONObject(responseStr);
			            responseStr = jsonObject.toString();
					}
					//Change by shrutika on 05-06-2020 [Start] for validation in case of extract template.
					response.setContentType( "text/plain; charset="+CommonConstants.ENCODING );
					response.setHeader("Cache-Control", "no-cache");
					response.getWriter().write( responseStr );
				}
				else if( action.equalsIgnoreCase( "PREVIOUS") )
				{
					String responseStr = "";
					Date startTime = new Date();
					String objContext = ( request.getParameter("OBJ_CTX")); //$NON-NLS-1$
					String editFlag = ( request.getParameter("EDIT_FLAG")); //$NON-NLS-1$
					String pkValues =  ( request.getParameter("PK_VALUES")); //$NON-NLS-1$
					String editorId =  ( request.getParameter("EDITOR_ID")); //$NON-NLS-1$
					String FORM_NO = ( request.getParameter("FORM_NO")); 
					//Added by Prasad on 18/05/16 [As per Danish Sir, Editor option added for Property Editor] START
					String editor = checkNull( request.getParameter("EDITOR") );
					String domId = checkNull( request.getParameter("DOM_ID") );
					if ( editor.length() == 0 )
					{
						editor = "MobEditor";
					}
					BaseLogger.log("3", userInfo,editorId,"EDITOR - ["+ editor +"]");
					//Added by Prasad on 18/05/16 [As per Danish Sir, Editor option added for Property Editor] END
					String userId = userInfo.getLoginCode();
					editorId = editorId + userId; 
					//String terminal = request.getRemoteAddr();
					//Changed By Pankaj T. on 21-05-2021 for getting actual client ip in case of load balancer - start
					String chgIP = request.getHeader("X-Forwarded-For");
					if(chgIP == null)
					{  
						chgIP = request.getRemoteAddr();
					}
					//Changed By Pankaj T. on 21-05-2021 for getting actual client ip in case of load balancer - end
					String action1 = action;
					BaseLogger.log("3", userInfo,editorId,"Inside E12EditorHandlerServlet FORM_NO["+FORM_NO+"] objContext["+objContext+"] editFlag["+editFlag+"]");
					if("A".equalsIgnoreCase(editFlag))
					{
						action1 = "ADD";
					}
					else if("V".equalsIgnoreCase(editFlag))
					{
						action1 = "VIEW";
					}
					else
					{
						action1 = "EDIT";
					}
					if("EDIT".equalsIgnoreCase(action1) && (pkValues == null || pkValues.trim().length() == 0))
					{
						action1  = "ADD";
					}
					if( "E".equals( editFlag ) )  //$NON-NLS-1$
					{
						/*String tempEditorID = editorId;
					if( editorId != null &&  editorId.indexOf(userId) != -1)
					{
						tempEditorID = editorId.substring(0,editorId.indexOf(userId));
					}
					startTime = new Date();*/
					}
					/*String tempEditorID = editorId;
				if( editorId != null &&  editorId.indexOf(userId) != -1)
				{
					tempEditorID = editorId.substring(0,editorId.indexOf(userId));
				}*/
					String tempEditorID = getStatefulEditorId( editorId, userId );
					//Added by shrutika on 03-12-18 [Start] for updateEventLog.
					String event = "get_detail_data";
					if( userEventLogEJB != null && userInfo != null )
					{
						//Change by shrutika on 05-01-19 for add exception.
						userEventLogEJB.setEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorID, action1 , event,  startTime, null ,"pkValues:[" + pkValues + "], objContext:[" + objContext + "], ", pkValues,"Pending","SA","");
					}

					//Added by shrutika on 25-12-18 [Start] for update status as Exception.
					tempstartTime = startTime;
					tempObjName = objName;
					tempevent = event;
					temppkValues = pkValues;
					tempformNo = objContext;
					tempfieldName = fieldName;
					tempactionMode = action1;
					editorID = tempEditorID;
					//Added by shrutika on 25-12-18 [End] for update status as Exception.

					//Added by shrutika on 03-12-18 [End] for updateEventLog.
					if( pkValues != null && pkValues.trim().length() > 0 && ( ! pkValues.equalsIgnoreCase("null") ) && ( "A".equalsIgnoreCase( editFlag ) )  && ( Integer.parseInt( objContext ) == 1 ) ) //$NON-NLS-1$ //$NON-NLS-2$
					{
						startTime = new Date();
						//Changed by Prasad on 18/05/16 [As per Danish Sir, Editor option added for Property Editor] START
						//responseStr = setActionForDuplicateTransaction(objName, objContext, pkValues , sess , editorId, userId);
						responseStr = setActionForDuplicateTransaction(objName, objContext, pkValues , sess , editorId, userId, editor);
						//Changed by Prasad on 18/05/16 [As per Danish Sir, Editor option added for Property Editor] END
					}
					else
					{
						startTime = new Date();
						String chgStr = request.getParameter("CHG_STR"); //$NON-NLS-1$
						//Added by shrutika on 26-04-18 [Start] for update forcedSave flag in change xml string.
						E12GenericUtility genericutility = new E12GenericUtility();
						if(forceSave != null && forceSave.equalsIgnoreCase("true"))
						{
							chgStr = genericutility.updateDataHeader(chgStr, forceSave, "forcedSave");
						}
						//Added by shrutika on 26-04-18 [End] for update forcedSave flag in change xml string.
						String argFieldValues = request.getParameter("ARG_VALUES"); //$NON-NLS-1$
						String reqParamStr = request.getParameter("REQ_PARAM_STR"); //$NON-NLS-1$
						responseStr = getXMLDataOnPrevious( objName, objContext, editFlag, pkValues, chgStr, argFieldValues, sess, editorId, reqParamStr, userId, action, domId);
						BaseLogger.log("3", userInfo,editorId,"response from getXMLDataOnPrevious responseStr["+responseStr+"]");
					}
					//String event = "get_detail_data";
					if ( objContext != null && !"null".equalsIgnoreCase( objContext )  )
					{
						if ( pkValues !=null && !"null".equalsIgnoreCase( pkValues ) && pkValues.trim().length() > 0 && !"1".equals( objContext ) )
						{
							if ( "A".equalsIgnoreCase( editFlag ) )
							{
								event = "ADD";
							}
							action1 = "EDIT";
						}
						else if ( !"1".equals( objContext ) ) 
						{
							if("A".equalsIgnoreCase(editFlag))
							{
								event = "ADD";
							}
							action1 = "ADD";
						}
					}
					if( userEventLogEJB != null && userInfo != null )
					{
						//Added by shrutika on 03-12-18 for updateEventLog.
						//userEventLogEJB.setEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorID, action1 , event, new Date(), new Date(),"pkValues:[" + pkValues + "], objContext:[" + objContext + "], ", pkValues);
						//Change by shrutika on 05-01-19 for add exception.
						userEventLogEJB.updateEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorID, action1 , event, startTime, new Date(),"pkValues:[" + pkValues + "], objContext:[" + objContext + "], ", pkValues,"Success","SA","");
					}
					else
					{
						BaseLogger.log("3", userInfo,editorId," ============ User info is null then never create event log in doPost() method of RequestHandlerServlet.java file, action is 'XML_DATA_DETAIL' ");
					}

					org.w3c.dom.Document currentDetailNode = new E12GenericUtility().parseString(responseStr);
					int totalDetailNodes = currentDetailNode.getElementsByTagName("Detail" + FORM_NO).getLength();
					BaseLogger.log("3", userInfo,editorId,"Inside E12EditorHandlerServlet Action [PREVIOUS] totalDetailNodes["+totalDetailNodes+"]");
					String finalRespStr = "";
					if( totalDetailNodes > 0)
					{	
						for( int i = 0 ; i < totalDetailNodes ; i++ )
						{	
							if( currentDetailNode.getElementsByTagName("Detail" + FORM_NO).item(i) != null )
							{
								responseStr = new E12GenericUtility().serializeDom( (Node) currentDetailNode.getElementsByTagName("Detail" + FORM_NO).item(i) );
								finalRespStr = finalRespStr + responseStr;
							}
						}
					}
					else if( currentDetailNode.getElementsByTagName("Errors").item(0) != null )
					{
						finalRespStr = new E12GenericUtility().serializeDom( (Node) currentDetailNode.getElementsByTagName( "Errors" ).item(0) );
					}
					responseStr = "<?xml version='1.0'?><Root><Header><editFlag>null</editFlag></Header><Errors></Errors>" + finalRespStr + "</Root>";
					BaseLogger.log("3", userInfo,editorId,"responseStr ["+responseStr+"]");

					response.setContentType( "text/plain; charset="+CommonConstants.ENCODING );
					response.setHeader("Cache-Control", "no-cache");
					response.getWriter().write( responseStr );
					isAddnlAct = true;
				}
				//Added by Sandeep S. on 2-11-16 [[S16EBAS019]To implement multiple layouts in Editor] Start
				else if( action.equalsIgnoreCase( "FIRST_CALL_BROWSER" ) )
				{
					String responseStr = "";
					Date startTime = new Date();
					String objContext = ( request.getParameter("OBJ_CTX")); //$NON-NLS-1$
					String editFlag = ( request.getParameter("EDIT_FLAG")); //$NON-NLS-1$
					String pkValues =  ( request.getParameter("PK_VALUES")); //$NON-NLS-1$
					String editorId =  ( request.getParameter("EDITOR_ID")); //$NON-NLS-1$
					String editor = checkNull( request.getParameter("EDITOR") );
					String coreMdlId =  ( request.getParameter("CORE_MDL_ID"));
					String tempNoOfForms =  ( request.getParameter("NO_OF_FORMS"));
					String defaulEditor = ( request.getParameter("DEFAULT_EDITOR"));
					int noOfForms = Integer.parseInt(tempNoOfForms);
					if ( editor.length() == 0 )
					{
						editor = "MobEditor";
					}
					BaseLogger.log("3", userInfo,editorId,"EDITOR - ["+ editor +"]");
					String userId = userInfo.getLoginCode();
					editorId = editorId + userId; 
					//String terminal = request.getRemoteAddr();
					//Changed By Pankaj T. on 21-05-2021 for getting actual client ip in case of load balancer - start
					String chgIP = request.getHeader("X-Forwarded-For");
					if(chgIP == null)
					{  
						chgIP = request.getRemoteAddr();
					}
					//Changed By Pankaj T. on 21-05-2021 for getting actual client ip in case of load balancer - end
					String action1 = action;
					if("A".equalsIgnoreCase(editFlag))
					{
						action1 = "ADD";
					}
					else if("V".equalsIgnoreCase(editFlag))
					{
						action1 = "VIEW";
					}
					else
					{
						action1 = "EDIT";
					}
					if("EDIT".equalsIgnoreCase(action1) && (pkValues == null || pkValues.trim().length() == 0))
					{
						action1  = "ADD";
					}
					if( "E".equals( editFlag ) )  //$NON-NLS-1$
					{
						/*String tempEditorID = editorId;
						if( editorId != null &&  editorId.indexOf(userId) != -1)
						{
							tempEditorID = editorId.substring(0,editorId.indexOf(userId));
						}
						startTime = new Date();*/
					}
					/*String tempEditorID = editorId;
					if( editorId != null &&  editorId.indexOf(userId) != -1)
					{
						tempEditorID = editorId.substring(0,editorId.indexOf(userId));
					}*/
					String tempEditorID = getStatefulEditorId( editorId, userId );
					//Added by shrutika on 03-12-18 [Start] for updateEventLog.
					String event = "get_detail_data";
					if( userEventLogEJB != null && userInfo != null )
					{
						//Change by shrutika on 05-01-19 for add exception.
						userEventLogEJB.setEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorID, action1 , event, startTime, null ,"pkValues:[" + pkValues + "], objContext:[" + objContext + "], ", pkValues,"Pending","SA","");
					}
					//Added by shrutika on 03-12-18 [end] for updateEventLog.
					
					//Added by Prasad on 16/10/19 [To set plan date for Editor in GWT Calendar]Start
					plan_Date =	( request.getParameter( "PLAN_DATE"  )!= null )?request.getParameter( "PLAN_DATE"  ):"";
					Cal_Comp =	( request.getParameter( "CALENDAR_COMP"  )!= null )?request.getParameter( "CALENDAR_COMP"  ):"";
					BaseLogger.log( "3", userInfo, editorId, "FIRST_CALL_BROWSER ** plan_Date ["+plan_Date+"] Cal_Comp ["+Cal_Comp+"]" );
					//Added by Prasad on 16/10/19 [To set plan date for Editor in GWT Calendar]End

					//Added by Ravindra on 06/09/2021 [restore transaction related point] START
					if( infinispanLocalObj != null )
					{
						try 
						{
							JSONArray objTransactionJsonArr = null;
							if ( infinispanLocalObj.containsStatefulDataCache( userId ) )
							{
								objTransactionJsonArr = infinispanLocalObj.getStatefulDataCache( userId );
							}
							BaseLogger.log( "2", userInfo, editorId, "objTransactionJsonArr : ["+ objTransactionJsonArr +"]" );
							if ( objTransactionJsonArr != null )
							{
								int removeIndex = -1;
								for( int idx = 0; idx < objTransactionJsonArr.length(); idx++ )
								{
									JSONObject objTransactionJson = objTransactionJsonArr.getJSONObject( idx );
									BaseLogger.log( "2", userInfo, editorId, "objTransactionJson : ["+ objTransactionJson +"]" );
									if( objTransactionJson != null )
									{
										String objDataCache = "";
										if ( objTransactionJson.has( objName +"_SEP_"+ editorId ) )
										{
											BaseLogger.log( "2", userInfo, editorId, "In editorId condition" );
											removeIndex = idx;
											objDataCache = checkNull( E12GenericUtility.getJSONValue( objTransactionJson, (objName +"_SEP_"+ editorId) ) );
										}
										else if ( objTransactionJson.has( objName +"_SEP_"+ editorID ) )
										{
											BaseLogger.log( "2", userInfo, editorId, "In editorID condition" );
											removeIndex = idx;
											objDataCache = checkNull( E12GenericUtility.getJSONValue( objTransactionJson, (objName +"_SEP_"+ editorID) ) );
										}
										BaseLogger.log( "2", userInfo, editorId, "objDataCache : ["+ objDataCache +"]" );
										BaseLogger.log( "2", userInfo, editorId, "" );
										if( objDataCache.length() > 0 )
										{
											editFlag = E12GenericUtility.getJSONValue( objTransactionJson, "EDIT_FLAG" );
											pkValues = E12GenericUtility.getJSONValue( objTransactionJson, "PK_VALUES" );
											editorId = E12GenericUtility.getJSONValue( objTransactionJson, "EDITOR_ID" );
											if( editorId.indexOf( userId ) == -1 )
											{
												editorId = editorId + userId;
											}
											BaseLogger.log( "2", userInfo, editorId, "editFlag : ["+ editFlag +"], pkValues : ["+ pkValues +"], editorId : ["+ editorId +"]" );
											
											responseStr = objDataCache;
											break;
										}
									}
								}
								if( removeIndex != -1 )
								{
									objTransactionJsonArr.remove( removeIndex );
									BaseLogger.log( "2", userInfo, editorId, "After delete objTransactionJsonArr : ["+ objTransactionJsonArr +"]" );
									infinispanLocalObj.setStatefulDataCache( userId, objTransactionJsonArr );
								}
							}
						}
						catch (Exception e) 
						{
							BaseLogger.log( "0", userInfo, editorId, "Exception in infinispanLocalObj.getStatefulDataCache : ["+ e.getMessage() +"]" );
							e.printStackTrace();
						}
					}
					//Added by Ravindra on 06/09/2021 [restore transaction related point] END
					
					responseStr = checkNull( responseStr );
					BaseLogger.log( "2", userInfo, editorId, "responseStr : ["+ responseStr +"]" );
					
					//Added by shrutika on 25-12-18 [Start] for update status as Exception.
					tempstartTime = startTime;
					tempObjName = objName;
					tempevent = event;
					temppkValues = pkValues;
					tempformNo = objContext;
					tempfieldName = fieldName;
					tempactionMode = action1;
					editorID = tempEditorID;
					//Added by shrutika on 25-12-18 [End] for update status as Exception.
					
					if ( responseStr.length() == 0 )
					{
						if( pkValues != null && pkValues.trim().length() > 0 && ( ! pkValues.equalsIgnoreCase("null") ) && ( "A".equalsIgnoreCase( editFlag ) )  && ( Integer.parseInt( objContext ) == 1 ) ) //$NON-NLS-1$ //$NON-NLS-2$
						{
							//startTime = new Date();
							//Changed by Prasad on 18/05/16 [As per Danish Sir, Editor option added for Property Editor] START
							//responseStr = setActionForDuplicateTransaction(objName, objContext, pkValues , sess , editorId, userId);
							responseStr = setActionForDuplicateTransaction(objName, objContext, pkValues , sess , editorId, userId, editor);
						}
						else
						{
							//startTime = new Date();
							String chgStr = request.getParameter("CHG_STR"); //$NON-NLS-1$
							String argFieldValues = request.getParameter("ARG_VALUES"); //$NON-NLS-1$
							String reqParamStr = request.getParameter("REQ_PARAM_STR"); //$NON-NLS-1$
							//responseStr = getXMLDataForDetail( objName, objContext, editFlag, pkValues, chgStr, argFieldValues, sess, editorId, reqParamStr, userId, editor );
							//change by shrutika on 28-01-19 for multiple activities are not update due to global userinfo.
							//responseStr = getDetailDataForBrowser(objName, objContext, editFlag, pkValues, chgStr, argFieldValues, sess, coreMdlId, reqParamStr, userId, action1, "1", noOfForms, request, editorId, defaulEditor);
							responseStr = getDetailDataForBrowser(objName, objContext, editFlag, pkValues, chgStr, argFieldValues, sess, coreMdlId, reqParamStr, userId, action1, "1", noOfForms, request, editorId, defaulEditor,userInfo);

							//BaseLogger.log("3", userInfo,editorId,"response from getXMLDataForDetail responseStr["+responseStr+"]");
						}
					}
					else
					{
						String argFieldValues = request.getParameter("ARG_VALUES");
						String reqParamStr = request.getParameter("REQ_PARAM_STR");
						responseStr = getDetailDataForBrowser(objName, objContext, editFlag, pkValues, responseStr, argFieldValues, sess, coreMdlId, reqParamStr, userId, action1, "1", noOfForms, request, editorId, defaulEditor, userInfo);
					}

					//String event = "get_detail_data";
					if ( objContext != null && !"null".equalsIgnoreCase( objContext )  )
					{
						if ( pkValues !=null && !"null".equalsIgnoreCase( pkValues ) && pkValues.trim().length() > 0 && !"1".equals( objContext ) )
						{
							if ( "A".equalsIgnoreCase( editFlag ) )
							{
								event = "ADD";
							}
							action1 = "EDIT";
						}
						else if ( !"1".equals( objContext ) ) 
						{
							if("A".equalsIgnoreCase(editFlag))
							{
								event = "ADD";
							}
							action1 = "ADD";
						}
					}
					if( userEventLogEJB != null && userInfo != null )
					{
						//Added by shrutika on 03-12-18 [Start] for updateEventLog.
						//userEventLogEJB.setEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorID, action1 , event, new Date(), new Date(),"pkValues:[" + pkValues + "], objContext:[" + objContext + "], ", pkValues);
						//Change by shrutika on 05-01-19 for add exception.
						userEventLogEJB.updateEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorID, action1 , event, startTime, new Date(),"pkValues:[" + pkValues + "], objContext:[" + objContext + "], ", pkValues,"Success","SA","");
					}
					else
					{
						BaseLogger.log("3", userInfo,editorId," ============ User info is null then never create event log in doPost() method of RequestHandlerServlet.java file, action is 'XML_DATA_DETAIL' ");
					}

					//org.w3c.dom.Document currentDetailNode = new E12GenericUtility().parseString(responseStr);
					//Changed by Sandeep on 28-JUN-16 [[S15LSUN004] New interface for Wizard and Editor] Start
					/*if( currentDetailNode.getElementsByTagName("Detail1").item(0) != null )
					{
						responseStr = new E12GenericUtility().serializeDom( (Node) currentDetailNode.getElementsByTagName("Detail1").item(0) );
					}*/
					//Changed by Sandeep on 14-APR-16 [[S15LSUN004] New interface for Wizard and Editor] End
					//Added By Ajinkya G on 31-May-17 [for issue while copy tranasction detail data not copied on switch]
					
					//Added by shrutika on 19-05-2020 [Strat] for extract template option.
					String returnType =  E12GenericUtility.checkNull( request.getParameter("RTEURN_TYPE"));
					//if( !"E".equals( editFlag ) && !"true".equalsIgnoreCase(defaulEditor) && responseStr.indexOf("<?xml version") == -1)
					if( !"E".equals( editFlag ) && !"true".equalsIgnoreCase(defaulEditor) && responseStr.indexOf("<?xml version") == -1 && !"json".equalsIgnoreCase(returnType))
					{
						responseStr = "<?xml version='1.0'?><Root><Header><editFlag>null</editFlag></Header><Errors></Errors>" + responseStr + "</Root>";
					}
					BaseLogger.log("3", userInfo,editorId,"responseStr ["+responseStr+"]");
					org.w3c.dom.Document currentDetailNode = new E12GenericUtility().parseString(responseStr);
					if( "json".equalsIgnoreCase(returnType) && currentDetailNode != null && currentDetailNode.getElementsByTagName("Errors").item(0) == null )
					{
			            JSONObject jsonObject  = XML.toJSONObject(responseStr);
			            responseStr = jsonObject.toString();
					}
                    //Added by shrutika on 19-05-2020 [End] for extract template option.
                   
					response.setContentType( "text/plain; charset="+CommonConstants.ENCODING );
					response.setHeader("Cache-Control", "no-cache");
					response.getWriter().write( responseStr );
				}
				else if( action.equalsIgnoreCase( "SET_DATA" ) )
				{
					String coreMdlId = "";
					String xmlStr = "";
					String chgStr = "";
					String editFlag = "";
					String objContext = "";
					String domId = "";
					String isFormDirty = "";
					isFormDirty = checkNull( request.getParameter("isFormDirty") );
					coreMdlId = checkNull( request.getParameter("EDITOR_ID") );
					xmlStr = checkNull( request.getParameter("XML_STR"));
					chgStr = checkNull( request.getParameter("CHG_STR"));
					//Added by shrutika on 05-06-2020 [Start] for validation in case of extract template.
					editFlag = checkNull( request.getParameter("EDIT_FLAG"));
					objContext = checkNull( request.getParameter("OBJ_CONTEXT"));
					domId = checkNull( request.getParameter("DOM_ID"));
					//Added by shrutika on 05-06-2020 [End] for validation in case of extract template.
					//Added By Pankaj T. on 16-03-20 for If the 1st error code is warning and 2nd error code is error, then system does not show warning and shows only error message - start
					E12GenericUtility genericutility = new E12GenericUtility();
					
					//Added by shrutika on 05-06-2020 [Start] for validation in case of extract template.
					if( "".equalsIgnoreCase(chgStr) )
					{
						chgStr = currentDomIdData(xmlStr, objContext, domId, objName, editFlag);
					}
					//Added by shrutika on 05-06-2020 [End] for validation in case of extract template.
					if(forceSave != null && forceSave.equalsIgnoreCase("true"))
					{
						chgStr = genericutility.updateDataHeader(chgStr, forceSave, "forcedSave");
					}
					//Added By Pankaj T. on 16-03-20 for If the 1st error code is warning and 2nd error code is error, then system does not show warning and shows only error message - end
				
					String userId = userInfo.getLoginCode();
					String editorId = coreMdlId + userId;
					String responseStr = "";
					responseStr = setData(objName, editorId, sess, userId, coreMdlId, xmlStr, chgStr, editFlag, objContext, domId, isFormDirty);
					BaseLogger.log("3", userInfo,editorId,"responseStr ["+responseStr+"]");

					org.w3c.dom.Document currentDetailNode = new E12GenericUtility().parseString(responseStr);
					String finalRespStr = "";
					if( currentDetailNode != null )
					{
						if( currentDetailNode.getElementsByTagName("Errors").item(0) != null )
						{
							Node errorNode = currentDetailNode.getElementsByTagName("error").item(0);
							Node typeNode = errorNode.getAttributes().getNamedItem("type");
							String typeNodeValue = typeNode.getNodeValue();
							BaseLogger.log("3", userInfo,editorId,"InE12EditorHandlerServlet typeNodeValue["+typeNodeValue+"]");
							//Commented By Pankaj T. on 16-03-20 for If the 1st error code is warning and 2nd error code is error, then system does not show warning and shows only error message - start
							//if( !"P".equalsIgnoreCase(typeNodeValue) && !"W".equalsIgnoreCase(typeNodeValue) )
							{
								finalRespStr = new E12GenericUtility().serializeDom( (Node) currentDetailNode.getElementsByTagName( "Errors" ).item(0) );
							}
							/*else
							{
								//finalRespStr = new E12GenericUtility().serializeDom( (Node) currentDetailNode.getElementsByTagName( "message" ).item(0) );
								finalRespStr = "<Message type=\""+typeNodeValue+ "\">";
								finalRespStr = finalRespStr + new E12GenericUtility().serializeDom( (Node) currentDetailNode.getElementsByTagName( "message" ).item(0) );
								if( currentDetailNode.getElementsByTagName( "description" ).item(0) != null )
								{
									finalRespStr = finalRespStr + new E12GenericUtility().serializeDom( (Node) currentDetailNode.getElementsByTagName( "description" ).item(0) );
								}
								finalRespStr = finalRespStr + "</Message>";
							}*/
							//Commented By Pankaj T. on 16-03-20 for If the 1st error code is warning and 2nd error code is error, then system does not show warning and shows only error message - end
							responseStr = finalRespStr;
						}
					}

					response.setContentType( "text/plain; charset="+CommonConstants.ENCODING );
					response.setHeader("Cache-Control", "no-cache");
					response.getWriter().write( responseStr );
				}
				//Added by Sandeep S. on 2-11-16 [[S16EBAS019]To implement multiple layouts in Editor]End
				
				//Added by shrutika on 18-05-18 [Start] for clearCache with particular type
				else if( action.equalsIgnoreCase( "CLEARCACHE" ) )
				{
					String responseStr ="",finalRespStr="";
					String type = checkNull( request.getParameter("TYPE") );
					InfinispanLocal infinispanLocalObj = ((InfinispanLocal)ctx.lookup("ibase/InfinispanEJB/local"));
					boolean isError = infinispanLocalObj.clearCacheWithtype(type);
					BaseLogger.log("3", userInfo,null,"inside E12editorhandlaer servlet.....1997["+isError+"]");
					if( !isError )
					{
						String msgtype = "P";
						String id = "ClearCacheid";
						finalRespStr = "<Errors>" + "\n";
						finalRespStr = finalRespStr + "<error  type=" + '"' + msgtype + '"'+ " id=" + '"' + id + '"'+ ">" + "\n";
						//finalRespStr = finalRespStr + "<message><![CDATA[Clear Cache Successfully]]></message>" + "\n";
						finalRespStr = finalRespStr + "<message><![CDATA[Cleared Infinispan Cache.]]></message>" + "\n";
						//Added by shrutika on 22-05-18 for display description in prompt.
						finalRespStr = finalRespStr + "<description><![CDATA[Cleared " +type+ " Infinispan Cache Successfully.]]></description>" + "\n";
						finalRespStr = finalRespStr + "</error>";
						finalRespStr = finalRespStr + "</Errors>";
						responseStr = "<?xml version='1.0'?><Root><Header><editFlag>null</editFlag></Header>" + finalRespStr + "</Root>";
					}
					response.setContentType( "text/plain; charset="+CommonConstants.ENCODING );
					response.setHeader("Cache-Control", "no-cache");
					response.getWriter().write( responseStr );
				}
				//Added by shrutika on 18-05-18 [Start] for clearCache with particular type
				//Added by shrutika on 03-08-18 [start] for getting tab orderwise xml.
				else if( action.equalsIgnoreCase( "GET_TABORDER_DATA" ) )
				{
					StringBuilder tabOrderFields = new StringBuilder();
					String responseStr = "",seprator =",";
					BaseLogger.log("3", userInfo,null,"inside get tab order wise map...2042 objName["+objName+"]formNo["+formNo+"]");
					String metaDataFileName = objName + "2" + formNo;
					DWFactory dws = null;
					try
					{
						dws = new DWFactory(userInfo);
					} 
					catch (Exception e) 
					{
						e.printStackTrace();
					}
					DWObject dwObj = (DWObject)dws.getDataWindow(metaDataFileName);
					HashMap<String, String> tabOrderWiseLogicalNameMap = dwObj.getTabOrderWiseLogicalNameMap();
					for ( Map.Entry<String, String> entry : tabOrderWiseLogicalNameMap.entrySet() )
					{
						String nodeName = entry.getKey();
						tabOrderFields.append(nodeName);
						tabOrderFields.append(seprator);
					}
					responseStr = tabOrderFields.toString();
					response.setContentType( "text/plain; charset="+CommonConstants.ENCODING );
					response.setHeader("Cache-Control", "no-cache");
					response.getWriter().write( responseStr );
				}//added by vishal pathare on 17.08.18 for[Rest ibase home related changes in E12connection log]Start.
				else if( action.equalsIgnoreCase( "RESETIBASE" ) )
				{
					BaseLogger.log("3", userInfo,null,"ResetIBASE called");
					CommonConstants.TOMCAT_HOME = null;
					CommonConstants.setIBASEHOME();
					BaseLogger.log("3", userInfo,null,"ResetIBASEHome successfully");
					
					//Added by shrutika on 06-02-19 [Start] for display prompt after reset ibase home.
					String responseStr ="",finalRespStr="";
					String msgtype = "P";
					String id = "ResetIBASE";
					finalRespStr = "<Errors>" + "\n";
					finalRespStr = finalRespStr + "<error  type=" + '"' + msgtype + '"'+ " id=" + '"' + id + '"'+ ">" + "\n";
					finalRespStr = finalRespStr + "<message><![CDATA[Reset IBASEHome successfully.]]></message>" + "\n";
					finalRespStr = finalRespStr + "<description><![CDATA[Reset IBASEHome successfully.]]></description>" + "\n";
					finalRespStr = finalRespStr + "</error>";
					finalRespStr = finalRespStr + "</Errors>";
					responseStr = "<?xml version='1.0'?><Root><Header><editFlag>null</editFlag></Header>" + finalRespStr + "</Root>";
					response.setContentType( "text/plain; charset="+CommonConstants.ENCODING );
					response.setHeader("Cache-Control", "no-cache");
					response.getWriter().write( responseStr );
					//Added by shrutika on 06-02-19 [End] for display prompt after reset ibase home.
				}
				//Added by shrutika on 03-12-18 [Start] for display pending user activity
				else if(action.equals("GET_USER_ACTIVITY"))
				{
					String responseStr = "";
					String objectName = checkNull( request.getParameter("OBJ_NAME") );
					String user = checkNull( request.getParameter("USER") );
					String timeDiff = checkNull( request.getParameter("TIME_DIFF") );
					EventLogInfoBean eventInfoBean = null;
					if( userInfo != null )
					{
						String sessionId = userInfo.getSesstionId();
						if( userEventLogEJB != null)
						{
							responseStr = userEventLogEJB.userActivities( objectName, user, timeDiff );
						}
						//responseStr = eventInfoBean.getUserActivityLog();
						responseStr = "<?xml version='1.0'?><Root><Header><editFlag>null</editFlag></Header>" + responseStr + "</Root>";
					}
					response.setContentType( "text/plain; charset="+CommonConstants.ENCODING );
					response.setHeader("Cache-Control", "no-cache");
					//Added by shrutika on 17-01-18 [Start] for display exceptio.
					request.setAttribute("USERACTIVITY",responseStr );
					//request.getSession().setAttribute("USERACTIVITY", responseStr);
					request.getRequestDispatcher("/jsp/DisplayUserActivity.jsp").forward(request,response);
					//response.sendRedirect( response.encodeURL("/ibase/jsp/DisplayUserActivity?USERACTIVITY="+responseStr)); //$NON-NLS-1$
					//Added by shrutika on 17-01-18 [End] for display exceptio.
					response.getWriter().write( responseStr );

				}

				//Added by shrutika on 21-05-19 [Start] for draw tax related fields in tax screen.
				else if(action.equals("GET_TAXENV_DESCRIPTION"))
				{
					String responseStr = "";
					String tax_env = checkNull( request.getParameter("TAX_ENV") );
					if( userInfo != null )
					{
						DBAccessEJB dbAccessEjb = new DBAccessEJB();
						responseStr = dbAccessEjb.getDBColumnValue("TAXENV", "DESCR", "TAX_ENV = '"+tax_env+"'" , transDB);
					}
					response.setContentType( "text/plain; charset="+CommonConstants.ENCODING );
					response.setHeader("Cache-Control", "no-cache");
					response.getWriter().write( responseStr );
				}
				//Added by shrutika on 21-05-19 [End] for draw tax related fields in tax screen.
				//Added by shrutika on 03-12-18 [end] for display pending user activity
				//added by vishal pathare on 17.08.18 for[Rest ibase home related changes in E12connection log]End.
				//Added by shrutika on 03-08-18 [End] for getting tab orderwise xml.
				//Changes made by Pratheek on 05-03-2020[ to add the detail feed in second form when scanning the product from 1st form ]-Start
				else if( "POPULATE_ATTACHMENT_DATA".equalsIgnoreCase( action ) )
				{
					String xmlData = checkNull( request.getParameter("XML_DATA") );
					String editFlag = request.getParameter("EDIT_FLAG");
					String coreMdlId =  ( request.getParameter("CORE_MDL_ID"));
					String editorIDVal =  ( request.getParameter("EDITOR_ID"));
					String userID = userInfo.getLoginCode();
					editorIDVal = editorIDVal + userID;
					String responseStr = "";
					
					ITMTransactionCoreModel itmTransCoreMdl = (ITMTransactionCoreModel) sess.getAttribute(coreMdlId);
					BaseLogger.log("3", userInfo,null,"itmTransCoreMdl 2571!!!! ["+itmTransCoreMdl+"]");
					if( itmTransCoreMdl == null )
					{
						BaseLogger.log("3", userInfo,editorID,"ITMTransactionCoreModel can not get from sess 2573!!!!");
						itmTransCoreMdl = new ITMTransactionCoreModel();
						itmTransCoreMdl.setObjName(objName);
						itmTransCoreMdl.setUserInfo( userInfo );
						ITMTransactionHeaderModel itmTransHdrMdl = (ITMTransactionHeaderModel) sess.getAttribute( "itmTransHdrMdl" );
						if ( itmTransHdrMdl != null )
						{
							itmTransCoreMdl.setITMFilterModel( itmTransHdrMdl.getITMFilterModel() );
						}
						sess.setAttribute(coreMdlId, itmTransCoreMdl);
					}
					itmTransCoreMdl.getMasterStateful().setEditorId(""+editorIDVal);
		  			itmTransCoreMdl.setCoreModelId(Integer.parseInt(coreMdlId));
		  			itmTransCoreMdl.setEditFlag(editFlag);
		  			E12TransEditorCoreModel transEditorCoreModel = (E12TransEditorCoreModel) sess.getAttribute( editorIDVal );
		  			BaseLogger.log("3", userInfo,null,"transEditorCoreModel 2593!!!! ["+transEditorCoreModel+"]");
					if ( transEditorCoreModel == null )
					{
						transEditorCoreModel = new E12TransEditorCoreModel( objName );
						transEditorCoreModel.setUserInfo( userInfo );
						transEditorCoreModel.setMasterStateful( itmTransCoreMdl.getMasterStateful() );
						transEditorCoreModel.setObjName( objName );
						
						sess.setAttribute( editorID, transEditorCoreModel );
					}
					MasterStatefulRemote masterRem = transEditorCoreModel.getMasterStateful();
					//Changed by Prasad on 08/04/2020 [resolve error while accessing attachment from free form] START
					if ( xmlData != null && xmlData.length() > 0 )
					{
						responseStr = masterRem.populateAttachmentData(xmlData, editFlag);
					}
					//Changed by Prasad on 08/04/2020 [resolve error while accessing attachment from free form] END
					if ( responseStr.indexOf("<Errors>") == -1 )
					{
						if( !editFlag.equalsIgnoreCase("V"))
						{
							responseStr = masterRem.getDataXML( "2", "", "E", "1" );
						}
						else
						{
							responseStr = masterRem.getDataXML( "2", "", editFlag, "1" );
						}
					}
					BaseLogger.log("3", userInfo,null,"responseStr 2608!!!! ["+responseStr+"]");
					
					response.setContentType( "text/plain; charset="+CommonConstants.ENCODING );
					response.setHeader("Cache-Control", "no-cache");
					response.getWriter().write( responseStr );
				}
				//Changes made by Pratheek on 05-03-2020[ to add the detail feed in second form when scanning the product from 1st form ]-End
				
				//Added by shrutika on 13-04-2020 [Start] for display device information on image click on change detail field.
				else if( "DISPLAY_CHG_TERMDATA".equalsIgnoreCase( action ) )
				{
					String action1 = request.getParameter("ACTION");
					String loginId = request.getParameter("CHG_USER");
					String macAddr = request.getParameter("CHG_TERM");
					BaseLogger.log("3", userInfo,null,"inside DISPLAY_CHG_TERMDATA....");
					
					CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
					String deviceInfo = commonDBAccessEJB.getChgTermInfo(userInfo,loginId,macAddr);
					BaseLogger.log("3", userInfo,null,"inside DISPLAY_CHG_TERMDATA....deviceInfo["+deviceInfo+"]");
					String responseStr = deviceInfo;
					
					response.setContentType( "text/plain; charset="+CommonConstants.ENCODING );
					response.setHeader("Cache-Control", "no-cache");
					response.getWriter().write( responseStr );
				}
				//Added by shrutika on 13-04-2020 [End] for display device information on image click on change detail field.
				
				//Added by shrutika on 19-05-2020 [End] for extract template option.
				else if("SAVE_EXTRACT_TEMPLATE_DATA".equalsIgnoreCase( action ))
				{
					try
					{
						String xmlString = request.getParameter("XML_STR");
						String editorId = request.getParameter("EDITOR_ID");
						Connection conn = null;
						MasterApplyEJB ms = new MasterApplyEJB();
						MasterStatefulLocal masterStateful=null;
						AppConnectParm appConnect1 = new AppConnectParm();
						InitialContext ctx = new InitialContext(appConnect1.getProperty());
						masterStateful = (MasterStatefulLocal)ctx.lookup("ibase/MasterStatefulEJB/local");
						
						ms.setUserInfoBean(userInfo);
						masterStateful.setUserInfo( userInfo.toString(), xmlString );
						masterStateful.setEditorId(editorId);
						ms.setObjFormDetail(objName, userInfo);
						HashMap<String, String> transactionDetailMap = ms.getTransactionDetailForEdit( conn, xmlString, userInfo.toString() );
						if("Y".equalsIgnoreCase(transactionDetailMap.get("IS_RECORD_EXIST")))
						{
							xmlString = ms.updateXml( transactionDetailMap, xmlString );
						}
						String resultString = masterStateful.processRequest(userInfo, xmlString, true, conn);
						response.setContentType( "text/plain; charset="+CommonConstants.ENCODING );
						response.setHeader("Cache-Control", "no-cache");
						response.getWriter().write( resultString );
						
					}
					catch (Exception e) 
					{
						BaseLogger.log("0", userInfo,null,"Exception inside SAVE_EXTEXCT_TEMPLATE_DATA action [" + e.getMessage() + "]");
					}
				}
				//Added by shrutika on 19-05-2020 [End] for extract template option.
				
				//Added by shrutika on 05-06-2020 [Start] for validation in case of extract template.
				else if( "Pre_Validate".equals(action)  )
				{
					Node detailNode = null;
					try 
					{
						
						String editorId = E12GenericUtility.checkNull(request.getParameter("EDITOR_ID"));
						String xmlString = E12GenericUtility.checkNull(request.getParameter("XML_STR"));
						String objContext = E12GenericUtility.checkNull(request.getParameter("FORM_NO"));
						String domID = E12GenericUtility.checkNull(request.getParameter("DOM_ID"));
						objName = E12GenericUtility.checkNull(request.getParameter("OBJ_NAME"));
						String editFlag = E12GenericUtility.checkNull(request.getParameter("EDIT_FLAG"));
						
						String pkVlaue = E12GenericUtility.checkNull(request.getParameter("PK_VLAUES"));
						//Added by shrutika on 26-06-2020 for issue in case of warning occur.
						forceSave = E12GenericUtility.checkNull(request.getParameter("FORCESAVE"));
						if( "".equals(forceSave) )
						{
							forceSave = "false";
						}
						//Added by shrutika on 26-06-2020 for issue in case of warning occur.
						if( pkVlaue.endsWith(":") )
						{
							pkVlaue = pkVlaue.substring(0, (pkVlaue.length() - 1) );
						}
						
						ITMTransactionCoreModel itmTransCoreMdl = null;
						itmTransCoreMdl = ( ITMTransactionCoreModel )sess.getAttribute( editorId );
						BaseLogger.log("3",null,null,"itmTransCoreMdl;;;;;;:"+itmTransCoreMdl);
						if(itmTransCoreMdl == null)
						{
							itmTransCoreMdl = new ITMTransactionCoreModel();
							itmTransCoreMdl.setObjName(objName);
							itmTransCoreMdl.setUserInfo( userInfo );
							ITMTransactionHeaderModel itmTransHdrMdl = (ITMTransactionHeaderModel) sess.getAttribute( "itmTransHdrMdl" );
							if ( itmTransHdrMdl != null )
							{
								itmTransCoreMdl.setITMFilterModel( itmTransHdrMdl.getITMFilterModel() );
							}
							sess.setAttribute(editorId, itmTransCoreMdl);
						}
						
						itmTransCoreMdl.masterStateful.setEditorId(editorId);
						itmTransCoreMdl.masterStateful.setUserInfo(userInfo);
						itmTransCoreMdl.masterStateful.getContextTitlesList(objName, userInfo);
						itmTransCoreMdl.masterStateful.setEditFlag(editFlag);

						E12GenericUtility gn = new E12GenericUtility();
						detailNode = gn.searchNode( gn.parseString( xmlString ), objContext, domID);
						
						String currenFormStr = gn.serializeDom(detailNode);
						
						String chgStr = "<?xml version='1.0' encoding='UTF-8'?>" + 
								"<Root>" +
								"<header>"+
								"<objName><![CDATA["+objName+"]]></objName>"+
								"<pageContext><![CDATA[1]]></pageContext>"+
								"<objContext><![CDATA[1]]></objContext>"+
								"<editFlag><![CDATA["+editFlag+"]]></editFlag>"+
								"<focusedColumn><![CDATA[]]></focusedColumn>"+
								"<elementName><![CDATA[]]></elementName>" + 
								"<keyValue><![CDATA[1]]></keyValue>" + 
								" <taxKeyValue><![CDATA[]]></taxKeyValue>" + 
								"<saveLevel><![CDATA[0]]></saveLevel>" +
								//change by shrutika on 26-06-2020 for issue in case of warning occur.
								"<forcedSave><![CDATA["+forceSave+"]]></forcedSave>" +
								"<taxInFocus><![CDATA[false]]></taxInFocus>" + 
								"<forcedconfirm><![CDATA[false]]></forcedconfirm>" + 
								"<isSaveNConitinue><![CDATA[false]]></isSaveNConitinue>"+
								"</header>"+
								currenFormStr+
								"</Root>";
						
						String retString = (chgStr != null && chgStr.length() > 0)?itmTransCoreMdl.masterStateful.validateAndPerformAction( chgStr, "VAL_DATA" ):""; //$NON-NLS-1$
						BaseLogger.log("3",null,null,"inaside prevalidate "+retString+"]]]]]\n\n\n\n");
						String responseStr = retString;
						String returnType =  E12GenericUtility.checkNull( request.getParameter("RTEURN_TYPE"));
						org.w3c.dom.Document currentDetailNode = new E12GenericUtility().parseString(responseStr);
						if( "json".equalsIgnoreCase(returnType) && currentDetailNode != null && currentDetailNode.getElementsByTagName("Errors").item(0) == null )
						{
				            JSONObject jsonObject  = XML.toJSONObject(responseStr);
				            responseStr = jsonObject.toString();
						}
				
						response.setContentType( "text/plain; charset="+CommonConstants.ENCODING );
						response.setHeader("Cache-Control", "no-cache");
						response.getWriter().write( responseStr );	
						
						
					} catch (Exception e) {
						// TODO Auto-generated catch block
						BaseLogger.log("0", userInfo,null,"Exception inside preValidateAction action [" + e.getMessage() + "]");
						e.printStackTrace();
					}
				}
				//Added by shrutika on 05-06-2020 [End] for validation in case of extract template.
				
				//Added By Pankaj T. on 17-02-2021 - added new attributes in detail tag valdatastat, taxcalcstat & id for  checking current record is valid or not at the time of adding new detail - start
				else if( "GET_DETAIL_FORM_DATA".equals(action) )
				{
					String responseStr = "";
					String objContext = ( request.getParameter("OBJ_CTX"));
					String editFlag = ( request.getParameter("EDIT_FLAG"));
					String pkValues =  ( request.getParameter("PK_VALUES"));
					String editorId =  ( request.getParameter("EDITOR_ID"));
					String FORM_NO = ( request.getParameter("FORM_NO")); 
					String returnType = checkNull( request.getParameter("RTEURN_TYPE") );
					String userId = userInfo.getLoginCode();
					editorId = editorId + userId; 
					String detailXmlString = getDetailData(objName, objContext, editFlag, pkValues, null, null, sess, editorId, null, userId, action, null);
					BaseLogger.log("3", userInfo,editorId,"In GET_DETAIL_FORM_DATA action detailXmlString["+responseStr+"]");
					org.w3c.dom.Document allDetailNode = new E12GenericUtility().parseString(detailXmlString);
					detailXmlString = "";
					int detailNodes = allDetailNode.getElementsByTagName("Detail" + FORM_NO).getLength();
					if( detailNodes > 0)
					{	
						for( int i = 0 ; i < detailNodes ; i++ )
						{	
							if( allDetailNode.getElementsByTagName("Detail" + FORM_NO).item(i) != null )
							{
								String singleDetailString = "";
								singleDetailString = new E12GenericUtility().serializeDom( (Node) allDetailNode.getElementsByTagName("Detail" + FORM_NO).item(i) );
								detailXmlString = detailXmlString + singleDetailString;
							}
						}
					}
					if( "json".equalsIgnoreCase(returnType) )
					{
						responseStr = detailXmlString ;
					}
					else
					{
						responseStr = "<?xml version='1.0'?><Root><Header><editFlag>null</editFlag></Header><Errors></Errors>" + detailXmlString + "</Root>";
					}
					BaseLogger.log("3", userInfo,editorId,"In GET_DETAIL_FORM_DATA action responseStr........2183["+responseStr+"]");
					if( "json".equalsIgnoreCase(returnType) )
					{
						if ( responseStr == null || ( responseStr != null && responseStr.startsWith( "<?xml" ) ) )
						{
							responseStr = "<Root>" + responseStr + "</Root>";
						}
			            JSONObject jsonObject  = XML.toJSONObject(responseStr);
			            responseStr = jsonObject.toString();
					}
					response.setContentType( "text/plain; charset="+CommonConstants.ENCODING );
					response.setHeader("Cache-Control", "no-cache");
					response.getWriter().write( responseStr );
				}
				//Added By Pankaj T. on 17-02-2021 - added new attributes in detail tag valdatastat, taxcalcstat & id for  checking current record is valid or not at the time of adding new detail - end
			}
			//Added by sanket J on 30/05/17 [for checking Session expired or err msg ]-start
			else
			{
				//Changed by Sandeep S. on 19-JAN-17 [To check session exist or not for same user on same or on another machine]
				request.getSession().invalidate();
				throw new BaseException( new Exception( "SESSION_EXPIRED" ) );
			}
			//Added by sanket J on 30/05/17 [for checking Session expired or err msg ]-END
		}
		//Added by Amey W on 4/1/2019 [To display error message in case of inappropriate pophelp query] START
		catch(ITMException item)
		{			
			String itmExpMsg = item.getMessage();
			//Added by shrutika on 25-12-18 [Start] for update status as Exception.
			//Added if condition by shrutika on 10-02-19 for when session is expired and we view record then zero row return alert occur.
			if( userInfo != null )
			{
				if("OBJ_POPHELP".equalsIgnoreCase(action))
				{
					userEventLogEJB.updateEventLog(userInfo.getLoginCode(), tempObjName, userInfo.getSesstionId(),editorID , tempactionMode , "pophelp", tempstartTime, new Date(),"pkValues:[" + temppkValues + "], objContext:[" + tempformNo + "], filedName:["+tempfieldName+"]", temppkValues, "Exception","SA",item.getMessage());
				}
				else if(action.equals("ITEM_CHANGE"))
				{
					userEventLogEJB.updateEventLog(userInfo.getLoginCode(), tempObjName, userInfo.getSesstionId(), editorID, tempactionMode , "item change", tempstartTime, new Date(),"pkValues:[" + temppkValues + "], pageContext:[" + temppageContext + "], objContext:[" + tempformNo + "], argFieldValues:[" + tempargFieldValues + "]focusColumn["+focusColumn+"]", temppkValues,"Exception","SA",item.getMessage());
				}
				else
				{
					userEventLogEJB.updateEventLog(userInfo.getLoginCode(), tempObjName, userInfo.getSesstionId(), editorID, tempactionMode , tempevent, tempstartTime, new Date(),"pkValues:[" + temppkValues + "], objContext:[" + tempformNo + "], ", temppkValues,"Exception","SA",item.getMessage());
				}
			}
			//Added by shrutika on 25-12-18 [End] for update status as Exception.

			itmExpMsg = itmExpMsg.replaceAll("<Error ", "<error ").replaceAll("</Error>", "</error>");
			BaseLogger.log("0", userInfo,null,"E12EditorHandlerServlet : ITMException Msg[" + itmExpMsg + "]");
			response.setHeader("Cache-Control", "no-cache");
			response.setContentType( "text/html; charset="+CommonConstants.ENCODING );
			response.getWriter().write(itmExpMsg);

			item.printStackTrace();
			try
			{
				//Changed By Pankaj T. on 28-08-2018 for resolved issue of checkErrorException in client side due to written wrong response - start
				itmExpMsg = item.getMessage();
				BaseLogger.log("3",userInfo,null,"ServiceHandlerServlet2.doPost() : ITMException Msg[" + itmExpMsg + "]");
				response.setHeader("Cache-Control", "no-cache");
				response.setContentType( "text/html; charset="+CommonConstants.ENCODING );
				response.getWriter().write(itmExpMsg);
				response.getWriter().flush();
				response.getWriter().close();
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		//Added by Amey W on 4/1/2019 [To display error message in case of inappropriate pophelp query] END
		catch(Exception t)
		{
			//Added by sanket J on 30/05/17 [for checking Session expired or err msg ]-start 

			//Added by shrutika on 25-12-18 [Start] for update status as Exception.
			//change by shrutika on 22-01-19 for parsing issue for writePrintStacktrace in updateEventLog.
			ITMException ie = new ITMException(t);
			//Added if condition by shrutika on 10-02-19 for when session is expired and we view record then zero row return alert occur.
			if( userInfo != null )
			{
				if("OBJ_POPHELP".equalsIgnoreCase(action))
				{
					userEventLogEJB.updateEventLog(userInfo.getLoginCode(), tempObjName, userInfo.getSesstionId(),editorID , tempactionMode , "pophelp", tempstartTime, new Date(),"pkValues:[" + temppkValues + "], objContext:[" + tempformNo + "], filedName:["+tempfieldName+"]", temppkValues, "Exception","SA",ie.getMessage());
				}
				else if(action.equals("ITEM_CHANGE"))
				{
					userEventLogEJB.updateEventLog(userInfo.getLoginCode(), tempObjName, userInfo.getSesstionId(), editorID, tempactionMode , "item change", tempstartTime, new Date(),"pkValues:[" + temppkValues + "], pageContext:[" + temppageContext + "], objContext:[" + tempformNo + "], argFieldValues:[" + tempargFieldValues + "]focusColumn["+focusColumn+"]", temppkValues,"Exception","SA",ie.getMessage());
				}
				else
				{
					userEventLogEJB.updateEventLog(userInfo.getLoginCode(), tempObjName, userInfo.getSesstionId(), editorID, tempactionMode , tempevent, tempstartTime, new Date(),"pkValues:[" + temppkValues + "], objContext:[" + tempformNo + "], ", temppkValues,"Exception","SA",ie.getMessage());
				}
			}
			//Added by shrutika on 25-12-18 [End] for update status as Exception.

			BaseLogger.log("0", userInfo,null, "Throwable in doPost:==>" + t.getMessage() );
			try
			{
				t.printStackTrace();
				E12GenericUtility genericUtility = new E12GenericUtility();
				PrintWriter writer = response.getWriter();
				String errMsg = "";
				if ( request.getSession().getAttribute( "ERR_MSG" ) == null  )
				{   
					response.setContentType( "text/xml; charset="+CommonConstants.ENCODING );
					errMsg = genericUtility.createErrorString(t);
				}
				else
				{
					String sessMsg = (String) request.getSession().getAttribute( "ERR_MSG" );
					response.setContentType( "text/html; charset="+CommonConstants.ENCODING );
					errMsg = "ERR_MSG :" + sessMsg;
				}
				response.setContentLength( errMsg.length() );
				writer.println( errMsg );
				writer.flush();
				writer.close();

			}
			catch( Exception ex )
			{
				String msg = ex.toString();
				if( ex != null && ex.toString().contains("Posted content") ){
					msg = msg.replace("java.io.IOException:",""); 
					BaseLogger.log("0", userInfo,null,"E12EditorHandlerServlet : Exception[" +ex.getMessage()+"]");
					msg = "Exception:" + msg ;
				}
				BaseLogger.log("0", userInfo,null,"E12EditorHandlerServlet : Exception[" + ex.getMessage() + "]");
				ex.printStackTrace();
				response.getWriter().write( msg );
			}
		}
		/*catch (Throwable e) 
		{
            BaseLogger.log("3", userInfo,editorId,"]::::::::::::::::E12EditorHandlerServlet:::::::::::::::::::::::;;;;;;Stack trace:[");
            BaseLogger.log("3", userInfo,editorId,e.getStackTrace() + "]");
            BaseLogger.log("3", userInfo,editorId,":::::::::::::::::E12EditorHandlerServlet::::::::::::::::::::::;;;;;;Cause:[");
            BaseLogger.log("3", userInfo,editorId,e.getCause() + "]");
        }*/
		//Added by sanket J on 30/05/17 [for checking Session expired or err msg ]-END 
	}

	//change by shrutika on 28-01-19 for create local userinfo.
	//private String getMessageArgumentsVals(String objName,RIAWizardBean wizardBean)throws ITMException
	private String getMessageArgumentsVals(String objName,RIAWizardBean wizardBean, UserInfoBean userInfo)throws ITMException
	{
		ArrayList msgArgList = null;
		String msgArgStr= "";
		
		E12GenericUtility genericUtility = new E12GenericUtility();
		try
		{
			msgArgList = wizardBean.getMessageDetailList(objName);
			int msgArgListLen  = msgArgList.size();

			for(int i =0;i < msgArgListLen; i++)
			{
				String argumentStr = (String)msgArgList.get(i);

				if(argumentStr.indexOf("Detail") != -1 && argumentStr.indexOf(".") != -1)
				{
					String objCtx = argumentStr.substring(argumentStr.indexOf("Detail") + 6,argumentStr.indexOf("."));
					String fieldName = argumentStr.substring(argumentStr.indexOf(".")+1);
					String fieldVal = "";
					String detailStr= wizardBean.getFormXmlData(objCtx);
					if(detailStr != null && detailStr.length() > 0)
					{
						Document dom = genericUtility.parseString("<Root>"+detailStr+"</Root>");
						fieldVal = genericUtility.getColumnValue(fieldName,dom);
					}
					msgArgStr = msgArgStr + "&"+fieldName+"="+fieldVal;
				}
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,null,"Exception : E12EditorHandlerServlet : getSuccessMessageArguments(String,wizardBean) :"+e);
			throw new ITMException(e);
		}
		BaseLogger.log("2", userInfo,null,"Final Message Argument Str["+msgArgStr+"]");
		return msgArgStr;
	}
	
	//Changed by Prasad on 05/05/16 [As per Danish Sir, Editor option added for Property Editor]
	//private String getXmlDataString(String objName, String action, String objContext, String fieldName, String profileId, String tabType, UserInfoBean userInfo)
	private String getXmlDataString(String objName, String action, String objContext, String fieldName, String profileId, String tabType, UserInfoBean userInfo, String editor)
	{
		try
		{
			StringBuffer xmlStringBuf = new StringBuffer();
			String pageContext = ( "F".equalsIgnoreCase( tabType ) ) ? "2" : "1";
			AppConnectParm appConnect = new AppConnectParm();
			InitialContext ctx = new InitialContext(appConnect.getProperty());
			//LocalizationRemote localize = ( LocalizationRemote ) ctx.lookup( "ibase/LocalizationEJB/remote" );
			LocalizationEJB localize = new LocalizationEJB();
			//Changed by Prasad on 05/05/16 [As per Danish Sir, Editor option added for Property Editor]
			//xmlStringBuf.append( localize.getLocalizedXmlString( userInfo, objName, pageContext, objContext, profileId) );
			xmlStringBuf.append( localize.getLocalizedXmlString( userInfo, objName, pageContext, objContext, profileId, editor) );
			localize = null;
			return xmlStringBuf.toString();
		}
		catch(Exception ex)
		{
			BaseLogger.log("0", userInfo,null,"E12EditorHandlerServlet::Exception["+ex.getMessage()+"]");
			ex.printStackTrace();
			return null;
		}
	}

	//change by shrutika on 28-01-19 for create local userinfo.
	//public ArrayList<String> createDataArrayList( HttpServletRequest request, String objContext, String objName)
	public ArrayList<String> createDataArrayList( HttpServletRequest request, String objContext, String objName, UserInfoBean userInfo)
	{
		ArrayList<String> currentDomArrayReq = new ArrayList<String>();
		try
		{
			boolean isSelectedDetail = true;
			String formNo = request.getParameter("FORM_NO");

			String action = request.getParameter("ACTION");

			StringBuffer xmlStringBufHeader = new StringBuffer( "<?xml version='1.0' encoding='"+CommonConstants.ENCODING+"'?>" );
			xmlStringBufHeader.append("<DocumentRoot><description>Datawindow Root</description><group0><description>Group0 description</description><Header0><Errors></Errors><description>Header0 members</description>");
			StringBuffer xmlStringBufFooter = new StringBuffer( "</Header0></group0></DocumentRoot>" );

			ArrayList<String> dataSelectedList = new ArrayList<String>();//WILL STORE LIKE [[Detail3.1, Detail3.7, Detail3.12, Detail3.16, Detail3.17, Detail3.18]]
			ArrayList<String> dataNotSelectedList = new ArrayList<String>();

			TreeMap<String, String> dataMap = new TreeMap<String, String>();
			Enumeration enum1 = request.getParameterNames();
			while( enum1.hasMoreElements() )
			{
				Object e = enum1.nextElement();				
				String paramName = ( String ) e;
				if ( paramName.indexOf(".") == -1 ) // To avoid variables like 'OBJ_NAME', FORM_NO etc.
				{
					continue;
				}

				isSelectedDetail = true;

				String paramValue = request.getParameter( paramName );				
				String currRow = paramName.substring( 0, paramName.lastIndexOf(".") );//"Detail1.2"
				if ( objName.equalsIgnoreCase( "savex_wiz" ) ) 
				{
					if ( paramName.startsWith("Detail2") )
					{
						isSelectedDetail = false;
					}
				}
				else if( paramName.startsWith("Detail4") )
				{
					isSelectedDetail = false;
				}
				if ( paramName.startsWith( "Detail"+formNo ) || ! isSelectedDetail )
				{

					if ( ! dataSelectedList.contains( currRow ) )
					{
						dataSelectedList.add( currRow );
					}
				}
				else
				{
					if ( ! dataNotSelectedList.contains( currRow ) && ! dataSelectedList.contains( currRow ) )
					{
						if ( ( "true" ).equalsIgnoreCase( ( String ) request.getParameter( currRow + ".selectbox" ) ) )
						{
							dataSelectedList.add( currRow );
						}
						else
						{
							dataNotSelectedList.add( currRow );
						}
					}					
				}
				dataMap.put( paramName, paramValue );
			}					

			if ( dataMap != null)
			{
				Iterator<String> dataMapIterator = dataMap.keySet().iterator();
				String prevFormNo = "";
				String prevDomID = "";

				String currRow = "";
				String prevRow = "";

				boolean isRowSelected = false;
				boolean isAttributeFound = false;
				String lastSelectedForm = "";

				StringBuffer completeDataBuff = new StringBuffer();
				StringBuffer selectedDataBuff = new StringBuffer();

				while ( dataMapIterator.hasNext() )
				{
					String id = dataMapIterator.next();//Detail2.3.item_code
					String currFormNo = id.substring( "Detail".length(), id.indexOf(".") );
					currRow = id.substring(0, id.lastIndexOf("."));//Detail2.3

					if( ! prevRow.equals(currRow) )
					{						
						if( dataSelectedList.contains( currRow ))
						{
							isRowSelected = true;							
						}
						else
						{
							isRowSelected = false;							
						}
					}

					if ( prevFormNo != "" && ! prevFormNo.equals( currFormNo ) )
					{
						prevDomID = "";
					}
					String currDomID = id.substring( id.indexOf(".") + 1,  id.lastIndexOf("."));
					if ( ("Detail1").equals( id.substring( 0, id.indexOf(".") ) ) || ( ("Detail2").equals( id.substring( 0, id.indexOf(".") ) ) && !isSelectedDetail) )
					{
						currDomID = "" + 1;
					}
					String fieldName = id.substring( id.lastIndexOf(".") + 1 );
					String fieldValue = dataMap.get( id );
					if ( ! prevDomID.equals( currDomID )  )
					{
						//&& ( completeDataBuff.toString().indexOf("<Detail" + prevFormNo + ">") != -1 ) -- checking if data of prevFormNo exists in completeDataBuff 
						if ( completeDataBuff.toString().length() > 0 && ( completeDataBuff.toString().indexOf("<Detail" + prevFormNo ) != -1 ) )
						{
							completeDataBuff.append("</Detail" + prevFormNo + ">");
						}
						if( isRowSelected )
						{
							//&& ( selectedDataBuff.toString().indexOf("<Detail" + prevFormNo) != -1 ) -- checking if data of prevFormNo exists in selectedDataBuff
							if ( selectedDataBuff.toString().length() > 0 && ( selectedDataBuff.toString().indexOf("<Detail" + prevFormNo) != -1 ) )
							{
								selectedDataBuff.append("</Detail" + prevFormNo + ">");
							}
							selectedDataBuff.append("<Detail" + currFormNo +" objContext=\"" + currFormNo + "\" objName=\"" + objName + "\" domID=\"" + ( currDomID ) + "\" dbID=\"\" selected=\"Y\" >");

							completeDataBuff.append("<Detail" + currFormNo +" objContext=\"" + currFormNo + "\" objName=\"" + objName + "\" domID=\"" + ( currDomID ) + "\" dbID=\"\" selected=\"Y\" >");
						}
						else
						{
							completeDataBuff.append("<Detail" + currFormNo +" objContext=\"" + currFormNo + "\" objName=\"" + objName + "\" domID=\"" + ( currDomID ) + "\" dbID=\"\" selected=\"N\" >");
						}
					}

					String currElement = "";
					if( "ATTRIBUTE_NODE".equalsIgnoreCase( fieldName ) )
					{
						isAttributeFound = true;
						BaseLogger.log("3", userInfo,null,"ATTRIBUTE_NODE[" + fieldValue + "]");
						currElement = ( "".equalsIgnoreCase( fieldValue ) ? "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n" : fieldValue );
					}
					else if( "observ_data".equalsIgnoreCase( fieldName ) )
					{
						currElement = "<"+fieldName+">"+fieldValue+"</"+fieldName+">";
					}
					else
					{
						currElement = "<"+fieldName+"><![CDATA["+fieldValue+"]]></"+fieldName+">";
					}

					completeDataBuff.append( currElement );
					if( isRowSelected )
					{
						selectedDataBuff.append( currElement );
						lastSelectedForm = currFormNo;
					}					
					prevDomID = currDomID;
					prevFormNo = currFormNo;

					prevRow = currRow;
				}

				if ( completeDataBuff != null && ( completeDataBuff.toString() ).trim().length() > 0 )
				{
					if( !isAttributeFound )
					{
						completeDataBuff = new StringBuffer( insertAttributeNode( completeDataBuff.toString() ) );
						selectedDataBuff = new StringBuffer( insertAttributeNode( selectedDataBuff.toString() ) );
					}

					completeDataBuff.append("</Detail" + prevFormNo + ">");
					// Checking for "<Detail" + lastSelectedForm be present in slectedDataBuff
					if(selectedDataBuff.toString().length() > 0 && ( selectedDataBuff.toString().indexOf("<Detail" + lastSelectedForm) != -1 ) )
					{
						selectedDataBuff.append("</Detail" + lastSelectedForm + ">");
					}
					String completeDataStr = ( xmlStringBufHeader.toString() + completeDataBuff.toString() + xmlStringBufFooter.toString() );
					String selectedDataStr =  ( xmlStringBufHeader.toString() + selectedDataBuff.toString() + xmlStringBufFooter.toString() );
					currentDomArrayReq.add( completeDataStr );
					currentDomArrayReq.add( selectedDataStr );
					String fieldAttachmentStr = request.getParameter("field_attachments");
					BaseLogger.log("3", userInfo,null,"fieldAttachmentStr[" + fieldAttachmentStr + "]");
					if(fieldAttachmentStr != null && fieldAttachmentStr.length() > 0 && ( ! "null".equals(fieldAttachmentStr) ) )
					{
						currentDomArrayReq.add( fieldAttachmentStr );
					}
				}
			}
		}
		catch ( Exception e )
		{
			e.printStackTrace();
			BaseLogger.log("0", userInfo,null,"Exception::ITMException-->:"+e.getMessage());
		}
		return currentDomArrayReq;
	}
	
	private String insertAttributeNode( String formDetail )
	{
		if( "".equalsIgnoreCase( formDetail ) )
		{
			return formDetail;
		}
		String returnStr1 = formDetail.substring(0, formDetail.indexOf(">") + 1);
		String returnStr2 = formDetail.substring( formDetail.indexOf(">") + 1 );
		String attribStr = "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n";
		
		StringBuffer tempBuff = new StringBuffer();
		tempBuff.append(returnStr1).append(attribStr).append(returnStr2);
		formDetail = tempBuff.toString();
		
		return formDetail;
	}
	
	//Changed By Ajinkya Darvesh on 11/07/2017 [To get header data into detail for popup column]
	//private String getpopUpKeyStr(String objName, String fieldName, String paramXmlStr,UserInfoBean userInfo) 
	//changed by Amey W on 4/1/2019 [Add throws ITMException declaration to method (To display error message in case of inappropriate pophelp query)]
	private String getpopUpKeyStr(String objName, String fieldName, String paramXmlStr,UserInfoBean userInfo, String allDetailXmlData,	String formno, String reqParams)throws ITMException 
	{
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			InitialContext ctx = new InitialContext(appConnect.getProperty());
			//PopUpRemote popUp = ( PopUpRemote )ctx.lookup( "ibase/PopUpEJB/remote" );
			PopUpEJB popUp = new PopUpEJB();
			
			//Changed By Ajinkya Darvesh on 11/07/2017 [To get header data into detail for popup column] [START]
			//String xmlString = popUp.getpopUpKeyStr(objName, fieldName, paramXmlStr, userInfo);
			String xmlString = popUp.getpopUpKeyStr(objName, fieldName, paramXmlStr, userInfo , allDetailXmlData, formno, reqParams);
			//Changed By Ajinkya Darvesh on 11/07/2017 [To get header data into detail for popup column] [END]
			popUp = null;
			return xmlString;
		}
		catch(Exception ex)
		{
			BaseLogger.log("0", userInfo,null,"Exception :: E12EditorHandlerServlet.getPopUpKeyStr ["+ex.getMessage()+"]");
			ex.printStackTrace();
			//changed by Amey W on 4/1/2019 [To display error message in case of inappropriate pophelp query]
			//return null;
			throw new ITMException(ex);
		}
	}
	
	/*public ArrayList<String> getPopHelpInfo(String objName, String objType)
	{
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			InitialContext ctx = new InitialContext(appConnect.getProperty());
			PopUpRemote popUp = ( PopUpRemote )ctx.lookup( "ibase/PopUpEJB/remote" );
			ArrayList<String> popHelpLst = popUp.getPopUpLst(objName, objType);
			return popHelpLst;
		}
		catch(Exception ex)
		{
			BaseLogger.log("3", userInfo,editorId,"Exception :: E12EditorHandlerServlet.getPopHelpInfo ["+ex.getMessage()+"]");
			ex.printStackTrace();
			return null;
		}
	}*/

	//change by shrutika on 280 for multiple activities are not update due to global userinfo.
	//private void abortServeComp( HttpServletRequest request )
	private void abortServeComp( HttpServletRequest request, UserInfoBean userInfo  )
	{
		try
		{
			String editorID = request.getParameter("EDITOR_ID");
			ArrayList<Object> objInSession = (ArrayList<Object>) request.getSession().getAttribute("OBJECT_IN_SESSION");
			if( objInSession != null && objInSession.size() > 0 )
			{
				for ( int ctr = 0; ctr < objInSession.size(); ctr++ )
				{
					Object currObj = objInSession.get( ctr );
					if( currObj instanceof RIAWizardBean )
					{
						RIAWizardBean rwb = ( RIAWizardBean ) currObj;
//						String objName = rwb.getObjName();
						String prevEditorID = rwb.getEditorID();
						if( prevEditorID != null && prevEditorID.equalsIgnoreCase(editorID))
						{
							rwb.remove();
							request.getSession().removeAttribute( "WIZARD_BEAN_"+ editorID );
							BaseLogger.log("3", userInfo,null,"abortServeComp ...  Removed WIZARD_BEAN_"+ editorID );
						}
					}
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}
	
	//change by shrutika on 28-01-19 for multiple activities are not update due to global userinfo.
	//private String getXSLFileName( String fileName )throws ITMException
	private String getXSLFileName( String fileName, UserInfoBean userInfo )throws ITMException
	{   
		String retFileName = null;
		try
		{
			String defaultPath = null;
			if( CommonConstants.APPLICATION_CONTEXT != null )
			{
				defaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT + File.separator;
			}
			else
			{
				defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + CommonConstants.ITM_CONTEXT + File.separator;
			}
			if ( ! ( new File( defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME ) ).exists() )
			{
				( new File(defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME) ).mkdir();
			}

			File xslFile = new File(defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME , fileName);
			if( xslFile.exists() )
			{
				retFileName = xslFile.getAbsolutePath();
			}
			else
			{   
				BaseLogger.log("3", userInfo,null,"Default file not found @ "+xslFile.getAbsolutePath());
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return retFileName;
	}
	
	/**
	 * @param request
	 * @param isSaved
	 * @return
	 * @throws Exception
	 */
	//change by shrutika on 28-01-19 for create local userinfo.
	//private String uploadFile( HttpServletRequest request,boolean isSaved)throws ITMException, Exception
	private String uploadFile( HttpServletRequest request,boolean isSaved, UserInfoBean userInfo)throws ITMException, Exception
	{
		String newFileName = null;
		File DUMP_DIR = null;
		try
		{
			if(isSaved)
			{
				DUMP_DIR = new File(dirName);
			}
			else
			{
				String editorId = request.getParameter("EDITOR_ID");
				String tmpdirName = dirName + File.separator + editorId;
				DUMP_DIR = new File(tmpdirName);
			}
			if (!DUMP_DIR.exists())
			{
				DUMP_DIR.mkdirs();
			}
			BaseLogger.log("3", userInfo,null,"Document Upload");
			BaseLogger.log("3", userInfo,null,"MAX_UPLOAD_SIZE[" + MAX_UPLOAD_SIZE + "]");
			MultipartParser mp = new MultipartParser(request, MAX_UPLOAD_SIZE);
			Part part;
			while ((part = mp.readNextPart()) != null)
			{
				String name = part.getName();
				BaseLogger.log("3", userInfo,null,"name**********"+ name);
				if (part.isParam())
				{
				  // it's a parameter part
				  ParamPart paramPart = (ParamPart) part;
				  String value = paramPart.getStringValue();				  
				}
				else if (part.isFile())
				{
					//it's a file part
					FilePart filePart = (FilePart) part;
					String oriFileName = filePart.getFileName();
					newFileName = oriFileName;
					
					long size = filePart.writeTo(DUMP_DIR);
					
					File oriFileObj = new File(DUMP_DIR + File.separator + oriFileName);
					if(oriFileObj.exists())
					{
						oriFileObj.renameTo(new File(DUMP_DIR + File.separator + newFileName));
					}
					BaseLogger.log("3", userInfo,null,"filePart size [" + size + "]");
				}
			}
		}
		catch (IOException lEx)
		{
			BaseLogger.log("0", userInfo,null,"IOException while file uploading : " + lEx);
			throw lEx;
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,null,"Exception while file uploading : " + e);
			throw e;
		}		
		return newFileName;
	}
	
	//Commented by Prasad on 07/02/19 [unused methods] START
	/**
	 * @param request
	 * @param file
	 * @param refId
	 * @return
	 * @throws Exception
	 */
	/*private String addDocument( HttpServletRequest request, File file , String refId )throws ITMException, Exception //Manish 12/1/2006
	{
		//change by shrutika on 28-01-19 for create local userinfo.
		UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
		StringBuffer retXMLStringBuff = null;
		String retString = null;
		BufferedInputStream bfr = null;
		ByteArrayOutputStream bout = null;
		BaseLogger.log("2", userInfo,null, "**** DNYANESHWAR **** E12EditorHandlerServlet : addDocument : refId["+refId+"]" );
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			InitialContext ctx = new InitialContext(appConnect.getProperty());
			//DocumentHandlerRemote docHandler = (DocumentHandlerRemote)ctx.lookup("ibase/DocumentHandlerEJB/remote");
			DocumentHandlerEJB docHandler = new DocumentHandlerEJB();
			BaseLogger.log("3", userInfo,null, "**** DNYANESHWAR **** E12EditorHandlerServlet : addDocument : docHandler["+docHandler+"]" );
			BaseLogger.log("3", userInfo,null,"***refId in DocumentHandler-----> "+ refId);
			String objName = request.getParameter("OBJ_NAME");
			//change by shrutika on 28-01-19 for create local userinfo.
			//String refSer = getValueFromDBAccess( objName , "REFSER" );
			String refSer = getValueFromDBAccess( objName , "REFSER", userInfo );
			
			BaseLogger.log("3", userInfo,null,"***refSer -----> "+ refSer);
			
			//UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
			String user = userInfo.getLoginCode();
			String fileName = file.getName();
			String fileType = fileName.substring( fileName.lastIndexOf(".") + 1 );//Manish 11/30/2006

			BaseLogger.log("3", userInfo,null, "***fileName[" + fileName + "] fileType[" + fileType + "]" );
			
			
			retXMLStringBuff = new StringBuffer();

			retXMLStringBuff.append("<?xml version=\"1.0\" encoding=\""+CommonConstants.ENCODING+"\"?>");
			retXMLStringBuff.append("<DocumentRoot>");
			retXMLStringBuff.append("<description>Datawindow Root</description>");
			retXMLStringBuff.append("<group0>");
			retXMLStringBuff.append("<description>Group0 description</description>");
			retXMLStringBuff.append("<Header0>");
			retXMLStringBuff.append("<description>Header0 members</description>");
			retXMLStringBuff.append("<header>");
			retXMLStringBuff.append("<ref_id><![CDATA["+refId+"]]></ref_id>");
			retXMLStringBuff.append("<ref_ser><![CDATA["+refSer+"]]></ref_ser>");
			retXMLStringBuff.append("<doc_name><![CDATA["+file.getName()+"]]></doc_name>");
			retXMLStringBuff.append("<doc_type><![CDATA["+fileType+"]]></doc_type>");
			retXMLStringBuff.append("<created_by><![CDATA["+user+"]]></created_by>");
			retXMLStringBuff.append("</header>");
			retXMLStringBuff.append("</Header0>");
			retXMLStringBuff.append("</group0>");
			retXMLStringBuff.append("</DocumentRoot>");
			BaseLogger.log("3", userInfo,null,"***retXMLStringBuff [" + retXMLStringBuff + "]");

			//[Here temporary file created ]
			retString = docHandler.addDocument(retXMLStringBuff.toString(), file, userInfo.getTransDB());
		}
		catch (ITMException itme)
		{
			BaseLogger.log("0", userInfo,null,"ITMException while file addDocument in DOC_CONTENTS : [" + itme.getMessage() + "]");
			throw itme;
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,null,"Exception while file addDocument in DOC_CONTENTS : [" + e.getMessage() + "]");
			throw e;
		}
		finally
		{
			try
			{
				if( bfr != null )
				{
					bfr.close();
					bfr = null;
				}
				if( bout != null )
				{
					bout.close();
					bout = null;
				}
			}
			catch ( Exception e )
			{
				BaseLogger.log("0", userInfo,null, "Exception in releasing file resource :" );
				e.printStackTrace();
			}
		}
		return retString;
	}*/
	
	//change by shrutika on 28-01-19 for create local userinfo.
	//private String getValueFromDBAccess( String objName, String columnName )throws Exception
	/*private String getValueFromDBAccess1( String objName, String columnName, UserInfoBean userInfo )throws Exception
	{
		String retValue = "";
		try
		{
			if( objName != null && ( !"null".equals( objName ) ) && objName.length() > 0 )
			{
				AppConnectParm appConnect = new AppConnectParm();
				InitialContext ctx = new InitialContext(appConnect.getProperty());
				//DBAccessRemote dbAccess = (DBAccessRemote)ctx.lookup("ibase/DBAccessEJB/remote");
				DBAccessEJB dbAccess = new DBAccessEJB();
				if( "REFSER".equalsIgnoreCase( columnName ) )
				{
					retValue = dbAccess.getRefSer( null, objName, userInfo );
				}
				else if( "ISATTACHMENT".equalsIgnoreCase( columnName ) )
				{
					retValue = dbAccess.getIsAttachment(objName, userInfo);
				}
				else if( "STARTFORM".equalsIgnoreCase( columnName ) )
				{
					retValue = dbAccess.getStartForm(objName, userInfo);
				}
				else 
				{
					HashMap objDetailMap = dbAccess.getObjDetailMap(objName, userInfo);
					if (objDetailMap != null) 
					{
						retValue = (String) objDetailMap.get(columnName);
					}
				}
				dbAccess = null;
			}
		}
		catch( Exception e )
		{
			BaseLogger.log("0", userInfo,null,"getValueFromDBAccess : Exception [" + e.getMessage() + "]");
			throw e;
		}
		return retValue;
	}*/
	//Commented by Prasad on 07/02/19 [unused methods] END
	
	/**
	 * @param formData : Here formData will contains freeForm data only i.e It contains only one detail <Detail1>... </Detail1>
	 * 
	 * @param objContext : Form No for which ArrayList to be generate
	 * 
	 * @param objName : Object Name
	 * 
	 * @return
	 */
	//change by shrutika on 28-01-19 for create local userinfo.
	//public ArrayList<String> createNextDataArrayList( String formData, String objContext, String objName)
	public ArrayList<String> createNextDataArrayList( String formData, String objContext, String objName, UserInfoBean userInfo)
	{
		Document formDataDom;
		String selectedDataXML = "";
		ArrayList<String> currentDomArrayReq = new ArrayList<String>();
		StringBuffer xmlStringBufHeader = new StringBuffer( "<?xml version='1.0' encoding='"+CommonConstants.ENCODING+"'?>" );
		xmlStringBufHeader.append("<DocumentRoot><description>Datawindow Root</description><group0><description>Group0 description</description><Header0><Errors></Errors><description>Header0 members</description>");
		StringBuffer xmlStringBufFooter = new StringBuffer( "</Header0></group0></DocumentRoot>" );

		try
		{
			E12GenericUtility e12GenericUtility = new E12GenericUtility();
			formDataDom = e12GenericUtility.parseString(formData);
			Node detailNode = formDataDom.getElementsByTagName("Detail" + objContext).item(0);
			selectedDataXML = e12GenericUtility.serializeDom(detailNode);
			BaseLogger.log("3", userInfo,null,objContext + " : selectedDataXML[" + selectedDataXML + "]" );
		}
		catch (ITMException e) 
		{
			e.printStackTrace();
		}

		String selectedDataStr =  ( xmlStringBufHeader.toString() + selectedDataXML + xmlStringBufFooter.toString() );
		currentDomArrayReq.add( "" );
		currentDomArrayReq.add( selectedDataStr );
		currentDomArrayReq.add( selectedDataXML );
		return currentDomArrayReq;
	}
	//[For File Attachment on Finish] End
	
	//change by shrutika on 28-01-19 for multiple activities are not update due to global userinfo.
	//private String getCommaSeperatedValue( ArrayList objItemChangeFldList )
	private String getCommaSeperatedValue( ArrayList objItemChangeFldList, UserInfoBean userInfo )
	{
		StringBuffer fieldNameBuff = new StringBuffer();
		for( Object fieldName : objItemChangeFldList )
		{
			fieldNameBuff.append( (String)fieldName ).append(",");
		}
		String CSValues = fieldNameBuff.toString();
		if( ! "".equalsIgnoreCase( CSValues ) )
		{
			CSValues = CSValues.substring(0, CSValues.lastIndexOf(","));
		}
		BaseLogger.log("2", userInfo,null,"getCommaSeperatedValue : CSValues [" + CSValues + "]");
		return CSValues;
	}
 	
	//[For Restart Transaction from specified Form] Start
	//private CommonDBAccessRemote getCommonDBAccess() throws BaseException
	//change by shrutika on 28-01-19 for multiple activities are not update due to global userinfo.
	private CommonDBAccessRemote getCommonDBAccess( UserInfoBean userInfo ) throws BaseException
	{
		// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [START]
		//CommonDBAccessRemote ejbObj = null;
		CommonDBAccessEJB ejbObj = null;
		// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [END]
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			BaseLogger.log("3", userInfo,null,"Looking Up for CommonDBAccess EJB with Properties==>\n"+p); //$NON-NLS-1$
			// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [START]
			//ejbObj = (CommonDBAccessRemote)ctx.lookup("ibase/CommonDBAccessEJB/remote"); //$NON-NLS-1$
			ejbObj = new CommonDBAccessEJB();
			// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [END]
		}
		catch( BaseException be )
		{
			BaseLogger.log("0", userInfo,null,"Exception: getCommonDBAccess:==>\n"+be); //$NON-NLS-1$
			throw be;
		}
		catch( Exception e )
		{
			BaseLogger.log("0", userInfo,null,"Exception: getCommonDBAccess:==>\n"+e); //$NON-NLS-1$
			throw new BaseException( e );
		}
		return ejbObj;
	}
	
	private String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	//[For Restart Transaction from specified Form] End

	public ArrayList<String> getPopHelpInfo(String objName, String objType, UserInfoBean userInfo)
	{
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			InitialContext ctx = new InitialContext(appConnect.getProperty());
			//PopUpRemote popUp = ( PopUpRemote )ctx.lookup( "ibase/PopUpEJB/remote" );
			PopUpEJB popUp = new PopUpEJB();
			ArrayList<String> popHelpLst = popUp.getPopUpLst(objName, objType, userInfo);
			popUp = null;
			return popHelpLst;
		}
		catch(Exception ex)
		{
			BaseLogger.log("0", userInfo,null,"Exception :: E12EditorHandlerServlet.getPopHelpInfo ["+ex.getMessage()+"]");
			ex.printStackTrace();
			return null;
		}
	}
	
	private String getValueFromDBAccess( String objName, String columnName ,UserInfoBean userInfo)throws Exception
	{
		String retValue = "";
		try
		{
			if( objName != null && ( !"null".equals( objName ) ) && objName.length() > 0 )
			{
				AppConnectParm appConnect = new AppConnectParm();
				InitialContext ctx = new InitialContext(appConnect.getProperty());
				//DBAccessRemote dbAccess = (DBAccessRemote)ctx.lookup("ibase/DBAccessEJB/remote");
				DBAccessEJB dbAccess = new DBAccessEJB();
				if( "REFSER".equalsIgnoreCase( columnName ) )
				{
					retValue = dbAccess.getRefSer( null, objName,userInfo );
				}
				else if( "ISATTACHMENT".equalsIgnoreCase( columnName ) )
				{
					retValue = dbAccess.getIsAttachment(objName,userInfo);
				}
				else if( "STARTFORM".equalsIgnoreCase( columnName ) )
				{
					retValue = dbAccess.getStartForm(objName,userInfo);
				}
				else 
				{
					HashMap objDetailMap = dbAccess.getObjDetailMap(objName,userInfo);
					if (objDetailMap != null) 
					{
						retValue = (String) objDetailMap.get(columnName);
					}
				}
				dbAccess = null;
			}
		}
		catch( Exception e )
		{
			BaseLogger.log("0", userInfo,null,"getValueFromDBAccess : Exception [" + e.getMessage() + "]");
			throw e;
		}
		return retValue;
	}

	//[Called from AUTO_SEARCH_POPHELP action : this will send pophelp data in JSON format] Start
	//changed by Amey W on 4/1/2019 [Add throws ITMException declaration to method (To display error message in case of inappropriate pophelp query)]
	private String getAutoSearchPophelp(HttpServletRequest request,	UserInfoBean userInfo) throws ITMException
	{

		//Added by shrutika on 25-12-18 [Start] for update status as Exception.
		String objName = "",editorId ="",actionMode ="", pkValues= "", editflag= "" ,formNo = "", fieldName = "";
		Date startTime = new Date();
		//Added by shrutika on 25-12-18 [End] for update status as Exception.
		try
		{
			StringBuffer params = new StringBuffer();
			objName = request.getParameter("OBJ_NAME");
			fieldName = request.getParameter("FIELD_NAME");
			//Added by sanket on 25/04/17 [pophelp relted changes] START
			editorId = request.getParameter("EDITOR_ID");
			String sqlInput = request.getParameter("SQL_INPUT");
			formNo = request.getParameter("FORM_NO");
			String paramxml = request.getParameter("PARAMXML");
			//added by shrutika on 10-12-18 [start] for add pophelp data in event log.
			pkValues = request.getParameter("PKVLAUE");
			editflag = request.getParameter("EDIT_FLAG");
			//added by shrutika on 10-12-18 [start] for add pophelp data in event log.
			//Changed by sanket on 25/04/17 [pophelp relted changes] END
			Enumeration enum1 = request.getParameterNames();
			while( enum1.hasMoreElements() )
			{
				String paramName = ( String ) enum1.nextElement();
				String paramValue = request.getParameter( paramName );
				params.append(paramName).append("=").append(paramValue).append("~SEP~");
			}
			//Added by shrutika for 10-12-18 [Start] for add pophelp event in event activity log.
			ibase.ejb.UserEventLogEJB userEventLogEJB = new ibase.ejb.UserEventLogEJB();
			if( "".equalsIgnoreCase(editorId))
			{
				editorId = "" + new Date().getTime();
			}
			actionMode = "VIEW";
			if(editflag != null)
			{
				if( editflag.equals("A") )
				{
					actionMode = "ADD";
				}
				else if( editflag.equals("E") )
				{
					actionMode = "EDIT";
				}
			}
			//Change by shrutika on 05-01-19 for add exception.
			userEventLogEJB.setEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(),editorId , actionMode , "AUTO_SEARCH_POPHELP", startTime, null,"pkValues:[" + pkValues + "], objContext:[" + formNo + "], filedName:["+fieldName+"]", pkValues, "Pending","SA","");
			//Added by shrutika for 10-12-18 [end] for add pophelp event in event activity log.


			//BaseLogger.log("3", userInfo,editorId,"getAutoSearchPophelp params["+params+"]");
			AppConnectParm appConnect = new AppConnectParm();
			InitialContext ctx = new InitialContext(appConnect.getProperty());
			//PopUpRemote popUp = ( PopUpRemote )ctx.lookup( "ibase/PopUpEJB/remote" );
			PopUpEJB popUp = new PopUpEJB();
			//Changed By sanket J on 26/04/17 [for pophelp related changes]
			//String xmlString = popUp.getpopUpKeyStrJSON(objName, fieldName, params.toString(), userInfo);
			String xmlString = popUp.getpopUpKeyStrJSON(objName, fieldName, params.toString(), userInfo , editorId, sqlInput, formNo, paramxml);
			//Added by shrutika for 10-12-18 for add pophelp event in event activity log.
			//Change by shrutika on 05-01-19 for add exception.
			userEventLogEJB.updateEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(),editorId , actionMode , "AUTO_SEARCH_POPHELP", startTime, new Date(),"pkValues:[" + pkValues + "], objContext:[" + formNo + "], filedName:["+fieldName+"]", pkValues, "Success","SA","");
			popUp = null;
			return xmlString;
		}
		catch(Exception ex)
		{
			//Added by shrutika on 25-12-18 [Start] for update status as Exception.
			//change by shrutika on 22-01-19 for parsing issue for writePrintStacktrace in updateEventLog.
			ITMException ie = new ITMException(ex);
			userEventLogEJB.updateEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(),editorId , actionMode , "AUTO_SEARCH_POPHELP", startTime, new Date(),"pkValues:[" + pkValues + "], objContext:[" + formNo + "], filedName:["+fieldName+"]", pkValues, "Exception","SA",ie.getMessage());
			//Added by shrutika on 25-12-18 [End] for update status as Exception.
			BaseLogger.log("0", userInfo,null,"Exception :: E12EditorHandlerServlet.getPopUpKeyStr ["+ex.getMessage()+"]");
			ex.printStackTrace();
			//changed by Amey W on 4/1/2019 [To display error message in case of inappropriate pophelp query]
			//return null;
			throw new ITMException(ex);
		}
	}
	//[Called from AUTO_SEARCH_POPHELP action : this will send pophelp data in JSON format] End
	
	//Changed by Prasad on 18/05/16 [As per Danish Sir, Editor option added for Property Editor]
	//protected String setActionForDuplicateTransaction( String objName, String objContext, String pkValues , HttpSession sess , String editorId ,String user)throws ITMException
	protected String setActionForDuplicateTransaction( String objName, String objContext, String pkValues , HttpSession sess , String editorId ,String user, String editor)throws ITMException
	{
		String retXMLStr = ""; //$NON-NLS-1$
		//change by shrutika on 28-01-19 for create local userinfo.
		ibase.utility.UserInfoBean userInfo = ( ibase.utility.UserInfoBean )sess.getAttribute( "USER_INFO" ); //$NON-NLS-1$
		try
		{
			//ibase.utility.UserInfoBean userInfo = ( ibase.utility.UserInfoBean )sess.getAttribute( "USER_INFO" ); //$NON-NLS-1$
			//Changed by Prasad on 04/05/17 [Create E12TransEditorCoreModel and keep in session instead of MasterStateful] START
			/*MasterStatefulRemote masterRem = ( MasterStatefulRemote )sess.getAttribute( editorId );
			if( masterRem == null )
			{
				masterRem = (MasterStatefulRemote)this.ctx.lookup("ibase/MasterStatefulEJB/remote"); //$NON-NLS-1$
				sess.setAttribute( editorId, masterRem );
				if( userInfo != null )
				{
					String tempEditorID = editorId;
					if( editorId != null &&  editorId.indexOf(user) != -1)
					{
						tempEditorID = editorId.substring(0,editorId.indexOf(user));
					}
					masterRem.setEditorId(tempEditorID);
					masterRem.setUserInfo( userInfo );
					//Added by Prasad on 18/05/16 [As per Danish Sir, Editor option added for Property Editor]
					masterRem.setEditor(editor);
					//Changed by samadhan on 28/09/2016[CO3ASUN001] for forcefully tax calculation.
					//retXMLStr = masterRem.getTransCopyXMLString( objName , objContext ,  pkValues, null );
					//Changed By Pankaj T on 16-03-17 [setting transCopy flag true for Copy Transaction]
					masterRem.setTransCopy(true);
					retXMLStr = masterRem.getTransCopyXMLString( objName , objContext ,  pkValues, null, true );
					//Changed By Pankaj T on 16-03-17 [setting transCopy flag false after Copy Transaction completed]
					masterRem.setTransCopy(false);
				}
				else
				{
					retXMLStr = Messages.getString("E12EditorHandlerServlet_notLoggedOrSessionHasExpired")+"\n"+Messages.getString("RequestHandlerServlet_pleaseReconnectToWork."); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				}
			}*/
			//Added By Ajinkya Gopalkar on 17-May-17[For implementing copy transaction in Compact Editor] - Start
			String tempEditorID = getStatefulEditorId( editorId, user );
			ITMTransactionCoreModel itmTransCoreMdl = (ITMTransactionCoreModel) sess.getAttribute(tempEditorID);
			BaseLogger.log("3", userInfo,editorId,"Session attributes==>"+sess.getAttribute(tempEditorID));
			/*Enumeration e = sess.getAttributeNames();
		    while (e.hasMoreElements()) {
		      String name = (String) e.nextElement();
		      BaseLogger.log("3", userInfo,editorId,name + ": " + sess.getAttribute(name) + "\n");
		    }*/
			if( itmTransCoreMdl == null )
			{
				BaseLogger.log("3", userInfo,editorId,"ITMTransactionCoreModel can not get from sess");
				itmTransCoreMdl = new ITMTransactionCoreModel();
				//Changed by Sadique on 10/12/18 [changes for wildfly clustering] START
				//itmTransCoreMdl.setSessionContext(sess);
				itmTransCoreMdl.setObjName(objName);
				//added by sadique on 10/12/18 for wildfly clustering
				itmTransCoreMdl.setUserInfo( userInfo );
				ITMTransactionHeaderModel itmTransHdrMdl = (ITMTransactionHeaderModel) sess.getAttribute( "itmTransHdrMdl" );
				if ( itmTransHdrMdl != null )
				{
					itmTransCoreMdl.setITMFilterModel( itmTransHdrMdl.getITMFilterModel() );
				}
				//Changed by Sadique on 10/12/18 [changes for wildfly clustering] END

				sess.setAttribute(tempEditorID, itmTransCoreMdl);
			}
			itmTransCoreMdl.masterStateful.setEditorId(""+tempEditorID);
  			itmTransCoreMdl.setCoreModelId(Integer.parseInt(tempEditorID));
  			itmTransCoreMdl.setPKValues(pkValues);
  			itmTransCoreMdl.setEditFlag("A");
//  		itmTransCoreMdl.setTransCopied(true);
			//Added By Ajinkya Gopalkar on 17-May-17[For implementing copy transaction in Compact Editor] - End
			
			E12TransEditorCoreModel transEditorCoreModel = (E12TransEditorCoreModel) sess.getAttribute( editorId );
			if ( transEditorCoreModel == null )
			{
				transEditorCoreModel = new E12TransEditorCoreModel( objName );
				//Changed by Sadique on 10/12/18 [changes for wildfly clustering] START
				//transEditorCoreModel.setSessionCtx( sess );
				transEditorCoreModel.setUserInfo( userInfo );
				//Changed by Sadique on 10/12/18 [changes for wildfly clustering] END
				transEditorCoreModel.setMasterStateful( itmTransCoreMdl.masterStateful );
				transEditorCoreModel.setObjName( objName );
				sess.setAttribute( editorId, transEditorCoreModel );
			}
			MasterStatefulRemote masterRem = transEditorCoreModel.getMasterStateful();
			if( userInfo != null && masterRem != null )
			{
//				String tempEditorID = getStatefulEditorId( editorId, user );
				masterRem.setEditorId( tempEditorID );
				masterRem.setTransCopy( true );
				//Added by Pratheek on 1/04/2020[ to properly show the line number when drawing the feed in detail screen on the click of servicehandler 3 button]-Start
				masterRem.setCurrentDetailValidated(true);
				//Added by Pratheek on 1/04/2020[ to properly show the line number when drawing the feed in detail screen on the click of servicehandler 3 button]-End
				//Added By Ajinkya Gopalkar on 29-May-17[For issue of avoid copy transaction again while switching to Compact editor] Start
				if( pkValues != null && !itmTransCoreMdl.isTransCopied() )
				{
					retXMLStr = masterRem.getTransCopyXMLString(objName, objContext, pkValues, null, false);
					itmTransCoreMdl.setTransCopied(true);
				}
				else
				{
					//Changes by Ajinkya G on 31-May-17[For issue of all form data not get while switch to compact editor]
					retXMLStr = masterRem.getDetailDomData();
				}
//				retXMLStr = masterRem.getTransCopyXMLString( objName, objContext, pkValues, null, true );
//				Added By Ajinkya Gopalkar on 29-May-17[For issue of avoid copy transaction again while switching to Compact editor] End
				masterRem.setTransCopy( false );
			}
			else
			{
				retXMLStr = Messages.getString("E12EditorHandlerServlet_notLoggedOrSessionHasExpired")+"\n"+Messages.getString("RequestHandlerServlet_pleaseReconnectToWork."); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}
			//Changed by Prasad on 04/05/17 [Create E12TransEditorCoreModel and keep in session instead of MasterStateful] END
		}
		catch (Throwable e)
		{
			e.printStackTrace();
			BaseLogger.log("0", userInfo,editorId,"Exception :E12EditorHandlerServlet :setActionForDuplicateTransaction :==>"); //$NON-NLS-1$
		}
		return retXMLStr;
	}
	//Changed by Prasad on 18/05/16 [As per Danish Sir, Editor option added for Property Editor]
	//protected String getXMLDataForDetail( String objName, String objContext, String editFlag, String pkValues, String chgStr, String argFieldValues, HttpSession sess, String editorId, String reqParamStr ,String user) throws ITMException
	protected String getXMLDataForDetail( String objName, String objContext, String editFlag, String pkValues, String chgStr, String argFieldValues, HttpSession sess, String editorId, String reqParamStr ,String user, String editor) throws ITMException
	{
		//change by shrutika on 28-01-19 for create local userinfo.
		ibase.utility.UserInfoBean userInfo = ( ibase.utility.UserInfoBean )sess.getAttribute( "USER_INFO" ); //$NON-NLS-1$
		BaseLogger.log("2", userInfo,editorId,"[RequestHandlerServlet]Getting detail xml string for objName :"+objName+":\n\tpkValues :"+pkValues+":\n\targFieldValues :"+argFieldValues); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		String retXMLStr = "";
		try
		{
			//ibase.utility.UserInfoBean userInfo = ( ibase.utility.UserInfoBean )sess.getAttribute( "USER_INFO" ); //$NON-NLS-1$
			BaseLogger.log("3", userInfo,editorId,"get masterRem from session for editorId "+editorId);
			//Changed by Prasad on 04/05/17 [Create E12TransEditorCoreModel and keep in session instead of MasterStateful] START
			/*MasterStatefulRemote masterRem = ( MasterStatefulRemote )sess.getAttribute( editorId );
			String tempEditorID = editorId;
			if( editorId != null &&  editorId.indexOf(user) != -1)
			{
				tempEditorID = editorId.substring(0,editorId.indexOf(user));
			}
			if(masterRem == null)
			{
				BaseLogger.log("3", userInfo,editorId,"Inside getXMLDataForDetail if masterRem == null");
				masterRem = (MasterStatefulRemote)this.ctx.lookup("ibase/MasterStatefulEJB/remote"); //$NON-NLS-1$
				masterRem.setEditorId(tempEditorID);
				//Added by Prasad on 18/05/16 [As per Danish Sir, Editor option added for Property Editor]
				masterRem.setEditor(editor);
				//Added by Suraj on 18-11-2016 [To set plan date ]Start
				masterRem.setPlanDate(plan_Date);
				masterRem.setCalComp(Cal_Comp);
				//Added by Suraj on 18-11-2016 [To set plan date ]End
				if(!editFlag.equals("V")) //$NON-NLS-1$
				{
					sess.setAttribute( editorId, masterRem );
				}
				if(userInfo != null)
				{
					masterRem.setUserInfo(userInfo);
				}
				else
				{
					retXMLStr = Messages.getString("RequestHandlerServlet_notLoggedOrSessionExpired")+"\n"+Messages.getString("RequestHandlerServlet_pleaseReconnectToWork"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				}
			}*/
			E12TransEditorCoreModel transEditorCoreModel = (E12TransEditorCoreModel) sess.getAttribute( editorId );
			if ( transEditorCoreModel == null )
			{
				transEditorCoreModel = new E12TransEditorCoreModel( objName );
				//Changed by Sadique on 10/12/18 [changes for wildfly clustering] START
				//transEditorCoreModel.setSessionCtx( sess );
				transEditorCoreModel.setUserInfo( userInfo );
				//Changed by Sadique on 10/12/18 [changes for wildfly clustering] END
				transEditorCoreModel.setObjName( objName );
				
				sess.setAttribute( editorId, transEditorCoreModel );
			}
			MasterStatefulRemote masterRem = transEditorCoreModel.getMasterStateful();
			//Changed by Prasad on 04/05/17 [Create E12TransEditorCoreModel and keep in session instead of MasterStateful] END
			if( userInfo != null && masterRem != null )
			{
				String tempEditorID = getStatefulEditorId( editorId, user );
				masterRem.setEditorId(tempEditorID);
				//Added by Prasad on 18/05/16 [As per Danish Sir, Editor option added for Property Editor]
				masterRem.setEditor(editor);
				//Added by Suraj on 18-11-2016 [To set plan date ]Start
				masterRem.setPlanDate(plan_Date);
				masterRem.setCalComp(Cal_Comp);
				//Added by Suraj on 18-11-2016 [To set plan date ]End
				//Changed by Prasad on 31/01/19 [to validate client and server side data and perform respected action]
				//String valXMLStr = (chgStr != null && chgStr.length() > 0)?masterRem.updateDetailDom(chgStr):""; //$NON-NLS-1$
				//Added By Pankaj T. on 17-02-2021 - added new attributes in detail tag valdatastat, taxcalcstat & id for  checking current record is valid or not at the time of adding new detail - start
				String currObjContext = masterRem.getObjContext();
				String currDomId = masterRem.getDetailDomId();
				String headerPKFieldValues = masterRem.getHeaderPKFieldValues();
				String xmlStr = masterRem.getDetailDomData();
				
				if( (currObjContext != null && !(currObjContext.equals("1"))) && (objContext != null && objContext.equals(currObjContext)) && E12GenericUtility.checkNull(xmlStr).length() > 0 )
				{
					E12GenericUtility e12GenericUtility = new E12GenericUtility();
					Document dom = e12GenericUtility.parseString(xmlStr);
					if( dom != null )
					{
						Node detailNode = null;
						String headerPKValues = "";
						if( headerPKFieldValues != null && (headerPKFieldValues.lastIndexOf(":") == headerPKFieldValues.length() - 1) )
						{
							headerPKValues = headerPKFieldValues.substring(0, headerPKFieldValues.lastIndexOf(":"));
						}
						String id = currObjContext + ":" + currDomId + ":" + headerPKValues;
						BaseLogger.log("3", userInfo,editorId,"Inside E12EditorHandlerServlet getXMLDataForDetail  detailNode id : [" + id +"]");
						try
						{
							XPathFactory xpf = XPathFactory.newInstance();
					        XPath xpath = xpf.newXPath();
					        XPathExpression expression = xpath.compile( "//Detail"+currObjContext+"[@id='"+id+"']" );

					        detailNode = (Node) expression.evaluate( dom, XPathConstants.NODE );
						} 
						catch (Exception e) 
						{
							BaseLogger.log("3", userInfo,editorId,"Inside E12EditorHandlerServlet getXMLDataForDetail Exception in getting detailNode using Xpath : ["+E12GenericUtility.getStackTrace(e)+"]");
						}
						if( detailNode != null )
						{
							Node valdatastatNode = detailNode.getAttributes().getNamedItem("valdatastat");
							if( valdatastatNode != null )
							{
								String valdatastat = E12GenericUtility.checkNull( valdatastatNode.getNodeValue() );
								if( "0".equalsIgnoreCase(valdatastat) || "1".equalsIgnoreCase(valdatastat) || "2".equalsIgnoreCase(valdatastat) )
								{
									BaseLogger.log("3", userInfo,editorId,"Inside E12EditorHandlerServlet getXMLDataForDetail valdatastat : ["+valdatastat+"]");
									BaseLogger.log("3", userInfo,editorId,"Inside E12EditorHandlerServlet getXMLDataForDetail objContext : ["+objContext+"]");
									BaseLogger.log("3", userInfo,editorId,"Inside E12EditorHandlerServlet getXMLDataForDetail currObjContext : ["+currObjContext+"]");
									BaseLogger.log("3", userInfo,editorId,"Inside E12EditorHandlerServlet getXMLDataForDetail currDomId : ["+currDomId+"]");
									BaseLogger.log("3", userInfo,editorId,"Inside E12EditorHandlerServlet getXMLDataForDetail headerPKFieldValues : ["+headerPKFieldValues+"]");
									BaseLogger.log("3", userInfo,editorId,"Inside E12EditorHandlerServlet getXMLDataForDetail xmlStr : ["+xmlStr+"]");
									retXMLStr = "Invalid row found against domId = " + currDomId + ". So please validate the current row and then add a new one.~~"+currDomId;
									BaseLogger.log("3", userInfo,editorId,"Invalid row found in server side when adding new row :::["+retXMLStr+"]");
									return retXMLStr;
								}
							}
							Node taxcalcstatNode = detailNode.getAttributes().getNamedItem("taxcalcstat");
							if( taxcalcstatNode != null )
							{
								String taxcalcstat = E12GenericUtility.checkNull( taxcalcstatNode.getNodeValue() );
								if( "1".equalsIgnoreCase(taxcalcstat) || "2".equalsIgnoreCase(taxcalcstat) || "3".equalsIgnoreCase(taxcalcstat) )
								{
									BaseLogger.log("3", userInfo,editorId,"Inside E12EditorHandlerServlet getXMLDataForDetail taxcalcstat : ["+taxcalcstat+"]");
									BaseLogger.log("3", userInfo,editorId,"Inside E12EditorHandlerServlet getXMLDataForDetail objContext : ["+objContext+"]");
									BaseLogger.log("3", userInfo,editorId,"Inside E12EditorHandlerServlet getXMLDataForDetail currObjContext : ["+currObjContext+"]");
									BaseLogger.log("3", userInfo,editorId,"Inside E12EditorHandlerServlet getXMLDataForDetail currDomId : ["+currDomId+"]");
									BaseLogger.log("3", userInfo,editorId,"Inside E12EditorHandlerServlet getXMLDataForDetail headerPKFieldValues : ["+headerPKFieldValues+"]");
									BaseLogger.log("3", userInfo,editorId,"Inside E12EditorHandlerServlet getXMLDataForDetail xmlStr : ["+xmlStr+"]");
									retXMLStr = "Tax not calculated against domId = " + currDomId + ". So please validate the current row and then add a new one.~~"+currDomId;
									BaseLogger.log("3", userInfo,editorId,"Invalid row found in server side when adding new row :::["+retXMLStr+"]");
									return retXMLStr;
								}
							}
						}
					}
				}
				//Added By Pankaj T. on 17-02-2021 - added new attributes in detail tag valdatastat, taxcalcstat & id for  checking current record is valid or not at the time of adding new detail - end
				String valXMLStr = (chgStr != null && chgStr.length() > 0)?masterRem.validateAndPerformAction( chgStr, "VAL_DATA" ):""; //$NON-NLS-1$
				boolean isValid = (valXMLStr.indexOf("<Errors>") != -1)?false:true; //$NON-NLS-1$
				if(isValid)
				{
					valXMLStr = (valXMLStr.indexOf("<?xml version=") != -1 ) ? valXMLStr.substring(valXMLStr.indexOf(">") + 1) : valXMLStr; //$NON-NLS-1$ //$NON-NLS-2$
					if( reqParamStr != null && reqParamStr.trim().length() > 0 )
					{
						masterRem.setRequestParamStr(reqParamStr.trim());
					}
					BaseLogger.log("3", userInfo,editorId,"Inside E12EditorHandlerServlet valXMLStr["+valXMLStr+"]");
					retXMLStr = masterRem.getDetailXMLDomString(objName, objContext, editFlag, pkValues, argFieldValues, true);
					BaseLogger.log("3", userInfo,editorId,"retXMLStr ["+retXMLStr+"]"); //$NON-NLS-1$ //$NON-NLS-2$
					
					retXMLStr = (retXMLStr.indexOf("<?xml version=") != -1 ) ? retXMLStr.substring(retXMLStr.indexOf(">") + 1) : retXMLStr; //$NON-NLS-1$ //$NON-NLS-2$
					if(chgStr != null && chgStr.length() > 0)
					{
						retXMLStr = "<?xml version='1.0' encoding='"+userInfo.getCharEnc()+"' ?><Data><ValData>" + valXMLStr + "</ValData>" + retXMLStr + "</Data>"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
					}
					masterRem.setRequestParamStr( null );
				}
				else
				{
					retXMLStr = valXMLStr;
				}
			}
			else
			{
				retXMLStr = Messages.getString("RequestHandlerServlet_notLoggedOrSessionExpired")+"\n"+Messages.getString("RequestHandlerServlet_pleaseReconnectToWork"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}
			if(masterRem != null && editFlag.equals("V")) //$NON-NLS-1$
			{
				masterRem.remove();
				masterRem = null;
			}
		}
		catch (ITMException itme)
		{
			sess.setAttribute( "ERR_MSG", "INVALID_DETAIL_DATA" ); //$NON-NLS-1$ //$NON-NLS-2$
			BaseLogger.log("0", userInfo,editorId,"ITMException :RequestHandlerServlet :getXMLDataForDetail :==>"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			sess.setAttribute( "ERR_MSG", "INVALID_DETAIL_DATA" ); //$NON-NLS-1$ //$NON-NLS-2$
			BaseLogger.log("0", userInfo,editorId,"Exception :RequestHandlerServlet :getXMLDataForDetail :==>"); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return retXMLStr;
	}
	
	//Added by Sandeep on 10-May-16 [[S15LSUN004] for delete action in Transaction Editor ] start
	protected String getXMLDataOnDelete(String objName, String objContext, String editFlag, String pkValues, String chgStr, String argFieldValues, HttpSession sess, String editorId, String reqParamStr , String user, String action, String domID) throws ITMException
	{
		//change by shrutika on 28-01-19 for create local userinfo.
		ibase.utility.UserInfoBean userInfo = ( ibase.utility.UserInfoBean )sess.getAttribute( "USER_INFO" ); //$NON-NLS-1$
		BaseLogger.log("2", userInfo,editorId,"[RequestHandlerServlet]Getting detail xml string on delete for objName :"+objName+":\n\tpkValues :"+pkValues+":\n\targFieldValues :"+argFieldValues); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		String retXMLStr = "";
		try
		{
			//ibase.utility.UserInfoBean userInfo = ( ibase.utility.UserInfoBean )sess.getAttribute( "USER_INFO" ); //$NON-NLS-1$
			//Changed by Prasad on 04/05/17 [Create E12TransEditorCoreModel and keep in session instead of MasterStateful] START
			/*MasterStatefulRemote masterRem = ( MasterStatefulRemote )sess.getAttribute( editorId );
			String tempEditorID = editorId;
			if( editorId != null &&  editorId.indexOf(user) != -1)
			{
				tempEditorID = editorId.substring(0,editorId.indexOf(user));
			}
			if(masterRem == null)
			{
				masterRem = (MasterStatefulRemote)this.ctx.lookup("ibase/MasterStatefulEJB/remote"); //$NON-NLS-1$
				masterRem.setEditorId(tempEditorID);
				if(!editFlag.equals("V")) //$NON-NLS-1$
				{
					sess.setAttribute( editorId, masterRem );
				}
				if(userInfo != null)
				{
					masterRem.setUserInfo(userInfo);
				}
				else
				{
					retXMLStr = Messages.getString("RequestHandlerServlet_notLoggedOrSessionExpired")+"\n"+Messages.getString("RequestHandlerServlet_pleaseReconnectToWork"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				}
			}*/
			E12TransEditorCoreModel transEditorCoreModel = (E12TransEditorCoreModel) sess.getAttribute( editorId );
			if ( transEditorCoreModel == null )
			{
				transEditorCoreModel = new E12TransEditorCoreModel( objName );
				//Changed by Sadique on 10/12/18 [changes for wildfly clustering] START
				//transEditorCoreModel.setSessionCtx( sess );
				transEditorCoreModel.setUserInfo( userInfo );
				//Changed by Sadique on 10/12/18 [changes for wildfly clustering] END
				transEditorCoreModel.setObjName( objName );
				
				sess.setAttribute( editorId, transEditorCoreModel );
			}
			MasterStatefulRemote masterRem = transEditorCoreModel.getMasterStateful();
			//Changed by Prasad on 04/05/17 [Create E12TransEditorCoreModel and keep in session instead of MasterStateful] END
			if( userInfo != null && masterRem != null )
			{
				String tempEditorID = getStatefulEditorId( editorId, user );
				masterRem.setEditorId(tempEditorID);
				//Added by Pratheek on 1/04/2020[ to properly show the line number when drawing the feed in detail screen on the click of servicehandler 3 button]-Start
				masterRem.setCurrentDetailValidated(true);
				//Added by Pratheek on 1/04/2020[ to properly show the line number when drawing the feed in detail screen on the click of servicehandler 3 button]-End
				//Changed by Prasad on 31/01/19 [to validate client and server side data and perform respected action]
				//String valXMLStr = (chgStr != null && chgStr.length() > 0)?masterRem.updateDetailDom(chgStr):""; //$NON-NLS-1$
				String valXMLStr = (chgStr != null && chgStr.length() > 0)?masterRem.validateAndPerformAction( chgStr, "VAL_DATA" ):""; //$NON-NLS-1$
				boolean isValid = (valXMLStr.indexOf("<Errors>") != -1)?false:true; //$NON-NLS-1$
				if(isValid)
				{
					valXMLStr = (valXMLStr.indexOf("<?xml version=") != -1 ) ? valXMLStr.substring(valXMLStr.indexOf(">") + 1) : valXMLStr; //$NON-NLS-1$ //$NON-NLS-2$
					if( reqParamStr != null && reqParamStr.trim().length() > 0 )
					{
						masterRem.setRequestParamStr(reqParamStr.trim());
					}
					
					BaseLogger.log("3", userInfo,editorId,"Inside E12EditorHandlerServlet valXMLStr["+valXMLStr+"]");
					if( !"BLANK_DOM_FOR_ADD".equalsIgnoreCase(action) && !"NEXT".equalsIgnoreCase(action) )
					{
						retXMLStr = masterRem.getDataXML(objContext, domID, "E", "1");
						BaseLogger.log("3", userInfo,editorId,"retXMLStr ["+retXMLStr+"]");
					}
					else if( "NEXT".equalsIgnoreCase(action) )
					{
						if( !"V".equalsIgnoreCase(editFlag) )
						{
							//retXMLStr = masterRem.getDataXML(objContext, domID, "E", "1");
						}
						else
						{
							//retXMLStr = masterRem.getDetailXMLDomString(objName, objContext, editFlag, pkValues, argFieldValues, true);
						}
						//Changed by Sandeep on 28-JUN-16 [[S15LSUN004] New interface for Wizard and Editor] End
						BaseLogger.log("3", userInfo,editorId,"retXMLStr ["+retXMLStr+"]");
					}
					else
					{
						retXMLStr = masterRem.getDataXML(objContext, "1", "A", "1");
						BaseLogger.log("3", userInfo,editorId,"retXMLStr ["+retXMLStr+"]");
					}
					retXMLStr = (retXMLStr.indexOf("<?xml version=") != -1 ) ? retXMLStr.substring(retXMLStr.indexOf(">") + 1) : retXMLStr; //$NON-NLS-1$ //$NON-NLS-2$
					
					if(chgStr != null && chgStr.length() > 0)
					{
						retXMLStr = "<?xml version='1.0' encoding='"+userInfo.getCharEnc()+"' ?><Data>"+ retXMLStr + "</Data>"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
					}
					masterRem.setRequestParamStr( null );
				}
				else
				{
					retXMLStr = valXMLStr;
				}
			}
			else
			{
				retXMLStr = Messages.getString("RequestHandlerServlet_notLoggedOrSessionExpired")+"\n"+Messages.getString("RequestHandlerServlet_pleaseReconnectToWork"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}
			if(masterRem != null && editFlag.equals("V")) //$NON-NLS-1$
			{
				masterRem.remove();
				masterRem = null;
			}
		}
		catch (ITMException itme)
		{
			sess.setAttribute( "ERR_MSG", "INVALID_DETAIL_DATA" ); //$NON-NLS-1$ //$NON-NLS-2$
			BaseLogger.log("0", userInfo,editorId,"ITMException :RequestHandlerServlet :getXMLDataForDetail :==>"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			sess.setAttribute( "ERR_MSG", "INVALID_DETAIL_DATA" ); //$NON-NLS-1$ //$NON-NLS-2$
			BaseLogger.log("0", userInfo,editorId,"Exception :RequestHandlerServlet :getXMLDataForDetail :==>"); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return retXMLStr;
	}
	//Added by Sandeep on 10-May-16 [[S15LSUN004] for delete action in Transaction Editor ] end
	
	protected String getXMLDataOnPrevious(String objName, String objContext, String editFlag, String pkValues, String chgStr, String argFieldValues, HttpSession sess, String editorId, String reqParamStr , String user, String action, String domID) throws ITMException
	{
		//change by shrutika on 28-01-19 for create local userinfo.
		ibase.utility.UserInfoBean userInfo = ( ibase.utility.UserInfoBean )sess.getAttribute( "USER_INFO" ); //$NON-NLS-1$
		BaseLogger.log("2", userInfo,editorId,"[RequestHandlerServlet]Getting detail xml string on previous for objName :"+objName+":\n\tpkValues :"+pkValues+":\n\targFieldValues :"+argFieldValues); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		String retXMLStr = "";
		try
		{
			//ibase.utility.UserInfoBean userInfo = ( ibase.utility.UserInfoBean )sess.getAttribute( "USER_INFO" ); //$NON-NLS-1$
			//Changed by Prasad on 04/05/17 [Create E12TransEditorCoreModel and keep in session instead of MasterStateful] START
			/*MasterStatefulRemote masterRem = ( MasterStatefulRemote )sess.getAttribute( editorId );
			String tempEditorID = editorId;
			if( editorId != null &&  editorId.indexOf(user) != -1)
			{
				tempEditorID = editorId.substring(0,editorId.indexOf(user));
			}
			if(masterRem == null)
			{
				masterRem = (MasterStatefulRemote)this.ctx.lookup("ibase/MasterStatefulEJB/remote"); //$NON-NLS-1$
				masterRem.setEditorId(tempEditorID);
				if(!editFlag.equals("V")) //$NON-NLS-1$
				{
					sess.setAttribute( editorId, masterRem );
				}
				if(userInfo != null)
				{
					masterRem.setUserInfo(userInfo);
				}
				else
				{
					retXMLStr = Messages.getString("RequestHandlerServlet_notLoggedOrSessionExpired")+"\n"+Messages.getString("RequestHandlerServlet_pleaseReconnectToWork"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				}
			}*/
			E12TransEditorCoreModel transEditorCoreModel = (E12TransEditorCoreModel) sess.getAttribute( editorId );
			if ( transEditorCoreModel == null )
			{
				transEditorCoreModel = new E12TransEditorCoreModel( objName );
				//Changed by Sadique on 10/12/18 [changes for wildfly clustering] START
				//transEditorCoreModel.setSessionCtx( sess );
				transEditorCoreModel.setUserInfo( userInfo );
				//Changed by Sadique on 10/12/18 [changes for wildfly clustering] END
				transEditorCoreModel.setObjName( objName );
				
				sess.setAttribute( editorId, transEditorCoreModel );
			}
			MasterStatefulRemote masterRem = transEditorCoreModel.getMasterStateful();
			//Changed by Prasad on 04/05/17 [Create E12TransEditorCoreModel and keep in session instead of MasterStateful] END
			if( userInfo != null && masterRem != null )
			{
				String tempEditorID = getStatefulEditorId( editorId, user );
				masterRem.setEditorId(tempEditorID);
				//Changed by Prasad on 31/01/19 [to validate client and server side data and perform respected action]
				//String valXMLStr = (chgStr != null && chgStr.length() > 0)?masterRem.updateDetailDom(chgStr):""; //$NON-NLS-1$
				String valXMLStr = (chgStr != null && chgStr.length() > 0)?masterRem.validateAndPerformAction( chgStr, "VAL_DATA" ):""; //$NON-NLS-1$
				boolean isValid = (valXMLStr.indexOf("<Errors>") != -1)?false:true; //$NON-NLS-1$
				if(isValid)
				{
					valXMLStr = (valXMLStr.indexOf("<?xml version=") != -1 ) ? valXMLStr.substring(valXMLStr.indexOf(">") + 1) : valXMLStr; //$NON-NLS-1$ //$NON-NLS-2$
					if( reqParamStr != null && reqParamStr.trim().length() > 0 )
					{
						masterRem.setRequestParamStr(reqParamStr.trim());
					}
					
//					BaseLogger.log("3", userInfo,editorId,"Inside E12EditorHandlerServlet valXMLStr["+valXMLStr+"]");
					if( !"V".equalsIgnoreCase( editFlag) )
					{
						BaseLogger.log("3", userInfo,editorId,"inside E12EditorHandlerServlet...3225 objContext["+objContext+"]");
						//Change by Shrutika on 27-04-18 [Start] for avoid blank detail on previous form.
						//retXMLStr = masterRem.getDataXML(objContext, "1", editFlag, "1");
						retXMLStr = masterRem.getCurrentFormDetail(objContext);
						BaseLogger.log("3", userInfo,editorId,"retXMLStr ["+retXMLStr+"]]]]");
					}
					else
					{
						//Added due to issue on previous in view mode
						retXMLStr = masterRem.getDetailXMLDomString(objName, objContext, editFlag, pkValues, argFieldValues, true);
						BaseLogger.log("3", userInfo,editorId,"retXMLStr ["+retXMLStr+"]");
					}
					retXMLStr = (retXMLStr.indexOf("<?xml version=") != -1 ) ? retXMLStr.substring(retXMLStr.indexOf(">") + 1) : retXMLStr; //$NON-NLS-1$ //$NON-NLS-2$
					
					if(chgStr != null && chgStr.length() > 0)
					{
						retXMLStr = "<?xml version='1.0' encoding='"+userInfo.getCharEnc()+"' ?><Data>"+ retXMLStr + "</Data>"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
					}
					masterRem.setRequestParamStr( null );
				}
				else
				{
					retXMLStr = valXMLStr;
				}
			}
			else
			{
				retXMLStr = Messages.getString("RequestHandlerServlet_notLoggedOrSessionExpired")+"\n"+Messages.getString("RequestHandlerServlet_pleaseReconnectToWork"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}
			if(masterRem != null && editFlag.equals("V")) //$NON-NLS-1$
			{
				masterRem.remove();
				masterRem = null;
			}
		}
		catch (ITMException itme)
		{
			sess.setAttribute( "ERR_MSG", "INVALID_DETAIL_DATA" ); //$NON-NLS-1$ //$NON-NLS-2$
			BaseLogger.log("0", userInfo,editorId,"ITMException :RequestHandlerServlet :getXMLDataForDetail :==>"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			sess.setAttribute( "ERR_MSG", "INVALID_DETAIL_DATA" ); //$NON-NLS-1$ //$NON-NLS-2$
			BaseLogger.log("0", userInfo,editorId,"Exception :RequestHandlerServlet :getXMLDataForDetail :==>"); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return retXMLStr;
	}
	
	protected String getChangedData(String chgStr, HttpSession sess, HttpServletRequest request, String editorId, String user) throws ITMException
	{
		String retXMLStr = null;
		//change by shrutika on 28-01-19 for create local userinfo.
		ibase.utility.UserInfoBean userInfo = ( ibase.utility.UserInfoBean )sess.getAttribute( "USER_INFO" ); //$NON-NLS-1$
		try
		{
			//ibase.utility.UserInfoBean userInfo = ( ibase.utility.UserInfoBean )sess.getAttribute( "USER_INFO" ); //$NON-NLS-1$
			//Changed by Prasad on 04/05/17 [Create E12TransEditorCoreModel and keep in session instead of MasterStateful]
			//MasterStatefulRemote masterRem = ( MasterStatefulRemote )sess.getAttribute( editorId+user );
			E12TransEditorCoreModel transEditorCoreModel = (E12TransEditorCoreModel) sess.getAttribute( editorId );
			if ( transEditorCoreModel != null )
			{
				MasterStatefulRemote masterRem = transEditorCoreModel.getMasterStateful();
				//BaseLogger.log("3", userInfo,editorId,"Inside getItemChanged of E12EditorHadler line no 2034");
				if( userInfo != null && masterRem != null )
				{
					masterRem.setEditorId(editorId);
					//Changed by Pankaj T on 04-01-18 [changes for multitenancy]
					masterRem.setUserInfo(userInfo);
					//BaseLogger.log("3", userInfo,editorId,"Inside getItemChanged of E12EditorHadler line no 2038");
					//Changed by Prasad on 31/01/19 [to validate client and server side data and perform respected action]
					//retXMLStr = masterRem.applyItemChange(chgStr);
					retXMLStr = masterRem.validateAndPerformAction( chgStr, "ITEM_CHANGE" );
					//BaseLogger.log("3", userInfo,editorId,"Inside getItemChanged of E12EditorHadler line no 2040");
				}
				else
				{
					//BaseLogger.log("3", userInfo,editorId,"Inside getItemChanged of E12EditorHadler line no 2044");
					retXMLStr = Messages.getString("RequestHandlerServlet_notLoggedOrSessionExpired")+"\n"+Messages.getString("RequestHandlerServlet_pleaseReconnectToWork"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				}
			}
			else
			{
				//BaseLogger.log("3", userInfo,editorId,"Inside getItemChanged of E12EditorHadler line no 2050");
				retXMLStr = Messages.getString("RequestHandlerServlet_notLoggedOrSessionExpired")+"\n"+Messages.getString("RequestHandlerServlet_pleaseReconnectToWork."); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}
		}
		catch (ITMException itme)
		{
			sess.setAttribute( "ERR_MSG", "INVALID_DETAIL_DATA" ); //$NON-NLS-1$ //$NON-NLS-2$
			BaseLogger.log("0", userInfo,editorId,"ITMException :E12EditorHandlerServlet :getChangedData :==>"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			sess.setAttribute( "ERR_MSG", "INVALID_DETAIL_DATA" ); //$NON-NLS-1$ //$NON-NLS-2$
			BaseLogger.log("0", userInfo,editorId,"Exception :E12EditorHandlerServlet :getChangedData :==>"); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return retXMLStr;
	}

	private String validateData( String chgStr, HttpSession sess, String editorId, String editFlag, String saveLevel,String objName, String tranID, MasterStatefulRemote masterRem ) throws ITMException
	{
		String retXMLStr = null;
		boolean isWriteUserActLog =  false ; 
		//change by shrutika on 28-01-19 for create local userinfo.
		ibase.utility.UserInfoBean userInfo = ( ibase.utility.UserInfoBean )sess.getAttribute( "USER_INFO" ); //$NON-NLS-1$
		try
		{
			//ibase.utility.UserInfoBean userInfo = ( ibase.utility.UserInfoBean )sess.getAttribute( "USER_INFO" ); //$NON-NLS-1$
			//Changed by Prasad on 04/05/17 [Create E12TransEditorCoreModel and keep in session instead of MasterStateful]
			//MasterStatefulRemote masterRem = ( MasterStatefulRemote )sess.getAttribute( editorId );
			if (masterRem != null)
			{
				/*String tempEditorID = editorId;
				if( editorId != null &&  editorId.indexOf( userInfo.getLoginCode() ) != -1)
				{
					tempEditorID = editorId.substring(0,editorId.indexOf( userInfo.getLoginCode() ));
				}
				masterRem.setEditorId(tempEditorID);*/
				if(userInfo != null)
				{
					Date startTime = new Date();
					//Changed by Prasad on 31/01/19 [to validate client and server side data and perform respected action]
					//retXMLStr = masterRem.updateDetailDom(chgStr);
					retXMLStr = masterRem.validateAndPerformAction( chgStr, "VAL_DATA" );
					retXMLStr = (retXMLStr == null )? "" : retXMLStr;
					String action1 = "EDIT";
					String eventAction = "";
					if("A".equalsIgnoreCase(editFlag))
					{
						action1 = "ADD";
					}
					if("V".equalsIgnoreCase(editFlag))
					{
						action1 = "VIEW";
					}
					else
					{
						action1 = "EDIT";
					}
					if("EDIT".equalsIgnoreCase(action1) && (tranID == null || tranID.trim().length() == 0))
					{
						action1  = "ADD";
						tranID = masterRem.getTranId();// Added by Dnyaneshwar Chavan 20-Aug-15 [ PRIMARY_KEY tag value should not be null as per Danish Sir ]
					}
					if( retXMLStr.indexOf( "<Root><Detail>Success</Detail></Root>" ) != -1 )
					{
						eventAction = "Abort";
						isWriteUserActLog = true;
					}
					else if( retXMLStr.indexOf( "<MsgOnSave> Transaction is saved. </MsgOnSave>" ) != -1 )
					{
						eventAction = "Save";
						isWriteUserActLog = true;
					}
					BaseLogger.log("3", userInfo,editorId,"Dnyaneshwar :: RequestHandlerServlet : validateData : eventAction["+eventAction+"]");
					if( "Abort".equalsIgnoreCase(eventAction) )
					{
						if( userEventLogEJB != null && userInfo != null )
						{
							///Change by shrutika on 03-12-18 [Start] for updateEventLog.
							//userEventLogEJB.setEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), masterRem.getEditorId(), action1 , eventAction, startTime, new Date(),"saveLvl:[" + saveLevel + "]", tranID);
							//Change by shrutika on 05-01-19 for add exception.
							userEventLogEJB.setEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), masterRem.getEditorId(), action1 , eventAction, startTime, new Date(),"saveLvl:[" + saveLevel + "]", tranID, "Success","SA","");
						}
						else
						{
							BaseLogger.log("3", userInfo,editorId," ============ User info is null then never create event log in validateData() method of RequestHandlerServlet.java file, action is 'DEL_TRANS' ");
						}
					}
				}
				else
				{
					retXMLStr = Messages.getString("RequestHandlerServlet_notLoggedOrSessionExpired")+"\n"+Messages.getString("RequestHandlerServlet_pleaseReconnectToWork."); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				}
			}
			else
			{
				retXMLStr = Messages.getString("RequestHandlerServlet_notLoggedOrSessionExpired")+"\n"+Messages.getString("RequestHandlerServlet_pleaseReconnectToWork."); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}
			if ( editFlag == null && saveLevel == null )
			{
				Document xmlStrDoc = null;
				if(chgStr != null && !chgStr.equalsIgnoreCase("-1")) //$NON-NLS-1$
				{
					xmlStrDoc =  new E12GenericUtility().parseString( chgStr );
					if(xmlStrDoc.getElementsByTagName("saveLevel").item(0) != null) //$NON-NLS-1$
					{
						if(xmlStrDoc.getElementsByTagName("saveLevel").item(0).getFirstChild() != null) //$NON-NLS-1$
						{
							saveLevel = ((String)xmlStrDoc.getElementsByTagName("saveLevel").item(0).getFirstChild().getNodeValue()).trim(); //$NON-NLS-1$
						}
					}
					if(xmlStrDoc.getElementsByTagName("editFlag").item(0) != null) //$NON-NLS-1$
					{
						if(xmlStrDoc.getElementsByTagName("editFlag").item(0).getFirstChild() != null) //$NON-NLS-1$
						{
							editFlag = ((String)xmlStrDoc.getElementsByTagName("editFlag").item(0).getFirstChild().getNodeValue()).trim(); //$NON-NLS-1$
						}
					}
				}
			}
			if( isWriteUserActLog && masterRem != null )
			{
				if( userInfo != null )
				{
					EventLogInfoBean eventInfoBean = new EventLogInfoBean(userInfo.getLoginCode());
					eventInfoBean.removeEditorActivity(objName, userInfo.getSesstionId(), masterRem.getEditorId(), userInfo.getTransDB());
				}
				else
				{
					BaseLogger.log("3", userInfo,editorId," ============ User info is null then never created event log in ITMValidatorServlet.java file");
				}
				try 
				{
					masterRem.remove();
					masterRem = null;
				} 
				catch ( javax.ejb.NoSuchEJBException exception ) 
				{
					BaseLogger.log("3", userInfo,editorId, " ReuestHandlerServlet :: validateData :  IN CATCH BLOCK " );
				}
			}//[removing MasterStatefulRemote instance As per KB].End
		}
		catch (ITMException itme)
		{
			sess.setAttribute( "ERR_MSG", "INVALID_DETAIL_DATA" ); //$NON-NLS-1$ //$NON-NLS-2$
			BaseLogger.log("0", userInfo,editorId,"ITMException :RequestHandlerServlet :validateData :==>"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			sess.setAttribute( "ERR_MSG", "INVALID_DETAIL_DATA" ); //$NON-NLS-1$ //$NON-NLS-2$
			BaseLogger.log("0", userInfo,editorId,"Exception :RequestHandlerServlet :validateData :==>"); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return retXMLStr;
	}
	
	//change by shrutika on 28-01-19 for multiple activities are not update due to global userinfo.
	//protected String getSavedTransId(String parseString) throws ITMException
	protected String getSavedTransId(String parseString, UserInfoBean userInfo) throws ITMException
	{
		String refId = ""; //$NON-NLS-1$
		try
		{
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			DocumentBuilder db = dbf.newDocumentBuilder();
			Document doc = db.parse(new ByteArrayInputStream(parseString.getBytes()));
			Node tranIdNode = doc.getElementsByTagName("TranID").item(0); //$NON-NLS-1$
			if(tranIdNode != null && tranIdNode.getFirstChild() != null && tranIdNode.getFirstChild().getNodeValue() != null)
			{
				refId = tranIdNode.getFirstChild().getNodeValue();
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,null,"Exception :RequestHandlerServlet :getSavedTransId :==>"); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return refId;
	}
	
	protected String getDetailData(String objName, String objContext, String editFlag, String pkValues, String chgStr, String argFieldValues, HttpSession sess, String editorId, String reqParamStr , String user, String action, String domID) throws ITMException
	{
		//change by shrutika on 28-01-19 for create local userinfo.
		ibase.utility.UserInfoBean userInfo = ( ibase.utility.UserInfoBean )sess.getAttribute( "USER_INFO" ); //$NON-NLS-1$
		String retXMLStr = "";
		try
		{
			//ibase.utility.UserInfoBean userInfo = ( ibase.utility.UserInfoBean )sess.getAttribute( "USER_INFO" ); //$NON-NLS-1$
			//Changed by Prasad on 04/05/17 [Create E12TransEditorCoreModel and keep in session instead of MasterStateful] START
			/*MasterStatefulRemote masterRem = ( MasterStatefulRemote )sess.getAttribute( editorId );
			String tempEditorID = editorId;
			if( editorId != null &&  editorId.indexOf(user) != -1)
			{
				tempEditorID = editorId.substring(0,editorId.indexOf(user));
			}
			if(masterRem == null)
			{
				masterRem = (MasterStatefulRemote)this.ctx.lookup("ibase/MasterStatefulEJB/remote"); //$NON-NLS-1$
				masterRem.setEditorId(tempEditorID);
				if(!editFlag.equals("V")) //$NON-NLS-1$
				{
					sess.setAttribute( editorId, masterRem );
				}
				if(userInfo != null)
				{
					masterRem.setUserInfo(userInfo);
				}
				else
				{
					retXMLStr = Messages.getString("RequestHandlerServlet_notLoggedOrSessionExpired")+"\n"+Messages.getString("RequestHandlerServlet_pleaseReconnectToWork"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				}
			}*/
			E12TransEditorCoreModel transEditorCoreModel = (E12TransEditorCoreModel) sess.getAttribute( editorId );
			if ( transEditorCoreModel == null )
			{
				transEditorCoreModel = new E12TransEditorCoreModel( objName );
				//Changed by Sadique on 10/12/18 [changes for wildfly clustering] START
				//transEditorCoreModel.setSessionCtx( sess );
				transEditorCoreModel.setUserInfo( userInfo );
				//Changed by Sadique on 10/12/18 [changes for wildfly clustering] END
				transEditorCoreModel.setObjName( objName );
				
				sess.setAttribute( editorId, transEditorCoreModel );
			}
			MasterStatefulRemote masterRem = transEditorCoreModel.getMasterStateful();
			//Changed by Prasad on 04/05/17 [Create E12TransEditorCoreModel and keep in session instead of MasterStateful] END
			if( userInfo != null && masterRem != null )
			{
				String tempEditorID = getStatefulEditorId( editorId, user );
				masterRem.setEditorId(tempEditorID);
				String valXMLStr = ""; //$NON-NLS-1$
				//boolean isValid = (valXMLStr.indexOf("<Errors>") != -1)?false:true; //$NON-NLS-1$
				//if(isValid)
				//{
					//valXMLStr = (valXMLStr.indexOf("<?xml version=") != -1 ) ? valXMLStr.substring(valXMLStr.indexOf(">") + 1) : valXMLStr; //$NON-NLS-1$ //$NON-NLS-2$
					if( reqParamStr != null && reqParamStr.trim().length() > 0 )
					{
						masterRem.setRequestParamStr(reqParamStr.trim());
					}
//					BaseLogger.log("3", userInfo,editorId,"Inside E12EditorHandlerServlet valXMLStr["+valXMLStr+"]");
					//if( !"BLANK_DOM_FOR_ADD".equalsIgnoreCase(action) && !"NEXT".equalsIgnoreCase(action) )
					//{
						retXMLStr = masterRem.getDataXML(objContext, domID, "E", "1");
						BaseLogger.log("3", userInfo,editorId,"retXMLStr ["+retXMLStr+"]");
					//}
					/*else if( "NEXT".equalsIgnoreCase(action) )
					{
						if( !"V".equalsIgnoreCase(editFlag) )
						{
							//retXMLStr = masterRem.getDataXML(objContext, domID, "E", "1");
						}
						else
						{
							//retXMLStr = masterRem.getDetailXMLDomString(objName, objContext, editFlag, pkValues, argFieldValues, true);
						}
						//Changed by Sandeep on 28-JUN-16 [[S15LSUN004] New interface for Wizard and Editor] End
						BaseLogger.log("3", userInfo,editorId,"retXMLStr ["+retXMLStr+"]");
					}
					else
					{
						retXMLStr = masterRem.getDataXML(objContext, "1", "A", "1");
						BaseLogger.log("3", userInfo,editorId,"retXMLStr ["+retXMLStr+"]");
					}*/
					retXMLStr = (retXMLStr.indexOf("<?xml version=") != -1 ) ? retXMLStr.substring(retXMLStr.indexOf(">") + 1) : retXMLStr; //$NON-NLS-1$ //$NON-NLS-2$
					
					if(chgStr != null && chgStr.length() > 0)
					{
						retXMLStr = "<?xml version='1.0' encoding='"+userInfo.getCharEnc()+"' ?><Data>"+ retXMLStr + "</Data>"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
					}
					masterRem.setRequestParamStr( null );
				//}
			}
			else
			{
				retXMLStr = Messages.getString("RequestHandlerServlet_notLoggedOrSessionExpired")+"\n"+Messages.getString("RequestHandlerServlet_pleaseReconnectToWork"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}
			if(masterRem != null && editFlag.equals("V")) //$NON-NLS-1$
			{
				masterRem.remove();
				masterRem = null;
			}
		}
		catch (ITMException itme)
		{
			sess.setAttribute( "ERR_MSG", "INVALID_DETAIL_DATA" ); //$NON-NLS-1$ //$NON-NLS-2$
			BaseLogger.log("0", userInfo,editorId,"ITMException :RequestHandlerServlet :getXMLDataForDetail :==>"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			sess.setAttribute( "ERR_MSG", "INVALID_DETAIL_DATA" ); //$NON-NLS-1$ //$NON-NLS-2$
			BaseLogger.log("0", userInfo,editorId,"Exception :RequestHandlerServlet :getXMLDataForDetail :==>"); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return retXMLStr;
	}
	//Change done by Sandeep S. on 26/09/16 [To display promt or warning alert mesage] End
	
	//Added by Sandeep S. on 2-11-16 [[S16EBAS019]To implement multiple layouts in Editor]Start
	//change by shrutika on 28-01-19 for multiple activities are not update due to global userinfo.
	//protected String getDetailDataForBrowser(String objName, String objContext, String editFlag, String pkValues, String chgStr, String argFieldValues, HttpSession sess, String coreMdlId, String reqParamStr , String user, String action, String domID, int noOfForms, HttpServletRequest request, String editorId, String deafultEditor) throws ITMException
	protected String getDetailDataForBrowser(String objName, String objContext, String editFlag, String pkValues, String chgStr, String argFieldValues, HttpSession sess, String coreMdlId, String reqParamStr , String user, String action, String domID, int noOfForms, HttpServletRequest request, String editorId, String deafultEditor, UserInfoBean userInfo) throws ITMException
	{
		String retXMLStr = "";
		try
		{
			ITMTransactionCoreModel itmTransCoreMdl = (ITMTransactionCoreModel) sess.getAttribute(request.getParameter("CORE_MDL_ID"));
			BaseLogger.log("3", userInfo,editorId,"Session attributes==>"+sess.getAttribute(request.getParameter("CORE_MDL_ID")));
			/*Enumeration e = sess.getAttributeNames();
		    while (e.hasMoreElements()) {
		      String name = (String) e.nextElement();
		      BaseLogger.log("3", userInfo,editorId,name + ": " + sess.getAttribute(name) + "\n");
		    }*/
			if( itmTransCoreMdl == null )
			{
				BaseLogger.log("3", userInfo,editorId,"ITMTransactionCoreModel can not get from sess");
				//Change by Sandeep S. on 2/12/16 [To open transaction in default editor layout] start
				itmTransCoreMdl = new ITMTransactionCoreModel();
				//Changed by Sadique on 10/12/18 [changes for wildfly clustering] START
				//itmTransCoreMdl.setSessionContext(sess);
				itmTransCoreMdl.setObjName(objName);
				itmTransCoreMdl.setUserInfo( userInfo );
				ITMTransactionHeaderModel itmTransHdrMdl = (ITMTransactionHeaderModel) sess.getAttribute( "itmTransHdrMdl" );
				if ( itmTransHdrMdl != null )
				{
					itmTransCoreMdl.setITMFilterModel( itmTransHdrMdl.getITMFilterModel() );
				}
				//Changed by Sadique on 10/12/18 [changes for wildfly clustering] END

				sess.setAttribute(coreMdlId, itmTransCoreMdl);
			}
			itmTransCoreMdl.getMasterStateful().setEditorId(""+coreMdlId);
  			itmTransCoreMdl.setCoreModelId(Integer.parseInt(coreMdlId));
  			itmTransCoreMdl.setPKValues(pkValues);
  			itmTransCoreMdl.setEditFlag(editFlag);
  			//Added by Prasad on 16/10/19 [To set plan date for Editor in GWT Calendar]Start
  			itmTransCoreMdl.getMasterStateful().setPlanDate(plan_Date);
  			itmTransCoreMdl.getMasterStateful().setCalComp(Cal_Comp);
  			//Added by Prasad on 16/10/19 [To set plan date for Editor in GWT Calendar]Start
  			
  			//Changed by Prasad on 04/05/17 [Create E12TransEditorCoreModel and keep in session instead of MasterStateful] START
  			//ibase.utility.UserInfoBean userInfo = ( ibase.utility.UserInfoBean )sess.getAttribute( "USER_INFO" );
  			E12TransEditorCoreModel transEditorCoreModel = (E12TransEditorCoreModel) sess.getAttribute( editorId );
			if ( transEditorCoreModel == null )
			{
				transEditorCoreModel = new E12TransEditorCoreModel( objName );
				//Changed by Sadique on 10/12/18 [changes for wildfly clustering] START
				//transEditorCoreModel.setSessionCtx( sess );
				transEditorCoreModel.setUserInfo( userInfo );
				//Changed by Sadique on 10/12/18 [changes for wildfly clustering] END
				transEditorCoreModel.setMasterStateful( itmTransCoreMdl.getMasterStateful() );
				transEditorCoreModel.setObjName( objName );
				
				sess.setAttribute( editorId, transEditorCoreModel );
			}
			MasterStatefulRemote masterRem = transEditorCoreModel.getMasterStateful();
  			//MasterStatefulRemote masterRem = ( MasterStatefulRemote )sess.getAttribute( editorId );
  			//Commented by Prasad on 02/05/17 [unused code as MasterStatefulRemote is getting from ITMTransactionCoreModel]
  			/*String tempEditorID = editorId;
			if( editorId != null &&  editorId.indexOf(user) != -1)
			{
				tempEditorID = editorId.substring(0,editorId.indexOf(user));
			}*/
  			/*if(masterRem == null)
			{
				//masterRem = (MasterStatefulRemote)this.ctx.lookup("ibase/MasterStatefulEJB/remote"); //$NON-NLS-1$
				//masterRem.setEditorId(tempEditorID);
				if(!editFlag.equals("V")) //$NON-NLS-1$
				{
					//sess.setAttribute( editorId, masterRem );
					BaseLogger.log("3", userInfo,editorId,"set masterRem in session for editorId "+editorId);
					sess.setAttribute( editorId, itmTransCoreMdl.masterStateful );
				}
				if(userInfo != null)
				{
					masterRem.setUserInfo(userInfo);
				}
				else
				{
					retXMLStr = Messages.getString("RequestHandlerServlet_notLoggedOrSessionExpired")+"\n"+Messages.getString("RequestHandlerServlet_pleaseReconnectToWork"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				}
				if(userInfo == null)
				{
					retXMLStr = Messages.getString("RequestHandlerServlet_notLoggedOrSessionExpired")+"\n"+Messages.getString("RequestHandlerServlet_pleaseReconnectToWork"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				}
			}*/
  			
  			int cnt = 0;
  			int pos = 0;
  			int lastPos = 0;
  			String xmlString = "";
  			StringBuffer xmlStringBuff = new StringBuffer();
  			//itmTransCoreMdl.masterStateful.setTransInfo(pkValues, argFieldValues);
  			//itmTransCoreMdl.masterStateful.setEditFlag(editFlag);
  			//itmTransCoreMdl.masterStateful.setLocalEditFlag(editFlag);
  			//itmTransCoreMdl.masterStateful.getContextTitlesList(objName);
  			if( "false".equalsIgnoreCase(deafultEditor) )
  			{
  				/*if( "E".equalsIgnoreCase(editFlag)  )
  				{
					//xmlString = masterRem.getDetailXMLDomString(objName, objContext, editFlag, pkValues, argFieldValues, true);
					//xmlString =itmTransCoreMdl.masterStateful.getDetailXMLDomString(objName, objContext, editFlag, pkValues, argFieldValues, true);
  				}*/
  				//else
  				//{
  				for (cnt = 1; cnt <= noOfForms; cnt++) 
  				{
  					//xmlString = masterDataStatefulLocal.getBlankDomForAdd(objName, "" + cnt, pageContext, null, userInfo.toString(), getEditor());
  					if( !"V".equalsIgnoreCase(editFlag) )
  					{
  						xmlString = checkNull( itmTransCoreMdl.getXMLData(""+cnt, "E", "1", reqParamStr) );
  					}
  					else
  					{
  						xmlString = checkNull( itmTransCoreMdl.getXMLData(""+cnt, editFlag, "1", reqParamStr) );
  					}

  					/*if( !"V".equalsIgnoreCase(editFlag) && xmlString.indexOf( "<Detail"+cnt ) == -1)
					{
						xmlString = checkNull( itmTransCoreMdl.getXMLData(""+cnt, "A", "1", reqParamStr) );
					}*/
  					if (cnt == 1) 
  					{
  						xmlStringBuff = xmlStringBuff.append(xmlString);
  					}
  					else 
  					{
  						if( !"".equalsIgnoreCase( xmlString ) )
  						{
  							pos = xmlString.indexOf("<Detail");
  							if( pos != -1 )
  							{
  								lastPos = xmlString.lastIndexOf("</Header0>");
  								xmlString = xmlString.substring(pos, lastPos);
  								lastPos = xmlStringBuff.lastIndexOf("</Header0>");
  								xmlStringBuff.insert(lastPos, xmlString);
  							}
  						}
  					}

  					if( xmlStringBuff.indexOf("domID=\"\"") != -1 )
  					{
  						pos = xmlStringBuff.indexOf("domID=\"\"");
  						xmlStringBuff.insert(pos + 7, "1");
  					}
  				}
  				xmlString = xmlStringBuff.toString();
  				//}
  			}
  			else
  			{  				
  				if( reqParamStr != null && reqParamStr.trim().length() > 0 )
				{
  					itmTransCoreMdl.getMasterStateful().setRequestParamStr(reqParamStr.trim());
				}
  				//{
					//xmlString = masterRem.getDetailXMLDomString(objName, objContext, editFlag, pkValues, argFieldValues, true);
  					xmlString = itmTransCoreMdl.getMasterStateful().getDetailXMLDomString(objName, objContext, editFlag, pkValues, argFieldValues, true);
				//}
				BaseLogger.log("3", userInfo,editorId,"xmlString ["+xmlString+"]");
				itmTransCoreMdl.getMasterStateful().setRequestParamStr( null );
  			}
  			//Added by Ravindra on 06/09/2021 [restore transaction related point] START
  			chgStr = checkNull( chgStr );
			BaseLogger.log( "3", userInfo, editorId, "chgStr ["+ chgStr +"]" );
			if ( chgStr.length() > 0 )
			{
				xmlString = chgStr;
			}
			//Added by Ravindra on 06/09/2021 [restore transaction related point] END
  			retXMLStr = xmlString;
			if( !"".equalsIgnoreCase(retXMLStr) && masterRem != null )
			{
				itmTransCoreMdl.getMasterStateful().setData(retXMLStr);
			}
			//BaseLogger.log("3", userInfo,editorId,"Inside getDetailDataForBrowser ==>["+retXMLStr+"]");
		}
		catch (ITMException itme)
		{
			sess.setAttribute( "ERR_MSG", "INVALID_DETAIL_DATA" ); //$NON-NLS-1$ //$NON-NLS-2$
			BaseLogger.log("0", userInfo,editorId,"ITMException :RequestHandlerServlet :getXMLDataForDetail :==>"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			sess.setAttribute( "ERR_MSG", "INVALID_DETAIL_DATA" ); //$NON-NLS-1$ //$NON-NLS-2$
			BaseLogger.log("0", userInfo,editorId,"Exception :RequestHandlerServlet :getXMLDataForDetail :==>"); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return retXMLStr;
	}
	
	protected String setData(String objName, String editorId, HttpSession sess, String user, String coreMdlId, String xmlStr, String chgStr, String editFlag, String objContext, String domId, String isFormDirty)throws ITMException
	{
		//change by shrutika on 28-01-19 for create local userinfo.
		String retXMLStr = "";
		ibase.utility.UserInfoBean userInfo = ( ibase.utility.UserInfoBean )sess.getAttribute( "USER_INFO" );
		try
		{
			//ibase.utility.UserInfoBean userInfo = ( ibase.utility.UserInfoBean )sess.getAttribute( "USER_INFO" );
			//Commented by Prasad on 02/05/17 [unused code as MasterStatefulRemote is getting from ITMTransactionCoreModel]
			/*MasterStatefulRemote masterRem = ( MasterStatefulRemote )sess.getAttribute( editorId );
			String tempEditorID = editorId;
			if( editorId != null &&  editorId.indexOf(user) != -1)
			{
				tempEditorID = editorId.substring(0,editorId.indexOf(user));
			}*/
			ITMTransactionCoreModel itmTransCoreMdl = ( ITMTransactionCoreModel )sess.getAttribute( coreMdlId );
			if ( itmTransCoreMdl != null )
			{
				itmTransCoreMdl.masterStateful.setEditorId(coreMdlId);
				itmTransCoreMdl.masterStateful.setEditFlag(editFlag);
				itmTransCoreMdl.masterStateful.setLocalEditFlag(editFlag);
				//itmTransCoreMdl.masterStateful.setUserInfo( userInfo.toString(),xmlStr );
				itmTransCoreMdl.masterStateful.setUserInfo(userInfo);
				itmTransCoreMdl.masterStateful.getContextTitlesList(objName);
				//Change by Sandeep S. on 2/12/16 [To open transaction in default editor layout] end
				String valXMLStr = "";
				if( !"V".equalsIgnoreCase(editFlag) && ( !"".equalsIgnoreCase(isFormDirty) && "true".equalsIgnoreCase(isFormDirty) ) )
				{
					//Changed by Prasad on 31/01/19 [to validate client and server side data and perform respected action]
					//valXMLStr = (chgStr != null && chgStr.length() > 0)?itmTransCoreMdl.masterStateful.updateDetailDom(chgStr):""; //$NON-NLS-1$
					valXMLStr = (chgStr != null && chgStr.length() > 0)?itmTransCoreMdl.masterStateful.validateAndPerformAction( chgStr, "VAL_DATA" ):""; //$NON-NLS-1$
				}
				//Commented by Prasad on 02/05/17 [Not required to set data] START
				/*boolean isValid = (valXMLStr.indexOf("<Errors>") != -1) ? false : true; //$NON-NLS-1$
				if( isValid )
				{
					if( !"".equals(xmlStr) )
					{
						itmTransCoreMdl.masterStateful.setData(xmlStr);
						//masterRem.setData(xmlStr);
					}
				}*/
				//Commented by Prasad on 02/05/17 [Not required to set data] END
				retXMLStr = valXMLStr;
			}
		}
		/*catch (ITMException itme)
		{
			sess.setAttribute( "ERR_MSG", "INVALID_DETAIL_DATA" ); //$NON-NLS-1$ //$NON-NLS-2$
			BaseLogger.log("3", userInfo,editorId,"ITMException :RequestHandlerServlet :getXMLDataForDetail :==>"); //$NON-NLS-1$
			throw itme;
		}*/
		catch (Exception e)
		{
			sess.setAttribute( "ERR_MSG", "INVALID_DETAIL_DATA" ); //$NON-NLS-1$ //$NON-NLS-2$
			BaseLogger.log("0", userInfo,editorId,"Exception :RequestHandlerServlet :setData :==>"); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return retXMLStr;
	}
	//Added by Sandeep S. on 2-11-16 [[S16EBAS019]To implement multiple layouts in Editor]End
	//Create new servlet by Sandeep on 12-APR-16 [[S15LSUN004] for new Interface of wizard and transaction editor] End
	//Added by Prasad on 29/07/16 [for adding follow up actions] START
	/**
	 * Add follow up actions
	 * 
	 * @param userId
	 * @param editorId
	 * @param tranId
	 * @param objName
	 * @param transDB 
	 */
	 //Changed by Pankaj T on 04-01-18 [changes for multitenancy]
	private void addFollowUpAction( String userId, String editorId, String tranId, String objName, UserInfoBean userInfo )
	{
		try 
		{
			String pendingWrkflwMapKey = userId + "~" + editorId;
			String pendingWrkflwMapValue = objName + "~" + tranId;
			Map<String, String> pendingWrkflwMap = new HashMap<String, String>();
			if ( servletContext.getAttribute( "pendingWrkflwMap" ) != null )
			{
				pendingWrkflwMap = (Map<String, String>) servletContext.getAttribute( "pendingWrkflwMap" );
				if ( pendingWrkflwMap != null )
				{
					pendingWrkflwMap.put( pendingWrkflwMapKey, pendingWrkflwMapValue );
				}
				AppConnectParm appConnect = new AppConnectParm();
				InitialContext ctx = new InitialContext( appConnect.getProperty() );
				// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [START]
				//E12FollowUpActionLocal followUpActionLocal = (E12FollowUpActionLocal) ctx.lookup( "ibase/E12FollowUpActionEJB/local" );
				E12FollowUpActionEJB followUpActionLocal = new E12FollowUpActionEJB();
				// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [END]
				//Changed by Pankaj T on 04-01-18 [changes for multitenancy]
				followUpActionLocal.followUpAction( pendingWrkflwMapKey, servletContext, userInfo );
			}
			BaseLogger.log("3", userInfo,editorId,"pendingWrkflwMap - "+ servletContext.getAttribute( "pendingWrkflwMap" ));
		}
		catch (Exception e) 
		{
			BaseLogger.log("0", userInfo,editorId, "Exception - "+ e.getMessage() );
			e.printStackTrace();
		}
	}
	//Added by Prasad on 29/07/16 [for adding follow up actions] END

	//Added by suraj on 3-may-17[Start-for notification ]
	//change by shrutika on 28-01-19 for create local userinfo.
	//private InitialContext getInitialContext() throws ITMException
	private InitialContext getInitialContext( UserInfoBean userInfo ) throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			BaseLogger.log("3", userInfo,null,"In try block of NotificationScheduleJB:getInitialContext Method.");
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext( appConnect.getProperty() );
		}
		catch( ITMException itme )
		{
			BaseLogger.log("0", userInfo,null, "ITMException : getInitialContext : "+ itme.getMessage() );
			throw itme;
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,null, "Exception : getInitialContext : "+ e.getMessage() );
			throw new ITMException(e);
		}
		return ctx;
	}
	//Added by suraj on 3-may-17[End-for notification ]
	
	//Added by Prasad on 02/05/17 [Get masterStateful editorId] START
	private String getStatefulEditorId( String editorId, String userId )
	{
		String tempEditorID = editorId;
		if( editorId != null &&  editorId.indexOf( userId ) != -1)
		{
			tempEditorID = editorId.substring(0,editorId.indexOf(userId));
		}
		return tempEditorID;
	}
	//Added by Prasad on 02/05/17 [Get masterStateful editorId] END
	
	//Added By Ajinkya Darvesh on 11/07/2017 [To get header data into detail for popup column] [START]
	//change by shrutika on 28-01-19 for multiple activities are not update due to global userinfo.
	//private String getDetailDomData(HttpServletRequest request, String editorId, String user)
	private String getDetailDomData(HttpServletRequest request, String editorId, String user, UserInfoBean userInfo)
	{
		HttpSession sess = null;
		String retXMLStr = null;
		try
		{
			sess = request.getSession();
			BaseLogger.log("3", userInfo,editorId, "In getDetailDomData" );

			ibase.utility.UserInfoBean userInfobean = ( ibase.utility.UserInfoBean )sess.getAttribute( "USER_INFO" ); //$NON-NLS-1$
			//Changed by Prasad on 11/05/17 [to get data from core model] START
			//MasterStatefulRemote masterRem = ( MasterStatefulRemote )sess.getAttribute( editorID+user );
			String tempEditorID = editorId;
			editorId = editorId + user;
			MasterStatefulRemote masterRem = null;
			if ( sess.getAttribute( editorId ) instanceof MasterStatefulRemote )
			{
				masterRem = ( MasterStatefulRemote ) sess.getAttribute( editorId );
			}
			else if ( sess.getAttribute( tempEditorID ) instanceof ITMTransactionCoreModel )
			{
				ITMTransactionCoreModel transactionCoreModel = ( ITMTransactionCoreModel ) sess.getAttribute( tempEditorID );
				if ( transactionCoreModel != null )
				{
					masterRem = transactionCoreModel.getMasterStateful();
				}
			}
			else if ( sess.getAttribute( editorId ) instanceof E12TransEditorCoreModel )
			{
				E12TransEditorCoreModel transEditorCoreModel = ( E12TransEditorCoreModel ) sess.getAttribute( editorId );
				if ( transEditorCoreModel != null )
				{
					masterRem = transEditorCoreModel.getMasterStateful();
				}
			}
			if ( masterRem != null && userInfobean != null )
			{
				BaseLogger.log("3", userInfo,editorId,"Inside getAutoSearchDomData of E12EditorHadler line no 2038");
				retXMLStr = masterRem.getDetailDomData();
				BaseLogger.log("3", userInfo,editorId,"Inside retXMLStr["+retXMLStr+"]");
			}
			//Changed by Prasad on 11/05/17 [to get data from core model] END
		}
		catch (Exception e)
		{
			retXMLStr = null;
			BaseLogger.log("0", userInfo,editorId,"Exception :getDetailDomData :==>"+ e.getMessage()); //$NON-NLS-1$
		}
		return retXMLStr;
	}
	//Added By Ajinkya Darvesh on 11/07/2017 [To get header data into detail for popup column] [END]
	
	private String getSummaryXMLString(String finalKey, String objName, UserInfoBean userInfo) {
		String userID = userInfo.getLoginCode();
		
		String xmlData = "";
		String webSocketXMLData = "";
		
		//Changed by Prasad on 23/11/2020 [check infinispanLocalObj not null]
		if (CommonConstants.CACHE_OPT != 0 && infinispanLocalObj != null ) {
			if (infinispanLocalObj != null) {
				BaseLogger.log("3", userInfo, null, "Getting values inside infinispan object [" + finalKey + "]");
				xmlData = infinispanLocalObj.getFormData(finalKey);
				infinispanLocalObj.remove(finalKey);
				
				webSocketXMLData = new E12GenericUtility().editWebSocketXml(xmlData);
				xmlData = objName + "~" + E12GenericUtility.checkNull(webSocketXMLData);
			}
		} else {
			if (RAHandler.getUserRATO().containsKey(userID)) {
				ArrayList<RAHandlerTO> raHandlerTOs = RAHandler.getUserRATO().get(userID);
				
				if (raHandlerTOs != null && !raHandlerTOs.isEmpty()) {
					RAHandlerTO raHandlerTO = new RAHandlerTO();
					raHandlerTO = raHandlerTOs.get(raHandlerTOs.size() - 1);
					String object = E12GenericUtility.checkNull(raHandlerTO.getObject());
					
					webSocketXMLData = new E12GenericUtility().editWebSocketXml(E12GenericUtility.checkNull(raHandlerTO.getData()));
					xmlData = object + "~" + E12GenericUtility.checkNull(webSocketXMLData);
				}
			}
		}
		
		return xmlData;
	}
	
	//Added by shrutika on 05-06-2020 [Start] for validation in case of extract template.
	private String currentDomIdData( String chgStr, String objContext, String domId, String objName, String editFlag )
	{
		try 
		{
			Node detailNode = null;
			E12GenericUtility gn = new E12GenericUtility();
			detailNode = gn.searchNode( gn.parseString( chgStr ), objContext, domId);
			String currenFormStr = gn.serializeDom(detailNode);
			
			chgStr = "<?xml version='1.0' encoding='UTF-8'?>" + 
					"<Root>"+
					"<header>"+
					"<objName><![CDATA["+objName+"]]></objName>"+
					"<pageContext><![CDATA[2]]></pageContext>"+
					"<objContext><![CDATA["+objContext+"]]></objContext>"+
					"<editFlag><![CDATA["+editFlag+"]]></editFlag>"+
					"<focusedColumn><![CDATA[]]></focusedColumn>"+
					"<elementName><![CDATA[false]]></elementName>" + 
					"<keyValue><![CDATA["+domId+"]]></keyValue>"+
					"<taxKeyValue><![CDATA["+domId+"]]></taxKeyValue>"+
					"<saveLevel><![CDATA[0]]></saveLevel>"+
					"<forcedSave><![CDATA[false]]></forcedSave>"+
					"<taxInFocus><![CDATA[false]]></taxInFocus>"+
					"</header>"+
					currenFormStr+
					"</Root>";
			
			return chgStr;
		} catch (ITMException e) {
			BaseLogger.log("0",null,null,"Exception inside currentDomIdData :==>"+e);
			e.printStackTrace();
			return chgStr;
		}
	}
	//Added by shrutika on 05-06-2020 [End] for validation in case of extract template.
	
	//Added by shrutika on 26-10-2020 [Start] for finish functionality in extract template.
	private String currentDomIdDataforFinsih( String chgStr, String objContext, String domId, String objName, String editFlag )
	{
		try 
		{
			Node detailNode = null;
			E12GenericUtility gn = new E12GenericUtility();
			detailNode = gn.searchNode( gn.parseString( chgStr ), objContext, domId);
			String currenFormStr = gn.serializeDom(detailNode);
			
			chgStr = "<?xml version='1.0' encoding='UTF-8'?>" + 
					"<Root>"+
					"<header>"+
					"<objName><![CDATA["+objName+"]]></objName>"+
					"<pageContext><![CDATA[1]]></pageContext>"+
					"<objContext><![CDATA["+objContext+"]]></objContext>"+
					"<editFlag><![CDATA["+editFlag+"]]></editFlag>"+
					"<focusedColumn><![CDATA[]]></focusedColumn>"+
					"<elementName><![CDATA[]]></elementName>" + 
					"<keyValue><![CDATA["+domId+"]]></keyValue>"+
					"<taxKeyValue><![CDATA[]]></taxKeyValue>"+
					"<saveLevel><![CDATA[1]]></saveLevel>"+
					"<forcedSave><![CDATA[false]]></forcedSave>"+
					"<taxInFocus><![CDATA[false]]></taxInFocus>"+
					"<forcedconfirm><![CDATA[false]]></forcedconfirm>" + 
					"<isSaveNConitinue><![CDATA[false]]></isSaveNConitinue>"+
					"</header>"+
					currenFormStr+
					"</Root>";
			
			return chgStr;
		} catch (ITMException e) {
			BaseLogger.log("0",null,null,"Exception inside currentDomIdData :==>"+e);
			e.printStackTrace();
			return chgStr;
		}
	}
	//Added by shrutika on 26-10-2020 [Start] for finish functionality in extract template.
}