package com.testing;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.sql.Types;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;

import javax.annotation.Resource;
import javax.ejb.Remove;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.ejb.CommonDBAccessEJB;
import ibase.hibernate.bean.ObjUserPref;
import ibase.hibernate.dao.ObjUserPrefDao;
import ibase.sys.ejb.BaseProductInfo;
//Changed by Danish on 19/03/2007
//Changed by Monif on 6/27/2008 [To remove OraclePreparedStatement ]
//import oracle.jdbc.driver.OraclePreparedStatement;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.DWFactory;
import ibase.webitm.utility.DWObject;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.PopUpHandler;
import ibase.webitm.utility.TransIDGenerator;

/**
 * <p>Title: iBase Application</p>
 * <p>Description: The authenticate() method of the bean authenticates a user, and the getEmpInfo method get the employee info.
 * getUserProfileXML() accepts user profile as a string value and returns it in the XML format .
 * getUserXML() method accepts the usercode and returns XML String It generates the XML for the menu.
 * </p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: Base Information Managment Ltd.</p>
 * @author Base
 * @version 1.0
 */
@javax.ejb.Stateless
public class DBAccessEJB implements DBAccessRemote,DBAccessLocal //implements SessionBean
{

	//Gulzar on 24/01/17 : START
	final String OBJ_INFO_SEPARATOR = ";";
	private HashMap<String, String> objFormInfoMap = null;
	//Gulzar on 24/01/17 : START

	//Added By Pankaj T on 12/09/17 for creating infinispan object on class level - Start
	static InfinispanLocal infinispanLocalObj = null;
	static Hashtable jndiProperties = null;
	static InitialContext ctx = null;

	static
	{
		try
		{
			//Added Pankaj T on 18-10-17 [for CACHE_OPT define in ibase.xml 0 = NO Cache, 1 = Internal Cache, 2 = External Cache]
			if( CommonConstants.CACHE_OPT != 0 )
			{
				jndiProperties = new Hashtable();
				jndiProperties.put(Context.URL_PKG_PREFIXES,"org.jboss.ejb.client.naming");
				ctx=new InitialContext(jndiProperties);
				infinispanLocalObj = ((InfinispanLocal)ctx.lookup("ibase/InfinispanEJB/local"));
				BaseLogger.log("1", null, null,"DBAccessEJB infinispanLocalObj created.....");
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null,"Exception in DBAccessEJB static block:["+e.getMessage()+"]");
			e.printStackTrace();
		}
	}
	//Added By Pankaj T on 12/09/17 for creating infinispan object on class level - End

	//SessionContext cSessionContext;
	/**
	 *     This method is invoked by the EJB container after the client initiated the lifecycle by invoking the "create()" method
	 *<P>It is inside the bean class,allowing to perform certain operations right after the bean is instantiated</P>
	 *@exception RemoteException,CreateException
	 *
	 *
	 */
	public void ejbCreate()
	{
	}
	/**
	 *     This method is invoked by the EJB container at the end of the lifecycle after the client invokes the "remove()" method
	 *<P>It is inside the bean class,allowing to perform certain operations just before the bean's instance gets garbage collected</P>
	 *
	 */
	@Remove
	public void remove()
	{
	}
	/**
The EJB container invokes the bean's method immediately before passivating it
	 *
	 */
	public void ejbActivate()
	{
	}
	/**
The EJB container invokes the bean's method immediately after passivating it and moving it back to the ready state
	 *
	 */
	public void ejbPassivate()
	{
	}
	/**
This method sets the session context of the EJB
	 *
	 */
	private @Resource SessionContext sessionContext;

	/**
	 *This method returns ITM Version
	 *@return ITM Version as String
	 *@exception RemoteException,ITMException
	 *
	 */
	/*public String getAppProperties() throws RemoteException, ITMException
	{
		BaseLogger.log("3", null, null,"[DBAccessEJB]Getting the ITM Version ....."); //$NON-NLS-1$
		ConnDriver mConnDriver = null;
		Connection mConnection = null;
		Statement stmt = null;
		ResultSet rs = null;
		String retITMVersion = ""; //$NON-NLS-1$
		String dispDateFormat = "INVALID_DISP_FORMAT"; //$NON-NLS-1$
		try
		{
			mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver"); //$NON-NLS-1$

			String selectQuery = "SELECT ITM_VER FROM PARAMETER"; //$NON-NLS-1$
			stmt = mConnection.createStatement();
			rs = stmt.executeQuery(selectQuery);
			if (rs.next())
			{
				retITMVersion = rs.getString("ITM_VER"); //$NON-NLS-1$
			}
			rs.close();
			rs = null;
			if(stmt != null)
			{
				stmt.close();
				stmt = null;
			}
			try
			{
				dispDateFormat = new E12GenericUtility().getDispDateFormat();
			}
			catch (Exception e)
			{
				BaseLogger.log("3", null, null,"Invalid Display Date Format..."); //$NON-NLS-1$
			}
		}
		catch (ITMException itme)
		{
			BaseLogger.log("3", null, null,"Exception :DBAccessEJB :getAppProperties :==>"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			BaseLogger.log("3", null, null,"Exception :DBAccessEJB :getAppProperties :==>"); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getAppProperties :\n"+e.getMessage()); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("3", null, null,"[DBAccessEJB]Returning the Application Properties :"+retITMVersion); //$NON-NLS-1$
		return retITMVersion + "~" + dispDateFormat; //$NON-NLS-1$
	}*/

	public String getProfileId(String mUserID, String site) throws RemoteException,ITMException
	{
		String profileId = null;
		ConnDriver mConnDriver = null;
		Connection mConnection = null;
		Statement stmt = null;
		ResultSet rs = null;
		try
		{
			mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB( "Driver" ); //$NON-NLS-1$

			String selectQuery = "SELECT PROFILE_ID FROM USERS WHERE CODE ='" + mUserID + "'"; //$NON-NLS-1$ //$NON-NLS-2$
			stmt = mConnection.createStatement();
			rs = stmt.executeQuery(selectQuery);
			if (rs.next())
			{
				profileId = rs.getString("PROFILE_ID"); //$NON-NLS-1$
			}
			rs.close();
			rs = null;
			if(stmt != null)
			{
				stmt.close();
				stmt = null;
			}
		}
		catch (ITMException itme)
		{
			BaseLogger.log("0", null, null,"ITMException :DBAccessEJB :getProfileId :==>"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null,"Exception :DBAccessEJB :getProfileId :==>"); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getProfileId :\n"+e.getMessage()); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		//BaseLogger.log("3", null, null,"[DBAccessEJB]Returning Profile Id :"+profileId);
		return profileId;
	}

	/**
	 *This method accepts username, site code and returns information about that specific user.
	 *<P>It retrieves the information about the employee of the company</P>
	 *@param  mUserID user ID
	 *@param  site site
	 *@return StringSTATUS_SERVER_LOG
	 *@exception RemoteException,ITMException
	 */
	public String [] getEmpInfo(String mUserID, String site, String transDB) throws RemoteException,ITMException
	{
		//Changed By Rupali on 20/05/2008.[To add the Email ID in UserInfo].Request ID:-[BI78SUN047]
		//String [] arr= new String[12];
		//Changed by Swapnil Shirke on 20-Jul-2010 [to add stan_code__hq, designation, date of join, division in userInfo][WS90SUN043] starts
		//String [] arr= new String[14];
		//Change by Nilesh on 22-Mar-2011[WS01SUN062][To add lang and country into userinfo]
		//String [] arr= new String[18];

		//Changes by Prajyot [Add theme into userinfo]
		//String [] arr= new String[21];
		//Changed by Prasad on 24/08/16 [Adding UX_INTERFACE for storing interface]
		//String [] arr= new String[22];

		//Change by shrutika on 05-02-18 for set city in case of change site.
		//String [] arr= new String[23];
		//String [] arr= new String[24];
		//String [] arr= new String[25];//increase the size of array on  16-02-18 for getting fin_entity.
		//Changes made by Pratheek on 29-01-19[ increase the size of array for getting facility_code values. ]-Start
		//String [] arr= new String[26];
		String [] arr= new String[27];
		//Changes made by Pratheek on 29-01-19[ increase the size of array for getting facility_code values. ]-End

		Connection mConnection = null;
		Connection usersConn = null;
		ConnDriver mConnDriver = null;
		String mQuery = null;
		String mQuery1 = null;
		String mQuery2 = null;
		Statement mStmt = null;
		ResultSet mRs = null;
		try
		{
			if(site != null)
			{
				site = site.trim();
			}
			if(mUserID != null)
			{
				mUserID = mUserID.trim();
			}
			mConnDriver = new ConnDriver();
			//Added by Pankaj T on 19-01-18 [changes for multitenancy]
			usersConn = mConnDriver.getConnectDB("Driver");
			//Commented and changed by Gulzar on 24/10/13[] : START
			if(transDB!=null && (transDB.trim().length() >0 ))
			{
				mConnection = mConnDriver.getConnectDB(transDB);
			}
			//Commented and changed by Gulzar on 24/10/13[] : END

			arr[0]="";//EMP_NO //$NON-NLS-1$
			arr[1]="";//FNAME.MNAME.LNAME //$NON-NLS-1$
			arr[2]="";//REPORT_TO //$NON-NLS-1$
			arr[3]="";//DCODE //$NON-NLS-1$
			arr[4]= "";//DEPT //$NON-NLS-1$
			arr[5]="";//SITE_CODE //$NON-NLS-1$
			arr[6]= "";//SITE_DESCR //$NON-NLS-1$
			arr[7]= "";//USER_LEVEL //$NON-NLS-1$
			arr[8]= "";//USER_TYPE //$NON-NLS-1$
			arr[9]= "";//ENTITY_CODE //$NON-NLS-1$
			arr[10]= "";//PROFILE_ID //$NON-NLS-1$
			arr[11]= "";//ITEM_SER //$NON-NLS-1$
			//Changed By Rupali on 20/05/2008.[To add the Email ID in UserInfo].Request ID:-[BI78SUN047]
			arr[12]= "";//EMAIL ID //$NON-NLS-1$
			arr[13]= "";//LOGGER_TYPE //$NON-NLS-1$
			//Changed by Swapnil Shirke on 20-Jul-2010 [to add stan_code__hq, designation, dateOfJoining, division in userInfo][WS90SUN043] starts
			arr[14] = ""; //STAN_CODE__HQ //$NON-NLS-1$
			arr[15] = ""; //DESIGNATION //$NON-NLS-1$
			arr[16] = ""; //DATE_JOIN //$NON-NLS-1$
			arr[17] = ""; //DIVISION //$NON-NLS-1$
			//Changed by Swapnil Shirke on 20-Jul-2010 [to add stan_code__hq, designation, dateOfJoining, division in userInfo][WS90SUN043] ends
			//Change by Nilesh on 22-Mar-2011 [WS01SUN062][set lang & country from users]Start
			arr[18] = ""; //$NON-NLS-1$
			arr[19] = "";  //$NON-NLS-1$
			arr[20] = "";  //$NON-NLS-1$

			//Added by Prajyot 18MAR2014[Theme Implementation]
			arr[21] = "";// USER_THEME //$NON-NLS-1$
			//Added by Prasad on 24/08/16 [Adding UX_INTERFACE for storing interface]
			arr[22] = "";

			//Change by Nilesh on 22-Mar-2011 [WS01SUN062][set lang & country from users]End
			//BaseLogger.log("3", null, null,"User: "+mUserID);
			//BaseLogger.log("3", null, null,"Site: "+site);
			BaseLogger.log("3",null, null,"Retrieving EmployeeInformation....."); //$NON-NLS-1$
			//changed by gayatri[ SY01SUN013 || To allocate different set of rights to the same user for different sites based on different profile id]
			String profileId=""; //$NON-NLS-1$
			if ( ( mUserID != null ) && ! ( site.equals( "" ) ) ) //$NON-NLS-1$
			{
				//changed by gayatri[ SY01SUN013 || To allocate different set of rights to the same user for different sites based on different profile id]start
				mStmt = mConnection.createStatement();
				String getSiteCodeWiseMenu="SELECT PROFILE_ID FROM USER_SITE WHERE USER_ID='" +mUserID+ "' AND SITE_CODE='" +site+ "'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				//BaseLogger.log("3", null, null,"getSiteCodeWiseMenu="+getSiteCodeWiseMenu);
				mRs = mStmt.executeQuery(getSiteCodeWiseMenu);

				if ( mRs.next() )
				{
					profileId=mRs.getString("PROFILE_ID"); //$NON-NLS-1$
				}
				//BaseLogger.log("3", null, null,"Profile Id from USER_SITE :["+profileId+"]");
				if ( mRs != null )
				{
					mRs.close();
					mRs = null;
				}
				if ( mStmt != null )
				{
					mStmt.close();
					mStmt = null;
				}
				//changed by gayatri [ SY01SUN013 || To allocate different set of rights to the same user for different sites based on different profile id]end
				//Change by Nilesh on 22-Mar-2011 [WS01SUN062][set lang & country from users]
				//mQuery1 = "SELECT USR_LEV,USER_TYPE,ENTITY_CODE,PROFILE_ID,LOGGER_TYPE FROM USERS WHERE CODE ='" + mUserID + "'";

				//Added USER_THEME in Select query
				//Changed by Prasad on 24/08/16 [Adding UX_INTERFACE for storing interface]
				mQuery1 = "SELECT USR_LEV,USER_TYPE,ENTITY_CODE,PROFILE_ID,LOGGER_TYPE,USER_LANG,USER_COUNTRY, TRANS_DB, USER_THEME, UX_INTERFACE, ENTERPRISE  FROM USERS WHERE CODE ='" + mUserID + "'"; //$NON-NLS-1$ //$NON-NLS-2$
				mStmt = usersConn.createStatement();
				mRs = mStmt.executeQuery(mQuery1);
				int level = 0;
				BaseLogger.log("3", null, null,"Selecting User Level, User Type, Entity Code, Profile Id........."); //$NON-NLS-1$
				if(mRs.next())
				{
					level = mRs.getInt("USR_LEV"); //$NON-NLS-1$
					arr[7] = new Integer(level).toString();
					BaseLogger.log("3", null, null,"User Level :["+level+"]"); //$NON-NLS-1$ //$NON-NLS-2$
					arr[8] = mRs.getString("USER_TYPE"); //$NON-NLS-1$
					BaseLogger.log("3", null, null,"User Type :["+arr[8]+"]"); //$NON-NLS-1$ //$NON-NLS-2$
					arr[9] = mRs.getString("ENTITY_CODE"); //$NON-NLS-1$
					BaseLogger.log("3", null, null,"Entity Code :["+arr[9]+"]"); //$NON-NLS-1$ //$NON-NLS-2$
					//Change by Nilesh on 22-Mar-2011 [WS01SUN062][set lang & country from users]Start
					arr[18] = mRs.getString("USER_LANG"); //$NON-NLS-1$
					BaseLogger.log("3", null, null,"USER LANG :["+arr[18]+"]");	 //$NON-NLS-1$ //$NON-NLS-2$
					arr[19] = mRs.getString("USER_COUNTRY"); //$NON-NLS-1$
					BaseLogger.log("3", null, null,"USER COUNTRY :["+arr[19]+"]");	 //$NON-NLS-1$ //$NON-NLS-2$
					//Change by Nilesh on 22-Mar-2011 [WS01SUN062][set lang & country from users]End
					//changed by gayatri[ SY01SUN013 || To allocate different set of rights to the same user for different sites based on different profile id]start
					//arr[10] = mRs.getString("PROFILE_ID");
					//if( profileId.length()!=0 )
					if(profileId != null && profileId.length()!= 0 )//changed by gayatri on 04-02-2011[ SY01SUN013 ][to remove null pointer exception]
					{
						arr[10] = profileId;
					}
					else
					{
						arr[10] = mRs.getString("PROFILE_ID"); //$NON-NLS-1$
					}
					//changed by gayatri[ SY01SUN013 || To allocate different set of rights to the same user for different sites based on different profile id]end
					BaseLogger.log("3", null, null,"DBAccessEJB:Profile Id After setting:["+arr[10]+"]"); //$NON-NLS-1$ //$NON-NLS-2$
					if( mRs.getString("LOGGER_TYPE") != null ){ //$NON-NLS-1$
						arr[13] = mRs.getString("LOGGER_TYPE"); //$NON-NLS-1$
					}
					BaseLogger.log("3", null, null,"LOGGER_TYPE :[" + arr[13] + "]"); //$NON-NLS-1$ //$NON-NLS-2$

					arr[20] = (mRs.getString("TRANS_DB") == null) ?"":mRs.getString("TRANS_DB").trim();

					//Get the value of userTheme and put in the array
					arr[21] = (mRs.getString("USER_THEME") == null) ?"":mRs.getString("USER_THEME").trim(); //$NON-NLS-1$
					BaseLogger.log("3", null, null,"USER_THEME :["+arr[21]+"]");
					//Added by Prasad on 24/08/16 [Adding UX_INTERFACE for storing interface] START
					arr[22] = (mRs.getString("UX_INTERFACE") == null) ?"":mRs.getString("UX_INTERFACE").trim(); //$NON-NLS-1$
					BaseLogger.log("3", null, null,"UX_INTERFACE :["+arr[22]+"]");
					//Added by Prasad on 24/08/16 [Adding UX_INTERFACE for storing interface] END
					arr[23] = mRs.getString("ENTERPRISE"); //$NON-NLS-1$
					BaseLogger.log("3",null,null,"ENTERPRISE :["+arr[23]+"]");
				}
				BaseLogger.log("3", null, null, "Employee Information if not printed above then not set........." ); //$NON-NLS-1$
				//Commented by Manish on 06/10/2006 as teh same work is done from COmmonDBAccessEJB
				//arr[5] = getSiteAccessStatus( mConnection, mUserID, site, arr[7] );

				//Changed by Monif on 25/04/09[Setting arr[8] if it is "" ].
				//arr[8] = (arr[8] == null || "null".equalsIgnoreCase(arr[8])) ? "E" : arr[8];
				if ( arr[8] == null || "null".equalsIgnoreCase(arr[8]) || arr[8].trim().length() == 0 ) //$NON-NLS-1$
				{
					arr[8] = "E"; //$NON-NLS-1$
				}
				BaseLogger.log("3", null, null,"arr[8]:["+arr[8]+"]"); //$NON-NLS-1$ //$NON-NLS-2$
				mRs.close();
				mRs = null;
				mStmt.close();
				mStmt = null;
				BaseLogger.log("3", null, null,"Selecting Employee Details from  EMPLOYEE, DEPARTMENT"); //$NON-NLS-1$
				//Swapnil on 20-JUL-2010 [WS90SUN043] [Adding stan_code__hq in select query] starts
				/*
				mQuery = "SELECT EMP_CODE ENO , EMP_SITE,EMP_FNAME FNAME, EMP_MNAME MNAME,EMP_LNAME LNAME," +
							 "REPORT_TO, B.DEPT_CODE DCODE, B.DESCR DEPT FROM EMPLOYEE A, DEPARTMENT B " +
							 "WHERE A.DEPT_CODE=B.DEPT_CODE AND EMP_CODE " +
							 " = ( SELECT  EMP_CODE  FROM USERS WHERE " +
							 "CODE='" + mUserID + "')";
				 */
				/*mQuery = "SELECT EMP_CODE ENO , EMP_SITE,EMP_FNAME FNAME, EMP_MNAME MNAME,EMP_LNAME LNAME," +
				 "REPORT_TO, B.DEPT_CODE DCODE, B.DESCR DEPT, C.DESCR AS STAN_CD__HQ_DESCR, " +
				 "A.DESIGNATION AS DESIGNATION, A.DATE_JOIN AS DATE_JOIN " +
				 "FROM EMPLOYEE A, DEPARTMENT B , STATION C " +
				 "WHERE A.DEPT_CODE=B.DEPT_CODE AND " +
				 "A.STAN_CODE__HQ=C.STAN_CODE(+) AND " +
				 "EMP_CODE " +
				 " = ( SELECT  EMP_CODE  FROM USERS WHERE " +
				 "CODE='" + mUserID + "')";*/
				//Added by Pankaj T on 19-01-18 [changes for multitenancy]
				String empCode = "";
				String qry = "SELECT  EMP_CODE  FROM USERS WHERE CODE='" + mUserID + "'";
				try(PreparedStatement pstmt = usersConn.prepareStatement(qry);
					ResultSet resultSet = pstmt.executeQuery();)
				{
					if(resultSet.next())
					{
						empCode = resultSet.getString("EMP_CODE");
					}
				}
				catch (Exception e)
				{
					e.printStackTrace();
				}
				//Added by Pankaj T on 19-01-18 [changes for multitenancy]
				/*mQuery = "SELECT EMP_CODE ENO , EMP_SITE,EMP_FNAME FNAME, EMP_MNAME MNAME,EMP_LNAME LNAME," + //$NON-NLS-1$
						"REPORT_TO, B.DEPT_CODE DCODE, B.DESCR DEPT, C.DESCR AS STAN_CD__HQ_DESCR, " + //$NON-NLS-1$
						"A.DESIGNATION AS DESIGNATION, A.DATE_JOIN AS DATE_JOIN " + //$NON-NLS-1$
						"FROM EMPLOYEE A LEFT OUTER JOIN STATION C ON A.STAN_CODE__HQ=C.STAN_CODE, DEPARTMENT B " + //$NON-NLS-1$
						"WHERE A.DEPT_CODE=B.DEPT_CODE AND " +				 //$NON-NLS-1$
						"EMP_CODE ='" + empCode +"'"; //$NON-NLS-1$
				*/
				
				//Added By Pankaj T. on 02-02-2023 changed sql to set data of employee if department or station not matched with employee - start 
				mQuery= "SELECT EMP_CODE ENO, EMP_SITE, EMP_FNAME FNAME, EMP_MNAME MNAME, EMP_LNAME LNAME," +
						"REPORT_TO, B.DEPT_CODE DCODE, B.DESCR DEPT, C.DESCR AS STAN_CD__HQ_DESCR, " +
						"A.DESIGNATION AS DESIGNATION, A.DATE_JOIN AS DATE_JOIN " +
						"FROM EMPLOYEE A " + 
						"LEFT OUTER JOIN STATION C ON A.STAN_CODE__HQ=C.STAN_CODE " +
						"LEFT OUTER JOIN DEPARTMENT B ON A.DEPT_CODE=B.DEPT_CODE " +
						"WHERE EMP_CODE ='" + empCode +"'";
				//Added By Pankaj T. on 02-02-2023 changed sql to set data of employee if department or station not matched with employee - end
				
				//		" = ( SELECT  EMP_CODE  FROM USERS WHERE " + //$NON-NLS-1$
				//		"CODE='" + mUserID + "')"; //$NON-NLS-1$ //$NON-NLS-2$
				//Swapnil on 20-JUL-2010 [WS90SUN043] ends
				//arr[5] = site;
				//change by shrutika on 05-02-18 for getting city.
				//mQuery2= "SELECT DESCR FROM SITE WHERE SITE_CODE='" + site + "'"; //$NON-NLS-1$ //$NON-NLS-2$
				//Changes made by Pratheek on 29-01-19[ to get the facility code from site table ]-Start
				//mQuery2= "SELECT DESCR,FIN_ENTITY,CITY FROM SITE WHERE SITE_CODE='" + site + "'";
				mQuery2= "SELECT DESCR,FIN_ENTITY,CITY,FACILITY_CODE FROM SITE WHERE SITE_CODE='" + site + "'";
				mStmt = mConnection.createStatement();
				mRs = mStmt.executeQuery(mQuery2);
				if(mRs.next())
				{
					arr[6] = mRs.getString("DESCR"); // SITE NAME //$NON-NLS-1$
					BaseLogger.log("3", null, null,"Site Descr :["+arr[6]+"]"); //$NON-NLS-1$ //$NON-NLS-2$
					//Added by Shrutika on 13-12-18 [Start] for set fin_entity value when login.
					arr[24] = mRs.getString("FIN_ENTITY");
					BaseLogger.log("3",null,null,"Site FIN_ENTITY :["+arr[24]+"]");
					//Added by shrutika on 05-02-18 for getting city.
					//arr[23] = mRs.getString("CITY");
					arr[25] = mRs.getString("CITY");
					BaseLogger.log("3", null, null,"Site city : 532["+arr[25]+"]");
					//Added by Pratheek on 28-01-19[ to store the facility code value in reports]-Start
					arr[26] = mRs.getString("FACILITY_CODE");
					BaseLogger.log("3",null,null,"Site FACILITY_CODE : 547!!!["+arr[26]+"]");
					//Added by Pratheek on 28-01-19[ to store the facility code value in reports]-End
				}
				mRs.close();
				mStmt.close();
				mStmt = null;
				mStmt = mConnection.createStatement();
				mRs = mStmt.executeQuery(mQuery);
				while (mRs.next())
				{
					arr[0] = mRs.getString("ENO"); //EMP_NO //$NON-NLS-1$
					BaseLogger.log("3", null, null,"Emp No. :["+arr[0]+"]"); //$NON-NLS-1$ //$NON-NLS-2$

					//Changed by Gulzar/Rahul on 04/09/14 to replace the (.) with space( )  and checking the null :START
					//arr[1] = mRs.getString("FNAME") +"." + mRs.getString("MNAME") + "." + mRs.getString("LNAME"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
					String fName = mRs.getString("FNAME");
					String mName = mRs.getString("MNAME");
					String lName = mRs.getString("LNAME");
					arr[1] = ((fName == null || fName.trim().length() == 0)?"": fName) + ((mName == null || mName.trim().length() == 0)?"": " " + mName) + ((lName == null || lName.trim().length() == 0)?"": " " + lName);
					//Changed by Gulzar/Rahul on 04/09/14 to replace the (.) with space( )  and checking the null :END

					BaseLogger.log("3", null, null,"Emp Name :["+arr[1]+"]"); //$NON-NLS-1$ //$NON-NLS-2$
					arr[2] = mRs.getString("REPORT_TO");//REPORT //$NON-NLS-1$
					BaseLogger.log("3", null, null,"Report To :[" + arr[2] + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					arr[3]=mRs.getString("DCODE"); //DEPT_CODE //$NON-NLS-1$
					BaseLogger.log("3", null, null,"Dept Code :[" + arr[3] + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					arr[4]=mRs.getString("DEPT");  // DEPT NAME //$NON-NLS-1$
					BaseLogger.log("3", null, null,"Dept Name :[" + arr[4] + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					//Changed by Swapnil Shirke on 20-Jul-2010 [to add stan_code__hq, designation, dateOfJoining, division in userInfo][WS90SUN043] starts
					arr[14] = mRs.getString("STAN_CD__HQ_DESCR"); // HQ DESCRIPTION //$NON-NLS-1$
					BaseLogger.log("3", null, null,"Dept Descr :["+arr[14]+"]"); //$NON-NLS-1$ //$NON-NLS-2$
					arr[15] = mRs.getString("DESIGNATION"); // DESIGNATION DESCRIPTION //$NON-NLS-1$
					BaseLogger.log("3", null, null,"Designation :["+arr[15]+"]"); //$NON-NLS-1$ //$NON-NLS-2$
					//To convert the SQL server date to the System date format
					E12GenericUtility genericUtility = new E12GenericUtility();
					arr[16] = genericUtility.getValidDateString(mRs.getString("DATE_JOIN"), genericUtility.getDBDateFormat(), "dd-MMM-yyyy"); //$NON-NLS-1$ //$NON-NLS-2$
					//arr[16] = mRs.getString("DATE_JOIN"); // DATE_JOIN DESCRIPTION
					BaseLogger.log("3", null, null,"Date Of Join :["+arr[16]+"]"); //$NON-NLS-1$ //$NON-NLS-2$
					//Changed by Swapnil Shirke on 20-Jul-2010 [to add stan_code__hq, designation, dateOfJoining, division in userInfo][WS90SUN043] ends
				}
				if(arr[8].equalsIgnoreCase("P")) //$NON-NLS-1$
				{
					//Commented and passed connection to private method : Gulzar on 24/10/13[] : START
					//arr[11] = getItemSer(arr[9]);
					arr[11] = getItemSer(arr[9],mConnection);
					//Commented and passed connection to private method : Gulzar on 24/10/13[] : END

					BaseLogger.log("3", null, null,"Item Ser. :[" + arr[11] + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					//Changed by Swapnil Shirke on 01-Jul-2010 [to add stan_code__hq, designation, dateOfJoining, division in userInfo][WS90SUN043] starts
					arr[17] = getDivision(arr[11], transDB);
					BaseLogger.log("3", null, null,"Division :[" + arr[17] + "]"); //$NON-NLS-1$ //$NON-NLS-2$
					//Changed by Swapnil Shirke on 01-Jul-2010 [to add stan_code__hq, designation, dateOfJoining, division in userInfo][WS90SUN043] ends
				}
				//Changed By Rupali on 20/05/2008.[To add the Email ID into UserInfo].Request ID:-[BI78SUN047].Start
				String tableName = ""; //$NON-NLS-1$
				String selectColName = ""; //$NON-NLS-1$
				String whereColName = ""; //$NON-NLS-1$
				if(arr[8].equalsIgnoreCase("P")) //$NON-NLS-1$
				{
					tableName = "sales_pers"; //$NON-NLS-1$
					selectColName = "email_addr"; //$NON-NLS-1$
					whereColName = "sales_pers"; //$NON-NLS-1$

				}
				//Changed by Prasad on 10/11/2020 [check for developer type 'D']
				//else if(arr[8].equalsIgnoreCase("E")) //$NON-NLS-1$
				else if(arr[8].equalsIgnoreCase("E") || arr[8].equalsIgnoreCase("D")) //$NON-NLS-1$
				{
					tableName ="employee"; //$NON-NLS-1$
					selectColName = "email_id_off"; //$NON-NLS-1$
					whereColName = "emp_code"; //$NON-NLS-1$
				}

				else if(arr[8].equalsIgnoreCase("S")) //$NON-NLS-1$
				{
					tableName = "supplier"; //$NON-NLS-1$
					selectColName = "email_addr"; //$NON-NLS-1$
					whereColName = "supp_code"; //$NON-NLS-1$
				}
				else if(arr[8].equalsIgnoreCase("C")) //$NON-NLS-1$
				{
					tableName = "customer"; //$NON-NLS-1$
					selectColName = "email_addr"; //$NON-NLS-1$
					whereColName = "cust_code"; //$NON-NLS-1$
				}
				arr[12] = getEmailAddr(selectColName,tableName,whereColName,(mUserID+"$"), createUserInfo(mUserID)); //$NON-NLS-1$
				//Changed By Rupali on 20/05/2008.[To add the Email ID into UserInfo].Request ID:-[BI78SUN047].End
				mRs.close();
				mRs = null;
				mStmt.close();
				mStmt = null;
			}
			else
			{
				BaseLogger.log("3", null, null,"(DBAccessEJB:getEmpInfo)UserID: NULL  or SiteCode: Doesn't Exist");  //$NON-NLS-1$
			}
		}
		catch(ITMException itme)
		{
			BaseLogger.log("3", null, null,"ITMException: DBAccess: getEmpInfo: ==>EmployeeInformation: Not Returned(Generic Exception)\n"); //$NON-NLS-1$
			throw itme;
		}
		catch(SQLException sqlExp)
		{
			BaseLogger.log("3", null, null,"Exception: DBAccess: getEmpInfo: ==>EmployeeInformation: Not Returned(SQLException)\n" + sqlExp); //$NON-NLS-1$
			sqlExp.printStackTrace();
			throw new ITMException(sqlExp);
		}
		catch(Exception e)
		{
			BaseLogger.log("3", null, null,"Exception: DBAccess: getEmpInfo: ==>EmployeeInformation: Not Returned(Generic Exception)\n" +e); //$NON-NLS-1$
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(mStmt != null)
					{
						mStmt.close();
						mStmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
				if(usersConn != null)
				{
					usersConn.close();
					usersConn = null;
				}
			}
			catch(SQLException sqlExp1)
			{
				BaseLogger.log("3", null, null,"Exception: DBAccess: getEmpInfo: ==>EmployeeInformation: Not Returned(SQLException) F\n"+sqlExp1); //$NON-NLS-1$
				sqlExp1.printStackTrace();
				throw new ITMException(sqlExp1);
			}
		}
		BaseLogger.log("3", null, null,"Employee Information: Returning........"); //$NON-NLS-1$
		return arr;
	}

	private String getSiteAccessStatus( Connection mConnection, String mUserID, String siteCode, String userLevel ) throws ITMException
	{
		//BaseLogger.log("3", null, null, "Checking site access status for User ID :[ " + mUserID + "] Site Code :[ " + siteCode + "] User Level :[ " + userLevel + "]" );
		String siteAccessStatus = "INVALID_SITE"; //$NON-NLS-1$
		Statement stmt = null;
		ResultSet rs = null;
		try
		{
			int siteStatusInt = -1;
			String selectQuery = "SELECT COUNT( SITE_CODE ) FROM SITE WHERE SITE_CODE='" + siteCode + "'"; //$NON-NLS-1$ //$NON-NLS-2$
			stmt = mConnection.createStatement();
			rs = stmt.executeQuery(selectQuery);
			if (rs.next())
			{
				siteStatusInt = rs.getInt( 1 );
				BaseLogger.log("3", null, null, "Count from SITE :["+siteStatusInt+"]" ); //$NON-NLS-1$ //$NON-NLS-2$
			}
			rs.close();
			rs = null;
			stmt.close();
			stmt = null;
			if( siteStatusInt == 1 )
			{
				if( userLevel != null && userLevel.length() > 0 )
				{
					int userLevelInt = Integer.parseInt( userLevel );
					if( userLevelInt > 1 )
					{
						selectQuery = "SELECT COUNT( SITE_CODE ) FROM USER_SITE WHERE USER_ID='"+mUserID+"' AND SITE_CODE='" + siteCode + "'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						stmt = mConnection.createStatement();
						rs = stmt.executeQuery( selectQuery );
						if (rs.next())
						{
							siteStatusInt = rs.getInt( 1 );
							BaseLogger.log("3", null, null, "Count from USER_SITE :["+siteStatusInt+"]" ); //$NON-NLS-1$ //$NON-NLS-2$
						}
						stmt.close();
						stmt = null;
						if( siteStatusInt == 0 )
						{
							siteAccessStatus = "INACCESSIBLE_SITE"; //$NON-NLS-1$
						}
						else
						{
							siteAccessStatus = siteCode;
						}
					}//if( userLevelInt > 1 )
					else
					{
						siteAccessStatus = siteCode;
					}
				}//if( userLevel != null && userLevel.length() > 0 )
			}//if( siteStatusInt == 1 )
		}
		catch (Exception e)
		{
			BaseLogger.log("3", null, null,"Exception :DBAccessEJB :checkSiteAccessStatus :==>"); //$NON-NLS-1$
			throw new ITMException(e);
		}
		BaseLogger.log("3", null, null,"[DBAccessEJB]Returning checkSiteAccessStatus :"+siteAccessStatus); //$NON-NLS-1$
		return siteAccessStatus;
	}

	//Changes by Gulzar on 24/10/13 to pass connection parameter
	//private String getItemSer(String entityCode) throws RemoteException, ITMException
	private String getItemSer(String entityCode, Connection conn ) throws RemoteException, ITMException
	{
		BaseLogger.log("3", null, null,"Getting item series for entityCode :"+entityCode+":"); //$NON-NLS-1$ //$NON-NLS-2$
		String itemSer = ""; //$NON-NLS-1$
		ConnDriver connDriver = null;
		//Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		String query = null;

		try
		{
			connDriver = new ConnDriver();

			query = "SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS = '"+entityCode+"'"; //$NON-NLS-1$ //$NON-NLS-2$
			stmt = conn.createStatement();
			BaseLogger.log("3", null, null,"[DBAccessEJB]Getting division code, query :\n"+query); //$NON-NLS-1$
			rs = stmt.executeQuery(query);

			while(rs.next())
			{
				itemSer = rs.getString(1);
			}
			rs.close();
			rs = null;
			stmt.close();
			stmt = null;
		}
		/* -Commented by gulzar as it is not required [] on 24/10/13
		catch (ITMException itme)
		{
			BaseLogger.log("3", null, null,"ITMException :DBAccessEJB :getItemSer :==>"); //$NON-NLS-1$
			throw itme;
		}
		 */
		catch (Exception e)
		{
			BaseLogger.log("3", null, null,"Exception :DBAccessEJB :getItemSer :==>"+e); //$NON-NLS-1$
			//e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(stmt != null)
					{
						stmt.close();
					}
					//Gulzar - not required
					//conn.close();
					//conn = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getItemSer :==>"+e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("3", null, null,"[DBAccessEJB]ItemSer :"+itemSer); //$NON-NLS-1$
		return itemSer;
	}

	/**
	 *This method accepts the username and returns the user type as a string value
	 *@param  mUserID userID
	 *@return XML api as String
	 *@exception RemoteException
	 */
	public String getUserType(String mUserID) throws RemoteException,ITMException
	{
		String mQuery = null;
		Connection mConnection = null;
		Statement mStatement = null;
		ResultSet mResultSet = null;
		ConnDriver mConnDriver = null;
		String userType = null;
		BaseLogger.log("3", null, null,"(DBAccessEJB:getUserType)UserType: Searching...");			 //$NON-NLS-1$
		try
		{
			mConnDriver = new ConnDriver();
			mQuery  = " SELECT USER_TYPE  FROM  USERS " //$NON-NLS-1$
					+ "WHERE CODE = '" + mUserID  + "'"; //$NON-NLS-1$ //$NON-NLS-2$

			mConnection = mConnDriver.getConnectDB("Driver"); //$NON-NLS-1$

			mStatement = mConnection.createStatement();
			mResultSet=	mStatement.executeQuery(mQuery);
			while (mResultSet.next())
			{
				userType = mResultSet.getString("USER_TYPE"); //$NON-NLS-1$
			}
			mResultSet.close();
			mResultSet = null;
			mStatement.close();
			mStatement = null;
		}
		catch(ITMException itme)
		{
			BaseLogger.log("3", null, null,"ITMException: DBAccess: getUserType: ==>\n"); //$NON-NLS-1$
			throw itme;
		}
		catch(SQLException sqlExp)
		{
			BaseLogger.log("3", null, null,"Exception: DBAccessEJB: getUserType: ==>UserType: Not Returned(SQLException)\n"+sqlExp); //$NON-NLS-1$
			sqlExp.printStackTrace();
			throw new ITMException(sqlExp);
		}
		catch(Exception e)
		{
			BaseLogger.log("3", null, null,"Exception: DBAccess: getUserType: ==>\n"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mStatement != null)
				{
					mStatement.close();
					mStatement = null;
				}
				if(mConnection != null)
				{
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				BaseLogger.log("3", null, null,"Exception: DBAccess: getUserType: ==>UserType: Not Returned(SQLException) F\n"+e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("3", null, null,"(DBAccessEJB:getUserType)UserType: Returning...");			 //$NON-NLS-1$
		return userType.trim();
	}

	/**
	 *This method accepts user profile as a string value and returns it in the XML format
	 *@param  profile profile
	 *@return XML api as String
	 *@exception RemoteException,ITMException
	 *
	 */
	public String getUserProfileXML(String profile) throws RemoteException,ITMException
	{
		StringBuffer mXML = new StringBuffer();
		String msg=""; //$NON-NLS-1$
		String tApp=null;
		String app_descr,mpath,appln,m1,m2,m3;
		int rno = 1;
		try
		{
			mXML.append("<ROOT>"); //$NON-NLS-1$
			mXML.append("<PROFILE ID=\"" + profile + "\">"); //$NON-NLS-1$ //$NON-NLS-2$
			mXML.append("<WELCOME>"); //$NON-NLS-1$
			mXML.append("<NO_OF_SCREEN>3</NO_OF_SCREEN>"); //$NON-NLS-1$
			mXML.append("<SCREEN>"); //$NON-NLS-1$
			mXML.append("<TITLE>MENU</TITLE>"); //$NON-NLS-1$
			mXML.append("<URI>Menu.jsp</URI>"); //$NON-NLS-1$
			mXML.append("<WIDTH>400</WIDTH>"); //$NON-NLS-1$
			mXML.append("<HEIGHT>600</HEIGHT>"); //$NON-NLS-1$
			mXML.append("<FWIDTH>372</FWIDTH>"); //$NON-NLS-1$
			mXML.append("<FHEIGHT>600</FHEIGHT>"); //$NON-NLS-1$
			mXML.append("<POSITION X=\"0\" Y=\"15\"></POSITION>"); //$NON-NLS-1$
			mXML.append("</SCREEN>"); //$NON-NLS-1$
			mXML.append("<SCREEN>"); //$NON-NLS-1$
			mXML.append("<TITLE>WIN-1</TITLE>"); //$NON-NLS-1$
			mXML.append("<URI>Win1.jsp</URI>"); //$NON-NLS-1$
			mXML.append("<WIDTH>600</WIDTH>"); //$NON-NLS-1$
			mXML.append("<HEIGHT>300</HEIGHT>"); //$NON-NLS-1$
			mXML.append("<FWIDTH>600</FWIDTH>"); //$NON-NLS-1$
			mXML.append("<FHEIGHT>300</FHEIGHT>"); //$NON-NLS-1$
			mXML.append("<POSITION X=\"401\" Y=\"15\"></POSITION>"); //$NON-NLS-1$
			mXML.append("</SCREEN>"); //$NON-NLS-1$
			mXML.append("<SCREEN>"); //$NON-NLS-1$
			mXML.append("<TITLE>WIN-2</TITLE>"); //$NON-NLS-1$
			mXML.append("<URI>Win2.jsp</URI>"); //$NON-NLS-1$
			mXML.append("<WIDTH>600</WIDTH>"); //$NON-NLS-1$
			mXML.append("<HEIGHT>300</HEIGHT>"); //$NON-NLS-1$
			mXML.append("<FWIDTH>600</FWIDTH>"); //$NON-NLS-1$
			mXML.append("<FHEIGHT>300</FHEIGHT>"); //$NON-NLS-1$
			mXML.append("<POSITION X=\"401\" Y=\"305\"></POSITION>"); //$NON-NLS-1$
			mXML.append("</SCREEN>"); //$NON-NLS-1$
			mXML.append("</WELCOME>"); //$NON-NLS-1$
			mXML.append("</PROFILE>"); //$NON-NLS-1$
			mXML.append("</ROOT>"); //$NON-NLS-1$
		}
		catch(Exception ex)
		{
			System.err.println("Exception: DBAccessEJB:getUserProfileXML ==>UserProfileXML: Not Built\n"+ ex); //$NON-NLS-1$
			ex.printStackTrace();
			throw new ITMException(ex);
		}

		BaseLogger.log("3", null, null,"UserProfileXML: Built"); //$NON-NLS-1$
		return mXML.toString();
	}

	/**
	 *This method accepts the usercode and returns XML String
	 *It generates the XML for the menu
	 *@param  usercode usercode
	 *@return XML api as String
	 *@exception RemoteException,ITMException
	 *
	 */
	public String getUserXML(String userCode, String profileID) throws RemoteException,ITMException
	{
		StringBuffer mXML = new StringBuffer("<?xml version=\"1.0\" encoding=\""+CommonConstants.ENCODING+"\"?><ROOT>"); //$NON-NLS-1$
		Connection mConnection = null;
		Statement mStatement = null;
		ResultSet mResultSet = null;
		Statement mStatement1 = null;
		ResultSet mResultSet1 = null;
		try
		{
			String tApp=null;
			String prev_descr1 = null;
			String prev_descr2 = null;
			String prev_descr3 = null;
			String prev_descr4 = null;
			String prev_descr5 = null;

			String mIconPath = ""; //$NON-NLS-1$
			String prevIconPath = ""; //$NON-NLS-1$
			String mObjType = ""; //$NON-NLS-1$

			String app_descr,mpath,appln,level1,level2,level3,level4,level5;
			String tLev1_descr = "",tLev2_descr = "",tLev3_descr = "",tLev4_descr = "",tLev5_descr = ""; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
			String tpath,tpath1,tpath2,qry,mWinName;
			int rno=1;
			//changed by gayatri [to add favourite from user_rights][24-04-2012]
			ArrayList favObjName = new ArrayList();
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver"); //$NON-NLS-1$
			/*//Changed by gayatri[To give an option of favorite menus on the screen to the user for faster access To the menus most frequently used][SY90SUN029]start
			String selectObjName="SELECT OBJ_NAME FROM USER_OBJ_FAV WHERE USER_ID='"+userCode+"'";
			BaseLogger.log("3", null, null,"selectFavoriteQry="+selectObjName);
			mStatement = mConnection.createStatement();
			mResultSet = mStatement.executeQuery(selectObjName);
			if( mResultSet.next() )
			{
				mXML.append("<APP ANAME='FAV'>");
				do
				{
					String winName="w_"+mResultSet.getString("OBJ_NAME");
					String selectFavoriteQry="SELECT WIN_NAME,DESCR,ICON_PATH,OBJ_TYPE FROM ITM2MENU WHERE WIN_NAME='"+winName+"'";
					Statement fStat=mConnection.createStatement();
					ResultSet fResultSet=fStat.executeQuery(selectFavoriteQry);
					if(fResultSet.next())
					{
						mXML.append("<LEVEL  WIN='"+fResultSet.getString("WIN_NAME")+"' VAL1='0' VAL2='0' VAL3='0' VAL4='0' VAL5='0' ICON='"+fResultSet.getString("ICON_PATH")+"' OBJ_TYPE='"+fResultSet.getString("OBJ_TYPE")+"'><![CDATA["+fResultSet.getString("DESCR")+" ]]></LEVEL>");
					}
					fStat=null;
					fResultSet=null;
				}	while(mResultSet.next());

				mXML.append("</APP>");
			}
			if ( mStatement != null  )
			{
				mStatement.close();
				mStatement = null;
			}
			if ( mResultSet != null )
			{
				mResultSet.close();
				mResultSet = null;
			}
			//Changed by gayatri[To give an option of favorite menus on the screen to the user for faster access To the menus most frequently used][SY90SUN029]end*/
			String usrLevSelQry = "SELECT USR_LEV FROM USERS WHERE CODE ='" + userCode + "'"; //$NON-NLS-1$ //$NON-NLS-2$
			mStatement = mConnection.createStatement();
			mResultSet = mStatement.executeQuery(usrLevSelQry);
			int level = 0;
			if(mResultSet.next())
			{
				level = mResultSet.getInt("USR_LEV"); //$NON-NLS-1$
			}
			mResultSet.close();
			mResultSet = null;
			mStatement.close();
			mStatement = null;
			String menuSelQry = null;
			if( level >= 1 )
			{
				//changed by gayatri on 07-02-2011 [To give an option of favorite menus on the screen to the user for faster access To the menus most frequently used][SY90SUN029]start
				String selectObjName="SELECT OBJ_NAME FROM USER_OBJ_FAV  WHERE USER_ID='"+userCode+"'"; //$NON-NLS-1$ //$NON-NLS-2$
				BaseLogger.log("3", null, null,"Object from user_obj_fav = ["+selectObjName+"]"); //$NON-NLS-1$ //$NON-NLS-2$
				mStatement = mConnection.createStatement();
				mResultSet = mStatement.executeQuery(selectObjName);
				if( mResultSet.next() )
				{
					mXML.append("<APP ANAME='FAV'>"); //$NON-NLS-1$
					do
					{
						String objName = mResultSet.getString("OBJ_NAME"); //$NON-NLS-1$
						BaseLogger.log("3", null, null,"objName = "+objName); //$NON-NLS-1$
						//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
						//String getRightsQry = "SELECT COUNT(1) FROM USER_RIGHTS WHERE PROFILE_ID = '"+profileID+"' AND OBJ_NAME ='"+objName.trim()+"'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						String getRightsQry = "SELECT COUNT(1) FROM USER_RIGHTS WHERE PROFILE_ID IN " + E12GenericUtility.getFormattedProfileId(profileID) +" AND OBJ_NAME ='"+objName.trim()+"'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						//BaseLogger.log("3", null, null,"getRightsQry = "+getRightsQry);
						Statement rStatement = mConnection.createStatement();
						ResultSet rResultSet = rStatement.executeQuery(getRightsQry);
						if(rResultSet.next())
						{
							if(rResultSet.getInt(1) != 0)
							{
								String winName="w_"+mResultSet.getString("OBJ_NAME"); //$NON-NLS-1$ //$NON-NLS-2$
								String selectFavoriteQry = "SELECT WIN_NAME,DESCR,ICON_PATH,OBJ_TYPE FROM ITM2MENU WHERE WIN_NAME='"+winName+"'"; //$NON-NLS-1$ //$NON-NLS-2$

								Statement fStat = mConnection.createStatement();
								ResultSet fResultSet = fStat.executeQuery(selectFavoriteQry);
								if(fResultSet.next())
								{
									String favWinName = fResultSet.getString("WIN_NAME");
									//added by gayatri [to add favourites from user_rights]
									favObjName.add(favWinName);
									String favIconPath = fResultSet.getString("ICON_PATH");
									String favObjType = fResultSet.getString("OBJ_TYPE");
									String favDecr = fResultSet.getString("DESCR");

									BaseLogger.log("3", null, null,"favDecr ["+favDecr+"]");

									mXML.append("<LEVEL  WIN='"+favWinName+"' VAL1='0' VAL2='0' VAL3='0' VAL4='0' VAL5='0' ICON='"+favIconPath+"' OBJ_TYPE='"+favObjType+"'><![CDATA["+favDecr+" ]]></LEVEL>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$
								}
								if ( fStat != null )
								{
									fStat.close();
									fStat = null;
								}
								if ( fResultSet != null )
								{
									fResultSet.close();
									fResultSet = null;
								}
							}
							if ( rStatement != null )
							{
								rStatement.close();
								rStatement = null;
							}
							if ( rResultSet != null )
							{
								rResultSet.close();
								rResultSet = null;
							}
						}
					}while(mResultSet.next());
					mXML.append("</APP>"); //$NON-NLS-1$
				}
				if ( mStatement != null  )
				{
					mStatement.close();
					mStatement = null;
				}
				if ( mResultSet != null )
				{
					mResultSet.close();
					mResultSet = null;
				}
				//added by gayatri [to add favourites from user_rights]start
				PreparedStatement favPreStat = null;
				ResultSet favRs = null;
				//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
				//String favUserRights = "SELECT OBJ_NAME FROM USER_RIGHTS WHERE PROFILE_ID = ? AND FAV_OPTION = ?";
				String favUserRights = "SELECT OBJ_NAME FROM USER_RIGHTS WHERE PROFILE_ID IN "+ E12GenericUtility.getFormattedProfileId(profileID)+" AND FAV_OPTION = ?";
				favPreStat = mConnection.prepareStatement(favUserRights);
				//favPreStat.setString(1, profileID);
				favPreStat.setString(1, "Y");
				favRs = favPreStat.executeQuery();
				if(favRs.next())
				{
					do
					{
						String winName = "w_" + favRs.getString("OBJ_NAME");
						if(!favObjName.isEmpty() && !favObjName.contains(winName))
						{
							mXML.append("<APP ANAME = 'RIGHTFAV'>");
							String selectFavQry = "SELECT WIN_NAME,DESCR,ICON_PATH,OBJ_TYPE FROM ITM2MENU WHERE WIN_NAME= ? ";
							PreparedStatement preStat = null;
							ResultSet rs = null;
							preStat = mConnection.prepareStatement(selectFavQry);
							preStat.setString(1 , winName );
							rs = preStat.executeQuery();
							if(rs.next())
							{
								String favWinName = rs.getString("WIN_NAME");
								String favIconPath = rs.getString("ICON_PATH");
								String favObjType = rs.getString("OBJ_TYPE");
								String favDecr = rs.getString("DESCR");

								BaseLogger.log("3", null, null,"favDecr ["+favDecr+"]");
								mXML.append("<LEVEL  WIN='"+favWinName+"' VAL1='0' VAL2='0' VAL3='0' VAL4='0' VAL5='0' ICON='"+favIconPath+"' OBJ_TYPE='"+favObjType+"'><![CDATA["+favDecr+" ]]></LEVEL>");
							}
							mXML.append("</APP>");
							if(preStat != null)
							{
								preStat.close();
								preStat = null;
							}
							if(rs != null)
							{
								rs.close();
								rs = null;
							}
						}
					}
					while(favRs.next());
				}
				if(favPreStat != null)
				{
					favPreStat.close();
					favPreStat = null;
				}
				if(favRs != null)
				{
					favRs.close();
					favRs = null;
				}

				//added by gayatri [to add favourites from user_rights]end
				//changed by gayatri on 07-02-2011 [To give an option of favorite menus on the screen to the user for faster access To the menus most frequently used][SY90SUN029]end
				/*menuSelQry = "SELECT A.APPLICATION APP,WIN_NAME, B.MENU_PATH MPATH,DESCR,ICON_PATH,OBJ_TYPE  FROM USER_RIGHTS A, ITM2MENU B " +
						"WHERE PROFILE_ID = '" + profileID + "'" +
						"AND A.APPLICATION=B.APPLICATION AND LEVEL_1=MENU_ROW AND LEVEL_2=MENU_COL " +
						"AND MENU_SUBCOL=LEVEL_3 AND A.LEVEL_4=B.LEVEL_4 AND A.LEVEL_5=B.LEVEL_5 " +
						"ORDER BY A.APPLICATION,MENU_ROW,MENU_COL,MENU_SUBCOL,A.LEVEL_4,A.LEVEL_5";*/
				//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]START
				/*menuSelQry = "SELECT A.APPLICATION APP,WIN_NAME, B.MENU_PATH MPATH,DESCR,ICON_PATH,OBJ_TYPE  FROM USER_RIGHTS A, ITM2MENU B " + //$NON-NLS-1$
						"WHERE PROFILE_ID = '" + profileID + "'" + //$NON-NLS-1$ //$NON-NLS-2$
						"AND A.APPLICATION=B.APPLICATION AND LEVEL_1=MENU_ROW AND LEVEL_2=MENU_COL " + //$NON-NLS-1$
						"AND MENU_SUBCOL=LEVEL_3 AND A.LEVEL_4=B.LEVEL_4 AND A.LEVEL_5=B.LEVEL_5 " +  //$NON-NLS-1$
						"ORDER BY A.APPLICATION,MENU_ROW,MENU_COL,MENU_SUBCOL,A.LEVEL_4,A.LEVEL_5";*/ //$NON-NLS-1$
				menuSelQry = "SELECT A.APPLICATION APP,WIN_NAME, B.MENU_PATH MPATH,DESCR,ICON_PATH,OBJ_TYPE  FROM USER_RIGHTS A, ITM2MENU B " + //$NON-NLS-1$
						"WHERE PROFILE_ID IN " + E12GenericUtility.getFormattedProfileId(profileID) +" "+ //$NON-NLS-1$ //$NON-NLS-2$
						"AND A.APPLICATION=B.APPLICATION AND LEVEL_1=MENU_ROW AND LEVEL_2=MENU_COL " + //$NON-NLS-1$
						"AND MENU_SUBCOL=LEVEL_3 AND A.LEVEL_4=B.LEVEL_4 AND A.LEVEL_5=B.LEVEL_5 " +  //$NON-NLS-1$
						"ORDER BY A.APPLICATION,MENU_ROW,MENU_COL,MENU_SUBCOL,A.LEVEL_4,A.LEVEL_5";
				//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]END
			}
			else
			{
				menuSelQry = "SELECT APPLICATION APP,WIN_NAME, MENU_PATH MPATH,DESCR,ICON_PATH,OBJ_TYPE FROM ITM2MENU WHERE WIN_NAME NOT IN ('-') ORDER BY APPLICATION,level_1,level_2,Level_3,LEVEL_4,LEVEL_5"; //$NON-NLS-1$
				//Changed by gayatri  on 07-02-2011[To give an option of favorite menus on the screen to the user for faster access To the menus most frequently used][SY90SUN029]start
				String selectObjName="SELECT OBJ_NAME FROM USER_OBJ_FAV WHERE USER_ID='"+userCode+"'"; //$NON-NLS-1$ //$NON-NLS-2$
				//BaseLogger.log("3", null, null,"selectObjName2 = ["+selectObjName+"]");
				mStatement = mConnection.createStatement();
				mResultSet = mStatement.executeQuery(selectObjName);
				if( mResultSet.next() )
				{
					mXML.append("<APP ANAME='FAV'>"); //$NON-NLS-1$
					do
					{
						String winName="w_"+mResultSet.getString("OBJ_NAME"); //$NON-NLS-1$ //$NON-NLS-2$
						String selectFavoriteQry = "SELECT WIN_NAME,DESCR,ICON_PATH,OBJ_TYPE FROM ITM2MENU WHERE WIN_NAME='"+winName.trim()+"'"; //$NON-NLS-1$ //$NON-NLS-2$
						BaseLogger.log("3", null, null,"user level 0 selectFavoriteQry = ["+selectFavoriteQry+"]"); //$NON-NLS-1$ //$NON-NLS-2$
						//Statement fStat = mConnection.createStatement();
						//ResultSet fResultSet = fStat.executeQuery(selectFavoriteQry);
						//if(fResultSet.next())
						//{
						//mXML.append("<LEVEL  WIN='"+fResultSet.getString("WIN_NAME")+"' VAL1='0' VAL2='0' VAL3='0' VAL4='0' VAL5='0' ICON='"+fResultSet.getString("ICON_PATH")+"' OBJ_TYPE='"+fResultSet.getString("OBJ_TYPE")+"'><![CDATA["+fResultSet.getString("DESCR")+" ]]></LEVEL>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$
						//}
						//fStat=null;
						//fResultSet=null;


						Statement fStat = mConnection.createStatement();
						ResultSet fResultSet = fStat.executeQuery(selectFavoriteQry);
						if(fResultSet.next())
						{
							String favWinName = fResultSet.getString("WIN_NAME");
							//Changed by gayatri [to add favourites from user_rights ]
							favObjName.add(favWinName);
							String favIconPath = fResultSet.getString("ICON_PATH");
							String favObjType = fResultSet.getString("OBJ_TYPE");
							String favDecr = fResultSet.getString("DESCR");

							BaseLogger.log("3", null, null,"favDecr user level 0["+favDecr+"]");

							mXML.append("<LEVEL  WIN='"+favWinName+"' VAL1='0' VAL2='0' VAL3='0' VAL4='0' VAL5='0' ICON='"+favIconPath+"' OBJ_TYPE='"+favObjType+"'><![CDATA["+favDecr+" ]]></LEVEL>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$
						}

						if ( fStat != null )
						{
							fStat.close();
							fStat = null;
						}
						if ( fResultSet != null )
						{
							fResultSet.close();
							fResultSet = null;
						}

					}	while(mResultSet.next());

					mXML.append("</APP>"); //$NON-NLS-1$
				}
				if ( mStatement != null  )
				{
					mStatement.close();
					mStatement = null;
				}
				if ( mResultSet != null )
				{
					mResultSet.close();
					mResultSet = null;
				}
				//Changed by gayatri  on 07-02-2011[To give an option of favourite menus on the screen to the user for faster access To the menus most frequently used][SY90SUN029]END
				//added by gayatri [to add favourites from user_rights]start
				PreparedStatement favPreStat = null;
				ResultSet favRs = null;
				//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
				//String favUserRights = "SELECT OBJ_NAME FROM USER_RIGHTS WHERE PROFILE_ID = ? AND FAV_OPTION = ?";
				String favUserRights = "SELECT OBJ_NAME FROM USER_RIGHTS WHERE PROFILE_ID IN "+ E12GenericUtility.getFormattedProfileId(profileID)+" AND FAV_OPTION = ?";
				favPreStat = mConnection.prepareStatement(favUserRights);
				//favPreStat.setString(1, profileID);
				favPreStat.setString(1, "Y");
				favRs = favPreStat.executeQuery();
				if(favRs.next())
				{
					do
					{
						String winName = "w_" + favRs.getString("OBJ_NAME");
						if(!favObjName.isEmpty() && !favObjName.contains(winName))
						{
							mXML.append("<APP ANAME = 'RIGHTFAV'>");
							String selectFavQry = "SELECT WIN_NAME,DESCR,ICON_PATH,OBJ_TYPE FROM ITM2MENU WHERE WIN_NAME= ? ";
							PreparedStatement preStat = null;
							ResultSet rs = null;
							preStat = mConnection.prepareStatement(selectFavQry);
							preStat.setString(1 , winName );
							rs = preStat.executeQuery();
							if(rs.next())
							{
								String favWinName = rs.getString("WIN_NAME");
								String favIconPath = rs.getString("ICON_PATH");
								String favObjType = rs.getString("OBJ_TYPE");
								String favDecr = rs.getString("DESCR");

								BaseLogger.log("3", null, null,"favDecr ["+favDecr+"]");
								mXML.append("<LEVEL  WIN='"+favWinName+"' VAL1='0' VAL2='0' VAL3='0' VAL4='0' VAL5='0' ICON='"+favIconPath+"' OBJ_TYPE='"+favObjType+"'><![CDATA["+favDecr+" ]]></LEVEL>");
							}
							mXML.append("</APP>");
							if(preStat != null)
							{
								preStat.close();
								preStat = null;
							}
							if(rs != null)
							{
								rs.close();
								rs = null;
							}
						}
					}
					while(favRs.next());
				}
				if(favPreStat != null)
				{
					favPreStat.close();
					favPreStat = null;
				}
				if(favRs != null)
				{
					favRs.close();
					favRs = null;
				}

				//added by gayatri [to add favourites from user_rights]end
			}
			mStatement = mConnection.createStatement();
			mResultSet = mStatement.executeQuery(menuSelQry);
			boolean recFound = false;
			while (mResultSet.next())
			{
				recFound = true;
				appln = mResultSet.getString("APP"); //$NON-NLS-1$
				mWinName = mResultSet.getString("WIN_NAME"); //$NON-NLS-1$
				mpath = mResultSet.getString("MPATH"); //$NON-NLS-1$
				BaseLogger.log("3", null, null,"mpath-------------------------------------------:"+mpath); //$NON-NLS-1$
				if(mpath != null)
				{
					tpath = mpath.substring( mpath.indexOf( '.' ) + 1 );
					tpath1 = tpath.substring( tpath.indexOf( '.' )+1, tpath.lastIndexOf( '.' )  );
					tpath2 = tpath1.substring(tpath1.indexOf('.'));
					level1 = tpath.substring(0,tpath.indexOf('.'));
					level2 = tpath1.substring(0,tpath1.indexOf('.'));
					level3 = tpath2.substring(tpath2.indexOf('.')+1,tpath2.lastIndexOf('.')  );
					level4 = tpath1.substring(tpath1.lastIndexOf('.')+1  );
					level5 = mpath.substring(mpath.lastIndexOf('.')+1  );
					app_descr = mResultSet.getString("DESCR"); //$NON-NLS-1$
					BaseLogger.log("3", null, null,"app_descr ["+app_descr+"]");
					mIconPath = mResultSet.getString("ICON_PATH"); //$NON-NLS-1$
					mObjType = mResultSet.getString("OBJ_TYPE"); //$NON-NLS-1$
					if (!(appln.equals(tApp)))
					{
						tApp = appln;
						if (rno>1)
						{
							mXML.append("</APP>"); //$NON-NLS-1$
						}
						if (rno==1)
						{
							rno++;
						}
						mXML.append("<APP ANAME='" + appln + "'>"); //$NON-NLS-1$ //$NON-NLS-2$
					}
					if ( ! level1.equals("0"))  //$NON-NLS-1$
					{
						//if level 1 is defined then generates the child of application
						qry="SELECT DESCR,ICON_PATH  FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
								" AND LEVEL_1=0 AND LEVEL_2=0 AND LEVEL_3 = 0 AND LEVEL_4=0 AND LEVEL_5=0"; //$NON-NLS-1$
						mStatement1 = mConnection.createStatement();
						mResultSet1 = mStatement1.executeQuery(qry);
						if(mResultSet1.next())
						{
							prev_descr1 = mResultSet1.getString("DESCR"); //$NON-NLS-1$
							prevIconPath = mResultSet1.getString("ICON_PATH"); //$NON-NLS-1$
						}
						mResultSet1.close();
						mStatement1.close();
						mStatement1 = null;

						if (!((prev_descr1.equals(tLev1_descr))))
						{
							tLev1_descr=prev_descr1;
							mXML.append("<LEVEL WIN='0' VAL1='0' VAL2='0' VAL3='0' VAL4='0' VAL5='0' ICON='"+prevIconPath+"' OBJ_TYPE=''><![CDATA[" + prev_descr1 + " ]]>"); //For level //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
							mXML.append("</LEVEL>"); //$NON-NLS-1$
						}
					}
					if (!(level2.equals("0")))  //$NON-NLS-1$
					{
						//if level 2 is defined then generates the child of level 1
						qry="SELECT DESCR,ICON_PATH FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
								"AND LEVEL_1= " + level1 + " AND LEVEL_2=0 AND LEVEL_3 = 0 AND LEVEL_4=0 AND LEVEL_5=0"; //$NON-NLS-1$ //$NON-NLS-2$
						mStatement1 = mConnection.createStatement();
						mResultSet1 = mStatement1.executeQuery(qry);
						if(mResultSet1.next())
						{
							prev_descr2 =mResultSet1.getString("DESCR"); //$NON-NLS-1$
							prevIconPath =mResultSet1.getString("ICON_PATH"); //$NON-NLS-1$
						}
						mResultSet1.close();
						mStatement1.close();
						mStatement1 = null;

						if (!((prev_descr2.equals(tLev2_descr))))
						{
							tLev2_descr=prev_descr2;
							mXML.append("<LEVEL WIN='0' VAL1='" + level1 + "' VAL2='0' VAL3='0' VAL4='0' VAL5='0' ICON='"+prevIconPath+"' OBJ_TYPE=''><![CDATA[" + prev_descr2 + " ]]>"); //For level //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
							mXML.append("</LEVEL>"); //$NON-NLS-1$
						}
					}
					if (!(level3.equals("0")))  //$NON-NLS-1$
					{
						//if level 3 is defined then generates the child of node at level 2
						qry="SELECT DESCR,ICON_PATH FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
								"AND LEVEL_1= " + level1+ " AND LEVEL_2= " + level2 + " AND LEVEL_3 = 0 AND LEVEL_4=0 AND LEVEL_5=0"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						mStatement1 = mConnection.createStatement();
						mResultSet1 = mStatement1.executeQuery(qry);

						if(mResultSet1.next())
						{
							prev_descr3 =mResultSet1.getString("DESCR"); //$NON-NLS-1$
							prevIconPath =mResultSet1.getString("ICON_PATH"); //$NON-NLS-1$

						}
						mResultSet1.close();
						mStatement1.close();
						mStatement1 = null;

						if (!((prev_descr3.equals(tLev3_descr))))
						{
							tLev3_descr=prev_descr3;
							mXML.append("<LEVEL WIN='0' VAL1='" + level1 + "' VAL2='" + level2 + "' VAL3='0' VAL4='0' VAL5='0' ICON='"+prevIconPath+"' OBJ_TYPE=''><![CDATA[" + prev_descr3 + " ]]>"); //For level //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
							mXML.append("</LEVEL>"); //$NON-NLS-1$
						}
					}
					if (!(level4.equals("0"))) //$NON-NLS-1$
					{
						//if level 4 is defined then generates the child of node at level 3
						qry="SELECT DESCR,ICON_PATH  FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
								" AND LEVEL_1= " + level1 + " AND LEVEL_2="+ level2 +  //$NON-NLS-1$ //$NON-NLS-2$
								" AND LEVEL_3 = "+ level3 + " AND LEVEL_4=0 AND LEVEL_5=0"; //$NON-NLS-1$ //$NON-NLS-2$

						mStatement1 = mConnection.createStatement();
						mResultSet1 = mStatement1.executeQuery(qry);
						// updated by rahul - start
						//mResultSet1.next();
						//prev_descr4 =mResultSet1.getString("DESCR");
						if(mResultSet1.next())
						{
							prev_descr4 =mResultSet1.getString("DESCR"); //$NON-NLS-1$
							prevIconPath =mResultSet1.getString("ICON_PATH");					 //$NON-NLS-1$
						}
						mResultSet1.close();
						mStatement1.close();
						mStatement1 = null;
						if (!((prev_descr4.equals(tLev4_descr))))
						{
							tLev4_descr = prev_descr4;
							mXML.append("<LEVEL WIN='0' VAL1='" + level1 + "' VAL2='" +  //$NON-NLS-1$ //$NON-NLS-2$
									level2 + "' VAL3='" + level3 + "' VAL4='0' VAL5='0' ICON='"+prevIconPath+"' OBJ_TYPE=''><![CDATA[" + prev_descr4 + " ]]>"); //For level //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
							mXML.append("</LEVEL>"); //$NON-NLS-1$
						}
					}
					if (!(level5.equals("0")))  //$NON-NLS-1$
					{
						//if level 5 is defined then generates the child of node at level 4 - rahul
						qry="SELECT DESCR,ICON_PATH  FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
								" AND LEVEL_1= " + level1 + " AND LEVEL_2="+ level2 +  //$NON-NLS-1$ //$NON-NLS-2$
								" AND LEVEL_3 = "+ level3 + " AND LEVEL_4=" + level4 + " AND LEVEL_5=0"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$

						mStatement1 = mConnection.createStatement();
						mResultSet1 = mStatement1.executeQuery(qry);
						if(mResultSet1.next())
						{
							prev_descr5 =mResultSet1.getString("DESCR"); //$NON-NLS-1$
							prevIconPath =mResultSet1.getString("ICON_PATH"); //$NON-NLS-1$
						}
						mResultSet1.close();
						mStatement1.close();
						mStatement1 = null;

						if (!((prev_descr5.equals(tLev5_descr))))
						{
							tLev5_descr=prev_descr5;
							mXML.append("<LEVEL WIN='0' VAL1='" + level1 + "' VAL2='" +  //$NON-NLS-1$ //$NON-NLS-2$
									level2 + "' VAL3='" + level3 + "' VAL4='" + level4 + //$NON-NLS-1$ //$NON-NLS-2$
									"' VAL5='0' ICON='"+prevIconPath+"' OBJ_TYPE=''><![CDATA[" + prev_descr5 + " ]]>"); //For level 4 //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
							mXML.append("</LEVEL>"); //$NON-NLS-1$
						}
					}
					mXML.append("<LEVEL  WIN='" + mWinName + "' VAL1='" + level1 + "' VAL2='" + level2 + "' VAL3='" + level3 + "' VAL4='" + level4 + "' VAL5='" + level5 + "' ICON='"+mIconPath+"' OBJ_TYPE='"+mObjType+"'><![CDATA[" + app_descr + " ]]>"); //For level //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$
					mXML.append("</LEVEL>"); //$NON-NLS-1$
				}//if(mpath != null)
			}
			if (recFound)
			{
				mXML.append("</APP>"); //$NON-NLS-1$
			}
			mXML.append("</ROOT>");		 //$NON-NLS-1$
			mResultSet.close();
			mResultSet = null;
			mStatement.close();
			mStatement = null;
			BaseLogger.log("3", null, null,"(DBAccessEJB:getUserXML)UserXML: Built"); //$NON-NLS-1$
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException: DBAccess: getUserXML: ==>UserXML: Not Built(Generic Exception)\n"); //$NON-NLS-1$
			throw itme;
		}
		catch(SQLException ex)
		{
			System.err.println("Exception: DBAccess: getUserXML: ==>UserXML: Not Built(SQLException)\n" + ex); //$NON-NLS-1$
			ex.printStackTrace();
			//return mXML.toString();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccess: getUserXML: ==>UserXML: Not Built(Generic Exception)\n" + e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(mStatement != null)
					{
						mStatement.close();
					}
					if(mStatement1 != null)
					{
						mStatement1.close();
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getUserXML ==>UserXML: Not Built F\n" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("3", null, null,"DBAccess menu created of length ["+mXML.toString().length()+"]");
		return mXML.toString();
	}
	//Changed by Rupali Hande for [to retrived the menus only for MOB_DEPLOY="M" option].RequestID[WI89SUN020].Start
	// Changed By Dilip Mane on 12/02/08 for [ getting user menu xml on for mobile client ] Start
	/**
	 *This method accepts the usercode and returns XML String
	 *It generates the XML for the menu
	 *@param  <code >usercode usercode</code >
	 *@param <code>profileID </code>
	 *@param <code>isMobileMenu </code> M for Mobile cilent
	 *@return XML api as String
	 *@exception RemoteException,ITMException
	 *
	 */
	public String getUserXML(String userCode, String profileID, String isMobileMenu ) throws RemoteException,ITMException
	{
		StringBuffer mXML = new StringBuffer("<ROOT>"); //$NON-NLS-1$
		Connection mConnection = null;
		Statement mStatement = null;
		ResultSet mResultSet = null;
		Statement mStatement1 = null;
		ResultSet mResultSet1 = null;
		try
		{
			String tApp=null;
			String prev_descr1 = null;
			String prev_descr2 = null;
			String prev_descr3 = null;
			String prev_descr4 = null;
			String prev_descr5 = null;

			String mIconPath = ""; //$NON-NLS-1$
			String prevIconPath = ""; //$NON-NLS-1$
			String mObjType = ""; //$NON-NLS-1$

			String app_descr,mpath,appln,level1,level2,level3,level4,level5;
			String tLev1_descr = "",tLev2_descr = "",tLev3_descr = "",tLev4_descr = "",tLev5_descr = ""; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
			String tpath,tpath1,tpath2,qry,mWinName;
			int rno=1;
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver"); //$NON-NLS-1$
			String usrLevSelQry = "SELECT USR_LEV FROM USERS WHERE CODE ='" + userCode + "'"; //$NON-NLS-1$ //$NON-NLS-2$
			mStatement = mConnection.createStatement();
			mResultSet = mStatement.executeQuery(usrLevSelQry);
			int level = 0;
			if(mResultSet.next())
			{
				level = mResultSet.getInt("USR_LEV"); //$NON-NLS-1$
			}
			mResultSet.close();
			mStatement.close();
			mStatement = null;
			String menuSelQry = null;

			if ( isMobileMenu !=null && isMobileMenu.trim().length() > 0 )
			{
				if( level >= 1 )
				{
					//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]START
					/*menuSelQry = "SELECT A.APPLICATION APP,WIN_NAME, B.MENU_PATH MPATH,DESCR,ICON_PATH,OBJ_TYPE  FROM USER_RIGHTS A, ITM2MENU B " + //$NON-NLS-1$
							"WHERE PROFILE_ID = '" + profileID + "'" +"AND MOB_DEPLOY = '"+isMobileMenu+"'"+ //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
							"AND A.APPLICATION=B.APPLICATION AND LEVEL_1=MENU_ROW AND LEVEL_2=MENU_COL " + //$NON-NLS-1$
							"AND MENU_SUBCOL=LEVEL_3 AND A.LEVEL_4=B.LEVEL_4 AND A.LEVEL_5=B.LEVEL_5 " +  //$NON-NLS-1$
							"ORDER BY A.APPLICATION,MENU_ROW,MENU_COL,MENU_SUBCOL,A.LEVEL_4,A.LEVEL_5";*/ //$NON-NLS-1$
					menuSelQry = "SELECT A.APPLICATION APP,WIN_NAME, B.MENU_PATH MPATH,DESCR,ICON_PATH,OBJ_TYPE  FROM USER_RIGHTS A, ITM2MENU B " + //$NON-NLS-1$
							"WHERE PROFILE_ID IN " + E12GenericUtility.getFormattedProfileId(profileID) +" AND MOB_DEPLOY = '"+isMobileMenu+"'"+ //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
							"AND A.APPLICATION=B.APPLICATION AND LEVEL_1=MENU_ROW AND LEVEL_2=MENU_COL " + //$NON-NLS-1$
							"AND MENU_SUBCOL=LEVEL_3 AND A.LEVEL_4=B.LEVEL_4 AND A.LEVEL_5=B.LEVEL_5 " +  //$NON-NLS-1$
							"ORDER BY A.APPLICATION,MENU_ROW,MENU_COL,MENU_SUBCOL,A.LEVEL_4,A.LEVEL_5";
					//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]END
				}
				else
				{
					menuSelQry = "SELECT APPLICATION APP,WIN_NAME, MENU_PATH MPATH,DESCR,ICON_PATH,OBJ_TYPE FROM ITM2MENU WHERE WIN_NAME NOT IN ('-')" +"AND MOB_DEPLOY = '"+isMobileMenu+"'"+"ORDER BY APPLICATION,level_1,level_2,Level_3,LEVEL_4,LEVEL_5";				 //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				}

			}
			else
			{
				if( level >= 1 )
				{
					//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]START
					/*menuSelQry = "SELECT A.APPLICATION APP,WIN_NAME, B.MENU_PATH MPATH,DESCR,ICON_PATH,OBJ_TYPE  FROM USER_RIGHTS A, ITM2MENU B " + //$NON-NLS-1$
							"WHERE PROFILE_ID = '" + profileID + "'" + //$NON-NLS-1$ //$NON-NLS-2$
							"AND A.APPLICATION=B.APPLICATION AND LEVEL_1=MENU_ROW AND LEVEL_2=MENU_COL " + //$NON-NLS-1$
							"AND MENU_SUBCOL=LEVEL_3 AND A.LEVEL_4=B.LEVEL_4 AND A.LEVEL_5=B.LEVEL_5 " +  //$NON-NLS-1$
							"ORDER BY A.APPLICATION,MENU_ROW,MENU_COL,MENU_SUBCOL,A.LEVEL_4,A.LEVEL_5";*/ //$NON-NLS-1$
					menuSelQry = "SELECT A.APPLICATION APP,WIN_NAME, B.MENU_PATH MPATH,DESCR,ICON_PATH,OBJ_TYPE  FROM USER_RIGHTS A, ITM2MENU B " + //$NON-NLS-1$
							"WHERE PROFILE_ID IN " + E12GenericUtility.getFormattedProfileId(profileID) +" "+ //$NON-NLS-1$ //$NON-NLS-2$
							"AND A.APPLICATION=B.APPLICATION AND LEVEL_1=MENU_ROW AND LEVEL_2=MENU_COL " + //$NON-NLS-1$
							"AND MENU_SUBCOL=LEVEL_3 AND A.LEVEL_4=B.LEVEL_4 AND A.LEVEL_5=B.LEVEL_5 " +  //$NON-NLS-1$
							"ORDER BY A.APPLICATION,MENU_ROW,MENU_COL,MENU_SUBCOL,A.LEVEL_4,A.LEVEL_5";
					//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]END
				}
				else
				{
					menuSelQry = "SELECT APPLICATION APP,WIN_NAME, MENU_PATH MPATH,DESCR,ICON_PATH,OBJ_TYPE FROM ITM2MENU WHERE WIN_NAME NOT IN ('-') ORDER BY APPLICATION,level_1,level_2,Level_3,LEVEL_4,LEVEL_5";				 //$NON-NLS-1$
				}
			}

			BaseLogger.log("3", null, null,"DBAccessEJB: menuSelQry    ["+menuSelQry+"]");	 //$NON-NLS-1$ //$NON-NLS-2$
			mStatement = mConnection.createStatement();
			mResultSet = mStatement.executeQuery(menuSelQry);
			boolean recFound = false;
			while (mResultSet.next())
			{
				recFound = true;
				appln = mResultSet.getString("APP"); //$NON-NLS-1$
				mWinName = mResultSet.getString("WIN_NAME"); //$NON-NLS-1$
				mpath = mResultSet.getString("MPATH"); //$NON-NLS-1$
				BaseLogger.log("3", null, null, "DBAccessEJB :: getting menu xml  "); //$NON-NLS-1$
				BaseLogger.log("3", null, null,"mpath-------------------------------------------:"+mpath); //$NON-NLS-1$
				if(mpath != null)
				{
					tpath = mpath.substring( mpath.indexOf( '.' ) + 1 );
					tpath1 = tpath.substring( tpath.indexOf( '.' )+1, tpath.lastIndexOf( '.' )  );
					tpath2 = tpath1.substring(tpath1.indexOf('.'));
					level1 = tpath.substring(0,tpath.indexOf('.'));
					level2 = tpath1.substring(0,tpath1.indexOf('.'));
					level3 = tpath2.substring(tpath2.indexOf('.')+1,tpath2.lastIndexOf('.')  );
					level4 = tpath1.substring(tpath1.lastIndexOf('.')+1  );
					level5 = mpath.substring(mpath.lastIndexOf('.')+1  );

					BaseLogger.log("3", null, null, "Level 1 [ "+level1+ "]" ); //$NON-NLS-1$ //$NON-NLS-2$
					BaseLogger.log("3", null, null, "Level 2 [ "+level2+ "]" ); //$NON-NLS-1$ //$NON-NLS-2$
					BaseLogger.log("3", null, null, "Level 3 [ "+level3+ "]" ); //$NON-NLS-1$ //$NON-NLS-2$
					BaseLogger.log("3", null, null, "Level 4 [ "+level4+ "]" ); //$NON-NLS-1$ //$NON-NLS-2$
					BaseLogger.log("3", null, null, "Level 5 [ "+level5+ "]" ); //$NON-NLS-1$ //$NON-NLS-2$

					app_descr = mResultSet.getString("DESCR"); //$NON-NLS-1$
					mIconPath = mResultSet.getString("ICON_PATH"); //$NON-NLS-1$
					mObjType = mResultSet.getString("OBJ_TYPE"); //$NON-NLS-1$
					if (!(appln.equals(tApp)))
					{
						tApp = appln;
						if (rno>1)
						{
							mXML.append("</APP>"); //$NON-NLS-1$
						}
						if (rno==1)
						{
							rno++;
						}
						BaseLogger.log("3", null, null, "DBAccessEJB ApplicationName [ "+appln+ "]");  //$NON-NLS-1$ //$NON-NLS-2$
						mXML.append("<APP ANAME='" + appln + "'>"); //$NON-NLS-1$ //$NON-NLS-2$
					}
					if ( ! level1.equals("0"))  //$NON-NLS-1$
					{
						//if level 1 is defined then generates the child of application
						qry="SELECT DESCR,ICON_PATH  FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
								" AND LEVEL_1=0 AND LEVEL_2=0 AND LEVEL_3 = 0 AND LEVEL_4=0 AND LEVEL_5=0"; //$NON-NLS-1$
						mStatement1 = mConnection.createStatement();
						mResultSet1 = mStatement1.executeQuery(qry);
						if(mResultSet1.next())
						{
							prev_descr1 = mResultSet1.getString("DESCR"); //$NON-NLS-1$
							prevIconPath = mResultSet1.getString("ICON_PATH"); //$NON-NLS-1$
						}
						mStatement1.close();
						mStatement1 = null;

						if (!((prev_descr1.equals(tLev1_descr))))
						{
							tLev1_descr=prev_descr1;
							mXML.append("<LEVEL WIN='0' VAL1='0' VAL2='0' VAL3='0' VAL4='0' VAL5='0' ICON='"+prevIconPath+"' OBJ_TYPE=''><![CDATA[" + prev_descr1 + " ]]>"); //For level //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
							mXML.append("</LEVEL>"); //$NON-NLS-1$
						}
					}
					BaseLogger.log("3", null, null, "DBAaceesEJB :: level 2 [" +level2+"]" ); //$NON-NLS-1$ //$NON-NLS-2$
					if (!(level2.equals("0")))  //$NON-NLS-1$
					{
						//if level 2 is defined then generates the child of level 1
						qry="SELECT DESCR,ICON_PATH FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
								"AND LEVEL_1= " + level1 + " AND LEVEL_2=0 AND LEVEL_3 = 0 AND LEVEL_4=0 AND LEVEL_5=0"; //$NON-NLS-1$ //$NON-NLS-2$
						mStatement1 = mConnection.createStatement();
						mResultSet1 = mStatement1.executeQuery(qry);
						if(mResultSet1.next())
						{
							prev_descr2 =mResultSet1.getString("DESCR"); //$NON-NLS-1$
							prevIconPath =mResultSet1.getString("ICON_PATH"); //$NON-NLS-1$
						}
						mStatement1.close();
						mStatement1 = null;
						BaseLogger.log("3", null, null, "DBAaceesEJB :: prev_descr2 [" +prev_descr2+"] tLev2_descr [ "+tLev2_descr+" ]"  ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						if (!((prev_descr2.equals(tLev2_descr))))
						{
							tLev2_descr=prev_descr2;
							mXML.append("<LEVEL WIN='0' VAL1='" + level1 + "' VAL2='0' VAL3='0' VAL4='0' VAL5='0' ICON='"+prevIconPath+"' OBJ_TYPE=''><![CDATA[" + prev_descr2 + " ]]>"); //For level //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
							mXML.append("</LEVEL>"); //$NON-NLS-1$
						}
					}
					if (!(level3.equals("0")))  //$NON-NLS-1$
					{
						//if level 3 is defined then generates the child of node at level 2
						qry="SELECT DESCR,ICON_PATH FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
								"AND LEVEL_1= " + level1+ " AND LEVEL_2= " + level2 + " AND LEVEL_3 = 0 AND LEVEL_4=0 AND LEVEL_5=0"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						mStatement1 = mConnection.createStatement();
						mResultSet1 = mStatement1.executeQuery(qry);

						if(mResultSet1.next())
						{
							prev_descr3 =mResultSet1.getString("DESCR"); //$NON-NLS-1$
							prevIconPath =mResultSet1.getString("ICON_PATH"); //$NON-NLS-1$

						}
						mStatement1.close();
						mStatement1 = null;

						if (!((prev_descr3.equals(tLev3_descr))))
						{
							tLev3_descr=prev_descr3;
							mXML.append("<LEVEL WIN='0' VAL1='" + level1 + "' VAL2='" + level2 + "' VAL3='0' VAL4='0' VAL5='0' ICON='"+prevIconPath+"' OBJ_TYPE=''><![CDATA[" + prev_descr3 + " ]]>"); //For level //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
							mXML.append("</LEVEL>"); //$NON-NLS-1$
						}
					}
					if (!(level4.equals("0"))) //$NON-NLS-1$
					{
						//if level 4 is defined then generates the child of node at level 3
						qry="SELECT DESCR,ICON_PATH  FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
								" AND LEVEL_1= " + level1 + " AND LEVEL_2="+ level2 +  //$NON-NLS-1$ //$NON-NLS-2$
								" AND LEVEL_3 = "+ level3 + " AND LEVEL_4=0 AND LEVEL_5=0"; //$NON-NLS-1$ //$NON-NLS-2$

						mStatement1 = mConnection.createStatement();
						mResultSet1 = mStatement1.executeQuery(qry);
						// updated by rahul - start
						//mResultSet1.next();
						//prev_descr4 =mResultSet1.getString("DESCR");
						if(mResultSet1.next())
						{
							prev_descr4 =mResultSet1.getString("DESCR"); //$NON-NLS-1$
							prevIconPath =mResultSet1.getString("ICON_PATH");					 //$NON-NLS-1$
						}

						mStatement1.close();
						mStatement1 = null;
						if (!((prev_descr4.equals(tLev4_descr))))
						{
							tLev4_descr = prev_descr4;
							mXML.append("<LEVEL WIN='0' VAL1='" + level1 + "' VAL2='" +  //$NON-NLS-1$ //$NON-NLS-2$
									level2 + "' VAL3='" + level3 + "' VAL4='0' VAL5='0' ICON='"+prevIconPath+"' OBJ_TYPE=''><![CDATA[" + prev_descr4 + " ]]>"); //For level //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
							mXML.append("</LEVEL>"); //$NON-NLS-1$
						}
					}
					if (!(level5.equals("0")))  //$NON-NLS-1$
					{
						//if level 5 is defined then generates the child of node at level 4 - rahul
						qry="SELECT DESCR,ICON_PATH  FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
								" AND LEVEL_1= " + level1 + " AND LEVEL_2="+ level2 +  //$NON-NLS-1$ //$NON-NLS-2$
								" AND LEVEL_3 = "+ level3 + " AND LEVEL_4=" + level4 + " AND LEVEL_5=0"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$

						mStatement1 = mConnection.createStatement();
						mResultSet1 = mStatement1.executeQuery(qry);
						if(mResultSet1.next())
						{
							prev_descr5 =mResultSet1.getString("DESCR"); //$NON-NLS-1$
							prevIconPath =mResultSet1.getString("ICON_PATH"); //$NON-NLS-1$
						}
						mStatement1.close();
						mStatement1 = null;

						if (!((prev_descr5.equals(tLev5_descr))))
						{
							tLev5_descr=prev_descr5;
							mXML.append("<LEVEL WIN='0' VAL1='" + level1 + "' VAL2='" +  //$NON-NLS-1$ //$NON-NLS-2$
									level2 + "' VAL3='" + level3 + "' VAL4='" + level4 + //$NON-NLS-1$ //$NON-NLS-2$
									"' VAL5='0' ICON='"+prevIconPath+"' OBJ_TYPE=''><![CDATA[" + prev_descr5 + " ]]>"); //For level 4 //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
							mXML.append("</LEVEL>"); //$NON-NLS-1$
						}
					}
					mXML.append("<LEVEL  WIN='" + mWinName + "' VAL1='" + level1 + "' VAL2='" + level2 + "' VAL3='" + level3 + "' VAL4='" + level4 + "' VAL5='" + level5 + "' ICON='"+mIconPath+"' OBJ_TYPE='"+mObjType+"'><![CDATA[" + app_descr + " ]]>"); //For level //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$
					mXML.append("</LEVEL>"); //$NON-NLS-1$
				}//if(mpath != null)
			}
			if (recFound)
			{
				mXML.append("</APP>"); //$NON-NLS-1$
			}
			mXML.append("</ROOT>");	 //$NON-NLS-1$
			mResultSet.close();
			mStatement.close();
			mStatement = null;
			BaseLogger.log("3", null, null,"(DBAccessEJB:getUserXML)UserXML 1475 : Built"); //$NON-NLS-1$
		}
		catch ( ITMException itme )
		{
			System.err.println("ITMException: DBAccess: getUserXML: ==>UserXML: Not Built(Generic Exception)\n"); //$NON-NLS-1$
			throw itme;
		}
		catch( SQLException ex )
		{
			System.err.println("Exception: DBAccess: getUserXML: ==>UserXML: Not Built(SQLException)\n" + ex); //$NON-NLS-1$
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccess: getUserXML: ==>UserXML: Not Built(Generic Exception)\n" + e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(mStatement != null)
					{
						mStatement.close();
					}
					if(mStatement1 != null)
					{
						mStatement1.close();
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getUserXML ==>UserXML: Not Built F\n" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		return mXML.toString();
	}
	// ChangedBy Dilip Mane on 12/02/08 for [ getting user menu xml on for mobile client ] End
	//Changed by Rupali Hande for [to retrived the menus only for MOB_DEPLOY="M" option].RequestID[WI89SUN020].End

	//Changed by HRUSIKESH BEHERA on 17/02/11, WS01SUN042 [Migrating Search Page into GWT],to make a single RPC call for collecting trans_ifno, col_info, formal arguments & action info Starts
	/**
	 * It gathers all the detail information (i.e. trans info, formal arguments & column info ) specific to
	 * the object & returns the same.
	 *
	 * @param objName
	 * @param pageContext
	 * @param metaDataFileName
	 * @param userInfo
	 * @return objDetail
	 * @throws
	 */
	//Changes made by Pratheek on 23/08/18[to pass the objType on process screen]-Start
//	public String getObjDetail( String objName, String pageContext, String metaDataFileName, UserInfoBean userInfo )throws RemoteException, ITMException
	public String getObjDetail( String objName, String pageContext, String metaDataFileName, UserInfoBean userInfo,String objtype )throws RemoteException, ITMException
	//Changes made by Pratheek on 23/08/18[to pass the objType on process screen]-End
	{
		BaseLogger.log("3", null, null,"In getObjDetail objName:["+objName+"], pageContext:["+pageContext+"]");
		StringBuffer objDetail = new StringBuffer( "<ROOT>" ); //$NON-NLS-1$
		try
		{
			String transInfoStr;
			String frmlArgInfoStr;

			//Changed by Gulzar on 24/01/17 : START
			ArrayList objFormsDetailList = null;
			String transDB = "";
			if( userInfo != null )
			{
				transDB = userInfo.getTransDB();
			}
			//if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
			{
				objFormsDetailList = this.getObjFormsDetailList( objName, userInfo );
			}
			getObjFormInfo(objFormsDetailList);
			//transInfoStr = this.getTransactionInfo( objName, pageContext, metaDataFileName, userInfo );
			//Changes made by Pratheek on 23/08/18[to prevent reading 21 and 22 metadata in process screen]-Start
//			transInfoStr = this.getTransactionInfo( objName, pageContext, metaDataFileName, userInfo, objFormsDetailList );
			transInfoStr = this.getTransactionInfo( objName, pageContext, metaDataFileName, userInfo, objFormsDetailList,objtype );
			////Changes made by Pratheek on 23/08/18[to prevent reading 21 and 22 metadata in process screen]-End
			//Changed by Gulzar on 24/01/17 : END

			//Changes made by Gulzar on 10/10/13 to support multiDB connection : START
			//String transDB = userInfo.getTransDB();//Gulzar on 24/01/17
			if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
			{
				frmlArgInfoStr = this.getUserInfoString( objName, userInfo.getLoginCode(), userInfo.getProfileId(), userInfo.getUserLevel(), userInfo );
			}
			else
			{
				// Commented and Added by Saiprasad on 15-03-19[START]
				//frmlArgInfoStr = this.getUserInfoString( objName, userInfo.getLoginCode(), userInfo.getProfileId(), userInfo.getUserLevel(), userInfo.getTransDB() );
				frmlArgInfoStr = this.getUserInfoString( objName, userInfo.getLoginCode(), userInfo.getProfileId(), userInfo.getUserLevel(), userInfo.getTransDB() , userInfo );
				// Commented and Added by Saiprasad on 15-03-19 [END]
			}

			//Changes made by Gulzar on 10/10/13 to support multiDB connection : END

			//Added By Ajinkya Gopalkar on 21-SEP-17[For code optimization and reduce server call] Start
			StringBuilder objItemChangeBuff = new StringBuilder("<ITEMCHANGE_FIELDS>") ;
			//if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
			{
//				dbValues = dbAccess.getObjFormsDetailList(objName, userInfo);
				for(int i = 0 ; i < objFormsDetailList.size() ; i++)
				{
					ArrayList currForm = (ArrayList) objFormsDetailList.get(i);
					String objContext = (String) currForm.get(14);
					String formName = (String) currForm.get(32);//Gulzar on 11/01/17
					ArrayList objICElmList = getItemChangeElementList( objName, objContext, userInfo );
					objItemChangeBuff.append("<ITEMCHANGE_FIELD objContext = '" + objContext + "' >").append("<![CDATA[" + getCommaSeperatedValue( objICElmList ) + "]]>").append("</ITEMCHANGE_FIELD>");
				}
			}
			/*else
			{
//				dbValues = dbAccess.getObjFormsDetailList(objName);
				for(int i = 0 ; i < objFormsDetailList.size() ; i++)
				{
					ArrayList currForm = (ArrayList) objFormsDetailList.get(i);
					String objContext = (String) currForm.get(14);
					String formName = (String) currForm.get(32);//Gulzar on 11/01/17
					ArrayList objICElmList = getItemChangeElementList( objName, objContext );
					objItemChangeBuff.append("<ITEMCHANGE_FIELD objContext = '" + objContext + "' >").append("<![CDATA[" + getCommaSeperatedValue( objICElmList ) + "]]>").append("</ITEMCHANGE_FIELD>");
				}

			}*/
			objItemChangeBuff.append("</ITEMCHANGE_FIELDS>");
			objItemChangeBuff.append("<NO_OFFLINE_ALLWD><![CDATA[0]]></NO_OFFLINE_ALLWD>");

			StringBuilder objnTitle = new StringBuilder();
			BaseLogger.log("3", null, null,"objFormsDetailList size:["+objFormsDetailList.size()+"]");
			for(int i = 0 ; i < objFormsDetailList.size() ; i++)
			{
				ArrayList currForm = (ArrayList)objFormsDetailList.get(i);
				String title = (String)currForm.get(0); //0
				String scanMetaData = (String) currForm.get(6); //1
				String objContext = (String) currForm.get(14); //2
				String scrFlag = (String) currForm.get(15); //3
				String dbFormType = (String) ( ( currForm.get(16) == null ) ? "" : currForm.get(16) ); //4
				String dispMetaData = (String) ( ( currForm.get(17) == null ) ? "" : currForm.get(17) ); //5
				String parentKeyCol = (String) ( ( currForm.get(18) == null ) ? "" : currForm.get(18) ); //6
				String assistedMode = (String) ( ( currForm.get(19) == null ) ? "" : currForm.get(19) ); //7
				String storageKeyMetadata = ( String ) currForm.get( 20 ); //8
				String selectionMode = ( String ) currForm.get( 21 ); //9
				String defaultView = ( String ) currForm.get( 22 ); //10
				String freezeColNum = ( String ) currForm.get( 24 ); //11
				String defRowCnt = ( String ) currForm.get( 25 ); //12
				String isMandatory = ( String ) currForm.get( 26 ); //13
				String tranIdCol = ( String ) currForm.get( 27 ); //14
				String keyInfo = ( String ) currForm.get( 28 ); //15
				String thumbObj = ( String ) currForm.get( 29 ); //16
				String thumbImageCol = ( String ) currForm.get( 30 ); //17
				String thumbAltCol = ( String ) currForm.get( 31 ); //18
				String formName = ( String ) currForm.get( 32 ); //19
				String formIcon = ( String ) currForm.get( 33 ); //20
				String formViewOpts = ( String ) currForm.get( 34 ); //21
				//Added by Sandeep S. on 24-NOV-17 [Implementation of Matrix-form detail form] Start
				String xColumn = ( String ) currForm.get( 35 );
				String yColumn = ( String ) currForm.get( 36 );
				//Added by Pankaj T. on 13-04-18 for display summary in side panel of define field in property_info column of obj_forms table - Start
				String propertyInfo = ( String ) currForm.get( 8 );
				BaseLogger.log("3", null, null,"propertyInfo for formNo["+(i+1)+"]:["+propertyInfo+"]");
				//Added by Pankaj T. on 13-04-18 for display summary in side panel of define field in property_info column of obj_forms table - End

//				BaseLogger.log("3", null, null,"title["+title+"] \nobjContext["+objContext+"] \nscrFlag["+scrFlag+"] \ndbFormType["+dbFormType+"] " + "\ndispMetaData[" + dispMetaData + "]\nparentKeyCol[" + parentKeyCol + "]\nscanMetaData[" + scanMetaData + "]\nassistedMode[" + assistedMode + "]\nStorageKeyMetadata[" + storageKeyMetadata + "]\nselectionMode[" + selectionMode + "]\ndefaultView[" + defaultView + "]\nfreezColNum[" + freezeColNum + "]\ndefRowCnt[ "+defRowCnt+"]\nisMandatory["+isMandatory+"]\nthumbObj["+thumbObj+"]\nthumbImageCol["+thumbImageCol+"]\nthumbAltCol["+thumbAltCol+"]\nformName["+formName+"]\nformIcon["+formIcon+"]\nkeyInfo["+keyInfo+"]\ntranIdCol["+tranIdCol+"]\nformViewOpts["+formViewOpts+"]" );
                //Changed By Ravindra C on 	06-2-18 [separator chnaged from '#' to '#SEP#']
                //Added by Pankaj T. on 13-04-18 for display summary in side panel of define field in property_info column of obj_forms table
				objnTitle.append( title + "#SEP#" + scrFlag + "#SEP#" + dbFormType+ "#SEP#" + dispMetaData + "#SEP#" + parentKeyCol + "#SEP#" + scanMetaData + "#SEP#" + assistedMode + "#SEP#" + storageKeyMetadata + "#SEP#" + selectionMode + "#SEP#" + defaultView + "#SEP#" + freezeColNum + "#SEP#" + defRowCnt + "#SEP#" + isMandatory + "#SEP#" + thumbObj +"#SEP#" + thumbImageCol +"#SEP#" + thumbAltCol +"#SEP#" + formName +"#SEP#" + formIcon + "#SEP#" + keyInfo + "#SEP#" + tranIdCol + "#SEP#" + formViewOpts + "#SEP#" + xColumn + "#SEP#" + yColumn + "#SEP#" + propertyInfo + "~" );
//				if(request.getSession().getAttribute("DUMP_FILE_PATH") != null)
//				{
//					request.getSession().setAttribute("DUMP_FILE_PATH", null) ;
//				}
			}
			objItemChangeBuff.append("<FORMS_DET><![CDATA["+ objnTitle.toString() +"]]></FORMS_DET>");
			//Added By Ajinkya Gopalkar on 21-SEP-17[For code optimization and reduce server call] End
			//ArgumentLocal argument = (ArgumentLocal) this.getInitialContext().lookup( "ibase/ArgumentEJB/local" ); //$NON-NLS-1$
			ArgumentEJB argument = new ArgumentEJB();

			//Changes made by Gulzar on 24/01/17 : START
			//String colInfoStr = argument.getColumnsInfo( objName );
			//Changes made by Pratheek on 25-01-19[to get the obj_detals value in reports]-Start
			String colInfoStr = "";
			if(!"R".equalsIgnoreCase(objtype))
			{
				colInfoStr = argument.getColumnsInfo( objName, this.objFormInfoMap );
			}
			//Changes made by Pratheek on 25-01-19[to get the obj_detals value in reports]-End
			//Changes made by Gulzar on 24/01/17 : END

			String acctYearDates = getAcctPrdXML( userInfo.getTransDB() );		//Added by Prajyot on 11-dec-14 [for getting  Account period]

			//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - start
			String tranMessages = getTransactionMessages(userInfo, objName);
			objDetail.append( transInfoStr ).append( objItemChangeBuff.toString() ).append( frmlArgInfoStr ).append( colInfoStr ).append( acctYearDates ).append(tranMessages).append( "</ROOT>" ); //$NON-NLS-1$
			//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - end
		}
		catch ( ITMException itme)
		{
			BaseLogger.log("3", null, null, "ITMException : DBAccessEJB : getObjDetails() :==>" ); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			BaseLogger.log("3", null, null, "Exception : DBAccessEJB : getObjDetails() :==>" ); //$NON-NLS-1$
			throw new ITMException(e);
		}

		return objDetail.toString();

	}

	/**
	 * It collects the transaction information specific to the objName & returns the same.
	 *
	 * @param objName
	 * @param pageContext
	 * @param metaDataFileName
	 * @param userInfo
	 * @return transInfoXMLBuffer
	 * @throws ITMException
	 */
	//New parameter objFormsDetailList added by Gulzar on 24/01/17
	//private String getTransactionInfo( String objName, String pageContext, String metaDataFileName, UserInfoBean userInfo ) throws ITMException
	//Changes made by Pratheek on 23/08/18[to prevent reading 21 and 22 metadata in process screen]-Start
//	private String getTransactionInfo( String objName, String pageContext, String metaDataFileName, UserInfoBean userInfo, ArrayList objFormsDetailList ) throws ITMException
	private String getTransactionInfo( String objName, String pageContext, String metaDataFileName, UserInfoBean userInfo, ArrayList objFormsDetailList,String objType ) throws ITMException
	//Changes made by Pratheek on 23/08/18[to prevent reading 21 and 22 metadata in process screen]-End
	{
		StringBuffer transInfoXMLBuffer = null;
		try
		{
			BaseLogger.log("3", null, null,"DBAccessEJB >> getTransactionInfo >> metaDataFileName =["+metaDataFileName+"] objType ["+objType+"]");
			transInfoXMLBuffer = new StringBuffer();
			if( userInfo != null )
			{
				String transDB = userInfo.getTransDB();
				//Commented and moved to calling method getObjDetail() on 24/01/17 : START
				//Changes by Gulzar on 23/10/13 to pass the userInfo string to overloaded getObjFormsDetailList() method : START
				/*
				ArrayList objFormsDetailList = null;
				if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
				{
					objFormsDetailList = this.getObjFormsDetailList( objName, userInfo );
				}
				else
				{
					objFormsDetailList = this.getObjFormsDetailList( objName );
				}
				 */
				//Changes by Gulzar on 23/10/13 to pass the userInfo string to overloaded getObjFormsDetailList() method : END
				//Commented and moved to calling method getObjDetail() on 24/01/17 : END

				BaseLogger.log("3", null, null,"objFormsDetailList : " + objFormsDetailList ); //$NON-NLS-1$

				if ( objFormsDetailList.size() > 0 )
				{
					int noOfForms = objFormsDetailList.size();
					transInfoXMLBuffer.append( "<Transaction id=\""+objName+"\">\n" ); //$NON-NLS-1$ //$NON-NLS-2$

					if( metaDataFileName == null ||  "null".equalsIgnoreCase(metaDataFileName) || ( metaDataFileName != null && metaDataFileName.length() == 0 ) ) //$NON-NLS-1$
					{
						//Changes made by Pratheek on 25-01-19[to get the obj_detals value in reports]-Start
						if( pageContext != null && pageContext.length() > 0 &&  !"R".equalsIgnoreCase(objType))
						{
							transInfoXMLBuffer.append( this.getArgumentString( objName, userInfo ) +"\n"); //$NON-NLS-1$
						}
						//Changes by Gulzar on 23/10/13 to pass the userInfo string to overloaded getObjDetailMap() method : START
						HashMap objDetailMap = null;
						if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
						{
							objDetailMap = this.getObjDetailMap( objName, userInfo );
						}
						/*else
						{
							objDetailMap = this.getObjDetailMap( objName );
						}*/
						//Changes by Gulzar on 23/10/13 to pass the userInfo string to overloaded getObjDetailMap() method : END
						if( objDetailMap != null && objDetailMap.size() > 0 )
						{
							transInfoXMLBuffer.append( this.getObjDetailString( objDetailMap ) + "\n" ); //$NON-NLS-1$
						}
						//Changes by Gulzar on 23/10/13 to pass the userInfo string to overloaded getObjDetailMap() method : START

						if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
						{
							transInfoXMLBuffer.append( this.getActionsString( objName, "editFlag", "1", userInfo.getProfileId(), userInfo.getUserLevel(), userInfo  ) + "\n" ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						}
						else
						{
							transInfoXMLBuffer.append( this.getActionsString( objName, "editFlag", "1", userInfo.getProfileId(), userInfo.getUserLevel(), userInfo.getTransDB() ) + "\n" ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						}
						transInfoXMLBuffer.append( this.getAllClientActionsString( objName, userInfo ) + "\n" ); //$NON-NLS-1$
						//Changes by Gulzar on 23/10/13 to pass the userInfo string to overloaded getObjDetailMap() method : START
					}
					BaseLogger.log("3", null, null, "noOfForms : " + noOfForms ); //$NON-NLS-1$
					for( int i = 0; i < noOfForms; i++ )
					{
						ArrayList currFormDetailList = (ArrayList)objFormsDetailList.get(i);
						transInfoXMLBuffer.append("<Form no=\""+ ( i + 1 ) +"\">\n"); //$NON-NLS-1$ //$NON-NLS-2$
						transInfoXMLBuffer.append("<Title><![CDATA["+currFormDetailList.get(0)+"]]></Title>\n"); //$NON-NLS-1$ //$NON-NLS-2$
						transInfoXMLBuffer.append("<CrossUpdateExpr><![CDATA["+currFormDetailList.get(1)+"]]></CrossUpdateExpr>\n"); //$NON-NLS-1$ //$NON-NLS-2$
						transInfoXMLBuffer.append("<ExprFldInfo><![CDATA["+currFormDetailList.get(2)+"]]></ExprFldInfo>\n"); //$NON-NLS-1$ //$NON-NLS-2$
						transInfoXMLBuffer.append("<TargetFldInfo><![CDATA["+currFormDetailList.get(3)+"]]></TargetFldInfo>\n"); //$NON-NLS-1$ //$NON-NLS-2$
						transInfoXMLBuffer.append("<ExprComment><![CDATA["+currFormDetailList.get(4)+"]]></ExprComment>\n"); //$NON-NLS-1$ //$NON-NLS-2$
						transInfoXMLBuffer.append("<ScanFlag><![CDATA["+currFormDetailList.get(5)+"]]></ScanFlag>\n"); //$NON-NLS-1$ //$NON-NLS-2$
						transInfoXMLBuffer.append("<ScanMetadata><![CDATA["+currFormDetailList.get(6)+"]]></ScanMetadata>\n"); //$NON-NLS-1$ //$NON-NLS-2$
						transInfoXMLBuffer.append("<AutoAcceptScan><![CDATA["+currFormDetailList.get(7)+"]]></AutoAcceptScan>\n"); //$NON-NLS-1$ //$NON-NLS-2$
						transInfoXMLBuffer.append("<PropertyInfo><![CDATA["+currFormDetailList.get(8)+"]]></PropertyInfo>\n"); //$NON-NLS-1$ //$NON-NLS-2$
						transInfoXMLBuffer.append("<AfterSave><![CDATA["+currFormDetailList.get(9)+"]]></AfterSave>\n"); //$NON-NLS-1$ //$NON-NLS-2$
						transInfoXMLBuffer.append("<ColumnOnSave><![CDATA["+currFormDetailList.get( 10 )+"]]></ColumnOnSave>\n"); //$NON-NLS-1$ //$NON-NLS-2$
						transInfoXMLBuffer.append("<ScanDelimiter><![CDATA["+currFormDetailList.get( 11 )+"]]></ScanDelimiter>\n"); //$NON-NLS-1$ //$NON-NLS-2$
						transInfoXMLBuffer.append("<ExtMetadata><![CDATA["+currFormDetailList.get( 12 )+"]]></ExtMetadata>\n"); //$NON-NLS-1$ //$NON-NLS-2$
						transInfoXMLBuffer.append("<AutoAcceptWeighdata><![CDATA[" + currFormDetailList.get( 13 ) + "]]></AutoAcceptWeighdata>\n"); //$NON-NLS-1$ //$NON-NLS-2$
						//Added by Reema on 18/08/14 [to add disp_metadata]
						transInfoXMLBuffer.append("<DispMetadata><![CDATA["+currFormDetailList.get(17)+"]]></DispMetadata>\n"); //$NON-NLS-1$ //$NON-NLS-2$
						transInfoXMLBuffer.append("<AssistedMode><![CDATA[" + currFormDetailList.get( 19 ) + "]]></AssistedMode>\n");	 //$NON-NLS-1$ //$NON-NLS-2$
						transInfoXMLBuffer.append("<AutoAddOnEntry><![CDATA[" + currFormDetailList.get( 23 ) + "]]></AutoAddOnEntry>\n");
						//Added by Prasad on 02/06/16 [get tran_id_col for all forms]
						/*transInfoXMLBuffer.append("<TranIdCols><![CDATA[" + currFormDetailList.get( 27 ) + "]]></TranIdCols>\n");*/
						String formNo = "" + ( i + 1 ); //$NON-NLS-1$

						String formName = "";
						if( currFormDetailList != null && currFormDetailList.size() > 32 )
						{
							formName = (String)currFormDetailList.get(32);
						}
						transInfoXMLBuffer.append("<FormName><![CDATA[" + formName + "]]></FormName>\n");
						//Added by Bhupendra on 31-05-17 for Summary Page Issue during adding transaction Start
						String tranIdCols = checkNull( ""+ currFormDetailList.get( 27 ) );
						if ( tranIdCols.length() == 0 )
						{
							//Changes made by Pratheek on 23/08/18[to prevent reading 21 and 22 metadata in process screen]-Start
//							tranIdCols = getMetadataPkFldName( objName, formNo, formName );
							//Changes made by Pratheek on 25-01-19[to get the obj_detals value in reports]-Start
							if( !"R".equalsIgnoreCase(objType))
							{
								tranIdCols = getMetadataPkFldName( objName, formNo, formName,objType, userInfo );
							}
							//Changes made by Pratheek on 25-01-19[to get the obj_detals value in reports]-End
							//Changes made by Pratheek on 23/08/18[to prevent reading 21 and 22 metadata in process screen]-End
						}
						BaseLogger.log("3", null, null,"tranIdCols ["+ tranIdCols +"]");
						transInfoXMLBuffer.append("<TranIdCols><![CDATA[" + tranIdCols + "]]></TranIdCols>\n");
						//Added by Bhupendra on 31-05-17 for Summary Page Issue during adding transaction End
						//Changed by Sandeep S. on 07-OCT-16 [To set key_info values in the header field of wizard and editor]Start
						BaseLogger.log("3", null, null,"inside dbaccess for key_info ["+currFormDetailList.get( 28 )+"]");
						transInfoXMLBuffer.append("<KEY_INFO><![CDATA[" + currFormDetailList.get( 28 ) + "]]></KEY_INFO>\n");
						//Added by sanket on 10/10/16 [get image on all form feeds ]-start
						transInfoXMLBuffer.append("<ThumbObj><![CDATA[" + currFormDetailList.get( 29 ) + "]]></ThumbObj>\n");
						transInfoXMLBuffer.append("<ThumbImageCol><![CDATA[" + currFormDetailList.get( 30 ) + "]]></ThumbImageCol>\n");
						transInfoXMLBuffer.append("<ThumbAltCol><![CDATA[" + currFormDetailList.get( 31 ) + "]]></ThumbAltCol>\n");
						//Added by sanket on 10/10/16 [get image on all form feeds ]-End
						//Changes by Gulzar on 23/10/13 to pass the userInfo string to overloaded getObjFormsDetailList() method : START


						if(formName != null && formName.trim().length() > 0 && !"null".equalsIgnoreCase(formName))
						{
							metaDataFileName = objName +""+ pageContext +""+ formName;
						}
						BaseLogger.log("3", null, null,"metaDataFileName =["+metaDataFileName+"], formName =["+formName+"]");
						if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
						{
							transInfoXMLBuffer.append( this.getLinkInfo( objName,formNo, userInfo ) );
							//Implement link action for summery page
							if(( i + 1 ) == noOfForms)
							{
								transInfoXMLBuffer.append( this.getLinkInfo( objName, Integer.toString(i+2) , userInfo ) );
							}
//							transInfoXMLBuffer.append( this.getColumnInfo( objName, Integer.toString(i+1), pageContext, metaDataFileName, userInfo ) );
						}
						else
						{
							//Changed by Reema on 11-Dec-2015 [For obj_links on basis of right_char]
							//								transInfoXMLBuffer.append( this.getLinkInfo( objName,formNo ) );
							//Changed by Pankaj T on 04-01-18 [changes for multitenancy]
							transInfoXMLBuffer.append( this.getLinkInfo( objName,formNo, userInfo.getLoginCode(), userInfo ) );
							//Changed by Reema on 11-Dec-2015 [For obj_links on basis of right_char]-End
//							transInfoXMLBuffer.append( this.getColumnInfo( objName, Integer.toString(i+1), pageContext, metaDataFileName ) );
						}

						transInfoXMLBuffer.append("</Form>\n"); //$NON-NLS-1$
					}
					transInfoXMLBuffer.append("</Transaction>"); //$NON-NLS-1$
				}
			}
			else
			{
				transInfoXMLBuffer.append(Messages.getString("DBAccessEJB_notLogged")+"\n"+Messages.getString("DBAccessEJB_pleaseReconnect")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}
		}
		catch (ITMException itme)
		{
			BaseLogger.log("3", null, null,"ITMException : DBAccessEJB :getTransactionInfo :==>"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			BaseLogger.log("3", null, null,"Exception : DBAccessEJB :getTransactionInfo :==>"); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return transInfoXMLBuffer.toString();
	}

	/**
	 * It collects the object specific arguments & returns the same.
	 *
	 * @param objName
	 * @return
	 * @throws ITMException
	 */
	private String getArgumentString( String objName, UserInfoBean userInfo ) throws ITMException
	{
		String retArgString = ""; //$NON-NLS-1$
		try
		{
			//ArgumentLocal argument = ( ArgumentLocal )this.getInitialContext().lookup( "ibase/ArgumentEJB/local" ); //$NON-NLS-1$
			ArgumentEJB argument = new ArgumentEJB();

			// Changed  By Swapnil Ph. on 13-feb-2012 [ passed the UserInfoBean object to provide the user info on client side ]start
			//retArgString = argument.getArguments( objName );
			//Changes made by Gulzar on 24/01/17 : START
			//retArgString = argument.getArguments( objName, userInfo  );
			retArgString = argument.getArguments( objName, userInfo, this.objFormInfoMap );
			//Changes made by Gulzar on 24/01/17 : END
			// Changed By Swapnil Ph. on 13-feb-2012 [ passed the UserInfoBean object to provide the user info on client side ]end

		}
		catch ( ITMException itme )
		{
			BaseLogger.log("3", null, null, "ITMException : DBAccessEJB : getArgumentString :==>" ); //$NON-NLS-1$
			throw itme;
		}
		catch ( Exception e )
		{
			BaseLogger.log("3", null, null, "Exception : DBAccessEJB : getArgumentString :==>" ); //$NON-NLS-1$
			throw new ITMException( e );
		}
		return retArgString;
	}

	/**
	 * It collects the transetup information & returns the same.
	 *
	 * @param objDetailMap
	 * @return
	 * @throws ITMException
	 */
	private String getObjDetailString( HashMap objDetailMap ) throws ITMException
	{
		String retXML = null;
		try
		{
			retXML  = "<TRANSETUP>"; //$NON-NLS-1$
			Iterator iter = objDetailMap.keySet().iterator();
			while(iter.hasNext())
			{
				String key = ((String)iter.next());
				//retXML += "\n<" + key + ">" + objDetailMap.get(key) + "</" + key + ">"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				//Changes by Dnyaneshwar on 19-11-2012 [ add 'CDATA' tag bcz MSG_ONSAVE column value is a '<Tran_ID>'. This value can not parse xml  ] Start
				retXML += "\n<" + key + "><![CDATA[" + objDetailMap.get(key) + "]]></" + key + ">"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			}
			retXML += "\n</TRANSETUP>"; //$NON-NLS-1$
		}
		catch ( Exception e )
		{
			BaseLogger.log("3", null, null, "Exception : DBAccessEJB : getObjDetailString :==>" ); //$NON-NLS-1$
			throw new ITMException( e );
		}
		return retXML;
	}

	/**
	 * It collects the link related information for the form associated with the object that is being passed to it
	 * & returns the same.
	 *
	 * @param objName
	 * @param formNo
	 * @return
	 * @throws ITMException
	 */
	//Changed by Reema on 11-Dec-2015 [For obj_links on basis of right_char]
	//		private String getLinkInfo( String objName, String formNo ) throws ITMException
	//Changed by Pankaj T on 04-01-18 [changes for multitenancy]
	private String getLinkInfo( String objName, String formNo, String loginCode, UserInfoBean userInfo ) throws ITMException
	{
		String linkInfoStr = null;
		try
		{
			//LinkControllerLocal linkControllerRemote = ( LinkControllerLocal ) this.getInitialContext().lookup( "ibase/LinkControllerEJB/local" ); //$NON-NLS-1$
			LinkControllerEJB linkControllerEJB = new LinkControllerEJB();
			//				linkInfoStr = linkControllerRemote.getLinkInfo(objName,formNo)
			//Changed by Pankaj T on 04-01-18 [changes for multitenancy]
			linkInfoStr = linkControllerEJB.getLinkInfo(objName,formNo, loginCode, userInfo);
			//Changed by Reema on 11-Dec-2015 [For obj_links on basis of right_char]-End
			linkControllerEJB = null;
		}
		catch ( ITMException itme )
		{
			BaseLogger.log("3", null, null, "ITMException : DBAccessEJB : getLinkInfo : ==>" ); //$NON-NLS-1$
			throw itme;
		}
		catch ( Exception e )
		{
			BaseLogger.log("3", null, null, "Exception : DBAccessEJB :getLinkInfo : ==>" ); //$NON-NLS-1$
			throw new ITMException( e );
		}
		return linkInfoStr;
	}

	/**
	 * It collects the information regarding physical name of columns, display name of columns, name of primary
	 * key column & returns the same.
	 *
	 *
	 * @param objName
	 * @param formNo
	 * @param pageContext
	 * @param metaDataFileName
	 * @return
	 * @throws ITMException
	 *//*
	private String getColumnInfo( String objName, String formNo, String pageContext, String metaDataFileName ) throws ITMException
	{
		StringBuffer columnInfoXMLBuff = null;
		try
		{
			columnInfoXMLBuff = new StringBuffer();
			BaseLogger.log("3", null, null, "getColumnInfo : " + pageContext ); //$NON-NLS-1$

			ArrayList itemChangeFieldList = this.getItemChangeElementList( objName, formNo );
			BaseLogger.log("3", null, null, "itemChangeFieldList : " + itemChangeFieldList ); //$NON-NLS-1$

			HashMap validateElementMap = this.getValidateElementMap( objName );
			ArrayList clientValidateFieldList =null;
			if(validateElementMap != null)
			{
				clientValidateFieldList = (ArrayList) validateElementMap.get("C"); //$NON-NLS-1$
			}

			if(itemChangeFieldList.contains("itm_default")) //$NON-NLS-1$
			{
				columnInfoXMLBuff.append("<Column id=\"itm_default\" srvCallOnChange=\"true\" />\n"); //$NON-NLS-1$
			}
			if(itemChangeFieldList.contains("itm_defaultedit")) //$NON-NLS-1$
			{
				columnInfoXMLBuff.append("<Column id=\"itm_defaultedit\" srvCallOnChange=\"true\" />\n"); //$NON-NLS-1$
			}

			//Changes done by Gaurav Singh on 13-JUL-2016 [ setIBASEHOME only when TOMCAT_HOME is null | Start ]
			//CommonConstants.setIBASEHOME();
			if(CommonConstants.TOMCAT_HOME == null || CommonConstants.TOMCAT_HOME.trim().length() == 0)
			{
				CommonConstants.setIBASEHOME();
			}
			//Changes done by Gaurav Singh on 13-JUL-2016 [ setIBASEHOME only when TOMCAT_HOME is null | End ]

			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			DocumentBuilder db = dbf.newDocumentBuilder();
			Document doc = null;
			if(metaDataFileName != null && metaDataFileName.length() > 0 && ( ! "null".equalsIgnoreCase(metaDataFileName))) //$NON-NLS-1$
			{
				doc = db.parse(new File(CommonConstants.JBOSSHOME + File.separator + "bin" + File.separator + "metadata" + File.separator + metaDataFileName + ".xml")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}
			else
			{
				doc = db.parse(new File(CommonConstants.JBOSSHOME + File.separator + "bin" + File.separator + "metadata" + File.separator + objName + pageContext + formNo + ".xml")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}
			String fieldName = ""; //$NON-NLS-1$
			NodeList columnObjectList = doc.getElementsByTagName("ColumnObject"); //$NON-NLS-1$
			for(int i=0;i<columnObjectList.getLength();i++)
			{
				Node currColumnObject =(Node)columnObjectList.item(i);
				NodeList columnObjectDetail = currColumnObject.getChildNodes();
				for(int j=0;j<columnObjectDetail.getLength();j++)
				{
					if(!(columnObjectDetail.item(j).getNodeName().equalsIgnoreCase("#text"))) //$NON-NLS-1$
					{
						if(columnObjectDetail.item(j).getFirstChild() != null)
						{
							fieldName = columnObjectDetail.item(j).getFirstChild().getNodeValue();
							if(columnObjectDetail.item(j).getNodeName().equalsIgnoreCase("NAME")) //$NON-NLS-1$
							{
								boolean columnFlag = false;
								String popUpInfoStr = null;
								StringBuffer valInfoBuff = new StringBuffer();
								String srvColStr = null;

								PopUpHandler popUpHandler = new PopUpHandler();
								String popUpString = popUpHandler.getFieldPopUpXML(fieldName, objName, "1"); //$NON-NLS-1$
								if(popUpString != null)
								{
									columnFlag = true;
									if(popUpString.equalsIgnoreCase("NOPARAM")) //$NON-NLS-1$
									{
										popUpInfoStr = "popUpExists=\"true\" popUpParam=\"NULL\" "; //$NON-NLS-1$
									}
									else
									{
										popUpInfoStr = "popUpExists=\"true\" popUpParam=\""+popUpString+"\" "; //$NON-NLS-1$ //$NON-NLS-2$
									}
								}

								if(itemChangeFieldList != null && itemChangeFieldList.contains(fieldName))
								{
									columnFlag = true;
									srvColStr = "srvCallOnChange=\"true\" "; //$NON-NLS-1$
								}
								if(clientValidateFieldList != null )
								{
									for(int k=0;k < clientValidateFieldList.size();k++)
									{
										columnFlag = true;
										HashMap fieldMap=(HashMap)clientValidateFieldList.get(k);
										String mapFieldName=((String)fieldMap.get("FIELD_NAME")).trim(); //$NON-NLS-1$
										if( mapFieldName.equalsIgnoreCase( fieldName ) )
										{
											String blankOpt=((String)fieldMap.get("BLANK_OPT")); //$NON-NLS-1$
											String valType =((String)fieldMap.get("VAL_TYPE")); //$NON-NLS-1$
											String validateFromObjectName =((String)fieldMap.get("OBJ_NAME")); //$NON-NLS-1$
											String description = ((String)fieldMap.get("DESCR")); //$NON-NLS-1$
											String errorCode = ((String)fieldMap.get("ERROR_CD")); //$NON-NLS-1$
											valInfoBuff.append("<ValInfo "); //$NON-NLS-1$
											if(blankOpt != null)
											{
												valInfoBuff.append("BlankOpt =\""+blankOpt+"\" "); //$NON-NLS-1$ //$NON-NLS-2$
											}
											if(valType != null)
											{
												valInfoBuff.append("ValType =\""+valType+"\" "); //$NON-NLS-1$ //$NON-NLS-2$
											}
											if(validateFromObjectName != null)
											{
												valInfoBuff.append("ValidateFromObjName =\""+validateFromObjectName+"\" "); //$NON-NLS-1$ //$NON-NLS-2$
											}
											if(errorCode != null)
											{
												valInfoBuff.append("ErrorCode =\""+errorCode+"\" >\n"); //$NON-NLS-1$ //$NON-NLS-2$
												valInfoBuff.append("<Message><![CDATA["+description +"]]></Message>\n"); //$NON-NLS-1$ //$NON-NLS-2$
												valInfoBuff.append("</ValInfo >\n"); //$NON-NLS-1$
											}
											else
											{
												valInfoBuff.append("/>\n"); //$NON-NLS-1$
											}
										}
									}
								}
								if ( columnFlag )
								{
									columnFlag = false;
									columnInfoXMLBuff.append("<Column id=\""+fieldName+"\" "); //$NON-NLS-1$ //$NON-NLS-2$
									if (popUpInfoStr != null)
									{
										columnInfoXMLBuff.append(popUpInfoStr);
									}
									if (srvColStr!= null)
									{
										columnInfoXMLBuff.append(srvColStr);
									}

									String popHelpCols = ""; //$NON-NLS-1$
									String popHelpSrc = ""; //$NON-NLS-1$
									String multiOptPopUp = ""; //$NON-NLS-1$
									String helpOption = ""; //$NON-NLS-1$
									String popHelpColsNSrcXML = popUpHandler.getPopHelpColsNSrc(fieldName, objName, "1"); //$NON-NLS-1$
									Document popHelpColsNSrcDoc = new E12GenericUtility().parseString( popHelpColsNSrcXML );
									if( popHelpColsNSrcDoc != null )
									{
										Node popHelpColsNSrcDocFirstChild = popHelpColsNSrcDoc.getFirstChild();
										if( popHelpColsNSrcDocFirstChild != null )
										{
											NodeList popHelpColsNSrcList = popHelpColsNSrcDocFirstChild.getChildNodes();
											int nodeListLen = popHelpColsNSrcList.getLength();
											for (int k=0; k < nodeListLen; k++)
											{
												Node currNode = popHelpColsNSrcList.item(k);
												String nodeName = currNode.getNodeName();
												if ( "POPHELP_COLS".equalsIgnoreCase(nodeName) ) //$NON-NLS-1$
												{
													if (currNode.getFirstChild() != null )
													{
														popHelpCols = currNode.getFirstChild().getNodeValue();
													}
												}
												else if ( "POPHELP_SOURCE".equalsIgnoreCase(nodeName) ) //$NON-NLS-1$
												{
													if (currNode.getFirstChild() != null )
													{
														popHelpSrc = currNode.getFirstChild().getNodeValue();
													}
												}
												else if ( "MULTI_OPT_POPUP".equalsIgnoreCase(nodeName) ) //$NON-NLS-1$
												{
													if (currNode.getFirstChild() != null )
													{
														multiOptPopUp = currNode.getFirstChild().getNodeValue();
													}
												}
												else if ( "HELP_OPTION".equalsIgnoreCase(nodeName) ) //$NON-NLS-1$
												{
													if (currNode.getFirstChild() != null )
													{
														helpOption = currNode.getFirstChild().getNodeValue();
													}
												}
											}
											columnInfoXMLBuff.append("popUpSource =\"").append(popHelpSrc).append("\"");//Manish //$NON-NLS-1$ //$NON-NLS-2$

											columnInfoXMLBuff.append(" multiOptPopUp =\"").append(multiOptPopUp).append("\""); //$NON-NLS-1$ //$NON-NLS-2$
											columnInfoXMLBuff.append(" helpOption =\"").append(helpOption).append("\">"); //$NON-NLS-1$ //$NON-NLS-2$
										}
									}
									if(valInfoBuff.length()  > 0)
									{
										columnInfoXMLBuff.append( valInfoBuff.toString() );
									}
									if( popHelpCols.length() > 0 )
									{
										columnInfoXMLBuff.append("<POPHELP_COLS>").append(popHelpCols).append("</POPHELP_COLS>"); //$NON-NLS-1$ //$NON-NLS-2$
									}
									columnInfoXMLBuff.append("</Column>"); //$NON-NLS-1$
								}
							}
						}
					}
				}
			}
		}
		catch (ITMException itme)
		{
			BaseLogger.log("3", null, null, "ITMException : DBAccessEJB : getColumnInfo : ==>" ); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			BaseLogger.log("3", null, null,"Exception : DBAccessEJB : getColumnInfo :==>"); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return columnInfoXMLBuff.toString();
	}*/

	/**
	 * It collects the information regarding the "actions" associated with the object i.e objName & returns the
	 * same.
	 *
	 * @param objName
	 * @param userCode
	 * @param userInfo
	 * @return
	 * @throws ITMException
	 */

	/*--Commented and changed by Gulzar as it is not required becoz this method is get called when userInfo != null
	private String getAllClientActionsString( String objName, UserInfoBean userInfo ) throws ITMException
	{
		BaseLogger.log("3", null, null," getAllClientActionsString  for objName [" + objName + "]"); //$NON-NLS-1$ //$NON-NLS-2$
		String retActionXML = null;
		try
		{
			if(userInfo != null)
			{
				retActionXML = this.getAllClientActionsString( objName );
			}
			else
			{
				retActionXML = Messages.getString("DBAccessEJB_notLoggedIn")+" \n "+Messages.getString("DBAccessEJB_pleaseReconnectToWork"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}
		}
		catch (ITMException itme)
		{
			BaseLogger.log("3", null, null,"ITMException : DBAccessEJB :getActionString :==>"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			BaseLogger.log("3", null, null,"Exception : DBAccessEJB :getActionString :==>"); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return retActionXML;
	}
	 */

	/**
	 * It creates a object of InitialContext & returns the same.
	 *
	 * @return
	 * @throws ITMException
	 */
	private InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext( appConnect.getProperty() );
		}
		catch( ITMException itme )
		{
			BaseLogger.log("3", null, null, "ITMException : DBAccessEJB :getInitialContext :==>" ); //$NON-NLS-1$
			throw itme;
		}
		catch(Exception e)
		{
			BaseLogger.log("3", null, null, "Exception : DBAccessEJB :getInitialContext :==>" ); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return ctx;
	}
	//Changed by HRUSIKESH BEHERA on 17/02/11, WS01SUN042 [Migrating Search Page into GWT],to make a single RPC call for collecting trans_ifno, col_info, formal arguments & action info Ends.

	public HashMap getObjDetailMap(String objName, String transDB) throws RemoteException, ITMException
	{
		HashMap objDetailMap = null;
		Connection mConnection = null;
		Statement mStmt = null;
		ResultSet mRs=null;
		int iResult=0;
		String objInfo = null;
		try
		{	BaseLogger.log("3", null, null,"In getObjDetailMap transDB:["+transDB+"]");
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB(transDB); //$NON-NLS-1$
			objName = (objName.startsWith("w_"))?objName : "w_" + objName; //$NON-NLS-1$ //$NON-NLS-2$
			//Changed by Danish on 13/07/2006 to collect edit opt and audit opt from Transetup
			//Changed by Danish on 09/10/2006 [to add cache_opt]
			//String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT FROM TRANSETUP WHERE TRAN_WINDOW='"+objName +"'";

			//Changed by Dhruv on 06/11/2007 to select REPEAT_ADD_DET for detail repeat flag.
			//String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL FROM TRANSETUP WHERE TRAN_WINDOW='"+objName +"'";
			//Changed by Danish on 07/11/2007 to select TRAN_ID_COL to include in Map
			//String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL FROM TRANSETUP WHERE TRAN_WINDOW='"+objName +"'";
			//Change by Nilesh on 29-JAN-11 [MK01SUN011] [To get period_option from transetup]
			//Change by Nilesh on 17-Feb-11 [DI01SUN004] [To get EXP_TYPE from transetup ]
			//String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL,TRAN_ID_COL, PERIOD_OPTION FROM TRANSETUP WHERE TRAN_WINDOW='"+objName +"'";

			//Added By Prajyot on 6-AUG-2012 [HEADER_FORM_NO : TranID generation started from this form number in wizard i.e. TranID generation entry form ]
			//String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL,TRAN_ID_COL, PERIOD_OPTION, EXEC_TYPE,ALLOW_ATTACH FROM TRANSETUP WHERE TRAN_WINDOW='"+objName +"'";			 //$NON-NLS-1$ //$NON-NLS-2$
			//String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL,TRAN_ID_COL, PERIOD_OPTION, EXEC_TYPE,ALLOW_ATTACH, HEADER_FORM_NO FROM TRANSETUP WHERE TRAN_WINDOW='"+objName +"'";			 //$NON-NLS-1$ //$NON-NLS-2$
			//Changed by Dnyaneshwar on 19/11/12 [ WS2GSUN002 || Add new column 'MSG_ONSAVE' in the sqlquery ] Start

			//Changed by Reema on 01/Nov/14 [S14CSUN002 || Add new column 'CONFIRM_DATE_COL' in sqlquery] start
			//String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL,TRAN_ID_COL, PERIOD_OPTION, EXEC_TYPE,ALLOW_ATTACH, HEADER_FORM_NO, MSG_ONSAVE FROM TRANSETUP WHERE TRAN_WINDOW='"+objName +"'";			 //$NON-NLS-1$ //$NON-NLS-2$
			//String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL,TRAN_ID_COL, PERIOD_OPTION, EXEC_TYPE,ALLOW_ATTACH, HEADER_FORM_NO, MSG_ONSAVE, CONFIRM_DATE_COL FROM TRANSETUP WHERE TRAN_WINDOW='"+objName +"'";			 //$NON-NLS-1$ //$NON-NLS-2$
			//Changed by Prajyot on 11/DEC/14 [HR Portal || Add new column 'BROW_DATA_DEF' in sqlquery] start
			//String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL,TRAN_ID_COL, PERIOD_OPTION, EXEC_TYPE,ALLOW_ATTACH, HEADER_FORM_NO, MSG_ONSAVE, CONFIRM_DATE_COL, BROW_DATA_DEF FROM TRANSETUP WHERE TRAN_WINDOW='"+objName +"'";			 //$NON-NLS-1$ //$NON-NLS-2$
			//Changed by Reema on 20/Jan/15 [S14GSUN005 || Add new columns 'DEF_VIEW', 'VIEW_OPTS' in sqlquery ]
			//Changed by Savita Yadav on 10-08-2015 [Added columns THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL to get dynamic images]
			//			String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL,TRAN_ID_COL, PERIOD_OPTION, EXEC_TYPE,ALLOW_ATTACH, HEADER_FORM_NO, MSG_ONSAVE, CONFIRM_DATE_COL, BROW_DATA_DEF, DEF_VIEW, VIEW_OPTS FROM TRANSETUP WHERE TRAN_WINDOW='"+objName +"'";			 //$NON-NLS-1$ //$NON-NLS-2$
			//Changed by Reema on 4-sep-15 [to show different flag for cofirm_col,cancel_col, in_wf_col, unconfirm_col ]
			//			String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL,TRAN_ID_COL, PERIOD_OPTION, EXEC_TYPE,ALLOW_ATTACH, HEADER_FORM_NO, MSG_ONSAVE, CONFIRM_DATE_COL, BROW_DATA_DEF, DEF_VIEW, VIEW_OPTS, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL FROM TRANSETUP WHERE TRAN_WINDOW='"+objName +"'";			 //$NON-NLS-1$ //$NON-NLS-2$
			//			Changed by Savita Yadav on 17/12/15 [To show DEFAULT_DATA_ROW]
			//			String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL,TRAN_ID_COL, PERIOD_OPTION, EXEC_TYPE,ALLOW_ATTACH, HEADER_FORM_NO, MSG_ONSAVE, CONFIRM_DATE_COL, BROW_DATA_DEF, DEF_VIEW, VIEW_OPTS, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL, CANCEL_COL, CANCEL_VAL, IN_WF_COL, IN_WF_VAL FROM TRANSETUP WHERE TRAN_WINDOW='"+objName +"'";			 //$NON-NLS-1$ //$NON-NLS-2$
			//String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL,TRAN_ID_COL, PERIOD_OPTION, EXEC_TYPE,ALLOW_ATTACH, HEADER_FORM_NO, MSG_ONSAVE, CONFIRM_DATE_COL, BROW_DATA_DEF, DEF_VIEW, VIEW_OPTS, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL, CANCEL_COL, CANCEL_VAL, IN_WF_COL, IN_WF_VAL, DEFAULT_DATA_ROW FROM TRANSETUP WHERE TRAN_WINDOW='"+objName +"'";			 //$NON-NLS-1$ //$NON-NLS-2$
			//Change by Sandeep S. on 2/12/16 [To open transaction in default editor layout]
			//String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL,TRAN_ID_COL, PERIOD_OPTION, EXEC_TYPE,ALLOW_ATTACH, HEADER_FORM_NO, MSG_ONSAVE, CONFIRM_DATE_COL, BROW_DATA_DEF, DEF_VIEW, VIEW_OPTS, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL, CANCEL_COL, CANCEL_VAL, IN_WF_COL, IN_WF_VAL, DEFAULT_DATA_ROW, DEFAULT_EDITOR, MSG_NO FROM TRANSETUP WHERE TRAN_WINDOW='"+objName +"'";			 //$NON-NLS-1$ //$NON-NLS-2$
			//Changed by shrutika on 23-02-17 [To get msg_str against msg_no]
//			String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL,TRAN_ID_COL, PERIOD_OPTION, EXEC_TYPE,ALLOW_ATTACH, HEADER_FORM_NO, MSG_ONSAVE, CONFIRM_DATE_COL, BROW_DATA_DEF, DEF_VIEW, VIEW_OPTS, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL, CANCEL_COL, CANCEL_VAL, IN_WF_COL, IN_WF_VAL, DEFAULT_DATA_ROW, DEFAULT_EDITOR, TR.MSG_NO, MSG.MSG_STR, ISATTACHMENT, START_FORM, RESTART_FORM FROM TRANSETUP TR LEFT OUTER JOIN MESSAGES MSG ON TR.MSG_NO=MSG.MSG_NO WHERE TRAN_WINDOW='"+objName +"'";
			//String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL,TRAN_ID_COL, PERIOD_OPTION, EXEC_TYPE,ALLOW_ATTACH, HEADER_FORM_NO, MSG_ONSAVE, CONFIRM_DATE_COL, BROW_DATA_DEF, DEF_VIEW, VIEW_OPTS, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL, CANCEL_COL, CANCEL_VAL, IN_WF_COL, IN_WF_VAL, DEFAULT_DATA_ROW, DEFAULT_EDITOR, ENABLE_EDITOR, ISATTACHMENT, START_FORM, RESTART_FORM, TR.MSG_NO, MSG.MSG_STR FROM TRANSETUP TR LEFT OUTER JOIN MESSAGES MSG ON TR.MSG_NO=MSG.MSG_NO WHERE TRAN_WINDOW='"+objName +"'";    //Added ENABLE_EDITOR column by Sagar B.22/8/17
			//Changed By Pankaj T. on 26-09-18 to add new column CLOSE_COL & CLOSE_VAL
			//String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL,TRAN_ID_COL, PERIOD_OPTION, EXEC_TYPE,ALLOW_ATTACH, HEADER_FORM_NO, MSG_ONSAVE, CONFIRM_DATE_COL, BROW_DATA_DEF, DEF_VIEW, VIEW_OPTS, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL, CANCEL_COL, CANCEL_VAL, IN_WF_COL, IN_WF_VAL, DEFAULT_DATA_ROW, DEFAULT_EDITOR, ENABLE_EDITOR, ISATTACHMENT, START_FORM, RESTART_FORM, TR.MSG_NO, MSG.MSG_STR, CLOSE_COL, CLOSE_VAL FROM TRANSETUP TR LEFT OUTER JOIN MESSAGES MSG ON TR.MSG_NO=MSG.MSG_NO WHERE TRAN_WINDOW='"+objName +"'";    //Added ENABLE_EDITOR column by Sagar B.22/8/17
			String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL,TRAN_ID_COL, PERIOD_OPTION, EXEC_TYPE,ALLOW_ATTACH, HEADER_FORM_NO, MSG_ONSAVE, CONFIRM_DATE_COL, BROW_DATA_DEF, DEF_VIEW, VIEW_OPTS, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL, CANCEL_COL, CANCEL_VAL, IN_WF_COL, IN_WF_VAL, DEFAULT_DATA_ROW, DEFAULT_EDITOR, ENABLE_EDITOR, ISATTACHMENT, START_FORM, RESTART_FORM, TR.MSG_NO, MSG.MSG_STR, CLOSE_COL, CLOSE_VAL, ATTACH_COUNT_MIN FROM TRANSETUP TR LEFT OUTER JOIN MESSAGES MSG ON TR.MSG_NO=MSG.MSG_NO WHERE TRAN_WINDOW='"+objName +"'";    //Added ATTACH_COUNT_MIN column by Prasad on 03/11/19
			//String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, TRAN_DATE_COL, WORKFLOW_OPT FROM TRANSETUP WHERE TRAN_WINDOW='"+objName +"'";
			mStmt = mConnection.createStatement();
			mRs = mStmt.executeQuery(sqlQuery);
			ResultSetMetaData rsmd = mRs.getMetaData();
			objDetailMap = new HashMap();
			while(mRs.next())
			{
				int noOfColumns = rsmd.getColumnCount();
				for(int ctr = 1; ctr <= noOfColumns; ctr++)
				{
					// Changed by gayatri on 28-12-2011 [WI1HBAS001] [Migration of BaseE12 on Mysql] start
					//objDetailMap.put(rsmd.getColumnName(ctr), mRs.getString(ctr));
					if("mysql".equalsIgnoreCase(CommonConstants.DB_NAME))
					{
						objDetailMap.put(rsmd.getColumnName(ctr).toUpperCase(), mRs.getString(ctr));
					}
					else
					{
						objDetailMap.put(rsmd.getColumnName(ctr), mRs.getString(ctr));
					}
					// Changed by gayatri on 28-12-2011 [WI1HBAS001] [Migration of BaseE12 on Mysql] end
				}
			}
			//Added by Prasad on 03/11/19 [to add min and max attachment related details] START
			HashMap<String, String> attachMinMaxDetailMap = getObjAttachConfigMinMaxAttachDetails( objName, mConnection, transDB );
			if ( attachMinMaxDetailMap != null && attachMinMaxDetailMap.size() > 0 )
			{
				objDetailMap.putAll( attachMinMaxDetailMap );
			}
			//Added by Prasad on 03/11/19 [to add min and max attachment related details] END
			//Added By Nilesh Start ::01-06-2017
			if(mRs!=null)
			{
				mRs.close();
				mRs = null;
			}
			if(mStmt!=null)
			{
				mStmt.close();
				mStmt = null;
			}

			//Added By Nilesh End ::01-06-2017
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException :DBAccessEJB :getObjInfo :\n"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			//System.err.println("Exception :DBAccessEJB :getObjInfo :\n"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(mStmt != null)
					{
						mStmt.close();
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getObjInfo :==>F" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("3", null, null,"Returning objDetailMap :"+objDetailMap); //$NON-NLS-1$
		return objDetailMap;
	}

	public ArrayList getObjFormsDetailList(String objName)throws  RemoteException, ITMException
	{
		String winName = "w_" + objName; //$NON-NLS-1$
		String mQuery = null;
		Connection mConnection = null;
		Statement mStmt = null;
		ResultSet mRs = null;
		ArrayList<ArrayList<String>> objFormsDetailList = new ArrayList<ArrayList<String>>();
		try
		{
			//Changes By Prajyot On 23-Sep-2011 [To select ASSISTED_MODE from obj_forms] Starts
			//mQuery = "SELECT FORM_NO, TITLE, CROSS_UPDATE_EXPR, EXPR_FLD_INFO, TARGET_FLD_INFO, EXPR_COMMENT, SCAN_FLAG, SCAN_METADATA, AUTO_ACCEPT_SCAN, PROPERTY_INFO, AFTER_SAVE, COLUMN_ON_SAVE, SCAN_DELIMITER, EXT_METADATA, AUTO_ACCEPT_WEIGHDATA, SCR_FLAG, FORM_TYPE, DISP_METADATA, PARENT_KEY_COL FROM OBJ_FORMS WHERE WIN_NAME='" + winName + "'" + " AND FORM_NO NOT LIKE '%.%' ORDER BY FORM_NO ";
			//			mQuery = "SELECT FORM_NO, TITLE, CROSS_UPDATE_EXPR, EXPR_FLD_INFO, TARGET_FLD_INFO, EXPR_COMMENT, SCAN_FLAG, SCAN_METADATA, AUTO_ACCEPT_SCAN, PROPERTY_INFO, AFTER_SAVE, COLUMN_ON_SAVE, SCAN_DELIMITER, EXT_METADATA, AUTO_ACCEPT_WEIGHDATA, SCR_FLAG, FORM_TYPE, DISP_METADATA, PARENT_KEY_COL, ASSISTED_MODE FROM OBJ_FORMS WHERE WIN_NAME='" + winName + "'" + " AND FORM_NO NOT LIKE '%.%' ORDER BY FORM_NO "; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			//			mQuery = "SELECT FORM_NO, TITLE, CROSS_UPDATE_EXPR, EXPR_FLD_INFO, TARGET_FLD_INFO, EXPR_COMMENT, SCAN_FLAG, SCAN_METADATA, AUTO_ACCEPT_SCAN, PROPERTY_INFO, AFTER_SAVE, COLUMN_ON_SAVE, SCAN_DELIMITER, EXT_METADATA, AUTO_ACCEPT_WEIGHDATA, SCR_FLAG, FORM_TYPE, DISP_METADATA, PARENT_KEY_COL, ASSISTED_MODE, STORAGE_KEY_METADATA, SELECTION_MODE FROM OBJ_FORMS WHERE WIN_NAME='" + winName + "'" + " AND FORM_NO NOT LIKE '%.%' ORDER BY FORM_NO "; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			//Changed by gayatri on 22-07-2013 [to auto save feature on multiple field]

			//mQuery = "SELECT FORM_NO, TITLE, CROSS_UPDATE_EXPR, EXPR_FLD_INFO, TARGET_FLD_INFO, EXPR_COMMENT, SCAN_FLAG, SCAN_METADATA, AUTO_ACCEPT_SCAN, PROPERTY_INFO, AFTER_SAVE, COLUMN_ON_SAVE, SCAN_DELIMITER, EXT_METADATA, AUTO_ACCEPT_WEIGHDATA, SCR_FLAG, FORM_TYPE, DISP_METADATA, PARENT_KEY_COL, ASSISTED_MODE, STORAGE_KEY_METADATA, SELECTION_MODE, DEFAULT_VIEW FROM OBJ_FORMS WHERE WIN_NAME='" + winName + "'" + " AND FORM_NO NOT LIKE '%.%' ORDER BY FORM_NO "; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			//mQuery = "SELECT FORM_NO, TITLE, CROSS_UPDATE_EXPR, EXPR_FLD_INFO, TARGET_FLD_INFO, EXPR_COMMENT, SCAN_FLAG, SCAN_METADATA, AUTO_ACCEPT_SCAN, PROPERTY_INFO, AFTER_SAVE, COLUMN_ON_SAVE, SCAN_DELIMITER, EXT_METADATA, AUTO_ACCEPT_WEIGHDATA, SCR_FLAG, FORM_TYPE, DISP_METADATA, PARENT_KEY_COL, ASSISTED_MODE, STORAGE_KEY_METADATA, SELECTION_MODE, DEFAULT_VIEW, AUTO_ADDON_ENTRY FROM OBJ_FORMS WHERE WIN_NAME='" + winName + "'" + " AND FORM_NO NOT LIKE '%.%' ORDER BY FORM_NO "; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			// Above Line Commented by AMit D on 27 Dec 13 and order by form no is done by converting to Number.
			//Added by Ajinkya Gopalkar on 30-11-2015[Request ID :D15HSUN011 - for FREEZE_COL_POS column for freezing column]
			//Changed by Reema on 4-01-2016 [S15JSUN001 - Dynamic row number to be shown in GWT-Wizard screen]
			//mQuery = "SELECT FORM_NO, TITLE, CROSS_UPDATE_EXPR, EXPR_FLD_INFO, TARGET_FLD_INFO, EXPR_COMMENT, SCAN_FLAG, SCAN_METADATA, AUTO_ACCEPT_SCAN, PROPERTY_INFO, AFTER_SAVE, COLUMN_ON_SAVE, SCAN_DELIMITER, EXT_METADATA, AUTO_ACCEPT_WEIGHDATA, SCR_FLAG, FORM_TYPE, DISP_METADATA, PARENT_KEY_COL, ASSISTED_MODE, STORAGE_KEY_METADATA, SELECTION_MODE, DEFAULT_VIEW, AUTO_ADDON_ENTRY, FREEZE_COL_POS FROM OBJ_FORMS WHERE WIN_NAME='" + winName + "'" + " AND FORM_NO NOT LIKE '%.%' " ;
			//Added by Prasad on 02/06/16 [get tran_id_col for all forms]
			//mQuery = "SELECT FORM_NO, TITLE, CROSS_UPDATE_EXPR, EXPR_FLD_INFO, TARGET_FLD_INFO, EXPR_COMMENT, SCAN_FLAG, SCAN_METADATA, AUTO_ACCEPT_SCAN, PROPERTY_INFO, AFTER_SAVE, COLUMN_ON_SAVE, SCAN_DELIMITER, EXT_METADATA, AUTO_ACCEPT_WEIGHDATA, SCR_FLAG, FORM_TYPE, DISP_METADATA, PARENT_KEY_COL, ASSISTED_MODE, STORAGE_KEY_METADATA, SELECTION_MODE, DEFAULT_VIEW, AUTO_ADDON_ENTRY, FREEZE_COL_POS, DEFAULT_ROW_CNT, IS_MANDATORY FROM OBJ_FORMS WHERE WIN_NAME='" + winName + "'" + " AND FORM_NO NOT LIKE '%.%' " ;
			//Changed by sanket on 10/10/16 [get thumb-img for all form]
			//mQuery = "SELECT FORM_NO, TITLE, CROSS_UPDATE_EXPR, EXPR_FLD_INFO, TARGET_FLD_INFO, EXPR_COMMENT, SCAN_FLAG, SCAN_METADATA, AUTO_ACCEPT_SCAN, PROPERTY_INFO, AFTER_SAVE, COLUMN_ON_SAVE, SCAN_DELIMITER, EXT_METADATA, AUTO_ACCEPT_WEIGHDATA, SCR_FLAG, FORM_TYPE, DISP_METADATA, PARENT_KEY_COL, ASSISTED_MODE, STORAGE_KEY_METADATA, SELECTION_MODE, DEFAULT_VIEW, AUTO_ADDON_ENTRY, FREEZE_COL_POS, DEFAULT_ROW_CNT, IS_MANDATORY, TRAN_ID_COL, KEY_INFO FROM OBJ_FORMS WHERE WIN_NAME='" + winName + "'" + " AND FORM_NO NOT LIKE '%.%' " ;
			//Gulzar on 11/01/17 and FORM_ICON by Ajinkya
			//mQuery = "SELECT FORM_NO, TITLE, CROSS_UPDATE_EXPR, EXPR_FLD_INFO, TARGET_FLD_INFO, EXPR_COMMENT, SCAN_FLAG, SCAN_METADATA, AUTO_ACCEPT_SCAN, PROPERTY_INFO, AFTER_SAVE, COLUMN_ON_SAVE, SCAN_DELIMITER, EXT_METADATA, AUTO_ACCEPT_WEIGHDATA, SCR_FLAG, FORM_TYPE, DISP_METADATA, PARENT_KEY_COL, ASSISTED_MODE, STORAGE_KEY_METADATA, SELECTION_MODE, DEFAULT_VIEW, AUTO_ADDON_ENTRY, FREEZE_COL_POS, DEFAULT_ROW_CNT, IS_MANDATORY, TRAN_ID_COL, KEY_INFO, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL FROM OBJ_FORMS WHERE WIN_NAME='" + winName + "'" + " AND FORM_NO NOT LIKE '%.%' " ;
			//Added by Sandeep S. on 24-NOV-17 [Implementation of Matrix-form detail form] Start
			//mQuery = "SELECT FORM_NO, TITLE, CROSS_UPDATE_EXPR, EXPR_FLD_INFO, TARGET_FLD_INFO, EXPR_COMMENT, SCAN_FLAG, SCAN_METADATA, AUTO_ACCEPT_SCAN, PROPERTY_INFO, AFTER_SAVE, COLUMN_ON_SAVE, SCAN_DELIMITER, EXT_METADATA, AUTO_ACCEPT_WEIGHDATA, SCR_FLAG, FORM_TYPE, DISP_METADATA, PARENT_KEY_COL, ASSISTED_MODE, STORAGE_KEY_METADATA, SELECTION_MODE, DEFAULT_VIEW, AUTO_ADDON_ENTRY, FREEZE_COL_POS, DEFAULT_ROW_CNT, IS_MANDATORY, TRAN_ID_COL, KEY_INFO, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL, FORM_NAME, FORM_ICON, FORM_VIEW_OPTS FROM OBJ_FORMS WHERE WIN_NAME='" + winName + "'" + " AND FORM_NO NOT LIKE '%.%' " ;
			mQuery = "SELECT FORM_NO, TITLE, CROSS_UPDATE_EXPR, EXPR_FLD_INFO, TARGET_FLD_INFO, EXPR_COMMENT, SCAN_FLAG, SCAN_METADATA, AUTO_ACCEPT_SCAN, PROPERTY_INFO, AFTER_SAVE, COLUMN_ON_SAVE, SCAN_DELIMITER, EXT_METADATA, AUTO_ACCEPT_WEIGHDATA, SCR_FLAG, FORM_TYPE, DISP_METADATA, PARENT_KEY_COL, ASSISTED_MODE, STORAGE_KEY_METADATA, SELECTION_MODE, DEFAULT_VIEW, AUTO_ADDON_ENTRY, FREEZE_COL_POS, DEFAULT_ROW_CNT, IS_MANDATORY, TRAN_ID_COL, KEY_INFO, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL, FORM_NAME, FORM_ICON, FORM_VIEW_OPTS, X_COLUMN, Y_COLUMN FROM OBJ_FORMS WHERE WIN_NAME='" + winName + "'" + " AND FORM_NO NOT LIKE '%.%' " ;
			//Changed by prathamesh jangam on 30jun17 for db2
			BaseLogger.log("3", null, null,"DATABASE NAME["+CommonConstants.DB_NAME+"]");
			if("DB2".equalsIgnoreCase( CommonConstants.DB_NAME ) )
			{
				//Added By Nilesh For TO_NUMBER() FUNCTION RETURN NUMBER LIKE 1.00 TO AVOID THIS USE CASR FUNCTION START :: 04-08-2017
				//mQuery = "SELECT TO_NUMBER(FORM_NO) AS FORM_NO, TITLE, CROSS_UPDATE_EXPR, EXPR_FLD_INFO, TARGET_FLD_INFO, EXPR_COMMENT, SCAN_FLAG, SCAN_METADATA, AUTO_ACCEPT_SCAN, PROPERTY_INFO, AFTER_SAVE, COLUMN_ON_SAVE, SCAN_DELIMITER, EXT_METADATA, AUTO_ACCEPT_WEIGHDATA, SCR_FLAG, FORM_TYPE, DISP_METADATA, PARENT_KEY_COL, ASSISTED_MODE, STORAGE_KEY_METADATA, SELECTION_MODE, DEFAULT_VIEW, AUTO_ADDON_ENTRY, FREEZE_COL_POS, DEFAULT_ROW_CNT, IS_MANDATORY, TRAN_ID_COL, KEY_INFO, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL, FORM_NAME, FORM_ICON, FORM_VIEW_OPTS FROM OBJ_FORMS WHERE WIN_NAME='" + winName + "'" + " AND FORM_NO NOT LIKE '%.%' " ;
				//mQuery = "SELECT CAST(FORM_NO AS INT) AS FORM_NO, TITLE, CROSS_UPDATE_EXPR, EXPR_FLD_INFO, TARGET_FLD_INFO, EXPR_COMMENT, SCAN_FLAG, SCAN_METADATA, AUTO_ACCEPT_SCAN, PROPERTY_INFO, AFTER_SAVE, COLUMN_ON_SAVE, SCAN_DELIMITER, EXT_METADATA, AUTO_ACCEPT_WEIGHDATA, SCR_FLAG, FORM_TYPE, DISP_METADATA, PARENT_KEY_COL, ASSISTED_MODE, STORAGE_KEY_METADATA, SELECTION_MODE, DEFAULT_VIEW, AUTO_ADDON_ENTRY, FREEZE_COL_POS, DEFAULT_ROW_CNT, IS_MANDATORY, TRAN_ID_COL, KEY_INFO, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL, FORM_NAME, FORM_ICON, FORM_VIEW_OPTS FROM OBJ_FORMS WHERE WIN_NAME='" + winName + "'" + " AND FORM_NO NOT LIKE '%.%' " ;
				mQuery = "SELECT CAST(FORM_NO AS INT) AS FORM_NO, TITLE, CROSS_UPDATE_EXPR, EXPR_FLD_INFO, TARGET_FLD_INFO, EXPR_COMMENT, SCAN_FLAG, SCAN_METADATA, AUTO_ACCEPT_SCAN, PROPERTY_INFO, AFTER_SAVE, COLUMN_ON_SAVE, SCAN_DELIMITER, EXT_METADATA, AUTO_ACCEPT_WEIGHDATA, SCR_FLAG, FORM_TYPE, DISP_METADATA, PARENT_KEY_COL, ASSISTED_MODE, STORAGE_KEY_METADATA, SELECTION_MODE, DEFAULT_VIEW, AUTO_ADDON_ENTRY, FREEZE_COL_POS, DEFAULT_ROW_CNT, IS_MANDATORY, TRAN_ID_COL, KEY_INFO, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL, FORM_NAME, FORM_ICON, FORM_VIEW_OPTS, X_COLUMN, Y_COLUMN FROM OBJ_FORMS WHERE WIN_NAME='" + winName + "'" + " AND FORM_NO NOT LIKE '%.%' " ;
				//Added by Sandeep S. on 24-NOV-17 [Implementation of Matrix-form detail form] End
				//Added By Nilesh End:: 04-08-2017
			}
			if( "oracle".equalsIgnoreCase( CommonConstants.DB_NAME ) )
			{
				mQuery = mQuery + " ORDER BY TO_NUMBER (FORM_NO) "; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}
			else
			{
				mQuery = mQuery + " ORDER BY FORM_NO "; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}

			BaseLogger.log("3", null, null,"getObjFormsDetailList.mQuery["+mQuery+"]"); //$NON-NLS-1$ //$NON-NLS-2$

			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver"); //$NON-NLS-1$
			mStmt = mConnection.createStatement();
			mRs = mStmt.executeQuery(mQuery);
			boolean isEntryValid = false;
			ArrayList<String> currFormsDetailList = null;
			String objContext = "1"; //$NON-NLS-1$
			while(mRs.next())
			{
				isEntryValid = true;
				currFormsDetailList = new ArrayList<String>();

				objContext = mRs.getString("FORM_NO"); //$NON-NLS-1$
				String title = mRs.getString("TITLE"); //$NON-NLS-1$
				if((title == null) || (title.equalsIgnoreCase("null")) || title.length() == 0) //$NON-NLS-1$
				{
					title = objName.toUpperCase();
				}
				title = new E12GenericUtility().initCap( title, "_" ); //$NON-NLS-1$
				title = title.replace( '_', ' ' );

				currFormsDetailList.add( title );// [0]
				currFormsDetailList.add( getDesiredVal( mRs.getString("CROSS_UPDATE_EXPR") ) ); //$NON-NLS-1$ [1]
				currFormsDetailList.add( getDesiredVal( mRs.getString("EXPR_FLD_INFO") ) ); //$NON-NLS-1$ [2]
				currFormsDetailList.add( getDesiredVal( mRs.getString("TARGET_FLD_INFO") ) ); //$NON-NLS-1$ [3]
				currFormsDetailList.add( getDesiredVal( mRs.getString("EXPR_COMMENT") ) ); //$NON-NLS-1$ [4]
				currFormsDetailList.add( getDesiredVal( mRs.getString("SCAN_FLAG") ) ); //$NON-NLS-1$ [5]
				currFormsDetailList.add( getDesiredVal( mRs.getString("SCAN_METADATA") ) ); //$NON-NLS-1$ [6]
				currFormsDetailList.add( getDesiredVal( mRs.getString("AUTO_ACCEPT_SCAN") ) ); //$NON-NLS-1$ [7]
				currFormsDetailList.add( getDesiredVal( mRs.getString("PROPERTY_INFO") ) ); //$NON-NLS-1$ [8]
				currFormsDetailList.add( getDesiredVal( mRs.getString("AFTER_SAVE") ) ); //$NON-NLS-1$ [9]
				currFormsDetailList.add( getDesiredVal( mRs.getString("COLUMN_ON_SAVE") ) ); //$NON-NLS-1$ [10]
				currFormsDetailList.add( getDesiredVal( mRs.getString("SCAN_DELIMITER") ) ); //$NON-NLS-1$ [11]
				currFormsDetailList.add( getDesiredVal( mRs.getString("EXT_METADATA") ) ); //$NON-NLS-1$ [12]
				currFormsDetailList.add( getDesiredVal( mRs.getString("AUTO_ACCEPT_WEIGHDATA") ) ); //$NON-NLS-1$ [13]
				currFormsDetailList.add( objContext );// [14]
				currFormsDetailList.add( getDesiredVal( mRs.getString("SCR_FLAG") ) ); //$NON-NLS-1$ [15]
				currFormsDetailList.add( getDesiredVal( mRs.getString("FORM_TYPE") ) ); //$NON-NLS-1$ [16]
				currFormsDetailList.add( getDesiredVal( mRs.getString("DISP_METADATA") ) ); //$NON-NLS-1$ [17]
				currFormsDetailList.add( getDesiredVal( mRs.getString("PARENT_KEY_COL") ) ); //$NON-NLS-1$ [18]
				currFormsDetailList.add( getDesiredVal( mRs.getString("ASSISTED_MODE") )); //$NON-NLS-1$ [19]
				currFormsDetailList.add( getDesiredVal( mRs.getString( "STORAGE_KEY_METADATA" ) ) );// [20]
				currFormsDetailList.add( getDesiredVal( mRs.getString( "SELECTION_MODE" ) ) );// [21]
				currFormsDetailList.add( getDesiredVal( mRs.getString( "DEFAULT_VIEW" ) ) );// [22]
				//Added by gayatri on 22-07-2013 [to auto save feature on multiple field]
				currFormsDetailList.add( getDesiredVal( mRs.getString( "AUTO_ADDON_ENTRY" ) ) );// [23]
				//Added by Ajinkya Gopalkar on 30-11-2015 [Request ID :D15HSUN011 - to freeze column for datagrid]
				currFormsDetailList.add( getDesiredVal( mRs.getString( "FREEZE_COL_POS" ) ) );// [24]
				//Added by Reema on 4-01-2016 [S15JSUN001 - Dynamic row number to be shown in GWT-Wizard screen]
				currFormsDetailList.add( getDesiredVal( mRs.getString( "DEFAULT_ROW_CNT" ) ) );// [25]
				//Added by Prajyot on 4-03-2016 [ Mandatory forms - IS_MANDATORY]
				currFormsDetailList.add( getDesiredVal( mRs.getString( "IS_MANDATORY" ) ) );// [26]
				//Added by Prasad on 02/06/16 [get tran_id_col for all forms]
				currFormsDetailList.add( checkNull( mRs.getString( "TRAN_ID_COL" ) ) );// [27]
				currFormsDetailList.add( checkNull( mRs.getString( "KEY_INFO" ) ) );// [28] Added by Sandeep S. on 07-OCT-16 [To set key_info values in the header field of wizard and editor]
				//Added by sanket on 10/10/16 [get image on feeds]-start
				currFormsDetailList.add( getDesiredVal( mRs.getString( "THUMB_OBJ" ) ) );// [29]
				currFormsDetailList.add( getDesiredVal( mRs.getString( "THUMB_IMAGE_COL" ) ) );// [30]
				currFormsDetailList.add( getDesiredVal( mRs.getString( "THUMB_ALT_COL" ) ) );// [31]
				//Added by sanket on 10/10/16 [get image on feeds]-END
				currFormsDetailList.add( getDesiredVal( mRs.getString( "FORM_NAME" ) ) );// [32]//Gulzar on 11/01/17
				currFormsDetailList.add( getDesiredVal( mRs.getString( "FORM_ICON" ) ) );// [33]
				currFormsDetailList.add( getDesiredVal( mRs.getString( "FORM_VIEW_OPTS" ) ) );// [34] //Added By Ajinkya G
				//Added by Sandeep S. on 24-NOV-17 [Implementation of Matrix-form detail form] Start
				currFormsDetailList.add( getDesiredVal( mRs.getString( "X_COLUMN" ) ) );// [35] //Added By Sandeep S
				currFormsDetailList.add( getDesiredVal( mRs.getString( "Y_COLUMN" ) ) );// [36] //Added By Sandeep S
				//Added by Sandeep S. on 24-NOV-17 [Implementation of Matrix-form detail form] End
				objFormsDetailList.add(currFormsDetailList);
			}//while(mRs.next())
			//Added By Nilesh Start ::01-06-2017
			if(mRs!=null)
			{
				mRs.close();
				mRs = null;
			}
			if(mStmt!=null)
			{
				mStmt.close();
				mStmt = null;
			}
			if(mConnection!=null)
			{
				mConnection.close();
				mConnection = null;
			}
			//Added By Nilesh End ::01-06-2017

			if( ! isEntryValid )
			{
				currFormsDetailList = new ArrayList<String>();
				currFormsDetailList.add( objName.toUpperCase() );// [0]
				//Change by gayatri [To add AUTO_ADDON_ENTRY column in currFormsDetailList ]
				//int totLen = 22;// Total length of currFormsDetailList when isEntryValid = true
				//int totLen = 24; //Changes by Prajyot to make same length of selected columns
				//Added by Prajyot on 4-03-2016 [ Mandatory forms - IS_MANDATORY]
				//int totLen = 26; //Changed by Prasad on 02/06/16 [get tran_id_col for all forms]
				int totLen = 35;
				for( int i = 0; i < totLen; i++ )
				{
					currFormsDetailList.add(null);
				}

				objFormsDetailList.add(currFormsDetailList);
			}
			//Changes By Prajyot On 23-Sep-2011 [To select ASSISTED_MODE from obj_forms] Ends
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException: DBAccess: getObjFormsDetailList :"); //$NON-NLS-1$
			throw itme;
		}
		catch(SQLException ex)
		{
			System.err.println("Exception: DBAccess: getObjFormsDetailList :\n"+ex); //$NON-NLS-1$
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccess: getObjFormsDetailList :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if (mStmt != null)
					{
						mStmt.close();
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getObjFormsDetailList \n" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("3", null, null,"Returning objFormsDetailList....."); //$NON-NLS-1$
		return objFormsDetailList;
	}

	//Changed by Shravan on 18/12/2006 to get view details.
	/*public HashMap getObjViewDetailMap( String objName, String formNo ) throws RemoteException, ITMException
	{
		HashMap objDetailMap = null;
		Connection mConnection = null;
		PreparedStatement pStmt = null;
		ResultSet mRs=null;
		String sqlQuery = null;
		int iResult=0;
		String objInfo = null;
		try
		{
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB( "Driver" ); //$NON-NLS-1$
			objName = ( objName.startsWith( "w_" ) ) ? objName : "w_" + objName; //$NON-NLS-1$ //$NON-NLS-2$
			sqlQuery = "SELECT KEY_FLAG ,CONFIRM_COL,CONFIRM_VAL,EDIT_TMPLT,EDIT_OPT FROM TRANSETUP WHERE TRAN_WINDOW=?"; //$NON-NLS-1$
			pStmt = mConnection.prepareStatement(sqlQuery);
			pStmt.setString(1,objName);
			mRs = pStmt.executeQuery();
			objDetailMap = new HashMap();
			while( mRs.next() )
			{
				objDetailMap.put( "KEY_FLAG", mRs.getString( "KEY_FLAG" ) ); //$NON-NLS-1$ //$NON-NLS-2$
				objDetailMap.put( "CONFIRM_COL", mRs.getString("CONFIRM_COL")); //$NON-NLS-1$ //$NON-NLS-2$
				objDetailMap.put( "CONFIRM_VAL", mRs.getString( "CONFIRM_VAL")); //$NON-NLS-1$ //$NON-NLS-2$
				objDetailMap.put( "EDIT_TMPLT", mRs.getString("EDIT_TMPLT")); //$NON-NLS-1$ //$NON-NLS-2$
				objDetailMap.put( "EDIT_OPT", mRs.getString("EDIT_OPT")); //$NON-NLS-1$ //$NON-NLS-2$
			}
			mRs.close();
			mRs = null;
			if( pStmt != null )
			{
				pStmt.close();
				pStmt = null;
			}
			//Changed by Santosh on 29/08/16 for chekbox visible/ nonvisible on form no 2
			//sqlQuery = "SELECT SCR_FLAG FROM OBJ_FORMS WHERE WIN_NAME = ? AND FORM_NO = ?"; //$NON-NLS-1$
			sqlQuery = "SELECT SCR_FLAG,SELECTION_OPT FROM OBJ_FORMS WHERE WIN_NAME = ? AND FORM_NO = ?";
			pStmt = mConnection.prepareStatement(sqlQuery);
			pStmt.setString(1,objName);
			pStmt.setString(2,formNo);
			mRs = pStmt.executeQuery();
			while( mRs.next() )
			{
				objDetailMap.put( "SCR_FLAG", mRs.getString( "SCR_FLAG" ) ); //$NON-NLS-1$ //$NON-NLS-2$
				//Added by Santosh on 29/08/16 for chekbox visible/ nonvisible on form no 2 [Start]
				objDetailMap.put( "SELECTION_OPT", mRs.getString( "SELECTION_OPT" ) );
				//Added by Santosh on 29/08/16 for chekbox visible/ nonvisible on form no 2 [End]
			}
			mRs.close();
			mRs = null;
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException :DBAccessEJB :getObjInfo :\n"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception :DBAccessEJB :getObjInfo :\n"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(pStmt != null)
					{
						pStmt.close();
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getObjInfo :==>F" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("3", null, null,"Returning objDetailMap :"+objDetailMap); //$NON-NLS-1$
		return objDetailMap;
	}*/

	/*public boolean isSignDefined(String refSer)throws  RemoteException,ITMException
	{
		boolean isSignDefined = false;
		Connection mConnection = null;
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		try
		{
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver"); //$NON-NLS-1$
			String qry = "SELECT COUNT(1) FROM OBJ_SIGN WHERE REF_SER = ?"; //$NON-NLS-1$
			pStmt = mConnection.prepareStatement(qry);
			pStmt.setString(1, refSer.trim());
			rs = pStmt.executeQuery();
			while(rs.next())
			{
				if(rs.getInt(1) > 0)
				{
					isSignDefined = true;
				}
			}
			rs.close();
			rs = null;
			pStmt.close();
			pStmt = null;
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException: DBAccess: isSignDefined :"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccess: isSignDefined :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if (pStmt != null)
					{
						pStmt.close();
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: isSignDefined \n" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		return isSignDefined;
	}*/

	public String getActionsString(String objName, String editFlag, String objContext, String profileId, String userlevel, String transDB)throws  RemoteException,ITMException
	{
		//BaseLogger.log("3", null, null,"Getting Action String for objName :["+objName+"] objContext :["+objContext+"] editFlag :["+editFlag+"] profileId :["+profileId+"]");
		String actionStr = ""; //$NON-NLS-1$
		try
		{
			//Added By Ajinkya Gopalkar on 21-SEP-17[For code optimization and reduce server call] Start
			String cacheActionStr = objName + "~~"+ profileId + "~~" + userlevel;
			String allActStr = "";
			//Added Pankaj T on 18-10-17 [for CACHE_OPT define in ibase.xml 0 = NO Cache, 1 = Internal Cache, 2 = External Cache]
			//Changed by Prasad on 23/11/2020 [check infinispanLocalObj not null]
			if( CommonConstants.CACHE_OPT != 0 && infinispanLocalObj != null )
			{
				if( infinispanLocalObj.contains(cacheActionStr))
				{
					allActStr = infinispanLocalObj.getFormData(cacheActionStr);
				}
				else
				{
					allActStr = getAllActionsString(objName, profileId, userlevel, transDB);
					infinispanLocalObj.putFormData(cacheActionStr, allActStr);
				}
			}
			else
			{
				allActStr = getAllActionsString(objName, profileId, userlevel, transDB);
			}
			//Added By Ajinkya Gopalkar on 21-SEP-17[For code optimization and reduce server call] End
			/*
			Document actionDom = GenericUtility.getInstance().parseString(allActStr);
			NodeList actnNodeChildList = actionDom.getElementsByTagName("action");
			for (int i = 0; i < actnNodeChildSize; i++)
			{
				Node currNode =	actnNodeChildList.item(i);
			}
			 */
			actionStr = allActStr;
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException: DBAccess: getActionsString:"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccess: getActionsString:"  + e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		BaseLogger.log("3", null, null,"Returning Action Str :["+actionStr+"]"); //$NON-NLS-1$ //$NON-NLS-2$
		return actionStr;
	}

	public String getAllActionsString( String objName, String profileID, String userLevel, String transDB )throws  RemoteException,ITMException
	{
		Connection mConnection = null;
		Statement mStmt = null;
		ResultSet mRs = null;
		StringBuffer allActStrBuff = new StringBuffer("<ACTIONS>"); //$NON-NLS-1$
		String  mQuery = null;
		String  mQuery1 = null;
		String strRights = ""; //$NON-NLS-1$
		String compName = ""; //$NON-NLS-1$
		String compType = ""; //$NON-NLS-1$
		String methodName = ""; //$NON-NLS-1$
		boolean isSysTypeOverwritten = false;
		try
		{
			ConnDriver mConnDriver = new ConnDriver();

			if(transDB!=null && (transDB.trim().length() >0 ))
			{
				mConnection = mConnDriver.getConnectDB(transDB);
			}

			BaseLogger.log("3", null, null,"3040 GWTCAL : Start getAllActions userLevel ["+userLevel+"]");
			if ( ("0").equals( userLevel ) ) //$NON-NLS-1$
			{
				strRights = "*"; //$NON-NLS-1$
			}
			else
			{
				//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
				//mQuery1 = "SELECT RIGHTS FROM USER_RIGHTS WHERE PROFILE_ID ='" + profileID + "'" + " AND OBJ_NAME ='"+objName+"'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				mQuery1 = "SELECT RIGHTS FROM USER_RIGHTS WHERE PROFILE_ID IN " + E12GenericUtility.getFormattedProfileId(profileID) + " AND OBJ_NAME ='"+objName+"'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				BaseLogger.log("3", null, null,"3048 GWTCAL : Start getAllActions mQuery1 ["+mQuery1+"]");
				mStmt = mConnection.createStatement();
				mRs = mStmt.executeQuery(mQuery1);
				while(mRs.next())
				{
					strRights = strRights + mRs.getString("RIGHTS"); //$NON-NLS-1$
				}
				/*--Commented and chagned by Gulzar
				mRs.close();
				mStmt.close();
				mStmt = null;
				*/
				if (mRs != null)
				{
					mRs.close();
					mRs = null;
				}
				if (mStmt != null)
				{
					mStmt.close();
					mStmt = null;
				}
			}
			BaseLogger.log("3", null, null,"GWTCAL Rights String for current Profile["+profileID+"] on current Object["+objName+"] :["+strRights+"]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			//Danish Friday, May 05, 2006 Adding if "A" / "E" exisits but "S" does not Exisits
			if ( strRights != null && strRights.length() > 0)
			{
				if ( ( strRights.indexOf("A") != -1 || strRights.indexOf("E") != -1 ) && strRights.indexOf("S") == -1 ) //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				{
					strRights = strRights+"S"; //$NON-NLS-1$
				}

				//changed by gayatri on 14-01-2013[MF3ISUN010][To add confirmation before action button ]
				//mQuery = "SELECT FORM_NO, RIGHTS_CHAR, TITLE, INTERACTIVE, SERVICE_CODE, IMAGE, SERVICE_HANDLER, PLACEMENT, ACTION_TYPE FROM OBJ_ACTIONS WHERE OBJ_NAME='"+objName+"' ORDER BY ACTION_TYPE, LINE_NO "; //$NON-NLS-1$ //$NON-NLS-2$
				//Changed by Reema on 3-Feb-16 [added show_in_panel column to show action in side panel]
				//mQuery = "SELECT FORM_NO, RIGHTS_CHAR, TITLE, INTERACTIVE, SERVICE_CODE, IMAGE, SERVICE_HANDLER, PLACEMENT, ACTION_TYPE, IS_CONFIRMATION_REQ, SEP_DUTY_OPT, RE_AUTH_OPT FROM OBJ_ACTIONS WHERE OBJ_NAME='"+objName+"' ORDER BY ACTION_TYPE, LINE_NO "; //$NON-NLS-1$ //$NON-NLS-2$
				//Changes done by Sanket on 11/10/17 [for adding def_nodata] START
				//mQuery = "SELECT FORM_NO, RIGHTS_CHAR, TITLE, INTERACTIVE, SERVICE_CODE, IMAGE, SERVICE_HANDLER, PLACEMENT, ACTION_TYPE, IS_CONFIRMATION_REQ, SEP_DUTY_OPT, RE_AUTH_OPT, SHOW_IN_PANEL, SWIPE_POSITION, ACTION_ID, MULTI_ROW_OPT FROM OBJ_ACTIONS WHERE OBJ_NAME='"+objName+"' ORDER BY ACTION_TYPE, LINE_NO "; //$NON-NLS-1$ //$NON-NLS-2$
				//Changed by Pankaj T. on 02-08-18 to display actions in subheader on display_mode basis 0 - In all mode, 1 - In home, 2 - In home & view, 3 - home & Edit, 4 - home & Add/Edit mode & add column show_confirm to configure action on confirm/cancel transaction
				//mQuery = "SELECT FORM_NO, RIGHTS_CHAR, TITLE, INTERACTIVE, SERVICE_CODE, IMAGE, SERVICE_HANDLER, PLACEMENT, ACTION_TYPE, IS_CONFIRMATION_REQ, SEP_DUTY_OPT, RE_AUTH_OPT, SHOW_IN_PANEL, SWIPE_POSITION, ACTION_ID, MULTI_ROW_OPT, DEF_NODATA, ACTION_ARG, PAGE_CONTEXT, DISPLAY_MODE, SHOW_CONFIRM FROM OBJ_ACTIONS WHERE OBJ_NAME='"+objName+"' ORDER BY ACTION_TYPE, LINE_NO "; //$NON-NLS-1$ //$NON-NLS-2$
				//Added By Pankaj T. on 03-01-19 added new column line_no for display links on homepage feed order by line_no
				//Added by Pratheek on 24-06-19[ added a new column rec_specific in obj_actions for getting the record specific actions and links]-Start
				//mQuery = "SELECT FORM_NO, RIGHTS_CHAR, TITLE, INTERACTIVE, SERVICE_CODE, IMAGE, SERVICE_HANDLER, PLACEMENT, ACTION_TYPE, IS_CONFIRMATION_REQ, SEP_DUTY_OPT, RE_AUTH_OPT, SHOW_IN_PANEL, SWIPE_POSITION, ACTION_ID, MULTI_ROW_OPT, DEF_NODATA, ACTION_ARG, PAGE_CONTEXT, DISPLAY_MODE, SHOW_CONFIRM, LINE_NO FROM OBJ_ACTIONS WHERE OBJ_NAME='"+objName+"' ORDER BY  LINE_NO "; //$NON-NLS-1$ //$NON-NLS-2$
				mQuery = "SELECT FORM_NO, RIGHTS_CHAR, TITLE, INTERACTIVE, SERVICE_CODE, IMAGE, SERVICE_HANDLER, PLACEMENT, ACTION_TYPE, IS_CONFIRMATION_REQ, SEP_DUTY_OPT, RE_AUTH_OPT, SHOW_IN_PANEL, SWIPE_POSITION, ACTION_ID, MULTI_ROW_OPT, DEF_NODATA, ACTION_ARG, PAGE_CONTEXT, DISPLAY_MODE, SHOW_CONFIRM, REC_SPECIFIC,LINE_NO FROM OBJ_ACTIONS WHERE OBJ_NAME='"+objName+"' ORDER BY  LINE_NO "; //$NON-NLS-1$ //$NON-NLS-2$
				mStmt = mConnection.createStatement();
				mRs = mStmt.executeQuery(mQuery);

				while(mRs.next())
				{
					String formNo = mRs.getString("FORM_NO"); //$NON-NLS-1$
					String rightsChar = mRs.getString("RIGHTS_CHAR"); //$NON-NLS-1$
					String title = mRs.getString("TITLE"); //$NON-NLS-1$
					String interactive = mRs.getString("INTERACTIVE"); //$NON-NLS-1$
					String serviceCode = mRs.getString("SERVICE_CODE");  //$NON-NLS-1$
					String image = mRs.getString("IMAGE"); //$NON-NLS-1$
					//D	Possible values	1=forwarding to URL	2=web service call	3=MasterStateful event
					String serviceHandler = mRs.getString("SERVICE_HANDLER"); //$NON-NLS-1$
					//D	Possible values	1=?	2=?	3=?
					String placement = mRs.getString("PLACEMENT"); //$NON-NLS-1$
					String actionType = mRs.getString("ACTION_TYPE"); //$NON-NLS-1$
					//changed by gayatri on 14-01-2013[MF3ISUN010][To add confirmation before action button ]
					String confirmationReq = mRs.getString("IS_CONFIRMATION_REQ");
					String reAuthOpt = mRs.getString("RE_AUTH_OPT");
					String sepDutyOpt = mRs.getString("SEP_DUTY_OPT");
					String showInPanel = mRs.getString("SHOW_IN_PANEL");		//Changed by Reema on 3-Feb-16 [added show_in_panel column to show action in side panel]
					//Added by Pankaj for swipe position
					String swipePos = mRs.getString("SWIPE_POSITION");
					String actionId = mRs.getString("ACTION_ID");
					//Added by Pankaj for swipe position
					String multiRowOpt =mRs.getString("MULTI_ROW_OPT"); //added by sanket on 24/08/16 [added MULTI_ROW_OPT column and get values]
					//Added by Sanket on 11/10/17 [add def_nodata]
					String defNoData = mRs.getString("DEF_NODATA");
					//Added by Prasad on 24/11/17 [action argument related implementation]
					String actionArg = mRs.getString( "ACTION_ARG" );
					//Changed by Pankaj T. on 02-08-18 to display actions in subheader on display_mode basis 0 - In all mode, 1 - In home, 2 - In home & view, 3 - home & Edit, 4 - home & Add/Edit mode & add column show_confirm to configure action on confirm/cancel transaction
					String showConfirm = mRs.getString("SHOW_CONFIRM");
					String displayMode = mRs.getString("DISPLAY_MODE");
					//Added By Pankaj T. on 03-01-19 added new column line_no for display links on homepage feed order by line_no
					String lineNo = mRs.getString("LINE_NO");
					//Added by shrutika on 29-11-17 for Implement getting page context(for copy functionality)
					String pageContext = mRs.getString("PAGE_CONTEXT");
					//Added by Pratheek on 24-06-19[ to get the record specific column value from obj_actions so to add actions and links in more button]-Start
					String recordSpecific = mRs.getString("REC_SPECIFIC");
					BaseLogger.log("3", null, null,"pageConterxt["+pageContext+"]title["+title+"] recordSpecific ["+recordSpecific+"]");
					//Added by Pratheek on 24-06-19[ to get the record specific column value from obj_actions so to add actions and links in more button]-End
					serviceHandler = (serviceHandler == null || "NULL".equalsIgnoreCase(serviceHandler))?"0":serviceHandler; //$NON-NLS-1$ //$NON-NLS-2$
					placement = (placement == null || "NULL".equalsIgnoreCase(placement))?"0" : placement; //$NON-NLS-1$ //$NON-NLS-2$
					actionId = (actionId == null || "NULL".equalsIgnoreCase(actionId))?rightsChar : actionId; //$NON-NLS-1$ //$NON-NLS-2$
					Statement stmt = null;
					ResultSet rs = null;
					String query = ""; //$NON-NLS-1$
					String argValue = ""; //$NON-NLS-1$
					BaseLogger.log("3", null, null,"Action Title :["+title+"] Form No :["+formNo+"] Rights Char :["+rightsChar+"] Service Code :["+serviceCode+"] Service Handler :["+serviceHandler+"] Action Type :["+actionType+"]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$
					if(serviceHandler != null && (serviceHandler.equals("1") || serviceHandler.equals("2"))) //$NON-NLS-1$ //$NON-NLS-2$
					{
						if(serviceCode != null && serviceCode.length() > 0)
						{
							query = "SELECT A.COMP_TYPE, A.COMP_NAME, B.SERVICE_URI, B.METHOD_NAME FROM SYSTEM_EVENTS A, SYSTEM_EVENT_SERVICES B WHERE A.SERVICE_CODE=B.SERVICE_CODE AND A.OBJ_NAME='" + objName + "' AND A.EVENT_CODE='" + serviceCode + "'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
							stmt = mConnection.createStatement();
							rs = stmt.executeQuery(query);
							while(rs.next())
							{
								compType = rs.getString("COMP_TYPE"); //$NON-NLS-1$
								compName = rs.getString("COMP_NAME"); //$NON-NLS-1$
								serviceCode = rs.getString("SERVICE_URI"); //$NON-NLS-1$
								methodName = rs.getString("METHOD_NAME"); //$NON-NLS-1$
							}
							/*--Commented and changed by Gulzar
							rs.close();
							stmt.close();
							*/
							if (rs != null)
							{
								rs.close();
								rs = null;
							}
							if (stmt != null)
							{
								stmt.close();
								stmt = null;
							}

							if(serviceCode != null && serviceCode.length() > 0)
							{
								if(! serviceCode.startsWith("http") ) //$NON-NLS-1$
								{
									if(CommonConstants.TOMCAT_HOME == null || CommonConstants.TOMCAT_HOME.length() == 0)
									{
										CommonConstants.setIBASEHOME();
									}
									// Changed By Danish sir  on 16-11-2011 [to check whether url starts with "/ibase"]start
									if( serviceCode.startsWith("/ibase")) //$NON-NLS-1$
									{
										//Commented By Pankaj T. on 30-09-2020 if server assigned multiple domains in that case issue occurs of session not getting, so remove TOMCAT_HOME
										//serviceCode = CommonConstants.TOMCAT_HOME + serviceCode;
									}
									else if( !(serviceCode.contains(".asmx")) )
									{
										serviceCode = CommonConstants.TOMCAT_HOME + "/ibase/" + CommonConstants.ITM_CONTEXT + "/jsp/" + serviceCode; //$NON-NLS-1$ //$NON-NLS-2$
									}
									// Changed By Danish sir  on 16-11-2011 [to check whether url starts with "/ibase"]end
								}
							}
							else
							{
								throw new Exception("Invalid Service Code :["+serviceCode+"] in SYSTEM_EVENT_SERVICES Cannot be empty"); //$NON-NLS-1$ //$NON-NLS-2$
							}
						}
						else
						{
							throw new Exception("Invalid Service Code :["+serviceCode+"] in OBJ_ACTIONS Cannot be empty"); //$NON-NLS-1$ //$NON-NLS-2$
						}
					}//if(serviceHandler != null && (serviceHandler.equals("1") || serviceHandler.equals("2")))
					else if( serviceHandler != null && serviceHandler.equals("5") ) //$NON-NLS-1$
					{
						if(serviceCode != null && serviceCode.length() > 0)
						{
							query = "SELECT B.ARG_VALUE FROM SYSTEM_EVENTS A, SYSTEM_SERVICE_ARGS B WHERE A.SERVICE_CODE=B.SERVICE_CODE AND A.OBJ_NAME='" + objName + "' AND A.EVENT_CODE='" + serviceCode + "' AND B.ARG_MODE='F'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
							stmt = mConnection.createStatement();
							rs = stmt.executeQuery(query);
							if(rs.next())
							{
								argValue = rs.getString("ARG_VALUE"); //$NON-NLS-1$
							}
							/*--Commented and changed by Gulzar
							rs.close();
							stmt.close();
							*/
							if (rs != null)
							{
								rs.close();
								rs = null;
							}
							if (stmt != null)
							{
								stmt.close();
								stmt = null;
							}
						}
						else
						{
							throw new Exception("Invalid Service Code :["+serviceCode+"] in OBJ_ACTIONS Cannot be empty"); //$NON-NLS-1$ //$NON-NLS-2$
						}
					}
					/*
					if(actionType == null || (actionType != null && actionType.length() == 0))
					{
						actionType = "S";
					}
					isSysTypeOverwritten = ("S".equalsIgnoreCase(actionType))?true:isSysTypeOverwritten;*/
					//Changes By Ajinkya Gopalkar on 9-May-16[For creating action in View and Edit mode]
					//Changed done by Gaurav Singh on 23-AUG-2016 [ for resolving Action button issue ]
					//if ( strRights.indexOf(rightsChar) != -1  ||  ( strRights.indexOf("*") != -1 || strRights.indexOf("V") != -1 || strRights.indexOf("E") != -1 ) ) //$NON-NLS-1$
					if ( strRights.indexOf(rightsChar) != -1  || strRights.indexOf("*") != -1 )
					{
						//changed by gayatri on 14-01-2013[MF3ISUN010][To add confirmation before action button ]
						//allActStrBuff.append("\n<action id='"+rightsChar+"' enabled='-1' title ='"+title+"' interactive='"+interactive+"' image='"+image+"' action_type='"+actionType+"' obj_context='"+( (actionType.equalsIgnoreCase( "S" ) ) ? "1" : formNo )+"' service_handler='"+serviceHandler+"' placement='"+placement+"'>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$ //$NON-NLS-11$
						//Changed by Reema on 3-Feb-16 [added show_in_panel column to show action in side panel]
						//allActStrBuff.append("\n<action id='"+rightsChar+"' enabled='-1' title ='"+title+"' interactive='"+interactive+"' image='"+image+"' action_type='"+actionType+"' obj_context='"+( (actionType.equalsIgnoreCase( "S" ) ) ? "1" : formNo )+"' service_handler='"+serviceHandler+"' placement='"+placement+"' confirmation_req='"+confirmationReq+"' sep_duty_opt='"+sepDutyOpt+"' re_auth_opt='"+reAuthOpt+"' >"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$ //$NON-NLS-11$
						//Changed By Suraj on 14-July-2016 [To add formNO from obj_actions table ]
						//Changed by parikshit on 29/12/16 [to set form number] start
						//allActStrBuff.append("\n<action formNo='"+formNo+"' id='"+rightsChar+"' enabled='-1' title ='"+title+"' interactive='"+interactive+"' image='"+image+"' action_type='"+actionType+"' obj_context='"+( (actionType.equalsIgnoreCase( "S" ) ) ? "1" : formNo )+"' service_handler='"+serviceHandler+"' placement='"+placement+"' confirmation_req='"+confirmationReq+"' sep_duty_opt='"+sepDutyOpt+"' re_auth_opt='"+reAuthOpt+"' showInPanel= '"+showInPanel+"' swipe_position='"+swipePos+"' action_id='"+actionId+"' multiRowOpt= '"+multiRowOpt+"'>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$ //$NON-NLS-11$ //$NON-NLS-12$ //$NON-NLS-13$
						//Changes Done By sanket J on 11/09/17 [for def_nodata]
						//allActStrBuff.append("\n<action formNo='"+formNo+"' id='"+rightsChar+"' enabled='-1' title ='"+title+"' interactive='"+interactive+"' image='"+image+"' action_type='"+actionType+"' obj_context='"+formNo+"' service_handler='"+serviceHandler+"' placement='"+placement+"' confirmation_req='"+confirmationReq+"' sep_duty_opt='"+sepDutyOpt+"' re_auth_opt='"+reAuthOpt+"' showInPanel= '"+showInPanel+"' swipe_position='"+swipePos+"' action_id='"+actionId+"' multiRowOpt= '"+multiRowOpt+"'>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$ //$NON-NLS-11$ //$NON-NLS-12$ //$NON-NLS-13$
						//Added by Prasad on 24/11/17 [action argument related implementation]
						//Changed by Pankaj T. on 02-08-18 to display actions in subheader on display_mode basis 0 - In all mode, 1 - In home, 2 - In home & view, 3 - home & Edit, 4 - home & Add/Edit mode & add column show_confirm to configure action on confirm/cancel transaction
						//Added By Pankaj T. on 03-01-19 added new column line_no for display links on homepage feed order by line_no
						//Added by Pratheek on 24-06-19[ added new column rec_specific to get the record specific actions and links ]-Start
						allActStrBuff.append("\n<action formNo='"+formNo+"' id='"+rightsChar+"' enabled='-1' title ='"+title+"' interactive='"+interactive+"' image='"+image+"' action_type='"+actionType+"' obj_context='"+formNo+"' service_handler='"+serviceHandler+"' placement='"+placement+"' confirmation_req='"+confirmationReq+"' sep_duty_opt='"+sepDutyOpt+"' re_auth_opt='"+reAuthOpt+"' showInPanel= '"+showInPanel+"' swipe_position='"+swipePos+"' action_id='"+actionId+"' multiRowOpt= '"+multiRowOpt+"' def_NoData= '"+defNoData+"' action_arg= '"+ actionArg +"' page_context= '"+ pageContext +"' display_mode= '"+ displayMode + "' show_confirm= '"+ showConfirm + "' rec_specific= '" +recordSpecific+"' line_no = '"+ lineNo + "'>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$ //$NON-NLS-11$ //$NON-NLS-12$ //$NON-NLS-13$
						//Changed by parikshit on 29/12/16 [to set form number] end
						allActStrBuff.append("<service_code cmpType='"+compType+"' cmpName='"+compName+"' metName='"+methodName+"' argVal='"+argValue+"'><![CDATA["+serviceCode+"]]></service_code>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
						allActStrBuff.append("</action>"); //$NON-NLS-1$
					}
				}//while(mRs.next())
				/*--Commented and changed by Gulzar
				mRs.close();
				mStmt.close();
				mStmt = null;
				*/
				if (mRs != null)
				{
					mRs.close();
					mRs = null;
				}
				if (mStmt != null)
				{
					mStmt.close();
					mStmt = null;
				}
				/*if( ! isSysTypeOverwritten)
				{
					strRights = (strRights == null) ? "" : strRights;
					if(strRights.indexOf("*") != -1 || strRights.indexOf("A") != -1)
					{
						allActStrBuff.append("\n<action id='A' enabled='-1' title ='Add' interactive='Y' image='a' action_type='S' obj_context='1' service_handler='0' placement='0'>");
						allActStrBuff.append("<service_code>NA</service_code>");
						allActStrBuff.append("</action>");
					}
					else if(strRights.indexOf("*") != -1 || strRights.indexOf("E") != -1)
					{
						allActStrBuff.append("\n<action id='E' enabled='-1' title ='Edit' interactive='Y' image='e' action_type='S' obj_context='1' service_handler='0' placement='0'>");
						allActStrBuff.append("<service_code>NA</service_code>");
						allActStrBuff.append("</action>");
					}
					else if(strRights.indexOf("*") != -1 || strRights.indexOf("D") != -1)
					{
						allActStrBuff.append("\n<action id='D' enabled='-1' title ='Delete' interactive='Y' image='d' action_type='S' obj_context='1' service_handler='0' placement='0'>");
						allActStrBuff.append("<service_code>NA</service_code>");
						allActStrBuff.append("</action>");
					}
					else if(strRights.indexOf("*") != -1 || strRights.indexOf("S") != -1)
					{
						allActStrBuff.append("\n<action id='S' enabled='-1' title ='Save' interactive='Y' image='s' action_type='S' obj_context='1' service_handler='0' placement='0'>");
						allActStrBuff.append("<service_code>NA</service_code>");
						allActStrBuff.append("</action>");
					}
				}*/
				allActStrBuff.append("\n</ACTIONS>"); //$NON-NLS-1$
			}//if ( strRights != null && strRights.lenght() > 0)
			else
			{
				allActStrBuff.append("\n</ACTIONS>"); //$NON-NLS-1$
				BaseLogger.log("3", null, null,"No rights defined for profileID ["+profileID + "] for OBJ_NAME ["+objName+"]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException: DBAccess: getAllActionsString:"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccess: getAllActionsString:"  + e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(mStmt != null)
					{
						mStmt.close();
						mStmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getAllActionsString \n" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("3", null, null,"Actions String============================\n"+allActStrBuff.toString()+"\n"); //$NON-NLS-1$ //$NON-NLS-2$
		return allActStrBuff.toString();
	}

	//Commented and Added by Saiprasad on 15-03-19 to add userinfo as a parameter
	//public String getUserInfoString(String objName, String userId, String profileId, String userLevel, String transDB )throws  RemoteException,ITMException
	public String getUserInfoString(String objName, String userId, String profileId, String userLevel, String transDB, UserInfoBean userInfo )throws  RemoteException,ITMException
	{
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		StringBuffer userInfoXMLBuff = new StringBuffer();
		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB(transDB); //$NON-NLS-1$

			userInfoXMLBuff.append("<transname id='"+objName+"'>"); //$NON-NLS-1$ //$NON-NLS-2$
			userInfoXMLBuff.append("<filters>"); //$NON-NLS-1$

			String query = "SELECT FILTER_NAME, FILTER_POS, DEFAULT_OPT, FILTER_STR FROM USER_FILTER_SETTING WHERE USER_ID ='" + userId + "'" + " AND WIN_NAME = 'w_"+objName+"'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			BaseLogger.log("3", null, null,"[DBAccessEJB]Getting user Info, query :\n"+query+":"); //$NON-NLS-1$ //$NON-NLS-2$
			stmt = conn.createStatement();
			rs = stmt.executeQuery(query);
			//Added by madhup 11/01/07 for getting common user filter
			boolean userFilterExists = false;

			while( rs.next() )
			{
				String filterName = rs.getString("FILTER_NAME"); //$NON-NLS-1$
				String filterPos = rs.getString("FILTER_POS"); //$NON-NLS-1$
				String defaultOpt = rs.getString("DEFAULT_OPT"); //$NON-NLS-1$
				String filterStr = rs.getString("FILTER_STR"); //$NON-NLS-1$

				userInfoXMLBuff.append("<filter pos='"+filterPos+"' default_opt='"+defaultOpt+"'>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				userInfoXMLBuff.append("<name><![CDATA["+filterName+"]]></name>"); //$NON-NLS-1$ //$NON-NLS-2$
				userInfoXMLBuff.append("<expr><![CDATA["+filterStr+"]]></expr>"); //$NON-NLS-1$ //$NON-NLS-2$
				userInfoXMLBuff.append("</filter>"); //$NON-NLS-1$

				// Added by madhup 11/01/07 setting usrBasedFlt as found
				userFilterExists = true;
			}
			rs.close();
			stmt.close();
			stmt = null;
			//changes by madhup 11/01/07 for getting common user filter
			if( ! userFilterExists )
			{
				query = "SELECT FILTER_NAME, FILTER_POS, DEFAULT_OPT, FILTER_STR FROM USER_FILTER_SETTING WHERE USER_ID ='X'" + " AND WIN_NAME = 'w_"+objName+"'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				BaseLogger.log("3", null, null,"[DBAccessEJB]Getting user Info, query :\n"+query+":"); //$NON-NLS-1$ //$NON-NLS-2$
				stmt = conn.createStatement();
				rs = stmt.executeQuery(query);
				while(rs.next())
				{
					String filterName = rs.getString("FILTER_NAME"); //$NON-NLS-1$
					String filterPos = rs.getString("FILTER_POS"); //$NON-NLS-1$
					String defaultOpt = rs.getString("DEFAULT_OPT"); //$NON-NLS-1$
					String filterStr = rs.getString("FILTER_STR"); //$NON-NLS-1$

					userInfoXMLBuff.append("<filter pos='"+filterPos+"' default_opt='"+defaultOpt+"'>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
					userInfoXMLBuff.append("<name><![CDATA["+filterName+"]]></name>"); //$NON-NLS-1$ //$NON-NLS-2$
					userInfoXMLBuff.append("<expr><![CDATA["+filterStr+"]]></expr>"); //$NON-NLS-1$ //$NON-NLS-2$
					userInfoXMLBuff.append("</filter>"); //$NON-NLS-1$
				}
			}
			rs.close();
			if ( stmt != null )
			{
				stmt.close();
				stmt = null;
			}
			// end changes 11/01/07
			userInfoXMLBuff.append("</filters>"); //$NON-NLS-1$
			userInfoXMLBuff.append("<rights_str><![CDATA["+getUserRightsString(objName, profileId, userLevel, transDB , userInfo )+"]]></rights_str>"); //$NON-NLS-1$ //$NON-NLS-2$
			userInfoXMLBuff.append("<AUDIT_STR><![CDATA["+getAuditTrialRights(objName, profileId, userLevel, transDB )+"]]></AUDIT_STR>");
			userInfoXMLBuff.append("</transname>");			 //$NON-NLS-1$
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException :DBAccessEJB :getUserInfoString :==>"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception :DBAccessEJB :getUserInfoString :==>"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(stmt != null)
					{
						stmt.close();
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getUserInfoString :==>\n"+e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("3", null, null,"[DBAccessEJB]Returning user Info string !!!!!!!!!!!!!!!"); //$NON-NLS-1$
		return userInfoXMLBuff.toString();
	}
	//Commented and Added by Saiprasad on 15-03-19 to add userinfo as a parameter
	//public String getUserRightsString( String objName, String profileID, String userLevel, String transDB )throws ITMException
	public String getUserRightsString( String objName, String profileID, String userLevel, String transDB,UserInfoBean userInfoBean)throws ITMException
	{
		ConnDriver connDriver = null;
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		//Commented and Added by Saiprasad on 15-03-19 to get rights from user_adhic_rights [START]
		PreparedStatement pStmt = null;
		String userAdhocRights = "",userAdhocRightSql = "",userRightType =" ";
		String userID = userInfoBean.getLoginCode();
		String currSiteCode = userInfoBean.getSiteCode();
	    String siteCodeLogin = "";
	    Timestamp effFromUserAdhoc = null,validUptoAdhoc = null,currDateTs = null;
	    //Added by saiprasad G.
	    Date curr= new Date();
	    E12GenericUtility genericUtility = new E12GenericUtility();
	  //Commented and Added by Saiprasad on 15-03-19 to get rights from user_adhic_rights [END]
		//Changed by Dhruv on 10/11/2006 to handle user rights.
		//String rightsStr = "*";
		String rightsStr = ""; //$NON-NLS-1$
		try
		{
			BaseLogger.log("3", null, null, "userLevel :["+userLevel+"] userLevel == 0:["+(userLevel == "0")+"]" ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			if( "0".equals( userLevel ) ) //$NON-NLS-1$
			{
				rightsStr = "*"; //$NON-NLS-1$
			}
			else
			{
				connDriver = new ConnDriver();
				conn = connDriver.getConnectDB( transDB ); //$NON-NLS-1$
				//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
				//String query = "SELECT RIGHTS FROM USER_RIGHTS WHERE PROFILE_ID ='" + profileID + "'" + " AND OBJ_NAME ='"+objName+"'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				String query = "SELECT RIGHTS FROM USER_RIGHTS WHERE PROFILE_ID IN " + E12GenericUtility.getFormattedProfileId(profileID) + " AND OBJ_NAME ='"+objName+"'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				BaseLogger.log("3", null, null, "[DBAccessEJB]Getting user rights, query :\n"+query+":" ); //$NON-NLS-1$ //$NON-NLS-2$
				stmt = conn.createStatement();
				rs = stmt.executeQuery(query);
				while(rs.next())
				{
					rightsStr = rightsStr + rs.getString( "RIGHTS" ); //$NON-NLS-1$
				}
				rs.close();
				rs = null;
				stmt.close();
				stmt = null;
				//Added by Saiprasad G. for overridding the rights from the user_rights_adhoc table on 15-03-19 START
				SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
				String currDateStr = sdfAppl.format(curr);

				userAdhocRightSql = "SELECT RIGHTS,RIGHTS_TYPE,SITE_CODE__LOGIN, EFF_FROM,VALID_UPTO FROM USER_RIGHTS_ADHOC WHERE OBJ_NAME =? AND USER_ID =?" ;
				pStmt=conn.prepareStatement(userAdhocRightSql);
				pStmt.setString(1, objName);
				pStmt.setString(2, userID);
				rs=pStmt.executeQuery();
				while(rs.next())
				{
					userRightType = rs.getString("RIGHTS_TYPE");
					userAdhocRights = rs.getString("RIGHTS");
					siteCodeLogin=E12GenericUtility.checkNull(rs.getString("SITE_CODE__LOGIN"));
					effFromUserAdhoc = rs.getTimestamp("EFF_FROM");
					validUptoAdhoc = rs.getTimestamp("VALID_UPTO");
				}

				currDateTs = Timestamp.valueOf(genericUtility.getValidDateString(currDateStr,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())+ " 00:00:00.0");

				if(userRightType.equalsIgnoreCase("O"))
				{
					BaseLogger.log("3", null, null,"[DBAccessEJB]UserAdhocRights gets from the override["+userAdhocRights+"]");
					if((!currDateTs.before(effFromUserAdhoc)) && (!currDateTs.after(validUptoAdhoc)))
					{
						if(currSiteCode.equalsIgnoreCase(siteCodeLogin) || siteCodeLogin.length()==0)
						{
							rightsStr = userAdhocRights;
							BaseLogger.log("3", null, null,"[DBAccessEJB]RightStr gets from the overridd["+rightsStr+"]");
						}
					}
					else
					{
						BaseLogger.log("3", null, null,"[DBAccessEJB]User right gets from the Existing1:["+rightsStr+"]");
					}
				}
				if(rs!=null)
				{
					rs.close();
					rs = null;
				}
				if(pStmt!=null)
				{
					pStmt.close();
					pStmt = null;
				}
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}
				//Added by Saiprasad G. for overridding the rights from the user_rights_adhoc table on 15-03-19 START
			}
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException :DBAccessEJB :getUserRightsString :==>"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception :DBAccessEJB :getUserRightsString :==>"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs=null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getUserRightsString :==>\n"+e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("3", null, null,"[DBAccessEJB]Returning usr rights string :\n"+rightsStr+"\n"); //$NON-NLS-1$ //$NON-NLS-2$
		return rightsStr;
	}

	/*public String getObjActionString(String objName)throws  RemoteException,ITMException
	{
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		StringBuffer retXMLBuff = new StringBuffer();
		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver"); //$NON-NLS-1$

			String query = "SELECT RIGHTS_CHAR,TITLE,SERVICE_CODE FROM OBJ_ACTIONS WHERE OBJ_NAME='"+objName+"'"; //$NON-NLS-1$ //$NON-NLS-2$
			BaseLogger.log("3", null, null,"[DBAccessEJB]Getting object action string, query :\n"+query+":"); //$NON-NLS-1$ //$NON-NLS-2$
			stmt = conn.createStatement();
			rs = stmt.executeQuery(query);
			retXMLBuff.append("<Root>"+"\n"); //$NON-NLS-1$ //$NON-NLS-2$
			while(rs.next())
			{
				String rightsChar = rs.getString("RIGHTS_CHAR"); //$NON-NLS-1$
				String title = rs.getString("TITLE"); //$NON-NLS-1$
				String serviceCode = rs.getString("SERVICE_CODE"); //$NON-NLS-1$

				retXMLBuff.append("<Action id='" + rightsChar + "' title='" + title +"' service_code='" + serviceCode +"' >"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				retXMLBuff.append("</Action>"+"\n"); //$NON-NLS-1$ //$NON-NLS-2$
			}
			retXMLBuff.append("</Root>"+"\n"); //$NON-NLS-1$ //$NON-NLS-2$
			stmt.close();
			stmt = null;
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException :DBAccessEJB :getObjActionString :==>"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception :DBAccessEJB :getObjActionString :==>"+ e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getObjActionString \n" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("3", null, null,"[DBAccessEJB]Returning object action string :\n"+retXMLBuff+"\n"); //$NON-NLS-1$ //$NON-NLS-2$
		return retXMLBuff.toString();
	}*/

	private String getNormalizeString(String nodeString)throws ITMException
	{
		StringBuffer tempStringBuff = new StringBuffer();
		try
		{
			tempStringBuff.append("<DocumentRoot>"); //$NON-NLS-1$
			tempStringBuff.append("<description>Datawindow Root</description>"); //$NON-NLS-1$
			tempStringBuff.append("<group0>"); //$NON-NLS-1$
			tempStringBuff.append("<description>Group0 description</description>"); //$NON-NLS-1$
			tempStringBuff.append("<Header0>"); //$NON-NLS-1$
			tempStringBuff.append("<description>Header0 members</description>"); //$NON-NLS-1$

			tempStringBuff.append(nodeString);

			tempStringBuff.append("</Header0>"); //$NON-NLS-1$
			tempStringBuff.append("</group0>"); //$NON-NLS-1$
			tempStringBuff.append("</DocumentRoot>"); //$NON-NLS-1$
		}
		catch(Exception e)
		{
			BaseLogger.log("3", null, null,"Exception :DBAccessEJB :getNormalizeString :==>\n"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return tempStringBuff.toString();
	}

	public String getUserName(String userCode)throws RemoteException, ITMException
	{
		BaseLogger.log("3", null, null,"[DBAccessEJB] getUserName() for userCode :"+userCode); //$NON-NLS-1$
		Connection mConnection = null;
		CallableStatement cStmt = null;
		String userName = ""; //$NON-NLS-1$

		try
		{
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver"); //$NON-NLS-1$

			cStmt = mConnection.prepareCall("{? = call DDF_GET_USER_NAME(?)}"); //$NON-NLS-1$
			cStmt.setString(2, userCode);
			cStmt.registerOutParameter(1,Types.VARCHAR);
			cStmt.executeUpdate();
			userName = cStmt.getString(1);
			cStmt.close();
			cStmt = null;
			//BaseLogger.log("3", null, null,"User Name :"+userName);
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException :DBAccessEJB :getUserName :\n"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception :DBAccessEJB :getUserName :\n"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if (cStmt != null)
					{
						cStmt.close();
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getUserName :==>\n"+e.getMessage()); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		return userName;
	}

	public ArrayList getMailDetailList(String formatCode)throws RemoteException, ITMException
	{
		BaseLogger.log("3", null, null,"[DBAccessEJB] :getMailDetails() for Format Code :"+formatCode); //$NON-NLS-1$
		ConnDriver mConnDriver = null;
		Connection mConnection = null;
		Statement stmt = null;
		ResultSet mRs = null;
		ResultSetMetaData rsmd = null;
		ArrayList mailDetailList = null;
		try
		{
			mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver"); //$NON-NLS-1$

			String mQuery = "SELECT SEND_TO, COPY_TO, BLIND_COPY, SUBJECT, BODY_TEXT, ATTACH_TYPE FROM MAIL_FORMAT WHERE FORMAT_CODE = '"+formatCode+"'"; //$NON-NLS-1$ //$NON-NLS-2$
			stmt = mConnection.createStatement();
			mRs = stmt.executeQuery(mQuery);

			rsmd = mRs.getMetaData();
			int noOfCols = rsmd.getColumnCount();

			mailDetailList = new ArrayList();

			if (mRs.next())
			{
				String data = null;
				for (int ctr = 1; ctr <= noOfCols; ctr++)
				{
					data = mRs.getString(ctr);
					mailDetailList.add(data);
				}
			}
			stmt.close();
			stmt = null;
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException :DBAccessEJB :getMailDetails :\n"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception :DBAccessEJB :getMailDetails :\n"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getMailDetails :\n"+e.getMessage()); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		return mailDetailList;
	}


	//Added by Chitranga Tandel on 12-march-2018 to get Actions in json format
	public String getAllActionsJson( String objName, String profileID, String userLevel, String transDB )throws  RemoteException,ITMException, JSONException
	{
		Connection mConnection = null;
		Statement mStmt = null;
		ResultSet mRs = null;

		JSONArray allActJsonArr = new JSONArray();
		JSONObject actionJson = new JSONObject();
		JSONArray actJsonArr = new JSONArray();
		JSONObject allActJsonObj = new JSONObject();

		String  mQuery = null;
		String  mQuery1 = null;
		String strRights = ""; //$NON-NLS-1$
		String compName = ""; //$NON-NLS-1$
		String compType = ""; //$NON-NLS-1$
		String methodName = ""; //$NON-NLS-1$
		boolean isSysTypeOverwritten = false;
		try
		{
			ConnDriver mConnDriver = new ConnDriver();



			if(transDB!=null && (transDB.trim().length() >0 ))
			{
				mConnection = mConnDriver.getConnectDB(transDB);
			}

			BaseLogger.log("3", null, null,"3040 GWTCAL : Start getAllActions userLevel ["+userLevel+"]");
			if ( ("0").equals( userLevel ) ) //$NON-NLS-1$
			{
				strRights = "*"; //$NON-NLS-1$
			}
			else
			{
				mQuery1 = "SELECT RIGHTS FROM USER_RIGHTS WHERE PROFILE_ID IN " + E12GenericUtility.getFormattedProfileId(profileID) + " AND OBJ_NAME ='"+objName+"'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				BaseLogger.log("3", null, null,"3048 GWTCAL : Start getAllActions mQuery1 ["+mQuery1+"]");
				mStmt = mConnection.createStatement();
				mRs = mStmt.executeQuery(mQuery1);
				while(mRs.next())
				{
					strRights = strRights + mRs.getString("RIGHTS"); //$NON-NLS-1$
				}
				if (mRs != null)
				{
					mRs.close();
					mRs = null;
				}
				if (mStmt != null)
				{
					mStmt.close();
					mStmt = null;
				}
			}
			BaseLogger.log("3", null, null,"GWTCAL Rights String for current Profile["+profileID+"] on current Object["+objName+"] :["+strRights+"]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			if ( strRights != null && strRights.length() > 0)
			{


				if ( ( strRights.indexOf("A") != -1 || strRights.indexOf("E") != -1 ) && strRights.indexOf("S") == -1 ) //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				{
					strRights = strRights+"S"; //$NON-NLS-1$
				}
				//Changed by Pankaj T. on 02-08-18 to display actions in subheader on display_mode basis 0 - In all mode, 1 - In home, 2 - In home & view, 3 - home & Edit, 4 - home & Add/Edit mode & add column show_confirm to configure action on confirm/cancel transaction
				//mQuery = "SELECT FORM_NO, RIGHTS_CHAR, TITLE, INTERACTIVE, SERVICE_CODE, IMAGE, SERVICE_HANDLER, PLACEMENT, ACTION_TYPE, IS_CONFIRMATION_REQ, SEP_DUTY_OPT, RE_AUTH_OPT, SHOW_IN_PANEL, SWIPE_POSITION, ACTION_ID, MULTI_ROW_OPT, DEF_NODATA, ACTION_ARG, PAGE_CONTEXT, DISPLAY_MODE, SHOW_CONFIRM FROM OBJ_ACTIONS WHERE OBJ_NAME='"+objName+"' ORDER BY ACTION_TYPE, LINE_NO "; //$NON-NLS-1$ //$NON-NLS-2$
				//Added By Pankaj T. on 03-01-19 added new column line_no for display links on homepage feed order by line_no
				//Added by Pratheek on 24-06-19[ added a new column rec_specific in obj_actions for getting the record specific actions and links]-Start
				//mQuery = "SELECT FORM_NO, RIGHTS_CHAR, TITLE, INTERACTIVE, SERVICE_CODE, IMAGE, SERVICE_HANDLER, PLACEMENT, ACTION_TYPE, IS_CONFIRMATION_REQ, SEP_DUTY_OPT, RE_AUTH_OPT, SHOW_IN_PANEL, SWIPE_POSITION, ACTION_ID, MULTI_ROW_OPT, DEF_NODATA, ACTION_ARG, PAGE_CONTEXT, DISPLAY_MODE, SHOW_CONFIRM, LINE_NO FROM OBJ_ACTIONS WHERE OBJ_NAME='"+objName+"' ORDER BY LINE_NO "; //$NON-NLS-1$ //$NON-NLS-2$
				mQuery = "SELECT FORM_NO, RIGHTS_CHAR, TITLE, INTERACTIVE, SERVICE_CODE, IMAGE, SERVICE_HANDLER, PLACEMENT, ACTION_TYPE, IS_CONFIRMATION_REQ, SEP_DUTY_OPT, RE_AUTH_OPT, SHOW_IN_PANEL, SWIPE_POSITION, ACTION_ID, MULTI_ROW_OPT, DEF_NODATA, ACTION_ARG, PAGE_CONTEXT, DISPLAY_MODE, SHOW_CONFIRM, REC_SPECIFIC,LINE_NO FROM OBJ_ACTIONS WHERE OBJ_NAME='"+objName+"' ORDER BY LINE_NO "; //$NON-NLS-1$ //$NON-NLS-2$
				mStmt = mConnection.createStatement();
				mRs = mStmt.executeQuery(mQuery);

				while(mRs.next())
				{


					String formNo = mRs.getString("FORM_NO"); //$NON-NLS-1$
					String rightsChar = mRs.getString("RIGHTS_CHAR"); //$NON-NLS-1$
					String title = mRs.getString("TITLE"); //$NON-NLS-1$
					String interactive = mRs.getString("INTERACTIVE"); //$NON-NLS-1$
					String serviceCode = mRs.getString("SERVICE_CODE");  //$NON-NLS-1$
					String image = mRs.getString("IMAGE"); //$NON-NLS-1$
					//D	Possible values	1=forwarding to URL	2=web service call	3=MasterStateful event
					String serviceHandler = mRs.getString("SERVICE_HANDLER"); //$NON-NLS-1$
					//D	Possible values	1=?	2=?	3=?
					String placement = mRs.getString("PLACEMENT"); //$NON-NLS-1$
					String actionType = mRs.getString("ACTION_TYPE"); //$NON-NLS-1$
					//changed by gayatri on 14-01-2013[MF3ISUN010][To add confirmation before action button ]
					String confirmationReq = mRs.getString("IS_CONFIRMATION_REQ");
					String reAuthOpt = mRs.getString("RE_AUTH_OPT");
					String sepDutyOpt = mRs.getString("SEP_DUTY_OPT");
					String showInPanel = mRs.getString("SHOW_IN_PANEL");		//Changed by Reema on 3-Feb-16 [added show_in_panel column to show action in side panel]
					//Added by Pankaj for swipe position
					String swipePos = mRs.getString("SWIPE_POSITION");
					String actionId = mRs.getString("ACTION_ID");
					//Added by Pankaj for swipe position
					String multiRowOpt =mRs.getString("MULTI_ROW_OPT"); //added by sanket on 24/08/16 [added MULTI_ROW_OPT column and get values]
					//Added by Sanket on 11/10/17 [add def_nodata]
					String defNoData = mRs.getString("DEF_NODATA");
					//Added by Prasad on 24/11/17 [action argument related implementation]
					String actionArg = mRs.getString( "ACTION_ARG" );
					//Changed by Pankaj T. on 02-08-18 to display actions in subheader on display_mode basis 0 - In all mode, 1 - In home, 2 - In home & view, 3 - home & Edit, 4 - home & Add/Edit mode & add column show_confirm to configure action on confirm/cancel transaction
					String showConfirm = mRs.getString("SHOW_CONFIRM");
					String displayMode = mRs.getString("DISPLAY_MODE");
					//Added By Pankaj T. on 03-01-19 added new column line_no for display links on homepage feed order by line_no
					String lineNo = mRs.getString("LINE_NO");
					//Added by shrutika on 29-11-17 for Implement getting page context(for copy functionality)
					String pageContext = mRs.getString("PAGE_CONTEXT");
					//Added by Pratheek on 24-06-19[ added new column rec_specific to get the record specific actions and links ]-Start
					String recordSpecific = mRs.getString("REC_SPECIFIC");
					serviceHandler = (serviceHandler == null || "NULL".equalsIgnoreCase(serviceHandler))?"0":serviceHandler; //$NON-NLS-1$ //$NON-NLS-2$
					placement = (placement == null || "NULL".equalsIgnoreCase(placement))?"0" : placement; //$NON-NLS-1$ //$NON-NLS-2$
					actionId = (actionId == null || "NULL".equalsIgnoreCase(actionId))?rightsChar : actionId; //$NON-NLS-1$ //$NON-NLS-2$
					Statement stmt = null;
					ResultSet rs = null;
					String query = ""; //$NON-NLS-1$
					String argValue = ""; //$NON-NLS-1$
					BaseLogger.log("3", null, null,"Action Title :["+title+"] Form No :["+formNo+"] Rights Char :["+rightsChar+"] Service Code :["+serviceCode+"] Service Handler :["+serviceHandler+"] Action Type :["+actionType+"]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$
					if(serviceHandler != null && (serviceHandler.equals("1") || serviceHandler.equals("2"))) //$NON-NLS-1$ //$NON-NLS-2$
					{
						if(serviceCode != null && serviceCode.length() > 0)
						{
							query = "SELECT A.COMP_TYPE, A.COMP_NAME, B.SERVICE_URI, B.METHOD_NAME FROM SYSTEM_EVENTS A, SYSTEM_EVENT_SERVICES B WHERE A.SERVICE_CODE=B.SERVICE_CODE AND A.OBJ_NAME='" + objName + "' AND A.EVENT_CODE='" + serviceCode + "'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
							stmt = mConnection.createStatement();
							rs = stmt.executeQuery(query);
							while(rs.next())
							{
								compType = rs.getString("COMP_TYPE"); //$NON-NLS-1$
								compName = rs.getString("COMP_NAME"); //$NON-NLS-1$
								serviceCode = rs.getString("SERVICE_URI"); //$NON-NLS-1$
								methodName = rs.getString("METHOD_NAME"); //$NON-NLS-1$
							}
							if (rs != null)
							{
								rs.close();
								rs = null;
							}
							if (stmt != null)
							{
								stmt.close();
								stmt = null;
							}

							if(serviceCode != null && serviceCode.length() > 0)
							{
								if(! serviceCode.startsWith("http") ) //$NON-NLS-1$
								{
									if(CommonConstants.TOMCAT_HOME == null || CommonConstants.TOMCAT_HOME.length() == 0)
									{
										CommonConstants.setIBASEHOME();
									}
									// Changed By Danish sir  on 16-11-2011 [to check whether url starts with "/ibase"]start
									if( serviceCode.startsWith("/ibase")) //$NON-NLS-1$
									{
										//Commented By Pankaj T. on 30-09-2020 if server assigned multiple domains in that case issue occurs of session not getting, so remove TOMCAT_HOME
										//serviceCode = CommonConstants.TOMCAT_HOME + serviceCode;
									}
									else if( !(serviceCode.contains(".asmx")) )
									{
										serviceCode = CommonConstants.TOMCAT_HOME + "/ibase/" + CommonConstants.ITM_CONTEXT + "/jsp/" + serviceCode; //$NON-NLS-1$ //$NON-NLS-2$
									}
									// Changed By Danish sir  on 16-11-2011 [to check whether url starts with "/ibase"]end
								}
							}
							else
							{
								throw new Exception("Invalid Service Code :["+serviceCode+"] in SYSTEM_EVENT_SERVICES Cannot be empty"); //$NON-NLS-1$ //$NON-NLS-2$
							}
						}
						else
						{
							throw new Exception("Invalid Service Code :["+serviceCode+"] in OBJ_ACTIONS Cannot be empty"); //$NON-NLS-1$ //$NON-NLS-2$
						}
					}//if(serviceHandler != null && (serviceHandler.equals("1") || serviceHandler.equals("2")))
					else if( serviceHandler != null && serviceHandler.equals("5") ) //$NON-NLS-1$
					{
						if(serviceCode != null && serviceCode.length() > 0)
						{
							query = "SELECT B.ARG_VALUE FROM SYSTEM_EVENTS A, SYSTEM_SERVICE_ARGS B WHERE A.SERVICE_CODE=B.SERVICE_CODE AND A.OBJ_NAME='" + objName + "' AND A.EVENT_CODE='" + serviceCode + "' AND B.ARG_MODE='F'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
							stmt = mConnection.createStatement();
							rs = stmt.executeQuery(query);
							if(rs.next())
							{
								argValue = rs.getString("ARG_VALUE"); //$NON-NLS-1$
							}
							/*--Commented and changed by Gulzar
							rs.close();
							stmt.close();
							*/
							if (rs != null)
							{
								rs.close();
								rs = null;
							}
							if (stmt != null)
							{
								stmt.close();
								stmt = null;
							}
						}
						else
						{
							throw new Exception("Invalid Service Code :["+serviceCode+"] in OBJ_ACTIONS Cannot be empty"); //$NON-NLS-1$ //$NON-NLS-2$
						}
					}
					/*
					if(actionType == null || (actionType != null && actionType.length() == 0))
					{
						actionType = "S";
					}
					isSysTypeOverwritten = ("S".equalsIgnoreCase(actionType))?true:isSysTypeOverwritten;*/
					//Changes By Ajinkya Gopalkar on 9-May-16[For creating action in View and Edit mode]
					//Changed done by Gaurav Singh on 23-AUG-2016 [ for resolving Action button issue ]
					//if ( strRights.indexOf(rightsChar) != -1  ||  ( strRights.indexOf("*") != -1 || strRights.indexOf("V") != -1 || strRights.indexOf("E") != -1 ) ) //$NON-NLS-1$
					if ( strRights.indexOf(rightsChar) != -1  || strRights.indexOf("*") != -1 )
					{

						JSONObject actionObj = new JSONObject();
						JSONObject serviceObjCon = new JSONObject();
						JSONObject serviceObj = new JSONObject();

					    BaseLogger.log("3", null, null,"going to construcct json of user rights");

						int enabled = -1;
						actionObj.put("formNo", formNo);
						actionObj.put("right_char", rightsChar);
						actionObj.put("enabled", enabled);
						actionObj.put("title", title);
						actionObj.put("interactive", interactive);
						actionObj.put("image", image);
						actionObj.put("action_type", actionType);
						actionObj.put("obj_context", formNo);
						actionObj.put("service_handler", serviceHandler);
						actionObj.put("placement", serviceHandler);
						actionObj.put("confirmation_req", confirmationReq);
						actionObj.put("sep_duty_opt", sepDutyOpt);
						actionObj.put("re_auth_opt", reAuthOpt);
						actionObj.put("showInPanel", showInPanel);
						actionObj.put("swipe_position", swipePos);
						actionObj.put("action_id", actionId);
						actionObj.put("multiRowOpt", multiRowOpt);
						actionObj.put("def_NoData", defNoData);
						actionObj.put("action_arg", actionArg);
						//Added By Pankaj T. on 03-01-19 added new column line_no for display links on homepage feed order by line_no - start
						actionObj.put("display_mode", displayMode);
						actionObj.put("show_confirm", showConfirm);
						actionObj.put("line_no", lineNo);
						//Added By Pankaj T. on 03-01-19 added new column line_no for display links on homepage feed order by line_no - end
						//Added by Pratheek on 24-06-19[ added new column rec_specific to get the record specific actions and links ]-Start
						actionObj.put("rec_specific", recordSpecific);
						//Added by Pratheek on 24-06-19[ added new column rec_specific to get the record specific actions and links ]-End

						actJsonArr.put(actionObj);

						BaseLogger.log("3", null, null,"actJsonArr in DBAccess WHICH IS EMPTY  "+actJsonArr );
						serviceObjCon.put("cmpType", compType);
						serviceObjCon.put("cmpName", compName);
						serviceObjCon.put("metName", methodName);
						serviceObjCon.put("argVal", argValue);

						actionObj.put("service_code" , serviceObjCon);
					}
				}
				  actionJson.put("action",actJsonArr);
                  BaseLogger.log("3", null, null,"action in DBAccess   "+actionJson );
				if (mRs != null)
				{
					mRs.close();
					mRs = null;
				}
				if (mStmt != null)
				{
					mStmt.close();
					mStmt = null;
				}
				allActJsonObj.put("ACTIONS", actionJson);
				BaseLogger.log("3", null, null,"allActJsonObj in DBAccess   "+allActJsonObj );
				allActJsonArr.put(allActJsonObj);
			}//if ( strRights != null && strRights.lenght() > 0)
			else
			{
				allActJsonArr.put("No rights defined");
				BaseLogger.log("3", null, null,"No rights defined for profileID ["+profileID + "] for OBJ_NAME [" +objName+"]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException: DBAccess: getAllActionsString:"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccess: getAllActionsString:"  + e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(mStmt != null)
					{
						mStmt.close();
						mStmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getAllActionsString \n" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("3", null, null,"Actions String============================\n"+allActJsonArr.toString()+"\n"); //$NON-NLS-1$ //$NON-NLS-2$
		return allActJsonArr.toString();

    }
	//ended by Chitranga Tandel on 12-march-2018 to get Actions in json format

	public ArrayList getMailDetailList(String formatCode, Connection conn)throws RemoteException, ITMException
	{
		BaseLogger.log("3", null, null,"[DBAccessEJB] :getMailDetails() 3919 for Format Code :"+formatCode); //$NON-NLS-1$
//		ConnDriver mConnDriver = null;
//		Connection mConnection = null;
		Statement stmt = null;
		ResultSet mRs = null;
		ResultSetMetaData rsmd = null;
		ArrayList mailDetailList = null;
		try
		{
//			mConnDriver = new ConnDriver();
//			mConnection = mConnDriver.getConnectDB(transDB); //$NON-NLS-1$

			String mQuery = "SELECT SEND_TO, COPY_TO, BLIND_COPY, SUBJECT, BODY_TEXT, ATTACH_TYPE FROM MAIL_FORMAT WHERE FORMAT_CODE = '"+formatCode+"'"; //$NON-NLS-1$ //$NON-NLS-2$
			stmt = conn.createStatement();
			mRs = stmt.executeQuery(mQuery);

			rsmd = mRs.getMetaData();
			int noOfCols = rsmd.getColumnCount();

			mailDetailList = new ArrayList();

			if (mRs.next())
			{
				String data = null;
				for (int ctr = 1; ctr <= noOfCols; ctr++)
				{
					data = mRs.getString(ctr);
					mailDetailList.add(data);
				}
			}
			stmt.close();
			stmt = null;
		}
		catch (Exception e)
		{
			System.err.println("Exception :DBAccessEJB :getMailDetails :\n"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return mailDetailList;
	}

	public String getEmailAddr(String selFieldName, String fromTableName, String whereFieldName, String whereFieldValue)throws RemoteException, ITMException
	{
		BaseLogger.log("3", null, null,"[DBAccessEJB]Getting email address from master table :["+fromTableName+"]: for ["+whereFieldName+"], ["+ whereFieldValue +"]"); //$NON-NLS-1$ //$NON-NLS-2$
		ConnDriver mConnDriver = null;
		Connection mConnection = null;
		Statement stmt = null;
		ResultSet mRs = null;
		String retEmailAddr = null;
		String transDB = "";
		try
		{
			mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver");
			//Commented and changed by Gulzar on 02/12/13 [] to passss 'Driver' instead of 'Driver':START
			//Commented and changed by Gulzar on 02/12/13 [] to passss 'Driver' instead of 'Driver':END

			//Changed By Rupali on 20/05/2008.[To add the Email ID into UserInfo].Request ID:-[BI78SUN047].Start
			//String mQuery = "SELECT " + selFieldName + " FROM " + fromTableName + " WHERE " + whereFieldName + " = '" + whereFieldValue + "'";
			String mQuery = ""; //$NON-NLS-1$
			whereFieldValue = checkNull( whereFieldValue );
			if(!whereFieldValue.endsWith("$")) //$NON-NLS-1$
			{

				mQuery = "SELECT " + selFieldName + " FROM " + fromTableName + " WHERE " + whereFieldName + " = '" + whereFieldValue + "'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
			}
			else
			{
				String userID = whereFieldValue.substring(0,whereFieldValue.indexOf("$")); //$NON-NLS-1$
				mQuery = "SELECT " + selFieldName + " FROM " + fromTableName + " WHERE " + whereFieldName + " = ( SELECT  ENTITY_CODE  FROM USERS WHERE CODE='" + userID + "')"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
			}
			//Changed By Rupali on 20/05/2008.[To add the Email ID into UserInfo].Request ID:-[BI78SUN047].End
			//	BaseLogger.log("3", null, null,"[DBAccessEJB]Query :"+mQuery);
			stmt = mConnection.createStatement();
			mRs = stmt.executeQuery(mQuery);

			if (mRs.next())
			{
				retEmailAddr = mRs.getString(1);
			}
			mRs.close();
			stmt.close();
			stmt = null;
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException :DBAccessEJB :getEmailAddr :\n"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception :DBAccessEJB :getEmailAddr :\n"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getMailDetails :\n"+e.getMessage()); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("3", null, null,"[DBAccessEJB]Returning email address :["+retEmailAddr+"]:"); //$NON-NLS-1$ //$NON-NLS-2$
		return retEmailAddr;
	}

	//	Changed by Dhruv on 02/08/2007to support mandatory flag default value differnet in case of all_rec fn.

	/*public String getAccFilt(String objName,String profileID)throws  RemoteException,ITMException
	{
		ConnDriver mConnDriver = null;
		Connection mConnection = null;
		Statement mStmt = null;
		ResultSet mRs = null;
		//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
		//String accFilt = null;
		String multiAccFilt = "";
		String  mQuery = null;
		try
		{
			mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver"); //$NON-NLS-1$
			//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
			//mQuery = "SELECT ACC_FILT FROM USER_RIGHTS WHERE PROFILE_ID ='" + profileID + "'" + " AND OBJ_NAME ='"+objName+"'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			mQuery = "SELECT ACC_FILT FROM USER_RIGHTS WHERE PROFILE_ID IN " + E12GenericUtility.getFormattedProfileId(profileID) + " AND OBJ_NAME ='"+objName+"'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			//BaseLogger.log("3", null, null,"[DBACCESSEJB]getAccFilt:query:\n"+mQuery);
			mStmt = mConnection.createStatement();
			mRs = mStmt.executeQuery(mQuery);
			while(mRs.next())
			{
				String accFilt = mRs.getString("ACC_FILT"); //$NON-NLS-1$
				//Added by Sagar B. for multiple profile id related changes[11-Dec-17]
				multiAccFilt = multiAccFilt + "(" + accFilt + ") AND ";
			}
			mRs.close();
			mRs = null;
			mStmt.close();
			mStmt = null;
			//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]START
//			if (accFilt == null || accFilt.equals("")) //$NON-NLS-1$
//			{
//				accFilt = ""; //$NON-NLS-1$
//			}
//			else
//			{
//				accFilt = "AND " + accFilt; //$NON-NLS-1$
//			}
			if (multiAccFilt == null || multiAccFilt.equals("")) //$NON-NLS-1$
			{
				multiAccFilt = ""; //$NON-NLS-1$
			}
			else
			{
				multiAccFilt = multiAccFilt.substring( 0, multiAccFilt.lastIndexOf(" AND ") );
				multiAccFilt = "AND " + multiAccFilt; //$NON-NLS-1$
			}
			//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]END
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException: DBAccess: getAccFilt:"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccess: getAccFilt:"  + e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(mStmt != null)
					{
						mStmt.close();
						mStmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getAccFilt \n" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		//return accFilt;
		return multiAccFilt;
	}*/

	/*public String saveDraftObject(String user_id, String objName, int draftLineNo, java.sql.Date create_date, java.sql.Date mod_date, char status, String sharing, String editDomData)throws RemoteException,ITMException
	{
		//Added By Prajyot on 9/JAN/2013 [To commit local connection]
		boolean isError = false;

		Connection mConnection = null;
		PreparedStatement mPstmt = null;
		Statement stat = null;
		ResultSet mRs = null;
		String  mInsStat = null;
		try
		{
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver"); //$NON-NLS-1$
			stat = mConnection.createStatement();
			ResultSet tranRS = stat.executeQuery("SELECT COUNT(*) FROM DRAFT_OBJECTS WHERE USER_ID = '" + user_id + "' AND OBJ_NAME = '" + objName +"' AND LINE_NO = " + draftLineNo); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			boolean isExists = false;
			if(tranRS.next())
			{
				isExists = (tranRS.getInt(1) > 0)?true:false;
			}
			tranRS.close();
			tranRS = null;
			stat.close();
			stat=null;
			byte editData [] = editDomData.getBytes();
			if(isExists)
			{
				BaseLogger.log("3", null, null,"Updating draft XML data........"); //$NON-NLS-1$
				mInsStat = "UPDATE DRAFT_OBJECTS SET EDIT_XML_DATA = ? WHERE USER_ID = ? AND  OBJ_NAME = ? AND LINE_NO = ?"; //$NON-NLS-1$
				mPstmt = mConnection.prepareStatement(mInsStat);
				mPstmt.setBytes(1, editData);
				mPstmt.setString(2, user_id);
				mPstmt.setString(3, objName);
				mPstmt.setInt(4, draftLineNo);
			}
			else
			{
				BaseLogger.log("3", null, null,"Inserting new draft XML data........"); //$NON-NLS-1$
				stat = mConnection.createStatement();
				tranRS = stat.executeQuery("SELECT COUNT(*) FROM DRAFT_OBJECTS WHERE USER_ID = '" + user_id + "' AND OBJ_NAME = '" + objName +"'"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				if(tranRS.next())
				{
					draftLineNo = tranRS.getInt(1);
					draftLineNo++;
				}
				stat.close();
				stat=null;
				BaseLogger.log("3", null, null,"New draft line no :"+draftLineNo); //$NON-NLS-1$
				mInsStat = "INSERT INTO DRAFT_OBJECTS (USER_ID, OBJ_NAME, LINE_NO, TITLE, CREATE_DATE, MOD_DATE, STATUS, SHARING, EDIT_XML_DATA) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)"; //$NON-NLS-1$

				mPstmt = mConnection.prepareStatement(mInsStat);
				mPstmt.setString(1, user_id);
				mPstmt.setString(2, objName);
				mPstmt.setInt(3, draftLineNo);
				mPstmt.setString(4, objName.toUpperCase()+draftLineNo);
				mPstmt.setDate(5, create_date);
				mPstmt.setDate(6, mod_date);
				mPstmt.setString(7, String.valueOf(status));
				mPstmt.setString(8, sharing);
				mPstmt.setBytes(9, editData);
			}
			BaseLogger.log("3", null, null,"EDIT DRAFT DATA :\n\n\n\n\n"+new String(editData)+"\n\n\n\n\n"); //$NON-NLS-1$ //$NON-NLS-2$
			BaseLogger.log("3", null, null,"Executing Draft Insert Query"); //$NON-NLS-1$
			mPstmt.executeUpdate();
			tranRS.close();
			tranRS = null;
			mPstmt.close();
			mPstmt = null;
			BaseLogger.log("3", null, null,"Draft data inserted..............."); //$NON-NLS-1$
		}
		catch (ITMException itme)
		{
			//Added By Prajyot on 9/JAN/2013 [To commit local connection]
			isError = true;

			System.err.println("ITMException: DBAccess: saveToDraftObjects:"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			//Added By Prajyot on 9/JAN/2013 [To commit local connection]
			isError = true;

			System.err.println("Exception: DBAccess: saveToDraftObjects:"  + e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(stat != null)
					{
						stat.close();
						stat = null;
					}
					if(mPstmt != null)
					{
						mPstmt.close();
						mPstmt = null;
					}

					//Added By Prajyot on 9/JAN/2013 [To commit local connection]
					if( !isError )
					{
						mConnection.commit();
					}
					else
					{
						mConnection.rollback();
					}

					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getActionTitlesList \n" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		return "Done"; //$NON-NLS-1$
	}*/

	/*public String getAllDraftInfoString(String userID, String objName)throws RemoteException,ITMException
	{
		Connection mConnection = null;
		Statement mStmt = null;
		ResultSet mRs = null;
		ResultSetMetaData rsmd = null;
		String  mQuery = null;
		String retXMLStr = null;
		try
		{
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver"); //$NON-NLS-1$

			StringBuffer xmlStringBuff = new StringBuffer();

			//			BaseLogger.log("3", null, null,"userID :"+userID+":");
			//			BaseLogger.log("3", null, null,"objName :"+objName+":");

			mQuery = "SELECT LINE_NO, TITLE FROM DRAFT_OBJECTS WHERE USER_ID = '"+userID+"' AND OBJ_NAME = '"+objName+"'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			//BaseLogger.log("3", null, null,"mQuery :"+mQuery);
			mStmt = mConnection.createStatement();
			mRs = mStmt.executeQuery(mQuery);
			rsmd = mRs.getMetaData();
			int noOfCols = rsmd.getColumnCount();
			while(mRs.next())
			{
				String data = null;
				StringBuffer dataBuff = new StringBuffer();

				dataBuff.append("<Detail id=''>\n"); //$NON-NLS-1$
				for (int i = 1; i <= noOfCols; i++)
				{
					data = mRs.getString(i);
					if(data == null)
					{
						data = ""; //$NON-NLS-1$
					}
					dataBuff.append("<"+(String)rsmd.getColumnName(i)+"><![CDATA["+data+"]]></"+(String)rsmd.getColumnName(i)+">\n"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				}
				dataBuff.append("</Detail>\n"); //$NON-NLS-1$
				xmlStringBuff.append(dataBuff);
			}
			mRs.close();
			mRs = null;
			mStmt.close();
			mStmt = null;
			BaseLogger.log("3", null, null,"All draft info string :"+xmlStringBuff.toString()); //$NON-NLS-1$
			retXMLStr = getNormalizeString(xmlStringBuff.toString());
		}
		catch (ITMException itme)
		{
			BaseLogger.log("3", null, null,"ITMException :DBAccessEJB :getAllDraftInfoString :"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			BaseLogger.log("3", null, null,"Exception :DBAccessEJB :getAllDraftInfoString :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(mStmt != null)
					{
						mStmt.close();
						mStmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getDraftObjectXMLString :"+e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		return retXMLStr;
	}*/

	/*public String getDraftEditXml(String user, String objName, int draftLineNo)throws RemoteException,ITMException
	{
		//	BaseLogger.log("3", null, null,"Getting Draft data for obj name :" + objName + "draftLineNo :" + draftLineNo + " and User :"+user);
		Connection mConnection = null;
		PreparedStatement mPstmt = null;
		ResultSet mRs = null;
		String  mQuery = null;
		byte byteDraftEditXml[] = new byte[1];
		StringBuffer retDraftEditXmlBuff = new StringBuffer();

		try
		{
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver"); //$NON-NLS-1$
			StringBuffer addWhereClauseBuff = new StringBuffer();
			boolean isDraftId = false;
			if(draftLineNo != -1)
			{
				isDraftId = true;
				addWhereClauseBuff.append(" AND LINE_NO = ").append("?"); //$NON-NLS-1$ //$NON-NLS-2$
			}
			boolean isObjName = false;
			if(objName != null && objName.length() > 0)
			{
				isObjName = true;
				addWhereClauseBuff.append(" AND OBJ_NAME = ").append("?"); //$NON-NLS-1$ //$NON-NLS-2$
			}

			mQuery = "SELECT EDIT_XML_DATA FROM DRAFT_OBJECTS WHERE USER_ID = ?" + addWhereClauseBuff.toString(); //$NON-NLS-1$

			mPstmt = mConnection.prepareStatement(mQuery);
			mPstmt.setString(1, user);
			if(isDraftId)
			{
				mPstmt.setInt(2, draftLineNo);
			}
			if(isObjName)
			{
				if(!isDraftId)
				{
					mPstmt.setString(2, objName);
				}
				else
				{
					mPstmt.setString(3, objName);
				}
			}
			//BaseLogger.log("3", null, null,"Executing Query(for draft data ) :"+mQuery);
			mRs = mPstmt.executeQuery();

			ArrayList draftStrList = new ArrayList();

			while(mRs.next())
			{
				BaseLogger.log("3", null, null,"Got a value..............."); //$NON-NLS-1$
				draftStrList.add(mRs.getBlob(1));
			}
			mRs.close();
			mRs = null;
			java.sql.Blob dbBlob = null;
			BaseLogger.log("3", null, null,"draftStrList.size() :"+draftStrList.size()); //$NON-NLS-1$
			for(int ctr = 0; ctr < draftStrList.size(); ctr++)
			{
				dbBlob = (java.sql.Blob)draftStrList.get(ctr);
				if (dbBlob != null)
				{
					BaseLogger.log("3", null, null,"DB Blob length :"+dbBlob.length()+":"); //$NON-NLS-1$ //$NON-NLS-2$
					long start = 1;
					byte[] b = dbBlob.getBytes(start, (int)dbBlob.length());
					//BaseLogger.log("3", null, null,"Byte version Length :"+b.length+":");
					//BaseLogger.log("3", null, null,"String version of DB Blob :"+new String(b)+":");
					retDraftEditXmlBuff.append(new String(b));
				}
			}
		}
		catch (ITMException itme)
		{
			BaseLogger.log("3", null, null,"ITMException: DBAccess: getDraftEditXml :"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			BaseLogger.log("3", null, null,"Exception: DBAccess: getDraftEditXml :" + e); //$NON-NLS-1$
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(mPstmt != null)
					{
						mPstmt.close();
						mPstmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getDraftEditXml :" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		//BaseLogger.log("3", null, null,"retDraftEditXmlBuff.toString() :"+retDraftEditXmlBuff.toString());
		return retDraftEditXmlBuff.toString();
	}*/

	private String getNormalizedString(String nodeString)throws ITMException
	{
		StringBuffer tempStringBuff = new StringBuffer();
		try
		{
			tempStringBuff.append("<DocumentRoot>"); //$NON-NLS-1$
			tempStringBuff.append("<description>Datawindow Root</description>"); //$NON-NLS-1$
			tempStringBuff.append("<group0>"); //$NON-NLS-1$
			tempStringBuff.append("<description>Group0 description</description>"); //$NON-NLS-1$
			tempStringBuff.append("<Header0>"); //$NON-NLS-1$
			tempStringBuff.append("<description>Header0 members</description>"); //$NON-NLS-1$

			tempStringBuff.append(nodeString);

			tempStringBuff.append("</Header0>"); //$NON-NLS-1$
			tempStringBuff.append("</group0>"); //$NON-NLS-1$
			tempStringBuff.append("</DocumentRoot>"); //$NON-NLS-1$
		}
		catch(Exception e)
		{
			BaseLogger.log("3", null, null,"Exception :MasterStatefulEJB :getNormalizedString :==>\n"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return tempStringBuff.toString();
	}

	/*public String getDraftXSLFName(String user, String objName, int draftLineNo, String pageContext)throws RemoteException, ITMException
	{
		String xslFileName = null;
		Connection mConnection = null;
		PreparedStatement mPstmt = null;
		ResultSet mRs = null;
		String  mQuery = null;
		String fieldName = "EDIT_XSL_FNAME"; //$NON-NLS-1$

		try
		{
			if(pageContext != null && pageContext.equalsIgnoreCase("1")) //$NON-NLS-1$
			{
				fieldName = "BROW_XSL_FNAME"; //$NON-NLS-1$
			}
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver"); //$NON-NLS-1$

			StringBuffer addWhereClauseBuff = new StringBuffer();
			boolean isDraftId = false;
			if(draftLineNo != -1)
			{
				isDraftId = true;
				addWhereClauseBuff.append(" AND LINE_NO = ").append("?"); //$NON-NLS-1$ //$NON-NLS-2$
			}
			boolean isObjName = false;
			if(objName != null && objName.length() > 0)
			{
				isObjName = true;
				addWhereClauseBuff.append(" AND OBJ_NAME = ").append("?"); //$NON-NLS-1$ //$NON-NLS-2$
			}

			mQuery = "SELECT "+ fieldName +" FROM DRAFT_OBJECTS WHERE USER_ID = ?" + addWhereClauseBuff.toString(); //$NON-NLS-1$ //$NON-NLS-2$

			mPstmt = mConnection.prepareStatement(mQuery);

			mPstmt.setString(1, user);
			if(isDraftId)
			{
				mPstmt.setInt(2, draftLineNo);
			}
			if(isObjName)
			{
				if(!isDraftId)
				{
					mPstmt.setString(2, objName);
				}
				else
				{
					mPstmt.setString(3, objName);
				}
			}
			BaseLogger.log("3", null, null,"Executing Query(for draft xsl for page context - "+pageContext+") :"+mQuery); //$NON-NLS-1$ //$NON-NLS-2$
			mRs = mPstmt.executeQuery();
			if(mRs.next())
			{
				xslFileName = mRs.getString(1);
			}
			mRs.close();
			mRs = null;
			if(xslFileName != null && !xslFileName.endsWith(".xsl")) //$NON-NLS-1$
			{
				xslFileName += ".xsl"; //$NON-NLS-1$
			}
		}
		catch (ITMException itme)
		{
			BaseLogger.log("3", null, null,"ITMException: DBAccess: getDraftXSLFName :"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			BaseLogger.log("3", null, null,"Exception: DBAccess: getDraftXSLFName :" + e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(mPstmt != null)
					{
						mPstmt.close();
						mPstmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getDraftXSLFName :" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("3", null, null,"Returning Draft XSL file name :"+xslFileName); //$NON-NLS-1$
		return xslFileName;
	}*/

	/*public boolean deleteDraftObject(String draftID)throws RemoteException, ITMException
	{
		BaseLogger.log("3", null, null,"[DBAccessEJB]Deleting draft object for draftID :"+draftID+":"); //$NON-NLS-1$ //$NON-NLS-2$
		Connection mConnection = null;
		Statement stmt = null;
		boolean isDelDraft = false;
		try
		{
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver"); //$NON-NLS-1$
			String query = "DELETE FROM DRAFT_OBJECTS WHERE DRAFT_ID = '"+draftID+"'"; //$NON-NLS-1$ //$NON-NLS-2$
			stmt = mConnection.createStatement();

			BaseLogger.log("3", null, null,"Executing Draft Delete Query ........."); //$NON-NLS-1$
			int deleteCnt = stmt.executeUpdate(query);
			if (deleteCnt > 0)
			{
				isDelDraft = true;
				BaseLogger.log("3", null, null,"Draft object deleted !!!!!!!!!!!!!!!!"); //$NON-NLS-1$
			}
			stmt.close();
			stmt = null;
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException: DBAccess: saveToDraftObjects:"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccess: saveToDraftObjects:"  + e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getActionTitlesList \n" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		return isDelDraft;
	}*/

	//Changed by Danish on 07/05/2007
	//public HashMap getRowSecurityInfoMap( String userLevel, String userType, String objName, String entityCode, String siteCode, String profileId )throws RemoteException, ITMException
	public HashMap getRowSecurityInfoMap( String objName, String userInfoStr)throws RemoteException, ITMException
	{
		BaseLogger.log("3", null, null, "[DBAccessEJB]In getRowSecurityInfoMap............." ); //$NON-NLS-1$
		//StringBuffer rowSecurityStrBuff = new StringBuffer();
		HashMap rowSecurityInfo = null;
		Connection con = null;
		Statement stmt = null;
		String transDB = "";
		try
		{
			UserInfoBean usrInfo = new UserInfoBean( userInfoStr );
			ConnDriver conDriver = new ConnDriver();
			// Added By Arvind on 18-12-13 to support multiDB connection : START
			transDB = usrInfo.getTransDB();
			BaseLogger.log("3", null, null,"getRowSecurityInfoMap...TransDB"+transDB);
			if ( transDB != null && !"null".equalsIgnoreCase(transDB) && transDB.trim().length() > 0 )
			{
				con = conDriver.getConnectDB( transDB ); //$NON-NLS-1$
			}

			// Added By Arvind on 18-12-13 to support multiDB connection : END

			//Changed by Danish on 07/05/2007 Start
			String userLevel = usrInfo.getUserLevel();
			String userType = usrInfo.getUserType();
			String entityCode = usrInfo.getEntityCode();
			String siteCode = usrInfo.getSiteCode();
			String profileId = usrInfo.getProfileId();
			//Changed by Danish on 07/05/2007 End

			//SITE_ACC_COL,ITEM_SER_ACC_COL these values not to be set from here
			String sql = "SELECT SITE_ACC_COL,SALES_PERS_ACC_COL,CUST_ACC_COL,SUPP_ACC_COL,ITEM_SER_ACC_COL,EMP_ACC_COL,TABLE_NAME FROM TRANSETUP WHERE TRAN_WINDOW='w_" + objName+"'"; //$NON-NLS-1$ //$NON-NLS-2$
			stmt = con.createStatement();
			ResultSet rs = stmt.executeQuery(sql);
			String site_acc_col = null;
			String sales_pers_acc_col = null;
			String cust_acc_col = null;
			String supp_acc_col = null;
			String item_ser_acc_col = null;
			String emp_acc_col = null;
			String mainTableName = null;

			if( rs.next() )
			{
				site_acc_col = rs.getString( "SITE_ACC_COL" ); //$NON-NLS-1$

				sales_pers_acc_col = rs.getString( "SALES_PERS_ACC_COL" ); //$NON-NLS-1$

				cust_acc_col = rs.getString( "CUST_ACC_COL" ); //$NON-NLS-1$

				supp_acc_col = rs.getString( "SUPP_ACC_COL" ); //$NON-NLS-1$

				item_ser_acc_col = rs.getString( "ITEM_SER_ACC_COL" ); //$NON-NLS-1$

				emp_acc_col = rs.getString( "EMP_ACC_COL" ); //$NON-NLS-1$

				mainTableName = rs.getString( "TABLE_NAME" ); //$NON-NLS-1$

				String focussedColumn = ""; //$NON-NLS-1$
				String itemSer = ""; //$NON-NLS-1$
				String condn = ""; //$NON-NLS-1$
				rowSecurityInfo = new HashMap();
				/*BaseLogger.log("3", null, null, "[DBAccessEJB]User Type :[" + userType + "]" );
				BaseLogger.log("3", null, null, "[DBAccessEJB]User Level :[" + userLevel + "]" );
				BaseLogger.log("3", null, null, "[DBAccessEJB]Main Table Name :[" + mainTableName + "]" );
				BaseLogger.log("3", null, null, "[DBAccessEJB]site_acc_col :[" + site_acc_col + "]" );
				BaseLogger.log("3", null, null, "[DBAccessEJB]cust_acc_cuserTypeol :[" + cust_acc_col + "]" );
				BaseLogger.log("3", null, null, "[DBAccessEJB]supp_acc_col :[" + supp_acc_col + "]" );
				BaseLogger.log("3", null, null, "[DBAccessEJB]item_ser_acc_col :[" + item_ser_acc_col + "]" );
				BaseLogger.log("3", null, null, "[DBAccessEJB]emp_acc_col :[" + emp_acc_col + "]" );*/
				if ( userType != null )
				{
					//if site has value then append AND SITE_CODE TO YOUR ROW SECURITY
					if( Integer.parseInt( userLevel ) > 1 && mainTableName != null && site_acc_col != null && site_acc_col.trim().length() > 0 )
					{
						//Changed by Dhruv on 10/11/2006 to handle case where SITE_CODE not in main table.
						if( site_acc_col.indexOf( "." ) != -1 ) //$NON-NLS-1$
						{
							condn = site_acc_col + "='" + siteCode + "'"; //$NON-NLS-1$ //$NON-NLS-2$
						}
						else
						{
							condn = mainTableName + "." + site_acc_col + " = '" + siteCode + "'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						}
						BaseLogger.log("3", null, null, "[DBAccessEJB]Adding filter for site_acc_col :[" + site_acc_col + "]" ); //$NON-NLS-1$ //$NON-NLS-2$
						rowSecurityInfo.put( mainTableName, condn );
					}
					if( ( userType.trim().equalsIgnoreCase( "P" ) ) && ( sales_pers_acc_col != null && sales_pers_acc_col.length() > 0 ) ) //$NON-NLS-1$
					{
						focussedColumn = sales_pers_acc_col.trim();
						//Changed by Danish on 08/01/2007
						//Changed by Dhruv on 02/05/2007 to handle case where emp_code not in main table.
						//condn = mainTableName + "." + focussedColumn + "='" + entityCode + "'";
						if( sales_pers_acc_col.indexOf( "." ) != -1 ) //$NON-NLS-1$
						{
							condn = sales_pers_acc_col + "='" + entityCode + "'"; //$NON-NLS-1$ //$NON-NLS-2$
						}
						else
						{
							condn = mainTableName + "." + sales_pers_acc_col + " = '" + entityCode + "'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						}
						BaseLogger.log("3", null, null, "[DBAccessEJB]Adding filter for sales_pers_acc_col :[" + sales_pers_acc_col + "]" ); //$NON-NLS-1$ //$NON-NLS-2$
						rowSecurityInfo.put( mainTableName, condn );

						if( ( item_ser_acc_col != null && item_ser_acc_col.length() > 0 ) )
						{
							itemSer = item_ser_acc_col.trim();
							condn = " SALES_PERS.ITEM_SER=" + mainTableName + "." + itemSer + " AND SALES_PERS.SALES_PERS="+mainTableName+"."+focussedColumn+" AND SALES_PERS.SALES_PERS='" + entityCode +"'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
							//rowSecurityInfo.put( "SALES_PERS", condn );
						}
					}
					else if( ( userType.trim().equalsIgnoreCase( "C" ) ) && ( cust_acc_col != null && cust_acc_col.length() > 0 ) ) //$NON-NLS-1$
					{
						focussedColumn = cust_acc_col.trim();
						//Changed by Swapnil 15/06/2010 starts
						condn = mainTableName + "."+focussedColumn + " = '" + entityCode + "'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						BaseLogger.log("3", null, null,"[DBAccessEJB]getRowSecurityInfoMap Condition : "+condn); //$NON-NLS-1$
						rowSecurityInfo.put( mainTableName, condn );
						//Changed by Swapnil 15/06/2010 ends
					}
					else if( ( userType.trim().equalsIgnoreCase( "S" ) ) && ( supp_acc_col != null && supp_acc_col.length() > 0 ) ) //$NON-NLS-1$
					{
						focussedColumn = supp_acc_col.trim();
						//Changed By Prajyot on 05-JUN-2015 [Entity Contact Details for SSP] Starts
						//condn = mainTableName + "."+focussedColumn + " = '" + entityCode + "'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						if( ifEntityContactsExists( usrInfo ) )
						{
							condn = mainTableName + "."+focussedColumn + " IN ( SELECT ENTITY_CODE FROM ENTITY_CONTACT WHERE USER_ID__PORTAL = '"+ usrInfo.getLoginCode() +"' AND ENTITY_TYPE = 'S' ) ";
						}
						else
						{
							condn = mainTableName + "."+focussedColumn + " = '" + entityCode + "'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						}
						BaseLogger.log("3", null, null,"[DBAccessEJB]getRowSecurityInfoMap Condition USER TYPE = S: "+condn); //$NON-NLS-1$
						//Changed By Prajyot on 05-JUN-2015 [Entity Contact Details for SSP] End
						rowSecurityInfo.put( mainTableName, condn );
					}
					else if( ( userType.trim().equalsIgnoreCase( "E" ) ) && ( emp_acc_col != null && emp_acc_col.length() > 0 ) ) //$NON-NLS-1$
					{
						focussedColumn = emp_acc_col.trim();
						if( ( item_ser_acc_col != null && item_ser_acc_col.length() >0 ) )
						{
							itemSer = item_ser_acc_col.trim();
						}
						//Changed by Dhruv on 03/03/2007 to handle case where emp_code not in main table.
						if( emp_acc_col.indexOf( "." ) != -1 ) //$NON-NLS-1$
						{
							condn = emp_acc_col + "='" + entityCode + "'"; //$NON-NLS-1$ //$NON-NLS-2$
						}
						else
						{
							condn = mainTableName + "." + emp_acc_col + " = '" + entityCode + "'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						}
						BaseLogger.log("3", null, null, "[DBAccessEJB]Adding filter for emp_acc_col :[" + emp_acc_col + "]" ); //$NON-NLS-1$ //$NON-NLS-2$
						rowSecurityInfo.put( mainTableName, condn );
					}
				}
			}
			rs.close();
			rs = null;
			stmt.close();
			stmt = null;
			//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
			//PreparedStatement pstmt = con.prepareStatement( "SELECT ACC_FILT FROM USER_RIGHTS WHERE PROFILE_ID =? AND OBJ_NAME=?" ); //$NON-NLS-1$
			PreparedStatement pstmt = con.prepareStatement( "SELECT ACC_FILT FROM USER_RIGHTS WHERE PROFILE_ID IN "+ E12GenericUtility.getFormattedProfileId(profileId)+" AND OBJ_NAME=?" ); //$NON-NLS-1$
			//Changed by Monif on 6/27/2008 [To remove OraclePreparedStatement ].Start
			//Changed by Danish on 19/03/2007 start
			//pstmt.setString( 1, profileId );
			//pstmt.setString( 2, objName );
			/*if ( CommonConstants.DB_NAME.equalsIgnoreCase("oracle") )
			{
				( ( OraclePreparedStatement ) pstmt).setFixedCHAR( 1, profileId );
				( ( OraclePreparedStatement ) pstmt).setFixedCHAR( 2, objName );
			}
			else
			{
				pstmt.setString( 1, profileId );
				pstmt.setString( 2, objName );
			}*/
			//Changed by Danish on 19/03/2007 end
			//pstmt.setString( 1, profileId );
			pstmt.setString( 1, objName );
			//Changed by Monif on 6/27/2008 [To remove OraclePreparedStatement ].End
			rs = pstmt.executeQuery();
			String multiAccFilt = "";
			//if( rs.next() )
			while( rs.next() )
			{
				String accFilt = rs.getString( "ACC_FILT" ); //$NON-NLS-1$
				if( accFilt != null && accFilt.length() > 0 )
				{
					//Changed by Danish on 07/05/2007 Start
					//"loginEmpCode","loginSiteCode","entityCode","profileId","userType","runMode","user_lang","user_country","charEnc"
					ArrayList userConstList = new ArrayList();
					userConstList.add("entityCode"); //$NON-NLS-1$
					userConstList.add("profileId"); //$NON-NLS-1$
					userConstList.add("userType"); //$NON-NLS-1$
					userConstList.add("userLevel"); //$NON-NLS-1$
					//Added by sanjaya for pass following codes for filter in brow window[03/DEC/13,WS3ISUN001]--Start--
					userConstList.add("loginCode"); // LoginCode is changed to loginCode by AMit D on 13 th Dec 13
					userConstList.add("LOGIN_SITE");
					userConstList.add("empCode");
					userConstList.add("deptCode");
					userConstList.add("itemSer");
					userConstList.add("isBiUser");
					userConstList.add("stanCode");
					userConstList.add("designation");
					userConstList.add("division");
					//Added by sanjaya for pass following codes for filter in brow window[03/DEC/13,WS3ISUN001]--End--

					for (int i = 0; i < userConstList.size() ; i++)
					{
						String currElement  = ( String ) userConstList.get(i);
						while ( accFilt.indexOf( "<"+currElement+">" ) != -1 ) //$NON-NLS-1$ //$NON-NLS-2$
						{
							StringBuffer accFiltBuff = new StringBuffer( accFilt );
							accFiltBuff.replace( accFilt.indexOf( currElement ) - 1 , ( accFilt.indexOf( currElement ) + currElement.length()+1 ), usrInfo.getPropValue(currElement) );
							accFilt = accFiltBuff.toString();
						}
					}
					//Changed by Danish on 07/05/2007 End

					multiAccFilt = multiAccFilt + "(" + accFilt + ") AND ";
					//rowSecurityInfo.put( "ACC_FILT", accFilt ); //$NON-NLS-1$
				}
			}
			if( multiAccFilt.length() > 0 )
			{
				multiAccFilt = multiAccFilt.substring( 0, multiAccFilt.lastIndexOf(" AND ") );
				rowSecurityInfo.put( "ACC_FILT", multiAccFilt ); //$NON-NLS-1$
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		}
		catch ( ITMException itme )
		{
			System.err.println("ITMException: DBAccess: getRowSecurityInfoMap:"); //$NON-NLS-1$
			throw itme;
		}
		catch ( Exception e )
		{
			BaseLogger.log("3", null, null,"Exception :DBAccessEJB :getRowSecurityInfoMap :==>"); //$NON-NLS-1$
			throw new ITMException( e );
		}
		finally
		{
			try
			{
				if( con != null )
				{
					if( stmt != null )
					{
						stmt.close();
						stmt = null;
					}
					con.close();
					con = null;
				}
			}
			catch (Exception e)
			{
				BaseLogger.log("3", null, null,"Exception :DBAccessEJB :getRowSecurityInfoMap :finally==>"); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("3", null, null, "[DBAccessEJB]rowSecurityInfo :\n"+rowSecurityInfo ); //$NON-NLS-1$
		return rowSecurityInfo;
	}

	public void registerReport( HashMap menuEntryMap ) throws RemoteException,ITMException//Milind
	{
		//Added By Prajyot on 9/JAN/2013 [To commit local connection]
		boolean isError = false;

		Connection con = null;
		PreparedStatement pStmt = null;
		int levelNo ;
		try
		{
			ConnDriver connDriver = new ConnDriver();
			con = connDriver.getConnectDB( "Driver" ); //$NON-NLS-1$
			String qry = "INSERT INTO ITM2MENU( APPLICATION,LEVEL_1,LEVEL_2,LEVEL_3,LEVEL_4,LEVEL_5,WIN_NAME,DESCR,COMMENTS,	MENU_PATH,ICON_PATH,OBJ_TYPE ) "+ //$NON-NLS-1$
					"VALUES (?,?,?,?,?,?,?,?,?,?,?,?)"; //$NON-NLS-1$
			pStmt = con.prepareStatement( qry );
			pStmt.setString( 1, menuEntryMap.get( "application" ).toString() ); //$NON-NLS-1$
			levelNo = Integer.parseInt( menuEntryMap.get( "level1" ).toString()); //$NON-NLS-1$
			pStmt.setInt( 2, levelNo );
			levelNo = Integer.parseInt( menuEntryMap.get( "level2" ).toString()); //$NON-NLS-1$
			pStmt.setInt( 3, levelNo );
			levelNo = Integer.parseInt( menuEntryMap.get( "level3" ).toString()); //$NON-NLS-1$
			pStmt.setInt( 4, levelNo );
			levelNo = Integer.parseInt( menuEntryMap.get( "level4" ).toString()); //$NON-NLS-1$
			pStmt.setInt( 5, levelNo );
			levelNo = Integer.parseInt( menuEntryMap.get( "level5" ).toString()); //$NON-NLS-1$
			pStmt.setInt( 6, levelNo );
			pStmt.setString( 7, menuEntryMap.get( "winName" ).toString() );  //$NON-NLS-1$
			pStmt.setString( 8, menuEntryMap.get( "descr" ).toString() ); //$NON-NLS-1$
			pStmt.setString( 9, null );
			pStmt.setString( 10, menuEntryMap.get( "menuPath" ).toString()); //$NON-NLS-1$
			pStmt.setString( 11, "itm_logo.ico" ); //$NON-NLS-1$
			pStmt.setString( 12, "R" ); //$NON-NLS-1$

			pStmt.executeUpdate();
			BaseLogger.log("3", null, null,"Itm2menu Entry completed"); //$NON-NLS-1$
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
		}
		catch(Exception e )
		{
			//Added By Prajyot on 9/JAN/2013 [To commit local connection]
			isError = true;

			System.err.println("Exception :DBAccessEJB :registerReport :\n"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(con != null)
				{
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}

					//Added By Prajyot on 9/JAN/2013 [To commit local connection]
					if( !isError )
					{
						con.commit();
					}
					else
					{
						con.rollback();
					}
					con.close();

					con = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :registerReport :\n"+e.getMessage()); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
	}

	public String checkMenuPath( HashMap menuEntryMap ) throws RemoteException,ITMException //Milind
	{
		BaseLogger.log("3", null, null,"To Check menu Path"); //$NON-NLS-1$
		Connection con = null;
		ResultSet rs = null;
		PreparedStatement pStmt = null;
		String returnValue = null;
		int levelNo ;
		try
		{
			ConnDriver connDriver = new ConnDriver();
			con = connDriver.getConnectDB("Driver"); //$NON-NLS-1$
			String qry = "SELECT WIN_NAME FROM ITM2MENU WHERE APPLICATION=? AND LEVEL_1=? AND LEVEL_2=? AND LEVEL_3=? AND LEVEL_4=? AND LEVEL_5=?"; //$NON-NLS-1$
			pStmt = con.prepareStatement(qry);
			pStmt.setString(1, menuEntryMap.get("application").toString()); //$NON-NLS-1$
			levelNo = Integer.parseInt( menuEntryMap.get("level1").toString()); //$NON-NLS-1$
			pStmt.setInt(2,levelNo);
			levelNo = Integer.parseInt( menuEntryMap.get("level2").toString()); //$NON-NLS-1$
			pStmt.setInt(3,levelNo);
			levelNo = Integer.parseInt( menuEntryMap.get("level3").toString()); //$NON-NLS-1$
			pStmt.setInt(4,levelNo);
			levelNo = Integer.parseInt( menuEntryMap.get("level4").toString()); //$NON-NLS-1$
			pStmt.setInt(5,levelNo);
			levelNo = Integer.parseInt( menuEntryMap.get("level5").toString()); //$NON-NLS-1$
			pStmt.setInt(6,levelNo);

			rs = pStmt.executeQuery();
			if( rs.next())
			{
				return "Invalid"; //$NON-NLS-1$
			}

			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
		}
		catch(Exception e )
		{
			System.err.println("Exception :DBAccessEJB :checkMenuPath :\n"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(con != null)
				{
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
					con = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :checkMenuPath :\n"+e.getMessage()); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		return "Valid"; //$NON-NLS-1$
	}

	/**
	 * This methos will be used to update blob value while inserting data in AuditTrail table in oracle database
	 * @param Connection con, String query, String dataStr, ArrayList bindVarValues, ArrayList bindVarTypes
	 * @return boolean updStatus
	 * @throws RemoteException
	 * @throws ITMException
	 */
	public boolean updateBlob(Connection con, String query, String dataStr, ArrayList bindVarValues, ArrayList bindVarTypes) throws RemoteException, ITMException
	{
		BaseLogger.log("3", null, null,"query ["+query+"]");
		BaseLogger.log("3", null, null,"bindVarTypes ["+bindVarTypes+"]"); //$NON-NLS-1$ //$NON-NLS-2$
		BaseLogger.log("3", null, null,"bindVarValues ["+bindVarValues+"]"); //$NON-NLS-1$ //$NON-NLS-2$
		boolean updStatus = false;
		PreparedStatement pStmt = null;
		try
		{
			pStmt = con.prepareStatement(query);
			for (int ctr = 0; ctr < bindVarValues.size(); ctr++ )
			{
				if ( ((String)bindVarTypes.get(ctr)).indexOf("String") != -1) //$NON-NLS-1$
				{
					pStmt.setString((ctr+1), (String)bindVarValues.get(ctr));
				}
				else if (((String)bindVarTypes.get(ctr)).indexOf("Int") != -1) //$NON-NLS-1$
				{
					pStmt.setInt((ctr+1), Integer.parseInt((String)bindVarValues.get(ctr)) );
				}
			}

			ResultSet rs = pStmt.executeQuery();
			if(rs.next())
			{
				//Get the Blob locator and open output stream for the Blob
				Blob mapBlob = rs.getBlob(1);
				OutputStream blobOutputStream = ((oracle.sql.BLOB)mapBlob).getBinaryOutputStream();
				byte[] dataByteArray = null;
				//Changed by Monif on 2/23/2009 [For special char parsing issue].Start
				E12GenericUtility genericUtility = new E12GenericUtility();
				dataStr = genericUtility.remAllXmlDec(dataStr);
				//Changed by Monif on 2/23/2009 [For special char parsing issue].End
				if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</DocumentRoot>") != -1) //$NON-NLS-1$
				{
					dataStr = dataStr.substring(0, dataStr.indexOf("</DocumentRoot>") + 15); //$NON-NLS-1$
					dataByteArray = dataStr.getBytes();
				}
				else if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</Root>") != -1) //$NON-NLS-1$
				{
					dataStr = dataStr.substring(0, dataStr.indexOf("</Root>") + 7); //$NON-NLS-1$
					dataByteArray = dataStr.getBytes();
				}
				BaseLogger.log("3", null, null,"dataByteArray IS = "+dataStr);
				// Write to Blob
				blobOutputStream.write(dataByteArray);
				blobOutputStream.close();
				updStatus = true;
			}
			rs.close();
			rs = null;
			pStmt.close();
			pStmt = null;

		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pStmt != null)
				{
					pStmt.close();
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :updateBlob :==>finally\n"+e.getMessage()); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		return updStatus;
	}

	public String getBlob(String query, ArrayList bindVarValues, ArrayList bindVarTypes) throws RemoteException, ITMException
	{
		String dataStr = ""; //$NON-NLS-1$
		PreparedStatement pStmt = null;
		Connection con = null;
		try
		{
			ConnDriver connDriver = new ConnDriver();
			con = connDriver.getConnectDB("Driver"); //$NON-NLS-1$

			pStmt = con.prepareStatement(query);
			for (int ctr = 0; ctr < bindVarValues.size(); ctr++ )
			{
				if ( ((String)bindVarTypes.get(ctr)).indexOf("String") != -1) //$NON-NLS-1$
				{
					pStmt.setString((ctr+1), (String)bindVarValues.get(ctr));
				}
				else if (((String)bindVarTypes.get(ctr)).indexOf("Int") != -1) //$NON-NLS-1$
				{
					pStmt.setInt((ctr+1), Integer.parseInt((String)bindVarValues.get(ctr)) );
				}
			}

			ResultSet rs = pStmt.executeQuery();
			if (rs.next())
			{
				InputStream is = rs.getBinaryStream(1);
				if (is != null)
				{

					InputStreamReader isr = new InputStreamReader(is);
					StringBuffer xmlStringBuff = new StringBuffer();
					int ch = -1;
					while((ch = isr.read()) != -1 )
					{
						xmlStringBuff.append((char)ch);
					}
					isr.close();
					dataStr = xmlStringBuff.toString();
				}
			}
			if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</DocumentRoot>") != -1) //$NON-NLS-1$
			{
				dataStr = dataStr.substring(0, dataStr.indexOf("</DocumentRoot>") + 15); //$NON-NLS-1$
			}
			else if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</Root>") != -1) //$NON-NLS-1$
			{
				dataStr = dataStr.substring(0, dataStr.indexOf("</Root>") + 7); //$NON-NLS-1$
			}
			rs.close();
			rs = null;
			pStmt.close();
			pStmt = null;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(con != null)
				{
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
					con.close();
					con = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getBlob :==>finally\n"+e.getMessage()); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		return dataStr;
	}

	//Added by Ashish Sonawane on 11-Dec-12 [START]

	/** This method will give the string value for XMLType field in the database with specified query and other parameters.
	 * @param query					:	select query to be executed.
	 * @param bindVarValues			:	Arraylist containing variable values to be bind using preparedstatement in given query.
	 * @param bindVarTypes			:	Arraylist variable types to be bind using preparedstatement in given query.
	 * @return						: 	String value for XMLType field.
	 * @throws RemoteException
	 * @throws ITMException
	 */
	public String getXMLTypeStr( String query, ArrayList bindVarValues, ArrayList bindVarTypes) throws RemoteException, ITMException
	{
		String dataStr = "";
		PreparedStatement pStmt = null;
		Connection con = null;
		ResultSet rs=null;
		try
		{
			ConnDriver connDriver = new ConnDriver();
			con = connDriver.getConnectDB("Driver"); //$NON-NLS-1$
			pStmt = con.prepareStatement(query);

			for (int ctr = 0; ctr < bindVarValues.size(); ctr++ )
			{
				if ( ((String)bindVarTypes.get(ctr)).indexOf("String") != -1)
				{
					pStmt.setString((ctr+1), (String)bindVarValues.get(ctr));
				}
				else if (((String)bindVarTypes.get(ctr)).indexOf("Int") != -1)
				{
					pStmt.setInt((ctr+1), Integer.parseInt((String)bindVarValues.get(ctr)) );
				}
			}

			rs = pStmt.executeQuery();
			if (rs.next())
			{
				// Commented By Gulzar/Sneha on 20-DEC-13 to get the XMLType data value as string : START
				/*XMLType xmlTypeObj = (XMLType)rs.getObject(1);
				if(xmlTypeObj != null)
				{
					dataStr=xmlTypeObj.getStringVal();
				}
				else
				{
					dataStr="";
				}
				 */
				dataStr =rs.getString(1) == null ? "":rs.getString(1);
				// Commented By Gulzar/Sneha on 20-DEC-13 to get the XMLType data value as string : END

			}
			if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</DocumentRoot>") != -1)
			{
				dataStr = dataStr.substring(0, dataStr.indexOf("</DocumentRoot>") + 15);
			}
			else if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</Root>") != -1)
			{
				dataStr = dataStr.substring(0, dataStr.indexOf("</Root>") + 7);
			}
			rs.close();
			rs = null;
			pStmt.close();
			pStmt = null;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(con != null)
				{
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					con.close();
					con = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getXMLType :==>finally\n"+e.getMessage()); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		return dataStr;
	}

	//Added by Ashish Sonawane on 11-Dec-12 [END]
	public String getRefSerXMLStr(String user)throws RemoteException, ITMException
	{
		//BaseLogger.log("3", null, null,"[DBAccessEJB]Getting the ref seriese info. xml string for user :"+user+":");
		String mQuery = null;
		ConnDriver mConnDriver = null;
		Connection mConnection = null;
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String retXMLString = null;
		UserInfoBean userInfo = null;
		String transDB = "";
		try
		{
			userInfo = createUserInfo(user);
			transDB = userInfo.getTransDB();
			mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB(transDB); //$NON-NLS-1$

			StringBuffer roleCodeBuff = new StringBuffer();
			ArrayList roleCodeList = getRoleCodeList(mConnection, user);
			for (int ctr = 0; ctr < roleCodeList.size(); ctr++)
			{
				roleCodeBuff.append("'" + roleCodeList.get(ctr) + "',"); //$NON-NLS-1$ //$NON-NLS-2$
			}

			if(roleCodeBuff.length() > 0)
			{
				roleCodeBuff.deleteCharAt((roleCodeBuff.length() - 1));
				//Changed By Danish on 30/08/2006 reason []
				//mQuery = "SELECT DISTINCT REF_SER FROM OBJ_SIGN WHERE ROLE_CODE__SIGN IN("+roleCodeBuff.toString()+")";
				mQuery = "SELECT DISTINCT REF_SER FROM OBJ_SIGN_TRANS WHERE ROLE_CODE__SIGN IN("+roleCodeBuff.toString()+")"; //$NON-NLS-1$ //$NON-NLS-2$
				BaseLogger.log("3", userInfo, null,"[SignManagerEJB]Retrieving relevant REF_SER from OBJ_SIGN table.........."); //$NON-NLS-1$
				pStmt = mConnection.prepareStatement(mQuery);
				rs = pStmt.executeQuery();
				StringBuffer refSerBuff = new StringBuffer();
				while (rs.next())
				{
					String currRefSer = rs.getString(1);
					refSerBuff.append("'"+currRefSer+"',"); //$NON-NLS-1$ //$NON-NLS-2$
				}
				if (pStmt != null)
				{
					rs.close();
					pStmt.close();
				}
				BaseLogger.log("3", userInfo, null,"[SignManagerEJB]Listing all Ref Series corresponding to the current user role codes :"+refSerBuff.toString()); //$NON-NLS-1$
				if (refSerBuff.length() > 0)
				{
					StringBuffer xmlStringBuff = new StringBuffer();
					refSerBuff.deleteCharAt((refSerBuff.length() - 1));
					mQuery = "SELECT REF_SER, DESCR FROM REFSER WHERE REF_SER IN("+refSerBuff.toString()+")"; //$NON-NLS-1$ //$NON-NLS-2$
					pStmt = mConnection.prepareStatement(mQuery);
					rs = pStmt.executeQuery();
					while (rs.next())
					{
						String refSer = rs.getString("REF_SER"); //$NON-NLS-1$
						String objName = getRefSerObjName(refSer, transDB);
						if (objName != null && objName.length() > 0 )
						{
							xmlStringBuff.append("<Detail>"); //$NON-NLS-1$
							xmlStringBuff.append("<REF_SER><![CDATA["+refSer+"]]></REF_SER>"); //$NON-NLS-1$ //$NON-NLS-2$
							xmlStringBuff.append("<REF_SER_DESC><![CDATA["+rs.getString("DESCR")+"]]></REF_SER_DESC>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
							xmlStringBuff.append("<OBJ_NAME><![CDATA["+objName+"]]></OBJ_NAME>"); //$NON-NLS-1$ //$NON-NLS-2$
							xmlStringBuff.append("</Detail>"); //$NON-NLS-1$
						}
						else
						{
							BaseLogger.log("3", userInfo, null,"ObjName not Found For refSer ["+refSer+"]"); //$NON-NLS-1$ //$NON-NLS-2$
						}
					}
					retXMLString = getNormalizeString(xmlStringBuff.toString());
					if(pStmt != null)
					{
						rs.close();
						pStmt.close();
					}
				}
			}
		}
		catch (ITMException itme)
		{
			BaseLogger.log("0", userInfo, null,"ITMException :SignManagerEJB :getRefSerXMLStr :==>"+itme.getMessage()); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo, null,"Exception :SignManagerEJB :getRefSerXMLStr :==>"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(pStmt != null)
					{
						rs = null;
						pStmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :SignManagerEJB :getRefSerXMLStr :==>finally"+e.getMessage()); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("9", userInfo, null,"retXMLString ["+retXMLString+"]"); //$NON-NLS-1$ //$NON-NLS-2$
		return retXMLString;
	}

	private ArrayList getRoleCodeList(Connection conn, String userID)throws ITMException
	{
		//BaseLogger.log("3", null, null,"[DBAcessEJB]Getting all role codes for the given user :"+userID+":");
		ArrayList roleCodeList = null;
		Statement mStmt = null;
		try
		{
			roleCodeList = new ArrayList();
			String sqlQuery = "SELECT ROLE_CODE FROM WF_ROLE_USERS WHERE USERID = '"+userID+"'"; //$NON-NLS-1$ //$NON-NLS-2$
			//BaseLogger.log("3", null, null,"[DBAcessEJBEJB]Retrieving all role codes for the given user, query :\n"+sqlQuery);
			mStmt = conn.createStatement();
			ResultSet rs = mStmt.executeQuery(sqlQuery);
			while (rs.next())
			{
				String currRoleCode = rs.getString("ROLE_CODE"); //$NON-NLS-1$
				roleCodeList.add(currRoleCode.trim());
			}
			BaseLogger.log("3", null, null,"[DBAcessEJBEJB]ArrayList listing all Role Code corresponding to the given User :"+roleCodeList); //$NON-NLS-1$
			if(rs != null)
			{
				rs.close();
			}
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mStmt != null)
				{
					mStmt.close();
				}
			}
			catch (Exception exp)
			{
				BaseLogger.log("0", null, null,"Exception : DBAcessEJB :getRoleCodeList :\n"+exp.getMessage()); //$NON-NLS-1$
				throw new ITMException(exp);
			}
		}
		return roleCodeList;
	}

	public String getRefSer(Connection mConnection, String objName)throws RemoteException, ITMException
	{
		BaseLogger.log("2", null, null,"[DBAccessEJB]getRefSer() called for objName :"+objName+":"); //$NON-NLS-1$ //$NON-NLS-2$
		Statement mStmt = null;
		ResultSet rs = null;
		String refSer = null;
		//Change by Nilesh on 12-Feb-2011[Close connection if it locally created]
		String flag = "false";  //$NON-NLS-1$
		try
		{
			//			Changed by Monif on 15/10/2007 to create connection.Start
			/*if( mConnection == null )
			{
				mConnection = new ConnDriver().getConnectDB( "Driver" ); //$NON-NLS-1$
				//Change by Nilesh on 12-Feb-2011[Close connection if it locally created]
				flag = "true"; //$NON-NLS-1$
			}*/
			//Changed by Monif on 15/10/2007 to create connection.End
			String sqlQuery = null;
			//Changed by Monif on 10/10/09.
			objName = ( objName != null )?objName.trim():objName;
			sqlQuery = "SELECT REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = 'w_"+objName+"'"; //$NON-NLS-1$ //$NON-NLS-2$
			BaseLogger.log("3", null, null,"[DBAccessEJB]Fetching refSer from TRANSETUP for the current object : Query :\n"+sqlQuery); //$NON-NLS-1$
			mStmt = mConnection.createStatement();
			rs = mStmt.executeQuery(sqlQuery);
			if (rs.next())
			{
				refSer = rs.getString(1);
			}
			if(rs != null)
			{
				rs.close();
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null,"Exception :DBAccessEJB :getRefSer :\n"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mStmt != null)
				{
					mStmt.close();
				}
				//Change by Nilesh on 12-Feb-2011[Close connection if it locally created]Start
				/*if( "true".equals(flag) && mConnection != null ) //$NON-NLS-1$
				{
					mConnection.close();
					mConnection = null;
				}*/
				//Change by Nilesh on 12-Feb-2011[Close connection if it locally created]End
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getRefSer :==>"+e.getMessage()); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		return refSer;
	}

	public String getRefSerDesc(Connection mConnection, String refSer)throws RemoteException, ITMException
	{
		BaseLogger.log("2", null, null,"[DBAccessEJB]getRefSerDesc() called for refSer :"+refSer+":"); //$NON-NLS-1$ //$NON-NLS-2$
		String desc = ""; //$NON-NLS-1$
		Statement mStmt = null;
		ResultSet rs = null;
		try
		{
			String mQuery = "SELECT DESCR FROM REFSER WHERE REF_SER = '"+refSer+"'"; //$NON-NLS-1$ //$NON-NLS-2$
			BaseLogger.log("3", null, null,"[DBAccessEJB]Retrieving description for the refSer, Query :\n"+mQuery); //$NON-NLS-1$
			mStmt = mConnection.createStatement();
			rs = mStmt.executeQuery(mQuery);

			if (rs.next())
			{
				desc = rs.getString(1);
			}
			if(rs != null)
			{
				rs.close();
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null,"Exception :DBAccessEJB :getRefSerDesc :==>\n"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mStmt != null)
				{
					mStmt.close();
				}
			}
			catch(Exception e)
			{
				throw new ITMException(e);
			}
		}
		return desc;
	}

	/*public String getRefSerObjName(String refSer)throws RemoteException, ITMException
	{
		String refSerObjName = "";		 //$NON-NLS-1$
		Connection mConnection = null;
		Statement mStmt = null;
		ResultSet rs = null;
		try
		{
			ConnDriver mConnDriver =  new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver"); //$NON-NLS-1$
			String mQuery = "SELECT TRAN_WINDOW FROM TRANSETUP	 WHERE REF_SER = '"+refSer.trim()+"' "; //$NON-NLS-1$ //$NON-NLS-2$
			BaseLogger.log("3", null, null,"mQuery ["+mQuery+"]"); //$NON-NLS-1$ //$NON-NLS-2$
			mStmt = mConnection.createStatement();
			rs = mStmt.executeQuery(mQuery);

			if (rs.next())
			{
				refSerObjName = rs.getString("TRAN_WINDOW"); //$NON-NLS-1$
				refSerObjName = (refSerObjName.startsWith("w_")) ? refSerObjName.substring("w_".length()) : refSerObjName; //$NON-NLS-1$ //$NON-NLS-2$
			}
			//rs.close();
		}
		catch (Exception e)
		{
			BaseLogger.log("3", null, null,"Exception :DBAccessEJB :getRefSerObjName :==>\n"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(mStmt != null)
					{
						mStmt.close();
						mStmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :SignManagerEJB :getRefSerObjName :==>finally"+e.getMessage()); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("3", null, null,"refSerObjName ["+refSerObjName+"]"); //$NON-NLS-1$ //$NON-NLS-2$
		return refSerObjName.trim();
	}*/

	/*public HashMap getValidateElementMap( String objName )throws RemoteException, ITMException
	{
		ConnDriver connDriver = null;
		Connection connection = null;
		Statement stmt = null;
		ResultSet resSet = null;
		String  query = null;
		String modName=( (objName.toUpperCase()).startsWith("W_")) ? objName:("W_".concat(objName.toUpperCase()));//objName; //$NON-NLS-1$ //$NON-NLS-2$
		ArrayList serverFieldList=null;
		ArrayList clientFieldList=null;
		HashMap validateElementMap=null;

		try
		{
			connDriver = new ConnDriver();
			connection = connDriver.getConnectDB("Driver"); //$NON-NLS-1$

			query = "SELECT VAL_STAGE,FLD_NAME,BLANK_OPT,VAL_TYPE,OBJ_NAME,VAL_TABLE,ERROR_CD,FLD_TYPE ,FLD_WIDTH ,UDF_USAGE_1,UDF_USAGE_2,UDF_USAGE_3,DESCR FROM GENMST WHERE MOD_NAME IN ('"+modName+"' , 'X')"; //$NON-NLS-1$ //$NON-NLS-2$

			BaseLogger.log("3", null, null,"getValidateElementMap::query::"+query); //$NON-NLS-1$

			stmt = connection.createStatement();
			resSet = stmt.executeQuery(query);

			serverFieldList=new ArrayList();
			clientFieldList=new ArrayList();

			validateElementMap=new HashMap();

			while(resSet.next())
			{

				//ArrayList fieldList=new ArrayList();
				HashMap fieldMap=new HashMap();

				String valStage = resSet.getString("VAL_STAGE"); //$NON-NLS-1$
				if ( valStage == null || valStage.length() <= 0 )
				{
					valStage = "S"; //$NON-NLS-1$
				}
				String fieldName = resSet.getString("FLD_NAME"); //$NON-NLS-1$
				String blankOpt = resSet.getString("BLANK_OPT"); //$NON-NLS-1$
				if ( blankOpt == null || blankOpt.length() <= 0 )
				{
					blankOpt = "Y"; //$NON-NLS-1$
				}
				String valType = resSet.getString("VAL_TYPE"); //$NON-NLS-1$
				if (valType == null || valType.length() <= 0)
				{
					valType="M"; //$NON-NLS-1$
					valStage="B"; //$NON-NLS-1$
				}
				String validateFromObjName = resSet.getString("OBJ_NAME"); //$NON-NLS-1$
				String valTable = resSet.getString("VAL_TABLE"); //$NON-NLS-1$

				String errorCode = resSet.getString("ERROR_CD"); //$NON-NLS-1$
				String fieldType = resSet.getString("FLD_TYPE"); //$NON-NLS-1$

				int fieldWidth = resSet.getInt("FLD_WIDTH"); //$NON-NLS-1$

				String udfUsage1 = resSet.getString("UDF_USAGE_1"); //$NON-NLS-1$
				String udfUsage2 = resSet.getString("UDF_USAGE_2"); //$NON-NLS-1$
				String udfUsage3 = resSet.getString("UDF_USAGE_3"); //$NON-NLS-1$
				String description = resSet.getString("DESCR"); //$NON-NLS-1$

				fieldMap.put("FIELD_NAME",fieldName.trim()); //$NON-NLS-1$
				fieldMap.put("BLANK_OPT",blankOpt); //$NON-NLS-1$
				fieldMap.put("VAL_TYPE",valType); //$NON-NLS-1$
				fieldMap.put("OBJ_NAME",validateFromObjName); //$NON-NLS-1$
				fieldMap.put("VAL_TABLE",valTable); //$NON-NLS-1$
				fieldMap.put("ERROR_CD",errorCode); //$NON-NLS-1$
				fieldMap.put("FLD_TYPE",fieldType); //$NON-NLS-1$
				fieldMap.put("FLD_WIDTH",new Integer(fieldWidth)); //$NON-NLS-1$
				fieldMap.put("UDF_USAGE_1",udfUsage1); //$NON-NLS-1$
				fieldMap.put("UDF_USAGE_2",udfUsage2); //$NON-NLS-1$
				fieldMap.put("DESCR",description); //$NON-NLS-1$




				//fieldList.add(fieldName.trim());
				//fieldList.add(blankOpt);

				if( valStage.equalsIgnoreCase("S") || valStage.equalsIgnoreCase("B") ) //$NON-NLS-1$ //$NON-NLS-2$
				{
					//serverFieldList.add(fieldList);
					serverFieldList.add(fieldMap);
				}
				else if( valStage.equalsIgnoreCase("C") || valStage.equalsIgnoreCase("B") ) //$NON-NLS-1$ //$NON-NLS-2$
				{
					//clientFieldList.add(fieldList);
					clientFieldList.add(fieldMap);
				}

			}

			validateElementMap.put("S",serverFieldList); //$NON-NLS-1$
			validateElementMap.put("C",clientFieldList); //$NON-NLS-1$
			resSet.close();
			resSet = null;
			stmt.close();
			stmt = null;
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException: DBAccess: getValidateElementMap:==>"+itme); //$NON-NLS-1$
			itme.printStackTrace();
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccess: getValidateElementMap:==>"+ e); //$NON-NLS-1$
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(connection != null)
				{
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					connection.close();
					connection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getValidateElementMap ==> \n" + e); //$NON-NLS-1$
				throw new ITMException( e );
			}
		}
		return validateElementMap;
	}*/

	/*public HashMap getCopyColInfoMap( String objName, String formNo ) throws RemoteException, ITMException
	{
		Connection mConnection = null;
		PreparedStatement pStmt = null;
		ResultSet pRs=null;
		HashMap yExcludeCopyColMap = null;
		HashMap nExcludeCopyColMap = null;
		HashMap excludeCopyColInfoMap = null;

		try
		{
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver"); //$NON-NLS-1$
			String sqlQuery = "SELECT FIELD_NAME,DEF_VALUE,COPY_FLAG FROM TRANS_COPY_SETUP WHERE OBJ_NAME= ? AND FORM_NO= ? "; //$NON-NLS-1$
			pStmt = mConnection.prepareStatement( sqlQuery );
			pStmt.setString(1,objName.trim());
			pStmt.setString(2,formNo.trim());
			pRs = pStmt.executeQuery();
			excludeCopyColInfoMap = new HashMap();
			nExcludeCopyColMap = new HashMap();
			yExcludeCopyColMap = new HashMap();
			while(pRs.next())
			{
				String colName = pRs.getString(1);
				String defValue = pRs.getString(2);
				String copyFlg = pRs.getString(3);
				if( copyFlg == null || "N".equalsIgnoreCase( copyFlg ) ) //$NON-NLS-1$
				{
					nExcludeCopyColMap.put(colName,defValue);
				}
				else if( "Y".equalsIgnoreCase( copyFlg ) ) //$NON-NLS-1$
				{
					yExcludeCopyColMap.put( colName,defValue );
				}
			}
			excludeCopyColInfoMap.put( "N", nExcludeCopyColMap ); //$NON-NLS-1$
			excludeCopyColInfoMap.put( "Y", yExcludeCopyColMap ); //$NON-NLS-1$
			pRs.close();
			pRs = null;
			pStmt.close();
			pStmt = null;
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException :DBAccessEJB :getExcludeCopyColInfoMap :\n"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception :DBAccessEJB :getExcludeCopyColInfoMap :\n"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(pStmt != null)
					{
						pStmt.close();
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getExcludeCopyColInfoMap :==>F" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("3", null, null,"Returning excludeCopyColInfoMap :"+ excludeCopyColInfoMap); //$NON-NLS-1$
		return excludeCopyColInfoMap;
	}*/

	// Changed By Dilip Mane on 07/08/2008 for [ getting mobile number of user ] start
	public String getMobileNumber(String loginCode, String transDB )throws RemoteException, ITMException
	{
		BaseLogger.log("2", null, null,"[DBAccessEJB]Getting Mobile number from masters for logincode ["+ loginCode + "]"); //$NON-NLS-1$ //$NON-NLS-2$
		ConnDriver mConnDriver = null;
		Connection mConnection = null;
		Statement stmt = null;
		ResultSet mRs = null;
		String retMobNo = null;
		try
		{
			mConnDriver = new ConnDriver();
			//Commented and changed by Gulzar on 11/02/14 : user related information should get from 'Driver' connection instead of 'Driver'
			mConnection = mConnDriver.getConnectDB("Driver"); //$NON-NLS-1$
			//mConnection = mConnDriver.getConnectDB(transDB); //$NON-NLS-1$

			String mQuery = "SELECT mobile_no FROM users WHERE code = '" + loginCode + "'"; //$NON-NLS-1$ //$NON-NLS-2$

			//BaseLogger.log("3", null, null,"[DBAccessEJB]Query :"+mQuery);
			stmt = mConnection.createStatement();
			mRs = stmt.executeQuery(mQuery);

			if (mRs.next())
			{
				retMobNo = mRs.getString(1);
			}
			mRs.close();
			mRs = null;
			stmt.close();
			stmt = null;
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException :DBAccessEJB :getMobileNumber :\n"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception :DBAccessEJB :getMobileNumber :\n"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getMobileNumber :\n"+e.getMessage()); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2", null, null,"[DBAccessEJB]Returning mobile number :"+retMobNo+":"); //$NON-NLS-1$ //$NON-NLS-2$
		return retMobNo;
	}
	// Changed By Dilip Mane on 07/08/2008 for [ getting mobile number of user ] End

	//Changed by Monif on 13/08/09[ To get TranComplMsg from TransetUp || WS89SUN113].Start
	/*public String getTranComplMsg(String winName )throws RemoteException, ITMException
	{
		BaseLogger.log("3", null, null,"[DBAccessEJB]Getting TranComplMsg from TRANSETUP for winName ["+ winName + "]"); //$NON-NLS-1$ //$NON-NLS-2$
		ConnDriver mConnDriver = null;
		Connection mConnection = null;
		Statement stmt = null;
		ResultSet mRs = null;
		String retTranComplMsg = null;
		try
		{
			mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver"); //$NON-NLS-1$

			String mQuery = "SELECT TRAN_COMPL_MSG FROM TRANSETUP WHERE TRAN_WINDOW = '" + winName + "'"; //$NON-NLS-1$ //$NON-NLS-2$

			BaseLogger.log("3", null, null,"[DBAccessEJB]Query :"+mQuery); //$NON-NLS-1$
			stmt = mConnection.createStatement();
			mRs = stmt.executeQuery(mQuery);

			if (mRs.next())
			{
				retTranComplMsg = mRs.getString(1);
			}
			stmt.close();
			stmt = null;
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException :DBAccessEJB :getTranComplMsg :\n"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception :DBAccessEJB :getTranComplMsg :\n"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getTranComplMsg :\n"+e.getMessage()); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("3", null, null,"[DBAccessEJB]Returning getTranComplMsg :"+retTranComplMsg+":"); //$NON-NLS-1$ //$NON-NLS-2$
		return retTranComplMsg;
	}*///Changed by Monif on 13/08/09[ To get TranComplMsg from TransetUp ].End
	//Changed by Swapnil Shirke on 01-Jul-2010 [to add stan_code__hq, designation, dateOfJoining, division in userInfo][WS90SUN043] starts
	private String getDivision(String itemSer, String transDB) throws RemoteException, BaseException
	{
		BaseLogger.log("2", null, null,"Getting item series for entityCode :"+itemSer+":"); //$NON-NLS-1$ //$NON-NLS-2$
		String division = ""; //$NON-NLS-1$
		ConnDriver connDriver = null;
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		String query = null;

		try
		{
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB(transDB); //$NON-NLS-1$
			query = "SELECT DESCR AS DIVISION FROM ITEMSER WHERE ITEM_SER = '"+itemSer+"'"; //$NON-NLS-1$ //$NON-NLS-2$
			stmt = conn.createStatement();
			BaseLogger.log("2", null, null,"[CommonDBAccessEJB]Getting division code, query :\n"+query); //$NON-NLS-1$
			rs = stmt.executeQuery(query);

			while(rs.next())
			{
				division = rs.getString(1);
			}
			stmt.close();
			stmt = null;
		}
		catch (SQLException sqle)
		{
			BaseLogger.log("0", null, null,"SQLException :CommonDBAccessEJB :getDivision :==>"); //$NON-NLS-1$
			sqle.printStackTrace();
			throw new ITMException(sqle);
		}
		catch (BaseException basee)
		{
			BaseLogger.log("0", null, null,"BaseException :CommonDBAccessEJB :getDivision :==>"); //$NON-NLS-1$
			basee.printStackTrace();

		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null,"Exception :CommonDBAccessEJB :getDivision :==>"+e); //$NON-NLS-1$
			e.printStackTrace();

		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(stmt != null)
					{
						stmt.close();
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :CommonDBAccessEJB :getDivision :==>"+e); //$NON-NLS-1$
				throw new BaseException(e);
			}
		}
		BaseLogger.log("2", null, null,"[CommonDBAccessEJB]Division :"+division); //$NON-NLS-1$
		return division;
	}
	//Changed by Swapnil Shirke on 01-Jul-2010 [to add stan_code__hq, designation, dateOfJoining, division in userInfo][WS90SUN043] ends
	//Changed by gayatri[To give an option of favorite menus on the screen to the user for faster access To the menus most frequently used][SY90SUN029]start
	/*public String insertFavoriteObject(String objName , String userId , String clientIP)throws RemoteException,ITMException
	{
		Connection mConnection = null;
		PreparedStatement mPstmt = null;
		ResultSet rs = null;
		String  mInsStat = null;
		String returnString = ""; //$NON-NLS-1$
		try
		{
			if(userId!=null)
			{
				ConnDriver mConnDriver = new ConnDriver();
				mConnection = mConnDriver.getConnectDB("Driver"); //$NON-NLS-1$
				mInsStat = "SELECT COUNT(1) FROM USER_OBJ_FAV WHERE OBJ_NAME=? AND USER_ID=?"; //$NON-NLS-1$
				mPstmt = mConnection.prepareStatement(mInsStat);
				mPstmt.setString(1, objName);
				mPstmt.setString(2, userId);
				rs = mPstmt.executeQuery();
				if ( rs.next() )
				{
					if(rs.getInt(1) <= 0)
					{

						//BaseLogger.log("3", null, null," objName="+objName+" userId= "+userId+" time= "+new java.sql.Timestamp(System.currentTimeMillis())+"clientIP="+clientIP);
						mInsStat = "INSERT INTO USER_OBJ_FAV(OBJ_NAME , USER_ID ,CHG_DATE , CHG_USER , CHG_TERM ) VALUES (?, ?, ?, ?, ?)"; //$NON-NLS-1$

						mPstmt = mConnection.prepareStatement(mInsStat);
						mPstmt.setString(1, objName);
						mPstmt.setString(2, userId);
						mPstmt.setTimestamp(3, new java.sql.Timestamp(System.currentTimeMillis()));
						mPstmt.setString(4, userId);
						mPstmt.setString(5, clientIP);
						BaseLogger.log("3", null, null,"Executing insertFavoriteObject Query"); //$NON-NLS-1$
						mPstmt.executeUpdate();
						mConnection.commit();
						returnString = Messages.getString("DBAccessEJB_addToFavourites"); //$NON-NLS-1$
					}
					else
					{
						returnString = Messages.getString("DBAccessEJB_alreadyExistsInFavourites"); //$NON-NLS-1$
					}
				}
				mPstmt.close();
				mPstmt = null;
				BaseLogger.log("3", null, null,"Favorite object inserted..............."); //$NON-NLS-1$
			}
			else
			{
				System.err.println(Messages.getString("DBAccessEJB_notLogged")+"\n"+Messages.getString("DBAccessEJB_pleaseReconnect")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$

			}
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException: DBAccess: saveToDraftObjects:"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccess: saveToDraftObjects:"  + e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(mPstmt != null)
					{
						mPstmt.close();
						mPstmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getActionTitlesList \n" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		return returnString;
	}*/
	/*public String removeFavoriteObject(String objName , String userId )throws RemoteException,ITMException
	{
		Connection mConnection = null;
		PreparedStatement mPstmt = null;
		ResultSet rs = null;
		String  mInsStat = null;
		String returnString = ""; //$NON-NLS-1$
		try
		{
			if(userId!=null)
			{
				ConnDriver mConnDriver = new ConnDriver();
				mConnection = mConnDriver.getConnectDB("Driver"); //$NON-NLS-1$
				mInsStat = "SELECT COUNT(1) FROM USER_OBJ_FAV WHERE OBJ_NAME=? AND USER_ID=?"; //$NON-NLS-1$
				mPstmt = mConnection.prepareStatement(mInsStat);
				mPstmt.setString(1, objName);
				mPstmt.setString(2, userId);
				rs = mPstmt.executeQuery();
				if ( rs.next() )
				{
					if(rs.getInt(1) > 0)
					{
						mInsStat = "DELETE FROM USER_OBJ_FAV WHERE OBJ_NAME=? AND USER_ID=?"; //$NON-NLS-1$

						mPstmt = mConnection.prepareStatement(mInsStat);
						mPstmt.setString(1, objName);
						mPstmt.setString(2, userId);
						BaseLogger.log("3", null, null,"Executing insertFavoriteObject Query"); //$NON-NLS-1$
						mPstmt.executeUpdate();
						mConnection.commit();
						returnString = Messages.getString("DBAccessEJB_removeFromFavourites"); //$NON-NLS-1$
					}
					else
					{
						returnString = Messages.getString("DBAccessEJB_unableToRemoveFromFavourites"); //$NON-NLS-1$
					}
				}
				mPstmt.close();
				mPstmt = null;
				BaseLogger.log("3", null, null,"Favorite object inserted..............."); //$NON-NLS-1$
			}
			else
			{
				System.err.println(Messages.getString("DBAccessEJB_notLogged")+"\n"+Messages.getString("DBAccessEJB_pleaseReconnect")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$

			}

		}
		catch (ITMException itme)
		{
			System.err.println("ITMException: DBAccess: saveToDraftObjects:"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccess: saveToDraftObjects:"  + e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(mPstmt != null)
					{
						mPstmt.close();
						mPstmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getActionTitlesList \n" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		return returnString;
	}*/
	//Changed by gayatri[To give an option of favorite menus on the screen to the user for faster access To the menus most frequently used][SY90SUN029]end
	//Added by Nilesh on 22/11/10 [WI01BAS004][Implementation of Favourite]Start
	//Added Harshada 23 Nov 2012 [creating user connections on login]
	//Added by Dnyaneshwar Chavan [userLevel, profileId and isMobile parameters are added ] Start
	public String getFavouriteData( String loginCode, String applName, String profileId, String userLevel, boolean isMobile, UserInfoBean userInfo )throws RemoteException, ITMException
	{
		StringBuffer favXmlStr = new StringBuffer();
		ConnDriver mConnDriver = null;
		Connection mConnection = null;
		Statement mStatement = null;
		ResultSet mResultSet = null;
		//Added by Saiprasad G. on 15-03-19 to get rights from useradhoc
		HashMap<String,String> overrideRightsAdhocMap = new HashMap<>();
		CommonDBAccessEJB commonDBaccess = new CommonDBAccessEJB();

		if( applName != null && !"".equalsIgnoreCase(applName) && !"null".equalsIgnoreCase(applName) )
		{
			applName = applName.toUpperCase();
		}

		try
		{
			mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB(userInfo.getTransDB()); //$NON-NLS-1$
			//Added By Pratheek for Menu restriction in E12Mobile
			checkConditionDetails( userInfo );

			int userLev =(userLevel==null||"".equalsIgnoreCase(userLevel))? -1 : Integer.parseInt(userLevel);

			//String favObjName = "SELECT OBJ_NAME FROM USER_OBJ_FAV WHERE USER_ID='"+loginCode+"'"; //$NON-NLS-1$ //$NON-NLS-2$
			//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]START
			/*String favAndUsrRightsQuery = " SELECT OBJ_NAME FROM USER_RIGHTS WHERE FAV_OPTION = 'Y' AND PROFILE_ID='"+profileId.trim()+"' "
					+" UNION "
					+" SELECT OBJ_NAME FROM USER_OBJ_FAV WHERE USER_ID='"+loginCode.trim()+"' "
					+" AND OBJ_NAME NOT IN ( SELECT RTRIM(OBJ_NAME) FROM USER_RIGHTS "
					+" WHERE FAV_OPTION = 'Y' AND PROFILE_ID='"+profileId.trim()+"' ) ";*/
			String favAndUsrRightsQuery = "SELECT OBJ_NAME, APPLICATION FROM USER_RIGHTS WHERE FAV_OPTION = 'Y' AND PROFILE_ID  IN "+ E12GenericUtility.getFormattedProfileId(profileId.trim()) +" AND OBJ_NAME IN( SELECT OBJ_NAME FROM USER_RIGHTS WHERE FAV_OPTION = 'Y' AND PROFILE_ID IN " + E12GenericUtility.getFormattedProfileId(profileId.trim())
					+" UNION "
					+" SELECT OBJ_NAME FROM USER_OBJ_FAV WHERE USER_ID='"+loginCode.trim()+"' "
					+" AND OBJ_NAME NOT IN ( SELECT RTRIM(OBJ_NAME) FROM USER_RIGHTS "
					+" WHERE FAV_OPTION = 'Y' AND PROFILE_ID IN " + E12GenericUtility.getFormattedProfileId(profileId.trim())+" ) ) ";
			//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]END
			//BaseLogger.log("3", null, null, "Getting favObjName SQL [ " + favAndUsrRightsQuery + "]" ); //$NON-NLS-1$ //$NON-NLS-2$
			mStatement = mConnection.createStatement();
			mResultSet = mStatement.executeQuery( favAndUsrRightsQuery );
			favXmlStr.append("<APPLICATION>"); //$NON-NLS-1$
			while(mResultSet.next())
			{
				String objName = mResultSet.getString("OBJ_NAME").trim();
				BaseLogger.log("3", userInfo, null, "FavObjName [" + objName + "]" ); //$NON-NLS-1$ //$NON-NLS-2$
				//String winName="w_"+objName; //$NON-NLS-1$ //$NON-NLS-2$
				String winName= ( objName.indexOf("/") == -1 ) ? "w_"+objName : objName ; //$NON-NLS-1$ //$NON-NLS-2$

				String appName = mResultSet.getString("APPLICATION").trim();
				BaseLogger.log("3", userInfo, null, "Fav menu appName [" + appName + "]" );
				//Changes by Prajyot on 25-JAN-2013[ In case of Application name is Null ] Start
				String selectFavoriteQry = "";

				// Commented and Added by Dnyaneshwar Chavan on 04-APR-13 [Some codition add for Favourite menu] start
				/*if( applName != null )
				{
					selectFavoriteQry="SELECT APPLICATION,WIN_NAME,DESCR,COMMENTS,MENU_PATH,ICON_PATH,OBJ_TYPE FROM ITM2MENU WHERE WIN_NAME='"+winName.trim()+"'" + "and APPLICATION=" +"'"+applName.trim()+"'"; //$NON-NLS-1$ //$NON-NLS-2$
				}
				else
				{
					selectFavoriteQry="SELECT APPLICATION,WIN_NAME,DESCR,COMMENTS,MENU_PATH,ICON_PATH,OBJ_TYPE FROM ITM2MENU WHERE WIN_NAME='"+winName.trim()+"'"; //$NON-NLS-1$ //$NON-NLS-2$
				}
				//Changes by Prajyot on 25-JAN-2013[ In case of Application name is Null ] Ends
				 */
				if( userLev >= 1 )
				{
					selectFavoriteQry = " SELECT B.APPLICATION ,B.WIN_NAME, B.COMMENTS, B.MENU_PATH ,"
							+" B.DESCR,B.ICON_PATH,B.OBJ_TYPE "
							+" FROM USER_RIGHTS A, ITM2MENU B "
							//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
							//+" WHERE A.PROFILE_ID ='"+profileId.trim()+"' "
							+" WHERE A.PROFILE_ID  IN " + E12GenericUtility.getFormattedProfileId(profileId.trim())
							//Changes made by Pratheek on 27-12-18[to display favourite menu for all application.]-Start
							+" AND A.APPLICATION = '"+appName+"' "
							//Changes made by Pratheek on 27-12-18[to display favourite menu for all application.]-End
							+" AND A.FAV_OPTION = 'Y' "
							+" AND B.WIN_NAME ='"+winName.trim()+"'"
							//+" "+(isMobile == true ? " AND B.MOB_DEPLOY = 'Y' " : " ")
							+" "+( isMobile == true ? " AND ( B.MOB_DEPLOY = 'Y' OR B.MOB_DEPLOY = 'B' ) " : "  AND ( B.MOB_DEPLOY = 'B' OR B.MOB_DEPLOY is null ) " )//Added by Dnyaneshwar Chavan on 21-Aug-14 [ Mobile Specific Menus Should Not Get Displayed In Browser. ]
							+" AND A.APPLICATION=B.APPLICATION AND A.MENU_ROW=B.LEVEL_1 "
							+" AND A.MENU_COL=B.LEVEL_2 AND A.MENU_SUBCOL=B.LEVEL_3 "
							+" AND A.LEVEL_4=B.LEVEL_4 AND A.LEVEL_5=B.LEVEL_5 "
							+" ORDER BY A.APPLICATION,A.MENU_ROW,A.MENU_COL,A.MENU_SUBCOL,A.LEVEL_4,A.LEVEL_5 ";
				}
				else
				{
					selectFavoriteQry = " SELECT APPLICATION,WIN_NAME,DESCR,COMMENTS,MENU_PATH,"
							+" ICON_PATH, OBJ_TYPE "
							+" FROM ITM2MENU "
							+" WHERE WIN_NAME='"+winName.trim()+"'"
							//Changes made by Pratheek on 27-12-18[to display favourite menu for all application.]-Start
							+" AND APPLICATION ='"+appName+"'"
							//Changes made by Pratheek on 27-12-18[to display favourite menu for all application.]-End
							//+" "+(isMobile == true ? " AND MOB_DEPLOY = 'Y' " : " ")
							+" "+( isMobile == true ? " AND ( MOB_DEPLOY = 'Y' OR MOB_DEPLOY = 'B' ) " : "  AND ( MOB_DEPLOY = 'B' OR MOB_DEPLOY is null ) " )//Added by Dnyaneshwar Chavan on 21-Aug-14 [ Mobile Specific Menus Should Not Get Displayed In Browser. ]
							+" ORDER BY APPLICATION,LEVEL_1,LEVEL_2,LEVEL_3,LEVEL_4,LEVEL_5";
				}
				// Commented and Added by Dnyaneshwar Chavan on 04-APR-13 [Some codition add for Favourite menu] End
				//BaseLogger.log("3", null, null, "Favourite ITM2MENU Query [" + selectFavoriteQry + "]" ); //$NON-NLS-1$ //$NON-NLS-2$
				//Added by Saiprasad G. START
				overrideRightsAdhocMap = commonDBaccess.getUserAdhocRights(profileId, userInfo);
				//Added by Saiprasad G. END
				Statement fStmt = mConnection.createStatement();
				ResultSet fResultSet = fStmt.executeQuery(selectFavoriteQry);
				if(fResultSet.next())
				{
					//Changed By Pratheek for Menu restriction in E12Mobile
					boolean freez = false;
					freez = checkObjPermission( objName ,fResultSet.getString("OBJ_TYPE") );
					//Changes made by Pratheek on 19-08-19[error was coming on xml parsing so added the cdata with the value ]-Start
					//favXmlStr.append("<OPTION id='"+fResultSet.getString("MENU_PATH")+"' icon='"+fResultSet.getString("ICON_PATH")+"'><TITLE><![CDATA["+fResultSet.getString("DESCR")+"]]></TITLE><OBJNAME><![CDATA["+objName+"]]></OBJNAME><OBJTYPE>"+fResultSet.getString("OBJ_TYPE")+"</OBJTYPE><COMMENTS>"+fResultSet.getString("COMMENTS")+"</COMMENTS>");
					favXmlStr.append("<OPTION id='"+fResultSet.getString("MENU_PATH")+"' icon='"+fResultSet.getString("ICON_PATH")+"'><TITLE><![CDATA["+fResultSet.getString("DESCR")+"]]></TITLE><OBJNAME><![CDATA["+objName+"]]></OBJNAME><OBJTYPE><![CDATA["+fResultSet.getString("OBJ_TYPE")+"]]></OBJTYPE><COMMENTS><![CDATA["+fResultSet.getString("COMMENTS")+"]]></COMMENTS>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$ //$NON-NLS-11$ //$NON-NLS-12$ //$NON-NLS-13$

					favXmlStr.append("<FREEZ_MENU><![CDATA[");
					favXmlStr.append(freez);
					favXmlStr.append("]]></FREEZ_MENU>");
					//Changes made by Pratheek on 19-08-19[error was coming on xml parsing so added the cdata with the value ]-End
					if( freez )
					{
						favXmlStr.append("<FREEZ_MESSAGE><![CDATA[");
						favXmlStr.append( CommonConstants.menuRstMsg );
						favXmlStr.append("]]></FREEZ_MESSAGE>");
					}
					else
					{
						favXmlStr.append("<FREEZ_MESSAGE>");
						favXmlStr.append("<![CDATA[]]>");
						favXmlStr.append("</FREEZ_MESSAGE>");
					}
					//Added by Saiprasad G. to add adhoc_rights in xml [START]
					String loginSiteCode = userInfo.getSiteCode();
					String rightAdhocSiteCode = overrideRightsAdhocMap.get(objName);
					if(loginSiteCode.equalsIgnoreCase(rightAdhocSiteCode) || overrideRightsAdhocMap.containsKey(objName))
					{
						favXmlStr.append("<ADHOC_RIGHTS>");
						favXmlStr.append("<![CDATA[Y]]>");
						favXmlStr.append("</ADHOC_RIGHTS>");
					}
					else
					{
						favXmlStr.append("<ADHOC_RIGHTS>");
						favXmlStr.append("<![CDATA[N]]>");
						favXmlStr.append("</ADHOC_RIGHTS>");
					}
                    //Added by Saiprasad G. on 15-03-19 to add adhoc_rights in xml [END]
					favXmlStr.append("</OPTION>");
					//Changed By Pratheek for Menu restriction in E12Mobile
				}
				//Added By Prajyot on 20-FEB-2013 [Multiple Open cursor issue]
				if( fStmt != null )
				{
					fStmt.close();
					fStmt=null;
				}
				if( fResultSet != null )
				{
					fResultSet.close();
					fResultSet=null;
				}

			}
			favXmlStr.append("</APPLICATION>"); //$NON-NLS-1$
			mResultSet.close();
			mResultSet = null;
			mStatement.close();
			mStatement = null;
		}
		catch(Exception e)
		{
			System.err.println("Exception :DBAccessEJB :getFavouriteData :==>"+e); //$NON-NLS-1$
		}
		finally
		{
			try
			{
				if( mResultSet != null )
				{
					mResultSet.close();
					mResultSet = null;
				}
				if( mStatement != null )
				{
					mStatement.close();
					mStatement =null;
				}
				if(mConnection!=null )
				{
					mConnection.close();
					mConnection=null;
				}
			}
			catch(Exception se)
			{
				BaseLogger.log("0", userInfo, null,"Exception :DBAccessEJB :getFavouriteData : In finally ==>" + se.getMessage()); //$NON-NLS-1$
			}
		}
		//Added By Pratheek for Menu restriction in E12Mobile
		clearPermissionList();

		BaseLogger.log("2", userInfo, null,"Returning Favorite data ["+favXmlStr+"]"); //$NON-NLS-1$ //$NON-NLS-2$
		return favXmlStr.toString();
	}
	//Added by Nilesh on 22/11/10 [WI01BAS004][Implementation of Favourite]End
	//Added by Gayatri Yadav  on 14-01-2011[SY01SUN005][ DownTime Logging]start
	//Changed  by Gayatri Yadav on 17-03-2011 [SY01SUN005][DownTime Logging ]
	//public String insertStatusLog( String serverId, String serverIp, String serverType, String serverName, String clientIp, String requestTime, String responseStatus, String logFileName)throws RemoteException,ITMException
	//changed by Gayatri Yadav on  01-04-2011 [To store machine name in status log][SY12SUN004]
	//public String insertStatusLog( String serverId, String serverIp, String serverType, String serverName, String clientIp, String requestTime, String responseStatus, String logFileName, String userName, String execepMessage)throws RemoteException,ITMException
	public String insertStatusLog( String serverId, String serverIp, String serverType, String serverName, String clientIp, String requestTime, String responseStatus, String logFileName, String userName, String execepMessage, String machineName)throws RemoteException,ITMException
	{
		BaseLogger.log("2", null, null,"DBAccessEJB CALLED"); //$NON-NLS-1$

		Connection conn = null;
		PreparedStatement pstmt = null;
		Statement stmt = null;
		String respString = ""; //$NON-NLS-1$
		BaseLogger.log("2", null, null,"requestTime = "+requestTime); //$NON-NLS-1$
		java.sql.Timestamp requestDate = java.sql.Timestamp.valueOf(requestTime.trim());
		java.util.Date date = new  java.util.Date();
		SimpleDateFormat formatter=  new SimpleDateFormat("dd-MM-yyyy"); //$NON-NLS-1$
		String currentDate = formatter.format(date.getTime());
		BaseLogger.log("2", null, null,"dateNow = "+currentDate); //$NON-NLS-1$

		try
		{
			conn = ( new ConnDriver() ).getConnectDB("Driver"); //$NON-NLS-1$
			//changed by gayatri on 30-01-2012 [WI1HBAS001][Migration of BaseE12 on Mysql]start
			//String nextseqQuery = "select DOWNTIME_SEQ.NEXTVAL from dual";
			//String nextSeq = "";
			String nextseqQuery = "";
			String nextSeq = "";
			//changed by gayatri
			//nextseqQuery = ("mysql".equalsIgnoreCase( CommonConstants.DB_NAME ) )? "SELECT DOWNTIME_FUNCTION()" :  "SELECT DOWNTIME_SEQ.NEXTVAL FORM DUAL" ;
			nextseqQuery = ("mysql".equalsIgnoreCase( CommonConstants.DB_NAME ) )? "SELECT DOWNTIME_FUNCTION()" :  "SELECT DOWNTIME_SEQ.NEXTVAL FROM DUAL" ;
			//changed by gayatri on 30-01-2012  [WI1HBAS001][Migration of BaseE12 on Mysql]end

			stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery( nextseqQuery );
			if( rs.next() )
			{
				nextSeq = rs.getString( 1 );
			}
			BaseLogger.log("3", null, null," nextSeq [" + nextSeq + "]"); //$NON-NLS-1$ //$NON-NLS-2$
			//changed by gayatri on 30-01-2012  [WI1HBAS001][Migration of BaseE12 on Mysql]start
			if("mysql".equalsIgnoreCase( CommonConstants.DB_NAME ))
			{
				nextSeq = (nextSeq != null) ? String.valueOf(Integer.parseInt(nextSeq)+1) : "1";
			}
			//changed by gayatri on 30-01-2012  [WI1HBAS001][Migration of BaseE12 on Mysql]end
			BaseLogger.log("3", null, null," nextSeq [" + nextSeq + "]"); //$NON-NLS-1$ //$NON-NLS-2$

			//Changed  by Gayatri Yadav on 17-03-2011 [SY01SUN005][DownTime Logging ]
			//String insertQuery = "INSERT INTO UPTIME_LOG (REQUEST_ID , SERVER_ID , SERVER_IP , SERVER_TYPE , SERVER_NAME ,CLIENT_IP , REQUEST_TIME, RESPONSE_STATUS , LOG_FILE_NAME) VALUES( ?, ?, ?, ?, ?, ?, ?, ?,?)";
			//changed by Gayatri Yadav on  01-04-2011 [To store machine name in status log][SY12SUN004]
			//String insertQuery = "INSERT INTO UPTIME_LOG (REQUEST_ID , SERVER_ID , SERVER_IP , SERVER_TYPE , SERVER_NAME ,CLIENT_IP , REQUEST_TIME, RESPONSE_STATUS , LOG_FILE_NAME , USER_NAME, EXCEPTION_MSG) VALUES( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
			String insertQuery = "INSERT INTO UPTIME_LOG (REQUEST_ID , SERVER_ID , SERVER_IP , SERVER_TYPE , SERVER_NAME ,CLIENT_IP , REQUEST_TIME, RESPONSE_STATUS , LOG_FILE_NAME , USER_NAME, EXCEPTION_MSG, CHG_TERM) VALUES( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"; //$NON-NLS-1$
			BaseLogger.log("3", null, null,"insertQuery = "+insertQuery); //$NON-NLS-1$
			pstmt=conn.prepareStatement( insertQuery );
			pstmt.setString( 1, nextSeq );
			pstmt.setString( 2, serverId );
			pstmt.setString( 3, serverIp );
			pstmt.setString( 4, serverType );
			pstmt.setString(5, serverName);
			pstmt.setString( 6, clientIp );
			pstmt.setTimestamp( 7, requestDate );
			pstmt.setString( 8, responseStatus );
			pstmt.setString( 9, logFileName );
			//Changed  by Gayatri Yadav on 17-03-2011 [SY01SUN005][DownTime Logging ]start
			pstmt.setString( 10, userName );
			pstmt.setString( 11, execepMessage );
			//Changed  by Gayatri Yadav on 17-03-2011 [SY01SUN005][DownTime Logging ]end
			//changed by Gayatri Yadav on  01-04-2011 [To store machine name in status log][SY12SUN004]
			pstmt.setString( 12, machineName );
			int result = pstmt.executeUpdate();
			if(result > 0 && result != 0)
			{
				respString = Messages.getString("DBAccessEJB_fileSuccessfullyLoadedInDatabase"); //$NON-NLS-1$
				File statusServerLog = new File( CommonConstants.STATUS_SERVER_LOG + CommonConstants.STATUS_SERVER_lOG_FILE);
				if (statusServerLog.exists())
				{
					String uploadedFolderFilePath = CommonConstants.UPLOADED_FOLDER;
					File uplodedFolder = new File(uploadedFolderFilePath);
					if(!uplodedFolder.exists())
					{
						uplodedFolder.mkdir();
					}
					BaseLogger.log("3", null, null,"uplodedFolder = " + uplodedFolder.toString()); //$NON-NLS-1$
					// Move file to new directory
					String uplodeFileName = currentDate.toString()+statusServerLog.getName() ;
					BaseLogger.log("3", null, null,"uplodeFileName " +uplodeFileName); //$NON-NLS-1$
					//Changed  by gayatri on [02-03-2011] to changed logic of moving file [SY01SUN005] start
					File file = new File(uplodedFolder , uplodeFileName);
					if(file.exists())
					{
						file.delete();
					}
					//Changed  by gayatri on [02-03-2011] to changed logic of moving file [SY01SUN005] end
					boolean success = statusServerLog.renameTo(new File(uplodedFolder, uplodeFileName.toString()));
					if (success)
					{
						BaseLogger.log("3", null, null,"file moved to uploaded folder"); //$NON-NLS-1$
					}
				}
			}
			else
			{
				respString = Messages.getString("DBAccessEJB_fileNotLoadedInDatabase"); //$NON-NLS-1$
			}
			conn.commit();
		}
		catch (Exception e)
		{
			try
			{
				conn.rollback();
			}
			catch( Exception le )
			{
				le.printStackTrace();
				throw new ITMException(le);
			}
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( conn != null )
				{
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					if( stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return respString;
	}
	//Added by Gayatri Yadav on 14-01-2011 [SY01SUN005][ DownTime Logging]end
	//Added by farooque on 13-May-2011[WS01SUN048][to get action data from obj_link]Start
	public String getAllActionLinksString(String objName, UserInfoBean userInfo)throws RemoteException, ITMException
	{
		BaseLogger.log("2", userInfo, null,"Landed to Ejb"); //$NON-NLS-1$
		Connection mConnection = null;
		Statement mStmt = null;
		ResultSet mRs = null;
		StringBuffer allActStrBuff = new StringBuffer("<OBJACTION>" ); //$NON-NLS-1$
		String  mQuery = null;
		String  mQuery1 = null;
		String strRights = ""; //$NON-NLS-1$
		String compName = ""; //$NON-NLS-1$
		String compType = ""; //$NON-NLS-1$
		String methodName = ""; //$NON-NLS-1$
		boolean isSysTypeOverwritten = false;
		//Commented and Added by Saiprasad on 02-04-19 to get rights from user_adhic_rights [START]
		PreparedStatement pStmt = null;
		String userAdhocRights = "",userAdhocRightSql = "",userRightType =" ";
		String userID = userInfo.getLoginCode();
		String currSiteCode = userInfo.getSiteCode();
	    String siteCodeLogin = "";
	    Timestamp effFromUserAdhoc = null,validUptoAdhoc = null,currDateTs = null;
	    Date curr= new Date();
	    E12GenericUtility genericUtility = new E12GenericUtility();
	    //Commented and Added by Saiprasad on 02-04-19 to get rights from user_adhic_rights [END]
		try
		{
			ConnDriver mConnDriver = new ConnDriver();

			//Changes made by Gulzar on 10/10/13 to support multiDB connection : START
			String transDB = userInfo.getTransDB();
			//if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
			{
				mConnection = mConnDriver.getConnectDB(transDB); //$NON-NLS-1$
			}
			//Changes made by Gulzar on 10/10/13 to support multiDB connection : END

			if ( ("0").equals( userInfo.getUserLevel() ) ) //$NON-NLS-1$
			{
				BaseLogger.log("3", userInfo, null,"DBAcess if condition"); //$NON-NLS-1$
				strRights = "*"; //$NON-NLS-1$
			}
			else
			{
				BaseLogger.log("3", userInfo, null,"DBAcess else condition"); //$NON-NLS-1$
				//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
				//mQuery1 = "SELECT RIGHTS FROM USER_RIGHTS WHERE PROFILE_ID ='" + userInfo.getProfileId() + "'" + " AND OBJ_NAME ='"+objName+"'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				mQuery1 = "SELECT RIGHTS FROM USER_RIGHTS WHERE PROFILE_ID  IN " + E12GenericUtility.getFormattedProfileId(userInfo.getProfileId()) + " AND OBJ_NAME ='"+objName+"'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				BaseLogger.log("3", userInfo, null,"SQL Query :" + mQuery1); //$NON-NLS-1$
				mStmt = mConnection.createStatement();
				mRs = mStmt.executeQuery(mQuery1);
				while(mRs.next())
				{
					strRights = strRights + mRs.getString("RIGHTS"); //$NON-NLS-1$
				}
				mRs.close();
				mStmt.close();
				mStmt = null;

				System.out.println("DBAccessEJB.getAllActionLinksString() 7079 : ");
				//Added by Saiprasad G. for overridding the rights from the user_rights_adhoc table on 15-03-19 START
				SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
				String currDateStr = sdfAppl.format(curr);

				userAdhocRightSql = "SELECT RIGHTS,RIGHTS_TYPE,SITE_CODE__LOGIN, EFF_FROM,VALID_UPTO FROM USER_RIGHTS_ADHOC WHERE OBJ_NAME =? AND USER_ID =?" ;
				pStmt=mConnection.prepareStatement(userAdhocRightSql);
				pStmt.setString(1, objName);
				pStmt.setString(2, userID);
				mRs=pStmt.executeQuery();
				while(mRs.next())
				{
					userRightType = mRs.getString("RIGHTS_TYPE");
					userAdhocRights = mRs.getString("RIGHTS");
					siteCodeLogin=E12GenericUtility.checkNull(mRs.getString("SITE_CODE__LOGIN"));
					effFromUserAdhoc = mRs.getTimestamp("EFF_FROM");
					validUptoAdhoc = mRs.getTimestamp("VALID_UPTO");
				}

				currDateTs = Timestamp.valueOf(genericUtility.getValidDateString(currDateStr,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())+ " 00:00:00.0");

				if(userRightType.equalsIgnoreCase("O"))
				{
					BaseLogger.log("3", null, null,"[DBAccessEJB]UserAdhocRights gets from the override 1 ["+userAdhocRights+"]");
					if((!currDateTs.before(effFromUserAdhoc)) && (!currDateTs.after(validUptoAdhoc)))
					{
						if(currSiteCode.equalsIgnoreCase(siteCodeLogin) || siteCodeLogin.length()==0)
						{
							strRights = userAdhocRights;
							BaseLogger.log("3", null, null,"[DBAccessEJB]RightStr gets from the overridd 1 ["+strRights+"]");
						}
					}
				}
				if(mRs!=null)
				{
					mRs.close();
					mRs = null;
				}
				if(pStmt!=null)
				{
					pStmt.close();
					pStmt = null;
				}
				//Added by Saiprasad G. for overridding the rights from the user_rights_adhoc table on 15-03-19 START
			}
			BaseLogger.log("3", userInfo, null,"Rights String for current Profile["+userInfo.getProfileId()+"] on current Object["+objName+"] :["+strRights+"]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			//Danish Friday, May 05, 2006 Adding if "A" / "E" exisits but "S" does not Exisits
			if ( strRights != null && strRights.length() > 0)
			{
				if ( ( strRights.indexOf("A") != -1 || strRights.indexOf("E") != -1 ) && strRights.indexOf("S") == -1 ) //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				{
					strRights = strRights+"S"; //$NON-NLS-1$
				}
				//Changed By Mahesh Patidar on 19/JUL/13 [to get obj_links as per strRights value]
				BaseLogger.log("3", userInfo, null,"RightsChar[" + strRights + "]");
				if(strRights.indexOf("*") != -1)
				{
					mQuery = "SELECT FORM_NO, LINK_TYPE, LINK_URI, LINK_TITLE FROM OBJ_LINKS WHERE OBJ_NAME='"+objName+"'"; //$NON-NLS-1$ //$NON-NLS-2$
				}
				else
				{
					String rightsChars = "";
					int count = 0;
					for(count = 0; count < strRights.length(); count++)
					{
						rightsChars = rightsChars + "'" + strRights.charAt(count)+"',";
					}
					rightsChars = rightsChars.substring(0,rightsChars.length()-1);
					BaseLogger.log("3", userInfo, null,"rightsChars[" + rightsChars + "]");
					mQuery = "SELECT FORM_NO, LINK_TYPE, LINK_URI, LINK_TITLE FROM OBJ_LINKS WHERE OBJ_NAME='"+objName+"' AND RIGHTS_CHAR IN (" + rightsChars + ") "; //$NON-NLS-1$ //$NON-NLS-2$
				}
				//Ended By Mahesh Patidar
				BaseLogger.log("3", userInfo, null,"mQuery :" +mQuery); //$NON-NLS-1$
				mStmt = mConnection.createStatement();
				mRs = mStmt.executeQuery(mQuery);
				while(mRs.next())
				{
					allActStrBuff.append("<LINKACTION>"); //$NON-NLS-1$
					allActStrBuff.append("<FORM_NO><![CDATA[").append(mRs.getString("FORM_NO")).append("]]></FORM_NO>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
					allActStrBuff.append("<LINK_TYPE><![CDATA[").append(mRs.getString("LINK_TYPE")).append("]]></LINK_TYPE>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
					allActStrBuff.append("<LINK_URI><![CDATA[").append(mRs.getString("LINK_URI")).append("]]></LINK_URI>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
					allActStrBuff.append("<LINK_TITLE><![CDATA[").append(mRs.getString("LINK_TITLE")).append("]]></LINK_TITLE>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
					allActStrBuff.append("</LINKACTION>"); //$NON-NLS-1$
				}
			}
			allActStrBuff.append("</OBJACTION>"); //$NON-NLS-1$
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException: DBAccess: getAllActionLinksString:"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccess: getAllActionLinksString:"  + e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(mStmt != null)
					{
						mStmt.close();
						mStmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getAllActionLinksString \n" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}

		}
		BaseLogger.log("2", userInfo, null,"Actions Link String=========\n"+allActStrBuff.toString()+"\n"); //$NON-NLS-1$ //$NON-NLS-2$
		return allActStrBuff.toString();

	}
	//Added by farooque on 13-May-2011[WS01SUN048][to get action data from obj_link]End

	//Added Priyanka B Start
	public String getAllActionLinksJson(String objName, UserInfoBean userInfo)throws RemoteException, ITMException
	{
		BaseLogger.log("2", userInfo, null,"Landed to Ejb json"); //$NON-NLS-1$
		Connection mConnection = null;
		Statement mStmt = null;
		ResultSet mRs = null;
		String  mQuery = null;
		String  mQuery1 = null;
		String strRights = ""; //$NON-NLS-1$
		String compName = ""; //$NON-NLS-1$
		String compType = ""; //$NON-NLS-1$
		String methodName = ""; //$NON-NLS-1$
		boolean isSysTypeOverwritten = false;
		JSONObject linkActionFinalObj =new JSONObject();

		//Commented and Added by Saiprasad on 02-04-19 to get rights from user_adhic_rights [START]
		PreparedStatement pStmt = null;
		String userAdhocRights = "",userAdhocRightSql = "",userRightType =" ";
		String userID = userInfo.getLoginCode();
		String currSiteCode = userInfo.getSiteCode();
	    String siteCodeLogin = "";
	    Timestamp effFromUserAdhoc = null,validUptoAdhoc = null,currDateTs = null;
	    Date curr= new Date();
	    E12GenericUtility genericUtility = new E12GenericUtility();
	    //Commented and Added by Saiprasad on 02-04-1902-04-19 to get rights from user_adhic_rights [END]

		try
		{
			ConnDriver mConnDriver = new ConnDriver();

			//Changes made by Gulzar on 10/10/13 to support multiDB connection : START
			String transDB = userInfo.getTransDB();
			//if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
			{
				mConnection = mConnDriver.getConnectDB(transDB); //$NON-NLS-1$
			}
			//Changes made by Gulzar on 10/10/13 to support multiDB connection : END

			if ( ("0").equals( userInfo.getUserLevel() ) ) //$NON-NLS-1$
			{
				BaseLogger.log("2", userInfo, null,"DBAcess if condition"); //$NON-NLS-1$
				strRights = "*"; //$NON-NLS-1$
			}
			else
			{
				BaseLogger.log("3", userInfo, null,"DBAcess else condition"); //$NON-NLS-1$
				//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
				//mQuery1 = "SELECT RIGHTS FROM USER_RIGHTS WHERE PROFILE_ID ='" + userInfo.getProfileId() + "'" + " AND OBJ_NAME ='"+objName+"'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				mQuery1 = "SELECT RIGHTS FROM USER_RIGHTS WHERE PROFILE_ID  IN " + E12GenericUtility.getFormattedProfileId(userInfo.getProfileId()) + " AND OBJ_NAME ='"+objName+"'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				BaseLogger.log("3", userInfo, null,"SQL Query :" + mQuery1); //$NON-NLS-1$
				mStmt = mConnection.createStatement();
				mRs = mStmt.executeQuery(mQuery1);
				while(mRs.next())
				{
					strRights = strRights + mRs.getString("RIGHTS"); //$NON-NLS-1$
				}
				mRs.close();
				mStmt.close();
				mStmt = null;

				System.out.println("DBAccessEJB.getAllActionLinksJson() : 7282");
				//Added by Saiprasad G. for overridding the rights from the user_rights_adhoc table on 15-03-19 START
				SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
				String currDateStr = sdfAppl.format(curr);
				userAdhocRightSql = "SELECT RIGHTS,RIGHTS_TYPE,SITE_CODE__LOGIN, EFF_FROM,VALID_UPTO FROM USER_RIGHTS_ADHOC WHERE OBJ_NAME =? AND USER_ID =?" ;
				pStmt=mConnection.prepareStatement(userAdhocRightSql);
				pStmt.setString(1, objName);
				pStmt.setString(2, userID);
				mRs=pStmt.executeQuery();
				while(mRs.next())
				{
					userRightType = mRs.getString("RIGHTS_TYPE");
					userAdhocRights = mRs.getString("RIGHTS");
					siteCodeLogin=E12GenericUtility.checkNull(mRs.getString("SITE_CODE__LOGIN"));
					effFromUserAdhoc = mRs.getTimestamp("EFF_FROM");
					validUptoAdhoc = mRs.getTimestamp("VALID_UPTO");
				}

				currDateTs = Timestamp.valueOf(genericUtility.getValidDateString(currDateStr,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())+ " 00:00:00.0");

				if(userRightType.equalsIgnoreCase("O"))
				{
					BaseLogger.log("3", null, null,"[DBAccessEJB]UserAdhocRights gets from the override 2 ["+userAdhocRights+"]");
					if((!currDateTs.before(effFromUserAdhoc)) && (!currDateTs.after(validUptoAdhoc)))
					{
						if(currSiteCode.equalsIgnoreCase(siteCodeLogin) || siteCodeLogin.length()==0)
						{
							strRights = userAdhocRights;
							BaseLogger.log("3", null, null,"[DBAccessEJB]RightStr gets from the overridd 2 ["+strRights+"]");
						}
					}
				}
				if(mRs!=null)
				{
					mRs.close();
					mRs = null;
				}
				if(pStmt!=null)
				{
					pStmt.close();
					pStmt = null;
				}
				//Added by Saiprasad G. for overridding the rights from the user_rights_adhoc table on 15-03-19 START
			}
			BaseLogger.log("3", userInfo, null,"Rights String for current Profile["+userInfo.getProfileId()+"] on current Object["+objName+"] :["+strRights+"]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			//Danish Friday, May 05, 2006 Adding if "A" / "E" exisits but "S" does not Exisits
			if ( strRights != null && strRights.length() > 0)
			{
				if ( ( strRights.indexOf("A") != -1 || strRights.indexOf("E") != -1 ) && strRights.indexOf("S") == -1 ) //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				{
					strRights = strRights+"S"; //$NON-NLS-1$
				}
				//Changed By Mahesh Patidar on 19/JUL/13 [to get obj_links as per strRights value]
				BaseLogger.log("3", userInfo, null,"RightsChar[" + strRights + "]");
				if(strRights.indexOf("*") != -1)
				{
					mQuery = "SELECT FORM_NO, FIELD_NAME, TARGET_OBJ_NAME,LINK_FORM_NAME,"
							+ "LINK_ARG,UPDATE_FLAG,RIGHTS_CHAR,IMAGE,"
							+ "SHOW_IN_PANEL,SHORTCUT_CHAR,AUTO_INVOKE,LINK_TYPE,"
							//Added by shrutika on 07-03-19 added new column linkId for If Process Trail is open then Process Trail link option should not display in Process Trail transaction.
							//Added by Pratheek on 24-06-19[ added a new column rec_specific in obj_actions for getting the record specific actions and links]-Start
							+ " LINK_URI, LINK_TITLE,SHOW_CONFIRM, DISPLAY_MODE, LINE_NO,LINK_ID,REC_SPECIFIC"	//Added By Pankaj T. on 03-01-19 added new column line_no for display links on homepage feed order by line_no
							+ " FROM OBJ_LINKS"
							+ " WHERE OBJ_NAME='"+objName+"' ORDER BY LINE_NO "; //Added By Pankaj T. on 03-01-19 added new column line_no for display links on homepage feed order by line_no //$NON-NLS-1$ //$NON-NLS-2$
				}
				else
				{
					String rightsChars = "";
					int count = 0;
					for(count = 0; count < strRights.length(); count++)
					{
						rightsChars = rightsChars + "'" + strRights.charAt(count)+"',";
					}
					rightsChars = rightsChars.substring(0,rightsChars.length()-1);
					BaseLogger.log("3", userInfo, null,"rightsChars[" + rightsChars + "]");
					//Changes made by Priyanka B. on 05/Nov/18 Start
					mQuery = "SELECT FORM_NO, LINK_TYPE, LINK_URI, LINK_TITLE,"
							+" FIELD_NAME,TARGET_OBJ_NAME,LINK_FORM_NAME,LINK_ARG,"
							+" UPDATE_FLAG,UPDATE_FLAG,RIGHTS_CHAR,IMAGE,"
							+" SHOW_IN_PANEL,SHORTCUT_CHAR,AUTO_INVOKE,SHOW_CONFIRM,"
							//Added by shrutika on 07-03-19 added new column linkId for If Process Trail is open then Process Trail link option should not display in Process Trail transaction.
							//Added by Pratheek on 24-06-19[ added a new column rec_specific in obj_actions for getting the record specific actions and links]-Start
							+" DISPLAY_MODE, LINE_NO,LINK_ID,REC_SPECIFIC  FROM OBJ_LINKS "	//Added By Pankaj T. on 03-01-19 added new column line_no for display links on homepage feed order by line_no
							+" WHERE OBJ_NAME='"+objName+"' AND RIGHTS_CHAR IN (" + rightsChars + ") ORDER BY LINE_NO "; 	//Added By Pankaj T. on 03-01-19 added new column line_no for display links on homepage feed order by line_no	//$NON-NLS-1$ //$NON-NLS-2$
				   //Changes made by Priyanka B. on 05/Nov/18 End
				}
				//Ended By Mahesh Patidar
				BaseLogger.log("3", userInfo, null,"mQuery :" +mQuery); //$NON-NLS-1$
				mStmt = mConnection.createStatement();
				mRs = mStmt.executeQuery(mQuery);
				BaseLogger.log("3", userInfo, null,"result of the query :" +mRs);
				JSONArray linkActionArray=new JSONArray();
				while(mRs.next())
				{
					String formNo=mRs.getString("FORM_NO");
					String linkType=mRs.getString("LINK_TYPE");
					String linkUrl=mRs.getString("LINK_URI");
					String linkTitle=mRs.getString("LINK_TITLE");

					String fieldName=mRs.getString("FIELD_NAME");
					String targetObjName=mRs.getString("TARGET_OBJ_NAME");
					String linkFormName=mRs.getString("LINK_FORM_NAME");
					String linkArg=mRs.getString("LINK_ARG");
					String updateFlag=mRs.getString("UPDATE_FLAG");
					String rightChar=mRs.getString("RIGHTS_CHAR");
					String image=mRs.getString("IMAGE");
					String showInPanel=mRs.getString("SHOW_IN_PANEL");
					String shortCutChar=mRs.getString("SHORTCUT_CHAR");
					String autoInvoke=mRs.getString("AUTO_INVOKE");
					String showConfirm = mRs.getString("SHOW_CONFIRM");
					String displayMode = mRs.getString("DISPLAY_MODE");
					//Added By Pankaj T. on 03-01-19 added new column line_no for display links on homepage feed order by line_no
					String lineNo = mRs.getString("LINE_NO");
					//Added by shrutika on 07-03-19 added new column linkId for If Process Trail is open then Process Trail link option should not display in Process Trail transaction.
					String linkId = mRs.getString("LINK_ID");
					//Added by Pratheek on 24-06-19[ added new column rec_specific to get the record specific actions and links ]-Start
					String recordSpecific = mRs.getString("REC_SPECIFIC");
					JSONObject linkObj = new JSONObject();
					linkObj.put("FormNo", checkNull(formNo));

					linkObj.put("FieldName", checkNull(fieldName));
					linkObj.put("TargetObject", checkNull(targetObjName));
					linkObj.put("LinkForm", checkNull(linkFormName));

					linkObj.put("LinkTitle", checkNull(linkTitle));
					linkObj.put("LinkUri", checkNull(linkUrl));
					linkObj.put("LinkType", checkNull(linkType));

					linkObj.put("LinkArg", checkNull(linkArg));
					linkObj.put("UpdateFlag", checkNull(updateFlag));
					linkObj.put("RightsChar", checkNull(rightChar));

					linkObj.put("Image", checkNull(image));
					linkObj.put("ShowInPanel", checkNull(showInPanel));
					linkObj.put("ShortcutChar", checkNull(shortCutChar));

					linkObj.put("AutoInvoke", checkNull(autoInvoke));
					linkObj.put("ShowConfirm", checkNull(showConfirm));
					linkObj.put("DisplayMode", checkNull(displayMode));
					//Added By Pankaj T. on 03-01-19 added new column line_no for display links on homepage feed order by line_no
					linkObj.put("LineNo", checkNull(lineNo));
					//Added by shrutika on 07-03-19 added new column linkId for If Process Trail is open then Process Trail link option should not display in Process Trail transaction.
					linkObj.put("linkId", checkNull(linkId));
					//Added by Pratheek on 24-06-19[ added new column rec_specific to get the record specific actions and links ]-Start
					linkObj.put("RecordSpecific", checkNull(recordSpecific));

					linkActionArray.put(linkObj);
				}
				linkActionFinalObj.put("LinkActions",linkActionArray);
			}
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException: DBAccess: getAllActionLinksJson:"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccess: getAllActionLinksJson:"  + e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(mStmt != null)
					{
						mStmt.close();
						mStmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getAllActionLinksJson \n" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}

		}
		BaseLogger.log("2", userInfo, null,"Actions Link json=========\n"+linkActionFinalObj.toString()+"\n"); //$NON-NLS-1$ //$NON-NLS-2$
		return linkActionFinalObj.toString();

	}
	//Added by Priyanka B END

	//Changes By Prajyot On 23-Sep-2011 [To reduce repeated lines of code] Starts
	private String getDesiredVal(String input) throws Exception
	{
		String retVal = null;
		try
		{
			if( ! ( input != null && ( input.equalsIgnoreCase("null") || input.trim().length() == 0 ) ) ) //$NON-NLS-1$
			{
				retVal = input;
			}
		}
		catch(Exception e)
		{
			throw e;
		}
		return retVal;
	}
	//Changes By Prajyot On 23-Sep-2011 [To To reduce repeated lines of code] Ends

	//public String getPrintStatus(String tranId , String objName, String argValue, String user, String chgTerm, String rePrint) throws ITMException
	public String getPrintStatus(String tranId , String objName, String argValue, String user, String chgTerm, String rePrint, String profileId, String transDB ) throws ITMException
	{
		//Changed By Umakanta on 25/AUG/2015 [ S15ESUN005 ][ To return "" for userlevel parameter ]Start
		//return getPrintStatus(  tranId ,  objName,  argValue,  user,  chgTerm,  rePrint, profileId, "", true );
		return getPrintStatus(  tranId ,  objName,  argValue,  user,  chgTerm,  rePrint, profileId, "", true ,"", transDB, null);
		//Changed By Umakanta on 25/AUG/2015 [ S15ESUN005 ][ To return "" for userlevel parameter ]End
	}
	//Changed By Umakanta on 25/AUG/2015 [ S15ESUN005 ][ To pass userlevel parameter   ]
	//public String getPrintStatus(String tranId , String objName, String argValue, String user, String chgTerm, String rePrint, String profileId, String reprintCntrlSQL, boolean isConfirmReprint ) throws ITMException
	public String getPrintStatus(String tranId , String objName, String argValue, String user, String chgTerm, String rePrint, String profileId, String reprintCntrlSQL, boolean isConfirmReprint, String userLevel, String transDB, UserInfoBean userInfoBean ) throws ITMException
	{
		BaseLogger.log("2", null, null,"DBAccessEJB CALLED "+objName); //$NON-NLS-1$
		String printStatus = ""; //$NON-NLS-1$
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pst = null;
		ResultSet rst = null;
		PreparedStatement maxCntPstmt = null;//Added By Umakanta Das on 29-JUN-2016
		ResultSet maxCntRs = null;//Added By Umakanta Das on 29-JUN-2016

		Calendar calendar = Calendar.getInstance();
		Timestamp currentTimestamp = new java.sql.Timestamp(calendar.getTime().getTime());

		int rptCnt = 0;
		int cnt = 0;
		int rptMaxCount = 0;

		TransIDGenerator tg = new TransIDGenerator("<Root></Root>", "SYSTEM", CommonConstants.DB_NAME); //$NON-NLS-1$ //$NON-NLS-2$
		try
		{
			conn = connDriver.getConnectDB(transDB); //$NON-NLS-1$

			//Commented and changes done by Gaurav Singh on 21-06-14 : [ Start ]
			//Get the keystring from transetup instead of hard code value
			//Commented and updated By Umakanta on 29/OCT/2015 [ S15ESUN005 ] [ To resolve generating Transaction ID issue ]Start
			String uniqueKeyLog = "";
			String uniqueKey = "";
			String tranIdCtrl = "";
			/*//String uniqueKey = tg.generateTranSeqID("RPTPRN", "", "seq10", conn); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			keyString = getDBColumnValue("TRANSETUP", "KEY_STRING", " REF_SER = 'RPTPRN'" );
			String uniqueKey = tg.generateTranSeqID("RPTPRN", "", keyString, conn);

			//String uniqueKeyLog = tg.generateTranSeqID("RPTPLG", "", "seq10", conn); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			keyString = getDBColumnValue("TRANSETUP", "KEY_STRING", " REF_SER = 'RPTPLG'" );
			String uniqueKeyLog = tg.generateTranSeqID("RPTPLG", "", keyString, conn);

			//Commented and changes done by Gaurav Singh on 21-06-14 [ End ]

			BaseLogger.log("3", null, null,"uniqueKey [ "+ uniqueKey +"]"); //$NON-NLS-1$ //$NON-NLS-2$
			BaseLogger.log("3", null, null,"uniqueKeyLog [ "+ uniqueKeyLog +"]"); //$NON-NLS-1$ //$NON-NLS-2$ */
			//Commented and updated By Umakanta on 29/OCT/2015 [ S15ESUN005 ] [ To resolve generating Transaction ID issue ]End
			int[] insertStatus ;
			int insertLogStatus = -1;
			ArrayList<String> reprintCntrlResulstAL = new ArrayList<String>();
			String printControl = checkNull( getPrintCtr( objName, transDB ) );
			reprintCntrlResulstAL = getReprintCntrlQSLResult( replaceArgValue( reprintCntrlSQL, argValue ), userInfoBean );

			//Added try/catch block by Ravindra C on 27-03-2020 for avoiding PARAMETER_VAL length exception - Start
			try
			{
				String getPrintStatus = "SELECT COUNT(1), MAX(REPRINT_CNT) FROM RPT_PRINT_LOG WHERE REPORT_NAME = ? AND PARAMETER_VAL = ? ";  //$NON-NLS-1$
				pstmt = conn.prepareStatement(getPrintStatus);
				if( reprintCntrlResulstAL.size() == 0 )
				{
					reprintCntrlResulstAL.add( argValue );
				}
				pstmt.setString(1, objName);
				//pstmt.setString(2, argValue);
				pstmt.setString(2, reprintCntrlResulstAL.get( 0 ) );
				rs = pstmt.executeQuery();

				if(rs.next())
				{
					cnt = rs.getInt(1);
					BaseLogger.log("3", null, null,"rs.getInt = "+rs.getInt(1)); //$NON-NLS-1$
				}
			}
			catch ( Exception e)
			{
				e.printStackTrace();
				BaseLogger.log("0", null, null,"In the GetPrintStatus Exception : ["+ e.getMessage() +"]");
			}
			//Added try/catch block by Ravindra C on 27-03-2020 for avoiding PARAMETER_VAL length exception - End

			if(cnt != 0)
			{
				rptCnt = rs.getInt(2);
				//Changed By Umakanta 29/JAN/2016 [ S15ISUN006 ][ To check if print Control Y in transetup table then call reprint control Functionality ]
				if ( "Y".equalsIgnoreCase( printControl ) )
				{
					//Added By Umakanta Das on 05-MAR-2016 [ S15ISUN006 ] [ To get user name from users against USER_ID__PRINT of RPT_PRINT_LOG table ] Start
					String printedByUsr = "";
					PreparedStatement prdStmt = null;
					ResultSet rSet = null;
					String userIdPrintStatus = " SELECT USERS.NAME AS USER_NAME from USERS  RIGHT OUTER JOIN  RPT_PRINT_LOG ON USERS.CODE = RPT_PRINT_LOG.USER_ID__PRINT "
							+" WHERE  RPT_PRINT_LOG.REPORT_NAME = ?  AND RPT_PRINT_LOG.PARAMETER_VAL = ? ORDER BY REPRINT_ON DESC " ;
					prdStmt = conn.prepareStatement( userIdPrintStatus );
					if( reprintCntrlResulstAL.size() == 0 )
					{
						reprintCntrlResulstAL.add( argValue );
					}
					prdStmt.setString(1, objName);
					prdStmt.setString(2, reprintCntrlResulstAL.get( 0 ) );
					rSet = prdStmt.executeQuery();
					if(rSet.next())
					{
						printedByUsr = checkNull( rSet.getString( "USER_NAME" ) );
					}

					rSet.close();
					rSet = null;
					prdStmt.close();
					prdStmt = null;
					//Added By Umakanta Das on 05-MAR-2016 [ S15ISUN006 ] [ To get user name from users against USER_ID__PRINT of RPT_PRINT_LOG table ] End

					if("N".equalsIgnoreCase(rePrint)) //$NON-NLS-1$
					{
						//Updated By Umakanta Das on 05-MAR-2016 [ S15ISUN006 ] [ To Pass user name with reprint status ]
						//printStatus = "E"; //$NON-NLS-1$
						printStatus = "E_"+ printedByUsr ;
					}
					else
					{
						boolean isExistPARAMVal = false;
						reprintCntrlResulstAL = getReprintCntrlQSLResult( replaceArgValue( reprintCntrlSQL, argValue ), userInfoBean );
						//changed by gayatri on 10-09-2013 [SY3ESUN003][to display report atleast once if m_reprint ="Y" and rights is other than "*" or "R"] start
						//Added by Pankaj T on 19-12-17 [changes for multitenancy]
						String userRightsStr = checkNull( getUserRights( objName , profileId, userInfoBean.toString()) );
						BaseLogger.log("3", null, null, "userRightsStr ["+userRightsStr+"] rePrint["+rePrint+"]" );
						//Changed By Umakanta 25/AUG/2015 [ S15ESUN005 ][ If user level equal to 0 then dont check rights and reprint report with confirmation and with out confirmation as per reprint value ]Start
						/*if("Y".equalsIgnoreCase(rePrint) && userRightsStr != null && userRightsStr.indexOf("*") == -1 && userRightsStr.indexOf("R") == -1)
						{
							printStatus = "E";
							return printStatus;
						}
						else if ( "Y".equalsIgnoreCase(rePrint) && ( userRightsStr.indexOf( "*" ) == -1 && userRightsStr.indexOf( "R" ) == -1 ) )
						{
							isExistPARAMVal = isExistPARAMVal( reprintCntrlResulstAL, objName );
							if( isExistPARAMVal )
							{
								printStatus = "E";
		                        return printStatus;
							}
						}
						else if ( isConfirmReprint == false && "Y".equalsIgnoreCase( rePrint ) )
						{
							printStatus = "W";
	                        return printStatus;
						}*/

						int urs_lvl = Integer.parseInt( ( checkNull( userLevel ).length() == 0 ) ? "-1" : checkNull( userLevel )  );
						if( urs_lvl != 0 )
						{
							if("Y".equalsIgnoreCase(rePrint) && userRightsStr != null && userRightsStr.indexOf("*") == -1 && userRightsStr.indexOf("R") == -1)
							{
								//Updated By Umakanta Das on 05-MAR-2016 [ S15ISUN006 ] [ To Pass user name with reprint status ]
								//printStatus = "E";
								printStatus = "E_"+ printedByUsr ;
								return printStatus;
							}
							else if ( "Y".equalsIgnoreCase(rePrint) && ( userRightsStr.indexOf( "*" ) == -1 && userRightsStr.indexOf( "R" ) == -1 ) )
							{
								//Changed by Pankaj T on 04-01-18 [changes for multitenancy]
								isExistPARAMVal = isExistPARAMVal( reprintCntrlResulstAL, objName, userInfoBean );
								if( isExistPARAMVal )
								{
									//Updated By Umakanta Das on 05-MAR-2016 [ S15ISUN006 ] [ To Pass user name with reprint status ]
									//printStatus = "E";
									printStatus = "E_"+ printedByUsr ;
									return printStatus;
								}
							}
							else if ( checkNull( rePrint ).length() == 0 )
							{
								if ( userRightsStr.indexOf( "*" ) != -1 || userRightsStr.indexOf( "R" ) != -1 )
								{
									printStatus = "S";
									return printStatus;
								}
								else
								{
									//Updated By Umakanta Das on 05-MAR-2016 [ S15ISUN006 ] [ To Pass user name with reprint status ]
									//printStatus = "E";
									printStatus = "E_"+ printedByUsr ;
									return printStatus;
								}
							}
							else
							{
								BaseLogger.log("3", null, null,"DBAccessEjb::getPrintStatus::urs_lvl != 0::checkNull( rePrint ).length() == 0::Else Part has Printed");
							}
						}
						else
						{
							if ( checkNull( rePrint ).length() == 0 )
							{
								printStatus = "S";
								return printStatus;
							}
							else
							{
								BaseLogger.log("3", null, null,"DBAccessEjb::getPrintStatus::urs_lvl == 0::Else Part has Printed");
							}
						}
						if ( isConfirmReprint == false && "Y".equalsIgnoreCase( rePrint ) )
						{
							//Updated By Umakanta Das on 05-MAR-2016 [ S15ISUN006 ] [ To Pass user name with reprint status ]
							//printStatus = "W";
							printStatus = "W_"+ printedByUsr;
							return printStatus;
						}
						else
						{
							BaseLogger.log("3", null, null,"DBAccessEjb::getPrintStatus::isConfirmReprint == false and rePrint not equal to Y::Else Part has Printed");
						}
						//Changed By Umakanta 25/AUG/2015 [ S15ESUN005 ][ If user level equal to 0 then dont check rights and reprint report with confirmation and with out confirmation as per reprint value ]End
						//changed by gayatri on 10-09-2013 [SY3ESUN003][to display report atleast once if m_reprint ="Y" and rights is other than "*" or "R"] end
						//String tranIdCtrl = ""; //$NON-NLS-1$
						//Added By Umakanta 20/JULY/2015 [SY3ESUN003][ To Handle IndexOutOfBoundsException ]Start
						if( isExistPARAMVal != true && reprintCntrlResulstAL.size() == 0 )
						{
							reprintCntrlResulstAL.add( argValue );
						}
						//Added By Umakanta 20/JULY/2015 [SY3ESUN003][ To Handle IndexOutOfBoundsException ]End
						//UPDATE REPRINT_CNT IN RPT_PRINT_LOG
						//Commented By Umakanta das on 29-JUN-2016[to resolve TranIDCtrl issue]Start
						/*String getTranIdCtrl = "SELECT TRAN_ID__CTRL FROM RPT_PRINT_LOG WHERE REPORT_NAME = ? AND PARAMETER_VAL = ? "; //$NON-NLS-1$
						pst = conn.prepareStatement(getTranIdCtrl);
						pst.setString(1, objName);
						//pst.setString(2, argValue);
						pst.setString(2, reprintCntrlResulstAL.get( 0 ));
						rst = pst.executeQuery();
						if(rst.next())
						{
							tranIdCtrl = rst.getString(1);
						}*/
						//Commented By Umakanta das on 29-JUN-2016[to resolve TranIDCtrl issue]End
						pst = null;
						//updated By Umakanta on 29/OCT/2015 [ S15ESUN005 ] [ To check condition if rePrint value Y then  genarate tran ID and insert data in RPT_PRINT_LOG table ]Start
						if ( "Y".equalsIgnoreCase( rePrint )  )
						{
							//Commented By Umakanta Das on 05-JULY-2016[ To resolve reprint count range argument.]

							/*String keyStringLog = getDBColumnValue( "TRANSETUP", "KEY_STRING", " REF_SER = 'RPTPLG'" );

							String updateReprintLog = "INSERT INTO RPT_PRINT_LOG (TRAN_ID, REPORT_NAME, PARAMETER_VAL, USER_ID__PRINT, REPRINT_ON, REPRINT_CNT, TRAN_ID__CTRL) VALUES(?, ?, ?, ?, ?, ?, ?)"; //$NON-NLS-1$
							pst = conn.prepareStatement(updateReprintLog);
							pst.setString(1,uniqueKeyLog  );
							pst.setString(2,objName );
							pst.setString(3,argValue );
							pst.setString(4,user );
							pst.setTimestamp(5,currentTimestamp);
							pst.setInt(6,rptCnt+1 );
							pst.setString(7,tranIdCtrl );
							insertStatus = pst.executeUpdate();
							BaseLogger.log("3", null, null,"insertStatus = ["+insertStatus+"]"); //$NON-NLS-1$ //$NON-NLS-2$
							if(insertStatus!= -1)
							{
								printStatus = "W"; //$NON-NLS-1$
							}
							rptCnt = rptCnt+1;
							//Commented By Umakanta 20/JULY/2015 [SY3ESUN003][ To Handle IndexOutOfBoundsException ]Start
							if( isExistPARAMVal != true && reprintCntrlResulstAL.size() == 0 )
							{
								reprintCntrlResulstAL.add( argValue );
							}
							//Commented By Umakanta 20/JULY/2015 [SY3ESUN003][ To Handle IndexOutOfBoundsException ]End
							for ( String result : reprintCntrlResulstAL )
							{
								//updated By Umakanta on 02/NOV/2015 [ S15ESUN005 ] [ To create Tran ID uniquely ]Start
								uniqueKeyLog = tg.generateTranSeqID( "RPTPLG", "", keyStringLog, conn );
								BaseLogger.log("3", null, null,"uniqueKeyLog [ "+ uniqueKeyLog +"]");
								//updated By Umakanta on 02/NOV/2015 [ S15ESUN005 ] [ To create Tran ID uniquely ]End
								pst.setString(1,uniqueKeyLog  );
								pst.setString(2,objName );
								pst.setString(3,result );
								pst.setString(4,user );
								pst.setTimestamp(5,currentTimestamp);
								pst.setInt(6,rptCnt );
								pst.setString(7,tranIdCtrl );
								pst.addBatch();
							}
							int[] insrtLogStatus = pst.executeBatch();
							BaseLogger.log("3", null, null,"insertStatus = ["+insrtLogStatus.length+"]");
							if ( insrtLogStatus.length > 0  && reprintCntrlSQL.length() == 0 )
							{
								//Updated By Umakanta Das on 05-MAR-2016 [ S15ISUN006 ] [ To Pass user name with reprint status ]
								//printStatus = "W";
								printStatus = "W_"+ printedByUsr;
							}
							else
							{
								printStatus = "S";
							}*/
							//Commented By Umakanta Das on 05-JULY-2016[ To resolve reprint count range argument.]End

							//Added by Umakanta Das on 05-JULY-2016[ To resolve reprint count range argument]Start
							for ( String result : reprintCntrlResulstAL )
							{
								String paramVal = "";
								String cntSql = "SELECT PARAMETER_VAL FROM RPT_PRINT_CTRL WHERE REPORT_NAME = ? AND PARAMETER_VAL = ? ";  //$NON-NLS-1$
								pstmt = conn.prepareStatement( cntSql );
								if( reprintCntrlResulstAL.size() == 0 )
								{
									reprintCntrlResulstAL.add( argValue );
								}
								pstmt.setString(1, objName);
								pstmt.setString(2, result );
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									paramVal = checkNull( rs.getString( "PARAMETER_VAL" ) );
								}
								if( !paramVal.equalsIgnoreCase( checkNull( result ) ) )
								{
									String keyStringCtrl = getDBColumnValue( "TRANSETUP", "KEY_STRING", " REF_SER = 'RPTPRN'", userInfoBean.getTransDB() );
									BaseLogger.log("3", null, null,"INSERT STATEMENT");
									String insertReportData = "INSERT INTO RPT_PRINT_CTRL (TRAN_ID, REPORT_NAME, PARAMETER_VAL, USER_ID, PRINTED_ON, PRINTED_TERM) VALUES(?, ?, ?, ?, ?, ?)"; //$NON-NLS-1$
									BaseLogger.log("3", null, null,"insertReportData = ["+insertReportData+"]");
									pst = conn.prepareStatement( insertReportData );
									uniqueKey = tg.generateTranSeqID( "RPTPRN", "", keyStringCtrl, conn );
									BaseLogger.log("3", null, null,"uniqueKey [ "+ uniqueKey +"]");
									pst.setString(1, uniqueKey );
									pst.setString(2, objName );
									pst.setString(3, result );
									pst.setString(4, user );
									pst.setTimestamp(5, currentTimestamp);
									pst.setString(6, chgTerm );
									pst.addBatch();
									insertStatus = pst.executeBatch();

									pst = null;
									String insertReportLog = "INSERT INTO RPT_PRINT_LOG (TRAN_ID, REPORT_NAME, PARAMETER_VAL, USER_ID__PRINT, REPRINT_ON, REPRINT_CNT, TRAN_ID__CTRL) VALUES(?, ?, ?, ?, ?, ?, ?)"; //$NON-NLS-1$
									BaseLogger.log("3", null, null,"insertReportLog = ["+insertReportLog+"]");
									pst = conn.prepareStatement( insertReportLog );

									String getTranIdCtrl = " SELECT TRAN_ID FROM RPT_PRINT_CTRL WHERE REPORT_NAME = ? AND PARAMETER_VAL = ? " ;
									maxCntPstmt = conn.prepareStatement( getTranIdCtrl );
									maxCntPstmt.setString( 1, objName );
									maxCntPstmt.setString( 2, result );
									maxCntRs = maxCntPstmt.executeQuery();
									if( maxCntRs.next() )
									{
										tranIdCtrl = maxCntRs.getString("TRAN_ID");
									}

									if( maxCntRs != null )
									{
										maxCntRs.close();
										maxCntRs = null;
									}
									if( maxCntPstmt != null )
									{
										maxCntPstmt.close();
										maxCntPstmt = null;
									}

									String keyStringLog = getDBColumnValue( "TRANSETUP", "KEY_STRING", " REF_SER = 'RPTPLG'", transDB );
									uniqueKeyLog = tg.generateTranSeqID( "RPTPLG", "", keyStringLog, conn );
									BaseLogger.log("3", null, null,"uniqueKeyLog [ "+ uniqueKeyLog +"]");
									pst.setString( 1, uniqueKeyLog  );
									pst.setString( 2, objName );
									pst.setString( 3, result );
									pst.setString( 4, user );
									pst.setTimestamp( 5, currentTimestamp);
									pst.setInt( 6, 1 );
									pst.setString( 7, tranIdCtrl );
									pst.addBatch();
									int[] insrtLogStatus = pst.executeBatch();
									BaseLogger.log("3", null, null,"insrtLogStatus = ["+insrtLogStatus+"]");
									if ( insrtLogStatus.length > 0  && reprintCntrlSQL.length() == 0 )
									{
										printStatus = "W_"+ printedByUsr;
									}
									else
									{
										printStatus = "S";
									}
								}
								else
								{
									String keyStringLog = getDBColumnValue( "TRANSETUP", "KEY_STRING", " REF_SER = 'RPTPLG'", transDB );

									String updateReprintLog = "INSERT INTO RPT_PRINT_LOG (TRAN_ID, REPORT_NAME, PARAMETER_VAL, USER_ID__PRINT, REPRINT_ON, REPRINT_CNT, TRAN_ID__CTRL) VALUES(?, ?, ?, ?, ?, ?, ?)"; //$NON-NLS-1$
									pst = conn.prepareStatement(updateReprintLog);
									String getPrintCntSql = "SELECT MAX(REPRINT_CNT) AS MAX_COUNT FROM RPT_PRINT_LOG WHERE REPORT_NAME = ? AND PARAMETER_VAL = ? ";  //$NON-NLS-1$
									maxCntPstmt = conn.prepareStatement( getPrintCntSql );
									maxCntPstmt.setString( 1, objName );
									maxCntPstmt.setString( 2, result );
									maxCntRs = maxCntPstmt.executeQuery();
									if( maxCntRs.next() )
									{
										rptMaxCount = maxCntRs.getInt( "MAX_COUNT" );
									}

									if( maxCntRs != null )
									{
										maxCntRs.close();
										maxCntRs = null;
									}
									if( maxCntPstmt != null )
									{
										maxCntPstmt.close();
										maxCntPstmt = null;
									}
									rptMaxCount = rptMaxCount+1;
									String getTranIdCtrl = " SELECT RPT_PRINT_CTRL.TRAN_ID as TRAN_ID from RPT_PRINT_CTRL RPT_PRINT_CTRL INNER JOIN RPT_PRINT_LOG RPT_PRINT_LOG ON "
											+" RPT_PRINT_CTRL.PARAMETER_VAL = RPT_PRINT_LOG.PARAMETER_VAL WHERE RPT_PRINT_LOG.REPORT_NAME = ? AND RPT_PRINT_LOG.PARAMETER_VAL = ? " ;
									maxCntPstmt = conn.prepareStatement( getTranIdCtrl );
									maxCntPstmt.setString( 1, objName );
									maxCntPstmt.setString( 2, result );
									maxCntRs = maxCntPstmt.executeQuery();
									if( maxCntRs.next() )
									{
										tranIdCtrl = maxCntRs.getString("TRAN_ID");
									}

									if( maxCntRs != null )
									{
										maxCntRs.close();
										maxCntRs = null;
									}
									if( maxCntPstmt != null )
									{
										maxCntPstmt.close();
										maxCntPstmt = null;
									}
									uniqueKeyLog = tg.generateTranSeqID( "RPTPLG", "", keyStringLog, conn );
									BaseLogger.log("3", null, null,"uniqueKeyLog [ "+ uniqueKeyLog +"]");
									pst.setString(1,uniqueKeyLog  );
									pst.setString(2,objName );
									pst.setString(3,result );
									pst.setString(4,user );
									pst.setTimestamp(5,currentTimestamp);
									pst.setInt(6, rptMaxCount );
									pst.setString(7,tranIdCtrl );
									pst.addBatch();
									int[] insrtLogStatus = pst.executeBatch();
									BaseLogger.log("3", null, null,"insertStatus = ["+insrtLogStatus.length+"]");
									if ( insrtLogStatus.length > 0  && reprintCntrlSQL.length() == 0 )
									{
										printStatus = "W_"+ printedByUsr;
									}
									else
									{
										printStatus = "S";
									}
								}
							}
							//Added by Umakanta Das on 05-JULY-2016[ To resolve reprint count range argument]End
						}
						else
						{
							printStatus = "S";
						}
						//updated By Umakanta on 29/OCT/2015 [ S15ESUN005 ] [ To check condition if rePrint value Y then  genarate tran ID and insert data in RPT_PRINT_LOG table ]End
					}
				}
			}
			else
			{
				//updated By Umakanta on 29/OCT/2015 [ S15ESUN005 ] [ To check condition if rePrint value Y then  genarate tran ID and insert data in RPT_PRINT_LOG table ]Start
				//Changed By Umakanta 29/JAN/2016 [ S15ISUN006 ][ To check if print Control Y in transetup table then call reprint control Functionality ]
				//if ( "Y".equalsIgnoreCase( rePrint ) )
				if ( "Y".equalsIgnoreCase( printControl ) )
				{
					//updated By Umakanta on 02/NOV/2015 [ S15ESUN005 ] [ To create Tran ID uniquely ]Start
					String keyStringCtrl = getDBColumnValue( "TRANSETUP", "KEY_STRING", " REF_SER = 'RPTPRN'", transDB );
					String keyStringLog = getDBColumnValue( "TRANSETUP", "KEY_STRING", " REF_SER = 'RPTPLG'", transDB );
					//updated By Umakanta on 02/NOV/2015 [ S15ESUN005 ] [ To create Tran ID uniquely ]End

					// INSERT INTO RPT_PRINT_CTRL
					BaseLogger.log("3", null, null,"INSERT STATEMENT"); //$NON-NLS-1$
					String insertReportData = "INSERT INTO RPT_PRINT_CTRL (TRAN_ID, REPORT_NAME, PARAMETER_VAL, USER_ID, PRINTED_ON, PRINTED_TERM) VALUES(?, ?, ?, ?, ?, ?)"; //$NON-NLS-1$
					BaseLogger.log("3", null, null,"insertReportData = ["+insertReportData+"]"); //$NON-NLS-1$ //$NON-NLS-2$
					pst = conn.prepareStatement( insertReportData );
					/*pst.setString(1,uniqueKey );
					pst.setString(2,objName );
					pst.setString(3,argValue );
					pst.setString(4,user );
					pst.setTimestamp(5,currentTimestamp);
					pst.setString(6,chgTerm );
					insertStatus = pst.executeUpdate();*/
					for( String result : reprintCntrlResulstAL )
					{
						//updated By Umakanta on 02/NOV/2015 [ S15ESUN005 ] [ To create Tran ID uniquely ]Start
						uniqueKey = tg.generateTranSeqID( "RPTPRN", "", keyStringCtrl, conn );
						BaseLogger.log("3", null, null,"uniqueKey [ "+ uniqueKey +"]");
						//updated By Umakanta on 02/NOV/2015 [ S15ESUN005 ] [ To create Tran ID uniquely ]End
						pst.setString(1,uniqueKey );
						pst.setString(2,objName );
						pst.setString(3,result );
						pst.setString(4,user );
						pst.setTimestamp(5,currentTimestamp);
						pst.setString(6,chgTerm );
						pst.addBatch();
					}
					insertStatus = pst.executeBatch();
					BaseLogger.log("3", null, null,"insertStatus = ["+insertStatus.length+"]"); //$NON-NLS-1$ //$NON-NLS-2$
					// INSERT INTO RPT_PRINT_LOG
					pst = null;

					String insertReportLog = "INSERT INTO RPT_PRINT_LOG (TRAN_ID, REPORT_NAME, PARAMETER_VAL, USER_ID__PRINT, REPRINT_ON, REPRINT_CNT, TRAN_ID__CTRL) VALUES(?, ?, ?, ?, ?, ?, ?)"; //$NON-NLS-1$
					BaseLogger.log("3", null, null,"insertReportLog = ["+insertReportLog+"]"); //$NON-NLS-1$ //$NON-NLS-2$
					pst = conn.prepareStatement( insertReportLog );
					/*pst.setString(1,uniqueKeyLog  );
					pst.setString(2,objName );
					pst.setString(3,argValue );
					pst.setString(4,user );
					pst.setTimestamp(5,currentTimestamp);
					pst.setInt(6,0 );
					pst.setString(7,uniqueKey );
					insertLogStatus = pst.executeUpdate();*/

					for( String result : reprintCntrlResulstAL )
					{
						//Updated By Umakanta das on 29-JUN-2016[to resolve TranIDCtrl issue]Start
						//String getTranIdCtrl = "SELECT TRAN_ID__CTRL FROM RPT_PRINT_LOG WHERE REPORT_NAME = ? AND PARAMETER_VAL = ? ";
						String getTranIdCtrl = " SELECT TRAN_ID FROM RPT_PRINT_CTRL WHERE REPORT_NAME = ? AND PARAMETER_VAL = ? " ;
						maxCntPstmt = conn.prepareStatement( getTranIdCtrl );
						maxCntPstmt.setString( 1, objName );
						maxCntPstmt.setString( 2, result );
						maxCntRs = maxCntPstmt.executeQuery();
						if( maxCntRs.next() )
						{
							tranIdCtrl = maxCntRs.getString("TRAN_ID");
						}

						if( maxCntRs != null )
						{
							maxCntRs.close();
							maxCntRs = null;
						}
						if( maxCntPstmt != null )
						{
							maxCntPstmt.close();
							maxCntPstmt = null;
						}
						//Updated By Umakanta das on 29-JUN-2016[to resolve TranIDCtrl issue]End

						//updated By Umakanta on 02/NOV/2015 [ S15ESUN005 ] [ To create Tran ID uniquely ]Start
						uniqueKeyLog = tg.generateTranSeqID( "RPTPLG", "", keyStringLog, conn );
						BaseLogger.log("3", null, null,"uniqueKeyLog [ "+ uniqueKeyLog +"]");
						//updated By Umakanta on 02/NOV/2015 [ S15ESUN005 ] [ To create Tran ID uniquely ]End
						pst.setString( 1, uniqueKeyLog  );
						pst.setString( 2, objName );
						pst.setString( 3, result );
						pst.setString( 4, user );
						pst.setTimestamp( 5, currentTimestamp);
						//Updated By Umakanta Das on 05-MAR-2016 [ S15ISUN006 ] [ To resolve reprint count issue ]
						//pst.setInt( 6, 0 );
						pst.setInt( 6, 1 );
						//pst.setString( 7, uniqueKey );
						pst.setString( 7, tranIdCtrl );
						pst.addBatch();
					}
					int[] insrtLogStatus = pst.executeBatch();
					BaseLogger.log("3", null, null,"insrtLogStatus = ["+insrtLogStatus.length+"]"); //$NON-NLS-1$ //$NON-NLS-2$
					printStatus = "S"; //$NON-NLS-1$
				}
				else
				{
					printStatus = "S";
				}
				//updated By Umakanta on 29/OCT/2015 [ S15ESUN005 ] [ To check condition if rePrint value Y then  genarate tran ID and insert data in RPT_PRINT_LOG table ]End
			}
			if(conn != null)
			{
				conn.commit();
			}
		}
		// Added By Umakanta on 14/JULY/2015 [ SY3ESUN003 ] [ To handle sql Exception and send message to client side ]Start
		catch (SQLException slqEx)
		{
			slqEx.printStackTrace();
			try
			{
				BaseLogger.log("3", null, null,"Sql exception");
				conn.rollback();
				printStatus = "INC_RPNT_SQL_E";
				return printStatus;
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
			//Commented By Ravindra C on 25-03-2020 to avoid error while user pass lage number of pophelps.
			//throw new ITMException( slqEx );
		}
		// Added By Umakanta on 14/JULY/2015 [ SY3ESUN003 ] [ To handle sql Exception and send message to client side ]End
		catch (Exception e)
		{
			e.getStackTrace();
			try
			{
				BaseLogger.log("3", null, null,"inside exception"); //$NON-NLS-1$
				printStatus = "E"; //$NON-NLS-1$
				conn.rollback();
			}
			catch( Exception le )
			{
				le.printStackTrace();
				throw new ITMException(le);
			}
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( conn != null )
				{
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					if( pst != null )
					{
						pst.close();
						pst = null;
					}
					if( maxCntRs != null )
					{
						maxCntRs.close();
						maxCntRs = null;
					}
					if( maxCntPstmt != null )
					{
						maxCntPstmt.close();
						maxCntPstmt = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return printStatus;
	}

	/**
	 *
	 * This method check the two condition depend upone given values.<BR>
	 * 1. If <code> SYSTEM_EVENTS</code> does not entry of <code>'pre_validate'</code> event <BR>
	 * for current given objName value then check 2nd condition otherwise return <code>USR_SITE_S</code>.<BR>
	 *
	 * 2. If <code>USER_SITE</code> does not entry of given site code values then return <code>USR_SITE_E</code>.
	 * Otherwise return <code>USR_SITE_S<code>.
	 *
	 * @param siteCodes the site code values.
	 * @param objName the object name.
	 * @return the value of above conditions.
	 */
	/*public String getUserSiteStatus( String siteCodes, String objName )
	{
		String userSiteStatus = "";
		StringBuilder buildInQuery = new StringBuilder();
		String[] siteCodeSplt = siteCodes.split( "," );
		for ( String siteCode : siteCodeSplt )
		{
			buildInQuery.append( "'").append( siteCode ).append( "', " );
		}
		String inValues = buildInQuery.toString();
		BaseLogger.log("3", null, null, " B4 substring last value inValues ["+inValues+"]" );
		inValues = inValues.substring(0, ( inValues.lastIndexOf(",") ) );
		BaseLogger.log("3", null, null, " after substring last value inValues ["+inValues+"]" );
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			conn = connDriver.getConnectDB("Driver");
			String queryRPTPrintLog = "SELECT EVENT_CODE FROM SYSTEM_EVENTS WHERE OBJ_NAME = ? AND EVENT_CODE = ?";
			pstmt = conn.prepareStatement( queryRPTPrintLog );
			pstmt.setString(1, objName );
			pstmt.setString(2, "pre_validate" );
			rs = pstmt.executeQuery();
			if( !rs.next() )
			{
				pstmt = null;
				rs = null;
				queryRPTPrintLog = " SELECT * FROM USER_SITE WHERE SITE_CODE IN(?)";
				pstmt = conn.prepareStatement( queryRPTPrintLog );
				pstmt.setString(1, inValues );
				rs = pstmt.executeQuery();
				if( rs.next() )
				{
					userSiteStatus = "USR_SITE_E"; // User site error
				}
				else
				{
					userSiteStatus = "USR_SITE_S"; // User site success
				}
			}
			else
			{
				userSiteStatus = "USR_SITE_S"; // User site success
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( conn != null )
				{
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return userSiteStatus;
	}*/
	/**
	 * This method check the value in <code>RPT_PRINT_LOG</code> table with given list of reprint sql result.
	 *
	 * @param reprintCntrlResulstAL the reprint control sql value list
	 * @return <code>true</code> if exist the given values in RPT_PRINT_LOG table otherwise <code>false</code>
	 */
	 //Changed by Pankaj T on 04-01-18 [changes for multitenancy]
	private boolean isExistPARAMVal( ArrayList<String> reprintCntrlResulstAL, String objName, UserInfoBean userInfo )
	{
		boolean isExistPARAMVal = false;
		StringBuilder buildInQuery = new StringBuilder();
		for ( String result : reprintCntrlResulstAL )
		{
			buildInQuery.append( "'").append( result ).append( "', " );
		}
		String inValues = buildInQuery.toString();
		BaseLogger.log("2", userInfo, null, " B4 substring last value inValues ["+inValues+"]" );
		inValues = inValues.substring(0, ( inValues.lastIndexOf(",") ) );
		BaseLogger.log("2", userInfo, null, " after substring last value inValues ["+inValues+"]" );
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String transDB = "";
		try
		{
			//Changed by Pankaj T on 04-01-18 [changes for multitenancy]
			transDB = userInfo.getTransDB();
			conn = connDriver.getConnectDB(transDB);
			String queryRPTPrintLog = "SELECT * FROM RPT_PRINT_LOG WHERE REPORT_NAME ='"+objName+"' AND PARAMETER_VAL IN ("+inValues+")";
			pstmt = conn.prepareStatement( queryRPTPrintLog );
			rs = pstmt.executeQuery();
			isExistPARAMVal = rs.next();
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( conn != null )
				{
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return isExistPARAMVal;
	}

	/**
	 * This method replace the argument value of reprint control sql.<BR>
	 * like following.<BR>
	 * The current sql <code>SELECT USER_ID FROM USER_SITE WHERE USER_ID=:userCode and PROFILE_ID=:profileID </code> <BR>
	 * After replaced the argument value sql<BR>
	 * <code>SELECT USER_ID FROM USER_SITE WHERE USER_ID='E06531' and PROFILE_ID='FLT' </code>
	 *
	 *
	 * @param reprintCntrlSQL the reprint control SQL.
	 * @param argumentXML the argument values in XML format
	 * @return the replaced sql
	 * @throws ITMException
	 */
	private String replaceArgValue( String reprintCntrlSQL, String argumentXML ) throws ITMException
	{
		BaseLogger.log("2", null, null, " DBAccessEJB :: replaceArgValue reprintCntrlSQL["+reprintCntrlSQL+"] \n argumentXML["+argumentXML+"]" );
		String returnSQL = "" ;
		argumentXML = checkNull(argumentXML);
		if ( argumentXML.indexOf( "<Arguments>") == -1 )
		{
			return returnSQL;
		}
		E12GenericUtility utility = new E12GenericUtility();
		Document dom = utility.parseString( argumentXML );
		NodeList argumentsNL = dom.getElementsByTagName( "Arguments" ).item(0).getChildNodes();

		int argsLen = argumentsNL.getLength();
		LinkedHashMap<String, String> argsMap = new LinkedHashMap<String, String>();

		for( int index = 0; index < argsLen; index ++ )
		{
			Node node = argumentsNL.item(index);
			if( node != null )
			{
				String nodeName = node.getNodeName();
				String nodeVal = "";
				if( node.hasChildNodes() )
				{
					nodeVal = node.getFirstChild().getNodeValue();
				}
				argsMap.put(nodeName, nodeVal);
			}
		}
		Set<String> fieldKeys = argsMap.keySet();
		Iterator<String> itrt = fieldKeys.iterator();
		while ( itrt.hasNext() )
		{
			String fieldKey = (String) itrt.next();
			String fieldVal = argsMap.get(fieldKey);
			if( reprintCntrlSQL.contains( fieldKey ) )
			{
				//reprintCntrlSQL = reprintCntrlSQL.replace( ( "=:"+fieldKey ), " IN ( '"+fieldVal+"' )" );
				//Added By Umakanta Das On 14/JULY/2015 [ SY3ESUN003 ] [ To change replace logic of  reprint cntrl sql ] Start
				//reprintCntrlSQL = reprintCntrlSQL.replace( ( ":"+fieldKey ), " '"+fieldVal+"' " );
				//Added By Umakanta Das On 14/JULY/2015 [ SY3ESUN003 ] [ To change replace logic of  reprint cntrl sql ] End

				//Added By Umakanta Das On 24/JULY/2015 [ SY3ESUN003 ] [ To change replace logic of  reprint cntrl sql for parsing date ] Start
				if ( fieldVal.startsWith( "TO_DATE" ) )
				{
					reprintCntrlSQL = reprintCntrlSQL.replace( ( ":"+fieldKey ), fieldVal );
				}
				else
				{
					reprintCntrlSQL = reprintCntrlSQL.replace( ( ":"+fieldKey ), " '"+fieldVal+"' " );
				}
				//Added By Umakanta Das On 24/JULY/2015 [ SY3ESUN003 ] [ To change replace logic of  reprint cntrl sql for parsing date ] End
			}
		}
		BaseLogger.log("2", null, null, " After replace reprint control SQL ["+reprintCntrlSQL+"]" );
		argsMap = null;
		return reprintCntrlSQL;
	}

	/**
	 * This method execute sql and return the result with given reprint control SQL
	 *
	 * @param reprintCntrlSQL the reprint control SQL.
	 * @return the sql result.
	 */
	private ArrayList getReprintCntrlQSLResult( String reprintCntrlSQL, UserInfoBean userInfoBean )
	{
		BaseLogger.log("2", userInfoBean, null, " DBAccessEJB :: getReprintCntrlQSLResult reprintCntrlSQL["+reprintCntrlSQL+"] " );
		ArrayList<String> resultAL = new ArrayList<String>();
		reprintCntrlSQL = checkNull(reprintCntrlSQL);
		if( reprintCntrlSQL.length() <= 0 )
		{
			return resultAL;
		}
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			//Added by Pankaj T on 19-12-17 [changes for multitenancy]
			String transDB = userInfoBean.getTransDB();
			conn = connDriver.getConnectDB(transDB);

			pstmt = conn.prepareStatement( reprintCntrlSQL );
			rs = pstmt.executeQuery();
			while ( rs.next() )
			{
				resultAL.add( checkNull( rs.getString( 1 ) ).trim()  );
			}
		}
		catch (Exception e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( conn != null )
				{
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		BaseLogger.log("2", userInfoBean, null, " DBAccessEJB :: getReprintCntrlQSLResult : reprintCntrlSQL result list ["+resultAL.toString()+"] " );
		return resultAL;
	}

	private String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}

	//Added By Prajyot On 23-MAR-2012[End]

	//Added by Harshada on 28th Nov 2012 [Creating user connections on login] starts
	/**
	 * Gets all the application associated to logged in user
	 */
	public ArrayList getApplications(String userId,String userLevel, UserInfoBean userInfo) throws RemoteException,ITMException
	{
		ArrayList<String> applsNm = new ArrayList<String>();
		ArrayList<String> applDesc = new ArrayList<String>();
		Connection mConnection = null;
		Statement stmt = null;
		String selectQuery=null;
		String subquery =null;
		ResultSet rs = null;
		BaseLogger.log("2", userInfo, null,"User level : "+ userLevel);
		try
		{
			ConnDriver mConnDriver = new ConnDriver();
			String transDB = userInfo.getTransDB();
			mConnection = mConnDriver.getConnectDB(transDB);

			//added by vishal pathare on 31.7.18 for[application user licence type wise application should display]
			String userLicType = getUserLicenceType( userId );
			BaseLogger.log("3", userInfo, null,"userLicType["+userLicType+"]");
			String applType = "";
			boolean isLicType = false;
			if( E12GenericUtility.checkNull( userLicType ).length() > 0 )
			{
				isLicType = true;
				if(userLicType.equalsIgnoreCase("E"))
				{
					applType = E12GenericUtility.getFormattedProfileId("E,S");
				}
				else
				{
					applType = E12GenericUtility.getFormattedProfileId( userLicType );
				}
			}
			BaseLogger.log("3", userInfo, null,"applType122["+applType+"]");

			if(userLevel != null && userLevel.equalsIgnoreCase("0")){
				//selectQuery = "SELECT DISTINCT APPLICATION FROM USER_RIGHTS";

				//Changes By Umakanta / Prajyot on 15JULY14 [DB2 Compatibility for Join statements]
				//selectQuery = "SELECT DISTINCT a.APPLICATION , b.DESCR " +
				//		"from USER_RIGHTS a, APPL_MST b " +
				//		"WHERE b.APP_NAME(+) = a.APPLICATION";

				//Changed by Sandeep S. on 24-OCT-17 [User can change application by tapping app icon inside menu/left panel] start
				//selectQuery = "SELECT DISTINCT a.APPLICATION , b.DESCR, b.CONN_OPTION from USER_RIGHTS a right outer join APPL_MST b ON b.APP_NAME = a.APPLICATION";
				//changed by vishal pathare on 1.8.18[users licence related security]
				if( isLicType )
				{
					// Changed by Pooja S on 11-oct-2019 [To Module name should be display in grey with application change icon ]
					selectQuery = "SELECT DISTINCT B.APP_NAME , B.DESCR, B.CONN_OPTION, B.APPL_GROUP FROM USER_RIGHTS A RIGHT OUTER JOIN APPL_MST B ON B.APP_NAME = A.APPLICATION WHERE B.APPL_TYPE in "+applType+"";
				}
				else
				{
					// Changed by Pooja S on 11-oct-2019 [To Module name should be display in grey with application change icon ]
				    selectQuery = "SELECT DISTINCT b.APP_NAME , b.DESCR, b.CONN_OPTION, b.APPL_GROUP from USER_RIGHTS a right outer join APPL_MST b ON b.APP_NAME = a.APPLICATION";
				}
			}
			else
			{

				//selectQuery = "SELECT DISTINCT APPLICATION FROM USER_RIGHTS WHERE PROFILE_ID = (SELECT PROFILE_ID FROM USERS WHERE CODE = '"+userId+"'"+")";
				//selectQuery = "SELECT DISTINCT a.APPLICATION , c.DESCR, c.CONN_OPTION " +
				//		"from USER_RIGHTS a , USERS b, APPL_MST c WHERE a.PROFILE_ID= b.PROFILE_ID and a.APPLICATION = c.APP_NAME and b.CODE='"+ userId +"'";
				//changed by vishal pathare on 1.8.18[users licence related security]Start
				if( isLicType )
				{
					// Changed by Pooja S on 11-oct-2019 [To Module name should be display in grey with application change icon ]
					selectQuery = "SELECT DISTINCT C.APP_NAME , C.DESCR, C.CONN_OPTION, C.APPL_GROUP FROM USER_RIGHTS A , USERS B, APPL_MST C WHERE A.PROFILE_ID= B.PROFILE_ID AND A.APPLICATION = C.APP_NAME AND B.CODE='"+userId+"' AND C.APPL_TYPE IN "+applType+"";
				}
				else
				{
					// Changed by Pooja S on 11-oct-2019 [To Module name should be display in grey with application change icon ]
				   selectQuery = "SELECT DISTINCT c.APP_NAME , c.DESCR, c.CONN_OPTION , c.APPL_GROUP " +
						   		 "from USER_RIGHTS a , USERS b, APPL_MST c WHERE a.PROFILE_ID= b.PROFILE_ID and a.APPLICATION = c.APP_NAME and b.CODE='"+ userId +"'";
				}
			}
			BaseLogger.log("3", userInfo, null,"my query:: " + selectQuery);
			stmt = mConnection.createStatement();
			rs = stmt.executeQuery(selectQuery);

			while(rs.next())
			{
				//applsNm.add(rs.getString("APPLICATION")+"["+rs.getString("DESCR")+"]"+"["+rs.getString("CONN_OPTION")+"]");
				// Changed by Pooja S on 11-oct-2019 [To Module name should be display in grey with application change icon ]
				applsNm.add(rs.getString("APP_NAME")+"["+rs.getString("DESCR")+"]"+"["+rs.getString("CONN_OPTION")+"]"+rs.getString("APPL_GROUP"));
				//Changed by Sandeep S. on 24-OCT-17 [User can change application by tapping app icon inside menu/left panel] end
			}

			if(rs!=null){
				rs.close();
				rs =null;
			}

		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo, null,"Exception :DBAccessEJB :Applications :==>" + e.getMessage());
			throw new ITMException(e);
		}

		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getApplications :\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2", userInfo, null,"[DBAccessEJB]Return Application array  :"+applsNm);
		return applsNm;
	}

	//Added By Mahesh Patidar on 04-JUN-13[to get column value from transetup using column name and objname]
	public String getDBColumnValue(String tableName, String columnName, String condition)throws RemoteException, ITMException
	{
		String columnValue = "";
		Connection mConnection = null;
		Statement mStmt = null;
		ResultSet rs = null;
		//Added By Nilesh Start ::30-06-2017 For db2
		String selectColumns="";
		//Added By Nilesh Start ::30-06-2017 For db2
		try
		{
			String columnNameAs = "";
			//Added By Nilesh Start ::30-06-2017 For db2
			selectColumns=columnName;
			//Added By Nilesh Start ::30-06-2017 For db2
			if( columnName.indexOf("~AS~") != -1 )
			{
				String[] columnNameArr = columnName.split("~AS~");
				if( columnNameArr.length > 1 )
				{
					columnName = columnNameArr[0];
					columnNameAs = columnNameArr[1];
					//Added By Nilesh Start ::30-06-2017 For db2
					selectColumns=columnName+" AS "+columnNameAs;
					//Added By Nilesh Start ::30-06-2017 For db2
				}
			}
			ConnDriver mConnDriver =  new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver");
			String mQuery =  " SELECT " +  selectColumns + " FROM " + tableName + " WHERE " + condition ;
			BaseLogger.log("3", null, null,"mQuery ["+mQuery+"]");
			mStmt = mConnection.createStatement();
			rs = mStmt.executeQuery(mQuery);
			//Added By Nilesh Start ::30-06-2017 For db2
			BaseLogger.log("3", null, null,"columnNameAs::"+columnNameAs);
			//Added By Nilesh Start ::30-06-2017 For db2

			if( columnNameAs.length() > 0 )
			{
				columnName = columnNameAs;
			}
			if (rs.next())
			{
				columnValue = checkNull( rs.getString( columnName.trim() ) );
			}
			/*--Commented and moved to finally block
			rs.close();
			rs = null;
			*/
		}
		catch (Exception e)
		{
			columnValue = "";
			BaseLogger.log("0", null, null,"Exception :DBAccessEJB :getDBColumnValue() :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				//To close ResultSet, Statement and Connection in Finally
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(mStmt != null)
				{
					mStmt.close();
					mStmt = null;
				}
				if(mConnection != null)
				{
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getTransetupColumnValue() :==>finally"+e.getMessage()); //$NON-NLS-1$
			}
		}
		BaseLogger.log("2", null, null,tableName +"." + columnName + " ["+columnValue+"]");
		return columnValue.trim();
	}
	//Ended By Mahesh Patidar

	//Added by gayatri on 23-07-2013 [SY3ESUN003][to get max reprint count]start
	//Changed by gayatri on 10-09-2013 [SY3ESUN003] [to get reprint count for current value and current report ]

	//Added by gayatri on 30-09-2013 [to display audit data in process page][WI3FSUN002]start
	/**
	 *This method accepts objname, returns data from audit trail table.
	 *@param  String objName
	 *@return String xmlData
	 *@exception ITMException
	 */
	/*public String getProcessAuditDetail(String objName, int noOfRecord)throws ITMException
	{
		BaseLogger.log("3", null, null,"In DBAccessEjb");
		StringBuffer xmlData = new StringBuffer("<Root>");
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			conn = connDriver.getConnectDB("Driver");
			//change by gayatri on 19-09-2013[WI3FSUN002][to sort rows as per date]
			//String getProcAuditData = "SELECT CHG_XML  FROM AUDIT_TRAIL WHERE OBJ_NAME = ? AND ROWNUM < = ?";
			String getProcAuditData = "SELECT * FROM (SELECT CHG_XML FROM AUDIT_TRAIL WHERE OBJ_NAME = ? ORDER BY CHG_DATE DESC)WHERE ROWNUM <= ?";
			pstmt = conn.prepareStatement(getProcAuditData);
			pstmt.setString(1, objName);
			//change by gayatri on 19-09-2013 [WI3FSUN002][to get row as mentioned in properties table]
			//pstmt.setInt(2, noOfRecord);
			pstmt.setInt(2, noOfRecord+1);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				Blob blobData = rs.getBlob("CHG_XML");
				String currentNode = new String(blobData.getBytes( 1, (int)blobData.length()));
				BaseLogger.log("3", null, null,"currentNode = [ "+currentNode+" ]");

				if(currentNode != null && currentNode.indexOf("<DocumentRoot>")!= -1)
				{
					xmlData.append(currentNode.substring(currentNode.indexOf("<Arguments>"), currentNode.indexOf("</Arguments>")));
					xmlData.append("</Arguments>");

				}
				else if(currentNode != null && currentNode.indexOf("</Root>")!= -1)
				{
					xmlData.append(currentNode.substring(6, currentNode.indexOf("</Root>")));
				}
			}
			xmlData.append("</Root>");
		}
		catch (Exception e)
		{
			e.getStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( conn != null )
				{
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		BaseLogger.log("3", null, null,"xmlData [= "+xmlData+"]");
		return xmlData.toString();
	}*/

	/**This method will return no of rows which need to be displayed after clicking on view audit button
	 *  in process page.
	 * @return String noOfRec
	 *@exception ITMException
	 */
	/*public int getRecProcessAudit()throws ITMException
	{
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		Statement stmt = null;
		ResultSet rs = null;
		int noOfRec = 0;
		try
		{
			conn = connDriver.getConnectDB("Driver");
			String getNoOfRecProcAudit = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME='REC_PROC_AUDIT'";
			stmt = conn.createStatement();
			rs = stmt.executeQuery(getNoOfRecProcAudit);
			if(rs.next())
			{
				if(rs.getString("PROP_VALUE") != null)
				{
					noOfRec = Integer.parseInt(rs.getString("PROP_VALUE"));
				}
			}
		}
		catch (Exception e)
		{
			e.getStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( conn != null )
				{
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if( stmt != null )
					{
						stmt.close();
						stmt = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return noOfRec;
	}*/
	//Added by gayatri on 30-09-2013 [to display audit data in process page][WI3FSUN002]end

	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].START
	public int getRecProcessAudit(String userInfoStr)throws ITMException
	{
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		Statement stmt = null;
		ResultSet rs = null;
		int noOfRec = 0;
		String transDB = null;
		try
		{
			ibase.utility.UserInfoBean userInfo = new ibase.utility.UserInfoBean( userInfoStr );
			transDB=userInfo.getTransDB();

			conn = connDriver.getConnectDB(transDB);
			String getNoOfRecProcAudit = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME='REC_PROC_AUDIT'";
			stmt = conn.createStatement();
			rs = stmt.executeQuery(getNoOfRecProcAudit);
			if(rs.next())
			{
				if(rs.getString("PROP_VALUE") != null)
				{
					noOfRec = Integer.parseInt(rs.getString("PROP_VALUE"));
				}
			}
		}
		catch (Exception e)
		{
			e.getStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( conn != null )
				{
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if( stmt != null )
					{
						stmt.close();
						stmt = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return noOfRec;
	}

	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END
	//Overloaded method added by Gulzar to support multiDB connection : START
	public String getUserXML(String userCode, String profileID, UserInfoBean userInfo) throws RemoteException,ITMException
	{
		StringBuffer mXML = new StringBuffer("<?xml version=\"1.0\" encoding=\""+CommonConstants.ENCODING+"\"?><ROOT>"); //$NON-NLS-1$
		Connection mConnection = null;
		Connection tranConnection = null;
		Statement mStatement = null;
		ResultSet mResultSet = null;
		Statement tranStatement = null;
		ResultSet tranResultSet = null;
		Statement mStatement1 = null;
		ResultSet mResultSet1 = null;
		String transDB = null;
		try
		{
			String tApp=null;
			String prev_descr1 = null;
			String prev_descr2 = null;
			String prev_descr3 = null;
			String prev_descr4 = null;
			String prev_descr5 = null;

			String mIconPath = ""; //$NON-NLS-1$
			String prevIconPath = ""; //$NON-NLS-1$
			String mObjType = ""; //$NON-NLS-1$

			String app_descr,mpath,appln,level1,level2,level3,level4,level5;
			String tLev1_descr = "",tLev2_descr = "",tLev3_descr = "",tLev4_descr = "",tLev5_descr = ""; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
			String tpath,tpath1,tpath2,qry,mWinName;
			int rno=1;
			//changed by gayatri [to add favourite from user_rights][24-04-2012]
			ArrayList favObjName = new ArrayList();
			ConnDriver mConnDriver = new ConnDriver();
			//Commented and changed by Gulzar as user related infor should get from 'Driver' instead of 'Driver' to support multiDB connection : START

			transDB = userInfo.getTransDB();
			mConnection = mConnDriver.getConnectDB(transDB);
			//Commented and changed by Gulzar as user related infor should get from 'Driver' instead of 'Driver' to support multiDB connection : END

			/*//Changed by gayatri[To give an option of favorite menus on the screen to the user for faster access To the menus most frequently used][SY90SUN029]start
			String selectObjName="SELECT OBJ_NAME FROM USER_OBJ_FAV WHERE USER_ID='"+userCode+"'";
			BaseLogger.log("3", null, null,"selectFavoriteQry="+selectObjName);
			mStatement = mConnection.createStatement();
			mResultSet = mStatement.executeQuery(selectObjName);
			if( mResultSet.next() )
			{
				mXML.append("<APP ANAME='FAV'>");
				do
				{
					String winName="w_"+mResultSet.getString("OBJ_NAME");
					String selectFavoriteQry="SELECT WIN_NAME,DESCR,ICON_PATH,OBJ_TYPE FROM ITM2MENU WHERE WIN_NAME='"+winName+"'";
					Statement fStat=mConnection.createStatement();
					ResultSet fResultSet=fStat.executeQuery(selectFavoriteQry);
					if(fResultSet.next())
					{
						mXML.append("<LEVEL  WIN='"+fResultSet.getString("WIN_NAME")+"' VAL1='0' VAL2='0' VAL3='0' VAL4='0' VAL5='0' ICON='"+fResultSet.getString("ICON_PATH")+"' OBJ_TYPE='"+fResultSet.getString("OBJ_TYPE")+"'><![CDATA["+fResultSet.getString("DESCR")+" ]]></LEVEL>");
					}
					fStat=null;
					fResultSet=null;
				}	while(mResultSet.next());

				mXML.append("</APP>");
			}
			if ( mStatement != null  )
			{
				mStatement.close();
				mStatement = null;
			}
			if ( mResultSet != null )
			{
				mResultSet.close();
				mResultSet = null;
			}
			//Changed by gayatri[To give an option of favorite menus on the screen to the user for faster access To the menus most frequently used][SY90SUN029]end*/
			String usrLevSelQry = "SELECT USR_LEV FROM USERS WHERE CODE ='" + userCode + "'"; //$NON-NLS-1$ //$NON-NLS-2$
			mStatement = mConnection.createStatement();
			mResultSet = mStatement.executeQuery(usrLevSelQry);
			int level = 0;
			if(mResultSet.next())
			{
				level = mResultSet.getInt("USR_LEV"); //$NON-NLS-1$
			}
			mResultSet.close();
			mResultSet = null;
			mStatement.close();
			mStatement = null;
			String menuSelQry = null;
			ConnDriver tranConnDriver = new ConnDriver();
			tranConnection = tranConnDriver.getConnectDB(userInfo.getTransDB()); //$NON-NLS-1$
			//Added by Pratheek on 11-06-18[to show menu based on ent_types column values of itm2menu and Enterprise table]-Start
			String entTypes ="";
			String tableName = "ENTERPRISE";
			String columnName = "ENT_TYPE";
			//Changes made by Pratheek on 26-06-18[to trim the data to check the condition properly]-Start
			String condition = "WHERE ENTERPRISE='"+E12GenericUtility.checkNull(userInfo.getEnterprise())+"'";
			//Changes made by Pratheek on 26-06-18[to trim the data to check the condition properly]-End
			String enterpriseType = E12GenericUtility.checkNull(getDBColumnValue(tableName, columnName, condition, transDB));
			BaseLogger.log("3", userInfo, null,"After executing query 40006!!!!![");
			BaseLogger.log("3", userInfo, null,"enterpriseEntType 4008!!!!!!["+enterpriseType+"]");
			//Added by Pratheek on 11-06-18[to show menu based on ent_types column values of itm2menu and Enterprise table]-End
			if( level >= 1 )
			{
				//changed by gayatri on 07-02-2011 [To give an option of favorite menus on the screen to the user for faster access To the menus most frequently used][SY90SUN029]start
				String selectObjName="SELECT OBJ_NAME FROM USER_OBJ_FAV  WHERE USER_ID='"+userCode+"'"; //$NON-NLS-1$ //$NON-NLS-2$
				BaseLogger.log("3", userInfo, null,"Object from user_obj_fav = ["+selectObjName+"]"); //$NON-NLS-1$ //$NON-NLS-2$
				mStatement = mConnection.createStatement();
				mResultSet = mStatement.executeQuery(selectObjName);

				//Added by Arvind on 11-Dec-13

				//Added by Arvind on 11-Dec-13

				if( mResultSet.next() )
				{
					mXML.append("<APP ANAME='FAV'>"); //$NON-NLS-1$
					do
					{
						String objName = mResultSet.getString("OBJ_NAME"); //$NON-NLS-1$
						BaseLogger.log("3", userInfo, null,"objName = "+objName); //$NON-NLS-1$
						//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
						//String getRightsQry = "SELECT COUNT(1) FROM USER_RIGHTS WHERE PROFILE_ID = '"+profileID+"' AND OBJ_NAME ='"+objName.trim()+"'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						String getRightsQry = "SELECT COUNT(1) FROM USER_RIGHTS WHERE PROFILE_ID IN " + E12GenericUtility.getFormattedProfileId(profileID) +" AND OBJ_NAME ='"+objName.trim()+"'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						//BaseLogger.log("3", null, null,"getRightsQry = "+getRightsQry);
						Statement rStatement = tranConnection.createStatement();
						ResultSet rResultSet = rStatement.executeQuery(getRightsQry);
						if(rResultSet.next())
						{
							if(rResultSet.getInt(1) != 0)
							{
								String winName="w_"+mResultSet.getString("OBJ_NAME"); //$NON-NLS-1$ //$NON-NLS-2$
								String selectFavoriteQry = "SELECT WIN_NAME,DESCR,ICON_PATH,OBJ_TYPE FROM ITM2MENU WHERE WIN_NAME='"+winName+"'"; //$NON-NLS-1$ //$NON-NLS-2$

								Statement fStat = mConnection.createStatement();
								ResultSet fResultSet = fStat.executeQuery(selectFavoriteQry);
								if(fResultSet.next())
								{
									String favWinName = fResultSet.getString("WIN_NAME");
									//added by gayatri [to add favourites from user_rights]
									favObjName.add(favWinName);
									String favIconPath = fResultSet.getString("ICON_PATH");
									String favObjType = fResultSet.getString("OBJ_TYPE");
									String favDecr = fResultSet.getString("DESCR");

									BaseLogger.log("3", userInfo, null,"favDecr ["+favDecr+"]");

									mXML.append("<LEVEL  WIN='"+favWinName+"' VAL1='0' VAL2='0' VAL3='0' VAL4='0' VAL5='0' ICON='"+favIconPath+"' OBJ_TYPE='"+favObjType+"'><![CDATA["+favDecr+" ]]></LEVEL>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$
								}
								if ( fStat != null )
								{
									fStat.close();
									fStat = null;
								}
								if ( fResultSet != null )
								{
									fResultSet.close();
									fResultSet = null;
								}
							}
							if ( rStatement != null )
							{
								rStatement.close();
								rStatement = null;
							}
							if ( rResultSet != null )
							{
								rResultSet.close();
								rResultSet = null;
							}
						}
					}while(mResultSet.next());
					mXML.append("</APP>"); //$NON-NLS-1$
				}
				if ( mStatement != null  )
				{
					mStatement.close();
					mStatement = null;
				}
				if ( mResultSet != null )
				{
					mResultSet.close();
					mResultSet = null;
				}
				//added by gayatri [to add favourites from user_rights]start
				PreparedStatement favPreStat = null;
				ResultSet favRs = null;
				//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
				//String favUserRights = "SELECT OBJ_NAME FROM USER_RIGHTS WHERE PROFILE_ID = ? AND FAV_OPTION = ?";
				String favUserRights = "SELECT OBJ_NAME FROM USER_RIGHTS WHERE PROFILE_ID IN "+ E12GenericUtility.getFormattedProfileId(profileID)+" AND FAV_OPTION = ?";
				favPreStat = tranConnection.prepareStatement(favUserRights);
				//favPreStat.setString(1, profileID);
				favPreStat.setString(1, "Y");
				favRs = favPreStat.executeQuery();
				if(favRs.next())
				{
					do
					{
						String winName = "w_" + favRs.getString("OBJ_NAME");
						if(!favObjName.isEmpty() && !favObjName.contains(winName))
						{
							mXML.append("<APP ANAME = 'RIGHTFAV'>");
							String selectFavQry = "SELECT WIN_NAME,DESCR,ICON_PATH,OBJ_TYPE FROM ITM2MENU WHERE WIN_NAME= ? ";
							PreparedStatement preStat = null;
							ResultSet rs = null;
							preStat = tranConnection.prepareStatement(selectFavQry);
							preStat.setString(1 , winName );
							rs = preStat.executeQuery();
							if(rs.next())
							{
								String favWinName = rs.getString("WIN_NAME");
								String favIconPath = rs.getString("ICON_PATH");
								String favObjType = rs.getString("OBJ_TYPE");
								String favDecr = rs.getString("DESCR");

								BaseLogger.log("3", userInfo, null,"favDecr ["+favDecr+"]");
								mXML.append("<LEVEL  WIN='"+favWinName+"' VAL1='0' VAL2='0' VAL3='0' VAL4='0' VAL5='0' ICON='"+favIconPath+"' OBJ_TYPE='"+favObjType+"'><![CDATA["+favDecr+" ]]></LEVEL>");
							}
							mXML.append("</APP>");
							if(preStat != null)
							{
								preStat.close();
								preStat = null;
							}
							if(rs != null)
							{
								rs.close();
								rs = null;
							}
						}
					}
					while(favRs.next());
				}
				if(favPreStat != null)
				{
					favPreStat.close();
					favPreStat = null;
				}
				if(favRs != null)
				{
					favRs.close();
					favRs = null;
				}

				//added by gayatri [to add favourites from user_rights]end
				//changed by gayatri on 07-02-2011 [To give an option of favorite menus on the screen to the user for faster access To the menus most frequently used][SY90SUN029]end
				/*menuSelQry = "SELECT A.APPLICATION APP,WIN_NAME, B.MENU_PATH MPATH,DESCR,ICON_PATH,OBJ_TYPE  FROM USER_RIGHTS A, ITM2MENU B " +
						"WHERE PROFILE_ID = '" + profileID + "'" +
						"AND A.APPLICATION=B.APPLICATION AND LEVEL_1=MENU_ROW AND LEVEL_2=MENU_COL " +
						"AND MENU_SUBCOL=LEVEL_3 AND A.LEVEL_4=B.LEVEL_4 AND A.LEVEL_5=B.LEVEL_5 " +
						"ORDER BY A.APPLICATION,MENU_ROW,MENU_COL,MENU_SUBCOL,A.LEVEL_4,A.LEVEL_5";*/
				//Changes made by Pratheek on 12-06-18[to get the ent_type column value from itm2menu]-Start
//				menuSelQry = "SELECT A.APPLICATION APP,WIN_NAME, B.MENU_PATH MPATH,DESCR,ICON_PATH,OBJ_TYPE FROM USER_RIGHTS A, ITM2MENU B " + //$NON-NLS-1$
				menuSelQry = "SELECT A.APPLICATION APP,WIN_NAME, B.MENU_PATH MPATH,DESCR,ICON_PATH,OBJ_TYPE,B.ENT_TYPES FROM USER_RIGHTS A, ITM2MENU B " + //$NON-NLS-1$
						//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
						//"WHERE PROFILE_ID = '" + profileID + "'" + //$NON-NLS-1$ //$NON-NLS-2$
						"WHERE PROFILE_ID IN " + E12GenericUtility.getFormattedProfileId(profileID)  + //$NON-NLS-1$ //$NON-NLS-2$
						"AND A.APPLICATION=B.APPLICATION AND LEVEL_1=MENU_ROW AND LEVEL_2=MENU_COL " + //$NON-NLS-1$
						"AND MENU_SUBCOL=LEVEL_3 AND A.LEVEL_4=B.LEVEL_4 AND A.LEVEL_5=B.LEVEL_5 " +  //$NON-NLS-1$
						"ORDER BY A.APPLICATION,MENU_ROW,MENU_COL,MENU_SUBCOL,A.LEVEL_4,A.LEVEL_5"; //$NON-NLS-1$
			}
			else
			{
				//Changes made by Pratheek on 12-06-18[to get the ent_type column value from itm2menu]-Start
//				menuSelQry = "SELECT APPLICATION APP,WIN_NAME, MENU_PATH MPATH,DESCR,ICON_PATH,OBJ_TYPE FROM ITM2MENU WHERE WIN_NAME NOT IN ('-') ORDER BY APPLICATION,level_1,level_2,Level_3,LEVEL_4,LEVEL_5"; //$NON-NLS-1$
				menuSelQry = "SELECT APPLICATION APP,WIN_NAME, MENU_PATH MPATH,DESCR,ICON_PATH,OBJ_TYPE,ENT_TYPES FROM ITM2MENU WHERE WIN_NAME NOT IN ('-') ORDER BY APPLICATION,level_1,level_2,Level_3,LEVEL_4,LEVEL_5"; //$NON-NLS-1$
				//Changed by gayatri  on 07-02-2011[To give an option of favorite menus on the screen to the user for faster access To the menus most frequently used][SY90SUN029]start
				String selectObjName="SELECT OBJ_NAME FROM USER_OBJ_FAV WHERE USER_ID='"+userCode+"'"; //$NON-NLS-1$ //$NON-NLS-2$
				//BaseLogger.log("3", null, null,"selectObjName2 = ["+selectObjName+"]");
				mStatement = tranConnection.createStatement();
				mResultSet = mStatement.executeQuery(selectObjName);
				if( mResultSet.next() )
				{
					mXML.append("<APP ANAME='FAV'>"); //$NON-NLS-1$
					do
					{
						String winName="w_"+mResultSet.getString("OBJ_NAME"); //$NON-NLS-1$ //$NON-NLS-2$
						String selectFavoriteQry = "SELECT WIN_NAME,DESCR,ICON_PATH,OBJ_TYPE FROM ITM2MENU WHERE WIN_NAME='"+winName.trim()+"'"; //$NON-NLS-1$ //$NON-NLS-2$
						BaseLogger.log("3", userInfo, null,"user level 0 selectFavoriteQry = ["+selectFavoriteQry+"]"); //$NON-NLS-1$ //$NON-NLS-2$
						//Statement fStat = mConnection.createStatement();
						//ResultSet fResultSet = fStat.executeQuery(selectFavoriteQry);
						//if(fResultSet.next())
						//{
						//mXML.append("<LEVEL  WIN='"+fResultSet.getString("WIN_NAME")+"' VAL1='0' VAL2='0' VAL3='0' VAL4='0' VAL5='0' ICON='"+fResultSet.getString("ICON_PATH")+"' OBJ_TYPE='"+fResultSet.getString("OBJ_TYPE")+"'><![CDATA["+fResultSet.getString("DESCR")+" ]]></LEVEL>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$
						//}
						//fStat=null;
						//fResultSet=null;


						Statement fStat = tranConnection.createStatement();
						ResultSet fResultSet = fStat.executeQuery(selectFavoriteQry);
						if(fResultSet.next())
						{
							String favWinName = fResultSet.getString("WIN_NAME");
							//Changed by gayatri [to add favourites from user_rights ]
							favObjName.add(favWinName);
							String favIconPath = fResultSet.getString("ICON_PATH");
							String favObjType = fResultSet.getString("OBJ_TYPE");
							String favDecr = fResultSet.getString("DESCR");

							BaseLogger.log("3", userInfo, null,"favDecr user level 0["+favDecr+"]");

							mXML.append("<LEVEL  WIN='"+favWinName+"' VAL1='0' VAL2='0' VAL3='0' VAL4='0' VAL5='0' ICON='"+favIconPath+"' OBJ_TYPE='"+favObjType+"'><![CDATA["+favDecr+" ]]></LEVEL>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$
						}
						if ( fStat != null )
						{
							fStat.close();
							fStat = null;
						}
						if ( fResultSet != null )
						{
							fResultSet.close();
							fResultSet = null;
						}


					}	while(mResultSet.next());

					mXML.append("</APP>"); //$NON-NLS-1$
				}
				if ( mStatement != null  )
				{
					mStatement.close();
					mStatement = null;
				}
				if ( mResultSet != null )
				{
					mResultSet.close();
					mResultSet = null;
				}
				//Changed by gayatri  on 07-02-2011[To give an option of favourite menus on the screen to the user for faster access To the menus most frequently used][SY90SUN029]END
				//added by gayatri [to add favourites from user_rights]start
				PreparedStatement favPreStat = null;
				ResultSet favRs = null;
				//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
				//String favUserRights = "SELECT OBJ_NAME FROM USER_RIGHTS WHERE PROFILE_ID = ? AND FAV_OPTION = ?";
				String favUserRights = "SELECT OBJ_NAME FROM USER_RIGHTS WHERE PROFILE_ID IN "+ E12GenericUtility.getFormattedProfileId(profileID)+" AND FAV_OPTION = ?";
				favPreStat = tranConnection.prepareStatement(favUserRights);
				//favPreStat.setString(1, profileID);
				favPreStat.setString(1, "Y");
				favRs = favPreStat.executeQuery();
				if(favRs.next())
				{
					do
					{
						String winName = "w_" + favRs.getString("OBJ_NAME");
						if(!favObjName.isEmpty() && !favObjName.contains(winName))
						{
							mXML.append("<APP ANAME = 'RIGHTFAV'>");
							String selectFavQry = "SELECT WIN_NAME,DESCR,ICON_PATH,OBJ_TYPE FROM ITM2MENU WHERE WIN_NAME= ? ";
							PreparedStatement preStat = null;
							ResultSet rs = null;
							preStat = tranConnection.prepareStatement(selectFavQry);
							preStat.setString(1 , winName );
							rs = preStat.executeQuery();
							if(rs.next())
							{
								String favWinName = rs.getString("WIN_NAME");
								String favIconPath = rs.getString("ICON_PATH");
								String favObjType = rs.getString("OBJ_TYPE");
								String favDecr = rs.getString("DESCR");

								BaseLogger.log("3", userInfo, null,"favDecr ["+favDecr+"]");
								mXML.append("<LEVEL  WIN='"+favWinName+"' VAL1='0' VAL2='0' VAL3='0' VAL4='0' VAL5='0' ICON='"+favIconPath+"' OBJ_TYPE='"+favObjType+"'><![CDATA["+favDecr+" ]]></LEVEL>");
							}
							mXML.append("</APP>");
							if(preStat != null)
							{
								preStat.close();
								preStat = null;
							}
							if(rs != null)
							{
								rs.close();
								rs = null;
							}
						}
					}
					while(favRs.next());
				}
				if(favPreStat != null)
				{
					favPreStat.close();
					favPreStat = null;
				}
				if(favRs != null)
				{
					favRs.close();
					favRs = null;
				}

				//added by gayatri [to add favourites from user_rights]end
			}
			mStatement = tranConnection.createStatement();
			mResultSet = mStatement.executeQuery(menuSelQry);
			boolean recFound = false;
			while (mResultSet.next())
			{
				recFound = true;
				appln = mResultSet.getString("APP"); //$NON-NLS-1$
				mWinName = mResultSet.getString("WIN_NAME"); //$NON-NLS-1$
				mpath = mResultSet.getString("MPATH"); //$NON-NLS-1$
				//Changes made by Pratheek on 12-06-18 [to get the ent_types column value of itm2menu table]-Start
				entTypes = E12GenericUtility.checkNull(mResultSet.getString("ENT_TYPES"));
				//Changes made by Pratheek on 12-06-18 [to get the ent_types column value of itm2menu table]-End
				BaseLogger.log("3", userInfo, null,"mpath-------------------------------------------:"+mpath); //$NON-NLS-1$
				//Changes made by Pratheek on 12-06-18 [to show the menu based on ent_types values]-Start
				//Changes made by Pratheek on 26-06-18[to check if enty_type and ent_types column value]-Start
				if(entTypes.length() > 0 && enterpriseType.length() > 0 && entTypes.contains(enterpriseType))
				{
					if(mpath != null)
					{
						tpath = mpath.substring( mpath.indexOf( '.' ) + 1 );
						tpath1 = tpath.substring( tpath.indexOf( '.' )+1, tpath.lastIndexOf( '.' )  );
						tpath2 = tpath1.substring(tpath1.indexOf('.'));
						level1 = tpath.substring(0,tpath.indexOf('.'));
						level2 = tpath1.substring(0,tpath1.indexOf('.'));
						level3 = tpath2.substring(tpath2.indexOf('.')+1,tpath2.lastIndexOf('.')  );
						level4 = tpath1.substring(tpath1.lastIndexOf('.')+1  );
						level5 = mpath.substring(mpath.lastIndexOf('.')+1  );
						app_descr = mResultSet.getString("DESCR"); //$NON-NLS-1$
						BaseLogger.log("3", userInfo, null,"app_descr ["+app_descr+"]");
						mIconPath = mResultSet.getString("ICON_PATH"); //$NON-NLS-1$
						mObjType = mResultSet.getString("OBJ_TYPE"); //$NON-NLS-1$
						if (!(appln.equals(tApp)))
						{
							tApp = appln;
							if (rno>1)
							{
								mXML.append("</APP>"); //$NON-NLS-1$
							}
							if (rno==1)
							{
								rno++;
							}
							mXML.append("<APP ANAME='" + appln + "'>"); //$NON-NLS-1$ //$NON-NLS-2$
						}
						if ( ! level1.equals("0"))  //$NON-NLS-1$
						{
							//if level 1 is defined then generates the child of application
							qry="SELECT DESCR,ICON_PATH  FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
									" AND LEVEL_1=0 AND LEVEL_2=0 AND LEVEL_3 = 0 AND LEVEL_4=0 AND LEVEL_5=0"; //$NON-NLS-1$
							mStatement1 = tranConnection.createStatement();
							mResultSet1 = mStatement1.executeQuery(qry);
							if(mResultSet1.next())
							{
								prev_descr1 = mResultSet1.getString("DESCR"); //$NON-NLS-1$
								prevIconPath = mResultSet1.getString("ICON_PATH"); //$NON-NLS-1$
							}
							mResultSet1.close();
							mStatement1.close();
							mStatement1 = null;

							if (!((prev_descr1.equals(tLev1_descr))))
							{
								tLev1_descr=prev_descr1;
								mXML.append("<LEVEL WIN='0' VAL1='0' VAL2='0' VAL3='0' VAL4='0' VAL5='0' ICON='"+prevIconPath+"' OBJ_TYPE=''><![CDATA[" + prev_descr1 + " ]]>"); //For level //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
								mXML.append("</LEVEL>"); //$NON-NLS-1$
							}
						}
						if (!(level2.equals("0")))  //$NON-NLS-1$
						{
							//if level 2 is defined then generates the child of level 1
							qry="SELECT DESCR,ICON_PATH FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
									"AND LEVEL_1= " + level1 + " AND LEVEL_2=0 AND LEVEL_3 = 0 AND LEVEL_4=0 AND LEVEL_5=0"; //$NON-NLS-1$ //$NON-NLS-2$
							mStatement1 = tranConnection.createStatement();
							mResultSet1 = mStatement1.executeQuery(qry);
							if(mResultSet1.next())
							{
								prev_descr2 =mResultSet1.getString("DESCR"); //$NON-NLS-1$
								prevIconPath =mResultSet1.getString("ICON_PATH"); //$NON-NLS-1$
							}
							mResultSet1.close();
							mStatement1.close();
							mStatement1 = null;

							if (!((prev_descr2.equals(tLev2_descr))))
							{
								tLev2_descr=prev_descr2;
								mXML.append("<LEVEL WIN='0' VAL1='" + level1 + "' VAL2='0' VAL3='0' VAL4='0' VAL5='0' ICON='"+prevIconPath+"' OBJ_TYPE=''><![CDATA[" + prev_descr2 + " ]]>"); //For level //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
								mXML.append("</LEVEL>"); //$NON-NLS-1$
							}
						}
						if (!(level3.equals("0")))  //$NON-NLS-1$
						{
							//if level 3 is defined then generates the child of node at level 2
							qry="SELECT DESCR,ICON_PATH FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
									"AND LEVEL_1= " + level1+ " AND LEVEL_2= " + level2 + " AND LEVEL_3 = 0 AND LEVEL_4=0 AND LEVEL_5=0"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
							mStatement1 = tranConnection.createStatement();
							mResultSet1 = mStatement1.executeQuery(qry);

							if(mResultSet1.next())
							{
								prev_descr3 =mResultSet1.getString("DESCR"); //$NON-NLS-1$
								prevIconPath =mResultSet1.getString("ICON_PATH"); //$NON-NLS-1$

							}
							mResultSet1.close();
							mStatement1.close();
							mStatement1 = null;

							if (!((prev_descr3.equals(tLev3_descr))))
							{
								tLev3_descr=prev_descr3;
								mXML.append("<LEVEL WIN='0' VAL1='" + level1 + "' VAL2='" + level2 + "' VAL3='0' VAL4='0' VAL5='0' ICON='"+prevIconPath+"' OBJ_TYPE=''><![CDATA[" + prev_descr3 + " ]]>"); //For level //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
								mXML.append("</LEVEL>"); //$NON-NLS-1$
							}
						}
						if (!(level4.equals("0"))) //$NON-NLS-1$
						{
							//if level 4 is defined then generates the child of node at level 3
							qry="SELECT DESCR,ICON_PATH  FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
									" AND LEVEL_1= " + level1 + " AND LEVEL_2="+ level2 +  //$NON-NLS-1$ //$NON-NLS-2$
									" AND LEVEL_3 = "+ level3 + " AND LEVEL_4=0 AND LEVEL_5=0"; //$NON-NLS-1$ //$NON-NLS-2$

							mStatement1 = tranConnection.createStatement();
							mResultSet1 = mStatement1.executeQuery(qry);
							// updated by rahul - start
							//mResultSet1.next();
							//prev_descr4 =mResultSet1.getString("DESCR");
							if(mResultSet1.next())
							{
								prev_descr4 =mResultSet1.getString("DESCR"); //$NON-NLS-1$
								prevIconPath =mResultSet1.getString("ICON_PATH");					 //$NON-NLS-1$
							}
							mResultSet1.close();
							mStatement1.close();
							mStatement1 = null;
							if (!((prev_descr4.equals(tLev4_descr))))
							{
								tLev4_descr = prev_descr4;
								mXML.append("<LEVEL WIN='0' VAL1='" + level1 + "' VAL2='" +  //$NON-NLS-1$ //$NON-NLS-2$
										level2 + "' VAL3='" + level3 + "' VAL4='0' VAL5='0' ICON='"+prevIconPath+"' OBJ_TYPE=''><![CDATA[" + prev_descr4 + " ]]>"); //For level //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
								mXML.append("</LEVEL>"); //$NON-NLS-1$
							}
						}
						if (!(level5.equals("0")))  //$NON-NLS-1$
						{
							//if level 5 is defined then generates the child of node at level 4 - rahul
							qry="SELECT DESCR,ICON_PATH  FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
									" AND LEVEL_1= " + level1 + " AND LEVEL_2="+ level2 +  //$NON-NLS-1$ //$NON-NLS-2$
									" AND LEVEL_3 = "+ level3 + " AND LEVEL_4=" + level4 + " AND LEVEL_5=0"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$

							mStatement1 = tranConnection.createStatement();
							mResultSet1 = mStatement1.executeQuery(qry);
							if(mResultSet1.next())
							{
								prev_descr5 =mResultSet1.getString("DESCR"); //$NON-NLS-1$
								prevIconPath =mResultSet1.getString("ICON_PATH"); //$NON-NLS-1$
							}
							mResultSet1.close();
							mStatement1.close();
							mStatement1 = null;

							if (!((prev_descr5.equals(tLev5_descr))))
							{
								tLev5_descr=prev_descr5;
								mXML.append("<LEVEL WIN='0' VAL1='" + level1 + "' VAL2='" +  //$NON-NLS-1$ //$NON-NLS-2$
										level2 + "' VAL3='" + level3 + "' VAL4='" + level4 + //$NON-NLS-1$ //$NON-NLS-2$
										"' VAL5='0' ICON='"+prevIconPath+"' OBJ_TYPE=''><![CDATA[" + prev_descr5 + " ]]>"); //For level 4 //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
								mXML.append("</LEVEL>"); //$NON-NLS-1$
							}
						}
						mXML.append("<LEVEL  WIN='" + mWinName + "' VAL1='" + level1 + "' VAL2='" + level2 + "' VAL3='" + level3 + "' VAL4='" + level4 + "' VAL5='" + level5 + "' ICON='"+mIconPath+"' OBJ_TYPE='"+mObjType+"'><![CDATA[" + app_descr + " ]]>"); //For level //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$
						mXML.append("</LEVEL>"); //$NON-NLS-1$
					}//if(mpath != null)
				}
				//Changes made by Pratheek on 12-06-18 [to show the menu based on ent_types values]-End
			}
			if (recFound)
			{
				mXML.append("</APP>"); //$NON-NLS-1$
			}
			mXML.append("</ROOT>");		 //$NON-NLS-1$
			mResultSet.close();
			mResultSet = null;
			mStatement.close();
			mStatement = null;
			BaseLogger.log("3", userInfo, null,"(DBAccessEJB:getUserXML)UserXML: Built"); //$NON-NLS-1$
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException: DBAccess: getUserXML: ==>UserXML: Not Built(Generic Exception)\n"); //$NON-NLS-1$
			throw itme;
		}
		catch(SQLException ex)
		{
			System.err.println("Exception: DBAccess: getUserXML: ==>UserXML: Not Built(SQLException)\n" + ex); //$NON-NLS-1$
			ex.printStackTrace();
			//return mXML.toString();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccess: getUserXML: ==>UserXML: Not Built(Generic Exception)\n" + e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(mStatement != null)
					{
						mStatement.close();
					}
					if(mStatement1 != null)
					{
						mStatement1.close();
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getUserXML ==>UserXML: Not Built F\n" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2", userInfo, null,"DBAccess menu created of length ["+mXML.toString().length()+"]");
		return mXML.toString();
	}
	//Overloaded method added by Gulzar to support multiDB connection : END

	//Overloaded method added by Gulzar on 11/02/14 to support multidB connection : START
	public String getUserXML(String userCode, String profileID, String isMobileMenu, UserInfoBean userInfo ) throws RemoteException,ITMException
	{
		StringBuffer mXML = new StringBuffer("<ROOT>"); //$NON-NLS-1$
		Connection mConnection = null;
		Statement mStatement = null;
		ResultSet mResultSet = null;
		Statement mStatement1 = null;
		ResultSet mResultSet1 = null;
		try
		{
			String tApp=null;
			String prev_descr1 = null;
			String prev_descr2 = null;
			String prev_descr3 = null;
			String prev_descr4 = null;
			String prev_descr5 = null;

			String mIconPath = ""; //$NON-NLS-1$
			String prevIconPath = ""; //$NON-NLS-1$
			String mObjType = ""; //$NON-NLS-1$

			String app_descr,mpath,appln,level1,level2,level3,level4,level5;
			String tLev1_descr = "",tLev2_descr = "",tLev3_descr = "",tLev4_descr = "",tLev5_descr = ""; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
			String tpath,tpath1,tpath2,qry,mWinName;
			int rno=1;
			ConnDriver mConnDriver = new ConnDriver();

			String transDB = userInfo.getTransDB();
			if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
			{
				mConnection = mConnDriver.getConnectDB(transDB); //$NON-NLS-1$
			}
			//Added by Pratheek on 11-06-18[to show menu based on ent_types column values of itm2menu and Enterprise table]-Start
			String entTypes ="";
			String tableName = "ENTERPRISE";
			String columnName = "ENT_TYPE";
			//Changes made by Pratheek on 26-06-18[to trim the data to check the condition properly]-Start
			String condition = "WHERE ENTERPRISE='"+E12GenericUtility.checkNull(userInfo.getEnterprise())+"'";
			//Changes made by Pratheek on 26-06-18[to trim the data to check the condition properly]-End
			String enterpriseType = E12GenericUtility.checkNull(getDBColumnValue(tableName, columnName, condition, transDB));
			BaseLogger.log("3", userInfo, null,"enterpriseEntType 4008!!!!!!["+enterpriseType+"]");
			//Added by Pratheek on 11-06-18[to show menu based on ent_types column values of itm2menu and Enterprise table]-End-End

			String usrLevSelQry = "SELECT USR_LEV FROM USERS WHERE CODE ='" + userCode + "'"; //$NON-NLS-1$ //$NON-NLS-2$
			mStatement = mConnection.createStatement();
			mResultSet = mStatement.executeQuery(usrLevSelQry);
			int level = 0;
			if(mResultSet.next())
			{
				level = mResultSet.getInt("USR_LEV"); //$NON-NLS-1$
			}
			mResultSet.close();
			mStatement.close();
			mStatement = null;
			String menuSelQry = null;

			if ( isMobileMenu !=null && isMobileMenu.trim().length() > 0 )
			{
				if( level >= 1 )
				{
					//Changes made by Pratheek on 12-06-18[to get the ent_type column value from itm2menu]-Start
//					menuSelQry = "SELECT A.APPLICATION APP,WIN_NAME, B.MENU_PATH MPATH,DESCR,ICON_PATH,OBJ_TYPE FROM USER_RIGHTS A, ITM2MENU B " + //$NON-NLS-1$
					menuSelQry = "SELECT A.APPLICATION APP,WIN_NAME, B.MENU_PATH MPATH,DESCR,ICON_PATH,OBJ_TYPE,B.ENT_TYPES FROM USER_RIGHTS A, ITM2MENU B " + //$NON-NLS-1$
							//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
							//"WHERE PROFILE_ID = '" + profileID + "'" +"AND MOB_DEPLOY = '"+isMobileMenu+"'"+ //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
							"WHERE PROFILE_ID IN " + E12GenericUtility.getFormattedProfileId(profileID) +" AND MOB_DEPLOY = '"+isMobileMenu+"'"+ //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
							"AND A.APPLICATION=B.APPLICATION AND LEVEL_1=MENU_ROW AND LEVEL_2=MENU_COL " + //$NON-NLS-1$
							"AND MENU_SUBCOL=LEVEL_3 AND A.LEVEL_4=B.LEVEL_4 AND A.LEVEL_5=B.LEVEL_5 " +  //$NON-NLS-1$
							"ORDER BY A.APPLICATION,MENU_ROW,MENU_COL,MENU_SUBCOL,A.LEVEL_4,A.LEVEL_5"; //$NON-NLS-1$
				}
				else
				{
					//Changes made by Pratheek on 12-06-18[to get the ent_type column value from itm2menu]-Start
//					menuSelQry = "SELECT APPLICATION APP,WIN_NAME, MENU_PATH MPATH,DESCR,ICON_PATH,OBJ_TYPE FROM ITM2MENU WHERE WIN_NAME NOT IN ('-')" +"AND MOB_DEPLOY = '"+isMobileMenu+"'"+"ORDER BY APPLICATION,level_1,level_2,Level_3,LEVEL_4,LEVEL_5";				 //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
					menuSelQry = "SELECT APPLICATION APP,WIN_NAME, MENU_PATH MPATH,DESCR,ICON_PATH,OBJ_TYPE,ENT_TYPES FROM ITM2MENU WHERE WIN_NAME NOT IN ('-')" +"AND MOB_DEPLOY = '"+isMobileMenu+"'"+"ORDER BY APPLICATION,level_1,level_2,Level_3,LEVEL_4,LEVEL_5";				 //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				}

			}
			else
			{
				if( level >= 1 )
				{
					//Changes made by Pratheek on 12-06-18[to get the ent_type column value from itm2menu]-Start
//					menuSelQry = "SELECT A.APPLICATION APP,WIN_NAME, B.MENU_PATH MPATH,DESCR,ICON_PATH,OBJ_TYPE FROM USER_RIGHTS A, ITM2MENU B " + //$NON-NLS-1$
					menuSelQry = "SELECT A.APPLICATION APP,WIN_NAME, B.MENU_PATH MPATH,DESCR,ICON_PATH,OBJ_TYPE,B.ENT_TYPES FROM USER_RIGHTS A, ITM2MENU B " + //$NON-NLS-1$
							//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
							//"WHERE PROFILE_ID = '" + profileID + "'" + //$NON-NLS-1$ //$NON-NLS-2$
							"WHERE PROFILE_ID IN " + E12GenericUtility.getFormattedProfileId(profileID) + //$NON-NLS-1$ //$NON-NLS-2$
							"AND A.APPLICATION=B.APPLICATION AND LEVEL_1=MENU_ROW AND LEVEL_2=MENU_COL " + //$NON-NLS-1$
							"AND MENU_SUBCOL=LEVEL_3 AND A.LEVEL_4=B.LEVEL_4 AND A.LEVEL_5=B.LEVEL_5 " +  //$NON-NLS-1$
							"ORDER BY A.APPLICATION,MENU_ROW,MENU_COL,MENU_SUBCOL,A.LEVEL_4,A.LEVEL_5"; //$NON-NLS-1$
				}
				else
				{
					//Changes made by Pratheek on 12-06-18[to get the ent_type column value from itm2menu]-Start
//					menuSelQry = "SELECT APPLICATION APP,WIN_NAME, MENU_PATH MPATH,DESCR,ICON_PATH,OBJ_TYPE FROM ITM2MENU WHERE WIN_NAME NOT IN ('-') ORDER BY APPLICATION,level_1,level_2,Level_3,LEVEL_4,LEVEL_5";				 //$NON-NLS-1$
					menuSelQry = "SELECT APPLICATION APP,WIN_NAME, MENU_PATH MPATH,DESCR,ICON_PATH,OBJ_TYPE,ENT_TYPES FROM ITM2MENU WHERE WIN_NAME NOT IN ('-') ORDER BY APPLICATION,level_1,level_2,Level_3,LEVEL_4,LEVEL_5";				 //$NON-NLS-1$
				}
			}

			BaseLogger.log("3", userInfo, null,"DBAccessEJB: menuSelQry    ["+menuSelQry+"]");	 //$NON-NLS-1$ //$NON-NLS-2$
			mStatement = mConnection.createStatement();
			mResultSet = mStatement.executeQuery(menuSelQry);

			boolean recFound = false;
			while (mResultSet.next())
			{
				recFound = true;
				appln = mResultSet.getString("APP"); //$NON-NLS-1$
				mWinName = mResultSet.getString("WIN_NAME"); //$NON-NLS-1$
				mpath = mResultSet.getString("MPATH"); //$NON-NLS-1$
				//Added by Pratheek on 11-06-18[to show menu based on ent_types column values of itm2menu and Enterprise table]-Start
				entTypes = E12GenericUtility.checkNull(mResultSet.getString("ENT_TYPES"));
				//Added by Pratheek on 11-06-18[to show menu based on ent_types column values of itm2menu and Enterprise table]-End
				BaseLogger.log("3", userInfo, null, "DBAccessEJB :: getting menu xml  "); //$NON-NLS-1$
				BaseLogger.log("3", userInfo, null,"mpath-------------------------------------------:"+mpath); //$NON-NLS-1$
				//Changes made by Pratheek on 12-06-18 [to show the menu based on ent_types values]-Start
				//Changes made by Pratheek on 26-06-18[to check if enty_type and ent_types column value]-Start
				if(entTypes.length() > 0 && enterpriseType.length() > 0 && entTypes.contains(enterpriseType))
				{
					if(mpath != null)
					{
						tpath = mpath.substring( mpath.indexOf( '.' ) + 1 );
						tpath1 = tpath.substring( tpath.indexOf( '.' )+1, tpath.lastIndexOf( '.' )  );
						tpath2 = tpath1.substring(tpath1.indexOf('.'));
						level1 = tpath.substring(0,tpath.indexOf('.'));
						level2 = tpath1.substring(0,tpath1.indexOf('.'));
						level3 = tpath2.substring(tpath2.indexOf('.')+1,tpath2.lastIndexOf('.')  );
						level4 = tpath1.substring(tpath1.lastIndexOf('.')+1  );
						level5 = mpath.substring(mpath.lastIndexOf('.')+1  );

						BaseLogger.log("3", userInfo, null, "Level 1 [ "+level1+ "]" ); //$NON-NLS-1$ //$NON-NLS-2$
						BaseLogger.log("3", userInfo, null, "Level 2 [ "+level2+ "]" ); //$NON-NLS-1$ //$NON-NLS-2$
						BaseLogger.log("3", userInfo, null, "Level 3 [ "+level3+ "]" ); //$NON-NLS-1$ //$NON-NLS-2$
						BaseLogger.log("3", userInfo, null, "Level 4 [ "+level4+ "]" ); //$NON-NLS-1$ //$NON-NLS-2$
						BaseLogger.log("3", userInfo, null, "Level 5 [ "+level5+ "]" ); //$NON-NLS-1$ //$NON-NLS-2$

						app_descr = mResultSet.getString("DESCR"); //$NON-NLS-1$
						mIconPath = mResultSet.getString("ICON_PATH"); //$NON-NLS-1$
						mObjType = mResultSet.getString("OBJ_TYPE"); //$NON-NLS-1$
						if (!(appln.equals(tApp)))
						{
							tApp = appln;
							if (rno>1)
							{
								mXML.append("</APP>"); //$NON-NLS-1$
							}
							if (rno==1)
							{
								rno++;
							}
							BaseLogger.log("3", userInfo, null, "DBAccessEJB ApplicationName [ "+appln+ "]");  //$NON-NLS-1$ //$NON-NLS-2$
							mXML.append("<APP ANAME='" + appln + "'>"); //$NON-NLS-1$ //$NON-NLS-2$
						}
						if ( ! level1.equals("0"))  //$NON-NLS-1$
						{
							//if level 1 is defined then generates the child of application
							qry="SELECT DESCR,ICON_PATH  FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
									" AND LEVEL_1=0 AND LEVEL_2=0 AND LEVEL_3 = 0 AND LEVEL_4=0 AND LEVEL_5=0"; //$NON-NLS-1$
							mStatement1 = mConnection.createStatement();
							mResultSet1 = mStatement1.executeQuery(qry);
							if(mResultSet1.next())
							{
								prev_descr1 = mResultSet1.getString("DESCR"); //$NON-NLS-1$
								prevIconPath = mResultSet1.getString("ICON_PATH"); //$NON-NLS-1$
							}
							mStatement1.close();
							mStatement1 = null;

							if (!((prev_descr1.equals(tLev1_descr))))
							{
								tLev1_descr=prev_descr1;
								mXML.append("<LEVEL WIN='0' VAL1='0' VAL2='0' VAL3='0' VAL4='0' VAL5='0' ICON='"+prevIconPath+"' OBJ_TYPE=''><![CDATA[" + prev_descr1 + " ]]>"); //For level //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
								mXML.append("</LEVEL>"); //$NON-NLS-1$
							}
						}
						BaseLogger.log("3", userInfo, null, "DBAaceesEJB :: level 2 [" +level2+"]" ); //$NON-NLS-1$ //$NON-NLS-2$
						if (!(level2.equals("0")))  //$NON-NLS-1$
						{
							//if level 2 is defined then generates the child of level 1
							qry="SELECT DESCR,ICON_PATH FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
									"AND LEVEL_1= " + level1 + " AND LEVEL_2=0 AND LEVEL_3 = 0 AND LEVEL_4=0 AND LEVEL_5=0"; //$NON-NLS-1$ //$NON-NLS-2$
							mStatement1 = mConnection.createStatement();
							mResultSet1 = mStatement1.executeQuery(qry);
							if(mResultSet1.next())
							{
								prev_descr2 =mResultSet1.getString("DESCR"); //$NON-NLS-1$
								prevIconPath =mResultSet1.getString("ICON_PATH"); //$NON-NLS-1$
							}
							mStatement1.close();
							mStatement1 = null;
							BaseLogger.log("3", userInfo, null, "DBAaceesEJB :: prev_descr2 [" +prev_descr2+"] tLev2_descr [ "+tLev2_descr+" ]"  ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
							if (!((prev_descr2.equals(tLev2_descr))))
							{
								tLev2_descr=prev_descr2;
								mXML.append("<LEVEL WIN='0' VAL1='" + level1 + "' VAL2='0' VAL3='0' VAL4='0' VAL5='0' ICON='"+prevIconPath+"' OBJ_TYPE=''><![CDATA[" + prev_descr2 + " ]]>"); //For level //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
								mXML.append("</LEVEL>"); //$NON-NLS-1$
							}
						}
						if (!(level3.equals("0")))  //$NON-NLS-1$
						{
							//if level 3 is defined then generates the child of node at level 2
							qry="SELECT DESCR,ICON_PATH FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
									"AND LEVEL_1= " + level1+ " AND LEVEL_2= " + level2 + " AND LEVEL_3 = 0 AND LEVEL_4=0 AND LEVEL_5=0"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
							mStatement1 = mConnection.createStatement();
							mResultSet1 = mStatement1.executeQuery(qry);

							if(mResultSet1.next())
							{
								prev_descr3 =mResultSet1.getString("DESCR"); //$NON-NLS-1$
								prevIconPath =mResultSet1.getString("ICON_PATH"); //$NON-NLS-1$

							}
							mStatement1.close();
							mStatement1 = null;

							if (!((prev_descr3.equals(tLev3_descr))))
							{
								tLev3_descr=prev_descr3;
								mXML.append("<LEVEL WIN='0' VAL1='" + level1 + "' VAL2='" + level2 + "' VAL3='0' VAL4='0' VAL5='0' ICON='"+prevIconPath+"' OBJ_TYPE=''><![CDATA[" + prev_descr3 + " ]]>"); //For level //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
								mXML.append("</LEVEL>"); //$NON-NLS-1$
							}
						}
						if (!(level4.equals("0"))) //$NON-NLS-1$
						{
							//if level 4 is defined then generates the child of node at level 3
							qry="SELECT DESCR,ICON_PATH  FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
									" AND LEVEL_1= " + level1 + " AND LEVEL_2="+ level2 +  //$NON-NLS-1$ //$NON-NLS-2$
									" AND LEVEL_3 = "+ level3 + " AND LEVEL_4=0 AND LEVEL_5=0"; //$NON-NLS-1$ //$NON-NLS-2$

							mStatement1 = mConnection.createStatement();
							mResultSet1 = mStatement1.executeQuery(qry);
							// updated by rahul - start
							//mResultSet1.next();
							//prev_descr4 =mResultSet1.getString("DESCR");
							if(mResultSet1.next())
							{
								prev_descr4 =mResultSet1.getString("DESCR"); //$NON-NLS-1$
								prevIconPath =mResultSet1.getString("ICON_PATH");					 //$NON-NLS-1$
							}

							mStatement1.close();
							mStatement1 = null;
							if (!((prev_descr4.equals(tLev4_descr))))
							{
								tLev4_descr = prev_descr4;
								mXML.append("<LEVEL WIN='0' VAL1='" + level1 + "' VAL2='" +  //$NON-NLS-1$ //$NON-NLS-2$
										level2 + "' VAL3='" + level3 + "' VAL4='0' VAL5='0' ICON='"+prevIconPath+"' OBJ_TYPE=''><![CDATA[" + prev_descr4 + " ]]>"); //For level //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
								mXML.append("</LEVEL>"); //$NON-NLS-1$
							}
						}
						if (!(level5.equals("0")))  //$NON-NLS-1$
						{
							//if level 5 is defined then generates the child of node at level 4 - rahul
							qry="SELECT DESCR,ICON_PATH  FROM ITM2MENU WHERE APPLICATION='" + appln + "'" +  //$NON-NLS-1$ //$NON-NLS-2$
									" AND LEVEL_1= " + level1 + " AND LEVEL_2="+ level2 +  //$NON-NLS-1$ //$NON-NLS-2$
									" AND LEVEL_3 = "+ level3 + " AND LEVEL_4=" + level4 + " AND LEVEL_5=0"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$

							mStatement1 = mConnection.createStatement();
							mResultSet1 = mStatement1.executeQuery(qry);
							if(mResultSet1.next())
							{
								prev_descr5 =mResultSet1.getString("DESCR"); //$NON-NLS-1$
								prevIconPath =mResultSet1.getString("ICON_PATH"); //$NON-NLS-1$
							}
							mStatement1.close();
							mStatement1 = null;

							if (!((prev_descr5.equals(tLev5_descr))))
							{
								tLev5_descr=prev_descr5;
								mXML.append("<LEVEL WIN='0' VAL1='" + level1 + "' VAL2='" +  //$NON-NLS-1$ //$NON-NLS-2$
										level2 + "' VAL3='" + level3 + "' VAL4='" + level4 + //$NON-NLS-1$ //$NON-NLS-2$
										"' VAL5='0' ICON='"+prevIconPath+"' OBJ_TYPE=''><![CDATA[" + prev_descr5 + " ]]>"); //For level 4 //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
								mXML.append("</LEVEL>"); //$NON-NLS-1$
							}
						}
						mXML.append("<LEVEL  WIN='" + mWinName + "' VAL1='" + level1 + "' VAL2='" + level2 + "' VAL3='" + level3 + "' VAL4='" + level4 + "' VAL5='" + level5 + "' ICON='"+mIconPath+"' OBJ_TYPE='"+mObjType+"'><![CDATA[" + app_descr + " ]]>"); //For level //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$
						mXML.append("</LEVEL>"); //$NON-NLS-1$
					}//if(mpath != null)
				}
				//Changes made by Pratheek on 12-06-18 [to show the menu based on ent_types values]-End
			}
			if (recFound)
			{
				mXML.append("</APP>"); //$NON-NLS-1$
			}
			mXML.append("</ROOT>");	 //$NON-NLS-1$
			mResultSet.close();
			mStatement.close();
			mStatement = null;
			BaseLogger.log("3", userInfo, null,"(DBAccessEJB:getUserXML)UserXML 1475 : Built"); //$NON-NLS-1$
		}
		catch ( ITMException itme )
		{
			System.err.println("ITMException: DBAccess: getUserXML: ==>UserXML: Not Built(Generic Exception)\n"); //$NON-NLS-1$
			throw itme;
		}
		catch( SQLException ex )
		{
			System.err.println("Exception: DBAccess: getUserXML: ==>UserXML: Not Built(SQLException)\n" + ex); //$NON-NLS-1$
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccess: getUserXML: ==>UserXML: Not Built(Generic Exception)\n" + e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(mStatement != null)
					{
						mStatement.close();
					}
					if(mStatement1 != null)
					{
						mStatement1.close();
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getUserXML ==>UserXML: Not Built F\n" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		return mXML.toString();
	}
	//Overloaded method added by Gulzar on 11/02/14 to support multidB connection : END

	//Added overloaded method by Gulzar [24/10/13] to support multiDB connection :START
	private String getLinkInfo( String objName, String formNo, UserInfoBean userInfo ) throws ITMException
	{
		String linkInfoStr = null;
		try
		{
			//LinkControllerLocal linkControllerRemote = ( LinkControllerLocal ) this.getInitialContext().lookup( "ibase/LinkControllerEJB/local" ); //$NON-NLS-1$
			LinkControllerEJB linkControllerEJB = new LinkControllerEJB();
			linkInfoStr = linkControllerEJB.getLinkInfo(objName,formNo, userInfo);
			linkControllerEJB = null;
		}
		catch ( ITMException itme )
		{
			BaseLogger.log("0", userInfo, null, "ITMException : DBAccessEJB : getLinkInfo : ==>" ); //$NON-NLS-1$
			throw itme;
		}
		catch ( Exception e )
		{
			BaseLogger.log("0", userInfo, null, "Exception : DBAccessEJB :getLinkInfo : ==>" ); //$NON-NLS-1$
			throw new ITMException( e );
		}
		return linkInfoStr;
	}

	//Changed by gulzar on 10/10/13 to support multiDB connection : overloaded method :START
	private String getColumnInfo( String objName, String formNo, String pageContext, String metaDataFileName, UserInfoBean userInfo ) throws ITMException
	{
		StringBuffer columnInfoXMLBuff = null;
		try
		{
			columnInfoXMLBuff = new StringBuffer();
			BaseLogger.log("3", userInfo, null, "getColumnInfo : " + pageContext ); //$NON-NLS-1$

			//Changed by Gulzar on [23/10/13] [] : START
			String transDB = userInfo.getTransDB();
			//Changed by Gulzar on [23/10/13] [] : END

			ArrayList itemChangeFieldList = this.getItemChangeElementList( objName, formNo, userInfo );
			BaseLogger.log("3", userInfo, null, "itemChangeFieldList : " + itemChangeFieldList ); //$NON-NLS-1$

			HashMap validateElementMap = this.getValidateElementMap( objName, userInfo );
			ArrayList clientValidateFieldList =null;
			if(validateElementMap != null)
			{
				clientValidateFieldList = (ArrayList) validateElementMap.get("C"); //$NON-NLS-1$
			}

			if(itemChangeFieldList.contains("itm_default")) //$NON-NLS-1$
			{
				columnInfoXMLBuff.append("<Column id=\"itm_default\" srvCallOnChange=\"true\" />\n"); //$NON-NLS-1$
			}
			if(itemChangeFieldList.contains("itm_defaultedit")) //$NON-NLS-1$
			{
				columnInfoXMLBuff.append("<Column id=\"itm_defaultedit\" srvCallOnChange=\"true\" />\n"); //$NON-NLS-1$
			}

			//Changes done by Gaurav Singh on 13-JUL-2016 [ setIBASEHOME only when TOMCAT_HOME is null | Start ]
			//CommonConstants.setIBASEHOME();
			if(CommonConstants.TOMCAT_HOME == null || CommonConstants.TOMCAT_HOME.trim().length() == 0)
			{
				CommonConstants.setIBASEHOME();
			}
			//Changes done by Gaurav Singh on 13-JUL-2016 [ setIBASEHOME only when TOMCAT_HOME is null | End ]

			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			DocumentBuilder db = dbf.newDocumentBuilder();
			Document doc = null;
			if(metaDataFileName != null && metaDataFileName.length() > 0 && ( ! "null".equalsIgnoreCase(metaDataFileName))) //$NON-NLS-1$
			{
				// Commented and Added by Pankaj R on 24-Nov-20 as suggested by Danish sir
				// doc = db.parse(new File(CommonConstants.JBOSSHOME + File.separator + "bin" + File.separator + "metadata" + File.separator + metaDataFileName + ".xml")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				doc = db.parse(new File(CommonConstants.JBOSSHOME + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "metadata" + File.separator + metaDataFileName + ".xml")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}
			else
			{
				// Commented and Added by Pankaj R on 24-Nov-20 as suggested by Danish sir
				// doc = db.parse(new File(CommonConstants.JBOSSHOME + File.separator + "bin" + File.separator + "metadata" + File.separator + objName + pageContext + formNo + ".xml")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				doc = db.parse(new File(CommonConstants.JBOSSHOME + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "metadata" + File.separator + objName + pageContext + formNo + ".xml")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}
			String fieldName = ""; //$NON-NLS-1$
			NodeList columnObjectList = doc.getElementsByTagName("ColumnObject"); //$NON-NLS-1$
			for(int i=0;i<columnObjectList.getLength();i++)
			{
				Node currColumnObject =(Node)columnObjectList.item(i);
				NodeList columnObjectDetail = currColumnObject.getChildNodes();
				for(int j=0;j<columnObjectDetail.getLength();j++)
				{
					if(!(columnObjectDetail.item(j).getNodeName().equalsIgnoreCase("#text"))) //$NON-NLS-1$
					{
						if(columnObjectDetail.item(j).getFirstChild() != null)
						{
							fieldName = columnObjectDetail.item(j).getFirstChild().getNodeValue();
							if(columnObjectDetail.item(j).getNodeName().equalsIgnoreCase("NAME")) //$NON-NLS-1$
							{
								boolean columnFlag = false;
								String popUpInfoStr = null;
								StringBuffer valInfoBuff = new StringBuffer();
								String srvColStr = null;

								//Changes made by Gulzar on [23/10/13] [] :START
								PopUpHandler popUpHandler = null;
//								if(transDB != null && transDB.trim().length() > 0)
//								{
									BaseLogger.log("3", null, null,"Before :DBAccessEJB :getColumn() overloaded");
									popUpHandler = new PopUpHandler(userInfo);
//								}
//								else
//								{
//									BaseLogger.log("3", null, null,"Before :DBAccessEJB :getColumn()");
//									popUpHandler = new PopUpHandler();
//								}
								String popUpString = popUpHandler.getFieldPopUpXML(fieldName, objName, "1"); //$NON-NLS-1$
								if(popUpString != null)
								{
									columnFlag = true;
									if(popUpString.equalsIgnoreCase("NOPARAM")) //$NON-NLS-1$
									{
										popUpInfoStr = "popUpExists=\"true\" popUpParam=\"NULL\" "; //$NON-NLS-1$
									}
									else
									{
										popUpInfoStr = "popUpExists=\"true\" popUpParam=\""+popUpString+"\" "; //$NON-NLS-1$ //$NON-NLS-2$
									}
								}

								if(itemChangeFieldList != null && itemChangeFieldList.contains(fieldName))
								{
									columnFlag = true;
									srvColStr = "srvCallOnChange=\"true\" "; //$NON-NLS-1$
								}
								if(clientValidateFieldList != null )
								{
									for(int k=0;k < clientValidateFieldList.size();k++)
									{
										columnFlag = true;
										HashMap fieldMap=(HashMap)clientValidateFieldList.get(k);
										String mapFieldName=((String)fieldMap.get("FIELD_NAME")).trim(); //$NON-NLS-1$
										if( mapFieldName.equalsIgnoreCase( fieldName ) )
										{
											String blankOpt=((String)fieldMap.get("BLANK_OPT")); //$NON-NLS-1$
											String valType =((String)fieldMap.get("VAL_TYPE")); //$NON-NLS-1$
											String validateFromObjectName =((String)fieldMap.get("OBJ_NAME")); //$NON-NLS-1$
											String description = ((String)fieldMap.get("DESCR")); //$NON-NLS-1$
											String errorCode = ((String)fieldMap.get("ERROR_CD")); //$NON-NLS-1$
											valInfoBuff.append("<ValInfo "); //$NON-NLS-1$
											if(blankOpt != null)
											{
												valInfoBuff.append("BlankOpt =\""+blankOpt+"\" "); //$NON-NLS-1$ //$NON-NLS-2$
											}
											if(valType != null)
											{
												valInfoBuff.append("ValType =\""+valType+"\" "); //$NON-NLS-1$ //$NON-NLS-2$
											}
											if(validateFromObjectName != null)
											{
												valInfoBuff.append("ValidateFromObjName =\""+validateFromObjectName+"\" "); //$NON-NLS-1$ //$NON-NLS-2$
											}
											if(errorCode != null)
											{
												valInfoBuff.append("ErrorCode =\""+errorCode+"\" >\n"); //$NON-NLS-1$ //$NON-NLS-2$
												valInfoBuff.append("<Message><![CDATA["+description +"]]></Message>\n"); //$NON-NLS-1$ //$NON-NLS-2$
												valInfoBuff.append("</ValInfo >\n"); //$NON-NLS-1$
											}
											else
											{
												valInfoBuff.append("/>\n"); //$NON-NLS-1$
											}
										}
									}
								}
								if ( columnFlag )
								{
									columnFlag = false;
									columnInfoXMLBuff.append("<Column id=\""+fieldName+"\" "); //$NON-NLS-1$ //$NON-NLS-2$
									if (popUpInfoStr != null)
									{
										columnInfoXMLBuff.append(popUpInfoStr);
									}
									if (srvColStr!= null)
									{
										columnInfoXMLBuff.append(srvColStr);
									}

									String popHelpCols = ""; //$NON-NLS-1$
									String popHelpSrc = ""; //$NON-NLS-1$
									String multiOptPopUp = ""; //$NON-NLS-1$
									String helpOption = ""; //$NON-NLS-1$
									String popHelpColsNSrcXML = popUpHandler.getPopHelpColsNSrc(fieldName, objName, "1"); //$NON-NLS-1$
									Document popHelpColsNSrcDoc = new E12GenericUtility().parseString( popHelpColsNSrcXML );
									if( popHelpColsNSrcDoc != null )
									{
										Node popHelpColsNSrcDocFirstChild = popHelpColsNSrcDoc.getFirstChild();
										if( popHelpColsNSrcDocFirstChild != null )
										{
											NodeList popHelpColsNSrcList = popHelpColsNSrcDocFirstChild.getChildNodes();
											int nodeListLen = popHelpColsNSrcList.getLength();
											for (int k=0; k < nodeListLen; k++)
											{
												Node currNode = popHelpColsNSrcList.item(k);
												String nodeName = currNode.getNodeName();
												if ( "POPHELP_COLS".equalsIgnoreCase(nodeName) ) //$NON-NLS-1$
												{
													if (currNode.getFirstChild() != null )
													{
														popHelpCols = currNode.getFirstChild().getNodeValue();
													}
												}
												else if ( "POPHELP_SOURCE".equalsIgnoreCase(nodeName) ) //$NON-NLS-1$
												{
													if (currNode.getFirstChild() != null )
													{
														popHelpSrc = currNode.getFirstChild().getNodeValue();
													}
												}
												else if ( "MULTI_OPT_POPUP".equalsIgnoreCase(nodeName) ) //$NON-NLS-1$
												{
													if (currNode.getFirstChild() != null )
													{
														multiOptPopUp = currNode.getFirstChild().getNodeValue();
													}
												}
												else if ( "HELP_OPTION".equalsIgnoreCase(nodeName) ) //$NON-NLS-1$
												{
													if (currNode.getFirstChild() != null )
													{
														helpOption = currNode.getFirstChild().getNodeValue();
													}
												}
											}
											columnInfoXMLBuff.append("popUpSource =\"").append(popHelpSrc).append("\"");//Manish //$NON-NLS-1$ //$NON-NLS-2$

											columnInfoXMLBuff.append(" multiOptPopUp =\"").append(multiOptPopUp).append("\""); //$NON-NLS-1$ //$NON-NLS-2$
											columnInfoXMLBuff.append(" helpOption =\"").append(helpOption).append("\">"); //$NON-NLS-1$ //$NON-NLS-2$
										}
									}
									if(valInfoBuff.length()  > 0)
									{
										columnInfoXMLBuff.append( valInfoBuff.toString() );
									}
									if( popHelpCols.length() > 0 )
									{
										columnInfoXMLBuff.append("<POPHELP_COLS>").append(popHelpCols).append("</POPHELP_COLS>"); //$NON-NLS-1$ //$NON-NLS-2$
									}
									columnInfoXMLBuff.append("</Column>"); //$NON-NLS-1$
								}
							}
						}
					}
				}
			}
		}
		catch (ITMException itme)
		{
			BaseLogger.log("0", userInfo, null, "ITMException : DBAccessEJB : getColumnInfo : ==>" ); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo, null,"Exception : DBAccessEJB : getColumnInfo :==>"); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return columnInfoXMLBuff.toString();
	}

	//Changed : END

	//Changes made by Gulzar on 23/10/13 : created overloaded method and passed userInfor String parameter : START
	public HashMap getObjDetailMap(String objName, UserInfoBean userInfo ) throws RemoteException, ITMException
	{
		HashMap objDetailMap = null;
		Connection mConnection = null;
		Statement mStmt = null;
		ResultSet mRs=null;
		int iResult=0;
        String objInfo = null;
        JSONObject DocWiseDeleteValues = new JSONObject(); //Added by Pramod S on 13-Jun-2022 [To get document type values as key and show_del_attach as value] - START
		try
		{
			String transDB = userInfo.getTransDB();
			BaseLogger.log("3", userInfo, null,"transDB in getobjDetailMap @@:["+transDB+"]");
			BaseLogger.log("3", userInfo, null,"transDB in getobjDetailMap objName @@:["+objName+"]");
			ConnDriver mConnDriver = new ConnDriver();
			if (null != transDB && transDB.length() > 0 && !("null".equals(transDB)))
			{
				mConnection = mConnDriver.getConnectDB(transDB); //$NON-NLS-1$
			}

			objName = (objName.startsWith("w_"))?objName : "w_" + objName; //$NON-NLS-1$ //$NON-NLS-2$
			//Changed by Danish on 13/07/2006 to collect edit opt and audit opt from Transetup
			//Changed by Danish on 09/10/2006 [to add cache_opt]
			//String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT FROM TRANSETUP WHERE TRAN_WINDOW='"+objName +"'";

			//Changed by Dhruv on 06/11/2007 to select REPEAT_ADD_DET for detail repeat flag.
			//String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL FROM TRANSETUP WHERE TRAN_WINDOW='"+objName +"'";
			//Changed by Danish on 07/11/2007 to select TRAN_ID_COL to include in Map
			//String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL FROM TRANSETUP WHERE TRAN_WINDOW='"+objName +"'";
			//Change by Nilesh on 29-JAN-11 [MK01SUN011] [To get period_option from transetup]
			//Change by Nilesh on 17-Feb-11 [DI01SUN004] [To get EXP_TYPE from transetup ]
			//String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL,TRAN_ID_COL, PERIOD_OPTION FROM TRANSETUP WHERE TRAN_WINDOW='"+objName +"'";

			//Added By Prajyot on 6-AUG-2012 [HEADER_FORM_NO : TranID generation started from this form number in wizard i.e. TranID generation entry form ]
			//String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL,TRAN_ID_COL, PERIOD_OPTION, EXEC_TYPE,ALLOW_ATTACH FROM TRANSETUP WHERE TRAN_WINDOW='"+objName +"'";			 //$NON-NLS-1$ //$NON-NLS-2$
			//String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL,TRAN_ID_COL, PERIOD_OPTION, EXEC_TYPE,ALLOW_ATTACH, HEADER_FORM_NO FROM TRANSETUP WHERE TRAN_WINDOW='"+objName +"'";			 //$NON-NLS-1$ //$NON-NLS-2$
			//Changed by Dnyaneshwar on 19/11/12 [ WS2GSUN002 || Add new column 'MSG_ONSAVE' in the sqlquery ] Start

			//Changed by Reema on 01/Nov/14 [S14CSUN002 || Add new column 'CONFIRM_DATE_COL' in sqlquery] start
			//String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL,TRAN_ID_COL, PERIOD_OPTION, EXEC_TYPE,ALLOW_ATTACH, HEADER_FORM_NO, MSG_ONSAVE FROM TRANSETUP WHERE TRAN_WINDOW='"+objName +"'";			 //$NON-NLS-1$ //$NON-NLS-2$
			//String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL,TRAN_ID_COL, PERIOD_OPTION, EXEC_TYPE,ALLOW_ATTACH, HEADER_FORM_NO, MSG_ONSAVE, CONFIRM_DATE_COL FROM TRANSETUP WHERE TRAN_WINDOW='"+objName +"'";			 //$NON-NLS-1$ //$NON-NLS-2$
			//Changed by Prajyot on 11/DEC/14 [HR Portal || Add new column 'BROW_DATA_DEF' in sqlquery] start
			//String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL,TRAN_ID_COL, PERIOD_OPTION, EXEC_TYPE,ALLOW_ATTACH, HEADER_FORM_NO, MSG_ONSAVE, CONFIRM_DATE_COL, BROW_DATA_DEF FROM TRANSETUP WHERE TRAN_WINDOW='"+objName +"'";			 //$NON-NLS-1$ //$NON-NLS-2$
			//Changed by Reema on 20/Jan/15 [S14GSUN005 || Add new columns 'DEF_VIEW', 'VIEW_OPTS' in sqlquery ]
			//Changed by Savita Yadav on 10-08-2015 [Added columns THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL to get dynamic images]
			//			String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL,TRAN_ID_COL, PERIOD_OPTION, EXEC_TYPE,ALLOW_ATTACH, HEADER_FORM_NO, MSG_ONSAVE, CONFIRM_DATE_COL, BROW_DATA_DEF, DEF_VIEW, VIEW_OPTS FROM TRANSETUP WHERE TRAN_WINDOW='"+objName +"'";			 //$NON-NLS-1$ //$NON-NLS-2$
			//Changed by Reema on 4-sep-15 [to show different flag for cofirm_col,cancel_col, in_wf_col, unconfirm_col ]
			//			String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL,TRAN_ID_COL, PERIOD_OPTION, EXEC_TYPE,ALLOW_ATTACH, HEADER_FORM_NO, MSG_ONSAVE, CONFIRM_DATE_COL, BROW_DATA_DEF, DEF_VIEW, VIEW_OPTS, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL FROM TRANSETUP WHERE TRAN_WINDOW='"+objName +"'";			 //$NON-NLS-1$ //$NON-NLS-2$
			//			Changed by Savita Yadav on 17/12/15 [To show DEFAULT_DATA_ROW]
			//			String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL,TRAN_ID_COL, PERIOD_OPTION, EXEC_TYPE,ALLOW_ATTACH, HEADER_FORM_NO, MSG_ONSAVE, CONFIRM_DATE_COL, BROW_DATA_DEF, DEF_VIEW, VIEW_OPTS, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL, CANCEL_COL, CANCEL_VAL, IN_WF_COL, IN_WF_VAL FROM TRANSETUP WHERE TRAN_WINDOW='"+objName +"'";			 //$NON-NLS-1$ //$NON-NLS-2$
			//String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL,TRAN_ID_COL, PERIOD_OPTION, EXEC_TYPE,ALLOW_ATTACH, HEADER_FORM_NO, MSG_ONSAVE, CONFIRM_DATE_COL, BROW_DATA_DEF, DEF_VIEW, VIEW_OPTS, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL, CANCEL_COL, CANCEL_VAL, IN_WF_COL, IN_WF_VAL, DEFAULT_DATA_ROW FROM TRANSETUP WHERE TRAN_WINDOW='"+objName +"'";			 //$NON-NLS-1$ //$NON-NLS-2$
			//Change by Sandeep S. on 2/12/16 [To open transaction in default editor layout]
			//String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL,TRAN_ID_COL, PERIOD_OPTION, EXEC_TYPE,ALLOW_ATTACH, HEADER_FORM_NO, MSG_ONSAVE, CONFIRM_DATE_COL, BROW_DATA_DEF, DEF_VIEW, VIEW_OPTS, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL, CANCEL_COL, CANCEL_VAL, IN_WF_COL, IN_WF_VAL, DEFAULT_DATA_ROW, DEFAULT_EDITOR FROM TRANSETUP WHERE TRAN_WINDOW='"+objName +"'";			 //$NON-NLS-1$ //$NON-NLS-2$
			//Changed by shrutika on 23-02-17 [To get msg_str against msg_no]
//			String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL,TRAN_ID_COL, PERIOD_OPTION, EXEC_TYPE,ALLOW_ATTACH, HEADER_FORM_NO, MSG_ONSAVE, CONFIRM_DATE_COL, BROW_DATA_DEF, DEF_VIEW, VIEW_OPTS, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL, CANCEL_COL, CANCEL_VAL, IN_WF_COL, IN_WF_VAL, DEFAULT_DATA_ROW, DEFAULT_EDITOR, TR.MSG_NO, MSG.MSG_STR, ISATTACHMENT, START_FORM, RESTART_FORM FROM TRANSETUP TR LEFT OUTER JOIN MESSAGES MSG ON TR.MSG_NO=MSG.MSG_NO WHERE TRAN_WINDOW='"+objName +"'";//shrutika
			//Changed by Prasad on 13/07/18 [LOAD_MODE column added]
			//String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL,TRAN_ID_COL, PERIOD_OPTION, EXEC_TYPE,ALLOW_ATTACH, HEADER_FORM_NO, MSG_ONSAVE, CONFIRM_DATE_COL, BROW_DATA_DEF, DEF_VIEW, VIEW_OPTS, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL, CANCEL_COL, CANCEL_VAL, IN_WF_COL, IN_WF_VAL, DEFAULT_DATA_ROW, DEFAULT_EDITOR, ENABLE_EDITOR, ISATTACHMENT, START_FORM, RESTART_FORM, TR.MSG_NO, MSG.MSG_STR FROM TRANSETUP TR LEFT OUTER JOIN MESSAGES MSG ON TR.MSG_NO=MSG.MSG_NO WHERE TRAN_WINDOW='"+objName +"'";   //Added ENABLE_EDITOR column by Sagar B.22/8/17
			//String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL,TRAN_ID_COL, PERIOD_OPTION, EXEC_TYPE,ALLOW_ATTACH, HEADER_FORM_NO, MSG_ONSAVE, CONFIRM_DATE_COL, BROW_DATA_DEF, DEF_VIEW, VIEW_OPTS, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL, CANCEL_COL, CANCEL_VAL, IN_WF_COL, IN_WF_VAL, DEFAULT_DATA_ROW, DEFAULT_EDITOR, ENABLE_EDITOR, ISATTACHMENT, START_FORM, RESTART_FORM, TR.MSG_NO, MSG.MSG_STR, TR.LOAD_MODE FROM TRANSETUP TR LEFT OUTER JOIN MESSAGES MSG ON TR.MSG_NO=MSG.MSG_NO WHERE TRAN_WINDOW='"+objName +"'";   //Added ENABLE_EDITOR column by Sagar B.22/8/17
			//Changed By Pankaj T. on 26-09-18 to add new column CLOSE_COL & CLOSE_VAL
			//Changes made by Pratheek on 25-01-19[to get the site_acc_col value from transetup in reports]-Start
			//String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL,TRAN_ID_COL, PERIOD_OPTION, EXEC_TYPE,ALLOW_ATTACH, HEADER_FORM_NO, MSG_ONSAVE, CONFIRM_DATE_COL, BROW_DATA_DEF, DEF_VIEW, VIEW_OPTS, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL, CANCEL_COL, CANCEL_VAL, IN_WF_COL, IN_WF_VAL, DEFAULT_DATA_ROW, DEFAULT_EDITOR, ENABLE_EDITOR, ISATTACHMENT, START_FORM, RESTART_FORM, TR.MSG_NO, MSG.MSG_STR, TR.LOAD_MODE, CLOSE_COL, CLOSE_VAL FROM TRANSETUP TR LEFT OUTER JOIN MESSAGES MSG ON TR.MSG_NO=MSG.MSG_NO WHERE TRAN_WINDOW='"+objName +"'";   //Added ENABLE_EDITOR column by Sagar B.22/8/17
			//String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL,TRAN_ID_COL, PERIOD_OPTION, EXEC_TYPE,ALLOW_ATTACH, HEADER_FORM_NO, MSG_ONSAVE, CONFIRM_DATE_COL, BROW_DATA_DEF, DEF_VIEW, VIEW_OPTS, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL, CANCEL_COL, CANCEL_VAL, IN_WF_COL, IN_WF_VAL, DEFAULT_DATA_ROW, DEFAULT_EDITOR, ENABLE_EDITOR, ISATTACHMENT, START_FORM, RESTART_FORM, TR.MSG_NO, MSG.MSG_STR, TR.LOAD_MODE, CLOSE_COL, CLOSE_VAL, SITE_ACC_COL FROM TRANSETUP TR LEFT OUTER JOIN MESSAGES MSG ON TR.MSG_NO=MSG.MSG_NO WHERE TRAN_WINDOW='"+objName +"'";   //Added ENABLE_EDITOR column by Sagar B.22/8/17
			String sqlQuery = "SELECT TRAN_WINDOW,SAVE_FLAG,KEY_FLAG,REF_SER,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CONFIRM_COL,CONFIRM_VAL,AUTO_CONFIRM,TABLE_NAME,EDIT_TMPLT,WRKFLW_INIT, REPEATE_ADD, REPEAT_ADD_DET, TRAN_DATE_COL, WORKFLOW_OPT, EDIT_OPT, AUDIT_TRAIL_OPT, CACHE_OPT,EDIT_EXPR,RATE_COL,QTY_COL,TRAN_ID_COL, PERIOD_OPTION, EXEC_TYPE,ALLOW_ATTACH, HEADER_FORM_NO, MSG_ONSAVE, CONFIRM_DATE_COL, BROW_DATA_DEF, DEF_VIEW, VIEW_OPTS, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL, CANCEL_COL, CANCEL_VAL, IN_WF_COL, IN_WF_VAL, DEFAULT_DATA_ROW, DEFAULT_EDITOR, ENABLE_EDITOR, ISATTACHMENT, START_FORM, RESTART_FORM, TR.MSG_NO, MSG.MSG_STR, TR.LOAD_MODE, CLOSE_COL, CLOSE_VAL, SITE_ACC_COL, ATTACH_COUNT_MIN, SYNC_FROM_APP FROM TRANSETUP TR LEFT OUTER JOIN MESSAGES MSG ON TR.MSG_NO=MSG.MSG_NO WHERE TRAN_WINDOW='"+objName +"'";  //30122022 //Added ATTACH_COUNT_MIN column by Prasad on 03/11/19
			//Changes made by Pratheek on 25-01-19[to get the site_acc_col value from transetup in reports]-End
			mStmt = mConnection.createStatement();
			mRs = mStmt.executeQuery(sqlQuery);
			ResultSetMetaData rsmd = mRs.getMetaData();
			objDetailMap = new HashMap();
			//Added by Sagar B. to set User preference value on OBJ_USER_PREF table[26-Apr-19]START
			ObjUserPrefDao objUserPrefDao = new ObjUserPrefDao();
			String objectName = (objName.startsWith("w_")) ? objName.substring(2) : objName; //$NON-NLS-1$ //$NON-NLS-2$
			ArrayList<String> userPrefList = new ArrayList<String>();
			userPrefList.add( "DEF_VIEW" );
			//Added by Sagar B. to set User preference value on OBJ_USER_PREF table[26-Apr-19]END
			//Added by shrutika on 16-07-18 for calculate tax according to the user Preference.
			String taxForms = "";
			while(mRs.next())
			{
				int noOfColumns = rsmd.getColumnCount();
				for(int ctr = 1; ctr <= noOfColumns; ctr++)
				{
					// Changed by gayatri on 28-12-2011 [WI1HBAS001] [Migration of BaseE12 on Mysql] start
					//objDetailMap.put(rsmd.getColumnName(ctr), mRs.getString(ctr));
					//Added by Sagar B. to set User preference value on OBJ_USER_PREF table[26-Apr-19]START
					String colName = rsmd.getColumnName(ctr);
					String colValue = mRs.getString(ctr);
					//Added by shrutika on 16-07-18 [Start] for calculate tax according to the user Preference.
					if( colName.equalsIgnoreCase("TAX_FORMS"))
					{
						taxForms = colValue;
					}
					//Added by shrutika on 16-07-18 [End] for calculate tax according to the user Preference.
					if( userPrefList.contains( colName ) )
					{
						ObjUserPref userObjPref = objUserPrefDao.getObjectPreference(userInfo, objectName, colName);
						BaseLogger.log("3", userInfo,null,"colValue :["+colValue+"]" );
						if( userObjPref != null )
						{
							String prefValue = E12GenericUtility.checkNull(userObjPref.getPrefValue());
							BaseLogger.log("3", userInfo,null,"prefValue :["+prefValue+"]" );
							if( !"".equals(prefValue) )
							{
								colValue = prefValue;
								BaseLogger.log("3", userInfo,null,"colValue after :["+colValue+"]" );
							}
						}
					}
					//Added by Sagar B. to set User preference value on OBJ_USER_PREF table[26-Apr-19]END
					if("mysql".equalsIgnoreCase(CommonConstants.DB_NAME))
					{
						//objDetailMap.put(rsmd.getColumnName(ctr).toUpperCase(), mRs.getString(ctr));
						objDetailMap.put(colName.toUpperCase(), colValue);
					}
					else
					{
						//objDetailMap.put(rsmd.getColumnName(ctr), mRs.getString(ctr));
						objDetailMap.put(colName, colValue);
					}
					// Changed by gayatri on 28-12-2011 [WI1HBAS001] [Migration of BaseE12 on Mysql] end
				}
			}
			//Added by Pooja on 10/06/2020 [to get thumbObjdescr to display at side panel] START
			String thumbObj = checkNull( ""+ objDetailMap.get( "THUMB_OBJ" ) );
			String thumbWinName = (thumbObj.startsWith("w_"))? thumbObj : "w_" + thumbObj;
			String thumbObjDescr = getDBColumnValue( "ITM2MENU", "DESCR", ("WIN_NAME ='"+ thumbWinName +"' AND DESCR IS NOT NULL "), mConnection);
			objDetailMap.put( "THUMB_OBJ_DESCR", thumbObjDescr );
			objDetailMap.put("THUMB_OBJ_RIGHTS", getUserRights(thumbObj,  (userInfo != null) ? userInfo.getProfileId() : "", userInfo.toString()));
			//Added by Pooja on 10/06/2020 [to get thumbObjdescr to display at side panel] END
			
			//Added by shrutika on 16-07-18 [Start] for calculate tax according to the user Preference.
			taxForms = E12GenericUtility.checkNull(taxForms);
			if( !"".equalsIgnoreCase(taxForms))
			{
				if(taxForms.contains(","))
				{
					String taxForarr[] = taxForms.split(",");
					for( int i=0; i < taxForarr.length; i++ )
					{
						String formNo = taxForarr[i];
						String calculateOnchange = "RECALCULATE_TAX_"+formNo;
						ObjUserPref userObjPref = objUserPrefDao.getObjectPreference(userInfo, objectName, calculateOnchange);
						if( userObjPref != null )
						{
							String prefValue = E12GenericUtility.checkNull(userObjPref.getPrefValue());
							if( !"".equals(prefValue) )
							{
								objDetailMap.put(calculateOnchange, prefValue);
							}
						}
						else
						{
							objDetailMap.put(calculateOnchange, "");
						}
					}
				}
				else
				{
					String calculateOnchange = "RECALCULATE_TAX_"+taxForms;
					ObjUserPref userObjPref = objUserPrefDao.getObjectPreference(userInfo, objectName, calculateOnchange);
					if( userObjPref != null )
					{
						String prefValue = E12GenericUtility.checkNull(userObjPref.getPrefValue());
						if( !"".equals(prefValue) )
						{
							objDetailMap.put(calculateOnchange, prefValue);
						}
					}
					else
					{
						objDetailMap.put(calculateOnchange, "");
					}
				}
			}
			//Added by shrutika on 16-07-18 [End] for calculate tax according to the user Preference.
			/*
			mRs.close();
			mStmt.close();
			mStmt = null;
			*/
			//Added by Prasad on 03/11/19 [to add min and max attachment related details] START
			HashMap<String, String> attachMinMaxDetailMap = getObjAttachConfigMinMaxAttachDetails( objName, mConnection, transDB );
			if ( attachMinMaxDetailMap != null && attachMinMaxDetailMap.size() > 0 )
			{
				objDetailMap.putAll( attachMinMaxDetailMap );
			}
			//Added by Prasad on 03/11/19 [to add min and max attachment related details] END
			//Added by Nilesh Start on 27-03-2020 [to add showDeleteAttchAllow  attachment related details] START
			if ( objName != null && objName.startsWith( "w_" ) )
			{
				
				String objetName = objName.substring( 2 );
				String condition = "OBJ_NAME = '"+objetName.trim()+"'";
                //Added by Pramod S on 13-Jun-2022 [To get document type as key and show_del_attach as value and pass it in JSONObject] - START
				//String showDeleteAttchAllow = E12GenericUtility.checkNull( getDBColumnValueNew("OBJ_ATTACH_CONFIG", "SHOW_DEL_ATTACH" , "DOC_TYPE", condition, transDB ) );
                DocWiseDeleteValues =  getDBColumnValueNew("OBJ_ATTACH_CONFIG", "SHOW_DEL_ATTACH" , "DOC_TYPE", condition, transDB );
				//BaseLogger.log("3", userInfo, null,"transDB in SHOW_DEL_ATTACH @@:["+showDeleteAttchAllow+"]");
				objDetailMap.put("SHOW_DEL_ATTACH", DocWiseDeleteValues);
				//Added by Pramod S on 13-Jun-2022 [To get document type as key and show_del_attach as value and pass it in JSONObject] - END
			}
			//Added by Nilesh Start on 27-03-2020 [to add showDeleteAttchAllow  attachment related details] End
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException :DBAccessEJB :getObjInfo :\n"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception :DBAccessEJB :getObjInfo :\n"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(mRs!=null)
					{
						mRs.close();
						mRs = null;
					}
					if(mStmt != null)
					{
						mStmt.close();
						mStmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getObjInfo :==>F" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2",userInfo, null,"Returning objDetailMap :"+objDetailMap); //$NON-NLS-1$
		return objDetailMap;
	}
	//Changes made by Gulzar on 23/10/13 : created overloaded method and passed userInfor String parameter : END

	public ArrayList getObjFormsDetailList(String objName, UserInfoBean userInfo ) throws  RemoteException, ITMException
	{
		String winName = "w_" + objName; //$NON-NLS-1$
		String mQuery = null;
		Connection mConnection = null;
		Statement mStmt = null;
		ResultSet mRs = null;

		//Added by shrutika on 24-07-19 [Start] for Implement user Preference for feed view and table view in case of wizard and process screen.
		ObjUserPrefDao objUserPrefDao = new ObjUserPrefDao();

		ArrayList<ArrayList<String>> objFormsDetailList = new ArrayList<ArrayList<String>>();
		try
		{
			//Changes By Prajyot On 23-Sep-2011 [To select ASSISTED_MODE from obj_forms] Starts
			//mQuery = "SELECT FORM_NO, TITLE, CROSS_UPDATE_EXPR, EXPR_FLD_INFO, TARGET_FLD_INFO, EXPR_COMMENT, SCAN_FLAG, SCAN_METADATA, AUTO_ACCEPT_SCAN, PROPERTY_INFO, AFTER_SAVE, COLUMN_ON_SAVE, SCAN_DELIMITER, EXT_METADATA, AUTO_ACCEPT_WEIGHDATA, SCR_FLAG, FORM_TYPE, DISP_METADATA, PARENT_KEY_COL FROM OBJ_FORMS WHERE WIN_NAME='" + winName + "'" + " AND FORM_NO NOT LIKE '%.%' ORDER BY FORM_NO ";
			//			mQuery = "SELECT FORM_NO, TITLE, CROSS_UPDATE_EXPR, EXPR_FLD_INFO, TARGET_FLD_INFO, EXPR_COMMENT, SCAN_FLAG, SCAN_METADATA, AUTO_ACCEPT_SCAN, PROPERTY_INFO, AFTER_SAVE, COLUMN_ON_SAVE, SCAN_DELIMITER, EXT_METADATA, AUTO_ACCEPT_WEIGHDATA, SCR_FLAG, FORM_TYPE, DISP_METADATA, PARENT_KEY_COL, ASSISTED_MODE FROM OBJ_FORMS WHERE WIN_NAME='" + winName + "'" + " AND FORM_NO NOT LIKE '%.%' ORDER BY FORM_NO "; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			//			mQuery = "SELECT FORM_NO, TITLE, CROSS_UPDATE_EXPR, EXPR_FLD_INFO, TARGET_FLD_INFO, EXPR_COMMENT, SCAN_FLAG, SCAN_METADATA, AUTO_ACCEPT_SCAN, PROPERTY_INFO, AFTER_SAVE, COLUMN_ON_SAVE, SCAN_DELIMITER, EXT_METADATA, AUTO_ACCEPT_WEIGHDATA, SCR_FLAG, FORM_TYPE, DISP_METADATA, PARENT_KEY_COL, ASSISTED_MODE, STORAGE_KEY_METADATA, SELECTION_MODE FROM OBJ_FORMS WHERE WIN_NAME='" + winName + "'" + " AND FORM_NO NOT LIKE '%.%' ORDER BY FORM_NO "; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			//Changed by gayatri on 22-07-2013 [to auto save feature on multiple field]

			//mQuery = "SELECT FORM_NO, TITLE, CROSS_UPDATE_EXPR, EXPR_FLD_INFO, TARGET_FLD_INFO, EXPR_COMMENT, SCAN_FLAG, SCAN_METADATA, AUTO_ACCEPT_SCAN, PROPERTY_INFO, AFTER_SAVE, COLUMN_ON_SAVE, SCAN_DELIMITER, EXT_METADATA, AUTO_ACCEPT_WEIGHDATA, SCR_FLAG, FORM_TYPE, DISP_METADATA, PARENT_KEY_COL, ASSISTED_MODE, STORAGE_KEY_METADATA, SELECTION_MODE, DEFAULT_VIEW FROM OBJ_FORMS WHERE WIN_NAME='" + winName + "'" + " AND FORM_NO NOT LIKE '%.%' ORDER BY FORM_NO "; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			//mQuery = "SELECT FORM_NO, TITLE, CROSS_UPDATE_EXPR, EXPR_FLD_INFO, TARGET_FLD_INFO, EXPR_COMMENT, SCAN_FLAG, SCAN_METADATA, AUTO_ACCEPT_SCAN, PROPERTY_INFO, AFTER_SAVE, COLUMN_ON_SAVE, SCAN_DELIMITER, EXT_METADATA, AUTO_ACCEPT_WEIGHDATA, SCR_FLAG, FORM_TYPE, DISP_METADATA, PARENT_KEY_COL, ASSISTED_MODE, STORAGE_KEY_METADATA, SELECTION_MODE, DEFAULT_VIEW, AUTO_ADDON_ENTRY FROM OBJ_FORMS WHERE WIN_NAME='" + winName + "'" + " AND FORM_NO NOT LIKE '%.%' ORDER BY FORM_NO "; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			// Above Line Commented by AMit D on 27 Dec 13 and order by form no is done by converting to Number.
			//Added by Ajinkya Gopalkar on 30-11-2015 [Request ID :D15HSUN011 - for FREEZE_COL_POS column for freezing column]
			//Changed by Reema on 4-01-2016 [S15JSUN001 - Dynamic row number to be shown in GWT-Wizard screen]
			//mQuery = "SELECT FORM_NO, TITLE, CROSS_UPDATE_EXPR, EXPR_FLD_INFO, TARGET_FLD_INFO, EXPR_COMMENT, SCAN_FLAG, SCAN_METADATA, AUTO_ACCEPT_SCAN, PROPERTY_INFO, AFTER_SAVE, COLUMN_ON_SAVE, SCAN_DELIMITER, EXT_METADATA, AUTO_ACCEPT_WEIGHDATA, SCR_FLAG, FORM_TYPE, DISP_METADATA, PARENT_KEY_COL, ASSISTED_MODE, STORAGE_KEY_METADATA, SELECTION_MODE, DEFAULT_VIEW, AUTO_ADDON_ENTRY, FREEZE_COL_POS FROM OBJ_FORMS WHERE WIN_NAME='" + winName + "'" + " AND FORM_NO NOT LIKE '%.%' " ;
			//Added by Prasad on 02/06/16 [get tran_id_col for all forms]
			//mQuery = "SELECT FORM_NO, TITLE, CROSS_UPDATE_EXPR, EXPR_FLD_INFO, TARGET_FLD_INFO, EXPR_COMMENT, SCAN_FLAG, SCAN_METADATA, AUTO_ACCEPT_SCAN, PROPERTY_INFO, AFTER_SAVE, COLUMN_ON_SAVE, SCAN_DELIMITER, EXT_METADATA, AUTO_ACCEPT_WEIGHDATA, SCR_FLAG, FORM_TYPE, DISP_METADATA, PARENT_KEY_COL, ASSISTED_MODE, STORAGE_KEY_METADATA, SELECTION_MODE, DEFAULT_VIEW, AUTO_ADDON_ENTRY, FREEZE_COL_POS, DEFAULT_ROW_CNT, IS_MANDATORY FROM OBJ_FORMS WHERE WIN_NAME='" + winName + "'" + " AND FORM_NO NOT LIKE '%.%' " ;
			//Changed by sanket on 10/10/16 [get thumb_image for all forms ]
			//mQuery = "SELECT FORM_NO, TITLE, CROSS_UPDATE_EXPR, EXPR_FLD_INFO, TARGET_FLD_INFO, EXPR_COMMENT, SCAN_FLAG, SCAN_METADATA, AUTO_ACCEPT_SCAN, PROPERTY_INFO, AFTER_SAVE, COLUMN_ON_SAVE, SCAN_DELIMITER, EXT_METADATA, AUTO_ACCEPT_WEIGHDATA, SCR_FLAG, FORM_TYPE, DISP_METADATA, PARENT_KEY_COL, ASSISTED_MODE, STORAGE_KEY_METADATA, SELECTION_MODE, DEFAULT_VIEW, AUTO_ADDON_ENTRY, FREEZE_COL_POS, DEFAULT_ROW_CNT, IS_MANDATORY, TRAN_ID_COL, KEY_INFO FROM OBJ_FORMS WHERE WIN_NAME='" + winName + "'" + " AND FORM_NO NOT LIKE '%.%' " ;
			//Gulzar on 11/01/17 and FORM_ICON by Ajinkya: START
			//mQuery = "SELECT FORM_NO, TITLE, CROSS_UPDATE_EXPR, EXPR_FLD_INFO, TARGET_FLD_INFO, EXPR_COMMENT, SCAN_FLAG, SCAN_METADATA, AUTO_ACCEPT_SCAN, PROPERTY_INFO, AFTER_SAVE, COLUMN_ON_SAVE, SCAN_DELIMITER, EXT_METADATA, AUTO_ACCEPT_WEIGHDATA, SCR_FLAG, FORM_TYPE, DISP_METADATA, PARENT_KEY_COL, ASSISTED_MODE, STORAGE_KEY_METADATA, SELECTION_MODE, DEFAULT_VIEW, AUTO_ADDON_ENTRY, FREEZE_COL_POS, DEFAULT_ROW_CNT, IS_MANDATORY, TRAN_ID_COL, KEY_INFO, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL FROM OBJ_FORMS WHERE WIN_NAME='" + winName + "'" + " AND FORM_NO NOT LIKE '%.%' " ;
			//Added by Sandeep S. on 24-NOV-17 [Implementation of Matrix-form detail form] Start
			//mQuery = "SELECT FORM_NO, TITLE, CROSS_UPDATE_EXPR, EXPR_FLD_INFO, TARGET_FLD_INFO, EXPR_COMMENT, SCAN_FLAG, SCAN_METADATA, AUTO_ACCEPT_SCAN, PROPERTY_INFO, AFTER_SAVE, COLUMN_ON_SAVE, SCAN_DELIMITER, EXT_METADATA, AUTO_ACCEPT_WEIGHDATA, SCR_FLAG, FORM_TYPE, DISP_METADATA, PARENT_KEY_COL, ASSISTED_MODE, STORAGE_KEY_METADATA, SELECTION_MODE, DEFAULT_VIEW, AUTO_ADDON_ENTRY, FREEZE_COL_POS, DEFAULT_ROW_CNT, IS_MANDATORY, TRAN_ID_COL, KEY_INFO, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL, FORM_NAME, FORM_ICON, FORM_VIEW_OPTS FROM OBJ_FORMS WHERE WIN_NAME='" + winName + "'" + " AND FORM_NO NOT LIKE '%.%' " ;
			mQuery = "SELECT FORM_NO, TITLE, CROSS_UPDATE_EXPR, EXPR_FLD_INFO, TARGET_FLD_INFO, EXPR_COMMENT, SCAN_FLAG, SCAN_METADATA, AUTO_ACCEPT_SCAN, PROPERTY_INFO, AFTER_SAVE, COLUMN_ON_SAVE, SCAN_DELIMITER, EXT_METADATA, AUTO_ACCEPT_WEIGHDATA, SCR_FLAG, FORM_TYPE, DISP_METADATA, PARENT_KEY_COL, ASSISTED_MODE, STORAGE_KEY_METADATA, SELECTION_MODE, DEFAULT_VIEW, AUTO_ADDON_ENTRY, FREEZE_COL_POS, DEFAULT_ROW_CNT, IS_MANDATORY, TRAN_ID_COL, KEY_INFO, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL, FORM_NAME, FORM_ICON, FORM_VIEW_OPTS, X_COLUMN, Y_COLUMN FROM OBJ_FORMS WHERE WIN_NAME='" + winName + "'" + " AND FORM_NO NOT LIKE '%.%' " ;
			//added by prathamesh jangam on 30jun17 for db2
			BaseLogger.log("3", userInfo, null,"DATABASE NAME["+CommonConstants.DB_NAME+"]");
			if("DB2".equalsIgnoreCase( CommonConstants.DB_NAME ) )
			{
				//mQuery = "SELECT TO_NUMBER(FORM_NO) AS FORM_NO, TITLE, CROSS_UPDATE_EXPR, EXPR_FLD_INFO, TARGET_FLD_INFO, EXPR_COMMENT, SCAN_FLAG, SCAN_METADATA, AUTO_ACCEPT_SCAN, PROPERTY_INFO, AFTER_SAVE, COLUMN_ON_SAVE, SCAN_DELIMITER, EXT_METADATA, AUTO_ACCEPT_WEIGHDATA, SCR_FLAG, FORM_TYPE, DISP_METADATA, PARENT_KEY_COL, ASSISTED_MODE, STORAGE_KEY_METADATA, SELECTION_MODE, DEFAULT_VIEW, AUTO_ADDON_ENTRY, FREEZE_COL_POS, DEFAULT_ROW_CNT, IS_MANDATORY, TRAN_ID_COL, KEY_INFO, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL, FORM_NAME, FORM_ICON, FORM_VIEW_OPTS FROM OBJ_FORMS WHERE WIN_NAME='" + winName + "'" + " AND FORM_NO NOT LIKE '%.%' " ;
				//Changed by Nilesh on 12/01/18 [to resolve casting issue in DB2]
				//mQuery = "SELECT TO_NUMBER(FORM_NO) AS FORM_NO, TITLE, CROSS_UPDATE_EXPR, EXPR_FLD_INFO, TARGET_FLD_INFO, EXPR_COMMENT, SCAN_FLAG, SCAN_METADATA, AUTO_ACCEPT_SCAN, PROPERTY_INFO, AFTER_SAVE, COLUMN_ON_SAVE, SCAN_DELIMITER, EXT_METADATA, AUTO_ACCEPT_WEIGHDATA, SCR_FLAG, FORM_TYPE, DISP_METADATA, PARENT_KEY_COL, ASSISTED_MODE, STORAGE_KEY_METADATA, SELECTION_MODE, DEFAULT_VIEW, AUTO_ADDON_ENTRY, FREEZE_COL_POS, DEFAULT_ROW_CNT, IS_MANDATORY, TRAN_ID_COL, KEY_INFO, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL, FORM_NAME, FORM_ICON, FORM_VIEW_OPTS, X_COLUMN, Y_COLUMN FROM OBJ_FORMS WHERE WIN_NAME='" + winName + "'" + " AND FORM_NO NOT LIKE '%.%' " ;
				mQuery = "SELECT CAST(FORM_NO AS INT) AS FORM_NO, TITLE, CROSS_UPDATE_EXPR, EXPR_FLD_INFO, TARGET_FLD_INFO, EXPR_COMMENT, SCAN_FLAG, SCAN_METADATA, AUTO_ACCEPT_SCAN, PROPERTY_INFO, AFTER_SAVE, COLUMN_ON_SAVE, SCAN_DELIMITER, EXT_METADATA, AUTO_ACCEPT_WEIGHDATA, SCR_FLAG, FORM_TYPE, DISP_METADATA, PARENT_KEY_COL, ASSISTED_MODE, STORAGE_KEY_METADATA, SELECTION_MODE, DEFAULT_VIEW, AUTO_ADDON_ENTRY, FREEZE_COL_POS, DEFAULT_ROW_CNT, IS_MANDATORY, TRAN_ID_COL, KEY_INFO, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL, FORM_NAME, FORM_ICON, FORM_VIEW_OPTS, X_COLUMN, Y_COLUMN FROM OBJ_FORMS WHERE WIN_NAME='" + winName + "'" + " AND FORM_NO NOT LIKE '%.%' " ;
				//Added by Sandeep S. on 24-NOV-17 [Implementation of Matrix-form detail form] End
			}
			if( "oracle".equalsIgnoreCase( CommonConstants.DB_NAME ) )
			{
				mQuery = mQuery + " ORDER BY TO_NUMBER (FORM_NO) "; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}
			else
			{
				mQuery = mQuery + " ORDER BY FORM_NO "; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}

			BaseLogger.log("3",userInfo, null,"getObjFormsDetailList.mQuery["+mQuery+"]"); //$NON-NLS-1$ //$NON-NLS-2$

			ConnDriver mConnDriver = new ConnDriver();

			String transDB=userInfo.getTransDB();
			//commented By Ravindra C on 06-09-18 for prevent SYSOUT.
			//BaseLogger.log("3", null, null,"DBAccessEJB 10207 transDB["+transDB+"]");
			mConnection = mConnDriver.getConnectDB(transDB); //$NON-NLS-1$
			mStmt = mConnection.createStatement();
			mRs = mStmt.executeQuery(mQuery);
			boolean isEntryValid = false;
			ArrayList<String> currFormsDetailList = null;
			String objContext = "1"; //$NON-NLS-1$
			while(mRs.next())
			{
				isEntryValid = true;
				currFormsDetailList = new ArrayList<String>();

				objContext = mRs.getString("FORM_NO"); //$NON-NLS-1$
				String title = mRs.getString("TITLE"); //$NON-NLS-1$
				if((title == null) || (title.equalsIgnoreCase("null")) || title.length() == 0) //$NON-NLS-1$
				{
					title = objName.toUpperCase();
				}
				title = new E12GenericUtility().initCap( title, "_" ); //$NON-NLS-1$
				title = title.replace( '_', ' ' );

				currFormsDetailList.add( title );// [0]
				currFormsDetailList.add( getDesiredVal( mRs.getString("CROSS_UPDATE_EXPR") ) ); //$NON-NLS-1$ [1]
				currFormsDetailList.add( getDesiredVal( mRs.getString("EXPR_FLD_INFO") ) ); //$NON-NLS-1$ [2]
				currFormsDetailList.add( getDesiredVal( mRs.getString("TARGET_FLD_INFO") ) ); //$NON-NLS-1$ [3]
				currFormsDetailList.add( getDesiredVal( mRs.getString("EXPR_COMMENT") ) ); //$NON-NLS-1$ [4]
				currFormsDetailList.add( getDesiredVal( mRs.getString("SCAN_FLAG") ) ); //$NON-NLS-1$ [5]
				currFormsDetailList.add( getDesiredVal( mRs.getString("SCAN_METADATA") ) ); //$NON-NLS-1$ [6]
				currFormsDetailList.add( getDesiredVal( mRs.getString("AUTO_ACCEPT_SCAN") ) ); //$NON-NLS-1$ [7]
				currFormsDetailList.add( getDesiredVal( mRs.getString("PROPERTY_INFO") ) ); //$NON-NLS-1$ [8]
				currFormsDetailList.add( getDesiredVal( mRs.getString("AFTER_SAVE") ) ); //$NON-NLS-1$ [9]
				currFormsDetailList.add( getDesiredVal( mRs.getString("COLUMN_ON_SAVE") ) ); //$NON-NLS-1$ [10]
				currFormsDetailList.add( getDesiredVal( mRs.getString("SCAN_DELIMITER") ) ); //$NON-NLS-1$ [11]
				currFormsDetailList.add( getDesiredVal( mRs.getString("EXT_METADATA") ) ); //$NON-NLS-1$ [12]
				currFormsDetailList.add( getDesiredVal( mRs.getString("AUTO_ACCEPT_WEIGHDATA") ) ); //$NON-NLS-1$ [13]
				currFormsDetailList.add( objContext );// [14]
				currFormsDetailList.add( getDesiredVal( mRs.getString("SCR_FLAG") ) ); //$NON-NLS-1$ [15]
				currFormsDetailList.add( getDesiredVal( mRs.getString("FORM_TYPE") ) ); //$NON-NLS-1$ [16]
				currFormsDetailList.add( getDesiredVal( mRs.getString("DISP_METADATA") ) ); //$NON-NLS-1$ [17]
				currFormsDetailList.add( getDesiredVal( mRs.getString("PARENT_KEY_COL") ) ); //$NON-NLS-1$ [18]
				currFormsDetailList.add( getDesiredVal( mRs.getString("ASSISTED_MODE") )); //$NON-NLS-1$ [19]
				currFormsDetailList.add( getDesiredVal( mRs.getString( "STORAGE_KEY_METADATA" ) ) );// [20]
				currFormsDetailList.add( getDesiredVal( mRs.getString( "SELECTION_MODE" ) ) );// [21]
				currFormsDetailList.add( getDesiredVal( mRs.getString( "DEFAULT_VIEW" ) ) );// [22]
				//Added by gayatri on 22-07-2013 [to auto save feature on multiple field]
				currFormsDetailList.add( getDesiredVal( mRs.getString( "AUTO_ADDON_ENTRY" ) ) );// [23]
				//Added by Ajinkya Gopalkar on 30-11-2015 [Request ID :D15HSUN011 - to freeze column for datagrid]
				currFormsDetailList.add( getDesiredVal( mRs.getString( "FREEZE_COL_POS" ) ) );// [24]
				//Added by Reema on 4-01-2016 [S15JSUN001 - Dynamic row number to be shown in GWT-Wizard screen]
				currFormsDetailList.add( getDesiredVal( mRs.getString( "DEFAULT_ROW_CNT" ) ) );// [25]
				//Added by Prajyot on 4-03-2016 [ Mandatory forms - IS_MANDATORY]
				currFormsDetailList.add( getDesiredVal( mRs.getString( "IS_MANDATORY" ) ) );// [26]
				//Added by Prasad on 02/06/16 [get tran_id_col for all forms]
				currFormsDetailList.add( checkNull( mRs.getString( "TRAN_ID_COL" ) ) );// [27]
				//Changed by Sandeep S. on 28/09/16
				currFormsDetailList.add( checkNull( mRs.getString( "KEY_INFO" ) ) );// [28]
				//Added by sanket on 10/10/16 [ get thumb-image on all forms]
				currFormsDetailList.add( checkNull( mRs.getString( "THUMB_OBJ" ) ) );// [29]
				currFormsDetailList.add( checkNull( mRs.getString( "THUMB_IMAGE_COL" ) ) );// [30]
				currFormsDetailList.add( checkNull( mRs.getString( "THUMB_ALT_COL" ) ) );// [31]
				currFormsDetailList.add( checkNull( mRs.getString( "FORM_NAME" ) ) );// [32]//Gulzar on 11/01/17
				currFormsDetailList.add( checkNull( mRs.getString( "FORM_ICON" ) ) );// [33] //By Ajinkya


				//currFormsDetailList.add( checkNull( mRs.getString( "FORM_VIEW_OPTS" ) ) );// [34] //By Ajinkya
				//Added by shrutika on 24-07-19 [Start] for Implement user Preference for feed view and table view in case of wizard and process screen.
				//Change by shrutika on 29-07-19 [Start] for Implement user Preference FORM_VIEW_OPTS only for wizard and process screen.
				String objType = getDBColumnValue("ITM2MENU", "OBJ_TYPE", "WIN_NAME = '"+winName+"'" , transDB);
				if( (objType.equalsIgnoreCase("W") || objType.equalsIgnoreCase("P")) && !"1".equals(objContext) )
				{
					String colName = "FORM_VIEW_OPTS_"+objContext;
					ObjUserPref userObjPref = objUserPrefDao.getObjectPreference(userInfo, objName, colName);
					if( userObjPref != null )
					{
						String prefValue = E12GenericUtility.checkNull(userObjPref.getPrefValue());
						if( !"".equals(prefValue) )
						{
							currFormsDetailList.add(prefValue);
						}
						else
						{
							currFormsDetailList.add( checkNull( mRs.getString( "FORM_VIEW_OPTS" ) ) );
						}
					}
					else
					{
						currFormsDetailList.add( checkNull( mRs.getString( "FORM_VIEW_OPTS" ) ) );
					}
				}
				else
				{
					currFormsDetailList.add( checkNull( mRs.getString( "FORM_VIEW_OPTS" ) ) );
				}
				//Change by shrutika on 29-07-19 [End] for Implement user Preference FORM_VIEW_OPTS only for wizard and process screen.
				//Added by shrutika on 24-07-19 [End] for Implement user Preference for feed view and table view in case of wizard and process screen.
				//Added by Sandeep S. on 24-NOV-17 [Implementation of Matrix-form detail form] Start
				currFormsDetailList.add( checkNull( mRs.getString( "X_COLUMN" ) ) );// [35] //By Sandeep S
				currFormsDetailList.add( checkNull( mRs.getString( "Y_COLUMN" ) ) );// [36] //By Sandeep S
				//Added by Sandeep S. on 24-NOV-17 [Implementation of Matrix-form detail form] End
				objFormsDetailList.add(currFormsDetailList);
			}//while(mRs.next())
			/*--Commented by Nilesh
			mRs.close();
			mRs = null;
			mStmt.close();
			mStmt = null;
			mConnection.close();
			mConnection = null;
			*/
			if( ! isEntryValid )
			{
				currFormsDetailList = new ArrayList<String>();
				currFormsDetailList.add( objName.toUpperCase() );// [0]
				//Change by gayatri [To add AUTO_ADDON_ENTRY column in currFormsDetailList ]
				//int totLen = 22;// Total length of currFormsDetailList when isEntryValid = true
				//int totLen = 24; //Changes by Prajyot to make same length of selected columns
				//Added by Prajyot on 4-03-2016 [ Mandatory forms - IS_MANDATORY]
				//int totLen = 26; //Changed by Prasad on 02/06/16 [get tran_id_col for all forms]
				//int totLen = 35;
				int totLen = 36;
				for( int i = 0; i < totLen; i++ )
				{
					currFormsDetailList.add(null);
				}

				objFormsDetailList.add(currFormsDetailList);
			}
			//Changes By Prajyot On 23-Sep-2011 [To select ASSISTED_MODE from obj_forms] Ends
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException: DBAccess: getObjFormsDetailList :"); //$NON-NLS-1$
			throw itme;
		}
		catch(SQLException ex)
		{
			System.err.println("Exception: DBAccess: getObjFormsDetailList :\n"+ex); //$NON-NLS-1$
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccess: getObjFormsDetailList :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(mRs!=null)
					{
						mRs.close();
						mRs = null;
					}
					if (mStmt != null)
					{
						mStmt.close();
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getObjFormsDetailList \n" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2", userInfo, null,"Returning objFormsDetailList....."); //$NON-NLS-1$
		return objFormsDetailList;
	}

	//Added By Shahu Mali on 08-10-13.END

	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].START
	public ArrayList getObjProcessDetailList(String objName, UserInfoBean userInfo)throws RemoteException, ITMException
	{
		String winName = "w_" + objName; //$NON-NLS-1$
		String mQuery = null;
		Connection mConnection = null;
		Statement mStmt = null;
		ResultSet mRs = null;
		ArrayList objFormsDetailList = new ArrayList();
		String transDB = null;

		try
		{
			transDB=userInfo.getTransDB();

			mQuery = "SELECT FORM_NO, TITLE, CROSS_UPDATE_EXPR, EXPR_FLD_INFO, TARGET_FLD_INFO, EXPR_COMMENT FROM OBJ_FORMS WHERE WIN_NAME='" + winName + "'" + " AND FORM_NO NOT LIKE '%.%' ORDER BY FORM_NO "; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			ConnDriver mConnDriver = new ConnDriver();

			mConnection = mConnDriver.getConnectDB(transDB);
			mStmt = mConnection.createStatement();
			mRs = mStmt.executeQuery(mQuery);
			boolean isEntryValid = false;
			ArrayList currFormsDetailList = null;
			String objContext = "1"; //$NON-NLS-1$
			while(mRs.next())
			{
				isEntryValid = true;
				currFormsDetailList = new ArrayList();
				objContext = mRs.getString("FORM_NO"); //$NON-NLS-1$
				String title = mRs.getString("TITLE"); //$NON-NLS-1$
				String expr = mRs.getString("CROSS_UPDATE_EXPR"); //$NON-NLS-1$
				String exprVarInfo = mRs.getString("EXPR_FLD_INFO"); //$NON-NLS-1$
				String targetVarInfo = mRs.getString("TARGET_FLD_INFO"); //$NON-NLS-1$
				String exprComment = mRs.getString("EXPR_COMMENT"); //$NON-NLS-1$

				if((title == null) || (title.equalsIgnoreCase("null")) || title.length() == 0) //$NON-NLS-1$
				{
					title = objName.toUpperCase();
				}
				if(expr != null && expr.equalsIgnoreCase("null") && expr.trim().length() == 0) //$NON-NLS-1$
				{
					expr = null;
				}
				if(exprVarInfo != null && exprVarInfo.equalsIgnoreCase("null") && exprVarInfo.trim().length() == 0) //$NON-NLS-1$
				{
					exprVarInfo = null;
				}
				if(targetVarInfo != null && targetVarInfo.equalsIgnoreCase("null") && targetVarInfo.length() == 0) //$NON-NLS-1$
				{
					targetVarInfo = null;
				}
				if(exprComment != null && exprComment.equalsIgnoreCase("null") && exprComment.length() == 0) //$NON-NLS-1$
				{
					exprComment = null;
				}

				currFormsDetailList.add(title);
				currFormsDetailList.add(objContext);//shravan 26/08/2006 adding form_no
				currFormsDetailList.add(expr);
				currFormsDetailList.add(exprVarInfo);
				currFormsDetailList.add(targetVarInfo);
				currFormsDetailList.add(exprComment);



				objFormsDetailList.add(currFormsDetailList);
			}//while(mRs.next())
			mRs.close();
			mRs = null;
			mStmt.close();
			mStmt = null;
			if(!isEntryValid)
			{
				currFormsDetailList = new ArrayList();
				currFormsDetailList.add(objName.toUpperCase());
				currFormsDetailList.add(null);
				currFormsDetailList.add(null);
				currFormsDetailList.add(null);
				currFormsDetailList.add(null);

				objFormsDetailList.add(currFormsDetailList);
			}
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException: DBAccess: getObjProcessDetailList :"); //$NON-NLS-1$
			throw itme;
		}
		catch(SQLException ex)
		{
			System.err.println("Exception: DBAccess: getObjProcessDetailList :\n"+ex); //$NON-NLS-1$
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccess: getObjProcessDetailList :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if (mStmt != null)
					{
						mStmt.close();
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getObjProcessDetailList \n" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2",userInfo, null,"Returning objFormsDetailList....."); //$NON-NLS-1$
		return objFormsDetailList;
	}
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END

	//Added by Chitranga Tandel on 12-march-2018 to get Actions in json format
	public String getAllActionsJson( String objName, String profileID, String userLevel, UserInfoBean userInfo )throws  RemoteException,ITMException, JSONException
	{
		Connection mConnection = null;
		Statement mStmt = null;
		ResultSet mRs = null;

		JSONArray allActJsonArr = new JSONArray();
		JSONObject actionJson = new JSONObject();
		JSONArray actJsonArr = new JSONArray();
		JSONObject allActJsonObj = new JSONObject();
		//$NON-NLS-1$

		String  mQuery = null;
		String  mQuery1 = null;
		String strRights = ""; //$NON-NLS-1$
		String compName = ""; //$NON-NLS-1$
		String compType = ""; //$NON-NLS-1$
		String methodName = ""; //$NON-NLS-1$
		boolean isSysTypeOverwritten = false;
		//Commented and Added by Saiprasad on 02-04-19 to get rights from user_adhic_rights [START]
		PreparedStatement pStmt = null;
		String userAdhocRights = "",userAdhocRightSql = "",userRightType =" ";
		String userID = userInfo.getLoginCode();
		String currSiteCode = userInfo.getSiteCode();
	    String siteCodeLogin = "";
	    Timestamp effFromUserAdhoc = null,validUptoAdhoc = null,currDateTs = null;
	    Date curr= new Date();
	    E12GenericUtility genericUtility = new E12GenericUtility();
	    //Commented and Added by Saiprasad on 02-04-19 to get rights from user_adhic_rights [END]
		try
		{
			ConnDriver mConnDriver = new ConnDriver();



			String transDB = userInfo.getTransDB();
			if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
			{
				mConnection = mConnDriver.getConnectDB(transDB); //$NON-NLS-1$
			}

			if ( ("0").equals( userLevel ) ) //$NON-NLS-1$
			{
				strRights = "*"; //$NON-NLS-1$
			}
			else
			{
				mQuery1 = "SELECT RIGHTS FROM USER_RIGHTS WHERE PROFILE_ID IN " + E12GenericUtility.getFormattedProfileId(profileID) + " AND OBJ_NAME ='"+objName+"'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				mStmt = mConnection.createStatement();
				mRs = mStmt.executeQuery(mQuery1);
				while(mRs.next())
				{
					strRights = strRights + mRs.getString("RIGHTS"); //$NON-NLS-1$
				}
				if(mRs != null)
				{
					mRs.close();
					mRs = null;
				}
				if(mStmt != null)
				{
					mStmt.close();
					mStmt = null;
				}
				System.out.println("DBAccessEJB.getAllActionsJson() 10561");
				//Added by Saiprasad G. for overridding the rights from the user_rights_adhoc table on 15-03-19 START
				SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
				String currDateStr = sdfAppl.format(curr);
				userAdhocRightSql = "SELECT RIGHTS,RIGHTS_TYPE,SITE_CODE__LOGIN, EFF_FROM,VALID_UPTO FROM USER_RIGHTS_ADHOC WHERE OBJ_NAME =? AND USER_ID =?" ;
				pStmt=mConnection.prepareStatement(userAdhocRightSql);
				pStmt.setString(1, objName);
				pStmt.setString(2, userID);
				mRs=pStmt.executeQuery();
				while(mRs.next())
				{
					userRightType = mRs.getString("RIGHTS_TYPE");
					userAdhocRights = mRs.getString("RIGHTS");
					siteCodeLogin=E12GenericUtility.checkNull(mRs.getString("SITE_CODE__LOGIN"));
					effFromUserAdhoc = mRs.getTimestamp("EFF_FROM");
					validUptoAdhoc = mRs.getTimestamp("VALID_UPTO");
				}

				currDateTs = Timestamp.valueOf(genericUtility.getValidDateString(currDateStr,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())+ " 00:00:00.0");

				if(userRightType.equalsIgnoreCase("O"))
				{
					BaseLogger.log("3", null, null,"[DBAccessEJB]UserAdhocRights gets from the override 3 ["+userAdhocRights+"]");
					if((!currDateTs.before(effFromUserAdhoc)) && (!currDateTs.after(validUptoAdhoc)))
					{
						if(currSiteCode.equalsIgnoreCase(siteCodeLogin) || siteCodeLogin.length()==0)
						{
							strRights = userAdhocRights;
							BaseLogger.log("3", null, null,"[DBAccessEJB]RightStr gets from the overridd 3 ["+strRights+"]");
						}
					}
				}
				if(mRs!=null)
				{
					mRs.close();
					mRs = null;
				}
				if(pStmt!=null)
				{
					pStmt.close();
					pStmt = null;
				}
				System.out.println("After :::strRights P "+strRights);
				//Added by Saiprasad G. for overridding the rights from the user_rights_adhoc table on 15-03-19 START

			}
			BaseLogger.log("3",userInfo, null,"Rights String for current Profile["+profileID+"] on current Object["+objName+"] :["+strRights+"]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			if ( strRights != null && strRights.length() > 0)
			{


				if ( ( strRights.indexOf("A") != -1 || strRights.indexOf("E") != -1 ) && strRights.indexOf("S") == -1 ) //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				{
					strRights = strRights+"S"; //$NON-NLS-1$
				}
				//Changed by Pankaj T. on 02-08-18 to display actions in subheader on display_mode basis 0 - In all mode, 1 - In home, 2 - In home & view, 3 - home & Edit, 4 - home & Add/Edit mode & add column show_confirm to configure action on confirm/cancel transaction
				//mQuery = "SELECT FORM_NO, RIGHTS_CHAR, TITLE, INTERACTIVE, SERVICE_CODE, IMAGE, SERVICE_HANDLER, PLACEMENT, ACTION_TYPE, IS_CONFIRMATION_REQ, SHOW_IN_PANEL,SWIPE_POSITION, ACTION_ID, MULTI_ROW_OPT, DEF_NODATA, ACTION_ARG, PAGE_CONTEXT , DISPLAY_MODE, SHOW_CONFIRM FROM OBJ_ACTIONS WHERE OBJ_NAME='"+objName+"' ORDER BY ACTION_TYPE, LINE_NO "; //$NON-NLS-1$ //$NON-NLS-2$
				//Added By Pankaj T. on 03-01-19 added new column line_no for display links on homepage feed order by line_no
				//Added by Pratheek on 24-06-19[ added a new column rec_specific in obj_actions for getting the record specific actions and links]-Start
				//mQuery = "SELECT FORM_NO, RIGHTS_CHAR, TITLE, INTERACTIVE, SERVICE_CODE, IMAGE, SERVICE_HANDLER, PLACEMENT, ACTION_TYPE, IS_CONFIRMATION_REQ, SHOW_IN_PANEL,SWIPE_POSITION, ACTION_ID, MULTI_ROW_OPT, DEF_NODATA, ACTION_ARG, PAGE_CONTEXT , DISPLAY_MODE, SHOW_CONFIRM, LINE_NO FROM OBJ_ACTIONS WHERE OBJ_NAME='"+objName+"' ORDER BY LINE_NO "; //$NON-NLS-1$ //$NON-NLS-2$
				mQuery = "SELECT FORM_NO, RIGHTS_CHAR, TITLE, INTERACTIVE, SERVICE_CODE, IMAGE, SERVICE_HANDLER, PLACEMENT, ACTION_TYPE, IS_CONFIRMATION_REQ, SHOW_IN_PANEL,SWIPE_POSITION, ACTION_ID, MULTI_ROW_OPT, DEF_NODATA, ACTION_ARG, PAGE_CONTEXT , DISPLAY_MODE, SHOW_CONFIRM, REC_SPECIFIC,LINE_NO FROM OBJ_ACTIONS WHERE OBJ_NAME='"+objName+"' ORDER BY LINE_NO "; //$NON-NLS-1$ //$NON-NLS-2$
				mStmt = mConnection.createStatement();
				mRs = mStmt.executeQuery(mQuery);

				while(mRs.next())
				{


					String formNo = mRs.getString("FORM_NO"); //$NON-NLS-1$
					String rightsChar = mRs.getString("RIGHTS_CHAR"); //$NON-NLS-1$
					String title = mRs.getString("TITLE"); //$NON-NLS-1$
					String interactive = mRs.getString("INTERACTIVE"); //$NON-NLS-1$
					String serviceCode = mRs.getString("SERVICE_CODE");  //$NON-NLS-1$
					String image = mRs.getString("IMAGE"); //$NON-NLS-1$
					//D	Possible values	1=forwarding to URL	2=web service call	3=MasterStateful event
					String serviceHandler = mRs.getString("SERVICE_HANDLER"); //$NON-NLS-1$
					//D	Possible values	1=?	2=?	3=?
					String placement = mRs.getString("PLACEMENT"); //$NON-NLS-1$
					String actionType = mRs.getString("ACTION_TYPE"); //$NON-NLS-1$
					//changed by gayatri on 14-01-2013[MF3ISUN010][To add confirmation before action button ]
					String confirmationReq = mRs.getString("IS_CONFIRMATION_REQ");
					String showInPanel = mRs.getString("SHOW_IN_PANEL");		//Changed by Reema on 3-Feb-16 [added show_in_panel column to show action in side panel]
					//Added by Pankaj for swipe position
					String swipePos = mRs.getString("SWIPE_POSITION");
					String actionId = mRs.getString("ACTION_ID");
					//Added by Pankaj for swipe position
					String multiRowOpt = mRs.getString("MULTI_ROW_OPT");  //added by sanket on 24/08/16 [added MULTI_ROW_OPT column and get values]
					//Added by Sanket on 11/10/17 [add def_nodata column]
					String defNoData = mRs.getString("DEF_NODATA");
					//Added by Prasad on 24/11/17 [action argument related implementation]
					String actionArg = mRs.getString("ACTION_ARG");
					//Changed by Pankaj T. on 02-08-18 to display actions in subheader on display_mode basis 0 - In all mode, 1 - In home, 2 - In home & view, 3 - home & Edit, 4 - home & Add/Edit mode & add column show_confirm to configure action on confirm/cancel transaction
					String showConfirm = mRs.getString("SHOW_CONFIRM");
					String displayMode = mRs.getString("DISPLAY_MODE");
					//Added By Pankaj T. on 03-01-19 added new column line_no for display links on homepage feed order by line_no
					String lineNo = mRs.getString("LINE_NO");
					//Added by shrutika on 29-11-17 for Implement getting page context(for copy functionality)
					String pageContext = mRs.getString("PAGE_CONTEXT");
					//Added by Pratheek on 24-06-19[ to get the record specific column value from obj_actions so to add actions and links in more button]-Start
					String recordSpecific = mRs.getString("REC_SPECIFIC");
					BaseLogger.log("3", userInfo, null,"pageConterxt["+pageContext+"]title["+title+"] recordSpecific ["+recordSpecific+"]");
					//Added by Pratheek on 24-06-19[ to get the record specific column value from obj_actions so to add actions and links in more button]-End
					BaseLogger.log("3", userInfo, null, "Action Arg :["+ actionArg +"], Form No :["+ formNo +"]" );
					serviceHandler = (serviceHandler == null || "NULL".equalsIgnoreCase(serviceHandler))?"0":serviceHandler; //$NON-NLS-1$ //$NON-NLS-2$
					placement = (placement == null || "NULL".equalsIgnoreCase(placement))?"0" : placement; //$NON-NLS-1$ //$NON-NLS-2$
					actionId = (actionId == null || "NULL".equalsIgnoreCase(actionId))?rightsChar : actionId; //$NON-NLS-1$ //$NON-NLS-2$
					Statement stmt = null;
					ResultSet rs = null;
					String query = ""; //$NON-NLS-1$
					String argValue = ""; //$NON-NLS-1$
					BaseLogger.log("3",userInfo, null,"Action Title :["+title+"] Form No :["+formNo+"] Rights Char :["+rightsChar+"] Service Code :["+serviceCode+"] Service Handler :["+serviceHandler+"] Action Type :["+actionType+"]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$
					if(serviceHandler != null && (serviceHandler.equals("1") || serviceHandler.equals("2"))) //$NON-NLS-1$ //$NON-NLS-2$
					{
						if(serviceCode != null && serviceCode.length() > 0)
						{
							query = "SELECT A.COMP_TYPE, A.COMP_NAME, B.SERVICE_URI, B.METHOD_NAME FROM SYSTEM_EVENTS A, SYSTEM_EVENT_SERVICES B WHERE A.SERVICE_CODE=B.SERVICE_CODE AND A.OBJ_NAME='" + objName + "' AND A.EVENT_CODE='" + serviceCode + "'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
							stmt = mConnection.createStatement();
							rs = stmt.executeQuery(query);
							while(rs.next())
							{
								compType = rs.getString("COMP_TYPE"); //$NON-NLS-1$
								compName = rs.getString("COMP_NAME"); //$NON-NLS-1$
								serviceCode = rs.getString("SERVICE_URI"); //$NON-NLS-1$
								methodName = rs.getString("METHOD_NAME"); //$NON-NLS-1$
							}
							/*
							rs.close();
							stmt.close();
							*/
							if (rs != null)
							{
								rs.close();
								rs = null;
							}
							if (stmt != null)
							{
								stmt.close();
								stmt = null;
							}

							if(serviceCode != null && serviceCode.length() > 0)
							{
								if(! serviceCode.startsWith("http") ) //$NON-NLS-1$
								{
									if(CommonConstants.TOMCAT_HOME == null || CommonConstants.TOMCAT_HOME.length() == 0)
									{
										CommonConstants.setIBASEHOME();
									}
									if( serviceCode.startsWith("/ibase")) //$NON-NLS-1$
									{
										//Commented By Pankaj T. on 30-09-2020 if server assigned multiple domains in that case issue occurs of session not getting, so remove TOMCAT_HOME
										//serviceCode = CommonConstants.TOMCAT_HOME + serviceCode;
									}
									else if( !(serviceCode.contains(".asmx")) )
									{
										serviceCode = CommonConstants.TOMCAT_HOME + "/ibase/" + CommonConstants.ITM_CONTEXT + "/jsp/" + serviceCode; //$NON-NLS-1$ //$NON-NLS-2$
									}
								}
							}
							else
							{
								throw new Exception("Invalid Service Code :["+serviceCode+"] in SYSTEM_EVENT_SERVICES Cannot be empty"); //$NON-NLS-1$ //$NON-NLS-2$
							}
						}
						else
						{
							throw new Exception("Invalid Service Code :["+serviceCode+"] in OBJ_ACTIONS Cannot be empty"); //$NON-NLS-1$ //$NON-NLS-2$
						}
					}//if(serviceHandler != null && (serviceHandler.equals("1") || serviceHandler.equals("2")))
					else if( serviceHandler != null && serviceHandler.equals("5") ) //$NON-NLS-1$
					{
						if(serviceCode != null && serviceCode.length() > 0)
						{
							query = "SELECT B.ARG_VALUE FROM SYSTEM_EVENTS A, SYSTEM_SERVICE_ARGS B WHERE A.SERVICE_CODE=B.SERVICE_CODE AND A.OBJ_NAME='" + objName + "' AND A.EVENT_CODE='" + serviceCode + "' AND B.ARG_MODE='F'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
							stmt = mConnection.createStatement();
							rs = stmt.executeQuery(query);
							if(rs.next())
							{
								argValue = rs.getString("ARG_VALUE"); //$NON-NLS-1$
							}
							/*
							rs.close();
							stmt.close();
							*/
							if (rs != null)
							{
								rs.close();
								rs = null;
							}
							if (stmt != null)
							{
								stmt.close();
								stmt = null;
							}
						}
						else
						{
							throw new Exception("Invalid Service Code :["+serviceCode+"] in OBJ_ACTIONS Cannot be empty"); //$NON-NLS-1$ //$NON-NLS-2$
						}
					}
					/*
					if(actionType == null || (actionType != null && actionType.length() == 0))
					{
						actionType = "S";
					}
					isSysTypeOverwritten = ("S".equalsIgnoreCase(actionType))?true:isSysTypeOverwritten;*/
					//Changes By Ajinkya Gopalkar on 9-May-16[For creating action in View and Edit mode]
					//Changed done by Gaurav Singh on 23-AUG-2016 [ for resolving Action button issue ]
					//if ( ( strRights.indexOf(rightsChar) != -1 ) || ( strRights.indexOf("*") != -1 || strRights.indexOf("V") != -1 ) || ( strRights.indexOf("E") != -1 ) ) //$NON-NLS-1$
					if ( strRights.indexOf(rightsChar) != -1 || strRights.indexOf("*") != -1 )
					{
						JSONObject actionObj = new JSONObject();
						JSONObject serviceObjCon = new JSONObject();
						JSONObject serviceObj = new JSONObject();

						BaseLogger.log("3",userInfo, null,"going to construcct json of user rights");

						int enabled = -1;
						actionObj.put("formNo", formNo);
						actionObj.put("right_char", rightsChar);
						actionObj.put("enabled", enabled);
						actionObj.put("title", title);
						actionObj.put("interactive", interactive);
						actionObj.put("image", image);
						actionObj.put("action_type", actionType);
						actionObj.put("obj_context", formNo);
						actionObj.put("service_handler", serviceHandler);
						actionObj.put("placement", serviceHandler);
						actionObj.put("confirmation_req", confirmationReq);
						actionObj.put("showInPanel", showInPanel);
						actionObj.put("swipe_position", swipePos);
						actionObj.put("action_id", actionId);
						actionObj.put("multiRowOpt", multiRowOpt);
						actionObj.put("def_NoData", defNoData);
						actionObj.put("action_arg", actionArg);
						//Added By Pankaj T. on 03-01-19 added new column line_no for display links on homepage feed order by line_no - start
						actionObj.put("display_mode", displayMode);
						actionObj.put("show_confirm", showConfirm);
						actionObj.put("line_no", lineNo);
						//Added By Pankaj T. on 03-01-19 added new column line_no for display links on homepage feed order by line_no - end
						//Added by Pratheek on 24-06-19[ added new column rec_specific to get the record specific actions and links ]-Start
						actionObj.put("rec_specific", recordSpecific);
						//Added by Pratheek on 24-06-19[ added new column rec_specific to get the record specific actions and links ]-End
						actJsonArr.put(actionObj);

						BaseLogger.log("3",userInfo, null,"actJsonArr in DBAccess   "+actJsonArr );

                        serviceObjCon.put("cmpType", compType);
                        serviceObjCon.put("cmpName", compName);
                        serviceObjCon.put("metName", methodName);
                        serviceObjCon.put("argVal", argValue);
                        actionObj.put("service_code" , serviceObjCon);

                        BaseLogger.log("3",userInfo, null,"action in DBAccess   "+actionJson );
					}

				}
				actionJson.put("action",actJsonArr);

				if (mRs != null)
				{
					mRs.close();
					mRs = null;
				}
				if (mStmt != null)
				{
					mStmt.close();
					mStmt = null;
				}

				allActJsonObj.put("ACTIONS", actionJson);
				BaseLogger.log("3",userInfo, null,"allActJsonObj in DBAccess   "+allActJsonObj );
				allActJsonArr.put(allActJsonObj);
			}//if ( strRights != null && strRights.lenght() > 0)
			else
			{
				allActJsonArr.put("No rights defined");
				BaseLogger.log("3", userInfo, null,"No rights defined for profileID ["+profileID + "] for OBJ_NAME ["+objName+"]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException: DBAccess: getAllActionsString:"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccess: getAllActionsString:"  + e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(mStmt != null)
					{
						mStmt.close();
						mStmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getAllActionsString \n" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2", userInfo, null,"Actions String============================\n"+allActJsonArr.toString()+"\n"); //$NON-NLS-1$ //$NON-NLS-2$
		return allActJsonArr.toString();
	}

	//ended by Chitranga Tandel on 12-march-2018 to get Actions in json format

	//Added By Shahu Mali on 08-10-13.[WS3GBAS001].START
	public HashMap getObjViewDetailMap( String objName, String formNo, UserInfoBean userInfo ) throws RemoteException, ITMException
	{
		HashMap objDetailMap = null;
		Connection mConnection = null;
		PreparedStatement pStmt = null;
		ResultSet mRs=null;
		String sqlQuery = null;
		int iResult=0;
		String objInfo = null;
		String transDB =null;
		try
		{

			BaseLogger.log("3", userInfo, null,"getObjViewDetailMap ..with userInfo"+userInfo.toString());
			transDB=userInfo.getTransDB();
			ConnDriver mConnDriver = new ConnDriver();

			mConnection = mConnDriver.getConnectDB(transDB);
			objName = ( objName.startsWith( "w_" ) ) ? objName : "w_" + objName; //$NON-NLS-1$ //$NON-NLS-2$
			sqlQuery = "SELECT KEY_FLAG ,CONFIRM_COL,CONFIRM_VAL,EDIT_TMPLT,EDIT_OPT FROM TRANSETUP WHERE TRAN_WINDOW=?"; //$NON-NLS-1$
			pStmt = mConnection.prepareStatement(sqlQuery);
			pStmt.setString(1,objName);
			mRs = pStmt.executeQuery();
			objDetailMap = new HashMap();
			while( mRs.next() )
			{
				objDetailMap.put( "KEY_FLAG", mRs.getString( "KEY_FLAG" ) ); //$NON-NLS-1$ //$NON-NLS-2$
				objDetailMap.put( "CONFIRM_COL", mRs.getString("CONFIRM_COL")); //$NON-NLS-1$ //$NON-NLS-2$
				objDetailMap.put( "CONFIRM_VAL", mRs.getString( "CONFIRM_VAL")); //$NON-NLS-1$ //$NON-NLS-2$
				objDetailMap.put( "EDIT_TMPLT", mRs.getString("EDIT_TMPLT")); //$NON-NLS-1$ //$NON-NLS-2$
				objDetailMap.put( "EDIT_OPT", mRs.getString("EDIT_OPT")); //$NON-NLS-1$ //$NON-NLS-2$
			}
			mRs.close();
			mRs = null;
			if( pStmt != null )
			{
				pStmt.close();
				pStmt = null;
			}
			//Changed by Santosh on 15-01-2018 to get Selection opt value
			//sqlQuery = "SELECT SCR_FLAG FROM OBJ_FORMS WHERE WIN_NAME = ? AND FORM_NO = ?"; //$NON-NLS-1$
			sqlQuery = "SELECT SCR_FLAG, SELECTION_OPT FROM OBJ_FORMS WHERE WIN_NAME = ? AND FORM_NO = ?";
			pStmt = mConnection.prepareStatement(sqlQuery);
			pStmt.setString(1,objName);
			pStmt.setString(2,formNo);
			mRs = pStmt.executeQuery();
			while( mRs.next() )
			{
				objDetailMap.put( "SCR_FLAG", mRs.getString( "SCR_FLAG" ) ); //$NON-NLS-1$ //$NON-NLS-2$
				//Added by Santosh on 15-01-2018 to get Selection opt value
				objDetailMap.put( "SELECTION_OPT", mRs.getString( "SELECTION_OPT" ) );
			}
			mRs.close();
			mRs = null;
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException :DBAccessEJB :getObjInfo :\n"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception :DBAccessEJB :getObjInfo :\n"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(pStmt != null)
					{
						pStmt.close();
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getObjInfo :==>F" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2", userInfo, null,"Returning objDetailMap :"+objDetailMap); //$NON-NLS-1$
		return objDetailMap;
	}
	//Added By Shahu Mali on  08-10-13.[WS3GBAS001].END

	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].START
	public boolean isSignDefined(String refSer, UserInfoBean userInfo)throws  RemoteException,ITMException
	{
		boolean isSignDefined = false;
		Connection mConnection = null;
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String transDB = null;
		try
		{

			transDB=userInfo.getTransDB();

			ConnDriver mConnDriver = new ConnDriver();

			mConnection = mConnDriver.getConnectDB(transDB);
			String qry = "SELECT COUNT(1) FROM OBJ_SIGN WHERE REF_SER = ?"; //$NON-NLS-1$
			pStmt = mConnection.prepareStatement(qry);
			pStmt.setString(1, refSer.trim());
			rs = pStmt.executeQuery();
			while(rs.next())
			{
				if(rs.getInt(1) > 0)
				{
					isSignDefined = true;
				}
			}
			rs.close();
			rs = null;
			pStmt.close();
			pStmt = null;
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException: DBAccess: isSignDefined :"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccess: isSignDefined :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if (pStmt != null)
					{
						pStmt.close();
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: isSignDefined \n" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		return isSignDefined;
	}
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END

	//Changes made by Gulzar on 23/10/13[WS3GBAS001] : created overloaded method and passed userInfor String parameter : START
	public String getActionsString(String objName, String editFlag, String objContext, String profileId, String userlevel, UserInfoBean userInfo)throws  RemoteException,ITMException
	{
		//BaseLogger.log("3", null, null,"Getting Action String for objName :["+objName+"] objContext :["+objContext+"] editFlag :["+editFlag+"] profileId :["+profileId+"]");
		String actionStr = ""; //$NON-NLS-1$
		try
		{
			String cacheActionStr = objName + "~~"+ profileId + "~~" + userlevel;
			String allActStr = "";
			//Added Pankaj T on 18-10-17 [for CACHE_OPT define in ibase.xml 0 = NO Cache, 1 = Internal Cache, 2 = External Cache]
			//Changed by Prasad on 23/11/2020 [check infinispanLocalObj not null]
			if( CommonConstants.CACHE_OPT != 0 && infinispanLocalObj != null )
			{
				if( infinispanLocalObj.contains(cacheActionStr))
				{
					allActStr = infinispanLocalObj.getFormData(cacheActionStr);
				}
				else
				{
					allActStr = getAllActionsString(objName, profileId, userlevel, userInfo);
					infinispanLocalObj.putFormData(cacheActionStr, allActStr);
				}
			}
			else
			{
				allActStr = getAllActionsString(objName, profileId, userlevel, userInfo);
			}
			/*
			Document actionDom = GenericUtility.getInstance().parseString(allActStr);
			NodeList actnNodeChildList = actionDom.getElementsByTagName("action");
			for (int i = 0; i < actnNodeChildSize; i++)
			{
				Node currNode =	actnNodeChildList.item(i);
			}
			 */
			actionStr = allActStr;
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException: DBAccess: getActionsString:"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccess: getActionsString:"  + e); //$NON-NLS-1$
			throw new ITMException(e);
		}
//		BaseLogger.log("3", null, null,"Returning Action Str :["+actionStr+"]"); //$NON-NLS-1$ //$NON-NLS-2$
		return actionStr;
	}
	//Changes made by Gulzar on 23/10/13[WS3GBAS001] : created overloaded method and passed userInfo String parameter : END

	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].START
	public String getAllActionsString( String objName, String profileID, String userLevel, UserInfoBean userInfo )throws  RemoteException,ITMException
	{
		Connection mConnection = null;
		Statement mStmt = null;
		ResultSet mRs = null;
		StringBuffer allActStrBuff = new StringBuffer("<ACTIONS>"); //$NON-NLS-1$
		String  mQuery = null;
		String  mQuery1 = null;
		String strRights = ""; //$NON-NLS-1$
		String compName = ""; //$NON-NLS-1$
		String compType = ""; //$NON-NLS-1$
		String methodName = ""; //$NON-NLS-1$
		boolean isSysTypeOverwritten = false;
		//Commented and Added by Saiprasad on 02-04-19 to get rights from user_adhic_rights [START]
		PreparedStatement pStmt = null;
		String userAdhocRights = "",userAdhocRightSql = "",userRightType =" ";
		String userID = userInfo.getLoginCode();
		String currSiteCode = userInfo.getSiteCode();
	    String siteCodeLogin = "";
	    Timestamp effFromUserAdhoc = null,validUptoAdhoc = null,currDateTs = null;
	    //Added by saiprasad G.
	    Date curr= new Date();
	    E12GenericUtility genericUtility = new E12GenericUtility();
	    //Commented and Added by Saiprasad on 02-04-19 to get rights from user_adhic_rights [END]
		try
		{
			ConnDriver mConnDriver = new ConnDriver();

			String transDB = userInfo.getTransDB();
			if(transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
			{
				mConnection = mConnDriver.getConnectDB(transDB); //$NON-NLS-1$
			}

			if ( ("0").equals( userLevel ) ) //$NON-NLS-1$
			{
				strRights = "*"; //$NON-NLS-1$
			}
			else
			{
				//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
				//mQuery1 = "SELECT RIGHTS FROM USER_RIGHTS WHERE PROFILE_ID ='" + profileID + "'" + " AND OBJ_NAME ='"+objName+"'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				mQuery1 = "SELECT RIGHTS FROM USER_RIGHTS WHERE PROFILE_ID IN " + E12GenericUtility.getFormattedProfileId(profileID) + " AND OBJ_NAME ='"+objName+"'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				mStmt = mConnection.createStatement();
				mRs = mStmt.executeQuery(mQuery1);
				while(mRs.next())
				{
					strRights = strRights + mRs.getString("RIGHTS"); //$NON-NLS-1$
				}
				if(mRs != null)
				{
					mRs.close();
					mRs = null;
				}
				if(mStmt != null)
				{
					mStmt.close();
					mStmt = null;
				}
				System.out.println("DBAccessEJB.getAllActionsString() 11149");
				//Added by Saiprasad G. for overridding the rights from the user_rights_adhoc table on 15-03-19 START
				SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
				String currDateStr = sdfAppl.format(curr);

				userAdhocRightSql = "SELECT RIGHTS,RIGHTS_TYPE,SITE_CODE__LOGIN, EFF_FROM,VALID_UPTO FROM USER_RIGHTS_ADHOC WHERE OBJ_NAME =? AND USER_ID =?" ;
				pStmt=mConnection.prepareStatement(userAdhocRightSql);
				pStmt.setString(1, objName);
				pStmt.setString(2, userID);
				mRs=pStmt.executeQuery();
				while(mRs.next())
				{
					userRightType = mRs.getString("RIGHTS_TYPE");
					userAdhocRights = mRs.getString("RIGHTS");
					siteCodeLogin=E12GenericUtility.checkNull(mRs.getString("SITE_CODE__LOGIN"));
					effFromUserAdhoc = mRs.getTimestamp("EFF_FROM");
					validUptoAdhoc = mRs.getTimestamp("VALID_UPTO");
				}
				if(mRs!=null)
				{
					mRs.close();
					mRs = null;
				}
				if(pStmt!=null)
				{
					pStmt.close();
					pStmt = null;
				}
				currDateTs = Timestamp.valueOf(genericUtility.getValidDateString(currDateStr,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())+ " 00:00:00.0");

				if(userRightType.equalsIgnoreCase("O"))
				{
					BaseLogger.log("3", null, null,"[DBAccessEJB]UserAdhocRights gets from the override 4 ["+userAdhocRights+"]");
					if((!currDateTs.before(effFromUserAdhoc)) && (!currDateTs.after(validUptoAdhoc)))
					{
						if(currSiteCode.equalsIgnoreCase(siteCodeLogin) || siteCodeLogin.length()==0)
						{
							strRights = userAdhocRights;
							BaseLogger.log("3", null, null,"[DBAccessEJB]RightStr gets from the overridd 4 ["+strRights+"]");
						}
					}
				}

				System.out.println("After :::strRights P "+strRights);
				//Added by Saiprasad G. for overridding the rights from the user_rights_adhoc table on 15-03-19 START
			}
			BaseLogger.log("3", userInfo, null,"Rights String for current Profile["+profileID+"] on current Object["+objName+"] :["+strRights+"]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			//Danish Friday, May 05, 2006 Adding if "A" / "E" exisits but "S" does not Exisits
			if ( strRights != null && strRights.length() > 0)
			{
				if ( ( strRights.indexOf("A") != -1 || strRights.indexOf("E") != -1 ) && strRights.indexOf("S") == -1 ) //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				{
					strRights = strRights+"S"; //$NON-NLS-1$
				}

				//changed by gayatri on 14-01-2013[MF3ISUN010][To add confirmation before action button ]
				//mQuery = "SELECT FORM_NO, RIGHTS_CHAR, TITLE, INTERACTIVE, SERVICE_CODE, IMAGE, SERVICE_HANDLER, PLACEMENT, ACTION_TYPE FROM OBJ_ACTIONS WHERE OBJ_NAME='"+objName+"' ORDER BY ACTION_TYPE, LINE_NO "; //$NON-NLS-1$ //$NON-NLS-2$
				//Changed by Reema on 3-Feb-16 [added show_in_panel column to show action in side panel]
				//mQuery = "SELECT FORM_NO, RIGHTS_CHAR, TITLE, INTERACTIVE, SERVICE_CODE, IMAGE, SERVICE_HANDLER, PLACEMENT, ACTION_TYPE, IS_CONFIRMATION_REQ FROM OBJ_ACTIONS WHERE OBJ_NAME='"+objName+"' ORDER BY ACTION_TYPE, LINE_NO "; //$NON-NLS-1$ //$NON-NLS-2$
				//Changes Done By sanket J on 11-09-17 [for def_nodata column]
				//mQuery = "SELECT FORM_NO, RIGHTS_CHAR, TITLE, INTERACTIVE, SERVICE_CODE, IMAGE, SERVICE_HANDLER, PLACEMENT, ACTION_TYPE, IS_CONFIRMATION_REQ, SHOW_IN_PANEL,SWIPE_POSITION, ACTION_ID, MULTI_ROW_OPT FROM OBJ_ACTIONS WHERE OBJ_NAME='"+objName+"' ORDER BY ACTION_TYPE, LINE_NO "; //$NON-NLS-1$ //$NON-NLS-2$
				//mQuery = "SELECT FORM_NO, RIGHTS_CHAR, TITLE, INTERACTIVE, SERVICE_CODE, IMAGE, SERVICE_HANDLER, PLACEMENT, ACTION_TYPE, IS_CONFIRMATION_REQ, SHOW_IN_PANEL,SWIPE_POSITION, ACTION_ID, MULTI_ROW_OPT, DEF_NODATA, ACTION_ARG FROM OBJ_ACTIONS WHERE OBJ_NAME='"+objName+"' ORDER BY ACTION_TYPE, LINE_NO "; //$NON-NLS-1$ //$NON-NLS-2$
				//Change by shrutika on 29-11-17 for Implement getting page context(for copy functionality)
				//Changed by Pankaj T. on 02-08-18 to display actions in subheader on display_mode basis 0 - In all mode, 1 - In home, 2 - In home & view, 3 - home & Edit, 4 - home & Add/Edit mode & add column show_confirm to configure action on confirm/cancel transaction
				//mQuery = "SELECT FORM_NO, RIGHTS_CHAR, TITLE, INTERACTIVE, SERVICE_CODE, IMAGE, SERVICE_HANDLER, PLACEMENT, ACTION_TYPE, IS_CONFIRMATION_REQ, SHOW_IN_PANEL,SWIPE_POSITION, ACTION_ID, MULTI_ROW_OPT, DEF_NODATA, ACTION_ARG, PAGE_CONTEXT, DISPLAY_MODE, SHOW_CONFIRM FROM OBJ_ACTIONS WHERE OBJ_NAME='"+objName+"' ORDER BY ACTION_TYPE, LINE_NO "; //$NON-NLS-1$ //$NON-NLS-2$
				//Added By Pankaj T. on 03-01-19 added new column line_no for display links on homepage feed order by line_no
				//Added by Pratheek on 24-06-19[ added a new column rec_specific in obj_actions for getting the record specific actions and links]-Start
				//mQuery = "SELECT FORM_NO, RIGHTS_CHAR, TITLE, INTERACTIVE, SERVICE_CODE, IMAGE, SERVICE_HANDLER, PLACEMENT, ACTION_TYPE, IS_CONFIRMATION_REQ, SHOW_IN_PANEL,SWIPE_POSITION, ACTION_ID, MULTI_ROW_OPT, DEF_NODATA, ACTION_ARG, PAGE_CONTEXT, DISPLAY_MODE, SHOW_CONFIRM, LINE_NO FROM OBJ_ACTIONS WHERE OBJ_NAME='"+objName+"' ORDER BY LINE_NO "; //$NON-NLS-1$ //$NON-NLS-2$
				mQuery = "SELECT FORM_NO, RIGHTS_CHAR, TITLE, INTERACTIVE, SERVICE_CODE, IMAGE, SERVICE_HANDLER, PLACEMENT, ACTION_TYPE, IS_CONFIRMATION_REQ, SHOW_IN_PANEL,SWIPE_POSITION, ACTION_ID, MULTI_ROW_OPT, DEF_NODATA, ACTION_ARG, PAGE_CONTEXT, DISPLAY_MODE, SHOW_CONFIRM, LINE_NO, REC_SPECIFIC FROM OBJ_ACTIONS WHERE OBJ_NAME='"+objName+"' ORDER BY LINE_NO "; //$NON-NLS-1$ //$NON-NLS-2$
				mStmt = mConnection.createStatement();
				mRs = mStmt.executeQuery(mQuery);

				while(mRs.next())
				{
					String formNo = mRs.getString("FORM_NO"); //$NON-NLS-1$
					String rightsChar = mRs.getString("RIGHTS_CHAR"); //$NON-NLS-1$
					String title = mRs.getString("TITLE"); //$NON-NLS-1$
					String interactive = mRs.getString("INTERACTIVE"); //$NON-NLS-1$
					String serviceCode = mRs.getString("SERVICE_CODE");  //$NON-NLS-1$
					String image = mRs.getString("IMAGE"); //$NON-NLS-1$
					//D	Possible values	1=forwarding to URL	2=web service call	3=MasterStateful event
					String serviceHandler = mRs.getString("SERVICE_HANDLER"); //$NON-NLS-1$
					//D	Possible values	1=?	2=?	3=?
					String placement = mRs.getString("PLACEMENT"); //$NON-NLS-1$
					String actionType = mRs.getString("ACTION_TYPE"); //$NON-NLS-1$
					//changed by gayatri on 14-01-2013[MF3ISUN010][To add confirmation before action button ]
					String confirmationReq = mRs.getString("IS_CONFIRMATION_REQ");
					String showInPanel = mRs.getString("SHOW_IN_PANEL");		//Changed by Reema on 3-Feb-16 [added show_in_panel column to show action in side panel]
					//Added by Pankaj for swipe position
					String swipePos = mRs.getString("SWIPE_POSITION");
					String actionId = mRs.getString("ACTION_ID");
					//Added by Pankaj for swipe position
					String multiRowOpt = mRs.getString("MULTI_ROW_OPT");  //added by sanket on 24/08/16 [added MULTI_ROW_OPT column and get values]
					//Added by Sanket on 11/10/17 [add def_nodata column]
					String defNoData = mRs.getString("DEF_NODATA");
					//Added by Prasad on 24/11/17 [action argument related implementation]
					String actionArg = mRs.getString("ACTION_ARG");
					//Changed by Pankaj T. on 02-08-18 to display actions in subheader on display_mode basis 0 - In all mode, 1 - In home, 2 - In home & view, 3 - home & Edit, 4 - home & Add/Edit mode & add column show_confirm to configure action on confirm/cancel transaction
					String showConfirm = mRs.getString("SHOW_CONFIRM");
					String displayMode = mRs.getString("DISPLAY_MODE");
					//Added By Pankaj T. on 03-01-19 added new column line_no for display links on homepage feed order by line_no
					String lineNo = mRs.getString("LINE_NO");
					//Added by shrutika on 29-11-17 for Implement getting page context(for copy functionality)
					String pageContext = mRs.getString("PAGE_CONTEXT");
					//Added by Pratheek on 24-06-19[ to get the record specific column value from obj_actions so to add actions and links in more button]-Start
					String recordSpecific = mRs.getString("REC_SPECIFIC");
					BaseLogger.log("3",userInfo, null,"pageConterxt 11270!!!!!!["+pageContext+"]title["+title+"] actionSpecific ["+recordSpecific+"]");
					//Added by Pratheek on 24-06-19[ to get the record specific column value from obj_actions so to add actions and links in more button]-End
					BaseLogger.log("3",userInfo, null, "Action Arg :["+ actionArg +"], Form No :["+ formNo +"]" );
					serviceHandler = (serviceHandler == null || "NULL".equalsIgnoreCase(serviceHandler))?"0":serviceHandler; //$NON-NLS-1$ //$NON-NLS-2$
					placement = (placement == null || "NULL".equalsIgnoreCase(placement))?"0" : placement; //$NON-NLS-1$ //$NON-NLS-2$
					actionId = (actionId == null || "NULL".equalsIgnoreCase(actionId))?rightsChar : actionId; //$NON-NLS-1$ //$NON-NLS-2$
					Statement stmt = null;
					ResultSet rs = null;
					String query = ""; //$NON-NLS-1$
					String argValue = ""; //$NON-NLS-1$
					BaseLogger.log("3", userInfo, null,"Action Title :["+title+"] Form No :["+formNo+"] Rights Char :["+rightsChar+"] Service Code :["+serviceCode+"] Service Handler :["+serviceHandler+"] Action Type :["+actionType+"]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$
					if(serviceHandler != null && (serviceHandler.equals("1") || serviceHandler.equals("2"))) //$NON-NLS-1$ //$NON-NLS-2$
					{
						if(serviceCode != null && serviceCode.length() > 0)
						{
							query = "SELECT A.COMP_TYPE, A.COMP_NAME, B.SERVICE_URI, B.METHOD_NAME FROM SYSTEM_EVENTS A, SYSTEM_EVENT_SERVICES B WHERE A.SERVICE_CODE=B.SERVICE_CODE AND A.OBJ_NAME='" + objName + "' AND A.EVENT_CODE='" + serviceCode + "'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
							stmt = mConnection.createStatement();
							rs = stmt.executeQuery(query);
							while(rs.next())
							{
								compType = rs.getString("COMP_TYPE"); //$NON-NLS-1$
								compName = rs.getString("COMP_NAME"); //$NON-NLS-1$
								serviceCode = rs.getString("SERVICE_URI"); //$NON-NLS-1$
								methodName = rs.getString("METHOD_NAME"); //$NON-NLS-1$
							}
							/*
							rs.close();
							stmt.close();
							*/
							if (rs != null)
							{
								rs.close();
								rs = null;
							}
							if (stmt != null)
							{
								stmt.close();
								stmt = null;
							}

							if(serviceCode != null && serviceCode.length() > 0)
							{
								if(! serviceCode.startsWith("http") ) //$NON-NLS-1$
								{
									if(CommonConstants.TOMCAT_HOME == null || CommonConstants.TOMCAT_HOME.length() == 0)
									{
										CommonConstants.setIBASEHOME();
									}
									// Changed By Danish sir  on 16-11-2011 [to check whether url starts with "/ibase"]start
									if( serviceCode.startsWith("/ibase")) //$NON-NLS-1$
									{
										//Commented By Pankaj T. on 30-09-2020 if server assigned multiple domains in that case issue occurs of session not getting, so remove TOMCAT_HOME
										//serviceCode = CommonConstants.TOMCAT_HOME + serviceCode;
									}
									else if( !(serviceCode.contains(".asmx")) )
									{
										serviceCode = CommonConstants.TOMCAT_HOME + "/ibase/" + CommonConstants.ITM_CONTEXT + "/jsp/" + serviceCode; //$NON-NLS-1$ //$NON-NLS-2$
									}
									// Changed By Danish sir  on 16-11-2011 [to check whether url starts with "/ibase"]end
								}
							}
							else
							{
								throw new Exception("Invalid Service Code :["+serviceCode+"] in SYSTEM_EVENT_SERVICES Cannot be empty"); //$NON-NLS-1$ //$NON-NLS-2$
							}
						}
						else
						{
							throw new Exception("Invalid Service Code :["+serviceCode+"] in OBJ_ACTIONS Cannot be empty"); //$NON-NLS-1$ //$NON-NLS-2$
						}
					}//if(serviceHandler != null && (serviceHandler.equals("1") || serviceHandler.equals("2")))
					else if( serviceHandler != null && serviceHandler.equals("5") ) //$NON-NLS-1$
					{
						if(serviceCode != null && serviceCode.length() > 0)
						{
							query = "SELECT B.ARG_VALUE FROM SYSTEM_EVENTS A, SYSTEM_SERVICE_ARGS B WHERE A.SERVICE_CODE=B.SERVICE_CODE AND A.OBJ_NAME='" + objName + "' AND A.EVENT_CODE='" + serviceCode + "' AND B.ARG_MODE='F'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
							stmt = mConnection.createStatement();
							rs = stmt.executeQuery(query);
							if(rs.next())
							{
								argValue = rs.getString("ARG_VALUE"); //$NON-NLS-1$
							}
							/*
							rs.close();
							stmt.close();
							*/
							if (rs != null)
							{
								rs.close();
								rs = null;
							}
							if (stmt != null)
							{
								stmt.close();
								stmt = null;
							}
						}
						else
						{
							throw new Exception("Invalid Service Code :["+serviceCode+"] in OBJ_ACTIONS Cannot be empty"); //$NON-NLS-1$ //$NON-NLS-2$
						}
					}
					/*
					if(actionType == null || (actionType != null && actionType.length() == 0))
					{
						actionType = "S";
					}
					isSysTypeOverwritten = ("S".equalsIgnoreCase(actionType))?true:isSysTypeOverwritten;*/
					//Changes By Ajinkya Gopalkar on 9-May-16[For creating action in View and Edit mode]
					//Changed done by Gaurav Singh on 23-AUG-2016 [ for resolving Action button issue ]
					//if ( ( strRights.indexOf(rightsChar) != -1 ) || ( strRights.indexOf("*") != -1 || strRights.indexOf("V") != -1 ) || ( strRights.indexOf("E") != -1 ) ) //$NON-NLS-1$
					if ( strRights.indexOf(rightsChar) != -1 || strRights.indexOf("*") != -1 )
					{
						//changed by gayatri on 14-01-2013[MF3ISUN010][To add confirmation before action button ]
						//allActStrBuff.append("\n<action id='"+rightsChar+"' enabled='-1' title ='"+title+"' interactive='"+interactive+"' image='"+image+"' action_type='"+actionType+"' obj_context='"+( (actionType.equalsIgnoreCase( "S" ) ) ? "1" : formNo )+"' service_handler='"+serviceHandler+"' placement='"+placement+"'>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$ //$NON-NLS-11$
						//Changed by Reema on 3-Feb-16 [added show_in_panel column to show action in side panel]
						//allActStrBuff.append("\n<action id='"+rightsChar+"' enabled='-1' title ='"+title+"' interactive='"+interactive+"' image='"+image+"' action_type='"+actionType+"' obj_context='"+( (actionType.equalsIgnoreCase( "S" ) ) ? "1" : formNo )+"' service_handler='"+serviceHandler+"' placement='"+placement+"' confirmation_req='"+confirmationReq+"'>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$ //$NON-NLS-11$
						//Changed By Suraj on 14-July-2016 [To add formNO from obj_actions table ]
						//Changed by parikshit on 29/12/16 [to set form number] start
						//allActStrBuff.append("\n<action formNo='"+formNo+"' id='"+rightsChar+"' enabled='-1' title ='"+title+"' interactive='"+interactive+"' image='"+image+"' action_type='"+actionType+"' obj_context='"+( (actionType.equalsIgnoreCase( "S" ) ) ? "1" : formNo )+"' service_handler='"+serviceHandler+"' placement='"+placement+"' confirmation_req='"+confirmationReq+"' showInPanel= '"+showInPanel+"' swipe_position='"+swipePos+"' action_id='"+actionId+"' multiRowOpt= '"+multiRowOpt+"'>");  //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$ //$NON-NLS-11$//$NON-NLS-12$ //$NON-NLS-13$
						//Changed By sanket J on 11/09/17 [for def_nodata]
						//allActStrBuff.append("\n<action formNo='"+formNo+"' id='"+rightsChar+"' enabled='-1' title ='"+title+"' interactive='"+interactive+"' image='"+image+"' action_type='"+actionType+"' obj_context='"+ formNo +"' service_handler='"+serviceHandler+"' placement='"+placement+"' confirmation_req='"+confirmationReq+"' showInPanel= '"+showInPanel+"' swipe_position='"+swipePos+"' action_id='"+actionId+"' multiRowOpt= '"+multiRowOpt+"'>");  //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$ //$NON-NLS-11$//$NON-NLS-12$ //$NON-NLS-13$
						//Added by Prasad on 24/11/17 [action argument related implementation]
						//allActStrBuff.append("\n<action formNo='"+formNo+"' id='"+rightsChar+"' enabled='-1' title ='"+title+"' interactive='"+interactive+"' image='"+image+"' action_type='"+actionType+"' obj_context='"+ formNo +"' service_handler='"+serviceHandler+"' placement='"+placement+"' confirmation_req='"+confirmationReq+"' showInPanel= '"+showInPanel+"' swipe_position='"+swipePos+"' action_id='"+actionId+"' multiRowOpt= '"+multiRowOpt+"' def_NoData= '"+ defNoData +"' action_arg= '"+ actionArg +"'>");  //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$ //$NON-NLS-11$//$NON-NLS-12$ //$NON-NLS-13$
						//Change by shrutika on 29-11-17 for Implement getting page context(for copy functionality)
						//Changed by Pankaj T. on 02-08-18 to display actions in subheader on display_mode basis 0 - In all mode, 1 - In home, 2 - In home & view, 3 - home & Edit, 4 - home & Add/Edit mode & add column show_confirm to configure action on confirm/cancel transaction
						//Added By Pankaj T. on 03-01-19 added new column line_no for display links on homepage feed order by line_no
						//Added by Pratheek on 24-06-19[ added new column rec_specific to get the record specific actions and links ]-Start
						allActStrBuff.append("\n<action formNo='"+formNo+"' id='"+rightsChar+"' enabled='-1' title ='"+title+"' interactive='"+interactive+"' image='"+image+"' action_type='"+actionType+"' obj_context='"+ formNo +"' service_handler='"+serviceHandler+"' placement='"+placement+"' confirmation_req='"+confirmationReq+"' showInPanel= '"+showInPanel+"' swipe_position='"+swipePos+"' action_id='"+actionId+"' multiRowOpt= '"+multiRowOpt+"' def_NoData= '"+ defNoData +"' action_arg= '"+ actionArg + "' page_context= '"+ pageContext +"' display_mode= '"+ displayMode + "' show_confirm= '"+ showConfirm + "' rec_specific= '" +recordSpecific+"' line_no = '"+ lineNo + "'>");

						//Changed by parikshit on 29/12/16 [to set form number] end
						allActStrBuff.append("<service_code cmpType='"+compType+"' cmpName='"+compName+"' metName='"+methodName+"' argVal='"+argValue+"'><![CDATA["+serviceCode+"]]></service_code>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
						allActStrBuff.append("</action>"); //$NON-NLS-1$
					}
				}//while(mRs.next())
				/*
				mRs.close();
				mStmt.close();
				mStmt = null;
				*/
				if (mRs != null)
				{
					mRs.close();
					mRs = null;
				}
				if (mStmt != null)
				{
					mStmt.close();
					mStmt = null;
				}

				/*if( ! isSysTypeOverwritten)
				{
					strRights = (strRights == null) ? "" : strRights;
					if(strRights.indexOf("*") != -1 || strRights.indexOf("A") != -1)
					{
						allActStrBuff.append("\n<action id='A' enabled='-1' title ='Add' interactive='Y' image='a' action_type='S' obj_context='1' service_handler='0' placement='0'>");
						allActStrBuff.append("<service_code>NA</service_code>");
						allActStrBuff.append("</action>");
					}
					else if(strRights.indexOf("*") != -1 || strRights.indexOf("E") != -1)
					{
						allActStrBuff.append("\n<action id='E' enabled='-1' title ='Edit' interactive='Y' image='e' action_type='S' obj_context='1' service_handler='0' placement='0'>");
						allActStrBuff.append("<service_code>NA</service_code>");
						allActStrBuff.append("</action>");
					}
					else if(strRights.indexOf("*") != -1 || strRights.indexOf("D") != -1)
					{
						allActStrBuff.append("\n<action id='D' enabled='-1' title ='Delete' interactive='Y' image='d' action_type='S' obj_context='1' service_handler='0' placement='0'>");
						allActStrBuff.append("<service_code>NA</service_code>");
						allActStrBuff.append("</action>");
					}
					else if(strRights.indexOf("*") != -1 || strRights.indexOf("S") != -1)
					{
						allActStrBuff.append("\n<action id='S' enabled='-1' title ='Save' interactive='Y' image='s' action_type='S' obj_context='1' service_handler='0' placement='0'>");
						allActStrBuff.append("<service_code>NA</service_code>");
						allActStrBuff.append("</action>");
					}
				}*/
				allActStrBuff.append("\n</ACTIONS>"); //$NON-NLS-1$
			}//if ( strRights != null && strRights.lenght() > 0)
			else
			{
				allActStrBuff.append("\n</ACTIONS>"); //$NON-NLS-1$
				BaseLogger.log("3", userInfo, null,"No rights defined for profileID ["+profileID + "] for OBJ_NAME ["+objName+"]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException: DBAccess: getAllActionsString:"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccess: getAllActionsString:"  + e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(mStmt != null)
					{
						mStmt.close();
						mStmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getAllActionsString \n" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2", userInfo, null,"Actions String============================\n"+allActStrBuff.toString()+"\n"); //$NON-NLS-1$ //$NON-NLS-2$
		return allActStrBuff.toString();
	}
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END

	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].START
	public String getAllClientActionsString( String objName, UserInfoBean userInfo )throws  RemoteException,ITMException
	{
		BaseLogger.log("2", userInfo, null,"getAllClientActionsString : Called for objName ["+objName+"] "); //$NON-NLS-1$ //$NON-NLS-2$
		Connection conn = null;
		StringBuffer allActExtndStrBuff = new StringBuffer("<CLIENT_ACTIONS>"); //$NON-NLS-1$
		Statement stmt = null;
		String transDB = null;
		try
		{

			transDB=userInfo.getTransDB();
			ConnDriver mConnDriver = new ConnDriver();

			if(transDB != null && transDB.trim().length() > 0)
			{
				conn = mConnDriver.getConnectDB(transDB);
			}

			String query = " SELECT  LINE_NO, COMP_NAME, COMP_TYPE, METHOD_NAME, ARGS_NAME, ARGS_TYPE, ARGS_VAL FROM OBJ_ACTIONS_CLIENT WHERE OBJ_NAME='"+objName+"'  ORDER BY LINE_NO "; //$NON-NLS-1$ //$NON-NLS-2$
			BaseLogger.log("3", userInfo, null,"getAllClientActionsString : query [" + query + "]"); //$NON-NLS-1$ //$NON-NLS-2$
			stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery( query );

			if( rs.next() )
			{

				allActExtndStrBuff.append("\n<CLIENT_ACTION LINE_NO='"+  rs.getString("LINE_NO") +"' >"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				allActExtndStrBuff.append("<COMP_NAME><![CDATA["+ rs.getString("COMP_NAME") +"]]></COMP_NAME>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				allActExtndStrBuff.append("<COMP_TYPE><![CDATA["+ rs.getString("COMP_TYPE") +"]]></COMP_TYPE>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				allActExtndStrBuff.append("<METHOD_NAME><![CDATA["+ rs.getString("METHOD_NAME") +"]]></METHOD_NAME>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				allActExtndStrBuff.append("<ARGS_NAME><![CDATA["+ rs.getString("ARGS_NAME") +"]]></ARGS_NAME>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				allActExtndStrBuff.append("<ARGS_TYPE><![CDATA["+ rs.getString("ARGS_TYPE") +"]]></ARGS_TYPE>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				allActExtndStrBuff.append("<ARGS_VAL><![CDATA["+ rs.getString("ARGS_VAL") +"]]></ARGS_VAL>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				allActExtndStrBuff.append("</CLIENT_ACTION>"); //$NON-NLS-1$
				BaseLogger.log("3", userInfo, null,"getAllClientActionsString : allActExtndStrBuff ["+allActExtndStrBuff.toString()+"]"); //$NON-NLS-1$ //$NON-NLS-2$
			}
			rs.close();
			rs = null;
			stmt.close();

			allActExtndStrBuff.append("\n</CLIENT_ACTIONS>"); //$NON-NLS-1$
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException: DBAccess: getAllClientActionsString:"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccess: getAllClientActionsString:"  + e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( conn != null )
				{
					if( stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getAllClientActionsString \n" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2", userInfo, null,"Extnd Actions String===================\n"+allActExtndStrBuff.toString()+"\n"); //$NON-NLS-1$ //$NON-NLS-2$
		return allActExtndStrBuff.toString();
	}
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END

	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].START
	public String getUserInfoString(String objName, String userId, String profileId, String userLevel, UserInfoBean userInfo )throws  RemoteException,ITMException
	{
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		StringBuffer userInfoXMLBuff = new StringBuffer();
		String transDB = null;
		try
		{
			transDB = userInfo.getTransDB();

			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB(transDB); //$NON-NLS-1$

			userInfoXMLBuff.append("<transname id='"+objName+"'>"); //$NON-NLS-1$ //$NON-NLS-2$
			userInfoXMLBuff.append("<filters>"); //$NON-NLS-1$

			String query = "SELECT FILTER_NAME, FILTER_POS, DEFAULT_OPT, FILTER_STR FROM USER_FILTER_SETTING WHERE USER_ID ='" + userId + "'" + " AND WIN_NAME = 'w_"+objName+"'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			BaseLogger.log("3", userInfo, null,"[DBAccessEJB]Getting user Info, query :\n"+query+":"); //$NON-NLS-1$ //$NON-NLS-2$
			stmt = conn.createStatement();
			rs = stmt.executeQuery(query);
			//Added by madhup 11/01/07 for getting common user filter
			boolean userFilterExists = false;

			while( rs.next() )
			{
				String filterName = rs.getString("FILTER_NAME"); //$NON-NLS-1$
				String filterPos = rs.getString("FILTER_POS"); //$NON-NLS-1$
				String defaultOpt = rs.getString("DEFAULT_OPT"); //$NON-NLS-1$
				String filterStr = rs.getString("FILTER_STR"); //$NON-NLS-1$

				userInfoXMLBuff.append("<filter pos='"+filterPos+"' default_opt='"+defaultOpt+"'>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				userInfoXMLBuff.append("<name><![CDATA["+filterName+"]]></name>"); //$NON-NLS-1$ //$NON-NLS-2$
				userInfoXMLBuff.append("<expr><![CDATA["+filterStr+"]]></expr>"); //$NON-NLS-1$ //$NON-NLS-2$
				userInfoXMLBuff.append("</filter>"); //$NON-NLS-1$

				// Added by madhup 11/01/07 setting usrBasedFlt as found
				userFilterExists = true;
			}
			rs.close();
			stmt.close();
			stmt = null;
			//changes by madhup 11/01/07 for getting common user filter
			if( ! userFilterExists )
			{
				query = "SELECT FILTER_NAME, FILTER_POS, DEFAULT_OPT, FILTER_STR FROM USER_FILTER_SETTING WHERE USER_ID ='X'" + " AND WIN_NAME = 'w_"+objName+"'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				BaseLogger.log("3", userInfo, null,"[DBAccessEJB]Getting user Info, query :\n"+query+":"); //$NON-NLS-1$ //$NON-NLS-2$
				stmt = conn.createStatement();
				rs = stmt.executeQuery(query);
				while(rs.next())
				{
					String filterName = rs.getString("FILTER_NAME"); //$NON-NLS-1$
					String filterPos = rs.getString("FILTER_POS"); //$NON-NLS-1$
					String defaultOpt = rs.getString("DEFAULT_OPT"); //$NON-NLS-1$
					String filterStr = rs.getString("FILTER_STR"); //$NON-NLS-1$

					userInfoXMLBuff.append("<filter pos='"+filterPos+"' default_opt='"+defaultOpt+"'>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
					userInfoXMLBuff.append("<name><![CDATA["+filterName+"]]></name>"); //$NON-NLS-1$ //$NON-NLS-2$
					userInfoXMLBuff.append("<expr><![CDATA["+filterStr+"]]></expr>"); //$NON-NLS-1$ //$NON-NLS-2$
					userInfoXMLBuff.append("</filter>"); //$NON-NLS-1$
				}
			}
			rs.close();
			if ( stmt != null )
			{
				stmt.close();
				stmt = null;
			}
			// end changes 11/01/07
			userInfoXMLBuff.append("</filters>"); //$NON-NLS-1$
			userInfoXMLBuff.append("<rights_str><![CDATA["+getUserRightsString(objName, profileId, userLevel, transDB , userInfo )+"]]></rights_str>"); //$NON-NLS-1$ //$NON-NLS-2$
			userInfoXMLBuff.append("<AUDIT_STR><![CDATA["+getAuditTrialRights(objName, profileId, userLevel, transDB )+"]]></AUDIT_STR>");
			userInfoXMLBuff.append("</transname>");			 //$NON-NLS-1$
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException :DBAccessEJB :getUserInfoString :==>"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception :DBAccessEJB :getUserInfoString :==>"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(stmt != null)
					{
						stmt.close();
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getUserInfoString :==>\n"+e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2", userInfo, null,"[DBAccessEJB]Returning user Info string !!!!!!!!!!!!!!!"); //$NON-NLS-1$
		return userInfoXMLBuff.toString();
	}
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END
	//Overloaded method is added by Gulzar [][] - to pass userInfo : START.
	private String getUserRightsString( String objName, String profileID, String userLevel, UserInfoBean userInfo  )throws ITMException
	{
		ConnDriver connDriver = null;
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		//Changed by Dhruv on 10/11/2006 to handle user rights.
		//String rightsStr = "*";
		String rightsStr = ""; //$NON-NLS-1$
		try
		{
			String transDB = userInfo.getTransDB();

			BaseLogger.log("3",userInfo, null, "userLevel :["+userLevel+"] userLevel == 0:["+(userLevel == "0")+"]" ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			if( "0".equals( userLevel ) ) //$NON-NLS-1$
			{
				rightsStr = "*"; //$NON-NLS-1$
			}
			else
			{
				connDriver = new ConnDriver();

				//Commented and pass tranDB to method

				conn = connDriver.getConnectDB(transDB); //$NON-NLS-1$

				//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
				//String query = "SELECT RIGHTS FROM USER_RIGHTS WHERE PROFILE_ID ='" + profileID + "'" + " AND OBJ_NAME ='"+objName+"'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				String query = "SELECT RIGHTS FROM USER_RIGHTS WHERE PROFILE_ID IN " + E12GenericUtility.getFormattedProfileId(profileID) + " AND OBJ_NAME ='"+objName+"'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				BaseLogger.log("3", userInfo, null, "[DBAccessEJB]Getting user rights, query :\n"+query+":" ); //$NON-NLS-1$ //$NON-NLS-2$
				stmt = conn.createStatement();
				rs = stmt.executeQuery(query);
				while(rs.next())
				{
					rightsStr = rightsStr + rs.getString( "RIGHTS" ); //$NON-NLS-1$
				}
				rs.close();
				rs = null;
				stmt.close();
				stmt = null;
				conn.close();
				conn=null;
			}
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException :DBAccessEJB :getUserRightsString :==>"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception :DBAccessEJB :getUserRightsString :==>"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getUserRightsString :==>\n"+e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2", userInfo, null,"[DBAccessEJB]Returning usr rights string :\n"+rightsStr+"\n"); //$NON-NLS-1$ //$NON-NLS-2$
		return rightsStr;
	}
	//Overloaded method is added by Gulzar [][] - to pass userInfo : END.

	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].START
	public String getObjActionString(String objName, UserInfoBean userInfo)throws  RemoteException,ITMException
	{
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		StringBuffer retXMLBuff = new StringBuffer();
		String transDB = null;
		try
		{
			transDB=userInfo.getTransDB();
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB(transDB);
			String query = "SELECT RIGHTS_CHAR,TITLE,SERVICE_CODE FROM OBJ_ACTIONS WHERE OBJ_NAME='"+objName+"'"; //$NON-NLS-1$ //$NON-NLS-2$
			BaseLogger.log("3",userInfo, null,"[DBAccessEJB]Getting object action string, query :\n"+query+":"); //$NON-NLS-1$ //$NON-NLS-2$
			stmt = conn.createStatement();
			rs = stmt.executeQuery(query);
			retXMLBuff.append("<Root>"+"\n"); //$NON-NLS-1$ //$NON-NLS-2$
			while(rs.next())
			{
				String rightsChar = rs.getString("RIGHTS_CHAR"); //$NON-NLS-1$
				String title = rs.getString("TITLE"); //$NON-NLS-1$
				String serviceCode = rs.getString("SERVICE_CODE"); //$NON-NLS-1$

				retXMLBuff.append("<Action id='" + rightsChar + "' title='" + title +"' service_code='" + serviceCode +"' >"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				retXMLBuff.append("</Action>"+"\n"); //$NON-NLS-1$ //$NON-NLS-2$
			}
			retXMLBuff.append("</Root>"+"\n"); //$NON-NLS-1$ //$NON-NLS-2$
			stmt.close();
			stmt = null;
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException :DBAccessEJB :getObjActionString :==>"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception :DBAccessEJB :getObjActionString :==>"+ e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getObjActionString \n" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2", userInfo, null,"[DBAccessEJB]Returning object action string :\n"+retXMLBuff+"\n"); //$NON-NLS-1$ //$NON-NLS-2$
		return retXMLBuff.toString();
	}
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].START
	public ArrayList getMailDetailList(String formatCode, UserInfoBean userInfo)throws RemoteException, ITMException
	{
		BaseLogger.log("2",userInfo, null,"[DBAccessEJB] :getMailDetails() 11385 for Format Code :"+formatCode); //$NON-NLS-1$
		ConnDriver mConnDriver = null;
		Connection mConnection = null;
		Statement stmt = null;
		ResultSet mRs = null;
		ResultSetMetaData rsmd = null;
		ArrayList mailDetailList = null;
		String transDB = null;
		try
		{
			transDB=userInfo.getTransDB();
			mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB(transDB);
			String mQuery = "SELECT SEND_TO, COPY_TO, BLIND_COPY, SUBJECT, BODY_TEXT, ATTACH_TYPE FROM MAIL_FORMAT WHERE FORMAT_CODE = '"+formatCode+"'"; //$NON-NLS-1$ //$NON-NLS-2$
			stmt = mConnection.createStatement();
			mRs = stmt.executeQuery(mQuery);

			rsmd = mRs.getMetaData();
			int noOfCols = rsmd.getColumnCount();

			mailDetailList = new ArrayList();

			if (mRs.next())
			{
				String data = null;
				for (int ctr = 1; ctr <= noOfCols; ctr++)
				{
					data = mRs.getString(ctr);
					mailDetailList.add(data);
				}
			}
			stmt.close();
			stmt = null;
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException :DBAccessEJB :getMailDetails :\n"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception :DBAccessEJB :getMailDetails :\n"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getMailDetails :\n"+e.getMessage()); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		return mailDetailList;
	}
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END

	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].START
	public ArrayList getItemChangeElementList(String objName,String formNo, UserInfoBean userInfo )throws RemoteException,ITMException
	{
		ConnDriver mConnDriver = null;
		Connection mConnection = null;
		Statement mStmt = null;
		ResultSet mRs = null;
		ArrayList itemChangeElementsList = null;
		String  mQuery = null;
		String transDB = null;
		try
		{
			transDB=userInfo.getTransDB();

			mConnDriver = new ConnDriver();

			mConnection = mConnDriver.getConnectDB(transDB);

			mQuery = "SELECT FIELD_NAME FROM OBJ_ITEMCHANGE WHERE OBJ_NAME='" + objName + "' AND FORM_NO='" + formNo + "'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			mStmt = mConnection.createStatement();
			mRs = mStmt.executeQuery(mQuery);
			itemChangeElementsList = new ArrayList();
			while(mRs.next())
			{
				String data = mRs.getString("FIELD_NAME"); //$NON-NLS-1$
				itemChangeElementsList.add(data);
			}
			/*--Commented by Nilesh and moved in finally block
			mRs.close();
			mRs = null;
			mStmt.close();
			mStmt = null;
			*/
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException: DBAccess: getElemItemChangeList:"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccess: getElemItemChangeList:"  + e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(mRs != null)
					{
						mRs.close();
						mRs = null;
					}
					if(mStmt != null)
					{
						mStmt.close();
						mStmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getElemItemChangeList \n" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		return itemChangeElementsList;
	}
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].START
	public ArrayList getITMDefaultEditFormNoList( String objName, UserInfoBean userInfo)throws RemoteException, ITMException
	{
		ConnDriver mConnDriver = null;
		Connection mConnection = null;
		Statement mStmt = null;
		ResultSet mRs = null;
		ArrayList itmDefaultEditFormNoList = null;
		String  mQuery = null;
		String transDB = null;
		try
		{
			transDB=userInfo.getTransDB();
			mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB(transDB);

			mQuery = "SELECT FORM_NO FROM OBJ_ITEMCHANGE WHERE OBJ_NAME='" + objName + "' AND FORM_NO<>'1' AND FIELD_NAME='itm_defaultedit'"; //$NON-NLS-1$ //$NON-NLS-2$
			mStmt = mConnection.createStatement();
			mRs = mStmt.executeQuery(mQuery);
			itmDefaultEditFormNoList = new ArrayList();
			while( mRs.next() )
			{
				String data = mRs.getString( "FORM_NO" ); //$NON-NLS-1$
				itmDefaultEditFormNoList.add( data );
			}
			mRs.close();
			mRs = null;
			mStmt.close();
			mStmt = null;
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException: DBAccess: getITMDefaultEditFormNoList:"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccess: getITMDefaultEditFormNoList:"  + e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(mStmt != null)
					{
						mStmt.close();
						mStmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getITMDefaultEditFormNoList \n" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		return itmDefaultEditFormNoList;
	}
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END

	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].START
	public ArrayList getManadatoryItemChangeElementList( String objName, String formNo, String mandatoryFlag, UserInfoBean userInfo )throws RemoteException, ITMException
	{
		ConnDriver mConnDriver = null;
		Connection mConnection = null;
		Statement mStmt = null;
		ResultSet mRs = null;
		ArrayList itemChangeElementsList = null;
		String  mQuery = null;
		String transDB = null;
		try
		{
			transDB=userInfo.getTransDB();

			mConnDriver = new ConnDriver();

			mConnection = mConnDriver.getConnectDB(transDB);

			mQuery = "SELECT FIELD_NAME FROM OBJ_ITEMCHANGE WHERE OBJ_NAME='" + objName + "' AND FORM_NO='" + formNo + "' AND 'Y' = ( CASE WHEN MANDATORY IS NULL THEN '"+mandatoryFlag+"' ELSE MANDATORY END )"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			mStmt = mConnection.createStatement();
			mRs = mStmt.executeQuery(mQuery);
			itemChangeElementsList = new ArrayList();
			while(mRs.next())
			{
				String data = mRs.getString("FIELD_NAME"); //$NON-NLS-1$
				itemChangeElementsList.add(data);
			}
			/*--Commented By Nilesh and moved to finally block Start ::01-06-2017
			mRs.close();
			mRs = null;
			mStmt.close();
			mStmt = null;
			*/
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException: DBAccess: getElemItemChangeList:"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccess: getElemItemChangeList:"  + e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(mStmt != null)
					{
						mStmt.close();
						mStmt = null;
					}
					if(mRs != null)
					{
						mRs.close();
						mRs = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getElemItemChangeList \n" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		return itemChangeElementsList;
	}
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END

	public String getAccFilt(String objName,String profileID, UserInfoBean userInfo)throws  RemoteException,ITMException
	{
		ConnDriver mConnDriver = null;
		Connection mConnection = null;
		Statement mStmt = null;
		ResultSet mRs = null;
		//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
		//String accFilt = null;
		String multiAccFilt = "";
		String  mQuery = null;
		try
		{
			mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB(userInfo.getTransDB()); //$NON-NLS-1$
			//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
			//mQuery = "SELECT ACC_FILT FROM USER_RIGHTS WHERE PROFILE_ID ='" + profileID + "'" + " AND OBJ_NAME ='"+objName+"'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			mQuery = "SELECT ACC_FILT FROM USER_RIGHTS WHERE PROFILE_ID IN " + E12GenericUtility.getFormattedProfileId(profileID) + " AND OBJ_NAME ='"+objName+"'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			//BaseLogger.log("3", null, null,"[DBACCESSEJB]getAccFilt:query:\n"+mQuery);
			mStmt = mConnection.createStatement();
			mRs = mStmt.executeQuery(mQuery);
			while(mRs.next())
			{
				String accFilt = mRs.getString("ACC_FILT"); //$NON-NLS-1$
				//Added by Sagar B. for multiple profile id related changes[11-Dec-17]
				multiAccFilt = multiAccFilt + "(" + accFilt + ") AND ";
			}
			mRs.close();
			mRs = null;
			mStmt.close();
			mStmt = null;
			//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]START
//			if (accFilt == null || accFilt.equals("")) //$NON-NLS-1$
//			{
//				accFilt = ""; //$NON-NLS-1$
//			}
//			else
//			{
//				accFilt = "AND " + accFilt; //$NON-NLS-1$
//			}
			if (multiAccFilt == null || multiAccFilt.equals("")) //$NON-NLS-1$
			{
				multiAccFilt = ""; //$NON-NLS-1$
			}
			else
			{
				multiAccFilt = multiAccFilt.substring( 0, multiAccFilt.lastIndexOf(" AND ") );
				multiAccFilt = "AND " + multiAccFilt; //$NON-NLS-1$
			}
			//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]END
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException: DBAccess: getAccFilt:"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccess: getAccFilt:"  + e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(mStmt != null)
					{
						mStmt.close();
						mStmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getAccFilt \n" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		//return accFilt;
		return multiAccFilt;
	}
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].START
	public String saveDraftObject(String user_id, String objName, int draftLineNo, java.sql.Date create_date, java.sql.Date mod_date, char status, String sharing, String editDomData,String userInfoStr)throws RemoteException,ITMException
	{
		//Added By Prajyot on 9/JAN/2013 [To commit local connection]
		boolean isError = false;

		Connection mConnection = null;
		PreparedStatement mPstmt = null;
		Statement stat = null;
		ResultSet mRs = null;
		String  mInsStat = null;
		String transDB = null;
		try
		{
			ibase.utility.UserInfoBean userInfo = new ibase.utility.UserInfoBean( userInfoStr );
			transDB=userInfo.getTransDB();
			ConnDriver mConnDriver = new ConnDriver();

			mConnection = mConnDriver.getConnectDB(transDB);

			stat = mConnection.createStatement();
			ResultSet tranRS = stat.executeQuery("SELECT COUNT(*) FROM DRAFT_OBJECTS WHERE USER_ID = '" + user_id + "' AND OBJ_NAME = '" + objName +"' AND LINE_NO = " + draftLineNo); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			boolean isExists = false;
			if(tranRS.next())
			{
				isExists = (tranRS.getInt(1) > 0)?true:false;
			}
			tranRS.close();
			tranRS = null;
			stat.close();
			stat=null;
			byte editData [] = editDomData.getBytes();
			if(isExists)
			{
				BaseLogger.log("3", userInfo, null,"Updating draft XML data........"); //$NON-NLS-1$
				mInsStat = "UPDATE DRAFT_OBJECTS SET EDIT_XML_DATA = ? WHERE USER_ID = ? AND  OBJ_NAME = ? AND LINE_NO = ?"; //$NON-NLS-1$
				mPstmt = mConnection.prepareStatement(mInsStat);
				mPstmt.setBytes(1, editData);
				mPstmt.setString(2, user_id);
				mPstmt.setString(3, objName);
				mPstmt.setInt(4, draftLineNo);
			}
			else
			{
				BaseLogger.log("3", userInfo, null,"Inserting new draft XML data........"); //$NON-NLS-1$
				stat = mConnection.createStatement();
				tranRS = stat.executeQuery("SELECT COUNT(*) FROM DRAFT_OBJECTS WHERE USER_ID = '" + user_id + "' AND OBJ_NAME = '" + objName +"'"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				if(tranRS.next())
				{
					draftLineNo = tranRS.getInt(1);
					draftLineNo++;
				}
				stat.close();
				stat=null;
				BaseLogger.log("3", userInfo, null,"New draft line no :"+draftLineNo); //$NON-NLS-1$
				mInsStat = "INSERT INTO DRAFT_OBJECTS (USER_ID, OBJ_NAME, LINE_NO, TITLE, CREATE_DATE, MOD_DATE, STATUS, SHARING, EDIT_XML_DATA) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)"; //$NON-NLS-1$

				mPstmt = mConnection.prepareStatement(mInsStat);
				mPstmt.setString(1, user_id);
				mPstmt.setString(2, objName);
				mPstmt.setInt(3, draftLineNo);
				mPstmt.setString(4, objName.toUpperCase()+draftLineNo);
				mPstmt.setDate(5, create_date);
				mPstmt.setDate(6, mod_date);
				mPstmt.setString(7, String.valueOf(status));
				mPstmt.setString(8, sharing);
				mPstmt.setBytes(9, editData);
			}
			BaseLogger.log("3",userInfo, null,"EDIT DRAFT DATA :\n\n\n\n\n"+new String(editData)+"\n\n\n\n\n"); //$NON-NLS-1$ //$NON-NLS-2$
			BaseLogger.log("3", userInfo, null,"Executing Draft Insert Query"); //$NON-NLS-1$
			mPstmt.executeUpdate();
			tranRS.close();
			tranRS = null;
			mPstmt.close();
			mPstmt = null;
			BaseLogger.log("3", userInfo, null,"Draft data inserted..............."); //$NON-NLS-1$
		}
		catch (ITMException itme)
		{
			//Added By Prajyot on 9/JAN/2013 [To commit local connection]
			isError = true;

			System.err.println("ITMException: DBAccess: saveToDraftObjects:"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			//Added By Prajyot on 9/JAN/2013 [To commit local connection]
			isError = true;

			System.err.println("Exception: DBAccess: saveToDraftObjects:"  + e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(stat != null)
					{
						stat.close();
						stat = null;
					}
					if(mPstmt != null)
					{
						mPstmt.close();
						mPstmt = null;
					}

					//Added By Prajyot on 9/JAN/2013 [To commit local connection]
					if( !isError )
					{
						mConnection.commit();
					}
					else
					{
						mConnection.rollback();
					}

					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getActionTitlesList \n" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		return "Done"; //$NON-NLS-1$
	}
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].START
	public String getAllDraftInfoString(String userID, String objName,String userInfoStr)throws RemoteException,ITMException
	{
		Connection mConnection = null;
		Statement mStmt = null;
		ResultSet mRs = null;
		ResultSetMetaData rsmd = null;
		String  mQuery = null;
		String retXMLStr = null;
		String transDB = null;
		try
		{
			ibase.utility.UserInfoBean userInfo = new ibase.utility.UserInfoBean( userInfoStr );
			transDB=userInfo.getTransDB();

			ConnDriver mConnDriver = new ConnDriver();

			mConnection = mConnDriver.getConnectDB(transDB);

			StringBuffer xmlStringBuff = new StringBuffer();

			mQuery = "SELECT LINE_NO, TITLE FROM DRAFT_OBJECTS WHERE USER_ID = '"+userID+"' AND OBJ_NAME = '"+objName+"'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			mStmt = mConnection.createStatement();
			mRs = mStmt.executeQuery(mQuery);
			rsmd = mRs.getMetaData();
			int noOfCols = rsmd.getColumnCount();
			while(mRs.next())
			{
				String data = null;
				StringBuffer dataBuff = new StringBuffer();

				dataBuff.append("<Detail id=''>\n"); //$NON-NLS-1$
				for (int i = 1; i <= noOfCols; i++)
				{
					data = mRs.getString(i);
					if(data == null)
					{
						data = ""; //$NON-NLS-1$
					}
					dataBuff.append("<"+(String)rsmd.getColumnName(i)+"><![CDATA["+data+"]]></"+(String)rsmd.getColumnName(i)+">\n"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				}
				dataBuff.append("</Detail>\n"); //$NON-NLS-1$
				xmlStringBuff.append(dataBuff);
			}
			mRs.close();
			mRs = null;
			mStmt.close();
			mStmt = null;
			BaseLogger.log("3", userInfo, null,"All draft info string :"+xmlStringBuff.toString()); //$NON-NLS-1$
			retXMLStr = getNormalizeString(xmlStringBuff.toString());
		}
		catch (ITMException itme)
		{
			BaseLogger.log("0", null, null,"ITMException :DBAccessEJB :getAllDraftInfoString :"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null,"Exception :DBAccessEJB :getAllDraftInfoString :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(mStmt != null)
					{
						mStmt.close();
						mStmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getDraftObjectXMLString :"+e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		return retXMLStr;
	}
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].START
	public String getDraftEditXml(String user, String objName, int draftLineNo,String userInfoStr)throws RemoteException,ITMException
	{
		//	BaseLogger.log("3", null, null,"Getting Draft data for obj name :" + objName + "draftLineNo :" + draftLineNo + " and User :"+user);
		Connection mConnection = null;
		PreparedStatement mPstmt = null;
		ResultSet mRs = null;
		String  mQuery = null;
		byte byteDraftEditXml[] = new byte[1];
		StringBuffer retDraftEditXmlBuff = new StringBuffer();
		String transDB = null;
		try
		{
			ibase.utility.UserInfoBean userInfo = new ibase.utility.UserInfoBean( userInfoStr );
			transDB=userInfo.getTransDB();

			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB(transDB);

			StringBuffer addWhereClauseBuff = new StringBuffer();
			boolean isDraftId = false;
			if(draftLineNo != -1)
			{
				isDraftId = true;
				addWhereClauseBuff.append(" AND LINE_NO = ").append("?"); //$NON-NLS-1$ //$NON-NLS-2$
			}
			boolean isObjName = false;
			if(objName != null && objName.length() > 0)
			{
				isObjName = true;
				addWhereClauseBuff.append(" AND OBJ_NAME = ").append("?"); //$NON-NLS-1$ //$NON-NLS-2$
			}

			mQuery = "SELECT EDIT_XML_DATA FROM DRAFT_OBJECTS WHERE USER_ID = ?" + addWhereClauseBuff.toString(); //$NON-NLS-1$

			mPstmt = mConnection.prepareStatement(mQuery);
			mPstmt.setString(1, user);
			if(isDraftId)
			{
				mPstmt.setInt(2, draftLineNo);
			}
			if(isObjName)
			{
				if(!isDraftId)
				{
					mPstmt.setString(2, objName);
				}
				else
				{
					mPstmt.setString(3, objName);
				}
			}
			mRs = mPstmt.executeQuery();

			ArrayList draftStrList = new ArrayList();

			while(mRs.next())
			{
				BaseLogger.log("3", userInfo, null,"Got a value..............."); //$NON-NLS-1$
				draftStrList.add(mRs.getBlob(1));
			}
			mRs.close();
			mRs = null;
			java.sql.Blob dbBlob = null;
			BaseLogger.log("3", userInfo, null,"draftStrList.size() :"+draftStrList.size()); //$NON-NLS-1$
			for(int ctr = 0; ctr < draftStrList.size(); ctr++)
			{
				dbBlob = (java.sql.Blob)draftStrList.get(ctr);
				if (dbBlob != null)
				{
					BaseLogger.log("3", userInfo, null,"DB Blob length :"+dbBlob.length()+":"); //$NON-NLS-1$ //$NON-NLS-2$
					long start = 1;
					byte[] b = dbBlob.getBytes(start, (int)dbBlob.length());
					retDraftEditXmlBuff.append(new String(b));
				}
			}
		}
		catch (ITMException itme)
		{
			BaseLogger.log("0", null, null,"ITMException: DBAccess: getDraftEditXml :"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null,"Exception: DBAccess: getDraftEditXml :" + e); //$NON-NLS-1$
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(mPstmt != null)
					{
						mPstmt.close();
						mPstmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getDraftEditXml :" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		return retDraftEditXmlBuff.toString();
	}
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END

	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].START
	public String getDraftXSLFName(String user, String objName, int draftLineNo, String pageContext,String userInfoStr)throws RemoteException, ITMException
	{
		String xslFileName = null;
		Connection mConnection = null;
		PreparedStatement mPstmt = null;
		ResultSet mRs = null;
		String  mQuery = null;
		String fieldName = "EDIT_XSL_FNAME"; //$NON-NLS-1$
		String transDB = null;

		try
		{
			ibase.utility.UserInfoBean userInfo = new ibase.utility.UserInfoBean( userInfoStr );
			transDB=userInfo.getTransDB();

			if(pageContext != null && pageContext.equalsIgnoreCase("1")) //$NON-NLS-1$
			{
				fieldName = "BROW_XSL_FNAME"; //$NON-NLS-1$
			}
			ConnDriver mConnDriver = new ConnDriver();

			mConnection = mConnDriver.getConnectDB(transDB);

			StringBuffer addWhereClauseBuff = new StringBuffer();
			boolean isDraftId = false;
			if(draftLineNo != -1)
			{
				isDraftId = true;
				addWhereClauseBuff.append(" AND LINE_NO = ").append("?"); //$NON-NLS-1$ //$NON-NLS-2$
			}
			boolean isObjName = false;
			if(objName != null && objName.length() > 0)
			{
				isObjName = true;
				addWhereClauseBuff.append(" AND OBJ_NAME = ").append("?"); //$NON-NLS-1$ //$NON-NLS-2$
			}

			mQuery = "SELECT "+ fieldName +" FROM DRAFT_OBJECTS WHERE USER_ID = ?" + addWhereClauseBuff.toString(); //$NON-NLS-1$ //$NON-NLS-2$

			mPstmt = mConnection.prepareStatement(mQuery);

			mPstmt.setString(1, user);
			if(isDraftId)
			{
				mPstmt.setInt(2, draftLineNo);
			}
			if(isObjName)
			{
				if(!isDraftId)
				{
					mPstmt.setString(2, objName);
				}
				else
				{
					mPstmt.setString(3, objName);
				}
			}
			BaseLogger.log("3", userInfo, null,"Executing Query(for draft xsl for page context - "+pageContext+") :"+mQuery); //$NON-NLS-1$ //$NON-NLS-2$
			mRs = mPstmt.executeQuery();
			if(mRs.next())
			{
				xslFileName = mRs.getString(1);
			}
			mRs.close();
			mRs = null;
			if(xslFileName != null && !xslFileName.endsWith(".xsl")) //$NON-NLS-1$
			{
				xslFileName += ".xsl"; //$NON-NLS-1$
			}
		}
		catch (ITMException itme)
		{
			BaseLogger.log("0", null, null,"ITMException: DBAccess: getDraftXSLFName :"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null,"Exception: DBAccess: getDraftXSLFName :" + e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(mPstmt != null)
					{
						mPstmt.close();
						mPstmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getDraftXSLFName :" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2", null, null,"Returning Draft XSL file name :"+xslFileName); //$NON-NLS-1$
		return xslFileName;
	}
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].START
	public boolean deleteDraftObject(String draftID,String userInfoStr)throws RemoteException, ITMException
	{
		BaseLogger.log("2", null, null,"[DBAccessEJB]Deleting draft object for draftID :"+draftID+":"); //$NON-NLS-1$ //$NON-NLS-2$
		Connection mConnection = null;
		Statement stmt = null;
		boolean isDelDraft = false;
		String transDB = null;

		try
		{
			ibase.utility.UserInfoBean userInfo = new ibase.utility.UserInfoBean( userInfoStr );
			transDB=userInfo.getTransDB();
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB(transDB);
			String query = "DELETE FROM DRAFT_OBJECTS WHERE DRAFT_ID = '"+draftID+"'"; //$NON-NLS-1$ //$NON-NLS-2$
			stmt = mConnection.createStatement();

			BaseLogger.log("3", null, null,"Executing Draft Delete Query ........."); //$NON-NLS-1$
			int deleteCnt = stmt.executeUpdate(query);
			if (deleteCnt > 0)
			{
				isDelDraft = true;
				BaseLogger.log("3", null, null,"Draft object deleted !!!!!!!!!!!!!!!!"); //$NON-NLS-1$
			}
			stmt.close();
			stmt = null;
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException: DBAccess: saveToDraftObjects:"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccess: saveToDraftObjects:"  + e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getActionTitlesList \n" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		return isDelDraft;
	}
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].START
	public void registerReport( HashMap menuEntryMap,String userInfoStr ) throws RemoteException,ITMException//Milind
	{
		//Added By Prajyot on 9/JAN/2013 [To commit local connection]
		boolean isError = false;

		Connection con = null;
		PreparedStatement pStmt = null;
		int levelNo ;
		String transDB = null;
		try
		{
			ibase.utility.UserInfoBean userInfo = new ibase.utility.UserInfoBean( userInfoStr );
			transDB=userInfo.getTransDB();

			ConnDriver connDriver = new ConnDriver();
			con = connDriver.getConnectDB(transDB); //$NON-NLS-1$
			String qry = "INSERT INTO ITM2MENU( APPLICATION,LEVEL_1,LEVEL_2,LEVEL_3,LEVEL_4,LEVEL_5,WIN_NAME,DESCR,COMMENTS,	MENU_PATH,ICON_PATH,OBJ_TYPE ) "+ //$NON-NLS-1$
					"VALUES (?,?,?,?,?,?,?,?,?,?,?,?)"; //$NON-NLS-1$
			pStmt = con.prepareStatement( qry );
			pStmt.setString( 1, menuEntryMap.get( "application" ).toString() ); //$NON-NLS-1$
			levelNo = Integer.parseInt( menuEntryMap.get( "level1" ).toString()); //$NON-NLS-1$
			pStmt.setInt( 2, levelNo );
			levelNo = Integer.parseInt( menuEntryMap.get( "level2" ).toString()); //$NON-NLS-1$
			pStmt.setInt( 3, levelNo );
			levelNo = Integer.parseInt( menuEntryMap.get( "level3" ).toString()); //$NON-NLS-1$
			pStmt.setInt( 4, levelNo );
			levelNo = Integer.parseInt( menuEntryMap.get( "level4" ).toString()); //$NON-NLS-1$
			pStmt.setInt( 5, levelNo );
			levelNo = Integer.parseInt( menuEntryMap.get( "level5" ).toString()); //$NON-NLS-1$
			pStmt.setInt( 6, levelNo );
			pStmt.setString( 7, menuEntryMap.get( "winName" ).toString() );  //$NON-NLS-1$
			pStmt.setString( 8, menuEntryMap.get( "descr" ).toString() ); //$NON-NLS-1$
			pStmt.setString( 9, null );
			pStmt.setString( 10, menuEntryMap.get( "menuPath" ).toString()); //$NON-NLS-1$
			pStmt.setString( 11, "itm_logo.ico" ); //$NON-NLS-1$
			pStmt.setString( 12, "R" ); //$NON-NLS-1$

			pStmt.executeUpdate();
			BaseLogger.log("3", null, null,"Itm2menu Entry completed"); //$NON-NLS-1$
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
		}
		catch(Exception e )
		{
			isError = true;
			System.err.println("Exception :DBAccessEJB :registerReport :\n"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(con != null)
				{
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}

					if( !isError )
					{
						con.commit();
					}
					else
					{
						con.rollback();
					}
					con.close();

					con = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :registerReport :\n"+e.getMessage()); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
	}
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].Start
	public String checkMenuPath( HashMap menuEntryMap,String userInfoStr ) throws RemoteException,ITMException //Milind
	{
		BaseLogger.log("2", null, null,"To Check menu Path"); //$NON-NLS-1$
		Connection con = null;
		ResultSet rs = null;
		PreparedStatement pStmt = null;
		String returnValue = null;
		int levelNo ;
		String transDB = null;
		try
		{
			ibase.utility.UserInfoBean userInfo = new ibase.utility.UserInfoBean( userInfoStr );
			transDB=userInfo.getTransDB();

			ConnDriver connDriver = new ConnDriver();
			con = connDriver.getConnectDB(transDB); //$NON-NLS-1$
			String qry = "SELECT WIN_NAME FROM ITM2MENU WHERE APPLICATION=? AND LEVEL_1=? AND LEVEL_2=? AND LEVEL_3=? AND LEVEL_4=? AND LEVEL_5=?"; //$NON-NLS-1$
			pStmt = con.prepareStatement(qry);
			pStmt.setString(1, menuEntryMap.get("application").toString()); //$NON-NLS-1$
			levelNo = Integer.parseInt( menuEntryMap.get("level1").toString()); //$NON-NLS-1$
			pStmt.setInt(2,levelNo);
			levelNo = Integer.parseInt( menuEntryMap.get("level2").toString()); //$NON-NLS-1$
			pStmt.setInt(3,levelNo);
			levelNo = Integer.parseInt( menuEntryMap.get("level3").toString()); //$NON-NLS-1$
			pStmt.setInt(4,levelNo);
			levelNo = Integer.parseInt( menuEntryMap.get("level4").toString()); //$NON-NLS-1$
			pStmt.setInt(5,levelNo);
			levelNo = Integer.parseInt( menuEntryMap.get("level5").toString()); //$NON-NLS-1$
			pStmt.setInt(6,levelNo);

			rs = pStmt.executeQuery();
			if( rs.next())
			{
				return "Invalid"; //$NON-NLS-1$
			}

			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
		}
		catch(Exception e )
		{
			System.err.println("Exception :DBAccessEJB :checkMenuPath :\n"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(con != null)
				{
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
					con = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :checkMenuPath :\n"+e.getMessage()); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		return "Valid"; //$NON-NLS-1$
	}
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].START
	public String getBlob(String query, ArrayList bindVarValues, ArrayList bindVarTypes,UserInfoBean userInfo) throws RemoteException, ITMException
	{
		String dataStr = ""; //$NON-NLS-1$
		PreparedStatement pStmt = null;
		Connection con = null;
		String transDB = null;
		try
		{
			transDB=userInfo.getTransDB();

			ConnDriver connDriver = new ConnDriver();
			con = connDriver.getConnectDB(transDB); //$NON-NLS-1$

			pStmt = con.prepareStatement(query);
			for (int ctr = 0; ctr < bindVarValues.size(); ctr++ )
			{
				if ( ((String)bindVarTypes.get(ctr)).indexOf("String") != -1) //$NON-NLS-1$
				{
					pStmt.setString((ctr+1), (String)bindVarValues.get(ctr));
				}
				else if (((String)bindVarTypes.get(ctr)).indexOf("Int") != -1) //$NON-NLS-1$
				{
					pStmt.setInt((ctr+1), Integer.parseInt((String)bindVarValues.get(ctr)) );
				}
			}

			ResultSet rs = pStmt.executeQuery();
			if (rs.next())
			{
				InputStream is = rs.getBinaryStream(1);
				if (is != null)
				{

					InputStreamReader isr = new InputStreamReader(is);
					StringBuffer xmlStringBuff = new StringBuffer();
					int ch = -1;
					while((ch = isr.read()) != -1 )
					{
						xmlStringBuff.append((char)ch);
					}
					isr.close();
					dataStr = xmlStringBuff.toString();
					//Added if condition by shrutika on 08-05-18 [Start] for issue in audit trail when no one feed edit and finish the transaction.
					dataStr = dataStr.replace("\n", "");
					if(dataStr.trim().equalsIgnoreCase("<Root></Root>"))
					{
						dataStr="";
					}
					else
					{
						dataStr = xmlStringBuff.toString();
					}

					//Added if condition by shrutika on 08-05-18 [End] for issue in audit trail when no one feed edit and finish the transaction.
				}
			}
			if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</DocumentRoot>") != -1) //$NON-NLS-1$
			{
				dataStr = dataStr.substring(0, dataStr.indexOf("</DocumentRoot>") + 15); //$NON-NLS-1$
			}
			else if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</Root>") != -1) //$NON-NLS-1$
			{
				dataStr = dataStr.substring(0, dataStr.indexOf("</Root>") + 7); //$NON-NLS-1$
			}
			rs.close();
			rs = null;
			pStmt.close();
			pStmt = null;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(con != null)
				{
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
					con.close();
					con = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getBlob :==>finally\n"+e.getMessage()); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		return dataStr;
	}

	public String getXMLTypeStr( String query, ArrayList bindVarValues, ArrayList bindVarTypes, String userInfoStr) throws RemoteException, ITMException
	{
		String dataStr = "";
		PreparedStatement pStmt = null;
		Connection con = null;
		ResultSet rs=null;
		try
		{
			ibase.utility.UserInfoBean userInfo = new ibase.utility.UserInfoBean( userInfoStr );
			String transDB = userInfo.getTransDB();

			ConnDriver connDriver = new ConnDriver();
			con = connDriver.getConnectDB(transDB); //$NON-NLS-1$
			pStmt = con.prepareStatement(query);

			for (int ctr = 0; ctr < bindVarValues.size(); ctr++ )
			{
				if ( ((String)bindVarTypes.get(ctr)).indexOf("String") != -1)
				{
					pStmt.setString((ctr+1), (String)bindVarValues.get(ctr));
				}
				else if (((String)bindVarTypes.get(ctr)).indexOf("Int") != -1)
				{
					pStmt.setInt((ctr+1), Integer.parseInt((String)bindVarValues.get(ctr)) );
				}
			}

			rs = pStmt.executeQuery();
			if (rs.next())
			{
				// Commented By Gulzar/Sneha on 20-DEC-13 to get the XMLType data value as string : START
				/*XMLType xmlTypeObj = (XMLType)rs.getObject(1);
				if(xmlTypeObj != null)
				{
					dataStr=xmlTypeObj.getStringVal();
				}
				else
				{
					dataStr="";
				}
				 */
				dataStr =rs.getString(1) == null ? "":rs.getString(1);
				// Commented By Gulzar/Sneha on 20-DEC-13 to get the XMLType data value as string : END

			}
			if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</DocumentRoot>") != -1)
			{
				dataStr = dataStr.substring(0, dataStr.indexOf("</DocumentRoot>") + 15);
			}
			else if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</Root>") != -1)
			{
				dataStr = dataStr.substring(0, dataStr.indexOf("</Root>") + 7);
			}
			rs.close();
			rs = null;
			pStmt.close();
			pStmt = null;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(con != null)
				{
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					con.close();
					con = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getXMLType :==>finally\n"+e.getMessage()); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		return dataStr;
	}

	public String getRefSerXMLStr(String user,String userInfoStr)throws RemoteException, ITMException
	{
		//BaseLogger.log("3", null, null,"[DBAccessEJB]Getting the ref seriese info. xml string for user :"+user+":");
		String mQuery = null;
		ConnDriver mConnDriver = null;
		Connection mConnection = null;
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String retXMLString = null;
		String transDB = null;
		try
		{
			ibase.utility.UserInfoBean userInfo = new ibase.utility.UserInfoBean( userInfoStr );
			transDB=userInfo.getTransDB();

			mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB(transDB); //$NON-NLS-1$

			StringBuffer roleCodeBuff = new StringBuffer();
			ArrayList roleCodeList = getRoleCodeList(mConnection, user);
			for (int ctr = 0; ctr < roleCodeList.size(); ctr++)
			{
				roleCodeBuff.append("'" + roleCodeList.get(ctr) + "',"); //$NON-NLS-1$ //$NON-NLS-2$
			}

			if(roleCodeBuff.length() > 0)
			{
				roleCodeBuff.deleteCharAt((roleCodeBuff.length() - 1));
				mQuery = "SELECT DISTINCT REF_SER FROM OBJ_SIGN_TRANS WHERE ROLE_CODE__SIGN IN("+roleCodeBuff.toString()+")"; //$NON-NLS-1$ //$NON-NLS-2$
				BaseLogger.log("3", null, null,"[SignManagerEJB]Retrieving relevant REF_SER from OBJ_SIGN table.........."); //$NON-NLS-1$
				pStmt = mConnection.prepareStatement(mQuery);
				rs = pStmt.executeQuery();
				StringBuffer refSerBuff = new StringBuffer();
				while (rs.next())
				{
					String currRefSer = rs.getString(1);
					refSerBuff.append("'"+currRefSer+"',"); //$NON-NLS-1$ //$NON-NLS-2$
				}
				if (pStmt != null)
				{
					rs.close();
					pStmt.close();
				}
				BaseLogger.log("3", null, null,"[SignManagerEJB]Listing all Ref Series corresponding to the current user role codes :"+refSerBuff.toString()); //$NON-NLS-1$
				if (refSerBuff.length() > 0)
				{
					StringBuffer xmlStringBuff = new StringBuffer();
					refSerBuff.deleteCharAt((refSerBuff.length() - 1));
					mQuery = "SELECT REF_SER, DESCR FROM REFSER WHERE REF_SER IN("+refSerBuff.toString()+")"; //$NON-NLS-1$ //$NON-NLS-2$
					pStmt = mConnection.prepareStatement(mQuery);
					rs = pStmt.executeQuery();
					while (rs.next())
					{
						String refSer = rs.getString("REF_SER"); //$NON-NLS-1$
						String objName = getRefSerObjName(refSer, transDB);
						if (objName != null && objName.length() > 0 )
						{
							xmlStringBuff.append("<Detail>"); //$NON-NLS-1$
							xmlStringBuff.append("<REF_SER><![CDATA["+refSer+"]]></REF_SER>"); //$NON-NLS-1$ //$NON-NLS-2$
							xmlStringBuff.append("<REF_SER_DESC><![CDATA["+rs.getString("DESCR")+"]]></REF_SER_DESC>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
							xmlStringBuff.append("<OBJ_NAME><![CDATA["+objName+"]]></OBJ_NAME>"); //$NON-NLS-1$ //$NON-NLS-2$
							xmlStringBuff.append("</Detail>"); //$NON-NLS-1$
						}
						else
						{
							BaseLogger.log("3", null, null,"ObjName not Found For refSer ["+refSer+"]"); //$NON-NLS-1$ //$NON-NLS-2$
						}
					}
					retXMLString = getNormalizeString(xmlStringBuff.toString());
					if(pStmt != null)
					{
						rs.close();
						pStmt.close();
					}
				}
			}
		}
		catch (ITMException itme)
		{
			BaseLogger.log("0", null, null,"ITMException :SignManagerEJB :getRefSerXMLStr :==>"+itme.getMessage()); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null,"Exception :SignManagerEJB :getRefSerXMLStr :==>"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(pStmt != null)
					{
						rs = null;
						pStmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :SignManagerEJB :getRefSerXMLStr :==>finally"+e.getMessage()); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2", null, null,"retXMLString ["+retXMLString+"]"); //$NON-NLS-1$ //$NON-NLS-2$
		return retXMLString;
	}
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END
	public String getRefSer(Connection mConnection, String objName,UserInfoBean userInfo)throws RemoteException, ITMException
	{
		BaseLogger.log("2", userInfo, null,"[DBAccessEJB]getRefSer() called for objName :"+objName+":"); //$NON-NLS-1$ //$NON-NLS-2$
		Statement mStmt = null;
		ResultSet rs = null;
		String refSer = null;
		String transDB = null;
		String flag = "false";  //$NON-NLS-1$
		try
		{

			transDB=userInfo.getTransDB();

			if( mConnection == null )
			{
				mConnection = new ConnDriver().getConnectDB( transDB ); //$NON-NLS-1$
				flag = "true"; //$NON-NLS-1$
			}
			String sqlQuery = null;
			objName = ( objName != null )?objName.trim():objName;
			sqlQuery = "SELECT REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = 'w_"+objName+"'"; //$NON-NLS-1$ //$NON-NLS-2$
			BaseLogger.log("3", userInfo, null,"[DBAccessEJB]Fetching refSer from TRANSETUP for the current object : Query :\n"+sqlQuery); //$NON-NLS-1$
			mStmt = mConnection.createStatement();
			rs = mStmt.executeQuery(sqlQuery);
			if (rs.next())
			{
				refSer = rs.getString(1);
			}
			if(rs != null)
			{
				rs.close();
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo, null,"Exception :DBAccessEJB :getRefSer :\n"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mStmt != null)
				{
					mStmt.close();
				}
				if( "true".equals(flag) && mConnection != null ) //$NON-NLS-1$
				{
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getRefSer :==>"+e.getMessage()); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		return refSer;
	}
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].START
	public String getRefSerObjName(String refSer,String transDB)throws RemoteException, ITMException
	{
		String refSerObjName = "";		 //$NON-NLS-1$
		Connection mConnection = null;
		Statement mStmt = null;
		//String transDB = null;
		ResultSet rs = null;
		try
		{
			//ibase.utility.UserInfoBean userInfo = new ibase.utility.UserInfoBean( userInfoStr );
			//transDB=userInfo.getTransDB();
			ConnDriver mConnDriver =  new ConnDriver();
			mConnection = mConnDriver.getConnectDB(transDB); //$NON-NLS-1$
			String mQuery = "SELECT TRAN_WINDOW FROM TRANSETUP	 WHERE REF_SER = '"+refSer.trim()+"' "; //$NON-NLS-1$ //$NON-NLS-2$
			BaseLogger.log("3", null, null,"mQuery ["+mQuery+"]"); //$NON-NLS-1$ //$NON-NLS-2$
			mStmt = mConnection.createStatement();
			rs = mStmt.executeQuery(mQuery);

			if (rs.next())
			{
				refSerObjName = rs.getString("TRAN_WINDOW"); //$NON-NLS-1$
				refSerObjName = (refSerObjName.startsWith("w_")) ? refSerObjName.substring("w_".length()) : refSerObjName; //$NON-NLS-1$ //$NON-NLS-2$
			}
			//rs.close();
		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null,"Exception :DBAccessEJB :getRefSerObjName :==>\n"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(mStmt != null)
					{
						mStmt.close();
						mStmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :SignManagerEJB :getRefSerObjName :==>finally"+e.getMessage()); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2", null, null,"refSerObjName ["+refSerObjName+"]"); //$NON-NLS-1$ //$NON-NLS-2$
		return refSerObjName.trim();
	}
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].START
	public HashMap getValidateElementMap( String objName, UserInfoBean userInfo )throws RemoteException, ITMException
	{
		ConnDriver connDriver = null;
		Connection connection = null;
		Statement stmt = null;
		ResultSet resSet = null;
		String  query = null;
		String modName=( (objName.toUpperCase()).startsWith("W_")) ? objName:("W_".concat(objName.toUpperCase()));//objName; //$NON-NLS-1$ //$NON-NLS-2$
		ArrayList serverFieldList=null;
		ArrayList clientFieldList=null;
		HashMap validateElementMap=null;
		String transDB = null;

		try
		{
			transDB = userInfo.getTransDB();

			connDriver = new ConnDriver();
			connection = connDriver.getConnectDB(transDB); //$NON-NLS-1$

			query = "SELECT VAL_STAGE,FLD_NAME,BLANK_OPT,VAL_TYPE,OBJ_NAME,VAL_TABLE,ERROR_CD,FLD_TYPE ,FLD_WIDTH ,UDF_USAGE_1,UDF_USAGE_2,UDF_USAGE_3,DESCR FROM GENMST WHERE MOD_NAME IN ('"+modName+"' , 'X')"; //$NON-NLS-1$ //$NON-NLS-2$

			BaseLogger.log("3", userInfo, null,"getValidateElementMap::query::"+query); //$NON-NLS-1$

			stmt = connection.createStatement();
			resSet = stmt.executeQuery(query);

			serverFieldList=new ArrayList();
			clientFieldList=new ArrayList();

			validateElementMap=new HashMap();

			while(resSet.next())
			{

				//ArrayList fieldList=new ArrayList();
				HashMap fieldMap=new HashMap();

				String valStage = resSet.getString("VAL_STAGE"); //$NON-NLS-1$
				if ( valStage == null || valStage.length() <= 0 )
				{
					valStage = "S"; //$NON-NLS-1$
				}
				String fieldName = resSet.getString("FLD_NAME"); //$NON-NLS-1$
				String blankOpt = resSet.getString("BLANK_OPT"); //$NON-NLS-1$
				if ( blankOpt == null || blankOpt.length() <= 0 )
				{
					blankOpt = "Y"; //$NON-NLS-1$
				}
				String valType = resSet.getString("VAL_TYPE"); //$NON-NLS-1$
				if (valType == null || valType.length() <= 0)
				{
					valType="M"; //$NON-NLS-1$
					valStage="B"; //$NON-NLS-1$
				}
				String validateFromObjName = resSet.getString("OBJ_NAME"); //$NON-NLS-1$
				String valTable = resSet.getString("VAL_TABLE"); //$NON-NLS-1$

				String errorCode = resSet.getString("ERROR_CD"); //$NON-NLS-1$
				String fieldType = resSet.getString("FLD_TYPE"); //$NON-NLS-1$

				int fieldWidth = resSet.getInt("FLD_WIDTH"); //$NON-NLS-1$

				String udfUsage1 = resSet.getString("UDF_USAGE_1"); //$NON-NLS-1$
				String udfUsage2 = resSet.getString("UDF_USAGE_2"); //$NON-NLS-1$
				String udfUsage3 = resSet.getString("UDF_USAGE_3"); //$NON-NLS-1$
				String description = resSet.getString("DESCR"); //$NON-NLS-1$

				fieldMap.put("FIELD_NAME",fieldName.trim()); //$NON-NLS-1$
				fieldMap.put("BLANK_OPT",blankOpt); //$NON-NLS-1$
				fieldMap.put("VAL_TYPE",valType); //$NON-NLS-1$
				fieldMap.put("OBJ_NAME",validateFromObjName); //$NON-NLS-1$
				fieldMap.put("VAL_TABLE",valTable); //$NON-NLS-1$
				fieldMap.put("ERROR_CD",errorCode); //$NON-NLS-1$
				fieldMap.put("FLD_TYPE",fieldType); //$NON-NLS-1$
				fieldMap.put("FLD_WIDTH",new Integer(fieldWidth)); //$NON-NLS-1$
				fieldMap.put("UDF_USAGE_1",udfUsage1); //$NON-NLS-1$
				fieldMap.put("UDF_USAGE_2",udfUsage2); //$NON-NLS-1$
				fieldMap.put("DESCR",description); //$NON-NLS-1$




				//fieldList.add(fieldName.trim());
				//fieldList.add(blankOpt);

				if( valStage.equalsIgnoreCase("S") || valStage.equalsIgnoreCase("B") ) //$NON-NLS-1$ //$NON-NLS-2$
				{
					//serverFieldList.add(fieldList);
					serverFieldList.add(fieldMap);
				}
				else if( valStage.equalsIgnoreCase("C") || valStage.equalsIgnoreCase("B") ) //$NON-NLS-1$ //$NON-NLS-2$
				{
					//clientFieldList.add(fieldList);
					clientFieldList.add(fieldMap);
				}

			}

			validateElementMap.put("S",serverFieldList); //$NON-NLS-1$
			validateElementMap.put("C",clientFieldList); //$NON-NLS-1$
			resSet.close();
			resSet = null;
			stmt.close();
			stmt = null;
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException: DBAccess: getValidateElementMap:==>"+itme); //$NON-NLS-1$
			itme.printStackTrace();
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccess: getValidateElementMap:==>"+ e); //$NON-NLS-1$
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(connection != null)
				{
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					connection.close();
					connection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getValidateElementMap ==> \n" + e); //$NON-NLS-1$
				throw new ITMException( e );
			}
		}
		return validateElementMap;
	}
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END

	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].START
	public HashMap getCopyColInfoMap( String objName, String formNo,UserInfoBean userInfo ) throws RemoteException, ITMException
	{
		Connection mConnection = null;
		PreparedStatement pStmt = null;
		ResultSet pRs=null;
		HashMap yExcludeCopyColMap = null;
		HashMap nExcludeCopyColMap = null;
		HashMap excludeCopyColInfoMap = null;
		String transDB = null;
		try
		{
			transDB=userInfo.getTransDB();

			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB(transDB); //$NON-NLS-1$
			String sqlQuery = "SELECT FIELD_NAME,DEF_VALUE,COPY_FLAG FROM TRANS_COPY_SETUP WHERE OBJ_NAME= ? AND FORM_NO= ? "; //$NON-NLS-1$
			pStmt = mConnection.prepareStatement( sqlQuery );
			pStmt.setString(1,objName.trim());
			pStmt.setString(2,formNo.trim());
			pRs = pStmt.executeQuery();
			excludeCopyColInfoMap = new HashMap();
			nExcludeCopyColMap = new HashMap();
			yExcludeCopyColMap = new HashMap();
			while(pRs.next())
			{
				String colName = pRs.getString(1);
				String defValue = pRs.getString(2);
				String copyFlg = pRs.getString(3);
				if( copyFlg == null || "N".equalsIgnoreCase( copyFlg ) ) //$NON-NLS-1$
				{
					nExcludeCopyColMap.put(colName,defValue);
				}
				else if( "Y".equalsIgnoreCase( copyFlg ) ) //$NON-NLS-1$
				{
					yExcludeCopyColMap.put( colName,defValue );
				}
			}
			excludeCopyColInfoMap.put( "N", nExcludeCopyColMap ); //$NON-NLS-1$
			excludeCopyColInfoMap.put( "Y", yExcludeCopyColMap ); //$NON-NLS-1$
			pRs.close();
			pRs = null;
			pStmt.close();
			pStmt = null;
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException :DBAccessEJB :getExcludeCopyColInfoMap :\n"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception :DBAccessEJB :getExcludeCopyColInfoMap :\n"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(pStmt != null)
					{
						pStmt.close();
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getExcludeCopyColInfoMap :==>F" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2", userInfo, null,"Returning excludeCopyColInfoMap :"+ excludeCopyColInfoMap); //$NON-NLS-1$
		return excludeCopyColInfoMap;
	}
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].START
	public String getTranComplMsg(String winName, UserInfoBean userInfo )throws RemoteException, ITMException
	{
		BaseLogger.log("2", userInfo, null,"[DBAccessEJB]Getting TranComplMsg from TRANSETUP for winName ["+ winName + "]"); //$NON-NLS-1$ //$NON-NLS-2$
		ConnDriver mConnDriver = null;
		Connection mConnection = null;
		Statement stmt = null;
		ResultSet mRs = null;
		String retTranComplMsg = null;
		String transDB = null;

		try
		{
			transDB=userInfo.getTransDB();

			mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB(transDB); //$NON-NLS-1$

			String mQuery = "SELECT TRAN_COMPL_MSG FROM TRANSETUP WHERE TRAN_WINDOW = '" + winName + "'"; //$NON-NLS-1$ //$NON-NLS-2$

			BaseLogger.log("3", userInfo, null,"[DBAccessEJB]Query :"+mQuery); //$NON-NLS-1$
			stmt = mConnection.createStatement();
			mRs = stmt.executeQuery(mQuery);

			if (mRs.next())
			{
				retTranComplMsg = mRs.getString(1);
			}
			stmt.close();
			stmt = null;
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException :DBAccessEJB :getTranComplMsg :\n"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception :DBAccessEJB :getTranComplMsg :\n"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getTranComplMsg :\n"+e.getMessage()); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2",userInfo, null,"[DBAccessEJB]Returning getTranComplMsg :"+retTranComplMsg+":"); //$NON-NLS-1$ //$NON-NLS-2$
		return retTranComplMsg;
	}

	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END

	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].START
	public String insertFavoriteObject(String objName , String userId , String clientIP,String userInfoStr)throws RemoteException,ITMException
	{
		Connection mConnection = null;
		PreparedStatement mPstmt = null;
		ResultSet rs = null;
		String  mInsStat = null;
		String returnString = ""; //$NON-NLS-1$
		String transDB = null;
		try
		{
			if(userId!=null)
			{
				ConnDriver mConnDriver = new ConnDriver();
				ibase.utility.UserInfoBean userInfo = new ibase.utility.UserInfoBean( userInfoStr );
				transDB=userInfo.getTransDB();
				if(transDB!=null && (transDB.trim().length() >0 ))
				{
					mConnection = mConnDriver.getConnectDB(transDB); //$NON-NLS-1$
				}
				mInsStat = "SELECT COUNT(1) FROM USER_OBJ_FAV WHERE OBJ_NAME=? AND USER_ID=?"; //$NON-NLS-1$
				mPstmt = mConnection.prepareStatement(mInsStat);
				mPstmt.setString(1, objName);
				mPstmt.setString(2, userId);
				rs = mPstmt.executeQuery();
				if ( rs.next() )
				{
					if(rs.getInt(1) <= 0)
					{

						mInsStat = "INSERT INTO USER_OBJ_FAV(OBJ_NAME , USER_ID ,CHG_DATE , CHG_USER , CHG_TERM ) VALUES (?, ?, ?, ?, ?)"; //$NON-NLS-1$

						mPstmt = mConnection.prepareStatement(mInsStat);
						mPstmt.setString(1, objName);
						mPstmt.setString(2, userId);
						mPstmt.setTimestamp(3, new java.sql.Timestamp(System.currentTimeMillis()));
						mPstmt.setString(4, userId);
						mPstmt.setString(5, clientIP);
						BaseLogger.log("3", userInfo, null,"Executing insertFavoriteObject Query"); //$NON-NLS-1$
						mPstmt.executeUpdate();
						mConnection.commit();
						returnString = Messages.getString("DBAccessEJB_addToFavourites"); //$NON-NLS-1$
					}
					else
					{
						returnString = Messages.getString("DBAccessEJB_alreadyExistsInFavourites"); //$NON-NLS-1$
					}
				}
				mPstmt.close();
				mPstmt = null;
				BaseLogger.log("3", userInfo, null,"Favorite object inserted..............."); //$NON-NLS-1$
			}
			else
			{
				System.err.println(Messages.getString("DBAccessEJB_notLogged")+"\n"+Messages.getString("DBAccessEJB_pleaseReconnect")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$

			}
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException: DBAccess: saveToDraftObjects:"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccess: saveToDraftObjects:"  + e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(mPstmt != null)
					{
						mPstmt.close();
						mPstmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getActionTitlesList \n" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		return returnString;
	}
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END

	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].START
	public String removeFavoriteObject(String objName , String userId,String userInfoStr )throws RemoteException,ITMException
	{
		Connection mConnection = null;
		PreparedStatement mPstmt = null;
		ResultSet rs = null;
		String  mInsStat = null;
		String returnString = ""; //$NON-NLS-1$
		String transDB = null;

		try
		{
			if(userId!=null)
			{
				ConnDriver mConnDriver = new ConnDriver();
				ibase.utility.UserInfoBean userInfo = new ibase.utility.UserInfoBean( userInfoStr );
				transDB=userInfo.getTransDB();
				if(transDB!=null && (transDB.trim().length() >0 ))
				{
					mConnection = mConnDriver.getConnectDB(transDB); //$NON-NLS-1$
				}

				mInsStat = "SELECT COUNT(1) FROM USER_OBJ_FAV WHERE OBJ_NAME=? AND USER_ID=?"; //$NON-NLS-1$
				mPstmt = mConnection.prepareStatement(mInsStat);
				mPstmt.setString(1, objName);
				mPstmt.setString(2, userId);
				rs = mPstmt.executeQuery();
				if ( rs.next() )
				{
					if(rs.getInt(1) > 0)
					{
						mInsStat = "DELETE FROM USER_OBJ_FAV WHERE OBJ_NAME=? AND USER_ID=?"; //$NON-NLS-1$

						mPstmt = mConnection.prepareStatement(mInsStat);
						mPstmt.setString(1, objName);
						mPstmt.setString(2, userId);
						BaseLogger.log("3", userInfo, null,"Executing insertFavoriteObject Query"); //$NON-NLS-1$
						mPstmt.executeUpdate();
						mConnection.commit();
						returnString = Messages.getString("DBAccessEJB_removeFromFavourites"); //$NON-NLS-1$
					}
					else
					{
						returnString = Messages.getString("DBAccessEJB_unableToRemoveFromFavourites"); //$NON-NLS-1$
					}
				}
				mPstmt.close();
				mPstmt = null;
				BaseLogger.log("3", userInfo, null,"Favorite object inserted..............."); //$NON-NLS-1$
			}
			else
			{
				System.err.println(Messages.getString("DBAccessEJB_notLogged")+"\n"+Messages.getString("DBAccessEJB_pleaseReconnect")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$

			}

		}
		catch (ITMException itme)
		{
			System.err.println("ITMException: DBAccess: saveToDraftObjects:"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccess: saveToDraftObjects:"  + e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(mPstmt != null)
					{
						mPstmt.close();
						mPstmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getActionTitlesList \n" + e); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		return returnString;
	}
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END

	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].START
	public String getFavouriteData( String loginCode, String applName, String profileId, String userLevel, boolean isMobile,String userInfoStr )throws RemoteException, ITMException
	{
		StringBuffer favXmlStr = new StringBuffer();
		ConnDriver mConnDriver = null;
		Connection mConnection = null;
		Statement mStatement = null;
		ResultSet mResultSet = null;
		String transDB = null;
		if( applName != null && !"".equalsIgnoreCase(applName) && !"null".equalsIgnoreCase(applName) )
		{
			applName = applName.toUpperCase();
		}

		try
		{
			ibase.utility.UserInfoBean userInfo = new ibase.utility.UserInfoBean( userInfoStr );
			transDB=userInfo.getTransDB();

			mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB(transDB); //$NON-NLS-1$

			int userLev =(userLevel==null||"".equalsIgnoreCase(userLevel))? -1 : Integer.parseInt(userLevel);
			//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
			//String favAndUsrRightsQuery = " SELECT OBJ_NAME FROM USER_RIGHTS WHERE FAV_OPTION = 'Y' AND PROFILE_ID='"+profileId.trim()+"' "
			String favAndUsrRightsQuery = " SELECT OBJ_NAME FROM USER_RIGHTS WHERE FAV_OPTION = 'Y' AND PROFILE_ID IN " + E12GenericUtility.getFormattedProfileId(profileId.trim())
					+" UNION "
					+" SELECT OBJ_NAME FROM USER_OBJ_FAV WHERE USER_ID='"+loginCode.trim()+"' "
					+" AND OBJ_NAME NOT IN ( SELECT TRIM(OBJ_NAME) FROM USER_RIGHTS "
					//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
					//+" WHERE FAV_OPTION = 'Y' AND PROFILE_ID='"+profileId.trim()+"' ) ";
					+" WHERE FAV_OPTION = 'Y' AND PROFILE_ID IN " + E12GenericUtility.getFormattedProfileId(profileId.trim())+" ) ";

			BaseLogger.log("3", userInfo, null, "Getting favObjName SQL [ " + favAndUsrRightsQuery + "]" ); //$NON-NLS-1$ //$NON-NLS-2$
			mStatement = mConnection.createStatement();
			mResultSet = mStatement.executeQuery( favAndUsrRightsQuery );
			favXmlStr.append("<APPLICATION>"); //$NON-NLS-1$
			while(mResultSet.next())
			{
				String objName = mResultSet.getString("OBJ_NAME").trim();
				BaseLogger.log("3", userInfo, null, "FavObjName [" + objName + "]" ); //$NON-NLS-1$ //$NON-NLS-2$
				String winName= ( objName.indexOf("/") == -1 ) ? "w_"+objName : objName ; //$NON-NLS-1$ //$NON-NLS-2$

				String selectFavoriteQry = "";

				if( userLev >= 1 )
				{
					selectFavoriteQry = " SELECT B.APPLICATION ,B.WIN_NAME, B.COMMENTS, B.MENU_PATH ,"
							+" B.DESCR,B.ICON_PATH,B.OBJ_TYPE "
							+" FROM USER_RIGHTS A, ITM2MENU B "
							//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
							//+" WHERE A.PROFILE_ID ='"+profileId.trim()+"' "
							+" WHERE A.PROFILE_ID IN " + E12GenericUtility.getFormattedProfileId(profileId.trim())
							+" AND A.APPLICATION = '"+applName+"' "
							+" AND A.FAV_OPTION = 'Y' "
							+" AND B.WIN_NAME ='"+winName.trim()+"'"
							+" "+(isMobile == true ? " AND B.MOB_DEPLOY = 'Y' " : " ")
							+" AND A.APPLICATION=B.APPLICATION AND A.MENU_ROW=B.LEVEL_1 "
							+" AND A.MENU_COL=B.LEVEL_2 AND A.MENU_SUBCOL=B.LEVEL_3 "
							+" AND A.LEVEL_4=B.LEVEL_4 AND A.LEVEL_5=B.LEVEL_5 "
							+" ORDER BY A.APPLICATION,A.MENU_ROW,A.MENU_COL,A.MENU_SUBCOL,A.LEVEL_4,A.LEVEL_5 ";
				}
				else
				{
					selectFavoriteQry = " SELECT APPLICATION,WIN_NAME,DESCR,COMMENTS,MENU_PATH,"
							+" ICON_PATH, OBJ_TYPE "
							+" FROM ITM2MENU "
							+" WHERE WIN_NAME='"+winName.trim()+"'"
							+" AND APPLICATION ='"+applName+"'"
							+" "+(isMobile == true ? " AND MOB_DEPLOY = 'Y' " : " ")
							+" ORDER BY APPLICATION,LEVEL_1,LEVEL_2,LEVEL_3,LEVEL_4,LEVEL_5";
				}
				BaseLogger.log("3", userInfo, null, "Favourite ITM2MENU Query [" + selectFavoriteQry + "]" ); //$NON-NLS-1$ //$NON-NLS-2$
				Statement fStmt = mConnection.createStatement();
				ResultSet fResultSet = fStmt.executeQuery(selectFavoriteQry);
				if(fResultSet.next())
				{
					favXmlStr.append("<OPTION id='"+fResultSet.getString("MENU_PATH")+"' icon='"+fResultSet.getString("ICON_PATH")+"'><TITLE><![CDATA["+fResultSet.getString("DESCR")+"]]></TITLE><OBJNAME><![CDATA["+objName+"]]></OBJNAME><OBJTYPE>"+fResultSet.getString("OBJ_TYPE")+"</OBJTYPE><COMMENTS>"+fResultSet.getString("COMMENTS")+"</COMMENTS></OPTION>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$ //$NON-NLS-11$ //$NON-NLS-12$ //$NON-NLS-13$
				}
				if( fStmt != null )
				{
					fStmt.close();
					fStmt=null;
				}
				if( fResultSet != null )
				{
					fResultSet.close();
					fResultSet=null;
				}

			}
			favXmlStr.append("</APPLICATION>"); //$NON-NLS-1$
			mResultSet.close();
			mResultSet = null;
			mStatement.close();
			mStatement = null;
		}
		catch(Exception e)
		{
			System.err.println("Exception :DBAccessEJB :getFavouriteData :==>"+e); //$NON-NLS-1$
		}
		finally
		{
			try
			{
				if( mResultSet != null )
				{
					mResultSet.close();
					mResultSet = null;
				}
				if( mStatement != null )
				{
					mStatement.close();
					mStatement =null;
				}
				if(mConnection!=null )
				{
					mConnection.close();
					mConnection=null;
				}
			}
			catch(Exception se)
			{
				BaseLogger.log("0", null, null,"Exception :DBAccessEJB :getFavouriteData : In finally ==>" + se.getMessage()); //$NON-NLS-1$
			}
		}
		BaseLogger.log("2", null, null,"Returning Favorite data ["+favXmlStr+"]"); //$NON-NLS-1$ //$NON-NLS-2$
		return favXmlStr.toString();
	}
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END

	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].START
	public String getPrintCtr(String objName,String transDB) throws ITMException
	{
		BaseLogger.log("2", null, null,"DBAccessEJB CALLED "+objName); //$NON-NLS-1$
		String printControl = ""; //$NON-NLS-1$
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		PreparedStatement pstmt = null;
		ResultSet rs = null;
//		String transDB = null;
		try
		{
//			ibase.utility.UserInfoBean userInfo = new ibase.utility.UserInfoBean( userInfoStr );
//			transDB=userInfo.getTransDB();

			conn = connDriver.getConnectDB(transDB); //$NON-NLS-1$
			String getPrintCtrQuery = "SELECT PRINT_CONTROL FROM TRANSETUP WHERE TRAN_WINDOW = ?";  //$NON-NLS-1$
			pstmt = conn.prepareStatement(getPrintCtrQuery);
			pstmt.setString(1, objName);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				printControl = rs.getString(1);
			}
		}
		catch (Exception e)
		{
			try
			{
				conn.rollback();
			}
			catch( Exception le )
			{
				le.printStackTrace();
				throw new ITMException(le);
			}
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( conn != null )
				{
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return printControl;

	}
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].START
	public String getPrintStatus(String tranId , String objName, String argValue, String user, String chgTerm, String rePrint, String profileId,String userInfoStr, String transDBVal) throws ITMException
	{
		BaseLogger.log("2", null, null,"DBAccessEJB CALLED "+objName); //$NON-NLS-1$
		String printStatus = ""; //$NON-NLS-1$
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pst = null;
		ResultSet rst = null;

		String transDB = null;
		Calendar calendar = Calendar.getInstance();
		Timestamp currentTimestamp = new java.sql.Timestamp(calendar.getTime().getTime());

		int rptCnt = 0;
		int cnt = 0;

		TransIDGenerator tg = new TransIDGenerator("<Root></Root>", "SYSTEM", CommonConstants.DB_NAME); //$NON-NLS-1$ //$NON-NLS-2$
		try
		{
			ibase.utility.UserInfoBean userInfo = new ibase.utility.UserInfoBean( userInfoStr );
			transDB=userInfo.getTransDB();
			conn = connDriver.getConnectDB(transDB); //$NON-NLS-1$

			//Commented and changes done by Gaurav Singh on 21-06-14 : [ Start ]
			//Get the keystring from transetup instead of hard code value
			String keyString = "";
			//String uniqueKey = tg.generateTranSeqID("RPTPRN", "", "seq10", conn); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			keyString = getDBColumnValue("TRANSETUP", "KEY_STRING", " REF_SER = 'RPTPRN'", transDB );
			String uniqueKey = tg.generateTranSeqID("RPTPRN", "", keyString, conn);

			//String uniqueKeyLog = tg.generateTranSeqID("RPTPLG", "", "seq10", conn); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			keyString = getDBColumnValue("TRANSETUP", "KEY_STRING", " REF_SER = 'RPTPLG'", userInfoStr );
			String uniqueKeyLog = tg.generateTranSeqID("RPTPLG", "", keyString, conn);

			//Commented and changes done by Gaurav Singh on 21-06-14 [ End ]

			BaseLogger.log("3", null, null,"uniqueKey [ "+ uniqueKey +"]"); //$NON-NLS-1$ //$NON-NLS-2$
			BaseLogger.log("3", null, null,"uniqueKeyLog [ "+ uniqueKeyLog +"]"); //$NON-NLS-1$ //$NON-NLS-2$
			int insertStatus  = -1;
			int insertLogStatus = -1;

			//Added try/catch block by Ravindra C on 27-03-2020 for avoiding PARAMETER_VAL length exception - Start
			try
			{
				String getPrintStatus = "SELECT COUNT(1) , MAX(REPRINT_CNT) FROM RPT_PRINT_LOG WHERE REPORT_NAME = ? AND PARAMETER_VAL = ? ";  //$NON-NLS-1$
				pstmt = conn.prepareStatement(getPrintStatus);
				pstmt.setString(1, objName);
				pstmt.setString(2, argValue);
				rs = pstmt.executeQuery();

				if(rs.next())
				{
					cnt = rs.getInt(1);
					BaseLogger.log("3", null, null,"rs.getInt = "+rs.getInt(1)); //$NON-NLS-1$
				}
			}
			catch( Exception e )
			{
				e.printStackTrace();
				BaseLogger.log("0", null, null,"In the GetPrintStatus Exception : ["+ e.getMessage() +"]");
			}
			//Added try/catch block by Ravindra C on 27-03-2020 for avoiding PARAMETER_VAL length exception - END
			if(cnt != 0)
			{
				rptCnt = rs.getInt(2);
				if("N".equalsIgnoreCase(rePrint)) //$NON-NLS-1$
				{
					printStatus = "E"; //$NON-NLS-1$
				}
				else
				{

					//changed by gayatri on 10-09-2013 [SY3ESUN003][to display report atleast once if m_reprint ="Y" and rights is other than "*" or "R"] start
					String userRightsStr = getUserRights( objName , profileId, userInfoStr);
					if("Y".equalsIgnoreCase(rePrint) && userRightsStr != null && userRightsStr.indexOf("*") == -1 && userRightsStr.indexOf("R") == -1)
					{
						printStatus = "E";
						return printStatus;
					}
					//changed by gayatri on 10-09-2013 [SY3ESUN003][to display report atleast once if m_reprint ="Y" and rights is other than "*" or "R"] end
					String tranIdCtrl = ""; //$NON-NLS-1$

					//UPDATE REPRINT_CNT IN RPT_PRINT_LOG
					String getTranIdCtrl = "SELECT TRAN_ID__CTRL FROM RPT_PRINT_LOG WHERE REPORT_NAME = ? AND PARAMETER_VAL = ? "; //$NON-NLS-1$
					pst = conn.prepareStatement(getTranIdCtrl);
					pst.setString(1, objName);
					pst.setString(2, argValue);
					rst = pst.executeQuery();
					if(rst.next())
					{
						tranIdCtrl = rst.getString(1);
					}

					pst = null;
					String updateReprintLog = "INSERT INTO RPT_PRINT_LOG (TRAN_ID, REPORT_NAME, PARAMETER_VAL, USER_ID__PRINT, REPRINT_ON, REPRINT_CNT, TRAN_ID__CTRL) VALUES(?, ?, ?, ?, ?, ?, ?)"; //$NON-NLS-1$
					pst = conn.prepareStatement(updateReprintLog);
					pst.setString(1,uniqueKeyLog  );
					pst.setString(2,objName );
					pst.setString(3,argValue );
					pst.setString(4,user );
					pst.setTimestamp(5,currentTimestamp);
					pst.setInt(6,rptCnt+1 );
					pst.setString(7,tranIdCtrl );
					insertStatus = pst.executeUpdate();
					BaseLogger.log("3", null, null,"insertStatus = ["+insertStatus+"]"); //$NON-NLS-1$ //$NON-NLS-2$
					if(insertStatus!= -1)
					{
						printStatus = "W"; //$NON-NLS-1$
					}
				}
			}
			else
			{
				// INSERT INTO RPT_PRINT_CTRL
				BaseLogger.log("3", null, null,"INSERT STATEMENT"); //$NON-NLS-1$
				String insertReportData = "INSERT INTO RPT_PRINT_CTRL (TRAN_ID, REPORT_NAME, PARAMETER_VAL, USER_ID, PRINTED_ON, PRINTED_TERM) VALUES(?, ?, ?, ?, ?, ?)"; //$NON-NLS-1$
				BaseLogger.log("3", null, null,"insertReportData = ["+insertReportData+"]"); //$NON-NLS-1$ //$NON-NLS-2$
				pst = conn.prepareStatement( insertReportData );
				pst.setString(1,uniqueKey );
				pst.setString(2,objName );
				pst.setString(3,argValue );
				pst.setString(4,user );
				pst.setTimestamp(5,currentTimestamp);
				pst.setString(6,chgTerm );
				insertStatus = pst.executeUpdate();

				BaseLogger.log("3", null, null,"insertStatus = ["+insertStatus+"]"); //$NON-NLS-1$ //$NON-NLS-2$
				// INSERT INTO RPT_PRINT_LOG
				pst = null;

				String insertReportLog = "INSERT INTO RPT_PRINT_LOG (TRAN_ID, REPORT_NAME, PARAMETER_VAL, USER_ID__PRINT, REPRINT_ON, REPRINT_CNT, TRAN_ID__CTRL) VALUES(?, ?, ?, ?, ?, ?, ?)"; //$NON-NLS-1$
				BaseLogger.log("3", null, null,"insertReportLog = ["+insertReportLog+"]"); //$NON-NLS-1$ //$NON-NLS-2$
				pst = conn.prepareStatement( insertReportLog );
				pst.setString(1,uniqueKeyLog  );
				pst.setString(2,objName );
				pst.setString(3,argValue );
				pst.setString(4,user );
				pst.setTimestamp(5,currentTimestamp);
				pst.setInt(6,0 );
				pst.setString(7,uniqueKey );
				insertLogStatus = pst.executeUpdate();
				BaseLogger.log("3", null, null,"insertLogStatus = ["+insertLogStatus+"]"); //$NON-NLS-1$ //$NON-NLS-2$
				printStatus = "S"; //$NON-NLS-1$
			}
			if(conn != null)
			{
				conn.commit();
			}
		}
		catch (Exception e)
		{
			e.getStackTrace();
			try
			{
				BaseLogger.log("0", null, null,"inside exception"); //$NON-NLS-1$
				printStatus = "E"; //$NON-NLS-1$
				conn.rollback();
			}
			catch( Exception le )
			{
				le.printStackTrace();
				throw new ITMException(le);
			}
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( conn != null )
				{
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					if( pst != null )
					{
						pst.close();
						pst = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return printStatus;
	}
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].START
	public String getUserRights(String objName, String profileId,String userInfoStr) throws ITMException
	{
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pst = null;
		ResultSet rst = null;
		String userRights = ""; //$NON-NLS-1$
		String userLevel = "";
		String transDB = null;
		try
		{
			ibase.utility.UserInfoBean userInfo = new ibase.utility.UserInfoBean( userInfoStr );
			transDB=userInfo.getTransDB();

			conn = connDriver.getConnectDB(transDB); //$NON-NLS-1$
			String getMenuName = "SELECT DESCR FROM ITM2MENU WHERE WIN_NAME = ?"; //$NON-NLS-1$
			BaseLogger.log("3", null, null,"getUserRights = ["+getMenuName+"]"); //$NON-NLS-1$ //$NON-NLS-2$
			pstmt = conn.prepareStatement(getMenuName);
			//change by shrutika on 19-12-2020 for Exception in application start
			if( objName!= null )
			{
				pstmt.setString(1, "w_"+objName); //$NON-NLS-1$
			}
			else
			{
				pstmt.setNull(1, java.sql.Types.VARCHAR);
			}
			//change by shrutika on 19-12-2020 for Exception in application end
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				try
				{
					//Changed by Pooja S on 15-June-2020 [CustomemMenu image related implementation] Start
					userLevel = userInfo.getUserLevel();
					BaseLogger.log( "3", null, null, "userLevel = ["+userLevel+"]" );
					if( ! "0".equalsIgnoreCase( userLevel ) )
					{
						String menuName = rs.getString(1);
						//changed by gayatri on 6-FAB-2013 [To add profile_id in getUserRights method ]
						//String getUserRights = "SELECT RIGHTS FROM USER_RIGHTS WHERE MENU_NAME = ?"; //$NON-NLS-1$
						//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
						//String getUserRights = "SELECT RIGHTS FROM USER_RIGHTS WHERE MENU_NAME = ? AND PROFILE_ID = ? ";//$NON-NLS-1$
						String getUserRights = "SELECT RIGHTS FROM USER_RIGHTS WHERE MENU_NAME = ? AND PROFILE_ID IN "+ E12GenericUtility.getFormattedProfileId(profileId);//$NON-NLS-1$
						BaseLogger.log("3", null, null,"getUserRights = ["+getUserRights+"]"); //$NON-NLS-1$ //$NON-NLS-2$
						pst = conn.prepareStatement(getUserRights);
						pst.setString(1 , menuName );
						//changed by gayatri on 6-FAB-2013 [To add profile_id in getUserRights method ]
						//pst.setString(2 , profileId );
						rst = pst.executeQuery();
						//if(rst.next())
						while(rst.next())
						{
							userRights = userRights + rst.getString(1);
						}
					}
					else
					{
						userRights = "*";
					}
					//Changed by Pooja S on 15-June-2020 [CustomemMenu image related implementation] End
				}
				catch(Exception e)
				{
					e.getStackTrace();
					throw new ITMException(e);
				}
			}
		}
		catch (Exception e)
		{
			e.getStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( conn != null )
				{
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
					if( pst != null )
					{
						pst.close();
						pst = null;
					}
					if ( rst != null )
					{
						rst.close();
						rst = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2", null, null,"userRights [ "+userRights+"]"); //$NON-NLS-1$ //$NON-NLS-2$
		return userRights;
	}
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].START
	public String getStartForm(String objName,UserInfoBean userInfo)throws RemoteException, ITMException
	{
		String startForm = "";
		Connection mConnection = null;
		Statement mStmt = null;
		ResultSet rs = null;
		String transDB = null;
		//Statement is replaced with PreparedStatement by Gulzar
		PreparedStatement pstmt=null;
		try
		{

			transDB=userInfo.getTransDB();

			ConnDriver mConnDriver =  new ConnDriver();
			mConnection = mConnDriver.getConnectDB(transDB);
			//String mQuery = "SELECT START_FORM FROM TRANSETUP WHERE TRAN_WINDOW = 'w_" + objName.trim() + "' "; //$NON-NLS-1$ //$NON-NLS-2$
			String mQuery = "SELECT START_FORM FROM TRANSETUP WHERE TRAN_WINDOW = ? "; //$NON-NLS-1$ //$NON-NLS-2$
			BaseLogger.log("3", null, null,"mQuery ["+mQuery+"]");
			/*mStmt = mConnection.createStatement();
			rs = mStmt.executeQuery(mQuery);*/

			pstmt = mConnection.prepareStatement(mQuery);
			pstmt.setString(1 , "w_" + objName.trim() );
			rs = pstmt.executeQuery();

			if (rs.next())
			{
				startForm = checkNull( rs.getString("START_FORM") );
			}
			/*
			rs.close();
			rs = null;
			*/
		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null,"Exception :DBAccessEJB :getStartForm :==>\n"+e);
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getStartForm :==>finally"+e.getMessage()); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2", null, null,"TRANSETUP.startForm ["+startForm+"]");
		return startForm.trim();
	}
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].START
	public String getIsAttachment(String objName,UserInfoBean userInfo)throws RemoteException, ITMException
	{
		String isAttachment = "";
		Connection mConnection = null;
		Statement mStmt = null;
		ResultSet rs = null;
		String transDB = null;
		//Statement is replaced with PreparedStatement by Gulzar
		PreparedStatement pstmt=null;
		try
		{
			transDB=userInfo.getTransDB();

			ConnDriver mConnDriver =  new ConnDriver();
			mConnection = mConnDriver.getConnectDB(transDB);
			//String mQuery = "SELECT ISATTACHMENT FROM TRANSETUP WHERE TRAN_WINDOW = 'w_" + objName.trim() + "' ";
			String mQuery = "SELECT ISATTACHMENT FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
			BaseLogger.log("3", null, null,"mQuery ["+mQuery+"]");
			/*mStmt = mConnection.createStatement();
			rs = mStmt.executeQuery(mQuery);*/

			pstmt = mConnection.prepareStatement(mQuery);
			pstmt.setString(1 , "w_" + objName.trim() );
			rs = pstmt.executeQuery();

			if (rs.next())
			{
				isAttachment = checkNull( rs.getString("ISATTACHMENT") );
			}
			/*
			rs.close();
			rs = null;
			*/
		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null,"Exception :DBAccessEJB :getIsAttachment :==>\n"+e);
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getIsAttachment :==>finally"+e.getMessage());
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2", null, null,"isAttachment ["+isAttachment+"]");
		return isAttachment.trim();
	}

	public String processAudit(String objName, String chgXml, String chgUser, String chgTerm, String userInfoStr)throws ITMException
	{
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String auditTranId = "";
		int result = 0;
		boolean updStatus = false;
		String respString = "Faliure";
		int maxChgId = 0;

		try
		{
			ibase.utility.UserInfoBean userInfo = new ibase.utility.UserInfoBean( userInfoStr );
			String transDB = userInfo.getTransDB();
			//Added by shrutika on 26-10-18 [Start] for display change ip and mac address in audit trail.
			String chgIp = "";
			if( userInfo != null)
			{
				chgTerm = userInfo.getMacAddress();
				chgIp = userInfo.getRemoteAddress();
			}
			//Added by shrutika on 26-10-18 [End] for display change ip and mac address in audit trail.
			//Changed By Mahesh Patidar on 15-MAY-13 [Change the procedure to get PROCESS_AUDIT_SEQ value for different database ]
			if ( "MSSQL".equalsIgnoreCase( CommonConstants.DB_NAME ) )
			{
				respString = "Success";
				return respString;
			}

			ConnDriver mConnDriver =  new ConnDriver();
			conn = mConnDriver.getConnectDB(transDB);
			//			String nextseqQuery =  "SELECT PROCESS_AUDIT_SEQ.NEXTVAL FROM DUAL " ;
			//			stmt = conn.createStatement();
			//			rs = stmt.executeQuery( nextseqQuery );
			//			if( rs.next() )
			//			{
			//				auditTranId = rs.getString( 1 );
			//			}
			//			rs = null;

			String nextseqQuery = "";
			if ( "db2".equalsIgnoreCase( CommonConstants.DB_NAME ) )
			{
				nextseqQuery = "SELECT NEXTVAL FOR PROCESS_AUDIT_SEQ FROM DUAL" ;
			}
			else if("mysql".equalsIgnoreCase( CommonConstants.DB_NAME ))
			{
				String maxValueStr ="";
				String getMaxValue = "SELECT MAX(MAX_VALUE) FROM SEQUENCES WHERE SEQ_NAME = 'PROCESS_AUDIT_SEQ' ";
				stmt = conn.createStatement();
				rs = stmt.executeQuery(getMaxValue);

				if(rs.next())
				{
					if(rs.getInt(1) != 0)
					{
						auditTranId = String.valueOf(rs.getInt(1));
						if(auditTranId != null && auditTranId.length() >0 )
						{
							maxValueStr = "UPDATE SEQUENCES SET MAX_VALUE = ? WHERE SEQ_NAME = 'PROCESS_AUDIT_SEQ' ";
							pstmt = conn.prepareStatement(maxValueStr);
							pstmt.setLong(1,rs.getInt(1)+1);
						}
					}
					else
					{
						auditTranId = String.valueOf(1);
						maxValueStr = "INSERT INTO SEQUENCES ( MAX_VALUE ,SEQ_NAME) VALUES (?, ?) ";
						pstmt = conn.prepareStatement(maxValueStr);
						pstmt.setInt(1,1);
						pstmt.setString(2,"PROCESS_AUDIT_SEQ");
					}
				}

				pstmt.executeUpdate();
				rs.close();
				stmt.close();
				pstmt.close();
				rs = null;
				stmt = null;
				pstmt = null;
			}
			else
			{
				nextseqQuery = "SELECT PROCESS_AUDIT_SEQ.NEXTVAL FROM DUAL" ;
			}
			if(!"mysql".equalsIgnoreCase( CommonConstants.DB_NAME ))
			{
				stmt = conn.createStatement();
				rs = stmt.executeQuery( nextseqQuery );
				while(rs.next())
				{
					auditTranId = rs.getString(1);
				}
				rs.close();
				stmt.close();
				rs = null;
				stmt = null;
			}
			//Ended By Mahesh Patidar

			Random random = new Random();
			int refId = random.nextInt(999999999);
			//Changed by gayatri on 01-10-2013 [to cast CHG_ID as number ][WI3FSUN002]
			//String getMaxChangeId = "SELECT MAX( CHG_ID) FROM AUDIT_TRAIL WHERE OBJ_NAME = ?";

			//Changed by gayatri on 30-10-2013 [To support multiple database ][WI3FSUN002]start
			//String getMaxChangeId = "SELECT MAX( CAST ( (CHG_ID) AS NUMBER(10) ) ) CHG_ID  FROM AUDIT_TRAIL WHERE OBJ_NAME = ?";
			String getMaxChangeId = "";
			if("mysql".equalsIgnoreCase( CommonConstants.DB_NAME ) || "db2".equalsIgnoreCase( CommonConstants.DB_NAME ) )
			{
				getMaxChangeId =  "SELECT MAX(CAST(CHG_ID AS DECIMAL(10))) CHG_ID FROM AUDIT_TRAIL WHERE OBJ_NAME = ?";
			}
			else
			{
				getMaxChangeId = "SELECT MAX( CAST ( (CHG_ID) AS NUMBER(10) ) ) CHG_ID  FROM AUDIT_TRAIL WHERE OBJ_NAME = ?";
			}
			//Changed by gayatri on 30-10-2013 [To support multiple database ][WI3FSUN002]end
			pstmt = conn.prepareStatement( getMaxChangeId );
			pstmt.setString( 1, objName );
			rs  = pstmt.executeQuery();
			if(rs.next())
			{
				maxChgId = rs.getInt(1);
			}
			maxChgId++;
			pstmt = null;


			//Changed by gayatri on 30-10-2013 [To support multiple database ][WI3FSUN002]start
			/*
			String insertQuery = "INSERT INTO AUDIT_TRAIL (CHG_ID, OBJ_NAME, REF_ID, DATA_XML_BEFORE, CHG_XML, DATA_XML_AFTER, CHG_USER, CHG_DATE, CHG_TERM, TRAN_ID, ACTION_PRFRM) VALUES (?,?,?,EMPTY_BLOB(),EMPTY_BLOB(),EMPTY_BLOB(),?,?,?,?,?)";
			pstmt = conn.prepareStatement( insertQuery );
			pstmt.setString( 1, String.valueOf(maxChgId));
			pstmt.setString( 2, objName );
			pstmt.setString( 3, String.valueOf(refId) );
			pstmt.setString( 4, chgUser );
			pstmt.setTimestamp(5, new java.sql.Timestamp(System.currentTimeMillis()));
			pstmt.setString(6, chgTerm );
			pstmt.setString(7, auditTranId );
			pstmt.setString( 8, "Process" );

			result = pstmt.executeUpdate();

			ArrayList<String> bindVarValues = new ArrayList<String>();
			bindVarValues.add( auditTranId );

			ArrayList<String> bindVarTypes = new ArrayList<String>();
			bindVarTypes.add("String");
			String query = "SELECT CHG_XML FROM AUDIT_TRAIL WHERE TRAN_ID=? FOR UPDATE";

			updStatus = updateBlob(conn, query, chgXml, bindVarValues, bindVarTypes);

			if(updStatus)
			{
				respString = "Success";
			}
			 */
			if(!"mysql".equalsIgnoreCase( CommonConstants.DB_NAME ))
			{
				//Change by shrutika on 26-10-18 for display change ip and mac address in audit trail.
				//String insertQuery = "INSERT INTO AUDIT_TRAIL (CHG_ID, OBJ_NAME, REF_ID, DATA_XML_BEFORE, CHG_XML, DATA_XML_AFTER, CHG_USER, CHG_DATE, CHG_TERM, TRAN_ID, ACTION_PRFRM) VALUES (?,?,?,EMPTY_BLOB(),EMPTY_BLOB(),EMPTY_BLOB(),?,?,?,?,?)";
				String insertQuery = "INSERT INTO AUDIT_TRAIL (CHG_ID, OBJ_NAME, REF_ID, DATA_XML_BEFORE, CHG_XML, DATA_XML_AFTER, CHG_USER, CHG_DATE, CHG_TERM, TRAN_ID, ACTION_PRFRM, CHG_IP) VALUES (?,?,?,EMPTY_BLOB(),EMPTY_BLOB(),EMPTY_BLOB(),?,?,?,?,?,?)";
				pstmt = conn.prepareStatement( insertQuery );
				pstmt.setString( 1, String.valueOf(maxChgId));
				pstmt.setString( 2, objName );
				pstmt.setString( 3, String.valueOf(refId).trim() );//Gaurav Singh on 30-May-2016
				pstmt.setString( 4, chgUser );
				pstmt.setTimestamp(5, new java.sql.Timestamp(System.currentTimeMillis()));
				pstmt.setString(6, chgTerm );
				pstmt.setString(7, auditTranId );
				pstmt.setString( 8, "Process" );
				//Added by shrutika on 26-10-18 for display change ip and mac address in audit trail.
				pstmt.setString( 9, chgIp );
				result = pstmt.executeUpdate();
				ArrayList<String> bindVarValues = new ArrayList<String>();
				bindVarValues.add( auditTranId );

				ArrayList<String> bindVarTypes = new ArrayList<String>();
				bindVarTypes.add("String");
				String query = "SELECT CHG_XML FROM AUDIT_TRAIL WHERE TRAN_ID = ? FOR UPDATE";

				updStatus = updateBlob(conn, query, chgXml, bindVarValues, bindVarTypes);

				if(updStatus)
				{
					respString = "Success";
				}
			}
			else
			{
				//Change by shrutika on 26-10-18 for display change ip and mac address in audit trail.
				//String insertQuery = "INSERT INTO AUDIT_TRAIL (CHG_ID, OBJ_NAME, REF_ID, DATA_XML_BEFORE, CHG_XML, DATA_XML_AFTER, CHG_USER, CHG_DATE, CHG_TERM, TRAN_ID, ACTION_PRFRM) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
				String insertQuery = "INSERT INTO AUDIT_TRAIL (CHG_ID, OBJ_NAME, REF_ID, DATA_XML_BEFORE, CHG_XML, DATA_XML_AFTER, CHG_USER, CHG_DATE, CHG_TERM, TRAN_ID, ACTION_PRFRM, CHG_IP) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
				pstmt = conn.prepareStatement( insertQuery );
				pstmt.setString( 1, String.valueOf(maxChgId));
				pstmt.setString( 2, objName );
				pstmt.setString( 3, String.valueOf(refId).trim() );//Gaurav Singh on 30-May-2016
				pstmt.setString( 4, null );

				byte[] chgXmlArray = (chgXml != null ? chgXml.getBytes() : null );
				ByteArrayInputStream chgXmlByteArray = (chgXml != null ? new ByteArrayInputStream( chgXmlArray ) : null );

				if(chgXmlArray != null)
				{
					pstmt.setBinaryStream(5, chgXmlByteArray, chgXmlByteArray.available());
				}
				else
				{
					pstmt.setString( 5, null );
				}
				pstmt.setString( 6, null );
				pstmt.setString( 7, chgUser );
				pstmt.setTimestamp(8, new java.sql.Timestamp(System.currentTimeMillis()));
				pstmt.setString(9, chgTerm );
				pstmt.setString(10, auditTranId );
				pstmt.setString( 11, "Process" );
				//Added by shrutika on 26-10-18 for display change ip and mac address in audit trail.
				pstmt.setString( 12, chgIp );
				result = pstmt.executeUpdate();
			}

			rs.close();
			rs = null;
			//Changed by gayatri on 30-10-2013 [To support multiple database ][WI3FSUN002]end
		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null,"Exception :DBAccessEJB :getIsAttachment :==>\n"+e);
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}

					//Added By Prajyot on 9/JAN/2013 [To commit local connection]
					if( updStatus )
					{
						conn.commit();
					}
					else
					{
						conn.rollback();
					}

					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getIsAttachment :==>finally"+e.getMessage());
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2", null, null,"respString = "+respString);
		return respString;
	}

	public ArrayList getApplications(String userId,String userLevel,String userInfoStr) throws RemoteException,ITMException
	{
		ArrayList<String> applsNm = new ArrayList<String>();
		ArrayList<String> applDesc = new ArrayList<String>();
		Connection mConnection = null;
		Statement stmt = null;
		String selectQuery=null;
		String subquery =null;
		ResultSet rs = null;
		String transDB = null;
		BaseLogger.log("2", null, null,"User level : "+ userLevel);
		try
		{
			ibase.utility.UserInfoBean userInfo = new ibase.utility.UserInfoBean( userInfoStr );
			transDB=userInfo.getTransDB();
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB(transDB);
			if(userLevel != null && userLevel.equalsIgnoreCase("0")){

				//Changes By Umakanta / Prajyot on 15JULY14 [DB2 Compatibility for Join statements]
				//selectQuery = "SELECT DISTINCT a.APPLICATION , b.DESCR " +
				//		"from USER_RIGHTS a, APPL_MST b " +
				//		"WHERE b.APP_NAME(+) = a.APPLICATION";
				selectQuery = "SELECT DISTINCT a.APPLICATION , b.DESCR from USER_RIGHTS a right outer join APPL_MST b ON b.APP_NAME = a.APPLICATION";
			}
			else
			{

				selectQuery = "SELECT DISTINCT a.APPLICATION , c.DESCR " +
						"from USER_RIGHTS a , USERS b, APPL_MST c WHERE a.PROFILE_ID= b.PROFILE_ID and a.APPLICATION = c.APP_NAME and b.CODE='"+ userId +"'";
			}
			BaseLogger.log("3", null, null,"my query:: " + selectQuery);
			stmt = mConnection.createStatement();
			rs = stmt.executeQuery(selectQuery);

			while(rs.next())
			{
				applsNm.add(rs.getString("APPLICATION")+"["+rs.getString("DESCR")+"]");
			}

			if(rs!=null){
				rs.close();
				rs =null;
			}

		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null,"Exception :DBAccessEJB :Applications :==>" + e.getMessage());
			throw new ITMException(e);
		}

		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getApplications :\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2", null, null,"[DBAccessEJB]Return Application array  :"+applsNm);
		return applsNm;
	}
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].START
	public String getAppDescription(String applName,String userInfoStr)throws RemoteException,ITMException
	{
		String descrp = null;
		Connection mConnection = null;
		Statement stmt = null;
		String transDB = null;
		try
		{
			ibase.utility.UserInfoBean userInfo = new ibase.utility.UserInfoBean( userInfoStr );
			transDB=userInfo.getTransDB();
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB(transDB);
			String selectQuery = "select descr from appl_mst where app_name =" +"'"+applName+"'" ;
			stmt = mConnection.createStatement();
			ResultSet rs = stmt.executeQuery(selectQuery);
			if(rs.next())
			{
				descrp = rs.getString("descr");
			}
			rs.close();
			rs = null;
			stmt.close();
			stmt = null;
			mConnection.close();
			mConnection = null;
		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null,"Exception :DBAccessEJB :AppDescription :==>");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getAppDescription :\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2", null, null,"[DBAccessEJB]Return Description value  :"+descrp);

		return descrp;
	}
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].START
	public String getDBColumnValue(String tableName, String columnName, String condition,String transDB)throws RemoteException, ITMException
	{
		String columnValue = "";
		Connection mConnection = null;
		Statement mStmt = null;
		ResultSet rs = null;
		String selectColumns="";
//		String transDB = null;
		try
		{
			String columnNameAs = "";
			//Added By Nilesh Start ::30-06-2017 For db2
			selectColumns=columnName;
			//Added By Nilesh Start ::30-06-2017 For db2
			if( columnName.indexOf("~AS~") != -1 )
			{
				String[] columnNameArr = columnName.split("~AS~");
				if( columnNameArr.length > 1 )
				{
					columnName = columnNameArr[0];
					columnNameAs = columnNameArr[1];
					//Added By Nilesh Start ::30-06-2017 For db2
					selectColumns=columnName+" AS "+columnNameAs;
					//Added By Nilesh Start ::30-06-2017 For db2
				}
			}
			ConnDriver mConnDriver =  new ConnDriver();
			if( transDB != null && (transDB.trim().length() > 0 ) )
			{
				mConnection = mConnDriver.getConnectDB(transDB);
			}

			String mQuery =  " SELECT " +  selectColumns + " FROM " + tableName + " WHERE " + condition ;
			BaseLogger.log("3", null, null,"mQuery ["+mQuery+"]");
			mStmt = mConnection.createStatement();
			rs = mStmt.executeQuery(mQuery);
			//Added By Nilesh Start ::30-06-2017 For db2
			BaseLogger.log("3", null, null,"columnNameAs::"+columnNameAs);
			//Added By Nilesh Start ::30-06-2017 For db2

			if( columnNameAs.length() > 0 )
			{
				columnName = columnNameAs;
			}
			if (rs.next())
			{
				columnValue = checkNull( rs.getString( columnName.trim() ) );
			}
		}
		catch (Exception e)
		{
			columnValue = "";
			BaseLogger.log("0", null, null,"Exception :DBAccessEJB :getDBColumnValue() :==>\n"+e.getMessage());
		}
		finally
		{
			try
			{
				//To close ResultSet, Statement and Connection in Finally
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(mStmt != null)
				{
					mStmt.close();
					mStmt = null;
				}
				if(mConnection != null)
				{
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getTransetupColumnValue() :==>finally"+e.getMessage()); //$NON-NLS-1$
			}
		}
		BaseLogger.log("2", null, null,tableName +"." + columnName + " ["+columnValue+"]");
		return columnValue.trim();
	}
	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END

	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END
	public String getMaxReprintCount(String objName, String argValue,String userInfoStr) throws ITMException
	{
		BaseLogger.log("2", null, null,"DBAccessEJB CALLED "+objName); //$NON-NLS-1$
		String maxReprintCount = ""; //$NON-NLS-1$
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String transDB = null;
		try
		{
			ibase.utility.UserInfoBean userInfo = new ibase.utility.UserInfoBean( userInfoStr );
			transDB=userInfo.getTransDB();

			conn = connDriver.getConnectDB(transDB); //$NON-NLS-1$

			String getMaxReprintSql = "SELECT COUNT(1) , MAX(REPRINT_CNT) FROM RPT_PRINT_LOG WHERE REPORT_NAME = ? AND PARAMETER_VAL = ? ";
			pstmt = conn.prepareStatement(getMaxReprintSql);
			pstmt.setString(1, objName);
			pstmt.setString(2, argValue);

			rs = pstmt.executeQuery();

			if(rs.next())
			{
				maxReprintCount = String.valueOf(rs.getInt(2));
				BaseLogger.log("3", null, null,"[Max Reprint Count] = "+maxReprintCount);
			}
		}
		catch (SQLException e)
		{
			e.getStackTrace();
		}
		catch (Exception e)
		{
			e.getStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( conn != null )
				{
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return maxReprintCount;
	}

	public String getProcessAuditDetail(String objName, int noOfRecord, String userInfoStr)throws ITMException
	{
		BaseLogger.log("2", null, null,"In DBAccessEjb");
		StringBuffer xmlData = new StringBuffer("<Root>");
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			ibase.utility.UserInfoBean userInfo = new ibase.utility.UserInfoBean( userInfoStr );
			String transDB=userInfo.getTransDB();
			conn = connDriver.getConnectDB(transDB);
			//change by gayatri on 19-09-2013[WI3FSUN002][to sort rows as per date]
			//String getProcAuditData = "SELECT CHG_XML  FROM AUDIT_TRAIL WHERE OBJ_NAME = ? AND ROWNUM < = ?";
			String getProcAuditData = "SELECT * FROM (SELECT ROWNUM AS ROW_NO ,CHG_XML FROM AUDIT_TRAIL WHERE OBJ_NAME = ? ORDER BY CHG_DATE DESC)WHERE ROW_NO <= ?";
			pstmt = conn.prepareStatement(getProcAuditData);
			pstmt.setString(1, objName);
			//change by gayatri on 19-09-2013 [WI3FSUN002][to get row as mentioned in properties table]
			//pstmt.setInt(2, noOfRecord);
			pstmt.setInt(2, noOfRecord+1);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				Blob blobData = rs.getBlob("CHG_XML");
				String currentNode = new String(blobData.getBytes( 1, (int)blobData.length()));
				BaseLogger.log("3", null, null,"currentNode = [ "+currentNode+" ]");

				if(currentNode != null && currentNode.indexOf("<DocumentRoot>")!= -1)
				{
					xmlData.append(currentNode.substring(currentNode.indexOf("<Arguments>"), currentNode.indexOf("</Arguments>")));
					xmlData.append("</Arguments>");

				}
				else if(currentNode != null && currentNode.indexOf("</Root>")!= -1)
				{
					xmlData.append(currentNode.substring(6, currentNode.indexOf("</Root>")));
				}
			}
			xmlData.append("</Root>");
		}
		catch (Exception e)
		{
			e.getStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( conn != null )
				{
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		BaseLogger.log("9", null, null,"xmlData [= "+xmlData+"]");
		return xmlData.toString();
	}

	//Added By Shahu Mali on  09-10-13.[WS3GBAS001].END


	//Added by Dnyaneshwar chavan on 15-APR-14 [ Draw the no. of sites ] Start
	/**
	 * This method return the user site information
	 *
	 * @param userId the current login user id
	 * @param userLevel
	 * @return the String
	 * @throws ITMException
	 */
	@Override
	public String getSiteInfo(String userId, String userLevel, UserInfoBean userInfoBean) throws ITMException
	{
		StringBuffer xmlData = new StringBuffer("<ROOT>");
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try
		{
			int usrLevel = Integer.parseInt( userLevel );
			//Added by Pankaj T on 19-12-17 [changes for multitenancy]
			String transDB = userInfoBean.getTransDB();
			conn = connDriver.getConnectDB(transDB);
			boolean isProfileId = true;
			//changed by vishal pathare on 13.4.18 for[site wise enterprise image related changes]
			//Changes made by Pratheek on 05-02-19[to get the facility_code and fin_entity value when getting diffrent sites for reports]-Start
			//String userSiteQry = "SELECT US.SITE_CODE, US.PROFILE_ID, S.SITE_TYPE, S.DESCR, S.CITY, S.ENTERPRISE  FROM USER_SITE US, SITE S WHERE S.SITE_CODE = US.SITE_CODE AND US.USER_ID = ? ";
			String userSiteQry = "SELECT US.SITE_CODE, US.PROFILE_ID, S.SITE_TYPE, S.DESCR, S.CITY, S.ENTERPRISE,S.FIN_ENTITY,S.FACILITY_CODE FROM USER_SITE US, SITE S WHERE S.SITE_CODE = US.SITE_CODE AND US.USER_ID = ? ";
			//Changes By Prajyot on 16JULY14 [DB2 Compatibility]Starts
			//String allSiteQry = " SELECT SITE_CODE, SITE_TYPE, DESCR, CITY, ENTERPRISE FROM SITE ";
			String allSiteQry = " SELECT SITE_CODE, SITE_TYPE, DESCR, CITY,FIN_ENTITY,FACILITY_CODE, ENTERPRISE FROM SITE ";
			//Changes made by Pratheek on 05-02-19[to get the facility_code and fin_entity value when getting diffrent sites for reports]-End
			//			pstmt = conn.prepareStatement(userSiteQry, ResultSet.TYPE_SCROLL_SENSITIVE, ResultSet.CONCUR_READ_ONLY );
			//			pstmt.setString(1, userId);
			//			rs = pstmt.executeQuery();
			//			if( usrLevel == 0 && !rs.first() )
			//			{
			//				userSiteQry = " SELECT SITE_CODE, SITE_TYPE, DESCR, CITY FROM SITE ";
			//				pstmt = conn.prepareStatement(userSiteQry, ResultSet.TYPE_SCROLL_SENSITIVE, ResultSet.CONCUR_READ_ONLY );
			//				rs.close();
			//				rs = pstmt.executeQuery();
			//				isProfileId = false;
			//			}
			//			else
			//			{
			//				rs.previous();
			//			}

			/**
			 * If User Level 0 then system should return all sites from SITE
			 * else should return result of USER_SITE and SITE table
			 */
			if( usrLevel == 0 )
			{
				isProfileId = false;
				BaseLogger.log("3", null, null,"allSiteQry [" + allSiteQry + "]");
				pstmt = conn.prepareStatement(allSiteQry);
				rs = pstmt.executeQuery();
			}
			else
			{
				BaseLogger.log("3", null, null,"userSiteQry [" + userSiteQry + "]");
				pstmt = conn.prepareStatement(userSiteQry);
				pstmt.setString(1, userId);
				rs = pstmt.executeQuery();
			}
			//Changes By Prajyot on 16JULY14 [DB2 Compatibility]Ends

			xmlData.append( "<SITES>" );

			while ( rs.next() )
			{
				xmlData.append( "<SITE code='").append( checkNull( rs.getString( "SITE_CODE" ) )).append("' ");
				xmlData.append(" siteType='").append( checkNull( rs.getString( "SITE_TYPE" ))).append("' city='").append( checkNull(rs.getString( "CITY" )) ).append( "' " );
				//added by vishal pathare on 13.4.18 for[site wise enterprise image related changes]
				xmlData.append(" FIN_ENTITY='").append( checkNull( rs.getString( "FIN_ENTITY" ))).append( "' " );
				xmlData.append(" FACILITY_CODE='").append( checkNull( rs.getString( "FACILITY_CODE" ))).append( "' " );
				xmlData.append(" ENTERPRISE='").append( checkNull( rs.getString( "ENTERPRISE" ))).append( "' " );
				if( isProfileId )
				{
					xmlData.append( " profileId='" ).append( checkNull(rs.getString( "PROFILE_ID" )) ).append("'");
				}
				else
				{
					xmlData.append( " profileId='' " );
				}
				xmlData.append("> " ).append("<![CDATA["+ checkNull(rs.getString( "DESCR" ))+"]]> ").append(  "</SITE>" );
			}
			xmlData.append( "</SITES>" );
			xmlData.append("</ROOT>");
		}
		catch (Exception e)
		{
			e.getStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( conn != null )
				{
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		BaseLogger.log("9", null, null," Dnyaneshwra ::  xmlData [= "+xmlData+"]");
		return xmlData.toString();
	}
	//Added by Dnyaneshwar chavan on 15-APR-14 [ Draw the no. of sites ] End

	//Added by Prajyot on 17APR2014[To set USER THEME in USERS table] Start
	public void setUserTheme(String userId, String userTheme, String transDB)throws ITMException, RemoteException
	{
		BaseLogger.log("2", null, null,"In DBAccessEjb");
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		PreparedStatement pstmt = null;
		int result = 0;
		try
		{
			//Changed BY Suraj on 22-Sept-2016 [ To switch interface and change user theme ]Start
			if( "Legacy".equalsIgnoreCase(userTheme) )
			{
				conn = connDriver.getConnectDB(transDB);
				String updateSQL = "UPDATE USERS SET USER_THEME=?, UX_INTERFACE=? WHERE CODE=?";
				pstmt = conn.prepareStatement(updateSQL);
				pstmt.setString(1, "blue");
				pstmt.setString(2, "1");
				pstmt.setString(3, userId);
				result = pstmt.executeUpdate();
				BaseLogger.log("3", null, null,"update userTheme");
			}
			else if( "Galaxy".equalsIgnoreCase(userTheme) )
			{
				conn = connDriver.getConnectDB(transDB);
				String updateSQL = "UPDATE USERS SET USER_THEME=?, UX_INTERFACE=? WHERE CODE=?";
				pstmt = conn.prepareStatement(updateSQL);
				pstmt.setString(1, "galaxy");
				pstmt.setString(2, "2");
				pstmt.setString(3, userId);
				result = pstmt.executeUpdate();
				BaseLogger.log("3", null, null,"update userTheme");
			}
			else
			{
				conn = connDriver.getConnectDB(transDB);
				String updateSQL = "UPDATE USERS SET USER_THEME=? WHERE CODE=?";
				pstmt = conn.prepareStatement(updateSQL);
				pstmt.setString(1, userTheme);
				pstmt.setString(2, userId);
				result = pstmt.executeUpdate();
				BaseLogger.log("3", null, null,"update userTheme");
			}
			//Changed BY Suraj on 22-Sept-2016 [ To switch interface and change user theme ]End

		}
		catch (Exception e)
		{
			e.getStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( conn != null )
				{
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					conn.commit();
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
	}
	//Added by Prajyot on 17APR2014[To set USER THEME in USERS table] End

	//Added by Prajyot On 28MAY2014[Implementing Separation of Duty]Starts
	/**
	 * Checks applicability of SepOfDuty for selected record / transaction by logined user
	 */
	public boolean isSepOfDutyApplicable( String objName, String loginUser, String pkValues, String actionCode, String transDB ) throws Exception
	{
		boolean isApplicable = false;
		try
		{
			//TABLE_NAME,TRAN_ID_COL
			String tableName = "";
			String tranIdCol = "";
			String pkNames = "";

			String sep_duty = getSepOfDutyValue(objName, actionCode, transDB);
			BaseLogger.log("3", null, null,"isSepOfDutyApplicable :: sep_duty[" + sep_duty + "]");
			if( !"0".equals(sep_duty) )
			{
				HashMap objDetMap = getObjDetailMap(objName, transDB);
				if( objDetMap != null )
				{
					tableName = checkNull( (String) objDetMap.get("TABLE_NAME") );
					tranIdCol = checkNull( (String) objDetMap.get("TRAN_ID_COL") );
					pkNames = checkNull( (String) objDetMap.get("TRAN_ID_COL") );
					BaseLogger.log("3", null, null,"isSepOfDutyApplicable :: tableName[" + tableName + "]tranIdCol[" + tranIdCol + "]");
				}
				if( objDetMap == null || tableName.trim().length() == 0 || tranIdCol.trim().length() == 0 )
				{
					BaseLogger.log("3", null, null,"Check transetup values for TRAN_WINDOW :[w_" + objName + "]");
					return isApplicable;
				}

				BaseLogger.log("3", null, null,"isSepOfDutyApplicable :: pkNames[" + pkNames + "] pkValues[" + pkValues + "]");
				String[] pkNamesArr = checkNull( pkNames ).split(":");
				String[] pkValuesArr = checkNull( pkValues ).split(":");

				StringBuffer selQuery = new StringBuffer(" SELECT COUNT(1) AS CNT ");
				selQuery.append(" FROM ").append( tableName );
				selQuery.append(" WHERE ");
				for (int i = 0; i < pkNamesArr.length; i++)
				{
					try
					{
						selQuery.append( pkNamesArr[i] ).append(" = '").append( checkNull( pkValuesArr[i] ) ).append("' ").append(" AND ");
					}
					catch (ArrayIndexOutOfBoundsException outOfBoundsException)
					{
						selQuery.append( pkNamesArr[i] ).append(" = '").append( "" ).append("' ").append(" AND ");
						BaseLogger.log("3", null, null,"No value found for pkNamesArr[i]:["+i+"]["+pkNamesArr[i]+"]");
					}
				}
				if( ! "2".equals(sep_duty) )
				{
					selQuery.append(" TRIM(ADD_USER) = '").append(loginUser).append("' ");
				}

				if( "2".equals(sep_duty) )
				{
					selQuery.append(" ( TRIM(ADD_USER) = '").append(loginUser).append("' ");
					selQuery.append(" OR TRIM(CHG_USER) = '").append(loginUser).append("') ");
				}
				BaseLogger.log("3", null, null,"selQuery[" + selQuery.toString() + "]");
				int result = 0;
				Connection conn = null;
				try
				{
					ConnDriver connDriver = new ConnDriver();
					//Added by Pankaj T on 19-12-17 [changes for multitenancy]
					conn = connDriver.getConnectDB(transDB);
					PreparedStatement pstmt = conn.prepareStatement( selQuery.toString() );
					ResultSet rs = pstmt.executeQuery();
					while( rs.next() )
					{

						result = rs.getInt("CNT");
					}
					BaseLogger.log("3", null, null,"selQuery[" + selQuery.toString() + "] \n result[" + result + "]");
					if( rs != null )
					{
						rs.close();
						rs = null;
					}
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
				}
				catch( SQLException e )
				{
//					BaseLogger.log("3", null, null,"isSepOfDutyApplicable SQLException[" + e.getMessage()+ "]");
					e.printStackTrace();
					throw new ITMException(e);
//					throw e;
				}
				catch( Exception e )
				{
					e.getStackTrace();
					throw e;
				}
				finally
				{
					try
					{
						if( conn != null )
						{
							conn.close();
							conn = null;
						}
					}
					catch(Exception e)
					{
						e.printStackTrace();
						throw e;
					}
				}

				if( result > 0 )
				{
					isApplicable = true;
				}
			}
		}
		catch( Exception e )
		{
			e.getStackTrace();
			throw e;
		}
		return isApplicable;
	}

	/**
	 * returns value of SepOfDuty
	 */
	private String getSepOfDutyValue(String objName, String actionCode, String transDB) throws RemoteException, ITMException
	{
		String colValue = "";
		try
		{
			colValue = getDBColumnValue("OBJ_ACTIONS", "SEP_DUTY_OPT", " OBJ_NAME ='" + objName + "' AND RIGHTS_CHAR = '" + actionCode + "' ", transDB);
			if( Integer.parseInt( checkNull( colValue ) ) > 2 )
			{
				colValue = "0";
			}
		}
		catch(NumberFormatException nfe)
		{
			BaseLogger.log("0", null, null,"NumberFormatException in getSepOfDuty for Integer Value [" + colValue + "]");
			colValue = "0";
		}
		catch (ITMException e)
		{
			BaseLogger.log("0", null, null,"ITMException in getSepOfDuty for...\n");
			colValue = "0";
			e.printStackTrace();
		}
		return colValue;
	}
	//Added by Prajyot On 28MAY2014[Implementing Separation of Duty]Ends

	//Added by Gulzar on 19/09/14 to get the mobile no to send the SMS : START
	/**
	 * Returns Mobile no from Masters like Employee, Customer, Supplier and Sales Person.
	 * The mobile not is used to send the SMS to perticular employee, customer, supplier or sales person
	 */
	public String getMobileNo(String selFieldName, String fromTableName, String whereFieldName, String whereFieldValue)throws RemoteException, ITMException
	{
		BaseLogger.log("2", null, null,"[DBAccessEJB]Getting email address from master table :"+fromTableName+": for "+whereFieldName); //$NON-NLS-1$ //$NON-NLS-2$
		ConnDriver mConnDriver = null;
		Connection mConnection = null;
		PreparedStatement pStmt = null;
		ResultSet mRs = null;
		String mobileNo = null;
		try
		{
			mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("Driver"); //$NON-NLS-1$
			String mQuery = ""; //$NON-NLS-1$
			if(!whereFieldValue.endsWith("$")) //$NON-NLS-1$
			{

				mQuery = "SELECT " + selFieldName + " FROM " + fromTableName + " WHERE " + whereFieldName + " = '" + whereFieldValue + "'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
			}
			else
			{
				String userID = whereFieldValue.substring(0,whereFieldValue.indexOf("$")); //$NON-NLS-1$
				mQuery = "SELECT " + selFieldName + " FROM " + fromTableName + " WHERE " + whereFieldName + " = ( SELECT  ENTITY_CODE  FROM USERS WHERE CODE='" + userID + "')"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
			}
			pStmt = mConnection.prepareStatement(mQuery);
			mRs = pStmt.executeQuery();

			if (mRs.next())
			{
				mobileNo = mRs.getString(1);
			}
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException :DBAccessEJB :mobileNo :\n"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception :DBAccessEJB :mobileNo :\n"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(mRs != null)
					{
						mRs.close();
						mRs = null;
					}
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getMailDetails :\n"+e.getMessage()); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2", null, null,"[DBAccessEJB]Returning Mobile No :"+mobileNo+":"); //$NON-NLS-1$ //$NON-NLS-2$
		return mobileNo;
	}
	//Added by Gulzar on 19/09/14 to get the mobile no to send the SMS : END

	//Added by Gulzar on 19/09/14 to get the SMS Details for supplier format code to send the SMS : START
	/**
	 * Returns ArrayList which contains the SMS details for the supplied format code.
	 * The SMS detail like send_to , SMS header text, SMS Body text and SMS footer text
	 * send_to can contain the value like mobile_no, {(E)EMP_CODE}, [(E)ROLE_CODE]. Multile value can be put separated by comma(,)
	 */
	public ArrayList getSMSDetailList(String formatCode, UserInfoBean userInfo)throws RemoteException, ITMException
	{
		BaseLogger.log("2", null, null,"[DBAccessEJB] :getSMSDetailList() for Format Code :"+formatCode); //$NON-NLS-1$
		ConnDriver mConnDriver = null;
		Connection mConnection = null;
		PreparedStatement pStmt = null;
		ResultSet mRs = null;
		ResultSetMetaData rsmd = null;
		ArrayList smsDetailList = new ArrayList();

		String transDB = "";

		try
		{
			if(userInfo != null)
			{
				transDB = userInfo.getTransDB();
			}

			mConnDriver = new ConnDriver();

			if(transDB != null && transDB.trim().length() > 0 && !"null".equalsIgnoreCase(transDB))
			{
				mConnection = mConnDriver.getConnectDB(transDB); //$NON-NLS-1$
			}

			//Added By Ravindra C on 08-09-21 to define template id for SMS
			String mQuery = "SELECT SEND_TO, SMS_HEADER, SMS_BODY, SMS_FOOTER, SMS_TYPE, MSG_TEMPL FROM SMS_FORMAT WHERE FORMAT_CODE = ? ";
			pStmt = mConnection.prepareStatement(mQuery);
			pStmt.setString(1, formatCode);
			mRs = pStmt.executeQuery();

			if (mRs.next())
			{
				smsDetailList.add(0, mRs.getString("SEND_TO"));
				smsDetailList.add(1, mRs.getString("SMS_HEADER"));
				smsDetailList.add(2, mRs.getString("SMS_BODY"));
				smsDetailList.add(3, mRs.getString("SMS_FOOTER"));
				// Added by Pankaj R on 26-Mar-21 to use defined templates, where sms body will be fetched from template defined.[START]  
				smsDetailList.add(4, mRs.getString("SMS_TYPE"));
				// Added by Pankaj R on 26-Mar-21 to use defined templates, where sms body will be fetched from template defined.[END]

				//Added By Ravindra C on 08-09-21 to define template id for SMS
				smsDetailList.add(5, mRs.getString("MSG_TEMPL"));
			}
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException :DBAccessEJB :getSMSDetails :\n"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception :DBAccessEJB :getSMSDetails :\n"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(mRs != null)
					{
						mRs.close();
						mRs = null;
					}
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getSMSDetails :\n"+e.getMessage()); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		return smsDetailList;
	}
	//Added by Gulzar on 19/09/14 to get the SMS Details for supplier format code to send the SMS : END

	/**
	 * This method is used to get the service_code value which is equvalent to event_code of system_events
	 * for user defined actions (service_handler 2)
	 * @param objName
	 * @param actionCode
	 * @param actionTitle
	 * @param userInfo
	 * @return
	 * @throws Exception
	 */
	public String getEventCodeForObject(String objName, String actionCode, String actionTitle, UserInfoBean userInfo) throws Exception
	{
		Connection conn = null;
		String eventCode = "";
		String transDB = "";
		ResultSet rsEvent = null;
		PreparedStatement pstmtEvent = null;
		String eventSql = "";
		try
		{
			ConnDriver connDriver = new ConnDriver();
			if(userInfo != null)
			{
				transDB = userInfo.getTransDB();
			}
			if (transDB != null && transDB.trim().length() > 0 && !"null".equalsIgnoreCase(transDB))
			{
				conn = connDriver.getConnectDB(transDB);
			}

			if(actionCode == null || actionCode.trim().length() == 0)
			{
				actionCode = actionTitle;
				eventSql = "SELECT SERVICE_CODE FROM OBJ_ACTIONS WHERE OBJ_NAME = ? AND TITLE = ?";
			}
			else
			{
				eventSql = "SELECT SERVICE_CODE FROM OBJ_ACTIONS WHERE OBJ_NAME = ? AND RIGHTS_CHAR = ?";
			}

			pstmtEvent = conn.prepareStatement(eventSql);
			pstmtEvent.setString(1, objName);
			pstmtEvent.setString(2, actionCode);

			rsEvent = pstmtEvent.executeQuery();

			if(rsEvent.next())
			{
				eventCode = rsEvent.getString("SERVICE_CODE");
			}

			BaseLogger.log("3", null, null,"eventCode =["+eventCode+"]");
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw e;
		}
		finally
		{
			try
			{
				if(rsEvent != null)
				{
					rsEvent.close();
					rsEvent = null;
				}
				if(pstmtEvent != null)
				{
					pstmtEvent.close();
					pstmtEvent = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e1)
			{
			}
		}
		return eventCode;
	}

	//Added by Prajyot on 11/DEC/14 [Add tag in XML to get account period] start
	private String getAcctPrdXML(String transDB)throws  RemoteException,ITMException
	{
		ConnDriver mConnDriver = null;
		Connection mConnection = null;
		//Statement mStmt = null;
		PreparedStatement pstmt = null;
		ResultSet mRs = null;
		StringBuilder acctPrdXML = new StringBuilder();
		String  mQuery = null;
		try
		{
			mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB(transDB);

			//			Changed by Reema on 31-mar-15 [trunc date from sysdate]-start
			//			mQuery = "SELECT FR_DATE, TO_DATE FROM ACCTPRD WHERE FR_DATE  <= SYSDATE AND TO_DATE >= SYSDATE";

			//Changes made by Gulzar on 21/08/15 for MSSQL : START
			//mQuery = "SELECT FR_DATE, TO_DATE FROM ACCTPRD WHERE FR_DATE  <= TRUNC(SYSDATE) AND TO_DATE >= TRUNC(SYSDATE)";
			//mStmt = mConnection.createStatement();
			//mRs = mStmt.executeQuery(mQuery);

			E12GenericUtility genericUtility = new E12GenericUtility();
			DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDate = dtFormat.format( Calendar.getInstance().getTime() );
			currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ;
			mQuery = "SELECT FR_DATE, TO_DATE FROM ACCTPRD WHERE FR_DATE  <= ? AND TO_DATE >= ?";

			pstmt = mConnection.prepareStatement(mQuery);
			pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(currDate));
			pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(currDate));
			mRs = pstmt.executeQuery();

			//Changes made by Gulzar on 21/08/15 for MSSQL : END
			//Changed by Reema on 31-mar-15 [trunc date from sysdate]-end

			acctPrdXML.append("<ACCT_PRD>");
			while(mRs.next())
			{
				//Changed By Pankaj T. on 26-07-2021 - for using getString() method getting date column value in different formats due to this parsing error occurred. - start
				//acctPrdXML.append( "<FR_DATE><![CDATA[").append( mRs.getString("FR_DATE") ).append( "]]></FR_DATE>" );
				//acctPrdXML.append( "<TO_DATE><![CDATA[").append( mRs.getString("TO_DATE") ).append( "]]></TO_DATE>" );
				Date frDate = mRs.getDate("FR_DATE");
				Date todate = mRs.getDate("TO_DATE");
				String fromDate = genericUtility.getValidDateString(frDate, CommonConstants.DB_DATE_FORMAT);
				String toDate = genericUtility.getValidDateString(todate, CommonConstants.DB_DATE_FORMAT);
				acctPrdXML.append( "<FR_DATE><![CDATA[").append( fromDate ).append( "]]></FR_DATE>" );
				acctPrdXML.append( "<TO_DATE><![CDATA[").append( toDate ).append( "]]></TO_DATE>" );
				//Changed By Pankaj T. on 26-07-2021 - for using getString() method getting date column value in different formats due to this parsing error occurred. - end
			}
			acctPrdXML.append("</ACCT_PRD>");
			mRs.close();
			mRs = null;
			pstmt.close();
			pstmt = null;
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException: DBAccessEJB: getAcctPrdXML:");
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccessEJB: getAcctPrdXML:"  + e);
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(mRs != null)
					{
						mRs.close();
						mRs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccessEJB: getAcctPrdXML \n" + e);
				throw new ITMException(e);
			}
		}
		return acctPrdXML.toString();
	}
	//Added by Prajyot on 11/DEC/14 [Add tag in XML to get account period] end
	// Added by Prajyot On 25-DEC-2014 [S14GSUN005- Galaxy Portal : New theme implementation in web interface - Galaxy Theme] Start
	@Override
	//Changed By Pankaj T. on 25-09-18 for resolved issue of application not display for multiple profile
	public String getApplicationInfo(String userID, String userLevel, String transDB, String profileId) throws RemoteException, ITMException
	{
		Connection mConnection = null;
		Statement stmt = null;
		String selectQuery=null;
		//StringBuffer applXmlString = new StringBuffer("<APPL_MST>");
		StringBuffer applXmlString = new StringBuffer("");
		ResultSet rs = null;
		BaseLogger.log("2", null, null,"User level : "+ userLevel);
		try
		{
			String applGroup = "";
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB(transDB);
			//Added By Pankaj T. on 18-04-18 for user wise application caching - start
			BaseLogger.log("3", null, null,"CACHE_OPT in getApplicationInfo:["+CommonConstants.CACHE_OPT+"]");
			BaseLogger.log("3", null, null,"profileId in getApplicationInfo before formating:["+profileId+"]");
			String actualProfileId = profileId;
			profileId = E12GenericUtility.getFormattedProfileId(profileId);
			BaseLogger.log("3", null, null,"profileId in getApplicationInfo after formating:["+profileId+"]");
			//added by vishal pathare on 31.7.18 for[application user licence type wise application should display]Start
			String userLicType = getUserLicenceType( userID );
			BaseLogger.log("3", null, null,"userLicType["+userLicType+"]");
			String applType = "";
			boolean isLicType = false;
			if( E12GenericUtility.checkNull( userLicType ).length() > 0 )
			{
				isLicType = true;
				if( userLicType.equalsIgnoreCase("E") )
				{
					applType = E12GenericUtility.getFormattedProfileId("E,S");
				}
				else
				{
					applType = E12GenericUtility.getFormattedProfileId( userLicType );
				}
			}
			BaseLogger.log("3", null, null,"applType122["+applType+"]");
			//added by vishal pathare on 31.7.18 for[application user licence type wise application should display]End
			if( CommonConstants.CACHE_OPT != 0 )
			{
				//Added By Pankaj T. on 05-03-2020 As suggested By SM Sir to get the profile_id from user_site table and if not found then get from users table: START
				String applnStorageKey = userID+"_"+userLevel+"_"+transDB+"_"+actualProfileId;
				//Added By Pankaj T. on 05-03-2020 As suggested By SM Sir to get the profile_id from user_site table and if not found then get from users table: End
				BaseLogger.log("3", null, null,"applnStorageKey:["+applnStorageKey+"]");
				//Changed by Prasad on 23/11/2020 [check infinispanLocalObj not null]
				if( infinispanLocalObj != null && infinispanLocalObj.contains( applnStorageKey) )
				{
					applXmlString.append(infinispanLocalObj.getFormData(applnStorageKey));
				}
				else
				{
					applXmlString.append("<APPL_MST>");
					if(userLevel != null && userLevel.equalsIgnoreCase("0"))
					{
						//Changed by Reema on 30-mar-15 [set order for applications]
						//				selectQuery = "SELECT DISTINCT B.APP_NAME, B.DESCR, B.APPL_GROUP, B.APPL_COLOR FROM USER_RIGHTS A RIGHT OUTER JOIN APPL_MST B ON B.APP_NAME = A.APPLICATION ORDER BY B.APPL_GROUP";
						//Changes made by Gulzar 21/08/15 - included ABS(B.APPL_ORDER) in select clause to work in MSSQL in case of DISTINCT : START
						//selectQuery = "SELECT DISTINCT B.APP_NAME, B.DESCR, B.APPL_GROUP, B.APPL_COLOR, B.APPL_ORDER FROM USER_RIGHTS A RIGHT OUTER JOIN APPL_MST B ON B.APP_NAME = A.APPLICATION ORDER BY ABS(B.APPL_ORDER),B.APPL_GROUP";
						//Changed by PRATHAMESH JANGAM FOR DB2 ISSUE to make db2 compatible
						if("DB2".equalsIgnoreCase(CommonConstants.DB_NAME))
						{
							//changed by vishal pathare on 31.7.18 for[application user licence type wise application should display]
							if( isLicType )
							{
								selectQuery = "SELECT DISTINCT B.App_Name,B.Descr,B.Appl_Group,B.Appl_Color, B.Appl_Order, ABS(cast(B.Appl_Order as integer)) New_Appl_Order, B.Conn_Option, B.SEARCH_DOMAIN FROM User_Rights A RIGHT OUTER JOIN Appl_Mst B On B.App_Name = A.Application where b.appl_type in "+applType+" Order By New_Appl_Order,B.Appl_Group";
							}
							else
							{
								selectQuery = "SELECT DISTINCT B.App_Name,B.Descr,B.Appl_Group,B.Appl_Color, B.Appl_Order, ABS(cast(B.Appl_Order as integer)) New_Appl_Order, B.Conn_Option, B.SEARCH_DOMAIN FROM User_Rights A RIGHT OUTER JOIN Appl_Mst B On B.App_Name = A.Application Order By New_Appl_Order,B.Appl_Group";
							}
						}
						else
						{
							//changed by vishal pathare on 31.7.18 for[application user licence type wise application should display]
							if( isLicType )
							{
								selectQuery = "SELECT DISTINCT B.APP_NAME, B.DESCR, B.APPL_GROUP, B.APPL_COLOR, B.APPL_ORDER, ABS(B.APPL_ORDER), B.CONN_OPTION, B.SEARCH_DOMAIN FROM USER_RIGHTS A RIGHT OUTER JOIN APPL_MST B ON B.APP_NAME = A.APPLICATION where b.appl_type in "+applType+" ORDER BY ABS(B.APPL_ORDER),B.APPL_GROUP";
							}
							else
							{
								selectQuery = "SELECT DISTINCT B.APP_NAME, B.DESCR, B.APPL_GROUP, B.APPL_COLOR, B.APPL_ORDER, ABS(B.APPL_ORDER), B.CONN_OPTION, B.SEARCH_DOMAIN FROM USER_RIGHTS A RIGHT OUTER JOIN APPL_MST B ON B.APP_NAME = A.APPLICATION ORDER BY ABS(B.APPL_ORDER),B.APPL_GROUP";
							}
						}
						//Changes made by Gulzar - included ABS(B.APPL_ORDER) in select clause to work in MSSQL in case of DISTINCT : END
					}
					else
					{
						//Changed by Reema on 30-mar-15 [set order for applications]
						//				selectQuery = "SELECT DISTINCT C.APP_NAME, C.DESCR, C.APPL_GROUP, C.APPL_COLOR FROM USER_RIGHTS A , USERS B, APPL_MST C WHERE A.PROFILE_ID = B.PROFILE_ID AND A.APPLICATION = C.APP_NAME AND B.CODE='" + userID + "' ORDER BY C.APPL_GROUP";
						//Changes made by Gulzar 21/08/15 - included ABS(B.APPL_ORDER) in select clause to work in MSSQL in case of DISTINCT : START
						//selectQuery = "SELECT DISTINCT C.APP_NAME, C.DESCR, C.APPL_GROUP, C.APPL_COLOR, C.APPL_ORDER FROM USER_RIGHTS A , USERS B, APPL_MST C WHERE A.PROFILE_ID = B.PROFILE_ID AND A.APPLICATION = C.APP_NAME AND B.CODE='" + userID + "' ORDER BY ABS(C.APPL_ORDER),C.APPL_GROUP";
						//Changed by Prajyot[Bug Fixing - Alias Name]
						//selectQuery = "SELECT DISTINCT C.APP_NAME, C.DESCR, C.APPL_GROUP, C.APPL_COLOR, C.APPL_ORDER, ABS(B.APPL_ORDER) FROM USER_RIGHTS A , USERS B, APPL_MST C WHERE A.PROFILE_ID = B.PROFILE_ID AND A.APPLICATION = C.APP_NAME AND B.CODE='" + userID + "' ORDER BY ABS(C.APPL_ORDER),C.APPL_GROUP";
						//Changed by PRATHAMESH JANGAM FOR DB2 ISSUE to make db2 compatible
						if("DB2".equalsIgnoreCase(CommonConstants.DB_NAME))
						{
							//changed by vishal pathare on 31.7.18 for[application user licence type wise application should display]
							if( isLicType )
							{
								//Changed By Pankaj T. on 25-09-18 for resolved issue of application not display for multiple profile
								//selectQuery = "SELECT DISTINCT C.APP_NAME, C.DESCR, C.APPL_GROUP, C.APPL_COLOR, C.APPL_ORDER, ABS(cast(C.APPL_ORDER AS INTEGER)) New_Appl_Order, C.CONN_OPTION FROM USER_RIGHTS A , USERS B, APPL_MST C WHERE A.PROFILE_ID = B.PROFILE_ID AND A.APPLICATION = C.APP_NAME AND B.CODE='" + userID + "' and c.appl_type in "+applType+" ORDER BY New_Appl_Order,C.APPL_GROUP";
								selectQuery = "SELECT DISTINCT C.APP_NAME, C.DESCR, C.APPL_GROUP, C.APPL_COLOR, C.APPL_ORDER, ABS(cast(C.APPL_ORDER AS INTEGER)) New_Appl_Order, C.CONN_OPTION, C.SEARCH_DOMAIN FROM USER_RIGHTS A , USERS B, APPL_MST C WHERE A.PROFILE_ID IN "+profileId+" AND A.APPLICATION = C.APP_NAME AND B.CODE='" + userID + "' and c.appl_type in "+applType+" ORDER BY New_Appl_Order,C.APPL_GROUP";
							}
							else
							{
								//Changed By Pankaj T. on 25-09-18 for resolved issue of application not display for multiple profile
								//selectQuery = "SELECT DISTINCT C.APP_NAME, C.DESCR, C.APPL_GROUP, C.APPL_COLOR, C.APPL_ORDER, ABS(cast(C.APPL_ORDER AS INTEGER)) New_Appl_Order, C.CONN_OPTION FROM USER_RIGHTS A , USERS B, APPL_MST C WHERE A.PROFILE_ID = B.PROFILE_ID AND A.APPLICATION = C.APP_NAME AND B.CODE='" + userID + "' ORDER BY New_Appl_Order,C.APPL_GROUP";
								selectQuery = "SELECT DISTINCT C.APP_NAME, C.DESCR, C.APPL_GROUP, C.APPL_COLOR, C.APPL_ORDER, ABS(cast(C.APPL_ORDER AS INTEGER)) New_Appl_Order, C.CONN_OPTION, C.SEARCH_DOMAIN FROM USER_RIGHTS A , USERS B, APPL_MST C WHERE A.PROFILE_ID IN"+profileId+" AND A.APPLICATION = C.APP_NAME AND B.CODE='" + userID + "' ORDER BY New_Appl_Order,C.APPL_GROUP";
							}

						}
						else
						{
							//changed by vishal pathare on 31.7.18 for[application user licence type wise application should display]
							if( isLicType )
							{
								//Changed By Pankaj T. on 25-09-18 for resolved issue of application not display for multiple profile
								//selectQuery = "SELECT DISTINCT C.APP_NAME, C.DESCR, C.APPL_GROUP, C.APPL_COLOR, C.APPL_ORDER, ABS(C.APPL_ORDER), C.CONN_OPTION FROM USER_RIGHTS A , USERS B, APPL_MST C WHERE A.PROFILE_ID = B.PROFILE_ID AND A.APPLICATION = C.APP_NAME AND B.CODE='" + userID + "' and c.appl_type in "+applType+" ORDER BY ABS(C.APPL_ORDER),C.APPL_GROUP";
								selectQuery = "SELECT DISTINCT C.APP_NAME, C.DESCR, C.APPL_GROUP, C.APPL_COLOR, C.APPL_ORDER, ABS(C.APPL_ORDER), C.CONN_OPTION, C.SEARCH_DOMAIN FROM USER_RIGHTS A , USERS B, APPL_MST C WHERE A.PROFILE_ID IN "+profileId+" AND A.APPLICATION = C.APP_NAME AND B.CODE='" + userID + "' and c.appl_type in "+applType+" ORDER BY ABS(C.APPL_ORDER),C.APPL_GROUP";
							}
							else
							{
								//Changed By Pankaj T. on 25-09-18 for resolved issue of application not display for multiple profile
								//selectQuery = "SELECT DISTINCT C.APP_NAME, C.DESCR, C.APPL_GROUP, C.APPL_COLOR, C.APPL_ORDER, ABS(C.APPL_ORDER), C.CONN_OPTION FROM USER_RIGHTS A , USERS B, APPL_MST C WHERE A.PROFILE_ID = B.PROFILE_ID AND A.APPLICATION = C.APP_NAME AND B.CODE='" + userID + "' ORDER BY ABS(C.APPL_ORDER),C.APPL_GROUP";
								selectQuery = "SELECT DISTINCT C.APP_NAME, C.DESCR, C.APPL_GROUP, C.APPL_COLOR, C.APPL_ORDER, ABS(C.APPL_ORDER), C.CONN_OPTION, C.SEARCH_DOMAIN FROM USER_RIGHTS A , USERS B, APPL_MST C WHERE A.PROFILE_ID IN "+profileId+" AND A.APPLICATION = C.APP_NAME AND B.CODE='" + userID + "' ORDER BY ABS(C.APPL_ORDER),C.APPL_GROUP";
							}
						}
						//Changes made by Gulzar - included ABS(B.APPL_ORDER) in select clause to work in MSSQL in case of DISTINCT : END
					}
					BaseLogger.log("3", null, null,"my query:: " + selectQuery);
					stmt = mConnection.createStatement();
					rs = stmt.executeQuery(selectQuery);

					while(rs.next())
					{
						//ADDED CHECKNULL TO GET DATA FOR db2- PRATHAMESH JANGAM ON 22JUN17
						String applGroupDB = checkNull(rs.getString("APPL_GROUP"));
						if( ! applGroupDB.equalsIgnoreCase( applGroup ) )
						{
							if( ! "".equalsIgnoreCase( applGroup ) )
							{
								applXmlString.append("</APPL_GROUP>");
							}
							applGroup = applGroupDB;
							applXmlString.append("<APPL_GROUP name='").append( applGroup ).append("'>");
						}
						applXmlString.append("<APPL_DETAIL>");
						applXmlString.append("<APP_NAME>").append("<![CDATA[").append( rs.getString("APP_NAME") ).append("]]>").append("</APP_NAME>");
						applXmlString.append("<DESCR>").append("<![CDATA[").append( rs.getString("DESCR") ).append("]]>").append("</DESCR>");
						applXmlString.append("<APPL_COLOR>").append("<![CDATA[").append( rs.getString("APPL_COLOR") ).append("]]>").append("</APPL_COLOR>");
						applXmlString.append("<CONN_OPTION>").append("<![CDATA[").append( rs.getString("CONN_OPTION") ).append("]]>").append("</CONN_OPTION>");
						applXmlString.append("<SEARCH_DOMAIN>").append("<![CDATA[").append( rs.getString("SEARCH_DOMAIN") ).append("]]>").append("</SEARCH_DOMAIN>");		//Added by Sagar B. for SOLR related changes[16-May-19]
						applXmlString.append("</APPL_DETAIL>");
					}
					if( (applXmlString.toString().indexOf("<APPL_GROUP") != -1) && (!applXmlString.toString().endsWith("</APPL_GROUP>")) )
					{
						applXmlString.append("</APPL_GROUP>");
					}
					if(rs!=null)
					{
						rs.close();
						rs =null;
					}
					applXmlString.append("</APPL_MST>");
					//Changed by Prasad on 23/11/2020 [check infinispanLocalObj not null]
					if ( infinispanLocalObj != null )
					{
						infinispanLocalObj.putFormData(applnStorageKey, applXmlString.toString());
					}
				}
			}
			else
			{
				applXmlString.append("<APPL_MST>");
				if(userLevel != null && userLevel.equalsIgnoreCase("0"))
				{
					//Changed by Reema on 30-mar-15 [set order for applications]
					//				selectQuery = "SELECT DISTINCT B.APP_NAME, B.DESCR, B.APPL_GROUP, B.APPL_COLOR FROM USER_RIGHTS A RIGHT OUTER JOIN APPL_MST B ON B.APP_NAME = A.APPLICATION ORDER BY B.APPL_GROUP";
					//Changes made by Gulzar 21/08/15 - included ABS(B.APPL_ORDER) in select clause to work in MSSQL in case of DISTINCT : START
					//selectQuery = "SELECT DISTINCT B.APP_NAME, B.DESCR, B.APPL_GROUP, B.APPL_COLOR, B.APPL_ORDER FROM USER_RIGHTS A RIGHT OUTER JOIN APPL_MST B ON B.APP_NAME = A.APPLICATION ORDER BY ABS(B.APPL_ORDER),B.APPL_GROUP";
					//Changed by PRATHAMESH JANGAM FOR DB2 ISSUE to make db2 compatible
					if("DB2".equalsIgnoreCase(CommonConstants.DB_NAME))
					{
						//changed by vishal pathare on 31.7.18 for[application user licence type wise application should display]
						if( isLicType )
						{
							selectQuery = "SELECT DISTINCT B.App_Name,B.Descr,B.Appl_Group,B.Appl_Color, B.Appl_Order, ABS(cast(B.Appl_Order as integer)) New_Appl_Order, B.Conn_Option, B.SEARCH_DOMAIN FROM User_Rights A RIGHT OUTER JOIN Appl_Mst B On B.App_Name = A.Application where b.appl_type in "+applType+" Order By New_Appl_Order,B.Appl_Group";
						}
						else
						{
							selectQuery = "SELECT DISTINCT B.App_Name,B.Descr,B.Appl_Group,B.Appl_Color, B.Appl_Order, ABS(cast(B.Appl_Order as integer)) New_Appl_Order, B.Conn_Option, B.SEARCH_DOMAIN FROM User_Rights A RIGHT OUTER JOIN Appl_Mst B On B.App_Name = A.Application Order By New_Appl_Order,B.Appl_Group";
						}

					}
					else
					{
						//changed by vishal pathare on 31.7.18 for[application user licence type wise application should display]
						if( isLicType )
						{
							selectQuery = "= SELECT DISTINCT B.APP_NAME, B.DESCR, B.APPL_GROUP, B.APPL_COLOR, B.APPL_ORDER, ABS(B.APPL_ORDER), B.CONN_OPTION, B.SEARCH_DOMAIN FROM USER_RIGHTS A RIGHT OUTER JOIN APPL_MST B ON B.APP_NAME = A.APPLICATION where b.appl_type in "+applType+" ORDER BY ABS(B.APPL_ORDER),B.APPL_GROUP";
						}
						else
						{
							selectQuery = "SELECT DISTINCT B.APP_NAME, B.DESCR, B.APPL_GROUP, B.APPL_COLOR, B.APPL_ORDER, ABS(B.APPL_ORDER), B.CONN_OPTION, B.SEARCH_DOMAIN FROM USER_RIGHTS A RIGHT OUTER JOIN APPL_MST B ON B.APP_NAME = A.APPLICATION ORDER BY ABS(B.APPL_ORDER),B.APPL_GROUP";
						}
					}
					//Changes made by Gulzar - included ABS(B.APPL_ORDER) in select clause to work in MSSQL in case of DISTINCT : END
				}
				else
				{
					//Changed by Reema on 30-mar-15 [set order for applications]
					//				selectQuery = "SELECT DISTINCT C.APP_NAME, C.DESCR, C.APPL_GROUP, C.APPL_COLOR FROM USER_RIGHTS A , USERS B, APPL_MST C WHERE A.PROFILE_ID = B.PROFILE_ID AND A.APPLICATION = C.APP_NAME AND B.CODE='" + userID + "' ORDER BY C.APPL_GROUP";
					//Changes made by Gulzar 21/08/15 - included ABS(B.APPL_ORDER) in select clause to work in MSSQL in case of DISTINCT : START
					//selectQuery = "SELECT DISTINCT C.APP_NAME, C.DESCR, C.APPL_GROUP, C.APPL_COLOR, C.APPL_ORDER FROM USER_RIGHTS A , USERS B, APPL_MST C WHERE A.PROFILE_ID = B.PROFILE_ID AND A.APPLICATION = C.APP_NAME AND B.CODE='" + userID + "' ORDER BY ABS(C.APPL_ORDER),C.APPL_GROUP";
					//Changed by Prajyot[Bug Fixing - Alias Name]
					//selectQuery = "SELECT DISTINCT C.APP_NAME, C.DESCR, C.APPL_GROUP, C.APPL_COLOR, C.APPL_ORDER, ABS(B.APPL_ORDER) FROM USER_RIGHTS A , USERS B, APPL_MST C WHERE A.PROFILE_ID = B.PROFILE_ID AND A.APPLICATION = C.APP_NAME AND B.CODE='" + userID + "' ORDER BY ABS(C.APPL_ORDER),C.APPL_GROUP";
					//Changed by PRATHAMESH JANGAM FOR DB2 ISSUE to make db2 compatible
					if("DB2".equalsIgnoreCase(CommonConstants.DB_NAME))
					{
						//changed by vishal pathare on 31.7.18 for[application user licence type wise application should display]
						if( isLicType )
						{
							//Changed By Pankaj T. on 25-09-18 for resolved issue of application not display for multiple profile
							//selectQuery = "SELECT DISTINCT C.APP_NAME, C.DESCR, C.APPL_GROUP, C.APPL_COLOR, C.APPL_ORDER, ABS(cast(C.APPL_ORDER AS INTEGER)) New_Appl_Order, C.CONN_OPTION FROM USER_RIGHTS A , USERS B, APPL_MST C WHERE A.PROFILE_ID = B.PROFILE_ID AND A.APPLICATION = C.APP_NAME AND B.CODE='" + userID + "' and c.appl_type in "+applType+" ORDER BY New_Appl_Order,C.APPL_GROUP";
							selectQuery = "SELECT DISTINCT C.APP_NAME, C.DESCR, C.APPL_GROUP, C.APPL_COLOR, C.APPL_ORDER, ABS(cast(C.APPL_ORDER AS INTEGER)) New_Appl_Order, C.CONN_OPTION, C.SEARCH_DOMAIN FROM USER_RIGHTS A , USERS B, APPL_MST C WHERE A.PROFILE_ID IN "+profileId+" AND A.APPLICATION = C.APP_NAME AND B.CODE='" + userID + "' and c.appl_type in "+applType+" ORDER BY New_Appl_Order,C.APPL_GROUP";
						}
						else
						{
							//Changed By Pankaj T. on 25-09-18 for resolved issue of application not display for multiple profile
							//selectQuery = "SELECT DISTINCT C.APP_NAME, C.DESCR, C.APPL_GROUP, C.APPL_COLOR, C.APPL_ORDER, ABS(cast(C.APPL_ORDER AS INTEGER)) New_Appl_Order, C.CONN_OPTION FROM USER_RIGHTS A , USERS B, APPL_MST C WHERE A.PROFILE_ID = B.PROFILE_ID AND A.APPLICATION = C.APP_NAME AND B.CODE='" + userID + "' ORDER BY New_Appl_Order,C.APPL_GROUP";
							selectQuery = "SELECT DISTINCT C.APP_NAME, C.DESCR, C.APPL_GROUP, C.APPL_COLOR, C.APPL_ORDER, ABS(cast(C.APPL_ORDER AS INTEGER)) New_Appl_Order, C.CONN_OPTION, C.SEARCH_DOMAIN FROM USER_RIGHTS A , USERS B, APPL_MST C WHERE A.PROFILE_ID IN"+profileId+" AND A.APPLICATION = C.APP_NAME AND B.CODE='" + userID + "' ORDER BY New_Appl_Order,C.APPL_GROUP";
						}
					}
					else
					{
						//changed by vishal pathare on 31.7.18 for[application user licence type wise application should display]
						if( isLicType )
						{
							//Changed By Pankaj T. on 25-09-18 for resolved issue of application not display for multiple profile
							//selectQuery = "SELECT DISTINCT C.APP_NAME, C.DESCR, C.APPL_GROUP, C.APPL_COLOR, C.APPL_ORDER, ABS(C.APPL_ORDER), C.CONN_OPTION FROM USER_RIGHTS A , USERS B, APPL_MST C WHERE A.PROFILE_ID = B.PROFILE_ID AND A.APPLICATION = C.APP_NAME AND B.CODE='" + userID + "' and c.appl_type in "+applType+" ORDER BY ABS(C.APPL_ORDER),C.APPL_GROUP";
							selectQuery = "SELECT DISTINCT C.APP_NAME, C.DESCR, C.APPL_GROUP, C.APPL_COLOR, C.APPL_ORDER, ABS(C.APPL_ORDER), C.CONN_OPTION, C.SEARCH_DOMAIN FROM USER_RIGHTS A , USERS B, APPL_MST C WHERE A.PROFILE_ID IN "+profileId+" AND A.APPLICATION = C.APP_NAME AND B.CODE='" + userID + "' and c.appl_type in "+applType+" ORDER BY ABS(C.APPL_ORDER),C.APPL_GROUP";
						}
						else
						{
							//Changed By Pankaj T. on 25-09-18 for resolved issue of application not display for multiple profile
							//selectQuery = "SELECT DISTINCT C.APP_NAME, C.DESCR, C.APPL_GROUP, C.APPL_COLOR, C.APPL_ORDER, ABS(C.APPL_ORDER), C.CONN_OPTION FROM USER_RIGHTS A , USERS B, APPL_MST C WHERE A.PROFILE_ID = B.PROFILE_ID AND A.APPLICATION = C.APP_NAME AND B.CODE='" + userID + "' ORDER BY ABS(C.APPL_ORDER),C.APPL_GROUP";
							selectQuery = "SELECT DISTINCT C.APP_NAME, C.DESCR, C.APPL_GROUP, C.APPL_COLOR, C.APPL_ORDER, ABS(C.APPL_ORDER), C.CONN_OPTION, C.SEARCH_DOMAIN FROM USER_RIGHTS A , USERS B, APPL_MST C WHERE A.PROFILE_ID IN "+profileId+" AND A.APPLICATION = C.APP_NAME AND B.CODE='" + userID + "' ORDER BY ABS(C.APPL_ORDER),C.APPL_GROUP";
						}
					}
					//Changes made by Gulzar - included ABS(B.APPL_ORDER) in select clause to work in MSSQL in case of DISTINCT : END
				}
				BaseLogger.log("3", null, null,"my query:: " + selectQuery);
				stmt = mConnection.createStatement();
				rs = stmt.executeQuery(selectQuery);

				while(rs.next())
				{
					//ADDED CHECKNULL TO GET DATA FOR db2- PRATHAMESH JANGAM ON 22JUN17
					String applGroupDB = checkNull(rs.getString("APPL_GROUP"));
					if( ! applGroupDB.equalsIgnoreCase( applGroup ) )
					{
						if( ! "".equalsIgnoreCase( applGroup ) )
						{
							applXmlString.append("</APPL_GROUP>");
						}
						applGroup = applGroupDB;
						applXmlString.append("<APPL_GROUP name='").append( applGroup ).append("'>");
					}
					applXmlString.append("<APPL_DETAIL>");
					applXmlString.append("<APP_NAME>").append("<![CDATA[").append( rs.getString("APP_NAME") ).append("]]>").append("</APP_NAME>");
					applXmlString.append("<DESCR>").append("<![CDATA[").append( rs.getString("DESCR") ).append("]]>").append("</DESCR>");
					applXmlString.append("<APPL_COLOR>").append("<![CDATA[").append( rs.getString("APPL_COLOR") ).append("]]>").append("</APPL_COLOR>");
					applXmlString.append("<CONN_OPTION>").append("<![CDATA[").append( rs.getString("CONN_OPTION") ).append("]]>").append("</CONN_OPTION>");
					applXmlString.append("<SEARCH_DOMAIN>").append("<![CDATA[").append( rs.getString("SEARCH_DOMAIN") ).append("]]>").append("</SEARCH_DOMAIN>");		//Added by Sagar B. for SOLR related changes[16-May-19]
					applXmlString.append("</APPL_DETAIL>");
				}
				if( (applXmlString.toString().indexOf("<APPL_GROUP") != -1) && (!applXmlString.toString().endsWith("</APPL_GROUP>")) )
				{
					applXmlString.append("</APPL_GROUP>");
				}
				if(rs!=null)
				{
					rs.close();
					rs =null;
				}
				applXmlString.append("</APPL_MST>");
			}
			//Added By Pankaj T. on 18-04-18 for user wise application caching - end
		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null,"Exception :DBAccessEJB :Applications :==>" + e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getApplications :\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2", null, null,"[DBAccessEJB]Return Application Info :["+ applXmlString+"]");
		return applXmlString.toString();
	}
	// Added by Prajyot On 25-DEC-2014 [S14GSUN005- Galaxy Portal : New theme implementation in web interface - Galaxy Theme]Ends

	//Added by Prasad on 24/02/15 [WS3DSUN004 - Change Rights for Delete Attachment] Start
	/**
	 * To Verify the current Transaction is confirmed or not
	 * @param objName
	 * @param pkValues
	 * @return isConfirmed
	 * @throws ITMException
	 */
	//Changes by Prajyot on 29APR2015 [To revised Delete Attachment Rights based.]Starts
	//private boolean isAttachmentAllow(String objName, String pkValues) throws ITMException
	//TODO :By Prajyot on 11-Aug-2015 [Need to check confirm status at the time of Field Level Attachment]
	private boolean isConfirmed(String objName, String pkValues, String transDB, UserInfoBean userInfo) throws ITMException
	{
		boolean isConfirmed = false;
		Connection mConn = null;
		PreparedStatement pStamt = null;
		ResultSet rs = null;
		try
		{
			HashMap objDetailMap = getObjDetailMap(objName, transDB);

			String colName = (String)objDetailMap.get( "CONFIRM_COL" );
			String cofColVal = (String)objDetailMap.get( "CONFIRM_VAL" );
			String tranIdCol = (String)objDetailMap.get( "TRAN_ID_COL" );
			String tableName = (String)objDetailMap.get( "TABLE_NAME" );

			//Commented as Currently implemented logic for PROFILE level Attachment Confirmation.
			// TODO: If required object / transaction level Attachment Confirmation.
			//String attachAllow = (String)objDetailMap.get( "ALLOW_ATTACH" );
			//if ( (! "1".equalsIgnoreCase(attachAllow ) ) || cofColVal == null || colName == null || tranIdCol == null || tableName == null )
			if ( cofColVal == null || colName == null || tranIdCol == null || tableName == null )
			{
				BaseLogger.log("3", null, null,"Warning : Confirmation logic not defined ... Check TRANSETUP table for below columns :");
				BaseLogger.log("3", null, null,"Check for CONFIRM_COL, CONFIRM_VAL, TRAN_ID_COL, TABLE_NAME");
				// As Confirmation logic not defined will treat as transaction is Unconfirmed
				// and return false;
				return false;
			}
			String COLUMN_SEPARATOR = ":";
			if( pkValues != null && pkValues.indexOf("~") != -1 )
			{
				COLUMN_SEPARATOR = "~";
			}

			DWObject dwObj = getDWObject(objName, 1, userInfo);

			ArrayList primaryKeyLogNameList = dwObj.getPrimaryKeyLogNameList();
			ArrayList primaryKeyDataTypeList = dwObj.getPrimaryKeyDataTypeList();

			StringBuffer headerPKFieldNamesBuff = new StringBuffer();
			StringBuffer headerPKFieldDataTypesBuff = new StringBuffer();

			for(int i = 0; i < primaryKeyLogNameList.size(); i++)
			{
				headerPKFieldNamesBuff.append((String)primaryKeyLogNameList.get(i)).append(COLUMN_SEPARATOR); //$NON-NLS-1$
				headerPKFieldDataTypesBuff.append((String)primaryKeyDataTypeList.get(i)).append(COLUMN_SEPARATOR); //$NON-NLS-1$
			}
			if (headerPKFieldNamesBuff.length() > 0)
			{
				headerPKFieldNamesBuff.deleteCharAt((headerPKFieldNamesBuff.length() - 1));
			}

			String headerPKFieldNames = headerPKFieldNamesBuff.toString();
			String headerPKFieldDataTypes = headerPKFieldDataTypesBuff.toString();

			StringBuffer selQuery = new StringBuffer( );

			selQuery.append( "SELECT COUNT(1) FROM " + tableName + " WHERE " );

			StringTokenizer pkNameTokens = new StringTokenizer( headerPKFieldNames, COLUMN_SEPARATOR ); //$NON-NLS-1$
			while( pkNameTokens.hasMoreTokens() )
			{
				String currPKName = pkNameTokens.nextToken();
				selQuery.append( currPKName ).append( " = " ).append("?").append( " AND " ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}

			selQuery.append( "(" + colName +"='"+ cofColVal +"')" ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$

			if( selQuery.length() > 0 )
			{
				E12GenericUtility genericUtility = new E12GenericUtility();

				ConnDriver mConnDriver = new ConnDriver();
				mConn = mConnDriver.getConnectDB( transDB );

				BaseLogger.log("3", null, null,"selQuery [" + selQuery.toString() + "]");

				pStamt = mConn.prepareStatement( selQuery.toString() );

				if( pkValues != null && selQuery.indexOf( "?" ) != -1 ) //$NON-NLS-1$
				{
					StringTokenizer qryParamTokens = new StringTokenizer( pkValues );
					int pCount = 1;
					while(qryParamTokens.hasMoreTokens())
					{
						String testParam = qryParamTokens.nextToken( COLUMN_SEPARATOR );
						if ( headerPKFieldDataTypes != null )
						{
                            //change by shrutika on 19-12-2020 for Exception in application start
							//String testParamType = headerPKFieldDataTypes.substring( 0, headerPKFieldDataTypes.indexOf( COLUMN_SEPARATOR ) );
							String testParamType = "";
							if( headerPKFieldDataTypes.contains(COLUMN_SEPARATOR))
							{
								testParamType = headerPKFieldDataTypes.substring( 0, headerPKFieldDataTypes.indexOf( COLUMN_SEPARATOR ) );
							}
							else
							{
								testParamType = headerPKFieldDataTypes;
							}
                            //change by shrutika on 19-12-2020 for Exception in application end
							BaseLogger.log("3", null, null, "Setting Param value :["+testParam+"] Type :["+testParamType+"] position :["+pCount+"]" ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
							if ( testParamType.equalsIgnoreCase( "DATETIME" ) ) //$NON-NLS-1$
							{
								testParam = genericUtility.getValidDateTimeString(testParam, genericUtility.getDispDateFormat(), genericUtility.getDBDateFormat());
								pStamt.setTimestamp(pCount, java.sql.Timestamp.valueOf(testParam));
							}
							else if ( testParamType.equalsIgnoreCase("DATE") ) //$NON-NLS-1$
							{
								testParam = getValidDateString( testParam, genericUtility.getDispDateFormat(), genericUtility.getDBDateFormat() );
								pStamt.setDate( pCount, java.sql.Date.valueOf( testParam ) );
							}
							else if ( testParamType.equalsIgnoreCase( "DECIMAL" ) ) //$NON-NLS-1$
							{
								pStamt.setDouble(pCount, Double.parseDouble(testParam));
							}
							else
							{
								pStamt.setString( pCount, testParam );
							}
							headerPKFieldDataTypes = headerPKFieldDataTypes.substring( headerPKFieldDataTypes.indexOf( COLUMN_SEPARATOR ) + 1 );
						}
						else
						{
							pStamt.setString( pCount, testParam );
						}
						pCount = pCount + 1;
					}
				}
			}

			rs = pStamt.executeQuery();
			while(rs.next())
			{
				int count = rs.getInt(1);
				if (count > 0)
				{
					isConfirmed = true;
				}
			}
			rs.close();
			rs = null;
			BaseLogger.log("3", null, null,"isConfirmed [" + isConfirmed + "]");
		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null,"Exception : DBAccessEJB : isConfirmed :"+e);
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pStamt != null )
				{
					pStamt.close();
					pStamt = null;
				}
				if( mConn != null )
				{
					mConn.close();
					mConn = null;
				}
			}
			catch( Exception e )
			{
				BaseLogger.log("0", null, null, "Exception : DBAccessEJB : isConfirmed : Finally:" + e.getMessage() );
			}
		}
		BaseLogger.log("2", null, null,"Return from isConfirmed [" + isConfirmed + "]");
		return isConfirmed;
	}
	//Comented and Changes by Prajyot on 29APR2015 [To revised Delete Attachment Rights based.]Ends
	/**
	 *
	 * @param objName
	 * @param formNo
	 * @return
	 * @throws ITMException
	 */
	private DWObject getDWObject(String objName, int formNo, UserInfoBean userInfo) throws ITMException
	{
		DWObject dwObject = null;
		try
		{
			String metaDataFileName = objName + "2" + formNo; //$NON-NLS-1$
			//Changes By Ajinkya Gopalkar on 4-Apr-17
			//			DWFactory dws = DWFactory.getDWFactory();
			DWFactory dws = new DWFactory(userInfo);
			dwObject = (DWObject)dws.getDataWindow(metaDataFileName);
		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null,"Exception : DBAccessEJB : getDWObject :"+e); //$NON-NLS-1$
			throw new ITMException(e);
		}
		return dwObject;
	}

	/**
	 * converting date format
	 * @param dateStr
	 * @param sourceDateFormat
	 * @param targetDateFormat
	 * @return
	 * @throws ITMException
	 */
	private String getValidDateString(String dateStr, String sourceDateFormat, String targetDateFormat) throws ITMException
	{
		BaseLogger.log("2", null, null,"[DBAccessEJB]Converting dateStr :["+dateStr+"] From format :["+sourceDateFormat +"] To Format :["+targetDateFormat+"]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
		Object date = null;
		String retDateStr = ""; //$NON-NLS-1$
		try
		{
			if (!(sourceDateFormat.equalsIgnoreCase(targetDateFormat)))
			{
				if (sourceDateFormat.indexOf("/") != -1) //$NON-NLS-1$
				{
					dateStr.replace('/', '-');
				}
				else if (sourceDateFormat.indexOf(".") != -1) //$NON-NLS-1$
				{
					dateStr.replace('.', '-');
				}

				date = new SimpleDateFormat(sourceDateFormat).parse(dateStr);
				SimpleDateFormat sdfOutput = new SimpleDateFormat(targetDateFormat);
				retDateStr = sdfOutput.format(date);
			}
			else
			{
				retDateStr = dateStr;
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null,"Exception :DBAccessEJB :getValidDateString :==>"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		BaseLogger.log("2", null, null,"[DBAccessEJB]Converted Datestr :["+retDateStr+"]"); //$NON-NLS-1$ //$NON-NLS-2$
		return retDateStr;
	}

	/**
	 * To verify Authorization to Delete attachment or Not
	 * @param docId
	 * @param userLevel
	 * @param profileId
	 * @param loginCode
	 * @param objName
	 * @param pkValues
	 * @return isAuthorized
	 * @throws RemoteException, ITMException
	 */
	public boolean deleteAttachmentAuth(String docId, String userLevel, String profileId, String loginCode, String objName, String pkValues, String documentAddedBy, String transDB, UserInfoBean userInfo) throws RemoteException, ITMException
	{
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		Connection conn = null;
		ConnDriver connDriver =  new ConnDriver();

		String sql = "";
		boolean isAuthorized = false;
		String attach_rights = "";
		try
		{
			if( "0".equalsIgnoreCase( userLevel ) )
			{
				isAuthorized = true;
			}
			// for other than user level 0
			else
			{
				conn = connDriver.getConnectDB(transDB);

				objName = objName.indexOf("w_")!= -1 ? objName.replace("w_", ""):objName;
				//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
				//sql=" SELECT ATTACH_RIGHTS FROM USER_RIGHTS WHERE PROFILE_ID = ? AND OBJ_NAME = ?";
				sql=" SELECT ATTACH_RIGHTS FROM USER_RIGHTS WHERE PROFILE_ID IN "+ E12GenericUtility.getFormattedProfileId(profileId)+" AND OBJ_NAME = ?";
				pStmt = conn.prepareStatement(sql);
				//pStmt.setString(1, getFormattedProfileId(profileId));
				pStmt.setString(1, objName);
				rs = pStmt.executeQuery();
				//if( rs.next() )
				while( rs.next() )
				{
					attach_rights = attach_rights + rs.getString("ATTACH_RIGHTS") == null ? "" : rs.getString("ATTACH_RIGHTS");
				}

				rs.close();
				rs = null;
				pStmt.close();
				pStmt = null;

				if(attach_rights != null)
				{
					attach_rights = attach_rights.trim();
				}

				if(loginCode != null)
				{
					loginCode = loginCode.trim();
				}

				BaseLogger.log("3", null, null,"ATTACH_RIGHTS = ["+ attach_rights +"] loginCode = ["+ loginCode +"]");

				//Comented and Changes by Prajyot on 29APR2015 [To revised Delete Attachment Rights based.]Starts
				/*
				boolean isConfirmed = isAttachmentAllow(objName, pkValues);

				//attach right ('*')
				if ( attach_rights.indexOf("*") != -1 )
				{
					isAuthorized = true;
				}
				//Self - Unconfirmed - attach right ('1')
				else if(loginCode.equals(documentAddedBy) && !isConfirmed && (attach_rights.indexOf("1") != -1))
				{
					isAuthorized = true;
				}
				//Self - Confirmed - attach right ('2')
				else if(loginCode.equals(documentAddedBy) && isConfirmed && (attach_rights.indexOf("2") != -1))
				{
					isAuthorized = true;
				}
				//Self - Confirmed - attach right ('3')
				else if(!loginCode.equals(documentAddedBy) && isConfirmed && (attach_rights.indexOf("3") != -1))
				{
					isAuthorized = true;
				}
				//Self - Unconfirmed - attach right ('4')
				else if(!loginCode.equals(documentAddedBy) && !isConfirmed && (attach_rights.indexOf("4") != -1))
				{
					isAuthorized = true;
				}
				else
				{
					isAuthorized = false;
				}
				 */
				//Changes by Prajyot on 11-Aug-2015 [Not to check for Transaction confirm status in case of ATTACH_RIGHTS is * ]
				//boolean isSelf = loginCode.equals(documentAddedBy);
				//boolean isConfirm = isConfirmed(objName, pkValues);
				boolean isAllAttachRights = ( attach_rights.indexOf("*") != -1 );
				boolean isSelf = isAllAttachRights ? true : loginCode.equals(documentAddedBy);
				boolean isConfirm = isAllAttachRights ? true : isConfirmed(objName, pkValues, transDB, userInfo);
				BaseLogger.log("3", null, null,"isSelf["+ isSelf +"]isConfirm["+ isConfirm +"]loginCode["+ loginCode +"]documentAddedBy["+ documentAddedBy +"]");
				//All attach rights : Can delete attachment - If attached by self or others ( and transaction is Confirmed or Unconfirmed ).
				if ( attach_rights.indexOf("*") != -1 )
				{
					isAuthorized = true;
				}
				//Attach rights = 1 : Can delete attachment - which attached by Self - Unconfirmed.
				else if ( attach_rights.indexOf("1") != -1 )
				{
					isAuthorized = ( isSelf && !isConfirm ); // SELF UNCONFIRMED
				}
				//Attach rights = 2 : Can delete attachment - which attached by Self or Others - Unconfirmed.
				else if ( attach_rights.indexOf("2") != -1 )
				{
					isAuthorized = ( !isConfirm ); // ANY UNCONFIRMED
				}
				//Attach rights = 3 : Can delete attachment - which attached by Self - Unconfirmed or Confirmed.
				else if ( attach_rights.indexOf("3") != -1 )
				{
					isAuthorized = ( isSelf ); // SELF ALL
				}
				//Attach rights = 4 : Can delete attachment - which attached by Self - Unconfirmed or Confirmed.
				//										and - which attached by Others - Unconfirmed.
				else if ( attach_rights.indexOf("4") != -1 )
				{
					isAuthorized = ( isSelf && isConfirm ) || ( !isConfirm ); // SELF CONFIRMED or ANY UNCONFIRMED
				}
				//Comented and Changes by Prajyot on 29APR2015 [To revised Delete Attachment Rights based.]Ends
			}

			BaseLogger.log("3", null, null,"In DBAccessEJB : deleteAttachmentAuth["+isAuthorized+"]");
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
				if( conn != null && ! conn.isClosed() )
				{
					conn.close();
				}
			}
			catch(Exception e)
			{
				BaseLogger.log("0", null, null, "Exception : DBAccessEJB : deleteAttachmentAuth()"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return isAuthorized;
	}
	//Added by Prasad on 24/02/15 [WS3DSUN004 - Change Rights for Delete Attachment] End

	//Added By Prajyot on 05-JUN-2015 [Entity Contact Details for SSP] Starts
	/**
	 * To get Entity Contact Details from ENTITY_CONTACT
	 * @param transDB
	 */
	@Override
	public String getEntityContactDetails(String loginUserId, String userType, String transDB) throws ITMException
	{
		BaseLogger.log("2", null, null,"Get Account Details loginUserId["+loginUserId+"]userType["+userType+"]");
		StringBuffer accountDetailsBuff = new StringBuffer("");
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		Connection conn = null;
		ConnDriver connDriver =  new ConnDriver();
		try
		{
			conn = connDriver.getConnectDB(transDB);
			String sql = "SELECT * FROM ENTITY_CONTACT WHERE USER_ID__PORTAL = ?  AND ENTITY_TYPE = ? ";
			if( "ALL".equalsIgnoreCase(userType) )
			{
				sql = "SELECT * FROM ENTITY_CONTACT WHERE USER_ID__PORTAL = ?";
				pStmt = conn.prepareStatement(sql);
				pStmt.setString(1, loginUserId);
			}
			else
			{
				pStmt = conn.prepareStatement(sql);
				pStmt.setString(1, loginUserId);
				pStmt.setString(2, userType);
			}
			BaseLogger.log("3", null, null,"Sql getAccountDetails [" + sql + "]");
			rs = pStmt.executeQuery();
			ResultSetMetaData rsmd = rs.getMetaData();
			int colCount = rsmd.getColumnCount();
			if( rs.next() )
			{
				accountDetailsBuff.append("<Root>");
				do
				{
					accountDetailsBuff.append("<ENTITY_CONTACT>");
					for(int colNo = 1; colNo <= colCount; colNo++)
					{
						String colName = checkNull( rsmd.getColumnName(colNo) ).toUpperCase();
						String colValue = checkNull( rs.getString(colNo) );
						accountDetailsBuff.append("<"+colName+">").append("<![CDATA[" + colValue + "]]>").append("</"+colName+">");
						//Changes by Ajinkya Gopalkar on 23-SEP-15[For usertype "ALL"]
						String entityContactType = checkNull( rs.getString( "ENTITY_TYPE" ) );
						//For Column Name ENTITY_CODE
						if("ENTITY_CODE".equalsIgnoreCase(colName))
						{
							String tableName = "";
							String selectColName = "";
							String whereColName = "";
							if("P".equalsIgnoreCase( entityContactType ) || "ALL".equalsIgnoreCase(userType) )
							{
								tableName = "sales_pers";
								selectColName = "sp_name";
								whereColName = "sales_pers";
							}
							else if("E".equalsIgnoreCase( entityContactType ) || "ALL".equalsIgnoreCase(userType) )
							{
								tableName ="employee";
								selectColName = "emp_fname || ' ' || emp_lname as emp_name ~AS~ emp_name"; // To separate column alias name
								whereColName = "emp_code";
							}
							else if("S".equalsIgnoreCase( entityContactType ) || "ALL".equalsIgnoreCase(userType) )
							{
								tableName = "supplier";
								selectColName = "supp_name";
								whereColName = "supp_code";
							}
							else if("C".equalsIgnoreCase( entityContactType ) || "ALL".equalsIgnoreCase(userType) )
							{
								tableName = "customer";
								selectColName = "cust_name";
								whereColName = "cust_code";
							}
							String selectColValue = getDBColumnValue(tableName, selectColName, whereColName + " = '" + colValue + "' ", transDB);
							accountDetailsBuff.append("<ENTITY_CONTACT_NAME>").append("<![CDATA[" + selectColValue + "]]>").append("</ENTITY_CONTACT_NAME>");
						}
					}
					accountDetailsBuff.append("</ENTITY_CONTACT>");
				}
				while( rs.next() );
				accountDetailsBuff.append("</Root>");
			}
			rs.close();
			rs = null;
			pStmt.close();
			pStmt = null;
		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null,"Exception in getEntityContactDetails ["+e.getMessage()+"]");
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
				if( conn != null && ! conn.isClosed() )
				{
					conn.close();
				}
			}
			catch(Exception e)
			{
				BaseLogger.log("0", null, null, "Exception : DBAccessEJB : getEntityContactDetails()"+e.getMessage());
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2", null, null,"Return from getEntityContactDetails [" + accountDetailsBuff.toString() + "]");
		return accountDetailsBuff.toString();
	}

	// To check entity contact exists for login user
	private boolean ifEntityContactsExists(UserInfoBean usrInfo)
	{
		boolean ifEntityContactsExists = false;
		String loginUserId = usrInfo.getLoginCode();
		String userType = usrInfo.getUserType();
		try
		{
			String acctDetails = getEntityContactDetails(loginUserId, userType, usrInfo.getTransDB());
			ifEntityContactsExists = checkNull(acctDetails).length() > 0;
			BaseLogger.log("3", usrInfo, null,"ifEntityContactsExists [" + ifEntityContactsExists + "] acctDetails[" + checkNull(acctDetails).length() + "]");
		}
		catch (ITMException e)
		{
			BaseLogger.log("0", usrInfo, null,"ITMException at ifEntityContactsExists [" + e.getMessage() + "]");
			e.printStackTrace();
		}
		return ifEntityContactsExists;
	}
	//Added By Prajyot on 05-JUN-2015 [Entity Contact Details for SSP] End

	//Added By umakanta On 14/JULY/2015 [ SY3ESUN003 ] [ For get Max Reprint Count ]Start
	public String getMaxReprintCount(String objName, String argValue, String userInfoStr, String reprintCntrlSQL) throws ITMException
	{
		BaseLogger.log("2", null, null,"DBAccessEJB CALLED "+objName); //$NON-NLS-1$
		String maxReprintCount = "0";
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			//Added by Pankaj T on 19-12-17 [changes for multitenancy]
			UserInfoBean userInfoBean = new UserInfoBean(userInfoStr);
			String transDB = userInfoBean.getTransDB();
			conn = connDriver.getConnectDB(transDB);

			ArrayList<String> reprintCntrlResulstAL = new ArrayList<String>();
			String getPrintStatus = "SELECT COUNT(1) , MAX(REPRINT_CNT) FROM RPT_PRINT_LOG WHERE REPORT_NAME = ? AND PARAMETER_VAL = ? ";  //$NON-NLS-1$
			pstmt = conn.prepareStatement(getPrintStatus);
			reprintCntrlResulstAL = getReprintCntrlQSLResult( replaceArgValue( reprintCntrlSQL, argValue ), userInfoBean );
			if( reprintCntrlResulstAL.size() == 0 )
			{
				reprintCntrlResulstAL.add( argValue );
			}
			pstmt.setString(1, objName);
			pstmt.setString(2, reprintCntrlResulstAL.get( 0 ) );

			rs = pstmt.executeQuery();
			if(rs.next())
			{
				maxReprintCount = String.valueOf( rs.getInt(2) );
				BaseLogger.log("3", null, null,"[Max Reprint Count] = "+maxReprintCount);
			}
		}
		//Added By Ravindra C on 25-03-2020 to avoid error while user pass lage number of pophelps. START
		catch(SQLException e)
		{
			e.getStackTrace();
		}
		//Added By Ravindra C on 25-03-2020 to avoid error while user pass lage number of pophelps. END
		catch (Exception e)
		{
			e.getStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( conn != null )
				{
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return maxReprintCount;
	}
	//Added By umakanta On 14/JULY/2015 [ SY3ESUN003 ] [ For get Max Reprint Count ]End


	//Added by Reema on 15/JULY/2015 [get Reason code list]
	public String getReasCodeList( String objName, UserInfoBean userInfo ) throws ITMException
	{
		String sql = "";
		StringBuffer valueXmlString = new StringBuffer();
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		String transDB = null;
		String itemCode = "";
		try
		{
			ConnDriver connDriver = new ConnDriver();
			transDB = userInfo.getTransDB();
			connectionObject = connDriver.getConnectDB(transDB);

			sql = "SELECT FLD_VALUE, DESCR FROM GENCODES WHERE FLD_NAME='REAS_CODE' AND  MOD_NAME = UPPER('W_"+objName+"') ";
			BaseLogger.log("3", null, null,"getReasCodeList: SQL:: [" + sql + "]");
			valueXmlString.append("<Root>\r\n");

			pstmt = connectionObject.prepareStatement(sql);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				valueXmlString.append("<REASCODE>");
				valueXmlString.append("<FLD_VALUE><![CDATA[").append(rs.getString("FLD_VALUE")).append("]]></FLD_VALUE>\r\n");
				valueXmlString.append("<DESCR><![CDATA[").append(rs.getString("DESCR")).append("]]></DESCR>\r\n");
				valueXmlString.append("</REASCODE>\r\n");
			}// end of while
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			BaseLogger.log("0", null, null,"Exception :DBAccessEJB :getReasCodeList(String):" + e.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		}
		finally
		{
			try
			{
				if (connectionObject != null && !connectionObject.isClosed()) {
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch (Exception e)
			{
				BaseLogger.log("0", null, null,"Exception :DBAccessEJB :getReasCodeList(String) :==>\n"+ e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append("</Root>\r\n");
		BaseLogger.log("2", null, null,"\n****ReasonListXmlString :" + valueXmlString.toString() + ":********");
		return valueXmlString.toString();
	}
	//Added by Reema on 15/JULY/2015 [get Reason code list]-End

	//Addded by Gaurav Singh on 13-JUL-15 [To get the Email_Addr from entity_contact master | Start]
	/**
	 * This method is used to get all the Email ID based on the parameter supplied
	 * @param entityType
	 * @param entityCode
	 * @param responsibleFor
	 * @return
	 * @throws ITMException
	 */
	public String getEntityEmailAddr(String entityType, String entityCode, String responsibleFor)throws RemoteException, ITMException
	{
		String emailId = "";
		Connection conn = null;
		ConnDriver connDriver = null;
		PreparedStatement pstmtEmail = null;
		ResultSet rsEmail = null;
		try
		{
			int count = 1;
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver");

			String emailSql = "SELECT EMAIL_ID FROM ENTITY_CONTACT WHERE ENTITY_TYPE = ? AND ENTITY_CODE = ? AND RESPONSIBLE_FOR = ? ";
			pstmtEmail = conn.prepareStatement(emailSql);
			pstmtEmail.setString(1, entityType);
			pstmtEmail.setString(2, entityCode);
			pstmtEmail.setString(3, responsibleFor);
			rsEmail = pstmtEmail.executeQuery();

			while(rsEmail.next())
			{
				if(count == 1)
				{
					emailId = (rsEmail.getString("EMAIL_ID") == null)?"":rsEmail.getString("EMAIL_ID").trim();
				}
				else
				{
					emailId = emailId + ","+ ((rsEmail.getString("EMAIL_ID") == null)?"":rsEmail.getString("EMAIL_ID").trim());
				}
				count++;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(rsEmail != null)
					{
						rsEmail.close();
						rsEmail = null;
					}
					if(pstmtEmail != null)
					{
						pstmtEmail.close();
						pstmtEmail = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e1)
			{

			}
		}
		BaseLogger.log("2", null, null,"Email ID == ["+emailId+"]");
		return emailId;
	}
	//Addded by Gaurav Singh on 13-JUL-15 [End]

	//Added by Prasad on 07/08/15 [Comment related changes] START
	/**
	 * get Comments of selected transaction
	 * @param refSer
	 * @param tranId
	 * @return
	 * @throws ITMException
	 */
	public String getComments(String refSer, String tranId, UserInfoBean userInfo) throws ITMException
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String returnString = "";
		try
		{
			BaseLogger.log("3", userInfo, null,"In getComments - refSer - ["+ refSer +"], tranId - ["+ tranId +"]");
			if ( userInfo != null )
			{
				ConnDriver connDriver = new ConnDriver();
				String transDB = userInfo.getTransDB();
				if( checkNull(transDB).length() > 0 )
				{
					conn = connDriver.getConnectDB(transDB);
				}
				//Added By Pankaj T. on 16-06-2021 to get dbName from connection url instead of Commonconstant
				String database = connDriver.getDBName();
				connDriver = null;

				StringBuffer xmlString = new StringBuffer();
				xmlString.append("<ROOT><COMMENTS>");
				String sql = "";
				//Added By Pankaj T. on 16-06-2021 to get dbName from connection url instead of Commonconstant and changed sql for mysql - start
				if( "mysql".equalsIgnoreCase( database ) )
				{
					sql = "SELECT concat( a.Comm_text, ' ( on ', a.chg_date, ' by ', b.name, ')')  as COMM_TEXT "
							+ " FROM COMMENTS a, users b "
							+ " where a.chg_user = b.code and a.REF_SER = ? AND a.REF_ID= ? "
							+ " ORDER BY a.CHG_DATE DESC";
				}
				else
				{
					sql = "SELECT a.Comm_text || ' ( on ' ||  a.chg_date || ' by ' || b.name || ')'  as COMM_TEXT "
							+ " FROM COMMENTS a, users b "
							+ " where a.chg_user = b.code and a.REF_SER = ? AND a.REF_ID= ? "
							+ " ORDER BY a.CHG_DATE DESC";
				}
				//Added By Pankaj T. on 16-06-2021 to get dbName from connection url instead of Commonconstant and changed sql for mysql - end
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, refSer);
				pstmt.setString(2, tranId);
				rs = pstmt.executeQuery();
				while( rs.next() )
				{
					String comment = rs.getString("COMM_TEXT") == null ? "" : rs.getString("COMM_TEXT");
					xmlString.append("<COMMENT><![CDATA[" + comment + "]]></COMMENT>");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				xmlString.append("</COMMENTS></ROOT>");

				returnString = xmlString.toString();
			}
		}
		catch (SQLException e)
		{
			returnString = e.getMessage();
			e.printStackTrace();
			throw new ITMException(e);
		}
		catch (Exception e)
		{
			returnString = e.getMessage();
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch( Exception e )
			{
				BaseLogger.log("0", userInfo, null, "Exception :" + e.getMessage() );
				e.printStackTrace();
			}
		}
		BaseLogger.log("2", userInfo, null,"returnString - ["+ returnString +"]");

		return returnString;
	}

	/**
	 * Add Comments of selected transaction
	 * @param refSer
	 * @param tranId
	 * @param comment
	 * @param userCode
	 * @param userInfo
	 * @throws ITMException
	 */
	public String addComments(String objName, String refSer, String tranId, String comment, String userCode, UserInfoBean userInfo) throws ITMException, SQLException
	{
		String returnString = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "", keyCont = "";
		try
		{
			BaseLogger.log("3", userInfo, null,"In addComments - refSer - ["+ refSer +"], tranId - ["+ tranId +"], userCode - ["+ userCode +"]");
			if ( userInfo != null )
			{
				ConnDriver connDriver = new ConnDriver();
				String transDB = userInfo.getTransDB();
				if( checkNull(transDB).length() > 0 )
				{
					conn = connDriver.getConnectDB(transDB);
				}

				conn.setAutoCommit(false);
				connDriver = null;

				String chgTerm = userInfo.getRemoteHostName();
				if( chgTerm != null && chgTerm.length() > 15 )
				{
					chgTerm = chgTerm.substring(0, 15);
				}
				else if( chgTerm == null || chgTerm.length() == 0 )
				{
					chgTerm = userInfo.getRemoteHost();
				}
				//Added code by Varsha to get keystring from transeup on 30-08-18
				sql   = "select key_string from transetup where tran_window = 't_comment_id'";
				pstmt = conn.prepareStatement(sql);
				rs    = pstmt.executeQuery();
				if(rs.next())
				{
					keyCont = checkNull(rs.getString("key_string"));
				}
				else
				{
					keyCont = "";
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				if(keyCont == null || keyCont.trim().length() == 0)
				{
					keyCont = "_seq10";
				}
				//Ended code by Varsha to get keystring from transeup on 30-08-18
				StringTokenizer st = new StringTokenizer( tranId, ";" );
				while( st.hasMoreTokens() )
				{
					String tranIdLocal = st.nextToken();
					BaseLogger.log("3", userInfo, null,"tranIdLocal ["+tranIdLocal+"]");

					//Added By Pankaj T. on 16-06-2021 to get sequence accordingly database
					CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
					String lineNo = commonDBAccessEJB.generateSeq("COMMENTS_LINE_NO", 10, userInfo.getTransDB());
					
					sql = "INSERT INTO COMMENTS(COMMENT_ID,REF_SER,REF_ID,LINE_NO,COMM_TEXT,CHG_USER,CHG_DATE,CHG_TERM) "
							//+ "VALUES(?,?,?,COMMENTS_LINE_NO.NEXTVAL,?,?,?,?)";
							+ "VALUES(?,?,?,?,?,?,?,?)";

					// Change by Abhishek T on 21-Mar-17 [For insert comment id in COMMENTS table] START
					TransIDGenerator idGenerator = new TransIDGenerator("<Root></Root>", userCode, CommonConstants.DB_NAME);

					//Commented and added by Varsha V on 30-08-18 for passing keycont from transetup
					//String transId = idGenerator.generateTranSeqID("CMMTID", "COMMENT_ID", "seq10", conn);
					String transId = idGenerator.generateTranSeqID("CMMTID", "COMMENT_ID", keyCont, conn);
					//Ended by Varsha V on 30-08-18 for passing keycont from transetup

					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, transId);
					pstmt.setString(2, refSer);
					pstmt.setString(3, tranIdLocal);
					pstmt.setString(4, lineNo);
					pstmt.setString(5, comment);
					pstmt.setString(6, userCode);
					pstmt.setTimestamp(7, new java.sql.Timestamp(System.currentTimeMillis()));
					pstmt.setString(8, chgTerm ); //$NON-NLS-1$
					// Change by Abhishek T on 21-Mar-17 [For insert comment id in COMMENTS table] END

					int noOfRows = pstmt.executeUpdate();
					pstmt.close();
					pstmt = null;
					BaseLogger.log("3", userInfo, null,"<..........ROW INSERTED.............> [" + noOfRows + "]");

					updateCountOfComments(objName, tranIdLocal, refSer, conn, userInfo);
					//Added by Pankaj on 23-07-18 [Start] for insert Add Comment for record.
					AuditTrailExtEJB auditTrailExt = new AuditTrailExtEJB();
					String auditResult = auditTrailExt.saveActionPerformedInAudit(objName, tranId, "Add Comment","Add Comment", userCode, chgTerm, userInfo);
					//Added by Pankaj on 23-07-18 [End] for insert Add Comment for record.
				}
				conn.commit();

				returnString = "<ROOT><RESULT>Success</RESULT></ROOT>";
			}
		}
		catch (SQLException e)
		{
			//added rollback statement by Varsha v on 30-08-18
			if(conn != null)
			{
				conn.rollback();
			}
			returnString = e.getMessage();
			e.printStackTrace();
			throw new ITMException(e);
		}
		catch (Exception e)
		{
			//added rollback statement by Varsha v on 30-08-18
			if(conn != null)
			{
				conn.rollback();
			}
			returnString = e.getMessage();
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch( Exception e )
			{
				BaseLogger.log("0", userInfo, null, "Exception :" + e.getMessage() );
				e.printStackTrace();
			}
		}
		BaseLogger.log("2", userInfo, null,"returnString - ["+ returnString +"]");

		return returnString;
	}

	/**
	 * Update Count Comments of selected transaction
	 * @param objName
	 * @param refId
	 * @param refSer
	 * @param transDB
	 * @throws ITMException
	 */
	public void updateCountOfComments(String objName, String refId, String refSer, Connection conn, UserInfoBean userInfo) throws ITMException
	{
		PreparedStatement pStamt = null;
		ResultSet resultSet = null;
		boolean localConn = false;
		try
		{
			String transDB = userInfo.getTransDB();
			BaseLogger.log("3", userInfo, null,"In updateCountOfComments - objName = ["+ objName +"] refId = ["+ refId +"] refSer = ["+ refSer +"] transDB = ["+ transDB +"]");
			if ( conn == null )
			{
				ConnDriver mConnDriver = new ConnDriver();
				if(transDB!=null && (transDB.trim().length() >0 ))
				{
					conn = mConnDriver.getConnectDB( transDB );
				}

				mConnDriver = null;
				localConn = true;
			}
			String tranIdCol = "", tableName = "", tranWin = "";
			if ( checkNull(objName).length() > 0 )
			{
				HashMap objDetailMap = getObjDetailMap(objName, userInfo);
				tranIdCol = (String)objDetailMap.get( "TRAN_ID_COL" );
				tableName = (String)objDetailMap.get( "TABLE_NAME" );
			}
			else if ( checkNull(refSer).length() > 0 )
			{
				String sql = "SELECT TRAN_WINDOW, TRAN_ID_COL, TABLE_NAME FROM TRANSETUP WHERE REF_SER = ? ";
				pStamt = conn.prepareStatement(sql);
				pStamt.setString(1, refSer);
				resultSet = pStamt.executeQuery();
				if(resultSet.next())
				{
					tranWin = resultSet.getString(1);
					tranIdCol = resultSet.getString(2);
					tableName = resultSet.getString(3);
				}
				pStamt.close();
				pStamt=null;
				resultSet.close();
				resultSet=null;

				BaseLogger.log("3", userInfo, null,"tranWin = ["+ tranWin +"] tranIdCol = ["+ tranIdCol +"] tableName = ["+ tableName +"]");
				if ( checkNull(tranWin).length() > 0 )
				{
					objName = tranWin.replace("w_", "");
				}
			}

			BaseLogger.log("3",userInfo, null,"objName = ["+ objName +"] tranIdCol = ["+ tranIdCol +"] tableName = ["+ tableName +"]");
			if ( checkNull(objName).length() > 0 )
			{
				if ( checkNull(tableName).length() > 0 && checkNull(tranIdCol).length() > 0 )
				{
					DatabaseMetaData metadata = conn.getMetaData();
					resultSet = metadata.getTables(null, null, tableName.toUpperCase(), null);
					if(resultSet.next())
					{
						BaseLogger.log("3",userInfo, null,"["+ tableName +"] -- table exists");
						resultSet.close();
						resultSet = null;

						resultSet = metadata.getColumns(null, null, tableName.toUpperCase(), "NO_COMMENTS");
						if(resultSet.next())
						{
							BaseLogger.log("3", userInfo, null,"[NO_COMMENTS] -- column exists");
							//Changed by Prasad on 28/01/16 [Updating comments count for composite primary key] START
							/*String query = "UPDATE "+ tableName +" "
									+ " SET NO_COMMENTS = ( SELECT COUNT(*) FROM COMMENTS WHERE REF_SER= ? AND REF_ID = ? ) WHERE "+ tranIdCol +" = ?";

							pStamt = conn.prepareStatement( query );
							pStamt.setString(1, refSer);
							pStamt.setString(2, refId);
							pStamt.setString(3, refId);
							int updateCnt = pStamt.executeUpdate();
							if ( localConn )
							{
								conn.commit();
								BaseLogger.log("3", null, null,"Connection Commited....");
							}
							BaseLogger.log("3", null, null,"updateCnt = [" + updateCnt + "]");*/
							E12GenericUtility genericUtility = new E12GenericUtility();
							if ( tranIdCol.contains( ":" ) )
							{
								tranIdCol = tranIdCol.replaceAll( ":", "," );
							}
							String[] tranIdCols = tranIdCol.split( "," );
							String[] refIds = refId.split( "~" );
							if ( tranIdCols.length == refIds.length )
							{
								StringBuffer advQuery = new StringBuffer( " WHERE " );
								String sql = "SELECT " + tranIdCol + "  FROM " + tableName + " WHERE 1 = 2";
								pStamt = conn.prepareStatement(sql);
								ResultSet rs = pStamt.executeQuery();

								ResultSetMetaData md = rs.getMetaData();
								String columnNames = "", columnValue = "";
								for( int i = 1; i <= md.getColumnCount(); i++ )
								{
									columnNames = md.getColumnName(i);
									columnValue = genericUtility.checkNull( refIds[i - 1] );
									if ( md.getColumnTypeName(i).toUpperCase().indexOf("DATE") != -1 || md.getColumnTypeName(i).toUpperCase().indexOf("TIMESTAMP") != -1 )
									{
										columnValue = columnValue.length() > 0 ?
												genericUtility.getValidDateString( columnValue, genericUtility.getDispDateFormat(), genericUtility.getDBDateFormat() ) : columnValue;
									}
									if ( i == md.getColumnCount() )
									{
										advQuery.append( columnNames + " = '"+ columnValue +"'" );
									}
									else
									{
										advQuery.append( columnNames + " = '"+ columnValue +"' AND " );
									}
								}
								String query = "UPDATE "+ tableName +" "
										+ " SET NO_COMMENTS = ( SELECT COUNT(*) FROM COMMENTS WHERE REF_SER= ? AND REF_ID = ? ) "+ advQuery.toString();

								pStamt = conn.prepareStatement( query );
								pStamt.setString(1, refSer);
								pStamt.setString(2, refId);
								int updateCnt = pStamt.executeUpdate();
								if ( localConn )
								{
									conn.commit();
									BaseLogger.log("3", userInfo, null,"Connection Commited....");
								}
								BaseLogger.log("3", userInfo, null,"updateCnt = [" + updateCnt + "]");
							}
							//Changed by Prasad on 28/01/16 [Updating comments count for composite primary key] END
						}
						resultSet.close();
						resultSet = null;
					}
				}
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo, null,"Exception : DBAccessEJB : updateCountOfComments :"+e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( pStamt != null )
				{
					pStamt.close();
					pStamt = null;
				}
				if( resultSet != null )
				{
					resultSet.close();
					resultSet = null;
				}
				if( localConn && conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch( Exception e )
			{
				BaseLogger.log("0", userInfo, null, "Exception :" + e.getMessage() );
				e.printStackTrace();
			}
		}
	}
	//Added by Prasad on 07/08/15 [Comment related changes] END

	//Added by Reema on 11-sep-15 [strore GeoFence Records in database]-start
	@Override
	public String storeGpsTrackRecord( String gpsTrackResult, String deviceID, String updateSource ) throws ITMException
	{
		BaseLogger.log("2", null, null,"In DBAccessEjb:: storeGpsTrackRecord");
		if( gpsTrackResult == null || "null".equalsIgnoreCase(gpsTrackResult) || gpsTrackResult.trim().length() <= 0 )
		{
			return "Failure";
		}
		E12GenericUtility genericUtility = new E12GenericUtility();
		StringBuffer gpsId = new StringBuffer("");
		Document dom = new E12GenericUtility().parseString( gpsTrackResult );
		NodeList geoPositionsTag = null;
		if( dom != null && dom.getElementsByTagName( "GEOPOSITIONS" ) != null )
		{
			geoPositionsTag = dom.getElementsByTagName( "GEOPOSITIONS" );
			Connection conn = null;
			ConnDriver connDriver = new ConnDriver();
			PreparedStatement pstmt = null;
			int result = 0;
			try
			{
				//BaseLogger.log("3", null, null,"In try of storeGpsTrackRecord");
				conn = connDriver.getConnectDB("Driver");
				//TODO : Ref this function GEOPOS_ID_FUNCTION() in DBAccessEJB class
				String updateSQL = "INSERT INTO GEOPOS(TRAN_ID, DEVICE_ID, DATETIME, GEOPOS, USER_ID, UPDATE_SOURCE, DATA_MODE) VALUES (GEOPOS_ID_SEQ.NEXTVAL,?,?,?,?,?,?)";
				for( int i = 0; i < geoPositionsTag.getLength(); i++ )
				{
					NodeList childNodeList = geoPositionsTag.item( i ).getChildNodes();
					int childLenght = childNodeList.getLength();
					for (int j = 0; j < childLenght; j++)
					{
						String latitude = "", longitude = "", id = "",altitude = "", datetime = "";
						String userId = "", serverId = "", dataMode = "";
						Node geoPositionTag = childNodeList.item( j );
						NodeList geoPositionNodeList = geoPositionTag.getChildNodes();
						for( int k = 0; k < geoPositionNodeList.getLength(); k++ )
						{
							Node geoPosNode = geoPositionNodeList.item( k );
							if( geoPosNode != null )
							{
								String nodeName = geoPosNode.getNodeName();
								String nodeValue = "";
								if( geoPosNode.getFirstChild() != null )
								{
									nodeValue = checkNull( geoPosNode.getFirstChild().getNodeValue() );
								}
								else
								{
									nodeValue = checkNull( geoPosNode.getNodeValue() );
								}
								if( "ID".equalsIgnoreCase( nodeName ) )
								{
									id = nodeValue;
								}
								else if( "LONGITUDE".equalsIgnoreCase( nodeName ) )
								{
									longitude = nodeValue;
								}
								else if( "LATITUDE".equalsIgnoreCase( nodeName ) )
								{
									latitude = nodeValue;
								}
								else if( "ALTITUDE".equalsIgnoreCase( nodeName ) )
								{
									altitude = nodeValue;
								}
								else if( "DATE_TIME".equalsIgnoreCase( nodeName ) )
								{
									datetime = nodeValue;
								}
								else if( "USER_ID".equalsIgnoreCase( nodeName ) )
								{
									userId = nodeValue;
								}
								else if( "SERVER_ID".equalsIgnoreCase( nodeName ) )
								{
									serverId = nodeValue;
								}
								else if( "DATA_MODE".equalsIgnoreCase( nodeName ) )
								{
									dataMode = nodeValue;
								}
							}
						}
						BaseLogger.log("3", null, null,"Record...: "+j+"\nid: ["+id+"]\nlatitude: ["+latitude+"]nlongitude: ["+longitude+"]" +
								"\naltitude: ["+altitude+"]\ndatetime: ["+datetime+"]\nuserId: ["+userId+"]\nserverId: ["+serverId+"]\ndataMode: ["+dataMode+"] ");
						StringBuffer geoPos = new StringBuffer();
						geoPos.append(latitude+","+longitude);
						pstmt = conn.prepareStatement(updateSQL);
						pstmt.setString(1, deviceID);

						//						datetime = genericUtility.getValidDateString( datetime, genericUtility.getApplDateTimeFormat(), genericUtility.getDBDateTimeFormat() ) ;
						datetime = genericUtility.getValidDateString( datetime, "yyyy-MM-dd HH:mm:ss",genericUtility.getDBDateTimeFormat() ) ;
						BaseLogger.log("3", null, null,"datetime: "+datetime);
						pstmt.setTimestamp(2, java.sql.Timestamp.valueOf( datetime ) );
						pstmt.setString(3, geoPos.toString());
						pstmt.setString(4, userId );
						pstmt.setString(5, updateSource );
						pstmt.setString(6, dataMode );
						result = pstmt.executeUpdate();
						BaseLogger.log("3", null, null,"insert GeoPOS: "+j);
						gpsId.append(id +",");
						if( pstmt != null )
						{
							pstmt.close();
							pstmt = null;
						}
					}
				}
				gpsId.append("Success");
			}
			catch (Exception e)
			{
				gpsId.append("Failure ");
				e.getStackTrace();
				throw new ITMException(e);
			}
			finally
			{
				try
				{
					if( conn != null )
					{
						if( pstmt != null )
						{
							pstmt.close();
							pstmt = null;
						}
						conn.commit();
						conn.close();
						conn = null;
					}
				}
				catch(Exception e)
				{
					e.printStackTrace();
				}
			}
		}
		else
		{
			//Do nothing
		}
		//NodeList geoTag = dom.getElementsByTagName( "GEOPOSITIONS" );

		return gpsId.toString();
	}
	//Added by Reema on 11-sep-15 [strore GeoFence Records in database]-End

	//Added by Prasad on 29/09/15 [Get Quick Filter Details - F15FSUN003] START
	/**
	 * get Filter Metadata from table
	 * @param objName
	 * @param userId
	 * @return
	 * @throws ITMException
	 */
	@Override
	public String getQuickFltrDtl(String objName, String userId) throws ITMException
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String returnString = "";
		UserInfoBean userInfo = null;
		String transDB = "";
		try
		{
			BaseLogger.log("3", null, null,"In getQuickFltrDtl - objName - ["+ objName +"], userId - ["+ userId +"]");
			userInfo = createUserInfo(userId);
			transDB = userInfo.getTransDB();
			if ( objName != null )
			{
				ConnDriver connDriver = new ConnDriver();
				conn = connDriver.getConnectDB(transDB);
				connDriver = null;

				StringBuffer xmlString = new StringBuffer();
				xmlString.append("<ROOT>\r\n<QUICK_FILTER>\r\n");
				String sql = "SELECT OBJ_NAME, USER_ID, FILT_NAME, EXPR_TYPE, EXPR_VALUE, FILT_GUI, FILT_POS, TITLE, CHG_DATE, CHG_USER, CHG_TERM " +
						" FROM OBJ_SMART_FILTER " +
						" WHERE OBJ_NAME = ? " +
						" ORDER BY FILT_POS";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, objName);
				rs = pstmt.executeQuery();
				while( rs.next() )
				{
					String obj_name = checkNull(rs.getString("OBJ_NAME"));
					String user_id = checkNull(rs.getString("USER_ID"));
					String filt_name = checkNull(rs.getString("FILT_NAME"));
					String expr_type = checkNull(rs.getString("EXPR_TYPE"));
					String expr_value = checkNull(rs.getString("EXPR_VALUE"));
					String filt_gui = checkNull(rs.getString("FILT_GUI"));
					String filt_pos = checkNull(rs.getString("FILT_POS"));
					String filt_title = checkNull(rs.getString("TITLE"));
					String chg_date = checkNull(rs.getString("CHG_DATE"));
					String chg_user = checkNull(rs.getString("CHG_USER"));
					String chg_term = checkNull(rs.getString("CHG_TERM"));

					if ( checkNull(user_id).equalsIgnoreCase(userId) || checkNull(user_id).equalsIgnoreCase("x") )
					{
						String filtTitle = "";
						if ( expr_type.equalsIgnoreCase("E") )
						{
							String[] exprValues = checkNull(expr_value).split(",");
							String[] exprTitles = checkNull(filt_title).split(",");
							for ( int i = 0; i < exprValues.length; i++ )
							{
								if ( i < exprTitles.length )
								{
									filtTitle += checkNull(exprValues[i]) + ":" + checkNull(exprTitles[i]) + ",";
								}
								else
								{
									filtTitle += checkNull(exprValues[i]) + ":" + checkNull(exprValues[i]) + ",";
								}
							}
							filtTitle = filtTitle.substring(0, filtTitle.length() - 1);
						}

						xmlString.append("<DETAIL>\r\n");
						xmlString.append("<OBJ_NAME><![CDATA[" + obj_name + "]]></OBJ_NAME>\r\n");
						xmlString.append("<USER_ID><![CDATA[" + user_id + "]]></USER_ID>\r\n");
						xmlString.append("<FILT_NAME><![CDATA[" + filt_name + "]]></FILT_NAME>\r\n");
						xmlString.append("<EXPR_TYPE><![CDATA[" + expr_type + "]]></EXPR_TYPE>\r\n");
						if ( expr_type.equalsIgnoreCase("E") )
						{
							xmlString.append("<EXPR_VALUE><![CDATA[" + filtTitle + "]]></EXPR_VALUE>\r\n");
						}
						else
						{
							xmlString.append("<EXPR_VALUE><![CDATA[" + expr_value + "]]></EXPR_VALUE>\r\n");
						}
						xmlString.append("<FILT_GUI><![CDATA[" + filt_gui + "]]></FILT_GUI>\r\n");
						xmlString.append("<FILT_POS><![CDATA[" + filt_pos + "]]></FILT_POS>\r\n");
						xmlString.append("<EXPR_TITLE><![CDATA[" + filt_title + "]]></EXPR_TITLE>\r\n");
						xmlString.append("<CHG_DATE><![CDATA[" + chg_date + "]]></CHG_DATE>\r\n");
						xmlString.append("<CHG_USER><![CDATA[" + chg_user + "]]></CHG_USER>\r\n");
						xmlString.append("<CHG_TERM><![CDATA[" + chg_term + "]]></CHG_TERM>\r\n");
						xmlString.append("</DETAIL>\r\n");
					}
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				xmlString.append("</QUICK_FILTER>\r\n</ROOT>");

				returnString = xmlString.toString();
			}
		}
		catch (SQLException e)
		{
			returnString = e.getMessage();
			e.printStackTrace();
			throw new ITMException(e);
		}
		catch (Exception e)
		{
			returnString = e.getMessage();
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch( Exception e )
			{
				BaseLogger.log("0", null, null, "Exception :" + e.getMessage() );
				e.printStackTrace();
			}
		}
		BaseLogger.log("2", null, null,"returnString - ["+ returnString +"]");
		return returnString;
	}
	//Added by Prasad on 29/09/15 [Get Quick Filter Details - F15FSUN003] END

	//Added by Chetan Mahajan on 29-Sep-15 [Req id : F15FSUN008] [ For display attachement download and delete button on basis of user rights ] Start
	/**
	 * For getting user rights for delete attachement and download attachment
	 * @param docId
	 * @param userLevel
	 * @param profileId
	 * @param loginCode
	 * @param objName
	 * @param pkValues
	 * @param documentAddedBy
	 * @param transDB
	 * @return
	 * @throws RemoteException
	 * @throws ITMException
	 */
	@Override
	public String getDeleteDownloadRights(String docId, String userLevel, String profileId, String loginCode, String objName, String pkValues, String documentAddedBy, String transDB, UserInfoBean userInfo) throws RemoteException, ITMException
	{
		BaseLogger.log("2", null, null,"**********DBAccessEJB::getDeleteDownloadRights***************");
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		Connection conn = null;
		ConnDriver connDriver =  new ConnDriver();

		String sql = "";
		boolean isDeleteAuthorized = false;
		boolean isdownloadAuthorized = false;
		String attach_rights = "";
		String authStr = "";
		try
		{
			if( "0".equalsIgnoreCase( userLevel ) )
			{
				isDeleteAuthorized = true;
				isdownloadAuthorized = true;
			}
			// for other than user level 0
			else
			{
				conn = connDriver.getConnectDB(transDB);
				objName = objName.indexOf("w_")!= -1 ? objName.replace("w_", ""):objName;
				//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
				//sql=" SELECT ATTACH_RIGHTS FROM USER_RIGHTS WHERE PROFILE_ID = ? AND OBJ_NAME = ?";
				sql=" SELECT ATTACH_RIGHTS FROM USER_RIGHTS WHERE PROFILE_ID IN "+ E12GenericUtility.getFormattedProfileId(profileId)+" AND OBJ_NAME = ?";
				pStmt = conn.prepareStatement(sql);
				//pStmt.setString(1, profileId);
				pStmt.setString(1, objName);
				rs = pStmt.executeQuery();
				//if( rs.next() )
				while( rs.next() )
				{
					attach_rights = attach_rights + rs.getString("ATTACH_RIGHTS") == null ? "" : rs.getString("ATTACH_RIGHTS");
				}
				rs.close();
				rs = null;
				pStmt.close();
				pStmt = null;

				if(attach_rights != null)
				{
					attach_rights = attach_rights.trim();
				}
				if(loginCode != null)
				{
					loginCode = loginCode.trim();
				}
				BaseLogger.log("3", null, null,"ATTACH_RIGHTS = ["+ attach_rights +"] loginCode = ["+ loginCode +"]");

				String[] rightList = attach_rights.split(",");
				String deleteRights = "";
				String downloadRights = "";

				for(int i = 0; i < rightList.length; i++)
				{
					if( i == 0 )// either download or delete rights given
					{
						if(rightList[0].contains("W") || rightList[0].contains("w"))
						{
							downloadRights = rightList[0];
						}
						else
						{
							deleteRights = rightList[0];
						}
					}
					else if( i == 1 ) //Both delete and download rights given
					{
						deleteRights = rightList[0];
						downloadRights = rightList[1];
					}
				}

				boolean isAllAttachRights = ( deleteRights.indexOf("*") != -1 );
				boolean isSelf = isAllAttachRights ? true : loginCode.equals(documentAddedBy);
				boolean isConfirm = isAllAttachRights ? true : isConfirmed(objName, pkValues, transDB, userInfo);
				BaseLogger.log("3", null, null,"isSelf["+ isSelf +"]isConfirm["+ isConfirm +"]loginCode["+ loginCode +"]documentAddedBy["+ documentAddedBy +"]");
				//All attach rights : Can delete attachment - If attached by self or others ( and transaction is Confirmed or Unconfirmed ).
				if ( deleteRights.indexOf("*") != -1 )
				{
					isDeleteAuthorized = true;
					isdownloadAuthorized = true;
				}
				//Attach rights = 1 : Can delete attachment - which attached by Self - Unconfirmed.
				else if ( deleteRights.indexOf("1") != -1 )
				{
					isDeleteAuthorized = ( isSelf && !isConfirm ); // SELF UNCONFIRMED
				}
				//Attach rights = 2 : Can delete attachment - which attached by Self or Others - Unconfirmed.
				else if ( deleteRights.indexOf("2") != -1 )
				{
					isDeleteAuthorized = ( !isConfirm ); // ANY UNCONFIRMED
				}
				//Attach rights = 3 : Can delete attachment - which attached by Self - Unconfirmed or Confirmed.
				else if ( deleteRights.indexOf("3") != -1 )
				{
					isDeleteAuthorized = ( isSelf ); // SELF ALL
				}
				//Attach rights = 4 : Can delete attachment - which attached by Self - Unconfirmed or Confirmed.
				//										and - which attached by Others - Unconfirmed.
				else if ( deleteRights.indexOf("4") != -1 )
				{
					isDeleteAuthorized = ( isSelf && isConfirm ) || ( !isConfirm ); // SELF CONFIRMED or ANY UNCONFIRMED
				}
				//Comented and Changes by Prajyot on 29APR2015 [To revised Delete Attachment Rights based.]Ends

				BaseLogger.log("3", null, null," dowloadRights = "+downloadRights);
				//dowloadRights = w : Can download attachment - which attached by Self.
				if ( downloadRights.equals("w") )
				{
					isdownloadAuthorized = isSelf;
				}
				//dowloadRights = W : Can download attachment - which attached by Self and other.
				else if( downloadRights.equals("W") )
				{
					isdownloadAuthorized = true;
				}
			}
			authStr = isDeleteAuthorized+","+isdownloadAuthorized;
			BaseLogger.log("3", null, null,"In DBAccessEJB : isDeleteAuthorized = ["+isDeleteAuthorized+"] isdownloadAuthorized = ["+isdownloadAuthorized+"]");
		}
		catch (Exception ex)
		{
			BaseLogger.log("0", null, null,"In DBAccessEJB : deleteAttachmentAuth Exception "+ex.getMessage());
			ex.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
				if( conn != null && ! conn.isClosed() )
				{
					conn.close();
				}
			}
			catch(Exception e)
			{
				BaseLogger.log("0", null, null, "Exception : DBAccessEJB : finally : "+e.getMessage());
				throw new ITMException(e);
			}
		}
		return authStr;
	}
	//Added by Chetan Mahajan on 29-Sep-15 [Req id : F15FSUN008] [ For display attachement download and delete button on basis of user rights ] End

	//Added By Ajinkya Gopalkar on 21-OCT-15 [for getting site code for change site functionality ] Start

	//public String getSiteCodeDetails(String loginUserId) throws ITMException
	//Change by shrutika on 05-07-17 for Change Site functionality is not working in certain user rights
	@Override
	public String getSiteCodeDetails(String loginUserId ,String userLevel ,String profileId, String transDB, String fin_entity) throws ITMException
	{
		BaseLogger.log("2", null, null,"get SiteCode Details loginUserId["+loginUserId+"]");
		BaseLogger.log("2", null, null,"get SiteCode Details userLevel["+userLevel+"]");
		BaseLogger.log("2", null, null,"get SiteCode Details profileId["+profileId+"]");
		BaseLogger.log("2", null, null,"get SiteCode Details transDB["+transDB+"]");
		BaseLogger.log("2", null, null,"get SiteCode Details fin_entity["+fin_entity+"]");
		StringBuffer siteCodeDetailsBuff = new StringBuffer("");
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		Connection conn = null;
		ConnDriver connDriver =  new ConnDriver();
		try
		{
			conn = connDriver.getConnectDB(transDB);
			String sql = null;
			//Added by shrutika on 05-07-17 [Start] for Change Site functionality is not working in certain user rights
			String enterprise = getDBColumnValue("USERS", "ENTERPRISE", "CODE = '"+loginUserId+"'");
			BaseLogger.log("3", null, null,"get SiteCode Details enterprise["+enterprise+"]");
			if( "2".equalsIgnoreCase( userLevel ) )
			{
				sql = "SELECT * FROM USER_SITE WHERE USER_ID = ?";
				pStmt = conn.prepareStatement(sql);
				pStmt.setString(1, loginUserId);
			}
			//added by shrutika [Start] on 05-02-18 for enterprise related data.
			else if(( "0".equalsIgnoreCase( userLevel ) || "1".equalsIgnoreCase( userLevel )) && (E12GenericUtility.checkNull(enterprise).length() > 0))
			{
				//sql = "SELECT SITE_CODE,CITY,DESCR,FIN_ENTITY FROM SITE WHERE ENTERPRISE = ?";

				//Change by shrutika on 14-02-18 for display records according to the fin_entity.
				//Change by shrutika on 28-05-18 for display records according to order by city.
				/*sql = 	"SELECT SITE.SITE_CODE,SITE.CITY,SITE.DESCR,SITE.FIN_ENTITY," +
						"(CASE WHEN SITE.FIN_ENTITY='" + fin_entity + "'" + "THEN 1 ELSE 2 END) AS SRNO " +
						"FROM SITE WHERE SITE.ENTERPRISE = ?" + " ORDER BY SRNO,FIN_ENTITY,SITE_CODE";*/
				//Added by Pratheek on 28-01-19[ to get the facility code value in reports]-Start
				//sql = 	"SELECT SITE.SITE_CODE,SITE.CITY,SITE.DESCR,SITE.FIN_ENTITY," +
				sql = 	"SELECT SITE.SITE_CODE,SITE.CITY,SITE.DESCR,SITE.FIN_ENTITY,FACILITY_CODE," +
						"(CASE WHEN SITE.FIN_ENTITY='" + fin_entity + "'" + "THEN 1 ELSE 2 END) AS SRNO " +
						"FROM SITE WHERE SITE.ENTERPRISE = ?" + " ORDER BY SRNO,CITY,FIN_ENTITY";
				pStmt = conn.prepareStatement(sql);
				pStmt.setString(1, enterprise);
			}
			else
			{
				//sql = "SELECT SITE_CODE,CITY, FROM SITE";

				//Change by shrutika on 14-02-18 for display records according to the fin_entity.
				//Change by shrutika on 28-05-18 for display records according to order by city.
			/*	sql = 	"SELECT SITE.SITE_CODE,SITE.CITY,SITE.DESCR,SITE.FIN_ENTITY," +
						"(CASE WHEN SITE.FIN_ENTITY='" + fin_entity + "'" + "THEN 1 ELSE 2 END) AS SRNO " +
						"FROM SITE" + " ORDER BY SRNO,FIN_ENTITY,SITE_CODE";*/
				//Added by Pratheek on 28-01-19[ to get the facility code value in reports]-Start
				//sql = 	"SELECT SITE.SITE_CODE,SITE.CITY,SITE.DESCR,SITE.FIN_ENTITY," +
				sql = 	"SELECT SITE.SITE_CODE,SITE.CITY,SITE.DESCR,SITE.FIN_ENTITY,FACILITY_CODE," +
						"(CASE WHEN SITE.FIN_ENTITY='" + fin_entity + "'" + "THEN 1 ELSE 2 END) AS SRNO " +
						"FROM SITE" + " ORDER BY SRNO,CITY,FIN_ENTITY";

				pStmt = conn.prepareStatement(sql);
			}
			//added by shrutika [End] on 05-02-18  for enterprise related data.
			//Added by shrutika on 05-07-17 [End] for Change Site functionality is not working in certain user rights
			BaseLogger.log("3", null, null,"Sql getSiteCodeDetails[" + sql + "]");
			rs = pStmt.executeQuery();
			ResultSetMetaData rsmd = rs.getMetaData();
			int colCount = rsmd.getColumnCount();
			BaseLogger.log("3", null, null,"no of column : "+colCount);
			if( rs.next() )
			{
				siteCodeDetailsBuff.append("<Root>");
				do
				{
					siteCodeDetailsBuff.append("<USER_SITE>");
					for(int colNo = 1; colNo <= colCount; colNo++)
					{
						String colName = checkNull( rsmd.getColumnName(colNo) ).toUpperCase();
						String colValue = checkNull( rs.getString(colNo) );
						siteCodeDetailsBuff.append("<"+colName+">").append("<![CDATA[" + colValue + "]]>").append("</"+colName+">");
						//Added by shrutika on 05-07-17 [Start] for Change Site functionality is not working in certain user rights
						if( "2".equalsIgnoreCase( userLevel ))
						{
							//For Column Name ENTITY_CODE
							if("SITE_CODE".equalsIgnoreCase(colName))
							{
								String tableName = "SITE";
								String selectColName = "CITY";
								String whereColName = "";
								String selectColValue = getDBColumnValue("SITE", "CITY", "SITE_CODE" + " = '" + colValue + "' ", transDB);
								String siteDescription = getDBColumnValue("SITE", "DESCR", "SITE_CODE" + " = '" + colValue + "' ", transDB);
								//siteCodeDetailsBuff.append("<SITE_DESCR>").append("<![CDATA[" + selectColValue + "]]>").append("</SITE_DESCR>");
								//added by shrutika [Start] on 05-02-18 for getting city and site description in case of change site.
								siteCodeDetailsBuff.append("<CITY>").append("<![CDATA[" + selectColValue + "]]>").append("</CITY>");
								siteCodeDetailsBuff.append("<SITE_DESCR>").append("<![CDATA[" + siteDescription + "]]>").append("</SITE_DESCR>");
								//added by shrutika [End] on 05-02-18 for getting city and site description in case of change site.

								//shrutika 14-02-18
								//Added by shrutika [Start] on 14-02-18 for getting fin_entity value when login or change the site code.
								String getfin_entity = getDBColumnValue("SITE", "FIN_ENTITY", "SITE_CODE" + " = '" + colValue + "' ", transDB);
								siteCodeDetailsBuff.append("<FIN_ENTITY>").append("<![CDATA[" + getfin_entity + "]]>").append("</FIN_ENTITY>");
								//Added by shrutika [End] on 14-02-18 for getting fin_entity value when login or change the site code.
								//Added by shrutika [Start] on 14-02-18 for getting PROFILE_ID value when login or change the site code.
								String condition = "USER_ID = '"+ loginUserId +"' AND SITE_CODE = '"+ colValue +"'";
								profileId = getDBColumnValue("USER_SITE", "PROFILE_ID", condition, transDB);
								//Added By Pankaj T. on 05-03-2020 As suggested By SM Sir to get the profile_id from user_site table and if not found then get from users table: START
								BaseLogger.log("3", null, null,"DBAccessEJB.getSiteCodeDetails() USER_SITE profileId:["+profileId+"]");
								if("".equals(E12GenericUtility.checkNull(profileId)))
								{
									condition = "CODE = '"+ loginUserId +"'";
									profileId = getDBColumnValue("USERS", "PROFILE_ID", condition);
									BaseLogger.log("3", null, null,"DBAccessEJB.getSiteCodeDetails() USERS profileId:["+profileId+"]");
								}
								//Added By Pankaj T. on 05-03-2020 As suggested By SM Sir to get the profile_id from user_site table and if not found then get from users table: END
								siteCodeDetailsBuff.append("<PROFILE_ID>").append("<![CDATA[" + profileId + "]]>").append("</PROFILE_ID>");
								//Added by shrutika [End] on 14-02-18 for getting PROFILE_ID value when login or change the site code.
								//Added by Pratheek on 28-01-19[ to show the facility code value in userInfo xml]-Start
								String getfacility_code = getDBColumnValue("SITE", "FACILITY_CODE", "SITE_CODE" + " = '" + colValue + "' ", transDB);
								siteCodeDetailsBuff.append("<FACILITY_CODE>").append("<![CDATA[" + getfacility_code + "]]>").append("</FACILITY_CODE>");
								//Added by Pratheek on 28-01-19[ to show the facility code value in userInfo xml ]-End
							}
						}
						else
						{
							if("SITE_CODE".equalsIgnoreCase(colName))
							{
								String selectColValue = checkNull( rs.getString(2) );
								String siteDescription = checkNull( rs.getString(3) );
								//Added By Pankaj T. on 05-03-2020 As suggested By SM Sir to get the profile_id from user_site table and if not found then get from users table: START
								if( "1".equalsIgnoreCase( userLevel ))
								{
									String condition = "USER_ID = '"+ loginUserId +"' AND SITE_CODE = '"+ colValue +"'";
									profileId = getDBColumnValue("USER_SITE", "PROFILE_ID", condition, transDB);
									BaseLogger.log("3", null, null,"DBAccessEJB.getSiteCodeDetails() USER_SITE profileId:["+profileId+"]");
									if("".equals(E12GenericUtility.checkNull(profileId)))
									{
										condition = "CODE = '"+ loginUserId +"'";
										profileId = getDBColumnValue("USERS", "PROFILE_ID", condition);
										BaseLogger.log("3", null, null,"DBAccessEJB.getSiteCodeDetails() USERS profileId:["+profileId+"]");
									}
								}
								//Added By Pankaj T. on 05-03-2020 As suggested By SM Sir to get the profile_id from user_site table and if not found then get from users table: END
								siteCodeDetailsBuff.append("<PROFILE_ID>").append("<![CDATA[" + profileId + "]]>").append("</PROFILE_ID>");
								//siteCodeDetailsBuff.append("<SITE_DESCR>").append("<![CDATA[" + selectColValue + "]]>").append("</SITE_DESCR>");
								//added by shrutika [Start] on 05-02-18 for getting city and site description in case of change site.
								siteCodeDetailsBuff.append("<CITY>").append("<![CDATA[" + selectColValue + "]]>").append("</CITY>");
								siteCodeDetailsBuff.append("<SITE_DESCR>").append("<![CDATA[" + siteDescription + "]]>").append("</SITE_DESCR>");
								//added by shrutika [End] on 05-02-18 for getting city and site description in case of change site.

								//Added by shrutika [Start] on 14-02-18 for getting fin_entity value when login or change the site code.
								String getfin_entity = checkNull( rs.getString(4) );
								//Added by Pratheek on 01-02-19[ to get facility_code value and pass the value to UserInfo ]-Start
								String getfacility_code = checkNull( rs.getString(5) );
								siteCodeDetailsBuff.append("<FIN_ENTITY>").append("<![CDATA[" + getfin_entity + "]]>").append("</FIN_ENTITY>");
								siteCodeDetailsBuff.append("<FACILITY_CODE>").append("<![CDATA[" + getfacility_code+"]]>").append("</FACILITY_CODE>");
								//Added by Pratheek on 01-02-19[ to get facility_code value and pass the value to UserInfo ]-End
								//Added by shrutika [End] on 14-02-18 for getting fin_entity value when login or change the site code.
							}
						}
						//Added by shrutika on 05-07-17 [End] for Change Site functionality is not working in certain user rights
					}
					siteCodeDetailsBuff.append("</USER_SITE>");
				}
				while( rs.next() );
				siteCodeDetailsBuff.append("</Root>");
			}

			rs.close();
			rs = null;
			pStmt.close();
			pStmt = null;
		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null,"Exception in getEntityContactDetails ["+e.getMessage()+"]");
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
				if( conn != null && ! conn.isClosed() )
				{
					conn.close();
				}
			}
			catch(Exception e)
			{
				BaseLogger.log("0", null, null, "Exception : DBAccessEJB : getSiteCodeDetails()"+e.getMessage());
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2", null, null,"Return from getSiteCodeDetails [" + siteCodeDetailsBuff.toString().length() + "]");
		return siteCodeDetailsBuff.toString();
	}
	//Added By Ajinkya Gopalkar on 21-OCT-15 [for getting site code for change site functionality ] End

	//Added by Prasad on 18/06/15 [SSC transaction - adding new object type 'A' and 'C'] START
	/**
	 * get objType of object name
	 * @param objName
	 * @return
	 * @throws ITMException
	 */
	@Override
	public String getObjType(String objName, String transDB) throws ITMException
	{
		String objType = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB(transDB);
			connDriver = null;

			String winName = "w_"+objName;
			String sql = "SELECT OBJ_TYPE FROM ITM2MENU WHERE WIN_NAME = ?";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, winName);

			rs = pstmt.executeQuery();
			while (rs.next())
			{
				objType = rs.getString(1);
			}
			rs.close(); rs = null;
			pstmt.close(); pstmt = null;
			BaseLogger.log("3", null, null,"OBJ_TYPE : ["+ objType +"]");
		}
		catch (SQLException e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				conn.close();
			}
			catch (SQLException e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return objType;
	}

	/**
	 * get documentId from doc_transaction link table
	 * @param objName
	 * @param tranId
	 * @return
	 * @throws ITMException
	 */
	 //Changed by Pankaj T on 04-01-18 [changes for multitenancy]
	@Override
	public String getDocTransactionLinkDocId(String objName, String tranId, UserInfoBean userInfo) throws ITMException
	{
		String docId = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String transDB = "";
		try
		{
			ConnDriver connDriver = new ConnDriver();
			transDB = userInfo.getTransDB();
			conn = connDriver.getConnectDB(transDB);
			connDriver = null;

			String refSer = getRefSer( conn, objName );

			String sql = "SELECT DOC_ID||':'||DOC_TYPE DOC_CONTENTS_DTL "
					+ " FROM DOC_CONTENTS "
					+ " WHERE DOC_ID IN (SELECT DOC_ID FROM DOC_TRANSACTION_LINK WHERE REF_ID = '"+ tranId +"' AND REF_SER = '"+ refSer +"')";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				docId += rs.getString(1).trim() + ",";
			}
			rs.close(); rs = null;
			pstmt.close(); pstmt = null;
			if ( docId.trim().length() > 1 )
			{
				docId = docId.substring( 0, docId.trim().length()-1 );
			}
			BaseLogger.log("3", null, null,"DOC_CONTENTS_DTL : ["+ docId +"]");
		}
		catch (RemoteException e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		catch (ITMException e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		catch (NamingException e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				conn.close();
			}
			catch (SQLException e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return docId;
	}
	//Added by Prasad on 18/06/15 [SSC transaction - adding new object type 'A' and 'C'] END

	//Added by Prasad on 18/06/15 [get OBJ_ATTACH_CONFIG details- W15BSUN010] START
	/**
	 * Return Attach isConfig for provided object name
	 * @param objName
	 * @return
	 * @throws ITMException
	 */
	@Override
	public boolean isAttachConfig(String objName, String transDB) throws ITMException
	{
		boolean isAttachConfig = false;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB(transDB);
			connDriver = null;

			//Changed by Prasad on 14/01/16 [getting issue of append] START
			/*String sql = "SELECT COUNT(*) FROM OBJ_ATTACH_CONFIG, TRANSETUP " +
					" WHERE LOWER('w_'||OBJ_ATTACH_CONFIG.OBJ_NAME) = LOWER(TRANSETUP.TRAN_WINDOW) " +
					" AND TRANSETUP.REF_SER IS NOT NULL " +
					" AND OBJ_ATTACH_CONFIG.OBJ_NAME = ? ";*/
			String winName = "w_"+objName;
			String sql = "SELECT DOC_TYPE, (SELECT REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ?) REFSER "
					+ " FROM OBJ_ATTACH_CONFIG "
					+ " WHERE OBJ_NAME = ?";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, winName);
			pstmt.setString(2, objName);

			rs = pstmt.executeQuery();
			String docType = "", refSer = "";
			if (rs.next())
			{
				/*if ( rs.getInt(1) > 0 )
				{
					isAttachConfig = true;
				}*/
				docType = checkNull( rs.getString(1) );
				refSer = checkNull( rs.getString(2) );
			}
			/*--Commented by Nilesh and moved to
			rs.close(); rs = null;
			pstmt.close(); pstmt = null;
			*/
			if ( docType.length() > 0 && refSer.length() > 0 )
			{
				isAttachConfig = true;
			}
			//Changed by Prasad on 14/01/16 [getting issue of append] END
			BaseLogger.log("3", null, null,"isAttachConfig : ["+ isAttachConfig +"]");
		}
		catch (SQLException e)
		{
			isAttachConfig = false;
			e.printStackTrace();
			throw new ITMException(e);
		}
		catch (Exception e)
		{
			isAttachConfig = false;
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				//Added By Nilesh Start ::01-06-2017
				if(rs!=null)
				{
					rs.close();
					rs=null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt=null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
				//Added By Nilesh End ::01-06-2017
			}
			catch (SQLException e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return isAttachConfig;
	}

	/**
	 * Get TranId wise Attachment Details
	 * @param objName
	 * @param tranId
	 * @return
	 * @throws ITMException
	 */
	@Override
	public String getObjAttachConfigDtl(String objName, String tranId, UserInfoBean userInfo, String editFlag) throws ITMException
	{
		StringBuffer xmlString = new StringBuffer();
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try
		{
			ConnDriver connDriver = new ConnDriver();
			String transDB = userInfo.getTransDB();
			conn = connDriver.getConnectDB(transDB);
			connDriver = null;
			//Added by Prasad on 08/01/16 [show thumbnail of images and valiadtaion of minimun attachment - W15HSUN008] START
			E12GenericUtility genericUtility = new E12GenericUtility();
			//DocumentHandlerRemote docHandler = (DocumentHandlerRemote) getInitialContext().lookup("ibase/DocumentHandlerEJB/remote");
			DocumentHandlerEJB docHandler = new DocumentHandlerEJB();

			String winName = "w_"+ objName;
			xmlString.append("<ROOT>\r\n<OBJ_ATTACH_CONFIG>\r\n");

			String sql = "";
			//Changed by Prasad on 04/01/16 [change doc_type to DOC_TYPE_ATTACH and file_type to FILE_TYPE_ATTACH] START
			if ( "A".equalsIgnoreCase( editFlag ) )
			{
				sql = "SELECT OBJ_ATTACH_CONFIG.DOC_TYPE, '' AS DOC_ID, '' AS DOC_NAME, OBJ_ATTACH_CONFIG.FILE_TYPE, " +
						" OBJ_ATTACH_CONFIG.MIN_ATTACH_REQ AS MIN_ATTACH, OBJ_ATTACH_CONFIG.MIN_ATTACH_REQ, " +
						" OBJ_ATTACH_CONFIG.MAX_ATTACH_ALLOW, " +
						" OBJ_ATTACH_CONFIG.ATTACH_MODE, OBJ_ATTACH_CONFIG.REMARKS, " +
						" OBJ_ATTACH_CONFIG.CHG_DATE, OBJ_ATTACH_CONFIG.CHG_USER, OBJ_ATTACH_CONFIG.CHG_TERM " +
						" FROM OBJ_ATTACH_CONFIG " +
						" WHERE OBJ_ATTACH_CONFIG.OBJ_NAME = ? " +
						" ORDER BY DOC_TYPE, DOC_ID ";

				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, objName);
			}
			else if ( "E".equalsIgnoreCase( editFlag ) )
			{
				//docHandler = (DocumentHandlerRemote) getInitialContext().lookup("ibase/DocumentHandlerEJB/remote");

				sql = "SELECT DOC_TRANSACTION_LINK.DOC_TYPE_ATTACH AS DOC_TYPE, DOC_CONTENTS.DOC_ID, DOC_CONTENTS.DOC_NAME, DOC_TRANSACTION_LINK.FILE_TYPE_ATTACH AS FILE_TYPE, " +
						" 1 AS MIN_ATTACH, OBJ_ATTACH_CONFIG.MIN_ATTACH_REQ, OBJ_ATTACH_CONFIG.MAX_ATTACH_ALLOW, OBJ_ATTACH_CONFIG.ATTACH_MODE, OBJ_ATTACH_CONFIG.REMARKS, " +
						" DOC_CONTENTS.CHG_DATE, DOC_CONTENTS.CHG_USER, DOC_CONTENTS.CHG_TERM " +
						" FROM DOC_TRANSACTION_LINK " +
						" LEFT OUTER JOIN OBJ_ATTACH_CONFIG ON TRIM(OBJ_ATTACH_CONFIG.DOC_TYPE) = TRIM(DOC_TRANSACTION_LINK.DOC_TYPE_ATTACH) " +
						" AND OBJ_ATTACH_CONFIG.OBJ_NAME = ? " +
						" INNER JOIN DOC_CONTENTS ON DOC_TRANSACTION_LINK.DOC_ID = DOC_CONTENTS.DOC_ID " +
						" WHERE TRIM(DOC_TRANSACTION_LINK.REF_SER) = ( SELECT TRIM(REF_SER) FROM TRANSETUP WHERE TRAN_WINDOW = ? ) " +
						" AND DOC_TRANSACTION_LINK.REF_ID = ? " +
						" UNION ALL " +
						" SELECT OBJ_ATTACH_CONFIG.DOC_TYPE, '' AS DOC_ID, '' AS DOC_NAME, OBJ_ATTACH_CONFIG.FILE_TYPE, " +
						" ( OBJ_ATTACH_CONFIG.MIN_ATTACH_REQ - (SELECT COUNT(*) FROM DOC_TRANSACTION_LINK " +
						" WHERE TRIM(DOC_TRANSACTION_LINK.REF_SER) = ( SELECT TRIM(REF_SER) FROM TRANSETUP WHERE TRAN_WINDOW = ? ) " +
						" AND DOC_TRANSACTION_LINK.REF_ID = ? AND TRIM(DOC_TRANSACTION_LINK.DOC_TYPE_ATTACH) = TRIM(OBJ_ATTACH_CONFIG.DOC_TYPE)) ) AS MIN_ATTACH, " +
						" OBJ_ATTACH_CONFIG.MIN_ATTACH_REQ," +
						" OBJ_ATTACH_CONFIG.MAX_ATTACH_ALLOW, " +
						" OBJ_ATTACH_CONFIG.ATTACH_MODE, OBJ_ATTACH_CONFIG.REMARKS, " +
						" OBJ_ATTACH_CONFIG.CHG_DATE, OBJ_ATTACH_CONFIG.CHG_USER, OBJ_ATTACH_CONFIG.CHG_TERM " +
						" FROM OBJ_ATTACH_CONFIG " +
						" WHERE OBJ_ATTACH_CONFIG.OBJ_NAME = ? " +
						" ORDER BY DOC_TYPE, DOC_ID ";

				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, objName);
				pstmt.setString(2, winName);
				pstmt.setString(3, tranId);
				pstmt.setString(4, winName);
				pstmt.setString(5, tranId);
				pstmt.setString(6, objName);
			}
			else if ( "V".equalsIgnoreCase( editFlag ) )
			{
				sql = "SELECT DOC_TRANSACTION_LINK.DOC_TYPE_ATTACH AS DOC_TYPE, DOC_CONTENTS.DOC_ID, DOC_CONTENTS.DOC_NAME, DOC_TRANSACTION_LINK.FILE_TYPE_ATTACH AS FILE_TYPE, " +
						" 1 AS MIN_ATTACH, OBJ_ATTACH_CONFIG.MIN_ATTACH_REQ, OBJ_ATTACH_CONFIG.MAX_ATTACH_ALLOW, OBJ_ATTACH_CONFIG.ATTACH_MODE, OBJ_ATTACH_CONFIG.REMARKS, " +
						" DOC_CONTENTS.CHG_DATE, DOC_CONTENTS.CHG_USER, DOC_CONTENTS.CHG_TERM " +
						" FROM DOC_TRANSACTION_LINK " +
						" LEFT OUTER JOIN OBJ_ATTACH_CONFIG ON TRIM(OBJ_ATTACH_CONFIG.DOC_TYPE) = TRIM(DOC_TRANSACTION_LINK.DOC_TYPE_ATTACH) " +
						" AND OBJ_ATTACH_CONFIG.OBJ_NAME = ? " +
						" INNER JOIN DOC_CONTENTS ON DOC_TRANSACTION_LINK.DOC_ID = DOC_CONTENTS.DOC_ID " +
						" WHERE TRIM(DOC_TRANSACTION_LINK.REF_SER) = ( SELECT TRIM(REF_SER) FROM TRANSETUP WHERE TRAN_WINDOW = ? ) " +
						" AND DOC_TRANSACTION_LINK.REF_ID = ? " +
						" ORDER BY DOC_TYPE, DOC_ID ";

				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, objName);
				pstmt.setString(2, winName);
				pstmt.setString(3, tranId);
			}
			//Changed by Prasad on 04/01/16 [change doc_type to DOC_TYPE_ATTACH and file_type to FILE_TYPE_ATTACH] END

			int count = 0;
			if ( checkNull( sql ).length() > 0 && pstmt != null )
			{
				rs = pstmt.executeQuery();
				while (rs.next())
				{
					count++;
					String doc_type = checkNull( rs.getString("DOC_TYPE") );
					String doc_id 	= checkNull( rs.getString("DOC_ID") );
					String doc_name = checkNull( rs.getString("DOC_NAME") );
					String file_type = checkNull( rs.getString("FILE_TYPE") );
					String minAttach = checkNull( rs.getString("MIN_ATTACH") );
					String minAttachReq = checkNull( rs.getString("MIN_ATTACH_REQ") );
					String max_attach_allow = checkNull( rs.getString("MAX_ATTACH_ALLOW") );
					String attach_mode = checkNull( rs.getString("ATTACH_MODE") );
					String remarks 	= checkNull( rs.getString("REMARKS") );
					String chg_date = checkNull( rs.getString("CHG_DATE") );
					String chg_user = checkNull( rs.getString("CHG_USER") );
					String chg_term = checkNull( rs.getString("CHG_TERM") );
					if ( chg_date.length() > 0 )
					{
						chg_date = genericUtility.getValidDateTimeString( chg_date, genericUtility.getDBDateTimeFormat(),
								genericUtility.getApplDateFormat() );
					}
					String isDeleteAuth = "false";
					String isDownloadAuth = "false";
					String filePath = "";

					//Changed by Prasad on 08/01/16 [check less than min_attach_req value - W15HSUN008]
					//if ( ! "0".equalsIgnoreCase( min_attach_req ) )
					if ( minAttach.length() > 0 && Integer.parseInt(minAttach) > 0 )
					{
						if ( doc_id.length() > 0 )
						{
							if ( userInfo != null && "E".equalsIgnoreCase( editFlag ) )
							{
								String userLevel = checkNull( userInfo.getUserLevel() );
								String profileId = checkNull( userInfo.getProfileId() );
								String loginCode = checkNull( userInfo.getLoginCode() );
								String authStr = "";
								if( docHandler != null && checkNull( tranId ).length() > 0 && checkNull( doc_id ).length() > 0 )
								{
									String addedByUserId = docHandler.docAddedBy( doc_id, transDB );
									authStr = getDeleteDownloadRights(doc_id, userLevel, profileId, loginCode, objName, tranId, addedByUserId, userInfo.getTransDB(), userInfo);
									BaseLogger.log("3", null, null,"Delete and download rights = [" + authStr +"]");
									if ( checkNull( authStr ).indexOf( "," ) != -1 )
									{
										String[] allUserRights = authStr.split(",");
										isDeleteAuth = allUserRights[0];
										isDownloadAuth = allUserRights[1];
									}
								}
							}

							//Added by Prasad on 08/01/16 [show thumbnail of images - W15HSUN008] START
							if( docHandler != null && checkNull( doc_id ).length() > 0 )
							{
								//Added by Prasad on 25/05/18 [CONTENT_MGMT related changes]
								//byte[] byteArray = docHandler.getDocument(doc_id, userInfo.getTransDB());
								byte[] byteArray = docHandler.getDocument( doc_id, userInfo );
								BaseLogger.log("3", null, null,"docId = ["+ doc_id +"] docName = ["+ doc_name +"] - userInfo = ["+ userInfo.getSesstionId() +"]");
								if (byteArray != null)
								{
									try
									{
										filePath = "Downloads";
										if ( userInfo != null )
										{
											String userId = checkNull( userInfo.getLoginCode() );
											String sessionId = checkNull( userInfo.getSesstionId() );
											filePath = "temp"+ File.separator + userId + sessionId;
										}
										String documentPath = CommonConstants.APPLICATION_CONTEXT + filePath;
										File outFile = new File( documentPath );
										if ( ! outFile.exists() )
										{
											outFile.mkdir();
										}
										if ( checkNull( doc_name ).length() > 0 )
										{
											outFile = new File( documentPath + File.separator + doc_name );
											FileOutputStream fout = new FileOutputStream(outFile);
											IOUtils.write(byteArray, fout);
											fout.close();
										}
										else
										{
											BaseLogger.log("3", null, null,"Document Name is empty.");
										}
									}
									catch (Exception e)
									{
										e.printStackTrace();
									}
								}
							}
							//Added by Prasad on 08/01/16 [show thumbnail of images - W15HSUN008] END

							xmlString.append("<DETAIL attach_id='"+ count +"'>\r\n");
							xmlString.append("<OBJ_NAME><![CDATA[" + objName + "]]></OBJ_NAME>\r\n");
							xmlString.append("<DOC_TYPE><![CDATA[" + doc_type + "]]></DOC_TYPE>\r\n");
							xmlString.append("<DOC_ID><![CDATA[" + doc_id + "]]></DOC_ID>\r\n");
							xmlString.append("<DOC_NAME><![CDATA[" + doc_name + "]]></DOC_NAME>\r\n");
							xmlString.append("<FILE_TYPE><![CDATA[" + file_type + "]]></FILE_TYPE>\r\n");
							xmlString.append("<MIN_ATTACH><![CDATA[" + minAttach + "]]></MIN_ATTACH>\r\n");
							xmlString.append("<MIN_ATTACH_REQ><![CDATA[" + minAttachReq + "]]></MIN_ATTACH_REQ>\r\n");
							xmlString.append("<MAX_ATTACH_ALLOW><![CDATA[" + max_attach_allow + "]]></MAX_ATTACH_ALLOW>\r\n");
							xmlString.append("<ATTACH_MODE><![CDATA[" + attach_mode + "]]></ATTACH_MODE>\r\n");
							xmlString.append("<REMARKS><![CDATA[" + remarks + "]]></REMARKS>\r\n");
							xmlString.append("<DELETE_RIGHT><![CDATA[" + isDeleteAuth + "]]></DELETE_RIGHT>\r\n");
							xmlString.append("<DOWNLOAD_RIGHT><![CDATA[" + isDownloadAuth + "]]></DOWNLOAD_RIGHT>\r\n");
							xmlString.append("<DOWNLOADED_PATH><![CDATA[" + filePath + "]]></DOWNLOADED_PATH>\r\n");
							xmlString.append("<CHG_DATE><![CDATA[" + chg_date + "]]></CHG_DATE>\r\n");
							xmlString.append("<CHG_USER><![CDATA[" + chg_user + "]]></CHG_USER>\r\n");
							xmlString.append("<CHG_TERM><![CDATA[" + chg_term + "]]></CHG_TERM>\r\n");
							xmlString.append("</DETAIL>\r\n");
						}
						else
						{
							int min_attach = Integer.parseInt(minAttach);
							for ( int i = 0; i < min_attach; i++ )
							{
								xmlString.append("<DETAIL attach_id='"+ count +"'>\r\n");
								xmlString.append("<OBJ_NAME><![CDATA[" + objName + "]]></OBJ_NAME>\r\n");
								xmlString.append("<DOC_TYPE><![CDATA[" + doc_type + "]]></DOC_TYPE>\r\n");
								xmlString.append("<DOC_ID><![CDATA[" + doc_id + "]]></DOC_ID>\r\n");
								xmlString.append("<DOC_NAME><![CDATA[" + doc_name + "]]></DOC_NAME>\r\n");
								xmlString.append("<FILE_TYPE><![CDATA[" + file_type + "]]></FILE_TYPE>\r\n");
								xmlString.append("<MIN_ATTACH><![CDATA[" + minAttach + "]]></MIN_ATTACH>\r\n");
								xmlString.append("<MIN_ATTACH_REQ><![CDATA[" + minAttachReq + "]]></MIN_ATTACH_REQ>\r\n");
								xmlString.append("<MAX_ATTACH_ALLOW><![CDATA[" + max_attach_allow + "]]></MAX_ATTACH_ALLOW>\r\n");
								xmlString.append("<ATTACH_MODE><![CDATA[" + attach_mode + "]]></ATTACH_MODE>\r\n");
								xmlString.append("<REMARKS><![CDATA[" + remarks + "]]></REMARKS>\r\n");
								xmlString.append("<DELETE_RIGHT><![CDATA[" + isDeleteAuth + "]]></DELETE_RIGHT>\r\n");
								xmlString.append("<DOWNLOAD_RIGHT><![CDATA[" + isDownloadAuth + "]]></DOWNLOAD_RIGHT>\r\n");
								xmlString.append("<DOWNLOADED_PATH><![CDATA[" + filePath + "]]></DOWNLOADED_PATH>\r\n");
								xmlString.append("<CHG_DATE><![CDATA[" + chg_date + "]]></CHG_DATE>\r\n");
								xmlString.append("<CHG_USER><![CDATA[" + chg_user + "]]></CHG_USER>\r\n");
								xmlString.append("<CHG_TERM><![CDATA[" + chg_term + "]]></CHG_TERM>\r\n");
								xmlString.append("</DETAIL>\r\n");

								if ( i < min_attach - 1 )
								{
									count++;
								}
							}
						}
					}
				}
				rs.close(); rs = null;
				pstmt.close(); pstmt = null;
				String attachCountMin = checkNull( getDBColumnValue( "TRANSETUP", "ATTACH_COUNT_MIN", " TRAN_WINDOW = '"+ winName +"'", userInfo.getTransDB() ) );
				attachCountMin = attachCountMin.length() > 0 ? attachCountMin : "0";
				xmlString.append("<ATTACH_COUNT_MIN><![CDATA[" + attachCountMin + "]]></ATTACH_COUNT_MIN>\r\n");
				xmlString.append("<EDIT_FLAG><![CDATA[" + editFlag + "]]></EDIT_FLAG>\r\n");
				//Added by Prasad on 08/01/16 [show thumbnail of images and valiadtaion of minimun attachment - W15HSUN008] END
			}
			if ( count == 0 )
			{
				StringBuffer dataNotFoundStr = new StringBuffer("<DETAIL><![CDATA[No Data Found]]></DETAIL>");
				xmlString.append( dataNotFoundStr );
			}
			xmlString.append("</OBJ_ATTACH_CONFIG>\r\n</ROOT>");

			BaseLogger.log("3", null, null,"xmlString : ["+ xmlString.toString() +"]");
		}
		catch (SQLException e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				conn.close();
				conn = null;
			}
			catch (SQLException e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return xmlString.toString();
	}
	//Added by Prasad on 18/06/15 [get OBJ_ATTACH_CONFIG details- W15BSUN010] END

	//Added by Prajyot [For update any table by passing table name, column name, column value and where condition] START
	public void updateTableColumnValue(String tableName, String columnName, String columnValue, String whereCondition, String transDB) throws ITMException
	{
		PreparedStatement pStamt = null;
		Connection conn = null;
		try
		{
			BaseLogger.log("3", null, null,"In updateTableColumnValue - tableName = ["+ tableName +"] columnName  ["+ columnName +"] " +
					"columnValue = ["+ columnValue +"] whereCondition = ["+ whereCondition +"]");

			ConnDriver mConnDriver = new ConnDriver();
			conn = mConnDriver.getConnectDB( transDB );
			String query = "UPDATE "+ tableName +" SET " + columnName + " = '" + columnValue + "' WHERE "+ whereCondition +" ";

			pStamt = conn.prepareStatement( query );
			int updateCnt = pStamt.executeUpdate();
			BaseLogger.log("3", null, null,"updateCnt = [" + updateCnt + "]");
		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null,"Exception : DBAccessEJB : updateTableColumnValue :"+e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( pStamt != null )
				{
					pStamt.close();
					pStamt = null;
				}
				if( conn != null )
				{
					conn.commit();
					conn.close();
					conn = null;
				}
			}
			catch( Exception e )
			{
				BaseLogger.log("0", null, null, "In DBAccessEJB updateTableColumnValue Exception :" + e.getMessage() );
				e.printStackTrace();
			}
		}
	}
	//Added by Prajyot [For update any table by passing table name, column name, column value and where condition] END

	//Added by Prasad on 01/03/16 [for creating log of accessing web service] START
	/**
	 * creating log of accessing web service
	 *
	 * @param tokenId
	 * @param action
	 * @param params
	 * @param responseType
	 * @param response
	 * @param requestedTerm
	 * @param requestedUser
	 * @param userInfo
	 * @return
	 * @throws ITMException
	 */
	@Override
	public String createExtServiceLog(String tokenId, String action, String params, String responseType, String response, String requestedTerm, String requestedUser, UserInfoBean userInfo) throws ITMException
	{
		String returnString = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		try
		{
			BaseLogger.log("3", null, null,"In createExtServiceLog - \ntokenId - ["+ tokenId +"], \naction - ["+ action +"], \nparams - ["+ params +"]");
			ConnDriver connDriver = new ConnDriver();
			String transDB = "";
			if ( userInfo != null )
			{
				transDB = checkNull( userInfo.getTransDB() );
			}
			if( transDB.length() > 0 )
			{
				conn = connDriver.getConnectDB( transDB );
			}

			conn.setAutoCommit(false);
			connDriver = null;

			String tranId = "";
			String seqQuery = "SELECT EXT_SERVICE_LOG_SEQ.NEXTVAL FROM DUAL";
			pstmt = conn.prepareStatement( seqQuery );
			ResultSet rs = pstmt.executeQuery();
			if( rs.next() )
			{
				tranId = rs.getString(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			String sql = "INSERT INTO EXT_SERVICE_LOG (TRAN_ID, TOKEN_ID, ACTION, PARAM, RESPONSE_TYPE, RESPONSE, REQ_ON, REQ_BY, REQ_TERM) "
					+ " VALUES (?, ?, ?, EMPTY_BLOB(), ?, EMPTY_BLOB(), ?, ?, ?)";
			int insertCnt = 0;
			if( "mysql".equalsIgnoreCase( CommonConstants.DB_NAME ) )
			{
				sql = "INSERT INTO EXT_SERVICE_LOG (TRAN_ID, TOKEN_ID, ACTION, PARAM, RESPONSE_TYPE, RESPONSE, REQ_ON, REQ_BY, REQ_TERM) "
						+ " VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";

				byte[] paramsArray = (params != null ? params.getBytes() : null );
				ByteArrayInputStream paramsByteArray = (paramsArray != null ? new ByteArrayInputStream( paramsArray ) : null );

				byte[] responseArray = (response != null ? response.getBytes() : null );
				ByteArrayInputStream responseByteArray = (responseArray != null ? new ByteArrayInputStream( responseArray ) : null );

				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				pstmt.setString(2, tokenId);
				pstmt.setString(3, action);
				if(paramsByteArray != null )
				{
					pstmt.setBinaryStream(4, paramsByteArray, paramsByteArray.available());
				}
				else
				{
					pstmt.setBinaryStream(4, null, 0);
				}
				pstmt.setString(5, responseType);
				if(responseByteArray != null )
				{
					pstmt.setBinaryStream(6, responseByteArray, responseByteArray.available());
				}
				else
				{
					pstmt.setBinaryStream(6, null, 0);
				}
				pstmt.setTimestamp(7, new java.sql.Timestamp(System.currentTimeMillis()));
				pstmt.setString(8, requestedUser );
				pstmt.setString(9, requestedTerm );
				insertCnt = pstmt.executeUpdate();
				pstmt.close();
				pstmt = null;
			}
			else
			{
				sql = "INSERT INTO EXT_SERVICE_LOG (TRAN_ID, TOKEN_ID, ACTION, PARAM, RESPONSE_TYPE, RESPONSE, REQ_ON, REQ_BY, REQ_TERM) "
						+ " VALUES (?, ?, ?, EMPTY_BLOB(), ?, EMPTY_BLOB(), ?, ?, ?)";

				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				pstmt.setString(2, tokenId);
				pstmt.setString(3, action);
				pstmt.setString(4, responseType);
				pstmt.setTimestamp(5, new java.sql.Timestamp(System.currentTimeMillis()));
				pstmt.setString(6, requestedUser );
				pstmt.setString(7, requestedTerm );
				insertCnt = pstmt.executeUpdate();
				pstmt.close();
				pstmt = null;

				boolean updateFlag = false;
				if ( insertCnt > 0 )
				{
					pstmt = conn.prepareStatement("SELECT PARAM, RESPONSE FROM EXT_SERVICE_LOG WHERE TRAN_ID = ? FOR UPDATE");
					pstmt.setString( 1, tranId );
					rs = pstmt.executeQuery();
					if( rs.next() )
					{
						updateFlag = true;
						Blob mapBlob = rs.getBlob(1);
						OutputStream blobOutputStream = ((oracle.sql.BLOB)mapBlob).getBinaryOutputStream();
						params = checkNull( params );
						blobOutputStream.write( params.getBytes() );
						blobOutputStream.close();
						blobOutputStream = null;
						mapBlob = null;

						mapBlob = rs.getBlob(2);
						blobOutputStream = ((oracle.sql.BLOB)mapBlob).getBinaryOutputStream();
						response = checkNull( response );
						blobOutputStream.write( response.getBytes() );
						blobOutputStream.close();
						blobOutputStream = null;
						mapBlob = null;
					}
					pstmt.close();
					pstmt = null;
					rs.close();
					rs = null;
				}
				BaseLogger.log("3", null, null, "updateFlag - "+ updateFlag );
			}
			BaseLogger.log("3", null, null,"<..........ROW INSERTED.............> [" + insertCnt + "]");

			if ( conn != null )
			{
				conn.commit();
				conn.close();
				conn = null;
			}
			returnString = "<ROOT><RESULT>Success</RESULT></ROOT>";
		}
		catch (SQLException e)
		{
			returnString = "<ROOT><RESULT>"+ e.getMessage() +"</RESULT></ROOT>";
			e.printStackTrace();
			throw new ITMException(e);
		}
		catch (Exception e)
		{
			returnString = "<ROOT><RESULT>"+ e.getMessage() +"</RESULT></ROOT>";
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch( Exception e )
			{
				BaseLogger.log("0", null, null, "Exception :" + e.getMessage() );
				e.printStackTrace();
			}
		}
		BaseLogger.log("2", null, null,"returnString - ["+ returnString +"]");

		return returnString;
	}
	//Added by Prasad on 01/03/16 [for creating log of accessing web service]

	//Added By Umakanta Das on 05-MAR-2016 [ S15ISUN006 ] [ To check reprint status of report when user print report first time ] Start
	/**
	 * Thir method returns print status before user print report at first time.
	 *
	 * @param tranId
	 * @param objName
	 * @param argValue
	 * @param user
	 * @param chgTerm
	 * @param rePrint
	 * @param profileId
	 * @param reprintCntrlSQL
	 * @param isConfirmReprint
	 * @param userLevel
	 * @return printStatus
	 * @throws ITMException
	 */
	public String getReprintStatus(String tranId , String objName, String argValue, String user, String chgTerm, String rePrint, String profileId, String reprintCntrlSQL, boolean isConfirmReprint, String userLevel, UserInfoBean userInfo ) throws ITMException
	{
		BaseLogger.log("2", userInfo, null,"DBAccessEJB CALLED "+objName); //$NON-NLS-1$
		String printStatus = ""; //$NON-NLS-1$
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pst = null;
		ResultSet rst = null;

		Calendar calendar = Calendar.getInstance();
		Timestamp currentTimestamp = new java.sql.Timestamp(calendar.getTime().getTime());
		int rptCnt = 0;
		int cnt = 0;

		try
		{
			String transDB = userInfo.getTransDB();
			conn = connDriver.getConnectDB(transDB); //$NON-NLS-1$
			ArrayList<String> reprintCntrlResulstAL = new ArrayList<String>();

			//Added try/catch block by Ravindra C on 27-03-2020 for avoiding PARAMETER_VAL length exception - Start
			try
			{
				String getPrintStatus = "SELECT COUNT(1) , MAX(REPRINT_CNT) FROM RPT_PRINT_LOG WHERE REPORT_NAME = ? AND PARAMETER_VAL = ? ";  //$NON-NLS-1$
				pstmt = conn.prepareStatement(getPrintStatus);
				reprintCntrlResulstAL = getReprintCntrlQSLResult( replaceArgValue( reprintCntrlSQL, argValue ), userInfo );
				if( reprintCntrlResulstAL.size() == 0 )
				{
					reprintCntrlResulstAL.add( argValue );
				}
				pstmt.setString(1, objName);
				pstmt.setString(2, reprintCntrlResulstAL.get( 0 ) );
				rs = pstmt.executeQuery();

				if(rs.next())
				{
					cnt = rs.getInt(1);
					BaseLogger.log("3", userInfo, null,"rs.getInt = "+rs.getInt(1)); //$NON-NLS-1$
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
				BaseLogger.log("0", null, null,"In the getReprintStatus Exception : ["+ e.getMessage() +"]");
			}
			//Added try/catch block by Ravindra C on 27-03-2020 for avoiding PARAMETER_VAL length exception - End

			if(cnt != 0)
			{
				rptCnt = rs.getInt(2);
				String printedByUsr = "";
				PreparedStatement prdStmt = null;
				ResultSet rSet = null;
				String userIdPrintStatus = " SELECT USERS.NAME AS USER_NAME from USERS  RIGHT OUTER JOIN  RPT_PRINT_LOG ON USERS.CODE = RPT_PRINT_LOG.USER_ID__PRINT "
						+" WHERE  RPT_PRINT_LOG.REPORT_NAME = ?  AND RPT_PRINT_LOG.PARAMETER_VAL = ? ORDER BY REPRINT_ON DESC " ;
				prdStmt = conn.prepareStatement( userIdPrintStatus );
				if( reprintCntrlResulstAL.size() == 0 )
				{
					reprintCntrlResulstAL.add( argValue );
				}
				prdStmt.setString(1, objName);
				prdStmt.setString(2, reprintCntrlResulstAL.get( 0 ) );
				rSet = prdStmt.executeQuery();
				if(rSet.next())
				{
					printedByUsr = checkNull( rSet.getString( "USER_NAME" ) );
				}
				rSet.close();
				rSet = null;
				prdStmt.close();
				prdStmt = null;

				if("N".equalsIgnoreCase(rePrint)) //$NON-NLS-1$
				{
					printStatus = "E_"+ printedByUsr ; //$NON-NLS-1$
				}
				else
				{
					boolean isExistPARAMVal = false;
					reprintCntrlResulstAL = getReprintCntrlQSLResult( replaceArgValue( reprintCntrlSQL, argValue ), userInfo );
					//Added by Pankaj T on 19-12-17 [changes for multitenancy]
					String userRightsStr = checkNull( getUserRights( objName , profileId, userInfo.toString()) );
					BaseLogger.log("3", userInfo, null, "userRightsStr ["+userRightsStr+"] rePrint["+rePrint+"]" );
					int urs_lvl = Integer.parseInt( ( checkNull( userLevel ).length() == 0 ) ? "-1" : checkNull( userLevel )  );
					if( urs_lvl != 0 )
					{
						if("Y".equalsIgnoreCase(rePrint) && userRightsStr != null && userRightsStr.indexOf("*") == -1 && userRightsStr.indexOf("R") == -1)
						{
							printStatus = "E_"+ printedByUsr ;
							return printStatus;
						}
						else if ( "Y".equalsIgnoreCase(rePrint) && ( userRightsStr.indexOf( "*" ) == -1 && userRightsStr.indexOf( "R" ) == -1 ) )
						{
							//Changed by Pankaj T on 04-01-18 [changes for multitenancy]
							isExistPARAMVal = isExistPARAMVal( reprintCntrlResulstAL, objName, userInfo );
							if( isExistPARAMVal )
							{
								printStatus = "E_"+ printedByUsr ;
								return printStatus;
							}
						}
						else if ( checkNull( rePrint ).length() == 0 )
						{
							if ( userRightsStr.indexOf( "*" ) != -1 || userRightsStr.indexOf( "R" ) != -1 )
							{
								printStatus = "S";
								return printStatus;
							}
							else
							{
								printStatus = "E_"+ printedByUsr ;
								return printStatus;
							}
						}
						else
						{
							BaseLogger.log("3", userInfo, null,"DBAccessEjb::getPrintStatus::urs_lvl != 0::checkNull( rePrint ).length() == 0::Else Part has Printed");
						}
					}
					else
					{
						if ( checkNull( rePrint ).length() == 0 )
						{
							printStatus = "S";
							return printStatus;
						}
						else
						{
							BaseLogger.log("3", userInfo, null,"DBAccessEjb::getPrintStatus::urs_lvl == 0::Else Part has Printed");
						}
					}
					if ( isConfirmReprint == false && "Y".equalsIgnoreCase( rePrint ) )
					{
						printStatus = "W_"+ printedByUsr;
						return printStatus;
					}
					else
					{
						BaseLogger.log("3", userInfo, null,"DBAccessEjb::getRePrintStatus::isConfirmReprint == false and rePrint not equal to Y::Else Part has Printed");
					}
				}
			}
			else
			{
				printStatus = "S";
			}
		}
		//Added By Ravindra C on 25-03-2020 to avoid error while user pass lage number of pophelps. START
		catch (SQLException slqEx)
		{
			slqEx.getStackTrace();
		}
		//Added By Ravindra C on 25-03-2020 to avoid error while user pass lage number of pophelps. END
		catch (Exception e)
		{
			e.getStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( conn != null )
				{
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					if( pst != null )
					{
						pst.close();
						pst = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return printStatus;
	}
	//Added By Umakanta Das on 05-MAR-2016 [ S15ISUN006 ] [ To check reprint status of report when user print report first time ] End

	//Added By Ajinkya Gopalkar on 1-Jun-16[for getting application connection option while login ] Start
	@Override
	public String getAppConnOpt(String applName, UserInfoBean userInfo) throws RemoteException, ITMException
	{
		String connOpt = null;
		Connection mConnection = null;
		Statement stmt = null;
		ResultSet rs = null;
		try
		{
			ConnDriver mConnDriver = new ConnDriver();
			String transDB = userInfo.getTransDB();
			mConnection = mConnDriver.getConnectDB(transDB);
			String selectQuery = "select conn_option from appl_mst where app_name =" +"'"+applName+"'" ;
			stmt = mConnection.createStatement();
			rs = stmt.executeQuery(selectQuery);
			if(rs.next())
			{
				connOpt = rs.getString("conn_option");
			}
			rs.close();
			rs = null;
			stmt.close();
			stmt = null;
			mConnection.close();
			mConnection = null;
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo, null,"Exception :DBAccessEJB :AppDescription :==>");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(stmt != null)
				{
					stmt.close();
					stmt = null;
				}
				if(mConnection != null)
				{
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getAppDescription :\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2", userInfo, null,"[DBAccessEJB]Return Connection Option value  :"+connOpt);
		return connOpt;
	}
	//Added By Ajinkya Gopalkar on 1-Jun-16[for getting application connection option while login ] End
	//added by vishal pathare on 23.12.16 for adding rights on side panel container]Start.
	// Commneted and Added by Saiprasad on 15-03-19 to add userInfo as a parameter [START]
	//public String getSidePanelOptionsRights(String objName, String profileId, String userLevel, String transDB)
	public String getSidePanelOptionsRights(String objName, String profileId, String userLevel, String transDB, UserInfoBean userInfo)
	{
		StringBuffer sidePanelOptionsRights = new StringBuffer();
		sidePanelOptionsRights.append("<OBJ_RIGHTS>");
		try
		{
			sidePanelOptionsRights.append( "<RIGHTS_STR><![CDATA["+ getUserRightsString(objName, profileId, userLevel, transDB , userInfo ) +"]]></RIGHTS_STR>" );
			sidePanelOptionsRights.append( "<AUDIT_STR><![CDATA["+ getAuditTrialRights(objName, profileId, userLevel, transDB ) +"]]></AUDIT_STR>" );
		}
		catch(Exception ex)
		{
			BaseLogger.log("0", null, null,"Exception in DB ACCES EJB getRights"+ex.getMessage());
		}
		sidePanelOptionsRights.append("</OBJ_RIGHTS>");

		return sidePanelOptionsRights.toString();
	}

	public String getAuditTrialRights( String objName, String profileID, String userLevel, String transDB )throws ITMException
	{
		ConnDriver connDriver = null;
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		String auditStr = "";
		try
		{
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( transDB );
			String query="select count(*) from obj_actions where obj_name = '"+objName+"' and service_code = 'audit_trail'";
			stmt = conn.createStatement();
			rs = stmt.executeQuery(query);
			int count = 0;
			while(rs.next())
			{
				count = rs.getInt( 1 );
			}
			BaseLogger.log("3", null, null, "count of audit trial ["+count );
			if( count > 0 )
			{
				auditStr = "Y";
			}
			else
			{
				auditStr="N";
			}
			rs.close();
			rs = null;
			stmt.close();
			stmt = null;
			conn.close();
			conn=null;
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException :DBAccessEJB :getUserRightsString :==>");
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception :DBAccessEJB :getUserRightsString :==>"+e);
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :auditStr :==>\n"+e);
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2", null, null,"[DBAccessEJB]Returning  auditStr string :\n"+auditStr+"\n");
		return auditStr;
	}
	//added by vishal pathare on 23.12.16 for adding rights on side panel container]End.

	private void getObjFormInfo(ArrayList dbValues)
	{
		try
		{
			this.objFormInfoMap = new HashMap();
			for(int i = 0 ; i < dbValues.size() ; i++)
			{
				ArrayList currForm = (ArrayList) dbValues.get(i);
				String title = (String)currForm.get(0);
				String objContext = (String) currForm.get(14);
				String scrType = (String) ( ( currForm.get(15) == null ) ? "" : currForm.get(15) );
				String dbFormType = (String) ( ( currForm.get(16) == null ) ? "" : currForm.get(16) );
				String formName = (String) ( ( currForm.get(32) == null ) ? "" : currForm.get(32) );
				String parentKeyCol = (String) ( ( currForm.get(18) == null ) ? "" : currForm.get(18) );
				this.objFormInfoMap.put(objContext, dbFormType + OBJ_INFO_SEPARATOR + parentKeyCol + OBJ_INFO_SEPARATOR + scrType + OBJ_INFO_SEPARATOR + formName);
			}
			BaseLogger.log("3", null, null,"objFormInfoMap : [" + this.objFormInfoMap + "]" );

		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null,"Exception in getObjFormType" + e.getMessage() );
			e.printStackTrace();
		}
	}
	//Added By Pratheek for Menu restriction in E12Mobile Start
	private void checkConditionDetails( UserInfoBean userInfo )
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rsCheckCON = null;
		Connection msgConn = null;
		//Changes made by Pratheek on 18-04-18[to close the prepared statement and result set connection]-Start
		PreparedStatement pstmtusrLevQry = null;
		PreparedStatement pstmtUserLvlSql = null;
		PreparedStatement pstmtMessageQuery = null;
		ResultSet rs = null;
		ResultSet rs1 = null;
		ResultSet messageRst = null;
		//Changes made by Pratheek on 18-04-18[to close the prepared statement and result set connection]-End
		try
		{
			String isRestrict = "";
			String isAllow = "";

			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB(userInfo.getTransDB());
			String usrLevQry = "SELECT * FROM CONDN_ACC_DET ORDER BY SEQ_NO";
			pstmt = conn.prepareStatement( usrLevQry );
			rsCheckCON = pstmt.executeQuery( );
			msgConn = connDriver.getConnectDB("Driver");
			while( rsCheckCON.next() )
			{
				String sql_purpose = rsCheckCON.getString("SQL_PURPOSE");
				String condId = rsCheckCON.getString("CONDN_ID");
				int sqlNo = rsCheckCON.getInt("SEQ_NO");
				String condnSql = rsCheckCON.getString("CONDN_SQL");
				String qualRes  = rsCheckCON.getString("QUAL_RES"); // result to be matched
				String sqlInput = rsCheckCON.getString("SQL_INPUT"); //input to CONDN_SQL query
				String msgNo = rsCheckCON.getString("MSG_NO");
				String [] sqlInputArray = sqlInput.trim().split(":");

				//Condition sql executed here
				//Changes made by Pratheek on 18-04-18[to close the prepared statement and result set connection]-Start
//				pstmt = conn.prepareStatement(condnSql);
				pstmtusrLevQry = conn.prepareStatement(condnSql);
				//Changes made by Pratheek on 18-04-18[to close the prepared statement and result set connection]-End
				for( int i = 0; i< sqlInputArray.length; i++)
				{
					String value = userInfo.getPropValue( sqlInputArray[i] );
					BaseLogger.log("3", null, null,"!!!**** value is ["+value+"]");
					//Changes made by Pratheek on 18-04-18[to close the prepared statement and result set connection]-Start
//					pstmt.setString(i+1, value );
					pstmtusrLevQry.setString(i+1, value );
					//Changes made by Pratheek on 18-04-18[to close the prepared statement and result set connection]-End
				}
				//Changes made by Pratheek on 18-04-18[to close the prepared statement and result set connection]-Start
//				rs = pstmt.executeQuery( );
				rs = pstmtusrLevQry.executeQuery( );
				//Changes made by Pratheek on 18-04-18[to close the prepared statement and result set connection]-End

				while( rs.next() )
				{
					String result = rs.getString(1);
					ResultSetMetaData rsmd = rs.getMetaData();
					String columnName = rsmd.getColumnName(1);
					BaseLogger.log("3", null, null,"!!*** result ["+result+"] qualRes ["+qualRes+"] sqlNo ["+sqlNo+"] columnName ["+columnName+"]");

					if( "SEQ_NO".equals(columnName) )
					{
						String key = "SEQ-"+result.trim();
						result = CommonConstants.sequenceResultMap.get( key );
					}
					//If SQL purpose is C then go ahead (if I then stop )
					BaseLogger.log("3", null, null,"!!** 11 purpose ["+sql_purpose+"]");

					if( "C".equalsIgnoreCase(sql_purpose.trim()))
					{
						//*************** Condition result match
						if( result.trim().equals( qualRes.trim() ) )
						{
							String sql = "SELECT * FROM CONDN_ACC WHERE CONDN_ID='"+condId.trim()+"'";
							//Changes made by Pratheek on 18-04-18[to close the prepared statement and result set connection]-Start
//							pstmt = conn.prepareStatement( sql );
//							rs1 = pstmt.executeQuery( );
							pstmtUserLvlSql = conn.prepareStatement( sql );
							rs1 = pstmtUserLvlSql.executeQuery( );
							//Changes made by Pratheek on 18-04-18[to close the prepared statement and result set connection]-End

							if( rs1.next() )
							{
								String descr = rs1.getString("DESCR");
								String startupView = rs1.getString("STARTUP_VIEW");
								String objAcc = rs1.getString("OBJ_ACC");
								String accType = rs1.getString("ACC_TYPE");
								String condnStatus = rs1.getString("CONDN_STATUS");

								//if( "R".equals(accType.trim()) && "A".equals(condnStatus.trim()) )
								if( "A".equals(condnStatus.trim()) )
								{
									String messageSql = "SELECT MSG_DESCR FROM MESSAGES WHERE MSG_NO='"+msgNo.trim()+"'";
									//Changes made by Pratheek on 18-04-18[to close the prepared statement and result set connection]-Start
									//pstmt = msgConn.prepareStatement( messageSql );
									//messageRst = pstmt.executeQuery( );
									pstmtMessageQuery = msgConn.prepareStatement( messageSql );
									messageRst = pstmtMessageQuery.executeQuery( );
									//Changes made by Pratheek on 18-04-18[to close the prepared statement and result set connection]-End
									while( messageRst.next() )
									{
										String alertMsg = messageRst.getString(1);
										CommonConstants.menuRstMsg = alertMsg;
									}
									//Changes made by Pratheek on 18-04-18[to close the prepared statement and result set connection]-Start
									if(messageRst!=null)
									{
										messageRst.close();
										messageRst=null;
									}
									if(pstmtMessageQuery !=null)
									{
										pstmtMessageQuery.close();
										pstmtMessageQuery=null;
									}
									//Changes made by Pratheek on 18-04-18[to close the prepared statement and result set connection]-End
								}

								if( "ALL".equals(objAcc.trim()) && "R".equals(accType.trim()))
								{
									CommonConstants.allDisable = "true";
								}
								else
								{
									CommonConstants.allDisable = "false";
								}

								//If condition is active then go ahead
								if( "A".equals(condnStatus.trim()))
								{
									if( "R".equals(accType.trim()) )
									{
										//for restrict
										String [] restrictObjArray = objAcc.trim().split(":");
										for( String restrtObj : restrictObjArray )
										{
											CommonConstants.restrictObjList.add( restrtObj.trim() );
										}
									}
									else
									{
										//For allow accType = A
										String [] allowObjArray = objAcc.trim().split(":");
										for( String allowObj : allowObjArray )
										{
											CommonConstants.allowedObjList.add( allowObj.trim() );
										}
									}
								}
								else
								{
									//If Condition is InActive comes here
								}
							}
							//Changes made by Pratheek on 18-04-18[to close the prepared statement and result set connection]-Start
							if(rs1!=null)
							{
								rs1.close();
								rs1=null;
							}
							if(pstmtUserLvlSql !=null)
							{
								pstmtUserLvlSql.close();
								pstmtUserLvlSql=null;
							}
							//Changes made by Pratheek on 18-04-18[to close the prepared statement and result set connection]-End
						}
						//*************** Condition result doesnot match
						else
						{
							//							String key = "SEQ-"+sqlNo;
							//							CommonConstants.sequenceResultMap.put( key, result);
						}
					}
					else
					{
						//*************** Input and condition match ( this will not happen in case of Input)
						if( result.trim().equals( qualRes.trim() ) )
						{
						}
						//*************** Input and condition does not match
						else
						{
							//result does not match put result in sequence map
							String key = "SEQ-"+sqlNo;
							CommonConstants.sequenceResultMap.put( key, result);
						}
					}
				}
				//Changes made by Pratheek on 18-04-18[to close the prepared statement and result set connection]-Start
				if(rs!=null)
				{
					rs.close();
					rs=null;
				}
				if(pstmtusrLevQry!=null)
				{
					pstmtusrLevQry.close();
					pstmtusrLevQry=null;
				}
				//Changes made by Pratheek on 18-04-18[to close the prepared statement and result set connection]-End
			}
			//Changes made by Pratheek on 18-04-18[to close the prepared statement and result set connection]-Start
			if(rsCheckCON!=null)
			{
				rsCheckCON.close();
				rsCheckCON=null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
			//Changes made by Pratheek on 18-04-18[to close the prepared statement and result set connection]-End
		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null,"Exception while check condition details : "+e.getMessage());
		}
		finally
		{
			try
			{
				if(msgConn != null)
				{
					msgConn.close();
					msgConn = null;
				}
				if(conn != null)
				{
					if(pstmt != null)pstmt.close();
					if(rsCheckCON != null)rsCheckCON.close();
					//Changes made by Pratheek on 18-04-18[to close the prepared statement and result set connection]-Start
					if(pstmtusrLevQry != null)pstmtusrLevQry.close();
					if(rs != null)rs.close();

					if(pstmtUserLvlSql != null)pstmtUserLvlSql.close();
					if(rs1 != null)rs1.close();

					if(pstmtMessageQuery != null)pstmtMessageQuery.close();
					if(messageRst != null)messageRst.close();
					//Changes made by Pratheek on 18-04-18[to close the prepared statement and result set connection]-End
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception while closing connection condition details :" + e.getMessage()); //$NON-NLS-1$
			}
		}
		BaseLogger.log("2", null, null,"!!*** restrict list ["+CommonConstants.restrictObjList+"]");
		BaseLogger.log("2", null, null,"!!*** allowed list ["+CommonConstants.allowedObjList+"]");
		BaseLogger.log("2", null, null,"!!*** sequence result map ["+CommonConstants.sequenceResultMap+"]");
		BaseLogger.log("2", null, null,"!!*** alert message ["+CommonConstants.menuRstMsg+"]");
	}

	private boolean checkObjPermission( String objName, String objType )
	{
		boolean isFreez = false;
		try
		{
			String value = "";
			if( "I".equals(objType))
			{
				BaseLogger.log("3", null, null,"!!*** objName ["+objName+"]");
				String newStr = objName.substring(objName.indexOf("?")+1);
				if( !(newStr.indexOf("OBJ_NAME") == -1) )
				{
					String[] calData = newStr.split("&");
					for( String data : calData )
					{
						String name = data.substring(0, data.indexOf("="));
						if("OBJ_NAME".equalsIgnoreCase(name) )
						{
							value = data.substring(data.indexOf("=")+1);
							objName = value;
							//BaseLogger.log("3", null, null,"Value is ["+value+"]");
							break;
						}
					}
				}
			}

			int restrictSize = CommonConstants.restrictObjList.size();
			int allowedSize = CommonConstants.allowedObjList.size();

			if( restrictSize > allowedSize)
			{
				if( CommonConstants.restrictObjList.contains(objName) )
				{
					isFreez = true;
				}
			}
			else if( allowedSize > restrictSize )
			{
				if( CommonConstants.allowedObjList.contains(objName) )
				{
					isFreez = false;
				}
				else
				{
					isFreez = true;
				}
			}

			//			if( CommonConstants.restrictObjList.contains(objName) )
			//			{
			//				isFreez = true;
			//			}
			if( "true".equalsIgnoreCase( CommonConstants.allDisable ) )
			{
				isFreez = true;
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null,"Exception while check permission :"+e.getMessage());
		}

		return isFreez;
	}

	private void clearPermissionList()
	{
		CommonConstants.restrictObjList.clear();
		CommonConstants.allowedObjList.clear();
		CommonConstants.sequenceResultMap.clear();
		CommonConstants.allDisable = "false";
	}
	//Added By Pratheek for Menu restriction in E12Mobile End

	//Added by Santosh on 20/04/2017 to get itm2menu details for objName[Start]
	public String getItm2menuDetails( String objName, String transDB ) throws ITMException
	{
		StringBuffer xmlDataSBuff = new StringBuffer();
		String winName = "";
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Connection conn = null;

		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( transDB );
			connDriver = null;

			//Changed by Prasad on 26/04/2021 [object name related changes in case of url defined in win_name] START
			String condition = "";
			if( objName.contains( "/" ) )
			{
				if ( objName.contains( "?" ) )
				{
					winName = objName.substring( objName.indexOf( "?" ) + 1 );
				}
				else
				{
					winName = objName;
				}
				winName = winName.toUpperCase();
				condition = " UPPER(WIN_NAME) LIKE '%"+ winName +"%' ";
			}
			else
			{
				if ( ! objName.startsWith( "w_" ) )
				{
					winName = ("w_"+objName);
				}
				else
				{
					winName = objName;
				}
				winName = winName.toUpperCase();
				condition = " UPPER(WIN_NAME) = '"+ winName +"' ";
			}

			sql = "SELECT WIN_NAME, DESCR, MENU_PATH, ICON_PATH, OBJ_TYPE FROM ITM2MENU WHERE "+ condition +" AND MENU_PATH IS NOT NULL";
			pstmt = conn.prepareStatement(sql);
			//pstmt.setString(1, winName);
			//Changed by Prasad on 26/04/2021 [object name related changes in case of url defined in win_name] END
			rs = pstmt.executeQuery();

			if(rs.next())
			{
				xmlDataSBuff.append("<root>");
				xmlDataSBuff.append("<detail>");
				xmlDataSBuff.append("<descr><![CDATA["+checkNull(rs.getString("DESCR"))+"]]></descr>");
				xmlDataSBuff.append("<menuPath><![CDATA["+checkNull(rs.getString("MENU_PATH"))+"]]></menuPath>");
				xmlDataSBuff.append("<iconPath><![CDATA["+checkNull(rs.getString("ICON_PATH"))+"]]></iconPath>");
				xmlDataSBuff.append("<objType><![CDATA["+checkNull(rs.getString("OBJ_TYPE"))+"]]></objType>");
				xmlDataSBuff.append("</detail>");
				xmlDataSBuff.append("</root>");
			}

		}
		catch(SQLException se)
		{
			BaseLogger.log("0", null, null,"DBAccessEJB.getItm2menuDetails().inSQLException["+se.getMessage()+"]");
			se.printStackTrace();
			throw new ITMException(se);
		}
		catch(Exception e)
		{
			BaseLogger.log("0", null, null,"DBAccessEJB.getItm2menuDetails()["+e.getMessage()+"]");
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				if( conn != null && !conn.isClosed())
				{
					conn.close();
					conn = null;
				}
			}
			catch(SQLException se)
			{
				BaseLogger.log("0", null, null,"DBAccessEJB.getItm2menuDetails() in finally["+se.getMessage()+"]");
				se.printStackTrace();
				throw new ITMException(se);
			}
		}
		return xmlDataSBuff.toString();
	}
	//Added by Santosh on 20/04/2017 to get itm2menu details for objName[End]
	//Added by Bhupendra on 31-05-17 for Summary Page Issue during adding transaction Start
	//Changes made by Pratheek on 23/08/18[to pass the objType on process screen]-Start
//	private String getMetadataPkFldName( String objName, String formNo, String formName )
	private String getMetadataPkFldName( String objName, String formNo, String formName,String objType, UserInfoBean userInfo )
	//Changes made by Pratheek on 23/08/18[to pass the objType on process screen]-End
	{
		String pKFieldNames = "";
		try
		{
			//Changes made by Pratheek on 23/08/18[to prevent reading 21 and 22 metadata in process screen]-Start
			BaseLogger.log("3", null, null,"ObjType in getMetaDataPkFldName mrthod 18731!!!!["+objType+"]");
			String metaDataFileName ="";
			if( "P".equalsIgnoreCase(objType))
			{
				metaDataFileName = objName + "1" + formNo;
			}
			else
			{
				metaDataFileName = objName + "2" + formNo;
			}

			if(formName != null && formName.trim().length() > 0 && !"null".equalsIgnoreCase(formName))
			{
				if( "P".equalsIgnoreCase(objType))
				{
					metaDataFileName = objName +"1"+ formName;
				}
				else
				{
					metaDataFileName = objName +"2"+ formName;
				}
			}
			//Changes made by Pratheek on 23/08/18[to prevent reading 21 and 22 metadata in process screen]-End
			DWFactory dws = new DWFactory(userInfo);
			DWObject dwObject = (DWObject) dws.getDataWindow(metaDataFileName);
			ArrayList primaryKeyLogNameList = dwObject.getPrimaryKeyLogNameList();

			StringBuffer headerPKFieldNamesBuff = new StringBuffer();
			for(int i = 0; i < primaryKeyLogNameList.size(); i++)
			{
				headerPKFieldNamesBuff.append((String)primaryKeyLogNameList.get(i)).append( ":" );
			}
			if (headerPKFieldNamesBuff.length() > 0)
			{
				headerPKFieldNamesBuff.deleteCharAt((headerPKFieldNamesBuff.length() - 1));
			}

			pKFieldNames = headerPKFieldNamesBuff.toString();
		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null,"Exception : DBAccessEJB : getMetadataPkFldName :"+e.getMessage());
		}
		return pKFieldNames;
	}
	//Added by Bhupendra on 31-05-17 for Summary Page Issue during adding transaction Start

	//Added By Ajinkya Gopalkar - Start
	private String getCommaSeperatedValue( ArrayList objItemChangeFldList )
	{
		StringBuffer fieldNameBuff = new StringBuffer();
		for( Object fieldName : objItemChangeFldList )
		{
			fieldNameBuff.append( (String)fieldName ).append(",");
		}
		String CSValues = fieldNameBuff.toString();
		if( ! "".equalsIgnoreCase( CSValues ) )
		{
			CSValues = CSValues.substring(0, CSValues.lastIndexOf(","));
		}
		BaseLogger.log("2", null, null,"getCommaSeperatedValue : CSValues [" + CSValues + "]");
		return CSValues;
	}
	//Added By Ajinkya Gopalkar - End

	public String getOfflineTransNo(String objName,UserInfoBean userInfo)throws RemoteException, ITMException
	{
		String offlineTransNo = "";
		Connection mConnection = null;
		Statement mStmt = null;
		ResultSet rs = null;
		String transDB = null;
		Statement pstmt=null;
		try
		{

			transDB=userInfo.getTransDB();

			ConnDriver mConnDriver =  new ConnDriver();
			mConnection = mConnDriver.getConnectDB(transDB);
			//Changed by Sagar B. for multiple profile id related changes[11-Dec-17]
			//String mQuery = "SELECT NO_OFFLINE_ALLWD FROM USER_RIGHTS WHERE OBJ_NAME = '"+objName.trim()+"' AND PROFILE_ID = '"+userInfo.getProfileId()+"'";
			String mQuery = "SELECT NO_OFFLINE_ALLWD FROM USER_RIGHTS WHERE OBJ_NAME = '"+objName.trim()+"' AND PROFILE_ID IN "+ E12GenericUtility.getFormattedProfileId(userInfo.getProfileId());
			BaseLogger.log("3", null, null,"mQuery ["+mQuery+"]");

			rs = pstmt.executeQuery(mQuery);

			//if (rs.next())
			while (rs.next())
			{
				offlineTransNo = offlineTransNo + checkNull( rs.getString("NO_OFFLINE_ALLWD") );
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null,"Exception :DBAccessEJB :getStartForm :==>\n"+e);
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(mStmt != null)
					{
						mStmt.close();
						mStmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getStartForm :==>finally"+e.getMessage()); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2", null, null,"TRANSETUP.startForm ["+offlineTransNo+"]");
		return offlineTransNo.trim();
	}

	//Added by Pankaj on 19-12-2017 [for create userinfo object] Start
	/**
	 *
	 *if find any match then store the respective user information in UserInfoBean object and returns that object.
	 *
	 * @param userId
	 *
	 * @throws BaseException
	 * @throws Exception
	 */
	@Override
	public UserInfoBean createUserInfo(String userId) throws BaseException, Exception
	{
		return createUserInfo(userId, null);
	}
	//Added by Pankaj on 19-12-2017 [for create userinfo object] End

	//Added by Pratheek on 14/09/19 [to pass the updated site_cdoe if present when changing the site and then when creating new userInfo] START
	@Override
	public UserInfoBean createUserInfo(String userId,String siteCode) throws BaseException, Exception
	{
		UserInfoBean userInfoBean = new UserInfoBean();
		ConnDriver connDriver = null;
		Connection connection = null;
		Statement statement = null;
		ResultSet resultSet = null;
		//Added by Pankaj T. on 10-04-2020 for Configure SMTP mail server against ENTERPRISE - start
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		//Added by Pankaj T. on 10-04-2020 for Configure SMTP mail server against ENTERPRISE - end
		//Added By Pankaj T. on 01-02-2021 to set chg_term of logintrace as a termid in userinfo - start
		PreparedStatement preparedStatement = null;
		ResultSet res = null;
		//Added By Pankaj T. on 01-02-2021 to set chg_term of logintrace as a termid in userinfo - end
		try
		{
			BaseLogger.log("3", null, null,"userId in createUserInfo of DBAccessEJB=["+userId+"] site_code ["+siteCode+"]");
			userInfoBean.setLoginCode(userId);
			connDriver = new ConnDriver();
			connection = connDriver.getConnectDB("Driver");
			statement = connection.createStatement();
			//Changed by Sagar B. for forgot password impl in APK[16/11/17]
			//String sql = "select EMP_CODE,ENTITY_CODE,PROFILE_ID,USER_TYPE,CHG_TERM,USER_THEME,USER_COUNTRY,USER_LANG,TRANS_DB,SITE_CODE__DEF,ENTERPRISE from users where code='"+userId+"'";
			//Changed By Pankaj T. on 21-10-19 set USER_CODE, MOBILE_NO, EMAIL_ID of user in userInfo
			String sql = "select EMP_CODE,ENTITY_CODE,PROFILE_ID,USER_TYPE,CHG_TERM,USER_THEME,USER_COUNTRY,USER_LANG,TRANS_DB,SITE_CODE__DEF,ENTERPRISE,PASS_WD_SHA,NAME,USER_ID,MOBILE_NO,EMAIL_ID from users where code='"+userId+"'";
			resultSet = statement.executeQuery(sql);
			if(resultSet.next())
			{
				userInfoBean.setEmpCode(E12GenericUtility.checkNull(resultSet.getString("EMP_CODE")));
				userInfoBean.setEntityCode(E12GenericUtility.checkNull(resultSet.getString("ENTITY_CODE")));
				userInfoBean.setProfileId(E12GenericUtility.checkNull(resultSet.getString("PROFILE_ID")));
				userInfoBean.setUserType(E12GenericUtility.checkNull(resultSet.getString("USER_TYPE")));
				userInfoBean.setRemoteHost(E12GenericUtility.checkNull(resultSet.getString("CHG_TERM")));
				userInfoBean.setUserTheme(E12GenericUtility.checkNull(resultSet.getString("USER_THEME")));
				userInfoBean.setUserCountry(E12GenericUtility.checkNull(resultSet.getString("USER_COUNTRY")));
				userInfoBean.setUserLanguage(E12GenericUtility.checkNull(resultSet.getString("USER_LANG")));
				userInfoBean.setTransDB(E12GenericUtility.checkNull(resultSet.getString("TRANS_DB")));
				if( siteCode != null && E12GenericUtility.checkNull(siteCode).length() > 0)
				{
					userInfoBean.setSiteCode(siteCode);
				}
				else
				{
					userInfoBean.setSiteCode(E12GenericUtility.checkNull(resultSet.getString("SITE_CODE__DEF")));
				}
				userInfoBean.setEnterprise(E12GenericUtility.checkNull(resultSet.getString("ENTERPRISE")));
				//Added by Sagar B. for forgot password impl in APK[16/11/17]START
				userInfoBean.setLoginPwd(E12GenericUtility.checkNull(resultSet.getString("PASS_WD_SHA")));
				userInfoBean.setUserName(E12GenericUtility.checkNull(resultSet.getString("NAME")));
				//Changed By Pankaj T. on 21-10-19 set USER_CODE, MOBILE_NO, EMAIL_ID of user in userInfo - start
				userInfoBean.setLoginUserId(E12GenericUtility.checkNull(resultSet.getString("USER_ID")));
				userInfoBean.setLoginMobileNo(E12GenericUtility.checkNull(resultSet.getString("MOBILE_NO")));
				userInfoBean.setLoginEmailId(E12GenericUtility.checkNull(resultSet.getString("EMAIL_ID")));
				//Changed By Pankaj T. on 21-10-19 set USER_CODE, MOBILE_NO, EMAIL_ID of user in userInfo - end
				//Added by Sagar B. for forgot password impl in APK[16/11/17]END

				//Added by Pankaj T. on 10-04-2020 for Configure SMTP mail server against ENTERPRISE - start
				if( E12GenericUtility.checkNull(userInfoBean.getTransDB()).length() > 0 )
				{
					conn = connDriver.getConnectDB(userInfoBean.getTransDB());
					if( "".equals(E12GenericUtility.checkNull(userInfoBean.getEnterprise())) )
					{
						String sqlString = "select ENTERPRISE from site where site_code=?";
						BaseLogger.log("3",null,null,"siteCode["+userInfoBean.getSiteCode()+"]");
						pstmt = conn.prepareStatement(sqlString);
						pstmt.setString(1,userInfoBean.getSiteCode());
						rs = pstmt.executeQuery();
						while (rs.next())
						{
							userInfoBean.setEnterprise(E12GenericUtility.checkNull(rs.getString("ENTERPRISE")));
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
					}
					if( E12GenericUtility.checkNull(userInfoBean.getEnterprise()).length() > 0 )
					{
						String sqlString = "SELECT ENTERPRISE_DESCR, SMTP_HOST, SMTP_PORT, SMTP_USER, SMTP_PASS_WD, SMTP_PROTOCOL_TYPE, SMTP_MAILFROM, EMAIL_ID FROM ENTERPRISE WHERE ENTERPRISE = ?";
						BaseLogger.log("3",null,null,"enterprise["+userInfoBean.getEnterprise()+"]");
						pstmt = conn.prepareStatement(sqlString);
						pstmt.setString(1,userInfoBean.getEnterprise());
						rs = pstmt.executeQuery();
						while (rs.next())
						{
							userInfoBean.setEnterpriseDescr(rs.getString("ENTERPRISE_DESCR"));
							userInfoBean.setSmtpHost(rs.getString("SMTP_HOST"));
							userInfoBean.setSmtpPort(rs.getString("SMTP_PORT"));
							userInfoBean.setSmtpUser(rs.getString("SMTP_USER"));
							userInfoBean.setSmtpPassWD(rs.getString("SMTP_PASS_WD"));
							userInfoBean.setSmtpProtocolType(rs.getString("SMTP_PROTOCOL_TYPE"));
							userInfoBean.setSmtpMailFrom(rs.getString("SMTP_MAILFROM"));
							userInfoBean.setAdminEmailId(rs.getString("EMAIL_ID"));
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
					}
				}
				//Added by Pankaj T. on 10-04-2020 for Configure SMTP mail server against ENTERPRISE - end
				//Added By Pankaj T. on 01-02-2021 to set chg_term of logintrace as a termid in userinfo - start
				String termIdSQL = "SELECT CHG_TERM FROM LOGINTRACE WHERE USERID = ? AND LOGINTIME = ( SELECT MAX(LOGINTIME) FROM LOGINTRACE WHERE USERID = ? AND LOGIN_STATUS = ? )";
				preparedStatement = connection.prepareStatement(termIdSQL);
				preparedStatement.setString(1, userId);
				preparedStatement.setString(2, userId);
				preparedStatement.setString(3, "T");
				res = preparedStatement.executeQuery();
				if( res.next() )
				{
					userInfoBean.setTermId( res.getString("CHG_TERM") );
				}
				preparedStatement.close();
				preparedStatement = null;
				res.close();
				res = null;
				//Added By Pankaj T. on 01-02-2021 to set chg_term of logintrace as a termid in userinfo - end
				BaseLogger.log("3", null, null,"DBAccessEjb createUserInfo()::::::"+userInfoBean.toString());
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null,"Exception in DBAccessEJB createUserInfo()........."+e);
		}
		finally
		{
			if (resultSet != null) resultSet.close();
			if (statement != null) statement.close();
			if (connection != null) connection.close();
			//Added by Pankaj T. on 10-04-2020 for Configure SMTP mail server against ENTERPRISE - start
			if( rs != null )
			{
				rs.close();
				rs =null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if( conn != null )
			{
				conn.close();
				conn = null;
			}
			//Added by Pankaj T. on 10-04-2020 for Configure SMTP mail server against ENTERPRISE - end
			//Added By Pankaj T. on 01-02-2021 to set chg_term of logintrace as a termid in userinfo - start
			if( preparedStatement != null )
			{
				preparedStatement.close();
				preparedStatement = null;
			}
			if( res != null )
			{
				res.close();
				res = null;
			}
			//Added By Pankaj T. on 01-02-2021 to set chg_term of logintrace as a termid in userinfo - end
		}
		return userInfoBean;
	}
	//Added by Pratheek on 14/09/19 [to pass the updated site_cdoe if present when changing the site and then creating new userInfo] End

	//Added by Pankaj T on 12-01-18 [changes for multitenancy added overloaded method]
	public String getEmailAddr(String selFieldName, String fromTableName, String whereFieldName, String whereFieldValue, UserInfoBean userInfo)throws RemoteException, ITMException
	{
		BaseLogger.log("2", null, null,"[DBAccessEJB]Getting email address from master table :["+fromTableName+"]: for ["+whereFieldName+"], ["+ whereFieldValue +"]"); //$NON-NLS-1$ //$NON-NLS-2$
		ConnDriver mConnDriver = null;
		Connection mConnection = null;
		Statement stmt = null;
		ResultSet mRs = null;
		String retEmailAddr = null;
		String transDB = "";
		try
		{
			mConnDriver = new ConnDriver();
			//Added by Pankaj T on 19-12-17 [changes for multitenancy]
			transDB = userInfo.getTransDB();
			BaseLogger.log("3", null, null,"TransDB in getEmailAddr:["+transDB+"]");
			mConnection = mConnDriver.getConnectDB(transDB);

			//Commented and changed by Gulzar on 02/12/13 [] to passss 'Driver' instead of 'Driver':START
			//Commented and changed by Gulzar on 02/12/13 [] to passss 'Driver' instead of 'Driver':END

			//Changed By Rupali on 20/05/2008.[To add the Email ID into UserInfo].Request ID:-[BI78SUN047].Start
			//String mQuery = "SELECT " + selFieldName + " FROM " + fromTableName + " WHERE " + whereFieldName + " = '" + whereFieldValue + "'";
			String mQuery = ""; //$NON-NLS-1$
			whereFieldValue = checkNull( whereFieldValue );
			if(!whereFieldValue.endsWith("$")) //$NON-NLS-1$
			{

				mQuery = "SELECT " + selFieldName + " FROM " + fromTableName + " WHERE " + whereFieldName + " = '" + whereFieldValue + "'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
			}
			else
			{
				String userID = whereFieldValue.substring(0,whereFieldValue.indexOf("$")); //$NON-NLS-1$
				//Added by Pankaj T on 19-01-18 [changes for multitenancy]
				String entityCode = "";
				try (Connection usersConn = mConnDriver.getConnectDB("Driver");)
				{
					String qry = "SELECT  ENTITY_CODE  FROM USERS WHERE CODE='" + userID + "'";
					try(PreparedStatement pstmt = usersConn.prepareStatement(qry);
						ResultSet resultSet = pstmt.executeQuery();)
					{
						if(resultSet.next())
						{
							entityCode = resultSet.getString("ENTITY_CODE");
						}
					}
				}
				catch (Exception e)
				{
					e.printStackTrace();
				}
				//mQuery = "SELECT " + selFieldName + " FROM " + fromTableName + " WHERE " + whereFieldName + " = ( SELECT  ENTITY_CODE  FROM USERS WHERE CODE='" + userID + "')"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
				mQuery = "SELECT " + selFieldName + " FROM " + fromTableName + " WHERE " + whereFieldName + " = '" + entityCode + "'";
				//Added by Pankaj T on 19-01-18 [changes for multitenancy]
			}
			//Changed By Rupali on 20/05/2008.[To add the Email ID into UserInfo].Request ID:-[BI78SUN047].End
			//	BaseLogger.log("3", null, null,"[DBAccessEJB]Query :"+mQuery);
			stmt = mConnection.createStatement();
			mRs = stmt.executeQuery(mQuery);

			if (mRs.next())
			{
				retEmailAddr = mRs.getString(1);
			}
			mRs.close();
			stmt.close();
			stmt = null;
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException :DBAccessEJB :getEmailAddr :\n"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception :DBAccessEJB :getEmailAddr :\n"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getMailDetails :\n"+e.getMessage()); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
		BaseLogger.log("2", null, null,"[DBAccessEJB]Returning email address :["+retEmailAddr+"]:"); //$NON-NLS-1$ //$NON-NLS-2$
		return retEmailAddr;
	}

	public String getEmailAddr(String selFieldName, String fromTableName, String whereFieldName, String whereFieldValue, Connection connection)throws RemoteException, ITMException
	{
		BaseLogger.log("2", null, null,"[DBAccessEJB]Getting email address from master table :["+fromTableName+"]: for ["+whereFieldName+"], ["+ whereFieldValue +"]"); //$NON-NLS-1$ //$NON-NLS-2$
		ConnDriver mConnDriver = null;
		Connection mConnection = null;
		Statement stmt = null;
		ResultSet mRs = null;
		String retEmailAddr = null;
		String transDB = "";
		try
		{
			mConnDriver = new ConnDriver();
			mConnection = connection;
			//Commented and changed by Gulzar on 02/12/13 [] to passss 'Driver' instead of 'Driver':START
			//Commented and changed by Gulzar on 02/12/13 [] to passss 'Driver' instead of 'Driver':END

			//Changed By Rupali on 20/05/2008.[To add the Email ID into UserInfo].Request ID:-[BI78SUN047].Start
			//String mQuery = "SELECT " + selFieldName + " FROM " + fromTableName + " WHERE " + whereFieldName + " = '" + whereFieldValue + "'";
			String mQuery = ""; //$NON-NLS-1$
			whereFieldValue = checkNull( whereFieldValue );
			if(!whereFieldValue.endsWith("$")) //$NON-NLS-1$
			{
				mQuery = "SELECT " + selFieldName + " FROM " + fromTableName + " WHERE " + whereFieldName + " = '" + whereFieldValue + "'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
			}
			else
			{
				String userID = whereFieldValue.substring(0,whereFieldValue.indexOf("$")); //$NON-NLS-1$
				//Added by Pankaj T on 19-01-18 [changes for multitenancy]
				String entityCode = "";
				try (Connection usersConn = mConnDriver.getConnectDB("Driver");)
				{
					String qry = "SELECT  ENTITY_CODE  FROM USERS WHERE CODE='" + userID + "'";
					try(PreparedStatement pstmt = usersConn.prepareStatement(qry);
						ResultSet resultSet = pstmt.executeQuery();)
					{
						if(resultSet.next())
						{
							entityCode = resultSet.getString("ENTITY_CODE");
						}
					}
				}
				catch (Exception e)
				{
					e.printStackTrace();
				}
				//mQuery = "SELECT " + selFieldName + " FROM " + fromTableName + " WHERE " + whereFieldName + " = ( SELECT  ENTITY_CODE  FROM USERS WHERE CODE='" + userID + "')"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
				mQuery = "SELECT " + selFieldName + " FROM " + fromTableName + " WHERE " + whereFieldName + " = '" + entityCode + "'";
				//Added by Pankaj T on 19-01-18 [changes for multitenancy]
			}
			//Changed By Rupali on 20/05/2008.[To add the Email ID into UserInfo].Request ID:-[BI78SUN047].End
			//	BaseLogger.log("3", null, null,"[DBAccessEJB]Query :"+mQuery);
			stmt = mConnection.createStatement();
			mRs = stmt.executeQuery(mQuery);

			if (mRs.next())
			{
				retEmailAddr = mRs.getString(1);
			}
			mRs.close();
			mRs = null;
			stmt.close();
			stmt = null;
		}
		/*catch (ITMException itme)
		{
			System.err.println("ITMException :DBAccessEJB :getEmailAddr :\n"); //$NON-NLS-1$
			throw itme;
		}*/
		catch (Exception e)
		{
			System.err.println("Exception :DBAccessEJB :getEmailAddr :\n"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				/*if(mConnection != null)
				{
					mConnection.close();
					mConnection = null;
				}*/
				if(stmt != null)
				{
					stmt.close();
					stmt = null;
				}
				if(mRs != null)
				{
					mRs.close();
					mRs = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getMailDetails :\n"+e.getMessage()); //$NON-NLS-1$
				//throw new ITMException(e);
			}
		}
		BaseLogger.log( "2", null, null, "[DBAccessEJB] Returning email address : ["+ retEmailAddr +"]" ); //$NON-NLS-1$ //$NON-NLS-2$
		return retEmailAddr;
	}

	/**
	 * This method is used to get all the Email ID based on the parameter supplied
	 * @param entityType
	 * @param entityCode
	 * @param responsibleFor
	 * @return
	 * @throws ITMException
	 */
	public String getEntityEmailAddr(String entityType, String entityCode, String responsibleFor, UserInfoBean userInfo)throws RemoteException, ITMException
	{
		String emailId = "";
		Connection conn = null;
		ConnDriver connDriver = null;
		PreparedStatement pstmtEmail = null;
		ResultSet rsEmail = null;
		try
		{
			int count = 1;
			connDriver = new ConnDriver();
			String transDB = userInfo.getTransDB();
			conn = connDriver.getConnectDB(transDB);

			String emailSql = "SELECT EMAIL_ID FROM ENTITY_CONTACT WHERE ENTITY_TYPE = ? AND ENTITY_CODE = ? AND RESPONSIBLE_FOR = ? ";
			pstmtEmail = conn.prepareStatement(emailSql);
			pstmtEmail.setString(1, entityType);
			pstmtEmail.setString(2, entityCode);
			pstmtEmail.setString(3, responsibleFor);
			rsEmail = pstmtEmail.executeQuery();

			while(rsEmail.next())
			{
				if(count == 1)
				{
					emailId = (rsEmail.getString("EMAIL_ID") == null)?"":rsEmail.getString("EMAIL_ID").trim();
				}
				else
				{
					emailId = emailId + ","+ ((rsEmail.getString("EMAIL_ID") == null)?"":rsEmail.getString("EMAIL_ID").trim());
				}
				count++;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(rsEmail != null)
					{
						rsEmail.close();
						rsEmail = null;
					}
					if(pstmtEmail != null)
					{
						pstmtEmail.close();
						pstmtEmail = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e1)
			{

			}
		}
		BaseLogger.log("2", null, null,"Email ID == ["+emailId+"]");
		return emailId;
	}

	/**
	 * This method is used to get all the Email ID based on the parameter supplied
	 * @param entityType
	 * @param entityCode
	 * @param responsibleFor
	 * @return
	 * @throws ITMException
	 */
	public String getEntityEmailAddr(String entityType, String entityCode, String responsibleFor, Connection connection)throws RemoteException, ITMException
	{
		String emailId = "";
		Connection conn = null;
		ConnDriver connDriver = null;
		PreparedStatement pstmtEmail = null;
		ResultSet rsEmail = null;
		try
		{
			int count = 1;
			connDriver = new ConnDriver();
			conn = connection;

			String emailSql = "SELECT EMAIL_ID FROM ENTITY_CONTACT WHERE ENTITY_TYPE = ? AND ENTITY_CODE = ? AND RESPONSIBLE_FOR = ? ";
			pstmtEmail = conn.prepareStatement(emailSql);
			pstmtEmail.setString(1, entityType);
			pstmtEmail.setString(2, entityCode);
			pstmtEmail.setString(3, responsibleFor);
			rsEmail = pstmtEmail.executeQuery();

			while(rsEmail.next())
			{
				if(count == 1)
				{
					emailId = (rsEmail.getString("EMAIL_ID") == null)?"":rsEmail.getString("EMAIL_ID").trim();
				}
				else
				{
					emailId = emailId + ","+ ((rsEmail.getString("EMAIL_ID") == null)?"":rsEmail.getString("EMAIL_ID").trim());
				}
				count++;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				//if(conn != null)
				{
					if(rsEmail != null)
					{
						rsEmail.close();
						rsEmail = null;
					}
					if(pstmtEmail != null)
					{
						pstmtEmail.close();
						pstmtEmail = null;
					}
					/*conn.close();
					conn = null;*/
				}
			}
			catch(Exception e1)
			{

			}
		}
		BaseLogger.log("2", null, null,"Email ID == ["+emailId+"]");
		return emailId;
	}

	public String getDBColumnValue(String tableName, String columnName, String condition, Connection mConnection)throws RemoteException, ITMException
	{
		String columnValue = "";
		Statement mStmt = null;
		ResultSet rs = null;
		String selectColumns="";

		try
		{
			String columnNameAs = "";
			//Added By Nilesh Start ::30-06-2017 For db2
			selectColumns=columnName;
			//Added By Nilesh Start ::30-06-2017 For db2
			if( columnName.indexOf("~AS~") != -1 )
			{
				String[] columnNameArr = columnName.split("~AS~");
				if( columnNameArr.length > 1 )
				{
					columnName = columnNameArr[0];
					columnNameAs = columnNameArr[1];
					//Added By Nilesh Start ::30-06-2017 For db2
					selectColumns=columnName+" AS "+columnNameAs;
					//Added By Nilesh Start ::30-06-2017 For db2
				}
			}

			String mQuery =  " SELECT " +  selectColumns + " FROM " + tableName + " WHERE " + condition ;
			BaseLogger.log("3", null, null,"mQuery ["+mQuery+"]");
			mStmt = mConnection.createStatement();
			rs = mStmt.executeQuery(mQuery);
			//Added By Nilesh Start ::30-06-2017 For db2
			BaseLogger.log("3", null, null,"columnNameAs::"+columnNameAs);
			//Added By Nilesh Start ::30-06-2017 For db2

			if( columnNameAs.length() > 0 )
			{
				columnName = columnNameAs;
			}
			if (rs.next())
			{
				columnValue = checkNull( rs.getString( columnName.trim() ) );
			}
		}
		catch (Exception e)
		{
			columnValue = "";
			BaseLogger.log("0", null, null,"Exception :DBAccessEJB :getDBColumnValue() :==>\n"+e.getMessage());
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(mStmt != null)
				{
					mStmt.close();
					mStmt = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getTransetupColumnValue() :==>finally"+e.getMessage()); //$NON-NLS-1$
			}
		}
		BaseLogger.log("2", null, null,tableName +"." + columnName + " ["+columnValue+"]");
		return columnValue.trim();
	}
	//Added by Pankaj T on 12-01-18 [changes for multitenancy added overloaded method]
	//added by vishal pathare on 13.4.18 for[site wise enterprise image related changes]start
	public String updateEnterprise(String siteCode, String transDB) throws ITMException
	{
		String enterprise="";
		Connection conn = null;
		ConnDriver connDriver = null;
		PreparedStatement pstmtEmail = null;
		ResultSet rsEmail = null;
		connDriver = new ConnDriver();
		try
		{

			if(transDB!=null && (transDB.trim().length() >0 ))
			{
				conn = connDriver.getConnectDB(transDB);
			}
			BaseLogger.log("3", null, null,"transDB["+transDB+"]");

			String sqlString = "select enterprise from site where site_code=?";
			BaseLogger.log("3", null, null,"siteCode["+siteCode+"]");
			PreparedStatement pstmt = conn.prepareStatement(sqlString);
			pstmt.setString(1,siteCode);
			ResultSet rs = pstmt.executeQuery();
			while (rs.next())
			{
				enterprise = rs.getString("enterprise");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			if(conn!=null)
			{
				conn.close();
				conn = null;
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null,"Exception in DbAccess updateEnterprise method["+e.getMessage()+"]");
			throw new ITMException(e);
		}
		return enterprise;

	}
	//added by vishal pathare on 13.4.18 for[site wise enterprise image related changes]End
	//Added by sunny soni for getting app survey information [start]
	public String getUserFeedbackOnAppsurvey(String userId, String appId, String easeUse,
			String funcCovered, String performance, String feedback) throws BaseException, Exception
	{
		String result = "";
		Connection conn = null;
		ConnDriver connDriver = null;
		PreparedStatement pstmt = null;
		String sql = "";
		try{
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver");

			sql = "INSERT INTO USERFEEDBACK(USER_ID, APP_ID, EASE_USE, FUNC_COVERED, PERFRMNCE, FEEDBACK)"
				+ "VALUES(?,?,?,?,?,?)";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, userId);
			pstmt.setString(2, appId);
			pstmt.setString(3, easeUse);
			pstmt.setString(4, funcCovered);
			pstmt.setString(5, performance);
			pstmt.setString(6, feedback);
			int i = pstmt.executeUpdate();
			BaseLogger.log("3", null, null,"In getUserFeedbackOnAppsurvey, value of i::[ "+i+" ]");
			if(i>0){
				result = "Inserted Successfully";
			}
			if(conn != null){
				conn.commit();
			}
			if(pstmt!=null){
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e){
			result = "Exception occured: "+e.getMessage();
			BaseLogger.log("0", null, null,"Exception in DbAccess getUserFeedbackOnAppsurvey method["+e.getMessage()+"]");
			throw new ITMException(e);
		}
		finally{
				try{
					if(conn != null){
							if(pstmt != null){
								pstmt.close();
								pstmt = null;
							}
							conn.close();
							conn = null;
						}
				}
				catch(Exception e){
					e.printStackTrace();
				}
		}
		return result;
	}

	//added by vishal pathare on 31.7.18 for[application user licence type wise application should display]Start
	private String getUserLicenceType( String userId ) throws ITMException
	{
		String userLicType = "";
		ConnDriver mConnDriver = null;
		Connection mConnection = null;
		Statement stmt = null;
		ResultSet rs = null;
		try
		{
			mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB( "Driver" );

			String selectQuery = "SELECT USER_LIC_TYPE FROM USERS WHERE CODE='" + userId + "'";
			stmt = mConnection.createStatement();
			rs = stmt.executeQuery(selectQuery);
			if (rs.next())
			{
				userLicType = rs.getString("USER_LIC_TYPE");
			}
			rs.close();
			rs = null;
			if(stmt != null)
			{
				stmt.close();
				stmt = null;
			}
		}
		catch (ITMException itme)
		{
			BaseLogger.log("0", null, null,"ITMException :DBAccessEJB :getUserLicenceType :==>["+itme.getMessage()+"]");
			throw itme;
		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null,"Exception :DBAccessEJB :getUserLicenceType :==>["+e.getMessage()+"]");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getUserLicenceType :\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return userLicType;
	}
	//added by vishal pathare on 31.7.18 for[application user licence type wise application should display]End

	//added by vishal pathare on 11.9.18 for [stop server if product version of BaseProductInfo and parameter table itm_ver column doesn't match]Start
	public boolean validateProductInfo() throws ITMException, NamingException
	{
		BaseLogger.log("2", null, null," validateProductInfo called 1");
		String productVersion = "";
		// BaseProductInfoLocal baseProductInfo = (BaseProductInfoLocal)this.getInitialContext().lookup("ibase/BaseProductInfo/local");
		BaseProductInfo baseProductInfo = new BaseProductInfo();
		String productInfoXml = baseProductInfo.getProductInfo();
		//	 BaseLogger.log("3", null, null,"productInfoXml in DBAccess EJB["+productInfoXml+"]");
		Document actionDom = new E12GenericUtility().parseString( productInfoXml );
		NodeList actnNodeChildList = actionDom.getElementsByTagName("PRODUCT_VERSION");
		int length = actnNodeChildList.getLength();
		BaseLogger.log("3", null, null,"length["+length+"]");
		for (int i = 0; i < length; i++)
		{
			if( actnNodeChildList.item(i).getFirstChild() != null )
			{
				String nodeName =	actnNodeChildList.item(i).getNodeName();
				productVersion  =	checkNull(actnNodeChildList.item(i).getFirstChild().getNodeValue());
				BaseLogger.log("3", null, null,"nodeName["+nodeName+"]nodeValue["+productVersion+"]");
			}
		}
		String itm_Version = getProductVersion();
		BaseLogger.log("3", null, null,"itm_Version["+itm_Version+"]");

		if( itm_Version.equalsIgnoreCase( productVersion ) )
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	private String getProductVersion() throws ITMException
	{
		String itm_Version = "";
		ConnDriver mConnDriver = null;
		Connection mConnection = null;
		Statement stmt = null;
		ResultSet rs = null;
		try
		{
			mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB( "Driver" );

			String selectQuery = "SELECT ITM_VER FROM PARAMETER";
			stmt = mConnection.createStatement();
			rs = stmt.executeQuery(selectQuery);
			if (rs.next())
			{
				itm_Version = checkNull(rs.getString("ITM_VER"));
			}
			rs.close();
			rs = null;
			if(stmt != null)
			{
				stmt.close();
				stmt = null;
			}
		}
		catch (ITMException itme)
		{
			BaseLogger.log("0", null, null,"ITMException :DBAccessEJB :getProductVersion :==>["+itme.getMessage()+"]");
			throw itme;
		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null,"Exception :DBAccessEJB :getProductVersion :==>["+e.getMessage()+"]");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getUserLicenceType :\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return itm_Version;
		//added by vishal pathare on 11.9.18 for [stop server if product version of BaseProductInfo and parameter table itm_ver column doesn't match]End
	}

	public String getRestrictedMenu( String loginCode, String applName, String profileId, String userLevel, boolean isMobile, String targetObj, UserInfoBean userInfo )throws RemoteException, ITMException
	{
		StringBuffer favXmlStr = new StringBuffer();
		ConnDriver mConnDriver = null;
		Connection mConnection = null;
		Statement mStatement = null;
		ResultSet mResultSet = null;

		if( applName != null && !"".equalsIgnoreCase(applName) && !"null".equalsIgnoreCase(applName) )
		{
			applName = applName.toUpperCase();
		}
		try
		{
			mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB(userInfo.getTransDB()); //$NON-NLS-1$
			checkConditionDetail( userInfo );

			int userLev =(userLevel==null||"".equalsIgnoreCase(userLevel))? -1 : Integer.parseInt(userLevel);

			String userRightsQuery = " SELECT OBJ_NAME FROM USER_RIGHTS WHERE PROFILE_ID IN " + E12GenericUtility.getFormattedProfileId(profileId.trim())
					+" UNION "
					+" SELECT OBJ_NAME FROM USER_OBJ_FAV WHERE USER_ID='"+loginCode.trim()+"' "
					+" AND OBJ_NAME NOT IN ( SELECT RTRIM(OBJ_NAME) FROM USER_RIGHTS "
					+" WHERE PROFILE_ID IN " + E12GenericUtility.getFormattedProfileId(profileId.trim())+" ) ";
			mStatement = mConnection.createStatement();
			mResultSet = mStatement.executeQuery( userRightsQuery );
			favXmlStr.append("<?xml version=\"1.0\"?>\r\n<Root>");
			boolean isWritten = false;
			while(mResultSet.next())
			{
				String objName = mResultSet.getString("OBJ_NAME").trim();
				BaseLogger.log("3",userInfo,null, "FavObjName [" + objName + "]" ); //$NON-NLS-1$ //$NON-NLS-2$
				String winName= ( objName.indexOf("/") == -1 ) ? "w_"+objName : objName ; //$NON-NLS-1$ //$NON-NLS-2$

				String selectFavoriteQry = "";
				if( userLev >= 1 )
				{
					selectFavoriteQry = " SELECT B.APPLICATION ,B.WIN_NAME, B.COMMENTS, B.MENU_PATH ,"
							+" B.DESCR,B.ICON_PATH,B.OBJ_TYPE "
							+" FROM USER_RIGHTS A, ITM2MENU B "
							+" WHERE A.PROFILE_ID  IN " + E12GenericUtility.getFormattedProfileId(profileId.trim())
							+" AND A.APPLICATION = '"+applName+"' "
							+" AND B.WIN_NAME ='"+winName.trim()+"'"
							+" "+( isMobile == true ? " AND ( B.MOB_DEPLOY = 'Y' OR B.MOB_DEPLOY = 'B' ) " : "  AND ( B.MOB_DEPLOY = 'B' OR B.MOB_DEPLOY is null ) " )//Added by Dnyaneshwar Chavan on 21-Aug-14 [ Mobile Specific Menus Should Not Get Displayed In Browser. ]
							+" AND A.APPLICATION=B.APPLICATION AND A.MENU_ROW=B.LEVEL_1 "
							+" AND A.MENU_COL=B.LEVEL_2 AND A.MENU_SUBCOL=B.LEVEL_3 "
							+" AND A.LEVEL_4=B.LEVEL_4 AND A.LEVEL_5=B.LEVEL_5 "
							+" ORDER BY A.APPLICATION,A.MENU_ROW,A.MENU_COL,A.MENU_SUBCOL,A.LEVEL_4,A.LEVEL_5 ";
				}
				else
				{
					selectFavoriteQry = " SELECT APPLICATION,WIN_NAME,DESCR,COMMENTS,MENU_PATH,"
							+" ICON_PATH, OBJ_TYPE "
							+" FROM ITM2MENU "
							+" WHERE WIN_NAME='"+winName.trim()+"'"
							+" AND APPLICATION ='"+applName+"'"
							+" "+( isMobile == true ? " AND ( MOB_DEPLOY = 'Y' OR MOB_DEPLOY = 'B' ) " : "  AND ( MOB_DEPLOY = 'B' OR MOB_DEPLOY is null ) " )//Added by Dnyaneshwar Chavan on 21-Aug-14 [ Mobile Specific Menus Should Not Get Displayed In Browser. ]
							+" ORDER BY APPLICATION,LEVEL_1,LEVEL_2,LEVEL_3,LEVEL_4,LEVEL_5";
				}
				StringBuffer errStringXml = new StringBuffer();
				Statement fStmt = mConnection.createStatement();
				ResultSet fResultSet = fStmt.executeQuery(selectFavoriteQry);

				if(fResultSet.next())
				{
					BaseLogger.log("3",userInfo,null,"CommonConstants.restrictObjList :: "+(CommonConstants.restrictObjList));
					for(int i = 0 ;i < CommonConstants.restrictObjList.size(); i++)
					{
						BaseLogger.log("3",userInfo,null,"Target objName : "+targetObj);
						boolean freez = false;
						if(CommonConstants.restrictObjList.get(i).equals(targetObj))
						{
							freez = checkObjPermission( targetObj ,fResultSet.getString("OBJ_TYPE") );
							BaseLogger.log("3",userInfo,null,"freez :: "+freez);
							if(freez)
							{
								if(! isWritten)
								{
									String dummy = "";
									favXmlStr.append("<Errors>\r\n");
									favXmlStr.append("<error id=\"");
									favXmlStr.append(CommonConstants.menuRstMsgId).append("\" type=\"").append("E").append("\" column_value=\"").append(dummy);
									favXmlStr.append("\" column_name=\"").append(dummy).append("\">\r\n");;
									favXmlStr.append("<message><![CDATA[ "+CommonConstants.menuRstMsg+"]]></message>");
									favXmlStr.append("<description><![CDATA["+CommonConstants.menuRstMsg+"]]></description>");
									favXmlStr.append("<type><![CDATA["+dummy+"]]></type>");
									favXmlStr.append("<time><![CDATA["+dummy+"]]></time>");
									favXmlStr.append("<alarm><![CDATA["+dummy+"]]></alarm>");
									favXmlStr.append("<source><![CDATA["+dummy+"]]></source>");
									favXmlStr.append("<trace><![CDATA[]]></trace>");
									favXmlStr.append("<redirect><![CDATA["+dummy+"]]></redirect>");
									favXmlStr.append("</error>").append("</Errors>");
									isWritten = true;
								}
							}
						}
					}
				}
				if( fStmt != null )
				{
					fStmt.close();
					fStmt=null;
				}
				if( fResultSet != null )
				{
					fResultSet.close();
					fResultSet=null;
				}

			}
			favXmlStr.append("</Root>"); //$NON-NLS-1$
			mResultSet.close();
			mResultSet = null;
			mStatement.close();
			mStatement = null;
		}
		catch(Exception e)
		{
			System.err.println("Exception :DBAccessEJB :getFavouriteData :==>"+e); //$NON-NLS-1$
		}
		finally
		{
			try
			{
				if( mResultSet != null )
				{
					mResultSet.close();
					mResultSet = null;
				}
				if( mStatement != null )
				{
					mStatement.close();
					mStatement =null;
				}
				if(mConnection!=null )
				{
					mConnection.close();
					mConnection=null;
				}
			}
			catch(Exception se)
			{
				BaseLogger.log("3",userInfo,null,"Exception :DBAccessEJB :getFavouriteData : In finally ==>" + se.getMessage()); //$NON-NLS-1$
			}
		}
		clearPermissionList();

		BaseLogger.log("3",userInfo,null,"DBAccessEJB.getRestrictedMenu() P : ["+favXmlStr+"]");
		return favXmlStr.toString();
	}

	private void checkConditionDetail( UserInfoBean userInfo )
	{
		BaseLogger.log("2",userInfo,null,"DBAccessEJB.checkConditionDetails() checkConditionDetails ");
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rsCheckCON = null;
		Connection msgConn = null;
		//Changes made by Pratheek on 18-04-18[to close the prepared statement and result set connection]-Start
		PreparedStatement pstmtusrLevQry = null;
		PreparedStatement pstmtUserLvlSql = null;
		PreparedStatement pstmtMessageQuery = null;
		ResultSet rs = null;
		ResultSet rs1 = null;
		ResultSet messageRst = null;
		//Changes made by Pratheek on 18-04-18[to close the prepared statement and result set connection]-End
		try
		{
			String isRestrict = "";
			String isAllow = "";

			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB(userInfo.getTransDB());
			String usrLevQry = "SELECT * FROM CONDN_ACC_DET ORDER BY SEQ_NO";
			pstmt = conn.prepareStatement( usrLevQry );
			rsCheckCON = pstmt.executeQuery( );
			msgConn = connDriver.getConnectDB("Driver");
			while( rsCheckCON.next() )
			{
				String sql_purpose = rsCheckCON.getString("SQL_PURPOSE");
				String condId = rsCheckCON.getString("CONDN_ID");
				int sqlNo = rsCheckCON.getInt("SEQ_NO");
				String condnSql = rsCheckCON.getString("CONDN_SQL");
				String qualRes  = E12GenericUtility.checkNull(rsCheckCON.getString("QUAL_RES")); // result to be matched
				String sqlInput = rsCheckCON.getString("SQL_INPUT"); //input to CONDN_SQL query
				String msgNo = rsCheckCON.getString("MSG_NO");
				String [] sqlInputArray = sqlInput.trim().split(":");

				pstmtusrLevQry = conn.prepareStatement(condnSql);
				for( int i = 0; i< sqlInputArray.length; i++)
				{
					String value = userInfo.getPropValue( sqlInputArray[i] );
					BaseLogger.log("3",userInfo,null,"!!!**** value is ["+value+"]");
					pstmtusrLevQry.setString(i+1, value );
				}
				rs = pstmtusrLevQry.executeQuery( );
				while( rs.next() )
				{
					String result = E12GenericUtility.checkNull(rs.getString(1));
					ResultSetMetaData rsmd = rs.getMetaData();
					String columnName = rsmd.getColumnName(1);
					BaseLogger.log("3",userInfo,null,"!!*** result ["+result+"] qualRes ["+qualRes+"] sqlNo ["+sqlNo+"] columnName ["+columnName+"]");

					if( "SEQ_NO".equals(columnName) )
					{
						String key = "SEQ-"+result.trim();
						result = CommonConstants.sequenceResultMap.get( key );
					}
					//If SQL purpose is C then go ahead (if I then stop )
					BaseLogger.log("3",userInfo,null,"!!** 11 purpose ["+sql_purpose+"]");

					if( "C".equalsIgnoreCase(sql_purpose.trim()))
					{
						if( result.trim().equals( qualRes.trim() ) )
						{

							String sql = "SELECT * FROM CONDN_ACC WHERE CONDN_ID='"+condId.trim()+"'";
							pstmtUserLvlSql = conn.prepareStatement( sql );
							rs1 = pstmtUserLvlSql.executeQuery( );

							if( rs1.next() )
							{
								String descr = rs1.getString("DESCR");
								String startupView = rs1.getString("STARTUP_VIEW");
								String objAcc = rs1.getString("OBJ_ACC");
								String accType = rs1.getString("ACC_TYPE");
								String condnStatus = rs1.getString("CONDN_STATUS");

								if( "A".equals(condnStatus.trim()) )
								{
									String messageSql = "SELECT MSG_DESCR FROM MESSAGES WHERE MSG_NO='"+msgNo.trim()+"'";
									pstmtMessageQuery = msgConn.prepareStatement( messageSql );
									messageRst = pstmtMessageQuery.executeQuery( );
									while( messageRst.next() )
									{
										String alertMsg = messageRst.getString(1);
										CommonConstants.menuRstMsg = alertMsg;
										CommonConstants.menuRstMsgId = msgNo.trim();
									}
									if(messageRst!=null)
									{
										messageRst.close();
										messageRst=null;
									}
									if(pstmtMessageQuery !=null)
									{
										pstmtMessageQuery.close();
										pstmtMessageQuery=null;
									}
								}

								if( "ALL".equals(objAcc.trim()) && "R".equals(accType.trim()))
								{
									CommonConstants.allDisable = "true";
								}
								else
								{
									CommonConstants.allDisable = "false";
								}

								if( "A".equals(condnStatus.trim()))
								{
									if( "R".equals(accType.trim()) )
									{
										//for restrict
										String [] restrictObjArray = objAcc.trim().split(":");
										for( String restrtObj : restrictObjArray )
										{
											CommonConstants.restrictObjList.add( restrtObj.trim() );
										}
									}
									else
									{
										//For allow accType = A
										String [] allowObjArray = objAcc.trim().split(":");
										for( String allowObj : allowObjArray )
										{
											CommonConstants.allowedObjList.add( allowObj.trim() );
										}
									}
								}
								else
								{
									//If Condition is InActive comes here
								}
							}
							//Changes made by Pratheek on 18-04-18[to close the prepared statement and result set connection]-Start
							if(rs1!=null)
							{
								rs1.close();
								rs1=null;
							}
							if(pstmtUserLvlSql !=null)
							{
								pstmtUserLvlSql.close();
								pstmtUserLvlSql=null;
							}
							//Changes made by Pratheek on 18-04-18[to close the prepared statement and result set connection]-End
						}
						//*************** Condition result doesnot match
						else
						{
							//							String key = "SEQ-"+sqlNo;
							//							CommonConstants.sequenceResultMap.put( key, result);
						}
					}
					else
					{
						//*************** Input and condition match ( this will not happen in case of Input)
						if( result.trim().equals( qualRes.trim() ) )
						{
						}
						//*************** Input and condition does not match
						else
						{
							//result does not match put result in sequence map
							String key = "SEQ-"+sqlNo;
							CommonConstants.sequenceResultMap.put( key, result);
						}
					}
				}
				//Changes made by Pratheek on 18-04-18[to close the prepared statement and result set connection]-Start
				if(rs!=null)
				{
					rs.close();
					rs=null;
				}
				if(pstmtusrLevQry!=null)
				{
					pstmtusrLevQry.close();
					pstmtusrLevQry=null;
				}
				//Changes made by Pratheek on 18-04-18[to close the prepared statement and result set connection]-End
			}
			//Changes made by Pratheek on 18-04-18[to close the prepared statement and result set connection]-Start
			if(rsCheckCON!=null)
			{
				rsCheckCON.close();
				rsCheckCON=null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
			//Changes made by Pratheek on 18-04-18[to close the prepared statement and result set connection]-End
		}
		catch (Exception e)
		{
			BaseLogger.log("3",userInfo,null,"Exception while check condition details : "+e.getMessage());
		}
		finally
		{
			try
			{
				if(msgConn != null)
				{
					msgConn.close();
					msgConn = null;
				}
				if(conn != null)
				{
					if(pstmt != null)pstmt.close();
					if(rsCheckCON != null)rsCheckCON.close();
					//Changes made by Pratheek on 18-04-18[to close the prepared statement and result set connection]-Start
					if(pstmtusrLevQry != null)pstmtusrLevQry.close();
					if(rs != null)rs.close();

					if(pstmtUserLvlSql != null)pstmtUserLvlSql.close();
					if(rs1 != null)rs1.close();

					if(pstmtMessageQuery != null)pstmtMessageQuery.close();
					if(messageRst != null)messageRst.close();
					//Changes made by Pratheek on 18-04-18[to close the prepared statement and result set connection]-End
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception while closing connection condition details :" + e.getMessage()); //$NON-NLS-1$
			}
		}
		BaseLogger.log("3",userInfo,null,"!!*** restrict list ["+CommonConstants.restrictObjList+"]");
		BaseLogger.log("3",userInfo,null,"!!*** allowed list ["+CommonConstants.allowedObjList+"]");
		BaseLogger.log("3",userInfo,null,"!!*** sequence result map ["+CommonConstants.sequenceResultMap+"]");
		BaseLogger.log("3",userInfo,null,"!!*** alert message ["+CommonConstants.menuRstMsg+"]");
		BaseLogger.log("3",userInfo,null,"!!*** alert Id message ["+CommonConstants.menuRstMsgId+"]");
	}
	//added by vishal pathare on 31.7.18 for[application user licence type wise application should display]End

	// Added by Vikas Lagad on 19-10-18 to show favourite menus[START]
	public String getFavInfo(String userID, String transDB) throws RemoteException, ITMException
	{
		Connection mConnection = null;
		Statement stmt = null;
		String selectQuery=null;
		StringBuffer favXmlString = new StringBuffer("");
		ResultSet rs;
		try
		{
			String applGroup = "";
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB(transDB);

			selectQuery = "select OBJ_NAME from USER_OBJ_FAV where USER_ID='"+userID+"'";
			BaseLogger.log("3",null,null,"my query:: " + selectQuery);
			stmt = mConnection.createStatement();
			rs = stmt.executeQuery(selectQuery);
			favXmlString.append("<FAV_MENU>");
			while(rs.next())
			{
				favXmlString.append("<OBJ_NAME>").append("<![CDATA[").append( rs.getString("OBJ_NAME") ).append("]]>").append("</OBJ_NAME>");
			}
			favXmlString.append("</FAV_MENU>");
		}
		catch (Exception e)
		{
			BaseLogger.log("3",null,null,"Exception :DBAccessEJB :Applications :==>" + e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getApplications :\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return favXmlString.toString();
	}
	// Added by Vikas Lagad on 19-10-18 to show favourite menus[END]

	//Added by Prasad on 19/10/18 [to generate tranId] START
	public String generateTranId( String winName, String xsiteCode, String userID, Connection conn ) throws ITMException
	{
		PreparedStatement lstmt = null;
		ResultSet lrs = null;
		String tranId = null;

		try
		{
			String keyStringQuery = null;
			String tranDate = null;
			String tranSer = "";
			String keyString = "";
			String keyCol = "";

			keyStringQuery = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE UPPER(TRAN_WINDOW) = ?";
			BaseLogger.log("3",null,null, "keyStringQuery  :: " + keyStringQuery );
			lstmt = conn.prepareStatement( keyStringQuery );
			lstmt.setString(1,winName);
			lrs = lstmt.executeQuery();
			if( lrs.next() )
			{
				keyString = lrs.getString( "KEY_STRING" );
				keyCol = lrs.getString( "TRAN_ID_COL" );
				tranSer = lrs.getString( "REF_SER" );
			}
			else
			{
				if( lrs != null )
				{
					lrs.close();
					lrs = null;
				}
				if( lstmt != null )
				{
					lstmt.close();
					lstmt = null;
				}
				String sqlStr = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER  FROM  TRANSETUP WHERE  TRAN_WINDOW = 'GENERAL' ";
				BaseLogger.log("3",null,null, " sqlStr : " + sqlStr );

				lstmt = conn.prepareStatement( sqlStr );
				lrs = lstmt.executeQuery();

				if( lrs.next() )
				{
					keyString = lrs.getString( "KEY_STRING" );
					keyCol = lrs.getString( "TRAN_ID_COL" );
					tranSer = lrs.getString( "REF_SER" );
				}
			}
			lrs.close();
			lrs = null;
			lstmt.close();
			lstmt = null;

			tranDate = getCurrdateAppFormat();

			StringBuffer xmlValues = new StringBuffer("<?xml version=\"1.0\" encoding=\"").append(CommonConstants.ENCODING).append("\"?><Root>");
			xmlValues.append("<Header></Header><Detail1><tran_id></tran_id><site_code>").append( xsiteCode ).append("</site_code>"); //added by rupali on 29/03/17 to solving tran id generation issue
			xmlValues.append("<tran_date>").append( tranDate ).append("</tran_date></Detail1></Root>");

			TransIDGenerator tg = new TransIDGenerator(xmlValues.toString(), userID, CommonConstants.DB_NAME);
			tranId = tg.generateTranSeqID( tranSer, keyCol, keyString, conn );
		}
		catch(SQLException se)
		{
			se.printStackTrace();
			throw new ITMException(se);
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		finally
		{
			try
			{
				if ( lrs != null )
				{
					lrs.close();
					lrs = null;
				}
				if (lstmt != null )
				{
					lstmt.close();
					lstmt = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}
		return tranId;
	}

	private String getCurrdateAppFormat()
	{
		String currAppdate ="";
		try
		{
			E12GenericUtility genericUtility = new E12GenericUtility();
			java.sql.Timestamp currDate = new java.sql.Timestamp(System.currentTimeMillis()) ;
			SimpleDateFormat sdf = new SimpleDateFormat( genericUtility.getDBDateFormat() );
			Object date = sdf.parse( currDate.toString() );
			currDate = java.sql.Timestamp.valueOf( sdf.format(date).toString() + " 00:00:00.0");
			currAppdate = new SimpleDateFormat( genericUtility.getApplDateFormat() ).format( currDate ).toString();
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return (currAppdate);
	}
	//Added by Prasad on 19/10/18 [to generate tranId] END

	//Added by Pooja S on [27-12-2018] to Insert the User Activity Log in Database Start
	public String getUserLog(UserInfoBean userInfo,String fileName,String date) throws SQLException
	{
		String transDB = null;
		Connection conn=null;
		String xml="";

		try
		{
			E12GenericUtility genericUtility = new E12GenericUtility();
			boolean flagValue = false;
			String	userLogPath = CommonConstants.APPLICATION_CONTEXT;
			userLogPath = userLogPath.replaceAll("/deploy/ibase.ear/ibase.war/", "");
			userLogPath = userLogPath+"/UserActivity/";

			ArrayList<String> userFileNameList =   getUserFiles(fileName,date.replace("-", "")) ;
			//Changed by Pankaj T on 04-01-18 [changes for multitenancy]
			transDB=userInfo.getTransDB();
			ConnDriver conDriver = new ConnDriver();
			conn = conDriver.getConnectDB(userInfo.getTransDB());
			//HashMap<String, String> map_ = getLogEvents( userInfo );
			if( userFileNameList.size() > 0 )
			{
				String keyStringLog = getDBColumnValue( "TRANSETUP", "KEY_STRING", " REF_SER = 'U-ACT'", transDB );

				for ( String userFileName : userFileNameList )
				{
					String userFile = userLogPath + userFileName;
					String userDate = userFileName;
					int indexDate = userDate.indexOf("_");
					userDate = userDate.substring(indexDate+1);
					userDate = userDate.replaceAll(".txt", "");
					BaseLogger.log("3",userInfo,null,"Read the file form userLogPath["+userFile+"]  userDate"+ userDate+"]");
					File file = new File(userFile);
					StringBuilder builder = new StringBuilder("<ACTIVITIES>");
					FileInputStream fis = new FileInputStream(file);
					int content;
					while ( (content = fis.read()) != -1 )
					{
						// convert to char
						builder.append((char)content);
					}
					builder.append("</ACTIVITIES>");
					//changed by rahul barve on 01-oct-2014 [Start]
					//GenericUtility genericUtility = GenericUtility.getInstance();
					//changed by rahul barve on 01-oct-2014 [End]
					Document dom = (Document) genericUtility.parseString(builder.toString());
					NodeList activities = dom.getElementsByTagName("ACTIVITIES");
					if( activities.getLength() > 0 )
					{
						for ( int index = 0; index < activities.getLength(); index++ )
						{
							Node activitiesNode = activities.item(index);
							NodeList activity = activitiesNode.getChildNodes();
							int length = activity.getLength();
							if ( length > 0 )
							{
								for ( int activityIndex = 0; activityIndex < length; activityIndex++ )
								{
									Node element = activity.item(activityIndex);
									String userCode = "";
									String objValue = "";
									String actionValue = "";
									String endTime = "";
									String startTime = "";
									String eventName = "";
									String activityEditor = "";
									String argParam = "";
									NodeList list = element.getChildNodes();
									if ( element.getNodeName().equalsIgnoreCase("ACTIVITY") )
									{
										if ( element.hasAttributes() )
										{
											userCode = listAllAttributes(element).toString();
										}
									}
									for ( int listIndex = 0; listIndex < list.getLength(); listIndex++ )
									{
										Node node = list.item(listIndex);
										NodeList listAction =null;
										NodeList listEvent =null;
										if ( node.getNodeName().equalsIgnoreCase("ACTIVITY_OBJECT") )
										{
											objValue = node.getFirstChild().getNodeValue();
										}
										else if ( node.getNodeName().equalsIgnoreCase("ACTIVITY_ACTION") )
										{
											int m;
											listAction=node.getChildNodes();
											int l=listAction.getLength();
											if( l > 0)
											{
												for ( m = 0; m < l; m++ )
												{
													Node elementAction = listAction.item(m);
													if ( elementAction.getNodeName().equalsIgnoreCase("ACTION_TYPE") )
													{
														actionValue = elementAction.getFirstChild().getNodeValue();
													}
													else if ( elementAction.getNodeName().equalsIgnoreCase("ACTIVITY_EDITOR") )
													{
														activityEditor = elementAction.getFirstChild().getNodeValue();
													}
													else if ( elementAction.getNodeName().equalsIgnoreCase("EVENT_ID") )
													{
														int k;
														listEvent=elementAction.getChildNodes();
														int len=listEvent.getLength();
														if( len > 0)
														{
															for ( k = 0; k  < len; k++ )
															{
																Node elementEvent = listEvent.item(k);
																if ( elementEvent.getNodeName().equalsIgnoreCase("EVENT_DESCRP") )
																{
																	eventName = elementEvent.getFirstChild().getNodeValue();
																}
																else if ( elementEvent.getNodeName().equalsIgnoreCase("ARG_PARAM") )
																{
																	try
																	{
																		argParam = elementEvent.getFirstChild().getNodeValue();
																	}
																	catch(Exception e)
																	{
																		BaseLogger.log("0",null,null,"Exception in UserActLog$$$["+e.getMessage()+"]");
																		argParam = "";
																	}
																}
																else if ( elementEvent.getNodeName().equalsIgnoreCase("ACCESS_START_TIME") )
																{
																	startTime = elementEvent.getFirstChild().getNodeValue();
																}
																else if ( elementEvent.getNodeName().equalsIgnoreCase("ACCESS_END_TIME") )
																{
																	endTime = elementEvent.getFirstChild().getNodeValue();
																}
																else if ( elementEvent.getNodeName().equalsIgnoreCase("PRIMARY_KEY") )
																{
																	String key = elementEvent.getFirstChild().getNodeValue();
																	if( key == null )
																	{
																		key = "";
																	}
																	flagValue =	saveUserLogToDB(userDate, userCode, objValue, actionValue, eventName, activityEditor, argParam, key, startTime, endTime ,userInfo ,conn,keyStringLog);
																}
															}
														}
													}

												}
											}
										}
									}
								}
							}

						}
					}

				}
				/*if( flagValue == true )
				{
					BaseLogger.log("2", userInfo, null,"User Logger saved successfully in to DataBase");
				}
				else
				{
					BaseLogger.log("2", userInfo, null,"Failed to save the User Logger into DataBase");
				}*/
				xml=showLogEvents(userInfo,fileName,date);
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			if(conn != null)
			{
				conn.close();
				conn=null;
			}
		}
		return xml;
	}

	private boolean saveUserLogToDB( String date, String userCode, String objName, String action, String  eventName, String activityEditor, String argParam,String key, String startTime, String endTime,UserInfoBean userInfoStr ,Connection conn ,String keyStringLog) throws RemoteException, ITMException
	{
		BaseLogger.log("0",null,null,"UserACT INFO======="+userInfoStr);
		boolean flag = false;
		PreparedStatement mPstmt = null;
		DateFormat formatter = null;
		java.util.Date convertedDate = null;
		long longDate;
		TransIDGenerator tranId = new TransIDGenerator("<Root></Root>", "SYSTEM", CommonConstants.DB_NAME);
		try
		{
			String uniqueLogKey = tranId.generateTranSeqID( "U-ACT", "", keyStringLog, conn );

			String insertQry = "INSERT INTO USER_ACT_LOG(TRANS_DB,LOG_DATE,EMP_CODE,WIN_NAME,ACTION_CODE,EVENT_DES,ACTIVITY_EDITOR,ARG_PARAM,PRIMARY_KEY,REQ_DATE_TIME,RES_DATE_TIME) VALUES(?, ?, ?, ?, ?, ?,?,?,?,?,?)";
			mPstmt = conn.prepareStatement(insertQry);

			mPstmt.setString(1, uniqueLogKey);
			formatter = new SimpleDateFormat("yyyyMMdd");
			convertedDate = (java.util.Date) formatter.parse(date);
			longDate = convertedDate.getTime();
			java.sql.Date sqlDate = new java.sql.Date(longDate);
			mPstmt.setDate(2, sqlDate);
			mPstmt.setString(3, userCode);
			mPstmt.setString(4, "w_"+objName);
			mPstmt.setString(5, action);
			mPstmt.setString(6, eventName);
			mPstmt.setString(7, activityEditor);
			mPstmt.setString(8, argParam);
			mPstmt.setString(9, key);

			//20-May-2014 19:15:10 or dd/MM/yyyy HH:mm:ss
			formatter = new SimpleDateFormat(CommonConstants.APPL_DATETIME_FORMAT);
			convertedDate = (java.util.Date) formatter.parse(startTime);
			longDate = convertedDate.getTime();
			java.sql.Timestamp sqlTimestampStart = new java.sql.Timestamp(longDate);
			mPstmt.setTimestamp(10, sqlTimestampStart);

			formatter = new SimpleDateFormat(CommonConstants.APPL_DATETIME_FORMAT);
			convertedDate = (java.util.Date) formatter.parse(endTime);
			longDate = convertedDate.getTime();
			java.sql.Timestamp sqlTimestampEnd = new java.sql.Timestamp(longDate);
			mPstmt.setTimestamp(11, sqlTimestampEnd);
			mPstmt.executeUpdate();

			mPstmt.close();
			mPstmt = null;

			conn.commit();
			flag = true;
		}
		catch(ITMException itme)
		{
			BaseLogger.log("0",null,null,"ITMException :UserActLogSaveToDB :saveEventLog :==>");
			throw itme;
		}
		catch(SQLException ie)
		{
			BaseLogger.log("0",null,null,"SQLException :UserActLogSaveToDB :saveEventLog :==>"+ie);
			try
			{
				conn.rollback();
			}
			catch (Exception sqle )
			{
				throw new ITMException( sqle );
			}
			throw new ITMException(ie);
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :UserActLogSaveToDB :saveEventLog :==>"+e);
			try
			{
				conn.rollback();
			}
			catch (Exception sqle )
			{
				throw new ITMException( sqle );
			}
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(mPstmt != null)
					{
						mPstmt.close();
						mPstmt = null;
					}

				}
			}
			catch(Exception e)
			{
				throw new ITMException(e);
			}
		}
		return flag;
	}

	/** This method will give the list of user's file names
	 * @param dirPath location of log file
	 * @param userCode user code
	 * @return user log  file's name
	 */

	private ArrayList<String> getUserFiles(String fileName ,String date)
	{
		int tokentCount;
		String[] list=null;
		int count = 0;
		//File f = new File(dirPath);
		//File[] files  = f.listFiles();
		list= fileName.split(",");
		tokentCount=list.length;
		ArrayList<String> fileNameList = new ArrayList<String>();
		if( list != null )
		{
			for( int index=0; index < tokentCount; index++ )
			{
				count ++;
				String value=list[index];
				//File file = files[index];
				fileNameList.add( value+"_"+date+".txt" );
				/*if( file.isDirectory() )
				{
					BaseLogger.log("0",null,null,"file absolutepath["+file.getAbsolutePath()+"]");
				}*/
			}
			/*if( file.isDirectory() )
			{
				BaseLogger.log("0",null,null,"file absolutepath["+file.getAbsolutePath()+"]");
			}*/

		}
		BaseLogger.log("2",null,null,"fileList["+fileNameList+"] count files["+count+"]");
		return fileNameList;
	}

	/** This method will give the tag attribute value
	 * @param element node
	 * @return tag attribute value
	 */
	private  String listAllAttributes( Node element )
	{
		// get a map containing the attributes of this node
		NamedNodeMap attributes = element.getAttributes();
		String attrValue = "";
		// get the number of nodes in this map
		int numAttrs = attributes.getLength();
		for ( int i = 0; i < numAttrs; i++ )
		{
			Attr attr = (Attr) attributes.item(i);
			String attrName = attr.getNodeName();
			if( attrName.equalsIgnoreCase("USER_ID") )
			{
				attrValue = attr.getNodeValue();
			}
			else if( attrName.equalsIgnoreCase("id") )
			{
				attrValue = attr.getNodeValue();
			}
		}
		return attrValue;
	}

	/**
	 * To get list of event codes and it's descriptions
	 * @return HashMap list of key value pair's
	 * */
	//Changed by Pankaj T on 04-01-18 [changes for multitenancy]
	private HashMap<String, String> getLogEvents(UserInfoBean userInfo) throws RemoteException, ITMException
	{
		HashMap<String, String> mapEvents = new HashMap<String, String>();
		Connection conn = null;
		Statement stmt = null;
		String transDB = "";
		try
		{
			ConnDriver conDriver = new ConnDriver();
			//Changed by Pankaj T on 04-01-18 [changes for multitenancy]
			transDB = userInfo.getTransDB();
			conn = conDriver.getConnectDB(transDB);
			String selectQry = "SELECT EVENT_CODE, DESCR FROM EVENTS";
			stmt = conn.createStatement();
			ResultSet rs = stmt.executeQuery(selectQry);
			while(rs.next())
			{
				String	eventCode = rs.getString("EVENT_CODE");
				String	descrp = rs.getString("DESCR");
				mapEvents.put(eventCode, descrp);
			}
			rs.close();
			rs = null;
			stmt.close();
			stmt = null;
			conn.close();
			conn = null;
		}
		catch (Exception e)
		{
			BaseLogger.log("0",userInfo,null,"Exception :UserActLogSaveToDB :getLogEvents :==>");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				//System.err.println("Exception :UserActLogSaveToDB :getLogEvents :\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return mapEvents;
	}

	private String showLogEvents(UserInfoBean userInfo,String fileName,String date) throws RemoteException, ITMException
	{
		E12GenericUtility genericUtility = new E12GenericUtility();
		Connection conn = null;
		PreparedStatement Pstmt = null;
		ResultSet rs=null;
		String transDB = "";
		String tranId="",logDate="",empCode="",winName="",actionCode="",eventDesc="",activityEditor="",argParam="",primaryKey="",reqDate="",resDate="";
		StringBuffer xmlStrBuff = new StringBuffer("<root>");
		int j,i;
		String[] user = null;
		String userName="";
		try
		{
			ConnDriver conDriver = new ConnDriver();
			transDB = userInfo.getTransDB();
			conn = conDriver.getConnectDB(transDB);
			user=fileName.split("_");
			userName=user[0];
			String name=userName.replaceAll("(\\w+)", "\"$1\"");
			String result2 = name.replaceAll("\"", "'");
			String files=result2.replaceFirst("'", "");
			String filesSeperated=files.substring(0,files.lastIndexOf("'"));

			String formattedDate = genericUtility.getValidDateString( date, genericUtility.getDBDateFormat(),genericUtility.getApplDateFormat());

			formattedDate=formattedDate.replace("/", "-");

			String selectQry = "SELECT * FROM USER_ACT_LOG WHERE EMP_CODE IN ('"+ filesSeperated +"') and LOG_DATE= ?";
			Pstmt = conn.prepareStatement(selectQry);
			Pstmt.setString(1,formattedDate);
			rs = Pstmt.executeQuery();
			while (rs.next())
			{
				tranId = rs.getString("TRANS_DB");
				logDate = rs.getString("LOG_DATE");
				empCode = rs.getString("EMP_CODE");
				winName = rs.getString("WIN_NAME");
				actionCode = rs.getString("ACTION_CODE");
				eventDesc = rs.getString("EVENT_DES");
				activityEditor = rs.getString("ACTIVITY_EDITOR");
				argParam = rs.getString("ARG_PARAM");
				primaryKey = rs.getString("PRIMARY_KEY");
				reqDate = rs.getString("REQ_DATE_TIME");
				resDate = rs.getString("RES_DATE_TIME");
				xmlStrBuff.append("<Detail>");
				xmlStrBuff.append("<TRANS_DB>"+ tranId +"</TRANS_DB>");
				xmlStrBuff.append("<LOG_DATE>"+ logDate +"</LOG_DATE>");
				xmlStrBuff.append("<EMP_CODE>"+ empCode +"</EMP_CODE>");
				xmlStrBuff.append("<WIN_NAME>"+ winName +"</WIN_NAME>");
				xmlStrBuff.append("<ACTION_CODE>"+ actionCode +"</ACTION_CODE>");
				xmlStrBuff.append("<EVENT_DES>"+ eventDesc +"</EVENT_DES>");
				xmlStrBuff.append("<ACTIVITY_EDITOR>"+ activityEditor +"</ACTIVITY_EDITOR>");
				xmlStrBuff.append("<ARG_PARAM>"+ argParam +"</ARG_PARAM>");
				xmlStrBuff.append("<PRIMARY_KEY>"+ primaryKey +"</PRIMARY_KEY>");
				xmlStrBuff.append("<REQ_DATE_TIME>"+ reqDate +"</REQ_DATE_TIME>");
				xmlStrBuff.append("<RES_DATE_TIME>"+ resDate +"</RES_DATE_TIME>");
				xmlStrBuff.append("</Detail>");
			}
			xmlStrBuff.append("</root>");
		}
		catch (Exception e)
		{
			//BaseLogger.log("2", userInfo, null,"Exception in the showLog "+e.getMessage());
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(Pstmt != null)
					{
						Pstmt.close();
						Pstmt = null;
					}
					conn.close();
					conn = null;
					rs.close();
					rs = null;
				}
			}

			catch(Exception e)
			{
				//System.err.println("Exception :UserActLogSaveToDB :getLogEvents :\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return xmlStrBuff.toString();
	}

	public void clearUserLog(UserInfoBean userInfo, String fileName,String date)
	{
		E12GenericUtility genericUtility = new E12GenericUtility();
		Connection conn = null;
		PreparedStatement mPstmt = null;
		ResultSet rs=null;
		String transDB=null;
		String[] user=null;
		String userName="";
		try
		{
			user=fileName.split("_");
			userName=user[0];
			String name=userName.replaceAll("(\\w+)", "\"$1\"");
			String result2 = name.replaceAll("\"", "'");
			String files=result2.replaceFirst("'", "");
			String filesSeperated=files.substring(0,files.lastIndexOf("'"));

			ConnDriver conDriver = new ConnDriver();
			transDB = userInfo.getTransDB();
			conn = conDriver.getConnectDB(transDB);

			String formattedDate = genericUtility.getValidDateString( date, genericUtility.getDBDateFormat(),genericUtility.getApplDateFormat());

			String sql="DELETE FROM USER_ACT_LOG WHERE LOG_DATE=? and EMP_CODE IN ('"+ filesSeperated +"')";
			mPstmt = conn.prepareStatement(sql);
			mPstmt.setString(1,formattedDate);
			mPstmt.executeUpdate();

			conn.commit();
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :UserActLogSaveToDB :CLEAREVENT :==>"+e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(mPstmt != null)
					{
						mPstmt.close();
						mPstmt = null;
					}
					conn.close();
					conn = null;
					rs.close();
					rs = null;
				}
			}
			catch(Exception e)
			{
				BaseLogger.log("0",null,null,"Exception :UserActLogSaveToDB :connnn :==>"+e);
			}
		}
	}
	//Added by Pooja S on [27-12-2018] to Insert the User Activity Log in Database End

	//Added by Pooja S on [04-FEB-2019] To check the user Rights while accessing window in the another tab Start
	public boolean objRightsCheck( String objName, UserInfoBean userInfo, String editFlag )
	{
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		boolean isRightAvailable = false;
		try
		{
			if ( userInfo != null )
			{
				String userLevel = userInfo.getUserLevel();
				if ( "0".equalsIgnoreCase( userLevel ) )
				{
					return true;
				}
				else
				{
					String profileId = userInfo.getProfileId();

					ConnDriver conDriver = new ConnDriver();
					String transDB = userInfo.getTransDB();
					conn = conDriver.getConnectDB(transDB);
					conDriver = null;

					String sql="SELECT RIGHTS FROM USER_RIGHTS WHERE PROFILE_ID IN " + E12GenericUtility.getFormattedProfileId(profileId) + " AND OBJ_NAME ='"+objName+"'";

					stmt = conn.createStatement();
					rs = stmt.executeQuery(sql);
					String rights = "";
					while( rs.next() )
					{
						rights = rs.getString("RIGHTS");
					}
					if ( rights.indexOf(editFlag) != -1 || rights.indexOf("*") != -1 )
					{
						isRightAvailable = true;
					}
					rs.close();
					rs = null;
					stmt.close();
					stmt = null;
					conn.close();
					conn = null;
				}
			}
		}
		catch (Exception e)
		{
			BaseLogger.log( "0", userInfo, null, "Exception :UserActLogSaveToDB :getLogEvents : ["+ e.getMessage() +"]" );
		}
		finally
		{
			try
			{
				if( stmt != null )
				{
					stmt.close();
					stmt = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				BaseLogger.log("0",null,null,"Exception :UserActLogSaveToDB :connnn :==>"+e);
			}
		}
		return isRightAvailable;
	}
	 //Added by Pooja S on [04-FEB-2019] To check the user Rights while accessing window in the another tab End
	public JSONObject getBankDetails(String bankCode, UserInfoBean userInfoBean)
	{
		System.out.println("Inside getBankDetails........................1");
		JSONObject jsonResponse= new JSONObject();
		String corpId = "",userId = "",aggrId = "",urn = "",aggrName = "",ifsc = "",currCode = "", accountNo = "", bankAliasId="";
		Connection mConnection = null;
		PreparedStatement pStmt = null;
		try
		{
			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB(userInfoBean.getTransDB());
			String bankSql = "SELECT AC_NO,CORPORATE_ID,ARRG_ID,URN,ARRG_NAME,IFSC,BANK_INT_USER,CURR_CODE,BANK_INT_ALIAS FROM BANK WHERE BANK_CODE= ?";
			pStmt = mConnection.prepareStatement(bankSql);
			pStmt.setString(1, bankCode);
			ResultSet mResultSet = pStmt.executeQuery();
			if (mResultSet.next())
			{
				accountNo = mResultSet.getString("AC_NO");
				corpId = mResultSet.getString("CORPORATE_ID");
				userId = mResultSet.getString("BANK_INT_USER");
				aggrId = mResultSet.getString("ARRG_ID");
				aggrName = mResultSet.getString("ARRG_NAME");
				ifsc = mResultSet.getString("IFSC");
				currCode = mResultSet.getString("CURR_CODE");
				bankAliasId = mResultSet.getString("BANK_INT_ALIAS");
				urn = mResultSet.getString("URN");
			}

			jsonResponse.put("CORPID",corpId);
			jsonResponse.put("USERID",userId);
			jsonResponse.put("AGGRID",aggrId);
			jsonResponse.put("ARRG_NAME",aggrName);
			jsonResponse.put("URN",urn);
			jsonResponse.put("ACCOUNTNO",accountNo);
			jsonResponse.put("IFSC",ifsc);
			jsonResponse.put("CURRENCY",currCode);
			jsonResponse.put("BANK_ALIAS",bankAliasId);

			System.out.println("JSON Response............."+jsonResponse.toString());
			mResultSet.close();
			mResultSet = null;
			pStmt.close();
			pStmt = null;
			mConnection.close();
			mConnection = null;

		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccessEJB: getUsrLevForBAID :" + e);
		}
		finally
		{
			if (mConnection!=null)
			{
				try
				{
					mConnection.close();
				}
				catch (SQLException sqe)
				{
					sqe.printStackTrace();
					try {
						throw new ITMException(sqe);
					} catch (ITMException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				}
				mConnection=null;
			}
		}
		System.out.println("Inside getBankDetails........................11"+jsonResponse);
		return jsonResponse;
	}

	public Map<String, String> getAccountFromSundry(String sundryType, String sundryCode, UserInfoBean userInfoBean)
	{
		Map<String, String> accountDetMap = new HashMap<>();
		Connection connection = null;
		ConnDriver connDriver = null;
		PreparedStatement preparedStatement = null;
		ResultSet resultSet = null;
		String accountSql = "";
		String benBankAccountNo = "", benIFSCCode = "";

		try
		{
			connDriver = new ConnDriver();
			connection = connDriver.getConnectDB(userInfoBean.getTransDB());
			System.out.println("sundryType : "+sundryType);
			System.out.println("sundryCode : "+sundryCode);
			if("C".equalsIgnoreCase(sundryType)) // Customer
			{
				accountSql = "SELECT BANK_ACCT_NO__BEN, IFSC FROM CUSTOMER_BANK WHERE CUST_CODE = ?";
				preparedStatement = connection.prepareStatement(accountSql);
				preparedStatement.setString(1, sundryCode);
				resultSet = preparedStatement.executeQuery();
				if(resultSet.next())
				{
					benBankAccountNo = resultSet.getString("BANK_ACCT_NO__BEN");
					benIFSCCode = resultSet.getString("IFSC");
				}
				System.out.println("C benBankAccountNo : "+benBankAccountNo);
				resultSet.close();
				preparedStatement.close();
			}
			else if ("S".equalsIgnoreCase(sundryType)) // Supplier
			{
				accountSql = "SELECT BANK_ACCT_NO__BEN, IFSC FROM SUPPLIER_BANK WHERE SUPP_CODE =  ?";
				preparedStatement = connection.prepareStatement(accountSql);
				preparedStatement.setString(1, sundryCode);
				resultSet = preparedStatement.executeQuery();
				if(resultSet.next())
				{
					benBankAccountNo = resultSet.getString("BANK_ACCT_NO__BEN");
					benIFSCCode = resultSet.getString("IFSC");
				}
				System.out.println("S benBankAccountNo : "+benBankAccountNo);
				resultSet.close();
				preparedStatement.close();
			}
			else if ("E".equalsIgnoreCase(sundryType)) // Employee
			{
				accountSql = "SELECT BANK_ACCT, IFSC FROM EMPLOYEE_BANK WHERE EMP_CODE =  ?";
				preparedStatement = connection.prepareStatement(accountSql);
				preparedStatement.setString(1, sundryCode);
				resultSet = preparedStatement.executeQuery();
				if(resultSet.next())
				{
					benBankAccountNo = resultSet.getString("BANK_ACCT");
					benIFSCCode = resultSet.getString("IFSC");
				}System.out.println("E benBankAccountNo : "+benBankAccountNo);
				resultSet.close();
				preparedStatement.close();
			}
			else if ("X".equalsIgnoreCase(sundryType)) // Tax Authority
			{

			}
			else if ("L".equalsIgnoreCase(sundryType)) // Loan Party
			{
				accountSql = "SELECT BANK_ACCT_NO__BEN, IFSC FROM  LOANPARTY_BANK WHERE PARTY_CODE =  ?";
				preparedStatement = connection.prepareStatement(accountSql);
				preparedStatement.setString(1, sundryCode);
				resultSet = preparedStatement.executeQuery();
				if(resultSet.next())
				{
					benBankAccountNo = resultSet.getString("BANK_ACCT_NO__BEN");
					benIFSCCode = resultSet.getString("IFSC");
				}
				System.out.println("L benBankAccountNo : "+benBankAccountNo);
				resultSet.close();
				preparedStatement.close();
			}
			else if ("0".equalsIgnoreCase(sundryType)) // Others
			{

			}
			else if ("T".equalsIgnoreCase(sundryType)) // Transporter
			{
				accountSql = "SELECT BANK_ACCT_NO__BEN, IFSC FROM  TRANSPORTER_BANK WHERE TRAN_CODE = ?";
				preparedStatement = connection.prepareStatement(accountSql);
				preparedStatement.setString(1, sundryCode);
				resultSet = preparedStatement.executeQuery();
				if(resultSet.next())
				{
					benBankAccountNo = resultSet.getString("BANK_ACCT_NO__BEN");
					benIFSCCode = resultSet.getString("IFSC");
				}
				System.out.println("T benBankAccountNo : "+benBankAccountNo);
				resultSet.close();
				preparedStatement.close();
			}
			else if ("P".equalsIgnoreCase(sundryType)) // Sales Person
			{
				accountSql = "SELECT BANK_ACCT_NO__BEN, IFSC FROM  SALES_PERS_BANK WHERE SALES_PERS = ?";
				preparedStatement = connection.prepareStatement(accountSql);
				preparedStatement.setString(1, sundryCode);
				resultSet = preparedStatement.executeQuery();
				if(resultSet.next())
				{
					benBankAccountNo = resultSet.getString("BANK_ACCT_NO__BEN");
					benIFSCCode = resultSet.getString("IFSC");
				}
				System.out.println("P benBankAccountNo : "+benBankAccountNo);
				resultSet.close();
				preparedStatement.close();
			}
			else if ("R".equalsIgnoreCase(sundryType)) // Stratergic Customer
			{
				accountSql = "SELECT BANK_ACCT_NO__BEN, IFSC FROM  STRG_CUST_BANK WHERE SC_CODE = ?";
				preparedStatement = connection.prepareStatement(accountSql);
				preparedStatement.setString(1, sundryCode);
				resultSet = preparedStatement.executeQuery();
				if(resultSet.next())
				{
					benBankAccountNo = resultSet.getString("BANK_ACCT_NO__BEN");
					benIFSCCode = resultSet.getString("IFSC");
				}
				System.out.println("R benBankAccountNo : "+benBankAccountNo);
				resultSet.close();
				preparedStatement.close();
			}
			else if ("B".equalsIgnoreCase(sundryType)) // Bank
			{

			}

			accountDetMap.put("BEN_ACC_NO", benBankAccountNo);
			accountDetMap.put("BEN_IFSC_CODE", benIFSCCode);
			System.out.println("accountDetMap >>>>>>>> "+accountDetMap);
		}
		catch(Exception e)
		{
			System.out.println("Exception in DBAccessEJB.getAccountFromSundry() : "+e);
			BaseLogger.log("0",null,null,"Exception :DBAccessEJB.getAccountFromSundry() :==>"+e);
		}

		return accountDetMap;
	}

	public int updateBankRespAndStatus(String tableName, String objName, String primaryKey, String respStrFromBank, String respStatus, UserInfoBean userInfoBean) throws ITMException
	{
		ConnDriver connDriver = null;
		Connection connection = null;
		PreparedStatement pStmt = null;
		ResultSet resultSet = null;
		int updateCount = 0;
		try
		{
			connDriver = new ConnDriver();
			connection = connDriver.getConnectDB(userInfoBean.getTransDB());

			if(tableName != null)
			{
				String updateTransactionTable = "UPDATE "+tableName+" SET BANK_RESPONSE = ?, BANK_RESP_STAT = ? WHERE TRAN_ID = ?";
				pStmt = connection.prepareStatement(updateTransactionTable);
				pStmt.setString(1, respStrFromBank);
				pStmt.setString(2, respStatus);
				pStmt.setString(3, primaryKey);
				updateCount = pStmt.executeUpdate();
				if(updateCount > 0)
				{
					connection.commit();
				}
			}
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(connection != null)
				{
					if(resultSet != null)
					{
						resultSet.close();
						resultSet = null;
					}
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
					connection.close();
					connection = null;
				}
			}
			catch(Exception e)
			{
				BaseLogger.log("0",null,null,"DBAccessEJB.updateTransactionStatus() :connnn :==>"+e);
			}
		}
		return 0;
	}

	//Changed by Sainath T. on 28-05-19 [To Check userRights for object]-START
	/**
	 * It validates the object against the user rights.
	 *
	 * @param objName
	 * @param userinfo
	 * @return 0 if not having rights to access object
	 * @throws Exception
	 */
	public int validateObjectUserRights(String objName, UserInfoBean userinfo)
	{
		BaseLogger.log("3", userinfo, null, "IN validateObjectUserRights>>");

		ConnDriver ConnDriver = null;
		String transDB = null;
		Connection connection = null;
		Statement statement = null;
		ResultSet resultSet = null;
		String profilId = userinfo.getProfileId();
		int colCount = 0;
		try
		{
			ConnDriver = new ConnDriver();
			transDB=userinfo.getTransDB();
			connection = ConnDriver.getConnectDB(transDB);
			statement = connection.createStatement();
			//String query = "SELECT * FROM USER_RIGHTS WHERE PROFILE_ID = '"+profilId+"' AND OBJ_NAME = '"+objName+"'";
			String query = "SELECT * FROM USER_RIGHTS WHERE PROFILE_ID IN " + E12GenericUtility.getFormattedProfileId(profilId) + " AND OBJ_NAME ='"+objName+"'";
			resultSet = statement.executeQuery(query);
			while(resultSet.next())
			{
				colCount ++;
			}
		}
		catch (Exception e) {
			BaseLogger.log("3", userinfo, null, e.getMessage());
			BaseLogger.log("3", userinfo, null, "Error in validateObjectUserRights method in RIArequesthandlerservlet");
		}
		finally
		{
			try
			{
				if ( resultSet != null )
				{
					resultSet.close();
					resultSet = null;
				}
				if ( statement != null )
				{
					statement.close();
					statement = null;
				}
				if ( connection != null )
				{
					connection.close();
					connection = null;
				}

			}
			catch(Exception ex)
			{
				BaseLogger.log("0", userinfo,  null,"Finally Exception : "+ex.getMessage());
				ex.printStackTrace();
			}
		}
		return colCount;
	}
	//Changed by Sainath T. on 28-05-19 [To Check userRights for object]-END

	//Changed by saiprasad G. for tracing the bank request. [START]
	/**
	 * This method is used for insert the all bank request and response in BANK_INTEGRATION_LOG table
	 * @param refSer is used to set store the refSer
	 * @param refId is used to store the refId
	 * @param objName is used to store the objName
	 * @param userReq is used to store the user request
	 * @param bankResp is used to store the bank response
	 * @param serviceName is used to store which action is user selected
	 * @param userInfoBean is used to get the chg user and chg term
	 * @return tranId get tran_id
	 */
	public String insertBankReqLog( String refSer , String refId , String objName , String userReq , String bankResp , String serviceName  ,  UserInfoBean userInfoBean )
	{
		Connection con = null;
		PreparedStatement pStmt = null;
		ConnDriver connDriver = new ConnDriver();
		E12GenericUtility genericUtility = new E12GenericUtility();
		String tranId ="";
		int i=0;
		try
		{
			Date todayDate = new Date();
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getDBDateFormat());
			String chgDateStr = simpleDateFormat.format(todayDate);
			Date chgDate = simpleDateFormat.parse(chgDateStr);
			Timestamp chgDateTs = new Timestamp(chgDate.getTime());
			String userId = userInfoBean.getLoginCode();
			String chgTerm = userInfoBean.getRemoteHost();
			con = connDriver.getConnectDB(userInfoBean.getTransDB());
			StringBuilder sql = new StringBuilder();
			TransIDGenerator tranIdGen = new TransIDGenerator("<Root></Root>", userId , userInfoBean.getTransDB());
			tranId = tranIdGen.generateTranSeqID("S_BANK", "TRAN_ID", "seq10", con);
			sql.append("INSERT INTO BANK_INTEGRATION_LOG(TRAN_ID,REF_SER,REF_ID,OBJ_NAME,USER_REQ,BANK_RESP,SERVICE_NAME,CHG_DATE,CHG_USER,CHG_TERM)");
			sql.append("VALUES (?,?,?,?,?,?,?,?,?,?)");
			pStmt = con.prepareStatement(sql.toString());
			pStmt.setString( 1 , tranId );
			pStmt.setString( 2 , refSer );
			pStmt.setString( 3 , refId );
			pStmt.setString( 4 , objName );
			pStmt.setString( 5 , userReq );
			pStmt.setString( 6 , bankResp);
			pStmt.setString( 7 , serviceName );
			pStmt.setTimestamp( 8, chgDateTs);
			pStmt.setString( 9 , userId);
			pStmt.setString( 10 , chgTerm );
			i = pStmt.executeUpdate();

			if(i > 0)
			{
				con.commit();
			}
			else
			{
				con.rollback();
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0", null, null , "Exception:"+e.getMessage());
		}
		finally
		{
			try
			{
				if(pStmt!=null)
				{
					pStmt.close();
					pStmt = null;
				}
				if(con!=null)
				{
					con.close();
					con = null;
				}
			}
			catch(Exception e)
			{
				BaseLogger.log("0", null, null , "Exception in closing resource:"+e.getMessage());
			}
		}
		return tranId;
	}
	//Changed by saiprasad G. for tracing  bank request. [END]

	//Changed by saiprasad G. for upadte bank response. [START]
	/**
	 * This method is use for the updating response from the bank response
	 * for updating the response in the BANK_INTEGRATION_LOG table
	 * @param tranId for update bank response against tran_id
	 * @param bankResp for set the bank response
	 * @param userInfo for getting userInfo
	 * @return number of updated rows
	 */
	public int updateResponseReqLog( String tranId , String bankResp , UserInfoBean userInfoBean )
	{
		Connection connection = null;
		PreparedStatement preparedStatement = null;
		int i = 0;
		try
		{
			ConnDriver connDriver = new ConnDriver();
			connection = connDriver.getConnectDB(userInfoBean.getTransDB());
			StringBuilder sql = new StringBuilder("UPDATE BANK_INTEGRATION_LOG SET BANK_RESP = ? WHERE TRAN_ID= ?");
			preparedStatement = connection.prepareStatement(sql.toString());
			preparedStatement.setString( 1 , bankResp );
			preparedStatement.setString( 2 , tranId );
			i = preparedStatement.executeUpdate();
			if(i > 0)
			{
				connection.commit();
			}
			else
			{
				connection.rollback();
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0", null, null , "Exception:"+e.getMessage());
		}
		finally
		{
			try
			{
				if(preparedStatement!=null)
				{
					preparedStatement.close();
					preparedStatement = null;
				}
				if(connection!=null)
				{
					connection.close();
					connection = null;
				}
			}
			catch(Exception e)
			{
				BaseLogger.log("0", null, null , "Exception: in closing resource"+e.getMessage());
			}
		}
		return i;
	}
	//Changed by saiprasad G. for upadte bank response. [END]

	//Added by Prasad on 03/11/19 [to add min and max attachment related details] START
	/**
	 * Get OBJ_ATTACH_CONFIG table details
	 *
	 * @param objName
	 * @param userInfo
	 * @return
	 * @throws ITMException
	 */
	private HashMap<String, String> getObjAttachConfigMinMaxAttachDetails( String objName, Connection conn, String transDB )
	{
		HashMap<String, String> attachMinMaxDetailMap = new HashMap<String, String>();
		PreparedStatement pstmt = null;
		ResultSet rs=null;
		boolean isLocalConn = false;
		try
		{
			if ( conn == null )
			{
				ConnDriver conDriver = new ConnDriver();
				conn = conDriver.getConnectDB( transDB );
				conDriver = null;
				isLocalConn = true;
			}
			if ( objName != null && objName.startsWith( "w_" ) )
			{
				objName = objName.substring( 2 );
			}
			String selectQry = "SELECT SUM(MIN_ATTACH_REQ) AS MIN_ATTACH_REQ, SUM(MAX_ATTACH_ALLOW) AS MAX_ATTACH_ALLOW FROM OBJ_ATTACH_CONFIG WHERE OBJ_NAME = ?";
			pstmt = conn.prepareStatement( selectQry );
			pstmt.setString( 1, objName );
			rs = pstmt.executeQuery();

			ResultSetMetaData rsmd = rs.getMetaData();
			while( rs.next() )
			{
				int noOfColumns = rsmd.getColumnCount();
				for(int ctr = 1; ctr <= noOfColumns; ctr++)
				{
					if( "mysql".equalsIgnoreCase( CommonConstants.DB_NAME ) )
					{
						attachMinMaxDetailMap.put( rsmd.getColumnName(ctr).toUpperCase(), rs.getString(ctr) );
					}
					else
					{
						attachMinMaxDetailMap.put( rsmd.getColumnName(ctr), rs.getString(ctr) );
					}
				}
			}
		}
		catch (Exception e)
		{
			BaseLogger.log( "0", null, null, "Exception in getObjAttachConfigMinMaxAttachDetails ["+ e.getMessage() +"]" );
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( conn != null && isLocalConn )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{

			}
		}
		BaseLogger.log( "3", null, null, "attachMinMaxDetailMap ["+ attachMinMaxDetailMap +"]" );
		return attachMinMaxDetailMap;
	}
	//Added by Prasad on 03/11/19 [to add min and max attachment related details] END

	//Added By Pankaj T. on 14-11-19 [ for display data model list on schedule report argument page ] - start
	public ArrayList<String> getDataModelList( UserInfoBean userInfo) throws ITMException
	{
		System.out.println("DBAccessEJB.getDataModelList()");
		ArrayList<String> dataModelList = new ArrayList<>();
		PreparedStatement preparedStatement = null;
		ResultSet resultSet = null;
		Connection connection = null;
		try
		{
			try
			{
				ConnDriver connDriver = new ConnDriver();
				connection = connDriver.getConnectDB(userInfo.getTransDB());
				String sql = "SELECT DATA_MODEL FROM DATA_MODEL ORDER BY DATA_MODEL";
				preparedStatement = connection.prepareStatement(sql);
				resultSet = preparedStatement.executeQuery();
				while( resultSet.next() )
				{
					dataModelList.add(resultSet.getString("DATA_MODEL"));
				}
			}
			catch (Exception e)
			{
				System.out.println("DBAccessEJB.getDataModelList() Exception :["+E12GenericUtility.getStackTrace(e)+"]");
				throw new ITMException(e);
			}
			System.out.println("DBAccessEJB.getDataModelList() dataModelList:["+dataModelList+"]");
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( preparedStatement != null )
				{
					preparedStatement.close();
					preparedStatement = null;
				}
				if( connection != null )
				{
					connection.close();
					connection = null;
				}
			}
			catch (Exception e2)
			{
				e2.printStackTrace();
			}
		}
		return dataModelList;
	}
	//Added By Pankaj T. on 14-11-19 [ for display data model list on schedule report argument page ] - end

	//Added by shrutika on 03-12-19 [Start] for update SITE_CODE__DEF in user master when change site code.
	public void updateUserMaster(String userCode, String siteCode) throws ITMException
	{
		BaseLogger.log("3", null, null,"inside updateUserMaster.....22230["+siteCode+"]userCode["+userCode+"]");
		Connection conn = null;
		PreparedStatement pstmt = null;
		ConnDriver connDriver = new ConnDriver();
		try
		{
			conn = connDriver.getConnectDB( "Driver" );
			//Added by shrutika on 05-12-19 Update is not working in QC database.
			conn.setAutoCommit(false);
			String sqlString  = "UPDATE USERS SET SITE_CODE__DEF = ? WHERE CODE = ? " ;
			pstmt = conn.prepareStatement(sqlString);
			pstmt.setString(1,siteCode);
			pstmt.setString(2,userCode);
			pstmt.executeUpdate();
			//Added by shrutika on 05-12-19  Update is not working in QC database.
			conn.commit();
			pstmt.close();
			pstmt = null;
			if(conn!=null)
			{
				conn.close();
				conn = null;
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null,"Exception updateUserMaster method["+e.getMessage()+"]");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				BaseLogger.log("0", null, null,"Exception updateUserMaster method in finally["+e.getMessage()+"]");
			}
		}
	}
	//Added by shrutika on 03-12-19 [End] for update SITE_CODE__DEF in user master when change site code.

	//Added By Ravindra C on 10-02-20 for upload max attachment size validation - Start
	public String getMaxFileUploadSize( String objName, Connection conn, UserInfoBean userInfo )
	{
		String maxFileUploadSize = "";
		ConnDriver connDriver = null;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String sql ="";
		ResultSet rs1 = null;
		PreparedStatement pstmt1 = null;
		boolean isLocalConnection = false;
		String transDB = "";
		try
		{
			if(userInfo !=null)
			{
				transDB = checkNull( userInfo.getTransDB() );
			}
			transDB = transDB.trim().length() > 0 ? transDB : "DriverITM";

			if(conn == null)
			{
				connDriver = new ConnDriver();
				conn = connDriver.getConnectDB( transDB );
				isLocalConnection = true;
			}

			sql ="SELECT MAX_FILE_SIZE FROM OBJ_ATTACH_CONFIG where OBJ_NAME = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, objName);
			rs= pstmt.executeQuery();
			if( rs.next() )
			{
				maxFileUploadSize = checkNull( rs.getString("MAX_FILE_SIZE") );
			}
			BaseLogger.log("3",null,null,"maxFileUploadSize : - ["+ maxFileUploadSize +"]");
			rs.close();
			pstmt.close();

			if(maxFileUploadSize.trim().length() == 0)
			{
				String sql1 ="";
				sql1 ="SELECT MAX_FILE_SIZE FROM OBJ_ATTACH_CONFIG where OBJ_NAME ='X'";
				pstmt1 = conn.prepareStatement(sql1);
				rs1 = pstmt1.executeQuery();
				if( rs1.next() )
				{
					maxFileUploadSize = checkNull( rs.getString("MAX_FILE_SIZE") );
				}
				BaseLogger.log("3",null,null,"maxFileUploadSize for X: - ["+ maxFileUploadSize +"]");
				rs1.close();
				pstmt1.close();
			}
			if(maxFileUploadSize.trim().length() == 0)
			{
				maxFileUploadSize = CommonConstants.MAX_FILE_SIZE;
				BaseLogger.log("3",null,null,"maxFileUploadSize from CommonConstant : - ["+ maxFileUploadSize +"]");
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			BaseLogger.log("0",null,null,"In the getMaxFileUploadSize Exception :["+ e.getMessage() +"]");
		}
		finally
		{
			try
			{
				if( rs !=null)
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( rs1 !=null)
				{
					rs1.close();
					rs1 = null;
				}
				if( pstmt1 !=null)
				{
					pstmt1.close();
					pstmt1 = null;
				}
				if( conn !=null && isLocalConnection )
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e2)
			{
				e2.printStackTrace();
				BaseLogger.log("3",null,null,"In the getMaxFileUploadSize finally block Exception ["+ e2.getMessage() +"]");
			}
		}
		return maxFileUploadSize;
	}
	//Added By Ravindra C on 10-02-20 for upload max attachment size validation - End
	//Added by Nilesh on 27/03/2020 [to add min and max and show_del_attch attachment related details] START
	/**
	 * Get OBJ_ATTACH_CONFIG table details
	 *
	 * @param objName
	 * @param userInfo
	 * @return
	 * @throws ITMException
	 */
	public HashMap<String, String> getObjAttachConfigMinMaxshowDelAttachDetails( String objName, String transDB )
	{
		HashMap<String, String> attachMinMaxDetailMap = new HashMap<String, String>();
		PreparedStatement pstmt = null;
		ResultSet rs=null;
		boolean isLocalConn = false;
		Connection conn = null;
		try
		{
			ConnDriver conDriver = new ConnDriver();
			conn = conDriver.getConnectDB( transDB );
			conDriver = null;

			if ( objName != null && objName.startsWith( "w_" ) )
			{
				objName = objName.substring( 2 );
			}
			String selectQry = "SELECT MIN_ATTACH_REQ, MAX_ATTACH_ALLOW,SHOW_DEL_ATTACH FROM OBJ_ATTACH_CONFIG WHERE OBJ_NAME = ? ";
			pstmt = conn.prepareStatement( selectQry );
			pstmt.setString( 1, objName );
			rs = pstmt.executeQuery();

			ResultSetMetaData rsmd = rs.getMetaData();
			while( rs.next() )
			{
				int noOfColumns = rsmd.getColumnCount();
				for(int ctr = 1; ctr <= noOfColumns; ctr++)
				{
					if( "mysql".equalsIgnoreCase( CommonConstants.DB_NAME ) )
					{
						attachMinMaxDetailMap.put( rsmd.getColumnName(ctr).toUpperCase(), rs.getString(ctr) );
					}
					else
					{
						attachMinMaxDetailMap.put( rsmd.getColumnName(ctr), rs.getString(ctr) );
					}
				}
			}
		}
		catch (Exception e)
		{
			BaseLogger.log( "0", null, null, "Exception in getObjAttachConfigMinMaxshowDelAttachDetails ["+ e.getMessage() +"]" );
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( conn != null  )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{

			}
		}
		BaseLogger.log( "3", null, null, "getObjAttachConfigMinMaxshowDelAttachDetails ["+ attachMinMaxDetailMap +"]" );
		return attachMinMaxDetailMap;
	}
	//Added by Nilesh on 27/03/2020 [to add min and max and show_del_attch attachment related details] End

	// added by Mahesh Saggam on 31/03/2020 [to create user interface for follow-up-action] Start
	public String getFollowUpActionResp(String objName, String transDB) throws ITMException, JSONException
	{
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Connection conn = null;
		String lineNo = "";
		String actionId = "";
		String actionType = "";
		String actionInfo = "";
		String condExp  = "";
		String condInp = "";
		JSONArray flwUpActionArr = new JSONArray();
		JSONObject flwUpActionObj = new JSONObject();
		JSONObject flwUpActionRoot = new JSONObject();

		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( transDB );
			connDriver = null;

			sql = "SELECT * FROM OBJ_FOLLOWUP_ACT WHERE OBJ_NAME=? ORDER BY LINE_NO";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, objName);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				JSONObject flwUpChildObj = new JSONObject();
				lineNo = checkNull(rs.getString("LINE_NO"));
				actionId = checkNull(rs.getString("ACTION_ID"));
				actionType = checkNull(rs.getString("ACTION_TYPE"));
				actionInfo = checkNull(rs.getString("ACTION_INFO"));
				condExp = checkNull(rs.getString("CONDITIONAL_EXPRESSION"));
				condInp = checkNull(rs.getString("CONDITIONAL_INPUT"));

				flwUpChildObj.put("OBJ_NAME", objName);
				flwUpChildObj.put("LINE_NO", lineNo);
				flwUpChildObj.put("ACTION_ID", actionId);
				flwUpChildObj.put("ACTION_TYPE", actionType.toUpperCase());
				flwUpChildObj.put("ACTION_INFO", actionInfo);
				flwUpChildObj.put("CONDITIONAL_EXPRESSION", condExp);
				flwUpChildObj.put("CONDITIONAL_INPUT", condInp);

				flwUpActionArr.put(flwUpChildObj);
			}
			flwUpActionObj.put("FOLLOW_UP_ACTION", flwUpActionArr);
			flwUpActionRoot.put("ROOT", flwUpActionObj);

		}
		catch(SQLException se)
		{
			BaseLogger.log("0", null, null,"DBAccessEJB.getFollowUpActionResp().inSQLException["+se.getMessage()+"]");
			se.printStackTrace();
			throw new ITMException(se);
		}
		catch(Exception e)
		{
			BaseLogger.log("0", null, null,"DBAccessEJB.getFollowUpActionResp()["+e.getMessage()+"]");
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				if( conn != null && !conn.isClosed())
				{
					conn.close();
					conn = null;
				}
			}
			catch(SQLException se)
			{
				BaseLogger.log("0", null, null,"DBAccessEJB.getFollowUpActionResp() in finally["+se.getMessage()+"]");
				se.printStackTrace();
				throw new ITMException(se);
			}
		}
		BaseLogger.log("0", null, null,"response inside getFollowUpActionResp 22538"+flwUpActionRoot.toString()+"]");
		return flwUpActionRoot.toString();
	}
	public void addFollowUpAction(String objName, String lineNo, String actionId, String actionType, String actionInfo,
			String condExpr, String condInpt, String viewMode, UserInfoBean userInfo) throws ITMException
	{

		String sql = "";
		String resultString = "";
		String xmlString = "";
		PreparedStatement pstmt = null;
		Connection conn = null;


		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( userInfo.getTransDB() );
		  if("Add".equalsIgnoreCase(viewMode))
		  {
			  sql = "Insert into OBJ_FOLLOWUP_ACT (OBJ_NAME,LINE_NO,ACTION_ID,ACTION_TYPE,ACTION_INFO,"
			  		+ "CONDITIONAL_EXPRESSION,CONDITIONAL_INPUT) "
			  		+ "values (?, ?, ?, ?, ?, ?, ?)"; pstmt = conn.prepareStatement(sql);
			  pstmt.setString(1, E12GenericUtility.checkNull(objName));
			  pstmt.setString(2,E12GenericUtility.checkNull(lineNo));
			  pstmt.setString(3,E12GenericUtility.checkNull(actionId));
			  pstmt.setString(4,E12GenericUtility.checkNull(actionType.toUpperCase()));
			  pstmt.setString(5,E12GenericUtility.checkNull(actionInfo.toUpperCase()));
			  pstmt.setString(6,E12GenericUtility.checkNull(condExpr));
			  pstmt.setString(7,E12GenericUtility.checkNull(condInpt));
		  }
		  else {
			  sql= "UPDATE OBJ_FOLLOWUP_ACT SET ACTION_ID=?, " +
					  "ACTION_TYPE=?, ACTION_INFO=?, CONDITIONAL_EXPRESSION=?, CONDITIONAL_INPUT=? "
					  + "where OBJ_NAME=? AND LINE_NO=?"; pstmt = conn.prepareStatement(sql);
			  pstmt.setString(1, E12GenericUtility.checkNull(actionId));
			  pstmt.setString(2,E12GenericUtility.checkNull(actionType.toUpperCase()));
			  pstmt.setString(3,E12GenericUtility.checkNull(actionInfo));
			  pstmt.setString(4,E12GenericUtility.checkNull(condExpr));
			  pstmt.setString(5,E12GenericUtility.checkNull(condInpt));
			  pstmt.setString(6,E12GenericUtility.checkNull(objName));
			  pstmt.setString(7,E12GenericUtility.checkNull(lineNo));
		  }

			pstmt.executeUpdate();
			conn.commit();
			BaseLogger.log("0", null, null,"after commit addFollowUpAction");
		}
		catch(SQLException se)
		{
			BaseLogger.log("0", null, null,"DBAccessEJB.addFollowUpAction().inSQLException 22792["+se.getMessage()+"]");
			se.printStackTrace();
			throw new ITMException(se);
		}
		catch(Exception e)
		{
			BaseLogger.log("0", null, null,"DBAccessEJB.addFollowUpAction() 22798 ["+e.getMessage()+"]");
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				if( conn != null && !conn.isClosed())
				{
					conn.close();
					conn = null;
				}
			}
			catch(SQLException se)
			{
				BaseLogger.log("0", null, null,"DBAccessEJB.addFollowUpAction() in finally 22819 ["+se.getMessage()+"]");
				se.printStackTrace();
				throw new ITMException(se);
			}
		}
	}
	public void deleteFollowUpAction(String objName, String lineNo, String actionType, String transDB) throws ITMException
	{
		String sql = "";
		Statement stmt = null;
		Connection conn = null;
		boolean isDelDraft = false;

		try
		{
			ConnDriver driver = new ConnDriver();
			conn = driver.getConnectDB(transDB);
			sql = "DELETE FROM OBJ_FOLLOWUP_ACT WHERE OBJ_NAME='"+objName+"' AND LINE_NO='"+lineNo+"' AND ACTION_TYPE='"+actionType+"'";
			stmt = conn.createStatement();

			stmt.executeUpdate(sql);
			conn.commit();
			stmt.close();
			stmt = null;
		}
		catch (ITMException itme)
		{
			System.err.println("ITMException: DBAccess: saveToDraftObjects:");
			throw itme;
		}
		catch (Exception e)
		{
			System.err.println("Exception: DBAccess: saveToDraftObjects:"  + e);
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception: DBAccess: getActionTitlesList \n" + e);
				throw new ITMException(e);
			}
		}
	}
	public String getObjNameList(String transDB) throws ITMException
	{
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Connection conn = null;
		ArrayList<String> objList = new ArrayList<>();

		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( transDB );
			connDriver = null;

			sql = "SELECT DISTINCT WIN_NAME FROM ITM2MENU WHERE OBJ_TYPE=?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "T");

			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String winName = E12GenericUtility.checkNull(rs.getString("WIN_NAME"));
				if(!"".equalsIgnoreCase(winName) && winName.trim().startsWith("w_"))
				{
					String objName= rs.getString("WIN_NAME").trim().substring(2);
					objList.add(objName);
				}
			}
			Collections.sort(objList);
		}
		catch(SQLException se)
		{
			BaseLogger.log("0", null, null,"DBAccessEJB.getFollowUpActionResp().inSQLException["+se.getMessage()+"]");
			se.printStackTrace();
			throw new ITMException(se);
		}
		catch(Exception e)
		{
			BaseLogger.log("0", null, null,"DBAccessEJB.getFollowUpActionResp()["+e.getMessage()+"]");
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				if( conn != null && !conn.isClosed())
				{
					conn.close();
					conn = null;
				}
			}
			catch(SQLException se)
			{
				BaseLogger.log("0", null, null,"DBAccessEJB.getFollowUpActionResp() in finally["+se.getMessage()+"]");
				se.printStackTrace();
				throw new ITMException(se);
			}
		}
		BaseLogger.log("0", null, null,"response inside getObjNameList 22538"+objList.toString()+"]");
		return objList.toString();
	}
	public String addSmsFormat(String jsonData, String formatCode, UserInfoBean userInfo) throws ITMException, JSONException
	{
		Connection conn = null;
		Connection conn1 = null;
		E12GenericUtility genericUtility = new E12GenericUtility();

		JSONObject jsonObj = new JSONObject(jsonData);
		System.out.println("lenght of data SMSDetais:: ["+jsonObj.length()+"]");
		Iterator<String> keys = jsonObj.keys();
		String resultString = "";
		String xmlString="";
		String detailString = "";
		try
		{
			MasterStatefulLocal masterStateful=null;
			MasterApplyEJB ms = new MasterApplyEJB();
			AppConnectParm appConnect = new AppConnectParm();
			InitialContext ctx = new InitialContext(appConnect.getProperty());
			masterStateful = (MasterStatefulLocal)ctx.lookup("ibase/MasterStatefulEJB/local");
			masterStateful.setUserInfo(userInfo);

			while(keys.hasNext())
			{
				String key = keys.next();
				String value = checkNull(jsonObj.getString(key));
				detailString = detailString + "<"+key.toLowerCase()+"><![CDATA["+value+"]]></"+key.toLowerCase()+">";
			}
			xmlString = "<Root>"
					+ "<DocumentRoot>"
						+ "<description>Datawindow Root</description>"
						+ "<group0>"
							+ "<description>Group0 description</description>"
							+ "<Header0>"
								+ "<objName><![CDATA[sms_format]]></objName>"
								+ "<pageContext><![CDATA[1]]></pageContext>"
								+ "<objContext><![CDATA[1]]></objContext>"
								+ "<editFlag><![CDATA[A]]></editFlag>"
								+ "<focusedColumn><![CDATA[]]></focusedColumn>"
								+ "<action><![CDATA[SAVE]]></action>"
								+ "<elementName><![CDATA[]]></elementName>"
								+ "<keyValue><![CDATA[1]]></keyValue>"
								+ "<taxKeyValue><![CDATA[]]></taxKeyValue>"
								+ "<saveLevel><![CDATA[1]]></saveLevel>"
								+ "<forcedSave><![CDATA[true]]></forcedSave>"
								+ "<taxInFocus><![CDATA[false]]></taxInFocus>"
								+ "<description>Header0 Members</description>"
								+ "<pkValues><![CDATA[]]></pkValues>"
								+ "<Detail1 dbID=\"\" domID=\"1\" objName=\"sms_format\" objContext=\"1\">"
								+ "<attribute pkNames=\"format_code:\" status=\"N\" updateFlag=\"A\" selected=\"N\"/>"
								+ detailString
								+ "</Detail1>"
							+ "</Header0>"
						+ "</group0>"
					+ "</DocumentRoot>"
					+ "</Root>";
			HashMap<String, String> transactionDetailMap = ms.getTransactionDetailForEdit( conn, xmlString, userInfo.toString() );// Added by AMit D  For Testing
			System.out.println("transactionDetailMap.get()::: 23115 ["+transactionDetailMap.get("IS_RECORD_EXIST")+"]");
			if("Y".equalsIgnoreCase(transactionDetailMap.get("IS_RECORD_EXIST")))
			{
				xmlString = "<Root>"
						+ "<DocumentRoot>"
							+ "<description>Datawindow Root</description>"
							+ "<group0>"
								+ "<description>Group0 description</description>"
								+ "<Header0>"
									+ "<objName><![CDATA[sms_format]]></objName>"
									+ "<pageContext><![CDATA[1]]></pageContext>"
									+ "<objContext><![CDATA[1]]></objContext>"
									+ "<editFlag><![CDATA[E]]></editFlag>"
									+ "<focusedColumn><![CDATA[]]></focusedColumn>"
									+ "<action><![CDATA[EDIT]]></action>"
									+ "<elementName><![CDATA[]]></elementName>"
									+ "<keyValue><![CDATA[1]]></keyValue>"
									+ "<taxKeyValue><![CDATA[]]></taxKeyValue>"
									+ "<saveLevel><![CDATA[1]]></saveLevel>"
									+ "<forcedSave><![CDATA[true]]></forcedSave>"
									+ "<taxInFocus><![CDATA[false]]></taxInFocus>"
									+ "<description>Header0 Members</description>"
									+ "<pkValues><![CDATA[]]></pkValues>"
									+ "<Detail1 dbID=\""+formatCode+"\" domID=\"1\" objName=\"sms_format\" objContext=\"1\">"
									+ "<attribute pkNames=\"format_code:\" status=\"N\" updateFlag=\"A\" selected=\"N\"/>"
									+ detailString
									+ "</Detail1>"
								+ "</Header0>"
							+ "</group0>"
						+ "</DocumentRoot>"
						+ "</Root>";
				xmlString = ms.updateXml( transactionDetailMap, xmlString );
			}
			System.out.println("print xmlString:: ["+xmlString+"]");
			resultString = masterStateful.processRequest(userInfo, xmlString, true, conn1);
			System.out.println("print resultString:: ["+resultString+"]");

		}
		catch(Exception e)
		{
			BaseLogger.log("0", null, null,"DBAccessEJB.getFollowUpActionResp()["+e.getMessage()+"]");
			e.printStackTrace();
		}
		return resultString;
	}
	public String addEmailFormat(String jsonData, String formatCode, UserInfoBean userInfo) throws ITMException, JSONException
	{
		JSONObject jsonObj = new JSONObject(jsonData);
		System.out.println("lenght of data emaiDetais:: ["+jsonObj.length()+"]");
		Iterator<String> keys = jsonObj.keys();

		Connection conn = null;
		Connection conn1 = null;
		String detailString = "";
		String xmlString="";
		String resultString = "";
		try
		{
			MasterStatefulLocal masterStateful=null;
			MasterApplyEJB ms = new MasterApplyEJB();
			AppConnectParm appConnect = new AppConnectParm();
			InitialContext ctx = new InitialContext(appConnect.getProperty());
			masterStateful = (MasterStatefulLocal)ctx.lookup("ibase/MasterStatefulEJB/local");
			masterStateful.setUserInfo(userInfo);

			while(keys.hasNext())
			{
				String key = keys.next();
				String value = checkNull(jsonObj.getString(key));
				System.out.println("key smsFormat:: ["+key+"]");
				System.out.println("value smsFormat:: ["+value+"]");
				detailString = detailString + "<"+key.toLowerCase()+"><![CDATA["+value+"]]></"+key.toLowerCase()+">";
			}
			xmlString = "<Root>"
					+ "<DocumentRoot>"
						+ "<description>Datawindow Root</description>"
						+ "<group0>"
							+ "<description>Group0 description</description>"
							+ "<Header0>"
								+ "<objName><![CDATA[mail_format]]></objName>"
								+ "<pageContext><![CDATA[1]]></pageContext>"
								+ "<objContext><![CDATA[1]]></objContext>"
								+ "<editFlag><![CDATA[A]]></editFlag>"
								+ "<focusedColumn><![CDATA[]]></focusedColumn>"
								+ "<action><![CDATA[SAVE]]></action>"
								+ "<elementName><![CDATA[]]></elementName>"
								+ "<keyValue><![CDATA[1]]></keyValue>"
								+ "<taxKeyValue><![CDATA[]]></taxKeyValue>"
								+ "<saveLevel><![CDATA[1]]></saveLevel>"
								+ "<forcedSave><![CDATA[true]]></forcedSave>"
								+ "<taxInFocus><![CDATA[false]]></taxInFocus>"
								+ "<description>Header0 Members</description>"
								+ "<pkValues><![CDATA[]]></pkValues>"
								+ "<Detail1 dbID=\"\" domID=\"1\" objName=\"mail_format\" objContext=\"1\">"
								+ "<attribute pkNames=\"format_code:\" status=\"N\" updateFlag=\"A\" selected=\"N\"/>"
								+ detailString
								+ "</Detail1>"
							+ "</Header0>"
						+ "</group0>"
					+ "</DocumentRoot>"
					+ "</Root>";
			HashMap<String, String> transactionDetailMap = ms.getTransactionDetailForEdit( conn, xmlString, userInfo.toString() );// Added by AMit D  For Testing
			System.out.println("transactionDetailMap.get()::: 23314 ["+transactionDetailMap.get("IS_RECORD_EXIST")+"]");
			if("Y".equalsIgnoreCase(transactionDetailMap.get("IS_RECORD_EXIST")))
			{
				xmlString = "<Root>"
						+ "<DocumentRoot>"
							+ "<description>Datawindow Root</description>"
							+ "<group0>"
								+ "<description>Group0 description</description>"
								+ "<Header0>"
									+ "<objName><![CDATA[mail_format]]></objName>"
									+ "<pageContext><![CDATA[1]]></pageContext>"
									+ "<objContext><![CDATA[1]]></objContext>"
									+ "<editFlag><![CDATA[E]]></editFlag>"
									+ "<focusedColumn><![CDATA[]]></focusedColumn>"
									+ "<action><![CDATA[EDIT]]></action>"
									+ "<elementName><![CDATA[]]></elementName>"
									+ "<keyValue><![CDATA[1]]></keyValue>"
									+ "<taxKeyValue><![CDATA[]]></taxKeyValue>"
									+ "<saveLevel><![CDATA[1]]></saveLevel>"
									+ "<forcedSave><![CDATA[true]]></forcedSave>"
									+ "<taxInFocus><![CDATA[false]]></taxInFocus>"
									+ "<description>Header0 Members</description>"
									+ "<pkValues><![CDATA[]]></pkValues>"
									+ "<Detail1 dbID=\""+formatCode+"\" domID=\"1\" objName=\"mail_format\" objContext=\"1\">"
									+ "<attribute pkNames=\"format_code:\" status=\"N\" updateFlag=\"A\" selected=\"N\"/>"
									+ detailString
									+ "</Detail1>"
								+ "</Header0>"
							+ "</group0>"
						+ "</DocumentRoot>"
						+ "</Root>";
				xmlString = ms.updateXml( transactionDetailMap, xmlString );
			}
			System.out.println("print emailXmlString:: ["+xmlString+"]");
			resultString = masterStateful.processRequest(userInfo, xmlString, true, conn1);
			System.out.println("print emailResultString:: ["+resultString+"]");
		}
		catch(Exception e)
		{
			BaseLogger.log("0", null, null,"DBAccessEJB.getFollowUpActionResp()["+e.getMessage()+"]");
			e.printStackTrace();
		}
		return resultString;
	}
	// added by Mahesh Saggam on 31/03/2020 [to create user interface for follow-up-action] End

	//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - start
	public String getTransactionMessages( UserInfoBean userInfo, String objName )
	{
		StringBuffer messageStr = new StringBuffer();
		try
		{
			E12GenericUtility e12GenericUtility = new E12GenericUtility();
			String columnName = "";
			String errorString = "";

			messageStr.append("<Messages>");

			columnName = getDBColumnValue("TRANSETUP", "CONFIRM_COL", "TRAN_WINDOW = 'w_"+objName+"'", userInfo.getTransDB());
			System.out.println("DBAccessEJB.getTransactionMessages() columnName:["+columnName+"]");
			errorString = e12GenericUtility.getErrorMessage(columnName, "NOEDITC", userInfo.getLoginCode());
			System.out.println("DBAccessEJB.getTransactionMessages() errorString:["+errorString+"]");
			messageStr.append(errorString);

			columnName = getDBColumnValue("TRANSETUP", "CANCEL_COL", "TRAN_WINDOW = 'w_"+objName+"'", userInfo.getTransDB());
			System.out.println("DBAccessEJB.getTransactionMessages() columnName:["+columnName+"]");
			errorString = e12GenericUtility.getErrorMessage(columnName, "NOEDITX", userInfo.getLoginCode());
			System.out.println("DBAccessEJB.getTransactionMessages() errorString:["+errorString+"]");
			messageStr.append(errorString);

			columnName = getDBColumnValue("TRANSETUP", "CLOSE_COL", "TRAN_WINDOW = 'w_"+objName+"'", userInfo.getTransDB());
			System.out.println("DBAccessEJB.getTransactionMessages() columnName:["+columnName+"]");
			errorString = e12GenericUtility.getErrorMessage(columnName, "NOEDITL", userInfo.getLoginCode());
			System.out.println("DBAccessEJB.getTransactionMessages() errorString:["+errorString+"]");
			messageStr.append(errorString);

			columnName = "";
			System.out.println("DBAccessEJB.getTransactionMessages() columnName:["+columnName+"]");
			errorString = e12GenericUtility.getErrorMessage(columnName, "NOEDITO", userInfo.getLoginCode());
			System.out.println("DBAccessEJB.getTransactionMessages() errorString:["+errorString+"]");
			messageStr.append(errorString);

			messageStr.append("</Messages>");
		}
		catch (Exception e)
		{
			System.out.println("DBAccessEJB.getTransactionMessages() EXCEPTION :["+E12GenericUtility.getStackTrace(e)+"]");
		}
		System.out.println("DBAccessEJB.getTransactionMessages():["+messageStr.toString()+"");
		return messageStr.toString();
	}
	//Added By Pankaj T. on 02-04-2020 for display Need different messages on canceling already cancelled transaction. Row level security is applied on confirm col/val, cancel col/val, close col/val & edit expression. - end

	//Added By Ravindra C on 30-05-2020 to get table column name type - Start
	public HashMap<String, String> getColLogNameTypeMap(String tableName, UserInfoBean userInfo)
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		HashMap<String, String> colLogNameTypeMap = new HashMap<String, String>();
		try
		{
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			String transDB = checkNull( userInfo.getTransDB());
			if( transDB.trim().length() > 0 )
			{
				conn = connDriver.getConnectDB( transDB );
			}
			connDriver = null;
			DatabaseMetaData metadata = conn.getMetaData();
			rs = metadata.getTables(null, null, tableName.toUpperCase(), null);
			if(rs.next())
			{
				BaseLogger.log("3",userInfo, null,"["+ tableName +"] -- table exists");
				rs.close();
				rs = null;

				String sql = "SELECT *  FROM " + tableName + " WHERE 1 = 2";
				BaseLogger.log("3", userInfo, null, "getColLogNameTypeMap sql : [" + sql + "]");
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();

				ResultSetMetaData rsmd = rs.getMetaData();
				String columnNames = "", columnValue = "";
				for( int i = 1; i <= rsmd.getColumnCount(); i++ )
				{
					String colTypeName = rsmd.getColumnTypeName(i);
					String colName = rsmd.getColumnLabel(i);
					colName = colName.toLowerCase();
					colTypeName = colTypeName.toLowerCase();
					colLogNameTypeMap.put(colName, colTypeName);
				}
			}
			rs.close();
			pstmt.close();
			conn.close();
		}
		catch(Exception e)
		{
			e.printStackTrace();
			BaseLogger.log( "0", userInfo, null, "In the getColLogNameTypeMap Exception : ["+ e.getMessage() +"]" );
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e1)
			{
				e1.printStackTrace();
			}
		}
		return colLogNameTypeMap;
	}
	//Added By Ravindra C on 30-05-2020 to get table column name type - End
	
	//Added by Sadique on 18/07/2020 [to column reorder related functionality] START
	public String applyReorderTableColumnProperties( org.json.JSONObject jsonObject, UserInfoBean userInfo )
	{
		String xmlPropertiesString = "";
		String dataPropertieseStr = "";
		String metaDatafileName = "";
		String formName = "" ,formNo ="", objName ="", logicalname = "", pageContext = "" , objType = "";
		pageContext = "1";
		try 
		{
			//Changed by sadique shaikh on 20-07-2020 for Multiple Drag and drop start		
			org.json.JSONObject jsonObjectMetadata = jsonObject.getJSONObject("REORDER_DATA");
			formName = jsonObjectMetadata.getString("FORM_NAME");
			formNo = jsonObjectMetadata.getString("FORM_NO");
			objName = jsonObjectMetadata.getString("OBJ_NAME");
			//Added by sadique shaikh 03-03-2021 [for reorder changes in homepage]
			objType = jsonObjectMetadata.getString("OBJ_TYPE");
			jsonObjectMetadata.put( "PAGE_CTX", pageContext );
			//Changed by sadique shaikh on 20-07-2020 for Multiple Drag and drop End
			String newObjContext = "";
			if ( formName != null && formName.trim().length() > 0 && ! "null".equalsIgnoreCase( formName ) )
			{
				newObjContext = formName;
			}
			else
			{
				newObjContext = formNo;
			}
			//Changed by Sadique on 22/03/2021 [to support reorder column functionality in case of profile_id_res is not available]
			String cacheMetadataFileName = userInfo.getEnterprise()+"-"+userInfo.getProfileIdRes()+"-"+userInfo.getLoginCode()+"~~"+objName+pageContext+newObjContext;
			//Changed by Prasad on 23/11/2020 [check infinispanLocalObj not null]
			if ( infinispanLocalObj != null )
			{
				infinispanLocalObj.removeFormData( cacheMetadataFileName );
			}
			
			//Added by sadique shaikh on 20-07-2020 to remove infinispanLocalObj Start
			if ( formName != null && ! "null".equalsIgnoreCase(formName) && formName.trim().length() > 0 )
			{
				metaDatafileName = objName + pageContext + formName;
			}
			else
			{
				metaDatafileName = objName+""+pageContext+""+formNo;
			}
			//Changed by Prasad on 23/11/2020 [check infinispanLocalObj not null]
			if ( infinispanLocalObj != null )
			{
				infinispanLocalObj.remove( metaDatafileName );
			}
			//Added by sadique shaikh on 20-07-2020 to remove infinispanLocalObj End
			
			E12GenericUtility genericUtility = new E12GenericUtility();
			
			HashMap<String, String> propEditorInfoMap = new HashMap<String,String>();
			propEditorInfoMap.put( "PROFILE_ID_RES", userInfo.getProfileIdRes() );
            propEditorInfoMap.put( "ENTERPRISE_ID_RES", userInfo.getEnterprise() );
            propEditorInfoMap.put( "PROFILE_ID", checkNull( userInfo.getProfileId() ) ); //Changes by Jatin M for reorder column profile Id wise changes
			propEditorInfoMap.put( "EDITOR", "" );
			//Added by Sadique on 15/03/2021 [pass userid to apply table properties]
			propEditorInfoMap.put( "USER_ID", userInfo.getLoginCode().trim() );
		
			BaseLogger.log( "3", userInfo, null, "propEditorInfoMap " + propEditorInfoMap);
			
			String metadataFilePath = genericUtility.applyPropertiesOnMetadata( jsonObject, propEditorInfoMap, userInfo );
			BaseLogger.log( "3", userInfo, null, "metadataFilePath : ["+ metadataFilePath +"]" );
			
			String metadataXmlStr = genericUtility.readFile( metadataFilePath );
			
			BaseLogger.log( "3", userInfo, null, "objType : ["+ objType +"]" );
			//Added by sadique shaikh 03-03-2021 [for reorder changes in homepage]  start
			if( "T".equalsIgnoreCase( objType ) )
			{
				xmlPropertiesString = metadataXmlStr;
			}
			else
			{
				String targetDir = CommonConstants.APPLICATION_CONTEXT + File.separator + "temp";
				xmlPropertiesString = genericUtility.transformToString( getMetadataXSLFileName( "ME12XML2TEXT.xsl" ), metadataXmlStr, targetDir, "Output", ".html" );
				if ( xmlPropertiesString.startsWith("<?xml version=") ) 
				{
					xmlPropertiesString = xmlPropertiesString.substring(xmlPropertiesString.indexOf("?>") + 2);
				}
			}
			//Added by sadique shaikh 03-03-2021 [for reorder changes in homepage] End
		}
		catch (ITMException e) 
		{
			e.printStackTrace();
		}
		catch (JSONException e) 
		{
			e.printStackTrace();
		}
		catch (Exception e) 
		{
			e.printStackTrace();
		}
		BaseLogger.log( "3", userInfo, null, "xmlPropertiesString ["+ xmlPropertiesString +"]" );
		return xmlPropertiesString;
	}
	
	private String getMetadataXSLFileName( String fileName )throws ITMException
	{
		String retFileName = null;
		try
		{
			String defaultPath = null;
			if( CommonConstants.APPLICATION_CONTEXT != null )
			{
				defaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT + File.separator;
			}
			else
			{
				defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + CommonConstants.ITM_CONTEXT + File.separator;
			}
			//String fileName = "ME12XML2TEXT.xsl";
			if ( ! ( new File( defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME ) ).exists() )
			{
				( new File(defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME) ).mkdir();
			}

			File xslFile = new File(defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME , fileName);
			if( xslFile.exists() )
			{
				retFileName = xslFile.getAbsolutePath();
			}
			else
			{
				BaseLogger.log("3",null,null,"Default file not found @ "+xslFile.getAbsolutePath());
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return retFileName;
	}
	//Added by Sadique on 18/07/2020 [to column reorder related functionality] END

    // Added by Pankaj R on 28-09-20 to get the sql [START]
    public String getPopUpData( String query, String sqlInput, String[] parameters, String allDetailXml, UserInfoBean userInfo )throws RemoteException, ITMException
	{
		E12GenericUtility genUtility = new E12GenericUtility();
		try {
			int counter = 0;
			String inputName = null;
			String inputValue = null;
			String objContext = "";
			String nodeValue = null;
			Document allDetailXmlDom = null;
			if ( allDetailXml != null && allDetailXml.length() > 0 )
			{
				allDetailXmlDom = genUtility.parseString(allDetailXml);
			}
			BaseLogger.log( "3", userInfo, null, "Query : ["+ query +"]" );
			ArrayList inputList = genUtility.getTokenList( sqlInput, "," );
			if( parameters != null )
			{
				while(query.indexOf( '?' ) != -1)
				{
					StringBuffer queryBuffer = new StringBuffer( query );
					int index = queryBuffer.toString().indexOf( '?' );
					inputValue = parameters[ counter ];
					BaseLogger.log("3", userInfo, null," In if condition inputValue[ "+inputValue+"] & inputList ["+inputList+"]");
					if( inputList != null && ( counter  < inputList.size() ) && ( inputValue == null || ( inputValue.trim().length() == 0 || "null".equalsIgnoreCase( inputValue ) ) ) )
					{
						inputName = ( ( String )inputList.get( counter ) ).toUpperCase();
						if ( inputName.indexOf( "." ) != -1 )
						{
							objContext = checkNull( inputName.substring( inputName.indexOf(":") + 1, inputName.indexOf(".") ) );
						}
						BaseLogger.log("3", userInfo, null,"objContext 1 @["+objContext+"]");
						if( objContext.equals("0") )
						{
							objContext = "1";
						}
						BaseLogger.log("3", userInfo, null,"objContext 2 @["+objContext+"]");
						inputName = ( inputName.indexOf( "." ) != -1 ) ? inputName.substring( inputName.indexOf( "." ) + 1 ) : inputName;
						inputName = ( inputName.indexOf( ":" ) != -1 ) ? inputName.substring( inputName.indexOf( ":" ) + 1 ) : inputName;
						BaseLogger.log("3", userInfo, null,"inputName ["+inputName+"]");

						if ( allDetailXmlDom != null && objContext.length() > 0 )
						{
							NodeList detailNodeList = (NodeList) allDetailXmlDom.getElementsByTagName( "Detail"+objContext );
							if ( detailNodeList != null )
							{
								Node detailNode = detailNodeList.item(0);
								if ( detailNode != null )
								{
									detailNodeList = detailNode.getChildNodes();
									for (int cnt=0; cnt < detailNodeList.getLength(); cnt++)
									{
										detailNode = detailNodeList.item(cnt);
										if (detailNode.getFirstChild() != null && detailNode.getNodeName().equalsIgnoreCase(inputName))
										{
											nodeValue = detailNode.getFirstChild().getNodeValue();
											break;
										}
									}
								}
								inputValue = nodeValue;
							}
						}
						if ( checkNull( inputValue ).length() == 0 && userInfo != null )
						{
							inputValue = userInfo.getPropValue( inputName );
						}
					}
					inputValue = ( inputValue == null ) ? "" : inputValue;

					BaseLogger.log("3", userInfo, null, "input name["+index+"] :["+inputName+"], :["+inputValue+"]");
					
					queryBuffer.replace( index, index+1, inputValue );
					query = queryBuffer.toString();
					queryBuffer = null;
					
					counter++;
				}
			}
			else
			{
				while(query.indexOf( '?' ) != -1)
				{
					StringBuffer queryBuffer = new StringBuffer( query );
					int index = queryBuffer.toString().indexOf( '?' );
					if( inputList != null && ( counter  < inputList.size() ) && ( inputValue == null || ( inputValue != null && ( inputValue.trim().length() < 1 ) || "null".equalsIgnoreCase( inputValue ) ) ))
					{
						inputName = ( ( String )inputList.get( counter ) ).toUpperCase();
						if ( inputName.indexOf( "." ) != -1 )
						{
							objContext = checkNull( inputName.substring( inputName.indexOf(":") + 1, inputName.indexOf(".") ) );
						}
						BaseLogger.log("3", userInfo, null,"objContext 1 @["+objContext+"]");
						if( objContext.equals("0") )
						{
							objContext = "1";
						}
						BaseLogger.log("3", userInfo, null,"objContext 2 @["+objContext+"]");
						inputName = ( inputName.indexOf( "." ) != -1 ) ? inputName.substring( inputName.indexOf( "." ) + 1 ) : inputName;
						inputName = ( inputName.indexOf( ":" ) != -1 ) ? inputName.substring( inputName.indexOf( ":" ) + 1 ) : inputName;

						if ( allDetailXmlDom != null && objContext.length() > 0 )
						{
							NodeList detailNodeList = (NodeList) allDetailXmlDom.getElementsByTagName( "Detail"+objContext );
							if ( detailNodeList != null )
							{
								Node detailNode = detailNodeList.item(0);
								if ( detailNode != null )
								{
									detailNodeList = detailNode.getChildNodes();
									for (int cnt=0; cnt < detailNodeList.getLength(); cnt++)
									{
										detailNode = detailNodeList.item(cnt);
										if (detailNode.getFirstChild() != null && detailNode.getNodeName().equalsIgnoreCase(inputName))
										{
											nodeValue = detailNode.getFirstChild().getNodeValue();
											break;
										}
									}
								}
								inputValue = nodeValue;
							}
						}
						if ( checkNull( inputValue ).length() == 0 && userInfo != null )
						{
							inputValue = userInfo.getPropValue( inputName );
						}
					}
					inputValue = ( inputValue == null ) ? "" : inputValue;

					BaseLogger.log("3", userInfo, null,"input name["+index+"] :["+inputName+"] :["+inputValue+"]");

					queryBuffer.replace( index, index+1, inputValue );
					query = queryBuffer.toString();
					queryBuffer = null;
					
					counter++;
				}
			}
		}
		catch (Exception e) 
		{
			e.printStackTrace();
		}
		BaseLogger.log( "3", userInfo, null, "In DBAccessEJB final query--> ["+ query +"]" );
		
		return query;
    }
    // Added by Pankaj R on 28-09-20 to get the sql [END]
    
    //Added by Prasad on 05/01/2021 [to get the sync trans log details] START
    public HashMap<String, String> getSyncDataDetails( String offlineId, UserInfoBean userInfo ) throws ITMException
    {
		Connection con = null;
		PreparedStatement pStmt = null;
		
		HashMap<String, String> dataMap = new HashMap<String, String>();
		try
		{
			String transDB = null;
			ConnDriver connDriver = new ConnDriver();
			con = connDriver.getConnectDB(transDB); //$NON-NLS-1$

			String query = "SELECT LOG.RESPONSE, LOG.TRANS_XML, LOG.OBJ_NAME FROM SYNC_TRANS_LOG LOG WHERE LOG.OFFLINE_ID = ? AND LOG.STATUS = ?";

			pStmt = con.prepareStatement(query);
			pStmt.setString( 1, offlineId );
			pStmt.setString( 2, "S" );
			
			ResultSet rs = pStmt.executeQuery();
			if (rs.next())
			{
				String dataStr = ""; //$NON-NLS-1$
				
				InputStream is = rs.getBinaryStream(1);
				if ( is != null )
				{
					InputStreamReader isr = new InputStreamReader(is);
					StringBuffer xmlStringBuff = new StringBuffer();
					int ch = -1;
					while((ch = isr.read()) != -1 )
					{
						xmlStringBuff.append((char)ch);
					}
					isr.close();
					dataStr = xmlStringBuff.toString();
					//Added if condition by shrutika on 08-05-18 [Start] for issue in audit trail when no one feed edit and finish the transaction.
					dataStr = dataStr.replace("\n", "");
					if( dataStr.trim().equalsIgnoreCase( "<Root></Root>" ) )
					{
						dataStr = "";
					}
					else
					{
						dataStr = xmlStringBuff.toString();
					}
					//Added if condition by shrutika on 08-05-18 [End] for issue in audit trail when no one feed edit and finish the transaction.
				}
				if ( dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</DocumentRoot>") != -1 ) //$NON-NLS-1$
				{
					dataStr = dataStr.substring(0, dataStr.indexOf("</DocumentRoot>") + 15); //$NON-NLS-1$
				}
				else if ( dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</Root>") != -1 ) //$NON-NLS-1$
				{
					dataStr = dataStr.substring(0, dataStr.indexOf("</Root>") + 7); //$NON-NLS-1$
				}
				dataMap.put( "RESPONSE", dataStr );
				
				dataStr = "";
				is = rs.getBinaryStream(2);
				if (is != null)
				{
					InputStreamReader isr = new InputStreamReader(is);
					StringBuffer xmlStringBuff = new StringBuffer();
					int ch = -1;
					while((ch = isr.read()) != -1 )
					{
						xmlStringBuff.append((char)ch);
					}
					isr.close();
					//Added if condition by shrutika on 08-05-18 [Start] for issue in audit trail when no one feed edit and finish the transaction.
					dataStr = dataStr.replace("\n", "");
					if( dataStr.trim().equalsIgnoreCase( "<Root></Root>" ) )
					{
						dataStr = "";
					}
					else
					{
						dataStr = xmlStringBuff.toString();
					}
					//Added if condition by shrutika on 08-05-18 [End] for issue in audit trail when no one feed edit and finish the transaction.
				}
				if ( dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</DocumentRoot>") != -1 ) //$NON-NLS-1$
				{
					dataStr = dataStr.substring(0, dataStr.indexOf("</DocumentRoot>") + 15); //$NON-NLS-1$
				}
				else if ( dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</Root>") != -1 ) //$NON-NLS-1$
				{
					dataStr = dataStr.substring(0, dataStr.indexOf("</Root>") + 7); //$NON-NLS-1$
				}
				dataMap.put( "TRANS_XML", dataStr );
				
				dataStr = rs.getString( "OBJ_NAME" );
				dataMap.put( "OBJ_NAME", dataStr );
			}
			rs.close();
			rs = null;
			pStmt.close();
			pStmt = null;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			BaseLogger.log( "3", userInfo, null, "Exception :: DBAccessEJB : getSyncDataDetails : ["+ e.getMessage() +"]" ); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(con != null)
				{
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
					con.close();
					con = null;
				}
			}
			catch(Exception e)
			{
				BaseLogger.log( "3", userInfo, null, "Exception :: DBAccessEJB : getSyncDataDetails :==>finally ["+ e.getMessage() +"]" ); //$NON-NLS-1$
				e.printStackTrace();
			}
		}
		return dataMap;
	}
    //Added by Prasad on 05/01/2021 [to get the sync trans log details] END
    
    //Added by Pravin k on 11-FEB-21[To get current period code]   START
    public String getCurrentPeriodCode(UserInfoBean userInfo) throws RemoteException,Exception
	{
        BaseLogger.log("3",null,null,"DBAccessEJB :getCurrentPeriodCode ");
		String periodCode = null;
		Connection mConnection = null;
		Statement stmt = null;
        String transDB = null;
		try
		{
            transDB = userInfo.getTransDB();
            BaseLogger.log("3",null,null,"DBAccessEJB :getCurrentPeriodCode ::transDB"+transDB);

			ConnDriver mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB(transDB); //$NON-NLS-1$
			String selectQuery = "select code from period where sysdate between fr_date and to_date";
			stmt = mConnection.createStatement();
			ResultSet rs = stmt.executeQuery(selectQuery);
			if (rs.next())
			{
				periodCode = rs.getString("code").trim();
            }
            BaseLogger.log("0",null,null,"DBAccessEJB :getCurrentPeriodCode::["+periodCode+"]");
			rs.close();
			rs = null;
			stmt.close();
			stmt = null;
			mConnection.close();
			mConnection = null;
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :DBAccessEJB :getCurrentPeriodCode :==>"+e.getMessage());
			
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				BaseLogger.log("0",null,null,"Exception :DBAccessEJB :periodCode :\n"+e.getMessage());
			}
		}
		//BaseLogger.log("9",null,null,"[DBAccessEJB]Returning Profile Id :"+profileId);
		return periodCode;
	}
    //Added by Pravin k on 11-FEB-21[To get current period code] END
	
	//Added By Ravindra C on 11-03-21 [wf_role related implementation in mail] - Start
    public ArrayList getRoleInfoList( Connection con, String roleCode )throws RemoteException,ITMException
    {
    	BaseLogger.log( "3", null, null, "[DBAccessEJB] Getting role code info for roleCode :["+ roleCode +"]" ); //$NON-NLS-1$ //$NON-NLS-2$
    	Connection mConnection = con;
    	Statement mStmt = null;
    	ResultSet rs = null;
    	ArrayList roleInfoList = null;

    	boolean isLocalConnection = false; //Gulzar on 09/10/12
    	try
    	{
    		if(mConnection == null)
    		{
    			ConnDriver mConnDriver = new ConnDriver();
    			mConnection = mConnDriver.getConnectDB("Driver"); //$NON-NLS-1$
    			isLocalConnection = true; //Gulzar on 09/10/12
    		}
    		if(roleCode != null)
    		{
    			String selectQuery = "SELECT ROLE_TYPE, ROLE_ENTITY, ROLE_ENTITY_SQL, USER_ID, ROLE_SQL_INPUT FROM WF_ROLE WHERE ROLE_CODE = '"+roleCode+"'"; //$NON-NLS-1$ //$NON-NLS-2$
    			//BaseLogger.log("3", null, null,"Query for Role Info List :["+selectQuery+"]");
    			mStmt = mConnection.createStatement();
    			rs = mStmt.executeQuery(selectQuery);
    			roleInfoList = new ArrayList();

    			if (rs.next())
    			{
    				String roleType = rs.getString("ROLE_TYPE");  //$NON-NLS-1$
    				roleInfoList.add(roleType);
    				roleInfoList.add(rs.getString("ROLE_ENTITY")); //$NON-NLS-1$
    				roleInfoList.add(rs.getString("ROLE_ENTITY_SQL")); //$NON-NLS-1$
    				String userId = rs.getString("USER_ID"); //$NON-NLS-1$
    				if ("S".equals(roleType)) //$NON-NLS-1$
    				{
    					selectQuery = "SELECT ENTITY_CODE FROM USERS WHERE CODE='"+userId+"'"; //$NON-NLS-1$ //$NON-NLS-2$
    					Statement stmt = mConnection.createStatement();
    					ResultSet rsInr = stmt.executeQuery(selectQuery);
    					if (rsInr.next())
    					{
    						userId = rsInr.getString("ENTITY_CODE"); //$NON-NLS-1$
    					}
    					//Added by Gaurav Singh on 20-Nov-2015 [ To close the Statement and ResultSet | Start]
    					if(rsInr != null)
    					{
    						rsInr.close();
    						rsInr = null;
    					}
    					if(stmt != null)
    					{
    						stmt.close();
    						stmt = null;
    					}
    					//Added by Gaurav Singh on 20-Nov-2015 [ To close the Statement and ResultSet | End]
    				}
    				roleInfoList.add(userId);
    				roleInfoList.add(rs.getString("ROLE_SQL_INPUT"));
    			}
    			if(mStmt != null)
    			{
    				rs.close();
    				mStmt.close();
    				//mConnection.close();//Commented and shifted to finally block and needs to be closed if isLocalConnection = true - Gulzar on 09/10/12
    			}
    		}
    	}
    	catch (ITMException itme)
    	{
    		BaseLogger.log( "0", null, null,"ITMException :DBAccessEJB :getRoleInfo :==>\n"+itme.getMessage() ); //$NON-NLS-1$
    		throw itme;
    	}
    	catch (Exception e)
    	{
    		BaseLogger.log( "0", null, null,"Exception :DBAccessEJB :getRoleInfo :==>\n"+e.getMessage() ); //$NON-NLS-1$
    		throw new ITMException(e);
    	}
    	finally
    	{
    		try
    		{	//if isLocalConnection = true then connection needs to be closed - Gulzar on 09/10/12
    			if( isLocalConnection && mConnection != null)
    			{
    				mConnection.close();
    				mConnection = null;
    			}
    			//end changes gulzar on 09/10/12
    			if(mStmt != null)
    			{
    				mStmt.close();
    			}
    		}
    		catch(Exception e)
    		{
    			BaseLogger.log( "0", null, null, "Exception :DBAccessEJB :getRoleInfoList :\n"+e.getMessage() ); //$NON-NLS-1$
    			throw new ITMException(e);
    		}
    	}
    	BaseLogger.log( "3", null, null, "[DBAccessEJB] Returning role code info list : ["+ roleInfoList +"]" ); //$NON-NLS-1$ //$NON-NLS-2$
    	return roleInfoList;
    }

    public String getRoleEntityCode( String roleExpr, String roleExprType, ArrayList roleInfoList, Document dataDom, UserInfoBean userInfo ) throws Exception
    {
    	String entityCode = "";
    	PreparedStatement roleExprPStmt = null;
    	ResultSet roleExprRS = null;
    	Connection conn = null;
    	try
    	{
    		ConnDriver connDriver = new ConnDriver();
    		conn = connDriver.getConnectDB( userInfo.getTransDB() );
    		connDriver = null;

    		if ( ( (String)roleInfoList.get(0) ).equalsIgnoreCase( "D" ) )
    		{
    			BaseLogger.log( "3", null, null, "[DBAccessEJB] Evaluating RoleExpr as roleType is D" );
    			if ( roleExpr != null )
    			{
    				String roleCodeSql = (String) roleInfoList.get(2);
    				roleExprPStmt = conn.prepareStatement( roleCodeSql );
    				if( roleCodeSql.contains("?") )
    				{
    					int indexOfSep = -1;
    					int bindCtr = 1;
    					BaseLogger.log( "3", null, null, "[DBAccessEJB] roleExpr.indexOf(\":\") ["+ roleExpr.indexOf(":") +"]" );
    					while ( ( indexOfSep = roleExpr.indexOf(":") ) != -1 )
    					{
    						String currField = roleExpr.substring(0, indexOfSep);
    						String currType = roleExprType.substring(0, roleExprType.indexOf(":"));
    						BaseLogger.log( "3", null, null, "[DBAccessEJB] currField ["+ currField +"], currType ["+currType+"]" );
    						
    						Object currValue = getValueOfField( dataDom, currField, currType );
    						BaseLogger.log( "3", null, null, "[DBAccessEJB] Setting value as : ["+ currValue +"], field : ["+ currField +"]" );
    						
    						roleExprPStmt.setObject( bindCtr, currValue );
    						
    						roleExpr = roleExpr.substring( indexOfSep + 1 );
    						roleExprType = roleExprType.substring( roleExprType.indexOf(":") + 1 );
    						bindCtr++;
    					}
    				}
    				roleExprRS = roleExprPStmt.executeQuery();
    				while ( roleExprRS.next() )
    				{
    					entityCode = roleExprRS.getString(1);
    				}
    				BaseLogger.log( "3", null, null, "[DBAccessEJB] Setting Dynamic entityCode : ["+ entityCode +"]" );
    				if( roleExprRS != null )
    				{
    					roleExprRS.close();
    					roleExprRS = null;
    				}
    				if( roleExprPStmt != null )
    				{
    					roleExprPStmt.close();
    					roleExprPStmt = null;
    				}
    			}
    		}
    		else
    		{
    			entityCode = (String) roleInfoList.get(3);
    			BaseLogger.log( "3", null, null, "[DBAccessEJB] Setting Static entityCode ["+ entityCode +"]" );
    		}
    		BaseLogger.log( "3", null, null, "[DBAccessEJB] entityCode ["+ entityCode +"]" );
    	}
    	catch (ITMException e)
    	{
    		BaseLogger.log( "0", null, null, "ITMException :DBAccessEJB :getRoleInfo :==>\n"+e.getMessage() ); //$NON-NLS-1$
    		throw e;
    	}
    	catch (Exception e)
    	{
    		BaseLogger.log( "0", null, null, "Exception :DBAccessEJB :getRoleInfo :==>\n"+e.getMessage() ); //$NON-NLS-1$
    		throw new ITMException(e);
    	}
    	finally
    	{
    		try
    		{
    			if( roleExprRS != null )
				{
					roleExprRS.close();
					roleExprRS = null;
				}
    			if ( roleExprPStmt != null )
    			{
    				roleExprPStmt.close();
    				roleExprPStmt = null;
    			}
    			if ( conn != null )
    			{
    				conn.close();
    				conn = null;
    			}
    		}
    		catch (Exception e)
    		{
    			throw new ITMException(e);
    		}
    	}
    	return entityCode;
    }

    private Object getValueOfField( Document dom, String currFieldName, String currFieldType ) throws ITMException
    {
    	Object fieldValue = null;
    	Node currField = null;
    	try
    	{
    		String currFieldValue = null;
    		if( currFieldName.indexOf(".") != -1 )
    		{
    			//do something and find out the parent tag
    			String detailName = currFieldName.substring( 0, currFieldName.indexOf(".") );
    			String fieldName = currFieldName.substring( currFieldName.indexOf(".") + 1 );
    			BaseLogger.log( "3", null, null, "[DBAccessEJB] Getting field value of ["+ fieldName +"] of ["+ detailName +"] tag" );
    			NodeList detailNodeList = dom.getElementsByTagName( detailName ).item(0).getChildNodes();
    			for(int ctr = 0; ctr < detailNodeList.getLength(); ctr++)
    			{
    				Node currChild = detailNodeList.item(ctr);
    				if( currChild.getNodeName().equalsIgnoreCase(fieldName) && currChild.getFirstChild() != null )
    				{
    					currField = currChild;
    					break;
    				}
    			}
    		}
    		else
    		{
    			currField = dom.getElementsByTagName(currFieldName).item(0);
    		}
    		
    		if ( currField != null )
    		{
    			if ( currField.getFirstChild() != null )
    			{
    				currFieldValue = currField.getFirstChild().getNodeValue();
    			}
    			if ( currFieldValue != null )
    			{
    				if ( currFieldType.equalsIgnoreCase("I") )
    				{
    					fieldValue = Integer.valueOf(currFieldValue.toString());
    				}
    				else if ( currFieldType.equalsIgnoreCase("Number") || currFieldType.equalsIgnoreCase("N") || currFieldType.equalsIgnoreCase("D") )
    				{
    					fieldValue = Double.valueOf(currFieldValue.toString());
    				}
    				else
    				{
    					fieldValue = currFieldValue.trim();
    				}
    			}
    		}
    	}
    	catch (Exception e)
    	{
    		BaseLogger.log( "3", null, null, "Exception : DBAccessEJB :getValueOfField() : ["+ e.getMessage() +"]" );
    		throw new ITMException(e);
    	}
    	return fieldValue;
    }
  //Added By Ravindra C on 11-03-21 [wf_role related implementation in mail] - END
    
    //Added By Pankaj T. on 09-09-2021 - Remove user level logic. It should be work on user_rights basis. - start
    public boolean getUserAccess (String pageName, UserInfoBean userInfo)
	{
		BaseLogger.log("2", userInfo,  null,"In DBAccessEJB.getUserAccess() userInfo = ["+userInfo+"]");
		BaseLogger.log("2", userInfo,  null,"In DBAccessEJB.getUserAccess() pageName = ["+pageName+"]");
		boolean isAccessible = false;
		ConnDriver connDriver = null;  
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String transDB = null;
		String profileId = userInfo.getProfileId();
		String getUserAccess = "SELECT COUNT(1) FROM USER_RIGHTS A, ITM2MENU B WHERE A.PROFILE_ID IN "+E12GenericUtility.getFormattedProfileId(profileId)+" AND WIN_NAME IN (?, ?, ?, ? ) AND A.APPLICATION = B.APPLICATION "
				+ "AND LEVEL_1 = MENU_ROW AND LEVEL_2 = MENU_COL AND LEVEL_3 = MENU_SUBCOL AND A.LEVEL_4 = B.LEVEL_4 AND A.LEVEL_5 = B.LEVEL_5 "
				+ "AND ( A.RIGHTS LIKE '%U%' or A.RIGHTS LIKE '%*%') AND ( WIN_NAME != NULL or WIN_NAME != '-')";

		try
		{
			transDB=userInfo.getTransDB();
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB(transDB);
			pstmt = conn.prepareStatement(getUserAccess);
			pstmt.setString(1, CommonConstants.TOMCAT_HOME+"/ibase/jsp/" + pageName);
			pstmt.setString(2, "/ibase/jsp/" + pageName);
			pstmt.setString(3, CommonConstants.TOMCAT_HOME+"/ibase/webitm/jsp/" + pageName);
			pstmt.setString(4, "/ibase/webitm/jsp/" + pageName);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				if(rs.getInt(1) > 0 )
				{
					isAccessible = true;
				}
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("2", userInfo,  null,"In DBAccessEJB.getUserAccess() Exception = ["+E12GenericUtility.getStackTrace(e)+"]");
		}
		finally
		{
			try
			{
				if(rs !=null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		BaseLogger.log("2", userInfo,  null,"In DBAccessEJB.getUserAccess() isAccessible = ["+isAccessible+"]");
		return  isAccessible;
	}
    //Added By Pankaj T. on 09-09-2021 - Remove user level logic. It should be work on user_rights basis.
            
    //Added by Pramod S on 13-Jun-2022 [To get document type as key and show_del_attach as value and pass it in JSONObject] - START
    public JSONObject getDBColumnValueNew(String tableName, String columnName, String columnName2 ,String condition,String transDB)throws RemoteException, ITMException
	{
        JSONObject DocWiseDeleteObject = new JSONObject();
        String columnValue = "";
        String columnNameValue= "";
		Connection mConnection = null;
		Statement mStmt = null;
		ResultSet rs = null;
        String selectColumns="";
        String selectColumns2="";
//		String transDB = null;
		try
		{
            String columnNameAs = "";
            String columnNameAs2 = "";
			//Added By Nilesh Start ::30-06-2017 For db2
            selectColumns=columnName;
            selectColumns2=columnName2;
			//Added By Nilesh Start ::30-06-2017 For db2
			if( columnName.indexOf("~AS~") != -1 )
			{
				String[] columnNameArr = columnName.split("~AS~");
				if( columnNameArr.length > 1 )
				{
					columnName = columnNameArr[0];
					columnNameAs = columnNameArr[1];
					//Added By Nilesh Start ::30-06-2017 For db2
					selectColumns=columnName+" AS "+columnNameAs;
					//Added By Nilesh Start ::30-06-2017 For db2
				}
            }
            
            if( columnName2.indexOf("~AS~") != -1 )
			{
				String[] columnNameArr = columnName2.split("~AS~");
				if( columnNameArr.length > 1 )
				{
					columnName2 = columnNameArr[0];
					columnNameAs2 = columnNameArr[1];
					//Added By Nilesh Start ::30-06-2017 For db2
					selectColumns2=columnName2+" AS "+columnNameAs2;
					//Added By Nilesh Start ::30-06-2017 For db2
				}
            }
            
			ConnDriver mConnDriver =  new ConnDriver();
			if( transDB != null && (transDB.trim().length() > 0 ) )
			{
				mConnection = mConnDriver.getConnectDB(transDB);
			}

			String mQuery =  " SELECT " +  selectColumns +" , "+ selectColumns2 + " FROM " + tableName + " WHERE " + condition ;
			BaseLogger.log("3", null, null,"mQuery ["+mQuery+"]");
			mStmt = mConnection.createStatement();
			rs = mStmt.executeQuery(mQuery);
			//Added By Nilesh Start ::30-06-2017 For db2
            BaseLogger.log("3", null, null,"columnNameAs::"+columnNameAs);
            BaseLogger.log("3", null, null,"columnNameAs2::"+columnNameAs2);
			//Added By Nilesh Start ::30-06-2017 For db2

			if( columnNameAs.length() > 0 )
			{
				columnName = columnNameAs;
            }
            if( columnNameAs2.length() > 0 )
			{
				columnName2 = columnNameAs2;
			}
			while (rs.next())
			{
                columnValue = checkNull( rs.getString( columnName.trim() ) );
                columnNameValue = checkNull( rs.getString( columnName2.trim() ) );
                DocWiseDeleteObject.put(columnNameValue,columnValue);
			}
		}
		catch (Exception e)
		{
            columnValue = "";
            columnNameValue = "";
			BaseLogger.log("0", null, null,"Exception :DBAccessEJB :getDBColumnValue() :==>\n"+e.getMessage());
		}
		finally
		{
			try
			{
				//To close ResultSet, Statement and Connection in Finally
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(mStmt != null)
				{
					mStmt.close();
					mStmt = null;
				}
				if(mConnection != null)
				{
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :DBAccessEJB :getTransetupColumnValue() :==>finally"+e.getMessage()); //$NON-NLS-1$
			}
		}
        BaseLogger.log("2", null, null,tableName +"." + columnName + " pramod ["+columnValue+"]");
        BaseLogger.log("2", null, null,tableName +"." + columnName2 + " pramod ["+columnNameValue+"]");
        BaseLogger.log("2", null, null,tableName +"." + columnName2 + " pramod ["+DocWiseDeleteObject+"]");

        String value = DocWiseDeleteObject.toString();

        BaseLogger.log("2", null, null,tableName +"." + columnName2 + " value ["+value+"]");
		return DocWiseDeleteObject;
    }
    //Added by Pramod S on 13-Jun-2022 [To get document type as key and show_del_attach as value and pass it in JSONObject] - END
}

