import { BrowserModule } from '@angular/platform-browser';
import { NgModule, CUSTOM_ELEMENTS_SCHEMA } from '@angular/core';

import { HttpClientModule } from '@angular/common/http';
import { SearchMenuComponent } from './search-menu.component';
import { HomePagePopuppanelComponent } from './home-page-popuppanel/home-page-popuppanel.component';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { MatNativeDateModule } from '@angular/material/core';
import { PophelpModule } from '../ang-pophelp/pophelp.module';
import { MaterialModule } from 'base-blocks';
import { BrowserAnimationsModule } from '@angular/platform-browser/animations';
import { SearchComponent } from './searchComponent.service';
import { CustomFilterComponent } from './custom-filter/custom-filter.component';
import { AddFilterComponent } from './add-filter/add-filter.component';
import { BBAutosuggestModule } from 'base-blocks';
//Added by Vikas L. to call background job component
import { BackgroundJobStatusModule } from '../background-job/background-job-status.module';

@NgModule({
  declarations: [
    SearchMenuComponent,
    HomePagePopuppanelComponent,
    CustomFilterComponent,
    AddFilterComponent,
  ],
  imports: [ 
    BrowserModule,
    HttpClientModule,
    ReactiveFormsModule,
    BrowserAnimationsModule,
    FormsModule,
    MatNativeDateModule,
    PophelpModule,
    BBAutosuggestModule,
    MaterialModule,
    BackgroundJobStatusModule
  ],
  schemas: [
    CUSTOM_ELEMENTS_SCHEMA,
  ],
  exports: [
    SearchMenuComponent
  ],
  providers: [SearchComponent],
  entryComponents:[SearchMenuComponent],
})
export class SearchMenuModule { }
