export class BISResponse {

    /**
     * Indicates whether this response is produced using "Proteus Sense" utility
     */
    inferred: boolean | any = false;
    modelName: string = 'Proteus Sense';

    constructor( public sentBy : string, public response : any, public isWaiting : boolean = false, public template : string, public format : string, public msgDateTime ? : string){
        if(!this.msgDateTime)
        {
            this.msgDateTime = new Date().toString();
            console.log(sentBy, ' : msgDateTime : ', this.msgDateTime);
        }   
    }

    setWaiting( isWaiting : boolean ) {
        this.isWaiting = isWaiting;
    }

    //Added by Sainath T on 19/09/18.[to generate response on basis of result format type]-start
    /*setResponse( response : any ) {
        this.response = response;
    }*/
    //Chnaged by Pooja S on [Changes vision response in case of multiValue found]
    setTemplateResponse(
        format : string, response : any, template : string,
        inferred?: boolean, modelName?: string, addlInfo?: String
    ) {
        this.format = format;
        this.inferred = inferred;
        console.log('Model Name', modelName);
        modelName && (this.modelName = modelName);

        console.log('Inside setTemplateResponse : Inferred', inferred);

        if ( format == "3" )
        {
            //this.response = JSON.parse( response );
            this.response = response;
            //Changed by Sainath T on 10/10/18.[to change CSS class names]-Start
            //Added Condition to check if no template then set default template
            if(template.length == 0)
            {
            template=`<div class="bis-headerDiv dynamicTable scrollbar" id="resultDiv" style="width: 100%; height:100%; font-size: 14px;">
            <table width="100%" class="bis-tableClass" id="resultTable">
            <thead>
                <ng-container *ngIf="context">
                <tr class="bis-detail" align="center">
                    <th style="text-align: center;" *ngFor="let col of context['cols']; index as idx" class="bis-thClass {{context.colStyle[idx]}}">{{col}}</th>
                </tr>
                </ng-container>
            </thead>
            <tbody>
                <ng-container *ngIf="context.rows">
                <tr *ngFor="let row of context.rows" class="bis-detail">
                    <td *ngFor="let rData of row; index as idx" class="bis-tdClass {{context.colStyle[idx]}}">{{rData}}</td>
                </tr>
                </ng-container>
            </tbody>
            </table>
            </div>`;
        }
            /* For showing total
            <tbody>
            <ng-container *ngIf="context.total">
                <tr  class="bis-detail">
                    <th *ngFor="let tRow of context.total; index as idx" class="bis-tdClass {{context.colStyle[idx]}}">{{tRow}}</th>
                </tr>
            </ng-container>
            </tbody> */
        }
        /* Added by sadiq s on 19-07-19 [To implement card view] - Start */
        if ( format == "6" )
        {
            this.response = response;
            if(template.length == 0)
            {
                template=`   
                <div *ngFor="let row of context.rows;index as idx1" class="bis-card" >
                    <div style="padding: 0 0 .5rem 0;">
                        <span class ="bis-counter">{{idx1 + 1}}</span>
                    </div>
                    <div class="bis-detail" cellspacing="0" cellpadding="0">
                        <ng-container *ngFor="let col of context.cols; index as idx" class="bis-fieldDetail" >
                            <div class="bis-fieldLabel">{{col}}:</div>
                            <div class="bis-fieldValue">{{row[idx]}}</div>
                        </ng-container>
                    </div>
                </div>`;
            }
        }
        /* Added by sadiq s on 19-07-19 [To implement card view] - Start */
        else
        {
            this.response = response;
            //Added by Pooja S on [Changes vision response in case of multiValue found] Start
            if( addlInfo != null && addlInfo.length > 0 && (format == "1" || format == "2") )
            {
                this.response = addlInfo + "<br><br>" + response;
            }
            //Added by Pooja S on [Changes vision response in case of multiValue found] End
        }
        //Added by Pooja S on [Changes vision response in case of multiValue found] Start
        if( ( addlInfo != null && addlInfo.length > 0 ) && template.length > 0 )
        {
            template = addlInfo + '<br><br>' + template;
        }
        //Added by Pooja S on [Changes vision response in case of multiValue found] End
        this.template = template;
    }
    //Added by Sainath T on 19/09/18.[to generate response on basis of result format type]-end
}
  