import { Component, OnInit, ViewChild, Output, EventEmitter, HostListener, Input } from '@angular/core';
import { Overlay, OverlayConfig, OverlayRef } from '@angular/cdk/overlay';
import { Portal,  TemplatePortalDirective } from '@angular/cdk/portal';
//By Sainath T. on 03/12/2018
import { GROUP_BY } from 'src/plugin/utils/dashboard-plugin-util';

@Component({
  selector: 'bis-selection-list',
  templateUrl: './bis-selection-list.component.html',
  styleUrls: ['./bis-selection-list.component.css']
})
export class BISSelectionListComponent implements OnInit {

  title : string = 'Intents'; //Changed by Sainath for intents pophelp title
  pophelpConfig: any;
  pophelpData: any;
  overlayRef: OverlayRef | any;
  selectedValue: any;
//Added by Pratheek on 18-06-19[to pass the id value to so differentiate the Welcome screen and Quick Action Panel]-Start
  @Input("parentId") assistantId : string | any;
  //Added by Pratheek on 18-06-19[to pass the id value to so differentiate the Welcome screen and Quick Action Panel]-End
  //Sainath T. [To pass form group data to ang-pophelp]
  public formGroup = {};

  @Output('onSelectionChange') selectionChange = new EventEmitter<any>();

  @ViewChild(TemplatePortalDirective) templatePortal: Portal<any> | any;

  constructor(public overlay: Overlay) { }

  ngOnInit() 
  { 
  }

  loadArgPophelp(pophelpConfig: any,formGroup: any) 
  {
    //console.log('Display Suggestion with config : ', pophelpConfig);
    //TODO: Call Datamodel
    this.pophelpConfig = pophelpConfig;
    //Sainath T. on 23/11/2018 - [To pass for pophelp]
    this.formGroup = formGroup;
    this.title = pophelpConfig.title;
    this.openPophelp();
  }
 

  loadIntentPophelp(data: any) 
  {
    //Sai281118 - Changes to display intents group-wise on sort APPL_DESCR- START
    var feedData = GROUP_BY(data,"APPL_DESCR");
    console.log('Display Suggestion with feedData : ',feedData);
    this.pophelpData = feedData;
    //Sai281118 - Changes to display intents group-wise on sort APPL_DESC - END
    //Added by Sainath T. on 23-SEP-2019
    setTimeout( () =>{
      this.openPophelp();
    },1);
  }
  
  private openPophelp() 
  {
	//Added by Pratheek on 18-06-19[to pass the id value to so differentiate the Welcome screen and Quick Action Panel]-Start
    console.log('Inside bis-selection-list AssistantID 59!!!! ['+this.assistantId+']');
    // var bisAssistantContainer = document.getElementById('bis-assistant');
    var bisAssistantContainer = document.getElementById(this.assistantId);
	//Added by Pratheek on 18-06-19[to pass the id value to so differentiate the Welcome screen and Quick Action Panel]-End
    // console.log('openPophelp >>', bisAssistantContainer, 
    // 'Offset >',
    // bisAssistantContainer.offsetWidth,  
    // bisAssistantContainer.offsetHeight,
    // bisAssistantContainer.offsetTop,
    // bisAssistantContainer.offsetLeft,
    // 'Client >',
    // bisAssistantContainer.clientLeft,
    // bisAssistantContainer.clientTop );
    var containerWidth = bisAssistantContainer ? bisAssistantContainer.offsetWidth + "px" : "320px";
    var containerHeight = bisAssistantContainer ? bisAssistantContainer.offsetHeight + "px" : "500px";

    var containerTop = bisAssistantContainer ? bisAssistantContainer.getBoundingClientRect().top + "px" : "0px";
    var containerLeft = bisAssistantContainer ? bisAssistantContainer.getBoundingClientRect().left + "px" : "0px";

    var config = new OverlayConfig();
    config.hasBackdrop = true;
    config.panelClass = 'bis-assistant-overlay';
    config.positionStrategy = this.overlay.position()
        .global()
        .width(containerWidth)
        .height(containerHeight);

    this.overlayRef = this.overlay.create(config);
    this.overlayRef.attach(this.templatePortal);
	//Added by Pratheek on 18-06-19[to pass the id value to so differentiate the Welcome screen and Quick Action Panel]-Start
    this.overlayRef.hostElement.id = this.assistantId;
    console.log('this.overlayRef.hostElement id val 88!!!!!!['+this.overlayRef.hostElement.id+']');
    if( this.overlayRef.hostElement &&  this.overlayRef.hostElement.id == "bi_assistant")
    {
      this.overlayRef.hostElement.style.top = containerTop;
      this.overlayRef.hostElement.style.width = containerWidth;
      this.overlayRef.hostElement.style.height = containerHeight;
    }
    else
    {
      this.overlayRef.hostElement.style.top = containerTop;
      this.overlayRef.hostElement.style.width = containerWidth;
      this.overlayRef.hostElement.style.height = containerHeight;
      this.overlayRef.hostElement.style.left = containerLeft;
	  //Added by Pratheek on 18-06-19[to pass the id value to so differentiate the Welcome screen and Quick Action Panel]-End
    }
  }

  @HostListener('window:resize')
  onKeyboardInvoke(){
    console.log("onKeyboardInvoke window.innerWidth >>",window.innerWidth);
    //Added by Pratheek on 18-06-19[to pass the id value to so differentiate the Welcome screen and Quick Action Panel]-Start
    // var bisAssistantContainer = document.getElementById('bis-assistant');
    var bisAssistantContainer = document.getElementById(this.assistantId);
	//Added by Pratheek on 18-06-19[to pass the id value to so differentiate the Welcome screen and Quick Action Panel]-End
    var containerWidth = bisAssistantContainer ? bisAssistantContainer.offsetWidth + "px" : "320px";
    var containerHeight = bisAssistantContainer ? bisAssistantContainer.offsetHeight + "px" : "500px";

    var containerTop = bisAssistantContainer ? bisAssistantContainer.getBoundingClientRect().top + "px" : "0px";
    var containerLeft = bisAssistantContainer ? bisAssistantContainer.getBoundingClientRect().left + "px" : "0px";

	//Added by Pratheek on 18-06-19[to pass the id value to so differentiate the Welcome screen and Quick Action Panel]-Start
    this.overlayRef.hostElement.id = this.assistantId;
    console.log('this.overlayRef.hostElement id val 122!!!!!!['+this.overlayRef.hostElement.id+']');
    if( this.overlayRef.hostElement &&  this.overlayRef.hostElement.id == "bi_assistant")
    {
      this.overlayRef.hostElement.style.top = containerTop;
      this.overlayRef.hostElement.style.width = containerWidth;
      this.overlayRef.hostElement.style.height = containerHeight;
    }
    else
    {
      this.overlayRef.hostElement.style.top = containerTop;
      this.overlayRef.hostElement.style.width = containerWidth;
      this.overlayRef.hostElement.style.height = containerHeight;
      this.overlayRef.hostElement.style.left = containerLeft;
      //Added by Pratheek on 18-06-19[to pass the id value to so differentiate the Welcome screen and Quick Action Panel]-End
    }
  }

  onCancel()
  {
    this.overlayRef.dispose();
  }

  onSelectionChange(value: any)
  {
    //console.log('onSelectionChange >', value);
    this.selectedValue = value;
  }
  
  onDone()
  {
    this.overlayRef.dispose();
    this.selectionChange.emit(this.selectedValue);
  }
}
