package ibase.e12ria.e12table.client;


/**
 * <p>Title: HomePgMetadataInfoBean</p>
 * <p>Description: It is used to set meta data informations for each column in the metadataInfoHMap </p>
 * <p>Date: 02-02-11</p>
 * @author HRUSIKESH
 *
 */
public class ColumnInfoBean  
{
	private String colPhysicalName = null;
	private String colDisplayText = null;
	private String colLogicalName = null;
	private int colWidth = 0;
	
	/**
	 * 
	 * @param displayText		Used as display name of the column.
	 * @param physicalName 		Used as physical name of the column.
	 * @param width		
	 */
	public ColumnInfoBean( String displayText, String physicalName, String logicalName, String width )
	{
		this.colDisplayText = displayText;
		this.colPhysicalName = physicalName;
		this.colWidth = (int)Double.parseDouble( width );
		
		// Added by Swapnil ph.on 26/11/11 [DC1HSUN002 | to hold logical name ]
		this.colLogicalName = logicalName ;
	}
	
	/**
	 * Gets the display name of Column
	 * @return colDisplayText
	 */
	public String getDisplayNameOfCol()
	{
		return this.colDisplayText;
	}
	
	/**
	 * Gets the physical name of column.
	 * @return colPhysicalName
	 */
	public String getPhyNameOfCol()
	{
		return this.colPhysicalName;
	}
	
	/**
	 * Gets the width of column.
	 * @return colWidth
	 */
	public int getWidth()
	{
		return this.colWidth;
	}
	
	public void setWidth(int colWidth)
	{
		this.colWidth = colWidth;
	}
	
	// Added by Swapnil ph.on 26/11/11 [DC1HSUN002 | to SET logical name ]
	/**
	 * Gets the logical name of column
	 * @return colLogicalName
	 */
	public  String getLogicalNameOfCol()
	{
		return this.colLogicalName;
	}
	
	
	public String toString()
	{
		return "displayNameOfCol : " + colDisplayText + "\nphyNameOfCol : " + 
				colPhysicalName + "\n logicalNameOfColumn : "+ colLogicalName +"\n width : " + colWidth ;
	}
	
}
