package ibase.webitm.util.gst;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;

import ibase.webitm.bean.gst.ATA;
import ibase.webitm.bean.gst.InvLineItem;

public class ATASerializer extends BaseSerializer<ATA>
{
	@Override
	public void serialize(ATA ata, JsonGenerator json, SerializerProvider serializeProvider) throws IOException, JsonProcessingException
	{
		json.writeStartObject();
		
		json.writeStringField("sply_ty", ata.supplyType);
		
		if(ata.orgCpty != null && ata.orgDocNum != null && ata.orgDocDt != null)
		{
			json.writeStringField("ocpty", ata.orgCpty);
			json.writeStringField("odoc_num", ata.orgDocNum);
			json.writeStringField("odoc_dt", gstFmt.format(ata.orgDocDt));
		}
		writeLineItems(ata, json);
		
		json.writeEndObject();
	}
	
	 private void writeLineItems(ATA ata, JsonGenerator json) throws IOException 
	    {
	        json.writeFieldName("itms");
	        
	        json.writeStartArray();
	        
	        for(InvLineItem li : ata.itms)
	        {
	        	writeLineItem(json, li);
	        }

	        json.writeEndArray();
	    }

	    private void writeLineItem(JsonGenerator json, InvLineItem li) 
	    {
	        try 
	        {
	            json.writeStartObject();
	            
	            json.writeNumberField("ad_amt", li.taxval);

	            json.writeNumberField("iamt", li.iamt);
	            
	        	json.writeNumberField("camt", li.camt);
	        	
	        	json.writeNumberField("samt", li.samt);
	            
	            json.writeNumberField("csamt", li.csamt);
	            
	            json.writeEndObject();
	        }
	        catch (Exception e) 
	        {
	        	System.out.println("ATSearializer.writeLineItem()["+e.getMessage()+"]");
	            e.printStackTrace();
	        }
	    }
}
