<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:NonHtml="http://www.progress.com/StylusStudio/NonHtml" version="1.0" exclude-result-prefixes="NonHtml">
   <xsl:output method="html" omit-xml-declaration="no" standalone="no" indent="no" />
   <xsl:template match="/">
      <html>
         <head>
            <link href="../../css/xtree.css" type="text/css" rel="stylesheet" />
            <link href="default.css" type="text/css" rel="stylesheet" />
            <LINK type="text/css" rel="stylesheet" href="/ibase/css/pordercss.css" />
            <LINK type="text/css" rel="stylesheet" href="/ibase/css/workflowsign.css" />
            <style type="text/css">
					html,body { /*height:100%;*/
						background-color: #f7f8fa;
						font-family: 'MuseoLight', sans-serif;
						-webkit-font-smoothing: antialiased;
						font-size: 14px;
						font-weight: normal;
					}
					
					.gray {
						color: #555;
						text-align: right;
						font-size: 14px;
					}
					
					.brdrt {
						border-right: 1px solid #ccc;
					}
					
					.editDisplayColumnClass {
						readOnly: true;
						color: #555;
						TEXT-ALIGN: left;
						padding: 5px;
						font-size: 16px;
						font-weight: normal;
					}
					
					.editDisplayheaderClass {
						readOnly: true;
						color: #000;
						TEXT-ALIGN: left;
						padding: 5px;
						font-weight: normal;
						font-size: 14px;
					}
					
					.editDisplayrightClass {
						readOnly: true;
						border: inset 1;
						COLOR: black;
						BACKGROUND: #FFFFD9;
						TEXT-ALIGN: right;
						font-weight: normal;
					}
					
					.editDisplayecnterClass {
						readOnly: true;
						color: #5fdeb2;
						TEXT-ALIGN: left;
						font-size: 18px;
						padding: 5px 0;
						font-weight: normal;
					}
					
					.editDisplayecnterClass2 {
						readOnly: true;
						border: inset 1;
						COLOR: black;
						TEXT-ALIGN: center;
						font-weight: normal;
					}
					
					.editDisplayClass {
						background-color: transparent !important;
						readOnly: true;
						color: #555;
						TEXT-ALIGN: left;
						padding: 5px;
						font-weight: normal;
						font-size: 14px;
					}
					
					input {
						color: rgb(80, 80, 80) !important;
						/* font-size: 14px !important; */ /* TODO: Changes in I18NLabel */
						font-size: 14px !important;
						border: 1px solid #ccc;
						background: #fff;
					}
					
					@font-face { /* declare fonts */
						font-family: "MuseoLight";
						src: url("../fonts/Museo300-Regular.eot");
						src: local("Museo 300"), local("Museo-300"),
							url("../fonts/Museo300-Regular.woff") format("woff"),
							url("../fonts/Museo300-Regular.otf") format("opentype"),
							url("../fonts/Museo300-Regular.svg#Museo-300") format("svg");
					}
					
					.editDisplayecnterClass1 {
						readOnly: true;
						color: #5fdeb2;
						TEXT-ALIGN: left;
						font-size: 16px;
						padding: 10px 0 0 0;
					}
					
					.editDisplayecnterClass3 {
						readOnly: true;
						color: #5fdeb2;
						TEXT-ALIGN: left;
						font-size: 16px;
						padding: 10px 0 0 0;
					}
					
					/*Changed by Shravan*/
					.tableClass2 {
						border-top: 2px solid #5fdeb2;
						border-right: 1px solid #ccc;
						border-left: 1px solid #ccc;
						border-bottom: 1px solid #ccc;
						background: #FFF;
						margin-bottom:20px;
					}
					
					.tableClass2 td {/*
						font-size: 14px;*/
						padding:5px;
					}
					
					.rtalign {
						color: #5893bf;
						text-align: right;
						padding: 5px;
						font-size: 14px;
						font-weight: normal;
					}
                     
					.po {
						readOnly: true;
						color: #555;
						TEXT-ALIGN: left;
						padding: 10px;
						font-weight: normal;
						font-size: 18px;
					}
					
					.black {
						color: #000;
						font-weight: normal;
						font-size: 17px;
					}
						
					.editDisplayClass211 {
						readOnly: true;
						color: #555;
						TEXT-ALIGN: left;
						padding: 5px;
						font-weight: normal;
						font-size: 14px;
					}
                </style>
         </head>
         <body>
            <input type="hidden" value="supp_info_upd" name="OBJ_NAME" />
            <input type="hidden" value="2" name="PAGE_CONTEXT" />
            <input type="hidden" value="1" name="OBJ_CONTEXT" />
            <form name="form">
               <xsl:for-each select="//Detail1">
                  <table cellSpacing="1" cellPadding="1" width="100%" border="0">
                     <tbody>
                        <tr>
                           <td colSpan="4" class="editDisplayColumnClass">Supplier Information</td>
                        </tr>
                        <tr />
                     </tbody>
                  </table>
               </xsl:for-each>
               <table cellSpacing="0" cellPadding="0" width="100%" border="0" class="tableClass2">
					<tbody>
						<xsl:for-each select="//Detail1">
						
						<tr>
	                      		<td class="po black" style="font-size: 14px;" width="20%">
	                           		Transaction Id: <xsl:value-of select="tran_id" />
	                       		</td>
	                           <td class="rtalign" width="20%"></td>
	                           <td class="po black" style="text-align: right;font-size: 14px;" width="30%">
	                              <xsl:value-of select="tran_date" />
	                           </td>
	                        </tr>
							<tr>
                               	<td class="po black " colSpan="4"  style="text-align:center;font-size:20px;padding-bottom: 0px;">
                               		<xsl:value-of select="supp_code" /> 
                                </td>
                            </tr>
                            <tr>
								<td class="gray" colSpan="4"  style="text-align:center;padding-top: 0px;">
									<xsl:value-of select="supp_name" />
								</td>
                            </tr>
						</xsl:for-each>
					</tbody>
				</table>
              	<table cellspacing="0" cellpadding="0" width="100%" border="0" class="tableClass2" style="border-top:1px solid #ccc;">
                  <tbody>
                     <xsl:for-each select="//Detail1">
                     
                     
                        <tr>
                           <td class="editDisplayClass211" width="20%">Old PAN Number:</td>
                           <td class="brdrt gray" style="text-align: right;" width="30%">&#xA0;
                              <xsl:value-of select="pan_no_o" />
                           </td>
                           <td class="editDisplayClass211" width="20%">New PAN Number:</td>
                           <td class="gray" style="text-align: right;" width="30%">
								<xsl:choose>
									<xsl:when test="pan_no = pan_no_o">
										&#xA0;<xsl:value-of select="pan_no" />
									</xsl:when>
									<xsl:otherwise>
										&#xA0;<b><xsl:value-of select="pan_no" /></b>
									</xsl:otherwise>
								</xsl:choose>
							</td>
                        </tr>
                        <tr>
                           <td class="editDisplayClass211" width="20%">Old Cheque Name:</td>
                           <td class="brdrt gray" style="text-align: right;" width="30%">&#xA0;
                              <xsl:value-of select="chq_name_o" />
                           </td>
                           <td class="editDisplayClass211" width="20%">New Cheque Name:</td>
                           <td class="gray" style="text-align: right;" width="30%">
								<xsl:choose>
									<xsl:when test="chq_name = chq_name_o">
										&#xA0;<xsl:value-of select="chq_name" />
									</xsl:when>
									<xsl:otherwise>
										&#xA0;<b><xsl:value-of select="chq_name" /></b>
									</xsl:otherwise>
								</xsl:choose>
							</td>
                        </tr>
                     	<tr>
                           <td class="editDisplayClass211">Old Alternate Address1:</td>
                           <td class="brdrt gray" style="text-align: right;">&#xA0;
                              <xsl:value-of select="alt_addr1_o" />
                           </td>
                           <td class="editDisplayClass211">New Alternate Address1:</td>
                           <td class="gray" style="text-align: right;">
								<xsl:choose>
									<xsl:when test="alt_addr1 = alt_addr1_o">
										&#xA0;<xsl:value-of select="alt_addr1" />
									</xsl:when>
									<xsl:otherwise>
										&#xA0;<b><xsl:value-of select="alt_addr1" /></b>
									</xsl:otherwise>
								</xsl:choose>
							</td>
                        </tr>
                     	<tr>
                           <td class="editDisplayClass211">Old Alternate Address2:</td>
                           <td class="brdrt gray" style="text-align: right;">&#xA0;
                              <xsl:value-of select="alt_addr2_o" />
                           </td>
                           <td class="editDisplayClass211">New Alternate Address2:</td>
                           <td class="gray" style="text-align: right;">
								<xsl:choose>
									<xsl:when test="alt_addr2 = alt_addr2_o">
										&#xA0;<xsl:value-of select="alt_addr2" />
									</xsl:when>
									<xsl:otherwise>
										&#xA0;<b><xsl:value-of select="alt_addr2" /></b>
									</xsl:otherwise>
								</xsl:choose>
							</td>
                        </tr>
                     	<tr>
                           <td class="editDisplayClass211">Old Alternate Address3:</td>
                           <td class="brdrt gray" style="text-align: right;">&#xA0;
                              <xsl:value-of select="alt_addr3_o" />
                           </td>
                           <td class="editDisplayClass211">New Alternate Address3:</td>
                           <td class="gray" style="text-align: right;">
								<xsl:choose>
									<xsl:when test="alt_addr3 = alt_addr3_o">
										&#xA0;<xsl:value-of select="alt_addr3" />
									</xsl:when>
									<xsl:otherwise>
										&#xA0;<b><xsl:value-of select="alt_addr3" /></b>
									</xsl:otherwise>
								</xsl:choose>
							</td>
                        </tr>
                     	<tr>
                           <td class="editDisplayClass211">Old Alternate Pin:</td>
                           <td class="brdrt gray" style="text-align: right;">&#xA0;
                              <xsl:value-of select="alt_pin_o" />
                           </td>
                           <td class="editDisplayClass211">New Alternate Pin:</td>
                           <td class="gray" style="text-align: right;">
								<xsl:choose>
									<xsl:when test="alt_pin = alt_pin_o">
										&#xA0;<xsl:value-of select="alt_pin" />
									</xsl:when>
									<xsl:otherwise>
										&#xA0;<b><xsl:value-of select="alt_pin" /></b>
									</xsl:otherwise>
								</xsl:choose>
							</td>
                        </tr>
                        <tr>
                           <td class="editDisplayClass211">Old Alternate City:</td>
                           <td class="brdrt gray" style="text-align: right;">&#xA0;
                              <xsl:value-of select="alt_city_o" />
                           </td>
                           <td class="editDisplayClass211">New Alternate City:</td>
                           <td class="gray" style="text-align: right;">
								<xsl:choose>
									<xsl:when test="alt_city = alt_city_o">
										&#xA0;<xsl:value-of select="alt_city" />
									</xsl:when>
									<xsl:otherwise>
										&#xA0;<b><xsl:value-of select="alt_city" /></b>
									</xsl:otherwise>
								</xsl:choose>
							</td>
                        </tr>
                        <tr>
                           <td class="editDisplayClass211">Old Alternate State Code:</td>
                           <td class="brdrt gray" style="text-align: right;">&#xA0;
                              <xsl:value-of select="state_code__alt_o" />
                           </td>
                           <td class="editDisplayClass211">New Alternate State Code:</td>
                           <td class="gray" style="text-align: right;">
								<xsl:choose>
									<xsl:when test="state_code__alt = state_code__alt_o">
										&#xA0;<xsl:value-of select="state_code__alt" />
									</xsl:when>
									<xsl:otherwise>
										&#xA0;<b><xsl:value-of select="state_code__alt" /></b>
									</xsl:otherwise>
								</xsl:choose>
							</td>
                        </tr>
                       <!--  <tr>
                           <td class="editDisplayClass211">Old Alternate Country Code:</td>
                           <td class="brdrt gray" style="text-align: right;">&#xA0;
                              <xsl:value-of select="count_code" />
                           </td>
                           <td class="editDisplayClass211">New:</td>
                           <td class="gray" style="text-align: right;">
								<xsl:choose>
									<xsl:when test="count_code_1 = count_code">
										&#xA0;<xsl:value-of select="count_code_1" />
									</xsl:when>
									<xsl:otherwise>
										&#xA0;<b><xsl:value-of select="count_code_1" /></b>
									</xsl:otherwise>
								</xsl:choose>
							</td>
                        </tr> -->
                        <tr>
                           <td class="editDisplayClass211">Old Alternate Telphone Number1:</td>
                           <td class="brdrt gray" style="text-align: right;">&#xA0;
                              <xsl:value-of select="alt_tele1_o" />
                           </td>
                           <td class="editDisplayClass211">New Alternate Telphone Number1:</td>
                           <td class="gray" style="text-align: right;">
								<xsl:choose>
									<xsl:when test="alt_tele1 = alt_tele1_o">
										&#xA0;<xsl:value-of select="alt_tele1" />
									</xsl:when>
									<xsl:otherwise>
										&#xA0;<b><xsl:value-of select="alt_tele1" /></b>
									</xsl:otherwise>
								</xsl:choose>
							</td>
                        </tr>
                        <tr>
                           <td class="editDisplayClass211">Old Telphone Number1:</td>
                           <td class="brdrt gray" style="text-align: right;">&#xA0;
                              <xsl:value-of select="tele1_o" />
                           </td>
                           <td class="editDisplayClass211">New Telphone Number1:</td>
                           <td class="gray" style="text-align: right;">
								<xsl:choose>
									<xsl:when test="tele1 = tele1_o">
										&#xA0;<xsl:value-of select="tele1" />
									</xsl:when>
									<xsl:otherwise>
										&#xA0;<b><xsl:value-of select="tele1" /></b>
									</xsl:otherwise>
								</xsl:choose>
							</td>
                        </tr>
                        <tr>
                           <td class="editDisplayClass211">Old Telphone Number2:</td>
                           <td class="brdrt gray" style="text-align: right;">&#xA0;
                              <xsl:value-of select="tele2_o" />
                           </td>
                           <td class="editDisplayClass211">New Telphone Number2:</td>
                           <td class="gray" style="text-align: right;">
								<xsl:choose>
									<xsl:when test="tele2 = tele2_o">
										&#xA0;<xsl:value-of select="tele2" />
									</xsl:when>
									<xsl:otherwise>
										&#xA0;<b><xsl:value-of select="tele2" /></b>
									</xsl:otherwise>
								</xsl:choose>
							</td>
                        </tr>
                        <tr>
                           <td class="editDisplayClass211">Old Fax:</td>
                           <td class="brdrt gray" style="text-align: right;">&#xA0;
                              <xsl:value-of select="fax_o" />
                           </td>
                           <td class="editDisplayClass211">New Fax:</td>
                           <td class="gray" style="text-align: right;">
								<xsl:choose>
									<xsl:when test="fax = fax_o">
										&#xA0;<xsl:value-of select="fax" />
									</xsl:when>
									<xsl:otherwise>
										&#xA0;<b><xsl:value-of select="fax" /></b>
									</xsl:otherwise>
								</xsl:choose>
							</td>
                        </tr>
                     	<tr>
                           <td class="editDisplayClass211">Old Tax Registration:</td>
                           <td class="brdrt gray" style="text-align: right;">&#xA0;
                              <xsl:value-of select="tax_reg_o" />
                           </td>
                           <td class="editDisplayClass211">New Tax Registration:</td>
                           <td class="gray" style="text-align: right;">
								<xsl:choose>
									<xsl:when test="tax_reg = tax_reg_o">
										&#xA0;<xsl:value-of select="tax_reg" />
									</xsl:when>
									<xsl:otherwise>
										&#xA0;<b><xsl:value-of select="tax_reg" /></b>
									</xsl:otherwise>
								</xsl:choose>
							</td>
                        </tr>
                     	<tr>
                           <td class="editDisplayClass211">Old Excise Reference:</td>
                           <td class="brdrt gray" style="text-align: right;">&#xA0;
                              <xsl:value-of select="excise_ref_o" />
                           </td>
                           <td class="editDisplayClass211">New Excise Reference:</td>
                           <td class="gray" style="text-align: right;">
								<xsl:choose>
									<xsl:when test="excise_ref = excise_ref_o">
										&#xA0;<xsl:value-of select="excise_ref" />
									</xsl:when>
									<xsl:otherwise>
										&#xA0;<b><xsl:value-of select="excise_ref" /></b>
									</xsl:otherwise>
								</xsl:choose>
							</td>
                        </tr>
                        <tr>
                           <td class="editDisplayClass211">Old Service Tax Regs:</td>
                           <td class="brdrt gray" style="text-align: right;">&#xA0;
                              <xsl:value-of select="ser_tax_reg_o" />
                           </td>
                           <td class="editDisplayClass211">New Service Tax Regs:</td>
                           <td class="gray" style="text-align: right;">
								<xsl:choose>
									<xsl:when test="ser_tax_reg = ser_tax_reg_o">
										&#xA0;<xsl:value-of select="ser_tax_reg" />
									</xsl:when>
									<xsl:otherwise>
										&#xA0;<b><xsl:value-of select="ser_tax_reg" /></b>
									</xsl:otherwise>
								</xsl:choose>
							</td>
                        </tr>
                        <tr>
                           <td class="editDisplayClass211">Old Contact Person:</td>
                           <td class="brdrt gray" style="text-align: right;">&#xA0;
                              <xsl:value-of select="contact_purc_o" />
                           </td>
                           <td class="editDisplayClass211">New Contact Person:</td>
                           <td class="gray" style="text-align: right;">
								<xsl:choose>
									<xsl:when test="contact_purc = contact_purc_o">
										&#xA0;<xsl:value-of select="contact_purc" />
									</xsl:when>
									<xsl:otherwise>
										&#xA0;<b><xsl:value-of select="contact_purc" /></b>
									</xsl:otherwise>
								</xsl:choose>
							</td>
                        </tr>
                        <tr>
                           <td class="editDisplayClass211">Old Email Address:</td>
                           <td class="brdrt gray" style="text-align: right;">&#xA0;
                              <xsl:value-of select="email_addr_o" />
                           </td>
                           <td class="editDisplayClass211">New Email Address:</td>
                           <td class="gray" style="text-align: right;">
								<xsl:choose>
									<xsl:when test="email_addr = email_addr_o">
										&#xA0;<xsl:value-of select="email_addr" />
									</xsl:when>
									<xsl:otherwise>
										&#xA0;<b><xsl:value-of select="email_addr" /></b>
									</xsl:otherwise>
								</xsl:choose>
							</td>
                        </tr>
                        <tr>
                           <td class="editDisplayClass211">Old Purchasing Email:</td>
                           <td class="brdrt gray" style="text-align: right;">&#xA0;
                              <xsl:value-of select="email_purc_o" />
                           </td>
                           <td class="editDisplayClass211">New Purchasing Email:</td>
                           <td class="gray" style="text-align: right;">
								<xsl:choose>
									<xsl:when test="email_purc = email_purc_o">
										&#xA0;<xsl:value-of select="email_purc" />
									</xsl:when>
									<xsl:otherwise>
										&#xA0;<b><xsl:value-of select="email_purc" /></b>
									</xsl:otherwise>
								</xsl:choose>
							</td>
                        </tr>
                        <tr>
                           <td class="editDisplayClass211">Old Tax Registration St:</td>
                           <td class="brdrt gray" style="text-align: right;">&#xA0;
                              <xsl:value-of select="tax_reg_st_o" />
                           </td>
                           <td class="editDisplayClass211">New  Tax Registration St:</td>
                           <td class="gray" style="text-align: right;">
								<xsl:choose>
									<xsl:when test="tax_reg_st = tax_reg_st_o">
										&#xA0;<xsl:value-of select="tax_reg_st" />
									</xsl:when>
									<xsl:otherwise>
										&#xA0;<b><xsl:value-of select="tax_reg_st" /></b>
									</xsl:otherwise>
								</xsl:choose>
							</td>
                        </tr>
                         <tr>
                           <td class="editDisplayClass211">Old ECC No:</td>
                           <td class="brdrt gray" style="text-align: right;">&#xA0;
                              <xsl:value-of select="ecc_no_o" />
                           </td>
                           <td class="editDisplayClass211">New ECC No:</td>
                           <td class="gray" style="text-align: right;">
								<xsl:choose>
									<xsl:when test="ecc_no = ecc_no_o">
										&#xA0;<xsl:value-of select="ecc_no" />
									</xsl:when>
									<xsl:otherwise>
										&#xA0;<b><xsl:value-of select="ecc_no" /></b>
									</xsl:otherwise>
								</xsl:choose>
							</td>
                        </tr>
                         <tr>
                           <td class="editDisplayClass211">Old CST No:</td>
                           <td class="brdrt gray" style="text-align: right;">&#xA0;
                              <xsl:value-of select="cst_no_o" />
                           </td>
                           <td class="editDisplayClass211">New CST No:</td>
                           <td class="gray" style="text-align: right;">
								<xsl:choose>
									<xsl:when test="cst_no = cst_no_o">
										&#xA0;<xsl:value-of select="cst_no" />
									</xsl:when>
									<xsl:otherwise>
										&#xA0;<b><xsl:value-of select="cst_no" /></b>
									</xsl:otherwise>
								</xsl:choose>
							</td>
                        </tr>
                          <tr>
                           <td class="editDisplayClass211">Old Small Scale Industry:</td>
                           <td class="brdrt gray" style="text-align: right;">&#xA0;
                              <xsl:value-of select="ssi_o" />
                           </td>
                           <td class="editDisplayClass211">New Small Scale Industry:</td>
                           <td class="gray" style="text-align: right;">
								<xsl:choose>
									<xsl:when test="ssi = ssi_o">
										&#xA0;<xsl:value-of select="ssi" />
									</xsl:when>
									<xsl:otherwise>
										&#xA0;<b><xsl:value-of select="ssi" /></b>
									</xsl:otherwise>
								</xsl:choose>
							</td>
                        </tr>
                        <tr>
                           <td class="editDisplayClass211">Old PF Number:</td>
                           <td class="brdrt gray" style="text-align: right;">&#xA0;
                              <xsl:value-of select="pf_no_o" />
                           </td>
                           <td class="editDisplayClass211">New PF Number:</td>
                           <td class="gray" style="text-align: right;">
								<xsl:choose>
									<xsl:when test="pf_no = pf_no_o">
										&#xA0;<xsl:value-of select="ssi" />
									</xsl:when>
									<xsl:otherwise>
										&#xA0;<b><xsl:value-of select="pf_no" /></b>
									</xsl:otherwise>
								</xsl:choose>
							</td>
                        </tr>
                        <tr>
                           <td class="editDisplayClass211">Status:</td>
                           <td class="brdrt gray" style="text-align: right;">&#xA0;
								<xsl:choose>
									<xsl:when test="wf_status = 'O'">
										Open
									</xsl:when>
								</xsl:choose>
								<xsl:choose>
									<xsl:when test="wf_status = 'S'">
										Submit
									</xsl:when>
								</xsl:choose>
						   </td>
                           <td class="editDisplayClass211">Status Date:</td>
                           <td class="gray" style="text-align: right;">
                              <xsl:value-of select="status_date" />
                           </td>
                        </tr>
                     </xsl:for-each>
                  </tbody>
               </table>
            </form>
         </body>
      </html>
   </xsl:template>
</xsl:stylesheet>