package ibase.webitm.ejb.gst;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.PrivateKey;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

import javax.annotation.PostConstruct;

import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.request.HttpRequest;
import com.sun.jmx.snmp.Timestamp;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.bean.gst.APICallData;
import ibase.webitm.bean.gst.AT;
import ibase.webitm.bean.gst.ATA;
import ibase.webitm.bean.gst.B2B;
import ibase.webitm.bean.gst.B2BUR;
import ibase.webitm.bean.gst.B2CL;
import ibase.webitm.bean.gst.B2CLA;
import ibase.webitm.bean.gst.B2CS;
import ibase.webitm.bean.gst.B2CSA;
import ibase.webitm.bean.gst.CDNDetails;
import ibase.webitm.bean.gst.CDNR;
import ibase.webitm.bean.gst.CDNRA;
import ibase.webitm.bean.gst.CDNUR;
import ibase.webitm.bean.gst.DocDetails;
import ibase.webitm.bean.gst.DocIssued;
import ibase.webitm.bean.gst.Docs;
import ibase.webitm.bean.gst.EXP;
import ibase.webitm.bean.gst.GSTR1;
import ibase.webitm.bean.gst.GSTR2;
import ibase.webitm.bean.gst.GSTR3B;
import ibase.webitm.bean.gst.HSN;
import ibase.webitm.bean.gst.HSNDetails;
import ibase.webitm.bean.gst.IMPG;
import ibase.webitm.bean.gst.IMPS;
import ibase.webitm.bean.gst.ITCData;
import ibase.webitm.bean.gst.ITCEligibilty;
import ibase.webitm.bean.gst.InterNilSupplies;
import ibase.webitm.bean.gst.InterStateSupplies;
import ibase.webitm.bean.gst.InterStateSuppliesData;
import ibase.webitm.bean.gst.InterestLateFeeData;
import ibase.webitm.bean.gst.IntraNilSupplies;
import ibase.webitm.bean.gst.InvLineItem;
import ibase.webitm.bean.gst.Invoice;
import ibase.webitm.bean.gst.InwardSupplies;
import ibase.webitm.bean.gst.InwardSuppliesDetails;
import ibase.webitm.bean.gst.InwardSuppliesUnderRevCharge;
import ibase.webitm.bean.gst.Nil;
import ibase.webitm.bean.gst.NilInwardSupplies;
import ibase.webitm.bean.gst.OutwardExempetedSupplies;
import ibase.webitm.bean.gst.OutwardNonGSTSupplies;
import ibase.webitm.bean.gst.OutwardSuppliesDetails;
import ibase.webitm.bean.gst.OutwardZeroRatedSupplies;
import ibase.webitm.bean.gst.SuppliesDetails;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.util.gst.AESEncryption;
import ibase.webitm.util.gst.GSPSignature;
import ibase.webitm.util.gst.GSTCommonUtil;
import ibase.webitm.util.gst.PubKeyEncryption;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;

@javax.ejb.Stateless
public class GSTDataSubmitWizPos extends ValidatorEJB implements GSTDataSubmitWizPosLocal, GSTDataSubmitWizPosRemote
{
	private String BASE_API_URL = "";
	private String AUTH_TOKEN_URL = "";
	private String GSTR_RETSTAT_URL = "";
	private String GSTR1_URL = "";
	private String GSTR2_URL = "";
	private String GSTR3_URL = "";
	private String GSTR2A_URL = "";
	private String GSTR3B_URL = "";
	private String FILEDET_URL = "";
	private final String APPLICATION_JSON = "application/json";
	private String appKey = "";
	String ipAddress = "";
	private byte[] appKeyInBytes = null;
	private String appKeyEncryptedAndCoded = "";
	private String clientId = "";
	private String clientSecret = "";
	String userName = "", gstin = "", periodCode = "", stateCode = "", authToken = "";
	byte[] authSEK = null;
	private String fileDownloadDir = "";
	private String saveFilePath = "";
	private String gstDateFormat = "";
	
	AESEncryption aesEncryption = null;
	PubKeyEncryption pubKeyEncryption = null;
	Connection conn = null;
	GSPSignature gspSignature;
	PrivateKey aspPrivateKey = null;
	
	E12GenericUtility e12GenericUtility = new E12GenericUtility();
	GSTCommonUtil gstCommonUtil = new GSTCommonUtil();
	
	@PostConstruct
	public void postConstruct()
	{
		String gstnPublicKeyName = "", gspPrivateKeyName = "";
		try(java.util.Scanner sc = new java.util.Scanner(new java.net.URL("https://api.ipify.org").openStream(), "UTF-8").useDelimiter("\\A"))
		{
			System.out.println("GSTDataSubmitWizPos PostConstruct called!");
			conn = getConnection();
			FinCommon finCommon = new FinCommon();
			gstnPublicKeyName = finCommon.getFinparams("999999", "GSTN_PUB_KEY_NAME", conn);
			gspPrivateKeyName = finCommon.getFinparams("999999", "GSP_PRI_KEY_NAME", conn);
			if("NULLFOUND".equalsIgnoreCase(gstnPublicKeyName))
			{
				gstnPublicKeyName = "GSTN_G2B_Prod_Public";
			}
			if("NULLFOUND".equalsIgnoreCase(gspPrivateKeyName))
			{
				gspPrivateKeyName = "GSP_Private_Prod_Key";
			}
			System.out.println("gstnPublicKeyName["+gstnPublicKeyName+"]");
			System.out.println("gspPrivateKeyName["+gspPrivateKeyName+"]");
			InputStream pubKeyInpStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("ibase/webitm/resources/gst/"+gstnPublicKeyName.trim()+".cer");
			clientId = finCommon.getFinparams("999999", "GST_CLIENT_ID", conn);
			clientSecret = finCommon.getFinparams("999999", "GST_CLIENT_SECRET", conn);
			fileDownloadDir = finCommon.getFinparams("999999", "GST_DOWNLOAD_DIR", conn);
			aesEncryption = new AESEncryption();
			pubKeyEncryption = new PubKeyEncryption(pubKeyInpStream);
			ipAddress = sc.next();
			if(ipAddress== null || ipAddress.trim().length() == 0)
			{
				String tomcatHome = CommonConstants.TOMCAT_HOME;
				ipAddress = tomcatHome.substring(tomcatHome.lastIndexOf("/")+1, tomcatHome.lastIndexOf(":"));
			}
			System.out.println("host ipAddress["+ipAddress+"]");
			gspSignature = new GSPSignature();
			String privateKeyPath = "/ibase/webitm/resources/gst/"+gspPrivateKeyName.trim()+".pem";
			aspPrivateKey = gspSignature.loadPrivateKey(Thread.currentThread().getContextClassLoader().getResourceAsStream(privateKeyPath));
			gstDateFormat = gstCommonUtil.getGSTDateFormat();
			System.out.println("gstDateFormat["+gstDateFormat+"]");
		}
		catch (Exception e) 
		{
			System.out.println("GSTDataSubmitWizPos.postConstruct()["+e.getMessage()+"]");
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(conn!= null && !conn.isClosed())
				{
					conn.close();
					conn = null;
				}
			}
			catch(SQLException se)
			{
				System.out.println("GSTDataSubmitWizPos.postConstruct()["+se.getMessage()+"]");
				se.printStackTrace();
			}
		}
		
	}
	@Override
	public String postSave(String xmlStringAll, String dcrId, String editFlag, String xtraParams, Connection conn) throws RemoteException,ITMException
	{
		Document allXMLDom = null;
		NodeList detail1NList = null, detail1ChildNList = null, detail2NList = null, detail2ChildNList = null;
		String retString = "", nodeName = "", otp = "", sek = "", returnsType = "", grossTurnover = "",
			   action = "", siteCode = "", gspAuthString = "", gspAuthSignature = "", currentYearTurnover = "", signedData = "", panNo = "", aadhaarNo = "",
			   signMethod = "", summaryData = "";
		String loginCode = "", chgTerm = "", callStatus = "", responseId = "", responseJsonStr= "";
		
		APICallData apiCallData = null;
		boolean isDataLogged = false;
		
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		try
		{
			String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
			
			loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			
			System.out.println("xmlStringAll["+xmlStringAll+"]");
			System.out.println("dcrId["+dcrId+"]");
			System.out.println("editFlag["+editFlag+"]");
			
			sql = "SELECT SERVICE_CODE, SERVICE_URI FROM SYSTEM_EVENT_SERVICES WHERE METHOD_NAME = 'GST_API_URL'";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				switch(rs.getString("SERVICE_CODE"))
				{
					case "base_url" :
					{
						BASE_API_URL = rs.getString("SERVICE_URI");
					}
					break;
					case "gstr_auth_url" :
					{
						AUTH_TOKEN_URL = rs.getString("SERVICE_URI");
					}
					break;
					case "gstr_retstatus_url" :
					{
						GSTR_RETSTAT_URL = rs.getString("SERVICE_URI");
					}
					break;
					case "gstr1_url" :
					{
						GSTR1_URL = rs.getString("SERVICE_URI");
					}
					break;
					case "gstr2_url" :
					{
						GSTR2_URL = rs.getString("SERVICE_URI");
					}
					break;
					case "gstr2a_url" :
					{
						GSTR2A_URL = rs.getString("SERVICE_URI");
					}
					break;
					case "gstr3_url" :
					{
						GSTR3_URL = rs.getString("SERVICE_URI");
					}
					break;
					case "gstr3b_url" :
					{
						GSTR3B_URL = rs.getString("SERVICE_URI");
					}
					break;
					case "gstr_filedet_url" :
					{
						FILEDET_URL = rs.getString("SERVICE_URI");
					}
					break;
				}
			}
			closeResources(rs, pstmt);
			
			System.out.println("BASE_API_URL["+BASE_API_URL+"]");
			System.out.println("AUTH_TOKEN_URL["+AUTH_TOKEN_URL+"]");
			System.out.println("GSTR_URL["+GSTR_RETSTAT_URL+"]");
			System.out.println("GSTR1_URL["+GSTR1_URL+"]");
			System.out.println("GSTR2_URL["+GSTR2_URL+"]");
			System.out.println("GSTR2A_URL["+GSTR2A_URL+"]");
			System.out.println("GSTR3B_URL["+GSTR3B_URL+"]");
			System.out.println("FILEDET_URL["+FILEDET_URL+"]");
			
			allXMLDom = e12GenericUtility.parseString(xmlStringAll);
			
			detail1NList = allXMLDom.getElementsByTagName("Detail1");
			detail1ChildNList = detail1NList.item(0).getChildNodes();
			
			for(int i=0; i<detail1ChildNList.getLength();i++)
			{
				Node eachDetail1Element = detail1ChildNList.item(i);
				nodeName = eachDetail1Element.getNodeName();
				
				if(!"#text".equalsIgnoreCase(nodeName) && !"attribute".equals(nodeName))
				{
					if("username".equalsIgnoreCase(nodeName))
					{
						userName = eachDetail1Element.getTextContent();
					}
					else if("state_code".equalsIgnoreCase(nodeName))
					{
						stateCode = eachDetail1Element.getTextContent();;
					}
					else if("app_key".equalsIgnoreCase(nodeName))
					{
						appKey = eachDetail1Element.getTextContent();
					}
					else if("otp".equalsIgnoreCase(nodeName))
					{
						otp = eachDetail1Element.getTextContent();
					}
					else if("returns_type".equalsIgnoreCase(nodeName))
					{
						returnsType = eachDetail1Element.getTextContent();
					}
					else if("gstin".equalsIgnoreCase(nodeName))
					{
						gstin = eachDetail1Element.getTextContent();
					}
					else if("period_code".equalsIgnoreCase(nodeName))
					{
						periodCode = eachDetail1Element.getTextContent();
					}
					else if("gross_turnover".equalsIgnoreCase(nodeName))
					{
						grossTurnover = eachDetail1Element.getTextContent();
					}
					else if("action".equalsIgnoreCase(nodeName))
					{
						action = eachDetail1Element.getTextContent();
					}
					else if("site_code".equalsIgnoreCase(nodeName))
					{
						siteCode = eachDetail1Element.getTextContent();
					}
					else if("cur_gross_turnover".equalsIgnoreCase(nodeName))
					{
						currentYearTurnover = eachDetail1Element.getTextContent();
					}
				}
			}
			
			System.out.println("returnsType["+returnsType+"] action ["+action+"]");
			
			if("SUBMIT".equalsIgnoreCase(action) || "FILE".equalsIgnoreCase(action))
			{
				detail2NList = allXMLDom.getElementsByTagName("Detail2");
				detail2ChildNList = detail2NList.item(0).getChildNodes();
				
				for(int i=0; i<detail2ChildNList.getLength();i++)
				{
					Node eachDetail2Element = detail2ChildNList.item(i);
					nodeName = eachDetail2Element.getNodeName();
					
					if(!"#text".equalsIgnoreCase(nodeName) && !"attribute".equals(nodeName))
					{
						if("auth_token".equalsIgnoreCase(nodeName))
						{
							authToken = eachDetail2Element.getTextContent();
						}
						else if("auth_sek".equalsIgnoreCase(nodeName))
						{
							sek = eachDetail2Element.getTextContent();
						}
						else if("summary_data".equalsIgnoreCase(nodeName))
						{
							summaryData = eachDetail2Element.getTextContent();
						}
						else if("signed_data".equalsIgnoreCase(nodeName))
						{
							signedData = eachDetail2Element.getTextContent();
						}
						else if("pan_no".equalsIgnoreCase(nodeName))
						{
							panNo = eachDetail2Element.getTextContent();
						}
						else if("aadhar_no".equalsIgnoreCase(nodeName))
						{
							aadhaarNo = eachDetail2Element.getTextContent();
						}
						else if("sign_method".equalsIgnoreCase(nodeName))
						{
							signMethod = eachDetail2Element.getTextContent();
						}
					}
				}
				
				System.out.println("authToken["+authToken+"] sek["+sek+"]");
			}
			
			appKeyInBytes = aesEncryption.decodeBase64StringTOByte(appKey);
			appKeyEncryptedAndCoded = pubKeyEncryption.encrypt(appKeyInBytes);
			
			if(authToken.trim().length() > 0 && sek.trim().length() > 0)
			{
				System.out.println("authToken and authSEK from detail2");
				
				authSEK = aesEncryption.decrypt(sek, appKeyInBytes);
                System.out.println("authSEK = "+ aesEncryption.encodeBase64String(authSEK));
			}
			else
			{
				String encryptedOTP = aesEncryption.encryptEK(otp.getBytes(), appKeyInBytes);
				
				JSONObject authTokenReqObj = new JSONObject();
		        authTokenReqObj.put("action", "AUTHTOKEN");
		        authTokenReqObj.put("username", userName);
		        authTokenReqObj.put("app_key", appKeyEncryptedAndCoded);
		        authTokenReqObj.put("otp", encryptedOTP);
		        
		        long timeStamp = new Timestamp().getDateTime();
		        gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin;
				gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
				
		        HttpRequest authTokenReq = Unirest.post(String.format("%s%s", BASE_API_URL, AUTH_TOKEN_URL))
										   .header("Content-Type",APPLICATION_JSON)
										   .header("clientid", clientId)
										   .header("client-secret", clientSecret)
										   .header("state-cd", stateCode)
										   .header("ip-usr", ipAddress)
										   .header("txn", transactionId)
										   .header("X-Asp-Auth-Token", gspAuthString)
					    	               .header("X-Asp-Auth-Signature", gspAuthSignature)
										   .body(new JsonNode(authTokenReqObj.toString()))
										   .getHttpRequest();
		        
		        System.out.println("authtoken url["+authTokenReq.getUrl()+"]");
		        System.out.println("authtoken method["+authTokenReq.getHttpMethod()+"]");
				System.out.println("authtoken request header["+authTokenReq.getHeaders()+"]");
				System.out.println("authtoken request payload["+IOUtils.toString(authTokenReq.getBody().getEntity().getContent())+"]");
		        
		        HttpResponse<JsonNode> authTokenResp = authTokenReq.asJson();
		        
		        apiCallData = new APICallData();
		        apiCallData.setPeriodCode(periodCode);
		        apiCallData.setCallDate(new Date());
		        apiCallData.setSiteCode(siteCode);
		        apiCallData.setUserId(loginCode);
		        apiCallData.setCallType("AUTHTOKEN");
		        apiCallData.setRecType("1");
		        apiCallData.setNoOfRecords(0);
		        apiCallData.setChgUser(loginCode);
		        apiCallData.setChgDate(new Date());
		        apiCallData.setChgTerm(chgTerm);

		        System.out.println(String.format("authTokenResp Request : Status[%s] Response[%s]", authTokenResp.getStatus(), authTokenResp.getBody()));
		        if (authTokenResp.getStatus() == 200) 
		        {
		            JSONObject object = authTokenResp.getBody().getObject();
		            if (object.has("auth_token") && object.has("sek") && object.has("status_cd") && Objects.equals(object.getString("status_cd"), "1")) 
		            {
		                authToken = object.getString("auth_token");
		                sek = object.getString("sek");

		                authSEK = aesEncryption.decrypt(sek, appKeyInBytes);
		                System.out.println("authSEK = "+ aesEncryption.encodeBase64String(authSEK));
		                
		                callStatus = "1";
		                apiCallData.setCallStatus(callStatus);
				        apiCallData.setResponseId(responseId);
				        apiCallData.setResponseJsonStr(responseJsonStr);
		                
		            }
		            else
		            {
		            	JSONObject errorJSON = authTokenResp.getBody().getObject().getJSONObject("error");
		            	
		            	if("AUTH4033".equalsIgnoreCase(errorJSON.getString("error_cd")))
		            	{
		            		callStatus = "2";
		            		responseJsonStr = errorJSON.getString("message");
		            		apiCallData.setCallStatus(callStatus);
					        apiCallData.setResponseId(responseId);
					        apiCallData.setResponseJsonStr(responseJsonStr);
		            		retString = new ITMDBAccessEJB().getErrorString("","VTINVOTP","","",conn);
		            		return retString;
		            	}
		            	else
		            	{
		            		String errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
		            		retString = getError(errMsg, "GSTAPIERR", conn);
		            		callStatus = "2";
		            		responseJsonStr = errMsg;
		            		apiCallData.setCallStatus(callStatus);
					        apiCallData.setResponseId(responseId);
					        apiCallData.setResponseJsonStr(responseJsonStr);
		            		return retString;
		            	}
		            }
		        }
		        else if(authTokenResp.getStatus() == 500)
		        {
		        	String errMsg = "Message : Error occurred at GSTN server \nResponse code : "+authTokenResp.getStatus();
		        	callStatus = "2";
		        	responseJsonStr = errMsg;
            		apiCallData.setCallStatus(callStatus);
			        apiCallData.setResponseId(responseId);
			        apiCallData.setResponseJsonStr(responseJsonStr);
		        	retString = getError(errMsg, "GSTAPIERR", conn);
		        	return retString;
		        }
		        else
		        {
		        	JSONObject errorJSON = authTokenResp.getBody().getObject().getJSONObject("error");
		        	String errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
		        	retString = getError(errMsg, "GSTAPIERR", conn);
		        	callStatus = "2";
		        	responseJsonStr = errMsg;
            		apiCallData.setCallStatus(callStatus);
			        apiCallData.setResponseId(responseId);
			        apiCallData.setResponseJsonStr(responseJsonStr);
		        	return retString;
		        }
		        
		        gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
		        isDataLogged = true;
			}
			
			if(authToken != null && authToken.trim().length() > 0 && authSEK != null)
			{
				if("GSTR1".equalsIgnoreCase(returnsType))
	            {
	            	if("SAVE".equalsIgnoreCase(action))
	            	{
	            		retString = createGstr1Json( siteCode, grossTurnover, currentYearTurnover, xtraParams, conn);
	            	}
	            	else if ("SUBMIT".equalsIgnoreCase(action))
	            	{
	            		retString = submitGstr("1", xtraParams, conn);
	            	}
	            	else if ("FILE".equalsIgnoreCase(action))
	            	{
	            		retString = fileGstr("1", summaryData, signedData, panNo, aadhaarNo, signMethod, xtraParams, conn);
	            	}
	            	else if("DELETE".equalsIgnoreCase(action))
	            	{
	            		retString = createDeleteGstr1Json( siteCode, grossTurnover, currentYearTurnover, xtraParams, conn);
	            	}
	            }
	            else if("GSTR2A".equalsIgnoreCase(returnsType))
	            {
	            	if("GETINV".equalsIgnoreCase(action))
	            	{
	            		retString = downloadGstr2AData(siteCode, xtraParams, conn);
	            	}
	            }
	            else if("GSTR2".equalsIgnoreCase(returnsType))
	            {
	            	if("SAVE".equalsIgnoreCase(action))
	            	{
	            		retString = createGstr2Json(siteCode, xtraParams, conn);
	            	}
	            	else if("GENERATE".equalsIgnoreCase(returnsType))
	            	{
	            		retString = generateGSTR3(xtraParams, conn);
	            	}
	            	else if ("SUBMIT".equalsIgnoreCase(action))
	            	{
	            		retString = submitGstr("2", xtraParams, conn);
	            	}
	            	else if ("FILE".equalsIgnoreCase(action))
	            	{
	            		retString = fileGstr("2", summaryData, signedData, panNo, aadhaarNo, signMethod, xtraParams, conn);
	            	}
	            	else if("DELETE".equalsIgnoreCase(action))
	            	{
	            		retString = createDeleteGstr2Json( siteCode, xtraParams, conn);
	            	}
	            }
	            else if("GSTR3B".equalsIgnoreCase(returnsType))
	            {
	            	if("SAVE".equalsIgnoreCase(action))
	            	{
	            		retString = createGstr3bJson(siteCode, xtraParams, conn);
	            	}
	            	else if("SUBMIT".equalsIgnoreCase(action))
	            	{
	            		retString = submitGstr3b(xtraParams, conn);
	            	}
	            	else if("FILE".equalsIgnoreCase(action))
	            	{
	            		retString = fileGstr3b(summaryData, signedData, panNo, aadhaarNo, signMethod, xtraParams, conn);
	            	}
	            }
			}
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.postSave()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			if(apiCallData != null && !isDataLogged)
			{
				gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
			}
		}
		
		return retString;
	}
	
	private String createGstr1Json(String siteCode, String grossTurnover, String currentYearTurnover, String xtraParams, Connection conn) throws ITMException
	{
		String retString = "";
		int num = 0, noOfRecords = 0;
		
		boolean isDataFound = false;
		
		String udfStr1 = "", udfStr2 = "", udfStr3 = "";
		String sql = "", lineSql = "", refDataSql = "";
		PreparedStatement pstmt = null, linePstmt = null, refDataPstmt = null;
		ResultSet rs = null, lineRs = null, refDataRs = null;
		
		String tranId = "", tranType = "", tranIdRef = "", ctin = "", posStateCode = "";
		
		ArrayList<String> tranIdList = new ArrayList<String>();
		
		Map<String, ArrayList<Invoice>> invoicesHMap = new HashMap<String, ArrayList<Invoice>>();
		Map<String, Object> invTypObjHMap = new HashMap<String, Object>();
		ArrayList<B2B> b2bInvoiceList = new ArrayList<B2B>();
		ArrayList<B2CL> b2clInvoiceList = new ArrayList<B2CL>();
		ArrayList<B2CLA> b2claInvoiceList = new ArrayList<B2CLA>();
		ArrayList<B2CS> b2csInvoiceList = new ArrayList<B2CS>();
		ArrayList<B2CSA> b2csaInvoiceList = new ArrayList<B2CSA>();
		ArrayList<CDNR> cdnrList = new ArrayList<CDNR>();
		ArrayList<CDNRA> cdnraList = new ArrayList<CDNRA>();
		ArrayList<AT> atList = new ArrayList<AT>();
		ArrayList<ATA> ataList = new ArrayList<ATA>();
		ArrayList<EXP> expInvoiceList = new ArrayList<EXP>();
		ArrayList<AT> atPaidList = new ArrayList<AT>();
		ArrayList<CDNUR> cdnurList = new ArrayList<CDNUR>();

		ArrayList<InvLineItem> invLineItems = null;
		ArrayList<Invoice> invoices = null;
		ArrayList<CDNDetails> cdnDetailsList = null;
		ArrayList<HSNDetails> hsnList = new ArrayList<HSNDetails>();
		ArrayList<DocDetails> docDetailsList = new ArrayList<DocDetails>();
		ArrayList<Docs> docsList = null;
		
		GSTR1 gstr1 = null;
		Invoice invoice = null;
		InvLineItem invLineItem = null;
		B2B b2b = null;
		B2CL b2cl = null;
		B2CS b2cs = null;
		CDNR cdnr = null;
		CDNDetails cdnDetails = null;
		AT at = null;
		EXP exp = null;
		CDNUR cdnur = null;
		Nil nil = null;
		HSN hsn = null;	
		HSNDetails hsnDetails = null;
		DocIssued docIssued = null;
		
		try
		{
			Date payloadStartTime = new Date();
			
			sql = "SELECT * FROM GST_DATA_HDR WHERE PRD_CODE = ? AND SITE_CODE = ? AND SUBMIT_STATUS = 'P' AND REC_TYPE ='1'";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, periodCode);
			pstmt.setString(2, siteCode);
			rs = pstmt.executeQuery();

			while(rs.next())
			{
				++noOfRecords;
				isDataFound = true;
				tranId = checkNullandTrim(rs.getString("TRAN_ID"));
				tranType = checkNullandTrim(rs.getString("TRAN_TYPE"));
				ctin = checkNullandTrim(rs.getString("TAX_REG_NO"));
				posStateCode = checkNullandTrim(rs.getString("GST_CODE"));
				tranIdRef = checkNullandTrim(rs.getString("TRAN_ID__REF"));
				
				System.out.println("in saveGstr1 tranId["+tranId+"] tranType["+tranType+"] ctin["+ctin+"] posStateCode["+posStateCode+"] tranIdRef["+tranIdRef+"]");
				
				invoices = new ArrayList<Invoice>();
				invoice = new Invoice();
				invLineItems = new ArrayList<InvLineItem>();
				cdnDetailsList = new ArrayList<CDNDetails>();
				
				lineSql = "SELECT UDF_STR1, UDF_STR2, UDF_STR3 FROM GENCODES WHERE MOD_NAME='W_GSTR' AND FLD_NAME='TRAN_TYPE' AND FLD_VALUE = ? ";
				linePstmt = conn.prepareStatement(lineSql);
				linePstmt.setString(1, tranType);
				
				lineRs = linePstmt.executeQuery();
				
				if(lineRs.next())
				{
					udfStr1 = checkNullandTrim(lineRs.getString("UDF_STR1"));
					udfStr2 = checkNullandTrim(lineRs.getString("UDF_STR2"));
					udfStr3 = checkNullandTrim(lineRs.getString("UDF_STR3"));
				}
				if(linePstmt!=null)
				{
					linePstmt.close();
					linePstmt=null;
				}
				if(lineRs!=null)
				{
					lineRs.close();
					lineRs=null;
				}
				
				if(invoicesHMap.containsKey(ctin+"~"+udfStr1))
				{
					invoices = invoicesHMap.get(ctin+"~"+udfStr1);
				}
				
				//tran_type : 01,02,03,08,09,10 = B2B invoices
				if("B2B".equalsIgnoreCase(udfStr1))
				{
					lineSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(IGST_AMT) AS IGST_AMT, SUM(CGST_AMT) AS CGST_AMT, SUM(SGST_AMT) AS SGST_AMT, SUM(CESS_AMT) AS CESS_AMT "
							+ " FROM GST_DATA_DET "
							+ " WHERE TRAN_ID = ? "
							+ " GROUP BY GST_RATE";
					linePstmt = conn.prepareStatement(lineSql);
					linePstmt.setString(1, tranId);
					lineRs = linePstmt.executeQuery();
					int lineNum = 0;
					while(lineRs.next())
					{
						invLineItem = new InvLineItem();
						invLineItem.num = ++lineNum;
						invLineItem.rate = lineRs.getDouble("GST_RATE");
						invLineItem.taxval = lineRs.getDouble("TAXABLE_AMT");
						invLineItem.iamt = lineRs.getDouble("IGST_AMT");
						invLineItem.camt = lineRs.getDouble("CGST_AMT");
						invLineItem.samt = lineRs.getDouble("SGST_AMT");
						invLineItem.csamt = lineRs.getDouble("CESS_AMT");
						
						invLineItems.add(invLineItem);
					}
					if(linePstmt != null)
					{
						linePstmt.close();
						linePstmt = null;
					}
					if(lineRs != null)
					{
						lineRs.close();
						lineRs = null;
					}
					
					invoice.inum = rs.getString("DOC_NO");
					invoice.idt = rs.getDate("DOC_DATE");
					invoice.val = rs.getDouble("AMOUNT");
					invoice.invoiceType = udfStr2;
					invoice.pos = posStateCode;
					invoice.rchrg = "Y".equalsIgnoreCase(rs.getString("REVERSE_CHRG"));
					invoice.etin = rs.getString("ECOM_REG_NO");
					invoice.items = invLineItems;
					
					invoices.add(invoice);
					
					invoicesHMap.put(ctin+"~"+udfStr1, invoices);
					
					if("B2B".equalsIgnoreCase(udfStr1))
					{
						b2b = new B2B();
						if(invTypObjHMap.containsKey(ctin+"~"+udfStr1))
						{
							b2b = (B2B)invTypObjHMap.get(ctin+"~"+udfStr1);
							if(b2bInvoiceList.contains(b2b))
							{
								int index = b2bInvoiceList.indexOf(b2b);
								b2bInvoiceList.remove(index);
							}
						}
						b2b.ctin = ctin;
						b2b.isReverseCharge = true;
						b2b.invoices = invoices;
						
						invTypObjHMap.put(ctin+"~"+udfStr1, b2b);
						b2bInvoiceList.add(b2b);
					}
				}
				//tran_type : 04, 05 = B2CL invoices
				if("B2CL".equalsIgnoreCase(udfStr1))
				{
					invoices = new ArrayList<Invoice>();
					invoice = new Invoice();
					invLineItems = new ArrayList<InvLineItem>();
					
					lineSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(IGST_AMT) AS IGST_AMT, SUM(CGST_AMT) AS CGST_AMT, SUM(SGST_AMT) AS SGST_AMT, SUM(CESS_AMT) AS CESS_AMT "
							+ " FROM GST_DATA_DET "
							+ " WHERE TRAN_ID = ? "
							+ " GROUP BY GST_RATE";
					linePstmt = conn.prepareStatement(lineSql);
					linePstmt.setString(1, tranId);
					lineRs = linePstmt.executeQuery();
					int lineNum = 0;
					while(lineRs.next())
					{
						invLineItem = new InvLineItem();
						invLineItem.num = ++lineNum;
						invLineItem.rate = lineRs.getDouble("GST_RATE");
						invLineItem.taxval = lineRs.getDouble("TAXABLE_AMT");
						invLineItem.iamt = lineRs.getDouble("IGST_AMT");
						invLineItem.camt = lineRs.getDouble("CGST_AMT");
						invLineItem.samt = lineRs.getDouble("SGST_AMT");
						invLineItem.csamt = lineRs.getDouble("CESS_AMT");
						
						invLineItems.add(invLineItem);
					}
					if(linePstmt != null)
					{
						linePstmt.close();
						linePstmt = null;
					}
					if(lineRs != null)
					{
						lineRs.close();
						lineRs = null;
					}
					
					invoice.inum = checkNullandTrim(rs.getString("DOC_NO"));
					invoice.idt = rs.getDate("DOC_DATE");
					invoice.val = rs.getDouble("AMOUNT");
					invoice.etin = rs.getString("ECOM_REG_NO");
					invoice.items = invLineItems;
					
					invoices.add(invoice);
					
					if("B2CL".equalsIgnoreCase(udfStr1))
					{
						b2cl = new B2CL();
						b2cl.isReverseCharge = false;
						b2cl.stateCode = posStateCode;
						b2cl.invoices = invoices;
						
						b2clInvoiceList.add(b2cl);
					}
				}
				//tran_type : 11,12,13,14 = B2CS invoices, 37,38,39,40 = B2CSA invoices
				if("B2CS".equalsIgnoreCase(udfStr1) || "B2CSA".equalsIgnoreCase(udfStr1))
				{
					
					lineSql = "SELECT * FROM GST_DATA_DET WHERE TRAN_ID = ? ORDER BY LINE_NO ";
					linePstmt = conn.prepareStatement(lineSql);
					linePstmt.setString(1, tranId);
					lineRs = linePstmt.executeQuery();
					
					while(lineRs.next())
					{
						if("B2CS".equalsIgnoreCase(udfStr1))
						{
							b2cs = new B2CS();
							
							b2cs.supplyType = udfStr2;
							b2cs.txval = lineRs.getDouble("TAXABLE_AMT");
							b2cs.typ = udfStr3;
							b2cs.etin = rs.getString("ECOM_REG_NO");
							b2cs.pos = posStateCode;
							b2cs.rate = lineRs.getDouble("GST_RATE");
							b2cs.iamt = lineRs.getDouble("IGST_AMT");
							b2cs.camt = lineRs.getDouble("CGST_AMT");
							b2cs.samt = lineRs.getDouble("SGST_AMT");
							b2cs.csamt = lineRs.getDouble("CESS_AMT");
							
							b2csInvoiceList.add(b2cs);
						}
					}
					if(linePstmt != null)
					{
						linePstmt.close();
						linePstmt = null;
					}
					if(lineRs != null)
					{
						lineRs.close();
						lineRs = null;
					}
				}
				//tran_type : 29,30 = CDNR, 33,34 = CDNRA
				if("CDNR".equalsIgnoreCase(udfStr1) || "CDNRA".equalsIgnoreCase(udfStr1))
				{
					Calendar calendar = Calendar.getInstance();
					calendar.set(2017, 06, 01);
					Date gstStartDate = calendar.getTime();
					
					if("CDNR".equalsIgnoreCase(udfStr1))
					{
						lineSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(IGST_AMT) AS IGST_AMT, SUM(CGST_AMT) AS CGST_AMT, SUM(SGST_AMT) AS SGST_AMT, SUM(CESS_AMT) AS CESS_AMT "
								+ " FROM GST_DATA_DET "
								+ " WHERE TRAN_ID = ? "
								+ " GROUP BY GST_RATE";
						linePstmt = conn.prepareStatement(lineSql);
						linePstmt.setString(1, tranId);
						lineRs = linePstmt.executeQuery();
						int lineNum = 0;
						while(lineRs.next())
						{
							invLineItem = new InvLineItem();
							invLineItem.num = ++lineNum;
							invLineItem.rate = lineRs.getDouble("GST_RATE");
							invLineItem.taxval = lineRs.getDouble("TAXABLE_AMT");
							invLineItem.iamt = lineRs.getDouble("IGST_AMT");
							invLineItem.camt = lineRs.getDouble("CGST_AMT");
							invLineItem.samt = lineRs.getDouble("SGST_AMT");
							invLineItem.csamt = lineRs.getDouble("CESS_AMT");
							
							invLineItems.add(invLineItem);
						}
						if(linePstmt != null)
						{
							linePstmt.close();
							linePstmt = null;
						}
						if(lineRs != null)
						{
							lineRs.close();
							lineRs = null;
						}
						
						cdnDetails = new CDNDetails();
						
						cdnDetails.cdnNoteType = udfStr2;
						cdnDetails.cdNoteNumber = checkNullandTrim(rs.getString("DOC_NO"));
						cdnDetails.cdNoteDate = rs.getDate("DOC_DATE");
						cdnDetails.invoiceNumber = checkNullandTrim(rs.getString("REF_ID__INV"));
						cdnDetails.invoiceDate = rs.getDate("REF_DATE__INV");
						cdnDetails.val = rs.getDouble("AMOUNT");
						//cdnDetails.reason = checkNullandTrim(rs.getString("REAS_CODE"));
						cdnDetails.reason = "07-Others";//TODO sending hardcoded reason value, difficult to determine as per GSTN reason list 
						if(rs.getDate("REF_DATE__INV").before(gstStartDate))
						{
							cdnDetails.isPreGSTInvoice = true;
						}
						cdnDetails.items = invLineItems;
						
						cdnDetailsList.add(cdnDetails);
						
						cdnr = new CDNR();
						cdnr.isReverseCharge = false;
						cdnr.ctin = ctin;
						cdnr.cdnDetails = cdnDetailsList;
						
						cdnrList.add(cdnr);
					}
				}
				//tran_type : 06,07 = Exports and tran_type : 27,28 = Exports amendments
				if("EXP".equalsIgnoreCase(udfStr1) || "EXPA".equalsIgnoreCase(udfStr1))
				{
					invoices = new ArrayList<Invoice>();
					invoice = new Invoice();
					invLineItems = new ArrayList<InvLineItem>();
					
					if("EXP".equalsIgnoreCase(udfStr1))
					{
						
						lineSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(IGST_AMT) AS IGST_AMT, SUM(CGST_AMT) AS CGST_AMT, SUM(SGST_AMT) AS SGST_AMT, SUM(CESS_AMT) AS CESS_AMT "
								+ " FROM GST_DATA_DET "
								+ " WHERE TRAN_ID = ? "
								+ " GROUP BY GST_RATE";
						linePstmt = conn.prepareStatement(lineSql);
						linePstmt.setString(1, tranId);
						lineRs = linePstmt.executeQuery();
						
						while(lineRs.next())
						{
							invLineItem = new InvLineItem();
							invLineItem.rate = lineRs.getDouble("GST_RATE");
							invLineItem.taxval = lineRs.getDouble("TAXABLE_AMT");
							invLineItem.iamt = lineRs.getDouble("IGST_AMT");
							invLineItem.camt = lineRs.getDouble("CGST_AMT");
							invLineItem.samt = lineRs.getDouble("SGST_AMT");
							invLineItem.csamt = lineRs.getDouble("CESS_AMT");
							
							invLineItems.add(invLineItem);
						}
						if(linePstmt != null)
						{
							linePstmt.close();
							linePstmt = null;
						}
						if(lineRs != null)
						{
							lineRs.close();
							lineRs = null;
						}
						
						invoice.inum = rs.getString("DOC_NO");
						invoice.idt = rs.getDate("DOC_DATE");
						invoice.val = rs.getDouble("AMOUNT");
						invoice.shippingPortCode = checkNullandTrim(rs.getString("ORDER_NO"));
						invoice.shippingBillNum = getDoubleValue(rs.getString("LR_NO"));
						invoice.shippingBillDt = rs.getDate("LR_DATE");
						invoice.items = invLineItems;
						
						invoices.add(invoice);
						
						exp = new EXP();
						exp.isReverseCharge = false;
						exp.exportType = udfStr2;
						exp.invoices = invoices;
						
						expInvoiceList.add(exp);
					}
				}
				//tran_type : 41,42 = Advance Tax and tran_type : 45,46 = Adv. Tax amendments
				if("AT".equalsIgnoreCase(udfStr1) || "ATA".equalsIgnoreCase(udfStr1))
				{
					invLineItems = new ArrayList<InvLineItem>();
					
					if("AT".equalsIgnoreCase(udfStr1))
					{
						lineSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(IGST_AMT) AS IGST_AMT, SUM(CGST_AMT) AS CGST_AMT, SUM(SGST_AMT) AS SGST_AMT, SUM(CESS_AMT) AS CESS_AMT "
								+ " FROM GST_DATA_DET "
								+ " WHERE TRAN_ID = ? "
								+ " GROUP BY GST_RATE";
						linePstmt = conn.prepareStatement(lineSql);
						linePstmt.setString(1, tranId);
						lineRs = linePstmt.executeQuery();
						
						while(lineRs.next())
						{
							invLineItem = new InvLineItem();
							
							invLineItem.rate = lineRs.getDouble("GST_RATE");
							invLineItem.taxval = lineRs.getDouble("TAXABLE_AMT");
							invLineItem.iamt = lineRs.getDouble("IGST_AMT");
							invLineItem.camt = lineRs.getDouble("CGST_AMT");
							invLineItem.samt = lineRs.getDouble("SGST_AMT");
							invLineItem.csamt = lineRs.getDouble("CESS_AMT");
							
							invLineItems.add(invLineItem);
						}
						if(linePstmt != null)
						{
							linePstmt.close();
							linePstmt = null;
						}
						if(lineRs != null)
						{
							lineRs.close();
							lineRs = null;
						}
						
						at = new AT();
						at.isReverseCharge = false;
						
						at.recType = "1";
						at.pos = posStateCode;
						at.supplyType = udfStr2;
						at.itms = invLineItems;
						
						atList.add(at);
					}
				}
				//tran_type : 43,44 = Advance Tax paid and tran_type : 47,48 Advance Tax paid amendments
				if("TXP".equalsIgnoreCase(udfStr1))
				{
					invLineItems = new ArrayList<InvLineItem>();
					
					lineSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(IGST_AMT) AS IGST_AMT, SUM(CGST_AMT) AS CGST_AMT, SUM(SGST_AMT) AS SGST_AMT, SUM(CESS_AMT) AS CESS_AMT "
							+ " FROM GST_DATA_DET "
							+ " WHERE TRAN_ID = ? "
							+ " GROUP BY GST_RATE";
					linePstmt = conn.prepareStatement(lineSql);
					linePstmt.setString(1, tranId);
					lineRs = linePstmt.executeQuery();
					
					while(lineRs.next())
					{
						invLineItem = new InvLineItem();
						
						invLineItem.rate = lineRs.getDouble("GST_RATE");
						invLineItem.taxval = lineRs.getDouble("TAXABLE_AMT");
						invLineItem.iamt = lineRs.getDouble("IGST_AMT");
						invLineItem.camt = lineRs.getDouble("CGST_AMT");
						invLineItem.samt = lineRs.getDouble("SGST_AMT");
						invLineItem.csamt = lineRs.getDouble("CESS_AMT");
						
						invLineItems.add(invLineItem);
					}
					if(linePstmt != null)
					{
						linePstmt.close();
						linePstmt = null;
					}
					if(lineRs != null)
					{
						lineRs.close();
						lineRs = null;
					}
					
					at = new AT();
					at.isReverseCharge = false;
					
					at.recType = "1";
					at.pos = posStateCode;
					at.supplyType = udfStr2;
					at.itms = invLineItems;
					
					atPaidList.add(at);
				}
				//tran_type : 31,32 = CDNUR and tran_type : 35,36 = CDNURA
				if("CDNUR".equalsIgnoreCase(udfStr1))
				{
					String customerType = "", refTranType = "";
					Calendar calendar = Calendar.getInstance();
					calendar.set(2017, 06, 01);
					Date gstStartDate = calendar.getTime();
					
					lineSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(IGST_AMT) AS IGST_AMT, SUM(CGST_AMT) AS CGST_AMT, SUM(SGST_AMT) AS SGST_AMT, SUM(CESS_AMT) AS CESS_AMT "
							+ " FROM GST_DATA_DET "
							+ " WHERE TRAN_ID = ? "
							+ " GROUP BY GST_RATE";
					linePstmt = conn.prepareStatement(lineSql);
					linePstmt.setString(1, tranId);
					lineRs = linePstmt.executeQuery();
					int lineNum = 0;
					while(lineRs.next())
					{
						invLineItem = new InvLineItem();
						invLineItem.num = ++lineNum;
						invLineItem.rate = lineRs.getDouble("GST_RATE");
						invLineItem.taxval = lineRs.getDouble("TAXABLE_AMT");
						invLineItem.iamt = lineRs.getDouble("IGST_AMT");
						invLineItem.camt = lineRs.getDouble("CGST_AMT");
						invLineItem.samt = lineRs.getDouble("SGST_AMT");
						invLineItem.csamt = lineRs.getDouble("CESS_AMT");
						
						invLineItems.add(invLineItem);
					}
					if(linePstmt != null)
					{
						linePstmt.close();
						linePstmt = null;
					}
					if(lineRs != null)
					{
						lineRs.close();
						lineRs = null;
					}
					
					cdnur = new CDNUR();
					cdnur.isReverseCharge = false;
					if(rs.getDate("REF_DATE__INV").after(gstStartDate))
					{
						refDataSql = "SELECT TRAN_TYPE FROM GST_DATA_HDR WHERE DOC_NO = ? ";
						refDataPstmt = conn.prepareStatement(refDataSql);
						refDataPstmt.setString(1, checkNullandTrim(rs.getString("REF_ID__INV")));
						refDataRs = refDataPstmt.executeQuery();
						
						if(refDataRs.next())
						{
							refTranType = checkNullandTrim(refDataRs.getString("TRAN_TYPE"));
						}
						if(refDataPstmt != null)
						{
							refDataPstmt.close();
							refDataPstmt = null;
						}
						if(refDataRs != null)
						{
							refDataRs.close();
							refDataRs = null;
						}
						if(refTranType != null && refTranType.trim().length() > 0)
						{
							if("04".equalsIgnoreCase(refTranType) || "05".equalsIgnoreCase(refTranType))
							{
								customerType = "B2CL";
							}
							else if("06".equalsIgnoreCase(refTranType))
							{
								customerType = "EXPWP";
							}
							else if("07".equalsIgnoreCase(refTranType))
							{
								customerType = "EXPWOP";
							}
						}
					}
					cdnur.recType = "1";
					cdnur.customerType = customerType;
					cdnur.cdnNoteType = udfStr2;
					cdnur.cdNoteNumber = checkNullandTrim(rs.getString("DOC_NO"));
					cdnur.cdNoteDate = rs.getDate("DOC_DATE");
					cdnur.invoiceNumber = checkNullandTrim(rs.getString("REF_ID__INV"));
					cdnur.invoiceDate = rs.getDate("REF_DATE__INV");
					cdnur.val = rs.getDouble("AMOUNT");
					//cdnur.reason = checkNullandTrim(rs.getString("REAS_CODE"));
					cdnur.reason = "07-Others";//TODO sending hardcoded reason value, difficult to determine as per GSTN reason list
					if(rs.getDate("REF_DATE__INV").before(gstStartDate))
					{
						cdnur.isPreGSTInvoice = true;
					}
					cdnur.items = invLineItems;
					
					cdnurList.add(cdnur);
				}
				
				tranIdList.add(tranId);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			
			if(isDataFound)
			{
				//NIL data summary
				//tran_type : 15,16,17,18,19,20,21,22,23,24,25,26 = Nil Supplies
				invoices = new ArrayList<Invoice>();
				
				Invoice interB2BNilInv = getNilRateSummary("INTRB2B", "15", "16", "17", siteCode, periodCode, conn);
				Invoice intraB2BNilInv = getNilRateSummary("INTRAB2B", "18", "19", "20", siteCode, periodCode, conn);
				Invoice interB2CNilInv = getNilRateSummary("INTRB2C", "21", "22", "23", siteCode, periodCode, conn);
				Invoice intraB2CNilInv = getNilRateSummary("INTRAB2C", "24", "25", "26", siteCode, periodCode, conn);
				
				if(interB2BNilInv != null)
				{
					invoices.add(interB2BNilInv);
				}
				if(intraB2BNilInv != null)
				{
					invoices.add(intraB2BNilInv);
				}
				if(interB2CNilInv != null)
				{
					invoices.add(interB2CNilInv);
				}
				if(intraB2CNilInv != null)
				{
					invoices.add(intraB2CNilInv);
				}
				
				if(invoices.size() > 0)
				{
					nil = new Nil();
					nil.invoices = invoices;
				}
				
				//HSN summary data will be sent every time
				//Changed by Santosh on 08/09/17 to subtract credit note in HSN summary
				/*sql = " SELECT GDD.GS_CODE, GDD.GS_DESCR, GDD.UNIT, SUM(GDD.QUANTITY) AS TOT_QTY, SUM(GDD.TAXABLE_AMT) AS TOT_TAXVAL,"
					+ " SUM(GDD.IGST_AMT) AS TOT_IAMT, SUM(CGST_AMT) AS TOT_CAMT, SUM(SGST_AMT) AS TOT_SAMT, SUM(CESS_AMT) AS TOT_CSAMT"
					+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD"
					+ " WHERE GDH.TRAN_ID = GDD.TRAN_ID AND GDD.GS_CODE IS NOT NULL AND GDH.REC_TYPE='1'"
					+ " AND GDH.SITE_CODE = ? AND GDH.PRD_CODE = ? AND GDH.TRAN_TYPE NOT IN ('29','31')" 
					+ " GROUP BY GDD.GS_CODE, GDD.GS_DESCR, GDD.UNIT";*/
				
				sql = " SELECT GS_CODE, GS_DESCR, UNIT, SUM(TOT_QTY) AS TOT_QTY, SUM(TOT_TAXVAL) AS TOT_TAXVAL, SUM(TOT_IAMT) AS TOT_IAMT, SUM(TOT_CAMT) AS TOT_CAMT, SUM(TOT_SAMT) AS TOT_SAMT, SUM(TOT_CSAMT) AS TOT_CSAMT FROM"
					+ " (SELECT GDD.GS_CODE, GDD.GS_DESCR, GDD.UNIT, SUM(GDD.QUANTITY) AS TOT_QTY, SUM(GDD.TAXABLE_AMT) AS TOT_TAXVAL,"
					+ " SUM(GDD.IGST_AMT) AS TOT_IAMT, SUM(CGST_AMT) AS TOT_CAMT, SUM(SGST_AMT) AS TOT_SAMT, SUM(CESS_AMT) AS TOT_CSAMT"
					+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD"
					+ " WHERE GDH.TRAN_ID = GDD.TRAN_ID AND GDD.GS_CODE IS NOT NULL AND GDH.REC_TYPE='1'"
					+ " AND GDH.SITE_CODE = ? AND GDH.PRD_CODE = ? AND GDH.TRAN_TYPE NOT IN ('29','31')"
					+ " GROUP BY GDD.GS_CODE, GDD.GS_DESCR, GDD.UNIT"
					+ " UNION ALL"
					+ " SELECT GDD.GS_CODE, GDD.GS_DESCR, GDD.UNIT, -1*SUM(GDD.QUANTITY) AS TOT_QTY, -1*SUM(GDD.TAXABLE_AMT) AS TOT_TAXVAL,"
					+ " -1*SUM(GDD.IGST_AMT) AS TOT_IAMT, -1*SUM(CGST_AMT) AS TOT_CAMT, -1*SUM(SGST_AMT) AS TOT_SAMT, -1*SUM(CESS_AMT) AS TOT_CSAMT"
					+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD"
					+ " WHERE GDH.TRAN_ID = GDD.TRAN_ID AND GDD.GS_CODE IS NOT NULL AND GDH.REC_TYPE='1'"
					+ " AND GDH.SITE_CODE = ? AND GDH.PRD_CODE = ? AND GDH.TRAN_TYPE  IN ('29','31')"
					+ " GROUP BY GDD.GS_CODE, GDD.GS_DESCR, GDD.UNIT) GROUP BY GS_CODE, GS_DESCR, UNIT"	;
				
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, siteCode);
				pstmt.setString(2, periodCode);
				pstmt.setString(3, siteCode);
				pstmt.setString(4, periodCode);
				rs = pstmt.executeQuery();
				
				while (rs.next()) 
				{
					hsnDetails = new HSNDetails();
					
					hsnDetails.num = ++num;
					hsnDetails.itemOrServiceCode = checkNullandTrim(rs.getString("GS_CODE"));
					hsnDetails.description = checkNullandTrim(rs.getString("GS_DESCR"));
					hsnDetails.unitOfMeasure = checkNullandTrim(rs.getString("UNIT"));
					hsnDetails.quantity = rs.getDouble("TOT_QTY");
					hsnDetails.totalAmount = rs.getDouble("TOT_TAXVAL") + rs.getDouble("TOT_IAMT") + rs.getDouble("TOT_CAMT") + rs.getDouble("TOT_SAMT") + rs.getDouble("TOT_CSAMT");
					hsnDetails.totalTaxableAmount = rs.getDouble("TOT_TAXVAL");
					hsnDetails.totalIGSTAmount = rs.getDouble("TOT_IAMT");
					hsnDetails.totalCGSTAmount = rs.getDouble("TOT_CAMT");
					hsnDetails.totalSGSTAmount = rs.getDouble("TOT_SAMT");
					hsnDetails.totalCESSAmount = rs.getDouble("TOT_CSAMT");
					
					hsnList.add(hsnDetails);
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				
				if(hsnList.size() > 0)
				{
					hsn = new HSN();
					hsn.recType = "1";
					hsn.hsnDetails = hsnList;
				}
				
				docsList = new ArrayList<Docs>();

				sql = " SELECT MIN(DOC_NO) FROM_NO, MAX(DOC_NO) TO_NO, COUNT(1) TOT_CNT"
					+ " FROM GST_DATA_HDR WHERE SITE_CODE = ? AND PRD_CODE = ? AND REC_TYPE = ?"
					+ " AND TRAN_TYPE IN ('01','03','04','05','11','12','13','14')";
				
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, siteCode);
				pstmt.setString(2, periodCode);
				pstmt.setString(3, "1");
				
				rs = pstmt.executeQuery();
				
				while(rs.next())
				{
					if(rs.getInt("TOT_CNT") > 0)
					{
						Docs docs = new Docs();
						docs.docNum = 1;
						docs.fromSerialNo = checkNullandTrim(rs.getString("FROM_NO"));
						docs.toSerialNo = checkNullandTrim(rs.getString("TO_NO"));
						docs.totalNo = rs.getInt("TOT_CNT");
						docs.cancelNo = 0;
						docs.toatlNetIssued = rs.getInt("TOT_CNT");
						
						docsList.add(docs);
					}
				}
				closeResources(rs, pstmt);
				
				if(docsList.size() > 0)
				{
					DocDetails docDetails = new DocDetails();
					
					docDetails.serialNumber = 1;
					docDetails.docs = docsList;
					
					docDetailsList.add(docDetails);
				}
				
				docsList = new ArrayList<Docs>();

				sql = " SELECT MIN(DOC_NO) FROM_NO, MAX(DOC_NO) TO_NO, COUNT(1) TOT_CNT"
					+ " FROM GST_DATA_HDR WHERE SITE_CODE = ? AND PRD_CODE = ? AND REC_TYPE = ?"
					+ " AND TRAN_TYPE IN ('02')";
				
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, siteCode);
				pstmt.setString(2, periodCode);
				pstmt.setString(3, "1");
				
				rs = pstmt.executeQuery();
				
				while(rs.next())
				{
					if(rs.getInt("TOT_CNT") > 0)
					{
						Docs docs = new Docs();
						docs.docNum = 1;
						docs.fromSerialNo = checkNullandTrim(rs.getString("FROM_NO"));
						docs.toSerialNo = checkNullandTrim(rs.getString("TO_NO"));
						docs.totalNo = rs.getInt("TOT_CNT");
						docs.cancelNo = 0;
						docs.toatlNetIssued = rs.getInt("TOT_CNT");
						
						docsList.add(docs);
					}
				}
				closeResources(rs, pstmt);
				
				if(docsList.size() > 0)
				{
					DocDetails docDetails = new DocDetails();
					
					docDetails.serialNumber = 2;
					docDetails.docs = docsList;
					
					docDetailsList.add(docDetails);
				}
				
				docsList = new ArrayList<Docs>();
				
				sql = " SELECT MIN(DOC_NO) FROM_NO, MAX(DOC_NO) TO_NO, COUNT(1) TOT_CNT"
					+ " FROM GST_DATA_HDR WHERE SITE_CODE = ? AND PRD_CODE = ? AND REC_TYPE = ?"
					+ " AND TRAN_TYPE IN ('30','32')";
				
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, siteCode);
				pstmt.setString(2, periodCode);
				pstmt.setString(3, "1");
				
				rs = pstmt.executeQuery();
				
				while(rs.next())
				{
					if(rs.getInt("TOT_CNT") > 0)
					{
						Docs docs = new Docs();
						docs.docNum = 1;
						docs.fromSerialNo = checkNullandTrim(rs.getString("FROM_NO"));
						docs.toSerialNo = checkNullandTrim(rs.getString("TO_NO"));
						docs.totalNo = rs.getInt("TOT_CNT");
						docs.cancelNo = 0;
						docs.toatlNetIssued = rs.getInt("TOT_CNT");
						
						docsList.add(docs);
					}
				}
				closeResources(rs, pstmt);
				
				if(docsList.size() > 0)
				{
					DocDetails docDetails = new DocDetails();
					
					docDetails.serialNumber = 4;
					docDetails.docs = docsList;
					
					docDetailsList.add(docDetails);
				}
				
				docsList = new ArrayList<Docs>();
				
				sql = " SELECT MIN(DOC_NO) FROM_NO, MAX(DOC_NO) TO_NO, COUNT(1) TOT_CNT"
					+ " FROM GST_DATA_HDR WHERE SITE_CODE = ? AND PRD_CODE = ? AND REC_TYPE = ?"
					+ " AND TRAN_TYPE IN ('29','31')";
				
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, siteCode);
				pstmt.setString(2, periodCode);
				pstmt.setString(3, "1");
				
				rs = pstmt.executeQuery();
				
				if(rs.next())
				{
					if(rs.getInt("TOT_CNT") > 0)
					{
						Docs docs = new Docs();
						docs.docNum = 1;
						docs.fromSerialNo = checkNullandTrim(rs.getString("FROM_NO"));
						docs.toSerialNo = checkNullandTrim(rs.getString("TO_NO"));
						docs.totalNo = rs.getInt("TOT_CNT");
						docs.cancelNo = 0;
						docs.toatlNetIssued = rs.getInt("TOT_CNT");
						
						docsList.add(docs);
					}
				}
				closeResources(rs, pstmt);
				
				if(docsList.size() > 0)
				{
					DocDetails docDetails = new DocDetails();
					
					docDetails.serialNumber = 5;
					docDetails.docs = docsList;
					
					docDetailsList.add(docDetails);
				}
				
				if(docDetailsList.size() > 0)
				{
					docIssued = new DocIssued();
					docIssued.docDetails = docDetailsList;
				}
				
				gstr1 = new GSTR1();
				gstr1.gstin = gstin;
				gstr1.financialPeriod = periodCode;
				gstr1.grossTurnOver = Double.valueOf(grossTurnover);
				gstr1.currentGrossTurnOver = Double.valueOf(currentYearTurnover);
				
				if(b2bInvoiceList.size() > 0)
				{
					gstr1.b2b = b2bInvoiceList;
				}
				if(b2clInvoiceList.size() > 0)
				{
					gstr1.b2cl = b2clInvoiceList;
				}
				if(b2claInvoiceList.size() > 0)
				{
					gstr1.b2cla = b2claInvoiceList;
				}
				if(b2csInvoiceList.size() > 0)
				{
					gstr1.b2cs = b2csInvoiceList;
				}
				if(b2csaInvoiceList.size() > 0)
				{
					gstr1.b2csa = b2csaInvoiceList;
				}
				if(cdnrList.size() > 0)
				{
					gstr1.cdnr = cdnrList;
				}
				if(cdnraList.size() > 0)
				{
					gstr1.cdnra = cdnraList;
				}
				if(atList.size() > 0)
				{
					gstr1.at = atList;
				}
				if(ataList.size() > 0)
				{
					gstr1.ata = ataList;
				}
				if(expInvoiceList.size() > 0)
				{
					gstr1.exp = expInvoiceList;
				}
				if(atPaidList.size() > 0)
				{
					gstr1.txpd = atPaidList;
				}
				if(cdnurList.size() > 0)
				{
					gstr1.cdnur = cdnurList;
				}
				if(nil != null)
				{
					gstr1.nil = nil;
				}
				if(hsn != null)
				{
					gstr1.hsn = hsn;
				}
				if(docIssued != null)
				{
					gstr1.docIssued = docIssued;
				}
			
				ObjectMapper objectMapper = new ObjectMapper();
				
				String json = objectMapper.writeValueAsString(gstr1);
				
				System.out.println("jsonPayload to SAVE GSTR1["+json+"]");
				
				Date payloadEndTime = new Date();
				
				long payloadDiff = payloadEndTime.getTime() - payloadStartTime.getTime();

				long payloadDiffSeconds = payloadDiff / 1000 % 60;
				long payloadDiffMinutes = payloadDiff / (60 * 1000) % 60;
				long payloadDiffHours = payloadDiff / (60 * 60 * 1000);
				
				System.out.println("DIFFERANCE IN TIME FOR PAYLOAD CREATION GSTR1 IN HH:MM:SS ["+payloadDiffHours +":"+payloadDiffMinutes+":"+payloadDiffSeconds+"]");
				
				retString = saveGSTRData(json, noOfRecords, tranIdList, "1", conn, xtraParams);
			}
		}
		catch (Exception e) 
		{
			System.out.println("GSTDataSubmitWizPos.saveGstr1()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}
	private String createDeleteGstr1Json(String siteCode, String grossTurnover, String currentYearTurnover, String xtraParams, Connection conn) throws ITMException
	{
		String retString = "";
		int noOfRecords = 0;
		
		boolean isDataFound = false;
		
		String udfStr1 = "", udfStr2 = "", udfStr3 = "";
		String sql = "", lineSql = "", refDataSql = "";
		PreparedStatement pstmt = null, linePstmt = null, refDataPstmt = null;
		ResultSet rs = null, lineRs = null, refDataRs = null;
		
		String tranId = "", tranType = "", tranIdRef = "", ctin = "", posStateCode = "";
		
		ArrayList<String> tranIdList = new ArrayList<String>();
		
		Map<String, ArrayList<Invoice>> invoicesHMap = new HashMap<String, ArrayList<Invoice>>();
		Map<String, Object> invTypObjHMap = new HashMap<String, Object>();
		ArrayList<B2B> b2bInvoiceList = new ArrayList<B2B>();
		ArrayList<B2CL> b2clInvoiceList = new ArrayList<B2CL>();
		ArrayList<B2CLA> b2claInvoiceList = new ArrayList<B2CLA>();
		ArrayList<B2CS> b2csInvoiceList = new ArrayList<B2CS>();
		ArrayList<B2CSA> b2csaInvoiceList = new ArrayList<B2CSA>();
		ArrayList<CDNR> cdnrList = new ArrayList<CDNR>();
		ArrayList<CDNRA> cdnraList = new ArrayList<CDNRA>();
		ArrayList<AT> atList = new ArrayList<AT>();
		ArrayList<ATA> ataList = new ArrayList<ATA>();
		ArrayList<EXP> expInvoiceList = new ArrayList<EXP>();
		ArrayList<AT> atPaidList = new ArrayList<AT>();
		ArrayList<CDNUR> cdnurList = new ArrayList<CDNUR>();

		ArrayList<InvLineItem> invLineItems = null;
		ArrayList<Invoice> invoices = null;
		ArrayList<CDNDetails> cdnDetailsList = null;
		
		GSTR1 gstr1 = null;
		Invoice invoice = null;
		InvLineItem invLineItem = null;
		B2B b2b = null;
		B2CL b2cl = null;
		B2CS b2cs = null;
		CDNR cdnr = null;
		CDNDetails cdnDetails = null;
		AT at = null;
		EXP exp = null;
		CDNUR cdnur = null;
		Nil nil = null;
		
		try
		{
			sql = "SELECT * FROM GST_DATA_HDR WHERE PRD_CODE = ? AND SITE_CODE = ? AND SUBMIT_STATUS = 'T' AND REC_TYPE ='1'";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, periodCode);
			pstmt.setString(2, siteCode);
			rs = pstmt.executeQuery();

			while(rs.next())
			{
				++noOfRecords;
				isDataFound = true;
				tranId = checkNullandTrim(rs.getString("TRAN_ID"));
				tranType = checkNullandTrim(rs.getString("TRAN_TYPE"));
				ctin = checkNullandTrim(rs.getString("TAX_REG_NO"));
				posStateCode = checkNullandTrim(rs.getString("GST_CODE"));
				tranIdRef = checkNullandTrim(rs.getString("TRAN_ID__REF"));
				
				System.out.println("in deleteGstr1 tranId["+tranId+"] tranType["+tranType+"] ctin["+ctin+"] posStateCode["+posStateCode+"] tranIdRef["+tranIdRef+"]");
				
				invoices = new ArrayList<Invoice>();
				invoice = new Invoice();
				invLineItems = new ArrayList<InvLineItem>();
				cdnDetailsList = new ArrayList<CDNDetails>();
				
				lineSql = "SELECT UDF_STR1, UDF_STR2, UDF_STR3 FROM GENCODES WHERE MOD_NAME='W_GSTR' AND FLD_NAME='TRAN_TYPE' AND FLD_VALUE = ? ";
				linePstmt = conn.prepareStatement(lineSql);
				linePstmt.setString(1, tranType);
				
				lineRs = linePstmt.executeQuery();
				
				if(lineRs.next())
				{
					udfStr1 = checkNullandTrim(lineRs.getString("UDF_STR1"));
					udfStr2 = checkNullandTrim(lineRs.getString("UDF_STR2"));
					udfStr3 = checkNullandTrim(lineRs.getString("UDF_STR3"));
				}
				if(linePstmt!=null)
				{
					linePstmt.close();
					linePstmt=null;
				}
				if(lineRs!=null)
				{
					lineRs.close();
					lineRs=null;
				}
				
				if(invoicesHMap.containsKey(ctin+"~"+udfStr1))
				{
					invoices = invoicesHMap.get(ctin+"~"+udfStr1);
				}
				
				//tran_type : 01,02,03,08,09,10 = B2B invoices
				if("B2B".equalsIgnoreCase(udfStr1))
				{
					invoice.inum = rs.getString("DOC_NO");
					invoice.idt = rs.getDate("DOC_DATE");
					invoice.taxPayerAction = "D";
					
					invoices.add(invoice);
					
					invoicesHMap.put(ctin+"~"+udfStr1, invoices);
					
					if("B2B".equalsIgnoreCase(udfStr1))
					{
						b2b = new B2B();
						if(invTypObjHMap.containsKey(ctin+"~"+udfStr1))
						{
							b2b = (B2B)invTypObjHMap.get(ctin+"~"+udfStr1);
							if(b2bInvoiceList.contains(b2b))
							{
								int index = b2bInvoiceList.indexOf(b2b);
								b2bInvoiceList.remove(index);
							}
						}
						b2b.ctin = ctin;
						b2b.isReverseCharge = true;
						b2b.invoices = invoices;
						
						invTypObjHMap.put(ctin+"~"+udfStr1, b2b);
						b2bInvoiceList.add(b2b);
					}
				}
				//tran_type : 04, 05 = B2CL invoices
				if("B2CL".equalsIgnoreCase(udfStr1))
				{
					invoices = new ArrayList<Invoice>();
					invoice = new Invoice();
					invLineItems = new ArrayList<InvLineItem>();
					
					invoice.inum = checkNullandTrim(rs.getString("DOC_NO"));
					invoice.idt = rs.getDate("DOC_DATE");
					invoice.taxPayerAction = "D";
					
					invoices.add(invoice);
					
					if("B2CL".equalsIgnoreCase(udfStr1))
					{
						b2cl = new B2CL();
						b2cl.isReverseCharge = false;
						b2cl.stateCode = posStateCode;
						b2cl.invoices = invoices;
						
						b2clInvoiceList.add(b2cl);
					}
				}
				//tran_type : 11,12,13,14 = B2CS invoices, 37,38,39,40 = B2CSA invoices
				if("B2CS".equalsIgnoreCase(udfStr1) || "B2CSA".equalsIgnoreCase(udfStr1))
				{
					
					lineSql = "SELECT * FROM GST_DATA_DET WHERE TRAN_ID = ? ORDER BY LINE_NO ";
					linePstmt = conn.prepareStatement(lineSql);
					linePstmt.setString(1, tranId);
					lineRs = linePstmt.executeQuery();
					
					while(lineRs.next())
					{
						if("B2CS".equalsIgnoreCase(udfStr1))
						{
							b2cs = new B2CS();
							
							b2cs.supplyType = udfStr2;
							b2cs.typ = udfStr3;
							b2cs.pos = posStateCode;
							b2cs.rate = lineRs.getDouble("GST_RATE");
							b2cs.taxPayerAction = "D";
							
							b2csInvoiceList.add(b2cs);
						}
					}
					if(linePstmt != null)
					{
						linePstmt.close();
						linePstmt = null;
					}
					if(lineRs != null)
					{
						lineRs.close();
						lineRs = null;
					}
				}
				//tran_type : 29,30 = CDNR, 33,34 = CDNRA
				if("CDNR".equalsIgnoreCase(udfStr1) || "CDNRA".equalsIgnoreCase(udfStr1))
				{
					if("CDNR".equalsIgnoreCase(udfStr1))
					{
						lineSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(IGST_AMT) AS IGST_AMT, SUM(CGST_AMT) AS CGST_AMT, SUM(SGST_AMT) AS SGST_AMT, SUM(CESS_AMT) AS CESS_AMT "
								+ " FROM GST_DATA_DET "
								+ " WHERE TRAN_ID = ? "
								+ " GROUP BY GST_RATE";
						linePstmt = conn.prepareStatement(lineSql);
						linePstmt.setString(1, tranId);
						lineRs = linePstmt.executeQuery();
						int lineNum = 0;
						while(lineRs.next())
						{
							invLineItem = new InvLineItem();
							invLineItem.num = ++lineNum;
							invLineItem.rate = lineRs.getDouble("GST_RATE");
							invLineItem.taxval = lineRs.getDouble("TAXABLE_AMT");
							invLineItem.iamt = lineRs.getDouble("IGST_AMT");
							invLineItem.camt = lineRs.getDouble("CGST_AMT");
							invLineItem.samt = lineRs.getDouble("SGST_AMT");
							invLineItem.csamt = lineRs.getDouble("CESS_AMT");
							
							invLineItems.add(invLineItem);
						}
						if(linePstmt != null)
						{
							linePstmt.close();
							linePstmt = null;
						}
						if(lineRs != null)
						{
							lineRs.close();
							lineRs = null;
						}
						
						cdnDetails = new CDNDetails();
						
						cdnDetails.cdNoteNumber = checkNullandTrim(rs.getString("DOC_NO"));
						cdnDetails.cdNoteDate = rs.getDate("DOC_DATE");
						cdnDetails.taxPayerAction = "D";
						
						cdnDetailsList.add(cdnDetails);
						
						cdnr = new CDNR();
						cdnr.isReverseCharge = false;
						
						cdnr.ctin = ctin;
						cdnr.cdnDetails = cdnDetailsList;
						
						cdnrList.add(cdnr);
					}
				}
				//tran_type : 06,07 = Exports and tran_type : 27,28 = Exports amendments
				if("EXP".equalsIgnoreCase(udfStr1) || "EXPA".equalsIgnoreCase(udfStr1))
				{
					invoices = new ArrayList<Invoice>();
					invoice = new Invoice();
					invLineItems = new ArrayList<InvLineItem>();
					
					if("EXP".equalsIgnoreCase(udfStr1))
					{
						invoice.inum = rs.getString("DOC_NO");
						invoice.idt = rs.getDate("DOC_DATE");
						invoice.taxPayerAction = "D";
						
						invoices.add(invoice);
						
						exp = new EXP();
						exp.isReverseCharge = false;
						exp.exportType = udfStr2;
						exp.invoices = invoices;
						
						expInvoiceList.add(exp);
					}
				}
				//tran_type : 41,42 = Advance Tax and tran_type : 45,46 = Adv. Tax amendments
				if("AT".equalsIgnoreCase(udfStr1) || "ATA".equalsIgnoreCase(udfStr1))
				{
					invLineItems = new ArrayList<InvLineItem>();
					
					if("AT".equalsIgnoreCase(udfStr1))
					{
						at = new AT();
						at.isReverseCharge = false;
						at.recType = "1";
						
						at.pos = posStateCode;
						at.supplyType = udfStr2;
						at.taxPayerAction = "D";
						
						atList.add(at);
					}
				}
				//tran_type : 43,44 = Advance Tax paid and tran_type : 47,48 Advance Tax paid amendments
				if("TXP".equalsIgnoreCase(udfStr1))
				{
					at = new AT();
					at.isReverseCharge = false;
					at.recType = "1";
					
					at.pos = posStateCode;
					at.supplyType = udfStr2;
					at.taxPayerAction = "D";
					
					atPaidList.add(at);
				}
				//tran_type : 31,32 = CDNUR and tran_type : 35,36 = CDNURA
				if("CDNUR".equalsIgnoreCase(udfStr1))
				{
					String customerType = "", refTranType = "";
					Calendar calendar = Calendar.getInstance();
					calendar.set(2017, 06, 01);
					Date gstStartDate = calendar.getTime();
					
					cdnur = new CDNUR();
					cdnur.isReverseCharge = false;
					if(rs.getDate("REF_DATE__INV").after(gstStartDate))
					{
						refDataSql = "SELECT TRAN_TYPE FROM GST_DATA_HDR WHERE DOC_NO = ? ";
						refDataPstmt = conn.prepareStatement(refDataSql);
						refDataPstmt.setString(1, checkNullandTrim(rs.getString("REF_ID__INV")));
						refDataRs = refDataPstmt.executeQuery();
						
						if(refDataRs.next())
						{
							refTranType = checkNullandTrim(refDataRs.getString("TRAN_TYPE"));
						}
						if(refDataPstmt != null)
						{
							refDataPstmt.close();
							refDataPstmt = null;
						}
						if(refDataRs != null)
						{
							refDataRs.close();
							refDataRs = null;
						}
						if(refTranType != null && refTranType.trim().length() > 0)
						{
							if("04".equalsIgnoreCase(refTranType) || "05".equalsIgnoreCase(refTranType))
							{
								customerType = "B2CL";
							}
							else if("06".equalsIgnoreCase(refTranType))
							{
								customerType = "EXPWP";
							}
							else if("07".equalsIgnoreCase(refTranType))
							{
								customerType = "EXPWOP";
							}
						}
					}
					cdnur.recType = "1";
					cdnur.customerType = customerType;
					cdnur.cdNoteNumber = checkNullandTrim(rs.getString("DOC_NO"));
					cdnur.cdNoteDate = rs.getDate("DOC_DATE");
					cdnur.taxPayerAction = "D";
					
					cdnurList.add(cdnur);
				}
				
				tranIdList.add(tranId);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			
			if(isDataFound)
			{
				int nilDataCnt = 0;
				
				sql = " SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = ? AND PRD_CODE = ? AND SITE_CODE = ?"
					+ " AND TRAN_TYPE IN ('15','16','17','18','19','20','21','22','23','24','25','26')";
				
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, "1");
				pstmt.setString(2, "T");
				pstmt.setString(3, periodCode);
				pstmt.setString(4, siteCode);
				rs = pstmt.executeQuery();
				
				if(rs.next())
				{
					nilDataCnt = rs.getInt("CNT");
					System.out.println("nilDataCnt["+nilDataCnt+"]");
					if(nilDataCnt > 0)
					{
						nil = new Nil();
						nil.taxPayerAction = "D";
					}
				}
				closeResources(rs, pstmt);
				
				gstr1 = new GSTR1();
				gstr1.gstin = gstin;
				gstr1.financialPeriod = periodCode;
				gstr1.grossTurnOver = Double.valueOf(grossTurnover);
				gstr1.currentGrossTurnOver = Double.valueOf(currentYearTurnover);
				
				if(b2bInvoiceList.size() > 0)
				{
					gstr1.b2b = b2bInvoiceList;
				}
				if(b2clInvoiceList.size() > 0)
				{
					gstr1.b2cl = b2clInvoiceList;
				}
				if(b2claInvoiceList.size() > 0)
				{
					gstr1.b2cla = b2claInvoiceList;
				}
				if(b2csInvoiceList.size() > 0)
				{
					gstr1.b2cs = b2csInvoiceList;
				}
				if(b2csaInvoiceList.size() > 0)
				{
					gstr1.b2csa = b2csaInvoiceList;
				}
				if(cdnrList.size() > 0)
				{
					gstr1.cdnr = cdnrList;
				}
				if(cdnraList.size() > 0)
				{
					gstr1.cdnra = cdnraList;
				}
				if(atList.size() > 0)
				{
					gstr1.at = atList;
				}
				if(ataList.size() > 0)
				{
					gstr1.ata = ataList;
				}
				if(expInvoiceList.size() > 0)
				{
					gstr1.exp = expInvoiceList;
				}
				if(atPaidList.size() > 0)
				{
					gstr1.txpd = atPaidList;
				}
				if(cdnurList.size() > 0)
				{
					gstr1.cdnur = cdnurList;
				}
				if(nil != null)
				{
					gstr1.nil = nil;
				}
			
				ObjectMapper objectMapper = new ObjectMapper();
				
				String json = objectMapper.writeValueAsString(gstr1);
				
				System.out.println("jsonPayload to DELETE GSTR1["+json+"]");
				
				retString = deleteDataFromGSTN(json, noOfRecords, tranIdList, "1", xtraParams, conn);
			}
		}
		catch (Exception e) 
		{
			System.out.println("GSTDataSubmitWizPos.createDeleteGstr1Json()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}
	private String createDeleteGstr2Json(String siteCode, String xtraParams, Connection conn) throws ITMException
	{
		String retString = "";
		int noOfRecords = 0;
		
		boolean isDataFound = false;
		
		String udfStr1 = "", udfStr2 = "", udfStr3 = "";
		String sql = "", lineSql = "";
		PreparedStatement pstmt = null, linePstmt = null;
		ResultSet rs = null, lineRs = null;
		
		String tranId = "", tranType = "", tranIdRef = "", ctin = "", posStateCode = "";

		ArrayList<String> tranIdList = new ArrayList<String>();
		
		Map<String, ArrayList<Invoice>> invoicesHMap = new HashMap<String, ArrayList<Invoice>>();
		Map<String, Object> invTypObjHMap = new HashMap<String, Object>();
		ArrayList<B2B> b2bInvoiceList = new ArrayList<B2B>();
		ArrayList<B2BUR> b2burInvoiceList = new ArrayList<B2BUR>();
		ArrayList<CDNR> cdnrList = new ArrayList<CDNR>();
		ArrayList<IMPG> impgList = new ArrayList<IMPG>();
		ArrayList<IMPS> impsList = new ArrayList<IMPS>();
		ArrayList<AT> txiList = new ArrayList<AT>();
		ArrayList<AT> txpdList = new ArrayList<AT>();
		ArrayList<CDNUR> cdnurList = new ArrayList<CDNUR>();
		
		ArrayList<Invoice> invoices = null;
		ArrayList<CDNDetails> cdnDetailsList = null;
		
		GSTR2 gstr2 = null;
		Invoice invoice = null;
		B2B b2b = null;
		B2BUR b2bur = null;
		CDNR cdnr = null;
		CDNDetails cdnDetails = null;
		IMPG impg = null;
		IMPS imps = null;
		AT at = null;
		CDNUR cdnur = null;
		NilInwardSupplies nilInwardSupplies = null;
		
		try
		{
			sql = "SELECT * FROM GST_DATA_HDR WHERE PRD_CODE = ? AND SITE_CODE = ? AND SUBMIT_STATUS = 'T' AND REC_TYPE ='2'";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, periodCode);
			pstmt.setString(2, siteCode);
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				++noOfRecords;
				isDataFound = true;
				tranId = checkNullandTrim(rs.getString("TRAN_ID"));
				tranType = checkNullandTrim(rs.getString("TRAN_TYPE"));
				ctin = checkNullandTrim(rs.getString("TAX_REG_NO"));
				posStateCode = checkNullandTrim(rs.getString("GST_CODE"));
				tranIdRef = checkNullandTrim(rs.getString("TRAN_ID__REF"));
				
				System.out.println("in deleteGstr2 tranId["+tranId+"] tranType["+tranType+"] ctin["+ctin+"] posStateCode["+posStateCode+"] tranIdRef["+tranIdRef+"]");
				
				invoices = new ArrayList<Invoice>();
				invoice = new Invoice();
				cdnDetailsList = new ArrayList<CDNDetails>();
				
				lineSql = "SELECT UDF_STR1, UDF_STR2, UDF_STR3 FROM GENCODES WHERE MOD_NAME = 'W_GSTR_PURC' AND FLD_NAME = 'TRAN_TYPE' AND FLD_VALUE = ? ";
				linePstmt = conn.prepareStatement(lineSql);
				linePstmt.setString(1, tranType);
				
				lineRs = linePstmt.executeQuery();
				
				if(lineRs.next())
				{
					udfStr1 = checkNullandTrim(lineRs.getString("UDF_STR1"));
					udfStr2 = checkNullandTrim(lineRs.getString("UDF_STR2"));
					udfStr3 = checkNullandTrim(lineRs.getString("UDF_STR3"));
					
					System.out.println("udfStr1["+udfStr1+"] udfStr2["+udfStr2+"] udfStr3["+udfStr3+"]");
				}
				if(linePstmt!=null)
				{
					linePstmt.close();
					linePstmt=null;
				}
				if(lineRs!=null)
				{
					lineRs.close();
					lineRs=null;
				}
				
				if(invoicesHMap.containsKey(ctin+"~"+udfStr1))
				{
					invoices = invoicesHMap.get(ctin+"~"+udfStr1);
				}
				
				//tran_type : 01 = B2B invoices
				if("B2B".equalsIgnoreCase(udfStr1))
				{
					invoice.inum = rs.getString("DOC_NO");
					invoice.idt = rs.getDate("DOC_DATE");
					invoice.taxPayerAction = "D";
					
					invoices.add(invoice);
					
					invoicesHMap.put(ctin+"~"+udfStr1, invoices);
					
					if("B2B".equalsIgnoreCase(udfStr1))
					{
						b2b = new B2B();
						if(invTypObjHMap.containsKey(ctin+"~"+udfStr1))
						{
							b2b = (B2B)invTypObjHMap.get(ctin+"~"+udfStr1);
							if(b2bInvoiceList.contains(b2b))
							{
								int index = b2bInvoiceList.indexOf(b2b);
								b2bInvoiceList.remove(index);
							}
						}
						b2b.ctin = ctin;
						b2b.isReverseCharge = true;
						b2b.invoices = invoices;
						
						invTypObjHMap.put(ctin+"~"+udfStr1, b2b);
						b2bInvoiceList.add(b2b);
					}
				}
				if("B2BUR".equalsIgnoreCase(udfStr1))
				{
					invoice.inum = rs.getString("DOC_NO");
					invoice.idt = rs.getDate("DOC_DATE");
					invoice.taxPayerAction = "D";
					invoices.add(invoice);
					
					if("B2BUR".equalsIgnoreCase(udfStr1))
					{
						b2bur = new B2BUR();
						b2bur.invoices = invoices;
						b2burInvoiceList.add(b2bur);
					}
				}
				if("CDN".equalsIgnoreCase(udfStr1))
				{
					if("CDN".equalsIgnoreCase(udfStr1))
					{
						cdnDetails = new CDNDetails();
						
						cdnDetails.taxPayerAction =  "D";
						cdnDetails.cdNoteNumber = checkNullandTrim(rs.getString("DOC_NO"));
						cdnDetails.cdNoteDate = rs.getDate("DOC_DATE");
						
						cdnDetailsList.add(cdnDetails);
						
						cdnr = new CDNR();
						cdnr.isReverseCharge = false;
						cdnr.ctin = ctin;
						cdnr.cdnDetails = cdnDetailsList;
						
						cdnrList.add(cdnr);
					}
				}
				if("IMP_G".equalsIgnoreCase(udfStr1))
				{
					impg = new IMPG();
					impg.taxPayerAction = "D";
					impg.billOfEntryNo = checkNullandTrim(rs.getString("LR_NO"));
					impg.billOfEntryDate = rs.getDate("LR_DATE");
					
					impgList.add(impg);
				}
				if("IMP_S".equalsIgnoreCase(udfStr1))
				{
					imps = new IMPS();
					imps.taxPayerAction = "D";
					imps.inum = checkNullandTrim(rs.getString("DOC_NO"));
					imps.idt = rs.getDate("DOC_DATE");
					
					impsList.add(imps);
				}
				if("TXPI".equalsIgnoreCase(udfStr1))
				{
					at = new AT();
					at.isReverseCharge = false;
					at.recType = "2";
					
					at.taxPayerAction = "D";
					at.pos = checkNullandTrim(rs.getString("GST_CODE"));
					at.supplyType = udfStr2;
					
					txiList.add(at);
				}
				if("TXPD".equalsIgnoreCase(udfStr1))
				{
					
					at = new AT();
					at.isReverseCharge = false;
					at.recType = "2";
					
					at.taxPayerAction = "D";
					at.pos = checkNullandTrim(rs.getString("GST_CODE"));
					at.supplyType = udfStr2;
					
					txpdList.add(at);
				}
				if("CDNUR".equalsIgnoreCase(udfStr1))
				{
					cdnur = new CDNUR();
					cdnur.isReverseCharge = false;
					cdnur.recType = "2";
					
					cdnur.taxPayerAction = "D";
					cdnur.cdNoteNumber = checkNullandTrim(rs.getString("DOC_NO"));
					cdnur.cdNoteDate = rs.getDate("DOC_DATE");
					
					cdnurList.add(cdnur);
				}
				
				tranIdList.add(tranId);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			
			if(isDataFound)
			{
				int nilDataCnt = 0;
				
				sql = " SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = ? AND PRD_CODE = ? AND SITE_CODE = ?"
					+ " AND TRAN_TYPE IN ('18','19','20','21','22','23','24','25')";
				
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, "2");
				pstmt.setString(2, "T");
				pstmt.setString(3, periodCode);
				pstmt.setString(4, siteCode);
				rs = pstmt.executeQuery();
				
				if(rs.next())
				{
					nilDataCnt = rs.getInt("CNT");
					System.out.println("nilDataCnt["+nilDataCnt+"]");
					if(nilDataCnt > 0)
					{
						nilInwardSupplies = new NilInwardSupplies();
						nilInwardSupplies.taxPayerAction = "D";
					}
				}
				closeResources(rs, pstmt);
				
				gstr2 = new GSTR2();
				gstr2.gstin = gstin;
				gstr2.financialPeriod = periodCode;
				
				if(b2bInvoiceList.size() > 0)
				{
					gstr2.b2b = b2bInvoiceList;
				}
				if(b2burInvoiceList.size() > 0)
				{
					gstr2.b2bur = b2burInvoiceList;
				}
				if(cdnrList.size() > 0)
				{
					gstr2.cdnr = cdnrList;
				}
				if(impgList.size() > 0)
				{
					gstr2.impg = impgList;
				}
				if(impsList.size()>0)
				{
					gstr2.imps = impsList;
				}
				if(nilInwardSupplies != null)
				{
					gstr2.nil = nilInwardSupplies;
				}
				if(txiList.size()>0)
				{
					gstr2.txi = txiList;
				}
				if(txpdList.size()>0)
				{
					gstr2.txpd = txpdList;
				}
				if(cdnurList.size()>0)
				{
					gstr2.cdnur = cdnurList;
				}
				
				ObjectMapper objectMapper = new ObjectMapper();
				
				String json = objectMapper.writeValueAsString(gstr2);
				
				System.out.println("jsonPayload to delete GSTR2["+json+"]");
				
				retString = deleteDataFromGSTN(json, noOfRecords, tranIdList, "2", xtraParams, conn);
			}
			
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.createDeleteGstr2Json()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException (e);
		}
		
		return retString;
	}
	private String submitGstr(String recType, String xtraParams,Connection conn) throws ITMException
	{
		String retString = "", RETURN_URL = "";
		String errMsg = "", gspAuthString = "", gspAuthSignature = "";
		String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
		String loginCode = "", chgTerm = "", siteCode = "", callStatus = "", responseJsonStr = "", responseId = "";
		
		try
		{
			if("1".equalsIgnoreCase(recType))
			{
				RETURN_URL = GSTR1_URL;
			}
			else if("2".equalsIgnoreCase(recType))
			{
				RETURN_URL = GSTR2_URL;
			}
			else if("3".equalsIgnoreCase(recType))
			{
				RETURN_URL = GSTR3_URL;
			}
			else if("6".equalsIgnoreCase(recType))
			{
				RETURN_URL = GSTR3B_URL;
			}
			
			siteCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			
			String json = "{\"gstin\":\""+gstin+"\",\"ret_period\":\""+periodCode+"\"}";
            
            byte[] jsonBase64 = Base64.getEncoder().encode(json.getBytes());
			String encryptedPayload = aesEncryption.encryptEK(jsonBase64, authSEK);
			 
			HMac hmac = new HMac(new SHA256Digest());
			byte[] resBuf = new byte[hmac.getMacSize()];
			
			hmac.init(new KeyParameter(authSEK));
			hmac.update(jsonBase64, 0, jsonBase64.length);
			hmac.doFinal(resBuf, 0);
            
			JSONObject reqBody = new JSONObject();
            reqBody.put("action", "RETSUBMIT");
            reqBody.put("data", encryptedPayload);
            reqBody.put("hmac", new String(Base64.getEncoder().encode(resBuf)));
            
            long timeStamp = new Timestamp().getDateTime();
	        gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin;
			gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
			
            HttpRequest gstrSubmitReq = Unirest.post(String.format("%s%s", BASE_API_URL, RETURN_URL))
										.header("Content-Type", APPLICATION_JSON)
										.header("action", "RETSUBMIT")
				                        .header("state-cd", stateCode)
				                        .header("clientid", clientId)
				                        .header("client-secret", clientSecret)
				                        .header("ip-usr", ipAddress)
				                        .header("username", userName)
				                        .header("auth-token", authToken)
				                        .header("txn", transactionId)
				                        .header("ret_period", periodCode)
				                        .header("gstin", gstin)
				                        .header("X-Asp-Auth-Token", gspAuthString)
				                        .header("X-Asp-Auth-Signature", gspAuthSignature)
				                        .body(new JsonNode(reqBody.toString()))
				                        .getHttpRequest();
            
            System.out.println("RETSUBMIT GSTR"+recType+" url["+gstrSubmitReq.getUrl()+"]");
			System.out.println("RETSUBMIT GSTR"+recType+" method["+gstrSubmitReq.getHttpMethod()+"]");
			System.out.println("RETSUBMIT GSTR"+recType+" request header["+gstrSubmitReq.getHeaders()+"]");
			System.out.println("RETSUBMIT GSTR"+recType+" request payload["+IOUtils.toString(gstrSubmitReq.getBody().getEntity().getContent())+"]");
            
            HttpResponse<JsonNode> gstrSubmitResp = gstrSubmitReq.asJson();
            
            System.out.println(String.format("gstrSubmitResp Request : Status[%s] Response[%s]", gstrSubmitResp.getStatus(), gstrSubmitResp.getBody()));
            
            if (gstrSubmitResp.getStatus() == 200) 
	        {
				JSONObject gstrSubmitRespObj = gstrSubmitResp.getBody().getObject();
				if(gstrSubmitRespObj.has("data") && gstrSubmitRespObj.has("rek"))
				{
					callStatus = "1";
					String gstrSubmitdata = gstrSubmitRespObj.getString("data");
					String gstrSubmitrek = gstrSubmitRespObj.getString("rek");
					
					byte[] apiEK = aesEncryption.decrypt(gstrSubmitrek, authSEK);
					String respJsoninBase64 = new String(aesEncryption.decrypt(gstrSubmitdata, apiEK));
					
					byte[] respJsonInBytes = aesEncryption.decodeBase64StringTOByte(respJsoninBase64);
					
					JSONObject gstrSubmitObj = new JSONObject(new String(respJsonInBytes));
					String transId = gstrSubmitObj.getString("reference_id");
					responseId = transId;
					System.out.println("transId to getStatus after SUBMIT call["+transId+"]");
					
					retString = getSaveSubmitStatus(transId, null ,recType, "S", xtraParams, conn);
				}
				else
	            {
					callStatus = "2";
					JSONObject errorJSON = gstrSubmitResp.getBody().getObject().getJSONObject("error");
					responseJsonStr = errorJSON.toString();
		        	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
		        	retString = getError(errMsg, "GSTAPIERR", conn);
	            }
	        }
            else if(gstrSubmitResp.getStatus() == 500)
	        {
	        	callStatus = "2";
	        	errMsg = "Message : Error occurred at GSTN server \nResponse code : "+gstrSubmitResp.getStatus();
	        	responseJsonStr = errMsg;
	        	retString = getError(errMsg, "GSTAPIERR", conn);
	        }
			else
            {
				callStatus = "2";
            	JSONObject errorJSON = gstrSubmitResp.getBody().getObject().getJSONObject("error");
            	responseJsonStr = errorJSON.toString();
            	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
	        	retString = getError(errMsg, "GSTAPIERR", conn);
            }
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.submitGstr()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			APICallData apiCallData = new APICallData();
	        apiCallData.setPeriodCode(periodCode);
	        apiCallData.setCallDate(new Date());
	        apiCallData.setSiteCode(siteCode);
	        apiCallData.setUserId(loginCode);
	        apiCallData.setCallType("RETSUBMIT");
	        apiCallData.setRecType(recType);
	        apiCallData.setNoOfRecords(0);
	        apiCallData.setCallStatus(callStatus);
	        apiCallData.setResponseId(responseId);
	        apiCallData.setResponseJsonStr(responseJsonStr);
	        apiCallData.setChgUser(loginCode);
	        apiCallData.setChgDate(new Date());
	        apiCallData.setChgTerm(chgTerm);
	        
	        gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
		}
		return retString;
	}
	private String fileGstr(String recType, String summaryData, String signedData, String panNo, String aadhaarNo, String signMethod, String xtraParams, Connection conn) throws ITMException
	{
		String retString = "", RETURN_URL = "";
		String errMsg = "", gspAuthString = "", gspAuthSignature = "", signType = "",signId = "";
		String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
		String loginCode = "", chgTerm = "", siteCode = "", callStatus = "", responseJsonStr = "", responseId = "";
		
		try
		{
			if("1".equalsIgnoreCase(recType))
			{
				RETURN_URL = GSTR1_URL;
			}
			else if("2".equalsIgnoreCase(recType))
			{
				RETURN_URL = GSTR2_URL;
			}
			else if("3".equalsIgnoreCase(recType))
			{
				RETURN_URL = GSTR3_URL;
			}
			else if("6".equalsIgnoreCase(recType))
			{
				RETURN_URL = GSTR3B_URL;
			}
			
			siteCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			
			long timeStamp = new Timestamp().getDateTime();
	        gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin;
			gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
			
			byte[] jsonBase64 = Base64.getEncoder().encode(summaryData.toString().getBytes());
			String encryptedPayload = aesEncryption.encryptEK(jsonBase64, authSEK);
			
			if("D".equalsIgnoreCase(signMethod))
			{
				signType = "DSC";
				signId = panNo;
			}
			else if("E".equalsIgnoreCase(signMethod))
			{
				signType = "ESIGN";
				signId = aadhaarNo;
			}
			
			JSONObject fileGstrDataJsonObj = new JSONObject();
			fileGstrDataJsonObj.put("action", "RETFILE");
			fileGstrDataJsonObj.put("data", encryptedPayload);
			fileGstrDataJsonObj.put("sign", signedData);
			fileGstrDataJsonObj.put("st", signType);
			fileGstrDataJsonObj.put("sid", signId);
			
			HttpRequest fileGstrReq = Unirest.post(String.format("%s%s", BASE_API_URL, RETURN_URL))
									  .header("Content-Type", APPLICATION_JSON)
									  .header("state-cd", stateCode)
									  .header("clientid", clientId)
									  .header("client-secret", clientSecret)
									  .header("ip-usr", ipAddress)
									  .header("username", userName)
									  .header("auth-token", authToken)
									  .header("txn", transactionId)
									  .header("ret_period", periodCode)
									  .header("gstin", gstin)
									  .header("X-Asp-Auth-Token", gspAuthString)
									  .header("X-Asp-Auth-Signature", gspAuthSignature)
									  .body(new JsonNode(fileGstrDataJsonObj.toString()))
									  .getHttpRequest();
			
			System.out.println("FILE GSTR"+recType+" url["+fileGstrReq.getUrl()+"]");
			System.out.println("FILE GSTR"+recType+" method["+fileGstrReq.getHttpMethod()+"]");
			System.out.println("FILE GSTR"+recType+" request header["+fileGstrReq.getHeaders()+"]");
			System.out.println("FILE GSTR"+recType+" request payload["+IOUtils.toString(fileGstrReq.getBody().getEntity().getContent())+"]");
			
			HttpResponse<JsonNode> fileGstrResp = fileGstrReq.asJson();

			System.out.println(String.format("fileGstrResp Request : Status[%s] Response[%s]", fileGstrResp.getStatus(), fileGstrResp.getBody()));
			if (fileGstrResp.getStatus() == 200) 
			{
				JSONObject fileGstrRespObj = fileGstrResp.getBody().getObject();
				if(fileGstrRespObj.has("data") && fileGstrRespObj.has("rek"))
				{
					callStatus = "1";
					String fileGstrData = fileGstrRespObj.getString("data");
					String fileGstrRek = fileGstrRespObj.getString("rek");

					byte[] fileGstrApiEK = aesEncryption.decrypt(fileGstrRek, authSEK);

					String fileGstrJsoninBase64 = new String(aesEncryption.decrypt(fileGstrData, fileGstrApiEK));

					byte[] fileGstrJsonInBytes = aesEncryption.decodeBase64StringTOByte(fileGstrJsoninBase64);

					System.out.println(new String(fileGstrJsonInBytes));
					
					responseId = new String(fileGstrJsonInBytes);
				}
				else
				{
					callStatus = "2";
					JSONObject errorJSON = fileGstrResp.getBody().getObject().getJSONObject("error");
					responseJsonStr = errorJSON.toString();
					errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
					retString = getError(errMsg, "GSTAPIERR", conn);
				}
			}
			else
			{
				callStatus = "2";
				JSONObject errorJSON = fileGstrResp.getBody().getObject().getJSONObject("error");
				responseJsonStr = errorJSON.toString();
				errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
				retString = getError(errMsg, "GSTAPIERR", conn);
			}
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.fileGstr1()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			APICallData apiCallData = new APICallData();
			apiCallData.setPeriodCode(periodCode);
			apiCallData.setCallDate(new Date());
			apiCallData.setSiteCode(siteCode);
			apiCallData.setUserId(loginCode);
			apiCallData.setCallType("RETFILE");
			apiCallData.setRecType(recType);
			apiCallData.setNoOfRecords(0);
			apiCallData.setCallStatus(callStatus);
			apiCallData.setResponseId(responseId);
			apiCallData.setResponseJsonStr(responseJsonStr);
			apiCallData.setChgUser(loginCode);
			apiCallData.setChgDate(new Date());
			apiCallData.setChgTerm(chgTerm);
			
			gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
		}
		
		return retString;
	}
	private String deleteDataFromGSTN (String jsonPayload, int noOfRecodrs, ArrayList<String> tranIdList, String recType, String xtraParams, Connection conn) throws ITMException
	{
		String retString = "";
		String RETURN_URL = "", siteCode = "", loginCode = "", chgTerm = "";
		String gspAuthString = "", gspAuthSignature = "";
		String transactionId = "";
		String errMsg = "", callStatus = "", responseId = "", responseJsonStr = "", gstrData = "", gstrRek = "";
		try
		{
			if("1".equalsIgnoreCase(recType))
			{
				RETURN_URL = GSTR1_URL;
			}
			else if("2".equalsIgnoreCase(recType))
			{
				RETURN_URL = GSTR2_URL;
			}
			
			siteCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			
			transactionId = UUID.randomUUID().toString().replaceAll("-", "");
			
			long timeStamp = new Timestamp().getDateTime();
	        gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin;
			gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
			
			byte[] jsonBase64 = Base64.getEncoder().encode(jsonPayload.getBytes());
			String encryptedPayload = aesEncryption.encryptEK(jsonBase64, authSEK);
			 
			HMac hmac = new HMac(new SHA256Digest());
			byte[] resBuf = new byte[hmac.getMacSize()];
			
			hmac.init(new KeyParameter(authSEK));
			hmac.update(jsonBase64, 0, jsonBase64.length);
			hmac.doFinal(resBuf, 0);
			
			JSONObject gstrHeaderObj = new JSONObject();
			gstrHeaderObj.put("action", "RETSAVE");
			gstrHeaderObj.put("data", encryptedPayload);
			gstrHeaderObj.put("hmac", new String(Base64.getEncoder().encode(resBuf)));
			
			HttpRequest deleteGstrReq = Unirest.put(String.format("%s%s", BASE_API_URL, RETURN_URL))
									   	.header("Content-Type", APPLICATION_JSON)
									   	.header("clientid", clientId)
									   	.header("client-secret", clientSecret)
										.header("txn",transactionId)
										.header("state-cd", stateCode)
										.header("auth-token", authToken)
										.header("gstin", gstin)
										.header("username", userName)
										.header("ret_period", periodCode)
										.header("ip-usr", ipAddress)
										.header("X-Asp-Auth-Token", gspAuthString)
										.header("X-Asp-Auth-Signature", gspAuthSignature)
										.body(new JsonNode(gstrHeaderObj.toString()))
										.getHttpRequest();
				
				System.out.println("DELETE GSTR"+recType+" url["+deleteGstrReq.getUrl()+"]");
				System.out.println("DELETE GSTR"+recType+" method["+deleteGstrReq.getHttpMethod()+"]");
				System.out.println("DELETE GSTR"+recType+" request header["+deleteGstrReq.getHeaders()+"]");
				System.out.println("DELETE GSTR"+recType+" request payload["+IOUtils.toString(deleteGstrReq.getBody().getEntity().getContent())+"]");
				
				HttpResponse<JsonNode> gstrResp = deleteGstrReq.asJson();
				
				System.out.println(String.format("gstrResp Request : Status[%s] Response[%s]", gstrResp.getStatus(), gstrResp.getBody()));
				
				if (gstrResp.getStatus() == 200) 
				{
					JSONObject gstrRespObj = gstrResp.getBody().getObject();

					if(gstrRespObj.has("data") && gstrRespObj.has("rek"))
					{
						callStatus = "1";
						gstrData = gstrRespObj.getString("data");
						gstrRek = gstrRespObj.getString("rek");

						byte[] apiEKGstr = aesEncryption.decrypt(gstrRek, authSEK);
						String gstrRespJsoninBase64 = new String(aesEncryption.decrypt(gstrData, apiEKGstr));

						byte[] gstrRespJsonInBytes = aesEncryption.decodeBase64StringTOByte(gstrRespJsoninBase64);

						JSONObject gstrTransIdRespObj = new JSONObject(new String(gstrRespJsonInBytes));
						String transId = gstrTransIdRespObj.getString("reference_id");

						responseId = transId;

						System.out.println("transId to getStatus["+transId+"]");

						retString = getSaveSubmitStatus(transId, tranIdList ,recType, "D", xtraParams, conn);
					}
					else
					{
						callStatus = "2";
						JSONObject errorJSON = gstrResp.getBody().getObject().getJSONObject("error");
						responseJsonStr = errorJSON.toString();
						errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
						retString = getError(errMsg, "GSTAPIERR", conn);
					}
				}
				else if(gstrResp.getStatus() == 500)
				{
				callStatus = "2";
				errMsg = "Message : Error occurred at GSTN server \nResponse code : "+gstrResp.getStatus();
				responseJsonStr = errMsg;
				retString = getError(errMsg, "GSTAPIERR", conn);
				}
				else
				{
				callStatus = "2";
				JSONObject errorJSON = gstrResp.getBody().getObject().getJSONObject("error");
				responseJsonStr = errorJSON.toString();
				errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
				retString = getError(errMsg, "GSTAPIERR", conn);
				}
			
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.deleteDataFromGSTN()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			APICallData apiCallData = new APICallData();
			apiCallData.setPeriodCode(periodCode);
			apiCallData.setCallDate(new Date());
			apiCallData.setSiteCode(siteCode);
			apiCallData.setUserId(loginCode);
			apiCallData.setCallType("RETDELETE");
			apiCallData.setRecType(recType);
			apiCallData.setNoOfRecords(0);
			apiCallData.setCallStatus(callStatus);
			apiCallData.setResponseId(responseId);
			apiCallData.setResponseJsonStr(responseJsonStr);
			apiCallData.setChgUser(loginCode);
			apiCallData.setChgDate(new Date());
			apiCallData.setChgTerm(chgTerm);
			
			gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
		}
		return retString;
	}
	private String getSaveSubmitStatus(String transId, ArrayList<String> tranIdList, String recType, String actionFlag, String xtraParams, Connection conn) throws ITMException
	{
		String retString = "", errMsg = "";
		String transactionId = "", retStatsData = "", retStatsRek= "", retStatusCallStatus = "", retStatusResponseJsonStr = "";
		String gspAuthStringRet = "", gspAuthSignatureRet = "", siteCode = "", loginCode = "", chgTerm = "";
		boolean isLoopBreak = false;
		String sql = "";
		PreparedStatement pstmt = null;
		int updateCnt = 0;
		APICallData apiRetStatsCallData = null;
		ArrayList<APICallData> retStatAPICallList = new ArrayList<APICallData>();
		try
		{
			siteCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			
			while(true)
			{
				Thread.sleep(10000);//TODO NEED TO REMOVE WITH BETTER OPTION
				transactionId = UUID.randomUUID().toString().replaceAll("-", "");
				long timeStampRet = new Timestamp().getDateTime();
		        gspAuthStringRet = clientId + ":" + transactionId + ":" + timeStampRet + ":" + gstin;
				gspAuthSignatureRet = gspSignature.sign(gspAuthStringRet, aspPrivateKey);
				
				HttpRequest retStatusReq = Unirest.get(String.format("%s%s", BASE_API_URL, GSTR_RETSTAT_URL))
										   .queryString("action","RETSTATUS")
										   .queryString("gstin", gstin)
										   .queryString("ret_period", periodCode)
										   .queryString("ref_id",transId)
										   .header("Content-Type", APPLICATION_JSON)
										   .header("state-cd", stateCode)
										   .header("clientid", clientId)
										   .header("client-secret", clientSecret)
										   .header("ip-usr", ipAddress)
										   .header("username", userName)
										   .header("auth-token", authToken)
										   .header("txn", transactionId)
										   .header("ret_period", periodCode)
										   .header("gstin", gstin)
										   .header("X-Asp-Auth-Token", gspAuthStringRet)
					    	               .header("X-Asp-Auth-Signature", gspAuthSignatureRet)
										   .getHttpRequest();
				
				System.out.println("RETSTATUS url["+retStatusReq.getUrl()+"]");
				System.out.println("RETSTATUS method["+retStatusReq.getHttpMethod()+"]");
				System.out.println("RETSTATUS request header["+retStatusReq.getHeaders()+"]");
				
				HttpResponse<JsonNode> retStatusResp = retStatusReq.asJson();

				System.out.println(String.format("retStatusResp Request : Status[%s] Response[%s]", retStatusResp.getStatus(), retStatusResp.getBody()));

				if (retStatusResp.getStatus() == 200) 
				{
					JSONObject retStatsRespObj = retStatusResp.getBody().getObject();
					if(retStatsRespObj.has("data") && retStatsRespObj.has("rek"))
					{
						retStatsData = retStatsRespObj.getString("data");
						retStatsRek = retStatsRespObj.getString("rek");

						byte[] apiEKRetstats = aesEncryption.decrypt(retStatsRek, authSEK);

						String retStatsRespJsoninBase64 = new String(aesEncryption.decrypt(retStatsData, apiEKRetstats));

						byte[] retStatsRespJsonInBytes = aesEncryption.decodeBase64StringTOByte(retStatsRespJsoninBase64);

						JSONObject retStatsJsonData = new JSONObject(new String(retStatsRespJsonInBytes));
						System.out.println( "retStatsJsonData["+retStatsJsonData+"]");
						
						if("IP".equalsIgnoreCase((String)retStatsJsonData.get("status_cd")))
						{
							retStatusCallStatus = "0";
							retStatusResponseJsonStr = "IP";
						}
						else if("P".equalsIgnoreCase((String)retStatsJsonData.get("status_cd")))
						{
							retStatusCallStatus = "1";
							if(tranIdList != null && tranIdList.size() > 0)
							{
								updateSubmissionStatus(tranIdList, actionFlag, conn);
							}
							else
							{
								sql = "UPDATE GST_DATA_HDR SET SUBMIT_STATUS = ?, SUBMIT_DATE = ? WHERE PRD_CODE = ? AND SITE_CODE = ? AND REC_TYPE = ? AND SUBMIT_STATUS = ?";
								pstmt = conn.prepareStatement(sql);
								
								pstmt.setString(1, "S");
								pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(e12GenericUtility.getValidDateString(new Date(), e12GenericUtility.getDBDateTimeFormat())));
								pstmt.setString(3, periodCode);
								pstmt.setString(4, siteCode);
								pstmt.setString(5, recType);
								pstmt.setString(6, "T");
								
								updateCnt = pstmt.executeUpdate();
								
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
								
								System.out.println("submit status updated of ["+siteCode+"] for ["+periodCode+"] update count ["+updateCnt+"]");
							}
							isLoopBreak = true;
						}
						else if("PE".equalsIgnoreCase((String)retStatsJsonData.get("status_cd")))
						{
							retStatusCallStatus = "2";
							errMsg = getRetStatusErrMsg(retStatsJsonData);
							retStatusResponseJsonStr = errMsg;
							retString = getError(errMsg, "GSTAPIERR", conn);
							isLoopBreak = true;
						}
						else if("ER".equalsIgnoreCase(retStatsJsonData.getString("status_cd")))
						{
							retStatusCallStatus = "2";
							if(retStatsJsonData.has("error_report"))
							{
								JSONObject errorJSON = retStatsJsonData.getJSONObject("error_report");
								if(errorJSON.has("error_msg") && errorJSON.has("error_cd"))
								{
									errMsg = "Message : "+errorJSON.getString("error_msg")+" \nError code : "+errorJSON.getString("error_cd");
								}
							}
							
							retStatusResponseJsonStr = errMsg;
							retString = getError(errMsg, "GSTAPIERR", conn);
							isLoopBreak = true;
						}
						else
						{
							retStatusCallStatus = "2";
							if(retStatsJsonData.has("status_cd"))
							{
								errMsg = "Message : "+retStatsJsonData.getString("status_cd")+" \nError code : "+retStatsJsonData.getString("status_cd");
							}
							
							retStatusResponseJsonStr = errMsg;
							retString = getError(errMsg, "GSTAPIERR", conn);
							isLoopBreak = true;
						}
					}
					else
					{
						retStatusCallStatus = "2";
						JSONObject errorJSON = retStatusResp.getBody().getObject().getJSONObject("error");
						retStatusResponseJsonStr = errorJSON.toString();
						errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
						retString = getError(errMsg, "GSTAPIERR", conn);
						isLoopBreak = true;
					}
				}
				else if(retStatusResp.getStatus() == 500)
		        {
					retStatusCallStatus = "2";
		        	errMsg = "Message : Error occurred at GSTN server \nResponse code : "+retStatusResp.getStatus();
		        	retStatusResponseJsonStr = errMsg;
		        	retString = getError(errMsg, "GSTAPIERR", conn);
		        	isLoopBreak = true;
		        }
				else
				{
					retStatusCallStatus = "2";
					JSONObject errorJSON = retStatusResp.getBody().getObject().getJSONObject("error");
					retStatusResponseJsonStr = errorJSON.toString();
					errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
					retString = getError(errMsg, "GSTAPIERR", conn);
					isLoopBreak = true;
				}
				
				if(retStatusResponseJsonStr.length() > 500)
				{
					retStatusResponseJsonStr = retStatusResponseJsonStr.substring(0, 500);
				}
				
				apiRetStatsCallData = new APICallData();
				apiRetStatsCallData.setPeriodCode(periodCode);
				apiRetStatsCallData.setCallDate(new Date());
				apiRetStatsCallData.setSiteCode(siteCode);
				apiRetStatsCallData.setUserId(loginCode);
				apiRetStatsCallData.setCallType("RETSTATUS");
				apiRetStatsCallData.setRecType(recType);
				apiRetStatsCallData.setNoOfRecords(0);
				apiRetStatsCallData.setCallStatus(retStatusCallStatus);
				apiRetStatsCallData.setResponseId("");
				apiRetStatsCallData.setResponseJsonStr(retStatusResponseJsonStr);
				apiRetStatsCallData.setChgUser(loginCode);
				apiRetStatsCallData.setChgDate(new Date());
				apiRetStatsCallData.setChgTerm(chgTerm);
				
				retStatAPICallList.add(apiRetStatsCallData);
		        
		        if(isLoopBreak)
		        {
		        	break;
		        }
		        else
		        {
		        	continue;
		        }
			}
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.getSaveSubmitStatus()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			if(retStatAPICallList.size()>0)
			{
				for(APICallData apiCallData : retStatAPICallList)
				{
					gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
				}
			}
		}
		return retString;
	}
	/*private String getGstr1Summary(String authToken, String stateCode, String userName, String gstin, String periodCode, byte[] authSEK, String action, String xtraParams, Connection conn) throws ITMException
	{
		String retString = "";
		String errMsg = "", gspAuthString = "", gspAuthSignature = "";
		String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
		String loginCode = "", chgTerm = "", siteCode = "", callStatus = "", responseJsonStr = "", retFileCallStatus = "", retFileResponseJsonStr = "";
		
		try
		{
			siteCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			
			long timeStamp = new Timestamp().getDateTime();
	        gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin;
			gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
			
			System.out.println("RETSUM request url ["+String.format("%s%s", GSP_API_URL, GSTR1_URL_V3)+"]");
			
			HttpResponse<JsonNode> getGstr1SumryResp = Unirest.get(String.format("%s%s", GSP_API_URL, GSTR1_URL_V3))
													   .queryString("action","RETSUM")
													   .queryString("gstin", gstin)
													   .queryString("ret_period", periodCode)
													   .header("Content-Type", APPLICATION_JSON)
													   .header("state-cd", stateCode)
													   .header("clientid", clientId)
													   .header("client-secret", clientSecret)
													   .header("ip-usr", ipAddress)
													   .header("username", userName)
													   .header("auth-token", authToken)
													   .header("txn", transactionId)
													   .header("ret_period", periodCode)
													   .header("gstin", gstin)
													   .header("X-Asp-Auth-Token", gspAuthString)
								    	               .header("X-Asp-Auth-Signature", gspAuthSignature)
													   .asJson();
			
			System.out.println(String.format("getGstr1SumryResp Request : Status[%s] Response[%s]", getGstr1SumryResp.getStatus(), getGstr1SumryResp.getBody()));
			
			if (getGstr1SumryResp.getStatus() == 200) 
	        {
				JSONObject getGstr1SumryRespObj = getGstr1SumryResp.getBody().getObject();
				if(getGstr1SumryRespObj.has("data") && getGstr1SumryRespObj.has("rek"))
				{
					callStatus = "1";
					
					String gstr1Sumrydata = getGstr1SumryRespObj.getString("data");
					String gstr1Sumryrek = getGstr1SumryRespObj.getString("rek");
					
					byte[] apiEK = aesEncryption.decrypt(gstr1Sumryrek, authSEK);
					
					String respJsoninBase64 = new String(aesEncryption.decrypt(gstr1Sumrydata, apiEK));
					
					byte[] respJsonInBytes = aesEncryption.decodeBase64StringTOByte(respJsoninBase64);
					
					JSONObject gstr1SumryJsonObj = new JSONObject(new String(respJsonInBytes));
					
					System.out.println(gstr1SumryJsonObj);
					
					if("FILE".equalsIgnoreCase(action))
					{
						String gspAuthStringFile = "", gspAuthSignatureFile = "";
						
						byte[] jsonBase64 = Base64.getEncoder().encode(gstr1SumryJsonObj.toString().getBytes());
						String encryptedPayload = aesEncryption.encryptEK(jsonBase64, authSEK);
						
						HMac hmac = new HMac(new SHA256Digest());
						byte[] resBuf = new byte[hmac.getMacSize()];
						
						hmac.init(new KeyParameter(authSEK));
						hmac.update(jsonBase64, 0, jsonBase64.length);
						hmac.doFinal(resBuf, 0);
						
						JSONObject fileGstr1DataJsonObj = new JSONObject();
						fileGstr1DataJsonObj.put("action", "RETFILE");
						fileGstr1DataJsonObj.put("data", encryptedPayload);
						fileGstr1DataJsonObj.put("hmac", new String(Base64.getEncoder().encode(resBuf)));
						fileGstr1DataJsonObj.put("sign", "asfasfasfu3dsfkj3kjdv=");
						fileGstr1DataJsonObj.put("st", "DSC");
						fileGstr1DataJsonObj.put("sid", "AMAPT8269L");
						
						long timeStampFile = new Timestamp().getDateTime();
				        gspAuthStringFile = clientId + ":" + transactionId + ":" + timeStampFile + ":" + gstin;
						gspAuthSignatureFile = gspSignature.sign(gspAuthStringFile, aspPrivateKey);
						
						System.out.println("RETFILE request url ["+String.format("%s%s", GSP_API_URL, GSTR1_URL_V3)+"]");
						
						HttpResponse<JsonNode> fileGstr1Resp = Unirest.post(String.format("%s%s", GSP_API_URL, GSTR1_URL_V3))
															   .header("Content-Type", APPLICATION_JSON)
															   .header("state-cd", stateCode)
															   .header("clientid", clientId)
															   .header("client-secret", clientSecret)
															   .header("ip-usr", ipAddress)
															   .header("username", userName)
															   .header("auth-token", authToken)
															   //.header("app_key", appKeyEncryptedAndCoded)
															   .header("txn", transactionId)
															   .header("ret_period", periodCode)
															   .header("gstin", gstin)
															   .header("X-Asp-Auth-Token", gspAuthStringFile)
										    	               .header("X-Asp-Auth-Signature", gspAuthSignatureFile)
															   .body(new JsonNode(fileGstr1DataJsonObj.toString()))
															   .asJson();
						
						System.out.println(String.format("fileGstr1Resp Request : Status[%s] Response[%s]", fileGstr1Resp.getStatus(), fileGstr1Resp.getBody()));
						if (fileGstr1Resp.getStatus() == 200) 
				        {
							JSONObject fileGstr1RespObj = fileGstr1Resp.getBody().getObject();
							if(fileGstr1RespObj.has("data") && fileGstr1RespObj.has("rek"))
							{
								retFileCallStatus = "1";
								String fileGstr1Data = fileGstr1RespObj.getString("data");
								String fileGstr1Rek = fileGstr1RespObj.getString("rek");
								
								byte[] fileGstr1ApiEK = aesEncryption.decrypt(fileGstr1Rek, authSEK);
								
								String fileGstr1JsoninBase64 = new String(aesEncryption.decrypt(fileGstr1Data, fileGstr1ApiEK));
								
								byte[] fileGstr1JsonInBytes = aesEncryption.decodeBase64StringTOByte(fileGstr1JsoninBase64);
								
								retFileResponseJsonStr = new String(fileGstr1JsonInBytes);
								
								System.out.println(new String(fileGstr1JsonInBytes));
							}
							else
							{
								retFileCallStatus = "2";
								JSONObject errorJSON = fileGstr1Resp.getBody().getObject().getJSONObject("error");
								retFileResponseJsonStr = errorJSON.toString();
					        	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
					        	retString = getError(errMsg, "GSTAPIERR", conn);
							}
				        }
						else
						{
							retFileCallStatus = "2";
							JSONObject errorJSON = fileGstr1Resp.getBody().getObject().getJSONObject("error");
							retFileResponseJsonStr = errorJSON.toString();
				        	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
				        	retString = getError(errMsg, "GSTAPIERR", conn);
						}
						
						APICallData apiCallData = new APICallData();
				        apiCallData.setPeriodCode(periodCode);
				        apiCallData.setCallDate(new Date());
				        apiCallData.setSiteCode(siteCode);
				        apiCallData.setUserId(loginCode);
				        apiCallData.setCallType("RETFILE");
				        apiCallData.setRecType("1");
				        apiCallData.setNoOfRecords(0);
				        apiCallData.setCallStatus(retFileCallStatus);
				        apiCallData.setResponseId("");
				        apiCallData.setResponseJsonStr(retFileResponseJsonStr);
				        apiCallData.setChgUser(loginCode);
				        apiCallData.setChgDate(new Date());
				        apiCallData.setChgTerm(chgTerm);
				        
				        gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
					}
				}
				else
	            {
					callStatus = "2";
					JSONObject errorJSON = getGstr1SumryResp.getBody().getObject().getJSONObject("error");
					responseJsonStr = errorJSON.toString();
		        	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
		        	retString = getError(errMsg, "GSTAPIERR", conn);
	            }
	        }
			else
            {
				callStatus = "2";
            	JSONObject errorJSON = getGstr1SumryResp.getBody().getObject().getJSONObject("error");
            	responseJsonStr = errorJSON.toString();
            	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
	        	retString = getError(errMsg, "GSTAPIERR", conn);
            }
			
			APICallData apiCallData = new APICallData();
	        apiCallData.setPeriodCode(periodCode);
	        apiCallData.setCallDate(new Date());
	        apiCallData.setSiteCode(siteCode);
	        apiCallData.setUserId(loginCode);
	        apiCallData.setCallType("RETSUM");
	        apiCallData.setRecType("1");
	        apiCallData.setNoOfRecords(0);
	        apiCallData.setCallStatus(callStatus);
	        apiCallData.setResponseId("");
	        apiCallData.setResponseJsonStr(responseJsonStr);
	        apiCallData.setChgUser(loginCode);
	        apiCallData.setChgDate(new Date());
	        apiCallData.setChgTerm(chgTerm);
	        
	        gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.getGstr1Summary()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}*/
	private String downloadGstr2AData(String siteCode, String xtraParams, Connection conn) throws ITMException
	{
		String retString = "";
		String errMsg = "", gspAuthString = "", gspAuthSignature = "";
		String[] gstr2Section = {"B2B","CDN"};
		String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
		String loginCode = "", chgTerm = "", callStatus = "", responseJsonStr = "", responseId = "";
		ArrayList<APICallData> apiCallDataList = new ArrayList<APICallData>();
		
		try
		{
			loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			
			for(String action : gstr2Section)
			{
				System.out.println("calling for ["+action+"]");
				long timeStamp = new Timestamp().getDateTime();
		        gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin;
				gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
				
				HttpRequest getGstr2InvoicesReq = Unirest.get(String.format("%s%s", BASE_API_URL, GSTR2A_URL))
			     				  		   	   	  .queryString("action", action)
				     				  		   	  .queryString("gstin", gstin)
				     				  		   	  .queryString("ret_period", periodCode)
				     				  		   	  .header("Content-Type", APPLICATION_JSON)
				     				  		   	  .header("state-cd", stateCode)
				     				  		   	  .header("clientid", clientId)
				     				  		   	  .header("client-secret", clientSecret)
				     				  		   	  .header("ip-usr", ipAddress)
				     				  		   	  .header("username", userName)
				     				  		   	  .header("auth-token", authToken)
				     				  		   	  .header("txn", transactionId)
				     				  		   	  .header("ret_period", periodCode)
				     				  		   	  .header("gstin", gstin)
				     				  		   	  .header("X-Asp-Auth-Token", gspAuthString)
							    	              .header("X-Asp-Auth-Signature", gspAuthSignature)
				     				  		   	  .getHttpRequest();
				
				System.out.println("get GSTR2A ["+action+"] invoices url["+getGstr2InvoicesReq.getUrl()+"]");
		        System.out.println("get GSTR2A ["+action+"] invoices method["+getGstr2InvoicesReq.getHttpMethod()+"]");
				System.out.println("get GSTR2A ["+action+"] invoices request header["+getGstr2InvoicesReq.getHeaders()+"]");
				
				HttpResponse<JsonNode> getGstr2InvoicesResp = getGstr2InvoicesReq.asJson();
				
				System.out.println(String.format("getGstr2InvoicesResp Request : Status[%s] Response[%s]", getGstr2InvoicesResp.getStatus(), getGstr2InvoicesResp.getBody()));
				 
				if (getGstr2InvoicesResp.getStatus() == 200) 
				{
					JSONObject getGstr2InvoicesRespObj = getGstr2InvoicesResp.getBody().getObject();
					if(getGstr2InvoicesRespObj.has("data") && getGstr2InvoicesRespObj.has("rek"))
					{
						callStatus = "1";
						String gstr2InvoicesData = getGstr2InvoicesRespObj.getString("data");
						String gstr2InvoicesRek = getGstr2InvoicesRespObj.getString("rek");

						byte[] apiEK = aesEncryption.decrypt(gstr2InvoicesRek, authSEK);
						String respJsoninBase64 = new String(aesEncryption.decrypt(gstr2InvoicesData, apiEK));

						byte[] respJsonInBytes = aesEncryption.decodeBase64StringTOByte(respJsoninBase64);

						JSONObject gstr2InvoiceJsonObj = new JSONObject(new String(respJsonInBytes));

						System.out.println("respJsonInBytes["+new String(respJsonInBytes)+"]");
						
						if(gstr2InvoiceJsonObj.has("est") && gstr2InvoiceJsonObj.has("token"))
		                {
							retString = getDataFromFileServer("4", gstr2InvoiceJsonObj, action, xtraParams, conn);
		                }
						else
						{
							if("B2B".equalsIgnoreCase(action))
							{
								insertB2BInvoiceData(stateCode, periodCode, siteCode, gstr2InvoiceJsonObj, xtraParams, conn);
							}
							else if("CDN".equalsIgnoreCase(action))
							{
								insertCDNData(stateCode, periodCode, siteCode, gstr2InvoiceJsonObj, xtraParams, conn);
							}
						}
					}
					else
					{
						callStatus = "2";
						JSONObject errorJSON = getGstr2InvoicesResp.getBody().getObject().getJSONObject("error");
						responseJsonStr = errorJSON.toString();
						errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
						retString = getError(errMsg, "GSTAPIERR", conn);
					}
				}
				else if(getGstr2InvoicesResp.getStatus() == 500)
				{
					callStatus = "2";
					errMsg = "Message : Error occurred at GSTN server \nResponse code : "+getGstr2InvoicesResp.getStatus();
					responseJsonStr = errMsg;
					retString = getError(errMsg, "GSTAPIERR", conn);
				}
				else
				{
					callStatus = "2";
					JSONObject errorJSON = getGstr2InvoicesResp.getBody().getObject().getJSONObject("error");
					responseJsonStr = errorJSON.toString();
					errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
					retString = getError(errMsg, "GSTAPIERR", conn);
				}
				 
				APICallData apiCallData = new APICallData();
				apiCallData.setPeriodCode(periodCode);
				apiCallData.setCallDate(new Date());
				apiCallData.setSiteCode(siteCode);
				apiCallData.setUserId(loginCode);
				apiCallData.setCallType("GET_"+action);
				apiCallData.setRecType("4");
				apiCallData.setNoOfRecords(0);
				apiCallData.setCallStatus(callStatus);
				apiCallData.setResponseId(responseId);
				apiCallData.setResponseJsonStr(responseJsonStr);
				apiCallData.setChgUser(loginCode);
				apiCallData.setChgDate(new Date());
				apiCallData.setChgTerm(chgTerm);
				
				apiCallDataList.add(apiCallData);
	        
			}
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.getGstr2Invoices()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			if(apiCallDataList.size() > 0)
			{
				for(APICallData eachApiCallData : apiCallDataList)
				{
					gstCommonUtil.updateAPICallLogHistory(eachApiCallData, null);
				}
			}
		}
		return retString;
	}
	private String createGstr2Json(String siteCode, String xtraParams, Connection conn) throws ITMException
	{
		String retString = "";
		int num = 0, noOfRecords = 0;
		
		boolean isDataFound = false;
		
		String udfStr1 = "", udfStr2 = "", udfStr3 = "";
		String sql = "", lineSql = "";
		PreparedStatement pstmt = null, linePstmt = null;
		ResultSet rs = null, lineRs = null;
		
		String tranId = "", tranType = "", tranIdRef = "", ctin = "", posStateCode = "";

		ArrayList<String> tranIdList = new ArrayList<String>();
		
		Map<String, ArrayList<Invoice>> invoicesHMap = new HashMap<String, ArrayList<Invoice>>();
		Map<String, Object> invTypObjHMap = new HashMap<String, Object>();
		ArrayList<B2B> b2bInvoiceList = new ArrayList<B2B>();
		ArrayList<B2BUR> b2burInvoiceList = new ArrayList<B2BUR>();
		ArrayList<CDNR> cdnrList = new ArrayList<CDNR>();
		ArrayList<HSNDetails> hsnList = new ArrayList<HSNDetails>();
		ArrayList<IMPG> impgList = new ArrayList<IMPG>();
		ArrayList<IMPS> impsList = new ArrayList<IMPS>();
		ArrayList<AT> txiList = new ArrayList<AT>();
		ArrayList<AT> txpdList = new ArrayList<AT>();
		ArrayList<CDNUR> cdnurList = new ArrayList<CDNUR>();
		
		ArrayList<InvLineItem> invLineItems = null;
		ArrayList<Invoice> invoices = null;
		ArrayList<CDNDetails> cdnDetailsList = null;
		
		GSTR2 gstr2 = null;
		Invoice invoice = null;
		InvLineItem invLineItem = null;
		B2B b2b = null;
		B2BUR b2bur = null;
		CDNR cdnr = null;
		CDNDetails cdnDetails = null;
		HSNDetails hsnDetails = null;
		HSN hsn = null;
		IMPG impg = null;
		IMPS imps = null;
		AT at = null;
		CDNUR cdnur = null;
		NilInwardSupplies nilInwardSupplies = null;
		
		try
		{
			sql = "SELECT * FROM GST_DATA_HDR WHERE PRD_CODE = ? AND SITE_CODE = ? AND SUBMIT_STATUS = 'P' AND REC_TYPE ='2'";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, periodCode);
			pstmt.setString(2, siteCode);
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				++noOfRecords;
				isDataFound = true;
				tranId = checkNullandTrim(rs.getString("TRAN_ID"));
				tranType = checkNullandTrim(rs.getString("TRAN_TYPE"));
				ctin = checkNullandTrim(rs.getString("TAX_REG_NO"));
				posStateCode = checkNullandTrim(rs.getString("GST_CODE"));
				tranIdRef = checkNullandTrim(rs.getString("TRAN_ID__REF"));
				
				System.out.println("in saveGstr2 tranId["+tranId+"] tranType["+tranType+"] ctin["+ctin+"] posStateCode["+posStateCode+"] tranIdRef["+tranIdRef+"]");
				
				invoices = new ArrayList<Invoice>();
				invoice = new Invoice();
				invLineItems = new ArrayList<InvLineItem>();
				cdnDetailsList = new ArrayList<CDNDetails>();
				
				lineSql = "SELECT UDF_STR1, UDF_STR2, UDF_STR3 FROM GENCODES WHERE MOD_NAME = 'W_GSTR_PURC' AND FLD_NAME = 'TRAN_TYPE' AND FLD_VALUE = ? ";
				linePstmt = conn.prepareStatement(lineSql);
				linePstmt.setString(1, tranType);
				
				lineRs = linePstmt.executeQuery();
				
				if(lineRs.next())
				{
					udfStr1 = checkNullandTrim(lineRs.getString("UDF_STR1"));
					udfStr2 = checkNullandTrim(lineRs.getString("UDF_STR2"));
					udfStr3 = checkNullandTrim(lineRs.getString("UDF_STR3"));
					
					System.out.println("udfStr1["+udfStr1+"] udfStr2["+udfStr2+"] udfStr3["+udfStr3+"]");
				}
				if(linePstmt!=null)
				{
					linePstmt.close();
					linePstmt=null;
				}
				if(lineRs!=null)
				{
					lineRs.close();
					lineRs=null;
				}
				
				if(invoicesHMap.containsKey(ctin+"~"+udfStr1))
				{
					invoices = invoicesHMap.get(ctin+"~"+udfStr1);
				}
				
				//tran_type : 01 = B2B invoices
				if("B2B".equalsIgnoreCase(udfStr1))
				{
					lineSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(IGST_AMT) AS IGST_AMT, SUM(CGST_AMT) AS CGST_AMT, SUM(SGST_AMT) AS SGST_AMT, SUM(CESS_AMT) AS CESS_AMT, "
							+ " ITC_TYPE, SUM(ITC_IGST) AS ITC_IGST, SUM(ITC_CGST) AS ITC_CGST, SUM(ITC_SGST) AS ITC_SGST, SUM(ITC_CESS) AS ITC_CESS "
							+ " FROM GST_DATA_DET "
							+ " WHERE TRAN_ID = ? "
							+ " GROUP BY GST_RATE, ITC_TYPE ";
					linePstmt = conn.prepareStatement(lineSql);
					linePstmt.setString(1, tranId);
					lineRs = linePstmt.executeQuery();
					int lineNum = 0;
					while(lineRs.next())
					{
						invLineItem = new InvLineItem();
						invLineItem.num = ++lineNum;
						invLineItem.rate = lineRs.getDouble("GST_RATE");
						invLineItem.taxval = lineRs.getDouble("TAXABLE_AMT");
						invLineItem.iamt = lineRs.getDouble("IGST_AMT");
						invLineItem.camt = lineRs.getDouble("CGST_AMT");
						invLineItem.samt = lineRs.getDouble("SGST_AMT");
						invLineItem.csamt = lineRs.getDouble("CESS_AMT");
						invLineItem.itcType = checkNullandTrim(lineRs.getString("ITC_TYPE")).toLowerCase();
						invLineItem.igstInputTax = lineRs.getDouble("ITC_IGST");
						invLineItem.cgstInputTax = lineRs.getDouble("ITC_CGST");
						invLineItem.sgstInputTax = lineRs.getDouble("ITC_SGST");
						invLineItem.cessInputTax = lineRs.getDouble("ITC_CESS");
						
						invLineItems.add(invLineItem);
					}
					if(linePstmt != null)
					{
						linePstmt.close();
						linePstmt = null;
					}
					if(lineRs != null)
					{
						lineRs.close();
						lineRs = null;
					}
					
					invoice.inum = rs.getString("DOC_NO");
					invoice.idt = rs.getDate("DOC_DATE");
					invoice.val = rs.getDouble("AMOUNT");
					invoice.invoiceType = udfStr2;
					invoice.pos = posStateCode;
					invoice.rchrg = "Y".equalsIgnoreCase(rs.getString("REVERSE_CHRG"));
					invoice.items = invLineItems;
					invoice.taxPayerAction = checkNullandTrim(rs.getString("SUBMISSION_TYPE"));
					invoice.checksum = checkNullandTrim(rs.getString("DOC_CHECKSUM"));
					
					invoices.add(invoice);
					
					invoicesHMap.put(ctin+"~"+udfStr1, invoices);
					
					if("B2B".equalsIgnoreCase(udfStr1))
					{
						b2b = new B2B();
						if(invTypObjHMap.containsKey(ctin+"~"+udfStr1))
						{
							b2b = (B2B)invTypObjHMap.get(ctin+"~"+udfStr1);
							if(b2bInvoiceList.contains(b2b))
							{
								int index = b2bInvoiceList.indexOf(b2b);
								b2bInvoiceList.remove(index);
							}
						}
						b2b.ctin = ctin;
						b2b.isReverseCharge = true;
						b2b.invoices = invoices;
						
						invTypObjHMap.put(ctin+"~"+udfStr1, b2b);
						b2bInvoiceList.add(b2b);
					}
				}
				if("B2BUR".equalsIgnoreCase(udfStr1))
				{
					invoices = new ArrayList<Invoice>();
					invoice = new Invoice();
					invLineItems = new ArrayList<InvLineItem>();
					
					lineSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(IGST_AMT) AS IGST_AMT, SUM(CGST_AMT) AS CGST_AMT, SUM(SGST_AMT) AS SGST_AMT, SUM(CESS_AMT) AS CESS_AMT, "
							+ " ITC_TYPE, SUM(ITC_IGST) AS ITC_IGST, SUM(ITC_CGST) AS ITC_CGST, SUM(ITC_SGST) AS ITC_SGST, SUM(ITC_CESS) AS ITC_CESS "
							+ " FROM GST_DATA_DET "
							+ " WHERE TRAN_ID = ? "
							+ " GROUP BY GST_RATE, ITC_TYPE ";
					linePstmt = conn.prepareStatement(lineSql);
					linePstmt.setString(1, tranId);
					lineRs = linePstmt.executeQuery();
					int lineNum = 0;
					while(lineRs.next())
					{
						invLineItem = new InvLineItem();
						invLineItem.num = ++lineNum;
						invLineItem.rate = lineRs.getDouble("GST_RATE");
						invLineItem.taxval = lineRs.getDouble("TAXABLE_AMT");
						invLineItem.iamt = lineRs.getDouble("IGST_AMT");
						invLineItem.camt = lineRs.getDouble("CGST_AMT");
						invLineItem.samt = lineRs.getDouble("SGST_AMT");
						invLineItem.csamt = lineRs.getDouble("CESS_AMT");
						invLineItem.itcType = checkNullandTrim(lineRs.getString("ITC_TYPE")).toLowerCase();
						invLineItem.igstInputTax = lineRs.getDouble("ITC_IGST");
						invLineItem.cgstInputTax = lineRs.getDouble("ITC_CGST");
						invLineItem.sgstInputTax = lineRs.getDouble("ITC_SGST");
						invLineItem.cessInputTax = lineRs.getDouble("ITC_CESS");
						
						invLineItems.add(invLineItem);
					}
					if(linePstmt != null)
					{
						linePstmt.close();
						linePstmt = null;
					}
					if(lineRs != null)
					{
						lineRs.close();
						lineRs = null;
					}
					
					invoice.inum = rs.getString("DOC_NO");
					invoice.idt = rs.getDate("DOC_DATE");
					invoice.val = rs.getDouble("AMOUNT");
					invoice.pos = posStateCode;
					invoice.items = invLineItems;
					invoice.supplyType = stateCode.trim().equalsIgnoreCase(posStateCode.trim())?"INTRA":"INTER";
					invoices.add(invoice);
					
					if("B2BUR".equalsIgnoreCase(udfStr1))
					{
						b2bur = new B2BUR();
						b2bur.invoices = invoices;
						b2burInvoiceList.add(b2bur);
					}
				}
				if("CDN".equalsIgnoreCase(udfStr1))
				{
					Calendar calendar = Calendar.getInstance();
					calendar.set(2017, 06, 01);
					Date gstStartDate = calendar.getTime();
					
					if("CDN".equalsIgnoreCase(udfStr1))
					{
						lineSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(IGST_AMT) AS IGST_AMT, SUM(CGST_AMT) AS CGST_AMT, SUM(SGST_AMT) AS SGST_AMT, SUM(CESS_AMT) AS CESS_AMT, "
								+ " ITC_TYPE, SUM(ITC_IGST) AS ITC_IGST, SUM(ITC_CGST) AS ITC_CGST, SUM(ITC_SGST) AS ITC_SGST, SUM(ITC_CESS) AS ITC_CESS "
								+ " FROM GST_DATA_DET "
								+ " WHERE TRAN_ID = ? "
								+ " GROUP BY GST_RATE, ITC_TYPE ";
						linePstmt = conn.prepareStatement(lineSql);
						linePstmt.setString(1, tranId);
						lineRs = linePstmt.executeQuery();
						int lineNum = 0;
						while(lineRs.next())
						{
							invLineItem = new InvLineItem();
							invLineItem.num = ++lineNum;
							invLineItem.rate = lineRs.getDouble("GST_RATE");
							invLineItem.taxval = lineRs.getDouble("TAXABLE_AMT");
							invLineItem.iamt = lineRs.getDouble("IGST_AMT");
							invLineItem.camt = lineRs.getDouble("CGST_AMT");
							invLineItem.samt = lineRs.getDouble("SGST_AMT");
							invLineItem.csamt = lineRs.getDouble("CESS_AMT");
							invLineItem.itcType = checkNullandTrim(lineRs.getString("ITC_TYPE")).toLowerCase();
							invLineItem.igstInputTax = lineRs.getDouble("ITC_IGST");
							invLineItem.cgstInputTax = lineRs.getDouble("ITC_CGST");
							invLineItem.sgstInputTax = lineRs.getDouble("ITC_SGST");
							invLineItem.cessInputTax = lineRs.getDouble("ITC_CESS");
							
							invLineItems.add(invLineItem);
						}
						if(linePstmt != null)
						{
							linePstmt.close();
							linePstmt = null;
						}
						if(lineRs != null)
						{
							lineRs.close();
							lineRs = null;
						}
						
						cdnDetails = new CDNDetails();
						
						cdnDetails.cdnNoteType = udfStr2;
						cdnDetails.cdNoteNumber = checkNullandTrim(rs.getString("DOC_NO"));
						cdnDetails.cdNoteDate = rs.getDate("DOC_DATE");
						cdnDetails.invoiceNumber = checkNullandTrim(rs.getString("REF_ID__INV"));
						cdnDetails.invoiceDate = rs.getDate("REF_DATE__INV");
						cdnDetails.val = rs.getDouble("AMOUNT");
						//cdnDetails.reason = checkNullandTrim(rs.getString("REAS_CODE"));
						cdnDetails.reason = "07-Others";//TODO sending hardcoded reason value, difficult to determine as per GSTN reason list
						if(rs.getDate("REF_DATE__INV").before(gstStartDate))
						{
							cdnDetails.isPreGSTInvoice = true;
						}
						cdnDetails.items = invLineItems;
						cdnDetails.taxPayerAction =  checkNullandTrim(rs.getString("SUBMISSION_TYPE"));
						cdnDetails.checksum =  checkNullandTrim(rs.getString("DOC_CHECKSUM"));
						
						cdnDetailsList.add(cdnDetails);
						
						cdnr = new CDNR();
						cdnr.isReverseCharge = false;
						cdnr.ctin = ctin;
						cdnr.cdnDetails = cdnDetailsList;
						
						cdnrList.add(cdnr);
					}
				}
				if("IMP_G".equalsIgnoreCase(udfStr1))
				{
					String sezGSTIN = "";
					
					lineSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(IGST_AMT) AS IGST_AMT, SUM(CGST_AMT) AS CGST_AMT, SUM(SGST_AMT) AS SGST_AMT, SUM(CESS_AMT) AS CESS_AMT, "
							+ " ITC_TYPE, SUM(ITC_IGST) AS ITC_IGST, SUM(ITC_CGST) AS ITC_CGST, SUM(ITC_SGST) AS ITC_SGST, SUM(ITC_CESS) AS ITC_CESS "
							+ " FROM GST_DATA_DET "
							+ " WHERE TRAN_ID = ? "
							+ " GROUP BY GST_RATE, ITC_TYPE ";
					linePstmt = conn.prepareStatement(lineSql);
					linePstmt.setString(1, tranId);
					lineRs = linePstmt.executeQuery();
					int lineNum = 0;
					while(lineRs.next())
					{
						invLineItem = new InvLineItem();
						invLineItem.num = ++lineNum;
						invLineItem.rate = lineRs.getDouble("GST_RATE");
						invLineItem.taxval = lineRs.getDouble("TAXABLE_AMT");
						invLineItem.iamt = lineRs.getDouble("IGST_AMT");
						invLineItem.camt = lineRs.getDouble("CGST_AMT");
						invLineItem.samt = lineRs.getDouble("SGST_AMT");
						invLineItem.csamt = lineRs.getDouble("CESS_AMT");
						invLineItem.itcType = checkNullandTrim(lineRs.getString("ITC_TYPE")).toLowerCase();
						invLineItem.igstInputTax = lineRs.getDouble("ITC_IGST");
						invLineItem.cgstInputTax = lineRs.getDouble("ITC_CGST");
						invLineItem.sgstInputTax = lineRs.getDouble("ITC_SGST");
						invLineItem.cessInputTax = lineRs.getDouble("ITC_CESS");
						
						invLineItems.add(invLineItem);
					}
					if(linePstmt != null)
					{
						linePstmt.close();
						linePstmt = null;
					}
					if(lineRs != null)
					{
						lineRs.close();
						lineRs = null;
					}
					
					impg = new IMPG();
					sezGSTIN = checkNullandTrim(rs.getString("TAX_REG_NO"));
					impg.sezGSTIN = sezGSTIN;
					if(sezGSTIN.length()>0)
					{
						impg.isSezImport = true;
					}
					else
					{
						impg.isSezImport = false;
					}
					impg.billOfEntryNo = checkNullandTrim(rs.getString("LR_NO"));
					impg.billOfEntryDate = rs.getDate("LR_DATE");
					impg.amount = rs.getDouble("AMOUNT");
					impg.portCode = checkNullandTrim(rs.getString("ORDER_NO"));
					impg.items = invLineItems;
					
					impgList.add(impg);
				}
				if("IMP_S".equalsIgnoreCase(udfStr1))
				{
					lineSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(IGST_AMT) AS IGST_AMT, SUM(CGST_AMT) AS CGST_AMT, SUM(SGST_AMT) AS SGST_AMT, SUM(CESS_AMT) AS CESS_AMT, "
							+ " ITC_TYPE, SUM(ITC_IGST) AS ITC_IGST, SUM(ITC_CGST) AS ITC_CGST, SUM(ITC_SGST) AS ITC_SGST, SUM(ITC_CESS) AS ITC_CESS "
							+ " FROM GST_DATA_DET "
							+ " WHERE TRAN_ID = ? "
							+ " GROUP BY GST_RATE, ITC_TYPE ";
					linePstmt = conn.prepareStatement(lineSql);
					linePstmt.setString(1, tranId);
					lineRs = linePstmt.executeQuery();
					int lineNum = 0;
					while(lineRs.next())
					{
						invLineItem = new InvLineItem();
						invLineItem.num = ++lineNum;
						invLineItem.rate = lineRs.getDouble("GST_RATE");
						invLineItem.taxval = lineRs.getDouble("TAXABLE_AMT");
						invLineItem.iamt = lineRs.getDouble("IGST_AMT");
						invLineItem.camt = lineRs.getDouble("CGST_AMT");
						invLineItem.samt = lineRs.getDouble("SGST_AMT");
						invLineItem.csamt = lineRs.getDouble("CESS_AMT");
						invLineItem.itcType = checkNullandTrim(lineRs.getString("ITC_TYPE")).toLowerCase();
						invLineItem.igstInputTax = lineRs.getDouble("ITC_IGST");
						invLineItem.cgstInputTax = lineRs.getDouble("ITC_CGST");
						invLineItem.sgstInputTax = lineRs.getDouble("ITC_SGST");
						invLineItem.cessInputTax = lineRs.getDouble("ITC_CESS");
						
						invLineItems.add(invLineItem);
					}
					if(linePstmt != null)
					{
						linePstmt.close();
						linePstmt = null;
					}
					if(lineRs != null)
					{
						lineRs.close();
						lineRs = null;
					}
					
					imps = new IMPS();
					imps.inum = checkNullandTrim(rs.getString("DOC_NO"));
					imps.idt = rs.getDate("DOC_DATE");
					imps.val = rs.getDouble("AMOUNT");
					imps.pos = checkNullandTrim(rs.getString("GST_CODE"));
					imps.items = invLineItems;
					
					impsList.add(imps);
				}
				if("TXPI".equalsIgnoreCase(udfStr1))
				{
					lineSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(IGST_AMT) AS IGST_AMT, SUM(CGST_AMT) AS CGST_AMT, SUM(SGST_AMT) AS SGST_AMT, SUM(CESS_AMT) AS CESS_AMT, "
							+ " ITC_TYPE, SUM(ITC_IGST) AS ITC_IGST, SUM(ITC_CGST) AS ITC_CGST, SUM(ITC_SGST) AS ITC_SGST, SUM(ITC_CESS) AS ITC_CESS "
							+ " FROM GST_DATA_DET "
							+ " WHERE TRAN_ID = ? "
							+ " GROUP BY GST_RATE, ITC_TYPE ";
					linePstmt = conn.prepareStatement(lineSql);
					linePstmt.setString(1, tranId);
					lineRs = linePstmt.executeQuery();
					int lineNum = 0;
					while(lineRs.next())
					{
						invLineItem = new InvLineItem();
						invLineItem.num = ++lineNum;
						invLineItem.rate = lineRs.getDouble("GST_RATE");
						invLineItem.taxval = lineRs.getDouble("TAXABLE_AMT");
						invLineItem.iamt = lineRs.getDouble("IGST_AMT");
						invLineItem.camt = lineRs.getDouble("CGST_AMT");
						invLineItem.samt = lineRs.getDouble("SGST_AMT");
						invLineItem.csamt = lineRs.getDouble("CESS_AMT");
						
						invLineItems.add(invLineItem);
					}
					if(linePstmt != null)
					{
						linePstmt.close();
						linePstmt = null;
					}
					if(lineRs != null)
					{
						lineRs.close();
						lineRs = null;
					}
					
					at = new AT();
					at.isReverseCharge = false;
					
					at.recType = "2";
					at.pos = checkNullandTrim(rs.getString("GST_CODE"));
					at.supplyType = udfStr2;
					at.itms = invLineItems;
					
					txiList.add(at);
				}
				if("TXPD".equalsIgnoreCase(udfStr1))
				{
					lineSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(IGST_AMT) AS IGST_AMT, SUM(CGST_AMT) AS CGST_AMT, SUM(SGST_AMT) AS SGST_AMT, SUM(CESS_AMT) AS CESS_AMT, "
							+ " ITC_TYPE, SUM(ITC_IGST) AS ITC_IGST, SUM(ITC_CGST) AS ITC_CGST, SUM(ITC_SGST) AS ITC_SGST, SUM(ITC_CESS) AS ITC_CESS "
							+ " FROM GST_DATA_DET "
							+ " WHERE TRAN_ID = ? "
							+ " GROUP BY GST_RATE, ITC_TYPE ";
					linePstmt = conn.prepareStatement(lineSql);
					linePstmt.setString(1, tranId);
					lineRs = linePstmt.executeQuery();
					int lineNum = 0;
					while(lineRs.next())
					{
						invLineItem = new InvLineItem();
						invLineItem.num = ++lineNum;
						invLineItem.rate = lineRs.getDouble("GST_RATE");
						invLineItem.taxval = lineRs.getDouble("TAXABLE_AMT");
						invLineItem.iamt = lineRs.getDouble("IGST_AMT");
						invLineItem.camt = lineRs.getDouble("CGST_AMT");
						invLineItem.samt = lineRs.getDouble("SGST_AMT");
						invLineItem.csamt = lineRs.getDouble("CESS_AMT");
						
						invLineItems.add(invLineItem);
					}
					if(linePstmt != null)
					{
						linePstmt.close();
						linePstmt = null;
					}
					if(lineRs != null)
					{
						lineRs.close();
						lineRs = null;
					}
					
					at = new AT();
					at.isReverseCharge = false;
					
					at.recType = "2";
					at.pos = checkNullandTrim(rs.getString("GST_CODE"));
					at.supplyType = udfStr2;
					at.itms = invLineItems;
					
					txpdList.add(at);
				}
				if("CDNUR".equalsIgnoreCase(udfStr1))
				{
					Calendar calendar = Calendar.getInstance();
					calendar.set(2017, 06, 01);
					Date gstStartDate = calendar.getTime();
					
					lineSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(IGST_AMT) AS IGST_AMT, SUM(CGST_AMT) AS CGST_AMT, SUM(SGST_AMT) AS SGST_AMT, SUM(CESS_AMT) AS CESS_AMT, "
							+ " ITC_TYPE, SUM(ITC_IGST) AS ITC_IGST, SUM(ITC_CGST) AS ITC_CGST, SUM(ITC_SGST) AS ITC_SGST, SUM(ITC_CESS) AS ITC_CESS "
							+ " FROM GST_DATA_DET "
							+ " WHERE TRAN_ID = ? "
							+ " GROUP BY GST_RATE, ITC_TYPE ";
					linePstmt = conn.prepareStatement(lineSql);
					linePstmt.setString(1, tranId);
					lineRs = linePstmt.executeQuery();
					int lineNum = 0;
					while(lineRs.next())
					{
						invLineItem = new InvLineItem();
						invLineItem.num = ++lineNum;
						invLineItem.rate = lineRs.getDouble("GST_RATE");
						invLineItem.taxval = lineRs.getDouble("TAXABLE_AMT");
						invLineItem.iamt = lineRs.getDouble("IGST_AMT");
						invLineItem.camt = lineRs.getDouble("CGST_AMT");
						invLineItem.samt = lineRs.getDouble("SGST_AMT");
						invLineItem.csamt = lineRs.getDouble("CESS_AMT");
						invLineItem.itcType = checkNullandTrim(lineRs.getString("ITC_TYPE")).toLowerCase();
						invLineItem.igstInputTax = lineRs.getDouble("ITC_IGST");
						invLineItem.cgstInputTax = lineRs.getDouble("ITC_CGST");
						invLineItem.sgstInputTax = lineRs.getDouble("ITC_SGST");
						invLineItem.cessInputTax = lineRs.getDouble("ITC_CESS");
						
						invLineItems.add(invLineItem);
					}
					if(linePstmt != null)
					{
						linePstmt.close();
						linePstmt = null;
					}
					if(lineRs != null)
					{
						lineRs.close();
						lineRs = null;
					}
					
					cdnur = new CDNUR();
					cdnur.isReverseCharge = false;
					cdnur.recType = "2";
					
					cdnur.receiverGSTIN = checkNullandTrim(rs.getString("TAX_REG_NO"));
					cdnur.cdnNoteType = udfStr2;
					cdnur.cdNoteNumber = checkNullandTrim(rs.getString("DOC_NO"));
					cdnur.cdNoteDate = rs.getDate("DOC_DATE");
					cdnur.invoiceNumber = checkNullandTrim(rs.getString("REF_ID__INV"));
					cdnur.invoiceDate = rs.getDate("REF_DATE__INV");
					cdnur.val = rs.getDouble("AMOUNT");
					//cdnur.reason = checkNullandTrim(rs.getString("REAS_CODE"));
					cdnur.reason = "07-Others";//TODO sending hardcoded reason value, difficult to determine as per GSTN reason list
					if(rs.getDate("REF_DATE__INV").before(gstStartDate))
					{
						cdnur.isPreGSTInvoice = true;
					}
					cdnur.items = invLineItems;
					
					cdnurList.add(cdnur);
				}
				
				tranIdList.add(tranId);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			
			if(isDataFound)
			{
				//HSN summary data will be sent every time
				//Changed by Santosh on 08/09/17 to subtract debit note in HSN summary
				/*sql = " SELECT GDD.GS_CODE, GDD.GS_DESCR, GDD.UNIT, SUM(GDD.QUANTITY) AS TOT_QTY, SUM(GDD.TAXABLE_AMT) AS TOT_TAXVAL,"
					+ " SUM(GDD.IGST_AMT) AS TOT_IAMT, SUM(CGST_AMT) AS TOT_CAMT, SUM(SGST_AMT) AS TOT_SAMT, SUM(CESS_AMT) AS TOT_CSAMT"
					+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD"
					+ " WHERE GDH.TRAN_ID = GDD.TRAN_ID AND GDD.GS_CODE IS NOT NULL AND GDH.REC_TYPE='2'"
					+ " AND GDH.SITE_CODE = ? AND GDH.PRD_CODE = ?"
					+ " GROUP BY GDD.GS_CODE, GDD.GS_DESCR, GDD.UNIT";*/
				
				sql = " SELECT GS_CODE, GS_DESCR, UNIT, SUM(TOT_QTY) AS TOT_QTY, SUM(TOT_TAXVAL) AS TOT_TAXVAL, SUM(TOT_IAMT) AS TOT_IAMT, SUM(TOT_CAMT) AS TOT_CAMT, SUM(TOT_SAMT) AS TOT_SAMT, SUM(TOT_CSAMT) AS TOT_CSAMT FROM"
					+ " (SELECT GDD.GS_CODE, GDD.GS_DESCR, GDD.UNIT, SUM(GDD.QUANTITY) AS TOT_QTY, SUM(GDD.TAXABLE_AMT) AS TOT_TAXVAL,"
					+ " SUM(GDD.IGST_AMT) AS TOT_IAMT, SUM(CGST_AMT) AS TOT_CAMT, SUM(SGST_AMT) AS TOT_SAMT, SUM(CESS_AMT) AS TOT_CSAMT"
					+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD"
					+ " WHERE GDH.TRAN_ID = GDD.TRAN_ID AND GDD.GS_CODE IS NOT NULL AND GDH.REC_TYPE='2'"
					+ " AND GDH.SITE_CODE = ? AND GDH.PRD_CODE = ? AND GDH.TRAN_TYPE NOT IN ('10','11')"
					+ " GROUP BY GDD.GS_CODE, GDD.GS_DESCR, GDD.UNIT"
					+ " UNION ALL"
					+ " SELECT GDD.GS_CODE, GDD.GS_DESCR, GDD.UNIT, -1*SUM(GDD.QUANTITY) AS TOT_QTY, -1*SUM(GDD.TAXABLE_AMT) AS TOT_TAXVAL,"
					+ " -1*SUM(GDD.IGST_AMT) AS TOT_IAMT, -1*SUM(CGST_AMT) AS TOT_CAMT, -1*SUM(SGST_AMT) AS TOT_SAMT, -1*SUM(CESS_AMT) AS TOT_CSAMT"
					+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD"
					+ " WHERE GDH.TRAN_ID = GDD.TRAN_ID AND GDD.GS_CODE IS NOT NULL AND GDH.REC_TYPE='2'"
					+ " AND GDH.SITE_CODE = ? AND GDH.PRD_CODE = ? AND GDH.TRAN_TYPE IN ('10','11')"
					+ " GROUP BY GDD.GS_CODE, GDD.GS_DESCR, GDD.UNIT) GROUP BY GS_CODE, GS_DESCR, UNIT";
				
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, siteCode);
				pstmt.setString(2, periodCode);
				pstmt.setString(3, siteCode);
				pstmt.setString(4, periodCode);
				rs = pstmt.executeQuery();
				
				while (rs.next()) 
				{
					hsnDetails = new HSNDetails();
					
					hsnDetails.num = ++num;
					hsnDetails.itemOrServiceCode = checkNullandTrim(rs.getString("GS_CODE"));
					hsnDetails.description = checkNullandTrim(rs.getString("GS_DESCR"));
					hsnDetails.unitOfMeasure = checkNullandTrim(rs.getString("UNIT"));
					hsnDetails.quantity = rs.getDouble("TOT_QTY");
					hsnDetails.totalAmount = rs.getDouble("TOT_TAXVAL") + rs.getDouble("TOT_IAMT") + rs.getDouble("TOT_CAMT") + rs.getDouble("TOT_SAMT") + rs.getDouble("TOT_CSAMT");
					hsnDetails.totalTaxableAmount = rs.getDouble("TOT_TAXVAL");
					hsnDetails.totalIGSTAmount = rs.getDouble("TOT_IAMT");
					hsnDetails.totalCGSTAmount = rs.getDouble("TOT_CAMT");
					hsnDetails.totalSGSTAmount = rs.getDouble("TOT_SAMT");
					hsnDetails.totalCESSAmount = rs.getDouble("TOT_CSAMT");
					
					hsnList.add(hsnDetails);
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				
				if(hsnList.size() > 0)
				{
					hsn = new HSN();
					hsn.recType = "2";
					hsn.hsnDetails = hsnList;
				}
				
				InterNilSupplies interNilSupplies = getInterNilRateSummary("18", "19", "20", "21", siteCode, periodCode, conn);
				IntraNilSupplies intraNilSupplies = getIntraNilRateSummary("22", "23", "24", "25", siteCode, periodCode, conn);
				
				if(interNilSupplies != null || intraNilSupplies != null)
				{
					nilInwardSupplies = new NilInwardSupplies();
					nilInwardSupplies.interNilSupplies = interNilSupplies;
					nilInwardSupplies.intraNilSupplies = intraNilSupplies;
				}
				
				gstr2 = new GSTR2();
				gstr2.gstin = gstin;
				gstr2.financialPeriod = periodCode;
				
				//Summary of Nil rated inward supplies
				
				if(b2bInvoiceList.size() > 0)
				{
					gstr2.b2b = b2bInvoiceList;
				}
				if(b2burInvoiceList.size() > 0)
				{
					gstr2.b2bur = b2burInvoiceList;
				}
				if(cdnrList.size() > 0)
				{
					gstr2.cdnr = cdnrList;
				}
				if(hsn != null)
				{
					gstr2.hsn = hsn;
				}
				if(impgList.size() > 0)
				{
					gstr2.impg = impgList;
				}
				if(impsList.size()>0)
				{
					gstr2.imps = impsList;
				}
				if(nilInwardSupplies != null)
				{
					gstr2.nil = nilInwardSupplies;
				}
				if(txiList.size()>0)
				{
					gstr2.txi = txiList;
				}
				if(txpdList.size()>0)
				{
					gstr2.txpd = txpdList;
				}
				if(cdnurList.size()>0)
				{
					gstr2.cdnur = cdnurList;
				}
				
				ObjectMapper objectMapper = new ObjectMapper();
				
				String json = objectMapper.writeValueAsString(gstr2);
				
				System.out.println("jsonPayload to SAVE GSTR2["+json+"]");
				
				retString = saveGSTRData(json, noOfRecords, tranIdList, "2", conn, xtraParams);
			}
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.saveGstr2()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}
	private String generateGSTR3(String xtraParams, Connection conn) throws ITMException
	{
		String retString = "";
		String siteCode = "", loginCode = "", transactionId = "", chgTerm = "", gspAuthString = "", gspAuthSignature="", callStatus = "", errMsg = "",
			   responseId = "";
		try
		{
			siteCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			
			transactionId = UUID.randomUUID().toString().replaceAll("-", "");
			long timeStamp = new Timestamp().getDateTime();
			gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin;
			gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
			
			HttpRequest generateGSTR3Req = Unirest.get(String.format("%s%s", BASE_API_URL, GSTR3_URL))
										   .queryString("gstin", gstin)
										   .queryString("ret_period",periodCode)
										   .queryString("action","GENERATE")
										   .header("Content-Type", APPLICATION_JSON)
										   .header("state-cd", stateCode)
										   .header("clientid", clientId)
										   .header("client-secret", clientSecret)
										   .header("ip-usr", ipAddress)
										   .header("username", userName)
										   .header("auth-token", authToken)
										   .header("txn", transactionId)
										   .header("ret_period", periodCode)
										   .header("gstin", gstin)
										   .header("X-Asp-Auth-Token", gspAuthString)
										   .header("X-Asp-Auth-Signature", gspAuthSignature)
										   .getHttpRequest();
			
			System.out.println("GENERATE GSTR3 for ["+gstin+"] for ["+periodCode+"] url["+generateGSTR3Req.getUrl()+"]");
	        System.out.println("GENERATE GSTR3 method["+generateGSTR3Req.getHttpMethod()+"]");
			System.out.println("GENERATE GSTR3 request header["+generateGSTR3Req.getHeaders()+"]");
			
			HttpResponse<JsonNode> generateGSTR3Resp = generateGSTR3Req.asJson();

			System.out.println(String.format("generateGSTR3Resp Request : Status[%s] Response[%s]", generateGSTR3Resp.getStatus(), generateGSTR3Resp.getBody()));
			
			if (generateGSTR3Resp.getStatus() == 200) 
			{
				JSONObject generateGSTR3RespObj = generateGSTR3Resp.getBody().getObject();
				if(generateGSTR3RespObj.has("data") && generateGSTR3RespObj.has("rek"))
				{	
					callStatus = "1";
					String generateGstr3Data = generateGSTR3RespObj.getString("data");
					String generateGstr3Rek = generateGSTR3RespObj.getString("rek");

					byte[] generateGstr3ApiEK = aesEncryption.decrypt(generateGstr3Rek, authSEK);

					String generateGstr3JsoninBase64 = new String(aesEncryption.decrypt(generateGstr3Data, generateGstr3ApiEK));

					byte[] generateGstr3JsonInBytes = aesEncryption.decodeBase64StringTOByte(generateGstr3JsoninBase64);

					JSONObject generateGstr3JsonObj = new JSONObject(new String(generateGstr3JsonInBytes));
					
					System.out.println("560101.generateGstr3JsonObj["+generateGstr3JsonObj+"]");
					
					if(generateGstr3JsonObj.has("ref_id"))
					{
						responseId = generateGstr3JsonObj.getString("ref_id");
					}
				}
				else
				{
					callStatus = "2";
					JSONObject errorJSON = generateGSTR3Resp.getBody().getObject();
					if(errorJSON.has("error"))
					{
						JSONObject tempJsonObj = errorJSON.getJSONObject("error");
						
						if(tempJsonObj.has("message"))
						{
							errMsg = tempJsonObj.getString("message");
							retString = "<data_error><![CDATA["+errMsg+"]]></data_error>";
						}
					}
				}
			}
			else
			{
				callStatus = "2";
				JSONObject errorJSON = generateGSTR3Resp.getBody().getObject();
				if(errorJSON.has("error"))
				{
					JSONObject tempJsonObj = errorJSON.getJSONObject("error");
					
					if(tempJsonObj.has("message"))
					{
						errMsg = tempJsonObj.getString("message");
						retString = "<data_error><![CDATA["+errMsg+"]]></data_error>";
					}
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.generateGSTR3()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			APICallData apiCallData = new APICallData();
	        apiCallData.setPeriodCode(periodCode);
	        apiCallData.setCallDate(new Date());
	        apiCallData.setSiteCode(siteCode);
	        apiCallData.setUserId(loginCode);
	        apiCallData.setCallType("GENERATE_GSTR3");
	        apiCallData.setRecType("3");
	        apiCallData.setNoOfRecords(0);
	        apiCallData.setCallStatus(callStatus);
	        apiCallData.setResponseId(responseId);
	        apiCallData.setResponseJsonStr(errMsg);
	        apiCallData.setChgUser(loginCode);
	        apiCallData.setChgDate(new Date());
	        apiCallData.setChgTerm(chgTerm);
	        
	        gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
		}
		return retString;
	}
	private String getDataFromFileServer(String recType, JSONObject dataJSONObject, String sectionName, String xtraParams, Connection conn) throws ITMException
	{
		String retString = null;
		String transactionId = "", gspAuthString = "", gspAuthSignature = "";
		String siteCode = "", loginCode = "", chgTerm = "", responseId = "", responseJsonStr = "", callStatus = "";
		String sep = File.separator;
		try
		{
			siteCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			
			File baseFolder = new File(fileDownloadDir);
			
			if(!baseFolder.exists())
			{
				boolean isFoldercreated = baseFolder.mkdirs();
				System.out.println("isFoldercreated="+isFoldercreated);
			}
			
			saveFilePath = baseFolder.getPath();
			
			System.out.println("saveFilePath ["+saveFilePath+"]");
			
			File sectionFolder = new File(saveFilePath + sep + gstin + sep + periodCode + sep +"GSTR2A" + sep + sectionName);
			if(!sectionFolder.exists())
			{
				sectionFolder.mkdirs();
				System.out.println("section folder created for ["+sectionName+"]");
			}
			
			transactionId = UUID.randomUUID().toString().replaceAll("-", "");
			long timeStamp = new Timestamp().getDateTime();
			gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin;
			gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);

			HttpRequest fileDetailsReq = Unirest.get(String.format("%s%s", BASE_API_URL, GSTR_RETSTAT_URL))
										.queryString("gstin", gstin)
										.queryString("ret_period",periodCode)
										.queryString("token",dataJSONObject.getString("token"))
										.queryString("action","FILEDET")
										.header("Content-Type", APPLICATION_JSON)
										.header("state-cd", stateCode)
										.header("clientid", clientId)
										.header("client-secret", clientSecret)
										.header("ip-usr", ipAddress)
										.header("username", userName)
										.header("auth-token", authToken)
										.header("txn", transactionId)
										.header("ret_period", periodCode)
										.header("gstin", gstin)
										.header("X-Asp-Auth-Token", gspAuthString)
										.header("X-Asp-Auth-Signature", gspAuthSignature)
										.getHttpRequest();
			
			System.out.println("download file url["+fileDetailsReq.getUrl()+"]");
	        System.out.println("download file method["+fileDetailsReq.getHttpMethod()+"]");
			System.out.println("download file request header["+fileDetailsReq.getHeaders()+"]");

			HttpResponse<JsonNode> fileDetailsResp = fileDetailsReq.asJson();
			
			System.out.println(String.format("fileDetailsResp Request : Status[%s] Response[%s]", fileDetailsResp.getStatus(), fileDetailsResp.getBody()));
			
			if (fileDetailsResp.getStatus() == 200) 
			{
				JSONObject fileGstr1RespObj = fileDetailsResp.getBody().getObject();
				if(fileGstr1RespObj.has("data") && fileGstr1RespObj.has("rek"))
				{	
					callStatus = "1";
					String fileGstr1Data = fileGstr1RespObj.getString("data");
					String fileGstr1Rek = fileGstr1RespObj.getString("rek");

					byte[] fileGstr1ApiEK = aesEncryption.decrypt(fileGstr1Rek, authSEK);

					String fileGstr1JsoninBase64 = new String(aesEncryption.decrypt(fileGstr1Data, fileGstr1ApiEK));

					byte[] fileGstr1JsonInBytes = aesEncryption.decodeBase64StringTOByte(fileGstr1JsoninBase64);

					JSONObject filedetailsJsonObj = new JSONObject(new String(fileGstr1JsonInBytes));

					if(filedetailsJsonObj.has("urls")&&filedetailsJsonObj.has("ek"))
					{
						String sessionKey = filedetailsJsonObj.getString("ek");
						JSONArray fileDetailsArry = filedetailsJsonObj.getJSONArray("urls");

						System.out.println("sessionKey["+sessionKey+"]");
						
						for(int i=0; i<fileDetailsArry.length(); i++)
						{
							String fileName = "", filePath = "";
							
							JSONObject tempJsonObj = fileDetailsArry.getJSONObject(i);

							if(tempJsonObj.has("ul"))
							{
								String fileUrl = tempJsonObj.getString("ul");
								fileUrl = FILEDET_URL + fileUrl;
								URL url = new URL(fileUrl);
								HttpURLConnection connection = (HttpURLConnection) url.openConnection();

								int responseCode = connection.getResponseCode();
								if (responseCode == HttpURLConnection.HTTP_OK) 
								{
									String disposition = connection.getHeaderField("Content-Disposition");

									if (disposition != null) 
									{
										int index = disposition.indexOf("filename=");
										if (index > 0)
										{
											fileName = disposition.substring(index + 10, disposition.length() - 1);
										}
									} 
									else 
									{
										fileName = fileUrl.substring(fileUrl.lastIndexOf("/") + 1,fileUrl.lastIndexOf("?"));
									}

									InputStream inputStream = connection.getInputStream();
									
									filePath = sectionFolder.getPath()+ sep + fileName;
									
									System.out.println("Json file save path["+filePath+"]");
									
									FileOutputStream outputStream = new FileOutputStream(filePath);

									int bytesRead = -1;
									byte[] buffer = new byte[1024];
									while ((bytesRead = inputStream.read(buffer)) != -1) 
									{
										outputStream.write(buffer, 0, bytesRead);
									}

									outputStream.close();
									inputStream.close();
								}

								TarArchiveInputStream tarInput = new TarArchiveInputStream(new GzipCompressorInputStream(new FileInputStream(filePath)));
								TarArchiveEntry currentEntry = tarInput.getNextTarEntry();
								BufferedReader br = null;
								while (currentEntry != null) 
								{
									br = new BufferedReader(new InputStreamReader(tarInput));
									String line;
									while ((line = br.readLine()) != null) 
									{
										byte[] decryptEK =  aesEncryption.decodeBase64StringTOByte(sessionKey);
										String decryptedData = new String(aesEncryption.decrypt(line, decryptEK));
										String decodedJson = new String(org.apache.commons.codec.binary.Base64.decodeBase64(decryptedData));

										JSONObject insertDataJson = new JSONObject(decodedJson);
										
										if("B2B".equalsIgnoreCase(sectionName))
										{
											insertB2BInvoiceData(stateCode, periodCode, siteCode, insertDataJson, xtraParams, conn);
										}
										else if("CDN".equalsIgnoreCase(sectionName))
										{
											insertCDNData(stateCode, periodCode, siteCode, insertDataJson, xtraParams, conn);
										}
									}
									currentEntry = tarInput.getNextTarEntry();
								}
								tarInput.close();
							}
						}
					}
				}
				else
				{
					String errMsg = "";
					callStatus = "2";
					JSONObject errorJSON = fileDetailsResp.getBody().getObject();
					if(errorJSON.has("error"))
					{
						JSONObject tempJsonObj = errorJSON.getJSONObject("error");
						
						if(tempJsonObj.has("message"))
						{
							errMsg = tempJsonObj.getString("message");
							retString = "<data_error><![CDATA["+errMsg+"]]></data_error>";
						}
					}
				}
			}
			else
			{
				String errMsg = "";
				callStatus = "2";
				JSONObject errorJSON = fileDetailsResp.getBody().getObject();
				if(errorJSON.has("error"))
				{
					JSONObject tempJsonObj = errorJSON.getJSONObject("error");
					
					if(tempJsonObj.has("message"))
					{
						errMsg = tempJsonObj.getString("message");
						retString = "<data_error><![CDATA["+errMsg+"]]></data_error>";
					}
				}
			}
			
			APICallData apiCallData = new APICallData();
	        apiCallData.setPeriodCode(periodCode);
	        apiCallData.setCallDate(new Date());
	        apiCallData.setSiteCode(siteCode);
	        apiCallData.setUserId(loginCode);
	        apiCallData.setCallType("FILEDET");
	        apiCallData.setRecType(recType);
	        apiCallData.setNoOfRecords(0);
	        apiCallData.setCallStatus(callStatus);
	        apiCallData.setResponseId(responseId);
	        apiCallData.setResponseJsonStr(responseJsonStr);
	        apiCallData.setChgUser(loginCode);
	        apiCallData.setChgDate(new Date());
	        apiCallData.setChgTerm(chgTerm);
	        
	        gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.getDataFromFileServer()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("final retString["+retString+"]");
		return retString;
	}
	/*private String submitGstr2(String xtraParams,Connection conn) throws ITMException
	{
		String retString = "";
		String errMsg = "", gspAuthString = "", gspAuthSignature = "";
		String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
		String loginCode = "", chgTerm = "", siteCode = "", callStatus = "", responseJsonStr = "", responseId = "";
		
		String sql = "";
		PreparedStatement pstmt = null;
		int updateCnt = 0;
		
		try
		{
			
			siteCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			
			String json = "{\"gstin\":\""+gstin+"\",\"ret_period\":\""+periodCode+"\"}";
            
            byte[] jsonBase64 = Base64.getEncoder().encode(json.getBytes());
			String encryptedPayload = aesEncryption.encryptEK(jsonBase64, authSEK);
			 
			HMac hmac = new HMac(new SHA256Digest());
			byte[] resBuf = new byte[hmac.getMacSize()];
			
			hmac.init(new KeyParameter(authSEK));
			hmac.update(jsonBase64, 0, jsonBase64.length);
			hmac.doFinal(resBuf, 0);
            
			JSONObject reqBody = new JSONObject();
            reqBody.put("action", "RETSUBMIT");
            reqBody.put("data", encryptedPayload);
            reqBody.put("hmac", new String(Base64.getEncoder().encode(resBuf)));
            
            long timeStamp = new Timestamp().getDateTime();
	        gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin;
			gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
			
            HttpRequest gstr2SubmitReq = Unirest.post(String.format("%s%s", BASE_API_URL, GSTR2_URL))
										.header("Content-Type", APPLICATION_JSON)
										.header("action", "RETSUBMIT")
				                        .header("state-cd", stateCode)
				                        .header("clientid", clientId)
				                        .header("client-secret", clientSecret)
				                        .header("ip-usr", ipAddress)
				                        .header("username", userName)
				                        .header("auth-token", authToken)
				                        .header("txn", transactionId)
				                        .header("ret_period", periodCode)
				                        .header("gstin", gstin)
				                        .header("X-Asp-Auth-Token", gspAuthString)
				                        .header("X-Asp-Auth-Signature", gspAuthSignature)
				                        .body(new JsonNode(reqBody.toString()))
				                        .getHttpRequest();
            
            System.out.println("RETSUBMIT GSTR2 url["+gstr2SubmitReq.getUrl()+"]");
			System.out.println("RETSUBMIT GSTR2 method["+gstr2SubmitReq.getHttpMethod()+"]");
			System.out.println("RETSUBMIT GSTR2 request header["+gstr2SubmitReq.getHeaders()+"]");
			System.out.println("RETSUBMIT GSTR2 request payload["+IOUtils.toString(gstr2SubmitReq.getBody().getEntity().getContent())+"]");
			
			HttpResponse<JsonNode> gstr2SubmitResp = gstr2SubmitReq.asJson();
            
            System.out.println(String.format("gstr2SubmitResp Request : Status[%s] Response[%s]", gstr2SubmitResp.getStatus(), gstr2SubmitResp.getBody()));
            
            if (gstr2SubmitResp.getStatus() == 200) 
	        {
				JSONObject gstr2SubmitRespObj = gstr2SubmitResp.getBody().getObject();
				if(gstr2SubmitRespObj.has("data") && gstr2SubmitRespObj.has("rek"))
				{
					callStatus = "1";
					String gstr2Submitdata = gstr2SubmitRespObj.getString("data");
					String gstr2Submitrek = gstr2SubmitRespObj.getString("rek");
					
					byte[] apiEK = aesEncryption.decrypt(gstr2Submitrek, authSEK);
					String respJsoninBase64 = new String(aesEncryption.decrypt(gstr2Submitdata, apiEK));
					
					byte[] respJsonInBytes = aesEncryption.decodeBase64StringTOByte(respJsoninBase64);
					
					JSONObject gstr2SubmitObj = new JSONObject(new String(respJsonInBytes));
					String transId = gstr2SubmitObj.getString("reference_id");
					responseId = transId;
					System.out.println("transId to getStatus after SUBMIT call["+transId+"]");
					
					sql = "UPDATE GST_DATA_HDR SET SUBMIT_STATUS = ? AND SUBMIT_DATE = ? WHERE PRD_CODE = ? AND SITE_CODE = ? AND REC_TYPE = '2'";
					pstmt = conn.prepareStatement(sql);
					
					pstmt.setString(1, "S");
					pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(e12GenericUtility.getValidDateString(new Date(), e12GenericUtility.getDBDateTimeFormat())));
					pstmt.setString(3, periodCode);
					pstmt.setString(4, siteCode);
					
					updateCnt = pstmt.executeUpdate();
					
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
					
					System.out.println("submit status updated of ["+siteCode+"] for ["+periodCode+"] update count ["+updateCnt+"]");
					
				}
				else
	            {
					callStatus = "2";
					JSONObject errorJSON = gstr2SubmitResp.getBody().getObject().getJSONObject("error");
					responseJsonStr = errorJSON.toString();
		        	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
		        	retString = getError(errMsg, "GSTAPIERR", conn);
	            }
	        }
            else if(gstr2SubmitResp.getStatus() == 500)
	        {
	        	callStatus = "2";
	        	errMsg = "Message : Error occurred at GSTN server \nResponse code : "+gstr2SubmitResp.getStatus();
	        	responseJsonStr = errMsg;
	        	retString = getError(errMsg, "GSTAPIERR", conn);
	        }
			else
            {
				callStatus = "2";
            	JSONObject errorJSON = gstr2SubmitResp.getBody().getObject().getJSONObject("error");
            	responseJsonStr = errorJSON.toString();
            	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
	        	retString = getError(errMsg, "GSTAPIERR", conn);
            }
            
            APICallData apiCallData = new APICallData();
	        apiCallData.setPeriodCode(periodCode);
	        apiCallData.setCallDate(new Date());
	        apiCallData.setSiteCode(siteCode);
	        apiCallData.setUserId(loginCode);
	        apiCallData.setCallType("RETSUBMIT");
	        apiCallData.setRecType("2");
	        apiCallData.setNoOfRecords(0);
	        apiCallData.setCallStatus(callStatus);
	        apiCallData.setResponseId(responseId);
	        apiCallData.setResponseJsonStr(responseJsonStr);
	        apiCallData.setChgUser(loginCode);
	        apiCallData.setChgDate(new Date());
	        apiCallData.setChgTerm(chgTerm);
	        
	        gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.submitGstr2()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}*/
	/*private String fileGstr2(String summaryData, String signedData, String panNo, String aadhaarNo, String signMethod, String xtraParams, Connection conn) throws ITMException
	{
		String retString = "";
		String errMsg = "", gspAuthString = "", gspAuthSignature = "", signType = "",signId = "";
		String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
		String loginCode = "", chgTerm = "", siteCode = "", callStatus = "", responseJsonStr = "";
		
		try
		{
			siteCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			
			long timeStamp = new Timestamp().getDateTime();
	        gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin;
			gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
			
			byte[] jsonBase64 = Base64.getEncoder().encode(summaryData.toString().getBytes());
			String encryptedPayload = aesEncryption.encryptEK(jsonBase64, authSEK);
			
			HMac hmac = new HMac(new SHA256Digest());
			byte[] resBuf = new byte[hmac.getMacSize()];
			
			hmac.init(new KeyParameter(authSEK));
			hmac.update(jsonBase64, 0, jsonBase64.length);
			hmac.doFinal(resBuf, 0);
			
			if("D".equalsIgnoreCase(signMethod))
			{
				signType = "DSC";
				signId = panNo;
			}
			else if("E".equalsIgnoreCase(signMethod))
			{
				signType = "ESIGN";
				signId = aadhaarNo;
			}
			
			JSONObject fileGstr2DataJsonObj = new JSONObject();
			fileGstr2DataJsonObj.put("action", "RETFILE");
			fileGstr2DataJsonObj.put("data", encryptedPayload);
			fileGstr2DataJsonObj.put("hmac", new String(Base64.getEncoder().encode(resBuf)));
			fileGstr2DataJsonObj.put("sign", signedData);
			fileGstr2DataJsonObj.put("st", signType);
			fileGstr2DataJsonObj.put("sid", signId);
			
			HttpRequest fileGstr2Req = Unirest.post(String.format("%s%s", BASE_API_URL, GSTR2_URL))
									   .header("Content-Type", APPLICATION_JSON)
									   .header("state-cd", stateCode)
									   .header("clientid", clientId)
									   .header("client-secret", clientSecret)
									   .header("ip-usr", ipAddress)
									   .header("username", userName)
									   .header("auth-token", authToken)
									   .header("txn", transactionId)
									   .header("ret_period", periodCode)
									   .header("gstin", gstin)
									   .header("X-Asp-Auth-Token", gspAuthString)
									   .header("X-Asp-Auth-Signature", gspAuthSignature)
									   .body(new JsonNode(fileGstr2DataJsonObj.toString()))
									   .getHttpRequest();
			
			System.out.println("FILE GSTR2 url["+fileGstr2Req.getUrl()+"]");
			System.out.println("FILE GSTR2 method["+fileGstr2Req.getHttpMethod()+"]");
			System.out.println("FILE GSTR2 request header["+fileGstr2Req.getHeaders()+"]");
			System.out.println("FILE GSTR2 request payload["+IOUtils.toString(fileGstr2Req.getBody().getEntity().getContent())+"]");
			
			HttpResponse<JsonNode> fileGstr2Resp = fileGstr2Req.asJson();

			System.out.println(String.format("fileGstr2Resp Request : Status[%s] Response[%s]", fileGstr2Resp.getStatus(), fileGstr2Resp.getBody()));
			if (fileGstr2Resp.getStatus() == 200) 
			{
				JSONObject fileGstr2RespObj = fileGstr2Resp.getBody().getObject();
				if(fileGstr2RespObj.has("data") && fileGstr2RespObj.has("rek"))
				{
					callStatus = "1";
					String fileGstr2Data = fileGstr2RespObj.getString("data");
					String fileGstr2Rek = fileGstr2RespObj.getString("rek");

					byte[] fileGstr2ApiEK = aesEncryption.decrypt(fileGstr2Rek, authSEK);

					String fileGstr2JsoninBase64 = new String(aesEncryption.decrypt(fileGstr2Data, fileGstr2ApiEK));

					byte[] fileGstr2JsonInBytes = aesEncryption.decodeBase64StringTOByte(fileGstr2JsoninBase64);

					System.out.println(new String(fileGstr2JsonInBytes));
				}
				else
				{
					callStatus = "2";
					JSONObject errorJSON = fileGstr2Resp.getBody().getObject().getJSONObject("error");
					responseJsonStr = errorJSON.toString();
					errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
					retString = getError(errMsg, "GSTAPIERR", conn);
				}
			}
			else
			{
				callStatus = "2";
				JSONObject errorJSON = fileGstr2Resp.getBody().getObject().getJSONObject("error");
				responseJsonStr = errorJSON.toString();
				errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
				retString = getError(errMsg, "GSTAPIERR", conn);
			}
			
			APICallData apiCallData = new APICallData();
			apiCallData.setPeriodCode(periodCode);
			apiCallData.setCallDate(new Date());
			apiCallData.setSiteCode(siteCode);
			apiCallData.setUserId(loginCode);
			apiCallData.setCallType("RETFILE");
			apiCallData.setRecType("2");
			apiCallData.setNoOfRecords(0);
			apiCallData.setCallStatus(callStatus);
			apiCallData.setResponseId("");
			apiCallData.setResponseJsonStr(responseJsonStr);
			apiCallData.setChgUser(loginCode);
			apiCallData.setChgDate(new Date());
			apiCallData.setChgTerm(chgTerm);
			
			gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
			
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.fileGstr2()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		
		return retString;
	}*/
	private String createGstr3bJson(String siteCode, String xtraParams, Connection conn) throws ITMException
	{
		String retString = "";
		GSTR3B gstr3b = null;
		List<InterStateSuppliesData> interStateSuppliesDataList = new ArrayList<InterStateSuppliesData>();
		List<ITCData> itcAvlDataList = new ArrayList<ITCData>();
		List<ITCData> itcRevDataList = new ArrayList<ITCData>();
		List<ITCData> itcInelgDataList = new ArrayList<ITCData>();
		List<InwardSuppliesDetails> inwardSuppliesList = new ArrayList<InwardSuppliesDetails>();
		
		
		OutwardSuppliesDetails outwardSuppliesDetails = null;
		OutwardZeroRatedSupplies outwardZeroRatedSupplies = null;
		OutwardExempetedSupplies outwardExempetedSupplies = null;
		InwardSuppliesUnderRevCharge inwardSuppliesUnderRevCharge = null;
		OutwardNonGSTSupplies outwardNonGSTSupplies = null;
		SuppliesDetails suppliesDetails = null;
		ITCData netITCData = null;
		InterestLateFeeData interestLateFeeData = null;
		
		InterStateSupplies interStateSupplies = new InterStateSupplies();
		
		int noOfRecords = 0;
		ArrayList<String> tranIdList = new ArrayList<String>();
		
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		try
		{
			sql = " SELECT GDH.TRAN_TYPE,SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD" 
				+ " WHERE GDH.TRAN_ID=GDD.TRAN_ID" 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.SUBMIT_STATUS = ?"
				+ " AND GDH.TRAN_TYPE IN ('01','02','03','04','05') GROUP BY TRAN_TYPE";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, "6");
				pstmt.setString(2, siteCode);
				pstmt.setString(3, periodCode);
				pstmt.setString(4, "P");
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				if("01".equalsIgnoreCase(gstCommonUtil.checkNull(rs.getString("TRAN_TYPE"))))
				{
					outwardSuppliesDetails = new OutwardSuppliesDetails();
					outwardSuppliesDetails.taxableAmount = rs.getDouble("TAXABLE_AMT");
					outwardSuppliesDetails.igstAmount = rs.getDouble("IGST_AMT");
					outwardSuppliesDetails.cgstAmount = rs.getDouble("CGST_AMT");
					outwardSuppliesDetails.sgstAmount = rs.getDouble("SGST_AMT");
					outwardSuppliesDetails.cessAmount = rs.getDouble("CESS_AMT");
				}
				else if("02".equalsIgnoreCase(gstCommonUtil.checkNull(rs.getString("TRAN_TYPE"))))
				{
					outwardZeroRatedSupplies = new OutwardZeroRatedSupplies();
					outwardZeroRatedSupplies.taxableAmount = rs.getDouble("TAXABLE_AMT");
					outwardZeroRatedSupplies.igstAmount = rs.getDouble("IGST_AMT");
					outwardZeroRatedSupplies.cessAmount = rs.getDouble("CESS_AMT");
				}
				else if("03".equalsIgnoreCase(gstCommonUtil.checkNull(rs.getString("TRAN_TYPE"))))
				{
					outwardExempetedSupplies = new OutwardExempetedSupplies();
					outwardExempetedSupplies.taxableAmount = rs.getDouble("TAXABLE_AMT");
				}
				else if("04".equalsIgnoreCase(gstCommonUtil.checkNull(rs.getString("TRAN_TYPE"))))
				{
					inwardSuppliesUnderRevCharge = new InwardSuppliesUnderRevCharge();
					inwardSuppliesUnderRevCharge.taxableAmount = rs.getDouble("TAXABLE_AMT");
					inwardSuppliesUnderRevCharge.igstAmount = rs.getDouble("IGST_AMT");
					inwardSuppliesUnderRevCharge.cgstAmount = rs.getDouble("CGST_AMT");
					inwardSuppliesUnderRevCharge.sgstAmount = rs.getDouble("SGST_AMT");
					inwardSuppliesUnderRevCharge.cessAmount = rs.getDouble("CESS_AMT");
				}
				else if("05".equalsIgnoreCase(gstCommonUtil.checkNull(rs.getString("TRAN_TYPE"))))
				{
					outwardNonGSTSupplies = new OutwardNonGSTSupplies();
					outwardNonGSTSupplies.taxableAmount = rs.getDouble("TAXABLE_AMT");
				}
			}
			closeResources(rs,pstmt);
			
			if(outwardSuppliesDetails!=null || outwardZeroRatedSupplies!=null || outwardExempetedSupplies!=null || inwardSuppliesUnderRevCharge!=null || outwardNonGSTSupplies!=null)
			{
				suppliesDetails = new SuppliesDetails();
				suppliesDetails.outwardSuppliesDetails = outwardSuppliesDetails;
				suppliesDetails.outwardZeroRatedSupplies = outwardZeroRatedSupplies;
				suppliesDetails.outwardExempetedSupplies = outwardExempetedSupplies;
				suppliesDetails.inwardSuppliesUnderRevCharge = inwardSuppliesUnderRevCharge;
				suppliesDetails.outwardNonGSTSupplies = outwardNonGSTSupplies;
			}
			
			sql = " SELECT GDH.GST_CODE, SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD" 
				+ " WHERE GDH.TRAN_ID = GDD.TRAN_ID" 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.SUBMIT_STATUS = ? AND GDH.TRAN_TYPE IN ('06') GROUP BY GDH.GST_CODE";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			pstmt.setString(4, "P");
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				InterStateSuppliesData interStateSuppliesData = new InterStateSuppliesData();
				interStateSuppliesData.placeOfSupply = gstCommonUtil.checkNull(rs.getString("GST_CODE"));
				interStateSuppliesData.taxableAmount = rs.getDouble("TAXABLE_AMT");
				interStateSuppliesData.igstAmount = rs.getDouble("IGST_AMT");
				interStateSuppliesDataList.add(interStateSuppliesData);
			}
			closeResources(rs,pstmt);
			
			if(interStateSuppliesDataList.size() > 0)
			{
				interStateSupplies.interUnregisterSuppliesData = interStateSuppliesDataList;
			}
			//interStateSuppliesDataList.clear();
			
			sql = " SELECT GDH.GST_CODE, SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD" 
				+ " WHERE GDH.TRAN_ID = GDD.TRAN_ID" 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.SUBMIT_STATUS = ? AND GDH.TRAN_TYPE IN ('07') GROUP BY GDH.GST_CODE";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			pstmt.setString(4, "P");
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				InterStateSuppliesData interStateSuppliesData = new InterStateSuppliesData();
				interStateSuppliesData.placeOfSupply = gstCommonUtil.checkNull(rs.getString("GST_CODE"));
				interStateSuppliesData.taxableAmount = rs.getDouble("TAXABLE_AMT");
				interStateSuppliesData.igstAmount = rs.getDouble("IGST_AMT");
				interStateSuppliesDataList.add(interStateSuppliesData);
			}
			closeResources(rs,pstmt);
			
			if(interStateSuppliesDataList.size() > 0)
			{
				interStateSupplies.compositionSuppliesData = interStateSuppliesDataList;
			}
			//interStateSuppliesDataList.clear();
			
			sql = " SELECT GDH.GST_CODE, SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD" 
				+ " WHERE GDH.TRAN_ID = GDD.TRAN_ID" 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.SUBMIT_STATUS = ? AND GDH.TRAN_TYPE IN ('08') GROUP BY GDH.GST_CODE";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			pstmt.setString(4, "P");
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				InterStateSuppliesData interStateSuppliesData = new InterStateSuppliesData();
				interStateSuppliesData.placeOfSupply = gstCommonUtil.checkNull(rs.getString("GST_CODE"));
				interStateSuppliesData.taxableAmount = rs.getDouble("TAXABLE_AMT");
				interStateSuppliesData.igstAmount = rs.getDouble("IGST_AMT");
				interStateSuppliesDataList.add(interStateSuppliesData);
			}
			closeResources(rs,pstmt);
			
			if(interStateSuppliesDataList.size() > 0)
			{
				interStateSupplies.uinSuppliesData = interStateSuppliesDataList;
			}
			//interStateSuppliesDataList.clear();
			
			sql = " SELECT GDH.TRAN_TYPE, SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD" 
				+ " WHERE GDH.TRAN_ID = GDD.TRAN_ID" 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.SUBMIT_STATUS = ? AND GDH.TRAN_TYPE IN ('09','10','11','12','13','14') GROUP BY GDH.TRAN_TYPE";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			pstmt.setString(4, "P");
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				ITCData itcData = new ITCData();
				String tranType = checkNullandTrim(rs.getString("TRAN_TYPE"));
				if("09".equalsIgnoreCase(tranType))
				{
					itcData.type = "IMPG";
				}
				else if("10".equalsIgnoreCase(tranType))
				{
					itcData.type = "IMPS";
				}
				else if("11".equalsIgnoreCase(tranType))
				{
					itcData.type = "ISRC";
				}
				else if("12".equalsIgnoreCase(tranType))
				{
					itcData.type = "ISD";
				}
				else if("14".equalsIgnoreCase(tranType))
				{
					itcData.type = "OTH";
				}
				
				itcData.igstAmount = rs.getDouble("IGST_AMT");
				itcData.cgstAmount = rs.getDouble("CGST_AMT");
				itcData.sgstAmount = rs.getDouble("SGST_AMT");
				itcData.cessAmount = rs.getDouble("CESS_AMT");
				itcAvlDataList.add(itcData);
			}
			closeResources(rs,pstmt);
				
			sql = " SELECT GDH.TRAN_TYPE, SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD" 
				+ " WHERE GDH.TRAN_ID = GDD.TRAN_ID" 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.SUBMIT_STATUS = ? AND GDH.TRAN_TYPE IN ('15','16','17','18','19','20') GROUP BY GDH.TRAN_TYPE";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			pstmt.setString(4, "P");
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				ITCData itcData = new ITCData();
				String tranType = checkNullandTrim(rs.getString("TRAN_TYPE"));
				if("15".equalsIgnoreCase(tranType))
				{
					itcData.type = "IMPG";
				}
				else if("16".equalsIgnoreCase(tranType))
				{
					itcData.type = "IMPS";
				}
				else if("17".equalsIgnoreCase(tranType))
				{
					itcData.type = "ISRC";
				}
				else if("18".equalsIgnoreCase(tranType))
				{
					itcData.type = "ISD";
				}
				else if("19".equalsIgnoreCase(tranType))
				{
					itcData.type = "RUL";
				}
				else if("20".equalsIgnoreCase(tranType))
				{
					itcData.type = "OTH";
				}
				
				itcData.igstAmount = rs.getDouble("IGST_AMT");
				itcData.cgstAmount = rs.getDouble("CGST_AMT");
				itcData.sgstAmount = rs.getDouble("SGST_AMT");
				itcData.cessAmount = rs.getDouble("CESS_AMT");
				itcRevDataList.add(itcData);
			}
			closeResources(rs,pstmt);
			
			sql = " SELECT GDH.TRAN_TYPE, SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD" 
				+ " WHERE GDH.TRAN_ID = GDD.TRAN_ID" 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.SUBMIT_STATUS = ? AND GDH.TRAN_TYPE IN ('21') GROUP BY GDH.TRAN_TYPE";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			pstmt.setString(4, "P");
			
			rs = pstmt.executeQuery();
			
			if(rs.next())
			{
				netITCData = new ITCData();
				netITCData.igstAmount = rs.getDouble("IGST_AMT");
				netITCData.cgstAmount = rs.getDouble("CGST_AMT");
				netITCData.sgstAmount = rs.getDouble("SGST_AMT");
				netITCData.cessAmount = rs.getDouble("CESS_AMT");
			}
			closeResources(rs, pstmt);
			
			sql = " SELECT GDH.TRAN_TYPE, SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD" 
				+ " WHERE GDH.TRAN_ID = GDD.TRAN_ID" 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.SUBMIT_STATUS = ? AND GDH.TRAN_TYPE IN ('22','23','24','25','26','27') GROUP BY GDH.TRAN_TYPE";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			pstmt.setString(4, "P");
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				ITCData itcData = new ITCData();
				String tranType = checkNullandTrim(rs.getString("TRAN_TYPE"));
				if("22".equalsIgnoreCase(tranType))
				{
					itcData.type = "IMPG";
				}
				else if("23".equalsIgnoreCase(tranType))
				{
					itcData.type = "IMPS";
				}
				else if("24".equalsIgnoreCase(tranType))
				{
					itcData.type = "ISRC";
				}
				else if("25".equalsIgnoreCase(tranType))
				{
					itcData.type = "ISD";
				}
				else if("26".equalsIgnoreCase(tranType))
				{
					itcData.type = "RUL";
				}
				else if("27".equalsIgnoreCase(tranType))
				{
					itcData.type = "OTH";
				}
				
				itcData.igstAmount = rs.getDouble("IGST_AMT");
				itcData.cgstAmount = rs.getDouble("CGST_AMT");
				itcData.sgstAmount = rs.getDouble("SGST_AMT");
				itcData.cessAmount = rs.getDouble("CESS_AMT");
				itcInelgDataList.add(itcData);
			}
			closeResources(rs,pstmt);
			
			ITCEligibilty itcEligibility = new ITCEligibilty();
			if(itcAvlDataList.size() > 0)
			{
				itcEligibility.itcAvailable = itcAvlDataList;
			}
			if(itcRevDataList.size() > 0)
			{
				itcEligibility.itcReversed = itcRevDataList;
			}
			if(netITCData != null)
			{
				itcEligibility.netITCAvailable = netITCData;
			}
			if(itcInelgDataList.size() > 0)
			{
				itcEligibility.itcIneligible = itcInelgDataList;
			}
			
			InwardSuppliesDetails inwardGSTSupplies = new InwardSuppliesDetails();
			
			sql = " SELECT GDH.TRAN_TYPE, SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD" 
				+ " WHERE GDH.TRAN_ID = GDD.TRAN_ID" 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.SUBMIT_STATUS = ? AND GDH.TRAN_TYPE IN ('28','30') GROUP BY GDH.TRAN_TYPE";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			pstmt.setString(4, "P");
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				inwardGSTSupplies.type = "GST";
				String tranType = checkNullandTrim(rs.getString("TRAN_TYPE"));
				if("28".equalsIgnoreCase(tranType))
				{
					inwardGSTSupplies.interSuppliesAmount = rs.getDouble("TAXABLE_AMT");
				}
				else if("30".equalsIgnoreCase(tranType))
				{
					inwardGSTSupplies.intraSuppliesAmount = rs.getDouble("TAXABLE_AMT");
				}
			}
			closeResources(rs, pstmt);
			inwardSuppliesList.add(inwardGSTSupplies);
			
			InwardSuppliesDetails inwardnonGSTSupplies = new InwardSuppliesDetails();
			
			sql = " SELECT GDH.TRAN_TYPE, SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD" 
				+ " WHERE GDH.TRAN_ID=GDD.TRAN_ID" 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.SUBMIT_STATUS = ? AND GDH.TRAN_TYPE IN ('29','31') GROUP BY GDH.TRAN_TYPE";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			pstmt.setString(4, "P");
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				inwardnonGSTSupplies.type = "NONGST";
				String tranType = checkNullandTrim(rs.getString("TRAN_TYPE"));
				if("29".equalsIgnoreCase(tranType))
				{
					inwardnonGSTSupplies.interSuppliesAmount = rs.getDouble("TAXABLE_AMT");
				}
				else if("31".equalsIgnoreCase(tranType))
				{
					inwardnonGSTSupplies.intraSuppliesAmount = rs.getDouble("TAXABLE_AMT");
				}
			}
			closeResources(rs, pstmt);
			inwardSuppliesList.add(inwardnonGSTSupplies);
			
			InwardSupplies inwardSupplies = new InwardSupplies();
			if(inwardSuppliesList.size() > 0)
			{
				inwardSupplies.inwardSuppliesDetails = inwardSuppliesList;
			}
			
			sql = " SELECT SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD" 
				+ " WHERE GDH.TRAN_ID=GDD.TRAN_ID" 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.SUBMIT_STATUS = ? AND GDH.TRAN_TYPE IN ('32')";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			pstmt.setString(4, "P");
			
			rs = pstmt.executeQuery();
			
			if(rs.next())
			{
				interestLateFeeData = new InterestLateFeeData();
				interestLateFeeData.igstAmount = rs.getDouble("IGST_AMT");
				interestLateFeeData.cgstAmount = rs.getDouble("CGST_AMT");
				interestLateFeeData.sgstAmount = rs.getDouble("SGST_AMT");
				interestLateFeeData.cessAmount = rs.getDouble("CESS_AMT");
			}
			closeResources(rs, pstmt);
			
			gstr3b = new GSTR3B();
			
			gstr3b.gstin = gstin;
			gstr3b.financialPeriod = periodCode;
			if(suppliesDetails != null)
			{
				gstr3b.supplyDetails = suppliesDetails;
			}
			gstr3b.interStateSupplies = interStateSupplies;
			gstr3b.itcEligibility = itcEligibility;
			gstr3b.inwardSupplies = inwardSupplies;
			if(interestLateFeeData != null)
			{
				gstr3b.interestLateFeeData = interestLateFeeData;
			}
			
			ObjectMapper objectMapper = new ObjectMapper();
			
			String json = objectMapper.writeValueAsString(gstr3b);
			
			System.out.println("jsonPayload to save GSTR3B ["+json+"]");
			
			retString = saveGSTRData(json, noOfRecords, tranIdList, "6", conn, xtraParams);
			
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.saveGstr3b()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}
	private String submitGstr3b(String xtraParams,Connection conn) throws ITMException
	{
		String retString = "";
		String errMsg = "", gspAuthString = "", gspAuthSignature = "";
		String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
		String loginCode = "", chgTerm = "", siteCode = "", callStatus = "", responseJsonStr = "", responseId = "";
		
		try
		{
			siteCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			
			String json = "{\"gstin\":\""+gstin+"\",\"ret_period\":\""+periodCode+"\"}";
            
            byte[] jsonBase64 = Base64.getEncoder().encode(json.getBytes());
			String encryptedPayload = aesEncryption.encryptEK(jsonBase64, authSEK);
			 
			HMac hmac = new HMac(new SHA256Digest());
			byte[] resBuf = new byte[hmac.getMacSize()];
			
			hmac.init(new KeyParameter(authSEK));
			hmac.update(jsonBase64, 0, jsonBase64.length);
			hmac.doFinal(resBuf, 0);
            
			JSONObject reqBody = new JSONObject();
            reqBody.put("action", "RETSUBMIT");
            reqBody.put("data", encryptedPayload);
            reqBody.put("hmac", new String(Base64.getEncoder().encode(resBuf)));
            
            long timeStamp = new Timestamp().getDateTime();
	        gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin;
			gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
			
            HttpRequest gstr3bSubmitReq = Unirest.post(String.format("%s%s", BASE_API_URL, GSTR3B_URL))
										.header("Content-Type", APPLICATION_JSON)
										.header("action", "RETSUBMIT")
				                        .header("state-cd", stateCode)
				                        .header("clientid", clientId)
				                        .header("client-secret", clientSecret)
				                        .header("ip-usr", ipAddress)
				                        .header("username", userName)
				                        .header("auth-token", authToken)
				                        .header("txn", transactionId)
				                        .header("ret_period", periodCode)
				                        .header("gstin", gstin)
				                        .header("X-Asp-Auth-Token", gspAuthString)
				                        .header("X-Asp-Auth-Signature", gspAuthSignature)
				                        .body(new JsonNode(reqBody.toString()))
				                        .getHttpRequest();
            
            System.out.println("RETSUBMIT GSTR3B url["+gstr3bSubmitReq.getUrl()+"]");
			System.out.println("RETSUBMIT GSTR3B method["+gstr3bSubmitReq.getHttpMethod()+"]");
			System.out.println("RETSUBMIT GSTR3B request header["+gstr3bSubmitReq.getHeaders()+"]");
			System.out.println("RETSUBMIT GSTR3B request payload["+IOUtils.toString(gstr3bSubmitReq.getBody().getEntity().getContent())+"]");
            
            HttpResponse<JsonNode> gstr3bSubmitResp = gstr3bSubmitReq.asJson();
            
            System.out.println(String.format("gstr3bSubmitResp Request : Status[%s] Response[%s]", gstr3bSubmitResp.getStatus(), gstr3bSubmitResp.getBody()));
            
            if (gstr3bSubmitResp.getStatus() == 200) 
	        {
				JSONObject gstr3bSubmitRespObj = gstr3bSubmitResp.getBody().getObject();
				if(gstr3bSubmitRespObj.has("data") && gstr3bSubmitRespObj.has("rek"))
				{
					callStatus = "1";
					String gstr3bSubmitdata = gstr3bSubmitRespObj.getString("data");
					String gstr3bSubmitrek = gstr3bSubmitRespObj.getString("rek");
					
					byte[] apiEK = aesEncryption.decrypt(gstr3bSubmitrek, authSEK);
					String respJsoninBase64 = new String(aesEncryption.decrypt(gstr3bSubmitdata, apiEK));
					
					byte[] respJsonInBytes = aesEncryption.decodeBase64StringTOByte(respJsoninBase64);
					
					JSONObject gstr3bSubmitObj = new JSONObject(new String(respJsonInBytes));
					String transId = gstr3bSubmitObj.getString("reference_id");
					responseId = transId;
					System.out.println("transId to getStatus after SUBMIT call["+transId+"]");
					
				}
				else
	            {
					callStatus = "2";
					JSONObject errorJSON = gstr3bSubmitResp.getBody().getObject().getJSONObject("error");
					responseJsonStr = errorJSON.toString();
		        	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
		        	retString = getError(errMsg, "GSTAPIERR", conn);
	            }
	        }
            else if(gstr3bSubmitResp.getStatus() == 500)
	        {
	        	callStatus = "2";
	        	errMsg = "Message : Error occurred at GSTN server \nResponse code : "+gstr3bSubmitResp.getStatus();
	        	responseJsonStr = errMsg;
	        	retString = getError(errMsg, "GSTAPIERR", conn);
	        }
			else
            {
				callStatus = "2";
            	JSONObject errorJSON = gstr3bSubmitResp.getBody().getObject().getJSONObject("error");
            	responseJsonStr = errorJSON.toString();
            	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
	        	retString = getError(errMsg, "GSTAPIERR", conn);
            }
            
            APICallData apiCallData = new APICallData();
	        apiCallData.setPeriodCode(periodCode);
	        apiCallData.setCallDate(new Date());
	        apiCallData.setSiteCode(siteCode);
	        apiCallData.setUserId(loginCode);
	        apiCallData.setCallType("RETSUBMIT");
	        apiCallData.setRecType("3");
	        apiCallData.setNoOfRecords(0);
	        apiCallData.setCallStatus(callStatus);
	        apiCallData.setResponseId(responseId);
	        apiCallData.setResponseJsonStr(responseJsonStr);
	        apiCallData.setChgUser(loginCode);
	        apiCallData.setChgDate(new Date());
	        apiCallData.setChgTerm(chgTerm);
	        
	        gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.submitGstr3b()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}
	private String fileGstr3b(String summaryData, String signedData, String panNo, String aadhaarNo, String signMethod, String xtraParams, Connection conn) throws ITMException
	{
		String retString = "";
		String errMsg = "", gspAuthString = "", gspAuthSignature = "", signType = "",signId = "";
		String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
		String loginCode = "", chgTerm = "", siteCode = "", callStatus = "", responseJsonStr = "";
		
		try
		{
			siteCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			
			long timeStamp = new Timestamp().getDateTime();
	        gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin;
			gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
			
			byte[] jsonBase64 = Base64.getEncoder().encode(summaryData.toString().getBytes());
			String encryptedPayload = aesEncryption.encryptEK(jsonBase64, authSEK);
			
			HMac hmac = new HMac(new SHA256Digest());
			byte[] resBuf = new byte[hmac.getMacSize()];
			
			hmac.init(new KeyParameter(authSEK));
			hmac.update(jsonBase64, 0, jsonBase64.length);
			hmac.doFinal(resBuf, 0);
			
			if("D".equalsIgnoreCase(signMethod))
			{
				signType = "DSC";
				signId = panNo;
			}
			else if("E".equalsIgnoreCase(signMethod))
			{
				signType = "ESIGN";
				signId = aadhaarNo;
			}
			
			JSONObject fileGstr3bDataJsonObj = new JSONObject();
			fileGstr3bDataJsonObj.put("action", "RETFILE");
			fileGstr3bDataJsonObj.put("data", encryptedPayload);
			fileGstr3bDataJsonObj.put("hmac", new String(Base64.getEncoder().encode(resBuf)));
			fileGstr3bDataJsonObj.put("sign", signedData);
			fileGstr3bDataJsonObj.put("st", signType);
			fileGstr3bDataJsonObj.put("sid", signId);
			
			HttpRequest fileGstr3bReq = Unirest.post(String.format("%s%s", BASE_API_URL, GSTR3B_URL))
									   .header("Content-Type", APPLICATION_JSON)
									   .header("state-cd", stateCode)
									   .header("clientid", clientId)
									   .header("client-secret", clientSecret)
									   .header("ip-usr", ipAddress)
									   .header("username", userName)
									   .header("auth-token", authToken)
									   .header("txn", transactionId)
									   .header("ret_period", periodCode)
									   .header("gstin", gstin)
									   .header("X-Asp-Auth-Token", gspAuthString)
									   .header("X-Asp-Auth-Signature", gspAuthSignature)
									   .body(new JsonNode(fileGstr3bDataJsonObj.toString()))
									   .getHttpRequest();
			
			System.out.println("FILE GSTR3B url["+fileGstr3bReq.getUrl()+"]");
			System.out.println("FILE GSTR3B method["+fileGstr3bReq.getHttpMethod()+"]");
			System.out.println("FILE GSTR3B request header["+fileGstr3bReq.getHeaders()+"]");
			System.out.println("FILE GSTR3B request payload["+IOUtils.toString(fileGstr3bReq.getBody().getEntity().getContent())+"]");
			
			HttpResponse<JsonNode> fileGstr3bResp = fileGstr3bReq.asJson();

			System.out.println(String.format("fileGstr3bResp Request : Status[%s] Response[%s]", fileGstr3bResp.getStatus(), fileGstr3bResp.getBody()));
			if (fileGstr3bResp.getStatus() == 200) 
			{
				JSONObject fileGstr3bRespObj = fileGstr3bResp.getBody().getObject();
				if(fileGstr3bRespObj.has("data") && fileGstr3bRespObj.has("rek"))
				{
					callStatus = "1";
					String fileGstr3bData = fileGstr3bRespObj.getString("data");
					String fileGstr3bRek = fileGstr3bRespObj.getString("rek");

					byte[] fileGstr3bApiEK = aesEncryption.decrypt(fileGstr3bRek, authSEK);

					String fileGstr3bJsoninBase64 = new String(aesEncryption.decrypt(fileGstr3bData, fileGstr3bApiEK));

					byte[] fileGstr3bJsonInBytes = aesEncryption.decodeBase64StringTOByte(fileGstr3bJsoninBase64);

					System.out.println(new String(fileGstr3bJsonInBytes));
				}
				else
				{
					callStatus = "2";
					JSONObject errorJSON = fileGstr3bResp.getBody().getObject().getJSONObject("error");
					responseJsonStr = errorJSON.toString();
					errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
					retString = getError(errMsg, "GSTAPIERR", conn);
				}
			}
			else
			{
				callStatus = "2";
				JSONObject errorJSON = fileGstr3bResp.getBody().getObject().getJSONObject("error");
				responseJsonStr = errorJSON.toString();
				errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
				retString = getError(errMsg, "GSTAPIERR", conn);
			}
			
			APICallData apiCallData = new APICallData();
			apiCallData.setPeriodCode(periodCode);
			apiCallData.setCallDate(new Date());
			apiCallData.setSiteCode(siteCode);
			apiCallData.setUserId(loginCode);
			apiCallData.setCallType("RETFILE");
			apiCallData.setRecType("3");
			apiCallData.setNoOfRecords(0);
			apiCallData.setCallStatus(callStatus);
			apiCallData.setResponseId("");
			apiCallData.setResponseJsonStr(responseJsonStr);
			apiCallData.setChgUser(loginCode);
			apiCallData.setChgDate(new Date());
			apiCallData.setChgTerm(chgTerm);
			
			gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
			
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.fileGstr3b()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		
		return retString;
	}
	private void insertB2BInvoiceData(String stateCode, String periodCode, String siteCode, JSONObject gstr2InvoiceJsonObj, String xtraParams, Connection conn) throws ITMException
	{
		JSONArray b2bInvArry = new JSONArray();
		JSONObject b2bJsonObj = new JSONObject();
		JSONArray b2bInvJsonArry = new JSONArray();
		JSONObject b2bInvJsonObj = new JSONObject();
		JSONArray b2bInvLineItmsArry = new JSONArray();
		JSONObject b2bInvLineItemObj = new JSONObject();
		String tranId = "", cptyGSTIN = "", iNum = "", iDate = "", reversCharge = "", docCheckSum = "", pos = "", invType = "", tranType = ""; 
		String ecomOperetorGSTIN = "", loginCode = "", chgTerm = "";
		
		int lineNo = 0, hdrInsCnt = 0;
		double amount = 0.0, lineAmt = 0.0, irt = 0.0, iamt = 0.0, crt = 0.0, camt = 0.0, srt = 0.0, samt = 0.0, csamt = 0.0, rate = 0.0;
		
		int [] detInsCnt = null;
		
		String hdrInsSql = "", detInsSql = "";
		PreparedStatement hdrInsPstmt = null, detInsPstmt = null;
		boolean isError = false;
		
		try
		{
			loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			
			
			b2bInvArry = gstr2InvoiceJsonObj.getJSONArray("b2b");
			
			for(int i = 0; i < b2bInvArry.length(); i++)
			{
				b2bJsonObj = b2bInvArry.getJSONObject(i);
				cptyGSTIN = b2bJsonObj.getString("ctin");
				
				b2bInvJsonArry = b2bJsonObj.getJSONArray("inv");
				
				for(int j=0; j<b2bInvJsonArry.length(); j++)
				{
					hdrInsSql = " INSERT INTO GST_DATA_HDR (TRAN_ID, TRAN_DATE, TRAN_ID__REF, SITE_CODE, PRD_CODE, REC_TYPE, TRAN_TYPE, CUST_CODE, CUST_NAME,"
							  + " SUBMISSION_TYPE, DOC_CHECKSUM, DOC_TYPE, DOC_NO, DOC_DATE, AMOUNT, REVERSE_CHRG, LR_NO, LR_DATE, REAS_CODE, REF_ID__INV,"
							  + " REF_DATE__INV, PROV_ASSMNT, ORDER_NO, ORDER_DATE, REMARKS, SUBMIT_STATUS, SUBMIT_DATE, ADD_USER, ADD_DATE, ADD_TERM, CHG_USER,"
							  + " CHG_DATE, CHG_TERM, TAX_REG_NO, RECO_STATUS, ECOM_REG_NO, REF_SER, GST_CODE, GST_TYPE, REF_ID)"
							  + " VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
					
					hdrInsPstmt = conn.prepareStatement(hdrInsSql);
					
					b2bInvJsonObj = b2bInvJsonArry.getJSONObject(j);
					
					iNum = b2bInvJsonObj.getString("inum");
					iDate = b2bInvJsonObj.getString("idt");
					amount = b2bInvJsonObj.getDouble("val");
					docCheckSum = b2bInvJsonObj.getString("chksum");
					reversCharge = b2bInvJsonObj.getString("rchrg");
					pos = b2bInvJsonObj.getString("pos");
					invType = b2bInvJsonObj.getString("inv_typ").trim();
					if(b2bInvJsonObj.has("etin"))
					{
						ecomOperetorGSTIN = b2bInvJsonObj.getString("etin");
					}
					
					if("R".equalsIgnoreCase(invType))
					{
						if("Y".equalsIgnoreCase(reversCharge))
						{
							tranType = "02";
						}
						else if(ecomOperetorGSTIN != null && ecomOperetorGSTIN.trim().length()>0)
						{
							tranType = "03";
						}
						else 
						{
							tranType = "01";
						}
					}
					else if("DE".equalsIgnoreCase(invType))
					{
						tranType = "10";
					}
					else if("SEWP".equalsIgnoreCase(invType))
					{
						tranType = "08";
					}
					else if("SEWOP".equalsIgnoreCase(invType))
					{
						tranType = "09";
					}
					
					tranId = generateTranId("w_gstr_purc","","",conn);
					
					hdrInsPstmt.setString(1, tranId);
					hdrInsPstmt.setTimestamp(2, java.sql.Timestamp.valueOf(e12GenericUtility.getValidDateString(new Date(), e12GenericUtility.getDBDateTimeFormat())));
					hdrInsPstmt.setString(3, null);
					hdrInsPstmt.setString(4, siteCode);
					hdrInsPstmt.setString(5, periodCode);
					hdrInsPstmt.setString(6, "4");
					hdrInsPstmt.setString(7, tranType);
					hdrInsPstmt.setString(8, null);
					hdrInsPstmt.setString(9, null);
					hdrInsPstmt.setString(10, null);
					hdrInsPstmt.setString(11, docCheckSum);
					hdrInsPstmt.setString(12, null);
					hdrInsPstmt.setString(13, iNum);
					hdrInsPstmt.setTimestamp(14, getTimeStamp(iDate));
					hdrInsPstmt.setDouble(15, amount);
					hdrInsPstmt.setString(16, reversCharge);
					hdrInsPstmt.setString(17, null);
					hdrInsPstmt.setTimestamp(18, null);
					hdrInsPstmt.setString(19, null);
					hdrInsPstmt.setString(20, null);
					hdrInsPstmt.setTimestamp(21, null);
					hdrInsPstmt.setString(22, null);
					hdrInsPstmt.setString(23, null);
					hdrInsPstmt.setTimestamp(24, null);
					hdrInsPstmt.setString(25, null);
					hdrInsPstmt.setString(26, "D");
					hdrInsPstmt.setTimestamp(27, null);
					hdrInsPstmt.setString(28, loginCode);
					hdrInsPstmt.setTimestamp(29, java.sql.Timestamp.valueOf(e12GenericUtility.getValidDateString(new Date(), e12GenericUtility.getDBDateTimeFormat())));
					hdrInsPstmt.setString(30, chgTerm);
					hdrInsPstmt.setString(31, loginCode);
					hdrInsPstmt.setTimestamp(32, java.sql.Timestamp.valueOf(e12GenericUtility.getValidDateString(new Date(), e12GenericUtility.getDBDateTimeFormat())));
					hdrInsPstmt.setString(33, chgTerm);
					hdrInsPstmt.setString(34, cptyGSTIN);
					hdrInsPstmt.setString(35, null);
					hdrInsPstmt.setString(36, ecomOperetorGSTIN);
					hdrInsPstmt.setString(37, null);
					hdrInsPstmt.setString(38, stateCode);
					hdrInsPstmt.setString(39, null);
					hdrInsPstmt.setString(40, null);
					
					hdrInsCnt = hdrInsPstmt.executeUpdate();
					
					if(hdrInsPstmt != null)
					{
						hdrInsPstmt.close();
						hdrInsPstmt = null;
					}
					
					System.out.println("header insert count for B2B GSTR2A invoices ["+hdrInsCnt+"]");
					
					detInsSql = " INSERT INTO GST_DATA_DET (TRAN_ID, LINE_NO, STATUS, SR_NO__OLD, LINE_TYPE, GS_CODE, TAXABLE_AMT, IGST_PERC,"
							  + " IGST_AMT, CGST_PERC, CGST_AMT, SGST_PERC, SGST_AMT, GS_DESCR, UNIT, QUANTITY, SUPPLY_TYPE, CESS_PERC, CESS_AMT,"
							  + " REMARKS, ITC_TYPE, ITC_IGST, ITC_CGST, ITC_SGST, ITC_CESS, GST_RATE)"
							  + " VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
					
					detInsPstmt = conn.prepareStatement(detInsSql);
					
					b2bInvLineItmsArry = b2bInvJsonObj.getJSONArray("itms");
					
					for(int k=0; k<b2bInvLineItmsArry.length(); k++)
					{
						b2bInvLineItemObj = b2bInvLineItmsArry.getJSONObject(k);
						
						lineNo = b2bInvLineItemObj.getInt("num");
						
						JSONObject tempJSONObj = b2bInvLineItemObj.getJSONObject("itm_det");
						
						rate = tempJSONObj.getDouble("rt");
						lineAmt = tempJSONObj.getDouble("txval");
						if(tempJSONObj.has("iamt"))
						{
							iamt = tempJSONObj.getDouble("iamt");
						}
						if(tempJSONObj.has("camt"))
						{
							camt = tempJSONObj.getDouble("camt");
						}
						if(tempJSONObj.has("samt"))
						{
							samt = tempJSONObj.getDouble("samt");
						}
						if(tempJSONObj.has("csamt"))
						{
							csamt = tempJSONObj.getDouble("csamt");
						}  
						
						if(stateCode.trim().equalsIgnoreCase(pos.trim()))
						{
							irt = rate;
						}
						else
						{
							crt = rate/2;
							srt = rate/2;
						}
						
						detInsPstmt.setString(1, tranId);
						detInsPstmt.setInt(2, lineNo);
						detInsPstmt.setString(3, null);
						detInsPstmt.setInt(4, 0);
						detInsPstmt.setString(5, null);
						detInsPstmt.setString(6, null);
						detInsPstmt.setDouble(7, lineAmt);
						detInsPstmt.setDouble(8, irt);
						detInsPstmt.setDouble(9, iamt);
						detInsPstmt.setDouble(10, crt);
						detInsPstmt.setDouble(11, camt);
						detInsPstmt.setDouble(12, srt);
						detInsPstmt.setDouble(13, samt);
						detInsPstmt.setString(14, null);
						detInsPstmt.setString(15, null);
						detInsPstmt.setInt(16, 0);
						detInsPstmt.setString(17, null);
						detInsPstmt.setDouble(18, 0.0);
						detInsPstmt.setDouble(19, csamt);
						detInsPstmt.setString(20, null);
						detInsPstmt.setString(21, null);
						detInsPstmt.setDouble(22, 0.0);
						detInsPstmt.setDouble(23, 0.0);
						detInsPstmt.setDouble(24, 0.0);
						detInsPstmt.setDouble(25, 0.0);
						detInsPstmt.setDouble(26, rate);
						
						detInsPstmt.addBatch();
						detInsPstmt.clearParameters();
					}
					
					detInsCnt = detInsPstmt.executeBatch();
					
					if(detInsPstmt != null)
					{
						detInsPstmt.close();
						detInsPstmt = null;
					}
					
					if(detInsCnt!=null)
					{
						for(int eachRowCnt : detInsCnt)
						{
							System.out.println("detail row insert count for B2B GSTR2A invoices ["+eachRowCnt+"]");
						}
					}
				}
			}
		}
		catch (Exception e)
		{
			isError = true;
			System.out.println("GSTDataSubmitWizPos.insertB2BInvoiceData()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(isError)
				{
					if(hdrInsPstmt != null)
					{
						hdrInsPstmt.close();
						hdrInsPstmt = null;
					}
					if(detInsPstmt != null)
					{
						detInsPstmt.close();
						detInsPstmt = null;
					}
				}
			}
			catch(SQLException se)
			{
				System.out.println("GSTDataSubmitWizPos.insertB2BInvoiceData()["+se.getMessage()+"]");
				se.printStackTrace();
			}
		}
	}
	/*private void insertIMGInvoiceData(String stateCode, String periodCode, String siteCode, JSONObject gstr2InvoiceJsonObj, Connection conn) throws ITMException
	{
		JSONArray imgInvoiceArry = new JSONArray();
		JSONObject imgJsonObj = new JSONObject();
		JSONArray imgInvLineItmsArry = new JSONArray();
		JSONObject imgInvLineItemObj = new JSONObject();
		
		String tranId = "", isSezImport = "", supplierGSTIN = "", billOfEntry = "", billOfEntryDtStr = "", checkSum = "", portCode = "", itcType = "",
			   tranType = "", docType = "";
		int lineNo = 0;
		double billOfEntryAmt = 0.0, rate = 0.0, igstAmt = 0.0, taxableValue = 0.0, cessAmt = 0.0, itcIGSTAmt = 0.0, itcCessAmt = 0.0;
		
		List<String> hdrColumnList = new ArrayList<String>(), hdrDataTypeList = new ArrayList<String>(), hdrDataList = null;
	 	List<String> detColumnList = new ArrayList<String>(),  detDataTypeList = new ArrayList<String>();
	 	List<List<String>> detDataList = null;
		
		try
		{
			hdrColumnList.add("TRAN_ID");
			hdrColumnList.add("TRAN_DATE");
			hdrColumnList.add("REC_TYPE");
			hdrColumnList.add("TRAN_TYPE");
			hdrColumnList.add("SUBMIT_STATUS");
			hdrColumnList.add("DOC_CHECKSUM");
			hdrColumnList.add("LR_NO");
			hdrColumnList.add("LR_DATE");
			hdrColumnList.add("AMOUNT");
			hdrColumnList.add("TAX_REG_NO");
			hdrColumnList.add("SITE_CODE");
			hdrColumnList.add("DOC_TYPE");
			hdrColumnList.add("ORDER_NO");
			hdrColumnList.add("PRD_CODE");
			
			hdrDataTypeList.add("STRING");		//TRAN_ID
			hdrDataTypeList.add("TIMESTAMP");	//TRAN_DATE
			hdrDataTypeList.add("STRING");		//REC_TYPE
			hdrDataTypeList.add("STRING");		//TRAN_TYPE
			hdrDataTypeList.add("STRING");		//SUBMIT_STATUS
			hdrDataTypeList.add("STRING");		//DOC_CHECKSUM
			hdrDataTypeList.add("STRING");		//LR_NO
			hdrDataTypeList.add("STRING");		//LR_DATE
			hdrDataTypeList.add("DOUBLE");		//AMOUNT
			hdrDataTypeList.add("STRING");		//TAX_REG_NO
			hdrDataTypeList.add("STRING");		//SITE_CODE
			hdrDataTypeList.add("STRING");		//DOC_TYPE
			hdrDataTypeList.add("STRING");		//ORDER_NO
			hdrDataTypeList.add("STRING");		//PRD_CODE
			
			detColumnList.add("TRAN_ID");
			detColumnList.add("LINE_NO");
			detColumnList.add("TAXABLE_AMT");
			detColumnList.add("GST_RATE");
			detColumnList.add("IGST_PERC");
			detColumnList.add("IGST_AMT");
			detColumnList.add("CESS_AMT");
			detColumnList.add("ITC_TYPE");
			detColumnList.add("ITC_IGST");
			detColumnList.add("ITC_CESS");
			
			detDataTypeList.add("STRING");		//TRAN_ID
			detDataTypeList.add("INT");			//LINE_NO
			detDataTypeList.add("DOUBLE");		//TAXABLE_AMT
			detDataTypeList.add("DOUBLE");		//GST_RATE
			detDataTypeList.add("DOUBLE");		//IGST_PERC
			detDataTypeList.add("DOUBLE");		//IGST_AMT
			detDataTypeList.add("DOUBLE");		//CESS_AMT
			detDataTypeList.add("STRING");		//ITC_TYPE
			detDataTypeList.add("DOUBLE");		//ITC_IGST
			detDataTypeList.add("DOUBLE");		//ITC_CESS
			
			imgInvoiceArry = gstr2InvoiceJsonObj.getJSONArray("imp_g");
			
			for(int i=0; i<imgInvoiceArry.length(); i++)
			{
				imgJsonObj = imgInvoiceArry.getJSONObject(i);
				
				isSezImport = imgJsonObj.getString("is_sez");
				supplierGSTIN = imgJsonObj.getString("stin");
				billOfEntry = imgJsonObj.getString("boe_num");
				billOfEntryDtStr = imgJsonObj.getString("boe_dt");
				billOfEntryAmt = imgJsonObj.getDouble("boe_val");
				checkSum = imgJsonObj.getString("chksum");
				portCode = imgJsonObj.getString("port_code");
				
				if("Y".equalsIgnoreCase(isSezImport))
				{
					tranType = "06";
				}
				else
				{
					tranType = "05";
				}
				
				tranId = generateTranId("w_gstr_purc","","",conn);
				
				detDataList = new ArrayList<List<String>>();
				
				imgInvLineItmsArry = imgJsonObj.getJSONArray("itms");
				
				for(int j=0; j< imgInvLineItmsArry.length(); j++)
				{
					imgInvLineItemObj = imgInvLineItmsArry.getJSONObject(j);
					
					lineNo = imgInvLineItemObj.getInt("num");
					rate = imgInvLineItemObj.getDouble("rt");
					taxableValue = imgInvLineItemObj.getDouble("txval");
					igstAmt = imgInvLineItemObj.getDouble("iamt");
					cessAmt = imgInvLineItemObj.getDouble("csamt");
					itcType = imgInvLineItemObj.getString("elg");
					itcIGSTAmt = imgInvLineItemObj.getDouble("tx_i");
					itcCessAmt = imgInvLineItemObj.getDouble("tx_cs");
					
					if(igstAmt > 0)
					{
						docType = "SEWP";
					}
					else
					{
						docType = "SEWOP";
					}
					
					List<String> tempList = new ArrayList<String>();
					tempList.add(tranId);
					tempList.add(String.valueOf(lineNo));
					tempList.add(String.valueOf(taxableValue));
					tempList.add(String.valueOf(rate));
					tempList.add(String.valueOf(rate));
					tempList.add(String.valueOf(igstAmt));
					tempList.add(String.valueOf(cessAmt));
					tempList.add(itcType);
					tempList.add(String.valueOf(itcIGSTAmt));
					tempList.add(String.valueOf(itcCessAmt));
					
					detDataList.add(tempList);
				}
				
				hdrDataList = new ArrayList<String>();
				
				hdrDataList.add(tranId);
				hdrDataList.add(e12GenericUtility.getValidDateString(new Date(), e12GenericUtility.getDBDateFormat()));
				hdrDataList.add("2");
				hdrDataList.add(tranType);
				hdrDataList.add("D");
				hdrDataList.add(checkSum);
				hdrDataList.add(billOfEntry);
				hdrDataList.add(billOfEntryDtStr);
				hdrDataList.add(String.valueOf(billOfEntryAmt));
				hdrDataList.add(supplierGSTIN);
				hdrDataList.add(siteCode);
				hdrDataList.add(docType);
				hdrDataList.add(portCode);
				hdrDataList.add(periodCode);
				
				insertGSTHdrDetData(hdrColumnList, hdrDataTypeList, hdrDataList, detColumnList, detDataTypeList, detDataList, conn);
			}
			
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.insertIMGInvoiceData()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
	}
	private void insertIMSInvoiceData(String stateCode, String periodCode, String siteCode, JSONObject gstr2InvoiceJsonObj, Connection conn) throws ITMException
	{
		JSONArray imsInvoiceArry = new JSONArray();
		JSONObject imsJsonObj = new JSONObject();
		JSONArray imsInvLineItmsArry = new JSONArray();
		JSONObject imsInvLineItemObj = new JSONObject();
		
		String tranId = "", invoiceId = "", invoiceDate = "", checkSum = "", gstCode = "", itcType = "", tranType = "";
		int lineNo = 0;
		double amount = 0.0, rate = 0.0, igstAmt = 0.0, taxableValue = 0.0, cessAmt = 0.0, itcIGSTAmt = 0.0, itcCessAmt = 0.0;
		
		List<String> hdrColumnList = new ArrayList<String>(), hdrDataTypeList = new ArrayList<String>(), hdrDataList = null;
	 	List<String> detColumnList = new ArrayList<String>(),  detDataTypeList = new ArrayList<String>();
	 	List<List<String>> detDataList = null;
	 	
		try
		{
			hdrColumnList.add("TRAN_ID");
			hdrColumnList.add("TRAN_DATE");
			hdrColumnList.add("REC_TYPE");
			hdrColumnList.add("TRAN_TYPE");
			hdrColumnList.add("SUBMIT_STATUS");
			hdrColumnList.add("DOC_CHECKSUM");
			hdrColumnList.add("DOC_NO");
			hdrColumnList.add("DOC_DATE");
			hdrColumnList.add("AMOUNT");
			hdrColumnList.add("GST_CODE");
			hdrColumnList.add("SITE_CODE");
			hdrColumnList.add("PRD_CODE");
			
			hdrDataTypeList.add("STRING");		//TRAN_ID
			hdrDataTypeList.add("TIMESTAMP");	//TRAN_DATE
			hdrDataTypeList.add("STRING");		//REC_TYPE
			hdrDataTypeList.add("STRING");		//TRAN_TYPE
			hdrDataTypeList.add("STRING");		//SUBMIT_STATUS
			hdrDataTypeList.add("STRING");		//DOC_CHECKSUM
			hdrDataTypeList.add("STRING");		//DOC_NO
			hdrDataTypeList.add("TIMESTAMP");	//DOC_DATE
			hdrDataTypeList.add("DOUBLE");		//AMOUNT
			hdrDataTypeList.add("STRING");		//GST_CODE
			hdrDataTypeList.add("STRING");		//SITE_CODE
			hdrDataTypeList.add("STRING");		//PRD_CODE
			
			detColumnList.add("TRAN_ID");
			detColumnList.add("LINE_NO");
			detColumnList.add("TAXABLE_AMT");
			detColumnList.add("GST_RATE");
			detColumnList.add("IGST_PERC");
			detColumnList.add("IGST_AMT");
			detColumnList.add("CESS_AMT");
			detColumnList.add("ITC_TYPE");
			detColumnList.add("ITC_IGST");
			detColumnList.add("ITC_CESS");
			
			detDataTypeList.add("STRING");		//TRAN_ID
			detDataTypeList.add("INT");			//LINE_NO
			detDataTypeList.add("DOUBLE");		//TAXABLE_AMT
			detDataTypeList.add("DOUBLE");		//GST_RATE
			detDataTypeList.add("DOUBLE");		//IGST_PERC
			detDataTypeList.add("DOUBLE");		//IGST_AMT
			detDataTypeList.add("DOUBLE");		//CESS_AMT
			detDataTypeList.add("STRING");		//ITC_TYPE
			detDataTypeList.add("DOUBLE");		//ITC_IGST
			detDataTypeList.add("DOUBLE");		//ITC_CESS
			
			tranType = "04";
			
			imsInvoiceArry = gstr2InvoiceJsonObj.getJSONArray("imp_s");
			
			for(int i=0; i<gstr2InvoiceJsonObj.length(); i++)
			{
				imsJsonObj = imsInvoiceArry.getJSONObject(i);
				
				invoiceId = imsJsonObj.getString("inum");
				invoiceDate = imsJsonObj.getString("idt");
				amount = imsJsonObj.getDouble("ival");
				checkSum = imsJsonObj.getString("chksum");
				gstCode = imsJsonObj.getString("pos");
				
				tranId = generateTranId("w_gstr_purc","","",conn);
				
				hdrDataList = new ArrayList<String>();
				hdrDataList.add(tranId);
				hdrDataList.add(e12GenericUtility.getValidDateString(new Date(), e12GenericUtility.getDBDateFormat()));
				hdrDataList.add("2");
				hdrDataList.add(tranType);
				hdrDataList.add("D");
				hdrDataList.add(checkSum);
				hdrDataList.add(invoiceId);
				hdrDataList.add(invoiceDate);
				hdrDataList.add(String.valueOf(amount));
				hdrDataList.add(gstCode);
				hdrDataList.add(siteCode);
				hdrDataList.add(periodCode);
				
				detDataList = new ArrayList<List<String>>();
				imsInvLineItmsArry = imsJsonObj.getJSONArray("itms");
				
				for(int j=0; j<imsInvLineItmsArry.length(); j++)
				{
					imsInvLineItemObj = imsInvLineItmsArry.getJSONObject(j);
					
					lineNo = imsInvLineItemObj.getInt("num");
					taxableValue = imsInvLineItemObj.getDouble("txval");
					rate = imsInvLineItemObj.getDouble("rt");
					igstAmt = imsInvLineItemObj.getDouble("iamt");
					cessAmt = imsInvLineItemObj.getDouble("csamt");
					itcType = imsInvLineItemObj.getString("elg");
					itcIGSTAmt = imsInvLineItemObj.getDouble("tx_i");
					itcCessAmt = imsInvLineItemObj.getDouble("tx_cs");
					
					List<String> tempList = new ArrayList<String>();
					tempList.add(tranId);
					tempList.add(String.valueOf(lineNo));
					tempList.add(String.valueOf(taxableValue));
					tempList.add(String.valueOf(rate));
					tempList.add(String.valueOf(rate));
					tempList.add(String.valueOf(igstAmt));
					tempList.add(String.valueOf(cessAmt));
					tempList.add(itcType);
					tempList.add(String.valueOf(itcIGSTAmt));
					tempList.add(String.valueOf(itcCessAmt));
					
					detDataList.add(tempList);
				}
				insertGSTHdrDetData(hdrColumnList, hdrDataTypeList, hdrDataList, detColumnList, detDataTypeList, detDataList, conn);
			}
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.insertIMSInvoiceData()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
	}*/
	private void insertCDNData(String stateCode, String periodCode, String siteCode, JSONObject gstr2InvoiceJsonObj, String xtraParams, Connection conn) throws ITMException
	{
		JSONArray cdnArry = new JSONArray();
		JSONObject cdnJsonObj = new JSONObject();
		JSONArray cdnJsonArry = new JSONArray();
		JSONObject cdnDataJsonObj = new JSONObject();
		JSONArray cdnInvLineItmsArry = new JSONArray();
		JSONObject cdnInvLineItemObj = new JSONObject();
		String tranId = "", cptyGSTIN = "", invoiceId = "", invoiceDate = "", docCheckSum = "", tranType = ""; 
		String creditDebitId = "", creditDebitDate = "", creditDebitType = "", reason = "", loginCode = "", chgTerm = "";
		
		int lineNo = 0, hdrInsCnt = 0;
		double amount = 0.0, lineAmt = 0.0, irt = 0.0, iamt = 0.0, crt = 0.0, camt = 0.0, srt = 0.0, samt = 0.0, csamt = 0.0, rate = 0.0; 
		int [] detInsCnt = null;
		
		String hdrInsSql = "", detInsSql = "";
		PreparedStatement hdrInsPstmt = null, detInsPstmt = null;
		boolean isError = false;
	 	
		
		try
		{
			loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			
			
			cdnArry = gstr2InvoiceJsonObj.getJSONArray("cdn");
			
			for(int i = 0; i < cdnArry.length(); i++)
			{
				cdnJsonObj = cdnArry.getJSONObject(i);
				cptyGSTIN = cdnJsonObj.getString("ctin");
				
				cdnJsonArry = cdnJsonObj.getJSONArray("nt");
				
				for(int j=0; j<cdnJsonArry.length(); j++)
				{
					hdrInsSql = " INSERT INTO GST_DATA_HDR (TRAN_ID, TRAN_DATE, TRAN_ID__REF, SITE_CODE, PRD_CODE, REC_TYPE, TRAN_TYPE, CUST_CODE, CUST_NAME,"
							+ " SUBMISSION_TYPE, DOC_CHECKSUM, DOC_TYPE, DOC_NO, DOC_DATE, AMOUNT, REVERSE_CHRG, LR_NO, LR_DATE, REAS_CODE, REF_ID__INV,"
							+ " REF_DATE__INV, PROV_ASSMNT, ORDER_NO, ORDER_DATE, REMARKS, SUBMIT_STATUS, SUBMIT_DATE, ADD_USER, ADD_DATE, ADD_TERM, CHG_USER,"
							+ " CHG_DATE, CHG_TERM, TAX_REG_NO, RECO_STATUS, ECOM_REG_NO, REF_SER, GST_CODE, GST_TYPE, REF_ID)"
							+ " VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
					hdrInsPstmt = conn.prepareStatement(hdrInsSql);
					
					cdnDataJsonObj = cdnJsonArry.getJSONObject(j);
					
					creditDebitId = cdnDataJsonObj.getString("nt_num");
					creditDebitDate = cdnDataJsonObj.getString("nt_dt");
					creditDebitType = cdnDataJsonObj.getString("ntty");
					amount = cdnDataJsonObj.getDouble("val");
					invoiceId = cdnDataJsonObj.getString("inum");
					invoiceDate = cdnDataJsonObj.getString("idt");
					docCheckSum = cdnDataJsonObj.getString("chksum");
					reason = cdnDataJsonObj.getString("rsn");
					
					if("C".equalsIgnoreCase(creditDebitType))
					{
						tranType = "29";
					}
					else if("D".equalsIgnoreCase(creditDebitType))
					{
						tranType = "30";
					}
										
					tranId = generateTranId("w_gstr_purc","","",conn);
					
					hdrInsPstmt.setString(1, tranId);
					hdrInsPstmt.setTimestamp(2, java.sql.Timestamp.valueOf(e12GenericUtility.getValidDateString(new Date(), e12GenericUtility.getDBDateTimeFormat())));
					hdrInsPstmt.setString(3, null);
					hdrInsPstmt.setString(4, siteCode);
					hdrInsPstmt.setString(5, periodCode);
					hdrInsPstmt.setString(6, "4");
					hdrInsPstmt.setString(7, tranType);
					hdrInsPstmt.setString(8, null);
					hdrInsPstmt.setString(9, null);
					hdrInsPstmt.setString(10, null);
					hdrInsPstmt.setString(11, docCheckSum);
					hdrInsPstmt.setString(12, null);
					hdrInsPstmt.setString(13, creditDebitId);
					hdrInsPstmt.setTimestamp(14, getTimeStamp(creditDebitDate));
					hdrInsPstmt.setDouble(15, amount);
					hdrInsPstmt.setString(16, null);
					hdrInsPstmt.setString(17, null);
					hdrInsPstmt.setTimestamp(18, null);
					hdrInsPstmt.setString(19, reason);
					hdrInsPstmt.setString(20, invoiceId);
					hdrInsPstmt.setTimestamp(21, getTimeStamp(invoiceDate));
					hdrInsPstmt.setString(22, null);
					hdrInsPstmt.setString(23, null);
					hdrInsPstmt.setTimestamp(24, null);
					hdrInsPstmt.setString(25, null);
					hdrInsPstmt.setString(26, "D");
					hdrInsPstmt.setTimestamp(27, null);
					hdrInsPstmt.setString(28, loginCode);
					hdrInsPstmt.setTimestamp(29, java.sql.Timestamp.valueOf(e12GenericUtility.getValidDateString(new Date(), e12GenericUtility.getDBDateTimeFormat())));
					hdrInsPstmt.setString(30, chgTerm);
					hdrInsPstmt.setString(31, loginCode);
					hdrInsPstmt.setTimestamp(32, java.sql.Timestamp.valueOf(e12GenericUtility.getValidDateString(new Date(), e12GenericUtility.getDBDateTimeFormat())));
					hdrInsPstmt.setString(33, chgTerm);
					hdrInsPstmt.setString(34, cptyGSTIN);
					hdrInsPstmt.setString(35, null);
					hdrInsPstmt.setString(36, null);
					hdrInsPstmt.setString(37, null);
					hdrInsPstmt.setString(38, stateCode);
					hdrInsPstmt.setString(39, null);
					hdrInsPstmt.setString(40, null);
					
					hdrInsCnt = hdrInsPstmt.executeUpdate();
					
					if(hdrInsPstmt != null)
					{
						hdrInsPstmt.close();
						hdrInsPstmt = null;
					}
					
					System.out.println("header insert count for Credit/Debit note["+hdrInsCnt+"]");
					
					detInsSql = " INSERT INTO GST_DATA_DET (TRAN_ID, LINE_NO, STATUS, SR_NO__OLD, LINE_TYPE, GS_CODE, TAXABLE_AMT, IGST_PERC,"
							  + " IGST_AMT, CGST_PERC, CGST_AMT, SGST_PERC, SGST_AMT, GS_DESCR, UNIT, QUANTITY, SUPPLY_TYPE, CESS_PERC, CESS_AMT,"
							  + " REMARKS, ITC_TYPE, ITC_IGST, ITC_CGST, ITC_SGST, ITC_CESS, GST_RATE)"
							  + " VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
					
					detInsPstmt = conn.prepareStatement(detInsSql);
					
					cdnInvLineItmsArry = cdnDataJsonObj.getJSONArray("itms");
					
					for(int k=0; k<cdnInvLineItmsArry.length(); k++)
					{
						cdnInvLineItemObj = cdnInvLineItmsArry.getJSONObject(k);
						
						lineNo = cdnInvLineItemObj.getInt("num");
						
						JSONObject tempJSONObj = cdnInvLineItemObj.getJSONObject("itm_det");
						
						rate = tempJSONObj.getDouble("rt");
						lineAmt = tempJSONObj.getDouble("txval");
						if(tempJSONObj.has("iamt"))
						{
							iamt = tempJSONObj.getDouble("iamt");
						}
						if(tempJSONObj.has("camt"))
						{
							camt = tempJSONObj.getDouble("camt");
						}
						if(tempJSONObj.has("samt"))
						{
							samt = tempJSONObj.getDouble("samt");
						}
						if(tempJSONObj.has("csamt"))
						{
							csamt = tempJSONObj.getDouble("csamt");
						}  
						
						if(iamt > 0)
						{
							irt = rate;
						}
						else if (camt > 0 && samt > 0)
						{
							crt = rate/2;
							srt = rate/2;
						}
						
						detInsPstmt.setString(1, tranId);
						detInsPstmt.setInt(2, lineNo);
						detInsPstmt.setString(3, null);
						detInsPstmt.setInt(4, 0);
						detInsPstmt.setString(5, null);
						detInsPstmt.setString(6, null);
						detInsPstmt.setDouble(7, lineAmt);
						detInsPstmt.setDouble(8, irt);
						detInsPstmt.setDouble(9, iamt);
						detInsPstmt.setDouble(10, crt);
						detInsPstmt.setDouble(11, camt);
						detInsPstmt.setDouble(12, srt);
						detInsPstmt.setDouble(13, samt);
						detInsPstmt.setString(14, null);
						detInsPstmt.setString(15, null);
						detInsPstmt.setInt(16, 0);
						detInsPstmt.setString(17, null);
						detInsPstmt.setDouble(18, 0.0);
						detInsPstmt.setDouble(19, csamt);
						detInsPstmt.setString(20, null);
						detInsPstmt.setString(21, null);
						detInsPstmt.setDouble(22, 0.0);
						detInsPstmt.setDouble(23, 0.0);
						detInsPstmt.setDouble(24, 0.0);
						detInsPstmt.setDouble(25, 0.0);
						detInsPstmt.setDouble(26, rate);
						
						detInsPstmt.addBatch();
						detInsPstmt.clearParameters();
					}
					
					detInsCnt = detInsPstmt.executeBatch();
					
					if(detInsPstmt != null)
					{
						detInsPstmt.close();
						detInsPstmt = null;
					}
					
					if(detInsCnt!=null)
					{
						for(int eachRowCnt : detInsCnt)
						{
							System.out.println("detail row insert count for Credit/Debit note ["+eachRowCnt+"]");
						}
					}
				}
			}
		}
		catch (Exception e)
		{
			isError = true;
			System.out.println("GSTDataSubmitWizPos.insertCDNData()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(isError)
				{
					if(hdrInsPstmt != null)
					{
						hdrInsPstmt.close();
						hdrInsPstmt = null;
					}
					if(detInsPstmt != null)
					{
						detInsPstmt.close();
						detInsPstmt = null;
					}
				}
			}
			catch(SQLException se)
			{
				System.out.println("GSTDataSubmitWizPos.insertCDNData()["+se.getMessage()+"]");
				se.printStackTrace();
			}
		}
	}
	/*private void insertNILData(String stateCode, String periodCode, String siteCode, JSONObject gstr2InvoiceJsonObj, Connection conn) throws ITMException
	{
		JSONObject nilJsonObj = null, nilInterJsonObj = null, nilIntraJsonObj = null;
		HashMap<String, String> nilSuppliesAmtHMap = null;
		String tranId = "";
		List<String> hdrColumnList = new ArrayList<String>(), hdrDataTypeList = new ArrayList<String>(), hdrDataList = null;
		
		try
		{
			hdrColumnList.add("TRAN_ID");
			hdrColumnList.add("TRAN_DATE");
			hdrColumnList.add("TRAN_TYPE");
			hdrColumnList.add("SITE_CODE");
			hdrColumnList.add("PRD_CODE");
			hdrColumnList.add("REC_TYPE");
			hdrColumnList.add("AMOUNT");
			hdrColumnList.add("SUBMIT_STATUS");
			
			hdrDataTypeList.add("STRING");		//TRAN_ID
			hdrDataTypeList.add("TIMESTAMP");	//TRAN_DATE
			hdrDataTypeList.add("STRING");		//TRAN_TYPE
			hdrDataTypeList.add("STRING");		//SITE_CODE
			hdrDataTypeList.add("STRING");		//PRD_CODE
			hdrDataTypeList.add("STRING");		//REC_TYPE
			hdrDataTypeList.add("DOUBLE");		//AMOUNT
			hdrDataTypeList.add("STRING");		//SUBMIT_STATUS
			
			nilJsonObj = gstr2InvoiceJsonObj.getJSONObject("nil_supplies");
			if(nilJsonObj.has("inter"))
			{
				
				nilInterJsonObj = nilJsonObj.getJSONObject("inter");
				nilSuppliesAmtHMap = new HashMap<String, String>();
				nilSuppliesAmtHMap.put("13", String.valueOf(nilInterJsonObj.getDouble("cpddr")));
				nilSuppliesAmtHMap.put("14", String.valueOf(nilInterJsonObj.getDouble("exptdsply")));
				nilSuppliesAmtHMap.put("15", String.valueOf(nilInterJsonObj.getDouble("ngsply")));
				nilSuppliesAmtHMap.put("16", String.valueOf(nilInterJsonObj.getDouble("nilsply")));
				
				Set<String> tranTypeKeySet = nilSuppliesAmtHMap.keySet();
				
				for(String tranType : tranTypeKeySet)
				{
					hdrDataList = new ArrayList<String>();
					tranId = generateTranId("w_gstr_purc","","",conn);
					hdrDataList.add(tranId);
					hdrDataList.add(e12GenericUtility.getValidDateString(new Date(), e12GenericUtility.getDBDateFormat()));
					hdrDataList.add(tranType);
					hdrDataList.add(siteCode);
					hdrDataList.add(periodCode);
					hdrDataList.add("2");
					hdrDataList.add(nilSuppliesAmtHMap.get(tranType));
					hdrDataList.add("D");
					
					insertGSTHdrDetData(hdrColumnList, hdrDataTypeList, hdrDataList, null, null, null, conn);
				}
			}
			if(nilJsonObj.has("intra"))
			{
				nilIntraJsonObj = nilJsonObj.getJSONObject("intra");
				nilSuppliesAmtHMap = new HashMap<String, String>();
				nilSuppliesAmtHMap.put("17", String.valueOf(nilIntraJsonObj.getDouble("cpddr")));
				nilSuppliesAmtHMap.put("18", String.valueOf(nilIntraJsonObj.getDouble("exptdsply")));
				nilSuppliesAmtHMap.put("19", String.valueOf(nilIntraJsonObj.getDouble("ngsply")));
				nilSuppliesAmtHMap.put("20", String.valueOf(nilIntraJsonObj.getDouble("nilsply")));
				
				Set<String> tranTypeKeySet = nilSuppliesAmtHMap.keySet();
				
				for(String tranType : tranTypeKeySet)
				{
					hdrDataList = new ArrayList<String>();
					tranId = generateTranId("w_gstr_purc","","",conn);
					hdrDataList.add(tranId);
					hdrDataList.add(e12GenericUtility.getValidDateString(new Date(), e12GenericUtility.getDBDateFormat()));
					hdrDataList.add(tranType);
					hdrDataList.add(siteCode);
					hdrDataList.add(periodCode);
					hdrDataList.add("2");
					hdrDataList.add(nilSuppliesAmtHMap.get(tranType));
					hdrDataList.add("D");
					
					insertGSTHdrDetData(hdrColumnList, hdrDataTypeList, hdrDataList, null, null, null, conn);
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.insertNILData()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
	}
	private void insertTXIData(String stateCode, String periodCode, String siteCode, JSONObject gstr2InvoiceJsonObj, String action, Connection conn) throws ITMException
	{
		JSONArray txiDataJsonArry = null;
		JSONObject txiDataJsonObj = null;
		JSONArray txiDataLineItemJsonArry = null;
		JSONObject txiDataLineItemJsonObj = null;
		
		String gstCode = "", supplyType = "", tranType = "", tranId = "";
		int lineNo = 0;
		double rate = 0.0, advAmt = 0.0, igstPerc = 0.0, igstAmt = 0.0, cgstPerc = 0.0, cgstAmt = 0.0, sgstPerc = 0.0, sgstAmt = 0.0, cessAmt = 0.0;
		
		List<String> hdrColumnList = new ArrayList<String>(), hdrDataTypeList = new ArrayList<String>(), hdrDataList = null;
	 	List<String> detColumnList = new ArrayList<String>(),  detDataTypeList = new ArrayList<String>();
	 	List<List<String>> detDataList = null;
		try
		{
			hdrColumnList.add("TRAN_ID");
			hdrColumnList.add("TRAN_DATE");
			hdrColumnList.add("TRAN_TYPE");
			hdrColumnList.add("SITE_CODE");
			hdrColumnList.add("PRD_CODE");
			hdrColumnList.add("REC_TYPE");
			hdrColumnList.add("GST_CODE");
			hdrColumnList.add("SUBMIT_STATUS");
			
			hdrDataTypeList.add("STRING");		//TRAN_ID
			hdrDataTypeList.add("TIMESTAMP");	//TRAN_DATE
			hdrDataTypeList.add("STRING");		//TRAN_TYPE
			hdrDataTypeList.add("STRING");		//SITE_CODE
			hdrDataTypeList.add("STRING");		//PRD_CODE
			hdrDataTypeList.add("STRING");		//REC_TYPE
			hdrDataTypeList.add("STRING");		//AMOUNT
			hdrDataTypeList.add("STRING");		//SUBMIT_STATUS
			
			detColumnList.add("TRAN_ID");
			detColumnList.add("LINE_NO");
			detColumnList.add("TAXABLE_AMT");
			detColumnList.add("GST_RATE");
			detColumnList.add("IGST_PERC");
			detColumnList.add("IGST_AMT");
			detColumnList.add("CGST_PERC");
			detColumnList.add("CGST_AMT");
			detColumnList.add("SGST_PERC");
			detColumnList.add("SGST_AMT");
			detColumnList.add("CESS_AMT");
			
			detDataTypeList.add("STRING");		//TRAN_ID
			detDataTypeList.add("INT");			//LINE_NO
			detDataTypeList.add("DOUBLE");		//TAXABLE_AMT
			detDataTypeList.add("DOUBLE");		//GST_RATE
			detDataTypeList.add("DOUBLE");		//IGST_PERC
			detDataTypeList.add("DOUBLE");		//IGST_AMT
			detDataTypeList.add("DOUBLE");		//CGST_PERC
			detDataTypeList.add("DOUBLE");		//CGST_AMT
			detDataTypeList.add("DOUBLE");		//SGST_PERC
			detDataTypeList.add("DOUBLE");		//SGST_AMT
			detDataTypeList.add("DOUBLE");		//CESS_AMT
			
			txiDataJsonArry = gstr2InvoiceJsonObj.getJSONArray("txi");
			
			for(int i=0; i<txiDataJsonArry.length(); i++)
			{
				hdrDataList = new ArrayList<String>();
				txiDataJsonObj = txiDataJsonArry.getJSONObject(i);
				
				gstCode = txiDataJsonObj.getString("pos");
				supplyType = txiDataJsonObj.getString("sply_ty");
				
				if("TXLI".equalsIgnoreCase(action))
				{
					if("INTER".equalsIgnoreCase(supplyType))
					{
						tranType = "20";
					}
					else  if("INTRA".equalsIgnoreCase(supplyType))
					{
						tranType = "19";
					}
				}
				if("TXP".equalsIgnoreCase(action))
				{
					if("INTER".equalsIgnoreCase(supplyType))
					{
						tranType = "22";
					}
					else  if("INTRA".equalsIgnoreCase(supplyType))
					{
						tranType = "21";
					}
				}
									
				tranId = generateTranId("w_gstr_purc","","",conn);
				
				hdrDataList.add(tranId);
				hdrDataList.add(e12GenericUtility.getValidDateString(new Date(), e12GenericUtility.getDBDateFormat()));
				hdrDataList.add(tranType);
				hdrDataList.add(siteCode);
				hdrDataList.add(periodCode);
				hdrDataList.add("2");
				hdrDataList.add(gstCode);
				hdrDataList.add("D");
				
				detDataList = new ArrayList<List<String>>();
				txiDataLineItemJsonArry = txiDataJsonObj.getJSONArray("itms");
				for(int j=0; j<txiDataLineItemJsonArry.length(); j++)
				{
					ArrayList<String> tempList = new ArrayList<String>();
					txiDataLineItemJsonObj = txiDataLineItemJsonArry.getJSONObject(j);
					
					lineNo = txiDataLineItemJsonObj.getInt("num");
					rate = txiDataLineItemJsonObj.getDouble("rt");
					if("INTER".equalsIgnoreCase(supplyType))
					{
						igstPerc = 0.0;
						cgstPerc = rate/2;
						sgstPerc = rate/2;
					}
					else  if("INTRA".equalsIgnoreCase(supplyType))
					{
						igstPerc = rate;
						cgstPerc = 0.0;
						sgstPerc = 0.0;
					}
					advAmt = txiDataLineItemJsonObj.getDouble("adamt");
					igstAmt = txiDataLineItemJsonObj.getDouble("iamt");
					cgstAmt = txiDataLineItemJsonObj.getDouble("camt");
					sgstAmt = txiDataLineItemJsonObj.getDouble("samt");
					cessAmt = txiDataLineItemJsonObj.getDouble("csamt");
					
					tempList.add(tranId);
					tempList.add(String.valueOf(lineNo));
					tempList.add(String.valueOf(advAmt));
					tempList.add(String.valueOf(rate));
					tempList.add(String.valueOf(igstPerc));
					tempList.add(String.valueOf(igstAmt));
					tempList.add(String.valueOf(cgstPerc));
					tempList.add(String.valueOf(cgstAmt));
					tempList.add(String.valueOf(sgstPerc));
					tempList.add(String.valueOf(sgstAmt));
					tempList.add(String.valueOf(cessAmt));
					
					detDataList.add(tempList);
				}
				insertGSTHdrDetData(hdrColumnList, hdrDataTypeList, hdrDataList, detColumnList, detDataTypeList, detDataList, conn);
			}
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.insertTXIData()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
	}*/
	private void updateSubmissionStatus(ArrayList<String> tranIdList, String actionFlag, Connection conn) throws ITMException
	{
		String updateSql = "", submitStatus = "";
		PreparedStatement pstmtUpd = null;
		
		try
		{
			if("S".equalsIgnoreCase(actionFlag))
			{
				submitStatus = "T";
			}
			else if("D".equalsIgnoreCase(actionFlag))
			{
				submitStatus = "P";
			}
			updateSql = "UPDATE GST_DATA_HDR SET SUBMIT_STATUS = ?, SUBMIT_DATE = ? WHERE TRAN_ID = ?";
			pstmtUpd = conn.prepareStatement(updateSql);
			
			for(String tranId : tranIdList)
			{
				pstmtUpd.setString(1, submitStatus);
				pstmtUpd.setTimestamp(2, java.sql.Timestamp.valueOf(e12GenericUtility.getValidDateString(new Date(), e12GenericUtility.getDBDateTimeFormat())));
				pstmtUpd.setString(3, tranId);
				
				pstmtUpd.addBatch();
				pstmtUpd.clearParameters();
			}
			
			int[] updateCount = pstmtUpd.executeBatch();
			
			System.out.print("GST_DATA_HDR Update count");
			
			for(int eachRowCnt : updateCount)
			{
				System.out.print(eachRowCnt + ",");
			}
			System.out.println("");
		}
		catch (Exception e) 
		{
			System.out.println("GSTDataSubmitWizPos.updateSubmissionStatus()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
	}
	
	private String getError(String errMsg, String Code, Connection conn)  throws ITMException, Exception
	{
		String mainStr ="";

		try
		{
			String errString = "";
			errString =  new ITMDBAccessEJB().getErrorString("",Code,"","",conn);
			
			String begPart = errString.substring(0,errString.indexOf("</description>"));
			String endDesc = errString.substring(errString.indexOf("</description>"),errString.length());
			mainStr = checkNullandTrim(begPart) + "<![CDATA[" +errMsg+ " ]]>" + checkNullandTrim(endDesc);
			System.out.println("mainStr:::::::::::::::::: "+mainStr);
			begPart = null;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return mainStr;
	}
	
	private String getRetStatusErrMsg(JSONObject retStatusJsonObj) throws ITMException
	{
		String retString = "";
		JSONObject errorJsonObj = null;
		
		try
		{
			if(retStatusJsonObj.has("error_report"))
			{
				errorJsonObj = retStatusJsonObj.getJSONObject("error_report");
				
				String[] secKeys = JSONObject.getNames(errorJsonObj);
				
				for(String eachSectionName : secKeys)
				{
					retString += "Section : "+eachSectionName.toUpperCase()+"\n\r";
					
					JSONArray eachSecErrJsonArry = errorJsonObj.getJSONArray(eachSectionName);
					
					for(int i=0; i<eachSecErrJsonArry.length(); i++)
					{
						JSONObject eachSecErrJsonObj = eachSecErrJsonArry.getJSONObject(i);
						
						if(eachSecErrJsonObj.has("error_msg"))
						{
							retString += eachSecErrJsonObj.getString("error_msg");
						}
						if(eachSecErrJsonObj.has("hsn_sc"))
						{
							retString += " HSN/SAC : "+eachSecErrJsonObj.getString("hsn_sc");
						}
						if(eachSecErrJsonObj.has("desc"))
						{
							retString += ", Description : "+eachSecErrJsonObj.getString("desc");
						}
						if(eachSecErrJsonObj.has("uqc"))
						{
							retString += ", UQC : "+eachSecErrJsonObj.getString("uqc");
						}
						if(eachSecErrJsonObj.has("inum"))
						{
							retString += ", Invoice No. : "+eachSecErrJsonObj.getString("inum");
						}
						if(eachSecErrJsonObj.has("idt"))
						{
							retString += ", Dated : "+eachSecErrJsonObj.getString("idt");
						}
						if(eachSecErrJsonObj.has("pos"))
						{
							retString += ", POS : "+eachSecErrJsonObj.getString("pos");
						}
						if(eachSecErrJsonObj.has("inv_typ"))
						{
							retString += ", Invoice Type : "+eachSecErrJsonObj.getString("inv_typ");
						}
						if(eachSecErrJsonObj.has("nt_num") && eachSecErrJsonObj.has("nt_dt"))
						{
							retString += " Credit/Debit No. : "+eachSecErrJsonObj.getString("nt_num")+ " Credit/Debit Dt. : "+eachSecErrJsonObj.getString("nt_dt");
						}
						retString += "\n\r";
					}
				}
			}
			else
			{
				retString = "Some error occurred!";
			}
			
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.getRetStatusErrMsg()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		
		return retString;
	}
	
	private Invoice getNilRateSummary(String supplyType, String nilAmtTranType, String exmptAmtTranType, String nonGSTAmtTranType, String siteCode, String periodCode, Connection conn)
	{
		Invoice invoice = null;
		double nilAmount = 0.0, exemtAmount = 0.0, nonGSTAmount = 0.0;
		
		String sql= "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		try
		{
			sql = " SELECT TRAN_TYPE,SUM(AMOUNT) AS AMOUNT FROM GST_DATA_HDR "
				+ " WHERE REC_TYPE = '1' AND TRAN_TYPE  in (?,?,?) AND SITE_CODE = ? AND PRD_CODE = ?"
				+ " GROUP BY TRAN_TYPE";
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, nilAmtTranType);
			pstmt.setString(2, exmptAmtTranType);
			pstmt.setString(3, nonGSTAmtTranType);
			pstmt.setString(4, siteCode);
			pstmt.setString(5, periodCode);
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				if(invoice == null)
				{
					invoice = new Invoice();
				}
				if(nilAmtTranType.equalsIgnoreCase(rs.getString("TRAN_TYPE")))
				{
					nilAmount = rs.getDouble("AMOUNT");
				}
				if(exmptAmtTranType.equalsIgnoreCase(rs.getString("TRAN_TYPE")))
				{
					exemtAmount = rs.getDouble("AMOUNT");
				}
				if(nonGSTAmtTranType.equalsIgnoreCase(rs.getString("TRAN_TYPE")))
				{
					nonGSTAmount = rs.getDouble("AMOUNT");
				}
			}
			
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			
			if(invoice != null)
			{
				invoice.supplyType = supplyType;
				invoice.totalNilAmount = nilAmount;
				invoice.totalExemptedAmount = exemtAmount;
				invoice.totalNonGSTAmout = nonGSTAmount;
			}
			
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.getNilRateSummary()["+e.getMessage()+"]");
			e.printStackTrace();
		}
		
		return invoice;
	}
	private InterNilSupplies getInterNilRateSummary(String compundingAmtTranType, String exmptAmtTranType, String nonGSTAmtTranType, String nilAmtTranType, String siteCode, String periodCode, Connection conn)
	{
		InterNilSupplies interNilSupplies = null;
		double nilAmount = 0.0, exemtAmount = 0.0, nonGSTAmount = 0.0, compoundingAmount = 0.0;
		
		String sql= "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		try
		{
			sql = " SELECT TRAN_TYPE,SUM(AMOUNT) AS AMOUNT FROM GST_DATA_HDR "
				+ " WHERE REC_TYPE = '2' AND TRAN_TYPE  in (?,?,?,?) AND SITE_CODE = ? AND PRD_CODE = ?"
				+ " GROUP BY TRAN_TYPE";
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, nilAmtTranType);
			pstmt.setString(2, exmptAmtTranType);
			pstmt.setString(3, nonGSTAmtTranType);
			pstmt.setString(4, compundingAmtTranType);
			pstmt.setString(5, siteCode);
			pstmt.setString(6, periodCode);
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				if(interNilSupplies == null)
				{
					interNilSupplies = new InterNilSupplies();
				}
				if(nilAmtTranType.equalsIgnoreCase(rs.getString("TRAN_TYPE")))
				{
					nilAmount = rs.getDouble("AMOUNT");
				}
				if(exmptAmtTranType.equalsIgnoreCase(rs.getString("TRAN_TYPE")))
				{
					exemtAmount = rs.getDouble("AMOUNT");
				}
				if(nonGSTAmtTranType.equalsIgnoreCase(rs.getString("TRAN_TYPE")))
				{
					nonGSTAmount = rs.getDouble("AMOUNT");
				}
				if(compundingAmtTranType.equalsIgnoreCase(rs.getString("TRAN_TYPE")))
				{
					compoundingAmount = rs.getDouble("AMOUNT");
				}
			}
			
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			
			if(interNilSupplies != null)
			{
				interNilSupplies.compoundSuppliesAmt = compoundingAmount;
				interNilSupplies.nilSuppliesAmt = nilAmount;
				interNilSupplies.exempetedSuppliesAmt = exemtAmount;
				interNilSupplies.nonGSTSuppliesAmt = nonGSTAmount;
			}
			
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.getInterNilRateSummary()["+e.getMessage()+"]");
			e.printStackTrace();
		}
		
		return interNilSupplies;
	}
	private IntraNilSupplies getIntraNilRateSummary(String compundingAmtTranType, String exmptAmtTranType, String nonGSTAmtTranType, String nilAmtTranType, String siteCode, String periodCode, Connection conn)
	{
		IntraNilSupplies intraNilSupplies = null;
		double nilAmount = 0.0, exemtAmount = 0.0, nonGSTAmount = 0.0, compoundingAmount = 0.0;
		
		String sql= "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		try
		{
			sql = " SELECT TRAN_TYPE,SUM(AMOUNT) AS AMOUNT FROM GST_DATA_HDR "
				+ " WHERE REC_TYPE = '2' AND TRAN_TYPE  in (?,?,?,?) AND SITE_CODE = ? AND PRD_CODE = ?"
				+ " GROUP BY TRAN_TYPE";
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, nilAmtTranType);
			pstmt.setString(2, exmptAmtTranType);
			pstmt.setString(3, nonGSTAmtTranType);
			pstmt.setString(4, compundingAmtTranType);
			pstmt.setString(5, siteCode);
			pstmt.setString(6, periodCode);
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				if(intraNilSupplies == null)
				{
					intraNilSupplies = new IntraNilSupplies();
				}
				if(nilAmtTranType.equalsIgnoreCase(rs.getString("TRAN_TYPE")))
				{
					nilAmount = rs.getDouble("AMOUNT");
				}
				if(exmptAmtTranType.equalsIgnoreCase(rs.getString("TRAN_TYPE")))
				{
					exemtAmount = rs.getDouble("AMOUNT");
				}
				if(nonGSTAmtTranType.equalsIgnoreCase(rs.getString("TRAN_TYPE")))
				{
					nonGSTAmount = rs.getDouble("AMOUNT");
				}
				if(compundingAmtTranType.equalsIgnoreCase(rs.getString("TRAN_TYPE")))
				{
					compoundingAmount = rs.getDouble("AMOUNT");
				}
			}
			
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			
			if(intraNilSupplies != null)
			{
				intraNilSupplies.compoundSuppliesAmt = compoundingAmount;
				intraNilSupplies.nilSuppliesAmt = nilAmount;
				intraNilSupplies.exempetedSuppliesAmt = exemtAmount;
				intraNilSupplies.nonGSTSuppliesAmt = nonGSTAmount;
			}
			
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.getIntraNilRateSummary()["+e.getMessage()+"]");
			e.printStackTrace();
		}
		
		return intraNilSupplies;
	}
	public String saveGSTRData(String jsonPayload, int noOfRecords, ArrayList<String> tranIdList, String recType, Connection conn, String xtraParams) throws ITMException
	{
		String retString = "";
		String gspAuthString = "", gspAuthSignature = "", transactionId = "", RETURN_URL = "", errMsg = "", callStatus = "", responseId = "", 
			   responseJsonStr = "",loginCode = "", chgTerm = "", siteCode = "", gstrData = "", gstrRek = "";
		Date restSaveEndTime = null;
		long diffStatus = 0L;
		
		try
		{
			siteCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			
			transactionId = UUID.randomUUID().toString().replaceAll("-", "");
			
			byte[] jsonBase64 = Base64.getEncoder().encode(jsonPayload.getBytes());
			String encryptedPayload = aesEncryption.encryptEK(jsonBase64, authSEK);
			 
			HMac hmac = new HMac(new SHA256Digest());
			byte[] resBuf = new byte[hmac.getMacSize()];
			
			hmac.init(new KeyParameter(authSEK));
			hmac.update(jsonBase64, 0, jsonBase64.length);
			hmac.doFinal(resBuf, 0);
			
			JSONObject gstr1HeaderObj = new JSONObject();
			gstr1HeaderObj.put("action", "RETSAVE");
			gstr1HeaderObj.put("data", encryptedPayload);
			gstr1HeaderObj.put("hmac", new String(Base64.getEncoder().encode(resBuf)));
			
			long timeStamp = new Timestamp().getDateTime();
	        gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin;
			gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
			
			Date startTime = new Date();
			
			if("1".equalsIgnoreCase(recType))
			{
				RETURN_URL = GSTR1_URL;
			}
			else if("2".equalsIgnoreCase(recType))
			{
				RETURN_URL = GSTR2_URL;
			}
			else if("3".equalsIgnoreCase(recType))
			{
				RETURN_URL = GSTR3_URL;
			}
			else if("6".equalsIgnoreCase(recType))
			{
				RETURN_URL = GSTR3B_URL;
			}
			
			HttpRequest saveGstrReq = Unirest.put(String.format("%s%s", BASE_API_URL, RETURN_URL))
								   	  .header("Content-Type", APPLICATION_JSON)
									  .header("clientid", clientId)
									  .header("client-secret", clientSecret)
									  .header("txn",transactionId)
									  .header("state-cd", stateCode)
									  .header("auth-token", authToken)
									  .header("gstin", gstin)
									  .header("username", userName)
									  .header("ret_period", periodCode)
									  .header("ip-usr", ipAddress)
									  .header("X-Asp-Auth-Token", gspAuthString)
				    	              .header("X-Asp-Auth-Signature", gspAuthSignature)
									  .body(new JsonNode(gstr1HeaderObj.toString()))
									  .getHttpRequest();
			 
			System.out.println("SAVE GSTR"+recType+" url["+saveGstrReq.getUrl()+"]");
			System.out.println("SAVE GSTR"+recType+" method["+saveGstrReq.getHttpMethod()+"]");
			System.out.println("SAVE GSTR"+recType+" request header["+saveGstrReq.getHeaders()+"]");
			System.out.println("SAVE GSTR"+recType+" request payload["+IOUtils.toString(saveGstrReq.getBody().getEntity().getContent())+"]");
			 
			HttpResponse<JsonNode> gstrResp = saveGstrReq.asJson();
			
			System.out.println(String.format("gstrResp Request : Status[%s] Response[%s]", gstrResp.getStatus(), gstrResp.getBody()));
			
			if (gstrResp.getStatus() == 200) 
	        {
				JSONObject gstrRespObj = gstrResp.getBody().getObject();
				
				if(gstrRespObj.has("data") && gstrRespObj.has("rek"))
				{
					callStatus = "1";
					gstrData = gstrRespObj.getString("data");
					gstrRek = gstrRespObj.getString("rek");
					
					byte[] apiEKGstr = aesEncryption.decrypt(gstrRek, authSEK);
					String gstrRespJsoninBase64 = new String(aesEncryption.decrypt(gstrData, apiEKGstr));
					
					byte[] gstrRespJsonInBytes = aesEncryption.decodeBase64StringTOByte(gstrRespJsoninBase64);
					
					JSONObject gstrTransIdRespObj = new JSONObject(new String(gstrRespJsonInBytes));
					String transId = gstrTransIdRespObj.getString("reference_id");
					
					responseId = transId;
					
					System.out.println("transId to getStatus["+transId+"]");
					
					restSaveEndTime = new Date();
					
					long retSaveDiff = restSaveEndTime.getTime() - startTime.getTime();

					long retSaveDiffSeconds = retSaveDiff / 1000 % 60;
					long retSaveDiffMinutes = retSaveDiff / (60 * 1000) % 60;
					long retSaveDiffHours = retSaveDiff / (60 * 60 * 1000);
					
					System.out.println("DIFFERANCE IN TIME FOR RETSAVE GSTR1 ["+gstin+"] IN HH:MM:SS ["+retSaveDiffHours +":"+retSaveDiffMinutes+":"+retSaveDiffSeconds+"]");
					
					retString = getSaveSubmitStatus(transId, tranIdList ,recType, "S", xtraParams, conn);
				}
				else
	            {
					callStatus = "2";
					JSONObject errorJSON = gstrResp.getBody().getObject().getJSONObject("error");
					responseJsonStr = errorJSON.toString();
		        	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
		        	retString = getError(errMsg, "GSTAPIERR", conn);
	            }
	        }
			else if(gstrResp.getStatus() == 500)
	        {
	        	callStatus = "2";
	        	errMsg = "Message : Error occurred at GSTN server \nResponse code : "+gstrResp.getStatus();
	        	responseJsonStr = errMsg;
	        	retString = getError(errMsg, "GSTAPIERR", conn);
	        }
			else
            {
				callStatus = "2";
            	JSONObject errorJSON = gstrResp.getBody().getObject().getJSONObject("error");
            	responseJsonStr = errorJSON.toString();
	        	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
	        	retString = getError(errMsg, "GSTAPIERR", conn);
            }
			
			Date endTime = new Date();
			long diff = endTime.getTime() - startTime.getTime();

			long diffSeconds = diff / 1000 % 60;
			long diffMinutes = diff / (60 * 1000) % 60;
			long diffHours = diff / (60 * 60 * 1000);
			
			if(restSaveEndTime != null)
			{
				diffStatus = endTime.getTime() - restSaveEndTime.getTime();
			}
			
			long diffStatsSeconds = diffStatus / 1000 % 60;
			long diffStatsMinutes = diffStatus / (60 * 1000) % 60;
			long diffStatsHours = diffStatus / (60 * 60 * 1000);
			
			System.out.println("DIFFERANCE IN TIME FOR RETSTATUS GSTR1 ["+gstin+"] IN HH:MM:SS ["+diffStatsHours +":"+diffStatsMinutes+":"+diffStatsSeconds+"]");
			System.out.println("DIFFERANCE IN TIME FOR SAVE GSTR1 ["+gstin+"] IN HH:MM:SS ["+diffHours +":"+diffMinutes+":"+diffSeconds+"]");
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.saveGSTRData()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			APICallData apiCallData = new APICallData();
	        apiCallData.setPeriodCode(periodCode);
	        apiCallData.setCallDate(new Date());
	        apiCallData.setSiteCode(siteCode);
	        apiCallData.setUserId(loginCode);
	        apiCallData.setCallType("RETSAVE");
	        apiCallData.setRecType(recType);
	        apiCallData.setNoOfRecords(noOfRecords);
	        apiCallData.setCallStatus(callStatus);
	        apiCallData.setResponseId(responseId);
	        apiCallData.setResponseJsonStr(responseJsonStr);
	        apiCallData.setChgUser(loginCode);
	        apiCallData.setChgDate(new Date());
	        apiCallData.setChgTerm(chgTerm);
	        
	        gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
	        
		}
		return retString;
	}
	/*private void insertGSTHdrDetData(List<String> hdrColumnList, List<String> hdrDataTypeList, List<String> hdrDataList, List<String> detColumnList, List<String> detDataTypeList, List<List<String>> detDataList, Connection conn) throws ITMException
	{
		boolean isError = false;
		PreparedStatement hdrPstmt = null, detPstmt = null;
		int hdrInsertCnt = 0;
		int[] detInsertCntArray = null;
		
		String hdrInsertSql = "", detInsertSql = "";
		
		StringBuffer hdrInsertSqlBuff = new StringBuffer();
		StringBuffer detInsertSqlBuff = new StringBuffer();
		
		try
		{
			hdrInsertSqlBuff.append("INSERT INTO GST_DATA_HDR (");
			
			for(String columnName : hdrColumnList)
			{
				hdrInsertSqlBuff.append(columnName+",");
			}
			hdrInsertSqlBuff.deleteCharAt(hdrInsertSqlBuff.length()-1);
			hdrInsertSqlBuff.append(") VALUES (");
			
			for(int i=0; i<hdrColumnList.size(); i++)
			{
				hdrInsertSqlBuff.append("?,");
			}
			hdrInsertSqlBuff.deleteCharAt(hdrInsertSqlBuff.length()-1);
			hdrInsertSqlBuff.append(")");
			
			hdrInsertSql = hdrInsertSqlBuff.toString();
			System.out.println("hdrInsertSql["+hdrInsertSql+"]");
			
			hdrPstmt = conn.prepareStatement(hdrInsertSql);
			
			for(int i=0; i<hdrDataTypeList.size(); i++)
			{
				
				String dataType = hdrDataTypeList.get(i);

				if("STRING".equalsIgnoreCase(dataType))
				{
					hdrPstmt.setString(i+1, hdrDataList.get(i));
				}
				else if("TIMESTAMP".equalsIgnoreCase(dataType))
				{
					String timestampStr = hdrDataList.get(i);
					java.sql.Timestamp timestamp = java.sql.Timestamp.valueOf(e12GenericUtility.getValidDateString(timestampStr, e12GenericUtility.getDBDateFormat()));
					hdrPstmt.setTimestamp(i+1, timestamp);
				}
				else if("DOUBLE".equalsIgnoreCase(dataType))
				{
					hdrPstmt.setDouble(i+1, Double.valueOf(hdrDataList.get(i)));
				}
				else if("INT".equalsIgnoreCase(dataType))
				{
					hdrPstmt.setInt(i+1, Integer.valueOf(hdrDataList.get(i)));
				}
			}
			
			hdrInsertCnt = hdrPstmt.executeUpdate();
			
			System.out.println("GST_DATA_HDR insert count["+hdrInsertCnt+"]");
			
			if(hdrPstmt != null)
			{
				hdrPstmt.close();
				hdrPstmt = null;
			}
			
			if(detColumnList != null && detColumnList.size() >0)
			{
				detInsertSqlBuff.append("INSERT INTO GST_DATA_DET (");
				
				for(String columnName : detColumnList)
				{
					detInsertSqlBuff.append(columnName+",");
				}
				detInsertSqlBuff.deleteCharAt(detInsertSqlBuff.length()-1);
				detInsertSqlBuff.append(") VALUES (");
				
				for(int i=0; i<detColumnList.size(); i++)
				{
					detInsertSqlBuff.append("?,");
				}
				detInsertSqlBuff.deleteCharAt(detInsertSqlBuff.length()-1);
				detInsertSqlBuff.append(")");
				
				detInsertSql = detInsertSqlBuff.toString();
				System.out.println("detInsertSql["+detInsertSql+"]");
				
				detPstmt = conn.prepareStatement(detInsertSql);
				
				for(List<String> eachDetList : detDataList)
				{
					for(int i=0; i<detDataTypeList.size(); i++)
					{
						String dataType = detDataTypeList.get(i);

						if("STRING".equalsIgnoreCase(dataType))
						{
							detPstmt.setString(i+1, eachDetList.get(i));
						}
						else if("TIMESTAMP".equalsIgnoreCase(dataType))
						{
							String timestampStr = eachDetList.get(i);
							java.sql.Timestamp timestamp = java.sql.Timestamp.valueOf(e12GenericUtility.getValidDateString(timestampStr, e12GenericUtility.getDBDateFormat()));
							detPstmt.setTimestamp(i+1, timestamp);
						}
						else if("DOUBLE".equalsIgnoreCase(dataType))
						{
							detPstmt.setDouble(i+1, Double.valueOf(eachDetList.get(i)));
						}
						else if("INT".equalsIgnoreCase(dataType))
						{
							detPstmt.setInt(i+1, Integer.valueOf(eachDetList.get(i)));
						}
					}
					
					detPstmt.addBatch();
					detPstmt.clearParameters();
				}
				
				detInsertCntArray = detPstmt.executeBatch();
				
				System.out.print("GST_DATA_DET insert count");
				
				for(int eachRowCnt : detInsertCntArray)
				{
					System.out.print(eachRowCnt + ",");
				}
				
				if(detPstmt != null)
				{
					detPstmt.close();
					detPstmt = null;
				}
			}
		}
		catch(SQLException se)
		{
			isError = true;
			System.out.println("GSTDataSubmitWizPos.insertGSTHdrDetData()["+se.getMessage()+"]");
			se.printStackTrace();
			throw new ITMException(se);
		} 
		catch (Exception e) 
		{
			isError = true;
			System.out.println("GSTDataSubmitWizPos.insertGSTHdrDetData()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(isError)
				{
					if(hdrPstmt != null)
					{
						hdrPstmt.close();
						hdrPstmt = null;
					}
					if(detPstmt != null)
					{
						detPstmt.close();
						detPstmt = null;
					}
				}
			}
			catch(SQLException se)
			{
				System.out.println("GSTDataSubmitWizPos.insertGSTHdrDetData()["+se.getMessage()+"]");
				se.printStackTrace();
			}
		}
	}*/
	
	private static String checkNullandTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
	
	private String generateTranId( String windowName, String siteCode, String tranDateStr, Connection conn )throws ITMException,Exception
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String selSql = "";
		String tranId = "";
		String tranSer = "";
		String keyString = "";
		String keyCol = "";
		String xmlValues = "";	

		try
		{
			selSql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
			pstmt = conn.prepareStatement(selSql);
			pstmt.setString( 1, windowName );
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				keyString = rs.getString("KEY_STRING");
				keyCol = rs.getString("TRAN_ID_COL");
				tranSer = rs.getString("REF_SER");
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
			System.out.println("keyString :"+keyString);
			System.out.println("keyCol :"+keyCol);
			System.out.println("tranSer :"+tranSer);

			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues +		"<tran_id></tran_id>";
			xmlValues = xmlValues +		"<site_code>" + siteCode + "</site_code>";
			xmlValues = xmlValues +		"<tran_date>" + tranDateStr + "</tran_date>"; 
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues  :["+xmlValues+"]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			System.out.println("tranId :"+tranId);

		}
		catch (SQLException ex)
		{
			System.out.println("Exception ::" +selSql+ ex.getMessage() + ":");
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		return tranId;
	}
	private java.sql.Timestamp getTimeStamp(String dateStr) throws ITMException, Exception 
	{ 
		String dbDateStr = "";
		if(dateStr != null && !dateStr.equals(""))
		{
			if(dateStr.indexOf(":") != -1)
			{
				System.out.println("inside logic"+dateStr);
				return java.sql.Timestamp.valueOf(dateStr);      
			}
			else
			{
				System.out.println("inside ");
				dbDateStr =(new E12GenericUtility()).getValidDateTimeString(dateStr, gstDateFormat, (new E12GenericUtility()).getDBDateTimeFormat());
				return java.sql.Timestamp.valueOf(dbDateStr); 
			}
		}
		else
		{
			return null;
		}
	}
	private double getDoubleValue(String input)
	{
		double value = 0.0;
		try
		{
			if(input == null)
			{
				value = 0.0;
			}
			else
			{
				value = Double.valueOf(checkNullandTrim(input));
			}
			System.out.println("retutn value["+value+"]");
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.getDoubleValue()["+e.getMessage()+"]");
			e.printStackTrace();
		}
		return value;
	}
	private void closeResources(ResultSet rs, PreparedStatement pstmt) throws SQLException
	{
		boolean isError = false;
		try
		{
			if(rs!=null)
			{
				rs.close();
				rs=null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(SQLException se)
		{
			isError = true;
			System.out.println("GSTDataSubmitWizPos.closeResources()["+se.getMessage()+"]");
			se.printStackTrace();
			throw new SQLException(se);
		}
		finally
		{
			try
			{
				if(isError)
				{
					if(rs!=null)
					{
						rs.close();
						rs=null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
			}
			catch(SQLException se)
			{
				isError = true;
				System.out.println("GSTDataSubmitWizPos.closeResources()inside finally["+se.getMessage()+"]");
				se.printStackTrace();
				throw new SQLException(se);
			}
		}
	}

}
