package ibase.webitm.ejb.adm.adv;

import java.rmi.RemoteException;

import ibase.system.config.ConnDriver;
import ibase.utility.EMail;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ITMDBAccessLocal;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.io.PrintStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.StringTokenizer;
import java.rmi.RemoteException;
import javax.naming.InitialContext;
import java.sql.*;
import java.text.*;
import ibase.system.config.*;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.*;
import javax.ejb.Stateless; // added for ejb3

@Stateless // added for ejb3

// Created by Chetna Shahu on 08/07/2014  for Transfer cancellation of employee  [START]
public class EmpTranPromCanc extends ActionHandlerEJB implements EmpTranPromCancLocal, EmpTranPromCancRemote
{

    public String actionHandler() throws RemoteException,ITMException
	{
		return "";
	}

	public String actionHandler(String tranId, String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		int updStatus = 0;
		String sql = "";
		String holTable = "";
		String siteCode = "";
		String confirm = "";
		String retString = "";

		ITMDBAccessLocal itmDBAccessLocal = (ITMDBAccessLocal) new ITMDBAccessEJB();

		try 
		{
			
			System.out.println("call EmpTranPromCanc [actionHandler] method .....for tran id"+ tranId);
			System.out.println(" xtraParams [" + xtraParams + "] ");
			System.out.println(" forcedFlag [" + forcedFlag + "] ");

			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			GenericUtility genericUtility = GenericUtility.getInstance();
			System.out.println("tranId [" + tranId + "]");
			String userID = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"LoginCode");
			siteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode");

			sql = "SELECT CONFIRMED FROM EMP_EMPLOY_EVENTS  WHERE TRAN_ID = ?";
			pstmt = conn.prepareStatement(sql);
			System.out.println("[EmpTranPromCanc][confirm]sqlStatus::" + sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				confirm = rs.getString("CONFIRMED");
			}
			else
			{
				retString = itmDBAccessLocal.getErrorString("", "VTEMPEVT01", userID);
			}
			System.out.println(" confirm  [" + confirm + "] ");
			closePstmtRset(pstmt, rs);

			if (retString == null || retString.trim().length() == 0)
			{
				if (confirm.equalsIgnoreCase("N")) 
				{
					if (userID != null && userID.length() > 0)
					{
						sql = "UPDATE EMP_EMPLOY_EVENTS  SET CONFIRMED = ? WHERE  TRAN_ID = ? ";
						pstmt = conn.prepareStatement(sql);
						System.out.println("[EmpTranPromCanc][confirm]sqlStatus::"+ sql);
						pstmt.setString(1, "X");
						pstmt.setString(2, tranId);
						updStatus = pstmt.executeUpdate();
						System.out.println("canceled the request [::" + updStatus);
						if(updStatus > 0)
						{
							retString = itmDBAccessLocal.getErrorString("", "VTEMPEVT01", userID);
							conn.commit();
						}
						else
						{
							retString = itmDBAccessLocal.getErrorString("", "VTEMPEVT02", userID);
							conn.rollback();
						}
						
					} else
					{
						retString = itmDBAccessLocal.getErrorString("", "EMPAPRV", userID);
					}
				} else if (confirm.equalsIgnoreCase("X"))
				{
					retString = itmDBAccessLocal.getErrorString("", "VTCANCEL", userID);
				} else if (confirm.equalsIgnoreCase("Y"))
				{
					retString = itmDBAccessLocal.getErrorString("", "VTEMPEVT03", userID);
				}
			}

		}
		catch (Exception e)
		{
			try
			{
				conn.rollback();
				System.out.println("Exception " + e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
			catch (Exception e1) 
			{
				e1.printStackTrace();
				throw new ITMException(e1);
			}
		} finally {
			try 
			{
				
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null) 
				{
					pstmt.close();
					pstmt = null;
				}
				if (conn != null)
				{
					conn.close();
					conn = null;
				}

			} 
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}

		return retString;

	}

	private void closePstmtRset(PreparedStatement pstmt, ResultSet rset)throws Exception {
		System.out.println("Closing statement and result.........");
		try 
		{
			if (rset != null)
			{
				rset.close();
				rset = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch (Exception exp) 
		{
			System.out.println("Inside Exception [EmpReimbClaimConfirm][closePstmtRset]::"+ exp.getMessage());
			exp.printStackTrace();
			throw new Exception(exp);
		}
	}

}
// Created by Chetna Shahu on 08/07/2014 for Transfer cancellation of employee
// [END]
