package ibase.webitm.util.gst;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;

import ibase.webitm.bean.gst.ATA;
import ibase.webitm.bean.gst.InvLineItem;

public class ATASearializer extends BaseSerializer<ATA>
{
	@Override
	public void serialize(ATA ata, JsonGenerator json, SerializerProvider serializeProvider) throws IOException, JsonProcessingException
	{
		json.writeStartObject();
		
		json.writeStringField("typ", ata.typ);
		
		if(ata.orgCpty != null && ata.orgDocNum != null && ata.orgDocDt != null)
		{
			json.writeStringField("ocpty", ata.orgCpty);
			json.writeStringField("odoc_num", ata.orgDocNum);
			json.writeStringField("odoc_dt", gstFmt.format(ata.orgDocDt));
		}
		
		json.writeStringField("cpty", ata.cpty);
		json.writeStringField("state_cd", ata.stateCode);
		json.writeStringField("doc_num", ata.docNum);
		json.writeStringField("doc_dt", gstFmt.format(ata.docDt));
		
		writeLineItems(ata, json);
		
		json.writeEndObject();
	}
	
	 private void writeLineItems(ATA ata, JsonGenerator json) throws IOException 
	    {
	        json.writeFieldName("itms");
	        
	        json.writeStartArray();
	        
	        for(InvLineItem li : ata.itms)
	        {
	        	writeLineItem(json, li);
	        }

	        json.writeEndArray();
	    }

	    private void writeLineItem(JsonGenerator json, InvLineItem li) 
	    {
	        try 
	        {
	            json.writeStartObject();
	            
	            json.writeStringField("ty", li.ty);
	            json.writeStringField("hsn_sc", li.hsn_sc);
	            json.writeNumberField("ad_amt", li.taxval);

	            json.writeNumberField("irt", li.irt);
	            json.writeNumberField("iamt", li.iamt);
	            
	        	json.writeNumberField("crt", li.crt);
	        	json.writeNumberField("camt", li.camt);
	        	
	        	json.writeNumberField("srt", li.srt);
	        	json.writeNumberField("samt", li.samt);
	            
	            json.writeNumberField("csrt", li.csrt);
	            json.writeNumberField("csamt", li.csamt);
	            
	            json.writeEndObject();
	        }
	        catch (Exception e) 
	        {
	        	System.out.println("ATSearializer.writeLineItem()["+e.getMessage()+"]");
	            e.printStackTrace();
	        }
	    }
}
