
--------------------------------------------------- Dashboad report ---------------------------------------------------
1 - Dashboard_pages
INSERT INTO Dashboard_pages 
(
	user_id ,
	page_id ,
	title ,
	uri ,
	image_uri ,
	page_type ,
	entity_type ,
	entity_code ,
	chg_user ,
	chg_term ,
	chg_date ,
	comp_type 
) VALUES (
	'X001',
	1,
	'Current Day Work Details',
	'/ibase/dwh/GwtDashboardPage.html?metadataname=currentdaydetail',
	'../images/compose.gif',
	'T',
	'U',
	'X001',
	'X001',
	'127.0.0.1',
	TO_DATE('31-05-2014 00:00:00','DD-MM-YYYY HH24:MI:SS'),
	'DBR '
);

2 - Dashboard_comp
INSERT INTO Dashboard_comp (
	user_id ,
	page_id ,
	comp_id ,
	title ,
	uri ,
	width ,
	height ,
	row_no ,
	column_no ,
	comp_type ,
	comp_name ,
	entity_type ,
	entity_code ,
	dbr_resource 
) VALUES (
	'X001',
	1,
	1,
	'DashBoard Report',
	'/ibase/dwh/GwtDashboardPage.html?metadataname=currentdaydetail',
	230,
	0,
	0,
	1,
	'DBR',
	'DBR',
	'U',
	'X001',
	'currentdaydetail'
);

------------------------------------------------- Pophelp Queries ---------------------------------------------------
--------------------------------------------------- ASE_NAME ---------------------------------------------------

INSERT INTO POPHELP (
	field_name,
	mod_name ,
	sql_str ,
	dw_object,
	msg_title,
	width ,
	height ,
	chg_date ,
	chg_user ,
	chg_term ,
	dist_opt ,
	filter_string ,
	sql_input ,
	default_col ,
	pop_align ,
	query_mode ,
	page_context ,
	pophelp_cols ,
	pophelp_source ,
	multi_opt ,
	help_option ,
	popup_xsl_name ,
	auto_min_length ) VALUES (
	'ASE_NAME',
	'W_DASHBOARD',
	'SELECT TRIM(A.EMP_CODE) AS as_sales_pers,  A.EMP_FNAME  ||'' ''  ||A.EMP_MNAME  ||'' ''  ||A.EMP_LNAME AS EMPLOYEE_NAMES,  B.EMP_FNAME  ||'' ''  ||B.EMP_MNAME  ||'' ''  ||B.EMP_LNAME  ||'' (''  ||TRIM(B.EMP_CODE)  ||'')'' AS MANAGER_NAMES FROM EMPLOYEE A ,  EMPLOYEE B WHERE B.EMP_CODE(+) = A.REPORT_TO   START WITH A.EMP_CODE = ''?'' CONNECT BY PRIOR A.EMP_CODE=A.REPORT_TO',
	NULL,
	'ASE Name',
	NULL,
	NULL,
	TO_DATE('12-03-2016 04:34:15','DD-MM-YYYY HH24:MI:SS'),
	'CHMAHAJAN ',
	'CHMAHAJAN      ',
	NULL,
	NULL,
	':LOGIN_CODE',
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL);

--------------------------------------------------- YEAR ---------------------------------------------------
INSERT INTO POPHELP (
	field_name,
	mod_name ,
	sql_str ,
	dw_object,
	msg_title,
	width ,
	height ,
	chg_date ,
	chg_user ,
	chg_term ,
	dist_opt ,
	filter_string ,
	sql_input ,
	default_col ,
	pop_align ,
	query_mode ,
	page_context ,
	pophelp_cols ,
	pophelp_source ,
	multi_opt ,
	help_option ,
	popup_xsl_name ,
	auto_min_length ) VALUES (
	'YEAR',
	'W_DASHBOARD',
	'SELECT TO_NUMBER(TO_CHAR(SYSDATE,''YYYY''))-1 AS YEAR, TO_NUMBER(TO_CHAR(SYSDATE,''YYYY''))-1 AS YEARS FROM DUAL UNION SELECT TO_NUMBER(TO_CHAR(SYSDATE,''YYYY'')) AS YEAR, TO_NUMBER(TO_CHAR(SYSDATE,''YYYY'')) AS YEAR FROM DUAL',
	NULL,
	'YEAR',
	NULL,
	NULL,
	TO_DATE('12-03-2016 04:34:15','DD-MM-YYYY HH24:MI:SS'),
	'CHMAHAJAN ',
	'CHMAHAJAN      ',
	NULL,
	NULL,
	'',
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL);

--------------------------------------------------- MONTH ---------------------------------------------------
INSERT INTO POPHELP (
	field_name,
	mod_name ,
	sql_str ,
	dw_object,
	msg_title,
	width ,
	height ,
	chg_date ,
	chg_user ,
	chg_term ,
	dist_opt ,
	filter_string ,
	sql_input ,
	default_col ,
	pop_align ,
	query_mode ,
	page_context ,
	pophelp_cols ,
	pophelp_source ,
	multi_opt ,
	help_option ,
	popup_xsl_name ,
	auto_min_length ) VALUES (
	'MONTH',
	'W_DASHBOARD',
	'SELECT 3,''MAR'' AS MONTH , ''March'' AS DESCR  FROM DUAL UNION SELECT 4,''APR'' AS MONTH , ''April'' AS DESCR  FROM DUAL UNION SELECT 5,''MAY'' AS MONTH , ''May'' AS DESCR  FROM DUAL UNION SELECT 6,''JUN'' AS MONTH , ''June'' AS DESCR  FROM DUAL UNION SELECT 7,''JUL'' AS MONTH , ''July'' AS DESCR  FROM DUAL UNION SELECT 8,''AUG'' AS MONTH , ''August'' AS DESCR  FROM DUAL UNION SELECT 9,''SEP'' AS MONTH , ''September'' AS DESCR  FROM DUAL UNION SELECT 10,''OCT'' AS MONTH , ''October'' AS DESCR  FROM DUAL UNION SELECT 11,''NOV'' AS MONTH , ''November'' AS DESCR  FROM DUAL UNION SELECT 12,''DEC'' AS MONTH , ''December'' AS DESCR  FROM DUAL',
	NULL,
	'MONTH',
	NULL,
	NULL,
	TO_DATE('12-03-2016 04:34:15','DD-MM-YYYY HH24:MI:SS'),
	'CHMAHAJAN ',
	'CHMAHAJAN',
	NULL,
	NULL,
	'',
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL);

--------------------------------------------------- Sql Functions ------------------------------------------------------

Create Function FN_R_TOT_PC(
as_dcr_id char,
as_event_date date,
as_sales_pers char,
as_loc_code char
)
Return Number as as_tot_pc number(4);
Begin

Select 
nvl(count(distinct strg_code),0) into as_tot_pc
from STRG_MEET_ORDER SMO 
where (dcr_id,Strg_Code) In (
select 
dcr_id,strg_code
from Strg_Meet
Where dcr_id = as_dcr_id
and event_date = as_event_date
AND SALES_PERS = as_sales_pers
and locality_Code = as_loc_code
)
and SMO.Quantity > 0;

Return as_tot_pc;
End;

----------------------------------------------------------------------------------------------

Create Function FN_R_ORD_VAL(
as_dcr_id char,
as_event_date date,
as_sales_pers char,
as_loc_code char
)
Return Number as as_ord_val number(8,2);
Begin

Select 
nvl(sum(value),0) into as_ord_val
from STRG_MEET_ORDER SMO 
where (dcr_id,Strg_Code) In (
select 
dcr_id,strg_code
from Strg_Meet
Where dcr_id = as_dcr_id
and event_date = as_event_date
AND SALES_PERS = as_sales_pers
and locality_Code = as_loc_code
)
and SMO.Quantity > 0;

Return as_ord_val;
End;

----------------------------------------------------------------------------------------------

Create Function FN_R_FW_CUMM_DAYS(
as_event_date date,
as_sales_pers char
)
Return Number as as_fw_cumm_days number(2);
Begin

select 
Nvl(Count (Distinct Event_Date),0) into as_fw_cumm_days
from Strg_Meet SM Inner Join fieldactivity FA On sm.event_Type = fa.activity_code
Where fa.activity_type = 'FW'
And strg_type = 'C'
AND SALES_PERS = as_sales_pers
AND event_date >= trunc(to_date(as_event_date),'mon')
AND event_date <= as_event_date
;

Return as_fw_cumm_days;
End;

----------------------------------------------------------------------------------------------

Create Function FN_R_CUMM_SMO(
as_event_date date,
as_sales_pers char
)
Return Number as as_cumm_smo number(8,2);
Begin

Select 
nvl(count(dcr_id),0) into as_cumm_smo
from STRG_MEET_ORDER SMO 
where (dcr_id,Strg_Code) In (
select 
dcr_id,strg_code
from Strg_Meet
Where strg_type = 'C'
And SALES_PERS = as_sales_pers
AND event_date >= trunc(to_date(as_event_date),'mon')
AND event_date <= as_event_date
)
and SMO.Quantity > 0;

Return as_cumm_smo;
End;
