/*
 * Author:Wasim Ansari
 * Date:08-08-2016
 * Request ID:S16EBAS006 (Pack Label Wizard)
 */

package ibase.webitm.ejb.wms;

import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.utility.ITMException;

import java.net.InetAddress;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import javax.ejb.Stateless;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class PackLabelWizEJB extends ValidatorEJB implements PackLabelWizEJBLocal, PackLabelWizEJBRemote
{
	String globalXtraParams = null;
	E12GenericUtility genericUtility = new E12GenericUtility();

	/**
	 * Default constructor. 
	 */
	public PackLabelWizEJB() {
		// TODO Auto-generated constructor stub
	}

	@Override
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		System.out.println("Inside wfvalData PackLabelWizEJB");
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;

		try
		{
			System.out.println("xmlString:::"+xmlString);

			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}

			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : Cpp : wfValData(String xmlString) : ==>\n"+e.getMessage());
		}

		return(errString);
	}


	@Override
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams)throws RemoteException, ITMException 
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;	
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;
		String userId = "";
		String errCode = "";
		String errorType = "";
		String errString = "";
		int ctr=0;
		int childNodeListLength;
		int currentFormNo = 0;
		long cnt = 0;
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		Connection conn = null;
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		boolean flag = false; 

		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>"); 
		try
		{
			//ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();

			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");

			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());

			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}

			switch(currentFormNo)
			{
			case 1 :
				break;
			case 2 :
				parentNodeList = dom.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr ++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();

					if (childNodeName.equalsIgnoreCase("quantity")) 
					{
						double pcontractQty = 0;

						double quantity = Double.parseDouble(genericUtility.getColumnValue("quantity", dom));
						String contractNo = checkNullAndTrim(genericUtility.getColumnValue("contract_no", dom));
						String itemCode = checkNullAndTrim(genericUtility.getColumnValue("item_code", dom));

						String countSerSql = " SELECT ( MAX_QTY - (CASE WHEN QUANTITY_REL IS NULL THEN 0 ELSE QUANTITY_REL END) ) AS QUANTITY FROM PCONTRACT_DET WHERE CONTRACT_NO = ? AND ITEM_CODE = ? ";
						pstmt = conn.prepareStatement(countSerSql);
						pstmt.setString(1, contractNo);
						pstmt.setString(2, itemCode);
						rs = pstmt.executeQuery();

						if (rs.next()) 
						{
							pcontractQty = rs.getDouble("QUANTITY");

							if(rs != null) 
							{
								rs.close();rs = null;
							}
							if(pstmt != null) 
							{
								pstmt.close();pstmt = null;
							}
						}
						else
						{
							countSerSql = " SELECT QUANTITY FROM PORDDET WHERE PURC_ORDER = ? AND ITEM_CODE = ? ";
							pstmt = conn.prepareStatement(countSerSql);
							pstmt.setString(1, contractNo);
							pstmt.setString(2, itemCode);
							rs = pstmt.executeQuery();
							if (rs.next()) 
							{
								pcontractQty = rs.getDouble("QUANTITY");
							}
						}
						if(rs != null) 
						{
							rs.close();rs = null;
						}
						if(pstmt != null) 
						{
							pstmt.close();pstmt = null;
						}
						System.out.println("Purchase Contract quantity["+pcontractQty+"] and entered quantity["+quantity+"] itemCode["+itemCode+"]");

						if (quantity > pcontractQty) 
						{
							return getError(itemCode, "VTPACKQTY", conn);
						}
					}
				}
			}

			int errListSize = errList.size();
			cnt = 0;
			String errFldName = null;
			if(errList != null && errListSize > 0)
			{
				for(cnt = 0; cnt < errListSize; cnt ++)
				{
					errCode = errList.get((int) cnt);
					errFldName = errFields.get((int) cnt);
					errString = getErrorString(errFldName, errCode, userId);
					errorType =  errorType(conn , errCode);
					if(errString.length() > 0)
					{
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if(errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			}

			else
			{
				errStringXml = new StringBuffer("");
			}
		}// End of try
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				//connDriver = null;
				if(conn != null)
				{
					if(rs != null) 
					{
						rs.close();rs = null;
					}
					if(pstmt != null) 
					{
						pstmt.close();pstmt = null;
					}
					conn.close();
				}
				conn = null;
			} 
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		errString = errStringXml.toString();
		return errString;
	}

	public  String getError(String itemCode, String Code, Connection conn)  throws ITMException, Exception
	{
		String mainStr ="";

		try
		{
			String errString = "";
			errString =  new ITMDBAccessEJB().getErrorString("",Code,"","",conn);
			String begPart = errString.substring(0,errString.indexOf("<message>")+9);
			String endDesc = errString.substring(errString.indexOf("</description>"));
			mainStr= begPart+"Entered quantity exceeded"+"</message><description>";
			mainStr= mainStr+"Quantity has been already issued/ Exceeds Order Quantity for item code : ["+itemCode+"]."+endDesc;
			System.out.println("mainStr:::::::::::::::::: "+mainStr);
			begPart = null;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return mainStr;
	}

	@Override
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		Document dom1 = null;
		Document dom = null;
		Document dom2 = null;
		String valueXmlString = "";

		try
		{
			System.out.println("xmlString : ["+ xmlString+ "] \nxmlString1 : ["+ xmlString1 +"] \nxmlString2 : ["+ xmlString2 +"]");

			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}

			valueXmlString = itemChanged(dom,dom1,dom2,objContext,currentColumn,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			e.printStackTrace();
			valueXmlString = genericUtility.createErrorString(e);
		}

		return (valueXmlString);
	}
	@Override
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		Connection conn = null;
		PreparedStatement pstmt = null,pstmtShipper = null;
		ResultSet rs = null, rsShipper = null ;
		globalXtraParams = xtraParams;
		String sql = "",userId = "",loginSiteCode = "",chgTerm = "",siteCode = "",siteCodeDescr = "",currDateStr = "",purcOrder = "",contractNo = "";
		int currentFormNo = 0;

		StringBuffer valueXmlString = new StringBuffer();
		Timestamp currDate = null;
		String lotNo = "";
		try
		{
			/*ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver = null;*/
			conn = getConnection();

			currDate = getCurrtDate();
			Date date = new Date(currDate.getTime());
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			currDateStr=simpleDateFormat.format(date);

			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
			loginSiteCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" );
			
			siteCode = checkNull(genericUtility.getColumnValue("site_code", dom1));
			sql = "SELECT DESCR FROM SITE WHERE SITE_CODE = ?";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1,siteCode);			
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				siteCodeDescr = checkNullAndTrim(rs.getString("DESCR"));
				System.out.println("siteCode===["+siteCode+"]  siteCodeDescr=======["+siteCodeDescr+"]");
			}	
			if(rs != null)
			{
				rs.close();rs = null;
			}	
			if(pstmt != null)
			{	
				pstmt.close();pstmt = null;
			}

			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?>\r\n<Root>\r\n<header>\r\n<editFlag>");
			valueXmlString.append(editFlag).append("</editFlag>\r\n</header>\r\n");

			System.out.println("currentColumn["+currentColumn+"] && currentFormNo["+currentFormNo+"]");

			switch ( currentFormNo )
			{
			case 1:
			{   
				valueXmlString.append("<Detail1 domID='1' selected = 'N'>\r\n");

				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ))
				{
					valueXmlString.append("<site_code>").append("<![CDATA["+siteCode+"]]>").append("</site_code>\r\n");
					valueXmlString.append("<site_code_descr>").append("<![CDATA["+siteCodeDescr+"]]>").append("</site_code_descr>\r\n");
					valueXmlString.append("<site_code__supp>").append("<![CDATA["+loginSiteCode+"]]>").append("</site_code__supp>\r\n");
					valueXmlString.append("<site_code__supp_descr>").append("<![CDATA["+siteCodeDescr+"]]>").append("</site_code__supp_descr>\r\n");
					valueXmlString.append("<contract_no>").append("<![CDATA[]]>").append("</contract_no>\r\n");
					valueXmlString.append("<purc_order>").append("<![CDATA[]]>").append("</purc_order>\r\n");
					valueXmlString.append("<supp_code>").append("<![CDATA[]]>").append("</supp_code>\r\n");
					valueXmlString.append("<supp_code_descr>").append("<![CDATA[]]>").append("</supp_code_descr>\r\n");
					valueXmlString.append("<tran_code>").append("<![CDATA[]]>").append("</tran_code>\r\n");
					valueXmlString.append("<tran_name>").append("<![CDATA[]]>").append("</tran_name>\r\n");
					valueXmlString.append("<tran_type>").append("<![CDATA[]]>").append("</tran_type>\r\n");
					valueXmlString.append("<scac_code>").append("<![CDATA[]]>").append("</scac_code>\r\n");
					valueXmlString.append("<ship_date>").append("<![CDATA["+currDateStr+"]]>").append("</ship_date>\r\n");
				}

				valueXmlString.append("</Detail1>\r\n");
			}
			break;
			case 2 :
			{
				contractNo 		= checkNullAndTrim(genericUtility.getColumnValue("contract_no", dom1));
				purcOrder 		= checkNullAndTrim(genericUtility.getColumnValue("purc_order", dom1));
				String suppCode 		= checkNullAndTrim(genericUtility.getColumnValue("supp_code", dom1));
				String suppCodeDescr 	= checkNullAndTrim(genericUtility.getColumnValue("supp_code_descr", dom1));
				siteCode 		= checkNull(genericUtility.getColumnValue("site_code", dom1));
				siteCodeDescr 	        = checkNullAndTrim(genericUtility.getColumnValue("site_code_descr", dom1));
				String siteCodeSupp 	= checkNull(genericUtility.getColumnValue("site_code__supp", dom1));
				String siteCodeSuppDescr= checkNullAndTrim(genericUtility.getColumnValue("site_code__supp_descr", dom1));
				String tranCode 	    = checkNullAndTrim(genericUtility.getColumnValue("tran_code", dom1));
				String tranName	        = checkNullAndTrim(genericUtility.getColumnValue("tran_name", dom1));
				String tranType 	    = checkNullAndTrim(genericUtility.getColumnValue("tran_type", dom1));
				String scacCode 	    = checkNullAndTrim(genericUtility.getColumnValue("scac_code", dom1));
				String shipDate 	    = checkNullAndTrim(genericUtility.getColumnValue("ship_date", dom1));

				int domID = 0;
				String itemCode = "", itemDescr = "", unit = "",lineNo = "";
				double shipperSize = 0, noArtQuot = 0, noArtRem = 0, noArt = 0, quantity = 0 ;
				//Date mfgDate = null;

				valueXmlString.append("<Detail2 domID = '"+domID+"' selected = 'N'>\r\n");
				if(contractNo != null && contractNo.length() > 0)
				{
					valueXmlString.append("<contract_no>").append("<![CDATA["+ contractNo +"]]>").append("</contract_no>\r\n");
				}
				else
				{
					valueXmlString.append("<purc_order>").append("<![CDATA["+ purcOrder +"]]>").append("</purc_order>\r\n");	
				}
				valueXmlString.append("<supp_code>").append("<![CDATA["+ suppCode +"]]>").append("</supp_code>\r\n");
				valueXmlString.append("<supp_code_descr>").append("<![CDATA["+ suppCodeDescr +"]]>").append("</supp_code_descr>\r\n");
				valueXmlString.append("<site_code>").append("<![CDATA["+ siteCode +"]]>").append("</site_code>\r\n");
				valueXmlString.append("<site_code_descr>").append("<![CDATA["+ siteCodeDescr +"]]>").append("</site_code_descr>\r\n");
				valueXmlString.append("<site_code__supp>").append("<![CDATA["+ siteCodeSupp +"]]>").append("</site_code__supp>\r\n");
				valueXmlString.append("<site_code__supp_descr>").append("<![CDATA["+ siteCodeSuppDescr +"]]>").append("</site_code__supp_descr>\r\n");
				valueXmlString.append("<tran_code>").append("<![CDATA["+ tranCode +"]]>").append("</tran_code>\r\n");
				valueXmlString.append("<tran_name>").append("<![CDATA["+ tranName +"]]>").append("</tran_name>\r\n");
				valueXmlString.append("<tran_type>").append("<![CDATA["+ tranType +"]]>").append("</tran_type>\r\n");
				valueXmlString.append("<scac_code>").append("<![CDATA["+ scacCode +"]]>").append("</scac_code>\r\n");
				valueXmlString.append("<ship_date>").append("<![CDATA["+shipDate+"]]>").append("</ship_date>\r\n");
				valueXmlString.append("</Detail2>\r\n");

				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
					if(contractNo != null && contractNo.trim().length() > 0)
					{
						/*sql = " SELECT H.CONTRACT_NO,H.SUPP_CODE,D.ITEM_CODE,I.DESCR,I.UNIT,(D.MAX_QTY - D.QUANTITY_REL) AS QUANTITY,H.TRAN_CODE "
							+ " FROM PCONTRACT_HDR H,PCONTRACT_DET D,ITEM I "
							+" WHERE H.CONTRACT_NO = D.CONTRACT_NO AND I.ITEM_CODE = D.ITEM_CODE AND H.CONTRACT_NO = ? AND (D.MAX_QTY - D.QUANTITY_REL) > 0 ";*/

						sql = " SELECT H.CONTRACT_NO,H.SUPP_CODE,D.LINE_NO,D.ITEM_CODE,I.DESCR,I.UNIT,((D.MAX_QTY - (CASE WHEN D.QUANTITY_REL IS NULL THEN 0 ELSE D.QUANTITY_REL END)) - (SELECT COALESCE((SELECT SUM(QUANTITY) " 
							+ " FROM ASN_HDR AH, ASN_DET AD WHERE AD.TRAN_ID = AH.TRAN_ID AND AH.CONTRACT_NO = H.CONTRACT_NO AND AD.ITEM_CODE = D.ITEM_CODE) ,0) FROM DUAL)) AS QUANTITY,"
							+ " H.TRAN_CODE FROM PCONTRACT_HDR H,PCONTRACT_DET D,ITEM I "
							+ " WHERE H.CONTRACT_NO = D.CONTRACT_NO AND I.ITEM_CODE = D.ITEM_CODE AND H.CONTRACT_NO = ? "
							+ " AND (SELECT COALESCE((SELECT SUM(QUANTITY) FROM ASN_HDR AH, ASN_DET AD WHERE AD.TRAN_ID = AH.TRAN_ID AND AH.CONTRACT_NO = H.CONTRACT_NO " 
							+ " AND AD.ITEM_CODE = D.ITEM_CODE) ,0) FROM DUAL) < (D.MAX_QTY - (CASE WHEN D.QUANTITY_REL IS NULL THEN 0 ELSE D.QUANTITY_REL END)) "
							+ " AND (D.MAX_QTY - (CASE WHEN D.QUANTITY_REL IS NULL THEN 0 ELSE D.QUANTITY_REL END)) > 0 ";
						pstmt = conn.prepareStatement(sql);			
						pstmt.setString(1,contractNo);
						rs = pstmt.executeQuery();
						while(rs.next())
						{
							domID++;
							itemCode = checkNullAndTrim(rs.getString("ITEM_CODE"));
							lineNo = checkNull(rs.getString("LINE_NO"));
							quantity = rs.getDouble("QUANTITY");
							itemDescr = checkNullAndTrim(rs.getString("DESCR"));
							unit = checkNullAndTrim(rs.getString("UNIT"));

							sql = " SELECT SHIPPER_SIZE FROM ITEM_LOT_PACKSIZE WHERE ITEM_CODE = ? ";
							pstmtShipper = conn.prepareStatement(sql);			
							pstmtShipper.setString(1,itemCode);			
							rsShipper = pstmtShipper.executeQuery();
							if(rsShipper.next())
							{
								shipperSize = rsShipper.getDouble("SHIPPER_SIZE");
							}
							else
							{
								shipperSize = 0.000;
							}
							if(rsShipper != null)
							{
								rsShipper.close();rsShipper = null;
							}	
							if(pstmtShipper != null)
							{	
								pstmtShipper.close();pstmtShipper = null;
							}

							if(shipperSize > 0)
							{
								noArtQuot= quantity / shipperSize ;
								noArtRem = quantity % shipperSize ;
								if(noArtRem > 0)
								{
									noArtRem = 1;
								}
								noArtQuot = (int) noArtQuot;
								noArt = noArtQuot + noArtRem;
								//noArt = noArtQuot ;
							}
							sql = "SELECT LOT_NO FROM CASE_LABEL WHERE ITEM_CODE = ? ";
							pstmtShipper = conn.prepareStatement(sql);			
							pstmtShipper.setString(1,itemCode);
							rsShipper = pstmtShipper.executeQuery();

							System.out.println("itemCode["+itemCode+"] quantity["+quantity+"] itemDescr["+itemDescr+"] unit["+unit+"] lineNo["+lineNo+"]");
							valueXmlString.append("<Detail2 domID = '"+domID+"' selected = 'N'>\r\n");
							valueXmlString.append("<contract_no>").append("<![CDATA["+ contractNo +"]]>").append("</contract_no>\r\n");
							valueXmlString.append("<supp_code>").append("<![CDATA["+ suppCode +"]]>").append("</supp_code>\r\n");
							valueXmlString.append("<item_code>").append("<![CDATA["+ itemCode +"]]>").append("</item_code>\r\n");
							valueXmlString.append("<item_descr>").append("<![CDATA["+ itemDescr +"]]>").append("</item_descr>\r\n");
							valueXmlString.append("<unit>").append("<![CDATA["+ unit +"]]>").append("</unit>\r\n");
							valueXmlString.append("<tot_quantity>").append("<![CDATA["+quantity+"]]>").append("</tot_quantity>\r\n");
							valueXmlString.append("<quantity>").append("<![CDATA[]]>").append("</quantity>\r\n");
							valueXmlString.append("<shipper_size>").append("<![CDATA["+shipperSize+"]]>").append("</shipper_size>\r\n");
							valueXmlString.append("<no_art>").append("<![CDATA["+noArt+"]]>").append("</no_art>\r\n");
							valueXmlString.append("<site_code__mfg>").append("<![CDATA["+loginSiteCode+"]]>").append("</site_code__mfg>\r\n");
							valueXmlString.append("<line_no__ord>").append("<![CDATA["+lineNo+"]]>").append("</line_no__ord>\r\n");
							if(rsShipper.next())
							{
								lotNo = rsShipper.getString("LOT_NO");
								valueXmlString.append("<lot_no>").append("<![CDATA["+lotNo+"]]>").append("</lot_no>\r\n");
							}
							String mfgDate = checkNullAndTrim(genericUtility.getColumnValue("mfg_date", dom1));
							System.out.println("mfgdate=====["+mfgDate+"]");
							valueXmlString.append("</Detail2>\r\n");

							if(rsShipper != null)
							{
								rsShipper.close();rsShipper = null;
							}	
							if(pstmtShipper != null)
							{	
								pstmtShipper.close();pstmtShipper = null;
							}
						}	
						if(rs != null)
						{
							rs.close();rs = null;
						}	
						if(pstmt != null)
						{	
							pstmt.close();pstmt = null;
						}
					}
					else
					{
						/*sql = "SELECT H.PURC_ORDER,H.SUPP_CODE,D.ITEM_CODE,I.DESCR,I.UNIT,D.QUANTITY,H.TRAN_CODE  FROM PORDER H, "
							+ "PORDDET D,ITEM I WHERE H.PURC_ORDER = D.PURC_ORDER AND I.ITEM_CODE = D.ITEM_CODE AND H.PURC_ORDER = ? AND D.QUANTITY > 0 ";*/
						sql = "SELECT H.PURC_ORDER,D.LINE_NO,H.SUPP_CODE,D.ITEM_CODE,I.DESCR,I.UNIT,(D.QUANTITY - (SELECT COALESCE((SELECT SUM(QUANTITY) FROM ASN_HDR AH, ASN_DET AD" 
							+ " WHERE AD.TRAN_ID = AH.TRAN_ID AND AH.PURC_ORDER = H.PURC_ORDER AND AD.ITEM_CODE = D.ITEM_CODE) ,0) FROM DUAL)) AS QUANTITY,H.TRAN_CODE  FROM PORDER H, "
							+ " PORDDET D,ITEM I WHERE H.PURC_ORDER = D.PURC_ORDER AND I.ITEM_CODE = D.ITEM_CODE AND H.PURC_ORDER = ? " 
							+ " AND (SELECT COALESCE((SELECT SUM(QUANTITY) FROM ASN_HDR AH, ASN_DET AD WHERE AD.TRAN_ID = AH.TRAN_ID AND AH.PURC_ORDER = H.PURC_ORDER AND AD.ITEM_CODE = D.ITEM_CODE) ,0) FROM DUAL) < D.QUANTITY "
							+ " AND D.QUANTITY > 0 ";
						pstmt = conn.prepareStatement(sql);			
						pstmt.setString(1,purcOrder);
						rs = pstmt.executeQuery();
						while(rs.next())
						{
							domID++;
							itemCode = checkNullAndTrim(rs.getString("ITEM_CODE"));
							lineNo = checkNull(rs.getString("LINE_NO"));
							quantity = rs.getDouble("QUANTITY");
							itemDescr = checkNullAndTrim(rs.getString("DESCR"));
							unit = checkNullAndTrim(rs.getString("UNIT"));

							sql = " SELECT SHIPPER_SIZE FROM ITEM_LOT_PACKSIZE WHERE ITEM_CODE = ? ";
							pstmtShipper = conn.prepareStatement(sql);			
							pstmtShipper.setString(1,itemCode);			
							rsShipper = pstmtShipper.executeQuery();
							if(rsShipper.next())
							{
								shipperSize = rsShipper.getDouble("SHIPPER_SIZE");
							}
							else
							{
								shipperSize = 0.000;
							}
							if(rsShipper != null)
							{
								rsShipper.close();rsShipper = null;
							}	
							if(pstmtShipper != null)
							{	
								pstmtShipper.close();pstmtShipper = null;
							}

							if(shipperSize > 0)
							{
								noArtQuot= quantity / shipperSize ;
								noArtRem = quantity % shipperSize ;
								if(noArtRem > 0)
								{
									noArtRem = 1;
								}
								noArtQuot = (int) noArtQuot;
								noArt = noArtQuot + noArtRem;
								//noArt = noArtQuot ;
							}

							sql = "SELECT LOT_NO FROM CASE_LABEL WHERE ITEM_CODE = ? ";
							pstmtShipper = conn.prepareStatement(sql);			
							//pstmtShipper.setString(1,purcOrder);			
							pstmtShipper.setString(1,itemCode);			
							rsShipper = pstmtShipper.executeQuery();

							System.out.println("itemCode["+itemCode+"] quantity["+quantity+"] itemDescr["+itemDescr+"] unit["+unit+"] lineNo["+lineNo+"]");

							valueXmlString.append("<Detail2 domID = '"+domID+"' selected = 'N'>\r\n");
							valueXmlString.append("<contract_no>").append("<![CDATA["+ purcOrder +"]]>").append("</contract_no>\r\n");
							valueXmlString.append("<supp_code>").append("<![CDATA["+ suppCode +"]]>").append("</supp_code>\r\n");
							valueXmlString.append("<item_code>").append("<![CDATA["+ itemCode +"]]>").append("</item_code>\r\n");
							valueXmlString.append("<item_descr>").append("<![CDATA["+ itemDescr +"]]>").append("</item_descr>\r\n");
							valueXmlString.append("<unit>").append("<![CDATA["+ unit +"]]>").append("</unit>\r\n");
							valueXmlString.append("<tot_quantity>").append("<![CDATA["+quantity+"]]>").append("</tot_quantity>\r\n");
							valueXmlString.append("<quantity>").append("<![CDATA[]]>").append("</quantity>\r\n");
							valueXmlString.append("<shipper_size>").append("<![CDATA["+shipperSize+"]]>").append("</shipper_size>\r\n");
							valueXmlString.append("<no_art>").append("<![CDATA["+noArt+"]]>").append("</no_art>\r\n");
							valueXmlString.append("<site_code__mfg>").append("<![CDATA["+loginSiteCode+"]]>").append("</site_code__mfg>\r\n");
							valueXmlString.append("<line_no__ord>").append("<![CDATA["+lineNo+"]]>").append("</line_no__ord>\r\n");
							if(rsShipper.next())
							{
								lotNo = rsShipper.getString("LOT_NO");
								valueXmlString.append("<lot_no>").append("<![CDATA["+lotNo+"]]>").append("</lot_no>\r\n");
							}
							valueXmlString.append("</Detail2>\r\n");

							if(rsShipper != null)
							{
								rsShipper.close();rsShipper = null;
							}	
							if(pstmtShipper != null)
							{	
								pstmtShipper.close();pstmtShipper = null;
							}
						}	
						if(rs != null)
						{
							rs.close();rs = null;
						}	
						if(pstmt != null)
						{	
							pstmt.close();pstmt = null;
						}

					}
				}
			}
			break;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception ::"+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();rs = null;
				}	
				if(pstmt != null)
				{	
					pstmt.close();pstmt = null;
				}
				if(rsShipper != null)
				{
					rsShipper.close();rsShipper = null;
				}	
				if(pstmtShipper != null)
				{	
					pstmtShipper.close();pstmtShipper = null;
				}
				if(conn != null)
				{	
					conn.close();conn = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}			
		}

		valueXmlString.append("</Root>");
		System.out.println("valueXmlString ::"+valueXmlString.toString());

		return valueXmlString.toString();
	}

	/**
	 * select error description from MESSAGES
	 * @param conn
	 * @param errorCode
	 * @return
	 */
	private String errorType(Connection conn , String errorCode)
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1,errorCode);			
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}

	@Override
	public String getList(String field, String[] values, String details, UserInfoBean userInfo) throws RemoteException, ITMException 
	{
		String sql = "",scacCode = "",tranType = "",tranName = "";
		StringBuffer valueXmlString = new StringBuffer("<?xml version = \"1.0\" encoding = \"UTF-8\"?> \r\n <Root>\r\n");
		Connection conn = null;
		PreparedStatement pstmt = null, pstmtTran = null;
		ResultSet rs = null,rsTran = null;
		Timestamp currDate = null;
		try 
		{
			System.out.println("userInfo["+userInfo+"]");
			String loginCode = userInfo.getLoginCode();
			String loginSiteCode = userInfo.getSiteCode();
			//chgTerm = genericUtility.getValueFromXTRA_PARAMS( globalXtraParams, "chgTerm" );
			System.out.println("Inside getList---->loginSiteCode["+loginSiteCode+"] loginCode["+loginCode+"] Field["+field+"] Values["+values+"]");

			/*ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;*/
			conn = getConnection();
			currDate = getCurrtDate();

			if (field.equals("contract_no"))
			{
				/*sql =  " SELECT H.CONTRACT_NO,H.SUPP_CODE,H.TRAN_CODE,H.SITE_CODE__SUPP,S.SUPP_NAME FROM PCONTRACT_HDR H,PCONTRACT_DET D,SUPPLIER S  "
					+" WHERE H.CONFIRMED = 'Y' AND H.CONTRACT_NO = D.CONTRACT_NO AND S.SUPP_CODE = H.SUPP_CODE "
					+" AND (D.MAX_QTY - D.QUANTITY_REL) > 0 AND "
					+" H.CONTRACT_TODATE >= ? GROUP BY H.CONTRACT_NO,H.SUPP_CODE,H.TRAN_CODE,H.SITE_CODE__SUPP,S.SUPP_NAME ";*/

				sql =  " SELECT H.CONTRACT_NO,H.SUPP_CODE,H.TRAN_CODE,H.SITE_CODE__SUPP,S.SUPP_NAME FROM PCONTRACT_HDR H,PCONTRACT_DET D,SUPPLIER S  "
					+" WHERE H.CONFIRMED = 'Y' AND H.CONTRACT_NO = D.CONTRACT_NO AND S.SUPP_CODE = H.SUPP_CODE "
					+" AND (D.MAX_QTY - (CASE WHEN D.QUANTITY_REL IS NULL THEN 0 ELSE D.QUANTITY_REL END)) > 0  AND ((SELECT COALESCE((SELECT SUM(QUANTITY) FROM ASN_HDR AH, ASN_DET AD " 
					+" WHERE AD.TRAN_ID=AH.TRAN_ID AND AH.CONTRACT_NO = H.CONTRACT_NO AND AD.ITEM_CODE = D.ITEM_CODE) ,0) FROM DUAL)< (D.MAX_QTY - (CASE WHEN D.QUANTITY_REL IS NULL THEN 0 ELSE D.QUANTITY_REL END)) )" 
					+" AND  H.STATUS = ? AND H.CONTRACT_TODATE >= ? " 
					+" AND S.SITE_CODE = ? AND S.SUPP_CODE = ?"
					+" GROUP BY H.CONTRACT_NO,H.SUPP_CODE,H.TRAN_CODE,H.SITE_CODE__SUPP,S.SUPP_NAME ";
			}
			else if(field.equals("site_code"))
			{
				sql = " SELECT SITE_CODE,DESCR FROM SITE ";
			}
			else if(field.equals("purc_order"))
			{
				/*sql = " SELECT H.PURC_ORDER,H.SUPP_CODE,H.TRAN_CODE,S.SITE_CODE,S.SUPP_NAME FROM PORDER H,PORDDET D,SUPPLIER S WHERE H.CONFIRMED = 'Y' " +
						"AND H.PURC_ORDER = D.PURC_ORDER AND S.SUPP_CODE = H.SUPP_CODE  AND D.QUANTITY > 0 AND  H.ORD_DATE >= ? " +
						"GROUP BY H.PURC_ORDER,H.SUPP_CODE,H.TRAN_CODE,S.SITE_CODE,S.SUPP_NAME ";*/

				sql = "SELECT H.PURC_ORDER,H.SUPP_CODE,H.TRAN_CODE,S.SITE_CODE,S.SUPP_NAME FROM PORDER H,PORDDET D,SUPPLIER S WHERE H.CONFIRMED = 'Y' " +
				"AND H.PURC_ORDER = D.PURC_ORDER AND S.SUPP_CODE = H.SUPP_CODE AND D.QUANTITY > 0 AND ((SELECT COALESCE((SELECT SUM(QUANTITY) FROM ASN_HDR AH, ASN_DET AD " +
				"WHERE AD.TRAN_ID=AH.TRAN_ID AND AH.PURC_ORDER = H.PURC_ORDER AND AD.ITEM_CODE = D.ITEM_CODE) ,0) FROM DUAL)< D.QUANTITY ) " +
				" AND  H.STATUS = ? AND S.SITE_CODE = ? AND S.SUPP_CODE = ?" +
				" GROUP BY H.PURC_ORDER,H.SUPP_CODE,H.TRAN_CODE,S.SITE_CODE,S.SUPP_NAME ";
			}

			pstmt = conn.prepareStatement(sql);
			if (field.equals("contract_no"))
			{
				pstmt.setString(1, "O");
				pstmt.setTimestamp(2, currDate);
				pstmt.setString(3, loginSiteCode);
				pstmt.setString(4, loginCode);
			}
			else if (field.equals("purc_order"))
			{
				pstmt.setString(1, "O");
				pstmt.setString(2, loginSiteCode);
				pstmt.setString(3, loginCode);
			}
			rs = pstmt.executeQuery();

			int num = 1;
			while (rs.next())
			{
				String fieldId = checkNullAndTrim(rs.getString(1));
				String fieldValue = checkNullAndTrim(rs.getString(2));
				String otherField = "",siteCodeSupp = "",siteCodeSuppDescr = "",suppName = "";

				if (field.equals("contract_no") || field.equals("purc_order"))
				{
					otherField = checkNullAndTrim(rs.getString(3));
					siteCodeSupp = checkNullAndTrim(rs.getString(4));
					suppName = checkNullAndTrim(rs.getString(5));

					sql = " SELECT SCAC_CODE,TRANSPORTER_TYPE,TRAN_NAME FROM TRANSPORTER WHERE TRAN_CODE = ? ";
					pstmtTran = conn.prepareStatement(sql);			
					pstmtTran.setString(1,otherField);			
					rsTran = pstmtTran.executeQuery();
					if(rsTran.next())
					{
						scacCode = checkNullAndTrim(rsTran.getString("SCAC_CODE"));
						tranType = checkNullAndTrim(rsTran.getString("TRANSPORTER_TYPE"));
						tranName = checkNullAndTrim(rsTran.getString("TRAN_NAME"));
					}
					if ( rsTran != null )
					{
						rsTran.close();rsTran = null;
					}
					if( pstmtTran != null )
					{
						pstmtTran.close();pstmtTran = null;
					}

					sql = " SELECT DESCR FROM SITE WHERE SITE_CODE = ? ";
					pstmtTran = conn.prepareStatement(sql);			
					pstmtTran.setString(1,siteCodeSupp);			
					rsTran = pstmtTran.executeQuery();
					if(rsTran.next())
					{
						siteCodeSuppDescr = checkNullAndTrim(rsTran.getString("DESCR"));
					}
					if ( rsTran != null )
					{
						rsTran.close();rsTran = null;
					}
					if( pstmtTran != null )
					{
						pstmtTran.close();pstmtTran = null;
					}

					otherField = otherField +":"+ tranName +":"+ tranType +":"+ scacCode +":"+ siteCodeSupp +":"+ siteCodeSuppDescr +":"+ suppName;
				}

				valueXmlString.append("<List domID='" + num + "' selected = '" + useLoop(values, fieldId) + "'>\r\n");
				valueXmlString.append("<fieldId><![CDATA[").append(fieldId).append("]]></fieldId>\r\n");
				valueXmlString.append("<fieldValue><![CDATA[").append(fieldValue).append("]]></fieldValue>\r\n");
				valueXmlString.append("<otherField><![CDATA[").append(otherField).append("]]></otherField>\r\n");
				valueXmlString.append("</List>\r\n");
				num++;
			}
			if(details.length() > 0)
			{
				Document dom = genericUtility.parseString(details); 
				Node currDetail = null;
				NodeList detail1List = null;
				NodeList currDetail1List = null;
				Node childNode = null;
				detail1List = dom.getElementsByTagName("Headers");
				for ( int ctr1 = 0; ctr1 < detail1List.getLength(); ctr1++ )
				{
					valueXmlString.append("<Headers domID='" + ctr1 + "' selected = 'N' >\r\n");
					currDetail = detail1List.item(ctr1);
					currDetail1List = currDetail.getChildNodes();
					for ( int i=0; i< currDetail1List.getLength(); i++ )
					{
						childNode = currDetail1List.item(i);
						String nodeName = childNode.getNodeName();	
						String nodeValue = "";
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							nodeValue =  checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						if (nodeName.equalsIgnoreCase("headName"))
						{
							valueXmlString.append("<headName><![CDATA[").append(nodeValue).append("]]></headName>\r\n");
						}
						if (nodeName.equalsIgnoreCase("headSize"))
						{
							valueXmlString.append("<headSize><![CDATA[").append(nodeValue).append("]]></headSize>\r\n");
						}
					}
					valueXmlString.append("</Headers>\r\n");
				}	
			}

		} 
		catch (Exception e) 
		{
			e.printStackTrace();
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		} 
		finally 
		{
			try 
			{
				if (rs != null) 
				{					
					rs.close();rs = null;
				}
				if (pstmt != null ) 
				{					
					pstmt.close();pstmt = null;
				}
				if( pstmtTran != null )
				{
					pstmtTran.close();pstmtTran = null;
				}
				if (conn != null && !conn.isClosed()) 
				{					
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e) 
			{
				e.getMessage();
				throw new ITMException(e);
			}
		}
		valueXmlString.append("</Root>\r\n");
		System.out.println("\n****ValueXmlString Pop Help:" + valueXmlString.toString()	+ ":********");

		return valueXmlString.toString();
	}


	public String getItemLotPackSize(String itemCode,String lotNo)
	{
		String shipperSize = "",sql = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;

		Connection conn = null;
		try
		{		
			/*ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;*/
			conn = getConnection();

			sql = " SELECT L.SHIPPER_SIZE FROM ITEM_LOT_PACKSIZE L,ITEM I "
				+ " WHERE I.ITEM_CODE = L.ITEM_CODE AND L.ITEM_CODE = ? AND L.LOT_NO__FROM <= ? AND L.LOT_NO__TO >= ? ";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1,itemCode);
			pstmt.setString(2,lotNo);
			pstmt.setString(3,lotNo);

			rs = pstmt.executeQuery();
			if(rs.next())
			{
				shipperSize = rs.getString("SHIPPER_SIZE");
			}
			else
			{
				shipperSize = "0.000";
			}
			if(rs != null)
			{
				rs.close();rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();pstmt = null;
			}
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
				if(conn != null)
				{
					conn.close();conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}		
		return shipperSize;
	}

	/**
	 * 
	 * @param input
	 * @return
	 */
	private static String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input;
	}
	private static String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}

	/**
	 * 
	 * @param arr
	 * @param targetValue
	 * @return
	 */
	public static String useLoop(String[] arr, String targetValue)
	{
		for(String s: arr)
		{
			String str = checkNullAndTrim(s);
			if(str.equals(targetValue))
				return "Y";
		}

		return "N";
	}

	/**
	 * get current date in Timestap formate
	 */
	private java.sql.Timestamp getCurrtDate() throws RemoteException,ITMException 
	{
		String currAppdate = "";
		java.sql.Timestamp currDate = null;
		try 
		{
			Object date = null;
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(genericUtility.getDBDateFormat());
			date = sdf.parse(currDate.toString());
			currDate = java.sql.Timestamp.valueOf(sdf.format(date).toString()+ " 00:00:00.0");

		} 
		catch (Exception e) 
		{
			throw new ITMException(e);
		}
		return (currDate);
	}

	//Changed by manish on 07/10/16[start]
	public String insertCaseLabel( String itemCode,String lotNo,String qty,String ordNo)throws RemoteException,ITMException 
	{
		String sql = "",packLabel = "",userId = "",chgTerm = "",loginSiteCode = "",errCode = "",errString = "";
		int quantity = 0;
		PreparedStatement pstmt = null; 
		ResultSet rs = null;
		Timestamp currDate = null;	
		boolean isErrorInsert = false;
		Connection tempConn = getConnection();

		try
		{
			userId = genericUtility.getValueFromXTRA_PARAMS( globalXtraParams, "loginCode" );
			chgTerm = genericUtility.getValueFromXTRA_PARAMS( globalXtraParams, "chgTerm" );
			currDate = getCurrtDate();
			quantity = (int)Double.parseDouble(qty);
			packLabel = ordNo + lotNo + itemCode + quantity;

			sql = " SELECT ITEM_CODE,LOT_NO,ORDER_NO,REF_SER FROM CASE_LABEL WHERE ITEM_CODE = ? AND LOT_NO= ? AND ORDER_NO = ? " +
			"AND REF_SER =? ";
			pstmt = tempConn.prepareStatement(sql);	
			pstmt.setString(1,itemCode);
			pstmt.setString(2,lotNo);	
			pstmt.setString(3,ordNo);	
			pstmt.setString(4,"P-CON");	
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				System.out.println("===RECORD ALREADY EXIST========");
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
				errString = "0";
			}
			else
			{
				sql = " INSERT INTO CASE_LABEL (ITEM_CODE,LOT_NO,ORDER_NO,REF_SER,QUANTITY,LABEL_NO,CHG_USER,CHG_DATE,CHG_TERM) "
					+ " VALUES (?,?,?,?,?,?,?,?,?) ";
				pstmt = tempConn.prepareStatement(sql);	
				pstmt.setString(1,itemCode);
				pstmt.setString(2,lotNo);	
				pstmt.setString(3,ordNo);	
				pstmt.setString(4,"P-CON");	
				pstmt.setInt(5,quantity);	
				pstmt.setString(6,packLabel);	
				pstmt.setString(7,userId);
				pstmt.setTimestamp(8,currDate);
				pstmt.setString(9,chgTerm);
				int insertCnt = pstmt.executeUpdate();
				System.out.println("number of insert in porder : "+insertCnt);
				errString = "1";
			}
			if(pstmt != null)
			{
				pstmt.close();pstmt = null;
			}

		}
		catch(Exception e)
		{
			System.out.println("error in insert data");
			isErrorInsert = true;
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(isErrorInsert)
				{
					tempConn.rollback();
				}
				else
				{
					tempConn.commit();
				}
				if(tempConn != null)
				{
					tempConn.close();tempConn = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}

			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return errString;
	}

	public String calcExpDate(String mfgDate, String itemCode) throws RemoteException, ITMException
	{
		double minSelfLife = 0.0;
		String sql = "", expDate = "";
		PreparedStatement pstmt = null; 
		ResultSet rs = null;
		Connection tempConn = getConnection();
		DistCommon distComm = new DistCommon();
		java.sql.Timestamp expDateCalc = null, mfgDateTs = null;
		try
		{
			sql = "SELECT MIN_SHELF_LIFE FROM ITEM WHERE ITEM_CODE = ? ";
			pstmt = tempConn.prepareStatement(sql);
			pstmt.setString( 1, itemCode );
			rs = pstmt.executeQuery();
			if ( rs.next() )
			{
				minSelfLife = rs.getDouble("MIN_SHELF_LIFE");
			}
			pstmt.clearParameters();
			System.out.println("minSelfLife["+minSelfLife+"] ");
			mfgDateTs = Timestamp.valueOf(genericUtility.getValidDateString(mfgDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
			expDateCalc = distComm.CalcExpiry( mfgDateTs, minSelfLife );
			System.out.println("expDateCalc["+expDateCalc+"] ");

			expDate = new SimpleDateFormat(genericUtility.getApplDateFormat()).format(expDateCalc);
			System.out.println("expDate["+expDate+"] ");
			pstmt.close(); pstmt = null;
			rs.close(); rs = null;
		}
		catch(Exception e)
		{
			System.out.println("errorrrrrrrrrrrrrrrrrrrrrrrr");
			e.printStackTrace();
		}
		return expDate;
	}
	
	public String compDate(String mfgDate,String expDate) throws RemoteException, ITMException
	{
		String compareDate = "";
		java.sql.Timestamp mfgDateTs = null;
		java.sql.Timestamp expDateTs = null;
		try
		{
			mfgDateTs = Timestamp.valueOf(genericUtility.getValidDateString(mfgDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
			expDateTs = Timestamp.valueOf(genericUtility.getValidDateString(expDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
			java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(genericUtility.getDBDateFormat());
			if (mfgDateTs.compareTo(expDateTs) > 0)
			{	
				compareDate = "1"; 
			}
			else
			{
				compareDate = "0"; 
			}
		}
		catch(Exception e)
		{
			System.out.println("errorrrrrrrrrrrrrrrrrrrrrrrr");
			e.printStackTrace();
		}
		return compareDate;
	}
	public String getSiteCode(String purcOrder, String contractNo) throws RemoteException, ITMException
	{
		String sql = "", siteCode = "", siteCodeLcns = "", siteCodeDlv = "";
		PreparedStatement pstmt = null; 
		ResultSet rs = null;
		Connection tempConn = getConnection();
		java.sql.Timestamp expDateCalc = null, mfgDateTs = null;
		try
		{
			sql = "SELECT SITE_CODE__LICENSE FROM PCONTRACT_HDR WHERE CONTRACT_NO = ?";
			pstmt = tempConn.prepareStatement(sql);			
			pstmt.setString(1,contractNo);			
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				siteCodeLcns = checkNullAndTrim(rs.getString("SITE_CODE__LICENSE"));
			}	
			if(rs != null)
			{
				rs.close();rs = null;
			}	
			if(pstmt != null)
			{	
				pstmt.close();pstmt = null;
			}

			sql = "SELECT SITE_CODE__DLV FROM PORDER WHERE PURC_ORDER = ?";
			pstmt = tempConn.prepareStatement(sql);			
			pstmt.setString(1,purcOrder);			
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				siteCodeDlv = checkNullAndTrim(rs.getString("SITE_CODE__DLV"));
				System.out.println("siteCodeDlv===["+siteCodeDlv+"]");
			}	
			if(rs != null)
			{
				rs.close();rs = null;
			}	
			if(pstmt != null)
			{	
				pstmt.close();pstmt = null;
			}
			if(siteCodeLcns != null && siteCodeLcns.trim().length() > 0)
			{
				//siteCode = siteCodeLcns;
				siteCode = "";
			}
			else
			{
				siteCode = siteCodeDlv;
			}
			System.out.println("siteCode["+siteCode+"]");
		}
		catch(Exception e)
		{
			System.out.println("errorrrrrrrrrrrrrrrrrrrrrrrr");
			e.printStackTrace();
		}
		return siteCode;
	}
	
	//Changed by manish on 07/10/16[end]
}
