package ibase.dashboard.scm.ejb;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.ejb.Stateless;
import org.json.simple.JSONObject;

/**
 * Session Bean implementation class SalesPersonSales
 */
@Stateless
public class SalesPerformance extends ValidatorEJB implements SalesPerformanceRemote, SalesPerformanceLocal
{
	/**
	 * Default constructor.
	 */
	private JSONObject jsonMetaData = null;
	private JSONObject jsonData = null;

	public SalesPerformance()
	{

	}	
	/*** 
	 * Method Name      : getSalesGraphData(String dataSourceName, String month)
	 * Servlet Name     : SalesPerfrmncSalesGrphServlet
	 * Metadataxml Name : salesdashboard.xml
	 * Description      : This method returns  raw data for rendering the Sales graph. 
	 * Graph Caption    :
	 *                    1. Monthly Sales trend - India BU
	 * ***/
	E12GenericUtility e12GenericUtility = new E12GenericUtility();
	@SuppressWarnings("unchecked")
	public JSONObject getSalesGraphData(String dataSourceName, String month) throws RemoteException, ITMException
	{
		JSONObject rawDataJson = new JSONObject();
		JSONObject rowData     = null;
		String sql             = "";
		String finYear         = "";
		ResultSet rs           = null;
		PreparedStatement pstmt= null;
		Connection conn        = null;		
		try
		{
			/*conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;*/
			/*add new code for connection DB on dated:15062016 by Nikhil*/
			conn = getConnection();
			int count=0;
			if(month!=null && month.trim().length()>0)
			{
				System.out.println("month comming from GWT ==="+month);					
				String selectedMonth  = month.substring(4, 6);				
				if(selectedMonth.trim().equalsIgnoreCase("01") ||selectedMonth.trim().equalsIgnoreCase("02") ||selectedMonth.trim().equalsIgnoreCase("03"))
				{
			    	finYear = String.valueOf(Integer.parseInt(month.substring(0, 4))-1)+"-"+month.substring(2, 4);
				}
				else
				{
					finYear = month.substring(0, 4)+"-"+ (String.valueOf(Integer.parseInt(month.substring(0, 4))+1)).substring(2, 4);
				}
				System.out.println("updates month and year from dcoding  =="+month+"finYear =="+finYear);
				
				//previous code 
				//sql = " SELECT TRAN, APR,MAY,JUN,JUL,AUG,SEP,OCT,NOV,DEC,JAN,FEB,MAR " + " FROM (SELECT '1.SALES' AS TRAN, ROUND(SUM(CY_SALE_MTH_APR)/10000000,1) AS APR, " + " ROUND(SUM(CY_SALE_MTH_MAY)/10000000,1) AS MAY,ROUND(SUM(CY_SALE_MTH_JUN)/10000000,1) AS JUN," + " ROUND(SUM(CY_SALE_MTH_JUL)/10000000,1) AS JUL,ROUND(SUM(CY_SALE_MTH_AUG)/10000000,1) AS AUG," + " ROUND(SUM(CY_SALE_MTH_SEP)/10000000,1) AS SEP,ROUND(SUM(CY_SALE_MTH_OCT)/10000000,1) AS OCT," + " ROUND(SUM(CY_SALE_MTH_NOV)/10000000,1) AS NOV,ROUND(SUM(CY_SALE_MTH_DEC)/10000000,1) AS DEC," + " ROUND(SUM(CY_SALE_MTH_JAN)/10000000,1) AS JAN,ROUND(SUM(CY_SALE_MTH_FEB)/10000000,1) AS FEB, " + " ROUND(SUM(CY_SALE_MTH_MAR)/10000000,1) AS MAR FROM SM_SALES_SUMM_WIDE, SALES_ITEM, " + " SM_SALES_BRAND_MST BRND WHERE TRIM(SM_SALES_SUMM_WIDE.FIN_YEAR)= '"+finYear+"' " + " AND SM_SALES_SUMM_WIDE.ITEM_CODE= SALES_ITEM.ITEM_CODE AND BRND.BRAND_CODE(+) = SALES_ITEM.ITEM_SUB_GROUP " + " AND BRND.DIV_CODE(+) = SALES_ITEM.ITEM_SER AND BRND.FIN_YEAR(+) = '"+finYear+"' " + " AND SALES_ITEM.ITEM_SUB_GROUP NOT IN ('CU','BJ')	UNION ALL " + " SELECT '2.HO ACH%' AS TRAN,(CASE WHEN SUM(FLD_TRGT_MTH_APR) <>0 THEN " + " ROUND( SUM(CY_SALE_MTH_APR)/ SUM(FLD_TRGT_MTH_APR * (100+ NVL(BRND.HO_TRGT_INCR_PRCNT,0)) /100)* 100 ,1) " + " ELSE ROUND(0*100,1) END) AS APR,(CASE WHEN SUM(FLD_TRGT_MTH_MAY) <>0 THEN ROUND( SUM(CY_SALE_MTH_MAY) " + " / SUM(FLD_TRGT_MTH_MAY * (100+ NVL(BRND.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) ELSE ROUND(0*100,1) END) AS MAY, " + " (CASE WHEN SUM(FLD_TRGT_MTH_JUN) <>0 THEN ROUND( SUM(CY_SALE_MTH_JUN)/ SUM(FLD_TRGT_MTH_JUN * (100+ NVL(BRND.HO_TRGT_INCR_PRCNT,0)) /100) " + " * 100 ,1) ELSE ROUND(0*100,1) END) AS JUN,(CASE WHEN SUM(FLD_TRGT_MTH_JUL) <>0 THEN ROUND( SUM(CY_SALE_MTH_JUL) " + " / SUM(FLD_TRGT_MTH_JUL * (100+ NVL(BRND.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) ELSE ROUND(0*100,1) END) AS JUL, " + " (CASE WHEN SUM(FLD_TRGT_MTH_AUG) <>0 THEN ROUND( SUM(CY_SALE_MTH_AUG)/ SUM(FLD_TRGT_MTH_AUG * (100+ NVL(BRND.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " + " ELSE ROUND(0*100,1) END) AS AUG,(CASE WHEN SUM(FLD_TRGT_MTH_SEP) <>0 THEN ROUND( SUM(CY_SALE_MTH_SEP) " + " / SUM(FLD_TRGT_MTH_SEP * (100+ NVL(BRND.HO_TRGT_INCR_PRCNT,0)) /100)  * 100 ,1) " + " ELSE ROUND(0*100,1) END) AS SEP,(CASE WHEN SUM(FLD_TRGT_MTH_OCT) <>0 THEN ROUND( SUM(CY_SALE_MTH_OCT) " + " / SUM(FLD_TRGT_MTH_OCT * (100+ NVL(BRND.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " + " ELSE ROUND(0*100,1) END) AS OCT,(CASE WHEN SUM(FLD_TRGT_MTH_NOV) <>0 THEN ROUND( SUM(CY_SALE_MTH_NOV) " + " / SUM(FLD_TRGT_MTH_NOV * (100+ NVL(BRND.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) ELSE ROUND(0*100,1) END) AS NOV, " + " (CASE WHEN SUM(FLD_TRGT_MTH_DEC) <>0 THEN ROUND( SUM(CY_SALE_MTH_DEC)/ SUM(FLD_TRGT_MTH_DEC * (100+ NVL(BRND.HO_TRGT_INCR_PRCNT,0)) /100) " + " * 100 ,1) ELSE ROUND(0*100,1) END) AS DEC,(CASE WHEN SUM(FLD_TRGT_MTH_JAN) <>0 THEN ROUND( SUM(CY_SALE_MTH_JAN) " + " / SUM(FLD_TRGT_MTH_JAN * (100+ NVL(BRND.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) ELSE ROUND(0*100,1) END) AS JAN," + " (CASE WHEN SUM(FLD_TRGT_MTH_FEB) <>0 THEN ROUND( SUM(CY_SALE_MTH_FEB)/ SUM(FLD_TRGT_MTH_FEB * (100+ NVL(BRND.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " + " ELSE ROUND(0*100,1) END) AS FEB,(CASE WHEN SUM(FLD_TRGT_MTH_MAR) <>0 THEN ROUND( SUM(CY_SALE_MTH_MAR) " + " / SUM(FLD_TRGT_MTH_MAR * (100+ NVL(BRND.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) ELSE ROUND(0*100,1) END) AS MAR " + " FROM SM_SALES_SUMM_WIDE, SALES_ITEM, SM_SALES_BRAND_MST BRND WHERE TRIM(SM_SALES_SUMM_WIDE.FIN_YEAR)= '"+finYear+"' " + " AND SM_SALES_SUMM_WIDE.ITEM_CODE= SALES_ITEM.ITEM_CODE AND BRND.BRAND_CODE(+) = SALES_ITEM.ITEM_SUB_GROUP " + " AND BRND.DIV_CODE(+) = SALES_ITEM.ITEM_SER AND BRND.FIN_YEAR(+) = '"+finYear+"' AND SALES_ITEM.ITEM_SUB_GROUP NOT IN ('CU','BJ') " + " UNION ALL SELECT '3.GR %' AS TRAN,(CASE WHEN SUM(LY_SALE_MTH_APR) <>0  AND SUM(CY_SALE_MTH_APR)<> 0 THEN " + " ROUND( (SUM(CY_SALE_MTH_APR) -SUM(LY_SALE_MTH_APR)) / SUM(LY_SALE_MTH_APR) *100 ,1) " + " ELSE ROUND(0*100,1) END) AS APR,(CASE WHEN SUM(LY_SALE_MTH_MAY) <>0 AND SUM(CY_SALE_MTH_MAY)<> 0 THEN " + " ROUND( (SUM(CY_SALE_MTH_MAY) -SUM(LY_SALE_MTH_MAY))/ SUM(LY_SALE_MTH_MAY) *100 ,1) ELSE ROUND(0*100,1) END) AS MAY, " + " (CASE WHEN SUM(LY_SALE_MTH_JUN) <>0 AND SUM(CY_SALE_MTH_JUN)<> 0 THEN ROUND( (SUM(CY_SALE_MTH_JUN) -SUM(LY_SALE_MTH_JUN)) " + " / SUM(LY_SALE_MTH_JUN) *100 ,1) ELSE ROUND(0*100,1) END) AS JUN,(CASE WHEN SUM(LY_SALE_MTH_JUL) <>0 AND SUM(CY_SALE_MTH_JUL)<> 0 THEN " + " ROUND( (SUM(CY_SALE_MTH_JUL) -SUM(LY_SALE_MTH_JUL)) / SUM(LY_SALE_MTH_JUL) *100 ,1) ELSE ROUND(0*100,1) END) AS JUL, " + " (CASE WHEN SUM(LY_SALE_MTH_AUG) <>0 AND SUM(CY_SALE_MTH_AUG)<> 0 THEN ROUND( (SUM(CY_SALE_MTH_AUG) -SUM(LY_SALE_MTH_AUG)) " + " / SUM(LY_SALE_MTH_AUG) *100 ,1) ELSE ROUND(0*100,1) END) AS AUG,(CASE WHEN SUM(LY_SALE_MTH_SEP) <>0 AND SUM(CY_SALE_MTH_SEP)<> 0 THEN " + " ROUND( (SUM(CY_SALE_MTH_SEP) -SUM(LY_SALE_MTH_SEP)) / SUM(LY_SALE_MTH_SEP) *100 ,1) ELSE ROUND(0*100,1) END) AS SEP, " + " (CASE WHEN SUM(LY_SALE_MTH_OCT) <>0 AND SUM(CY_SALE_MTH_OCT)<> 0 THEN ROUND( (SUM(CY_SALE_MTH_OCT) -SUM(LY_SALE_MTH_OCT)) " + " / SUM(LY_SALE_MTH_OCT) *100 ,1)ELSE ROUND(0*100,1) END) AS OCT,(CASE WHEN SUM(LY_SALE_MTH_NOV) <>0 AND SUM(CY_SALE_MTH_NOV)<> 0 THEN " + " ROUND( (SUM(CY_SALE_MTH_NOV) -SUM(LY_SALE_MTH_NOV))/ SUM(LY_SALE_MTH_NOV) *100 ,1) ELSE ROUND(0*100,1) END) AS NOV, " + " (CASE WHEN SUM(LY_SALE_MTH_DEC) <>0 AND SUM(CY_SALE_MTH_DEC)<> 0 THEN ROUND( (SUM(CY_SALE_MTH_DEC) -SUM(LY_SALE_MTH_DEC)) " + " / SUM(LY_SALE_MTH_DEC) *100 ,1) ELSE ROUND(0*100,1) END) AS DEC,(CASE WHEN SUM(LY_SALE_MTH_JAN) <>0 AND SUM(CY_SALE_MTH_JAN)<> 0 THEN " + " ROUND( (SUM(CY_SALE_MTH_JAN) -SUM(LY_SALE_MTH_JAN)) / SUM(LY_SALE_MTH_JAN) *100 ,1) ELSE ROUND(0*100,1) END) AS JAN, " + " (CASE WHEN SUM(LY_SALE_MTH_FEB) <>0 AND SUM(CY_SALE_MTH_FEB)<> 0 THEN ROUND( (SUM(CY_SALE_MTH_FEB) -SUM(LY_SALE_MTH_FEB)) " + " / SUM(LY_SALE_MTH_FEB) *100 ,1) ELSE ROUND(0*100,1) END) AS FEB,(CASE WHEN SUM(LY_SALE_MTH_MAR) <>0 AND SUM(CY_SALE_MTH_MAR)<> 0 THEN " + " ROUND( (SUM(CY_SALE_MTH_MAR) -SUM(LY_SALE_MTH_MAR))/ SUM(LY_SALE_MTH_MAR) *100 ,1) ELSE ROUND(0*100,1) END) AS MAR " + " FROM SM_SALES_SUMM_WIDE, SALES_ITEM, SM_SALES_BRAND_MST BRND WHERE TRIM(SM_SALES_SUMM_WIDE.FIN_YEAR)= '"+finYear+"' " + " AND SM_SALES_SUMM_WIDE.ITEM_CODE= SALES_ITEM.ITEM_CODE AND BRND.BRAND_CODE(+) = SALES_ITEM.ITEM_SUB_GROUP " + " AND BRND.DIV_CODE(+) = SALES_ITEM.ITEM_SER AND BRND.FIN_YEAR(+) = '"+finYear+"' AND SALES_ITEM.ITEM_SUB_GROUP NOT IN ('CU','BJ') " + " )WHERE '"+finYear+"' = '"+finYear+"'";
				sql=" SELECT mnno,mth,round(mthcysl/100,1) as mthcysl, round(ytdcysl/100,1) as ytdcysl, "
					      +" (CASE WHEN mthach<-200 THEN -200 WHEN mthach >200 THEN 200 ELSE mthach END) mthach, "
					      +"  (CASE WHEN ytdach<-200 THEN -200 WHEN ytdach >200 THEN 200 ELSE ytdach END) ytdach, "
					      +"  (CASE WHEN mthgr<-200 THEN -200 WHEN mthgr >200 THEN 200 ELSE mthgr END) mthgr, "
					      +"  (CASE WHEN ytdgr<-200 THEN -200 WHEN ytdgr >200 THEN 200 ELSE ytdgr END) ytdgr "
					      +" FROM( "
					      +" SELECT 1 AS mnno, 'APR' AS mth, " 
					      +" ROUND(SUM(sl.CY_SALE_MTH_APR)/100000,2) AS mthcysl, " 
					      +" ROUND(SUM(sl.CY_SALE_YTD_APR)/100000,2) AS ytdcysl, "
					      +" (CASE WHEN SUM(sl.FLD_TRGT_MTH_apr) <>0 THEN "
					      +" ROUND( SUM(sl.CY_SALE_MTH_apr)  "
					      +" / SUM(sl.FLD_TRGT_MTH_apr * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) "
					      +" * 100 ,1)  "
					      +" ELSE ROUND(2*100,1) END) AS mthach, "
					      +" (CASE WHEN SUM(sl.FLD_TRGT_YTD_apr) <>0 THEN "
					      +" ROUND( SUM(sl.CY_SALE_YTD_apr) " 
					      +" / SUM(sl.FLD_TRGT_YTD_apr * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) "
					      +" * 100 ,1) " 
					      +" ELSE ROUND(2*100,1) END) AS ytdach, "
					      +" (CASE WHEN SUM(sl.lY_SALE_MTH_apr) <>0  THEN "
					      +" ROUND( (SUM(sl.CY_SALE_MTH_apr) -SUM(sl.lY_SALE_MTH_apr)) "
					      +" / SUM(sl.lY_SALE_MTH_apr) *100 ,1) "
					      +" ELSE ROUND(2*100,1) END) AS mthgr, "
					      +" (CASE WHEN SUM(sl.lY_SALE_ytd_apr) <>0  THEN "
					      +" ROUND( (SUM(sl.CY_SALE_ytd_apr) -SUM(sl.lY_SALE_ytd_apr)) "
					      +" / SUM(sl.lY_SALE_ytd_apr) *100 ,1) "
					      +" ELSE ROUND(2*100,1) END) AS ytdgr "
					      +" FROM SM_SALES_SUMM_WIDE sl, sales_item, SM_SALES_BRAND_MST brnd "
					      +" WHERE  trim(Sl.fin_year)= (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
					      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
					      +" AND Sl.item_code= sales_item.item_code "
					      +" AND brnd.brand_code(+) = sales_item.item_sub_group "
					      +" AND brnd.div_code(+) = sales_item.item_ser "
					      +" AND brnd.fin_year(+) = (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
					      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
					      +" AND sales_item.item_sub_group NOT IN ('CU','BJ') "	
					      +" AND TO_NUMBER(SUBSTR(sl.fin_year,1,4)||'04') <= TO_NUMBER('"+month+"') "
					      +" AND '"+month+"' ='"+month+"' "	
					      +" UNION ALL "
					      +" SELECT 2 AS mnno,  'MAY' AS mth, " 
					      +" ROUND(SUM(sl.CY_SALE_MTH_may)/100000,2) AS mthcysl, "
					      +" ROUND(SUM(sl.CY_SALE_YTD_may)/100000,2) AS ytdcysl, "
					      +" (CASE WHEN SUM(sl.FLD_TRGT_MTH_may) <>0 THEN "
					      +" ROUND( SUM(sl.CY_SALE_MTH_may) " 
					      +" / SUM(sl.FLD_TRGT_MTH_may * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) "
					      +" * 100 ,1) " 
					      +" ELSE ROUND(0*100,1) END) AS mthach, "
					      +" (CASE WHEN SUM(sl.FLD_TRGT_YTD_may) <>0 THEN "
					      +" ROUND( SUM(sl.CY_SALE_YTD_may) " 
					      +" / SUM(sl.FLD_TRGT_YTD_may * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) "
					      +" * 100 ,1) " 
					      +" ELSE ROUND(0*100,1) END) AS ytdach, " 
					      +" (CASE WHEN SUM(sl.lY_SALE_MTH_may) <>0  THEN "
					      +" ROUND( (SUM(sl.CY_SALE_MTH_may) -SUM(sl.lY_SALE_MTH_may)) "
					      +" / SUM(sl.lY_SALE_MTH_may) *100 ,1) "
					      +" ELSE ROUND(0*100,1) END) AS mthgr, "
					      +" (CASE WHEN SUM(sl.lY_SALE_ytd_may) <>0  THEN "
					      +" ROUND( (SUM(sl.CY_SALE_ytd_may) -SUM(sl.lY_SALE_ytd_may)) "
					      +" / SUM(sl.lY_SALE_ytd_may) *100 ,1) "
					      +" ELSE ROUND(0*100,1) END) AS ytdgr "
					      +" FROM SM_SALES_SUMM_WIDE sl, sales_item, SM_SALES_BRAND_MST brnd "
					      +" WHERE trim(Sl.fin_year)= (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
					      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
					      +" AND Sl.item_code= sales_item.item_code "
					      +" AND brnd.brand_code(+) = sales_item.item_sub_group "
					      +" AND brnd.div_code(+) = sales_item.item_ser "
					      +" AND brnd.fin_year(+) = (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
					      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
					      +" AND sales_item.item_sub_group NOT IN ('CU','BJ') "	
					      +" AND TO_NUMBER(SUBSTR(sl.fin_year,1,4)||'05') <= TO_NUMBER('"+month+"') "
					      +" UNION ALL "
					      +" SELECT  3 AS mnno, 'JUN' AS mth, " 
					      +" ROUND(SUM(sl.CY_SALE_MTH_JUN)/100000,2) AS mthcysl, "
					      +" ROUND(SUM(sl.CY_SALE_YTD_JUN)/100000,2) AS ytdcysl, "
					      +" (CASE WHEN SUM(sl.FLD_TRGT_MTH_JUN) <>0 THEN "
					      +" ROUND( SUM(sl.CY_SALE_MTH_JUN) " 
					      +" / SUM(sl.FLD_TRGT_MTH_JUN * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) "
					      +" * 100 ,1) " 
					      +" ELSE ROUND(0*100,1) END) AS mthach, "
					      +" (CASE WHEN SUM(sl.FLD_TRGT_YTD_JUN) <>0 THEN "
					      +" ROUND( SUM(sl.CY_SALE_YTD_JUN) " 
					      +" / SUM(sl.FLD_TRGT_YTD_JUN * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) "
					      +" * 100 ,1)  "
					      +" ELSE ROUND(0*100,1) END) AS ytdach, "
					      +" (CASE WHEN SUM(sl.lY_SALE_MTH_JUN) <>0  THEN "
					      +" ROUND( (SUM(sl.CY_SALE_MTH_JUN) -SUM(sl.lY_SALE_MTH_JUN)) "
					      +" / SUM(sl.lY_SALE_MTH_JUN) *100 ,1) "
					      +" ELSE ROUND(0*100,1) END) AS mthgr, "
					      +" (CASE WHEN SUM(sl.lY_SALE_ytd_JUN) <>0  THEN "
					      +" ROUND( (SUM(sl.CY_SALE_ytd_JUN) -SUM(sl.lY_SALE_ytd_JUN)) "
					      +" / SUM(sl.lY_SALE_ytd_JUN) *100 ,1) "
					      +" ELSE ROUND(0*100,1) END) AS ytdgr "
					      +" FROM SM_SALES_SUMM_WIDE sl, sales_item, SM_SALES_BRAND_MST brnd "
					      +" WHERE trim(Sl.fin_year)= (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
					      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
					      +" AND Sl.item_code= sales_item.item_code "
					      +" AND brnd.brand_code(+) = sales_item.item_sub_group "
					      +" AND brnd.div_code(+) = sales_item.item_ser "
					      +" AND brnd.fin_year(+) = (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
					      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
					      +" AND sales_item.item_sub_group NOT IN ('CU','BJ') "	
					      +" AND TO_NUMBER(SUBSTR(sl.fin_year,1,4)||'06') <= TO_NUMBER('"+month+"') "
					      +" UNION ALL "
					      +" SELECT  4 AS mnno, 'JUL' AS mth, " 
					      +" ROUND(SUM(sl.CY_SALE_MTH_JUL)/100000,2) AS mthcysl, "
					      +" ROUND(SUM(sl.CY_SALE_YTD_JUL)/100000,2) AS ytdcysl, "
					      +" (CASE WHEN SUM(sl.FLD_TRGT_MTH_JUL) <>0 THEN "
					      +" ROUND( SUM(sl.CY_SALE_MTH_JUL) " 
					      +" / SUM(sl.FLD_TRGT_MTH_JUL * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) "
					      +" * 100 ,1) " 
					      +" ELSE ROUND(0*100,1) END) AS mthach, "
					      +" (CASE WHEN SUM(sl.FLD_TRGT_YTD_JUL) <>0 THEN "
					      +" ROUND( SUM(sl.CY_SALE_YTD_JUL) " 
					      +" / SUM(sl.FLD_TRGT_YTD_JUL * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) "
					      +" * 100 ,1) " 
					      +" ELSE ROUND(0*100,1) END) AS ytdach, "
					      +" (CASE WHEN SUM(sl.lY_SALE_MTH_JUL) <>0  THEN "
					      +" ROUND( (SUM(sl.CY_SALE_MTH_JUL) -SUM(sl.lY_SALE_MTH_JUL)) "
					      +" / SUM(sl.lY_SALE_MTH_JUL) *100 ,1) "
					      +" ELSE ROUND(0*100,1) END) AS mthgr, "
					      +" (CASE WHEN SUM(sl.lY_SALE_ytd_JUL) <>0  THEN "
					      +" ROUND( (SUM(sl.CY_SALE_ytd_JUL) -SUM(sl.lY_SALE_ytd_JUL)) "
					      +" / SUM(sl.lY_SALE_ytd_JUL) *100 ,1) "
					      +" ELSE ROUND(0*100,1) END) AS ytdgr "
					      +" FROM SM_SALES_SUMM_WIDE sl, sales_item, SM_SALES_BRAND_MST brnd "
					      +" WHERE trim(Sl.fin_year)= (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
					      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
					      +" AND Sl.item_code= sales_item.item_code "
					      +" AND brnd.brand_code(+) = sales_item.item_sub_group "
					      +" AND brnd.div_code(+) = sales_item.item_ser "
					      +" AND brnd.fin_year(+) = (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
					      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
					      +" AND sales_item.item_sub_group NOT IN ('CU','BJ') "	
					      +" AND TO_NUMBER(SUBSTR(sl.fin_year,1,4)||'07') <= TO_NUMBER('"+month+"') "
					      +" UNION ALL "
					      +" SELECT  5 AS mnno, 'AUG' AS mth, " 
					      +" ROUND(SUM(sl.CY_SALE_MTH_AUG)/100000,2) AS mthcysl, "
					      +" ROUND(SUM(sl.CY_SALE_YTD_AUG)/100000,2) AS ytdcysl, "
					      +" (CASE WHEN SUM(sl.FLD_TRGT_MTH_AUG) <>0 THEN "
					      +" ROUND( SUM(sl.CY_SALE_MTH_AUG) " 
					      +" / SUM(sl.FLD_TRGT_MTH_AUG * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) "
					      +" * 100 ,1) " 
					      +" ELSE ROUND(0*100,1) END) AS mthach, "
					      +" (CASE WHEN SUM(sl.FLD_TRGT_YTD_AUG) <>0 THEN "
					      +" ROUND( SUM(sl.CY_SALE_YTD_AUG) " 
					      +" / SUM(sl.FLD_TRGT_YTD_AUG * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) "
					      +" * 100 ,1) " 
					      +" ELSE ROUND(0*100,1) END) AS ytdach, "
					      +" (CASE WHEN SUM(sl.lY_SALE_MTH_AUG) <>0  THEN "
					      +" ROUND( (SUM(sl.CY_SALE_MTH_AUG) -SUM(sl.lY_SALE_MTH_AUG)) "
					      +" / SUM(sl.lY_SALE_MTH_AUG) *100 ,1) "
					      +" ELSE ROUND(0*100,1) END) AS mthgr, "
					      +" (CASE WHEN SUM(sl.lY_SALE_ytd_AUG) <>0  THEN "
					      +" ROUND( (SUM(sl.CY_SALE_ytd_AUG) -SUM(sl.lY_SALE_ytd_AUG)) "
					      +" / SUM(sl.lY_SALE_ytd_AUG) *100 ,1) "
					      +" ELSE ROUND(0*100,1) END) AS ytdgr "
					      +" FROM SM_SALES_SUMM_WIDE sl, sales_item, SM_SALES_BRAND_MST brnd "
					      +" WHERE trim(Sl.fin_year)= (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
					      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
					      +" AND Sl.item_code= sales_item.item_code "
					      +" AND brnd.brand_code(+) = sales_item.item_sub_group "
					      +" AND brnd.div_code(+) = sales_item.item_ser "
					      +" AND brnd.fin_year(+) = (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
					      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
					      +" AND sales_item.item_sub_group NOT IN ('CU','BJ') "	
					      +" AND TO_NUMBER(SUBSTR(sl.fin_year,1,4)||'08') <= TO_NUMBER('"+month+"') "
					      +" UNION ALL "
					      +" SELECT  6 AS mnno, 'SEP' AS mth, " 
					      +" ROUND(SUM(sl.CY_SALE_MTH_SEP)/100000,2) AS mthcysl, "
					      +" ROUND(SUM(sl.CY_SALE_YTD_SEP)/100000,2) AS ytdcysl, "
					      +" (CASE WHEN SUM(sl.FLD_TRGT_MTH_SEP) <>0 THEN "
					      +" ROUND( SUM(sl.CY_SALE_MTH_SEP) " 
					      +" / SUM(sl.FLD_TRGT_MTH_SEP * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) "
					      +" * 100 ,1) " 
					      +" ELSE ROUND(0*100,1) END) AS mthach, "
					      +" (CASE WHEN SUM(sl.FLD_TRGT_YTD_SEP) <>0 THEN "
					      +" ROUND( SUM(sl.CY_SALE_YTD_SEP) " 
					      +" / SUM(sl.FLD_TRGT_YTD_SEP * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) "
					      +" * 100 ,1) " 
					      +" ELSE ROUND(0*100,1) END) AS ytdach, "
					      +" (CASE WHEN SUM(sl.lY_SALE_MTH_SEP) <>0  THEN "
					      +" ROUND( (SUM(sl.CY_SALE_MTH_SEP) -SUM(sl.lY_SALE_MTH_SEP)) "
					      +" / SUM(sl.lY_SALE_MTH_SEP) *100 ,1) "
					      +" ELSE ROUND(0*100,1) END) AS mthgr, "
					      +" (CASE WHEN SUM(sl.lY_SALE_ytd_SEP) <>0  THEN "
					      +" ROUND( (SUM(sl.CY_SALE_ytd_SEP) -SUM(sl.lY_SALE_ytd_SEP)) "
					      +" / SUM(sl.lY_SALE_ytd_SEP) *100 ,1) "
					      +" ELSE ROUND(0*100,1) END) AS ytdgr "
					      +" FROM SM_SALES_SUMM_WIDE sl, sales_item, SM_SALES_BRAND_MST brnd "
					      +" WHERE trim(Sl.fin_year)= (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
					      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
					      +" AND Sl.item_code= sales_item.item_code "
					      +" AND brnd.brand_code(+) = sales_item.item_sub_group "
					      +" AND brnd.div_code(+) = sales_item.item_ser "
					      +" AND brnd.fin_year(+) = (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
					      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
					      +" AND sales_item.item_sub_group NOT IN ('CU','BJ') "	
					      +" AND TO_NUMBER(SUBSTR(sl.fin_year,1,4)||'09') <= TO_NUMBER('"+month+"') "
					      +" UNION ALL "
					      +" SELECT  7 AS mnno, 'OCT' AS mth, " 
					      +" ROUND(SUM(sl.CY_SALE_MTH_OCT)/100000,2) AS mthcysl, "
					      +" ROUND(SUM(sl.CY_SALE_YTD_OCT)/100000,2) AS ytdcysl, "
					      +" (CASE WHEN SUM(sl.FLD_TRGT_MTH_OCT) <>0 THEN "
					      +" ROUND( SUM(sl.CY_SALE_MTH_OCT) " 
					      +" / SUM(sl.FLD_TRGT_MTH_OCT * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) "
					      +" * 100 ,1) " 
					      +" ELSE ROUND(0*100,1) END) AS mthach, "
					      +" (CASE WHEN SUM(sl.FLD_TRGT_YTD_OCT) <>0 THEN "
					      +" ROUND( SUM(sl.CY_SALE_YTD_OCT) " 
					      +" / SUM(sl.FLD_TRGT_YTD_OCT * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) "
					      +" * 100 ,1) " 
					      +" ELSE ROUND(0*100,1) END) AS ytdach, "
					      +" (CASE WHEN SUM(sl.lY_SALE_MTH_OCT) <>0  THEN "
					      +" ROUND( (SUM(sl.CY_SALE_MTH_OCT) -SUM(sl.lY_SALE_MTH_OCT)) "
					      +" / SUM(sl.lY_SALE_MTH_OCT) *100 ,1) "
					      +" ELSE ROUND(0*100,1) END) AS mthgr, "
					      +" (CASE WHEN SUM(sl.lY_SALE_ytd_OCT) <>0  THEN "
					      +" ROUND( (SUM(sl.CY_SALE_ytd_OCT) -SUM(sl.lY_SALE_ytd_OCT)) "
					      +" / SUM(sl.lY_SALE_ytd_OCT) *100 ,1) "
					      +" ELSE ROUND(0*100,1) END) AS ytdgr "
					      +" FROM SM_SALES_SUMM_WIDE sl, sales_item, SM_SALES_BRAND_MST brnd "
					      +" WHERE trim(Sl.fin_year)= (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
					      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
					      +" AND Sl.item_code= sales_item.item_code "
					      +" AND brnd.brand_code(+) = sales_item.item_sub_group "
					      +" AND brnd.div_code(+) = sales_item.item_ser "
					      +" AND brnd.fin_year(+) = (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
					      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
					      +" AND sales_item.item_sub_group NOT IN ('CU','BJ') "	
					      +" AND TO_NUMBER(SUBSTR(sl.fin_year,1,4)||'10') <= TO_NUMBER('"+month+"') "
					      +" UNION ALL "
					      +" SELECT  8 AS mnno, 'NOV' AS mth, " 
					      +" ROUND(SUM(sl.CY_SALE_MTH_NOV)/100000,2) AS mthcysl, "
					      +" ROUND(SUM(sl.CY_SALE_YTD_NOV)/100000,2) AS ytdcysl, "
					      +" (CASE WHEN SUM(sl.FLD_TRGT_MTH_NOV) <>0 THEN "
					      +" ROUND( SUM(sl.CY_SALE_MTH_NOV) " 
					      +" / SUM(sl.FLD_TRGT_MTH_NOV * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) "
					      +" * 100 ,1) " 
					      +" ELSE ROUND(0*100,1) END) AS mthach, "
					      +" (CASE WHEN SUM(sl.FLD_TRGT_YTD_NOV) <>0 THEN "
					      +" ROUND( SUM(sl.CY_SALE_YTD_NOV) " 
					      +" / SUM(sl.FLD_TRGT_YTD_NOV * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) "
					      +" * 100 ,1) " 
					      +" ELSE ROUND(0*100,1) END) AS ytdach, "
					      +" (CASE WHEN SUM(sl.lY_SALE_MTH_NOV) <>0  THEN " 
					      +" ROUND( (SUM(sl.CY_SALE_MTH_NOV) -SUM(sl.lY_SALE_MTH_NOV)) "
					      +" / SUM(sl.lY_SALE_MTH_NOV) *100 ,1) "
					      +" ELSE ROUND(0*100,1) END) AS mthgr, "
					      +" (CASE WHEN SUM(sl.lY_SALE_ytd_NOV) <>0  THEN "
					      +" ROUND( (SUM(sl.CY_SALE_ytd_NOV) -SUM(sl.lY_SALE_ytd_NOV)) "
					      +" / SUM(sl.lY_SALE_ytd_NOV) *100 ,1) "
					      +" ELSE ROUND(0*100,1) END) AS ytdgr "
					      +" FROM SM_SALES_SUMM_WIDE sl, sales_item, SM_SALES_BRAND_MST brnd "
					      +" WHERE trim(Sl.fin_year)= (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
					      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
					      +" AND Sl.item_code= sales_item.item_code "
					      +" AND brnd.brand_code(+) = sales_item.item_sub_group "
					      +" AND brnd.div_code(+) = sales_item.item_ser "
					      +" AND brnd.fin_year(+) = (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
					      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
					      +" AND sales_item.item_sub_group NOT IN ('CU','BJ') "	
					      +" AND TO_NUMBER(SUBSTR(sl.fin_year,1,4)||'11') <= TO_NUMBER('"+month+"') "
					      +" UNION ALL "
					      +" SELECT  9 AS mnno, 'DEC' AS mth, " 
					      +" ROUND(SUM(sl.CY_SALE_MTH_DEC)/100000,2) AS mthcysl, "
					      +" ROUND(SUM(sl.CY_SALE_YTD_DEC)/100000,2) AS ytdcysl, "
					      +" (CASE WHEN SUM(sl.FLD_TRGT_MTH_DEC) <>0 THEN "
					      +" ROUND( SUM(sl.CY_SALE_MTH_DEC) " 
					      +" / SUM(sl.FLD_TRGT_MTH_DEC * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) "
					      +" * 100 ,1) " 
					      +" ELSE ROUND(0*100,1) END) AS mthach, "
					      +" (CASE WHEN SUM(sl.FLD_TRGT_YTD_DEC) <>0 THEN "
					      +" ROUND( SUM(sl.CY_SALE_YTD_DEC) " 
					      +" / SUM(sl.FLD_TRGT_YTD_DEC * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) "
					      +" * 100 ,1) " 
					      +" ELSE ROUND(0*100,1) END) AS ytdach, "
					      +" (CASE WHEN SUM(sl.lY_SALE_MTH_DEC) <>0  THEN "
					      +" ROUND( (SUM(sl.CY_SALE_MTH_DEC) -SUM(sl.lY_SALE_MTH_DEC)) "
					      +" / SUM(sl.lY_SALE_MTH_DEC) *100 ,1) "
					      +" ELSE ROUND(0*100,1) END) AS mthgr, "
					      +" (CASE WHEN SUM(sl.lY_SALE_ytd_DEC) <>0  THEN "
					      +" ROUND( (SUM(sl.CY_SALE_ytd_DEC) -SUM(sl.lY_SALE_ytd_DEC)) "
					      +" / SUM(sl.lY_SALE_ytd_DEC) *100 ,1) "
					      +" ELSE ROUND(0*100,1) END) AS ytdgr "
					      +" FROM SM_SALES_SUMM_WIDE sl, sales_item, SM_SALES_BRAND_MST brnd "
					      +" WHERE trim(Sl.fin_year)= (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
					      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
					      +" AND Sl.item_code= sales_item.item_code "
					      +" AND brnd.brand_code(+) = sales_item.item_sub_group "
					      +" AND brnd.div_code(+) = sales_item.item_ser " 
					      +" AND brnd.fin_year(+) = (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
					      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
					      +" AND sales_item.item_sub_group NOT IN ('CU','BJ') "	
					      +" AND TO_NUMBER(SUBSTR(sl.fin_year,1,4)||'12') <= TO_NUMBER('"+month+"') "
					      +" UNION ALL "
					      +" SELECT  10 AS mnno, 'JAN' AS mth, " 
					      +" ROUND(SUM(sl.CY_SALE_MTH_JAN)/100000,2) AS mthcysl, "
					      +" ROUND(SUM(sl.CY_SALE_YTD_JAN)/100000,2) AS ytdcysl, "
					      +" (CASE WHEN SUM(sl.FLD_TRGT_MTH_JAN) <>0 THEN "
					      +" ROUND( SUM(sl.CY_SALE_MTH_JAN) " 
					      +" / SUM(sl.FLD_TRGT_MTH_JAN * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) "
					      +" * 100 ,1)  "
					      +" ELSE ROUND(0*100,1) END) AS mthach, "
					      +" (CASE WHEN SUM(sl.FLD_TRGT_YTD_JAN) <>0 THEN "
					      +" ROUND( SUM(sl.CY_SALE_YTD_JAN) " 
					      +" / SUM(sl.FLD_TRGT_YTD_JAN * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) "
					      +" * 100 ,1) " 
					      +" ELSE ROUND(0*100,1) END) AS ytdach, "
					      +" (CASE WHEN SUM(sl.lY_SALE_MTH_JAN) <>0  THEN "
					      +" ROUND( (SUM(sl.CY_SALE_MTH_JAN) -SUM(sl.lY_SALE_MTH_JAN)) "
					      +" / SUM(sl.lY_SALE_MTH_JAN) *100 ,1) " 
					      +" ELSE ROUND(0*100,1) END) AS mthgr, "
					      +" (CASE WHEN SUM(sl.lY_SALE_ytd_JAN) <>0  THEN "
					      +" ROUND( (SUM(sl.CY_SALE_ytd_JAN) -SUM(sl.lY_SALE_ytd_JAN)) " 
					      +" / SUM(sl.lY_SALE_ytd_JAN) *100 ,1) "
					      +" ELSE ROUND(0*100,1) END) AS ytdgr "
					      +" FROM SM_SALES_SUMM_WIDE sl, sales_item, SM_SALES_BRAND_MST brnd "
					      +" WHERE trim(Sl.fin_year)= (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
					      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
					      +" AND Sl.item_code= sales_item.item_code "
					      +" AND brnd.brand_code(+) = sales_item.item_sub_group "
					      +" AND brnd.div_code(+) = sales_item.item_ser "
					      +" AND brnd.fin_year(+) = (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
					      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
					      +" AND sales_item.item_sub_group NOT IN ('CU','BJ')	 "
					      +" AND TO_NUMBER(SUBSTR(sl.fin_year,1,2)||SUBSTR(sl.fin_year,6,2)||'01') <= TO_NUMBER('"+month+"') "
					      +" UNION ALL "
					      +" SELECT  11 AS mnno, 'FEB' AS mth, " 
					      +" ROUND(SUM(sl.CY_SALE_MTH_FEB)/100000,2) AS mthcysl, "
					      +" ROUND(SUM(sl.CY_SALE_YTD_FEB)/100000,2) AS ytdcysl, "
					      +" (CASE WHEN SUM(sl.FLD_TRGT_MTH_FEB) <>0 THEN "
					      +" ROUND( SUM(sl.CY_SALE_MTH_FEB) " 
					      +" / SUM(sl.FLD_TRGT_MTH_FEB * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) "
					      +" * 100 ,1) " 
					      +" ELSE ROUND(0*100,1) END) AS mthach, " 
					      +" (CASE WHEN SUM(sl.FLD_TRGT_YTD_FEB) <>0 THEN "
					      +" ROUND( SUM(sl.CY_SALE_YTD_FEB) " 
					      +" / SUM(sl.FLD_TRGT_YTD_FEB * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) "
					      +" * 100 ,1) " 
					      +" ELSE ROUND(0*100,1) END) AS ytdach, "
					      +" (CASE WHEN SUM(sl.lY_SALE_MTH_FEB) <>0  THEN "
					      +" ROUND( (SUM(sl.CY_SALE_MTH_FEB) -SUM(sl.lY_SALE_MTH_FEB)) "
					      +" / SUM(sl.lY_SALE_MTH_FEB) *100 ,1) "
					      +" ELSE ROUND(0*100,1) END) AS mthgr, "
					      +" (CASE WHEN SUM(sl.lY_SALE_ytd_FEB) <>0  THEN "
					      +" ROUND( (SUM(sl.CY_SALE_ytd_FEB) -SUM(sl.lY_SALE_ytd_FEB)) "
					      +" / SUM(sl.lY_SALE_ytd_FEB) *100 ,1) "
					      +" ELSE ROUND(0*100,1) END) AS ytdgr "
					      +" FROM SM_SALES_SUMM_WIDE sl, sales_item, SM_SALES_BRAND_MST brnd "
					      +" WHERE trim(Sl.fin_year)= (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
					      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
					      +" AND Sl.item_code= sales_item.item_code "
					      +" AND brnd.brand_code(+) = sales_item.item_sub_group "
					      +" AND brnd.div_code(+) = sales_item.item_ser " 
					      +" AND brnd.fin_year(+) = (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
					      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
					      +" AND sales_item.item_sub_group NOT IN ('CU','BJ') "	
					      +" AND TO_NUMBER(SUBSTR(sl.fin_year,1,2)||SUBSTR(sl.fin_year,6,2)||'02') <= TO_NUMBER('"+month+"') "
					      +" UNION ALL "
					      +" SELECT  12 AS mnno, 'MAR' AS mth, " 
					      +" ROUND(SUM(sl.CY_SALE_MTH_MAR)/100000,2) AS mthcysl, " 
					      +" ROUND(SUM(sl.CY_SALE_YTD_MAR)/100000,2) AS ytdcysl, "
					      +" (CASE WHEN SUM(sl.FLD_TRGT_MTH_MAR) <>0 THEN "
					      +" ROUND( SUM(sl.CY_SALE_MTH_MAR) " 
					      +" / SUM(sl.FLD_TRGT_MTH_MAR * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) "
					      +" * 100 ,1) " 
					      +" ELSE ROUND(0*100,1) END) AS mthach, "
					      +" (CASE WHEN SUM(sl.FLD_TRGT_YTD_MAR) <>0 THEN "
					      +" ROUND( SUM(sl.CY_SALE_YTD_MAR) " 
					      +" / SUM(sl.FLD_TRGT_YTD_MAR * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) "
					      +" * 100 ,1) " 
					      +" ELSE ROUND(0*100,1) END) AS ytdach, "
					      +" (CASE WHEN SUM(sl.lY_SALE_MTH_MAR) <>0  THEN "
					      +" ROUND( (SUM(sl.CY_SALE_MTH_MAR) -SUM(sl.lY_SALE_MTH_MAR)) " 
					      +" / SUM(sl.lY_SALE_MTH_MAR) *100 ,1) "
					      +" ELSE ROUND(0*100,1) END) AS mthgr, " 
					      +" (CASE WHEN SUM(sl.lY_SALE_ytd_MAR) <>0  THEN "
					      +" ROUND( (SUM(sl.CY_SALE_ytd_MAR) -SUM(sl.lY_SALE_ytd_MAR)) "
					      +" / SUM(sl.lY_SALE_ytd_MAR) *100 ,1) "
					      +" ELSE ROUND(0*100,1) END) AS ytdgr "
					      +" FROM SM_SALES_SUMM_WIDE sl, sales_item, SM_SALES_BRAND_MST brnd "
					      +" WHERE trim(Sl.fin_year)= (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
					      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
					      +" AND Sl.item_code= sales_item.item_code "
					      +" AND brnd.brand_code(+) = sales_item.item_sub_group "
					      +" AND brnd.div_code(+) = sales_item.item_ser "
					      +" 					    AND brnd.fin_year(+) = (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
					      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
					      +" AND sales_item.item_sub_group NOT IN ('CU','BJ') AND TO_NUMBER(SUBSTR(sl.fin_year,1,2)||SUBSTR(sl.fin_year,6,2)||'03') <= TO_NUMBER('"+month+"') "
					      +" ) GROUP BY mnno,mth,mthcysl,ytdcysl,mthach,ytdach,mthgr,ytdgr HAVING ytdcysl<>0 OR ytdach<>0 OR ytdgr<>0 ORDER BY mnno"; 
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
								
				rowData = new JSONObject();
				rowData.put("month", rs.getString("mth"));
				rowData.put("sales", rs.getString("mthcysl"));
				rowData.put("ho_per", rs.getString("mthach"));
				rowData.put("gr_per", rs.getString("mthgr"));
				rawDataJson.put(count, rowData);
				count++;
				

			}
		}

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :SalesPersonSales:getSalesGraphData():" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		System.out.println("rawDataJson is =" + rawDataJson);

		return rawDataJson;
	}

	/*** End of method getSalesGraphData() ***/

	/*** 
	 * Method Name      : getProfitGraphData(String dataSourceName, String month)
	 * Servlet Name     : SalesPerfrmncProfitGraphServlet
	 * Metadataxml Name : expensedashboard.xml
	 * Description      : This method returns  raw data for rendering the 4 Expense-Profit graph. 
	 * Graph Caption    :
	 *     					1. FY-India BU Profit Monthly Graph
	 *    					2. FY-India BU Expense Monthly Graph
	 *   	 				3. FY-India BU Profit YTD Graph
	 *    					4. FY-India BU Profit YTD Graph
	 * ***/
	@SuppressWarnings("unchecked")
	public JSONObject getProfitGraphData(String dataSourceName, String month) throws RemoteException, ITMException
	{
		JSONObject rawDataJson = new JSONObject();
		JSONObject rowData     = null;
		String sql             = "";
        String finYear         = "";
		ResultSet rs           = null;
		PreparedStatement pstmt = null;
		Connection conn        = null;
		try
		{
			/*conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;*/
			/*add new code for connection DB on dated:15062016 by Nikhil*/
			conn = getConnection();
			int count=0;
			if(month!=null && month.trim().length()>0)
			{
			    System.out.println("Comming  month inside getProfitGraphData ==="+month);	
				String selectedMonth  = month.substring(4, 6);
				if(selectedMonth.trim().equalsIgnoreCase("01") ||selectedMonth.trim().equalsIgnoreCase("02") ||selectedMonth.trim().equalsIgnoreCase("03"))
				{
			    	finYear = String.valueOf(Integer.parseInt(month.substring(0, 4))-1)+"-"+month.substring(2, 4);
				}
				else
				{
					finYear = month.substring(0, 4)+"-"+ (String.valueOf(Integer.parseInt(month.substring(0, 4))+1)).substring(2, 4);
				}
			 System.out.println("updates month and year from dcoding in getProfitGraphData =="+month+"finYear =="+finYear);			
			sql="SELECT mnno,mth,round(mthexp/100,1) as mthexp,round(ytdexp/100,1) as ytdexp,round(mthpft/100,1) as mthpft,round(ytdpft/100,1) as ytdpft, "
			      +" (CASE WHEN mthexp_per_sl<-200 THEN -200 WHEN mthexp_per_sl >200 THEN 200 ELSE mthexp_per_sl END) AS mthexp_per_sl, "
			      +" (CASE WHEN ytdexp_per_sl<-200 THEN -200 WHEN ytdexp_per_sl >200 THEN 200 ELSE ytdexp_per_sl END) AS ytdexp_per_sl, "
			      +" (CASE WHEN mthexp_bud<-200 THEN -200 WHEN mthexp_bud >200 THEN 200 ELSE mthexp_bud END) AS mthexp_bud, "
			      +" (CASE WHEN ytdexp_bud<-200 THEN -200 WHEN ytdexp_bud >200 THEN 200 ELSE ytdexp_bud END) AS ytdexp_bud, "
			      +" (CASE WHEN mthpft_per_sl<-200 THEN -200 WHEN mthpft_per_sl >200 THEN 200 ELSE mthpft_per_sl END) AS mthpft_per_sl, "
			      +" (CASE WHEN ytdpft_per_sl<-200 THEN -200 WHEN ytdpft_per_sl >200 THEN 200 ELSE ytdpft_per_sl END) AS ytdpft_per_sl, "
			      +" (CASE WHEN mthpft_bud<-200 THEN -200 WHEN mthpft_bud >200 THEN 200 ELSE mthpft_bud END) AS mthpft_bud, "
			      +" (CASE WHEN ytdpft_bud<-200 THEN -200 WHEN ytdpft_bud >200 THEN 200 ELSE ytdpft_bud END) AS ytdpft_bud "
			      +" FROM( "
			      +" SELECT 1 AS mnno, 'APR' AS mth, " 
			      +" SUM(NVL(EXPENSE_MTH_APR,0)) AS mthexp, "
			      +" SUM(NVL(EXPENSE_ytd_APR,0)) AS ytdexp, "
			      +" ROUND(SUM(CY_SALE_MTH_apr)/100000,2) - SUM(NVL(COGS_MTH_APR,0)+NVL(EXPENSE_MTH_APR,0)) AS mthpft, "
			      +" ROUND(SUM(CY_SALE_YTD_apr)/100000,2) - SUM(NVL(COGS_YTD_APR,0)+NVL(EXPENSE_YTD_APR,0)) AS ytdpft, "
			      +" ( CASE WHEN SUM(CY_SALE_MTH_apr)=0 THEN 200 "  
			      +" ELSE  ROUND( SUM(NVL(EXPENSE_MTH_APR,0)) *100000 /SUM(CY_SALE_MTH_apr) * 100, 2) END ) AS mthexp_per_sl, "
			      +" ( CASE WHEN SUM(CY_SALE_ytd_apr)=0 THEN 200 "  
			      +" ELSE  ROUND( SUM(NVL(EXPENSE_YTD_APR,0)) *100000 /SUM(CY_SALE_YTD_apr) * 100, 2) END ) AS ytdexp_per_sl, "
			      +" (CASE WHEN SUM(trn.FLD_TRGT_MTH_apr) <>0 THEN "
			      +" ROUND( SUM(NVL(mst.BUD_EXP_apr,0))*1000 " 
			      +" / SUM(trn.FLD_TRGT_MTH_apr * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
			      +" ELSE ROUND(2*100,1) END) AS mthexp_bud, "
			      +" (CASE WHEN SUM(trn.FLD_TRGT_YTD_apr) <>0 THEN "
			      +" ROUND( SUM(NVL(mst.BUD_EXP_apr,0))*1000 " 
			      +" / SUM(trn.FLD_TRGT_YTD_apr * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
			      +" ELSE ROUND(2*100,1) END) AS ytdexp_bud, "
			      +" ( CASE WHEN SUM(CY_SALE_MTH_apr)=0 THEN -200 "  
			      +" ELSE  ROUND(  ( SUM(CY_SALE_MTH_apr) - (SUM( NVL(COGS_MTH_APR,0)+NVL(EXPENSE_MTH_APR,0) )*100000)  )/SUM(CY_SALE_MTH_apr) "
			      +" * 100, 2) END ) AS mthpft_per_sl, "
			      +" ( CASE WHEN SUM(CY_SALE_YTD_apr)=0 THEN -200 "  
			      +" ELSE  ROUND(  ( SUM(CY_SALE_YTD_apr) - (SUM( NVL(COGS_YTD_APR,0)+NVL(EXPENSE_YTD_APR,0) )*100000)  )/SUM(CY_SALE_YTD_apr) "
			      +" * 100, 2) END ) AS ytdpft_per_sl, "
			      +" (CASE WHEN SUM(trn.FLD_TRGT_MTH_apr) <>0 THEN "
			      +" ROUND( SUM(NVL(mst.BUD_PFT_apr,0))*1000 " 
			      +" / SUM(trn.FLD_TRGT_MTH_apr * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
			      +" ELSE ROUND(-2*100,1) END) AS mthpft_bud, "
			      +" (CASE WHEN SUM(trn.FLD_TRGT_YTD_apr) <>0 THEN "
			      +" ROUND( SUM(NVL(mst.BUD_PFT_apr,0))*1000 " 
			      +" / SUM(trn.FLD_TRGT_YTD_apr * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
			      +" ELSE ROUND(-2*100,1) END) AS ytdpft_bud "
			      +" FROM SM_SALES_DIV_MST mst, SM_SALES_SUMM_WIDE trn, sales_item, SM_SALES_BRAND_MST brnd "
			      +" WHERE trim(trn.fin_year)= (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
			      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
			      +" AND trn.fin_year=mst.fin_year "
			      +" AND trn.item_ser=mst.div_code "
			      +" AND trn.item_code= sales_item.item_code "
			      +" AND brnd.brand_code(+) = sales_item.item_sub_group "
			      +" AND brnd.div_code(+) = sales_item.item_ser "
			      +" AND brnd.fin_year(+) = (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
			      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
			      +" AND sales_item.item_sub_group NOT IN ('CU','BJ') " 
			      +" AND TO_NUMBER(SUBSTR(trn.fin_year,1,4)||'04') <= TO_NUMBER('"+month+"') "
			      +" AND '"+month+"' ='"+month+"'"	
			      +" UNION ALL "
			      +" SELECT 2 AS mnno, 'MAY' AS mth,  "
			      +" SUM(NVL(EXPENSE_MTH_MAY,0)) AS mthexp, "
			      +" SUM(NVL(EXPENSE_ytd_MAY,0)) AS ytdexp, "
			      +" ROUND(SUM(CY_SALE_MTH_MAY)/100000,2) - SUM(NVL(COGS_MTH_MAY,0)+NVL(EXPENSE_MTH_MAY,0)) AS mthpft, "
			      +" ROUND(SUM(CY_SALE_YTD_MAY)/100000,2) - SUM(NVL(COGS_YTD_MAY,0)+NVL(EXPENSE_YTD_MAY,0)) AS ytdpft, "
			      +" ( CASE WHEN SUM(CY_SALE_MTH_MAY)=0 THEN 200 "  
			      +" ELSE  ROUND( SUM(NVL(EXPENSE_MTH_MAY,0)) *100000 /SUM(CY_SALE_MTH_MAY) * 100, 2) END ) AS mthexp_per_sl, " 
			      +" ( CASE WHEN SUM(CY_SALE_ytd_MAY)=0 THEN 200 "  
			      +" ELSE  ROUND( SUM(NVL(EXPENSE_YTD_MAY,0)) *100000 /SUM(CY_SALE_YTD_MAY) * 100, 2) END ) AS ytdexp_per_sl, "
			      +" (CASE WHEN SUM(trn.FLD_TRGT_MTH_MAY) <>0 THEN "
			      +" ROUND( SUM(NVL(mst.BUD_EXP_MAY,0))*1000 " 
			      +" / SUM(trn.FLD_TRGT_MTH_MAY * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
			      +" ELSE ROUND(2*100,1) END) AS mthexp_bud, "
			      +" (CASE WHEN SUM(trn.FLD_TRGT_YTD_MAY) <>0 THEN "
			      +" ROUND( SUM(NVL(mst.BUD_EXP_MAY,0))*1000 " 
			      +" / SUM(trn.FLD_TRGT_YTD_MAY * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
			      +" ELSE ROUND(2*100,1) END) AS ytdexp_bud, "
			      +" ( CASE WHEN SUM(CY_SALE_MTH_MAY)=0 THEN -200 "  
			      +" ELSE  ROUND(  ( SUM(CY_SALE_MTH_MAY) - (SUM( NVL(COGS_MTH_MAY,0)+NVL(EXPENSE_MTH_MAY,0) )*100000)  )/SUM(CY_SALE_MTH_MAY) "
			      +" * 100, 2) END ) AS mthpft_per_sl, "
			      +" ( CASE WHEN SUM(CY_SALE_YTD_MAY)=0 THEN -200 "  
			      +" ELSE  ROUND(  ( SUM(CY_SALE_YTD_MAY) - (SUM( NVL(COGS_YTD_MAY,0)+NVL(EXPENSE_YTD_MAY,0) )*100000)  )/SUM(CY_SALE_YTD_MAY) "
			      +" * 100, 2) END ) AS ytdpft_per_sl, "
			      +" (CASE WHEN SUM(trn.FLD_TRGT_MTH_MAY) <>0 THEN "
			      +" ROUND( SUM(NVL(mst.BUD_PFT_MAY,0))*1000 " 
			      +" / SUM(trn.FLD_TRGT_MTH_MAY * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
			      +" ELSE ROUND(-2*100,1) END) AS mthpft_bud, "
			      +" (CASE WHEN SUM(trn.FLD_TRGT_YTD_MAY) <>0 THEN "
			      +" ROUND( SUM(NVL(mst.BUD_PFT_MAY,0))*1000 " 
			      +" / SUM(trn.FLD_TRGT_YTD_MAY * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
			      +" ELSE ROUND(-2*100,1) END) AS ytdpft_bud "
			      +" FROM SM_SALES_DIV_MST mst, SM_SALES_SUMM_WIDE trn, sales_item, SM_SALES_BRAND_MST brnd "
			      +" WHERE trim(trn.fin_year)= (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
			      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
			      +" AND trn.fin_year=mst.fin_year "
			      +" AND trn.item_ser=mst.div_code "
			      +" AND trn.item_code= sales_item.item_code "
			      +" AND brnd.brand_code(+) = sales_item.item_sub_group "
			      +" AND brnd.div_code(+) = sales_item.item_ser "
			      +" AND brnd.fin_year(+) = (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
			      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
			      +" AND sales_item.item_sub_group NOT IN ('CU','BJ') " 
			      +" AND TO_NUMBER(SUBSTR(trn.fin_year,1,4)||'05') <= TO_NUMBER('"+month+"') "
			      +" UNION ALL "
			      +" SELECT 3 AS mnno, 'JUN' AS mth, " 
			      +" SUM(NVL(EXPENSE_MTH_JUN,0)) AS mthexp, "
			      +" SUM(NVL(EXPENSE_ytd_JUN,0)) AS ytdexp, "
			      +" ROUND(SUM(CY_SALE_MTH_JUN)/100000,2) - SUM(NVL(COGS_MTH_JUN,0)+NVL(EXPENSE_MTH_JUN,0)) AS mthpft, "
			      +" ROUND(SUM(CY_SALE_YTD_JUN)/100000,2) - SUM(NVL(COGS_YTD_JUN,0)+NVL(EXPENSE_YTD_JUN,0)) AS ytdpft, "
			      +" ( CASE WHEN SUM(CY_SALE_MTH_JUN)=0 THEN 200 "  
			      +" ELSE  ROUND( SUM(NVL(EXPENSE_MTH_JUN,0)) *100000 /SUM(CY_SALE_MTH_JUN) * 100, 2) END ) AS mthexp_per_sl, "
			      +" ( CASE WHEN SUM(CY_SALE_ytd_JUN)=0 THEN 200 "  
			      +" ELSE  ROUND( SUM(NVL(EXPENSE_YTD_JUN,0)) *100000 /SUM(CY_SALE_YTD_JUN) * 100, 2) END ) AS ytdexp_per_sl, "
			      +" (CASE WHEN SUM(trn.FLD_TRGT_MTH_JUN) <>0 THEN "
			      +" ROUND( SUM(NVL(mst.BUD_EXP_JUN,0))*1000 " 
			      +" / SUM(trn.FLD_TRGT_MTH_JUN * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
			      +" ELSE ROUND(2*100,1) END) AS mthexp_bud, "
			      +" (CASE WHEN SUM(trn.FLD_TRGT_YTD_JUN) <>0 THEN "
			      +" ROUND( SUM(NVL(mst.BUD_EXP_JUN,0))*1000 " 
			      +" / SUM(trn.FLD_TRGT_YTD_JUN * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
			      +" ELSE ROUND(2*100,1) END) AS ytdexp_bud, "
			      +" ( CASE WHEN SUM(CY_SALE_MTH_JUN)=0 THEN -200 "  
			      +" ELSE  ROUND(  ( SUM(CY_SALE_MTH_JUN) - (SUM( NVL(COGS_MTH_JUN,0)+NVL(EXPENSE_MTH_JUN,0) )*100000)  )/SUM(CY_SALE_MTH_JUN) "
			      +" * 100, 2) END ) AS mthpft_per_sl, "
			      +" ( CASE WHEN SUM(CY_SALE_YTD_JUN)=0 THEN -200 "  
			      +" ELSE  ROUND(  ( SUM(CY_SALE_YTD_JUN) - (SUM( NVL(COGS_YTD_JUN,0)+NVL(EXPENSE_YTD_JUN,0) )*100000)  )/SUM(CY_SALE_YTD_JUN) "
			      +" * 100, 2) END ) AS ytdpft_per_sl, "
			      +" (CASE WHEN SUM(trn.FLD_TRGT_MTH_JUN) <>0 THEN "
			      +" ROUND( SUM(NVL(mst.BUD_PFT_JUN,0))*1000 " 
			      +" / SUM(trn.FLD_TRGT_MTH_JUN * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
			      +" ELSE ROUND(-2*100,1) END) AS mthpft_bud, "
			      +" (CASE WHEN SUM(trn.FLD_TRGT_YTD_JUN) <>0 THEN "
			      +" ROUND( SUM(NVL(mst.BUD_PFT_JUN,0))*1000 " 
			      +" / SUM(trn.FLD_TRGT_YTD_JUN * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
			      +" ELSE ROUND(-2*100,1) END) AS ytdpft_bud "
			      +" FROM SM_SALES_DIV_MST mst, SM_SALES_SUMM_WIDE trn, sales_item, SM_SALES_BRAND_MST brnd "
			      +" WHERE trim(trn.fin_year)= (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
			      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
			      +" AND trn.fin_year=mst.fin_year "
			      +" AND trn.item_ser=mst.div_code "
			      +" AND trn.item_code= sales_item.item_code "
			      +" AND brnd.brand_code(+) = sales_item.item_sub_group "
			      +" AND brnd.div_code(+) = sales_item.item_ser "
			      +" AND brnd.fin_year(+) = (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
			      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
			      +" AND sales_item.item_sub_group NOT IN ('CU','BJ') " 
			      +" AND TO_NUMBER(SUBSTR(trn.fin_year,1,4)||'06') <= TO_NUMBER('"+month+"') "
			      +" UNION ALL "
			      +" SELECT 4 AS mnno, 'JUL' AS mth,  "
			      +" SUM(NVL(EXPENSE_MTH_JUL,0)) AS mthexp, "
			      +" SUM(NVL(EXPENSE_ytd_JUL,0)) AS ytdexp, "
			      +" ROUND(SUM(CY_SALE_MTH_JUL)/100000,2) - SUM(NVL(COGS_MTH_JUL,0)+NVL(EXPENSE_MTH_JUL,0)) AS mthpft, "
			      +" ROUND(SUM(CY_SALE_YTD_JUL)/100000,2) - SUM(NVL(COGS_YTD_JUL,0)+NVL(EXPENSE_YTD_JUL,0)) AS ytdpft, "
			      +" ( CASE WHEN SUM(CY_SALE_MTH_JUL)=0 THEN 200 "  
			      +" ELSE  ROUND( SUM(NVL(EXPENSE_MTH_JUL,0)) *100000 /SUM(CY_SALE_MTH_JUL) * 100, 2) END ) AS mthexp_per_sl, "
			      +" ( CASE WHEN SUM(CY_SALE_ytd_JUL)=0 THEN 200 "  
			      +" ELSE  ROUND( SUM(NVL(EXPENSE_YTD_JUL,0)) *100000 /SUM(CY_SALE_YTD_JUL) * 100, 2) END ) AS ytdexp_per_sl, "
			      +" (CASE WHEN SUM(trn.FLD_TRGT_MTH_JUL) <>0 THEN "
			      +" ROUND( SUM(NVL(mst.BUD_EXP_JUL,0))*1000  "
			      +" / SUM(trn.FLD_TRGT_MTH_JUL * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
			      +" ELSE ROUND(2*100,1) END) AS mthexp_bud, "
			      +" (CASE WHEN SUM(trn.FLD_TRGT_YTD_JUL) <>0 THEN "
			      +" ROUND( SUM(NVL(mst.BUD_EXP_JUL,0))*1000 " 
			      +" / SUM(trn.FLD_TRGT_YTD_JUL * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
			      +" ELSE ROUND(2*100,1) END) AS ytdexp_bud, "
			      +" ( CASE WHEN SUM(CY_SALE_MTH_JUL)=0 THEN -200 "  
			      +" ELSE  ROUND(  ( SUM(CY_SALE_MTH_JUL) - (SUM( NVL(COGS_MTH_JUL,0)+NVL(EXPENSE_MTH_JUL,0) )*100000)  )/SUM(CY_SALE_MTH_JUL) "
			      +" * 100, 2) END ) AS mthpft_per_sl, "
			      +" ( CASE WHEN SUM(CY_SALE_YTD_JUL)=0 THEN -200 "  
			      +" ELSE  ROUND(  ( SUM(CY_SALE_YTD_JUL) - (SUM( NVL(COGS_YTD_JUL,0)+NVL(EXPENSE_YTD_JUL,0) )*100000)  )/SUM(CY_SALE_YTD_JUL) "
			      +" * 100, 2) END ) AS ytdpft_per_sl, "
			      +" (CASE WHEN SUM(trn.FLD_TRGT_MTH_JUL) <>0 THEN "
			      +" ROUND( SUM(NVL(mst.BUD_PFT_JUL,0))*1000 " 
			      +" / SUM(trn.FLD_TRGT_MTH_JUL * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
			      +" ELSE ROUND(-2*100,1) END) AS mthpft_bud, "
			      +" (CASE WHEN SUM(trn.FLD_TRGT_YTD_JUL) <>0 THEN "
			      +" ROUND( SUM(NVL(mst.BUD_PFT_JUL,0))*1000 " 
			      +" / SUM(trn.FLD_TRGT_YTD_JUL * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
			      +" ELSE ROUND(-2*100,1) END) AS ytdpft_bud "
			      +" FROM SM_SALES_DIV_MST mst, SM_SALES_SUMM_WIDE trn, sales_item, SM_SALES_BRAND_MST brnd "
			      +" WHERE trim(trn.fin_year)= (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
			      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
			      +" AND trn.fin_year=mst.fin_year "
			      +" AND trn.item_ser=mst.div_code "
			      +" AND trn.item_code= sales_item.item_code "
			      +" AND brnd.brand_code(+) = sales_item.item_sub_group "
			      +" AND brnd.div_code(+) = sales_item.item_ser "
			      +" AND brnd.fin_year(+) = (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
			      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
			      +" AND sales_item.item_sub_group NOT IN ('CU','BJ') " 
			      +" AND TO_NUMBER(SUBSTR(trn.fin_year,1,4)||'07') <= TO_NUMBER('"+month+"') "
			      +" UNION ALL "
			      +" SELECT 5 AS mnno, 'AUG' AS mth, " 
			      +" SUM(NVL(EXPENSE_MTH_AUG,0)) AS mthexp, "
			      +" SUM(NVL(EXPENSE_ytd_AUG,0)) AS ytdexp, "
			      +" ROUND(SUM(CY_SALE_MTH_AUG)/100000,2) - SUM(NVL(COGS_MTH_AUG,0)+NVL(EXPENSE_MTH_AUG,0)) AS mthpft, "
			      +" ROUND(SUM(CY_SALE_YTD_AUG)/100000,2) - SUM(NVL(COGS_YTD_AUG,0)+NVL(EXPENSE_YTD_AUG,0)) AS ytdpft, "
			      +" ( CASE WHEN SUM(CY_SALE_MTH_AUG)=0 THEN 200 "  
			      +" ELSE  ROUND( SUM(NVL(EXPENSE_MTH_AUG,0)) *100000 /SUM(CY_SALE_MTH_AUG) * 100, 2) END ) AS mthexp_per_sl, "
			      +" ( CASE WHEN SUM(CY_SALE_ytd_AUG)=0 THEN 200 "  
			      +" ELSE  ROUND( SUM(NVL(EXPENSE_YTD_AUG,0)) *100000 /SUM(CY_SALE_YTD_AUG) * 100, 2) END ) AS ytdexp_per_sl, "
			      +" (CASE WHEN SUM(trn.FLD_TRGT_MTH_AUG) <>0 THEN "
			      +" ROUND( SUM(NVL(mst.BUD_EXP_AUG,0))*1000 " 
			      +" / SUM(trn.FLD_TRGT_MTH_AUG * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
			      +" ELSE ROUND(2*100,1) END) AS mthexp_bud, "
			      +" (CASE WHEN SUM(trn.FLD_TRGT_YTD_AUG) <>0 THEN "
			      +" ROUND( SUM(NVL(mst.BUD_EXP_AUG,0))*1000 " 
			      +" / SUM(trn.FLD_TRGT_YTD_AUG * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
			      +" ELSE ROUND(2*100,1) END) AS ytdexp_bud, "
			      +" ( CASE WHEN SUM(CY_SALE_MTH_AUG)=0 THEN -200 "  
			      +" ELSE  ROUND(  ( SUM(CY_SALE_MTH_AUG) - (SUM( NVL(COGS_MTH_AUG,0)+NVL(EXPENSE_MTH_AUG,0) )*100000)  )/SUM(CY_SALE_MTH_AUG) "
			      +" * 100, 2) END ) AS mthpft_per_sl, "
			      +" ( CASE WHEN SUM(CY_SALE_YTD_AUG)=0 THEN -200 "  
			      +" ELSE  ROUND(  ( SUM(CY_SALE_YTD_AUG) - (SUM( NVL(COGS_YTD_AUG,0)+NVL(EXPENSE_YTD_AUG,0) )*100000)  )/SUM(CY_SALE_YTD_AUG) "
			      +" * 100, 2) END ) AS ytdpft_per_sl, "
			      +" (CASE WHEN SUM(trn.FLD_TRGT_MTH_AUG) <>0 THEN "
			      +" ROUND( SUM(NVL(mst.BUD_PFT_AUG,0))*1000 " 
			      +" / SUM(trn.FLD_TRGT_MTH_AUG * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
			      +" ELSE ROUND(-2*100,1) END) AS mthpft_bud, "
			      +" (CASE WHEN SUM(trn.FLD_TRGT_YTD_AUG) <>0 THEN "
			      +" ROUND( SUM(NVL(mst.BUD_PFT_AUG,0))*1000 " 
			      +" / SUM(trn.FLD_TRGT_YTD_AUG * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
			      +" ELSE ROUND(-2*100,1) END) AS ytdpft_bud "
			      +" FROM SM_SALES_DIV_MST mst, SM_SALES_SUMM_WIDE trn, sales_item, SM_SALES_BRAND_MST brnd "
			      +" WHERE trim(trn.fin_year)= (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
			      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
			      +" AND trn.fin_year=mst.fin_year "
			      +" AND trn.item_ser=mst.div_code "
			      +" AND trn.item_code= sales_item.item_code "
			      +" AND brnd.brand_code(+) = sales_item.item_sub_group "
			      +" AND brnd.div_code(+) = sales_item.item_ser "
			      +" AND brnd.fin_year(+) = (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
			      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
			      +" AND sales_item.item_sub_group NOT IN ('CU','BJ') " 
			      +" AND TO_NUMBER(SUBSTR(trn.fin_year,1,4)||'08') <= TO_NUMBER('"+month+"') "
			      +" UNION ALL "
			      +" SELECT 6 AS mnno, 'SEP' AS mth, " 
			      +" SUM(NVL(EXPENSE_MTH_SEP,0)) AS mthexp, "
			      +" SUM(NVL(EXPENSE_ytd_SEP,0)) AS ytdexp, "
			      +" ROUND(SUM(CY_SALE_MTH_SEP)/100000,2) - SUM(NVL(COGS_MTH_SEP,0)+NVL(EXPENSE_MTH_SEP,0)) AS mthpft, "
			      +" ROUND(SUM(CY_SALE_YTD_SEP)/100000,2) - SUM(NVL(COGS_YTD_SEP,0)+NVL(EXPENSE_YTD_SEP,0)) AS ytdpft, "
			      +" ( CASE WHEN SUM(CY_SALE_MTH_SEP)=0 THEN 200 "  
			      +" ELSE  ROUND( SUM(NVL(EXPENSE_MTH_SEP,0)) *100000 /SUM(CY_SALE_MTH_SEP) * 100, 2) END ) AS mthexp_per_sl, "
			      +" ( CASE WHEN SUM(CY_SALE_ytd_SEP)=0 THEN 200 "  
			      +" ELSE  ROUND( SUM(NVL(EXPENSE_YTD_SEP,0)) *100000 /SUM(CY_SALE_YTD_SEP) * 100, 2) END ) AS ytdexp_per_sl, "
			      +" (CASE WHEN SUM(trn.FLD_TRGT_MTH_SEP) <>0 THEN "
			      +" ROUND( SUM(NVL(mst.BUD_EXP_SEP,0))*1000 " 
			      +" / SUM(trn.FLD_TRGT_MTH_SEP * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
			      +" ELSE ROUND(2*100,1) END) AS mthexp_bud, "
			      +" (CASE WHEN SUM(trn.FLD_TRGT_YTD_SEP) <>0 THEN "
			      +" ROUND( SUM(NVL(mst.BUD_EXP_SEP,0))*1000 " 
			      +" / SUM(trn.FLD_TRGT_YTD_SEP * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
			      +" ELSE ROUND(2*100,1) END) AS ytdexp_bud, "
			      +" ( CASE WHEN SUM(CY_SALE_MTH_SEP)=0 THEN -200 "  
			      +" ELSE  ROUND(  ( SUM(CY_SALE_MTH_SEP) - (SUM( NVL(COGS_MTH_SEP,0)+NVL(EXPENSE_MTH_SEP,0) )*100000)  )/SUM(CY_SALE_MTH_SEP) "
			      +" * 100, 2) END ) AS mthpft_per_sl, "
			      +" ( CASE WHEN SUM(CY_SALE_YTD_SEP)=0 THEN -200 "  
			      +" ELSE  ROUND(  ( SUM(CY_SALE_YTD_SEP) - (SUM( NVL(COGS_YTD_SEP,0)+NVL(EXPENSE_YTD_SEP,0) )*100000)  )/SUM(CY_SALE_YTD_SEP) "
			      +" * 100, 2) END ) AS ytdpft_per_sl, "
			      +" (CASE WHEN SUM(trn.FLD_TRGT_MTH_SEP) <>0 THEN "
			      +" ROUND( SUM(NVL(mst.BUD_PFT_SEP,0))*1000 " 
			      +" / SUM(trn.FLD_TRGT_MTH_SEP * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
			      +" ELSE ROUND(-2*100,1) END) AS mthpft_bud, "
			      +" (CASE WHEN SUM(trn.FLD_TRGT_YTD_SEP) <>0 THEN "
			      +" ROUND( SUM(NVL(mst.BUD_PFT_SEP,0))*1000 " 
			      +" / SUM(trn.FLD_TRGT_YTD_SEP * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
			      +" ELSE ROUND(-2*100,1) END) AS ytdpft_bud "
			      +" FROM SM_SALES_DIV_MST mst, SM_SALES_SUMM_WIDE trn, sales_item, SM_SALES_BRAND_MST brnd "
			      +" WHERE trim(trn.fin_year)= (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
			      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
			      +" AND trn.fin_year=mst.fin_year "
			      +" AND trn.item_ser=mst.div_code "
			      +" AND trn.item_code= sales_item.item_code "
			      +" AND brnd.brand_code(+) = sales_item.item_sub_group "
			      +" AND brnd.div_code(+) = sales_item.item_ser "
			      +" AND brnd.fin_year(+) = (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
			      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
			      +" AND sales_item.item_sub_group NOT IN ('CU','BJ')  "
			      +" AND TO_NUMBER(SUBSTR(trn.fin_year,1,4)||'09') <= TO_NUMBER('"+month+"') "
			      +" UNION ALL "
			      +" SELECT 7 AS mnno, 'OCT' AS mth, " 
			      +" SUM(NVL(EXPENSE_MTH_OCT,0)) AS mthexp, "
			      +" SUM(NVL(EXPENSE_ytd_OCT,0)) AS ytdexp, "
			      +" ROUND(SUM(CY_SALE_MTH_OCT)/100000,2) - SUM(NVL(COGS_MTH_OCT,0)+NVL(EXPENSE_MTH_OCT,0)) AS mthpft, "
			      +" ROUND(SUM(CY_SALE_YTD_OCT)/100000,2) - SUM(NVL(COGS_YTD_OCT,0)+NVL(EXPENSE_YTD_OCT,0)) AS ytdpft, "
			      +" ( CASE WHEN SUM(CY_SALE_MTH_OCT)=0 THEN 200 "  
			      +" ELSE  ROUND( SUM(NVL(EXPENSE_MTH_OCT,0)) *100000 /SUM(CY_SALE_MTH_OCT) * 100, 2) END ) AS mthexp_per_sl, "
			      +" ( CASE WHEN SUM(CY_SALE_ytd_OCT)=0 THEN 200 "  
			      +" ELSE  ROUND( SUM(NVL(EXPENSE_YTD_OCT,0)) *100000 /SUM(CY_SALE_YTD_OCT) * 100, 2) END ) AS ytdexp_per_sl, "
			      +" (CASE WHEN SUM(trn.FLD_TRGT_MTH_OCT) <>0 THEN "
			      +" ROUND( SUM(NVL(mst.BUD_EXP_OCT,0))*1000 " 
			      +" / SUM(trn.FLD_TRGT_MTH_OCT * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
			      +" ELSE ROUND(2*100,1) END) AS mthexp_bud, "
			      +" (CASE WHEN SUM(trn.FLD_TRGT_YTD_OCT) <>0 THEN "
			      +" ROUND( SUM(NVL(mst.BUD_EXP_OCT,0))*1000 " 
			      +" / SUM(trn.FLD_TRGT_YTD_OCT * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
			      +" ELSE ROUND(2*100,1) END) AS ytdexp_bud, "
			      +" ( CASE WHEN SUM(CY_SALE_MTH_OCT)=0 THEN -200 "  
			      +" ELSE  ROUND(  ( SUM(CY_SALE_MTH_OCT) - (SUM( NVL(COGS_MTH_OCT,0)+NVL(EXPENSE_MTH_OCT,0) )*100000)  )/SUM(CY_SALE_MTH_OCT) "
			      +" * 100, 2) END ) AS mthpft_per_sl, "
			      +" ( CASE WHEN SUM(CY_SALE_YTD_OCT)=0 THEN -200 "  
			      +" ELSE  ROUND(  ( SUM(CY_SALE_YTD_OCT) - (SUM( NVL(COGS_YTD_OCT,0)+NVL(EXPENSE_YTD_OCT,0) )*100000)  )/SUM(CY_SALE_YTD_OCT) "
			      +" * 100, 2) END ) AS ytdpft_per_sl, "
			      +" (CASE WHEN SUM(trn.FLD_TRGT_MTH_OCT) <>0 THEN "
			      +" ROUND( SUM(NVL(mst.BUD_PFT_OCT,0))*1000 " 
			      +" / SUM(trn.FLD_TRGT_MTH_OCT * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
			      +" ELSE ROUND(-2*100,1) END) AS mthpft_bud, "
			      +" (CASE WHEN SUM(trn.FLD_TRGT_YTD_OCT) <>0 THEN "
			      +" ROUND( SUM(NVL(mst.BUD_PFT_OCT,0))*1000 " 
			      +" / SUM(trn.FLD_TRGT_YTD_OCT * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
			      +" ELSE ROUND(-2*100,1) END) AS ytdpft_bud "
			      +" FROM SM_SALES_DIV_MST mst, SM_SALES_SUMM_WIDE trn, sales_item, SM_SALES_BRAND_MST brnd "
			      +" WHERE trim(trn.fin_year)= (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
			      +" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
			      +" AND trn.fin_year=mst.fin_year "
			      +" AND trn.item_ser=mst.div_code "
			      +" AND trn.item_code= sales_item.item_code "
				  +" AND brnd.brand_code(+) = sales_item.item_sub_group "
					+" AND brnd.div_code(+) = sales_item.item_ser "
					+" AND brnd.fin_year(+) = (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
					+" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
					+" AND sales_item.item_sub_group NOT IN ('CU','BJ') " 
					+" AND TO_NUMBER(SUBSTR(trn.fin_year,1,4)||'10') <= TO_NUMBER('"+month+"') "
					+" UNION ALL "
					+" SELECT 8 AS mnno, 'NOV' AS mth, " 
					+" SUM(NVL(EXPENSE_MTH_NOV,0)) AS mthexp, "
					+" SUM(NVL(EXPENSE_ytd_NOV,0)) AS ytdexp, "
					+" ROUND(SUM(CY_SALE_MTH_NOV)/100000,2) - SUM(NVL(COGS_MTH_NOV,0)+NVL(EXPENSE_MTH_NOV,0)) AS mthpft, "
					+" ROUND(SUM(CY_SALE_YTD_NOV)/100000,2) - SUM(NVL(COGS_YTD_NOV,0)+NVL(EXPENSE_YTD_NOV,0)) AS ytdpft, "
					+" ( CASE WHEN SUM(CY_SALE_MTH_NOV)=0 THEN 200 "  
					+" ELSE  ROUND( SUM(NVL(EXPENSE_MTH_NOV,0)) *100000 /SUM(CY_SALE_MTH_NOV) * 100, 2) END ) AS mthexp_per_sl, "
					+" ( CASE WHEN SUM(CY_SALE_ytd_NOV)=0 THEN 200 "  
					+" ELSE  ROUND( SUM(NVL(EXPENSE_YTD_NOV,0)) *100000 /SUM(CY_SALE_YTD_NOV) * 100, 2) END ) AS ytdexp_per_sl, "
					+" (CASE WHEN SUM(trn.FLD_TRGT_MTH_NOV) <>0 THEN "
					+" ROUND( SUM(NVL(mst.BUD_EXP_NOV,0))*1000 " 
					+" / SUM(trn.FLD_TRGT_MTH_NOV * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
					+" ELSE ROUND(2*100,1) END) AS mthexp_bud, "
					+" (CASE WHEN SUM(trn.FLD_TRGT_YTD_NOV) <>0 THEN "
					+" ROUND( SUM(NVL(mst.BUD_EXP_NOV,0))*1000 " 
					+" / SUM(trn.FLD_TRGT_YTD_NOV * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
					+" ELSE ROUND(2*100,1) END) AS ytdexp_bud, "
					+" ( CASE WHEN SUM(CY_SALE_MTH_NOV)=0 THEN -200 "  
					+" ELSE  ROUND(  ( SUM(CY_SALE_MTH_NOV) - (SUM( NVL(COGS_MTH_NOV,0)+NVL(EXPENSE_MTH_NOV,0) )*100000)  )/SUM(CY_SALE_MTH_NOV) "
					+" * 100, 2) END ) AS mthpft_per_sl, "
					+" ( CASE WHEN SUM(CY_SALE_YTD_NOV)=0 THEN -200 "  
					+" ELSE  ROUND(  ( SUM(CY_SALE_YTD_NOV) - (SUM( NVL(COGS_YTD_NOV,0)+NVL(EXPENSE_YTD_NOV,0) )*100000)  )/SUM(CY_SALE_YTD_NOV) "
					+" * 100, 2) END ) AS ytdpft_per_sl, "
					+" (CASE WHEN SUM(trn.FLD_TRGT_MTH_NOV) <>0 THEN "
					+" ROUND( SUM(NVL(mst.BUD_PFT_NOV,0))*1000 " 
					+" / SUM(trn.FLD_TRGT_MTH_NOV * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
					+" ELSE ROUND(-2*100,1) END) AS mthpft_bud, "
					+" (CASE WHEN SUM(trn.FLD_TRGT_YTD_NOV) <>0 THEN "
					+" ROUND( SUM(NVL(mst.BUD_PFT_NOV,0))*1000 " 
					+" / SUM(trn.FLD_TRGT_YTD_NOV * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
					+" ELSE ROUND(-2*100,1) END) AS ytdpft_bud "
					+" FROM SM_SALES_DIV_MST mst, SM_SALES_SUMM_WIDE trn, sales_item, SM_SALES_BRAND_MST brnd "
					+" WHERE trim(trn.fin_year)= (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
					+" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
					+" AND trn.fin_year=mst.fin_year "
					+" AND trn.item_ser=mst.div_code "
					+" AND trn.item_code= sales_item.item_code "
					+" AND brnd.brand_code(+) = sales_item.item_sub_group "
					+" AND brnd.div_code(+) = sales_item.item_ser "
					+" AND brnd.fin_year(+) = (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
					+" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
					+" AND sales_item.item_sub_group NOT IN ('CU','BJ') " 
					+" AND TO_NUMBER(SUBSTR(trn.fin_year,1,4)||'11') <= TO_NUMBER('"+month+"') "
					+" UNION ALL "
					+" SELECT 9 AS mnno, 'DEC' AS mth, " 
					+" SUM(NVL(EXPENSE_MTH_DEC,0)) AS mthexp, "
					+" SUM(NVL(EXPENSE_ytd_DEC,0)) AS ytdexp, "
					+" ROUND(SUM(CY_SALE_MTH_DEC)/100000,2) - SUM(NVL(COGS_MTH_DEC,0)+NVL(EXPENSE_MTH_DEC,0)) AS mthpft, "
					+" ROUND(SUM(CY_SALE_YTD_DEC)/100000,2) - SUM(NVL(COGS_YTD_DEC,0)+NVL(EXPENSE_YTD_DEC,0)) AS ytdpft, "
					+" ( CASE WHEN SUM(CY_SALE_MTH_DEC)=0 THEN 200 "  
					+" ELSE  ROUND( SUM(NVL(EXPENSE_MTH_DEC,0)) *100000 /SUM(CY_SALE_MTH_DEC) * 100, 2) END ) AS mthexp_per_sl, "
					+" ( CASE WHEN SUM(CY_SALE_ytd_DEC)=0 THEN 200 "  
					+" ELSE  ROUND( SUM(NVL(EXPENSE_YTD_DEC,0)) *100000 /SUM(CY_SALE_YTD_DEC) * 100, 2) END ) AS ytdexp_per_sl, "
					+" (CASE WHEN SUM(trn.FLD_TRGT_MTH_DEC) <>0 THEN "
					+" ROUND( SUM(NVL(mst.BUD_EXP_DEC,0))*1000 " 
					+" / SUM(trn.FLD_TRGT_MTH_DEC * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
					+" ELSE ROUND(2*100,1) END) AS mthexp_bud, "
					+" (CASE WHEN SUM(trn.FLD_TRGT_YTD_DEC) <>0 THEN "
					+" ROUND( SUM(NVL(mst.BUD_EXP_DEC,0))*1000 " 
					+" / SUM(trn.FLD_TRGT_YTD_DEC * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
					+" ELSE ROUND(2*100,1) END) AS ytdexp_bud, "
					+" ( CASE WHEN SUM(CY_SALE_MTH_DEC)=0 THEN -200 "  
					+" ELSE  ROUND(  ( SUM(CY_SALE_MTH_DEC) - (SUM( NVL(COGS_MTH_DEC,0)+NVL(EXPENSE_MTH_DEC,0) )*100000)  )/SUM(CY_SALE_MTH_DEC) "
					+" * 100, 2) END ) AS mthpft_per_sl, "
					+" ( CASE WHEN SUM(CY_SALE_YTD_DEC)=0 THEN -200   "
					+" ELSE  ROUND(  ( SUM(CY_SALE_YTD_DEC) - (SUM( NVL(COGS_YTD_DEC,0)+NVL(EXPENSE_YTD_DEC,0) )*100000)  )/SUM(CY_SALE_YTD_DEC) " 
					+" * 100, 2) END ) AS ytdpft_per_sl, "
					+" (CASE WHEN SUM(trn.FLD_TRGT_MTH_DEC) <>0 THEN "
					+" ROUND( SUM(NVL(mst.BUD_PFT_DEC,0))*1000 " 
					+" / SUM(trn.FLD_TRGT_MTH_DEC * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
					+" ELSE ROUND(-2*100,1) END) AS mthpft_bud, "
					+" (CASE WHEN SUM(trn.FLD_TRGT_YTD_DEC) <>0 THEN "
					+" ROUND( SUM(NVL(mst.BUD_PFT_DEC,0))*1000 " 
					+" / SUM(trn.FLD_TRGT_YTD_DEC * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
					+" ELSE ROUND(-2*100,1) END) AS ytdpft_bud "
					+" FROM SM_SALES_DIV_MST mst, SM_SALES_SUMM_WIDE trn, sales_item, SM_SALES_BRAND_MST brnd "
					+" WHERE trim(trn.fin_year)= (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
					+" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
					+" AND trn.fin_year=mst.fin_year "
					+" AND trn.item_ser=mst.div_code "
					+" AND trn.item_code= sales_item.item_code "
					+" AND brnd.brand_code(+) = sales_item.item_sub_group "
					+" AND brnd.div_code(+) = sales_item.item_ser "
					+" AND brnd.fin_year(+) = (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
					+" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
					+" AND sales_item.item_sub_group NOT IN ('CU','BJ') " 
					+" AND TO_NUMBER(SUBSTR(trn.fin_year,1,4)||'12') <= TO_NUMBER('"+month+"') "
					+" UNION ALL "
					+" SELECT 10 AS mnno, 'JAN' AS mth, " 
					+" SUM(NVL(EXPENSE_MTH_JAN,0)) AS mthexp, "
					+" SUM(NVL(EXPENSE_ytd_JAN,0)) AS ytdexp, "
					+" ROUND(SUM(CY_SALE_MTH_JAN)/100000,2) - SUM(NVL(COGS_MTH_JAN,0)+NVL(EXPENSE_MTH_JAN,0)) AS mthpft, "
					+" ROUND(SUM(CY_SALE_YTD_JAN)/100000,2) - SUM(NVL(COGS_YTD_JAN,0)+NVL(EXPENSE_YTD_JAN,0)) AS ytdpft, "
					+" ( CASE WHEN SUM(CY_SALE_MTH_JAN)=0 THEN 200 "  
					+" ELSE  ROUND( SUM(NVL(EXPENSE_MTH_JAN,0)) *100000 /SUM(CY_SALE_MTH_JAN) * 100, 2) END ) AS mthexp_per_sl, "
					+" ( CASE WHEN SUM(CY_SALE_ytd_JAN)=0 THEN 200 "  
					+" ELSE  ROUND( SUM(NVL(EXPENSE_YTD_JAN,0)) *100000 /SUM(CY_SALE_YTD_JAN) * 100, 2) END ) AS ytdexp_per_sl, "
					+" (CASE WHEN SUM(trn.FLD_TRGT_MTH_JAN) <>0 THEN "
					+" ROUND( SUM(NVL(mst.BUD_EXP_JAN,0))*1000 " 
					+" / SUM(trn.FLD_TRGT_MTH_JAN * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
					+" ELSE ROUND(2*100,1) END) AS mthexp_bud, "
					+" (CASE WHEN SUM(trn.FLD_TRGT_YTD_JAN) <>0 THEN "
					+" ROUND( SUM(NVL(mst.BUD_EXP_JAN,0))*1000 " 
					+" / SUM(trn.FLD_TRGT_YTD_JAN * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
					+" ELSE ROUND(2*100,1) END) AS ytdexp_bud, "
					+" ( CASE WHEN SUM(CY_SALE_MTH_JAN)=0 THEN -200 "  
					+" ELSE  ROUND(  ( SUM(CY_SALE_MTH_JAN) - (SUM( NVL(COGS_MTH_JAN,0)+NVL(EXPENSE_MTH_JAN,0) )*100000)  )/SUM(CY_SALE_MTH_JAN) "
					+" * 100, 2) END ) AS mthpft_per_sl, "
					+" ( CASE WHEN SUM(CY_SALE_YTD_JAN)=0 THEN -200 "  
					+" ELSE  ROUND(  ( SUM(CY_SALE_YTD_JAN) - (SUM( NVL(COGS_YTD_JAN,0)+NVL(EXPENSE_YTD_JAN,0) )*100000)  )/SUM(CY_SALE_YTD_JAN) "
					+" * 100, 2) END ) AS ytdpft_per_sl, "
					+" (CASE WHEN SUM(trn.FLD_TRGT_MTH_JAN) <>0 THEN "
					+" ROUND( SUM(NVL(mst.BUD_PFT_JAN,0))*1000 " 
					+" / SUM(trn.FLD_TRGT_MTH_JAN * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
					+" ELSE ROUND(-2*100,1) END) AS mthpft_bud, "
					+" (CASE WHEN SUM(trn.FLD_TRGT_YTD_JAN) <>0 THEN "
					+" ROUND( SUM(NVL(mst.BUD_PFT_JAN,0))*1000 " 
					+" / SUM(trn.FLD_TRGT_YTD_JAN * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
					+" ELSE ROUND(-2*100,1) END) AS ytdpft_bud "
					+" FROM SM_SALES_DIV_MST mst, SM_SALES_SUMM_WIDE trn, sales_item, SM_SALES_BRAND_MST brnd "
					+" WHERE trim(trn.fin_year)= (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
					+" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
					+" AND trn.fin_year=mst.fin_year "
					+" AND trn.item_ser=mst.div_code "
					+" AND trn.item_code= sales_item.item_code "
					+" AND brnd.brand_code(+) = sales_item.item_sub_group "
					+" AND brnd.div_code(+) = sales_item.item_ser "
					+" AND brnd.fin_year(+) = (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
					+" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
			       +" AND sales_item.item_sub_group NOT IN ('CU','BJ') " 
			       +" AND TO_NUMBER(SUBSTR(trn.fin_year,1,2)||SUBSTR(trn.fin_year,6,2)||'01') <= TO_NUMBER('"+month+"') "
			      +" UNION ALL "
				+" SELECT 11 AS mnno, 'FEB' AS mth, " 
				+" SUM(NVL(EXPENSE_MTH_FEB,0)) AS mthexp, "
				+" SUM(NVL(EXPENSE_ytd_FEB,0)) AS ytdexp, "
				+" ROUND(SUM(CY_SALE_MTH_FEB)/100000,2) - SUM(NVL(COGS_MTH_FEB,0)+NVL(EXPENSE_MTH_FEB,0)) AS mthpft, "
				+" ROUND(SUM(CY_SALE_YTD_FEB)/100000,2) - SUM(NVL(COGS_YTD_FEB,0)+NVL(EXPENSE_YTD_FEB,0)) AS ytdpft, "
				+" ( CASE WHEN SUM(CY_SALE_MTH_FEB)=0 THEN 200 "  
				+" ELSE  ROUND( SUM(NVL(EXPENSE_MTH_FEB,0)) *100000 /SUM(CY_SALE_MTH_FEB) * 100, 2) END ) AS mthexp_per_sl, "
				+" ( CASE WHEN SUM(CY_SALE_ytd_FEB)=0 THEN 200 "  
				+" ELSE  ROUND( SUM(NVL(EXPENSE_YTD_FEB,0)) *100000 /SUM(CY_SALE_YTD_FEB) * 100, 2) END ) AS ytdexp_per_sl, "
				+" (CASE WHEN SUM(trn.FLD_TRGT_MTH_FEB) <>0 THEN "
				+" ROUND( SUM(NVL(mst.BUD_EXP_FEB,0))*1000 " 
				+" / SUM(trn.FLD_TRGT_MTH_FEB * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
				+" ELSE ROUND(2*100,1) END) AS mthexp_bud, "
				+" (CASE WHEN SUM(trn.FLD_TRGT_YTD_FEB) <>0 THEN "
				+" ROUND( SUM(NVL(mst.BUD_EXP_FEB,0))*1000 " 
				+" / SUM(trn.FLD_TRGT_YTD_FEB * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
				+" ELSE ROUND(2*100,1) END) AS ytdexp_bud, "
				+" ( CASE WHEN SUM(CY_SALE_MTH_FEB)=0 THEN -200 "  
				+" ELSE  ROUND(  ( SUM(CY_SALE_MTH_FEB) - (SUM( NVL(COGS_MTH_FEB,0)+NVL(EXPENSE_MTH_FEB,0) )*100000)  )/SUM(CY_SALE_MTH_FEB) "
				+" * 100, 2) END ) AS mthpft_per_sl, "
				+" ( CASE WHEN SUM(CY_SALE_YTD_FEB)=0 THEN -200 "  
				+" ELSE  ROUND(  ( SUM(CY_SALE_YTD_FEB) - (SUM( NVL(COGS_YTD_FEB,0)+NVL(EXPENSE_YTD_FEB,0) )*100000)  )/SUM(CY_SALE_YTD_FEB) "
				+"  * 100, 2) END ) AS ytdpft_per_sl, "
				+" (CASE WHEN SUM(trn.FLD_TRGT_MTH_FEB) <>0 THEN "
				+" ROUND( SUM(NVL(mst.BUD_PFT_FEB,0))*1000 " 
				+" / SUM(trn.FLD_TRGT_MTH_FEB * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
				+" ELSE ROUND(-2*100,1) END) AS mthpft_bud, "
				+" (CASE WHEN SUM(trn.FLD_TRGT_YTD_FEB) <>0 THEN "
				+" ROUND( SUM(NVL(mst.BUD_PFT_FEB,0))*1000 " 
				+" / SUM(trn.FLD_TRGT_YTD_FEB * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
				+" ELSE ROUND(-2*100,1) END) AS ytdpft_bud "
				+" FROM SM_SALES_DIV_MST mst, SM_SALES_SUMM_WIDE trn, sales_item, SM_SALES_BRAND_MST brnd "
				+" WHERE trim(trn.fin_year)= (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
				+" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
				+" AND trn.fin_year=mst.fin_year "
				+" AND trn.item_ser=mst.div_code "
				+" AND trn.item_code= sales_item.item_code "
				+" AND brnd.brand_code(+) = sales_item.item_sub_group "
				+" AND brnd.div_code(+) = sales_item.item_ser "
				+" AND brnd.fin_year(+) = (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
				+" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
				+" AND sales_item.item_sub_group NOT IN ('CU','BJ') " 
				+" AND TO_NUMBER(SUBSTR(trn.fin_year,1,2)||SUBSTR(trn.fin_year,6,2)||'02') <= TO_NUMBER('"+month+"') "
				+" UNION ALL "
				+" SELECT 12 AS mnno, 'MAR' AS mth, " 
				+" SUM(NVL(EXPENSE_MTH_MAR,0)) AS mthexp, "
				+" SUM(NVL(EXPENSE_ytd_MAR,0)) AS ytdexp, "
				+" ROUND(SUM(CY_SALE_MTH_MAR)/100000,2) - SUM(NVL(COGS_MTH_MAR,0)+NVL(EXPENSE_MTH_MAR,0)) AS mthpft, "
				+" ROUND(SUM(CY_SALE_YTD_MAR)/100000,2) - SUM(NVL(COGS_YTD_MAR,0)+NVL(EXPENSE_YTD_MAR,0)) AS ytdpft, "
				+" ( CASE WHEN SUM(CY_SALE_MTH_MAR)=0 THEN 200 "  
				+" ELSE  ROUND( SUM(NVL(EXPENSE_MTH_MAR,0)) *100000 /SUM(CY_SALE_MTH_MAR) * 100, 2) END ) AS mthexp_per_sl, "
				+" ( CASE WHEN SUM(CY_SALE_ytd_MAR)=0 THEN 200 "  
				+" ELSE  ROUND( SUM(NVL(EXPENSE_YTD_MAR,0)) *100000 /SUM(CY_SALE_YTD_MAR) * 100, 2) END ) AS ytdexp_per_sl, "
				+" (CASE WHEN SUM(trn.FLD_TRGT_MTH_MAR) <>0 THEN "
				+" ROUND( SUM(NVL(mst.BUD_EXP_MAR,0))*1000 " 
				+" / SUM(trn.FLD_TRGT_MTH_MAR * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
				+" ELSE ROUND(2*100,1) END) AS mthexp_bud, "
				+" (CASE WHEN SUM(trn.FLD_TRGT_YTD_MAR) <>0 THEN "
				+" ROUND( SUM(NVL(mst.BUD_EXP_MAR,0))*1000 " 
				+" / SUM(trn.FLD_TRGT_YTD_MAR * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
				+" ELSE ROUND(2*100,1) END) AS ytdexp_bud, "
				+" ( CASE WHEN SUM(CY_SALE_MTH_MAR)=0 THEN -200 "  
				+" ELSE  ROUND(  ( SUM(CY_SALE_MTH_MAR) - (SUM( NVL(COGS_MTH_MAR,0)+NVL(EXPENSE_MTH_MAR,0) )*100000)  )/SUM(CY_SALE_MTH_MAR) "
				+" * 100, 2) END ) AS mthpft_per_sl, "
				+" ( CASE WHEN SUM(CY_SALE_YTD_MAR)=0 THEN -200 "  
				+" ELSE  ROUND(  ( SUM(CY_SALE_YTD_MAR) - (SUM( NVL(COGS_YTD_MAR,0)+NVL(EXPENSE_YTD_MAR,0) )*100000)  )/SUM(CY_SALE_YTD_MAR) "
				+" * 100, 2) END ) AS ytdpft_per_sl, "
				+" (CASE WHEN SUM(trn.FLD_TRGT_MTH_MAR) <>0 THEN "
				+" ROUND( SUM(NVL(mst.BUD_PFT_MAR,0))*1000 " 
				+" / SUM(trn.FLD_TRGT_MTH_MAR * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
				+" ELSE ROUND(-2*100,1) END) AS mthpft_bud, "
				+" (CASE WHEN SUM(trn.FLD_TRGT_YTD_MAR) <>0 THEN "
				+" ROUND( SUM(NVL(mst.BUD_PFT_MAR,0))*1000 " 
				+" / SUM(trn.FLD_TRGT_YTD_MAR * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) * 100 ,1) " 
				+" ELSE ROUND(-2*100,1) END) AS ytdpft_bud "
				+" FROM SM_SALES_DIV_MST mst, SM_SALES_SUMM_WIDE trn, sales_item, SM_SALES_BRAND_MST brnd "
				+" WHERE trim(trn.fin_year)= (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
				+" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
				+" AND trn.fin_year=mst.fin_year "
				+" AND trn.item_ser=mst.div_code "
				+" AND trn.item_code= sales_item.item_code "
				+" AND brnd.brand_code(+) = sales_item.item_sub_group "
				+" AND brnd.div_code(+) = sales_item.item_ser "
				+" AND brnd.fin_year(+) = (CASE WHEN SUBSTR( '"+month+"'  ,5,2)<4 THEN SUBSTR( '"+month+"'  -100 ,1,4)||'-'||SUBSTR( '"+month+"'  ,3,2) " 
				+" ELSE SUBSTR( '"+month+"'  ,1,4)||'-' || SUBSTR( '"+month+"'  +100,3,2) END) "
				+" AND sales_item.item_sub_group NOT IN ('CU','BJ') " 
				+" AND TO_NUMBER(SUBSTR(trn.fin_year,1,2)||SUBSTR(trn.fin_year,6,2)||'03') <= TO_NUMBER('"+month+"') "
				+" ) "
				+" GROUP BY mnno,mth,mthexp,ytdexp,mthpft,ytdpft,mthexp_per_sl,ytdexp_per_sl,mthexp_bud,ytdexp_bud,mthpft_per_sl,ytdpft_per_sl,mthpft_bud,ytdpft_bud "
				+" HAVING ytdexp<>0 OR ytdpft<>0 "  
				+" ORDER BY mnno ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
			
				rowData = new JSONObject();
				rowData.put("month",   rs.getString("mth"));
				// start of properties for profit monthly graph 
				rowData.put("mthpft", rs.getString("mthpft"));
				rowData.put("mthpft_per_sl", rs.getString("mthpft_per_sl"));
				rowData.put("mthpft_bud", rs.getString("mthpft_bud"));
				// end of properties for profit monthly graph
				
				// start of properties for Expense monthly graph
				rowData.put("mthexp", rs.getString("mthexp"));
				rowData.put("mthexp_per_sl", rs.getString("mthexp_per_sl"));
				rowData.put("mthexp_bud", rs.getString("mthexp_bud"));
				// end of properties for Expense monthly graph
				
				// start of properties for Profit YTD graph
				rowData.put("ytdpft", rs.getString("ytdpft"));
				rowData.put("ytdpft_per_sl", rs.getString("ytdpft_per_sl"));
				rowData.put("ytdpft_bud", rs.getString("ytdpft_bud"));
				// end of properties for Profit YTD graph
				
				// start of properties for Expense YTD graph
				rowData.put("ytdexp", rs.getString("ytdexp"));
				rowData.put("ytdexp_per_sl", rs.getString("ytdexp_per_sl"));
				rowData.put("ytdexp_bud", rs.getString("ytdexp_bud"));
				// end of properties for Expense YTD graph
     			rawDataJson.put(count, rowData);
				count++;
				

			}
		}
		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :SalesPersonSales:getProfitGraph:" + d.getMessage());
				throw new ITMException(d);
			}
		}
				
		System.out.println("rawDataJson ProfitGraph is =" + rawDataJson);

		return rawDataJson;
	}
	/*** End of method getProfitGraphData() ***/
	
	
	/*** 
	 * Method Name      : getMnthlySalesGraphData(String dataSourceName, String month)
	 * Servlet Name     : SalesPerfrmncMonthWiseSalesServlet
	 * Metadataxml Name : salesdashboard.xml
	 * Description      : This method returns  raw data for rendering the Monthly Sales graph. 
	 * Graph Caption    :
	 *                    1. Monthly Sales
	 * ***/
	@SuppressWarnings("unchecked")
	public JSONObject getMnthlySalesGraphData(String dataSourceName, String month) throws RemoteException, ITMException
	{
		JSONObject rawDataMthlySalesJson = new JSONObject();
		JSONObject rowData               = null;
		ResultSet rs                     = null;
		PreparedStatement pstmt          = null;
		Connection conn                  = null;
		String sql                       = "";
		String finYear                   = "";
		try
		{
		   if(month!=null && month.trim().length()>0)
			{
		    	/*conn = connDriver.getConnectDB(dataSourceName);
				connDriver = null;*/
			   /*add new code for connection DB on dated:15062016 by Nikhil*/
				conn = getConnection();
				System.out.println("Comming  month inside getMnthlySalesGraphData ==="+month);					
				String selectedMonth  = month.substring(4, 6);				
				if(selectedMonth.trim().equalsIgnoreCase("01") ||selectedMonth.trim().equalsIgnoreCase("02") ||selectedMonth.trim().equalsIgnoreCase("03"))
				{
			    	finYear = String.valueOf(Integer.parseInt(month.substring(0, 4))-1)+"-"+month.substring(2, 4);
					
				}
				else
				{
					finYear = month.substring(0, 4)+"-"+ (String.valueOf(Integer.parseInt(month.substring(0, 4))+1)).substring(2, 4);
				}
				System.out.println("updates month and year from dcoding in getMnthlySalesGraphData =="+month+"finYear =="+finYear);
				sql =" SELECT b.group_no,b.div_group,( CASE WHEN SUBSTR('"+month+"' ,5,2) =3 THEN ROUND(0 ,1) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2)<3 THEN ROUND(SUM(a.hotrgt_annual_cy-a.sale_ytd_cy) "
			    		+" /(12- SUBSTR('"+month+"' ,5,2)-9) /10000000,1) ELSE ROUND(SUM(a.hotrgt_annual_cy-a.sale_ytd_cy) "
			    		+" /(12- SUBSTR('"+month+"' ,5,2)+3) /10000000,1) END ) AS REQD_MTHLY, "
			    		+" ROUND(SUM(a.sale_ytd_cy)/ (CASE WHEN SUBSTR('"+month+"' ,5,2)<4 THEN "
			    		+" SUBSTR('"+month+"' ,5,2)+9 ELSE SUBSTR('"+month+"' ,5,2)-3 END)/10000000,1) "
			    		+" AS AVG_MTHLY,ROUND(SUM(a.sale_mth_cy)/10000000,1) AS MTH_CY_SALES, " 
			    		+" ROUND(SUM(a.hotrgt_mth_cy)/10000000,1) AS MTH_HO_TRGT,"
                        +" (case when SUM (a.hotrgt_mth_cy) <>0 then "
					     +" (case when ROUND(SUM (a.sale_mth_cy)/	SUM (a.hotrgt_mth_cy)* 100,1) <-200 THEN -200 "
					      +" when ROUND(SUM (a.sale_mth_cy)/	SUM (a.hotrgt_mth_cy)* 100,1) >200 THEN 200 ELSE "
					      +" ROUND(SUM (a.sale_mth_cy)/	SUM (a.hotrgt_mth_cy)* 100,1) end )"		    		
						+" ELSE ROUND(0*100,1)  END) AS MTH_ACH_PER, "			    		
								    		+"(CASE WHEN SUM(a.sale_mth_ly)<>0 "
						+" THEN (CASE WHEN ROUND(SUM(a.sale_mth_cy - a.sale_mth_ly)/SUM(a.sale_mth_ly)*100,1) <-200 THEN -200 "
					              +" WHEN ROUND(SUM(a.sale_mth_cy - a.sale_mth_ly)/SUM(a.sale_mth_ly)*100,1) >200 THEN 200 ELSE "
					              +" ROUND(SUM(a.sale_mth_cy - a.sale_mth_ly)/SUM(a.sale_mth_ly)*100,1) END )"
						+" ELSE ROUND(0*100,1)  END) AS MTH_GR, "
			    		+" ROUND(SUM(a.sale_ytd_cy)/10000000,1) "
			    		+" AS YTD_CY_SALES,ROUND(SUM(a.sale_ytd_ly)/10000000,1) AS YTD_LY_SALES, "
			    		+" ROUND(SUM(a.hotrgt_ytd_cy)/10000000,1) AS YTD_HO_TRGT,"
			    		+"(CASE WHEN SUM(a.sale_ytd_ly)<>0 "
						+" THEN (CASE WHEN ROUND(SUM(a.sale_ytd_cy - a.sale_ytd_ly)/SUM(a.sale_ytd_ly)*100,1) <-200 THEN -200 "
					    +" WHEN ROUND(SUM(a.sale_ytd_cy - a.sale_ytd_ly)/SUM(a.sale_ytd_ly)*100,1) >200 THEN 200 ELSE "
					    +" ROUND(SUM(a.sale_ytd_cy - a.sale_ytd_ly)/SUM(a.sale_ytd_ly)*100,1) END )"
			    		+" ELSE ROUND(0*100,1)  END) AS YTD_GR,"
			    		+" ROUND(SUM(a.sale_Qrt1_cy)/10000000,1) AS Q1, " 
			    		+" ROUND(SUM(a.sale_Qrt2_cy)/10000000,1) AS Q2,ROUND(SUM(a.sale_Qrt3_cy)/10000000,1) AS Q3, " 
			    		+" ROUND(SUM(a.sale_Qrt4_cy)/10000000,1) AS Q4,ROUND(SUM(a.sale_ytd_cy)/100000/"
			    		+" SUM(c.psr)/ (CASE WHEN SUBSTR('"+month+"' ,5,2)<4 THEN SUBSTR('"+month+"' ,5,2)+9 "
			    		+" ELSE SUBSTR('"+month+"' ,5,2)-3 END) ,1) AS PMPM,SUM(b.pmpm_ly) AS PMPM_LY, "
			    		+" ROUND(SUM(a.sale_ytd_cy-a.hotrgt_ytd_cy)/10000000,1) AS YTD_ACH_EXTRA, " 
			    		+" (CASE WHEN SUM(a.sale_ytd_cy)<>0 THEN ROUND(SUM(a.retu_ytd_cy)/" 
			    		+" SUM(a.sale_ytd_cy)*100,1) ELSE ROUND(0*100,1) END) AS RETU_YTD_PRCT "
			    		+" FROM (SELECT dwh.fin_year , dwh.item_ser,SUM(sale_mth_cy) AS sale_mth_cy, "
			    		+" SUM(sale_mth_ly) AS sale_mth_ly,SUM(trgt_mth_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0))"
			    		+" /100) AS hotrgt_mth_cy,SUM(sale_YTD_cy) AS sale_YTD_cy, "
			    		+" SUM(sale_YTD_ly) AS sale_YTD_ly,SUM(trgt_YTD_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) "
			    		+" /100) AS hotrgt_ytd_cy,SUM(sale_Qrt1_cy) AS sale_Qrt1_cy,SUM(sale_Qrt2_cy) AS sale_Qrt2_cy, " 
			    		+" SUM(sale_Qrt3_cy) AS sale_Qrt3_cy,SUM(sale_Qrt4_cy) AS sale_Qrt4_cy, " 
			    		+" SUM(trgt_annual_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) "
			    		+" AS hotrgt_annual_cy,SUM(retu_ytd_cy) AS retu_ytd_cy "
			    		+" FROM(SELECT fin_year , SM_SALES_SUMM_WIDE.item_ser,"  
			    		+" sales_item.item_sub_group AS sub_grp,(CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' "
			    		+" THEN SUM(CY_SALE_MTH_APR) WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_SALE_MTH_MAY) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(CY_SALE_MTH_JUN) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_SALE_MTH_JUL) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_SALE_MTH_AUG) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(CY_SALE_MTH_SEP) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_SALE_MTH_OCT) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(CY_SALE_MTH_NOV) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(CY_SALE_MTH_DEC) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_SALE_MTH_JAN) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(CY_SALE_MTH_FEB) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(CY_SALE_MTH_MAR) END ) AS sale_mth_cy, "
			    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(LY_SALE_MTH_APR) "	         
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(LY_SALE_MTH_MAY) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(LY_SALE_MTH_JUN) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(lY_SALE_MTH_JUL) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(lY_SALE_MTH_AUG) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(lY_SALE_MTH_SEP) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(lY_SALE_MTH_OCT) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(lY_SALE_MTH_NOV) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(lY_SALE_MTH_DEC) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(lY_SALE_MTH_JAN) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(lY_SALE_MTH_FEB) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(lY_SALE_MTH_MAR) END ) AS sale_mth_ly,"
			    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(FLD_TRGT_MTH_APR) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(FLD_TRGT_MTH_MAY)"
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(FLD_TRGT_MTH_JUN)"
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(FLD_TRGT_MTH_JUL) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(FLD_TRGT_MTH_AUG) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(FLD_TRGT_MTH_SEP) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(FLD_TRGT_MTH_OCT) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(FLD_TRGT_MTH_NOV) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(FLD_TRGT_MTH_DEC) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(FLD_TRGT_MTH_JAN) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(FLD_TRGT_MTH_FEB) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(FLD_TRGT_MTH_MAR) END ) "
			    		+" AS trgt_mth_cy, "
			    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(CY_SALE_YTD_JUN) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(CY_SALE_YTD_SEP) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(CY_SALE_YTD_NOV) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(CY_SALE_YTD_DEC) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(CY_SALE_YTD_FEB) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(CY_SALE_YTD_MAR) END ) "
			    		+" AS sale_YTD_cy, " 
			    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(lY_SALE_YTD_APR) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(lY_SALE_YTD_MAY) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(lY_SALE_YTD_JUN) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(lY_SALE_YTD_JUL) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(lY_SALE_YTD_AUG) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(lY_SALE_YTD_SEP) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(lY_SALE_YTD_OCT) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(lY_SALE_YTD_NOV) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(lY_SALE_YTD_DEC) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(lY_SALE_YTD_JAN) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(lY_SALE_YTD_FEB) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(lY_SALE_YTD_MAR) END ) "
			    		+" AS sale_YTD_ly," 
			    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(FLD_TRGT_YTD_APR) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(FLD_TRGT_YTD_MAY) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(FLD_TRGT_YTD_JUN) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(FLD_TRGT_YTD_JUL) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(FLD_TRGT_YTD_AUG) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(FLD_TRGT_YTD_SEP) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(FLD_TRGT_YTD_OCT) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(FLD_TRGT_YTD_NOV) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(FLD_TRGT_YTD_DEC) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(FLD_TRGT_YTD_JAN) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(FLD_TRGT_YTD_FEB) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(FLD_TRGT_YTD_MAR) END ) "
			    		+" AS trgt_YTD_cy, "
			    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) "
			    		+" ELSE SUM(CY_SALE_YTD_JUN)  END ) AS sale_Qrt1_cy, "
			    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) >='04' AND  SUBSTR('"+month+"' ,5,2) <='06' "
			    		+" THEN 0 WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) - SUM(CY_SALE_YTD_JUN) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) - SUM(CY_SALE_YTD_JUN) "
			    		+" ELSE  SUM(CY_SALE_YTD_SEP) - SUM(CY_SALE_YTD_JUN) END ) AS sale_Qrt2_cy,"
			    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) >='04' AND  SUBSTR('"+month+"' ,5,2) <='09' "
			    		+" THEN 0 WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) - "
			    		+" SUM(CY_SALE_YTD_SEP) WHEN SUBSTR('"+month+"' ,5,2) ='11' "
			    		+" THEN SUM(CY_SALE_YTD_NOV) - SUM(CY_SALE_YTD_SEP) ELSE "
			    		+" SUM(CY_SALE_YTD_DEC) - SUM(CY_SALE_YTD_SEP) END ) AS sale_Qrt3_cy, " 	
			    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) >='04' AND  SUBSTR('"+month+"' ,5,2) <='12' "
			    		+" THEN 0 WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) -"
			    		+" SUM(CY_SALE_YTD_DEC) WHEN SUBSTR('"+month+"' ,5,2) ='02' "
			    		+" THEN SUM(CY_SALE_YTD_FEB) - SUM(CY_SALE_YTD_DEC) ELSE "
			    		+" SUM(CY_SALE_YTD_MAR) - SUM(CY_SALE_YTD_DEC) END ) AS sale_Qrt4_cy,"
			    		+" SUM(FLD_TRGT_YTD_MAR) AS trgt_annual_cy, "
			    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(CY_RETU_YTD_APR) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_RETU_YTD_MAY) "	
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(CY_RETU_YTD_JUN) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_RETU_YTD_JUL) "	
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_RETU_YTD_AUG) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(CY_RETU_YTD_SEP) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_RETU_YTD_OCT) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(CY_RETU_YTD_NOV) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(CY_RETU_YTD_DEC) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_RETU_YTD_JAN) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(CY_RETU_YTD_FEB) "
			    		+" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(CY_RETU_YTD_MAR) END ) "
			    		+" AS retu_ytd_cy "
			    		+" FROM SM_SALES_SUMM_WIDE, sales_item " 
			    		+" WHERE trim(fin_year)= (CASE WHEN SUBSTR('"+month+"' ,5,2)<4 "
			    		+" THEN SUBSTR('"+month+"' -100 ,1,4)||'-'||SUBSTR('"+month+"' ,3,2) "             
			    		+" ELSE SUBSTR('"+month+"' ,1,4)||'-' || SUBSTR('"+month+"' +100,3,2) END) "
			    		+" AND '"+month+"' =	'"+month+"' "		
			    		+" AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code "
			    		+" AND sales_item.item_sub_group NOT IN ('CU','BJ') "
			    		+" GROUP BY fin_year ,SM_SALES_SUMM_WIDE.item_ser, sales_item.item_sub_group "     
			    		+" ) dwh,SM_SALES_BRAND_MST brnd  WHERE brnd.brand_code(+) = dwh.sub_grp "    
			    		+" AND brnd.div_code(+) = dwh.item_ser    AND brnd.fin_year(+) = dwh.fin_year "  
			    		+" GROUP BY dwh.fin_year, dwh.item_ser ) a, " 
			    		+" SM_SALES_DIV_MST b,( SELECT finyr, table_no, SUM(psr) AS psr " 
			    		+" FROM ( SELECT SUBSTR(version_id,3,4) AS finyr ,table_no, pool_code, "
			    		+" TO_NUMBER(MAX(NO_PSR_TERR)) AS PSR FROM starclub.emp_sales "
			    		+" WHERE LEVEL_NO = 4 GROUP BY SUBSTR(version_id,3,4) ,table_no, pool_code ) "
			    		+" GROUP BY finyr, table_no ) c "
			    		+" WHERE trim(a.item_ser)=trim(b.div_code) AND b.fin_year=a.fin_year "
			    		+" AND trim(a.item_ser)=trim(c.table_no) "
			    		+" AND c.finyr = SUBSTR(a.fin_year,3,2)||SUBSTR(a.fin_year,6,2) "
			    		+" AND b.div_group <> 'OTHERS' GROUP BY b.group_no,b.div_group ORDER BY group_no,div_group ";
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;		
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("division_grp",  checkNull(rs.getString("div_group")));
				rowData.put("mth_sales_val", rs.getString("mth_cy_sales"));
				rowData.put("avg_month_sal", rs.getString("avg_mthly"));
				rowData.put("req_month_sal", rs.getString("reqd_mthly"));
				rowData.put("growt_perc",    rs.getString("mth_gr"));
				rowData.put("ho_ach", rs.getString("MTH_ACH_PER"));
				rawDataMthlySalesJson.put(count, rowData);
				count++;				
				
			}
		}
			System.out.println("fetch Data for Mnthly Sales Graph rawjson====" + rawDataMthlySalesJson.toString());

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :SalesPersonSales:getMnthlySalesGraphData:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataMthlySalesJson;
	}
	/*** End of method getMnthlySalesGraphData() ***/
	
	
	/*** 
	 * Method Name      : getYTDSalesGraphData(String dataSourceName, String month)
	 * Servlet Name     : SalesPerfrmncYTDWiseSalesServlet
	 * Metadataxml Name : salesdashboard.xml
	 * Description      : This method returns  raw data for rendering the YTD Sales graph. 
	 * Graph Caption    :
	 *                    1. YTD Sales
	 * ***/
	@SuppressWarnings("unchecked")
	public JSONObject getYTDSalesGraphData(String dataSourceName,String month) throws RemoteException, ITMException
	{
		JSONObject rawDataYTDSalesJson = new JSONObject();
		JSONObject rowData             = null;
		String sql                     = "";
		String finYear                 = ""; 
		ResultSet rs                   = null;
		PreparedStatement pstmt        = null;
		Connection conn                = null;
		try
		{
		    if(month!=null && month.trim().length()>0)
				{
				    /*conn = connDriver.getConnectDB(dataSourceName);
					connDriver = null;*/
			    	/*add new code for connection DB on dated:15062016 by Nikhil*/
					conn = getConnection();
					System.out.println("Comming  month inside getYTDSalesGraphData ==="+month);					
					String selectedMonth  = month.substring(4, 6);				
					if(selectedMonth.trim().equalsIgnoreCase("01") ||selectedMonth.trim().equalsIgnoreCase("02") ||selectedMonth.trim().equalsIgnoreCase("03"))
					{
				    	finYear = String.valueOf(Integer.parseInt(month.substring(0, 4))-1)+"-"+month.substring(2, 4);
					}
					else
					{
						finYear = month.substring(0, 4)+"-"+ (String.valueOf(Integer.parseInt(month.substring(0, 4))+1)).substring(2, 4);
					}
					System.out.println("updates month and year from dcoding in getYTDSalesGraphData =="+month+"finYear =="+finYear);
				
					sql  =" SELECT b.group_no,b.div_group,( CASE WHEN SUBSTR('"+month+"' ,5,2) =3 THEN ROUND(0 ,1) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2)<3 THEN ROUND(SUM(a.hotrgt_annual_cy-a.sale_ytd_cy) "
				    		+" /(12- SUBSTR('"+month+"' ,5,2)-9) /10000000,1) ELSE ROUND(SUM(a.hotrgt_annual_cy-a.sale_ytd_cy) "
				    		+" /(12- SUBSTR('"+month+"' ,5,2)+3) /10000000,1) END ) AS REQD_MTHLY, "
				    		+" ROUND(SUM(a.sale_ytd_cy)/ (CASE WHEN SUBSTR('"+month+"' ,5,2)<4 THEN "
				    		+" SUBSTR('"+month+"' ,5,2)+9 ELSE SUBSTR('"+month+"' ,5,2)-3 END)/10000000,1) "
				    		+" AS AVG_MTHLY,ROUND(SUM(a.sale_mth_cy)/10000000,1) AS MTH_CY_SALES, " 
				    		+" ROUND(SUM(a.hotrgt_mth_cy)/10000000,1) AS MTH_HO_TRGT,"
				    		+" (CASE WHEN SUM(a.sale_mth_ly)<>0 "
							+" THEN (CASE WHEN ROUND(SUM(a.sale_mth_cy - a.sale_mth_ly)/SUM(a.sale_mth_ly)*100,1) <-200 THEN -200 "
				            +" WHEN ROUND(SUM(a.sale_mth_cy - a.sale_mth_ly)/SUM(a.sale_mth_ly)*100,1) >200 THEN 200 ELSE "
				            +" ROUND(SUM(a.sale_mth_cy - a.sale_mth_ly)/SUM(a.sale_mth_ly)*100,1) END )"
				    		+" ELSE ROUND(0*100,1)  END) AS MTH_GR,"
				    		+ "ROUND(SUM(a.sale_ytd_cy)/10000000,1) "
				    		+" AS YTD_CY_SALES,ROUND(SUM(a.sale_ytd_ly)/10000000,1) AS YTD_LY_SALES, "
				    		+" ROUND(SUM(a.hotrgt_ytd_cy)/10000000,1) AS YTD_HO_TRGT, "
						    + " (CASE WHEN SUM (a.hotrgt_ytd_cy)= 0 THEN 0 ELSE "
					        +" (CASE WHEN ROUND(SUM (a.sale_ytd_cy)/SUM (a.hotrgt_ytd_cy)* 100,1) <-200 THEN -200 "
				            +" WHEN ROUND(SUM (a.sale_ytd_cy)/SUM (a.hotrgt_ytd_cy)* 100,1) >200 THEN 200 ELSE "
				            +" ROUND(SUM (a.sale_ytd_cy)/SUM (a.hotrgt_ytd_cy)* 100,1) END) end) AS YTD_ACH_PER, "					   
							+" (CASE WHEN SUM(a.sale_ytd_ly)<>0 "
							+" THEN (CASE WHEN ROUND(SUM(a.sale_ytd_cy - a.sale_ytd_ly)/SUM(a.sale_ytd_ly)*100,1) <-200 THEN -200 "
				            +" WHEN ROUND(SUM(a.sale_ytd_cy - a.sale_ytd_ly)/SUM(a.sale_ytd_ly)*100,1) >200 THEN 200 ELSE "
				            +" ROUND(SUM(a.sale_ytd_cy - a.sale_ytd_ly)/SUM(a.sale_ytd_ly)*100,1) END )"				    		
				    		+" ELSE ROUND(0*100,1)  END) AS YTD_GR,"
				    		+" ROUND(SUM(a.sale_Qrt1_cy)/10000000,1) AS Q1, " 
				    		+" ROUND(SUM(a.sale_Qrt2_cy)/10000000,1) AS Q2,ROUND(SUM(a.sale_Qrt3_cy)/10000000,1) AS Q3, " 
				    		+" ROUND(SUM(a.sale_Qrt4_cy)/10000000,1) AS Q4,ROUND(SUM(a.sale_ytd_cy)/100000/"
				    		+" MAX(c.psr)/ (CASE WHEN SUBSTR('"+month+"' ,5,2)<4 THEN SUBSTR('"+month+"' ,5,2)+9 "
				    		+" ELSE SUBSTR('"+month+"' ,5,2)-3 END) ,2) AS PMPM,round(SUM(b.pmpm_ly),2) AS PMPM_LY, "
				    		+" ROUND(SUM(a.sale_ytd_cy-a.hotrgt_ytd_cy)/10000000,1) AS YTD_ACH_EXTRA, " 
				    		+" (CASE WHEN SUM(a.sale_ytd_cy)<>0 THEN ROUND(SUM(a.retu_ytd_cy)/" 
				    		+" SUM(a.sale_ytd_cy)*100,1) ELSE ROUND(0*100,1) END) AS RETU_YTD_PRCT "
				    		+" FROM (SELECT dwh.fin_year , dwh.item_ser,SUM(sale_mth_cy) AS sale_mth_cy, "
				    		+" SUM(sale_mth_ly) AS sale_mth_ly,SUM(trgt_mth_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0))"
				    		+" /100) AS hotrgt_mth_cy,SUM(sale_YTD_cy) AS sale_YTD_cy, "
				    		+" SUM(sale_YTD_ly) AS sale_YTD_ly,SUM(trgt_YTD_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) "
				    		+" /100) AS hotrgt_ytd_cy,SUM(sale_Qrt1_cy) AS sale_Qrt1_cy,SUM(sale_Qrt2_cy) AS sale_Qrt2_cy, " 
				    		+" SUM(sale_Qrt3_cy) AS sale_Qrt3_cy,SUM(sale_Qrt4_cy) AS sale_Qrt4_cy, " 
				    		+" SUM(trgt_annual_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) "
				    		+" AS hotrgt_annual_cy,SUM(retu_ytd_cy) AS retu_ytd_cy "
				    		+" FROM(SELECT fin_year , SM_SALES_SUMM_WIDE.item_ser,"  
				    		+" sales_item.item_sub_group AS sub_grp,(CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' "
				    		+" THEN SUM(CY_SALE_MTH_APR) WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_SALE_MTH_MAY) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(CY_SALE_MTH_JUN) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_SALE_MTH_JUL) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_SALE_MTH_AUG) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(CY_SALE_MTH_SEP) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_SALE_MTH_OCT) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(CY_SALE_MTH_NOV) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(CY_SALE_MTH_DEC) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_SALE_MTH_JAN) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(CY_SALE_MTH_FEB) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(CY_SALE_MTH_MAR) END ) AS sale_mth_cy, "
				    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(LY_SALE_MTH_APR) "	         
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(LY_SALE_MTH_MAY) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(LY_SALE_MTH_JUN) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(lY_SALE_MTH_JUL) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(lY_SALE_MTH_AUG) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(lY_SALE_MTH_SEP) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(lY_SALE_MTH_OCT) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(lY_SALE_MTH_NOV) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(lY_SALE_MTH_DEC) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(lY_SALE_MTH_JAN) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(lY_SALE_MTH_FEB) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(lY_SALE_MTH_MAR) END ) AS sale_mth_ly,"
				    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(FLD_TRGT_MTH_APR) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(FLD_TRGT_MTH_MAY)"
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(FLD_TRGT_MTH_JUN)"
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(FLD_TRGT_MTH_JUL) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(FLD_TRGT_MTH_AUG) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(FLD_TRGT_MTH_SEP) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(FLD_TRGT_MTH_OCT) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(FLD_TRGT_MTH_NOV) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(FLD_TRGT_MTH_DEC) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(FLD_TRGT_MTH_JAN) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(FLD_TRGT_MTH_FEB) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(FLD_TRGT_MTH_MAR) END ) "
				    		+" AS trgt_mth_cy, "
				    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(CY_SALE_YTD_JUN) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(CY_SALE_YTD_SEP) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(CY_SALE_YTD_NOV) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(CY_SALE_YTD_DEC) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(CY_SALE_YTD_FEB) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(CY_SALE_YTD_MAR) END ) "
				    		+" AS sale_YTD_cy, " 
				    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(lY_SALE_YTD_APR) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(lY_SALE_YTD_MAY) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(lY_SALE_YTD_JUN) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(lY_SALE_YTD_JUL) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(lY_SALE_YTD_AUG) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(lY_SALE_YTD_SEP) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(lY_SALE_YTD_OCT) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(lY_SALE_YTD_NOV) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(lY_SALE_YTD_DEC) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(lY_SALE_YTD_JAN) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(lY_SALE_YTD_FEB) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(lY_SALE_YTD_MAR) END ) "
				    		+" AS sale_YTD_ly," 
				    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(FLD_TRGT_YTD_APR) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(FLD_TRGT_YTD_MAY) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(FLD_TRGT_YTD_JUN) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(FLD_TRGT_YTD_JUL) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(FLD_TRGT_YTD_AUG) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(FLD_TRGT_YTD_SEP) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(FLD_TRGT_YTD_OCT) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(FLD_TRGT_YTD_NOV) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(FLD_TRGT_YTD_DEC) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(FLD_TRGT_YTD_JAN) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(FLD_TRGT_YTD_FEB) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(FLD_TRGT_YTD_MAR) END ) "
				    		+" AS trgt_YTD_cy, "
				    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) "
				    		+" ELSE SUM(CY_SALE_YTD_JUN)  END ) AS sale_Qrt1_cy, "
				    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) >='04' AND  SUBSTR('"+month+"' ,5,2) <='06' "
				    		+" THEN 0 WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) - SUM(CY_SALE_YTD_JUN) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) - SUM(CY_SALE_YTD_JUN) "
				    		+" ELSE  SUM(CY_SALE_YTD_SEP) - SUM(CY_SALE_YTD_JUN) END ) AS sale_Qrt2_cy,"
				    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) >='04' AND  SUBSTR('"+month+"' ,5,2) <='09' "
				    		+" THEN 0 WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) - "
				    		+" SUM(CY_SALE_YTD_SEP) WHEN SUBSTR('"+month+"' ,5,2) ='11' "
				    		+" THEN SUM(CY_SALE_YTD_NOV) - SUM(CY_SALE_YTD_SEP) ELSE "
				    		+" SUM(CY_SALE_YTD_DEC) - SUM(CY_SALE_YTD_SEP) END ) AS sale_Qrt3_cy, " 	
				    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) >='04' AND  SUBSTR('"+month+"' ,5,2) <='12' "
				    		+" THEN 0 WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) -"
				    		+" SUM(CY_SALE_YTD_DEC) WHEN SUBSTR('"+month+"' ,5,2) ='02' "
				    		+" THEN SUM(CY_SALE_YTD_FEB) - SUM(CY_SALE_YTD_DEC) ELSE "
				    		+" SUM(CY_SALE_YTD_MAR) - SUM(CY_SALE_YTD_DEC) END ) AS sale_Qrt4_cy,"
				    		+" SUM(FLD_TRGT_YTD_MAR) AS trgt_annual_cy, "
				    		+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(CY_RETU_YTD_APR) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_RETU_YTD_MAY) "	
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(CY_RETU_YTD_JUN) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_RETU_YTD_JUL) "	
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_RETU_YTD_AUG) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(CY_RETU_YTD_SEP) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_RETU_YTD_OCT) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(CY_RETU_YTD_NOV) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(CY_RETU_YTD_DEC) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_RETU_YTD_JAN) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(CY_RETU_YTD_FEB) "
				    		+" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(CY_RETU_YTD_MAR) END ) "
				    		+" AS retu_ytd_cy "
				    		+" FROM SM_SALES_SUMM_WIDE, sales_item " 
				    		+" WHERE trim(fin_year)= (CASE WHEN SUBSTR('"+month+"' ,5,2)<4 "
				    		+" THEN SUBSTR('"+month+"' -100 ,1,4)||'-'||SUBSTR('"+month+"' ,3,2) "             
				    		+" ELSE SUBSTR('"+month+"' ,1,4)||'-' || SUBSTR('"+month+"' +100,3,2) END) "
				    		+" AND '"+month+"' ='"+month+"' "		
				    		+" AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code "
				    		+" AND sales_item.item_sub_group NOT IN ('CU','BJ') "
				    		+" GROUP BY fin_year ,SM_SALES_SUMM_WIDE.item_ser, sales_item.item_sub_group "     
				    		+" ) dwh,SM_SALES_BRAND_MST brnd  WHERE brnd.brand_code(+) = dwh.sub_grp "    
				    		+" AND brnd.div_code(+) = dwh.item_ser    AND brnd.fin_year(+) = dwh.fin_year "  
				    		+" GROUP BY dwh.fin_year, dwh.item_ser ) a, " 
				    		+" SM_SALES_DIV_MST b,( SELECT finyr, table_no, SUM(psr) AS psr " 
				    		+" FROM ( SELECT SUBSTR(version_id,3,4) AS finyr ,table_no, pool_code, "
				    		+" TO_NUMBER(MAX(NO_PSR_TERR)) AS PSR FROM starclub.emp_sales "
				    		+" WHERE LEVEL_NO = 4 GROUP BY SUBSTR(version_id,3,4) ,table_no, pool_code ) "
				    		+" GROUP BY finyr, table_no ) c "
				    		+" WHERE trim(a.item_ser)=trim(b.div_code) AND b.fin_year=a.fin_year "
				    		+" AND trim(a.item_ser)=trim(c.table_no) "
				    		+" AND c.finyr = SUBSTR(a.fin_year,3,2)||SUBSTR(a.fin_year,6,2) "
				    		+" AND b.div_group <> 'OTHERS' GROUP BY b.group_no,b.div_group ORDER BY group_no,div_group ";
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;
			
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("division_grp", checkNull(rs.getString("div_group")));
				rowData.put("sal",    rs.getString("ytd_cy_sales"));
				rowData.put("gr",     rs.getString("ytd_gr"));
				rowData.put("ho_ach", rs.getString("YTD_ACH_PER"));
				//check property in sql nowwwwwww--
				//add new property for YTD on 8/01/2015 by Birendra Pandey
                rowData.put("ytd_ly_sales",  rs.getString("YTD_LY_SALES"));
				rowData.put("ytd_ho_trgt",   rs.getString("YTD_HO_TRGT"));									
                rowData.put("retu_ytd_prct", rs.getString("RETU_YTD_PRCT"));
				//Add new new property on date 8-Jan-15 by Birendra Pandey for Month sales graph
				rowData.put("reqd_mthly",   rs.getString("REQD_MTHLY"));
				rowData.put("avg_mthly",    rs.getString("AVG_MTHLY"));
				rowData.put("mth_cy_sales", rs.getString("MTH_CY_SALES"));
				rowData.put("mth_ho_trgt",  rs.getString("MTH_HO_TRGT"));
				rowData.put("mth_gr", rs.getString("MTH_GR"));
               //add new property for  PMPM on 8/01/2015 by Birendra Pandey
                rowData.put("pmpm",    rs.getString("PMPM"));
			    rowData.put("pmpm_ly", rs.getString("PMPM_LY"));			       
			   //end of code by Birendra   
			    
				rawDataYTDSalesJson.put(count, rowData);
				count++;
				
			}
		}
			System.out.println("fetch Data for YTD Sales Graph rawjson====" + rawDataYTDSalesJson.toString());

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :SalesPersonSales:getYTDSalesGraphData:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataYTDSalesJson;
	}

	/** end of method getYTDSalesGraphData()**/
	
	
	/*** 
	 * Method Name      : getDivisionWiseGraph(String dataSourceName, String month,String divGrp)
	 * Servlet Name     : SalesPerDivGroupWiseServlet
	 * Metadataxml Name : divisionwise.xml,mthdivisionwise.xml
	 * Description      : This method returns  raw data for rendering the Division wise YTD sales Graph, Monthly Sales . 
	 * Graph Caption    :
	 *   YTD :            A] Division Wise Details : 
	 *                        	 1. Division Wise YTD Sales
	 *                    		 2. DataGrid for the same
	 *                   
	 *   Monthly :        A] Division Wise :
	 *                    		 1. Division wise Monthly Sales
	 *                    		 2. DataGrid for the same
	 *                  
	 * ***/
	@SuppressWarnings("unchecked")
	public JSONObject getDivisionWiseGraph(String dataSourceName,String month,String divGrp) throws RemoteException, ITMException
	{
		JSONObject rawDataYTDSalesJson = new JSONObject();
		JSONObject rowData = null;
		String sql         = "";
		String finYear     =""; 
		ResultSet rs       = null;
		PreparedStatement pstmt = null;
		Connection conn    = null;
		try
		{
			
		    if(month!=null && month.trim().length()>0 && divGrp!=null)
				{
				    /*conn = connDriver.getConnectDB(dataSourceName);
					connDriver = null;*/
			    	/*add new code for connection DB on dated:15062016 by Nikhil*/
					conn = getConnection();
					divGrp=divGrp.trim();
					System.out.println("Comming  month inside getDivisionWiseGraph ==="+month);					
					String selectedMonth  = month.substring(4, 6);				
					if(selectedMonth.trim().equalsIgnoreCase("01") ||selectedMonth.trim().equalsIgnoreCase("02") ||selectedMonth.trim().equalsIgnoreCase("03"))
					{
				    	finYear = String.valueOf(Integer.parseInt(month.substring(0, 4))-1)+"-"+month.substring(2, 4);
					}
					else
					{
						finYear = month.substring(0, 4)+"-"+ (String.valueOf(Integer.parseInt(month.substring(0, 4))+1)).substring(2, 4);
					}
					System.out.println("updates month and year from dcoding in getYTDSalesGraphData =="+month+"finYear =="+finYear);
					sql =" SELECT b.div_group,b.div_code,B.DIV_DESCR,( CASE WHEN SUBSTR('"+month+"' ,5,2) =3 THEN ROUND(0 ,1) "
                            +" WHEN SUBSTR('"+month+"' ,5,2)<3 THEN ROUND(SUM(a.hotrgt_annual_cy-a.sale_ytd_cy) "
                            +" /(12- SUBSTR('"+month+"' ,5,2)-9) /10000000,1) ELSE ROUND(SUM(a.hotrgt_annual_cy-a.sale_ytd_cy) "
                            +" /(12- SUBSTR('"+month+"' ,5,2)+3) /10000000,1) END ) AS REQD_MTHLY, "
                            +" ROUND(SUM(a.sale_ytd_cy)/ (CASE WHEN SUBSTR('"+month+"' ,5,2)<4 THEN "
                            +" SUBSTR('"+month+"' ,5,2)+9 ELSE SUBSTR('"+month+"' ,5,2)-3 END)/10000000,1) "
                            +" AS AVG_MTHLY,ROUND(SUM(a.sale_mth_cy)/10000000,1) AS MTH_CY_SALES, " 
                            +" ROUND(SUM(a.hotrgt_mth_cy)/10000000,1) AS MTH_HO_TRGT, " 
						    +" (CASE WHEN SUM (a.hotrgt_mth_cy)= 0 THEN 0 ELSE "
							+" (CASE WHEN ROUND(SUM (a.sale_mth_cy)/SUM (a.hotrgt_mth_cy)*100,1) <-200 THEN -200 "
						    +" WHEN ROUND(SUM (a.sale_mth_cy)/SUM (a.hotrgt_mth_cy)*100,1) >200 THEN 200 ELSE "
			                +" ROUND(SUM (a.sale_mth_cy)/SUM (a.hotrgt_mth_cy)*100,1) END) end) AS MTH_ACH_PER, "                           
					        +" (CASE WHEN SUM(a.sale_mth_ly)<>0 "
						    +" THEN (CASE WHEN ROUND(SUM(a.sale_mth_cy - a.sale_mth_ly)/SUM(a.sale_mth_ly)*100,1) <-200 THEN -200 "
			                +" WHEN ROUND(SUM(a.sale_mth_cy - a.sale_mth_ly)/SUM(a.sale_mth_ly)*100,1) >200 THEN 200 ELSE "
			                +" ROUND(SUM(a.sale_mth_cy - a.sale_mth_ly)/SUM(a.sale_mth_ly)*100,1) END )"
			                +" ELSE ROUND(0*100,1)  END) AS MTH_GR,"
                            +" ROUND(SUM(a.sale_ytd_cy)/10000000,1) "
                            +" AS YTD_CY_SALES,ROUND(SUM(a.sale_ytd_ly)/10000000,1) AS YTD_LY_SALES, "
                            +" ROUND(SUM(a.hotrgt_ytd_cy)/10000000,1) AS YTD_HO_TRGT,(CASE WHEN SUM(a.sale_ytd_ly)<>0 "
			                + " THEN (CASE WHEN ROUND(SUM(a.sale_ytd_cy - a.sale_ytd_ly)/SUM(a.sale_ytd_ly)*100,1) <-200 THEN -200 "
			                +" WHEN ROUND(SUM(a.sale_ytd_cy - a.sale_ytd_ly)/SUM(a.sale_ytd_ly)*100,1) >200 THEN 200 ELSE "
			                +" ROUND(SUM(a.sale_ytd_cy - a.sale_ytd_ly)/SUM(a.sale_ytd_ly)*100,1) END )"              
			                +" ELSE ROUND(0*100,1)  END) AS YTD_GR,ROUND(SUM(a.sale_Qrt1_cy)/10000000,1) AS Q1, " 
                            +" ROUND(SUM(a.sale_Qrt2_cy)/10000000,1) AS Q2,ROUND(SUM(a.sale_Qrt3_cy)/10000000,1) AS Q3, " 
                            +" ROUND(SUM(a.sale_Qrt4_cy)/10000000,1) AS Q4,ROUND(SUM(a.sale_ytd_cy)/100000/"
                            +" MAX(c.psr)/ (CASE WHEN SUBSTR('"+month+"' ,5,2)<4 THEN SUBSTR('"+month+"' ,5,2)+9 "
                            +" ELSE SUBSTR('"+month+"' ,5,2)-3 END) ,1) AS PMPM,SUM(b.pmpm_ly) AS PMPM_LY, "
                            +" ROUND(SUM(a.sale_ytd_cy-a.hotrgt_ytd_cy)/10000000,1) AS YTD_ACH_EXTRA, " 
                            +" CASE WHEN SUM (a.hotrgt_YTD_cy) = 0 THEN 0 ELSE "
	                        +" (CASE WHEN ROUND(SUM (a.sale_YTD_cy)/SUM (a.hotrgt_YTD_cy)*100,1) <-200 THEN -200 "
				            +" WHEN ROUND(SUM (a.sale_YTD_cy)/SUM (a.hotrgt_YTD_cy)*100,1) >200 THEN 200 ELSE "
				            +" ROUND(SUM (a.sale_YTD_cy)/SUM (a.hotrgt_YTD_cy)*100,1) END) END AS YTD_ACH_PER, "                         
				            +" (CASE WHEN SUM(a.sale_ytd_cy)<>0 THEN ROUND(SUM(a.retu_ytd_cy)/" 
                            +" SUM(a.sale_ytd_cy)*100,1) ELSE ROUND(0*100,1) END) AS RETU_YTD_PRCT "
                            +" FROM (SELECT dwh.fin_year , dwh.item_ser,SUM(sale_mth_cy) AS sale_mth_cy, "
                            +" SUM(sale_mth_ly) AS sale_mth_ly,SUM(trgt_mth_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0))"
                            +" /100) AS hotrgt_mth_cy,SUM(sale_YTD_cy) AS sale_YTD_cy, "
                            +" SUM(sale_YTD_ly) AS sale_YTD_ly,SUM(trgt_YTD_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) "
                            +" /100) AS hotrgt_ytd_cy,SUM(sale_Qrt1_cy) AS sale_Qrt1_cy,SUM(sale_Qrt2_cy) AS sale_Qrt2_cy, " 
                            +" SUM(sale_Qrt3_cy) AS sale_Qrt3_cy,SUM(sale_Qrt4_cy) AS sale_Qrt4_cy, " 
                            +" SUM(trgt_annual_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) "
                            +" AS hotrgt_annual_cy,SUM(retu_ytd_cy) AS retu_ytd_cy "
                            +" FROM(SELECT fin_year , SM_SALES_SUMM_WIDE.item_ser," 
                            +" sales_item.item_sub_group AS sub_grp,(CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' "
                            +" THEN SUM(CY_SALE_MTH_APR) WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_SALE_MTH_MAY) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(CY_SALE_MTH_JUN) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_SALE_MTH_JUL) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_SALE_MTH_AUG) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(CY_SALE_MTH_SEP) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_SALE_MTH_OCT) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(CY_SALE_MTH_NOV) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(CY_SALE_MTH_DEC) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_SALE_MTH_JAN) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(CY_SALE_MTH_FEB) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(CY_SALE_MTH_MAR) END ) AS sale_mth_cy, "
                            +" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(LY_SALE_MTH_APR) " 
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(LY_SALE_MTH_MAY) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(LY_SALE_MTH_JUN) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(lY_SALE_MTH_JUL) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(lY_SALE_MTH_AUG) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(lY_SALE_MTH_SEP) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(lY_SALE_MTH_OCT) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(lY_SALE_MTH_NOV) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(lY_SALE_MTH_DEC) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(lY_SALE_MTH_JAN) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(lY_SALE_MTH_FEB) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(lY_SALE_MTH_MAR) END ) AS sale_mth_ly,"
                            +" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(FLD_TRGT_MTH_APR) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(FLD_TRGT_MTH_MAY)"
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(FLD_TRGT_MTH_JUN)"
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(FLD_TRGT_MTH_JUL) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(FLD_TRGT_MTH_AUG) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(FLD_TRGT_MTH_SEP) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(FLD_TRGT_MTH_OCT) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(FLD_TRGT_MTH_NOV) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(FLD_TRGT_MTH_DEC) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(FLD_TRGT_MTH_JAN) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(FLD_TRGT_MTH_FEB) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(FLD_TRGT_MTH_MAR) END ) "
                            +" AS trgt_mth_cy, "
                            +" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(CY_SALE_YTD_JUN) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(CY_SALE_YTD_SEP) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(CY_SALE_YTD_NOV) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(CY_SALE_YTD_DEC) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(CY_SALE_YTD_FEB) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(CY_SALE_YTD_MAR) END ) "
                            +" AS sale_YTD_cy, " 
                            +" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(lY_SALE_YTD_APR) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(lY_SALE_YTD_MAY) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(lY_SALE_YTD_JUN) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(lY_SALE_YTD_JUL) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(lY_SALE_YTD_AUG) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(lY_SALE_YTD_SEP) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(lY_SALE_YTD_OCT) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(lY_SALE_YTD_NOV) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(lY_SALE_YTD_DEC) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(lY_SALE_YTD_JAN) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(lY_SALE_YTD_FEB) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(lY_SALE_YTD_MAR) END ) "
                            +" AS sale_YTD_ly," 
                            +" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(FLD_TRGT_YTD_APR) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(FLD_TRGT_YTD_MAY) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(FLD_TRGT_YTD_JUN) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(FLD_TRGT_YTD_JUL) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(FLD_TRGT_YTD_AUG) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(FLD_TRGT_YTD_SEP) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(FLD_TRGT_YTD_OCT) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(FLD_TRGT_YTD_NOV) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(FLD_TRGT_YTD_DEC) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(FLD_TRGT_YTD_JAN) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(FLD_TRGT_YTD_FEB) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(FLD_TRGT_YTD_MAR) END ) "
                            +" AS trgt_YTD_cy, "
                            +" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) "
                            +" ELSE SUM(CY_SALE_YTD_JUN)  END ) AS sale_Qrt1_cy, "
                            +" (CASE WHEN SUBSTR('"+month+"' ,5,2) >='04' AND  SUBSTR('"+month+"' ,5,2) <='06' "
                            +" THEN 0 WHEN SUBSTR('"+month+"' ,5,2)='07' THEN SUM(CY_SALE_YTD_JUL) - SUM(CY_SALE_YTD_JUN) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) - SUM(CY_SALE_YTD_JUN) "
                            +" ELSE  SUM(CY_SALE_YTD_SEP) - SUM(CY_SALE_YTD_JUN) END ) AS sale_Qrt2_cy,"
                            +" (CASE WHEN SUBSTR('"+month+"' ,5,2) >='04' AND  SUBSTR('"+month+"' ,5,2) <='09' "
                            +" THEN 0 WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) - "
                            +" SUM(CY_SALE_YTD_SEP) WHEN SUBSTR('"+month+"' ,5,2) ='11' "
                            +" THEN SUM(CY_SALE_YTD_NOV) - SUM(CY_SALE_YTD_SEP) ELSE "
                            +" SUM(CY_SALE_YTD_DEC) - SUM(CY_SALE_YTD_SEP) END ) AS sale_Qrt3_cy, " 
                            +" (CASE WHEN SUBSTR('"+month+"' ,5,2) >='04' AND  SUBSTR('"+month+"' ,5,2) <='12' "
                            +" THEN 0 WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) -"
                            +" SUM(CY_SALE_YTD_DEC) WHEN SUBSTR('"+month+"' ,5,2) ='02' "
                            +" THEN SUM(CY_SALE_YTD_FEB) - SUM(CY_SALE_YTD_DEC) ELSE "
                            +" SUM(CY_SALE_YTD_MAR) - SUM(CY_SALE_YTD_DEC) END ) AS sale_Qrt4_cy,"
                            +" SUM(FLD_TRGT_YTD_MAR) AS trgt_annual_cy, "
                            +" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(CY_RETU_YTD_APR) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_RETU_YTD_MAY) " 
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(CY_RETU_YTD_JUN) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_RETU_YTD_JUL) " 
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_RETU_YTD_AUG) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(CY_RETU_YTD_SEP) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_RETU_YTD_OCT) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(CY_RETU_YTD_NOV) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(CY_RETU_YTD_DEC) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_RETU_YTD_JAN) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(CY_RETU_YTD_FEB) "
                            +" WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(CY_RETU_YTD_MAR) END ) "
                            +" AS retu_ytd_cy "
                            +" FROM SM_SALES_SUMM_WIDE, sales_item " 
                            +" WHERE trim(fin_year)= (CASE WHEN SUBSTR('"+month+"' ,5,2)<4 "
                            +" THEN SUBSTR('"+month+"' -100 ,1,4)||'-'||SUBSTR('"+month+"' ,3,2) " 
                            +" ELSE SUBSTR('"+month+"' ,1,4)||'-' || SUBSTR('"+month+"' +100,3,2) END) "
                            +" AND '"+month+"' =    '"+month+"' " 
                            +" AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code "
                            +" AND sales_item.item_sub_group NOT IN ('CU','BJ') "
                            +" GROUP BY fin_year ,SM_SALES_SUMM_WIDE.item_ser, sales_item.item_sub_group " 
                            +" ) dwh,SM_SALES_BRAND_MST brnd  WHERE brnd.brand_code(+) = dwh.sub_grp " 
                            +" AND brnd.div_code(+) = dwh.item_ser AND brnd.fin_year(+) = dwh.fin_year " 
                            +" GROUP BY dwh.fin_year, dwh.item_ser ) a, " 
                            +" SM_SALES_DIV_MST b,( SELECT finyr, table_no, SUM(psr) AS psr " 
                            +" FROM ( SELECT SUBSTR(version_id,3,4) AS finyr ,table_no, pool_code, "
                            +" TO_NUMBER(MAX(NO_PSR_TERR)) AS PSR FROM starclub.emp_sales "
                            +" WHERE LEVEL_NO = 4 GROUP BY SUBSTR(version_id,3,4) ,table_no, pool_code ) "
                            +" GROUP BY finyr, table_no ) c "
                            +" WHERE trim(a.item_ser)=trim(b.div_code) AND b.fin_year=a.fin_year "
                            +" AND trim(a.item_ser)=trim(c.table_no) "
                            +" AND c.finyr = SUBSTR(a.fin_year,3,2)||SUBSTR(a.fin_year,6,2) "
                            +" AND b.div_group <> 'OTHERS' AND b.div_group ='"+ divGrp + "' GROUP BY b.div_group,b.div_code,B.DIV_DESCR ORDER BY ROUND(SUM(a.sale_ytd_cy)/10000000,1) desc";
								pstmt = conn.prepareStatement(sql);
								rs = pstmt.executeQuery();
								int count = 0;
								
								while (rs.next())
								{
									rowData = new JSONObject();
									//this part will used for YTD sale graph
									rowData.put("div_code", checkNull(rs.getString("div_code")));
									rowData.put("div_descr", checkNull(rs.getString("DIV_DESCR")));
									rowData.put("ytd_cy_sales", rs.getString("YTD_CY_SALES"));
									rowData.put("ytd_gr", rs.getString("YTD_GR"));
									rowData.put("ytd_ach_extra", rs.getString("YTD_ACH_EXTRA"));
									//add new property for YTD on 7/01/2015 by Birendra Pandey
                                    rowData.put("ytd_ly_sales", rs.getString("YTD_LY_SALES"));
									rowData.put("ytd_ho_trgt", rs.getString("YTD_HO_TRGT"));									
                                    rowData.put("retu_ytd_prct", rs.getString("RETU_YTD_PRCT"));
									//Add new new property on date 7-Jan-15 by Birendra Pandey for Month sales graph
									rowData.put("reqd_mthly", rs.getString("REQD_MTHLY"));
									rowData.put("avg_mthly", rs.getString("AVG_MTHLY"));
									rowData.put("mth_cy_sales", rs.getString("MTH_CY_SALES"));
									rowData.put("mth_ho_trgt", rs.getString("MTH_HO_TRGT"));
									rowData.put("mth_ach_per", rs.getString("MTH_ACH_PER"));
									rowData.put("mth_gr", rs.getString("MTH_GR"));
                                   //add new property for  PMPM on 7/01/2015 by Birendra Pandey
                                    rowData.put("pmpm", rs.getString("PMPM"));
								    rowData.put("pmpm_ly", rs.getString("PMPM_LY"));
								    rowData.put("ytd_ach_per", rs.getString("YTD_ACH_PER")); 
								   //end of code by Birendra                                   
									rawDataYTDSalesJson.put(count, rowData);
									count++;
								}
							}
							System.out.println("fetch Data for YTD Sales Graph rawjson====" + rawDataYTDSalesJson.toString());
			
					} catch (Exception e)
					{
					e.printStackTrace();
					throw new ITMException(e);
					} finally
					{
					try
					{
						if (conn != null)
						{
							if (rs != null)
							rs.close();
							rs = null;
							if (pstmt != null)
							pstmt.close();
							pstmt = null;
							conn.close();
							conn = null;
						}
						conn = null;
					} catch (Exception d)
					{
						d.printStackTrace();
						System.out.println("Exception in :SalesPersonSales:getYTDSalesGraphData:" + d.getMessage());
						throw new ITMException(d);
					}
			}
			return rawDataYTDSalesJson;
	}
	
    /**end of method getDivisionWiseGraph() **/
	
	
	 /*** 
		 * Method Name      : getTopBrandYTD(String dataSourceName, String month,String divDescr)
		 * Servlet Name     : TopBrandYTDServlet
		 * Metadataxml Name : toptenbrand.xml
		 * Description      : This method returns  raw data for rendering the Top 10 Brands Details. 
		 * Graph Caption    :
		 *             
		 *                    1. Top 10 Brand Details 
		 *                    2. DataGrid for the same
		 *             
		 * ***/	
	@SuppressWarnings("unchecked")
	public JSONObject getTopBrandYTD(String dataSourceName,String month,String divDescr) throws RemoteException, ITMException
	{
		JSONObject rawDataYTDSalesJson = new JSONObject();
		JSONObject rowData = null;
		String sql         = "";
		String finYear     = ""; 
		ResultSet rs       = null;
		PreparedStatement pstmt = null;
		Connection conn    = null;
		try
		{
		    if(month!=null && month.trim().length()>0 && divDescr!=null)
				{
				    /*conn = connDriver.getConnectDB(dataSourceName);
					connDriver = null;*/
			    	/*add new code for connection DB on dated:15062016 by Nikhil*/
					conn = getConnection();
					divDescr=divDescr.trim();
					System.out.println("Comming  month inside getTopBrandYTD ==="+month);					
					String selectedMonth  = month.substring(4, 6);				
					if(selectedMonth.trim().equalsIgnoreCase("01") ||selectedMonth.trim().equalsIgnoreCase("02") ||selectedMonth.trim().equalsIgnoreCase("03"))
					{
				    	finYear = String.valueOf(Integer.parseInt(month.substring(0, 4))-1)+"-"+month.substring(2, 4);
					}
					else
					{
						finYear = month.substring(0, 4)+"-"+ (String.valueOf(Integer.parseInt(month.substring(0, 4))+1)).substring(2, 4);
					}
					System.out.println("select Sql for TopBrandWiseGraph =="+month+"finYear =="+finYear);
					//Note removed this section and build new sql swati
					sql ="SELECT sr_no, brand_name, divmst.div_descr, "
							+ "ROUND(trgt_ytd_cy/10000000,2) AS trgt_ytd,"
							+ "ROUND(hotrgt_ytd_cy/10000000,2) AS hotrgt_ytd_cy,"
							+ "ROUND(sale_YTD_cy/10000000,2) AS sale_YTD_cy, "
							+ "ROUND(sale_YTD_ly/10000000,2) AS sale_YTD_ly,"
                            +" CASE WHEN NVL(hotrgt_ytd_cy,0) = 0 THEN 0 ELSE "
	                       +" (CASE WHEN ROUND(sale_YTD_cy/hotrgt_ytd_cy * 100,1) <-200 THEN -200 "
			               +" WHEN ROUND(sale_YTD_cy/hotrgt_ytd_cy * 100,1) >200 THEN 200 ELSE "
			               +" ROUND(sale_YTD_cy/hotrgt_ytd_cy * 100,1) END) END AS ho_ach_prcnt, "							
			               + "(CASE WHEN NVL(sale_YTD_ly,0) <> 0 "
						   +" THEN (CASE WHEN ROUND((sale_YTD_cy -sale_YTD_ly)/ sale_YTD_ly* 100,1) <-200 THEN -200 "
			               +" WHEN ROUND((sale_YTD_cy -sale_YTD_ly)/ sale_YTD_ly* 100,1) >200 THEN 200 ELSE "
			                +" ROUND((sale_YTD_cy -sale_YTD_ly)/ sale_YTD_ly* 100,1) END )"              
			                +" ELSE ROUND(0*100,1)  END) AS gr_prcnt, "						  
 							+ "c.psr AS NO_OF_SO,"
							+ "ROUND(DWH.sale_ytd_cy/10000000/c.psr/(CASE WHEN SUBSTR('"+month+"',5,2)<4 	THEN SUBSTR('"+month+"',5,2)+9 ELSE SUBSTR('"+month+"',5,2)-3 END) ,2) AS PMPM,"
							+ "ROUND(terr100/totterr*100,1) AS terr100prcnt"
							+ " FROM ("
							+ "SELECT row_number() OVER( ORDER BY sale_YTD_cy DESC ) AS sr_no,"
							+ "fin_year, item_ser, sub_grp AS brand_name,"
							+ "sale_YTD_cy, sale_YTD_ly, trgt_YTD_cy, hotrgt_ytd_cy,"
							+ "totterr, terr100"
							+ " FROM ("
							+ "SELECT fin_year, item_ser, sub_grp,"
							+ " SUM(sale_YTD_cy) AS sale_YTD_cy, SUM(sale_YTD_ly) AS sale_YTD_ly,"
							+ " SUM(trgt_YTD_cy) AS trgt_YTD_cy, SUM(hotrgt_ytd_cy) AS hotrgt_ytd_cy, SUM(terrcnt) AS totterr, SUM(terr100cnt) AS terr100" 
							+ " FROM("
							+ " SELECT dwh.fin_year , dwh.item_ser, "
							+ " dwh.grp_nm AS sub_grp,dwh.terr_code, " 
							+ " SUM(sale_YTD_cy) AS sale_YTD_cy, "
							+ " SUM(sale_YTD_ly) AS sale_YTD_ly, "
							+ " SUM(trgt_YTD_cy) AS trgt_YTD_cy,"
							+ " ROUND(SUM(trgt_YTD_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100),2) AS hotrgt_ytd_cy, "
							+ " 1 AS terrcnt,"
							+ " (CASE WHEN SUM(trgt_YTD_cy) =0 THEN 1 WHEN ROUND(SUM( sale_YTD_cy) / SUM(trgt_YTD_cy * " 
							+ " (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0))/100) *100,1)>= 100 "
							+ "  THEN 1 ELSE 0 END ) AS terr100cnt "
							+ " FROM (   "
							+ " SELECT fin_year , SM_SALES_SUMM_WIDE.item_ser, "
							+ "  sales_item.item_sub_group AS sub_grp, sales_item.item_sub_group_descr AS grp_nm,"
							+ "  SM_SALES_SUMM_WIDE.terr_code AS terr_code," 
							+ "  (CASE WHEN SUBSTR('"+month+"',5,2) ='04' THEN SUM(CY_SALE_YTD_APR) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(CY_SALE_YTD_JUN) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(CY_SALE_YTD_SEP) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(CY_SALE_YTD_NOV) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(CY_SALE_YTD_DEC) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(CY_SALE_YTD_FEB) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(CY_SALE_YTD_MAR) END ) AS sale_YTD_cy, "
							+ "  (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(lY_SALE_YTD_APR) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(lY_SALE_YTD_MAY) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(lY_SALE_YTD_JUN) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(lY_SALE_YTD_JUL) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(lY_SALE_YTD_AUG) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(lY_SALE_YTD_SEP) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(lY_SALE_YTD_OCT) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(lY_SALE_YTD_NOV) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(lY_SALE_YTD_DEC) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(lY_SALE_YTD_JAN) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(lY_SALE_YTD_FEB) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(lY_SALE_YTD_MAR) END ) AS sale_YTD_ly, "
							+ "  (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(FLD_TRGT_YTD_APR) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(FLD_TRGT_YTD_MAY) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(FLD_TRGT_YTD_JUN) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(FLD_TRGT_YTD_JUL) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(FLD_TRGT_YTD_AUG) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(FLD_TRGT_YTD_SEP) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(FLD_TRGT_YTD_OCT) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(FLD_TRGT_YTD_NOV) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(FLD_TRGT_YTD_DEC) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(FLD_TRGT_YTD_JAN) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(FLD_TRGT_YTD_FEB) "
							+ "  WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(FLD_TRGT_YTD_MAR) END ) AS trgt_YTD_cy "
							+ "  FROM SM_SALES_SUMM_WIDE, sales_item "
							+ "  WHERE trim(fin_year)= (CASE WHEN SUBSTR('"+month+"' ,5,2)<4 THEN SUBSTR('"+month+"' -100 ,1,4)||'-'||SUBSTR('"+month+"' ,3,2) "
							+ "  ELSE SUBSTR('"+month+"' ,1,4)||'-' || SUBSTR('"+month+"' +100,3,2) END) "
							+ " AND '"+month+"' =   '"+month+"'"
							+ " AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code " 
							+ " AND sales_item.item_sub_group NOT IN ('CU','BJ') "
							+ " AND sales_item.item_SER_DESCR = '"+ divDescr + "'"
							+ " GROUP BY fin_year ,SM_SALES_SUMM_WIDE.item_ser, sales_item.item_sub_group," 
							+ " sales_item.item_sub_group_descr, SM_SALES_SUMM_WIDE.terr_code 	"
							+ " )dwh,SM_SALES_BRAND_MST brnd"
							+ "  WHERE brnd.brand_code(+) = dwh.sub_grp "
							+ "  AND brnd.div_code(+) = dwh.item_ser "
							+ "  AND brnd.fin_year(+) = dwh.fin_year "
							+ "  AND dwh.sale_ytd_cy+ dwh.trgt_YTD_cy <>0 "
							+ "  GROUP BY dwh.fin_year, dwh.item_ser, dwh.grp_nm,dwh.terr_code  )"
							+ " GROUP BY fin_year, item_ser, sub_grp )  "
							+ " ) dwh, SM_SALES_DIV_MST divmst, "
							+ " ( "
							+  " SELECT finyr, table_no, SUM(psr) AS psr" 
							+ " FROM (" 
							+ " SELECT SUBSTR(version_id,3,4) AS finyr ,table_no, pool_code,TO_NUMBER(MAX(NO_PSR_TERR)) AS PSR "
							+ " FROM starclub.emp_sales "
							+ " WHERE  " 
							+ " LEVEL_NO = 4 " 
							+ " GROUP BY SUBSTR(version_id,3,4) ,table_no, pool_code )"
							+ " GROUP BY finyr, table_no "
							+ " ) c "
							+ " WHERE dwh.item_ser= divmst.div_code " 
							+ " AND trim(DWH.item_ser)=trim(c.table_no) "
							+ " AND TRIM(divmst.div_descr) =TRIM('"+ divDescr + "')"
							+ " AND c.finyr = SUBSTR(DWH.fin_year,3,2)||SUBSTR(DWH.fin_year,6,2) " 
							+ " AND dwh.fin_year= divmst.fin_year "
							+ " AND dwh.sr_no <=10  ORDER BY sr_no";
					

					pstmt = conn.prepareStatement(sql);
					rs = pstmt.executeQuery();
					int count = 0;
								
					while (rs.next())
						{
							rowData = new JSONObject();	
							//add new proprety
							rowData.put("ytd_ho_trgt", rs.getString("hotrgt_ytd_cy"));								
							rowData.put("brand_name", checkNull(rs.getString("brand_name")));
							rowData.put("div_descr", checkNull(rs.getString("div_descr")));
							rowData.put("sale_ytd_cy", rs.getString("sale_YTD_cy"));
							rowData.put("gr_prcnt", rs.getString("gr_prcnt"));
							rowData.put("ho_ach_prcnt", rs.getString("ho_ach_prcnt"));
                            rowData.put("pmpm", rs.getString("PMPM"));						    
							rawDataYTDSalesJson.put(count, rowData);
							count++;
							
							
						}
				}
					System.out.println("fetch Data for getTopBrandYTD rawjson====" + rawDataYTDSalesJson.toString());
			
					} catch (Exception e)
					{
					e.printStackTrace();
					throw new ITMException(e);
					} finally
					{
					try
					{
						if (conn != null)
						{
							if (rs != null)
							rs.close();
							rs = null;
							if (pstmt != null)
							pstmt.close();
							pstmt = null;
							conn.close();
							conn = null;
						}
						conn = null;
					} catch (Exception d)
					{
						d.printStackTrace();
						System.out.println("Exception in :SalesPersonSales:getTopBrandYTD:" + d.getMessage());
						throw new ITMException(d);
					}
			}
			return rawDataYTDSalesJson;
	}
	/**end of method getTopBrandYTD() **/
	
	 /*** 
		 * Method Name      : getTopBrandMTH(String dataSourceName, String month,String divGrp)
		 * Servlet Name     : TopBrandMTHServlet
		 * Metadataxml Name : mnthtoptenbrand.xml
		 * Description      : This method returns  raw data for rendering the top ten Monthly Graph. 
		 * Graph Caption    :
		 *                    1. Division-Brand wise Monthly Sales
		 *                    2. DataGrid for the same
		 *             
		 * ***/
	@SuppressWarnings("unchecked")
	public JSONObject getTopBrandMTH(String dataSourceName,String month,String divDescr) throws RemoteException, ITMException
	{
		JSONObject rawDataYTDSalesJson = new JSONObject();
		JSONObject rowData = null;
		String sql         = "";
		String finYear     = ""; 
		ResultSet rs       = null;
		PreparedStatement pstmt = null;
		Connection conn    = null;
		try
		{
		    if(month!=null && month.trim().length()>0 && divDescr!=null)
				{
				    /*conn = connDriver.getConnectDB(dataSourceName);
					connDriver = null;*/
			    	/*add new code for connection DB on dated:15062016 by Nikhil*/
					conn = getConnection();
					divDescr=divDescr.trim();
					System.out.println("Comming  month inside getTopBrandMTH ==="+month);					
					String selectedMonth  = month.substring(4, 6);				
					if(selectedMonth.trim().equalsIgnoreCase("01") ||selectedMonth.trim().equalsIgnoreCase("02") ||selectedMonth.trim().equalsIgnoreCase("03"))
					{
				    	finYear = String.valueOf(Integer.parseInt(month.substring(0, 4))-1)+"-"+month.substring(2, 4);
					}
					else
					{
						finYear = month.substring(0, 4)+"-"+ (String.valueOf(Integer.parseInt(month.substring(0, 4))+1)).substring(2, 4);
					}
					System.out.println("select Sql for getTopBrandMTH =="+month+"finYear =="+finYear);
					//Note removed this section and build new sql swati
															
					sql  = " SELECT sr_no, brand_name, divmst.div_descr, "
							+ "	ROUND(trgt_MTH_cy/10000000,2) AS trgt_MTH, "
							+ "	ROUND(hotrgt_MTH_cy/10000000,2) AS hotrgt_MTH_cy, "
							+ " ROUND(sale_MTH_cy/10000000,2) AS sale_MTH_cy," 
							+ "	ROUND(sale_MTH_ly/10000000,2) AS sale_MTH_ly, "
							+ " (CASE WHEN NVL(hotrgt_MTH_cy,0) <> 0 THEN "
	+" (CASE WHEN ROUND(sale_MTH_cy/hotrgt_MTH_cy * 100,1) <-200 THEN -200 "
              +" WHEN ROUND(sale_MTH_cy/hotrgt_MTH_cy * 100,1) >200 THEN 200 ELSE "
              +" ROUND(sale_MTH_cy/hotrgt_MTH_cy * 100,1) END ) "
			  +" ELSE ROUND(0*100,1) END ) AS ho_ach_prcnt, " 	
							+ " (CASE WHEN NVL(sale_MTH_ly,0) <> 0 "
              +" THEN (CASE WHEN ROUND((sale_MTH_cy -sale_MTH_ly)/ sale_MTH_ly* 100,1) <-200 THEN -200 "
              +" WHEN ROUND((sale_MTH_cy -sale_MTH_ly)/ sale_MTH_ly* 100,1) >200 THEN 200 ELSE "
              +" ROUND((sale_MTH_cy -sale_MTH_ly)/ sale_MTH_ly* 100,1) END )"              
                            +" ELSE ROUND(0*100,1)  END) AS gr_prcnt, "							
							+ " c.psr AS NO_OF_SO, "
							+ " ROUND(DWH.sale_MTH_cy/10000000/c.psr/ "
							+ " (CASE WHEN SUBSTR('"+month+"',5,2)<4 THEN SUBSTR('"+month+"' ,5,2)+9 ELSE SUBSTR('"+month+"' ,5,2)-3 END) "
							+ " ,2) AS PMPM, "
							+ "	ROUND(terr100/totterr*100,1) AS terr100prcnt "
							+ " FROM ( "
							+ " SELECT row_number() OVER( ORDER BY sale_MTH_cy DESC ) AS sr_no, "
							+ " fin_year, item_ser, sub_grp AS brand_name, "
							+ "	sale_MTH_cy, sale_MTH_ly, trgt_MTH_cy, hotrgt_MTH_cy, "
							+ " totterr, terr100 "
							+ " FROM ( "
							+ " SELECT fin_year, item_ser, sub_grp, "
							+ " SUM(sale_MTH_cy) AS sale_MTH_cy, SUM(sale_MTH_ly) AS sale_MTH_ly, "
							+ "	SUM(trgt_MTH_cy) AS trgt_MTH_cy, "
							+ "	SUM(hotrgt_MTH_cy) AS hotrgt_MTH_cy,  "
							+ " SUM(terrcnt) AS totterr, SUM(terr100cnt) AS terr100 "
							+ " FROM( "
							+ " SELECT dwh.fin_year , dwh.item_ser, "
							+ "	dwh.grp_nm AS sub_grp,dwh.terr_code, "
							+ " SUM(sale_MTH_cy) AS sale_MTH_cy,  "
							+ "	SUM(sale_MTH_ly) AS sale_MTH_ly,  "
							+ "	SUM(trgt_MTH_cy) AS trgt_MTH_cy, "
							+ " ROUND(SUM(trgt_MTH_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100),2) AS hotrgt_MTH_cy,  "
							+ " 1 AS terrcnt, "
							+ " (CASE WHEN SUM(trgt_MTH_cy) =0 THEN 1 "
							+ " WHEN ROUND(SUM( sale_MTH_cy) / SUM(trgt_MTH_cy *  (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0))/100) *100,1)>= 100 THEN 1 ELSE 0 END ) AS terr100cnt "
							+ " FROM (   "
							+ " SELECT fin_year , SM_SALES_SUMM_WIDE.item_ser, "
							+ " sales_item.item_sub_group AS sub_grp, sales_item.item_sub_group_descr AS grp_nm, "
							+ " SM_SALES_SUMM_WIDE.terr_code AS terr_code, "
							+ " (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(CY_SALE_MTH_APR) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_SALE_MTH_MAY)  "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(CY_SALE_MTH_JUN)  "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_SALE_MTH_JUL)  "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_SALE_MTH_AUG)  "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(CY_SALE_MTH_SEP)  "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_SALE_MTH_OCT)  "
							+ "	WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(CY_SALE_MTH_NOV) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(CY_SALE_MTH_DEC)  "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_SALE_MTH_JAN)  "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(CY_SALE_MTH_FEB)  "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(CY_SALE_MTH_MAR) END ) AS sale_MTH_cy,  "
							+ " (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(lY_SALE_MTH_APR)  "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(lY_SALE_MTH_MAY)  "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(lY_SALE_MTH_JUN)  "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(lY_SALE_MTH_JUL) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(lY_SALE_MTH_AUG)  "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(lY_SALE_MTH_SEP) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(lY_SALE_MTH_OCT) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(lY_SALE_MTH_NOV) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(lY_SALE_MTH_DEC) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(lY_SALE_MTH_JAN) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(lY_SALE_MTH_FEB) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(lY_SALE_MTH_MAR) END ) AS sale_MTH_ly, "
							+ " (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(FLD_TRGT_MTH_APR) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(FLD_TRGT_MTH_MAY) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(FLD_TRGT_MTH_JUN) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(FLD_TRGT_MTH_JUL) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(FLD_TRGT_MTH_AUG) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(FLD_TRGT_MTH_SEP) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(FLD_TRGT_MTH_OCT) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(FLD_TRGT_MTH_NOV) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(FLD_TRGT_MTH_DEC) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(FLD_TRGT_MTH_JAN) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(FLD_TRGT_MTH_FEB) "
							+ " WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(FLD_TRGT_MTH_MAR) END ) AS trgt_MTH_cy  "
							+ " FROM SM_SALES_SUMM_WIDE, sales_item "
							+ " WHERE trim(fin_year)= (CASE WHEN SUBSTR('"+month+"' ,5,2)<4 THEN SUBSTR('"+month+"' -100 ,1,4)||'-'||SUBSTR('"+month+"' ,3,2) " 
							+ " ELSE SUBSTR('"+month+"' ,1,4)||'-' || SUBSTR('"+month+"' +100,3,2) END) "
							+ " AND '"+month+"' =	'"+month+"' "
							+ " AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code "
							+ " AND sales_item.item_sub_group NOT IN ('CU','BJ')"
							+ " AND SM_SALES_SUMM_WIDE.TERR_CODE NOT IN('COGS','EXPNS') "
							+ " AND sales_item.item_SER_DESCR = '"+ divDescr + "'"
							+ " GROUP BY fin_year ,SM_SALES_SUMM_WIDE.item_ser, sales_item.item_sub_group, "
							+ " sales_item.item_sub_group_descr, SM_SALES_SUMM_WIDE.terr_code "
							+ " ) 	 dwh,     SM_SALES_BRAND_MST brnd "
							+ " WHERE brnd.brand_code(+) = dwh.sub_grp "
							+ " AND brnd.div_code(+) = dwh.item_ser "
							+ " AND brnd.fin_year(+) = dwh.fin_year "
							+ " AND dwh.sale_MTH_cy+ dwh.trgt_MTH_cy <>0  "
							+ " GROUP BY dwh.fin_year, dwh.item_ser, dwh.grp_nm,dwh.terr_code "
							+ " ) "
							+ " GROUP BY fin_year, item_ser, sub_grp"
							+ " ) "
							+ " ) dwh, "
							+ " SM_SALES_DIV_MST divmst,"
							+ " ( "
							+ " SELECT finyr, table_no, SUM(psr) AS psr "
							+ " FROM ("
							+ "SELECT SUBSTR(version_id,3,4) AS finyr ,table_no, pool_code,TO_NUMBER(MAX(NO_PSR_TERR)) AS PSR"
							+ " FROM starclub.emp_sales"
							+ " WHERE "
							+ " LEVEL_NO = 4 "
							+ " GROUP BY SUBSTR(version_id,3,4) ,table_no, pool_code)"
							+ " GROUP BY finyr, table_no"
							+ ") c "
							+ " WHERE dwh.item_ser= divmst.div_code "
							+ " AND trim(DWH.item_ser)=trim(c.table_no) "
							+ " AND TRIM(divmst.div_descr) =TRIM('"+ divDescr + "')"
							+ " AND c.finyr = SUBSTR(DWH.fin_year,3,2)||SUBSTR(DWH.fin_year,6,2) "
							+ " AND dwh.fin_year= divmst.fin_year "
							+ " AND dwh.sr_no <= 10 "
							+ " ORDER BY sr_no  ";


							//Note end removed this section and build new sql swati

					pstmt = conn.prepareStatement(sql);
					rs = pstmt.executeQuery();
					int count = 0;
								
					while (rs.next())
						{
							rowData = new JSONObject();
							//Add new code												 
							rowData.put("mth_ho_trgt", rs.getString("hotrgt_MTH_cy"));	
							rowData.put("brand_name", checkNull(rs.getString("brand_name")));
							rowData.put("div_descr", rs.getString("div_descr"));
							rowData.put("trgt_mth", rs.getString("trgt_MTH"));
							rowData.put("sale_mth_cy", rs.getString("sale_MTH_cy"));
							rowData.put("sale_mth_ly", rs.getString("sale_MTH_ly"));
							rowData.put("ho_ach_prcnt", rs.getString("ho_ach_prcnt"));
							rowData.put("gr_prcnt", rs.getString("gr_prcnt"));
							rowData.put("no_of_so", rs.getString("NO_OF_SO"));
							rowData.put("pmpm", rs.getString("PMPM"));
							rowData.put("terr100prcnt", rs.getString("terr100prcnt"));
							rawDataYTDSalesJson.put(count, rowData);
							count++;
						}
				}
					System.out.println("fetch Data for getTopBrandMTH rawjson====" + rawDataYTDSalesJson.toString());
			
					} catch (Exception e)
					{
					e.printStackTrace();
					throw new ITMException(e);
					} finally
					{
					try
					{
						if (conn != null)
						{
							if (rs != null)
							rs.close();
							rs = null;
							if (pstmt != null)
							pstmt.close();
							pstmt = null;
							conn.close();
							conn = null;
						}
						conn = null;
					} catch (Exception d)
					{
						d.printStackTrace();
						System.out.println("Exception in :SalesPersonSales:getTopBrandMTH:" + d.getMessage());
						throw new ITMException(d);
					}
			}
			return rawDataYTDSalesJson;
	}
	/** End of method getTopBrandMTH() **/
	
	 /*** 
		 * Method Name      : getZoneWiseDetail(String dataSourceName, String month,String divDescr)
		 * Servlet Name     : ZoneWiseServlet
		 * Metadataxml Name : zonewise.xml,mthzonewise.xml
		 * Description      : This method returns  raw data for rendering the Division-Zone wise YTD sales Graph. 
		 * Graph Caption    :
		 *                A] YTS Sales : 
		 *                    1. Division-Zone Wise YTD Sales
		 *                    2. DataGrid for the same
		 *                B] Monthly Sales :
		 *                    1. Division-Zone Wise Monthly Sales
		 *                    2. DataGrid for the same
		 * ***/
	@SuppressWarnings({ "unchecked", "unchecked" })
	@Override
    public JSONObject getZoneWiseDetail(String dataSourceName,String month,String divDescr) throws RemoteException, ITMException
    {
		JSONObject rawDataZoneWiseJson = new JSONObject();
		JSONObject rowData = null;
		String sql         = "";
		String finYear     = "";
		ResultSet rs       = null;
		PreparedStatement pstmt = null;
		Connection conn    = null;
		try
		{
		if(month!=null && month.trim().length()>0)
		{
	    	/*conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;*/
			/*add new code for connection DB on dated:15062016 by Nikhil*/
			conn = getConnection();
			System.out.println("Comming  month inside getZoneWiseDetail ==="+month);					
			String selectedMonth  = month.substring(4, 6);				
			if(selectedMonth.trim().equalsIgnoreCase("01") ||selectedMonth.trim().equalsIgnoreCase("02") ||selectedMonth.trim().equalsIgnoreCase("03"))
			{
		    	finYear = String.valueOf(Integer.parseInt(month.substring(0, 4))-1)+"-"+month.substring(2, 4);
	    	}
			else
			{
				finYear = month.substring(0, 4)+"-"+ (String.valueOf(Integer.parseInt(month.substring(0, 4))+1)).substring(2, 4);
			}
			System.out.println("updates month and year from dcoding in getZoneWiseDetail =="+month+"finYear =="+finYear);
						
			sql  =" SELECT   b.div_group, b.div_code,CASE WHEN A.ZONE_DESCR IS NULL THEN 'xOTHERS' ELSE A.ZONE_DESCR END ZONE_DESCR,"
					+ "  (CASE "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = 3    THEN ROUND (0, 1) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) < 3    THEN ROUND (SUM (a.hotrgt_annual_cy - a.sale_ytd_cy) / (12 - SUBSTR ('"+month+"', 5, 2) - 9)/ 10000000,1) "
					+ "  ELSE ROUND (  SUM (a.hotrgt_annual_cy - a.sale_ytd_cy) / (12 - SUBSTR('"+month+"', 5, 2) + 3)/ 10000000,1) END ) AS reqd_mthly, " 
					+ "  ROUND(  SUM (a.sale_ytd_cy)/ (CASE WHEN SUBSTR ('"+month+"', 5, 2) < 4 THEN	SUBSTR ('"+month+"', 5, 2) + 9 "
					+ "  ELSE SUBSTR ('"+month+"', 5, 2) - 3 END)/ 10000000,1) AS avg_mthly, " 
					+ "  ROUND (SUM (a.sale_mth_cy) / 10000000, 1) AS mth_cy_sales, "
					+ "  ROUND (SUM (a.hotrgt_mth_cy) / 10000000, 1) AS mth_ho_trgt, " 
					+ " (CASE WHEN   SUM (a.hotrgt_mth_cy) =0 THEN  0 ELSE "
	+" (CASE WHEN ROUND (SUM (a.sale_mth_cy) / SUM (a.hotrgt_mth_cy) * 100, 1) <-200 THEN -200 "
              +" WHEN ROUND (SUM (a.sale_mth_cy) / SUM (a.hotrgt_mth_cy) * 100, 1) >200 THEN 200 ELSE "
              +" ROUND (SUM (a.sale_mth_cy) / SUM (a.hotrgt_mth_cy) * 100, 1) END) end) AS MTH_ACH_PER, "    
    +" (CASE WHEN SUM (a.sale_mth_ly) <> 0 "             
 			  +" THEN (CASE WHEN ROUND (SUM (a.sale_mth_cy - a.sale_mth_ly)/ SUM (a.sale_mth_ly) * 100,1) <-200 THEN -200 "
              +" WHEN ROUND (SUM (a.sale_mth_cy - a.sale_mth_ly)/ SUM (a.sale_mth_ly) * 100,1) >200 THEN 200 ELSE "
              +" ROUND (SUM (a.sale_mth_cy - a.sale_mth_ly)/ SUM (a.sale_mth_ly) * 100,1) END )"             
 					+ " ELSE ROUND (0 * 100, 1)          END         ) AS mth_gr, "
					+ " ROUND (SUM (a.sale_ytd_cy) / 10000000, 1) AS ytd_cy_sales, "
					+ " ROUND (SUM (a.sale_ytd_ly) / 10000000, 1) AS ytd_ly_sales, "
					+ " ROUND (SUM (a.hotrgt_ytd_cy) / 10000000, 1) AS ytd_ho_trgt,"
					+ " (CASE WHEN SUM (a.sale_ytd_ly) <> 0 "
             +" THEN (CASE WHEN ROUND (  SUM (a.sale_ytd_cy -	a.sale_ytd_ly)/ SUM (a.sale_ytd_ly)* 100,1) <-200 THEN -200 "
              +" WHEN ROUND (  SUM (a.sale_ytd_cy -	a.sale_ytd_ly)/ SUM (a.sale_ytd_ly)* 100,1) >200 THEN 200 ELSE "
              +" ROUND (  SUM (a.sale_ytd_cy -	a.sale_ytd_ly)/ SUM (a.sale_ytd_ly)* 100,1) END )"   					
					+ " ELSE ROUND (0 * 100, 1)  END  ) AS ytd_gr, "
					+ " ROUND (SUM (a.sale_qrt1_cy) / 10000000, 1) AS q1, "
					+ " ROUND (SUM (a.sale_qrt2_cy) / 10000000, 1) AS q2, "
					+ " ROUND (SUM (a.sale_qrt3_cy) / 10000000, 1) AS q3, "
					+ " ROUND (SUM (a.sale_qrt4_cy) / 10000000, 1) AS q4, "
					+ " ROUND (  SUM (a.sale_ytd_cy) / 100000/ MAX (c.psr)/ (CASE "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) < 4 THEN SUBSTR	('"+month+"', 5, 2) + 9 "
					+ " ELSE SUBSTR ('"+month+"', 5, 2) - 3 END),1) AS pmpm, "
					+ " SUM (b.pmpm_ly) AS pmpm_ly, "
					+ " ROUND (SUM (a.sale_ytd_cy - a.hotrgt_ytd_cy) / 10000000, 1) AS ytd_ach_extra,"
					+"  (CASE WHEN   SUM (a.hotrgt_YTD_cy) =0 THEN  0 ELSE "
	                +" (CASE WHEN ROUND (SUM (a.sale_YTD_cy) / SUM (a.hotrgt_YTD_cy) * 100,  1) <-200 THEN -200 "
                    +" WHEN ROUND (SUM (a.sale_YTD_cy) / SUM (a.hotrgt_YTD_cy) * 100,  1) >200 THEN 200 ELSE "
                    +" ROUND (SUM (a.sale_YTD_cy) / SUM (a.hotrgt_YTD_cy) * 100,  1) END) end) AS YTD_ACH_PER, "                           
					+ " (CASE WHEN SUM (a.sale_ytd_cy) <> 0 THEN ROUND (SUM (a.retu_ytd_cy) / SUM (a.sale_ytd_cy) * 100,1) "
					+ "  ELSE ROUND (0 * 100, 1) END) AS retu_ytd_prct " 
					+ " FROM (SELECT   dwh.fin_year, dwh.item_ser,DWH.TERR_CODE,DWH.ZONE_DESCR, "
					+ " SUM (sale_mth_cy) AS sale_mth_cy, "
					+ " SUM (sale_mth_ly) AS sale_mth_ly, "
					+ " SUM (  trgt_mth_cy * (100 + NVL (brnd.ho_trgt_incr_prcnt, 0))/100) AS hotrgt_mth_cy, "
					+ " SUM (sale_ytd_cy) AS sale_ytd_cy, "
					+ " SUM (sale_ytd_ly) AS sale_ytd_ly, "
					+ " SUM (  trgt_ytd_cy * (100 + NVL (brnd.ho_trgt_incr_prcnt, 0))/100) AS hotrgt_ytd_cy, "
					+ " SUM (sale_qrt1_cy) AS sale_qrt1_cy, "
					+ " SUM (sale_qrt2_cy) AS sale_qrt2_cy, "
					+ " SUM (sale_qrt3_cy) AS sale_qrt3_cy, "
					+ " SUM (sale_qrt4_cy) AS sale_qrt4_cy, "
					+ " SUM (  trgt_annual_cy * (100 + NVL (brnd.ho_trgt_incr_prcnt,0))/ 100) AS hotrgt_annual_cy, "
					+ " SUM (retu_ytd_cy) AS retu_ytd_cy "
					+ " FROM (SELECT   fin_year, sm_sales_summ_wide.item_ser, "
					+ " sales_item.item_sub_group AS sub_grp, "
					+ " sm_sales_summ_wide.TERR_CODE,  "
					+ " SALES_TERRITORY.ZONE_DESCR, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (cy_sale_mth_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (cy_sale_mth_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (cy_sale_mth_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (cy_sale_mth_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (cy_sale_mth_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (cy_sale_mth_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (cy_sale_mth_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (cy_sale_mth_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (cy_sale_mth_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (cy_sale_mth_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (cy_sale_mth_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (cy_sale_mth_mar) "
					+ " END ) AS sale_mth_cy,"
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (ly_sale_mth_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (ly_sale_mth_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (ly_sale_mth_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (ly_sale_mth_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (ly_sale_mth_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (ly_sale_mth_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (ly_sale_mth_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (ly_sale_mth_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (ly_sale_mth_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (ly_sale_mth_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (ly_sale_mth_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (ly_sale_mth_mar) "
					+ " END ) AS sale_mth_ly,"
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (fld_trgt_mth_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (fld_trgt_mth_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (fld_trgt_mth_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (fld_trgt_mth_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (fld_trgt_mth_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (fld_trgt_mth_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (fld_trgt_mth_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (fld_trgt_mth_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (fld_trgt_mth_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (fld_trgt_mth_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (fld_trgt_mth_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (fld_trgt_mth_mar) "
					+ " END) AS trgt_mth_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (cy_sale_ytd_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (cy_sale_ytd_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (cy_sale_ytd_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (cy_sale_ytd_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (cy_sale_ytd_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (cy_sale_ytd_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (cy_sale_ytd_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (cy_sale_ytd_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (cy_sale_ytd_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (cy_sale_ytd_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (cy_sale_ytd_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (cy_sale_ytd_mar) "
					+ " END) AS sale_ytd_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (ly_sale_ytd_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (ly_sale_ytd_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (ly_sale_ytd_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (ly_sale_ytd_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (ly_sale_ytd_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (ly_sale_ytd_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (ly_sale_ytd_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (ly_sale_ytd_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (ly_sale_ytd_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (ly_sale_ytd_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (ly_sale_ytd_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (ly_sale_ytd_mar) "
					+ " END) AS sale_ytd_ly, " 
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (fld_trgt_ytd_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (fld_trgt_ytd_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (fld_trgt_ytd_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (fld_trgt_ytd_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (fld_trgt_ytd_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (fld_trgt_ytd_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (fld_trgt_ytd_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (fld_trgt_ytd_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (fld_trgt_ytd_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (fld_trgt_ytd_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (fld_trgt_ytd_feb) " 
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (fld_trgt_ytd_mar) "
					+ " END) AS trgt_ytd_cy, " 
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (cy_sale_ytd_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (cy_sale_ytd_may) "
					+ " ELSE SUM (cy_sale_ytd_jun) " 
					+ " END) AS sale_qrt1_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) >= '04' AND SUBSTR ('"+month+"', 5, 2) <= '06' THEN 0 "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (cy_sale_ytd_jul) - SUM (cy_sale_ytd_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (cy_sale_ytd_aug) - SUM (cy_sale_ytd_jun) "
					+ " ELSE   SUM (cy_sale_ytd_sep)- SUM (cy_sale_ytd_jun) END) AS sale_qrt2_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) >= '04' AND SUBSTR ('"+month+"', 5, 2) <= '09' THEN 0 "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10'  THEN SUM (cy_sale_ytd_oct) - SUM (cy_sale_ytd_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11'  THEN SUM (cy_sale_ytd_nov) - SUM (cy_sale_ytd_sep) "
					+ " ELSE   SUM (cy_sale_ytd_dec) - SUM (cy_sale_ytd_sep) END) AS sale_qrt3_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) >= '04' AND SUBSTR ('"+month+"', 5, 2) <= '12' THEN 0 "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01'  THEN SUM (cy_sale_ytd_jan) - SUM (cy_sale_ytd_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02'  THEN SUM (cy_sale_ytd_feb) - SUM (cy_sale_ytd_dec) "
					+ " ELSE   SUM (cy_sale_ytd_mar) - SUM (cy_sale_ytd_dec) END ) AS sale_qrt4_cy, "
					+ " SUM (fld_trgt_ytd_mar) AS trgt_annual_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (cy_retu_ytd_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (cy_retu_ytd_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (cy_retu_ytd_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (cy_retu_ytd_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (cy_retu_ytd_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (cy_retu_ytd_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (cy_retu_ytd_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (cy_retu_ytd_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (cy_retu_ytd_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (cy_retu_ytd_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (cy_retu_ytd_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (cy_retu_ytd_mar) "
					+ " END) AS retu_ytd_cy "
					+ " FROM sm_sales_summ_wide, sales_item,SALES_TERRITORY, "
					+ " (SELECT territory_code FROM ( SELECT DISTINCT row_number() OVER( PARTITION BY territory_code ORDER BY territory_code) AS rw, territory_code,zone_descr FROM sales_station ) WHERE rw=1) ST  "
					+ " WHERE TRIM (fin_year) = (CASE WHEN SUBSTR ('"+month+"', 5, 2) < 4 THEN    SUBSTR ('"+month+"' - 100, 1, 4) || '-' || SUBSTR ('"+month+"', 3, 2) "
					+ " ELSE    SUBSTR ('"+month+"', 1,4)  || '-' || SUBSTR ('"+month+"' + 100, 3, 2)   END) "
					+ " AND '"+month+"' = '"+month+"' "
					+ " AND sm_sales_summ_wide.TERR_CODE = SALES_TERRITORY.TERR_CODE(+) "
					+ " AND SM_SALES_SUMM_WIDE.TERR_CODE = ST.TERRITORY_CODE AND SALES_TERRITORY.TERR_CODE = ST.TERRITORY_CODE  "
					+ " AND sm_sales_summ_wide.item_code =  sales_item.item_code "
					+ " AND sales_item.item_sub_group NOT IN ('CU', 'BJ') "
					+ " AND   SM_SALES_SUMM_WIDE.terr_code NOT IN('COGS','EXPNS') "
					+ " GROUP BY fin_year, sm_sales_summ_wide.item_ser,sales_item.item_sub_group,sm_sales_summ_wide.TERR_CODE,SALES_TERRITORY.ZONE_DESCR	"
					+ " ) dwh, sm_sales_brand_mst brnd "
					+ " WHERE brnd.brand_code(+) = dwh.sub_grp "
					+ " AND brnd.div_code(+) = dwh.item_ser "
					+ " AND brnd.fin_year(+) = dwh.fin_year "
					+ " GROUP BY dwh.fin_year, dwh.item_ser,DWH.TERR_CODE,DWH.ZONE_DESCR) a, "
					+ " sm_sales_div_mst b, "
					+ " (SELECT   finyr, table_no, SUM (psr) AS psr "
					+ " FROM (SELECT   SUBSTR (version_id, 3, 4) AS finyr, table_no, "
					+ " pool_code, TO_NUMBER (MAX (no_psr_terr)) AS psr "
					+ " FROM starclub.emp_sales "
					+ " WHERE level_no = 4  "
					+ " GROUP BY SUBSTR (version_id, 3, 4), table_no, pool_code) "
					+ " GROUP BY finyr, table_no) c "
					+ " WHERE TRIM (a.item_ser) = TRIM (b.div_code) "
					+ " AND b.fin_year = a.fin_year "
					+ " AND TRIM (a.item_ser) = TRIM (c.table_no) "
					+ " AND c.finyr = SUBSTR (a.fin_year, 3, 2) || SUBSTR (a.fin_year, 6, 2) "
					+ " AND b.div_group <> 'OTHERS' "
					+ " AND trim(b.div_descr) =trim('"+divDescr +"')"
					+ " GROUP BY b.div_group, b.div_code,CASE WHEN A.ZONE_DESCR IS NULL THEN 'xOTHERS' ELSE A.ZONE_DESCR END "
					+ " ORDER BY ROUND(SUM(a.sale_ytd_cy)/10000000,1) desc , CASE WHEN A.ZONE_DESCR IS NULL THEN 'xOTHERS' ELSE A.ZONE_DESCR END ";


			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;			
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("zone_descr", checkNull(rs.getString("ZONE_DESCR")));
				rowData.put("ytd_cy_sales", rs.getString("ytd_cy_sales"));
				rowData.put("ytd_gr", rs.getString("ytd_gr"));
				rowData.put("ytd_ach_extra", rs.getString("ytd_ach_extra"));
                rowData.put("ytd_ly_sales", rs.getString("YTD_LY_SALES"));
				rowData.put("ytd_ho_trgt", rs.getString("YTD_HO_TRGT"));									
				rowData.put("retu_ytd_prct", rs.getString("RETU_YTD_PRCT"));
				rowData.put("reqd_mthly", rs.getString("REQD_MTHLY"));
				rowData.put("avg_mthly", rs.getString("AVG_MTHLY"));
				rowData.put("mth_cy_sales", rs.getString("MTH_CY_SALES"));
				rowData.put("mth_ho_trgt", rs.getString("MTH_HO_TRGT"));
				rowData.put("mth_ach_per", rs.getString("MTH_ACH_PER"));
				rowData.put("mth_gr", rs.getString("MTH_GR"));
				rowData.put("pmpm", rs.getString("PMPM"));
				rowData.put("pmpm_ly", rs.getString("PMPM_LY"));
				
				rowData.put("ytd_ach_per", rs.getString("YTD_ach_per"));
				rawDataZoneWiseJson.put(count, rowData);
				count++;
			}
		}
			System.out.println("fetch Data for  Zone Wise Detail====" + rawDataZoneWiseJson.toString());

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :SalesPersonSales:getZoneWiseDetail:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataZoneWiseJson;
    }
	
	/**end of method getZoneWiseDetail() **/
	
	
	
	 /*** 
		 * Method Name      : getZoneWiseMetroDetail(String dataSourceName, String month,String divGrp)
		 * Servlet Name     : ZoneWiseMetroServlet
		 * Metadataxml Name : zonewisemetro.xml,mnthzonewisemetro.xml
		 * Description      : This method returns  raw data for rendering the Division-Zone-Region wise YTD sales Graph. 
		 * Graph Caption    :
		 *                 A] YTD Sales :
		 *                    1. Division-Zone-Region Wise Details
		 *                    2. DataGrid for the same
		 *                 B] Monthly Sales :
		 *                    1. Division-Zone-Region Wise Monthly Sales
		 *                    2. DataGrid for the same
		 * ***/
    @SuppressWarnings("unchecked")
	public JSONObject getZoneWiseMetroDetail(String dataSourceName, String month, String divGrp,String divDescr, String zoneDescr) throws RemoteException, ITMException
    {
		JSONObject rawDataResionWiseJson = new JSONObject();
		JSONObject rowData = null;
		String sql         = "";
		String finYear     = "";
		ResultSet rs       = null;
		PreparedStatement pstmt = null;
		Connection conn    = null;
		try
		{
		if(month!=null && month.trim().length()>0)
		{
	    	/*conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;*/
			/*add new code for connection DB on dated:15062016 by Nikhil*/
			conn = getConnection();
			System.out.println("Comming  month inside getZoneWiseMetroDetail ==="+month);					
			String selectedMonth  = month.substring(4, 6);				
			if(selectedMonth.trim().equalsIgnoreCase("01") ||selectedMonth.trim().equalsIgnoreCase("02") ||selectedMonth.trim().equalsIgnoreCase("03"))
			{
		    	finYear = String.valueOf(Integer.parseInt(month.substring(0, 4))-1)+"-"+month.substring(2, 4);
	    	}
			else
			{
				finYear = month.substring(0, 4)+"-"+ (String.valueOf(Integer.parseInt(month.substring(0, 4))+1)).substring(2, 4);
			}
			System.out.println("updates month and year from dcoding in getZoneWiseMetroDetail =="+month+"finYear =="+finYear);
			
			sql  =" SELECT   b.div_group, b.div_code,B.DIV_DESCR,A.ZONE_code,A.ZONE_DESCR,"
					+ "	CASE WHEN A.METRO_DSCR IS NULL THEN 'xOTHERS' ELSE  A.METRO_DSCR END METRO_DSCR, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = 3  THEN ROUND (0, 1) "
					+ "	 WHEN SUBSTR ('"+month+"', 5, 2) < 3  THEN ROUND (SUM (a.hotrgt_annual_cy - a.sale_ytd_cy)/ (12 - SUBSTR ('"+month+"', 5, 2) - 9)/ 10000000,1) "
					+ "  ELSE ROUND (  SUM (a.hotrgt_annual_cy - a.sale_ytd_cy)/ (12 - SUBSTR ('"+month+"', 5, 2) + 3)/ 10000000,1) "
					+ "  END) AS reqd_mthly, "
					+ "  ROUND(  SUM (a.sale_ytd_cy)/ (CASE WHEN SUBSTR ('"+month+"', 5, 2) < 4  THEN SUBSTR ('"+month+"', 5, 2) + 9 "
					+ "	 ELSE SUBSTR ('"+month+"', 5, 2) - 3 " 
					+ "	 END)/ 10000000,1) AS avg_mthly, "
					+ "  ROUND (SUM (a.sale_mth_cy) / 10000000, 1) AS mth_cy_sales, "
					+ "  ROUND (SUM (a.hotrgt_mth_cy) / 10000000, 1) AS mth_ho_trgt, "
				    + "  (CASE WHEN   SUM (a.hotrgt_mth_cy) =0 THEN  0 ELSE "
	+" (CASE WHEN ROUND (SUM (a.sale_mth_cy) / SUM (a.hotrgt_mth_cy) * 100, 1) <-200 THEN -200 "
              +" WHEN ROUND (SUM (a.sale_mth_cy) / SUM (a.hotrgt_mth_cy) * 100, 1) >200 THEN 200 ELSE "
              +" ROUND (SUM (a.sale_mth_cy) / SUM (a.hotrgt_mth_cy) * 100, 1) END) end) AS MTH_ACH_PER, "    
		                	+" (CASE WHEN SUM(a.sale_mth_ly)<>0 "
			  +" THEN (CASE WHEN ROUND(SUM(a.sale_mth_cy - a.sale_mth_ly)/SUM(a.sale_mth_ly)*100,1) <-200 THEN -200 "
              +" WHEN ROUND(SUM(a.sale_mth_cy - a.sale_mth_ly)/SUM(a.sale_mth_ly)*100,1) >200 THEN 200 ELSE "
              +" ROUND(SUM(a.sale_mth_cy - a.sale_mth_ly)/SUM(a.sale_mth_ly)*100,1) END )"
                            +" ELSE ROUND(0*100,1)  END) AS MTH_GR,"			  
					+ "  ROUND (SUM (a.sale_ytd_cy) / 10000000, 1) AS ytd_cy_sales, "
					+ "  ROUND (SUM (a.sale_ytd_ly) / 10000000, 1) AS ytd_ly_sales, "
					+ "  ROUND (SUM (a.hotrgt_ytd_cy) / 10000000, 1) AS ytd_ho_trgt, "
							+"(CASE WHEN SUM(a.sale_ytd_ly)<>0 "
              +" THEN (CASE WHEN ROUND(SUM(a.sale_ytd_cy - a.sale_ytd_ly)/SUM(a.sale_ytd_ly)*100,1) <-200 THEN -200 "
              +" WHEN ROUND(SUM(a.sale_ytd_cy - a.sale_ytd_ly)/SUM(a.sale_ytd_ly)*100,1) >200 THEN 200 ELSE "
              +" ROUND(SUM(a.sale_ytd_cy - a.sale_ytd_ly)/SUM(a.sale_ytd_ly)*100,1) END )"              
                            +" ELSE ROUND(0*100,1)  END) AS YTD_GR, "
					+ "  ROUND (SUM (a.sale_qrt1_cy) / 10000000, 1) AS q1, "
					+ "  ROUND (SUM (a.sale_qrt2_cy) / 10000000, 1) AS q2, "
					+ "  ROUND (SUM (a.sale_qrt3_cy) / 10000000, 1) AS q3, "
					+ "  ROUND (SUM (a.sale_qrt4_cy) / 10000000, 1) AS q4, "
					+ "  ROUND (  SUM (a.sale_ytd_cy)/ 100000/ MAX (c.psr)/ (CASE WHEN SUBSTR ('"+month+"', 5, 2) < 4  THEN SUBSTR ('"+month+"', 5, 2) + 9 "
					+ "	 ELSE SUBSTR ('"+month+"', 5, 2) - 3  "
					+ "	 END),1) AS pmpm, "
					+ "  SUM (b.pmpm_ly) AS pmpm_ly, "
					+ "  ROUND (SUM (a.sale_ytd_cy - a.hotrgt_ytd_cy) / 10000000, 1) AS ytd_ach_extra, "
					+ " (CASE WHEN   SUM (a.hotrgt_YTD_cy) =0 THEN  0 ELSE "
	+" (CASE WHEN ROUND (SUM (a.sale_YTD_cy) / SUM (a.hotrgt_YTD_cy) * 100, 1) <-200 THEN -200 "
              +" WHEN ROUND (SUM (a.sale_YTD_cy) / SUM (a.hotrgt_YTD_cy) * 100, 1) >200 THEN 200 ELSE "
              +" ROUND (SUM (a.sale_YTD_cy) / SUM (a.hotrgt_YTD_cy) * 100, 1) END) end)	 AS YTD_ach_per, " 				
					+ "  (CASE WHEN SUM (a.sale_ytd_cy) <> 0 THEN ROUND (SUM (a.retu_ytd_cy) / SUM (a.sale_ytd_cy) * 100,1) "
					+ "	 ELSE ROUND (0 * 100, 1) "
					+ "  END) AS retu_ytd_prct "
					+ "  FROM (SELECT   dwh.fin_year, dwh.item_ser,DWH.TERR_CODE,DWH.ZONE_CODE,DWH.ZONE_DESCR, "
					+ "	 DWH.TERR_DESCR,DWH.METRO_DSCR,SUM (sale_mth_cy) AS sale_mth_cy, "
					+ "  SUM (sale_mth_ly) AS sale_mth_ly,SUM (  trgt_mth_cy* (100 + NVL (brnd.ho_trgt_incr_prcnt, 0))/ 100) AS hotrgt_mth_cy, "
					+ "  SUM (sale_ytd_cy) AS sale_ytd_cy, SUM (sale_ytd_ly) AS sale_ytd_ly, "
					+ "  SUM (  trgt_ytd_cy * (100 + NVL (brnd.ho_trgt_incr_prcnt, 0))/ 100 ) AS hotrgt_ytd_cy, "
					+ "  SUM (sale_qrt1_cy) AS sale_qrt1_cy,SUM (sale_qrt2_cy) AS sale_qrt2_cy,SUM (sale_qrt3_cy) AS sale_qrt3_cy, "
					+ "  SUM (sale_qrt4_cy) AS sale_qrt4_cy,SUM (  trgt_annual_cy* (100 + NVL (brnd.ho_trgt_incr_prcnt, 0))/ 100) AS hotrgt_annual_cy, "
					+ "  SUM (retu_ytd_cy) AS retu_ytd_cy "
					+ "	 FROM (SELECT   fin_year, sm_sales_summ_wide.item_ser, "
					+ "	 sales_item.item_sub_group AS sub_grp,sm_sales_summ_wide.TERR_CODE, "
					+ "	 SALES_TERRITORY.ZONE_CODE,SALES_TERRITORY.ZONE_DESCR, "
					+ "	 SALES_TERRITORY.TERR_DESCR,SALES_TERRITORY.REGION_DESCR AS METRO_DSCR,"
					+ "	 (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (cy_sale_mth_apr) "
					+ "	 WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (cy_sale_mth_may) "
					+ "	 WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (cy_sale_mth_jun) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (cy_sale_mth_jul) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (cy_sale_mth_aug) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (cy_sale_mth_sep) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (cy_sale_mth_oct) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (cy_sale_mth_nov) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (cy_sale_mth_dec) "
					+ "	 WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (cy_sale_mth_jan) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (cy_sale_mth_feb) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (cy_sale_mth_mar) "
					+ "  END) AS sale_mth_cy, "
					+ "  (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (ly_sale_mth_apr) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (ly_sale_mth_may) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (ly_sale_mth_jun) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (ly_sale_mth_jul) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (ly_sale_mth_aug) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (ly_sale_mth_sep) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (ly_sale_mth_oct) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (ly_sale_mth_nov) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (ly_sale_mth_dec) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (ly_sale_mth_jan) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (ly_sale_mth_feb) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (ly_sale_mth_mar) "
					+ "  END) AS sale_mth_ly, "
					+ "  (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (fld_trgt_mth_apr) "
					+ "	 WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (fld_trgt_mth_may) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (fld_trgt_mth_jun) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (fld_trgt_mth_jul) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (fld_trgt_mth_aug) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (fld_trgt_mth_sep) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (fld_trgt_mth_oct) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (fld_trgt_mth_nov) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (fld_trgt_mth_dec) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (fld_trgt_mth_jan) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (fld_trgt_mth_feb) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (fld_trgt_mth_mar) "
					+ "  END) AS trgt_mth_cy, "
					+ "  (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (cy_sale_ytd_apr) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (cy_sale_ytd_may) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (cy_sale_ytd_jun) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (cy_sale_ytd_jul) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (cy_sale_ytd_aug) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (cy_sale_ytd_sep) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (cy_sale_ytd_oct) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (cy_sale_ytd_nov) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (cy_sale_ytd_dec) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (cy_sale_ytd_jan) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (cy_sale_ytd_feb) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (cy_sale_ytd_mar) "
					+ "  END) AS sale_ytd_cy, "
					+ "  (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (ly_sale_ytd_apr) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (ly_sale_ytd_may) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (ly_sale_ytd_jun) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (ly_sale_ytd_jul) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (ly_sale_ytd_aug) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (ly_sale_ytd_sep) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (ly_sale_ytd_oct) " 
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (ly_sale_ytd_nov) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (ly_sale_ytd_dec) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (ly_sale_ytd_jan) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (ly_sale_ytd_feb) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (ly_sale_ytd_mar) "
					+ "  END ) AS sale_ytd_ly, "                             
					+ "	 (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (fld_trgt_ytd_apr) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (fld_trgt_ytd_may) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (fld_trgt_ytd_jun) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (fld_trgt_ytd_jul) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (fld_trgt_ytd_aug) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (fld_trgt_ytd_sep) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (fld_trgt_ytd_oct) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (fld_trgt_ytd_nov) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (fld_trgt_ytd_dec) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (fld_trgt_ytd_jan) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (fld_trgt_ytd_feb) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (fld_trgt_ytd_mar) "
					+ "	 END) AS trgt_ytd_cy, "
					+ "  (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (cy_sale_ytd_apr) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (cy_sale_ytd_may) "
					+ "  ELSE SUM (cy_sale_ytd_jun) "
					+ "  END) AS sale_qrt1_cy, "
					+ "  (CASE WHEN SUBSTR ('"+month+"', 5, 2) >= '04' AND SUBSTR ('"+month+"', 5, 2) <= '06' THEN 0 "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN   SUM (cy_sale_ytd_jul) - SUM (cy_sale_ytd_jun) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN   SUM (cy_sale_ytd_aug) - SUM (cy_sale_ytd_jun) "
					+ "  ELSE   SUM (cy_sale_ytd_sep) - SUM (cy_sale_ytd_jun) "
					+ "  END) AS sale_qrt2_cy, "
					+ "  (CASE WHEN SUBSTR ('"+month+"', 5, 2) >= '04' AND SUBSTR ('"+month+"', 5, 2) <= '09' THEN 0 "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN   SUM (cy_sale_ytd_oct) - SUM (cy_sale_ytd_sep) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN   SUM (cy_sale_ytd_nov) - SUM (cy_sale_ytd_sep) "
					+ "  ELSE   SUM (cy_sale_ytd_dec) - SUM (cy_sale_ytd_sep) "
					+ "  END) AS sale_qrt3_cy, "
					+ "  (CASE WHEN SUBSTR ('"+month+"', 5, 2) >= '04' AND SUBSTR ('"+month+"', 5, 2) <= '12' THEN 0 "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN   SUM (cy_sale_ytd_jan) - SUM (cy_sale_ytd_dec) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN   SUM (cy_sale_ytd_feb) - SUM (cy_sale_ytd_dec) "
					+ "  ELSE   SUM (cy_sale_ytd_mar) - SUM (cy_sale_ytd_dec) "
					+ "  END ) AS sale_qrt4_cy, "
					+ "  SUM (fld_trgt_ytd_mar) AS trgt_annual_cy, "
					+ "  (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (cy_retu_ytd_apr) "
					+ "	 WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (cy_retu_ytd_may) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (cy_retu_ytd_jun) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (cy_retu_ytd_jul) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (cy_retu_ytd_aug) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (cy_retu_ytd_sep) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (cy_retu_ytd_oct) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (cy_retu_ytd_nov) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (cy_retu_ytd_dec) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (cy_retu_ytd_jan) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (cy_retu_ytd_feb) "
					+ "  WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (cy_retu_ytd_mar) "
					+ "  END) AS retu_ytd_cy "
					+ "  FROM sm_sales_summ_wide, sales_item,SALES_TERRITORY, "
					+ " (SELECT territory_code FROM ( SELECT DISTINCT row_number() OVER( PARTITION BY territory_code ORDER BY territory_code) AS rw,territory_code,zone_descr FROM sales_station ) WHERE rw=1) ST "   
					+ "  WHERE TRIM (fin_year) = "
					+ "  (CASE WHEN SUBSTR ('"+month+"', 5, 2) < 4  THEN    SUBSTR ('"+month+"' - 100, 1, 4)  || '-'  || SUBSTR ('"+month+"', 3, 2) "
					+ "  ELSE    SUBSTR ('"+month+"', 1, 4)  || '-' || SUBSTR ('"+month+"' + 100, 3, 2) "
					+ "  END) "
					+ "  AND '"+month+"' = '"+month+"' "
					+ "  AND sm_sales_summ_wide.TERR_CODE = SALES_TERRITORY.TERR_CODE(+) "
					+ "  AND SM_SALES_SUMM_WIDE.TERR_CODE = ST.TERRITORY_CODE AND SALES_TERRITORY.TERR_CODE = ST.TERRITORY_CODE "
					+ "  AND sm_sales_summ_wide.item_code = sales_item.item_code "
					+ "  AND sales_item.item_sub_group NOT IN ('CU', 'BJ') "
					+ "  AND   SM_SALES_SUMM_WIDE.terr_code NOT IN('COGS','EXPNS') "
					+ "	 GROUP BY fin_year, sm_sales_summ_wide.item_ser, "
					+ "  sales_item.item_sub_group,sm_sales_summ_wide.TERR_CODE,SALES_TERRITORY.ZONE_CODE,SALES_TERRITORY.ZONE_DESCR, "
					+ "	 SALES_TERRITORY.TERR_DESCR,SALES_TERRITORY.REGION_DESCR) dwh, sm_sales_brand_mst brnd "
					+ "  WHERE brnd.brand_code(+) = dwh.sub_grp "
					+ "  AND brnd.div_code(+) = dwh.item_ser "
					+ "  AND brnd.fin_year(+) = dwh.fin_year "
					+ "  GROUP BY dwh.fin_year, dwh.item_ser,DWH.TERR_CODE,DWH.ZONE_CODE,DWH.ZONE_DESCR,DWH.TERR_DESCR,DWH.METRO_DSCR) a, "
					+ "  sm_sales_div_mst b, "
					+ "  (SELECT   finyr, table_no, SUM (psr) AS psr "
					+ "  FROM (SELECT   SUBSTR (version_id, 3, 4) AS finyr, table_no, "
					+ "  pool_code, TO_NUMBER (MAX (no_psr_terr)) AS psr "
					+ "  FROM starclub.emp_sales "
					+ "  WHERE level_no = 4 "
					+ "  GROUP BY SUBSTR (version_id, 3, 4), table_no, pool_code) "
					+ "  GROUP BY finyr, table_no) c "
					+ "  WHERE TRIM (a.item_ser) = TRIM (b.div_code) "
					+ "  AND b.fin_year = a.fin_year "
					+ "  AND TRIM (a.item_ser) = TRIM (c.table_no) "
					+ "  AND c.finyr = SUBSTR (a.fin_year, 3, 2) || SUBSTR (a.fin_year, 6, 2) "
					+ "  AND b.div_group <> 'OTHERS'  "
					//+ "  AND b.div_group ='"+ divGrp + "'"
					+ "  AND TRIM(b.div_DESCR) =trim('"+ divDescr + "')"
					+ "  AND TRIM(A.ZONE_descr) = TRIM('" + zoneDescr + "')"
					+ " GROUP BY b.div_group, b.div_code,B.DIV_DESCR,A.ZONE_CODE,A.ZONE_DESCR,CASE WHEN A.METRO_DSCR IS NULL THEN 'xOTHERS' ELSE  A.METRO_DSCR END "
					+ " ORDER BY ROUND(SUM(a.sale_ytd_cy)/10000000,1) desc,CASE WHEN A.METRO_DSCR IS NULL THEN 'xOTHERS' ELSE  A.METRO_DSCR END ";



			pstmt = conn.prepareStatement(sql);
			rs    = pstmt.executeQuery();
			int count = 0;			
			while (rs.next())
			{
				rowData = new JSONObject();				
				rowData.put("metro_dscr", checkNull(rs.getString("METRO_DSCR")));
				rowData.put("ytd_cy_sales", rs.getString("ytd_cy_sales"));
				rowData.put("ytd_gr", rs.getString("ytd_gr"));
				rowData.put("ytd_ach_extra", rs.getString("ytd_ach_extra"));
                rowData.put("ytd_ly_sales", rs.getString("YTD_LY_SALES"));
				rowData.put("ytd_ho_trgt", rs.getString("YTD_HO_TRGT"));									
				rowData.put("retu_ytd_prct", rs.getString("RETU_YTD_PRCT"));
				rowData.put("reqd_mthly", rs.getString("REQD_MTHLY"));
				rowData.put("avg_mthly", rs.getString("AVG_MTHLY"));
				rowData.put("mth_cy_sales", rs.getString("MTH_CY_SALES"));
				rowData.put("mth_ho_trgt", rs.getString("MTH_HO_TRGT"));
				rowData.put("mth_ach_per", rs.getString("MTH_ACH_PER"));
				rowData.put("mth_gr", rs.getString("MTH_GR"));
				rowData.put("pmpm", rs.getString("PMPM"));
				rowData.put("pmpm_ly", rs.getString("PMPM_LY"));
				rowData.put("ytd_ach_per", rs.getString("YTD_ach_per"));
				rawDataResionWiseJson.put(count, rowData);
				count++;
			}
		}
			System.out.println("fetch Data for  zone Wise metra Detail====" + rawDataResionWiseJson.toString());

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :SalesPersonSales:getZoneWiseMetroDetail:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataResionWiseJson;
    }
	
	/**end of method for getZoneWiseMetroDetail() **/
	
    
    /*** 
	 * Method Name      : getBrandWiseZoneDetail(String dataSourceName, String month,String brandName)
	 * Servlet Name     : BrandWiseZoneServlet
	 * Metadataxml Name : brandwisezone.xml.mthbrandwisezone.xml
	 * Description      : This method returns  raw data for rendering the Brand wise zone Grpah. 
	 * Graph Caption    :
	 *    YTD:                1. Brand Wise Zone
	 *                        2. DataGrid for the same
	 *                        
	 *    Monthly:            1. Division-Brand-Zone Wise Monthly Sales
	 *    					  2. DataGrid for the same
	 * ***/
  	@SuppressWarnings({ "unchecked", "unchecked" })
  	@Override
      public JSONObject getBrandWiseZoneDetail(String dataSourceName,String month,String brandName) throws RemoteException, ITMException
      {
  		JSONObject rawDataZoneWiseJson = new JSONObject();
  		JSONObject rowData = null;
  		String sql         = "";
  		String finYear     = "";
  		ResultSet rs       = null;
  		PreparedStatement pstmt = null;
  		Connection conn    = null;
  		try
  		{
  		if(month!=null && month.trim().length()>0)
  		{
  	    	/*conn = connDriver.getConnectDB(dataSourceName);
  			connDriver = null;*/
  			/*add new code for connection DB on dated:15062016 by Nikhil*/
			conn = getConnection();
  			System.out.println("Comming  month inside getBrandWiseZoneDetail ==="+month);					
  			String selectedMonth  = month.substring(4, 6);				
  			if(selectedMonth.trim().equalsIgnoreCase("01") ||selectedMonth.trim().equalsIgnoreCase("02") ||selectedMonth.trim().equalsIgnoreCase("03"))
  			{
  		    	finYear = String.valueOf(Integer.parseInt(month.substring(0, 4))-1)+"-"+month.substring(2, 4);
  	    	}
  			else
  			{
  				finYear = month.substring(0, 4)+"-"+ (String.valueOf(Integer.parseInt(month.substring(0, 4))+1)).substring(2, 4);
  			}
  			System.out.println("updates month and year from dcoding in getBrandWiseZoneDetail =="+month+"finYear =="+finYear);
  						
  			sql  ="SELECT   b.div_group, CASE WHEN A.ZONE_DESCR IS NULL THEN 'xOTHERS' ELSE A.ZONE_DESCR END ZONE_DESCR,BRAND_NAME,BRAND_CODE,"
  					+ " (CASE "
  					+ " WHEN SUBSTR ('"+month+"', 5, 2) = 3    THEN ROUND (0, 1) "
  					+ " WHEN SUBSTR ('"+month+"', 5, 2) < 3    THEN ROUND (SUM (a.hotrgt_annual_cy - a.sale_ytd_cy) / (12 - SUBSTR ('"+month+"', 5, 2) - 9)/ 10000000,1) "
  					+ " ELSE ROUND (  SUM (a.hotrgt_annual_cy - a.sale_ytd_cy) / (12 - SUBSTR ('"+month+"', 5, 2) + 3)/ 10000000,1) END ) AS reqd_mthly, " 
  					+ " ROUND(  SUM (a.sale_ytd_cy)/ (CASE WHEN SUBSTR ('"+month+"', 5, 2) < 4 THEN SUBSTR ('"+month+"', 5, 2) + 9 "
  					+ "	ELSE SUBSTR ('"+month+"', 5, 2) - 3 END)/ 10000000,1) AS avg_mthly, " 
  					+ " ROUND (SUM (a.sale_mth_cy) / 10000000, 1) AS mth_cy_sales, "
  					+ " ROUND (SUM (a.hotrgt_mth_cy) / 10000000, 1) AS mth_ho_trgt, " 
					+ "(CASE WHEN   SUM (a.hotrgt_mth_cy) =0 THEN  0 ELSE "
	+" (CASE WHEN ROUND (SUM (a.sale_mth_cy) / SUM (a.hotrgt_mth_cy) * 100, 1) <-200 THEN -200 "
              +" WHEN ROUND (SUM (a.sale_mth_cy) / SUM (a.hotrgt_mth_cy) * 100, 1) >200 THEN 200 ELSE "
              +" ROUND (SUM (a.sale_mth_cy) / SUM (a.hotrgt_mth_cy) * 100, 1) END) end) AS MTH_ACH_PER, " 	
		                	+" (CASE WHEN SUM(a.sale_mth_ly)<>0 "
			  +" THEN (CASE WHEN ROUND(SUM(a.sale_mth_cy - a.sale_mth_ly)/SUM(a.sale_mth_ly)*100,1) <-200 THEN -200 "
              +" WHEN ROUND(SUM(a.sale_mth_cy - a.sale_mth_ly)/SUM(a.sale_mth_ly)*100,1) >200 THEN 200 ELSE "
              +" ROUND(SUM(a.sale_mth_cy - a.sale_mth_ly)/SUM(a.sale_mth_ly)*100,1) END )"
                            +" ELSE ROUND(0*100,1)  END) AS MTH_GR,"
					+ " ROUND (SUM (a.sale_ytd_cy) / 10000000, 1) AS ytd_cy_sales, "
					+ " ROUND (SUM (a.sale_ytd_ly) / 10000000, 1) AS ytd_ly_sales, "
					+ " ROUND (SUM (a.hotrgt_ytd_cy) / 10000000, 1) AS ytd_ho_trgt,"
					+ "(CASE WHEN   SUM (a.hotrgt_ytd_cy) =0 THEN  0 ELSE "
	+" (CASE WHEN ROUND (SUM (a.sale_ytd_cy) / SUM (a.hotrgt_ytd_cy) * 100, 1) <-200 THEN -200 "
              +" WHEN ROUND (SUM (a.sale_ytd_cy) / SUM (a.hotrgt_ytd_cy) * 100, 1) >200 THEN 200 ELSE "
              +" ROUND (SUM (a.sale_ytd_cy) / SUM (a.hotrgt_ytd_cy) * 100, 1) END) end) AS YTD_ACH_PER, " 					
							+"(CASE WHEN SUM(a.sale_ytd_ly)<>0 "
              +" THEN (CASE WHEN ROUND(SUM(a.sale_ytd_cy - a.sale_ytd_ly)/SUM(a.sale_ytd_ly)*100,1) <-200 THEN -200 "
              +" WHEN ROUND(SUM(a.sale_ytd_cy - a.sale_ytd_ly)/SUM(a.sale_ytd_ly)*100,1) >200 THEN 200 ELSE "
              +" ROUND(SUM(a.sale_ytd_cy - a.sale_ytd_ly)/SUM(a.sale_ytd_ly)*100,1) END )"              
                            +" ELSE ROUND(0*100,1)  END) AS YTD_GR, "	
					+ " ROUND (SUM (a.sale_qrt1_cy) / 10000000, 1) AS q1, "
					+ " ROUND (SUM (a.sale_qrt2_cy) / 10000000, 1) AS q2, "
					+ " ROUND (SUM (a.sale_qrt3_cy) / 10000000, 1) AS q3, "
					+ " ROUND (SUM (a.sale_qrt4_cy) / 10000000, 1) AS q4, "
					+ " ROUND (  SUM (a.sale_ytd_cy) / 100000/ MAX (c.psr)/ (CASE "
					+ "	WHEN SUBSTR ('"+month+"', 5, 2) < 4 THEN SUBSTR ('"+month+"', 5, 2) + 9 "
					+ "	ELSE SUBSTR ('"+month+"', 5, 2) - 3 END),1) AS pmpm, "
					+ " SUM (b.pmpm_ly) AS pmpm_ly, "
					+ " ROUND (SUM (a.sale_ytd_cy - a.hotrgt_ytd_cy) / 10000000, 1) AS ytd_ach_extra,"
					+ " (CASE WHEN SUM (a.sale_ytd_cy) <> 0 THEN ROUND (SUM (a.retu_ytd_cy) / SUM (a.sale_ytd_cy) * 100,1) "
					+ " ELSE ROUND (0 * 100, 1) END) AS retu_ytd_prct " 
					+ " FROM (SELECT   dwh.fin_year, dwh.item_ser,DWH.TERR_CODE,DWH.ZONE_DESCR, "
					+ " SUM (sale_mth_cy) AS sale_mth_cy, "
					+ " SUM (sale_mth_ly) AS sale_mth_ly, "
					+ " SUM (  trgt_mth_cy * (100 + NVL (brnd.ho_trgt_incr_prcnt, 0))/ 100) AS hotrgt_mth_cy, "
					+ " SUM (sale_ytd_cy) AS sale_ytd_cy, "
					+ " SUM (sale_ytd_ly) AS sale_ytd_ly, "
					+ " SUM (  trgt_ytd_cy * (100 + NVL (brnd.ho_trgt_incr_prcnt, 0))/ 100) AS hotrgt_ytd_cy, "
					+ " SUM (sale_qrt1_cy) AS sale_qrt1_cy, "
					+ " SUM (sale_qrt2_cy) AS sale_qrt2_cy, "
					+ " SUM (sale_qrt3_cy) AS sale_qrt3_cy, "
					+ " SUM (sale_qrt4_cy) AS sale_qrt4_cy, "
					+ " SUM (  trgt_annual_cy * (100 + NVL (brnd.ho_trgt_incr_prcnt, 0))/ 100) AS hotrgt_annual_cy, "
					+ " SUM (retu_ytd_cy) AS retu_ytd_cy ,grp_nm AS BRAND_NAME,sub_grp BRAND_CODE"
					+ " FROM (SELECT   fin_year, sm_sales_summ_wide.item_ser, "
					+ " sales_item.item_sub_group AS sub_grp, "
					+ "	sales_item.item_sub_group_descr AS grp_nm, "
					+ "	sm_sales_summ_wide.TERR_CODE,  "
					+ "	SALES_TERRITORY.ZONE_DESCR, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (cy_sale_mth_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (cy_sale_mth_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (cy_sale_mth_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (cy_sale_mth_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (cy_sale_mth_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (cy_sale_mth_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (cy_sale_mth_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (cy_sale_mth_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (cy_sale_mth_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (cy_sale_mth_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (cy_sale_mth_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (cy_sale_mth_mar) "
					+ " END ) AS sale_mth_cy,"
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (ly_sale_mth_apr) "
					+ "	WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (ly_sale_mth_may) "
					+ "	WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (ly_sale_mth_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (ly_sale_mth_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (ly_sale_mth_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (ly_sale_mth_sep) "
					+ "	WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (ly_sale_mth_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (ly_sale_mth_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (ly_sale_mth_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (ly_sale_mth_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (ly_sale_mth_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (ly_sale_mth_mar) "
					+ " END ) AS sale_mth_ly,"
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (fld_trgt_mth_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (fld_trgt_mth_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (fld_trgt_mth_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (fld_trgt_mth_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (fld_trgt_mth_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (fld_trgt_mth_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (fld_trgt_mth_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (fld_trgt_mth_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (fld_trgt_mth_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (fld_trgt_mth_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (fld_trgt_mth_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (fld_trgt_mth_mar) "
					+ "	END) AS trgt_mth_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (cy_sale_ytd_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (cy_sale_ytd_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (cy_sale_ytd_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (cy_sale_ytd_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (cy_sale_ytd_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (cy_sale_ytd_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (cy_sale_ytd_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (cy_sale_ytd_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (cy_sale_ytd_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (cy_sale_ytd_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (cy_sale_ytd_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (cy_sale_ytd_mar) "
					+ " END) AS sale_ytd_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (ly_sale_ytd_apr) "
					+ "	WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (ly_sale_ytd_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (ly_sale_ytd_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (ly_sale_ytd_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (ly_sale_ytd_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (ly_sale_ytd_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (ly_sale_ytd_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (ly_sale_ytd_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (ly_sale_ytd_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (ly_sale_ytd_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (ly_sale_ytd_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (ly_sale_ytd_mar) "
					+ " END) AS sale_ytd_ly, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (fld_trgt_ytd_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (fld_trgt_ytd_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (fld_trgt_ytd_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (fld_trgt_ytd_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (fld_trgt_ytd_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (fld_trgt_ytd_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (fld_trgt_ytd_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (fld_trgt_ytd_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (fld_trgt_ytd_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (fld_trgt_ytd_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (fld_trgt_ytd_feb) " 
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (fld_trgt_ytd_mar) "
					+ " END) AS trgt_ytd_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (cy_sale_ytd_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (cy_sale_ytd_may) "
					+ " ELSE SUM (cy_sale_ytd_jun) "
					+ "	END) AS sale_qrt1_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) >= '04' AND SUBSTR ('"+month+"', 5, 2) <= '06' THEN 0 "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN   SUM (cy_sale_ytd_jul) - SUM (cy_sale_ytd_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN   SUM (cy_sale_ytd_aug) - SUM (cy_sale_ytd_jun) "
					+ " ELSE   SUM (cy_sale_ytd_sep)- SUM (cy_sale_ytd_jun) END) AS sale_qrt2_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) >= '04' AND SUBSTR ('"+month+"', 5, 2) <= '09' THEN 0 "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10'  THEN   SUM (cy_sale_ytd_oct) - SUM (cy_sale_ytd_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11'  THEN   SUM (cy_sale_ytd_nov) - SUM (cy_sale_ytd_sep) "
					+ " ELSE   SUM (cy_sale_ytd_dec) - SUM (cy_sale_ytd_sep) END) AS sale_qrt3_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) >= '04' AND SUBSTR ('"+month+"', 5, 2) <= '12' THEN 0 "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01'  THEN   SUM (cy_sale_ytd_jan) - SUM (cy_sale_ytd_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02'  THEN   SUM (cy_sale_ytd_feb) - SUM (cy_sale_ytd_dec) "
					+ " ELSE   SUM (cy_sale_ytd_mar) - SUM (cy_sale_ytd_dec) END ) AS sale_qrt4_cy, "
					+ " SUM (fld_trgt_ytd_mar) AS trgt_annual_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (cy_retu_ytd_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (cy_retu_ytd_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (cy_retu_ytd_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (cy_retu_ytd_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (cy_retu_ytd_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (cy_retu_ytd_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (cy_retu_ytd_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (cy_retu_ytd_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (cy_retu_ytd_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (cy_retu_ytd_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (cy_retu_ytd_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (cy_retu_ytd_mar) "
					+ " END) AS retu_ytd_cy "
					+ " FROM sm_sales_summ_wide, sales_item,SALES_TERRITORY ,"
					+ " (SELECT territory_code FROM ( SELECT DISTINCT row_number() OVER( PARTITION BY territory_code ORDER BY territory_code) AS rw,territory_code,zone_descr FROM sales_station ) WHERE rw=1) ST "
					+ " WHERE TRIM (fin_year) = (CASE WHEN SUBSTR ('"+month+"', 5, 2) < 4 THEN    SUBSTR ('"+month+"' - 100, 1, 4) || '-' || SUBSTR ('"+month+"', 3, 2) "
					+ " ELSE    SUBSTR ('"+month+"', 1, 4)  || '-' || SUBSTR ('"+month+"' + 100, 3, 2) "
					+ "	END) "
					+ "	AND '"+month+"' = '"+month+"' "
					+ "	AND sm_sales_summ_wide.TERR_CODE = SALES_TERRITORY.TERR_CODE(+) "
					+ " AND SM_SALES_SUMM_WIDE.TERR_CODE = ST.TERRITORY_CODE AND SALES_TERRITORY.TERR_CODE = ST.TERRITORY_CODE  "
					+ " AND sm_sales_summ_wide.item_code =  sales_item.item_code "
					+ " AND sales_item.item_sub_group NOT IN ('CU', 'BJ') "
					+ " AND   SM_SALES_SUMM_WIDE.terr_code NOT IN('COGS','EXPNS') "
					+ " GROUP BY fin_year, sm_sales_summ_wide.item_ser,sales_item.item_sub_group,sales_item.item_sub_group_descr ,sm_sales_summ_wide.TERR_CODE,SALES_TERRITORY.ZONE_DESCR "
					+ "	) dwh, sm_sales_brand_mst brnd "
					+ " WHERE brnd.brand_code(+) = dwh.sub_grp "
					+ " AND brnd.div_code(+) = dwh.item_ser "
					+ " AND brnd.fin_year(+) = dwh.fin_year "
					+ " GROUP BY dwh.fin_year, dwh.item_ser,DWH.TERR_CODE,DWH.ZONE_DESCR,sub_grp ,grp_nm) a, "
					+ " sm_sales_div_mst b, "
					+ " (SELECT   finyr, table_no, SUM (psr) AS psr "
					+ " FROM (SELECT   SUBSTR (version_id, 3, 4) AS finyr, table_no, "
					+ " pool_code, TO_NUMBER (MAX (no_psr_terr)) AS psr "
					+ " FROM starclub.emp_sales "
					+ " WHERE level_no = 4  "
					+ " GROUP BY SUBSTR (version_id, 3, 4), table_no, pool_code) "
					+ " GROUP BY finyr, table_no) c "
					+ " WHERE TRIM (a.item_ser) = TRIM (b.div_code) "
					+ " AND b.fin_year = a.fin_year "
					+ " AND TRIM (a.item_ser) = TRIM (c.table_no) "
					+ " AND c.finyr = SUBSTR (a.fin_year, 3, 2) || SUBSTR (a.fin_year, 6, 2) "
					+ " AND b.div_group <> 'OTHERS' "
					+ " AND trim(a.brand_name) =TRIM('"+brandName + "')"
					+ " GROUP BY b.div_group,CASE WHEN A.ZONE_DESCR IS NULL THEN 'xOTHERS' ELSE A.ZONE_DESCR END,BRAND_NAME,BRAND_CODE "
					+ " HAVING (ROUND (SUM (a.sale_mth_cy) / 10000000, 1) + ROUND (SUM (a.sale_ytd_cy) / 10000000, 1)) <>0 "
					+ " ORDER BY ROUND(SUM(a.sale_ytd_cy)/10000000,1) desc, CASE WHEN A.ZONE_DESCR IS NULL THEN 'xOTHERS' ELSE A.ZONE_DESCR END ,BRAND_NAME,BRAND_CODE ";


  			pstmt = conn.prepareStatement(sql);
  			rs = pstmt.executeQuery();
  			int count = 0;			
  			while (rs.next())
  			{
  				rowData = new JSONObject();
  				rowData.put("zone_descr", checkNull(rs.getString("ZONE_DESCR")));
  				rowData.put("ytd_cy_sales", rs.getString("ytd_cy_sales"));
  				rowData.put("ytd_gr",       rs.getString("ytd_gr"));
  				rowData.put("ytd_ach_extra",rs.getString("ytd_ach_extra"));
  				rowData.put("ytd_ach_per",  rs.getString("ytd_ach_per"));  				
                rowData.put("ytd_ly_sales", rs.getString("YTD_LY_SALES"));
				rowData.put("ytd_ho_trgt",  rs.getString("YTD_HO_TRGT"));									
				rowData.put("retu_ytd_prct",rs.getString("RETU_YTD_PRCT"));
				rowData.put("reqd_mthly",   rs.getString("REQD_MTHLY"));
				rowData.put("avg_mthly",    rs.getString("AVG_MTHLY"));
				rowData.put("mth_cy_sales", rs.getString("MTH_CY_SALES"));
				rowData.put("mth_ho_trgt",  rs.getString("MTH_HO_TRGT"));
				rowData.put("mth_ach_per",  rs.getString("MTH_ACH_PER"));
				rowData.put("mth_gr",       rs.getString("MTH_GR"));
				rowData.put("pmpm",         rs.getString("PMPM"));
				rowData.put("pmpm_ly",      rs.getString("PMPM_LY"));
  				rawDataZoneWiseJson.put(count, rowData);
  				count++;
  				

  			}
  		}
  			System.out.println("fetch Data for brand wise Zone  Detail====" + rawDataZoneWiseJson.toString());

  		} catch (Exception e)
  		{
  			e.printStackTrace();
  			throw new ITMException(e);
  		} finally
  		{
  			try
  			{
  				if (conn != null)
  				{
  					if (rs != null)
  					rs.close();
  					rs = null;
  					if (pstmt != null)
  					pstmt.close();
  					pstmt = null;
  					conn.close();
  					conn = null;
  				}
  				conn = null;
  			} catch (Exception d)
  			{
  				d.printStackTrace();
  				System.out.println("Exception in :SalesPersonSales:getBrandWiseZoneDetail:" + d.getMessage());
  				throw new ITMException(d);
  			}
  		}
  		return rawDataZoneWiseJson;
      }
  	
  	/** end of method getBrandWiseZoneDetail() **/
    
  	
  	 /*** 
  		 * Method Name      : getBrandZoneWiseMetroDetail(String dataSourceName, String month,String brandName,String zoneDescr,String divDescr)
  		 * Servlet Name     : BrandZoneWiseMetroServlet
  		 * Metadataxml Name : brandwisezonemetro.xml,mnthbrandwisezonemetro.xml
  		 * Description      : This method returns  raw data for rendering the Brand wise zone metro Grpah. 
  		 * Graph Caption    :
  		 *      YTD:              1. Division-Zone-Region Wise YTD Sales
  		 *                        2. DataGrid for the same
  		 *                        
  		 *      Monthly:		  1. Division-Brand-Zone-Metro wise Monthly Sales
  		 *      				  2. DataGrid for the same
  		 *             
  		 * ***/
  	@SuppressWarnings({ "unchecked", "unchecked" })
  	@Override
      public JSONObject getBrandZoneWiseMetroDetail(String dataSourceName,String month,String brandName,String zoneDescr,String divDescr) throws RemoteException, ITMException
      {
  		JSONObject rawDataMetroWiseJson = new JSONObject();
  		JSONObject rowData = null;
  		String sql         = "";
  		String finYear     = "";
  		ResultSet rs       = null;
  		PreparedStatement pstmt = null;
  		Connection conn    = null;
  		try
  		{
  		if(month!=null && month.trim().length()>0)
  		{
  	    	/*conn = connDriver.getConnectDB(dataSourceName);
  			connDriver = null;*/
  			/*add new code for connection DB on dated:15062016 by Nikhil*/
			conn = getConnection();
  			System.out.println("Comming  month inside getBrandZoneWiseMetroDetail ==="+month);					
  			String selectedMonth  = month.substring(4, 6);				
  			if(selectedMonth.trim().equalsIgnoreCase("01") ||selectedMonth.trim().equalsIgnoreCase("02") ||selectedMonth.trim().equalsIgnoreCase("03"))
  			{
  		    	finYear = String.valueOf(Integer.parseInt(month.substring(0, 4))-1)+"-"+month.substring(2, 4);
  	    	}
  			else
  			{
  				finYear = month.substring(0, 4)+"-"+ (String.valueOf(Integer.parseInt(month.substring(0, 4))+1)).substring(2, 4);
  			}
  			System.out.println("updates month and year from dcoding in getBrandWiseZoneDetail =="+month+"finYear =="+finYear);
  						
  			sql  =" SELECT   b.div_group, b.div_code,b.div_descr,A.ZONE_code,A.ZONE_DESCR,BRAND_NAME,BRAND_CODE, "
					+ "	CASE WHEN A.METRO_DSCR IS NULL THEN 'xOTHERS' ELSE  A.METRO_DSCR END METRO_DSCR, "
					+ "	(CASE WHEN SUBSTR ('"+month+"', 5, 2) = 3  THEN ROUND (0, 1) "
					+ "	WHEN SUBSTR ('"+month+"', 5, 2) < 3  THEN ROUND (SUM (a.hotrgt_annual_cy - a.sale_ytd_cy)/ (12 - SUBSTR ('"+month+"', 5, 2) - 9)/ 10000000,1) "
					+ " ELSE ROUND (  SUM (a.hotrgt_annual_cy - a.sale_ytd_cy)/ (12 - SUBSTR ('"+month+"', 5, 2) + 3)/ 10000000,1) "
					+ " END) AS reqd_mthly, "
					+ " ROUND(  SUM (a.sale_ytd_cy)/ (CASE WHEN SUBSTR ('"+month+"', 5, 2) < 4  THEN SUBSTR ('"+month+"', 5, 2) + 9 "
					+ "	ELSE SUBSTR ('"+month+"', 5, 2) - 3 " 
					+ "	END)/ 10000000,1) AS avg_mthly, "
					+ " ROUND (SUM (a.sale_mth_cy) / 10000000, 1) AS mth_cy_sales, "
					+ " ROUND (SUM (a.hotrgt_mth_cy) / 10000000, 1) AS mth_ho_trgt, "
					+ "( CASE WHEN   SUM (a.hotrgt_mth_cy) =0 THEN  0 ELSE "
	               + " (CASE WHEN ROUND (SUM (a.sale_mth_cy) / SUM (a.hotrgt_mth_cy) * 100, 1) <-200 THEN -200 "
              +" WHEN ROUND (SUM (a.sale_mth_cy) / SUM (a.hotrgt_mth_cy) * 100, 1) >200 THEN 200 ELSE "
              +" ROUND (SUM (a.sale_mth_cy) / SUM (a.hotrgt_mth_cy) * 100, 1) END) end) AS MTH_ACH_PER, "	
		                	+" (CASE WHEN SUM(a.sale_mth_ly)<>0 "
			  +" THEN (CASE WHEN ROUND(SUM(a.sale_mth_cy - a.sale_mth_ly)/SUM(a.sale_mth_ly)*100,1) <-200 THEN -200 "
              +" WHEN ROUND(SUM(a.sale_mth_cy - a.sale_mth_ly)/SUM(a.sale_mth_ly)*100,1) >200 THEN 200 ELSE "
              +" ROUND(SUM(a.sale_mth_cy - a.sale_mth_ly)/SUM(a.sale_mth_ly)*100,1) END )"
                            +" ELSE ROUND(0*100,1)  END) AS MTH_GR,"
					+ " ROUND (SUM (a.sale_ytd_cy) / 10000000, 1) AS ytd_cy_sales, "
					+ " ROUND (SUM (a.sale_ytd_ly) / 10000000, 1) AS ytd_ly_sales, "
					+ " ROUND (SUM (a.hotrgt_ytd_cy) / 10000000, 1) AS ytd_ho_trgt, "
							+"(CASE WHEN SUM(a.sale_ytd_ly)<>0 "
              +" THEN (CASE WHEN ROUND(SUM(a.sale_ytd_cy - a.sale_ytd_ly)/SUM(a.sale_ytd_ly)*100,1) <-200 THEN -200 "
              +" WHEN ROUND(SUM(a.sale_ytd_cy - a.sale_ytd_ly)/SUM(a.sale_ytd_ly)*100,1) >200 THEN 200 ELSE "
              +" ROUND(SUM(a.sale_ytd_cy - a.sale_ytd_ly)/SUM(a.sale_ytd_ly)*100,1) END )"              
                            +" ELSE ROUND(0*100,1)  END) AS YTD_GR, "
					+ " ROUND (SUM (a.sale_qrt1_cy) / 10000000, 1) AS q1, "
					+ " ROUND (SUM (a.sale_qrt2_cy) / 10000000, 1) AS q2, "
					+ " ROUND (SUM (a.sale_qrt3_cy) / 10000000, 1) AS q3, "
					+ " ROUND (SUM (a.sale_qrt4_cy) / 10000000, 1) AS q4, "
					+ " ROUND (SUM (a.sale_ytd_cy)/ 100000/ MAX (c.psr)/ (CASE WHEN SUBSTR ('"+month+"', 5, 2) < 4  THEN SUBSTR ('"+month+"', 5, 2) + 9 "
					+ "	ELSE SUBSTR ('"+month+"', 5, 2) - 3  "
					+ "	END),1) AS pmpm, "
					+ " SUM (b.pmpm_ly) AS pmpm_ly, "
					+ " ROUND (SUM (a.sale_ytd_cy - a.hotrgt_ytd_cy) / 10000000, 1) AS ytd_ach_extra, "
					+ " (CASE WHEN   SUM (a.hotrgt_YTD_cy) =0 THEN  0 ELSE "
	+" (CASE WHEN ROUND (SUM (a.sale_ytd_cy) / SUM (a.hotrgt_ytd_cy) * 100, 1) <-200 THEN -200 "
              +" WHEN ROUND (SUM (a.sale_ytd_cy) / SUM (a.hotrgt_ytd_cy) * 100, 1) >200 THEN 200 ELSE "
              +" ROUND (SUM (a.sale_ytd_cy) / SUM (a.hotrgt_ytd_cy) * 100, 1) END) end) AS YTD_ACH_PER, " 					
					+ " (CASE WHEN SUM (a.sale_ytd_cy) <> 0 THEN ROUND (SUM (a.retu_ytd_cy) / SUM (a.sale_ytd_cy) * 100,1) "
					+ "	ELSE ROUND (0 * 100, 1) "
					+ " END) AS retu_ytd_prct "
					+ " FROM (SELECT   dwh.fin_year, dwh.item_ser,DWH.TERR_CODE,DWH.ZONE_CODE,DWH.ZONE_DESCR,grp_nm AS BRAND_NAME,sub_grp BRAND_CODE, "
					+ "	DWH.TERR_DESCR,DWH.METRO_DSCR,SUM (sale_mth_cy) AS sale_mth_cy, "
					+ " SUM (sale_mth_ly) AS sale_mth_ly,SUM (  trgt_mth_cy* (100 + NVL (brnd.ho_trgt_incr_prcnt, 0))/ 100) AS hotrgt_mth_cy, "
					+ " SUM (sale_ytd_cy) AS sale_ytd_cy, SUM (sale_ytd_ly) AS sale_ytd_ly, "
					+ " SUM (  trgt_ytd_cy * (100 + NVL (brnd.ho_trgt_incr_prcnt, 0))/ 100 ) AS hotrgt_ytd_cy, "
					+ " SUM (sale_qrt1_cy) AS sale_qrt1_cy,SUM (sale_qrt2_cy) AS sale_qrt2_cy,SUM (sale_qrt3_cy) AS sale_qrt3_cy, "
					+ " SUM (sale_qrt4_cy) AS sale_qrt4_cy,SUM (  trgt_annual_cy* (100 + NVL (brnd.ho_trgt_incr_prcnt, 0))/ 100) AS hotrgt_annual_cy, "
					+ " SUM (retu_ytd_cy) AS retu_ytd_cy "
					+ "	FROM (SELECT   fin_year, sm_sales_summ_wide.item_ser, "
					+ "	sales_item.item_sub_group AS sub_grp,sales_item.item_sub_group_descr AS grp_nm,sm_sales_summ_wide.TERR_CODE, "
					+ "	SALES_TERRITORY.ZONE_CODE,SALES_TERRITORY.ZONE_DESCR, "
					+ "	SALES_TERRITORY.TERR_DESCR,SALES_TERRITORY.REGION_DESCR AS METRO_DSCR,"
					+ "	(CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (cy_sale_mth_apr) "
					+ "	WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (cy_sale_mth_may) "
					+ "	WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (cy_sale_mth_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (cy_sale_mth_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (cy_sale_mth_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (cy_sale_mth_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (cy_sale_mth_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (cy_sale_mth_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (cy_sale_mth_dec) "
					+ "	WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (cy_sale_mth_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (cy_sale_mth_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (cy_sale_mth_mar) "
					+ " END) AS sale_mth_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (ly_sale_mth_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (ly_sale_mth_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (ly_sale_mth_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (ly_sale_mth_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (ly_sale_mth_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (ly_sale_mth_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (ly_sale_mth_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (ly_sale_mth_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (ly_sale_mth_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (ly_sale_mth_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (ly_sale_mth_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (ly_sale_mth_mar) "
					+ " END) AS sale_mth_ly, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (fld_trgt_mth_apr) "
					+ "	WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (fld_trgt_mth_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (fld_trgt_mth_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (fld_trgt_mth_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (fld_trgt_mth_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (fld_trgt_mth_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (fld_trgt_mth_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (fld_trgt_mth_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (fld_trgt_mth_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (fld_trgt_mth_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (fld_trgt_mth_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (fld_trgt_mth_mar) "
					+ " END) AS trgt_mth_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (cy_sale_ytd_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (cy_sale_ytd_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (cy_sale_ytd_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (cy_sale_ytd_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (cy_sale_ytd_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (cy_sale_ytd_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (cy_sale_ytd_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (cy_sale_ytd_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (cy_sale_ytd_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (cy_sale_ytd_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (cy_sale_ytd_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (cy_sale_ytd_mar) "
					+ " END) AS sale_ytd_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (ly_sale_ytd_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (ly_sale_ytd_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (ly_sale_ytd_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (ly_sale_ytd_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (ly_sale_ytd_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (ly_sale_ytd_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (ly_sale_ytd_oct) " 
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (ly_sale_ytd_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (ly_sale_ytd_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (ly_sale_ytd_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (ly_sale_ytd_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (ly_sale_ytd_mar) "
					+ " END ) AS sale_ytd_ly, "                             
					+ "	(CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (fld_trgt_ytd_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (fld_trgt_ytd_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (fld_trgt_ytd_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (fld_trgt_ytd_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (fld_trgt_ytd_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (fld_trgt_ytd_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (fld_trgt_ytd_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (fld_trgt_ytd_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (fld_trgt_ytd_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (fld_trgt_ytd_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (fld_trgt_ytd_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (fld_trgt_ytd_mar) "
					+ "	END) AS trgt_ytd_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (cy_sale_ytd_apr) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (cy_sale_ytd_may) "
					+ " ELSE SUM (cy_sale_ytd_jun) "
					+ " END) AS sale_qrt1_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) >= '04' AND SUBSTR ('"+month+"', 5, 2) <= '06' THEN 0 "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN   SUM (cy_sale_ytd_jul) - SUM (cy_sale_ytd_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN   SUM (cy_sale_ytd_aug) - SUM (cy_sale_ytd_jun) "
					+ " ELSE   SUM (cy_sale_ytd_sep) - SUM (cy_sale_ytd_jun) "
					+ " END) AS sale_qrt2_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) >= '04' AND SUBSTR ('"+month+"', 5, 2) <= '09' THEN 0 "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN   SUM (cy_sale_ytd_oct) - SUM (cy_sale_ytd_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN   SUM (cy_sale_ytd_nov) - SUM (cy_sale_ytd_sep) "
					+ " ELSE SUM (cy_sale_ytd_dec) - SUM (cy_sale_ytd_sep) "
					+ " END) AS sale_qrt3_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) >= '04' AND SUBSTR ('"+month+"', 5, 2) <= '12' THEN 0 "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN   SUM (cy_sale_ytd_jan) - SUM (cy_sale_ytd_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN   SUM (cy_sale_ytd_feb) - SUM (cy_sale_ytd_dec) "
					+ " ELSE   SUM (cy_sale_ytd_mar) - SUM (cy_sale_ytd_dec) "
					+ " END ) AS sale_qrt4_cy, "
					+ " SUM (fld_trgt_ytd_mar) AS trgt_annual_cy, "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) = '04' THEN SUM (cy_retu_ytd_apr) "
					+ "	WHEN SUBSTR ('"+month+"', 5, 2) = '05' THEN SUM (cy_retu_ytd_may) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '06' THEN SUM (cy_retu_ytd_jun) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '07' THEN SUM (cy_retu_ytd_jul) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '08' THEN SUM (cy_retu_ytd_aug) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '09' THEN SUM (cy_retu_ytd_sep) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '10' THEN SUM (cy_retu_ytd_oct) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '11' THEN SUM (cy_retu_ytd_nov) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '12' THEN SUM (cy_retu_ytd_dec) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '01' THEN SUM (cy_retu_ytd_jan) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '02' THEN SUM (cy_retu_ytd_feb) "
					+ " WHEN SUBSTR ('"+month+"', 5, 2) = '03' THEN SUM (cy_retu_ytd_mar) "
					+ " END) AS retu_ytd_cy "
					+ " FROM sm_sales_summ_wide, sales_item,SALES_TERRITORY, "
					+ " (SELECT territory_code FROM ( SELECT DISTINCT row_number() OVER( PARTITION BY territory_code ORDER BY territory_code) AS rw,territory_code,zone_descr FROM sales_station ) WHERE rw=1) ST "
					+ " WHERE TRIM (fin_year) = "
					+ " (CASE WHEN SUBSTR ('"+month+"', 5, 2) < 4  THEN    SUBSTR ('"+month+"' - 100, 1, 4)  || '-'  || SUBSTR ('"+month+"', 3, 2) "
					+ " ELSE    SUBSTR ('"+month+"', 1, 4)  || '-' || SUBSTR ('"+month+"' + 100, 3, 2) "
					+ " END) "
					+ " AND '"+month+"' = '"+month+"' "
					+ " AND sm_sales_summ_wide.TERR_CODE = SALES_TERRITORY.TERR_CODE(+) "
					+ " AND SM_SALES_SUMM_WIDE.TERR_CODE = ST.TERRITORY_CODE AND SALES_TERRITORY.TERR_CODE = ST.TERRITORY_CODE  "
					+ " AND sm_sales_summ_wide.item_code = sales_item.item_code "
					+ " AND sales_item.item_sub_group NOT IN ('CU', 'BJ') "
					+ " AND   SM_SALES_SUMM_WIDE.terr_code NOT IN('COGS','EXPNS') "
					+ "	GROUP BY fin_year, sm_sales_summ_wide.item_ser, "
					+ " sales_item.item_sub_group,sm_sales_summ_wide.TERR_CODE,SALES_TERRITORY.ZONE_CODE,SALES_TERRITORY.ZONE_DESCR, "
					+ "	sales_item.item_sub_group_descr ,SALES_TERRITORY.TERR_DESCR,SALES_TERRITORY.REGION_DESCR) dwh, sm_sales_brand_mst brnd "
					+ " WHERE brnd.brand_code(+) = dwh.sub_grp "
					+ " AND brnd.div_code(+) = dwh.item_ser "
					+ " AND brnd.fin_year(+) = dwh.fin_year "
					+ " GROUP BY dwh.fin_year, dwh.item_ser,DWH.TERR_CODE,DWH.ZONE_CODE,DWH.ZONE_DESCR,DWH.TERR_DESCR,sub_grp ,grp_nm,DWH.METRO_DSCR) a, "
					+ " sm_sales_div_mst b, "
					+ " (SELECT   finyr, table_no, SUM (psr) AS psr "
					+ " FROM (SELECT   SUBSTR (version_id, 3, 4) AS finyr, table_no, "
					+ " pool_code, TO_NUMBER (MAX (no_psr_terr)) AS psr "
					+ " FROM starclub.emp_sales "
					+ " WHERE level_no = 4 "
					+ " GROUP BY SUBSTR (version_id, 3, 4), table_no, pool_code) "
					+ " GROUP BY finyr, table_no) c "
					+ " WHERE TRIM (a.item_ser) = TRIM (b.div_code) "
					+ " AND b.fin_year = a.fin_year "
					+ " AND TRIM (a.item_ser) = TRIM (c.table_no) "
					+ " AND c.finyr = SUBSTR (a.fin_year, 3, 2) || SUBSTR (a.fin_year, 6, 2) "
					+ " AND b.div_group <> 'OTHERS'  "
					+ " AND TRIM(a.brand_name) =TRIM('"+ brandName + "')"
					+ " AND TRIM(b.div_descr) =TRIM('"+ divDescr + "')"
					+ " AND TRIM(A.ZONE_descr) = TRIM('" +zoneDescr + "')"
					+ " GROUP BY b.div_group, b.div_code,b.div_descr,A.ZONE_CODE,A.ZONE_DESCR,BRAND_NAME,BRAND_CODE,CASE WHEN A.METRO_DSCR IS NULL THEN 'xOTHERS' ELSE  A.METRO_DSCR END "
					+ " ORDER BY ROUND(SUM(a.sale_ytd_cy)/10000000,1) desc,CASE WHEN A.METRO_DSCR IS NULL THEN 'xOTHERS' ELSE  A.METRO_DSCR END";


  			pstmt = conn.prepareStatement(sql);
  			rs    = pstmt.executeQuery();
  			int count = 0;			
  			while (rs.next())
  			{
  				rowData = new JSONObject();
  				rowData.put("metro_descr", checkNull(rs.getString("METRO_DSCR")));
  				rowData.put("ytd_cy_sales", rs.getString("ytd_cy_sales"));
  				rowData.put("ytd_gr", rs.getString("ytd_gr"));
  				rowData.put("ytd_ach_extra", rs.getString("ytd_ach_extra"));
  				rowData.put("ytd_ach_per", rs.getString("YTD_ach_per"));
  				
				//Add new code for Monthly sales dashboard on date7-jan-15 by Dhanendra
                rowData.put("ytd_ly_sales", rs.getString("YTD_LY_SALES"));
				rowData.put("ytd_ho_trgt", rs.getString("YTD_HO_TRGT"));									
				rowData.put("retu_ytd_prct", rs.getString("RETU_YTD_PRCT"));
				//Add new new property on date 7-Jan-15 by Birendra Pandey for Month sales graph
				rowData.put("reqd_mthly", rs.getString("REQD_MTHLY"));
				rowData.put("avg_mthly", rs.getString("AVG_MTHLY"));
				rowData.put("mth_cy_sales", rs.getString("MTH_CY_SALES"));
				rowData.put("mth_ho_trgt", rs.getString("MTH_HO_TRGT"));
				rowData.put("mth_ach_per", rs.getString("MTH_ACH_PER"));
				rowData.put("mth_gr", rs.getString("MTH_GR"));
			   //add new property for  PMPM on 7/01/2015 by Birendra Pandey
				rowData.put("pmpm", rs.getString("PMPM"));
				rowData.put("pmpm_ly", rs.getString("PMPM_LY"));
				//End new code for Monthly sales dashboard on date7-jan-15 by Dhanendra
  				rawDataMetroWiseJson.put(count, rowData);
  				count++;
  			}
  		}
  			System.out.println("fetch Data for brand-zone wise Metro  Detail====" + rawDataMetroWiseJson.toString());

  		} catch (Exception e)
  		{
  			e.printStackTrace();
  			throw new ITMException(e);
  		} finally
  		{
  			try
  			{
  				if (conn != null)
  				{
  					if (rs != null)
  					rs.close();
  					rs = null;
  					if (pstmt != null)
  					pstmt.close();
  					pstmt = null;
  					conn.close();
  					conn = null;
  				}
  				conn = null;
  			} catch (Exception d)
  			{
  				d.printStackTrace();
  				System.out.println("Exception in :SalesPersonSales:getBrandZoneWiseMetroDetail:" + d.getMessage());
  				throw new ITMException(d);
  			}
  		}
  		return rawDataMetroWiseJson;
      }
  	
  	/** end of method getBrandZoneWiseMetroDetail() **/
    
    
    
  	/*** 
	 * Method Name      : getMnthSalesDivWiseGraphData(String dataSourceName, String month)
	 * Servlet Name     : SalesPerfrmncDivisionWiseServlet
	 * Metadataxml Name : salesdashboard.xml
	 * Description      : This method returns  raw data for rendering the YTD PMPM Division-wise graph. 
	 * Graph Caption    :
	 *                    1. YTD PMPM Division-wise
	 * ***/
	@SuppressWarnings("unchecked")
	public JSONObject getMnthSalesDivWiseGraphData(String dataSourceName,String month) throws RemoteException, ITMException
	{		
		JSONObject rawDataMnthDivWiseSalesJson = new JSONObject();
		JSONObject rowData = null;
		String sql         = "";
		String finYear     = "";
		ResultSet rs       = null;
		PreparedStatement pstmt = null;
		Connection conn    = null;
		try
		{
		if(month!=null && month.trim().length()>0)
		{
	    	/*conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;*/
			/*add new code for connection DB on dated:15062016 by Nikhil*/
			conn = getConnection();
			System.out.println("Comming  month inside getMnthSalesDivWiseGraphData ==="+month);					
			String selectedMonth  = month.substring(4, 6);				
			if(selectedMonth.trim().equalsIgnoreCase("01") ||selectedMonth.trim().equalsIgnoreCase("02") ||selectedMonth.trim().equalsIgnoreCase("03"))
			{
		    	finYear = String.valueOf(Integer.parseInt(month.substring(0, 4))-1)+"-"+month.substring(2, 4);
	    	}
			else
			{
				finYear = month.substring(0, 4)+"-"+ (String.valueOf(Integer.parseInt(month.substring(0, 4))+1)).substring(2, 4);
			}
			System.out.println("updates month and year from dcoding in getMnthSalesDivWiseGraphData =="+month+"finYear =="+finYear);
						
			sql  =" SELECT  b.DIV_NO, b.DIV_DESCR,( CASE WHEN SUBSTR('"+month+"' ,5,2) =3 THEN ROUND(0 ,1) WHEN SUBSTR('"+month+"' ,5,2) <3 THEN ROUND(SUM(a.hotrgt_annual_cy-a.sale_ytd_cy)/(12- SUBSTR('"+month+"' ,5,2)-9) /10000000,1)       ELSE ROUND(SUM(a.hotrgt_annual_cy-a.sale_ytd_cy)/(12- SUBSTR('"+month+"' ,5,2)+3) /10000000,1) END ) AS REQD_MTHLY,ROUND(SUM(a.sale_ytd_cy)/ (CASE WHEN SUBSTR('"+month+"' ,5,2)<4 THEN SUBSTR('"+month+"' ,5,2)+9 ELSE SUBSTR('"+month+"' ,5,2)-3 END)/10000000,1) AS AVG_MTHLY,ROUND(SUM(a.sale_mth_cy)/10000000,1) AS MTH_CY_SALES,ROUND(SUM(a.sale_mth_ly)/10000000,1) AS MTH_LY_SALES,ROUND(SUM(a.hotrgt_mth_cy)/10000000,1) AS MTH_HO_TRGT,"
			+" (CASE WHEN SUM(a.sale_mth_ly)<>0 THEN ROUND(SUM(a.sale_mth_cy - a.sale_mth_ly)/SUM(a.sale_mth_ly)*100,1) ELSE ROUND(9.99*100,1)  END) AS MTH_GR,"
			+ "( CASE WHEN   SUM (a.hotrgt_mth_cy) =0 THEN  0 ELSE "
	        +" (CASE WHEN ROUND (SUM (a.sale_mth_cy) / SUM (a.hotrgt_mth_cy) * 100, 1) <-200 THEN -200 "
            +" WHEN ROUND (SUM (a.sale_mth_cy) / SUM (a.hotrgt_mth_cy) * 100, 1) >200 THEN 200 ELSE "
            +" ROUND (SUM (a.sale_mth_cy) / SUM (a.hotrgt_mth_cy) * 100, 1) END) end) AS MTH_ACH_PER, "			
			+" ROUND(SUM(a.sale_ytd_cy)/10000000,1) AS YTD_CY_SALES,ROUND(SUM(a.sale_ytd_ly)/10000000,1) AS YTD_LY_SALES,ROUND(SUM(a.hotrgt_ytd_cy)/10000000,1) AS YTD_HO_TRGT, (CASE WHEN SUM(a.sale_ytd_ly)<>0 THEN ROUND(SUM(a.sale_ytd_cy - a.sale_ytd_ly)/SUM(a.sale_ytd_ly)*100,1) ELSE ROUND(9.99*100,1)  END) AS YTD_GR, ROUND(SUM(a.sale_Qrt1_cy)/10000000,1) AS Q1,ROUND(SUM(a.sale_Qrt2_cy)/10000000,1) AS Q2,ROUND(SUM(a.sale_Qrt3_cy)/10000000,1) AS Q3,ROUND(SUM(a.sale_Qrt4_cy)/10000000,1) AS Q4,ROUND(SUM(a.sale_ytd_cy)/100000/SUM(c.psr)/ (CASE WHEN SUBSTR('"+month+"' ,5,2)<4 THEN SUBSTR('"+month+"' ,5,2)+9 ELSE SUBSTR('"+month+"' ,5,2)-3 END) ,2) AS PMPM,round(SUM(b.pmpm_ly),2) AS PMPM_LY,ROUND(SUM(a.sale_ytd_cy)/100000/SUM(c.psr)/(CASE WHEN SUBSTR('"+month+"' ,5,2)<4 THEN SUBSTR('"+month+"' ,5,2)+9 ELSE SUBSTR('"+month+"' ,5,2)-3 END),2) - round(SUM(b.pmpm_ly),2) AS INC_PMPM,ROUND(SUM(a.sale_ytd_cy-a.hotrgt_ytd_cy)/10000000,1) AS YTD_ACH_EXTRA,(CASE WHEN SUM(a.sale_ytd_cy)<>0 THEN ROUND(SUM(a.retu_ytd_cy)/SUM(a.sale_ytd_cy)*100,1) ELSE ROUND(9.99*100,1) END) AS RETU_YTD_PRCT,sum(b.bud_inc_pmpm) as bud_inc_pmpm FROM (SELECT dwh.fin_year , dwh.item_ser,SUM(sale_mth_cy) AS sale_mth_cy,SUM(sale_mth_ly) AS sale_mth_ly,SUM(trgt_mth_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) AS hotrgt_mth_cy,SUM(sale_YTD_cy) AS sale_YTD_cy,SUM(sale_YTD_ly) AS sale_YTD_ly,SUM(trgt_YTD_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) AS hotrgt_ytd_cy,SUM(sale_Qrt1_cy) AS sale_Qrt1_cy, "
			+" SUM(sale_Qrt2_cy) AS sale_Qrt2_cy,SUM(sale_Qrt3_cy) AS sale_Qrt3_cy,SUM(sale_Qrt4_cy) AS sale_Qrt4_cy,SUM(trgt_annual_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100) AS hotrgt_annual_cy,SUM(retu_ytd_cy) AS retu_ytd_cy FROM(SELECT fin_year , SM_SALES_SUMM_WIDE.item_ser, "  
			+" sales_item.item_sub_group AS sub_grp, (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(CY_SALE_MTH_APR) WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_SALE_MTH_MAY) WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(CY_SALE_MTH_JUN)WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_SALE_MTH_JUL) WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_SALE_MTH_AUG) WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(CY_SALE_MTH_SEP) WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_SALE_MTH_OCT) WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(CY_SALE_MTH_NOV) WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(CY_SALE_MTH_DEC) WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_SALE_MTH_JAN) WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(CY_SALE_MTH_FEB) WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(CY_SALE_MTH_MAR) END ) AS sale_mth_cy, "
			+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(LY_SALE_MTH_APR) WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(LY_SALE_MTH_MAY) WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(LY_SALE_MTH_JUN)  WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(lY_SALE_MTH_JUL) WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(lY_SALE_MTH_AUG) WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(lY_SALE_MTH_SEP) WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(lY_SALE_MTH_OCT) WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(lY_SALE_MTH_NOV) WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(lY_SALE_MTH_DEC) WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(lY_SALE_MTH_JAN) WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(lY_SALE_MTH_FEB) WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(lY_SALE_MTH_MAR) END ) AS sale_mth_ly, "
			+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(FLD_TRGT_MTH_APR) WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(FLD_TRGT_MTH_MAY) WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(FLD_TRGT_MTH_JUN)WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(FLD_TRGT_MTH_JUL) WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(FLD_TRGT_MTH_AUG) WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(FLD_TRGT_MTH_SEP) WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(FLD_TRGT_MTH_OCT) WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(FLD_TRGT_MTH_NOV) WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(FLD_TRGT_MTH_DEC) WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(FLD_TRGT_MTH_JAN) WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(FLD_TRGT_MTH_FEB) WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(FLD_TRGT_MTH_MAR) END ) AS trgt_mth_cy, "
			+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(CY_SALE_YTD_JUN) WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(CY_SALE_YTD_SEP) WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(CY_SALE_YTD_NOV) WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(CY_SALE_YTD_DEC) WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(CY_SALE_YTD_FEB) WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(CY_SALE_YTD_MAR) END ) AS sale_YTD_cy, "
			+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(lY_SALE_YTD_APR) WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(lY_SALE_YTD_MAY) WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(lY_SALE_YTD_JUN) WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(lY_SALE_YTD_JUL) WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(lY_SALE_YTD_AUG) WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(lY_SALE_YTD_SEP) WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(lY_SALE_YTD_OCT) WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(lY_SALE_YTD_NOV) WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(lY_SALE_YTD_DEC) WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(lY_SALE_YTD_JAN) WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(lY_SALE_YTD_FEB) WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(lY_SALE_YTD_MAR) END ) AS sale_YTD_ly, "
			+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(FLD_TRGT_YTD_APR) WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(FLD_TRGT_YTD_MAY) WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(FLD_TRGT_YTD_JUN) WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(FLD_TRGT_YTD_JUL) WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(FLD_TRGT_YTD_AUG) WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(FLD_TRGT_YTD_SEP) WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(FLD_TRGT_YTD_OCT) WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(FLD_TRGT_YTD_NOV) WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(FLD_TRGT_YTD_DEC) WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(FLD_TRGT_YTD_JAN) WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(FLD_TRGT_YTD_FEB) WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(FLD_TRGT_YTD_MAR) END ) AS trgt_YTD_cy, "
			+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY)  ELSE  SUM(CY_SALE_YTD_JUN)  END ) AS sale_Qrt1_cy, "
			+" (CASE WHEN SUBSTR('"+month+"' ,5,2) >='04' AND  SUBSTR('"+month+"' ,5,2) <='06' THEN 0 WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) - SUM(CY_SALE_YTD_JUN) WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) - SUM(CY_SALE_YTD_JUN) ELSE  SUM(CY_SALE_YTD_SEP) - SUM(CY_SALE_YTD_JUN) END ) AS sale_Qrt2_cy, "  
			+" (CASE WHEN SUBSTR('"+month+"' ,5,2) >='04' AND  SUBSTR('"+month+"' ,5,2) <='09' THEN 0 WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) - SUM(CY_SALE_YTD_SEP) WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(CY_SALE_YTD_NOV) - SUM(CY_SALE_YTD_SEP) ELSE  SUM(CY_SALE_YTD_DEC) - SUM(CY_SALE_YTD_SEP) END ) AS sale_Qrt3_cy, "          
			+" (CASE WHEN SUBSTR('"+month+"' ,5,2) >='04' AND  SUBSTR('"+month+"' ,5,2) <='12' THEN 0 WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) - SUM(CY_SALE_YTD_DEC) WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(CY_SALE_YTD_FEB) - SUM(CY_SALE_YTD_DEC) ELSE  SUM(CY_SALE_YTD_MAR) - SUM(CY_SALE_YTD_DEC) END ) AS sale_Qrt4_cy, "
			+" SUM(FLD_TRGT_YTD_MAR) AS trgt_annual_cy, "
			+" (CASE WHEN SUBSTR('"+month+"' ,5,2) ='04' THEN SUM(CY_RETU_YTD_APR) WHEN SUBSTR('"+month+"' ,5,2) ='05' THEN SUM(CY_RETU_YTD_MAY)                          WHEN SUBSTR('"+month+"' ,5,2) ='06' THEN SUM(CY_RETU_YTD_JUN)                          WHEN SUBSTR('"+month+"' ,5,2) ='07' THEN SUM(CY_RETU_YTD_JUL) WHEN SUBSTR('"+month+"' ,5,2) ='08' THEN SUM(CY_RETU_YTD_AUG) WHEN SUBSTR('"+month+"' ,5,2) ='09' THEN SUM(CY_RETU_YTD_SEP) WHEN SUBSTR('"+month+"' ,5,2) ='10' THEN SUM(CY_RETU_YTD_OCT)                          WHEN SUBSTR('"+month+"' ,5,2) ='11' THEN SUM(CY_RETU_YTD_NOV)                          WHEN SUBSTR('"+month+"' ,5,2) ='12' THEN SUM(CY_RETU_YTD_DEC)  WHEN SUBSTR('"+month+"' ,5,2) ='01' THEN SUM(CY_RETU_YTD_JAN) WHEN SUBSTR('"+month+"' ,5,2) ='02' THEN SUM(CY_RETU_YTD_FEB) WHEN SUBSTR('"+month+"' ,5,2) ='03' THEN SUM(CY_RETU_YTD_MAR) END ) AS retu_ytd_cy "
			+" FROM SM_SALES_SUMM_WIDE, sales_item WHERE trim(fin_year)= (CASE WHEN SUBSTR('"+month+"' ,5,2)<4 THEN SUBSTR('"+month+"' -100 ,1,4)||'-'||SUBSTR('"+month+"' ,3,2) "              
			+" ELSE SUBSTR('"+month+"' ,1,4)||'-' || SUBSTR('"+month+"' +100,3,2) END) AND '"+month+"' ='"+month+"' "                
			+" AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code AND sales_item.item_sub_group NOT IN ('CU','BJ') "
			+" GROUP BY fin_year ,SM_SALES_SUMM_WIDE.item_ser, sales_item.item_sub_group "    
			+" ) dwh,     SM_SALES_BRAND_MST brnd "  
			+" WHERE brnd.brand_code(+) = dwh.sub_grp    AND brnd.div_code(+) = dwh.item_ser    AND brnd.fin_year(+) = dwh.fin_year "  
			+" GROUP BY dwh.fin_year, dwh.item_ser ) a, "
			+" SM_SALES_DIV_MST b,( SELECT finyr, table_no, SUM(psr) AS psr "
			+" FROM ( SELECT SUBSTR(version_id,3,4) AS finyr ,table_no, pool_code,TO_NUMBER(MAX(NO_PSR_TERR)) AS PSR "
			+" FROM starclub.emp_sales WHERE LEVEL_NO = 4 "
			+" GROUP BY SUBSTR(version_id,3,4) ,table_no, pool_code ) GROUP BY finyr, table_no ) c "
			+" WHERE trim(a.item_ser)=trim(b.div_code) AND b.fin_year=a.fin_year AND trim(a.item_ser)=trim(c.table_no) "
			+" AND c.finyr = SUBSTR(a.fin_year,3,2)||SUBSTR(a.fin_year,6,2) AND b.DIV_DESCR <> 'OTHERS' GROUP BY b.DIV_NO, b.DIV_DESCR ORDER BY  DIV_NO,DIV_DESCR ";


			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;			
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("div_descr", checkNull(rs.getString("DIV_DESCR")));
				rowData.put("mth_sales_val", rs.getString("MTH_CY_SALES"));
				rowData.put("ho_ach", rs.getString("MTH_ACH_PER"));
				rowData.put("gr_perc", rs.getString("MTH_GR"));
				rowData.put("pmpm", rs.getString("PMPM"));
				rowData.put("inc_pmpm", rs.getString("INC_PMPM"));
				rowData.put("bud_inc_pmpm", rs.getString("BUD_INC_PMPM"));
				rowData.put("mth_ly_sales", rs.getString("MTH_LY_SALES"));
				rawDataMnthDivWiseSalesJson.put(count, rowData);
				count++;
			}
		}
			System.out.println("fetch Data for Mnth Sales Div Wise Graph rawjson====" + rawDataMnthDivWiseSalesJson.toString());

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :SalesPersonSales:getMnthSalesDivWiseGraphData:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataMnthDivWiseSalesJson;
	}
	/***  end of method getMnthSalesDivWiseGraphData() **/	
	
	/* Start Code for Globle child grid on 14/04/2015 -Dhanendra*/
	@Override
	public JSONObject getGlobleChildGridDet(String dataSourceName,String month, String parameters, String linkMetadate) throws RemoteException,ITMException 
	{		
		JSONObject rawDataGlobleChildGridJson = new JSONObject();
		JSONObject rowData = null;
		String sql         = "";		
		ResultSet rs       = null;
		PreparedStatement pstmt = null;
		Connection conn    = null;
		String brandName   = "";
		try
		{
			System.out.println("linkMetadate------>"+linkMetadate);
			if(month!=null && month.trim().length()>0 && parameters!=null)
			{
		    	/*conn = connDriver.getConnectDB(dataSourceName);
				connDriver = null;*/
				/*add new code for connection DB on dated:15062016 by Nikhil*/
				conn = getConnection();
				if(linkMetadate.equals("topbrandgridchild"))
				{
				  
					String[] splitArr = parameters.trim().split("\\s+");
					System.out.println(" month======" + month);
					System.out.println(" brandName======" + splitArr[0]);
					brandName = splitArr[0];					
					sql ="SELECT cust_name||' ('||cust_code||')' AS party, ROUND(cmth_val/100000,1) AS cy_mth," +
						"ROUND(lmth_val/100000,1) AS ly_mth, ( CASE WHEN lmth_val=0 THEN 0 WHEN " +
						"ROUND( (cmth_val-lmth_val)/ lmth_val *100,1) >200 THEN 200 WHEN " +
						"ROUND( (cmth_val-lmth_val)/ lmth_val *100,1) <-200 THEN -200 ELSE " +
						"ROUND( (cmth_val-lmth_val)/ lmth_val *100,1) END ) AS mth_gr, " +
						"ROUND(cytd_val/100000,1) AS cy_ytd, ROUND(lytd_val/100000,1) AS ly_ytd," +
						" ( CASE WHEN lytd_val=0 THEN 0 WHEN ROUND( (cytd_val-lytd_val)/ lytd_val *100,1) >200 " +
						"THEN 200 WHEN ROUND( (cytd_val-lytd_val)/ lytd_val *100,1) <-200 THEN -200 " +
						"ELSE ROUND( (cytd_val-lytd_val)/ lytd_val *100,1) END ) AS ytd_gr, " +
						"ROUND(lfull_val/100000,1) AS ly_fullyr FROM brand_cus WHERE prd_code='"+month+"'" +
						" AND trim(brand)='"+brandName+"' ORDER BY cytd_val DESC ";
		            
					
					//sql = "select  1 as PARTY, 2 as CY_MTH, 2 as LY_MTH, 2 as MTH_GR,2 as CY_YTD,2 as LY_YTD,2 as YTD_GR,2 as LY_FULLYR from dual"; 
		
					pstmt = conn.prepareStatement(sql);
					rs = pstmt.executeQuery();
					int count = 0;			
					while (rs.next())
					{
						rowData = new JSONObject();
						rowData.put("party", checkNull(rs.getString("PARTY")));
						rowData.put("cy_mth", rs.getString("CY_MTH"));
						rowData.put("ly_mth", rs.getString("LY_MTH"));
						rowData.put("mth_gr", rs.getString("MTH_GR"));
						rowData.put("cy_ytd", rs.getString("CY_YTD"));
						rowData.put("ly_ytd", rs.getString("LY_YTD"));
						rowData.put("ytd_gr", rs.getString("YTD_GR"));
						rowData.put("ly_fullyr", rs.getString("LY_FULLYR"));
						rawDataGlobleChildGridJson.put(count, rowData);
						count++;
					}
				}
			}
				System.out.println("fetch Data for Mnth Sales Div Wise Graph rawjson====" + rawDataGlobleChildGridJson.toString());
	
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :SalesPersonSales:getMnthSalesDivWiseGraphData:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataGlobleChildGridJson;
	}
	/* End Code for Globle child grid on 14/04/2015 -Dhanendra*/
	
	
	private String checkNull(String str)
	{
		if(str == null)
		{
			return "";
		}
		else
		{
			return str ;
		}

	}
}
