/*
 * Decompiled with CFR 0.152.
 */
package com.fusioncharts.exporter.error;

import com.fusioncharts.exporter.beans.ExportConfiguration;
import com.fusioncharts.exporter.beans.LogMessageSetVO;
import com.fusioncharts.exporter.error.LOGMESSAGE;
import com.fusioncharts.exporter.error.Status;
import java.io.File;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class ErrorHandler {
    private static Logger logger = null;

    static {
        logger = Logger.getLogger(ErrorHandler.class.getName());
    }

    public static String buildResponse(LogMessageSetVO logMessageSetVO, boolean isHTML) {
        String string;
        StringBuffer err_buf = new StringBuffer();
        StringBuffer warn_buf = new StringBuffer();
        String errors = "";
        String notices = "";
        Set<LOGMESSAGE> errorSet = logMessageSetVO.getErrorsSet();
        Set<LOGMESSAGE> warningSet = logMessageSetVO.getWarningSet();
        for (Enum enum_ : errorSet) {
            err_buf.append(enum_.toString());
        }
        for (Enum enum_ : warningSet) {
            err_buf.append(enum_.toString());
        }
        errors = err_buf.length() > 0 ? String.valueOf(isHTML ? "<BR>" : "&") + "statusMessage=" + err_buf.substring(0) + (isHTML ? "<BR>" : "&") + "statusCode=" + Status.FAILURE.getCode() : "statusMessage=" + (Object)((Object)Status.SUCCESS) + "&statusCode=" + Status.SUCCESS.getCode();
        if (warn_buf.length() > 0) {
            notices = String.valueOf(isHTML ? "<BR>" : "&") + "notice=" + warn_buf.substring(0);
        }
        String string2 = (string = logMessageSetVO.getOtherMessages()) == null ? "" : string;
        logger.info("Errors=" + errors);
        logger.info("Notices=" + notices);
        logger.info("Miscellaneous Messages=" + string2);
        return String.valueOf(errors) + notices + string2;
    }

    public static String buildResponse(String eCodes, boolean isHTML) {
        StringTokenizer tokenizer = new StringTokenizer(eCodes, ",");
        StringBuffer err_buf = new StringBuffer();
        StringBuffer warn_buf = new StringBuffer();
        String errors = "";
        String notices = "";
        String errCode = null;
        while (tokenizer.hasMoreTokens()) {
            errCode = tokenizer.nextToken();
            if (errCode.length() <= 0) continue;
            if (errCode.indexOf("E") != -1) {
                err_buf.append((Object)LOGMESSAGE.valueOf(errCode));
                continue;
            }
            warn_buf.append((Object)LOGMESSAGE.valueOf(errCode));
        }
        errors = err_buf.length() > 0 ? String.valueOf(isHTML ? "<BR>" : "&") + "statusMessage=" + err_buf.substring(0) + (isHTML ? "<BR>" : "&") + "statusCode=" + Status.FAILURE.getCode() : "statusMessage=" + (Object)((Object)Status.SUCCESS) + "&statusCode=" + Status.SUCCESS.getCode();
        if (warn_buf.length() > 0) {
            notices = String.valueOf(isHTML ? "<BR>" : "&") + "notice=" + warn_buf.substring(0);
        }
        logger.info("Errors=" + errors);
        logger.info("Notices=" + notices);
        return String.valueOf(errors) + notices;
    }

    public static LogMessageSetVO checkServerSaveStatus(String fileName) {
        LogMessageSetVO errorSetVO = new LogMessageSetVO();
        String pathToSaveFolder = ExportConfiguration.SAVEABSOLUTEPATH;
        File saveFolder = new File(pathToSaveFolder);
        if (!saveFolder.exists()) {
            errorSetVO.addError(LOGMESSAGE.E508);
        } else if (!saveFolder.canWrite()) {
            errorSetVO.addError(LOGMESSAGE.E403);
        } else {
            String completeFilePath = String.valueOf(pathToSaveFolder) + File.separator + fileName;
            File saveFile = new File(completeFilePath);
            if (saveFile.exists()) {
                errorSetVO.addWarning(LOGMESSAGE.W509);
                if (ExportConfiguration.OVERWRITEFILE) {
                    errorSetVO.addWarning(LOGMESSAGE.W510);
                    if (!saveFile.canWrite()) {
                        errorSetVO.addError(LOGMESSAGE.E511);
                    }
                } else if (!ExportConfiguration.INTELLIGENTFILENAMING) {
                    errorSetVO.addError(LOGMESSAGE.E512);
                }
            }
        }
        return errorSetVO;
    }

    public static boolean doesServerSaveFolderExist() {
        boolean saveFolderExists = true;
        String pathToSaveFolder = ExportConfiguration.SAVEABSOLUTEPATH;
        File saveFolder = new File(pathToSaveFolder);
        if (!saveFolder.exists()) {
            saveFolderExists = false;
        }
        return saveFolderExists;
    }
}

