/**
* PURPOSE : To confirmed the Transaction for packing component.
* AUTHOR : Sankara
*/ 

package ibase.webitm.ejb.wms;

import ibase.utility.EMail;
import ibase.utility.CommonConstants;
import ibase.webitm.utility.*;
import ibase.webitm.ejb.*;
import ibase.system.config.*;
import ibase.webitm.utility.ITMException;

import java.io.*;
import java.rmi.RemoteException;
import java.sql.*;
import java.util.*;
import java.text.*;
import javax.ejb.*;
import javax.naming.InitialContext;
import javax.ejb.Stateless; 
import org.w3c.dom.*;
import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.stream.StreamSource;
import javax.xml.parsers.*;

@Stateless 
public class WaveHoldEJB extends ActionHandlerEJB implements WaveHoldEJBLocal, WaveHoldEJBRemote 
{
    /**
	 * The public method is used for confirming the service complaint transaction
	 * Returns confirmation message on successfull confirm otherwise returns error message
	 * @param tranID is the transaction id to be confirmed
	 * @param xtraParams contais additional information such as loginEmpCode,loginCode,chgTerm etc
	 * @param forcedFlag (true or false)
	 */
	public String confirm( String waveID, String xtraParams, String forcedFlag ) throws RemoteException,ITMException
	{
		String retString = "";
		Connection conn = null;	
		boolean isConn= false;
		
		try
		{
			retString = this.confirm( waveID,xtraParams, forcedFlag ,conn ,isConn);
			if ( retString != null && retString.length() > 0 )
			{
				throw new Exception("Exception while calling confirm for wave  Id:["+waveID+"]");
			}
		}
		catch( Exception exception )
		{
			System.out.println("Exception in [WaveHoldEJB] getCurrdateAppFormat " + exception.getMessage());
		}
		return retString;
	}
	public String confirm(String waveID, String xtraParams, String forcedFlag, Connection conn, boolean connStatus) throws RemoteException, ITMException
	{
		String holdStatus = "";
		String sql = "";		
		String retString = "";
		String loginEmpCode = "";
		
		boolean isError = false;
		int updCnt = 0;
		PreparedStatement pstmtUpd = null;
		PreparedStatement pstmtSql = null;
		ResultSet rs = null;
		ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
		
		try
		{
			if ( conn == null )
			{
				ConnDriver connDriver = new ConnDriver();
				conn = connDriver.getConnectDB("DriverITM");
				connDriver = null;
				conn.setAutoCommit(false);
				connStatus = true;
			}

			GenericUtility genericUtility = GenericUtility.getInstance();
			loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			java.sql.Timestamp currDate = new java.sql.Timestamp( System.currentTimeMillis() );

			sql = "SELECT HOLD_STATUS FROM WAVE_TASK WHERE WAVE_ID = ?";
			pstmtSql = conn.prepareStatement(sql);
			pstmtSql.setString(1, waveID);
			rs = pstmtSql.executeQuery();
			if( rs.next() )
			{
				holdStatus = checkNull( rs.getString("HOLD_STATUS") );
			}	
			rs.close();
			rs = null;
			pstmtSql.close();
			pstmtSql = null;

			sql = "UPDATE WAVE_TASK SET HOLD_STATUS = ? WHERE WAVE_ID = ? ";
			pstmtUpd = conn.prepareStatement(sql);
			
			if( holdStatus.trim().equalsIgnoreCase("N") )
			{
				holdStatus = "Y";
			}
			else
			{
				holdStatus = "N";
			}
			pstmtUpd.setString(1, holdStatus);
			pstmtUpd.setString(2, waveID);
			updCnt = pstmtUpd.executeUpdate();
			
			if( updCnt > 0 )
			{					
				System.out.println( updCnt + " rows updated successfully" );
			}
			else
			{
				System.out.println( updCnt + " rows Count Null" );
			}
			
			if(pstmtUpd != null)
			{
				pstmtUpd.close();
				pstmtUpd = null;
			}
			 
		}
		
		catch(Exception e)
		{
			isError = true;
			try
			{
				conn.rollback();
			}
			catch (Exception e1)
			{
			}
			e.printStackTrace();
			System.out.println("Exception ::"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( !isError && connStatus )
				{
					conn.commit(); 
					
					if("Y".equalsIgnoreCase(holdStatus))
					{
						retString = itmDBAccess.getErrorString("","WAVEHOLD","");
					}
					else
					{
						retString = itmDBAccess.getErrorString("","WAVERELS","");
					}
				}
				else if (isError && connStatus)
				{
					conn.rollback();
				}
				if(rs != null)
				{
					rs.close();
					rs = null;					
				}
				if(pstmtUpd != null)
				{
					pstmtUpd.close();
					pstmtUpd = null;					
				}
				if( conn != null && ! conn.isClosed() && connStatus)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println(e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("Returning Result ::"+retString);
		return retString;
	}
	private String checkNull( String input )
	{
		if( input == null )
		{
			input = "";
		}
		return input;
	}
}
