<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:template match="/">

<html>
<script type="text/javascript" src="/ibase/webitm/js/prodWiz_Common.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/prodWiz_Form_II.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/prodWiz_Popup.js"></script>

<script type="text/javascript" src="/ibase/webitm/js/jquery-1.10.2.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.datepicker.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery-ui-1.10.4.custom.min.js"></script>

<script type="text/javascript" src="/ibase/webitm/js/sortable_table.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/fixed_table_rc.js"></script>

<!-- <link href="/ibase/webitm/css/DD/ProductWizard.css" rel="stylesheet"/> -->
<link type="text/css" rel="stylesheet" href="/ibase/webitm/css/DD/jquery-ui-1.10.4.custom.min.css" />
<link href="/ibase/webitm/css/DD/fixed_table_rc.css" rel="stylesheet"/> 
<link type="text/css" rel="stylesheet" href="/ibase/webitm/css/htmlWizard.css"/>
<link type="text/css" rel="stylesheet" href="/ibase/webitm/css/productWiz.css"/> 

<script language="Javascript" src="/ibase/webitm/js/jquery.datetimepicker.full.js"></script>
<link type="text/css" rel="stylesheet" href="/ibase/webitm/css/jquery.datetimepicker.css"/>

<script>
<![CDATA[

	var sizes, colors, dimensions, itemDesc, sites;

	$(function() {
	
		sizes = document.getElementById("size_type").value;
		colors = document.getElementById("color_code_descr").value;
		dimensions = document.getElementById("dim_code_desc").value;
		itemDesc = document.getElementById("descr").value;
		sites = document.getElementById("site_codes").value;
		sitedesc = document.getElementById("site_desc").value;
		
		document.getElementById("showDiv").value = "1";
		
		createSizeColorTab();
		
		/*displaySKUItemDetails();*/
	});
	
	/*$(document).ready(function() {
		$('#sizeDtl').fxdHdrCol({
			fixedCols:  0,
			width:     "100%",
			height:    "95%",
			colModal: [
				   { width: 200, align: 'center' },
				   { width: 50, align: 'center' },
				   { width: 50, align: 'center' },
				   { width: 50, align: 'center' }
			],
			sort: true
		});
	});*/
	
	$(document).ready(function() {
	
	    $('#SKUItemId').fxdHdrCol({
			fixedCols:  0,
			width:     "100%",
			height:    "95%",
			colModal: [
				   { width: 27, align: 'center' },
				   { width: 55, align: 'center' },
				   { width: 350, align: 'left' },
				   { width: 300, align: 'left' },
				   { width: 110, align: 'left' },
				   { width: 150, align: 'left' },
				   { width: 150, align: 'left' },
				   { width: 250, align: 'left' },
				   { width: 120, align: 'center' },
				   { width: 120, align: 'center' },
				   { width: 120, align: 'center' },
				   { width: 80, align: 'center' },
				   { width: 80, align: 'center' },
				   { width: 80, align: 'center' },
				   { width: 80, align: 'center' },
				   { width: 120, align: 'center' },
				   { width: 120, align: 'center' },
				   { width: 120, align: 'center' },
				   { width: 120, align: 'center' },
				   { width: 150, align: 'center' },
				   { width: 150, align: 'center' },		  
			],
			sort: true
		});
	});
]]>
</script>
<!-- Changed by Sneha on 08-07-2016, to disable enter key [Start] -->
<!-- <body style="height: 100%; overflow: auto;" onload="getAppDateFormat()">  -->
<!-- Changed by Sneha on 08-07-2016, to disable enter key [End] -->

<!-- <body style="height: 100%; overflow: auto;" onload="getAppDateFormat(); setCustItemRef();">  -->

<body onload="getAppDateFormat(); setCustItemRef(); defaultBarcodeFlag();">  
<form name="prodWizFormII" id="prodWizFormII" METHOD="post" ACTION="/ibase/ITMWizardHandlerServlet"> 

<TABLE border="0" width="99%" height="2%" class="header_td header_table" cellpadding="0" cellspacing="0" >
	<TR>
		<div class='contentHeaderLbl'>
		<img src="/ibase/images/menuImages/web/Dailyactivityreport.png" onerror=" this.src= '/ibase/images/menuImages/errMenu.png' " style="position: absolute; margin-left: -20px;margin-top:9px; height: 20px; width: 20px;"/>
			<TD class="header_main header_td1" nowrap="true" valign="middle" > 
			      Product Wizard
			</TD>
		</div>
	</TR>
</TABLE>

<div id="innerDiv" style="overflow-y:hidden;overflow-x:auto;max-height:80%;width:99%">
	<table id="errorActivityTable" height="10%" class="tableClass"  style="margin: 0px 0px 0px 0px;position: relative;width: calc(literal('100% - 15px'));width: -moz-calc(literal('100% - 15px'));padding-right:0px; padding-left:5xp; width: -webkit-calc(literal('100% - 15px'));box-shadow: 3px 3px 3px gray;-moz-box-shadow:3px 3px 3px gray;-webkit-box-shadow: 3px 3px 3px gray;-o-box-shadow: 3px 3px 3px gray;background: rgba(255, 204, 0, 0.66);min-height: 50px;bottom:10px"  border="0" cellspacing="0" cellpadding="0"> 
			<xsl:for-each select="//error">
				<xsl:if test="position() = 1">
					<tr>	
						<td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"   nowrap="true" valign="bottom">
							Message :
						</td> 
						<td class="tdss_leftAlign"   style="background: rgba(255, 204, 0, 0.66);"   nowrap="true" valign="bottom">
							Description :
						</td>
						<td class="tdss_rightAlign"  style="background: rgba(255, 204, 0, 0.66);" nowrap="true" valign="bottom" colspan="2">
							<a href="#" style="text-decoration:none;" onclick="doHideMsg('errorActivityTable')"><font style="color:#000;text-decoration:none;padding-right:5px;" ><b>X</b></font></a>
						</td>
					</tr>
				</xsl:if>
				<xsl:variable name="message"><xsl:value-of select="message"/></xsl:variable>
				<xsl:variable name="description"><xsl:value-of select="description"/></xsl:variable>
				<xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
				<xsl:variable name="dbID"><xsl:value-of select="@domId"/></xsl:variable>  
				<xsl:variable name="column_name"><xsl:value-of select="@column_name"/></xsl:variable> 
				<tr style="background: rgba(255, 204, 0, 0.66);">
					 <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" nowrap="true">
						<xsl:value-of select="message"/>
					</td> 
					
					<td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" nowrap="true">
						<xsl:value-of select="description"/>
					</td>
					
					<td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"  nowrap="true">
					</td>
				</tr>
			</xsl:for-each>
			
			<xsl:for-each select="//error">
				<xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
				<xsl:if test="position() = 1">
					<xsl:if test="$type = 'W'">
						<tr style="background: rgba(255, 204, 0, 0.66);">
							<td class="tdss_leftAlign"  style="background: rgba(255, 204, 0, 0.66);"  nowrap="true" valign="bottom">
								<input  type="checkbox" name="forceSave" value="true" checked="checked" onClick="setChecked(this)"/>
							</td>
							<td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"  nowrap="true"></td>
						</tr>
					</xsl:if>
				</xsl:if>	
			</xsl:for-each>
	</table>
</div>
	
<!-- <div class="mainPage-Container" style="height: 100%;">
	
	 <div id="header">
		<div id="headingText">Product Wizard</div>
  	</div>  	
  	<div style='height: 40%;' id="headerDiv">
  	 <div style="width: 99%; margin-top: 5px;"> -->
	
	<div class="pageContentWrapper" style="height:72%;overflow:auto; ">
		<div id="headerDiv">	
	
			<xsl:for-each select="//Detail2">
				<xsl:variable name="item_parnt"><xsl:value-of select="item_parnt"/></xsl:variable>
				<xsl:variable name="item_parnt_desc"><xsl:value-of select="item_parnt_desc"/></xsl:variable>
				<xsl:variable name="item_type"><xsl:value-of select="item_type"/></xsl:variable>
				<xsl:variable name="item_type_desc"><xsl:value-of select="item_type_desc"/></xsl:variable>
				<xsl:variable name="item_ser"><xsl:value-of select="item_ser"/></xsl:variable>
				<xsl:variable name="itemser_descr"><xsl:value-of select="itemser_descr"/></xsl:variable>
				<xsl:variable name="descr"><xsl:value-of select="descr"/></xsl:variable>
				<xsl:variable name="grp_code"><xsl:value-of select="grp_code"/></xsl:variable>
				<xsl:variable name="grp_code_desc"><xsl:value-of select="grp_code_desc"/></xsl:variable>
				<xsl:variable name="loc_code"><xsl:value-of select="loc_code"/></xsl:variable>
				<xsl:variable name="stk_opt"><xsl:value-of select="stk_opt"/></xsl:variable>
				<xsl:variable name="site_codes"><xsl:value-of select="site_codes"/></xsl:variable>
				<xsl:variable name="site_desc"><xsl:value-of select="site_desc"/></xsl:variable>
				<xsl:variable name="size_type"><xsl:value-of select="size_type"/></xsl:variable>
				<xsl:variable name="dimension_desc"><xsl:value-of select="dimension_desc"/></xsl:variable>
				<xsl:variable name="dim_code_desc"><xsl:value-of select="dim_code_desc"/></xsl:variable>
				<xsl:variable name="color_codes"><xsl:value-of select="color_codes"/></xsl:variable>
				<xsl:variable name="color_code_descr"><xsl:value-of select="color_code_descr"/></xsl:variable>
				<xsl:variable name="size_codes"><xsl:value-of select="size_codes"/></xsl:variable>
				<xsl:variable name="phy_attr4"><xsl:value-of select="phy_attr4"/></xsl:variable>
				<xsl:variable name="phy_attr5"><xsl:value-of select="phy_attr5"/></xsl:variable>
				<xsl:variable name="price"><xsl:value-of select="price"/></xsl:variable>
				<xsl:variable name="curr_code"><xsl:value-of select="curr_code"/></xsl:variable>
				<xsl:variable name="unit"><xsl:value-of select="unit"/></xsl:variable>
				<xsl:variable name="loc_type"><xsl:value-of select="loc_type"/></xsl:variable>
				<xsl:variable name="track_shelf_life"><xsl:value-of select="track_shelf_life"/></xsl:variable>
				<xsl:variable name="unit_rate"><xsl:value-of select="unit_rate"/></xsl:variable>
				<xsl:variable name="item_category"><xsl:value-of select="item_category"/></xsl:variable>
				<xsl:variable name="category_descr"><xsl:value-of select="category_descr"/></xsl:variable>
				
				<xsl:variable name="supp_code"><xsl:value-of select="supp_code"/></xsl:variable>
				<xsl:variable name="supplier_desc"><xsl:value-of select="supplier_desc"/></xsl:variable>
				
				<xsl:variable name="item_length"><xsl:value-of select="item_length"/></xsl:variable>
				<xsl:variable name="item_width"><xsl:value-of select="item_width"/></xsl:variable>
				<xsl:variable name="item_height"><xsl:value-of select="item_height"/></xsl:variable>
				<xsl:variable name="item_gross_wt"><xsl:value-of select="item_gross_wt"/></xsl:variable>
				<xsl:variable name="price_list_dtl"><xsl:value-of select="price_list_dtl"/></xsl:variable>
				<xsl:variable name="supp_item_desc"><xsl:value-of select="supp_item_desc"/></xsl:variable>
				
				<xsl:variable name="item_sh_descr"><xsl:value-of select="item_sh_descr"/></xsl:variable>
				<xsl:variable name="long_desc"><xsl:value-of select="long_desc"/></xsl:variable>
				<xsl:variable name="meta_desc"><xsl:value-of select="meta_desc"/></xsl:variable>
				<xsl:variable name="meta_keywords"><xsl:value-of select="meta_keywords"/></xsl:variable>
				<xsl:variable name="meta_title"><xsl:value-of select="meta_title"/></xsl:variable>
				<xsl:variable name="img_path"><xsl:value-of select="img_path"/></xsl:variable>
				
				<xsl:variable name="login_code"><xsl:value-of select="login_code"/></xsl:variable>
				<xsl:variable name="chg_date"><xsl:value-of select="chg_date"/></xsl:variable>
				<xsl:variable name="chg_user"><xsl:value-of select="chg_user"/></xsl:variable>
				<xsl:variable name="chg_term"><xsl:value-of select="chg_term"/></xsl:variable>
				<xsl:variable name="pur_lead_time"><xsl:value-of select="pur_lead_time"/></xsl:variable>
				<xsl:variable name="location_descr"><xsl:value-of select="location_descr"/></xsl:variable>
				<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
				<!--Added by Parikshit on 20-APR-2015 [Added following fields] starts -->	
		        <xsl:variable name="shipper_size"><xsl:value-of select="shipper_size"/></xsl:variable>
				<xsl:variable name="case_length"><xsl:value-of select="case_length"/></xsl:variable>
				<xsl:variable name="case_width"><xsl:value-of select="case_width"/></xsl:variable>
				<xsl:variable name="size_height"><xsl:value-of select="size_height"/></xsl:variable>
				<xsl:variable name="case_gross_weight"><xsl:value-of select="case_gross_weight"/></xsl:variable>
				<xsl:variable name="case_net_weight"><xsl:value-of select="case_net_weight"/></xsl:variable>
			    <xsl:variable name="pack_size_dtl"><xsl:value-of select="pack_size_dtl"/></xsl:variable>
			    <xsl:variable name="size_type_desc"><xsl:value-of select="size_type_desc"/></xsl:variable>
			    <xsl:variable name="language"><xsl:value-of select="language"/></xsl:variable>
			    <xsl:variable name="language_desc"><xsl:value-of select="language_desc"/></xsl:variable>
				<xsl:variable name="language_dtl"><xsl:value-of select="language_dtl"/></xsl:variable>
				<xsl:variable name="tax"><xsl:value-of select="tax"/></xsl:variable>
				<xsl:variable name="tax_desc"><xsl:value-of select="tax_desc"/></xsl:variable>
				<xsl:variable name="item_commodity"><xsl:value-of select="item_commodity"/></xsl:variable>
				<xsl:variable name="date_format"><xsl:value-of select="date_format"/></xsl:variable><!--Added by parikshit kumbhar on 08/07/2015[to set date format]  -->
				<!--Added by Parikshit on 20-APR-2015 Ends -->	
				
				<!-- Added by Samadhan on 21/12/2015 [to set Size Discription Grid, limited edition,brand, brand descr] start -->
				<xsl:variable name="item_usage_type"><xsl:value-of select="item_usage_type"/></xsl:variable><!--limited edition-->
				<xsl:variable name="item_phy_attrib_24"><xsl:value-of select="item_phy_attrib_24"/></xsl:variable><!--brand code-->
				<xsl:variable name="brand_descr"><xsl:value-of select="brand_descr"/></xsl:variable><!--brand descr-->
				<!-- Added by Samadhan on 21/12/2015 [to set Size Discription Grid, limited edition,brand, brand descr] start -->
				
				<!--Changed by wasim on 05-08-2016 for tac chapter [START]-->
				<xsl:variable name="tax_chap"><xsl:value-of select="tax_chap"/></xsl:variable>
				<!--Changed by wasim on 05-08-2016 for tac chapter [END]-->
				
				<!-- Changed by Sneha on 26-09-2016, to add new field trade mark [Start] -->
				<xsl:variable name="trade_mark"><xsl:value-of select="trade_mark"/></xsl:variable>
				<!-- Changed by Sneha on 26-09-2016, to add new field trade mark [End] -->
				
				<!-- Changed by Sneha on 24-10-2016, to add new field customer item references [Start] -->
				<xsl:variable name="phy_attrib_4"><xsl:value-of select="phy_attrib_4"/></xsl:variable>
				
				<xsl:if test="$dbID = '0'">
				<input type="hidden" name="Detail2.{normalize-space($dbID)}.login_code" id ="login_code" value="{$login_code}" ISCHANGED="false"/>
				
				<strong>Parent Code: </strong><xsl:value-of select="item_parnt"/> - 
				<xsl:value-of select="item_parnt_desc"/>
				
				<div style="margin-top: 8px;"><strong>Product Matrix:</strong></div>

				<!-- <div id="sizeDtlDiv" style="height: 140px; overflow: auto; margin-top: 8px;">
		  			<table id="sizeDtl" border="0" width="30%" style="text-align: center; visibility: hidden;" class="body_table1"></table>
		  		</div> -->
	
		  		 <div id="sizeDtlDiv" style=" border: none !important; height:auto !important; width: 99%;">
		  			<table id="sizeDtl" class="headertableClass" style="border-top-style: none; "></table>
		  		</div> 
	
		 		<div style="margin-top: 8px;">
					<strong>Dimension : </strong> <xsl:value-of select="dim_code_desc"/>
				</div>
				
				
				<input type="hidden" value="{$item_parnt}" name="Detail2.{normalize-space($dbID)}.item_parnt" id="item_parnt" />
				<input type="hidden" value="{$item_parnt_desc}" name="Detail2.{normalize-space($dbID)}.item_parnt_desc" id="item_parnt_desc" />
				
				<input type="hidden" value="{$item_type}" name="Detail2.{normalize-space($dbID)}.item_type" id="item_type" />
				<input type="hidden" value="{$item_type_desc}" name="Detail2.{normalize-space($dbID)}.item_type_desc" id="item_type_desc" />
				
				<input type="hidden" value="{$item_ser}" name="Detail2.{normalize-space($dbID)}.item_ser" id="item_ser" />
				<input type="hidden" value="{$itemser_descr}" name="Detail2.{normalize-space($dbID)}.itemser_descr" id="itemser_descr" />
				
				<input type="hidden" value="{$descr}" name="Detail2.{normalize-space($dbID)}.descr" id="descr" />
				
				<input type="hidden" value="{$grp_code}" name="Detail2.{normalize-space($dbID)}.grp_code" id="grp_code" />
				<input type="hidden" value="{$grp_code_desc}" name="Detail2.{normalize-space($dbID)}.grp_code_desc" id="grp_code_desc" />
				
				<input type="hidden" value="{$site_codes}" name="Detail2.{normalize-space($dbID)}.site_codes" id="site_codes" />
				<input type="hidden" value="{$site_desc}" name="Detail2.{normalize-space($dbID)}.site_desc" id="site_desc" />
				
				<input type="hidden" value="{$dimension_desc}" name="Detail2.{normalize-space($dbID)}.dimension_desc" id="dimension_desc" />
				<input type="hidden" value="{$dim_code_desc}" name="Detail2.{normalize-space($dbID)}.dim_code_desc" id="dim_code_desc" />
				
				<input type="hidden" value="{$color_codes}" name="Detail2.{normalize-space($dbID)}.color_codes" id="color_codes" />
				<input type="hidden" value="{$color_code_descr}" name="Detail2.{normalize-space($dbID)}.color_code_descr" id="color_code_descr" />
				
				<input type="hidden" value="{$size_codes}" name="Detail2.{normalize-space($dbID)}.size_codes" id="size_codes" />
				<input type="hidden" value="{$size_type}" name="Detail2.{normalize-space($dbID)}.size_type" id="size_type" />
				
				<input type="hidden" value="{$loc_code}" name="Detail2.{normalize-space($dbID)}.loc_code" id="loc_code" />
				<input type="hidden" value="{$loc_type}" name="Detail2.{normalize-space($dbID)}.loc_type" id="loc_type" />
				
				<input type="hidden" value="{$stk_opt}" name="Detail2.{normalize-space($dbID)}.stk_opt" id="stk_opt" />
				<input type="hidden" value="{$phy_attr4}" name="Detail2.{normalize-space($dbID)}.phy_attr4" id="phy_attr4" />
				<input type="hidden" value="{$phy_attr5}" name="Detail2.{normalize-space($dbID)}.phy_attr5" id="phy_attr5" />
				<input type="hidden" value="{$price}" name="Detail2.{normalize-space($dbID)}.price" id="price" />
				<input type="hidden" value="{$curr_code}" name="Detail2.{normalize-space($dbID)}.curr_code" id="curr_code" />
				<input type="hidden" value="{$unit}" name="Detail2.{normalize-space($dbID)}.unit" id="unit" />
				<input type="hidden" value="{$track_shelf_life}" name="Detail2.{normalize-space($dbID)}.track_shelf_life" id="track_shelf_life" />
				<input type="hidden" value="{$unit_rate}" name="Detail2.{normalize-space($dbID)}.unit_rate" id="unit_rate" />
				
				<input type="hidden" value="{$supp_code}" name="Detail2.{normalize-space($dbID)}.supp_code" id="supp_code" />
				<input type="hidden" value="{$supplier_desc}" name="Detail2.{normalize-space($dbID)}.supplier_desc" id="supplier_desc" />
				<input type="hidden" value="{$supp_item_desc}" name="Detail2.{normalize-space($dbID)}.supp_item_desc" id="supp_item_desc" />
				
				<input type="hidden" value="{$item_category}" name="Detail2.{normalize-space($dbID)}.item_category" id="item_category" />
				<input type="hidden" value="{$category_descr}" name="Detail2.{normalize-space($dbID)}.category_descr" id="category_descr" />
				
				<input type="hidden" value="{$price_list_dtl}" name="Detail2.{normalize-space($dbID)}.price_list_dtl" id="price_list_dtl" />
				<input type="hidden" value="{$item_length}" name="Detail2.{normalize-space($dbID)}.item_length" id="item_length" />
				<input type="hidden" value="{$item_width}" name="Detail2.{normalize-space($dbID)}.item_width" id="item_width" />
				<input type="hidden" value="{$item_height}" name="Detail2.{normalize-space($dbID)}.item_height" id="item_height" />
				<input type="hidden" value="{$item_gross_wt}" name="Detail2.{normalize-space($dbID)}.item_gross_wt" id="item_gross_wt" />
				
				<input type="hidden" value="{$item_sh_descr}" name="Detail2.{normalize-space($dbID)}.item_sh_descr" id="item_sh_descr" />
				<input type="hidden" value="{$long_desc}" name="Detail2.{normalize-space($dbID)}.long_desc" id="long_desc" />
				<input type="hidden" value="{$meta_desc}" name="Detail2.{normalize-space($dbID)}.meta_desc" id="meta_desc" />
				<input type="hidden" value="{$meta_keywords}" name="Detail2.{normalize-space($dbID)}.meta_keywords" id="meta_keywords" />
				<input type="hidden" value="{$meta_title}" name="Detail2.{normalize-space($dbID)}.meta_title" id="meta_title" />
				<input type="hidden" value="{$img_path}" name="Detail2.{normalize-space($dbID)}.img_path" id="img_path" />
				
				<input type="hidden" value="{$chg_date}" name="Detail2.{normalize-space($dbID)}.chg_date" id="chg_date" ISCHANGED="false" />
				<input type="hidden" value="{$chg_user}" name="Detail2.{normalize-space($dbID)}.chg_user" id="chg_user" ISCHANGED="false" />
				<input type="hidden" value="{$chg_term}" name="Detail2.{normalize-space($dbID)}.chg_term" id="chg_term" ISCHANGED="false" />
				<input type="hidden" value="{$pur_lead_time}" name="Detail2.{normalize-space($dbID)}.pur_lead_time" id="pur_lead_time" />
				<input type="hidden" value="{$location_descr}" name="Detail2.{normalize-space($dbID)}.location_descr" id="location_descr" />
				<!--Added by Parikshit on 20-APR-2015 starts -->	
				<input type="hidden" value="{$shipper_size}" name="Detail2.{normalize-space($dbID)}.shipper_size" id="shipper_size" /> 
				<input type="hidden" value="{$case_length}" name="Detail2.{normalize-space($dbID)}.case_length" id="case_length" />
				<input type="hidden" value="{$case_width}" name="Detail2.{normalize-space($dbID)}.case_width" id="case_width" />
				<input type="hidden" value="{$size_height}" name="Detail2.{normalize-space($dbID)}.size_height" id="size_height" />
				<input type="hidden" value="{$case_gross_weight}" name="Detail2.{normalize-space($dbID)}.case_gross_weight" id="case_gross_weight" />
				<input type="hidden" value="{$case_net_weight}" name="Detail2.{normalize-space($dbID)}.case_net_weight" id="case_net_weight" />
				<input type="hidden" value="{$pack_size_dtl}" name="Detail2.{normalize-space($dbID)}.pack_size_dtl" id="pack_size_dtl" />
				<input type="hidden" value="{$language}" name="Detail2.{normalize-space($dbID)}.language" id="language" />
				<input type="hidden" value="{$language_desc}" name="Detail2.{normalize-space($dbID)}.language_desc" id="language_desc" />
				<input type="hidden" value="{$tax}" name="Detail2.{normalize-space($dbID)}.tax" id="tax" />
				<input type="hidden" value="{$tax_desc}" name="Detail2.{normalize-space($dbID)}.tax_desc" id="tax_desc" />
				<input type="hidden" value="{$size_type_desc}" name="Detail2.{normalize-space($dbID)}.size_type_desc" id="size_type_desc" />
				<input type="hidden" value="{$language_dtl}" name="Detail2.{normalize-space($dbID)}.language_dtl" id="language_dtl" />
				<input type="hidden" value="{$item_commodity}" name="Detail2.{normalize-space($dbID)}.item_commodity" id="item_commodity" />
				<input type="hidden" value="{$date_format}" name="date_format" id="date_format" /><!--Added by parikshit on 08/07/15 to set date format -->
				<!--Added by Parikshit on 20-APR-2015 Ends -->	
				<!--Added by Samadhan on 21/12/2015 for Limited Edition field  start-->
				<input type="hidden" value="{item_usage_type}" name="Detail2.{normalize-space($dbID)}.item_usage_type" id="item_usage_type" />
				<input type="hidden" value="{item_phy_attrib_24}" name="Detail2.{normalize-space($dbID)}.item_phy_attrib_24" id="item_phy_attrib_24" />
				<input type="hidden" value="{brand_descr}" name="Detail2.{normalize-space($dbID)}.brand_descr" id="brand_descr" />
				<!--Added by Samadhan on 21/12/2015 for Limited Edition field  start-->
				<!--Changed by wasim on 15-03-2016 to set site code for prevoius button [START]-->
				<input type="hidden" value="{site_code}" name="Detail2.{normalize-space($dbID)}.site_code" id="site_code" />
				<!--Changed by wasim on 15-03-2016 to set site code for prevoius button [END]-->
				<!--Changed by wasim on 15-03-2016 to set tax_chap for prevoius button [START]-->
				<input type="hidden" value="{$tax_chap}" name="Detail2.{normalize-space($dbID)}.tax_chap" id="tax_chap" />
				<!--Changed by wasim on 15-03-2016 to set tax_chap for prevoius button [END]-->
				
				<!-- Changed by Sneha on 26-09-2016, to add new field trade mark [Start] -->
				<input type="hidden" value="{$trade_mark}" name="Detail2.{normalize-space($dbID)}.trade_mark" id="trade_mark" />
				<!-- Changed by Sneha on 26-09-2016, to add new field trade mark [End] -->
				
				<!-- Changed by Sneha on 24-10-2016, to add new field customer item references [Start] -->
				<input type="hidden" value="{$phy_attrib_4}" name="Detail2.{normalize-space($dbID)}.phy_attrib_4" id="phy_attrib_4" />
				<!-- Changed by Sneha on 24-10-2016, to add new field customer item references [End] -->
				
				 <input type="hidden" name="cust_item_ref_status" id="cust_item_ref_status" ISCHANGED="false" readOnly = "1" onkeypress="return disableEnter()"/> <!-- Changed by Sneha on 28-10-2016, for cust_item_ref_status -->
				 <input type="hidden" name="barcode_flag" id="barcode_flag" ISCHANGED="false" readOnly = "1" onkeypress="return disableEnter()"/>	<!-- Changed by Sneha on 24-11-2016, for barcode flag -->
				</xsl:if>
			</xsl:for-each>
		</div>
<!-- </div> -->
		
		<div  id="detailDiv" style='height: 40%; margin-top: 8px;'>
			<strong>Product Description : </strong> <img src="/ibase/webitm/images/DD/expand1.png" id="showDiv" style="margin-bottom: -5px; cursor: pointer;" onclick='expandDiv()'/>
			<!-- <a href='#'><lable id="showDiv" value='1'>Expand</lable></a> -->
			<div id="detail" style="height: 150px; margin-top: 8px; " >
			<!-- <table class='tableClass' id="SKUItemId" style="width: 1500px;"> -->
			
			<table id="SKUItemId" class="headertableClass" style="border-top-style: none; ">
			<thead>
				<tr>
					<th class = "tHeader"><input type='checkbox' id='Detail2.0.selectbox' onclick='checkAllSKUItem(this)' checked='1'/></th>
					<th class = "tHeader">Sr&#160;No.</th>
					<th class = "tHeader">Item&#160;Description</th>
					<th class = "tHeader">Customer&#160;Item&#160;Refernces</th>	<!-- Added by Sneha on 24-10-2016 -->
					<th class = "tHeader">Size</th>
					<th class = "tHeader">Colour</th>
					<!-- Changed by Sneha on 23-06-2016, for display of Dimension instead of Fitting [Start]  -->
					<!--  <th>Fitting</th> -->
					<th class = "tHeader">Dimension</th> 
					<!-- Changed by Sneha on 23-06-2016, for display of Dimension instead of Fitting [End]  -->
					<th class = "tHeader">Category</th>
					<th class = "tHeader">Trade&#160;Mark</th> <!-- Added by Sneha on 26-09-2016 -->
					<th class = "tHeader">Sales&#160;Tax</th>    <!--Added by Parikshit Kumbhar on 26/05/2015 [Added Tax field in SKU]  -->
					<th class = "tHeader">Purchase&#160;Tax</th> <!-- Added by wasim on 27-07-2016 -->
					<th class = "tHeader">Length</th>
					<th class = "tHeader">Width</th>
					<th class = "tHeader">Height</th>
					<th class = "tHeader">Gross&#160;Wt</th>
					<th class = "tHeader">Barcode*</th>
					<th class = "tHeader">Commodity&#160;No</th>
					<th class = "tHeader">Location</th>
					<th class = "tHeader">Pack&#160;List</th>  <!-- Added by parikshit kumbhar on 20/04/2015 [to show Pack List in SKU]  -->
					<th class = "tHeader">Price&#160;List</th>
					<th class = "tHeader">Supplier&#160;Details</th>
				</tr>
			</thead>
			
			<tbody class='table-body fadeInDown'>
				<xsl:for-each select="//Detail2">
					<xsl:variable name="item_descr"><xsl:value-of select="item_descr"/></xsl:variable>
					
					<!-- Changed by Sneha on 24-10-2016, to add new field customer item references [Start] -->
					<xsl:variable name="phy_attrib_4"><xsl:value-of select="phy_attrib_4"/></xsl:variable>
					<!-- Changed by Sneha on 24-10-2016, to add new field customer item references [End] -->
					
					<xsl:variable name="phy_attrib_1"><xsl:value-of select="phy_attrib_1"/></xsl:variable>
					<xsl:variable name="phy_attrib_2"><xsl:value-of select="phy_attrib_2"/></xsl:variable>
					<xsl:variable name="phy_attrib_3"><xsl:value-of select="phy_attrib_3"/></xsl:variable>
					
					<xsl:variable name="phy_att1"><xsl:value-of select="phy_att1"/></xsl:variable>
					<xsl:variable name="phy_att2"><xsl:value-of select="phy_att2"/></xsl:variable>
					<xsl:variable name="phy_att3"><xsl:value-of select="phy_att3"/></xsl:variable>
					
					<xsl:variable name="item_category"><xsl:value-of select="item_category"/></xsl:variable>
					<xsl:variable name="category_descr"><xsl:value-of select="category_descr"/></xsl:variable>
					<xsl:variable name="item_length"><xsl:value-of select="item_length"/></xsl:variable>
					<xsl:variable name="item_width"><xsl:value-of select="item_width"/></xsl:variable>
					<xsl:variable name="item_height"><xsl:value-of select="item_height"/></xsl:variable>
					<xsl:variable name="item_gross_wt"><xsl:value-of select="item_gross_wt"/></xsl:variable>
					<xsl:variable name="item_barcode"><xsl:value-of select="item_barcode"/></xsl:variable>
					<xsl:variable name="price_list_dtl"><xsl:value-of select="price_list_dtl"/></xsl:variable>
					<xsl:variable name="supp_item_desc"><xsl:value-of select="supp_item_desc"/></xsl:variable>
					<xsl:variable name="loc_code"><xsl:value-of select="loc_code"/></xsl:variable>
					<xsl:variable name="loc_type"><xsl:value-of select="loc_type"/></xsl:variable>
					
					<xsl:variable name="dbIDs"><xsl:value-of select="@domID"/></xsl:variable>
					<xsl:variable name="chkbox"><xsl:value-of select="@selected"/></xsl:variable>
					<!--Added by Parikshit Kumbhar on 20-APR-2015 [to select values of respective tag] Starts -->
					<xsl:variable name="language_dtl"><xsl:value-of select="language_dtl"/></xsl:variable>	
 					<xsl:variable name="pack_size_dtl"><xsl:value-of select="pack_size_dtl"/></xsl:variable>
            		<xsl:variable name="shipper_size"><xsl:value-of select="shipper_size"/></xsl:variable>
			        <xsl:variable name="case_length"><xsl:value-of select="case_length"/></xsl:variable>
					<xsl:variable name="case_width"><xsl:value-of select="case_width"/></xsl:variable>
					<xsl:variable name="size_height"><xsl:value-of select="size_height"/></xsl:variable>
					<xsl:variable name="case_gross_weight"><xsl:value-of select="case_gross_weight"/></xsl:variable>
					<xsl:variable name="case_net_weight"><xsl:value-of select="case_net_weight"/></xsl:variable>
					<xsl:variable name="tax"><xsl:value-of select="tax"/></xsl:variable>
					<xsl:variable name="tax_desc"><xsl:value-of select="tax_desc"/></xsl:variable>
					<xsl:variable name="item_commodity"><xsl:value-of select="item_commodity"/></xsl:variable>
					<!--Added by Parikshit Kumbhar on 20-APR-2015 [to select values of respective tag] Ends -->	
					<!--Changed by wasim on 14-07-2015 to get login site code [START] -->
					<xsl:variable name="site_code"><xsl:value-of select="site_code"/></xsl:variable>
					<!--Changed by wasim on 14-07-2015 to get login site code [START] -->
					
					<!--Changed by wasim on 27-07-2016 for tax chapter [START] -->
					<xsl:variable name="tax_chap"><xsl:value-of select="tax_chap"/></xsl:variable>
					<!--Changed by wasim on 27-07-2016 for tax chapter [END] -->
					
					<!-- Changed by Sneha on 26-09-2016, to add new field trade mark [Start] -->
					<xsl:variable name="trade_mark"><xsl:value-of select="trade_mark"/></xsl:variable>
					<!-- Changed by Sneha on 26-09-2016, to add new field trade mark [End] -->
					
					<xsl:if test="$dbIDs > '0'">
					<tr>
						<td class = "td_leftAlign">
							<xsl:choose>
								<xsl:when test="$chkbox ='Y'">
									<input  type="checkbox" name="Detail2.{normalize-space($dbIDs)}.selectbox" id="Detail2.{normalize-space($dbIDs)}.selectbox" checked='true' value="true" onClick="setChecked(this)"/>
								</xsl:when>	
								<xsl:otherwise>
									<input  type="checkbox" name="Detail2.{normalize-space($dbIDs)}.selectbox" id="Detail2.{normalize-space($dbIDs)}.selectbox" value="false" onClick="setChecked(this)"/>
								</xsl:otherwise>
							</xsl:choose>	
						</td>
						
						<td class = "td_leftAlign" onclick="chkRows('Detail2.{normalize-space($dbIDs)}.selectbox')">
							<xsl:value-of select="@domID"/>
						</td>
						
						<td class = "td_leftAlign" onclick="chkProdDescRows('Detail2.{normalize-space($dbIDs)}.selectbox')">
							<input type="hidden" class="input_editable" value="{$item_descr}" name="Detail2.{normalize-space($dbIDs)}.item_descr" 
								id="Detail2.{normalize-space($dbIDs)}.item_descr" maxlength="10" />
								<xsl:value-of select="item_descr"/>
						</td>
						
						<!-- Changed by Sneha on 24-10-2016, to add new field customer item references [Start] -->
						<td class = "td_leftAlign" >
							<input type="text" class="input_editable" size="35" value="{$phy_attrib_4}" name="Detail2.{normalize-space($dbIDs)}.phy_attrib_4" 
								id="Detail2.{normalize-space($dbIDs)}.phy_attrib_4" maxlength="30"  
								onkeypress="return disableEnter()"/>
						</td>
						<!-- Changed by Sneha on 24-10-2016, to add new field customer item references [End] -->
						
						<td  class = "td_leftAlign" onclick="chkProdDescRows('Detail2.{normalize-space($dbIDs)}.selectbox')">
							<input type="hidden" class="input_editable" value="{$phy_attrib_1}" name="Detail2.{normalize-space($dbIDs)}.phy_attrib_1" 
								id="Detail2.{normalize-space($dbIDs)}.phy_attrib_1" maxlength="10"/>
								<!--Added by Parikshit Kumbhar on 19/05/2015 [to set hidden field]  -->
							
							<input type="hidden" class="input_editable" value="{$phy_att1}" name="Detail2.{normalize-space($dbIDs)}.phy_att1" 
								id="Detail2.{normalize-space($dbIDs)}.phy_att1" maxlength="10"/>
								<xsl:value-of select="phy_att1"/>
						</td>
						
						<td class = "td_leftAlign" onclick="chkProdDescRows('Detail2.{normalize-space($dbIDs)}.selectbox')">
							<input type="hidden" class="input_editable" value="{$phy_attrib_2}" name="Detail2.{normalize-space($dbIDs)}.phy_attrib_2" 
								id="Detail2.{normalize-space($dbIDs)}.phy_attrib_2" maxlength="10"/>
							
							<input type="hidden" class="input_editable" value="{$phy_att2}" name="Detail2.{normalize-space($dbIDs)}.phy_att2" 
								id="Detail2.{normalize-space($dbIDs)}.phy_att2" maxlength="10"/>
								<xsl:value-of select="phy_att2"/>
						</td>
						
						<td class = "td_leftAlign" onclick="chkProdDescRows('Detail2.{normalize-space($dbIDs)}.selectbox')">
							<input type="hidden" class="input_editable" value="{$phy_attrib_3}" name="Detail2.{normalize-space($dbIDs)}.phy_attrib_3" 
								id="Detail2.{normalize-space($dbIDs)}.phy_attrib_3" maxlength="10"/>
							
							<input type="hidden" class="input_editable" value="{$phy_att3}" name="Detail2.{normalize-space($dbIDs)}.phy_att3" 
								id="Detail2.{normalize-space($dbIDs)}.phy_att3" maxlength="10"/>
								<xsl:value-of select="phy_att3"/>
						</td>
						
						<td class = "td_leftAlign">
							<input type="hidden" value="{$item_category}" name="Detail2.{normalize-space($dbIDs)}.item_category" 
								id="Detail2.{normalize-space($dbIDs)}.item_category" maxlength="10"/>
								
							<input type="hidden" value="{$category_descr}" name="Detail2.{normalize-space($dbIDs)}.category_descr" 
								id="Detail2.{normalize-space($dbIDs)}.category_descr" maxlength="10"/>
							
							<div style="float:left;" id="item_category.{normalize-space($dbIDs)}" contenteditable="true" onkeypress="return false;"
							 	onkeydown="javascript:openSearchPopup(event, '{normalize-space($dbIDs)}','0','item_categoryII', 'Category', '{normalize-space($dbIDs)}');">
								<xsl:value-of select="item_category"/>
							</div>
							
							<div class = "imgClass2" >
								<a href="javascript:callListJSP('{normalize-space($dbIDs)}','0','item_categoryII', 'Category', '{normalize-space($dbIDs)}');" >
									<img src="/ibase/webitm/images/pophelp.png"  title="Select Product Category" />
								</a>
							</div>
						</td>
						
						<!-- Changed by Sneha on 26-09-2016, to add new field trade mark [Start] -->
						<td class = "td_leftAlign">								
							<input type="hidden" value="{$trade_mark}" name="Detail2.{normalize-space($dbIDs)}.trade_mark" 
								id="Detail2.{normalize-space($dbIDs)}.trade_mark" maxlength="25"/>
								
							<div style="float:left;" id="trade_mark.{normalize-space($dbIDs)}"  onkeypress="return false;"
							 	onkeydown="javascript:openSearchPopup(event, '{normalize-space($dbIDs)}','0','trade_mark', 'Trade Mark', '{normalize-space($dbIDs)}');">
								<xsl:value-of select="trade_mark"/>
							</div>
							
							<div class = "imgClass2">
								<a href="javascript:callListJSP('{normalize-space($dbIDs)}','0','trade_mark', 'Trade Mark', '{normalize-space($dbIDs)}');" >
									<img src="/ibase/webitm/images/pophelp.png"  title="Select Trade Mark" />
								</a>
							</div>
						</td>
						<!-- Changed by Sneha on 26-09-2016, to add new field trade mark [End] -->

						<!--Added by Parikshit Kumbhar on 26/05/2015 [Added Tax field in SKU] Start -->
						<td class = "td_leftAlign">
							<input type="hidden" value="{$tax}" name="Detail2.{normalize-space($dbIDs)}.tax" 
								id="Detail2.{normalize-space($dbIDs)}.tax" maxlength="10"/>
								
							<input type="hidden" value="{$tax_desc}" name="Detail2.{normalize-space($dbIDs)}.tax_desc" 
								id="Detail2.{normalize-space($dbIDs)}.tax_desc" maxlength="10"/>	
								
							<div style="float:left;" id="tax.{normalize-space($dbIDs)}" contenteditable="true" onkeypress="return false;"
							 	onkeydown="javascript:openSearchPopup(event, '{normalize-space($dbIDs)}','0','tax_desc', 'Sales Tax', '{normalize-space($dbIDs)}');">
								<xsl:value-of select="tax_desc"/>
							</div>
							
							<div class = "imgClass2">
								<a href="javascript:callListJSP('{normalize-space($dbIDs)}','0','tax_desc', 'Sales Tax', '{normalize-space($dbIDs)}');" >
									<img src="/ibase/webitm/images/pophelp.png" title="Select Sales Tax" />
								</a>
							</div>
						</td>
						
						<!--Changed by wasim on 27-07-2016 for tax chapter [START] -->
						<td class = "td_leftAlign">
							<input type="hidden" value="{$tax_chap}" name="Detail2.{normalize-space($dbIDs)}.tax_chap" 
								id="Detail2.{normalize-space($dbIDs)}.tax_chap" maxlength="10"/>	
								
							<div style="float:left;" id="tax_chap.{normalize-space($dbIDs)}" contenteditable="true" onkeypress="return false;"
							 	onkeydown="javascript:openSearchPopup(event, '{normalize-space($dbIDs)}','0','tax_chapII', 'Purchase Tax', '{normalize-space($dbIDs)}');">
								<xsl:value-of select="tax_chap"/>
							</div>
							
							<div class = "imgClass2">
								<a href="javascript:callListJSP('{normalize-space($dbIDs)}','0','tax_chapII', 'Purchase Tax', '{normalize-space($dbIDs)}');" >
									<img src="/ibase/webitm/images/pophelp.png"  title="Select Purchase Tax" />
								</a>
							</div>
						</td>
						<!--Changed by wasim on 27-07-2016 for tax chapter [END] -->
						
						<!--Added by Parikshit Kumbhar on 26/05/2015 [Added Tax field in SKU]  End-->
						<td class = "td_leftAlign">
							<input type="text" class="input_editable" size="8" value="{$item_length}" name="Detail2.{normalize-space($dbIDs)}.item_length" 
								id="Detail2.{normalize-space($dbIDs)}.item_length" maxlength="10" style='text-align: right;' onchange='return isNumeric(this)'
								onkeypress="return disableEnter()"/>
						</td>
						
						<td class = "td_leftAlign">
							<input type="text" class="input_editable" size="8" value="{$item_width}" name="Detail2.{normalize-space($dbIDs)}.item_width" 
								id="Detail2.{normalize-space($dbIDs)}.item_width" maxlength="10" style='text-align: right;' onchange='return isNumeric(this)'
								onkeypress="return disableEnter()"/>
						</td>
						
						<td class = "td_leftAlign">
							<input type="text" class="input_editable" size="8" value="{$item_height}" name="Detail2.{normalize-space($dbIDs)}.item_height" 
								id="Detail2.{normalize-space($dbIDs)}.item_height" maxlength="10" style='text-align: right;' onchange='return isNumeric(this)'
								onkeypress="return disableEnter()"/>
						</td>
						
						<td class = "td_leftAlign">
							<input type="text" class="input_editable" size="8" value="{$item_gross_wt}" name="Detail2.{normalize-space($dbIDs)}.item_gross_wt" 
								id="Detail2.{normalize-space($dbIDs)}.item_gross_wt" maxlength="10" style='text-align: right;' onchange='return isNumeric(this)'
								onkeypress="return disableEnter()"/>
						</td>
						
						<td class = "td_leftAlign">
							<input type="text" class="input_editable" size="13" value="{$item_barcode}" name="Detail2.{normalize-space($dbIDs)}.item_barcode" 
								id="Detail2.{normalize-space($dbIDs)}.item_barcode" maxlength="20" onkeypress="return disableEnter()" 
								onkeyup = "return specialCharValidate(this.id);" />
						</td>
						
						<td class = "td_leftAlign">
							<input type="text" class="input_editable" size="13" value="{$item_commodity}" name="Detail2.{normalize-space($dbIDs)}.item_commodity" 
								id="Detail2.{normalize-space($dbIDs)}.item_commodity" maxlength="20" onkeypress="return disableEnter()"
								onkeyup = "return specialCharValidate(this.id);" />
						</td>
						
						<td class = "td_leftAlign">
							<input type="hidden" value="{$loc_code}" name="Detail2.{normalize-space($dbIDs)}.loc_code" 
								id="Detail2.{normalize-space($dbIDs)}.loc_code" maxlength="10"/>
								
							<input type="hidden" value="{$loc_type}" name="Detail2.{normalize-space($dbIDs)}.loc_type" 
								id="Detail2.{normalize-space($dbIDs)}.loc_type" maxlength="10"/>	
								
							<div style="float:left;" id="loc_code.{normalize-space($dbIDs)}" contenteditable="true" onkeypress="return false;"
							 	onkeydown="javascript:openSearchPopup(event, '{normalize-space($dbIDs)}','0','loc_codeII', 'Location Code', '{normalize-space($dbIDs)}');">
								<xsl:value-of select="loc_code"/>
							</div>
							
							<!--Changed by wasim on 14-07-2015 to get login site code [START] -->
							<!--<a href="javascript:callListJSP('{normalize-space($dbIDs)}','0','loc_codeII', 'Location Code', '{normalize-space($dbIDs)}');" style="float: left;text-decoration: none;">
								<img src="/ibase/webitm/images/pophelp.png" style="margin-left: -5px;" title="Select Location Code" />
							</a>-->
							<div class = "imgClass2">
								<a href="javascript:callListJSP('{normalize-space($dbIDs)}','{normalize-space($site_code)}','loc_codeII', 'Location Code', '{normalize-space($dbIDs)}');" >
									<img src="/ibase/webitm/images/pophelp.png"  title="Select Location Code" />
								</a>
							<!--Changed by wasim on 14-07-2015 to get login site code [END] -->
							</div>
						</td>
						
						<!-- Added by Parikshit Kumbhar on 20-Apr-2015[apended value passing through openPopup function] Starts-->
						<td class = "td_leftAlign">
							<input type="hidden" class="input_editable" value="{$pack_size_dtl}" name="Detail2.{normalize-space($dbIDs)}.pack_size_dtl" 
								id="Detail2.{normalize-space($dbIDs)}.pack_size_dtl" />
							
							<a href="#" id="Detail2.{normalize-space($dbIDs)}.packListLink" onclick="openPopup(event, this.id, 'pack');" style="color: black">Click&#160;for&#160;Pack&#160;Details</a>
						
						     <input type="hidden" class="input_editable" value="{$language_dtl}" name="Detail2.{normalize-space($dbIDs)}.language_dtl" 
								id="Detail2.{normalize-space($dbIDs)}.language_dtl" />
						</td>
						<!-- Added by Parikshit Kumbhar on 20-Apr-2015 [apended value passing through openPopup function] End-->
						
						<td class = "td_leftAlign">
							<input type="hidden" class="input_editable" value="{$price_list_dtl}" name="Detail2.{normalize-space($dbIDs)}.price_list_dtl" 
								id="Detail2.{normalize-space($dbIDs)}.price_list_dtl" />
							
							<a href="#" id="Detail2.{normalize-space($dbIDs)}.prodPriceLink" onclick="openPopup(event, this.id, 'price');"  style="color: black">Click&#160;for&#160;PriceList</a>
						</td>
						
						<td class = "td_leftAlign">
							<input type="hidden" class="input_editable" value="{$supp_item_desc}" name="Detail2.{normalize-space($dbIDs)}.supp_item_desc" 
								id="Detail2.{normalize-space($dbIDs)}.supp_item_desc" />
							
							<a href="#" id="Detail2.{normalize-space($dbIDs)}.suppListLink" onclick="openPopup(event, this.id, 'supp');"  style="color: black">Click&#160;for&#160;Supplier&#160;Details</a>
						</td>
					</tr>
				</xsl:if>
			</xsl:for-each>
		</tbody>
		</table>
	</div>

	<!-- Added by Parikshit on 20-Apr-2015[for display contents inside the SKU ] starts-->
	<div id="packListDiv" class = "hidden body_table_div"> 
			<table id="SKUPackListId" class="headertableClass">
				<caption id="SKUPackListCaption" style = "margin-bottom:5px;">Pack Size Details</caption>
				<tbody>
				<tr>
					<!--Changed by Parikshit Kumbhar on 22/06/2015 [D15CKAT031] [Maxlength added] start-->
				    <td class="td_leftAlign">Shipper/pack size:</td>
				    <td><input type="text" onchange="return isNumeric(this)" class="input_editable" style="text-align: right;" id="s_size" value ="" maxlength="11"  /></td>	
				   
				    <td class="td_rightAlign">Case Length :</td>
				    <td><input type="text" onchange="return isNumeric(this)" class="input_editable" style="text-align: right;" id="c_length" value ="" maxlength="11" /></td>	
				    </tr>
				    
				    <tr>
				    <td class="td_leftAlign">Case Width:</td>
				    <td><input type="text" onchange="return isNumeric(this)" class="input_editable" style="text-align: right;" id="c_width" value ="" maxlength="11" /></td>	
				    
				    <td class="td_rightAlign">Case Height :</td>
				    <td><input type="text" onchange="return isNumeric(this)" class="input_editable" style="text-align: right;" id="c_height" value ="" maxlength="11" /></td>
				    </tr>
				    
				    <tr>
				    <td class="td_leftAlign">Case Gross Weight:</td>
				    <td><input type="text" onchange="return isNumeric(this)" class="input_editable" style="text-align: right;"  id="c_g_weight" value ="" maxlength="11" /></td>	
				   
				    <td class="td_rightAlign">Case Net Weight:</td>
				    <td><input type="text" onchange="return isNumeric(this)" class="input_editable" style="text-align: right;" id="c_n_weight" value ="" maxlength="11" /></td>
				   	<!--Changed by Parikshit Kumbhar on 22/06/2015 [D15CKAT031] [Maxlength added] end-->
				</tr>	
   			 </tbody>
		</table>
	<br/><input type="hidden" id="idNumPack"/>
	
	<div align = "right">
		<input type="button" style="cursor:hand" class="button" value="Ok" title='Ok' onclick="javascript:setPackDtls()"/>
		<input type="submit" style="cursor:hand" class="button" value="Cancel" title='Cancel' onclick="javascript:closePopup()"/>
	</div>
	<br/>
</div>
<!-- Added by Parikshit on 20-Apr-2015[for display contents inside the SKU ] end-->
	
<!-- <div style="overflow: auto; height: 260px;"> 
		 <table class='tableClass' id="SKUPriceListId" style="text-align: center; width: 550px; margin: 0 auto;"> -->
	<div id="priceListDiv" class = "hidden body_table_div" style = "width: 600px;">
		<table id="SKUPriceListId" class="headertableClass" >
			<caption id="SKUPriceListCaption" style = "margin-bottom:5px;">table</caption>
			<thead>
			<tr class='thClass'>
				<th width='5%'><input type="checkbox" id="chkAllPrices" name="chkAllPrices" onclick="checkAll(this)" /></th>
				<th class = "tHeader" width='5%'>Sites</th>
				<th class = "tHeader" width='5%'>PriceList</th>
				<th class = "tHeader" width='5%'>Currency</th>
				<th class = "tHeader" width='5%'>Rate</th>
				<!-- <th width='50px;'>Cost</th> -->
				<th class = "tHeader" width='15%'>Date&#160;From</th>
				<th class = "tHeader" width='15%'>Date&#160;To</th>
			</tr>
			</thead>
				<tbody class='table-body'></tbody>
		</table>
<!-- 		</div> -->
		
		<br/><input type="hidden" id="idNumP"/>
		<div align = "right">
			<input type="button" style="cursor:hand" class="button" value="Ok" title='' onclick="javascript:setPrice()"/>
			<input type="submit" style="cursor:hand" class="button" value="Cancel" title='' onclick="javascript:closePopup()"/>
		</div><br/>
	</div>
	
	<!-- <div style="overflow: auto; height: 260px;">
		<table class='tableClass' id="SKUSuppListId" style="text-align: center; width: 550px; margin: 0 auto;"> -->
	<div id="suppListDiv" class = "hidden body_table_div">
		<table id="SKUSuppListId" class="headertableClass" style = "width:600px;">
			<caption id="SKUSuppListCaption" style = "margin-bottom:5px;">table</caption>
			<thead>
				<tr class='thClass'>
					<th class = "tHeader" width='5%'><input type="checkbox" id="chkAllSupplier" name="chkAllSupplier" onclick="checkAll(this)" /></th>
					<th class = "tHeader" width='5%'>Supplier</th>
					<th class = "tHeader" width='5%'>PriceList</th>
					<th class = "tHeader" width='5%'>Currency</th>
					<th class = "tHeader" width='5%'>Cost</th>
					<th class = "tHeader" width='15%'>Date&#160;From</th>
					<th class = "tHeader" width='15%'>Date&#160;To</th>
				</tr>
			</thead>
			<tbody class='table-body'></tbody>
		</table>
<!-- 		</div> -->
		
		<br/><input type="hidden" id="idNumS"/>
		
		<div align = "right" style="margin-top:10px;">
			<input type="button" style="cursor:hand" class="button" value="Ok" title='Ok' onclick="javascript:setSuppDtls()"/>
			<input type="submit" style="cursor:hand" class="button" value="Cancel" title='Cancel' onclick="javascript:closePopup()"/>
		</div><br/>
	</div>
</div>
	
</div>

	<input type="hidden" id="idNumPack"/>
	
	
	
	
	<div id="buttonreplacement" align="center" style="display:none;">
		<img src="/ibase/images/preload.gif" alt="Please wait work in progress" >
			 Please wait......
		</img>	
	</div>
	
	<div align = "right">
		<input type="submit" style="cursor:hand; float:left;" class="button" value="Cancel" title='Cancel' id="previous" onclick="javascript:setActionVal('previous');"/>
		<input type="submit" style="cursor:hand; float:left;" class="button" value="Previous" title='Previous' id="prev" onclick="javascript:createXMLString()"/>
		<input type="submit" style="cursor:hand;" class="button" value="Finish" title='Finish' id="finish" onclick="javascript:return checkValidation();"/>
	</div>

	<table width="100%">
		<tr>
		  <td colspan="2">
			<input type="hidden" value="2" name="FORM_NO" ID="FORM_NO" />
			<input type="hidden"  value="dd_productWiz" name="OBJ_NAME" />
			<input type="hidden"  value="" name="action" id="action" />
			<input type="hidden" value="1:MP" name="formType" id="formType" />
			<input type="hidden" value="" name="PRE_FORM_VAL" ID="PRE_FORM_VAL" />
		</td>  
        </tr>
	</table>
<!-- 	</div> -->

			
</form>
</body>

</html>
</xsl:template>
</xsl:stylesheet>
