/*
 * Author:Wasim Ansari
 * Date:02-FEB-15
 * Request ID:D14IKAT004 (PO Wizard)
 */

package ibase.webitm.bean.wms;

import java.io.File;

import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.wms.DDPordWizAmdEJBRemote;
import ibase.webitm.utility.ITMException;

import javax.naming.InitialContext;
import javax.servlet.http.HttpSession;
import ibase.utility.E12GenericUtility;

public class PordAmdBean 
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	private ibase.utility.UserInfoBean userInfo = null;
	private HttpSession sessionCtx = null;
	private String objName = "";
	private String user_lang ="en"; 
	private String user_country = "US";
	
	private String getXSLFileName( String xslFileName )throws ITMException
	{   
		String retFileName = null;
		try
		{
			String defaultPath = null;
			if( CommonConstants.APPLICATION_CONTEXT != null )
			{
				defaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT + File.separator;
			}
			else
			{
				defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + CommonConstants.ITM_CONTEXT + File.separator;
			}
			File xslPath = new File( defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME + File.separator + "WIZARD");
			if ( !xslPath.exists() )
			{
				xslPath.mkdir();
			}
			System.out.println( " xslPath [" + xslPath +"] xslFileName ["+xslFileName +"]");
			File xslFile = new File(xslPath , xslFileName);
			if( xslFile.exists() )
			{
				retFileName = xslFile.getAbsolutePath();
			}
			else
			{
				throw new ITMException( new Exception( retFileName + " Wizard XSL file Not Found") );	
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return retFileName;
	}
	
	public String getForm( String formName, String xmlData ) throws ITMException 
	{
		String retHtmlData = null;
		
		try
		{
			System.out.println("*******In Method : [getForm in bean]************");
			
			System.out.println("xmlString : ["+ xmlData +"]");
			
			String xslFileName = getXSLFileName( "pord_wiz_amd1_wiz_" + this.user_lang + "_" + this.user_country + "_" + "A" + ".xsl" );
			
			retHtmlData = (genericUtility).transformToString( xslFileName, xmlData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
		}
		return retHtmlData;
	}
	public String getList(String field,String extra) throws ITMException
	{
		String itemTypeList = "";
		
		DDPordWizAmdEJBRemote ddPordWizAmdRemote = null;
		
		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			ddPordWizAmdRemote = (ibase.webitm.ejb.wms.DDPordWizAmdEJBRemote) ctx.lookup("ibase/DDPordWizAmdEJB/remote");
			itemTypeList = ddPordWizAmdRemote.getData(field,extra);

			String xslFileName = getXSLFileName( "pordAmd_ItemDetails_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			
			itemTypeList = (genericUtility).transformToString( xslFileName, itemTypeList, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );

		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			if ( ddPordWizAmdRemote != null )
			{
				ddPordWizAmdRemote = null;
			}
		}
		return itemTypeList;
	}
	
}
