

---------------------------Function fn_nearexp------------------------------------------------------------------------

create or replace function fn_nearexp (as_item_code in char, as_site_code in char ,as_loc_code in char,as_lot_no in char,as_lot_sl in char)
return char is 

ls_track_shelf_life char(1);
lc_min_shelf_life number(7,3);
nearexp_date date ;
exp_date date ;
begin

    	        begin	
		
			select min_shelf_life ,track_shelf_life into lc_min_shelf_life ,ls_track_shelf_life
			from item where item_code = as_item_code;
		
			exception when others then
			return  'N' ;
		end;
	
	if trim(ls_track_shelf_life) = 'S'  then
		 
		begin
			select (ADD_MONTHS( to_date(sysdate), lc_min_shelf_life ) )  + 1  into nearexp_date from dual;
		
			exception when others then
			return  'N' ;
		end;
		
		begin
		
			select  exp_date into exp_date from stock 
			where item_code = as_item_code and site_code = as_site_code and loc_code =  as_loc_code and lot_no =  as_lot_no  and  lot_sl = as_lot_sl  ;
			
		        exception when others then
                        return  'N' ;
                end;
		 
			if exp_date <= nearexp_date  then
				return 'Y' ;
			else
				return 'N' ;
			end if;
			
	else
		return 'N' ;		
        end if;
		
end; 


---------------------------Function fn_get_sampleqty ------------------------------------------------------------------------

create or replace function fn_get_sampleqty (as_item_code in char, as_site_code in char)
return char is 

lc_qty_sample number(14,3);

begin

	begin
    
		select qty_sample into lc_qty_sample 
		from siteitem 
		where item_code = as_item_code and site_code = as_site_code ; 
        
		exception when others then
		lc_qty_sample := 0 ;
	end;
  
  return lc_qty_sample;

end;




---------------------------Function fn_get_avgpotency ------------------------------------------------------------------------

create or replace function fn_get_avgpotency (as_item_code in char, as_site_code in char ,quantity in number)
return char is 
lc_item_potency number(14,3);
avg_potency number(14,3);
lc_potency number(14,3) := 0 ;
lc_potency_perc number(14,3);
cnt number;
begin
begin
select potency_perc into lc_potency_perc
from item 
where item_code = as_item_code ;

exception when others then

lc_potency := quantity;

end;
if lc_potency_perc > 0 then
begin

select COUNT(*) into cnt
from qc_order 
WHERE site_code = as_site_code 
and item_code = as_item_code 
and status = 'C' 
and item_potency > 0 and ROWNUM <= 3 order by status_date desc ;

exception when others then
lc_potency := quantity;
end;
begin

select sum(item_potency) into lc_item_potency
from qc_order 
WHERE site_code = as_site_code 
and item_code = as_item_code 
and status = 'C' 
and item_potency > 0 and ROWNUM <= 3 order by status_date desc ;
exception when others then

lc_potency := quantity;

end;
avg_potency := (lc_item_potency / cnt) ;
lc_potency := quantity / avg_potency * 100 ;

end if;

return lc_potency;
end;