------Related Party applicability definition
CREATE TABLE RELA_PARTY_APPL
(
FIN_ENTITY 		CHAR(10) NOT NULL, 
ACCT_PRD 		CHAR(6)  NOT NULL,
TRAN_CAT                VARCHAR2(5) NOT NULL,
PROJ_TURNOVER		NUMBER(14,3),
RELP_ALLW_PERC 		NUMBER(14,3),
ADD_DATE  		DATE,
ADD_USER  		VARCHAR2(10),
ADD_TERM  		VARCHAR2(15),
CHG_DATE  		DATE,
CHG_USER  		VARCHAR2(10),
CHG_TERM  		VARCHAR2(15)
);
ALTER TABLE RELA_PARTY_APPL ADD CONSTRAINT RELA_PARTY_APPL_X PRIMARY KEY(FIN_ENTITY,ACCT_PRD,TRAN_CAT);

--------------------transetup------------------------------------------------------------------------------------------------
INSERT INTO TRANSETUP (TRAN_WINDOW,SAVE_FLAG,VAL_FLAG,KEY_FLAG,CHG_DATE,CHG_USER,CHG_TERM,EDI_OPTION,MAIL_OPTION,CONFIRM_MODE,GARBAGE_OPT,TABLE_NAME,VIEW_MODE,AUDIT_TRAIL_OPT,PERIOD_OPTION)
VALUES ('w_rela_party_appl','2','2','M',TO_DATE('20-04-2016','DD-MM-RR'),'BASE','BASE','0','0','0','N','RELA_PARTY_APPL','F','2','M');

--------------------OBJ_FORMS------------------------------------------------------------------------------------------------
INSERT INTO OBJ_FORMS (WIN_NAME,TITLE,FORM_NO)VALUES('w_rela_party_appl','Approval','1');

--------------------OBJ_ACTIONS------------------------------------------------------------------------------------------------
INSERT INTO OBJ_ACTIONS (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,ACTION_TYPE) VALUES('rela_party_appl',1,'add.gif','Adding New','a','a','A','Add','1','S');
INSERT INTO OBJ_ACTIONS (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,ACTION_TYPE) VALUES('rela_party_appl',2,'edit.gif','Editing Existing Record','a','a','E','EDIT','1','S');
INSERT INTO OBJ_ACTIONS (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,ACTION_TYPE) VALUES('rela_party_appl',3,'save.gif','Saving','a','a','S','SAVE','1','S');

--------------------OBJ_ITEMCHANGE-----------------------------------------------------------------------------------------------
INSERT INTO OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME) VALUES ('rela_party_appl','1','itm_default');
INSERT INTO OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME) VALUES ('rela_party_appl','1','fin_entity');
INSERT INTO OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME) VALUES ('rela_party_appl','1','itm_defaultedit');

-------------------ITM2MENU------------------------------------------------------------------------------------------------
INSERT INTO ITM2MENU(APPLICATION,LEVEL_1,LEVEL_2,LEVEL_3,LEVEL_4,LEVEL_5,WIN_NAME,DESCR,COMMENTS,MENU_PATH,ICON_PATH,OBJ_TYPE,CHG_DATE,CHG_TERM,CHG_USER) VALUES 
('FIN',2,52,0,0,0,'w_rela_party_appl','Related Party Applicability','Related Party Applicability','FIN.2.52.0.0.0','e12_logo.gif','T',TO_DATE('21-04-16','DD-MM-RR'),'BASE','BASE');

--------------------SYSTEM_EVENTS------------------------------------------------------------------------------------------------
INSERT INTO SYSTEM_EVENTS (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME) values ('rela_party_appl','post_item_change','1','poic_default_ejb','0',to_date('21-04-16','DD-MM-RR'),'BASE','BASE','2','EJB','RelaPartyApplIC');
INSERT INTO SYSTEM_EVENTS (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME) VALUES ('rela_party_appl','pre_validate','1','prv_default_ejb','0',TO_DATE('21-04-16','DD-MM-RR'),'BASE','BASE','2','EJB','RelaPartyApplIC');

--------------------POPHELP------------------------------------------------------------------------------------------------
INSERT INTO POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,CHG_DATE,CHG_USER,CHG_TERM,DIST_OPT,DEFAULT_COL,POP_ALIGN) 
VALUES ('FIN_ENTITY','W_RELA_PARTY_APPL','SELECT FIN_ENTITY,DESCR FROM FINENT','Financial Entity',TO_DATE('21-04-16','DD-MM-RR'),'BASE','BASE','0',0,'C');

INSERT INTO POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,CHG_DATE,CHG_USER,CHG_TERM,DIST_OPT,DEFAULT_COL)
VALUES ('ACCT_PRD','W_RELA_PARTY_APPL','SELECT CODE, DESCR FROM ACCTPRD','Account Period',TO_DATE('21-04-16','DD-MM-RR'),'BASE','BASE','0',1);


--------------------MESSAGES-----------------------------------------------------------------------------------------------
INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM) 
VALUES ('NULLFINENT','Financial Entity is blank','Please enter Financial Entity ','E','Y',TO_DATE('21-04-16','DD-MM-RR'),'BASE','BASE');

INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM) 
VALUES ('NULLACCPRD',' Accounting Period is blank','Please select Accounting Period','E','Y',TO_DATE('21-04-16','DD-MM-RR'),'BASE','BASE');

INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM) 
VALUES ('INVDFINENT','Fin Entity does not exists','Financial Entity does not exists in Fin entity master','E','Y',TO_DATE('21-04-16','DD-MM-RR'),'BASE','BASE');

INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM) 
VALUES ('INVDACCPR','Accounting period not exists','Accounting period does not exists in Master','E','Y',TO_DATE('21-04-16','DD-MM-RR'),'BASE','BASE');

INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM) 
VALUES ('VTDUFINENT','Duplicate Record exist!','Please select another Financial entity, Accounting period or Transaction Category','E','Y',TO_DATE('21-04-16','DD-MM-RR'),'BASE','BASE');

INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM) 
VALUES ('VMPROJTURN','Project Turnover less than 0 ','Project Turnover should be greater than 0','E','Y',TO_DATE('21-04-16','DD-MM-RR'),'BASE','BASE');

INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM) 
VALUES ('VMRELPALLW','Invalid Related party allow ','Related party allow limit should be 0 to 100 ','E','Y',TO_DATE('21-04-16','DD-MM-RR'),'BASE','BASE');

---UPDATED BY POONAM ON 04-05-2016-----------

INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM) 
VALUES ('INVTRANCAT','Invalid Transaction Category','Transaction Category does not exists or not Active in Transaction Category master','E','Y',TO_DATE('04-05-16','DD-MM-RR'),'BASE','BASE');

INSERT INTO POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,CHG_DATE,CHG_USER,CHG_TERM,DIST_OPT,DEFAULT_COL)
values ('TRAN_CAT','W_RELA_PARTY_APPL','SELECT TRAN_CAT,DESCR FROM TRANSACTION_CAT','TRANSACTION CAT',TO_DATE('21-04-16','DD-MM-RR'),'BASE','BASE','0',1);

INSERT INTO OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME) VALUES ('rela_party_appl','1','tran_cat');
