package ibase.dashboard.wms.ejb;

import ibase.dashboard.Report.Utility.DashboardUtility;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.ejb.Stateless;
import org.json.simple.JSONObject;


@Stateless
public class StockRequirement extends ValidatorEJB implements StockRequirementLocal,StockRequirementRemote
{
	public StockRequirement()
	{
	}

	@SuppressWarnings("unchecked")
	public JSONObject getStockDetail(String loginCode,String dataSourceName,String itemseries)throws RemoteException, ITMException
	{
		JSONObject rowDataStockRequirementJson = new JSONObject();
		JSONObject rowData                = null;
		String sql                        = "";		
		ResultSet rs                      = null;
		PreparedStatement pstmt           = null;
		Connection conn                   = null;
		ConnDriver connDriver             = new ConnDriver();
		int count                         = 0;
		String appendSql = "";
		DashboardUtility dashboardUtility = new DashboardUtility();
		
		try
		{
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null; 
			
			if(itemseries==null || itemseries.length()<1)
			{
				appendSql = "";
			}
			else
			{
				appendSql = "A.Item_Ser IN("+dashboardUtility.getCommaSeparated(itemseries)+") and ";
			}
			
			sql = "select A.item_parnt Style,A.item_code SKUCODE,A.Description," +
				  "A.Item_Ser ItemSeries, B.Stock_In_Hand,B.Allocated," +
				  "C.Commited_Qty,D.Pending_PO,0 as Intransit," +
				  "B.Stock_In_Hand - C.Commited_Qty + D.Pending_PO as " +
				  "Balance_In_Hand from " +
				  "(select item_parnt,item_code,phy_attrib_2 || ' ' || " +
				  "phy_attrib_1 || ' ' || Descr as Description,Item_Ser " +
				  "from item)A,(select item_code,Sum(Quantity) Stock_In_Hand," +
				  "Sum(Alloc_Qty) Allocated from stock group by item_code) B," +
				  "(select item_code__ord, Sum(QTY_ORD- QTY_DESP) Commited_Qty " +
				  "from sorditem where (QTY_ORD- QTY_DESP)>0 group by " +
				  "item_code__ord)C,(select Item_CODE, " +
				  "Sum(quantity-dlv_qty) as Pending_PO from porddet " +
				  "where (quantity-dlv_qty)>0 group by Item_CODE) D " +
				  "where A.item_code=B.item_code(+) and " + appendSql +
				  "A.item_code=C.item_code__ord(+) and " +
				  "A.item_code=D.Item_CODE(+) " +
				  "and A.item_parnt is not null " +
				 // "and rownum<50"+
				  "order by A.item_parnt" ;						
	
			pstmt = conn.prepareStatement(sql);
			rs    = pstmt.executeQuery();	
			count = 0;				
			
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("style", checkNull(rs.getString("Style")).trim());
				rowData.put("code", checkNull(rs.getString("SKUCODE")).trim());
				rowData.put("descr", checkNull(rs.getString("Description")).trim());
				rowData.put("itemseries", checkNull(rs.getString("ItemSeries")).trim());
				rowData.put("stock_qty", checkNull(rs.getString("Stock_In_Hand")).trim());
				rowData.put("allocated_qty", checkNull(rs.getString("Allocated")).trim());
				rowData.put("commited_qty", checkNull(rs.getString("Commited_Qty")).trim());
				rowData.put("pending_PO", checkNull(rs.getString("Pending_PO")).trim());
				rowData.put("transit_qty", checkNull(rs.getString("Intransit")).trim());
				rowData.put("balanceinhand", checkNull(rs.getString("Balance_In_Hand")).trim());
				
				rowDataStockRequirementJson.put(count, rowData);
				count++;
			}
				
			System.out.println(" rowDataStockRequirementJson is =" + rowDataStockRequirementJson);

		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			}
			catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getTask():" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rowDataStockRequirementJson;
	}
	
	
	@SuppressWarnings("unchecked")
	public JSONObject getStockCrossDetail(String loginCode,String dataSourceName,String itemseries)throws RemoteException, ITMException
	{
		JSONObject rowDataStockCrossJson = new JSONObject();
		JSONObject rowData                = null;
		String sql                        = "";		
		ResultSet rs                      = null;
		PreparedStatement pstmt           = null;
		Connection conn                   = null;
		ConnDriver connDriver             = new ConnDriver();
		int count                         = 0;
		ArrayList<String> sizeList = new ArrayList<String>();
		String style = "", color = "", skusize = "", balance = "";
		DashboardUtility dashboardUtility=new DashboardUtility();
		String appendSql = "";
		
		HashMap<String, String> stockSizeDetailMap =null;
		HashMap<String, HashMap<String, String>> stockDetailMap = new HashMap<String, HashMap<String,String>>();
		try
		{
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;  
			
			
			sql = "select distinct ATTRIB_ID from itm_attrib_val where " +
				  "attrib_code='SIZE' order by sort_order"; 
			
			pstmt                            = conn.prepareStatement(sql);
			rs                               = pstmt.executeQuery();
			
			while(rs.next())
			{
				skusize = checkNull(rs.getString("ATTRIB_ID"));
				sizeList.add(skusize);
			}
			
			StringBuffer stylebuffer     = new StringBuffer ();
			StringBuffer sizes   = new StringBuffer ();
			for(int i=0; i < sizeList.size(); i++)
			{
				sizes.append("<td class='commonHeaderCardhtml' align='center'>"+sizeList.get(i)+"</td>");
			}
		
			sql = "";
			
			if(itemseries==null || itemseries.length()<1)
			{
				appendSql = "";
			}
			else
			{
				appendSql = "A.Item_Ser IN("+dashboardUtility.getCommaSeparated(itemseries)+") and ";
			}
			
			sql =   "select A.item_parnt Style,A.COLOR,A.SKU_Size, " +
					"B.Stock_In_Hand - C.Commited_Qty + D.Pending_PO as Balance_In_Hand from " +
					"(select item_parnt,item_code,phy_attrib_2 as COLOR, phy_attrib_1 as SKU_Size," +
					"Item_Ser from item)A, (select item_code,Sum(Quantity) Stock_In_Hand,Sum(Alloc_Qty) " +
					"Allocated from stock group by item_code) B, (select item_code__ord, " +
					"Sum(QTY_ORD- QTY_DESP) Commited_Qty from sorditem where (QTY_ORD- QTY_DESP)>0 " +
					"group by item_code__ord)C, (select Item_CODE, Sum(quantity-dlv_qty) as Pending_PO " +
					"from porddet where (quantity-dlv_qty)>0 group by Item_CODE) D " +
					"where A.item_code=B.item_code(+) " +
					"and " + appendSql +
					"A.item_code=C.item_code__ord(+) " +
					"and A.item_code=D.Item_CODE(+) " +
					"and A.item_parnt is not null and A.COLOR is not null " +
					//"and rownum<50"+
					" order by A.item_parnt" ;	
			
			pstmt                            = conn.prepareStatement(sql);
			rs                               = pstmt.executeQuery();	
			while (rs.next())
			{
				skusize = "";
				style   = checkNull(rs.getString("Style")).trim();
				color   = checkNull(rs.getString("COLOR")).trim();
				skusize = checkNull(rs.getString("SKU_Size")).trim();
				balance = checkBalance(rs.getString("Balance_In_Hand")).trim();
				String key = style+"~"+color;
				if(stockDetailMap.containsKey(key))
				{
					stockSizeDetailMap = stockDetailMap.get(key);
					stockSizeDetailMap.put(skusize, balance);
					stockDetailMap.put(key,stockSizeDetailMap);
				}
				else
				{
					stockSizeDetailMap = new HashMap<String, String>();
					stockSizeDetailMap.put(skusize, balance);
					stockDetailMap.put(key,stockSizeDetailMap);
				}
				
			}
			
			for(Map.Entry<String, HashMap<String, String>> entry: stockDetailMap.entrySet())
			{
				String mapKey = entry.getKey();
				HashMap<String, String> stockSizeMap = entry.getValue();
				
				System.out.println("mapKey: "+mapKey);
				
				String[] splitMapKey = mapKey.split("~");
				
				stylebuffer.append(generateTable(splitMapKey[0], splitMapKey[1], stockSizeMap, sizeList));
			}
			
			rowData = new JSONObject();
			rowData.put("stocks",stylebuffer.toString());
			rowData.put("columnsNo", sizeList.size());
			rowData.put("stockSizeizeList",sizes.toString());
			rowData.put("exporttoExcel", CommonConstants.TOMCAT_HOME+"/ibase/dwh/FusionChart/images/excel.png");
			rowDataStockCrossJson.put(count, rowData);
			
			count++;
				
			System.out.println(" rowDataStockCrossJson is =" + rowDataStockCrossJson);

		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			}
			catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getTask():" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rowDataStockCrossJson;
	}
	
	private String checkNull(String str)
	{
		if (str == null)
		{
			return "";
		} else
		{
			return str;
		}
	
	}
	
	private String checkBalance(String str)
	{
		if (str == null)
		{
			return "0";
		} else
		{
			return str.trim();
		}
	
	}
	public String generateTable(String style, String color, HashMap<String, String> stockSizeMap, ArrayList<String> sizeList)
	{
		
		
		StringBuffer tableData=new StringBuffer();
		tableData.append("<tr><td class='cardHtmlTableBodyAlignLft' style='width: 5%;'>"+style+
						"</td><td class='cardHtmlTableBodyAlignLft' style='width: 5%;'>"+color+
						"</td>");
		
		for (Iterator iterator = sizeList.iterator(); iterator.hasNext();) 
		{
			String stockSize = (String) iterator.next();
			String stockBalance = checkBalance(stockSizeMap.get(stockSize));
			tableData.append("<td class='cardHtmlTableBodyAlignRgt' >"+stockBalance+
						"</td>");	
		}
		tableData.append("</tr>");
		return tableData.toString();
	}
	
	
}
