package ibase.dashboard.crm.ejb;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;

import java.sql.*;
import java.util.*;
import java.util.Date;
import java.util.Map.Entry;

import javax.ejb.Stateless;

import org.json.simple.JSONObject;

@Stateless
public class OpportunityStageSummary implements OpportunityStageSummaryLocal,
OpportunityStageSummaryRemote {

	@SuppressWarnings({ "unchecked"})
	public JSONObject getOpportunityStageSummary(String dataSourceName,
			String loginCode,String oppStageDescr) 
	{

		JSONObject rowDataBasicJsn = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connection = new ConnDriver();
		String opprName = "", opprType = "", opprDate = "", sconCode = "", opprDescr = "", salesTeam = "",
				currCode = "", opprValue = "", salesProdGrp = "", profitPerc = "", forecastCloseDate = "", 
				salesPersonAssign = "", probPercStart = "", probVolumeCurrent = "", stageCode = "", 
				assDate = "", commId = "", salesPers = "", opprId = "", prodPerc = "", volume = "", reqType = "", 
				reqDescr = "", remarks = "", probPercCurrent = "", spName = "", stageDescr = "", contactName = "", 
				mobileNo = "", emailAddr = "", sorgName = "", sorgCode = "", opprPrcnt = "", salesPersEmpCode = "";
		int count = 0, countStageCode = 0, oppCountStageCode = 0;
		double valueStageCode = 0, oppValueStageCode = 0  ;
		Date foreCastCloserDate = null,asDate = null;
		String dbDateFormat= "",applDateFormat = "";
		try {

			conn = connection.getConnectDB(dataSourceName);
			
			E12GenericUtility genericUtility = new E12GenericUtility();
			dbDateFormat = genericUtility.getDBDateFormat();
			applDateFormat = genericUtility.getApplDateFormat();
			
			sql = "select sales_pers from sales_pers where emp_code = ?";
			pstmt = conn.prepareStatement(sql);
		    pstmt.setString(1, loginCode);
		    rs = pstmt.executeQuery();
		    while(rs.next()){
		    	salesPersEmpCode = rs.getString("sales_pers");
		    }
			
		    if (rs != null) {
				rs.close();
				rs = null;
			}
		    if (pstmt != null) {
				pstmt.close();
				pstmt = null;
			}
		    
			sql = "SELECT opp.oppr_id,"
					+ "opp.oppr_name,"
					+ "opp.oppr_type,"
					+ "opp.oppr_date as new_oppr_date,"
					+ "opp.scon_code,"
					+ "opp.sorg_code,"
					+ "opp.oppr_descr,"
					+ "opp.sales_team,"
					+ "opp.curr_code,"
					+ "opp.oppr_value,"
					+ "opp.sales_prod_grp,"
					+ "opp.profit_perc,"
					+ "opp.forecast_close_date as new_forecast_close_date,"
					+ "opp.sales_person_assign,"
					+ "opp.prob_perc_start,"
					+ "opp.prob_volume_current,"
					+ "opp.stage_code,"
					+ "opass.ass_date as new_ass_date,"
					+ "opass.comm_id,"
					+ "opass.prod_perc,"
					+ "opass.volume,"
					+ "opass.req_type,"
					+ "opass.req_descr,"
					+ "opass.remarks,"
					+ "opass.prob_perc_current,"
					+ "sales.sp_name,"
					+ "stage.descr as stage_descr,"
					+ "(contact.first_name||' '||case when contact.last_name is null or length(trim(contact.last_name)) = 0 then '' else trim(contact.last_name) end) as contact_name,"
					+ "contact.mobile_no,"
					+ "contact.email_addr,"
					+ "org.sorg_name "
					+ "FROM opportunity opp "
					+ "INNER JOIN oppr_assesment opass "
					+ "ON opp.oppr_id = opass.oppr_id "
					+ "INNER JOIN sales_pers sales "
					+ "ON sales.sales_pers = opass.sales_pers "
					+ "INNER JOIN sales_stage stage "
					+ "ON stage.stage_code = opp.stage_code "
					+ "INNER JOIN strg_contact contact "
					+ "ON contact.scon_code = opp.scon_code "
					+ "INNER JOIN strg_org org "
					+ "ON org.sorg_code = opp.sorg_code "
					+ "where opass.ass_date >= ADD_MONTHS(trunc(SYSDATE) , -40) "
					+ "and (opass.oppr_id , opass.ass_date) in (SELECT oppr_id,max(ass_date) FROM oppr_assesment opass1 where opass1.oppr_id = opass.oppr_id group by opass1.oppr_id) "
					+ "AND  stage.descr = ?"
					+ "AND opass.sales_pers = ?"
					+ "order by oppr_date,ass_date desc";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, oppStageDescr); 
			pstmt.setString(2, salesPersEmpCode);
			rs = pstmt.executeQuery();

			while (rs.next()) {
				
				foreCastCloserDate = rs.getDate("new_forecast_close_date");
				asDate = rs.getDate("new_ass_date");
				String newForecastDate ="",newAssDate="";
				newForecastDate = (foreCastCloserDate != null )? genericUtility.getValidDateString(foreCastCloserDate.toString(), dbDateFormat, applDateFormat ):null;
				newAssDate = (asDate != null )? genericUtility.getValidDateString(asDate.toString(), dbDateFormat, applDateFormat ):null;
						
						
				rowData = new JSONObject();

				rowData.put("sp_name", checkNull(rs.getString("sp_name")));
				rowData.put("stage_descr",checkNull(rs.getString("stage_descr")));
				rowData.put("contact_name",checkNull(rs.getString("contact_name")));
				rowData.put("sorg_name",checkNull(rs.getString("sorg_name")));
				rowData.put("oppr_descr",checkNull(rs.getString("oppr_descr")));
				rowData.put("oppr_value",checkNull(rs.getString("oppr_value")));
				rowData.put("oppr_name", checkNull(rs.getString("oppr_name")));
				rowData.put("forecast_close_date",newForecastDate);
				rowData.put("ass_date",newAssDate );
				
				rowDataBasicJsn.put(count, rowData);
				count++;
			}

		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("Exception in Opportunity Stage Summary :::: " + e.getMessage());
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}

				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}

				if (conn != null) {
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d) {
				d.printStackTrace();
				try {
					throw new ITMException(d);
				} catch (ITMException e) {
					e.printStackTrace();
				}
			}
		}
		return rowDataBasicJsn;
	}

	@SuppressWarnings({ "unchecked", "unused" })
	public JSONObject getOpportunityStageCount(String dataSourceName,
			String loginCode) {

		JSONObject rowDataCountJsn = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connection = new ConnDriver();
		String opprName = "", opprType = "", opprDate = "", sconCode = "", opprDescr = "", salesTeam = "", currCode = "", 
				salesProdGrp = "", profitPerc = "", forecastCloseDate = "", salesPersonAssign = "", probPercStart = "", 
				probVolumeCurrent = "", stageCode = "", assDate = "", commId = "", salesPers = "", opprId = "", prodPerc = "",
				volume = "", reqType = "", reqDescr = "", remarks = "", probPercCurrent = "", spName = "", stageDescr = "", 
				contactName = "", mobileNo = "", emailAddr = "", sorgName = "", sorgCode = "", opprValue = "", prvStageCode = "", 
				opprCount = "",salesPersEmpCode="";

		int count = 0,  countStageDescr = 0, totalCount = 0, oppCountStageWise = 0;
		double totalOppCount;

		try {

			HashMap<String, Integer> stageDescrHMap = new HashMap<String, Integer>();
			ArrayList<Double> totalCnt = new ArrayList<Double>();
			ArrayList<Integer> oppCnt = new ArrayList<Integer>();

			conn = connection.getConnectDB(dataSourceName);
			
			sql = "SELECT opp.oppr_id,"
					+ "opp.oppr_name,"
					+ "opp.oppr_type,"
					+ "to_char(opp.oppr_date,'dd-MM-yyyy') as new_oppr_date,"
					+ "opp.scon_code,"
					+ "opp.sorg_code,"
					+ "opp.oppr_descr,"
					+ "opp.sales_team,"
					+ "opp.curr_code,"
					+ "opp.oppr_value,"
					+ "opp.sales_prod_grp,"
					+ "opp.profit_perc,"
					+ "to_char(opp.forecast_close_date,'dd-MM-yyyy') as new_forecast_close_date,"
					+ "opp.sales_person_assign,"
					+ "opp.prob_perc_start,"
					+ "opp.prob_volume_current,"
					+ "opp.stage_code,"
					+ "to_char(opass.ass_date,'dd-MM-yyyy') as new_ass_date,"
					+ "opass.comm_id,"
					+ "opass.prod_perc,"
					+ "opass.volume,"
					+ "opass.req_type,"
					+ "opass.req_descr,"
					+ "opass.remarks,"
					+ "opass.prob_perc_current,"
					+ "sales.sales_pers,"
					+ "sales.sp_name,"
					+ "stage.descr as stage_descr,"
					+ "(contact.first_name||' '||case when contact.last_name is null or length(trim(contact.last_name)) = 0 then '' else trim(contact.last_name) end) as contact_name,"
					+ "contact.mobile_no,"
					+ "contact.email_addr,"
					+ "org.sorg_name "
					+ "FROM opportunity opp "
					+ "INNER JOIN oppr_assesment opass "
					+ "ON opp.oppr_id = opass.oppr_id "
					+ "INNER JOIN sales_pers sales "
					+ "ON sales.sales_pers = opass.sales_pers "
					+ "INNER JOIN sales_stage stage "
					+ "ON stage.stage_code = opp.stage_code "
					+ "INNER JOIN strg_contact contact "
					+ "ON contact.scon_code = opp.scon_code "
					+ "INNER JOIN strg_org org "
					+ "ON org.sorg_code = opp.sorg_code "
					+ "where opass.ass_date >= ADD_MONTHS(trunc(SYSDATE) , -40) "
					+ "and (opass.oppr_id , opass.ass_date) in (SELECT oppr_id,max(ass_date) FROM oppr_assesment opass1 where opass1.oppr_id = opass.oppr_id group by opass1.oppr_id) "
					+ "AND opass.sales_pers = ? "
					+ "order by oppr_date,ass_date";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, loginCode);
			rs = pstmt.executeQuery();
			while (rs.next()) {

				spName = checkNull(rs.getString("sp_name"));
				stageDescr = checkNull(rs.getString("stage_descr"));
				salesPers = checkNull(rs.getString("sales_pers"));
				stageCode = checkNull(rs.getString("stage_code"));
				opprValue = checkNull(rs.getString("oppr_value"));

				if (stageDescrHMap.containsKey(stageDescr)) {
					countStageDescr = countStageDescr + 1;
					totalCount = totalCount + 1;

					stageDescrHMap.put(stageDescr, countStageDescr);

				} else {
					countStageDescr = 0;
					countStageDescr = countStageDescr + 1;
					totalCount = totalCount + 1;
					stageDescrHMap.put(stageDescr, countStageDescr);
				}

			}

			Set<Map.Entry<String, Integer>> entrySet1 = stageDescrHMap.entrySet();
			Iterator<Entry<String, Integer>> entrySetIterator = entrySet1.iterator();

			while (entrySetIterator.hasNext()) {
				Entry<String, Integer> entry = entrySetIterator.next();
				oppCountStageWise = entry.getValue().intValue();

				oppCnt.add(count,oppCountStageWise);

				totalOppCount = (((double) oppCountStageWise / totalCount) * 100);
				totalCnt.add(count, totalOppCount);
				rowData = new JSONObject();

				rowData.put("stage_descr",entry.getKey());
				rowData.put("count",oppCountStageWise);
				rowData.put("totalOppCount", totalOppCount);

				rowDataCountJsn.put(count, rowData);
				count++;
			}

		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("Exception in Opportunity Stage Count :::: "+ e.getMessage());
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}

				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}

				if (conn != null) {
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d) {
				d.printStackTrace();
				try {
					throw new ITMException(d);
				} catch (ITMException e) {
					e.printStackTrace();
				}
			}
		}
		return rowDataCountJsn;
	}

	@SuppressWarnings({ "unused", "unchecked" })
	public JSONObject getOpportunityStageValue(String dataSourceName,
			String loginCode) {
		JSONObject rowDataValueJsn = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connection = new ConnDriver();
		String opprName = "", opprType = "", opprDate = "", sconCode = "", opprDescr = "", salesTeam = "",
				currCode = "", salesProdGrp = "", profitPerc = "", forecastCloseDate = "", salesPersonAssign = "", 
				probPercStart = "", probVolumeCurrent = "", stageCode = "", assDate = "", commId = "", salesPers = "",
				opprId = "", prodPerc = "", volume = "", reqType = "", reqDescr = "", remarks = "", probPercCurrent = "", 
				spName = "", stageDescr = "", contactName = "", mobileNo = "", emailAddr = "", sorgName = "", sorgCode = "", 
				opprValue = "",salesPersEmpCode="";

		int count = 0;
		double  valueStageDescr = 0, totalValue = 0.0, oppValueStageWise = 0;
		double totalOppValue = 0;
		try {

			HashMap<String, Double> stageDescrHMap = new HashMap<String, Double>();
			ArrayList<Double> totalVal = new ArrayList<Double>();
			ArrayList<Double> oppValue = new ArrayList<Double>();

			conn = connection.getConnectDB(dataSourceName);
			
			sql = "select sales_pers from sales_pers where emp_code = ?";
			pstmt = conn.prepareStatement(sql);
		    pstmt.setString(1, loginCode);
		    rs = pstmt.executeQuery();
		    while(rs.next()){
		    	salesPersEmpCode = rs.getString("sales_pers");
		    }
			
		    if (rs != null) {
				rs.close();
				rs = null;
			}
		    if (pstmt != null) {
				pstmt.close();
				pstmt = null;
			}
		    
			sql = "SELECT opp.oppr_id,"
					+ "opp.oppr_name,"
					+ "opp.oppr_type,"
					+ "to_char(opp.oppr_date,'dd-MM-yyyy') as new_oppr_date,"
					+ "opp.scon_code,"
					+ "opp.sorg_code,"
					+ "opp.oppr_descr,"
					+ "opp.sales_team,"
					+ "opp.curr_code,"
					+ "opp.oppr_value,"
					+ "opp.sales_prod_grp,"
					+ "opp.profit_perc,"
					+ "to_char(opp.forecast_close_date,'dd-MM-yyyy') as new_forecast_close_date,"
					+ "opp.sales_person_assign,"
					+ "opp.prob_perc_start,"
					+ "opp.prob_volume_current,"
					+ "opp.stage_code,"
					+ "to_char(opass.ass_date,'dd-MM-yyyy') as new_ass_date,"
					+ "opass.comm_id,"
					+ "opass.prod_perc,"
					+ "opass.volume,"
					+ "opass.req_type,"
					+ "opass.req_descr,"
					+ "opass.remarks,"
					+ "opass.prob_perc_current,"
					+ "sales.sales_pers,"
					+ "sales.sp_name,"
					+ "stage.descr as stage_descr,"
					+ "(contact.first_name||' '||case when contact.last_name is null or length(trim(contact.last_name)) = 0 then '' else trim(contact.last_name) end) as contact_name,"
					+ "contact.mobile_no,"
					+ "contact.email_addr,"
					+ "org.sorg_name "
					+ "FROM opportunity opp "
					+ "INNER JOIN oppr_assesment opass "
					+ "ON opp.oppr_id = opass.oppr_id "
					+ "INNER JOIN sales_pers sales "
					+ "ON sales.sales_pers = opass.sales_pers "
					+ "INNER JOIN sales_stage stage "
					+ "ON stage.stage_code = opp.stage_code "
					+ "INNER JOIN strg_contact contact "
					+ "ON contact.scon_code = opp.scon_code "
					+ "INNER JOIN strg_org org "
					+ "ON org.sorg_code = opp.sorg_code "
					+ "where opass.ass_date >= ADD_MONTHS(trunc(SYSDATE) , -40) "
					+ "and (opass.oppr_id , opass.ass_date) in (SELECT oppr_id,max(ass_date) FROM oppr_assesment opass1 where opass1.oppr_id = opass.oppr_id group by opass1.oppr_id)"
					+ "AND opass.sales_pers = ?"
					+ "order by oppr_date,ass_date";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, salesPersEmpCode);
			rs = pstmt.executeQuery();
			while (rs.next()) {

				spName = checkNull(rs.getString("sp_name"));
				stageDescr = checkNull(rs.getString("stage_descr"));
				salesPers = checkNull(rs.getString("sales_pers"));
				stageCode = checkNull(rs.getString("stage_code"));
				opprValue = checkNull(rs.getString("oppr_value"));

				if (stageDescrHMap.containsKey(stageDescr)) {
					valueStageDescr = stageDescrHMap.get(stageDescr) + Double.parseDouble(opprValue);
					totalValue = totalValue + Double.parseDouble(opprValue);

					stageDescrHMap.put(stageDescr, valueStageDescr);

				} else {
					valueStageDescr = 0;
					valueStageDescr = valueStageDescr + Double.parseDouble(opprValue);
					totalValue = totalValue + Double.parseDouble(opprValue);
					stageDescrHMap.put(stageDescr, valueStageDescr);
				}
			}

			System.out.println("Stage Descr HMap "+stageDescrHMap);

			Set<Map.Entry<String, Double>> entrySet = stageDescrHMap.entrySet();
			Iterator<Entry<String, Double>> entrySetIterator = entrySet.iterator();

			while (entrySetIterator.hasNext()) {
				Entry<String, Double> entry = entrySetIterator.next();
				oppValueStageWise = entry.getValue();

				oppValue.add(count, oppValueStageWise);

				totalOppValue = ((oppValueStageWise / totalValue) * 100);

				totalVal.add(count, totalOppValue);
				rowData = new JSONObject();

				rowData.put("stage_descr", entry.getKey());
				rowData.put("oppr_value",oppValueStageWise) ;
				rowData.put("totalOppValue", totalOppValue);
				rowDataValueJsn.put(count, rowData);
				count++;
			}

		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("Exception in Opportunity Stage Value :::: " + e.getMessage());
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}

				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}

				if (conn != null) {
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d) {
				d.printStackTrace();
				try {
					throw new ITMException(d);
				} catch (ITMException e) {
					e.printStackTrace();
				}
			}
		}

		return rowDataValueJsn;
	}

	@SuppressWarnings({ "unused", "unchecked" })
	public JSONObject getOrganizationStageCount(String dataSourceName,
			String loginCode) {

		JSONObject rowDataCountJsn = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connection = new ConnDriver();
		String opprName = "", opprType = "", opprDate = "", sconCode = "", opprDescr = "",
				salesTeam = "", currCode = "", salesProdGrp = "", profitPerc = "", forecastCloseDate = "",
				salesPersonAssign = "", probPercStart = "", probVolumeCurrent = "", stageCode = "", 
				assDate = "", commId = "", salesPers = "", opprId = "", prodPerc = "", volume = "", 
				reqType = "", reqDescr = "", remarks = "", probPercCurrent = "", spName = "", stageDescr = "",
				contactName = "", mobileNo = "", emailAddr = "", sorgName = "", sorgCode = "", opprValue = "",
				prvStageCode = "", opprCount = "",salesPersEmpCode="";

		int count = 0,  countStageCode = 0, totalCount = 0, orgCountStageWise = 0;
		double totalOrgCount = 0;
		try {

			HashMap<String, Integer> stageCodeHMap = new HashMap<String, Integer>();
			ArrayList<Integer> orgCount = new ArrayList<Integer>();
			ArrayList<Double> orgCountPnct = new ArrayList<Double>();

			conn = connection.getConnectDB(dataSourceName);
			
			sql = "SELECT opp.oppr_id,"
					+ "opp.oppr_name,"
					+ "opp.oppr_type,"
					+ "to_char(opp.oppr_date,'dd-MM-yyyy') as new_oppr_date,"
					+ "opp.scon_code,"
					+ "opp.sorg_code,"
					+ "opp.oppr_descr,"
					+ "opp.sales_team,"
					+ "opp.curr_code,"
					+ "opp.oppr_value,"
					+ "opp.sales_prod_grp,"
					+ "opp.profit_perc,"
					+ "to_char(opp.forecast_close_date,'dd-MM-yyyy') as new_forecast_close_date,"
					+ "opp.sales_person_assign,"
					+ "opp.prob_perc_start,"
					+ "opp.prob_volume_current,"
					+ "opp.stage_code,"
					+ "to_char(opass.ass_date,'dd-MM-yyyy') as new_ass_date,"
					+ "opass.comm_id,"
					+ "opass.prod_perc,"
					+ "opass.volume,"
					+ "opass.req_type,"
					+ "opass.req_descr,"
					+ "opass.remarks,"
					+ "opass.prob_perc_current,"
					+ "sales.sales_pers,"
					+ "sales.sp_name,"
					+ "stage.descr as stage_descr,"
					+ "(contact.first_name||' '||case when contact.last_name is null or length(trim(contact.last_name)) = 0 then '' else trim(contact.last_name) end) as contact_name,"
					+ "contact.mobile_no,"
					+ "contact.email_addr,"
					+ "org.sorg_name "
					+ "FROM opportunity opp "
					+ "INNER JOIN oppr_assesment opass "
					+ "ON opp.oppr_id = opass.oppr_id "
					+ "INNER JOIN sales_pers sales "
					+ "ON sales.sales_pers = opass.sales_pers "
					+ "INNER JOIN sales_stage stage "
					+ "ON stage.stage_code = opp.stage_code "
					+ "INNER JOIN strg_contact contact "
					+ "ON contact.scon_code = opp.scon_code "
					+ "INNER JOIN strg_org org "
					+ "ON org.sorg_code = opp.sorg_code "
					+ "where opass.ass_date >= ADD_MONTHS(trunc(SYSDATE) , -40) "
					+ "and (opass.oppr_id , opass.ass_date) in (SELECT oppr_id,max(ass_date) FROM oppr_assesment opass1 where opass1.oppr_id = opass.oppr_id group by opass1.oppr_id) "
					+ "order by oppr_date,ass_date";

			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			while (rs.next()) {

				spName = checkNull(rs.getString("sp_name"));
				salesPers = checkNull(rs.getString("sales_pers"));
				stageCode = checkNull(rs.getString("stage_code"));
				opprValue = checkNull(rs.getString("oppr_value"));

				if (stageCodeHMap.containsKey(stageCode)) {
					countStageCode = countStageCode + 1;
					totalCount = totalCount + 1;

					stageCodeHMap.put(stageCode, countStageCode);

				} else {
					countStageCode = 0;
					countStageCode = countStageCode + 1;
					totalCount = totalCount + 1;
					stageCodeHMap.put(stageCode, countStageCode);
				}

			}

			Set<Map.Entry<String, Integer>> entrySet1 = stageCodeHMap.entrySet();
			Iterator<Entry<String, Integer>> entrySetIterator = entrySet1.iterator();

			while (entrySetIterator.hasNext()) {
				Entry<String, Integer> entry = entrySetIterator.next();
				orgCountStageWise = entry.getValue().intValue();

				orgCount.add(count,orgCountStageWise);

				totalOrgCount = (((double) orgCountStageWise / totalCount) * 100);

				orgCountPnct.add(count, totalOrgCount);

				rowData = new JSONObject();

				rowData.put("stage_code", entry.getKey());
				rowData.put("totalOrgCount", totalOrgCount);

				rowDataCountJsn.put(count, rowData);
				count++;
			}

		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("Exception in Organization Stage Count :::: "+ e.getMessage());
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}

				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}

				if (conn != null) {
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d) {
				d.printStackTrace();
				try {
					throw new ITMException(d);
				} catch (ITMException e) {
					e.printStackTrace();
				}
			}
		}		
		return rowDataCountJsn;
	}

	@SuppressWarnings({ "unused", "unchecked" })
	public JSONObject getOrganizationStageValue(String dataSourceName,
			String loginCode) {

		JSONObject rowDataValueJsn = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connection = new ConnDriver();
		String opprName = "", opprType = "", opprDate = "", sconCode = "", opprDescr = "", salesTeam = "",
				currCode = "", salesProdGrp = "", profitPerc = "", forecastCloseDate = "", salesPersonAssign = "",
				probPercStart = "", probVolumeCurrent = "", stageCode = "", assDate = "", commId = "", salesPers = "",
				opprId = "", prodPerc = "", volume = "", reqType = "", reqDescr = "", remarks = "", probPercCurrent = "",
				spName = "", stageDescr = "", contactName = "", mobileNo = "", emailAddr = "", sorgName = "", sorgCode = "", 
				opprValue = "", countOppr = "";

		int count = 0;
		double  valueStageCode = 0, totalValue = 0.0, orgValueStageWise = 0, totalOrgValue = 0;
		try {

			HashMap<String, Double> stageCodeHMap = new HashMap<String, Double>();
			ArrayList<Double> orgValue = new ArrayList<Double>();
			ArrayList<Double> orgValuePnct = new ArrayList<Double>();

			conn = connection.getConnectDB(dataSourceName);

			sql = "SELECT opp.oppr_id,"
					+ "opp.oppr_name,"
					+ "opp.oppr_type,"
					+ "to_char(opp.oppr_date,'dd-MM-yyyy') as new_oppr_date,"
					+ "opp.scon_code,"
					+ "opp.sorg_code,"
					+ "opp.oppr_descr,"
					+ "opp.sales_team,"
					+ "opp.curr_code,"
					+ "opp.oppr_value,"
					+ "opp.sales_prod_grp,"
					+ "opp.profit_perc,"
					+ "to_char(opp.forecast_close_date,'dd-MM-yyyy') as new_forecast_close_date,"
					+ "opp.sales_person_assign,"
					+ "opp.prob_perc_start,"
					+ "opp.prob_volume_current,"
					+ "opp.stage_code,"
					+ "to_char(opass.ass_date,'dd-MM-yyyy') as new_ass_date,"
					+ "opass.comm_id,"
					+ "opass.prod_perc,"
					+ "opass.volume,"
					+ "opass.req_type,"
					+ "opass.req_descr,"
					+ "opass.remarks,"
					+ "opass.prob_perc_current,"
					+ "sales.sales_pers,"
					+ "sales.sp_name,"
					+ "stage.descr as stage_descr,"
					+ "(contact.first_name||' '||case when contact.last_name is null or length(trim(contact.last_name)) = 0 then '' else trim(contact.last_name) end) as contact_name,"
					+ "contact.mobile_no,"
					+ "contact.email_addr,"
					+ "org.sorg_name "
					+ "FROM opportunity opp "
					+ "INNER JOIN oppr_assesment opass "
					+ "ON opp.oppr_id = opass.oppr_id "
					+ "INNER JOIN sales_pers sales "
					+ "ON sales.sales_pers = opass.sales_pers "
					+ "INNER JOIN sales_stage stage "
					+ "ON stage.stage_code = opp.stage_code "
					+ "INNER JOIN strg_contact contact "
					+ "ON contact.scon_code = opp.scon_code "
					+ "INNER JOIN strg_org org "
					+ "ON org.sorg_code = opp.sorg_code "
					+ "where opass.ass_date >= ADD_MONTHS(trunc(SYSDATE) , -40) "
					+ "and (opass.oppr_id , opass.ass_date) in (SELECT oppr_id,max(ass_date) FROM oppr_assesment opass1 where opass1.oppr_id = opass.oppr_id group by opass1.oppr_id)"
					+ "order by oppr_date,ass_date";

			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			while (rs.next()) {

				spName = checkNull(rs.getString("sp_name"));
				salesPers = checkNull(rs.getString("sales_pers"));
				stageCode = checkNull(rs.getString("stage_code"));
				opprValue = checkNull(rs.getString("oppr_value"));

				if (stageCodeHMap.containsKey(stageCode)) {
					valueStageCode = stageCodeHMap.get(stageCode) + Double.parseDouble(opprValue);
					totalValue = totalValue + Double.parseDouble(opprValue);

					stageCodeHMap.put(stageCode, valueStageCode);

				} else {
					valueStageCode = 0;
					valueStageCode = valueStageCode + Double.parseDouble(opprValue);
					totalValue = totalValue + Double.parseDouble(opprValue);
					stageCodeHMap.put(stageCode, valueStageCode);
				}
			}

			Set<Map.Entry<String, Double>> entrySet1 = stageCodeHMap.entrySet();
			Iterator<Entry<String, Double>> entrySetIterator = entrySet1.iterator();

			while (entrySetIterator.hasNext()) {
				Entry<String, Double> entry = entrySetIterator.next();
				orgValueStageWise = entry.getValue();

				orgValue.add(count, orgValueStageWise);

				totalOrgValue = ((orgValueStageWise / totalValue) * 100);

				orgValuePnct.add(count, totalOrgValue);

				rowData = new JSONObject();

				rowData.put("stage_code", entry.getKey());
				rowData.put("totalOrgValue", totalOrgValue);

				rowDataValueJsn.put(count, rowData);
				count++;
			}

		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("Exception in Organization Stage Value :::: " + e.getMessage());
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}

				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}

				if (conn != null) {
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d) {
				d.printStackTrace();
				try {
					throw new ITMException(d);
				} catch (ITMException e) {
					e.printStackTrace();
				}
			}
		}		
		return rowDataValueJsn;
	}

	private String checkNull(String str) {
		if (str == null) {
			return "";
		} else {
			return str.trim();
		}
	}
}
