/**
* PURPOSE : EJB component CartonNoGenIC for carton no generation
* AUTHOR : Changed By Chaitali On 25/11/2011 
*/

package ibase.webitm.ejb.wms;

import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.SimpleDateFormat;

import org.w3c.dom.*;

@javax.ejb.Stateless
public class CartonNoGenIC extends ValidatorEJB implements CartonNoGenICLocal, CartonNoGenICRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();	
	/**
	* The method defined with no paramter and returns nothing
	*/
	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}//end of wfVAlData

	/**
	 * The public method is used for validation of required fields which inturn called overloded method
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currXmlDataStr contains the current form data in XML format
	 * @param hdrXmlDataStr contains always header form data in XML format
	 * @param allXmlDataStr contains all forms data in XML format
	 * @param objContext represents form no
	 * @param editFlag the mode of the transaction(A-Add or E-Edit)
	 * @param xtraParams contais additional information such as loginEmpCode,loginCode,chgTerm etc
	 */
	public String wfValData(String currXmlDataStr, String hdrXmlDataStr, String allXmlDataStr, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currDom = null;
		Document hdrDom = null;
		Document allDom = null;
		String errString = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		try
		{
			if(currXmlDataStr != null && currXmlDataStr.trim().length()!=0)
			{
				currDom = genericUtility.parseString(currXmlDataStr);
			}
			if(hdrXmlDataStr != null && hdrXmlDataStr.trim().length()!=0)
			{
				hdrDom = genericUtility.parseString(hdrXmlDataStr);
			}
			if(allXmlDataStr != null && allXmlDataStr.trim().length()!=0)
			{
				allDom = genericUtility.parseString(allXmlDataStr);
			}
			errString = wfValData( currDom, hdrDom, allDom, objContext, editFlag, xtraParams );
			System.out.println ( "ErrString: " + errString);
		}//end of try
		catch(Exception e)
		{
			System.out.println ( "Exception:CartonNoGenIC: wfValData(): " + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}//end of catch
		
		System.out.println ( "Returning from EJB wfValData" );
		return ( errString );
	}//end of wfvalData() of xml string

	/**
	* The public overloded method is used for validation of required fields
	* Returns validation string if exist otherwise returns null in XML format
	* @param currDom contains the current form data
	* @param hdrDom contains always header form data
	* @param allDom contains all forms data
	* @param objContext represents form no
	* @param editFlag the mode of the transaction(A-Add or E-Edit)
	* @param xtraParams contais additional information such as loginEmpCode,loginCode,chgTerm etc
	*/

	public String wfValData(Document currDom, Document hdrDom, Document allDom, String objContext, String editFlag,String xtraParams) throws RemoteException, ITMException
	{
		String errString = "";
		ResultSet rSet = null;
		Connection connObject = null;
		PreparedStatement pstmt = null;

		E12GenericUtility genericUtility = new E12GenericUtility();
		try
		{
			String columnValue = "";
			int currentFormNo = 0;
			//Commented by Santosh on 14-06-2016
			//ConnDriver connDriver = null;
			//connDriver = new ConnDriver();
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//connObject = connDriver.getConnectDB("DriverValidator");
			connObject = getConnection();
			//Changed and Commented By Santosh on 14-06-2016 :[END]

			NodeList parentList = null;
			NodeList childList = null;
			int noOfChilds = 0;
			String childNodeName = "";
			Node childNode =null;
			boolean isNumber = true;
			String sql = "";
			int count=0;

			String userID = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "LoginCode" );
	
			if ( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}

			parentList = currDom.getElementsByTagName( "Detail" + currentFormNo );
			childList = parentList.item( 0 ).getChildNodes();
			noOfChilds = childList.getLength();
			for (int ctr = 0; ctr < noOfChilds; ctr++)
			{
				childNode = childList.item( ctr );
				childNodeName = childNode.getNodeName();
				if ( childNode != null && childNode.getFirstChild() != null )
				{
					columnValue = childNode.getFirstChild().getNodeValue();
				}
				if ( "no_of_cartons".equalsIgnoreCase( childNodeName ) )
				{
					if (childNode.getFirstChild()==null)//checking for null no_of_cartons
					{
					   errString = getErrorString("no_of_cartons","INVCRTN",userID);
					   break;
					}
					else
					{
						isNumber = checkNumeric( columnValue );
						System.out.println("isNumber =["+isNumber+"]");
						if ( !isNumber )
						{
							errString = getErrorString("no_of_cartons","NOTANUMBR1",userID);
							break;
						}
					}

				}
				//ADDED BY MAHESH PATIDAR ON 05/06/12
				if ( "no_of_pallet".equalsIgnoreCase( childNodeName ) )
				{
					if (childNode.getFirstChild()==null)//checking for null no_of_cartons
					{
					   errString = getErrorString("no_of_pallet","VTPNOEMPTY",userID);
					   break;
					}
					else
					{
						isNumber = checkNumeric( columnValue );
						System.out.println("isNumber =["+isNumber+"]");
						if ( !isNumber )
						{
							errString = getErrorString("no_of_pallet","NOTANUMBR1",userID);
							break;
						}
					}

				} //ENDED BY MAHESH PATIDAR
				//Changed by Sankara on 19/11/2012 to add validation for printer_name[Start]
				else if ( "printer_name".equalsIgnoreCase( childNodeName ) )
				{
					columnValue = "";
					columnValue = genericUtility.getColumnValue("pallet_label",currDom);
					System.out.println(" my print label ->["+columnValue+"]");
					if (childNode.getFirstChild()==null && "Y".equalsIgnoreCase(columnValue))//checking for null no_of_cartons
					{
					   errString = getErrorString("no_of_pallet","BLKPRINTNM",userID);
					   break;
					}
				} 
				//Changed by Sankara on 19/11/2012 to add validation for printer_name[End]
			}
		} //end of try
		catch(Exception e)
		{
			System.out.println("Exception in CartonNoGenIC  == >");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rSet != null )
				{
					rSet.close();
					rSet = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( connObject != null && ! connObject.isClosed() )
				{
					connObject.close();
					connObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :CartonNoGenIC:wfValData :==>\n"+e.getMessage());
				throw new ITMException(e);
			}//end of catch
		} //end of finally
		return (errString);
	}
	private String checkNull(String string) 
	{
		if(string == null)
		{
			string = "";
		}
		return string;
	}
	//Changed by Sankara on 19/11/2012 for default value of pallet_label[Start]
	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{   
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			valueXmlString = itemChanged( dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams );
		}
		catch(Exception e)
		{
			System.out.println("Exception : [TrainingEJB][itemChanged(String,String)] :==>\n"+e.getMessage());
			throw new ITMException( e );
		}
        return valueXmlString;
	}
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		StringBuffer valueXmlString = new StringBuffer();
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		int currentFormNo = 0 ;
		String siteCode = "";
		String palletLabel = "";
		String chgTerm = "";
		java.util.Date currDate = null;
		String currDateStr = null;
		//Commented by Santosh on 14-06-2016
		//ConnDriver connDriver = new ConnDriver();
		E12GenericUtility genericUtility = new E12GenericUtility();
		
		try
		{   
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			conn.setAutoCommit(false);
			//Commented by Santosh on 14-06-2016
			//connDriver=null;
			
			String applDateFormat = genericUtility.getApplDateFormat();
	    	currDate = new java.util.Date();
	    	SimpleDateFormat sdf = new SimpleDateFormat(applDateFormat);
			currDateStr = sdf.format(currDate);
			
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			chgTerm = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" ));
			System.out.println("********__******ITEM DEFAULT CALLED");
			switch(currentFormNo)
			{
				case 1 :
				{
					valueXmlString.append("<Detail1 domID='1' selected=\"N\">\r\n");
					valueXmlString.append("<attribute  selected=\"N\" updateFlag=\"A\"  status=\"N\" pkNames=\"\" />\r\n");
				    if(currentColumn.trim().equalsIgnoreCase("itm_default"))
					{
						siteCode = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));
						valueXmlString.append("<pallet_label>").append("N").append("</pallet_label>");	
						valueXmlString.append("<printer_name protect=\"1\">").append("").append("</printer_name>");
	                }
				    else if("pallet_label".equalsIgnoreCase(currentColumn.trim()))
				    {
				    	palletLabel = genericUtility.getColumnValue("pallet_label",dom);
				    	
					    if( "N".equalsIgnoreCase(palletLabel) )
					    {
					    	valueXmlString.append("<printer_name protect=\"1\">").append("").append("</printer_name>");
					    }
					    else
					    {
					    	valueXmlString.append("<printer_name protect=\"0\">").append("").append("</printer_name>");
					    }
				    }
					valueXmlString.append("</Detail1>");
				  }     	
	              break;
			} 
			valueXmlString.append("</Root>");
			System.out.println("=================["+valueXmlString+"]");
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception ::"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn!=null)
				{
					if(pstmt != null)
					{	
						pstmt.close();
						pstmt = null;
					}	
					if(rs != null)
					{	
						rs.close();
						rs = null;
					}	
					if(conn != null)
					{	
						conn.close();
						conn = null;
					}	
				}
				
			}
			catch(Exception d)
			{
			  d.printStackTrace();
			}			
		}
		return valueXmlString.toString();
	}
	//Changed by Sankara on 19/11/2012 for default value of pallet_label[End]
	private boolean checkNumeric( String noOfLabel ) throws Exception
	{
		char[] cArray = noOfLabel.toCharArray();
		boolean isNumber = true;
		for(int i = 0; i < cArray.length;i++) 
		{
			if( !Character.isDigit(cArray[i]) ) 
			{
				isNumber = false;
			}
		}
		return isNumber;
	}
}
