/*
 * Author:Wasim Ansari
 * Date:03-05-2017
 * Request ID:F17BBAS001 (GST Wizard Post Save Component for Reconciliation Trace)
 */
package ibase.webitm.ejb.gst;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.util.gst.GSTCommonUtil;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import javax.ejb.Stateless;

import org.jcodec.codecs.vpx.VP8FixedRateControl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class GstrCustomTranEJB extends ValidatorEJB implements GstrCustomTranEJBRemote,GstrCustomTranEJBLocal 
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
	GSTCommonUtil gstUtility = new GSTCommonUtil();
    /**
     * Default constructor. 
     */
    public GstrCustomTranEJB() {
        // TODO Auto-generated constructor stub
    }
	@Override
	public String saveRecord(String objName,String tranXml,String gsttype, UserInfoBean userInfo) throws RemoteException, ITMException 
	{
		Connection conn = null;
		String sql = "";
		PreparedStatement pstmt = null;
		Document tranDoc = null;
		NodeList detailNodeList = null;
		String retXmlString = "<root>";
		String errString = "";
		boolean isErrorExist = false;
		String dbDateStr = "";
		String valSql = "";
		ResultSet vRs = null;
		String tranid = null,trandate = null,tranidref= null,sitecode = null,prdcode = null,
				rectype= null,trantype = null,custcode= null,custname= null,submissiontype= null,
				docchecksum = null,doctype= null,docno= null,docdate= null,amount= null,
				reversechrg= null,lrno = null,lrdate= null,reascode= null,refidinv= null,
				refdateinv= null,provassmnt= null,orderno= null,orderdate= null,remarks = null,
				submitstatus = null,submitdate= null,adduser = null,adddate= null,addterm = null,
				chguser = null,chgdate= null,chgterm= null,taxregno  = null,recostatus= null,
				ecomregno= null,refser= null,gstcode= null,refid= null;
		
		int lineno = 0;
		String status = null, srnoold = null, linetype = null, gscode = null, 
				taxableamt = null, igstperc = null, igstamt = null, cgstperc = null, cgstamt = null, sgstperc = null, sgstamt = null, gsdescr = null, 
				unit = null, quantity = null, supplytype = null, cessperc = null, cessamt = null, remarksDet = null, itctype = null, itcigst = null, 
				itccgst = null, itcsgst = null, itccess = null, gstrate = null;

		try
		{	
			System.out.println("===================Inside GstrCustomTranEJB class========================");
			if(conn == null || conn.isClosed())
			{
				System.out.println("@@Connection is null");
				conn = getConnection();
			}
			tranDoc = genericUtility.parseString(tranXml);
			detailNodeList = tranDoc.getElementsByTagName("Detail");

			docdate = genericUtility.getColumnValue("doc_date", tranDoc);
			prdcode = genericUtility.getColumnValue("prd_code", tranDoc);
			gsttype = genericUtility.getColumnValue("gst_type", tranDoc);
			if(docdate == null || docdate.length() == 0)
			{
				errString = getErrorString("doc_date", "INVDOCDATE", userInfo.getLoginCode());
				isErrorExist = true;
				return errString;
			}
			if(prdcode == null || prdcode.length() == 0)
			{
				errString = getErrorString("doc_date", "INVDOCDATE", userInfo.getLoginCode());
				isErrorExist = true;
				return errString;
			}
			else
			{
				valSql = "select tran_id from gst_data_hdr where gst_type = ? and prd_code = ? and rec_type = ?";

				pstmt =  conn.prepareStatement(valSql);
				pstmt.setString(1, gsttype);
				pstmt.setString(2, prdcode);
				if(objName != null && objName.equalsIgnoreCase("gstr"))
				{
					pstmt.setString(3, "1");
				}
				else if(objName != null && objName.equalsIgnoreCase("gstr_purc"))
				{
					pstmt.setString(3, "2");
				}
				else if(objName != null && objName.equalsIgnoreCase("gstr3b"))
				{
					pstmt.setString(3, "6");
				}
			
				vRs = pstmt.executeQuery();
				
				System.out.println(vRs.getFetchSize());
				if(vRs.next())
				{
					System.out.println("tran_id exist: "+vRs.getString("tran_id"));
					errString = getErrorString("doc_date", "INVGSTPCOD", userInfo.getLoginCode());
					isErrorExist = true;
					return errString;
				}
				if(pstmt != null)
				{
					pstmt.close(); 
					pstmt = null;
				}
			}


			for(int i = 0; i < detailNodeList.getLength() && !isErrorExist; i++)
			{
				Node detailNodePatent = detailNodeList.item(i);
				Node detailNode = null;
				double totalAmount = 0.00;
				tranid = null;
				tranid = gstUtility.generateTranId("w_"+objName, userInfo.getSiteCode(), conn);
				lineno = 0;
				for(int detCntr = 0; detCntr < detailNodePatent.getChildNodes().getLength(); detCntr++)
				{
					detailNode = detailNodePatent.getChildNodes().item(detCntr);

					if(detailNode.getNodeName().equalsIgnoreCase("detail1"))
					{
						trandate = null;tranidref= null;sitecode = null;prdcode = null;
						rectype= null;trantype = null;custcode= null;custname= null;submissiontype= null;
						docchecksum = null;doctype= null;docno= null;docdate= null;amount= null;
						reversechrg= null;lrno = null;lrdate= null;reascode= null;refidinv= null;
						refdateinv= null;provassmnt= null;orderno= null;orderdate= null;remarks = null;
						submitstatus = null;submitdate= null;adduser = null;adddate= null;addterm = null;
						chguser = null;chgdate= null;chgterm= null;taxregno  = null;recostatus= null;
						ecomregno= null;refser= null;gstcode= null;gsttype= null;refid= null;

						trandate = genericUtility.getColumnValueFromNode("tran_date", detailNode);
						tranidref= genericUtility.getColumnValueFromNode("tran_id__ref", detailNode);
						sitecode = genericUtility.getColumnValueFromNode("site_code", detailNode);
						prdcode = genericUtility.getColumnValueFromNode("prd_code", detailNode);
						rectype= genericUtility.getColumnValueFromNode("rec_type", detailNode);
						trantype = genericUtility.getColumnValueFromNode("tran_type", detailNode);
						custcode= genericUtility.getColumnValueFromNode("cust_code", detailNode);
						custname= genericUtility.getColumnValueFromNode("cust_name", detailNode);
						submissiontype= genericUtility.getColumnValueFromNode("submission_type", detailNode);
						docchecksum = genericUtility.getColumnValueFromNode("doc_checksum", detailNode);
						doctype= genericUtility.getColumnValueFromNode("doc_type", detailNode);
						docno= genericUtility.getColumnValueFromNode("doc_no", detailNode);
						docdate= genericUtility.getColumnValueFromNode("doc_date", detailNode);
						amount= genericUtility.getColumnValueFromNode("amount", detailNode);
						reversechrg= genericUtility.getColumnValueFromNode("reverse_chrg", detailNode);
						lrno = genericUtility.getColumnValueFromNode("lr_no", detailNode);
						lrdate= genericUtility.getColumnValueFromNode("lr_date", detailNode);
						reascode= genericUtility.getColumnValueFromNode("reas_code", detailNode);
						refidinv= genericUtility.getColumnValueFromNode("ref_id__inv", detailNode);
						refdateinv= genericUtility.getColumnValueFromNode("ref_date__inv", detailNode);
						provassmnt= genericUtility.getColumnValueFromNode("prov_assmnt", detailNode);
						orderno= genericUtility.getColumnValueFromNode("order_no", detailNode);
						orderdate= genericUtility.getColumnValueFromNode("order_date", detailNode);
						remarks = genericUtility.getColumnValueFromNode("remarks", detailNode);
						submitstatus = genericUtility.getColumnValueFromNode("submit_status", detailNode);
						submitdate= genericUtility.getColumnValueFromNode("submit_date", detailNode);
						adduser = genericUtility.getColumnValueFromNode("add_user", detailNode);
						adddate= genericUtility.getColumnValueFromNode("add_date", detailNode);
						addterm = genericUtility.getColumnValueFromNode("add_term", detailNode);
						//chguser = genericUtility.getColumnValueFromNode("chg_user", detailNode);
						chguser = userInfo.getLoginCode();
						//chgdate= genericUtility.getColumnValueFromNode("chg_date", detailNode);
						//chgterm= genericUtility.getColumnValueFromNode("chg_term", detailNode);
						chgterm = userInfo.getRemoteHost();
						taxregno  = genericUtility.getColumnValueFromNode("tax_reg_no", detailNode);
						recostatus= genericUtility.getColumnValueFromNode("reco_status", detailNode);
						ecomregno= genericUtility.getColumnValueFromNode("ecom_reg_no", detailNode);
						refser= genericUtility.getColumnValueFromNode("ref_ser", detailNode);
						gstcode= genericUtility.getColumnValueFromNode("gst_code", detailNode);
						gsttype= genericUtility.getColumnValueFromNode("gst_type", detailNode);
						refid= genericUtility.getColumnValueFromNode("ref_id", detailNode);

						sql = "Insert into gst_data_hdr (TRAN_ID,TRAN_DATE,TRAN_ID__REF,SITE_CODE,PRD_CODE,REC_TYPE,TRAN_TYPE,CUST_CODE,CUST_NAME,SUBMISSION_TYPE,DOC_CHECKSUM,DOC_TYPE,DOC_NO,DOC_DATE,AMOUNT,REVERSE_CHRG,LR_NO,LR_DATE,REAS_CODE,REF_ID__INV,REF_DATE__INV,PROV_ASSMNT,ORDER_NO,ORDER_DATE,REMARKS,SUBMIT_STATUS,SUBMIT_DATE,ADD_USER,ADD_DATE,ADD_TERM,CHG_USER,CHG_DATE,CHG_TERM,TAX_REG_NO,RECO_STATUS,ECOM_REG_NO,REF_SER,GST_CODE,GST_TYPE,REF_ID) "
								+ "values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,tranid); //TRAN_ID         NOT NULL CHAR(12)  
						pstmt.setTimestamp(2,getTimeStamp(trandate)); //TRAN_DATE    DATE
						pstmt.setString(3,tranidref); //TRAN_ID__REF             CHAR(12)      
						pstmt.setString(4,sitecode); //SITE_CODE                CHAR(5)       
						pstmt.setString(5,prdcode); //PRD_CODE                 CHAR(6)       
						pstmt.setString(6,rectype); //REC_TYPE                 CHAR(1)       
						pstmt.setString(7,trantype); //TRAN_TYPE                CHAR(2)       
						pstmt.setString(8,custcode); //CUST_CODE                CHAR(10)      
						pstmt.setString(9,custname); //CUST_NAME                VARCHAR2(90)  
						pstmt.setString(10,submissiontype); //SUBMISSION_TYPE          CHAR(1)       
						pstmt.setString(11,docchecksum); //DOC_CHECKSUM             VARCHAR2(100) 
						pstmt.setString(12,doctype); //DOC_TYPE                 CHAR(5)       
						pstmt.setString(13,docno); //DOC_NO                   VARCHAR2(50)  
						pstmt.setTimestamp(14,getTimeStamp(docdate)); //DOC_DATE                 DATE          
						pstmt.setDouble(15,getDouble(amount)); //AMOUNT                   NUMBER(15,2)  
						pstmt.setString(16,reversechrg); //REVERSE_CHRG             CHAR(1)       
						pstmt.setString(17,lrno); //LR_NO                    VARCHAR2(50)  
						pstmt.setTimestamp(18,getTimeStamp(lrdate)); //LR_DATE                  DATE          
						pstmt.setString(19,reascode); //REAS_CODE                VARCHAR2(50)  
						pstmt.setString(20,refidinv); //REF_ID__INV              VARCHAR2(50)  
						pstmt.setTimestamp(21,getTimeStamp(refdateinv)); //REF_DATE__INV            DATE          
						pstmt.setString(22,provassmnt); //PROV_ASSMNT              CHAR(1)       
						pstmt.setString(23,orderno); //ORDER_NO                 VARCHAR2(30)  
						pstmt.setTimestamp(24,getTimeStamp(orderdate)); //ORDER_DATE               DATE          
						pstmt.setString(25,remarks); //REMARKS                  VARCHAR2(100) 
						pstmt.setString(26,submitstatus); //SUBMIT_STATUS            CHAR(1)       
						pstmt.setTimestamp(27,getTimeStamp(submitdate)); //SUBMIT_DATE              DATE          
						pstmt.setString(28,adduser); //ADD_USER                 CHAR(10)      
						pstmt.setTimestamp(29,getTimeStamp(adddate)); //ADD_DATE                 DATE          
						pstmt.setString(30,addterm); //ADD_TERM                 VARCHAR2(15)  
						pstmt.setString(31,chguser); //CHG_USER                 CHAR(10)      
						pstmt.setTimestamp(32,new java.sql.Timestamp(System.currentTimeMillis())); //CHG_DATE                 DATE          
						pstmt.setString(33,chgterm); //CHG_TERM                 VARCHAR2(15)  
						pstmt.setString(34,taxregno); //TAX_REG_NO               VARCHAR2(15)  
						pstmt.setString(35,recostatus); //RECO_STATUS              VARCHAR2(1)   
						pstmt.setString(36,ecomregno); //ECOM_REG_NO              VARCHAR2(15)  
						pstmt.setString(37,refser); //REF_SER                  CHAR(6)       
						pstmt.setString(38,gstcode); //GST_CODE                 CHAR(2)       
						pstmt.setString(39,gsttype); //GST_TYPE                 CHAR(1)       
						pstmt.setString(40,refid); //REF_ID                   CHAR(10)

						pstmt.executeUpdate();
						if(pstmt != null)
						{
							pstmt.close(); 
							pstmt = null;
						}
						retXmlString = retXmlString + "<tran_id>"+tranid+"</tran_id>";
					}
					else if(detailNode.getNodeName().equalsIgnoreCase("detail2"))
					{
						status = null; srnoold = null; linetype = null; gscode = null; 
						taxableamt = null; igstperc = null; igstamt = null; cgstperc = null; cgstamt = null; sgstperc = null; sgstamt = null; gsdescr = null; 
						unit = null; quantity = null; supplytype = null; cessperc = null; cessamt = null; remarksDet = null; itctype = null; itcigst = null; 
						itccgst = null; itcsgst = null; itccess = null; gstrate = null;
						
						lineno++;    
						status = genericUtility.getColumnValueFromNode("status", detailNode);    
						srnoold = genericUtility.getColumnValueFromNode("sr_no__old", detailNode);    
						linetype = genericUtility.getColumnValueFromNode("line_type", detailNode);    
						gscode = genericUtility.getColumnValueFromNode("gs_code", detailNode);    
						taxableamt = genericUtility.getColumnValueFromNode("taxable_amt", detailNode);    
						igstperc = genericUtility.getColumnValueFromNode("igst_perc", detailNode);    
						igstamt = genericUtility.getColumnValueFromNode("igst_amt", detailNode);    
						cgstperc = genericUtility.getColumnValueFromNode("cgst_perc", detailNode);    
						cgstamt = genericUtility.getColumnValueFromNode("cgst_amt", detailNode);    
						sgstperc = genericUtility.getColumnValueFromNode("sgst_perc", detailNode);    
						sgstamt = genericUtility.getColumnValueFromNode("sgst_amt", detailNode);    
						gsdescr = genericUtility.getColumnValueFromNode("gs_descr", detailNode);    
						unit = genericUtility.getColumnValueFromNode("unit", detailNode);    
						quantity = genericUtility.getColumnValueFromNode("quantity", detailNode);    
						supplytype = genericUtility.getColumnValueFromNode("supply_type", detailNode);    
						cessperc = genericUtility.getColumnValueFromNode("cess_perc", detailNode);    
						cessamt = genericUtility.getColumnValueFromNode("cess_amt", detailNode);    
						remarksDet = genericUtility.getColumnValueFromNode("remarks", detailNode);    
						itctype = genericUtility.getColumnValueFromNode("itc_type", detailNode);    
						itcigst = genericUtility.getColumnValueFromNode("itc_igst", detailNode);    
						itccgst = genericUtility.getColumnValueFromNode("itc_cgst", detailNode);    
						itcsgst = genericUtility.getColumnValueFromNode("itc_sgst", detailNode);    
						itccess = genericUtility.getColumnValueFromNode("itc_cess", detailNode);    
						gstrate = genericUtility.getColumnValueFromNode("gst_rate", detailNode);
						
												
						sql = "insert into gst_data_det(TRAN_ID,LINE_NO,STATUS,SR_NO__OLD,LINE_TYPE,GS_CODE,TAXABLE_AMT,IGST_PERC,IGST_AMT,"
								+ "CGST_PERC,CGST_AMT,SGST_PERC,SGST_AMT,GS_DESCR,UNIT,QUANTITY,SUPPLY_TYPE,CESS_PERC,CESS_AMT,REMARKS,ITC_TYPE,"
								+ "ITC_IGST,ITC_CGST,ITC_SGST,ITC_CESS,GST_RATE)	values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
						//Insert INTO GST_DATA_DET Table....
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,tranid); 				//TRAN_ID     NOT NULL CHAR(12)     
						pstmt.setInt(2,lineno); 				//LINENO     NOT NULL NUMBER(3)    
						pstmt.setString(3,status); 				//STATUS               CHAR(1)      
						pstmt.setString(4,srnoold); 			//SRNOOLD           NUMBER(3)    
						pstmt.setString(5,linetype); 			//LINETYPE            CHAR(1)      
						pstmt.setString(6,gscode); 				//GSCODE              VARCHAR2(10) 
						pstmt.setDouble(7,getDouble(taxableamt));//TAXABLEAMT          NUMBER(15,2) 
						pstmt.setDouble(8,getDouble(igstperc)); //IGSTPERC            NUMBER(5,2)  
						pstmt.setDouble(9,getDouble(igstamt)); 	//IGSTAMT             NUMBER(15,2) 
						pstmt.setDouble(10,getDouble(cgstperc));//CGSTPERC            NUMBER(5,2)  
						pstmt.setDouble(11,getDouble(cgstamt)); //CGSTAMT             NUMBER(15,2) 
						pstmt.setDouble(12,getDouble(sgstperc));//SGSTPERC            NUMBER(5,2)  
						pstmt.setDouble(13,getDouble(sgstamt)); //SGSTAMT             NUMBER(15,2) 
						pstmt.setString(14,gsdescr); 			//GSDESCR             VARCHAR2(30) 
						pstmt.setString(15,unit); 				//UNIT                 VARCHAR2(30) 
						pstmt.setDouble(16,getDouble(quantity)); //QUANTITY             NUMBER(15,3) 
						pstmt.setString(17,supplytype); 		//SUPPLYTYPE          CHAR(2)      
						pstmt.setDouble(18,getDouble(cessperc)); //CESSPERC            NUMBER(15,2) 
						pstmt.setDouble(19,getDouble(cessamt)); //CESSAMT             NUMBER(15,2) 
						pstmt.setString(20,remarksDet); 			//REMARKS              VARCHAR2(10) 
						pstmt.setString(21,itctype); 			//ITCTYPE             CHAR(2)      
						pstmt.setDouble(22,getDouble(itcigst)); //ITCIGST             NUMBER(15,3) 
						pstmt.setDouble(23,getDouble(itccgst)); //ITCCGST             NUMBER(15,3) 
						pstmt.setDouble(24,getDouble(itcsgst)); //	ITCSGST             NUMBER(15,3) 
						pstmt.setDouble(25,getDouble(itccess)); //	ITCCESS             NUMBER(15,3) 
						pstmt.setDouble(26,getDouble(gstrate)); //GSTRATE             NUMBER(5,2)  
						pstmt.executeUpdate();
						if(pstmt != null)
						{
							pstmt.close(); 
							pstmt = null;
						}
						totalAmount = totalAmount + getDouble(igstamt) + getDouble(cgstamt) + getDouble(sgstamt) + getDouble(cessamt) + getDouble(taxableamt);
					}
				}
				if(("gstr_purc".equalsIgnoreCase(objName) && "V".equalsIgnoreCase(gsttype)) || ("gstr3b".equalsIgnoreCase(objName) && "O".equalsIgnoreCase(gsttype)))
				{
					sql = "UPDATE GST_DATA_HDR SET AMOUNT = ? WHERE TRAN_ID = ?"; 
					pstmt = conn.prepareStatement(sql);
					pstmt.setDouble(1, totalAmount);
					pstmt.setString(2, tranid);
					int rowsUpdated = pstmt.executeUpdate();
					if(rowsUpdated == 0)
					{
						System.out.println("Record not found.......");
					}
					if(pstmt != null)
					{
						pstmt.close(); 
						pstmt = null;
					}
				}
			}


			retXmlString = retXmlString + "</root>";

			if(isErrorExist)
			{
				conn.rollback();
				retXmlString = errString;
			}
			else
			{
				conn.commit();	
			}

		}catch (Exception e) 
		{
			try 
			{
				conn.rollback();
			} catch (SQLException e1) 
			{
				e1.printStackTrace();
			}
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally 
		{
			
			if(isErrorExist)
			{
				try 
				{
					conn.rollback();
				} catch (SQLException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				retXmlString = errString;
			}
			else
			{
				try 
				{
					conn.commit();
				} catch (SQLException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}	
			}
			try 
			{
				conn.close();
			} catch (SQLException e) 
			{
				e.printStackTrace();
			}
		}
		System.out.println("Return Xml String:"+retXmlString);
		return retXmlString;
	}
	
	
	@Override
	public String updateRecord(String objName,String tranXml,String gstType, UserInfoBean userInfo) throws RemoteException, ITMException 
	{
		Connection conn = null;
		String sql = "";
		PreparedStatement pstmt = null;
		Document tranDoc = null;
		NodeList detailNodeList = null;
		String retXmlString = "<root>";
		String errString = "";
		boolean isErrorExist = false;
	
		String tranid = null,trantype = null,amount= null;
		
		
		String lineno = null, status = null, srnoold = null, linetype = null, gscode = null, 
				taxableamt = null, igstperc = null, igstamt = null, cgstperc = null, cgstamt = null, sgstperc = null, sgstamt = null, gsdescr = null, 
				unit = null, quantity = null, supplytype = null, cessperc = null, cessamt = null, remarksDet = null, itctype = null, itcigst = null, 
				itccgst = null, itcsgst = null, itccess = null, gstrate = null;
		
		try
		{	
			System.out.println("===================Inside GstrCustomTranEJB class========================");
			if(conn == null || conn.isClosed())
			{
				System.out.println("@@Connection is null");
				conn = getConnection();
			}
			tranDoc = genericUtility.parseString(tranXml);
			detailNodeList = tranDoc.getElementsByTagName("Detail");
			
			for(int i = 0; i < detailNodeList.getLength() && !isErrorExist; i++)
			{
				Double totalAmount = 0.00;
				Node detailNodePatent = detailNodeList.item(i);
				for(int detCntr = 0; detCntr < detailNodePatent.getChildNodes().getLength(); detCntr++)
				{
					Node detailNode = detailNodePatent.getChildNodes().item(detCntr);

					if(detailNode.getNodeName().equalsIgnoreCase("detail1"))
					{
						tranid = null;trantype = null;amount= null;
		
						tranid = genericUtility.getColumnValueFromNode("tran_id", detailNode);
						trantype = genericUtility.getColumnValueFromNode("tran_type", detailNode);
						amount= genericUtility.getColumnValueFromNode("amount", detailNode);
										
						sql = "UPDATE GST_DATA_HDR SET AMOUNT = ? WHERE TRAN_ID = ? AND TRAN_TYPE = ?"; 
						pstmt = conn.prepareStatement(sql);
						pstmt.setDouble(1, getDouble(amount));
						pstmt.setString(2, tranid);
						pstmt.setString(3, trantype);
		
						int rowsUpdated = pstmt.executeUpdate();
						if(rowsUpdated == 0)
						{
							System.out.println("Record not found.......");
						}
						if(pstmt != null)
						{
							pstmt.close(); 
							pstmt = null;
						}
					}
					else if(detailNode.getNodeName().equalsIgnoreCase("detail2"))
					{
						status = null; srnoold = null; linetype = null; gscode = null; 
						taxableamt = null; igstperc = null; igstamt = null; cgstperc = null; cgstamt = null; sgstperc = null; sgstamt = null; gsdescr = null; 
						unit = null; quantity = null; supplytype = null; cessperc = null; cessamt = null; remarksDet = null; itctype = null; itcigst = null; 
						itccgst = null; itcsgst = null; itccess = null; gstrate = null;
						
						tranid = null;
						tranid = genericUtility.getColumnValueFromNode("tran_id", detailNode);
						lineno = genericUtility.getColumnValueFromNode("line_no", detailNode);    
						status = genericUtility.getColumnValueFromNode("status", detailNode);    
						srnoold = genericUtility.getColumnValueFromNode("sr_no__old", detailNode);    
						linetype = genericUtility.getColumnValueFromNode("line_type", detailNode);    
						gscode = genericUtility.getColumnValueFromNode("gs_code", detailNode);    
						taxableamt = genericUtility.getColumnValueFromNode("taxable_amt", detailNode);    
						igstperc = genericUtility.getColumnValueFromNode("igst_perc", detailNode);    
						igstamt = genericUtility.getColumnValueFromNode("igst_amt", detailNode);    
						cgstperc = genericUtility.getColumnValueFromNode("cgst_perc", detailNode);    
						cgstamt = genericUtility.getColumnValueFromNode("cgst_amt", detailNode);    
						sgstperc = genericUtility.getColumnValueFromNode("sgst_perc", detailNode);    
						sgstamt = genericUtility.getColumnValueFromNode("sgst_amt", detailNode);    
						gsdescr = genericUtility.getColumnValueFromNode("gs_descr", detailNode);    
						unit = genericUtility.getColumnValueFromNode("unit", detailNode);    
						quantity = genericUtility.getColumnValueFromNode("quantity", detailNode);    
						supplytype = genericUtility.getColumnValueFromNode("supply_type", detailNode);    
						cessperc = genericUtility.getColumnValueFromNode("cess_perc", detailNode);    
						cessamt = genericUtility.getColumnValueFromNode("cess_amt", detailNode);    
						remarksDet = genericUtility.getColumnValueFromNode("remarks", detailNode);    
						itctype = genericUtility.getColumnValueFromNode("itc_type", detailNode);    
						itcigst = genericUtility.getColumnValueFromNode("itc_igst", detailNode);    
						itccgst = genericUtility.getColumnValueFromNode("itc_cgst", detailNode);    
						itcsgst = genericUtility.getColumnValueFromNode("itc_sgst", detailNode);    
						itccess = genericUtility.getColumnValueFromNode("itc_cess", detailNode);    
						gstrate = genericUtility.getColumnValueFromNode("gst_rate", detailNode);;
						
						sql = "UPDATE GST_DATA_DET SET IGST_AMT = ? ,CGST_AMT = ? ,SGST_AMT = ?,CESS_AMT = ?,TAXABLE_AMT = ? WHERE TRAN_ID = ? AND LINE_NO = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setDouble(1, getDouble(igstamt));
						pstmt.setDouble(2, getDouble(cgstamt));
						pstmt.setDouble(3, getDouble(sgstamt));
						pstmt.setDouble(4, getDouble(cessamt));
						pstmt.setDouble(5, getDouble(taxableamt));
						
						pstmt.setString(6, tranid);
						pstmt.setString(7, lineno);
		
						int rowsUpdated = pstmt.executeUpdate();
						if(rowsUpdated == 0)
						{
							System.out.println("Record not found.......");
						}
						if(pstmt != null)
						{
							pstmt.close(); 
							pstmt = null;
						}
						totalAmount = totalAmount + getDouble(igstamt) + getDouble(cgstamt) + getDouble(sgstamt) + getDouble(cessamt) + getDouble(taxableamt);
					}
				}
				if(("gstr_purc".equalsIgnoreCase(objName) && "V".equalsIgnoreCase(gstType)) || ("gstr3b".equalsIgnoreCase(objName) && "O".equalsIgnoreCase(gstType)))
				{
					sql = "UPDATE GST_DATA_HDR SET AMOUNT = ? WHERE TRAN_ID = ?"; 
					pstmt = conn.prepareStatement(sql);
					pstmt.setDouble(1, totalAmount);
					pstmt.setString(2, tranid);
					int rowsUpdated = pstmt.executeUpdate();
					if(rowsUpdated == 0)
					{
						System.out.println("Record not found.......");
					}
					if(pstmt != null)
					{
						pstmt.close(); 
						pstmt = null;
					}
				}
				retXmlString = retXmlString + "<tran_id>"+tranid+"</tran_id>";
			}
			retXmlString = retXmlString + "</root>";
			
			if(isErrorExist)
			{
				conn.rollback();
				retXmlString = errString;
			}
			else
			{
				conn.commit();	
			}
			
		}catch (Exception e) 
		{
			try 
			{
				conn.rollback();
			} catch (SQLException e1) 
			{
				e1.printStackTrace();
			}
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally 
		{
			
			if(isErrorExist)
			{
				try 
				{
					conn.rollback();
				} catch (SQLException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				retXmlString = errString;
			}
			else
			{
				try 
				{
					conn.commit();
				} catch (SQLException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}	
			}
			try 
			{
				conn.close();
			} catch (SQLException e) 
			{
				e.printStackTrace();
			}
		}
		System.out.println("Return Xml String:"+retXmlString);
		return retXmlString;
	}
	
	private double getDouble(String amount) 
	{
		double result = 0.0;
		result = Double.parseDouble((amount==null||amount.equals("")) ? "0" : amount);
		return result;
	}
	@Override
	public String getRecords(String objName,String prdCode,String gstType, UserInfoBean userInfo) throws RemoteException, ITMException 
	{
		Connection conn = null;
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pstmtDet = null;
		ResultSet rsDet = null;
		String retXmlString = "<root>";
		
		try
		{	
			System.out.println("===================Inside GstrCustomTranEJB class========================");
			if(conn == null || conn.isClosed())
			{
				System.out.println("@@Connection is null");
				conn = getConnection();
			}
			
			sql = "select tran_type,tran_id,amount from gst_data_hdr where gst_type = ? and prd_code = ? and rec_type = ?";
			pstmt =  conn.prepareStatement(sql);
			pstmt.setString(1, gstType);
			pstmt.setString(2, prdCode);
			if(objName != null && objName.equalsIgnoreCase("gstr"))
			{
				pstmt.setString(3, "1");
			}
			else if(objName != null && objName.equalsIgnoreCase("gstr_purc"))
			{
				pstmt.setString(3, "2");
			}
			else if(objName != null && objName.equalsIgnoreCase("gstr3b"))
			{
				pstmt.setString(3, "6");
			}
						
			rs = pstmt.executeQuery();
			System.out.println(rs.getFetchSize());
			while(rs.next())
			{
				retXmlString = retXmlString + "<detail tran_type='"+rs.getString("tran_type")+"' >";
				retXmlString = retXmlString + "<detail1>";
				retXmlString = retXmlString + "<tran_id>"+rs.getString("tran_id")+"</tran_id>";
				retXmlString = retXmlString + "<tran_type>"+rs.getString("tran_type")+"</tran_type>";
				retXmlString = retXmlString + "<amount>"+rs.getDouble("amount")+"</amount>";
				retXmlString = retXmlString + "</detail1>";
				
				sql = "select igst_amt, cgst_amt, sgst_amt, cess_amt, tran_id, line_no, taxable_amt from gst_data_det where tran_id = ?";
				pstmtDet =  conn.prepareStatement(sql);
				pstmtDet.setString(1, rs.getString("tran_id"));
				rsDet = pstmtDet.executeQuery();
				System.out.println(rs.getFetchSize());
				while(rsDet.next())
				{
					retXmlString = retXmlString + "<detail2>";
					retXmlString = retXmlString + "<tran_id>"+rsDet.getString("tran_id")+"</tran_id>";
					retXmlString = retXmlString + "<line_no>"+rsDet.getString("line_no")+"</line_no>";
					retXmlString = retXmlString + "<igst_amt>"+rsDet.getDouble("igst_amt")+"</igst_amt>";
					retXmlString = retXmlString + "<cgst_amt>"+rsDet.getDouble("cgst_amt")+"</cgst_amt>";
					retXmlString = retXmlString + "<sgst_amt>"+rsDet.getDouble("sgst_amt")+"</sgst_amt>";
					retXmlString = retXmlString + "<cess_amt>"+rsDet.getDouble("cess_amt")+"</cess_amt>";
					retXmlString = retXmlString + "<taxable_amt>"+rsDet.getDouble("taxable_amt")+"</taxable_amt>";
					retXmlString = retXmlString + "</detail2>";
				}
				retXmlString = retXmlString + "</detail>";
			}
			retXmlString = retXmlString + "</root>";
			
		}catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally 
		{
			try 
			{
				conn.close();
			} catch (SQLException e) 
			{
				e.printStackTrace();
			}
		}
		System.out.println("Return Xml String:"+retXmlString);
		return retXmlString;
	}
	
	private Timestamp getTimeStamp(String dateStr) throws ITMException, Exception 
	{
		String dbDateStr = "";
		if(dateStr != null && !dateStr.equals(""))
		{
			dbDateStr =	(new E12GenericUtility()).getValidDateTimeString(dateStr, (new E12GenericUtility()).getApplDateTimeFormat(), (new E12GenericUtility()).getDBDateTimeFormat());
			return java.sql.Timestamp.valueOf(dbDateStr);          
		}
		else
		{
			return null;
		}
	}		
	
//<prd_code/><rec_type/><tran_type/><cust_code/><cust_name/><submission_type/><doc_checksum/><doc_type>R</doc_type><amount/><reverse_chrg>N</reverse_chrg><lr_no/><lr_date/><ref_id__inv/><ref_date__inv/><prov_assmnt>Y</prov_assmnt><order_no/><order_date/><remarks/><submit_status>P</submit_status><submit_date/><add_user/><add_date/><add_term/><chg_user/><chg_date/><chg_term/><tax_reg_no/><tran_date/><reco_status/><doc_no/><doc_date/><doc_no_old/><doc_date_1/><amount_1/><gst_code_state/><site_code/><site_descr/><reco_status_descr/><tran_type_descr/><rec_type_descr/><state_descr/><ecom_reg_no/><gst_code/><name/><addr1/><addr2/><addr3/><city/><gst_state_code/><pin/><tran_id/><tran_id__ref/><gst_type/><gst_type_descr/><doc_type_descr/><reas_code/></Detail1></Header0></group0></DocumentRoot>
}
