package ibase.dashboard.sfa.servlet;
import ibase.dashboard.sfa.ejb.RSRScoreRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;

import java.io.IOException;
import java.io.OutputStream;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.json.simple.JSONObject;

@SuppressWarnings("serial")
public class RSRScoreServlet extends HttpServlet
{
	//private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		System.out.println("inside RSRScoreServlet  servlet");
		RSRScoreRemote rsrScoreRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		String loginId = "";
		String salesPerson = "";
		String year="";
		String month="";
		String reportName="";
		
		try
		{
			
			response.setContentType("application/xml");
			
			HttpSession session = request.getSession(true);
			ibase.utility.UserInfoBean userInfo = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");
			loginId     = userInfo.getLoginCode();           
            
			dataSourceName    = request.getParameter("dataSourceName"); 
			
			salesPerson 	  = (request.getParameter("salesperson"));
			month 			  = (request.getParameter("month"));
			year 			  = (request.getParameter("year"));
			reportName    	  = request.getParameter("reportName"); 
			reportName        = reportName +"-"+ month +"-"+ year ;
			session.setAttribute("reportName", reportName);
			
			//System.out.println("in doPost=" + " loging Id comming from session == " + loginId );
			System.out.println( "salesPerson is =" + salesPerson );
			System.out.println( "month is =" + month );
			System.out.println("year is =" + year );
			System.out.println("loginId--"+loginId);
			System.out.println("reportName is =" + reportName );
			context = new InitialContext(appConnectParm.getProperty());
			rsrScoreRemote = (RSRScoreRemote)context.lookup("ibase/RSRScoreEJB/remote");
			JSONObject jsonObjData      = (JSONObject)rsrScoreRemote.getRSRScoreDetails(salesPerson,month,year,dataSourceName);
			OutputStream outputStream   = response.getOutputStream();			
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Output Result in RSRScoreServlet===" + jsonObjData);	
			
		} catch (Exception e)
		{
			System.out.println("Exception : RSRScoreServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
			  throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}

}