package ibase.webitm.ejb.adm.adv;

import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.adm.AdmCommon;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.ejb.fin.adv.PayIbcaConf;
import ibase.webitm.ejb.sys.CreateRCPXML;
import ibase.webitm.utility.TransIDGenerator;
import ibase.utility.CommonConstants;
import ibase.system.config.ConnDriver;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;

import org.w3c.dom.*;


@javax.ejb.Stateless
public class PayrollVoucherConf extends ActionHandlerEJB implements PayrollVoucherConfLocal, PayrollVoucherConfRemote
{
	public String confirm(String tranId, String xtraParams) throws RemoteException,ITMException
	{
		
		String retString = "";
		try
		{
			
			retString = confirm( tranId, "N", xtraParams);		
		
		}
		catch(Exception e)
		{
			System.out.println("Exception :PayrollVoucherConf :confirm(String tranId, String xtraParams):" + e.getMessage() + ":");
			retString = GenericUtility.getInstance().createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
		}
		System.out.println("Returning Result from PayrollVoucherConf :confirm(String tranId, String xtraParams) ::"+retString);
		return retString;
	}
	public String confirm(String tranId, String xtraParams, Connection conn) throws RemoteException,ITMException
	{
		
		String retString = "";
		try
		{
			
			retString = confirm( tranId, "N", xtraParams, conn);		
		
		}
		catch(Exception e)
		{
			System.out.println("Exception :PayrollVoucherConf :confirm(String tranId, String xtraParams, Connection conn):" + e.getMessage() + ":");
			retString = GenericUtility.getInstance().createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
		}
		System.out.println("Returning Result from PayrollVoucherConf :confirm(String tranId, String xtraParams, Connection conn) ::"+retString);
		return retString;
	}
 	public String confirm(String tranId, String forcedFlag, String xtraParams) throws RemoteException,ITMException
	{
		
		String retString = "";
		Connection conn = null;
		ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();		
		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverValidator");
			conn.setAutoCommit(false);		
			retString = confirm( tranId, forcedFlag, xtraParams, conn);	
			if (retString == null || retString.trim().length() == 0)
			{
				conn.commit();
				retString = "VTMCONF2";
				retString = itmDBAccess.getErrorString("",retString,"","",conn);
				return retString;
			}
			else
			{
				conn.rollback();
			}
		}
		catch(SQLException sqle)
		{
			System.out.println("Exception :PayrollVoucherConf :confirm(String tranId, String forcedFlag, String xtraParams):" + sqle.getMessage() + ":");
			retString = GenericUtility.getInstance().createErrorString(sqle);
			sqle.printStackTrace();
			throw new ITMException(sqle);
		}
		catch(Exception e)
		{
			try
			{
				conn.rollback();
			}
			catch (Exception re)
			{
				System.out.println("Exception :PayrollVoucherConf :confirm(String tranId, String forcedFlag, String xtraParams):" + re.getMessage() + ":");
			}
			System.out.println("Exception :PayrollVoucherConf :confirm(String tranId, String forcedFlag, String xtraParams):" + e.getMessage() + ":");
			retString = GenericUtility.getInstance().createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn!=null)
				{
					conn.close();
					conn=null;
				}
							
			}
			catch(Exception e1)
			{
				System.out.println(e1.getMessage());
				e1.printStackTrace();
				
			}
		}
		System.out.println("Returning Result from PayrollVoucherConf :confirm(String tranId, String forcedFlag, String xtraParams) ::"+retString);
		return retString;
	}

	public String confirm(String tranId, String forcedFlag, String xtraParams,  Connection conn) throws RemoteException,ITMException
	{
		
		String retString = "";
		String tranType = "";
		String batchNo = "";
		String siteAc = "";
		String confirmed = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;	
		try
		{
			String sql = "SELECT V.CONFIRMED AS CONFIRMED,V.TRAN_TYPE AS TRAN_TYPE, V.ENTRY_BATCH_NO AS ENTRY_BATCH_NO, CASE WHEN S.SITE_CODE__ACCT IS NULL THEN S.SITE_CODE ELSE S.SITE_CODE__ACCT END AS SITE_CODE FROM PAYR_VOUCHER V, SITE S WHERE V.TRAN_ID = ? AND S.SITE_CODE = V.SITE_CODE";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				confirmed = checkNull(rs.getString("CONFIRMED")==null ? "":rs.getString("CONFIRMED"));
				tranType = checkNull(rs.getString("TRAN_TYPE")==null ? "":rs.getString("TRAN_TYPE"));
				batchNo = checkNull(rs.getString("ENTRY_BATCH_NO")==null ? "":rs.getString("ENTRY_BATCH_NO"));
				siteAc = checkNull(rs.getString("SITE_CODE")==null ? "":rs.getString("SITE_CODE"));
			}	
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if (confirmed == null || !confirmed.equalsIgnoreCase("Y"))
			{
				retString = gbfRetrievePayrVoucher( tranId, tranType, tranType, batchNo, siteAc, forcedFlag, xtraParams, conn);		
			}
		
		}
		catch(SQLException sqle)
		{
			System.out.println("Exception :PayrollVoucherConf :confirm(String tranId, String forcedFlag, String xtraParams,  Connection conn):" + sqle.getMessage() + ":");
			retString = GenericUtility.getInstance().createErrorString(sqle);
			sqle.printStackTrace();
			throw new ITMException(sqle);
		}
		catch(Exception e)
		{
			System.out.println("Exception :PayrollVoucherConf :confirm(String tranId, String forcedFlag, String xtraParams,  Connection conn):" + e.getMessage() + ":");
			retString = GenericUtility.getInstance().createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				
			}
			catch (Exception fe)
			{
				System.out.println("Exception :PayrollVoucherConf :confirm(String tranId, String forcedFlag, String xtraParams,  Connection conn):" + fe.getMessage() + ":");
			}
		}
		System.out.println("Returning Result from PayrollVoucherConf :confirm(String tranId, String forcedFlag, String xtraParams,  Connection conn) ::"+retString);
		return retString;
	}
	private String gbfRetrievePayrVoucher(String tranId,String tranTypeFr,String tranTypeTo,String batchNo,String siteCode,String forcedFlag, String xtraParams ,Connection conn) throws ITMException
	{
		String errString = "",sql = "" ;
		String tranType = "",rights = "",ledgPostConf = "";
		String userId = "";
		String loginEmpCode = "";
		String profileIdArg = "";
		String profileIdDb = "";
		String rightsChar = "";
		String itFlag = "";
		int recCount = 0 ;
		int userLevel = 0 ;
		double totalAmt = 0; 
		Date tranDate = null,today = new java.util.Date();
		HashMap payVouchHdr = null;
		HashMap payVouchDet = null;
		HashMap payVouchAdv = null;
		ArrayList payVouchDetList = new ArrayList();
		ArrayList payVouchAdvList = new ArrayList();
		PreparedStatement pstmt = null,pstmtUpd = null;
		ResultSet rs = null;
		try 
		{
			System.out.println("gbfRetrievePayrVoucher called........... ");
			ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
			GenericUtility genericUtility = GenericUtility.getInstance();

			userId = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode"));
			profileIdArg = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"profileId"));
			loginEmpCode  = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode"));
			sql = "SELECT USR_LEV , PROFILE_ID FROM USERS WHERE CODE = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, userId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				userLevel = rs.getInt("USR_LEV");
				profileIdDb = checkNull(rs.getString("PROFILE_ID"));
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			if (profileIdArg.trim().length() == 0)
			{
				if (profileIdDb.trim().length() > 0)
				{
					profileIdArg = profileIdDb;
				}
			}
			if (userLevel < 1)
			{
				rightsChar = "*,N";
			}
			else
			{
				if (profileIdArg.trim().length() > 0)
				{
					//Modified by santosh to cancel the Marital status to Unmarital status(10/4/17)
					//sql = "SELECT RIGHTS FROM USER_RIGHTS WHERE PROFILE_ID = ?
					sql = "SELECT RIGHTS FROM USER_RIGHTS WHERE PROFILE_ID = ? AND OBJ_NAME='payr_voucher'";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, profileIdArg);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						rightsChar = checkNull(rs.getString("RIGHTS"));
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
				}
			}
			if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
			{
				sql = "SELECT TRAN_ID, TRAN_TYPE, TOT_AMT 	FROM PAYR_VOUCHER 	WHERE TRAN_ID = ? FOR UPDATE ";
			}

			else if ( "mssql".equalsIgnoreCase(CommonConstants.DB_NAME ))
			{
				sql = " SELECT TRAN_ID, TRAN_TYPE, TOT_AMT 	FROM PAYR_VOUCHER (UPDLOCK) WHERE TRAN_ID =  ?   " ;
			}
			else
			{
				sql =" SELECT TRAN_ID, TRAN_TYPE, TOT_AMT FROM PAYR_VOUCHER WHERE TRAN_ID = ? FOR UPDATE NOWAIT " ;
			}
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				tranId = checkNull(rs.getString("tran_id"));
				tranType = checkNull(rs.getString("tran_type"));
				totalAmt = rs.getDouble("tot_amt");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			if(!"PAY".equalsIgnoreCase(tranType.trim()) && !"ARR".equalsIgnoreCase(tranType.trim()) && !"LN".equalsIgnoreCase(tranType.trim()) && !"PRK".equalsIgnoreCase(tranType.trim()) && !"LEN".equalsIgnoreCase(tranType.trim()) && !"FFS".equalsIgnoreCase(tranType.trim()) && !"INC".equalsIgnoreCase(tranType.trim()))
			{
				if(totalAmt == 0)
				{
					recCount = 0;
					sql = "SELECT COUNT(*) FROM PAYR_VOUCHDET  WHERE TRAN_ID = ? 	AND AMOUNT <> 0";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, tranId);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						recCount = rs.getInt(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					if(recCount == 0)
					{
						errString = itmDBAccess.getErrorString("","VTVOUAMT","","",conn);
						return errString;
					}
				}
				else if(totalAmt < 0) 
				{

					if(rightsChar.indexOf("N") == -1)
					{
						errString = itmDBAccess.getErrorString("","VTVOUAMT","","",conn);
						return errString;
					}
				}
			}
			double hdrExchRate = 0d;
			double totDetAmt = 0d;
			double totAmtBc = 0d;

			sql = "   SELECT TRAN_ID,TRAN_DATE,TRAN_TYPE,EFF_DATE,EMP_CODE,REF_NO,REF_DATE,BANK_CODE,"
					+"AUTO_PAY,CHG_DATE,CHG_USER,CHG_TERM,SITE_CODE,FIN_ENTITY,TOT_AMT,ANAL_CODE,CONFIRMED,"
					+"PAID,ACCT_CODE__PAY,CCTR_CODE__PAY, VOUCH_TYPE,CURR_CODE,EXCH_RATE,ENTRY_BATCH_NO,TOT_AMT__BC,"+
					"REMARKS,PAY_MODE,CONF_DATE,EMP_CODE__APRV,HOLD, IT_FLAG  FROM PAYR_VOUCHER WHERE  TRAN_ID = ?  ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				payVouchHdr = new HashMap();
				payVouchHdr.put("tran_id",rs.getString("tran_id"));
				payVouchHdr.put("tran_type",rs.getString("tran_type"));
				payVouchHdr.put("tran_date",rs.getDate("tran_date"));
				payVouchHdr.put("eff_date",rs.getDate("eff_date"));
				payVouchHdr.put("ref_date",rs.getDate("ref_date"));
				payVouchHdr.put("emp_code",rs.getString("emp_code"));
				payVouchHdr.put("ref_no",rs.getString("ref_no"));
				payVouchHdr.put("bank_code",rs.getString("bank_code"));
				payVouchHdr.put("auto_pay",rs.getString("auto_pay"));
				payVouchHdr.put("chg_date",rs.getDate("chg_date"));
				payVouchHdr.put("chg_user",rs.getString("chg_user"));
				payVouchHdr.put("chg_term",rs.getString("chg_term"));
				payVouchHdr.put("site_code",rs.getString("site_code"));
				payVouchHdr.put("fin_entity",rs.getString("fin_entity"));
				payVouchHdr.put("tot_amt",rs.getDouble("tot_amt"));
				payVouchHdr.put("anal_code",rs.getString("anal_code"));
				payVouchHdr.put("confirmed",rs.getString("confirmed"));
				payVouchHdr.put("paid",rs.getString("paid"));
				payVouchHdr.put("acct_code__pay",rs.getString("acct_code__pay"));
				payVouchHdr.put("cctr_code__pay",rs.getString("cctr_code__pay"));
				payVouchHdr.put("vouch_type",rs.getString("vouch_type"));
				payVouchHdr.put("curr_code",rs.getString("curr_code"));
				payVouchHdr.put("entry_batch_no",rs.getString("entry_batch_no"));
				payVouchHdr.put("exch_rate",rs.getDouble("exch_rate"));
				payVouchHdr.put("tot_amt__bc",rs.getDouble("tot_amt__bc"));
				payVouchHdr.put("tot_amt",rs.getDouble("tot_amt"));
				payVouchHdr.put("remarks",rs.getString("remarks"));
				payVouchHdr.put("pay_mode",rs.getString("pay_mode"));
				payVouchHdr.put("conf_date",rs.getDate("conf_date"));
				payVouchHdr.put("emp_code__aprv",rs.getString("emp_code__aprv"));
				payVouchHdr.put("hold",rs.getString("hold"));
				payVouchHdr.put("it_flag",rs.getString("it_flag"));

				System.out.println("payVouchHdr="+payVouchHdr);
				// Modified by Piyush on 01/06/2016 [To update amount in header]
				hdrExchRate = rs.getDouble("exch_rate");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			sql = "SELECT TRAN_ID,LINE_NO,ACCT_CODE,CCTR_CODE,AMOUNT,AD_CODE,ANAL_CODE FROM PAYR_VOUCHDET  WHERE TRAN_ID = ? ORDER BY LINE_NO";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				payVouchDet = new HashMap();
				payVouchDet.put("tran_id",rs.getString("tran_id"));
				payVouchDet.put("line_no",rs.getString("line_no"));
				payVouchDet.put("acct_code",rs.getString("acct_code"));
				payVouchDet.put("cctr_code",rs.getString("cctr_code"));
				payVouchDet.put("amount",rs.getDouble("amount"));
				payVouchDet.put("ad_code",rs.getString("ad_code"));
				payVouchDet.put("anal_code",rs.getString("anal_code"));
				System.out.println("payVouchDet ="+payVouchDet);
				payVouchDetList.add(payVouchDet);
				totDetAmt = totDetAmt + rs.getDouble("amount");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			sql = "SELECT TRAN_ID, REF_SER,REF_NO,ADJ_AMT,TOT_AMT,CURR_CODE,EXCH_RATE__VOUCH,"
					+"DIFF_AMT__EXCH,ACCT_CODE,CCTR_CODE FROM PAYR_VOUCHADV WHERE TRAN_ID = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				payVouchAdv = new HashMap();
				payVouchAdv.put("tran_id",rs.getString("tran_id"));
				payVouchAdv.put("ref_ser",rs.getString("ref_ser"));
				payVouchAdv.put("ref_no",rs.getString("ref_no"));
				payVouchAdv.put("curr_code",rs.getString("curr_code"));
				payVouchAdv.put("adj_amt",rs.getDouble("adj_amt"));
				payVouchAdv.put("tot_amt",rs.getDouble("tot_amt"));
				payVouchAdv.put("exch_rate__vouch",rs.getDouble("exch_rate__vouch"));
				payVouchAdv.put("diff_amt__exch",rs.getDouble("diff_amt__exch"));
				payVouchAdv.put("acct_code",rs.getString("acct_code"));
				payVouchAdv.put("cctr_code",rs.getString("cctr_code"));
				System.out.println("payVouchAdv ="+payVouchAdv);
				payVouchAdvList.add(payVouchAdv);
				totDetAmt = totDetAmt + rs.getDouble("adj_amt");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			totAmtBc = totDetAmt * hdrExchRate;
			sql = " UPDATE PAYR_VOUCHER SET TOT_AMT = ? , TOT_AMT__BC = ? WHERE TRAN_ID   = ? "; 
			pstmtUpd = conn.prepareStatement(sql);
			pstmtUpd.setDouble(1,totDetAmt);
			pstmtUpd.setDouble(2,totAmtBc);
			pstmtUpd.setString(3,tranId);
			int hdrTotUpd = pstmtUpd.executeUpdate();
			System.out.println("row update totals into payr_voucher ="+hdrTotUpd);
			pstmtUpd.close();
			pstmtUpd = null;
			payVouchHdr.put("tot_amt__bc",totAmtBc);
			payVouchHdr.put("tot_amt",totDetAmt);

			tranDate = (Date)payVouchHdr.get("tran_date");

			sql = "SELECT LEDG_POST_CONF FROM TRANSETUP WHERE UPPER(TRAN_WINDOW) = 'W_PAYR_VOUCHER' ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				ledgPostConf = checkNull(rs.getString("ledg_post_conf"));
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			if("Y".equalsIgnoreCase(ledgPostConf.trim()))
			{
				if(!today.equals(tranDate))
				{
					tranDate = today;
					sql = "UPDATE PAYR_VOUCHER SET TRAN_DATE = ? WHERE TRAN_ID = ? "; 
					pstmtUpd = conn.prepareStatement(sql);
					pstmtUpd.setDate(1,tranDate == null?null:new java.sql.Date(tranDate.getTime()) );
					pstmtUpd.setString(2,tranId);
					int i = pstmtUpd.executeUpdate();
					System.out.println("row update into payr_voucher ="+i);
					pstmtUpd.close();
					pstmtUpd = null;
				}
				payVouchHdr.put("tran_date",tranDate);

			}
			errString = gbfPostPayrVoucher(payVouchHdr,payVouchDetList,payVouchAdvList,xtraParams,conn);
			System.out.println("Returned from gbfPostPayrVoucher ["+errString+"]");
			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}

		} catch (SQLException sqle) 
		{

			System.out.println("Exception :PayrollVoucherConf :gbfRetrievePayrVoucher :SQLException :==>\n"+sqle.getMessage());
			sqle.printStackTrace();
			throw new ITMException(sqle);
		}
		catch (Exception e) 
		{

			System.out.println("Exception :PayrollVoucherConf :gbfRetrievePayrVoucher :Exception :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;					
				}	
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;					
				}	
				if(pstmtUpd != null)
				{
					pstmtUpd.close();
					pstmtUpd = null;					
				}	
							
			}
			catch(Exception fe)
			{
				System.out.println(fe.getMessage());
				fe.printStackTrace();
				
			}
		}
		return errString;
	}

	private String gbfPostPayrVoucher(HashMap payVouchHdr,ArrayList payVouchDetList,ArrayList payVouchAdvList,String xtraParams ,Connection conn) throws ITMException
	{
		String errString = "",sql = "" , userId = "", chgTerm = "";
		String empCode = "", loanNo = "", adCode = "", confirmed = "" ,transer ="" , refId = "" ,tranId = "" ,refType = "" ;
		String tranType = "",ledgPostConf = "",siteCode = "", siteCodePayment = "", finEntity = "",finEntityFr = "",finEntityTo = "";
		String linkType = "",acctCodePay = "",cctrCodePay = "",acctCodeRCP = "",cctrCodeRCP = "",keyString = "";
		String entryBatchNo = "",currCode = "",remarks = "",payMode = "",bankCode = "",acctCodeHdr = "",cctrCodeHdr = "" ;
		int lineNo = 0,recCount = 0 ;
		double advAmt = 0,billAmt = 0,totalAmt = 0,exchRate = 0,totalAmtBC = 0; 
		Date recoDate = null, startDate = null,  confDate = null ,refDate = null;
		Date tranDate = null,today = new java.util.Date();

		PreparedStatement pstmt = null,pstmtUpd = null,pstmtHdr = null,pstmtInner = null;
		ResultSet rs = null,rsHdr = null,rsInner = null;
		Timestamp currDate = null;
		GenericUtility genericUtility = null;
		FinCommon finCommon = new FinCommon();
		PayIbcaConf	payIbcaConf = new PayIbcaConf();
		try 
		{
			System.out.println("gbfPostPayrVoucher called........... ");
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
			genericUtility = GenericUtility.getInstance();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
			if(userId == null || userId.trim().length() == 0)
			{
				userId = "SYSTEM";
			}
			if(chgTerm == null || chgTerm.trim().length() == 0)
			{
				chgTerm = "SYSTEM";
			}
			System.out.println("userId::::"+userId);
			System.out.println("chgTerm::::"+chgTerm);
			System.out.println("payVouch Header = "+payVouchHdr);
			if(payVouchHdr == null)
			{
				errString = itmDBAccess.getErrorString("","VTIMP","","",conn);
				return errString;
			}
			else if(payVouchHdr.size() == 0)
			{
				errString = itmDBAccess.getErrorString("","VTIMPNOREC","","",conn);
				return errString;
			}
			tranDate = (Date)payVouchHdr.get("tran_date");
			refId = (String)payVouchHdr.get("tran_id");
			tranType = (String)payVouchHdr.get("tran_type");
			empCode = (String)payVouchHdr.get("emp_code");
			siteCode = checkNull((String)payVouchHdr.get("site_code"));
			totalAmt = (Double)payVouchHdr.get("tot_amt");
			exchRate = (Double)payVouchHdr.get("exch_rate");
			totalAmtBC = (Double)payVouchHdr.get("tot_amt__bc");
			currCode = (String)payVouchHdr.get("curr_code");
			bankCode = (String)payVouchHdr.get("bank_code");
			payMode = (String)payVouchHdr.get("pay_mode");
			entryBatchNo = (String)payVouchHdr.get("entry_batch_no");
			acctCodeHdr = (String)payVouchHdr.get("acct_code__pay");
			cctrCodeHdr = (String)payVouchHdr.get("cctr_code__pay");
			remarks = "Transfer for HR related payment of " + empCode;

			errString = gbfPostPayrVoucherHdr(payVouchHdr,payVouchDetList,payVouchAdvList,xtraParams,conn);
			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}

			errString = gbfPostPayrVoucherDet(payVouchHdr,payVouchDetList,xtraParams,conn);
			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}
			// Start from here
			errString = finCommon.checkGlTranDrCr("P-VOUC",refId,conn);
			System.out.println("errString in checkGlTranDrCr ::"+errString);

			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}
			// create ibca if site code in voucher does not match the payment site of the employee

			sql = "SELECT SITE_CODE__PAYMENT  FROM EMPLOYEE WHERE EMP_CODE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, empCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				siteCodePayment = rs.getString("site_code__payment");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			if(siteCodePayment == null || siteCodePayment.trim().length() == 0)
			{
				siteCodePayment = siteCode;
			}

			if(! siteCode.trim().equalsIgnoreCase(siteCodePayment.trim()))
			{
				sql = "SELECT FIN_ENTITY  FROM SITE WHERE SITE_CODE = ?  ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, siteCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					finEntityFr = rs.getString("fin_entity");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				sql = "SELECT FIN_ENTITY  FROM SITE WHERE SITE_CODE = ?  ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, siteCodePayment);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					finEntityTo = rs.getString("fin_entity");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				sql = "SELECT LINK_TYPE, ACCT_CODE__PAY, CCTR_CODE__PAY, ACCT_CODE__RCP, CCTR_CODE__RCP "
						+"	FROM IBCA_PAY_CTRL 	WHERE SITE_CODE__FROM 	=  ? AND 	SITE_CODE__TO 	= ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, siteCode);
				pstmt.setString(2, siteCodePayment);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					linkType = rs.getString("link_type");
					acctCodePay = rs.getString("acct_code__pay");
					cctrCodePay = rs.getString("cctr_code__pay");
					acctCodeRCP = rs.getString("acct_code__rcp");
					cctrCodeRCP = rs.getString("cctr_code__rcp");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				String xmlValues =	"";
				sql = "SELECT KEY_STRING  FROM TRANSETUP WHERE UPPER(TRAN_WINDOW) = 'W_PAY_IBCA' ";
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					keyString = rs.getString("key_string");
				}
				rs.close();rs = null;
				pstmt.close();pstmt = null;

				System.out.println("keyString :"+keyString);

				sql = "SELECT TRAN_DATE  FROM MISC_PAYABLES WHERE TRAN_SER = 'P-VOUC' AND REF_NO = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, refId);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					tranDate = rs.getDate("TRAN_DATE");
				}
				rs.close();rs = null;
				pstmt.close();pstmt = null;

				System.out.println("keyString :"+keyString);
				SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
				String tranDateStr = sdfAppl.format(tranDate);

				xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
				xmlValues = xmlValues + "<Header></Header>";
				xmlValues = xmlValues + "<Detail1>";
				xmlValues = xmlValues +		"<tran_id></tran_id>";
				xmlValues = xmlValues +		"<site_code>" + siteCode + "</site_code>";
				xmlValues = xmlValues +		"<tran_date>" + tranDateStr + "</tran_date>"; 
				xmlValues = xmlValues +		"<link_type>" + linkType + "</link_type>";
				xmlValues = xmlValues + "</Detail1></Root>";
				System.out.println("xmlValues  :["+xmlValues+"]");
				TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
				String payIbcaId = tg.generateTranSeqID("P-IBCA", "tran_id", keyString, conn);
				System.out.println("tranIdGenerate for w_pay_ibca = "+payIbcaId);

				sql = " INSERT INTO PAY_IBCA (TRAN_ID, TRAN_DATE, EFF_DATE, SITE_CODE__FROM, FIN_ENTITY__FROM,"
						+" SITE_CODE__TO, FIN_ENTITY__TO, AMOUNT, CURR_CODE, EXCH_RATE, CONFIRMED, ACCT_CODE__IFR,"
						+" CCTR_CODE__IFR, ACCT_CODE__ITO, CCTR_CODE__ITO, CHG_DATE, CHG_USER, CHG_TERM, AMOUNT__BC,"
						+"	TRAN_TYPE, TRAN_SER, LINK_TYPE, REMARKS) 	VALUES ( ?, ?,?, ?, ?,"
						+" ?, ?,?,?, ?,    'N', ?,?, ?, ?,?,     ?, ?, ?,?, 'I',?, ?)  "; 
				pstmtUpd = conn.prepareStatement(sql);
				pstmtUpd.setString(1,payIbcaId);
				pstmtUpd.setDate(2,tranDate == null?null:new java.sql.Date(tranDate.getTime()) );
				pstmtUpd.setDate(3,new java.sql.Date((new java.sql.Timestamp(System.currentTimeMillis())).getTime()));
				pstmtUpd.setString(4,siteCode);
				pstmtUpd.setString(5,finEntityFr);
				pstmtUpd.setString(6,siteCodePayment);
				pstmtUpd.setString(7,finEntityTo);
				pstmtUpd.setDouble(8,totalAmt);
				pstmtUpd.setString(9,currCode);
				pstmtUpd.setDouble(10,exchRate);

				pstmtUpd.setString(11,acctCodePay);
				pstmtUpd.setString(12,cctrCodePay);
				pstmtUpd.setString(13,acctCodeRCP);
				pstmtUpd.setString(14,cctrCodeRCP);
				pstmtUpd.setTimestamp(15,new java.sql.Timestamp(System.currentTimeMillis()));
				pstmtUpd.setString(16,userId);
				pstmtUpd.setString(17,chgTerm);
				pstmtUpd.setDouble(18,totalAmtBC);
				pstmtUpd.setString(19,tranType);
				pstmtUpd.setString(20,linkType);

				pstmtUpd.setString(21,remarks);

				int i = pstmtUpd.executeUpdate();
				System.out.println("row insert into pay_ibca ="+i);
				pstmtUpd.close();
				pstmtUpd = null;

				sql = " INSERT INTO PAY_IBCA_DET (TRAN_ID, REF_SER, REF_NO, REF_DATE, CURR_CODE, EXCH_RATE,"
						+" SUNDRY_TYPE, SUNDRY_CODE, ACCT_CODE, CCTR_CODE, DUE_DATE, TOT_AMT, DISCOUNT,"
						+"	TAX_AMT, AUTO_PAY, BANK_CODE, REF_TYPE, PAY_MODE, ENTRY_BATCH_NO) "
						+"	VALUES (?, 'P-VOUC',?, ?, ?, ?,"
						+"	'E', ?, ?, ?, ?, ?, 0,  	0, 'Y', ?, ?, ?, ?)  "; 
				pstmtUpd = conn.prepareStatement(sql);
				pstmtUpd.setString(1,payIbcaId);
				pstmtUpd.setString(2,refId);
				pstmtUpd.setDate(3,tranDate == null?null:new java.sql.Date(tranDate.getTime()) );
				pstmtUpd.setString(4,currCode);
				pstmtUpd.setDouble(5,exchRate);

				pstmtUpd.setString(6,empCode);
				pstmtUpd.setString(7,acctCodeHdr);
				pstmtUpd.setString(8,cctrCodeHdr);
				pstmtUpd.setDate(9,tranDate == null?null:new java.sql.Date(tranDate.getTime()) );
				pstmtUpd.setDouble(10,totalAmt);

				pstmtUpd.setString(11,bankCode);
				pstmtUpd.setString(12,refType);//issue
				pstmtUpd.setString(13,payMode);
				pstmtUpd.setString(14,entryBatchNo);

				i = pstmtUpd.executeUpdate();
				System.out.println("row insert into pay_ibca_det ="+i);
				pstmtUpd.close();
				pstmtUpd = null;

				errString =  payIbcaConf.confirm(payIbcaId,xtraParams,"N",conn);
				if(errString != null && errString.trim().length() > 0 && errString.indexOf("VTCICONF3") == -1)
				{
					return errString;
				}
				else
				{
					errString = "";
				}


			}

		} 
		catch (SQLException sqle) 
		{

			System.out.println("Exception :PayrollVoucherConf :gbfPostPayrVoucher :SQLException :==>\n"+sqle.getMessage());
			sqle.printStackTrace();
			throw new ITMException(sqle);
		}
		catch (Exception e) 
		{

			System.out.println("Exception :PayrollVoucherConf :gbfPostPayrVoucher :Exception :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;					
				}	
				if(rsHdr != null)
				{
					rsHdr.close();
					rsHdr = null;					
				}	
				if(rsInner != null)
				{
					rsInner.close();
					rsInner = null;					
				}	
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;					
				}	
				if(pstmtUpd != null)
				{
					pstmtUpd.close();
					pstmtUpd = null;					
				}	
				if(pstmtHdr != null)
				{
					pstmtHdr.close();
					pstmtHdr = null;					
				}	
				if(pstmtInner != null)
				{
					pstmtInner.close();
					pstmtInner = null;					
				}	
							
			}
			catch(Exception fe)
			{
				System.out.println(fe.getMessage());
				fe.printStackTrace();
				
			}
		}
		return errString;
	}//gbfPostPayrVoucher end

	private String gbfPostPayrVoucherHdr(HashMap payVouchHdr,ArrayList payVouchDetList,ArrayList payVouchAdvList,String xtraParams ,Connection conn) throws ITMException
	{
		String errString = "",sql = "" , userId = "", chgTerm = "";
		String empCode = "", loanNo = "", adCode = "", confirmed = "" ,transer ="" , refId = "";
		String tranType = "",acctCodePay = "",siteCode = "",tranId = "",postOption = "";
		String status = "",sType = "",sCode = "",finEntity = "",cctrCodePay = "";
		String entryBatchNo = "",currCode = "",remarks = "",hold = "",keyString = "",refNo = "",payMode = "",bankCode = "";
		String sundryCode = "" , withHeld = "",loginEmpCode = "",editOption = "",refSer = "" ;
		int lineNo = 0,recCount = 0 ;
		double  recoAmt = 0,balanceAmt = 0,amount = 0;
		double advAmt = 0,adjAmt = 0,totalAmt = 0,netAmt = 0,taxAmt = 0,adjAmt1 = 0;
		double exchRate = 0 , holdAmt = 0;
		Date recoDate = null, startDate = null,  confDate = null ,refDate = null;
		Date tranDate = null,today = new java.util.Date(),resiDate = null,effDate = null;
		HashMap glTraceMap = null,sundryBalMap = null,miscPayMap = null,payVouchAdv = null;
		PreparedStatement pstmt = null,pstmtUpd = null,pstmtHdr = null,pstmtInner = null;
		ResultSet rs = null,rsHdr = null,rsInner = null;
		Timestamp currDate = null;
		GenericUtility genericUtility = null;
		FinCommon finCommon = new FinCommon();
		AdmCommon admCommon = null;
		try 
		{
			System.out.println("gbfPostPayrVoucherHdr called........... ");
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
			genericUtility = GenericUtility.getInstance();
			admCommon = new AdmCommon();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			loginEmpCode  = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
			System.out.println("payVouch Header = "+payVouchHdr);
			if(payVouchHdr == null)
			{
				errString = itmDBAccess.getErrorString("","VTIMP","","",conn);
				return errString;
			}
			else if(payVouchHdr.size() == 0)
			{
				errString = itmDBAccess.getErrorString("","VTIMPNOREC","","",conn);
				return errString;
			}
			glTraceMap = new HashMap();
			sundryBalMap = new HashMap();
			miscPayMap = new HashMap();

			tranDate = (Date)payVouchHdr.get("tran_date");
			tranId = (String)payVouchHdr.get("tran_id");
			effDate = (Date)payVouchHdr.get("eff_date");
			finEntity = (String)payVouchHdr.get("fin_entity");
			tranType = (String)payVouchHdr.get("tran_type");
			siteCode = (String)payVouchHdr.get("site_code");
			empCode = (String)payVouchHdr.get("emp_code");
			acctCodePay = (String)payVouchHdr.get("acct_code__pay");
			cctrCodePay = (String)payVouchHdr.get("cctr_code__pay");
			currCode = (String)payVouchHdr.get("curr_code");
			exchRate = (Double)payVouchHdr.get("exch_rate");
			entryBatchNo = (String)payVouchHdr.get("entry_batch_no");
			totalAmt = (Double)payVouchHdr.get("tot_amt");
			remarks = (String)payVouchHdr.get("remarks");
			hold = (String)payVouchHdr.get("hold");
			if(hold == null || hold.trim().length() == 0)
			{
				hold = "N";
			}
			refDate = (Date)payVouchHdr.get("ref_date");
			bankCode = (String)payVouchHdr.get("bank_code");
			payMode = (String)payVouchHdr.get("pay_mode");
			confirmed = (String)payVouchHdr.get("confirmed") == null?"N":(String)payVouchHdr.get("confirmed");

			postOption = checkNull(admCommon.getSiteEnv(siteCode	, "FIN", "X", "ZZZZZ", "PAYR_POSTING", getTimeStamp( tranDate ), conn));
			if(!"S".equalsIgnoreCase(postOption.trim())  && !"D".equalsIgnoreCase(postOption.trim()))
			{
				errString = itmDBAccess.getErrorString("","VTSITEPARM","","",conn);
				return errString;
			}

			if("S".equalsIgnoreCase(postOption.trim()) && ("PAY".equalsIgnoreCase(tranType) || "ARR".equalsIgnoreCase(tranType)))
			{
				sql = "SELECT RESI_DATE  FROM EMPLOYEE WHERE EMP_CODE = ?  ";
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					resiDate = rs.getDate("resi_date");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				if(resiDate != null)
				{
					status = "S";
				}
				else
				{
					status = "A";
				}
				if("S".equalsIgnoreCase(status))
				{
					sType = "E";
					sCode = empCode;
					postOption = "D";
					acctCodePay = admCommon.getSiteEnv(siteCode, "FIN", "X", "ZZZZZ", "NET_PAY_AC", getTimeStamp( tranDate ), conn);
					if("NULLFOUND".equalsIgnoreCase(acctCodePay))
					{
						errString = itmDBAccess.getErrorString("","VTSITEPARM","","",conn);
						return errString;
					}
				}
				else
				{
					sType = "O";
					sCode = "";
				}
			}
			else
			{
				postOption = "D";
				sType = "E";
				sCode = empCode;
			}
			glTraceMap.put("ref_id", tranId);
			glTraceMap.put("tran_date", getTimeStamp( tranDate ));
			glTraceMap.put("eff_date", getTimeStamp( effDate ) );
			glTraceMap.put("fin_entity", finEntity);
			glTraceMap.put("site_code", siteCode);
			glTraceMap.put("sundry_type", sType);
			glTraceMap.put("sundry_code", sCode);
			glTraceMap.put("acct_code", acctCodePay);
			glTraceMap.put("cctr_code", cctrCodePay);
			glTraceMap.put("emp_code", empCode);
			glTraceMap.put("anal_code", null);
			glTraceMap.put("curr_code", currCode);
			glTraceMap.put("exch_rate", exchRate);
			glTraceMap.put("entry_batch_no", entryBatchNo);
			if(totalAmt > 0)
			{
				glTraceMap.put("dr_amt", 0.0);
				glTraceMap.put("cr_amt", totalAmt);
			}
			else
			{
				glTraceMap.put("dr_amt", 0-totalAmt);
				glTraceMap.put("cr_amt", 0.0);
			}
			glTraceMap.put("ref_type", "A");
			glTraceMap.put("ref_ser", "P-VOUC");
			glTraceMap.put("remarks", remarks);
			glTraceMap.put("user_id",userId);
			glTraceMap.put("chg_user",userId);
			glTraceMap.put("chg_term",chgTerm);

			errString = finCommon.glTraceUpdate(glTraceMap, conn);
			System.out.println("errString2386="+errString);
			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}

			if(!"O".equalsIgnoreCase(sType))
			{
				sundryBalMap.put("tran_date",getTimeStamp( tranDate ));
				sundryBalMap.put("eff_date",getTimeStamp( effDate ));
				sundryBalMap.put("fin_entity",finEntity);
				sundryBalMap.put("site_code",siteCode);
				sundryBalMap.put("sundry_type",sType);
				sundryBalMap.put("sundry_code",sCode);
				sundryBalMap.put("acct_code",acctCodePay);
				sundryBalMap.put("cctr_code",cctrCodePay);
				sundryBalMap.put("curr_code",currCode);
				sundryBalMap.put("exch_rate",exchRate);


				if(totalAmt > 0)
				{
					sundryBalMap.put("dr_amt",0.0);
					sundryBalMap.put("cr_amt",totalAmt);
				}
				else
				{
					sundryBalMap.put("dr_amt",0-totalAmt);
					sundryBalMap.put("cr_amt",0.0);
				}
				sundryBalMap.put("adv_amt",0.0);
				sType = (String)sundryBalMap.get("sundry_type");
				sCode = (String)sundryBalMap.get("sundry_code");
				sundryBalMap.put("contact_code",finCommon.getContactCode(sType,sCode,conn));
				sundryBalMap.put("user_id",userId);
				sundryBalMap.put("chg_user",userId);
				sundryBalMap.put("chg_term",chgTerm);

				System.out.println("sundryBalMap:::::2483::::::"+sundryBalMap);
				
				errString = finCommon.gbf_sundrybal_upd(sundryBalMap,conn);
				System.out.println("2422 errString="+errString);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
			}
			// should be done only if it is a payroll / arrear voucher not for any other voucher 229
			if("PAY".equalsIgnoreCase(tranType) || "ARR".equalsIgnoreCase(tranType))
			{
				if("S".equalsIgnoreCase(postOption))
				{
					recCount = 0;
					sql = " SELECT COUNT(*)  FROM MISC_PAYABLES WHERE SITE_CODE = ? AND ENTRY_BATCH_NO = ? "
							+"	AND ACCT_CODE = ? AND CCTR_CODE = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode);
					pstmt.setString(2, entryBatchNo);
					pstmt.setString(3, acctCodePay);
					pstmt.setString(4, cctrCodePay);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						recCount = rs.getInt(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					if(recCount == 0)
					{
						String xmlValues =	"";
						sql = "SELECT KEY_STRING  FROM TRANSETUP WHERE UPPER(TRAN_WINDOW) = 'T_MISCPAY_REF' ";
						pstmt = conn.prepareStatement(sql);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							keyString = rs.getString("key_string");
						}
						rs.close();rs = null;
						pstmt.close();pstmt = null;
						
						if(keyString == null || keyString.trim().length() == 0)
						{
							sql = " SELECT KEY_STRING  FROM TRANSETUP WHERE UPPER(TRAN_WINDOW) = 'GENERAL' ";
							pstmt = conn.prepareStatement(sql);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								keyString = rs.getString("key_string");
							}
							rs.close();rs = null;
							pstmt.close();pstmt = null;
						}
						System.out.println("keyString :"+keyString);
						SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
						String tranDateStr = sdfAppl.format(tranDate);

						xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
						xmlValues = xmlValues + "<Header></Header>";
						xmlValues = xmlValues + "<Detail1>";
						xmlValues = xmlValues +		"<tran_id></tran_id>";
						xmlValues = xmlValues +		"<site_code>" + siteCode + "</site_code>";
						xmlValues = xmlValues +		"<tran_date>" + tranDateStr + "</tran_date>"; 
						xmlValues = xmlValues + "</Detail1></Root>";
						System.out.println("xmlValues  :["+xmlValues+"]");
						TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
						refNo = tg.generateTranSeqID("PAY_R", "tran_id", keyString, conn);
						System.out.println("tranIdGenerate for PAY_R = "+refNo);
						if(refNo == null || refNo.trim().length() == 0)
						{
							errString = itmDBAccess.getErrorString("","VTTRANID","","",conn);
							return errString;
						}
						else if("ERROR".equalsIgnoreCase(refNo))
						{
							errString = itmDBAccess.getErrorString("","VTTRANID","","",conn);
							return errString;
						}
						miscPayMap.put("tran_ser","P-VOUC");
						miscPayMap.put("tran_date",getTimeStamp( tranDate ));
						miscPayMap.put("ref_no",refNo);
						miscPayMap.put("ref_date",getTimeStamp( tranDate ));
						miscPayMap.put("bill_no"," ");
						miscPayMap.put("bill_date",getTimeStamp( refDate ));
						miscPayMap.put("curr_code",currCode);
						miscPayMap.put("exch_rate",exchRate);
						miscPayMap.put("sundry_type","O");
						miscPayMap.put("sundry_code","");
						miscPayMap.put("acct_code",acctCodePay);
						miscPayMap.put("cctr_code",cctrCodePay);
						miscPayMap.put("due_date",getTimeStamp( tranDate ));
						miscPayMap.put("site_code",siteCode);
						miscPayMap.put("fin_entity",finEntity);
						miscPayMap.put("tot_amt",totalAmt);
						miscPayMap.put("bank_code",bankCode); 
						miscPayMap.put("auto_pay","Y");
						miscPayMap.put("pay_mode",payMode);
						miscPayMap.put("paid","N");
						miscPayMap.put("adv_amt",0.0);
						miscPayMap.put("entry_batch_no",entryBatchNo);
						sundryCode = empCode;
						if("Y".equalsIgnoreCase(hold))
						{
							miscPayMap.put("hold_amt",totalAmt);
						}
						else if("N".equalsIgnoreCase(hold) && "E".equalsIgnoreCase(sType))
						{
							sql = " SELECT WITH_HELD  FROM EMPLOYEE WHERE EMP_CODE = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, empCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								withHeld = checkNull(rs.getString(1));
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if("Y".equalsIgnoreCase(withHeld))
							{
								miscPayMap.put("hold_amt",totalAmt);
								sql = " UPDATE PAYR_VOUCHER SET HOLD = 'Y' WHERE TRAN_ID = ? "; 
								pstmtUpd = conn.prepareStatement(sql);
								pstmtUpd.setString(1,tranId);
								int i = pstmtUpd.executeUpdate();
								System.out.println("row update into payr_voucher ="+i);
								pstmtUpd.close();
								pstmtUpd = null;

							}
							else
							{
								miscPayMap.put("hold_amt",0.0);
							}
						}
						else
						{
							miscPayMap.put("hold_amt",0.0);
						}

						errString = finCommon.gbfMiscPayUpd(miscPayMap,conn);
						System.out.println("2565="+errString);
						if(errString != null && errString.trim().length() > 0)
						{
							return errString;
						}
					}
					else if(recCount == 1)
					{
						// update the record in misc_payables 340
						sundryCode = empCode;
						if("Y".equalsIgnoreCase(hold))
						{
							holdAmt = totalAmt;
						}
						else if("N".equalsIgnoreCase(hold) && "E".equalsIgnoreCase(sType))
						{
							sql = " SELECT WITH_HELD  FROM EMPLOYEE WHERE EMP_CODE = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, empCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								withHeld = checkNull(rs.getString(1));
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if("Y".equalsIgnoreCase(withHeld))
							{
								holdAmt = totalAmt;
								sql = " UPDATE PAYR_VOUCHER SET HOLD = 'Y' WHERE TRAN_ID = ? "; 
								pstmtUpd = conn.prepareStatement(sql);
								pstmtUpd.setString(1,tranId);
								int i = pstmtUpd.executeUpdate();
								System.out.println("row update into payr_voucher ="+i);
								pstmtUpd.close();
								pstmtUpd = null;

							}
							else
							{
								holdAmt = 0;
							}
						}
						sql = " UPDATE MISC_PAYABLES SET TOT_AMT = TOT_AMT + ?,HOLD_AMT = HOLD_AMT + ?, STATUS_DATE = ?  "
								+" WHERE SITE_CODE = ? AND ENTRY_BATCH_NO = ? AND ACCT_CODE = ? AND CCTR_CODE =  ?  "; 
						pstmtUpd = conn.prepareStatement(sql);
						pstmtUpd.setDouble(1,totalAmt);
						pstmtUpd.setDouble(2,holdAmt);
						pstmtUpd.setDate(3,today == null?null:new java.sql.Date(today.getTime()) );
						pstmtUpd.setString(4,siteCode);
						pstmtUpd.setString(5,entryBatchNo);
						pstmtUpd.setString(6,acctCodePay);
						pstmtUpd.setString(7,cctrCodePay);
						int i = pstmtUpd.executeUpdate();
						System.out.println("row update into misc_payables ="+i);
						pstmtUpd.close();
						pstmtUpd = null;

					}
					else
					{
						errString = itmDBAccess.getErrorString("","VTPAYSUM","","",conn);
						return errString;
					}
				}
			}// end of ls_trantype
			// insert into misc_payables only for ls_post_option = 'D' 402
			// for all vouchers non payroll / arrears ls_post_option is forced to 'D'
			if("D".equalsIgnoreCase(postOption))
			{
				miscPayMap.put("tran_ser","P-VOUC");
				miscPayMap.put("tran_date",getTimeStamp( tranDate ));
				miscPayMap.put("ref_no",tranId);
				miscPayMap.put("ref_date",getTimeStamp( tranDate ));
				miscPayMap.put("bill_no"," ");
				miscPayMap.put("bill_date",getTimeStamp( refDate ));
				miscPayMap.put("curr_code",currCode);
				miscPayMap.put("exch_rate",exchRate);
				miscPayMap.put("sundry_type","E");
				miscPayMap.put("sundry_code",empCode);
				miscPayMap.put("acct_code",acctCodePay);
				miscPayMap.put("cctr_code",cctrCodePay);
				miscPayMap.put("due_date",getTimeStamp( tranDate ));
				miscPayMap.put("site_code",siteCode);
				miscPayMap.put("fin_entity",finEntity);
				miscPayMap.put("tot_amt",totalAmt);
				miscPayMap.put("bank_code",bankCode); 
				miscPayMap.put("auto_pay","Y");
				miscPayMap.put("pay_mode",payMode);
				miscPayMap.put("paid","N");
				miscPayMap.put("adv_amt",0.0);
				miscPayMap.put("entry_batch_no",entryBatchNo);

				sundryCode = empCode;
				if("Y".equalsIgnoreCase(hold))
				{
					miscPayMap.put("hold_amt",totalAmt);
				}
				else if("N".equalsIgnoreCase(hold) && "E".equalsIgnoreCase(sType))
				{
					sql = " SELECT WITH_HELD  FROM EMPLOYEE WHERE EMP_CODE = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, empCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						withHeld = checkNull(rs.getString(1));
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					if("Y".equalsIgnoreCase(withHeld))
					{
						miscPayMap.put("hold_amt",totalAmt);
						sql = " UPDATE PAYR_VOUCHER SET HOLD = 'y' WHERE TRAN_ID = ? "; 
						pstmtUpd = conn.prepareStatement(sql);
						pstmtUpd.setString(1,tranId);
						int i = pstmtUpd.executeUpdate();
						System.out.println("row update into payr_voucher ="+i);
						pstmtUpd.close();
						pstmtUpd = null;

					}
					else
					{
						miscPayMap.put("hold_amt",0.0);
					}
				}
				errString = finCommon.gbfMiscPayUpd(miscPayMap,conn);	
				System.out.println("2697  errString="+errString);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
			}// post_option = 'D'

			if(!"Y".equalsIgnoreCase(confirmed))
			{
				sql = " UPDATE PAYR_VOUCHER SET CONFIRMED = 'Y', CONF_DATE = ?, EMP_CODE__APRV = ? WHERE TRAN_ID = ? "; 
				pstmtUpd = conn.prepareStatement(sql);
				pstmtUpd.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
				pstmtUpd.setString(2,loginEmpCode);
				pstmtUpd.setString(3,tranId);
				int i = pstmtUpd.executeUpdate();
				System.out.println("row update into payr_voucher ="+i);
				pstmtUpd.close();
				pstmtUpd = null;
			}

			sql = " SELECT EDI_OPTION  FROM TRANSETUP WHERE TRAN_WINDOW = 'w_payr_voucher'";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				editOption = checkNull(rs.getString(1));
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			if(editOption != null && editOption.trim().equalsIgnoreCase("0"))
			{

				String dataStr = "";
				if ( "1".equals(editOption.trim()) )
				{
					CreateRCPXML createRCPXML = new CreateRCPXML("w_payr_voucher","tran_id");
					dataStr = createRCPXML.getTranXML( tranId, conn );
					System.out.println( "dataStr =[ "+ dataStr + "]" );
					Document ediDataDom = genericUtility.parseString(dataStr);
					E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
					String retString = e12CreateBatchLoad.createBatchLoad(ediDataDom, "w_payr_voucher", "0", xtraParams, conn );
					createRCPXML = null;
					e12CreateBatchLoad = null;
					if( retString != null && "SUCCESS".equals(retString) )
					{
						System.out.println("retString from pay voucher = 	["+retString+"]");
					}
				}

			} 

			for (int ctr =0; ctr < payVouchAdvList.size(); ctr++)
			{
				// adjust the misc_payable entry for each misc_payable adjusted 535
				glTraceMap = new HashMap();
				payVouchAdv = new HashMap();
				payVouchAdv = (HashMap) payVouchAdvList.get(ctr);
				System.out.println("2755 payVouchAdv="+payVouchAdv);

				glTraceMap.put("tran_date", getTimeStamp( tranDate ));
				glTraceMap.put("eff_date", getTimeStamp( effDate ) );
				glTraceMap.put("fin_entity", finEntity);
				glTraceMap.put("site_code", siteCode);
				glTraceMap.put("sundry_type", "E");
				glTraceMap.put("sundry_code", empCode);
				glTraceMap.put("acct_code", (String)payVouchAdv.get("acct_code"));
				glTraceMap.put("cctr_code", (String)payVouchAdv.get("cctr_code"));
				glTraceMap.put("emp_code", null);
				glTraceMap.put("anal_code", null);
				glTraceMap.put("curr_code", (String)payVouchAdv.get("curr_code"));
				glTraceMap.put("exch_rate", (Double)payVouchAdv.get("exch_rate__vouch"));

				if((Double)payVouchAdv.get("adj_amt") > 0)
				{
					glTraceMap.put("dr_amt", (Double)payVouchAdv.get("adj_amt") );
					glTraceMap.put("cr_amt", 0.0);
				}
				else
				{
					glTraceMap.put("dr_amt", 0.0);
					glTraceMap.put("cr_amt", 0 - (Double)payVouchAdv.get("adj_amt") );
				}
				glTraceMap.put("ref_type", "A");
				glTraceMap.put("ref_ser", "P-VOUC");
				glTraceMap.put("ref_id", tranId);
				glTraceMap.put("remarks", remarks);
				glTraceMap.put("user_id",userId);
				glTraceMap.put("chg_user",userId);
				glTraceMap.put("chg_term",chgTerm);

				errString = finCommon.glTraceUpdate(glTraceMap, conn);
				System.out.println("2788 errString="+errString);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}

				sundryBalMap.put("tran_date",getTimeStamp( tranDate ));
				sundryBalMap.put("eff_date",getTimeStamp( effDate ));
				sundryBalMap.put("fin_entity",finEntity);
				sundryBalMap.put("site_code",siteCode);
				sundryBalMap.put("sundry_type","E");
				sundryBalMap.put("sundry_code",empCode);
				sundryBalMap.put("acct_code",(String)payVouchAdv.get("acct_code"));
				sundryBalMap.put("cctr_code",(String)payVouchAdv.get("cctr_code"));
				sundryBalMap.put("curr_code",(String)payVouchAdv.get("curr_code"));
				sundryBalMap.put("exch_rate",(Double)payVouchAdv.get("exch_rate__vouch"));	


				if((Double)payVouchAdv.get("adj_amt") > 0)
				{
					sundryBalMap.put("dr_amt",(Double)payVouchAdv.get("adj_amt"));
					sundryBalMap.put("cr_amt",0.0);
				}
				else
				{
					sundryBalMap.put("dr_amt",0.0);
					sundryBalMap.put("cr_amt",0 - (Double)payVouchAdv.get("adj_amt"));
				}
				sundryBalMap.put("adv_amt",0.0);
				sType = (String)sundryBalMap.get("sundry_type");
				sCode = (String)sundryBalMap.get("sundry_code");
				sundryBalMap.put("contact_code",finCommon.getContactCode(sType,sCode,conn));
				sundryBalMap.put("user_id",userId);
				sundryBalMap.put("chg_user",userId);
				sundryBalMap.put("chg_term",chgTerm);

				errString = finCommon.gbf_sundrybal_upd(sundryBalMap,conn);	
				System.out.println("2822 errString ="+errString);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}

				refSer = (String)payVouchAdv.get("ref_ser");
				refNo = (String)payVouchAdv.get("ref_no");
				adjAmt = (Double)payVouchAdv.get("adj_amt");
				sql = " SELECT TOT_AMT, ADJ_AMT  FROM MISC_PAYABLES		WHERE TRAN_SER = ? AND REF_NO = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, refSer);
				pstmt.setString(2, refNo);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					amount = rs.getDouble("tot_amt");
					adjAmt1 = rs.getDouble("adj_amt");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				if(Math.abs(amount - adjAmt1) < Math.abs(adjAmt))
				{
					errString = itmDBAccess.getErrorString("","VTBAL1","","",conn);
					return errString;
				}
				adjAmt1 = adjAmt1 +  adjAmt ;
				if(amount == adjAmt)
					status = "A";
				else
					status = "P"; 

				sql = " UPDATE MISC_PAYABLES SET ADJ_AMT = ADJ_AMT + ? , HOLD_AMT = 0,STATUS = ?, STATUS_DATE = ? "
						+" 	WHERE TRAN_SER = ? AND REF_NO = ?  "; 
				pstmtUpd = conn.prepareStatement(sql);
				pstmtUpd.setDouble(1, adjAmt);
				pstmtUpd.setString(2,status );
				pstmtUpd.setDate(3,today == null?null:new java.sql.Date(today.getTime()) );
				pstmtUpd.setString(4,refSer);
				pstmtUpd.setString(5,refNo);
				int i = pstmtUpd.executeUpdate();
				System.out.println("row update into misc_payables ="+i);
				pstmtUpd.close();
				pstmtUpd = null;


				recCount = 0;
				sql = " SELECT COUNT(*) FROM PAYR_VOUCHER  WHERE TRAN_ID = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, refNo);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					recCount = rs.getInt(1);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				if(recCount > 0)
				{
					sql = " UPDATE PAYR_VOUCHER SET HOLD = 'N' 	WHERE TRAN_ID = ?   "; 
					pstmtUpd = conn.prepareStatement(sql);
					pstmtUpd.setString(1,refNo);
					i = pstmtUpd.executeUpdate();
					System.out.println("row update into payr_voucher ="+i);
					pstmtUpd.close();
					pstmtUpd = null;
				}

			}

		} catch (SQLException sqle) 
		{

			System.out.println("Exception :PayrollVoucherConf :gbfPostPayrVoucherHdr :SQLException :==>\n"+sqle.getMessage());
			sqle.printStackTrace();
			throw new ITMException(sqle);
		}
		catch (Exception e) 
		{

			System.out.println("Exception :PayrollVoucherConf :gbfPostPayrVoucherHdr :Exception :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;					
				}	
				if(rsHdr != null)
				{
					rsHdr.close();
					rsHdr = null;					
				}	
				if(rsInner != null)
				{
					rsInner.close();
					rsInner = null;					
				}	
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;					
				}	
				if(pstmtUpd != null)
				{
					pstmtUpd.close();
					pstmtUpd = null;					
				}	
				if(pstmtHdr != null)
				{
					pstmtHdr.close();
					pstmtHdr = null;					
				}	
				if(pstmtInner != null)
				{
					pstmtInner.close();
					pstmtInner = null;					
				}	
							
			}
			catch(Exception fe)
			{
				System.out.println(fe.getMessage());
				fe.printStackTrace();
				
			}
		}
		return errString;
	}//gbfPostPayrVoucherHdr end

	private String gbfPostPayrVoucherDet(HashMap payVouchHdr,ArrayList payVouchDetList,String xtraParams ,Connection conn) throws ITMException
	{
		String errString = "",sql = "" , userId = "", chgTerm = "";
		String empCode = "", loanNo = "", adCode = "", confirmed = "" ,transer ="" , refId = "";
		String tranType = "",ledgPostConf = "",balOpt = "";
		String status = "",sType = "",sCode = "",finEntity = "",cctrCodePay = "", tranId = "", siteCode = "";
		String entryBatchNo = "",currCode = "",remarks = "",hold = "",keyString = "",refNo = "",payMode = "",bankCode = "";
		int lineNo = 0,count = 0 ;
		double  recoAmt = 0,balanceAmt = 0,amount = 0;
		double advAmt = 0,billAmt = 0,totalAmt = 0,netAmt = 0,taxAmt = 0; 
		double exchRate = 0;
		Date recoDate = null, startDate = null,  confDate = null ,refDate = null;
		Date tranDate = null,today = new java.util.Date(),effDate = null;
		HashMap glTraceMap = null, payVouchDet = null ,sundryBalMap = null;
		PreparedStatement pstmt = null,pstmtUpd = null,pstmtHdr = null,pstmtInner = null;
		ResultSet rs = null,rsHdr = null,rsInner = null;
		Timestamp currDate = null;
		GenericUtility genericUtility = null;
		FinCommon finCommon = new FinCommon();
		try 
		{
			System.out.println("gbfPostPayrVoucherDet called........... ");
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
			genericUtility = GenericUtility.getInstance();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
			System.out.println("payVouch Header = "+payVouchHdr);
			if(payVouchHdr == null)
			{
				errString = itmDBAccess.getErrorString("","VTIMP","","",conn);
				return errString;
			}
			else if(payVouchHdr.size() == 0)
			{
				errString = itmDBAccess.getErrorString("","VTIMPNOREC","","",conn);
				return errString;
			}

			System.out.println("payVouch Detail = "+payVouchDetList);
			if(payVouchDetList == null)
			{
				errString = itmDBAccess.getErrorString("","VTIMP","","",conn);
				return errString;
			}
			else if(payVouchDetList.size() == 0)
			{
				errString = itmDBAccess.getErrorString("","VTIMPNOREC","","",conn);
				return errString;
			}
			tranDate = (Date)payVouchHdr.get("tran_date");
			tranId = (String)payVouchHdr.get("tran_id");
			effDate = (Date)payVouchHdr.get("eff_date");
			finEntity = (String)payVouchHdr.get("fin_entity");
			tranType = (String)payVouchHdr.get("tran_type");
			siteCode = (String)payVouchHdr.get("site_code");
			empCode = (String)payVouchHdr.get("emp_code");
			currCode = (String)payVouchHdr.get("curr_code");
			exchRate = (Double)payVouchHdr.get("exch_rate");
			entryBatchNo = (String)payVouchHdr.get("entry_batch_no");
			totalAmt = (Double)payVouchHdr.get("tot_amt");
			remarks = (String)payVouchHdr.get("remarks");
			hold = (String)payVouchHdr.get("hold");

			for (int ctr =0; ctr < payVouchDetList.size(); ctr++)
			{
				glTraceMap = new HashMap();
				payVouchDet = new HashMap();
				payVouchDet = (HashMap)payVouchDetList.get(ctr);
				adCode = (String)payVouchDet.get("ad_code");

				sql = "SELECT BAL_OPT  FROM ALLWDEDN WHERE AD_CODE = ?  ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, adCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					balOpt = rs.getString("bal_opt") == null?" ":rs.getString("bal_opt");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				glTraceMap.put("tran_date", getTimeStamp( tranDate ));
				glTraceMap.put("eff_date", getTimeStamp( effDate ));
				glTraceMap.put("fin_entity", finEntity);
				glTraceMap.put("site_code", siteCode);
				if("C".equalsIgnoreCase(balOpt.trim()) || "P".equalsIgnoreCase(balOpt.trim()))
				{
					glTraceMap.put("sundry_type", "E");
					glTraceMap.put("sundry_code", empCode);
				}
				else
				{
					glTraceMap.put("sundry_type", "O");
					glTraceMap.put("sundry_code", " ");
				}

				glTraceMap.put("acct_code", (String)payVouchDet.get("acct_code"));
				glTraceMap.put("cctr_code", (String)payVouchDet.get("cctr_code"));
				glTraceMap.put("emp_code", empCode);
				glTraceMap.put("anal_code", (String)payVouchDet.get("anal_code"));
				glTraceMap.put("curr_code", currCode);
				glTraceMap.put("exch_rate", exchRate);
				glTraceMap.put("entry_batch_no", entryBatchNo);

				if((Double)payVouchDet.get("amount") > 0)
				{
					glTraceMap.put("dr_amt", (Double)payVouchDet.get("amount") );
					glTraceMap.put("cr_amt", 0.0);
				}
				else
				{
					glTraceMap.put("dr_amt", 0.0);
					glTraceMap.put("cr_amt", 0 - (Double)payVouchDet.get("amount") );
				}
				glTraceMap.put("ref_type", "A");
				glTraceMap.put("ref_ser", "P-VOUC");
				glTraceMap.put("ref_id", tranId);
				glTraceMap.put("remarks", remarks);
				glTraceMap.put("user_id",userId);
				glTraceMap.put("chg_user",userId);
				glTraceMap.put("chg_term",chgTerm);

				errString = finCommon.glTraceUpdate(glTraceMap, conn);
				System.out.println("3040 errString="+errString);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
				if("C".equalsIgnoreCase(balOpt.trim()) || "P".equalsIgnoreCase(balOpt.trim()))
				{
					sundryBalMap = new HashMap();
					sundryBalMap.put("tran_date",getTimeStamp( tranDate ));
					sundryBalMap.put("eff_date",getTimeStamp( effDate ));
					sundryBalMap.put("fin_entity",finEntity);
					sundryBalMap.put("site_code",siteCode);
					sundryBalMap.put("sundry_type","E");
					sundryBalMap.put("sundry_code",empCode);
					sundryBalMap.put("acct_code",(String)payVouchDet.get("acct_code"));
					sundryBalMap.put("cctr_code",(String)payVouchDet.get("cctr_code"));
					System.out.println("currCode:::::::["+currCode+"]");
					sundryBalMap.put("curr_code",currCode);
					sundryBalMap.put("exch_rate",exchRate);	


					if((Double)payVouchDet.get("amount") > 0)
					{
						sundryBalMap.put("dr_amt",(Double)payVouchDet.get("amount"));
						sundryBalMap.put("cr_amt",0.0);
					}
					else
					{
						sundryBalMap.put("dr_amt",0.0);
						sundryBalMap.put("cr_amt",0 - (Double)payVouchDet.get("amount"));
					}
					sundryBalMap.put("adv_amt",0.0);
					sType = (String)sundryBalMap.get("sundry_type");
					sCode = (String)sundryBalMap.get("sundry_code");
					sundryBalMap.put("contact_code",finCommon.getContactCode(sType,sCode,conn));
					sundryBalMap.put("user_id",userId);
					sundryBalMap.put("chg_user",userId);
					sundryBalMap.put("chg_term",chgTerm);
					
					System.out.println("sundryBalMap::::::::::"+sundryBalMap);
					
					errString = finCommon.gbf_sundrybal_upd(sundryBalMap,conn);	
					System.out.println("3076 errString="+errString);
					if(errString != null && errString.trim().length() > 0)
					{
						return errString;
					}

				}
			}

		} catch (SQLException sqle) 
		{

			System.out.println("Exception :PayrollVoucherConf :gbfPostPayrVoucherDet :SQLException :==>\n"+sqle.getMessage());
			sqle.printStackTrace();
			throw new ITMException(sqle);
		}
		catch (Exception e) 
		{

			System.out.println("Exception :PayrollVoucherConf :gbfPostPayrVoucherDet :Exception :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;					
				}	
				if(rsHdr != null)
				{
					rsHdr.close();
					rsHdr = null;					
				}	
				if(rsInner != null)
				{
					rsInner.close();
					rsInner = null;					
				}	
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;					
				}	
				if(pstmtUpd != null)
				{
					pstmtUpd.close();
					pstmtUpd = null;					
				}	
				if(pstmtHdr != null)
				{
					pstmtHdr.close();
					pstmtHdr = null;					
				}	
				if(pstmtInner != null)
				{
					pstmtInner.close();
					pstmtInner = null;					
				}	
							
			}
			catch(Exception fe)
			{
				System.out.println(fe.getMessage());
				fe.printStackTrace();
				
			}
		}
		return errString;
	}//gbfPostPayrVoucherDet end

	private String checkNull( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		return inputVal;
	}
	private Timestamp getTimeStamp( Date inputDate ) throws RemoteException,ITMException
	{
		Timestamp ts = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			if ( inputDate != null )
			{
				ts = Timestamp.valueOf(genericUtility.getValidDateTimeString((new SimpleDateFormat(genericUtility.getApplDateFormat())).format(inputDate),genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ));
			}
		}
		catch (Exception e)
		{
			System.out.println("Exception :PayrollVoucherConf :getTimeStamp :Exception :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		return ts;
	}
}
