package ibase.webitm.ejb.adm;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;//Modified By Hemlata on[20/11/2014] [As per changes in framework to use genericUtility ]
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;  
import javax.ejb.Stateless;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class EmpPayrollInfo extends ValidatorEJB implements EmpPayrollInfoLocal ,EmpPayrollInfoRemote
{

	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		
		String errString = null;
		//Modified By Hemlata on[20/11/2014] [As per changes in framework to use genericUtility ][Start]
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new E12GenericUtility();
		//Modified By Hemlata on[20/11/2014] [As per changes in framework to use genericUtility ][End]
		try
		{
			System.out.println("EmpPayrollInfo xmlString in itemChanged..::["+xmlString+"]");
			System.out.println("EmpPayrollInfo xmlString1 in itemChanged..:: ["+xmlString1+"]");
			System.out.println("EmpPayrollInfo xmlString2 in itemChanged..:: ["+xmlString2+"]");
			
			if(xmlString != null && xmlString.length() > 0)
			{
				dom = genericUtility.parseString(xmlString);				
			}
			if(xmlString1 != null  &&  xmlString1.length() > 0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if(xmlString2 != null && xmlString2.length() > 0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = itemChanged( dom, dom1, dom2, objContext, currentColumn,  editFlag,  xtraParams);
			System.out.println("EmpPayrollInfo errString Returing at Stage 1["+errString+"]");
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception :EmpPayrollInfo [:" + e.getMessage() + ":]" );
			errString = genericUtility.createErrorString(e);
		}
		System.out.println("EmpPayrollInfo errString returing at Stage 2[" + errString+"]");
		return errString;
	}
		
	//Start of itemChanged block
	public String itemChanged(Document dom, Document dom1,Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		String objNameDefault = "";
		
		//Variable defined . Start
		String empCode = "";
		String empFname = "";
		String empMname = "";
		String empLname = "";
		String payMode = "";
		String payType = "";
		String withHeld = "";
		String basic = "";
		String gross ="";
		String autoAdv = "";
		String groupMediclaim = "" ;
		String bankAcct = "";
		String ddPayableBank = "";
		//Variable defined  . End

		int currentFormNo = 0;
		
		//Modified By Hemlata on[20/11/2014] [As per changes in framework to use genericUtility ][Start]
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new E12GenericUtility();
		//Modified By Hemlata on[20/11/2014] [As per changes in framework to use genericUtility ][End]
		 
		//To get login Employee Code And Login Site
		String loginEmpCode = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode"));

		StringBuffer valueXmlString = new StringBuffer();
		
		System.out.println("Login Employee got..:: ["+loginEmpCode+"]");
		System.out.println("objContext ..:: ["+objContext+"]");
		System.out.println("currentColumn ..:: ["+currentColumn+"]");
		System.out.println("editFlag ..:: ["+editFlag+"]");
		System.out.println("xtraParams ..:: ["+xtraParams+"]");
		

		if(objContext != null && objContext.trim().length() > 0)
		{
			currentFormNo = Integer.parseInt(objContext);
		}		

		try
		{		
			conn = connDriver.getConnectDB("Driver");
			conn.setAutoCommit(false);

			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");

			objNameDefault  = checkNull(getObjName(dom ,"1"));
			System.out.println("objNameDefault ..:: ["+objNameDefault+"]");
			
			switch (currentFormNo)
			{
				case 1:
						{
							valueXmlString.append("<Detail1 domID='1' dbID='' objContext='1' objName='"+objNameDefault+"' selected='Y'>\r\n");
							empCode = genericUtility.getColumnValue("emp_code",dom2);
							
							if(currentColumn.equalsIgnoreCase("itm_defaultedit"))
							{
								sql = " SELECT EMP_FNAME , EMP_MNAME , EMP_LNAME , PAY_TYPE , PAY_MODE , WITH_HELD , BASIC , GROSS , AUTO_ADV , GROUP_MEDICLAIM , DD_PAYABLE_BANK , BANK_ACCT FROM EMPLOYEE WHERE EMP_CODE = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,empCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									empFname = checkNull(rs.getString("EMP_FNAME"));
									empMname = checkNull(rs.getString("EMP_MNAME"));
									empLname = checkNull(rs.getString("EMP_LNAME"));
									payType = checkNull(rs.getString("PAY_TYPE"));
									payMode = checkNull(rs.getString("PAY_MODE"));
									withHeld = checkNull(rs.getString("WITH_HELD"));
									basic = checkNull(rs.getString("BASIC"));
									gross = checkNull(rs.getString("GROSS"));
									autoAdv = checkNull(rs.getString("AUTO_ADV"));
									groupMediclaim = checkNull(rs.getString("GROUP_MEDICLAIM"));
									ddPayableBank = checkNull(rs.getString("DD_PAYABLE_BANK"));
									bankAcct  = checkNull(rs.getString("BANK_ACCT"));
								}
								if( rs != null )
								{
									rs.close();
									rs = null;
								}
								if( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								System.out.println("empFname ..:: ["+empFname+"]");
								System.out.println("empMname ..:: ["+empMname+"]");
								System.out.println("empLname ..:: ["+empLname+"]");
								System.out.println("payType ..:: ["+payType+"]");
								System.out.println("payMode ..:: ["+payMode+"]");
								System.out.println("withHeld ..:: ["+withHeld+"]");
								System.out.println("basic ..:: ["+basic+"]");
								System.out.println("gross ..:: ["+gross+"]");
								System.out.println("autoAdv ..:: ["+autoAdv+"]");
								System.out.println("groupMediclaim ..:: ["+groupMediclaim+"]");
								System.out.println("ddPayableBank ..:: ["+ddPayableBank+"]");
								System.out.println("bankAcct ..:: ["+bankAcct+"]");
								
								valueXmlString.append("<emp_code protect=\"1\"><![CDATA[").append(empCode).append("]]></emp_code>\r\n");
								valueXmlString.append("<emp_fname protect=\"1\"><![CDATA[").append(empFname).append("]]></emp_fname>\r\n");
								valueXmlString.append("<emp_mname protect=\"1\"><![CDATA[").append(empMname).append("]]></emp_mname>\r\n");
								valueXmlString.append("<emp_lname protect=\"1\"><![CDATA[").append(empLname).append("]]></emp_lname>\r\n");
								
								
								if(payType == null || payType.length() == 0)
								{
									valueXmlString.append("<pay_type><![CDATA[").append("S").append("]]></pay_type>\r\n");
								}
								
								if(payMode == null || payMode.length() == 0)
								{
									valueXmlString.append("<pay_mode><![CDATA[").append("C").append("]]></pay_mode>\r\n");
								}
								
								if(withHeld == null || withHeld.length() == 0)
								{
									valueXmlString.append("<with_held><![CDATA[").append("N").append("]]></with_held>\r\n");
								}
								
								if(basic == null || basic.length() == 0)
								{
									valueXmlString.append("<basic><![CDATA[").append("0").append("]]></basic>\r\n");
								}
								
								if(gross == null || gross.length() == 0)
								{
									valueXmlString.append("<gross><![CDATA[").append("0").append("]]></gross>\r\n");
								}
								
								if(!(payMode.equalsIgnoreCase("D")))
								{
									valueXmlString.append("<dd_payable_bank protect=\"1\"><![CDATA[").append(ddPayableBank).append("]]></dd_payable_bank>\r\n");
								}
								
								if(!(payMode.equalsIgnoreCase("T")))
								{
									valueXmlString.append("<bank_acct protect=\"1\"><![CDATA[").append(bankAcct).append("]]></bank_acct>\r\n");
								}
								
								if(autoAdv == null || autoAdv.length() == 0)
								{
									valueXmlString.append("<auto_adv><![CDATA[").append("N").append("]]></auto_adv>\r\n");
								}
								
								if(groupMediclaim == null || groupMediclaim.length() == 0)
								{
									valueXmlString.append("<group_mediclaim><![CDATA[").append("N").append("]]></group_mediclaim>\r\n");
								}
								
							}
							else if (currentColumn.equalsIgnoreCase("pay_mode"))
							{
								payMode = checkNull(getColumnValue("pay_mode",dom,"1")) ;
								bankAcct = checkNull(getColumnValue("bank_acct",dom,"1")) ;
								
								if(payMode.equalsIgnoreCase("C"))
								{
									valueXmlString.append("<bank_code><![CDATA[").append("").append("]]></bank_code>\r\n");
									valueXmlString.append("<bank_acct><![CDATA[").append("").append("]]></bank_acct>\r\n");
								}
								if(!(payMode.equalsIgnoreCase("T")))
								{
									valueXmlString.append("<bank_acct protect=\"1\"><![CDATA[").append(bankAcct).append("]]></bank_acct>\r\n");
								}
								else
								{
									valueXmlString.append("<bank_acct protect=\"0\"><![CDATA[").append(bankAcct).append("]]></bank_acct>\r\n");
								}
								if(!(payMode.equalsIgnoreCase("D")))
								{
									valueXmlString.append("<dd_payable_bank protect=\"1\"><![CDATA[").append("").append("]]></dd_payable_bank>\r\n");
								}
								else
								{
									valueXmlString.append("<dd_payable_bank protect=\"0\"><![CDATA[").append("").append("]]></dd_payable_bank>\r\n");
								}
							}
							
							valueXmlString.append("</Detail1>\r\n");
						
						}//End of Case 1
						break;
			}//END OF SWITCH
			
		}//End of try block		
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :EmpPayrollInfo [itemChanged(String xmlString)] : ==>\n"+e.getMessage());
			throw new ITMException(e);
		}//End of cacth block
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
				
			}
			catch(Exception e)
			{
				System.out.println("Exception ::"+e);
				e.printStackTrace();
			}			
		}//End of finally block
		
		valueXmlString.append("</Root>\r\n");
		System.out.println("valueXmlString....["+valueXmlString.toString());
		return valueXmlString.toString();
	}//End of itemChanged block


	//Start of wfValData Start
	public String wfValData() throws RemoteException,ITMException
	{
		return "";
	}

	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("Came Inside 1 wfValData:::");
		
		//Modified By Hemlata on[20/11/2014] [As per changes in framework to use genericUtility ][Start]
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new E12GenericUtility();
		//Modified By Hemlata on[20/11/2014] [As per changes in framework to use genericUtility ][End]
		
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";
		System.out.println("xmlString ["+xmlString+"]");
		System.out.println("xmlString1["+xmlString1+"]");
		System.out.println("xmlString2["+xmlString2+"]");
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = parseString(xmlString); 
			}
			else
			{
				System.out.println("xmlstring is null");
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = parseString(xmlString1); 
			}
			else
			{
				System.out.println("xmlstring1 is null");
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = parseString(xmlString2);
			}
			else
			{
				System.out.println("xmlstring2 is null");
			}
			System.out.println("Before call valdata");
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [EmpPayrollInfo][wfValData(String xmlString)] : ==>\n"+e.getMessage());
			e.printStackTrace();
			errString = genericUtility.createErrorString(e);
			
		}
		return (errString); 
	}

	public String wfValData(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
	
		Node parentNode = null;
		Node childNode = null;

		NodeList parentNodeList = null;
		NodeList childNodeList = null;

		String errString = "";
		String childNodeName = "";	

		int currentFormNo = 0;		
		int childNodeListLength = 0;

		 
		String msgType = "";
		String errCode = "";
		String errFldName = "";
		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");

		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();

		int cnt = 0;
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;


		//Varibles used in case 1 Start
		String userId = "";
		String empCode = "";
		String acctCodeSal = "";
		String cctrCodeSal = "";
		String stanCode = "";
		String payMode = "";
		String stanCodeHq = "";
		String bankCode = "";
		String paySite = "";
		String bankAcct = "";
		String basic = "";
		String gross = "";
		//Varibles used in  case 1 End

		int ctr = 0;		
		int count = 0;	
		
		//Modified By Hemlata on[20/11/2014] [As per changes in framework to use genericUtility ][Start]
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new E12GenericUtility();
		//Modified By Hemlata on[20/11/2014] [As per changes in framework to use genericUtility ][End]
		
		Connection conn = null;
		try
		{
			
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver");
			conn.setAutoCommit(false);
			
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			
			switch(currentFormNo)
			{
				case 1:
				{
					parentNodeList = dom.getElementsByTagName("Detail"+currentFormNo);
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();

					for(ctr = 0; ctr < childNodeListLength; ctr++)
					{
						childNode = childNodeList.item(ctr);
						
						System.out.println("childNode"+childNode);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}

						childNodeName = childNode.getNodeName();
						
						if(childNodeName.equalsIgnoreCase("acct_code__sal"))
						{ 
							count = 0;
							acctCodeSal = genericUtility.getColumnValue("acct_code__sal",dom,objContext);
							System.out.println("acctCodeSal got in the validation ..::["+acctCodeSal+"]");
							
							if(acctCodeSal != null && acctCodeSal.length() > 0)
							{
								sql = " SELECT COUNT(*) AS ACCOUNT_CNT FROM ACCOUNTS WHERE ACCT_CODE = ?  ";
								pstmt = conn.prepareStatement(sql);		
								pstmt.setString(1,acctCodeSal);	
								rs = pstmt.executeQuery();		
								if( rs.next())
								{
									count  = rs.getInt("ACCOUNT_CNT");
								}
								System.out.println("count:::: "+count);
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								
								if(count == 0)
								{
									System.out.println("Invalid account code, not defined in master::::");
									
									errList.add( "VMACCT1" );
									errFields.add( childNodeName.toLowerCase() );
									
									msgType =  errorType( conn , "VMACCT1" );
									if ( msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}
						if(childNodeName.equalsIgnoreCase("cctr_code__sal"))
						{
							cctrCodeSal = genericUtility.getColumnValue("cctr_code__sal",dom,objContext);
							System.out.println("cctrCodeSal got in the validation ..::["+cctrCodeSal+"]");
							
							String cctrCode =  getEnv( "999999",  "CCTR_YESNO", conn);
							System.out.println("cctrCode .::["+cctrCode+"]");
							
							if(cctrCode.equalsIgnoreCase("NULLFOUND"))
							{
								System.out.println("Invalid cctrCode, not defined in master::::");
								
								errList.add( "VSENVAR1" );
								errFields.add( childNodeName.toLowerCase() );
								
								msgType =  errorType( conn , "VSENVAR1" );
								if ( msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							else	
							{
								if(cctrCodeSal != null && cctrCodeSal.length() > 0)
								{
									count = 0;
									
									sql = " SELECT COUNT(*) AS COSTCTR_CNT FROM COSTCTR WHERE CCTR_CODE = ?  ";
									
									pstmt = conn.prepareStatement(sql);		
									pstmt.setString(1,cctrCodeSal);	
									rs = pstmt.executeQuery();		
									if( rs.next())
									{
										count  = rs.getInt("COSTCTR_CNT");
									}
									System.out.println("count:::: "+count);
									if ( rs != null )
									{
										rs.close();
										rs = null;
									}
									if ( pstmt != null )
									{
										pstmt.close();
										pstmt = null;
									}
									
									if(count == 0)
									{
										System.out.println("Invalid cost cemter code, not defined in master::::");
										
										errList.add( "VMCCTR1" );
										errFields.add( childNodeName.toLowerCase() );
										
										msgType =  errorType( conn , "VMCCTR1" );
										if ( msgType.equalsIgnoreCase("E"))
										{
											break;
										}
									}
								}
								else
								{
									if(cctrCode.equalsIgnoreCase("N"))
									{
										System.out.println("Invalid cost cemter code, not defined in master::::");
									
										errList.add( "VMCCTR1" );
										errFields.add( childNodeName.toLowerCase() );
										
										msgType =  errorType( conn , "VMCCTR1" );
										if ( msgType.equalsIgnoreCase("E"))
										{
											break;
										}
									}
								}
							}
						}
						if(childNodeName.equalsIgnoreCase("stan_code"))
						{
							stanCode = genericUtility.getColumnValue("stan_code",dom,objContext);
							System.out.println("stanCode got in the validation ..::["+stanCode+"]");
							
							if(stanCode != null && stanCode.length() > 0 )
							{
								count = 0;
								
								sql = " SELECT COUNT(*) AS STATION_CNT FROM STATION WHERE STAN_CODE = ?  ";
								
								pstmt = conn.prepareStatement(sql);		
								pstmt.setString(1,stanCode);	
								rs = pstmt.executeQuery();		
								if( rs.next())
								{
									count  = rs.getInt("STATION_CNT");
								}
								System.out.println("count:::: "+count);
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								if(count == 0)
								{
									System.out.println("Invalid station code, not defined in master::::");
									
									errList.add( "VESTACD1" );
									errFields.add( childNodeName.toLowerCase() );
									
									msgType =  errorType( conn , "VESTACD1" );
									if ( msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
							
							payMode = genericUtility.getColumnValue("pay_mode",dom,objContext);
							System.out.println("payMode ::::::::::: "+payMode);
							
							if(payMode != null && payMode.trim().length() > 0)
							{
								if( payMode.trim().equalsIgnoreCase("D") || payMode.trim().equalsIgnoreCase("T") )
								{
									if(stanCode == null || stanCode.trim().length() == 0)
									{
										System.out.println("Station Code can not be empty when paymode Demand Draft or transferr::::");
										
										errList.add( "VESTACD2" );
										errFields.add( childNodeName.toLowerCase() );
										
										msgType =  errorType( conn , "VESTACD2" );
										if ( msgType.equalsIgnoreCase("E"))
										{
											break;
										}
									}
								}
							}
						}
						if(childNodeName.equalsIgnoreCase("stan_code__hq"))
						{
							stanCodeHq = genericUtility.getColumnValue("stan_code__hq",dom,objContext);
							System.out.println("stanCode got in the validation ..::["+stanCodeHq+"]");
							
							if(stanCodeHq != null && stanCodeHq.length() > 0 )
							{
								count = 0;
								
								sql = " SELECT COUNT(*) AS STATION_CNT FROM STATION WHERE STAN_CODE = ? ";
								
								pstmt = conn.prepareStatement(sql);		
								pstmt.setString(1,stanCodeHq);	
								rs = pstmt.executeQuery();		
								if( rs.next())
								{
									count  = rs.getInt("STATION_CNT");
								}
								System.out.println("count:::: "+count);
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								if(count == 0)
								{
									System.out.println("Invalid station code, not defined in master::::");
									
									errList.add( "VESTACD1" );
									errFields.add( childNodeName.toLowerCase() );
									
									msgType =  errorType( conn , "VESTACD1" );
									if ( msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}
						if(childNodeName.equalsIgnoreCase("bank_code"))
						{
							payMode = genericUtility.getColumnValue("pay_mode",dom,objContext);
							System.out.println("payMode ::::::::::: "+payMode);
							bankCode = genericUtility.getColumnValue("bank_code",dom,objContext);
							System.out.println("bankCode got in the validation ..::["+bankCode+"]");
							
							if(payMode != null && payMode.trim().length() > 0)
							{
								if( payMode.trim().equalsIgnoreCase("D") || payMode.trim().equalsIgnoreCase("T") )
								{
									if(bankCode == null || bankCode.length() == 0)
									{
										System.out.println("Bank code can not be blank when paymode Demand Draft or transfer::::");
										
										errList.add( "VMEMPPAY01" );
										errFields.add( childNodeName.toLowerCase() );
										
										msgType =  errorType( conn , "VMEMPPAY01" );
										if ( msgType.equalsIgnoreCase("E"))
										{
											break;
										}	
									}
								}
							}
							System.out.println("bankCode != null"+bankCode != null);
							
							if(bankCode != null && bankCode.length() > 0) 
							{
								count = 0;
								
								sql = " SELECT COUNT(*) AS BANK_CNT FROM BANK WHERE BANK_CODE = ? ";
								
								pstmt = conn.prepareStatement(sql);		
								pstmt.setString(1,bankCode);	
								rs = pstmt.executeQuery();		
								if( rs.next())
								{
									count  = rs.getInt("BANK_CNT");
								}
								System.out.println("count:::: "+count);
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								if(count == 0)
								{
									System.out.println("Invalid bank code, not defined in masterr::::");
									
									errList.add( "VMBANK1" );
									errFields.add( childNodeName.toLowerCase() );
									
									msgType =  errorType( conn , "VMBANK1" );
									if ( msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
								else
								{
									stanCode = genericUtility.getColumnValue("stan_code",dom,objContext);
									System.out.println("stanCode got in the validation ..::["+stanCode+"]");
									
									empCode = genericUtility.getColumnValue("emp_code",dom,objContext);
									System.out.println("empCode got in the validation ..::["+empCode+"]");
									
									if(stanCode != null && stanCode.length() > 0)
									{
										count = 0;
										
										sql= " SELECT COUNT(*) AS BANK_STAN_SERV_CNT FROM BANK_STAN_SERV WHERE BANK_CODE = ? AND STAN_CODE = ? ";
										
										pstmt = conn.prepareStatement(sql);		
										pstmt.setString(1,bankCode);	
										pstmt.setString(2,stanCode);	
										rs = pstmt.executeQuery();		
										if( rs.next())
										{
											count  = rs.getInt("BANK_STAN_SERV_CNT");
										}
										System.out.println("count:::: "+count);
										if ( rs != null )
										{
											rs.close();
											rs = null;
										}
										if ( pstmt != null )
										{
											pstmt.close();
											pstmt = null;
										}
										if(count == 0)
										{
											System.out.println("bank station service not defined::::");
											
											errList.add( "VTBKSTAN" );
											errFields.add( childNodeName.toLowerCase() );
											
											msgType =  errorType( conn , "VTBKSTAN" );
											if ( msgType.equalsIgnoreCase("E"))
											{
												break;
											}
										}
										else
										{
											sql = " SELECT PAY_SITE  FROM EMPLOYEE WHERE EMP_CODE = ? ";
											
											pstmt = conn.prepareStatement(sql);		
											pstmt.setString(1,empCode);	
											rs = pstmt.executeQuery();		
											if( rs.next())
											{
												paySite  = rs.getString("PAY_SITE");
											}
											System.out.println("paySite:::: "+paySite);
											if ( rs != null )
											{
												rs.close();
												rs = null;
											}
											if ( pstmt != null )
											{
												pstmt.close();
												pstmt = null;
											}
											
											if(paySite != null && paySite.trim().length() > 0)
											{
												sql= " SELECT COUNT(*) AS BANK_CNT FROM BANK WHERE BANK_CODE = ? AND SITE_CODE = (SELECT SITE_CODE__ACCT FROM SITE WHERE SITE_CODE = ?)"; 
												pstmt = conn.prepareStatement(sql);	
												pstmt.setString(1,bankCode);	
												pstmt.setString(2,paySite);	
												rs = pstmt.executeQuery();		
												if( rs.next())
												{
													count  = rs.getInt("BANK_CNT");
												}
												System.out.println("count:::: "+count);
												if ( rs != null )
												{
													rs.close();
													rs = null;
												}
												if ( pstmt != null )
												{
													pstmt.close();
													pstmt = null;
												}
												if(count == 0)
												{
													System.out.println("Pay Site not defined::::");
													
													errList.add( "VTBKPAY" );
													errFields.add( childNodeName.toLowerCase() );
													
													msgType =  errorType( conn , "VTBKPAY" );
													if ( msgType.equalsIgnoreCase("E"))
													{
														break;
													}
												}
											}
										}
									}
								}
							}
						}
						if(childNodeName.equalsIgnoreCase("bank_acct"))
						{						
							bankAcct = genericUtility.getColumnValue("bank_acct",dom,objContext);
							System.out.println("bank_acct ::::::::::: "+bankAcct);
							
							payMode = genericUtility.getColumnValue("pay_mode",dom,objContext);
							System.out.println("payMode ::::::::::: "+payMode);
							
							if(payMode.trim().equalsIgnoreCase("T"))
							{
								 if(bankAcct == null || bankAcct.trim().length() == 0)
								{
									System.out.println("Bank ACCT Can not be blank::::");
									
									errList.add( "VTBANKACC" );
									errFields.add( childNodeName.toLowerCase() );
									
									msgType =  errorType( conn , "VTBANKACC" );
									if ( msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}
						if(childNodeName.equalsIgnoreCase("basic"))
						{	
							basic = genericUtility.getColumnValue("basic",dom,objContext);
							System.out.println("basic ::::::::::: "+basic);
							
							if(basic == null || basic.trim().length()  == 0)
							{
								System.out.println("Basic per month Can not be blank::::");
								
								errList.add( "VMEMPPAY02" );
								errFields.add( childNodeName.toLowerCase() );
								
								msgType =  errorType( conn , "VMEMPPAY02" );
								if ( msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							else if(basic != null && basic.trim().length() > 0)
							{
								try
								{
									if(Integer.parseInt(basic) < 0)
									{
										System.out.println("Basic per month Can not ne Less than zero::::");
										
										errList.add( "VMEMPPAY03" );
										errFields.add( childNodeName.toLowerCase() );
										
										msgType =  errorType( conn , "VMEMPPAY03" );
										if ( msgType.equalsIgnoreCase("E"))
										{
											break;
										}
									}
									
								}
								catch (Exception e)
								{
									errList.add( "VMEMPPAY06" );
									errFields.add( childNodeName.toLowerCase() );
									
									msgType =  errorType( conn , "VMEMPPAY06" );
									if ( msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}
						if(childNodeName.equalsIgnoreCase("gross"))
						{	
							gross = genericUtility.getColumnValue("gross",dom,objContext);
							System.out.println("gross ::::::::::: "+gross);
							
							if(gross == null || gross.trim().length() == 0)
							{
								System.out.println("Gross Per Annum Can not be blank::::");
								
								errList.add( "VMEMPPAY04" );
								errFields.add( childNodeName.toLowerCase() );
								
								msgType =  errorType( conn , "VMEMPPAY04" );
								if ( msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							else	if(gross != null && gross.trim().length() > 0)
							{
								try
								{
									if(Integer.parseInt(gross) < 0)
									{
										System.out.println("Gross Per Annum Can not ne Less than zero::::");
										
										errList.add( "VMEMPPAY05" );
										errFields.add( childNodeName.toLowerCase() );
										
										msgType =  errorType( conn , "VMEMPPAY05" );
										if ( msgType.equalsIgnoreCase("E"))
										{
											break;
										}
									}
								}
								catch (Exception e)
								{
									errList.add( "VMEMPPAY06" );
									errFields.add( childNodeName.toLowerCase() );
									
									msgType =  errorType( conn , "VMEMPPAY06" );
									if ( msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}
				}
			}//End of case
			break;		
		}//End of Switch
			int errListSize = errList.size();
				if ( errList != null && errListSize > 0 )
				{
					for (cnt = 0; cnt < errListSize; cnt++ )
					{
						errCode = (String)errList.get(cnt);
						errFldName = (String)errFields.get(cnt);
						System.out.println("errCode .........."+errCode);
						
						errString = getErrorString( errFldName, errCode, userId );
						System.out.println("errString is : ::::>>>> " + errString);
						msgType =  errorType( conn , errCode );
						if ( errString.length() > 0)
						{
							String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8,errString.indexOf("<trace>"));
							bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8,errString.indexOf("</Errors>"));
							errStringXml.append(bifurErrString);
							System.out.println("errStringXml .........."+errStringXml);
							errString = "";
						}
						if ( msgType.equalsIgnoreCase("E"))
						{
							break;
						}
					}
					errList.clear();
					errList = null;
					errFields.clear();
					errFields = null;
					
					errStringXml.append("</Errors></Root>\r\n");
				}
				else
				{
					errStringXml = new StringBuffer( "" );
				}
				errString = errStringXml.toString();

		}
		catch(Exception e)
		{
			System.out.println( "Exception : [EmpPayrollInfo][wfValData(String xmlString)] : ==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e1)
			{
				System.out.println( "Exception : [EmpPayrollInfo][wfValData] : ==>\n"+e1.getMessage());
				throw new ITMException(e1);
			}
		}

	
		return errString;
	}
	//Start of wfValData End


	private String checkNull( String input )
	{
		if (input == null)
		{
			input = "";
		}
		else
		{
			input = input.trim();
		}
		return input;
	}
	private String getObjName(Document dom,String objContext)
	{	
		Node elementName = null;
		NodeList elementList = null;
		String objName = "";
		elementList = dom.getElementsByTagName("Detail"+objContext);
		elementName = elementList.item(0);
		if (elementName!=null && ("Detail"+objContext).equalsIgnoreCase(elementName.getNodeName()))
		{
			NamedNodeMap etlAttributes = elementName.getAttributes();
			if (etlAttributes!=null)
			{
				if (etlAttributes.getNamedItem("objName")!=null)
				{
					objName = etlAttributes.getNamedItem("objName").getNodeValue();
				}
			}
		}
		return objName;
	}

	private String errorType( Connection conn , String errorCode ) throws ITMException
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ? ";
			
			pstmt = conn.prepareStatement( sql );			
			pstmt.setString(1, errorCode);			
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
			throw new ITMException(ex);
		}		
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}		
		return msgType;
	}

	public String getEnv(String prdCode, String varName,Connection conn)
	{
		String retValue = "";
		String sql = "";
		Statement stmt = null;
		ResultSet rs = null;
		try
		{
			sql = "SELECT VAR_VALUE FROM PAYRPARM "  
			   	+ "WHERE PRD_CODE = '" + prdCode + "' AND VAR_NAME = '" + varName + "'";
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);
			if (rs.next())
			{
				retValue = rs.getString(1);
			}
			else
			{
				retValue = "NULLFOUND";
			}
			rs.close();
			stmt.close();
		}
		catch (SQLException se)
		{
			System.out.println("Exception :ITMDBAccessEJB :getEnvFin:" + se.getMessage() + ":");
			se.printStackTrace();
		}
		catch (Exception e)
		{
			System.out.println("Exception :ITMDBAccessEJB :getEnvFin:" + e.getMessage() + ":");
			e.printStackTrace();
		}
	//	System.out.println("Returning Value From getEnvFin() :: "+retValue);  
		return retValue;
	}
}