package ibase.e12ria.e12widgets.gwtmedia.client.player;

import ibase.e12ria.e12widgets.gwtmedia.client.event.HasPlayStateHandlers;
import ibase.e12ria.e12widgets.gwtmedia.client.event.PlayEvent;
import ibase.e12ria.e12widgets.gwtmedia.client.event.PlayStateHandler;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Widget;

public abstract class MediaPlayer extends Widget implements IsMediaPlayer, HasPlayStateHandlers {

	protected final String playerId = DOM.createUniqueId();
	protected final String src;
	
	protected List<PlayStateHandler> handlers = new ArrayList<PlayStateHandler>();
	
	protected PlayState state;
	
	public MediaPlayer(String src) {
		this.src = src;
		Element e = DOM.createElement("embed");
		e.setId(playerId);
		e.setAttribute("src", src);
		setElement(e);
	}

	@Override
	public HandlerRegistration addPlayStateHandler(PlayStateHandler handler) {
		if (handler != null) {
			handlers.add(handler);
		}
		return null;
	}
	
	protected void firePlayEvent(PlayState newState) {
		switch (newState) {
		case PAUSED:
			PlayEvent.fire(handlers, PlayEvent.ONPAUSE);
			break;
		case PLAYING:
			PlayEvent.fire(handlers, PlayEvent.ONPLAY);
			break;
		case STOPPED:
			PlayEvent.fire(handlers, PlayEvent.ONSTOP);
			break;
		}
	}

	@Override
	public void play() {
		state = PlayState.PLAYING;
		firePlayEvent(state);
	}

	@Override
	public void pause() {
		state = PlayState.PAUSED;
		firePlayEvent(state);
	}

	@Override
	public void stop() {
		state = PlayState.STOPPED;
		firePlayEvent(state);
	}

}
