package ibase.utility;

import ibase.bean.ConnParams;
import ibase.java.MetisUpdate;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CommonUtil 
{
	Logger logger = Logger.getLogger(CommonUtil.class);
	
	public void message(String magStr) 
	{
		JOptionPane.showMessageDialog(null, magStr);	
	}
	
	
	public Connection getConnection() throws Exception
    {
		logger.info("Inside Getting Connection............");
        Connection connection = null;
		ConnParams connParams = setConnParams();
        try
        {
        	Class.forName(connParams.getDriverName());
        	String encodedPass = decrypt(readPasswordFromFile(connParams.getDatabasePassword()));
        	connection = DriverManager.getConnection(connParams.getDriverUrl(), connParams.getDatabaseUsername(), encodedPass);
		logger.debug("Connection:"+connection);
        }
        catch(Exception e)
        {
			System.out.println("Connection Not Established([" + connParams.getDriverName() + "][" + connParams.getDriverUrl() + "][" + connParams.getDriverUrl() + "] ?????????");
			logger.error("Connection Not Established([" + connParams.getDriverName() + "][" + connParams.getDriverUrl() + "][" + connParams.getDriverUrl() + "] ?????????");
			logger.error("Exception: CommonUtil: getConnection: Generic Exception==>\n" + e);
			
			throw e;
        }	
        logger.info("Connection Established");
		return connection;
    }

	private ConnParams setConnParams() throws ParserConfigurationException, SAXException, IOException {
		logger.info("Inside set connection params...........");
		ConnParams connParams = new ConnParams();
		String current = System.getProperty("user.dir");
       logger.info("working directory in Java : " + current);

		//File fXmlFile = new File("/home/base/Desktop/XML Files/Driver.xml");
        File fXmlFile = new File(current+"/Driver.xml");
		
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
		DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
		org.w3c.dom.Document document =  dBuilder.parse(fXmlFile);
		NodeList parentNodeList = document.getElementsByTagName("dbconfig");
		Node parentNode = parentNodeList.item(0);
		NodeList childNodeList = parentNode.getChildNodes();
		for(int i =0;i<childNodeList.getLength();i++)
		{
			//System.out.println("for loop"+i);
			Node node = childNodeList.item(i);
			//System.out.println("NodeName="+node.getNodeName());
			if(node.getNodeName().equals("driverURL"))
			{
				//System.out.println("NodeValue="+node.getFirstChild().getNodeValue());
				connParams.setDriverUrl(node.getFirstChild().getNodeValue());
			}
			if(node.getNodeName().equals("username"))
			{
				//System.out.println("NodeValue="+node.getFirstChild().getNodeValue());
				connParams.setDatabaseUsername(node.getFirstChild().getNodeValue());
			}
			if(node.getNodeName().equals("passwordFile"))
			{
				//System.out.println("NodeValue="+node.getFirstChild().getNodeValue());
				connParams.setDatabasePassword(node.getFirstChild().getNodeValue());
			}
			if(node.getNodeName().equals("drivername"))
			{
				//System.out.println("NodeValue="+node.getFirstChild().getNodeValue());
				connParams.setDriverName(node.getFirstChild().getNodeValue());
			}
		}
		
		return connParams;
	}
	private String readPasswordFromFile(String ipwFile)
	{
		String pass = "";
		try
		{
			String fileName =  System.getProperty("user.dir") +"/"+ ipwFile;
			logger.info("ReadPasswordFromFile:"+fileName);
			
			ByteArrayOutputStream baos=new ByteArrayOutputStream();

			FileInputStream isr = new FileInputStream(fileName);

			StringBuffer passStrBuff = new StringBuffer();
			int i=-1;
			while ( ( i = isr.read() ) !=-1 )
			{
				baos.write(i);
			}
			
			pass = baos.toString("ISO-8859-1");

			baos.close();
			isr.close();
		}
		catch(Exception e)
		{
			System.out.println("Exception: CommonUtil: readPasswordFromFile(String):==>\n"+e.getMessage());
		}
		//System.out.println("password:"+pass);
		return pass;
	}

	private static String decrypt(String as_passwd)
	{
		String ls_return = "";
		try
		{
			int li_len, li_count, li_Seed, li_passAsc, li_seedcount;
			li_len = as_passwd.length();
			li_seedcount = 1;
			for(li_count = 0; li_count<li_len; li_count+=2)
			{
				li_Seed = ((int )as_passwd.charAt(li_count + 1 ) )  - li_seedcount ;
				li_passAsc = ((int )as_passwd.charAt(li_count ) ) - li_seedcount ;
				li_passAsc = li_passAsc - li_Seed;
				ls_return += (char)(li_passAsc);
				li_seedcount ++;
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception: ConnDriver: decrypt(String):==>\n"+e.getMessage());
			//throw e;
		}
		//System.out.println("password:"+ls_return);
		return ls_return;
	}
	
	public static Logger getLogger(Class clazz,String myLogFile){

	    org.apache.log4j.Logger log = Logger.getLogger(clazz);
	    Properties props=new Properties();
	   /* props.setProperty("log4j.appender.file","org.apache.log4j.RollingFileAppender");
	     props.setProperty("log4j.appender.logfile","org.apache.log4j.DailyRollingFileAppender");
	    props.setProperty("log4j.appender.logfile.DatePattern","'.'yyyy-MM-dd");
	    props.setProperty("log4j.appender.logfile.layout","org.apache.log4j.PatternLayout");
	    props.setProperty("log4j.appender.logfile.layout.ConversionPattern","%d{yyyy-MM-dd HH:mm:ss} %-5p %c{1}:%L - %m%n");
	    props.setProperty("log4j.appender.logfile.File",myLogFile);
	    props.setProperty("log4j.logger.com.com.test.log4j.conf","INFO, logfile");
*/
	    
	  
	   //log4j.rootLogger=debug,ERROR,INFO,CONSOLE,R
	    props.setProperty("log4j.rootLogger","debug,ERROR,INFO,CONSOLE,R");
	  
	    //log4j.appender.CONSOLE=org.apache.log4j.ConsoleAppender
	   props.setProperty("log4j.appender.CONSOLE","org.apache.log4j.ConsoleAppender");
	  
	    //log4j.appender.CONSOLE.layout=org.apache.log4j.PatternLayout
	    props.setProperty("log4j.appender.CONSOLE.layout","org.apache.log4j.PatternLayout");
	  
	    //log4j.appender.CONSOLE.layout.ConversionPattern=%5p [%t] (%F:%L) - %m%n
	    props.setProperty("log4j.appender.CONSOLE.layout.ConversionPattern","%5p [%t] (%F:%L) - %m%n");
	  
	   // log4j.appender.R=org.apache.log4j.RollingFileAppender
	    props.setProperty("log4j.appender.R","org.apache.log4j.RollingFileAppender");
	  
	    // log4j.appender.R.File=update.log
  		props.setProperty("log4j.appender.R.File",myLogFile);
	  
	    //log4j.appender.R.Target=System.out
  		props.setProperty("log4j.appender.R.Target","System.out");
	  
	   // log4j.appender.R.MaxFileSize=200KB
  		props.setProperty("log4j.appender.file","org.apache.log4j.RollingFileAppender");
	  
	   //  log4j.appender.R.MaxBackupIndex=2
	    props.setProperty("log4j.appender.R.MaxFileSize","2");
	  
	   // log4j.appender.R.layout=org.apache.log4j.PatternLayout
	    props.setProperty("log4j.appender.R.layout","org.apache.log4j.PatternLayout");
	  
	   // log4j.appender.R.layout.ConversionPattern=%d - %c - %p - %m%n
	    props.setProperty("log4j.appender.R.layout.ConversionPattern","%d - %c - %p - %m%n");
	  
	    
	    
	    
	    
	    PropertyConfigurator.configure(props);
	    return log;

	}
	public FileAppender getLogAppender(String ptcn) 
	{
		FileAppender appender = new FileAppender();
	    appender.setName("ptcnLog");
	    appender.setLayout(new PatternLayout("%d %-5p [%c{1}] %m%n"));
	    appender.setFile("logs/"+ptcn+".log");
	    appender.setAppend(true);
	    appender.setThreshold(Level.ERROR);
	    appender.setThreshold(Level.INFO);
	    appender.setThreshold(Level.DEBUG);
	    //appender.setThreshold(Level.ERROR);
	    appender.activateOptions();
	    return appender;
	}
	
}
