/*
 * Author:Wasim Ansari
 * Date:03-05-2017
 * Request ID:F17BBAS001 (GST Wizard Post Save Component for Reconciliation Trace)
 */
package ibase.webitm.ejb.gst;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import javax.ejb.Stateless;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class GSTRecoWizPosEJB extends ValidatorEJB implements GSTRecoWizPosEJBRemote,GSTRecoWizPosEJBLocal 
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
    /**
     * Default constructor. 
     */
    public GSTRecoWizPosEJB() {
        // TODO Auto-generated constructor stub
    }

	@Override
	public String postSave(String xmlStringAll, String tranID, String editFlag, String xtraParams, Connection conn) throws RemoteException, ITMException 
	{
		String retString="";
		try 
		{
			retString = postSave(xmlStringAll, xtraParams, "", conn);
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}
	
		
	public String postSave(String xmlstring, String xtraParams, String forcedFlag, Connection conn) throws RemoteException,ITMException
	{
		System.out.println("Inside GSTWizardPosEJB Post Save ["+xmlstring+"] \n xtraParams ["+xtraParams+"] \n forcedFlag["+forcedFlag+"]");
		
		PreparedStatement pstmt = null,pstmtUpd = null;
		ResultSet rs = null;
		
		boolean isError = false,isLocCon = false;
		Document dom = null;

		String sql = "",retString = "",tranID = "", tranIdGSTN = "";
		ArrayList<String> tranIDList = new ArrayList<String>();
		String tranIDStr = "",submitType = "";
		int cnt = 0;
		
		HashSet<String> hs = new HashSet<String>();
		
		try
		{	
			if(conn == null || conn.isClosed())
			{
				System.out.println("@@Connection is null");
				conn = getConnection();
				isLocCon = true;
			}
			else
			{
				System.out.println("@@Connection is not null");
			}
			
			if(xmlstring != null &&  (xmlstring.indexOf("Detail2") != -1))
			{
				sql = " INSERT INTO GSTRECO_TRACE (TRAN_ID,TRAN_ID__GSTN) "
				     +" VALUES ( ? , ?) ";
			    pstmt = conn.prepareStatement(sql);
			    
			    sql = " UPDATE GST_DATA_HDR SET RECO_STATUS = ?,SUBMISSION_TYPE = ? WHERE TRAN_ID IN (?,?) ";
				pstmtUpd = conn.prepareStatement(sql);
			    
			    dom = genericUtility.parseString(xmlstring); 
				
				NodeList detail2NodeList =dom.getElementsByTagName("Detail2");
				int detail3NodeListlen = detail2NodeList.getLength();
				for(int ctrH = 0; ctrH < detail3NodeListlen ; ctrH++)
				{
					NodeList childNodeList = detail2NodeList.item(ctrH).getChildNodes();
					int childNodeListlen = childNodeList.getLength();
	
					for(int ctrD = 0; ctrD < childNodeListlen ; ctrD++)
					{
						Node childNode = childNodeList.item(ctrD);
						
						if(childNode != null && "tran_id".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							tranID = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else if(childNode != null && "tran_id__gstn".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							tranIdGSTN = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else if(childNode != null && "data_match".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							submitType = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
					}
					
					System.out.println("TranID ["+tranID+"] GSTN TranID["+tranIdGSTN+"] Submit Type["+submitType+"]");
					
					if(tranID.length() > 0 && tranIdGSTN.length() > 0)
					{
						if (hs.contains(tranID) || hs.contains(tranIdGSTN))
						{
							System.out.println("Already inserted");
						}
		  				else
						{
		  					hs.add(tranID);
		  					hs.add(tranIdGSTN);
		  					
		  					pstmt.setString(1, tranID);
							pstmt.setString(2, tranIdGSTN);
							pstmt.addBatch();
							pstmt.clearParameters();
							
							tranIDStr = tranIDStr +"'"+ tranID +"','"+ tranIdGSTN +"'," ;
							cnt++;
							
							
							if("X".equalsIgnoreCase(submitType))
							{
								submitType = "";
							}
							
							pstmtUpd.setString(1, "M");
							pstmtUpd.setString(2, submitType);
							pstmtUpd.setString(3, tranID);
							pstmtUpd.setString(4, tranIdGSTN);
							pstmtUpd.addBatch();
							pstmtUpd.clearParameters();
						}
					}
					else
					{
						System.out.println("Not inserted---->TranID ["+tranID+"] GSTN TranID["+tranIdGSTN+"]");
					}
				}
				
				System.out.println("Count["+cnt+"]");
				if(cnt > 0)
				{
					int updCount[] = pstmt.executeBatch();
					System.out.println("Rows Inserted-->"+updCount);
					
					if( pstmt != null )
					{
						pstmt.close();pstmt = null;
					}
					
					updCount = pstmtUpd.executeBatch();
					System.out.println("Rows updated-->"+updCount);
					
					//tranIDStr = tranIDStr.substring(0, tranIDStr.length()-1);
					
					/*sql = " UPDATE GST_DATA_HDR SET RECO_STATUS = 'M' WHERE TRAN_ID IN ("+tranIDStr+") ";
					pstmt = conn.prepareStatement(sql);
					pstmt.executeUpdate();
					
					if( pstmt != null )
					{
						pstmt.close();pstmt = null;
					}*/
				}
				if( pstmt != null )
				{
					pstmt.close();pstmt = null;
				}
				if(pstmtUpd != null)
				{
					pstmtUpd.close();pstmtUpd = null;
				}
				
			}//End if Detail2 not found
			else
			{
				System.out.println("Detail2 not found");
				retString = itmDBAccessLocal.getErrorString("","VTBLNKDTL","","",conn);
				return retString;
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception GSTWizardPosEJB ==>"+e.getMessage());
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("Inside finally GSTWizardPosEJB isError["+isError+"] connStatus["+isLocCon+"]");
				if (rs != null )
				{
					rs.close();rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();pstmt = null;
				}
				if(pstmtUpd != null)
				{
					pstmtUpd.close();pstmtUpd = null;
				}
				if(isLocCon)
				{
					if(isError)
					{
						System.out.println("Inside rollbacking....");
						conn.rollback();
					}
					else
					{
						System.out.println("Inside committing....");
						conn.commit();
					}
					if (conn != null )
					{
						conn.close();conn = null;
					}
				}
			}
			catch( Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println("errString from post save GSTWizardPosEJB =["+retString+"]");
		return retString;
	}
	
	private static String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
}
