package ibase.dashboard.ssc.servlet;
import ibase.dashboard.ssc.ejb.AcctPayableRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.simple.JSONObject;
import javax.servlet.http.HttpSession;

public class EfficiencyTrendServlet extends HttpServlet
{
    private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	@SuppressWarnings("unchecked")
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		AcctPayableRemote acctPayableRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		try
		{
			response.setContentType("application/xml");

			dataSourceName = request.getParameter("dataSourceName");
			context = new InitialContext(appConnectParm.getProperty());
			acctPayableRemote = (AcctPayableRemote) context.lookup("ibase/AcctPayable/remote");
			JSONObject jsonObjData = (JSONObject) acctPayableRemote.getEfficiencyTrend(dataSourceName);
			OutputStream outputStream   = response.getOutputStream();			
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set for EfficiencyTrendServlet build the Graph is===" + jsonObjData);
		
			

		} catch (Exception e)
		{
			System.out.println("Exception : EfficiencyTrendServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}

	}

}