package ibase.dashboard.epa.servlet;
  
import ibase.dashboard.epa.ejb.EmpProductivityRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.simple.JSONObject;
  
  public class TaskWiseTimeServlet extends HttpServlet
  {
    private static final long serialVersionUID = 1L;
  
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
    {
    doPost(request, response);
    }
  
    public void doPost(HttpServletRequest request, HttpServletResponse response)
      throws IOException, ServletException
    {
     EmpProductivityRemote empEffectivenessRemote = null;
     InitialContext context = null;
     AppConnectParm appConnectParm = new AppConnectParm();
     String dataSourceName = "";
     String frDate = "";
     String toDate = "";
     String topNos = "";
     String empTask= "",deptCode = "";
     String empCode= "",usageIntensity="",functionType="";
      try
      {
       response.setContentType("application/xml");
	   HttpSession session = request.getSession(true);
	   ibase.utility.UserInfoBean userInfo = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");
       dataSourceName = request.getParameter("dataSourceName");       
       frDate  = request.getParameter("frDate");
       toDate  = request.getParameter("toDate");
       empCode = request.getParameter("empCode");
       deptCode= request.getParameter("deptCode");
       usageIntensity= request.getParameter("usageIntensity");
       empTask       = request.getParameter("taskname");
	   functionType  = request.getParameter("service");
	   topNos        = request.getParameter("topNos");
       context       = new InitialContext(appConnectParm.getProperty());
       empEffectivenessRemote = (EmpProductivityRemote)context.lookup("ibase/EmpProductivity/remote");
       /*setUserInfo(userInfo) for DB connection on dated:14062016*/
       empEffectivenessRemote.setUserInfo(userInfo);
       JSONObject jsonObjData    = empEffectivenessRemote.getTaskWiseTimeServlet(dataSourceName, frDate,toDate,empCode,deptCode,usageIntensity,empTask,functionType,topNos);
       OutputStream outputStream = response.getOutputStream();
       outputStream.write(jsonObjData.toString().getBytes());
       outputStream.flush();
       outputStream.close();
      }
      catch (Exception e)
      {
       System.out.println("Exception : TaskWiseTimeServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
        try
        {
        throw new ITMException(e);
        }
        catch (ITMException e1) {
         e1.printStackTrace();
        }
      }
    }
  }

