package ibase.webitm.ejb.gst;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import javax.ejb.Stateless;

import org.apache.log4j.spi.ErrorCode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Session Bean implementation class GstrIC
 */
@Stateless
public class GstrIC extends ValidatorEJB implements GstrICRemote, GstrICLocal 
{
	E12GenericUtility genericUtility = new E12GenericUtility();
		
   	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag,String xtraParams) throws RemoteException, ITMException 
    {
   	   Document dom = null; 
   	   Document dom1 = null; 
   	   Document dom2 = null;
   	   String retString = "";	
       try
       {
    	    System.out.println("*************** Inside wfValData *******************");  	   		
	   		if(xmlString != null && xmlString.trim().length()>0)
	   		{
	   			dom = genericUtility.parseString(xmlString);		
	   		}
	   		if(xmlString1 != null && xmlString1.trim().length()>0)
	   		{
	   			dom1 = genericUtility.parseString(xmlString1);
	   		}
	   		if(xmlString2 != null && xmlString2.trim().length()>0)
	   		{
	   			dom2 = genericUtility.parseString(xmlString2);
	   		}
	   		retString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
	   		System.out.println("errorString::::::::::"+retString);
		}
        catch(Exception e)
        {
	        System.out.println(":::" + getClass().getSimpleName() + "::"+ e.getMessage());
			e.getMessage(); 
        }
        return retString;	    
	}
   	
	public String wfValData(Document dom, Document dom1, Document dom2,String objContext, String editFlag, String xtraParams)throws RemoteException, ITMException 
	{
		E12GenericUtility genericUtility = new E12GenericUtility();
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		String sql="";
		String userId = "";
		int currentFormNo = 0;
		NodeList parentNodeList = null;
		Node parentNode = null;
		NodeList childNodeList = null;
		Node childNode = null;
		int childNodeLength = 0;
	    int ctr = 0, cnt = 0;
		String childNodeName = "";
		String errorType = "",errString="";
		String errCode = "";
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		String site_code="";
		String rec_type="";
		String tran_type="";
		String submission_type="";
		String state_code="";
		String prd_code="";
		String reco_status="";
		String reas_code="";
		String cust_name = "",tax_reg_no = "";
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");
		try
		{
			conn = getConnection();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode"); 
			
		    if(objContext != null && objContext.trim().length()>0)
		    {
			    currentFormNo = Integer.parseInt(objContext);
			    System.out.println("currentFormNo:::"+currentFormNo);
		        switch(currentFormNo)
		    	{
		    		case 1:
		    		{	
		    			parentNodeList = dom.getElementsByTagName("Detail1");
		    			parentNode = parentNodeList.item(0);
		    			childNodeList = parentNode.getChildNodes();
		    			childNodeLength = childNodeList.getLength();
		    			
		    			for(ctr = 0; ctr < childNodeLength; ctr++)
		    			{
		    				childNode =  childNodeList.item(ctr);
		    				childNodeName = childNode.getNodeName();
		    				System.out.println("childNodeName:::"+childNodeName);
						
		    				if("site_code".equalsIgnoreCase(childNodeName))
		    				{
		    					site_code = checkNull(genericUtility.getColumnValue("site_code",dom)).trim();
		    					
		    					if(site_code != null && site_code.trim().length() > 0)
		    					{
		    						sql = "select count(*) as cnt from site where site_code=?";
		    						pstmt = conn.prepareStatement(sql);
		    						pstmt.setString(1,site_code);
		    						rs = pstmt.executeQuery();
		    						if(rs.next())
		    						{
		    							cnt = rs.getInt("cnt");
		    						}
		    						if(pstmt != null)
									{
									    pstmt.close(); 
									    pstmt = null;
									}
									if(rs != null)
									{
										rs.close();
									    rs = null;
									}
							    
		    						if(cnt==0)
		    						{
		    							errCode = "VTSITEXT";
		    							errList.add(errCode);
		    							errFields.add(childNodeName.toLowerCase());
		    						}
		    					}
		    				}// end of if block for site_code
		    				else if("prd_code".equalsIgnoreCase(childNodeName))
		    				{
		    					prd_code = checkNull(genericUtility.getColumnValue("prd_code", dom)).trim();
		    					
		    					if(prd_code == null || prd_code.trim().length() == 0)
		    					{
		    						errCode = "VPATDPRC01";
		    						errList.add(errCode);
		    						errFields.add(childNodeName.toLowerCase());
		    					}
		    					else 
		    					{
		    						prd_code = checkNull(genericUtility.getColumnValue("prd_code", dom)).trim();
		    						sql = "select count(*) as cnt from period where  TO_CHAR(TO_DATE(code,'yyyymm'),'mmyyyy')=?";
		    						pstmt = conn.prepareStatement(sql);
		    						pstmt.setString(1,prd_code);
		    						rs = pstmt.executeQuery();
		    						if(rs.next())
		    						{
		    							cnt = rs.getInt("cnt");
		    						}
		    						if(pstmt != null)
									{
									    pstmt.close(); 
									    pstmt = null;
									}
									if(rs != null)
									{
										rs.close();
									    rs = null;
									}
							    
		    						if(cnt==0)
		    						{
		    							errCode = "VTMONATD10";
		    							errList.add(errCode);
		    							errFields.add(childNodeName.toLowerCase());	
		    						}
		    					}							
		    				}// end of if block for prd_code
		    				else if("rec_type".equalsIgnoreCase(childNodeName))
		    				{
		    					rec_type = checkNull(genericUtility.getColumnValue("rec_type", dom)).trim();
		    					
		    					if(rec_type != null && rec_type.trim().length() > 0)
		    					{
		    						sql = "select count(*) as cnt from gencodes where fld_name='REC_TYPE' and fld_value=?";
		    						pstmt = conn.prepareStatement(sql);
		    						pstmt.setString(1,rec_type);
		    						rs = pstmt.executeQuery();
		    						if(rs.next())
		    						{
		    							cnt = rs.getInt("cnt");
		    						}
		    						if(pstmt != null)
									{
									    pstmt.close(); 
									    pstmt = null;
									}
									if(rs != null)
									{
										rs.close();
									    rs = null;
									}
							    
		    						if(cnt==0)
		    						{
		    							errCode = "INVRECTYPE";
		    							errList.add(errCode);
		    							errFields.add(childNodeName.toLowerCase());	
		    						}
		    					}
		    				}//end of if block for rec_type
		    				else if("tran_type".equalsIgnoreCase(childNodeName))
		    				{
		    					tran_type = checkNull(genericUtility.getColumnValue("tran_type", dom)).trim();
		    					
		    					if(tran_type == null || tran_type.trim().length() == 0)
		    					{
		    						errCode = "INVTRNTYPE";
		    						errList.add(errCode);
		    						errFields.add(childNodeName.toLowerCase());
		    					}
		    					else
		    					{
		    						tran_type = checkNull(genericUtility.getColumnValue("tran_type", dom)).trim();
		    						sql = "select count(*) as cnt from gencodes where fld_name='TRAN_TYPE' and fld_value=?";
		    						pstmt = conn.prepareStatement(sql);
		    						pstmt.setString(1,tran_type);
		    						rs = pstmt.executeQuery();
		    						if(rs.next())
		    						{
		    							cnt = rs.getInt("cnt");
		    						}
		    						if(pstmt != null)
									{
									    pstmt.close(); 
									    pstmt = null;
									}
									if(rs != null)
									{
										rs.close();
									    rs = null;
									} 
							    
		    						if(cnt==0)
		    						{
		    							errCode = "VMATRNTYPE";
		    							errList.add(errCode);
		    							errFields.add(childNodeName.toLowerCase());	
		    						}
		    					}		    					
		    				}//end of if block for tran_type
		    				else if("cust_name".equalsIgnoreCase(childNodeName))
		    				{
		    					tran_type = checkNull(genericUtility.getColumnValue("tran_type", dom)).trim();
		    					cust_name = checkNull(genericUtility.getColumnValue("cust_name", dom)).trim();
		    							    					
		    					if((tran_type.equalsIgnoreCase("03")) || (tran_type.equalsIgnoreCase("04")) || (tran_type.equalsIgnoreCase("05")) || tran_type.equalsIgnoreCase("06"))
	    						{
		    						if(cust_name == null || cust_name.trim().length() == 0)
			    					{
		    							errCode = "VMATTDET01";
			    						errList.add(errCode);
		    							errFields.add(childNodeName.toLowerCase());
			    					}
	    						}
		    				}//end of if block for cust_name
		    				else if("state_code".equalsIgnoreCase(childNodeName))
		    				{
		    					state_code = checkNull(genericUtility.getColumnValue("state_code", dom)).trim();
		    					
		    					if(state_code == null || state_code.trim().length() == 0)
		    					{
		    						errCode = "VMSTATE2";
		    						errList.add(errCode);
		    						errFields.add(childNodeName.toLowerCase());
		    					}	
		    					else
		    					{
		    						state_code = checkNull(genericUtility.getColumnValue("state_code", dom)).trim();
		    						sql = "select count(*) as cnt from state where state_code=?";
		    						pstmt = conn.prepareStatement(sql);
		    						pstmt.setString(1,state_code);
		    						rs = pstmt.executeQuery();
		    						if(rs.next())
		    						{
		    							cnt = rs.getInt("cnt");
		    						}
		    						if(pstmt != null)
									{
									    pstmt.close(); 
									    pstmt = null;
									}
									if(rs != null)
									{
										rs.close();
									    rs = null;
									}
									
		    						if(cnt==0)
		    						{
		    							errCode = "VESTATCD2";
		    							errList.add(errCode);
		    							errFields.add(childNodeName.toLowerCase());	
		    						}
		    					}
		    				}//end of if block for state_code
		    				else if("reas_code".equalsIgnoreCase(childNodeName))
		    				{
		    					reas_code = checkNull(genericUtility.getColumnValue("reas_code", dom)).trim();
		    					
		    					if(reas_code != null && reas_code.trim().length() > 0)
		    					{
		    						sql = "select count(*) as cnt from gencodes where fld_name='REAS_CODE' AND MOD_NAME='W_DRCRRCP_CR' AND fld_value=?";
		    						pstmt = conn.prepareStatement(sql);
		    						pstmt.setString(1,reas_code);
		    						rs = pstmt.executeQuery();
		    						if(rs.next())
		    						{
		    							cnt = rs.getInt("cnt");
		    						}
		    						if(pstmt != null)
									{
									    pstmt.close(); 
									    pstmt = null;
									}
									if(rs != null)
									{
										rs.close();
									    rs = null;
									}
									
		    						if(cnt == 0)
		    						{
		    							errCode = "VMREASCOIN";
		    							errList.add(errCode);
		    							errFields.add(childNodeName.toLowerCase());	
		    						}
		    					}
		    				}//end of if block for reas_code
		    				else if("reco_status".equalsIgnoreCase(childNodeName))
		    				{
		    					reco_status = checkNull(genericUtility.getColumnValue("reco_status", dom)).trim();
		    					
		    					if(reco_status != null && reco_status.trim().length() > 0)
		    					{
		    						sql= "select count(*) as cnt from gencodes where fld_name='RECO_STATUS' and fld_value=?";
		    						pstmt = conn.prepareStatement(sql);
		    						pstmt.setString(1,reco_status);
		    						rs = pstmt.executeQuery();
		    						if(rs.next())
		    						{
		    							cnt = rs.getInt("cnt");
		    						}
		    						if(pstmt != null)
									{
									    pstmt.close(); 
									    pstmt = null;
									}
									if(rs != null)
									{
										rs.close();
									    rs = null;
									}
		    						
		    						if(cnt == 0)
		    						{
		    							errCode = "INVRECNSTS";
		    							errList.add(errCode);
		    							errFields.add(childNodeName.toLowerCase());	
		    						}
		    					}
		    				}// end of if block for reco_status
		    				else if("tax_reg_no".equalsIgnoreCase(childNodeName))
		    				{
		    					tran_type = checkNull(genericUtility.getColumnValue("tran_type", dom)).trim();
		    					tax_reg_no = checkNull(genericUtility.getColumnValue("tax_reg_no", dom)).trim();
		    					
		    					if(tran_type.equalsIgnoreCase("07") || tran_type.equalsIgnoreCase("08") || tran_type.equalsIgnoreCase("12"))
		    					{
		    						if(tax_reg_no == null || tax_reg_no.trim().length() == 0)
		    						{
		    							errCode = "VMGTINCODE";
		    							errList.add(errCode);
		    							errFields.add(childNodeName.toLowerCase());	
		    						}
		    					}	    					
		    				}// end of if block for tax_reg_no
		    			}//end of for loop
		    		}//end of case1
		    		break;
		    		}
		        	int errListSize = errList.size();
		        	System.out.println("errListSize::::::::::"+errListSize);
		        	int count = 0;
		        	String errFldName = null;
		        	if (errList != null && errListSize > 0)
		        	{
		        		for (count = 0; count < errListSize; count++)
		        		{
		        			errCode = errList.get(count);
		        			errFldName = errFields.get(count);
		        			System.out.println(" testing :errCode .:" + errCode);
		        			errString = getErrorString(errFldName, errCode, userId);
		        			System.out.println("errString>>>>>>>>>"+errString);
		        			errorType = errorType(conn, errCode);
		        			if (errString.length() > 0)
		        			{
		        				String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
		        				bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
		        				errStringXml.append(bifurErrString);
		        				errString = "";
		        			}
		        			if (errorType.equalsIgnoreCase("E"))
		        			{
		        				break;
		        			}
		        		}
		        		errList.clear();
		        		errList = null;
		        		errFields.clear();
		        		errFields = null;
		        		errStringXml.append("</Errors> </Root> \r\n");
		        	} 
		        	else
		        	{
		        		errStringXml = new StringBuffer("");
		        	}
		      	}
			}//end of try block
			catch(Exception e)
			{
				System.out.println("Exception ::"+e);
				e.printStackTrace();
			}
			finally
			{
				try
				{
					if (conn != null)
					{
						if (rs != null)
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						conn.close();
					}
					conn = null;
				} 
				catch (Exception d)
				{
					d.printStackTrace();
					throw new ITMException(d);
				}
			}
			errString = errStringXml.toString();
			System.out.println("testing : final errString : " + errString);
			return errString;
		}
	
	private String checkNull(String input) 
	{
		return input == null ? "" : input;
	}

	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn,String editFlag, String xtraParams) throws RemoteException,ITMException 
	{
		Document dom=null;
		Document domhr=null;
		Document domAll=null;
		String retString="";
		try
		{
			System.out.println("**************  Inside itemChanged method ****************");
			if(xmlString != null && xmlString.trim().length()>0)
	   		{
				dom = genericUtility.parseString(xmlString);		
	   		}
			if(xmlString1 != null && xmlString1.trim().length()>0)
	   		{
				domhr = genericUtility.parseString(xmlString1);		
	   		}
			if(xmlString2 != null && xmlString2.trim().length()>0)
	   		{
				domAll = genericUtility.parseString(xmlString2);		
	   		}
			retString = itemChanged(dom,domhr,domAll,objContext,currentColumn,editFlag,xtraParams);	
			System.out.println("retString::::::::::"+retString);
		}
		catch(Exception e)
		{
			System.out.println(":::" + getClass().getSimpleName() + "::"+ e.getMessage());
			e.getMessage(); 	
		}
		return retString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2,String objContext, String currentColumn, String editFlag,String xtraParams) throws RemoteException, ITMException 
    {
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		int currentFormNo=0,ctr = 0;	
		StringBuffer valueXmlString = new StringBuffer();
		NodeList parentNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		NodeList childNodeList = null;
		int childNodeLength = 0;
		String childNodeName = "";
		String columnValue="";
		int childNodeListLength = 0;
		String tran_id__ref="",rec_type="",tran_type="",state_code="",reco_status="",site_code="",cust_code="",cust_name="";
		String sql="";
		String doc_no="";
		String docDateStr="";
		double amount=0.0;
		String recDescr ="",tranDescr="",stateDescr="",recoDescr="",siteDescr="";
		java.util.Date doc_date=null;
		String loginSite = "";
		SimpleDateFormat sdf;
		try
		{
			conn = getConnection();
			sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			System.out.println("[GstrIC] [itemChanged] :currentFormNo ....." +currentFormNo);
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			
			switch(currentFormNo)
			{
				case 1 :
				{					
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					valueXmlString.append("<Detail1>");
					childNodeListLength = childNodeList.getLength();
					System.out.println("currentColumn-------->>[" + currentColumn + "]");
					if("itm_default".equalsIgnoreCase(currentColumn.trim()))
					{
						loginSite = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");	
						valueXmlString.append("<tran_date>").append("<![CDATA[" + sdf.format(new Date())+ "]]>").append("</tran_date>");
						//*****************changes for rec_type non-editable fields **************************
						sql = "select fld_value,descr from gencodes where fld_name='REC_TYPE' and mod_name='W_GSTR'";
						pstmt = conn.prepareStatement(sql);
						rs = pstmt.executeQuery();
						while(rs.next())
						{
							rec_type = rs.getString("fld_value");
							recDescr = rs.getString("descr");
							if(rec_type.equalsIgnoreCase("1") && recDescr.equalsIgnoreCase("GSTR1"))
							{
								valueXmlString.append("<rec_type>").append("<![CDATA["+rec_type+"]]>").append("</rec_type>");
								valueXmlString.append("<rec_type_descr>").append("<![CDATA["+recDescr+"]]>").append("</rec_type_descr>");
							}
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}
						//*****************changes for rec_type non-editable fields **************************
					}//end of if block for itm_default
					else if("itm_defaultedit".equalsIgnoreCase(currentColumn.trim()))
					{
						tran_id__ref = checkNull(genericUtility.getColumnValue("tran_id__ref", dom));
						
						sql = "select doc_no,doc_date,amount from gst_data_hdr where tran_id=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,tran_id__ref);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							doc_no = rs.getString("doc_no");
							doc_date = rs.getTimestamp("doc_date");
							amount = rs.getDouble("amount");					 
							System.out.println("doc_no::"+doc_no +"\t"+"doc_date::"+doc_date+"amount::"+amount);
						}		
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}
					    
					    if(doc_date != null)
					    {
					    	docDateStr=genericUtility.getValidDateString((doc_date).toString(),genericUtility.getDBDateFormat(),genericUtility.getApplDateFormat());
					    }
					    else
					    {
					    	docDateStr = "";	
					    }			    
					    valueXmlString.append("<doc_no_old>").append("<![CDATA["+checkNull(doc_no)+"]]>").append("</doc_no_old>");
						valueXmlString.append("<doc_date_1>").append("<![CDATA["+checkNull(docDateStr)+"]]>").append("</doc_date_1>");
						valueXmlString.append("<amount_1>").append("<![CDATA["+amount+"]]>").append("</amount_1>");
											
						rec_type = genericUtility.getColumnValue("rec_type", dom);
						sql = "select descr from gencodes where fld_name='REC_TYPE' and fld_value=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,rec_type);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							recDescr = rs.getString("descr");
						    System.out.println("recDescr>>"+recDescr);
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}  
					    valueXmlString.append("<rec_type_descr>").append("<![CDATA["+recDescr+"]]>").append("</rec_type_descr>");		
					
					    tran_type = checkNull(genericUtility.getColumnValue("tran_type", dom));
					    sql = "select descr from gencodes where fld_name='TRAN_TYPE' and fld_value=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,tran_type);
						rs = pstmt.executeQuery();	
						if(rs.next())
						{
							tranDescr = rs.getString("descr");
							System.out.println("tranDescr>>"+tranDescr);	
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}		    
					    valueXmlString.append("<tran_type_descr>").append("<![CDATA["+tranDescr+"]]>").append("</tran_type_descr>");
					    
					    state_code = checkNull(genericUtility.getColumnValue("state_code", dom));
					    sql = "select descr from state where state_code=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,state_code);
						rs = pstmt.executeQuery();	
						if(rs.next())
						{
							stateDescr = rs.getString("descr");
							System.out.println("stateDescr>>"+stateDescr);	
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}		    
					    valueXmlString.append("<state_descr>").append("<![CDATA["+stateDescr+"]]>").append("</state_descr>");
				    
						reco_status = checkNull(genericUtility.getColumnValue("reco_status", dom));
						sql = "select descr from gencodes where fld_name='RECO_STATUS' and fld_value=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,reco_status);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
						    recoDescr = rs.getString("descr");
						    System.out.println("recoDescr>>"+recoDescr);
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}	
						valueXmlString.append("<reco_status_descr>").append("<![CDATA["+recoDescr+"]]>").append("</reco_status_descr>");
					
						site_code = checkNull(genericUtility.getColumnValue("site_code", dom));
						
						sql = "select descr from site where site_code=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,site_code);
					    rs = pstmt.executeQuery();
					    if(rs.next())
					    {
					    	siteDescr = rs.getString("descr");
					    	System.out.println("siteDescr>>"+siteDescr);
					    }
					    if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}	
					    valueXmlString.append("<site_code_descr>").append("<![CDATA["+siteDescr+"]]>").append("</site_code_descr>");			   
					}//end of if block for itm_defaultedit
					else if ("tran_id__ref".equalsIgnoreCase(currentColumn.trim()))
					{
						tran_id__ref = checkNull(genericUtility.getColumnValue("tran_id__ref", dom));
						
						sql = "select doc_no,doc_date,amount from gst_data_hdr where tran_id=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,tran_id__ref);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							doc_no = rs.getString("doc_no");
							doc_date = rs.getTimestamp("doc_date");
							amount = rs.getDouble("amount");					 
							System.out.println("doc_no::"+doc_no +"\t"+"doc_date::"+doc_date+"amount::"+amount);
						}		
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}
						if(doc_date != null)
						{
							docDateStr=genericUtility.getValidDateString((doc_date).toString(),genericUtility.getDBDateFormat(),genericUtility.getApplDateFormat());
						}
						else
						{
							docDateStr = "";	
						}			    
						valueXmlString.append("<doc_no_old>").append("<![CDATA["+checkNull(doc_no)+"]]>").append("</doc_no_old>");
						valueXmlString.append("<doc_date_1>").append("<![CDATA["+checkNull(docDateStr)+"]]>").append("</doc_date_1>");
						valueXmlString.append("<amount_1>").append("<![CDATA["+amount+"]]>").append("</amount_1>");
					}//end of if block for tran_id__ref	
					else if("tran_type".equalsIgnoreCase(currentColumn.trim()))
					{
						tran_type = checkNull(genericUtility.getColumnValue("tran_type", dom));
						
					    sql = "select descr from gencodes where fld_name='TRAN_TYPE' and fld_value=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,tran_type);
						rs = pstmt.executeQuery();	
						if(rs.next())
						{
							tranDescr = rs.getString("descr");
							System.out.println("descr>>"+tranDescr);	
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}		    
					    valueXmlString.append("<tran_type_descr>").append("<![CDATA["+tranDescr+"]]>").append("</tran_type_descr>");				
					}//end of if block for tran_type
					else if("state_code".equalsIgnoreCase(currentColumn.trim()))
					{
						state_code = checkNull(genericUtility.getColumnValue("state_code", dom));
						
					    sql = "select descr from state where state_code=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,state_code);
						rs = pstmt.executeQuery();	
						if(rs.next())
						{
							stateDescr = rs.getString("descr");
							System.out.println("descr>>"+stateDescr);	
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}		    
					    valueXmlString.append("<state_descr>").append("<![CDATA["+stateDescr+"]]>").append("</state_descr>");				
					}//end of if block for state_code
					else if("reco_status".equalsIgnoreCase(currentColumn.trim()))
					{
						reco_status = checkNull(genericUtility.getColumnValue("reco_status", dom));
						
						sql = "select descr from gencodes where fld_name='RECO_STATUS' and fld_value=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,reco_status);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							recoDescr = rs.getString("descr");
							System.out.println("recoDescr>>"+recoDescr);
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}	
						valueXmlString.append("<reco_status_descr>").append("<![CDATA["+recoDescr+"]]>").append("</reco_status_descr>");
					}// end of if block for reco_status
					else if("site_code".equalsIgnoreCase(currentColumn.trim()))
					{
						site_code = checkNull(genericUtility.getColumnValue("site_code", dom));
						
						sql = "select descr from site where site_code=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,site_code);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							siteDescr = rs.getString("descr");
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}	
						valueXmlString.append("<site_descr>").append("<![CDATA["+siteDescr+"]]>").append("</site_descr>");
					}//end of if block for site_code
					else if("cust_code".equalsIgnoreCase(currentColumn.trim()))
					{
						cust_code = checkNull(genericUtility.getColumnValue("cust_code", dom));
						System.out.println("cust_code>>>>"+cust_code);
						
						sql = "select cust_name from customer where cust_code=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,cust_code);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							cust_name = rs.getString("cust_name");
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}
						valueXmlString.append("<cust_name>").append("<![CDATA["+cust_name+"]]>").append("</cust_name>");
					}//end of if block for cust_code
					valueXmlString.append("</Detail1>");
					break;
				}//end of case1
			}//end of switch block
			valueXmlString.append("</Root>");		
		}//end of try block
		catch(Exception e)
		{
			System.out.println(":::" + getClass().getSimpleName() + "::"+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					conn.close();
				}
				conn = null;
			} 
			catch (Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		return valueXmlString.toString();
    }

	private String errorType(Connection conn, String errorCode) throws ITMException
	{
		String msgType = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			String sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, errorCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}
			if(pstmt != null)
			{
			    pstmt.close(); 
			    pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
			    rs = null;
			}
		} 
		catch (Exception ex)
		{
			ex.printStackTrace();
			throw new ITMException(ex);
		} 
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			} 
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return msgType;
	}
}
