/* Developed By Ahmed Mohammed Ali
 * Date : 20-JUL-2016
 * Component Name : EmpMaritalStatusConf
 */

package ibase.webitm.ejb.adm.adv;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessLocal;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.adm.AdmCommon;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import javax.ejb.Stateless;
import javax.naming.InitialContext;

import org.w3c.dom.Document;

/**
 * Session Bean implementation class EmpMaritalStatusConf
 */
@Stateless
public class EmpMaritalStatusConf extends ActionHandlerEJB implements EmpMaritalStatusConfRemote, EmpMaritalStatusConfLocal 
{
	public String actionHandler() throws RemoteException, ITMException
	{
		return "";
	}

	public String actionHandler(String tranId, String xtraParams, String forcedFlag) throws RemoteException, ITMException
	{
		Connection connection = null;
		ConnDriver connDriver = null;
		String retString = "";
		boolean isError = false;
		try
		{
			connDriver = new ConnDriver();
			connection = connDriver.getConnectDB("DriverITM");
			connection.setAutoCommit(false);
			retString = checkNull(actionHandler(tranId, xtraParams, forcedFlag, connection));
		}
		catch(Exception e)
		{
			isError = true;
			System.out.println("Exception EmpMaritalStatusConf :confirm :==>" + e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(isError)
				{
					connection.rollback();
				}
				else
				{
					connection.commit();
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
				throw new ITMException(ex);
			}
		}
		return retString;
	}
	
	public String actionHandler(String tranId, String xtraParams, String forcedFlag, Connection connection) throws RemoteException, ITMException
	{
		String retString = "";
		Document headerDom = null;
		Document detailDom = null;
		
		try
		{
			retString = checkNull(actionHandler(tranId, headerDom, detailDom, xtraParams, forcedFlag, connection));
		}
		catch (Exception e)
		{
			System.out.println("Exception EmpMaritalStatusConf :confirm :==>");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("retString.. [" + retString + "] ");
		return retString;
	}
	
	public String actionHandler(String tranId, Document headerDom, Document detailDom, String xtraParams, String forcedFlag, Connection connection) throws RemoteException, ITMException
	{
		String retString = "";
		AdmCommon admCommon = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		AppConnectParm appConnect = null;
		InitialContext initialCtx = null;
		ITMDBAccessLocal itmDBAccess = null;
		ValidatorEJB validator = null;
		String empCode = "", tranDate = "", statusDate = "", oldStatus = "", newStatus = "", amount = "", generateVouch = ""; 
		E12GenericUtility genericUtility = null;
		String sql = "";
		String loginEmpCode = "", shortName = "", empFName = "", empMName = "", empLName = "", loginCode = "", chgTerm = "";
		Timestamp statusDateTimeStamp = null;
		Timestamp tranDateTimestamp = null;
		String entryBatchNo = " ", tranType = "", bankCode = "", autoPay = "", payMode = "", autoPost = "", holdFlag = "", giftCode = "";
		String winName = "", errCode = "", paySite = "", siteCodeAcct = "", withHeld = "";
		String acctCodeSal = "", cctrCodeSal = "", finEntity = "", empCctrCodeSal = "", empDeptCode = "";
		String empBankCode = "", prdCode = "", currencyCode = "", acctCodePay = "", cctrCodePay = "", vouchType = "";
		String confirmed = "", paid = "", remarks = "", confirmStatus = "";
		double totalAmount = 0.0d, exchangeRate = 0.0d, totalAmountBC = 0.0d;
		SimpleDateFormat sdf = null;
		Date relieveDate = null;
		PayrollVoucherConfLocal payrollVoucherConf = null;
		
		try
		{
			genericUtility = new E12GenericUtility();
			appConnect = new AppConnectParm();
			initialCtx = new InitialContext(appConnect.getProperty());
			itmDBAccess = (ITMDBAccessLocal)initialCtx.lookup("ibase/ITMDBAccessEJB/local");
			loginEmpCode = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"));
			loginCode = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode"));
			chgTerm = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId"));
			empCode = checkNull(genericUtility.getColumnValue("emp_code", headerDom));
			tranDate = checkNull(genericUtility.getColumnValue("tran_date", headerDom));
			statusDate = checkNull(genericUtility.getColumnValue("status_date", headerDom));
			oldStatus = checkNull(genericUtility.getColumnValue("old_status", headerDom));
			generateVouch = checkNull(genericUtility.getColumnValue("generate_voucher", headerDom));
			
			System.out.println("empCode ::" + empCode);
			System.out.println("tranDate ::" + tranDate);
			System.out.println("statusDate ::" + statusDate);
			System.out.println("oldStatus ::" + oldStatus);
			
			System.out.println("generateVouch ::" + generateVouch);
			
			tranDateTimestamp = Timestamp.valueOf(genericUtility.getValidDateTimeString(tranDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()));
			String dbName= checkNull(CommonConstants.DB_NAME);
			System.out.println("dbName:::::::"+dbName);
			if(dbName.trim().equalsIgnoreCase("oracle"))
			{
				sql = "SELECT NEW_STATUS, SHORT_NAME, EMP_FNAME, EMP_MNAME, EMP_LNAME, STATUS_DATE, AMOUNT, CONFIRM " +
						"FROM EMP_MARITALCHG WHERE EMP_CODE = ? AND TRAN_DATE = ? FOR UPDATE NOWAIT";
			}
			else
			{
				sql = "SELECT NEW_STATUS, SHORT_NAME, EMP_FNAME, EMP_MNAME, EMP_LNAME, STATUS_DATE, AMOUNT, CONFIRM " +
						"FROM EMP_MARITALCHG WHERE EMP_CODE = ? AND TRAN_DATE = ? FOR UPDATE";
			}
			pstmt = connection.prepareStatement(sql);
			pstmt.setString(1, empCode);
			pstmt.setTimestamp(2, tranDateTimestamp);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				newStatus = checkNull(rs.getString("NEW_STATUS"));
				//Modified by Ahmed on 12/AUG/2016[To stop trimming these values as it can contain spaces][START]
				//shortName = checkNull(rs.getString("SHORT_NAME"));
				//empFName = checkNull(rs.getString("EMP_FNAME"));
				//empMName = checkNull(rs.getString("EMP_MNAME"));
				//empLName = checkNull(rs.getString("EMP_LNAME"));
				shortName = replaceNull(rs.getString("SHORT_NAME"));
				empFName = replaceNull(rs.getString("EMP_FNAME"));
				empMName = replaceNull(rs.getString("EMP_MNAME"));
				empLName = replaceNull(rs.getString("EMP_LNAME"));
				//Modified by Ahmed on 12/AUG/2016[To stop trimming these values as it can contain spaces][END]
				statusDateTimeStamp = rs.getTimestamp("STATUS_DATE");
				amount = checkNull(rs.getString("AMOUNT"));
				confirmStatus = checkNull(rs.getString("CONFIRM"));
			}
			close(pstmt, rs);
			System.out.println("amount ::" + amount);
			System.out.println("newStatus ::" + newStatus);
			System.out.println("statusDate ::" + statusDateTimeStamp);
			System.out.println("empFName ::" + empFName);
			System.out.println("empMName ::" + empMName);
			System.out.println("empLName ::" + empLName);
			
			if("Y".equalsIgnoreCase(confirmStatus))
			{
				retString = itmDBAccess.getErrorString("", "VTMARSCH01", "", "", connection);
				return retString;
			}
			
			String namePrefix = "", sex = "";
			sql = "SELECT NAME_PREFIX, SEX FROM EMPLOYEE WHERE EMP_CODE = ? ";
			pstmt = connection.prepareStatement(sql);
			pstmt.setString(1, empCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				namePrefix = checkNull(rs.getString("NAME_PREFIX"));
				sex = checkNull(rs.getString("SEX"));
			}
			close(pstmt, rs);
			
			if("F".equalsIgnoreCase(sex))
			{
				namePrefix = "Ms";
			}
			
			sql = "UPDATE EMPLOYEE SET M_STATUS = ?, M_STATUS_DATE = ?, NAME_PREFIX = ?, EMP_FNAME = ?, " +
					"EMP_MNAME = ?, EMP_LNAME = ?, SHORT_NAME = ?, CHG_USER = ?, CHG_DATE = FN_SYSDATE(), CHG_TERM = ? " +
					"WHERE EMP_CODE = ?";
			pstmt = connection.prepareStatement(sql);
			pstmt.setString(1, newStatus);
			pstmt.setTimestamp(2, statusDateTimeStamp);
			pstmt.setString(3, namePrefix);
			pstmt.setString(4, empFName);
			pstmt.setString(5, empMName);
			pstmt.setString(6, empLName);
			pstmt.setString(7, shortName);
			pstmt.setString(8, loginCode);
			pstmt.setString(9, chgTerm);
			pstmt.setString(10, empCode);
			int updateEmployeeCount = pstmt.executeUpdate();
			System.out.println("updateEmployee :: " + updateEmployeeCount);
			close(pstmt, rs);
			
			sql = "UPDATE EMP_MARITALCHG SET CONFIRM = 'Y', CONF_DATE = FN_SYSDATE(), EMP_CODE__APRV = ? WHERE EMP_CODE = ? AND TRAN_DATE = ?";
			pstmt = connection.prepareStatement(sql);
			pstmt.setString(1, loginEmpCode);
			pstmt.setString(2, empCode);
			pstmt.setTimestamp(3, tranDateTimestamp);
			int updateMaritalChgCount = pstmt.executeUpdate();
			System.out.println("updateMaritalChg :: " + updateMaritalChgCount);
			close(pstmt, rs);
			
			if(updateEmployeeCount == 0 || updateMaritalChgCount == 0)
			{
				retString = itmDBAccess.getErrorString("","VTMARSCH02","","",connection);
				return retString;
			}
			
			if("M".equalsIgnoreCase(newStatus) && "Y".equalsIgnoreCase(generateVouch))
			{
				Date tranDateSql = null;
				sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
				admCommon = new AdmCommon();
				validator = new ValidatorEJB();
				tranType = "MRG";
				entryBatchNo = " ";
				vouchType = "O";
				confirmed = "N";
				paid = "N";
				remarks = "Marriage Gift Voucher";
				winName = "w_payr_voucher";
				tranDateSql = sdf.parse(tranDate);
				bankCode = checkNull(admCommon.getEnv("999999","BANKCODE",connection));
				if("NULLFOUND".equalsIgnoreCase(bankCode))
				{
					retString = itmDBAccess.getErrorString("", "VSENVAR1", "", "", connection);
					return retString;
				}
				autoPay = checkNull(admCommon.getEnv("999999", "AUTO_PAY", connection));
				if("NULLFOUND".equalsIgnoreCase(autoPay))
				{
					retString = itmDBAccess.getErrorString("", "VSENVAR1", "", "", connection);
					return retString;
				}
				payMode = checkNull(admCommon.getEnv("999999", "PAY_MODE", connection));
				if("NULLFOUND".equalsIgnoreCase(payMode))
				{
					retString = itmDBAccess.getErrorString("", "VSENVAR1", "", "", connection);
					return retString;
				}
				autoPost = checkNull(admCommon.getEnv("999999", "AUTO_POST", connection));
				if("NULLFOUND".equalsIgnoreCase(autoPost))
				{
					retString = itmDBAccess.getErrorString("", "VSENVAR1", "", "", connection);
					return retString;
				}
				giftCode = (admCommon.getEnv("999999", "GIFT_CODE", connection));
				if("NULLFOUND".equalsIgnoreCase(giftCode))
				{
					retString = itmDBAccess.getErrorString("", "VSENVAR1", "", "", connection);
					return retString;
				}
				
				sql = "SELECT CCTR_CODE__SAL, BANK_CODE, DEPT_CODE, RELIEVE_DATE, WITH_HELD, PAY_SITE FROM EMPLOYEE WHERE EMP_CODE = ?";
				pstmt = connection.prepareStatement(sql);
				pstmt.setString(1, empCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					paySite = checkNull(rs.getString("PAY_SITE"));
					withHeld = checkNull(rs.getString("WITH_HELD"));
					relieveDate = rs.getDate("RELIEVE_DATE");
					empCctrCodeSal = rs.getString("CCTR_CODE__SAL");
					empBankCode = checkNull(rs.getString("BANK_CODE"));
					empDeptCode = checkNull(rs.getString("DEPT_CODE"));
				}
				close(pstmt, rs);
				
				holdFlag = "N";
				if(relieveDate != null || "Y".equalsIgnoreCase(withHeld))
				{
					holdFlag = checkNull(admCommon.getEnv("999999","HOLD_FLAG",connection));
					if("NULLFOUND".equalsIgnoreCase(holdFlag))
					{
						retString = itmDBAccess.getErrorString("","VSENVAR1","","",connection);
						return retString;
					}
				}
				
				errCode = validator.nfCheckPeriod("ADM", tranDateSql, paySite);
				if(errCode == null || errCode.trim().length() == 0)
				{
					errCode = validator.nfCheckPeriod("FIN", tranDateSql, paySite);
					if(errCode != null && errCode.trim().length() > 0)
					{
						retString = itmDBAccess.getErrorString("", errCode, "", "", connection);
						return retString;
					}
				}
				else
				{
					retString = itmDBAccess.getErrorString("", errCode, "", "", connection);
					return retString;
				}
				
				sql = "SELECT CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE";
				pstmt = connection.prepareStatement(sql);
				pstmt.setTimestamp(1, tranDateTimestamp);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					prdCode = checkNull(rs.getString("CODE"));
				}
				close(pstmt, rs);
				
				sql = "SELECT NVL(AMOUNT,0) AS TOTAL_AMOUNT FROM PAYROLL_PROJDET WHERE EMP_CODE = ? AND PRD_CODE = ? AND AD_CODE = ?";
				pstmt = connection.prepareStatement(sql);
				pstmt.setString(1, empCode);
				pstmt.setString(2, prdCode);
				pstmt.setString(3, giftCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					totalAmount = rs.getDouble("TOTAL_AMOUNT");
				}
				close(pstmt, rs);
				
				if(totalAmount == 0)
				{
					retString = itmDBAccess.getErrorString("", "VTVCHAMT0", "", "", connection);
					return retString;
				}
				
				if(empBankCode.length() == 0)
				{
					empBankCode = bankCode;
				}
				
				sql = "SELECT FIN_ENTITY, SITE_CODE__ACCT FROM SITE WHERE SITE_CODE = ?";
				pstmt = connection.prepareStatement(sql);
				pstmt.setString(1, paySite);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					siteCodeAcct = checkNull(rs.getString("SITE_CODE__ACCT"));
					finEntity = checkNull(rs.getString("FIN_ENTITY"));
				}
				close(pstmt, rs);
				
				sql = "SELECT CURR_CODE FROM FINENT WHERE FIN_ENTITY = ?";
				pstmt = connection.prepareStatement(sql);
				pstmt.setString(1, finEntity);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					currencyCode = checkNull(rs.getString("CURR_CODE"));
				}
				close(pstmt, rs);
				
				sql = "SELECT STD_EXRT FROM CURRENCY WHERE CURR_CODE = ?";
				pstmt = connection.prepareStatement(sql);
				pstmt.setString(1, currencyCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					exchangeRate = rs.getDouble("STD_EXRT");
				}
				close(pstmt, rs);
				
				sql = "SELECT ACCT_CODE, CCTR_CODE FROM DEPARTMENT WHERE DEPT_CODE = ?";
				pstmt = connection.prepareStatement(sql);
				pstmt.setString(1, empDeptCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					acctCodePay = rs.getString("ACCT_CODE");
					cctrCodePay = rs.getString("CCTR_CODE");
				}
				close(pstmt, rs);
				
				tranId = generateTranId(winName, siteCodeAcct, tranDate, connection);
				System.out.println("tranId generated :: "+tranId);
				
				totalAmountBC = totalAmount * exchangeRate;
				String adCode = "";
				
				Calendar currentDate = Calendar.getInstance();
				SimpleDateFormat sdf1 = new SimpleDateFormat(genericUtility.getApplDateFormat());
				String sysDateStr = sdf1.format(currentDate.getTime());
				
				sql = " INSERT INTO PAYR_VOUCHER (TRAN_ID, TRAN_DATE, TRAN_TYPE, EFF_DATE, EMP_CODE, REF_NO, REF_DATE, " +
						"BANK_CODE, AUTO_PAY, PAY_MODE, CHG_DATE, CHG_USER, CHG_TERM, SITE_CODE, FIN_ENTITY, REMARKS, " +
						"ANAL_CODE, CONFIRMED, PAID, ACCT_CODE__PAY, CCTR_CODE__PAY, TOT_AMT, ENTRY_BATCH_NO, VOUCH_TYPE, " +
						"CURR_CODE, EXCH_RATE, TOT_AMT__BC, HOLD) "
						+" VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, FN_SYSDATE(), ?, ?, ?, ?, ?, " +
						"?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
				pstmt = connection.prepareStatement(sql);
				pstmt.setString(1, tranId);
				pstmt.setTimestamp(2, tranDateTimestamp);
				pstmt.setString(3, tranType);
				pstmt.setTimestamp(4, tranDateTimestamp);
				pstmt.setString(5, empCode);
//				pstmt.setString(6, tranId);
				pstmt.setString(6, statusDate);
				pstmt.setTimestamp(7, tranDateTimestamp);
				pstmt.setString(8, empBankCode);
				pstmt.setString(9, autoPay);
				pstmt.setString(10, payMode);
				pstmt.setString(11, loginCode);
				pstmt.setString(12, chgTerm);
				pstmt.setString(13, siteCodeAcct);
				pstmt.setString(14, finEntity);
				pstmt.setString(15, remarks);
				pstmt.setString(16, adCode);
				pstmt.setString(17, confirmed);
				pstmt.setString(18, paid);
				pstmt.setString(19, acctCodePay);
				pstmt.setString(20, cctrCodePay);
				pstmt.setDouble(21, totalAmount);
				pstmt.setString(22, entryBatchNo);
				pstmt.setString(23, vouchType);
				pstmt.setString(24, currencyCode);
				pstmt.setDouble(25, exchangeRate);
				pstmt.setDouble(26, totalAmountBC);
				pstmt.setString(27, holdFlag);
				int payrVoucherInsertCount = pstmt.executeUpdate();
				System.out.println("row insert into payr_voucher :: " + payrVoucherInsertCount);
				close(pstmt, rs);
				
				sql = "SELECT ACCT_CODE__SAL, CCTR_CODE__SAL FROM ALLWDEDN WHERE AD_CODE = ?";
				pstmt = connection.prepareStatement(sql);
				pstmt.setString(1, giftCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					acctCodeSal = rs.getString("ACCT_CODE__SAL");
					cctrCodeSal = rs.getString("CCTR_CODE__SAL");
				}
				close(pstmt, rs);
				
				if(empCctrCodeSal != null && empCctrCodeSal.trim().length() > 0)
				{
					cctrCodeSal = empCctrCodeSal;
				}
				
				sql = "INSERT INTO PAYR_VOUCHDET (TRAN_ID, LINE_NO, ACCT_CODE, CCTR_CODE, AMOUNT, AD_CODE) "
						+" VALUES (?, ?, ?, ?, ?, ?)";
				pstmt = connection.prepareStatement(sql);
				pstmt.setString(1, tranId);
				String lineNoStr = "1";
				pstmt.setString(2, lineNoStr);
				pstmt.setString(3, acctCodeSal);
				pstmt.setString(4, cctrCodeSal);
				pstmt.setDouble(5, totalAmount);
				pstmt.setString(6, giftCode);
				int payrVouchDetInsert = pstmt.executeUpdate();
				System.out.println("row insert into payr_vouchdet " + payrVouchDetInsert);
				close(pstmt, rs);
				
				updateMaritalChgCount = 0;
				sql = "UPDATE EMP_MARITALCHG SET VOUCHER_NO = ?, AMOUNT = ? WHERE EMP_CODE = ? AND TRAN_DATE = ?";
				pstmt = connection.prepareStatement(sql);
				pstmt.setString(1, tranId);
				pstmt.setDouble(2, totalAmount);
				pstmt.setString(3, empCode);
				pstmt.setTimestamp(4, tranDateTimestamp);
				updateMaritalChgCount = pstmt.executeUpdate();
				System.out.println("updateMaritalChg :: " + updateMaritalChgCount);
				close(pstmt, rs);
				
				if("Y".equalsIgnoreCase(autoPost))
				{
					payrollVoucherConf = (PayrollVoucherConfLocal)initialCtx.lookup("ibase/PayrollVoucherConf/local");
					retString = checkNull(payrollVoucherConf.confirm(tranId, forcedFlag, xtraParams, connection));
					if(retString.length() > 0 && retString.indexOf("VTMCONF2") == -1 )
					{
						return retString;
					}
					else
					{
						sql = "SELECT CASE WHEN CONFIRMED IS NULL THEN 'N' ELSE CONFIRMED END AS CONFIRMED FROM PAYR_VOUCHER WHERE TRAN_ID = ?";
						pstmt = connection.prepareStatement(sql);
						pstmt.setString(1, tranId);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							confirmed = checkNull(rs.getString("CONFIRMED"));
						}
						close(pstmt, rs);
						if(!"Y".equalsIgnoreCase(confirmed))
						{
							retString = itmDBAccess.getErrorString("","PAYVCHCNF1","","",connection);
							return retString;
						}
					}
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception EmpMaritalStatusConf :confirm :==>");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			close(pstmt, rs);
		}
		return retString;
	}
	
	private String generateTranId( String windowName, String siteCode, String tranDateStr, Connection conn) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String selSql = "";
		String tranId = "";
		String tranSer = "";
		String keyString = "";
		String keyCol = "";
		String xmlValues = "";

		try
		{
			System.out.println("generateTranId() called...");

			selSql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
			pstmt = conn.prepareStatement(selSql);
			pstmt.setString( 1, windowName );
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				keyString = rs.getString("KEY_STRING");
				keyCol = rs.getString("TRAN_ID_COL");
				tranSer = rs.getString("REF_SER");
			}
			close(pstmt, rs);
			System.out.println("keyString :"+keyString);
			System.out.println("keyCol :"+keyCol);
			System.out.println("tranSer :"+tranSer);

			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues +		"<tran_id></tran_id>";
			xmlValues = xmlValues +		"<site_code>" + siteCode + "</site_code>";
			xmlValues = xmlValues +		"<tran_date>" + tranDateStr + "</tran_date>"; 
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues  :["+xmlValues+"]");
			TransIDGenerator transIDGenerator = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
			tranId = transIDGenerator.generateTranSeqID(tranSer, keyCol, keyString, conn);
			System.out.println("tranId :"+tranId);
		}
		catch (SQLException ex)
		{
			System.out.println("Exception :EmpMaritalStatusConf :generateTranId :SQLException ::" +selSql+ ex.getMessage() + ":");
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{
			System.out.println("Exception :EmpMaritalStatusConf :generateTranId :Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return tranId;
	}
	
	private String checkNull(String input)
	{
		if (input == null || ("null").equalsIgnoreCase(input.trim()))
		{
			input = "";
		}
		else
		{
			input = input.trim();
		}
		return input;
	}
	
	//Modified by Ahmed on 12/AUG/2016[A16BSUN002][This method is used to only check for null value][START]
	private String replaceNull(String input)
	{
		if (input == null)
		{
			input = "";
		}
		return input;
	}
	//Modified by Ahmed on 12/AUG/2016[A16BSUN002][This method is used to only check for null value][END]
	
	private void close(PreparedStatement pstmt, ResultSet rs) 
	{
		try
		{
			if( rs != null)
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}
	}
}
