/********************************************************
	Title : TransporterBank EJB
	Date  : 06-May-2013
	Author: Somanath Behera

 ********************************************************/
package ibase.webitm.ejb.fin;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;

import javax.ejb.Stateless;

@Stateless
public class TransporterBank extends ValidatorEJB implements TransporterBankLocal, TransporterBankRemote {
    public TransporterBank() {
	System.out.println("^^^^^^^ inside TransporterBank ^^^^^^^");
    }

    public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException {
	Document dom = null;
	Document dom1 = null;
	Document dom2 = null;
	String errString = "";

	NodeList parentNodeList = null;
	NodeList childNodeList = null;
	Node parentNode = null;
	Node childNode = null;
	String childNodeName = "";

	try {
	    dom = parseString(xmlString);
	    dom1 = parseString(xmlString1);
	    if (xmlString2.trim().length() > 0) {
		dom2 = parseString("<Root>" + xmlString2 + "</Root>");
	    }
	    if (objContext != null && Integer.parseInt(objContext) == 1) {
		parentNodeList = dom2.getElementsByTagName("Header0");
		parentNode = parentNodeList.item(1);
		childNodeList = parentNode.getChildNodes();
		for (int x = 0; x < childNodeList.getLength(); x++) {
		    childNode = childNodeList.item(x);
		    childNodeName = childNode.getNodeName();
		    if (childNodeName.equalsIgnoreCase("Detail1")) {
			errString = wfValData(dom, dom1, dom2, "1", editFlag, xtraParams);
			if (errString != null && errString.trim().length() > 0)
			    break;
		    } else if (childNodeName.equalsIgnoreCase("Detail2")) {
			errString = wfValData(dom, dom1, dom2, "2", editFlag, xtraParams);
			break;
		    }
			}
	    }
	    else {
		errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
	    }
		} catch (Exception e) {
	    System.out.println("Exception : Inside TransporterBank wfValData Method ..> " + e.getMessage());
	    throw new ITMException(e);
	}
	return (errString);
    }

    public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException {
	GenericUtility genericUtility;
	NodeList parentNodeList = null;
	NodeList childNodeList = null;
	Node parentNode = null;
	Node childNode = null;
	int ctr = 0, currentFormNo = 0, childNodeListLength = 0, cnt = 0;
	String childNodeName = null;
	String errString = "";
	String errCode = "";
	Connection conn = null;
	PreparedStatement pStmt = null;
	ResultSet rs = null;
	String sql = "";
	String userId = ""; 
	String tranCode="";
	try {
	    ConnDriver connDriver = new ConnDriver();
	    conn = connDriver.getConnectDB("DriverITM");
	    conn.setAutoCommit(false);
	    connDriver = null;
	    userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
	    genericUtility = GenericUtility.getInstance();
	    if (objContext != null && objContext.trim().length() > 0) {
		currentFormNo = Integer.parseInt(objContext);
	    }
	    switch (currentFormNo) {
	    case 1:
		parentNodeList = dom.getElementsByTagName("Detail1");
		parentNode = parentNodeList.item(0);
		childNodeList = parentNode.getChildNodes();
		childNodeListLength = childNodeList.getLength();

		for (ctr = 0; ctr < childNodeListLength; ctr++) {
		    childNode = childNodeList.item(ctr);
		    childNodeName = childNode.getNodeName();
		    if (childNodeName.equalsIgnoreCase("tran_code")) {
			tranCode = genericUtility.getColumnValue("tran_code", dom);
			tranCode = tranCode == null ? "" : tranCode.trim();
			if (tranCode.length() == 0) {
			    errCode = "VMTNCDNL";
			    errString = getErrorString("tran_code", errCode, userId);
			    break;
			} else {
			    sql = "select count(1) from transporter where tran_code = ?";
			    pStmt = conn.prepareStatement(sql);
			    pStmt.setString(1, tranCode);
			    rs = pStmt.executeQuery();

			    if (rs.next()) {
				cnt = rs.getInt(1);
			    }
			    rs.close();
			    rs = null;
			    pStmt.close();
			    pStmt = null;
			    if (cnt == 0) {
				errCode = "VMCNTDNF";
				errString = getErrorString("tran_code", errCode, userId);
				break;
			    }
			}
		    } else if (childNodeName.equalsIgnoreCase("bank_code__ben")) {
					String bankCodeBen = genericUtility.getColumnValue(
						"bank_code__ben", dom);
					tranCode = genericUtility.getColumnValue("tran_code",
						dom);
					bankCodeBen = bankCodeBen == null ? "" : bankCodeBen
						.trim();
				if (bankCodeBen.length() == 0) {
					errCode = "VTBCBNNL";
					errString = getErrorString("bank_code__ben",
							errCode, userId);
					break;
				} else {
					if(!editFlag.equals("E")){
					sql = "select count(1) from transporter_bank where tran_code = ? and bank_code__ben= ? ";
					pStmt = conn.prepareStatement(sql);
					pStmt.setString(1, tranCode);
					pStmt.setString(2, bankCodeBen);
					rs = pStmt.executeQuery();

					if (rs.next()) {
						cnt = rs.getInt(1);
					}
					rs.close();
					rs = null;
					pStmt.close();
					pStmt = null;
					if (cnt > 0) {
						errCode = "VMTBALE";
						errString = getErrorString("tran_code",
								errCode, userId);
						break;
					}
				}
				}
			}else if (childNodeName.equalsIgnoreCase("bank_name__ben")) {
					String bankNameBen = genericUtility.getColumnValue("bank_name__ben", dom);
					bankNameBen = bankNameBen == null ? "" : bankNameBen.trim();
					if (bankNameBen.length() == 0) {
						errCode = "VTBNBNNL";
						errString = getErrorString("bank_name__ben", errCode, userId);
						break;
			}
			}
//			else if (childNodeName.equalsIgnoreCase("bank_acct_no__ben")) {
//					String bankActNo = genericUtility.getColumnValue("bank_acct_no__ben", dom);
//					bankActNo = bankActNo == null ? "" : bankActNo.trim();
//					if (bankActNo.length() == 0) {
//						errCode = "VTBANNL";
//						errString = getErrorString("bank_acct_no__ben", errCode, userId);
//						break;
//			}
//			}
			else if (childNodeName.equalsIgnoreCase("active_yn")) {
					String active = genericUtility.getColumnValue("active_yn", dom);
					active = active == null ? "" : active.trim();
					if (active.length() == 0) {
						errCode = "VTACTNL";
						errString = getErrorString("active_yn", errCode, userId);
						break;
			}//20-05-13
			}else if (childNodeName.equalsIgnoreCase("city__ben")) {
				    String cityBen = genericUtility.getColumnValue("city__ben", dom);
				    cityBen = cityBen == null ? "" : cityBen.trim();
				    if (cityBen.length() > 0) {
				    	sql = "select count(1) from station where city=?";
				    	pStmt = conn.prepareStatement(sql);
				    	pStmt.setString(1, cityBen);
				    	rs = pStmt.executeQuery();

					if (rs.next()) {
					    cnt = rs.getInt(1);
					}
						rs.close();
						rs = null;
						pStmt.close();
						pStmt = null;
					if (cnt == 0) {
					    errCode = "VMCITNF";
					    errString = getErrorString("city__ben", errCode, userId);
					    break;
					}
				    }
			}else if (childNodeName.equalsIgnoreCase("state_code__ben")) {
			    String staeCodeBen = genericUtility.getColumnValue("state_code__ben", dom);
			    staeCodeBen = staeCodeBen == null ? "" : staeCodeBen.trim();
			    if (staeCodeBen.length() > 0) {
			    	sql = "select count(1) from state where state_code=?";
			    	pStmt = conn.prepareStatement(sql);
			    	pStmt.setString(1, staeCodeBen);
			    	rs = pStmt.executeQuery();

				if (rs.next()) {
				    cnt = rs.getInt(1);
				}
					rs.close();
					rs = null;
					pStmt.close();
					pStmt = null;
				if (cnt == 0) {
				    errCode = "VMSTCDNF";
				    errString = getErrorString("state_code__ben", errCode, userId);
				    break;
				}
			    }
			}else if (childNodeName.equalsIgnoreCase("count_code__ben")) {
			    String contCodeBen = genericUtility.getColumnValue("count_code__ben", dom);
			    contCodeBen = contCodeBen == null ? "" : contCodeBen.trim();
			    if (contCodeBen.length() > 0) {
			    	sql = "select count(1) from country where count_code=?";
			    	pStmt = conn.prepareStatement(sql);
			    	pStmt.setString(1, contCodeBen);
			    	rs = pStmt.executeQuery();

				if (rs.next()) {
				    cnt = rs.getInt(1);
				}
					rs.close();
					rs = null;
					pStmt.close();
					pStmt = null;
				if (cnt == 0) {
				    errCode = "VMCNTCDNF";
				    errString = getErrorString("count_code__ben", errCode, userId);
				    break;
				}
			    }
			}else if (childNodeName.equalsIgnoreCase("bank_code__inter")) {
				String bankNameInt = genericUtility.getColumnValue("bank_code__inter", dom);
				bankNameInt = bankNameInt == null ? "" : bankNameInt.trim();
				if (bankNameInt.length() == 0) {
					errCode = "VMBNINNL";
					errString = getErrorString("bank_code__inter", errCode, userId);
					break;
				}
			}else if (childNodeName.equalsIgnoreCase("bank_name__inter")) {
				String bankNameInt = genericUtility.getColumnValue("bank_name__inter", dom);
				bankNameInt = bankNameInt == null ? "" : bankNameInt.trim();
				if (bankNameInt.length() == 0) {
					errCode = "VMBNNMNL";
					errString = getErrorString("bank_name__inter", errCode, userId);
					break;
				}
			}else if (childNodeName.equalsIgnoreCase("city__inter")) {
			    String cityInt = genericUtility.getColumnValue("city__inter", dom);
			    cityInt = cityInt == null ? "" : cityInt.trim();
			    if (cityInt.length() > 0) {
			    	sql = "select count(1) from station where city=?";
			    	pStmt = conn.prepareStatement(sql);
			    	pStmt.setString(1, cityInt);
			    	rs = pStmt.executeQuery();

				if (rs.next()) {
				    cnt = rs.getInt(1);
				}
					rs.close();
					rs = null;
					pStmt.close();
					pStmt = null;
				if (cnt == 0) {
				    errCode = "VMCITNF";
				    errString = getErrorString("city__inter", errCode, userId);
				    break;
				}
			    }
			}else if (childNodeName.equalsIgnoreCase("state_code__inter")) {
		    String stateCodeInt = genericUtility.getColumnValue("state_code__inter", dom);
		    stateCodeInt = stateCodeInt == null ? "" : stateCodeInt.trim();
		    	if (stateCodeInt.length() > 0) {
			    	sql = "select count(1) from state where state_code=?";
			    	pStmt = conn.prepareStatement(sql);
			    	pStmt.setString(1, stateCodeInt);
			    	rs = pStmt.executeQuery();

		    	if (rs.next()) {
		    		cnt = rs.getInt(1);
			}
					rs.close();
					rs = null;
					pStmt.close();
					pStmt = null;
			if (cnt == 0) {
				    errCode = "VMSTCDNF";
				    errString = getErrorString("state_code__inter", errCode, userId);
				    break;
			}
		    }
		}else if (childNodeName.equalsIgnoreCase("count_code__inter")) {
		    String contCodeInt = genericUtility.getColumnValue("count_code__inter", dom);
		    contCodeInt = contCodeInt == null ? "" : contCodeInt.trim();
		    if (contCodeInt.length() > 0) {
		    	sql = "select count(1) from country where count_code=?";
		    	pStmt = conn.prepareStatement(sql);
		    	pStmt.setString(1, contCodeInt);
		    	rs = pStmt.executeQuery();
			if (rs.next()) {
			    cnt = rs.getInt(1);
			}
				rs.close();
				rs = null;
				pStmt.close();
				pStmt = null;
			if (cnt == 0) {
			    errCode = "VMCNTCDNF";
			    errString = getErrorString("count_code__inter", errCode, userId);
			    break;
			}
		    }
		}//end on 20.05.13
			    
		}//end of for
	    }//end of switch
	} catch (Exception e) {
	    e.printStackTrace();
	    errString = e.getMessage();
	    throw new ITMException(e);
	} finally {
	    try {
		if (conn != null) {
		    conn.close();
		}
		conn = null;
	    } catch (Exception d) {
		d.printStackTrace();
	    }
	}
	return errString;
    }

    public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException {
	Document dom = null;
	Document dom1 = null;
	Document dom2 = null;
	String valueXmlString = "";
	try {
	    dom = parseString(xmlString);
	    dom1 = parseString(xmlString1);
	    if (xmlString2.trim().length() > 0) {
		dom2 = parseString(xmlString2);
	    }
	    valueXmlString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
	} catch (Exception e) {
	    System.out.println("Exception : itemChanged :==>\n" + e.getMessage());
	    throw new ITMException(e);
	}
	return valueXmlString;
    }

    public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException {
    	GenericUtility genericUtility;
    	StringBuffer valueXmlString = new StringBuffer();

    	Connection conn = null;
    	PreparedStatement pStmt = null;
    	ResultSet rs = null;
    	String sql = "";

    	int currentFormNo = 0;
    	String tranCode = "", transporterName = "";
    	String bankCodeBen="",bankNameBen="",addr1Ben="",addr2Ben="", addr3Ben="",stateCodeBen="", pinBen="",countryCodeBen="", cityBen="";
		String  bankCodeInt="",bankNameInt="",addr1Int="",addr2Int="", addr3Int="",stateCodeInt="", pinInt="",countryCodeInt="", cityInt=""; 
    	try {
    	    genericUtility = GenericUtility.getInstance();
    	    ConnDriver conndriver = new ConnDriver();
    	    conn = conndriver.getConnectDB("DriverITM");
    	    conn.setAutoCommit(false);
    	    conndriver = null;

    	    genericUtility = GenericUtility.getInstance();
    	    if (objContext != null && objContext.trim().length() > 0)
    		currentFormNo = Integer.parseInt(objContext);

    	    valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
    	    valueXmlString.append(editFlag).append("</editFlag></header>");
    	    switch (currentFormNo) {
    	    case 1:
    		valueXmlString.append("<Detail1>");
    		 if (currentColumn.trim().equalsIgnoreCase("tran_code")) {
    		    tranCode = genericUtility.getColumnValue("tran_code", dom);
    		    transporterName = "";
    		    tranCode = tranCode == null ? "" : tranCode.trim();
    		    if (tranCode.length() > 0) {
    			sql = "select tran_name from transporter where tran_code = ?";
    			pStmt = conn.prepareStatement(sql);
    			pStmt.setString(1, tranCode);
    			rs = pStmt.executeQuery();
    			if (rs.next()) {
    				transporterName = rs.getString(1);
    			}
    			transporterName = (transporterName == null) ? "" : transporterName.trim();
    			rs.close();
    			pStmt.close();
    			rs = null;
    			pStmt = null;
    		    }
    		    valueXmlString.append("<tran_name>").append(transporterName).append("</tran_name>\r\n");
    		}else if(currentColumn.trim().equalsIgnoreCase("bank_code__ben")){
    			bankCodeBen=genericUtility.getColumnValue("bank_code__ben", dom);
    			bankCodeBen = bankCodeBen == null ? "" : bankCodeBen.trim();
    			
    			if (bankCodeBen.length() > 0) {
        			sql = "select bank_name, addr1, addr2, addr3, city, state_code, pin, count_code from bank where bank_code= ?";
        			pStmt = conn.prepareStatement(sql);
        			pStmt.setString(1, bankCodeBen);
        			rs = pStmt.executeQuery();
        			if (rs.next()) {
        				bankNameBen = rs.getString(1);
        				addr1Ben = rs.getString(2);
        				addr2Ben = rs.getString(3);
        				addr3Ben = rs.getString(4);
        				cityBen = rs.getString(5);
        				stateCodeBen = rs.getString(6);
        				pinBen = rs.getString(7);
        				countryCodeBen=rs.getString(8);
        			}
        			bankNameBen = (bankNameBen == null) ? "" : bankNameBen.trim();
        			addr1Ben = (addr1Ben == null) ? "" : addr1Ben.trim();
        			addr2Ben = (addr2Ben == null) ? "" : addr2Ben.trim();
        			addr3Ben = (addr3Ben == null) ? "" : addr3Ben.trim();
        			cityBen = (cityBen == null) ? "" : cityBen.trim();
        			stateCodeBen = (stateCodeBen == null) ? "" : stateCodeBen.trim();
        			pinBen = (pinBen == null) ? "" : pinBen.trim();
        			countryCodeBen = (countryCodeBen == null) ? "" : countryCodeBen.trim();
        			
        			rs.close();
        			pStmt.close();
        			rs = null;
        			pStmt = null;
        		    }
        		    valueXmlString.append("<bank_name__ben>").append(bankNameBen).append("</bank_name__ben>\r\n");
        		    valueXmlString.append("<addr1__ben>").append(addr1Ben).append("</addr1__ben>\r\n");
        		    valueXmlString.append("<addr2__ben>").append(addr2Ben).append("</addr2__ben>\r\n");
        		    valueXmlString.append("<addr3__ben>").append(addr3Ben).append("</addr3__ben>\r\n");
        		    valueXmlString.append("<city__ben>").append(cityBen).append("</city__ben>\r\n");
        		    valueXmlString.append("<state_code__ben>").append(stateCodeBen).append("</state_code__ben>\r\n");
        		    valueXmlString.append("<pin__ben>").append(pinBen).append("</pin__ben>\r\n");
        		    valueXmlString.append("<count_code__ben>").append(countryCodeBen).append("</count_code__ben>\r\n");
        		}else if(currentColumn.trim().equalsIgnoreCase("bank_code__inter")){
        			bankCodeInt=genericUtility.getColumnValue("bank_code__inter", dom);
        			bankCodeInt = bankCodeInt == null ? "" : bankCodeInt.trim();
        			
        			if (bankCodeInt.length() > 0) {
            			sql = "select bank_name, addr1, addr2, addr3, city, state_code, pin, count_code from bank where bank_code= ?";
            			pStmt = conn.prepareStatement(sql);
            			pStmt.setString(1, bankCodeInt);
            			rs = pStmt.executeQuery();
            			if (rs.next()) {
            				bankNameInt = rs.getString(1);
            				addr1Int = rs.getString(2);
            				addr2Int = rs.getString(3);
            				addr3Int = rs.getString(4);
            				cityInt = rs.getString(5);
            				stateCodeInt = rs.getString(6);
            				pinInt = rs.getString(7);
            				countryCodeInt=rs.getString(8);
            			}
            			bankNameInt = (bankNameInt == null) ? "" : bankNameInt.trim();
            			addr1Int = (addr1Int == null) ? "" : addr1Int.trim();
            			addr2Int = (addr2Int == null) ? "" : addr2Int.trim();
            			addr3Int = (addr3Int == null) ? "" : addr3Int.trim();
            			cityInt = (cityInt == null) ? "" : cityInt.trim();
            			stateCodeInt = (stateCodeInt == null) ? "" : stateCodeInt.trim();
            			pinInt = (pinInt == null) ? "" : pinInt.trim();
            			countryCodeInt = (countryCodeInt == null) ? "" : countryCodeInt.trim();
            			
            			rs.close();
            			pStmt.close();
            			rs = null;
            			pStmt = null;
            		    }
            		    valueXmlString.append("<bank_name__inter>").append(bankNameInt).append("</bank_name__inter>\r\n");
            		    valueXmlString.append("<addr1__inter>").append(addr1Int).append("</addr1__inter>\r\n");
            		    valueXmlString.append("<addr2__inter>").append(addr2Int).append("</addr2__inter>\r\n");
            		    valueXmlString.append("<addr3__inter>").append(addr3Int).append("</addr3__inter>\r\n");
            		    valueXmlString.append("<city__inter>").append(cityInt).append("</city__inter>\r\n");
            		    valueXmlString.append("<state_code__inter>").append(stateCodeInt).append("</state_code__inter>\r\n");
            		    valueXmlString.append("<pin__inter>").append(pinInt).append("</pin__inter>\r\n");
            		    valueXmlString.append("<count_code__inter>").append(countryCodeInt).append("</count_code__inter>\r\n");
            	}
    		valueXmlString.append("</Detail1 >");
    		break;
    	    }
    	    valueXmlString.append("</Root>");
    	} catch (Exception e) {
    	    e.printStackTrace();
    	    throw new ITMException(e);
    	} finally {
    	    try {
    		if (conn != null) {
    		    conn.close();
    		    conn = null;
    		}
    	    } catch (Exception e1) {
    		e1.printStackTrace();
    	    }
    	}
    	return valueXmlString.toString();
        }


    public String wfValData() throws RemoteException, ITMException {
	return "";
    }

    public String wfValData(Document dom, Document dom1, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException {
	return "";
    }

    public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag) throws RemoteException, ITMException {
	return "";
    }

    public String itemChanged() throws RemoteException, ITMException {
	return "";
    }

    public String itemChanged(Document dom, Document dom1, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException {
	return "";
    }

    public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag) throws RemoteException, ITMException {
	return "";
    }

}