package ibase.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.Node;
import com.google.gwt.xml.client.NodeList;
import com.google.gwt.xml.client.XMLParser;

public class FilterCreator extends Composite
{
	PopupPanel contextMenuPanel = new PopupPanel(true);
	public final int STATUS_CODE_OK = 200;
	HorizontalPanel vPanel = new HorizontalPanel();
	final HorizontalPanel popUpHPnl = new HorizontalPanel();
	final HorizontalPanel lablePanle = new HorizontalPanel();
	final HorizontalPanel buttonPanle = new HorizontalPanel();
	Image HeadingLableImg = new Image("FusionChart/images/menu_button.png");
	Image openButton = new Image("FusionChart/images/analysis_scope.png");
	String selectedView = "";
	String xmlName = "";
	public JSONObject metaDataJsnObj = null;
	boolean isParameterPrsnt = false;
	Label label = null;
	ArrayList<String> title = new ArrayList<String>();
	ArrayList<String> parameterList = null;
	HorizontalPanel headingLableImgPanel = new HorizontalPanel();
	String windowTitle = "Title";

	public FilterCreator(ArrayList<String> parameterList, JSONObject metaDataJsnObj)
	{
		this.parameterList = parameterList;
		xmlName = parameterList.get(0);
		label = new Label();
		title = new MetaDataDtl().getTitle(metaDataJsnObj);
		if (title.size() > 1)
		{
			label.setText(title.get(0) + " " + getMonth(parameterList.get(1)) + title.get(1) + getMonth(parameterList.get(2)));
		} else
		{
			//label.setText(title.get(0) + parameterList.get(2) + "-" + parameterList.get(3));
			label.setText(title.get(0) );//+ parameterList.get(1));//+ "-" + parameterList.get(2));
		}

		HeadingLableImg.setStyleName("filterImage");
		if (getViewFilter(parameterList, metaDataJsnObj) != null)
		{
			headingLableImgPanel.add(getViewFilter(parameterList, metaDataJsnObj));
		}
		headingLableImgPanel.add(label);
		lablePanle.add(headingLableImgPanel);
		label.getElement().setId("titleLbl");
		lablePanle.setStylePrimaryName("lablePanleCSS");
		lablePanle.setCellHorizontalAlignment(label, HasHorizontalAlignment.ALIGN_LEFT);
		openButton.setStyleName("filterImage");
		buttonPanle.add(openButton);
		buttonPanle.setCellHorizontalAlignment(openButton, HasHorizontalAlignment.ALIGN_RIGHT);
		buttonPanle.setStylePrimaryName("vPanelCSS");
		vPanel.setWidth("100%");
		buttonPanle.setWidth("100%");
		lablePanle.setWidth("100%");

		vPanel.setSpacing(10);
		vPanel.add(lablePanle);
		vPanel.add(buttonPanle);
		this.metaDataJsnObj = metaDataJsnObj;
		openButton.addClickHandler(new FilterBtnActionHandler());
		initWidget(vPanel);
		selectedView = parameterList.get(parameterList.size() - 1);
		setParameterList(parameterList);

		for (int i = 1; i < parameterList.size(); i++)
		{
			if (parameterList.get(i).trim().length() > 0)
			{
				isParameterPrsnt = true;
			}
		}
		if (isParameterPrsnt)
		{
			getMetaDataForFltr(parameterList);
		}
	}

	public ArrayList<String> getParameterList()
	{
		return parameterList;
	}

	public void setParameterList(ArrayList<String> parameterList)
	{
		this.parameterList = parameterList;
	}

	public void getMetaDataForFltr(final ArrayList<String> parameterList)
	{
		final ArrayList<FilterInfo> filterList = new MetaDataDtl().getFilters(metaDataJsnObj);
		final PopupPanel mainPopupPnl = new PopupPanel(true);
		VerticalPanel homePgFltrPopupVPnl = new VerticalPanel();
		HorizontalPanel finishCancelBtnsHPnl = new HorizontalPanel();
		Label headinglable = new Label("Analysis Scope");
		Image analysisImage = new Image("FusionChart/images/analysis_scope.png");
		Image finishimage = new Image("FusionChart/images/check.png");
		Image cancelimage = new Image("FusionChart/images/close.png");

		TextBox inputTxtBox = null;
		String[] fltrParmtrArray = null;
		String filtrString = "";
		int cnt = 0;
		int noOfFiltr = 0;
		Label columnNameLbl = null;
		popUpHPnl.setSpacing(5);
		if ((parameterList == null) || (parameterList != null && parameterList.size() <= 4))
		{
			homePgFltrPopupVPnl.setStylePrimaryName("fltrPopupVPnlWidthFixed");
		} else
		{
			homePgFltrPopupVPnl.setStylePrimaryName("fltrPopupVPnl");
		}
		for (int scrlPnlCnt = 0; scrlPnlCnt < popUpHPnl.getWidgetCount(); scrlPnlCnt++)
		{
			if (!(popUpHPnl.getWidget(scrlPnlCnt) instanceof Label))
			{
				noOfFiltr++;
			}
		}
		if (noOfFiltr != filterList.size())
		{
			popUpHPnl.clear();
			for (FilterInfo filterInfo : filterList)
			{
				cnt++;
				if (parameterList != null && parameterList.size() > 1)
				{
					filtrString = parameterList.get(cnt);
					if (filtrString.length() > 0)
					{
						fltrParmtrArray = getSplitedStrng(filtrString);
					} else
					{
						fltrParmtrArray = null;
					}
				}
				if (filterInfo.filterType.equals("1"))
				{
					inputTxtBox = new TextBox();
					inputTxtBox.setTitle(filterInfo.getColName());
					inputTxtBox.setStylePrimaryName("textBoxCss");

					VerticalPanel outerVPanel = new VerticalPanel();
					/* outerVPanel.setHeight("200px"); */
					HorizontalPanel Hpanel = new HorizontalPanel();
					VerticalPanel Vpanel = new VerticalPanel();
					columnNameLbl = new Label("" + filterInfo.getColName());
					Vpanel.add(columnNameLbl);
					columnNameLbl.setStyleName("filterHeaderLabel");
					Vpanel.setStyleName("filterHeaderPanel");
					Hpanel.add(inputTxtBox);
					outerVPanel.add(Vpanel);
					outerVPanel.add(Hpanel);

					if (fltrParmtrArray != null)
					{
						for (int arrayCnt = 0; arrayCnt < fltrParmtrArray.length; arrayCnt++)
						{
							inputTxtBox.setText(fltrParmtrArray[arrayCnt]);
						}
					}
					/*
					 * popUpHPnl.add(columnNameLbl); popUpHPnl.add(inputTxtBox);
					 */
					popUpHPnl.add(outerVPanel);
				}
				if (filterInfo.filterType.equals("2"))
				{
					getPopHlpStrgFrAutoComp(filterInfo, popUpHPnl, fltrParmtrArray);
				}
				if (filterInfo.filterType.equals("3") || filterInfo.filterType.equals("5"))
				{
					getPopHelpString(popUpHPnl, filterInfo, fltrParmtrArray);
				}
			}
		}

		headinglable.setStyleName("filterDivHeadingName"); //Dhanendra   12-09-2014
		HorizontalPanel analysispanel = new HorizontalPanel();
		finishCancelBtnsHPnl.setWidth("100%");
		//finishCancelBtnsHPnl.setCellHorizontalAlignment(headinglable, HasHorizontalAlignment.ALIGN_LEFT);
		finishCancelBtnsHPnl.getElement().setAttribute("text-align", "left");
		analysisImage.setHeight("30px");
		analysispanel.add(analysisImage);
		analysispanel.add(headinglable);

		finishCancelBtnsHPnl.add(analysispanel);

		HorizontalPanel hpanelforbutton = new HorizontalPanel();

		hpanelforbutton.getElement().setAttribute("align", "right");
		finishimage.setHeight("25px");
		cancelimage.setHeight("25px");
		hpanelforbutton.add(finishimage);
		hpanelforbutton.add(cancelimage);
		cancelimage.setStyleName("imgalignment");
		finishCancelBtnsHPnl.setCellHorizontalAlignment(hpanelforbutton, HasHorizontalAlignment.ALIGN_RIGHT);

		finishCancelBtnsHPnl.add(hpanelforbutton);

		finishCancelBtnsHPnl.setStyleName("filterdivHeading");
		finishCancelBtnsHPnl.setSpacing(2);
		homePgFltrPopupVPnl.add(finishCancelBtnsHPnl);
		homePgFltrPopupVPnl.add(popUpHPnl);

		mainPopupPnl.setPopupPosition(100, 60);
		mainPopupPnl.getElement().setId("filterMainOuterDiv");
		mainPopupPnl.add(homePgFltrPopupVPnl);
		mainPopupPnl.show();

		cancelimage.addClickHandler(new ClickHandler()
		{
			@Override
			public void onClick(ClickEvent event)
			{
				mainPopupPnl.hide();
			}
		});

		/* Added new Code for Enter Key Action on 12 Nov 2014 by Dhanendra */

		mainPopupPnl.addDomHandler(new KeyUpHandler()
		{
			public void onKeyUp(KeyUpEvent event)
			{
				int keyCode = event.getNativeKeyCode();
				if (keyCode == KeyCodes.KEY_ENTER)
				{
					//Window.alert("Title is =" + Window.getTitle());
					if (!Window.getTitle().equalsIgnoreCase(windowTitle))
					{
						getFltrSelectedData(filterList, mainPopupPnl);
					}
					else
					{
						Window.setTitle("");
					}
				}
			}
		}, KeyUpEvent.getType());

		/* Ended new Code for Enter Key Action on 12 Nov 2014 by Dhanendra */

		finishimage.addClickHandler(new ClickHandler()
		{
			@Override
			public void onClick(ClickEvent event)
			{
				
				getFltrSelectedData(filterList, mainPopupPnl);
			}
		});
	}

	public void getPopHelpString(final HorizontalPanel popUpHPnl, final FilterInfo filterInfo, final String[] splitedArray)
	{
		String objActionPath = "/ibase/DashboardFilterServlet?FIELDNAME=" +filterInfo.getColNameId() + "&OBJ_NAME=" + filterInfo.getColModuleName();
		try
		{
			/*Start by Dhanendra 20/11/2014 Code add for before loading pophelp data label name display*/
			final VerticalPanel outerVPanel = new VerticalPanel();
			if (filterInfo.filterType.equals("3"))
			{
				outerVPanel.setHeight("200px");
				VerticalPanel Vpanel = new VerticalPanel();
				Label labelTh = new Label("" + filterInfo.getColName());
				Vpanel.add(labelTh);
				labelTh.setStyleName("filterHeaderLabel");
				Vpanel.setStyleName("filterHeaderPanel");
				outerVPanel.add(Vpanel);
				popUpHPnl.add(outerVPanel);
			}else if(filterInfo.filterType.equals("5"))
			{
				outerVPanel.setHeight("200px");
				VerticalPanel Vpanel = new VerticalPanel();
				Label labelTh = new Label("" + filterInfo.getColName());
				Vpanel.add(labelTh);
				labelTh.setStyleName("filterHeaderLabel");
				Vpanel.setStyleName("filterHeaderPanel");
				outerVPanel.add(Vpanel);
				popUpHPnl.add(outerVPanel);
				
			}
			/*End by Dhanendra 20/11/2014 Code add for before loading pophelp data label name display*/
			
			RequestBuilder reqBuilder = new RequestBuilder(RequestBuilder.POST, objActionPath);
			reqBuilder.sendRequest(null, new RequestCallback()
			{
				@Override
				public void onResponseReceived(Request request, Response response)
				{
					if (filterInfo.filterType.equals("3"))
					{
						/*Start code comment for label not display after loading */
						
						/*VerticalPanel outerVPanel = new VerticalPanel();
						outerVPanel.setHeight("200px");
						VerticalPanel Vpanel = new VerticalPanel();
						Label labelTh = new Label("" + filterInfo.getColName());
						Vpanel.add(labelTh);
						labelTh.setStyleName("filterHeaderLabel");
						Vpanel.setStyleName("filterHeaderPanel");
						outerVPanel.add(Vpanel);*/
						
						/*END code comment for label not display after loading */
						
						HorizontalPanel Hpanel = new HorizontalPanel();
						Hpanel.add(popHlpGridChkBox(getPopUpDataMap(response.getText()), filterInfo, splitedArray));
						outerVPanel.add(Hpanel);
						popUpHPnl.add(outerVPanel);
					} else if (filterInfo.filterType.equals("5"))
					{
						
						/*Start code comment for label not display after loading */
						
						/*VerticalPanel outerVPanel = new VerticalPanel();
						outerVPanel.setHeight("200px");
						VerticalPanel Vpanel = new VerticalPanel();
						Label labelTh = new Label("" + filterInfo.getColName());
						Vpanel.add(labelTh);
						labelTh.setStyleName("filterHeaderLabel");
						Vpanel.setStyleName("filterHeaderPanel");
						outerVPanel.add(Vpanel);*/
						
						/*END code comment for label not display after loading */
						
						HorizontalPanel Hpanel = new HorizontalPanel();
						Hpanel.add(popHelpGridRadioBtn(getPopUpDataMap(response.getText()), filterInfo, splitedArray));
						outerVPanel.add(Hpanel);
						popUpHPnl.add(outerVPanel);
					}
				}
				@Override
				public void onError(com.google.gwt.http.client.Request request, Throwable exception)
				{
					Window.alert("Error occured " + exception.getMessage());
				}
			});
		} catch (RequestException e)
		{
			Window.alert("Error occured " + e.getMessage());
		}
	}

	public HashMap<String, ArrayList<String>> getPopUpDataMap(String xmlMetadata)
	{
		NodeList rootNodeList = null;
		Document document = null;
		Node groupNode = null;
		NodeList headerList = null;
		Node headerNode = null;
		NodeList detalList = null;
		Node detailNode = null;
		NodeList columnList = null;
		Node columnNode = null;
		ArrayList<String> columnDataList = null;
		HashMap<String, ArrayList<String>> columnValueMap = new HashMap<String, ArrayList<String>>();
		try
		{
			document = XMLParser.parse(xmlMetadata);
			if (document != null)
			{
				rootNodeList = document.getElementsByTagName("DOCUMENTROOT").item(0).getChildNodes();
				for (int rootCtr = 0; rootCtr < rootNodeList.getLength(); rootCtr++)
				{
					groupNode = rootNodeList.item(rootCtr);
					if ("GROUP0".equals(groupNode.getNodeName()))
					{
						headerList = groupNode.getChildNodes();
						for (int nodeCtr = 0; nodeCtr < headerList.getLength(); nodeCtr++)
						{
							headerNode = headerList.item(nodeCtr);
							if ("HEADER0".equals(headerNode.getNodeName()))
							{
								detalList = headerNode.getChildNodes();
								for (int headCtr = 0; headCtr < detalList.getLength(); headCtr++)
								{
									detailNode = detalList.item(headCtr);
									if ("DETAIL".equals(detailNode.getNodeName()))
									{
										columnDataList = new ArrayList<String>();
										columnList = detailNode.getChildNodes();
										for (int colNodCtr = 0; colNodCtr < columnList.getLength(); colNodCtr++)
										{
											columnNode = columnList.item(colNodCtr);
											columnDataList.add(columnNode.getChildNodes().item(0).getNodeValue());
										}
										columnValueMap.put("" + headCtr, columnDataList);
									}
								}
							}
						}
					}
				}
			}
		} catch (Exception e)
		{
			System.out.println(" Exception in  getparsing(String xmlMetadata)" + e.getMessage());
			e.printStackTrace();
		}
		return columnValueMap;
	}

	public Widget popHlpGridChkBox(HashMap<String, ArrayList<String>> hashMap, FilterInfo filterInfo, String[] paramtrArray)
	{
		final ScrollPanel checkboxScrlPnl = new ScrollPanel();
		checkboxScrlPnl.setTitle(filterInfo.getColName());
		checkboxScrlPnl.setStyleName("filterScrlPnl");
		CheckBox chkBox = null;
		String row = "";
		String colData = "";
		String parameterValue = "";
		ArrayList<String> values = null;
		int columnCnt = hashMap.get("0").size();
		try
		{
			final FlexTable flexTable = new FlexTable();
			//flexTable.setBorderWidth(1);
			flexTable.setStyleName("flexTable");
			final CheckBox selectAllChkBox = new CheckBox();

			for (int colNo = 0; colNo < columnCnt + 1; colNo++)
			{
				if (colNo == 0)
				{
					flexTable.setWidget(0, 0, selectAllChkBox);
					flexTable.getCellFormatter().setAlignment(0, 0, HasHorizontalAlignment.ALIGN_CENTER, HasVerticalAlignment.ALIGN_MIDDLE);
					flexTable.getCellFormatter().addStyleName(0, 0, "flexTable-cell");
				} else
				{
					flexTable.setText(0, 1, filterInfo.getColDescr());
					flexTable.setText(0, 2, "All");
					flexTable.getCellFormatter().addStyleName(0, 2, "flexTable-cell");
					flexTable.getCellFormatter().setVisible(0, 1, false);
				}
			}
			selectAllChkBox.addClickHandler(new ClickHandler()
			{
				@Override
				public void onClick(ClickEvent event)
				{
					CheckBox checkBox = (CheckBox) event.getSource();
					int noOfRow = flexTable.getRowCount();
					for (int rowCnt = 0; rowCnt < noOfRow; rowCnt++)
					{
						if (checkBox.getValue())
						{
							CheckBox box = (CheckBox) flexTable.getWidget(rowCnt + 1, 0);
							box.setValue(true);
						} else
						{
							CheckBox box = (CheckBox) flexTable.getWidget(rowCnt + 1, 0);
							box.setValue(false);
						}
					}
				}
			});

			for (Map.Entry<String, ArrayList<String>> entry : hashMap.entrySet())
			{
				row = entry.getKey();
				values = entry.getValue();
				for (int col = 0; col < 3; col++)
				{
					if (col == 0)
					{
						final int rowCnt = Integer.parseInt(row) + 1;
						chkBox = new CheckBox();
						chkBox.addClickHandler(new ClickHandler()
						{
							@Override
							public void onClick(ClickEvent event)
							{
								CheckBox checkBox = (CheckBox) event.getSource();
								if (!checkBox.getValue())
								{
									selectAllChkBox.setValue(false);
								}
							}
						});
						flexTable.getCellFormatter().setAlignment(rowCnt, col, HasHorizontalAlignment.ALIGN_CENTER, HasVerticalAlignment.ALIGN_MIDDLE);
						flexTable.getCellFormatter().setWidth(rowCnt, col, "5em");
						flexTable.setWidget(rowCnt, col, chkBox);
					} else
					{
						flexTable.setText(Integer.parseInt(row) + 1, col, values.get(col - 1));
						if (col == 1)
						{
							if (paramtrArray != null)
							{
								colData = values.get(col - 1);
								for (int paramtrCnt = 0; paramtrCnt < paramtrArray.length; paramtrCnt++)
								{
									parameterValue = paramtrArray[paramtrCnt];
									if (parameterValue.trim().equalsIgnoreCase(colData.trim()))
									{
										CheckBox box = (CheckBox) flexTable.getWidget(Integer.parseInt(row) + 1, 0);
										box.setValue(true);
									}
								}
							}
							flexTable.getCellFormatter().setVisible(Integer.parseInt(row) + 1, 1, false);
						}
					}
				}
			}
			//checkboxScrlPnl.add(flexTableTH);
			checkboxScrlPnl.add(flexTable);
		} catch (Exception e)
		{
			Window.alert("Exception is " + e.getMessage());
		}
		return checkboxScrlPnl;
	}

	public Widget popHelpGridRadioBtn(HashMap<String, ArrayList<String>> hashMap, FilterInfo filterInfo, String[] paramtrArray)
	{
		String row = "";
		String colData = "";
		String parameterValue = "";
		RadioButton radioBtn = null;
		ArrayList<String> values = null;
		final ScrollPanel checkboxScrlPnl = new ScrollPanel();
		checkboxScrlPnl.setTitle(filterInfo.getColName());
		checkboxScrlPnl.setStyleName("filterScrlPnl");
		final FlexTable flexTable = new FlexTable();
		flexTable.setStyleName("flexTable");
		//flexTable.setBorderWidth(1);
		try
		{
			for (Map.Entry<String, ArrayList<String>> entry : hashMap.entrySet())
			{
				row = entry.getKey();
				values = entry.getValue();
				for (int colCnt = 0; colCnt < 3; colCnt++)
				{
					if (colCnt == 0)
					{
						final int rowCnt = Integer.parseInt(row) + 1;
						radioBtn = new RadioButton(filterInfo.getColNameId());
						flexTable.getCellFormatter().setAlignment(rowCnt, colCnt, HasHorizontalAlignment.ALIGN_CENTER, HasVerticalAlignment.ALIGN_MIDDLE);
						flexTable.getCellFormatter().setWidth(rowCnt, colCnt, "5em");
						flexTable.setWidget(rowCnt, colCnt, radioBtn);
					} else
					{
						flexTable.setText(Integer.parseInt(row) + 1, colCnt, values.get(colCnt - 1));
						if (colCnt == 1)
						{
							if (paramtrArray != null)
							{
								colData = values.get(colCnt - 1);
								for (int paramtrCnt = 0; paramtrCnt < paramtrArray.length; paramtrCnt++)
								{
									parameterValue = paramtrArray[paramtrCnt];
									if (parameterValue.trim().equalsIgnoreCase(colData.trim()))
									{
										RadioButton radioBtnOnLod = (RadioButton) flexTable.getWidget(Integer.parseInt(row) + 1, 0);
										radioBtnOnLod.setValue(true);
									}
								}
							}
							flexTable.getCellFormatter().setVisible(Integer.parseInt(row) + 1, 1, false);
						}
					}
				}
			}
			checkboxScrlPnl.add(flexTable);
		} catch (Exception e)
		{
			Window.alert("Exception is " + e.getMessage());
		}
		return checkboxScrlPnl;
	}

	private String[] getSplitedStrng(String year)
	{
		String[] splitedArray = null;
		if (year != null && year.length() > 0)
		{
			splitedArray = year.split(",");
		}
		return splitedArray;
	}

	public void getPopHlpStrgFrAutoComp(final FilterInfo filterInfo, final HorizontalPanel popUpHPnl, final String[] splitedArray)
	{

		String objActionPath = "/ibase/DashboardFilterServlet?FIELDNAME=" + filterInfo.getColNameId() + "&OBJ_NAME=" + filterInfo.getColModuleName();
		try
		{
			final VerticalPanel outerVPanel = new VerticalPanel();
			VerticalPanel vPanel = new VerticalPanel();
			Label columnNameLbl = null;
			columnNameLbl = new Label("" + filterInfo.getColName());
			vPanel.add(columnNameLbl);
			columnNameLbl.setStyleName("filterHeaderLabel");
			vPanel.setStyleName("filterHeaderPanel");
			outerVPanel.add(vPanel);
			popUpHPnl.add(outerVPanel);
			
			RequestBuilder reqBuilder = new RequestBuilder(RequestBuilder.POST, objActionPath);
			reqBuilder.sendRequest(null, new RequestCallback()
			{
				@Override
				public void onResponseReceived(Request request, Response response)
				{
					/*Start code comment for label not display after loading */
					
						
					/*VerticalPanel outerVPanel = new VerticalPanel();
					VerticalPanel vPanel = new VerticalPanel();
					columnNameLbl = new Label("" + filterInfo.getColName());
					vPanel.add(columnNameLbl);
					columnNameLbl.setStyleName("filterHeaderLabel");
					vPanel.setStyleName("filterHeaderPanel");
					Hpanel.add(inputTxtBox);
					outerVPanel.add(vPanel); */
					
					/*END code comment for label not display after loading */
					
					HorizontalPanel hPanel = new HorizontalPanel();
					new InputListWidget(response.getText(), hPanel, filterInfo, splitedArray);
					outerVPanel.add(hPanel);
					popUpHPnl.add(outerVPanel);
					}

				@Override
				public void onError(com.google.gwt.http.client.Request request, Throwable exception)
				{
					Window.alert("Error occured " + exception.getMessage());
				}
			});
		} catch (RequestException e)
		{
			Window.alert("Error occured " + e.getMessage());
		}
	}

	public class FilterBtnActionHandler implements ClickHandler
	{
		@Override
		public void onClick(ClickEvent event)
		{
			getMetaDataForFltr(null);
		}
	}

	public String getMonth(String month)
	{
		String selectedMonth = month.substring(4, 6);
		String year = month.substring(0, 4);
		String monthInChar = "";
		if (selectedMonth.equals("01"))
		{
			monthInChar = "Jan";
		}
		if (selectedMonth.equals("02"))
		{
			monthInChar = "Feb";
		}
		if (selectedMonth.equals("03"))
		{
			monthInChar = "Mar";
		}
		if (selectedMonth.equals("04"))
		{
			monthInChar = "Apr";
		}
		if (selectedMonth.equals("05"))
		{
			monthInChar = "May";
		}
		if (selectedMonth.equals("06"))
		{
			monthInChar = "Jun";
		}
		if (selectedMonth.equals("07"))
		{
			monthInChar = "Jul";
		}
		if (selectedMonth.equals("08"))
		{
			monthInChar = "Aug";
		}
		if (selectedMonth.equals("09"))
		{
			monthInChar = "Sep";
		}
		if (selectedMonth.equals("10"))
		{
			monthInChar = "Oct";
		}
		if (selectedMonth.equals("11"))
		{
			monthInChar = "Nov";
		}
		if (selectedMonth.equals("12"))
		{
			monthInChar = "Dec";
		}

		monthInChar = year + " - " + monthInChar;
		return monthInChar;
	}

	@SuppressWarnings("serial")
	public ScrollPanel getViewFilter(final ArrayList<String> parameterList, JSONObject metaDataJsnObj)
	{
		ScrollPanel viewPanel = null;
		String xmlMetadata = null;
		Document document = null;
		NodeList rootNodeList = null;
		Node rootNode = null;
		int count = 0;
		//	NodeList viewNodeList = null;
		//	Node viewNode = null;
		// String view=null;
		final String image = "<img align='top' src='FusionChart/images/menu_button.png' height='18px' width='25px'/>";

		MenuBar menu = new MenuBar();
		try
		{
			//	(new CustomGrid(10)).showOptionMenu();
			xmlMetadata = metaDataJsnObj.get("metaData").toString();
			xmlMetadata = metaDataJsnObj.get("metaData").toString().replace("\\", "").trim();
			xmlMetadata = xmlMetadata.replace('"', ' ').trim();
			document = XMLParser.parse(xmlMetadata);
			XMLParser.removeWhitespace(document);
			MenuBar fileMenu = new MenuBar(true);
			fileMenu.setStyleName("popupMenuBar");
			fileMenu.setAnimationEnabled(true);
			menu.setStyleName("menuCSS");
			SafeHtml addActivityImagePath = new SafeHtml()
			{
				public String asString()
				{
					return image;
				}
			};
			if (document != null)
			{
				rootNodeList = document.getElementsByTagName("Root").item(0).getChildNodes();
				for (int rootCtr = 0; rootCtr < rootNodeList.getLength(); rootCtr++)
				{
					rootNode = rootNodeList.item(rootCtr);
					if ("view".equals(rootNode.getNodeName()))
					{
						count++;
						final String view = rootNode.getAttributes().getNamedItem("name").getNodeValue();
						MenuItem actionItem = new MenuItem(view, new Command()
						{
							public void execute()
							{
								ArrayList<String> selectedParamList = getParameterList();
								selectedView = view;
								selectedParamList.remove(parameterList.size() - 1);
								selectedParamList.add(view);
								E12DashBoardPage.initaliseGraphNGrid(selectedParamList);
							}
						});
						fileMenu.addItem(actionItem);
						actionItem.setStyleName("popupMenuItem");
					}
				}
				if (count > 1)
				{
					viewPanel = new ScrollPanel();
					viewPanel.setWidth("100%");
					menu.addItem(new MenuItem(addActivityImagePath, fileMenu));
					viewPanel.add(menu);
					viewPanel.setStyleName("scrllPnlMenuBar");
				}
			}
		} catch (Exception e)
		{
			Window.alert("Exception in Class FilterCreator:getViewFilter():" + e.getMessage());
		}

		return viewPanel;
	}

	private void getFltrSelectedData(ArrayList<FilterInfo> filterList, PopupPanel mainPopupPnl)
	{

		boolean isFilterNotSelected = false;
		int row = 0;
		FlexTable grid = null;
		CheckBox checkBox = null;
		TextBox fltrTxtBox = null;
		BulletList bulletList = null;
		ScrollPanel scrollPnl = null;
		ArrayList<String> popUpSendDtatList = new ArrayList<String>();
		FilterInfo fltrInfo = null;
		String colName = "";
		popUpSendDtatList.add(xmlName);
		ListItem listItem = null;
		Paragraph paragraph = null;
		StringBuffer selectedChkBoxBuffer = null;
		HorizontalPanel horizontalPanel = null;
		VerticalPanel verticalPanel = null;
		String colNameId = "";
		for (int i = 0; i < filterList.size(); i++)
		{
			fltrInfo = filterList.get(i);
			colName = fltrInfo.getColName();
			colNameId = fltrInfo.getColNameId();
			
			
			for (int scrlPnlCnt = 0; scrlPnlCnt < popUpHPnl.getWidgetCount(); scrlPnlCnt++)
			{
				if (popUpHPnl.getWidget(scrlPnlCnt) instanceof VerticalPanel)
				{
					verticalPanel = (VerticalPanel) popUpHPnl.getWidget(scrlPnlCnt);
					if (verticalPanel.getWidget(1) instanceof HorizontalPanel)
					{
						horizontalPanel = (HorizontalPanel) verticalPanel.getWidget(1);
						if (horizontalPanel.getWidget(0) instanceof ScrollPanel)
						{
							scrollPnl = (ScrollPanel) horizontalPanel.getWidget(0);
							selectedChkBoxBuffer = new StringBuffer();
							grid = (FlexTable) scrollPnl.getWidget();
							row = grid.getRowCount();
							for (int rowCnt = 1; rowCnt < row; rowCnt++)
							{
								checkBox = (CheckBox) grid.getWidget(rowCnt, 0);
								if (checkBox.getValue())
								{
									if (selectedChkBoxBuffer.length() != 0)
									{
										selectedChkBoxBuffer.append("," + grid.getText(rowCnt, 1).trim());
									} else
									{
										selectedChkBoxBuffer.append(grid.getText(rowCnt, 1).trim());
									}
								}
							}
							if (scrollPnl.getTitle().equals(colName))
							{
								//if (selectedChkBoxBuffer.toString().trim().length() != 0)
								if (selectedChkBoxBuffer.toString()!= null) 
								{
									popUpSendDtatList.add(selectedChkBoxBuffer.toString());
								} else
								{
									if(!"CUST_CODE_SUNUSA".equalsIgnoreCase(colNameId) && !"CUST_CODE_DLV".equalsIgnoreCase(colNameId))
									{
										Window.alert(fltrInfo.getColName() + "Can't Be Empty");
										Window.setTitle(windowTitle);
										isFilterNotSelected = true;
									}
										
								}

							}

						} else if (horizontalPanel.getWidget(0) instanceof TextBox)
						{
							fltrTxtBox = (TextBox) horizontalPanel.getWidget(0);
							if (fltrTxtBox.getTitle().equals(colName))
							{
								//if (!fltrTxtBox.getText().isEmpty())
								if (fltrTxtBox.getText()!=null)
								{
									popUpSendDtatList.add(fltrTxtBox.getText());
								} else
								{
									
									if(!"CUST_CODE_SUNUSA".equalsIgnoreCase(colNameId) && !"CUST_CODE_DLV".equalsIgnoreCase(colNameId))
									{
										Window.alert(fltrInfo.getColName() + "Can't Be Empty");
										Window.setTitle(windowTitle);
										isFilterNotSelected = true;
									}
								}
							}
						} else if (horizontalPanel.getWidget(0) instanceof BulletList)
						{
							bulletList = (BulletList) horizontalPanel.getWidget(0);
							selectedChkBoxBuffer = new StringBuffer();
							if (bulletList.getTitle().equals(colName))
							{
								for (int j = 0; j < bulletList.getWidgetCount(); j++)
								{
									if (bulletList.getWidget(j) instanceof ListItem)
									{
										listItem = (ListItem) bulletList.getWidget(j);
										if (listItem.getWidget(0) instanceof Paragraph)
										{
											paragraph = (Paragraph) listItem.getWidget(0);

											if (selectedChkBoxBuffer.length() != 0)
											{
												selectedChkBoxBuffer.append("," + paragraph.getText().trim());
											} else
											{
												selectedChkBoxBuffer.append(paragraph.getText().trim());
											}

										}
									}
								}
								//if (selectedChkBoxBuffer.toString().trim().length() != 0)
								if (selectedChkBoxBuffer.toString()!= null)
								{
									popUpSendDtatList.add(selectedChkBoxBuffer.toString());
								} else
								{
									/*if(!"CUST_CODE_SUNUSA".equalsIgnoreCase(colNameId) || !"CUST_CODE_DLV".equalsIgnoreCase(colNameId))
									{
									Window.alert(fltrInfo.getColName() + "Can't Be Empty");
									Window.setTitle(windowTitle);
									isFilterNotSelected = true;
									}*/
									if(!"CUST_CODE_SUNUSA".equalsIgnoreCase(colNameId) && !"CUST_CODE_DLV".equalsIgnoreCase(colNameId))
									{
										Window.alert(fltrInfo.getColName() + "Can't Be Empty");
										Window.setTitle(windowTitle);
										isFilterNotSelected = true;
									}
								}
							}
						}
					}
				}

			}
		}
		
		
		if (!isFilterNotSelected)
		{
			Window.setTitle("");
			mainPopupPnl.hide();
			popUpSendDtatList.add(selectedView);
			setParameterList(popUpSendDtatList);
			E12DashBoardPage.initaliseGraphNGrid(popUpSendDtatList);
		}
	}
}