package ibase.client;

import ibase.client.resources.Resources;

import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.VerticalPanel;

public class E12LoadingInterface {
	private PopupPanel loadingPnl = null;
	private Label loadingInfo = new Label( "" );
	private static final ImageResource LOAD_IMG = Resources.INSTANCE.loadingImg();
	
	public E12LoadingInterface(){
		setLoading(false);
	}
	
	public void setLoading( boolean flag ) 
	{
		if( loadingPnl == null )
		{
			loadingInfo.setStyleName( "busyIndicatorMessage" );
			loadingInfo.setText( "Loading..." );
			loadingPnl = new PopupPanel();
			loadingPnl.setStyleName( "loadingPnl" );
			Image loadingImg = new Image();
			loadingImg.setResource( LOAD_IMG );
			VerticalPanel container = new VerticalPanel();
			container.setStyleName( "busyIndicatorContainer" );
			container.setSpacing( 5 );
			container.add( loadingImg );
			container.add( loadingInfo );
			container.setCellHorizontalAlignment(loadingImg, HasAlignment.ALIGN_CENTER);
			container.setCellHorizontalAlignment(loadingInfo, HasAlignment.ALIGN_CENTER);
			loadingPnl.add( container );
			loadingPnl.setModal(true);
			loadingPnl.setGlassEnabled(true);
			loadingPnl.center();
		}
		if( flag )
		{
			loadingPnl.setPopupPositionAndShow(new PopupPanel.PositionCallback() {
				  
			    public void setPosition(int offsetWidth, int offsetHeight) 
			    {
			       int clientWidth = Window.getClientWidth() ;
			       int left = ( ( clientWidth - offsetWidth ) / 2 ) ;
			       int top = loadingPnl.getPopupTop();
			       loadingPnl.setPopupPosition( left, top );
		        }
		   });			
		}
		else
		{
			loadingPnl.hide();
		}
	}
	
	public void setLoadingImg( boolean flag ) 
	{
		if( loadingPnl == null )
		{
			//loadingInfo.setStyleName( "busyIndicatorMessage" );
			loadingInfo.setText( "Loading..." );
			loadingPnl = new PopupPanel();
			//loadingPnl.setStyleName( "loadingPnl" );
			Image loadingImg = new Image();
			loadingImg.setResource( LOAD_IMG );
			VerticalPanel container = new VerticalPanel();
			//container.setStyleName( "busyIndicatorContainer" );
			container.setSpacing( 5 );
			container.add( loadingImg );
			container.add( loadingInfo );
			container.setCellHorizontalAlignment(loadingImg, HasAlignment.ALIGN_CENTER);
			container.setCellHorizontalAlignment(loadingInfo, HasAlignment.ALIGN_CENTER);
			loadingPnl.add( container );
			loadingPnl.setModal(true);
			loadingPnl.setGlassEnabled(true);
			loadingPnl.center();
		}
		if( flag )
		{
			loadingPnl.show();
		}
		else
		{
			loadingPnl.hide();
		}
	}
	
	
	public void setLoadingInfo( String loadingInfoStr )
	{
		loadingInfo.setText( loadingInfoStr );
	}
}
