/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.shared.impl.cldr;

// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA
//  cldrVersion=21.0
//  number=$Revision: 6546 $
//  type=ha
//  date=$Date: 2012-02-07 13:32:35 -0500 (Tue, 07 Feb 2012) $

/**
 * Implementation of DateTimeFormatInfo for the "ha" locale.
 */
public class DateTimeFormatInfoImpl_ha extends DateTimeFormatInfoImpl {

  @Override
  public String dateFormatFull() {
    return "EEEE, d MMMM, y";
  }

  @Override
  public String dateFormatLong() {
    return "d MMMM, y";
  }

  @Override
  public String dateFormatMedium() {
    return "d MMM, y";
  }

  @Override
  public String dateFormatShort() {
    return "d/M/yy";
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "Kafin haihuwar annab",
        "Bayan haihuwar annab"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "KHAI",
        "BHAI"
    };
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "EEEE, MMMM d";
  }

  @Override
  public String formatMonthNumDay() {
    return "M/d";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "MMM y";
  }

  @Override
  public String formatYearMonthFull() {
    return "MMMM y";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "d MMMM, y";
  }

  @Override
  public String formatYearMonthNum() {
    return "M/y";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "EEE, MMM d, y";
  }

  @Override
  public String formatYearQuarterFull() {
    return "QQQQ y";
  }

  @Override
  public String formatYearQuarterShort() {
    return "Q y";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "Janairu",
        "Faburairu",
        "Maris",
        "Afirilu",
        "Mayu",
        "Yuni",
        "Yuli",
        "Agusta",
        "Satumba",
        "Oktoba",
        "Nuwamba",
        "Disamba"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "J",
        "F",
        "M",
        "A",
        "M",
        "Y",
        "Y",
        "A",
        "S",
        "O",
        "N",
        "D"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "Jan",
        "Fab",
        "Mar",
        "Afi",
        "May",
        "Yun",
        "Yul",
        "Agu",
        "Sat",
        "Okt",
        "Nuw",
        "Dis"
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "Kwata na ɗaya",
        "Kwata na biyu",
        "Kwata na uku",
        "Kwata na huɗu"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "K1",
        "K2",
        "K3",
        "K4"
    };
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "Lahadi",
        "Litinin",
        "Talata",
        "Laraba",
        "Alhamis",
        "Jumma'a",
        "Asabar"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "L",
        "L",
        "T",
        "L",
        "A",
        "J",
        "A"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "Lh",
        "Li",
        "Ta",
        "Lr",
        "Al",
        "Ju",
        "As"
    };
  }
}
