package ibase.dashboard.sfa.servlet;

import ibase.dashboard.sfa.ejb.RejectionTemplSummaryRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;

import java.io.IOException;
import java.io.OutputStream;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.json.simple.JSONObject;

public class RejectionTemplDetServlet extends HttpServlet 
{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		RejectionTemplSummaryRemote rejectionRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		String templateID = "", fromDate = "", toDate = "";
		try
		{
			response.setContentType("application/xml");
			dataSourceName  = request.getParameter("dataSourceName");
			templateID      = request.getParameter("CELL_VAL");
			fromDate        = request.getParameter("fromDate");
			toDate          = request.getParameter("toDate");
			System.out.println("Template ID====="+templateID +"fromDate==="+fromDate+"toDate=="+toDate);
			context = new InitialContext(appConnectParm.getProperty());
			rejectionRemote = (RejectionTemplSummaryRemote) context.lookup("ibase/RejectionTemplSummary/remote");
			JSONObject jsonObjData = (JSONObject) rejectionRemote.getTemplDetail(dataSourceName,fromDate,toDate,templateID);
			OutputStream outputStream   = response.getOutputStream();			
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println("JSON data for RejectionTemplDetServlet is ==" + jsonObjData);
		
			

		} catch (Exception e)
		{
			System.out.println("Exception : RejectionTemplDetServlet.doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}

	}

	
}
