package ibase.webitm.ejb.sys;

import ibase.webitm.utility.*;
import ibase.webitm.ejb.*;
import ibase.webitm.bean.*;
import ibase.utility.CommonConstants;
import ibase.system.config.*;
import ibase.utility.UserInfoBean;
import ibase.scheduler.utility.interfaces.Schedule;
import java.util.*;
import java.rmi.*;
import javax.ejb.*;
import javax.rmi.*;
import java.io.File;
import java.io.FileWriter;
import java.io.*;
import java.lang.String;
import javax.mail.*;
import javax.mail.internet.*;
import javax.activation.*;
import java.sql.*;

import org.apache.log4j.*;
import org.w3c.dom.*;

public class DownloadCSVBatchBean  implements Schedule
{
	protected ibase.utility.UserInfoBean userInfo = null;
		
	public void downloadTransaction( String objName, String downloadLoc, String entityCode, 
	String entityType, String siteCodeDnld, String custCodeDnld ) throws RemoteException, ITMException
	{
		String templUpld = null;
		String templTypeUpld = null;
		String templDnld = null;
		String templTypeDnld = null;
		String objEximpFmt = null;
		
		TranXmlData client = null;
		String dnldFileNameServer = null;
		String dnldFileNameEmail = null;
		String downloadLocEmail = null;
		String xmlToCsvStr = null;
		HashMap emailHash = new HashMap();
		HashMap tranFileMip = new HashMap();
		// 11/09/09 manoharan DI89SUN223
		HashMap tranSeqMap = new HashMap();
		// end 11/09/09 manoharan
		
		String tranId = null;
		String custCode = null;
		String siteCode = null;
		String emailAddr = null;
		String uniformCode = null;
		String dt = null;
		String dty = null;
		String trfCycle = null;
		String prvCustCode = null;
		String previousDay = null;
		String trfType = null;
		String filePath =  null;
		String retString =  null;
		String subject =  null;
		int recCounter = 0;
		String text =  null;
		java.sql.Timestamp fromDate = null;
		java.sql.Timestamp toDate = null;

		boolean isTemplateExist = false;
				
		siteCodeDnld = ( siteCodeDnld != null && siteCodeDnld.equalsIgnoreCase( "null" ) ) ?
						"" : siteCodeDnld.trim();
		custCodeDnld = ( custCodeDnld != null && custCodeDnld.equalsIgnoreCase( "null" ) ) ? 
						"" : custCodeDnld.trim();
		String sql = null;
		
		//System.out.println( "downloadLoc:: " + downloadLoc );
		
		sql = " SELECT OBJ_NAME, TEMPL_UPLD, TEMPL_TYPE_UPLD, TEMPL_DNLD, TEMPL_TYPE_DNLD"
			 +" FROM OBJECT_EXIM_FMT "
			 +" WHERE OBJ_NAME  = '" + objName + "'"
			 +"	AND OBJ_CONTEXT = '" + entityType.trim() + "-" + entityCode.trim() + "'";
			 
			 
		java.sql.Connection conn = null;
		java.sql.PreparedStatement pstmt = null;
		java.sql.ResultSet rs = null;

		java.sql.PreparedStatement pstmtSeq = null;
		java.sql.PreparedStatement pstmtSeq2 = null;
		java.sql.ResultSet rsSeq = null;
		java.sql.ResultSet rsSeq2 = null;		
		java.sql.Timestamp tranDate = null;

		
		ConnDriver connDriver = new ConnDriver();
		try
		{
			conn = connDriver.getConnectDB( "DriverITM" );
			conn.setAutoCommit( false );
			
			pstmt = conn.prepareStatement( sql );
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				objName = rs.getString( "OBJ_NAME" );
				templUpld = rs.getString( "TEMPL_UPLD" );
				templTypeUpld = rs.getString( "TEMPL_TYPE_UPLD" );
				templDnld = rs.getString( "TEMPL_DNLD" );
				templTypeDnld = rs.getString( "TEMPL_TYPE_DNLD" );
				
				isTemplateExist = true;
			}
			/*System.out.println( " isTemplateExist :: [" + isTemplateExist + "]" );
			System.out.println( " objName :: [" + objName + "]" );
			System.out.println( " templUpld :: [" + templUpld + "]" );
			System.out.println( " templTypeUpld :: [" + templTypeUpld + "]" );
			System.out.println( " templDnld :: [" + templDnld + "]" );
			System.out.println( " templTypeDnld :: [" + templTypeDnld + "]" );
			*/
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		}catch( Exception ex )
		{
			ex.printStackTrace();
		}
		if( isTemplateExist )
		{
			GenericUtility genericUtility = GenericUtility.getInstance();
			
			//String xlsFileName = null;
			//String csvData = null;
			
			try
			{
				if( templTypeDnld.equalsIgnoreCase( "C" ) )
				{
					

					if( objName.equalsIgnoreCase( "INVOICE" ) )
					{
						//start - select all the undownloaded invoice, if found, 
						//then download for each.
						sql =" SELECT IV.INVOICE_ID TRAN_ID, IV.CUST_CODE CUST_CODE, "
							+"		IV.SITE_CODE SITE_CODE, CU.EMAIL_ADDR EMAIL_ADDR, "
							+"		CU.UNIFORM_CODE UNIFORM_CODE, "
							+"		TO_CHAR( IV.TRAN_DATE, 'DDMMYYYY' ) DTY, "
							+"		TO_CHAR( IV.TRAN_DATE, 'DDMM' ) DT, IV.TRAN_DATE TRAN_DATE, "
							+"		SC.INV_TRF_TYPE INV_TRF_TYPE, SC.INV_TRF_CYCLE INV_TRF_CYCLE "
							+" FROM INVOICE IV, CUSTOMER CU, SITE_CUSTOMER SC  "
							+" WHERE IV.CUST_CODE__BIL = CU.CUST_CODE "
							+"		AND IV.SITE_CODE = SC.SITE_CODE "
							+"		AND IV.CUST_CODE__BIL = SC.CUST_CODE "
							+"		AND SC.DOWNLOAD_YN = 'Y' "
							+"		AND ( IV.DOWNLOAD_FLAG IS NULL OR IV.DOWNLOAD_FLAG = 'N' ) ";
							
						if( siteCodeDnld != null && siteCodeDnld.trim().length() > 0
						&& custCodeDnld != null && custCodeDnld.trim().length() > 0 )
						{
							sql = sql + " AND IV.SITE_CODE = ? "
								+"	AND IV.CUST_CODE = ? ";
						}
						sql = sql + " ORDER BY IV.CUST_CODE, IV.TRAN_DATE, IV.INVOICE_ID ASC  ";
						
						pstmt = conn.prepareStatement( sql );
						if( siteCodeDnld != null && siteCodeDnld.trim().length() > 0
						&& custCodeDnld != null && custCodeDnld.trim().length() > 0 )
						{
							pstmt.setString(1, siteCodeDnld);
							pstmt.setString(2, custCodeDnld);
						}
						rs = pstmt.executeQuery();
						prvCustCode = null;
						recCounter = 0;
						while( rs.next() )
						{	
							tranFileMip = new HashMap();
							emailHash = new HashMap();
							retString =  null;
							tranId = rs.getString( "TRAN_ID" );
							custCode = rs.getString( "CUST_CODE" );
							siteCode = rs.getString( "SITE_CODE" );
							emailAddr = rs.getString( "EMAIL_ADDR" );
							uniformCode = rs.getString( "UNIFORM_CODE" );
							dt = rs.getString( "DT" );
							dty = rs.getString( "DTY" );
							tranDate = rs.getTimestamp( "TRAN_DATE" );
							trfType = rs.getString( "INV_TRF_TYPE" );
							trfCycle = rs.getString( "INV_TRF_CYCLE" );
							
							System.out.println("tranDate =="+tranDate);
							System.out.println("custCode =="+custCode);
							System.out.println("prvCustCode =="+prvCustCode);
							System.out.println("dt =="+dt);
							System.out.println("previousDay =="+previousDay);
							
							// 11/09/09 manoharan DI89SUN223 to store the sequence number 
							//(file suffix) in invoice table and increment for the same day 
							pstmtSeq2 = conn.prepareStatement("SELECT NVL(MAX(CASE WHEN DOWNLOAD_FILE_SEQ "
									+" IS NULL THEN 0 ELSE DOWNLOAD_FILE_SEQ END),0) AS DOWNLOAD_FILE_SEQ "
									+" FROM INVOICE WHERE CUST_CODE = ? AND TRAN_DATE = ? "
									+" AND DOWNLOAD_FLAG = 'Y'");
							// end 11/09/09 manoharan to store the sequence number 
							//(file suffix) in invoice table and increment for the same day
						
							tranFileMip.put( "tranId", tranId );
							tranFileMip.put( "templDnld", templDnld );
							
							// 27/04/10 sachin---to send file in new format as IDDMM<invoice id>.CSV
 							// for email start
							if(!("S".equalsIgnoreCase(trfType)))
							{
								dnldFileNameEmail = "I"+ dt + tranId.trim();
								tranFileMip.put( "dnldFileName", dnldFileNameEmail );
								
								downloadLocEmail = CommonConstants.JBOSSHOME + File.separator 
									+ "server" + File.separator + "default" + File.separator 
									+ "tmp";
								
								filePath = downloadLocEmail + File.separator + dnldFileNameEmail 
										+ ".csv";
									
								System.out.println(filePath);
								
								subject = "Invoice in CSV format for Invoice No." +tranId;
								text = "Dear Sir/Madam,\n Please find the attached CSV file "
									+" for Invoice No. "+tranId;
								
								if(emailAddr == null && emailAddr.equalsIgnoreCase(" "))
								{
									emailAddr = "";
								}
								
								
								emailHash.put("TO_ADDR", emailAddr); 
								emailHash.put("SUBJECT", subject);
								emailHash.put("TEXT", text);
								emailHash.put("FILEPATH", filePath);
							}
							// 27/04/10 sachin---to send file in new format as IDDMM<invoice id>.CSV
 							// for email end
							
							// 06/04/10 SY90SUN012 -sachin to select the peroid against 
							//the tran date from period table start
							
							pstmtSeq = conn.prepareStatement( " SELECT FR_DATE, TO_DATE FROM PERIOD "
							+" WHERE ? BETWEEN FR_DATE AND TO_DATE ");
							
							pstmtSeq.setTimestamp(1, tranDate);
							rsSeq = pstmtSeq.executeQuery();
							if( rsSeq.next() )
							{	
								fromDate = rsSeq.getTimestamp( "FR_DATE" );
								toDate = rsSeq.getTimestamp( "TO_DATE" );
					
							}
							rsSeq.close();
							rsSeq = null;
							pstmtSeq.close();
							pstmtSeq = null;
							
							// end 06/04/10 SY90SUN012 sachin to select the peroid 
							//against the tran date from period table end
														
							if(trfCycle != null && trfCycle.equalsIgnoreCase( "O" ))
							{
								pstmtSeq = conn.prepareStatement( " SELECT IV.INV_EXP_DATE "
										+" FROM INVOICE IV, SITE_CUSTOMER SC "
										+" WHERE IV.CUST_CODE__BIL = SC.CUST_CODE "
										+" AND IV.SITE_CODE = SC.SITE_CODE "
										+" AND IV.INV_EXP_DATE IS NOT NULL "
										+" AND IV.TRAN_DATE BETWEEN  ? AND ? "
										+" AND IV.SITE_CODE = ? "
										+" AND IV.CUST_CODE = ? "
										+" AND IV.DOWNLOAD_FLAG = 'Y' " );
								
								pstmtSeq.setTimestamp(1, fromDate);
								pstmtSeq.setTimestamp(2, toDate);
								pstmtSeq.setString(3, siteCode);
								pstmtSeq.setString(4, custCode);
								
								rsSeq = pstmtSeq.executeQuery();
								if( rsSeq.next() )
								{
									updateFlag(tranId, conn);
									System.out.println("Inside Once -- already downloaded ");
								}
								else
								{	
									if(!("S".equalsIgnoreCase(trfType)))
									{
										download(tranFileMip, downloadLocEmail);
										retString = sendMail(emailHash, conn);
										deleteFile(filePath);
									}
									if(!("E".equalsIgnoreCase(trfType)))
									{
										if( custCode.equalsIgnoreCase( prvCustCode ) && dt.equalsIgnoreCase( previousDay  ) )
										{
											recCounter++;
										}
										else
										{
											// 11/09/09 DI89SUN223 manoharan to store the sequence number 
											// (file suffix) in invoice table and increment for the same day 
											//recCounter = 1;
											
											pstmtSeq2.setString(1,custCode);
											pstmtSeq2.setTimestamp(2,tranDate);
											rsSeq2 = pstmtSeq2.executeQuery();
											if( rsSeq2.next() )
											{
												recCounter = rsSeq2.getInt("download_file_seq");
												
												System.out.println(recCounter);
											}
											rsSeq2.close();
											rsSeq2 = null;
											
											recCounter++;
											
											// end 11/09/09 manoharan to store the sequence number (file suffix)
											// in invoice table and increment for the same day
										}
										
										System.out.println(recCounter);
										dnldFileNameServer = ( uniformCode == null ? "" : uniformCode.trim() )  
										+ "_" + dty + "_" 
										+ ( new java.text.DecimalFormat( "000" ) ).format( recCounter );
										prvCustCode = custCode;	
										previousDay	= dt;
										
										if("B".equalsIgnoreCase(trfType))
										{
											tranFileMip.remove("dnldFileName");
										}
										tranFileMip.put( "dnldFileName", dnldFileNameServer );
										download(tranFileMip, downloadLoc);
										retString = "updateSeq";
									}
									
								}
								rsSeq.close();
								rsSeq = null;
								pstmtSeq.close();
								pstmtSeq = null;
							}
							else if(trfCycle != null && trfCycle.equalsIgnoreCase( "A" ))
							{							
								if(!("S".equalsIgnoreCase(trfType)))
								{
									download(tranFileMip, downloadLocEmail);
									retString = sendMail(emailHash, conn);
									deleteFile(filePath);
								}
								if(!("E".equalsIgnoreCase(trfType)))
								{
									if( custCode.equalsIgnoreCase( prvCustCode ) && dt.equalsIgnoreCase( previousDay  ) )
									{
										recCounter++;
									}
									else
									{
										// 11/09/09 DI89SUN223 manoharan to store the sequence number 
										// (file suffix) in invoice table and increment for the same day 
										//recCounter = 1;
										
										pstmtSeq2.setString(1,custCode);
										pstmtSeq2.setTimestamp(2,tranDate);
										rsSeq2 = pstmtSeq2.executeQuery();
										if( rsSeq2.next() )
										{
											recCounter = rsSeq2.getInt("download_file_seq");
											
											System.out.println(recCounter);
										}
										rsSeq2.close();
										rsSeq2 = null;
										
										recCounter++;
										
										// end 11/09/09 manoharan to store the sequence number (file suffix)
										// in invoice table and increment for the same day
									}
									
									System.out.println(recCounter);
									dnldFileNameServer = ( uniformCode == null ? "" : uniformCode.trim() )  
										+ "_" + dty + "_" 
										+ ( new java.text.DecimalFormat( "000" ) ).format( recCounter );
									prvCustCode = custCode;	
									previousDay	= dt;
									
									if("B".equalsIgnoreCase(trfType))
									{
										tranFileMip.remove("dnldFileName");
									}
									tranFileMip.put( "dnldFileName", dnldFileNameServer );
									download(tranFileMip, downloadLoc);
									retString = "updateSeq";
								}
							}
							//Changed by Sachin [update the Download_flag and INV_EXP_DATE after 
							//each invoice files downloading]
							
							if(retString!=null && !retString.equalsIgnoreCase("ERROR"))
							{
								sql = "UPDATE INVOICE SET "
								+" DOWNLOAD_FLAG = 'Y', INV_EXP_DATE = SYSDATE ";
															
								if(!("E".equalsIgnoreCase(trfType)))
								{
									sql += ", DOWNLOAD_FILE_SEQ = "+recCounter;
								}
								
								sql +=" WHERE INVOICE_ID = ? ";
								
								pstmtSeq = conn.prepareStatement(sql);
								
								pstmtSeq.setString( 1, tranId );
								
								int rowCnt = pstmtSeq.executeUpdate();
								
								System.out.println("Successfully updated =="+rowCnt);
								
								if(rowCnt >= 1)
								{
									conn.commit();
								}
								else
								{
									conn.rollback();
								}
								pstmtSeq.close();
								pstmtSeq = null;
							}
							
							pstmtSeq2.close();
							pstmtSeq2 = null;
						}
							//Changed by Sachin [update the Download_flag and INV_EXP_DATE after 
							//each invoice files downloading].end
							
						//end - select all the undownloaded invoice, if found, then download for each.

					}
				}
			}
			catch( Exception pte )
			{
				try{
					conn.rollback();
					conn.close();
					conn = null;
				}catch( Exception ex ){}
				pte.printStackTrace();
			}
			
		}
	}
	
	public void updateFlag(String tranId, Connection conn)throws RemoteException, ITMException
	{
		java.sql.PreparedStatement pstmtSeq2 = null;
		try
		{
			pstmtSeq2 = conn.prepareStatement( "UPDATE INVOICE SET "
			+" DOWNLOAD_FLAG = 'Y' WHERE INVOICE_ID = ? " );

			pstmtSeq2.setString( 1, tranId );
			int rowCnt = pstmtSeq2.executeUpdate();
			if(rowCnt >= 1){
				conn.commit();
			}
			else{
				conn.rollback();
			}
			pstmtSeq2.close();
			pstmtSeq2 = null;
		}
		catch (Exception e) 
		{
			System.out.println("Unable to updateFlag (" + e.getMessage() + ")");
		}
	}
	
	
	
	public void deleteFile( String filePath)throws RemoteException, ITMException
	{
		try 
		{
		  // Construct a File object for the file to be deleted.
		  File target = new File(filePath);

		  if (!target.exists()) {
			System.err.println("File " + filePath
				+ " not present to begin with!");
			return;
		  }

		  // delete tmp file:
		  if (target.delete())
			System.err.println("** Deleted " + filePath + " **");
		  else
			System.err.println("Failed to delete " + filePath);
		}
		catch (SecurityException e)
		{
		  System.err.println("Unable to delete " + filePath + "("
			  + e.getMessage() + ")");
		}
	}



	public void download( HashMap map, String downloadLoc)throws RemoteException, ITMException
	{
		java.sql.Connection conn = null;
		java.sql.PreparedStatement pstmt = null;
		java.sql.ResultSet rs = null;
		String tranId = null;
		String dnldFileName = null;
		String xmlToCsvStr = null;
		String templDnld = null;
		String csvData = null;
		TranXmlData client = null;

		
		ibase.webitm.utility.XML2CSVCustomConverter csvConverter = null;
		csvConverter = new ibase.webitm.utility.XML2CSVCustomConverter();	
		ConnDriver connDriver = new ConnDriver();
		client = new TranXmlData();
		if( map.size() > 0 )
		{
			try
			{
				conn = connDriver.getConnectDB( "DriverITM" );
				conn.setAutoCommit( false );
				connDriver = null;
				
				tranId = ( String )map.get( "tranId" );
				dnldFileName = ( String )map.get( "dnldFileName" );
				templDnld = ( String )map.get( "templDnld" );
								
				xmlToCsvStr = client.getTranXml( "invoice",
									java.sql.Timestamp.valueOf( "2008-11-01 00:00:00" ),
									java.sql.Timestamp.valueOf( "2008-11-01 00:00:00" ),
									tranId, tranId, conn );
				
				csvData = csvConverter.convert( xmlToCsvStr,  
										CommonConstants.JBOSSHOME + File.separator + "download" 
										+ File.separator + "template" 
										+ File.separator + templDnld + ".xml", null);
				FileWriter fw = new FileWriter( downloadLoc + File.separator + dnldFileName + ".csv" );

				fw.write( csvData );
				fw.close();
				fw = null;
				conn.close();
				conn = null;
				
				System.out.println("Inside download ");
			}
			catch( Exception ex )
			{
				//ignore this exception as if one file throws exception next file should download.
			}
			
		}
	}
	
	public String sendMail(HashMap hMap, Connection conn)throws Exception
	{
		
		String retString = "";
		String to = "";
		String from = "";
		String cc = "";
		boolean debug = false;
		String subject = "",text = "";
		String xmlDataFilePath = "";
		java.sql.PreparedStatement pstmtSeq = null;
		java.sql.ResultSet rsSeq = null; 
		try 
		{
			Properties props = System.getProperties();
			props.put("mail.smtp.host", CommonConstants.SMTPHOST);		  
			Authenticator auth = null;
			 
			Session session= Session.getDefaultInstance(props,auth);
			session.setDebug(debug);
			MimeMessage msg = new MimeMessage(session);
			MimeBodyPart mbp1 = new MimeBodyPart();
			MimeBodyPart mbp2 = new MimeBodyPart();
			Multipart mp = new MimeMultipart();
						
			from = CommonConstants.MAILFROM;
			to = (String)hMap.get("TO_ADDR");
			
			subject = (String)hMap.get("SUBJECT");
			text = (String)hMap.get("TEXT");
			xmlDataFilePath = (String)hMap.get("FILEPATH");
			
			InternetAddress[] address = {new InternetAddress(to)};
			
			mbp1.setText(text);				
			mp.addBodyPart(mbp1);
			
			// 30/03/10 Sachin---this part is added to send file as attachment.
				
			if( xmlDataFilePath != null )
			{
				File createdFileObj = null;
				createdFileObj = new File(xmlDataFilePath);
				mbp2 = new MimeBodyPart();
				DataSource source = new FileDataSource(createdFileObj);
				mbp2.setDataHandler(new DataHandler(source));
				mbp2.setFileName((createdFileObj.toString()).substring((createdFileObj.toString()).lastIndexOf("\\")+1, createdFileObj.toString().length()));
			}
			// 30/03/10 Sachin---end of part send file as attachment.

			mp.addBodyPart(mbp2);
			
			msg.setRecipients(Message.RecipientType.TO, address);
			
			// 28/04/10 Sachin---Start to check CC address is present
			
			pstmtSeq = conn.prepareStatement( "SELECT VAR_VALUE FROM DISPARM "
			+" WHERE PRD_CODE='999999' AND VAR_NAME = 'INV_MAIL_CC' " );

			rsSeq = pstmtSeq.executeQuery();
			if( rsSeq.next() )
			{
				cc = rsSeq.getString( "VAR_VALUE" );
				System.out.println("cc =="+ cc);
			}
			rsSeq.close();
			rsSeq = null;
			pstmtSeq.close();
			pstmtSeq = null;
			
			if(cc != null && cc.trim().length() > 0){
				InternetAddress[] ccAddress = {new InternetAddress(cc)};
				msg.setRecipients(Message.RecipientType.CC, ccAddress);
			}
			
			// 28/04/10 Sachin---End to check CC address is present
			
			msg.setSubject(subject);						
			msg.setFrom(new InternetAddress(from));	
			msg.setContent(mp);
			msg.setSentDate(new java.util.Date());
	
			if(msg.getRecipients(Message.RecipientType.TO) != null )
			{
				System.out.println("sending mail ...........");
				Transport.send(msg);
			}
		}
		catch (MessagingException mex) 
		{
			retString = "ERROR";
			System.out.println("SendEMail:MessagingException:\n");
			mex.printStackTrace();
		} 
		catch (Exception e) 
		{
			retString = "ERROR";
			System.out.println("SendEMail:MessagingException:\n");
			e.printStackTrace();
		}
		return retString;	
	}
	
	public String schedule( HashMap map )throws RemoteException, ITMException
	{
		return "";
	}
	public String schedule( String scheduleParamXML )throws RemoteException, ITMException
	{
		String userInfoList = null;
		String isIntractive = null;
		String objName = null;
		String downloadLoc = null;
		
		ArrayList paramListArr = new ArrayList();

		try
		{
			//APPLICATION_CONTEXT = CommonConstants.UPLOAD_LOC + File.separator 
			//+ "webapps" + File.separator + "ibase" + File.separator ;						
			//System.out.println(" scheduleParamXML  [" + scheduleParamXML + "]");
			
			Document userInfoDom = new ibase.utility.GenericUtility().parseString( scheduleParamXML );			
			NodeList paramList = userInfoDom.getElementsByTagName( "ACTUALPARAMETER" );
			//
			int noOfParam = paramList.getLength();
			for( int paramCnt = 0; paramCnt < noOfParam ; paramCnt++ )
			{
				paramListArr.add( ( String )( paramList.item( paramCnt ).getFirstChild().getNodeValue() ) );
			}
			
			//for( int i = 0 ; i < paramListArr.size(); i++ )
			//{
			//	System.out.println( "My param :: " + (String)paramListArr.get( i ) ); 
			//}
			//
			
			/*
			System.out.println(" RootNode [ " + rootNode+ " ] ");
			NodeList propNodeList = rootNode.getChildNodes();			
			System.out.println(" propNodeList [ " + propNodeList+ " ] ");
			int noOfProps = propNodeList.getLength();			
			for( int propCtr = 0; propCtr < noOfProps; propCtr++ )
			{				
				Node propNode = propNodeList.item( propCtr );
				System.out.println(" propNode [" +propNode+"]");
				if( propNode != null && propNode.getFirstChild() != null )
				{
					String propName = propNode.getNodeName();
					System.out.println(" propName [" +propName+"]");
					if ( "UserInfoStr".equalsIgnoreCase( propName ) )
					{
						userInfoList = propNode.getFirstChild().getNodeValue();
						System.out.println(" userInfoList [" + userInfoList + "]");
					}
				    else if ( "downloadLoc".equalsIgnoreCase( propName ) )
					{
						downloadLoc = propNode.getFirstChild().getNodeValue();
						System.out.println(" isIntractive [" + isIntractive + "]");
					}					
					else if ( "objName".equalsIgnoreCase( propName ) )
					{
						objName = propNode.getFirstChild().getNodeValue();
						System.out.println(" objName [" + objName + "]");
					}
					else if ( "entityCode".equalsIgnoreCase( propName ) )
					{
						entityCode = propNode.getFirstChild().getNodeValue();
						System.out.println(" entityCode [" + entityCode + "]");
					}
					else if ( "entityType".equalsIgnoreCase( propName ) )
					{
						entityType = propNode.getFirstChild().getNodeValue();
						System.out.println(" entityType [" + entityType + "]");
					}
				}
			}
			*/
			//downloadTransaction( objName, downloadLoc, entityCode, entityType, null );
			/*
			List and order of arguments :
			1. location,
			2. Entity Code
			3. Entity Type 
			4. Stite Code
			5. Cust code
			*/
			downloadTransaction( (String)paramListArr.get( 0 ), (String)paramListArr.get( 1 ),
			(String)paramListArr.get( 2 ), (String)paramListArr.get( 3 ),
			(String)paramListArr.get( 4 ), (String)paramListArr.get( 5 ) );
		}
		catch(Exception e)
		{
			//System.out.println("DownloadCSVBatchEJB :==>Schedule");
			e.printStackTrace();
		}
		
		return "";
	}	
}