/*
 * Copyright 2007 Robert Hanson <iamroberthanson AT gmail.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.gwtwidgets.client.ui.canvas;

/**
 * <p>
 * Font for use with Canvas. Fonts are derived from {@link Canvas#createBitmapFont(String, String, FontLoadListener)}.
 * 
 * A typical lifecycle
 * looks like this:
 * </p>
 * <p>
 * 
 * <pre>
 * Font font = Canvas.createBitmapFont(&quot;fonts/bitmap.png&quot;, &quot;fonts/descriptor.txt&quot;, listener);
 * ...
 * canvas.setFont(font);
 * ...
 * canvas.drawText("some text", x, y);
 * </pre>
 * </p>
 * <p>
 * Note that all current <code>Font</code> implementations rely on bitmaps and are expensive to create in
 * terms of memory and CPU.
 * </p>
 * @author g.georgovassilis
 *
 */
public abstract class Font {

	public abstract void drawText(String text, Canvas canvas, double x, double y);

}
