package ibase.webitm.util.gst;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;

import ibase.webitm.bean.gst.Invoice;
import ibase.webitm.bean.gst.Nil;

public class NilSerializer extends BaseSerializer<Nil>
{
	@Override
	public void serialize(Nil nil, JsonGenerator json, SerializerProvider serializerProvider)throws IOException, JsonProcessingException 
	{
		json.writeStartObject();
		
		if(nil.taxPayerAction != null && "D".equalsIgnoreCase(nil.taxPayerAction))
		{
			json.writeStringField("flag", nil.taxPayerAction);
		}
		else
		{
			json.writeFieldName("inv");
	        json.writeStartArray();

	        for(Invoice inv : nil.invoices)
	        {
	        	writeInvoice(inv, json);
	        }
	        
	        json.writeEndArray();
		}
		
        json.writeEndObject();
	}
	
	private void writeInvoice(Invoice inv, JsonGenerator json)
	{
		try
		{
			json.writeStartObject();
			
			json.writeStringField("sply_ty", inv.supplyType);
			json.writeNumberField("nil_amt", inv.totalNilAmount);
			json.writeNumberField("expt_amt", inv.totalExemptedAmount);
			json.writeNumberField("ngsup_amt", inv.totalNonGSTAmout);
			
			json.writeEndObject();
		}
		catch(Exception e)
		{
			System.out.println("NilSerializer.writeInvoice()["+e.getMessage()+"]");
			e.printStackTrace();
		}
	}
}
