create or replace
TRIGGER INS_INTERFACE_2
after insert or delete or update on siteitem referencing new as new old as old
for each row
DECLARE
  isupdated boolean := false;
  refser char(6);
  itemcode char(10);
  dissite char(120);
  icode char(10);
  idescr varchar2(120);
  iunit char(3);
  itype char(10);
  loczone number(16,0);
  qctype char(1);
  sianalclass char(1);
  tran_id char(10);
  PRAGMA AUTONOMOUS_TRANSACTION;
BEGIN
  if INSERTING then
    select var_value into dissite from disparm where var_name = 'SITE_CODE_DADRA2';
      if dissite is not null then
	  select item_code into itemcode from item where item_code = :new.item_code;
        if itemcode is not null then
		  select ref_ser into refser from transetup where tran_window = 'w_interface2';
          select lpad(to_number(seq_no)+1,10,'0') into tran_id from refseq where ref_ser=refser and trim(ref_prefix) is null;
		  insert into host_to_wms(tran_id, ref_id, item_code, descr, unit, item_type, family_grp, in_out, tran_date, msg_stat, qc_type, stro_pref)
          select tran_id, tran_id, siteitem.item_code, item.descr, item.unit, siteitem.item_ser__rg1 , siteitem.analysis_class, 'M' , sysdate, 'N',
          siteitem.qc_sample_type, siteitem.loc_zone__pref from siteitem siteitem, item item where siteitem.item_code = item.item_code and
          item.item_code = itemcode and instr(ddf_get_disparm_value('SITE_CODE_DADRA2', '999999'), siteitem.site_code) > 0 and rownum = 1 order by siteitem.chg_date desc;
		  update refseq set seq_no = tran_id where ref_ser=refser and trim(ref_prefix) is null;
		  select ref_ser into refser from transetup where tran_window = 'w_interface2';
          select lpad(to_number(seq_no)+1,10,'0') into tran_id from refseq where ref_ser=refser and trim(ref_prefix) is null;
		  insert into swms_to_awms(tran_id, ref_id, item_code, descr, unit, item_type, family_grp, in_out, tran_date, msg_stat, qc_type, stro_pref)
          select tran_id, tran_id, siteitem.item_code, item.descr, item.unit, siteitem.item_ser__rg1 , siteitem.analysis_class, 'M' , sysdate, 'N',
          siteitem.qc_sample_type, siteitem.loc_zone__pref from siteitem siteitem, item item where siteitem.item_code = item.item_code and
          item.item_code = itemcode and instr(ddf_get_disparm_value('SITE_CODE_DADRA2', '999999'), siteitem.site_code) > 0 and rownum = 1 order by siteitem.chg_date desc;
		  update refseq set seq_no = tran_id where ref_ser=refser and trim(ref_prefix) is null;
          commit;
        end if;
      end if;
  ELSIF UPDATING then
    if updating ('ITEM_CODE') then
      isupdated := true;
      icode := :new.ITEM_CODE;
    else
      icode := :old.ITEM_CODE;
    end if;
	if updating ('LOC_ZONE__PREF') then
      isupdated := true;
      loczone := :new.LOC_ZONE__PREF;
    else
      loczone := :old.LOC_ZONE__PREF;
    end if;
	if updating ('ANALYSIS_CLASS') then
      isupdated := true;
      sianalclass := :new.ANALYSIS_CLASS;
    else
      sianalclass := :old.ANALYSIS_CLASS;
    end if;
	if updating ('QC_SAMPLE_TYPE') then
      isupdated := true;
      qctype := :new.QC_SAMPLE_TYPE;
    else
      qctype := :old.QC_SAMPLE_TYPE;
    end if;
	if updating ('ITEM_SER__RG1') then
      isupdated := true;
      itype := :new.ITEM_SER__RG1;
    else
      itype := :old.ITEM_SER__RG1;
    end if;
    if isupdated then
      select var_value into dissite from disparm where var_name = 'SITE_CODE_DADRA2';
      if dissite is not null then
        select item_code, descr into itemcode, idescr from item where item_code = :new.item_code;
        if itemcode is not null then
          select ref_ser into refser from transetup where tran_window = 'w_interface2';
          select lpad(to_number(seq_no)+1,10,'0') into tran_id from refseq where ref_ser=refser and trim(ref_prefix) is null;
		  insert into host_to_wms(tran_id, ref_id, item_code, descr, unit, item_type, family_grp, in_out, tran_date, msg_stat, qc_type, stro_pref)
          select tran_id, tran_id, item.item_code, item.descr, item.unit, itype, sianalclass, 'M' , sysdate, 'N',
          qctype, loczone from siteitem siteitem, item item where item.item_code = itemcode
		  and instr(ddf_get_disparm_value('SITE_CODE_DADRA2', '999999'), siteitem.site_code) > 0 and rownum = 1 order by siteitem.chg_date desc;
		  update refseq set seq_no = tran_id where ref_ser=refser and trim(ref_prefix) is null;
          select ref_ser into refser from transetup where tran_window = 'w_interface2';
          select lpad(to_number(seq_no)+1,10,'0') into tran_id from refseq where ref_ser=refser and trim(ref_prefix) is null;
		  insert into swms_to_awms(tran_id, ref_id, item_code, descr, unit, item_type, family_grp, in_out, tran_date, msg_stat, qc_type, stro_pref)
          select tran_id, tran_id, item.item_code, item.descr, item.unit, itype , sianalclass, 'M' , sysdate, 'N',
          qctype, loczone from siteitem siteitem, item item where siteitem.item_code = item.item_code and
          item.item_code = itemcode and instr(ddf_get_disparm_value('SITE_CODE_DADRA2', '999999'), siteitem.site_code) > 0 and rownum = 1 order by siteitem.chg_date desc;
		  update refseq set seq_no = tran_id where ref_ser=refser and trim(ref_prefix) is null;
		  commit;
        end if;
      end if;
     end if;
  end if;
end;