/**
 * @author : Wasim Ansari
 * Date : 05-JUN-2015
 * Migration: W16IBAS005
 */
package ibase.webitm.ejb.fin.adv;


import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.E12CreateBatchLoadEjb;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.ejb.fin.InvAcct;
import ibase.webitm.ejb.sys.CreateRCPXML;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.text.*;
import javax.ejb.Stateless;
import org.w3c.dom.Document;



@Stateless
public class DrCrRcpConf extends ActionHandlerEJB implements DrCrInvConfLocal,DrCrInvConfRemote 
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	FinCommon finCommon = null;
	DistCommon distCommon = new DistCommon();
	ITMDBAccessEJB itmDBAccessEJB = null;
	InvAcct invacct = new InvAcct();
	String gs_run_mode = "";
	
	public String confirm(String tranID,String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{
		String retString = "";
		Connection conn = null;

		try
		{
			retString = confirm( tranID, xtraParams, forcedFlag, conn );

			/*if ( retString != null && retString.length() > 0 )
			{
				throw new Exception("Exception while calling DrCrRcpConf confirm for tran  Id:["+tranID+"]");
			}*/
		}
		catch(Exception exception)
		{
			retString = "ERROR";
			System.out.println("Exception in [DrCrRcpConf] " + exception.getMessage());
		}
		return retString;
	}

	public String confirm(String tranId, String xtraParams, String forcedFlag, Connection conn) throws RemoteException,ITMException
	{
		System.out.println("DrCrRcpConf Confirm called........");
		String sql = "";
		String confirm = "";
		String siteCode = "";
		String errString = "" ;
		String loginEmpCode = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		boolean connStatus=false;
		String chgUser="";
		java.sql.Timestamp today = null;

		try
		{
			if (conn == null)
			{
				conn = getConnection();
				connStatus = true;
			}
			finCommon = new FinCommon();
			itmDBAccessEJB = new ITMDBAccessEJB();
			
			loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
			gs_run_mode  = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "runMode");
			
			sql = " select confirmed,site_code,chg_user from drcr_rcp where tran_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				confirm = rs.getString("confirmed") == null ?"N":rs.getString("confirmed");
				siteCode = rs.getString("site_code") == null ?" ":rs.getString("site_code");
				chgUser = rs.getString("chg_user") == null ?" ":rs.getString("chg_user");
			}
			if(rs != null)
			{
				rs.close();rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();pstmt = null;
			}
			
			if(chgUser==null || chgUser.trim().length()==0)
			{
				chgUser="SYSTEM";
			}
			if("null".equalsIgnoreCase(loginEmpCode) || loginEmpCode==null || loginEmpCode.trim().length()==0)
			{
				sql=" select emp_code from users where code=? ";
				pstmt=conn.prepareStatement(sql);
				pstmt.setString(1,chgUser);
				
				rs=pstmt.executeQuery();
				if(rs.next())
				{
					loginEmpCode=rs.getString(1);
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
			}
			
			if(confirm != null  && "N".equalsIgnoreCase(confirm))
			{
				errString = retrieveDrCrRcp (tranId,siteCode,xtraParams,conn);
				
				System.out.println("Return String from retrieveDrCrRcp ["+errString+"]");
				
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
				
				if(errString == null || errString.trim().length() == 0)
				{
					if("null".equalsIgnoreCase(loginEmpCode) || loginEmpCode==null || loginEmpCode.trim().length()==0)
					{
						loginEmpCode="E03952";
					}
					
					today = new java.sql.Timestamp(System.currentTimeMillis()) ;
					
					sql = " update drcr_rcp set confirmed = 'Y', conf_date = ?, emp_code__aprv = ? where tran_id = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setTimestamp(1, today);
					pstmt.setString(2, loginEmpCode);
					pstmt.setString(3, tranId);
					int updateCoount = pstmt.executeUpdate();
					System.out.println("Rows Updated= "+updateCoount);
					if(pstmt != null)
					{
						pstmt.close();pstmt = null;
					}
					if(updateCoount > 0)
					{
						errString = itmDBAccessEJB.getErrorString("","VTCICONF3","","",conn);
					}
				}
				else 
				{
					if(errString.indexOf("<?xml version") == -1)
					{
						errString = itmDBAccessEJB.getErrorString("",errString,"","",conn);
					}
					return errString;
				}
			}
			else
			{
				System.out.println("The Selected transaction is already confirmed and can not be edited");
				
				errString = itmDBAccessEJB.getErrorString("","VTMCONF1","","",conn);
				return errString;
			}
			
			System.out.println("Error String from confirm method.....[" + errString + "]");
		} 
		catch( Exception e)
		{
			System.out.println("Exception inside DrCrRcpConf Confirm==>"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("Inside finally connStatus ["+connStatus+"]");
				
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
				if( conn != null && !conn.isClosed() && connStatus ) 
				{
					if(errString.indexOf("VTCICONF3") > -1)
					{
						System.out.println("Inside comitting.....");
						conn.commit();
					}
					else
					{
						System.out.println("Inside rollbacking.....");
						conn.rollback();
					}
					if(conn!=null)
					{	
						conn.close();conn = null;
					}	
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception : "+e);
				e.printStackTrace();
			}
		}
		return errString;
	}
	
	/**
	 * Migration gbf_retrieve_drcr_rcp--->retrieveDrCrRcp
	 */
	private String retrieveDrCrRcp(String tranId,String siteCode,String xtraParams,Connection conn) throws RemoteException,ITMException
	{
		String sql = "",sql1 = "";
		PreparedStatement pstmt = null, pstmt1 = null;
		ResultSet rs = null, rs1 = null;
		java.sql.Timestamp tranDate = null, today;

		ArrayList<String> tranIDList = new ArrayList<String>();
		ArrayList<Map> detailList = new ArrayList<Map>();
		ArrayList<Map> adjList = new ArrayList<Map>();
		
		Map hdrMap = new HashMap();
		Map detMap = new HashMap();
		Map adjMap = new HashMap();
		
		int hdrCount = 0, dtlCount = 0,countRec = 0,taxRows = 0,adjCount = 0,countRcv = 0,updRowCnt = 0;
		double recoAmt = 0,amount = 0,amountTotal = 0,drcrAmount = 0,total = 0,amountHdr = 0,exchRate = 0,
				amountHdr1 = 0, roundTo = 0,adjAmount = 0,recoAmount = 0,diffExchAmt = 0,roundAdj = 0,amountDet = 0,totalAmountRec = 0,adjAmountRec = 0;
		
		String invoiceIDHdr = "", tranIDDrcrRcp = "",tranSer = "",winName = "",ledgPostConf = "",errCode = "",acctCode = "",cctrCode= "",
		posType = "",itemSer = "",acctCodeSal = "",cctrCodeSal = "",cctrCodeAr = "",acctReco = "",cctrReco = "",acctRnd = "",cctrRnd = "",
		tranType = "",invType = "",lineNo = "",taxAmt = "",itemCode = "",lsStr = "",custCode = "",refNo = "",refSer = "",roundOff = "";
		
		try
		{
			System.out.println("Inside gbfRetrieveDrCrRcp.....tranId["+tranId+"] siteCode["+siteCode+"]");
			
			today = new java.sql.Timestamp(System.currentTimeMillis()) ;
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
			tranDate = java.sql.Timestamp.valueOf(sdf.format(today) + " 00:00:00.000");
			
			sql = " select tran_id from drcr_rcp where tran_id 	>= ? and tran_id <= ? and "
				 +" site_code =  ? and confirmed = 'N' order by tran_id asc ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			pstmt.setString(2,tranId);
			pstmt.setString(3,siteCode);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				tranIDDrcrRcp = rs.getString("tran_id");
				tranIDList.add(tranIDDrcrRcp);
			}
			if(rs != null)
			{
				rs.close();rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();pstmt = null;
			}
			
			for(int i = 0; i<tranIDList.size(); i++)
			{
				tranIDDrcrRcp = tranIDList.get(i);
				
				System.out.println("TranID is--->["+tranIDDrcrRcp+"]");
				
				if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
				{
					sql = "SELECT tran_id FROM drcr_rcp  WHERE tran_id = ? for update ";
				}

				else if ( "mssql".equalsIgnoreCase(CommonConstants.DB_NAME ))
				{
					sql = "SELECT tran_id FROM drcr_rcp (updlock) WHERE tran_id = ? " ;
				}
				else
				{
					sql =" SELECT tran_id  FROM drcr_rcp WHERE tran_id =  ? for update nowait" ;
				}
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranIDDrcrRcp);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					tranIDDrcrRcp = rs.getString("tran_id") == null ? " ":rs.getString("tran_id");
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
				
				hdrCount = 0;
				sql = " select tran_id,tran_date,fin_entity,cust_code,acct_code,cctr_code,eff_date,invoice_id,amount,curr_code,exch_rate,remarks,"
					+ " site_code,anal_code,drcr_flag,tran_id__rcv,confirmed,conf_date,emp_code__aprv,tran_type,tran_ser,due_date,cr_term,chg_date,"
					+ " chg_user,chg_term,add_date,add_user,add_term,amount__bc,item_ser,round_adj,sreturn_no,adj_recv,gp_ser,gp_no,gp_date,"
					+ " parent__tran_id,rev__tran,cust_ref_no,cust_ref_date,cust_ref_amt,rnd_off,rnd_to,sundry_type,sundry_code,site_code__drcr,"
					+ " drcr_type,ord_billback_amt,ord_offinv_amt,line_billback_amt,line_offinv_amt,edi_stat "
					+ " from drcr_rcp where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranIDDrcrRcp);
				rs = pstmt.executeQuery();
				if(rs.next())
				{ 
					hdrCount++;
					hdrMap.put("tran_id", rs.getString("tran_id"));
					hdrMap.put("tran_date", rs.getTimestamp("tran_date"));
					hdrMap.put("fin_entity", rs.getString("fin_entity"));
					hdrMap.put("cust_code", rs.getString("cust_code"));
					hdrMap.put("acct_code", rs.getString("acct_code"));
					hdrMap.put("cctr_code", rs.getString("cctr_code"));
					hdrMap.put("eff_date", rs.getTimestamp("eff_date"));
					hdrMap.put("invoice_id", rs.getString("invoice_id"));
					hdrMap.put("amount", rs.getDouble("amount"));
					hdrMap.put("curr_code", rs.getString("curr_code"));
					hdrMap.put("exch_rate", rs.getDouble("exch_rate"));
					hdrMap.put("remarks", rs.getString("remarks"));
					hdrMap.put("site_code", rs.getString("site_code"));
					hdrMap.put("anal_code", rs.getString("anal_code"));
					hdrMap.put("drcr_flag", rs.getString("drcr_flag"));
					hdrMap.put("tran_id__rcv", rs.getString("tran_id__rcv"));
					hdrMap.put("confirmed", rs.getString("confirmed"));
					hdrMap.put("conf_date", rs.getString("conf_date"));
					hdrMap.put("emp_code__aprv", rs.getString("emp_code__aprv"));
					hdrMap.put("tran_type", rs.getString("tran_type"));
					hdrMap.put("tran_ser", rs.getString("tran_ser"));
					hdrMap.put("due_date", rs.getTimestamp("due_date"));
					hdrMap.put("cr_term", rs.getString("cr_term"));
					hdrMap.put("chg_date", rs.getTimestamp("chg_date"));
					hdrMap.put("chg_term", rs.getString("chg_term"));
					hdrMap.put("add_date", rs.getTimestamp("add_date"));
					hdrMap.put("add_user", rs.getString("add_user"));
					hdrMap.put("add_user", rs.getString("add_user"));
					hdrMap.put("amount__bc", rs.getString("amount__bc"));
					hdrMap.put("item_ser", rs.getString("item_ser"));
					hdrMap.put("round_adj", rs.getDouble("round_adj"));
					hdrMap.put("sreturn_no", rs.getString("sreturn_no"));
					hdrMap.put("adj_recv", rs.getString("adj_recv"));
					hdrMap.put("gp_ser", rs.getString("gp_ser"));
					hdrMap.put("gp_no", rs.getString("gp_no"));
					hdrMap.put("gp_date", rs.getTimestamp("gp_date"));
					hdrMap.put("parent__tran_id", rs.getString("parent__tran_id"));
					hdrMap.put("rev__tran", rs.getString("rev__tran"));
					hdrMap.put("cust_ref_no", rs.getString("cust_ref_no"));
					hdrMap.put("cust_ref_date", rs.getTimestamp("cust_ref_date"));
					hdrMap.put("cust_ref_amt", rs.getDouble("cust_ref_amt"));
					hdrMap.put("rnd_off", rs.getString("rnd_off"));
					hdrMap.put("rnd_to", rs.getDouble("rnd_to"));
					hdrMap.put("sundry_type", rs.getString("sundry_type"));
					hdrMap.put("sundry_code", rs.getString("sundry_code"));
					hdrMap.put("site_code__drcr", rs.getString("site_code__drcr"));
					hdrMap.put("drcr_type", rs.getString("drcr_type"));
					hdrMap.put("ord_billback_amt",  rs.getDouble("ord_billback_amt"));
					hdrMap.put("ord_offinv_amt", rs.getDouble("ord_offinv_amt"));
					hdrMap.put("line_billback_amt", rs.getDouble("line_billback_amt"));
					hdrMap.put("line_offinv_amt", rs.getDouble("line_offinv_amt"));
					hdrMap.put("edi_stat", rs.getString("edi_stat"));
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
				
				/*sql = " select tran_id,line_no,invoice_id,line_no__inv,item_code,sales_pers,tax_class,tax_chap,tax_env,drcr_amt,tax_amt,net_amt, "
					+ " reas_code,cost_rate,rate__std,quantity,rate,rate__clg,discount,line_no__sret,line_no__invtrace,lot_no,lot_sl,tran_id__rcp, "
					+ " billback_amt,offinv_amt "
					+ " from drcr_rdet where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranIDDrcrRcp);
				rs = pstmt.executeQuery();
				while(rs.next())
				{ 
					detMap = new HashMap();
					detMap.put("tran_id", rs.getString("tran_id"));
					detMap.put("line_no", rs.getString("line_no"));
					detMap.put("invoice_id", rs.getString("invoice_id"));
					detMap.put("line_no__inv", rs.getString("line_no__inv"));
					detMap.put("item_code", rs.getString("item_code"));
					detMap.put("sales_pers", rs.getString("sales_pers"));
					detMap.put("tax_class", rs.getString("tax_class"));
					detMap.put("tax_chap", rs.getString("tax_chap"));
					detMap.put("tax_env", rs.getString("tax_env"));
					detMap.put("drcr_amt", rs.getDouble("drcr_amt"));
					detMap.put("tax_amt", rs.getDouble("tax_amt"));
					detMap.put("net_amt", rs.getDouble("net_amt"));
					detMap.put("reas_code", rs.getString("reas_code"));
					detMap.put("cost_rate", rs.getDouble("cost_rate"));
					detMap.put("rate__std", rs.getDouble("rate__std"));
					detMap.put("quantity", rs.getDouble("quantity"));
					detMap.put("rate", rs.getDouble("rate"));
					detMap.put("rate__clg", rs.getDouble("rate__clg"));
					detMap.put("discount", rs.getDouble("discount"));
					detMap.put("line_no__sret", rs.getString("line_no__sret"));
					detMap.put("line_no__invtrace", rs.getString("line_no__invtrace"));
					detMap.put("lot_no", rs.getString("lot_no"));
					detMap.put("lot_sl", rs.getString("lot_sl"));
					detMap.put("tran_id__rcp", rs.getString("tran_id__rcp"));
					detMap.put("billback_amt", rs.getDouble("billback_amt"));
					detMap.put("offinv_amt", rs.getDouble("offinv_amt"));
					detMap.put("amount", 0.0);
					
					detailList.add(detMap);
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}*/
				
				tranSer = (String) hdrMap.get("tran_ser");
				tranId = (String) hdrMap.get("tran_id");
				//tranDate = Timestamp.valueOf(genericUtility.getValidDateString(hdrMap.get("tran_date"), genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()));
				tranDate = (Timestamp) hdrMap.get("tran_date");
				tranDate = java.sql.Timestamp.valueOf(sdf.format(tranDate) + " 00:00:00.000");
				
				if(hdrCount > 0)
				{
					invoiceIDHdr = (String) hdrMap.get("invoice_id");
					
					sql = " select posttype, item_ser,acct_code__sal, cctr_code__sal, cctr_code__ar from invoice where invoice_id = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,invoiceIDHdr);
					rs = pstmt.executeQuery();
					if(rs.next())
					{ 
						posType = rs.getString("posttype");
						itemSer = rs.getString("item_ser");
						acctCodeSal = rs.getString("acct_code__sal");
						cctrCodeSal = rs.getString("cctr_code__sal");
						cctrCodeAr = rs.getString("cctr_code__ar");
					}
					if(rs != null)
					{
						rs.close();rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();pstmt = null;
					}
					
					System.out.println("acctCodeSal["+acctCodeSal+"]--cctrCodeSal["+cctrCodeSal+"]--cctrCodeAr["+cctrCodeAr+"]");
					
					if(cctrCodeSal == null || cctrCodeSal.length() == 0)
					{
						cctrCodeSal = cctrCodeAr;
					}
					if(posType == null || posType.length() == 0)
					{
						posType = "H";
					}
					
					siteCode = (String) hdrMap.get("site_code");
				}
				
				System.out.println("PosType["+posType+"]");
				
				if("CRNRCP".equalsIgnoreCase(tranSer.trim()))
				{
					winName = "W_DRCRRCP_CR";
				}
				else if("DRNRCP".equalsIgnoreCase(tranSer.trim()))
				{
					winName = "W_DRCRRCP_CR";
				}
				
				sql = "select ledg_post_conf from transetup where upper(tran_window) = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,winName);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					ledgPostConf = rs.getString(1);
				}
				else
				{
					errCode = "VTSEQ";
					return errCode;
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
				
				if("Y".equalsIgnoreCase(ledgPostConf))
				{
					sql = " update drcr_rcp set tran_date = ? where tran_id = ?" ;
					pstmt = conn.prepareStatement(sql);
					pstmt.setTimestamp(1, tranDate);
					pstmt.setString(2,tranId);
					pstmt.executeUpdate();		
					
					if(pstmt != null)
					{
						pstmt.close();pstmt = null;
					}
					
					hdrMap.put("tran_date", tranDate);
				}
				
				System.out.println("DetailCount-->"+dtlCount);
				if(dtlCount == 0)
				{
					//do
					//{
							invoiceIDHdr = (String) hdrMap.get("invoice_id");
							
							countRec = 0;
							sql = " select tran_type from sreturn where tran_id__crn = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,tranIDDrcrRcp);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								tranType = checkNullAndTrim(rs.getString("tran_type"));
								countRec++;
							}
							if(rs != null)
							{
								rs.close();rs = null;
							}
							if(pstmt != null)
							{
								pstmt.close();pstmt = null;
							}
							
							if(countRec > 0)
							{	
								sql = " select inv_type from invoice where invoice_id = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,invoiceIDHdr);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									invType = checkNullAndTrim(rs.getString("inv_type"));
								}
								if(rs != null)
								{
									rs.close();rs = null;
								}
								if(pstmt != null)
								{
									pstmt.close();pstmt = null;
								}
							}
						
							sql = " select acct_code, cctr_code, sum(tax_amt), line_no, (case when sum(reco_amount) is null then 0 else sum(reco_amount) end) as reco_amount " 
								 +" from taxtran where tran_code = ? and tran_id = ? "
								 +" and tax_amt <> 0 and effect <> 'N' group by acct_code, cctr_code, line_no ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,tranSer);
							pstmt.setString(2,tranId);
							rs = pstmt.executeQuery();
							while(rs.next())
							{
								acctCode = rs.getString("acct_code");
								cctrCode = rs.getString("cctr_code");
								taxAmt = rs.getString("tax_amt");
								lineNo = rs.getString("line_no");
								recoAmt = rs.getDouble("reco_amount");
								
								System.out.println("@@acctCode ["+acctCode+"]");
								
								if(acctCode == null || acctCode.trim().length() == 0)
								{
									if("H".equalsIgnoreCase(posType))
									{
										//Need to verify below codew
										cctrCode = finCommon.getAcctDetrTtype(" ", itemSer, "SRET" , tranType, conn);
										//ls_acctcode = f_get_token(ls_cctrcode,'~t');
										
										if (cctrCode != null && cctrCode.trim().length() > 0) 
										{
											String tokens [] = cctrCode.split(",");
						
											if ( tokens.length >= 2)
											{
												acctCode = tokens[0];
												cctrCode = tokens[1];
											}
											else
											{
												acctCode = cctrCode.substring(0,cctrCode.indexOf(","));
												cctrCode = cctrCode.substring(cctrCode.indexOf(",") + 1);
											}
										}
									}
									else if("D".equalsIgnoreCase(posType))
									{
										lineNo = lineNo.trim();
										
										sql = " select inv.item_code,i.item_ser from invoice_trace inv,item i "
											 +" where inv.invoice_id = ? and line_no = ? " 
											 +" and inv.item_code = i.item_code " ;
										pstmt1 = conn.prepareStatement(sql);
										pstmt1.setString(1,invoiceIDHdr);
										pstmt1.setString(2,lineNo);
										rs1 = pstmt1.executeQuery();
										if(rs1.next())
										{
											itemCode = rs.getString("item_code");
											itemSer = rs.getString("item_ser");
										}
										if(rs1 != null)
										{
											rs1.close();rs1 = null;
										}
										if(pstmt1 != null)
										{
											pstmt1.close();pstmt1 = null;
										}
										
										//Need to verify below code
										cctrCode = finCommon.getAcctDetrTtype(itemCode, itemSer, "SRET", tranType, conn);
										//ls_acctcode = f_get_token(ls_cctrcode,'~t')
										if (cctrCode != null && cctrCode.trim().length() > 0) 
										{
											String tokens [] = cctrCode.split(",");
						
											if ( tokens.length >= 2)
											{
												acctCode = tokens[0];
												cctrCode = tokens[1];
											}
											else
											{
												acctCode = cctrCode.substring(0,cctrCode.indexOf(","));
												cctrCode = cctrCode.substring(cctrCode.indexOf(",") + 1);
											}
										}
									}
								}
								
								System.out.println("@@cctrCode ["+cctrCode+"]");
								
								if(cctrCode == null || cctrCode.trim().length() == 0)
								{
									cctrCode = cctrCodeSal;
								}	
									
								lsStr = "acct_code = '" + checkNull((acctCode)) + "' and cctr_code = '" + checkNull(cctrCode) + "'";
								lineNo = String.valueOf(findLineNofromDetail(acctCode, cctrCode ,detailList));
										
								if(Integer.parseInt(lineNo) == 0) 
								{
									//Need to verfiy below code
									//li_lineno = lds_det.insertrow(0);
									//amountTotal = amount;
									detMap = new HashMap();
									amountTotal = amount;
								}
								else
								{	
									//Need to verfiy below code
									//amountTotal = amount + lds_det.getitemnumber(li_lineno,"amount");
									detMap = (HashMap) detailList.get(Integer.valueOf(lineNo));
									amountTotal = amount + (Double) detMap.get("amount");
								}	
							
								detMap.put("tran_id", tranId);
								detMap.put("line_no", lineNo);
								detMap.put("acct_code", acctCode);
								detMap.put("cctr_code", cctrCode);
								detMap.put("amount", amountTotal - recoAmt);
								detMap.put("emp_code", "");
								detMap.put("anal_code", "");
								
								if(Integer.parseInt(lineNo) == 0) 
								{
									detailList.add(detMap);
								}
								else
								{
									detailList.set(Integer.parseInt(lineNo), detMap);
								}
								
								total = total + amount;
							}
							if(rs != null)
							{
								rs.close();rs = null;
							}
							if(pstmt != null)
							{
								pstmt.close();pstmt = null;
							}
						
						
							sql = " select line_no, acct_code__reco, cctr_code__reco, (case when sum(reco_amount) is null then 0 else sum(reco_amount) end) as reco_amount "
					             +" from taxtran where tran_code = ? "
								 +" and tran_id	= ?  and (case when reco_amount is null then 0 else reco_amount end ) <> 0 " 
								 +" and effect <> 'N' group by line_no,acct_code__reco, cctr_code__reco ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,tranSer);
							pstmt.setString(2,tranId);
							rs = pstmt.executeQuery();
							while(rs.next())
							{
								lineNo = rs.getString("line_no");
								acctReco = rs.getString("acct_code__reco");
								cctrReco = rs.getString("cctr_code__reco");
								recoAmount = rs.getDouble("reco_amount");
								
								System.out.println("@@acctReco ["+acctReco+"]");
								
								if(acctReco == null || acctReco.trim().length() == 0)
								{
									if("H".equalsIgnoreCase(posType))
									{
										//Need to verfiy below code
										acctReco = finCommon.getAcctDetrTtype(" ", itemSer, "TAXRECO", tranType, conn);
										//ls_acct_reco = f_get_token(ls_cctr_reco,'~t')
										
										if (acctReco != null && acctReco.trim().length() > 0) 
										{
											String tokens [] = acctReco.split(",");
											acctReco = tokens[0];
										}
									}
									else if("D".equalsIgnoreCase(posType))
									{
										lineNo = lineNo.trim();
										
										sql = " select inv.item_code,i.item_ser from invoice_trace inv,item i "
											 +" where inv.invoice_id = ? and line_no = ? " 
											 +" and inv.item_code = i.item_code " ;
										pstmt1 = conn.prepareStatement(sql);
										pstmt1.setString(1,invoiceIDHdr);
										pstmt1.setString(2,lineNo);
										rs1 = pstmt1.executeQuery();
										if(rs1.next())
										{
											itemCode = rs.getString("item_code");
											itemSer = rs.getString("item_ser");
										}
										if(rs1 != null)
										{
											rs1.close();rs1 = null;
										}
										if(pstmt1 != null)
										{
											pstmt1.close();pstmt1 = null;
										}
										
										//Need to verify below code
										cctrReco = finCommon.getAcctDetrTtype(itemCode , itemSer, "TAXRECO", tranType, conn);
										//ls_acct_reco = f_get_token(ls_cctr_reco,'~t')
										
										if (cctrReco != null && cctrReco.trim().length() > 0) 
										{
											String tokens [] = cctrReco.split(",");
						
											if ( tokens.length >= 2)
											{
												acctReco = tokens[0];
												cctrReco = tokens[1];
											}
											else
											{
												acctReco = cctrReco.substring(0,cctrReco.indexOf(","));
												cctrReco = cctrReco.substring(cctrReco.indexOf(",") + 1);
											}
										}
									}
								}
								
								if(acctReco == null || acctReco.trim().length() == 0)
								{
									errCode = "VTACCTRECO";
									return errCode;
								}
								
								System.out.println("@@cctrReco["+cctrReco+"]");
								
								if(cctrReco == null || cctrReco.trim().length() == 0)
								{
									cctrReco = " ";
								}	
								
								taxRows = findLineNofromDetail(acctReco, cctrReco ,detailList);//Need to verify this code
								
								if(taxRows == 0)
								{
									//Need to verift below code
									detMap = new HashMap();
									detMap.put("tran_id",tranId);
									detMap.put("line_no",detailList.size()+1);//Need to verify what could be the line number here
									detMap.put("acct_code",acctReco);
									detMap.put("cctr_code",cctrReco);
									detMap.put("amount",recoAmt);
									detMap.put("emp_code","");
									detMap.put("anal_code","");
									detailList.add(detMap);
								}
								else if(taxRows > 0)
								{
									detMap = (HashMap) detailList.get(Integer.valueOf(taxRows));
									amount = (Double) detMap.get("amount");
									detMap.put("amount", amount + recoAmt);
									detailList.set(taxRows, detMap);
								}
								
							}
							if(rs != null)
							{
								rs.close();rs = null;
							}
							if(pstmt != null)
							{
								pstmt.close();pstmt = null;
							}
							
							if(errCode!= null && errCode.trim().length() > 0)
							{
								return errCode;
							}
						
							sql = " select d.item_code, sum(d.drcr_amt) as drcr_amt from drcr_rdet d, invoice i where d.invoice_id = i.invoice_id "
								+ " and d.tran_id = ? group by d.item_code ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,tranIDDrcrRcp);
							rs = pstmt.executeQuery();
							while(rs.next())
							{
								itemCode = rs.getString("item_code");
								amount = rs.getDouble("drcr_amt");
								
								if("H".equalsIgnoreCase(posType))
								{
									//Need to verify below code
									cctrCode = finCommon.getAcctDetrTtype(" " , itemSer, "SRET", tranType, conn);
									//ls_acctcode = f_get_token(ls_cctrcode,'~t')
									if (cctrCode != null && cctrCode.trim().length() > 0) 
									{
										String tokens [] = cctrCode.split(",");
					
										if ( tokens.length >= 2)
										{
											acctCode = tokens[0];
											cctrCode = tokens[1];
										}
										else
										{
											acctCode = cctrCode.substring(0,cctrCode.indexOf(","));
											cctrCode = cctrCode.substring(cctrCode.indexOf(",") + 1);
										}
									}
								}
								else if("D".equalsIgnoreCase(posType))
								{
									lineNo = lineNo.trim();
									
									sql = " select inv.item_code,i.item_ser from invoice_trace inv,item i "
										 +" where inv.invoice_id = ? and line_no = ? " 
										 +" and inv.item_code = i.item_code " ;
									pstmt1 = conn.prepareStatement(sql);
									pstmt1.setString(1,invoiceIDHdr);
									pstmt1.setString(2,lineNo);
									rs1 = pstmt1.executeQuery();
									if(rs1.next())
									{
										itemCode = rs.getString("item_code");
										itemSer = rs.getString("item_ser");
									}
									if(rs1 != null)
									{
										rs1.close();rs1 = null;
									}
									if(pstmt1 != null)
									{
										pstmt1.close();pstmt1 = null;
									}
									
									//Need to verify below code
									cctrCode = finCommon.getAcctDetrTtype(itemCode ,itemSer ,"SRET", tranType, conn);
									//ls_acctcode = f_get_token(ls_cctrcode,'~t')
									if (cctrCode != null && cctrCode.trim().length() > 0) 
									{
										String tokens [] = cctrCode.split(",");
					
										if ( tokens.length >= 2)
										{
											acctCode = tokens[0];
											cctrCode = tokens[1];
										}
										else
										{
											acctCode = cctrCode.substring(0,cctrCode.indexOf(","));
											cctrCode = cctrCode.substring(cctrCode.indexOf(",") + 1);
										}
									}
								}
								
								System.out.println("@@@cctrCode ["+cctrCode+"]");
								
								if(cctrCode == null || cctrCode.trim().length() == 0)
								{
									cctrCode = cctrCodeSal;
								}	
									
								lsStr = "acct_code = '" + checkNull((acctCode)) + "' and cctr_code = '" + checkNull(cctrCode) + "'";
								lineNo = String.valueOf(findLineNofromDetail(acctCode, cctrCode ,detailList));
										
								if(Integer.parseInt(lineNo) == 0) 
								{
									//Need to verify below code
									//li_lineno = lds_det.insertrow(0);
									//amountTotal = amount;
									detMap = new HashMap();
									amountTotal = amount;
								}
								else
								{	
									//Need to verify
									//amountTotal = amount + lds_det.getitemnumber(li_lineno,"amount");
									detMap = (HashMap) detailList.get(Integer.valueOf(lineNo));
									amountTotal = amount + (Double) detMap.get("amount");
								}
								
								System.out.println("**amountTotal["+amountTotal+"] amount["+amount+"] and Map amount["+(Double) detMap.get("amount")+"]");
								
								detMap.put("tran_id", tranId);
								detMap.put("line_no", lineNo);
								detMap.put("acct_code", acctCode);
								detMap.put("cctr_code", cctrCode);
								detMap.put("amount", amountTotal);
								detMap.put("emp_code", "");
								detMap.put("anal_code", "");
								
								System.out.println("LINE NUMBER IS["+lineNo+"]");
								if(Integer.parseInt(lineNo) == 0)
								{
									detailList.add(detMap);
								}
								else
								{
									detailList.set(Integer.parseInt(lineNo), detMap);
								}
								
								total = total + amount;
							}
							if(rs != null)
							{
								rs.close();rs = null;
							}
							if(pstmt != null)
							{
								pstmt.close();pstmt = null;
							}
							
							roundAdj = (Double) hdrMap.get("round_adj");
							amountHdr = (Double) hdrMap.get("amount");
							exchRate = (Double) hdrMap.get("exch_rate");
							amountHdr1 = amountHdr;
							
							System.out.println("@roundAdj["+roundAdj+"]");
							
							if(roundAdj == 0)
							{
								amountHdr = (Double)hdrMap.get("amount");
								roundOff =  (String) hdrMap.get("rnd_off");
								
								amountHdr1 = amountHdr;
								System.out.println("@roundOff["+roundOff+"]");
								if(!"N".equals(roundOff))
								{
									roundTo = (Double)hdrMap.get("rnd_to");
									amountHdr = distCommon.getRndamt(amountHdr1, roundOff, roundTo);
								}
								
								System.out.println("@amountHdr["+amountHdr+"] amountHdr1["+amountHdr1+"]");
								if(amountHdr != amountHdr1)
								{
									updRowCnt = 0;
									sql = " update drcr_rcp set amount = ?, amount__bc = (? * ?), round_adj = (? - ?) where tran_id = ? " ;
									pstmt1 = conn.prepareStatement(sql);
									pstmt1.setDouble(1, amountHdr);
									pstmt1.setDouble(2, amountHdr);
									pstmt1.setDouble(3, exchRate);
									pstmt1.setDouble(4, amountHdr);
									pstmt1.setDouble(5, amountHdr1);
									pstmt1.setString(6, tranIDDrcrRcp);
									updRowCnt = pstmt1.executeUpdate();
									
									if(pstmt1!=null)
									{
										pstmt1.close();pstmt1= null;
									}
									
									if(updRowCnt != 1)
									{
										errCode = "DS000NR";
									}
									
									hdrMap.put("round_adj", amountHdr - amountHdr1);
									hdrMap.put("amount", amountHdr);
									hdrMap.put("amount__bc", amountHdr * exchRate);
								}
							}
							
							roundAdj = (Double) hdrMap.get("round_adj");
							
							System.out.println("@@roundAdj["+roundAdj+"]");
							
							if(roundAdj != 0)
							{
								acctRnd = checkNullAndTrim(finCommon.getFinparams("999999", "ROUND_ADJUST_ACCT", conn));
								cctrRnd = checkNullAndTrim(finCommon.getFinparams("999999", "ROUND_ADJUST_CCTR", conn));
								
								if(("NULLFOUND".equals(acctRnd) || acctRnd == null || acctRnd.length() == 0) || (("NULLFOUND".equals(cctrRnd) || cctrRnd == null || cctrRnd.length() == 0)))
								{
									//errCode = "VSENVAR1";
									errCode = itmDBAccessEJB.getErrorString("","VSENVAR1","","",conn);  
									return errCode;
								}
								
								System.out.println("@@cctrRnd["+cctrRnd+"]");
								
								if(cctrRnd == null || cctrRnd.length() == 0 || "  ".equals(cctrRnd))
								{
									lineNo = String.valueOf(findLineNofromDetail(acctRnd, cctrRnd ,detailList));//Need to verify this code
									
									if(Integer.valueOf(lineNo) == 0)
									{
										//li_lineno = lds_det.insertrow(0);//NVO code
										lineNo = String.valueOf((detailList.size() + 1)); //Need to verify this code
									}
								
									detMap.put("tran_id", tranId);
									detMap.put("line_no", lineNo);
									detMap.put("acct_code", acctRnd);
									detMap.put("cctr_code", cctrRnd);
									detMap.put("amount", roundAdj);
									detMap.put("emp_code", "");
									detMap.put("anal_code", "");
									
									detailList.set(Integer.valueOf(lineNo), detMap);
								}
							}
					//}
					//while(true);
					
					System.out.println("After while loop ["+errCode+"]");		
					if(errCode != null && errCode.trim().length() > 0)
					{
						return errCode;
					}
					
					total = 0;
					dtlCount = detailList.size();
					
					System.out.println("@@dtlCount["+dtlCount+"]");
					for(int x = 0; x < dtlCount; x++)
					{
						detMap = (HashMap) detailList.get(x);
						amountDet = (Double) detMap.get("amount");
						
						System.out.println("amountDet["+amountDet+"]");
						
						total = total + amountDet;
					}
					
					amountHdr = (Double) hdrMap.get("amount");
					
					System.out.println("@@----total["+total+"] amountHdr["+amountHdr+"] and  Math.abs["+ Math.abs(total - amountHdr)+"]");
					
					if(total != amountHdr && Math.abs(total - amountHdr) > 1 )
					{
						//errCode = "VTPOST2";
						errCode = itmDBAccessEJB.getErrorString("","VTPOST2","","",conn);  
						return errCode;
					}
					
					custCode = (String) hdrMap.get("cust_code");
					//ll_adj_cnt = lds_adj.retrieve(ls_tranid)//Need to verify
					sql = " select tran_id,line_no,ref_ser,ref_no,ref_bal_amt,adj_amt,mrp_value__adj from drcr_rcpinv where tran_id= ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,tranIDDrcrRcp);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						adjMap = new HashMap();
						adjMap.put("tran_id", rs.getString("tran_id"));
						adjMap.put("line_no", rs.getString("line_no"));
						adjMap.put("ref_ser", rs.getString("ref_ser"));
						adjMap.put("ref_no", rs.getString("ref_no"));
						adjMap.put("ref_bal_amt", rs.getDouble("ref_bal_amt"));
						adjMap.put("adj_amt", rs.getDouble("adj_amt"));
						adjMap.put("mrp_value__adj", rs.getString("mrp_value__adj"));
						
						adjList.add(adjMap);
					}
					if(rs != null)
					{
						rs.close();rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();pstmt = null;
					}
					
					adjCount = adjList.size();
					total = 0;
					
					System.out.println("drcr_rcpinv Count="+adjCount);
					
					for(int x = 0; x < adjCount; x++)
					{
						adjMap = (HashMap) adjList.get(x);
						
						refNo = (String) adjMap.get("ref_no");
						refSer = (String) adjMap.get("ref_ser");
						adjAmount = (Double) adjMap.get("adj_amt");
						
						total = total + adjAmount;
						
						sql = " select count(*) from receivables where cust_code = ? and tran_ser = ? and ref_no = ? " ;
						pstmt1 = conn.prepareStatement(sql);
						pstmt1.setString(1,custCode);
						pstmt1.setString(2,refSer);
						pstmt1.setString(3,refNo);
						rs1 = pstmt1.executeQuery();
						if(rs1.next())
						{
							countRcv = rs1.getInt(1);
						}
						if(rs1 != null)
						{
							rs1.close();rs1 = null;
						}
						if(pstmt1 != null)
						{
							pstmt1.close();pstmt1 = null;
						}
						
						System.out.println("countRcv ["+countRcv+"]");
						if(countRcv == 0)
						{
							//return errCode;//Need to verify
							errCode = itmDBAccessEJB.getErrorString("",errCode,"","",conn);  
							return errCode;
						}
						
						sql = " select (tot_amt - adj_amt) as amount ,tot_amt , adj_amt from receivables where cust_code = ? and tran_ser = ? and ref_no = ? " ;
						pstmt1 = conn.prepareStatement(sql);
						pstmt1.setString(1,custCode);
						pstmt1.setString(2,refSer);
						pstmt1.setString(3,refNo);
						rs1 = pstmt1.executeQuery();
						if(rs1.next())
						{
							amount = rs1.getDouble("amount");
							totalAmountRec = rs1.getDouble("tot_amt");
							adjAmountRec = rs1.getDouble("adj_amt");
							
							System.out.println("@@@-adjAmountRec["+adjAmountRec+"] adjAmount["+adjAmount+"] totalAmountRec["+totalAmountRec+"] amount["+amount+"] ");
							if(Math.abs(adjAmountRec + adjAmount ) > Math.abs(totalAmountRec))
							{
								//Need to check this error code
								//errCode = "The  tot_amt - adj_amt in receivables table should be more than or equal to the adj_amt in detail.";
								errCode = itmDBAccessEJB.getErrorString("","VTPOST2","","",conn);  
								return errCode;
							}
						}
						if(rs1 != null)
						{
							rs1.close();rs1 = null;
						}
						if(pstmt1 != null)
						{
							pstmt1.close();pstmt1 = null;
						}
					}
					
					amount = (Double)hdrMap.get("amount");
					
					System.out.println("@@--amount["+amount+"] total["+total+"]");
					
					if(amount < 0 && total <= 0)
					{
						if(Math.abs(amount) < Math.abs(total))
						{
							//Need to check this code how to return error code
							//errCode = "The total of adj_amt in detail should not be more than the header net amount";
							errCode = itmDBAccessEJB.getErrorString("","VTPOST2","","",conn);  
							return errCode;
						}
					}
					else
					{
						if(amount < total)
						{
							//Need to check this code how to return error code
							//errCode = "The total of adj_amt in detail should not be more than the header net amount";
							errCode = itmDBAccessEJB.getErrorString("","VTPOST2","","",conn);  
							return errCode;
						}
					}
				}
				else// records found then verify amount
				{
					total = 0;
					dtlCount = detailList.size();
					
					for(int x = 1; x< dtlCount; x++)
					{
						detMap = (HashMap) detailList.get(x);
						amountDet = (Double) detMap.get("amount");
						
						if(amountDet != 0)
						{
							total = total + amountDet;
						}
					}

					amountHdr = (Double)hdrMap.get("amount");
					
					System.out.println("@@-total ["+total+"] amountHdr["+amountHdr+"] and Math.abs(total - amountHdr) ["+Math.abs(total - amountHdr)+"]");
					
					if(total != amountHdr && Math.abs(total - amountHdr) > 1 )
					{
						//errCode = "VTPOST2";
						errCode = itmDBAccessEJB.getErrorString("","VTPOST2","","",conn);  
						return errCode;
					}
				}
				
				errCode = postDrCrRcp(tranId, hdrMap, detailList, adjList, xtraParams, conn);
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception inside gbfRetrieveDrCrRcp==>"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
				if(rs1 != null)
				{
					rs1.close();rs1 = null;
				}
				if(pstmt1 != null)
				{
					pstmt1.close();pstmt1 = null;
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		
		System.out.println("Returning errorCode from gbfRetrieveDrCrRcp ["+errCode+"]");
		return errCode;
	}
	
	/**
	 * Migration gbf_post_drcr_rcp ---> postDrCrRcp
	 */
	private String postDrCrRcp(String tranId, Map hdrMap,ArrayList detailList,ArrayList adjList, String xtraParams,Connection conn) throws RemoteException,ITMException
	{
		String retString = "";
		String sql = "",sql1 = "";
		PreparedStatement pstmt = null, pstmt1 = null;
		ResultSet rs = null, rs1 = null;
		java.sql.Timestamp tranDate = null, today;
		String sReturnNo = "",sretFullRetType = "",tranType = "",postOnline = "",refSerHdr = "",refId = "",invIbcaGen = "",
			   custCode = "",siteCode = "",siteCodeRcv = "",keyStr = "",linkType = "",acctCodepay = "",cctrCodePay = "",
			   acctCodeRcp = "",cctrCodeRcp = "",ibcaID = "",remarks = "",tranSer = "",loginSiteCode = "";

		Timestamp refDate = null,dueDate = null,custRefDate = null,gpDate = null;
		String currCode = "",acctCode = "",cctrCode = "",autoRcp = "",bankCode = "",recd = "",refType = "",
				crTerm = "",itemSer = "",salesPers = "",salesPers1 = "",salesPers2 = "",custRefNo = "",gpNo = "",chgUser = "",chgTerm = "",invoiceID = "";
		double exchRate = 0,discount = 0,taxAmount = 0,custRefAmount = 0,amountBc = 0;
		
		String finEntityFrom = "",finEntityTo = "";
		double amount = 0;
		boolean adjInvoice = false;
		Map keyStoreMap = null;
		
		try
		{
			System.out.println("Inside gbf_post_drcr_rcp....tranId["+tranId+"]");
			
			chgUser = checkNullAndTrim((genericUtility.getValueFromXTRA_PARAMS(xtraParams, "chg_user"))); 
			chgTerm = checkNullAndTrim((genericUtility.getValueFromXTRA_PARAMS(xtraParams, "chg_term"))); 
			loginSiteCode = checkNullAndTrim((genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode"))); 
			
			tranDate = new java.sql.Timestamp(System.currentTimeMillis());
			SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDateStr = sdfAppl.format(tranDate);
			
			tranId = (String) hdrMap.get("tran_id");
			sReturnNo = (String) hdrMap.get("sreturn_no");
			refSerHdr = (String) hdrMap.get("tran_ser");
			invoiceID = (String) hdrMap.get("invoice_id");
			
			if(sReturnNo!= null && sReturnNo.trim().length() > 0)
			{
				sql = " update sreturn set tran_id__crn = ? where  tran_id = ? " ;
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranId);
				pstmt.setString(2,sReturnNo);
				pstmt.executeUpdate();
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
			}
			
			retString = postDrCrRcpHdr(tranId, hdrMap, detailList, xtraParams, conn);
			System.out.println("After gbfPostRcphdr---->["+retString+"]");
			if(retString != null && retString.trim().length() > 0)
			{
				return retString;
			}
			else
			{
				retString = postDrCrRcpDet(tranId, hdrMap, detailList , xtraParams, conn);
				System.out.println("After gbfPostRcpdet---->["+retString+"]");
			}
			
			if(retString != null && retString.trim().length() > 0)
			{
				return retString;
			}
			else
			{
				retString = postDrCrRcpAdjDet(tranId, hdrMap, adjList, xtraParams, conn);
				System.out.println("After gbf_post_drcr_adjdet---->["+retString+"]");
			}
			
			if(retString != null && retString.trim().length() > 0)
			{
				return retString;
			}
			
			adjInvoice = true;
			
			if(sReturnNo != null && sReturnNo.trim().length() > 0)
			{
				sretFullRetType = checkNullAndTrim(distCommon.getDisparams("999999","SRET_FULL_TRANTYPE",conn));
				
				System.out.println("sretFullRetType["+sretFullRetType+"]");
				if("NULLFOUND".equals(sretFullRetType) || sretFullRetType.length() > 0)
				{
					adjInvoice = true;
				}
				else
				{
					adjInvoice = false;
				}
				
				sql = " select tran_type from sreturn where tran_id = ? " ;
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,sReturnNo);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					tranType = rs.getString("tran_type");
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}
				
				System.out.println("adjInvoice["+adjInvoice+"]");
				if(adjInvoice)
				{
					retString = invoiceDrCrAdj (tranId , xtraParams, conn);
					System.out.println("After gbf_invoice_drcr_adj---->["+retString+"]");
					if(retString != null && retString.trim().length() > 0)
					{
						return retString;
					}
				}
				
				postOnline = checkNullAndTrim(finCommon.getFinparams("999999", "POST_ON_LINE", conn));
				System.out.println("PostOnline["+postOnline+"]");
				
				if("Y".equals(postOnline))
				{
					retString = finCommon.checkGlTranDrCr(refSerHdr, tranId, conn);
				}
				
				System.out.println("After POST_ON_LINE retString["+retString+"] RunMode["+gs_run_mode+"]");
				
				if("I".equals(gs_run_mode) && (retString == null || retString.trim().length() == 0))
				{
					invIbcaGen = checkNullAndTrim(finCommon.getFinparams("999999","INV_IBCA_GEN",conn));
					System.out.println("INV_IBCA_GEN["+invIbcaGen+"]");
					
					if("NULLFOUND".equals(invIbcaGen))
					{
						invIbcaGen = "Y";
					}
					
					if("Y".equals(invIbcaGen))
					{
						custCode = (String) hdrMap.get("cust_code");
						siteCode = (String) hdrMap.get("site_code");
						
						sql = " select site_customer.site_code__rcp from site_customer "
							+ " where ( site_customer.site_code = ? ) and ( site_customer.cust_code = ? ) ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,siteCode);
						pstmt.setString(2,custCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							siteCodeRcv = checkNullAndTrim(rs.getString("site_code__rcp"));
						}
						if(pstmt != null)
						{
							pstmt.close();pstmt = null;
						}
						if(rs != null)
						{
							rs.close();rs = null;
						}
						
						if(siteCodeRcv.length() == 0)
						{
							sql = " select site_code__rcp from customer where cust_code = ?  ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,custCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								siteCodeRcv = checkNullAndTrim(rs.getString("site_code__rcp"));
							}
							if(pstmt != null)
							{
								pstmt.close();pstmt = null;
							}
							if(rs != null)
							{
								rs.close();rs = null;
							}
						}
						
						if(siteCodeRcv.length() == 0)
						{
							siteCodeRcv = siteCode ;
						}
						
						if(!siteCodeRcv.equals(siteCode) && !"I".equals(siteCodeRcv))
						{	
							sql = " select key_string from transetup where upper(tran_window) = ?  ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,"W_RCP_IBCA");
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								keyStr = checkNullAndTrim(rs.getString("key_string"));
							}
							if(pstmt != null)
							{
								pstmt.close();pstmt = null;
							}
							if(rs != null)
							{
								rs.close();rs = null;
							}
							
							sql = " select fin_entity from site where site_code = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,siteCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								finEntityFrom = rs.getString("fin_entity");
							}
							if(pstmt != null)
							{
								pstmt.close();pstmt = null;
							}
							if(rs != null)
							{
								rs.close();rs = null;
							}
							
							sql = " select fin_entity from site where site_code = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,siteCodeRcv);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								finEntityTo = rs.getString("fin_entity");
							}
							if(pstmt != null)
							{
								pstmt.close();pstmt = null;
							}
							if(rs != null)
							{
								rs.close();rs = null;
							}
							
							sql = " select link_type, acct_code__pay, cctr_code__pay, acct_code__rcp, cctr_code__rcp "
								 +" from ibca_rcp_ctrl where site_code__from = ? and site_code__to = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,siteCode);
							pstmt.setString(2,siteCodeRcv);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								linkType = rs.getString("link_type");
								acctCodepay = rs.getString("acct_code__pay");
								cctrCodePay = rs.getString("cctr_code__pay");
								acctCodeRcp = rs.getString("acct_code__rcp");
								cctrCodeRcp = rs.getString("cctr_code__rcp");
							}
							if(pstmt != null)
							{
								pstmt.close();pstmt = null;
							}
							if(rs != null)
							{
								rs.close();rs = null;
							}
						
							//ibcaID = generateTranId("w_rcp_ibca", loginSiteCode, currDateStr, conn);
							String xmlValues = "";
							xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
							xmlValues = xmlValues + "<Header></Header>";
							xmlValues = xmlValues + "<Detail1>";
							xmlValues = xmlValues +	"<tran_id/>";
							xmlValues = xmlValues + "<site_code__from>" + siteCode + "</site_code__from>";
							xmlValues = xmlValues + "<site_code__to>" + siteCodeRcv + "</site_code__to>";
							xmlValues = xmlValues + "<tran_date>"+ currDateStr + "</tran_date>";
							xmlValues = xmlValues + "<link_type>"+linkType+"</link_type>";
							xmlValues = xmlValues + "</Detail1></Root>";
							TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
							ibcaID = tg.generateTranSeqID("R-IBCA", "tran_id", keyStr, conn);

							if("ERROR".equalsIgnoreCase(ibcaID))
							{
								retString = itmDBAccessEJB.getErrorString("", "VTTRANID", "", "",conn);
								return retString;
							}
							
							remarks = " Auto IBCA transfer of Dr/Cr Note of " + custCode;

							sql = " select ref_date, curr_code, exch_rate, cust_code, acct_code, "
							     +" cctr_code, due_date, (tot_amt - adj_amt) as amt , discount, tax_amt, auto_rcp, "
							     +" bank_code, recd, ref_type, cr_term, item_ser, sales_pers, "
							     +" sales_pers__1, sales_pers__2, tran_date,cust_ref_no,cust_ref_date,cust_ref_amt,gp_no,gp_date "
							     +" from receivables where tran_ser like '%RCP%' and  ref_no = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,tranId);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									System.out.println("Inside rs.Next()-----");
									
									refDate = rs.getTimestamp("ref_date");
									currCode = rs.getString("curr_code");
									exchRate = rs.getDouble("exch_rate");
									custCode = rs.getString("cust_code");
									acctCode = rs.getString("acct_code");
									cctrCode = rs.getString("cctr_code");
									dueDate = rs.getTimestamp("due_date");
									amount = rs.getDouble("amt");
									discount = rs.getDouble("discount");
									taxAmount = rs.getDouble("tax_amt");
									autoRcp = rs.getString("auto_rcp");
									bankCode = rs.getString("bank_code");
									recd = rs.getString("recd");
									refType = rs.getString("ref_type");
									crTerm = rs.getString("cr_term");
									itemSer = rs.getString("item_ser");
									salesPers = rs.getString("sales_pers");
									salesPers1 = rs.getString("sales_pers__1");
									salesPers2 = rs.getString("sales_pers__2");
									tranDate = rs.getTimestamp("tran_date");
									custRefNo = rs.getString("cust_ref_no");
									custRefDate = rs.getTimestamp("cust_ref_date");
									custRefAmount = rs.getDouble("cust_ref_amt");
									gpNo = rs.getString("gp_no");
									gpDate = rs.getTimestamp("gp_date");
								}
								if(pstmt != null)
								{
									pstmt.close();pstmt = null;
								}
								if(rs != null)
								{
									rs.close();rs = null;
								}
								
								if(amount < 0)
								{
									tranSer = "CRNRCP";
								}
								else
								{
									tranSer = "CRNRCP";
								}
								
								System.out.println("amount["+amount+"] * exchRate["+exchRate+"]* ");
								
								amountBc = amount * exchRate ;
								
								System.out.println("amountBc--["+amountBc+"]");
								if(amountBc != 0)
								{
									sql = " insert into rcp_ibca (tran_id, tran_date, eff_date, site_code__from, fin_entity__from, "
										 +" site_code__to, fin_entity__to, amount, curr_code, exch_rate, confirmed, acct_code__ifr," 
										 +" cctr_code__ifr, acct_code__ito, cctr_code__ito, chg_date, chg_user, chg_term, amount__bc, "
										 +" tran_type, tran_ser, link_type, remarks) " //23
										 +" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, ibcaID);
									pstmt.setTimestamp(2, tranDate);
									pstmt.setTimestamp(3, tranDate);
									pstmt.setString(4, siteCode);
									pstmt.setString(5, finEntityFrom);
									pstmt.setString(6, siteCodeRcv);
									pstmt.setString(7, finEntityTo);
									pstmt.setDouble(8, amount);
									pstmt.setString(9, currCode);
									pstmt.setDouble(10, exchRate);
									pstmt.setString(11, "N");
									pstmt.setString(12, acctCodepay);
									pstmt.setString(13, cctrCodePay);
									pstmt.setString(14, acctCodeRcp);
									pstmt.setString(15, cctrCodeRcp);
									pstmt.setTimestamp(16, tranDate);
									pstmt.setString(17, chgUser);
									pstmt.setString(18, chgTerm);
									pstmt.setDouble(19, amountBc);
									pstmt.setString(20, tranType);
									pstmt.setString(21, "I");
									pstmt.setString(22, linkType);
									pstmt.setString(23, remarks);
									pstmt.executeUpdate();
									
									sql = " insert into rcp_ibca_det (tran_id, ref_ser, ref_no, ref_date, curr_code, exch_rate, "
										 +" cust_code, acct_code, cctr_code, due_date, tot_amt, discount,tax_amt, bank_code, "
										 +" ref_type, auto_rcp, sales_pers, item_ser, sales_pers__1, sales_pers__2, cr_term, "
										 +" recd, ref_ser__org, line_no__ref, cust_ref_no, cust_ref_date, cust_ref_amt, gp_no, gp_date) " //29
										 +" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, ibcaID);
									pstmt.setString(2, refSerHdr);
									pstmt.setString(3, tranId);
									pstmt.setTimestamp(4, refDate);
									pstmt.setString(5, currCode);
									pstmt.setDouble(6, exchRate);
									pstmt.setString(7, custCode);
									pstmt.setString(8, acctCode);
									pstmt.setString(9, cctrCode);
									pstmt.setTimestamp(10, dueDate);
									pstmt.setDouble(11, amount);
									pstmt.setDouble(12, discount);
									pstmt.setDouble(13, taxAmount);
									pstmt.setString(14, bankCode);
									pstmt.setString(15, refType);
									pstmt.setString(16, autoRcp);
									pstmt.setString(17, salesPers);
									pstmt.setString(18, itemSer);
									pstmt.setString(19, salesPers1);
									pstmt.setString(20, salesPers2);
									pstmt.setString(21, crTerm);
									pstmt.setString(22, recd);
									pstmt.setString(23, tranSer);
									pstmt.setString(24, "1");
									pstmt.setString(25, custRefNo);
									pstmt.setTimestamp(26, custRefDate);
									pstmt.setDouble(27, custRefAmount);
									pstmt.setString(28, gpNo);
									pstmt.setTimestamp(29, gpDate);
									pstmt.executeUpdate();

									//ls_errcode = nvo_rcpibca.gbf_retrieve_ribca(ls_ibca_id, ls_ibca_id, 1,ls_site)
									//retString = gbf_retrieve_ribca(ibcaID, siteCode, xtraParams, conn);
									
									RcvIbcaConf ibcaObj = new RcvIbcaConf();
									retString = ibcaObj.confirm(ibcaID, xtraParams, "", conn);
									
									System.out.println("After gbf_retrieve_ribca ----->["+retString+"]");
									
									if(retString != null && retString.trim().length() > 0)
									{
										return retString;
									}
								}
						}
					}
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception inside gbf_post_drcr_rcp==>"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
				if(rs1 != null)
				{
					rs1.close();rs1 = null;
				}
				if(pstmt1 != null)
				{
					pstmt1.close();pstmt1 = null;
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		return retString;
	}
	
	/***
	 * Migration gbf_post_drcr_rcphdr --> postDrCrRcpHdr
	 */
	private String postDrCrRcpHdr (String tranId, Map hdrMap,ArrayList detailList, String xtraParams,Connection conn)throws RemoteException,ITMException
	{
		String errString = "";
		String sql = "",sql1 = "";
		PreparedStatement pstmt = null, pstmt1 = null;
		ResultSet rs = null, rs1 = null;
		java.sql.Timestamp tranDate = null, today = null;

		int ediOption = 0;
		double mrpValue = 0;
		String invoiceIDHdr = "", tranIDDrcrRcp = "",tranSer = "",winName = "",ledgPostConf = "",errCode = "",acctCode = "",cctrCode= "",
				posType = "",itemSer = "",acctCodeSal = "",cctrCodeSal = "",cctrCodeAr = "",acctReco = "",cctrReco = "",acctRnd = "",cctrRnd = "",
				tranType = "",invType = "",lineNo = "",taxAmt = "",itemCode = "",lsStr = "",custCode = "",refNo = "",refSer = "",drcrFalg = "";
		String temp = "",analysis = "",analysis1 = "",analysis2 = "",analysis3 = "",contactCode = "",salesPers = "",salesReturnNo = "",
				partyDocPref = "",confirmed = "",empCodeAprv = "",dataStr = "";
		
		Map glTraceMap = null; 
		Map sundryBalMap = null;
		Map receivablesMap = null;
		
		try
		{
			System.out.println("Inside gbf_post_drcr_rcphdr...tranId["+tranId+"]");
			
			today = new java.sql.Timestamp(System.currentTimeMillis()) ;
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
			tranDate = java.sql.Timestamp.valueOf(sdf.format(today) + " 00:00:00.000");
			
			tranSer = (String) hdrMap.get("tran_ser");
			tranId = (String) hdrMap.get("tran_id");
			tranType = (String) hdrMap.get("tran_type");
			
			if("CRNRCP".equals(tranSer))
			{
				winName = "w_drcrrcp_cr";
			}
			else if("DRNRCP".equals(tranSer))
			{
				winName = "w_drcrrcp_dr";
			}
			
		
			/*// Not to migrate following methods as per manohar sir suggetion
			ls_errcode = gbf_ud_accountposting(ls_winname, ls_transer, '', 4 , &
			 lds_hdr.describe("datawindow.syntax") &
			 + '~r' + lds_hdr.describe("datawindow.syntax.data"), &
			 lds_det.describe("datawindow.syntax") + &
			 '~r' + lds_det.describe("datawindow.syntax.data"), &
			lds_deta.describe("datawindow.syntax") + &
			 '~r' + lds_deta.describe("datawindow.syntax.data"), & 
			 lds_adj.describe("datawindow.syntax") + &
			 '~r' + lds_adj.describe("datawindow.syntax.data"), '', '', '')					 							 
			 
			 ls_acctmethod = f_get_token(ls_errcode,',')	*/			
			
			
			drcrFalg = (String) hdrMap.get("drcr_flag");
			
			System.out.println("DRCR Flag inside gbf_post_drcr_rcphdr["+drcrFalg+"]");
			
			if("D".equalsIgnoreCase(drcrFalg))
			{
				analysis = invacct.AcctAnalysisType(" ", tranSer, tranType, "DR", conn);
				temp = "DR" + analysis; 
				sql = " SELECT "+temp+" from dual ";
			}
			else
			{
				analysis = invacct.AcctAnalysisType(" ", tranSer, tranType, "CR", conn);
				temp = "CR" + analysis; 
				sql = " SELECT "+temp+" from dual ";
			}
			
			if(analysis !=null && analysis.trim().length() > 0)
			{
				String token[] = analysis.split(",");
				
				if(token.length >= 3)
				{
					analysis1 = token[0];
					analysis2 = token[1];
					analysis3 = token[2];
				}
			}
		
			//GL Trace Map started
			glTraceMap = new HashMap();
			glTraceMap.put("analysis1", analysis1);
			glTraceMap.put("analysis2", analysis2);
			glTraceMap.put("analysis3", analysis3);
			glTraceMap.put("tran_date", (Timestamp) hdrMap.get("tran_date"));
			glTraceMap.put("eff_date",  (Timestamp) hdrMap.get("eff_date"));
			glTraceMap.put("fin_entity",hdrMap.get("fin_entity"));
			glTraceMap.put("site_code", hdrMap.get("site_code"));
			glTraceMap.put("sundry_type", "C");
			glTraceMap.put("sundry_code", hdrMap.get("cust_code"));
			glTraceMap.put("cust_code", hdrMap.get("cust_code"));
			glTraceMap.put("acct_code", hdrMap.get("acct_code"));
			glTraceMap.put("cctr_code", hdrMap.get("cctr_code"));
			glTraceMap.put("emp_code", "");
			glTraceMap.put("anal_code", hdrMap.get("anal_code"));
			glTraceMap.put("curr_code", hdrMap.get("curr_code"));
			glTraceMap.put("exch_rate", hdrMap.get("exch_rate"));
			
			if("D".equals(drcrFalg))
			{
				glTraceMap.put("dr_amt", hdrMap.get("amount"));
				glTraceMap.put("cr_amt", "0");
			}
			else
			{
				glTraceMap.put("cr_amt", hdrMap.get("amount"));
				glTraceMap.put("dr_amt", "0");
			}
			
			glTraceMap.put("ref_type", "F");
			glTraceMap.put("ref_ser", hdrMap.get("tran_ser"));
			glTraceMap.put("ref_id", hdrMap.get("tran_id"));
			glTraceMap.put("remarks", hdrMap.get("remarks"));
			
			refSer = (String) glTraceMap.get("ref_ser");
			refNo  = (String) glTraceMap.get("ref_id");
			
			System.out.println("RefSer["+refSer+"] and RefNo["+refNo+"]");
			
			partyDocPref = finCommon.gfGetPartyDocRef(refSer, refNo, conn);
			glTraceMap.put("party_doc_ref", partyDocPref);
			
			errString = finCommon.glTraceUpdate((HashMap) glTraceMap, conn);
			
			System.out.println("After glTraceUpdate--->["+errString+"]");
			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}
			
			//Sundry Balance Map started
			sundryBalMap = new HashMap();
			sundryBalMap.put("tran_date", (Timestamp) hdrMap.get("tran_date"));
			sundryBalMap.put("eff_date",  (Timestamp) hdrMap.get("eff_date"));
			sundryBalMap.put("fin_entity",hdrMap.get("fin_entity"));
			sundryBalMap.put("site_code", hdrMap.get("site_code"));
			sundryBalMap.put("sundry_type", glTraceMap.get("sundry_type"));
			sundryBalMap.put("sundry_code", hdrMap.get("cust_code"));
			sundryBalMap.put("acct_code", hdrMap.get("acct_code"));
			sundryBalMap.put("cctr_code", hdrMap.get("cctr_code"));
			sundryBalMap.put("curr_code", hdrMap.get("curr_code"));
			sundryBalMap.put("exch_rate", hdrMap.get("exch_rate"));
			
			if("D".equals(drcrFalg))
			{
				sundryBalMap.put("dr_amt", (Double)hdrMap.get("amount"));
				sundryBalMap.put("cr_amt", 0.0);
			}
			else
			{
				sundryBalMap.put("cr_amt", (Double)hdrMap.get("amount"));
				sundryBalMap.put("dr_amt", 0.0);
			}
			sundryBalMap.put("adv_amt", 0.0);
			
			sql = " select contact_code from customer where cust_code = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, (String)sundryBalMap.get("sundry_code"));
			rs= pstmt.executeQuery();
			if(rs.next())
			{
				contactCode = rs.getString("contact_code");
			}
			if(rs != null)
			{
				rs.close();rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();pstmt = null;
			}
			sundryBalMap.put("contact_code",contactCode );
			
			errString = finCommon.gbf_sundrybal_upd((HashMap) sundryBalMap,conn);
			System.out.println("After gbf_sundrybal_upd--->["+errString+"]");
			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}
			
			//Recievables Map started
			receivablesMap = new HashMap();
			receivablesMap.put("tran_ser",  hdrMap.get("tran_ser"));
			receivablesMap.put("tran_date",  (Timestamp) hdrMap.get("tran_date"));
			receivablesMap.put("fin_entity",  hdrMap.get("fin_entity"));
			receivablesMap.put("site_code",  hdrMap.get("site_code"));
			receivablesMap.put("ref_no",  (String) hdrMap.get("tran_id"));
			receivablesMap.put("due_date",  (Timestamp) hdrMap.get("due_date"));
			receivablesMap.put("eff_date",  (Timestamp) hdrMap.get("eff_date"));
			receivablesMap.put("curr_code",  hdrMap.get("curr_code"));
			receivablesMap.put("exch_rate",  hdrMap.get("exch_rate"));
			receivablesMap.put("cust_code",  hdrMap.get("cust_code"));
			receivablesMap.put("acct_code",  hdrMap.get("acct_code"));
			receivablesMap.put("cctr_code",  hdrMap.get("cctr_code"));
			receivablesMap.put("tax_amt",  "0");
			receivablesMap.put("discount",  "0");
			
			if("D".equals(drcrFalg))
			{
				receivablesMap.put("tot_amt", (Double) hdrMap.get("amount"));
			}
			else
			{
				receivablesMap.put("tot_amt", 0 - (Double) hdrMap.get("amount"));
			}
			receivablesMap.put("auto_rcp", "N");
			receivablesMap.put("bank_code", "");
			receivablesMap.put("ref_type", hdrMap.get("tran_type"));
			receivablesMap.put("cr_term", hdrMap.get("cr_term"));
			invoiceIDHdr = (String) hdrMap.get("invoice_id");
			
			sql = " select sales_pers, item_ser from invoice where invoice_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,invoiceIDHdr);
			rs= pstmt.executeQuery();
			if(rs.next())
			{
				salesPers = rs.getString("sales_pers");
				itemSer = rs.getString("item_ser");
			}
			if(rs != null)
			{
				rs.close();rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();pstmt = null;
			}
			
			receivablesMap.put("cust_ref_no", hdrMap.get("cust_ref_no"));
			receivablesMap.put("cust_ref_date", hdrMap.get("cust_ref_date"));
			receivablesMap.put("cust_ref_amt", String.valueOf((Double) hdrMap.get("cust_ref_amt")));
			receivablesMap.put("gp_no", hdrMap.get("gp_no"));
			receivablesMap.put("gp_date", (Timestamp) hdrMap.get("gp_date"));
			salesReturnNo =  (String) hdrMap.get("sreturn_no");
			
			if(salesReturnNo != null && salesReturnNo.length() > 0)
			{
				sql = " select sum(case when mrp_value is null then 0 else mrp_value end) as mrp_value from sreturndet where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,salesReturnNo);
				rs= pstmt.executeQuery();
				if(rs.next())
				{
					mrpValue = rs.getDouble("mrp_value");
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
			}
			receivablesMap.put("mrp_value", (double) mrpValue);
			
			errString = finCommon.gbfReceivablesUpd((HashMap) receivablesMap,conn);
			System.out.println("After gbfReceivablesUpd--->["+errString+"]");
			
			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}
			
			confirmed = (String) hdrMap.get("confirmed");
			if(!"Y".equals(confirmed))
			{
				sql = "update drcr_rcp set confirmed = 'Y', conf_date = ? ,emp_code__aprv = ? where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setTimestamp(1, tranDate);
				pstmt.setString(2, empCodeAprv);
				pstmt.setString(3, (String) glTraceMap.get("ref_id"));
				pstmt.executeUpdate();
				if(pstmt!=null)
				{
					pstmt.close();pstmt=null;
				}
			}
			
			tranSer = (String) hdrMap.get("tran_ser");
			
			if("CRNRCP".equals(tranSer))
			{
				winName = "w_drcrrcp_cr";
			}
			else if("DRNRCP".equals(tranSer))
			{
				winName = "w_drcrrcp_dr";
			}
				
			sql = "select edi_option from transetup where tran_window = ?";	
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,winName);	
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				ediOption = rs.getInt(1);
			}
			if(rs!=null)
			{
				rs.close();rs=null;
			}
			if(pstmt!=null)
			{
				pstmt.close();pstmt=null;
			}

			if(ediOption > 0)
			{
				hdrMap.put("confirmed", "Y");
				hdrMap.put("conf_date", tranDate);
				hdrMap.put("emp_code__aprv", empCodeAprv);
			}
			
			if(ediOption == 2)
			{
				CreateRCPXML createRCPXML = new CreateRCPXML(winName, "tran_id");
                dataStr = createRCPXML.getTranXML(tranId, conn);
                System.out.println("dataStr =[ " + dataStr + "]");
                Document ediDataDom = genericUtility.parseString(dataStr);

                E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
                errString = e12CreateBatchLoad.createBatchLoad(ediDataDom, winName , "2", xtraParams, conn);
                createRCPXML = null;
                e12CreateBatchLoad = null;
                
                System.out.println("retString from edi 2 batchload gbf_post_drcr_rcphdr--->[" + errString + "]");
                
                //if (errString != null && "SUCCESS".equalsIgnoreCase(errString)) 
                if (errString != null && errString.indexOf("SUCCESS") != -1) 
				{
                	errString = "";
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception inside gbf_post_drcr_rcphdr==>"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
				if(rs1 != null)
				{
					rs1.close();rs1 = null;
				}
				if(pstmt1 != null)
				{
					pstmt1.close();pstmt1 = null;
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		return errString;
	}
	
	/**
	 * Migration gbf_post_drcr_rcpdet --> postDrCrRcpDet
	 */
	private String postDrCrRcpDet(String tranId, Map hdrMap,ArrayList detailList, String xtraParams,Connection conn)throws RemoteException,ITMException
	{
		String errString = "";
		String sql = "",sql1 = "";
		PreparedStatement pstmt = null, pstmt1 = null;
		ResultSet rs = null, rs1 = null;
		java.sql.Timestamp tranDate = null, today = null;
		Map detMap = null;
		Map glTraceMap = null;
		
		String invoiceIDHdr = "", tranIDDrcrRcp = "",tranSer = "",winName = "",ledgPostConf = "",errCode = "",acctCode = "",cctrCode= "",
				posType = "",itemSer = "",acctCodeSal = "",cctrCodeSal = "",cctrCodeAr = "",acctReco = "",cctrReco = "",acctRnd = "",cctrRnd = "",
				tranType = "",invType = "",lineNo = "",taxAmt = "",itemCode = "",lsStr = "",custCode = "",refNo = "",refSer = "",drcrFalg = "";
		String temp = "",analysis = "",analysis1 = "",analysis2 = "",analysis3 = "",contactCode = "",salesPers = "",salesReturnNo = "",
				partyDocPref = "",confirmed = "",empCodeAprv = "",siteCode = "",siteCodeFor = "",projectCode = "",currCode = "",remarks = "";
		String finEntity = "";
		double exchRate = 0;
		Date effDate = null;
		
		try
		{
			System.out.println("Inside gbf_post_drcr_rcpdet detailList size-->"+detailList.size());
			
			drcrFalg = (String)hdrMap.get("drcr_flag");
			tranDate = (Timestamp)hdrMap.get("tran_date");
			effDate = (Date)hdrMap.get("eff_date");
			finEntity = (String) hdrMap.get("fin_entity");
			siteCode = (String)hdrMap.get("site_code");
			siteCodeFor = (String)hdrMap.get("site_code__for");
			projectCode = (String)hdrMap.get("proj_code");
			currCode = (String)hdrMap.get("curr_code");
			exchRate = (Double) hdrMap.get("exch_rate");
			remarks = (String)hdrMap.get("remarks");
			
			for (int ctr =0; ctr < detailList.size(); ctr++)
			{
				detMap = (HashMap) detailList.get(ctr);
				System.out.println(" DetMap ctr [" + ctr + "] ["+detMap + "]");
				
				itemCode = checkNull((String)detMap.get("item_code"));
				tranSer = (String)hdrMap.get("tran_ser");
				tranType = (String)hdrMap.get("tran_type");
				
				if("D".equalsIgnoreCase(drcrFalg))
				{
					analysis = invacct.AcctAnalysisType(itemCode, tranSer, tranType, "DR", conn);
					temp = "DR" + analysis; 
					sql = " SELECT "+temp+" from dual ";
				}
				else
				{
					analysis = invacct.AcctAnalysisType(itemCode, tranSer, tranType, "CR", conn);
					temp = "CR" + analysis; 
					sql = " SELECT "+temp+" from dual ";
				}
				
				if(analysis !=null && analysis.trim().length() > 0)
				{
					String token[] = analysis.split(",");
					
					if(token.length >= 3)
					{
						analysis1 = token[0];
						analysis2 = token[1];
						analysis3 = token[2];
					}
				}
				
				
				glTraceMap = new HashMap();
				glTraceMap.put("tran_date", tranDate);
				glTraceMap.put("eff_date", effDate);
				glTraceMap.put("fin_entity", finEntity);
				glTraceMap.put("site_code", siteCode);
				glTraceMap.put("sundry_type","O");
				glTraceMap.put("sundry_code"," ");
				glTraceMap.put("acct_code", (String)detMap.get("acct_code"));
				glTraceMap.put("cctr_code", (String)detMap.get("cctr_code"));
				glTraceMap.put("emp_code", (String)detMap.get("emp_code"));
				glTraceMap.put("anal_code", (String)detMap.get("anal_code"));
				glTraceMap.put("curr_code", (String)hdrMap.get("curr_code"));
				glTraceMap.put("exch_rate", (Double)hdrMap.get("exch_rate"));
				
				if("D".equals(drcrFalg))
				{
					if((Double)detMap.get("amount") > 0)
					{
						glTraceMap.put("cr_amt", (Double) detMap.get("amount"));
						glTraceMap.put("dr_amt", "0");
					}
					else
					{
						glTraceMap.put("dr_amt", 0 - (Double)detMap.get("amount"));
						glTraceMap.put("cr_amt", "0");
					}
				}
				else
				{
					if((Double)detMap.get("amount") > 0)
					{
						glTraceMap.put("dr_amt", (Double) detMap.get("amount"));
						glTraceMap.put("cr_amt", "0");
					}
					else
					{
						glTraceMap.put("cr_amt", 0 - (Double)detMap.get("amount"));
						glTraceMap.put("dr_amt", "0");
					}
				}
				
				glTraceMap.put("ref_type", "F");
				glTraceMap.put("ref_id", tranId);
				glTraceMap.put("ref_ser", tranSer);
				glTraceMap.put("remarks", remarks);
				
				System.out.println("refSer["+tranSer+"] tranId["+tranId+"]");
				
				partyDocPref = finCommon.gfGetPartyDocRef(tranSer, tranId, conn);
				glTraceMap.put("party_doc_ref", partyDocPref);
				
				errString = finCommon.glTraceUpdate((HashMap) glTraceMap, conn);
				System.out.println("After glTraceUpdate---->["+errString+"]");
				
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception inside gbf_post_drcr_rcpdet==>"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		return errString;
	}
	
	/**
	 * Migration gbf_post_drcr_adjdet --> postDrCrRcpAdjDet
	 */
	private String postDrCrRcpAdjDet(String tranId, Map hdrMap, ArrayList detailList, String xtraParams,Connection conn)throws RemoteException,ITMException
	{
		String errString = "";
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Map detMap = null;
	
		String refSer = "",refNo = "", refSerHdr = "";

		double totAdjAmount = 0,amount = 0,adjAmt = 0,totalAmount = 0;
	
		try
		{
			System.out.println("Inside gbf_post_drcr_adjdet detailList size-->"+detailList.size());
			
			tranId = (String)hdrMap.get("tran_id");
			refSerHdr = (String)hdrMap.get("tran_ser");
			
			for (int ctr =0; ctr < detailList.size(); ctr++)
			{
				detMap = (HashMap) detailList.get(ctr);
				
				refSer = checkNull((String)detMap.get("ref_ser"));
				refNo = (String)detMap.get("ref_no");
				amount = (Double) detMap.get("adj_amt");
				totAdjAmount += amount;
				
				sql = "update receivables set adj_amt = (case when adj_amt is null then 0 else adj_amt end + ? ) where tran_ser = ? and ref_no = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setDouble(1,amount);
				pstmt.setString(2,refSer);
				pstmt.setString(3,refNo);
				pstmt.executeUpdate();
				
				if(pstmt!=null)
				{	
					pstmt.close();pstmt = null;
				}
				
				sql = " select adj_amt, tot_amt from receivables where tran_ser = ? and ref_no = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,refSer);
				pstmt.setString(2,refNo);
				rs = pstmt.executeQuery();
				
				if(rs.next())
				{
					adjAmt = rs.getDouble("adj_amt");
					totalAmount = rs.getDouble("tot_amt");
				}
				if(rs!=null)
				{	
					rs.close();rs = null;
				}
				if(pstmt!=null)
				{	
					pstmt.close();pstmt = null;
				}
				
				if(adjAmt > totalAmount)
				{
					sql = "update receivables set status = ? where tran_ser = ? and ref_no = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,"A");
					pstmt.setString(2,refSer);
					pstmt.setString(3,refNo);
					pstmt.executeUpdate();
					
					if(pstmt!=null)
					{	
						pstmt.close();pstmt = null;
					}
				}
				
				sql = " update receivables set adj_amt = (case when adj_amt is null then 0 else adj_amt end + (-1 * ?) ) where tran_ser = ? and ref_no = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setDouble(1,amount);
				pstmt.setString(2,refSerHdr);
				pstmt.setString(3,tranId);
				pstmt.executeUpdate();
				
				if(pstmt!=null)
				{	
					pstmt.close();pstmt = null;
				}

				sql = " select adj_amt, tot_amt from receivables where tran_ser = ? and ref_no = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,refSerHdr);
				pstmt.setString(2,tranId);
				rs = pstmt.executeQuery();
				
				if(rs.next())
				{
					adjAmt = rs.getDouble("adj_amt");
					totalAmount = rs.getDouble("tot_amt");
				}
				if(rs!=null)
				{	
					rs.close();rs = null;
				}
				if(pstmt!=null)
				{	
					pstmt.close();pstmt = null;
				}
				
				if(adjAmt == totalAmount)
				{
					sql = "update receivables set status = ? where tran_ser = ? and ref_no = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,"A");
					pstmt.setString(2,refSerHdr);
					pstmt.setString(3,tranId);
					pstmt.executeUpdate();
					
					if(pstmt!=null)
					{	
						pstmt.close();pstmt = null;
					}
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception inside gbf_post_drcr_adjdet==>"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		return errString;
	}
	
	/***
	 * Migration gbf_invoice_drcr_adj --> invoiceDrCrAdj
	 */
	public String invoiceDrCrAdj(String tranIDDrCr ,String xtraParams, Connection conn) throws ITMException
	{
		String retString = "";
		String sql = "";
		PreparedStatement pstmt = null,pstmt1= null;
		ResultSet rs = null;
		String keyStr = "", adjTranSer = "",invoiceID = "",tranSer = "",siteCode = "",adjRecv = "",postOnline = "",
			   refType = "",adjRefNo = "",refNo = "",nextID = "",status = "",tranID = "";
		int cnt = 0;
		Timestamp tranDate = null,currDate = null;
		double totAmount = 0,adjAmount = 0,diffAmount = 0,netAmount = 0,allInvTot = 0,allInvAdj = 0,invTot = 0, invAdj = 0,
				pendAmount = 0,crAmount = 0;
		ArrayList invoiceIDList = new ArrayList();
		ArrayList netAmountList = new ArrayList();
		
		try
		{
			System.out.println("Inside gbf_invoice_drcr_adj...tranIDDrCr["+tranIDDrCr+"]");
			
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDateStr = sdfAppl.format(currDate);
			
			adjTranSer = "S-INV";
			sql = " select invoice_id, tran_ser, site_code, adj_recv from drcr_rcp where tran_id = ?  ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranIDDrCr);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				cnt++;
				invoiceID = rs.getString("invoice_id");
				tranSer = rs.getString("tran_ser");
				siteCode = rs.getString("site_code");
				adjRecv = rs.getString("adj_recv");
			}
			if(rs!=null)
			{	
				rs.close();rs = null;
			}
			if(pstmt!=null)
			{	
				pstmt.close();pstmt = null;
			}
			
			if(cnt > 0)
			{
				sql = " update drcr_rcp set adj_recv = 'N' where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranIDDrCr);
				pstmt.executeUpdate();
				if(pstmt!=null)
				{
					pstmt.close();pstmt = null;
				}
			}
			
			if(adjRecv == null)
			{
				adjRecv = "N";
			}
			if(!("C".equals(adjRecv) || "D".equals(adjRecv) || "B".equals(adjRecv) || !"N".equals(adjRecv)))
			{
				sql = " update drcr_rcp set adj_recv = 'N' where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranIDDrCr);
				pstmt.executeUpdate();
				if(pstmt!=null)
				{
					pstmt.close();pstmt = null;
				}
			}
			
			if("DRNRCP".equals(tranSer) && "C".equals(adjRecv))
			{
				sql = " update drcr_rcp set adj_recv = 'N' where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranIDDrCr);
				pstmt.executeUpdate();
				if(pstmt!=null)
				{
					pstmt.close();pstmt = null;
				}
			}
			else if("CRNRCP".equals(tranSer) && "D".equals(adjRecv))
			{
				sql = " update drcr_rcp set adj_recv = 'N' where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranIDDrCr);
				pstmt.executeUpdate();
				if(pstmt!=null)
				{
					pstmt.close();pstmt = null;
				}
			}
			
			cnt = 0;
			sql = " select invoice_id, tran_date, inv_type from invoice where invoice_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, invoiceID);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				cnt++;
				adjRefNo = rs.getString("invoice_id");
				tranDate = rs.getTimestamp("tran_date");
				refType = rs.getString("inv_type");
			}
			if(rs!=null)
			{
				rs.close();rs= null;
			}
			if(pstmt!=null)
			{
				pstmt.close();pstmt = null;
			}
			
			if(cnt > 0)
			{
				sql = " update drcr_rcp set adj_recv = 'N' where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranIDDrCr);
				pstmt.executeUpdate();
				if(pstmt!=null)
				{
					pstmt.close();pstmt = null;
				}
			}
			else if("FN".equals(refType))
			{
				sql = " update drcr_rcp set adj_recv = 'N' where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranIDDrCr);
				pstmt.executeUpdate();
				if(pstmt!=null)
				{
					pstmt.close();pstmt = null;
				}
			}
			
			cnt = 0;
			sql = " select key_string from transetup where upper(tran_window) = ?  ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,"W_REC_ADJ");
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				cnt++;
				keyStr = checkNullAndTrim(rs.getString("key_string"));
			}
			if(pstmt!=null)
			{
				pstmt.close();pstmt = null;
			}
			if(rs != null)
			{
				rs.close();rs = null;
			}
			
			if(cnt > 0)
			{
				sql = " update drcr_rcp set adj_recv = 'N' where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranIDDrCr);
				pstmt.executeUpdate();
				if(pstmt!=null)
				{
					pstmt.close();pstmt = null;
				}
			}
			else
			{
				sql = " select key_str from transetup where upper(tran_window) = ?  ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,"GENERAL");
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					keyStr = checkNullAndTrim(rs.getString("key_str"));
				}
				if(pstmt!=null)
				{
					pstmt.close();pstmt = null;
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}
				
				if(cnt > 0)
				{
					sql = " update drcr_rcp set adj_recv = 'N' where tran_id = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, tranIDDrCr);
					pstmt.executeUpdate();
					if(pstmt!=null)
					{
						pstmt.close();pstmt = null;
					}
				}
			}
			
			sql = " select tran_id, tran_ser, ref_no, tot_amt, adj_amt from receivables "
				+ " where ((tran_ser = ? ) and (tot_amt - adj_amt) <> 0) and ref_no = ? and line_no__ref = '1' ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranSer);
			pstmt.setString(2,tranIDDrCr);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				tranID = rs.getString("tran_id");
				tranSer = rs.getString("tran_ser");
				refNo = rs.getString("ref_no");
				totAmount = rs.getDouble("tot_amt");
				adjAmount = rs.getDouble("adj_amt");
			}
			if(pstmt!=null)
			{
				pstmt.close();pstmt = null;
			}
			if(rs != null)
			{
				rs.close();rs = null;
			}
			diffAmount = totAmount - adjAmount;
			
			sql = " select invoice_id, sum(net_amt) as net_amt from drcr_rdet where tran_id = ? group by invoice_id ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranIDDrCr);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				invoiceID = rs.getString("invoice_id");
				netAmount = rs.getDouble("net_amt");
				
				invoiceIDList.add(invoiceID);
				netAmountList.add(netAmount);
			}
			if(pstmt != null)
			{
				pstmt.close();pstmt = null;
			}
			if(rs != null)
			{
				rs.close();rs = null;
			}
			
			
			for(int i = 0; i < invoiceIDList.size(); i++)
			{
				invoiceID = (String) invoiceIDList.get(i);
				adjRefNo = invoiceID;
				diffAmount = (Double) netAmountList.get(i);
				
				if("CRNRCP".equals(tranSer) || "R-ADV".equals(tranSer))
				{
					diffAmount = diffAmount * -1;
				}
				allInvTot = 0;
				allInvAdj = 0;
				invTot = 0;
				invAdj = 0;
				
				sql = " select  tot_amt, adj_amt from receivables where tran_ser = ? and ref_no = ? and (tot_amt - adj_amt) <> 0 ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranSer);
				pstmt.setString(2,invoiceID);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					System.out.println("Inside receivables for refNo ["+invoiceID+"] ");
					
					invTot = rs.getDouble("tot_amt");
					invAdj = rs.getDouble("adj_amt");
					
					allInvTot = allInvTot + invTot;
					allInvAdj = allInvAdj + invAdj;
				}
				if(pstmt!=null)
				{
					pstmt.close();pstmt = null;
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}
				
				System.out.println("allInvTot["+allInvTot+"] allInvAdj["+allInvAdj+"] diffAmount["+diffAmount+"] invTot["+invTot+"] invAdj["+invAdj+"]");
				 
				if(allInvTot == 0 && allInvAdj == 0)
				{
					return retString;
				}		
				if((invTot - (invAdj - diffAmount)) < 0 ) 
				{
					return retString;		
				}
				
				if((allInvTot - (allInvAdj - diffAmount)) < 0 )
				{
					sql = " update drcr_rcp set adj_recv = 'N' where tran_id = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, tranIDDrCr);
					pstmt.executeUpdate();
					if(pstmt!=null)
					{
						pstmt.close();pstmt = null;
					}
				}
				
				 nextID = generateTranId( "w_rec_adj", siteCode, currDateStr, conn);
				 
				 sql = " insert into receivables_adj (tran_id, ref_ser, ref_no, tot_amt, adj_amt, net_amt,ref_ser_adj,ref_no_adj, tran_id__rcv) "
					 	 + " values(?, ?, ?, ?, ?, ?, ?, ?, ?) ";
				 pstmt = conn.prepareStatement(sql);
				 pstmt.setString(1, nextID);
				 pstmt.setString(2, tranSer);
				 pstmt.setString(3, refNo);
				 pstmt.setDouble(4, diffAmount);
				 pstmt.setDouble(5, diffAmount);
				 pstmt.setDouble(6, 0);
				 pstmt.setString(7, adjTranSer);
				 pstmt.setString(8, adjRefNo);
				 pstmt.setString(9, tranID);
				 pstmt.executeUpdate();
				 
				 if(pstmt!=null)
				 {
					 pstmt.close();pstmt= null;
				 }
				 
				 if(i == 0)
				 {
					sql = " update receivables set adj_amt = tot_amt, status = 'A'  where tran_id = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, tranID);
					pstmt.executeUpdate();
					if(pstmt!=null)
					{
						pstmt.close();pstmt = null;
					}
				 }
				 
				cnt = 0; 
			    sql = " select  tot_amt, adj_amt from receivables where tran_ser = ? and ref_no = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranSer);
				pstmt.setString(2,invoiceID);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					cnt++;
					invTot = rs.getDouble("tot_amt");
					invAdj = rs.getDouble("adj_amt");
					
					if(invTot == invAdj && (!"DRNRCP".equals(tranSer) || !"MDRCRD".equals(tranSer)))
					{
						continue;
					}
					
					if("CRNRCP".equals(tranSer) || "MDRCRC".equals(tranSer) || "R-ADV".equals(tranSer))
					{
						pendAmount = invTot - invAdj;
						crAmount = diffAmount;
						diffAmount = diffAmount + pendAmount;
						
						if(diffAmount <= 0)
						{
							status = "A";
							sql = " update receivables set adj_amt = adj_amt + ?, status = ?  where tran_ser = ? and tran_id = ? and line_no__ref = ? ";
							pstmt1 = conn.prepareStatement(sql);
							pstmt1.setDouble(1, pendAmount);
							pstmt1.setString(2, status);
							pstmt1.setString(3, adjTranSer);
							pstmt1.setString(4, invoiceID);
							pstmt1.setString(5, ""+cnt);
							pstmt1.executeUpdate();
							if(pstmt1!=null)
							{
								pstmt1.close();pstmt1 = null;
							}
						}
						else
						{
							status = "U";
							sql = " update receivables set adj_amt = adj_amt - ?, status = ?  where tran_ser = ? and tran_id = ? and line_no__ref = ? ";
							pstmt1 = conn.prepareStatement(sql);
							pstmt1.setDouble(1, crAmount);
							pstmt1.setString(2, status);
							pstmt1.setString(3, adjTranSer);
							pstmt1.setString(4, invoiceID);
							pstmt1.setString(5, ""+cnt);
							pstmt1.executeUpdate();
							if(pstmt!=null)
							{
								pstmt.close();pstmt = null;
							}
						}
						
					}
					else if("DRNRCP".equals(tranSer) || "MDRCRD".equals(tranSer))
					{
						if(invTot != (invAdj - diffAmount))
						{
							status = "U";
						}
						else
						{
							status = "A";
						}
						
						sql = " update receivables set adj_amt = adj_amt - ?, status = ?  where tran_ser = ? and tran_id = ? and line_no__ref = ? ";
						pstmt1 = conn.prepareStatement(sql);
						pstmt1.setDouble(1, crAmount);
						pstmt1.setString(2, status);
						pstmt1.setString(3, adjTranSer);
						pstmt1.setString(4, invoiceID);
						pstmt1.setString(5, ""+cnt);
						pstmt1.executeUpdate();
						if(pstmt!=null)
						{
							pstmt.close();pstmt = null;
						}
					}
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Expcetion inside gbf_invoice_drcr_adj ==>"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();rs= null;
				}
				if(pstmt!=null)
				{
					pstmt.close();pstmt= null;
				}
				if(pstmt1!=null)
				{
					pstmt1.close();pstmt1= null;
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		return retString;
	}
	
	private String generateTranId(String windowName, String siteCode, String tranDateStr, Connection conn) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String selSql = "";
		String tranId = "";
		String tranSer = "";
		String keyString = "";
		String keyCol = "";
		String xmlValues = "";
		String paySiteCode = "";
		String effectiveDate = "";
		java.sql.Date effDate = null;
		try
		{
			System.out.println("generateTranId() called");
			selSql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
			// System.out.println("selSql :"+selSql);
			pstmt = conn.prepareStatement(selSql);
			pstmt.setString(1, windowName);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				keyString = rs.getString("KEY_STRING");
				keyCol = rs.getString("TRAN_ID_COL");
				tranSer = rs.getString("REF_SER");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			System.out.println("keyString :" + keyString);
			System.out.println("keyCol :" + keyCol);
			System.out.println("tranSer :" + tranSer);
			xmlValues = "<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues + "<tran_id></tran_id>";
			xmlValues = xmlValues + "<site_code>" + siteCode + "</site_code>";
			xmlValues = xmlValues + "<tran_date>" + tranDateStr + "</tran_date>";
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues :[" + xmlValues + "]");
			TransIDGenerator generatedTranid = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
			tranId = generatedTranid.generateTranSeqID(tranSer, keyCol, keyString, conn);

			System.out.println("tranId :" + tranId);
		} catch (SQLException ex)
		{
			System.out.println("Exception ::" + selSql + ex.getMessage() + ":");
			ex.printStackTrace();
			throw new ITMException(ex);
		} catch (Exception e)
		{
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			} catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return tranId;
	}
	
	private String checkNull(String input)
	{
		if(input == null)
		{
			input = "";
		}
		return input;
	}

	public String checkNullAndTrim( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		else
		{
			inputVal = inputVal.trim();
		}
		return inputVal;
	}
	
	public int findLineNofromDetail(String acctCode,String cctrCode,ArrayList detailList)
	{
		int lineNo = 0;
		HashMap detMap = new HashMap();
		String acctCodeMap = "",cctrCodeMap = "";
		try
		{
			for(int ctr=0 ; ctr < detailList.size() ; ctr++)
			{
				detMap = (HashMap) detailList.get(ctr);
				acctCodeMap = (String) detMap.get("acct_code");
				cctrCodeMap = (String) detMap.get("cctr_code");
				if (acctCodeMap.trim().equalsIgnoreCase(acctCode.trim()) && cctrCodeMap.trim().equalsIgnoreCase(cctrCode.trim()))
				{
					lineNo = (Integer) detMap.get("line_no");
					break;
				}
			}
		}
		catch (Exception e)
		{
			System.out.println("Exception inside findLineNofromDetail==>"+e.getMessage());
		}
		return lineNo;
	}
}
