package ibase.dashboard.crm.ejb;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;

import javax.ejb.Stateless;

import org.json.simple.JSONObject;

@Stateless
public class PendingCommunicationDashboard implements
PendingCommunicationDashboardLocal, PendingCommunicationDashboardRemote {

	@SuppressWarnings({ "unchecked"})
	public JSONObject getPendingCommunicationDashboard(String dataSourceName,
			String loginCode) 
	{
		E12GenericUtility genericUtility = new E12GenericUtility();
		JSONObject rowDataBasicJsn = new JSONObject();
		JSONObject rowData = null;
		String sql = "", sql1 = "", sql2 = "",sql3 = "";
		ResultSet rs = null, rs1 = null, rs2 = null,rs3=null;
		PreparedStatement pstmt = null, pstmt1 = null, pstmt2 = null,pstmt3=null;
		Connection conn = null;
		ConnDriver connection = new ConnDriver();
		String salesPers = "", sconCode = "", commId = "" ;
		Date commDate1 = null;
		String dbDataFormat="",applDataFormat ="";

		int count = 0;
		long millis = 0;
		StringBuffer xmlString = new StringBuffer();
		millis = System.currentTimeMillis();
		java.sql.Date date = new java.sql.Date(millis);
		System.out.println("Current date :::: "+ date);

		try {
			conn = connection.getConnectDB(dataSourceName);

			dbDataFormat = genericUtility.getDBDateFormat();
			applDataFormat = genericUtility.getApplDateFormat();

			sql3="select sales_pers from sales_pers where emp_code = ?";
			pstmt3 = conn.prepareStatement(sql3);
			pstmt3.setString(1, loginCode);
			rs3 = pstmt3.executeQuery();
			while (rs3.next()) 
			{
				salesPers = rs3.getString("sales_pers");
			}
			if (rs3 != null) {
				rs3.close();
				rs3 = null;
			}

			if (pstmt3 != null) 
			{
				pstmt3.close();
				pstmt3 = null;
			}
			sql = "SELECT scon_code FROM contact_comm_plan WHERE comm_id is null and sales_pers = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, salesPers);
			rs = pstmt.executeQuery();
			while (rs.next()) 
			{
				sconCode = rs.getString("scon_code");

				sql1 = "SELECT MAX(cp.comm_date) as past_comm_date FROM contact_comm_plan cp inner join strg_contact sc on sc.scon_code = cp.scon_code WHERE cp.scon_code = ? "
						+ " and cp.sales_pers = ? " ;
				pstmt1 = conn.prepareStatement(sql1);
				pstmt1.setString(1, sconCode);
				pstmt1.setString(2, salesPers);
				rs1 = pstmt1.executeQuery();
				while (rs1.next()) 
				{
					commDate1 = rs1.getDate("past_comm_date");
					String newdate = (commDate1 != null )? genericUtility.getValidDateString(commDate1.toString(), dbDataFormat, applDataFormat ):null;
					if (commDate1.before(date)) 
					{
						sql2 = "select  trim(sa.descr) as activity_descr,"+
								" CASE CP.CONTACT_TYPE WHEN '1' THEN 'Call' WHEN '2' THEN 'Mail' WHEN '3' THEN 'Meeting' WHEN '4'"+
								" THEN 'Videoconferencing'WHEN '5' THEN 'Other' END AS DESCR ,"+
								"(sc.first_name||' '||case when sc.last_name is null or length(trim(sc.last_name)) = 0 then '' else trim(sc.last_name) end) as contact_name,"+
								" so.sorg_name "+
								" from contact_comm_plan cp"+
								" LEFT OUTER join strg_contact  sc"+
								" on sc.scon_code = cp.scon_code"+
								" LEFT OUTER join strg_org so"+
								" on so.sorg_code = sc.sorg_code"+ 
								" LEFT OUTER  join sales_activity sa"+
								" on sa.activity_code = cp.activity_code"+ 
								" where  sc.scon_code=? and cp.sales_pers = ?";
						pstmt2 = conn.prepareStatement(sql2);
						pstmt2.setString(1, sconCode);
						pstmt2.setString(2, salesPers);
						rs2 = pstmt2.executeQuery();
						while (rs2.next()) 
						{
							System.out.println("Inside while @@@Pending communication Dashboard");
							count++;
							if(count == 1)
							{
								xmlString = new StringBuffer("<table class='mtBackgroundWhite' border=''><tbody><tr>"
										+ "<th class='mtBackgroundWhite' style='width: 2%;'>Date</th>" 
										+"<th class='mtBackgroundWhite' style='width: 2%;'>Contact Person</th>"
										+"<th class='mtBackgroundWhite' style='width: 2%;'>Contact mode</th>"
										+"<th class='mtBackgroundWhite' style='width: 2%;'>Activity Description</th>"
										+"</tr>");
							}
							xmlString.append("<tr><td rowspan ='2' class= 'cardHtmlTableBodyAlignLft' style='width: 2%;'>"+newdate+"</td>");
							xmlString.append("<td class= 'cardHtmlTableBodyAlignLft' style='width: 2%;'>"+(rs2.getString("contact_name"))+"</td>");
							xmlString.append("<td rowspan ='2' class= 'cardHtmlTableBodyAlignLft' style='width: 2%;'>"+checkNull(rs2.getString("DESCR"))+"</td>");
							xmlString.append("<td rowspan ='2'class= 'cardHtmlTableBodyAlignLft' style='width: 2%;'>"+checkNull(rs2.getString("activity_descr"))+"</td></tr>");
							xmlString.append("<tr><td class= 'cardHtmlTableBodyAlignLft' style='width: 2%;border-top: 1px solid transparent;vertical-align:top;'>"+checkNull(rs2.getString("sorg_name"))+"</td></tr>");

						}

					}

				}
				if(count == 0)
				{
					xmlString = new StringBuffer("<table  id='htmlTable' cellpadding='2'"+
							"align='center'><tbody><tr><td align = 'center' class='gwt-ScrollTable'>No "+
							"Data Found</td></tr>");
				}

			}
			System.out.println("xmlString ::::[ "+xmlString+" ]");
			xmlString.append("</tbody></table>");
			rowData =new JSONObject();
			rowData.put("xmlString", xmlString.toString());
			rowDataBasicJsn.put(0,rowData);
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("Exception in Pending Communication Dashboard :::: "+ e.getMessage());
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}

				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}

				if (rs1 != null) {
					rs1.close();
					rs1 = null;
				}

				if (pstmt1 != null) {
					pstmt1.close();
					pstmt1 = null;
				}
				if (rs2 != null) {
					rs2.close();
					rs2 = null;
				}

				if (pstmt2 != null) {
					pstmt2.close();
					pstmt2 = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
				conn = null;

			} catch (Exception d) {
				d.printStackTrace();
				try {
					throw new ITMException(d);
				} catch (ITMException e) {
					e.printStackTrace();
				}
			}
		}
		return rowDataBasicJsn;
	}

	private String checkNull(String str) {
		if (str == null) {
			return "";
		} else {
			return str.trim();
		}
	}
}
