/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb.adm;

import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.adm.AdmCommon;
import ibase.webitm.ejb.adm.EmpMthadPrsLocal;
import ibase.webitm.ejb.adm.EmpMthadPrsRemote;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import javax.ejb.Stateless;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class EmpMthadPrs
extends ValidatorEJB
implements EmpMthadPrsLocal,
EmpMthadPrsRemote {
    public String preSaveRec() throws RemoteException, ITMException {
        return "";
    }

    public String preSaveRec(String xmlString1, String domId, String objContext, String editFlag, String xtraParams, Connection conn) throws RemoteException, ITMException {
        System.out.println("EmpMthadPrsEJB called...........");
        Document dom = null;
        try {
            if (xmlString1 != null && xmlString1.trim().length() > 0) {
                dom = GenericUtility.getInstance().parseString(xmlString1);
                this.executepreSaveRec(dom, domId, objContext, editFlag, xtraParams, conn);
            }
        }
        catch (Exception e) {
            System.out.println("Exception :EmpMthadPrsEJB :preSaveRec() :" + e.getMessage() + ":");
            e.printStackTrace();
            throw new ITMException(e);
        }
        return "";
    }

    private String executepreSaveRec(Document dom, String domID, String objContext, String editFlag, String xtraParams, Connection conn) throws RemoteException, ITMException {
        Statement pstmt = null;
        Statement stmt = null;
        ResultSet rs = null;
        String empCode = "";
        String adCode = "";
        String effDate = "";
        String expDate = "";
        String periodFrom = "";
        String periodTo = "";
        String sqlStr = "";
        String amt = "";
        String keyString = "";
        String errorCode = "";
        String monthCode = "";
        String updateStatus = "";
        String userId = "";
        String retString = "";
        double originalAmt = 0.0;
        double amount = 0.0;
        boolean empStatus = false;
        Timestamp effectiveDate = null;
        Timestamp expiryDate = null;
        Node currDetail = null;
        ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
        try {
            try {
                GenericUtility genericUtility = GenericUtility.getInstance();
                userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "userId");
                AdmCommon admCommon = new AdmCommon();
                System.out.println("dom.............:: " + dom);
                System.out.println("domID.............:: " + domID);
                currDetail = this.getCurrentDetailFromDom(dom, domID);
                updateStatus = this.getCurrentUpdateFlag(currDetail);
                System.out.println("updateStatus.............:: " + updateStatus);
                if (currDetail != null && (updateStatus.equalsIgnoreCase("A") || updateStatus.equalsIgnoreCase("E"))) {
                    empCode = genericUtility.getColumnValueFromNode("emp_code", currDetail);
                    adCode = genericUtility.getColumnValueFromNode("ad_code", currDetail);
                    monthCode = genericUtility.getColumnValueFromNode("month_code", currDetail);
                    effDate = genericUtility.getColumnValueFromNode("eff_date", currDetail);
                    expDate = genericUtility.getColumnValueFromNode("exp_date", currDetail);
                    effectiveDate = Timestamp.valueOf(genericUtility.getValidDateTimeString(effDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()));
                    expiryDate = Timestamp.valueOf(genericUtility.getValidDateTimeString(expDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()));
                    System.out.println("effectiveDate...:: " + effectiveDate);
                    System.out.println("expiryDate...:: " + expiryDate);
                    sqlStr = "SELECT CODE FROM PERIOD WHERE FR_DATE <= ? AND TO_DATE >= ? ";
                    System.out.println("sqlStr.....::[1]:: " + sqlStr);
                    pstmt = conn.prepareStatement(sqlStr);
                    pstmt.setTimestamp(1, effectiveDate);
                    pstmt.setTimestamp(2, effectiveDate);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        periodFrom = rs.getString("CODE");
                    }
                    System.out.println("periodFrom:: " + periodFrom);
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                    sqlStr = "SELECT CODE FROM PERIOD WHERE FR_DATE <= ? AND TO_DATE >= ? ";
                    System.out.println("sqlStr.....::[2]:: " + sqlStr);
                    pstmt = conn.prepareStatement(sqlStr);
                    pstmt.setTimestamp(1, expiryDate);
                    pstmt.setTimestamp(2, expiryDate);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        periodTo = rs.getString("CODE");
                    }
                    System.out.println("periodTo:: " + periodTo);
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                    keyString = String.valueOf(empCode) + "|" + monthCode + "|" + adCode + "|" + effectiveDate;
                    System.out.println("keyString.....:: " + keyString);
                    errorCode = admCommon.payarrToProcUpdation(periodFrom, periodTo, empCode, empCode, "AR", "W_EMP_MTHAD", keyString, null, 0.0, null, null, xtraParams, conn);
                    if (errorCode.trim().length() > 0) {
                        conn.rollback();
                        retString = itmDBAccessEJB.getErrorString("", errorCode, userId);
                        System.out.println("Ret String: " + retString);
                    } else if (errorCode.trim().length() == 0) {
                        conn.commit();
                    }
                }
            }
            catch (SQLException sqe) {
                System.out.println("The SQLException occurs in [EmpMthadPrsEJB] :: [executepreSaveRec] :" + sqe);
                sqe.printStackTrace();
                try {
                    conn.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ITMException((Exception)sqe);
            }
            catch (Exception e) {
                System.out.println("The Exception occurs in [EmpMthadPrsEJB] :: [executepreSaveRec] :" + e);
                e.printStackTrace();
                try {
                    conn.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ITMException(e);
            }
        }
        finally {
            try {
                System.out.println("Closing stmt and pstmt......");
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :[EmpMthadPrsEJB] :: [executepreSaveRec] :\n" + e.getMessage());
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return retString;
    }

    private Node getCurrentDetailFromDom(Document dom, String domId) {
        NodeList detailList = null;
        Node currDetail = null;
        Node reqDetail = null;
        String currDomId = "";
        int detailListLength = 0;
        detailList = dom.getElementsByTagName("Detail1");
        detailListLength = detailList.getLength();
        int ctr = 0;
        while (ctr < detailListLength) {
            currDetail = detailList.item(ctr);
            currDomId = currDetail.getAttributes().getNamedItem("domID").getNodeValue();
            if (currDomId.equals(domId)) {
                reqDetail = currDetail;
                break;
            }
            ++ctr;
        }
        return reqDetail;
    }

    private String getCurrentUpdateFlag(Node currDetail) {
        NodeList currDetailList = null;
        String updateStatus = "";
        String nodeName = "";
        int currDetailListLength = 0;
        currDetailList = currDetail.getChildNodes();
        currDetailListLength = currDetailList.getLength();
        int i = 0;
        while (i < currDetailListLength) {
            nodeName = currDetailList.item(i).getNodeName();
            if (nodeName.equalsIgnoreCase("Attribute")) {
                updateStatus = currDetailList.item(i).getAttributes().getNamedItem("updateFlag").getNodeValue();
                break;
            }
            ++i;
        }
        return updateStatus;
    }
}

