/**
* PURPOSE : Validation and Item Change implementation for Expiry Stock Transfer .
* AUTHOR  : Rohan
* Date    : 30/05/12
* 
*/

package ibase.webitm.ejb.wms;

import java.io.*;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.*;
import java.util.*;
import java.util.Date;

import javax.ejb.*;
import javax.naming.InitialContext;
import javax.xml.parsers.*;
import org.w3c.dom.*;

import ibase.ejb.*;
import ibase.system.config.*;
import ibase.utility.BaseLogger;
import ibase.webitm.ejb.*;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerConfigurationException;
import org.xml.sax.InputSource;
import java.net.InetAddress;

@javax.ejb.Stateless
public class ExpStockTransferIC extends ValidatorEJB implements ExpStockTransferICRemote, ExpStockTransferICLocal  
{
	//Changed by rohan 
	//ArrayList<String> suggestedList = new ArrayList<String>();
	
	//System.out.println("");
	// Validation Code. Start	
	/**
	* The method is defined without any parameter and returns blank string
	*/
	public String wfValData() throws RemoteException,ITMException
	{
		return "";
	}
	
	/**
	* The public method is used for converting the current form data into a document(DOM)
	* The currDom is then given as argument to the overloaded function wfValData to perform validation
	* Returns validation string if exists else returns null in XML format
	* @param currFrmXmlStr contains the current form data in XML format
	* @param hdrFrmXmlStr contains all the header information in the XML format
	* @param allFrmXmlStr contains the data of all the forms in XML format
	* @param objContext represents the form number
	* @param editFlag represents the mode of transaction(A-Add or E-Edit)
	* @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	*/	
	public String wfValData(String currFrmXmlStr, String hdrFrmXmlStr,String allFrmXmlStr, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document currDom = null;
		Document hdrDom = null;
		Document allDom = null;
		String errString = "";
		
		try
		{
			System.out.println("wfValdata calling*******************");
			System.out.println("currFrmXmlStr ::"+currFrmXmlStr);
			System.out.println("hdrFrmXmlStr ::"+hdrFrmXmlStr);
			System.out.println("allFrmXmlStr ::"+allFrmXmlStr);
			if(currFrmXmlStr != null && currFrmXmlStr.trim().length()!=0)
			{
				currDom = parseString(currFrmXmlStr); 
			}
			if(hdrFrmXmlStr != null && hdrFrmXmlStr.trim().length()!=0)
			{
				hdrDom = parseString(hdrFrmXmlStr); 
			}
			if(allFrmXmlStr != null && allFrmXmlStr.trim().length()!=0)
			{
				allDom = parseString(allFrmXmlStr);
			}
			errString = wfValData(currDom,hdrDom,allDom,objContext,editFlag,xtraParams);
		}//end of try
		catch(Exception e)
		{
			System.out.println("Exception : [StockTransferGrlIC][wfValData(String currFrmXmlStr)] : ==>\n"+e.getMessage());
		}
		return (errString); 
	}

	/**
	 * The public overloaded method takes a document as input and is used for the validation of specified fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currDom contains the current form data as a document object model
	 * @param hdrDom contains all the header information
	 * @param allDom contains the field data of all the forms 
	 * @param objContext represents form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */	
	 public String wfValData(Document currDom, Document hdrDom, Document allDom, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException 	
	 {
		
		String errString = "";
		String columnValue = "";
		String sql = "";
		//Changed by Rohan on 20/06/12.start
		String stockSql = "";
		String suggLocCode = "";
		String sqlloc = "";
		String stockTransfer = "";
		String LocCodeRef = "";
		String LocCdRef = "";
		String sqlExp = "";
		String invStat= "";
		String nearExpLock = "";
		String lckCode = "";
		String lotNo = "";
		String lotSl = "";
		String sqlLock ="";
		String  stockTransferSql = "";
		String locCodeCurr = "";
		//Changed by Rohan on 20/06/12.end
		String refSer = "";
		String siteCode = "";
		//changed by sankara on 07/jun/14 for period stat
		java.util.Date tranDate = null;
		String prdCode = "";
		String childNodeName = "";
		String nearExpLoc = "";
		String expLoc = "";
		String lpnNo = "";
		String locCode = "";
		//String locationCode ="";
        //String expLock = "";
       // String nearExLoc = "";
		int noOfChilds = 0;
		int noOfParent = 0;
		int count = 0;
		int stockCnt = 0;
		
		int listCount = 0;
		HashMap<String, Integer> suggMap = null;
        //Changed by Rohan on 20/06/12.start
		int locListSize = 0;
		double quantity = 0d;
		ResultSet rs = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		PreparedStatement pstmtLoc = null;
		ResultSet rsLoc = null;
		//Changed by sumit on 17/09/12 commented not required now start
		//PreparedStatement pstmtLock = null;
		//PreparedStatement pstmtTransfer = null;
		//ResultSet rsLock = null;
		//ResultSet rsTransfer = null;
		//boolean duplicate = false;
		//Changed by sumit on 17/09/12 commented not required now end
		//ArrayList<String> suggestedList = new ArrayList<String>();
		//HashMap<String, Integer> suggMap = new HashMap<String, Integer>();
		//HashMap<String><String> suggMap = new HashMap<String><String>();
		//HashMap<String, Integer> suggMap = new HashMap<String, Integer>();
		//Changed by Rohan on 20/06/12.end
		//Changed by sumit on 17/09/12 commented not required now start
		//PreparedStatement pstmtStock = null;
		//ResultSet rsStock = null;
		//ResultSet rsExp = null;
		//PreparedStatement pstmtExp = null;
		//int ExplocListSize = 0;		
		//ArrayList<String> sugstLocList = null;
		
		//Changed by Rohan on 20/06/12.start
		//boolean flag = false;
		//boolean flg = false;
		//ArrayList<String> suggestedList = new ArrayList<String>();
		//Document dom = null;
		//Changed by sumit on 17/09/12 commented not required now END
		//Changed by Rohan on 20/06/12.end
        GenericUtility genericUtility = GenericUtility.getInstance();
        //Changed By Pragyan 11-AUG-14 To check and Facility Master implementation.start
        ibase.webitm.utility.wms.CommonWmsUtil commonWmsUtility =ibase.webitm.utility.wms.CommonWmsUtil.getInstance();

		DistCommon distCommon = new DistCommon();
		int currentFormNo = 0, cnt = 0;		
		Node childNode =null;
        String userId = "";
		NodeList parentList = null;
		NodeList childList = null;	
		String resrvLocInvstat = "";

		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
		String errorType = "", errCode = "";
		ArrayList errList = new ArrayList();
		ArrayList errFields = new ArrayList();
		
		//Changed by sumit on 27/06/12 start.
		String suggestedInvCode = "",taskCode = "", itemCode = ""; 
		StringTokenizer st2 = null;
		List inv = new ArrayList();
		int checkInt = 0;
		
		//Changed by sumit on 08/09/12 
		String lockType = "";
		String suggestedLockType ="";
		String nexprInvstat = "";
		String exprInvstat = "";
		String locType = "";	
		String errStr = "";
		
		try
		{
			
			
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;
			//changed by sankara on 07/jun/14 for period stat
			SimpleDateFormat sdf1 = new SimpleDateFormat(genericUtility.getApplDateFormat());
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			if ( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
				
			}
			
			parentList = currDom.getElementsByTagName( "Detail" + currentFormNo );
			System.out.println("@@@@@@ parentList ["+parentList.getLength()+"]");
			childList = null;	
			noOfParent = parentList.getLength();

			switch(currentFormNo)
			{
				
			    //Changed by sumit on 08/09/12 adding case 1 start( as per new requirment ) satrt.
				case 1 :
				{
					childList = parentList.item(0).getChildNodes();
					noOfChilds = childList.getLength();

					for ( int ctr = 0; ctr < noOfChilds; ctr++ ) //Loop for each node of current detail
					{	
						childNode = childList.item( ctr );
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						System.out.println(" ******** columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
						
						if ( "lock_type".equalsIgnoreCase( childNodeName ) )
						{
							if ( childNode.getFirstChild() == null )
							{
								errList.add( "NULLLOCKTP" );
								errFields.add( childNodeName.toLowerCase() );
							}
							else
							{
								suggestedLockType = genericUtility.getColumnValue("sys_lock_type", currDom);
								lockType = genericUtility.getColumnValue( "lock_type", currDom );
								System.out.println("suggestedLockType ==>["+suggestedLockType+"] lockType==>["+lockType+"]");							
								
								st2 = new StringTokenizer(suggestedLockType, ",");
								
								inv.clear();
								while (st2.hasMoreElements()) 
								{
									inv.add(st2.nextElement().toString().trim());
								}
								System.out.println("inv "+inv);
								if(!inv.contains(lockType))
								{
									errList.add( "INVLOCKTP" );
									errFields.add( childNodeName.toLowerCase() );
								}
								
							}
							
						}
					}
				}
				break;
				//Changed by sumit on 08/09/12 adding case 1 start( as per new requirment ) end.
				//Changed by sumit on 08/09/12 changed case number
				//case 1 :
				case 2 :
				{
					childList = parentList.item( 0 ).getChildNodes();
					noOfChilds = childList.getLength();
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{	
						childNode = childList.item( ctr );
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();						
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
						if ( "tran_date".equalsIgnoreCase( childNodeName ) )
						{
							if ( childNode.getFirstChild() == null )
							{
								errList.add( "NULLTRANDT" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
						else if ( "ref_ser".equalsIgnoreCase( childNodeName ) )
						{
							if ( childNode.getFirstChild() == null )
							{
								errList.add( "NULLREFSER" );
								errFields.add( childNodeName.toLowerCase() );
							}
							refSer = genericUtility.getColumnValue( "ref_ser", currDom );
							
							sql = "SELECT COUNT(*) AS COUNT FROM REFSER WHERE REF_SER = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, refSer);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt("COUNT");
							}							
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						
							if(cnt == 0)
							{
								errList.add( "VTREFSER1" );
								errFields.add( childNodeName.toLowerCase() );
							}						
						}
						else if ( "site_code".equalsIgnoreCase( childNodeName ) )
						{							
							if ( childNode.getFirstChild() == null )
							{
								errList.add( "NULLSITE" );
								errFields.add( childNodeName.toLowerCase() );
							}
							siteCode = genericUtility.getColumnValue( "site_code", currDom );
							
							sql = "SELECT COUNT(*) AS COUNT FROM SITE WHERE SITE_CODE = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, siteCode);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt("COUNT");
							}							
							rs.close();
							rs = null;							
							pstmt.close();
							pstmt = null;
							
							if(cnt == 0)
							{
								errList.add( "INVSITECD" );
								errFields.add( childNodeName.toLowerCase() );
							}
							else 
							{
															
								System.out.println("364 site code ="+siteCode);
								if (genericUtility.getColumnValue("tran_date", currDom) != null)
								{
									tranDate = sdf1.parse(genericUtility.getColumnValue("tran_date", currDom));
									sql = "select code from period where ?  between fr_date and to_date";
									pstmt = conn.prepareStatement(sql);
									pstmt.setDate(1, new java.sql.Date(tranDate.getTime()));
									rs = pstmt.executeQuery();
									if (rs.next())
									{
										prdCode = rs.getString(1);

									}
									rs.close();
									rs = null;
									pstmt.close();
									pstmt = null;

									sql = "select count(*) from period_stat where site_code = ? and prd_code = ? ";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, siteCode);
									pstmt.setString(2, prdCode);
									rs = pstmt.executeQuery();
									if (rs.next())
									{
										count = rs.getInt(1);

									}
									rs.close();
									rs = null;
									pstmt.close();
									pstmt = null;
									if (count == 0)
									{
										errList.add( "VTSITEPD" );
										errFields.add( childNodeName.toLowerCase() );
										break;
									}
									// nvo_functions_adv.nf_check_period('SAL',mdate1,msite_code)
									errCode = nfCheckPeriod("IC", tranDate, siteCode);
									System.out.println("425 Error Code = " + errCode);
									if (errCode != null && errCode.trim().length() > 0)
									{
										errList.add(errCode);
										errFields.add( childNodeName.toLowerCase() );
									}
								} 							 
							}//end 
							//Changed by Pragyan.End
						}
						else if ( "reas_code".equalsIgnoreCase( childNodeName ) )
						{
							if ( childNode.getFirstChild() == null )
							{
								errList.add( "NULLREASON" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
						//Changed by sumit sarkar on 27/06/12 task_code validation start.
						else if ( "task_code".equalsIgnoreCase( childNodeName ) )
						{
							if ( childNode.getFirstChild() == null )
							{
								errList.add( "NULLTASKCD" );
								errFields.add( childNodeName.toLowerCase() );
							}
							else
							{
								suggestedInvCode = genericUtility.getColumnValue("suggested_task_code", currDom);
								taskCode = genericUtility.getColumnValue("task_code", currDom);
								System.out.println("suggestedInvCode ==>["+suggestedInvCode+"] taskCode==>["+taskCode+"]");							
								
								st2 = new StringTokenizer(suggestedInvCode, ",");
								
								inv.clear();
								while (st2.hasMoreElements()) 
								{
									inv.add(st2.nextElement().toString().trim());
								}
								System.out.println("inv "+inv);
								if(!inv.contains(taskCode))
								{
									errList.add( "INVTASKCD" );
									errFields.add( childNodeName.toLowerCase() );
								}
							}
						}
						//Changed by sumit sarkar on 27/06/12 task_code validation end.
					}// for loop end
				}//case 1 end
				break;
				//Changed by Rohan 0n 20/06/12 [WM1FSUN006] To add Validation on form 2.start
				//Changed by sumit on 08/09/12 changed case number
				//case 2 :
				case 3:
				{
					
					siteCode = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));
					
					//Changed by sumit on 13/09/12 not needed now start and getting loc from disparam start.
					//ArrayList<String> sugstLocList = new ArrayList<String>();					
					//ArrayList<String> sugstExpLocList = new ArrayList<String>();					
					nexprInvstat = checkNull(distCommon.getDisparams("999999","NEXPR_INVSTAT",conn));
					exprInvstat = checkNull(distCommon.getDisparams("999999","EXPR_INVSTAT",conn));
					nearExpLoc = distCommon.getDisparams("999999","NEAREXP_LOC",conn);
					expLoc = distCommon.getDisparams("999999","EXP_LOC",conn);				  				  		
					System.out.println(" nexprInvstat in wfValData ["+nexprInvstat+"] exprInvstat ["+exprInvstat+"] taskCode ->["+taskCode+"] locType ->["+locType+"] nearExpLoc(NEAREXP_LOC) ["+nearExpLoc+"] expLoc(EXP_LOC) ["+expLoc+"]");
					//Changed by sumit on 13/09/12 not needed now start and getting loc from disparam end.
					
					childList = parentList.item( 0 ).getChildNodes();
					noOfChilds = childList.getLength();
					
					//Changed by Rohan on 24/06/12 as said by manoharan.start
					NodeList parentNodeList = null;
					NodeList chldList = null;
					int parentNodeListLength ;
					
					//Changed by sumit on 10/09/12 changin detail number
					//parentNodeList = allDom.getElementsByTagName("Detail2");
					parentNodeList = allDom.getElementsByTagName("Detail3");
					parentNodeListLength = parentNodeList.getLength();
					System.out.println("parentNodeListLength====******************===>"+parentNodeListLength);
					//Changed by sumit on 05/09/12 not required.
					/*String attribute = attributeValue(allDom);
					System.out.println(" ssssssssssssss "+attribute);*/
					//Changed by sumit on 17/09/12 commented as duplicate checking in checkDuplicate method start.
					/*for(int row = 0; row < parentNodeListLength; row++)
					{
						//Changed by sumit on 10/09/12 changin detail number
						//locationCode = checkNull(GenericUtility.getInstance().getColumnValueFromNode("loc_code__to", allDom.getElementsByTagName("Detail2").item(row)));
						locationCode = checkNull(GenericUtility.getInstance().getColumnValueFromNode("loc_code__to", allDom.getElementsByTagName("Detail3").item(row)));
						System.out.println("Adding to LIst"+locationCode+"[Row"+row);
						suggestedList.add(locationCode);	
					}*/
					//Changed by sumit on 17/09/12 commented as duplicate checking in checkDuplicate method end.
					
//					//Changed by Rohan on 24/06/12 as said by manoharan.end
					//Changed by sumit on 13/09/12 to check duplicate loc_code__to
					//Set setList = new HashSet(suggestedList);				
					
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{	
						childNode = childList.item( ctr );
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();						
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
						
						//Changed by sumit sarkar on 16/07/12 validating for null detail start.
						//Chnaged by sumit on 05/09/12 not required start.
						/*attribute = attributeValue(allDom);
						if( "N".equalsIgnoreCase(attribute ))
						{
							
							errList.add( "NULLDETAIL" );
							errFields.add( "" );
							break;							
						}*/
						//Chnaged by sumit on 05/09/12 not required end.
						//Changed by sumit sarkar on 16/07/12 validating for null detail end.
						if ( "loc_code__fr".equalsIgnoreCase( childNodeName ) )
						{
							locCode = checkNull(genericUtility.getColumnValue( "loc_code__fr", currDom ));
							
							if ( locCode.equalsIgnoreCase(""))
							{
								errList.add( "NULLDETAIL" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
	
						if ( "lot_sl__fr".equalsIgnoreCase( childNodeName ) )
						{
							
							lpnNo = checkNull(genericUtility.getColumnValue( "lot_sl__fr", currDom ));
							
							if ( lpnNo.equalsIgnoreCase(""))
							{
								errList.add( "NULLLPNNO" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}						
						else if ( "loc_code__to".equalsIgnoreCase( childNodeName ) )
						{          
							
							//System.out.println("@@@@@ loc_code__to validation executed.........");
							String singleLotSl="",itemLotOpt="";
							locCode = "";
							lotNo = checkNull(genericUtility.getColumnValue( "lot_no__fr", currDom ));
							lotSl = checkNull(genericUtility.getColumnValue( "lot_sl__fr", currDom ));
							itemCode = checkNull(genericUtility.getColumnValue( "item_code", currDom ));
							locCode = checkNull(genericUtility.getColumnValue( "loc_code__fr", currDom ));
							locCodeCurr = checkNull(genericUtility.getColumnValue( "loc_code__to", currDom ));
							nearExpLoc = distCommon.getDisparams("999999","NEAREXP_LOC",conn);
							expLoc = distCommon.getDisparams("999999","EXP_LOC",conn);
							//taskCode = genericUtility.getColumnValue("task_code",allDom);
					  		locType = genericUtility.getColumnValue("lock_type",hdrDom);
					  		System.out.println("locCodeCurr---->"+locCodeCurr+" locType ["+locType+"] exprInvstat ["+exprInvstat+"]  nexprInvstat ["+nexprInvstat+"]");
							//Changed by sumit on 05/09/12 wrong condition.
							//if(locCodeCurr == null || locCodeCurr.trim().length() > 0 )
							if(locCodeCurr == null || locCodeCurr.trim().length() == 0 )
							{
								errList.add( "NULLLOCCD" );
								errFields.add( childNodeName.toLowerCase() );
							}
							else 
							{
								//Changed By Pragyan 11-AUG-14 To check and Facility Master implementation.start
								if(!commonWmsUtility.isValFacLocation(locCodeCurr, siteCode, conn))
								{
									errList.add( "VMFACI2" ); // 'Diffrent Loc Code from location and site' (set same error Code @base)
									errFields.add( childNodeName.toLowerCase() );
									break;
								}
								//Changed By Pragyan 11-AUG-14 To check and Facility Master implementation.end	
								//Changed By Pragyan as per AShish 27-sep-13 to allow all location to transfer
								/*sql = "SELECT A.LOC_CODE AS LOC_CODE FROM LOCATION A, INVSTAT B "
										+ " WHERE A.INV_STAT = B.INV_STAT AND B.AVAILABLE = 'Y' "
										+ " AND (CASE WHEN B.STAT_TYPE IS NULL THEN ' ' ELSE B.STAT_TYPE END) <> 'S' "
										+ " AND A.INV_STAT = ? AND LOC_CODE = ? ";*/
								sql = "SELECT A.LOC_CODE AS LOC_CODE FROM LOCATION A, INVSTAT B "
									+ " WHERE A.INV_STAT = B.INV_STAT AND B.AVAILABLE = 'Y' "
									+ " AND (CASE WHEN B.STAT_TYPE IS NULL THEN ' ' ELSE B.STAT_TYPE END) <> 'S' "
								//	+ " AND A.INV_STAT = ? AND LOC_CODE = ? ";
									+ " AND LOC_CODE = ? ";
								
								pstmtLoc = conn.prepareStatement(sql);
								//Changed By Pragyan as per AShish 27-sep-13 to allow all location to transfer.start
								/*if( "EXP_LOCK".equalsIgnoreCase(locType))
								{
									pstmtLoc.setString(1, exprInvstat);
								}
								else if ("NEXP_LOCK".equalsIgnoreCase(locType))
								{
									pstmtLoc.setString(1, nexprInvstat);
								}
								pstmtLoc.setString(2, locCodeCurr);*/
								pstmtLoc.setString(1, locCodeCurr);
								rsLoc = pstmtLoc.executeQuery();
								
								if( rsLoc.next())
								{
														
									sql = "SELECT SINGLE_LOT_SL, ITEM_LOT_OPT FROM LOCATION WHERE LOC_CODE = ? ";
									pstmt = conn.prepareStatement( sql );
									pstmt.setString( 1, locCodeCurr );
									
									//pstmt.setString( 3, nexprInvstat );
																		
									//Changed by sumit on 13/09/12 adding inv state
									rs = pstmt.executeQuery();
									if( rs.next() )
									{
										singleLotSl = checkNull(rs.getString("SINGLE_LOT_SL"));
										itemLotOpt = checkNull(rs.getString("ITEM_LOT_OPT"));
									}
									else
									{
										errList.add( "INVLOCCODE" );
										errFields.add( childNodeName.toLowerCase() );
									}
									rs.close();
									rs = null;
									pstmt.close();
									pstmt = null;
									
									if("Y".equalsIgnoreCase(singleLotSl))
									{
										//sql = "SELECT QUANTITY FROM STOCK WHERE SITE_CODE = ?  AND LOC_CODE = ? ";
										sql = "SELECT SUM(QUANTITY) AS QUANTITY FROM STOCK WHERE SITE_CODE = ?  AND LOC_CODE = ? ";
										pstmt = conn.prepareStatement( sql );
										pstmt.setString( 1, siteCode );
										pstmt.setString( 2, locCodeCurr );										
										rs = pstmt.executeQuery();	
										if( rs.next() )
										{
											quantity = rs.getDouble("QUANTITY");
										}
										rs.close();
										rs = null;
										pstmt.close();
										pstmt = null;
										
										if( quantity != 0 )
										{
											errList.add( "VTLOCCODE1" );
											errFields.add( childNodeName.toLowerCase() );
										}
										
										//Changed by sumit on 17/09/12 commented this checking duplicate inside suggested method start.
										String locCodeExist = "";
										NodeList locCodeNodeList = null;
										ArrayList dupLocCodeList = new ArrayList();

										int noOfLocCode = 0;
										int listLen = 0;
										int recCnt = 0;
										int locCodeCntDb = 0;

										locCodeNodeList = currDom.getElementsByTagName("loc_code__to");
										noOfLocCode = locCodeNodeList.getLength();
										
										for( int idx = 0; idx < noOfLocCode; idx++ )
										{
											if ( locCodeNodeList.item( idx ).getFirstChild() != null )
											{
												dupLocCodeList.add((String)( locCodeNodeList.item( idx ).getFirstChild() ).getNodeValue());
											}
										}
										listLen = dupLocCodeList.size();
										if ( listLen > 0 )
										{
											recCnt = 1;
											for( int i = 0; i < listLen - 1; i++ )
											{
												for ( int j = i+1; j < listLen; j++ )
												{
													if ( ((String)dupLocCodeList.get(i)).equalsIgnoreCase((String)dupLocCodeList.get(j)) )
													{
														recCnt++;
														break;
													}
												}
												if( recCnt > 1 )
												{
													break;
												}
											}
										}
										System.out.println("recCnt = ["+recCnt+"]");
			
										if( recCnt > 1 )
										{
											errList.add( "DUPLOCCODE" );
											errFields.add( childNodeName.toLowerCase() );
										}
										//Changed by sumit on 17/09/12 commented this checking duplicate inside suggested method end.
									}
									else
									{
										if( itemLotOpt.trim().equals("0") )  
										{
											//sql = "SELECT COUNT(*) AS COUNT FROM STOCK WHERE ITEM_CODE <> ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO <> ?";
											sql = "SELECT COUNT(*) AS COUNT FROM STOCK WHERE (ITEM_CODE <> ? OR LOT_NO <> ?) AND SITE_CODE = ? AND LOC_CODE = ? AND QUANTITY > 0";
											pstmt = conn.prepareStatement( sql );
											pstmt.setString( 1, itemCode );
											pstmt.setString( 2, lotNo );
											pstmt.setString( 3, siteCode );
											pstmt.setString( 4, locCodeCurr );
											//pstmt.setString( 4, lotNo );
											rs = pstmt.executeQuery();
											if( rs.next() )
											{
												count = rs.getInt("COUNT");
											}
											rs.close();
											rs = null;
											pstmt.close();
											pstmt = null;

											if( count > 0 )
											{
												errList.add( "VTLOCCODE2" );
												errFields.add( childNodeName.toLowerCase() );
											}
										}//itemLotOpt = 0
										else if( itemLotOpt.trim().equals("1") )  //Validation for single item_code multiple lot_no
										{
											//Chnaged by sumit on 14/09/12 as per all logic 
											//sql = "SELECT COUNT(*) AS COUNT FROM STOCK WHERE  ITEM_CODE <> ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO = ? ";
											sql = "SELECT COUNT(*) AS COUNT FROM STOCK WHERE  ITEM_CODE <> ? AND SITE_CODE = ? AND LOC_CODE = ? AND QUANTITY > 0";
											pstmt = conn.prepareStatement( sql );
											pstmt.setString( 1, itemCode );
											pstmt.setString( 2, siteCode );
											pstmt.setString( 3, locCodeCurr );
											//pstmt.setString( 4, lotNo );
											rs = pstmt.executeQuery();
											if( rs.next() )
											{
												count = rs.getInt("COUNT");
											}
											rs.close();
											rs = null;
											pstmt.close();
											pstmt = null;
											if( count > 0 )
											{
												errList.add( "VTLOCCODE4" );
												errFields.add( childNodeName.toLowerCase() );
											}	
										}//itemLotOpt = 1 
										
									}
									
									//Changed by sumit on 17/09/12 validating duplicate loc_code__to start.
									errStr = checkDuplicate (allDom , locCodeCurr, singleLotSl, itemLotOpt );								
									if( errStr.trim().length() > 0 )
									{									
										errList.add( errStr );
										errFields.add( childNodeName.toLowerCase() );
									}
									//Changed by sumit on 17/09/12 validating duplicate loc_code__to end.
								}
								else
								{
									errList.add( "INVLOCSTAT" );
									errFields.add( childNodeName.toLowerCase() );
								}
								if( pstmtLoc != null)
								{
									pstmtLoc.close();
									pstmtLoc = null;
								}
								if(rsLoc != null)
								{
									rsLoc.close();
									rsLoc = null;
								}
								
								
									
								
								
							  //end
								//Changed by sumit on 13/09/12 checking duplicate loc_code__to start.
								/*
								nearExpLoc = distCommon.getDisparams("999999","NEAREXP_LOC",conn);
								expLoc = distCommon.getDisparams("999999","EXP_LOC",conn);
								stockTransfer = distCommon.getDisparams("999999","EXP_STOCK_TRANSFER",conn);
								
								if(stockTransfer.equalsIgnoreCase("N"))
								{
									LocCodeRef = nearExpLoc;
								}
								else if(stockTransfer.equalsIgnoreCase("E"))
								{
									LocCodeRef = expLoc;
								}
								else if(stockTransfer.equalsIgnoreCase("A"))
								{
									LocCodeRef = nearExpLoc;
									LocCdRef = expLoc;
								}
								
								if(stockTransfer.equalsIgnoreCase("A"))
								{
									
									nearExpLock  = distCommon.getDisparams("999999","NEAR_EXP_LOCK",conn);
									expLock = distCommon.getDisparams("999999","EXP_LOCK",conn);
									nearExLoc = distCommon.getDisparams("999999","NEAREXP_LOC",conn);
									
									sqlLock = "SELECT I.LOCK_CODE FROM INV_HOLD I,INV_HOLD_DET D "
										      +" WHERE I.TRAN_ID = D.TRAN_ID AND D.LOT_NO = ? AND D.LOT_SL = ? "
										      +" AND D.HOLD_STATUS = ?"
										      //Changed by sumit sarkar on 06/07/12 giving item_code condition
										      +" AND D.ITEM_CODE = ? AND D.LOC_CODE = ? ";
									
									pstmtLock =  conn.prepareStatement(sqlLock);
									pstmtLock.setString(1, lotNo);
									pstmtLock.setString(2, lotSl);
									pstmtLock.setString(3, "H");
									//Changed by sumit sarkar on 06/07/12 START.
									pstmtLock.setString(4, itemCode);
									pstmtLock.setString(5, locCode);
									//Changed by sumit sarkar on 06/07/12 END.
									rsLock = pstmtLock.executeQuery();
									if(rsLock.next())
									{
										lckCode =checkNull(rsLock.getString("LOCK_CODE"));
									}
									rsLock.close();
									pstmtLock.close();
									
									if(!lckCode.trim().equalsIgnoreCase(nearExpLock))
									{	
										sqlloc = "SELECT INV_STAT FROM LOCATION WHERE LOC_CODE = ?";
										pstmtLoc =  conn.prepareStatement(sqlloc);
										pstmtLoc.setString(1, columnValue);
										rsLoc = pstmtLoc.executeQuery();
										if(rsLoc.next())
										{
											invStat =checkNull(rsLoc.getString("INV_STAT"));
										}
										
										pstmtLoc.close();
										rsLoc.close();
										if(invStat.equalsIgnoreCase(""))
										{
											System.out.println(" <> invstat");
											errList.add( "EXPNTVAL" );
											errFields.add( childNodeName.toLowerCase() );	
										}
										else if(invStat.trim().equalsIgnoreCase(expLoc.trim()))
										{		
											sqlExp = "SELECT A.LOC_CODE AS LOC_CODE FROM LOCATION A, INVSTAT B "
												+ " WHERE A.INV_STAT = B.INV_STAT AND B.AVAILABLE = 'Y' "
												+ " AND (CASE WHEN B.STAT_TYPE IS NULL THEN ' ' ELSE B.STAT_TYPE END) <> 'S' "
												+ " AND A.INV_STAT = ? ORDER BY LOC_CODE ";
											pstmtExp =  conn.prepareStatement(sqlExp);
											pstmtExp.setString(1, LocCdRef);
											
											double stockQty = 0d;
											
											stockSql = "SELECT SUM(CASE WHEN QUANTITY IS NULL THEN 0 ELSE QUANTITY END) AS STOCK_QTY "
													+  " FROM STOCK WHERE LOC_CODE = ? ";
											//Changed by Rohan to Solve Bug
											//pstmtStock =  conn.prepareStatement(stockSql);
											rsExp = pstmtExp.executeQuery();
											while (rsExp.next())
											{
												suggLocCode = checkNull(rsExp.getString("LOC_CODE") );
												System.out.println("Adding location check=$$$$$===>"+suggLocCode);
												stockTransferSql = " SELECT COUNT(*) AS CNT FROM STOCK_TRANSFER H,STOCK_TRANSFER_DET D"
												          + " Where H.TRAN_ID = D.TRAN_ID"
												          + " AND H.SITE_CODE = ? "
														  + " AND LOC_CODE__TO = ? ";
												//pstmtTransfer =  conn.prepareStatement(stockTransferSql);
												//pstmtTransfer.setString(1, siteCode);
												//pstmtTransfer.setString(2, suggLocCode);
												//rsTransfer= pstmtTransfer.executeQuery();
												
												if(rsTransfer.next())
												{
													stockCnt = rsTransfer.getInt("CNT");
												}
												
												if( stockCnt == 0 )
												{
												
													pstmtStock =  conn.prepareStatement(stockSql);
													pstmtStock.setString( 1, suggLocCode );
													rsStock = pstmtStock.executeQuery();
													if ( rsStock.next() )
													{
														stockQty = rsStock.getDouble("STOCK_QTY");
														if ( stockQty == 0 )
														{
															sugstExpLocList.add(suggLocCode);
														}
													}
													else
													{
														sugstExpLocList.add(suggLocCode);
													}
												//}
												//pstmtStock.clearParameters();
												if(rsStock != null)
												{	
													rsStock.close(); 
													rsStock = null;
												}
												if(pstmtStock != null)
												{
													pstmtStock.close();
													pstmtStock = null;
												}
												if(pstmtTransfer != null)
												{
													pstmtTransfer.close();
													pstmtTransfer = null;
												}
												if(rsTransfer != null)
												{	
													rsTransfer.close(); 
													rsTransfer = null;
												}
											}//While close
											rsExp.close(); 
											rsExp = null;						
											pstmtExp.close(); 
											pstmtExp = null;
											if(pstmtStock != null)
											{	
												pstmtStock.close(); 
												pstmtStock = null;
											}	
											
											ExplocListSize = sugstExpLocList.size();
											
											for(int i=0;i<ExplocListSize;i++)
											{
												if(columnValue.trim().equalsIgnoreCase(sugstExpLocList.get(i).trim()))
												{
													flg = true;
													break;
												}
											}
											if(!flg)
											{
												System.out.println(" !flg ");
												//Changed by sumit sarkar on 05/07/12  
												//errList.add( "EXPNTVAL" );
												errList.add( "EXPLOCAUSE" );
												errFields.add( childNodeName.toLowerCase() );
											}
										}
										
										else if(lckCode.trim().equalsIgnoreCase(expLock.trim()) && invStat.trim().equalsIgnoreCase(nearExLoc.trim()))
										{
											System.out.println(" lckCode && invStat ");
											errList.add( "EXPNTVAL" );
											errFields.add( childNodeName.toLowerCase() );
										}
									}
								}							
							
								sql = "SELECT A.LOC_CODE AS LOC_CODE FROM LOCATION A, INVSTAT B "
										+ " WHERE A.INV_STAT = B.INV_STAT AND B.AVAILABLE = 'Y' "
										+ " AND (CASE WHEN B.STAT_TYPE IS NULL THEN ' ' ELSE B.STAT_TYPE END) <> 'S' "
										+ " AND A.INV_STAT = ? ORDER BY LOC_CODE ";
									pstmt =  conn.prepareStatement(sql);
									pstmt.setString(1, LocCodeRef);
									   							
									double stockQty = 0d;
									
									stockSql = "SELECT SUM(CASE WHEN QUANTITY IS NULL THEN 0 ELSE QUANTITY END) AS STOCK_QTY "
											+  " FROM STOCK WHERE LOC_CODE = ? ";
									
									rs = pstmt.executeQuery();
									
									while (rs.next())
									{
										suggLocCode = checkNull(rs.getString("LOC_CODE") );				
										
										stockTransferSql = " SELECT COUNT(*) AS CNT FROM STOCK_TRANSFER H,STOCK_TRANSFER_DET D"
										          + " Where H.TRAN_ID = D.TRAN_ID"
										          + " AND H.SITE_CODE = ? "
												  + " AND LOC_CODE__TO = ? ";
										pstmtTransfer =  conn.prepareStatement(stockTransferSql);
										pstmtTransfer.setString(1, siteCode);
										pstmtTransfer.setString(2, suggLocCode);
										rsTransfer= pstmtTransfer.executeQuery();
										
										if(rsTransfer.next())
										{
											stockCnt = rsTransfer.getInt("CNT");
										}
										
										if( stockCnt == 0 )
										{							
											if(rsStock != null)
											{	
												rsStock.close(); 
												rsStock = null;
											}
											if(pstmtStock != null)
											{
												pstmtStock.close();
												pstmtStock = null;
											}
											pstmtStock =  conn.prepareStatement(stockSql);
											pstmtStock.setString( 1, suggLocCode );
											rsStock = pstmtStock.executeQuery();
											if ( rsStock.next() )
											{
												System.out.println("Enter in result****************......");
												stockQty = rsStock.getDouble("STOCK_QTY");
												if ( stockQty == 0 )
												{
													System.out.println("ADDING---->"+suggLocCode);
													sugstLocList.add(suggLocCode);
												}
											}
											else
											{ 
												System.out.println("ADDING--******-->"+suggLocCode);
												sugstLocList.add(suggLocCode);
											}
										//}	
										
										if(pstmtTransfer != null)
										{
											pstmtTransfer.close();
											pstmtTransfer = null;
										}
										if(rsTransfer != null)
										{	
											rsTransfer.close(); 
											rsTransfer = null;
										}
									}
									rs.close(); 
									rs = null;						
									pstmt.close(); 
									pstmt = null;
									if(pstmtStock != null)
									{
										pstmtStock.close();
										pstmtStock = null;
									}
									
									locListSize = sugstLocList.size();
									for(int i=0;i<locListSize;i++)
									{
										System.out.println("Comparing====******"+columnValue+" AND "+sugstLocList.get(i));
										if(columnValue.trim().equalsIgnoreCase(sugstLocList.get(i).trim()))
										{
											flag = true;
											break;
										}
									}
									if(!flag)
									{
										if(stockTransfer.trim().equalsIgnoreCase("A") && !(flg))
										{
											errList.add( "NEXPLOCAUS" );
											errFields.add( childNodeName.toLowerCase() );
										}
										if(stockTransfer.trim().equalsIgnoreCase("N"))
										{	
											System.out.println(" stockTransfer 'N' ");
											errList.add( "NEXPNTVAL" );
											errFields.add( childNodeName.toLowerCase() );
										}
										else if(stockTransfer.trim().equalsIgnoreCase("E"))
										{
											System.out.println(" stockTransfer 'E' ");
											errList.add( "EXPNTVAL" );
											errFields.add( childNodeName.toLowerCase() );
										}
									}
									*/
									
									//Changed by sumit on 13/09/12 commented end
								
							}
							//Changed by sumit on 13/09/12 checking duplicate loc_code__to start.
							/*if( setList.size() != suggestedList.size() )
							{
								System.out.println(" inside my code");
								errList.add( "DUPRECORD" );
								errFields.add( childNodeName.toLowerCase() );
							}*/
							//Changed by sumit on 13/09/12 checking duplicate loc_code__to end.
						
						}  //end of loc_code_to
						else if( "item_code".equalsIgnoreCase( childNodeName ))
						{
							lotNo = checkNull(genericUtility.getColumnValue( "lot_no__fr", currDom ));
							lotSl = checkNull(genericUtility.getColumnValue( "lot_sl__fr", currDom ));
							itemCode = checkNull(genericUtility.getColumnValue( "item_code", currDom ));
							locCode = checkNull(genericUtility.getColumnValue( "loc_code__fr", currDom ));
							System.out.println("siteCode ["+siteCode+"] lotNo ["+lotNo+"] lotSl ->["+lotSl+"] itemCode ->["+itemCode+"] locCode->["+locCode+"]");
							
							sql = "SELECT ALLOC_QTY FROM STOCK WHERE ITEM_CODE = ? " +
									" AND LOT_NO = ? " +
									" AND LOT_SL = ? " +
									" AND LOC_CODE = ? " +
									" AND SITE_CODE = ? " +
									" AND ALLOC_QTY > 0 ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, itemCode);
							pstmt.setString(2, lotNo);
							pstmt.setString(3, lotSl);
							pstmt.setString(4, locCode);
							pstmt.setString(5, siteCode);
							rs = pstmt.executeQuery();
							if( rs.next())
							{
								errList.add( "ALOCQTYPRE" );
								errFields.add( childNodeName.toLowerCase() );
							}			
							
						}//end of item_code
					
				    }//for loop end
					
				}	
				//Changed by Rohan 0n 20/06/12 [WM1FSUN006] To add Validation on form 2.end	
				
			} //switch end
			//changed by Rohan on 24/06/12 Not allowed muliple suggested location.start
			/*
			for(int i = 0;i < suggestedList.size() ;i++ )
			{
				System.out.println("Enter in compare");
				String suggestedLoc = suggestedList.get(i);
				for ( int j = i+1 ; j < suggestedList.size() ; j++)
				{  
					String suggestedLocCmp = suggestedList.get(j);
					
					System.out.println("Comparing Records"+suggestedLoc+"AND"+suggestedLocCmp);
					if(suggestedLoc.trim().equalsIgnoreCase(suggestedLocCmp.trim()))
					{
						duplicate = true;
						break;
					}
				}
			}
			if(duplicate)
			{
				errList.add( "DUPRECORD" );
				errFields.add( childNodeName.toLowerCase() );
				
			}
			*/
			//Change by sumit sarkar on 16/07/12 start.
			/*System.out.println(" before validating null detail @@@@ ");*/
			/*System.out.println(" countInt ["+checkInt+"]");
			if( checkInt == 0 )
			{
				System.out.println(" after validate inside 'if' ");
				errList.add( "NULLDETAIL" );
				errFields.add( childNodeName.toLowerCase() );
			}*/
			//Change by sumit sarkar on 16/07/12 end.
			
			/*int suggestedListLength = suggestedList.size();
			
			suggMap = new HashMap<String, Integer>();
			System.out.println("suggestedList====>"+suggestedList);
			for(int i= 0;i<suggestedListLength;i++ )
			{	
				System.out.println("HashAMap Values====>"+suggMap);
				if(suggMap.containsKey(suggestedList.get(i)))
				{
					errList.add( "DUPRECORD" );
					errFields.add( childNodeName.toLowerCase() );
					
				}
				else
				{
					suggMap.put(suggestedList.get(i),i);
				}
			}	*/
			//changed by Rohan on 24/06/12 Not allowed muliple suggested location.end
			int errListSize = errList.size();
			cnt =0;
			String errFldName = null;
			if ( errList != null && errListSize > 0 )
			{
				for (cnt = 0; cnt < errListSize; cnt++ )
				{
					errCode = (String)errList.get(cnt);
					errFldName = (String)errFields.get(cnt);
					System.out.println("errCode .........."+errCode);
					//String errMsg = hashMap.get(errCode)!=null ? hashMap.get(errCode).toString():"";
					//System.out.println("errMsg .........."+errMsg);
					errString = getErrorString( errFldName, errCode, userId );
					errorType =  errorType( conn , errCode );
					if ( errString.length() > 0)
					{
						String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8,errString.indexOf("<trace>"));
						bifurErrString =bifurErrString;//+"<trace>"+errMsg+"</trace>";
						bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8,errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						System.out.println("errStringXml .........."+errStringXml);
						errString = "";
					}
					if ( errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				
				errStringXml.append("</Errors></Root>\r\n");
			}
			else
			{
				errStringXml = new StringBuffer( "" );
			}
			errString = errStringXml.toString();
		}//try block end
		catch(Exception e)
		{
			System.out.println("Exception in ExpiredStockTransferGrlIC  == >");
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( conn != null && ! conn.isClosed() )
				{
					conn.close();
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :StockTransferGrlIC:wfValData :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return errString;
		
		
	}

	private String errorType( Connection conn , String errorCode )
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO =   ? ";
			
			pstmt = conn.prepareStatement( sql );			
			pstmt.setString(1, errorCode);			
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}
	// Item Change Functionality. Start from here....		
	/**
	* The public method is defined without any parameters and returns blank string
	*/
	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}
	
	/**
	* The public method is used for converting the current form data into a document(dom)
	* The currDom is then given as argument to the overloaded function wfValData to perform validation
	* Returns validation string if exists else returns null in XML format
	* @param currFrmXmlStr contains the current form data in XML format
	* @param hdrFrmXmlStr contains all the header information in the XML format
	* @param allFrmXmlStr contains the data of all the forms in XML format
	* @param objContext represents the form number
	* @param currentColumn represents the value of current field.
	* @param editFlag represents the mode of transaction(A-Add or E-Edit)
	* @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	*/
	public String itemChanged(String currFrmXmlStr, String hdrFrmXmlStr, String allFrmXmlStr, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currDom = null;
		Document hdrDom = null;
		Document allDom = null;
		
		String errString = null;
		
		GenericUtility genericUtility = GenericUtility.getInstance();
		
		try
		{
			if (currFrmXmlStr != null && currFrmXmlStr.trim().length()!=0)
			{
				currDom = genericUtility.parseString(currFrmXmlStr); 
			}
			if (hdrFrmXmlStr != null && hdrFrmXmlStr.trim().length()!=0)
			{
				hdrDom = genericUtility.parseString(hdrFrmXmlStr); 
			}
			if (allFrmXmlStr != null && allFrmXmlStr.trim().length()!=0)
			{
				allDom = genericUtility.parseString(allFrmXmlStr); 
			}
			errString = itemChanged( currDom, hdrDom, allDom, objContext, currentColumn, editFlag, xtraParams );
			System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception : StockTransferGrlIC:defaul_ItemChanged(String,String):" + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ( "returning from StockTransferGrlIC default_Itemchanged" );
		return errString;
	}	
	
	/**
	 * The public overloaded method takes a document as input and is used for the validation of required fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currDom contains the current form data as a document object model
	 * @param hdrDom contains all the header information
	 * @param allDom contains the field data of all the forms 
	 * @param objContext represents form number
	 * @param currentColumn represents the current field 
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information
	 * 
	 */
	public String itemChanged( Document currDom, Document hdrDom, Document allDom, String objContext, String currentColumn, String editFlag, String xtraParams ) throws RemoteException,ITMException
	{
		String sql = "";
		//Changed by Rohan on 20/06/12.start
		String sqlSug = "";
		String sqlExp = "";
		//String  stockTransferSql = "";
		//ResultSet rsSug = null;
		//ResultSet rsTransfer = null;
		PreparedStatement pstmtSug = null;
		//PreparedStatement pstmtTransfer = null;
		ResultSet rsExp = null;
		PreparedStatement pstmtExp = null;
		String stockSql = "";
		//String suggLocCode = "";
		PreparedStatement pstmtStock = null;
		ResultSet rsStock = null;
		String LocCodeRefSug = "";
		String LocCdRefSugExp = "";
		int cnt = 0;
		int count = 0;
		//int stockCnt = 0;
		//Changed by Rohan on 20/06/12.end
		String itemCode = "";
		String itemDescr = "";				
		String columnValue = "";		
		String siteCode = "";	
		String siteDescr = "";	
		String lotSl = "";
		String locDescr = "";
		String lotNo = "";
		String locCode = "";
		String stockTransfer = "";
		String LocCodeRef = "";
		String LocCdRef ="";
		String nearExpLock = "";
		String expLock ="";
		String nearExpLoc = "";
		String lockCode = "";
		String expLoc = "";
		String tranId = "";
		String currDateStr = null;
		String defReasCode = null;
		String loginCode = "";
		String chgTerm = "";
		String siteCodeHold = "";
		
		int currentFormNo = 0;
		int domID = 0;	
		int LineNo = 0;
		
		double holdQty = 0d; 
			
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		
		Connection conn = null;
	
		StringBuffer valueXmlString = new StringBuffer();		
		GenericUtility genericUtility = GenericUtility.getInstance();

		java.util.Date currDate = null;
		SimpleDateFormat sdf = null;
		//Changed by sumit on 27/06/12 start.
		StringBuffer valueTemp = new StringBuffer();
		String suggestedInvStat = "";
		//Changed by sumit on 27/06/12 end.	
		//Changed by sumit on 05/10/12 
		String acctCodeCr = "", acctCodeDr = "", cctrCodeDr = "", cctrCodeCr = "";
		//Changed by sumit on 05/08/12 start
		PreparedStatement pstmt1 = null;
		ResultSet rs1 = null;
		String objName = "";
		//Changed by sumit on 05/08/12 end
		//Changed by sumit on 08/09/12 
		StringBuffer lockS = new StringBuffer();
		String locType = "";
		String nexprInvstat = "";
		String exprInvstat = "";
		PreparedStatement pstmt2 =null;
		ResultSet rs2 = null;
		String noArt = "";
		double quantity = 0d;
				
		try
		{
			String userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			
			columnValue = genericUtility.getColumnValue( currentColumn, currDom );
			
			DateFormat dateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String dbDateFormat = genericUtility.getDBDateFormat();
			String applDateFormat = genericUtility.getApplDateFormat();

			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");

			DistCommon distCommon = new DistCommon();
			
			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
            valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>" );
            valueXmlString.append( editFlag ).append( "</editFlag>\r\n</Header>\r\n" );
            
            //Changed by sumit on 13/09/12 getting exp and nexp inv_stat start.
            nexprInvstat = checkNull(distCommon.getDisparams("999999","NEXPR_INVSTAT",conn));
			exprInvstat = checkNull(distCommon.getDisparams("999999","EXPR_INVSTAT",conn));
			System.out.println(" nexprInvstat ["+nexprInvstat+"] exprInvstat ["+exprInvstat+"]");
			//Changed by sumit on 13/09/12 getting exp and nexp inv_stat end.
			
			switch ( currentFormNo )
			{
				//Changed by sumit on 08/09/12 dummy form inserted start.
				case 1:
				{
					nearExpLock  = distCommon.getDisparams("999999","NEAR_EXP_LOCK",conn);
					expLock = distCommon.getDisparams("999999","EXP_LOCK",conn);
					valueXmlString.append( "<Detail1 domID='1'>\r\n" );
					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )							
					{
						sql = 	"SELECT DISTINCT I.LOCK_CODE FROM INV_HOLD I,INV_HOLD_DET H, ITEM M,LOCATION L, STOCK S  WHERE" 
								+" I.TRAN_ID = H.TRAN_ID AND"
								+" H.ITEM_CODE = M.ITEM_CODE AND"
								+" H.LOC_CODE = L.LOC_CODE AND"
								+" H.HOLD_STATUS = ? "
								+" AND H.ITEM_CODE = S.ITEM_CODE "
								+" AND H.SITE_CODE = S.SITE_CODE "
								+" AND H.LOC_CODE = S.LOC_CODE "
								+" AND H.LOT_NO = S.LOT_NO "
								+" AND H.LOT_SL = S.LOT_SL "
								+" AND S.QUANTITY > 0 "
								+" AND I.LOCK_CODE IN (?,?)";
								
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, "H");
						pstmt.setString(2, nearExpLock);
						pstmt.setString(3, expLock);
						rs = pstmt.executeQuery();
						while( rs.next())
						{
							lockS.append(rs.getString("LOCK_CODE")).append(" , ");
						}
						if( pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						if( rs != null)
						{
							rs.close();
							rs = null;
						}
						System.out.println(" locks -> ["+lockS+"]");
						String string = "";
						if( lockS.toString().length() > 0)
						{
							string = lockS.toString().substring(0, lockS.toString().length() -2);
						}
						System.out.println(" new string ["+string+"]");						
						currDate = new java.util.Date();
						sdf = new SimpleDateFormat(applDateFormat);
						currDateStr = sdf.format(currDate);
						loginCode = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" ));
						chgTerm = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" ));
						siteCode = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));
						if ( siteCode.trim().length() == 0 || "INVALID_SITE".equalsIgnoreCase(siteCode.trim()) )
						{
							siteCode = getSiteCode( xtraParams, conn );
						}
						System.out.println("siteCode = ["+siteCode+"] loginCode ->["+loginCode+"] chgTerm ->["+chgTerm+"]");
						valueXmlString.append( "<tran_id/>\r\n" );	
						valueXmlString.append( "<sys_lock_type><![CDATA[" ).append( checkNullAndTrim(string) ).append( "]]></sys_lock_type>\r\n" );						
						valueXmlString.append( "<tran_date><![CDATA[" ).append( currDateStr ).append( "]]></tran_date>\r\n" );
						valueXmlString.append( "<ref_ser__for><![CDATA[" ).append( "XFRX" ).append( "]]></ref_ser__for>\r\n" );
						valueXmlString.append( "<site_code><![CDATA[" ).append(  checkNull ( siteCode)).append( "]]></site_code>\r\n" );
						
						sql = "SELECT DESCR FROM SITE WHERE SITE_CODE = ?";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, siteCode );						
						rs = pstmt.executeQuery();	
						if( rs.next() )
						{
							siteDescr = rs.getString("DESCR");
						}
						rs.close();rs = null;
						pstmt.close();pstmt = null;

						valueXmlString.append( "<site_descr><![CDATA[" ).append( checkNull( siteDescr )).append( "]]></site_descr>\r\n" );
						valueXmlString.append( "<reas_code><![CDATA[" ).append(  checkNull ( defReasCode)).append( "]]></reas_code>\r\n" );
						valueXmlString.append( "<confirmed><![CDATA[" ).append("N").append( "]]></confirmed>\r\n" );
						valueXmlString.append( "<chg_user><![CDATA[" ).append( loginCode ).append( "]]></chg_user>\r\n" );
						valueXmlString.append( "<chg_date><![CDATA[" ).append( currDateStr ).append( "]]></chg_date>\r\n" );
						valueXmlString.append( "<chg_term><![CDATA[" ).append( chgTerm ).append( "]]></chg_term>\r\n" );
						
					}
					valueXmlString.append("</Detail1>\r\n");
				}
				break;
				//Changed by sumit on 08/09/12 dummy form inserted end.
				//Changed by sumit on 08/09/12 changed case number as case 1 already used above.
				//case 1:
				case 2:
				{
					//Changed by sumit on 08/09/12 changed detail number and getting loc_type from hdr screen
					//valueXmlString.append( "<Detail1 domID='1'>\r\n" );
					locType = genericUtility.getColumnValue("lock_type",hdrDom);
					//Changed by sumit on 17/09/12 getting inv_stat start
					nearExpLoc = distCommon.getDisparams("999999","NEAREXP_LOC",conn);
					expLoc = distCommon.getDisparams("999999","EXP_LOC",conn);
					//Changed by sumit on 17/09/12 getting inv_stat start
					valueXmlString.append( "<Detail2 domID='1'>\r\n" );
					
					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )							
					{	
						currDate = new java.util.Date();
						sdf = new SimpleDateFormat(applDateFormat);
						currDateStr = sdf.format(currDate);

						stockTransfer = distCommon.getDisparams("999999","EXP_STOCK_TRANSFER",conn);
						
						if(stockTransfer.equalsIgnoreCase("N"))
						{
							defReasCode = distCommon.getDisparams("999999","NEAR_LOCK_RES",conn);
							//Changed by sumit 
							valueTemp.append(distCommon.getDisparams("999999","NEAR_EXP_LOCK",conn));
						}
						else if(stockTransfer.equalsIgnoreCase("E"))
						{
							defReasCode = distCommon.getDisparams("999999","EXP_LOCK_RES",conn);
							//Changed by sumit 
							valueTemp.append(distCommon.getDisparams("999999","EXP_LOCK",conn));
						}
						else if(stockTransfer.equalsIgnoreCase("A"))
						{
							defReasCode = distCommon.getDisparams("999999","NEAR_EXP_RES",conn);
							
							//Changed by sumit on 27/06/12 start.
							valueTemp.append( checkNullAndTrim(distCommon.getDisparams("999999","NEAR_EXP_LOCK",conn)));
							valueTemp.append(" , ");
							valueTemp.append(checkNullAndTrim(distCommon.getDisparams("999999","EXP_LOCK",conn)));
							//Changed by sumit on 27/06/12 end.
						}
						//Changed by sumit on 08/09/12 
						lockS = new StringBuffer();
						System.out.println(" new buffer string --- ["+lockS+"]");
						sql = "SELECT DISTINCT L.INV_STAT FROM INV_HOLD I,INV_HOLD_DET H, ITEM M,LOCATION L, STOCK S" +
								" WHERE I.TRAN_ID = H.TRAN_ID AND H.ITEM_CODE = M.ITEM_CODE " +
								" AND H.LOC_CODE = L.LOC_CODE AND H.HOLD_STATUS = ? " +
								" AND I.LOCK_CODE = ? " +
								" AND H.ITEM_CODE = S.ITEM_CODE " +
								" AND H.SITE_CODE = S.SITE_CODE " +
								" AND H.LOC_CODE = S.LOC_CODE " +
								" AND H.LOT_NO = S.LOT_NO " +
								" AND H.LOT_SL = S.LOT_SL " +
								" AND S.QUANTITY > 0 " +
								" AND S.INV_STAT <> ? AND I.REF_ID IN('NEAREXPIRY','EXPIRED') ";
						
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, "H");
						pstmt.setString(2, locType);
						if ("EXP_LOCK".equalsIgnoreCase(locType))
							pstmt.setString(3, expLoc);
						else if ("NEXP_LOCK".equalsIgnoreCase(locType))
							pstmt.setString(3, nearExpLoc);
						
						rs = pstmt.executeQuery();
						while( rs.next())
						{
							lockS.append(rs.getString("INV_STAT")).append(" , ");
						}
						
						String string = "";
						if( lockS.toString().length() > 0)
						{
							string = lockS.toString().substring(0, lockS.toString().length() -2);
						}
						System.out.println(" new in case 2 string ["+string+"]");
						
						//Changed by sumit 08/09/12 commented this below code start. 
						/*suggestedInvStat = valueTemp.toString();
						System.out.println("--------------["+suggestedInvStat+"]");*/
						//Changed by sumit 08/09/12 commented this below code end. 
						
						loginCode = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" ));
						chgTerm = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" ));
						siteCode = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));
						if ( siteCode.trim().length() == 0 || "INVALID_SITE".equalsIgnoreCase(siteCode.trim()) )
						{
							siteCode = getSiteCode( xtraParams, conn );
						}
						System.out.println("siteCode = ["+siteCode+"]");

						valueXmlString.append( "<tran_id/>\r\n" );		
						valueXmlString.append( "<suggested_task_code><![CDATA[" ).append( checkNullAndTrim(string) ).append( "]]></suggested_task_code>\r\n" );
						valueXmlString.append( "<tran_date><![CDATA[" ).append( currDateStr ).append( "]]></tran_date>\r\n" );
						valueXmlString.append( "<ref_ser__for><![CDATA[" ).append( "XFRX" ).append( "]]></ref_ser__for>\r\n" );
						valueXmlString.append( "<site_code><![CDATA[" ).append(  checkNull ( siteCode)).append( "]]></site_code>\r\n" );
						
						sql = "SELECT DESCR FROM SITE WHERE SITE_CODE = ?";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, siteCode );						
						rs = pstmt.executeQuery();	
						if( rs.next() )
						{
							siteDescr = rs.getString("DESCR");
						}
						rs.close();rs = null;
						pstmt.close();pstmt = null;

						valueXmlString.append( "<site_descr><![CDATA[" ).append( checkNull( siteDescr )).append( "]]></site_descr>\r\n" );
						valueXmlString.append( "<reas_code><![CDATA[" ).append(  checkNull ( defReasCode)).append( "]]></reas_code>\r\n" );
						valueXmlString.append( "<confirmed><![CDATA[" ).append("N").append( "]]></confirmed>\r\n" );
						valueXmlString.append( "<chg_user><![CDATA[" ).append( loginCode ).append( "]]></chg_user>\r\n" );
						valueXmlString.append( "<chg_date><![CDATA[" ).append( currDateStr ).append( "]]></chg_date>\r\n" );
						valueXmlString.append( "<chg_term><![CDATA[" ).append( chgTerm ).append( "]]></chg_term>\r\n" );
					}
					//Changed by sumit on 08/09/12 changed detail number
					//valueXmlString.append("</Detail1>\r\n");
					valueXmlString.append("</Detail2>\r\n");
				}//case 1 end here
				break;
				//Changed by sumit on 08/09/12 changed case number as case 1 already used above.
				//case 2:
				case 3:
			  	{
			  		//changed by sumit on 05/09/12 to set obj_name
			  		objName = "expired_stock_transfer";
			  		// valueXmlString.append( "<Detail2>\r\n" );
			  		ArrayList<String> sugstLocList = new ArrayList<String>();

			  		//ArrayList<String> sugstExpLocList = new ArrayList<String>();
			  		
			  		//Changed by sumit on 08/09/12 getting task code and lock_type from all dom start.
			  		//String taskCode = genericUtility.getColumnValue("task_code",allDom).trim();
			  		String taskCode = genericUtility.getColumnValue("task_code",allDom).trim();
			  		locType = genericUtility.getColumnValue("lock_type",allDom).trim();
			  		System.out.println(" taskCode ->["+taskCode+"] locType ->["+locType+"]");
			  		//Changed by sumit on 08/09/12 getting task code and lock_type from all dom end.
			  		
			  		System.out.println("TASK CODE FOR CURRENT TRANSACTION["+taskCode+"]");
			  		
					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )							
					{
						
						stockTransfer = distCommon.getDisparams("999999","EXP_STOCK_TRANSFER",conn);
						nearExpLock  = distCommon.getDisparams("999999","NEAR_EXP_LOCK",conn);
						expLock = distCommon.getDisparams("999999","EXP_LOCK",conn);
						
						//Changed by sumit on 13/09/12 changing disparm variable name.
						nearExpLoc = distCommon.getDisparams("999999","NEAREXP_LOC",conn);
						expLoc = distCommon.getDisparams("999999","EXP_LOC",conn);						
						
						//Changes by rohan.......
						siteCode = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));
						
						if(stockTransfer.equalsIgnoreCase("N"))
						{
							LocCodeRef = nearExpLock;
							LocCodeRefSug = nearExpLoc;
							
						}
						else if(stockTransfer.equalsIgnoreCase("E"))
						{
							LocCodeRef = expLock;
							LocCodeRefSug = expLoc;
						}
						else if(stockTransfer.equalsIgnoreCase("A"))
						{
							LocCodeRef = nearExpLock;
							LocCdRef = expLock;
							
							LocCodeRefSug = nearExpLoc ;
							LocCdRefSugExp = expLoc;
						
						}
						if(stockTransfer.equalsIgnoreCase("N") || (stockTransfer.equalsIgnoreCase("E")))
						{	
							//changed by sumit on 05/08/12 modified sql as same record comming twice from this sql. start
							/*sql = "SELECT I.TRAN_ID,I.SITE_CODE,H.ITEM_CODE,H.LINE_NO,H.LOC_CODE,H.LOT_NO,H.LOT_SL,T.HOLD_QTY,M.DESCR,L.DESCR LOC_DESCR,I.LOCK_CODE" 
							+" FROM INV_HOLD I,INV_HOLD_DET H,INV_HOLD_REL_TRACE T,ITEM M,LOCATION L  WHERE" 
							+" I.TRAN_ID = H.TRAN_ID AND"
							+" I.LOCK_CODE= ? AND"
							+" T.REF_NO = H.TRAN_ID AND" 
							+" T.LOT_NO = H.LOT_NO AND"
							+" H.ITEM_CODE = M.ITEM_CODE AND"
							+" H.LOC_CODE = L.LOC_CODE AND"
							+" H.HOLD_STATUS = ? "
							// Changed by sumit sarkar on 05/07/12 
							+" ORDER BY I.SITE_CODE, L.INV_STAT, L.LOC_CODE";*/
							
							sql = 	"SELECT I.TRAN_ID,I.SITE_CODE,H.ITEM_CODE,H.LINE_NO,H.LOC_CODE,H.LOT_NO,H.LOT_SL, M.DESCR,L.DESCR LOC_DESCR,I.LOCK_CODE" 
									+" FROM INV_HOLD I,INV_HOLD_DET H, ITEM M,LOCATION L, STOCK S  WHERE" 
									+" I.TRAN_ID = H.TRAN_ID AND"
									+" I.LOCK_CODE= ? AND"
									+" H.ITEM_CODE = M.ITEM_CODE AND"
									+" H.LOC_CODE = L.LOC_CODE AND"
									+" H.HOLD_STATUS = ? AND "
									+" L.INV_STAT = ? "
									+" AND H.ITEM_CODE = S.ITEM_CODE "
									+" AND H.SITE_CODE = S.SITE_CODE "
									+" AND H.LOC_CODE = S.LOC_CODE "
									+" AND H.LOT_NO = S.LOT_NO "
									+" AND H.LOT_SL = S.LOT_SL "
									+" AND S.QUANTITY > 0 "
									+" ORDER BY L.LOC_CODE, H.ITEM_CODE";
							
							//changed by sumit on 05/08/12 modified sql as same record comming twice from this sql. end
							
							pstmt =  conn.prepareStatement(sql);
							//Changed by sumit on 08/09/12 
							//pstmt.setString(1,LocCodeRef );						
							pstmt.setString(1,locType );
							pstmt.setString(2,"H" );
							pstmt.setString(3, taskCode);
						}
						
						//Chnage by Rohan on 24/06/12
						else if(stockTransfer.equalsIgnoreCase("A"))						
						{
							
							//changed by sumit on 05/08/12 modified sql as same record comming twice from this sql. start.
							/*sql = "SELECT I.TRAN_ID,I.SITE_CODE,H.ITEM_CODE,H.LINE_NO,H.LOC_CODE,H.LOT_NO,H.LOT_SL,T.HOLD_QTY,M.DESCR,L.DESCR LOC_DESCR,I.LOCK_CODE" 
								+" FROM INV_HOLD I,INV_HOLD_DET H,INV_HOLD_REL_TRACE T,ITEM M,LOCATION L  WHERE" 
								+" I.TRAN_ID = H.TRAN_ID AND"								
								//+" I.LOCK_CODE IN(?,?) AND"
								+" I.LOCK_CODE = ? AND"
								+" T.REF_NO= H.TRAN_ID AND" 
								+" T.LOT_NO = H.LOT_NO AND"
								+" H.ITEM_CODE = M.ITEM_CODE AND"
								+" H.LOC_CODE = L.LOC_CODE AND"
								+" H.HOLD_STATUS = ? "
								//Changed by sumit sarkar on 05/07/12 
								+" ORDER BY I.SITE_CODE, L.INV_STAT, L.LOC_CODE";*/
							
							sql = 	"SELECT I.TRAN_ID,I.SITE_CODE,H.ITEM_CODE,H.LINE_NO,H.LOC_CODE,H.LOT_NO,H.LOT_SL, M.DESCR,L.DESCR LOC_DESCR,I.LOCK_CODE" 
									+" FROM INV_HOLD I,INV_HOLD_DET H, ITEM M,LOCATION L  WHERE" 
									+" I.TRAN_ID = H.TRAN_ID AND"
									+" I.LOCK_CODE= ? AND"
									+" H.ITEM_CODE = M.ITEM_CODE AND"
									+" H.LOC_CODE = L.LOC_CODE AND"
									+" H.HOLD_STATUS = ? AND "
									+" L.INV_STAT = ? "
									+" ORDER BY L.LOC_CODE, H.ITEM_CODE";
							
							sql = 	"SELECT I.TRAN_ID,I.SITE_CODE,H.ITEM_CODE,H.LINE_NO,H.LOC_CODE,H.LOT_NO,H.LOT_SL, M.DESCR,L.DESCR LOC_DESCR,I.LOCK_CODE" 
									+" FROM INV_HOLD I,INV_HOLD_DET H, ITEM M,LOCATION L, STOCK S WHERE" 
									+" I.TRAN_ID = H.TRAN_ID AND"
									+" I.LOCK_CODE= ? AND"
									+" H.ITEM_CODE = M.ITEM_CODE AND"
									+" H.LOC_CODE = L.LOC_CODE AND"
									+" H.HOLD_STATUS = ? AND "
									+" L.INV_STAT = ? "
									+" AND H.ITEM_CODE = S.ITEM_CODE "
									+" AND H.SITE_CODE = S.SITE_CODE "
									+" AND H.LOC_CODE = S.LOC_CODE "
									+" AND H.LOT_NO = S.LOT_NO "
									+" AND H.LOT_SL = S.LOT_SL "
									+" AND S.QUANTITY > 0 "
									+" ORDER BY L.LOC_CODE, H.ITEM_CODE";
							
							//changed by sumit on 05/08/12 modified sql as same record comming twice from this sql. end.
							
							//Changed by sumit on 27/06/12 commented  start.
							/*sqlExp = "SELECT A.LOC_CODE AS LOC_CODE FROM LOCATION A, INVSTAT B "
								+ " WHERE A.INV_STAT = B.INV_STAT AND B.AVAILABLE = 'Y' "
								+ " AND (CASE WHEN B.STAT_TYPE IS NULL THEN ' ' ELSE B.STAT_TYPE END) <> 'S' "
								+ " AND A.INV_STAT = ? ORDER BY LOC_CODE ";
							
							pstmtExp =  conn.prepareStatement(sqlExp);
							pstmtExp.setString(1, LocCdRefSugExp);
							rsExp = pstmtExp.executeQuery();*/
							//Changed by sumit on 27/06/12 commented  end.
							//Changed by Rohan on 20/06/12 [Wm1ESUN006].To add Suggested location.end
							
							pstmt =  conn.prepareStatement(sql);
							//Changed by sumit om 27/06/12 change parameter start.
							/*pstmt.setString(1,LocCodeRef );
							pstmt.setString(2,LocCdRef );*/
							pstmt.setString(1,locType );
							//Changed by sumit om 27/06/12 change parameter end.							
							pstmt.setString(2,"H" );
							pstmt.setString(3, taskCode);
						}
						
						//Changed by sumit sarkar on 05/07/12 use this here.
						sqlExp = "SELECT A.LOC_CODE AS LOC_CODE FROM LOCATION A, INVSTAT B "
							+ " WHERE A.INV_STAT = B.INV_STAT AND B.AVAILABLE = 'Y' "
							+ " AND (CASE WHEN B.STAT_TYPE IS NULL THEN ' ' ELSE B.STAT_TYPE END) <> 'S' "
							+ " AND A.INV_STAT = ? ORDER BY LOC_CODE ";
						
						pstmtExp =  conn.prepareStatement(sqlExp);					
						pstmtExp.setString(1, LocCdRefSugExp);
						rsExp = pstmtExp.executeQuery();
						
						//Changed by Rohan on 20/06/12 [Wm1ESUN006].To add Suggested location.start
                        sqlSug = "SELECT A.LOC_CODE AS LOC_CODE FROM LOCATION A, INVSTAT B "
								+ " WHERE A.INV_STAT = B.INV_STAT AND B.AVAILABLE = 'Y' "
								+ " AND (CASE WHEN B.STAT_TYPE IS NULL THEN ' ' ELSE B.STAT_TYPE END) <> 'S' "
								+ " AND A.INV_STAT = ? ORDER BY LOC_CODE ";
						pstmtSug =  conn.prepareStatement(sqlSug);						
						pstmtSug.setString(1, LocCodeRefSug);						
						
						double stockQty = 0d;
						
						stockSql = "SELECT SUM(CASE WHEN QUANTITY IS NULL THEN 0 ELSE QUANTITY END) AS STOCK_QTY "
								+  " FROM STOCK WHERE LOC_CODE = ? ";
						
						//pstmtStock =  conn.prepareStatement(stockSql);						
						//Changed by sumit on 13/09/12 getting location to transfer item. start.
						sugstLocList.clear();
						System.out.println(" suggested loc after list clear() ->"+sugstLocList);
						if(locType.equalsIgnoreCase(expLock))
						{
							//(String locType,String siteCode, String taskCode, String invStat, Connection conn)
							System.out.println(" inside if of expLock");
							sugstLocList = suggestedLoc(locType,siteCode, taskCode, exprInvstat, conn);
						}
						else if(locType.equalsIgnoreCase(nearExpLock))
						{
							System.out.println(" inside if of nearExpLock");
							sugstLocList = suggestedLoc(locType,siteCode, taskCode, nexprInvstat, conn);
						}						
						
						//Changed by sumit on 13/09/12 getting location to transfer item. end.
						//Changed by sumit on 13/09/12 commented end.
						/*if(locType.equalsIgnoreCase(nearExpLock))
						{
						    rsSug = pstmtSug.executeQuery();
							while (rsSug.next())
							{
								suggLocCode = checkNull(rsSug.getString("LOC_CODE") );
								//Changed by rohan on 25/06/12 on .start
								System.out.println("Adding location check====>"+suggLocCode);
								stockTransferSql = " SELECT COUNT(*) AS CNT FROM STOCK_TRANSFER H,STOCK_TRANSFER_DET D"
								          + " Where H.TRAN_ID = D.TRAN_ID"
								          + " AND H.SITE_CODE = ? "
										  + " AND LOC_CODE__TO = ? ";
								pstmtTransfer =  conn.prepareStatement(stockTransferSql);
								pstmtTransfer.setString(1, siteCode);
								pstmtTransfer.setString(2, suggLocCode);
								rsTransfer= pstmtTransfer.executeQuery();
								
								if(rsTransfer.next())
								{
									stockCnt = rsTransfer.getInt("CNT");
								}
								
								if( stockCnt == 0 )
								{
									pstmtStock =  conn.prepareStatement(stockSql);	
									pstmtStock.setString( 1, suggLocCode );
									rsStock = pstmtStock.executeQuery();
									if ( rsStock.next() )
									{
										stockQty = rsStock.getDouble("STOCK_QTY");
										if ( stockQty == 0 )
										{
											sugstLocList.add(suggLocCode);
										}
									}
									else
									{
										sugstLocList.add(suggLocCode);
									}
									
								}
								if(pstmtStock != null)
								{
									pstmtStock.close();
									pstmtStock = null;
								}
								
								if(rsStock != null)
								{	
									rsStock.close(); 
									rsStock = null;
								}	
								if(pstmtTransfer != null)
								{
									pstmtTransfer.close();
									pstmtTransfer = null;
								}
								if(rsTransfer != null)
								{
									rsTransfer.close();
									rsTransfer = null;
								}
								//Changed by rohan on 25/06/12 on .end
							}
						}
						
						if(locType.equalsIgnoreCase(expLock))
						{
	                        if(rsExp != null )
	                        {
		                        while (rsExp.next())
								{
									suggLocCode = checkNull(rsExp.getString("LOC_CODE") );
									if(pstmtTransfer != null)
									{
										pstmtTransfer.close();
										pstmtTransfer = null;
									}
									if(rsTransfer != null)
									{
										rsTransfer.close();
										rsTransfer = null;
									}
									//Changed by rohan on 25/06/12 on .start
									
									stockTransferSql = " SELECT COUNT(*) AS CNT FROM STOCK_TRANSFER H,STOCK_TRANSFER_DET D"
									          + " Where H.TRAN_ID = D.TRAN_ID"
									          + " AND H.SITE_CODE = ? "
											  + " AND LOC_CODE__TO = ? ";
									pstmtTransfer =  conn.prepareStatement(stockTransferSql);
									pstmtTransfer.setString(1, siteCode);
									pstmtTransfer.setString(2, suggLocCode);
									rsTransfer= pstmtTransfer.executeQuery();
									
									if(rsTransfer.next())
									{
										stockCnt = rsTransfer.getInt("CNT");
									}
									
									if( stockCnt == 0 )
									{
										pstmtStock =  conn.prepareStatement(stockSql);	
										pstmtStock.setString( 1, suggLocCode );
										rsStock = pstmtStock.executeQuery();
										if ( rsStock.next() )
										{
											stockQty = rsStock.getDouble("STOCK_QTY");
			         
											if ( stockQty == 0 )
											{
												sugstExpLocList.add(suggLocCode);
											}
										}
										else
										{
											sugstExpLocList.add(suggLocCode);
										}
									}	
									if(pstmtStock != null)
									{
										pstmtStock.close();
										pstmtStock = null;
									}
									
									if(rsStock != null)
									{	
										rsStock.close(); 
										rsStock = null;
									}	
								}
	                        }    
						}*/
						
						//Changed by sumit on 13/09/12 commented start.
                      //Changed by Rohan on 20/06/12 [Wm1ESUN006].To add Suggested location.end
                        ////System.out.println("sugstExpLocList ->"+sugstExpLocList);						
						System.out.println("sugstLocList after ->"+sugstLocList);
						rs = pstmt.executeQuery();
						//Changed by sumit on 05/08/12 getting hold quantity value from inv_hold_rel_trace start.
						//sql = "SELECT SUM(HOLD_QTY) AS HOLD_QTY FROM INV_HOLD_REL_TRACE " +
						sql = "SELECT SUM((CASE WHEN HOLD_QTY IS NULL THEN 0 ELSE HOLD_QTY END) + " +
								" (CASE WHEN REL_QTY IS NULL THEN 0 ELSE REL_QTY END)) AS HOLD_QTY FROM INV_HOLD_REL_TRACE " +
								" WHERE "+//REF_NO = ? AND " +
								" SITE_CODE = ? " +
								" AND ITEM_CODE = ? " +
								" AND LOC_CODE =  ? " +
								" AND LOT_NO =  ? " +
								" AND LOT_SL = ? "+//;
								//Changed By Pragyan 26-DEC-13 To check lock code to avoid duplicate records.
								" AND LOCK_CODE = ? ";
								
						pstmt1 = conn.prepareStatement(sql);
						
						while (rs.next())
						{
							tranId = rs.getString("TRAN_ID");
							siteCodeHold = rs.getString("SITE_CODE");
							itemCode = rs.getString("ITEM_CODE");
							itemDescr = rs.getString("DESCR");
							LineNo = rs.getInt("LINE_NO");
							locCode = rs.getString("LOC_CODE");
							lockCode = rs.getString("LOCK_CODE");
						    lotNo = rs.getString("LOT_NO");
							lotSl = rs.getString("LOT_SL");
							//Changed by sumit on 05/09/12 not getting value from sql.
							//holdQty = rs.getDouble("HOLD_QTY");
							locDescr = rs.getString("LOC_DESCR");
							
							
							//pstmt1.setString(1, tranId);
							pstmt1.setString(1, siteCodeHold);
							pstmt1.setString(2, itemCode);
							pstmt1.setString(3, locCode);
							pstmt1.setString(4, lotNo);
							pstmt1.setString(5, lotSl);
							//Changed By Pragyan 26-DEC-13 To check lock code to avoid duplicate records.
							pstmt1.setString(6, locType);
							rs1 = pstmt1.executeQuery();
							
							if( rs1.next() )
							{
								holdQty = rs1.getInt("HOLD_QTY");
							}
							pstmt1.clearParameters();
							if(rs1 != null)
							{
								rs1.close();
								rs1 = null;
							}
							
							sql = "SELECT QUANTITY, NO_ART, ACCT_CODE__INV, CCTR_CODE__INV FROM STOCK WHERE ITEM_CODE = ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO = ? AND LOT_SL = ? ";
							pstmt2 = conn.prepareStatement(sql);
							pstmt2.setString(1, itemCode);
							pstmt2.setString(2, siteCodeHold);							
							pstmt2.setString(3, locCode);
							pstmt2.setString(4, lotNo);
							pstmt2.setString(5, lotSl);
							rs2 = pstmt2.executeQuery();
							if( rs2.next() )
							{
								quantity = rs2.getDouble("QUANTITY");
								noArt = rs2.getString("NO_ART");	
								acctCodeCr = rs2.getString("ACCT_CODE__INV");	
								acctCodeDr = rs2.getString("ACCT_CODE__INV");
								cctrCodeCr = rs2.getString("CCTR_CODE__INV");
								cctrCodeDr = rs2.getString("CCTR_CODE__INV");								
							}
							pstmt2.close();pstmt2 = null;
							rs2.close();rs2 = null;
							
							
							System.out.println(" new hold quantity ->["+holdQty+"]");						
							domID++;

							//Chnaged by sumit on 05/09/12 as per manoharan sir. start.
							//valueXmlString.append( "<Detail2 domID='"+ domID +"' selected=\"N\">\r\n" );
							//Changed by sumit on 08/09/12 changed detail number.
							//valueXmlString.append( "<Detail2 domID='"+ domID +"' objContext = '"+currentFormNo+"' objName='"+objName+"' selected=\"N\">\r\n" );
							valueXmlString.append( "<Detail3 domID='"+ domID +"' objContext = '"+currentFormNo+"' objName='"+objName+"' selected=\"N\">\r\n" );
							valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" />\r\n");
							//Chnaged by sumit on 05/09/12 as per manoharan sir. end.
							//valueXmlString.append( "<Detail2>\r\n" );							
							valueXmlString.append("<tran_id/>\r\n");
							valueXmlString.append("<tran_id_hold><![CDATA[").append(tranId).append("]]></tran_id_hold>\r\n");
							valueXmlString.append("<line_no><![CDATA[").append(LineNo).append("]]></line_no>\r\n");
							valueXmlString.append("<line_no_hold><![CDATA[").append(LineNo).append("]]></line_no_hold>\r\n");
							valueXmlString.append("<item_code><![CDATA[").append(checkNull(itemCode)).append("]]></item_code>\r\n");
							valueXmlString.append("<item_descr><![CDATA[").append(checkNull(itemDescr)).append("]]></item_descr>\r\n");
							valueXmlString.append("<loc_code__fr><![CDATA[").append(checkNullAndTrim(locCode)).append("]]></loc_code__fr>\r\n");
							valueXmlString.append("<loc_descr__fr><![CDATA[").append(checkNull(locDescr)).append("]]></loc_descr__fr>\r\n");
							
							//Changed by Rohan 0n 20/06/12[WM1ESUN006].start
							/*
							if(lockCode.trim().equalsIgnoreCase(nearExpLock.trim()))
							{
								valueXmlString.append("<loc_code__to><![CDATA[").append( checkNull(nearExpLoc) ).append("]]></loc_code__to>\r\n");
							}
							else if(lockCode.trim().equalsIgnoreCase(expLock.trim()))
							{
								valueXmlString.append("<loc_code__to><![CDATA[").append( checkNull(expLoc) ).append("]]></loc_code__to>\r\n");
							}
							*/
							//Changed by Rohan 0n 20/06/12[WM1ESUN006].end
							System.out.println("lot_no__fr"+lotNo+"lot_sl__fr"+lotSl);
							valueXmlString.append("<lot_no__fr><![CDATA[").append(checkNullAndTrim(lotNo)).append("]]></lot_no__fr>\r\n");
							valueXmlString.append("<lot_no__to><![CDATA[").append(checkNull(lotNo)).append("]]></lot_no__to>\r\n");	
							//Changed by Rohan 0n 20/06/12 [WM1FSUN006] To scan Lot Sl
							//valueXmlString.append("<lot_sl__fr><![CDATA[").append(checkNull(lotSl)).append("]]></lot_sl__fr>\r\n");
							valueXmlString.append("<lot_sl__fr><![CDATA[").append(checkNullAndTrim(lotSl)).append("]]></lot_sl__fr>\r\n");
							
							valueXmlString.append("<lot_sl__to><![CDATA[").append(checkNull(lotSl)).append("]]></lot_sl__to>\r\n");
							valueXmlString.append("<quantity><![CDATA[").append(quantity).append("]]></quantity>\r\n");
							valueXmlString.append("<hold_qty><![CDATA[").append(holdQty).append("]]></hold_qty>\r\n");
							//Changed by sumit on 14/09/12 insert no_art						
							valueXmlString.append("<no_art><![CDATA[").append(noArt).append("]]></no_art>\r\n");
							//Changed by sumit on 05/10/12 insert acct_code__cr and other start
							valueXmlString.append("<acct_code__cr><![CDATA[").append(acctCodeCr).append("]]></acct_code__cr>\r\n");
							valueXmlString.append("<acct_code__dr><![CDATA[").append(acctCodeDr).append("]]></acct_code__dr>\r\n");
							valueXmlString.append("<cctr_code__dr><![CDATA[").append(cctrCodeDr).append("]]></cctr_code__dr>\r\n");
							valueXmlString.append("<cctr_code__cr><![CDATA[").append(cctrCodeCr).append("]]></cctr_code__cr>\r\n");
							//Changed by sumit on 05/10/12 insert acct_code__cr and other end
							
							//Changed by Rohan 0n 20/06/12 [WM1ESU006] To add Location Code Suggested.start
							
							//Changed by sumit sarkar on 13/07/12 commented start.
							/*System.out.println("sugstExpLocList.size()"+sugstExpLocList.size()+"cnt"+cnt+"lockCode"+lockCode+">>>>EXP_LOCK");							
							System.out.println("sugstLocList.size()"+sugstLocList.size()+"count"+count);*/
							//Changed by sumit sarkar on 13/07/12 commented end.
							
							//Changed by sumit on 05/07/12 checking as per task_type 
							//if(sugstExpLocList.size() > 0 && cnt < sugstExpLocList.size() && lockCode.trim().equalsIgnoreCase(expLock) )
							//changed by sumit on 13/09/12 modified suggested location.
							/*if(sugstExpLocList.size() > 0 && cnt < sugstExpLocList.size() && locType.equalsIgnoreCase(expLock) )
                            {
							   System.out.println("exp - > sugstExpLocList.size()"+sugstExpLocList.size()+"cnt"+cnt+"lockCode"+lockCode+">>>>EXP_LOCK");			
                               valueXmlString.append("<loc_code__sys><![CDATA[").append(sugstExpLocList.get(cnt)).append("]]></loc_code__sys>\r\n");
                               //suggestedList.add(sugstExpLocList.get(cnt));
                               //System.out.println("Adding To List suggestedList====>"+sugstExpLocList.get(cnt));
							   cnt++;
							}
							else if(sugstLocList.size() > 0 && count < sugstLocList.size() && locType.equalsIgnoreCase(nearExpLock))
							{
								System.out.println("near exp- > sugstLocList.size()"+sugstLocList.size()+"count"+count);
								valueXmlString.append("<loc_code__sys><![CDATA[").append( sugstLocList.get(count)).append("]]></loc_code__sys>\r\n");
								//suggestedList.add(sugstLocList.get(count));
								//System.out.println("Adding To List suggestedList==********==>"+sugstLocList.get(count));
								count++;
							}*/
							if(sugstLocList.size() > 0 && cnt < sugstLocList.size())
                            {
							   //System.out.println("exp - > sugstExpLocList.size()"+sugstExpLocList.size()+"cnt"+cnt+"lockCode"+lockCode+">>>>EXP_LOCK");			
                               valueXmlString.append("<loc_code__sys><![CDATA[").append(sugstLocList.get(cnt)).append("]]></loc_code__sys>\r\n");
                               //suggestedList.add(sugstExpLocList.get(cnt));
                               //System.out.println("Adding To List suggestedList====>"+sugstExpLocList.get(cnt));
							   cnt++;
							}
							else
							{
								valueXmlString.append("<loc_code__sys><![CDATA[").append( "").append("]]></loc_code__sys>\r\n");
							}
							//Changed by sumit sarkar on 13/07/12 change condition.
							//else if(sugstLocList.size() > 0 && count < sugstLocList.size()
							/*if(sugstLocList.size() > 0 && count < sugstLocList.size() && taskCode.equalsIgnoreCase(nearExpLock))
							{
								System.out.println("near exp- > sugstLocList.size()"+sugstLocList.size()+"count"+count);
								valueXmlString.append("<loc_code__sys><![CDATA[").append( sugstLocList.get(count)).append("]]></loc_code__sys>\r\n");
								//suggestedList.add(sugstLocList.get(count));
								//System.out.println("Adding To List suggestedList==********==>"+sugstLocList.get(count));
								count++;
							}
							 */
							//Changed by Rohan 0n 20/06/12 [WM1ESU006] To add Location Code Suggested.end
							valueXmlString.append("<loc_code__to><![CDATA[").append( "").append("]]></loc_code__to>\r\n");
							//Changed by sumit on 08/09/12 detail number is changed.
							//valueXmlString.append("</Detail2>\r\n");
							valueXmlString.append("</Detail3>\r\n");
							
						}
						rs.close(); rs = null;						
						pstmt.close(); pstmt = null;

						//Changed by sumit sarkar on 14/07/12 commented below code
						/*String updatedDetailDomStr = addSelectedRecToDom( allDom, valueXmlString.toString() );
						
						valueXmlString = null;
						valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>").append( editFlag );
						valueXmlString.append("</editFlag>\r\n</Header>\r\n");
						updatedDetailDomStr = updatedDetailDomStr.substring(updatedDetailDomStr.indexOf("<Root>") + "<Root>".length(), updatedDetailDomStr.indexOf("</Root>") );
						
						valueXmlString.append(updatedDetailDomStr);*/
						
						//System.out.println("updatedDetailDomStr[1]:>>>>>>>>>>> "+updatedDetailDomStr);
			
					}
					break;				  		
			  	}// case 2 end
			  	
			}//switch  end
			
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (rsExp != null)
			{
				rsExp.close();
				rsExp = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if (pstmtExp != null)
			{
				pstmtExp.close();
				pstmtExp = null;
			}
			if( rs1 != null )
			{
				rs1.close();
				rs1 = null;
			}
			if(pstmt1 != null)
			{
				pstmt1.close();
				pstmt1 = null;
			}
			
			//valueXmlString.append("</Root>");
		}//try block end
		catch(Exception e)
		{
			System.out.println( "Exception :expStockTransferIC" + e.getMessage() + ":" );
			valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (rsExp != null)
				{
					rsExp.close();
					rsExp = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (pstmtExp != null)
				{
					pstmtExp.close();
					pstmtExp = null;
				}
				if( rs1 != null )
				{
					rs1.close();
					rs1 = null;
				}
				if(pstmt1 != null)
				{
					pstmt1.close();
					pstmt1 = null;
				}
				if( conn != null && ! conn.isClosed() )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :expStockTransferIC"+e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append( "</Root>\r\n" );	
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();
	}

	private String checkNull( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		return inputVal;
	}
	private String getSiteCode( String xtraParams, Connection connObject ) throws ITMException
	{
		String defaultSite = "";
		String empSite = "";
		String workSite = "";
		String sql = "";
		String loginCode = "";
	
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try
		{
			GenericUtility genericUtility = GenericUtility.getInstance();
			loginCode = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" ));

			sql = "SELECT USERS.EMP_CODE, USERS.ENTITY_CODE, USERS.SITE_CODE__DEF, EMP.EMP_SITE, EMP.WORK_SITE "+
					"FROM USERS USERS, EMPLOYEE EMP WHERE USERS.EMP_CODE = EMP.EMP_CODE AND USERS.CODE = ? ";
			pstmt = connObject.prepareStatement( sql );
			pstmt.setString( 1, loginCode );						
			rs = pstmt.executeQuery();	
			if( rs.next() )
			{
				defaultSite = checkNull(rs.getString("SITE_CODE__DEF"));
				empSite = checkNull(rs.getString("EMP_SITE"));
				workSite = checkNull(rs.getString("WORK_SITE"));
			}
			if ( defaultSite.trim().length() == 0 && empSite.trim().length() > 0 )
			{
				defaultSite = empSite;
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
		}
		catch (Exception e)
		{				
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{	
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println("defaultSite = ["+defaultSite+"]");
		return defaultSite;
	}
	private String checkNullAndTrim( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		else
		{
			inputVal = inputVal.trim();
		}
		return inputVal;
	}
	private String addSelectedRecToDom( Document allFormDataDom, String detailString ) throws Exception
	{
		ArrayList selectedList = new ArrayList();
		NodeList detailList = null;
		Node currDetail = null;
		NodeList currDetailList = null;
		String selectedVal = "", nodeName = "", updateStatus = "";
		String domIDVal = "";
		String updatedDetailDomStr = "";
		String attributeVal = "";
		String locCodeTo = "";
		String columnValue = "";

		HashMap toUpdateMap = new HashMap();

		Node elementName = null;

		int currDetailListLength = 0;
		int	detailListLength = 0;

		int selectedValCnt = 0;
		
		GenericUtility genericUtility = GenericUtility.getInstance();

		try
		{
			detailList = allFormDataDom.getElementsByTagName("Detail2");
			detailListLength = detailList.getLength();
			for ( int ctr = 0; ctr < detailListLength; ctr++ )
			{
				currDetail = detailList.item(ctr);
				currDetailList = currDetail.getChildNodes();
				currDetailListLength = currDetailList.getLength();
				
				attributeVal = "";
				columnValue = "";

				ArrayList toUpdNodeList = new ArrayList();
				HashMap dataMap = new HashMap();

				for ( int i=0; i< currDetailListLength; i++ )
				{
					Node childNode = currDetailList.item(i);
					nodeName = childNode.getNodeName();
					if (nodeName.equalsIgnoreCase("Attribute"))
					{
						attributeVal = checkNull(currDetailList.item(i).getAttributes().getNamedItem("selected").getNodeValue());
						System.out.println("attributeVal =["+attributeVal+"]");
					}//if (nodeName = Attribute
					else if (nodeName.equalsIgnoreCase("loc_code__to"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							locCodeTo = childNode.getFirstChild().getNodeValue();
							//toUpdNodeList.add( 1, childNode );
							dataMap.put("loc_code__to", childNode);
						}
					}
				}//End of inner for loop
				if ( "Y".equalsIgnoreCase(attributeVal.trim()) )
				{
					if ( currDetail.getAttributes().getNamedItem( "domID" ) != null )
					{
						domIDVal = checkNull(currDetail.getAttributes().getNamedItem( "domID" ).getNodeValue());
						System.out.println("domIDVal =["+domIDVal+"]");
					}
					toUpdateMap.put( domIDVal, dataMap );
				}
			}//End of for loop
			
			System.out.println("toUpdateMap:>>>>>>>>>>>: "+toUpdateMap);

			detailList = null;
			
			detailString = detailString + "</Root>\r\n" ;	
			System.out.println("detailString:>>>>>>>>>>> "+detailString);
			Document detailDom = genericUtility.parseString(detailString); 

			Element elementAttr = null;

			detailList = detailDom.getElementsByTagName("Detail2");
			detailListLength = detailList.getLength();
			for ( int ctr = 0; ctr < detailListLength; ctr++ )
			{
				currDetail = detailList.item(ctr);

				if ( currDetail.getAttributes().getNamedItem( "selected" ) != null )
				{
					selectedVal = checkNull(currDetail.getAttributes().getNamedItem( "selected" ).getNodeValue());
					System.out.println("selectedVal =["+selectedVal+"]");
					if ( "N".equalsIgnoreCase(selectedVal.trim()) )
					{
						if ( currDetail.getAttributes().getNamedItem( "domID" ) != null )
						{
							//ArrayList aList = null;

							HashMap dataMap = new HashMap();

							domIDVal = checkNull(currDetail.getAttributes().getNamedItem( "domID" ).getNodeValue());
							System.out.println("domIDVal =["+domIDVal+"]");
							System.out.println("toUpdateMap.containsKey(domIDVal) =["+toUpdateMap.containsKey(domIDVal)+"]");
							if ( toUpdateMap.containsKey(domIDVal) )
							{
								elementAttr = (Element)currDetail;
								elementAttr.setAttribute( "selected" , "Y" );
								
								Node locCodeToNode = null;

								dataMap = (HashMap)toUpdateMap.get(domIDVal);

								if ( dataMap.get("loc_code__to") != null )
								{
									locCodeToNode = (Node)dataMap.get("loc_code__to");
								}
								
								Node updatedNode = null;

								currDetailList = currDetail.getChildNodes();
								currDetailListLength = currDetailList.getLength();
								
								for ( int i = 0; i < currDetailListLength; i++ )
								{
									elementName = currDetailList.item(i);
									nodeName = elementName.getNodeName();
									if( elementName.getNodeType() != Node.ELEMENT_NODE || nodeName.equalsIgnoreCase("#text") )
									{
										continue;
									}
									System.out.println("nodeName =["+nodeName+"]");
									if ( nodeName.equalsIgnoreCase("loc_code__to") )
									{
										//System.out.println("LocCodeToNode =["+genericUtility.serializeDom( LocCodeToNode )+"]");
										updatedNode = detailDom.importNode(locCodeToNode, true);
										//System.out.println("updatedNode =["+genericUtility.serializeDom( updatedNode )+"]");
										(detailDom.getElementsByTagName("Detail2").item(ctr)).replaceChild(updatedNode, elementName );
									}
								}//inner for loop
							}//if ( toUpdateMap.containsKey(domIDVal) )
						}//if ( currDetail.getAttributes().getNamedItem( "domID" )
					}//if ( "N".equalsIgnoreCase(selectedVal.trim()) )
				}//if ( currDetail.getAttributes().getNamedItem( "selected" )
			}//outer for loop
			updatedDetailDomStr = genericUtility.serializeDom( detailDom );
			System.out.println("updatedDetailDomStr:>>>>>>>>>>> "+updatedDetailDomStr);
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw e;
		}
		
		return updatedDetailDomStr;
	}
	
	//Changed by sumit sarkar on 16/07/12 method to get attribute value start.
	private String attributeValue(Document allFormDataDom) throws Exception
	{

		ArrayList selectedList = new ArrayList();
		NodeList detailList = null;
		Node currDetail = null;
		NodeList currDetailList = null;
		String selectedVal = "", nodeName = "", updateStatus = "";
		String domIDVal = "";
		String updatedDetailDomStr = "";
		String attributeVal = "";
		String locCodeTo = "";
		String columnValue = "";

		HashMap toUpdateMap = new HashMap();

		Node elementName = null;

		int currDetailListLength = 0;
		int	detailListLength = 0;

		int selectedValCnt = 0;
		
		GenericUtility genericUtility = GenericUtility.getInstance();

		try
		{
			detailList = allFormDataDom.getElementsByTagName("Detail3");
			detailListLength = detailList.getLength();
			for ( int ctr = 0; ctr < detailListLength; ctr++ )
			{
				currDetail = detailList.item(ctr);
				currDetailList = currDetail.getChildNodes();
				currDetailListLength = currDetailList.getLength();
				
				attributeVal = "";
				columnValue = "";

				ArrayList toUpdNodeList = new ArrayList();
				HashMap dataMap = new HashMap();

				for ( int i=0; i< currDetailListLength; i++ )
				{
					Node childNode = currDetailList.item(i);
					nodeName = childNode.getNodeName();
					if (nodeName.equalsIgnoreCase("Attribute"))
					{
						attributeVal = checkNull(currDetailList.item(i).getAttributes().getNamedItem("selected").getNodeValue());
						System.out.println("attributeVal =["+attributeVal+"]");
					}//if (nodeName = Attribute					
				}
			}
			System.out.println("attributeVal @@>>>>>>>>>>> "+updatedDetailDomStr);
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw e;
		}
		
		return attributeVal;
	
	}
	//Changed by sumit sarkar on 16/07/12 method to get attribute value end.
	
	private ArrayList suggestedLoc(String locType,String siteCode, String taskCode, String invStat, Connection conn) throws ITMException
	{
		String sql = "";
		String locSql = "";
		String singleLotSl = "";
		String singleLotSql = "";
		String locCode = "";
		String locCodeSugg = "";
		String itemCode = "";
		//String siteCode = "";
		String lotNo = "";
		String itemLotOpt = "";
		PreparedStatement pstmt =null, pstmt1 = null, pstmt2 = null;
		ResultSet rs = null, rs1 = null, rs2 = null;
		Set suggLocSet = null;
		ArrayList suggLoc = new ArrayList();
		ArrayList alArraySuggLoc = new ArrayList();
		ArrayList arryLotNo = new ArrayList();		
		ArrayList arrayItemCode = new ArrayList();
		ArrayList arrayLocCode = new ArrayList();
		int quantity = 0;
		int count = 0;
		int i = 1;
		//ArrayList arraySiteCode = new ArrayList();
		
		try 
		{
			suggLoc.clear();
			sql = 	"SELECT COUNT(*) AS COUNT FROM INV_HOLD I,INV_HOLD_DET H, ITEM M,LOCATION L, STOCK S  WHERE " 
					+" I.TRAN_ID = H.TRAN_ID AND"
					+" I.LOCK_CODE= ? AND"
					+" H.ITEM_CODE = M.ITEM_CODE AND"
					+" H.LOC_CODE = L.LOC_CODE AND"
					+" H.HOLD_STATUS = ? AND "
					+" L.INV_STAT = ? "
					+" AND H.ITEM_CODE = S.ITEM_CODE "
					+" AND H.SITE_CODE = S.SITE_CODE "
					+" AND H.LOC_CODE = S.LOC_CODE "
					+" AND H.LOT_NO = S.LOT_NO "
					+" AND H.LOT_SL = S.LOT_SL "
					+" AND S.QUANTITY > 0 ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, locType);
			pstmt.setString(2, "H");
			pstmt.setString(3, taskCode);
			rs = pstmt.executeQuery();
			if( rs.next())
			{
				count = rs.getInt("COUNT");
			}
			System.out.println(" count ["+count+"]");
			
			locSql = "SELECT A.LOC_CODE AS LOC_CODE FROM LOCATION A, INVSTAT B "
					+ " WHERE A.INV_STAT = B.INV_STAT AND B.AVAILABLE = 'Y' "
					+ " AND (CASE WHEN B.STAT_TYPE IS NULL THEN ' ' ELSE B.STAT_TYPE END) <> 'S' "
					+ " AND A.INV_STAT = ? "
					+ " ORDER BY LOC_CODE ";
			pstmt = conn.prepareStatement(locSql);
			pstmt.setString(1, invStat);
			rs = pstmt.executeQuery();
			while( rs.next() && suggLoc.size() < count)
			{
				
				locCodeSugg = rs.getString("LOC_CODE");				
				sql = " SELECT QUANTITY FROM STOCK WHERE SITE_CODE = ?  AND LOC_CODE = ? ";						
				pstmt2 = conn.prepareStatement(sql);
				pstmt2.setString(1, siteCode);
				pstmt2.setString(2, locCodeSugg);					
				rs2 = pstmt2.executeQuery();
				if(rs2.next()) 
				{
					quantity = rs2.getInt("QUANTITY");
					if( quantity == 0)
					{
						suggLoc.add(locCodeSugg);							
					}							
				}
				else
				{
					suggLoc.add(locCodeSugg);
				}					
				if( pstmt2 != null)
				{
					pstmt2.close();
					pstmt = null;
				}
				if( rs2 != null)
				{
					rs2.close();
					rs2 = null;
				}				
			}//while close		
			
			if( pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}			
			if( pstmt2 != null)
			{
				pstmt2.close();
				pstmt2 = null;
			}
			if( rs != null)
			{
				rs.close();
				rs = null;
			}			
			if( rs2 != null)
			{
				rs2.close();
				rs2 = null;
			}
			
			suggLocSet = new HashSet(suggLoc);			
			suggLoc = new ArrayList(new TreeSet(suggLocSet));
			System.out.println(" suggested location after sorted to HashSet ------>"+suggLoc);			
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
			System.out.println(e);
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( pstmt1 != null)
				{
					pstmt1.close();
					pstmt1 = null;
				}
				if( pstmt2 != null)
				{
					pstmt2.close();
					pstmt2 = null;
				}
				if( rs != null)
				{
					rs.close();
					rs = null;
				}
				if( rs1 != null)
				{
					rs1.close();
					rs1 = null;
				}
				if( rs2 != null)
				{
					rs2.close();
					rs2 = null;
				}				
			}
			catch( Exception ex)
			{
				throw new ITMException(ex);
			}
		}
		return suggLoc;
	}
	//(allDom , locCodeCurr, singleLotSl, itemLotOpt );
	public String checkDuplicate(Document allDom, String locCodeCurr, String singleLotSl, String itemLotOpt) throws ITMException
	{
		String itemCode ="", lotNo = "";
		NodeList parentNodeList = null;
		NodeList chldList = null;
		int parentNodeListLength ;
		Node childNode =null;
        String userId = "";
        String locationCode = "";
		NodeList parentList = null;
		NodeList childList = null;	
		int noOfChilds = 0;
		int noOfParent = 0;
		ArrayList itemList = null;
		ArrayList lotSlList = null;
		Set itemSet = null;
		Set lotSlSet = null;
		String errorCode = "";
		try 
		{
			//childList = parentList.item(0).getChildNodes();
			//noOfChilds = childList.getLength();			
			//NodeList chldList = null;
			//int parentNodeListLength;
			parentNodeList = allDom.getElementsByTagName("Detail3");
			parentNodeListLength = parentNodeList.getLength();
			System.out.println(" inside checkDuplicate: parentNodeListLength $$$ *****===>"+ parentNodeListLength);
			itemList = new ArrayList();
			lotSlList = new ArrayList();
			for (int row = 0; row < parentNodeListLength; row++) 
			{
				//Changed by sumit on 10/09/12 changin detail number				
				locationCode = checkNull(GenericUtility.getInstance().getColumnValueFromNode("loc_code__to", allDom.getElementsByTagName("Detail3").item(row)));
				System.out.println(" locationCode ["+locationCode+"] locCodeCurr ["+locCodeCurr+"]");
				if( locationCode.equalsIgnoreCase(locCodeCurr))
				{
					itemCode = checkNull(GenericUtility.getInstance().getColumnValueFromNode("item_code",allDom.getElementsByTagName("Detail3").item(row)));
					lotNo = checkNull(GenericUtility.getInstance().getColumnValueFromNode("lot_sl__fr",allDom.getElementsByTagName("Detail3").item(row)));
					itemList.add(itemCode);
					lotSlList.add(lotNo);					
				}			
			}
			
			//System.out.println(" itemList "+itemList+" lotSlList "+lotSlList+"");
			itemSet = new HashSet(itemList);
			lotSlSet = new HashSet(lotSlList);			
			if( "N".equalsIgnoreCase(singleLotSl) && "0".equalsIgnoreCase(itemLotOpt))
			{				
				if( itemSet.size() > 1 || lotSlSet.size() > 1)
				{					
					errorCode = "VTLOCCODE2";
				}
				
			}
			else if( "N".equalsIgnoreCase(singleLotSl) && "1".equalsIgnoreCase(itemLotOpt))
			{				
				if( itemSet.size() > 1 )
				{					
					errorCode = "VTLOCCODE4";
				}
			}
			else if( "Y".equalsIgnoreCase(singleLotSl))
			{				
				if( itemList.size() > 1 )
				{
					errorCode = "DUPRECORD";
				}
			}
			//System.out.println("Adding to LIst" + itemCode + "[Row"	+ row);
			
			
		} catch (Exception e) 
		{
			System.out.println(e);
			throw new ITMException(e);
		}
		return errorCode;
	}
}